 /*
 **************************************************************************************
 *
 * (c) Copyright 2014 Marvell International Ltd.
 *
 *
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/.
 *
 **************************************************************************************
 *
 * \file SATA_regstructs.h
 * Generated using RegBuild 1.6.3
 *
 **************************************************************************************
 */

#ifndef _SATA_REGSTRUCTS_H_
#define _SATA_REGSTRUCTS_H_

#ifndef __KERNEL__
#include <stdint.h>
#endif

//====================================================================
//
//Register File: SATA (SATA)
/** \brief Top-level register file for SATA<BR>
Note: Bus is actually AHB, but specified APB so can see example register RTL*/
//
//====================================================================

typedef struct SATA_REGS_s
{
  volatile uint32_t HBA_CAPABILITY;  ///< 0x0 [R]: HBA Capability
  volatile uint32_t GLOBAL_HBA_CTRL;  ///< 0x4 [R/W]: Global HBA Control
  volatile uint32_t INT_STATUS;  ///< 0x8 [R/W]: Interrupt Status
  volatile uint32_t PORTS_IMPLEMENTED;  ///< 0xc [R]: Ports Implemented
  volatile uint32_t AHCI_VERSION;  ///< 0x10 [R]: AHCI Version
  volatile uint32_t reserved0[35];
  volatile uint32_t VDR_SPECIFIC_ADDR;  ///< 0xa0 [R/W]: Vendor Specific Address
  volatile uint32_t VDR_SPECIFIC_DATA;  ///< 0xa4 [R/W]: Vendor Specific Data
  volatile uint32_t reserved1[22];
  volatile uint32_t CMD_LIST_BASE_ADDR_LOW_32B;  ///< 0x100 [R/W]: Command List Base Address Lower 32-bits
  volatile uint32_t CMD_LIST_BASE_ADDR_UPR_32B;  ///< 0x104 [R/W]: Command List Base Address Upper 32-bits
  volatile uint32_t RCVD_FIS_BASE_ADDR_LOW_32B;  ///< 0x108 [R/W]: Received FIS Base Address Lower 32-bits
  volatile uint32_t RCVD_FIS_BASE_ADDR_UPR_32B;  ///< 0x10c [R/W]: Received FIS Base Address Upper 32-bits
  volatile uint32_t PORT_INT_STATUS;  ///< 0x110 [R/W]: Port Interrupt Status
  volatile uint32_t PORT_INT_ENABLE;  ///< 0x114 [R/W]: Port Interrupt Enable
  volatile uint32_t PORT_CMD_AND_STATUS;  ///< 0x118 [R/W]: Port Command and Status
  volatile uint32_t reserved2;
  volatile uint32_t PORT_TASK_FILE_DATA;  ///< 0x120 [R]: Port Task File Data
  volatile uint32_t PORT_SIGNATURE;  ///< 0x124 [R]: Port Signature
  volatile uint32_t SSTATUS_SCR0;  ///< 0x128 [R]: SATA Status
  volatile uint32_t SCONTROL_SCR2;  ///< 0x12c [R/W]: SATA Control
  volatile uint32_t SERROR_SCR1;  ///< 0x130 [R/W]: Serial ATA Error
  volatile uint32_t SACTIVE_SCR3;  ///< 0x134 [R/W]: SATA Active
  volatile uint32_t CMD_ISSUE;  ///< 0x138 [R/W]: Command Issue
  volatile uint32_t SNOTIFICATION_SCR4;  ///< 0x13c [R/W]: Port Serial ATA Notification
  volatile uint32_t PORT_FIS_BASED_SWITCH_CTRL;  ///< 0x140 [R/W]: Port FIS Based Switching Control
  volatile uint32_t reserved3[11];
  volatile uint32_t PORT0_CMD_LBA_BASE_ADDR_LOW_32B;  ///< 0x170 [R/W]: Port 0 Command LBA Table Base Address Lower 32-bits
  volatile uint32_t VDR_SPECIFIED_INT_CTRL;  ///< 0x174 [R/W]: Vendor Specified Interrupt Control
  volatile uint32_t IND_ACCS_PORT_PHY_ADDR;  ///< 0x178 [R/W]: Indirect Access Port PHY Address
  volatile uint32_t IND_ACCS_PORT_PHY_DATA;  ///< 0x17c [R/W]: Indirect Access Port PHY Data
} SATA_REGS_t;

#endif // SATA
