 /*
 **************************************************************************************
 *
 * (c) Copyright 2014 Marvell International Ltd.
 *
 *
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/.
 *
 **************************************************************************************
 *
 * \file SATA_regmasks.h
 * Generated using RegBuild 1.6.3
 *
 **************************************************************************************
 */

#ifndef _SATA_REGMASKS_H_
#define _SATA_REGMASKS_H_

#ifndef __KERNEL__
#include <stdint.h>
#endif

//====================================================================
//
//Register File: SATA (SATA)
/** \brief Top-level register file for SATA<BR>
Note: Bus is actually AHB, but specified APB so can see example register RTL*/
//
//====================================================================

//====================================================================
//Register: HBA Capability (HBA_CAPABILITY)
//====================================================================

#define  SATA_HBA_CAPABILITY__64_ADRS_SPT_MASK 0x80000000
#define  SATA_HBA_CAPABILITY__64_ADRS_SPT_SHIFT 31
#define  SATA_HBA_CAPABILITY__64_ADRS_SPT_MASK_SHIFT(reg) (((reg) & SATA_HBA_CAPABILITY__64_ADRS_SPT_MASK) >> SATA_HBA_CAPABILITY__64_ADRS_SPT_SHIFT)
#define  SATA_HBA_CAPABILITY__64_ADRS_SPT_REPLACE_VAL(reg,val) (((reg) & ~SATA_HBA_CAPABILITY__64_ADRS_SPT_MASK) | (((uint32_t)val) << SATA_HBA_CAPABILITY__64_ADRS_SPT_SHIFT))

#define  SATA_HBA_CAPABILITY_NCQ_MASK 0x40000000
#define  SATA_HBA_CAPABILITY_NCQ_SHIFT 30
#define  SATA_HBA_CAPABILITY_NCQ_MASK_SHIFT(reg) (((reg) & SATA_HBA_CAPABILITY_NCQ_MASK) >> SATA_HBA_CAPABILITY_NCQ_SHIFT)
#define  SATA_HBA_CAPABILITY_NCQ_REPLACE_VAL(reg,val) (((reg) & ~SATA_HBA_CAPABILITY_NCQ_MASK) | (((uint32_t)val) << SATA_HBA_CAPABILITY_NCQ_SHIFT))

#define  SATA_HBA_CAPABILITY_SNOTIFY_MASK 0x20000000
#define  SATA_HBA_CAPABILITY_SNOTIFY_SHIFT 29
#define  SATA_HBA_CAPABILITY_SNOTIFY_MASK_SHIFT(reg) (((reg) & SATA_HBA_CAPABILITY_SNOTIFY_MASK) >> SATA_HBA_CAPABILITY_SNOTIFY_SHIFT)
#define  SATA_HBA_CAPABILITY_SNOTIFY_REPLACE_VAL(reg,val) (((reg) & ~SATA_HBA_CAPABILITY_SNOTIFY_MASK) | (((uint32_t)val) << SATA_HBA_CAPABILITY_SNOTIFY_SHIFT))

#define  SATA_HBA_CAPABILITY_MPS_MASK 0x10000000
#define  SATA_HBA_CAPABILITY_MPS_SHIFT 28
#define  SATA_HBA_CAPABILITY_MPS_MASK_SHIFT(reg) (((reg) & SATA_HBA_CAPABILITY_MPS_MASK) >> SATA_HBA_CAPABILITY_MPS_SHIFT)
#define  SATA_HBA_CAPABILITY_MPS_REPLACE_VAL(reg,val) (((reg) & ~SATA_HBA_CAPABILITY_MPS_MASK) | (((uint32_t)val) << SATA_HBA_CAPABILITY_MPS_SHIFT))

#define  SATA_HBA_CAPABILITY_SSU_MASK 0x8000000
#define  SATA_HBA_CAPABILITY_SSU_SHIFT 27
#define  SATA_HBA_CAPABILITY_SSU_MASK_SHIFT(reg) (((reg) & SATA_HBA_CAPABILITY_SSU_MASK) >> SATA_HBA_CAPABILITY_SSU_SHIFT)
#define  SATA_HBA_CAPABILITY_SSU_REPLACE_VAL(reg,val) (((reg) & ~SATA_HBA_CAPABILITY_SSU_MASK) | (((uint32_t)val) << SATA_HBA_CAPABILITY_SSU_SHIFT))

#define  SATA_HBA_CAPABILITY_ALPM_MASK 0x4000000
#define  SATA_HBA_CAPABILITY_ALPM_SHIFT 26
#define  SATA_HBA_CAPABILITY_ALPM_MASK_SHIFT(reg) (((reg) & SATA_HBA_CAPABILITY_ALPM_MASK) >> SATA_HBA_CAPABILITY_ALPM_SHIFT)
#define  SATA_HBA_CAPABILITY_ALPM_REPLACE_VAL(reg,val) (((reg) & ~SATA_HBA_CAPABILITY_ALPM_MASK) | (((uint32_t)val) << SATA_HBA_CAPABILITY_ALPM_SHIFT))

#define  SATA_HBA_CAPABILITY_DA_LED_MASK 0x2000000
#define  SATA_HBA_CAPABILITY_DA_LED_SHIFT 25
#define  SATA_HBA_CAPABILITY_DA_LED_MASK_SHIFT(reg) (((reg) & SATA_HBA_CAPABILITY_DA_LED_MASK) >> SATA_HBA_CAPABILITY_DA_LED_SHIFT)
#define  SATA_HBA_CAPABILITY_DA_LED_REPLACE_VAL(reg,val) (((reg) & ~SATA_HBA_CAPABILITY_DA_LED_MASK) | (((uint32_t)val) << SATA_HBA_CAPABILITY_DA_LED_SHIFT))

#define  SATA_HBA_CAPABILITY_CMD_LIST_OR_MASK 0x1000000
#define  SATA_HBA_CAPABILITY_CMD_LIST_OR_SHIFT 24
#define  SATA_HBA_CAPABILITY_CMD_LIST_OR_MASK_SHIFT(reg) (((reg) & SATA_HBA_CAPABILITY_CMD_LIST_OR_MASK) >> SATA_HBA_CAPABILITY_CMD_LIST_OR_SHIFT)
#define  SATA_HBA_CAPABILITY_CMD_LIST_OR_REPLACE_VAL(reg,val) (((reg) & ~SATA_HBA_CAPABILITY_CMD_LIST_OR_MASK) | (((uint32_t)val) << SATA_HBA_CAPABILITY_CMD_LIST_OR_SHIFT))

#define  SATA_HBA_CAPABILITY_INT_SATA_SPD_MASK 0xf00000
#define  SATA_HBA_CAPABILITY_INT_SATA_SPD_SHIFT 20
#define  SATA_HBA_CAPABILITY_INT_SATA_SPD_MASK_SHIFT(reg) (((reg) & SATA_HBA_CAPABILITY_INT_SATA_SPD_MASK) >> SATA_HBA_CAPABILITY_INT_SATA_SPD_SHIFT)
#define  SATA_HBA_CAPABILITY_INT_SATA_SPD_REPLACE_VAL(reg,val) (((reg) & ~SATA_HBA_CAPABILITY_INT_SATA_SPD_MASK) | (((uint32_t)val) << SATA_HBA_CAPABILITY_INT_SATA_SPD_SHIFT))

#define  SATA_HBA_CAPABILITY_RESERVED1_MASK 0x80000
#define  SATA_HBA_CAPABILITY_RESERVED1_SHIFT 19
#define  SATA_HBA_CAPABILITY_RESERVED1_MASK_SHIFT(reg) (((reg) & SATA_HBA_CAPABILITY_RESERVED1_MASK) >> SATA_HBA_CAPABILITY_RESERVED1_SHIFT)
#define  SATA_HBA_CAPABILITY_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SATA_HBA_CAPABILITY_RESERVED1_MASK) | (((uint32_t)val) << SATA_HBA_CAPABILITY_RESERVED1_SHIFT))

#define  SATA_HBA_CAPABILITY_AHCI_ONLY_MASK 0x40000
#define  SATA_HBA_CAPABILITY_AHCI_ONLY_SHIFT 18
#define  SATA_HBA_CAPABILITY_AHCI_ONLY_MASK_SHIFT(reg) (((reg) & SATA_HBA_CAPABILITY_AHCI_ONLY_MASK) >> SATA_HBA_CAPABILITY_AHCI_ONLY_SHIFT)
#define  SATA_HBA_CAPABILITY_AHCI_ONLY_REPLACE_VAL(reg,val) (((reg) & ~SATA_HBA_CAPABILITY_AHCI_ONLY_MASK) | (((uint32_t)val) << SATA_HBA_CAPABILITY_AHCI_ONLY_SHIFT))

#define  SATA_HBA_CAPABILITY_PM_MASK 0x20000
#define  SATA_HBA_CAPABILITY_PM_SHIFT 17
#define  SATA_HBA_CAPABILITY_PM_MASK_SHIFT(reg) (((reg) & SATA_HBA_CAPABILITY_PM_MASK) >> SATA_HBA_CAPABILITY_PM_SHIFT)
#define  SATA_HBA_CAPABILITY_PM_REPLACE_VAL(reg,val) (((reg) & ~SATA_HBA_CAPABILITY_PM_MASK) | (((uint32_t)val) << SATA_HBA_CAPABILITY_PM_SHIFT))

#define  SATA_HBA_CAPABILITY_FIS_SW_MASK 0x10000
#define  SATA_HBA_CAPABILITY_FIS_SW_SHIFT 16
#define  SATA_HBA_CAPABILITY_FIS_SW_MASK_SHIFT(reg) (((reg) & SATA_HBA_CAPABILITY_FIS_SW_MASK) >> SATA_HBA_CAPABILITY_FIS_SW_SHIFT)
#define  SATA_HBA_CAPABILITY_FIS_SW_REPLACE_VAL(reg,val) (((reg) & ~SATA_HBA_CAPABILITY_FIS_SW_MASK) | (((uint32_t)val) << SATA_HBA_CAPABILITY_FIS_SW_SHIFT))

#define  SATA_HBA_CAPABILITY_PIO_MULT_DRQ_BLK_MASK 0x8000
#define  SATA_HBA_CAPABILITY_PIO_MULT_DRQ_BLK_SHIFT 15
#define  SATA_HBA_CAPABILITY_PIO_MULT_DRQ_BLK_MASK_SHIFT(reg) (((reg) & SATA_HBA_CAPABILITY_PIO_MULT_DRQ_BLK_MASK) >> SATA_HBA_CAPABILITY_PIO_MULT_DRQ_BLK_SHIFT)
#define  SATA_HBA_CAPABILITY_PIO_MULT_DRQ_BLK_REPLACE_VAL(reg,val) (((reg) & ~SATA_HBA_CAPABILITY_PIO_MULT_DRQ_BLK_MASK) | (((uint32_t)val) << SATA_HBA_CAPABILITY_PIO_MULT_DRQ_BLK_SHIFT))

#define  SATA_HBA_CAPABILITY_TRANS_SS_MASK 0x4000
#define  SATA_HBA_CAPABILITY_TRANS_SS_SHIFT 14
#define  SATA_HBA_CAPABILITY_TRANS_SS_MASK_SHIFT(reg) (((reg) & SATA_HBA_CAPABILITY_TRANS_SS_MASK) >> SATA_HBA_CAPABILITY_TRANS_SS_SHIFT)
#define  SATA_HBA_CAPABILITY_TRANS_SS_REPLACE_VAL(reg,val) (((reg) & ~SATA_HBA_CAPABILITY_TRANS_SS_MASK) | (((uint32_t)val) << SATA_HBA_CAPABILITY_TRANS_SS_SHIFT))

#define  SATA_HBA_CAPABILITY_TRANS_PS_MASK 0x2000
#define  SATA_HBA_CAPABILITY_TRANS_PS_SHIFT 13
#define  SATA_HBA_CAPABILITY_TRANS_PS_MASK_SHIFT(reg) (((reg) & SATA_HBA_CAPABILITY_TRANS_PS_MASK) >> SATA_HBA_CAPABILITY_TRANS_PS_SHIFT)
#define  SATA_HBA_CAPABILITY_TRANS_PS_REPLACE_VAL(reg,val) (((reg) & ~SATA_HBA_CAPABILITY_TRANS_PS_MASK) | (((uint32_t)val) << SATA_HBA_CAPABILITY_TRANS_PS_SHIFT))

#define  SATA_HBA_CAPABILITY_CTRL_MASK 0x1f00
#define  SATA_HBA_CAPABILITY_CTRL_SHIFT 8
#define  SATA_HBA_CAPABILITY_CTRL_MASK_SHIFT(reg) (((reg) & SATA_HBA_CAPABILITY_CTRL_MASK) >> SATA_HBA_CAPABILITY_CTRL_SHIFT)
#define  SATA_HBA_CAPABILITY_CTRL_REPLACE_VAL(reg,val) (((reg) & ~SATA_HBA_CAPABILITY_CTRL_MASK) | (((uint32_t)val) << SATA_HBA_CAPABILITY_CTRL_SHIFT))

#define  SATA_HBA_CAPABILITY_CMD_CMPLT_CS_MASK 0x80
#define  SATA_HBA_CAPABILITY_CMD_CMPLT_CS_SHIFT 7
#define  SATA_HBA_CAPABILITY_CMD_CMPLT_CS_MASK_SHIFT(reg) (((reg) & SATA_HBA_CAPABILITY_CMD_CMPLT_CS_MASK) >> SATA_HBA_CAPABILITY_CMD_CMPLT_CS_SHIFT)
#define  SATA_HBA_CAPABILITY_CMD_CMPLT_CS_REPLACE_VAL(reg,val) (((reg) & ~SATA_HBA_CAPABILITY_CMD_CMPLT_CS_MASK) | (((uint32_t)val) << SATA_HBA_CAPABILITY_CMD_CMPLT_CS_SHIFT))

#define  SATA_HBA_CAPABILITY_EMS_MASK 0x40
#define  SATA_HBA_CAPABILITY_EMS_SHIFT 6
#define  SATA_HBA_CAPABILITY_EMS_MASK_SHIFT(reg) (((reg) & SATA_HBA_CAPABILITY_EMS_MASK) >> SATA_HBA_CAPABILITY_EMS_SHIFT)
#define  SATA_HBA_CAPABILITY_EMS_REPLACE_VAL(reg,val) (((reg) & ~SATA_HBA_CAPABILITY_EMS_MASK) | (((uint32_t)val) << SATA_HBA_CAPABILITY_EMS_SHIFT))

#define  SATA_HBA_CAPABILITY_EXT_SATA_MASK 0x20
#define  SATA_HBA_CAPABILITY_EXT_SATA_SHIFT 5
#define  SATA_HBA_CAPABILITY_EXT_SATA_MASK_SHIFT(reg) (((reg) & SATA_HBA_CAPABILITY_EXT_SATA_MASK) >> SATA_HBA_CAPABILITY_EXT_SATA_SHIFT)
#define  SATA_HBA_CAPABILITY_EXT_SATA_REPLACE_VAL(reg,val) (((reg) & ~SATA_HBA_CAPABILITY_EXT_SATA_MASK) | (((uint32_t)val) << SATA_HBA_CAPABILITY_EXT_SATA_SHIFT))

#define  SATA_HBA_CAPABILITY_PORTS_MASK 0x1f
#define  SATA_HBA_CAPABILITY_PORTS_SHIFT 0
#define  SATA_HBA_CAPABILITY_PORTS_MASK_SHIFT(reg) (((reg) & SATA_HBA_CAPABILITY_PORTS_MASK) >> SATA_HBA_CAPABILITY_PORTS_SHIFT)
#define  SATA_HBA_CAPABILITY_PORTS_REPLACE_VAL(reg,val) (((reg) & ~SATA_HBA_CAPABILITY_PORTS_MASK) | (((uint32_t)val) << SATA_HBA_CAPABILITY_PORTS_SHIFT))

//====================================================================
//Register: Global HBA Control (GLOBAL_HBA_CTRL)
//====================================================================

#define  SATA_GLOBAL_HBA_CTRL_AHCI_EN_MASK 0x80000000
#define  SATA_GLOBAL_HBA_CTRL_AHCI_EN_SHIFT 31
#define  SATA_GLOBAL_HBA_CTRL_AHCI_EN_MASK_SHIFT(reg) (((reg) & SATA_GLOBAL_HBA_CTRL_AHCI_EN_MASK) >> SATA_GLOBAL_HBA_CTRL_AHCI_EN_SHIFT)
#define  SATA_GLOBAL_HBA_CTRL_AHCI_EN_REPLACE_VAL(reg,val) (((reg) & ~SATA_GLOBAL_HBA_CTRL_AHCI_EN_MASK) | (((uint32_t)val) << SATA_GLOBAL_HBA_CTRL_AHCI_EN_SHIFT))

#define  SATA_GLOBAL_HBA_CTRL_RESERVED1_MASK 0x7ffffff8
#define  SATA_GLOBAL_HBA_CTRL_RESERVED1_SHIFT 3
#define  SATA_GLOBAL_HBA_CTRL_RESERVED1_MASK_SHIFT(reg) (((reg) & SATA_GLOBAL_HBA_CTRL_RESERVED1_MASK) >> SATA_GLOBAL_HBA_CTRL_RESERVED1_SHIFT)
#define  SATA_GLOBAL_HBA_CTRL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SATA_GLOBAL_HBA_CTRL_RESERVED1_MASK) | (((uint32_t)val) << SATA_GLOBAL_HBA_CTRL_RESERVED1_SHIFT))

#define  SATA_GLOBAL_HBA_CTRL_MSI_RSM_MASK 0x4
#define  SATA_GLOBAL_HBA_CTRL_MSI_RSM_SHIFT 2
#define  SATA_GLOBAL_HBA_CTRL_MSI_RSM_MASK_SHIFT(reg) (((reg) & SATA_GLOBAL_HBA_CTRL_MSI_RSM_MASK) >> SATA_GLOBAL_HBA_CTRL_MSI_RSM_SHIFT)
#define  SATA_GLOBAL_HBA_CTRL_MSI_RSM_REPLACE_VAL(reg,val) (((reg) & ~SATA_GLOBAL_HBA_CTRL_MSI_RSM_MASK) | (((uint32_t)val) << SATA_GLOBAL_HBA_CTRL_MSI_RSM_SHIFT))

#define  SATA_GLOBAL_HBA_CTRL_INT_EN_MASK 0x2
#define  SATA_GLOBAL_HBA_CTRL_INT_EN_SHIFT 1
#define  SATA_GLOBAL_HBA_CTRL_INT_EN_MASK_SHIFT(reg) (((reg) & SATA_GLOBAL_HBA_CTRL_INT_EN_MASK) >> SATA_GLOBAL_HBA_CTRL_INT_EN_SHIFT)
#define  SATA_GLOBAL_HBA_CTRL_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~SATA_GLOBAL_HBA_CTRL_INT_EN_MASK) | (((uint32_t)val) << SATA_GLOBAL_HBA_CTRL_INT_EN_SHIFT))

#define  SATA_GLOBAL_HBA_CTRL_HBA_RST_MASK 0x1
#define  SATA_GLOBAL_HBA_CTRL_HBA_RST_SHIFT 0
#define  SATA_GLOBAL_HBA_CTRL_HBA_RST_MASK_SHIFT(reg) (((reg) & SATA_GLOBAL_HBA_CTRL_HBA_RST_MASK) >> SATA_GLOBAL_HBA_CTRL_HBA_RST_SHIFT)
#define  SATA_GLOBAL_HBA_CTRL_HBA_RST_REPLACE_VAL(reg,val) (((reg) & ~SATA_GLOBAL_HBA_CTRL_HBA_RST_MASK) | (((uint32_t)val) << SATA_GLOBAL_HBA_CTRL_HBA_RST_SHIFT))

//====================================================================
//Register: Interrupt Status (INT_STATUS)
//====================================================================

#define  SATA_INT_STATUS_RESERVED1_MASK 0xfffffffe
#define  SATA_INT_STATUS_RESERVED1_SHIFT 1
#define  SATA_INT_STATUS_RESERVED1_MASK_SHIFT(reg) (((reg) & SATA_INT_STATUS_RESERVED1_MASK) >> SATA_INT_STATUS_RESERVED1_SHIFT)
#define  SATA_INT_STATUS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SATA_INT_STATUS_RESERVED1_MASK) | (((uint32_t)val) << SATA_INT_STATUS_RESERVED1_SHIFT))

#define  SATA_INT_STATUS_PORT_INT_ST_MASK 0x1
#define  SATA_INT_STATUS_PORT_INT_ST_SHIFT 0
#define  SATA_INT_STATUS_PORT_INT_ST_MASK_SHIFT(reg) (((reg) & SATA_INT_STATUS_PORT_INT_ST_MASK) >> SATA_INT_STATUS_PORT_INT_ST_SHIFT)
#define  SATA_INT_STATUS_PORT_INT_ST_REPLACE_VAL(reg,val) (((reg) & ~SATA_INT_STATUS_PORT_INT_ST_MASK) | (((uint32_t)val) << SATA_INT_STATUS_PORT_INT_ST_SHIFT))

//====================================================================
//Register: Ports Implemented (PORTS_IMPLEMENTED)
//====================================================================

#define  SATA_PORTS_IMPLEMENTED_RESERVED1_MASK 0xfffffffc
#define  SATA_PORTS_IMPLEMENTED_RESERVED1_SHIFT 2
#define  SATA_PORTS_IMPLEMENTED_RESERVED1_MASK_SHIFT(reg) (((reg) & SATA_PORTS_IMPLEMENTED_RESERVED1_MASK) >> SATA_PORTS_IMPLEMENTED_RESERVED1_SHIFT)
#define  SATA_PORTS_IMPLEMENTED_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SATA_PORTS_IMPLEMENTED_RESERVED1_MASK) | (((uint32_t)val) << SATA_PORTS_IMPLEMENTED_RESERVED1_SHIFT))

#define  SATA_PORTS_IMPLEMENTED_PORTS_IMP_MASK 0x3
#define  SATA_PORTS_IMPLEMENTED_PORTS_IMP_SHIFT 0
#define  SATA_PORTS_IMPLEMENTED_PORTS_IMP_MASK_SHIFT(reg) (((reg) & SATA_PORTS_IMPLEMENTED_PORTS_IMP_MASK) >> SATA_PORTS_IMPLEMENTED_PORTS_IMP_SHIFT)
#define  SATA_PORTS_IMPLEMENTED_PORTS_IMP_REPLACE_VAL(reg,val) (((reg) & ~SATA_PORTS_IMPLEMENTED_PORTS_IMP_MASK) | (((uint32_t)val) << SATA_PORTS_IMPLEMENTED_PORTS_IMP_SHIFT))

//====================================================================
//Register: AHCI Version (AHCI_VERSION)
//====================================================================

#define  SATA_AHCI_VERSION_AHCI_VER_MASK 0xffffffff
#define  SATA_AHCI_VERSION_AHCI_VER_SHIFT 0
#define  SATA_AHCI_VERSION_AHCI_VER_MASK_SHIFT(reg) (((reg) & SATA_AHCI_VERSION_AHCI_VER_MASK) >> SATA_AHCI_VERSION_AHCI_VER_SHIFT)
#define  SATA_AHCI_VERSION_AHCI_VER_REPLACE_VAL(reg,val) (((reg) & ~SATA_AHCI_VERSION_AHCI_VER_MASK) | (((uint32_t)val) << SATA_AHCI_VERSION_AHCI_VER_SHIFT))

//====================================================================
//Register: Vendor Specific Address (VDR_SPECIFIC_ADDR)
//====================================================================

#define  SATA_VDR_SPECIFIC_ADDR_VS_ADDR_0_MASK 0xffffffff
#define  SATA_VDR_SPECIFIC_ADDR_VS_ADDR_0_SHIFT 0
#define  SATA_VDR_SPECIFIC_ADDR_VS_ADDR_0_MASK_SHIFT(reg) (((reg) & SATA_VDR_SPECIFIC_ADDR_VS_ADDR_0_MASK) >> SATA_VDR_SPECIFIC_ADDR_VS_ADDR_0_SHIFT)
#define  SATA_VDR_SPECIFIC_ADDR_VS_ADDR_0_REPLACE_VAL(reg,val) (((reg) & ~SATA_VDR_SPECIFIC_ADDR_VS_ADDR_0_MASK) | (((uint32_t)val) << SATA_VDR_SPECIFIC_ADDR_VS_ADDR_0_SHIFT))

//====================================================================
//Register: Vendor Specific Data (VDR_SPECIFIC_DATA)
//====================================================================

#define  SATA_VDR_SPECIFIC_DATA_VS_DATA_0_MASK 0xffffffff
#define  SATA_VDR_SPECIFIC_DATA_VS_DATA_0_SHIFT 0
#define  SATA_VDR_SPECIFIC_DATA_VS_DATA_0_MASK_SHIFT(reg) (((reg) & SATA_VDR_SPECIFIC_DATA_VS_DATA_0_MASK) >> SATA_VDR_SPECIFIC_DATA_VS_DATA_0_SHIFT)
#define  SATA_VDR_SPECIFIC_DATA_VS_DATA_0_REPLACE_VAL(reg,val) (((reg) & ~SATA_VDR_SPECIFIC_DATA_VS_DATA_0_MASK) | (((uint32_t)val) << SATA_VDR_SPECIFIC_DATA_VS_DATA_0_SHIFT))

//====================================================================
//Register: Command List Base Address Lower 32-bits (CMD_LIST_BASE_ADDR_LOW_32B)
//====================================================================

#define  SATA_CMD_LIST_BASE_ADDR_LOW_32B_CMD_LIST_BASE_ADDR_L_31_10_MASK 0xfffffc00
#define  SATA_CMD_LIST_BASE_ADDR_LOW_32B_CMD_LIST_BASE_ADDR_L_31_10_SHIFT 10
#define  SATA_CMD_LIST_BASE_ADDR_LOW_32B_CMD_LIST_BASE_ADDR_L_31_10_MASK_SHIFT(reg) (((reg) & SATA_CMD_LIST_BASE_ADDR_LOW_32B_CMD_LIST_BASE_ADDR_L_31_10_MASK) >> SATA_CMD_LIST_BASE_ADDR_LOW_32B_CMD_LIST_BASE_ADDR_L_31_10_SHIFT)
#define  SATA_CMD_LIST_BASE_ADDR_LOW_32B_CMD_LIST_BASE_ADDR_L_31_10_REPLACE_VAL(reg,val) (((reg) & ~SATA_CMD_LIST_BASE_ADDR_LOW_32B_CMD_LIST_BASE_ADDR_L_31_10_MASK) | (((uint32_t)val) << SATA_CMD_LIST_BASE_ADDR_LOW_32B_CMD_LIST_BASE_ADDR_L_31_10_SHIFT))

#define  SATA_CMD_LIST_BASE_ADDR_LOW_32B_RESERVED1_MASK 0x3fe
#define  SATA_CMD_LIST_BASE_ADDR_LOW_32B_RESERVED1_SHIFT 1
#define  SATA_CMD_LIST_BASE_ADDR_LOW_32B_RESERVED1_MASK_SHIFT(reg) (((reg) & SATA_CMD_LIST_BASE_ADDR_LOW_32B_RESERVED1_MASK) >> SATA_CMD_LIST_BASE_ADDR_LOW_32B_RESERVED1_SHIFT)
#define  SATA_CMD_LIST_BASE_ADDR_LOW_32B_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SATA_CMD_LIST_BASE_ADDR_LOW_32B_RESERVED1_MASK) | (((uint32_t)val) << SATA_CMD_LIST_BASE_ADDR_LOW_32B_RESERVED1_SHIFT))

#define  SATA_CMD_LIST_BASE_ADDR_LOW_32B_CMD_LIST_BASE_ADDR_L_0_MASK 0x1
#define  SATA_CMD_LIST_BASE_ADDR_LOW_32B_CMD_LIST_BASE_ADDR_L_0_SHIFT 0
#define  SATA_CMD_LIST_BASE_ADDR_LOW_32B_CMD_LIST_BASE_ADDR_L_0_MASK_SHIFT(reg) (((reg) & SATA_CMD_LIST_BASE_ADDR_LOW_32B_CMD_LIST_BASE_ADDR_L_0_MASK) >> SATA_CMD_LIST_BASE_ADDR_LOW_32B_CMD_LIST_BASE_ADDR_L_0_SHIFT)
#define  SATA_CMD_LIST_BASE_ADDR_LOW_32B_CMD_LIST_BASE_ADDR_L_0_REPLACE_VAL(reg,val) (((reg) & ~SATA_CMD_LIST_BASE_ADDR_LOW_32B_CMD_LIST_BASE_ADDR_L_0_MASK) | (((uint32_t)val) << SATA_CMD_LIST_BASE_ADDR_LOW_32B_CMD_LIST_BASE_ADDR_L_0_SHIFT))

//====================================================================
//Register: Command List Base Address Upper 32-bits (CMD_LIST_BASE_ADDR_UPR_32B)
//====================================================================

#define  SATA_CMD_LIST_BASE_ADDR_UPR_32B_CMD_LIST_BASE_ADDR_H_MASK 0xffffffff
#define  SATA_CMD_LIST_BASE_ADDR_UPR_32B_CMD_LIST_BASE_ADDR_H_SHIFT 0
#define  SATA_CMD_LIST_BASE_ADDR_UPR_32B_CMD_LIST_BASE_ADDR_H_MASK_SHIFT(reg) (((reg) & SATA_CMD_LIST_BASE_ADDR_UPR_32B_CMD_LIST_BASE_ADDR_H_MASK) >> SATA_CMD_LIST_BASE_ADDR_UPR_32B_CMD_LIST_BASE_ADDR_H_SHIFT)
#define  SATA_CMD_LIST_BASE_ADDR_UPR_32B_CMD_LIST_BASE_ADDR_H_REPLACE_VAL(reg,val) (((reg) & ~SATA_CMD_LIST_BASE_ADDR_UPR_32B_CMD_LIST_BASE_ADDR_H_MASK) | (((uint32_t)val) << SATA_CMD_LIST_BASE_ADDR_UPR_32B_CMD_LIST_BASE_ADDR_H_SHIFT))

//====================================================================
//Register: Received FIS Base Address Lower 32-bits (RCVD_FIS_BASE_ADDR_LOW_32B)
//====================================================================

#define  SATA_RCVD_FIS_BASE_ADDR_LOW_32B_FIS_BASE_ADDR_L_MASK 0xffffff00
#define  SATA_RCVD_FIS_BASE_ADDR_LOW_32B_FIS_BASE_ADDR_L_SHIFT 8
#define  SATA_RCVD_FIS_BASE_ADDR_LOW_32B_FIS_BASE_ADDR_L_MASK_SHIFT(reg) (((reg) & SATA_RCVD_FIS_BASE_ADDR_LOW_32B_FIS_BASE_ADDR_L_MASK) >> SATA_RCVD_FIS_BASE_ADDR_LOW_32B_FIS_BASE_ADDR_L_SHIFT)
#define  SATA_RCVD_FIS_BASE_ADDR_LOW_32B_FIS_BASE_ADDR_L_REPLACE_VAL(reg,val) (((reg) & ~SATA_RCVD_FIS_BASE_ADDR_LOW_32B_FIS_BASE_ADDR_L_MASK) | (((uint32_t)val) << SATA_RCVD_FIS_BASE_ADDR_LOW_32B_FIS_BASE_ADDR_L_SHIFT))

#define  SATA_RCVD_FIS_BASE_ADDR_LOW_32B_RESERVED1_MASK 0xff
#define  SATA_RCVD_FIS_BASE_ADDR_LOW_32B_RESERVED1_SHIFT 0
#define  SATA_RCVD_FIS_BASE_ADDR_LOW_32B_RESERVED1_MASK_SHIFT(reg) (((reg) & SATA_RCVD_FIS_BASE_ADDR_LOW_32B_RESERVED1_MASK) >> SATA_RCVD_FIS_BASE_ADDR_LOW_32B_RESERVED1_SHIFT)
#define  SATA_RCVD_FIS_BASE_ADDR_LOW_32B_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SATA_RCVD_FIS_BASE_ADDR_LOW_32B_RESERVED1_MASK) | (((uint32_t)val) << SATA_RCVD_FIS_BASE_ADDR_LOW_32B_RESERVED1_SHIFT))

//====================================================================
//Register: Received FIS Base Address Upper 32-bits (RCVD_FIS_BASE_ADDR_UPR_32B)
//====================================================================

#define  SATA_RCVD_FIS_BASE_ADDR_UPR_32B_FIS_BASE_ADDR_H_MASK 0xffffffff
#define  SATA_RCVD_FIS_BASE_ADDR_UPR_32B_FIS_BASE_ADDR_H_SHIFT 0
#define  SATA_RCVD_FIS_BASE_ADDR_UPR_32B_FIS_BASE_ADDR_H_MASK_SHIFT(reg) (((reg) & SATA_RCVD_FIS_BASE_ADDR_UPR_32B_FIS_BASE_ADDR_H_MASK) >> SATA_RCVD_FIS_BASE_ADDR_UPR_32B_FIS_BASE_ADDR_H_SHIFT)
#define  SATA_RCVD_FIS_BASE_ADDR_UPR_32B_FIS_BASE_ADDR_H_REPLACE_VAL(reg,val) (((reg) & ~SATA_RCVD_FIS_BASE_ADDR_UPR_32B_FIS_BASE_ADDR_H_MASK) | (((uint32_t)val) << SATA_RCVD_FIS_BASE_ADDR_UPR_32B_FIS_BASE_ADDR_H_SHIFT))

//====================================================================
//Register: Port Interrupt Status (PORT_INT_STATUS)
//====================================================================

#define  SATA_PORT_INT_STATUS_CPD_ST_MASK 0x80000000
#define  SATA_PORT_INT_STATUS_CPD_ST_SHIFT 31
#define  SATA_PORT_INT_STATUS_CPD_ST_MASK_SHIFT(reg) (((reg) & SATA_PORT_INT_STATUS_CPD_ST_MASK) >> SATA_PORT_INT_STATUS_CPD_ST_SHIFT)
#define  SATA_PORT_INT_STATUS_CPD_ST_REPLACE_VAL(reg,val) (((reg) & ~SATA_PORT_INT_STATUS_CPD_ST_MASK) | (((uint32_t)val) << SATA_PORT_INT_STATUS_CPD_ST_SHIFT))

#define  SATA_PORT_INT_STATUS_TF_ERR_ST_MASK 0x40000000
#define  SATA_PORT_INT_STATUS_TF_ERR_ST_SHIFT 30
#define  SATA_PORT_INT_STATUS_TF_ERR_ST_MASK_SHIFT(reg) (((reg) & SATA_PORT_INT_STATUS_TF_ERR_ST_MASK) >> SATA_PORT_INT_STATUS_TF_ERR_ST_SHIFT)
#define  SATA_PORT_INT_STATUS_TF_ERR_ST_REPLACE_VAL(reg,val) (((reg) & ~SATA_PORT_INT_STATUS_TF_ERR_ST_MASK) | (((uint32_t)val) << SATA_PORT_INT_STATUS_TF_ERR_ST_SHIFT))

#define  SATA_PORT_INT_STATUS_HOST_BUS_FE_ST_MASK 0x20000000
#define  SATA_PORT_INT_STATUS_HOST_BUS_FE_ST_SHIFT 29
#define  SATA_PORT_INT_STATUS_HOST_BUS_FE_ST_MASK_SHIFT(reg) (((reg) & SATA_PORT_INT_STATUS_HOST_BUS_FE_ST_MASK) >> SATA_PORT_INT_STATUS_HOST_BUS_FE_ST_SHIFT)
#define  SATA_PORT_INT_STATUS_HOST_BUS_FE_ST_REPLACE_VAL(reg,val) (((reg) & ~SATA_PORT_INT_STATUS_HOST_BUS_FE_ST_MASK) | (((uint32_t)val) << SATA_PORT_INT_STATUS_HOST_BUS_FE_ST_SHIFT))

#define  SATA_PORT_INT_STATUS_HOST_BUS_DE_ST_MASK 0x10000000
#define  SATA_PORT_INT_STATUS_HOST_BUS_DE_ST_SHIFT 28
#define  SATA_PORT_INT_STATUS_HOST_BUS_DE_ST_MASK_SHIFT(reg) (((reg) & SATA_PORT_INT_STATUS_HOST_BUS_DE_ST_MASK) >> SATA_PORT_INT_STATUS_HOST_BUS_DE_ST_SHIFT)
#define  SATA_PORT_INT_STATUS_HOST_BUS_DE_ST_REPLACE_VAL(reg,val) (((reg) & ~SATA_PORT_INT_STATUS_HOST_BUS_DE_ST_MASK) | (((uint32_t)val) << SATA_PORT_INT_STATUS_HOST_BUS_DE_ST_SHIFT))

#define  SATA_PORT_INT_STATUS_INTFC_FE_ST_MASK 0x8000000
#define  SATA_PORT_INT_STATUS_INTFC_FE_ST_SHIFT 27
#define  SATA_PORT_INT_STATUS_INTFC_FE_ST_MASK_SHIFT(reg) (((reg) & SATA_PORT_INT_STATUS_INTFC_FE_ST_MASK) >> SATA_PORT_INT_STATUS_INTFC_FE_ST_SHIFT)
#define  SATA_PORT_INT_STATUS_INTFC_FE_ST_REPLACE_VAL(reg,val) (((reg) & ~SATA_PORT_INT_STATUS_INTFC_FE_ST_MASK) | (((uint32_t)val) << SATA_PORT_INT_STATUS_INTFC_FE_ST_SHIFT))

#define  SATA_PORT_INT_STATUS_INTFC_NFE_ST_MASK 0x4000000
#define  SATA_PORT_INT_STATUS_INTFC_NFE_ST_SHIFT 26
#define  SATA_PORT_INT_STATUS_INTFC_NFE_ST_MASK_SHIFT(reg) (((reg) & SATA_PORT_INT_STATUS_INTFC_NFE_ST_MASK) >> SATA_PORT_INT_STATUS_INTFC_NFE_ST_SHIFT)
#define  SATA_PORT_INT_STATUS_INTFC_NFE_ST_REPLACE_VAL(reg,val) (((reg) & ~SATA_PORT_INT_STATUS_INTFC_NFE_ST_MASK) | (((uint32_t)val) << SATA_PORT_INT_STATUS_INTFC_NFE_ST_SHIFT))

#define  SATA_PORT_INT_STATUS_RESERVED1_MASK 0x2000000
#define  SATA_PORT_INT_STATUS_RESERVED1_SHIFT 25
#define  SATA_PORT_INT_STATUS_RESERVED1_MASK_SHIFT(reg) (((reg) & SATA_PORT_INT_STATUS_RESERVED1_MASK) >> SATA_PORT_INT_STATUS_RESERVED1_SHIFT)
#define  SATA_PORT_INT_STATUS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SATA_PORT_INT_STATUS_RESERVED1_MASK) | (((uint32_t)val) << SATA_PORT_INT_STATUS_RESERVED1_SHIFT))

#define  SATA_PORT_INT_STATUS_OFLOW_ST_MASK 0x1000000
#define  SATA_PORT_INT_STATUS_OFLOW_ST_SHIFT 24
#define  SATA_PORT_INT_STATUS_OFLOW_ST_MASK_SHIFT(reg) (((reg) & SATA_PORT_INT_STATUS_OFLOW_ST_MASK) >> SATA_PORT_INT_STATUS_OFLOW_ST_SHIFT)
#define  SATA_PORT_INT_STATUS_OFLOW_ST_REPLACE_VAL(reg,val) (((reg) & ~SATA_PORT_INT_STATUS_OFLOW_ST_MASK) | (((uint32_t)val) << SATA_PORT_INT_STATUS_OFLOW_ST_SHIFT))

#define  SATA_PORT_INT_STATUS_IPM_ST_MASK 0x800000
#define  SATA_PORT_INT_STATUS_IPM_ST_SHIFT 23
#define  SATA_PORT_INT_STATUS_IPM_ST_MASK_SHIFT(reg) (((reg) & SATA_PORT_INT_STATUS_IPM_ST_MASK) >> SATA_PORT_INT_STATUS_IPM_ST_SHIFT)
#define  SATA_PORT_INT_STATUS_IPM_ST_REPLACE_VAL(reg,val) (((reg) & ~SATA_PORT_INT_STATUS_IPM_ST_MASK) | (((uint32_t)val) << SATA_PORT_INT_STATUS_IPM_ST_SHIFT))

#define  SATA_PORT_INT_STATUS_PHYRDY_CH_ST_MASK 0x400000
#define  SATA_PORT_INT_STATUS_PHYRDY_CH_ST_SHIFT 22
#define  SATA_PORT_INT_STATUS_PHYRDY_CH_ST_MASK_SHIFT(reg) (((reg) & SATA_PORT_INT_STATUS_PHYRDY_CH_ST_MASK) >> SATA_PORT_INT_STATUS_PHYRDY_CH_ST_SHIFT)
#define  SATA_PORT_INT_STATUS_PHYRDY_CH_ST_REPLACE_VAL(reg,val) (((reg) & ~SATA_PORT_INT_STATUS_PHYRDY_CH_ST_MASK) | (((uint32_t)val) << SATA_PORT_INT_STATUS_PHYRDY_CH_ST_SHIFT))

#define  SATA_PORT_INT_STATUS_RESERVED2_MASK 0x300000
#define  SATA_PORT_INT_STATUS_RESERVED2_SHIFT 20
#define  SATA_PORT_INT_STATUS_RESERVED2_MASK_SHIFT(reg) (((reg) & SATA_PORT_INT_STATUS_RESERVED2_MASK) >> SATA_PORT_INT_STATUS_RESERVED2_SHIFT)
#define  SATA_PORT_INT_STATUS_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SATA_PORT_INT_STATUS_RESERVED2_MASK) | (((uint32_t)val) << SATA_PORT_INT_STATUS_RESERVED2_SHIFT))

#define  SATA_PORT_INT_STATUS_RCV_SIG_FIS_INT_MASK 0x80000
#define  SATA_PORT_INT_STATUS_RCV_SIG_FIS_INT_SHIFT 19
#define  SATA_PORT_INT_STATUS_RCV_SIG_FIS_INT_MASK_SHIFT(reg) (((reg) & SATA_PORT_INT_STATUS_RCV_SIG_FIS_INT_MASK) >> SATA_PORT_INT_STATUS_RCV_SIG_FIS_INT_SHIFT)
#define  SATA_PORT_INT_STATUS_RCV_SIG_FIS_INT_REPLACE_VAL(reg,val) (((reg) & ~SATA_PORT_INT_STATUS_RCV_SIG_FIS_INT_MASK) | (((uint32_t)val) << SATA_PORT_INT_STATUS_RCV_SIG_FIS_INT_SHIFT))

#define  SATA_PORT_INT_STATUS_WAKE_PWR_SV_INT_MASK 0x40000
#define  SATA_PORT_INT_STATUS_WAKE_PWR_SV_INT_SHIFT 18
#define  SATA_PORT_INT_STATUS_WAKE_PWR_SV_INT_MASK_SHIFT(reg) (((reg) & SATA_PORT_INT_STATUS_WAKE_PWR_SV_INT_MASK) >> SATA_PORT_INT_STATUS_WAKE_PWR_SV_INT_SHIFT)
#define  SATA_PORT_INT_STATUS_WAKE_PWR_SV_INT_REPLACE_VAL(reg,val) (((reg) & ~SATA_PORT_INT_STATUS_WAKE_PWR_SV_INT_MASK) | (((uint32_t)val) << SATA_PORT_INT_STATUS_WAKE_PWR_SV_INT_SHIFT))

#define  SATA_PORT_INT_STATUS_ENTER_PPS_INT_MASK 0x20000
#define  SATA_PORT_INT_STATUS_ENTER_PPS_INT_SHIFT 17
#define  SATA_PORT_INT_STATUS_ENTER_PPS_INT_MASK_SHIFT(reg) (((reg) & SATA_PORT_INT_STATUS_ENTER_PPS_INT_MASK) >> SATA_PORT_INT_STATUS_ENTER_PPS_INT_SHIFT)
#define  SATA_PORT_INT_STATUS_ENTER_PPS_INT_REPLACE_VAL(reg,val) (((reg) & ~SATA_PORT_INT_STATUS_ENTER_PPS_INT_MASK) | (((uint32_t)val) << SATA_PORT_INT_STATUS_ENTER_PPS_INT_SHIFT))

#define  SATA_PORT_INT_STATUS_ENTER_SLUMBER_INT_MASK 0x10000
#define  SATA_PORT_INT_STATUS_ENTER_SLUMBER_INT_SHIFT 16
#define  SATA_PORT_INT_STATUS_ENTER_SLUMBER_INT_MASK_SHIFT(reg) (((reg) & SATA_PORT_INT_STATUS_ENTER_SLUMBER_INT_MASK) >> SATA_PORT_INT_STATUS_ENTER_SLUMBER_INT_SHIFT)
#define  SATA_PORT_INT_STATUS_ENTER_SLUMBER_INT_REPLACE_VAL(reg,val) (((reg) & ~SATA_PORT_INT_STATUS_ENTER_SLUMBER_INT_MASK) | (((uint32_t)val) << SATA_PORT_INT_STATUS_ENTER_SLUMBER_INT_SHIFT))

#define  SATA_PORT_INT_STATUS_RCV_COMWAKE_OOB_MASK 0x8000
#define  SATA_PORT_INT_STATUS_RCV_COMWAKE_OOB_SHIFT 15
#define  SATA_PORT_INT_STATUS_RCV_COMWAKE_OOB_MASK_SHIFT(reg) (((reg) & SATA_PORT_INT_STATUS_RCV_COMWAKE_OOB_MASK) >> SATA_PORT_INT_STATUS_RCV_COMWAKE_OOB_SHIFT)
#define  SATA_PORT_INT_STATUS_RCV_COMWAKE_OOB_REPLACE_VAL(reg,val) (((reg) & ~SATA_PORT_INT_STATUS_RCV_COMWAKE_OOB_MASK) | (((uint32_t)val) << SATA_PORT_INT_STATUS_RCV_COMWAKE_OOB_SHIFT))

#define  SATA_PORT_INT_STATUS_RCV_BIST_ACT_FIS_MASK 0x4000
#define  SATA_PORT_INT_STATUS_RCV_BIST_ACT_FIS_SHIFT 14
#define  SATA_PORT_INT_STATUS_RCV_BIST_ACT_FIS_MASK_SHIFT(reg) (((reg) & SATA_PORT_INT_STATUS_RCV_BIST_ACT_FIS_MASK) >> SATA_PORT_INT_STATUS_RCV_BIST_ACT_FIS_SHIFT)
#define  SATA_PORT_INT_STATUS_RCV_BIST_ACT_FIS_REPLACE_VAL(reg,val) (((reg) & ~SATA_PORT_INT_STATUS_RCV_BIST_ACT_FIS_MASK) | (((uint32_t)val) << SATA_PORT_INT_STATUS_RCV_BIST_ACT_FIS_SHIFT))

#define  SATA_PORT_INT_STATUS_RESERVED3_MASK 0x3f00
#define  SATA_PORT_INT_STATUS_RESERVED3_SHIFT 8
#define  SATA_PORT_INT_STATUS_RESERVED3_MASK_SHIFT(reg) (((reg) & SATA_PORT_INT_STATUS_RESERVED3_MASK) >> SATA_PORT_INT_STATUS_RESERVED3_SHIFT)
#define  SATA_PORT_INT_STATUS_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~SATA_PORT_INT_STATUS_RESERVED3_MASK) | (((uint32_t)val) << SATA_PORT_INT_STATUS_RESERVED3_SHIFT))

#define  SATA_PORT_INT_STATUS_DEVICE_MECH_PRES_ST_MASK 0x80
#define  SATA_PORT_INT_STATUS_DEVICE_MECH_PRES_ST_SHIFT 7
#define  SATA_PORT_INT_STATUS_DEVICE_MECH_PRES_ST_MASK_SHIFT(reg) (((reg) & SATA_PORT_INT_STATUS_DEVICE_MECH_PRES_ST_MASK) >> SATA_PORT_INT_STATUS_DEVICE_MECH_PRES_ST_SHIFT)
#define  SATA_PORT_INT_STATUS_DEVICE_MECH_PRES_ST_REPLACE_VAL(reg,val) (((reg) & ~SATA_PORT_INT_STATUS_DEVICE_MECH_PRES_ST_MASK) | (((uint32_t)val) << SATA_PORT_INT_STATUS_DEVICE_MECH_PRES_ST_SHIFT))

#define  SATA_PORT_INT_STATUS_PORT_CONN_CH_ST_MASK 0x40
#define  SATA_PORT_INT_STATUS_PORT_CONN_CH_ST_SHIFT 6
#define  SATA_PORT_INT_STATUS_PORT_CONN_CH_ST_MASK_SHIFT(reg) (((reg) & SATA_PORT_INT_STATUS_PORT_CONN_CH_ST_MASK) >> SATA_PORT_INT_STATUS_PORT_CONN_CH_ST_SHIFT)
#define  SATA_PORT_INT_STATUS_PORT_CONN_CH_ST_REPLACE_VAL(reg,val) (((reg) & ~SATA_PORT_INT_STATUS_PORT_CONN_CH_ST_MASK) | (((uint32_t)val) << SATA_PORT_INT_STATUS_PORT_CONN_CH_ST_SHIFT))

#define  SATA_PORT_INT_STATUS_DESC_PROC_MASK 0x20
#define  SATA_PORT_INT_STATUS_DESC_PROC_SHIFT 5
#define  SATA_PORT_INT_STATUS_DESC_PROC_MASK_SHIFT(reg) (((reg) & SATA_PORT_INT_STATUS_DESC_PROC_MASK) >> SATA_PORT_INT_STATUS_DESC_PROC_SHIFT)
#define  SATA_PORT_INT_STATUS_DESC_PROC_REPLACE_VAL(reg,val) (((reg) & ~SATA_PORT_INT_STATUS_DESC_PROC_MASK) | (((uint32_t)val) << SATA_PORT_INT_STATUS_DESC_PROC_SHIFT))

#define  SATA_PORT_INT_STATUS_UNKN_FIS_INT_MASK 0x10
#define  SATA_PORT_INT_STATUS_UNKN_FIS_INT_SHIFT 4
#define  SATA_PORT_INT_STATUS_UNKN_FIS_INT_MASK_SHIFT(reg) (((reg) & SATA_PORT_INT_STATUS_UNKN_FIS_INT_MASK) >> SATA_PORT_INT_STATUS_UNKN_FIS_INT_SHIFT)
#define  SATA_PORT_INT_STATUS_UNKN_FIS_INT_REPLACE_VAL(reg,val) (((reg) & ~SATA_PORT_INT_STATUS_UNKN_FIS_INT_MASK) | (((uint32_t)val) << SATA_PORT_INT_STATUS_UNKN_FIS_INT_SHIFT))

#define  SATA_PORT_INT_STATUS_SET_DEV_INT_MASK 0x8
#define  SATA_PORT_INT_STATUS_SET_DEV_INT_SHIFT 3
#define  SATA_PORT_INT_STATUS_SET_DEV_INT_MASK_SHIFT(reg) (((reg) & SATA_PORT_INT_STATUS_SET_DEV_INT_MASK) >> SATA_PORT_INT_STATUS_SET_DEV_INT_SHIFT)
#define  SATA_PORT_INT_STATUS_SET_DEV_INT_REPLACE_VAL(reg,val) (((reg) & ~SATA_PORT_INT_STATUS_SET_DEV_INT_MASK) | (((uint32_t)val) << SATA_PORT_INT_STATUS_SET_DEV_INT_SHIFT))

#define  SATA_PORT_INT_STATUS_DMA_SET_FIS_INT_MASK 0x4
#define  SATA_PORT_INT_STATUS_DMA_SET_FIS_INT_SHIFT 2
#define  SATA_PORT_INT_STATUS_DMA_SET_FIS_INT_MASK_SHIFT(reg) (((reg) & SATA_PORT_INT_STATUS_DMA_SET_FIS_INT_MASK) >> SATA_PORT_INT_STATUS_DMA_SET_FIS_INT_SHIFT)
#define  SATA_PORT_INT_STATUS_DMA_SET_FIS_INT_REPLACE_VAL(reg,val) (((reg) & ~SATA_PORT_INT_STATUS_DMA_SET_FIS_INT_MASK) | (((uint32_t)val) << SATA_PORT_INT_STATUS_DMA_SET_FIS_INT_SHIFT))

#define  SATA_PORT_INT_STATUS_PIO_SETUP_FIS_INT_MASK 0x2
#define  SATA_PORT_INT_STATUS_PIO_SETUP_FIS_INT_SHIFT 1
#define  SATA_PORT_INT_STATUS_PIO_SETUP_FIS_INT_MASK_SHIFT(reg) (((reg) & SATA_PORT_INT_STATUS_PIO_SETUP_FIS_INT_MASK) >> SATA_PORT_INT_STATUS_PIO_SETUP_FIS_INT_SHIFT)
#define  SATA_PORT_INT_STATUS_PIO_SETUP_FIS_INT_REPLACE_VAL(reg,val) (((reg) & ~SATA_PORT_INT_STATUS_PIO_SETUP_FIS_INT_MASK) | (((uint32_t)val) << SATA_PORT_INT_STATUS_PIO_SETUP_FIS_INT_SHIFT))

#define  SATA_PORT_INT_STATUS_D2H_REG_FIS_INT_MASK 0x1
#define  SATA_PORT_INT_STATUS_D2H_REG_FIS_INT_SHIFT 0
#define  SATA_PORT_INT_STATUS_D2H_REG_FIS_INT_MASK_SHIFT(reg) (((reg) & SATA_PORT_INT_STATUS_D2H_REG_FIS_INT_MASK) >> SATA_PORT_INT_STATUS_D2H_REG_FIS_INT_SHIFT)
#define  SATA_PORT_INT_STATUS_D2H_REG_FIS_INT_REPLACE_VAL(reg,val) (((reg) & ~SATA_PORT_INT_STATUS_D2H_REG_FIS_INT_MASK) | (((uint32_t)val) << SATA_PORT_INT_STATUS_D2H_REG_FIS_INT_SHIFT))

//====================================================================
//Register: Port Interrupt Enable (PORT_INT_ENABLE)
//====================================================================

#define  SATA_PORT_INT_ENABLE_CPD_EN_MASK 0x80000000
#define  SATA_PORT_INT_ENABLE_CPD_EN_SHIFT 31
#define  SATA_PORT_INT_ENABLE_CPD_EN_MASK_SHIFT(reg) (((reg) & SATA_PORT_INT_ENABLE_CPD_EN_MASK) >> SATA_PORT_INT_ENABLE_CPD_EN_SHIFT)
#define  SATA_PORT_INT_ENABLE_CPD_EN_REPLACE_VAL(reg,val) (((reg) & ~SATA_PORT_INT_ENABLE_CPD_EN_MASK) | (((uint32_t)val) << SATA_PORT_INT_ENABLE_CPD_EN_SHIFT))

#define  SATA_PORT_INT_ENABLE_TF_ERR_ST_EN_MASK 0x40000000
#define  SATA_PORT_INT_ENABLE_TF_ERR_ST_EN_SHIFT 30
#define  SATA_PORT_INT_ENABLE_TF_ERR_ST_EN_MASK_SHIFT(reg) (((reg) & SATA_PORT_INT_ENABLE_TF_ERR_ST_EN_MASK) >> SATA_PORT_INT_ENABLE_TF_ERR_ST_EN_SHIFT)
#define  SATA_PORT_INT_ENABLE_TF_ERR_ST_EN_REPLACE_VAL(reg,val) (((reg) & ~SATA_PORT_INT_ENABLE_TF_ERR_ST_EN_MASK) | (((uint32_t)val) << SATA_PORT_INT_ENABLE_TF_ERR_ST_EN_SHIFT))

#define  SATA_PORT_INT_ENABLE_HOST_BUS_FE_EN_MASK 0x20000000
#define  SATA_PORT_INT_ENABLE_HOST_BUS_FE_EN_SHIFT 29
#define  SATA_PORT_INT_ENABLE_HOST_BUS_FE_EN_MASK_SHIFT(reg) (((reg) & SATA_PORT_INT_ENABLE_HOST_BUS_FE_EN_MASK) >> SATA_PORT_INT_ENABLE_HOST_BUS_FE_EN_SHIFT)
#define  SATA_PORT_INT_ENABLE_HOST_BUS_FE_EN_REPLACE_VAL(reg,val) (((reg) & ~SATA_PORT_INT_ENABLE_HOST_BUS_FE_EN_MASK) | (((uint32_t)val) << SATA_PORT_INT_ENABLE_HOST_BUS_FE_EN_SHIFT))

#define  SATA_PORT_INT_ENABLE_HOST_BUS_DE_EN_MASK 0x10000000
#define  SATA_PORT_INT_ENABLE_HOST_BUS_DE_EN_SHIFT 28
#define  SATA_PORT_INT_ENABLE_HOST_BUS_DE_EN_MASK_SHIFT(reg) (((reg) & SATA_PORT_INT_ENABLE_HOST_BUS_DE_EN_MASK) >> SATA_PORT_INT_ENABLE_HOST_BUS_DE_EN_SHIFT)
#define  SATA_PORT_INT_ENABLE_HOST_BUS_DE_EN_REPLACE_VAL(reg,val) (((reg) & ~SATA_PORT_INT_ENABLE_HOST_BUS_DE_EN_MASK) | (((uint32_t)val) << SATA_PORT_INT_ENABLE_HOST_BUS_DE_EN_SHIFT))

#define  SATA_PORT_INT_ENABLE_INTFC_FE_EN_MASK 0x8000000
#define  SATA_PORT_INT_ENABLE_INTFC_FE_EN_SHIFT 27
#define  SATA_PORT_INT_ENABLE_INTFC_FE_EN_MASK_SHIFT(reg) (((reg) & SATA_PORT_INT_ENABLE_INTFC_FE_EN_MASK) >> SATA_PORT_INT_ENABLE_INTFC_FE_EN_SHIFT)
#define  SATA_PORT_INT_ENABLE_INTFC_FE_EN_REPLACE_VAL(reg,val) (((reg) & ~SATA_PORT_INT_ENABLE_INTFC_FE_EN_MASK) | (((uint32_t)val) << SATA_PORT_INT_ENABLE_INTFC_FE_EN_SHIFT))

#define  SATA_PORT_INT_ENABLE_INTFC_NFE_EN_MASK 0x4000000
#define  SATA_PORT_INT_ENABLE_INTFC_NFE_EN_SHIFT 26
#define  SATA_PORT_INT_ENABLE_INTFC_NFE_EN_MASK_SHIFT(reg) (((reg) & SATA_PORT_INT_ENABLE_INTFC_NFE_EN_MASK) >> SATA_PORT_INT_ENABLE_INTFC_NFE_EN_SHIFT)
#define  SATA_PORT_INT_ENABLE_INTFC_NFE_EN_REPLACE_VAL(reg,val) (((reg) & ~SATA_PORT_INT_ENABLE_INTFC_NFE_EN_MASK) | (((uint32_t)val) << SATA_PORT_INT_ENABLE_INTFC_NFE_EN_SHIFT))

#define  SATA_PORT_INT_ENABLE_RESERVED1_MASK 0x2000000
#define  SATA_PORT_INT_ENABLE_RESERVED1_SHIFT 25
#define  SATA_PORT_INT_ENABLE_RESERVED1_MASK_SHIFT(reg) (((reg) & SATA_PORT_INT_ENABLE_RESERVED1_MASK) >> SATA_PORT_INT_ENABLE_RESERVED1_SHIFT)
#define  SATA_PORT_INT_ENABLE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SATA_PORT_INT_ENABLE_RESERVED1_MASK) | (((uint32_t)val) << SATA_PORT_INT_ENABLE_RESERVED1_SHIFT))

#define  SATA_PORT_INT_ENABLE_OFLOW_EN_MASK 0x1000000
#define  SATA_PORT_INT_ENABLE_OFLOW_EN_SHIFT 24
#define  SATA_PORT_INT_ENABLE_OFLOW_EN_MASK_SHIFT(reg) (((reg) & SATA_PORT_INT_ENABLE_OFLOW_EN_MASK) >> SATA_PORT_INT_ENABLE_OFLOW_EN_SHIFT)
#define  SATA_PORT_INT_ENABLE_OFLOW_EN_REPLACE_VAL(reg,val) (((reg) & ~SATA_PORT_INT_ENABLE_OFLOW_EN_MASK) | (((uint32_t)val) << SATA_PORT_INT_ENABLE_OFLOW_EN_SHIFT))

#define  SATA_PORT_INT_ENABLE_IPM_EN_MASK 0x800000
#define  SATA_PORT_INT_ENABLE_IPM_EN_SHIFT 23
#define  SATA_PORT_INT_ENABLE_IPM_EN_MASK_SHIFT(reg) (((reg) & SATA_PORT_INT_ENABLE_IPM_EN_MASK) >> SATA_PORT_INT_ENABLE_IPM_EN_SHIFT)
#define  SATA_PORT_INT_ENABLE_IPM_EN_REPLACE_VAL(reg,val) (((reg) & ~SATA_PORT_INT_ENABLE_IPM_EN_MASK) | (((uint32_t)val) << SATA_PORT_INT_ENABLE_IPM_EN_SHIFT))

#define  SATA_PORT_INT_ENABLE_PHYRDY_CH_INT_EN_MASK 0x400000
#define  SATA_PORT_INT_ENABLE_PHYRDY_CH_INT_EN_SHIFT 22
#define  SATA_PORT_INT_ENABLE_PHYRDY_CH_INT_EN_MASK_SHIFT(reg) (((reg) & SATA_PORT_INT_ENABLE_PHYRDY_CH_INT_EN_MASK) >> SATA_PORT_INT_ENABLE_PHYRDY_CH_INT_EN_SHIFT)
#define  SATA_PORT_INT_ENABLE_PHYRDY_CH_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~SATA_PORT_INT_ENABLE_PHYRDY_CH_INT_EN_MASK) | (((uint32_t)val) << SATA_PORT_INT_ENABLE_PHYRDY_CH_INT_EN_SHIFT))

#define  SATA_PORT_INT_ENABLE_RESERVED2_MASK 0x300000
#define  SATA_PORT_INT_ENABLE_RESERVED2_SHIFT 20
#define  SATA_PORT_INT_ENABLE_RESERVED2_MASK_SHIFT(reg) (((reg) & SATA_PORT_INT_ENABLE_RESERVED2_MASK) >> SATA_PORT_INT_ENABLE_RESERVED2_SHIFT)
#define  SATA_PORT_INT_ENABLE_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SATA_PORT_INT_ENABLE_RESERVED2_MASK) | (((uint32_t)val) << SATA_PORT_INT_ENABLE_RESERVED2_SHIFT))

#define  SATA_PORT_INT_ENABLE_RCV_SIG_FIS_INT_EN_MASK 0x80000
#define  SATA_PORT_INT_ENABLE_RCV_SIG_FIS_INT_EN_SHIFT 19
#define  SATA_PORT_INT_ENABLE_RCV_SIG_FIS_INT_EN_MASK_SHIFT(reg) (((reg) & SATA_PORT_INT_ENABLE_RCV_SIG_FIS_INT_EN_MASK) >> SATA_PORT_INT_ENABLE_RCV_SIG_FIS_INT_EN_SHIFT)
#define  SATA_PORT_INT_ENABLE_RCV_SIG_FIS_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~SATA_PORT_INT_ENABLE_RCV_SIG_FIS_INT_EN_MASK) | (((uint32_t)val) << SATA_PORT_INT_ENABLE_RCV_SIG_FIS_INT_EN_SHIFT))

#define  SATA_PORT_INT_ENABLE_WAKE_PWR_SV_INT_EN_MASK 0x40000
#define  SATA_PORT_INT_ENABLE_WAKE_PWR_SV_INT_EN_SHIFT 18
#define  SATA_PORT_INT_ENABLE_WAKE_PWR_SV_INT_EN_MASK_SHIFT(reg) (((reg) & SATA_PORT_INT_ENABLE_WAKE_PWR_SV_INT_EN_MASK) >> SATA_PORT_INT_ENABLE_WAKE_PWR_SV_INT_EN_SHIFT)
#define  SATA_PORT_INT_ENABLE_WAKE_PWR_SV_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~SATA_PORT_INT_ENABLE_WAKE_PWR_SV_INT_EN_MASK) | (((uint32_t)val) << SATA_PORT_INT_ENABLE_WAKE_PWR_SV_INT_EN_SHIFT))

#define  SATA_PORT_INT_ENABLE_ENTER_PPS_INT_EN_MASK 0x20000
#define  SATA_PORT_INT_ENABLE_ENTER_PPS_INT_EN_SHIFT 17
#define  SATA_PORT_INT_ENABLE_ENTER_PPS_INT_EN_MASK_SHIFT(reg) (((reg) & SATA_PORT_INT_ENABLE_ENTER_PPS_INT_EN_MASK) >> SATA_PORT_INT_ENABLE_ENTER_PPS_INT_EN_SHIFT)
#define  SATA_PORT_INT_ENABLE_ENTER_PPS_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~SATA_PORT_INT_ENABLE_ENTER_PPS_INT_EN_MASK) | (((uint32_t)val) << SATA_PORT_INT_ENABLE_ENTER_PPS_INT_EN_SHIFT))

#define  SATA_PORT_INT_ENABLE_ENTER_SLUMBER_INT_EN_MASK 0x10000
#define  SATA_PORT_INT_ENABLE_ENTER_SLUMBER_INT_EN_SHIFT 16
#define  SATA_PORT_INT_ENABLE_ENTER_SLUMBER_INT_EN_MASK_SHIFT(reg) (((reg) & SATA_PORT_INT_ENABLE_ENTER_SLUMBER_INT_EN_MASK) >> SATA_PORT_INT_ENABLE_ENTER_SLUMBER_INT_EN_SHIFT)
#define  SATA_PORT_INT_ENABLE_ENTER_SLUMBER_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~SATA_PORT_INT_ENABLE_ENTER_SLUMBER_INT_EN_MASK) | (((uint32_t)val) << SATA_PORT_INT_ENABLE_ENTER_SLUMBER_INT_EN_SHIFT))

#define  SATA_PORT_INT_ENABLE_RCV_COMWAKE_OOB_EN_MASK 0x8000
#define  SATA_PORT_INT_ENABLE_RCV_COMWAKE_OOB_EN_SHIFT 15
#define  SATA_PORT_INT_ENABLE_RCV_COMWAKE_OOB_EN_MASK_SHIFT(reg) (((reg) & SATA_PORT_INT_ENABLE_RCV_COMWAKE_OOB_EN_MASK) >> SATA_PORT_INT_ENABLE_RCV_COMWAKE_OOB_EN_SHIFT)
#define  SATA_PORT_INT_ENABLE_RCV_COMWAKE_OOB_EN_REPLACE_VAL(reg,val) (((reg) & ~SATA_PORT_INT_ENABLE_RCV_COMWAKE_OOB_EN_MASK) | (((uint32_t)val) << SATA_PORT_INT_ENABLE_RCV_COMWAKE_OOB_EN_SHIFT))

#define  SATA_PORT_INT_ENABLE_RCV_BIST_ACT_FIS_EN_MASK 0x4000
#define  SATA_PORT_INT_ENABLE_RCV_BIST_ACT_FIS_EN_SHIFT 14
#define  SATA_PORT_INT_ENABLE_RCV_BIST_ACT_FIS_EN_MASK_SHIFT(reg) (((reg) & SATA_PORT_INT_ENABLE_RCV_BIST_ACT_FIS_EN_MASK) >> SATA_PORT_INT_ENABLE_RCV_BIST_ACT_FIS_EN_SHIFT)
#define  SATA_PORT_INT_ENABLE_RCV_BIST_ACT_FIS_EN_REPLACE_VAL(reg,val) (((reg) & ~SATA_PORT_INT_ENABLE_RCV_BIST_ACT_FIS_EN_MASK) | (((uint32_t)val) << SATA_PORT_INT_ENABLE_RCV_BIST_ACT_FIS_EN_SHIFT))

#define  SATA_PORT_INT_ENABLE_RESERVED3_MASK 0x3f00
#define  SATA_PORT_INT_ENABLE_RESERVED3_SHIFT 8
#define  SATA_PORT_INT_ENABLE_RESERVED3_MASK_SHIFT(reg) (((reg) & SATA_PORT_INT_ENABLE_RESERVED3_MASK) >> SATA_PORT_INT_ENABLE_RESERVED3_SHIFT)
#define  SATA_PORT_INT_ENABLE_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~SATA_PORT_INT_ENABLE_RESERVED3_MASK) | (((uint32_t)val) << SATA_PORT_INT_ENABLE_RESERVED3_SHIFT))

#define  SATA_PORT_INT_ENABLE_DEVICE_MECH_PRES_EN_MASK 0x80
#define  SATA_PORT_INT_ENABLE_DEVICE_MECH_PRES_EN_SHIFT 7
#define  SATA_PORT_INT_ENABLE_DEVICE_MECH_PRES_EN_MASK_SHIFT(reg) (((reg) & SATA_PORT_INT_ENABLE_DEVICE_MECH_PRES_EN_MASK) >> SATA_PORT_INT_ENABLE_DEVICE_MECH_PRES_EN_SHIFT)
#define  SATA_PORT_INT_ENABLE_DEVICE_MECH_PRES_EN_REPLACE_VAL(reg,val) (((reg) & ~SATA_PORT_INT_ENABLE_DEVICE_MECH_PRES_EN_MASK) | (((uint32_t)val) << SATA_PORT_INT_ENABLE_DEVICE_MECH_PRES_EN_SHIFT))

#define  SATA_PORT_INT_ENABLE_PORT_CONN_CH_EN_MASK 0x40
#define  SATA_PORT_INT_ENABLE_PORT_CONN_CH_EN_SHIFT 6
#define  SATA_PORT_INT_ENABLE_PORT_CONN_CH_EN_MASK_SHIFT(reg) (((reg) & SATA_PORT_INT_ENABLE_PORT_CONN_CH_EN_MASK) >> SATA_PORT_INT_ENABLE_PORT_CONN_CH_EN_SHIFT)
#define  SATA_PORT_INT_ENABLE_PORT_CONN_CH_EN_REPLACE_VAL(reg,val) (((reg) & ~SATA_PORT_INT_ENABLE_PORT_CONN_CH_EN_MASK) | (((uint32_t)val) << SATA_PORT_INT_ENABLE_PORT_CONN_CH_EN_SHIFT))

#define  SATA_PORT_INT_ENABLE_DESC_PROC_INT_EN_MASK 0x20
#define  SATA_PORT_INT_ENABLE_DESC_PROC_INT_EN_SHIFT 5
#define  SATA_PORT_INT_ENABLE_DESC_PROC_INT_EN_MASK_SHIFT(reg) (((reg) & SATA_PORT_INT_ENABLE_DESC_PROC_INT_EN_MASK) >> SATA_PORT_INT_ENABLE_DESC_PROC_INT_EN_SHIFT)
#define  SATA_PORT_INT_ENABLE_DESC_PROC_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~SATA_PORT_INT_ENABLE_DESC_PROC_INT_EN_MASK) | (((uint32_t)val) << SATA_PORT_INT_ENABLE_DESC_PROC_INT_EN_SHIFT))

#define  SATA_PORT_INT_ENABLE_UNKN_FIS_INT_EN_MASK 0x10
#define  SATA_PORT_INT_ENABLE_UNKN_FIS_INT_EN_SHIFT 4
#define  SATA_PORT_INT_ENABLE_UNKN_FIS_INT_EN_MASK_SHIFT(reg) (((reg) & SATA_PORT_INT_ENABLE_UNKN_FIS_INT_EN_MASK) >> SATA_PORT_INT_ENABLE_UNKN_FIS_INT_EN_SHIFT)
#define  SATA_PORT_INT_ENABLE_UNKN_FIS_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~SATA_PORT_INT_ENABLE_UNKN_FIS_INT_EN_MASK) | (((uint32_t)val) << SATA_PORT_INT_ENABLE_UNKN_FIS_INT_EN_SHIFT))

#define  SATA_PORT_INT_ENABLE_SET_DEV_INT_EN_MASK 0x8
#define  SATA_PORT_INT_ENABLE_SET_DEV_INT_EN_SHIFT 3
#define  SATA_PORT_INT_ENABLE_SET_DEV_INT_EN_MASK_SHIFT(reg) (((reg) & SATA_PORT_INT_ENABLE_SET_DEV_INT_EN_MASK) >> SATA_PORT_INT_ENABLE_SET_DEV_INT_EN_SHIFT)
#define  SATA_PORT_INT_ENABLE_SET_DEV_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~SATA_PORT_INT_ENABLE_SET_DEV_INT_EN_MASK) | (((uint32_t)val) << SATA_PORT_INT_ENABLE_SET_DEV_INT_EN_SHIFT))

#define  SATA_PORT_INT_ENABLE_DMA_SET_FIS_INT_EN_MASK 0x4
#define  SATA_PORT_INT_ENABLE_DMA_SET_FIS_INT_EN_SHIFT 2
#define  SATA_PORT_INT_ENABLE_DMA_SET_FIS_INT_EN_MASK_SHIFT(reg) (((reg) & SATA_PORT_INT_ENABLE_DMA_SET_FIS_INT_EN_MASK) >> SATA_PORT_INT_ENABLE_DMA_SET_FIS_INT_EN_SHIFT)
#define  SATA_PORT_INT_ENABLE_DMA_SET_FIS_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~SATA_PORT_INT_ENABLE_DMA_SET_FIS_INT_EN_MASK) | (((uint32_t)val) << SATA_PORT_INT_ENABLE_DMA_SET_FIS_INT_EN_SHIFT))

#define  SATA_PORT_INT_ENABLE_PIO_SETUP_FIS_INT_EN_MASK 0x2
#define  SATA_PORT_INT_ENABLE_PIO_SETUP_FIS_INT_EN_SHIFT 1
#define  SATA_PORT_INT_ENABLE_PIO_SETUP_FIS_INT_EN_MASK_SHIFT(reg) (((reg) & SATA_PORT_INT_ENABLE_PIO_SETUP_FIS_INT_EN_MASK) >> SATA_PORT_INT_ENABLE_PIO_SETUP_FIS_INT_EN_SHIFT)
#define  SATA_PORT_INT_ENABLE_PIO_SETUP_FIS_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~SATA_PORT_INT_ENABLE_PIO_SETUP_FIS_INT_EN_MASK) | (((uint32_t)val) << SATA_PORT_INT_ENABLE_PIO_SETUP_FIS_INT_EN_SHIFT))

#define  SATA_PORT_INT_ENABLE_D2H_REG_FIS_INT_EN_MASK 0x1
#define  SATA_PORT_INT_ENABLE_D2H_REG_FIS_INT_EN_SHIFT 0
#define  SATA_PORT_INT_ENABLE_D2H_REG_FIS_INT_EN_MASK_SHIFT(reg) (((reg) & SATA_PORT_INT_ENABLE_D2H_REG_FIS_INT_EN_MASK) >> SATA_PORT_INT_ENABLE_D2H_REG_FIS_INT_EN_SHIFT)
#define  SATA_PORT_INT_ENABLE_D2H_REG_FIS_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~SATA_PORT_INT_ENABLE_D2H_REG_FIS_INT_EN_MASK) | (((uint32_t)val) << SATA_PORT_INT_ENABLE_D2H_REG_FIS_INT_EN_SHIFT))

//====================================================================
//Register: Port Command and Status (PORT_CMD_AND_STATUS)
//====================================================================

#define  SATA_PORT_CMD_AND_STATUS_INTFC_COMM_CTRL_MASK 0xf0000000
#define  SATA_PORT_CMD_AND_STATUS_INTFC_COMM_CTRL_SHIFT 28
#define  SATA_PORT_CMD_AND_STATUS_INTFC_COMM_CTRL_MASK_SHIFT(reg) (((reg) & SATA_PORT_CMD_AND_STATUS_INTFC_COMM_CTRL_MASK) >> SATA_PORT_CMD_AND_STATUS_INTFC_COMM_CTRL_SHIFT)
#define  SATA_PORT_CMD_AND_STATUS_INTFC_COMM_CTRL_REPLACE_VAL(reg,val) (((reg) & ~SATA_PORT_CMD_AND_STATUS_INTFC_COMM_CTRL_MASK) | (((uint32_t)val) << SATA_PORT_CMD_AND_STATUS_INTFC_COMM_CTRL_SHIFT))

#define  SATA_PORT_CMD_AND_STATUS_AGG_SLMB_PARTIAL_MASK 0x8000000
#define  SATA_PORT_CMD_AND_STATUS_AGG_SLMB_PARTIAL_SHIFT 27
#define  SATA_PORT_CMD_AND_STATUS_AGG_SLMB_PARTIAL_MASK_SHIFT(reg) (((reg) & SATA_PORT_CMD_AND_STATUS_AGG_SLMB_PARTIAL_MASK) >> SATA_PORT_CMD_AND_STATUS_AGG_SLMB_PARTIAL_SHIFT)
#define  SATA_PORT_CMD_AND_STATUS_AGG_SLMB_PARTIAL_REPLACE_VAL(reg,val) (((reg) & ~SATA_PORT_CMD_AND_STATUS_AGG_SLMB_PARTIAL_MASK) | (((uint32_t)val) << SATA_PORT_CMD_AND_STATUS_AGG_SLMB_PARTIAL_SHIFT))

#define  SATA_PORT_CMD_AND_STATUS_AGG_LINK_PWR_MGT_EN_MASK 0x4000000
#define  SATA_PORT_CMD_AND_STATUS_AGG_LINK_PWR_MGT_EN_SHIFT 26
#define  SATA_PORT_CMD_AND_STATUS_AGG_LINK_PWR_MGT_EN_MASK_SHIFT(reg) (((reg) & SATA_PORT_CMD_AND_STATUS_AGG_LINK_PWR_MGT_EN_MASK) >> SATA_PORT_CMD_AND_STATUS_AGG_LINK_PWR_MGT_EN_SHIFT)
#define  SATA_PORT_CMD_AND_STATUS_AGG_LINK_PWR_MGT_EN_REPLACE_VAL(reg,val) (((reg) & ~SATA_PORT_CMD_AND_STATUS_AGG_LINK_PWR_MGT_EN_MASK) | (((uint32_t)val) << SATA_PORT_CMD_AND_STATUS_AGG_LINK_PWR_MGT_EN_SHIFT))

#define  SATA_PORT_CMD_AND_STATUS_LED_ON_ATAPI_EN_MASK 0x2000000
#define  SATA_PORT_CMD_AND_STATUS_LED_ON_ATAPI_EN_SHIFT 25
#define  SATA_PORT_CMD_AND_STATUS_LED_ON_ATAPI_EN_MASK_SHIFT(reg) (((reg) & SATA_PORT_CMD_AND_STATUS_LED_ON_ATAPI_EN_MASK) >> SATA_PORT_CMD_AND_STATUS_LED_ON_ATAPI_EN_SHIFT)
#define  SATA_PORT_CMD_AND_STATUS_LED_ON_ATAPI_EN_REPLACE_VAL(reg,val) (((reg) & ~SATA_PORT_CMD_AND_STATUS_LED_ON_ATAPI_EN_MASK) | (((uint32_t)val) << SATA_PORT_CMD_AND_STATUS_LED_ON_ATAPI_EN_SHIFT))

#define  SATA_PORT_CMD_AND_STATUS_DEVICE_IS_ATAPI_MASK 0x1000000
#define  SATA_PORT_CMD_AND_STATUS_DEVICE_IS_ATAPI_SHIFT 24
#define  SATA_PORT_CMD_AND_STATUS_DEVICE_IS_ATAPI_MASK_SHIFT(reg) (((reg) & SATA_PORT_CMD_AND_STATUS_DEVICE_IS_ATAPI_MASK) >> SATA_PORT_CMD_AND_STATUS_DEVICE_IS_ATAPI_SHIFT)
#define  SATA_PORT_CMD_AND_STATUS_DEVICE_IS_ATAPI_REPLACE_VAL(reg,val) (((reg) & ~SATA_PORT_CMD_AND_STATUS_DEVICE_IS_ATAPI_MASK) | (((uint32_t)val) << SATA_PORT_CMD_AND_STATUS_DEVICE_IS_ATAPI_SHIFT))

#define  SATA_PORT_CMD_AND_STATUS_AUTO_P2S_TRANS_EN_MASK 0x800000
#define  SATA_PORT_CMD_AND_STATUS_AUTO_P2S_TRANS_EN_SHIFT 23
#define  SATA_PORT_CMD_AND_STATUS_AUTO_P2S_TRANS_EN_MASK_SHIFT(reg) (((reg) & SATA_PORT_CMD_AND_STATUS_AUTO_P2S_TRANS_EN_MASK) >> SATA_PORT_CMD_AND_STATUS_AUTO_P2S_TRANS_EN_SHIFT)
#define  SATA_PORT_CMD_AND_STATUS_AUTO_P2S_TRANS_EN_REPLACE_VAL(reg,val) (((reg) & ~SATA_PORT_CMD_AND_STATUS_AUTO_P2S_TRANS_EN_MASK) | (((uint32_t)val) << SATA_PORT_CMD_AND_STATUS_AUTO_P2S_TRANS_EN_SHIFT))

#define  SATA_PORT_CMD_AND_STATUS_FIS_SW_CAP_PORT_MASK 0x400000
#define  SATA_PORT_CMD_AND_STATUS_FIS_SW_CAP_PORT_SHIFT 22
#define  SATA_PORT_CMD_AND_STATUS_FIS_SW_CAP_PORT_MASK_SHIFT(reg) (((reg) & SATA_PORT_CMD_AND_STATUS_FIS_SW_CAP_PORT_MASK) >> SATA_PORT_CMD_AND_STATUS_FIS_SW_CAP_PORT_SHIFT)
#define  SATA_PORT_CMD_AND_STATUS_FIS_SW_CAP_PORT_REPLACE_VAL(reg,val) (((reg) & ~SATA_PORT_CMD_AND_STATUS_FIS_SW_CAP_PORT_MASK) | (((uint32_t)val) << SATA_PORT_CMD_AND_STATUS_FIS_SW_CAP_PORT_SHIFT))

#define  SATA_PORT_CMD_AND_STATUS_EXT_SATA_PORT_MASK 0x200000
#define  SATA_PORT_CMD_AND_STATUS_EXT_SATA_PORT_SHIFT 21
#define  SATA_PORT_CMD_AND_STATUS_EXT_SATA_PORT_MASK_SHIFT(reg) (((reg) & SATA_PORT_CMD_AND_STATUS_EXT_SATA_PORT_MASK) >> SATA_PORT_CMD_AND_STATUS_EXT_SATA_PORT_SHIFT)
#define  SATA_PORT_CMD_AND_STATUS_EXT_SATA_PORT_REPLACE_VAL(reg,val) (((reg) & ~SATA_PORT_CMD_AND_STATUS_EXT_SATA_PORT_MASK) | (((uint32_t)val) << SATA_PORT_CMD_AND_STATUS_EXT_SATA_PORT_SHIFT))

#define  SATA_PORT_CMD_AND_STATUS_CPD_SUPP_MASK 0x100000
#define  SATA_PORT_CMD_AND_STATUS_CPD_SUPP_SHIFT 20
#define  SATA_PORT_CMD_AND_STATUS_CPD_SUPP_MASK_SHIFT(reg) (((reg) & SATA_PORT_CMD_AND_STATUS_CPD_SUPP_MASK) >> SATA_PORT_CMD_AND_STATUS_CPD_SUPP_SHIFT)
#define  SATA_PORT_CMD_AND_STATUS_CPD_SUPP_REPLACE_VAL(reg,val) (((reg) & ~SATA_PORT_CMD_AND_STATUS_CPD_SUPP_MASK) | (((uint32_t)val) << SATA_PORT_CMD_AND_STATUS_CPD_SUPP_SHIFT))

#define  SATA_PORT_CMD_AND_STATUS_MECH_PRES_SW_MASK 0x80000
#define  SATA_PORT_CMD_AND_STATUS_MECH_PRES_SW_SHIFT 19
#define  SATA_PORT_CMD_AND_STATUS_MECH_PRES_SW_MASK_SHIFT(reg) (((reg) & SATA_PORT_CMD_AND_STATUS_MECH_PRES_SW_MASK) >> SATA_PORT_CMD_AND_STATUS_MECH_PRES_SW_SHIFT)
#define  SATA_PORT_CMD_AND_STATUS_MECH_PRES_SW_REPLACE_VAL(reg,val) (((reg) & ~SATA_PORT_CMD_AND_STATUS_MECH_PRES_SW_MASK) | (((uint32_t)val) << SATA_PORT_CMD_AND_STATUS_MECH_PRES_SW_SHIFT))

#define  SATA_PORT_CMD_AND_STATUS_HOT_PLUG_CAP_MASK 0x40000
#define  SATA_PORT_CMD_AND_STATUS_HOT_PLUG_CAP_SHIFT 18
#define  SATA_PORT_CMD_AND_STATUS_HOT_PLUG_CAP_MASK_SHIFT(reg) (((reg) & SATA_PORT_CMD_AND_STATUS_HOT_PLUG_CAP_MASK) >> SATA_PORT_CMD_AND_STATUS_HOT_PLUG_CAP_SHIFT)
#define  SATA_PORT_CMD_AND_STATUS_HOT_PLUG_CAP_REPLACE_VAL(reg,val) (((reg) & ~SATA_PORT_CMD_AND_STATUS_HOT_PLUG_CAP_MASK) | (((uint32_t)val) << SATA_PORT_CMD_AND_STATUS_HOT_PLUG_CAP_SHIFT))

#define  SATA_PORT_CMD_AND_STATUS_PM_ATT_MASK 0x20000
#define  SATA_PORT_CMD_AND_STATUS_PM_ATT_SHIFT 17
#define  SATA_PORT_CMD_AND_STATUS_PM_ATT_MASK_SHIFT(reg) (((reg) & SATA_PORT_CMD_AND_STATUS_PM_ATT_MASK) >> SATA_PORT_CMD_AND_STATUS_PM_ATT_SHIFT)
#define  SATA_PORT_CMD_AND_STATUS_PM_ATT_REPLACE_VAL(reg,val) (((reg) & ~SATA_PORT_CMD_AND_STATUS_PM_ATT_MASK) | (((uint32_t)val) << SATA_PORT_CMD_AND_STATUS_PM_ATT_SHIFT))

#define  SATA_PORT_CMD_AND_STATUS_CP_STATE_MASK 0x10000
#define  SATA_PORT_CMD_AND_STATUS_CP_STATE_SHIFT 16
#define  SATA_PORT_CMD_AND_STATUS_CP_STATE_MASK_SHIFT(reg) (((reg) & SATA_PORT_CMD_AND_STATUS_CP_STATE_MASK) >> SATA_PORT_CMD_AND_STATUS_CP_STATE_SHIFT)
#define  SATA_PORT_CMD_AND_STATUS_CP_STATE_REPLACE_VAL(reg,val) (((reg) & ~SATA_PORT_CMD_AND_STATUS_CP_STATE_MASK) | (((uint32_t)val) << SATA_PORT_CMD_AND_STATUS_CP_STATE_SHIFT))

#define  SATA_PORT_CMD_AND_STATUS_CMD_LIST_RN_MASK 0x8000
#define  SATA_PORT_CMD_AND_STATUS_CMD_LIST_RN_SHIFT 15
#define  SATA_PORT_CMD_AND_STATUS_CMD_LIST_RN_MASK_SHIFT(reg) (((reg) & SATA_PORT_CMD_AND_STATUS_CMD_LIST_RN_MASK) >> SATA_PORT_CMD_AND_STATUS_CMD_LIST_RN_SHIFT)
#define  SATA_PORT_CMD_AND_STATUS_CMD_LIST_RN_REPLACE_VAL(reg,val) (((reg) & ~SATA_PORT_CMD_AND_STATUS_CMD_LIST_RN_MASK) | (((uint32_t)val) << SATA_PORT_CMD_AND_STATUS_CMD_LIST_RN_SHIFT))

#define  SATA_PORT_CMD_AND_STATUS_FIS_RCV_RN_MASK 0x4000
#define  SATA_PORT_CMD_AND_STATUS_FIS_RCV_RN_SHIFT 14
#define  SATA_PORT_CMD_AND_STATUS_FIS_RCV_RN_MASK_SHIFT(reg) (((reg) & SATA_PORT_CMD_AND_STATUS_FIS_RCV_RN_MASK) >> SATA_PORT_CMD_AND_STATUS_FIS_RCV_RN_SHIFT)
#define  SATA_PORT_CMD_AND_STATUS_FIS_RCV_RN_REPLACE_VAL(reg,val) (((reg) & ~SATA_PORT_CMD_AND_STATUS_FIS_RCV_RN_MASK) | (((uint32_t)val) << SATA_PORT_CMD_AND_STATUS_FIS_RCV_RN_SHIFT))

#define  SATA_PORT_CMD_AND_STATUS_MECH_PRES_SW_STATE_MASK 0x2000
#define  SATA_PORT_CMD_AND_STATUS_MECH_PRES_SW_STATE_SHIFT 13
#define  SATA_PORT_CMD_AND_STATUS_MECH_PRES_SW_STATE_MASK_SHIFT(reg) (((reg) & SATA_PORT_CMD_AND_STATUS_MECH_PRES_SW_STATE_MASK) >> SATA_PORT_CMD_AND_STATUS_MECH_PRES_SW_STATE_SHIFT)
#define  SATA_PORT_CMD_AND_STATUS_MECH_PRES_SW_STATE_REPLACE_VAL(reg,val) (((reg) & ~SATA_PORT_CMD_AND_STATUS_MECH_PRES_SW_STATE_MASK) | (((uint32_t)val) << SATA_PORT_CMD_AND_STATUS_MECH_PRES_SW_STATE_SHIFT))

#define  SATA_PORT_CMD_AND_STATUS_CURR_CMD_SLT_MASK 0x1f00
#define  SATA_PORT_CMD_AND_STATUS_CURR_CMD_SLT_SHIFT 8
#define  SATA_PORT_CMD_AND_STATUS_CURR_CMD_SLT_MASK_SHIFT(reg) (((reg) & SATA_PORT_CMD_AND_STATUS_CURR_CMD_SLT_MASK) >> SATA_PORT_CMD_AND_STATUS_CURR_CMD_SLT_SHIFT)
#define  SATA_PORT_CMD_AND_STATUS_CURR_CMD_SLT_REPLACE_VAL(reg,val) (((reg) & ~SATA_PORT_CMD_AND_STATUS_CURR_CMD_SLT_MASK) | (((uint32_t)val) << SATA_PORT_CMD_AND_STATUS_CURR_CMD_SLT_SHIFT))

#define  SATA_PORT_CMD_AND_STATUS_RESERVED1_MASK 0xe0
#define  SATA_PORT_CMD_AND_STATUS_RESERVED1_SHIFT 5
#define  SATA_PORT_CMD_AND_STATUS_RESERVED1_MASK_SHIFT(reg) (((reg) & SATA_PORT_CMD_AND_STATUS_RESERVED1_MASK) >> SATA_PORT_CMD_AND_STATUS_RESERVED1_SHIFT)
#define  SATA_PORT_CMD_AND_STATUS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SATA_PORT_CMD_AND_STATUS_RESERVED1_MASK) | (((uint32_t)val) << SATA_PORT_CMD_AND_STATUS_RESERVED1_SHIFT))

#define  SATA_PORT_CMD_AND_STATUS_FIS_RX_EN_MASK 0x10
#define  SATA_PORT_CMD_AND_STATUS_FIS_RX_EN_SHIFT 4
#define  SATA_PORT_CMD_AND_STATUS_FIS_RX_EN_MASK_SHIFT(reg) (((reg) & SATA_PORT_CMD_AND_STATUS_FIS_RX_EN_MASK) >> SATA_PORT_CMD_AND_STATUS_FIS_RX_EN_SHIFT)
#define  SATA_PORT_CMD_AND_STATUS_FIS_RX_EN_REPLACE_VAL(reg,val) (((reg) & ~SATA_PORT_CMD_AND_STATUS_FIS_RX_EN_MASK) | (((uint32_t)val) << SATA_PORT_CMD_AND_STATUS_FIS_RX_EN_SHIFT))

#define  SATA_PORT_CMD_AND_STATUS_CMD_LIST_OVR_MASK 0x8
#define  SATA_PORT_CMD_AND_STATUS_CMD_LIST_OVR_SHIFT 3
#define  SATA_PORT_CMD_AND_STATUS_CMD_LIST_OVR_MASK_SHIFT(reg) (((reg) & SATA_PORT_CMD_AND_STATUS_CMD_LIST_OVR_MASK) >> SATA_PORT_CMD_AND_STATUS_CMD_LIST_OVR_SHIFT)
#define  SATA_PORT_CMD_AND_STATUS_CMD_LIST_OVR_REPLACE_VAL(reg,val) (((reg) & ~SATA_PORT_CMD_AND_STATUS_CMD_LIST_OVR_MASK) | (((uint32_t)val) << SATA_PORT_CMD_AND_STATUS_CMD_LIST_OVR_SHIFT))

#define  SATA_PORT_CMD_AND_STATUS_POD_SUPP_MASK 0x4
#define  SATA_PORT_CMD_AND_STATUS_POD_SUPP_SHIFT 2
#define  SATA_PORT_CMD_AND_STATUS_POD_SUPP_MASK_SHIFT(reg) (((reg) & SATA_PORT_CMD_AND_STATUS_POD_SUPP_MASK) >> SATA_PORT_CMD_AND_STATUS_POD_SUPP_SHIFT)
#define  SATA_PORT_CMD_AND_STATUS_POD_SUPP_REPLACE_VAL(reg,val) (((reg) & ~SATA_PORT_CMD_AND_STATUS_POD_SUPP_MASK) | (((uint32_t)val) << SATA_PORT_CMD_AND_STATUS_POD_SUPP_SHIFT))

#define  SATA_PORT_CMD_AND_STATUS_SPIN_UP_DEVICE_MASK 0x2
#define  SATA_PORT_CMD_AND_STATUS_SPIN_UP_DEVICE_SHIFT 1
#define  SATA_PORT_CMD_AND_STATUS_SPIN_UP_DEVICE_MASK_SHIFT(reg) (((reg) & SATA_PORT_CMD_AND_STATUS_SPIN_UP_DEVICE_MASK) >> SATA_PORT_CMD_AND_STATUS_SPIN_UP_DEVICE_SHIFT)
#define  SATA_PORT_CMD_AND_STATUS_SPIN_UP_DEVICE_REPLACE_VAL(reg,val) (((reg) & ~SATA_PORT_CMD_AND_STATUS_SPIN_UP_DEVICE_MASK) | (((uint32_t)val) << SATA_PORT_CMD_AND_STATUS_SPIN_UP_DEVICE_SHIFT))

#define  SATA_PORT_CMD_AND_STATUS_CMD_ST_MASK 0x1
#define  SATA_PORT_CMD_AND_STATUS_CMD_ST_SHIFT 0
#define  SATA_PORT_CMD_AND_STATUS_CMD_ST_MASK_SHIFT(reg) (((reg) & SATA_PORT_CMD_AND_STATUS_CMD_ST_MASK) >> SATA_PORT_CMD_AND_STATUS_CMD_ST_SHIFT)
#define  SATA_PORT_CMD_AND_STATUS_CMD_ST_REPLACE_VAL(reg,val) (((reg) & ~SATA_PORT_CMD_AND_STATUS_CMD_ST_MASK) | (((uint32_t)val) << SATA_PORT_CMD_AND_STATUS_CMD_ST_SHIFT))

//====================================================================
//Register: Port Task File Data (PORT_TASK_FILE_DATA)
//====================================================================

#define  SATA_PORT_TASK_FILE_DATA_RESERVED1_MASK 0xffff0000
#define  SATA_PORT_TASK_FILE_DATA_RESERVED1_SHIFT 16
#define  SATA_PORT_TASK_FILE_DATA_RESERVED1_MASK_SHIFT(reg) (((reg) & SATA_PORT_TASK_FILE_DATA_RESERVED1_MASK) >> SATA_PORT_TASK_FILE_DATA_RESERVED1_SHIFT)
#define  SATA_PORT_TASK_FILE_DATA_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SATA_PORT_TASK_FILE_DATA_RESERVED1_MASK) | (((uint32_t)val) << SATA_PORT_TASK_FILE_DATA_RESERVED1_SHIFT))

#define  SATA_PORT_TASK_FILE_DATA_ERR_REG_MASK 0xff00
#define  SATA_PORT_TASK_FILE_DATA_ERR_REG_SHIFT 8
#define  SATA_PORT_TASK_FILE_DATA_ERR_REG_MASK_SHIFT(reg) (((reg) & SATA_PORT_TASK_FILE_DATA_ERR_REG_MASK) >> SATA_PORT_TASK_FILE_DATA_ERR_REG_SHIFT)
#define  SATA_PORT_TASK_FILE_DATA_ERR_REG_REPLACE_VAL(reg,val) (((reg) & ~SATA_PORT_TASK_FILE_DATA_ERR_REG_MASK) | (((uint32_t)val) << SATA_PORT_TASK_FILE_DATA_ERR_REG_SHIFT))

#define  SATA_PORT_TASK_FILE_DATA_STATUS_REG_MASK 0xff
#define  SATA_PORT_TASK_FILE_DATA_STATUS_REG_SHIFT 0
#define  SATA_PORT_TASK_FILE_DATA_STATUS_REG_MASK_SHIFT(reg) (((reg) & SATA_PORT_TASK_FILE_DATA_STATUS_REG_MASK) >> SATA_PORT_TASK_FILE_DATA_STATUS_REG_SHIFT)
#define  SATA_PORT_TASK_FILE_DATA_STATUS_REG_REPLACE_VAL(reg,val) (((reg) & ~SATA_PORT_TASK_FILE_DATA_STATUS_REG_MASK) | (((uint32_t)val) << SATA_PORT_TASK_FILE_DATA_STATUS_REG_SHIFT))

//====================================================================
//Register: Port Signature (PORT_SIGNATURE)
//====================================================================

#define  SATA_PORT_SIGNATURE_LBA_HIGH_MASK 0xff000000
#define  SATA_PORT_SIGNATURE_LBA_HIGH_SHIFT 24
#define  SATA_PORT_SIGNATURE_LBA_HIGH_MASK_SHIFT(reg) (((reg) & SATA_PORT_SIGNATURE_LBA_HIGH_MASK) >> SATA_PORT_SIGNATURE_LBA_HIGH_SHIFT)
#define  SATA_PORT_SIGNATURE_LBA_HIGH_REPLACE_VAL(reg,val) (((reg) & ~SATA_PORT_SIGNATURE_LBA_HIGH_MASK) | (((uint32_t)val) << SATA_PORT_SIGNATURE_LBA_HIGH_SHIFT))

#define  SATA_PORT_SIGNATURE_LBA_MID_MASK 0xff0000
#define  SATA_PORT_SIGNATURE_LBA_MID_SHIFT 16
#define  SATA_PORT_SIGNATURE_LBA_MID_MASK_SHIFT(reg) (((reg) & SATA_PORT_SIGNATURE_LBA_MID_MASK) >> SATA_PORT_SIGNATURE_LBA_MID_SHIFT)
#define  SATA_PORT_SIGNATURE_LBA_MID_REPLACE_VAL(reg,val) (((reg) & ~SATA_PORT_SIGNATURE_LBA_MID_MASK) | (((uint32_t)val) << SATA_PORT_SIGNATURE_LBA_MID_SHIFT))

#define  SATA_PORT_SIGNATURE_LBA_LOW_MASK 0xff00
#define  SATA_PORT_SIGNATURE_LBA_LOW_SHIFT 8
#define  SATA_PORT_SIGNATURE_LBA_LOW_MASK_SHIFT(reg) (((reg) & SATA_PORT_SIGNATURE_LBA_LOW_MASK) >> SATA_PORT_SIGNATURE_LBA_LOW_SHIFT)
#define  SATA_PORT_SIGNATURE_LBA_LOW_REPLACE_VAL(reg,val) (((reg) & ~SATA_PORT_SIGNATURE_LBA_LOW_MASK) | (((uint32_t)val) << SATA_PORT_SIGNATURE_LBA_LOW_SHIFT))

#define  SATA_PORT_SIGNATURE_SECTOR_CNT_MASK 0xff
#define  SATA_PORT_SIGNATURE_SECTOR_CNT_SHIFT 0
#define  SATA_PORT_SIGNATURE_SECTOR_CNT_MASK_SHIFT(reg) (((reg) & SATA_PORT_SIGNATURE_SECTOR_CNT_MASK) >> SATA_PORT_SIGNATURE_SECTOR_CNT_SHIFT)
#define  SATA_PORT_SIGNATURE_SECTOR_CNT_REPLACE_VAL(reg,val) (((reg) & ~SATA_PORT_SIGNATURE_SECTOR_CNT_MASK) | (((uint32_t)val) << SATA_PORT_SIGNATURE_SECTOR_CNT_SHIFT))

//====================================================================
//Register: SATA Status (SSTATUS_SCR0)
//====================================================================

#define  SATA_SSTATUS_SCR0_RESERVED1_MASK 0xfffff000
#define  SATA_SSTATUS_SCR0_RESERVED1_SHIFT 12
#define  SATA_SSTATUS_SCR0_RESERVED1_MASK_SHIFT(reg) (((reg) & SATA_SSTATUS_SCR0_RESERVED1_MASK) >> SATA_SSTATUS_SCR0_RESERVED1_SHIFT)
#define  SATA_SSTATUS_SCR0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SATA_SSTATUS_SCR0_RESERVED1_MASK) | (((uint32_t)val) << SATA_SSTATUS_SCR0_RESERVED1_SHIFT))

#define  SATA_SSTATUS_SCR0_IPM_SCR0_MASK 0xf00
#define  SATA_SSTATUS_SCR0_IPM_SCR0_SHIFT 8
#define  SATA_SSTATUS_SCR0_IPM_SCR0_MASK_SHIFT(reg) (((reg) & SATA_SSTATUS_SCR0_IPM_SCR0_MASK) >> SATA_SSTATUS_SCR0_IPM_SCR0_SHIFT)
#define  SATA_SSTATUS_SCR0_IPM_SCR0_REPLACE_VAL(reg,val) (((reg) & ~SATA_SSTATUS_SCR0_IPM_SCR0_MASK) | (((uint32_t)val) << SATA_SSTATUS_SCR0_IPM_SCR0_SHIFT))

#define  SATA_SSTATUS_SCR0_SPD_SCR0_MASK 0xf0
#define  SATA_SSTATUS_SCR0_SPD_SCR0_SHIFT 4
#define  SATA_SSTATUS_SCR0_SPD_SCR0_MASK_SHIFT(reg) (((reg) & SATA_SSTATUS_SCR0_SPD_SCR0_MASK) >> SATA_SSTATUS_SCR0_SPD_SCR0_SHIFT)
#define  SATA_SSTATUS_SCR0_SPD_SCR0_REPLACE_VAL(reg,val) (((reg) & ~SATA_SSTATUS_SCR0_SPD_SCR0_MASK) | (((uint32_t)val) << SATA_SSTATUS_SCR0_SPD_SCR0_SHIFT))

#define  SATA_SSTATUS_SCR0_DET_SCR0_MASK 0xf
#define  SATA_SSTATUS_SCR0_DET_SCR0_SHIFT 0
#define  SATA_SSTATUS_SCR0_DET_SCR0_MASK_SHIFT(reg) (((reg) & SATA_SSTATUS_SCR0_DET_SCR0_MASK) >> SATA_SSTATUS_SCR0_DET_SCR0_SHIFT)
#define  SATA_SSTATUS_SCR0_DET_SCR0_REPLACE_VAL(reg,val) (((reg) & ~SATA_SSTATUS_SCR0_DET_SCR0_MASK) | (((uint32_t)val) << SATA_SSTATUS_SCR0_DET_SCR0_SHIFT))

//====================================================================
//Register: SATA Control (SCONTROL_SCR2)
//====================================================================

#define  SATA_SCONTROL_SCR2_RESERVED1_MASK 0xfff00000
#define  SATA_SCONTROL_SCR2_RESERVED1_SHIFT 20
#define  SATA_SCONTROL_SCR2_RESERVED1_MASK_SHIFT(reg) (((reg) & SATA_SCONTROL_SCR2_RESERVED1_MASK) >> SATA_SCONTROL_SCR2_RESERVED1_SHIFT)
#define  SATA_SCONTROL_SCR2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SATA_SCONTROL_SCR2_RESERVED1_MASK) | (((uint32_t)val) << SATA_SCONTROL_SCR2_RESERVED1_SHIFT))

#define  SATA_SCONTROL_SCR2_PORT_MULT_PORT_MASK 0xf0000
#define  SATA_SCONTROL_SCR2_PORT_MULT_PORT_SHIFT 16
#define  SATA_SCONTROL_SCR2_PORT_MULT_PORT_MASK_SHIFT(reg) (((reg) & SATA_SCONTROL_SCR2_PORT_MULT_PORT_MASK) >> SATA_SCONTROL_SCR2_PORT_MULT_PORT_SHIFT)
#define  SATA_SCONTROL_SCR2_PORT_MULT_PORT_REPLACE_VAL(reg,val) (((reg) & ~SATA_SCONTROL_SCR2_PORT_MULT_PORT_MASK) | (((uint32_t)val) << SATA_SCONTROL_SCR2_PORT_MULT_PORT_SHIFT))

#define  SATA_SCONTROL_SCR2_SEL_PWR_MGMT_MASK 0xf000
#define  SATA_SCONTROL_SCR2_SEL_PWR_MGMT_SHIFT 12
#define  SATA_SCONTROL_SCR2_SEL_PWR_MGMT_MASK_SHIFT(reg) (((reg) & SATA_SCONTROL_SCR2_SEL_PWR_MGMT_MASK) >> SATA_SCONTROL_SCR2_SEL_PWR_MGMT_SHIFT)
#define  SATA_SCONTROL_SCR2_SEL_PWR_MGMT_REPLACE_VAL(reg,val) (((reg) & ~SATA_SCONTROL_SCR2_SEL_PWR_MGMT_MASK) | (((uint32_t)val) << SATA_SCONTROL_SCR2_SEL_PWR_MGMT_SHIFT))

#define  SATA_SCONTROL_SCR2_IPM_SCR2_MASK 0xf00
#define  SATA_SCONTROL_SCR2_IPM_SCR2_SHIFT 8
#define  SATA_SCONTROL_SCR2_IPM_SCR2_MASK_SHIFT(reg) (((reg) & SATA_SCONTROL_SCR2_IPM_SCR2_MASK) >> SATA_SCONTROL_SCR2_IPM_SCR2_SHIFT)
#define  SATA_SCONTROL_SCR2_IPM_SCR2_REPLACE_VAL(reg,val) (((reg) & ~SATA_SCONTROL_SCR2_IPM_SCR2_MASK) | (((uint32_t)val) << SATA_SCONTROL_SCR2_IPM_SCR2_SHIFT))

#define  SATA_SCONTROL_SCR2_SPD_SCR2_MASK 0xf0
#define  SATA_SCONTROL_SCR2_SPD_SCR2_SHIFT 4
#define  SATA_SCONTROL_SCR2_SPD_SCR2_MASK_SHIFT(reg) (((reg) & SATA_SCONTROL_SCR2_SPD_SCR2_MASK) >> SATA_SCONTROL_SCR2_SPD_SCR2_SHIFT)
#define  SATA_SCONTROL_SCR2_SPD_SCR2_REPLACE_VAL(reg,val) (((reg) & ~SATA_SCONTROL_SCR2_SPD_SCR2_MASK) | (((uint32_t)val) << SATA_SCONTROL_SCR2_SPD_SCR2_SHIFT))

#define  SATA_SCONTROL_SCR2_DET_SCR2_MASK 0xf
#define  SATA_SCONTROL_SCR2_DET_SCR2_SHIFT 0
#define  SATA_SCONTROL_SCR2_DET_SCR2_MASK_SHIFT(reg) (((reg) & SATA_SCONTROL_SCR2_DET_SCR2_MASK) >> SATA_SCONTROL_SCR2_DET_SCR2_SHIFT)
#define  SATA_SCONTROL_SCR2_DET_SCR2_REPLACE_VAL(reg,val) (((reg) & ~SATA_SCONTROL_SCR2_DET_SCR2_MASK) | (((uint32_t)val) << SATA_SCONTROL_SCR2_DET_SCR2_SHIFT))

//====================================================================
//Register: Serial ATA Error (SERROR_SCR1)
//====================================================================

#define  SATA_SERROR_SCR1_RESERVED1_MASK 0xf8000000
#define  SATA_SERROR_SCR1_RESERVED1_SHIFT 27
#define  SATA_SERROR_SCR1_RESERVED1_MASK_SHIFT(reg) (((reg) & SATA_SERROR_SCR1_RESERVED1_MASK) >> SATA_SERROR_SCR1_RESERVED1_SHIFT)
#define  SATA_SERROR_SCR1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SATA_SERROR_SCR1_RESERVED1_MASK) | (((uint32_t)val) << SATA_SERROR_SCR1_RESERVED1_SHIFT))

#define  SATA_SERROR_SCR1_DEV_PRES_EXCH_MASK 0x4000000
#define  SATA_SERROR_SCR1_DEV_PRES_EXCH_SHIFT 26
#define  SATA_SERROR_SCR1_DEV_PRES_EXCH_MASK_SHIFT(reg) (((reg) & SATA_SERROR_SCR1_DEV_PRES_EXCH_MASK) >> SATA_SERROR_SCR1_DEV_PRES_EXCH_SHIFT)
#define  SATA_SERROR_SCR1_DEV_PRES_EXCH_REPLACE_VAL(reg,val) (((reg) & ~SATA_SERROR_SCR1_DEV_PRES_EXCH_MASK) | (((uint32_t)val) << SATA_SERROR_SCR1_DEV_PRES_EXCH_SHIFT))

#define  SATA_SERROR_SCR1_UNKNOWN_FIS_TYPE_MASK 0x2000000
#define  SATA_SERROR_SCR1_UNKNOWN_FIS_TYPE_SHIFT 25
#define  SATA_SERROR_SCR1_UNKNOWN_FIS_TYPE_MASK_SHIFT(reg) (((reg) & SATA_SERROR_SCR1_UNKNOWN_FIS_TYPE_MASK) >> SATA_SERROR_SCR1_UNKNOWN_FIS_TYPE_SHIFT)
#define  SATA_SERROR_SCR1_UNKNOWN_FIS_TYPE_REPLACE_VAL(reg,val) (((reg) & ~SATA_SERROR_SCR1_UNKNOWN_FIS_TYPE_MASK) | (((uint32_t)val) << SATA_SERROR_SCR1_UNKNOWN_FIS_TYPE_SHIFT))

#define  SATA_SERROR_SCR1_TPORT_TRANS_ERR_MASK 0x1000000
#define  SATA_SERROR_SCR1_TPORT_TRANS_ERR_SHIFT 24
#define  SATA_SERROR_SCR1_TPORT_TRANS_ERR_MASK_SHIFT(reg) (((reg) & SATA_SERROR_SCR1_TPORT_TRANS_ERR_MASK) >> SATA_SERROR_SCR1_TPORT_TRANS_ERR_SHIFT)
#define  SATA_SERROR_SCR1_TPORT_TRANS_ERR_REPLACE_VAL(reg,val) (((reg) & ~SATA_SERROR_SCR1_TPORT_TRANS_ERR_MASK) | (((uint32_t)val) << SATA_SERROR_SCR1_TPORT_TRANS_ERR_SHIFT))

#define  SATA_SERROR_SCR1_LINK_SEQ_ERR_MASK 0x800000
#define  SATA_SERROR_SCR1_LINK_SEQ_ERR_SHIFT 23
#define  SATA_SERROR_SCR1_LINK_SEQ_ERR_MASK_SHIFT(reg) (((reg) & SATA_SERROR_SCR1_LINK_SEQ_ERR_MASK) >> SATA_SERROR_SCR1_LINK_SEQ_ERR_SHIFT)
#define  SATA_SERROR_SCR1_LINK_SEQ_ERR_REPLACE_VAL(reg,val) (((reg) & ~SATA_SERROR_SCR1_LINK_SEQ_ERR_MASK) | (((uint32_t)val) << SATA_SERROR_SCR1_LINK_SEQ_ERR_SHIFT))

#define  SATA_SERROR_SCR1_HANDSHK_ERR_MASK 0x400000
#define  SATA_SERROR_SCR1_HANDSHK_ERR_SHIFT 22
#define  SATA_SERROR_SCR1_HANDSHK_ERR_MASK_SHIFT(reg) (((reg) & SATA_SERROR_SCR1_HANDSHK_ERR_MASK) >> SATA_SERROR_SCR1_HANDSHK_ERR_SHIFT)
#define  SATA_SERROR_SCR1_HANDSHK_ERR_REPLACE_VAL(reg,val) (((reg) & ~SATA_SERROR_SCR1_HANDSHK_ERR_MASK) | (((uint32_t)val) << SATA_SERROR_SCR1_HANDSHK_ERR_SHIFT))

#define  SATA_SERROR_SCR1_CRC_ERR_MASK 0x200000
#define  SATA_SERROR_SCR1_CRC_ERR_SHIFT 21
#define  SATA_SERROR_SCR1_CRC_ERR_MASK_SHIFT(reg) (((reg) & SATA_SERROR_SCR1_CRC_ERR_MASK) >> SATA_SERROR_SCR1_CRC_ERR_SHIFT)
#define  SATA_SERROR_SCR1_CRC_ERR_REPLACE_VAL(reg,val) (((reg) & ~SATA_SERROR_SCR1_CRC_ERR_MASK) | (((uint32_t)val) << SATA_SERROR_SCR1_CRC_ERR_SHIFT))

#define  SATA_SERROR_SCR1_DISP_ERR_MASK 0x100000
#define  SATA_SERROR_SCR1_DISP_ERR_SHIFT 20
#define  SATA_SERROR_SCR1_DISP_ERR_MASK_SHIFT(reg) (((reg) & SATA_SERROR_SCR1_DISP_ERR_MASK) >> SATA_SERROR_SCR1_DISP_ERR_SHIFT)
#define  SATA_SERROR_SCR1_DISP_ERR_REPLACE_VAL(reg,val) (((reg) & ~SATA_SERROR_SCR1_DISP_ERR_MASK) | (((uint32_t)val) << SATA_SERROR_SCR1_DISP_ERR_SHIFT))

#define  SATA_SERROR_SCR1__10B_8B_DEC_ERR_MASK 0x80000
#define  SATA_SERROR_SCR1__10B_8B_DEC_ERR_SHIFT 19
#define  SATA_SERROR_SCR1__10B_8B_DEC_ERR_MASK_SHIFT(reg) (((reg) & SATA_SERROR_SCR1__10B_8B_DEC_ERR_MASK) >> SATA_SERROR_SCR1__10B_8B_DEC_ERR_SHIFT)
#define  SATA_SERROR_SCR1__10B_8B_DEC_ERR_REPLACE_VAL(reg,val) (((reg) & ~SATA_SERROR_SCR1__10B_8B_DEC_ERR_MASK) | (((uint32_t)val) << SATA_SERROR_SCR1__10B_8B_DEC_ERR_SHIFT))

#define  SATA_SERROR_SCR1_COMWAKE_ERR_MASK 0x40000
#define  SATA_SERROR_SCR1_COMWAKE_ERR_SHIFT 18
#define  SATA_SERROR_SCR1_COMWAKE_ERR_MASK_SHIFT(reg) (((reg) & SATA_SERROR_SCR1_COMWAKE_ERR_MASK) >> SATA_SERROR_SCR1_COMWAKE_ERR_SHIFT)
#define  SATA_SERROR_SCR1_COMWAKE_ERR_REPLACE_VAL(reg,val) (((reg) & ~SATA_SERROR_SCR1_COMWAKE_ERR_MASK) | (((uint32_t)val) << SATA_SERROR_SCR1_COMWAKE_ERR_SHIFT))

#define  SATA_SERROR_SCR1_PHY_INT_ERR_MASK 0x20000
#define  SATA_SERROR_SCR1_PHY_INT_ERR_SHIFT 17
#define  SATA_SERROR_SCR1_PHY_INT_ERR_MASK_SHIFT(reg) (((reg) & SATA_SERROR_SCR1_PHY_INT_ERR_MASK) >> SATA_SERROR_SCR1_PHY_INT_ERR_SHIFT)
#define  SATA_SERROR_SCR1_PHY_INT_ERR_REPLACE_VAL(reg,val) (((reg) & ~SATA_SERROR_SCR1_PHY_INT_ERR_MASK) | (((uint32_t)val) << SATA_SERROR_SCR1_PHY_INT_ERR_SHIFT))

#define  SATA_SERROR_SCR1_PHYRDY_CHG_MASK 0x10000
#define  SATA_SERROR_SCR1_PHYRDY_CHG_SHIFT 16
#define  SATA_SERROR_SCR1_PHYRDY_CHG_MASK_SHIFT(reg) (((reg) & SATA_SERROR_SCR1_PHYRDY_CHG_MASK) >> SATA_SERROR_SCR1_PHYRDY_CHG_SHIFT)
#define  SATA_SERROR_SCR1_PHYRDY_CHG_REPLACE_VAL(reg,val) (((reg) & ~SATA_SERROR_SCR1_PHYRDY_CHG_MASK) | (((uint32_t)val) << SATA_SERROR_SCR1_PHYRDY_CHG_SHIFT))

#define  SATA_SERROR_SCR1_ERR_SCR1_MASK 0xffff
#define  SATA_SERROR_SCR1_ERR_SCR1_SHIFT 0
#define  SATA_SERROR_SCR1_ERR_SCR1_MASK_SHIFT(reg) (((reg) & SATA_SERROR_SCR1_ERR_SCR1_MASK) >> SATA_SERROR_SCR1_ERR_SCR1_SHIFT)
#define  SATA_SERROR_SCR1_ERR_SCR1_REPLACE_VAL(reg,val) (((reg) & ~SATA_SERROR_SCR1_ERR_SCR1_MASK) | (((uint32_t)val) << SATA_SERROR_SCR1_ERR_SCR1_SHIFT))

//====================================================================
//Register: SATA Active (SACTIVE_SCR3)
//====================================================================

#define  SATA_SACTIVE_SCR3_DEVICE_ST_SCR3_MASK 0xffffffff
#define  SATA_SACTIVE_SCR3_DEVICE_ST_SCR3_SHIFT 0
#define  SATA_SACTIVE_SCR3_DEVICE_ST_SCR3_MASK_SHIFT(reg) (((reg) & SATA_SACTIVE_SCR3_DEVICE_ST_SCR3_MASK) >> SATA_SACTIVE_SCR3_DEVICE_ST_SCR3_SHIFT)
#define  SATA_SACTIVE_SCR3_DEVICE_ST_SCR3_REPLACE_VAL(reg,val) (((reg) & ~SATA_SACTIVE_SCR3_DEVICE_ST_SCR3_MASK) | (((uint32_t)val) << SATA_SACTIVE_SCR3_DEVICE_ST_SCR3_SHIFT))

//====================================================================
//Register: Command Issue (CMD_ISSUE)
//====================================================================

#define  SATA_CMD_ISSUE_CMD_ISSUE_MASK 0xffffffff
#define  SATA_CMD_ISSUE_CMD_ISSUE_SHIFT 0
#define  SATA_CMD_ISSUE_CMD_ISSUE_MASK_SHIFT(reg) (((reg) & SATA_CMD_ISSUE_CMD_ISSUE_MASK) >> SATA_CMD_ISSUE_CMD_ISSUE_SHIFT)
#define  SATA_CMD_ISSUE_CMD_ISSUE_REPLACE_VAL(reg,val) (((reg) & ~SATA_CMD_ISSUE_CMD_ISSUE_MASK) | (((uint32_t)val) << SATA_CMD_ISSUE_CMD_ISSUE_SHIFT))

//====================================================================
//Register: Port Serial ATA Notification (SNOTIFICATION_SCR4)
//====================================================================

#define  SATA_SNOTIFICATION_SCR4_RESERVED1_MASK 0xffff0000
#define  SATA_SNOTIFICATION_SCR4_RESERVED1_SHIFT 16
#define  SATA_SNOTIFICATION_SCR4_RESERVED1_MASK_SHIFT(reg) (((reg) & SATA_SNOTIFICATION_SCR4_RESERVED1_MASK) >> SATA_SNOTIFICATION_SCR4_RESERVED1_SHIFT)
#define  SATA_SNOTIFICATION_SCR4_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SATA_SNOTIFICATION_SCR4_RESERVED1_MASK) | (((uint32_t)val) << SATA_SNOTIFICATION_SCR4_RESERVED1_SHIFT))

#define  SATA_SNOTIFICATION_SCR4_PM_NOTIFY_MASK 0xffff
#define  SATA_SNOTIFICATION_SCR4_PM_NOTIFY_SHIFT 0
#define  SATA_SNOTIFICATION_SCR4_PM_NOTIFY_MASK_SHIFT(reg) (((reg) & SATA_SNOTIFICATION_SCR4_PM_NOTIFY_MASK) >> SATA_SNOTIFICATION_SCR4_PM_NOTIFY_SHIFT)
#define  SATA_SNOTIFICATION_SCR4_PM_NOTIFY_REPLACE_VAL(reg,val) (((reg) & ~SATA_SNOTIFICATION_SCR4_PM_NOTIFY_MASK) | (((uint32_t)val) << SATA_SNOTIFICATION_SCR4_PM_NOTIFY_SHIFT))

//====================================================================
//Register: Port FIS Based Switching Control (PORT_FIS_BASED_SWITCH_CTRL)
//====================================================================

#define  SATA_PORT_FIS_BASED_SWITCH_CTRL_RESERVED1_MASK 0xfff00000
#define  SATA_PORT_FIS_BASED_SWITCH_CTRL_RESERVED1_SHIFT 20
#define  SATA_PORT_FIS_BASED_SWITCH_CTRL_RESERVED1_MASK_SHIFT(reg) (((reg) & SATA_PORT_FIS_BASED_SWITCH_CTRL_RESERVED1_MASK) >> SATA_PORT_FIS_BASED_SWITCH_CTRL_RESERVED1_SHIFT)
#define  SATA_PORT_FIS_BASED_SWITCH_CTRL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SATA_PORT_FIS_BASED_SWITCH_CTRL_RESERVED1_MASK) | (((uint32_t)val) << SATA_PORT_FIS_BASED_SWITCH_CTRL_RESERVED1_SHIFT))

#define  SATA_PORT_FIS_BASED_SWITCH_CTRL_PM_DEV_W_ERR_MASK 0xf0000
#define  SATA_PORT_FIS_BASED_SWITCH_CTRL_PM_DEV_W_ERR_SHIFT 16
#define  SATA_PORT_FIS_BASED_SWITCH_CTRL_PM_DEV_W_ERR_MASK_SHIFT(reg) (((reg) & SATA_PORT_FIS_BASED_SWITCH_CTRL_PM_DEV_W_ERR_MASK) >> SATA_PORT_FIS_BASED_SWITCH_CTRL_PM_DEV_W_ERR_SHIFT)
#define  SATA_PORT_FIS_BASED_SWITCH_CTRL_PM_DEV_W_ERR_REPLACE_VAL(reg,val) (((reg) & ~SATA_PORT_FIS_BASED_SWITCH_CTRL_PM_DEV_W_ERR_MASK) | (((uint32_t)val) << SATA_PORT_FIS_BASED_SWITCH_CTRL_PM_DEV_W_ERR_SHIFT))

#define  SATA_PORT_FIS_BASED_SWITCH_CTRL_ACT_DEV_OPT_MASK 0xf000
#define  SATA_PORT_FIS_BASED_SWITCH_CTRL_ACT_DEV_OPT_SHIFT 12
#define  SATA_PORT_FIS_BASED_SWITCH_CTRL_ACT_DEV_OPT_MASK_SHIFT(reg) (((reg) & SATA_PORT_FIS_BASED_SWITCH_CTRL_ACT_DEV_OPT_MASK) >> SATA_PORT_FIS_BASED_SWITCH_CTRL_ACT_DEV_OPT_SHIFT)
#define  SATA_PORT_FIS_BASED_SWITCH_CTRL_ACT_DEV_OPT_REPLACE_VAL(reg,val) (((reg) & ~SATA_PORT_FIS_BASED_SWITCH_CTRL_ACT_DEV_OPT_MASK) | (((uint32_t)val) << SATA_PORT_FIS_BASED_SWITCH_CTRL_ACT_DEV_OPT_SHIFT))

#define  SATA_PORT_FIS_BASED_SWITCH_CTRL_PM_DEV_TO_ISSUE_MASK 0xf00
#define  SATA_PORT_FIS_BASED_SWITCH_CTRL_PM_DEV_TO_ISSUE_SHIFT 8
#define  SATA_PORT_FIS_BASED_SWITCH_CTRL_PM_DEV_TO_ISSUE_MASK_SHIFT(reg) (((reg) & SATA_PORT_FIS_BASED_SWITCH_CTRL_PM_DEV_TO_ISSUE_MASK) >> SATA_PORT_FIS_BASED_SWITCH_CTRL_PM_DEV_TO_ISSUE_SHIFT)
#define  SATA_PORT_FIS_BASED_SWITCH_CTRL_PM_DEV_TO_ISSUE_REPLACE_VAL(reg,val) (((reg) & ~SATA_PORT_FIS_BASED_SWITCH_CTRL_PM_DEV_TO_ISSUE_MASK) | (((uint32_t)val) << SATA_PORT_FIS_BASED_SWITCH_CTRL_PM_DEV_TO_ISSUE_SHIFT))

#define  SATA_PORT_FIS_BASED_SWITCH_CTRL_RESERVED2_MASK 0xf8
#define  SATA_PORT_FIS_BASED_SWITCH_CTRL_RESERVED2_SHIFT 3
#define  SATA_PORT_FIS_BASED_SWITCH_CTRL_RESERVED2_MASK_SHIFT(reg) (((reg) & SATA_PORT_FIS_BASED_SWITCH_CTRL_RESERVED2_MASK) >> SATA_PORT_FIS_BASED_SWITCH_CTRL_RESERVED2_SHIFT)
#define  SATA_PORT_FIS_BASED_SWITCH_CTRL_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SATA_PORT_FIS_BASED_SWITCH_CTRL_RESERVED2_MASK) | (((uint32_t)val) << SATA_PORT_FIS_BASED_SWITCH_CTRL_RESERVED2_SHIFT))

#define  SATA_PORT_FIS_BASED_SWITCH_CTRL_SING_DEV_ERR_MASK 0x4
#define  SATA_PORT_FIS_BASED_SWITCH_CTRL_SING_DEV_ERR_SHIFT 2
#define  SATA_PORT_FIS_BASED_SWITCH_CTRL_SING_DEV_ERR_MASK_SHIFT(reg) (((reg) & SATA_PORT_FIS_BASED_SWITCH_CTRL_SING_DEV_ERR_MASK) >> SATA_PORT_FIS_BASED_SWITCH_CTRL_SING_DEV_ERR_SHIFT)
#define  SATA_PORT_FIS_BASED_SWITCH_CTRL_SING_DEV_ERR_REPLACE_VAL(reg,val) (((reg) & ~SATA_PORT_FIS_BASED_SWITCH_CTRL_SING_DEV_ERR_MASK) | (((uint32_t)val) << SATA_PORT_FIS_BASED_SWITCH_CTRL_SING_DEV_ERR_SHIFT))

#define  SATA_PORT_FIS_BASED_SWITCH_CTRL_DEV_ERR_CLR_MASK 0x2
#define  SATA_PORT_FIS_BASED_SWITCH_CTRL_DEV_ERR_CLR_SHIFT 1
#define  SATA_PORT_FIS_BASED_SWITCH_CTRL_DEV_ERR_CLR_MASK_SHIFT(reg) (((reg) & SATA_PORT_FIS_BASED_SWITCH_CTRL_DEV_ERR_CLR_MASK) >> SATA_PORT_FIS_BASED_SWITCH_CTRL_DEV_ERR_CLR_SHIFT)
#define  SATA_PORT_FIS_BASED_SWITCH_CTRL_DEV_ERR_CLR_REPLACE_VAL(reg,val) (((reg) & ~SATA_PORT_FIS_BASED_SWITCH_CTRL_DEV_ERR_CLR_MASK) | (((uint32_t)val) << SATA_PORT_FIS_BASED_SWITCH_CTRL_DEV_ERR_CLR_SHIFT))

#define  SATA_PORT_FIS_BASED_SWITCH_CTRL_PM_EN_MASK 0x1
#define  SATA_PORT_FIS_BASED_SWITCH_CTRL_PM_EN_SHIFT 0
#define  SATA_PORT_FIS_BASED_SWITCH_CTRL_PM_EN_MASK_SHIFT(reg) (((reg) & SATA_PORT_FIS_BASED_SWITCH_CTRL_PM_EN_MASK) >> SATA_PORT_FIS_BASED_SWITCH_CTRL_PM_EN_SHIFT)
#define  SATA_PORT_FIS_BASED_SWITCH_CTRL_PM_EN_REPLACE_VAL(reg,val) (((reg) & ~SATA_PORT_FIS_BASED_SWITCH_CTRL_PM_EN_MASK) | (((uint32_t)val) << SATA_PORT_FIS_BASED_SWITCH_CTRL_PM_EN_SHIFT))

//====================================================================
//Register: Port 0 Command LBA Table Base Address Lower 32-bits (PORT0_CMD_LBA_BASE_ADDR_LOW_32B)
//====================================================================

#define  SATA_PORT0_CMD_LBA_BASE_ADDR_LOW_32B_PORT_LBA_ADDR_31_1_MASK 0xfffffffe
#define  SATA_PORT0_CMD_LBA_BASE_ADDR_LOW_32B_PORT_LBA_ADDR_31_1_SHIFT 1
#define  SATA_PORT0_CMD_LBA_BASE_ADDR_LOW_32B_PORT_LBA_ADDR_31_1_MASK_SHIFT(reg) (((reg) & SATA_PORT0_CMD_LBA_BASE_ADDR_LOW_32B_PORT_LBA_ADDR_31_1_MASK) >> SATA_PORT0_CMD_LBA_BASE_ADDR_LOW_32B_PORT_LBA_ADDR_31_1_SHIFT)
#define  SATA_PORT0_CMD_LBA_BASE_ADDR_LOW_32B_PORT_LBA_ADDR_31_1_REPLACE_VAL(reg,val) (((reg) & ~SATA_PORT0_CMD_LBA_BASE_ADDR_LOW_32B_PORT_LBA_ADDR_31_1_MASK) | (((uint32_t)val) << SATA_PORT0_CMD_LBA_BASE_ADDR_LOW_32B_PORT_LBA_ADDR_31_1_SHIFT))

#define  SATA_PORT0_CMD_LBA_BASE_ADDR_LOW_32B_PORT_LBA_ADDR_0_MASK 0x1
#define  SATA_PORT0_CMD_LBA_BASE_ADDR_LOW_32B_PORT_LBA_ADDR_0_SHIFT 0
#define  SATA_PORT0_CMD_LBA_BASE_ADDR_LOW_32B_PORT_LBA_ADDR_0_MASK_SHIFT(reg) (((reg) & SATA_PORT0_CMD_LBA_BASE_ADDR_LOW_32B_PORT_LBA_ADDR_0_MASK) >> SATA_PORT0_CMD_LBA_BASE_ADDR_LOW_32B_PORT_LBA_ADDR_0_SHIFT)
#define  SATA_PORT0_CMD_LBA_BASE_ADDR_LOW_32B_PORT_LBA_ADDR_0_REPLACE_VAL(reg,val) (((reg) & ~SATA_PORT0_CMD_LBA_BASE_ADDR_LOW_32B_PORT_LBA_ADDR_0_MASK) | (((uint32_t)val) << SATA_PORT0_CMD_LBA_BASE_ADDR_LOW_32B_PORT_LBA_ADDR_0_SHIFT))

//====================================================================
//Register: Vendor Specified Interrupt Control (VDR_SPECIFIED_INT_CTRL)
//====================================================================

#define  SATA_VDR_SPECIFIED_INT_CTRL_VEN_SPEC_INT_EN_MASK 0x80000000
#define  SATA_VDR_SPECIFIED_INT_CTRL_VEN_SPEC_INT_EN_SHIFT 31
#define  SATA_VDR_SPECIFIED_INT_CTRL_VEN_SPEC_INT_EN_MASK_SHIFT(reg) (((reg) & SATA_VDR_SPECIFIED_INT_CTRL_VEN_SPEC_INT_EN_MASK) >> SATA_VDR_SPECIFIED_INT_CTRL_VEN_SPEC_INT_EN_SHIFT)
#define  SATA_VDR_SPECIFIED_INT_CTRL_VEN_SPEC_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~SATA_VDR_SPECIFIED_INT_CTRL_VEN_SPEC_INT_EN_MASK) | (((uint32_t)val) << SATA_VDR_SPECIFIED_INT_CTRL_VEN_SPEC_INT_EN_SHIFT))

#define  SATA_VDR_SPECIFIED_INT_CTRL_RESERVED1_MASK 0x7fffffff
#define  SATA_VDR_SPECIFIED_INT_CTRL_RESERVED1_SHIFT 0
#define  SATA_VDR_SPECIFIED_INT_CTRL_RESERVED1_MASK_SHIFT(reg) (((reg) & SATA_VDR_SPECIFIED_INT_CTRL_RESERVED1_MASK) >> SATA_VDR_SPECIFIED_INT_CTRL_RESERVED1_SHIFT)
#define  SATA_VDR_SPECIFIED_INT_CTRL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SATA_VDR_SPECIFIED_INT_CTRL_RESERVED1_MASK) | (((uint32_t)val) << SATA_VDR_SPECIFIED_INT_CTRL_RESERVED1_SHIFT))

//====================================================================
//Register: Indirect Access Port PHY Address (IND_ACCS_PORT_PHY_ADDR)
//====================================================================

#define  SATA_IND_ACCS_PORT_PHY_ADDR_RESERVED1_MASK 0xfffffe00
#define  SATA_IND_ACCS_PORT_PHY_ADDR_RESERVED1_SHIFT 9
#define  SATA_IND_ACCS_PORT_PHY_ADDR_RESERVED1_MASK_SHIFT(reg) (((reg) & SATA_IND_ACCS_PORT_PHY_ADDR_RESERVED1_MASK) >> SATA_IND_ACCS_PORT_PHY_ADDR_RESERVED1_SHIFT)
#define  SATA_IND_ACCS_PORT_PHY_ADDR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SATA_IND_ACCS_PORT_PHY_ADDR_RESERVED1_MASK) | (((uint32_t)val) << SATA_IND_ACCS_PORT_PHY_ADDR_RESERVED1_SHIFT))

#define  SATA_IND_ACCS_PORT_PHY_ADDR_INT_REG_ACCESS_MASK 0x100
#define  SATA_IND_ACCS_PORT_PHY_ADDR_INT_REG_ACCESS_SHIFT 8
#define  SATA_IND_ACCS_PORT_PHY_ADDR_INT_REG_ACCESS_MASK_SHIFT(reg) (((reg) & SATA_IND_ACCS_PORT_PHY_ADDR_INT_REG_ACCESS_MASK) >> SATA_IND_ACCS_PORT_PHY_ADDR_INT_REG_ACCESS_SHIFT)
#define  SATA_IND_ACCS_PORT_PHY_ADDR_INT_REG_ACCESS_REPLACE_VAL(reg,val) (((reg) & ~SATA_IND_ACCS_PORT_PHY_ADDR_INT_REG_ACCESS_MASK) | (((uint32_t)val) << SATA_IND_ACCS_PORT_PHY_ADDR_INT_REG_ACCESS_SHIFT))

#define  SATA_IND_ACCS_PORT_PHY_ADDR_ADDRESS_MASK 0xff
#define  SATA_IND_ACCS_PORT_PHY_ADDR_ADDRESS_SHIFT 0
#define  SATA_IND_ACCS_PORT_PHY_ADDR_ADDRESS_MASK_SHIFT(reg) (((reg) & SATA_IND_ACCS_PORT_PHY_ADDR_ADDRESS_MASK) >> SATA_IND_ACCS_PORT_PHY_ADDR_ADDRESS_SHIFT)
#define  SATA_IND_ACCS_PORT_PHY_ADDR_ADDRESS_REPLACE_VAL(reg,val) (((reg) & ~SATA_IND_ACCS_PORT_PHY_ADDR_ADDRESS_MASK) | (((uint32_t)val) << SATA_IND_ACCS_PORT_PHY_ADDR_ADDRESS_SHIFT))

//====================================================================
//Register: Indirect Access Port PHY Data (IND_ACCS_PORT_PHY_DATA)
//====================================================================

#define  SATA_IND_ACCS_PORT_PHY_DATA_DATA_MASK 0xffffffff
#define  SATA_IND_ACCS_PORT_PHY_DATA_DATA_SHIFT 0
#define  SATA_IND_ACCS_PORT_PHY_DATA_DATA_MASK_SHIFT(reg) (((reg) & SATA_IND_ACCS_PORT_PHY_DATA_DATA_MASK) >> SATA_IND_ACCS_PORT_PHY_DATA_DATA_SHIFT)
#define  SATA_IND_ACCS_PORT_PHY_DATA_DATA_REPLACE_VAL(reg,val) (((reg) & ~SATA_IND_ACCS_PORT_PHY_DATA_DATA_MASK) | (((uint32_t)val) << SATA_IND_ACCS_PORT_PHY_DATA_DATA_SHIFT))

#endif // SATA
