 /*
 **************************************************************************************
 *
 * (c) Copyright 2013 Marvell International Ltd.
 *
 *
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/.
 *
 **************************************************************************************
 *
 * \file ROTATE_TOP_regmasks.h
 * Generated using RegBuild 1.6.3
 *
 **************************************************************************************
 */

#ifndef _ROTATE_TOP_REGMASKS_H_
#define _ROTATE_TOP_REGMASKS_H_

#ifndef __KERNEL__
#include <stdint.h>
#endif

//====================================================================
//
//Register File: ROTATE_TOP (ROTATE_TOP)
//
//====================================================================

//====================================================================
//
//Register File: ROTATE_IDMA (ROTATE_IDMA)
//
//====================================================================

//====================================================================
//
//Register File: ROTATE_CORE (ROTATE_CORE)
/** \brief Register Descriptions for the Rotate Block*/
//
//====================================================================

//====================================================================
//Register: Rotate Control Register (CTRL)
//====================================================================

#define  ROTATE_CORE_CTRL_RESERVED1_MASK 0xffffc000
#define  ROTATE_CORE_CTRL_RESERVED1_SHIFT 14
#define  ROTATE_CORE_CTRL_RESERVED1_MASK_SHIFT(reg) (((reg) & ROTATE_CORE_CTRL_RESERVED1_MASK) >> ROTATE_CORE_CTRL_RESERVED1_SHIFT)
#define  ROTATE_CORE_CTRL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_CORE_CTRL_RESERVED1_MASK) | (((uint32_t)val) << ROTATE_CORE_CTRL_RESERVED1_SHIFT))

#define  ROTATE_CORE_CTRL_OUT_BIG_ENDIAN_MASK 0x2000
#define  ROTATE_CORE_CTRL_OUT_BIG_ENDIAN_SHIFT 13
#define  ROTATE_CORE_CTRL_OUT_BIG_ENDIAN_MASK_SHIFT(reg) (((reg) & ROTATE_CORE_CTRL_OUT_BIG_ENDIAN_MASK) >> ROTATE_CORE_CTRL_OUT_BIG_ENDIAN_SHIFT)
#define  ROTATE_CORE_CTRL_OUT_BIG_ENDIAN_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_CORE_CTRL_OUT_BIG_ENDIAN_MASK) | (((uint32_t)val) << ROTATE_CORE_CTRL_OUT_BIG_ENDIAN_SHIFT))

#define  ROTATE_CORE_CTRL_IN_BIG_ENDIAN_MASK 0x1000
#define  ROTATE_CORE_CTRL_IN_BIG_ENDIAN_SHIFT 12
#define  ROTATE_CORE_CTRL_IN_BIG_ENDIAN_MASK_SHIFT(reg) (((reg) & ROTATE_CORE_CTRL_IN_BIG_ENDIAN_MASK) >> ROTATE_CORE_CTRL_IN_BIG_ENDIAN_SHIFT)
#define  ROTATE_CORE_CTRL_IN_BIG_ENDIAN_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_CORE_CTRL_IN_BIG_ENDIAN_MASK) | (((uint32_t)val) << ROTATE_CORE_CTRL_IN_BIG_ENDIAN_SHIFT))

#define  ROTATE_CORE_CTRL_RESERVED2_MASK 0x800
#define  ROTATE_CORE_CTRL_RESERVED2_SHIFT 11
#define  ROTATE_CORE_CTRL_RESERVED2_MASK_SHIFT(reg) (((reg) & ROTATE_CORE_CTRL_RESERVED2_MASK) >> ROTATE_CORE_CTRL_RESERVED2_SHIFT)
#define  ROTATE_CORE_CTRL_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_CORE_CTRL_RESERVED2_MASK) | (((uint32_t)val) << ROTATE_CORE_CTRL_RESERVED2_SHIFT))

#define  ROTATE_CORE_CTRL_BPP_MASK 0x700
#define  ROTATE_CORE_CTRL_BPP_SHIFT 8
#define  ROTATE_CORE_CTRL_BPP_MASK_SHIFT(reg) (((reg) & ROTATE_CORE_CTRL_BPP_MASK) >> ROTATE_CORE_CTRL_BPP_SHIFT)
#define  ROTATE_CORE_CTRL_BPP_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_CORE_CTRL_BPP_MASK) | (((uint32_t)val) << ROTATE_CORE_CTRL_BPP_SHIFT))

#define  ROTATE_CORE_CTRL_ROT_MASK 0xc0
#define  ROTATE_CORE_CTRL_ROT_SHIFT 6
#define  ROTATE_CORE_CTRL_ROT_MASK_SHIFT(reg) (((reg) & ROTATE_CORE_CTRL_ROT_MASK) >> ROTATE_CORE_CTRL_ROT_SHIFT)
#define  ROTATE_CORE_CTRL_ROT_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_CORE_CTRL_ROT_MASK) | (((uint32_t)val) << ROTATE_CORE_CTRL_ROT_SHIFT))

#define  ROTATE_CORE_CTRL_MIRROR_MASK 0x30
#define  ROTATE_CORE_CTRL_MIRROR_SHIFT 4
#define  ROTATE_CORE_CTRL_MIRROR_MASK_SHIFT(reg) (((reg) & ROTATE_CORE_CTRL_MIRROR_MASK) >> ROTATE_CORE_CTRL_MIRROR_SHIFT)
#define  ROTATE_CORE_CTRL_MIRROR_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_CORE_CTRL_MIRROR_MASK) | (((uint32_t)val) << ROTATE_CORE_CTRL_MIRROR_SHIFT))

#define  ROTATE_CORE_CTRL_RESERVED3_MASK 0x8
#define  ROTATE_CORE_CTRL_RESERVED3_SHIFT 3
#define  ROTATE_CORE_CTRL_RESERVED3_MASK_SHIFT(reg) (((reg) & ROTATE_CORE_CTRL_RESERVED3_MASK) >> ROTATE_CORE_CTRL_RESERVED3_SHIFT)
#define  ROTATE_CORE_CTRL_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_CORE_CTRL_RESERVED3_MASK) | (((uint32_t)val) << ROTATE_CORE_CTRL_RESERVED3_SHIFT))

#define  ROTATE_CORE_CTRL_DUAL_IN_BUF_MASK 0x4
#define  ROTATE_CORE_CTRL_DUAL_IN_BUF_SHIFT 2
#define  ROTATE_CORE_CTRL_DUAL_IN_BUF_MASK_SHIFT(reg) (((reg) & ROTATE_CORE_CTRL_DUAL_IN_BUF_MASK) >> ROTATE_CORE_CTRL_DUAL_IN_BUF_SHIFT)
#define  ROTATE_CORE_CTRL_DUAL_IN_BUF_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_CORE_CTRL_DUAL_IN_BUF_MASK) | (((uint32_t)val) << ROTATE_CORE_CTRL_DUAL_IN_BUF_SHIFT))

#define  ROTATE_CORE_CTRL_BOTTOM_TO_TOP_MASK 0x2
#define  ROTATE_CORE_CTRL_BOTTOM_TO_TOP_SHIFT 1
#define  ROTATE_CORE_CTRL_BOTTOM_TO_TOP_MASK_SHIFT(reg) (((reg) & ROTATE_CORE_CTRL_BOTTOM_TO_TOP_MASK) >> ROTATE_CORE_CTRL_BOTTOM_TO_TOP_SHIFT)
#define  ROTATE_CORE_CTRL_BOTTOM_TO_TOP_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_CORE_CTRL_BOTTOM_TO_TOP_MASK) | (((uint32_t)val) << ROTATE_CORE_CTRL_BOTTOM_TO_TOP_SHIFT))

#define  ROTATE_CORE_CTRL_BYPASS_MASK 0x1
#define  ROTATE_CORE_CTRL_BYPASS_SHIFT 0
#define  ROTATE_CORE_CTRL_BYPASS_MASK_SHIFT(reg) (((reg) & ROTATE_CORE_CTRL_BYPASS_MASK) >> ROTATE_CORE_CTRL_BYPASS_SHIFT)
#define  ROTATE_CORE_CTRL_BYPASS_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_CORE_CTRL_BYPASS_MASK) | (((uint32_t)val) << ROTATE_CORE_CTRL_BYPASS_SHIFT))

//====================================================================
//Register: Rotate Data Mask Register (MASK)
//====================================================================

#define  ROTATE_CORE_MASK_MASK_MASK 0xffffffff
#define  ROTATE_CORE_MASK_MASK_SHIFT 0
#define  ROTATE_CORE_MASK_MASK_MASK_SHIFT(reg) (((reg) & ROTATE_CORE_MASK_MASK_MASK) >> ROTATE_CORE_MASK_MASK_SHIFT)
#define  ROTATE_CORE_MASK_MASK_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_CORE_MASK_MASK_MASK) | (((uint32_t)val) << ROTATE_CORE_MASK_MASK_SHIFT))

//====================================================================
//Register: Rotate Replace Data Register (REPLACE)
//====================================================================

#define  ROTATE_CORE_REPLACE_REPLACE_MASK 0xffffffff
#define  ROTATE_CORE_REPLACE_REPLACE_SHIFT 0
#define  ROTATE_CORE_REPLACE_REPLACE_MASK_SHIFT(reg) (((reg) & ROTATE_CORE_REPLACE_REPLACE_MASK) >> ROTATE_CORE_REPLACE_REPLACE_SHIFT)
#define  ROTATE_CORE_REPLACE_REPLACE_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_CORE_REPLACE_REPLACE_MASK) | (((uint32_t)val) << ROTATE_CORE_REPLACE_REPLACE_SHIFT))

//====================================================================
//Register: Rotate Soft Reset Register (SOFT_RESET)
//====================================================================

#define  ROTATE_CORE_SOFT_RESET_RESERVED1_MASK 0xfffffffe
#define  ROTATE_CORE_SOFT_RESET_RESERVED1_SHIFT 1
#define  ROTATE_CORE_SOFT_RESET_RESERVED1_MASK_SHIFT(reg) (((reg) & ROTATE_CORE_SOFT_RESET_RESERVED1_MASK) >> ROTATE_CORE_SOFT_RESET_RESERVED1_SHIFT)
#define  ROTATE_CORE_SOFT_RESET_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_CORE_SOFT_RESET_RESERVED1_MASK) | (((uint32_t)val) << ROTATE_CORE_SOFT_RESET_RESERVED1_SHIFT))

#define  ROTATE_CORE_SOFT_RESET_SOFT_RESET_MASK 0x1
#define  ROTATE_CORE_SOFT_RESET_SOFT_RESET_SHIFT 0
#define  ROTATE_CORE_SOFT_RESET_SOFT_RESET_MASK_SHIFT(reg) (((reg) & ROTATE_CORE_SOFT_RESET_SOFT_RESET_MASK) >> ROTATE_CORE_SOFT_RESET_SOFT_RESET_SHIFT)
#define  ROTATE_CORE_SOFT_RESET_SOFT_RESET_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_CORE_SOFT_RESET_SOFT_RESET_MASK) | (((uint32_t)val) << ROTATE_CORE_SOFT_RESET_SOFT_RESET_SHIFT))

//====================================================================
//Register: SRAM Access Control Register (RACR)
//====================================================================

#define  ROTATE_CORE_RACR_RESERVED1_MASK 0xfffffff0
#define  ROTATE_CORE_RACR_RESERVED1_SHIFT 4
#define  ROTATE_CORE_RACR_RESERVED1_MASK_SHIFT(reg) (((reg) & ROTATE_CORE_RACR_RESERVED1_MASK) >> ROTATE_CORE_RACR_RESERVED1_SHIFT)
#define  ROTATE_CORE_RACR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_CORE_RACR_RESERVED1_MASK) | (((uint32_t)val) << ROTATE_CORE_RACR_RESERVED1_SHIFT))

#define  ROTATE_CORE_RACR_RAM_SELECT_MASK 0xc
#define  ROTATE_CORE_RACR_RAM_SELECT_SHIFT 2
#define  ROTATE_CORE_RACR_RAM_SELECT_MASK_SHIFT(reg) (((reg) & ROTATE_CORE_RACR_RAM_SELECT_MASK) >> ROTATE_CORE_RACR_RAM_SELECT_SHIFT)
#define  ROTATE_CORE_RACR_RAM_SELECT_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_CORE_RACR_RAM_SELECT_MASK) | (((uint32_t)val) << ROTATE_CORE_RACR_RAM_SELECT_SHIFT))

#define  ROTATE_CORE_RACR_INC_ADDR_MODE_MASK 0x2
#define  ROTATE_CORE_RACR_INC_ADDR_MODE_SHIFT 1
#define  ROTATE_CORE_RACR_INC_ADDR_MODE_MASK_SHIFT(reg) (((reg) & ROTATE_CORE_RACR_INC_ADDR_MODE_MASK) >> ROTATE_CORE_RACR_INC_ADDR_MODE_SHIFT)
#define  ROTATE_CORE_RACR_INC_ADDR_MODE_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_CORE_RACR_INC_ADDR_MODE_MASK) | (((uint32_t)val) << ROTATE_CORE_RACR_INC_ADDR_MODE_SHIFT))

#define  ROTATE_CORE_RACR_CPU_MASK 0x1
#define  ROTATE_CORE_RACR_CPU_SHIFT 0
#define  ROTATE_CORE_RACR_CPU_MASK_SHIFT(reg) (((reg) & ROTATE_CORE_RACR_CPU_MASK) >> ROTATE_CORE_RACR_CPU_SHIFT)
#define  ROTATE_CORE_RACR_CPU_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_CORE_RACR_CPU_MASK) | (((uint32_t)val) << ROTATE_CORE_RACR_CPU_SHIFT))

//====================================================================
//Register: SRAM Address Register (RAR)
//====================================================================

#define  ROTATE_CORE_RAR_ADDRESS_MASK 0xffffffff
#define  ROTATE_CORE_RAR_ADDRESS_SHIFT 0
#define  ROTATE_CORE_RAR_ADDRESS_MASK_SHIFT(reg) (((reg) & ROTATE_CORE_RAR_ADDRESS_MASK) >> ROTATE_CORE_RAR_ADDRESS_SHIFT)
#define  ROTATE_CORE_RAR_ADDRESS_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_CORE_RAR_ADDRESS_MASK) | (((uint32_t)val) << ROTATE_CORE_RAR_ADDRESS_SHIFT))

//====================================================================
//Register: SRAM Address Status Register (RASR)
//====================================================================

#define  ROTATE_CORE_RASR_ADDRESS_MASK 0xffffffff
#define  ROTATE_CORE_RASR_ADDRESS_SHIFT 0
#define  ROTATE_CORE_RASR_ADDRESS_MASK_SHIFT(reg) (((reg) & ROTATE_CORE_RASR_ADDRESS_MASK) >> ROTATE_CORE_RASR_ADDRESS_SHIFT)
#define  ROTATE_CORE_RASR_ADDRESS_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_CORE_RASR_ADDRESS_MASK) | (((uint32_t)val) << ROTATE_CORE_RASR_ADDRESS_SHIFT))

//====================================================================
//Register: SRAM Data Write Register (RDWR)
/** \brief This register writes the SRAM entry.*/
//====================================================================

#define  ROTATE_CORE_RDWR_DATA_MASK 0xffffffff
#define  ROTATE_CORE_RDWR_DATA_SHIFT 0
#define  ROTATE_CORE_RDWR_DATA_MASK_SHIFT(reg) (((reg) & ROTATE_CORE_RDWR_DATA_MASK) >> ROTATE_CORE_RDWR_DATA_SHIFT)
#define  ROTATE_CORE_RDWR_DATA_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_CORE_RDWR_DATA_MASK) | (((uint32_t)val) << ROTATE_CORE_RDWR_DATA_SHIFT))

//====================================================================
//Register: SRAM Data Read Register (RDRR)
/** \brief This register reads the SRAM entry*/
//====================================================================

#define  ROTATE_CORE_RDRR_DATA_MASK 0xffffffff
#define  ROTATE_CORE_RDRR_DATA_SHIFT 0
#define  ROTATE_CORE_RDRR_DATA_MASK_SHIFT(reg) (((reg) & ROTATE_CORE_RDRR_DATA_MASK) >> ROTATE_CORE_RDRR_DATA_SHIFT)
#define  ROTATE_CORE_RDRR_DATA_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_CORE_RDRR_DATA_MASK) | (((uint32_t)val) << ROTATE_CORE_RDRR_DATA_SHIFT))

//====================================================================
//Register: ROTATE Parameter Register 0 (ROT_PARAM0)
/** \brief Contains parameter settings for this instantiation of ROTATE*/
//====================================================================

#define  ROTATE_CORE_ROT_PARAM0_RESERVED1_MASK 0xffe00000
#define  ROTATE_CORE_ROT_PARAM0_RESERVED1_SHIFT 21
#define  ROTATE_CORE_ROT_PARAM0_RESERVED1_MASK_SHIFT(reg) (((reg) & ROTATE_CORE_ROT_PARAM0_RESERVED1_MASK) >> ROTATE_CORE_ROT_PARAM0_RESERVED1_SHIFT)
#define  ROTATE_CORE_ROT_PARAM0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_CORE_ROT_PARAM0_RESERVED1_MASK) | (((uint32_t)val) << ROTATE_CORE_ROT_PARAM0_RESERVED1_SHIFT))

#define  ROTATE_CORE_ROT_PARAM0_ROT_OUT_BUF_DEPTH_MASK 0x1ff000
#define  ROTATE_CORE_ROT_PARAM0_ROT_OUT_BUF_DEPTH_SHIFT 12
#define  ROTATE_CORE_ROT_PARAM0_ROT_OUT_BUF_DEPTH_MASK_SHIFT(reg) (((reg) & ROTATE_CORE_ROT_PARAM0_ROT_OUT_BUF_DEPTH_MASK) >> ROTATE_CORE_ROT_PARAM0_ROT_OUT_BUF_DEPTH_SHIFT)
#define  ROTATE_CORE_ROT_PARAM0_ROT_OUT_BUF_DEPTH_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_CORE_ROT_PARAM0_ROT_OUT_BUF_DEPTH_MASK) | (((uint32_t)val) << ROTATE_CORE_ROT_PARAM0_ROT_OUT_BUF_DEPTH_SHIFT))

#define  ROTATE_CORE_ROT_PARAM0_ROT_IN_BUF_DEPTH_MASK 0xfff
#define  ROTATE_CORE_ROT_PARAM0_ROT_IN_BUF_DEPTH_SHIFT 0
#define  ROTATE_CORE_ROT_PARAM0_ROT_IN_BUF_DEPTH_MASK_SHIFT(reg) (((reg) & ROTATE_CORE_ROT_PARAM0_ROT_IN_BUF_DEPTH_MASK) >> ROTATE_CORE_ROT_PARAM0_ROT_IN_BUF_DEPTH_SHIFT)
#define  ROTATE_CORE_ROT_PARAM0_ROT_IN_BUF_DEPTH_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_CORE_ROT_PARAM0_ROT_IN_BUF_DEPTH_MASK) | (((uint32_t)val) << ROTATE_CORE_ROT_PARAM0_ROT_IN_BUF_DEPTH_SHIFT))

//====================================================================
//Register: ROTATE Parameter Register 1 (ROT_PARAM1)
/** \brief Contains parameter settings for this instantiation of ROTATE*/
//====================================================================

#define  ROTATE_CORE_ROT_PARAM1_RESERVED1_MASK 0xfff80000
#define  ROTATE_CORE_ROT_PARAM1_RESERVED1_SHIFT 19
#define  ROTATE_CORE_ROT_PARAM1_RESERVED1_MASK_SHIFT(reg) (((reg) & ROTATE_CORE_ROT_PARAM1_RESERVED1_MASK) >> ROTATE_CORE_ROT_PARAM1_RESERVED1_SHIFT)
#define  ROTATE_CORE_ROT_PARAM1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_CORE_ROT_PARAM1_RESERVED1_MASK) | (((uint32_t)val) << ROTATE_CORE_ROT_PARAM1_RESERVED1_SHIFT))

#define  ROTATE_CORE_ROT_PARAM1_IN_TILE_HEIGHT_MASK 0x7fc00
#define  ROTATE_CORE_ROT_PARAM1_IN_TILE_HEIGHT_SHIFT 10
#define  ROTATE_CORE_ROT_PARAM1_IN_TILE_HEIGHT_MASK_SHIFT(reg) (((reg) & ROTATE_CORE_ROT_PARAM1_IN_TILE_HEIGHT_MASK) >> ROTATE_CORE_ROT_PARAM1_IN_TILE_HEIGHT_SHIFT)
#define  ROTATE_CORE_ROT_PARAM1_IN_TILE_HEIGHT_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_CORE_ROT_PARAM1_IN_TILE_HEIGHT_MASK) | (((uint32_t)val) << ROTATE_CORE_ROT_PARAM1_IN_TILE_HEIGHT_SHIFT))

#define  ROTATE_CORE_ROT_PARAM1_IN_TILE_WIDTH_MASK 0x3ff
#define  ROTATE_CORE_ROT_PARAM1_IN_TILE_WIDTH_SHIFT 0
#define  ROTATE_CORE_ROT_PARAM1_IN_TILE_WIDTH_MASK_SHIFT(reg) (((reg) & ROTATE_CORE_ROT_PARAM1_IN_TILE_WIDTH_MASK) >> ROTATE_CORE_ROT_PARAM1_IN_TILE_WIDTH_SHIFT)
#define  ROTATE_CORE_ROT_PARAM1_IN_TILE_WIDTH_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_CORE_ROT_PARAM1_IN_TILE_WIDTH_MASK) | (((uint32_t)val) << ROTATE_CORE_ROT_PARAM1_IN_TILE_WIDTH_SHIFT))

//====================================================================
//Register: ROTATE Tagging Revision 0 (REV0)
/** \brief Provide means for firmware to read IP tagging information.
      This register of particular interest to firmware.*/
//====================================================================

#define  ROTATE_CORE_REV0_MAJ_MASK 0xffff0000
#define  ROTATE_CORE_REV0_MAJ_SHIFT 16
#define  ROTATE_CORE_REV0_MAJ_MASK_SHIFT(reg) (((reg) & ROTATE_CORE_REV0_MAJ_MASK) >> ROTATE_CORE_REV0_MAJ_SHIFT)
#define  ROTATE_CORE_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_CORE_REV0_MAJ_MASK) | (((uint32_t)val) << ROTATE_CORE_REV0_MAJ_SHIFT))

#define  ROTATE_CORE_REV0_MID_MASK 0xffff
#define  ROTATE_CORE_REV0_MID_SHIFT 0
#define  ROTATE_CORE_REV0_MID_MASK_SHIFT(reg) (((reg) & ROTATE_CORE_REV0_MID_MASK) >> ROTATE_CORE_REV0_MID_SHIFT)
#define  ROTATE_CORE_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_CORE_REV0_MID_MASK) | (((uint32_t)val) << ROTATE_CORE_REV0_MID_SHIFT))

//====================================================================
//Register: ROTATE Tagging Revision 1 (REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  ROTATE_CORE_REV1_RESERVED1_MASK 0xffff0000
#define  ROTATE_CORE_REV1_RESERVED1_SHIFT 16
#define  ROTATE_CORE_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & ROTATE_CORE_REV1_RESERVED1_MASK) >> ROTATE_CORE_REV1_RESERVED1_SHIFT)
#define  ROTATE_CORE_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_CORE_REV1_RESERVED1_MASK) | (((uint32_t)val) << ROTATE_CORE_REV1_RESERVED1_SHIFT))

#define  ROTATE_CORE_REV1_CFG_MASK 0xffff
#define  ROTATE_CORE_REV1_CFG_SHIFT 0
#define  ROTATE_CORE_REV1_CFG_MASK_SHIFT(reg) (((reg) & ROTATE_CORE_REV1_CFG_MASK) >> ROTATE_CORE_REV1_CFG_SHIFT)
#define  ROTATE_CORE_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_CORE_REV1_CFG_MASK) | (((uint32_t)val) << ROTATE_CORE_REV1_CFG_SHIFT))

//====================================================================
//
//Register File: ROTATE_ODMA (ROTATE_ODMA)
//
//====================================================================

//====================================================================
//
//Register File: ROTATE_IDMA_UDMA (ROTATE_IDMA_ROTATE_IDMA_UDMA)
//
//====================================================================

//====================================================================
//Register: UDMA Configuration Register (UCR)
//====================================================================

#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UCR_RESERVED1_MASK 0xfff00000
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UCR_RESERVED1_SHIFT 20
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UCR_RESERVED1_MASK_SHIFT(reg) (((reg) & ROTATE_IDMA_ROTATE_IDMA_UDMA_UCR_RESERVED1_MASK) >> ROTATE_IDMA_ROTATE_IDMA_UDMA_UCR_RESERVED1_SHIFT)
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UCR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_IDMA_ROTATE_IDMA_UDMA_UCR_RESERVED1_MASK) | (((uint32_t)val) << ROTATE_IDMA_ROTATE_IDMA_UDMA_UCR_RESERVED1_SHIFT))

#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UCR_DATAAXCACHE_MASK 0xf0000
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UCR_DATAAXCACHE_SHIFT 16
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UCR_DATAAXCACHE_MASK_SHIFT(reg) (((reg) & ROTATE_IDMA_ROTATE_IDMA_UDMA_UCR_DATAAXCACHE_MASK) >> ROTATE_IDMA_ROTATE_IDMA_UDMA_UCR_DATAAXCACHE_SHIFT)
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UCR_DATAAXCACHE_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_IDMA_ROTATE_IDMA_UDMA_UCR_DATAAXCACHE_MASK) | (((uint32_t)val) << ROTATE_IDMA_ROTATE_IDMA_UDMA_UCR_DATAAXCACHE_SHIFT))

#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UCR_DESCARCACHE_MASK 0xf000
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UCR_DESCARCACHE_SHIFT 12
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UCR_DESCARCACHE_MASK_SHIFT(reg) (((reg) & ROTATE_IDMA_ROTATE_IDMA_UDMA_UCR_DESCARCACHE_MASK) >> ROTATE_IDMA_ROTATE_IDMA_UDMA_UCR_DESCARCACHE_SHIFT)
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UCR_DESCARCACHE_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_IDMA_ROTATE_IDMA_UDMA_UCR_DESCARCACHE_MASK) | (((uint32_t)val) << ROTATE_IDMA_ROTATE_IDMA_UDMA_UCR_DESCARCACHE_SHIFT))

#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UCR_DESCAWCACHE_MASK 0xf00
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UCR_DESCAWCACHE_SHIFT 8
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UCR_DESCAWCACHE_MASK_SHIFT(reg) (((reg) & ROTATE_IDMA_ROTATE_IDMA_UDMA_UCR_DESCAWCACHE_MASK) >> ROTATE_IDMA_ROTATE_IDMA_UDMA_UCR_DESCAWCACHE_SHIFT)
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UCR_DESCAWCACHE_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_IDMA_ROTATE_IDMA_UDMA_UCR_DESCAWCACHE_MASK) | (((uint32_t)val) << ROTATE_IDMA_ROTATE_IDMA_UDMA_UCR_DESCAWCACHE_SHIFT))

#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UCR_RESERVED2_MASK 0xc0
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UCR_RESERVED2_SHIFT 6
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UCR_RESERVED2_MASK_SHIFT(reg) (((reg) & ROTATE_IDMA_ROTATE_IDMA_UDMA_UCR_RESERVED2_MASK) >> ROTATE_IDMA_ROTATE_IDMA_UDMA_UCR_RESERVED2_SHIFT)
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UCR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_IDMA_ROTATE_IDMA_UDMA_UCR_RESERVED2_MASK) | (((uint32_t)val) << ROTATE_IDMA_ROTATE_IDMA_UDMA_UCR_RESERVED2_SHIFT))

#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UCR_HANDSHAKEENABLE_MASK 0x20
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UCR_HANDSHAKEENABLE_SHIFT 5
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UCR_HANDSHAKEENABLE_MASK_SHIFT(reg) (((reg) & ROTATE_IDMA_ROTATE_IDMA_UDMA_UCR_HANDSHAKEENABLE_MASK) >> ROTATE_IDMA_ROTATE_IDMA_UDMA_UCR_HANDSHAKEENABLE_SHIFT)
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UCR_HANDSHAKEENABLE_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_IDMA_ROTATE_IDMA_UDMA_UCR_HANDSHAKEENABLE_MASK) | (((uint32_t)val) << ROTATE_IDMA_ROTATE_IDMA_UDMA_UCR_HANDSHAKEENABLE_SHIFT))

#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UCR_OWNWRITEDISABLE_MASK 0x10
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UCR_OWNWRITEDISABLE_SHIFT 4
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UCR_OWNWRITEDISABLE_MASK_SHIFT(reg) (((reg) & ROTATE_IDMA_ROTATE_IDMA_UDMA_UCR_OWNWRITEDISABLE_MASK) >> ROTATE_IDMA_ROTATE_IDMA_UDMA_UCR_OWNWRITEDISABLE_SHIFT)
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UCR_OWNWRITEDISABLE_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_IDMA_ROTATE_IDMA_UDMA_UCR_OWNWRITEDISABLE_MASK) | (((uint32_t)val) << ROTATE_IDMA_ROTATE_IDMA_UDMA_UCR_OWNWRITEDISABLE_SHIFT))

#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UCR_OWNPOLARITY_MASK 0x8
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UCR_OWNPOLARITY_SHIFT 3
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UCR_OWNPOLARITY_MASK_SHIFT(reg) (((reg) & ROTATE_IDMA_ROTATE_IDMA_UDMA_UCR_OWNPOLARITY_MASK) >> ROTATE_IDMA_ROTATE_IDMA_UDMA_UCR_OWNPOLARITY_SHIFT)
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UCR_OWNPOLARITY_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_IDMA_ROTATE_IDMA_UDMA_UCR_OWNPOLARITY_MASK) | (((uint32_t)val) << ROTATE_IDMA_ROTATE_IDMA_UDMA_UCR_OWNPOLARITY_SHIFT))

#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UCR_BEATS_MASK 0x6
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UCR_BEATS_SHIFT 1
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UCR_BEATS_MASK_SHIFT(reg) (((reg) & ROTATE_IDMA_ROTATE_IDMA_UDMA_UCR_BEATS_MASK) >> ROTATE_IDMA_ROTATE_IDMA_UDMA_UCR_BEATS_SHIFT)
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UCR_BEATS_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_IDMA_ROTATE_IDMA_UDMA_UCR_BEATS_MASK) | (((uint32_t)val) << ROTATE_IDMA_ROTATE_IDMA_UDMA_UCR_BEATS_SHIFT))

#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UCR_ENABLE_MASK 0x1
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UCR_ENABLE_SHIFT 0
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UCR_ENABLE_MASK_SHIFT(reg) (((reg) & ROTATE_IDMA_ROTATE_IDMA_UDMA_UCR_ENABLE_MASK) >> ROTATE_IDMA_ROTATE_IDMA_UDMA_UCR_ENABLE_SHIFT)
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UCR_ENABLE_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_IDMA_ROTATE_IDMA_UDMA_UCR_ENABLE_MASK) | (((uint32_t)val) << ROTATE_IDMA_ROTATE_IDMA_UDMA_UCR_ENABLE_SHIFT))

//====================================================================
//Register: UDMA Status Register (USR)
//====================================================================

#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_USR_RESERVED1_MASK 0xfffff800
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_USR_RESERVED1_SHIFT 11
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_USR_RESERVED1_MASK_SHIFT(reg) (((reg) & ROTATE_IDMA_ROTATE_IDMA_UDMA_USR_RESERVED1_MASK) >> ROTATE_IDMA_ROTATE_IDMA_UDMA_USR_RESERVED1_SHIFT)
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_USR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_IDMA_ROTATE_IDMA_UDMA_USR_RESERVED1_MASK) | (((uint32_t)val) << ROTATE_IDMA_ROTATE_IDMA_UDMA_USR_RESERVED1_SHIFT))

#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_USR_DMAPAUSED_MASK 0x400
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_USR_DMAPAUSED_SHIFT 10
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_USR_DMAPAUSED_MASK_SHIFT(reg) (((reg) & ROTATE_IDMA_ROTATE_IDMA_UDMA_USR_DMAPAUSED_MASK) >> ROTATE_IDMA_ROTATE_IDMA_UDMA_USR_DMAPAUSED_SHIFT)
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_USR_DMAPAUSED_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_IDMA_ROTATE_IDMA_UDMA_USR_DMAPAUSED_MASK) | (((uint32_t)val) << ROTATE_IDMA_ROTATE_IDMA_UDMA_USR_DMAPAUSED_SHIFT))

#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_USR_PAUSEAFTER_MASK 0x200
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_USR_PAUSEAFTER_SHIFT 9
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_USR_PAUSEAFTER_MASK_SHIFT(reg) (((reg) & ROTATE_IDMA_ROTATE_IDMA_UDMA_USR_PAUSEAFTER_MASK) >> ROTATE_IDMA_ROTATE_IDMA_UDMA_USR_PAUSEAFTER_SHIFT)
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_USR_PAUSEAFTER_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_IDMA_ROTATE_IDMA_UDMA_USR_PAUSEAFTER_MASK) | (((uint32_t)val) << ROTATE_IDMA_ROTATE_IDMA_UDMA_USR_PAUSEAFTER_SHIFT))

#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_USR_PAUSEBEFORE_MASK 0x100
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_USR_PAUSEBEFORE_SHIFT 8
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_USR_PAUSEBEFORE_MASK_SHIFT(reg) (((reg) & ROTATE_IDMA_ROTATE_IDMA_UDMA_USR_PAUSEBEFORE_MASK) >> ROTATE_IDMA_ROTATE_IDMA_UDMA_USR_PAUSEBEFORE_SHIFT)
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_USR_PAUSEBEFORE_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_IDMA_ROTATE_IDMA_UDMA_USR_PAUSEBEFORE_MASK) | (((uint32_t)val) << ROTATE_IDMA_ROTATE_IDMA_UDMA_USR_PAUSEBEFORE_SHIFT))

#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_USR_INTONFINISH_MASK 0x80
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_USR_INTONFINISH_SHIFT 7
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_USR_INTONFINISH_MASK_SHIFT(reg) (((reg) & ROTATE_IDMA_ROTATE_IDMA_UDMA_USR_INTONFINISH_MASK) >> ROTATE_IDMA_ROTATE_IDMA_UDMA_USR_INTONFINISH_SHIFT)
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_USR_INTONFINISH_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_IDMA_ROTATE_IDMA_UDMA_USR_INTONFINISH_MASK) | (((uint32_t)val) << ROTATE_IDMA_ROTATE_IDMA_UDMA_USR_INTONFINISH_SHIFT))

#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_USR_STOPONFINISH_MASK 0x40
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_USR_STOPONFINISH_SHIFT 6
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_USR_STOPONFINISH_MASK_SHIFT(reg) (((reg) & ROTATE_IDMA_ROTATE_IDMA_UDMA_USR_STOPONFINISH_MASK) >> ROTATE_IDMA_ROTATE_IDMA_UDMA_USR_STOPONFINISH_SHIFT)
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_USR_STOPONFINISH_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_IDMA_ROTATE_IDMA_UDMA_USR_STOPONFINISH_MASK) | (((uint32_t)val) << ROTATE_IDMA_ROTATE_IDMA_UDMA_USR_STOPONFINISH_SHIFT))

#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_USR_CMDBUFFULL_MASK 0x20
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_USR_CMDBUFFULL_SHIFT 5
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_USR_CMDBUFFULL_MASK_SHIFT(reg) (((reg) & ROTATE_IDMA_ROTATE_IDMA_UDMA_USR_CMDBUFFULL_MASK) >> ROTATE_IDMA_ROTATE_IDMA_UDMA_USR_CMDBUFFULL_SHIFT)
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_USR_CMDBUFFULL_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_IDMA_ROTATE_IDMA_UDMA_USR_CMDBUFFULL_MASK) | (((uint32_t)val) << ROTATE_IDMA_ROTATE_IDMA_UDMA_USR_CMDBUFFULL_SHIFT))

#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_USR_CMDBUFEMPTY_MASK 0x10
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_USR_CMDBUFEMPTY_SHIFT 4
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_USR_CMDBUFEMPTY_MASK_SHIFT(reg) (((reg) & ROTATE_IDMA_ROTATE_IDMA_UDMA_USR_CMDBUFEMPTY_MASK) >> ROTATE_IDMA_ROTATE_IDMA_UDMA_USR_CMDBUFEMPTY_SHIFT)
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_USR_CMDBUFEMPTY_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_IDMA_ROTATE_IDMA_UDMA_USR_CMDBUFEMPTY_MASK) | (((uint32_t)val) << ROTATE_IDMA_ROTATE_IDMA_UDMA_USR_CMDBUFEMPTY_SHIFT))

#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_USR_DATABUFFULL_MASK 0x8
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_USR_DATABUFFULL_SHIFT 3
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_USR_DATABUFFULL_MASK_SHIFT(reg) (((reg) & ROTATE_IDMA_ROTATE_IDMA_UDMA_USR_DATABUFFULL_MASK) >> ROTATE_IDMA_ROTATE_IDMA_UDMA_USR_DATABUFFULL_SHIFT)
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_USR_DATABUFFULL_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_IDMA_ROTATE_IDMA_UDMA_USR_DATABUFFULL_MASK) | (((uint32_t)val) << ROTATE_IDMA_ROTATE_IDMA_UDMA_USR_DATABUFFULL_SHIFT))

#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_USR_DATABUFEMPTY_MASK 0x4
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_USR_DATABUFEMPTY_SHIFT 2
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_USR_DATABUFEMPTY_MASK_SHIFT(reg) (((reg) & ROTATE_IDMA_ROTATE_IDMA_UDMA_USR_DATABUFEMPTY_MASK) >> ROTATE_IDMA_ROTATE_IDMA_UDMA_USR_DATABUFEMPTY_SHIFT)
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_USR_DATABUFEMPTY_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_IDMA_ROTATE_IDMA_UDMA_USR_DATABUFEMPTY_MASK) | (((uint32_t)val) << ROTATE_IDMA_ROTATE_IDMA_UDMA_USR_DATABUFEMPTY_SHIFT))

#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_USR_CLEAR_MASK 0x2
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_USR_CLEAR_SHIFT 1
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_USR_CLEAR_MASK_SHIFT(reg) (((reg) & ROTATE_IDMA_ROTATE_IDMA_UDMA_USR_CLEAR_MASK) >> ROTATE_IDMA_ROTATE_IDMA_UDMA_USR_CLEAR_SHIFT)
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_USR_CLEAR_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_IDMA_ROTATE_IDMA_UDMA_USR_CLEAR_MASK) | (((uint32_t)val) << ROTATE_IDMA_ROTATE_IDMA_UDMA_USR_CLEAR_SHIFT))

#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_USR_BUSY_MASK 0x1
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_USR_BUSY_SHIFT 0
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_USR_BUSY_MASK_SHIFT(reg) (((reg) & ROTATE_IDMA_ROTATE_IDMA_UDMA_USR_BUSY_MASK) >> ROTATE_IDMA_ROTATE_IDMA_UDMA_USR_BUSY_SHIFT)
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_USR_BUSY_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_IDMA_ROTATE_IDMA_UDMA_USR_BUSY_MASK) | (((uint32_t)val) << ROTATE_IDMA_ROTATE_IDMA_UDMA_USR_BUSY_SHIFT))

//====================================================================
//Register: UDMA Parameter Register (UPR)
//====================================================================

#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UPR_RESERVED1_MASK 0xff000000
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UPR_RESERVED1_SHIFT 24
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UPR_RESERVED1_MASK_SHIFT(reg) (((reg) & ROTATE_IDMA_ROTATE_IDMA_UDMA_UPR_RESERVED1_MASK) >> ROTATE_IDMA_ROTATE_IDMA_UDMA_UPR_RESERVED1_SHIFT)
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UPR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_IDMA_ROTATE_IDMA_UDMA_UPR_RESERVED1_MASK) | (((uint32_t)val) << ROTATE_IDMA_ROTATE_IDMA_UDMA_UPR_RESERVED1_SHIFT))

#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UPR_FIFODEPTH_MASK 0xffff00
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UPR_FIFODEPTH_SHIFT 8
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UPR_FIFODEPTH_MASK_SHIFT(reg) (((reg) & ROTATE_IDMA_ROTATE_IDMA_UDMA_UPR_FIFODEPTH_MASK) >> ROTATE_IDMA_ROTATE_IDMA_UDMA_UPR_FIFODEPTH_SHIFT)
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UPR_FIFODEPTH_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_IDMA_ROTATE_IDMA_UDMA_UPR_FIFODEPTH_MASK) | (((uint32_t)val) << ROTATE_IDMA_ROTATE_IDMA_UDMA_UPR_FIFODEPTH_SHIFT))

#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UPR_RESERVED2_MASK 0xe0
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UPR_RESERVED2_SHIFT 5
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UPR_RESERVED2_MASK_SHIFT(reg) (((reg) & ROTATE_IDMA_ROTATE_IDMA_UDMA_UPR_RESERVED2_MASK) >> ROTATE_IDMA_ROTATE_IDMA_UDMA_UPR_RESERVED2_SHIFT)
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UPR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_IDMA_ROTATE_IDMA_UDMA_UPR_RESERVED2_MASK) | (((uint32_t)val) << ROTATE_IDMA_ROTATE_IDMA_UDMA_UPR_RESERVED2_SHIFT))

#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UPR_SERPSUPPORT_MASK 0x10
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UPR_SERPSUPPORT_SHIFT 4
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UPR_SERPSUPPORT_MASK_SHIFT(reg) (((reg) & ROTATE_IDMA_ROTATE_IDMA_UDMA_UPR_SERPSUPPORT_MASK) >> ROTATE_IDMA_ROTATE_IDMA_UDMA_UPR_SERPSUPPORT_SHIFT)
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UPR_SERPSUPPORT_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_IDMA_ROTATE_IDMA_UDMA_UPR_SERPSUPPORT_MASK) | (((uint32_t)val) << ROTATE_IDMA_ROTATE_IDMA_UDMA_UPR_SERPSUPPORT_SHIFT))

#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UPR_DESCLENGTH_MASK 0x8
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UPR_DESCLENGTH_SHIFT 3
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UPR_DESCLENGTH_MASK_SHIFT(reg) (((reg) & ROTATE_IDMA_ROTATE_IDMA_UDMA_UPR_DESCLENGTH_MASK) >> ROTATE_IDMA_ROTATE_IDMA_UDMA_UPR_DESCLENGTH_SHIFT)
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UPR_DESCLENGTH_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_IDMA_ROTATE_IDMA_UDMA_UPR_DESCLENGTH_MASK) | (((uint32_t)val) << ROTATE_IDMA_ROTATE_IDMA_UDMA_UPR_DESCLENGTH_SHIFT))

#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UPR_BUSWIDTH_MASK 0x4
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UPR_BUSWIDTH_SHIFT 2
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UPR_BUSWIDTH_MASK_SHIFT(reg) (((reg) & ROTATE_IDMA_ROTATE_IDMA_UDMA_UPR_BUSWIDTH_MASK) >> ROTATE_IDMA_ROTATE_IDMA_UDMA_UPR_BUSWIDTH_SHIFT)
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UPR_BUSWIDTH_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_IDMA_ROTATE_IDMA_UDMA_UPR_BUSWIDTH_MASK) | (((uint32_t)val) << ROTATE_IDMA_ROTATE_IDMA_UDMA_UPR_BUSWIDTH_SHIFT))

#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UPR_MEMALIGN_MASK 0x3
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UPR_MEMALIGN_SHIFT 0
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UPR_MEMALIGN_MASK_SHIFT(reg) (((reg) & ROTATE_IDMA_ROTATE_IDMA_UDMA_UPR_MEMALIGN_MASK) >> ROTATE_IDMA_ROTATE_IDMA_UDMA_UPR_MEMALIGN_SHIFT)
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UPR_MEMALIGN_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_IDMA_ROTATE_IDMA_UDMA_UPR_MEMALIGN_MASK) | (((uint32_t)val) << ROTATE_IDMA_ROTATE_IDMA_UDMA_UPR_MEMALIGN_SHIFT))

//====================================================================
//Register: UDMA Interrupt Enable Register (UIER)
//====================================================================

#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UIER_RESERVED1_MASK 0xffffffc0
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UIER_RESERVED1_SHIFT 6
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UIER_RESERVED1_MASK_SHIFT(reg) (((reg) & ROTATE_IDMA_ROTATE_IDMA_UDMA_UIER_RESERVED1_MASK) >> ROTATE_IDMA_ROTATE_IDMA_UDMA_UIER_RESERVED1_SHIFT)
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UIER_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_IDMA_ROTATE_IDMA_UDMA_UIER_RESERVED1_MASK) | (((uint32_t)val) << ROTATE_IDMA_ROTATE_IDMA_UDMA_UIER_RESERVED1_SHIFT))

#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UIER_OUTOFRANGE_MASK 0x20
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UIER_OUTOFRANGE_SHIFT 5
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UIER_OUTOFRANGE_MASK_SHIFT(reg) (((reg) & ROTATE_IDMA_ROTATE_IDMA_UDMA_UIER_OUTOFRANGE_MASK) >> ROTATE_IDMA_ROTATE_IDMA_UDMA_UIER_OUTOFRANGE_SHIFT)
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UIER_OUTOFRANGE_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_IDMA_ROTATE_IDMA_UDMA_UIER_OUTOFRANGE_MASK) | (((uint32_t)val) << ROTATE_IDMA_ROTATE_IDMA_UDMA_UIER_OUTOFRANGE_SHIFT))

#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UIER_RRESP_MASK 0x10
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UIER_RRESP_SHIFT 4
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UIER_RRESP_MASK_SHIFT(reg) (((reg) & ROTATE_IDMA_ROTATE_IDMA_UDMA_UIER_RRESP_MASK) >> ROTATE_IDMA_ROTATE_IDMA_UDMA_UIER_RRESP_SHIFT)
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UIER_RRESP_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_IDMA_ROTATE_IDMA_UDMA_UIER_RRESP_MASK) | (((uint32_t)val) << ROTATE_IDMA_ROTATE_IDMA_UDMA_UIER_RRESP_SHIFT))

#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UIER_BRESP_MASK 0x8
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UIER_BRESP_SHIFT 3
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UIER_BRESP_MASK_SHIFT(reg) (((reg) & ROTATE_IDMA_ROTATE_IDMA_UDMA_UIER_BRESP_MASK) >> ROTATE_IDMA_ROTATE_IDMA_UDMA_UIER_BRESP_SHIFT)
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UIER_BRESP_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_IDMA_ROTATE_IDMA_UDMA_UIER_BRESP_MASK) | (((uint32_t)val) << ROTATE_IDMA_ROTATE_IDMA_UDMA_UIER_BRESP_SHIFT))

#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UIER_CLEARCOMPLETE_MASK 0x4
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UIER_CLEARCOMPLETE_SHIFT 2
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UIER_CLEARCOMPLETE_MASK_SHIFT(reg) (((reg) & ROTATE_IDMA_ROTATE_IDMA_UDMA_UIER_CLEARCOMPLETE_MASK) >> ROTATE_IDMA_ROTATE_IDMA_UDMA_UIER_CLEARCOMPLETE_SHIFT)
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UIER_CLEARCOMPLETE_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_IDMA_ROTATE_IDMA_UDMA_UIER_CLEARCOMPLETE_MASK) | (((uint32_t)val) << ROTATE_IDMA_ROTATE_IDMA_UDMA_UIER_CLEARCOMPLETE_SHIFT))

#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UIER_DESC_MASK 0x2
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UIER_DESC_SHIFT 1
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UIER_DESC_MASK_SHIFT(reg) (((reg) & ROTATE_IDMA_ROTATE_IDMA_UDMA_UIER_DESC_MASK) >> ROTATE_IDMA_ROTATE_IDMA_UDMA_UIER_DESC_SHIFT)
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UIER_DESC_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_IDMA_ROTATE_IDMA_UDMA_UIER_DESC_MASK) | (((uint32_t)val) << ROTATE_IDMA_ROTATE_IDMA_UDMA_UIER_DESC_SHIFT))

#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UIER_OWN_MASK 0x1
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UIER_OWN_SHIFT 0
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UIER_OWN_MASK_SHIFT(reg) (((reg) & ROTATE_IDMA_ROTATE_IDMA_UDMA_UIER_OWN_MASK) >> ROTATE_IDMA_ROTATE_IDMA_UDMA_UIER_OWN_SHIFT)
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UIER_OWN_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_IDMA_ROTATE_IDMA_UDMA_UIER_OWN_MASK) | (((uint32_t)val) << ROTATE_IDMA_ROTATE_IDMA_UDMA_UIER_OWN_SHIFT))

//====================================================================
//Register: UDMA Interrupt Pending Register (UIPR)
//====================================================================

#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UIPR_RESERVED1_MASK 0xffffffc0
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UIPR_RESERVED1_SHIFT 6
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UIPR_RESERVED1_MASK_SHIFT(reg) (((reg) & ROTATE_IDMA_ROTATE_IDMA_UDMA_UIPR_RESERVED1_MASK) >> ROTATE_IDMA_ROTATE_IDMA_UDMA_UIPR_RESERVED1_SHIFT)
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UIPR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_IDMA_ROTATE_IDMA_UDMA_UIPR_RESERVED1_MASK) | (((uint32_t)val) << ROTATE_IDMA_ROTATE_IDMA_UDMA_UIPR_RESERVED1_SHIFT))

#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UIPR_OUTOFRANGE_MASK 0x20
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UIPR_OUTOFRANGE_SHIFT 5
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UIPR_OUTOFRANGE_MASK_SHIFT(reg) (((reg) & ROTATE_IDMA_ROTATE_IDMA_UDMA_UIPR_OUTOFRANGE_MASK) >> ROTATE_IDMA_ROTATE_IDMA_UDMA_UIPR_OUTOFRANGE_SHIFT)
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UIPR_OUTOFRANGE_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_IDMA_ROTATE_IDMA_UDMA_UIPR_OUTOFRANGE_MASK) | (((uint32_t)val) << ROTATE_IDMA_ROTATE_IDMA_UDMA_UIPR_OUTOFRANGE_SHIFT))

#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UIPR_RRESP_MASK 0x10
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UIPR_RRESP_SHIFT 4
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UIPR_RRESP_MASK_SHIFT(reg) (((reg) & ROTATE_IDMA_ROTATE_IDMA_UDMA_UIPR_RRESP_MASK) >> ROTATE_IDMA_ROTATE_IDMA_UDMA_UIPR_RRESP_SHIFT)
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UIPR_RRESP_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_IDMA_ROTATE_IDMA_UDMA_UIPR_RRESP_MASK) | (((uint32_t)val) << ROTATE_IDMA_ROTATE_IDMA_UDMA_UIPR_RRESP_SHIFT))

#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UIPR_BRESP_MASK 0x8
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UIPR_BRESP_SHIFT 3
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UIPR_BRESP_MASK_SHIFT(reg) (((reg) & ROTATE_IDMA_ROTATE_IDMA_UDMA_UIPR_BRESP_MASK) >> ROTATE_IDMA_ROTATE_IDMA_UDMA_UIPR_BRESP_SHIFT)
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UIPR_BRESP_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_IDMA_ROTATE_IDMA_UDMA_UIPR_BRESP_MASK) | (((uint32_t)val) << ROTATE_IDMA_ROTATE_IDMA_UDMA_UIPR_BRESP_SHIFT))

#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UIPR_CLEARCOMPLETE_MASK 0x4
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UIPR_CLEARCOMPLETE_SHIFT 2
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UIPR_CLEARCOMPLETE_MASK_SHIFT(reg) (((reg) & ROTATE_IDMA_ROTATE_IDMA_UDMA_UIPR_CLEARCOMPLETE_MASK) >> ROTATE_IDMA_ROTATE_IDMA_UDMA_UIPR_CLEARCOMPLETE_SHIFT)
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UIPR_CLEARCOMPLETE_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_IDMA_ROTATE_IDMA_UDMA_UIPR_CLEARCOMPLETE_MASK) | (((uint32_t)val) << ROTATE_IDMA_ROTATE_IDMA_UDMA_UIPR_CLEARCOMPLETE_SHIFT))

#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UIPR_DESC_MASK 0x2
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UIPR_DESC_SHIFT 1
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UIPR_DESC_MASK_SHIFT(reg) (((reg) & ROTATE_IDMA_ROTATE_IDMA_UDMA_UIPR_DESC_MASK) >> ROTATE_IDMA_ROTATE_IDMA_UDMA_UIPR_DESC_SHIFT)
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UIPR_DESC_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_IDMA_ROTATE_IDMA_UDMA_UIPR_DESC_MASK) | (((uint32_t)val) << ROTATE_IDMA_ROTATE_IDMA_UDMA_UIPR_DESC_SHIFT))

#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UIPR_OWN_MASK 0x1
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UIPR_OWN_SHIFT 0
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UIPR_OWN_MASK_SHIFT(reg) (((reg) & ROTATE_IDMA_ROTATE_IDMA_UDMA_UIPR_OWN_MASK) >> ROTATE_IDMA_ROTATE_IDMA_UDMA_UIPR_OWN_SHIFT)
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UIPR_OWN_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_IDMA_ROTATE_IDMA_UDMA_UIPR_OWN_MASK) | (((uint32_t)val) << ROTATE_IDMA_ROTATE_IDMA_UDMA_UIPR_OWN_SHIFT))

//====================================================================
//Register: UDMA Interrupt Clear Register (UICR)
//====================================================================

#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UICR_RESERVED1_MASK 0xffffffc0
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UICR_RESERVED1_SHIFT 6
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UICR_RESERVED1_MASK_SHIFT(reg) (((reg) & ROTATE_IDMA_ROTATE_IDMA_UDMA_UICR_RESERVED1_MASK) >> ROTATE_IDMA_ROTATE_IDMA_UDMA_UICR_RESERVED1_SHIFT)
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UICR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_IDMA_ROTATE_IDMA_UDMA_UICR_RESERVED1_MASK) | (((uint32_t)val) << ROTATE_IDMA_ROTATE_IDMA_UDMA_UICR_RESERVED1_SHIFT))

#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UICR_OUTOFRANGE_MASK 0x20
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UICR_OUTOFRANGE_SHIFT 5
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UICR_OUTOFRANGE_MASK_SHIFT(reg) (((reg) & ROTATE_IDMA_ROTATE_IDMA_UDMA_UICR_OUTOFRANGE_MASK) >> ROTATE_IDMA_ROTATE_IDMA_UDMA_UICR_OUTOFRANGE_SHIFT)
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UICR_OUTOFRANGE_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_IDMA_ROTATE_IDMA_UDMA_UICR_OUTOFRANGE_MASK) | (((uint32_t)val) << ROTATE_IDMA_ROTATE_IDMA_UDMA_UICR_OUTOFRANGE_SHIFT))

#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UICR_RRESP_MASK 0x10
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UICR_RRESP_SHIFT 4
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UICR_RRESP_MASK_SHIFT(reg) (((reg) & ROTATE_IDMA_ROTATE_IDMA_UDMA_UICR_RRESP_MASK) >> ROTATE_IDMA_ROTATE_IDMA_UDMA_UICR_RRESP_SHIFT)
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UICR_RRESP_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_IDMA_ROTATE_IDMA_UDMA_UICR_RRESP_MASK) | (((uint32_t)val) << ROTATE_IDMA_ROTATE_IDMA_UDMA_UICR_RRESP_SHIFT))

#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UICR_BRESP_MASK 0x8
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UICR_BRESP_SHIFT 3
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UICR_BRESP_MASK_SHIFT(reg) (((reg) & ROTATE_IDMA_ROTATE_IDMA_UDMA_UICR_BRESP_MASK) >> ROTATE_IDMA_ROTATE_IDMA_UDMA_UICR_BRESP_SHIFT)
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UICR_BRESP_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_IDMA_ROTATE_IDMA_UDMA_UICR_BRESP_MASK) | (((uint32_t)val) << ROTATE_IDMA_ROTATE_IDMA_UDMA_UICR_BRESP_SHIFT))

#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UICR_CLEARCOMPLETE_MASK 0x4
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UICR_CLEARCOMPLETE_SHIFT 2
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UICR_CLEARCOMPLETE_MASK_SHIFT(reg) (((reg) & ROTATE_IDMA_ROTATE_IDMA_UDMA_UICR_CLEARCOMPLETE_MASK) >> ROTATE_IDMA_ROTATE_IDMA_UDMA_UICR_CLEARCOMPLETE_SHIFT)
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UICR_CLEARCOMPLETE_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_IDMA_ROTATE_IDMA_UDMA_UICR_CLEARCOMPLETE_MASK) | (((uint32_t)val) << ROTATE_IDMA_ROTATE_IDMA_UDMA_UICR_CLEARCOMPLETE_SHIFT))

#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UICR_DESC_MASK 0x2
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UICR_DESC_SHIFT 1
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UICR_DESC_MASK_SHIFT(reg) (((reg) & ROTATE_IDMA_ROTATE_IDMA_UDMA_UICR_DESC_MASK) >> ROTATE_IDMA_ROTATE_IDMA_UDMA_UICR_DESC_SHIFT)
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UICR_DESC_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_IDMA_ROTATE_IDMA_UDMA_UICR_DESC_MASK) | (((uint32_t)val) << ROTATE_IDMA_ROTATE_IDMA_UDMA_UICR_DESC_SHIFT))

#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UICR_OWN_MASK 0x1
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UICR_OWN_SHIFT 0
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UICR_OWN_MASK_SHIFT(reg) (((reg) & ROTATE_IDMA_ROTATE_IDMA_UDMA_UICR_OWN_MASK) >> ROTATE_IDMA_ROTATE_IDMA_UDMA_UICR_OWN_SHIFT)
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UICR_OWN_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_IDMA_ROTATE_IDMA_UDMA_UICR_OWN_MASK) | (((uint32_t)val) << ROTATE_IDMA_ROTATE_IDMA_UDMA_UICR_OWN_SHIFT))

//====================================================================
//Register: UDMA Interrupt Force Register (UIFR)
//====================================================================

#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UIFR_RESERVED1_MASK 0xffffffc0
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UIFR_RESERVED1_SHIFT 6
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UIFR_RESERVED1_MASK_SHIFT(reg) (((reg) & ROTATE_IDMA_ROTATE_IDMA_UDMA_UIFR_RESERVED1_MASK) >> ROTATE_IDMA_ROTATE_IDMA_UDMA_UIFR_RESERVED1_SHIFT)
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UIFR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_IDMA_ROTATE_IDMA_UDMA_UIFR_RESERVED1_MASK) | (((uint32_t)val) << ROTATE_IDMA_ROTATE_IDMA_UDMA_UIFR_RESERVED1_SHIFT))

#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UIFR_OUTOFRANGE_MASK 0x20
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UIFR_OUTOFRANGE_SHIFT 5
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UIFR_OUTOFRANGE_MASK_SHIFT(reg) (((reg) & ROTATE_IDMA_ROTATE_IDMA_UDMA_UIFR_OUTOFRANGE_MASK) >> ROTATE_IDMA_ROTATE_IDMA_UDMA_UIFR_OUTOFRANGE_SHIFT)
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UIFR_OUTOFRANGE_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_IDMA_ROTATE_IDMA_UDMA_UIFR_OUTOFRANGE_MASK) | (((uint32_t)val) << ROTATE_IDMA_ROTATE_IDMA_UDMA_UIFR_OUTOFRANGE_SHIFT))

#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UIFR_RRESP_MASK 0x10
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UIFR_RRESP_SHIFT 4
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UIFR_RRESP_MASK_SHIFT(reg) (((reg) & ROTATE_IDMA_ROTATE_IDMA_UDMA_UIFR_RRESP_MASK) >> ROTATE_IDMA_ROTATE_IDMA_UDMA_UIFR_RRESP_SHIFT)
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UIFR_RRESP_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_IDMA_ROTATE_IDMA_UDMA_UIFR_RRESP_MASK) | (((uint32_t)val) << ROTATE_IDMA_ROTATE_IDMA_UDMA_UIFR_RRESP_SHIFT))

#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UIFR_BRESP_MASK 0x8
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UIFR_BRESP_SHIFT 3
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UIFR_BRESP_MASK_SHIFT(reg) (((reg) & ROTATE_IDMA_ROTATE_IDMA_UDMA_UIFR_BRESP_MASK) >> ROTATE_IDMA_ROTATE_IDMA_UDMA_UIFR_BRESP_SHIFT)
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UIFR_BRESP_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_IDMA_ROTATE_IDMA_UDMA_UIFR_BRESP_MASK) | (((uint32_t)val) << ROTATE_IDMA_ROTATE_IDMA_UDMA_UIFR_BRESP_SHIFT))

#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UIFR_CLEARCOMPLETE_MASK 0x4
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UIFR_CLEARCOMPLETE_SHIFT 2
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UIFR_CLEARCOMPLETE_MASK_SHIFT(reg) (((reg) & ROTATE_IDMA_ROTATE_IDMA_UDMA_UIFR_CLEARCOMPLETE_MASK) >> ROTATE_IDMA_ROTATE_IDMA_UDMA_UIFR_CLEARCOMPLETE_SHIFT)
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UIFR_CLEARCOMPLETE_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_IDMA_ROTATE_IDMA_UDMA_UIFR_CLEARCOMPLETE_MASK) | (((uint32_t)val) << ROTATE_IDMA_ROTATE_IDMA_UDMA_UIFR_CLEARCOMPLETE_SHIFT))

#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UIFR_DESC_MASK 0x2
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UIFR_DESC_SHIFT 1
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UIFR_DESC_MASK_SHIFT(reg) (((reg) & ROTATE_IDMA_ROTATE_IDMA_UDMA_UIFR_DESC_MASK) >> ROTATE_IDMA_ROTATE_IDMA_UDMA_UIFR_DESC_SHIFT)
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UIFR_DESC_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_IDMA_ROTATE_IDMA_UDMA_UIFR_DESC_MASK) | (((uint32_t)val) << ROTATE_IDMA_ROTATE_IDMA_UDMA_UIFR_DESC_SHIFT))

#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UIFR_OWN_MASK 0x1
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UIFR_OWN_SHIFT 0
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UIFR_OWN_MASK_SHIFT(reg) (((reg) & ROTATE_IDMA_ROTATE_IDMA_UDMA_UIFR_OWN_MASK) >> ROTATE_IDMA_ROTATE_IDMA_UDMA_UIFR_OWN_SHIFT)
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UIFR_OWN_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_IDMA_ROTATE_IDMA_UDMA_UIFR_OWN_MASK) | (((uint32_t)val) << ROTATE_IDMA_ROTATE_IDMA_UDMA_UIFR_OWN_SHIFT))

//====================================================================
//Register: UDMA Descriptor Register (UDR)
//====================================================================

#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UDR_DESC_MASK 0xffffffff
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UDR_DESC_SHIFT 0
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UDR_DESC_MASK_SHIFT(reg) (((reg) & ROTATE_IDMA_ROTATE_IDMA_UDMA_UDR_DESC_MASK) >> ROTATE_IDMA_ROTATE_IDMA_UDMA_UDR_DESC_SHIFT)
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UDR_DESC_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_IDMA_ROTATE_IDMA_UDMA_UDR_DESC_MASK) | (((uint32_t)val) << ROTATE_IDMA_ROTATE_IDMA_UDMA_UDR_DESC_SHIFT))

//====================================================================
//Register: UDMA Burst Address Register (UBAR)
//====================================================================

#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UBAR_BURSTADDR_MASK 0xffffffff
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UBAR_BURSTADDR_SHIFT 0
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UBAR_BURSTADDR_MASK_SHIFT(reg) (((reg) & ROTATE_IDMA_ROTATE_IDMA_UDMA_UBAR_BURSTADDR_MASK) >> ROTATE_IDMA_ROTATE_IDMA_UDMA_UBAR_BURSTADDR_SHIFT)
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UBAR_BURSTADDR_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_IDMA_ROTATE_IDMA_UDMA_UBAR_BURSTADDR_MASK) | (((uint32_t)val) << ROTATE_IDMA_ROTATE_IDMA_UDMA_UBAR_BURSTADDR_SHIFT))

//====================================================================
//Register: UDMA Burst Length Register (UBLR)
//====================================================================

#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UBLR_RESERVED1_MASK 0xfffffc00
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UBLR_RESERVED1_SHIFT 10
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UBLR_RESERVED1_MASK_SHIFT(reg) (((reg) & ROTATE_IDMA_ROTATE_IDMA_UDMA_UBLR_RESERVED1_MASK) >> ROTATE_IDMA_ROTATE_IDMA_UDMA_UBLR_RESERVED1_SHIFT)
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UBLR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_IDMA_ROTATE_IDMA_UDMA_UBLR_RESERVED1_MASK) | (((uint32_t)val) << ROTATE_IDMA_ROTATE_IDMA_UDMA_UBLR_RESERVED1_SHIFT))

#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UBLR_BURSTDIR_MASK 0x200
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UBLR_BURSTDIR_SHIFT 9
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UBLR_BURSTDIR_MASK_SHIFT(reg) (((reg) & ROTATE_IDMA_ROTATE_IDMA_UDMA_UBLR_BURSTDIR_MASK) >> ROTATE_IDMA_ROTATE_IDMA_UDMA_UBLR_BURSTDIR_SHIFT)
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UBLR_BURSTDIR_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_IDMA_ROTATE_IDMA_UDMA_UBLR_BURSTDIR_MASK) | (((uint32_t)val) << ROTATE_IDMA_ROTATE_IDMA_UDMA_UBLR_BURSTDIR_SHIFT))

#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UBLR_BURSTLAST_MASK 0x100
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UBLR_BURSTLAST_SHIFT 8
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UBLR_BURSTLAST_MASK_SHIFT(reg) (((reg) & ROTATE_IDMA_ROTATE_IDMA_UDMA_UBLR_BURSTLAST_MASK) >> ROTATE_IDMA_ROTATE_IDMA_UDMA_UBLR_BURSTLAST_SHIFT)
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UBLR_BURSTLAST_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_IDMA_ROTATE_IDMA_UDMA_UBLR_BURSTLAST_MASK) | (((uint32_t)val) << ROTATE_IDMA_ROTATE_IDMA_UDMA_UBLR_BURSTLAST_SHIFT))

#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UBLR_BURSTLENGTH_MASK 0xff
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UBLR_BURSTLENGTH_SHIFT 0
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UBLR_BURSTLENGTH_MASK_SHIFT(reg) (((reg) & ROTATE_IDMA_ROTATE_IDMA_UDMA_UBLR_BURSTLENGTH_MASK) >> ROTATE_IDMA_ROTATE_IDMA_UDMA_UBLR_BURSTLENGTH_SHIFT)
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UBLR_BURSTLENGTH_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_IDMA_ROTATE_IDMA_UDMA_UBLR_BURSTLENGTH_MASK) | (((uint32_t)val) << ROTATE_IDMA_ROTATE_IDMA_UDMA_UBLR_BURSTLENGTH_SHIFT))

//====================================================================
//Register: UDMA Transfer Bytes Remaining Register (UBRR)
//====================================================================

#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UBRR_BYTESREMAIN_MASK 0xffffffff
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UBRR_BYTESREMAIN_SHIFT 0
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UBRR_BYTESREMAIN_MASK_SHIFT(reg) (((reg) & ROTATE_IDMA_ROTATE_IDMA_UDMA_UBRR_BYTESREMAIN_MASK) >> ROTATE_IDMA_ROTATE_IDMA_UDMA_UBRR_BYTESREMAIN_SHIFT)
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UBRR_BYTESREMAIN_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_IDMA_ROTATE_IDMA_UDMA_UBRR_BYTESREMAIN_MASK) | (((uint32_t)val) << ROTATE_IDMA_ROTATE_IDMA_UDMA_UBRR_BYTESREMAIN_SHIFT))

//====================================================================
//Register: UDMA Tag Register 0 (UTR0)
//====================================================================

#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UTR0_TAGMAJ_MASK 0xffff0000
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UTR0_TAGMAJ_SHIFT 16
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UTR0_TAGMAJ_MASK_SHIFT(reg) (((reg) & ROTATE_IDMA_ROTATE_IDMA_UDMA_UTR0_TAGMAJ_MASK) >> ROTATE_IDMA_ROTATE_IDMA_UDMA_UTR0_TAGMAJ_SHIFT)
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UTR0_TAGMAJ_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_IDMA_ROTATE_IDMA_UDMA_UTR0_TAGMAJ_MASK) | (((uint32_t)val) << ROTATE_IDMA_ROTATE_IDMA_UDMA_UTR0_TAGMAJ_SHIFT))

#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UTR0_TAGMID_MASK 0xffff
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UTR0_TAGMID_SHIFT 0
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UTR0_TAGMID_MASK_SHIFT(reg) (((reg) & ROTATE_IDMA_ROTATE_IDMA_UDMA_UTR0_TAGMID_MASK) >> ROTATE_IDMA_ROTATE_IDMA_UDMA_UTR0_TAGMID_SHIFT)
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UTR0_TAGMID_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_IDMA_ROTATE_IDMA_UDMA_UTR0_TAGMID_MASK) | (((uint32_t)val) << ROTATE_IDMA_ROTATE_IDMA_UDMA_UTR0_TAGMID_SHIFT))

//====================================================================
//Register: UDMA Tag Register 1 (UTR1)
//====================================================================

#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UTR1_RESERVED1_MASK 0xffff0000
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UTR1_RESERVED1_SHIFT 16
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UTR1_RESERVED1_MASK_SHIFT(reg) (((reg) & ROTATE_IDMA_ROTATE_IDMA_UDMA_UTR1_RESERVED1_MASK) >> ROTATE_IDMA_ROTATE_IDMA_UDMA_UTR1_RESERVED1_SHIFT)
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UTR1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_IDMA_ROTATE_IDMA_UDMA_UTR1_RESERVED1_MASK) | (((uint32_t)val) << ROTATE_IDMA_ROTATE_IDMA_UDMA_UTR1_RESERVED1_SHIFT))

#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UTR1_TAGCFG_MASK 0xffff
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UTR1_TAGCFG_SHIFT 0
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UTR1_TAGCFG_MASK_SHIFT(reg) (((reg) & ROTATE_IDMA_ROTATE_IDMA_UDMA_UTR1_TAGCFG_MASK) >> ROTATE_IDMA_ROTATE_IDMA_UDMA_UTR1_TAGCFG_SHIFT)
#define  ROTATE_IDMA_ROTATE_IDMA_UDMA_UTR1_TAGCFG_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_IDMA_ROTATE_IDMA_UDMA_UTR1_TAGCFG_MASK) | (((uint32_t)val) << ROTATE_IDMA_ROTATE_IDMA_UDMA_UTR1_TAGCFG_SHIFT))

//====================================================================
//
//Register File: ROTATE_IDMA_CORE (ROTATE_IDMA_ROTATE_IDMA_CORE)
//
//====================================================================

//====================================================================
//Register: IDMA Configuration Register (ICFG)
//====================================================================

#define  ROTATE_IDMA_ROTATE_IDMA_CORE_ICFG_RESERVED1_MASK 0xfffffff8
#define  ROTATE_IDMA_ROTATE_IDMA_CORE_ICFG_RESERVED1_SHIFT 3
#define  ROTATE_IDMA_ROTATE_IDMA_CORE_ICFG_RESERVED1_MASK_SHIFT(reg) (((reg) & ROTATE_IDMA_ROTATE_IDMA_CORE_ICFG_RESERVED1_MASK) >> ROTATE_IDMA_ROTATE_IDMA_CORE_ICFG_RESERVED1_SHIFT)
#define  ROTATE_IDMA_ROTATE_IDMA_CORE_ICFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_IDMA_ROTATE_IDMA_CORE_ICFG_RESERVED1_MASK) | (((uint32_t)val) << ROTATE_IDMA_ROTATE_IDMA_CORE_ICFG_RESERVED1_SHIFT))

#define  ROTATE_IDMA_ROTATE_IDMA_CORE_ICFG_OUTWIDTH_MASK 0x4
#define  ROTATE_IDMA_ROTATE_IDMA_CORE_ICFG_OUTWIDTH_SHIFT 2
#define  ROTATE_IDMA_ROTATE_IDMA_CORE_ICFG_OUTWIDTH_MASK_SHIFT(reg) (((reg) & ROTATE_IDMA_ROTATE_IDMA_CORE_ICFG_OUTWIDTH_MASK) >> ROTATE_IDMA_ROTATE_IDMA_CORE_ICFG_OUTWIDTH_SHIFT)
#define  ROTATE_IDMA_ROTATE_IDMA_CORE_ICFG_OUTWIDTH_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_IDMA_ROTATE_IDMA_CORE_ICFG_OUTWIDTH_MASK) | (((uint32_t)val) << ROTATE_IDMA_ROTATE_IDMA_CORE_ICFG_OUTWIDTH_SHIFT))

#define  ROTATE_IDMA_ROTATE_IDMA_CORE_ICFG_BOTTOMTOTOP_MASK 0x2
#define  ROTATE_IDMA_ROTATE_IDMA_CORE_ICFG_BOTTOMTOTOP_SHIFT 1
#define  ROTATE_IDMA_ROTATE_IDMA_CORE_ICFG_BOTTOMTOTOP_MASK_SHIFT(reg) (((reg) & ROTATE_IDMA_ROTATE_IDMA_CORE_ICFG_BOTTOMTOTOP_MASK) >> ROTATE_IDMA_ROTATE_IDMA_CORE_ICFG_BOTTOMTOTOP_SHIFT)
#define  ROTATE_IDMA_ROTATE_IDMA_CORE_ICFG_BOTTOMTOTOP_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_IDMA_ROTATE_IDMA_CORE_ICFG_BOTTOMTOTOP_MASK) | (((uint32_t)val) << ROTATE_IDMA_ROTATE_IDMA_CORE_ICFG_BOTTOMTOTOP_SHIFT))

#define  ROTATE_IDMA_ROTATE_IDMA_CORE_ICFG_MODE_MASK 0x1
#define  ROTATE_IDMA_ROTATE_IDMA_CORE_ICFG_MODE_SHIFT 0
#define  ROTATE_IDMA_ROTATE_IDMA_CORE_ICFG_MODE_MASK_SHIFT(reg) (((reg) & ROTATE_IDMA_ROTATE_IDMA_CORE_ICFG_MODE_MASK) >> ROTATE_IDMA_ROTATE_IDMA_CORE_ICFG_MODE_SHIFT)
#define  ROTATE_IDMA_ROTATE_IDMA_CORE_ICFG_MODE_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_IDMA_ROTATE_IDMA_CORE_ICFG_MODE_MASK) | (((uint32_t)val) << ROTATE_IDMA_ROTATE_IDMA_CORE_ICFG_MODE_SHIFT))

//====================================================================
//Register: IDMA Image Line Width Register (ILW)
//====================================================================

#define  ROTATE_IDMA_ROTATE_IDMA_CORE_ILW_LINESTRIDE_MASK 0xffff0000
#define  ROTATE_IDMA_ROTATE_IDMA_CORE_ILW_LINESTRIDE_SHIFT 16
#define  ROTATE_IDMA_ROTATE_IDMA_CORE_ILW_LINESTRIDE_MASK_SHIFT(reg) (((reg) & ROTATE_IDMA_ROTATE_IDMA_CORE_ILW_LINESTRIDE_MASK) >> ROTATE_IDMA_ROTATE_IDMA_CORE_ILW_LINESTRIDE_SHIFT)
#define  ROTATE_IDMA_ROTATE_IDMA_CORE_ILW_LINESTRIDE_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_IDMA_ROTATE_IDMA_CORE_ILW_LINESTRIDE_MASK) | (((uint32_t)val) << ROTATE_IDMA_ROTATE_IDMA_CORE_ILW_LINESTRIDE_SHIFT))

#define  ROTATE_IDMA_ROTATE_IDMA_CORE_ILW_LINEWIDTH_MASK 0xffff
#define  ROTATE_IDMA_ROTATE_IDMA_CORE_ILW_LINEWIDTH_SHIFT 0
#define  ROTATE_IDMA_ROTATE_IDMA_CORE_ILW_LINEWIDTH_MASK_SHIFT(reg) (((reg) & ROTATE_IDMA_ROTATE_IDMA_CORE_ILW_LINEWIDTH_MASK) >> ROTATE_IDMA_ROTATE_IDMA_CORE_ILW_LINEWIDTH_SHIFT)
#define  ROTATE_IDMA_ROTATE_IDMA_CORE_ILW_LINEWIDTH_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_IDMA_ROTATE_IDMA_CORE_ILW_LINEWIDTH_MASK) | (((uint32_t)val) << ROTATE_IDMA_ROTATE_IDMA_CORE_ILW_LINEWIDTH_SHIFT))

//====================================================================
//Register: IDMA Image Height Register (IIH)
//====================================================================

#define  ROTATE_IDMA_ROTATE_IDMA_CORE_IIH_RESERVED1_MASK 0xffff0000
#define  ROTATE_IDMA_ROTATE_IDMA_CORE_IIH_RESERVED1_SHIFT 16
#define  ROTATE_IDMA_ROTATE_IDMA_CORE_IIH_RESERVED1_MASK_SHIFT(reg) (((reg) & ROTATE_IDMA_ROTATE_IDMA_CORE_IIH_RESERVED1_MASK) >> ROTATE_IDMA_ROTATE_IDMA_CORE_IIH_RESERVED1_SHIFT)
#define  ROTATE_IDMA_ROTATE_IDMA_CORE_IIH_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_IDMA_ROTATE_IDMA_CORE_IIH_RESERVED1_MASK) | (((uint32_t)val) << ROTATE_IDMA_ROTATE_IDMA_CORE_IIH_RESERVED1_SHIFT))

#define  ROTATE_IDMA_ROTATE_IDMA_CORE_IIH_IMAGEHEIGHT_MASK 0xffff
#define  ROTATE_IDMA_ROTATE_IDMA_CORE_IIH_IMAGEHEIGHT_SHIFT 0
#define  ROTATE_IDMA_ROTATE_IDMA_CORE_IIH_IMAGEHEIGHT_MASK_SHIFT(reg) (((reg) & ROTATE_IDMA_ROTATE_IDMA_CORE_IIH_IMAGEHEIGHT_MASK) >> ROTATE_IDMA_ROTATE_IDMA_CORE_IIH_IMAGEHEIGHT_SHIFT)
#define  ROTATE_IDMA_ROTATE_IDMA_CORE_IIH_IMAGEHEIGHT_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_IDMA_ROTATE_IDMA_CORE_IIH_IMAGEHEIGHT_MASK) | (((uint32_t)val) << ROTATE_IDMA_ROTATE_IDMA_CORE_IIH_IMAGEHEIGHT_SHIFT))

//====================================================================
//Register: IDMA Tile Size Register (ITS)
//====================================================================

#define  ROTATE_IDMA_ROTATE_IDMA_CORE_ITS_TILEHEIGHT_MASK 0xffff0000
#define  ROTATE_IDMA_ROTATE_IDMA_CORE_ITS_TILEHEIGHT_SHIFT 16
#define  ROTATE_IDMA_ROTATE_IDMA_CORE_ITS_TILEHEIGHT_MASK_SHIFT(reg) (((reg) & ROTATE_IDMA_ROTATE_IDMA_CORE_ITS_TILEHEIGHT_MASK) >> ROTATE_IDMA_ROTATE_IDMA_CORE_ITS_TILEHEIGHT_SHIFT)
#define  ROTATE_IDMA_ROTATE_IDMA_CORE_ITS_TILEHEIGHT_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_IDMA_ROTATE_IDMA_CORE_ITS_TILEHEIGHT_MASK) | (((uint32_t)val) << ROTATE_IDMA_ROTATE_IDMA_CORE_ITS_TILEHEIGHT_SHIFT))

#define  ROTATE_IDMA_ROTATE_IDMA_CORE_ITS_TILEWIDTH_MASK 0xffff
#define  ROTATE_IDMA_ROTATE_IDMA_CORE_ITS_TILEWIDTH_SHIFT 0
#define  ROTATE_IDMA_ROTATE_IDMA_CORE_ITS_TILEWIDTH_MASK_SHIFT(reg) (((reg) & ROTATE_IDMA_ROTATE_IDMA_CORE_ITS_TILEWIDTH_MASK) >> ROTATE_IDMA_ROTATE_IDMA_CORE_ITS_TILEWIDTH_SHIFT)
#define  ROTATE_IDMA_ROTATE_IDMA_CORE_ITS_TILEWIDTH_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_IDMA_ROTATE_IDMA_CORE_ITS_TILEWIDTH_MASK) | (((uint32_t)val) << ROTATE_IDMA_ROTATE_IDMA_CORE_ITS_TILEWIDTH_SHIFT))

//====================================================================
//Register: IDMA Swath Offset Register (ISOFFST)
//====================================================================

#define  ROTATE_IDMA_ROTATE_IDMA_CORE_ISOFFST_SWATHOFFSET_MASK 0xffffffff
#define  ROTATE_IDMA_ROTATE_IDMA_CORE_ISOFFST_SWATHOFFSET_SHIFT 0
#define  ROTATE_IDMA_ROTATE_IDMA_CORE_ISOFFST_SWATHOFFSET_MASK_SHIFT(reg) (((reg) & ROTATE_IDMA_ROTATE_IDMA_CORE_ISOFFST_SWATHOFFSET_MASK) >> ROTATE_IDMA_ROTATE_IDMA_CORE_ISOFFST_SWATHOFFSET_SHIFT)
#define  ROTATE_IDMA_ROTATE_IDMA_CORE_ISOFFST_SWATHOFFSET_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_IDMA_ROTATE_IDMA_CORE_ISOFFST_SWATHOFFSET_MASK) | (((uint32_t)val) << ROTATE_IDMA_ROTATE_IDMA_CORE_ISOFFST_SWATHOFFSET_SHIFT))

//====================================================================
//Register: IDMA Tile Offset Register (ITOFFST)
//====================================================================

#define  ROTATE_IDMA_ROTATE_IDMA_CORE_ITOFFST_TILEOFFSET_MASK 0xffffffff
#define  ROTATE_IDMA_ROTATE_IDMA_CORE_ITOFFST_TILEOFFSET_SHIFT 0
#define  ROTATE_IDMA_ROTATE_IDMA_CORE_ITOFFST_TILEOFFSET_MASK_SHIFT(reg) (((reg) & ROTATE_IDMA_ROTATE_IDMA_CORE_ITOFFST_TILEOFFSET_MASK) >> ROTATE_IDMA_ROTATE_IDMA_CORE_ITOFFST_TILEOFFSET_SHIFT)
#define  ROTATE_IDMA_ROTATE_IDMA_CORE_ITOFFST_TILEOFFSET_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_IDMA_ROTATE_IDMA_CORE_ITOFFST_TILEOFFSET_MASK) | (((uint32_t)val) << ROTATE_IDMA_ROTATE_IDMA_CORE_ITOFFST_TILEOFFSET_SHIFT))

//====================================================================
//Register: IDMA Interrupt Enable Register (IIER)
//====================================================================

#define  ROTATE_IDMA_ROTATE_IDMA_CORE_IIER_RESERVED1_MASK 0xfffffffe
#define  ROTATE_IDMA_ROTATE_IDMA_CORE_IIER_RESERVED1_SHIFT 1
#define  ROTATE_IDMA_ROTATE_IDMA_CORE_IIER_RESERVED1_MASK_SHIFT(reg) (((reg) & ROTATE_IDMA_ROTATE_IDMA_CORE_IIER_RESERVED1_MASK) >> ROTATE_IDMA_ROTATE_IDMA_CORE_IIER_RESERVED1_SHIFT)
#define  ROTATE_IDMA_ROTATE_IDMA_CORE_IIER_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_IDMA_ROTATE_IDMA_CORE_IIER_RESERVED1_MASK) | (((uint32_t)val) << ROTATE_IDMA_ROTATE_IDMA_CORE_IIER_RESERVED1_SHIFT))

#define  ROTATE_IDMA_ROTATE_IDMA_CORE_IIER_LENGTHERR_MASK 0x1
#define  ROTATE_IDMA_ROTATE_IDMA_CORE_IIER_LENGTHERR_SHIFT 0
#define  ROTATE_IDMA_ROTATE_IDMA_CORE_IIER_LENGTHERR_MASK_SHIFT(reg) (((reg) & ROTATE_IDMA_ROTATE_IDMA_CORE_IIER_LENGTHERR_MASK) >> ROTATE_IDMA_ROTATE_IDMA_CORE_IIER_LENGTHERR_SHIFT)
#define  ROTATE_IDMA_ROTATE_IDMA_CORE_IIER_LENGTHERR_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_IDMA_ROTATE_IDMA_CORE_IIER_LENGTHERR_MASK) | (((uint32_t)val) << ROTATE_IDMA_ROTATE_IDMA_CORE_IIER_LENGTHERR_SHIFT))

//====================================================================
//Register: IDMA Interrupt Pending Register (IIPR)
//====================================================================

#define  ROTATE_IDMA_ROTATE_IDMA_CORE_IIPR_RESERVED1_MASK 0xfffffffe
#define  ROTATE_IDMA_ROTATE_IDMA_CORE_IIPR_RESERVED1_SHIFT 1
#define  ROTATE_IDMA_ROTATE_IDMA_CORE_IIPR_RESERVED1_MASK_SHIFT(reg) (((reg) & ROTATE_IDMA_ROTATE_IDMA_CORE_IIPR_RESERVED1_MASK) >> ROTATE_IDMA_ROTATE_IDMA_CORE_IIPR_RESERVED1_SHIFT)
#define  ROTATE_IDMA_ROTATE_IDMA_CORE_IIPR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_IDMA_ROTATE_IDMA_CORE_IIPR_RESERVED1_MASK) | (((uint32_t)val) << ROTATE_IDMA_ROTATE_IDMA_CORE_IIPR_RESERVED1_SHIFT))

#define  ROTATE_IDMA_ROTATE_IDMA_CORE_IIPR_LENGTHERR_MASK 0x1
#define  ROTATE_IDMA_ROTATE_IDMA_CORE_IIPR_LENGTHERR_SHIFT 0
#define  ROTATE_IDMA_ROTATE_IDMA_CORE_IIPR_LENGTHERR_MASK_SHIFT(reg) (((reg) & ROTATE_IDMA_ROTATE_IDMA_CORE_IIPR_LENGTHERR_MASK) >> ROTATE_IDMA_ROTATE_IDMA_CORE_IIPR_LENGTHERR_SHIFT)
#define  ROTATE_IDMA_ROTATE_IDMA_CORE_IIPR_LENGTHERR_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_IDMA_ROTATE_IDMA_CORE_IIPR_LENGTHERR_MASK) | (((uint32_t)val) << ROTATE_IDMA_ROTATE_IDMA_CORE_IIPR_LENGTHERR_SHIFT))

//====================================================================
//Register: IDMA Interrupt Clear Register (IICR)
//====================================================================

#define  ROTATE_IDMA_ROTATE_IDMA_CORE_IICR_RESERVED1_MASK 0xfffffffe
#define  ROTATE_IDMA_ROTATE_IDMA_CORE_IICR_RESERVED1_SHIFT 1
#define  ROTATE_IDMA_ROTATE_IDMA_CORE_IICR_RESERVED1_MASK_SHIFT(reg) (((reg) & ROTATE_IDMA_ROTATE_IDMA_CORE_IICR_RESERVED1_MASK) >> ROTATE_IDMA_ROTATE_IDMA_CORE_IICR_RESERVED1_SHIFT)
#define  ROTATE_IDMA_ROTATE_IDMA_CORE_IICR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_IDMA_ROTATE_IDMA_CORE_IICR_RESERVED1_MASK) | (((uint32_t)val) << ROTATE_IDMA_ROTATE_IDMA_CORE_IICR_RESERVED1_SHIFT))

#define  ROTATE_IDMA_ROTATE_IDMA_CORE_IICR_LENGTHERR_MASK 0x1
#define  ROTATE_IDMA_ROTATE_IDMA_CORE_IICR_LENGTHERR_SHIFT 0
#define  ROTATE_IDMA_ROTATE_IDMA_CORE_IICR_LENGTHERR_MASK_SHIFT(reg) (((reg) & ROTATE_IDMA_ROTATE_IDMA_CORE_IICR_LENGTHERR_MASK) >> ROTATE_IDMA_ROTATE_IDMA_CORE_IICR_LENGTHERR_SHIFT)
#define  ROTATE_IDMA_ROTATE_IDMA_CORE_IICR_LENGTHERR_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_IDMA_ROTATE_IDMA_CORE_IICR_LENGTHERR_MASK) | (((uint32_t)val) << ROTATE_IDMA_ROTATE_IDMA_CORE_IICR_LENGTHERR_SHIFT))

//====================================================================
//Register: IDMA Interrupt Force Register (IIFR)
//====================================================================

#define  ROTATE_IDMA_ROTATE_IDMA_CORE_IIFR_RESERVED1_MASK 0xfffffffe
#define  ROTATE_IDMA_ROTATE_IDMA_CORE_IIFR_RESERVED1_SHIFT 1
#define  ROTATE_IDMA_ROTATE_IDMA_CORE_IIFR_RESERVED1_MASK_SHIFT(reg) (((reg) & ROTATE_IDMA_ROTATE_IDMA_CORE_IIFR_RESERVED1_MASK) >> ROTATE_IDMA_ROTATE_IDMA_CORE_IIFR_RESERVED1_SHIFT)
#define  ROTATE_IDMA_ROTATE_IDMA_CORE_IIFR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_IDMA_ROTATE_IDMA_CORE_IIFR_RESERVED1_MASK) | (((uint32_t)val) << ROTATE_IDMA_ROTATE_IDMA_CORE_IIFR_RESERVED1_SHIFT))

#define  ROTATE_IDMA_ROTATE_IDMA_CORE_IIFR_LENGTHERR_MASK 0x1
#define  ROTATE_IDMA_ROTATE_IDMA_CORE_IIFR_LENGTHERR_SHIFT 0
#define  ROTATE_IDMA_ROTATE_IDMA_CORE_IIFR_LENGTHERR_MASK_SHIFT(reg) (((reg) & ROTATE_IDMA_ROTATE_IDMA_CORE_IIFR_LENGTHERR_MASK) >> ROTATE_IDMA_ROTATE_IDMA_CORE_IIFR_LENGTHERR_SHIFT)
#define  ROTATE_IDMA_ROTATE_IDMA_CORE_IIFR_LENGTHERR_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_IDMA_ROTATE_IDMA_CORE_IIFR_LENGTHERR_MASK) | (((uint32_t)val) << ROTATE_IDMA_ROTATE_IDMA_CORE_IIFR_LENGTHERR_SHIFT))

//====================================================================
//Register: IDMA Tag Register 0 (ITR0)
//====================================================================

#define  ROTATE_IDMA_ROTATE_IDMA_CORE_ITR0_RESERVED1_MASK 0xffff0000
#define  ROTATE_IDMA_ROTATE_IDMA_CORE_ITR0_RESERVED1_SHIFT 16
#define  ROTATE_IDMA_ROTATE_IDMA_CORE_ITR0_RESERVED1_MASK_SHIFT(reg) (((reg) & ROTATE_IDMA_ROTATE_IDMA_CORE_ITR0_RESERVED1_MASK) >> ROTATE_IDMA_ROTATE_IDMA_CORE_ITR0_RESERVED1_SHIFT)
#define  ROTATE_IDMA_ROTATE_IDMA_CORE_ITR0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_IDMA_ROTATE_IDMA_CORE_ITR0_RESERVED1_MASK) | (((uint32_t)val) << ROTATE_IDMA_ROTATE_IDMA_CORE_ITR0_RESERVED1_SHIFT))

#define  ROTATE_IDMA_ROTATE_IDMA_CORE_ITR0_TAGCFG_MASK 0xffff
#define  ROTATE_IDMA_ROTATE_IDMA_CORE_ITR0_TAGCFG_SHIFT 0
#define  ROTATE_IDMA_ROTATE_IDMA_CORE_ITR0_TAGCFG_MASK_SHIFT(reg) (((reg) & ROTATE_IDMA_ROTATE_IDMA_CORE_ITR0_TAGCFG_MASK) >> ROTATE_IDMA_ROTATE_IDMA_CORE_ITR0_TAGCFG_SHIFT)
#define  ROTATE_IDMA_ROTATE_IDMA_CORE_ITR0_TAGCFG_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_IDMA_ROTATE_IDMA_CORE_ITR0_TAGCFG_MASK) | (((uint32_t)val) << ROTATE_IDMA_ROTATE_IDMA_CORE_ITR0_TAGCFG_SHIFT))

//====================================================================
//Register: IDMA Tag Register 1 (ITR1)
//====================================================================

#define  ROTATE_IDMA_ROTATE_IDMA_CORE_ITR1_RESERVED1_MASK 0xffff0000
#define  ROTATE_IDMA_ROTATE_IDMA_CORE_ITR1_RESERVED1_SHIFT 16
#define  ROTATE_IDMA_ROTATE_IDMA_CORE_ITR1_RESERVED1_MASK_SHIFT(reg) (((reg) & ROTATE_IDMA_ROTATE_IDMA_CORE_ITR1_RESERVED1_MASK) >> ROTATE_IDMA_ROTATE_IDMA_CORE_ITR1_RESERVED1_SHIFT)
#define  ROTATE_IDMA_ROTATE_IDMA_CORE_ITR1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_IDMA_ROTATE_IDMA_CORE_ITR1_RESERVED1_MASK) | (((uint32_t)val) << ROTATE_IDMA_ROTATE_IDMA_CORE_ITR1_RESERVED1_SHIFT))

#define  ROTATE_IDMA_ROTATE_IDMA_CORE_ITR1_TAGMAJ_MASK 0xffff
#define  ROTATE_IDMA_ROTATE_IDMA_CORE_ITR1_TAGMAJ_SHIFT 0
#define  ROTATE_IDMA_ROTATE_IDMA_CORE_ITR1_TAGMAJ_MASK_SHIFT(reg) (((reg) & ROTATE_IDMA_ROTATE_IDMA_CORE_ITR1_TAGMAJ_MASK) >> ROTATE_IDMA_ROTATE_IDMA_CORE_ITR1_TAGMAJ_SHIFT)
#define  ROTATE_IDMA_ROTATE_IDMA_CORE_ITR1_TAGMAJ_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_IDMA_ROTATE_IDMA_CORE_ITR1_TAGMAJ_MASK) | (((uint32_t)val) << ROTATE_IDMA_ROTATE_IDMA_CORE_ITR1_TAGMAJ_SHIFT))

//====================================================================
//Register: IDMA Tag Register 2 (ITR2)
//====================================================================

#define  ROTATE_IDMA_ROTATE_IDMA_CORE_ITR2_RESERVED1_MASK 0xffff0000
#define  ROTATE_IDMA_ROTATE_IDMA_CORE_ITR2_RESERVED1_SHIFT 16
#define  ROTATE_IDMA_ROTATE_IDMA_CORE_ITR2_RESERVED1_MASK_SHIFT(reg) (((reg) & ROTATE_IDMA_ROTATE_IDMA_CORE_ITR2_RESERVED1_MASK) >> ROTATE_IDMA_ROTATE_IDMA_CORE_ITR2_RESERVED1_SHIFT)
#define  ROTATE_IDMA_ROTATE_IDMA_CORE_ITR2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_IDMA_ROTATE_IDMA_CORE_ITR2_RESERVED1_MASK) | (((uint32_t)val) << ROTATE_IDMA_ROTATE_IDMA_CORE_ITR2_RESERVED1_SHIFT))

#define  ROTATE_IDMA_ROTATE_IDMA_CORE_ITR2_TAGMID_MASK 0xffff
#define  ROTATE_IDMA_ROTATE_IDMA_CORE_ITR2_TAGMID_SHIFT 0
#define  ROTATE_IDMA_ROTATE_IDMA_CORE_ITR2_TAGMID_MASK_SHIFT(reg) (((reg) & ROTATE_IDMA_ROTATE_IDMA_CORE_ITR2_TAGMID_MASK) >> ROTATE_IDMA_ROTATE_IDMA_CORE_ITR2_TAGMID_SHIFT)
#define  ROTATE_IDMA_ROTATE_IDMA_CORE_ITR2_TAGMID_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_IDMA_ROTATE_IDMA_CORE_ITR2_TAGMID_MASK) | (((uint32_t)val) << ROTATE_IDMA_ROTATE_IDMA_CORE_ITR2_TAGMID_SHIFT))

//====================================================================
//
//Register File: ROTATE_ODMA_UDMA (ROTATE_ODMA_ROTATE_ODMA_UDMA)
//
//====================================================================

//====================================================================
//Register: UDMA Configuration Register (UCR)
//====================================================================

#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UCR_RESERVED1_MASK 0xfff00000
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UCR_RESERVED1_SHIFT 20
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UCR_RESERVED1_MASK_SHIFT(reg) (((reg) & ROTATE_ODMA_ROTATE_ODMA_UDMA_UCR_RESERVED1_MASK) >> ROTATE_ODMA_ROTATE_ODMA_UDMA_UCR_RESERVED1_SHIFT)
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UCR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_ODMA_ROTATE_ODMA_UDMA_UCR_RESERVED1_MASK) | (((uint32_t)val) << ROTATE_ODMA_ROTATE_ODMA_UDMA_UCR_RESERVED1_SHIFT))

#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UCR_DATAAXCACHE_MASK 0xf0000
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UCR_DATAAXCACHE_SHIFT 16
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UCR_DATAAXCACHE_MASK_SHIFT(reg) (((reg) & ROTATE_ODMA_ROTATE_ODMA_UDMA_UCR_DATAAXCACHE_MASK) >> ROTATE_ODMA_ROTATE_ODMA_UDMA_UCR_DATAAXCACHE_SHIFT)
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UCR_DATAAXCACHE_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_ODMA_ROTATE_ODMA_UDMA_UCR_DATAAXCACHE_MASK) | (((uint32_t)val) << ROTATE_ODMA_ROTATE_ODMA_UDMA_UCR_DATAAXCACHE_SHIFT))

#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UCR_DESCARCACHE_MASK 0xf000
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UCR_DESCARCACHE_SHIFT 12
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UCR_DESCARCACHE_MASK_SHIFT(reg) (((reg) & ROTATE_ODMA_ROTATE_ODMA_UDMA_UCR_DESCARCACHE_MASK) >> ROTATE_ODMA_ROTATE_ODMA_UDMA_UCR_DESCARCACHE_SHIFT)
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UCR_DESCARCACHE_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_ODMA_ROTATE_ODMA_UDMA_UCR_DESCARCACHE_MASK) | (((uint32_t)val) << ROTATE_ODMA_ROTATE_ODMA_UDMA_UCR_DESCARCACHE_SHIFT))

#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UCR_DESCAWCACHE_MASK 0xf00
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UCR_DESCAWCACHE_SHIFT 8
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UCR_DESCAWCACHE_MASK_SHIFT(reg) (((reg) & ROTATE_ODMA_ROTATE_ODMA_UDMA_UCR_DESCAWCACHE_MASK) >> ROTATE_ODMA_ROTATE_ODMA_UDMA_UCR_DESCAWCACHE_SHIFT)
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UCR_DESCAWCACHE_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_ODMA_ROTATE_ODMA_UDMA_UCR_DESCAWCACHE_MASK) | (((uint32_t)val) << ROTATE_ODMA_ROTATE_ODMA_UDMA_UCR_DESCAWCACHE_SHIFT))

#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UCR_RESERVED2_MASK 0xc0
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UCR_RESERVED2_SHIFT 6
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UCR_RESERVED2_MASK_SHIFT(reg) (((reg) & ROTATE_ODMA_ROTATE_ODMA_UDMA_UCR_RESERVED2_MASK) >> ROTATE_ODMA_ROTATE_ODMA_UDMA_UCR_RESERVED2_SHIFT)
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UCR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_ODMA_ROTATE_ODMA_UDMA_UCR_RESERVED2_MASK) | (((uint32_t)val) << ROTATE_ODMA_ROTATE_ODMA_UDMA_UCR_RESERVED2_SHIFT))

#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UCR_HANDSHAKEENABLE_MASK 0x20
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UCR_HANDSHAKEENABLE_SHIFT 5
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UCR_HANDSHAKEENABLE_MASK_SHIFT(reg) (((reg) & ROTATE_ODMA_ROTATE_ODMA_UDMA_UCR_HANDSHAKEENABLE_MASK) >> ROTATE_ODMA_ROTATE_ODMA_UDMA_UCR_HANDSHAKEENABLE_SHIFT)
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UCR_HANDSHAKEENABLE_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_ODMA_ROTATE_ODMA_UDMA_UCR_HANDSHAKEENABLE_MASK) | (((uint32_t)val) << ROTATE_ODMA_ROTATE_ODMA_UDMA_UCR_HANDSHAKEENABLE_SHIFT))

#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UCR_OWNWRITEDISABLE_MASK 0x10
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UCR_OWNWRITEDISABLE_SHIFT 4
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UCR_OWNWRITEDISABLE_MASK_SHIFT(reg) (((reg) & ROTATE_ODMA_ROTATE_ODMA_UDMA_UCR_OWNWRITEDISABLE_MASK) >> ROTATE_ODMA_ROTATE_ODMA_UDMA_UCR_OWNWRITEDISABLE_SHIFT)
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UCR_OWNWRITEDISABLE_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_ODMA_ROTATE_ODMA_UDMA_UCR_OWNWRITEDISABLE_MASK) | (((uint32_t)val) << ROTATE_ODMA_ROTATE_ODMA_UDMA_UCR_OWNWRITEDISABLE_SHIFT))

#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UCR_OWNPOLARITY_MASK 0x8
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UCR_OWNPOLARITY_SHIFT 3
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UCR_OWNPOLARITY_MASK_SHIFT(reg) (((reg) & ROTATE_ODMA_ROTATE_ODMA_UDMA_UCR_OWNPOLARITY_MASK) >> ROTATE_ODMA_ROTATE_ODMA_UDMA_UCR_OWNPOLARITY_SHIFT)
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UCR_OWNPOLARITY_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_ODMA_ROTATE_ODMA_UDMA_UCR_OWNPOLARITY_MASK) | (((uint32_t)val) << ROTATE_ODMA_ROTATE_ODMA_UDMA_UCR_OWNPOLARITY_SHIFT))

#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UCR_BEATS_MASK 0x6
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UCR_BEATS_SHIFT 1
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UCR_BEATS_MASK_SHIFT(reg) (((reg) & ROTATE_ODMA_ROTATE_ODMA_UDMA_UCR_BEATS_MASK) >> ROTATE_ODMA_ROTATE_ODMA_UDMA_UCR_BEATS_SHIFT)
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UCR_BEATS_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_ODMA_ROTATE_ODMA_UDMA_UCR_BEATS_MASK) | (((uint32_t)val) << ROTATE_ODMA_ROTATE_ODMA_UDMA_UCR_BEATS_SHIFT))

#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UCR_ENABLE_MASK 0x1
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UCR_ENABLE_SHIFT 0
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UCR_ENABLE_MASK_SHIFT(reg) (((reg) & ROTATE_ODMA_ROTATE_ODMA_UDMA_UCR_ENABLE_MASK) >> ROTATE_ODMA_ROTATE_ODMA_UDMA_UCR_ENABLE_SHIFT)
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UCR_ENABLE_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_ODMA_ROTATE_ODMA_UDMA_UCR_ENABLE_MASK) | (((uint32_t)val) << ROTATE_ODMA_ROTATE_ODMA_UDMA_UCR_ENABLE_SHIFT))

//====================================================================
//Register: UDMA Status Register (USR)
//====================================================================

#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_USR_RESERVED1_MASK 0xfffff800
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_USR_RESERVED1_SHIFT 11
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_USR_RESERVED1_MASK_SHIFT(reg) (((reg) & ROTATE_ODMA_ROTATE_ODMA_UDMA_USR_RESERVED1_MASK) >> ROTATE_ODMA_ROTATE_ODMA_UDMA_USR_RESERVED1_SHIFT)
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_USR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_ODMA_ROTATE_ODMA_UDMA_USR_RESERVED1_MASK) | (((uint32_t)val) << ROTATE_ODMA_ROTATE_ODMA_UDMA_USR_RESERVED1_SHIFT))

#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_USR_DMAPAUSED_MASK 0x400
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_USR_DMAPAUSED_SHIFT 10
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_USR_DMAPAUSED_MASK_SHIFT(reg) (((reg) & ROTATE_ODMA_ROTATE_ODMA_UDMA_USR_DMAPAUSED_MASK) >> ROTATE_ODMA_ROTATE_ODMA_UDMA_USR_DMAPAUSED_SHIFT)
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_USR_DMAPAUSED_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_ODMA_ROTATE_ODMA_UDMA_USR_DMAPAUSED_MASK) | (((uint32_t)val) << ROTATE_ODMA_ROTATE_ODMA_UDMA_USR_DMAPAUSED_SHIFT))

#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_USR_PAUSEAFTER_MASK 0x200
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_USR_PAUSEAFTER_SHIFT 9
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_USR_PAUSEAFTER_MASK_SHIFT(reg) (((reg) & ROTATE_ODMA_ROTATE_ODMA_UDMA_USR_PAUSEAFTER_MASK) >> ROTATE_ODMA_ROTATE_ODMA_UDMA_USR_PAUSEAFTER_SHIFT)
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_USR_PAUSEAFTER_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_ODMA_ROTATE_ODMA_UDMA_USR_PAUSEAFTER_MASK) | (((uint32_t)val) << ROTATE_ODMA_ROTATE_ODMA_UDMA_USR_PAUSEAFTER_SHIFT))

#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_USR_PAUSEBEFORE_MASK 0x100
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_USR_PAUSEBEFORE_SHIFT 8
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_USR_PAUSEBEFORE_MASK_SHIFT(reg) (((reg) & ROTATE_ODMA_ROTATE_ODMA_UDMA_USR_PAUSEBEFORE_MASK) >> ROTATE_ODMA_ROTATE_ODMA_UDMA_USR_PAUSEBEFORE_SHIFT)
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_USR_PAUSEBEFORE_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_ODMA_ROTATE_ODMA_UDMA_USR_PAUSEBEFORE_MASK) | (((uint32_t)val) << ROTATE_ODMA_ROTATE_ODMA_UDMA_USR_PAUSEBEFORE_SHIFT))

#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_USR_INTONFINISH_MASK 0x80
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_USR_INTONFINISH_SHIFT 7
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_USR_INTONFINISH_MASK_SHIFT(reg) (((reg) & ROTATE_ODMA_ROTATE_ODMA_UDMA_USR_INTONFINISH_MASK) >> ROTATE_ODMA_ROTATE_ODMA_UDMA_USR_INTONFINISH_SHIFT)
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_USR_INTONFINISH_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_ODMA_ROTATE_ODMA_UDMA_USR_INTONFINISH_MASK) | (((uint32_t)val) << ROTATE_ODMA_ROTATE_ODMA_UDMA_USR_INTONFINISH_SHIFT))

#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_USR_STOPONFINISH_MASK 0x40
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_USR_STOPONFINISH_SHIFT 6
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_USR_STOPONFINISH_MASK_SHIFT(reg) (((reg) & ROTATE_ODMA_ROTATE_ODMA_UDMA_USR_STOPONFINISH_MASK) >> ROTATE_ODMA_ROTATE_ODMA_UDMA_USR_STOPONFINISH_SHIFT)
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_USR_STOPONFINISH_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_ODMA_ROTATE_ODMA_UDMA_USR_STOPONFINISH_MASK) | (((uint32_t)val) << ROTATE_ODMA_ROTATE_ODMA_UDMA_USR_STOPONFINISH_SHIFT))

#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_USR_CMDBUFFULL_MASK 0x20
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_USR_CMDBUFFULL_SHIFT 5
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_USR_CMDBUFFULL_MASK_SHIFT(reg) (((reg) & ROTATE_ODMA_ROTATE_ODMA_UDMA_USR_CMDBUFFULL_MASK) >> ROTATE_ODMA_ROTATE_ODMA_UDMA_USR_CMDBUFFULL_SHIFT)
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_USR_CMDBUFFULL_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_ODMA_ROTATE_ODMA_UDMA_USR_CMDBUFFULL_MASK) | (((uint32_t)val) << ROTATE_ODMA_ROTATE_ODMA_UDMA_USR_CMDBUFFULL_SHIFT))

#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_USR_CMDBUFEMPTY_MASK 0x10
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_USR_CMDBUFEMPTY_SHIFT 4
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_USR_CMDBUFEMPTY_MASK_SHIFT(reg) (((reg) & ROTATE_ODMA_ROTATE_ODMA_UDMA_USR_CMDBUFEMPTY_MASK) >> ROTATE_ODMA_ROTATE_ODMA_UDMA_USR_CMDBUFEMPTY_SHIFT)
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_USR_CMDBUFEMPTY_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_ODMA_ROTATE_ODMA_UDMA_USR_CMDBUFEMPTY_MASK) | (((uint32_t)val) << ROTATE_ODMA_ROTATE_ODMA_UDMA_USR_CMDBUFEMPTY_SHIFT))

#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_USR_DATABUFFULL_MASK 0x8
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_USR_DATABUFFULL_SHIFT 3
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_USR_DATABUFFULL_MASK_SHIFT(reg) (((reg) & ROTATE_ODMA_ROTATE_ODMA_UDMA_USR_DATABUFFULL_MASK) >> ROTATE_ODMA_ROTATE_ODMA_UDMA_USR_DATABUFFULL_SHIFT)
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_USR_DATABUFFULL_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_ODMA_ROTATE_ODMA_UDMA_USR_DATABUFFULL_MASK) | (((uint32_t)val) << ROTATE_ODMA_ROTATE_ODMA_UDMA_USR_DATABUFFULL_SHIFT))

#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_USR_DATABUFEMPTY_MASK 0x4
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_USR_DATABUFEMPTY_SHIFT 2
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_USR_DATABUFEMPTY_MASK_SHIFT(reg) (((reg) & ROTATE_ODMA_ROTATE_ODMA_UDMA_USR_DATABUFEMPTY_MASK) >> ROTATE_ODMA_ROTATE_ODMA_UDMA_USR_DATABUFEMPTY_SHIFT)
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_USR_DATABUFEMPTY_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_ODMA_ROTATE_ODMA_UDMA_USR_DATABUFEMPTY_MASK) | (((uint32_t)val) << ROTATE_ODMA_ROTATE_ODMA_UDMA_USR_DATABUFEMPTY_SHIFT))

#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_USR_CLEAR_MASK 0x2
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_USR_CLEAR_SHIFT 1
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_USR_CLEAR_MASK_SHIFT(reg) (((reg) & ROTATE_ODMA_ROTATE_ODMA_UDMA_USR_CLEAR_MASK) >> ROTATE_ODMA_ROTATE_ODMA_UDMA_USR_CLEAR_SHIFT)
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_USR_CLEAR_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_ODMA_ROTATE_ODMA_UDMA_USR_CLEAR_MASK) | (((uint32_t)val) << ROTATE_ODMA_ROTATE_ODMA_UDMA_USR_CLEAR_SHIFT))

#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_USR_BUSY_MASK 0x1
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_USR_BUSY_SHIFT 0
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_USR_BUSY_MASK_SHIFT(reg) (((reg) & ROTATE_ODMA_ROTATE_ODMA_UDMA_USR_BUSY_MASK) >> ROTATE_ODMA_ROTATE_ODMA_UDMA_USR_BUSY_SHIFT)
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_USR_BUSY_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_ODMA_ROTATE_ODMA_UDMA_USR_BUSY_MASK) | (((uint32_t)val) << ROTATE_ODMA_ROTATE_ODMA_UDMA_USR_BUSY_SHIFT))

//====================================================================
//Register: UDMA Parameter Register (UPR)
//====================================================================

#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UPR_RESERVED1_MASK 0xff000000
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UPR_RESERVED1_SHIFT 24
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UPR_RESERVED1_MASK_SHIFT(reg) (((reg) & ROTATE_ODMA_ROTATE_ODMA_UDMA_UPR_RESERVED1_MASK) >> ROTATE_ODMA_ROTATE_ODMA_UDMA_UPR_RESERVED1_SHIFT)
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UPR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_ODMA_ROTATE_ODMA_UDMA_UPR_RESERVED1_MASK) | (((uint32_t)val) << ROTATE_ODMA_ROTATE_ODMA_UDMA_UPR_RESERVED1_SHIFT))

#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UPR_FIFODEPTH_MASK 0xffff00
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UPR_FIFODEPTH_SHIFT 8
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UPR_FIFODEPTH_MASK_SHIFT(reg) (((reg) & ROTATE_ODMA_ROTATE_ODMA_UDMA_UPR_FIFODEPTH_MASK) >> ROTATE_ODMA_ROTATE_ODMA_UDMA_UPR_FIFODEPTH_SHIFT)
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UPR_FIFODEPTH_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_ODMA_ROTATE_ODMA_UDMA_UPR_FIFODEPTH_MASK) | (((uint32_t)val) << ROTATE_ODMA_ROTATE_ODMA_UDMA_UPR_FIFODEPTH_SHIFT))

#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UPR_RESERVED2_MASK 0xe0
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UPR_RESERVED2_SHIFT 5
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UPR_RESERVED2_MASK_SHIFT(reg) (((reg) & ROTATE_ODMA_ROTATE_ODMA_UDMA_UPR_RESERVED2_MASK) >> ROTATE_ODMA_ROTATE_ODMA_UDMA_UPR_RESERVED2_SHIFT)
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UPR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_ODMA_ROTATE_ODMA_UDMA_UPR_RESERVED2_MASK) | (((uint32_t)val) << ROTATE_ODMA_ROTATE_ODMA_UDMA_UPR_RESERVED2_SHIFT))

#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UPR_SERPSUPPORT_MASK 0x10
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UPR_SERPSUPPORT_SHIFT 4
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UPR_SERPSUPPORT_MASK_SHIFT(reg) (((reg) & ROTATE_ODMA_ROTATE_ODMA_UDMA_UPR_SERPSUPPORT_MASK) >> ROTATE_ODMA_ROTATE_ODMA_UDMA_UPR_SERPSUPPORT_SHIFT)
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UPR_SERPSUPPORT_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_ODMA_ROTATE_ODMA_UDMA_UPR_SERPSUPPORT_MASK) | (((uint32_t)val) << ROTATE_ODMA_ROTATE_ODMA_UDMA_UPR_SERPSUPPORT_SHIFT))

#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UPR_DESCLENGTH_MASK 0x8
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UPR_DESCLENGTH_SHIFT 3
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UPR_DESCLENGTH_MASK_SHIFT(reg) (((reg) & ROTATE_ODMA_ROTATE_ODMA_UDMA_UPR_DESCLENGTH_MASK) >> ROTATE_ODMA_ROTATE_ODMA_UDMA_UPR_DESCLENGTH_SHIFT)
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UPR_DESCLENGTH_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_ODMA_ROTATE_ODMA_UDMA_UPR_DESCLENGTH_MASK) | (((uint32_t)val) << ROTATE_ODMA_ROTATE_ODMA_UDMA_UPR_DESCLENGTH_SHIFT))

#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UPR_BUSWIDTH_MASK 0x4
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UPR_BUSWIDTH_SHIFT 2
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UPR_BUSWIDTH_MASK_SHIFT(reg) (((reg) & ROTATE_ODMA_ROTATE_ODMA_UDMA_UPR_BUSWIDTH_MASK) >> ROTATE_ODMA_ROTATE_ODMA_UDMA_UPR_BUSWIDTH_SHIFT)
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UPR_BUSWIDTH_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_ODMA_ROTATE_ODMA_UDMA_UPR_BUSWIDTH_MASK) | (((uint32_t)val) << ROTATE_ODMA_ROTATE_ODMA_UDMA_UPR_BUSWIDTH_SHIFT))

#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UPR_MEMALIGN_MASK 0x3
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UPR_MEMALIGN_SHIFT 0
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UPR_MEMALIGN_MASK_SHIFT(reg) (((reg) & ROTATE_ODMA_ROTATE_ODMA_UDMA_UPR_MEMALIGN_MASK) >> ROTATE_ODMA_ROTATE_ODMA_UDMA_UPR_MEMALIGN_SHIFT)
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UPR_MEMALIGN_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_ODMA_ROTATE_ODMA_UDMA_UPR_MEMALIGN_MASK) | (((uint32_t)val) << ROTATE_ODMA_ROTATE_ODMA_UDMA_UPR_MEMALIGN_SHIFT))

//====================================================================
//Register: UDMA Interrupt Enable Register (UIER)
//====================================================================

#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UIER_RESERVED1_MASK 0xffffffc0
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UIER_RESERVED1_SHIFT 6
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UIER_RESERVED1_MASK_SHIFT(reg) (((reg) & ROTATE_ODMA_ROTATE_ODMA_UDMA_UIER_RESERVED1_MASK) >> ROTATE_ODMA_ROTATE_ODMA_UDMA_UIER_RESERVED1_SHIFT)
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UIER_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_ODMA_ROTATE_ODMA_UDMA_UIER_RESERVED1_MASK) | (((uint32_t)val) << ROTATE_ODMA_ROTATE_ODMA_UDMA_UIER_RESERVED1_SHIFT))

#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UIER_OUTOFRANGE_MASK 0x20
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UIER_OUTOFRANGE_SHIFT 5
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UIER_OUTOFRANGE_MASK_SHIFT(reg) (((reg) & ROTATE_ODMA_ROTATE_ODMA_UDMA_UIER_OUTOFRANGE_MASK) >> ROTATE_ODMA_ROTATE_ODMA_UDMA_UIER_OUTOFRANGE_SHIFT)
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UIER_OUTOFRANGE_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_ODMA_ROTATE_ODMA_UDMA_UIER_OUTOFRANGE_MASK) | (((uint32_t)val) << ROTATE_ODMA_ROTATE_ODMA_UDMA_UIER_OUTOFRANGE_SHIFT))

#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UIER_RRESP_MASK 0x10
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UIER_RRESP_SHIFT 4
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UIER_RRESP_MASK_SHIFT(reg) (((reg) & ROTATE_ODMA_ROTATE_ODMA_UDMA_UIER_RRESP_MASK) >> ROTATE_ODMA_ROTATE_ODMA_UDMA_UIER_RRESP_SHIFT)
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UIER_RRESP_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_ODMA_ROTATE_ODMA_UDMA_UIER_RRESP_MASK) | (((uint32_t)val) << ROTATE_ODMA_ROTATE_ODMA_UDMA_UIER_RRESP_SHIFT))

#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UIER_BRESP_MASK 0x8
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UIER_BRESP_SHIFT 3
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UIER_BRESP_MASK_SHIFT(reg) (((reg) & ROTATE_ODMA_ROTATE_ODMA_UDMA_UIER_BRESP_MASK) >> ROTATE_ODMA_ROTATE_ODMA_UDMA_UIER_BRESP_SHIFT)
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UIER_BRESP_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_ODMA_ROTATE_ODMA_UDMA_UIER_BRESP_MASK) | (((uint32_t)val) << ROTATE_ODMA_ROTATE_ODMA_UDMA_UIER_BRESP_SHIFT))

#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UIER_CLEARCOMPLETE_MASK 0x4
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UIER_CLEARCOMPLETE_SHIFT 2
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UIER_CLEARCOMPLETE_MASK_SHIFT(reg) (((reg) & ROTATE_ODMA_ROTATE_ODMA_UDMA_UIER_CLEARCOMPLETE_MASK) >> ROTATE_ODMA_ROTATE_ODMA_UDMA_UIER_CLEARCOMPLETE_SHIFT)
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UIER_CLEARCOMPLETE_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_ODMA_ROTATE_ODMA_UDMA_UIER_CLEARCOMPLETE_MASK) | (((uint32_t)val) << ROTATE_ODMA_ROTATE_ODMA_UDMA_UIER_CLEARCOMPLETE_SHIFT))

#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UIER_DESC_MASK 0x2
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UIER_DESC_SHIFT 1
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UIER_DESC_MASK_SHIFT(reg) (((reg) & ROTATE_ODMA_ROTATE_ODMA_UDMA_UIER_DESC_MASK) >> ROTATE_ODMA_ROTATE_ODMA_UDMA_UIER_DESC_SHIFT)
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UIER_DESC_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_ODMA_ROTATE_ODMA_UDMA_UIER_DESC_MASK) | (((uint32_t)val) << ROTATE_ODMA_ROTATE_ODMA_UDMA_UIER_DESC_SHIFT))

#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UIER_OWN_MASK 0x1
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UIER_OWN_SHIFT 0
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UIER_OWN_MASK_SHIFT(reg) (((reg) & ROTATE_ODMA_ROTATE_ODMA_UDMA_UIER_OWN_MASK) >> ROTATE_ODMA_ROTATE_ODMA_UDMA_UIER_OWN_SHIFT)
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UIER_OWN_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_ODMA_ROTATE_ODMA_UDMA_UIER_OWN_MASK) | (((uint32_t)val) << ROTATE_ODMA_ROTATE_ODMA_UDMA_UIER_OWN_SHIFT))

//====================================================================
//Register: UDMA Interrupt Pending Register (UIPR)
//====================================================================

#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UIPR_RESERVED1_MASK 0xffffffc0
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UIPR_RESERVED1_SHIFT 6
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UIPR_RESERVED1_MASK_SHIFT(reg) (((reg) & ROTATE_ODMA_ROTATE_ODMA_UDMA_UIPR_RESERVED1_MASK) >> ROTATE_ODMA_ROTATE_ODMA_UDMA_UIPR_RESERVED1_SHIFT)
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UIPR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_ODMA_ROTATE_ODMA_UDMA_UIPR_RESERVED1_MASK) | (((uint32_t)val) << ROTATE_ODMA_ROTATE_ODMA_UDMA_UIPR_RESERVED1_SHIFT))

#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UIPR_OUTOFRANGE_MASK 0x20
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UIPR_OUTOFRANGE_SHIFT 5
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UIPR_OUTOFRANGE_MASK_SHIFT(reg) (((reg) & ROTATE_ODMA_ROTATE_ODMA_UDMA_UIPR_OUTOFRANGE_MASK) >> ROTATE_ODMA_ROTATE_ODMA_UDMA_UIPR_OUTOFRANGE_SHIFT)
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UIPR_OUTOFRANGE_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_ODMA_ROTATE_ODMA_UDMA_UIPR_OUTOFRANGE_MASK) | (((uint32_t)val) << ROTATE_ODMA_ROTATE_ODMA_UDMA_UIPR_OUTOFRANGE_SHIFT))

#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UIPR_RRESP_MASK 0x10
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UIPR_RRESP_SHIFT 4
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UIPR_RRESP_MASK_SHIFT(reg) (((reg) & ROTATE_ODMA_ROTATE_ODMA_UDMA_UIPR_RRESP_MASK) >> ROTATE_ODMA_ROTATE_ODMA_UDMA_UIPR_RRESP_SHIFT)
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UIPR_RRESP_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_ODMA_ROTATE_ODMA_UDMA_UIPR_RRESP_MASK) | (((uint32_t)val) << ROTATE_ODMA_ROTATE_ODMA_UDMA_UIPR_RRESP_SHIFT))

#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UIPR_BRESP_MASK 0x8
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UIPR_BRESP_SHIFT 3
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UIPR_BRESP_MASK_SHIFT(reg) (((reg) & ROTATE_ODMA_ROTATE_ODMA_UDMA_UIPR_BRESP_MASK) >> ROTATE_ODMA_ROTATE_ODMA_UDMA_UIPR_BRESP_SHIFT)
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UIPR_BRESP_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_ODMA_ROTATE_ODMA_UDMA_UIPR_BRESP_MASK) | (((uint32_t)val) << ROTATE_ODMA_ROTATE_ODMA_UDMA_UIPR_BRESP_SHIFT))

#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UIPR_CLEARCOMPLETE_MASK 0x4
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UIPR_CLEARCOMPLETE_SHIFT 2
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UIPR_CLEARCOMPLETE_MASK_SHIFT(reg) (((reg) & ROTATE_ODMA_ROTATE_ODMA_UDMA_UIPR_CLEARCOMPLETE_MASK) >> ROTATE_ODMA_ROTATE_ODMA_UDMA_UIPR_CLEARCOMPLETE_SHIFT)
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UIPR_CLEARCOMPLETE_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_ODMA_ROTATE_ODMA_UDMA_UIPR_CLEARCOMPLETE_MASK) | (((uint32_t)val) << ROTATE_ODMA_ROTATE_ODMA_UDMA_UIPR_CLEARCOMPLETE_SHIFT))

#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UIPR_DESC_MASK 0x2
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UIPR_DESC_SHIFT 1
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UIPR_DESC_MASK_SHIFT(reg) (((reg) & ROTATE_ODMA_ROTATE_ODMA_UDMA_UIPR_DESC_MASK) >> ROTATE_ODMA_ROTATE_ODMA_UDMA_UIPR_DESC_SHIFT)
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UIPR_DESC_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_ODMA_ROTATE_ODMA_UDMA_UIPR_DESC_MASK) | (((uint32_t)val) << ROTATE_ODMA_ROTATE_ODMA_UDMA_UIPR_DESC_SHIFT))

#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UIPR_OWN_MASK 0x1
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UIPR_OWN_SHIFT 0
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UIPR_OWN_MASK_SHIFT(reg) (((reg) & ROTATE_ODMA_ROTATE_ODMA_UDMA_UIPR_OWN_MASK) >> ROTATE_ODMA_ROTATE_ODMA_UDMA_UIPR_OWN_SHIFT)
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UIPR_OWN_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_ODMA_ROTATE_ODMA_UDMA_UIPR_OWN_MASK) | (((uint32_t)val) << ROTATE_ODMA_ROTATE_ODMA_UDMA_UIPR_OWN_SHIFT))

//====================================================================
//Register: UDMA Interrupt Clear Register (UICR)
//====================================================================

#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UICR_RESERVED1_MASK 0xffffffc0
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UICR_RESERVED1_SHIFT 6
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UICR_RESERVED1_MASK_SHIFT(reg) (((reg) & ROTATE_ODMA_ROTATE_ODMA_UDMA_UICR_RESERVED1_MASK) >> ROTATE_ODMA_ROTATE_ODMA_UDMA_UICR_RESERVED1_SHIFT)
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UICR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_ODMA_ROTATE_ODMA_UDMA_UICR_RESERVED1_MASK) | (((uint32_t)val) << ROTATE_ODMA_ROTATE_ODMA_UDMA_UICR_RESERVED1_SHIFT))

#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UICR_OUTOFRANGE_MASK 0x20
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UICR_OUTOFRANGE_SHIFT 5
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UICR_OUTOFRANGE_MASK_SHIFT(reg) (((reg) & ROTATE_ODMA_ROTATE_ODMA_UDMA_UICR_OUTOFRANGE_MASK) >> ROTATE_ODMA_ROTATE_ODMA_UDMA_UICR_OUTOFRANGE_SHIFT)
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UICR_OUTOFRANGE_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_ODMA_ROTATE_ODMA_UDMA_UICR_OUTOFRANGE_MASK) | (((uint32_t)val) << ROTATE_ODMA_ROTATE_ODMA_UDMA_UICR_OUTOFRANGE_SHIFT))

#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UICR_RRESP_MASK 0x10
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UICR_RRESP_SHIFT 4
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UICR_RRESP_MASK_SHIFT(reg) (((reg) & ROTATE_ODMA_ROTATE_ODMA_UDMA_UICR_RRESP_MASK) >> ROTATE_ODMA_ROTATE_ODMA_UDMA_UICR_RRESP_SHIFT)
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UICR_RRESP_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_ODMA_ROTATE_ODMA_UDMA_UICR_RRESP_MASK) | (((uint32_t)val) << ROTATE_ODMA_ROTATE_ODMA_UDMA_UICR_RRESP_SHIFT))

#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UICR_BRESP_MASK 0x8
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UICR_BRESP_SHIFT 3
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UICR_BRESP_MASK_SHIFT(reg) (((reg) & ROTATE_ODMA_ROTATE_ODMA_UDMA_UICR_BRESP_MASK) >> ROTATE_ODMA_ROTATE_ODMA_UDMA_UICR_BRESP_SHIFT)
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UICR_BRESP_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_ODMA_ROTATE_ODMA_UDMA_UICR_BRESP_MASK) | (((uint32_t)val) << ROTATE_ODMA_ROTATE_ODMA_UDMA_UICR_BRESP_SHIFT))

#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UICR_CLEARCOMPLETE_MASK 0x4
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UICR_CLEARCOMPLETE_SHIFT 2
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UICR_CLEARCOMPLETE_MASK_SHIFT(reg) (((reg) & ROTATE_ODMA_ROTATE_ODMA_UDMA_UICR_CLEARCOMPLETE_MASK) >> ROTATE_ODMA_ROTATE_ODMA_UDMA_UICR_CLEARCOMPLETE_SHIFT)
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UICR_CLEARCOMPLETE_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_ODMA_ROTATE_ODMA_UDMA_UICR_CLEARCOMPLETE_MASK) | (((uint32_t)val) << ROTATE_ODMA_ROTATE_ODMA_UDMA_UICR_CLEARCOMPLETE_SHIFT))

#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UICR_DESC_MASK 0x2
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UICR_DESC_SHIFT 1
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UICR_DESC_MASK_SHIFT(reg) (((reg) & ROTATE_ODMA_ROTATE_ODMA_UDMA_UICR_DESC_MASK) >> ROTATE_ODMA_ROTATE_ODMA_UDMA_UICR_DESC_SHIFT)
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UICR_DESC_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_ODMA_ROTATE_ODMA_UDMA_UICR_DESC_MASK) | (((uint32_t)val) << ROTATE_ODMA_ROTATE_ODMA_UDMA_UICR_DESC_SHIFT))

#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UICR_OWN_MASK 0x1
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UICR_OWN_SHIFT 0
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UICR_OWN_MASK_SHIFT(reg) (((reg) & ROTATE_ODMA_ROTATE_ODMA_UDMA_UICR_OWN_MASK) >> ROTATE_ODMA_ROTATE_ODMA_UDMA_UICR_OWN_SHIFT)
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UICR_OWN_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_ODMA_ROTATE_ODMA_UDMA_UICR_OWN_MASK) | (((uint32_t)val) << ROTATE_ODMA_ROTATE_ODMA_UDMA_UICR_OWN_SHIFT))

//====================================================================
//Register: UDMA Interrupt Force Register (UIFR)
//====================================================================

#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UIFR_RESERVED1_MASK 0xffffffc0
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UIFR_RESERVED1_SHIFT 6
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UIFR_RESERVED1_MASK_SHIFT(reg) (((reg) & ROTATE_ODMA_ROTATE_ODMA_UDMA_UIFR_RESERVED1_MASK) >> ROTATE_ODMA_ROTATE_ODMA_UDMA_UIFR_RESERVED1_SHIFT)
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UIFR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_ODMA_ROTATE_ODMA_UDMA_UIFR_RESERVED1_MASK) | (((uint32_t)val) << ROTATE_ODMA_ROTATE_ODMA_UDMA_UIFR_RESERVED1_SHIFT))

#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UIFR_OUTOFRANGE_MASK 0x20
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UIFR_OUTOFRANGE_SHIFT 5
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UIFR_OUTOFRANGE_MASK_SHIFT(reg) (((reg) & ROTATE_ODMA_ROTATE_ODMA_UDMA_UIFR_OUTOFRANGE_MASK) >> ROTATE_ODMA_ROTATE_ODMA_UDMA_UIFR_OUTOFRANGE_SHIFT)
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UIFR_OUTOFRANGE_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_ODMA_ROTATE_ODMA_UDMA_UIFR_OUTOFRANGE_MASK) | (((uint32_t)val) << ROTATE_ODMA_ROTATE_ODMA_UDMA_UIFR_OUTOFRANGE_SHIFT))

#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UIFR_RRESP_MASK 0x10
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UIFR_RRESP_SHIFT 4
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UIFR_RRESP_MASK_SHIFT(reg) (((reg) & ROTATE_ODMA_ROTATE_ODMA_UDMA_UIFR_RRESP_MASK) >> ROTATE_ODMA_ROTATE_ODMA_UDMA_UIFR_RRESP_SHIFT)
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UIFR_RRESP_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_ODMA_ROTATE_ODMA_UDMA_UIFR_RRESP_MASK) | (((uint32_t)val) << ROTATE_ODMA_ROTATE_ODMA_UDMA_UIFR_RRESP_SHIFT))

#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UIFR_BRESP_MASK 0x8
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UIFR_BRESP_SHIFT 3
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UIFR_BRESP_MASK_SHIFT(reg) (((reg) & ROTATE_ODMA_ROTATE_ODMA_UDMA_UIFR_BRESP_MASK) >> ROTATE_ODMA_ROTATE_ODMA_UDMA_UIFR_BRESP_SHIFT)
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UIFR_BRESP_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_ODMA_ROTATE_ODMA_UDMA_UIFR_BRESP_MASK) | (((uint32_t)val) << ROTATE_ODMA_ROTATE_ODMA_UDMA_UIFR_BRESP_SHIFT))

#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UIFR_CLEARCOMPLETE_MASK 0x4
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UIFR_CLEARCOMPLETE_SHIFT 2
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UIFR_CLEARCOMPLETE_MASK_SHIFT(reg) (((reg) & ROTATE_ODMA_ROTATE_ODMA_UDMA_UIFR_CLEARCOMPLETE_MASK) >> ROTATE_ODMA_ROTATE_ODMA_UDMA_UIFR_CLEARCOMPLETE_SHIFT)
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UIFR_CLEARCOMPLETE_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_ODMA_ROTATE_ODMA_UDMA_UIFR_CLEARCOMPLETE_MASK) | (((uint32_t)val) << ROTATE_ODMA_ROTATE_ODMA_UDMA_UIFR_CLEARCOMPLETE_SHIFT))

#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UIFR_DESC_MASK 0x2
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UIFR_DESC_SHIFT 1
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UIFR_DESC_MASK_SHIFT(reg) (((reg) & ROTATE_ODMA_ROTATE_ODMA_UDMA_UIFR_DESC_MASK) >> ROTATE_ODMA_ROTATE_ODMA_UDMA_UIFR_DESC_SHIFT)
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UIFR_DESC_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_ODMA_ROTATE_ODMA_UDMA_UIFR_DESC_MASK) | (((uint32_t)val) << ROTATE_ODMA_ROTATE_ODMA_UDMA_UIFR_DESC_SHIFT))

#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UIFR_OWN_MASK 0x1
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UIFR_OWN_SHIFT 0
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UIFR_OWN_MASK_SHIFT(reg) (((reg) & ROTATE_ODMA_ROTATE_ODMA_UDMA_UIFR_OWN_MASK) >> ROTATE_ODMA_ROTATE_ODMA_UDMA_UIFR_OWN_SHIFT)
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UIFR_OWN_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_ODMA_ROTATE_ODMA_UDMA_UIFR_OWN_MASK) | (((uint32_t)val) << ROTATE_ODMA_ROTATE_ODMA_UDMA_UIFR_OWN_SHIFT))

//====================================================================
//Register: UDMA Descriptor Register (UDR)
//====================================================================

#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UDR_DESC_MASK 0xffffffff
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UDR_DESC_SHIFT 0
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UDR_DESC_MASK_SHIFT(reg) (((reg) & ROTATE_ODMA_ROTATE_ODMA_UDMA_UDR_DESC_MASK) >> ROTATE_ODMA_ROTATE_ODMA_UDMA_UDR_DESC_SHIFT)
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UDR_DESC_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_ODMA_ROTATE_ODMA_UDMA_UDR_DESC_MASK) | (((uint32_t)val) << ROTATE_ODMA_ROTATE_ODMA_UDMA_UDR_DESC_SHIFT))

//====================================================================
//Register: UDMA Burst Address Register (UBAR)
//====================================================================

#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UBAR_BURSTADDR_MASK 0xffffffff
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UBAR_BURSTADDR_SHIFT 0
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UBAR_BURSTADDR_MASK_SHIFT(reg) (((reg) & ROTATE_ODMA_ROTATE_ODMA_UDMA_UBAR_BURSTADDR_MASK) >> ROTATE_ODMA_ROTATE_ODMA_UDMA_UBAR_BURSTADDR_SHIFT)
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UBAR_BURSTADDR_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_ODMA_ROTATE_ODMA_UDMA_UBAR_BURSTADDR_MASK) | (((uint32_t)val) << ROTATE_ODMA_ROTATE_ODMA_UDMA_UBAR_BURSTADDR_SHIFT))

//====================================================================
//Register: UDMA Burst Length Register (UBLR)
//====================================================================

#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UBLR_RESERVED1_MASK 0xfffffc00
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UBLR_RESERVED1_SHIFT 10
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UBLR_RESERVED1_MASK_SHIFT(reg) (((reg) & ROTATE_ODMA_ROTATE_ODMA_UDMA_UBLR_RESERVED1_MASK) >> ROTATE_ODMA_ROTATE_ODMA_UDMA_UBLR_RESERVED1_SHIFT)
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UBLR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_ODMA_ROTATE_ODMA_UDMA_UBLR_RESERVED1_MASK) | (((uint32_t)val) << ROTATE_ODMA_ROTATE_ODMA_UDMA_UBLR_RESERVED1_SHIFT))

#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UBLR_BURSTDIR_MASK 0x200
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UBLR_BURSTDIR_SHIFT 9
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UBLR_BURSTDIR_MASK_SHIFT(reg) (((reg) & ROTATE_ODMA_ROTATE_ODMA_UDMA_UBLR_BURSTDIR_MASK) >> ROTATE_ODMA_ROTATE_ODMA_UDMA_UBLR_BURSTDIR_SHIFT)
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UBLR_BURSTDIR_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_ODMA_ROTATE_ODMA_UDMA_UBLR_BURSTDIR_MASK) | (((uint32_t)val) << ROTATE_ODMA_ROTATE_ODMA_UDMA_UBLR_BURSTDIR_SHIFT))

#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UBLR_BURSTLAST_MASK 0x100
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UBLR_BURSTLAST_SHIFT 8
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UBLR_BURSTLAST_MASK_SHIFT(reg) (((reg) & ROTATE_ODMA_ROTATE_ODMA_UDMA_UBLR_BURSTLAST_MASK) >> ROTATE_ODMA_ROTATE_ODMA_UDMA_UBLR_BURSTLAST_SHIFT)
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UBLR_BURSTLAST_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_ODMA_ROTATE_ODMA_UDMA_UBLR_BURSTLAST_MASK) | (((uint32_t)val) << ROTATE_ODMA_ROTATE_ODMA_UDMA_UBLR_BURSTLAST_SHIFT))

#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UBLR_BURSTLENGTH_MASK 0xff
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UBLR_BURSTLENGTH_SHIFT 0
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UBLR_BURSTLENGTH_MASK_SHIFT(reg) (((reg) & ROTATE_ODMA_ROTATE_ODMA_UDMA_UBLR_BURSTLENGTH_MASK) >> ROTATE_ODMA_ROTATE_ODMA_UDMA_UBLR_BURSTLENGTH_SHIFT)
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UBLR_BURSTLENGTH_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_ODMA_ROTATE_ODMA_UDMA_UBLR_BURSTLENGTH_MASK) | (((uint32_t)val) << ROTATE_ODMA_ROTATE_ODMA_UDMA_UBLR_BURSTLENGTH_SHIFT))

//====================================================================
//Register: UDMA Transfer Bytes Remaining Register (UBRR)
//====================================================================

#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UBRR_BYTESREMAIN_MASK 0xffffffff
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UBRR_BYTESREMAIN_SHIFT 0
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UBRR_BYTESREMAIN_MASK_SHIFT(reg) (((reg) & ROTATE_ODMA_ROTATE_ODMA_UDMA_UBRR_BYTESREMAIN_MASK) >> ROTATE_ODMA_ROTATE_ODMA_UDMA_UBRR_BYTESREMAIN_SHIFT)
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UBRR_BYTESREMAIN_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_ODMA_ROTATE_ODMA_UDMA_UBRR_BYTESREMAIN_MASK) | (((uint32_t)val) << ROTATE_ODMA_ROTATE_ODMA_UDMA_UBRR_BYTESREMAIN_SHIFT))

//====================================================================
//Register: UDMA Tag Register 0 (UTR0)
//====================================================================

#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UTR0_TAGMAJ_MASK 0xffff0000
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UTR0_TAGMAJ_SHIFT 16
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UTR0_TAGMAJ_MASK_SHIFT(reg) (((reg) & ROTATE_ODMA_ROTATE_ODMA_UDMA_UTR0_TAGMAJ_MASK) >> ROTATE_ODMA_ROTATE_ODMA_UDMA_UTR0_TAGMAJ_SHIFT)
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UTR0_TAGMAJ_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_ODMA_ROTATE_ODMA_UDMA_UTR0_TAGMAJ_MASK) | (((uint32_t)val) << ROTATE_ODMA_ROTATE_ODMA_UDMA_UTR0_TAGMAJ_SHIFT))

#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UTR0_TAGMID_MASK 0xffff
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UTR0_TAGMID_SHIFT 0
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UTR0_TAGMID_MASK_SHIFT(reg) (((reg) & ROTATE_ODMA_ROTATE_ODMA_UDMA_UTR0_TAGMID_MASK) >> ROTATE_ODMA_ROTATE_ODMA_UDMA_UTR0_TAGMID_SHIFT)
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UTR0_TAGMID_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_ODMA_ROTATE_ODMA_UDMA_UTR0_TAGMID_MASK) | (((uint32_t)val) << ROTATE_ODMA_ROTATE_ODMA_UDMA_UTR0_TAGMID_SHIFT))

//====================================================================
//Register: UDMA Tag Register 1 (UTR1)
//====================================================================

#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UTR1_RESERVED1_MASK 0xffff0000
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UTR1_RESERVED1_SHIFT 16
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UTR1_RESERVED1_MASK_SHIFT(reg) (((reg) & ROTATE_ODMA_ROTATE_ODMA_UDMA_UTR1_RESERVED1_MASK) >> ROTATE_ODMA_ROTATE_ODMA_UDMA_UTR1_RESERVED1_SHIFT)
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UTR1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_ODMA_ROTATE_ODMA_UDMA_UTR1_RESERVED1_MASK) | (((uint32_t)val) << ROTATE_ODMA_ROTATE_ODMA_UDMA_UTR1_RESERVED1_SHIFT))

#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UTR1_TAGCFG_MASK 0xffff
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UTR1_TAGCFG_SHIFT 0
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UTR1_TAGCFG_MASK_SHIFT(reg) (((reg) & ROTATE_ODMA_ROTATE_ODMA_UDMA_UTR1_TAGCFG_MASK) >> ROTATE_ODMA_ROTATE_ODMA_UDMA_UTR1_TAGCFG_SHIFT)
#define  ROTATE_ODMA_ROTATE_ODMA_UDMA_UTR1_TAGCFG_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_ODMA_ROTATE_ODMA_UDMA_UTR1_TAGCFG_MASK) | (((uint32_t)val) << ROTATE_ODMA_ROTATE_ODMA_UDMA_UTR1_TAGCFG_SHIFT))

//====================================================================
//
//Register File: ROTATE_ODMA_CORE (ROTATE_ODMA_ROTATE_ODMA_CORE)
//
//====================================================================

//====================================================================
//Register: ODMA Configuration Register (ICFG)
//====================================================================

#define  ROTATE_ODMA_ROTATE_ODMA_CORE_ICFG_RESERVED1_MASK 0xfffffff8
#define  ROTATE_ODMA_ROTATE_ODMA_CORE_ICFG_RESERVED1_SHIFT 3
#define  ROTATE_ODMA_ROTATE_ODMA_CORE_ICFG_RESERVED1_MASK_SHIFT(reg) (((reg) & ROTATE_ODMA_ROTATE_ODMA_CORE_ICFG_RESERVED1_MASK) >> ROTATE_ODMA_ROTATE_ODMA_CORE_ICFG_RESERVED1_SHIFT)
#define  ROTATE_ODMA_ROTATE_ODMA_CORE_ICFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_ODMA_ROTATE_ODMA_CORE_ICFG_RESERVED1_MASK) | (((uint32_t)val) << ROTATE_ODMA_ROTATE_ODMA_CORE_ICFG_RESERVED1_SHIFT))

#define  ROTATE_ODMA_ROTATE_ODMA_CORE_ICFG_INWIDTH_MASK 0x4
#define  ROTATE_ODMA_ROTATE_ODMA_CORE_ICFG_INWIDTH_SHIFT 2
#define  ROTATE_ODMA_ROTATE_ODMA_CORE_ICFG_INWIDTH_MASK_SHIFT(reg) (((reg) & ROTATE_ODMA_ROTATE_ODMA_CORE_ICFG_INWIDTH_MASK) >> ROTATE_ODMA_ROTATE_ODMA_CORE_ICFG_INWIDTH_SHIFT)
#define  ROTATE_ODMA_ROTATE_ODMA_CORE_ICFG_INWIDTH_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_ODMA_ROTATE_ODMA_CORE_ICFG_INWIDTH_MASK) | (((uint32_t)val) << ROTATE_ODMA_ROTATE_ODMA_CORE_ICFG_INWIDTH_SHIFT))

#define  ROTATE_ODMA_ROTATE_ODMA_CORE_ICFG_BOTTOMTOTOP_MASK 0x2
#define  ROTATE_ODMA_ROTATE_ODMA_CORE_ICFG_BOTTOMTOTOP_SHIFT 1
#define  ROTATE_ODMA_ROTATE_ODMA_CORE_ICFG_BOTTOMTOTOP_MASK_SHIFT(reg) (((reg) & ROTATE_ODMA_ROTATE_ODMA_CORE_ICFG_BOTTOMTOTOP_MASK) >> ROTATE_ODMA_ROTATE_ODMA_CORE_ICFG_BOTTOMTOTOP_SHIFT)
#define  ROTATE_ODMA_ROTATE_ODMA_CORE_ICFG_BOTTOMTOTOP_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_ODMA_ROTATE_ODMA_CORE_ICFG_BOTTOMTOTOP_MASK) | (((uint32_t)val) << ROTATE_ODMA_ROTATE_ODMA_CORE_ICFG_BOTTOMTOTOP_SHIFT))

#define  ROTATE_ODMA_ROTATE_ODMA_CORE_ICFG_MODE_MASK 0x1
#define  ROTATE_ODMA_ROTATE_ODMA_CORE_ICFG_MODE_SHIFT 0
#define  ROTATE_ODMA_ROTATE_ODMA_CORE_ICFG_MODE_MASK_SHIFT(reg) (((reg) & ROTATE_ODMA_ROTATE_ODMA_CORE_ICFG_MODE_MASK) >> ROTATE_ODMA_ROTATE_ODMA_CORE_ICFG_MODE_SHIFT)
#define  ROTATE_ODMA_ROTATE_ODMA_CORE_ICFG_MODE_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_ODMA_ROTATE_ODMA_CORE_ICFG_MODE_MASK) | (((uint32_t)val) << ROTATE_ODMA_ROTATE_ODMA_CORE_ICFG_MODE_SHIFT))

//====================================================================
//Register: ODMA Image Line Width Register (ILW)
//====================================================================

#define  ROTATE_ODMA_ROTATE_ODMA_CORE_ILW_LINESTRIDE_MASK 0xffff0000
#define  ROTATE_ODMA_ROTATE_ODMA_CORE_ILW_LINESTRIDE_SHIFT 16
#define  ROTATE_ODMA_ROTATE_ODMA_CORE_ILW_LINESTRIDE_MASK_SHIFT(reg) (((reg) & ROTATE_ODMA_ROTATE_ODMA_CORE_ILW_LINESTRIDE_MASK) >> ROTATE_ODMA_ROTATE_ODMA_CORE_ILW_LINESTRIDE_SHIFT)
#define  ROTATE_ODMA_ROTATE_ODMA_CORE_ILW_LINESTRIDE_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_ODMA_ROTATE_ODMA_CORE_ILW_LINESTRIDE_MASK) | (((uint32_t)val) << ROTATE_ODMA_ROTATE_ODMA_CORE_ILW_LINESTRIDE_SHIFT))

#define  ROTATE_ODMA_ROTATE_ODMA_CORE_ILW_LINEWIDTH_MASK 0xffff
#define  ROTATE_ODMA_ROTATE_ODMA_CORE_ILW_LINEWIDTH_SHIFT 0
#define  ROTATE_ODMA_ROTATE_ODMA_CORE_ILW_LINEWIDTH_MASK_SHIFT(reg) (((reg) & ROTATE_ODMA_ROTATE_ODMA_CORE_ILW_LINEWIDTH_MASK) >> ROTATE_ODMA_ROTATE_ODMA_CORE_ILW_LINEWIDTH_SHIFT)
#define  ROTATE_ODMA_ROTATE_ODMA_CORE_ILW_LINEWIDTH_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_ODMA_ROTATE_ODMA_CORE_ILW_LINEWIDTH_MASK) | (((uint32_t)val) << ROTATE_ODMA_ROTATE_ODMA_CORE_ILW_LINEWIDTH_SHIFT))

//====================================================================
//Register: ODMA Image Height Register (IIH)
//====================================================================

#define  ROTATE_ODMA_ROTATE_ODMA_CORE_IIH_RESERVED1_MASK 0xffff0000
#define  ROTATE_ODMA_ROTATE_ODMA_CORE_IIH_RESERVED1_SHIFT 16
#define  ROTATE_ODMA_ROTATE_ODMA_CORE_IIH_RESERVED1_MASK_SHIFT(reg) (((reg) & ROTATE_ODMA_ROTATE_ODMA_CORE_IIH_RESERVED1_MASK) >> ROTATE_ODMA_ROTATE_ODMA_CORE_IIH_RESERVED1_SHIFT)
#define  ROTATE_ODMA_ROTATE_ODMA_CORE_IIH_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_ODMA_ROTATE_ODMA_CORE_IIH_RESERVED1_MASK) | (((uint32_t)val) << ROTATE_ODMA_ROTATE_ODMA_CORE_IIH_RESERVED1_SHIFT))

#define  ROTATE_ODMA_ROTATE_ODMA_CORE_IIH_IMAGEHEIGHT_MASK 0xffff
#define  ROTATE_ODMA_ROTATE_ODMA_CORE_IIH_IMAGEHEIGHT_SHIFT 0
#define  ROTATE_ODMA_ROTATE_ODMA_CORE_IIH_IMAGEHEIGHT_MASK_SHIFT(reg) (((reg) & ROTATE_ODMA_ROTATE_ODMA_CORE_IIH_IMAGEHEIGHT_MASK) >> ROTATE_ODMA_ROTATE_ODMA_CORE_IIH_IMAGEHEIGHT_SHIFT)
#define  ROTATE_ODMA_ROTATE_ODMA_CORE_IIH_IMAGEHEIGHT_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_ODMA_ROTATE_ODMA_CORE_IIH_IMAGEHEIGHT_MASK) | (((uint32_t)val) << ROTATE_ODMA_ROTATE_ODMA_CORE_IIH_IMAGEHEIGHT_SHIFT))

//====================================================================
//Register: ODMA Tile Size Register (ITS)
//====================================================================

#define  ROTATE_ODMA_ROTATE_ODMA_CORE_ITS_TILEHEIGHT_MASK 0xffff0000
#define  ROTATE_ODMA_ROTATE_ODMA_CORE_ITS_TILEHEIGHT_SHIFT 16
#define  ROTATE_ODMA_ROTATE_ODMA_CORE_ITS_TILEHEIGHT_MASK_SHIFT(reg) (((reg) & ROTATE_ODMA_ROTATE_ODMA_CORE_ITS_TILEHEIGHT_MASK) >> ROTATE_ODMA_ROTATE_ODMA_CORE_ITS_TILEHEIGHT_SHIFT)
#define  ROTATE_ODMA_ROTATE_ODMA_CORE_ITS_TILEHEIGHT_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_ODMA_ROTATE_ODMA_CORE_ITS_TILEHEIGHT_MASK) | (((uint32_t)val) << ROTATE_ODMA_ROTATE_ODMA_CORE_ITS_TILEHEIGHT_SHIFT))

#define  ROTATE_ODMA_ROTATE_ODMA_CORE_ITS_TILEWIDTH_MASK 0xffff
#define  ROTATE_ODMA_ROTATE_ODMA_CORE_ITS_TILEWIDTH_SHIFT 0
#define  ROTATE_ODMA_ROTATE_ODMA_CORE_ITS_TILEWIDTH_MASK_SHIFT(reg) (((reg) & ROTATE_ODMA_ROTATE_ODMA_CORE_ITS_TILEWIDTH_MASK) >> ROTATE_ODMA_ROTATE_ODMA_CORE_ITS_TILEWIDTH_SHIFT)
#define  ROTATE_ODMA_ROTATE_ODMA_CORE_ITS_TILEWIDTH_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_ODMA_ROTATE_ODMA_CORE_ITS_TILEWIDTH_MASK) | (((uint32_t)val) << ROTATE_ODMA_ROTATE_ODMA_CORE_ITS_TILEWIDTH_SHIFT))

//====================================================================
//Register: ODMA Swath Offset Register (ISOFFST)
//====================================================================

#define  ROTATE_ODMA_ROTATE_ODMA_CORE_ISOFFST_SWATHOFFSET_MASK 0xffffffff
#define  ROTATE_ODMA_ROTATE_ODMA_CORE_ISOFFST_SWATHOFFSET_SHIFT 0
#define  ROTATE_ODMA_ROTATE_ODMA_CORE_ISOFFST_SWATHOFFSET_MASK_SHIFT(reg) (((reg) & ROTATE_ODMA_ROTATE_ODMA_CORE_ISOFFST_SWATHOFFSET_MASK) >> ROTATE_ODMA_ROTATE_ODMA_CORE_ISOFFST_SWATHOFFSET_SHIFT)
#define  ROTATE_ODMA_ROTATE_ODMA_CORE_ISOFFST_SWATHOFFSET_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_ODMA_ROTATE_ODMA_CORE_ISOFFST_SWATHOFFSET_MASK) | (((uint32_t)val) << ROTATE_ODMA_ROTATE_ODMA_CORE_ISOFFST_SWATHOFFSET_SHIFT))

//====================================================================
//Register: ODMA Tile Offset Register (ITOFFST)
//====================================================================

#define  ROTATE_ODMA_ROTATE_ODMA_CORE_ITOFFST_TILEOFFSET_MASK 0xffffffff
#define  ROTATE_ODMA_ROTATE_ODMA_CORE_ITOFFST_TILEOFFSET_SHIFT 0
#define  ROTATE_ODMA_ROTATE_ODMA_CORE_ITOFFST_TILEOFFSET_MASK_SHIFT(reg) (((reg) & ROTATE_ODMA_ROTATE_ODMA_CORE_ITOFFST_TILEOFFSET_MASK) >> ROTATE_ODMA_ROTATE_ODMA_CORE_ITOFFST_TILEOFFSET_SHIFT)
#define  ROTATE_ODMA_ROTATE_ODMA_CORE_ITOFFST_TILEOFFSET_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_ODMA_ROTATE_ODMA_CORE_ITOFFST_TILEOFFSET_MASK) | (((uint32_t)val) << ROTATE_ODMA_ROTATE_ODMA_CORE_ITOFFST_TILEOFFSET_SHIFT))

//====================================================================
//Register: ODMA Interrupt Enable Register (IIER)
//====================================================================

#define  ROTATE_ODMA_ROTATE_ODMA_CORE_IIER_RESERVED1_MASK 0xfffffffe
#define  ROTATE_ODMA_ROTATE_ODMA_CORE_IIER_RESERVED1_SHIFT 1
#define  ROTATE_ODMA_ROTATE_ODMA_CORE_IIER_RESERVED1_MASK_SHIFT(reg) (((reg) & ROTATE_ODMA_ROTATE_ODMA_CORE_IIER_RESERVED1_MASK) >> ROTATE_ODMA_ROTATE_ODMA_CORE_IIER_RESERVED1_SHIFT)
#define  ROTATE_ODMA_ROTATE_ODMA_CORE_IIER_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_ODMA_ROTATE_ODMA_CORE_IIER_RESERVED1_MASK) | (((uint32_t)val) << ROTATE_ODMA_ROTATE_ODMA_CORE_IIER_RESERVED1_SHIFT))

#define  ROTATE_ODMA_ROTATE_ODMA_CORE_IIER_LENGTHERR_MASK 0x1
#define  ROTATE_ODMA_ROTATE_ODMA_CORE_IIER_LENGTHERR_SHIFT 0
#define  ROTATE_ODMA_ROTATE_ODMA_CORE_IIER_LENGTHERR_MASK_SHIFT(reg) (((reg) & ROTATE_ODMA_ROTATE_ODMA_CORE_IIER_LENGTHERR_MASK) >> ROTATE_ODMA_ROTATE_ODMA_CORE_IIER_LENGTHERR_SHIFT)
#define  ROTATE_ODMA_ROTATE_ODMA_CORE_IIER_LENGTHERR_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_ODMA_ROTATE_ODMA_CORE_IIER_LENGTHERR_MASK) | (((uint32_t)val) << ROTATE_ODMA_ROTATE_ODMA_CORE_IIER_LENGTHERR_SHIFT))

//====================================================================
//Register: ODMA Interrupt Pending Register (IIPR)
//====================================================================

#define  ROTATE_ODMA_ROTATE_ODMA_CORE_IIPR_RESERVED1_MASK 0xfffffffe
#define  ROTATE_ODMA_ROTATE_ODMA_CORE_IIPR_RESERVED1_SHIFT 1
#define  ROTATE_ODMA_ROTATE_ODMA_CORE_IIPR_RESERVED1_MASK_SHIFT(reg) (((reg) & ROTATE_ODMA_ROTATE_ODMA_CORE_IIPR_RESERVED1_MASK) >> ROTATE_ODMA_ROTATE_ODMA_CORE_IIPR_RESERVED1_SHIFT)
#define  ROTATE_ODMA_ROTATE_ODMA_CORE_IIPR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_ODMA_ROTATE_ODMA_CORE_IIPR_RESERVED1_MASK) | (((uint32_t)val) << ROTATE_ODMA_ROTATE_ODMA_CORE_IIPR_RESERVED1_SHIFT))

#define  ROTATE_ODMA_ROTATE_ODMA_CORE_IIPR_LENGTHERR_MASK 0x1
#define  ROTATE_ODMA_ROTATE_ODMA_CORE_IIPR_LENGTHERR_SHIFT 0
#define  ROTATE_ODMA_ROTATE_ODMA_CORE_IIPR_LENGTHERR_MASK_SHIFT(reg) (((reg) & ROTATE_ODMA_ROTATE_ODMA_CORE_IIPR_LENGTHERR_MASK) >> ROTATE_ODMA_ROTATE_ODMA_CORE_IIPR_LENGTHERR_SHIFT)
#define  ROTATE_ODMA_ROTATE_ODMA_CORE_IIPR_LENGTHERR_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_ODMA_ROTATE_ODMA_CORE_IIPR_LENGTHERR_MASK) | (((uint32_t)val) << ROTATE_ODMA_ROTATE_ODMA_CORE_IIPR_LENGTHERR_SHIFT))

//====================================================================
//Register: ODMA Interrupt Clear Register (IICR)
//====================================================================

#define  ROTATE_ODMA_ROTATE_ODMA_CORE_IICR_RESERVED1_MASK 0xfffffffe
#define  ROTATE_ODMA_ROTATE_ODMA_CORE_IICR_RESERVED1_SHIFT 1
#define  ROTATE_ODMA_ROTATE_ODMA_CORE_IICR_RESERVED1_MASK_SHIFT(reg) (((reg) & ROTATE_ODMA_ROTATE_ODMA_CORE_IICR_RESERVED1_MASK) >> ROTATE_ODMA_ROTATE_ODMA_CORE_IICR_RESERVED1_SHIFT)
#define  ROTATE_ODMA_ROTATE_ODMA_CORE_IICR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_ODMA_ROTATE_ODMA_CORE_IICR_RESERVED1_MASK) | (((uint32_t)val) << ROTATE_ODMA_ROTATE_ODMA_CORE_IICR_RESERVED1_SHIFT))

#define  ROTATE_ODMA_ROTATE_ODMA_CORE_IICR_LENGTHERR_MASK 0x1
#define  ROTATE_ODMA_ROTATE_ODMA_CORE_IICR_LENGTHERR_SHIFT 0
#define  ROTATE_ODMA_ROTATE_ODMA_CORE_IICR_LENGTHERR_MASK_SHIFT(reg) (((reg) & ROTATE_ODMA_ROTATE_ODMA_CORE_IICR_LENGTHERR_MASK) >> ROTATE_ODMA_ROTATE_ODMA_CORE_IICR_LENGTHERR_SHIFT)
#define  ROTATE_ODMA_ROTATE_ODMA_CORE_IICR_LENGTHERR_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_ODMA_ROTATE_ODMA_CORE_IICR_LENGTHERR_MASK) | (((uint32_t)val) << ROTATE_ODMA_ROTATE_ODMA_CORE_IICR_LENGTHERR_SHIFT))

//====================================================================
//Register: ODMA Interrupt Force Register (IIFR)
//====================================================================

#define  ROTATE_ODMA_ROTATE_ODMA_CORE_IIFR_RESERVED1_MASK 0xfffffffe
#define  ROTATE_ODMA_ROTATE_ODMA_CORE_IIFR_RESERVED1_SHIFT 1
#define  ROTATE_ODMA_ROTATE_ODMA_CORE_IIFR_RESERVED1_MASK_SHIFT(reg) (((reg) & ROTATE_ODMA_ROTATE_ODMA_CORE_IIFR_RESERVED1_MASK) >> ROTATE_ODMA_ROTATE_ODMA_CORE_IIFR_RESERVED1_SHIFT)
#define  ROTATE_ODMA_ROTATE_ODMA_CORE_IIFR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_ODMA_ROTATE_ODMA_CORE_IIFR_RESERVED1_MASK) | (((uint32_t)val) << ROTATE_ODMA_ROTATE_ODMA_CORE_IIFR_RESERVED1_SHIFT))

#define  ROTATE_ODMA_ROTATE_ODMA_CORE_IIFR_LENGTHERR_MASK 0x1
#define  ROTATE_ODMA_ROTATE_ODMA_CORE_IIFR_LENGTHERR_SHIFT 0
#define  ROTATE_ODMA_ROTATE_ODMA_CORE_IIFR_LENGTHERR_MASK_SHIFT(reg) (((reg) & ROTATE_ODMA_ROTATE_ODMA_CORE_IIFR_LENGTHERR_MASK) >> ROTATE_ODMA_ROTATE_ODMA_CORE_IIFR_LENGTHERR_SHIFT)
#define  ROTATE_ODMA_ROTATE_ODMA_CORE_IIFR_LENGTHERR_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_ODMA_ROTATE_ODMA_CORE_IIFR_LENGTHERR_MASK) | (((uint32_t)val) << ROTATE_ODMA_ROTATE_ODMA_CORE_IIFR_LENGTHERR_SHIFT))

//====================================================================
//Register: ODMA Tag Register 0 (ITR0)
//====================================================================

#define  ROTATE_ODMA_ROTATE_ODMA_CORE_ITR0_RESERVED1_MASK 0xffff0000
#define  ROTATE_ODMA_ROTATE_ODMA_CORE_ITR0_RESERVED1_SHIFT 16
#define  ROTATE_ODMA_ROTATE_ODMA_CORE_ITR0_RESERVED1_MASK_SHIFT(reg) (((reg) & ROTATE_ODMA_ROTATE_ODMA_CORE_ITR0_RESERVED1_MASK) >> ROTATE_ODMA_ROTATE_ODMA_CORE_ITR0_RESERVED1_SHIFT)
#define  ROTATE_ODMA_ROTATE_ODMA_CORE_ITR0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_ODMA_ROTATE_ODMA_CORE_ITR0_RESERVED1_MASK) | (((uint32_t)val) << ROTATE_ODMA_ROTATE_ODMA_CORE_ITR0_RESERVED1_SHIFT))

#define  ROTATE_ODMA_ROTATE_ODMA_CORE_ITR0_TAGCFG_MASK 0xffff
#define  ROTATE_ODMA_ROTATE_ODMA_CORE_ITR0_TAGCFG_SHIFT 0
#define  ROTATE_ODMA_ROTATE_ODMA_CORE_ITR0_TAGCFG_MASK_SHIFT(reg) (((reg) & ROTATE_ODMA_ROTATE_ODMA_CORE_ITR0_TAGCFG_MASK) >> ROTATE_ODMA_ROTATE_ODMA_CORE_ITR0_TAGCFG_SHIFT)
#define  ROTATE_ODMA_ROTATE_ODMA_CORE_ITR0_TAGCFG_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_ODMA_ROTATE_ODMA_CORE_ITR0_TAGCFG_MASK) | (((uint32_t)val) << ROTATE_ODMA_ROTATE_ODMA_CORE_ITR0_TAGCFG_SHIFT))

//====================================================================
//Register: ODMA Tag Register 1 (ITR1)
//====================================================================

#define  ROTATE_ODMA_ROTATE_ODMA_CORE_ITR1_RESERVED1_MASK 0xffff0000
#define  ROTATE_ODMA_ROTATE_ODMA_CORE_ITR1_RESERVED1_SHIFT 16
#define  ROTATE_ODMA_ROTATE_ODMA_CORE_ITR1_RESERVED1_MASK_SHIFT(reg) (((reg) & ROTATE_ODMA_ROTATE_ODMA_CORE_ITR1_RESERVED1_MASK) >> ROTATE_ODMA_ROTATE_ODMA_CORE_ITR1_RESERVED1_SHIFT)
#define  ROTATE_ODMA_ROTATE_ODMA_CORE_ITR1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_ODMA_ROTATE_ODMA_CORE_ITR1_RESERVED1_MASK) | (((uint32_t)val) << ROTATE_ODMA_ROTATE_ODMA_CORE_ITR1_RESERVED1_SHIFT))

#define  ROTATE_ODMA_ROTATE_ODMA_CORE_ITR1_TAGMAJ_MASK 0xffff
#define  ROTATE_ODMA_ROTATE_ODMA_CORE_ITR1_TAGMAJ_SHIFT 0
#define  ROTATE_ODMA_ROTATE_ODMA_CORE_ITR1_TAGMAJ_MASK_SHIFT(reg) (((reg) & ROTATE_ODMA_ROTATE_ODMA_CORE_ITR1_TAGMAJ_MASK) >> ROTATE_ODMA_ROTATE_ODMA_CORE_ITR1_TAGMAJ_SHIFT)
#define  ROTATE_ODMA_ROTATE_ODMA_CORE_ITR1_TAGMAJ_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_ODMA_ROTATE_ODMA_CORE_ITR1_TAGMAJ_MASK) | (((uint32_t)val) << ROTATE_ODMA_ROTATE_ODMA_CORE_ITR1_TAGMAJ_SHIFT))

//====================================================================
//Register: ODMA Tag Register 2 (ITR2)
//====================================================================

#define  ROTATE_ODMA_ROTATE_ODMA_CORE_ITR2_RESERVED1_MASK 0xffff0000
#define  ROTATE_ODMA_ROTATE_ODMA_CORE_ITR2_RESERVED1_SHIFT 16
#define  ROTATE_ODMA_ROTATE_ODMA_CORE_ITR2_RESERVED1_MASK_SHIFT(reg) (((reg) & ROTATE_ODMA_ROTATE_ODMA_CORE_ITR2_RESERVED1_MASK) >> ROTATE_ODMA_ROTATE_ODMA_CORE_ITR2_RESERVED1_SHIFT)
#define  ROTATE_ODMA_ROTATE_ODMA_CORE_ITR2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_ODMA_ROTATE_ODMA_CORE_ITR2_RESERVED1_MASK) | (((uint32_t)val) << ROTATE_ODMA_ROTATE_ODMA_CORE_ITR2_RESERVED1_SHIFT))

#define  ROTATE_ODMA_ROTATE_ODMA_CORE_ITR2_TAGMID_MASK 0xffff
#define  ROTATE_ODMA_ROTATE_ODMA_CORE_ITR2_TAGMID_SHIFT 0
#define  ROTATE_ODMA_ROTATE_ODMA_CORE_ITR2_TAGMID_MASK_SHIFT(reg) (((reg) & ROTATE_ODMA_ROTATE_ODMA_CORE_ITR2_TAGMID_MASK) >> ROTATE_ODMA_ROTATE_ODMA_CORE_ITR2_TAGMID_SHIFT)
#define  ROTATE_ODMA_ROTATE_ODMA_CORE_ITR2_TAGMID_REPLACE_VAL(reg,val) (((reg) & ~ROTATE_ODMA_ROTATE_ODMA_CORE_ITR2_TAGMID_MASK) | (((uint32_t)val) << ROTATE_ODMA_ROTATE_ODMA_CORE_ITR2_TAGMID_SHIFT))

#endif // ROTATE_TOP
