/*
**************************************************************************
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2012-2013, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
******************************************************************************
 */


 
#ifndef _ROTATE_TOP_CFG_H_
#define _ROTATE_TOP_CFG_H_

/* #include "ROTATE_TOP_Common_regstructs.h" */ /* ROTATE_TOP has no top-level registers */
#include "ROTATE_regstructs.h"
#include "ROTATE_IDMA_reg_ptrs.h"
#include "ROTATE_ODMA_reg_ptrs.h"
#include "ROTATE_TOP_reg_ptrs.h"
#include "ROTATE_cfg.h"
#include "ROTATE_IDMA_cfg.h"
#include "ROTATE_ODMA_cfg.h"

#ifndef STRING_LENGTH_ROTATE_TOP
#define STRING_LENGTH_ROTATE_TOP 64
#endif

/*
 *-----------------------------------------------------------------------
 * Configuration structure
 *-----------------------------------------------------------------------
 */
typedef struct ROTATE_TOP_cfg_s
{

  char displayName[STRING_LENGTH_ROTATE_TOP];

  /* pointers to the sub-blocks' config structs */
  ROTATE_cfg_p ROTATE_cfg;
  ROTATE_IDMA_cfg_p ROTATE_IDMA_cfg;
  ROTATE_ODMA_cfg_p ROTATE_ODMA_cfg;

} ROTATE_TOP_cfg_t, *ROTATE_TOP_cfg_p;


/*
 *-----------------------------------------------------------------------
 * prototypes
 *-----------------------------------------------------------------------
 */
ROTATE_TOP_cfg_p get_cfg_chandle_ROTATE_TOP();

ROTATE_TOP_reg_ptrs_p get_regs_chandle_ROTATE_TOP(
  /* ROTATE_TOP_COMMON_REGS_t *ROTATE_TOP_regs, */ /* ROTATE_TOP has no top-level registers */
  ROTATE_REGS_t *ROTATE_regs,
  ROTATE_IDMA_reg_ptrs_p ROTATE_IDMA_regs,
  ROTATE_ODMA_reg_ptrs_p ROTATE_ODMA_regs
);

uint32_t cfg_driver_ROTATE_TOP(
  ROTATE_TOP_cfg_p cfg,
  ROTATE_TOP_reg_ptrs_p regs,
  uint32_t *rc
);

uint32_t start_dma_ROTATE_TOP(
  ROTATE_TOP_cfg_p cfg,
  ROTATE_TOP_reg_ptrs_p regs
);

uint32_t wait_for_done_ROTATE_TOP(
  ROTATE_TOP_cfg_p cfg,
  ROTATE_TOP_reg_ptrs_p regs,
  uint32_t irq_num,
  uint32_t usec_timeout,
  uint32_t *rc
);

uint32_t cleanup_ROTATE_TOP(
  ROTATE_TOP_cfg_p cfg,
  ROTATE_TOP_reg_ptrs_p regs,
  uint32_t *rc
);

uint32_t ISR_ROTATE_TOP(
  const void *cfg,
  const void *regs
);

#endif
