 /*
 **************************************************************************************
 *
 * (c) Copyright 2013 Marvell International Ltd.
 *
 *
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/.
 *
 **************************************************************************************
 *
 * \file RIPC_regmasks.h
 * Generated using RegBuild 1.6.3
 *
 **************************************************************************************
 */

#ifndef _RIPC_REGMASKS_H_
#define _RIPC_REGMASKS_H_

#ifndef __KERNEL__
#include <stdint.h>
#endif

//====================================================================
//
//Register File: RIPC (RIPC)
/** \brief Register Descriptions for the RIPC (rev 0 . 1 . 1 . 1)*/
//
//====================================================================

//====================================================================
//Register: RIPCx Status Register (RIPCx_STATUS_REG)
//====================================================================

#define  RIPC_RIPCX_STATUS_REG_RESERVED1_MASK 0xfffffffe
#define  RIPC_RIPCX_STATUS_REG_RESERVED1_SHIFT 1
#define  RIPC_RIPCX_STATUS_REG_RESERVED1_MASK_SHIFT(reg) (((reg) & RIPC_RIPCX_STATUS_REG_RESERVED1_MASK) >> RIPC_RIPCX_STATUS_REG_RESERVED1_SHIFT)
#define  RIPC_RIPCX_STATUS_REG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~RIPC_RIPCX_STATUS_REG_RESERVED1_MASK) | (((uint32_t)val) << RIPC_RIPCX_STATUS_REG_RESERVED1_SHIFT))

#define  RIPC_RIPCX_STATUS_REG_STATUS_MASK 0x1
#define  RIPC_RIPCX_STATUS_REG_STATUS_SHIFT 0
#define  RIPC_RIPCX_STATUS_REG_STATUS_MASK_SHIFT(reg) (((reg) & RIPC_RIPCX_STATUS_REG_STATUS_MASK) >> RIPC_RIPCX_STATUS_REG_STATUS_SHIFT)
#define  RIPC_RIPCX_STATUS_REG_STATUS_REPLACE_VAL(reg,val) (((reg) & ~RIPC_RIPCX_STATUS_REG_STATUS_MASK) | (((uint32_t)val) << RIPC_RIPCX_STATUS_REG_STATUS_SHIFT))

//====================================================================
//Register: RIPCx Int Request Register (Instance 1 of 3) (RIPCx_INT_REG0)
/** \brief  (Instance 1 of 3)*/
//====================================================================

#define  RIPC_RIPCX_INT_REG0_RESERVED1_MASK 0xfffffffe
#define  RIPC_RIPCX_INT_REG0_RESERVED1_SHIFT 1
#define  RIPC_RIPCX_INT_REG0_RESERVED1_MASK_SHIFT(reg) (((reg) & RIPC_RIPCX_INT_REG0_RESERVED1_MASK) >> RIPC_RIPCX_INT_REG0_RESERVED1_SHIFT)
#define  RIPC_RIPCX_INT_REG0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~RIPC_RIPCX_INT_REG0_RESERVED1_MASK) | (((uint32_t)val) << RIPC_RIPCX_INT_REG0_RESERVED1_SHIFT))

#define  RIPC_RIPCX_INT_REG0_INT_REQ_MASK 0x1
#define  RIPC_RIPCX_INT_REG0_INT_REQ_SHIFT 0
#define  RIPC_RIPCX_INT_REG0_INT_REQ_MASK_SHIFT(reg) (((reg) & RIPC_RIPCX_INT_REG0_INT_REQ_MASK) >> RIPC_RIPCX_INT_REG0_INT_REQ_SHIFT)
#define  RIPC_RIPCX_INT_REG0_INT_REQ_REPLACE_VAL(reg,val) (((reg) & ~RIPC_RIPCX_INT_REG0_INT_REQ_MASK) | (((uint32_t)val) << RIPC_RIPCX_INT_REG0_INT_REQ_SHIFT))

//====================================================================
//Register: RIPCx Int Request Register (Instance 2 of 3) (RIPCx_INT_REG1)
/** \brief  (Instance 2 of 3)*/
//====================================================================

#define  RIPC_RIPCX_INT_REG1_RESERVED1_MASK 0xfffffffe
#define  RIPC_RIPCX_INT_REG1_RESERVED1_SHIFT 1
#define  RIPC_RIPCX_INT_REG1_RESERVED1_MASK_SHIFT(reg) (((reg) & RIPC_RIPCX_INT_REG1_RESERVED1_MASK) >> RIPC_RIPCX_INT_REG1_RESERVED1_SHIFT)
#define  RIPC_RIPCX_INT_REG1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~RIPC_RIPCX_INT_REG1_RESERVED1_MASK) | (((uint32_t)val) << RIPC_RIPCX_INT_REG1_RESERVED1_SHIFT))

#define  RIPC_RIPCX_INT_REG1_INT_REQ_MASK 0x1
#define  RIPC_RIPCX_INT_REG1_INT_REQ_SHIFT 0
#define  RIPC_RIPCX_INT_REG1_INT_REQ_MASK_SHIFT(reg) (((reg) & RIPC_RIPCX_INT_REG1_INT_REQ_MASK) >> RIPC_RIPCX_INT_REG1_INT_REQ_SHIFT)
#define  RIPC_RIPCX_INT_REG1_INT_REQ_REPLACE_VAL(reg,val) (((reg) & ~RIPC_RIPCX_INT_REG1_INT_REQ_MASK) | (((uint32_t)val) << RIPC_RIPCX_INT_REG1_INT_REQ_SHIFT))

//====================================================================
//Register: RIPCx Int Request Register (Instance 3 of 3) (RIPCx_INT_REG2)
/** \brief  (Instance 3 of 3)*/
//====================================================================

#define  RIPC_RIPCX_INT_REG2_RESERVED1_MASK 0xfffffffe
#define  RIPC_RIPCX_INT_REG2_RESERVED1_SHIFT 1
#define  RIPC_RIPCX_INT_REG2_RESERVED1_MASK_SHIFT(reg) (((reg) & RIPC_RIPCX_INT_REG2_RESERVED1_MASK) >> RIPC_RIPCX_INT_REG2_RESERVED1_SHIFT)
#define  RIPC_RIPCX_INT_REG2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~RIPC_RIPCX_INT_REG2_RESERVED1_MASK) | (((uint32_t)val) << RIPC_RIPCX_INT_REG2_RESERVED1_SHIFT))

#define  RIPC_RIPCX_INT_REG2_INT_REQ_MASK 0x1
#define  RIPC_RIPCX_INT_REG2_INT_REQ_SHIFT 0
#define  RIPC_RIPCX_INT_REG2_INT_REQ_MASK_SHIFT(reg) (((reg) & RIPC_RIPCX_INT_REG2_INT_REQ_MASK) >> RIPC_RIPCX_INT_REG2_INT_REQ_SHIFT)
#define  RIPC_RIPCX_INT_REG2_INT_REQ_REPLACE_VAL(reg,val) (((reg) & ~RIPC_RIPCX_INT_REG2_INT_REQ_MASK) | (((uint32_t)val) << RIPC_RIPCX_INT_REG2_INT_REQ_SHIFT))

//====================================================================
//Register: RIPCx Interrupt Status Register (RIPCx_INT_STAT_REG)
//====================================================================

#define  RIPC_RIPCX_INT_STAT_REG_RESERVED1_MASK 0xfffffff8
#define  RIPC_RIPCX_INT_STAT_REG_RESERVED1_SHIFT 3
#define  RIPC_RIPCX_INT_STAT_REG_RESERVED1_MASK_SHIFT(reg) (((reg) & RIPC_RIPCX_INT_STAT_REG_RESERVED1_MASK) >> RIPC_RIPCX_INT_STAT_REG_RESERVED1_SHIFT)
#define  RIPC_RIPCX_INT_STAT_REG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~RIPC_RIPCX_INT_STAT_REG_RESERVED1_MASK) | (((uint32_t)val) << RIPC_RIPCX_INT_STAT_REG_RESERVED1_SHIFT))

#define  RIPC_RIPCX_INT_STAT_REG_INT_STAT_MASK 0x7
#define  RIPC_RIPCX_INT_STAT_REG_INT_STAT_SHIFT 0
#define  RIPC_RIPCX_INT_STAT_REG_INT_STAT_MASK_SHIFT(reg) (((reg) & RIPC_RIPCX_INT_STAT_REG_INT_STAT_MASK) >> RIPC_RIPCX_INT_STAT_REG_INT_STAT_SHIFT)
#define  RIPC_RIPCX_INT_STAT_REG_INT_STAT_REPLACE_VAL(reg,val) (((reg) & ~RIPC_RIPCX_INT_STAT_REG_INT_STAT_MASK) | (((uint32_t)val) << RIPC_RIPCX_INT_STAT_REG_INT_STAT_SHIFT))

//====================================================================
//Register: Revision (Major and Mid) Register (RIPCx_MAJ_MID_REV_REG)
//====================================================================

#define  RIPC_RIPCX_MAJ_MID_REV_REG_MAJ_REV_MASK 0xffff0000
#define  RIPC_RIPCX_MAJ_MID_REV_REG_MAJ_REV_SHIFT 16
#define  RIPC_RIPCX_MAJ_MID_REV_REG_MAJ_REV_MASK_SHIFT(reg) (((reg) & RIPC_RIPCX_MAJ_MID_REV_REG_MAJ_REV_MASK) >> RIPC_RIPCX_MAJ_MID_REV_REG_MAJ_REV_SHIFT)
#define  RIPC_RIPCX_MAJ_MID_REV_REG_MAJ_REV_REPLACE_VAL(reg,val) (((reg) & ~RIPC_RIPCX_MAJ_MID_REV_REG_MAJ_REV_MASK) | (((uint32_t)val) << RIPC_RIPCX_MAJ_MID_REV_REG_MAJ_REV_SHIFT))

#define  RIPC_RIPCX_MAJ_MID_REV_REG_MID_REV_MASK 0xffff
#define  RIPC_RIPCX_MAJ_MID_REV_REG_MID_REV_SHIFT 0
#define  RIPC_RIPCX_MAJ_MID_REV_REG_MID_REV_MASK_SHIFT(reg) (((reg) & RIPC_RIPCX_MAJ_MID_REV_REG_MID_REV_MASK) >> RIPC_RIPCX_MAJ_MID_REV_REG_MID_REV_SHIFT)
#define  RIPC_RIPCX_MAJ_MID_REV_REG_MID_REV_REPLACE_VAL(reg,val) (((reg) & ~RIPC_RIPCX_MAJ_MID_REV_REG_MID_REV_MASK) | (((uint32_t)val) << RIPC_RIPCX_MAJ_MID_REV_REG_MID_REV_SHIFT))

//====================================================================
//Register: Revision (Major and Mid) Register (RIPCx_CFG_REV_REG)
//====================================================================

#define  RIPC_RIPCX_CFG_REV_REG_RESERVED1_MASK 0xffff0000
#define  RIPC_RIPCX_CFG_REV_REG_RESERVED1_SHIFT 16
#define  RIPC_RIPCX_CFG_REV_REG_RESERVED1_MASK_SHIFT(reg) (((reg) & RIPC_RIPCX_CFG_REV_REG_RESERVED1_MASK) >> RIPC_RIPCX_CFG_REV_REG_RESERVED1_SHIFT)
#define  RIPC_RIPCX_CFG_REV_REG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~RIPC_RIPCX_CFG_REV_REG_RESERVED1_MASK) | (((uint32_t)val) << RIPC_RIPCX_CFG_REV_REG_RESERVED1_SHIFT))

#define  RIPC_RIPCX_CFG_REV_REG_CFG_REV_MASK 0xffff
#define  RIPC_RIPCX_CFG_REV_REG_CFG_REV_SHIFT 0
#define  RIPC_RIPCX_CFG_REV_REG_CFG_REV_MASK_SHIFT(reg) (((reg) & RIPC_RIPCX_CFG_REV_REG_CFG_REV_MASK) >> RIPC_RIPCX_CFG_REV_REG_CFG_REV_SHIFT)
#define  RIPC_RIPCX_CFG_REV_REG_CFG_REV_REPLACE_VAL(reg,val) (((reg) & ~RIPC_RIPCX_CFG_REV_REG_CFG_REV_MASK) | (((uint32_t)val) << RIPC_RIPCX_CFG_REV_REG_CFG_REV_SHIFT))

#endif // RIPC
