 /*
 **************************************************************************************
 *
 * (c) Copyright 2013 Marvell International Ltd.
 *
 *
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/.
 *
 **************************************************************************************
 *
 * \file PadEdgeDetect_top_regmasks.h
 * Generated using RegBuild 1.6.3
 *
 **************************************************************************************
 */

#ifndef _PADEDGEDETECT_TOP_REGMASKS_H_
#define _PADEDGEDETECT_TOP_REGMASKS_H_

#ifndef __KERNEL__
#include <stdint.h>
#endif

//====================================================================
//
//Register File: Pad Edge Detect Top (PadEdgeDetect_TOP)
/** \brief (rev 0 . 1 . 0 . 1)
    Register Descriptions for the Pad Edge Detect banks*/
//
//====================================================================

//====================================================================
//Register: IP Tagging Revision 0 (REV0)
/** \brief Provide means for firmware to read IP tagging information.
      This register of particular interest to firmware.*/
//====================================================================

#define  PADEDGEDETECT_TOP_REV0_MAJ_MASK 0xffff0000
#define  PADEDGEDETECT_TOP_REV0_MAJ_SHIFT 16
#define  PADEDGEDETECT_TOP_REV0_MAJ_MASK_SHIFT(reg) (((reg) & PADEDGEDETECT_TOP_REV0_MAJ_MASK) >> PADEDGEDETECT_TOP_REV0_MAJ_SHIFT)
#define  PADEDGEDETECT_TOP_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~PADEDGEDETECT_TOP_REV0_MAJ_MASK) | (((uint32_t)val) << PADEDGEDETECT_TOP_REV0_MAJ_SHIFT))

#define  PADEDGEDETECT_TOP_REV0_MID_MASK 0xffff
#define  PADEDGEDETECT_TOP_REV0_MID_SHIFT 0
#define  PADEDGEDETECT_TOP_REV0_MID_MASK_SHIFT(reg) (((reg) & PADEDGEDETECT_TOP_REV0_MID_MASK) >> PADEDGEDETECT_TOP_REV0_MID_SHIFT)
#define  PADEDGEDETECT_TOP_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~PADEDGEDETECT_TOP_REV0_MID_MASK) | (((uint32_t)val) << PADEDGEDETECT_TOP_REV0_MID_SHIFT))

//====================================================================
//Register: IP Tagging Revision 1 (REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  PADEDGEDETECT_TOP_REV1_RESERVED1_MASK 0xffff0000
#define  PADEDGEDETECT_TOP_REV1_RESERVED1_SHIFT 16
#define  PADEDGEDETECT_TOP_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & PADEDGEDETECT_TOP_REV1_RESERVED1_MASK) >> PADEDGEDETECT_TOP_REV1_RESERVED1_SHIFT)
#define  PADEDGEDETECT_TOP_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PADEDGEDETECT_TOP_REV1_RESERVED1_MASK) | (((uint32_t)val) << PADEDGEDETECT_TOP_REV1_RESERVED1_SHIFT))

#define  PADEDGEDETECT_TOP_REV1_CFG_MASK 0xffff
#define  PADEDGEDETECT_TOP_REV1_CFG_SHIFT 0
#define  PADEDGEDETECT_TOP_REV1_CFG_MASK_SHIFT(reg) (((reg) & PADEDGEDETECT_TOP_REV1_CFG_MASK) >> PADEDGEDETECT_TOP_REV1_CFG_SHIFT)
#define  PADEDGEDETECT_TOP_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~PADEDGEDETECT_TOP_REV1_CFG_MASK) | (((uint32_t)val) << PADEDGEDETECT_TOP_REV1_CFG_SHIFT))

//====================================================================
//
//Register File: Edge Detect Bank 0 Register (EdgeDetect0)
//
//====================================================================

//====================================================================
//Register: Edge Detect (EDGE)
/** \brief The Edge Detect register gives visibility to the Edge Detect status of the chip pads.
      Enabling and clearing these edge detect signals is done through the pad configuration
      registers.*/
//====================================================================

#define  EDGEDETECT0_EDGE_RESERVED1_MASK 0xffff8000
#define  EDGEDETECT0_EDGE_RESERVED1_SHIFT 15
#define  EDGEDETECT0_EDGE_RESERVED1_MASK_SHIFT(reg) (((reg) & EDGEDETECT0_EDGE_RESERVED1_MASK) >> EDGEDETECT0_EDGE_RESERVED1_SHIFT)
#define  EDGEDETECT0_EDGE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~EDGEDETECT0_EDGE_RESERVED1_MASK) | (((uint32_t)val) << EDGEDETECT0_EDGE_RESERVED1_SHIFT))

#define  EDGEDETECT0_EDGE_ED_MASK 0x7fff
#define  EDGEDETECT0_EDGE_ED_SHIFT 0
#define  EDGEDETECT0_EDGE_ED_MASK_SHIFT(reg) (((reg) & EDGEDETECT0_EDGE_ED_MASK) >> EDGEDETECT0_EDGE_ED_SHIFT)
#define  EDGEDETECT0_EDGE_ED_REPLACE_VAL(reg,val) (((reg) & ~EDGEDETECT0_EDGE_ED_MASK) | (((uint32_t)val) << EDGEDETECT0_EDGE_ED_SHIFT))

//====================================================================
//
//Register File: Edge Detect Bank 1 Register (EdgeDetect1)
//
//====================================================================

//====================================================================
//Register: Edge Detect (EDGE)
/** \brief The Edge Detect register gives visibility to the Edge Detect status of the chip pads.
      Enabling and clearing these edge detect signals is done through the pad configuration
      registers.*/
//====================================================================

#define  EDGEDETECT1_EDGE_ED_MASK 0xffffffff
#define  EDGEDETECT1_EDGE_ED_SHIFT 0
#define  EDGEDETECT1_EDGE_ED_MASK_SHIFT(reg) (((reg) & EDGEDETECT1_EDGE_ED_MASK) >> EDGEDETECT1_EDGE_ED_SHIFT)
#define  EDGEDETECT1_EDGE_ED_REPLACE_VAL(reg,val) (((reg) & ~EDGEDETECT1_EDGE_ED_MASK) | (((uint32_t)val) << EDGEDETECT1_EDGE_ED_SHIFT))

//====================================================================
//
//Register File: Edge Detect Bank 2 Register (EdgeDetect2)
//
//====================================================================

//====================================================================
//Register: Edge Detect (EDGE)
/** \brief The Edge Detect register gives visibility to the Edge Detect status of the chip pads.
      Enabling and clearing these edge detect signals is done through the pad configuration
      registers.*/
//====================================================================

#define  EDGEDETECT2_EDGE_ED_MASK 0xffffffff
#define  EDGEDETECT2_EDGE_ED_SHIFT 0
#define  EDGEDETECT2_EDGE_ED_MASK_SHIFT(reg) (((reg) & EDGEDETECT2_EDGE_ED_MASK) >> EDGEDETECT2_EDGE_ED_SHIFT)
#define  EDGEDETECT2_EDGE_ED_REPLACE_VAL(reg,val) (((reg) & ~EDGEDETECT2_EDGE_ED_MASK) | (((uint32_t)val) << EDGEDETECT2_EDGE_ED_SHIFT))

//====================================================================
//
//Register File: Edge Detect Bank 3 Register (EdgeDetect3)
//
//====================================================================

//====================================================================
//Register: Edge Detect (EDGE)
/** \brief The Edge Detect register gives visibility to the Edge Detect status of the chip pads.
      Enabling and clearing these edge detect signals is done through the pad configuration
      registers.*/
//====================================================================

#define  EDGEDETECT3_EDGE_ED_MASK 0xffffffff
#define  EDGEDETECT3_EDGE_ED_SHIFT 0
#define  EDGEDETECT3_EDGE_ED_MASK_SHIFT(reg) (((reg) & EDGEDETECT3_EDGE_ED_MASK) >> EDGEDETECT3_EDGE_ED_SHIFT)
#define  EDGEDETECT3_EDGE_ED_REPLACE_VAL(reg,val) (((reg) & ~EDGEDETECT3_EDGE_ED_MASK) | (((uint32_t)val) << EDGEDETECT3_EDGE_ED_SHIFT))

//====================================================================
//
//Register File: Edge Detect Bank 4 Register (EdgeDetect4)
//
//====================================================================

//====================================================================
//Register: Edge Detect (EDGE)
/** \brief The Edge Detect register gives visibility to the Edge Detect status of the chip pads.
      Enabling and clearing these edge detect signals is done through the pad configuration
      registers.*/
//====================================================================

#define  EDGEDETECT4_EDGE_ED_MASK 0xffffffff
#define  EDGEDETECT4_EDGE_ED_SHIFT 0
#define  EDGEDETECT4_EDGE_ED_MASK_SHIFT(reg) (((reg) & EDGEDETECT4_EDGE_ED_MASK) >> EDGEDETECT4_EDGE_ED_SHIFT)
#define  EDGEDETECT4_EDGE_ED_REPLACE_VAL(reg,val) (((reg) & ~EDGEDETECT4_EDGE_ED_MASK) | (((uint32_t)val) << EDGEDETECT4_EDGE_ED_SHIFT))

//====================================================================
//
//Register File: Edge Detect Bank 5 Register (EdgeDetect5)
//
//====================================================================

//====================================================================
//Register: Edge Detect (EDGE)
/** \brief The Edge Detect register gives visibility to the Edge Detect status of the chip pads.
      Enabling and clearing these edge detect signals is done through the pad configuration
      registers.*/
//====================================================================

#define  EDGEDETECT5_EDGE_ED_MASK 0xffffffff
#define  EDGEDETECT5_EDGE_ED_SHIFT 0
#define  EDGEDETECT5_EDGE_ED_MASK_SHIFT(reg) (((reg) & EDGEDETECT5_EDGE_ED_MASK) >> EDGEDETECT5_EDGE_ED_SHIFT)
#define  EDGEDETECT5_EDGE_ED_REPLACE_VAL(reg,val) (((reg) & ~EDGEDETECT5_EDGE_ED_MASK) | (((uint32_t)val) << EDGEDETECT5_EDGE_ED_SHIFT))

//====================================================================
//
//Register File: Edge Detect Bank 6 Register (EdgeDetect6)
//
//====================================================================

//====================================================================
//Register: Edge Detect (EDGE)
/** \brief The Edge Detect register gives visibility to the Edge Detect status of the chip pads.
      Enabling and clearing these edge detect signals is done through the pad configuration
      registers.*/
//====================================================================

#define  EDGEDETECT6_EDGE_ED_MASK 0xffffffff
#define  EDGEDETECT6_EDGE_ED_SHIFT 0
#define  EDGEDETECT6_EDGE_ED_MASK_SHIFT(reg) (((reg) & EDGEDETECT6_EDGE_ED_MASK) >> EDGEDETECT6_EDGE_ED_SHIFT)
#define  EDGEDETECT6_EDGE_ED_REPLACE_VAL(reg,val) (((reg) & ~EDGEDETECT6_EDGE_ED_MASK) | (((uint32_t)val) << EDGEDETECT6_EDGE_ED_SHIFT))

//====================================================================
//
//Register File: Edge Detect Bank 7 Register (EdgeDetect7)
//
//====================================================================

//====================================================================
//Register: Edge Detect (EDGE)
/** \brief The Edge Detect register gives visibility to the Edge Detect status of the chip pads.
      Enabling and clearing these edge detect signals is done through the pad configuration
      registers.*/
//====================================================================

#define  EDGEDETECT7_EDGE_ED_MASK 0xffffffff
#define  EDGEDETECT7_EDGE_ED_SHIFT 0
#define  EDGEDETECT7_EDGE_ED_MASK_SHIFT(reg) (((reg) & EDGEDETECT7_EDGE_ED_MASK) >> EDGEDETECT7_EDGE_ED_SHIFT)
#define  EDGEDETECT7_EDGE_ED_REPLACE_VAL(reg,val) (((reg) & ~EDGEDETECT7_EDGE_ED_MASK) | (((uint32_t)val) << EDGEDETECT7_EDGE_ED_SHIFT))

#endif // PADEDGEDETECT_TOP
