 /*
 **************************************************************************************
 *
 * (c) Copyright 2013 Marvell International Ltd.
 *
 *
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/.
 *
 **************************************************************************************
 *
 * \file PS_ESD_regstructs.h
 * Generated using RegBuild 1.6.3
 *
 **************************************************************************************
 */

#ifndef _PS_ESD_REGSTRUCTS_H_
#define _PS_ESD_REGSTRUCTS_H_

#ifndef __KERNEL__
#include <stdint.h>
#endif

//====================================================================
//
//Register File: PageSense and ESD Detect Block (PS_ESD)
//
//====================================================================

typedef struct PS_ESD_REGS_s
{
  volatile uint32_t ESD_CFG;  ///< 0x0 [R/W]: ESD Configuration
  volatile uint32_t ESD_START_0_R;  ///< 0x4 [R/W]: ESD Start Address
  volatile uint32_t ESD_START_1_G;  ///< 0x8 [R/W]: ESD Start Address 1
  volatile uint32_t ESD_START_2_B;  ///< 0xc [R/W]: ESD Start Address 2
  volatile uint32_t ESD_TOL;  ///< 0x10 [R/W]: ESD Tolerance
  volatile uint32_t ESD_CHG;  ///< 0x14 [R/W]: ESD Change
  volatile uint32_t ESD_RST;  ///< 0x18 [W]: ESD Color Reset
  volatile uint32_t ESD_LCNT0;  ///< 0x1c [R]: ESD Event Line Count Color0
  volatile uint32_t ESD_LCNT1;  ///< 0x20 [R]: ESD Event Line Count Color1
  volatile uint32_t ESD_LCNT2;  ///< 0x24 [R]: ESD Event Line Count Color2
  volatile uint32_t PS_CFG;  ///< 0x28 [R/W]: PageSense Configuration
  volatile uint32_t PS_GO;  ///< 0x2c [W]: PageSense Go
  volatile uint32_t PS_START;  ///< 0x30 [R/W]: PageSense Start Pixel
  volatile uint32_t PS_WIDTH0;  ///< 0x34 [R/W]: PageSense Region Widths 0
  volatile uint32_t PS_WIDTH1;  ///< 0x38 [R/W]: PageSense Region Widths 1
  volatile uint32_t PS_TOL;  ///< 0x3c [R/W]: PageSense Region Tolerance
  volatile uint32_t PS_TOTAL_WID;  ///< 0x40 [R/W]: PageSense Overall Width
  volatile uint32_t PS_TOGGLE;  ///< 0x44 [R/W]: PageSense Toggle Delta
  volatile uint32_t PS_CNT;  ///< 0x48 [R/W]: PageSense Count
  volatile uint32_t PS_LCNT;  ///< 0x4c [R]: PageSense Detect Line Count
  volatile uint32_t PS_FILT;  ///< 0x50 [R]: PageSense Filter Capture
  volatile uint32_t PS_STAT;  ///< 0x54 [R]: PageSense Status
  volatile uint32_t LCNT;  ///< 0x58 [R]: Line Counter
  volatile uint32_t LCNT_WR;  ///< 0x5c [W]: Line Counter
  volatile uint32_t IEN;  ///< 0x60 [R/W]: Interrupt Enable Register
  volatile uint32_t IPEND;  ///< 0x64 [R]: Interrupt Pending Register
  volatile uint32_t IACK;  ///< 0x68 [W]: Interrupt Acknowledge Register
  volatile uint32_t IFORCE;  ///< 0x6c [W]: Interrupt Force Register
  volatile uint32_t REV0;  ///< 0x70 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0x74 [R]: IP Tagging Revision 1
} PS_ESD_REGS_t;

#endif // PS_ESD
