 /*
 **************************************************************************************
 *
 * (c) Copyright 2013 Marvell International Ltd.
 *
 *
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/.
 *
 **************************************************************************************
 *
 * \file PS_ESD_regmasks.h
 * Generated using RegBuild 1.6.3
 *
 **************************************************************************************
 */

#ifndef _PS_ESD_REGMASKS_H_
#define _PS_ESD_REGMASKS_H_

#ifndef __KERNEL__
#include <stdint.h>
#endif

//====================================================================
//
//Register File: PageSense and ESD Detect Block (PS_ESD)
//
//====================================================================

//====================================================================
//Register: ESD Configuration (ESD_CFG)
/** \brief Overall configuration register for ESD detection logic (rev 0 . 3 . 1 . 4)*/
//====================================================================

#define  PS_ESD_ESD_CFG_RESERVED1_MASK 0xffffffe0
#define  PS_ESD_ESD_CFG_RESERVED1_SHIFT 5
#define  PS_ESD_ESD_CFG_RESERVED1_MASK_SHIFT(reg) (((reg) & PS_ESD_ESD_CFG_RESERVED1_MASK) >> PS_ESD_ESD_CFG_RESERVED1_SHIFT)
#define  PS_ESD_ESD_CFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_ESD_CFG_RESERVED1_MASK) | (((uint32_t)val) << PS_ESD_ESD_CFG_RESERVED1_SHIFT))

#define  PS_ESD_ESD_CFG_CHAN3_EN_MASK 0x10
#define  PS_ESD_ESD_CFG_CHAN3_EN_SHIFT 4
#define  PS_ESD_ESD_CFG_CHAN3_EN_MASK_SHIFT(reg) (((reg) & PS_ESD_ESD_CFG_CHAN3_EN_MASK) >> PS_ESD_ESD_CFG_CHAN3_EN_SHIFT)
#define  PS_ESD_ESD_CFG_CHAN3_EN_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_ESD_CFG_CHAN3_EN_MASK) | (((uint32_t)val) << PS_ESD_ESD_CFG_CHAN3_EN_SHIFT))

#define  PS_ESD_ESD_CFG_ESD_DIR_MASK 0x8
#define  PS_ESD_ESD_CFG_ESD_DIR_SHIFT 3
#define  PS_ESD_ESD_CFG_ESD_DIR_MASK_SHIFT(reg) (((reg) & PS_ESD_ESD_CFG_ESD_DIR_MASK) >> PS_ESD_ESD_CFG_ESD_DIR_SHIFT)
#define  PS_ESD_ESD_CFG_ESD_DIR_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_ESD_CFG_ESD_DIR_MASK) | (((uint32_t)val) << PS_ESD_ESD_CFG_ESD_DIR_SHIFT))

#define  PS_ESD_ESD_CFG_ACCUM_SIZE_MASK 0x6
#define  PS_ESD_ESD_CFG_ACCUM_SIZE_SHIFT 1
#define  PS_ESD_ESD_CFG_ACCUM_SIZE_MASK_SHIFT(reg) (((reg) & PS_ESD_ESD_CFG_ACCUM_SIZE_MASK) >> PS_ESD_ESD_CFG_ACCUM_SIZE_SHIFT)
#define  PS_ESD_ESD_CFG_ACCUM_SIZE_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_ESD_CFG_ACCUM_SIZE_MASK) | (((uint32_t)val) << PS_ESD_ESD_CFG_ACCUM_SIZE_SHIFT))

#define  PS_ESD_ESD_CFG_ENABLE_MASK 0x1
#define  PS_ESD_ESD_CFG_ENABLE_SHIFT 0
#define  PS_ESD_ESD_CFG_ENABLE_MASK_SHIFT(reg) (((reg) & PS_ESD_ESD_CFG_ENABLE_MASK) >> PS_ESD_ESD_CFG_ENABLE_SHIFT)
#define  PS_ESD_ESD_CFG_ENABLE_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_ESD_CFG_ENABLE_MASK) | (((uint32_t)val) << PS_ESD_ESD_CFG_ENABLE_SHIFT))

//====================================================================
//Register: ESD Start Address (ESD_START_0_R)
/** \brief Sets the pixel start address for the ESD accumulation region. If ESD_CFG.chan3_en is set, then ESD_START_0_R is the starting pixel address for the first sensor segment.*/
//====================================================================

#define  PS_ESD_ESD_START_0_R_RESERVED1_MASK 0xffff0000
#define  PS_ESD_ESD_START_0_R_RESERVED1_SHIFT 16
#define  PS_ESD_ESD_START_0_R_RESERVED1_MASK_SHIFT(reg) (((reg) & PS_ESD_ESD_START_0_R_RESERVED1_MASK) >> PS_ESD_ESD_START_0_R_RESERVED1_SHIFT)
#define  PS_ESD_ESD_START_0_R_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_ESD_START_0_R_RESERVED1_MASK) | (((uint32_t)val) << PS_ESD_ESD_START_0_R_RESERVED1_SHIFT))

#define  PS_ESD_ESD_START_0_R_ADDR_MASK 0xffff
#define  PS_ESD_ESD_START_0_R_ADDR_SHIFT 0
#define  PS_ESD_ESD_START_0_R_ADDR_MASK_SHIFT(reg) (((reg) & PS_ESD_ESD_START_0_R_ADDR_MASK) >> PS_ESD_ESD_START_0_R_ADDR_SHIFT)
#define  PS_ESD_ESD_START_0_R_ADDR_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_ESD_START_0_R_ADDR_MASK) | (((uint32_t)val) << PS_ESD_ESD_START_0_R_ADDR_SHIFT))

//====================================================================
//Register: ESD Start Address 1 (ESD_START_1_G)
/** \brief If ESD_CFG.chan3_en is set, sets the pixel start address for the ESD accumulation region for the second sensor segment.*/
//====================================================================

#define  PS_ESD_ESD_START_1_G_RESERVED1_MASK 0xffff0000
#define  PS_ESD_ESD_START_1_G_RESERVED1_SHIFT 16
#define  PS_ESD_ESD_START_1_G_RESERVED1_MASK_SHIFT(reg) (((reg) & PS_ESD_ESD_START_1_G_RESERVED1_MASK) >> PS_ESD_ESD_START_1_G_RESERVED1_SHIFT)
#define  PS_ESD_ESD_START_1_G_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_ESD_START_1_G_RESERVED1_MASK) | (((uint32_t)val) << PS_ESD_ESD_START_1_G_RESERVED1_SHIFT))

#define  PS_ESD_ESD_START_1_G_ADDR_MASK 0xffff
#define  PS_ESD_ESD_START_1_G_ADDR_SHIFT 0
#define  PS_ESD_ESD_START_1_G_ADDR_MASK_SHIFT(reg) (((reg) & PS_ESD_ESD_START_1_G_ADDR_MASK) >> PS_ESD_ESD_START_1_G_ADDR_SHIFT)
#define  PS_ESD_ESD_START_1_G_ADDR_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_ESD_START_1_G_ADDR_MASK) | (((uint32_t)val) << PS_ESD_ESD_START_1_G_ADDR_SHIFT))

//====================================================================
//Register: ESD Start Address 2 (ESD_START_2_B)
/** \brief If ESD_CFG.chan3_en is set, sets the pixel start address for the ESD accumulation region for the third sensor segment.*/
//====================================================================

#define  PS_ESD_ESD_START_2_B_RESERVED1_MASK 0xffff0000
#define  PS_ESD_ESD_START_2_B_RESERVED1_SHIFT 16
#define  PS_ESD_ESD_START_2_B_RESERVED1_MASK_SHIFT(reg) (((reg) & PS_ESD_ESD_START_2_B_RESERVED1_MASK) >> PS_ESD_ESD_START_2_B_RESERVED1_SHIFT)
#define  PS_ESD_ESD_START_2_B_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_ESD_START_2_B_RESERVED1_MASK) | (((uint32_t)val) << PS_ESD_ESD_START_2_B_RESERVED1_SHIFT))

#define  PS_ESD_ESD_START_2_B_ADDR_MASK 0xffff
#define  PS_ESD_ESD_START_2_B_ADDR_SHIFT 0
#define  PS_ESD_ESD_START_2_B_ADDR_MASK_SHIFT(reg) (((reg) & PS_ESD_ESD_START_2_B_ADDR_MASK) >> PS_ESD_ESD_START_2_B_ADDR_SHIFT)
#define  PS_ESD_ESD_START_2_B_ADDR_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_ESD_START_2_B_ADDR_MASK) | (((uint32_t)val) << PS_ESD_ESD_START_2_B_ADDR_SHIFT))

//====================================================================
//Register: ESD Tolerance (ESD_TOL)
/** \brief Sets the tolerance level for the ESD detection algorithm. ESD event is conditioned on the ABS(Line2 - Line0) being less than or equal to the Tolerance.*/
//====================================================================

#define  PS_ESD_ESD_TOL_RESERVED1_MASK 0xffffff00
#define  PS_ESD_ESD_TOL_RESERVED1_SHIFT 8
#define  PS_ESD_ESD_TOL_RESERVED1_MASK_SHIFT(reg) (((reg) & PS_ESD_ESD_TOL_RESERVED1_MASK) >> PS_ESD_ESD_TOL_RESERVED1_SHIFT)
#define  PS_ESD_ESD_TOL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_ESD_TOL_RESERVED1_MASK) | (((uint32_t)val) << PS_ESD_ESD_TOL_RESERVED1_SHIFT))

#define  PS_ESD_ESD_TOL_TOL_MASK 0xff
#define  PS_ESD_ESD_TOL_TOL_SHIFT 0
#define  PS_ESD_ESD_TOL_TOL_MASK_SHIFT(reg) (((reg) & PS_ESD_ESD_TOL_TOL_MASK) >> PS_ESD_ESD_TOL_TOL_SHIFT)
#define  PS_ESD_ESD_TOL_TOL_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_ESD_TOL_TOL_MASK) | (((uint32_t)val) << PS_ESD_ESD_TOL_TOL_SHIFT))

//====================================================================
//Register: ESD Change (ESD_CHG)
/** \brief Sets the change level for the ESD detection algorithm. If Line1 differs from the AVG(Line2 and Line0) by the ammount set in the change field, then a valid ESD event is flagged.*/
//====================================================================

#define  PS_ESD_ESD_CHG_RESERVED1_MASK 0xffffff00
#define  PS_ESD_ESD_CHG_RESERVED1_SHIFT 8
#define  PS_ESD_ESD_CHG_RESERVED1_MASK_SHIFT(reg) (((reg) & PS_ESD_ESD_CHG_RESERVED1_MASK) >> PS_ESD_ESD_CHG_RESERVED1_SHIFT)
#define  PS_ESD_ESD_CHG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_ESD_CHG_RESERVED1_MASK) | (((uint32_t)val) << PS_ESD_ESD_CHG_RESERVED1_SHIFT))

#define  PS_ESD_ESD_CHG_CHG_MASK 0xff
#define  PS_ESD_ESD_CHG_CHG_SHIFT 0
#define  PS_ESD_ESD_CHG_CHG_MASK_SHIFT(reg) (((reg) & PS_ESD_ESD_CHG_CHG_MASK) >> PS_ESD_ESD_CHG_CHG_SHIFT)
#define  PS_ESD_ESD_CHG_CHG_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_ESD_CHG_CHG_MASK) | (((uint32_t)val) << PS_ESD_ESD_CHG_CHG_SHIFT))

//====================================================================
//Register: ESD Color Reset (ESD_RST)
/** \brief Used to clear the internal ESD detection logic. One bit per color. Writing a '1' clears the color's accumulator and two previous value registers, clears the color's ESD event line number, and causes the color's state machine to wait for the next start of line to re-start monitoring.*/
//====================================================================

#define  PS_ESD_ESD_RST_RESERVED1_MASK 0xfffffff0
#define  PS_ESD_ESD_RST_RESERVED1_SHIFT 4
#define  PS_ESD_ESD_RST_RESERVED1_MASK_SHIFT(reg) (((reg) & PS_ESD_ESD_RST_RESERVED1_MASK) >> PS_ESD_ESD_RST_RESERVED1_SHIFT)
#define  PS_ESD_ESD_RST_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_ESD_RST_RESERVED1_MASK) | (((uint32_t)val) << PS_ESD_ESD_RST_RESERVED1_SHIFT))

#define  PS_ESD_ESD_RST_LCNT_MASK 0x8
#define  PS_ESD_ESD_RST_LCNT_SHIFT 3
#define  PS_ESD_ESD_RST_LCNT_MASK_SHIFT(reg) (((reg) & PS_ESD_ESD_RST_LCNT_MASK) >> PS_ESD_ESD_RST_LCNT_SHIFT)
#define  PS_ESD_ESD_RST_LCNT_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_ESD_RST_LCNT_MASK) | (((uint32_t)val) << PS_ESD_ESD_RST_LCNT_SHIFT))

#define  PS_ESD_ESD_RST_C2_MASK 0x4
#define  PS_ESD_ESD_RST_C2_SHIFT 2
#define  PS_ESD_ESD_RST_C2_MASK_SHIFT(reg) (((reg) & PS_ESD_ESD_RST_C2_MASK) >> PS_ESD_ESD_RST_C2_SHIFT)
#define  PS_ESD_ESD_RST_C2_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_ESD_RST_C2_MASK) | (((uint32_t)val) << PS_ESD_ESD_RST_C2_SHIFT))

#define  PS_ESD_ESD_RST_C1_MASK 0x2
#define  PS_ESD_ESD_RST_C1_SHIFT 1
#define  PS_ESD_ESD_RST_C1_MASK_SHIFT(reg) (((reg) & PS_ESD_ESD_RST_C1_MASK) >> PS_ESD_ESD_RST_C1_SHIFT)
#define  PS_ESD_ESD_RST_C1_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_ESD_RST_C1_MASK) | (((uint32_t)val) << PS_ESD_ESD_RST_C1_SHIFT))

#define  PS_ESD_ESD_RST_C0_MASK 0x1
#define  PS_ESD_ESD_RST_C0_SHIFT 0
#define  PS_ESD_ESD_RST_C0_MASK_SHIFT(reg) (((reg) & PS_ESD_ESD_RST_C0_MASK) >> PS_ESD_ESD_RST_C0_SHIFT)
#define  PS_ESD_ESD_RST_C0_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_ESD_RST_C0_MASK) | (((uint32_t)val) << PS_ESD_ESD_RST_C0_SHIFT))

//====================================================================
//Register: ESD Event Line Count Color0 (ESD_LCNT0)
/** \brief Provides the line number at which the ESD event was detected for color0. The line number is cleared when the color0 ESD interrupt is acknowledged.*/
//====================================================================

#define  PS_ESD_ESD_LCNT0_CRC_MASK 0x80000000
#define  PS_ESD_ESD_LCNT0_CRC_SHIFT 31
#define  PS_ESD_ESD_LCNT0_CRC_MASK_SHIFT(reg) (((reg) & PS_ESD_ESD_LCNT0_CRC_MASK) >> PS_ESD_ESD_LCNT0_CRC_SHIFT)
#define  PS_ESD_ESD_LCNT0_CRC_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_ESD_LCNT0_CRC_MASK) | (((uint32_t)val) << PS_ESD_ESD_LCNT0_CRC_SHIFT))

#define  PS_ESD_ESD_LCNT0_SEGS_MASK 0x70000000
#define  PS_ESD_ESD_LCNT0_SEGS_SHIFT 28
#define  PS_ESD_ESD_LCNT0_SEGS_MASK_SHIFT(reg) (((reg) & PS_ESD_ESD_LCNT0_SEGS_MASK) >> PS_ESD_ESD_LCNT0_SEGS_SHIFT)
#define  PS_ESD_ESD_LCNT0_SEGS_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_ESD_LCNT0_SEGS_MASK) | (((uint32_t)val) << PS_ESD_ESD_LCNT0_SEGS_SHIFT))

#define  PS_ESD_ESD_LCNT0_CNT_MASK 0xfffffff
#define  PS_ESD_ESD_LCNT0_CNT_SHIFT 0
#define  PS_ESD_ESD_LCNT0_CNT_MASK_SHIFT(reg) (((reg) & PS_ESD_ESD_LCNT0_CNT_MASK) >> PS_ESD_ESD_LCNT0_CNT_SHIFT)
#define  PS_ESD_ESD_LCNT0_CNT_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_ESD_LCNT0_CNT_MASK) | (((uint32_t)val) << PS_ESD_ESD_LCNT0_CNT_SHIFT))

//====================================================================
//Register: ESD Event Line Count Color1 (ESD_LCNT1)
/** \brief Provides the line number at which the ESD event was detected for color1. The line number is cleared when the color1 ESD interrupt is acknowledged.*/
//====================================================================

#define  PS_ESD_ESD_LCNT1_CRC_MASK 0x80000000
#define  PS_ESD_ESD_LCNT1_CRC_SHIFT 31
#define  PS_ESD_ESD_LCNT1_CRC_MASK_SHIFT(reg) (((reg) & PS_ESD_ESD_LCNT1_CRC_MASK) >> PS_ESD_ESD_LCNT1_CRC_SHIFT)
#define  PS_ESD_ESD_LCNT1_CRC_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_ESD_LCNT1_CRC_MASK) | (((uint32_t)val) << PS_ESD_ESD_LCNT1_CRC_SHIFT))

#define  PS_ESD_ESD_LCNT1_SEGS_MASK 0x70000000
#define  PS_ESD_ESD_LCNT1_SEGS_SHIFT 28
#define  PS_ESD_ESD_LCNT1_SEGS_MASK_SHIFT(reg) (((reg) & PS_ESD_ESD_LCNT1_SEGS_MASK) >> PS_ESD_ESD_LCNT1_SEGS_SHIFT)
#define  PS_ESD_ESD_LCNT1_SEGS_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_ESD_LCNT1_SEGS_MASK) | (((uint32_t)val) << PS_ESD_ESD_LCNT1_SEGS_SHIFT))

#define  PS_ESD_ESD_LCNT1_CNT_MASK 0xfffffff
#define  PS_ESD_ESD_LCNT1_CNT_SHIFT 0
#define  PS_ESD_ESD_LCNT1_CNT_MASK_SHIFT(reg) (((reg) & PS_ESD_ESD_LCNT1_CNT_MASK) >> PS_ESD_ESD_LCNT1_CNT_SHIFT)
#define  PS_ESD_ESD_LCNT1_CNT_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_ESD_LCNT1_CNT_MASK) | (((uint32_t)val) << PS_ESD_ESD_LCNT1_CNT_SHIFT))

//====================================================================
//Register: ESD Event Line Count Color2 (ESD_LCNT2)
/** \brief Provides the line number at which the ESD event was detected for color2. The line number is cleared when the color2 ESD interrupt is acknowledged.*/
//====================================================================

#define  PS_ESD_ESD_LCNT2_CRC_MASK 0x80000000
#define  PS_ESD_ESD_LCNT2_CRC_SHIFT 31
#define  PS_ESD_ESD_LCNT2_CRC_MASK_SHIFT(reg) (((reg) & PS_ESD_ESD_LCNT2_CRC_MASK) >> PS_ESD_ESD_LCNT2_CRC_SHIFT)
#define  PS_ESD_ESD_LCNT2_CRC_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_ESD_LCNT2_CRC_MASK) | (((uint32_t)val) << PS_ESD_ESD_LCNT2_CRC_SHIFT))

#define  PS_ESD_ESD_LCNT2_SEGS_MASK 0x70000000
#define  PS_ESD_ESD_LCNT2_SEGS_SHIFT 28
#define  PS_ESD_ESD_LCNT2_SEGS_MASK_SHIFT(reg) (((reg) & PS_ESD_ESD_LCNT2_SEGS_MASK) >> PS_ESD_ESD_LCNT2_SEGS_SHIFT)
#define  PS_ESD_ESD_LCNT2_SEGS_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_ESD_LCNT2_SEGS_MASK) | (((uint32_t)val) << PS_ESD_ESD_LCNT2_SEGS_SHIFT))

#define  PS_ESD_ESD_LCNT2_CNT_MASK 0xfffffff
#define  PS_ESD_ESD_LCNT2_CNT_SHIFT 0
#define  PS_ESD_ESD_LCNT2_CNT_MASK_SHIFT(reg) (((reg) & PS_ESD_ESD_LCNT2_CNT_MASK) >> PS_ESD_ESD_LCNT2_CNT_SHIFT)
#define  PS_ESD_ESD_LCNT2_CNT_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_ESD_LCNT2_CNT_MASK) | (((uint32_t)val) << PS_ESD_ESD_LCNT2_CNT_SHIFT))

//====================================================================
//Register: PageSense Configuration (PS_CFG)
/** \brief Overall configuration register for PageSense detection logic.*/
//====================================================================

#define  PS_ESD_PS_CFG_RESERVED1_MASK 0xfffffc00
#define  PS_ESD_PS_CFG_RESERVED1_SHIFT 10
#define  PS_ESD_PS_CFG_RESERVED1_MASK_SHIFT(reg) (((reg) & PS_ESD_PS_CFG_RESERVED1_MASK) >> PS_ESD_PS_CFG_RESERVED1_SHIFT)
#define  PS_ESD_PS_CFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_PS_CFG_RESERVED1_MASK) | (((uint32_t)val) << PS_ESD_PS_CFG_RESERVED1_SHIFT))

#define  PS_ESD_PS_CFG_RES_AVG_MASK 0x300
#define  PS_ESD_PS_CFG_RES_AVG_SHIFT 8
#define  PS_ESD_PS_CFG_RES_AVG_MASK_SHIFT(reg) (((reg) & PS_ESD_PS_CFG_RES_AVG_MASK) >> PS_ESD_PS_CFG_RES_AVG_SHIFT)
#define  PS_ESD_PS_CFG_RES_AVG_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_PS_CFG_RES_AVG_MASK) | (((uint32_t)val) << PS_ESD_PS_CFG_RES_AVG_SHIFT))

#define  PS_ESD_PS_CFG_RESERVED2_MASK 0x80
#define  PS_ESD_PS_CFG_RESERVED2_SHIFT 7
#define  PS_ESD_PS_CFG_RESERVED2_MASK_SHIFT(reg) (((reg) & PS_ESD_PS_CFG_RESERVED2_MASK) >> PS_ESD_PS_CFG_RESERVED2_SHIFT)
#define  PS_ESD_PS_CFG_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_PS_CFG_RESERVED2_MASK) | (((uint32_t)val) << PS_ESD_PS_CFG_RESERVED2_SHIFT))

#define  PS_ESD_PS_CFG_CHAN_EN_MASK 0x70
#define  PS_ESD_PS_CFG_CHAN_EN_SHIFT 4
#define  PS_ESD_PS_CFG_CHAN_EN_MASK_SHIFT(reg) (((reg) & PS_ESD_PS_CFG_CHAN_EN_MASK) >> PS_ESD_PS_CFG_CHAN_EN_SHIFT)
#define  PS_ESD_PS_CFG_CHAN_EN_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_PS_CFG_CHAN_EN_MASK) | (((uint32_t)val) << PS_ESD_PS_CFG_CHAN_EN_SHIFT))

#define  PS_ESD_PS_CFG_RESERVED3_MASK 0x8
#define  PS_ESD_PS_CFG_RESERVED3_SHIFT 3
#define  PS_ESD_PS_CFG_RESERVED3_MASK_SHIFT(reg) (((reg) & PS_ESD_PS_CFG_RESERVED3_MASK) >> PS_ESD_PS_CFG_RESERVED3_SHIFT)
#define  PS_ESD_PS_CFG_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_PS_CFG_RESERVED3_MASK) | (((uint32_t)val) << PS_ESD_PS_CFG_RESERVED3_SHIFT))

#define  PS_ESD_PS_CFG_TOF_NBOF_MASK 0x4
#define  PS_ESD_PS_CFG_TOF_NBOF_SHIFT 2
#define  PS_ESD_PS_CFG_TOF_NBOF_MASK_SHIFT(reg) (((reg) & PS_ESD_PS_CFG_TOF_NBOF_MASK) >> PS_ESD_PS_CFG_TOF_NBOF_SHIFT)
#define  PS_ESD_PS_CFG_TOF_NBOF_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_PS_CFG_TOF_NBOF_MASK) | (((uint32_t)val) << PS_ESD_PS_CFG_TOF_NBOF_SHIFT))

#define  PS_ESD_PS_CFG_START_BIT_MASK 0x2
#define  PS_ESD_PS_CFG_START_BIT_SHIFT 1
#define  PS_ESD_PS_CFG_START_BIT_MASK_SHIFT(reg) (((reg) & PS_ESD_PS_CFG_START_BIT_MASK) >> PS_ESD_PS_CFG_START_BIT_SHIFT)
#define  PS_ESD_PS_CFG_START_BIT_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_PS_CFG_START_BIT_MASK) | (((uint32_t)val) << PS_ESD_PS_CFG_START_BIT_SHIFT))

#define  PS_ESD_PS_CFG_COLOR_MODE_MASK 0x1
#define  PS_ESD_PS_CFG_COLOR_MODE_SHIFT 0
#define  PS_ESD_PS_CFG_COLOR_MODE_MASK_SHIFT(reg) (((reg) & PS_ESD_PS_CFG_COLOR_MODE_MASK) >> PS_ESD_PS_CFG_COLOR_MODE_SHIFT)
#define  PS_ESD_PS_CFG_COLOR_MODE_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_PS_CFG_COLOR_MODE_MASK) | (((uint32_t)val) << PS_ESD_PS_CFG_COLOR_MODE_SHIFT))

//====================================================================
//Register: PageSense Go (PS_GO)
/** \brief Primes the PageSense logic and causes it to begin searching for TOF or BOF.*/
//====================================================================

#define  PS_ESD_PS_GO_RESERVED1_MASK 0xfffffffe
#define  PS_ESD_PS_GO_RESERVED1_SHIFT 1
#define  PS_ESD_PS_GO_RESERVED1_MASK_SHIFT(reg) (((reg) & PS_ESD_PS_GO_RESERVED1_MASK) >> PS_ESD_PS_GO_RESERVED1_SHIFT)
#define  PS_ESD_PS_GO_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_PS_GO_RESERVED1_MASK) | (((uint32_t)val) << PS_ESD_PS_GO_RESERVED1_SHIFT))

#define  PS_ESD_PS_GO_GO_MASK 0x1
#define  PS_ESD_PS_GO_GO_SHIFT 0
#define  PS_ESD_PS_GO_GO_MASK_SHIFT(reg) (((reg) & PS_ESD_PS_GO_GO_MASK) >> PS_ESD_PS_GO_GO_SHIFT)
#define  PS_ESD_PS_GO_GO_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_PS_GO_GO_MASK) | (((uint32_t)val) << PS_ESD_PS_GO_GO_SHIFT))

//====================================================================
//Register: PageSense Start Pixel (PS_START)
/** \brief Sets the pixel number within a row where PageSense detection begins. Note that this is prior to the resolution reduction down to 300dpi.*/
//====================================================================

#define  PS_ESD_PS_START_RESERVED1_MASK 0xffff0000
#define  PS_ESD_PS_START_RESERVED1_SHIFT 16
#define  PS_ESD_PS_START_RESERVED1_MASK_SHIFT(reg) (((reg) & PS_ESD_PS_START_RESERVED1_MASK) >> PS_ESD_PS_START_RESERVED1_SHIFT)
#define  PS_ESD_PS_START_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_PS_START_RESERVED1_MASK) | (((uint32_t)val) << PS_ESD_PS_START_RESERVED1_SHIFT))

#define  PS_ESD_PS_START_START_PIX_MASK 0xffff
#define  PS_ESD_PS_START_START_PIX_SHIFT 0
#define  PS_ESD_PS_START_START_PIX_MASK_SHIFT(reg) (((reg) & PS_ESD_PS_START_START_PIX_MASK) >> PS_ESD_PS_START_START_PIX_SHIFT)
#define  PS_ESD_PS_START_START_PIX_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_PS_START_START_PIX_MASK) | (((uint32_t)val) << PS_ESD_PS_START_START_PIX_SHIFT))

//====================================================================
//Register: PageSense Region Widths 0 (PS_WIDTH0)
/** \brief Configures the widths (at 300dpi) for the each of the detection regions. This register configures regions 0-3.*/
//====================================================================

#define  PS_ESD_PS_WIDTH0_REGION3_MASK 0xff000000
#define  PS_ESD_PS_WIDTH0_REGION3_SHIFT 24
#define  PS_ESD_PS_WIDTH0_REGION3_MASK_SHIFT(reg) (((reg) & PS_ESD_PS_WIDTH0_REGION3_MASK) >> PS_ESD_PS_WIDTH0_REGION3_SHIFT)
#define  PS_ESD_PS_WIDTH0_REGION3_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_PS_WIDTH0_REGION3_MASK) | (((uint32_t)val) << PS_ESD_PS_WIDTH0_REGION3_SHIFT))

#define  PS_ESD_PS_WIDTH0_REGION2_MASK 0xff0000
#define  PS_ESD_PS_WIDTH0_REGION2_SHIFT 16
#define  PS_ESD_PS_WIDTH0_REGION2_MASK_SHIFT(reg) (((reg) & PS_ESD_PS_WIDTH0_REGION2_MASK) >> PS_ESD_PS_WIDTH0_REGION2_SHIFT)
#define  PS_ESD_PS_WIDTH0_REGION2_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_PS_WIDTH0_REGION2_MASK) | (((uint32_t)val) << PS_ESD_PS_WIDTH0_REGION2_SHIFT))

#define  PS_ESD_PS_WIDTH0_REGION1_MASK 0xff00
#define  PS_ESD_PS_WIDTH0_REGION1_SHIFT 8
#define  PS_ESD_PS_WIDTH0_REGION1_MASK_SHIFT(reg) (((reg) & PS_ESD_PS_WIDTH0_REGION1_MASK) >> PS_ESD_PS_WIDTH0_REGION1_SHIFT)
#define  PS_ESD_PS_WIDTH0_REGION1_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_PS_WIDTH0_REGION1_MASK) | (((uint32_t)val) << PS_ESD_PS_WIDTH0_REGION1_SHIFT))

#define  PS_ESD_PS_WIDTH0_REGION0_MASK 0xff
#define  PS_ESD_PS_WIDTH0_REGION0_SHIFT 0
#define  PS_ESD_PS_WIDTH0_REGION0_MASK_SHIFT(reg) (((reg) & PS_ESD_PS_WIDTH0_REGION0_MASK) >> PS_ESD_PS_WIDTH0_REGION0_SHIFT)
#define  PS_ESD_PS_WIDTH0_REGION0_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_PS_WIDTH0_REGION0_MASK) | (((uint32_t)val) << PS_ESD_PS_WIDTH0_REGION0_SHIFT))

//====================================================================
//Register: PageSense Region Widths 1 (PS_WIDTH1)
/** \brief Configures the widths (at 300dpi) for the each of the detection regions. This register configures regions 0-3.*/
//====================================================================

#define  PS_ESD_PS_WIDTH1_REGION7_MASK 0xff000000
#define  PS_ESD_PS_WIDTH1_REGION7_SHIFT 24
#define  PS_ESD_PS_WIDTH1_REGION7_MASK_SHIFT(reg) (((reg) & PS_ESD_PS_WIDTH1_REGION7_MASK) >> PS_ESD_PS_WIDTH1_REGION7_SHIFT)
#define  PS_ESD_PS_WIDTH1_REGION7_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_PS_WIDTH1_REGION7_MASK) | (((uint32_t)val) << PS_ESD_PS_WIDTH1_REGION7_SHIFT))

#define  PS_ESD_PS_WIDTH1_REGION6_MASK 0xff0000
#define  PS_ESD_PS_WIDTH1_REGION6_SHIFT 16
#define  PS_ESD_PS_WIDTH1_REGION6_MASK_SHIFT(reg) (((reg) & PS_ESD_PS_WIDTH1_REGION6_MASK) >> PS_ESD_PS_WIDTH1_REGION6_SHIFT)
#define  PS_ESD_PS_WIDTH1_REGION6_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_PS_WIDTH1_REGION6_MASK) | (((uint32_t)val) << PS_ESD_PS_WIDTH1_REGION6_SHIFT))

#define  PS_ESD_PS_WIDTH1_REGION5_MASK 0xff00
#define  PS_ESD_PS_WIDTH1_REGION5_SHIFT 8
#define  PS_ESD_PS_WIDTH1_REGION5_MASK_SHIFT(reg) (((reg) & PS_ESD_PS_WIDTH1_REGION5_MASK) >> PS_ESD_PS_WIDTH1_REGION5_SHIFT)
#define  PS_ESD_PS_WIDTH1_REGION5_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_PS_WIDTH1_REGION5_MASK) | (((uint32_t)val) << PS_ESD_PS_WIDTH1_REGION5_SHIFT))

#define  PS_ESD_PS_WIDTH1_REGION4_MASK 0xff
#define  PS_ESD_PS_WIDTH1_REGION4_SHIFT 0
#define  PS_ESD_PS_WIDTH1_REGION4_MASK_SHIFT(reg) (((reg) & PS_ESD_PS_WIDTH1_REGION4_MASK) >> PS_ESD_PS_WIDTH1_REGION4_SHIFT)
#define  PS_ESD_PS_WIDTH1_REGION4_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_PS_WIDTH1_REGION4_MASK) | (((uint32_t)val) << PS_ESD_PS_WIDTH1_REGION4_SHIFT))

//====================================================================
//Register: PageSense Region Tolerance (PS_TOL)
/** \brief Used to configure the region width tolerances (+/- from values programmed in PS_WIDTH0/PS_WIDTH1)*/
//====================================================================

#define  PS_ESD_PS_TOL_RESERVED1_MASK 0xffffc000
#define  PS_ESD_PS_TOL_RESERVED1_SHIFT 14
#define  PS_ESD_PS_TOL_RESERVED1_MASK_SHIFT(reg) (((reg) & PS_ESD_PS_TOL_RESERVED1_MASK) >> PS_ESD_PS_TOL_RESERVED1_SHIFT)
#define  PS_ESD_PS_TOL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_PS_TOL_RESERVED1_MASK) | (((uint32_t)val) << PS_ESD_PS_TOL_RESERVED1_SHIFT))

#define  PS_ESD_PS_TOL_TOTAL_TOL_MASK 0x3f00
#define  PS_ESD_PS_TOL_TOTAL_TOL_SHIFT 8
#define  PS_ESD_PS_TOL_TOTAL_TOL_MASK_SHIFT(reg) (((reg) & PS_ESD_PS_TOL_TOTAL_TOL_MASK) >> PS_ESD_PS_TOL_TOTAL_TOL_SHIFT)
#define  PS_ESD_PS_TOL_TOTAL_TOL_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_PS_TOL_TOTAL_TOL_MASK) | (((uint32_t)val) << PS_ESD_PS_TOL_TOTAL_TOL_SHIFT))

#define  PS_ESD_PS_TOL_RESERVED2_MASK 0xc0
#define  PS_ESD_PS_TOL_RESERVED2_SHIFT 6
#define  PS_ESD_PS_TOL_RESERVED2_MASK_SHIFT(reg) (((reg) & PS_ESD_PS_TOL_RESERVED2_MASK) >> PS_ESD_PS_TOL_RESERVED2_SHIFT)
#define  PS_ESD_PS_TOL_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_PS_TOL_RESERVED2_MASK) | (((uint32_t)val) << PS_ESD_PS_TOL_RESERVED2_SHIFT))

#define  PS_ESD_PS_TOL_REG_TOL_MASK 0x3f
#define  PS_ESD_PS_TOL_REG_TOL_SHIFT 0
#define  PS_ESD_PS_TOL_REG_TOL_MASK_SHIFT(reg) (((reg) & PS_ESD_PS_TOL_REG_TOL_MASK) >> PS_ESD_PS_TOL_REG_TOL_SHIFT)
#define  PS_ESD_PS_TOL_REG_TOL_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_PS_TOL_REG_TOL_MASK) | (((uint32_t)val) << PS_ESD_PS_TOL_REG_TOL_SHIFT))

//====================================================================
//Register: PageSense Overall Width (PS_TOTAL_WID)
/** \brief Used to configure the overall width of regions 1-7. Should be programmed with the sum of the regions PS_WIDTH0.region1 through PS_WIDTH1.region7.*/
//====================================================================

#define  PS_ESD_PS_TOTAL_WID_RESERVED1_MASK 0xfffff800
#define  PS_ESD_PS_TOTAL_WID_RESERVED1_SHIFT 11
#define  PS_ESD_PS_TOTAL_WID_RESERVED1_MASK_SHIFT(reg) (((reg) & PS_ESD_PS_TOTAL_WID_RESERVED1_MASK) >> PS_ESD_PS_TOTAL_WID_RESERVED1_SHIFT)
#define  PS_ESD_PS_TOTAL_WID_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_PS_TOTAL_WID_RESERVED1_MASK) | (((uint32_t)val) << PS_ESD_PS_TOTAL_WID_RESERVED1_SHIFT))

#define  PS_ESD_PS_TOTAL_WID_TOTAL_WID_MASK 0x7ff
#define  PS_ESD_PS_TOTAL_WID_TOTAL_WID_SHIFT 0
#define  PS_ESD_PS_TOTAL_WID_TOTAL_WID_MASK_SHIFT(reg) (((reg) & PS_ESD_PS_TOTAL_WID_TOTAL_WID_MASK) >> PS_ESD_PS_TOTAL_WID_TOTAL_WID_SHIFT)
#define  PS_ESD_PS_TOTAL_WID_TOTAL_WID_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_PS_TOTAL_WID_TOTAL_WID_MASK) | (((uint32_t)val) << PS_ESD_PS_TOTAL_WID_TOTAL_WID_SHIFT))

//====================================================================
//Register: PageSense Toggle Delta (PS_TOGGLE)
/** \brief Used to configure the deltas required to toggle between the dark and light regions.*/
//====================================================================

#define  PS_ESD_PS_TOGGLE_RESERVED1_MASK 0xffff0000
#define  PS_ESD_PS_TOGGLE_RESERVED1_SHIFT 16
#define  PS_ESD_PS_TOGGLE_RESERVED1_MASK_SHIFT(reg) (((reg) & PS_ESD_PS_TOGGLE_RESERVED1_MASK) >> PS_ESD_PS_TOGGLE_RESERVED1_SHIFT)
#define  PS_ESD_PS_TOGGLE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_PS_TOGGLE_RESERVED1_MASK) | (((uint32_t)val) << PS_ESD_PS_TOGGLE_RESERVED1_SHIFT))

#define  PS_ESD_PS_TOGGLE_TOGGLE10_MASK 0xff00
#define  PS_ESD_PS_TOGGLE_TOGGLE10_SHIFT 8
#define  PS_ESD_PS_TOGGLE_TOGGLE10_MASK_SHIFT(reg) (((reg) & PS_ESD_PS_TOGGLE_TOGGLE10_MASK) >> PS_ESD_PS_TOGGLE_TOGGLE10_SHIFT)
#define  PS_ESD_PS_TOGGLE_TOGGLE10_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_PS_TOGGLE_TOGGLE10_MASK) | (((uint32_t)val) << PS_ESD_PS_TOGGLE_TOGGLE10_SHIFT))

#define  PS_ESD_PS_TOGGLE_TOGGLE01_MASK 0xff
#define  PS_ESD_PS_TOGGLE_TOGGLE01_SHIFT 0
#define  PS_ESD_PS_TOGGLE_TOGGLE01_MASK_SHIFT(reg) (((reg) & PS_ESD_PS_TOGGLE_TOGGLE01_MASK) >> PS_ESD_PS_TOGGLE_TOGGLE01_SHIFT)
#define  PS_ESD_PS_TOGGLE_TOGGLE01_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_PS_TOGGLE_TOGGLE01_MASK) | (((uint32_t)val) << PS_ESD_PS_TOGGLE_TOGGLE01_SHIFT))

//====================================================================
//Register: PageSense Count (PS_CNT)
/** \brief Used to configure the number of detects required for a positive pattern match.*/
//====================================================================

#define  PS_ESD_PS_CNT_RESERVED1_MASK 0xffffff80
#define  PS_ESD_PS_CNT_RESERVED1_SHIFT 7
#define  PS_ESD_PS_CNT_RESERVED1_MASK_SHIFT(reg) (((reg) & PS_ESD_PS_CNT_RESERVED1_MASK) >> PS_ESD_PS_CNT_RESERVED1_SHIFT)
#define  PS_ESD_PS_CNT_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_PS_CNT_RESERVED1_MASK) | (((uint32_t)val) << PS_ESD_PS_CNT_RESERVED1_SHIFT))

#define  PS_ESD_PS_CNT_COUNT1_MASK 0x70
#define  PS_ESD_PS_CNT_COUNT1_SHIFT 4
#define  PS_ESD_PS_CNT_COUNT1_MASK_SHIFT(reg) (((reg) & PS_ESD_PS_CNT_COUNT1_MASK) >> PS_ESD_PS_CNT_COUNT1_SHIFT)
#define  PS_ESD_PS_CNT_COUNT1_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_PS_CNT_COUNT1_MASK) | (((uint32_t)val) << PS_ESD_PS_CNT_COUNT1_SHIFT))

#define  PS_ESD_PS_CNT_RESERVED2_MASK 0x8
#define  PS_ESD_PS_CNT_RESERVED2_SHIFT 3
#define  PS_ESD_PS_CNT_RESERVED2_MASK_SHIFT(reg) (((reg) & PS_ESD_PS_CNT_RESERVED2_MASK) >> PS_ESD_PS_CNT_RESERVED2_SHIFT)
#define  PS_ESD_PS_CNT_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_PS_CNT_RESERVED2_MASK) | (((uint32_t)val) << PS_ESD_PS_CNT_RESERVED2_SHIFT))

#define  PS_ESD_PS_CNT_COUNT0_MASK 0x7
#define  PS_ESD_PS_CNT_COUNT0_SHIFT 0
#define  PS_ESD_PS_CNT_COUNT0_MASK_SHIFT(reg) (((reg) & PS_ESD_PS_CNT_COUNT0_MASK) >> PS_ESD_PS_CNT_COUNT0_SHIFT)
#define  PS_ESD_PS_CNT_COUNT0_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_PS_CNT_COUNT0_MASK) | (((uint32_t)val) << PS_ESD_PS_CNT_COUNT0_SHIFT))

//====================================================================
//Register: PageSense Detect Line Count (PS_LCNT)
/** \brief Provides the line number at which the TOF/BOF event was detected. Cleared when PS_GO is written.*/
//====================================================================

#define  PS_ESD_PS_LCNT_VALID_MASK 0x80000000
#define  PS_ESD_PS_LCNT_VALID_SHIFT 31
#define  PS_ESD_PS_LCNT_VALID_MASK_SHIFT(reg) (((reg) & PS_ESD_PS_LCNT_VALID_MASK) >> PS_ESD_PS_LCNT_VALID_SHIFT)
#define  PS_ESD_PS_LCNT_VALID_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_PS_LCNT_VALID_MASK) | (((uint32_t)val) << PS_ESD_PS_LCNT_VALID_SHIFT))

#define  PS_ESD_PS_LCNT_RESERVED1_MASK 0x70000000
#define  PS_ESD_PS_LCNT_RESERVED1_SHIFT 28
#define  PS_ESD_PS_LCNT_RESERVED1_MASK_SHIFT(reg) (((reg) & PS_ESD_PS_LCNT_RESERVED1_MASK) >> PS_ESD_PS_LCNT_RESERVED1_SHIFT)
#define  PS_ESD_PS_LCNT_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_PS_LCNT_RESERVED1_MASK) | (((uint32_t)val) << PS_ESD_PS_LCNT_RESERVED1_SHIFT))

#define  PS_ESD_PS_LCNT_CNT_MASK 0xfffffff
#define  PS_ESD_PS_LCNT_CNT_SHIFT 0
#define  PS_ESD_PS_LCNT_CNT_MASK_SHIFT(reg) (((reg) & PS_ESD_PS_LCNT_CNT_MASK) >> PS_ESD_PS_LCNT_CNT_SHIFT)
#define  PS_ESD_PS_LCNT_CNT_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_PS_LCNT_CNT_MASK) | (((uint32_t)val) << PS_ESD_PS_LCNT_CNT_SHIFT))

//====================================================================
//Register: PageSense Filter Capture (PS_FILT)
/** \brief Provides the filter values that are captured when the PageSense interrupt fires. Cleared when PS_GO is written*/
//====================================================================

#define  PS_ESD_PS_FILT_VALID_MASK 0x80000000
#define  PS_ESD_PS_FILT_VALID_SHIFT 31
#define  PS_ESD_PS_FILT_VALID_MASK_SHIFT(reg) (((reg) & PS_ESD_PS_FILT_VALID_MASK) >> PS_ESD_PS_FILT_VALID_SHIFT)
#define  PS_ESD_PS_FILT_VALID_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_PS_FILT_VALID_MASK) | (((uint32_t)val) << PS_ESD_PS_FILT_VALID_SHIFT))

#define  PS_ESD_PS_FILT_RESERVED1_MASK 0x7fffff00
#define  PS_ESD_PS_FILT_RESERVED1_SHIFT 8
#define  PS_ESD_PS_FILT_RESERVED1_MASK_SHIFT(reg) (((reg) & PS_ESD_PS_FILT_RESERVED1_MASK) >> PS_ESD_PS_FILT_RESERVED1_SHIFT)
#define  PS_ESD_PS_FILT_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_PS_FILT_RESERVED1_MASK) | (((uint32_t)val) << PS_ESD_PS_FILT_RESERVED1_SHIFT))

#define  PS_ESD_PS_FILT_FILTER_MASK 0xff
#define  PS_ESD_PS_FILT_FILTER_SHIFT 0
#define  PS_ESD_PS_FILT_FILTER_MASK_SHIFT(reg) (((reg) & PS_ESD_PS_FILT_FILTER_MASK) >> PS_ESD_PS_FILT_FILTER_SHIFT)
#define  PS_ESD_PS_FILT_FILTER_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_PS_FILT_FILTER_MASK) | (((uint32_t)val) << PS_ESD_PS_FILT_FILTER_SHIFT))

//====================================================================
//Register: PageSense Status (PS_STAT)
/** \brief Provides read only status information for the PageSense function.*/
//====================================================================

#define  PS_ESD_PS_STAT_RESERVED1_MASK 0xfffffffe
#define  PS_ESD_PS_STAT_RESERVED1_SHIFT 1
#define  PS_ESD_PS_STAT_RESERVED1_MASK_SHIFT(reg) (((reg) & PS_ESD_PS_STAT_RESERVED1_MASK) >> PS_ESD_PS_STAT_RESERVED1_SHIFT)
#define  PS_ESD_PS_STAT_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_PS_STAT_RESERVED1_MASK) | (((uint32_t)val) << PS_ESD_PS_STAT_RESERVED1_SHIFT))

#define  PS_ESD_PS_STAT_BUSY_MASK 0x1
#define  PS_ESD_PS_STAT_BUSY_SHIFT 0
#define  PS_ESD_PS_STAT_BUSY_MASK_SHIFT(reg) (((reg) & PS_ESD_PS_STAT_BUSY_MASK) >> PS_ESD_PS_STAT_BUSY_SHIFT)
#define  PS_ESD_PS_STAT_BUSY_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_PS_STAT_BUSY_MASK) | (((uint32_t)val) << PS_ESD_PS_STAT_BUSY_SHIFT))

//====================================================================
//Register: Line Counter (LCNT)
/** \brief Provides the current value of the internal line counter.*/
//====================================================================

#define  PS_ESD_LCNT_CT_MASK 0xc0000000
#define  PS_ESD_LCNT_CT_SHIFT 30
#define  PS_ESD_LCNT_CT_MASK_SHIFT(reg) (((reg) & PS_ESD_LCNT_CT_MASK) >> PS_ESD_LCNT_CT_SHIFT)
#define  PS_ESD_LCNT_CT_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_LCNT_CT_MASK) | (((uint32_t)val) << PS_ESD_LCNT_CT_SHIFT))

#define  PS_ESD_LCNT_RESERVED1_MASK 0x30000000
#define  PS_ESD_LCNT_RESERVED1_SHIFT 28
#define  PS_ESD_LCNT_RESERVED1_MASK_SHIFT(reg) (((reg) & PS_ESD_LCNT_RESERVED1_MASK) >> PS_ESD_LCNT_RESERVED1_SHIFT)
#define  PS_ESD_LCNT_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_LCNT_RESERVED1_MASK) | (((uint32_t)val) << PS_ESD_LCNT_RESERVED1_SHIFT))

#define  PS_ESD_LCNT_CNT_MASK 0xfffffff
#define  PS_ESD_LCNT_CNT_SHIFT 0
#define  PS_ESD_LCNT_CNT_MASK_SHIFT(reg) (((reg) & PS_ESD_LCNT_CNT_MASK) >> PS_ESD_LCNT_CNT_SHIFT)
#define  PS_ESD_LCNT_CNT_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_LCNT_CNT_MASK) | (((uint32_t)val) << PS_ESD_LCNT_CNT_SHIFT))

//====================================================================
//Register: Line Counter (LCNT_WR)
/** \brief Allows the current value of the internal line counter to be written by firmware.*/
//====================================================================

#define  PS_ESD_LCNT_WR_CT_MASK 0xc0000000
#define  PS_ESD_LCNT_WR_CT_SHIFT 30
#define  PS_ESD_LCNT_WR_CT_MASK_SHIFT(reg) (((reg) & PS_ESD_LCNT_WR_CT_MASK) >> PS_ESD_LCNT_WR_CT_SHIFT)
#define  PS_ESD_LCNT_WR_CT_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_LCNT_WR_CT_MASK) | (((uint32_t)val) << PS_ESD_LCNT_WR_CT_SHIFT))

#define  PS_ESD_LCNT_WR_RESERVED1_MASK 0x30000000
#define  PS_ESD_LCNT_WR_RESERVED1_SHIFT 28
#define  PS_ESD_LCNT_WR_RESERVED1_MASK_SHIFT(reg) (((reg) & PS_ESD_LCNT_WR_RESERVED1_MASK) >> PS_ESD_LCNT_WR_RESERVED1_SHIFT)
#define  PS_ESD_LCNT_WR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_LCNT_WR_RESERVED1_MASK) | (((uint32_t)val) << PS_ESD_LCNT_WR_RESERVED1_SHIFT))

#define  PS_ESD_LCNT_WR_CNT_MASK 0xfffffff
#define  PS_ESD_LCNT_WR_CNT_SHIFT 0
#define  PS_ESD_LCNT_WR_CNT_MASK_SHIFT(reg) (((reg) & PS_ESD_LCNT_WR_CNT_MASK) >> PS_ESD_LCNT_WR_CNT_SHIFT)
#define  PS_ESD_LCNT_WR_CNT_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_LCNT_WR_CNT_MASK) | (((uint32_t)val) << PS_ESD_LCNT_WR_CNT_SHIFT))

//====================================================================
//Register: Interrupt Enable Register (IEN)
/** \brief Interrupt Enable.*/
//====================================================================

#define  PS_ESD_IEN_RESERVED1_MASK 0xfffffff0
#define  PS_ESD_IEN_RESERVED1_SHIFT 4
#define  PS_ESD_IEN_RESERVED1_MASK_SHIFT(reg) (((reg) & PS_ESD_IEN_RESERVED1_MASK) >> PS_ESD_IEN_RESERVED1_SHIFT)
#define  PS_ESD_IEN_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_IEN_RESERVED1_MASK) | (((uint32_t)val) << PS_ESD_IEN_RESERVED1_SHIFT))

#define  PS_ESD_IEN_PSENSE_MASK 0x8
#define  PS_ESD_IEN_PSENSE_SHIFT 3
#define  PS_ESD_IEN_PSENSE_MASK_SHIFT(reg) (((reg) & PS_ESD_IEN_PSENSE_MASK) >> PS_ESD_IEN_PSENSE_SHIFT)
#define  PS_ESD_IEN_PSENSE_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_IEN_PSENSE_MASK) | (((uint32_t)val) << PS_ESD_IEN_PSENSE_SHIFT))

#define  PS_ESD_IEN_ESD_COLOR2_MASK 0x4
#define  PS_ESD_IEN_ESD_COLOR2_SHIFT 2
#define  PS_ESD_IEN_ESD_COLOR2_MASK_SHIFT(reg) (((reg) & PS_ESD_IEN_ESD_COLOR2_MASK) >> PS_ESD_IEN_ESD_COLOR2_SHIFT)
#define  PS_ESD_IEN_ESD_COLOR2_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_IEN_ESD_COLOR2_MASK) | (((uint32_t)val) << PS_ESD_IEN_ESD_COLOR2_SHIFT))

#define  PS_ESD_IEN_ESD_COLOR1_MASK 0x2
#define  PS_ESD_IEN_ESD_COLOR1_SHIFT 1
#define  PS_ESD_IEN_ESD_COLOR1_MASK_SHIFT(reg) (((reg) & PS_ESD_IEN_ESD_COLOR1_MASK) >> PS_ESD_IEN_ESD_COLOR1_SHIFT)
#define  PS_ESD_IEN_ESD_COLOR1_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_IEN_ESD_COLOR1_MASK) | (((uint32_t)val) << PS_ESD_IEN_ESD_COLOR1_SHIFT))

#define  PS_ESD_IEN_ESD_COLOR0_MASK 0x1
#define  PS_ESD_IEN_ESD_COLOR0_SHIFT 0
#define  PS_ESD_IEN_ESD_COLOR0_MASK_SHIFT(reg) (((reg) & PS_ESD_IEN_ESD_COLOR0_MASK) >> PS_ESD_IEN_ESD_COLOR0_SHIFT)
#define  PS_ESD_IEN_ESD_COLOR0_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_IEN_ESD_COLOR0_MASK) | (((uint32_t)val) << PS_ESD_IEN_ESD_COLOR0_SHIFT))

//====================================================================
//Register: Interrupt Pending Register (IPEND)
/** \brief Interrupt Pending*/
//====================================================================

#define  PS_ESD_IPEND_RESERVED1_MASK 0xfffffff0
#define  PS_ESD_IPEND_RESERVED1_SHIFT 4
#define  PS_ESD_IPEND_RESERVED1_MASK_SHIFT(reg) (((reg) & PS_ESD_IPEND_RESERVED1_MASK) >> PS_ESD_IPEND_RESERVED1_SHIFT)
#define  PS_ESD_IPEND_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_IPEND_RESERVED1_MASK) | (((uint32_t)val) << PS_ESD_IPEND_RESERVED1_SHIFT))

#define  PS_ESD_IPEND_PSENSE_MASK 0x8
#define  PS_ESD_IPEND_PSENSE_SHIFT 3
#define  PS_ESD_IPEND_PSENSE_MASK_SHIFT(reg) (((reg) & PS_ESD_IPEND_PSENSE_MASK) >> PS_ESD_IPEND_PSENSE_SHIFT)
#define  PS_ESD_IPEND_PSENSE_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_IPEND_PSENSE_MASK) | (((uint32_t)val) << PS_ESD_IPEND_PSENSE_SHIFT))

#define  PS_ESD_IPEND_ESD_COLOR2_MASK 0x4
#define  PS_ESD_IPEND_ESD_COLOR2_SHIFT 2
#define  PS_ESD_IPEND_ESD_COLOR2_MASK_SHIFT(reg) (((reg) & PS_ESD_IPEND_ESD_COLOR2_MASK) >> PS_ESD_IPEND_ESD_COLOR2_SHIFT)
#define  PS_ESD_IPEND_ESD_COLOR2_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_IPEND_ESD_COLOR2_MASK) | (((uint32_t)val) << PS_ESD_IPEND_ESD_COLOR2_SHIFT))

#define  PS_ESD_IPEND_ESD_COLOR1_MASK 0x2
#define  PS_ESD_IPEND_ESD_COLOR1_SHIFT 1
#define  PS_ESD_IPEND_ESD_COLOR1_MASK_SHIFT(reg) (((reg) & PS_ESD_IPEND_ESD_COLOR1_MASK) >> PS_ESD_IPEND_ESD_COLOR1_SHIFT)
#define  PS_ESD_IPEND_ESD_COLOR1_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_IPEND_ESD_COLOR1_MASK) | (((uint32_t)val) << PS_ESD_IPEND_ESD_COLOR1_SHIFT))

#define  PS_ESD_IPEND_ESD_COLOR0_MASK 0x1
#define  PS_ESD_IPEND_ESD_COLOR0_SHIFT 0
#define  PS_ESD_IPEND_ESD_COLOR0_MASK_SHIFT(reg) (((reg) & PS_ESD_IPEND_ESD_COLOR0_MASK) >> PS_ESD_IPEND_ESD_COLOR0_SHIFT)
#define  PS_ESD_IPEND_ESD_COLOR0_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_IPEND_ESD_COLOR0_MASK) | (((uint32_t)val) << PS_ESD_IPEND_ESD_COLOR0_SHIFT))

//====================================================================
//Register: Interrupt Acknowledge Register (IACK)
/** \brief Interrupt Acknowledge.*/
//====================================================================

#define  PS_ESD_IACK_RESERVED1_MASK 0xfffffff0
#define  PS_ESD_IACK_RESERVED1_SHIFT 4
#define  PS_ESD_IACK_RESERVED1_MASK_SHIFT(reg) (((reg) & PS_ESD_IACK_RESERVED1_MASK) >> PS_ESD_IACK_RESERVED1_SHIFT)
#define  PS_ESD_IACK_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_IACK_RESERVED1_MASK) | (((uint32_t)val) << PS_ESD_IACK_RESERVED1_SHIFT))

#define  PS_ESD_IACK_PSENSE_MASK 0x8
#define  PS_ESD_IACK_PSENSE_SHIFT 3
#define  PS_ESD_IACK_PSENSE_MASK_SHIFT(reg) (((reg) & PS_ESD_IACK_PSENSE_MASK) >> PS_ESD_IACK_PSENSE_SHIFT)
#define  PS_ESD_IACK_PSENSE_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_IACK_PSENSE_MASK) | (((uint32_t)val) << PS_ESD_IACK_PSENSE_SHIFT))

#define  PS_ESD_IACK_ESD_COLOR2_MASK 0x4
#define  PS_ESD_IACK_ESD_COLOR2_SHIFT 2
#define  PS_ESD_IACK_ESD_COLOR2_MASK_SHIFT(reg) (((reg) & PS_ESD_IACK_ESD_COLOR2_MASK) >> PS_ESD_IACK_ESD_COLOR2_SHIFT)
#define  PS_ESD_IACK_ESD_COLOR2_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_IACK_ESD_COLOR2_MASK) | (((uint32_t)val) << PS_ESD_IACK_ESD_COLOR2_SHIFT))

#define  PS_ESD_IACK_ESD_COLOR1_MASK 0x2
#define  PS_ESD_IACK_ESD_COLOR1_SHIFT 1
#define  PS_ESD_IACK_ESD_COLOR1_MASK_SHIFT(reg) (((reg) & PS_ESD_IACK_ESD_COLOR1_MASK) >> PS_ESD_IACK_ESD_COLOR1_SHIFT)
#define  PS_ESD_IACK_ESD_COLOR1_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_IACK_ESD_COLOR1_MASK) | (((uint32_t)val) << PS_ESD_IACK_ESD_COLOR1_SHIFT))

#define  PS_ESD_IACK_ESD_COLOR0_MASK 0x1
#define  PS_ESD_IACK_ESD_COLOR0_SHIFT 0
#define  PS_ESD_IACK_ESD_COLOR0_MASK_SHIFT(reg) (((reg) & PS_ESD_IACK_ESD_COLOR0_MASK) >> PS_ESD_IACK_ESD_COLOR0_SHIFT)
#define  PS_ESD_IACK_ESD_COLOR0_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_IACK_ESD_COLOR0_MASK) | (((uint32_t)val) << PS_ESD_IACK_ESD_COLOR0_SHIFT))

//====================================================================
//Register: Interrupt Force Register (IFORCE)
/** \brief Interrupt Force.*/
//====================================================================

#define  PS_ESD_IFORCE_RESERVED1_MASK 0xfffffff0
#define  PS_ESD_IFORCE_RESERVED1_SHIFT 4
#define  PS_ESD_IFORCE_RESERVED1_MASK_SHIFT(reg) (((reg) & PS_ESD_IFORCE_RESERVED1_MASK) >> PS_ESD_IFORCE_RESERVED1_SHIFT)
#define  PS_ESD_IFORCE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_IFORCE_RESERVED1_MASK) | (((uint32_t)val) << PS_ESD_IFORCE_RESERVED1_SHIFT))

#define  PS_ESD_IFORCE_PSENSE_MASK 0x8
#define  PS_ESD_IFORCE_PSENSE_SHIFT 3
#define  PS_ESD_IFORCE_PSENSE_MASK_SHIFT(reg) (((reg) & PS_ESD_IFORCE_PSENSE_MASK) >> PS_ESD_IFORCE_PSENSE_SHIFT)
#define  PS_ESD_IFORCE_PSENSE_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_IFORCE_PSENSE_MASK) | (((uint32_t)val) << PS_ESD_IFORCE_PSENSE_SHIFT))

#define  PS_ESD_IFORCE_ESD_COLOR2_MASK 0x4
#define  PS_ESD_IFORCE_ESD_COLOR2_SHIFT 2
#define  PS_ESD_IFORCE_ESD_COLOR2_MASK_SHIFT(reg) (((reg) & PS_ESD_IFORCE_ESD_COLOR2_MASK) >> PS_ESD_IFORCE_ESD_COLOR2_SHIFT)
#define  PS_ESD_IFORCE_ESD_COLOR2_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_IFORCE_ESD_COLOR2_MASK) | (((uint32_t)val) << PS_ESD_IFORCE_ESD_COLOR2_SHIFT))

#define  PS_ESD_IFORCE_ESD_COLOR1_MASK 0x2
#define  PS_ESD_IFORCE_ESD_COLOR1_SHIFT 1
#define  PS_ESD_IFORCE_ESD_COLOR1_MASK_SHIFT(reg) (((reg) & PS_ESD_IFORCE_ESD_COLOR1_MASK) >> PS_ESD_IFORCE_ESD_COLOR1_SHIFT)
#define  PS_ESD_IFORCE_ESD_COLOR1_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_IFORCE_ESD_COLOR1_MASK) | (((uint32_t)val) << PS_ESD_IFORCE_ESD_COLOR1_SHIFT))

#define  PS_ESD_IFORCE_ESD_COLOR0_MASK 0x1
#define  PS_ESD_IFORCE_ESD_COLOR0_SHIFT 0
#define  PS_ESD_IFORCE_ESD_COLOR0_MASK_SHIFT(reg) (((reg) & PS_ESD_IFORCE_ESD_COLOR0_MASK) >> PS_ESD_IFORCE_ESD_COLOR0_SHIFT)
#define  PS_ESD_IFORCE_ESD_COLOR0_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_IFORCE_ESD_COLOR0_MASK) | (((uint32_t)val) << PS_ESD_IFORCE_ESD_COLOR0_SHIFT))

//====================================================================
//Register: IP Tagging Revision 0 (REV0)
/** \brief Provide means for firmware to read IP tagging information.
      This register of particular interest to firmware.*/
//====================================================================

#define  PS_ESD_REV0_MAJ_MASK 0xffff0000
#define  PS_ESD_REV0_MAJ_SHIFT 16
#define  PS_ESD_REV0_MAJ_MASK_SHIFT(reg) (((reg) & PS_ESD_REV0_MAJ_MASK) >> PS_ESD_REV0_MAJ_SHIFT)
#define  PS_ESD_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_REV0_MAJ_MASK) | (((uint32_t)val) << PS_ESD_REV0_MAJ_SHIFT))

#define  PS_ESD_REV0_MID_MASK 0xffff
#define  PS_ESD_REV0_MID_SHIFT 0
#define  PS_ESD_REV0_MID_MASK_SHIFT(reg) (((reg) & PS_ESD_REV0_MID_MASK) >> PS_ESD_REV0_MID_SHIFT)
#define  PS_ESD_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_REV0_MID_MASK) | (((uint32_t)val) << PS_ESD_REV0_MID_SHIFT))

//====================================================================
//Register: IP Tagging Revision 1 (REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  PS_ESD_REV1_RESERVED1_MASK 0xffff0000
#define  PS_ESD_REV1_RESERVED1_SHIFT 16
#define  PS_ESD_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & PS_ESD_REV1_RESERVED1_MASK) >> PS_ESD_REV1_RESERVED1_SHIFT)
#define  PS_ESD_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_REV1_RESERVED1_MASK) | (((uint32_t)val) << PS_ESD_REV1_RESERVED1_SHIFT))

#define  PS_ESD_REV1_CFG_MASK 0xffff
#define  PS_ESD_REV1_CFG_SHIFT 0
#define  PS_ESD_REV1_CFG_MASK_SHIFT(reg) (((reg) & PS_ESD_REV1_CFG_MASK) >> PS_ESD_REV1_CFG_SHIFT)
#define  PS_ESD_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_REV1_CFG_MASK) | (((uint32_t)val) << PS_ESD_REV1_CFG_SHIFT))

#endif // PS_ESD
