 /*
 **************************************************************************************
 *
 * (c) Copyright 2013 Marvell International Ltd.
 *
 *
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/.
 *
 **************************************************************************************
 *
 * \file POGO_IDMA_regstructs.h
 * Generated using RegBuild 1.6.3
 *
 **************************************************************************************
 */

#ifndef _POGO_IDMA_REGSTRUCTS_H_
#define _POGO_IDMA_REGSTRUCTS_H_

#include "hwincl.h"

//====================================================================
//
//Register File: POGO_IDMA (POGO_IDMA)
//
//====================================================================

//====================================================================
//
//Register File: POGO_IDMA_UDMA (POGO_IDMA_UDMA)
//
//====================================================================

typedef struct POGO_IDMA_UDMA_REGS_s
{
  volatile uint32_t UCR;  ///< 0x0 [R/W]: UDMA Configuration Register
  volatile uint32_t USR;  ///< 0x4 [R]: UDMA Status Register
  volatile uint32_t UPR;  ///< 0x8 [R]: UDMA Parameter Register
  volatile uint32_t UIER;  ///< 0xc [R/W]: UDMA Interrupt Enable Register
  volatile uint32_t UIPR;  ///< 0x10 [R]: UDMA Interrupt Pending Register
  volatile uint32_t UICR;  ///< 0x14 [W]: UDMA Interrupt Clear Register
  volatile uint32_t UIFR;  ///< 0x18 [W]: UDMA Interrupt Force Register
  volatile uint32_t UDR;  ///< 0x1c [R/W]: UDMA Descriptor Register
  volatile uint32_t UBAR;  ///< 0x20 [R]: UDMA Burst Address Register
  volatile uint32_t UBLR;  ///< 0x24 [R]: UDMA Burst Length Register
  volatile uint32_t UBRR;  ///< 0x28 [R]: UDMA Transfer Bytes Remaining Register
  volatile uint32_t reserved0;
  volatile uint32_t UTR0;  ///< 0x30 [R]: UDMA Tag Register 0
  volatile uint32_t UTR1;  ///< 0x34 [R]: UDMA Tag Register 1
} POGO_IDMA_UDMA_REGS_t;

//====================================================================
//
//Register File: POGO_IDMA_CORE (POGO_IDMA_CORE)
//
//====================================================================

typedef struct POGO_IDMA_CORE_REGS_s
{
  volatile uint32_t ICR;  ///< 0x0 [R/W]: IDMA Configuration Register
  volatile uint32_t IIER;  ///< 0x4 [R/W]: IDMA Interrupt Enable Register
  volatile uint32_t IIPR;  ///< 0x8 [R]: IDMA Interrupt Pending Register
  volatile uint32_t IICR;  ///< 0xc [W]: IDMA Interrupt Clear Register
  volatile uint32_t IIFR;  ///< 0x10 [W]: IDMA Interrupt Force Register
  volatile uint32_t ILWR;  ///< 0x14 [R/W]: IDMA Line Width Register
  volatile uint32_t IRHR;  ///< 0x18 [R/W]: IDMA Row Height Register
  volatile uint32_t ITR0;  ///< 0x1c [R]: IDMA Tag Register 0
  volatile uint32_t ITR1;  ///< 0x20 [R]: IDMA Tag Register 1
  volatile uint32_t ITR2;  ///< 0x24 [R]: IDMA Tag Register 2
} POGO_IDMA_CORE_REGS_t;

#endif // POGO_IDMA
 /*
 **************************************************************************************
 *
 * (c) Copyright 2013 Marvell International Ltd.
 *
 *
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/.
 *
 **************************************************************************************
 *
 * \file POGO_IDMA_regmasks.h
 * Generated using RegBuild 1.6.3
 *
 **************************************************************************************
 */

#ifndef _POGO_IDMA_REGMASKS_H_
#define _POGO_IDMA_REGMASKS_H_

#include "hwincl.h"

//====================================================================
//
//Register File: POGO_IDMA (POGO_IDMA)
//
//====================================================================

//====================================================================
//
//Register File: POGO_IDMA_UDMA (POGO_IDMA_UDMA)
//
//====================================================================

//====================================================================
//Register: UDMA Configuration Register (UCR)
//====================================================================

#define  POGO_IDMA_UDMA_UCR_RESERVED1_MASK 0xfff00000
#define  POGO_IDMA_UDMA_UCR_RESERVED1_SHIFT 20
#define  POGO_IDMA_UDMA_UCR_RESERVED1_MASK_SHIFT(reg) (((reg) & POGO_IDMA_UDMA_UCR_RESERVED1_MASK) >> POGO_IDMA_UDMA_UCR_RESERVED1_SHIFT)
#define  POGO_IDMA_UDMA_UCR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA_UDMA_UCR_RESERVED1_MASK) | (((uint32_t)val) << POGO_IDMA_UDMA_UCR_RESERVED1_SHIFT))

#define  POGO_IDMA_UDMA_UCR_DATAAXCACHE_MASK 0xf0000
#define  POGO_IDMA_UDMA_UCR_DATAAXCACHE_SHIFT 16
#define  POGO_IDMA_UDMA_UCR_DATAAXCACHE_MASK_SHIFT(reg) (((reg) & POGO_IDMA_UDMA_UCR_DATAAXCACHE_MASK) >> POGO_IDMA_UDMA_UCR_DATAAXCACHE_SHIFT)
#define  POGO_IDMA_UDMA_UCR_DATAAXCACHE_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA_UDMA_UCR_DATAAXCACHE_MASK) | (((uint32_t)val) << POGO_IDMA_UDMA_UCR_DATAAXCACHE_SHIFT))

#define  POGO_IDMA_UDMA_UCR_DESCARCACHE_MASK 0xf000
#define  POGO_IDMA_UDMA_UCR_DESCARCACHE_SHIFT 12
#define  POGO_IDMA_UDMA_UCR_DESCARCACHE_MASK_SHIFT(reg) (((reg) & POGO_IDMA_UDMA_UCR_DESCARCACHE_MASK) >> POGO_IDMA_UDMA_UCR_DESCARCACHE_SHIFT)
#define  POGO_IDMA_UDMA_UCR_DESCARCACHE_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA_UDMA_UCR_DESCARCACHE_MASK) | (((uint32_t)val) << POGO_IDMA_UDMA_UCR_DESCARCACHE_SHIFT))

#define  POGO_IDMA_UDMA_UCR_DESCAWCACHE_MASK 0xf00
#define  POGO_IDMA_UDMA_UCR_DESCAWCACHE_SHIFT 8
#define  POGO_IDMA_UDMA_UCR_DESCAWCACHE_MASK_SHIFT(reg) (((reg) & POGO_IDMA_UDMA_UCR_DESCAWCACHE_MASK) >> POGO_IDMA_UDMA_UCR_DESCAWCACHE_SHIFT)
#define  POGO_IDMA_UDMA_UCR_DESCAWCACHE_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA_UDMA_UCR_DESCAWCACHE_MASK) | (((uint32_t)val) << POGO_IDMA_UDMA_UCR_DESCAWCACHE_SHIFT))

#define  POGO_IDMA_UDMA_UCR_RESERVED2_MASK 0xc0
#define  POGO_IDMA_UDMA_UCR_RESERVED2_SHIFT 6
#define  POGO_IDMA_UDMA_UCR_RESERVED2_MASK_SHIFT(reg) (((reg) & POGO_IDMA_UDMA_UCR_RESERVED2_MASK) >> POGO_IDMA_UDMA_UCR_RESERVED2_SHIFT)
#define  POGO_IDMA_UDMA_UCR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA_UDMA_UCR_RESERVED2_MASK) | (((uint32_t)val) << POGO_IDMA_UDMA_UCR_RESERVED2_SHIFT))

#define  POGO_IDMA_UDMA_UCR_HANDSHAKEENABLE_MASK 0x20
#define  POGO_IDMA_UDMA_UCR_HANDSHAKEENABLE_SHIFT 5
#define  POGO_IDMA_UDMA_UCR_HANDSHAKEENABLE_MASK_SHIFT(reg) (((reg) & POGO_IDMA_UDMA_UCR_HANDSHAKEENABLE_MASK) >> POGO_IDMA_UDMA_UCR_HANDSHAKEENABLE_SHIFT)
#define  POGO_IDMA_UDMA_UCR_HANDSHAKEENABLE_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA_UDMA_UCR_HANDSHAKEENABLE_MASK) | (((uint32_t)val) << POGO_IDMA_UDMA_UCR_HANDSHAKEENABLE_SHIFT))

#define  POGO_IDMA_UDMA_UCR_OWNWRITEDISABLE_MASK 0x10
#define  POGO_IDMA_UDMA_UCR_OWNWRITEDISABLE_SHIFT 4
#define  POGO_IDMA_UDMA_UCR_OWNWRITEDISABLE_MASK_SHIFT(reg) (((reg) & POGO_IDMA_UDMA_UCR_OWNWRITEDISABLE_MASK) >> POGO_IDMA_UDMA_UCR_OWNWRITEDISABLE_SHIFT)
#define  POGO_IDMA_UDMA_UCR_OWNWRITEDISABLE_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA_UDMA_UCR_OWNWRITEDISABLE_MASK) | (((uint32_t)val) << POGO_IDMA_UDMA_UCR_OWNWRITEDISABLE_SHIFT))

#define  POGO_IDMA_UDMA_UCR_OWNPOLARITY_MASK 0x8
#define  POGO_IDMA_UDMA_UCR_OWNPOLARITY_SHIFT 3
#define  POGO_IDMA_UDMA_UCR_OWNPOLARITY_MASK_SHIFT(reg) (((reg) & POGO_IDMA_UDMA_UCR_OWNPOLARITY_MASK) >> POGO_IDMA_UDMA_UCR_OWNPOLARITY_SHIFT)
#define  POGO_IDMA_UDMA_UCR_OWNPOLARITY_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA_UDMA_UCR_OWNPOLARITY_MASK) | (((uint32_t)val) << POGO_IDMA_UDMA_UCR_OWNPOLARITY_SHIFT))

#define  POGO_IDMA_UDMA_UCR_BEATS_MASK 0x6
#define  POGO_IDMA_UDMA_UCR_BEATS_SHIFT 1
#define  POGO_IDMA_UDMA_UCR_BEATS_MASK_SHIFT(reg) (((reg) & POGO_IDMA_UDMA_UCR_BEATS_MASK) >> POGO_IDMA_UDMA_UCR_BEATS_SHIFT)
#define  POGO_IDMA_UDMA_UCR_BEATS_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA_UDMA_UCR_BEATS_MASK) | (((uint32_t)val) << POGO_IDMA_UDMA_UCR_BEATS_SHIFT))

#define  POGO_IDMA_UDMA_UCR_ENABLE_MASK 0x1
#define  POGO_IDMA_UDMA_UCR_ENABLE_SHIFT 0
#define  POGO_IDMA_UDMA_UCR_ENABLE_MASK_SHIFT(reg) (((reg) & POGO_IDMA_UDMA_UCR_ENABLE_MASK) >> POGO_IDMA_UDMA_UCR_ENABLE_SHIFT)
#define  POGO_IDMA_UDMA_UCR_ENABLE_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA_UDMA_UCR_ENABLE_MASK) | (((uint32_t)val) << POGO_IDMA_UDMA_UCR_ENABLE_SHIFT))

//====================================================================
//Register: UDMA Status Register (USR)
//====================================================================

#define  POGO_IDMA_UDMA_USR_RESERVED1_MASK 0xfffff800
#define  POGO_IDMA_UDMA_USR_RESERVED1_SHIFT 11
#define  POGO_IDMA_UDMA_USR_RESERVED1_MASK_SHIFT(reg) (((reg) & POGO_IDMA_UDMA_USR_RESERVED1_MASK) >> POGO_IDMA_UDMA_USR_RESERVED1_SHIFT)
#define  POGO_IDMA_UDMA_USR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA_UDMA_USR_RESERVED1_MASK) | (((uint32_t)val) << POGO_IDMA_UDMA_USR_RESERVED1_SHIFT))

#define  POGO_IDMA_UDMA_USR_DMAPAUSED_MASK 0x400
#define  POGO_IDMA_UDMA_USR_DMAPAUSED_SHIFT 10
#define  POGO_IDMA_UDMA_USR_DMAPAUSED_MASK_SHIFT(reg) (((reg) & POGO_IDMA_UDMA_USR_DMAPAUSED_MASK) >> POGO_IDMA_UDMA_USR_DMAPAUSED_SHIFT)
#define  POGO_IDMA_UDMA_USR_DMAPAUSED_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA_UDMA_USR_DMAPAUSED_MASK) | (((uint32_t)val) << POGO_IDMA_UDMA_USR_DMAPAUSED_SHIFT))

#define  POGO_IDMA_UDMA_USR_PAUSEAFTER_MASK 0x200
#define  POGO_IDMA_UDMA_USR_PAUSEAFTER_SHIFT 9
#define  POGO_IDMA_UDMA_USR_PAUSEAFTER_MASK_SHIFT(reg) (((reg) & POGO_IDMA_UDMA_USR_PAUSEAFTER_MASK) >> POGO_IDMA_UDMA_USR_PAUSEAFTER_SHIFT)
#define  POGO_IDMA_UDMA_USR_PAUSEAFTER_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA_UDMA_USR_PAUSEAFTER_MASK) | (((uint32_t)val) << POGO_IDMA_UDMA_USR_PAUSEAFTER_SHIFT))

#define  POGO_IDMA_UDMA_USR_PAUSEBEFORE_MASK 0x100
#define  POGO_IDMA_UDMA_USR_PAUSEBEFORE_SHIFT 8
#define  POGO_IDMA_UDMA_USR_PAUSEBEFORE_MASK_SHIFT(reg) (((reg) & POGO_IDMA_UDMA_USR_PAUSEBEFORE_MASK) >> POGO_IDMA_UDMA_USR_PAUSEBEFORE_SHIFT)
#define  POGO_IDMA_UDMA_USR_PAUSEBEFORE_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA_UDMA_USR_PAUSEBEFORE_MASK) | (((uint32_t)val) << POGO_IDMA_UDMA_USR_PAUSEBEFORE_SHIFT))

#define  POGO_IDMA_UDMA_USR_INTONFINISH_MASK 0x80
#define  POGO_IDMA_UDMA_USR_INTONFINISH_SHIFT 7
#define  POGO_IDMA_UDMA_USR_INTONFINISH_MASK_SHIFT(reg) (((reg) & POGO_IDMA_UDMA_USR_INTONFINISH_MASK) >> POGO_IDMA_UDMA_USR_INTONFINISH_SHIFT)
#define  POGO_IDMA_UDMA_USR_INTONFINISH_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA_UDMA_USR_INTONFINISH_MASK) | (((uint32_t)val) << POGO_IDMA_UDMA_USR_INTONFINISH_SHIFT))

#define  POGO_IDMA_UDMA_USR_STOPONFINISH_MASK 0x40
#define  POGO_IDMA_UDMA_USR_STOPONFINISH_SHIFT 6
#define  POGO_IDMA_UDMA_USR_STOPONFINISH_MASK_SHIFT(reg) (((reg) & POGO_IDMA_UDMA_USR_STOPONFINISH_MASK) >> POGO_IDMA_UDMA_USR_STOPONFINISH_SHIFT)
#define  POGO_IDMA_UDMA_USR_STOPONFINISH_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA_UDMA_USR_STOPONFINISH_MASK) | (((uint32_t)val) << POGO_IDMA_UDMA_USR_STOPONFINISH_SHIFT))

#define  POGO_IDMA_UDMA_USR_CMDBUFFULL_MASK 0x20
#define  POGO_IDMA_UDMA_USR_CMDBUFFULL_SHIFT 5
#define  POGO_IDMA_UDMA_USR_CMDBUFFULL_MASK_SHIFT(reg) (((reg) & POGO_IDMA_UDMA_USR_CMDBUFFULL_MASK) >> POGO_IDMA_UDMA_USR_CMDBUFFULL_SHIFT)
#define  POGO_IDMA_UDMA_USR_CMDBUFFULL_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA_UDMA_USR_CMDBUFFULL_MASK) | (((uint32_t)val) << POGO_IDMA_UDMA_USR_CMDBUFFULL_SHIFT))

#define  POGO_IDMA_UDMA_USR_CMDBUFEMPTY_MASK 0x10
#define  POGO_IDMA_UDMA_USR_CMDBUFEMPTY_SHIFT 4
#define  POGO_IDMA_UDMA_USR_CMDBUFEMPTY_MASK_SHIFT(reg) (((reg) & POGO_IDMA_UDMA_USR_CMDBUFEMPTY_MASK) >> POGO_IDMA_UDMA_USR_CMDBUFEMPTY_SHIFT)
#define  POGO_IDMA_UDMA_USR_CMDBUFEMPTY_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA_UDMA_USR_CMDBUFEMPTY_MASK) | (((uint32_t)val) << POGO_IDMA_UDMA_USR_CMDBUFEMPTY_SHIFT))

#define  POGO_IDMA_UDMA_USR_DATABUFFULL_MASK 0x8
#define  POGO_IDMA_UDMA_USR_DATABUFFULL_SHIFT 3
#define  POGO_IDMA_UDMA_USR_DATABUFFULL_MASK_SHIFT(reg) (((reg) & POGO_IDMA_UDMA_USR_DATABUFFULL_MASK) >> POGO_IDMA_UDMA_USR_DATABUFFULL_SHIFT)
#define  POGO_IDMA_UDMA_USR_DATABUFFULL_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA_UDMA_USR_DATABUFFULL_MASK) | (((uint32_t)val) << POGO_IDMA_UDMA_USR_DATABUFFULL_SHIFT))

#define  POGO_IDMA_UDMA_USR_DATABUFEMPTY_MASK 0x4
#define  POGO_IDMA_UDMA_USR_DATABUFEMPTY_SHIFT 2
#define  POGO_IDMA_UDMA_USR_DATABUFEMPTY_MASK_SHIFT(reg) (((reg) & POGO_IDMA_UDMA_USR_DATABUFEMPTY_MASK) >> POGO_IDMA_UDMA_USR_DATABUFEMPTY_SHIFT)
#define  POGO_IDMA_UDMA_USR_DATABUFEMPTY_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA_UDMA_USR_DATABUFEMPTY_MASK) | (((uint32_t)val) << POGO_IDMA_UDMA_USR_DATABUFEMPTY_SHIFT))

#define  POGO_IDMA_UDMA_USR_CLEAR_MASK 0x2
#define  POGO_IDMA_UDMA_USR_CLEAR_SHIFT 1
#define  POGO_IDMA_UDMA_USR_CLEAR_MASK_SHIFT(reg) (((reg) & POGO_IDMA_UDMA_USR_CLEAR_MASK) >> POGO_IDMA_UDMA_USR_CLEAR_SHIFT)
#define  POGO_IDMA_UDMA_USR_CLEAR_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA_UDMA_USR_CLEAR_MASK) | (((uint32_t)val) << POGO_IDMA_UDMA_USR_CLEAR_SHIFT))

#define  POGO_IDMA_UDMA_USR_BUSY_MASK 0x1
#define  POGO_IDMA_UDMA_USR_BUSY_SHIFT 0
#define  POGO_IDMA_UDMA_USR_BUSY_MASK_SHIFT(reg) (((reg) & POGO_IDMA_UDMA_USR_BUSY_MASK) >> POGO_IDMA_UDMA_USR_BUSY_SHIFT)
#define  POGO_IDMA_UDMA_USR_BUSY_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA_UDMA_USR_BUSY_MASK) | (((uint32_t)val) << POGO_IDMA_UDMA_USR_BUSY_SHIFT))

//====================================================================
//Register: UDMA Parameter Register (UPR)
//====================================================================

#define  POGO_IDMA_UDMA_UPR_RESERVED1_MASK 0xff000000
#define  POGO_IDMA_UDMA_UPR_RESERVED1_SHIFT 24
#define  POGO_IDMA_UDMA_UPR_RESERVED1_MASK_SHIFT(reg) (((reg) & POGO_IDMA_UDMA_UPR_RESERVED1_MASK) >> POGO_IDMA_UDMA_UPR_RESERVED1_SHIFT)
#define  POGO_IDMA_UDMA_UPR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA_UDMA_UPR_RESERVED1_MASK) | (((uint32_t)val) << POGO_IDMA_UDMA_UPR_RESERVED1_SHIFT))

#define  POGO_IDMA_UDMA_UPR_FIFODEPTH_MASK 0xffff00
#define  POGO_IDMA_UDMA_UPR_FIFODEPTH_SHIFT 8
#define  POGO_IDMA_UDMA_UPR_FIFODEPTH_MASK_SHIFT(reg) (((reg) & POGO_IDMA_UDMA_UPR_FIFODEPTH_MASK) >> POGO_IDMA_UDMA_UPR_FIFODEPTH_SHIFT)
#define  POGO_IDMA_UDMA_UPR_FIFODEPTH_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA_UDMA_UPR_FIFODEPTH_MASK) | (((uint32_t)val) << POGO_IDMA_UDMA_UPR_FIFODEPTH_SHIFT))

#define  POGO_IDMA_UDMA_UPR_RESERVED2_MASK 0xe0
#define  POGO_IDMA_UDMA_UPR_RESERVED2_SHIFT 5
#define  POGO_IDMA_UDMA_UPR_RESERVED2_MASK_SHIFT(reg) (((reg) & POGO_IDMA_UDMA_UPR_RESERVED2_MASK) >> POGO_IDMA_UDMA_UPR_RESERVED2_SHIFT)
#define  POGO_IDMA_UDMA_UPR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA_UDMA_UPR_RESERVED2_MASK) | (((uint32_t)val) << POGO_IDMA_UDMA_UPR_RESERVED2_SHIFT))

#define  POGO_IDMA_UDMA_UPR_SERPSUPPORT_MASK 0x10
#define  POGO_IDMA_UDMA_UPR_SERPSUPPORT_SHIFT 4
#define  POGO_IDMA_UDMA_UPR_SERPSUPPORT_MASK_SHIFT(reg) (((reg) & POGO_IDMA_UDMA_UPR_SERPSUPPORT_MASK) >> POGO_IDMA_UDMA_UPR_SERPSUPPORT_SHIFT)
#define  POGO_IDMA_UDMA_UPR_SERPSUPPORT_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA_UDMA_UPR_SERPSUPPORT_MASK) | (((uint32_t)val) << POGO_IDMA_UDMA_UPR_SERPSUPPORT_SHIFT))

#define  POGO_IDMA_UDMA_UPR_DESCLENGTH_MASK 0x8
#define  POGO_IDMA_UDMA_UPR_DESCLENGTH_SHIFT 3
#define  POGO_IDMA_UDMA_UPR_DESCLENGTH_MASK_SHIFT(reg) (((reg) & POGO_IDMA_UDMA_UPR_DESCLENGTH_MASK) >> POGO_IDMA_UDMA_UPR_DESCLENGTH_SHIFT)
#define  POGO_IDMA_UDMA_UPR_DESCLENGTH_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA_UDMA_UPR_DESCLENGTH_MASK) | (((uint32_t)val) << POGO_IDMA_UDMA_UPR_DESCLENGTH_SHIFT))

#define  POGO_IDMA_UDMA_UPR_BUSWIDTH_MASK 0x4
#define  POGO_IDMA_UDMA_UPR_BUSWIDTH_SHIFT 2
#define  POGO_IDMA_UDMA_UPR_BUSWIDTH_MASK_SHIFT(reg) (((reg) & POGO_IDMA_UDMA_UPR_BUSWIDTH_MASK) >> POGO_IDMA_UDMA_UPR_BUSWIDTH_SHIFT)
#define  POGO_IDMA_UDMA_UPR_BUSWIDTH_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA_UDMA_UPR_BUSWIDTH_MASK) | (((uint32_t)val) << POGO_IDMA_UDMA_UPR_BUSWIDTH_SHIFT))

#define  POGO_IDMA_UDMA_UPR_MEMALIGN_MASK 0x3
#define  POGO_IDMA_UDMA_UPR_MEMALIGN_SHIFT 0
#define  POGO_IDMA_UDMA_UPR_MEMALIGN_MASK_SHIFT(reg) (((reg) & POGO_IDMA_UDMA_UPR_MEMALIGN_MASK) >> POGO_IDMA_UDMA_UPR_MEMALIGN_SHIFT)
#define  POGO_IDMA_UDMA_UPR_MEMALIGN_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA_UDMA_UPR_MEMALIGN_MASK) | (((uint32_t)val) << POGO_IDMA_UDMA_UPR_MEMALIGN_SHIFT))

//====================================================================
//Register: UDMA Interrupt Enable Register (UIER)
//====================================================================

#define  POGO_IDMA_UDMA_UIER_RESERVED1_MASK 0xffffffc0
#define  POGO_IDMA_UDMA_UIER_RESERVED1_SHIFT 6
#define  POGO_IDMA_UDMA_UIER_RESERVED1_MASK_SHIFT(reg) (((reg) & POGO_IDMA_UDMA_UIER_RESERVED1_MASK) >> POGO_IDMA_UDMA_UIER_RESERVED1_SHIFT)
#define  POGO_IDMA_UDMA_UIER_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA_UDMA_UIER_RESERVED1_MASK) | (((uint32_t)val) << POGO_IDMA_UDMA_UIER_RESERVED1_SHIFT))

#define  POGO_IDMA_UDMA_UIER_OUTOFRANGE_MASK 0x20
#define  POGO_IDMA_UDMA_UIER_OUTOFRANGE_SHIFT 5
#define  POGO_IDMA_UDMA_UIER_OUTOFRANGE_MASK_SHIFT(reg) (((reg) & POGO_IDMA_UDMA_UIER_OUTOFRANGE_MASK) >> POGO_IDMA_UDMA_UIER_OUTOFRANGE_SHIFT)
#define  POGO_IDMA_UDMA_UIER_OUTOFRANGE_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA_UDMA_UIER_OUTOFRANGE_MASK) | (((uint32_t)val) << POGO_IDMA_UDMA_UIER_OUTOFRANGE_SHIFT))

#define  POGO_IDMA_UDMA_UIER_RRESP_MASK 0x10
#define  POGO_IDMA_UDMA_UIER_RRESP_SHIFT 4
#define  POGO_IDMA_UDMA_UIER_RRESP_MASK_SHIFT(reg) (((reg) & POGO_IDMA_UDMA_UIER_RRESP_MASK) >> POGO_IDMA_UDMA_UIER_RRESP_SHIFT)
#define  POGO_IDMA_UDMA_UIER_RRESP_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA_UDMA_UIER_RRESP_MASK) | (((uint32_t)val) << POGO_IDMA_UDMA_UIER_RRESP_SHIFT))

#define  POGO_IDMA_UDMA_UIER_BRESP_MASK 0x8
#define  POGO_IDMA_UDMA_UIER_BRESP_SHIFT 3
#define  POGO_IDMA_UDMA_UIER_BRESP_MASK_SHIFT(reg) (((reg) & POGO_IDMA_UDMA_UIER_BRESP_MASK) >> POGO_IDMA_UDMA_UIER_BRESP_SHIFT)
#define  POGO_IDMA_UDMA_UIER_BRESP_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA_UDMA_UIER_BRESP_MASK) | (((uint32_t)val) << POGO_IDMA_UDMA_UIER_BRESP_SHIFT))

#define  POGO_IDMA_UDMA_UIER_CLEARCOMPLETE_MASK 0x4
#define  POGO_IDMA_UDMA_UIER_CLEARCOMPLETE_SHIFT 2
#define  POGO_IDMA_UDMA_UIER_CLEARCOMPLETE_MASK_SHIFT(reg) (((reg) & POGO_IDMA_UDMA_UIER_CLEARCOMPLETE_MASK) >> POGO_IDMA_UDMA_UIER_CLEARCOMPLETE_SHIFT)
#define  POGO_IDMA_UDMA_UIER_CLEARCOMPLETE_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA_UDMA_UIER_CLEARCOMPLETE_MASK) | (((uint32_t)val) << POGO_IDMA_UDMA_UIER_CLEARCOMPLETE_SHIFT))

#define  POGO_IDMA_UDMA_UIER_DESC_MASK 0x2
#define  POGO_IDMA_UDMA_UIER_DESC_SHIFT 1
#define  POGO_IDMA_UDMA_UIER_DESC_MASK_SHIFT(reg) (((reg) & POGO_IDMA_UDMA_UIER_DESC_MASK) >> POGO_IDMA_UDMA_UIER_DESC_SHIFT)
#define  POGO_IDMA_UDMA_UIER_DESC_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA_UDMA_UIER_DESC_MASK) | (((uint32_t)val) << POGO_IDMA_UDMA_UIER_DESC_SHIFT))

#define  POGO_IDMA_UDMA_UIER_OWN_MASK 0x1
#define  POGO_IDMA_UDMA_UIER_OWN_SHIFT 0
#define  POGO_IDMA_UDMA_UIER_OWN_MASK_SHIFT(reg) (((reg) & POGO_IDMA_UDMA_UIER_OWN_MASK) >> POGO_IDMA_UDMA_UIER_OWN_SHIFT)
#define  POGO_IDMA_UDMA_UIER_OWN_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA_UDMA_UIER_OWN_MASK) | (((uint32_t)val) << POGO_IDMA_UDMA_UIER_OWN_SHIFT))

//====================================================================
//Register: UDMA Interrupt Pending Register (UIPR)
//====================================================================

#define  POGO_IDMA_UDMA_UIPR_RESERVED1_MASK 0xffffffc0
#define  POGO_IDMA_UDMA_UIPR_RESERVED1_SHIFT 6
#define  POGO_IDMA_UDMA_UIPR_RESERVED1_MASK_SHIFT(reg) (((reg) & POGO_IDMA_UDMA_UIPR_RESERVED1_MASK) >> POGO_IDMA_UDMA_UIPR_RESERVED1_SHIFT)
#define  POGO_IDMA_UDMA_UIPR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA_UDMA_UIPR_RESERVED1_MASK) | (((uint32_t)val) << POGO_IDMA_UDMA_UIPR_RESERVED1_SHIFT))

#define  POGO_IDMA_UDMA_UIPR_OUTOFRANGE_MASK 0x20
#define  POGO_IDMA_UDMA_UIPR_OUTOFRANGE_SHIFT 5
#define  POGO_IDMA_UDMA_UIPR_OUTOFRANGE_MASK_SHIFT(reg) (((reg) & POGO_IDMA_UDMA_UIPR_OUTOFRANGE_MASK) >> POGO_IDMA_UDMA_UIPR_OUTOFRANGE_SHIFT)
#define  POGO_IDMA_UDMA_UIPR_OUTOFRANGE_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA_UDMA_UIPR_OUTOFRANGE_MASK) | (((uint32_t)val) << POGO_IDMA_UDMA_UIPR_OUTOFRANGE_SHIFT))

#define  POGO_IDMA_UDMA_UIPR_RRESP_MASK 0x10
#define  POGO_IDMA_UDMA_UIPR_RRESP_SHIFT 4
#define  POGO_IDMA_UDMA_UIPR_RRESP_MASK_SHIFT(reg) (((reg) & POGO_IDMA_UDMA_UIPR_RRESP_MASK) >> POGO_IDMA_UDMA_UIPR_RRESP_SHIFT)
#define  POGO_IDMA_UDMA_UIPR_RRESP_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA_UDMA_UIPR_RRESP_MASK) | (((uint32_t)val) << POGO_IDMA_UDMA_UIPR_RRESP_SHIFT))

#define  POGO_IDMA_UDMA_UIPR_BRESP_MASK 0x8
#define  POGO_IDMA_UDMA_UIPR_BRESP_SHIFT 3
#define  POGO_IDMA_UDMA_UIPR_BRESP_MASK_SHIFT(reg) (((reg) & POGO_IDMA_UDMA_UIPR_BRESP_MASK) >> POGO_IDMA_UDMA_UIPR_BRESP_SHIFT)
#define  POGO_IDMA_UDMA_UIPR_BRESP_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA_UDMA_UIPR_BRESP_MASK) | (((uint32_t)val) << POGO_IDMA_UDMA_UIPR_BRESP_SHIFT))

#define  POGO_IDMA_UDMA_UIPR_CLEARCOMPLETE_MASK 0x4
#define  POGO_IDMA_UDMA_UIPR_CLEARCOMPLETE_SHIFT 2
#define  POGO_IDMA_UDMA_UIPR_CLEARCOMPLETE_MASK_SHIFT(reg) (((reg) & POGO_IDMA_UDMA_UIPR_CLEARCOMPLETE_MASK) >> POGO_IDMA_UDMA_UIPR_CLEARCOMPLETE_SHIFT)
#define  POGO_IDMA_UDMA_UIPR_CLEARCOMPLETE_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA_UDMA_UIPR_CLEARCOMPLETE_MASK) | (((uint32_t)val) << POGO_IDMA_UDMA_UIPR_CLEARCOMPLETE_SHIFT))

#define  POGO_IDMA_UDMA_UIPR_DESC_MASK 0x2
#define  POGO_IDMA_UDMA_UIPR_DESC_SHIFT 1
#define  POGO_IDMA_UDMA_UIPR_DESC_MASK_SHIFT(reg) (((reg) & POGO_IDMA_UDMA_UIPR_DESC_MASK) >> POGO_IDMA_UDMA_UIPR_DESC_SHIFT)
#define  POGO_IDMA_UDMA_UIPR_DESC_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA_UDMA_UIPR_DESC_MASK) | (((uint32_t)val) << POGO_IDMA_UDMA_UIPR_DESC_SHIFT))

#define  POGO_IDMA_UDMA_UIPR_OWN_MASK 0x1
#define  POGO_IDMA_UDMA_UIPR_OWN_SHIFT 0
#define  POGO_IDMA_UDMA_UIPR_OWN_MASK_SHIFT(reg) (((reg) & POGO_IDMA_UDMA_UIPR_OWN_MASK) >> POGO_IDMA_UDMA_UIPR_OWN_SHIFT)
#define  POGO_IDMA_UDMA_UIPR_OWN_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA_UDMA_UIPR_OWN_MASK) | (((uint32_t)val) << POGO_IDMA_UDMA_UIPR_OWN_SHIFT))

//====================================================================
//Register: UDMA Interrupt Clear Register (UICR)
//====================================================================

#define  POGO_IDMA_UDMA_UICR_RESERVED1_MASK 0xffffffc0
#define  POGO_IDMA_UDMA_UICR_RESERVED1_SHIFT 6
#define  POGO_IDMA_UDMA_UICR_RESERVED1_MASK_SHIFT(reg) (((reg) & POGO_IDMA_UDMA_UICR_RESERVED1_MASK) >> POGO_IDMA_UDMA_UICR_RESERVED1_SHIFT)
#define  POGO_IDMA_UDMA_UICR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA_UDMA_UICR_RESERVED1_MASK) | (((uint32_t)val) << POGO_IDMA_UDMA_UICR_RESERVED1_SHIFT))

#define  POGO_IDMA_UDMA_UICR_OUTOFRANGE_MASK 0x20
#define  POGO_IDMA_UDMA_UICR_OUTOFRANGE_SHIFT 5
#define  POGO_IDMA_UDMA_UICR_OUTOFRANGE_MASK_SHIFT(reg) (((reg) & POGO_IDMA_UDMA_UICR_OUTOFRANGE_MASK) >> POGO_IDMA_UDMA_UICR_OUTOFRANGE_SHIFT)
#define  POGO_IDMA_UDMA_UICR_OUTOFRANGE_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA_UDMA_UICR_OUTOFRANGE_MASK) | (((uint32_t)val) << POGO_IDMA_UDMA_UICR_OUTOFRANGE_SHIFT))

#define  POGO_IDMA_UDMA_UICR_RRESP_MASK 0x10
#define  POGO_IDMA_UDMA_UICR_RRESP_SHIFT 4
#define  POGO_IDMA_UDMA_UICR_RRESP_MASK_SHIFT(reg) (((reg) & POGO_IDMA_UDMA_UICR_RRESP_MASK) >> POGO_IDMA_UDMA_UICR_RRESP_SHIFT)
#define  POGO_IDMA_UDMA_UICR_RRESP_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA_UDMA_UICR_RRESP_MASK) | (((uint32_t)val) << POGO_IDMA_UDMA_UICR_RRESP_SHIFT))

#define  POGO_IDMA_UDMA_UICR_BRESP_MASK 0x8
#define  POGO_IDMA_UDMA_UICR_BRESP_SHIFT 3
#define  POGO_IDMA_UDMA_UICR_BRESP_MASK_SHIFT(reg) (((reg) & POGO_IDMA_UDMA_UICR_BRESP_MASK) >> POGO_IDMA_UDMA_UICR_BRESP_SHIFT)
#define  POGO_IDMA_UDMA_UICR_BRESP_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA_UDMA_UICR_BRESP_MASK) | (((uint32_t)val) << POGO_IDMA_UDMA_UICR_BRESP_SHIFT))

#define  POGO_IDMA_UDMA_UICR_CLEARCOMPLETE_MASK 0x4
#define  POGO_IDMA_UDMA_UICR_CLEARCOMPLETE_SHIFT 2
#define  POGO_IDMA_UDMA_UICR_CLEARCOMPLETE_MASK_SHIFT(reg) (((reg) & POGO_IDMA_UDMA_UICR_CLEARCOMPLETE_MASK) >> POGO_IDMA_UDMA_UICR_CLEARCOMPLETE_SHIFT)
#define  POGO_IDMA_UDMA_UICR_CLEARCOMPLETE_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA_UDMA_UICR_CLEARCOMPLETE_MASK) | (((uint32_t)val) << POGO_IDMA_UDMA_UICR_CLEARCOMPLETE_SHIFT))

#define  POGO_IDMA_UDMA_UICR_DESC_MASK 0x2
#define  POGO_IDMA_UDMA_UICR_DESC_SHIFT 1
#define  POGO_IDMA_UDMA_UICR_DESC_MASK_SHIFT(reg) (((reg) & POGO_IDMA_UDMA_UICR_DESC_MASK) >> POGO_IDMA_UDMA_UICR_DESC_SHIFT)
#define  POGO_IDMA_UDMA_UICR_DESC_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA_UDMA_UICR_DESC_MASK) | (((uint32_t)val) << POGO_IDMA_UDMA_UICR_DESC_SHIFT))

#define  POGO_IDMA_UDMA_UICR_OWN_MASK 0x1
#define  POGO_IDMA_UDMA_UICR_OWN_SHIFT 0
#define  POGO_IDMA_UDMA_UICR_OWN_MASK_SHIFT(reg) (((reg) & POGO_IDMA_UDMA_UICR_OWN_MASK) >> POGO_IDMA_UDMA_UICR_OWN_SHIFT)
#define  POGO_IDMA_UDMA_UICR_OWN_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA_UDMA_UICR_OWN_MASK) | (((uint32_t)val) << POGO_IDMA_UDMA_UICR_OWN_SHIFT))

//====================================================================
//Register: UDMA Interrupt Force Register (UIFR)
//====================================================================

#define  POGO_IDMA_UDMA_UIFR_RESERVED1_MASK 0xffffffc0
#define  POGO_IDMA_UDMA_UIFR_RESERVED1_SHIFT 6
#define  POGO_IDMA_UDMA_UIFR_RESERVED1_MASK_SHIFT(reg) (((reg) & POGO_IDMA_UDMA_UIFR_RESERVED1_MASK) >> POGO_IDMA_UDMA_UIFR_RESERVED1_SHIFT)
#define  POGO_IDMA_UDMA_UIFR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA_UDMA_UIFR_RESERVED1_MASK) | (((uint32_t)val) << POGO_IDMA_UDMA_UIFR_RESERVED1_SHIFT))

#define  POGO_IDMA_UDMA_UIFR_OUTOFRANGE_MASK 0x20
#define  POGO_IDMA_UDMA_UIFR_OUTOFRANGE_SHIFT 5
#define  POGO_IDMA_UDMA_UIFR_OUTOFRANGE_MASK_SHIFT(reg) (((reg) & POGO_IDMA_UDMA_UIFR_OUTOFRANGE_MASK) >> POGO_IDMA_UDMA_UIFR_OUTOFRANGE_SHIFT)
#define  POGO_IDMA_UDMA_UIFR_OUTOFRANGE_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA_UDMA_UIFR_OUTOFRANGE_MASK) | (((uint32_t)val) << POGO_IDMA_UDMA_UIFR_OUTOFRANGE_SHIFT))

#define  POGO_IDMA_UDMA_UIFR_RRESP_MASK 0x10
#define  POGO_IDMA_UDMA_UIFR_RRESP_SHIFT 4
#define  POGO_IDMA_UDMA_UIFR_RRESP_MASK_SHIFT(reg) (((reg) & POGO_IDMA_UDMA_UIFR_RRESP_MASK) >> POGO_IDMA_UDMA_UIFR_RRESP_SHIFT)
#define  POGO_IDMA_UDMA_UIFR_RRESP_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA_UDMA_UIFR_RRESP_MASK) | (((uint32_t)val) << POGO_IDMA_UDMA_UIFR_RRESP_SHIFT))

#define  POGO_IDMA_UDMA_UIFR_BRESP_MASK 0x8
#define  POGO_IDMA_UDMA_UIFR_BRESP_SHIFT 3
#define  POGO_IDMA_UDMA_UIFR_BRESP_MASK_SHIFT(reg) (((reg) & POGO_IDMA_UDMA_UIFR_BRESP_MASK) >> POGO_IDMA_UDMA_UIFR_BRESP_SHIFT)
#define  POGO_IDMA_UDMA_UIFR_BRESP_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA_UDMA_UIFR_BRESP_MASK) | (((uint32_t)val) << POGO_IDMA_UDMA_UIFR_BRESP_SHIFT))

#define  POGO_IDMA_UDMA_UIFR_CLEARCOMPLETE_MASK 0x4
#define  POGO_IDMA_UDMA_UIFR_CLEARCOMPLETE_SHIFT 2
#define  POGO_IDMA_UDMA_UIFR_CLEARCOMPLETE_MASK_SHIFT(reg) (((reg) & POGO_IDMA_UDMA_UIFR_CLEARCOMPLETE_MASK) >> POGO_IDMA_UDMA_UIFR_CLEARCOMPLETE_SHIFT)
#define  POGO_IDMA_UDMA_UIFR_CLEARCOMPLETE_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA_UDMA_UIFR_CLEARCOMPLETE_MASK) | (((uint32_t)val) << POGO_IDMA_UDMA_UIFR_CLEARCOMPLETE_SHIFT))

#define  POGO_IDMA_UDMA_UIFR_DESC_MASK 0x2
#define  POGO_IDMA_UDMA_UIFR_DESC_SHIFT 1
#define  POGO_IDMA_UDMA_UIFR_DESC_MASK_SHIFT(reg) (((reg) & POGO_IDMA_UDMA_UIFR_DESC_MASK) >> POGO_IDMA_UDMA_UIFR_DESC_SHIFT)
#define  POGO_IDMA_UDMA_UIFR_DESC_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA_UDMA_UIFR_DESC_MASK) | (((uint32_t)val) << POGO_IDMA_UDMA_UIFR_DESC_SHIFT))

#define  POGO_IDMA_UDMA_UIFR_OWN_MASK 0x1
#define  POGO_IDMA_UDMA_UIFR_OWN_SHIFT 0
#define  POGO_IDMA_UDMA_UIFR_OWN_MASK_SHIFT(reg) (((reg) & POGO_IDMA_UDMA_UIFR_OWN_MASK) >> POGO_IDMA_UDMA_UIFR_OWN_SHIFT)
#define  POGO_IDMA_UDMA_UIFR_OWN_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA_UDMA_UIFR_OWN_MASK) | (((uint32_t)val) << POGO_IDMA_UDMA_UIFR_OWN_SHIFT))

//====================================================================
//Register: UDMA Descriptor Register (UDR)
//====================================================================

#define  POGO_IDMA_UDMA_UDR_DESC_MASK 0xffffffff
#define  POGO_IDMA_UDMA_UDR_DESC_SHIFT 0
#define  POGO_IDMA_UDMA_UDR_DESC_MASK_SHIFT(reg) (((reg) & POGO_IDMA_UDMA_UDR_DESC_MASK) >> POGO_IDMA_UDMA_UDR_DESC_SHIFT)
#define  POGO_IDMA_UDMA_UDR_DESC_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA_UDMA_UDR_DESC_MASK) | (((uint32_t)val) << POGO_IDMA_UDMA_UDR_DESC_SHIFT))

//====================================================================
//Register: UDMA Burst Address Register (UBAR)
//====================================================================

#define  POGO_IDMA_UDMA_UBAR_BURSTADDR_MASK 0xffffffff
#define  POGO_IDMA_UDMA_UBAR_BURSTADDR_SHIFT 0
#define  POGO_IDMA_UDMA_UBAR_BURSTADDR_MASK_SHIFT(reg) (((reg) & POGO_IDMA_UDMA_UBAR_BURSTADDR_MASK) >> POGO_IDMA_UDMA_UBAR_BURSTADDR_SHIFT)
#define  POGO_IDMA_UDMA_UBAR_BURSTADDR_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA_UDMA_UBAR_BURSTADDR_MASK) | (((uint32_t)val) << POGO_IDMA_UDMA_UBAR_BURSTADDR_SHIFT))

//====================================================================
//Register: UDMA Burst Length Register (UBLR)
//====================================================================

#define  POGO_IDMA_UDMA_UBLR_RESERVED1_MASK 0xfffffc00
#define  POGO_IDMA_UDMA_UBLR_RESERVED1_SHIFT 10
#define  POGO_IDMA_UDMA_UBLR_RESERVED1_MASK_SHIFT(reg) (((reg) & POGO_IDMA_UDMA_UBLR_RESERVED1_MASK) >> POGO_IDMA_UDMA_UBLR_RESERVED1_SHIFT)
#define  POGO_IDMA_UDMA_UBLR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA_UDMA_UBLR_RESERVED1_MASK) | (((uint32_t)val) << POGO_IDMA_UDMA_UBLR_RESERVED1_SHIFT))

#define  POGO_IDMA_UDMA_UBLR_BURSTDIR_MASK 0x200
#define  POGO_IDMA_UDMA_UBLR_BURSTDIR_SHIFT 9
#define  POGO_IDMA_UDMA_UBLR_BURSTDIR_MASK_SHIFT(reg) (((reg) & POGO_IDMA_UDMA_UBLR_BURSTDIR_MASK) >> POGO_IDMA_UDMA_UBLR_BURSTDIR_SHIFT)
#define  POGO_IDMA_UDMA_UBLR_BURSTDIR_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA_UDMA_UBLR_BURSTDIR_MASK) | (((uint32_t)val) << POGO_IDMA_UDMA_UBLR_BURSTDIR_SHIFT))

#define  POGO_IDMA_UDMA_UBLR_BURSTLAST_MASK 0x100
#define  POGO_IDMA_UDMA_UBLR_BURSTLAST_SHIFT 8
#define  POGO_IDMA_UDMA_UBLR_BURSTLAST_MASK_SHIFT(reg) (((reg) & POGO_IDMA_UDMA_UBLR_BURSTLAST_MASK) >> POGO_IDMA_UDMA_UBLR_BURSTLAST_SHIFT)
#define  POGO_IDMA_UDMA_UBLR_BURSTLAST_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA_UDMA_UBLR_BURSTLAST_MASK) | (((uint32_t)val) << POGO_IDMA_UDMA_UBLR_BURSTLAST_SHIFT))

#define  POGO_IDMA_UDMA_UBLR_BURSTLENGTH_MASK 0xff
#define  POGO_IDMA_UDMA_UBLR_BURSTLENGTH_SHIFT 0
#define  POGO_IDMA_UDMA_UBLR_BURSTLENGTH_MASK_SHIFT(reg) (((reg) & POGO_IDMA_UDMA_UBLR_BURSTLENGTH_MASK) >> POGO_IDMA_UDMA_UBLR_BURSTLENGTH_SHIFT)
#define  POGO_IDMA_UDMA_UBLR_BURSTLENGTH_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA_UDMA_UBLR_BURSTLENGTH_MASK) | (((uint32_t)val) << POGO_IDMA_UDMA_UBLR_BURSTLENGTH_SHIFT))

//====================================================================
//Register: UDMA Transfer Bytes Remaining Register (UBRR)
//====================================================================

#define  POGO_IDMA_UDMA_UBRR_BYTESREMAIN_MASK 0xffffffff
#define  POGO_IDMA_UDMA_UBRR_BYTESREMAIN_SHIFT 0
#define  POGO_IDMA_UDMA_UBRR_BYTESREMAIN_MASK_SHIFT(reg) (((reg) & POGO_IDMA_UDMA_UBRR_BYTESREMAIN_MASK) >> POGO_IDMA_UDMA_UBRR_BYTESREMAIN_SHIFT)
#define  POGO_IDMA_UDMA_UBRR_BYTESREMAIN_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA_UDMA_UBRR_BYTESREMAIN_MASK) | (((uint32_t)val) << POGO_IDMA_UDMA_UBRR_BYTESREMAIN_SHIFT))

//====================================================================
//Register: UDMA Tag Register 0 (UTR0)
//====================================================================

#define  POGO_IDMA_UDMA_UTR0_TAGMAJ_MASK 0xffff0000
#define  POGO_IDMA_UDMA_UTR0_TAGMAJ_SHIFT 16
#define  POGO_IDMA_UDMA_UTR0_TAGMAJ_MASK_SHIFT(reg) (((reg) & POGO_IDMA_UDMA_UTR0_TAGMAJ_MASK) >> POGO_IDMA_UDMA_UTR0_TAGMAJ_SHIFT)
#define  POGO_IDMA_UDMA_UTR0_TAGMAJ_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA_UDMA_UTR0_TAGMAJ_MASK) | (((uint32_t)val) << POGO_IDMA_UDMA_UTR0_TAGMAJ_SHIFT))

#define  POGO_IDMA_UDMA_UTR0_TAGMID_MASK 0xffff
#define  POGO_IDMA_UDMA_UTR0_TAGMID_SHIFT 0
#define  POGO_IDMA_UDMA_UTR0_TAGMID_MASK_SHIFT(reg) (((reg) & POGO_IDMA_UDMA_UTR0_TAGMID_MASK) >> POGO_IDMA_UDMA_UTR0_TAGMID_SHIFT)
#define  POGO_IDMA_UDMA_UTR0_TAGMID_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA_UDMA_UTR0_TAGMID_MASK) | (((uint32_t)val) << POGO_IDMA_UDMA_UTR0_TAGMID_SHIFT))

//====================================================================
//Register: UDMA Tag Register 1 (UTR1)
//====================================================================

#define  POGO_IDMA_UDMA_UTR1_RESERVED1_MASK 0xffff0000
#define  POGO_IDMA_UDMA_UTR1_RESERVED1_SHIFT 16
#define  POGO_IDMA_UDMA_UTR1_RESERVED1_MASK_SHIFT(reg) (((reg) & POGO_IDMA_UDMA_UTR1_RESERVED1_MASK) >> POGO_IDMA_UDMA_UTR1_RESERVED1_SHIFT)
#define  POGO_IDMA_UDMA_UTR1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA_UDMA_UTR1_RESERVED1_MASK) | (((uint32_t)val) << POGO_IDMA_UDMA_UTR1_RESERVED1_SHIFT))

#define  POGO_IDMA_UDMA_UTR1_TAGCFG_MASK 0xffff
#define  POGO_IDMA_UDMA_UTR1_TAGCFG_SHIFT 0
#define  POGO_IDMA_UDMA_UTR1_TAGCFG_MASK_SHIFT(reg) (((reg) & POGO_IDMA_UDMA_UTR1_TAGCFG_MASK) >> POGO_IDMA_UDMA_UTR1_TAGCFG_SHIFT)
#define  POGO_IDMA_UDMA_UTR1_TAGCFG_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA_UDMA_UTR1_TAGCFG_MASK) | (((uint32_t)val) << POGO_IDMA_UDMA_UTR1_TAGCFG_SHIFT))

//====================================================================
//
//Register File: POGO_IDMA_CORE (POGO_IDMA_CORE)
//
//====================================================================

//====================================================================
//Register: IDMA Configuration Register (ICR)
//====================================================================

#define  POGO_IDMA_CORE_ICR_RESERVED1_MASK 0xfffffffc
#define  POGO_IDMA_CORE_ICR_RESERVED1_SHIFT 2
#define  POGO_IDMA_CORE_ICR_RESERVED1_MASK_SHIFT(reg) (((reg) & POGO_IDMA_CORE_ICR_RESERVED1_MASK) >> POGO_IDMA_CORE_ICR_RESERVED1_SHIFT)
#define  POGO_IDMA_CORE_ICR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA_CORE_ICR_RESERVED1_MASK) | (((uint32_t)val) << POGO_IDMA_CORE_ICR_RESERVED1_SHIFT))

#define  POGO_IDMA_CORE_ICR_BURSTSIZE_MASK 0x3
#define  POGO_IDMA_CORE_ICR_BURSTSIZE_SHIFT 0
#define  POGO_IDMA_CORE_ICR_BURSTSIZE_MASK_SHIFT(reg) (((reg) & POGO_IDMA_CORE_ICR_BURSTSIZE_MASK) >> POGO_IDMA_CORE_ICR_BURSTSIZE_SHIFT)
#define  POGO_IDMA_CORE_ICR_BURSTSIZE_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA_CORE_ICR_BURSTSIZE_MASK) | (((uint32_t)val) << POGO_IDMA_CORE_ICR_BURSTSIZE_SHIFT))

//====================================================================
//Register: IDMA Interrupt Enable Register (IIER)
//====================================================================

#define  POGO_IDMA_CORE_IIER_RESERVED1_MASK 0xfffffffc
#define  POGO_IDMA_CORE_IIER_RESERVED1_SHIFT 2
#define  POGO_IDMA_CORE_IIER_RESERVED1_MASK_SHIFT(reg) (((reg) & POGO_IDMA_CORE_IIER_RESERVED1_MASK) >> POGO_IDMA_CORE_IIER_RESERVED1_SHIFT)
#define  POGO_IDMA_CORE_IIER_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA_CORE_IIER_RESERVED1_MASK) | (((uint32_t)val) << POGO_IDMA_CORE_IIER_RESERVED1_SHIFT))

#define  POGO_IDMA_CORE_IIER_LENGTHERR_MASK 0x2
#define  POGO_IDMA_CORE_IIER_LENGTHERR_SHIFT 1
#define  POGO_IDMA_CORE_IIER_LENGTHERR_MASK_SHIFT(reg) (((reg) & POGO_IDMA_CORE_IIER_LENGTHERR_MASK) >> POGO_IDMA_CORE_IIER_LENGTHERR_SHIFT)
#define  POGO_IDMA_CORE_IIER_LENGTHERR_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA_CORE_IIER_LENGTHERR_MASK) | (((uint32_t)val) << POGO_IDMA_CORE_IIER_LENGTHERR_SHIFT))

#define  POGO_IDMA_CORE_IIER_EOS_MASK 0x1
#define  POGO_IDMA_CORE_IIER_EOS_SHIFT 0
#define  POGO_IDMA_CORE_IIER_EOS_MASK_SHIFT(reg) (((reg) & POGO_IDMA_CORE_IIER_EOS_MASK) >> POGO_IDMA_CORE_IIER_EOS_SHIFT)
#define  POGO_IDMA_CORE_IIER_EOS_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA_CORE_IIER_EOS_MASK) | (((uint32_t)val) << POGO_IDMA_CORE_IIER_EOS_SHIFT))

//====================================================================
//Register: IDMA Interrupt Pending Register (IIPR)
//====================================================================

#define  POGO_IDMA_CORE_IIPR_RESERVED1_MASK 0xfffffffc
#define  POGO_IDMA_CORE_IIPR_RESERVED1_SHIFT 2
#define  POGO_IDMA_CORE_IIPR_RESERVED1_MASK_SHIFT(reg) (((reg) & POGO_IDMA_CORE_IIPR_RESERVED1_MASK) >> POGO_IDMA_CORE_IIPR_RESERVED1_SHIFT)
#define  POGO_IDMA_CORE_IIPR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA_CORE_IIPR_RESERVED1_MASK) | (((uint32_t)val) << POGO_IDMA_CORE_IIPR_RESERVED1_SHIFT))

#define  POGO_IDMA_CORE_IIPR_LENGTHERR_MASK 0x2
#define  POGO_IDMA_CORE_IIPR_LENGTHERR_SHIFT 1
#define  POGO_IDMA_CORE_IIPR_LENGTHERR_MASK_SHIFT(reg) (((reg) & POGO_IDMA_CORE_IIPR_LENGTHERR_MASK) >> POGO_IDMA_CORE_IIPR_LENGTHERR_SHIFT)
#define  POGO_IDMA_CORE_IIPR_LENGTHERR_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA_CORE_IIPR_LENGTHERR_MASK) | (((uint32_t)val) << POGO_IDMA_CORE_IIPR_LENGTHERR_SHIFT))

#define  POGO_IDMA_CORE_IIPR_EOS_MASK 0x1
#define  POGO_IDMA_CORE_IIPR_EOS_SHIFT 0
#define  POGO_IDMA_CORE_IIPR_EOS_MASK_SHIFT(reg) (((reg) & POGO_IDMA_CORE_IIPR_EOS_MASK) >> POGO_IDMA_CORE_IIPR_EOS_SHIFT)
#define  POGO_IDMA_CORE_IIPR_EOS_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA_CORE_IIPR_EOS_MASK) | (((uint32_t)val) << POGO_IDMA_CORE_IIPR_EOS_SHIFT))

//====================================================================
//Register: IDMA Interrupt Clear Register (IICR)
//====================================================================

#define  POGO_IDMA_CORE_IICR_RESERVED1_MASK 0xfffffffc
#define  POGO_IDMA_CORE_IICR_RESERVED1_SHIFT 2
#define  POGO_IDMA_CORE_IICR_RESERVED1_MASK_SHIFT(reg) (((reg) & POGO_IDMA_CORE_IICR_RESERVED1_MASK) >> POGO_IDMA_CORE_IICR_RESERVED1_SHIFT)
#define  POGO_IDMA_CORE_IICR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA_CORE_IICR_RESERVED1_MASK) | (((uint32_t)val) << POGO_IDMA_CORE_IICR_RESERVED1_SHIFT))

#define  POGO_IDMA_CORE_IICR_LENGTHERR_MASK 0x2
#define  POGO_IDMA_CORE_IICR_LENGTHERR_SHIFT 1
#define  POGO_IDMA_CORE_IICR_LENGTHERR_MASK_SHIFT(reg) (((reg) & POGO_IDMA_CORE_IICR_LENGTHERR_MASK) >> POGO_IDMA_CORE_IICR_LENGTHERR_SHIFT)
#define  POGO_IDMA_CORE_IICR_LENGTHERR_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA_CORE_IICR_LENGTHERR_MASK) | (((uint32_t)val) << POGO_IDMA_CORE_IICR_LENGTHERR_SHIFT))

#define  POGO_IDMA_CORE_IICR_EOS_MASK 0x1
#define  POGO_IDMA_CORE_IICR_EOS_SHIFT 0
#define  POGO_IDMA_CORE_IICR_EOS_MASK_SHIFT(reg) (((reg) & POGO_IDMA_CORE_IICR_EOS_MASK) >> POGO_IDMA_CORE_IICR_EOS_SHIFT)
#define  POGO_IDMA_CORE_IICR_EOS_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA_CORE_IICR_EOS_MASK) | (((uint32_t)val) << POGO_IDMA_CORE_IICR_EOS_SHIFT))

//====================================================================
//Register: IDMA Interrupt Force Register (IIFR)
//====================================================================

#define  POGO_IDMA_CORE_IIFR_RESERVED1_MASK 0xfffffffc
#define  POGO_IDMA_CORE_IIFR_RESERVED1_SHIFT 2
#define  POGO_IDMA_CORE_IIFR_RESERVED1_MASK_SHIFT(reg) (((reg) & POGO_IDMA_CORE_IIFR_RESERVED1_MASK) >> POGO_IDMA_CORE_IIFR_RESERVED1_SHIFT)
#define  POGO_IDMA_CORE_IIFR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA_CORE_IIFR_RESERVED1_MASK) | (((uint32_t)val) << POGO_IDMA_CORE_IIFR_RESERVED1_SHIFT))

#define  POGO_IDMA_CORE_IIFR_LENGTHERR_MASK 0x2
#define  POGO_IDMA_CORE_IIFR_LENGTHERR_SHIFT 1
#define  POGO_IDMA_CORE_IIFR_LENGTHERR_MASK_SHIFT(reg) (((reg) & POGO_IDMA_CORE_IIFR_LENGTHERR_MASK) >> POGO_IDMA_CORE_IIFR_LENGTHERR_SHIFT)
#define  POGO_IDMA_CORE_IIFR_LENGTHERR_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA_CORE_IIFR_LENGTHERR_MASK) | (((uint32_t)val) << POGO_IDMA_CORE_IIFR_LENGTHERR_SHIFT))

#define  POGO_IDMA_CORE_IIFR_EOS_MASK 0x1
#define  POGO_IDMA_CORE_IIFR_EOS_SHIFT 0
#define  POGO_IDMA_CORE_IIFR_EOS_MASK_SHIFT(reg) (((reg) & POGO_IDMA_CORE_IIFR_EOS_MASK) >> POGO_IDMA_CORE_IIFR_EOS_SHIFT)
#define  POGO_IDMA_CORE_IIFR_EOS_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA_CORE_IIFR_EOS_MASK) | (((uint32_t)val) << POGO_IDMA_CORE_IIFR_EOS_SHIFT))

//====================================================================
//Register: IDMA Line Width Register (ILWR)
//====================================================================

#define  POGO_IDMA_CORE_ILWR_RESERVED1_MASK 0xfff00000
#define  POGO_IDMA_CORE_ILWR_RESERVED1_SHIFT 20
#define  POGO_IDMA_CORE_ILWR_RESERVED1_MASK_SHIFT(reg) (((reg) & POGO_IDMA_CORE_ILWR_RESERVED1_MASK) >> POGO_IDMA_CORE_ILWR_RESERVED1_SHIFT)
#define  POGO_IDMA_CORE_ILWR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA_CORE_ILWR_RESERVED1_MASK) | (((uint32_t)val) << POGO_IDMA_CORE_ILWR_RESERVED1_SHIFT))

#define  POGO_IDMA_CORE_ILWR_LINEWIDTH_MASK 0xfffff
#define  POGO_IDMA_CORE_ILWR_LINEWIDTH_SHIFT 0
#define  POGO_IDMA_CORE_ILWR_LINEWIDTH_MASK_SHIFT(reg) (((reg) & POGO_IDMA_CORE_ILWR_LINEWIDTH_MASK) >> POGO_IDMA_CORE_ILWR_LINEWIDTH_SHIFT)
#define  POGO_IDMA_CORE_ILWR_LINEWIDTH_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA_CORE_ILWR_LINEWIDTH_MASK) | (((uint32_t)val) << POGO_IDMA_CORE_ILWR_LINEWIDTH_SHIFT))

//====================================================================
//Register: IDMA Row Height Register (IRHR)
//====================================================================

#define  POGO_IDMA_CORE_IRHR_RESERVED1_MASK 0xffffffc0
#define  POGO_IDMA_CORE_IRHR_RESERVED1_SHIFT 6
#define  POGO_IDMA_CORE_IRHR_RESERVED1_MASK_SHIFT(reg) (((reg) & POGO_IDMA_CORE_IRHR_RESERVED1_MASK) >> POGO_IDMA_CORE_IRHR_RESERVED1_SHIFT)
#define  POGO_IDMA_CORE_IRHR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA_CORE_IRHR_RESERVED1_MASK) | (((uint32_t)val) << POGO_IDMA_CORE_IRHR_RESERVED1_SHIFT))

#define  POGO_IDMA_CORE_IRHR_ROWHEIGHT_MASK 0x3f
#define  POGO_IDMA_CORE_IRHR_ROWHEIGHT_SHIFT 0
#define  POGO_IDMA_CORE_IRHR_ROWHEIGHT_MASK_SHIFT(reg) (((reg) & POGO_IDMA_CORE_IRHR_ROWHEIGHT_MASK) >> POGO_IDMA_CORE_IRHR_ROWHEIGHT_SHIFT)
#define  POGO_IDMA_CORE_IRHR_ROWHEIGHT_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA_CORE_IRHR_ROWHEIGHT_MASK) | (((uint32_t)val) << POGO_IDMA_CORE_IRHR_ROWHEIGHT_SHIFT))

//====================================================================
//Register: IDMA Tag Register 0 (ITR0)
//====================================================================

#define  POGO_IDMA_CORE_ITR0_RESERVED1_MASK 0xffff0000
#define  POGO_IDMA_CORE_ITR0_RESERVED1_SHIFT 16
#define  POGO_IDMA_CORE_ITR0_RESERVED1_MASK_SHIFT(reg) (((reg) & POGO_IDMA_CORE_ITR0_RESERVED1_MASK) >> POGO_IDMA_CORE_ITR0_RESERVED1_SHIFT)
#define  POGO_IDMA_CORE_ITR0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA_CORE_ITR0_RESERVED1_MASK) | (((uint32_t)val) << POGO_IDMA_CORE_ITR0_RESERVED1_SHIFT))

#define  POGO_IDMA_CORE_ITR0_TAGCFG_MASK 0xffff
#define  POGO_IDMA_CORE_ITR0_TAGCFG_SHIFT 0
#define  POGO_IDMA_CORE_ITR0_TAGCFG_MASK_SHIFT(reg) (((reg) & POGO_IDMA_CORE_ITR0_TAGCFG_MASK) >> POGO_IDMA_CORE_ITR0_TAGCFG_SHIFT)
#define  POGO_IDMA_CORE_ITR0_TAGCFG_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA_CORE_ITR0_TAGCFG_MASK) | (((uint32_t)val) << POGO_IDMA_CORE_ITR0_TAGCFG_SHIFT))

//====================================================================
//Register: IDMA Tag Register 1 (ITR1)
//====================================================================

#define  POGO_IDMA_CORE_ITR1_RESERVED1_MASK 0xffff0000
#define  POGO_IDMA_CORE_ITR1_RESERVED1_SHIFT 16
#define  POGO_IDMA_CORE_ITR1_RESERVED1_MASK_SHIFT(reg) (((reg) & POGO_IDMA_CORE_ITR1_RESERVED1_MASK) >> POGO_IDMA_CORE_ITR1_RESERVED1_SHIFT)
#define  POGO_IDMA_CORE_ITR1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA_CORE_ITR1_RESERVED1_MASK) | (((uint32_t)val) << POGO_IDMA_CORE_ITR1_RESERVED1_SHIFT))

#define  POGO_IDMA_CORE_ITR1_TAGMAJ_MASK 0xffff
#define  POGO_IDMA_CORE_ITR1_TAGMAJ_SHIFT 0
#define  POGO_IDMA_CORE_ITR1_TAGMAJ_MASK_SHIFT(reg) (((reg) & POGO_IDMA_CORE_ITR1_TAGMAJ_MASK) >> POGO_IDMA_CORE_ITR1_TAGMAJ_SHIFT)
#define  POGO_IDMA_CORE_ITR1_TAGMAJ_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA_CORE_ITR1_TAGMAJ_MASK) | (((uint32_t)val) << POGO_IDMA_CORE_ITR1_TAGMAJ_SHIFT))

//====================================================================
//Register: IDMA Tag Register 2 (ITR2)
//====================================================================

#define  POGO_IDMA_CORE_ITR2_RESERVED1_MASK 0xffff0000
#define  POGO_IDMA_CORE_ITR2_RESERVED1_SHIFT 16
#define  POGO_IDMA_CORE_ITR2_RESERVED1_MASK_SHIFT(reg) (((reg) & POGO_IDMA_CORE_ITR2_RESERVED1_MASK) >> POGO_IDMA_CORE_ITR2_RESERVED1_SHIFT)
#define  POGO_IDMA_CORE_ITR2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA_CORE_ITR2_RESERVED1_MASK) | (((uint32_t)val) << POGO_IDMA_CORE_ITR2_RESERVED1_SHIFT))

#define  POGO_IDMA_CORE_ITR2_TAGMID_MASK 0xffff
#define  POGO_IDMA_CORE_ITR2_TAGMID_SHIFT 0
#define  POGO_IDMA_CORE_ITR2_TAGMID_MASK_SHIFT(reg) (((reg) & POGO_IDMA_CORE_ITR2_TAGMID_MASK) >> POGO_IDMA_CORE_ITR2_TAGMID_SHIFT)
#define  POGO_IDMA_CORE_ITR2_TAGMID_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA_CORE_ITR2_TAGMID_MASK) | (((uint32_t)val) << POGO_IDMA_CORE_ITR2_TAGMID_SHIFT))

#endif // POGO_IDMA
