 /*
 **************************************************************************************
 *
 * (c) Copyright 2013 Marvell International Ltd.
 *
 *
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/.
 *
 **************************************************************************************
 *
 * \file PIP_STATS_regstructs.h
 * Generated using RegBuild 1.6.3
 *
 **************************************************************************************
 */

#ifndef _PIP_STATS_REGSTRUCTS_H_
#define _PIP_STATS_REGSTRUCTS_H_

#ifndef __KERNEL__
#include <stdint.h>
#endif

//====================================================================
//
//Register File: PIP_STATS (PIP_STATS)
/** \brief Register descriptions for the PIP_STATS block.*/
//
//====================================================================

typedef struct PIP_STATS_REGS_s
{
  volatile uint32_t ACR;  ///< 0x0 [R/W]: PIP_STATS Configuration Register
  volatile uint32_t reserved0;
  volatile uint32_t ASACR;  ///< 0x8 [R/W]: PIP_STATS Stats A Configuration Register
  volatile uint32_t ASBCR;  ///< 0xc [R/W]: PIP_STATS Stats B Configuration Register
  volatile uint32_t ASCCR;  ///< 0x10 [R/W]: PIP_STATS Stats C Configuration Register
  volatile uint32_t ASDCR;  ///< 0x14 [R/W]: PIP_STATS Stats D Configuration Register
  volatile uint32_t reserved1[2];
  volatile uint32_t AMM0R;  ///< 0x20 [R]: PIP_STATS Maximum Minimum 0 Register
  volatile uint32_t AMM1R;  ///< 0x24 [R]: PIP_STATS Maximum Minimum 1 Register
  volatile uint32_t AMM2R;  ///< 0x28 [R]: PIP_STATS Maximum Minimum 2 Register
  volatile uint32_t AMM3R;  ///< 0x2c [R]: PIP_STATS Maximum Minimum 3 Register
  volatile uint32_t AMM4R;  ///< 0x30 [R]: PIP_STATS Maximum Minimum 4 Register
  volatile uint32_t AMM5R;  ///< 0x34 [R]: PIP_STATS Maximum Minimum 5 Register
  volatile uint32_t AMM6R;  ///< 0x38 [R]: PIP_STATS Maximum Minimum 6 Register
  volatile uint32_t AMM7R;  ///< 0x3c [R]: PIP_STATS Maximum Minimum 7 Register
  volatile uint32_t AA0R;  ///< 0x40 [R]: PIP_STATS Accumulator 0 Register
  volatile uint32_t AA1R;  ///< 0x44 [R]: PIP_STATS Accumulator 1 Register
  volatile uint32_t AA2R;  ///< 0x48 [R]: PIP_STATS Accumulator 2 Register
  volatile uint32_t AA3R;  ///< 0x4c [R]: PIP_STATS Accumulator 3 Register
  volatile uint32_t AA4R;  ///< 0x50 [R]: PIP_STATS Accumulator 4 Register
  volatile uint32_t AA5R;  ///< 0x54 [R]: PIP_STATS Accumulator 5 Register
  volatile uint32_t AA6R;  ///< 0x58 [R]: PIP_STATS Accumulator 6 Register
  volatile uint32_t AA7R;  ///< 0x5c [R]: PIP_STATS Accumulator 7 Register
  volatile uint32_t ASR;  ///< 0x60 [R]: PIP_STATS Status Register
  volatile uint32_t AD0R;  ///< 0x64 [R]: PIP_STATS Debug Channel 0 Register
  volatile uint32_t AD1R;  ///< 0x68 [R]: PIP_STATS Debug Channel 1 Register
  volatile uint32_t AD2R;  ///< 0x6c [R]: PIP_STATS Debug Channel 2 Register
  volatile uint32_t AD3R;  ///< 0x70 [R]: PIP_STATS Debug Channel 3 Register
  volatile uint32_t AD4R;  ///< 0x74 [R]: PIP_STATS Debug Channel 4 Register
  volatile uint32_t AD5R;  ///< 0x78 [R]: PIP_STATS Debug Channel 5 Register
  volatile uint32_t AD6R;  ///< 0x7c [R]: PIP_STATS Debug Channel 6 Register
  volatile uint32_t AD7R;  ///< 0x80 [R]: PIP_STATS Debug Channel 7 Register
  volatile uint32_t SR0LR;  ///< 0x84 [R]: Save Restore Channel 0 Location Read
  volatile uint32_t SR1LR;  ///< 0x88 [R]: Save Restore Channel 1 Location Read
  volatile uint32_t SR2LR;  ///< 0x8c [R]: Save Restore Channel 2 Location Read
  volatile uint32_t SR3LR;  ///< 0x90 [R]: Save Restore Channel 3 Location Read
  volatile uint32_t SR4LR;  ///< 0x94 [R]: Save Restore Channel 4 Location Read
  volatile uint32_t SR5LR;  ///< 0x98 [R]: Save Restore Channel 5 Location Read
  volatile uint32_t SR6LR;  ///< 0x9c [R]: Save Restore Channel 6 Location Read
  volatile uint32_t SR7LR;  ///< 0xa0 [R]: Save Restore Channel 7 Location Read
  volatile uint32_t SR0CRA;  ///< 0xa4 [R]: Save Restore Channel 0 Chan Read A
  volatile uint32_t SR0CRB;  ///< 0xa8 [R]: Save Restore Channel 0 Chan Read B
  volatile uint32_t SR1CRA;  ///< 0xac [R]: Save Restore Channel 1 Chan Read A
  volatile uint32_t SR1CRB;  ///< 0xb0 [R]: Save Restore Channel 1 Chan Read B
  volatile uint32_t SR2CRA;  ///< 0xb4 [R]: Save Restore Channel 2 Chan Read A
  volatile uint32_t SR2CRB;  ///< 0xb8 [R]: Save Restore Channel 2 Chan Read B
  volatile uint32_t SR3CRA;  ///< 0xbc [R]: Save Restore Channel 3 Chan Read A
  volatile uint32_t SR3CRB;  ///< 0xc0 [R]: Save Restore Channel 3 Chan Read B
  volatile uint32_t SR4CRA;  ///< 0xc4 [R]: Save Restore Channel 4 Chan Read A
  volatile uint32_t SR4CRB;  ///< 0xc8 [R]: Save Restore Channel 4 Chan Read B
  volatile uint32_t SR5CRA;  ///< 0xcc [R]: Save Restore Channel 5 Chan Read A
  volatile uint32_t SR5CRB;  ///< 0xd0 [R]: Save Restore Channel 5 Chan Read B
  volatile uint32_t SR6CRA;  ///< 0xd4 [R]: Save Restore Channel 6 Chan Read A
  volatile uint32_t SR6CRB;  ///< 0xd8 [R]: Save Restore Channel 6 Chan Read B
  volatile uint32_t SR7CRA;  ///< 0xdc [R]: Save Restore Channel 7 Chan Read A
  volatile uint32_t SR7CRB;  ///< 0xe0 [R]: Save Restore Channel 7 Chan Read B
  volatile uint32_t SR0LW;  ///< 0xe4 [W]: Save Restore Channel 0 Location Write
  volatile uint32_t SR1LW;  ///< 0xe8 [W]: Save Restore Channel 1 Location Write
  volatile uint32_t SR2LW;  ///< 0xec [W]: Save Restore Channel 2 Location Write
  volatile uint32_t SR3LW;  ///< 0xf0 [W]: Save Restore Channel 3 Location Write
  volatile uint32_t SR4LW;  ///< 0xf4 [W]: Save Restore Channel 4 Location Write
  volatile uint32_t SR5LW;  ///< 0xf8 [W]: Save Restore Channel 5 Location Write
  volatile uint32_t SR6LW;  ///< 0xfc [W]: Save Restore Channel 6 Location Write
  volatile uint32_t SR7LW;  ///< 0x100 [W]: Save Restore Channel 7 Location Write
  volatile uint32_t SR0CWA;  ///< 0x104 [W]: Save Restore Channel 0 Chan Write A
  volatile uint32_t SR0CWB;  ///< 0x108 [W]: Save Restore Channel 0 Chan Write B
  volatile uint32_t SR1CWA;  ///< 0x10c [W]: Save Restore Channel 1 Chan Write A
  volatile uint32_t SR1CWB;  ///< 0x110 [W]: Save Restore Channel 1 Chan Write B
  volatile uint32_t SR2CWA;  ///< 0x114 [W]: Save Restore Channel 2 Chan Write A
  volatile uint32_t SR2CWB;  ///< 0x118 [W]: Save Restore Channel 2 Chan Write B
  volatile uint32_t SR3CWA;  ///< 0x11c [W]: Save Restore Channel 3 Chan Write A
  volatile uint32_t SR3CWB;  ///< 0x120 [W]: Save Restore Channel 3 Chan Write B
  volatile uint32_t SR4CWA;  ///< 0x124 [W]: Save Restore Channel 4 Chan Write A
  volatile uint32_t SR4CWB;  ///< 0x128 [W]: Save Restore Channel 4 Chan Write B
  volatile uint32_t SR5CWA;  ///< 0x12c [W]: Save Restore Channel 5 Chan Write A
  volatile uint32_t SR5CWB;  ///< 0x130 [W]: Save Restore Channel 5 Chan Write B
  volatile uint32_t SR6CWA;  ///< 0x134 [W]: Save Restore Channel 6 Chan Write A
  volatile uint32_t SR6CWB;  ///< 0x138 [W]: Save Restore Channel 6 Chan Write B
  volatile uint32_t SR7CWA;  ///< 0x13c [W]: Save Restore Channel 7 Chan Write A
  volatile uint32_t SR7CWB;  ///< 0x140 [W]: Save Restore Channel 7 Chan Write B
  volatile uint32_t REV0;  ///< 0x144 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0x148 [R]: IP Tagging Revision 1
} PIP_STATS_REGS_t;

#endif // PIP_STATS
