 /*
 **************************************************************************************
 *
 * (c) Copyright 2013 Marvell International Ltd.
 *
 *
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/.
 *
 **************************************************************************************
 *
 * \file PIP_STATS_regmasks.h
 * Generated using RegBuild 1.6.3
 *
 **************************************************************************************
 */

#ifndef _PIP_STATS_REGMASKS_H_
#define _PIP_STATS_REGMASKS_H_

#ifndef __KERNEL__
#include <stdint.h>
#endif

//====================================================================
//
//Register File: PIP_STATS (PIP_STATS)
/** \brief Register descriptions for the PIP_STATS block.*/
//
//====================================================================

//====================================================================
//Register: PIP_STATS Configuration Register (ACR)
/** \brief This register configures the general operation of the PIP_STATS block. If PIP_STATS is bypassed, the states of the internal state machines are reset, but register settings are preserved. The CPU access bit must be enabled to write the auto halftone LUT, and must be disabled before starting the block.*/
//====================================================================

#define  PIP_STATS_ACR_IMAGE_WIDTH_M1_MASK 0xffff0000
#define  PIP_STATS_ACR_IMAGE_WIDTH_M1_SHIFT 16
#define  PIP_STATS_ACR_IMAGE_WIDTH_M1_MASK_SHIFT(reg) (((reg) & PIP_STATS_ACR_IMAGE_WIDTH_M1_MASK) >> PIP_STATS_ACR_IMAGE_WIDTH_M1_SHIFT)
#define  PIP_STATS_ACR_IMAGE_WIDTH_M1_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_ACR_IMAGE_WIDTH_M1_MASK) | (((uint32_t)val) << PIP_STATS_ACR_IMAGE_WIDTH_M1_SHIFT))

#define  PIP_STATS_ACR_STATS_ENABLE_MASK 0xff00
#define  PIP_STATS_ACR_STATS_ENABLE_SHIFT 8
#define  PIP_STATS_ACR_STATS_ENABLE_MASK_SHIFT(reg) (((reg) & PIP_STATS_ACR_STATS_ENABLE_MASK) >> PIP_STATS_ACR_STATS_ENABLE_SHIFT)
#define  PIP_STATS_ACR_STATS_ENABLE_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_ACR_STATS_ENABLE_MASK) | (((uint32_t)val) << PIP_STATS_ACR_STATS_ENABLE_SHIFT))

#define  PIP_STATS_ACR_RESERVED1_MASK 0xfc
#define  PIP_STATS_ACR_RESERVED1_SHIFT 2
#define  PIP_STATS_ACR_RESERVED1_MASK_SHIFT(reg) (((reg) & PIP_STATS_ACR_RESERVED1_MASK) >> PIP_STATS_ACR_RESERVED1_SHIFT)
#define  PIP_STATS_ACR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_ACR_RESERVED1_MASK) | (((uint32_t)val) << PIP_STATS_ACR_RESERVED1_SHIFT))

#define  PIP_STATS_ACR_SAVE_RESTORE_MODE_MASK 0x2
#define  PIP_STATS_ACR_SAVE_RESTORE_MODE_SHIFT 1
#define  PIP_STATS_ACR_SAVE_RESTORE_MODE_MASK_SHIFT(reg) (((reg) & PIP_STATS_ACR_SAVE_RESTORE_MODE_MASK) >> PIP_STATS_ACR_SAVE_RESTORE_MODE_SHIFT)
#define  PIP_STATS_ACR_SAVE_RESTORE_MODE_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_ACR_SAVE_RESTORE_MODE_MASK) | (((uint32_t)val) << PIP_STATS_ACR_SAVE_RESTORE_MODE_SHIFT))

#define  PIP_STATS_ACR_BYPASS_ALL_MASK 0x1
#define  PIP_STATS_ACR_BYPASS_ALL_SHIFT 0
#define  PIP_STATS_ACR_BYPASS_ALL_MASK_SHIFT(reg) (((reg) & PIP_STATS_ACR_BYPASS_ALL_MASK) >> PIP_STATS_ACR_BYPASS_ALL_SHIFT)
#define  PIP_STATS_ACR_BYPASS_ALL_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_ACR_BYPASS_ALL_MASK) | (((uint32_t)val) << PIP_STATS_ACR_BYPASS_ALL_SHIFT))

//====================================================================
//Register: PIP_STATS Stats A Configuration Register (ASACR)
/** \brief This register configures the operation of stats ch0 and ch1 by setting channel thresholds and the swath height.*/
//====================================================================

#define  PIP_STATS_ASACR_RESERVED1_MASK 0xf0000000
#define  PIP_STATS_ASACR_RESERVED1_SHIFT 28
#define  PIP_STATS_ASACR_RESERVED1_MASK_SHIFT(reg) (((reg) & PIP_STATS_ASACR_RESERVED1_MASK) >> PIP_STATS_ASACR_RESERVED1_SHIFT)
#define  PIP_STATS_ASACR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_ASACR_RESERVED1_MASK) | (((uint32_t)val) << PIP_STATS_ASACR_RESERVED1_SHIFT))

#define  PIP_STATS_ASACR_CH1_THRESH_MASK 0xf000000
#define  PIP_STATS_ASACR_CH1_THRESH_SHIFT 24
#define  PIP_STATS_ASACR_CH1_THRESH_MASK_SHIFT(reg) (((reg) & PIP_STATS_ASACR_CH1_THRESH_MASK) >> PIP_STATS_ASACR_CH1_THRESH_SHIFT)
#define  PIP_STATS_ASACR_CH1_THRESH_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_ASACR_CH1_THRESH_MASK) | (((uint32_t)val) << PIP_STATS_ASACR_CH1_THRESH_SHIFT))

#define  PIP_STATS_ASACR_STATS_CH1_SWATH_HEIGHT_M1_MASK 0xff0000
#define  PIP_STATS_ASACR_STATS_CH1_SWATH_HEIGHT_M1_SHIFT 16
#define  PIP_STATS_ASACR_STATS_CH1_SWATH_HEIGHT_M1_MASK_SHIFT(reg) (((reg) & PIP_STATS_ASACR_STATS_CH1_SWATH_HEIGHT_M1_MASK) >> PIP_STATS_ASACR_STATS_CH1_SWATH_HEIGHT_M1_SHIFT)
#define  PIP_STATS_ASACR_STATS_CH1_SWATH_HEIGHT_M1_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_ASACR_STATS_CH1_SWATH_HEIGHT_M1_MASK) | (((uint32_t)val) << PIP_STATS_ASACR_STATS_CH1_SWATH_HEIGHT_M1_SHIFT))

#define  PIP_STATS_ASACR_RESERVED2_MASK 0xf000
#define  PIP_STATS_ASACR_RESERVED2_SHIFT 12
#define  PIP_STATS_ASACR_RESERVED2_MASK_SHIFT(reg) (((reg) & PIP_STATS_ASACR_RESERVED2_MASK) >> PIP_STATS_ASACR_RESERVED2_SHIFT)
#define  PIP_STATS_ASACR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_ASACR_RESERVED2_MASK) | (((uint32_t)val) << PIP_STATS_ASACR_RESERVED2_SHIFT))

#define  PIP_STATS_ASACR_CH0_THRESH_MASK 0xf00
#define  PIP_STATS_ASACR_CH0_THRESH_SHIFT 8
#define  PIP_STATS_ASACR_CH0_THRESH_MASK_SHIFT(reg) (((reg) & PIP_STATS_ASACR_CH0_THRESH_MASK) >> PIP_STATS_ASACR_CH0_THRESH_SHIFT)
#define  PIP_STATS_ASACR_CH0_THRESH_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_ASACR_CH0_THRESH_MASK) | (((uint32_t)val) << PIP_STATS_ASACR_CH0_THRESH_SHIFT))

#define  PIP_STATS_ASACR_STATS_CH0_SWATH_HEIGHT_M1_MASK 0xff
#define  PIP_STATS_ASACR_STATS_CH0_SWATH_HEIGHT_M1_SHIFT 0
#define  PIP_STATS_ASACR_STATS_CH0_SWATH_HEIGHT_M1_MASK_SHIFT(reg) (((reg) & PIP_STATS_ASACR_STATS_CH0_SWATH_HEIGHT_M1_MASK) >> PIP_STATS_ASACR_STATS_CH0_SWATH_HEIGHT_M1_SHIFT)
#define  PIP_STATS_ASACR_STATS_CH0_SWATH_HEIGHT_M1_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_ASACR_STATS_CH0_SWATH_HEIGHT_M1_MASK) | (((uint32_t)val) << PIP_STATS_ASACR_STATS_CH0_SWATH_HEIGHT_M1_SHIFT))

//====================================================================
//Register: PIP_STATS Stats B Configuration Register (ASBCR)
/** \brief This register configures the operation of stats ch2 and ch3 by setting channel thresholds and the swath height.*/
//====================================================================

#define  PIP_STATS_ASBCR_RESERVED1_MASK 0xf0000000
#define  PIP_STATS_ASBCR_RESERVED1_SHIFT 28
#define  PIP_STATS_ASBCR_RESERVED1_MASK_SHIFT(reg) (((reg) & PIP_STATS_ASBCR_RESERVED1_MASK) >> PIP_STATS_ASBCR_RESERVED1_SHIFT)
#define  PIP_STATS_ASBCR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_ASBCR_RESERVED1_MASK) | (((uint32_t)val) << PIP_STATS_ASBCR_RESERVED1_SHIFT))

#define  PIP_STATS_ASBCR_CH3_THRESH_MASK 0xf000000
#define  PIP_STATS_ASBCR_CH3_THRESH_SHIFT 24
#define  PIP_STATS_ASBCR_CH3_THRESH_MASK_SHIFT(reg) (((reg) & PIP_STATS_ASBCR_CH3_THRESH_MASK) >> PIP_STATS_ASBCR_CH3_THRESH_SHIFT)
#define  PIP_STATS_ASBCR_CH3_THRESH_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_ASBCR_CH3_THRESH_MASK) | (((uint32_t)val) << PIP_STATS_ASBCR_CH3_THRESH_SHIFT))

#define  PIP_STATS_ASBCR_STATS_CH3_SWATH_HEIGHT_M1_MASK 0xff0000
#define  PIP_STATS_ASBCR_STATS_CH3_SWATH_HEIGHT_M1_SHIFT 16
#define  PIP_STATS_ASBCR_STATS_CH3_SWATH_HEIGHT_M1_MASK_SHIFT(reg) (((reg) & PIP_STATS_ASBCR_STATS_CH3_SWATH_HEIGHT_M1_MASK) >> PIP_STATS_ASBCR_STATS_CH3_SWATH_HEIGHT_M1_SHIFT)
#define  PIP_STATS_ASBCR_STATS_CH3_SWATH_HEIGHT_M1_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_ASBCR_STATS_CH3_SWATH_HEIGHT_M1_MASK) | (((uint32_t)val) << PIP_STATS_ASBCR_STATS_CH3_SWATH_HEIGHT_M1_SHIFT))

#define  PIP_STATS_ASBCR_RESERVED2_MASK 0xf000
#define  PIP_STATS_ASBCR_RESERVED2_SHIFT 12
#define  PIP_STATS_ASBCR_RESERVED2_MASK_SHIFT(reg) (((reg) & PIP_STATS_ASBCR_RESERVED2_MASK) >> PIP_STATS_ASBCR_RESERVED2_SHIFT)
#define  PIP_STATS_ASBCR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_ASBCR_RESERVED2_MASK) | (((uint32_t)val) << PIP_STATS_ASBCR_RESERVED2_SHIFT))

#define  PIP_STATS_ASBCR_CH2_THRESH_MASK 0xf00
#define  PIP_STATS_ASBCR_CH2_THRESH_SHIFT 8
#define  PIP_STATS_ASBCR_CH2_THRESH_MASK_SHIFT(reg) (((reg) & PIP_STATS_ASBCR_CH2_THRESH_MASK) >> PIP_STATS_ASBCR_CH2_THRESH_SHIFT)
#define  PIP_STATS_ASBCR_CH2_THRESH_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_ASBCR_CH2_THRESH_MASK) | (((uint32_t)val) << PIP_STATS_ASBCR_CH2_THRESH_SHIFT))

#define  PIP_STATS_ASBCR_STATS_CH2_SWATH_HEIGHT_M1_MASK 0xff
#define  PIP_STATS_ASBCR_STATS_CH2_SWATH_HEIGHT_M1_SHIFT 0
#define  PIP_STATS_ASBCR_STATS_CH2_SWATH_HEIGHT_M1_MASK_SHIFT(reg) (((reg) & PIP_STATS_ASBCR_STATS_CH2_SWATH_HEIGHT_M1_MASK) >> PIP_STATS_ASBCR_STATS_CH2_SWATH_HEIGHT_M1_SHIFT)
#define  PIP_STATS_ASBCR_STATS_CH2_SWATH_HEIGHT_M1_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_ASBCR_STATS_CH2_SWATH_HEIGHT_M1_MASK) | (((uint32_t)val) << PIP_STATS_ASBCR_STATS_CH2_SWATH_HEIGHT_M1_SHIFT))

//====================================================================
//Register: PIP_STATS Stats C Configuration Register (ASCCR)
/** \brief This register configures the operation of stats ch4 and ch5 by setting channel thresholds and the swath height.*/
//====================================================================

#define  PIP_STATS_ASCCR_RESERVED1_MASK 0xf0000000
#define  PIP_STATS_ASCCR_RESERVED1_SHIFT 28
#define  PIP_STATS_ASCCR_RESERVED1_MASK_SHIFT(reg) (((reg) & PIP_STATS_ASCCR_RESERVED1_MASK) >> PIP_STATS_ASCCR_RESERVED1_SHIFT)
#define  PIP_STATS_ASCCR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_ASCCR_RESERVED1_MASK) | (((uint32_t)val) << PIP_STATS_ASCCR_RESERVED1_SHIFT))

#define  PIP_STATS_ASCCR_CH5_THRESH_MASK 0xf000000
#define  PIP_STATS_ASCCR_CH5_THRESH_SHIFT 24
#define  PIP_STATS_ASCCR_CH5_THRESH_MASK_SHIFT(reg) (((reg) & PIP_STATS_ASCCR_CH5_THRESH_MASK) >> PIP_STATS_ASCCR_CH5_THRESH_SHIFT)
#define  PIP_STATS_ASCCR_CH5_THRESH_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_ASCCR_CH5_THRESH_MASK) | (((uint32_t)val) << PIP_STATS_ASCCR_CH5_THRESH_SHIFT))

#define  PIP_STATS_ASCCR_STATS_CH5_SWATH_HEIGHT_M1_MASK 0xff0000
#define  PIP_STATS_ASCCR_STATS_CH5_SWATH_HEIGHT_M1_SHIFT 16
#define  PIP_STATS_ASCCR_STATS_CH5_SWATH_HEIGHT_M1_MASK_SHIFT(reg) (((reg) & PIP_STATS_ASCCR_STATS_CH5_SWATH_HEIGHT_M1_MASK) >> PIP_STATS_ASCCR_STATS_CH5_SWATH_HEIGHT_M1_SHIFT)
#define  PIP_STATS_ASCCR_STATS_CH5_SWATH_HEIGHT_M1_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_ASCCR_STATS_CH5_SWATH_HEIGHT_M1_MASK) | (((uint32_t)val) << PIP_STATS_ASCCR_STATS_CH5_SWATH_HEIGHT_M1_SHIFT))

#define  PIP_STATS_ASCCR_RESERVED2_MASK 0xf000
#define  PIP_STATS_ASCCR_RESERVED2_SHIFT 12
#define  PIP_STATS_ASCCR_RESERVED2_MASK_SHIFT(reg) (((reg) & PIP_STATS_ASCCR_RESERVED2_MASK) >> PIP_STATS_ASCCR_RESERVED2_SHIFT)
#define  PIP_STATS_ASCCR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_ASCCR_RESERVED2_MASK) | (((uint32_t)val) << PIP_STATS_ASCCR_RESERVED2_SHIFT))

#define  PIP_STATS_ASCCR_CH4_THRESH_MASK 0xf00
#define  PIP_STATS_ASCCR_CH4_THRESH_SHIFT 8
#define  PIP_STATS_ASCCR_CH4_THRESH_MASK_SHIFT(reg) (((reg) & PIP_STATS_ASCCR_CH4_THRESH_MASK) >> PIP_STATS_ASCCR_CH4_THRESH_SHIFT)
#define  PIP_STATS_ASCCR_CH4_THRESH_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_ASCCR_CH4_THRESH_MASK) | (((uint32_t)val) << PIP_STATS_ASCCR_CH4_THRESH_SHIFT))

#define  PIP_STATS_ASCCR_STATS_CH4_SWATH_HEIGHT_M1_MASK 0xff
#define  PIP_STATS_ASCCR_STATS_CH4_SWATH_HEIGHT_M1_SHIFT 0
#define  PIP_STATS_ASCCR_STATS_CH4_SWATH_HEIGHT_M1_MASK_SHIFT(reg) (((reg) & PIP_STATS_ASCCR_STATS_CH4_SWATH_HEIGHT_M1_MASK) >> PIP_STATS_ASCCR_STATS_CH4_SWATH_HEIGHT_M1_SHIFT)
#define  PIP_STATS_ASCCR_STATS_CH4_SWATH_HEIGHT_M1_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_ASCCR_STATS_CH4_SWATH_HEIGHT_M1_MASK) | (((uint32_t)val) << PIP_STATS_ASCCR_STATS_CH4_SWATH_HEIGHT_M1_SHIFT))

//====================================================================
//Register: PIP_STATS Stats D Configuration Register (ASDCR)
/** \brief This register configures the operation of stats ch6 and ch7 by setting channel thresholds and the swath height.*/
//====================================================================

#define  PIP_STATS_ASDCR_RESERVED1_MASK 0xf0000000
#define  PIP_STATS_ASDCR_RESERVED1_SHIFT 28
#define  PIP_STATS_ASDCR_RESERVED1_MASK_SHIFT(reg) (((reg) & PIP_STATS_ASDCR_RESERVED1_MASK) >> PIP_STATS_ASDCR_RESERVED1_SHIFT)
#define  PIP_STATS_ASDCR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_ASDCR_RESERVED1_MASK) | (((uint32_t)val) << PIP_STATS_ASDCR_RESERVED1_SHIFT))

#define  PIP_STATS_ASDCR_CH7_THRESH_MASK 0xf000000
#define  PIP_STATS_ASDCR_CH7_THRESH_SHIFT 24
#define  PIP_STATS_ASDCR_CH7_THRESH_MASK_SHIFT(reg) (((reg) & PIP_STATS_ASDCR_CH7_THRESH_MASK) >> PIP_STATS_ASDCR_CH7_THRESH_SHIFT)
#define  PIP_STATS_ASDCR_CH7_THRESH_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_ASDCR_CH7_THRESH_MASK) | (((uint32_t)val) << PIP_STATS_ASDCR_CH7_THRESH_SHIFT))

#define  PIP_STATS_ASDCR_STATS_CH7_SWATH_HEIGHT_M1_MASK 0xff0000
#define  PIP_STATS_ASDCR_STATS_CH7_SWATH_HEIGHT_M1_SHIFT 16
#define  PIP_STATS_ASDCR_STATS_CH7_SWATH_HEIGHT_M1_MASK_SHIFT(reg) (((reg) & PIP_STATS_ASDCR_STATS_CH7_SWATH_HEIGHT_M1_MASK) >> PIP_STATS_ASDCR_STATS_CH7_SWATH_HEIGHT_M1_SHIFT)
#define  PIP_STATS_ASDCR_STATS_CH7_SWATH_HEIGHT_M1_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_ASDCR_STATS_CH7_SWATH_HEIGHT_M1_MASK) | (((uint32_t)val) << PIP_STATS_ASDCR_STATS_CH7_SWATH_HEIGHT_M1_SHIFT))

#define  PIP_STATS_ASDCR_RESERVED2_MASK 0xf000
#define  PIP_STATS_ASDCR_RESERVED2_SHIFT 12
#define  PIP_STATS_ASDCR_RESERVED2_MASK_SHIFT(reg) (((reg) & PIP_STATS_ASDCR_RESERVED2_MASK) >> PIP_STATS_ASDCR_RESERVED2_SHIFT)
#define  PIP_STATS_ASDCR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_ASDCR_RESERVED2_MASK) | (((uint32_t)val) << PIP_STATS_ASDCR_RESERVED2_SHIFT))

#define  PIP_STATS_ASDCR_CH6_THRESH_MASK 0xf00
#define  PIP_STATS_ASDCR_CH6_THRESH_SHIFT 8
#define  PIP_STATS_ASDCR_CH6_THRESH_MASK_SHIFT(reg) (((reg) & PIP_STATS_ASDCR_CH6_THRESH_MASK) >> PIP_STATS_ASDCR_CH6_THRESH_SHIFT)
#define  PIP_STATS_ASDCR_CH6_THRESH_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_ASDCR_CH6_THRESH_MASK) | (((uint32_t)val) << PIP_STATS_ASDCR_CH6_THRESH_SHIFT))

#define  PIP_STATS_ASDCR_STATS_CH6_SWATH_HEIGHT_M1_MASK 0xff
#define  PIP_STATS_ASDCR_STATS_CH6_SWATH_HEIGHT_M1_SHIFT 0
#define  PIP_STATS_ASDCR_STATS_CH6_SWATH_HEIGHT_M1_MASK_SHIFT(reg) (((reg) & PIP_STATS_ASDCR_STATS_CH6_SWATH_HEIGHT_M1_MASK) >> PIP_STATS_ASDCR_STATS_CH6_SWATH_HEIGHT_M1_SHIFT)
#define  PIP_STATS_ASDCR_STATS_CH6_SWATH_HEIGHT_M1_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_ASDCR_STATS_CH6_SWATH_HEIGHT_M1_MASK) | (((uint32_t)val) << PIP_STATS_ASDCR_STATS_CH6_SWATH_HEIGHT_M1_SHIFT))

//====================================================================
//Register: PIP_STATS Maximum Minimum 0 Register (AMM0R)
/** \brief This register contains the maximum and minimum stat for the contone channel 0 for the current swath.*/
//====================================================================

#define  PIP_STATS_AMM0R_CH0_MAXIMUM_MASK 0xffff0000
#define  PIP_STATS_AMM0R_CH0_MAXIMUM_SHIFT 16
#define  PIP_STATS_AMM0R_CH0_MAXIMUM_MASK_SHIFT(reg) (((reg) & PIP_STATS_AMM0R_CH0_MAXIMUM_MASK) >> PIP_STATS_AMM0R_CH0_MAXIMUM_SHIFT)
#define  PIP_STATS_AMM0R_CH0_MAXIMUM_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_AMM0R_CH0_MAXIMUM_MASK) | (((uint32_t)val) << PIP_STATS_AMM0R_CH0_MAXIMUM_SHIFT))

#define  PIP_STATS_AMM0R_CH0_MINIMUM_MASK 0xffff
#define  PIP_STATS_AMM0R_CH0_MINIMUM_SHIFT 0
#define  PIP_STATS_AMM0R_CH0_MINIMUM_MASK_SHIFT(reg) (((reg) & PIP_STATS_AMM0R_CH0_MINIMUM_MASK) >> PIP_STATS_AMM0R_CH0_MINIMUM_SHIFT)
#define  PIP_STATS_AMM0R_CH0_MINIMUM_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_AMM0R_CH0_MINIMUM_MASK) | (((uint32_t)val) << PIP_STATS_AMM0R_CH0_MINIMUM_SHIFT))

//====================================================================
//Register: PIP_STATS Maximum Minimum 1 Register (AMM1R)
/** \brief This register contains the maximum and minimum stat for the contone channel 1 for the current swath.*/
//====================================================================

#define  PIP_STATS_AMM1R_CH1_MAXIMUM_MASK 0xffff0000
#define  PIP_STATS_AMM1R_CH1_MAXIMUM_SHIFT 16
#define  PIP_STATS_AMM1R_CH1_MAXIMUM_MASK_SHIFT(reg) (((reg) & PIP_STATS_AMM1R_CH1_MAXIMUM_MASK) >> PIP_STATS_AMM1R_CH1_MAXIMUM_SHIFT)
#define  PIP_STATS_AMM1R_CH1_MAXIMUM_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_AMM1R_CH1_MAXIMUM_MASK) | (((uint32_t)val) << PIP_STATS_AMM1R_CH1_MAXIMUM_SHIFT))

#define  PIP_STATS_AMM1R_CH1_MINIMUM_MASK 0xffff
#define  PIP_STATS_AMM1R_CH1_MINIMUM_SHIFT 0
#define  PIP_STATS_AMM1R_CH1_MINIMUM_MASK_SHIFT(reg) (((reg) & PIP_STATS_AMM1R_CH1_MINIMUM_MASK) >> PIP_STATS_AMM1R_CH1_MINIMUM_SHIFT)
#define  PIP_STATS_AMM1R_CH1_MINIMUM_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_AMM1R_CH1_MINIMUM_MASK) | (((uint32_t)val) << PIP_STATS_AMM1R_CH1_MINIMUM_SHIFT))

//====================================================================
//Register: PIP_STATS Maximum Minimum 2 Register (AMM2R)
/** \brief This register contains the maximum and minimum stat for the contone channel 2 for the current swath.*/
//====================================================================

#define  PIP_STATS_AMM2R_CH2_MAXIMUM_MASK 0xffff0000
#define  PIP_STATS_AMM2R_CH2_MAXIMUM_SHIFT 16
#define  PIP_STATS_AMM2R_CH2_MAXIMUM_MASK_SHIFT(reg) (((reg) & PIP_STATS_AMM2R_CH2_MAXIMUM_MASK) >> PIP_STATS_AMM2R_CH2_MAXIMUM_SHIFT)
#define  PIP_STATS_AMM2R_CH2_MAXIMUM_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_AMM2R_CH2_MAXIMUM_MASK) | (((uint32_t)val) << PIP_STATS_AMM2R_CH2_MAXIMUM_SHIFT))

#define  PIP_STATS_AMM2R_CH2_MINIMUM_MASK 0xffff
#define  PIP_STATS_AMM2R_CH2_MINIMUM_SHIFT 0
#define  PIP_STATS_AMM2R_CH2_MINIMUM_MASK_SHIFT(reg) (((reg) & PIP_STATS_AMM2R_CH2_MINIMUM_MASK) >> PIP_STATS_AMM2R_CH2_MINIMUM_SHIFT)
#define  PIP_STATS_AMM2R_CH2_MINIMUM_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_AMM2R_CH2_MINIMUM_MASK) | (((uint32_t)val) << PIP_STATS_AMM2R_CH2_MINIMUM_SHIFT))

//====================================================================
//Register: PIP_STATS Maximum Minimum 3 Register (AMM3R)
/** \brief This register contains the maximum and minimum stat for the contone channel 3 for the current swath.*/
//====================================================================

#define  PIP_STATS_AMM3R_CH3_MAXIMUM_MASK 0xffff0000
#define  PIP_STATS_AMM3R_CH3_MAXIMUM_SHIFT 16
#define  PIP_STATS_AMM3R_CH3_MAXIMUM_MASK_SHIFT(reg) (((reg) & PIP_STATS_AMM3R_CH3_MAXIMUM_MASK) >> PIP_STATS_AMM3R_CH3_MAXIMUM_SHIFT)
#define  PIP_STATS_AMM3R_CH3_MAXIMUM_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_AMM3R_CH3_MAXIMUM_MASK) | (((uint32_t)val) << PIP_STATS_AMM3R_CH3_MAXIMUM_SHIFT))

#define  PIP_STATS_AMM3R_CH3_MINIMUM_MASK 0xffff
#define  PIP_STATS_AMM3R_CH3_MINIMUM_SHIFT 0
#define  PIP_STATS_AMM3R_CH3_MINIMUM_MASK_SHIFT(reg) (((reg) & PIP_STATS_AMM3R_CH3_MINIMUM_MASK) >> PIP_STATS_AMM3R_CH3_MINIMUM_SHIFT)
#define  PIP_STATS_AMM3R_CH3_MINIMUM_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_AMM3R_CH3_MINIMUM_MASK) | (((uint32_t)val) << PIP_STATS_AMM3R_CH3_MINIMUM_SHIFT))

//====================================================================
//Register: PIP_STATS Maximum Minimum 4 Register (AMM4R)
/** \brief This register contains the maximum and minimum stat for the contone channel 4 for the current swath.*/
//====================================================================

#define  PIP_STATS_AMM4R_CH4_MAXIMUM_MASK 0xffff0000
#define  PIP_STATS_AMM4R_CH4_MAXIMUM_SHIFT 16
#define  PIP_STATS_AMM4R_CH4_MAXIMUM_MASK_SHIFT(reg) (((reg) & PIP_STATS_AMM4R_CH4_MAXIMUM_MASK) >> PIP_STATS_AMM4R_CH4_MAXIMUM_SHIFT)
#define  PIP_STATS_AMM4R_CH4_MAXIMUM_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_AMM4R_CH4_MAXIMUM_MASK) | (((uint32_t)val) << PIP_STATS_AMM4R_CH4_MAXIMUM_SHIFT))

#define  PIP_STATS_AMM4R_CH4_MINIMUM_MASK 0xffff
#define  PIP_STATS_AMM4R_CH4_MINIMUM_SHIFT 0
#define  PIP_STATS_AMM4R_CH4_MINIMUM_MASK_SHIFT(reg) (((reg) & PIP_STATS_AMM4R_CH4_MINIMUM_MASK) >> PIP_STATS_AMM4R_CH4_MINIMUM_SHIFT)
#define  PIP_STATS_AMM4R_CH4_MINIMUM_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_AMM4R_CH4_MINIMUM_MASK) | (((uint32_t)val) << PIP_STATS_AMM4R_CH4_MINIMUM_SHIFT))

//====================================================================
//Register: PIP_STATS Maximum Minimum 5 Register (AMM5R)
/** \brief This register contains the maximum and minimum stat for the contone channel 5 for the current swath.*/
//====================================================================

#define  PIP_STATS_AMM5R_CH5_MAXIMUM_MASK 0xffff0000
#define  PIP_STATS_AMM5R_CH5_MAXIMUM_SHIFT 16
#define  PIP_STATS_AMM5R_CH5_MAXIMUM_MASK_SHIFT(reg) (((reg) & PIP_STATS_AMM5R_CH5_MAXIMUM_MASK) >> PIP_STATS_AMM5R_CH5_MAXIMUM_SHIFT)
#define  PIP_STATS_AMM5R_CH5_MAXIMUM_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_AMM5R_CH5_MAXIMUM_MASK) | (((uint32_t)val) << PIP_STATS_AMM5R_CH5_MAXIMUM_SHIFT))

#define  PIP_STATS_AMM5R_CH5_MINIMUM_MASK 0xffff
#define  PIP_STATS_AMM5R_CH5_MINIMUM_SHIFT 0
#define  PIP_STATS_AMM5R_CH5_MINIMUM_MASK_SHIFT(reg) (((reg) & PIP_STATS_AMM5R_CH5_MINIMUM_MASK) >> PIP_STATS_AMM5R_CH5_MINIMUM_SHIFT)
#define  PIP_STATS_AMM5R_CH5_MINIMUM_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_AMM5R_CH5_MINIMUM_MASK) | (((uint32_t)val) << PIP_STATS_AMM5R_CH5_MINIMUM_SHIFT))

//====================================================================
//Register: PIP_STATS Maximum Minimum 6 Register (AMM6R)
/** \brief This register contains the maximum and minimum stat for the contone channel 6 for the current swath.*/
//====================================================================

#define  PIP_STATS_AMM6R_CH6_MAXIMUM_MASK 0xffff0000
#define  PIP_STATS_AMM6R_CH6_MAXIMUM_SHIFT 16
#define  PIP_STATS_AMM6R_CH6_MAXIMUM_MASK_SHIFT(reg) (((reg) & PIP_STATS_AMM6R_CH6_MAXIMUM_MASK) >> PIP_STATS_AMM6R_CH6_MAXIMUM_SHIFT)
#define  PIP_STATS_AMM6R_CH6_MAXIMUM_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_AMM6R_CH6_MAXIMUM_MASK) | (((uint32_t)val) << PIP_STATS_AMM6R_CH6_MAXIMUM_SHIFT))

#define  PIP_STATS_AMM6R_CH6_MINIMUM_MASK 0xffff
#define  PIP_STATS_AMM6R_CH6_MINIMUM_SHIFT 0
#define  PIP_STATS_AMM6R_CH6_MINIMUM_MASK_SHIFT(reg) (((reg) & PIP_STATS_AMM6R_CH6_MINIMUM_MASK) >> PIP_STATS_AMM6R_CH6_MINIMUM_SHIFT)
#define  PIP_STATS_AMM6R_CH6_MINIMUM_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_AMM6R_CH6_MINIMUM_MASK) | (((uint32_t)val) << PIP_STATS_AMM6R_CH6_MINIMUM_SHIFT))

//====================================================================
//Register: PIP_STATS Maximum Minimum 7 Register (AMM7R)
/** \brief This register contains the maximum and minimum stat for the contone channel 7 for the current swath.*/
//====================================================================

#define  PIP_STATS_AMM7R_CH7_MAXIMUM_MASK 0xffff0000
#define  PIP_STATS_AMM7R_CH7_MAXIMUM_SHIFT 16
#define  PIP_STATS_AMM7R_CH7_MAXIMUM_MASK_SHIFT(reg) (((reg) & PIP_STATS_AMM7R_CH7_MAXIMUM_MASK) >> PIP_STATS_AMM7R_CH7_MAXIMUM_SHIFT)
#define  PIP_STATS_AMM7R_CH7_MAXIMUM_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_AMM7R_CH7_MAXIMUM_MASK) | (((uint32_t)val) << PIP_STATS_AMM7R_CH7_MAXIMUM_SHIFT))

#define  PIP_STATS_AMM7R_CH7_MINIMUM_MASK 0xffff
#define  PIP_STATS_AMM7R_CH7_MINIMUM_SHIFT 0
#define  PIP_STATS_AMM7R_CH7_MINIMUM_MASK_SHIFT(reg) (((reg) & PIP_STATS_AMM7R_CH7_MINIMUM_MASK) >> PIP_STATS_AMM7R_CH7_MINIMUM_SHIFT)
#define  PIP_STATS_AMM7R_CH7_MINIMUM_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_AMM7R_CH7_MINIMUM_MASK) | (((uint32_t)val) << PIP_STATS_AMM7R_CH7_MINIMUM_SHIFT))

//====================================================================
//Register: PIP_STATS Accumulator 0 Register (AA0R)
/** \brief This is a saturating counter which accumulates the pixel values for the
      current swath.*/
//====================================================================

#define  PIP_STATS_AA0R_RESERVED1_MASK 0xf0000000
#define  PIP_STATS_AA0R_RESERVED1_SHIFT 28
#define  PIP_STATS_AA0R_RESERVED1_MASK_SHIFT(reg) (((reg) & PIP_STATS_AA0R_RESERVED1_MASK) >> PIP_STATS_AA0R_RESERVED1_SHIFT)
#define  PIP_STATS_AA0R_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_AA0R_RESERVED1_MASK) | (((uint32_t)val) << PIP_STATS_AA0R_RESERVED1_SHIFT))

#define  PIP_STATS_AA0R_ACCUM_0_MASK 0xfffffff
#define  PIP_STATS_AA0R_ACCUM_0_SHIFT 0
#define  PIP_STATS_AA0R_ACCUM_0_MASK_SHIFT(reg) (((reg) & PIP_STATS_AA0R_ACCUM_0_MASK) >> PIP_STATS_AA0R_ACCUM_0_SHIFT)
#define  PIP_STATS_AA0R_ACCUM_0_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_AA0R_ACCUM_0_MASK) | (((uint32_t)val) << PIP_STATS_AA0R_ACCUM_0_SHIFT))

//====================================================================
//Register: PIP_STATS Accumulator 1 Register (AA1R)
/** \brief This is a saturating counter which accumulates the pixel values for the
      current swath.*/
//====================================================================

#define  PIP_STATS_AA1R_RESERVED1_MASK 0xf0000000
#define  PIP_STATS_AA1R_RESERVED1_SHIFT 28
#define  PIP_STATS_AA1R_RESERVED1_MASK_SHIFT(reg) (((reg) & PIP_STATS_AA1R_RESERVED1_MASK) >> PIP_STATS_AA1R_RESERVED1_SHIFT)
#define  PIP_STATS_AA1R_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_AA1R_RESERVED1_MASK) | (((uint32_t)val) << PIP_STATS_AA1R_RESERVED1_SHIFT))

#define  PIP_STATS_AA1R_ACCUM_1_MASK 0xfffffff
#define  PIP_STATS_AA1R_ACCUM_1_SHIFT 0
#define  PIP_STATS_AA1R_ACCUM_1_MASK_SHIFT(reg) (((reg) & PIP_STATS_AA1R_ACCUM_1_MASK) >> PIP_STATS_AA1R_ACCUM_1_SHIFT)
#define  PIP_STATS_AA1R_ACCUM_1_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_AA1R_ACCUM_1_MASK) | (((uint32_t)val) << PIP_STATS_AA1R_ACCUM_1_SHIFT))

//====================================================================
//Register: PIP_STATS Accumulator 2 Register (AA2R)
/** \brief This is a saturating counter which accumulates the pixel values for the
      current swath.*/
//====================================================================

#define  PIP_STATS_AA2R_RESERVED1_MASK 0xf0000000
#define  PIP_STATS_AA2R_RESERVED1_SHIFT 28
#define  PIP_STATS_AA2R_RESERVED1_MASK_SHIFT(reg) (((reg) & PIP_STATS_AA2R_RESERVED1_MASK) >> PIP_STATS_AA2R_RESERVED1_SHIFT)
#define  PIP_STATS_AA2R_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_AA2R_RESERVED1_MASK) | (((uint32_t)val) << PIP_STATS_AA2R_RESERVED1_SHIFT))

#define  PIP_STATS_AA2R_ACCUM_2_MASK 0xfffffff
#define  PIP_STATS_AA2R_ACCUM_2_SHIFT 0
#define  PIP_STATS_AA2R_ACCUM_2_MASK_SHIFT(reg) (((reg) & PIP_STATS_AA2R_ACCUM_2_MASK) >> PIP_STATS_AA2R_ACCUM_2_SHIFT)
#define  PIP_STATS_AA2R_ACCUM_2_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_AA2R_ACCUM_2_MASK) | (((uint32_t)val) << PIP_STATS_AA2R_ACCUM_2_SHIFT))

//====================================================================
//Register: PIP_STATS Accumulator 3 Register (AA3R)
/** \brief This is a saturating counter which accumulates the pixel values for the
      current swath.*/
//====================================================================

#define  PIP_STATS_AA3R_RESERVED1_MASK 0xf0000000
#define  PIP_STATS_AA3R_RESERVED1_SHIFT 28
#define  PIP_STATS_AA3R_RESERVED1_MASK_SHIFT(reg) (((reg) & PIP_STATS_AA3R_RESERVED1_MASK) >> PIP_STATS_AA3R_RESERVED1_SHIFT)
#define  PIP_STATS_AA3R_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_AA3R_RESERVED1_MASK) | (((uint32_t)val) << PIP_STATS_AA3R_RESERVED1_SHIFT))

#define  PIP_STATS_AA3R_ACCUM_3_MASK 0xfffffff
#define  PIP_STATS_AA3R_ACCUM_3_SHIFT 0
#define  PIP_STATS_AA3R_ACCUM_3_MASK_SHIFT(reg) (((reg) & PIP_STATS_AA3R_ACCUM_3_MASK) >> PIP_STATS_AA3R_ACCUM_3_SHIFT)
#define  PIP_STATS_AA3R_ACCUM_3_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_AA3R_ACCUM_3_MASK) | (((uint32_t)val) << PIP_STATS_AA3R_ACCUM_3_SHIFT))

//====================================================================
//Register: PIP_STATS Accumulator 4 Register (AA4R)
/** \brief This is a saturating counter which accumulates the pixel values for the
      current swath.*/
//====================================================================

#define  PIP_STATS_AA4R_RESERVED1_MASK 0xf0000000
#define  PIP_STATS_AA4R_RESERVED1_SHIFT 28
#define  PIP_STATS_AA4R_RESERVED1_MASK_SHIFT(reg) (((reg) & PIP_STATS_AA4R_RESERVED1_MASK) >> PIP_STATS_AA4R_RESERVED1_SHIFT)
#define  PIP_STATS_AA4R_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_AA4R_RESERVED1_MASK) | (((uint32_t)val) << PIP_STATS_AA4R_RESERVED1_SHIFT))

#define  PIP_STATS_AA4R_ACCUM_4_MASK 0xfffffff
#define  PIP_STATS_AA4R_ACCUM_4_SHIFT 0
#define  PIP_STATS_AA4R_ACCUM_4_MASK_SHIFT(reg) (((reg) & PIP_STATS_AA4R_ACCUM_4_MASK) >> PIP_STATS_AA4R_ACCUM_4_SHIFT)
#define  PIP_STATS_AA4R_ACCUM_4_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_AA4R_ACCUM_4_MASK) | (((uint32_t)val) << PIP_STATS_AA4R_ACCUM_4_SHIFT))

//====================================================================
//Register: PIP_STATS Accumulator 5 Register (AA5R)
/** \brief This is a saturating counter which accumulates the pixel values for the
      current swath.*/
//====================================================================

#define  PIP_STATS_AA5R_RESERVED1_MASK 0xf0000000
#define  PIP_STATS_AA5R_RESERVED1_SHIFT 28
#define  PIP_STATS_AA5R_RESERVED1_MASK_SHIFT(reg) (((reg) & PIP_STATS_AA5R_RESERVED1_MASK) >> PIP_STATS_AA5R_RESERVED1_SHIFT)
#define  PIP_STATS_AA5R_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_AA5R_RESERVED1_MASK) | (((uint32_t)val) << PIP_STATS_AA5R_RESERVED1_SHIFT))

#define  PIP_STATS_AA5R_ACCUM_5_MASK 0xfffffff
#define  PIP_STATS_AA5R_ACCUM_5_SHIFT 0
#define  PIP_STATS_AA5R_ACCUM_5_MASK_SHIFT(reg) (((reg) & PIP_STATS_AA5R_ACCUM_5_MASK) >> PIP_STATS_AA5R_ACCUM_5_SHIFT)
#define  PIP_STATS_AA5R_ACCUM_5_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_AA5R_ACCUM_5_MASK) | (((uint32_t)val) << PIP_STATS_AA5R_ACCUM_5_SHIFT))

//====================================================================
//Register: PIP_STATS Accumulator 6 Register (AA6R)
/** \brief This is a saturating counter which accumulates the pixel values for the
      current swath.*/
//====================================================================

#define  PIP_STATS_AA6R_RESERVED1_MASK 0xf0000000
#define  PIP_STATS_AA6R_RESERVED1_SHIFT 28
#define  PIP_STATS_AA6R_RESERVED1_MASK_SHIFT(reg) (((reg) & PIP_STATS_AA6R_RESERVED1_MASK) >> PIP_STATS_AA6R_RESERVED1_SHIFT)
#define  PIP_STATS_AA6R_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_AA6R_RESERVED1_MASK) | (((uint32_t)val) << PIP_STATS_AA6R_RESERVED1_SHIFT))

#define  PIP_STATS_AA6R_ACCUM_6_MASK 0xfffffff
#define  PIP_STATS_AA6R_ACCUM_6_SHIFT 0
#define  PIP_STATS_AA6R_ACCUM_6_MASK_SHIFT(reg) (((reg) & PIP_STATS_AA6R_ACCUM_6_MASK) >> PIP_STATS_AA6R_ACCUM_6_SHIFT)
#define  PIP_STATS_AA6R_ACCUM_6_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_AA6R_ACCUM_6_MASK) | (((uint32_t)val) << PIP_STATS_AA6R_ACCUM_6_SHIFT))

//====================================================================
//Register: PIP_STATS Accumulator 7 Register (AA7R)
/** \brief This is a saturating counter which accumulates the pixel values for the
      current swath.*/
//====================================================================

#define  PIP_STATS_AA7R_RESERVED1_MASK 0xf0000000
#define  PIP_STATS_AA7R_RESERVED1_SHIFT 28
#define  PIP_STATS_AA7R_RESERVED1_MASK_SHIFT(reg) (((reg) & PIP_STATS_AA7R_RESERVED1_MASK) >> PIP_STATS_AA7R_RESERVED1_SHIFT)
#define  PIP_STATS_AA7R_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_AA7R_RESERVED1_MASK) | (((uint32_t)val) << PIP_STATS_AA7R_RESERVED1_SHIFT))

#define  PIP_STATS_AA7R_ACCUM_7_MASK 0xfffffff
#define  PIP_STATS_AA7R_ACCUM_7_SHIFT 0
#define  PIP_STATS_AA7R_ACCUM_7_MASK_SHIFT(reg) (((reg) & PIP_STATS_AA7R_ACCUM_7_MASK) >> PIP_STATS_AA7R_ACCUM_7_SHIFT)
#define  PIP_STATS_AA7R_ACCUM_7_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_AA7R_ACCUM_7_MASK) | (((uint32_t)val) << PIP_STATS_AA7R_ACCUM_7_SHIFT))

//====================================================================
//Register: PIP_STATS Status Register (ASR)
/** \brief This register contains status flags. If any of the flags are set, it means some type of error has occurred. All flags will be reset when a start-of-image (SOI) data type is detected.*/
//====================================================================

#define  PIP_STATS_ASR_RESERVED1_MASK 0xe0000000
#define  PIP_STATS_ASR_RESERVED1_SHIFT 29
#define  PIP_STATS_ASR_RESERVED1_MASK_SHIFT(reg) (((reg) & PIP_STATS_ASR_RESERVED1_MASK) >> PIP_STATS_ASR_RESERVED1_SHIFT)
#define  PIP_STATS_ASR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_ASR_RESERVED1_MASK) | (((uint32_t)val) << PIP_STATS_ASR_RESERVED1_SHIFT))

#define  PIP_STATS_ASR_LINE_CH7_WIDTH_MISMATCH_MASK 0x10000000
#define  PIP_STATS_ASR_LINE_CH7_WIDTH_MISMATCH_SHIFT 28
#define  PIP_STATS_ASR_LINE_CH7_WIDTH_MISMATCH_MASK_SHIFT(reg) (((reg) & PIP_STATS_ASR_LINE_CH7_WIDTH_MISMATCH_MASK) >> PIP_STATS_ASR_LINE_CH7_WIDTH_MISMATCH_SHIFT)
#define  PIP_STATS_ASR_LINE_CH7_WIDTH_MISMATCH_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_ASR_LINE_CH7_WIDTH_MISMATCH_MASK) | (((uint32_t)val) << PIP_STATS_ASR_LINE_CH7_WIDTH_MISMATCH_SHIFT))

#define  PIP_STATS_ASR_RESERVED2_MASK 0xe000000
#define  PIP_STATS_ASR_RESERVED2_SHIFT 25
#define  PIP_STATS_ASR_RESERVED2_MASK_SHIFT(reg) (((reg) & PIP_STATS_ASR_RESERVED2_MASK) >> PIP_STATS_ASR_RESERVED2_SHIFT)
#define  PIP_STATS_ASR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_ASR_RESERVED2_MASK) | (((uint32_t)val) << PIP_STATS_ASR_RESERVED2_SHIFT))

#define  PIP_STATS_ASR_LINE_CH6_WIDTH_MISMATCH_MASK 0x1000000
#define  PIP_STATS_ASR_LINE_CH6_WIDTH_MISMATCH_SHIFT 24
#define  PIP_STATS_ASR_LINE_CH6_WIDTH_MISMATCH_MASK_SHIFT(reg) (((reg) & PIP_STATS_ASR_LINE_CH6_WIDTH_MISMATCH_MASK) >> PIP_STATS_ASR_LINE_CH6_WIDTH_MISMATCH_SHIFT)
#define  PIP_STATS_ASR_LINE_CH6_WIDTH_MISMATCH_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_ASR_LINE_CH6_WIDTH_MISMATCH_MASK) | (((uint32_t)val) << PIP_STATS_ASR_LINE_CH6_WIDTH_MISMATCH_SHIFT))

#define  PIP_STATS_ASR_RESERVED3_MASK 0xe00000
#define  PIP_STATS_ASR_RESERVED3_SHIFT 21
#define  PIP_STATS_ASR_RESERVED3_MASK_SHIFT(reg) (((reg) & PIP_STATS_ASR_RESERVED3_MASK) >> PIP_STATS_ASR_RESERVED3_SHIFT)
#define  PIP_STATS_ASR_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_ASR_RESERVED3_MASK) | (((uint32_t)val) << PIP_STATS_ASR_RESERVED3_SHIFT))

#define  PIP_STATS_ASR_LINE_CH5_WIDTH_MISMATCH_MASK 0x100000
#define  PIP_STATS_ASR_LINE_CH5_WIDTH_MISMATCH_SHIFT 20
#define  PIP_STATS_ASR_LINE_CH5_WIDTH_MISMATCH_MASK_SHIFT(reg) (((reg) & PIP_STATS_ASR_LINE_CH5_WIDTH_MISMATCH_MASK) >> PIP_STATS_ASR_LINE_CH5_WIDTH_MISMATCH_SHIFT)
#define  PIP_STATS_ASR_LINE_CH5_WIDTH_MISMATCH_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_ASR_LINE_CH5_WIDTH_MISMATCH_MASK) | (((uint32_t)val) << PIP_STATS_ASR_LINE_CH5_WIDTH_MISMATCH_SHIFT))

#define  PIP_STATS_ASR_RESERVED4_MASK 0xe0000
#define  PIP_STATS_ASR_RESERVED4_SHIFT 17
#define  PIP_STATS_ASR_RESERVED4_MASK_SHIFT(reg) (((reg) & PIP_STATS_ASR_RESERVED4_MASK) >> PIP_STATS_ASR_RESERVED4_SHIFT)
#define  PIP_STATS_ASR_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_ASR_RESERVED4_MASK) | (((uint32_t)val) << PIP_STATS_ASR_RESERVED4_SHIFT))

#define  PIP_STATS_ASR_LINE_CH4_WIDTH_MISMATCH_MASK 0x10000
#define  PIP_STATS_ASR_LINE_CH4_WIDTH_MISMATCH_SHIFT 16
#define  PIP_STATS_ASR_LINE_CH4_WIDTH_MISMATCH_MASK_SHIFT(reg) (((reg) & PIP_STATS_ASR_LINE_CH4_WIDTH_MISMATCH_MASK) >> PIP_STATS_ASR_LINE_CH4_WIDTH_MISMATCH_SHIFT)
#define  PIP_STATS_ASR_LINE_CH4_WIDTH_MISMATCH_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_ASR_LINE_CH4_WIDTH_MISMATCH_MASK) | (((uint32_t)val) << PIP_STATS_ASR_LINE_CH4_WIDTH_MISMATCH_SHIFT))

#define  PIP_STATS_ASR_RESERVED5_MASK 0xe000
#define  PIP_STATS_ASR_RESERVED5_SHIFT 13
#define  PIP_STATS_ASR_RESERVED5_MASK_SHIFT(reg) (((reg) & PIP_STATS_ASR_RESERVED5_MASK) >> PIP_STATS_ASR_RESERVED5_SHIFT)
#define  PIP_STATS_ASR_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_ASR_RESERVED5_MASK) | (((uint32_t)val) << PIP_STATS_ASR_RESERVED5_SHIFT))

#define  PIP_STATS_ASR_LINE_CH3_WIDTH_MISMATCH_MASK 0x1000
#define  PIP_STATS_ASR_LINE_CH3_WIDTH_MISMATCH_SHIFT 12
#define  PIP_STATS_ASR_LINE_CH3_WIDTH_MISMATCH_MASK_SHIFT(reg) (((reg) & PIP_STATS_ASR_LINE_CH3_WIDTH_MISMATCH_MASK) >> PIP_STATS_ASR_LINE_CH3_WIDTH_MISMATCH_SHIFT)
#define  PIP_STATS_ASR_LINE_CH3_WIDTH_MISMATCH_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_ASR_LINE_CH3_WIDTH_MISMATCH_MASK) | (((uint32_t)val) << PIP_STATS_ASR_LINE_CH3_WIDTH_MISMATCH_SHIFT))

#define  PIP_STATS_ASR_RESERVED6_MASK 0xe00
#define  PIP_STATS_ASR_RESERVED6_SHIFT 9
#define  PIP_STATS_ASR_RESERVED6_MASK_SHIFT(reg) (((reg) & PIP_STATS_ASR_RESERVED6_MASK) >> PIP_STATS_ASR_RESERVED6_SHIFT)
#define  PIP_STATS_ASR_RESERVED6_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_ASR_RESERVED6_MASK) | (((uint32_t)val) << PIP_STATS_ASR_RESERVED6_SHIFT))

#define  PIP_STATS_ASR_LINE_CH2_WIDTH_MISMATCH_MASK 0x100
#define  PIP_STATS_ASR_LINE_CH2_WIDTH_MISMATCH_SHIFT 8
#define  PIP_STATS_ASR_LINE_CH2_WIDTH_MISMATCH_MASK_SHIFT(reg) (((reg) & PIP_STATS_ASR_LINE_CH2_WIDTH_MISMATCH_MASK) >> PIP_STATS_ASR_LINE_CH2_WIDTH_MISMATCH_SHIFT)
#define  PIP_STATS_ASR_LINE_CH2_WIDTH_MISMATCH_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_ASR_LINE_CH2_WIDTH_MISMATCH_MASK) | (((uint32_t)val) << PIP_STATS_ASR_LINE_CH2_WIDTH_MISMATCH_SHIFT))

#define  PIP_STATS_ASR_RESERVED7_MASK 0xe0
#define  PIP_STATS_ASR_RESERVED7_SHIFT 5
#define  PIP_STATS_ASR_RESERVED7_MASK_SHIFT(reg) (((reg) & PIP_STATS_ASR_RESERVED7_MASK) >> PIP_STATS_ASR_RESERVED7_SHIFT)
#define  PIP_STATS_ASR_RESERVED7_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_ASR_RESERVED7_MASK) | (((uint32_t)val) << PIP_STATS_ASR_RESERVED7_SHIFT))

#define  PIP_STATS_ASR_LINE_CH1_WIDTH_MISMATCH_MASK 0x10
#define  PIP_STATS_ASR_LINE_CH1_WIDTH_MISMATCH_SHIFT 4
#define  PIP_STATS_ASR_LINE_CH1_WIDTH_MISMATCH_MASK_SHIFT(reg) (((reg) & PIP_STATS_ASR_LINE_CH1_WIDTH_MISMATCH_MASK) >> PIP_STATS_ASR_LINE_CH1_WIDTH_MISMATCH_SHIFT)
#define  PIP_STATS_ASR_LINE_CH1_WIDTH_MISMATCH_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_ASR_LINE_CH1_WIDTH_MISMATCH_MASK) | (((uint32_t)val) << PIP_STATS_ASR_LINE_CH1_WIDTH_MISMATCH_SHIFT))

#define  PIP_STATS_ASR_RESERVED8_MASK 0xe
#define  PIP_STATS_ASR_RESERVED8_SHIFT 1
#define  PIP_STATS_ASR_RESERVED8_MASK_SHIFT(reg) (((reg) & PIP_STATS_ASR_RESERVED8_MASK) >> PIP_STATS_ASR_RESERVED8_SHIFT)
#define  PIP_STATS_ASR_RESERVED8_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_ASR_RESERVED8_MASK) | (((uint32_t)val) << PIP_STATS_ASR_RESERVED8_SHIFT))

#define  PIP_STATS_ASR_LINE_CH0_WIDTH_MISMATCH_MASK 0x1
#define  PIP_STATS_ASR_LINE_CH0_WIDTH_MISMATCH_SHIFT 0
#define  PIP_STATS_ASR_LINE_CH0_WIDTH_MISMATCH_MASK_SHIFT(reg) (((reg) & PIP_STATS_ASR_LINE_CH0_WIDTH_MISMATCH_MASK) >> PIP_STATS_ASR_LINE_CH0_WIDTH_MISMATCH_SHIFT)
#define  PIP_STATS_ASR_LINE_CH0_WIDTH_MISMATCH_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_ASR_LINE_CH0_WIDTH_MISMATCH_MASK) | (((uint32_t)val) << PIP_STATS_ASR_LINE_CH0_WIDTH_MISMATCH_SHIFT))

//====================================================================
//Register: PIP_STATS Debug Channel 0 Register (AD0R)
/** \brief This register exposes internal states that are used in the operation of the channel 0 of PIP_STATS_stats.*/
//====================================================================

#define  PIP_STATS_AD0R_RESERVED1_MASK 0xff000000
#define  PIP_STATS_AD0R_RESERVED1_SHIFT 24
#define  PIP_STATS_AD0R_RESERVED1_MASK_SHIFT(reg) (((reg) & PIP_STATS_AD0R_RESERVED1_MASK) >> PIP_STATS_AD0R_RESERVED1_SHIFT)
#define  PIP_STATS_AD0R_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_AD0R_RESERVED1_MASK) | (((uint32_t)val) << PIP_STATS_AD0R_RESERVED1_SHIFT))

#define  PIP_STATS_AD0R_STATS_CH0_ROW_COUNT_MASK 0xff0000
#define  PIP_STATS_AD0R_STATS_CH0_ROW_COUNT_SHIFT 16
#define  PIP_STATS_AD0R_STATS_CH0_ROW_COUNT_MASK_SHIFT(reg) (((reg) & PIP_STATS_AD0R_STATS_CH0_ROW_COUNT_MASK) >> PIP_STATS_AD0R_STATS_CH0_ROW_COUNT_SHIFT)
#define  PIP_STATS_AD0R_STATS_CH0_ROW_COUNT_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_AD0R_STATS_CH0_ROW_COUNT_MASK) | (((uint32_t)val) << PIP_STATS_AD0R_STATS_CH0_ROW_COUNT_SHIFT))

#define  PIP_STATS_AD0R_STATS_CH0_INDEX_MASK 0xffff
#define  PIP_STATS_AD0R_STATS_CH0_INDEX_SHIFT 0
#define  PIP_STATS_AD0R_STATS_CH0_INDEX_MASK_SHIFT(reg) (((reg) & PIP_STATS_AD0R_STATS_CH0_INDEX_MASK) >> PIP_STATS_AD0R_STATS_CH0_INDEX_SHIFT)
#define  PIP_STATS_AD0R_STATS_CH0_INDEX_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_AD0R_STATS_CH0_INDEX_MASK) | (((uint32_t)val) << PIP_STATS_AD0R_STATS_CH0_INDEX_SHIFT))

//====================================================================
//Register: PIP_STATS Debug Channel 1 Register (AD1R)
/** \brief This register exposes internal states that are used in the operation of the channel 1 of PIP_STATS_stats.*/
//====================================================================

#define  PIP_STATS_AD1R_RESERVED1_MASK 0xff000000
#define  PIP_STATS_AD1R_RESERVED1_SHIFT 24
#define  PIP_STATS_AD1R_RESERVED1_MASK_SHIFT(reg) (((reg) & PIP_STATS_AD1R_RESERVED1_MASK) >> PIP_STATS_AD1R_RESERVED1_SHIFT)
#define  PIP_STATS_AD1R_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_AD1R_RESERVED1_MASK) | (((uint32_t)val) << PIP_STATS_AD1R_RESERVED1_SHIFT))

#define  PIP_STATS_AD1R_STATS_CH1_ROW_COUNT_MASK 0xff0000
#define  PIP_STATS_AD1R_STATS_CH1_ROW_COUNT_SHIFT 16
#define  PIP_STATS_AD1R_STATS_CH1_ROW_COUNT_MASK_SHIFT(reg) (((reg) & PIP_STATS_AD1R_STATS_CH1_ROW_COUNT_MASK) >> PIP_STATS_AD1R_STATS_CH1_ROW_COUNT_SHIFT)
#define  PIP_STATS_AD1R_STATS_CH1_ROW_COUNT_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_AD1R_STATS_CH1_ROW_COUNT_MASK) | (((uint32_t)val) << PIP_STATS_AD1R_STATS_CH1_ROW_COUNT_SHIFT))

#define  PIP_STATS_AD1R_STATS_CH1_INDEX_MASK 0xffff
#define  PIP_STATS_AD1R_STATS_CH1_INDEX_SHIFT 0
#define  PIP_STATS_AD1R_STATS_CH1_INDEX_MASK_SHIFT(reg) (((reg) & PIP_STATS_AD1R_STATS_CH1_INDEX_MASK) >> PIP_STATS_AD1R_STATS_CH1_INDEX_SHIFT)
#define  PIP_STATS_AD1R_STATS_CH1_INDEX_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_AD1R_STATS_CH1_INDEX_MASK) | (((uint32_t)val) << PIP_STATS_AD1R_STATS_CH1_INDEX_SHIFT))

//====================================================================
//Register: PIP_STATS Debug Channel 2 Register (AD2R)
/** \brief This register exposes internal states that are used in the operation of the channel 2 of PIP_STATS_stats.*/
//====================================================================

#define  PIP_STATS_AD2R_RESERVED1_MASK 0xff000000
#define  PIP_STATS_AD2R_RESERVED1_SHIFT 24
#define  PIP_STATS_AD2R_RESERVED1_MASK_SHIFT(reg) (((reg) & PIP_STATS_AD2R_RESERVED1_MASK) >> PIP_STATS_AD2R_RESERVED1_SHIFT)
#define  PIP_STATS_AD2R_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_AD2R_RESERVED1_MASK) | (((uint32_t)val) << PIP_STATS_AD2R_RESERVED1_SHIFT))

#define  PIP_STATS_AD2R_STATS_CH2_ROW_COUNT_MASK 0xff0000
#define  PIP_STATS_AD2R_STATS_CH2_ROW_COUNT_SHIFT 16
#define  PIP_STATS_AD2R_STATS_CH2_ROW_COUNT_MASK_SHIFT(reg) (((reg) & PIP_STATS_AD2R_STATS_CH2_ROW_COUNT_MASK) >> PIP_STATS_AD2R_STATS_CH2_ROW_COUNT_SHIFT)
#define  PIP_STATS_AD2R_STATS_CH2_ROW_COUNT_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_AD2R_STATS_CH2_ROW_COUNT_MASK) | (((uint32_t)val) << PIP_STATS_AD2R_STATS_CH2_ROW_COUNT_SHIFT))

#define  PIP_STATS_AD2R_STATS_CH2_INDEX_MASK 0xffff
#define  PIP_STATS_AD2R_STATS_CH2_INDEX_SHIFT 0
#define  PIP_STATS_AD2R_STATS_CH2_INDEX_MASK_SHIFT(reg) (((reg) & PIP_STATS_AD2R_STATS_CH2_INDEX_MASK) >> PIP_STATS_AD2R_STATS_CH2_INDEX_SHIFT)
#define  PIP_STATS_AD2R_STATS_CH2_INDEX_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_AD2R_STATS_CH2_INDEX_MASK) | (((uint32_t)val) << PIP_STATS_AD2R_STATS_CH2_INDEX_SHIFT))

//====================================================================
//Register: PIP_STATS Debug Channel 3 Register (AD3R)
/** \brief This register exposes internal states that are used in the operation of the channel 3 of PIP_STATS_stats.*/
//====================================================================

#define  PIP_STATS_AD3R_RESERVED1_MASK 0xff000000
#define  PIP_STATS_AD3R_RESERVED1_SHIFT 24
#define  PIP_STATS_AD3R_RESERVED1_MASK_SHIFT(reg) (((reg) & PIP_STATS_AD3R_RESERVED1_MASK) >> PIP_STATS_AD3R_RESERVED1_SHIFT)
#define  PIP_STATS_AD3R_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_AD3R_RESERVED1_MASK) | (((uint32_t)val) << PIP_STATS_AD3R_RESERVED1_SHIFT))

#define  PIP_STATS_AD3R_STATS_CH3_ROW_COUNT_MASK 0xff0000
#define  PIP_STATS_AD3R_STATS_CH3_ROW_COUNT_SHIFT 16
#define  PIP_STATS_AD3R_STATS_CH3_ROW_COUNT_MASK_SHIFT(reg) (((reg) & PIP_STATS_AD3R_STATS_CH3_ROW_COUNT_MASK) >> PIP_STATS_AD3R_STATS_CH3_ROW_COUNT_SHIFT)
#define  PIP_STATS_AD3R_STATS_CH3_ROW_COUNT_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_AD3R_STATS_CH3_ROW_COUNT_MASK) | (((uint32_t)val) << PIP_STATS_AD3R_STATS_CH3_ROW_COUNT_SHIFT))

#define  PIP_STATS_AD3R_STATS_CH3_INDEX_MASK 0xffff
#define  PIP_STATS_AD3R_STATS_CH3_INDEX_SHIFT 0
#define  PIP_STATS_AD3R_STATS_CH3_INDEX_MASK_SHIFT(reg) (((reg) & PIP_STATS_AD3R_STATS_CH3_INDEX_MASK) >> PIP_STATS_AD3R_STATS_CH3_INDEX_SHIFT)
#define  PIP_STATS_AD3R_STATS_CH3_INDEX_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_AD3R_STATS_CH3_INDEX_MASK) | (((uint32_t)val) << PIP_STATS_AD3R_STATS_CH3_INDEX_SHIFT))

//====================================================================
//Register: PIP_STATS Debug Channel 4 Register (AD4R)
/** \brief This register exposes internal states that are used in the operation of the channel 4 of PIP_STATS_stats.*/
//====================================================================

#define  PIP_STATS_AD4R_RESERVED1_MASK 0xff000000
#define  PIP_STATS_AD4R_RESERVED1_SHIFT 24
#define  PIP_STATS_AD4R_RESERVED1_MASK_SHIFT(reg) (((reg) & PIP_STATS_AD4R_RESERVED1_MASK) >> PIP_STATS_AD4R_RESERVED1_SHIFT)
#define  PIP_STATS_AD4R_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_AD4R_RESERVED1_MASK) | (((uint32_t)val) << PIP_STATS_AD4R_RESERVED1_SHIFT))

#define  PIP_STATS_AD4R_STATS_CH4_ROW_COUNT_MASK 0xff0000
#define  PIP_STATS_AD4R_STATS_CH4_ROW_COUNT_SHIFT 16
#define  PIP_STATS_AD4R_STATS_CH4_ROW_COUNT_MASK_SHIFT(reg) (((reg) & PIP_STATS_AD4R_STATS_CH4_ROW_COUNT_MASK) >> PIP_STATS_AD4R_STATS_CH4_ROW_COUNT_SHIFT)
#define  PIP_STATS_AD4R_STATS_CH4_ROW_COUNT_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_AD4R_STATS_CH4_ROW_COUNT_MASK) | (((uint32_t)val) << PIP_STATS_AD4R_STATS_CH4_ROW_COUNT_SHIFT))

#define  PIP_STATS_AD4R_STATS_CH4_INDEX_MASK 0xffff
#define  PIP_STATS_AD4R_STATS_CH4_INDEX_SHIFT 0
#define  PIP_STATS_AD4R_STATS_CH4_INDEX_MASK_SHIFT(reg) (((reg) & PIP_STATS_AD4R_STATS_CH4_INDEX_MASK) >> PIP_STATS_AD4R_STATS_CH4_INDEX_SHIFT)
#define  PIP_STATS_AD4R_STATS_CH4_INDEX_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_AD4R_STATS_CH4_INDEX_MASK) | (((uint32_t)val) << PIP_STATS_AD4R_STATS_CH4_INDEX_SHIFT))

//====================================================================
//Register: PIP_STATS Debug Channel 5 Register (AD5R)
/** \brief This register exposes internal states that are used in the operation of the channel 5 of PIP_STATS_stats.*/
//====================================================================

#define  PIP_STATS_AD5R_RESERVED1_MASK 0xff000000
#define  PIP_STATS_AD5R_RESERVED1_SHIFT 24
#define  PIP_STATS_AD5R_RESERVED1_MASK_SHIFT(reg) (((reg) & PIP_STATS_AD5R_RESERVED1_MASK) >> PIP_STATS_AD5R_RESERVED1_SHIFT)
#define  PIP_STATS_AD5R_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_AD5R_RESERVED1_MASK) | (((uint32_t)val) << PIP_STATS_AD5R_RESERVED1_SHIFT))

#define  PIP_STATS_AD5R_STATS_CH5_ROW_COUNT_MASK 0xff0000
#define  PIP_STATS_AD5R_STATS_CH5_ROW_COUNT_SHIFT 16
#define  PIP_STATS_AD5R_STATS_CH5_ROW_COUNT_MASK_SHIFT(reg) (((reg) & PIP_STATS_AD5R_STATS_CH5_ROW_COUNT_MASK) >> PIP_STATS_AD5R_STATS_CH5_ROW_COUNT_SHIFT)
#define  PIP_STATS_AD5R_STATS_CH5_ROW_COUNT_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_AD5R_STATS_CH5_ROW_COUNT_MASK) | (((uint32_t)val) << PIP_STATS_AD5R_STATS_CH5_ROW_COUNT_SHIFT))

#define  PIP_STATS_AD5R_STATS_CH5_INDEX_MASK 0xffff
#define  PIP_STATS_AD5R_STATS_CH5_INDEX_SHIFT 0
#define  PIP_STATS_AD5R_STATS_CH5_INDEX_MASK_SHIFT(reg) (((reg) & PIP_STATS_AD5R_STATS_CH5_INDEX_MASK) >> PIP_STATS_AD5R_STATS_CH5_INDEX_SHIFT)
#define  PIP_STATS_AD5R_STATS_CH5_INDEX_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_AD5R_STATS_CH5_INDEX_MASK) | (((uint32_t)val) << PIP_STATS_AD5R_STATS_CH5_INDEX_SHIFT))

//====================================================================
//Register: PIP_STATS Debug Channel 6 Register (AD6R)
/** \brief This register exposes internal states that are used in the operation of the channel 6 of PIP_STATS_stats.*/
//====================================================================

#define  PIP_STATS_AD6R_RESERVED1_MASK 0xff000000
#define  PIP_STATS_AD6R_RESERVED1_SHIFT 24
#define  PIP_STATS_AD6R_RESERVED1_MASK_SHIFT(reg) (((reg) & PIP_STATS_AD6R_RESERVED1_MASK) >> PIP_STATS_AD6R_RESERVED1_SHIFT)
#define  PIP_STATS_AD6R_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_AD6R_RESERVED1_MASK) | (((uint32_t)val) << PIP_STATS_AD6R_RESERVED1_SHIFT))

#define  PIP_STATS_AD6R_STATS_CH6_ROW_COUNT_MASK 0xff0000
#define  PIP_STATS_AD6R_STATS_CH6_ROW_COUNT_SHIFT 16
#define  PIP_STATS_AD6R_STATS_CH6_ROW_COUNT_MASK_SHIFT(reg) (((reg) & PIP_STATS_AD6R_STATS_CH6_ROW_COUNT_MASK) >> PIP_STATS_AD6R_STATS_CH6_ROW_COUNT_SHIFT)
#define  PIP_STATS_AD6R_STATS_CH6_ROW_COUNT_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_AD6R_STATS_CH6_ROW_COUNT_MASK) | (((uint32_t)val) << PIP_STATS_AD6R_STATS_CH6_ROW_COUNT_SHIFT))

#define  PIP_STATS_AD6R_STATS_CH6_INDEX_MASK 0xffff
#define  PIP_STATS_AD6R_STATS_CH6_INDEX_SHIFT 0
#define  PIP_STATS_AD6R_STATS_CH6_INDEX_MASK_SHIFT(reg) (((reg) & PIP_STATS_AD6R_STATS_CH6_INDEX_MASK) >> PIP_STATS_AD6R_STATS_CH6_INDEX_SHIFT)
#define  PIP_STATS_AD6R_STATS_CH6_INDEX_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_AD6R_STATS_CH6_INDEX_MASK) | (((uint32_t)val) << PIP_STATS_AD6R_STATS_CH6_INDEX_SHIFT))

//====================================================================
//Register: PIP_STATS Debug Channel 7 Register (AD7R)
/** \brief This register exposes internal states that are used in the operation of the channel 7 of PIP_STATS_stats.*/
//====================================================================

#define  PIP_STATS_AD7R_RESERVED1_MASK 0xff000000
#define  PIP_STATS_AD7R_RESERVED1_SHIFT 24
#define  PIP_STATS_AD7R_RESERVED1_MASK_SHIFT(reg) (((reg) & PIP_STATS_AD7R_RESERVED1_MASK) >> PIP_STATS_AD7R_RESERVED1_SHIFT)
#define  PIP_STATS_AD7R_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_AD7R_RESERVED1_MASK) | (((uint32_t)val) << PIP_STATS_AD7R_RESERVED1_SHIFT))

#define  PIP_STATS_AD7R_STATS_CH7_ROW_COUNT_MASK 0xff0000
#define  PIP_STATS_AD7R_STATS_CH7_ROW_COUNT_SHIFT 16
#define  PIP_STATS_AD7R_STATS_CH7_ROW_COUNT_MASK_SHIFT(reg) (((reg) & PIP_STATS_AD7R_STATS_CH7_ROW_COUNT_MASK) >> PIP_STATS_AD7R_STATS_CH7_ROW_COUNT_SHIFT)
#define  PIP_STATS_AD7R_STATS_CH7_ROW_COUNT_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_AD7R_STATS_CH7_ROW_COUNT_MASK) | (((uint32_t)val) << PIP_STATS_AD7R_STATS_CH7_ROW_COUNT_SHIFT))

#define  PIP_STATS_AD7R_STATS_CH7_INDEX_MASK 0xffff
#define  PIP_STATS_AD7R_STATS_CH7_INDEX_SHIFT 0
#define  PIP_STATS_AD7R_STATS_CH7_INDEX_MASK_SHIFT(reg) (((reg) & PIP_STATS_AD7R_STATS_CH7_INDEX_MASK) >> PIP_STATS_AD7R_STATS_CH7_INDEX_SHIFT)
#define  PIP_STATS_AD7R_STATS_CH7_INDEX_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_AD7R_STATS_CH7_INDEX_MASK) | (((uint32_t)val) << PIP_STATS_AD7R_STATS_CH7_INDEX_SHIFT))

//====================================================================
//Register: Save Restore Channel 0 Location Read (SR0LR)
/** \brief Channel 0 Location State Machine Registers This register is provided for the save portion of save/restore functionality. [31:25] = 0, [24] = line_width_mismatch, [23:16] = y_index, [15:0] = x_index*/
//====================================================================

#define  PIP_STATS_SR0LR_SAVE_VAL_MASK 0xffffffff
#define  PIP_STATS_SR0LR_SAVE_VAL_SHIFT 0
#define  PIP_STATS_SR0LR_SAVE_VAL_MASK_SHIFT(reg) (((reg) & PIP_STATS_SR0LR_SAVE_VAL_MASK) >> PIP_STATS_SR0LR_SAVE_VAL_SHIFT)
#define  PIP_STATS_SR0LR_SAVE_VAL_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_SR0LR_SAVE_VAL_MASK) | (((uint32_t)val) << PIP_STATS_SR0LR_SAVE_VAL_SHIFT))

//====================================================================
//Register: Save Restore Channel 1 Location Read (SR1LR)
/** \brief Channel 1 Location State Machine Registers This register is provided for the save portion of save/restore functionality. [31:25] = 0, [24] = line_width_mismatch, [23:16] = y_index, [15:0] = x_index*/
//====================================================================

#define  PIP_STATS_SR1LR_SAVE_VAL_MASK 0xffffffff
#define  PIP_STATS_SR1LR_SAVE_VAL_SHIFT 0
#define  PIP_STATS_SR1LR_SAVE_VAL_MASK_SHIFT(reg) (((reg) & PIP_STATS_SR1LR_SAVE_VAL_MASK) >> PIP_STATS_SR1LR_SAVE_VAL_SHIFT)
#define  PIP_STATS_SR1LR_SAVE_VAL_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_SR1LR_SAVE_VAL_MASK) | (((uint32_t)val) << PIP_STATS_SR1LR_SAVE_VAL_SHIFT))

//====================================================================
//Register: Save Restore Channel 2 Location Read (SR2LR)
/** \brief Channel 2 Location State Machine Registers This register is provided for the save portion of save/restore functionality. [31:25] = 0, [24] = line_width_mismatch, [23:16] = y_index, [15:0] = x_index*/
//====================================================================

#define  PIP_STATS_SR2LR_SAVE_VAL_MASK 0xffffffff
#define  PIP_STATS_SR2LR_SAVE_VAL_SHIFT 0
#define  PIP_STATS_SR2LR_SAVE_VAL_MASK_SHIFT(reg) (((reg) & PIP_STATS_SR2LR_SAVE_VAL_MASK) >> PIP_STATS_SR2LR_SAVE_VAL_SHIFT)
#define  PIP_STATS_SR2LR_SAVE_VAL_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_SR2LR_SAVE_VAL_MASK) | (((uint32_t)val) << PIP_STATS_SR2LR_SAVE_VAL_SHIFT))

//====================================================================
//Register: Save Restore Channel 3 Location Read (SR3LR)
/** \brief Channel 3 Location State Machine Registers This register is provided for the save portion of save/restore functionality. [31:25] = 0, [24] = line_width_mismatch, [23:16] = y_index, [15:0] = x_index*/
//====================================================================

#define  PIP_STATS_SR3LR_SAVE_VAL_MASK 0xffffffff
#define  PIP_STATS_SR3LR_SAVE_VAL_SHIFT 0
#define  PIP_STATS_SR3LR_SAVE_VAL_MASK_SHIFT(reg) (((reg) & PIP_STATS_SR3LR_SAVE_VAL_MASK) >> PIP_STATS_SR3LR_SAVE_VAL_SHIFT)
#define  PIP_STATS_SR3LR_SAVE_VAL_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_SR3LR_SAVE_VAL_MASK) | (((uint32_t)val) << PIP_STATS_SR3LR_SAVE_VAL_SHIFT))

//====================================================================
//Register: Save Restore Channel 4 Location Read (SR4LR)
/** \brief Channel 4 Location State Machine Registers This register is provided for the save portion of save/restore functionality. [31:25] = 0, [24] = line_width_mismatch, [23:16] = y_index, [15:0] = x_index*/
//====================================================================

#define  PIP_STATS_SR4LR_SAVE_VAL_MASK 0xffffffff
#define  PIP_STATS_SR4LR_SAVE_VAL_SHIFT 0
#define  PIP_STATS_SR4LR_SAVE_VAL_MASK_SHIFT(reg) (((reg) & PIP_STATS_SR4LR_SAVE_VAL_MASK) >> PIP_STATS_SR4LR_SAVE_VAL_SHIFT)
#define  PIP_STATS_SR4LR_SAVE_VAL_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_SR4LR_SAVE_VAL_MASK) | (((uint32_t)val) << PIP_STATS_SR4LR_SAVE_VAL_SHIFT))

//====================================================================
//Register: Save Restore Channel 5 Location Read (SR5LR)
/** \brief Channel 5 Location State Machine Registers This register is provided for the save portion of save/restore functionality. [31:25] = 0, [24] = line_width_mismatch, [23:16] = y_index, [15:0] = x_index*/
//====================================================================

#define  PIP_STATS_SR5LR_SAVE_VAL_MASK 0xffffffff
#define  PIP_STATS_SR5LR_SAVE_VAL_SHIFT 0
#define  PIP_STATS_SR5LR_SAVE_VAL_MASK_SHIFT(reg) (((reg) & PIP_STATS_SR5LR_SAVE_VAL_MASK) >> PIP_STATS_SR5LR_SAVE_VAL_SHIFT)
#define  PIP_STATS_SR5LR_SAVE_VAL_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_SR5LR_SAVE_VAL_MASK) | (((uint32_t)val) << PIP_STATS_SR5LR_SAVE_VAL_SHIFT))

//====================================================================
//Register: Save Restore Channel 6 Location Read (SR6LR)
/** \brief Channel 6 Location State Machine Registers This register is provided for the save portion of save/restore functionality. [31:25] = 0, [24] = line_width_mismatch, [23:16] = y_index, [15:0] = x_index*/
//====================================================================

#define  PIP_STATS_SR6LR_SAVE_VAL_MASK 0xffffffff
#define  PIP_STATS_SR6LR_SAVE_VAL_SHIFT 0
#define  PIP_STATS_SR6LR_SAVE_VAL_MASK_SHIFT(reg) (((reg) & PIP_STATS_SR6LR_SAVE_VAL_MASK) >> PIP_STATS_SR6LR_SAVE_VAL_SHIFT)
#define  PIP_STATS_SR6LR_SAVE_VAL_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_SR6LR_SAVE_VAL_MASK) | (((uint32_t)val) << PIP_STATS_SR6LR_SAVE_VAL_SHIFT))

//====================================================================
//Register: Save Restore Channel 7 Location Read (SR7LR)
/** \brief Channel 7 Location State Machine Registers This register is provided for the save portion of save/restore functionality. [31:25] = 0, [24] = line_width_mismatch, [23:16] = y_index, [15:0] = x_index*/
//====================================================================

#define  PIP_STATS_SR7LR_SAVE_VAL_MASK 0xffffffff
#define  PIP_STATS_SR7LR_SAVE_VAL_SHIFT 0
#define  PIP_STATS_SR7LR_SAVE_VAL_MASK_SHIFT(reg) (((reg) & PIP_STATS_SR7LR_SAVE_VAL_MASK) >> PIP_STATS_SR7LR_SAVE_VAL_SHIFT)
#define  PIP_STATS_SR7LR_SAVE_VAL_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_SR7LR_SAVE_VAL_MASK) | (((uint32_t)val) << PIP_STATS_SR7LR_SAVE_VAL_SHIFT))

//====================================================================
//Register: Save Restore Channel 0 Chan Read A (SR0CRA)
/** \brief Channel 0 Chan State Machine Registers This register is provided for the save portion of save/restore functionality. [31:16] = curr_max, [15:0] = curr_min*/
//====================================================================

#define  PIP_STATS_SR0CRA_SAVE_VAL_MASK 0xffffffff
#define  PIP_STATS_SR0CRA_SAVE_VAL_SHIFT 0
#define  PIP_STATS_SR0CRA_SAVE_VAL_MASK_SHIFT(reg) (((reg) & PIP_STATS_SR0CRA_SAVE_VAL_MASK) >> PIP_STATS_SR0CRA_SAVE_VAL_SHIFT)
#define  PIP_STATS_SR0CRA_SAVE_VAL_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_SR0CRA_SAVE_VAL_MASK) | (((uint32_t)val) << PIP_STATS_SR0CRA_SAVE_VAL_SHIFT))

//====================================================================
//Register: Save Restore Channel 0 Chan Read B (SR0CRB)
/** \brief Channel 0 Chan State Machine Registers This register is provided for the save portion of save/restore functionality. [31:28] = 0, [27:0] = curr_accum*/
//====================================================================

#define  PIP_STATS_SR0CRB_SAVE_VAL_MASK 0xffffffff
#define  PIP_STATS_SR0CRB_SAVE_VAL_SHIFT 0
#define  PIP_STATS_SR0CRB_SAVE_VAL_MASK_SHIFT(reg) (((reg) & PIP_STATS_SR0CRB_SAVE_VAL_MASK) >> PIP_STATS_SR0CRB_SAVE_VAL_SHIFT)
#define  PIP_STATS_SR0CRB_SAVE_VAL_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_SR0CRB_SAVE_VAL_MASK) | (((uint32_t)val) << PIP_STATS_SR0CRB_SAVE_VAL_SHIFT))

//====================================================================
//Register: Save Restore Channel 1 Chan Read A (SR1CRA)
/** \brief Channel 1 Chan State Machine Registers This register is provided for the save portion of save/restore functionality. [31:16] = curr_max, [15:0] = curr_min*/
//====================================================================

#define  PIP_STATS_SR1CRA_SAVE_VAL_MASK 0xffffffff
#define  PIP_STATS_SR1CRA_SAVE_VAL_SHIFT 0
#define  PIP_STATS_SR1CRA_SAVE_VAL_MASK_SHIFT(reg) (((reg) & PIP_STATS_SR1CRA_SAVE_VAL_MASK) >> PIP_STATS_SR1CRA_SAVE_VAL_SHIFT)
#define  PIP_STATS_SR1CRA_SAVE_VAL_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_SR1CRA_SAVE_VAL_MASK) | (((uint32_t)val) << PIP_STATS_SR1CRA_SAVE_VAL_SHIFT))

//====================================================================
//Register: Save Restore Channel 1 Chan Read B (SR1CRB)
/** \brief Channel 1 Chan State Machine Registers This register is provided for the save portion of save/restore functionality. [31:28] = 0, [27:0] = curr_accum*/
//====================================================================

#define  PIP_STATS_SR1CRB_SAVE_VAL_MASK 0xffffffff
#define  PIP_STATS_SR1CRB_SAVE_VAL_SHIFT 0
#define  PIP_STATS_SR1CRB_SAVE_VAL_MASK_SHIFT(reg) (((reg) & PIP_STATS_SR1CRB_SAVE_VAL_MASK) >> PIP_STATS_SR1CRB_SAVE_VAL_SHIFT)
#define  PIP_STATS_SR1CRB_SAVE_VAL_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_SR1CRB_SAVE_VAL_MASK) | (((uint32_t)val) << PIP_STATS_SR1CRB_SAVE_VAL_SHIFT))

//====================================================================
//Register: Save Restore Channel 2 Chan Read A (SR2CRA)
/** \brief Channel 2 Chan State Machine Registers This register is provided for the save portion of save/restore functionality. [31:16] = curr_max, [15:0] = curr_min*/
//====================================================================

#define  PIP_STATS_SR2CRA_SAVE_VAL_MASK 0xffffffff
#define  PIP_STATS_SR2CRA_SAVE_VAL_SHIFT 0
#define  PIP_STATS_SR2CRA_SAVE_VAL_MASK_SHIFT(reg) (((reg) & PIP_STATS_SR2CRA_SAVE_VAL_MASK) >> PIP_STATS_SR2CRA_SAVE_VAL_SHIFT)
#define  PIP_STATS_SR2CRA_SAVE_VAL_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_SR2CRA_SAVE_VAL_MASK) | (((uint32_t)val) << PIP_STATS_SR2CRA_SAVE_VAL_SHIFT))

//====================================================================
//Register: Save Restore Channel 2 Chan Read B (SR2CRB)
/** \brief Channel 2 Chan State Machine Registers This register is provided for the save portion of save/restore functionality. [31:28] = 0, [27:0] = curr_accum*/
//====================================================================

#define  PIP_STATS_SR2CRB_SAVE_VAL_MASK 0xffffffff
#define  PIP_STATS_SR2CRB_SAVE_VAL_SHIFT 0
#define  PIP_STATS_SR2CRB_SAVE_VAL_MASK_SHIFT(reg) (((reg) & PIP_STATS_SR2CRB_SAVE_VAL_MASK) >> PIP_STATS_SR2CRB_SAVE_VAL_SHIFT)
#define  PIP_STATS_SR2CRB_SAVE_VAL_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_SR2CRB_SAVE_VAL_MASK) | (((uint32_t)val) << PIP_STATS_SR2CRB_SAVE_VAL_SHIFT))

//====================================================================
//Register: Save Restore Channel 3 Chan Read A (SR3CRA)
/** \brief Channel 3 Chan State Machine Registers This register is provided for the save portion of save/restore functionality. [31:16] = curr_max, [15:0] = curr_min*/
//====================================================================

#define  PIP_STATS_SR3CRA_SAVE_VAL_MASK 0xffffffff
#define  PIP_STATS_SR3CRA_SAVE_VAL_SHIFT 0
#define  PIP_STATS_SR3CRA_SAVE_VAL_MASK_SHIFT(reg) (((reg) & PIP_STATS_SR3CRA_SAVE_VAL_MASK) >> PIP_STATS_SR3CRA_SAVE_VAL_SHIFT)
#define  PIP_STATS_SR3CRA_SAVE_VAL_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_SR3CRA_SAVE_VAL_MASK) | (((uint32_t)val) << PIP_STATS_SR3CRA_SAVE_VAL_SHIFT))

//====================================================================
//Register: Save Restore Channel 3 Chan Read B (SR3CRB)
/** \brief Channel 3 Chan State Machine Registers This register is provided for the save portion of save/restore functionality. [31:28] = 0, [27:0] = curr_accum*/
//====================================================================

#define  PIP_STATS_SR3CRB_SAVE_VAL_MASK 0xffffffff
#define  PIP_STATS_SR3CRB_SAVE_VAL_SHIFT 0
#define  PIP_STATS_SR3CRB_SAVE_VAL_MASK_SHIFT(reg) (((reg) & PIP_STATS_SR3CRB_SAVE_VAL_MASK) >> PIP_STATS_SR3CRB_SAVE_VAL_SHIFT)
#define  PIP_STATS_SR3CRB_SAVE_VAL_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_SR3CRB_SAVE_VAL_MASK) | (((uint32_t)val) << PIP_STATS_SR3CRB_SAVE_VAL_SHIFT))

//====================================================================
//Register: Save Restore Channel 4 Chan Read A (SR4CRA)
/** \brief Channel 4 Chan State Machine Registers This register is provided for the save portion of save/restore functionality. [31:16] = curr_max, [15:0] = curr_min*/
//====================================================================

#define  PIP_STATS_SR4CRA_SAVE_VAL_MASK 0xffffffff
#define  PIP_STATS_SR4CRA_SAVE_VAL_SHIFT 0
#define  PIP_STATS_SR4CRA_SAVE_VAL_MASK_SHIFT(reg) (((reg) & PIP_STATS_SR4CRA_SAVE_VAL_MASK) >> PIP_STATS_SR4CRA_SAVE_VAL_SHIFT)
#define  PIP_STATS_SR4CRA_SAVE_VAL_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_SR4CRA_SAVE_VAL_MASK) | (((uint32_t)val) << PIP_STATS_SR4CRA_SAVE_VAL_SHIFT))

//====================================================================
//Register: Save Restore Channel 4 Chan Read B (SR4CRB)
/** \brief Channel 4 Chan State Machine Registers This register is provided for the save portion of save/restore functionality. [31:28] = 0, [27:0] = curr_accum*/
//====================================================================

#define  PIP_STATS_SR4CRB_SAVE_VAL_MASK 0xffffffff
#define  PIP_STATS_SR4CRB_SAVE_VAL_SHIFT 0
#define  PIP_STATS_SR4CRB_SAVE_VAL_MASK_SHIFT(reg) (((reg) & PIP_STATS_SR4CRB_SAVE_VAL_MASK) >> PIP_STATS_SR4CRB_SAVE_VAL_SHIFT)
#define  PIP_STATS_SR4CRB_SAVE_VAL_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_SR4CRB_SAVE_VAL_MASK) | (((uint32_t)val) << PIP_STATS_SR4CRB_SAVE_VAL_SHIFT))

//====================================================================
//Register: Save Restore Channel 5 Chan Read A (SR5CRA)
/** \brief Channel 5 Chan State Machine Registers This register is provided for the save portion of save/restore functionality. [31:16] = curr_max, [15:0] = curr_min*/
//====================================================================

#define  PIP_STATS_SR5CRA_SAVE_VAL_MASK 0xffffffff
#define  PIP_STATS_SR5CRA_SAVE_VAL_SHIFT 0
#define  PIP_STATS_SR5CRA_SAVE_VAL_MASK_SHIFT(reg) (((reg) & PIP_STATS_SR5CRA_SAVE_VAL_MASK) >> PIP_STATS_SR5CRA_SAVE_VAL_SHIFT)
#define  PIP_STATS_SR5CRA_SAVE_VAL_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_SR5CRA_SAVE_VAL_MASK) | (((uint32_t)val) << PIP_STATS_SR5CRA_SAVE_VAL_SHIFT))

//====================================================================
//Register: Save Restore Channel 5 Chan Read B (SR5CRB)
/** \brief Channel 5 Chan State Machine Registers This register is provided for the save portion of save/restore functionality. [31:28] = 0, [27:0] = curr_accum*/
//====================================================================

#define  PIP_STATS_SR5CRB_SAVE_VAL_MASK 0xffffffff
#define  PIP_STATS_SR5CRB_SAVE_VAL_SHIFT 0
#define  PIP_STATS_SR5CRB_SAVE_VAL_MASK_SHIFT(reg) (((reg) & PIP_STATS_SR5CRB_SAVE_VAL_MASK) >> PIP_STATS_SR5CRB_SAVE_VAL_SHIFT)
#define  PIP_STATS_SR5CRB_SAVE_VAL_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_SR5CRB_SAVE_VAL_MASK) | (((uint32_t)val) << PIP_STATS_SR5CRB_SAVE_VAL_SHIFT))

//====================================================================
//Register: Save Restore Channel 6 Chan Read A (SR6CRA)
/** \brief Channel 6 Chan State Machine Registers This register is provided for the save portion of save/restore functionality. [31:16] = curr_max, [15:0] = curr_min*/
//====================================================================

#define  PIP_STATS_SR6CRA_SAVE_VAL_MASK 0xffffffff
#define  PIP_STATS_SR6CRA_SAVE_VAL_SHIFT 0
#define  PIP_STATS_SR6CRA_SAVE_VAL_MASK_SHIFT(reg) (((reg) & PIP_STATS_SR6CRA_SAVE_VAL_MASK) >> PIP_STATS_SR6CRA_SAVE_VAL_SHIFT)
#define  PIP_STATS_SR6CRA_SAVE_VAL_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_SR6CRA_SAVE_VAL_MASK) | (((uint32_t)val) << PIP_STATS_SR6CRA_SAVE_VAL_SHIFT))

//====================================================================
//Register: Save Restore Channel 6 Chan Read B (SR6CRB)
/** \brief Channel 6 Chan State Machine Registers This register is provided for the save portion of save/restore functionality. [31:28] = 0, [27:0] = curr_accum*/
//====================================================================

#define  PIP_STATS_SR6CRB_SAVE_VAL_MASK 0xffffffff
#define  PIP_STATS_SR6CRB_SAVE_VAL_SHIFT 0
#define  PIP_STATS_SR6CRB_SAVE_VAL_MASK_SHIFT(reg) (((reg) & PIP_STATS_SR6CRB_SAVE_VAL_MASK) >> PIP_STATS_SR6CRB_SAVE_VAL_SHIFT)
#define  PIP_STATS_SR6CRB_SAVE_VAL_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_SR6CRB_SAVE_VAL_MASK) | (((uint32_t)val) << PIP_STATS_SR6CRB_SAVE_VAL_SHIFT))

//====================================================================
//Register: Save Restore Channel 7 Chan Read A (SR7CRA)
/** \brief Channel 7 Chan State Machine Registers This register is provided for the save portion of save/restore functionality. [31:16] = curr_max, [15:0] = curr_min*/
//====================================================================

#define  PIP_STATS_SR7CRA_SAVE_VAL_MASK 0xffffffff
#define  PIP_STATS_SR7CRA_SAVE_VAL_SHIFT 0
#define  PIP_STATS_SR7CRA_SAVE_VAL_MASK_SHIFT(reg) (((reg) & PIP_STATS_SR7CRA_SAVE_VAL_MASK) >> PIP_STATS_SR7CRA_SAVE_VAL_SHIFT)
#define  PIP_STATS_SR7CRA_SAVE_VAL_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_SR7CRA_SAVE_VAL_MASK) | (((uint32_t)val) << PIP_STATS_SR7CRA_SAVE_VAL_SHIFT))

//====================================================================
//Register: Save Restore Channel 7 Chan Read B (SR7CRB)
/** \brief Channel 7 Chan State Machine Registers This register is provided for the save portion of save/restore functionality. [31:28] = 0, [27:0] = curr_accum*/
//====================================================================

#define  PIP_STATS_SR7CRB_SAVE_VAL_MASK 0xffffffff
#define  PIP_STATS_SR7CRB_SAVE_VAL_SHIFT 0
#define  PIP_STATS_SR7CRB_SAVE_VAL_MASK_SHIFT(reg) (((reg) & PIP_STATS_SR7CRB_SAVE_VAL_MASK) >> PIP_STATS_SR7CRB_SAVE_VAL_SHIFT)
#define  PIP_STATS_SR7CRB_SAVE_VAL_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_SR7CRB_SAVE_VAL_MASK) | (((uint32_t)val) << PIP_STATS_SR7CRB_SAVE_VAL_SHIFT))

//====================================================================
//Register: Save Restore Channel 0 Location Write (SR0LW)
/** \brief Channel 0 Location State Machine Registers This register is provided for the restore portion of save/restore functionality. [31:25] = 0, [24] = line_width_mismatch, [23:16] = y_index, [15:0] = x_index*/
//====================================================================

#define  PIP_STATS_SR0LW_RESTORE_VAL_MASK 0xffffffff
#define  PIP_STATS_SR0LW_RESTORE_VAL_SHIFT 0
#define  PIP_STATS_SR0LW_RESTORE_VAL_MASK_SHIFT(reg) (((reg) & PIP_STATS_SR0LW_RESTORE_VAL_MASK) >> PIP_STATS_SR0LW_RESTORE_VAL_SHIFT)
#define  PIP_STATS_SR0LW_RESTORE_VAL_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_SR0LW_RESTORE_VAL_MASK) | (((uint32_t)val) << PIP_STATS_SR0LW_RESTORE_VAL_SHIFT))

//====================================================================
//Register: Save Restore Channel 1 Location Write (SR1LW)
/** \brief Channel 1 Location State Machine Registers This register is provided for the restore portion of save/restore functionality. [31:25] = 0, [24] = line_width_mismatch, [23:16] = y_index, [15:0] = x_index*/
//====================================================================

#define  PIP_STATS_SR1LW_RESTORE_VAL_MASK 0xffffffff
#define  PIP_STATS_SR1LW_RESTORE_VAL_SHIFT 0
#define  PIP_STATS_SR1LW_RESTORE_VAL_MASK_SHIFT(reg) (((reg) & PIP_STATS_SR1LW_RESTORE_VAL_MASK) >> PIP_STATS_SR1LW_RESTORE_VAL_SHIFT)
#define  PIP_STATS_SR1LW_RESTORE_VAL_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_SR1LW_RESTORE_VAL_MASK) | (((uint32_t)val) << PIP_STATS_SR1LW_RESTORE_VAL_SHIFT))

//====================================================================
//Register: Save Restore Channel 2 Location Write (SR2LW)
/** \brief Channel 2 Location State Machine Registers This register is provided for the restore portion of save/restore functionality. [31:25] = 0, [24] = line_width_mismatch, [23:16] = y_index, [15:0] = x_index*/
//====================================================================

#define  PIP_STATS_SR2LW_RESTORE_VAL_MASK 0xffffffff
#define  PIP_STATS_SR2LW_RESTORE_VAL_SHIFT 0
#define  PIP_STATS_SR2LW_RESTORE_VAL_MASK_SHIFT(reg) (((reg) & PIP_STATS_SR2LW_RESTORE_VAL_MASK) >> PIP_STATS_SR2LW_RESTORE_VAL_SHIFT)
#define  PIP_STATS_SR2LW_RESTORE_VAL_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_SR2LW_RESTORE_VAL_MASK) | (((uint32_t)val) << PIP_STATS_SR2LW_RESTORE_VAL_SHIFT))

//====================================================================
//Register: Save Restore Channel 3 Location Write (SR3LW)
/** \brief Channel 3 Location State Machine Registers This register is provided for the restore portion of save/restore functionality. [31:25] = 0, [24] = line_width_mismatch, [23:16] = y_index, [15:0] = x_index*/
//====================================================================

#define  PIP_STATS_SR3LW_RESTORE_VAL_MASK 0xffffffff
#define  PIP_STATS_SR3LW_RESTORE_VAL_SHIFT 0
#define  PIP_STATS_SR3LW_RESTORE_VAL_MASK_SHIFT(reg) (((reg) & PIP_STATS_SR3LW_RESTORE_VAL_MASK) >> PIP_STATS_SR3LW_RESTORE_VAL_SHIFT)
#define  PIP_STATS_SR3LW_RESTORE_VAL_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_SR3LW_RESTORE_VAL_MASK) | (((uint32_t)val) << PIP_STATS_SR3LW_RESTORE_VAL_SHIFT))

//====================================================================
//Register: Save Restore Channel 4 Location Write (SR4LW)
/** \brief Channel 4 Location State Machine Registers This register is provided for the restore portion of save/restore functionality. [31:25] = 0, [24] = line_width_mismatch, [23:16] = y_index, [15:0] = x_index*/
//====================================================================

#define  PIP_STATS_SR4LW_RESTORE_VAL_MASK 0xffffffff
#define  PIP_STATS_SR4LW_RESTORE_VAL_SHIFT 0
#define  PIP_STATS_SR4LW_RESTORE_VAL_MASK_SHIFT(reg) (((reg) & PIP_STATS_SR4LW_RESTORE_VAL_MASK) >> PIP_STATS_SR4LW_RESTORE_VAL_SHIFT)
#define  PIP_STATS_SR4LW_RESTORE_VAL_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_SR4LW_RESTORE_VAL_MASK) | (((uint32_t)val) << PIP_STATS_SR4LW_RESTORE_VAL_SHIFT))

//====================================================================
//Register: Save Restore Channel 5 Location Write (SR5LW)
/** \brief Channel 5 Location State Machine Registers This register is provided for the restore portion of save/restore functionality. [31:25] = 0, [24] = line_width_mismatch, [23:16] = y_index, [15:0] = x_index*/
//====================================================================

#define  PIP_STATS_SR5LW_RESTORE_VAL_MASK 0xffffffff
#define  PIP_STATS_SR5LW_RESTORE_VAL_SHIFT 0
#define  PIP_STATS_SR5LW_RESTORE_VAL_MASK_SHIFT(reg) (((reg) & PIP_STATS_SR5LW_RESTORE_VAL_MASK) >> PIP_STATS_SR5LW_RESTORE_VAL_SHIFT)
#define  PIP_STATS_SR5LW_RESTORE_VAL_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_SR5LW_RESTORE_VAL_MASK) | (((uint32_t)val) << PIP_STATS_SR5LW_RESTORE_VAL_SHIFT))

//====================================================================
//Register: Save Restore Channel 6 Location Write (SR6LW)
/** \brief Channel 6 Location State Machine Registers This register is provided for the restore portion of save/restore functionality. [31:25] = 0, [24] = line_width_mismatch, [23:16] = y_index, [15:0] = x_index*/
//====================================================================

#define  PIP_STATS_SR6LW_RESTORE_VAL_MASK 0xffffffff
#define  PIP_STATS_SR6LW_RESTORE_VAL_SHIFT 0
#define  PIP_STATS_SR6LW_RESTORE_VAL_MASK_SHIFT(reg) (((reg) & PIP_STATS_SR6LW_RESTORE_VAL_MASK) >> PIP_STATS_SR6LW_RESTORE_VAL_SHIFT)
#define  PIP_STATS_SR6LW_RESTORE_VAL_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_SR6LW_RESTORE_VAL_MASK) | (((uint32_t)val) << PIP_STATS_SR6LW_RESTORE_VAL_SHIFT))

//====================================================================
//Register: Save Restore Channel 7 Location Write (SR7LW)
/** \brief Channel 7 Location State Machine Registers This register is provided for the restore portion of save/restore functionality. [31:25] = 0, [24] = line_width_mismatch, [23:16] = y_index, [15:0] = x_index*/
//====================================================================

#define  PIP_STATS_SR7LW_RESTORE_VAL_MASK 0xffffffff
#define  PIP_STATS_SR7LW_RESTORE_VAL_SHIFT 0
#define  PIP_STATS_SR7LW_RESTORE_VAL_MASK_SHIFT(reg) (((reg) & PIP_STATS_SR7LW_RESTORE_VAL_MASK) >> PIP_STATS_SR7LW_RESTORE_VAL_SHIFT)
#define  PIP_STATS_SR7LW_RESTORE_VAL_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_SR7LW_RESTORE_VAL_MASK) | (((uint32_t)val) << PIP_STATS_SR7LW_RESTORE_VAL_SHIFT))

//====================================================================
//Register: Save Restore Channel 0 Chan Write A (SR0CWA)
/** \brief Channel 0 Chan State Machine Registers This register is provided for the restore portion of save/restore functionality. [31:16] = curr_max, [15:0] = curr_min*/
//====================================================================

#define  PIP_STATS_SR0CWA_RESTORE_VAL_MASK 0xffffffff
#define  PIP_STATS_SR0CWA_RESTORE_VAL_SHIFT 0
#define  PIP_STATS_SR0CWA_RESTORE_VAL_MASK_SHIFT(reg) (((reg) & PIP_STATS_SR0CWA_RESTORE_VAL_MASK) >> PIP_STATS_SR0CWA_RESTORE_VAL_SHIFT)
#define  PIP_STATS_SR0CWA_RESTORE_VAL_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_SR0CWA_RESTORE_VAL_MASK) | (((uint32_t)val) << PIP_STATS_SR0CWA_RESTORE_VAL_SHIFT))

//====================================================================
//Register: Save Restore Channel 0 Chan Write B (SR0CWB)
/** \brief Channel 0 Chan State Machine Registers This register is provided for the restore portion of save/restore functionality. [31:28] = 0, [27:0] = curr_accum*/
//====================================================================

#define  PIP_STATS_SR0CWB_RESTORE_VAL_MASK 0xffffffff
#define  PIP_STATS_SR0CWB_RESTORE_VAL_SHIFT 0
#define  PIP_STATS_SR0CWB_RESTORE_VAL_MASK_SHIFT(reg) (((reg) & PIP_STATS_SR0CWB_RESTORE_VAL_MASK) >> PIP_STATS_SR0CWB_RESTORE_VAL_SHIFT)
#define  PIP_STATS_SR0CWB_RESTORE_VAL_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_SR0CWB_RESTORE_VAL_MASK) | (((uint32_t)val) << PIP_STATS_SR0CWB_RESTORE_VAL_SHIFT))

//====================================================================
//Register: Save Restore Channel 1 Chan Write A (SR1CWA)
/** \brief Channel 1 Chan State Machine Registers This register is provided for the restore portion of save/restore functionality. [31:16] = curr_max, [15:0] = curr_min*/
//====================================================================

#define  PIP_STATS_SR1CWA_RESTORE_VAL_MASK 0xffffffff
#define  PIP_STATS_SR1CWA_RESTORE_VAL_SHIFT 0
#define  PIP_STATS_SR1CWA_RESTORE_VAL_MASK_SHIFT(reg) (((reg) & PIP_STATS_SR1CWA_RESTORE_VAL_MASK) >> PIP_STATS_SR1CWA_RESTORE_VAL_SHIFT)
#define  PIP_STATS_SR1CWA_RESTORE_VAL_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_SR1CWA_RESTORE_VAL_MASK) | (((uint32_t)val) << PIP_STATS_SR1CWA_RESTORE_VAL_SHIFT))

//====================================================================
//Register: Save Restore Channel 1 Chan Write B (SR1CWB)
/** \brief Channel 1 Chan State Machine Registers This register is provided for the restore portion of save/restore functionality. [31:28] = 0, [27:0] = curr_accum*/
//====================================================================

#define  PIP_STATS_SR1CWB_RESTORE_VAL_MASK 0xffffffff
#define  PIP_STATS_SR1CWB_RESTORE_VAL_SHIFT 0
#define  PIP_STATS_SR1CWB_RESTORE_VAL_MASK_SHIFT(reg) (((reg) & PIP_STATS_SR1CWB_RESTORE_VAL_MASK) >> PIP_STATS_SR1CWB_RESTORE_VAL_SHIFT)
#define  PIP_STATS_SR1CWB_RESTORE_VAL_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_SR1CWB_RESTORE_VAL_MASK) | (((uint32_t)val) << PIP_STATS_SR1CWB_RESTORE_VAL_SHIFT))

//====================================================================
//Register: Save Restore Channel 2 Chan Write A (SR2CWA)
/** \brief Channel 2 Chan State Machine Registers This register is provided for the restore portion of save/restore functionality. [31:16] = curr_max, [15:0] = curr_min*/
//====================================================================

#define  PIP_STATS_SR2CWA_RESTORE_VAL_MASK 0xffffffff
#define  PIP_STATS_SR2CWA_RESTORE_VAL_SHIFT 0
#define  PIP_STATS_SR2CWA_RESTORE_VAL_MASK_SHIFT(reg) (((reg) & PIP_STATS_SR2CWA_RESTORE_VAL_MASK) >> PIP_STATS_SR2CWA_RESTORE_VAL_SHIFT)
#define  PIP_STATS_SR2CWA_RESTORE_VAL_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_SR2CWA_RESTORE_VAL_MASK) | (((uint32_t)val) << PIP_STATS_SR2CWA_RESTORE_VAL_SHIFT))

//====================================================================
//Register: Save Restore Channel 2 Chan Write B (SR2CWB)
/** \brief Channel 2 Chan State Machine Registers This register is provided for the restore portion of save/restore functionality. [31:28] = 0, [27:0] = curr_accum*/
//====================================================================

#define  PIP_STATS_SR2CWB_RESTORE_VAL_MASK 0xffffffff
#define  PIP_STATS_SR2CWB_RESTORE_VAL_SHIFT 0
#define  PIP_STATS_SR2CWB_RESTORE_VAL_MASK_SHIFT(reg) (((reg) & PIP_STATS_SR2CWB_RESTORE_VAL_MASK) >> PIP_STATS_SR2CWB_RESTORE_VAL_SHIFT)
#define  PIP_STATS_SR2CWB_RESTORE_VAL_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_SR2CWB_RESTORE_VAL_MASK) | (((uint32_t)val) << PIP_STATS_SR2CWB_RESTORE_VAL_SHIFT))

//====================================================================
//Register: Save Restore Channel 3 Chan Write A (SR3CWA)
/** \brief Channel 3 Chan State Machine Registers This register is provided for the restore portion of save/restore functionality. [31:16] = curr_max, [15:0] = curr_min*/
//====================================================================

#define  PIP_STATS_SR3CWA_RESTORE_VAL_MASK 0xffffffff
#define  PIP_STATS_SR3CWA_RESTORE_VAL_SHIFT 0
#define  PIP_STATS_SR3CWA_RESTORE_VAL_MASK_SHIFT(reg) (((reg) & PIP_STATS_SR3CWA_RESTORE_VAL_MASK) >> PIP_STATS_SR3CWA_RESTORE_VAL_SHIFT)
#define  PIP_STATS_SR3CWA_RESTORE_VAL_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_SR3CWA_RESTORE_VAL_MASK) | (((uint32_t)val) << PIP_STATS_SR3CWA_RESTORE_VAL_SHIFT))

//====================================================================
//Register: Save Restore Channel 3 Chan Write B (SR3CWB)
/** \brief Channel 3 Chan State Machine Registers This register is provided for the restore portion of save/restore functionality. [31:28] = 0, [27:0] = curr_accum*/
//====================================================================

#define  PIP_STATS_SR3CWB_RESTORE_VAL_MASK 0xffffffff
#define  PIP_STATS_SR3CWB_RESTORE_VAL_SHIFT 0
#define  PIP_STATS_SR3CWB_RESTORE_VAL_MASK_SHIFT(reg) (((reg) & PIP_STATS_SR3CWB_RESTORE_VAL_MASK) >> PIP_STATS_SR3CWB_RESTORE_VAL_SHIFT)
#define  PIP_STATS_SR3CWB_RESTORE_VAL_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_SR3CWB_RESTORE_VAL_MASK) | (((uint32_t)val) << PIP_STATS_SR3CWB_RESTORE_VAL_SHIFT))

//====================================================================
//Register: Save Restore Channel 4 Chan Write A (SR4CWA)
/** \brief Channel 4 Chan State Machine Registers This register is provided for the restore portion of save/restore functionality. [31:16] = curr_max, [15:0] = curr_min*/
//====================================================================

#define  PIP_STATS_SR4CWA_RESTORE_VAL_MASK 0xffffffff
#define  PIP_STATS_SR4CWA_RESTORE_VAL_SHIFT 0
#define  PIP_STATS_SR4CWA_RESTORE_VAL_MASK_SHIFT(reg) (((reg) & PIP_STATS_SR4CWA_RESTORE_VAL_MASK) >> PIP_STATS_SR4CWA_RESTORE_VAL_SHIFT)
#define  PIP_STATS_SR4CWA_RESTORE_VAL_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_SR4CWA_RESTORE_VAL_MASK) | (((uint32_t)val) << PIP_STATS_SR4CWA_RESTORE_VAL_SHIFT))

//====================================================================
//Register: Save Restore Channel 4 Chan Write B (SR4CWB)
/** \brief Channel 4 Chan State Machine Registers This register is provided for the restore portion of save/restore functionality. [31:28] = 0, [27:0] = curr_accum*/
//====================================================================

#define  PIP_STATS_SR4CWB_RESTORE_VAL_MASK 0xffffffff
#define  PIP_STATS_SR4CWB_RESTORE_VAL_SHIFT 0
#define  PIP_STATS_SR4CWB_RESTORE_VAL_MASK_SHIFT(reg) (((reg) & PIP_STATS_SR4CWB_RESTORE_VAL_MASK) >> PIP_STATS_SR4CWB_RESTORE_VAL_SHIFT)
#define  PIP_STATS_SR4CWB_RESTORE_VAL_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_SR4CWB_RESTORE_VAL_MASK) | (((uint32_t)val) << PIP_STATS_SR4CWB_RESTORE_VAL_SHIFT))

//====================================================================
//Register: Save Restore Channel 5 Chan Write A (SR5CWA)
/** \brief Channel 5 Chan State Machine Registers This register is provided for the restore portion of save/restore functionality. [31:16] = curr_max, [15:0] = curr_min*/
//====================================================================

#define  PIP_STATS_SR5CWA_RESTORE_VAL_MASK 0xffffffff
#define  PIP_STATS_SR5CWA_RESTORE_VAL_SHIFT 0
#define  PIP_STATS_SR5CWA_RESTORE_VAL_MASK_SHIFT(reg) (((reg) & PIP_STATS_SR5CWA_RESTORE_VAL_MASK) >> PIP_STATS_SR5CWA_RESTORE_VAL_SHIFT)
#define  PIP_STATS_SR5CWA_RESTORE_VAL_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_SR5CWA_RESTORE_VAL_MASK) | (((uint32_t)val) << PIP_STATS_SR5CWA_RESTORE_VAL_SHIFT))

//====================================================================
//Register: Save Restore Channel 5 Chan Write B (SR5CWB)
/** \brief Channel 5 Chan State Machine Registers This register is provided for the restore portion of save/restore functionality. [31:28] = 0, [27:0] = curr_accum*/
//====================================================================

#define  PIP_STATS_SR5CWB_RESTORE_VAL_MASK 0xffffffff
#define  PIP_STATS_SR5CWB_RESTORE_VAL_SHIFT 0
#define  PIP_STATS_SR5CWB_RESTORE_VAL_MASK_SHIFT(reg) (((reg) & PIP_STATS_SR5CWB_RESTORE_VAL_MASK) >> PIP_STATS_SR5CWB_RESTORE_VAL_SHIFT)
#define  PIP_STATS_SR5CWB_RESTORE_VAL_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_SR5CWB_RESTORE_VAL_MASK) | (((uint32_t)val) << PIP_STATS_SR5CWB_RESTORE_VAL_SHIFT))

//====================================================================
//Register: Save Restore Channel 6 Chan Write A (SR6CWA)
/** \brief Channel 6 Chan State Machine Registers This register is provided for the restore portion of save/restore functionality. [31:16] = curr_max, [15:0] = curr_min*/
//====================================================================

#define  PIP_STATS_SR6CWA_RESTORE_VAL_MASK 0xffffffff
#define  PIP_STATS_SR6CWA_RESTORE_VAL_SHIFT 0
#define  PIP_STATS_SR6CWA_RESTORE_VAL_MASK_SHIFT(reg) (((reg) & PIP_STATS_SR6CWA_RESTORE_VAL_MASK) >> PIP_STATS_SR6CWA_RESTORE_VAL_SHIFT)
#define  PIP_STATS_SR6CWA_RESTORE_VAL_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_SR6CWA_RESTORE_VAL_MASK) | (((uint32_t)val) << PIP_STATS_SR6CWA_RESTORE_VAL_SHIFT))

//====================================================================
//Register: Save Restore Channel 6 Chan Write B (SR6CWB)
/** \brief Channel 6 Chan State Machine Registers This register is provided for the restore portion of save/restore functionality. [31:28] = 0, [27:0] = curr_accum*/
//====================================================================

#define  PIP_STATS_SR6CWB_RESTORE_VAL_MASK 0xffffffff
#define  PIP_STATS_SR6CWB_RESTORE_VAL_SHIFT 0
#define  PIP_STATS_SR6CWB_RESTORE_VAL_MASK_SHIFT(reg) (((reg) & PIP_STATS_SR6CWB_RESTORE_VAL_MASK) >> PIP_STATS_SR6CWB_RESTORE_VAL_SHIFT)
#define  PIP_STATS_SR6CWB_RESTORE_VAL_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_SR6CWB_RESTORE_VAL_MASK) | (((uint32_t)val) << PIP_STATS_SR6CWB_RESTORE_VAL_SHIFT))

//====================================================================
//Register: Save Restore Channel 7 Chan Write A (SR7CWA)
/** \brief Channel 7 Chan State Machine Registers This register is provided for the restore portion of save/restore functionality. [31:16] = curr_max, [15:0] = curr_min*/
//====================================================================

#define  PIP_STATS_SR7CWA_RESTORE_VAL_MASK 0xffffffff
#define  PIP_STATS_SR7CWA_RESTORE_VAL_SHIFT 0
#define  PIP_STATS_SR7CWA_RESTORE_VAL_MASK_SHIFT(reg) (((reg) & PIP_STATS_SR7CWA_RESTORE_VAL_MASK) >> PIP_STATS_SR7CWA_RESTORE_VAL_SHIFT)
#define  PIP_STATS_SR7CWA_RESTORE_VAL_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_SR7CWA_RESTORE_VAL_MASK) | (((uint32_t)val) << PIP_STATS_SR7CWA_RESTORE_VAL_SHIFT))

//====================================================================
//Register: Save Restore Channel 7 Chan Write B (SR7CWB)
/** \brief Channel 7 Chan State Machine Registers This register is provided for the restore portion of save/restore functionality. [31:28] = 0, [27:0] = curr_accum*/
//====================================================================

#define  PIP_STATS_SR7CWB_RESTORE_VAL_MASK 0xffffffff
#define  PIP_STATS_SR7CWB_RESTORE_VAL_SHIFT 0
#define  PIP_STATS_SR7CWB_RESTORE_VAL_MASK_SHIFT(reg) (((reg) & PIP_STATS_SR7CWB_RESTORE_VAL_MASK) >> PIP_STATS_SR7CWB_RESTORE_VAL_SHIFT)
#define  PIP_STATS_SR7CWB_RESTORE_VAL_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_SR7CWB_RESTORE_VAL_MASK) | (((uint32_t)val) << PIP_STATS_SR7CWB_RESTORE_VAL_SHIFT))

//====================================================================
//Register: IP Tagging Revision 0 (REV0)
/** \brief Provide means for firmware to read IP tagging information.
      This register of particular interest to firmware.*/
//====================================================================

#define  PIP_STATS_REV0_MAJ_MASK 0xffff0000
#define  PIP_STATS_REV0_MAJ_SHIFT 16
#define  PIP_STATS_REV0_MAJ_MASK_SHIFT(reg) (((reg) & PIP_STATS_REV0_MAJ_MASK) >> PIP_STATS_REV0_MAJ_SHIFT)
#define  PIP_STATS_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_REV0_MAJ_MASK) | (((uint32_t)val) << PIP_STATS_REV0_MAJ_SHIFT))

#define  PIP_STATS_REV0_MID_MASK 0xffff
#define  PIP_STATS_REV0_MID_SHIFT 0
#define  PIP_STATS_REV0_MID_MASK_SHIFT(reg) (((reg) & PIP_STATS_REV0_MID_MASK) >> PIP_STATS_REV0_MID_SHIFT)
#define  PIP_STATS_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_REV0_MID_MASK) | (((uint32_t)val) << PIP_STATS_REV0_MID_SHIFT))

//====================================================================
//Register: IP Tagging Revision 1 (REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  PIP_STATS_REV1_RESERVED1_MASK 0xffff0000
#define  PIP_STATS_REV1_RESERVED1_SHIFT 16
#define  PIP_STATS_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & PIP_STATS_REV1_RESERVED1_MASK) >> PIP_STATS_REV1_RESERVED1_SHIFT)
#define  PIP_STATS_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_REV1_RESERVED1_MASK) | (((uint32_t)val) << PIP_STATS_REV1_RESERVED1_SHIFT))

#define  PIP_STATS_REV1_CFG_MASK 0xffff
#define  PIP_STATS_REV1_CFG_SHIFT 0
#define  PIP_STATS_REV1_CFG_MASK_SHIFT(reg) (((reg) & PIP_STATS_REV1_CFG_MASK) >> PIP_STATS_REV1_CFG_SHIFT)
#define  PIP_STATS_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~PIP_STATS_REV1_CFG_MASK) | (((uint32_t)val) << PIP_STATS_REV1_CFG_SHIFT))

#endif // PIP_STATS
