 /*
 **************************************************************************************
 *
 * (c) Copyright 2013 Marvell International Ltd.
 *
 *
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/.
 *
 **************************************************************************************
 *
 * \file PIPE_ACCESS_regmasks.h
 * Generated using RegBuild 1.6.3
 *
 **************************************************************************************
 */

#ifndef _PIPE_ACCESS_REGMASKS_H_
#define _PIPE_ACCESS_REGMASKS_H_

#ifndef __KERNEL__
#include <stdint.h>
#endif

//====================================================================
//
//Register File: PIPE_ACCESS (PIPE_ACCESS)
//
//====================================================================

//====================================================================
//Register: Configuration register (cfg)
/** \brief Used to configure the main Pipe Access modes.*/
//====================================================================

#define  PIPE_ACCESS_CFG_RESERVED1_MASK 0xff800000
#define  PIPE_ACCESS_CFG_RESERVED1_SHIFT 23
#define  PIPE_ACCESS_CFG_RESERVED1_MASK_SHIFT(reg) (((reg) & PIPE_ACCESS_CFG_RESERVED1_MASK) >> PIPE_ACCESS_CFG_RESERVED1_SHIFT)
#define  PIPE_ACCESS_CFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PIPE_ACCESS_CFG_RESERVED1_MASK) | (((uint32_t)val) << PIPE_ACCESS_CFG_RESERVED1_SHIFT))

#define  PIPE_ACCESS_CFG_CPU_LUT_ACCESS_SEL_MASK 0x700000
#define  PIPE_ACCESS_CFG_CPU_LUT_ACCESS_SEL_SHIFT 20
#define  PIPE_ACCESS_CFG_CPU_LUT_ACCESS_SEL_MASK_SHIFT(reg) (((reg) & PIPE_ACCESS_CFG_CPU_LUT_ACCESS_SEL_MASK) >> PIPE_ACCESS_CFG_CPU_LUT_ACCESS_SEL_SHIFT)
#define  PIPE_ACCESS_CFG_CPU_LUT_ACCESS_SEL_REPLACE_VAL(reg,val) (((reg) & ~PIPE_ACCESS_CFG_CPU_LUT_ACCESS_SEL_MASK) | (((uint32_t)val) << PIPE_ACCESS_CFG_CPU_LUT_ACCESS_SEL_SHIFT))

#define  PIPE_ACCESS_CFG_RESERVED2_MASK 0xe0000
#define  PIPE_ACCESS_CFG_RESERVED2_SHIFT 17
#define  PIPE_ACCESS_CFG_RESERVED2_MASK_SHIFT(reg) (((reg) & PIPE_ACCESS_CFG_RESERVED2_MASK) >> PIPE_ACCESS_CFG_RESERVED2_SHIFT)
#define  PIPE_ACCESS_CFG_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~PIPE_ACCESS_CFG_RESERVED2_MASK) | (((uint32_t)val) << PIPE_ACCESS_CFG_RESERVED2_SHIFT))

#define  PIPE_ACCESS_CFG_CPU_LUT_ACCESS_EN_MASK 0x10000
#define  PIPE_ACCESS_CFG_CPU_LUT_ACCESS_EN_SHIFT 16
#define  PIPE_ACCESS_CFG_CPU_LUT_ACCESS_EN_MASK_SHIFT(reg) (((reg) & PIPE_ACCESS_CFG_CPU_LUT_ACCESS_EN_MASK) >> PIPE_ACCESS_CFG_CPU_LUT_ACCESS_EN_SHIFT)
#define  PIPE_ACCESS_CFG_CPU_LUT_ACCESS_EN_REPLACE_VAL(reg,val) (((reg) & ~PIPE_ACCESS_CFG_CPU_LUT_ACCESS_EN_MASK) | (((uint32_t)val) << PIPE_ACCESS_CFG_CPU_LUT_ACCESS_EN_SHIFT))

#define  PIPE_ACCESS_CFG_RESERVED3_MASK 0xc000
#define  PIPE_ACCESS_CFG_RESERVED3_SHIFT 14
#define  PIPE_ACCESS_CFG_RESERVED3_MASK_SHIFT(reg) (((reg) & PIPE_ACCESS_CFG_RESERVED3_MASK) >> PIPE_ACCESS_CFG_RESERVED3_SHIFT)
#define  PIPE_ACCESS_CFG_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~PIPE_ACCESS_CFG_RESERVED3_MASK) | (((uint32_t)val) << PIPE_ACCESS_CFG_RESERVED3_SHIFT))

#define  PIPE_ACCESS_CFG_LUT_CBI_MASK 0x3000
#define  PIPE_ACCESS_CFG_LUT_CBI_SHIFT 12
#define  PIPE_ACCESS_CFG_LUT_CBI_MASK_SHIFT(reg) (((reg) & PIPE_ACCESS_CFG_LUT_CBI_MASK) >> PIPE_ACCESS_CFG_LUT_CBI_SHIFT)
#define  PIPE_ACCESS_CFG_LUT_CBI_REPLACE_VAL(reg,val) (((reg) & ~PIPE_ACCESS_CFG_LUT_CBI_MASK) | (((uint32_t)val) << PIPE_ACCESS_CFG_LUT_CBI_SHIFT))

#define  PIPE_ACCESS_CFG_RESERVED4_MASK 0xc00
#define  PIPE_ACCESS_CFG_RESERVED4_SHIFT 10
#define  PIPE_ACCESS_CFG_RESERVED4_MASK_SHIFT(reg) (((reg) & PIPE_ACCESS_CFG_RESERVED4_MASK) >> PIPE_ACCESS_CFG_RESERVED4_SHIFT)
#define  PIPE_ACCESS_CFG_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~PIPE_ACCESS_CFG_RESERVED4_MASK) | (((uint32_t)val) << PIPE_ACCESS_CFG_RESERVED4_SHIFT))

#define  PIPE_ACCESS_CFG_PIPELINE_LOAD_EN_MASK 0x300
#define  PIPE_ACCESS_CFG_PIPELINE_LOAD_EN_SHIFT 8
#define  PIPE_ACCESS_CFG_PIPELINE_LOAD_EN_MASK_SHIFT(reg) (((reg) & PIPE_ACCESS_CFG_PIPELINE_LOAD_EN_MASK) >> PIPE_ACCESS_CFG_PIPELINE_LOAD_EN_SHIFT)
#define  PIPE_ACCESS_CFG_PIPELINE_LOAD_EN_REPLACE_VAL(reg,val) (((reg) & ~PIPE_ACCESS_CFG_PIPELINE_LOAD_EN_MASK) | (((uint32_t)val) << PIPE_ACCESS_CFG_PIPELINE_LOAD_EN_SHIFT))

#define  PIPE_ACCESS_CFG_RESERVED5_MASK 0xc0
#define  PIPE_ACCESS_CFG_RESERVED5_SHIFT 6
#define  PIPE_ACCESS_CFG_RESERVED5_MASK_SHIFT(reg) (((reg) & PIPE_ACCESS_CFG_RESERVED5_MASK) >> PIPE_ACCESS_CFG_RESERVED5_SHIFT)
#define  PIPE_ACCESS_CFG_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~PIPE_ACCESS_CFG_RESERVED5_MASK) | (((uint32_t)val) << PIPE_ACCESS_CFG_RESERVED5_SHIFT))

#define  PIPE_ACCESS_CFG_PIPELINE_STORE_EN_MASK 0x30
#define  PIPE_ACCESS_CFG_PIPELINE_STORE_EN_SHIFT 4
#define  PIPE_ACCESS_CFG_PIPELINE_STORE_EN_MASK_SHIFT(reg) (((reg) & PIPE_ACCESS_CFG_PIPELINE_STORE_EN_MASK) >> PIPE_ACCESS_CFG_PIPELINE_STORE_EN_SHIFT)
#define  PIPE_ACCESS_CFG_PIPELINE_STORE_EN_REPLACE_VAL(reg,val) (((reg) & ~PIPE_ACCESS_CFG_PIPELINE_STORE_EN_MASK) | (((uint32_t)val) << PIPE_ACCESS_CFG_PIPELINE_STORE_EN_SHIFT))

#define  PIPE_ACCESS_CFG_RESERVED6_MASK 0xe
#define  PIPE_ACCESS_CFG_RESERVED6_SHIFT 1
#define  PIPE_ACCESS_CFG_RESERVED6_MASK_SHIFT(reg) (((reg) & PIPE_ACCESS_CFG_RESERVED6_MASK) >> PIPE_ACCESS_CFG_RESERVED6_SHIFT)
#define  PIPE_ACCESS_CFG_RESERVED6_REPLACE_VAL(reg,val) (((reg) & ~PIPE_ACCESS_CFG_RESERVED6_MASK) | (((uint32_t)val) << PIPE_ACCESS_CFG_RESERVED6_SHIFT))

#define  PIPE_ACCESS_CFG_BYPASS_MASK 0x1
#define  PIPE_ACCESS_CFG_BYPASS_SHIFT 0
#define  PIPE_ACCESS_CFG_BYPASS_MASK_SHIFT(reg) (((reg) & PIPE_ACCESS_CFG_BYPASS_MASK) >> PIPE_ACCESS_CFG_BYPASS_SHIFT)
#define  PIPE_ACCESS_CFG_BYPASS_REPLACE_VAL(reg,val) (((reg) & ~PIPE_ACCESS_CFG_BYPASS_MASK) | (((uint32_t)val) << PIPE_ACCESS_CFG_BYPASS_SHIFT))

//====================================================================
//Register: Interrupt Enable Register (irq_en)
/** \brief Enables interrupts from Pipe Access core.*/
//====================================================================

#define  PIPE_ACCESS_IRQ_EN_RESERVED1_MASK 0xfffffffc
#define  PIPE_ACCESS_IRQ_EN_RESERVED1_SHIFT 2
#define  PIPE_ACCESS_IRQ_EN_RESERVED1_MASK_SHIFT(reg) (((reg) & PIPE_ACCESS_IRQ_EN_RESERVED1_MASK) >> PIPE_ACCESS_IRQ_EN_RESERVED1_SHIFT)
#define  PIPE_ACCESS_IRQ_EN_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PIPE_ACCESS_IRQ_EN_RESERVED1_MASK) | (((uint32_t)val) << PIPE_ACCESS_IRQ_EN_RESERVED1_SHIFT))

#define  PIPE_ACCESS_IRQ_EN_CH6_EOI_IRQ_EN_MASK 0x2
#define  PIPE_ACCESS_IRQ_EN_CH6_EOI_IRQ_EN_SHIFT 1
#define  PIPE_ACCESS_IRQ_EN_CH6_EOI_IRQ_EN_MASK_SHIFT(reg) (((reg) & PIPE_ACCESS_IRQ_EN_CH6_EOI_IRQ_EN_MASK) >> PIPE_ACCESS_IRQ_EN_CH6_EOI_IRQ_EN_SHIFT)
#define  PIPE_ACCESS_IRQ_EN_CH6_EOI_IRQ_EN_REPLACE_VAL(reg,val) (((reg) & ~PIPE_ACCESS_IRQ_EN_CH6_EOI_IRQ_EN_MASK) | (((uint32_t)val) << PIPE_ACCESS_IRQ_EN_CH6_EOI_IRQ_EN_SHIFT))

#define  PIPE_ACCESS_IRQ_EN_CH4_EOI_IRQ_EN_MASK 0x1
#define  PIPE_ACCESS_IRQ_EN_CH4_EOI_IRQ_EN_SHIFT 0
#define  PIPE_ACCESS_IRQ_EN_CH4_EOI_IRQ_EN_MASK_SHIFT(reg) (((reg) & PIPE_ACCESS_IRQ_EN_CH4_EOI_IRQ_EN_MASK) >> PIPE_ACCESS_IRQ_EN_CH4_EOI_IRQ_EN_SHIFT)
#define  PIPE_ACCESS_IRQ_EN_CH4_EOI_IRQ_EN_REPLACE_VAL(reg,val) (((reg) & ~PIPE_ACCESS_IRQ_EN_CH4_EOI_IRQ_EN_MASK) | (((uint32_t)val) << PIPE_ACCESS_IRQ_EN_CH4_EOI_IRQ_EN_SHIFT))

//====================================================================
//Register: Interrupt Pending Register (irq_st)
/** \brief Current status of interrupts from Pipe Access core or DMAs.*/
//====================================================================

#define  PIPE_ACCESS_IRQ_ST_RESERVED1_MASK 0xfffffff0
#define  PIPE_ACCESS_IRQ_ST_RESERVED1_SHIFT 4
#define  PIPE_ACCESS_IRQ_ST_RESERVED1_MASK_SHIFT(reg) (((reg) & PIPE_ACCESS_IRQ_ST_RESERVED1_MASK) >> PIPE_ACCESS_IRQ_ST_RESERVED1_SHIFT)
#define  PIPE_ACCESS_IRQ_ST_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PIPE_ACCESS_IRQ_ST_RESERVED1_MASK) | (((uint32_t)val) << PIPE_ACCESS_IRQ_ST_RESERVED1_SHIFT))

#define  PIPE_ACCESS_IRQ_ST_IDMA_IRQ_STAT_MASK 0x8
#define  PIPE_ACCESS_IRQ_ST_IDMA_IRQ_STAT_SHIFT 3
#define  PIPE_ACCESS_IRQ_ST_IDMA_IRQ_STAT_MASK_SHIFT(reg) (((reg) & PIPE_ACCESS_IRQ_ST_IDMA_IRQ_STAT_MASK) >> PIPE_ACCESS_IRQ_ST_IDMA_IRQ_STAT_SHIFT)
#define  PIPE_ACCESS_IRQ_ST_IDMA_IRQ_STAT_REPLACE_VAL(reg,val) (((reg) & ~PIPE_ACCESS_IRQ_ST_IDMA_IRQ_STAT_MASK) | (((uint32_t)val) << PIPE_ACCESS_IRQ_ST_IDMA_IRQ_STAT_SHIFT))

#define  PIPE_ACCESS_IRQ_ST_ODMA_IRQ_STAT_MASK 0x4
#define  PIPE_ACCESS_IRQ_ST_ODMA_IRQ_STAT_SHIFT 2
#define  PIPE_ACCESS_IRQ_ST_ODMA_IRQ_STAT_MASK_SHIFT(reg) (((reg) & PIPE_ACCESS_IRQ_ST_ODMA_IRQ_STAT_MASK) >> PIPE_ACCESS_IRQ_ST_ODMA_IRQ_STAT_SHIFT)
#define  PIPE_ACCESS_IRQ_ST_ODMA_IRQ_STAT_REPLACE_VAL(reg,val) (((reg) & ~PIPE_ACCESS_IRQ_ST_ODMA_IRQ_STAT_MASK) | (((uint32_t)val) << PIPE_ACCESS_IRQ_ST_ODMA_IRQ_STAT_SHIFT))

#define  PIPE_ACCESS_IRQ_ST_CH6_EOI_IRQ_STAT_MASK 0x2
#define  PIPE_ACCESS_IRQ_ST_CH6_EOI_IRQ_STAT_SHIFT 1
#define  PIPE_ACCESS_IRQ_ST_CH6_EOI_IRQ_STAT_MASK_SHIFT(reg) (((reg) & PIPE_ACCESS_IRQ_ST_CH6_EOI_IRQ_STAT_MASK) >> PIPE_ACCESS_IRQ_ST_CH6_EOI_IRQ_STAT_SHIFT)
#define  PIPE_ACCESS_IRQ_ST_CH6_EOI_IRQ_STAT_REPLACE_VAL(reg,val) (((reg) & ~PIPE_ACCESS_IRQ_ST_CH6_EOI_IRQ_STAT_MASK) | (((uint32_t)val) << PIPE_ACCESS_IRQ_ST_CH6_EOI_IRQ_STAT_SHIFT))

#define  PIPE_ACCESS_IRQ_ST_CH4_EOI_IRQ_STAT_MASK 0x1
#define  PIPE_ACCESS_IRQ_ST_CH4_EOI_IRQ_STAT_SHIFT 0
#define  PIPE_ACCESS_IRQ_ST_CH4_EOI_IRQ_STAT_MASK_SHIFT(reg) (((reg) & PIPE_ACCESS_IRQ_ST_CH4_EOI_IRQ_STAT_MASK) >> PIPE_ACCESS_IRQ_ST_CH4_EOI_IRQ_STAT_SHIFT)
#define  PIPE_ACCESS_IRQ_ST_CH4_EOI_IRQ_STAT_REPLACE_VAL(reg,val) (((reg) & ~PIPE_ACCESS_IRQ_ST_CH4_EOI_IRQ_STAT_MASK) | (((uint32_t)val) << PIPE_ACCESS_IRQ_ST_CH4_EOI_IRQ_STAT_SHIFT))

//====================================================================
//Register: Interrupt Acknowledge Register (irq_ack)
/** \brief Acknowledge interrupts from Pipe Access core.*/
//====================================================================

#define  PIPE_ACCESS_IRQ_ACK_RESERVED1_MASK 0xfffffffc
#define  PIPE_ACCESS_IRQ_ACK_RESERVED1_SHIFT 2
#define  PIPE_ACCESS_IRQ_ACK_RESERVED1_MASK_SHIFT(reg) (((reg) & PIPE_ACCESS_IRQ_ACK_RESERVED1_MASK) >> PIPE_ACCESS_IRQ_ACK_RESERVED1_SHIFT)
#define  PIPE_ACCESS_IRQ_ACK_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PIPE_ACCESS_IRQ_ACK_RESERVED1_MASK) | (((uint32_t)val) << PIPE_ACCESS_IRQ_ACK_RESERVED1_SHIFT))

#define  PIPE_ACCESS_IRQ_ACK_CH6_EOI_IRQ_ACK_MASK 0x2
#define  PIPE_ACCESS_IRQ_ACK_CH6_EOI_IRQ_ACK_SHIFT 1
#define  PIPE_ACCESS_IRQ_ACK_CH6_EOI_IRQ_ACK_MASK_SHIFT(reg) (((reg) & PIPE_ACCESS_IRQ_ACK_CH6_EOI_IRQ_ACK_MASK) >> PIPE_ACCESS_IRQ_ACK_CH6_EOI_IRQ_ACK_SHIFT)
#define  PIPE_ACCESS_IRQ_ACK_CH6_EOI_IRQ_ACK_REPLACE_VAL(reg,val) (((reg) & ~PIPE_ACCESS_IRQ_ACK_CH6_EOI_IRQ_ACK_MASK) | (((uint32_t)val) << PIPE_ACCESS_IRQ_ACK_CH6_EOI_IRQ_ACK_SHIFT))

#define  PIPE_ACCESS_IRQ_ACK_CH4_EOI_IRQ_ACK_MASK 0x1
#define  PIPE_ACCESS_IRQ_ACK_CH4_EOI_IRQ_ACK_SHIFT 0
#define  PIPE_ACCESS_IRQ_ACK_CH4_EOI_IRQ_ACK_MASK_SHIFT(reg) (((reg) & PIPE_ACCESS_IRQ_ACK_CH4_EOI_IRQ_ACK_MASK) >> PIPE_ACCESS_IRQ_ACK_CH4_EOI_IRQ_ACK_SHIFT)
#define  PIPE_ACCESS_IRQ_ACK_CH4_EOI_IRQ_ACK_REPLACE_VAL(reg,val) (((reg) & ~PIPE_ACCESS_IRQ_ACK_CH4_EOI_IRQ_ACK_MASK) | (((uint32_t)val) << PIPE_ACCESS_IRQ_ACK_CH4_EOI_IRQ_ACK_SHIFT))

//====================================================================
//Register: Interrupt Force Register (irq_force)
/** \brief Force interrupts from Pipe Access core.*/
//====================================================================

#define  PIPE_ACCESS_IRQ_FORCE_RESERVED1_MASK 0xfffffffc
#define  PIPE_ACCESS_IRQ_FORCE_RESERVED1_SHIFT 2
#define  PIPE_ACCESS_IRQ_FORCE_RESERVED1_MASK_SHIFT(reg) (((reg) & PIPE_ACCESS_IRQ_FORCE_RESERVED1_MASK) >> PIPE_ACCESS_IRQ_FORCE_RESERVED1_SHIFT)
#define  PIPE_ACCESS_IRQ_FORCE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PIPE_ACCESS_IRQ_FORCE_RESERVED1_MASK) | (((uint32_t)val) << PIPE_ACCESS_IRQ_FORCE_RESERVED1_SHIFT))

#define  PIPE_ACCESS_IRQ_FORCE_CH6_EOI_IRQ_FORCE_MASK 0x2
#define  PIPE_ACCESS_IRQ_FORCE_CH6_EOI_IRQ_FORCE_SHIFT 1
#define  PIPE_ACCESS_IRQ_FORCE_CH6_EOI_IRQ_FORCE_MASK_SHIFT(reg) (((reg) & PIPE_ACCESS_IRQ_FORCE_CH6_EOI_IRQ_FORCE_MASK) >> PIPE_ACCESS_IRQ_FORCE_CH6_EOI_IRQ_FORCE_SHIFT)
#define  PIPE_ACCESS_IRQ_FORCE_CH6_EOI_IRQ_FORCE_REPLACE_VAL(reg,val) (((reg) & ~PIPE_ACCESS_IRQ_FORCE_CH6_EOI_IRQ_FORCE_MASK) | (((uint32_t)val) << PIPE_ACCESS_IRQ_FORCE_CH6_EOI_IRQ_FORCE_SHIFT))

#define  PIPE_ACCESS_IRQ_FORCE_CH4_EOI_IRQ_FORCE_MASK 0x1
#define  PIPE_ACCESS_IRQ_FORCE_CH4_EOI_IRQ_FORCE_SHIFT 0
#define  PIPE_ACCESS_IRQ_FORCE_CH4_EOI_IRQ_FORCE_MASK_SHIFT(reg) (((reg) & PIPE_ACCESS_IRQ_FORCE_CH4_EOI_IRQ_FORCE_MASK) >> PIPE_ACCESS_IRQ_FORCE_CH4_EOI_IRQ_FORCE_SHIFT)
#define  PIPE_ACCESS_IRQ_FORCE_CH4_EOI_IRQ_FORCE_REPLACE_VAL(reg,val) (((reg) & ~PIPE_ACCESS_IRQ_FORCE_CH4_EOI_IRQ_FORCE_MASK) | (((uint32_t)val) << PIPE_ACCESS_IRQ_FORCE_CH4_EOI_IRQ_FORCE_SHIFT))

//====================================================================
//Register: Packing Configuration (pack_cfg)
/** \brief Configure packing for pipeline store operation.*/
//====================================================================

#define  PIPE_ACCESS_PACK_CFG_RESERVED1_MASK 0xffff0000
#define  PIPE_ACCESS_PACK_CFG_RESERVED1_SHIFT 16
#define  PIPE_ACCESS_PACK_CFG_RESERVED1_MASK_SHIFT(reg) (((reg) & PIPE_ACCESS_PACK_CFG_RESERVED1_MASK) >> PIPE_ACCESS_PACK_CFG_RESERVED1_SHIFT)
#define  PIPE_ACCESS_PACK_CFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PIPE_ACCESS_PACK_CFG_RESERVED1_MASK) | (((uint32_t)val) << PIPE_ACCESS_PACK_CFG_RESERVED1_SHIFT))

#define  PIPE_ACCESS_PACK_CFG_PACK_8_CHAN_SEL_MASK 0xe000
#define  PIPE_ACCESS_PACK_CFG_PACK_8_CHAN_SEL_SHIFT 13
#define  PIPE_ACCESS_PACK_CFG_PACK_8_CHAN_SEL_MASK_SHIFT(reg) (((reg) & PIPE_ACCESS_PACK_CFG_PACK_8_CHAN_SEL_MASK) >> PIPE_ACCESS_PACK_CFG_PACK_8_CHAN_SEL_SHIFT)
#define  PIPE_ACCESS_PACK_CFG_PACK_8_CHAN_SEL_REPLACE_VAL(reg,val) (((reg) & ~PIPE_ACCESS_PACK_CFG_PACK_8_CHAN_SEL_MASK) | (((uint32_t)val) << PIPE_ACCESS_PACK_CFG_PACK_8_CHAN_SEL_SHIFT))

#define  PIPE_ACCESS_PACK_CFG_PACK_32_CHAN_SEL_MASK 0x1000
#define  PIPE_ACCESS_PACK_CFG_PACK_32_CHAN_SEL_SHIFT 12
#define  PIPE_ACCESS_PACK_CFG_PACK_32_CHAN_SEL_MASK_SHIFT(reg) (((reg) & PIPE_ACCESS_PACK_CFG_PACK_32_CHAN_SEL_MASK) >> PIPE_ACCESS_PACK_CFG_PACK_32_CHAN_SEL_SHIFT)
#define  PIPE_ACCESS_PACK_CFG_PACK_32_CHAN_SEL_REPLACE_VAL(reg,val) (((reg) & ~PIPE_ACCESS_PACK_CFG_PACK_32_CHAN_SEL_MASK) | (((uint32_t)val) << PIPE_ACCESS_PACK_CFG_PACK_32_CHAN_SEL_SHIFT))

#define  PIPE_ACCESS_PACK_CFG_RESERVED2_MASK 0xe00
#define  PIPE_ACCESS_PACK_CFG_RESERVED2_SHIFT 9
#define  PIPE_ACCESS_PACK_CFG_RESERVED2_MASK_SHIFT(reg) (((reg) & PIPE_ACCESS_PACK_CFG_RESERVED2_MASK) >> PIPE_ACCESS_PACK_CFG_RESERVED2_SHIFT)
#define  PIPE_ACCESS_PACK_CFG_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~PIPE_ACCESS_PACK_CFG_RESERVED2_MASK) | (((uint32_t)val) << PIPE_ACCESS_PACK_CFG_RESERVED2_SHIFT))

#define  PIPE_ACCESS_PACK_CFG_PACK_SIDEBAND_MSB_MASK 0x100
#define  PIPE_ACCESS_PACK_CFG_PACK_SIDEBAND_MSB_SHIFT 8
#define  PIPE_ACCESS_PACK_CFG_PACK_SIDEBAND_MSB_MASK_SHIFT(reg) (((reg) & PIPE_ACCESS_PACK_CFG_PACK_SIDEBAND_MSB_MASK) >> PIPE_ACCESS_PACK_CFG_PACK_SIDEBAND_MSB_SHIFT)
#define  PIPE_ACCESS_PACK_CFG_PACK_SIDEBAND_MSB_REPLACE_VAL(reg,val) (((reg) & ~PIPE_ACCESS_PACK_CFG_PACK_SIDEBAND_MSB_MASK) | (((uint32_t)val) << PIPE_ACCESS_PACK_CFG_PACK_SIDEBAND_MSB_SHIFT))

#define  PIPE_ACCESS_PACK_CFG_RESERVED3_MASK 0xe0
#define  PIPE_ACCESS_PACK_CFG_RESERVED3_SHIFT 5
#define  PIPE_ACCESS_PACK_CFG_RESERVED3_MASK_SHIFT(reg) (((reg) & PIPE_ACCESS_PACK_CFG_RESERVED3_MASK) >> PIPE_ACCESS_PACK_CFG_RESERVED3_SHIFT)
#define  PIPE_ACCESS_PACK_CFG_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~PIPE_ACCESS_PACK_CFG_RESERVED3_MASK) | (((uint32_t)val) << PIPE_ACCESS_PACK_CFG_RESERVED3_SHIFT))

#define  PIPE_ACCESS_PACK_CFG_PACK_SHIFT_2_MASK 0x10
#define  PIPE_ACCESS_PACK_CFG_PACK_SHIFT_2_SHIFT 4
#define  PIPE_ACCESS_PACK_CFG_PACK_SHIFT_2_MASK_SHIFT(reg) (((reg) & PIPE_ACCESS_PACK_CFG_PACK_SHIFT_2_MASK) >> PIPE_ACCESS_PACK_CFG_PACK_SHIFT_2_SHIFT)
#define  PIPE_ACCESS_PACK_CFG_PACK_SHIFT_2_REPLACE_VAL(reg,val) (((reg) & ~PIPE_ACCESS_PACK_CFG_PACK_SHIFT_2_MASK) | (((uint32_t)val) << PIPE_ACCESS_PACK_CFG_PACK_SHIFT_2_SHIFT))

#define  PIPE_ACCESS_PACK_CFG_RESERVED4_MASK 0xc
#define  PIPE_ACCESS_PACK_CFG_RESERVED4_SHIFT 2
#define  PIPE_ACCESS_PACK_CFG_RESERVED4_MASK_SHIFT(reg) (((reg) & PIPE_ACCESS_PACK_CFG_RESERVED4_MASK) >> PIPE_ACCESS_PACK_CFG_RESERVED4_SHIFT)
#define  PIPE_ACCESS_PACK_CFG_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~PIPE_ACCESS_PACK_CFG_RESERVED4_MASK) | (((uint32_t)val) << PIPE_ACCESS_PACK_CFG_RESERVED4_SHIFT))

#define  PIPE_ACCESS_PACK_CFG_PACK_MODE_MASK 0x3
#define  PIPE_ACCESS_PACK_CFG_PACK_MODE_SHIFT 0
#define  PIPE_ACCESS_PACK_CFG_PACK_MODE_MASK_SHIFT(reg) (((reg) & PIPE_ACCESS_PACK_CFG_PACK_MODE_MASK) >> PIPE_ACCESS_PACK_CFG_PACK_MODE_SHIFT)
#define  PIPE_ACCESS_PACK_CFG_PACK_MODE_REPLACE_VAL(reg,val) (((reg) & ~PIPE_ACCESS_PACK_CFG_PACK_MODE_MASK) | (((uint32_t)val) << PIPE_ACCESS_PACK_CFG_PACK_MODE_SHIFT))

//====================================================================
//Register: Unpacking Configuration (unpack_cfg)
/** \brief Configure unpacking for pipeline load operation.*/
//====================================================================

#define  PIPE_ACCESS_UNPACK_CFG_RESERVED1_MASK 0xff000000
#define  PIPE_ACCESS_UNPACK_CFG_RESERVED1_SHIFT 24
#define  PIPE_ACCESS_UNPACK_CFG_RESERVED1_MASK_SHIFT(reg) (((reg) & PIPE_ACCESS_UNPACK_CFG_RESERVED1_MASK) >> PIPE_ACCESS_UNPACK_CFG_RESERVED1_SHIFT)
#define  PIPE_ACCESS_UNPACK_CFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PIPE_ACCESS_UNPACK_CFG_RESERVED1_MASK) | (((uint32_t)val) << PIPE_ACCESS_UNPACK_CFG_RESERVED1_SHIFT))

#define  PIPE_ACCESS_UNPACK_CFG_SIDEBAND_FW_VAL_MASK 0xff0000
#define  PIPE_ACCESS_UNPACK_CFG_SIDEBAND_FW_VAL_SHIFT 16
#define  PIPE_ACCESS_UNPACK_CFG_SIDEBAND_FW_VAL_MASK_SHIFT(reg) (((reg) & PIPE_ACCESS_UNPACK_CFG_SIDEBAND_FW_VAL_MASK) >> PIPE_ACCESS_UNPACK_CFG_SIDEBAND_FW_VAL_SHIFT)
#define  PIPE_ACCESS_UNPACK_CFG_SIDEBAND_FW_VAL_REPLACE_VAL(reg,val) (((reg) & ~PIPE_ACCESS_UNPACK_CFG_SIDEBAND_FW_VAL_MASK) | (((uint32_t)val) << PIPE_ACCESS_UNPACK_CFG_SIDEBAND_FW_VAL_SHIFT))

#define  PIPE_ACCESS_UNPACK_CFG_UNPACK_8_CHAN_SEL_MASK 0xe000
#define  PIPE_ACCESS_UNPACK_CFG_UNPACK_8_CHAN_SEL_SHIFT 13
#define  PIPE_ACCESS_UNPACK_CFG_UNPACK_8_CHAN_SEL_MASK_SHIFT(reg) (((reg) & PIPE_ACCESS_UNPACK_CFG_UNPACK_8_CHAN_SEL_MASK) >> PIPE_ACCESS_UNPACK_CFG_UNPACK_8_CHAN_SEL_SHIFT)
#define  PIPE_ACCESS_UNPACK_CFG_UNPACK_8_CHAN_SEL_REPLACE_VAL(reg,val) (((reg) & ~PIPE_ACCESS_UNPACK_CFG_UNPACK_8_CHAN_SEL_MASK) | (((uint32_t)val) << PIPE_ACCESS_UNPACK_CFG_UNPACK_8_CHAN_SEL_SHIFT))

#define  PIPE_ACCESS_UNPACK_CFG_UNPACK_32_CHAN_SEL_MASK 0x1000
#define  PIPE_ACCESS_UNPACK_CFG_UNPACK_32_CHAN_SEL_SHIFT 12
#define  PIPE_ACCESS_UNPACK_CFG_UNPACK_32_CHAN_SEL_MASK_SHIFT(reg) (((reg) & PIPE_ACCESS_UNPACK_CFG_UNPACK_32_CHAN_SEL_MASK) >> PIPE_ACCESS_UNPACK_CFG_UNPACK_32_CHAN_SEL_SHIFT)
#define  PIPE_ACCESS_UNPACK_CFG_UNPACK_32_CHAN_SEL_REPLACE_VAL(reg,val) (((reg) & ~PIPE_ACCESS_UNPACK_CFG_UNPACK_32_CHAN_SEL_MASK) | (((uint32_t)val) << PIPE_ACCESS_UNPACK_CFG_UNPACK_32_CHAN_SEL_SHIFT))

#define  PIPE_ACCESS_UNPACK_CFG_RESERVED2_MASK 0xc00
#define  PIPE_ACCESS_UNPACK_CFG_RESERVED2_SHIFT 10
#define  PIPE_ACCESS_UNPACK_CFG_RESERVED2_MASK_SHIFT(reg) (((reg) & PIPE_ACCESS_UNPACK_CFG_RESERVED2_MASK) >> PIPE_ACCESS_UNPACK_CFG_RESERVED2_SHIFT)
#define  PIPE_ACCESS_UNPACK_CFG_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~PIPE_ACCESS_UNPACK_CFG_RESERVED2_MASK) | (((uint32_t)val) << PIPE_ACCESS_UNPACK_CFG_RESERVED2_SHIFT))

#define  PIPE_ACCESS_UNPACK_CFG_UNPACK_USE_SIDEBAND_FW_MASK 0x200
#define  PIPE_ACCESS_UNPACK_CFG_UNPACK_USE_SIDEBAND_FW_SHIFT 9
#define  PIPE_ACCESS_UNPACK_CFG_UNPACK_USE_SIDEBAND_FW_MASK_SHIFT(reg) (((reg) & PIPE_ACCESS_UNPACK_CFG_UNPACK_USE_SIDEBAND_FW_MASK) >> PIPE_ACCESS_UNPACK_CFG_UNPACK_USE_SIDEBAND_FW_SHIFT)
#define  PIPE_ACCESS_UNPACK_CFG_UNPACK_USE_SIDEBAND_FW_REPLACE_VAL(reg,val) (((reg) & ~PIPE_ACCESS_UNPACK_CFG_UNPACK_USE_SIDEBAND_FW_MASK) | (((uint32_t)val) << PIPE_ACCESS_UNPACK_CFG_UNPACK_USE_SIDEBAND_FW_SHIFT))

#define  PIPE_ACCESS_UNPACK_CFG_UNPACK_SIDEBAND_MSB_MASK 0x100
#define  PIPE_ACCESS_UNPACK_CFG_UNPACK_SIDEBAND_MSB_SHIFT 8
#define  PIPE_ACCESS_UNPACK_CFG_UNPACK_SIDEBAND_MSB_MASK_SHIFT(reg) (((reg) & PIPE_ACCESS_UNPACK_CFG_UNPACK_SIDEBAND_MSB_MASK) >> PIPE_ACCESS_UNPACK_CFG_UNPACK_SIDEBAND_MSB_SHIFT)
#define  PIPE_ACCESS_UNPACK_CFG_UNPACK_SIDEBAND_MSB_REPLACE_VAL(reg,val) (((reg) & ~PIPE_ACCESS_UNPACK_CFG_UNPACK_SIDEBAND_MSB_MASK) | (((uint32_t)val) << PIPE_ACCESS_UNPACK_CFG_UNPACK_SIDEBAND_MSB_SHIFT))

#define  PIPE_ACCESS_UNPACK_CFG_RESERVED3_MASK 0xe0
#define  PIPE_ACCESS_UNPACK_CFG_RESERVED3_SHIFT 5
#define  PIPE_ACCESS_UNPACK_CFG_RESERVED3_MASK_SHIFT(reg) (((reg) & PIPE_ACCESS_UNPACK_CFG_RESERVED3_MASK) >> PIPE_ACCESS_UNPACK_CFG_RESERVED3_SHIFT)
#define  PIPE_ACCESS_UNPACK_CFG_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~PIPE_ACCESS_UNPACK_CFG_RESERVED3_MASK) | (((uint32_t)val) << PIPE_ACCESS_UNPACK_CFG_RESERVED3_SHIFT))

#define  PIPE_ACCESS_UNPACK_CFG_UNPACK_SHIFT_2_MASK 0x10
#define  PIPE_ACCESS_UNPACK_CFG_UNPACK_SHIFT_2_SHIFT 4
#define  PIPE_ACCESS_UNPACK_CFG_UNPACK_SHIFT_2_MASK_SHIFT(reg) (((reg) & PIPE_ACCESS_UNPACK_CFG_UNPACK_SHIFT_2_MASK) >> PIPE_ACCESS_UNPACK_CFG_UNPACK_SHIFT_2_SHIFT)
#define  PIPE_ACCESS_UNPACK_CFG_UNPACK_SHIFT_2_REPLACE_VAL(reg,val) (((reg) & ~PIPE_ACCESS_UNPACK_CFG_UNPACK_SHIFT_2_MASK) | (((uint32_t)val) << PIPE_ACCESS_UNPACK_CFG_UNPACK_SHIFT_2_SHIFT))

#define  PIPE_ACCESS_UNPACK_CFG_RESERVED4_MASK 0xc
#define  PIPE_ACCESS_UNPACK_CFG_RESERVED4_SHIFT 2
#define  PIPE_ACCESS_UNPACK_CFG_RESERVED4_MASK_SHIFT(reg) (((reg) & PIPE_ACCESS_UNPACK_CFG_RESERVED4_MASK) >> PIPE_ACCESS_UNPACK_CFG_RESERVED4_SHIFT)
#define  PIPE_ACCESS_UNPACK_CFG_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~PIPE_ACCESS_UNPACK_CFG_RESERVED4_MASK) | (((uint32_t)val) << PIPE_ACCESS_UNPACK_CFG_RESERVED4_SHIFT))

#define  PIPE_ACCESS_UNPACK_CFG_UNPACK_MODE_MASK 0x3
#define  PIPE_ACCESS_UNPACK_CFG_UNPACK_MODE_SHIFT 0
#define  PIPE_ACCESS_UNPACK_CFG_UNPACK_MODE_MASK_SHIFT(reg) (((reg) & PIPE_ACCESS_UNPACK_CFG_UNPACK_MODE_MASK) >> PIPE_ACCESS_UNPACK_CFG_UNPACK_MODE_SHIFT)
#define  PIPE_ACCESS_UNPACK_CFG_UNPACK_MODE_REPLACE_VAL(reg,val) (((reg) & ~PIPE_ACCESS_UNPACK_CFG_UNPACK_MODE_MASK) | (((uint32_t)val) << PIPE_ACCESS_UNPACK_CFG_UNPACK_MODE_SHIFT))

//====================================================================
//Register: 1D LUT 3,4,5 Input Selection (lut_input_sel)
/** \brief Configure channel muxing on inputs to 1-D LUTs.*/
//====================================================================

#define  PIPE_ACCESS_LUT_INPUT_SEL_RESERVED1_MASK 0xfffffc00
#define  PIPE_ACCESS_LUT_INPUT_SEL_RESERVED1_SHIFT 10
#define  PIPE_ACCESS_LUT_INPUT_SEL_RESERVED1_MASK_SHIFT(reg) (((reg) & PIPE_ACCESS_LUT_INPUT_SEL_RESERVED1_MASK) >> PIPE_ACCESS_LUT_INPUT_SEL_RESERVED1_SHIFT)
#define  PIPE_ACCESS_LUT_INPUT_SEL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PIPE_ACCESS_LUT_INPUT_SEL_RESERVED1_MASK) | (((uint32_t)val) << PIPE_ACCESS_LUT_INPUT_SEL_RESERVED1_SHIFT))

#define  PIPE_ACCESS_LUT_INPUT_SEL_LUT_5_INPUT_SEL_MASK 0x300
#define  PIPE_ACCESS_LUT_INPUT_SEL_LUT_5_INPUT_SEL_SHIFT 8
#define  PIPE_ACCESS_LUT_INPUT_SEL_LUT_5_INPUT_SEL_MASK_SHIFT(reg) (((reg) & PIPE_ACCESS_LUT_INPUT_SEL_LUT_5_INPUT_SEL_MASK) >> PIPE_ACCESS_LUT_INPUT_SEL_LUT_5_INPUT_SEL_SHIFT)
#define  PIPE_ACCESS_LUT_INPUT_SEL_LUT_5_INPUT_SEL_REPLACE_VAL(reg,val) (((reg) & ~PIPE_ACCESS_LUT_INPUT_SEL_LUT_5_INPUT_SEL_MASK) | (((uint32_t)val) << PIPE_ACCESS_LUT_INPUT_SEL_LUT_5_INPUT_SEL_SHIFT))

#define  PIPE_ACCESS_LUT_INPUT_SEL_RESERVED2_MASK 0x80
#define  PIPE_ACCESS_LUT_INPUT_SEL_RESERVED2_SHIFT 7
#define  PIPE_ACCESS_LUT_INPUT_SEL_RESERVED2_MASK_SHIFT(reg) (((reg) & PIPE_ACCESS_LUT_INPUT_SEL_RESERVED2_MASK) >> PIPE_ACCESS_LUT_INPUT_SEL_RESERVED2_SHIFT)
#define  PIPE_ACCESS_LUT_INPUT_SEL_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~PIPE_ACCESS_LUT_INPUT_SEL_RESERVED2_MASK) | (((uint32_t)val) << PIPE_ACCESS_LUT_INPUT_SEL_RESERVED2_SHIFT))

#define  PIPE_ACCESS_LUT_INPUT_SEL_LUT_4_INPUT_SEL_MASK 0x70
#define  PIPE_ACCESS_LUT_INPUT_SEL_LUT_4_INPUT_SEL_SHIFT 4
#define  PIPE_ACCESS_LUT_INPUT_SEL_LUT_4_INPUT_SEL_MASK_SHIFT(reg) (((reg) & PIPE_ACCESS_LUT_INPUT_SEL_LUT_4_INPUT_SEL_MASK) >> PIPE_ACCESS_LUT_INPUT_SEL_LUT_4_INPUT_SEL_SHIFT)
#define  PIPE_ACCESS_LUT_INPUT_SEL_LUT_4_INPUT_SEL_REPLACE_VAL(reg,val) (((reg) & ~PIPE_ACCESS_LUT_INPUT_SEL_LUT_4_INPUT_SEL_MASK) | (((uint32_t)val) << PIPE_ACCESS_LUT_INPUT_SEL_LUT_4_INPUT_SEL_SHIFT))

#define  PIPE_ACCESS_LUT_INPUT_SEL_RESERVED3_MASK 0xe
#define  PIPE_ACCESS_LUT_INPUT_SEL_RESERVED3_SHIFT 1
#define  PIPE_ACCESS_LUT_INPUT_SEL_RESERVED3_MASK_SHIFT(reg) (((reg) & PIPE_ACCESS_LUT_INPUT_SEL_RESERVED3_MASK) >> PIPE_ACCESS_LUT_INPUT_SEL_RESERVED3_SHIFT)
#define  PIPE_ACCESS_LUT_INPUT_SEL_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~PIPE_ACCESS_LUT_INPUT_SEL_RESERVED3_MASK) | (((uint32_t)val) << PIPE_ACCESS_LUT_INPUT_SEL_RESERVED3_SHIFT))

#define  PIPE_ACCESS_LUT_INPUT_SEL_LUT_3_INPUT_SEL_MASK 0x1
#define  PIPE_ACCESS_LUT_INPUT_SEL_LUT_3_INPUT_SEL_SHIFT 0
#define  PIPE_ACCESS_LUT_INPUT_SEL_LUT_3_INPUT_SEL_MASK_SHIFT(reg) (((reg) & PIPE_ACCESS_LUT_INPUT_SEL_LUT_3_INPUT_SEL_MASK) >> PIPE_ACCESS_LUT_INPUT_SEL_LUT_3_INPUT_SEL_SHIFT)
#define  PIPE_ACCESS_LUT_INPUT_SEL_LUT_3_INPUT_SEL_REPLACE_VAL(reg,val) (((reg) & ~PIPE_ACCESS_LUT_INPUT_SEL_LUT_3_INPUT_SEL_MASK) | (((uint32_t)val) << PIPE_ACCESS_LUT_INPUT_SEL_LUT_3_INPUT_SEL_SHIFT))

//====================================================================
//Register: 1D LUT Per Pixel Enable Register (per_pixel_en)
/** \brief Configure per-pixel-enable/disable for 1-D LUT operation.*/
//====================================================================

#define  PIPE_ACCESS_PER_PIXEL_EN_RESERVED1_MASK 0xffffe000
#define  PIPE_ACCESS_PER_PIXEL_EN_RESERVED1_SHIFT 13
#define  PIPE_ACCESS_PER_PIXEL_EN_RESERVED1_MASK_SHIFT(reg) (((reg) & PIPE_ACCESS_PER_PIXEL_EN_RESERVED1_MASK) >> PIPE_ACCESS_PER_PIXEL_EN_RESERVED1_SHIFT)
#define  PIPE_ACCESS_PER_PIXEL_EN_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PIPE_ACCESS_PER_PIXEL_EN_RESERVED1_MASK) | (((uint32_t)val) << PIPE_ACCESS_PER_PIXEL_EN_RESERVED1_SHIFT))

#define  PIPE_ACCESS_PER_PIXEL_EN_PER_PIXEL_ENABLE_MASK 0x1000
#define  PIPE_ACCESS_PER_PIXEL_EN_PER_PIXEL_ENABLE_SHIFT 12
#define  PIPE_ACCESS_PER_PIXEL_EN_PER_PIXEL_ENABLE_MASK_SHIFT(reg) (((reg) & PIPE_ACCESS_PER_PIXEL_EN_PER_PIXEL_ENABLE_MASK) >> PIPE_ACCESS_PER_PIXEL_EN_PER_PIXEL_ENABLE_SHIFT)
#define  PIPE_ACCESS_PER_PIXEL_EN_PER_PIXEL_ENABLE_REPLACE_VAL(reg,val) (((reg) & ~PIPE_ACCESS_PER_PIXEL_EN_PER_PIXEL_ENABLE_MASK) | (((uint32_t)val) << PIPE_ACCESS_PER_PIXEL_EN_PER_PIXEL_ENABLE_SHIFT))

#define  PIPE_ACCESS_PER_PIXEL_EN_RESERVED2_MASK 0xe00
#define  PIPE_ACCESS_PER_PIXEL_EN_RESERVED2_SHIFT 9
#define  PIPE_ACCESS_PER_PIXEL_EN_RESERVED2_MASK_SHIFT(reg) (((reg) & PIPE_ACCESS_PER_PIXEL_EN_RESERVED2_MASK) >> PIPE_ACCESS_PER_PIXEL_EN_RESERVED2_SHIFT)
#define  PIPE_ACCESS_PER_PIXEL_EN_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~PIPE_ACCESS_PER_PIXEL_EN_RESERVED2_MASK) | (((uint32_t)val) << PIPE_ACCESS_PER_PIXEL_EN_RESERVED2_SHIFT))

#define  PIPE_ACCESS_PER_PIXEL_EN_PER_PIXEL_POLARITY_MASK 0x100
#define  PIPE_ACCESS_PER_PIXEL_EN_PER_PIXEL_POLARITY_SHIFT 8
#define  PIPE_ACCESS_PER_PIXEL_EN_PER_PIXEL_POLARITY_MASK_SHIFT(reg) (((reg) & PIPE_ACCESS_PER_PIXEL_EN_PER_PIXEL_POLARITY_MASK) >> PIPE_ACCESS_PER_PIXEL_EN_PER_PIXEL_POLARITY_SHIFT)
#define  PIPE_ACCESS_PER_PIXEL_EN_PER_PIXEL_POLARITY_REPLACE_VAL(reg,val) (((reg) & ~PIPE_ACCESS_PER_PIXEL_EN_PER_PIXEL_POLARITY_MASK) | (((uint32_t)val) << PIPE_ACCESS_PER_PIXEL_EN_PER_PIXEL_POLARITY_SHIFT))

#define  PIPE_ACCESS_PER_PIXEL_EN_RESERVED3_MASK 0xf8
#define  PIPE_ACCESS_PER_PIXEL_EN_RESERVED3_SHIFT 3
#define  PIPE_ACCESS_PER_PIXEL_EN_RESERVED3_MASK_SHIFT(reg) (((reg) & PIPE_ACCESS_PER_PIXEL_EN_RESERVED3_MASK) >> PIPE_ACCESS_PER_PIXEL_EN_RESERVED3_SHIFT)
#define  PIPE_ACCESS_PER_PIXEL_EN_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~PIPE_ACCESS_PER_PIXEL_EN_RESERVED3_MASK) | (((uint32_t)val) << PIPE_ACCESS_PER_PIXEL_EN_RESERVED3_SHIFT))

#define  PIPE_ACCESS_PER_PIXEL_EN_PER_PIXEL_SEL_MASK 0x7
#define  PIPE_ACCESS_PER_PIXEL_EN_PER_PIXEL_SEL_SHIFT 0
#define  PIPE_ACCESS_PER_PIXEL_EN_PER_PIXEL_SEL_MASK_SHIFT(reg) (((reg) & PIPE_ACCESS_PER_PIXEL_EN_PER_PIXEL_SEL_MASK) >> PIPE_ACCESS_PER_PIXEL_EN_PER_PIXEL_SEL_SHIFT)
#define  PIPE_ACCESS_PER_PIXEL_EN_PER_PIXEL_SEL_REPLACE_VAL(reg,val) (((reg) & ~PIPE_ACCESS_PER_PIXEL_EN_PER_PIXEL_SEL_MASK) | (((uint32_t)val) << PIPE_ACCESS_PER_PIXEL_EN_PER_PIXEL_SEL_SHIFT))

//====================================================================
//Register: Stats Configuration Register 0 (stats_cfg0)
/** \brief 1st Stats configuration register - dimensions and enable.*/
//====================================================================

#define  PIPE_ACCESS_STATS_CFG0_IMAGE_WIDTH_MASK 0xffff0000
#define  PIPE_ACCESS_STATS_CFG0_IMAGE_WIDTH_SHIFT 16
#define  PIPE_ACCESS_STATS_CFG0_IMAGE_WIDTH_MASK_SHIFT(reg) (((reg) & PIPE_ACCESS_STATS_CFG0_IMAGE_WIDTH_MASK) >> PIPE_ACCESS_STATS_CFG0_IMAGE_WIDTH_SHIFT)
#define  PIPE_ACCESS_STATS_CFG0_IMAGE_WIDTH_REPLACE_VAL(reg,val) (((reg) & ~PIPE_ACCESS_STATS_CFG0_IMAGE_WIDTH_MASK) | (((uint32_t)val) << PIPE_ACCESS_STATS_CFG0_IMAGE_WIDTH_SHIFT))

#define  PIPE_ACCESS_STATS_CFG0_RESERVED1_MASK 0xe000
#define  PIPE_ACCESS_STATS_CFG0_RESERVED1_SHIFT 13
#define  PIPE_ACCESS_STATS_CFG0_RESERVED1_MASK_SHIFT(reg) (((reg) & PIPE_ACCESS_STATS_CFG0_RESERVED1_MASK) >> PIPE_ACCESS_STATS_CFG0_RESERVED1_SHIFT)
#define  PIPE_ACCESS_STATS_CFG0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PIPE_ACCESS_STATS_CFG0_RESERVED1_MASK) | (((uint32_t)val) << PIPE_ACCESS_STATS_CFG0_RESERVED1_SHIFT))

#define  PIPE_ACCESS_STATS_CFG0_PATCH_HEIGHT_MASK 0x1ff0
#define  PIPE_ACCESS_STATS_CFG0_PATCH_HEIGHT_SHIFT 4
#define  PIPE_ACCESS_STATS_CFG0_PATCH_HEIGHT_MASK_SHIFT(reg) (((reg) & PIPE_ACCESS_STATS_CFG0_PATCH_HEIGHT_MASK) >> PIPE_ACCESS_STATS_CFG0_PATCH_HEIGHT_SHIFT)
#define  PIPE_ACCESS_STATS_CFG0_PATCH_HEIGHT_REPLACE_VAL(reg,val) (((reg) & ~PIPE_ACCESS_STATS_CFG0_PATCH_HEIGHT_MASK) | (((uint32_t)val) << PIPE_ACCESS_STATS_CFG0_PATCH_HEIGHT_SHIFT))

#define  PIPE_ACCESS_STATS_CFG0_RESERVED2_MASK 0xc
#define  PIPE_ACCESS_STATS_CFG0_RESERVED2_SHIFT 2
#define  PIPE_ACCESS_STATS_CFG0_RESERVED2_MASK_SHIFT(reg) (((reg) & PIPE_ACCESS_STATS_CFG0_RESERVED2_MASK) >> PIPE_ACCESS_STATS_CFG0_RESERVED2_SHIFT)
#define  PIPE_ACCESS_STATS_CFG0_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~PIPE_ACCESS_STATS_CFG0_RESERVED2_MASK) | (((uint32_t)val) << PIPE_ACCESS_STATS_CFG0_RESERVED2_SHIFT))

#define  PIPE_ACCESS_STATS_CFG0_STATS_SELECT_MASK 0x2
#define  PIPE_ACCESS_STATS_CFG0_STATS_SELECT_SHIFT 1
#define  PIPE_ACCESS_STATS_CFG0_STATS_SELECT_MASK_SHIFT(reg) (((reg) & PIPE_ACCESS_STATS_CFG0_STATS_SELECT_MASK) >> PIPE_ACCESS_STATS_CFG0_STATS_SELECT_SHIFT)
#define  PIPE_ACCESS_STATS_CFG0_STATS_SELECT_REPLACE_VAL(reg,val) (((reg) & ~PIPE_ACCESS_STATS_CFG0_STATS_SELECT_MASK) | (((uint32_t)val) << PIPE_ACCESS_STATS_CFG0_STATS_SELECT_SHIFT))

#define  PIPE_ACCESS_STATS_CFG0_STATS_EN_MASK 0x1
#define  PIPE_ACCESS_STATS_CFG0_STATS_EN_SHIFT 0
#define  PIPE_ACCESS_STATS_CFG0_STATS_EN_MASK_SHIFT(reg) (((reg) & PIPE_ACCESS_STATS_CFG0_STATS_EN_MASK) >> PIPE_ACCESS_STATS_CFG0_STATS_EN_SHIFT)
#define  PIPE_ACCESS_STATS_CFG0_STATS_EN_REPLACE_VAL(reg,val) (((reg) & ~PIPE_ACCESS_STATS_CFG0_STATS_EN_MASK) | (((uint32_t)val) << PIPE_ACCESS_STATS_CFG0_STATS_EN_SHIFT))

//====================================================================
//Register: Stats Configuration Register 1 (stats_cfg1)
/** \brief 2nd Stats configuration register - thresholds.*/
//====================================================================

#define  PIPE_ACCESS_STATS_CFG1_RESERVED1_MASK 0xfc000000
#define  PIPE_ACCESS_STATS_CFG1_RESERVED1_SHIFT 26
#define  PIPE_ACCESS_STATS_CFG1_RESERVED1_MASK_SHIFT(reg) (((reg) & PIPE_ACCESS_STATS_CFG1_RESERVED1_MASK) >> PIPE_ACCESS_STATS_CFG1_RESERVED1_SHIFT)
#define  PIPE_ACCESS_STATS_CFG1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PIPE_ACCESS_STATS_CFG1_RESERVED1_MASK) | (((uint32_t)val) << PIPE_ACCESS_STATS_CFG1_RESERVED1_SHIFT))

#define  PIPE_ACCESS_STATS_CFG1_THRESH0_MASK 0x3ff0000
#define  PIPE_ACCESS_STATS_CFG1_THRESH0_SHIFT 16
#define  PIPE_ACCESS_STATS_CFG1_THRESH0_MASK_SHIFT(reg) (((reg) & PIPE_ACCESS_STATS_CFG1_THRESH0_MASK) >> PIPE_ACCESS_STATS_CFG1_THRESH0_SHIFT)
#define  PIPE_ACCESS_STATS_CFG1_THRESH0_REPLACE_VAL(reg,val) (((reg) & ~PIPE_ACCESS_STATS_CFG1_THRESH0_MASK) | (((uint32_t)val) << PIPE_ACCESS_STATS_CFG1_THRESH0_SHIFT))

#define  PIPE_ACCESS_STATS_CFG1_RESERVED2_MASK 0xfc00
#define  PIPE_ACCESS_STATS_CFG1_RESERVED2_SHIFT 10
#define  PIPE_ACCESS_STATS_CFG1_RESERVED2_MASK_SHIFT(reg) (((reg) & PIPE_ACCESS_STATS_CFG1_RESERVED2_MASK) >> PIPE_ACCESS_STATS_CFG1_RESERVED2_SHIFT)
#define  PIPE_ACCESS_STATS_CFG1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~PIPE_ACCESS_STATS_CFG1_RESERVED2_MASK) | (((uint32_t)val) << PIPE_ACCESS_STATS_CFG1_RESERVED2_SHIFT))

#define  PIPE_ACCESS_STATS_CFG1_THRESH1_MASK 0x3ff
#define  PIPE_ACCESS_STATS_CFG1_THRESH1_SHIFT 0
#define  PIPE_ACCESS_STATS_CFG1_THRESH1_MASK_SHIFT(reg) (((reg) & PIPE_ACCESS_STATS_CFG1_THRESH1_MASK) >> PIPE_ACCESS_STATS_CFG1_THRESH1_SHIFT)
#define  PIPE_ACCESS_STATS_CFG1_THRESH1_REPLACE_VAL(reg,val) (((reg) & ~PIPE_ACCESS_STATS_CFG1_THRESH1_MASK) | (((uint32_t)val) << PIPE_ACCESS_STATS_CFG1_THRESH1_SHIFT))

//====================================================================
//Register: Stats Configuration Register 2 (stats_cfg2)
/** \brief 3rd Stats configuration register - thresholds.*/
//====================================================================

#define  PIPE_ACCESS_STATS_CFG2_RESERVED1_MASK 0xfc000000
#define  PIPE_ACCESS_STATS_CFG2_RESERVED1_SHIFT 26
#define  PIPE_ACCESS_STATS_CFG2_RESERVED1_MASK_SHIFT(reg) (((reg) & PIPE_ACCESS_STATS_CFG2_RESERVED1_MASK) >> PIPE_ACCESS_STATS_CFG2_RESERVED1_SHIFT)
#define  PIPE_ACCESS_STATS_CFG2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PIPE_ACCESS_STATS_CFG2_RESERVED1_MASK) | (((uint32_t)val) << PIPE_ACCESS_STATS_CFG2_RESERVED1_SHIFT))

#define  PIPE_ACCESS_STATS_CFG2_THRESH2_MASK 0x3ff0000
#define  PIPE_ACCESS_STATS_CFG2_THRESH2_SHIFT 16
#define  PIPE_ACCESS_STATS_CFG2_THRESH2_MASK_SHIFT(reg) (((reg) & PIPE_ACCESS_STATS_CFG2_THRESH2_MASK) >> PIPE_ACCESS_STATS_CFG2_THRESH2_SHIFT)
#define  PIPE_ACCESS_STATS_CFG2_THRESH2_REPLACE_VAL(reg,val) (((reg) & ~PIPE_ACCESS_STATS_CFG2_THRESH2_MASK) | (((uint32_t)val) << PIPE_ACCESS_STATS_CFG2_THRESH2_SHIFT))

#define  PIPE_ACCESS_STATS_CFG2_RESERVED2_MASK 0xfc00
#define  PIPE_ACCESS_STATS_CFG2_RESERVED2_SHIFT 10
#define  PIPE_ACCESS_STATS_CFG2_RESERVED2_MASK_SHIFT(reg) (((reg) & PIPE_ACCESS_STATS_CFG2_RESERVED2_MASK) >> PIPE_ACCESS_STATS_CFG2_RESERVED2_SHIFT)
#define  PIPE_ACCESS_STATS_CFG2_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~PIPE_ACCESS_STATS_CFG2_RESERVED2_MASK) | (((uint32_t)val) << PIPE_ACCESS_STATS_CFG2_RESERVED2_SHIFT))

#define  PIPE_ACCESS_STATS_CFG2_THRESH3_MASK 0x3ff
#define  PIPE_ACCESS_STATS_CFG2_THRESH3_SHIFT 0
#define  PIPE_ACCESS_STATS_CFG2_THRESH3_MASK_SHIFT(reg) (((reg) & PIPE_ACCESS_STATS_CFG2_THRESH3_MASK) >> PIPE_ACCESS_STATS_CFG2_THRESH3_SHIFT)
#define  PIPE_ACCESS_STATS_CFG2_THRESH3_REPLACE_VAL(reg,val) (((reg) & ~PIPE_ACCESS_STATS_CFG2_THRESH3_MASK) | (((uint32_t)val) << PIPE_ACCESS_STATS_CFG2_THRESH3_SHIFT))

//====================================================================
//Register: Stats Configuration Register 3 (stats_cfg3)
/** \brief 4th Stats configuration register - thresholds.*/
//====================================================================

#define  PIPE_ACCESS_STATS_CFG3_RESERVED1_MASK 0xfc000000
#define  PIPE_ACCESS_STATS_CFG3_RESERVED1_SHIFT 26
#define  PIPE_ACCESS_STATS_CFG3_RESERVED1_MASK_SHIFT(reg) (((reg) & PIPE_ACCESS_STATS_CFG3_RESERVED1_MASK) >> PIPE_ACCESS_STATS_CFG3_RESERVED1_SHIFT)
#define  PIPE_ACCESS_STATS_CFG3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PIPE_ACCESS_STATS_CFG3_RESERVED1_MASK) | (((uint32_t)val) << PIPE_ACCESS_STATS_CFG3_RESERVED1_SHIFT))

#define  PIPE_ACCESS_STATS_CFG3_THRESH4_MASK 0x3ff0000
#define  PIPE_ACCESS_STATS_CFG3_THRESH4_SHIFT 16
#define  PIPE_ACCESS_STATS_CFG3_THRESH4_MASK_SHIFT(reg) (((reg) & PIPE_ACCESS_STATS_CFG3_THRESH4_MASK) >> PIPE_ACCESS_STATS_CFG3_THRESH4_SHIFT)
#define  PIPE_ACCESS_STATS_CFG3_THRESH4_REPLACE_VAL(reg,val) (((reg) & ~PIPE_ACCESS_STATS_CFG3_THRESH4_MASK) | (((uint32_t)val) << PIPE_ACCESS_STATS_CFG3_THRESH4_SHIFT))

#define  PIPE_ACCESS_STATS_CFG3_RESERVED2_MASK 0xfc00
#define  PIPE_ACCESS_STATS_CFG3_RESERVED2_SHIFT 10
#define  PIPE_ACCESS_STATS_CFG3_RESERVED2_MASK_SHIFT(reg) (((reg) & PIPE_ACCESS_STATS_CFG3_RESERVED2_MASK) >> PIPE_ACCESS_STATS_CFG3_RESERVED2_SHIFT)
#define  PIPE_ACCESS_STATS_CFG3_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~PIPE_ACCESS_STATS_CFG3_RESERVED2_MASK) | (((uint32_t)val) << PIPE_ACCESS_STATS_CFG3_RESERVED2_SHIFT))

#define  PIPE_ACCESS_STATS_CFG3_THRESH5_MASK 0x3ff
#define  PIPE_ACCESS_STATS_CFG3_THRESH5_SHIFT 0
#define  PIPE_ACCESS_STATS_CFG3_THRESH5_MASK_SHIFT(reg) (((reg) & PIPE_ACCESS_STATS_CFG3_THRESH5_MASK) >> PIPE_ACCESS_STATS_CFG3_THRESH5_SHIFT)
#define  PIPE_ACCESS_STATS_CFG3_THRESH5_REPLACE_VAL(reg,val) (((reg) & ~PIPE_ACCESS_STATS_CFG3_THRESH5_MASK) | (((uint32_t)val) << PIPE_ACCESS_STATS_CFG3_THRESH5_SHIFT))

//====================================================================
//Register: IP Tagging Revision 0 (REV0)
/** \brief Provide means for firmware to read IP tagging information.
      This register of particular interest to firmware.*/
//====================================================================

#define  PIPE_ACCESS_REV0_MAJ_MASK 0xffff0000
#define  PIPE_ACCESS_REV0_MAJ_SHIFT 16
#define  PIPE_ACCESS_REV0_MAJ_MASK_SHIFT(reg) (((reg) & PIPE_ACCESS_REV0_MAJ_MASK) >> PIPE_ACCESS_REV0_MAJ_SHIFT)
#define  PIPE_ACCESS_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~PIPE_ACCESS_REV0_MAJ_MASK) | (((uint32_t)val) << PIPE_ACCESS_REV0_MAJ_SHIFT))

#define  PIPE_ACCESS_REV0_MID_MASK 0xffff
#define  PIPE_ACCESS_REV0_MID_SHIFT 0
#define  PIPE_ACCESS_REV0_MID_MASK_SHIFT(reg) (((reg) & PIPE_ACCESS_REV0_MID_MASK) >> PIPE_ACCESS_REV0_MID_SHIFT)
#define  PIPE_ACCESS_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~PIPE_ACCESS_REV0_MID_MASK) | (((uint32_t)val) << PIPE_ACCESS_REV0_MID_SHIFT))

//====================================================================
//Register: IP Tagging Revision 1 (REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  PIPE_ACCESS_REV1_RESERVED1_MASK 0xffff0000
#define  PIPE_ACCESS_REV1_RESERVED1_SHIFT 16
#define  PIPE_ACCESS_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & PIPE_ACCESS_REV1_RESERVED1_MASK) >> PIPE_ACCESS_REV1_RESERVED1_SHIFT)
#define  PIPE_ACCESS_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PIPE_ACCESS_REV1_RESERVED1_MASK) | (((uint32_t)val) << PIPE_ACCESS_REV1_RESERVED1_SHIFT))

#define  PIPE_ACCESS_REV1_CFG_MASK 0xffff
#define  PIPE_ACCESS_REV1_CFG_SHIFT 0
#define  PIPE_ACCESS_REV1_CFG_MASK_SHIFT(reg) (((reg) & PIPE_ACCESS_REV1_CFG_MASK) >> PIPE_ACCESS_REV1_CFG_SHIFT)
#define  PIPE_ACCESS_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~PIPE_ACCESS_REV1_CFG_MASK) | (((uint32_t)val) << PIPE_ACCESS_REV1_CFG_SHIFT))

//====================================================================
//Register: CPU LUT Data (cpu_lut)
/** \brief CPU access to 1-D LUT space.*/
//====================================================================

#define  PIPE_ACCESS_CPU_LUT_RESERVED1_MASK 0xfffffc00
#define  PIPE_ACCESS_CPU_LUT_RESERVED1_SHIFT 10
#define  PIPE_ACCESS_CPU_LUT_RESERVED1_MASK_SHIFT(reg) (((reg) & PIPE_ACCESS_CPU_LUT_RESERVED1_MASK) >> PIPE_ACCESS_CPU_LUT_RESERVED1_SHIFT)
#define  PIPE_ACCESS_CPU_LUT_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PIPE_ACCESS_CPU_LUT_RESERVED1_MASK) | (((uint32_t)val) << PIPE_ACCESS_CPU_LUT_RESERVED1_SHIFT))

#define  PIPE_ACCESS_CPU_LUT_DATA_MASK 0x3ff
#define  PIPE_ACCESS_CPU_LUT_DATA_SHIFT 0
#define  PIPE_ACCESS_CPU_LUT_DATA_MASK_SHIFT(reg) (((reg) & PIPE_ACCESS_CPU_LUT_DATA_MASK) >> PIPE_ACCESS_CPU_LUT_DATA_SHIFT)
#define  PIPE_ACCESS_CPU_LUT_DATA_REPLACE_VAL(reg,val) (((reg) & ~PIPE_ACCESS_CPU_LUT_DATA_MASK) | (((uint32_t)val) << PIPE_ACCESS_CPU_LUT_DATA_SHIFT))

#endif // PIPE_ACCESS
