 /*
 **************************************************************************************
 *
 * (c) Copyright 2014 Marvell International Ltd.
 *
 *
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/.
 *
 **************************************************************************************
 *
 * \file PIE_regstructs.h
 * Generated using RegBuild 1.6.3
 *
 **************************************************************************************
 */

#ifndef _PIE_PIE_REGSTRUCTS_H_
#define _PIE_PIE_REGSTRUCTS_H_

#include "hwincl.h"

//====================================================================
//
//Register File: PIE (PIE_PIE)
/** \brief Register Descriptions for the PIE superblock*/
//
//====================================================================

//====================================================================
//
//Register File: PIE Common Registers and Interrupts (PIE_Common)
/** \brief Register Descriptions for the PIE Common block
      (rev 0 . 0 . 7 . 0)*/
//
//====================================================================

typedef struct PIE_COMMON_REGS_s
{
  volatile uint32_t IENR;  ///< 0x0 [R/W]: Interrupt Enable Register
  volatile uint32_t IPR;  ///< 0x4 [R]: Interrupt Pending Register
  volatile uint32_t reserved0;
  volatile uint32_t CBIR;  ///< 0xc [R/W]: Common Block Interface Register
  volatile uint32_t CTL;  ///< 0x10 [R/W]: PIE Control Register
  volatile uint32_t DBG;  ///< 0x14 [R]: DEBUG Bus Observation
  volatile uint32_t REV0;  ///< 0x18 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0x1c [R]: IP Tagging Revision 1
} PIE_COMMON_REGS_t;

//====================================================================
//
//Register File: PIE POGO Input DMA (Instance 1 of 3) (POGO_IDMA0)
//
//====================================================================

//====================================================================
//
//Register File: PIE POGO Input DMA (Instance 2 of 3) (POGO_IDMA1)
//
//====================================================================

//====================================================================
//
//Register File: PIE POGO Input DMA (Instance 3 of 3) (POGO_IDMA2)
//
//====================================================================

//====================================================================
//
//Register File: PIE POGOIZER (POGOIZER)
/** \brief (rev 0 . 6 . 3 . 0)
    These registers provide the means to program the characteristics of the desired
    pogoizing operation.*/
//
//====================================================================

typedef struct POGOIZER_REGS_s
{
  volatile uint32_t Cfg;  ///< 0x0 [R/W]: Pogoizer Configuration Register
  volatile uint32_t LPad;  ///< 0x4 [R/W]: Left Side Padding Register
  volatile uint32_t RPad;  ///< 0x8 [R/W]: Right Side Padding Register
  volatile uint32_t reserved0;
  volatile uint32_t LVal0;  ///< 0x10 [R/W]: Left Side Padding Value Register (Instance 1 of 3)
  volatile uint32_t LVal1;  ///< 0x14 [R/W]: Left Side Padding Value Register (Instance 2 of 3)
  volatile uint32_t LVal2;  ///< 0x18 [R/W]: Left Side Padding Value Register (Instance 3 of 3)
  volatile uint32_t reserved1;
  volatile uint32_t RVal0;  ///< 0x20 [R/W]: Right Side Padding Value Register (Instance 1 of 3)
  volatile uint32_t RVal1;  ///< 0x24 [R/W]: Right Side Padding Value Register (Instance 2 of 3)
  volatile uint32_t RVal2;  ///< 0x28 [R/W]: Right Side Padding Value Register (Instance 3 of 3)
  volatile uint32_t reserved2[3];
  volatile uint32_t LTrunc;  ///< 0x38 [R/W]: Left Side Truncation Boundary
  volatile uint32_t RTrunc;  ///< 0x3c [R/W]: Right Side Truncation Boundary
  volatile uint32_t REV0;  ///< 0x40 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0x44 [R]: IP Tagging Revision 1
} POGOIZER_REGS_t;

//====================================================================
//
//Register File: PIE POGO Input OT DMA (OT_POGO_IDMA)
//
//====================================================================

//====================================================================
//
//Register File: PIE OT POGOIZER (OTPOGOIZER)
/** \brief (rev 0 . 6 . 3 . 0)
    These registers provide the means to program the characteristics of the desired
    pogoizing operation.*/
//
//====================================================================

typedef struct OTPOGOIZER_REGS_s
{
  volatile uint32_t Cfg;  ///< 0x0 [R/W]: Pogoizer Configuration Register
  volatile uint32_t LPad;  ///< 0x4 [R/W]: Left Side Padding Register
  volatile uint32_t RPad;  ///< 0x8 [R/W]: Right Side Padding Register
  volatile uint32_t reserved0;
  volatile uint32_t LVal0;  ///< 0x10 [R/W]: Left Side Padding Value Register (Instance 1 of 1)
  volatile uint32_t reserved1[3];
  volatile uint32_t RVal0;  ///< 0x20 [R/W]: Right Side Padding Value Register (Instance 1 of 1)
  volatile uint32_t reserved2[5];
  volatile uint32_t LTrunc;  ///< 0x38 [R/W]: Left Side Truncation Boundary
  volatile uint32_t RTrunc;  ///< 0x3c [R/W]: Right Side Truncation Boundary
  volatile uint32_t REV0;  ///< 0x40 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0x44 [R]: IP Tagging Revision 1
} OTPOGOIZER_REGS_t;

//====================================================================
//
//Register File: PIE CIS Color Shift Correction (ColorShift)
/** \brief Register Descriptions for the CIS Color Shift Block
    (rev 0 . 2 . 1 . 3)*/
//
//====================================================================

typedef struct COLORSHIFT_REGS_s
{
  volatile uint32_t CCSCR;  ///< 0x0 [R/W]: CIS Color Shift Configuration Register
  volatile uint32_t CCSMMR;  ///< 0x4 [R/W]: CIS Color Shift Multiplier Mode Register
  volatile uint32_t CCSMWR;  ///< 0x8 [R/W]: CIS Color Shift Multiplier Weights Register
  volatile uint32_t CCSLSSR;  ///< 0xc [W]: CIS Color Shift LFSR Starting Seed Register
  volatile uint32_t CCSLSR;  ///< 0x10 [R]: CIS Color Shift LFSR Status Register
  volatile uint32_t reserved0[3];
  volatile uint32_t REV0;  ///< 0x20 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0x24 [R]: IP Tagging Revision 1
} COLORSHIFT_REGS_t;

//====================================================================
//
//Register File: PIE RGB2esRGB (LUT1D_RGB2esRGB)
/** \brief (rev 0 . 1 . 6 . 3)
    Register descriptions for the LUT1D block.*/
//
//====================================================================

typedef struct LUT1D_RGB2ESRGB_REGS_s
{
  volatile uint32_t REV0;  ///< 0x0 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0x4 [R]: IP Tagging Revision 1
  volatile uint32_t LUT_CR;  ///< 0x8 [R/W]: LUT1D Configuration Register
  volatile uint32_t reserved0;
  volatile uint32_t EXTRAREG0;  ///< 0x10 [R/W]: LUT1D Look Up Table 0 Extra Register
  volatile uint32_t EXTRAREG1;  ///< 0x14 [R/W]: LUT1D Look Up Table 1 Extra Register
  volatile uint32_t EXTRAREG2;  ///< 0x18 [R/W]: LUT1D Look Up Table 2 Extra Register
  volatile uint32_t reserved1[1017];
  volatile uint32_t LUT0[1024];  ///< 0x1000 [R/W]: LUT1D Look Up Table 0
  volatile uint32_t LUT1[1024];  ///< 0x2000 [R/W]: LUT1D Look Up Table 1
  volatile uint32_t LUT2[1024];  ///< 0x3000 [R/W]: LUT1D Look Up Table 2
} LUT1D_RGB2ESRGB_REGS_t;

//====================================================================
//
//Register File: PIE Subcube Color Space Conversion (ScCSC)
/** \brief Top-level register file for ScCSC*/
//
//====================================================================

typedef struct SCCSC_REGS_s
{
  volatile uint32_t STATUS;  ///< 0x0 [R]: NOT USED
  volatile uint32_t CNTRL;  ///< 0x4 [R/W]: ScCSC CONTROL REG
  volatile uint32_t MCClr;  ///< 0x8 [R]: NOT USED
  volatile uint32_t LCClr;  ///< 0xc [R]: NOT USED
  volatile uint32_t CACHE_INVLD;  ///< 0x10 [R]: NOT USED
  volatile uint32_t CACHE_CNTRL;  ///< 0x14 [R]: NOT USED
  volatile uint32_t IDX_MISS_COUNTER;  ///< 0x18 [R]: NOT USED
  volatile uint32_t PIXEL_MISS_COUNTER;  ///< 0x1c [R]: NOT USED
  volatile uint32_t LATENCY_COUNTER;  ///< 0x20 [R]: NOT USED
  volatile uint32_t BASE_ADDR;  ///< 0x24 [R]: NOT USED
  volatile uint32_t WT;  ///< 0x28 [R/W]: White Threshold settings
  volatile uint32_t WR_REG0;  ///< 0x2c [R/W]: White Response reg 0 
  volatile uint32_t WR_REG1;  ///< 0x30 [R/W]: White Response reg 1 
  volatile uint32_t WR_REG2;  ///< 0x34 [R/W]: White Response reg 2 
  volatile uint32_t KR_REG0;  ///< 0x38 [R/W]: Black Response Reg 0 
  volatile uint32_t KR_REG1;  ///< 0x3c [R/W]: Black Response Reg 1 
  volatile uint32_t KR_REG2;  ///< 0x40 [R/W]: Black Response Reg 2 
  volatile uint32_t RAR;  ///< 0x44 [W]: SRAM Address 
  volatile uint32_t RDW0;  ///< 0x48 [R/W]: RAM Data Write 0
  volatile uint32_t RDW1;  ///< 0x4c [R/W]: RAM Data Write 1
  volatile uint32_t RDW2;  ///< 0x50 [R/W]: RAM Data Write 2
  volatile uint32_t RDR0;  ///< 0x54 [R]: RAM Data Read 0
  volatile uint32_t RDR1;  ///< 0x58 [R]: RAM Data Read 1
  volatile uint32_t RDR2;  ///< 0x5c [R]: RAM Data Read 2
  volatile uint32_t REV;  ///< 0x60 [R]: IIP Tagging Revision
  volatile uint32_t PARAMS;  ///< 0x64 [R]: PARAMETERS
} SCCSC_REGS_t;

//====================================================================
//
//Register File: PIE esRGB2YCrCb (ES2Y)
/** \brief (rev 0 . 4 . 4 . 0)
    Register Descriptions for the 1 CSC block*/
//
//====================================================================

typedef struct ES2Y_REGS_s
{
  volatile uint32_t CCR;  ///< 0x0 [R/W]: CSC Configuration Register
  volatile uint32_t reserved0[3];
  volatile uint32_t REV0;  ///< 0x10 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0x14 [R]: IP Tagging Revision 1
  volatile uint32_t reserved1[58];
  volatile uint32_t MCR0;  ///< 0x100 [R/W]: Multiply Coefficient Register 0 (row 0, col 0)
  volatile uint32_t MCR1;  ///< 0x104 [R/W]: Multiply Coefficient Register 1 (row 0, col 1)
  volatile uint32_t MCR2;  ///< 0x108 [R/W]: Multiply Coefficient Register 2 (row 0, col 2)
  volatile uint32_t MCR3;  ///< 0x10c [R/W]: Multiply Coefficient Register 3 (row 1, col 0)
  volatile uint32_t MCR4;  ///< 0x110 [R/W]: Multiply Coefficient Register 4 (row 1, col 1)
  volatile uint32_t MCR5;  ///< 0x114 [R/W]: Multiply Coefficient Register 5 (row 1, col 2)
  volatile uint32_t MCR6;  ///< 0x118 [R/W]: Multiply Coefficient Register 6 (row 2, col 0)
  volatile uint32_t MCR7;  ///< 0x11c [R/W]: Multiply Coefficient Register 7 (row 2, col 1)
  volatile uint32_t MCR8;  ///< 0x120 [R/W]: Multiply Coefficient Register 8 (row 2, col 2)
} ES2Y_REGS_t;

//====================================================================
//
//Register File: PIE Histogram (CStats)
/** \brief (rev 0 . 3 . 2 . 0)
         CStats (Histogram) register interface.*/
//
//====================================================================

typedef struct CSTATS_REGS_s
{
  volatile uint32_t CFG;  ///< 0x0 [R/W]: Configure CStats Register
  volatile uint32_t LM;  ///< 0x4 [R/W]: Left Margin Register
  volatile uint32_t RM;  ///< 0x8 [R/W]: Right Margin Register
  volatile uint32_t SW;  ///< 0xc [R/W]: Section Width
  volatile uint32_t STW;  ///< 0x10 [R/W]: Strip Width
  volatile uint32_t TR1;  ///< 0x14 [R/W]: Threshold Register 1
  volatile uint32_t TR2;  ///< 0x18 [R/W]: Threshold Register 2
  volatile uint32_t SBLK;  ///< 0x1c [R/W]: Strip Black
  volatile uint32_t SGRY;  ///< 0x20 [R/W]: Strip Grey
  volatile uint32_t SC;  ///< 0x24 [R/W]: Strip Color
  volatile uint32_t CFGBW;  ///< 0x28 [W]: Configure Register B Write
  volatile uint32_t CFGBR;  ///< 0x2c [R]: Configure Register B Read
  volatile uint32_t REV0;  ///< 0x30 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0x34 [R]: IP Tagging Revision 1
  volatile uint32_t reserved0[114];
  volatile uint32_t RAM0[128];  ///< 0x200 [R/W]: Ram 0
  volatile uint32_t RAM1[128];  ///< 0x400 [R/W]: Ram 1
  volatile uint32_t RAM2[128];  ///< 0x600 [R/W]: Ram 2
  volatile uint32_t RAM3[32];  ///< 0x800 [R/W]: Ram 3
} CSTATS_REGS_t;

//====================================================================
//
//Register File: PIE Object Type Merge and Background Replace (OTMARB)
/** \brief (rev 0 . 1 . 0 . 1)
    Registers for the Object Type Merge and Replace Background Color block*/
//
//====================================================================

typedef struct OTMARB_REGS_s
{
  volatile uint32_t Config;  ///< 0x0 [R/W]: Configuration Register
  volatile uint32_t BGColor;  ///< 0x4 [R/W]: Background Color Replacement Value
  volatile uint32_t reserved0[2];
  volatile uint32_t IntEnable;  ///< 0x10 [R/W]: OTMARB Interrupt Enable Register
  volatile uint32_t IntAck;  ///< 0x14 [W]: OTMARB Interrupt Acknowledge Register
  volatile uint32_t IntStat;  ///< 0x18 [R]: OTMARB Interrupt Status Register
  volatile uint32_t IntTest;  ///< 0x1c [W]: OTMARB Interrupt Test Register
  volatile uint32_t REV0;  ///< 0x20 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0x24 [R]: IP Tagging Revision 1
} OTMARB_REGS_t;

//====================================================================
//
//Register File: PIE Neutral Gray Adjust (NGAdjust)
/** \brief Register Descriptions for the 1 NGAdjust block
    (rev 0 . 4 . 0 . 4)*/
//
//====================================================================

typedef struct NGADJUST_REGS_s
{
  volatile uint32_t Config;  ///< 0x0 [R/W]: NGA Configuration Register
  volatile uint32_t REV0;  ///< 0x4 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0x8 [R]: IP Tagging Revision 1
  volatile uint32_t reserved0[1021];
  volatile uint32_t LUTAccess[1024];  ///< 0x1000 [R/W]: Look Up Table Access
} NGADJUST_REGS_t;

//====================================================================
//
//Register File: PIE Is Tone (ISTONE)
/** \brief (rev 0 . 3 . 2 . 0)
    Top-level register file for the IsTone block*/
//
//====================================================================

typedef struct ISTONE_REGS_s
{
  volatile uint32_t IsCtrl;  ///< 0x0 [R/W]: IsTone Control Register
  volatile uint32_t IsLumThresh;  ///< 0x4 [R/W]: Luminance Thresholds Register
  volatile uint32_t IsChromThresh;  ///< 0x8 [R/W]: Chrominance Thresholds Register
  volatile uint32_t IsRotCoeff;  ///< 0xc [R/W]: Rotation Matrix Coefficient Register
  volatile uint32_t IsRotOffst;  ///< 0x10 [R/W]: Rotation Offset Register
  volatile uint32_t IsPxlOffst;  ///< 0x14 [R/W]: Chrominance Pixel Offset Register
  volatile uint32_t IsLumShift;  ///< 0x18 [R/W]: Luminance Shift Register
  volatile uint32_t IsLumComp;  ///< 0x1c [R/W]: Luminance Compensation Register
  volatile uint32_t IsMultDiv;  ///< 0x20 [R/W]: Chrominance Multiply / Divide Register
  volatile uint32_t IsThresh;  ///< 0x24 [R/W]: Test Value Threshold Register
  volatile uint32_t IsDataMask0;  ///< 0x28 [R/W]: IsTone Data Mask 0 Register
  volatile uint32_t IsDataMask1;  ///< 0x2c [R/W]: IsTone Data Mask 1 Register
  volatile uint32_t REV0;  ///< 0x30 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0x34 [R]: IP Tagging Revision 1
} ISTONE_REGS_t;

//====================================================================
//
//Register File: PIE Tone/Contrast & Neutral Sensitivity (TCNSense)
/** \brief Register Descriptions for the PIE TCNSense block
    (rev 0 . 3 . 1 . 3)*/
//
//====================================================================

typedef struct TCNSENSE_REGS_s
{
  volatile uint32_t TCNSCR;  ///< 0x0 [R/W]: TCNS Configuration Register
  volatile uint32_t REV0;  ///< 0x4 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0x8 [R]: IP Tagging Revision 1
  volatile uint32_t reserved0[1021];
  volatile uint32_t TCNSLUT[1024];  ///< 0x1000 [R/W]: Main TCNS Look Up Table
  volatile uint32_t TCNSLUT2[1024];  ///< 0x2000 [R/W]: Alternate TCNS Look Up Table
} TCNSENSE_REGS_t;

//====================================================================
//
//Register File: PIE DENOISE (DENOISE)
/** \brief (rev 0 . 1 . 0 . 1)
    Top-level register file for the DENOISE block*/
//
//====================================================================

typedef struct DENOISE_REGS_s
{
  volatile uint32_t REV0;  ///< 0x0 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0x4 [R]: IP Tagging Revision 1
  volatile uint32_t CFG;  ///< 0x8 [R/W]: Configuration Register
} DENOISE_REGS_t;

//====================================================================
//
//Register File: PIE DeScreen MultiFilter (DSMF)
/** \brief Register Descriptions for the Descreen / MultiFilter block
(rev 0 . 1 . 2 . 2)*/
//
//====================================================================

typedef struct DSMF_REGS_s
{
  volatile uint32_t DSMF_Ctl;  ///< 0x0 [R/W]: DSMF Control Register
  volatile uint32_t DSMF_Seg_HV_Proj;  ///< 0x4 [R/W]: DSMF Segmentation Threshold - Horizontal and Vertical Projection Register
  volatile uint32_t DSMF_Seg_Diag_Proj;  ///< 0x8 [R/W]: DSMF Segmentation Threshold - Diagonal Projection Register
  volatile uint32_t DSMF_Seg_Isolated;  ///< 0xc [R/W]: DSMF Segmentation Threshold - Isolated Detection Register
  volatile uint32_t DSMF_Seg_3x3_Text;  ///< 0x10 [R/W]: DSMF Segmentation Threshold - 3x3 Text Detection Register
  volatile uint32_t DSMF_Seg_3x3_Mixed;  ///< 0x14 [R/W]: DSMF Segmentation Threshold - 3x3 Mixed Detection Register
  volatile uint32_t DSMF_Seg_5x5_Text;  ///< 0x18 [R/W]: DSMF Segmentation Threshold - 5x5 Text Detection Register
  volatile uint32_t DSMF_Seg_5x5_Mixed;  ///< 0x1c [R/W]: DSMF Segmentation Threshold - 5x5 Mixed Detection Register
  volatile uint32_t DSMF_Seg_Line;  ///< 0x20 [R/W]: DSMF Segmentation Threshold - Line Detection Register
  volatile uint32_t DSMF_Seg_Line_Diag;  ///< 0x24 [R/W]: DSMF Segmentation Threshold - Line Diagonal Detection Register
  volatile uint32_t DSMF_SCR1;  ///< 0x28 [R/W]: DSMF Sculptor Configuration 1 Register
  volatile uint32_t DSMF_SCR2;  ///< 0x2c [R/W]: DSMF Sculptor Configuration 2 Register
  volatile uint32_t DSMF_TEL1R;  ///< 0x30 [R/W]: DSMF Text Enhance Limit 1 Register
  volatile uint32_t DSMF_TEL2R;  ///< 0x34 [R/W]: DSMF Text Enhance Limit 2 Register
  volatile uint32_t DSMF_TEL3R;  ///< 0x38 [R/W]: DSMF Text Enhance Limit 3 Register
  volatile uint32_t DSMF_EC_COMPARE;  ///< 0x3c [R/W]: DSMF Edge Count Compare
  volatile uint32_t DSMF_EC_WR;  ///< 0x40 [W]: DSMF Edge Count Write
  volatile uint32_t DSMF_EC_OBS;  ///< 0x44 [R]: DSMF Edge Count Observation
  volatile uint32_t DSMF_ECI;  ///< 0x48 [R/W]: DSMF Edge Count Indices
  volatile uint32_t DSMF_YVC00_01;  ///< 0x4c [R/W]: DSMF Y Variable Coefficient00_01, Filter 0
  volatile uint32_t DSMF_YVC02_03;  ///< 0x50 [R/W]: DSMF Y Variable Coefficient02_03, Filter 0
  volatile uint32_t DSMF_YVC04_10;  ///< 0x54 [R/W]: DSMF Y Variable Coefficient04_10, Filter 0
  volatile uint32_t DSMF_YVC11_12;  ///< 0x58 [R/W]: DSMF Y Variable Coefficient11_12, Filter 0
  volatile uint32_t DSMF_YVC13_14;  ///< 0x5c [R/W]: DSMF Y Variable Coefficient13_14, Filter 0
  volatile uint32_t DSMF_YVC20_21;  ///< 0x60 [R/W]: DSMF Y Variable Coefficient20_21, Filter 0
  volatile uint32_t DSMF_YVC22_23;  ///< 0x64 [R/W]: DSMF Y Variable Coefficient22_23, Filter 0
  volatile uint32_t DSMF_YVC24;  ///< 0x68 [R/W]: DSMF Y Variable Coefficient24, Filter 0
  volatile uint32_t DSMF_YVC30_31;  ///< 0x6c [R/W]: DSMF Y Variable Coefficient30_31, Filter 0
  volatile uint32_t DSMF_YVC32_33;  ///< 0x70 [R/W]: DSMF Y Variable Coefficient32_33, Filter 0
  volatile uint32_t DSMF_YVC34_40;  ///< 0x74 [R/W]: DSMF Y Variable Coefficient34_40, Filter 0
  volatile uint32_t DSMF_YVC41_42;  ///< 0x78 [R/W]: DSMF Y Variable Coefficient41_42, Filter 0
  volatile uint32_t DSMF_YVC43_44;  ///< 0x7c [R/W]: DSMF Y Variable Coefficient43_44, Filter 0
  volatile uint32_t DSMF_CVC00_01;  ///< 0x80 [R/W]: DSMF Chroma Variable Coefficient00_01, Filter 0
  volatile uint32_t DSMF_CVC02_03;  ///< 0x84 [R/W]: DSMF Chroma Variable Coefficient02_03, Filter 0
  volatile uint32_t DSMF_CVC04_10;  ///< 0x88 [R/W]: DSMF Chroma Variable Coefficient04_10, Filter 0
  volatile uint32_t DSMF_CVC11_12;  ///< 0x8c [R/W]: DSMF Chroma Variable Coefficient11_12, Filter 0
  volatile uint32_t DSMF_CVC13_14;  ///< 0x90 [R/W]: DSMF Chroma Variable Coefficient13_14, Filter 0
  volatile uint32_t DSMF_CVC20_21;  ///< 0x94 [R/W]: DSMF Chroma Variable Coefficient20_21, Filter 0
  volatile uint32_t DSMF_CVC22_23;  ///< 0x98 [R/W]: DSMF Chroma Variable Coefficient22_23, Filter 0
  volatile uint32_t DSMF_CVC24;  ///< 0x9c [R/W]: DSMF Chroma Variable Coefficient24, Filter 0
  volatile uint32_t DSMF_CVC30_31;  ///< 0xa0 [R/W]: DSMF Chroma Variable Coefficient30_31, Filter 0
  volatile uint32_t DSMF_CVC32_33;  ///< 0xa4 [R/W]: DSMF Chroma Variable Coefficient32_33, Filter 0
  volatile uint32_t DSMF_CVC34_40;  ///< 0xa8 [R/W]: DSMF Chroma Variable Coefficient34_40, Filter 0
  volatile uint32_t DSMF_CVC41_42;  ///< 0xac [R/W]: DSMF Chroma Variable Coefficient41_42, Filter 0
  volatile uint32_t DSMF_CVC43_44;  ///< 0xb0 [R/W]: DSMF Chroma Variable Coefficient43_44, Filter 0
  volatile uint32_t DSMF_FILT_MULT;  ///< 0xb4 [R/W]: DSMF Filter Sum Multiplier, Filter 0
  volatile uint32_t DSMF_FILT_SHIFT;  ///< 0xb8 [R/W]: DSMF Filter Sum Shift Factor, Filter 0
  volatile uint32_t DSMF_YVC00_01_F1;  ///< 0xbc [R/W]: DSMF Y Variable Coefficient00_01, Filter 1
  volatile uint32_t DSMF_YVC02_03_F1;  ///< 0xc0 [R/W]: DSMF Y Variable Coefficient02_03, Filter 1
  volatile uint32_t DSMF_YVC04_10_F1;  ///< 0xc4 [R/W]: DSMF Y Variable Coefficient04_10, Filter 1
  volatile uint32_t DSMF_YVC11_12_F1;  ///< 0xc8 [R/W]: DSMF Y Variable Coefficient11_12, Filter 1
  volatile uint32_t DSMF_YVC13_14_F1;  ///< 0xcc [R/W]: DSMF Y Variable Coefficient13_14, Filter 1
  volatile uint32_t DSMF_YVC20_21_F1;  ///< 0xd0 [R/W]: DSMF Y Variable Coefficient20_21, Filter 1
  volatile uint32_t DSMF_YVC22_23_F1;  ///< 0xd4 [R/W]: DSMF Y Variable Coefficient22_23, Filter 1
  volatile uint32_t DSMF_YVC24_F1;  ///< 0xd8 [R/W]: DSMF Y Variable Coefficient24, Filter 1
  volatile uint32_t DSMF_YVC30_31_F1;  ///< 0xdc [R/W]: DSMF Y Variable Coefficient30_31, Filter 1
  volatile uint32_t DSMF_YVC32_33_F1;  ///< 0xe0 [R/W]: DSMF Y Variable Coefficient32_33, Filter 1
  volatile uint32_t DSMF_YVC34_40_F1;  ///< 0xe4 [R/W]: DSMF Y Variable Coefficient34_40, Filter 1
  volatile uint32_t DSMF_YVC41_42_F1;  ///< 0xe8 [R/W]: DSMF Y Variable Coefficient41_42, Filter 1
  volatile uint32_t DSMF_YVC43_44_F1;  ///< 0xec [R/W]: DSMF Y Variable Coefficient43_44, Filter 1
  volatile uint32_t DSMF_CVC00_01_F1;  ///< 0xf0 [R/W]: DSMF Chroma Variable Coefficient00_01, Filter 1
  volatile uint32_t DSMF_CVC02_03_F1;  ///< 0xf4 [R/W]: DSMF Chroma Variable Coefficient02_03, Filter 1
  volatile uint32_t DSMF_CVC04_10_F1;  ///< 0xf8 [R/W]: DSMF Chroma Variable Coefficient04_10, Filter 1
  volatile uint32_t DSMF_CVC11_12_F1;  ///< 0xfc [R/W]: DSMF Chroma Variable Coefficient11_12, Filter 1
  volatile uint32_t DSMF_CVC13_14_F1;  ///< 0x100 [R/W]: DSMF Chroma Variable Coefficient13_14, Filter 1
  volatile uint32_t DSMF_CVC20_21_F1;  ///< 0x104 [R/W]: DSMF Chroma Variable Coefficient20_21, Filter 1
  volatile uint32_t DSMF_CVC22_23_F1;  ///< 0x108 [R/W]: DSMF Chroma Variable Coefficient22_23, Filter 1
  volatile uint32_t DSMF_CVC24_F1;  ///< 0x10c [R/W]: DSMF Chroma Variable Coefficient24, Filter 1
  volatile uint32_t DSMF_CVC30_31_F1;  ///< 0x110 [R/W]: DSMF Chroma Variable Coefficient30_31, Filter 1
  volatile uint32_t DSMF_CVC32_33_F1;  ///< 0x114 [R/W]: DSMF Chroma Variable Coefficient32_33, Filter 1
  volatile uint32_t DSMF_CVC34_40_F1;  ///< 0x118 [R/W]: DSMF Chroma Variable Coefficient34_40, Filter 1
  volatile uint32_t DSMF_CVC41_42_F1;  ///< 0x11c [R/W]: DSMF Chroma Variable Coefficient41_42, Filter 1
  volatile uint32_t DSMF_CVC43_44_F1;  ///< 0x120 [R/W]: DSMF Chroma Variable Coefficient43_44, Filter 1
  volatile uint32_t DSMF_FILT_MULT_F1;  ///< 0x124 [R/W]: DSMF Filter Sum Multiplier, Filter 1
  volatile uint32_t DSMF_FILT_SHIFT_F1;  ///< 0x128 [R/W]: DSMF Filter Sum Shift Factor, Filter 1
  volatile uint32_t DSMF_YVC00_01_F2;  ///< 0x12c [R/W]: DSMF Y Variable Coefficient00_01, Filter 2
  volatile uint32_t DSMF_YVC02_03_F2;  ///< 0x130 [R/W]: DSMF Y Variable Coefficient02_03, Filter 2
  volatile uint32_t DSMF_YVC04_10_F2;  ///< 0x134 [R/W]: DSMF Y Variable Coefficient04_10, Filter 2
  volatile uint32_t DSMF_YVC11_12_F2;  ///< 0x138 [R/W]: DSMF Y Variable Coefficient11_12, Filter 2
  volatile uint32_t DSMF_YVC13_14_F2;  ///< 0x13c [R/W]: DSMF Y Variable Coefficient13_14, Filter 2
  volatile uint32_t DSMF_YVC20_21_F2;  ///< 0x140 [R/W]: DSMF Y Variable Coefficient20_21, Filter 2
  volatile uint32_t DSMF_YVC22_23_F2;  ///< 0x144 [R/W]: DSMF Y Variable Coefficient22_23, Filter 2
  volatile uint32_t DSMF_YVC24_F2;  ///< 0x148 [R/W]: DSMF Y Variable Coefficient24, Filter 2
  volatile uint32_t DSMF_YVC30_31_F2;  ///< 0x14c [R/W]: DSMF Y Variable Coefficient30_31, Filter 2
  volatile uint32_t DSMF_YVC32_33_F2;  ///< 0x150 [R/W]: DSMF Y Variable Coefficient32_33, Filter 2
  volatile uint32_t DSMF_YVC34_40_F2;  ///< 0x154 [R/W]: DSMF Y Variable Coefficient34_40, Filter 2
  volatile uint32_t DSMF_YVC41_42_F2;  ///< 0x158 [R/W]: DSMF Y Variable Coefficient41_42, Filter 2
  volatile uint32_t DSMF_YVC43_44_F2;  ///< 0x15c [R/W]: DSMF Y Variable Coefficient43_44, Filter 2
  volatile uint32_t DSMF_CVC00_01_F2;  ///< 0x160 [R/W]: DSMF Chroma Variable Coefficient00_01, Filter 2
  volatile uint32_t DSMF_CVC02_03_F2;  ///< 0x164 [R/W]: DSMF Chroma Variable Coefficient02_03, Filter 2
  volatile uint32_t DSMF_CVC04_10_F2;  ///< 0x168 [R/W]: DSMF Chroma Variable Coefficient04_10, Filter 2
  volatile uint32_t DSMF_CVC11_12_F2;  ///< 0x16c [R/W]: DSMF Chroma Variable Coefficient11_12, Filter 2
  volatile uint32_t DSMF_CVC13_14_F2;  ///< 0x170 [R/W]: DSMF Chroma Variable Coefficient13_14, Filter 2
  volatile uint32_t DSMF_CVC20_21_F2;  ///< 0x174 [R/W]: DSMF Chroma Variable Coefficient20_21, Filter 2
  volatile uint32_t DSMF_CVC22_23_F2;  ///< 0x178 [R/W]: DSMF Chroma Variable Coefficient22_23, Filter 2
  volatile uint32_t DSMF_CVC24_F2;  ///< 0x17c [R/W]: DSMF Chroma Variable Coefficient24, Filter 2
  volatile uint32_t DSMF_CVC30_31_F2;  ///< 0x180 [R/W]: DSMF Chroma Variable Coefficient30_31, Filter 2
  volatile uint32_t DSMF_CVC32_33_F2;  ///< 0x184 [R/W]: DSMF Chroma Variable Coefficient32_33, Filter 2
  volatile uint32_t DSMF_CVC34_40_F2;  ///< 0x188 [R/W]: DSMF Chroma Variable Coefficient34_40, Filter 2
  volatile uint32_t DSMF_CVC41_42_F2;  ///< 0x18c [R/W]: DSMF Chroma Variable Coefficient41_42, Filter 2
  volatile uint32_t DSMF_CVC43_44_F2;  ///< 0x190 [R/W]: DSMF Chroma Variable Coefficient43_44, Filter 2
  volatile uint32_t DSMF_FILT_MULT_F2;  ///< 0x194 [R/W]: DSMF Filter Sum Multiplier, Filter 2
  volatile uint32_t DSMF_FILT_SHIFT_F2;  ///< 0x198 [R/W]: DSMF Filter Sum Shift Factor, Filter 2
  volatile uint32_t DSMF_YVC00_01_F3;  ///< 0x19c [R/W]: DSMF Y Variable Coefficient00_01, Filter 3
  volatile uint32_t DSMF_YVC02_03_F3;  ///< 0x1a0 [R/W]: DSMF Y Variable Coefficient02_03, Filter 3
  volatile uint32_t DSMF_YVC04_10_F3;  ///< 0x1a4 [R/W]: DSMF Y Variable Coefficient04_10, Filter 3
  volatile uint32_t DSMF_YVC11_12_F3;  ///< 0x1a8 [R/W]: DSMF Y Variable Coefficient11_12, Filter 3
  volatile uint32_t DSMF_YVC13_14_F3;  ///< 0x1ac [R/W]: DSMF Y Variable Coefficient13_14, Filter 3
  volatile uint32_t DSMF_YVC20_21_F3;  ///< 0x1b0 [R/W]: DSMF Y Variable Coefficient20_21, Filter 3
  volatile uint32_t DSMF_YVC22_23_F3;  ///< 0x1b4 [R/W]: DSMF Y Variable Coefficient22_23, Filter 3
  volatile uint32_t DSMF_YVC24_F3;  ///< 0x1b8 [R/W]: DSMF Y Variable Coefficient24, Filter 3
  volatile uint32_t DSMF_YVC30_31_F3;  ///< 0x1bc [R/W]: DSMF Y Variable Coefficient30_31, Filter 3
  volatile uint32_t DSMF_YVC32_33_F3;  ///< 0x1c0 [R/W]: DSMF Y Variable Coefficient32_33, Filter 3
  volatile uint32_t DSMF_YVC34_40_F3;  ///< 0x1c4 [R/W]: DSMF Y Variable Coefficient34_40, Filter 3
  volatile uint32_t DSMF_YVC41_42_F3;  ///< 0x1c8 [R/W]: DSMF Y Variable Coefficient41_42, Filter 3
  volatile uint32_t DSMF_YVC43_44_F3;  ///< 0x1cc [R/W]: DSMF Y Variable Coefficient43_44, Filter 3
  volatile uint32_t DSMF_CVC00_01_F3;  ///< 0x1d0 [R/W]: DSMF Chroma Variable Coefficient00_01, Filter 3
  volatile uint32_t DSMF_CVC02_03_F3;  ///< 0x1d4 [R/W]: DSMF Chroma Variable Coefficient02_03, Filter 3
  volatile uint32_t DSMF_CVC04_10_F3;  ///< 0x1d8 [R/W]: DSMF Chroma Variable Coefficient04_10, Filter 3
  volatile uint32_t DSMF_CVC11_12_F3;  ///< 0x1dc [R/W]: DSMF Chroma Variable Coefficient11_12, Filter 3
  volatile uint32_t DSMF_CVC13_14_F3;  ///< 0x1e0 [R/W]: DSMF Chroma Variable Coefficient13_14, Filter 3
  volatile uint32_t DSMF_CVC20_21_F3;  ///< 0x1e4 [R/W]: DSMF Chroma Variable Coefficient20_21, Filter 3
  volatile uint32_t DSMF_CVC22_23_F3;  ///< 0x1e8 [R/W]: DSMF Chroma Variable Coefficient22_23, Filter 3
  volatile uint32_t DSMF_CVC24_F3;  ///< 0x1ec [R/W]: DSMF Chroma Variable Coefficient24, Filter 3
  volatile uint32_t DSMF_CVC30_31_F3;  ///< 0x1f0 [R/W]: DSMF Chroma Variable Coefficient30_31, Filter 3
  volatile uint32_t DSMF_CVC32_33_F3;  ///< 0x1f4 [R/W]: DSMF Chroma Variable Coefficient32_33, Filter 3
  volatile uint32_t DSMF_CVC34_40_F3;  ///< 0x1f8 [R/W]: DSMF Chroma Variable Coefficient34_40, Filter 3
  volatile uint32_t DSMF_CVC41_42_F3;  ///< 0x1fc [R/W]: DSMF Chroma Variable Coefficient41_42, Filter 3
  volatile uint32_t DSMF_CVC43_44_F3;  ///< 0x200 [R/W]: DSMF Chroma Variable Coefficient43_44, Filter 3
  volatile uint32_t DSMF_FILT_MULT_F3;  ///< 0x204 [R/W]: DSMF Filter Sum Multiplier, Filter 3
  volatile uint32_t DSMF_FILT_SHIFT_F3;  ///< 0x208 [R/W]: DSMF Filter Sum Shift Factor, Filter 3
  volatile uint32_t DSMF_AVG_MASK;  ///< 0x20c [R/W]: DSMF Average Mask Mode
  volatile uint32_t DSMF_FILT_CTL_LUT[16];  ///< 0x210 [R/W]: DSMF Filter Control LUT
  volatile uint32_t reserved0[108];
  volatile uint32_t DSMF_SEG_PROJ_LUT[256];  ///< 0x400 [R/W]: DSMF Segmentation / Projection LUT
  volatile uint32_t reserved1[256];
  volatile uint32_t DSMF_AI_LUT0[64];  ///< 0xc00 [R/W]: DSMF Activity Index LUT 0
  volatile uint32_t reserved2[192];
  volatile uint32_t DSMF_AI_LUT1[64];  ///< 0x1000 [R/W]: DSMF Activity Index LUT 1
  volatile uint32_t REV0;  ///< 0x1100 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0x1104 [R]: IP Tagging Revision 1
} DSMF_REGS_t;

//====================================================================
//
//Register File: PIE Decimator (DECIM)
/** \brief Top-level register file for the Decimate block <br/> (rev 0 . 1 . 1 . 2)*/
//
//====================================================================

typedef struct DECIM_REGS_s
{
  volatile uint32_t div;  ///< 0x0 [R/W]: Divisor Register
  volatile uint32_t start;  ///< 0x4 [R/W]: Vertical Start Register
  volatile uint32_t REV0;  ///< 0x8 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0xc [R]: IP Tagging Revision 1
} DECIM_REGS_t;

//====================================================================
//
//Register File: PIE YCrCb2esRGB (Y2ES)
/** \brief (rev 0 . 4 . 4 . 0)
    Register Descriptions for the 1 CSC block*/
//
//====================================================================

typedef struct Y2ES_REGS_s
{
  volatile uint32_t CCR;  ///< 0x0 [R/W]: CSC Configuration Register
  volatile uint32_t reserved0[3];
  volatile uint32_t REV0;  ///< 0x10 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0x14 [R]: IP Tagging Revision 1
  volatile uint32_t reserved1[58];
  volatile uint32_t MCR0;  ///< 0x100 [R/W]: Multiply Coefficient Register 0 (row 0, col 0)
  volatile uint32_t MCR1;  ///< 0x104 [R/W]: Multiply Coefficient Register 1 (row 0, col 1)
  volatile uint32_t MCR2;  ///< 0x108 [R/W]: Multiply Coefficient Register 2 (row 0, col 2)
  volatile uint32_t MCR3;  ///< 0x10c [R/W]: Multiply Coefficient Register 3 (row 1, col 0)
  volatile uint32_t MCR4;  ///< 0x110 [R/W]: Multiply Coefficient Register 4 (row 1, col 1)
  volatile uint32_t MCR5;  ///< 0x114 [R/W]: Multiply Coefficient Register 5 (row 1, col 2)
  volatile uint32_t MCR6;  ///< 0x118 [R/W]: Multiply Coefficient Register 6 (row 2, col 0)
  volatile uint32_t MCR7;  ///< 0x11c [R/W]: Multiply Coefficient Register 7 (row 2, col 1)
  volatile uint32_t MCR8;  ///< 0x120 [R/W]: Multiply Coefficient Register 8 (row 2, col 2)
} Y2ES_REGS_t;

//====================================================================
//
//Register File: PIE XYScale (XYScale)
/** \brief Register Descriptions for the PIE XYScale block
    (rev 0 . 3 . 4 . 2)*/
//
//====================================================================

typedef struct XYSCALE_REGS_s
{
  volatile uint32_t CSR;  ///< 0x0 [R/W]: Configure X-Y Scale Register
  volatile uint32_t reserved0;
  volatile uint32_t CCR;  ///< 0x8 [R/W]: Output Strip Column Count Register
  volatile uint32_t CFR1;  ///< 0xc [R/W]: Color 2 and Color 1 Fill Data Register
  volatile uint32_t CFR2;  ///< 0x10 [R/W]: Color 0 Fill Data Register
  volatile uint32_t HSR;  ///< 0x14 [R/W]: Horizontal Scale Register
  volatile uint32_t VSR;  ///< 0x18 [R/W]: Vertical Scale Register
  volatile uint32_t HSMR;  ///< 0x1c [R/W]: Horizontal Scale Minus Normal Register
  volatile uint32_t VSMR;  ///< 0x20 [R/W]: Vertical Scale Minus Normal Register
  volatile uint32_t XTR;  ///< 0x24 [W]: X-Transpose Configuration Register
  volatile uint32_t YTR;  ///< 0x28 [W]: Y-Transpose Configuration Register
  volatile uint32_t CXR;  ///< 0x2c [R]: Current X-Start Register
  volatile uint32_t CYR;  ///< 0x30 [R]: Current Y Transpose Register
  volatile uint32_t VSPR;  ///< 0x34 [W]: Vertical Start Percentage
  volatile uint32_t HCPR;  ///< 0x38 [R]: Horizontal Current/End Percentage Register
  volatile uint32_t VCPR;  ///< 0x3c [R]: Vertical Current/End Percentage Register
  volatile uint32_t XOR;  ///< 0x40 [R]: Observation Register
  volatile uint32_t REV0;  ///< 0x44 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0x48 [R]: IP Tagging Revision 1
} XYSCALE_REGS_t;

//====================================================================
//
//Register File: PIE Clip and Pad (CLIPPAD)
/** \brief Top-level register file for the Clip Pad block*/
//
//====================================================================

typedef struct CLIPPAD_REGS_s
{
  volatile uint32_t Cfg;  ///< 0x0 [R/W]: CLIPPAD Configuration Register
  volatile uint32_t LPad;  ///< 0x4 [R/W]: Left Side Padding Register
  volatile uint32_t RPad;  ///< 0x8 [R/W]: Right Side Padding Register
  volatile uint32_t reserved0;
  volatile uint32_t LVal0;  ///< 0x10 [R/W]: Left Side Padding Value Register (Instance 1 of 4)
  volatile uint32_t LVal1;  ///< 0x14 [R/W]: Left Side Padding Value Register (Instance 2 of 4)
  volatile uint32_t LVal2;  ///< 0x18 [R/W]: Left Side Padding Value Register (Instance 3 of 4)
  volatile uint32_t LVal3;  ///< 0x1c [R/W]: Left Side Padding Value Register (Instance 4 of 4)
  volatile uint32_t reserved1[4];
  volatile uint32_t RVal0;  ///< 0x30 [R/W]: Right Side Padding Value Register (Instance 1 of 4)
  volatile uint32_t RVal1;  ///< 0x34 [R/W]: Right Side Padding Value Register (Instance 2 of 4)
  volatile uint32_t RVal2;  ///< 0x38 [R/W]: Right Side Padding Value Register (Instance 3 of 4)
  volatile uint32_t RVal3;  ///< 0x3c [R/W]: Right Side Padding Value Register (Instance 4 of 4)
  volatile uint32_t reserved2[4];
  volatile uint32_t LTrunc;  ///< 0x50 [R/W]: Left Side Truncation Boundary
  volatile uint32_t RTrunc;  ///< 0x54 [R/W]: Right Side Truncation Boundary
  volatile uint32_t LineWidth;  ///< 0x58 [R/W]: Line Width Register
  volatile uint32_t CLIPPADPR;  ///< 0x5c [R]: CLIPPAD Parameter Register
  volatile uint32_t REV0;  ///< 0x60 [R]: CLIPPAD Tagging Revision 0
  volatile uint32_t REV1;  ///< 0x64 [R]: CLIPPAD Tagging Revision 1
} CLIPPAD_REGS_t;

//====================================================================
//
//Register File: PIE Depogoizer (DEPOGOIZER)
/** \brief (rev 0 . 6 . 5 . 0)
    The DEPOGO registers provide the means to program the characteristics of the desired
    depogoizing operation.*/
//
//====================================================================

typedef struct DEPOGOIZER_REGS_s
{
  volatile uint32_t Cfg;  ///< 0x0 [R/W]: Depogoizer Configuration Register
  volatile uint32_t reserved0;
  volatile uint32_t REV0;  ///< 0x8 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0xc [R]: IP Tagging Revision 1
} DEPOGOIZER_REGS_t;

//====================================================================
//
//Register File: PIE Write DMA (POGO_ODMA)
//
//====================================================================

//====================================================================
//
//Register File: PIE OT Depogoizer (OTDEPOGOIZER)
/** \brief (rev 0 . 6 . 5 . 0)
    The DEPOGO registers provide the means to program the characteristics of the desired
    depogoizing operation.*/
//
//====================================================================

typedef struct OTDEPOGOIZER_REGS_s
{
  volatile uint32_t Cfg;  ///< 0x0 [R/W]: Depogoizer Configuration Register
  volatile uint32_t reserved0;
  volatile uint32_t REV0;  ///< 0x8 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0xc [R]: IP Tagging Revision 1
} OTDEPOGOIZER_REGS_t;

//====================================================================
//
//Register File: PIE Write OT DMA (POGO_OTODMA)
//
//====================================================================

//====================================================================
//
//Register File: PIE DISTORT_TOP (DISTORT_TOP)
/** \brief Register Descriptions for the DISTORT_TOP Testbench*/
//
//====================================================================

//====================================================================
//
//Register File: PIE XYCScale (XYCScale)
/** \brief (rev 0 . 3 . 0 . 0)*/
//
//====================================================================

typedef struct XYCSCALE_REGS_s
{
  volatile uint32_t CSR;  ///< 0x0 [R/W]: Configure X-Y Scale Register
  volatile uint32_t CLCR;  ///< 0x4 [R]: Input Strip Column and Line Count Register 
  volatile uint32_t CCR;  ///< 0x8 [R/W]: Output Strip Column Count Register
  volatile uint32_t CFR1;  ///< 0xc [R/W]: Color 2 and Color 1 Fill Data Register
  volatile uint32_t CFR2;  ///< 0x10 [R/W]: Color 0 Fill Data Register
  volatile uint32_t HSR;  ///< 0x14 [R/W]: Horizontal Scale Register
  volatile uint32_t VSR;  ///< 0x18 [R/W]: Vertical Scale Register
  volatile uint32_t reserved0[2];
  volatile uint32_t XTR;  ///< 0x24 [W]: X-Transpose Configuration Register
  volatile uint32_t YTR;  ///< 0x28 [W]: Y-Transpose Configuration Register
  volatile uint32_t CXR;  ///< 0x2c [R]: Current X-Start Register
  volatile uint32_t CYR;  ///< 0x30 [R]: Current Y-Start Register
  volatile uint32_t reserved1[3];
  volatile uint32_t XOR;  ///< 0x40 [R]: Observation Register
  volatile uint32_t SR;  ///< 0x44 [R/W]: Status Register
  volatile uint32_t REV0;  ///< 0x48 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0x4c [R]: IP Tagging Revision 1
} XYCSCALE_REGS_t;

//====================================================================
//
//Register File: PIE IHI (IHI)
/** \brief Top-level register file for the IHI block
(rev 0 . 0 . 7 . 4)*/
//
//====================================================================

typedef struct IHI_REGS_s
{
  volatile uint32_t Control;  ///< 0x0 [R/W]: IHI Control Register
  volatile uint32_t ImgSize;  ///< 0x4 [R/W]: IHI Image Size Register
  volatile uint32_t ED_Bndry;  ///< 0x8 [R/W]: IHI Edge Detect Boundaries Register
  volatile uint32_t ED_Bndry2;  ///< 0xc [R/W]: IHI Edge Detect Boundaries 2 Register
  volatile uint32_t Cluster_Control;  ///< 0x10 [R/W]: IHI Cluster Control Register
  volatile uint32_t BG_Tonal;  ///< 0x14 [R/W]: IHI Background Tonal Correct
  volatile uint32_t FG_Tonal;  ///< 0x18 [R/W]: IHI Foreground Tonal Correct
  volatile uint32_t DB_CTL;  ///< 0x1c [R/W]: IHI DB Debug Control
  volatile uint32_t REV0;  ///< 0x20 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0x24 [R]: IP Tagging Revision 1
} IHI_REGS_t;

//====================================================================
//
//Register File: PIE IHI Depogoizer (IHIDEPOGOIZER)
/** \brief (rev 0 . 6 . 5 . 0)
    The DEPOGO registers provide the means to program the characteristics of the desired
    depogoizing operation.*/
//
//====================================================================

typedef struct IHIDEPOGOIZER_REGS_s
{
  volatile uint32_t Cfg;  ///< 0x0 [R/W]: Depogoizer Configuration Register
  volatile uint32_t reserved0;
  volatile uint32_t REV0;  ///< 0x8 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0xc [R]: IP Tagging Revision 1
} IHIDEPOGOIZER_REGS_t;

//====================================================================
//
//Register File: PIE Write IHI DMA (POGO_IHI_ODMA)
//
//====================================================================

//====================================================================
//
//Register File: POGO_IDMA_UDMA (POGO_IDMA0_POGO_IDMA_UDMA)
//
//====================================================================

typedef struct POGO_IDMA0_POGO_IDMA_UDMA_REGS_s
{
  volatile uint32_t UCR;  ///< 0x0 [R/W]: UDMA Configuration Register
  volatile uint32_t USR;  ///< 0x4 [R]: UDMA Status Register
  volatile uint32_t UPR;  ///< 0x8 [R]: UDMA Parameter Register
  volatile uint32_t UIER;  ///< 0xc [R/W]: UDMA Interrupt Enable Register
  volatile uint32_t UIPR;  ///< 0x10 [R]: UDMA Interrupt Pending Register
  volatile uint32_t UICR;  ///< 0x14 [W]: UDMA Interrupt Clear Register
  volatile uint32_t UIFR;  ///< 0x18 [W]: UDMA Interrupt Force Register
  volatile uint32_t UDR;  ///< 0x1c [R/W]: UDMA Descriptor Register
  volatile uint32_t UBAR;  ///< 0x20 [R]: UDMA Burst Address Register
  volatile uint32_t UBLR;  ///< 0x24 [R]: UDMA Burst Length Register
  volatile uint32_t UBRR;  ///< 0x28 [R]: UDMA Transfer Bytes Remaining Register
  volatile uint32_t reserved0;
  volatile uint32_t UTR0;  ///< 0x30 [R]: UDMA Tag Register 0
  volatile uint32_t UTR1;  ///< 0x34 [R]: UDMA Tag Register 1
} POGO_IDMA0_POGO_IDMA_UDMA_REGS_t;

//====================================================================
//
//Register File: POGO_IDMA_CORE (POGO_IDMA0_POGO_IDMA_CORE)
//
//====================================================================

typedef struct POGO_IDMA0_POGO_IDMA_CORE_REGS_s
{
  volatile uint32_t ICR;  ///< 0x0 [R/W]: IDMA Configuration Register
  volatile uint32_t IIER;  ///< 0x4 [R/W]: IDMA Interrupt Enable Register
  volatile uint32_t IIPR;  ///< 0x8 [R]: IDMA Interrupt Pending Register
  volatile uint32_t IICR;  ///< 0xc [W]: IDMA Interrupt Clear Register
  volatile uint32_t IIFR;  ///< 0x10 [W]: IDMA Interrupt Force Register
  volatile uint32_t ILWR;  ///< 0x14 [R/W]: IDMA Line Width Register
  volatile uint32_t IRHR;  ///< 0x18 [R/W]: IDMA Row Height Register
  volatile uint32_t ITR0;  ///< 0x1c [R]: IDMA Tag Register 0
  volatile uint32_t ITR1;  ///< 0x20 [R]: IDMA Tag Register 1
  volatile uint32_t ITR2;  ///< 0x24 [R]: IDMA Tag Register 2
} POGO_IDMA0_POGO_IDMA_CORE_REGS_t;

//====================================================================
//
//Register File: POGO_IDMA_UDMA (POGO_IDMA1_POGO_IDMA_UDMA)
//
//====================================================================

typedef struct POGO_IDMA1_POGO_IDMA_UDMA_REGS_s
{
  volatile uint32_t UCR;  ///< 0x0 [R/W]: UDMA Configuration Register
  volatile uint32_t USR;  ///< 0x4 [R]: UDMA Status Register
  volatile uint32_t UPR;  ///< 0x8 [R]: UDMA Parameter Register
  volatile uint32_t UIER;  ///< 0xc [R/W]: UDMA Interrupt Enable Register
  volatile uint32_t UIPR;  ///< 0x10 [R]: UDMA Interrupt Pending Register
  volatile uint32_t UICR;  ///< 0x14 [W]: UDMA Interrupt Clear Register
  volatile uint32_t UIFR;  ///< 0x18 [W]: UDMA Interrupt Force Register
  volatile uint32_t UDR;  ///< 0x1c [R/W]: UDMA Descriptor Register
  volatile uint32_t UBAR;  ///< 0x20 [R]: UDMA Burst Address Register
  volatile uint32_t UBLR;  ///< 0x24 [R]: UDMA Burst Length Register
  volatile uint32_t UBRR;  ///< 0x28 [R]: UDMA Transfer Bytes Remaining Register
  volatile uint32_t reserved0;
  volatile uint32_t UTR0;  ///< 0x30 [R]: UDMA Tag Register 0
  volatile uint32_t UTR1;  ///< 0x34 [R]: UDMA Tag Register 1
} POGO_IDMA1_POGO_IDMA_UDMA_REGS_t;

//====================================================================
//
//Register File: POGO_IDMA_CORE (POGO_IDMA1_POGO_IDMA_CORE)
//
//====================================================================

typedef struct POGO_IDMA1_POGO_IDMA_CORE_REGS_s
{
  volatile uint32_t ICR;  ///< 0x0 [R/W]: IDMA Configuration Register
  volatile uint32_t IIER;  ///< 0x4 [R/W]: IDMA Interrupt Enable Register
  volatile uint32_t IIPR;  ///< 0x8 [R]: IDMA Interrupt Pending Register
  volatile uint32_t IICR;  ///< 0xc [W]: IDMA Interrupt Clear Register
  volatile uint32_t IIFR;  ///< 0x10 [W]: IDMA Interrupt Force Register
  volatile uint32_t ILWR;  ///< 0x14 [R/W]: IDMA Line Width Register
  volatile uint32_t IRHR;  ///< 0x18 [R/W]: IDMA Row Height Register
  volatile uint32_t ITR0;  ///< 0x1c [R]: IDMA Tag Register 0
  volatile uint32_t ITR1;  ///< 0x20 [R]: IDMA Tag Register 1
  volatile uint32_t ITR2;  ///< 0x24 [R]: IDMA Tag Register 2
} POGO_IDMA1_POGO_IDMA_CORE_REGS_t;

//====================================================================
//
//Register File: POGO_IDMA_UDMA (POGO_IDMA2_POGO_IDMA_UDMA)
//
//====================================================================

typedef struct POGO_IDMA2_POGO_IDMA_UDMA_REGS_s
{
  volatile uint32_t UCR;  ///< 0x0 [R/W]: UDMA Configuration Register
  volatile uint32_t USR;  ///< 0x4 [R]: UDMA Status Register
  volatile uint32_t UPR;  ///< 0x8 [R]: UDMA Parameter Register
  volatile uint32_t UIER;  ///< 0xc [R/W]: UDMA Interrupt Enable Register
  volatile uint32_t UIPR;  ///< 0x10 [R]: UDMA Interrupt Pending Register
  volatile uint32_t UICR;  ///< 0x14 [W]: UDMA Interrupt Clear Register
  volatile uint32_t UIFR;  ///< 0x18 [W]: UDMA Interrupt Force Register
  volatile uint32_t UDR;  ///< 0x1c [R/W]: UDMA Descriptor Register
  volatile uint32_t UBAR;  ///< 0x20 [R]: UDMA Burst Address Register
  volatile uint32_t UBLR;  ///< 0x24 [R]: UDMA Burst Length Register
  volatile uint32_t UBRR;  ///< 0x28 [R]: UDMA Transfer Bytes Remaining Register
  volatile uint32_t reserved0;
  volatile uint32_t UTR0;  ///< 0x30 [R]: UDMA Tag Register 0
  volatile uint32_t UTR1;  ///< 0x34 [R]: UDMA Tag Register 1
} POGO_IDMA2_POGO_IDMA_UDMA_REGS_t;

//====================================================================
//
//Register File: POGO_IDMA_CORE (POGO_IDMA2_POGO_IDMA_CORE)
//
//====================================================================

typedef struct POGO_IDMA2_POGO_IDMA_CORE_REGS_s
{
  volatile uint32_t ICR;  ///< 0x0 [R/W]: IDMA Configuration Register
  volatile uint32_t IIER;  ///< 0x4 [R/W]: IDMA Interrupt Enable Register
  volatile uint32_t IIPR;  ///< 0x8 [R]: IDMA Interrupt Pending Register
  volatile uint32_t IICR;  ///< 0xc [W]: IDMA Interrupt Clear Register
  volatile uint32_t IIFR;  ///< 0x10 [W]: IDMA Interrupt Force Register
  volatile uint32_t ILWR;  ///< 0x14 [R/W]: IDMA Line Width Register
  volatile uint32_t IRHR;  ///< 0x18 [R/W]: IDMA Row Height Register
  volatile uint32_t ITR0;  ///< 0x1c [R]: IDMA Tag Register 0
  volatile uint32_t ITR1;  ///< 0x20 [R]: IDMA Tag Register 1
  volatile uint32_t ITR2;  ///< 0x24 [R]: IDMA Tag Register 2
} POGO_IDMA2_POGO_IDMA_CORE_REGS_t;

//====================================================================
//
//Register File: POGO_IDMA_UDMA (OT_POGO_IDMA_POGO_IDMA_UDMA)
//
//====================================================================

typedef struct OT_POGO_IDMA_POGO_IDMA_UDMA_REGS_s
{
  volatile uint32_t UCR;  ///< 0x0 [R/W]: UDMA Configuration Register
  volatile uint32_t USR;  ///< 0x4 [R]: UDMA Status Register
  volatile uint32_t UPR;  ///< 0x8 [R]: UDMA Parameter Register
  volatile uint32_t UIER;  ///< 0xc [R/W]: UDMA Interrupt Enable Register
  volatile uint32_t UIPR;  ///< 0x10 [R]: UDMA Interrupt Pending Register
  volatile uint32_t UICR;  ///< 0x14 [W]: UDMA Interrupt Clear Register
  volatile uint32_t UIFR;  ///< 0x18 [W]: UDMA Interrupt Force Register
  volatile uint32_t UDR;  ///< 0x1c [R/W]: UDMA Descriptor Register
  volatile uint32_t UBAR;  ///< 0x20 [R]: UDMA Burst Address Register
  volatile uint32_t UBLR;  ///< 0x24 [R]: UDMA Burst Length Register
  volatile uint32_t UBRR;  ///< 0x28 [R]: UDMA Transfer Bytes Remaining Register
  volatile uint32_t reserved0;
  volatile uint32_t UTR0;  ///< 0x30 [R]: UDMA Tag Register 0
  volatile uint32_t UTR1;  ///< 0x34 [R]: UDMA Tag Register 1
} OT_POGO_IDMA_POGO_IDMA_UDMA_REGS_t;

//====================================================================
//
//Register File: POGO_IDMA_CORE (OT_POGO_IDMA_POGO_IDMA_CORE)
//
//====================================================================

typedef struct OT_POGO_IDMA_POGO_IDMA_CORE_REGS_s
{
  volatile uint32_t ICR;  ///< 0x0 [R/W]: IDMA Configuration Register
  volatile uint32_t IIER;  ///< 0x4 [R/W]: IDMA Interrupt Enable Register
  volatile uint32_t IIPR;  ///< 0x8 [R]: IDMA Interrupt Pending Register
  volatile uint32_t IICR;  ///< 0xc [W]: IDMA Interrupt Clear Register
  volatile uint32_t IIFR;  ///< 0x10 [W]: IDMA Interrupt Force Register
  volatile uint32_t ILWR;  ///< 0x14 [R/W]: IDMA Line Width Register
  volatile uint32_t IRHR;  ///< 0x18 [R/W]: IDMA Row Height Register
  volatile uint32_t ITR0;  ///< 0x1c [R]: IDMA Tag Register 0
  volatile uint32_t ITR1;  ///< 0x20 [R]: IDMA Tag Register 1
  volatile uint32_t ITR2;  ///< 0x24 [R]: IDMA Tag Register 2
} OT_POGO_IDMA_POGO_IDMA_CORE_REGS_t;

//====================================================================
//
//Register File: POGO_ODMA_UDMA (POGO_ODMA_POGO_ODMA_UDMA)
//
//====================================================================

typedef struct POGO_ODMA_POGO_ODMA_UDMA_REGS_s
{
  volatile uint32_t UCR;  ///< 0x0 [R/W]: UDMA Configuration Register
  volatile uint32_t USR;  ///< 0x4 [R]: UDMA Status Register
  volatile uint32_t UPR;  ///< 0x8 [R]: UDMA Parameter Register
  volatile uint32_t UIER;  ///< 0xc [R/W]: UDMA Interrupt Enable Register
  volatile uint32_t UIPR;  ///< 0x10 [R]: UDMA Interrupt Pending Register
  volatile uint32_t UICR;  ///< 0x14 [W]: UDMA Interrupt Clear Register
  volatile uint32_t UIFR;  ///< 0x18 [W]: UDMA Interrupt Force Register
  volatile uint32_t UDR;  ///< 0x1c [R/W]: UDMA Descriptor Register
  volatile uint32_t UBAR;  ///< 0x20 [R]: UDMA Burst Address Register
  volatile uint32_t UBLR;  ///< 0x24 [R]: UDMA Burst Length Register
  volatile uint32_t UBRR;  ///< 0x28 [R]: UDMA Transfer Bytes Remaining Register
  volatile uint32_t reserved0;
  volatile uint32_t UTR0;  ///< 0x30 [R]: UDMA Tag Register 0
  volatile uint32_t UTR1;  ///< 0x34 [R]: UDMA Tag Register 1
} POGO_ODMA_POGO_ODMA_UDMA_REGS_t;

//====================================================================
//
//Register File: POGO_ODMA_CORE (POGO_ODMA_POGO_ODMA_CORE)
//
//====================================================================

typedef struct POGO_ODMA_POGO_ODMA_CORE_REGS_s
{
  volatile uint32_t reserved0;
  volatile uint32_t OIER;  ///< 0x4 [R/W]: ODMA Interrupt Enable Register
  volatile uint32_t OIPR;  ///< 0x8 [R]: ODMA Interrupt Pending Register
  volatile uint32_t OICR;  ///< 0xc [W]: ODMA Interrupt Clear Register
  volatile uint32_t OIFR;  ///< 0x10 [W]: ODMA Interrupt Force Register
  volatile uint32_t OLWR;  ///< 0x14 [R/W]: ODMA Line Width Register
  volatile uint32_t OCNTRL;  ///< 0x18 [R/W]: ODMA Control Register
  volatile uint32_t OTR0;  ///< 0x1c [R]: ODMA Tag Register 0
  volatile uint32_t OTR1;  ///< 0x20 [R]: ODMA Tag Register 1
  volatile uint32_t OTR2;  ///< 0x24 [R]: ODMA Tag Register 2
} POGO_ODMA_POGO_ODMA_CORE_REGS_t;

//====================================================================
//
//Register File: POGO_ODMA_UDMA (POGO_OTODMA_POGO_ODMA_UDMA)
//
//====================================================================

typedef struct POGO_OTODMA_POGO_ODMA_UDMA_REGS_s
{
  volatile uint32_t UCR;  ///< 0x0 [R/W]: UDMA Configuration Register
  volatile uint32_t USR;  ///< 0x4 [R]: UDMA Status Register
  volatile uint32_t UPR;  ///< 0x8 [R]: UDMA Parameter Register
  volatile uint32_t UIER;  ///< 0xc [R/W]: UDMA Interrupt Enable Register
  volatile uint32_t UIPR;  ///< 0x10 [R]: UDMA Interrupt Pending Register
  volatile uint32_t UICR;  ///< 0x14 [W]: UDMA Interrupt Clear Register
  volatile uint32_t UIFR;  ///< 0x18 [W]: UDMA Interrupt Force Register
  volatile uint32_t UDR;  ///< 0x1c [R/W]: UDMA Descriptor Register
  volatile uint32_t UBAR;  ///< 0x20 [R]: UDMA Burst Address Register
  volatile uint32_t UBLR;  ///< 0x24 [R]: UDMA Burst Length Register
  volatile uint32_t UBRR;  ///< 0x28 [R]: UDMA Transfer Bytes Remaining Register
  volatile uint32_t reserved0;
  volatile uint32_t UTR0;  ///< 0x30 [R]: UDMA Tag Register 0
  volatile uint32_t UTR1;  ///< 0x34 [R]: UDMA Tag Register 1
} POGO_OTODMA_POGO_ODMA_UDMA_REGS_t;

//====================================================================
//
//Register File: POGO_ODMA_CORE (POGO_OTODMA_POGO_ODMA_CORE)
//
//====================================================================

typedef struct POGO_OTODMA_POGO_ODMA_CORE_REGS_s
{
  volatile uint32_t reserved0;
  volatile uint32_t OIER;  ///< 0x4 [R/W]: ODMA Interrupt Enable Register
  volatile uint32_t OIPR;  ///< 0x8 [R]: ODMA Interrupt Pending Register
  volatile uint32_t OICR;  ///< 0xc [W]: ODMA Interrupt Clear Register
  volatile uint32_t OIFR;  ///< 0x10 [W]: ODMA Interrupt Force Register
  volatile uint32_t OLWR;  ///< 0x14 [R/W]: ODMA Line Width Register
  volatile uint32_t OCNTRL;  ///< 0x18 [R/W]: ODMA Control Register
  volatile uint32_t OTR0;  ///< 0x1c [R]: ODMA Tag Register 0
  volatile uint32_t OTR1;  ///< 0x20 [R]: ODMA Tag Register 1
  volatile uint32_t OTR2;  ///< 0x24 [R]: ODMA Tag Register 2
} POGO_OTODMA_POGO_ODMA_CORE_REGS_t;

//====================================================================
//
//Register File: PIE LUT1D_BDE, ANTIFCOR, DISTORT_DMA (DISTORT_TOP_ANTIFCOR_TOP)
/** \brief Register Descriptions for the ANTIFCOR Top Testbench*/
//
//====================================================================

//====================================================================
//
//Register File: PIE Distort (DISTORT_TOP_DISTORT)
/** \brief Register file for the DISTORT block
  (rev 0 . 6 . 1 . 0)*/
//
//====================================================================

typedef struct DISTORT_TOP_DISTORT_REGS_s
{
  volatile uint32_t Cfg;  ///< 0x0 [R/W]: Configuration Register
  volatile uint32_t OutputStripConfig;  ///< 0x4 [W]: Output Strip Configuration
  volatile uint32_t OutputStripStatus;  ///< 0x8 [R]: Output Strip Status
  volatile uint32_t QueueHsStatus;  ///< 0xc [R]: Output Strip Queue and CDMA Handshake Status
  volatile uint32_t IntEnable;  ///< 0x10 [R/W]: Interrupt Enable Register
  volatile uint32_t IntPending;  ///< 0x14 [R]: Interrupt Pending Register
  volatile uint32_t IntClear;  ///< 0x18 [W]: Interrupt Clear Register
  volatile uint32_t IntForce;  ///< 0x1c [W]: Interrupt Force Register
  volatile uint32_t Ch1_ImageDimension;  ///< 0x20 [R/W]: CH1 Input Image Size
  volatile uint32_t Ch2_ImageDimension;  ///< 0x24 [R/W]: CH2 Input Image Size
  volatile uint32_t Ch3_ImageDimension;  ///< 0x28 [R/W]: CH3 Input Image Size
  volatile uint32_t reserved0;
  volatile uint32_t Ch1_DataStartPos_X;  ///< 0x30 [R/W]: CH1 Horizontal Data Start Position
  volatile uint32_t Ch2_DataStartPos_X;  ///< 0x34 [R/W]: CH2 Horizontal Data Start Position
  volatile uint32_t Ch3_DataStartPos_X;  ///< 0x38 [R/W]: CH3 Horizontal Data Start Position
  volatile uint32_t reserved1;
  volatile uint32_t Ch1_DataStartPos_Y;  ///< 0x40 [R/W]: CH1 Vertical Data Start Position
  volatile uint32_t Ch2_DataStartPos_Y;  ///< 0x44 [R/W]: CH2 Vertical Data Start Position
  volatile uint32_t Ch3_DataStartPos_Y;  ///< 0x48 [R/W]: CH3 Vertical Data Start Position
  volatile uint32_t reserved2;
  volatile uint32_t Ch1_FixedRowStepX;  ///< 0x50 [R/W]: Fixed Row Step X for channel 1
  volatile uint32_t Ch2_FixedRowStepX;  ///< 0x54 [R/W]: Fixed Row Step X for channel 2
  volatile uint32_t Ch3_FixedRowStepX;  ///< 0x58 [R/W]: Fixed Row Step X for channel 3
  volatile uint32_t reserved3;
  volatile uint32_t Ch1_FixedRowStepY;  ///< 0x60 [R/W]: Fixed Row Step Y for channel 1
  volatile uint32_t Ch2_FixedRowStepY;  ///< 0x64 [R/W]: Fixed Row Step Y for channel 2
  volatile uint32_t Ch3_FixedRowStepY;  ///< 0x68 [R/W]: Fixed Row Step Y for channel 3
  volatile uint32_t reserved4;
  volatile uint32_t Ch1_FixedColStepX;  ///< 0x70 [R/W]: Fixed Col Step X for channel 1
  volatile uint32_t Ch2_FixedColStepX;  ///< 0x74 [R/W]: Fixed Col Step X for channel 2
  volatile uint32_t Ch3_FixedColStepX;  ///< 0x78 [R/W]: Fixed Col Step X for channel 3
  volatile uint32_t reserved5;
  volatile uint32_t Ch1_FixedColStepY;  ///< 0x80 [R/W]: Fixed Col Step Y for channel 1
  volatile uint32_t Ch2_FixedColStepY;  ///< 0x84 [R/W]: Fixed Col Step Y for channel 2
  volatile uint32_t Ch3_FixedColStepY;  ///< 0x88 [R/W]: Fixed Col Step Y for channel 3
  volatile uint32_t reserved6;
  volatile uint32_t Ch1_BlankValue;  ///< 0x90 [R/W]: Blank value for channel 1
  volatile uint32_t Ch2_BlankValue;  ///< 0x94 [R/W]: Blank value for channel 2
  volatile uint32_t Ch3_BlankValue;  ///< 0x98 [R/W]: Blank value for channel 3
  volatile uint32_t reserved7;
  volatile uint32_t Ch1_HighestLine;  ///< 0xa0 [R]: Highest line for channel 1
  volatile uint32_t Ch2_HighestLine;  ///< 0xa4 [R]: Highest line for channel 2
  volatile uint32_t Ch3_HighestLine;  ///< 0xa8 [R]: Highest line for channel 3
  volatile uint32_t HighestLineReset;  ///< 0xac [W]: Highest Line Counter Reset Register
  volatile uint32_t CurrentPosition;  ///< 0xb0 [R]: Current Position
  volatile uint32_t PosSelect;  ///< 0xb4 [R/W]: Position Select
  volatile uint32_t reserved8[82];
  volatile uint32_t REV0;  ///< 0x200 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0x204 [R]: IP Tagging Revision 1
  volatile uint32_t reserved9[62];
  volatile uint32_t HCL0;  ///< 0x300 [R/W]: Horizontal Coefficient 0 / 1 (Instance 1 of 16)
  volatile uint32_t HCH0;  ///< 0x304 [R/W]: Horizontal Coefficient 2 / 3 (Instance 1 of 16)
  volatile uint32_t HCL1;  ///< 0x308 [R/W]: Horizontal Coefficient 0 / 1 (Instance 2 of 16)
  volatile uint32_t HCH1;  ///< 0x30c [R/W]: Horizontal Coefficient 2 / 3 (Instance 2 of 16)
  volatile uint32_t HCL2;  ///< 0x310 [R/W]: Horizontal Coefficient 0 / 1 (Instance 3 of 16)
  volatile uint32_t HCH2;  ///< 0x314 [R/W]: Horizontal Coefficient 2 / 3 (Instance 3 of 16)
  volatile uint32_t HCL3;  ///< 0x318 [R/W]: Horizontal Coefficient 0 / 1 (Instance 4 of 16)
  volatile uint32_t HCH3;  ///< 0x31c [R/W]: Horizontal Coefficient 2 / 3 (Instance 4 of 16)
  volatile uint32_t HCL4;  ///< 0x320 [R/W]: Horizontal Coefficient 0 / 1 (Instance 5 of 16)
  volatile uint32_t HCH4;  ///< 0x324 [R/W]: Horizontal Coefficient 2 / 3 (Instance 5 of 16)
  volatile uint32_t HCL5;  ///< 0x328 [R/W]: Horizontal Coefficient 0 / 1 (Instance 6 of 16)
  volatile uint32_t HCH5;  ///< 0x32c [R/W]: Horizontal Coefficient 2 / 3 (Instance 6 of 16)
  volatile uint32_t HCL6;  ///< 0x330 [R/W]: Horizontal Coefficient 0 / 1 (Instance 7 of 16)
  volatile uint32_t HCH6;  ///< 0x334 [R/W]: Horizontal Coefficient 2 / 3 (Instance 7 of 16)
  volatile uint32_t HCL7;  ///< 0x338 [R/W]: Horizontal Coefficient 0 / 1 (Instance 8 of 16)
  volatile uint32_t HCH7;  ///< 0x33c [R/W]: Horizontal Coefficient 2 / 3 (Instance 8 of 16)
  volatile uint32_t HCL8;  ///< 0x340 [R/W]: Horizontal Coefficient 0 / 1 (Instance 9 of 16)
  volatile uint32_t HCH8;  ///< 0x344 [R/W]: Horizontal Coefficient 2 / 3 (Instance 9 of 16)
  volatile uint32_t HCL9;  ///< 0x348 [R/W]: Horizontal Coefficient 0 / 1 (Instance 10 of 16)
  volatile uint32_t HCH9;  ///< 0x34c [R/W]: Horizontal Coefficient 2 / 3 (Instance 10 of 16)
  volatile uint32_t HCL10;  ///< 0x350 [R/W]: Horizontal Coefficient 0 / 1 (Instance 11 of 16)
  volatile uint32_t HCH10;  ///< 0x354 [R/W]: Horizontal Coefficient 2 / 3 (Instance 11 of 16)
  volatile uint32_t HCL11;  ///< 0x358 [R/W]: Horizontal Coefficient 0 / 1 (Instance 12 of 16)
  volatile uint32_t HCH11;  ///< 0x35c [R/W]: Horizontal Coefficient 2 / 3 (Instance 12 of 16)
  volatile uint32_t HCL12;  ///< 0x360 [R/W]: Horizontal Coefficient 0 / 1 (Instance 13 of 16)
  volatile uint32_t HCH12;  ///< 0x364 [R/W]: Horizontal Coefficient 2 / 3 (Instance 13 of 16)
  volatile uint32_t HCL13;  ///< 0x368 [R/W]: Horizontal Coefficient 0 / 1 (Instance 14 of 16)
  volatile uint32_t HCH13;  ///< 0x36c [R/W]: Horizontal Coefficient 2 / 3 (Instance 14 of 16)
  volatile uint32_t HCL14;  ///< 0x370 [R/W]: Horizontal Coefficient 0 / 1 (Instance 15 of 16)
  volatile uint32_t HCH14;  ///< 0x374 [R/W]: Horizontal Coefficient 2 / 3 (Instance 15 of 16)
  volatile uint32_t HCL15;  ///< 0x378 [R/W]: Horizontal Coefficient 0 / 1 (Instance 16 of 16)
  volatile uint32_t HCH15;  ///< 0x37c [R/W]: Horizontal Coefficient 2 / 3 (Instance 16 of 16)
  volatile uint32_t VCL0;  ///< 0x380 [R/W]: Vertical Coefficient 0 / 1 (Instance 1 of 16)
  volatile uint32_t VCH0;  ///< 0x384 [R/W]: Vertical Coefficient 2 / 3 (Instance 1 of 16)
  volatile uint32_t VCL1;  ///< 0x388 [R/W]: Vertical Coefficient 0 / 1 (Instance 2 of 16)
  volatile uint32_t VCH1;  ///< 0x38c [R/W]: Vertical Coefficient 2 / 3 (Instance 2 of 16)
  volatile uint32_t VCL2;  ///< 0x390 [R/W]: Vertical Coefficient 0 / 1 (Instance 3 of 16)
  volatile uint32_t VCH2;  ///< 0x394 [R/W]: Vertical Coefficient 2 / 3 (Instance 3 of 16)
  volatile uint32_t VCL3;  ///< 0x398 [R/W]: Vertical Coefficient 0 / 1 (Instance 4 of 16)
  volatile uint32_t VCH3;  ///< 0x39c [R/W]: Vertical Coefficient 2 / 3 (Instance 4 of 16)
  volatile uint32_t VCL4;  ///< 0x3a0 [R/W]: Vertical Coefficient 0 / 1 (Instance 5 of 16)
  volatile uint32_t VCH4;  ///< 0x3a4 [R/W]: Vertical Coefficient 2 / 3 (Instance 5 of 16)
  volatile uint32_t VCL5;  ///< 0x3a8 [R/W]: Vertical Coefficient 0 / 1 (Instance 6 of 16)
  volatile uint32_t VCH5;  ///< 0x3ac [R/W]: Vertical Coefficient 2 / 3 (Instance 6 of 16)
  volatile uint32_t VCL6;  ///< 0x3b0 [R/W]: Vertical Coefficient 0 / 1 (Instance 7 of 16)
  volatile uint32_t VCH6;  ///< 0x3b4 [R/W]: Vertical Coefficient 2 / 3 (Instance 7 of 16)
  volatile uint32_t VCL7;  ///< 0x3b8 [R/W]: Vertical Coefficient 0 / 1 (Instance 8 of 16)
  volatile uint32_t VCH7;  ///< 0x3bc [R/W]: Vertical Coefficient 2 / 3 (Instance 8 of 16)
  volatile uint32_t VCL8;  ///< 0x3c0 [R/W]: Vertical Coefficient 0 / 1 (Instance 9 of 16)
  volatile uint32_t VCH8;  ///< 0x3c4 [R/W]: Vertical Coefficient 2 / 3 (Instance 9 of 16)
  volatile uint32_t VCL9;  ///< 0x3c8 [R/W]: Vertical Coefficient 0 / 1 (Instance 10 of 16)
  volatile uint32_t VCH9;  ///< 0x3cc [R/W]: Vertical Coefficient 2 / 3 (Instance 10 of 16)
  volatile uint32_t VCL10;  ///< 0x3d0 [R/W]: Vertical Coefficient 0 / 1 (Instance 11 of 16)
  volatile uint32_t VCH10;  ///< 0x3d4 [R/W]: Vertical Coefficient 2 / 3 (Instance 11 of 16)
  volatile uint32_t VCL11;  ///< 0x3d8 [R/W]: Vertical Coefficient 0 / 1 (Instance 12 of 16)
  volatile uint32_t VCH11;  ///< 0x3dc [R/W]: Vertical Coefficient 2 / 3 (Instance 12 of 16)
  volatile uint32_t VCL12;  ///< 0x3e0 [R/W]: Vertical Coefficient 0 / 1 (Instance 13 of 16)
  volatile uint32_t VCH12;  ///< 0x3e4 [R/W]: Vertical Coefficient 2 / 3 (Instance 13 of 16)
  volatile uint32_t VCL13;  ///< 0x3e8 [R/W]: Vertical Coefficient 0 / 1 (Instance 14 of 16)
  volatile uint32_t VCH13;  ///< 0x3ec [R/W]: Vertical Coefficient 2 / 3 (Instance 14 of 16)
  volatile uint32_t VCL14;  ///< 0x3f0 [R/W]: Vertical Coefficient 0 / 1 (Instance 15 of 16)
  volatile uint32_t VCH14;  ///< 0x3f4 [R/W]: Vertical Coefficient 2 / 3 (Instance 15 of 16)
  volatile uint32_t VCL15;  ///< 0x3f8 [R/W]: Vertical Coefficient 0 / 1 (Instance 16 of 16)
  volatile uint32_t VCH15;  ///< 0x3fc [R/W]: Vertical Coefficient 2 / 3 (Instance 16 of 16)
} DISTORT_TOP_DISTORT_REGS_t;

//====================================================================
//
//Register File: PIE DISTORT_MAP (DISTORT_TOP_DISTORT_MAP)
/** \brief Register descriptions for the DISTORT_MAP block.*/
//
//====================================================================

typedef struct DISTORT_TOP_DISTORT_MAP_REGS_s
{
  volatile uint32_t CR_BLOCK;  ///< 0x0 [R/W]: DISTORT_MAP Block Configuration Register
  volatile uint32_t CR_IMAGE;  ///< 0x4 [R/W]: DISTORT_MAP Image Configuration Register
  volatile uint32_t CR_STRIP;  ///< 0x8 [W]: DISTORT_MAP Strip Configuration Register
  volatile uint32_t SR_STRIP;  ///< 0xc [R]: DISTORT_MAP Strip Status Register
  volatile uint32_t SR_OUTPUT;  ///< 0x10 [R]: DISTORT_MAP Output Status Register
  volatile uint32_t CR_CH0SE0;  ///< 0x14 [W]: DISTORT_MAP Channel 0 Start Element 0 Configuration Register
  volatile uint32_t CR_CH0SE1;  ///< 0x18 [W]: DISTORT_MAP Channel 0 Start Element 1 Configuration Register
  volatile uint32_t CR_CH1SE0;  ///< 0x1c [W]: DISTORT_MAP Channel 1 Start Element 0 Configuration Register
  volatile uint32_t CR_CH1SE1;  ///< 0x20 [W]: DISTORT_MAP Channel 1 Start Element 1 Configuration Register
  volatile uint32_t CR_CH2SE0;  ///< 0x24 [W]: DISTORT_MAP Channel 2 Start Element 0 Configuration Register
  volatile uint32_t CR_CH2SE1;  ///< 0x28 [W]: DISTORT_MAP Channel 2 Start Element 1 Configuration Register
  volatile uint32_t SR_CH0SE0;  ///< 0x2c [R]: DISTORT_MAP Channel 0 Start Element 0 Status Register
  volatile uint32_t SR_CH0SE1;  ///< 0x30 [R]: DISTORT_MAP Channel 0 Start Element 1 Status Register
  volatile uint32_t SR_CH1SE0;  ///< 0x34 [R]: DISTORT_MAP Channel 1 Start Element 0 Status Register
  volatile uint32_t SR_CH1SE1;  ///< 0x38 [R]: DISTORT_MAP Channel 1 Start Element 1 Status Register
  volatile uint32_t SR_CH2SE0;  ///< 0x3c [R]: DISTORT_MAP Channel 2 Start Element 0 Status Register
  volatile uint32_t SR_CH2SE1;  ///< 0x40 [R]: DISTORT_MAP Channel 2 Start Element 1 Status Register
  volatile uint32_t INTR_EN;  ///< 0x44 [R/W]: DISTORT_MAP Interrupt Enable Register
  volatile uint32_t INTR_STAT;  ///< 0x48 [R]: DISTORT_MAP Interrupt Status Register
  volatile uint32_t INTR_ACK;  ///< 0x4c [W]: DISTORT_MAP Interrupt Acknowledge Register
  volatile uint32_t INTR_FORCE;  ///< 0x50 [W]: DISTORT_MAP Interrupt Force Register
  volatile uint32_t DR_CH0PRE;  ///< 0x54 [R]: DISTORT_MAP Channel 0 Prefetch Debug Register
  volatile uint32_t DR_CH0DEL;  ///< 0x58 [R]: DISTORT_MAP Channel 0 Delayed Debug Register
  volatile uint32_t DR_CH1PRE;  ///< 0x5c [R]: DISTORT_MAP Channel 1 Prefetch Debug Register
  volatile uint32_t DR_CH1DEL;  ///< 0x60 [R]: DISTORT_MAP Channel 1 Delayed Debug Register
  volatile uint32_t DR_CH2PRE;  ///< 0x64 [R]: DISTORT_MAP Channel 2 Prefetch Debug Register
  volatile uint32_t DR_CH2DEL;  ///< 0x68 [R]: DISTORT_MAP Channel 2 Delayed Debug Register
  volatile uint32_t REV0;  ///< 0x6c [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0x70 [R]: IP Tagging Revision 1
} DISTORT_TOP_DISTORT_MAP_REGS_t;

//====================================================================
//
//Register File: POGO_ODMA_UDMA (POGO_IHI_ODMA_POGO_ODMA_UDMA)
//
//====================================================================

typedef struct POGO_IHI_ODMA_POGO_ODMA_UDMA_REGS_s
{
  volatile uint32_t UCR;  ///< 0x0 [R/W]: UDMA Configuration Register
  volatile uint32_t USR;  ///< 0x4 [R]: UDMA Status Register
  volatile uint32_t UPR;  ///< 0x8 [R]: UDMA Parameter Register
  volatile uint32_t UIER;  ///< 0xc [R/W]: UDMA Interrupt Enable Register
  volatile uint32_t UIPR;  ///< 0x10 [R]: UDMA Interrupt Pending Register
  volatile uint32_t UICR;  ///< 0x14 [W]: UDMA Interrupt Clear Register
  volatile uint32_t UIFR;  ///< 0x18 [W]: UDMA Interrupt Force Register
  volatile uint32_t UDR;  ///< 0x1c [R/W]: UDMA Descriptor Register
  volatile uint32_t UBAR;  ///< 0x20 [R]: UDMA Burst Address Register
  volatile uint32_t UBLR;  ///< 0x24 [R]: UDMA Burst Length Register
  volatile uint32_t UBRR;  ///< 0x28 [R]: UDMA Transfer Bytes Remaining Register
  volatile uint32_t reserved0;
  volatile uint32_t UTR0;  ///< 0x30 [R]: UDMA Tag Register 0
  volatile uint32_t UTR1;  ///< 0x34 [R]: UDMA Tag Register 1
} POGO_IHI_ODMA_POGO_ODMA_UDMA_REGS_t;

//====================================================================
//
//Register File: POGO_ODMA_CORE (POGO_IHI_ODMA_POGO_ODMA_CORE)
//
//====================================================================

typedef struct POGO_IHI_ODMA_POGO_ODMA_CORE_REGS_s
{
  volatile uint32_t reserved0;
  volatile uint32_t OIER;  ///< 0x4 [R/W]: ODMA Interrupt Enable Register
  volatile uint32_t OIPR;  ///< 0x8 [R]: ODMA Interrupt Pending Register
  volatile uint32_t OICR;  ///< 0xc [W]: ODMA Interrupt Clear Register
  volatile uint32_t OIFR;  ///< 0x10 [W]: ODMA Interrupt Force Register
  volatile uint32_t OLWR;  ///< 0x14 [R/W]: ODMA Line Width Register
  volatile uint32_t OCNTRL;  ///< 0x18 [R/W]: ODMA Control Register
  volatile uint32_t OTR0;  ///< 0x1c [R]: ODMA Tag Register 0
  volatile uint32_t OTR1;  ///< 0x20 [R]: ODMA Tag Register 1
  volatile uint32_t OTR2;  ///< 0x24 [R]: ODMA Tag Register 2
} POGO_IHI_ODMA_POGO_ODMA_CORE_REGS_t;

//====================================================================
//
//Register File: PIE LUT1D (Bit Depth Enhance) (Instance 1 of 3) (DISTORT_TOP_ANTIFCOR_TOP_LUT1D_BDE0)
/** \brief (rev 0 . 1 . 6 . 3)
    Register descriptions for the LUT1D block.*/
//
//====================================================================

typedef struct DISTORT_TOP_ANTIFCOR_TOP_LUT1D_BDE0_REGS_s
{
  volatile uint32_t REV0;  ///< 0x0 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0x4 [R]: IP Tagging Revision 1
  volatile uint32_t LUT_CR;  ///< 0x8 [R/W]: LUT1D Configuration Register
  volatile uint32_t reserved0[253];
  volatile uint32_t LUT0[256];  ///< 0x400 [R/W]: LUT1D Look Up Table 0
} DISTORT_TOP_ANTIFCOR_TOP_LUT1D_BDE0_REGS_t;

//====================================================================
//
//Register File: PIE LUT1D (Bit Depth Enhance) (Instance 2 of 3) (DISTORT_TOP_ANTIFCOR_TOP_LUT1D_BDE1)
/** \brief (rev 0 . 1 . 6 . 3)
    Register descriptions for the LUT1D block.*/
//
//====================================================================

typedef struct DISTORT_TOP_ANTIFCOR_TOP_LUT1D_BDE1_REGS_s
{
  volatile uint32_t REV0;  ///< 0x0 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0x4 [R]: IP Tagging Revision 1
  volatile uint32_t LUT_CR;  ///< 0x8 [R/W]: LUT1D Configuration Register
  volatile uint32_t reserved0[253];
  volatile uint32_t LUT0[256];  ///< 0x400 [R/W]: LUT1D Look Up Table 0
} DISTORT_TOP_ANTIFCOR_TOP_LUT1D_BDE1_REGS_t;

//====================================================================
//
//Register File: PIE LUT1D (Bit Depth Enhance) (Instance 3 of 3) (DISTORT_TOP_ANTIFCOR_TOP_LUT1D_BDE2)
/** \brief (rev 0 . 1 . 6 . 3)
    Register descriptions for the LUT1D block.*/
//
//====================================================================

typedef struct DISTORT_TOP_ANTIFCOR_TOP_LUT1D_BDE2_REGS_s
{
  volatile uint32_t REV0;  ///< 0x0 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0x4 [R]: IP Tagging Revision 1
  volatile uint32_t LUT_CR;  ///< 0x8 [R/W]: LUT1D Configuration Register
  volatile uint32_t reserved0[253];
  volatile uint32_t LUT0[256];  ///< 0x400 [R/W]: LUT1D Look Up Table 0
} DISTORT_TOP_ANTIFCOR_TOP_LUT1D_BDE2_REGS_t;

//====================================================================
//
//Register File: PIE Antiflare Correction (DISTORT_TOP_ANTIFCOR_TOP_ANTIFCOR)
/** \brief Register descriptions for the ANTIFCOR block.*/
//
//====================================================================

typedef struct DISTORT_TOP_ANTIFCOR_TOP_ANTIFCOR_REGS_s
{
  volatile uint32_t ANTIFCOR_CFG;  ///< 0x0 [R/W]: ANTIFCOR Configuration Register
  volatile uint32_t ANTIFCOR_CLIP;  ///< 0x4 [R/W]: ANTIFCOR Gray and Black Clip Register
  volatile uint32_t REV0;  ///< 0x8 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0xc [R]: IP Tagging Revision 1
} DISTORT_TOP_ANTIFCOR_TOP_ANTIFCOR_REGS_t;

//====================================================================
//
//Register File: PIE DISTORT DMA ANTIFCOR Data (Instance 1 of 3) (DISTORT_TOP_ANTIFCOR_TOP_DDMA_AC_DATA0)
//
//====================================================================

typedef struct DISTORT_TOP_ANTIFCOR_TOP_DDMA_AC_DATA0_REGS_s
{
  volatile uint32_t UCR;  ///< 0x0 [R/W]: DISTORT_DMA Configuration Register
  volatile uint32_t USR;  ///< 0x4 [R]: DISTORT_DMA Status Register
  volatile uint32_t UPR;  ///< 0x8 [R]: DISTORT_DMA Parameter Register
  volatile uint32_t UIER;  ///< 0xc [R/W]: DISTORT_DMA Interrupt Enable Register
  volatile uint32_t UIPR;  ///< 0x10 [R]: DISTORT_DMA Interrupt Pending Register
  volatile uint32_t UICR;  ///< 0x14 [W]: DISTORT_DMA Interrupt Clear Register
  volatile uint32_t UIFR;  ///< 0x18 [W]: DISTORT_DMA Interrupt Force Register
  volatile uint32_t UDR;  ///< 0x1c [R/W]: DISTORT_DMA Descriptor Register
  volatile uint32_t UBAR;  ///< 0x20 [R]: DISTORT_DMA Burst Address Register
  volatile uint32_t UBLR;  ///< 0x24 [R]: DISTORT_DMA Burst Length Register
  volatile uint32_t UIWR;  ///< 0x28 [R/W]: DISTORT_DMA Image Width Register
  volatile uint32_t UTR0;  ///< 0x2c [R]: DISTORT_DMA Tag Register 0
  volatile uint32_t UTR1;  ///< 0x30 [R]: DISTORT_DMA Tag Register 1
  volatile uint32_t UTR2;  ///< 0x34 [R]: DISTORT_DMA Tag Register 2
} DISTORT_TOP_ANTIFCOR_TOP_DDMA_AC_DATA0_REGS_t;

//====================================================================
//
//Register File: PIE DISTORT DMA ANTIFCOR Data (Instance 2 of 3) (DISTORT_TOP_ANTIFCOR_TOP_DDMA_AC_DATA1)
//
//====================================================================

typedef struct DISTORT_TOP_ANTIFCOR_TOP_DDMA_AC_DATA1_REGS_s
{
  volatile uint32_t UCR;  ///< 0x0 [R/W]: DISTORT_DMA Configuration Register
  volatile uint32_t USR;  ///< 0x4 [R]: DISTORT_DMA Status Register
  volatile uint32_t UPR;  ///< 0x8 [R]: DISTORT_DMA Parameter Register
  volatile uint32_t UIER;  ///< 0xc [R/W]: DISTORT_DMA Interrupt Enable Register
  volatile uint32_t UIPR;  ///< 0x10 [R]: DISTORT_DMA Interrupt Pending Register
  volatile uint32_t UICR;  ///< 0x14 [W]: DISTORT_DMA Interrupt Clear Register
  volatile uint32_t UIFR;  ///< 0x18 [W]: DISTORT_DMA Interrupt Force Register
  volatile uint32_t UDR;  ///< 0x1c [R/W]: DISTORT_DMA Descriptor Register
  volatile uint32_t UBAR;  ///< 0x20 [R]: DISTORT_DMA Burst Address Register
  volatile uint32_t UBLR;  ///< 0x24 [R]: DISTORT_DMA Burst Length Register
  volatile uint32_t UIWR;  ///< 0x28 [R/W]: DISTORT_DMA Image Width Register
  volatile uint32_t UTR0;  ///< 0x2c [R]: DISTORT_DMA Tag Register 0
  volatile uint32_t UTR1;  ///< 0x30 [R]: DISTORT_DMA Tag Register 1
  volatile uint32_t UTR2;  ///< 0x34 [R]: DISTORT_DMA Tag Register 2
} DISTORT_TOP_ANTIFCOR_TOP_DDMA_AC_DATA1_REGS_t;

//====================================================================
//
//Register File: PIE DISTORT DMA ANTIFCOR Data (Instance 3 of 3) (DISTORT_TOP_ANTIFCOR_TOP_DDMA_AC_DATA2)
//
//====================================================================

typedef struct DISTORT_TOP_ANTIFCOR_TOP_DDMA_AC_DATA2_REGS_s
{
  volatile uint32_t UCR;  ///< 0x0 [R/W]: DISTORT_DMA Configuration Register
  volatile uint32_t USR;  ///< 0x4 [R]: DISTORT_DMA Status Register
  volatile uint32_t UPR;  ///< 0x8 [R]: DISTORT_DMA Parameter Register
  volatile uint32_t UIER;  ///< 0xc [R/W]: DISTORT_DMA Interrupt Enable Register
  volatile uint32_t UIPR;  ///< 0x10 [R]: DISTORT_DMA Interrupt Pending Register
  volatile uint32_t UICR;  ///< 0x14 [W]: DISTORT_DMA Interrupt Clear Register
  volatile uint32_t UIFR;  ///< 0x18 [W]: DISTORT_DMA Interrupt Force Register
  volatile uint32_t UDR;  ///< 0x1c [R/W]: DISTORT_DMA Descriptor Register
  volatile uint32_t UBAR;  ///< 0x20 [R]: DISTORT_DMA Burst Address Register
  volatile uint32_t UBLR;  ///< 0x24 [R]: DISTORT_DMA Burst Length Register
  volatile uint32_t UIWR;  ///< 0x28 [R/W]: DISTORT_DMA Image Width Register
  volatile uint32_t UTR0;  ///< 0x2c [R]: DISTORT_DMA Tag Register 0
  volatile uint32_t UTR1;  ///< 0x30 [R]: DISTORT_DMA Tag Register 1
  volatile uint32_t UTR2;  ///< 0x34 [R]: DISTORT_DMA Tag Register 2
} DISTORT_TOP_ANTIFCOR_TOP_DDMA_AC_DATA2_REGS_t;

//====================================================================
//
//Register File: PIE DISTORT DMA ANTIFCOR Correction (Instance 1 of 3) (DISTORT_TOP_ANTIFCOR_TOP_DDMA_AC_CORR0)
//
//====================================================================

typedef struct DISTORT_TOP_ANTIFCOR_TOP_DDMA_AC_CORR0_REGS_s
{
  volatile uint32_t UCR;  ///< 0x0 [R/W]: DISTORT_DMA Configuration Register
  volatile uint32_t USR;  ///< 0x4 [R]: DISTORT_DMA Status Register
  volatile uint32_t UPR;  ///< 0x8 [R]: DISTORT_DMA Parameter Register
  volatile uint32_t UIER;  ///< 0xc [R/W]: DISTORT_DMA Interrupt Enable Register
  volatile uint32_t UIPR;  ///< 0x10 [R]: DISTORT_DMA Interrupt Pending Register
  volatile uint32_t UICR;  ///< 0x14 [W]: DISTORT_DMA Interrupt Clear Register
  volatile uint32_t UIFR;  ///< 0x18 [W]: DISTORT_DMA Interrupt Force Register
  volatile uint32_t UDR;  ///< 0x1c [R/W]: DISTORT_DMA Descriptor Register
  volatile uint32_t UBAR;  ///< 0x20 [R]: DISTORT_DMA Burst Address Register
  volatile uint32_t UBLR;  ///< 0x24 [R]: DISTORT_DMA Burst Length Register
  volatile uint32_t UIWR;  ///< 0x28 [R/W]: DISTORT_DMA Image Width Register
  volatile uint32_t UTR0;  ///< 0x2c [R]: DISTORT_DMA Tag Register 0
  volatile uint32_t UTR1;  ///< 0x30 [R]: DISTORT_DMA Tag Register 1
  volatile uint32_t UTR2;  ///< 0x34 [R]: DISTORT_DMA Tag Register 2
} DISTORT_TOP_ANTIFCOR_TOP_DDMA_AC_CORR0_REGS_t;

//====================================================================
//
//Register File: PIE DISTORT DMA ANTIFCOR Correction (Instance 2 of 3) (DISTORT_TOP_ANTIFCOR_TOP_DDMA_AC_CORR1)
//
//====================================================================

typedef struct DISTORT_TOP_ANTIFCOR_TOP_DDMA_AC_CORR1_REGS_s
{
  volatile uint32_t UCR;  ///< 0x0 [R/W]: DISTORT_DMA Configuration Register
  volatile uint32_t USR;  ///< 0x4 [R]: DISTORT_DMA Status Register
  volatile uint32_t UPR;  ///< 0x8 [R]: DISTORT_DMA Parameter Register
  volatile uint32_t UIER;  ///< 0xc [R/W]: DISTORT_DMA Interrupt Enable Register
  volatile uint32_t UIPR;  ///< 0x10 [R]: DISTORT_DMA Interrupt Pending Register
  volatile uint32_t UICR;  ///< 0x14 [W]: DISTORT_DMA Interrupt Clear Register
  volatile uint32_t UIFR;  ///< 0x18 [W]: DISTORT_DMA Interrupt Force Register
  volatile uint32_t UDR;  ///< 0x1c [R/W]: DISTORT_DMA Descriptor Register
  volatile uint32_t UBAR;  ///< 0x20 [R]: DISTORT_DMA Burst Address Register
  volatile uint32_t UBLR;  ///< 0x24 [R]: DISTORT_DMA Burst Length Register
  volatile uint32_t UIWR;  ///< 0x28 [R/W]: DISTORT_DMA Image Width Register
  volatile uint32_t UTR0;  ///< 0x2c [R]: DISTORT_DMA Tag Register 0
  volatile uint32_t UTR1;  ///< 0x30 [R]: DISTORT_DMA Tag Register 1
  volatile uint32_t UTR2;  ///< 0x34 [R]: DISTORT_DMA Tag Register 2
} DISTORT_TOP_ANTIFCOR_TOP_DDMA_AC_CORR1_REGS_t;

//====================================================================
//
//Register File: PIE DISTORT DMA ANTIFCOR Correction (Instance 3 of 3) (DISTORT_TOP_ANTIFCOR_TOP_DDMA_AC_CORR2)
//
//====================================================================

typedef struct DISTORT_TOP_ANTIFCOR_TOP_DDMA_AC_CORR2_REGS_s
{
  volatile uint32_t UCR;  ///< 0x0 [R/W]: DISTORT_DMA Configuration Register
  volatile uint32_t USR;  ///< 0x4 [R]: DISTORT_DMA Status Register
  volatile uint32_t UPR;  ///< 0x8 [R]: DISTORT_DMA Parameter Register
  volatile uint32_t UIER;  ///< 0xc [R/W]: DISTORT_DMA Interrupt Enable Register
  volatile uint32_t UIPR;  ///< 0x10 [R]: DISTORT_DMA Interrupt Pending Register
  volatile uint32_t UICR;  ///< 0x14 [W]: DISTORT_DMA Interrupt Clear Register
  volatile uint32_t UIFR;  ///< 0x18 [W]: DISTORT_DMA Interrupt Force Register
  volatile uint32_t UDR;  ///< 0x1c [R/W]: DISTORT_DMA Descriptor Register
  volatile uint32_t UBAR;  ///< 0x20 [R]: DISTORT_DMA Burst Address Register
  volatile uint32_t UBLR;  ///< 0x24 [R]: DISTORT_DMA Burst Length Register
  volatile uint32_t UIWR;  ///< 0x28 [R/W]: DISTORT_DMA Image Width Register
  volatile uint32_t UTR0;  ///< 0x2c [R]: DISTORT_DMA Tag Register 0
  volatile uint32_t UTR1;  ///< 0x30 [R]: DISTORT_DMA Tag Register 1
  volatile uint32_t UTR2;  ///< 0x34 [R]: DISTORT_DMA Tag Register 2
} DISTORT_TOP_ANTIFCOR_TOP_DDMA_AC_CORR2_REGS_t;

#endif // PIE_PIE
 /*
 **************************************************************************************
 *
 * (c) Copyright 2014 Marvell International Ltd.
 *
 *
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/.
 *
 **************************************************************************************
 *
 * \file PIE_regmasks.h
 * Generated using RegBuild 1.6.3
 *
 **************************************************************************************
 */

#ifndef _PIE_PIE_REGMASKS_H_
#define _PIE_PIE_REGMASKS_H_

#include "hwincl.h"

//====================================================================
//
//Register File: PIE (PIE_PIE)
/** \brief Register Descriptions for the PIE superblock*/
//
//====================================================================

//====================================================================
//
//Register File: PIE Common Registers and Interrupts (PIE_Common)
/** \brief Register Descriptions for the PIE Common block
      (rev 0 . 0 . 7 . 0)*/
//
//====================================================================

//====================================================================
//Register: Interrupt Enable Register (IENR)
/** \brief Setting bits in this register to '1' will enable the corresponding interrupt source's 
        interrupts to be passed on to the CPU. If a bit in this register is '0', the
        corresponding interrupt source's interrupts will be masked off from the CPU, and would
        have to be polled via reads to the interrupt source's interrupt pending register.*/
//====================================================================

#define  PIE_COMMON_IENR_RESERVED1_MASK 0xfe000000
#define  PIE_COMMON_IENR_RESERVED1_SHIFT 25
#define  PIE_COMMON_IENR_RESERVED1_MASK_SHIFT(reg) (((reg) & PIE_COMMON_IENR_RESERVED1_MASK) >> PIE_COMMON_IENR_RESERVED1_SHIFT)
#define  PIE_COMMON_IENR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PIE_COMMON_IENR_RESERVED1_MASK) | (((uint32_t)val) << PIE_COMMON_IENR_RESERVED1_SHIFT))

#define  PIE_COMMON_IENR_RDMA_GROUPINTEN_MASK 0x1000000
#define  PIE_COMMON_IENR_RDMA_GROUPINTEN_SHIFT 24
#define  PIE_COMMON_IENR_RDMA_GROUPINTEN_MASK_SHIFT(reg) (((reg) & PIE_COMMON_IENR_RDMA_GROUPINTEN_MASK) >> PIE_COMMON_IENR_RDMA_GROUPINTEN_SHIFT)
#define  PIE_COMMON_IENR_RDMA_GROUPINTEN_REPLACE_VAL(reg,val) (((reg) & ~PIE_COMMON_IENR_RDMA_GROUPINTEN_MASK) | (((uint32_t)val) << PIE_COMMON_IENR_RDMA_GROUPINTEN_SHIFT))

#define  PIE_COMMON_IENR_DDMA_DATA_GROUPINTEN_MASK 0x800000
#define  PIE_COMMON_IENR_DDMA_DATA_GROUPINTEN_SHIFT 23
#define  PIE_COMMON_IENR_DDMA_DATA_GROUPINTEN_MASK_SHIFT(reg) (((reg) & PIE_COMMON_IENR_DDMA_DATA_GROUPINTEN_MASK) >> PIE_COMMON_IENR_DDMA_DATA_GROUPINTEN_SHIFT)
#define  PIE_COMMON_IENR_DDMA_DATA_GROUPINTEN_REPLACE_VAL(reg,val) (((reg) & ~PIE_COMMON_IENR_DDMA_DATA_GROUPINTEN_MASK) | (((uint32_t)val) << PIE_COMMON_IENR_DDMA_DATA_GROUPINTEN_SHIFT))

#define  PIE_COMMON_IENR_DDMA_CORR_GROUPINTEN_MASK 0x400000
#define  PIE_COMMON_IENR_DDMA_CORR_GROUPINTEN_SHIFT 22
#define  PIE_COMMON_IENR_DDMA_CORR_GROUPINTEN_MASK_SHIFT(reg) (((reg) & PIE_COMMON_IENR_DDMA_CORR_GROUPINTEN_MASK) >> PIE_COMMON_IENR_DDMA_CORR_GROUPINTEN_SHIFT)
#define  PIE_COMMON_IENR_DDMA_CORR_GROUPINTEN_REPLACE_VAL(reg,val) (((reg) & ~PIE_COMMON_IENR_DDMA_CORR_GROUPINTEN_MASK) | (((uint32_t)val) << PIE_COMMON_IENR_DDMA_CORR_GROUPINTEN_SHIFT))

#define  PIE_COMMON_IENR_DISTORTINTEN_MASK 0x200000
#define  PIE_COMMON_IENR_DISTORTINTEN_SHIFT 21
#define  PIE_COMMON_IENR_DISTORTINTEN_MASK_SHIFT(reg) (((reg) & PIE_COMMON_IENR_DISTORTINTEN_MASK) >> PIE_COMMON_IENR_DISTORTINTEN_SHIFT)
#define  PIE_COMMON_IENR_DISTORTINTEN_REPLACE_VAL(reg,val) (((reg) & ~PIE_COMMON_IENR_DISTORTINTEN_MASK) | (((uint32_t)val) << PIE_COMMON_IENR_DISTORTINTEN_SHIFT))

#define  PIE_COMMON_IENR_IHI16X8SHORTINTEN_MASK 0x100000
#define  PIE_COMMON_IENR_IHI16X8SHORTINTEN_SHIFT 20
#define  PIE_COMMON_IENR_IHI16X8SHORTINTEN_MASK_SHIFT(reg) (((reg) & PIE_COMMON_IENR_IHI16X8SHORTINTEN_MASK) >> PIE_COMMON_IENR_IHI16X8SHORTINTEN_SHIFT)
#define  PIE_COMMON_IENR_IHI16X8SHORTINTEN_REPLACE_VAL(reg,val) (((reg) & ~PIE_COMMON_IENR_IHI16X8SHORTINTEN_MASK) | (((uint32_t)val) << PIE_COMMON_IENR_IHI16X8SHORTINTEN_SHIFT))

#define  PIE_COMMON_IENR_IHI16X8TALLINTEN_MASK 0x80000
#define  PIE_COMMON_IENR_IHI16X8TALLINTEN_SHIFT 19
#define  PIE_COMMON_IENR_IHI16X8TALLINTEN_MASK_SHIFT(reg) (((reg) & PIE_COMMON_IENR_IHI16X8TALLINTEN_MASK) >> PIE_COMMON_IENR_IHI16X8TALLINTEN_SHIFT)
#define  PIE_COMMON_IENR_IHI16X8TALLINTEN_REPLACE_VAL(reg,val) (((reg) & ~PIE_COMMON_IENR_IHI16X8TALLINTEN_MASK) | (((uint32_t)val) << PIE_COMMON_IENR_IHI16X8TALLINTEN_SHIFT))

#define  PIE_COMMON_IENR_IHI3X3SHORTINTEN_MASK 0x40000
#define  PIE_COMMON_IENR_IHI3X3SHORTINTEN_SHIFT 18
#define  PIE_COMMON_IENR_IHI3X3SHORTINTEN_MASK_SHIFT(reg) (((reg) & PIE_COMMON_IENR_IHI3X3SHORTINTEN_MASK) >> PIE_COMMON_IENR_IHI3X3SHORTINTEN_SHIFT)
#define  PIE_COMMON_IENR_IHI3X3SHORTINTEN_REPLACE_VAL(reg,val) (((reg) & ~PIE_COMMON_IENR_IHI3X3SHORTINTEN_MASK) | (((uint32_t)val) << PIE_COMMON_IENR_IHI3X3SHORTINTEN_SHIFT))

#define  PIE_COMMON_IENR_IHI3X3TALLINTEN_MASK 0x20000
#define  PIE_COMMON_IENR_IHI3X3TALLINTEN_SHIFT 17
#define  PIE_COMMON_IENR_IHI3X3TALLINTEN_MASK_SHIFT(reg) (((reg) & PIE_COMMON_IENR_IHI3X3TALLINTEN_MASK) >> PIE_COMMON_IENR_IHI3X3TALLINTEN_SHIFT)
#define  PIE_COMMON_IENR_IHI3X3TALLINTEN_REPLACE_VAL(reg,val) (((reg) & ~PIE_COMMON_IENR_IHI3X3TALLINTEN_MASK) | (((uint32_t)val) << PIE_COMMON_IENR_IHI3X3TALLINTEN_SHIFT))

#define  PIE_COMMON_IENR_PACKMONO_WDMAINTEN_MASK 0x10000
#define  PIE_COMMON_IENR_PACKMONO_WDMAINTEN_SHIFT 16
#define  PIE_COMMON_IENR_PACKMONO_WDMAINTEN_MASK_SHIFT(reg) (((reg) & PIE_COMMON_IENR_PACKMONO_WDMAINTEN_MASK) >> PIE_COMMON_IENR_PACKMONO_WDMAINTEN_SHIFT)
#define  PIE_COMMON_IENR_PACKMONO_WDMAINTEN_REPLACE_VAL(reg,val) (((reg) & ~PIE_COMMON_IENR_PACKMONO_WDMAINTEN_MASK) | (((uint32_t)val) << PIE_COMMON_IENR_PACKMONO_WDMAINTEN_SHIFT))

#define  PIE_COMMON_IENR_DIS_MAPINTEN_MASK 0x8000
#define  PIE_COMMON_IENR_DIS_MAPINTEN_SHIFT 15
#define  PIE_COMMON_IENR_DIS_MAPINTEN_MASK_SHIFT(reg) (((reg) & PIE_COMMON_IENR_DIS_MAPINTEN_MASK) >> PIE_COMMON_IENR_DIS_MAPINTEN_SHIFT)
#define  PIE_COMMON_IENR_DIS_MAPINTEN_REPLACE_VAL(reg,val) (((reg) & ~PIE_COMMON_IENR_DIS_MAPINTEN_MASK) | (((uint32_t)val) << PIE_COMMON_IENR_DIS_MAPINTEN_SHIFT))

#define  PIE_COMMON_IENR_AC_CORR_RDMA2INTEN_MASK 0x4000
#define  PIE_COMMON_IENR_AC_CORR_RDMA2INTEN_SHIFT 14
#define  PIE_COMMON_IENR_AC_CORR_RDMA2INTEN_MASK_SHIFT(reg) (((reg) & PIE_COMMON_IENR_AC_CORR_RDMA2INTEN_MASK) >> PIE_COMMON_IENR_AC_CORR_RDMA2INTEN_SHIFT)
#define  PIE_COMMON_IENR_AC_CORR_RDMA2INTEN_REPLACE_VAL(reg,val) (((reg) & ~PIE_COMMON_IENR_AC_CORR_RDMA2INTEN_MASK) | (((uint32_t)val) << PIE_COMMON_IENR_AC_CORR_RDMA2INTEN_SHIFT))

#define  PIE_COMMON_IENR_AC_CORR_RDMA1INTEN_MASK 0x2000
#define  PIE_COMMON_IENR_AC_CORR_RDMA1INTEN_SHIFT 13
#define  PIE_COMMON_IENR_AC_CORR_RDMA1INTEN_MASK_SHIFT(reg) (((reg) & PIE_COMMON_IENR_AC_CORR_RDMA1INTEN_MASK) >> PIE_COMMON_IENR_AC_CORR_RDMA1INTEN_SHIFT)
#define  PIE_COMMON_IENR_AC_CORR_RDMA1INTEN_REPLACE_VAL(reg,val) (((reg) & ~PIE_COMMON_IENR_AC_CORR_RDMA1INTEN_MASK) | (((uint32_t)val) << PIE_COMMON_IENR_AC_CORR_RDMA1INTEN_SHIFT))

#define  PIE_COMMON_IENR_AC_CORR_RDMA0INTEN_MASK 0x1000
#define  PIE_COMMON_IENR_AC_CORR_RDMA0INTEN_SHIFT 12
#define  PIE_COMMON_IENR_AC_CORR_RDMA0INTEN_MASK_SHIFT(reg) (((reg) & PIE_COMMON_IENR_AC_CORR_RDMA0INTEN_MASK) >> PIE_COMMON_IENR_AC_CORR_RDMA0INTEN_SHIFT)
#define  PIE_COMMON_IENR_AC_CORR_RDMA0INTEN_REPLACE_VAL(reg,val) (((reg) & ~PIE_COMMON_IENR_AC_CORR_RDMA0INTEN_MASK) | (((uint32_t)val) << PIE_COMMON_IENR_AC_CORR_RDMA0INTEN_SHIFT))

#define  PIE_COMMON_IENR_AC_DATA_RDMA2INTEN_MASK 0x800
#define  PIE_COMMON_IENR_AC_DATA_RDMA2INTEN_SHIFT 11
#define  PIE_COMMON_IENR_AC_DATA_RDMA2INTEN_MASK_SHIFT(reg) (((reg) & PIE_COMMON_IENR_AC_DATA_RDMA2INTEN_MASK) >> PIE_COMMON_IENR_AC_DATA_RDMA2INTEN_SHIFT)
#define  PIE_COMMON_IENR_AC_DATA_RDMA2INTEN_REPLACE_VAL(reg,val) (((reg) & ~PIE_COMMON_IENR_AC_DATA_RDMA2INTEN_MASK) | (((uint32_t)val) << PIE_COMMON_IENR_AC_DATA_RDMA2INTEN_SHIFT))

#define  PIE_COMMON_IENR_AC_DATA_RDMA1INTEN_MASK 0x400
#define  PIE_COMMON_IENR_AC_DATA_RDMA1INTEN_SHIFT 10
#define  PIE_COMMON_IENR_AC_DATA_RDMA1INTEN_MASK_SHIFT(reg) (((reg) & PIE_COMMON_IENR_AC_DATA_RDMA1INTEN_MASK) >> PIE_COMMON_IENR_AC_DATA_RDMA1INTEN_SHIFT)
#define  PIE_COMMON_IENR_AC_DATA_RDMA1INTEN_REPLACE_VAL(reg,val) (((reg) & ~PIE_COMMON_IENR_AC_DATA_RDMA1INTEN_MASK) | (((uint32_t)val) << PIE_COMMON_IENR_AC_DATA_RDMA1INTEN_SHIFT))

#define  PIE_COMMON_IENR_AC_DATA_RDMA0INTEN_MASK 0x200
#define  PIE_COMMON_IENR_AC_DATA_RDMA0INTEN_SHIFT 9
#define  PIE_COMMON_IENR_AC_DATA_RDMA0INTEN_MASK_SHIFT(reg) (((reg) & PIE_COMMON_IENR_AC_DATA_RDMA0INTEN_MASK) >> PIE_COMMON_IENR_AC_DATA_RDMA0INTEN_SHIFT)
#define  PIE_COMMON_IENR_AC_DATA_RDMA0INTEN_REPLACE_VAL(reg,val) (((reg) & ~PIE_COMMON_IENR_AC_DATA_RDMA0INTEN_MASK) | (((uint32_t)val) << PIE_COMMON_IENR_AC_DATA_RDMA0INTEN_SHIFT))

#define  PIE_COMMON_IENR_DSMFSHORTINTEN_MASK 0x100
#define  PIE_COMMON_IENR_DSMFSHORTINTEN_SHIFT 8
#define  PIE_COMMON_IENR_DSMFSHORTINTEN_MASK_SHIFT(reg) (((reg) & PIE_COMMON_IENR_DSMFSHORTINTEN_MASK) >> PIE_COMMON_IENR_DSMFSHORTINTEN_SHIFT)
#define  PIE_COMMON_IENR_DSMFSHORTINTEN_REPLACE_VAL(reg,val) (((reg) & ~PIE_COMMON_IENR_DSMFSHORTINTEN_MASK) | (((uint32_t)val) << PIE_COMMON_IENR_DSMFSHORTINTEN_SHIFT))

#define  PIE_COMMON_IENR_DSMFTALLINTEN_MASK 0x80
#define  PIE_COMMON_IENR_DSMFTALLINTEN_SHIFT 7
#define  PIE_COMMON_IENR_DSMFTALLINTEN_MASK_SHIFT(reg) (((reg) & PIE_COMMON_IENR_DSMFTALLINTEN_MASK) >> PIE_COMMON_IENR_DSMFTALLINTEN_SHIFT)
#define  PIE_COMMON_IENR_DSMFTALLINTEN_REPLACE_VAL(reg,val) (((reg) & ~PIE_COMMON_IENR_DSMFTALLINTEN_MASK) | (((uint32_t)val) << PIE_COMMON_IENR_DSMFTALLINTEN_SHIFT))

#define  PIE_COMMON_IENR_OTMARBINTEN_MASK 0x40
#define  PIE_COMMON_IENR_OTMARBINTEN_SHIFT 6
#define  PIE_COMMON_IENR_OTMARBINTEN_MASK_SHIFT(reg) (((reg) & PIE_COMMON_IENR_OTMARBINTEN_MASK) >> PIE_COMMON_IENR_OTMARBINTEN_SHIFT)
#define  PIE_COMMON_IENR_OTMARBINTEN_REPLACE_VAL(reg,val) (((reg) & ~PIE_COMMON_IENR_OTMARBINTEN_MASK) | (((uint32_t)val) << PIE_COMMON_IENR_OTMARBINTEN_SHIFT))

#define  PIE_COMMON_IENR_OT_WDMAINTEN_MASK 0x20
#define  PIE_COMMON_IENR_OT_WDMAINTEN_SHIFT 5
#define  PIE_COMMON_IENR_OT_WDMAINTEN_MASK_SHIFT(reg) (((reg) & PIE_COMMON_IENR_OT_WDMAINTEN_MASK) >> PIE_COMMON_IENR_OT_WDMAINTEN_SHIFT)
#define  PIE_COMMON_IENR_OT_WDMAINTEN_REPLACE_VAL(reg,val) (((reg) & ~PIE_COMMON_IENR_OT_WDMAINTEN_MASK) | (((uint32_t)val) << PIE_COMMON_IENR_OT_WDMAINTEN_SHIFT))

#define  PIE_COMMON_IENR_WDMAINTEN_MASK 0x10
#define  PIE_COMMON_IENR_WDMAINTEN_SHIFT 4
#define  PIE_COMMON_IENR_WDMAINTEN_MASK_SHIFT(reg) (((reg) & PIE_COMMON_IENR_WDMAINTEN_MASK) >> PIE_COMMON_IENR_WDMAINTEN_SHIFT)
#define  PIE_COMMON_IENR_WDMAINTEN_REPLACE_VAL(reg,val) (((reg) & ~PIE_COMMON_IENR_WDMAINTEN_MASK) | (((uint32_t)val) << PIE_COMMON_IENR_WDMAINTEN_SHIFT))

#define  PIE_COMMON_IENR_OT_RDMAINTEN_MASK 0x8
#define  PIE_COMMON_IENR_OT_RDMAINTEN_SHIFT 3
#define  PIE_COMMON_IENR_OT_RDMAINTEN_MASK_SHIFT(reg) (((reg) & PIE_COMMON_IENR_OT_RDMAINTEN_MASK) >> PIE_COMMON_IENR_OT_RDMAINTEN_SHIFT)
#define  PIE_COMMON_IENR_OT_RDMAINTEN_REPLACE_VAL(reg,val) (((reg) & ~PIE_COMMON_IENR_OT_RDMAINTEN_MASK) | (((uint32_t)val) << PIE_COMMON_IENR_OT_RDMAINTEN_SHIFT))

#define  PIE_COMMON_IENR_RDMA2INTEN_MASK 0x4
#define  PIE_COMMON_IENR_RDMA2INTEN_SHIFT 2
#define  PIE_COMMON_IENR_RDMA2INTEN_MASK_SHIFT(reg) (((reg) & PIE_COMMON_IENR_RDMA2INTEN_MASK) >> PIE_COMMON_IENR_RDMA2INTEN_SHIFT)
#define  PIE_COMMON_IENR_RDMA2INTEN_REPLACE_VAL(reg,val) (((reg) & ~PIE_COMMON_IENR_RDMA2INTEN_MASK) | (((uint32_t)val) << PIE_COMMON_IENR_RDMA2INTEN_SHIFT))

#define  PIE_COMMON_IENR_RDMA1INTEN_MASK 0x2
#define  PIE_COMMON_IENR_RDMA1INTEN_SHIFT 1
#define  PIE_COMMON_IENR_RDMA1INTEN_MASK_SHIFT(reg) (((reg) & PIE_COMMON_IENR_RDMA1INTEN_MASK) >> PIE_COMMON_IENR_RDMA1INTEN_SHIFT)
#define  PIE_COMMON_IENR_RDMA1INTEN_REPLACE_VAL(reg,val) (((reg) & ~PIE_COMMON_IENR_RDMA1INTEN_MASK) | (((uint32_t)val) << PIE_COMMON_IENR_RDMA1INTEN_SHIFT))

#define  PIE_COMMON_IENR_RDMA0INTEN_MASK 0x1
#define  PIE_COMMON_IENR_RDMA0INTEN_SHIFT 0
#define  PIE_COMMON_IENR_RDMA0INTEN_MASK_SHIFT(reg) (((reg) & PIE_COMMON_IENR_RDMA0INTEN_MASK) >> PIE_COMMON_IENR_RDMA0INTEN_SHIFT)
#define  PIE_COMMON_IENR_RDMA0INTEN_REPLACE_VAL(reg,val) (((reg) & ~PIE_COMMON_IENR_RDMA0INTEN_MASK) | (((uint32_t)val) << PIE_COMMON_IENR_RDMA0INTEN_SHIFT))

//====================================================================
//Register: Interrupt Pending Register (IPR)
/** \brief When a PIE interrupt is detected by the CPU, this register should be read to determine
        which DMA channel(s) originated the interrupt. In order to clear the interrupts
        indicated in this register, the corresponding DMA channel's pending interrupt must be
        cleared. See the appropriate DMA block's documentation to determine how to do this.*/
//====================================================================

#define  PIE_COMMON_IPR_RESERVED1_MASK 0xfe000000
#define  PIE_COMMON_IPR_RESERVED1_SHIFT 25
#define  PIE_COMMON_IPR_RESERVED1_MASK_SHIFT(reg) (((reg) & PIE_COMMON_IPR_RESERVED1_MASK) >> PIE_COMMON_IPR_RESERVED1_SHIFT)
#define  PIE_COMMON_IPR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PIE_COMMON_IPR_RESERVED1_MASK) | (((uint32_t)val) << PIE_COMMON_IPR_RESERVED1_SHIFT))

#define  PIE_COMMON_IPR_RDMA_GROUPINTPEND_MASK 0x1000000
#define  PIE_COMMON_IPR_RDMA_GROUPINTPEND_SHIFT 24
#define  PIE_COMMON_IPR_RDMA_GROUPINTPEND_MASK_SHIFT(reg) (((reg) & PIE_COMMON_IPR_RDMA_GROUPINTPEND_MASK) >> PIE_COMMON_IPR_RDMA_GROUPINTPEND_SHIFT)
#define  PIE_COMMON_IPR_RDMA_GROUPINTPEND_REPLACE_VAL(reg,val) (((reg) & ~PIE_COMMON_IPR_RDMA_GROUPINTPEND_MASK) | (((uint32_t)val) << PIE_COMMON_IPR_RDMA_GROUPINTPEND_SHIFT))

#define  PIE_COMMON_IPR_DDMA_DATA_GROUPINTPEND_MASK 0x800000
#define  PIE_COMMON_IPR_DDMA_DATA_GROUPINTPEND_SHIFT 23
#define  PIE_COMMON_IPR_DDMA_DATA_GROUPINTPEND_MASK_SHIFT(reg) (((reg) & PIE_COMMON_IPR_DDMA_DATA_GROUPINTPEND_MASK) >> PIE_COMMON_IPR_DDMA_DATA_GROUPINTPEND_SHIFT)
#define  PIE_COMMON_IPR_DDMA_DATA_GROUPINTPEND_REPLACE_VAL(reg,val) (((reg) & ~PIE_COMMON_IPR_DDMA_DATA_GROUPINTPEND_MASK) | (((uint32_t)val) << PIE_COMMON_IPR_DDMA_DATA_GROUPINTPEND_SHIFT))

#define  PIE_COMMON_IPR_DDMA_CORR_GROUPINTPEND_MASK 0x400000
#define  PIE_COMMON_IPR_DDMA_CORR_GROUPINTPEND_SHIFT 22
#define  PIE_COMMON_IPR_DDMA_CORR_GROUPINTPEND_MASK_SHIFT(reg) (((reg) & PIE_COMMON_IPR_DDMA_CORR_GROUPINTPEND_MASK) >> PIE_COMMON_IPR_DDMA_CORR_GROUPINTPEND_SHIFT)
#define  PIE_COMMON_IPR_DDMA_CORR_GROUPINTPEND_REPLACE_VAL(reg,val) (((reg) & ~PIE_COMMON_IPR_DDMA_CORR_GROUPINTPEND_MASK) | (((uint32_t)val) << PIE_COMMON_IPR_DDMA_CORR_GROUPINTPEND_SHIFT))

#define  PIE_COMMON_IPR_DISTORTINTPEND_MASK 0x200000
#define  PIE_COMMON_IPR_DISTORTINTPEND_SHIFT 21
#define  PIE_COMMON_IPR_DISTORTINTPEND_MASK_SHIFT(reg) (((reg) & PIE_COMMON_IPR_DISTORTINTPEND_MASK) >> PIE_COMMON_IPR_DISTORTINTPEND_SHIFT)
#define  PIE_COMMON_IPR_DISTORTINTPEND_REPLACE_VAL(reg,val) (((reg) & ~PIE_COMMON_IPR_DISTORTINTPEND_MASK) | (((uint32_t)val) << PIE_COMMON_IPR_DISTORTINTPEND_SHIFT))

#define  PIE_COMMON_IPR_IHI16X8SHORTINTPEND_MASK 0x100000
#define  PIE_COMMON_IPR_IHI16X8SHORTINTPEND_SHIFT 20
#define  PIE_COMMON_IPR_IHI16X8SHORTINTPEND_MASK_SHIFT(reg) (((reg) & PIE_COMMON_IPR_IHI16X8SHORTINTPEND_MASK) >> PIE_COMMON_IPR_IHI16X8SHORTINTPEND_SHIFT)
#define  PIE_COMMON_IPR_IHI16X8SHORTINTPEND_REPLACE_VAL(reg,val) (((reg) & ~PIE_COMMON_IPR_IHI16X8SHORTINTPEND_MASK) | (((uint32_t)val) << PIE_COMMON_IPR_IHI16X8SHORTINTPEND_SHIFT))

#define  PIE_COMMON_IPR_IHI16X8TALLINTPEND_MASK 0x80000
#define  PIE_COMMON_IPR_IHI16X8TALLINTPEND_SHIFT 19
#define  PIE_COMMON_IPR_IHI16X8TALLINTPEND_MASK_SHIFT(reg) (((reg) & PIE_COMMON_IPR_IHI16X8TALLINTPEND_MASK) >> PIE_COMMON_IPR_IHI16X8TALLINTPEND_SHIFT)
#define  PIE_COMMON_IPR_IHI16X8TALLINTPEND_REPLACE_VAL(reg,val) (((reg) & ~PIE_COMMON_IPR_IHI16X8TALLINTPEND_MASK) | (((uint32_t)val) << PIE_COMMON_IPR_IHI16X8TALLINTPEND_SHIFT))

#define  PIE_COMMON_IPR_IHI3X3SHORTINTPEND_MASK 0x40000
#define  PIE_COMMON_IPR_IHI3X3SHORTINTPEND_SHIFT 18
#define  PIE_COMMON_IPR_IHI3X3SHORTINTPEND_MASK_SHIFT(reg) (((reg) & PIE_COMMON_IPR_IHI3X3SHORTINTPEND_MASK) >> PIE_COMMON_IPR_IHI3X3SHORTINTPEND_SHIFT)
#define  PIE_COMMON_IPR_IHI3X3SHORTINTPEND_REPLACE_VAL(reg,val) (((reg) & ~PIE_COMMON_IPR_IHI3X3SHORTINTPEND_MASK) | (((uint32_t)val) << PIE_COMMON_IPR_IHI3X3SHORTINTPEND_SHIFT))

#define  PIE_COMMON_IPR_IHI3X3TALLINTPEND_MASK 0x20000
#define  PIE_COMMON_IPR_IHI3X3TALLINTPEND_SHIFT 17
#define  PIE_COMMON_IPR_IHI3X3TALLINTPEND_MASK_SHIFT(reg) (((reg) & PIE_COMMON_IPR_IHI3X3TALLINTPEND_MASK) >> PIE_COMMON_IPR_IHI3X3TALLINTPEND_SHIFT)
#define  PIE_COMMON_IPR_IHI3X3TALLINTPEND_REPLACE_VAL(reg,val) (((reg) & ~PIE_COMMON_IPR_IHI3X3TALLINTPEND_MASK) | (((uint32_t)val) << PIE_COMMON_IPR_IHI3X3TALLINTPEND_SHIFT))

#define  PIE_COMMON_IPR_PACKMONO_WDMAINTPEND_MASK 0x10000
#define  PIE_COMMON_IPR_PACKMONO_WDMAINTPEND_SHIFT 16
#define  PIE_COMMON_IPR_PACKMONO_WDMAINTPEND_MASK_SHIFT(reg) (((reg) & PIE_COMMON_IPR_PACKMONO_WDMAINTPEND_MASK) >> PIE_COMMON_IPR_PACKMONO_WDMAINTPEND_SHIFT)
#define  PIE_COMMON_IPR_PACKMONO_WDMAINTPEND_REPLACE_VAL(reg,val) (((reg) & ~PIE_COMMON_IPR_PACKMONO_WDMAINTPEND_MASK) | (((uint32_t)val) << PIE_COMMON_IPR_PACKMONO_WDMAINTPEND_SHIFT))

#define  PIE_COMMON_IPR_DIS_MAPINTPEND_MASK 0x8000
#define  PIE_COMMON_IPR_DIS_MAPINTPEND_SHIFT 15
#define  PIE_COMMON_IPR_DIS_MAPINTPEND_MASK_SHIFT(reg) (((reg) & PIE_COMMON_IPR_DIS_MAPINTPEND_MASK) >> PIE_COMMON_IPR_DIS_MAPINTPEND_SHIFT)
#define  PIE_COMMON_IPR_DIS_MAPINTPEND_REPLACE_VAL(reg,val) (((reg) & ~PIE_COMMON_IPR_DIS_MAPINTPEND_MASK) | (((uint32_t)val) << PIE_COMMON_IPR_DIS_MAPINTPEND_SHIFT))

#define  PIE_COMMON_IPR_AC_CORR_RDMA2INTPEND_MASK 0x4000
#define  PIE_COMMON_IPR_AC_CORR_RDMA2INTPEND_SHIFT 14
#define  PIE_COMMON_IPR_AC_CORR_RDMA2INTPEND_MASK_SHIFT(reg) (((reg) & PIE_COMMON_IPR_AC_CORR_RDMA2INTPEND_MASK) >> PIE_COMMON_IPR_AC_CORR_RDMA2INTPEND_SHIFT)
#define  PIE_COMMON_IPR_AC_CORR_RDMA2INTPEND_REPLACE_VAL(reg,val) (((reg) & ~PIE_COMMON_IPR_AC_CORR_RDMA2INTPEND_MASK) | (((uint32_t)val) << PIE_COMMON_IPR_AC_CORR_RDMA2INTPEND_SHIFT))

#define  PIE_COMMON_IPR_AC_CORR_RDMA1INTPEND_MASK 0x2000
#define  PIE_COMMON_IPR_AC_CORR_RDMA1INTPEND_SHIFT 13
#define  PIE_COMMON_IPR_AC_CORR_RDMA1INTPEND_MASK_SHIFT(reg) (((reg) & PIE_COMMON_IPR_AC_CORR_RDMA1INTPEND_MASK) >> PIE_COMMON_IPR_AC_CORR_RDMA1INTPEND_SHIFT)
#define  PIE_COMMON_IPR_AC_CORR_RDMA1INTPEND_REPLACE_VAL(reg,val) (((reg) & ~PIE_COMMON_IPR_AC_CORR_RDMA1INTPEND_MASK) | (((uint32_t)val) << PIE_COMMON_IPR_AC_CORR_RDMA1INTPEND_SHIFT))

#define  PIE_COMMON_IPR_AC_CORR_RDMA0INTPEND_MASK 0x1000
#define  PIE_COMMON_IPR_AC_CORR_RDMA0INTPEND_SHIFT 12
#define  PIE_COMMON_IPR_AC_CORR_RDMA0INTPEND_MASK_SHIFT(reg) (((reg) & PIE_COMMON_IPR_AC_CORR_RDMA0INTPEND_MASK) >> PIE_COMMON_IPR_AC_CORR_RDMA0INTPEND_SHIFT)
#define  PIE_COMMON_IPR_AC_CORR_RDMA0INTPEND_REPLACE_VAL(reg,val) (((reg) & ~PIE_COMMON_IPR_AC_CORR_RDMA0INTPEND_MASK) | (((uint32_t)val) << PIE_COMMON_IPR_AC_CORR_RDMA0INTPEND_SHIFT))

#define  PIE_COMMON_IPR_AC_DATA_RDMA2INTPEND_MASK 0x800
#define  PIE_COMMON_IPR_AC_DATA_RDMA2INTPEND_SHIFT 11
#define  PIE_COMMON_IPR_AC_DATA_RDMA2INTPEND_MASK_SHIFT(reg) (((reg) & PIE_COMMON_IPR_AC_DATA_RDMA2INTPEND_MASK) >> PIE_COMMON_IPR_AC_DATA_RDMA2INTPEND_SHIFT)
#define  PIE_COMMON_IPR_AC_DATA_RDMA2INTPEND_REPLACE_VAL(reg,val) (((reg) & ~PIE_COMMON_IPR_AC_DATA_RDMA2INTPEND_MASK) | (((uint32_t)val) << PIE_COMMON_IPR_AC_DATA_RDMA2INTPEND_SHIFT))

#define  PIE_COMMON_IPR_AC_DATA_RDMA1INTPEND_MASK 0x400
#define  PIE_COMMON_IPR_AC_DATA_RDMA1INTPEND_SHIFT 10
#define  PIE_COMMON_IPR_AC_DATA_RDMA1INTPEND_MASK_SHIFT(reg) (((reg) & PIE_COMMON_IPR_AC_DATA_RDMA1INTPEND_MASK) >> PIE_COMMON_IPR_AC_DATA_RDMA1INTPEND_SHIFT)
#define  PIE_COMMON_IPR_AC_DATA_RDMA1INTPEND_REPLACE_VAL(reg,val) (((reg) & ~PIE_COMMON_IPR_AC_DATA_RDMA1INTPEND_MASK) | (((uint32_t)val) << PIE_COMMON_IPR_AC_DATA_RDMA1INTPEND_SHIFT))

#define  PIE_COMMON_IPR_AC_DATA_RDMA0INTPEND_MASK 0x200
#define  PIE_COMMON_IPR_AC_DATA_RDMA0INTPEND_SHIFT 9
#define  PIE_COMMON_IPR_AC_DATA_RDMA0INTPEND_MASK_SHIFT(reg) (((reg) & PIE_COMMON_IPR_AC_DATA_RDMA0INTPEND_MASK) >> PIE_COMMON_IPR_AC_DATA_RDMA0INTPEND_SHIFT)
#define  PIE_COMMON_IPR_AC_DATA_RDMA0INTPEND_REPLACE_VAL(reg,val) (((reg) & ~PIE_COMMON_IPR_AC_DATA_RDMA0INTPEND_MASK) | (((uint32_t)val) << PIE_COMMON_IPR_AC_DATA_RDMA0INTPEND_SHIFT))

#define  PIE_COMMON_IPR_DSMFSHORTINTPEND_MASK 0x100
#define  PIE_COMMON_IPR_DSMFSHORTINTPEND_SHIFT 8
#define  PIE_COMMON_IPR_DSMFSHORTINTPEND_MASK_SHIFT(reg) (((reg) & PIE_COMMON_IPR_DSMFSHORTINTPEND_MASK) >> PIE_COMMON_IPR_DSMFSHORTINTPEND_SHIFT)
#define  PIE_COMMON_IPR_DSMFSHORTINTPEND_REPLACE_VAL(reg,val) (((reg) & ~PIE_COMMON_IPR_DSMFSHORTINTPEND_MASK) | (((uint32_t)val) << PIE_COMMON_IPR_DSMFSHORTINTPEND_SHIFT))

#define  PIE_COMMON_IPR_DSMFTALLINTPEND_MASK 0x80
#define  PIE_COMMON_IPR_DSMFTALLINTPEND_SHIFT 7
#define  PIE_COMMON_IPR_DSMFTALLINTPEND_MASK_SHIFT(reg) (((reg) & PIE_COMMON_IPR_DSMFTALLINTPEND_MASK) >> PIE_COMMON_IPR_DSMFTALLINTPEND_SHIFT)
#define  PIE_COMMON_IPR_DSMFTALLINTPEND_REPLACE_VAL(reg,val) (((reg) & ~PIE_COMMON_IPR_DSMFTALLINTPEND_MASK) | (((uint32_t)val) << PIE_COMMON_IPR_DSMFTALLINTPEND_SHIFT))

#define  PIE_COMMON_IPR_OTMARBINTPEND_MASK 0x40
#define  PIE_COMMON_IPR_OTMARBINTPEND_SHIFT 6
#define  PIE_COMMON_IPR_OTMARBINTPEND_MASK_SHIFT(reg) (((reg) & PIE_COMMON_IPR_OTMARBINTPEND_MASK) >> PIE_COMMON_IPR_OTMARBINTPEND_SHIFT)
#define  PIE_COMMON_IPR_OTMARBINTPEND_REPLACE_VAL(reg,val) (((reg) & ~PIE_COMMON_IPR_OTMARBINTPEND_MASK) | (((uint32_t)val) << PIE_COMMON_IPR_OTMARBINTPEND_SHIFT))

#define  PIE_COMMON_IPR_OT_WDMAINTPEND_MASK 0x20
#define  PIE_COMMON_IPR_OT_WDMAINTPEND_SHIFT 5
#define  PIE_COMMON_IPR_OT_WDMAINTPEND_MASK_SHIFT(reg) (((reg) & PIE_COMMON_IPR_OT_WDMAINTPEND_MASK) >> PIE_COMMON_IPR_OT_WDMAINTPEND_SHIFT)
#define  PIE_COMMON_IPR_OT_WDMAINTPEND_REPLACE_VAL(reg,val) (((reg) & ~PIE_COMMON_IPR_OT_WDMAINTPEND_MASK) | (((uint32_t)val) << PIE_COMMON_IPR_OT_WDMAINTPEND_SHIFT))

#define  PIE_COMMON_IPR_WDMAINTPEND_MASK 0x10
#define  PIE_COMMON_IPR_WDMAINTPEND_SHIFT 4
#define  PIE_COMMON_IPR_WDMAINTPEND_MASK_SHIFT(reg) (((reg) & PIE_COMMON_IPR_WDMAINTPEND_MASK) >> PIE_COMMON_IPR_WDMAINTPEND_SHIFT)
#define  PIE_COMMON_IPR_WDMAINTPEND_REPLACE_VAL(reg,val) (((reg) & ~PIE_COMMON_IPR_WDMAINTPEND_MASK) | (((uint32_t)val) << PIE_COMMON_IPR_WDMAINTPEND_SHIFT))

#define  PIE_COMMON_IPR_OT_RDMAINTPEND_MASK 0x8
#define  PIE_COMMON_IPR_OT_RDMAINTPEND_SHIFT 3
#define  PIE_COMMON_IPR_OT_RDMAINTPEND_MASK_SHIFT(reg) (((reg) & PIE_COMMON_IPR_OT_RDMAINTPEND_MASK) >> PIE_COMMON_IPR_OT_RDMAINTPEND_SHIFT)
#define  PIE_COMMON_IPR_OT_RDMAINTPEND_REPLACE_VAL(reg,val) (((reg) & ~PIE_COMMON_IPR_OT_RDMAINTPEND_MASK) | (((uint32_t)val) << PIE_COMMON_IPR_OT_RDMAINTPEND_SHIFT))

#define  PIE_COMMON_IPR_RDMA2INTPEND_MASK 0x4
#define  PIE_COMMON_IPR_RDMA2INTPEND_SHIFT 2
#define  PIE_COMMON_IPR_RDMA2INTPEND_MASK_SHIFT(reg) (((reg) & PIE_COMMON_IPR_RDMA2INTPEND_MASK) >> PIE_COMMON_IPR_RDMA2INTPEND_SHIFT)
#define  PIE_COMMON_IPR_RDMA2INTPEND_REPLACE_VAL(reg,val) (((reg) & ~PIE_COMMON_IPR_RDMA2INTPEND_MASK) | (((uint32_t)val) << PIE_COMMON_IPR_RDMA2INTPEND_SHIFT))

#define  PIE_COMMON_IPR_RDMA1INTPEND_MASK 0x2
#define  PIE_COMMON_IPR_RDMA1INTPEND_SHIFT 1
#define  PIE_COMMON_IPR_RDMA1INTPEND_MASK_SHIFT(reg) (((reg) & PIE_COMMON_IPR_RDMA1INTPEND_MASK) >> PIE_COMMON_IPR_RDMA1INTPEND_SHIFT)
#define  PIE_COMMON_IPR_RDMA1INTPEND_REPLACE_VAL(reg,val) (((reg) & ~PIE_COMMON_IPR_RDMA1INTPEND_MASK) | (((uint32_t)val) << PIE_COMMON_IPR_RDMA1INTPEND_SHIFT))

#define  PIE_COMMON_IPR_RDMA0INTPEND_MASK 0x1
#define  PIE_COMMON_IPR_RDMA0INTPEND_SHIFT 0
#define  PIE_COMMON_IPR_RDMA0INTPEND_MASK_SHIFT(reg) (((reg) & PIE_COMMON_IPR_RDMA0INTPEND_MASK) >> PIE_COMMON_IPR_RDMA0INTPEND_SHIFT)
#define  PIE_COMMON_IPR_RDMA0INTPEND_REPLACE_VAL(reg,val) (((reg) & ~PIE_COMMON_IPR_RDMA0INTPEND_MASK) | (((uint32_t)val) << PIE_COMMON_IPR_RDMA0INTPEND_SHIFT))

//====================================================================
//Register: Common Block Interface Register (CBIR)
/** \brief This register is used to change different PIE level control settings*/
//====================================================================

#define  PIE_COMMON_CBIR_RESERVED1_MASK 0xfffffffe
#define  PIE_COMMON_CBIR_RESERVED1_SHIFT 1
#define  PIE_COMMON_CBIR_RESERVED1_MASK_SHIFT(reg) (((reg) & PIE_COMMON_CBIR_RESERVED1_MASK) >> PIE_COMMON_CBIR_RESERVED1_SHIFT)
#define  PIE_COMMON_CBIR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PIE_COMMON_CBIR_RESERVED1_MASK) | (((uint32_t)val) << PIE_COMMON_CBIR_RESERVED1_SHIFT))

#define  PIE_COMMON_CBIR_SOFTRESET_MASK 0x1
#define  PIE_COMMON_CBIR_SOFTRESET_SHIFT 0
#define  PIE_COMMON_CBIR_SOFTRESET_MASK_SHIFT(reg) (((reg) & PIE_COMMON_CBIR_SOFTRESET_MASK) >> PIE_COMMON_CBIR_SOFTRESET_SHIFT)
#define  PIE_COMMON_CBIR_SOFTRESET_REPLACE_VAL(reg,val) (((reg) & ~PIE_COMMON_CBIR_SOFTRESET_MASK) | (((uint32_t)val) << PIE_COMMON_CBIR_SOFTRESET_SHIFT))

//====================================================================
//Register: PIE Control Register (CTL)
/** \brief This register is used to change different PIE level control settings*/
//====================================================================

#define  PIE_COMMON_CTL_RESERVED1_MASK 0xffffe000
#define  PIE_COMMON_CTL_RESERVED1_SHIFT 13
#define  PIE_COMMON_CTL_RESERVED1_MASK_SHIFT(reg) (((reg) & PIE_COMMON_CTL_RESERVED1_MASK) >> PIE_COMMON_CTL_RESERVED1_SHIFT)
#define  PIE_COMMON_CTL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PIE_COMMON_CTL_RESERVED1_MASK) | (((uint32_t)val) << PIE_COMMON_CTL_RESERVED1_SHIFT))

#define  PIE_COMMON_CTL_IMAGE_RDY_BYP_MASK 0x1000
#define  PIE_COMMON_CTL_IMAGE_RDY_BYP_SHIFT 12
#define  PIE_COMMON_CTL_IMAGE_RDY_BYP_MASK_SHIFT(reg) (((reg) & PIE_COMMON_CTL_IMAGE_RDY_BYP_MASK) >> PIE_COMMON_CTL_IMAGE_RDY_BYP_SHIFT)
#define  PIE_COMMON_CTL_IMAGE_RDY_BYP_REPLACE_VAL(reg,val) (((reg) & ~PIE_COMMON_CTL_IMAGE_RDY_BYP_MASK) | (((uint32_t)val) << PIE_COMMON_CTL_IMAGE_RDY_BYP_SHIFT))

#define  PIE_COMMON_CTL_OT_RDY_BYP_MASK 0x800
#define  PIE_COMMON_CTL_OT_RDY_BYP_SHIFT 11
#define  PIE_COMMON_CTL_OT_RDY_BYP_MASK_SHIFT(reg) (((reg) & PIE_COMMON_CTL_OT_RDY_BYP_MASK) >> PIE_COMMON_CTL_OT_RDY_BYP_SHIFT)
#define  PIE_COMMON_CTL_OT_RDY_BYP_REPLACE_VAL(reg,val) (((reg) & ~PIE_COMMON_CTL_OT_RDY_BYP_MASK) | (((uint32_t)val) << PIE_COMMON_CTL_OT_RDY_BYP_SHIFT))

#define  PIE_COMMON_CTL_DB_DEBUG_SEL_MASK 0x700
#define  PIE_COMMON_CTL_DB_DEBUG_SEL_SHIFT 8
#define  PIE_COMMON_CTL_DB_DEBUG_SEL_MASK_SHIFT(reg) (((reg) & PIE_COMMON_CTL_DB_DEBUG_SEL_MASK) >> PIE_COMMON_CTL_DB_DEBUG_SEL_SHIFT)
#define  PIE_COMMON_CTL_DB_DEBUG_SEL_REPLACE_VAL(reg,val) (((reg) & ~PIE_COMMON_CTL_DB_DEBUG_SEL_MASK) | (((uint32_t)val) << PIE_COMMON_CTL_DB_DEBUG_SEL_SHIFT))

#define  PIE_COMMON_CTL_DIS_MAP_POGO_EN_MASK 0x80
#define  PIE_COMMON_CTL_DIS_MAP_POGO_EN_SHIFT 7
#define  PIE_COMMON_CTL_DIS_MAP_POGO_EN_MASK_SHIFT(reg) (((reg) & PIE_COMMON_CTL_DIS_MAP_POGO_EN_MASK) >> PIE_COMMON_CTL_DIS_MAP_POGO_EN_SHIFT)
#define  PIE_COMMON_CTL_DIS_MAP_POGO_EN_REPLACE_VAL(reg,val) (((reg) & ~PIE_COMMON_CTL_DIS_MAP_POGO_EN_MASK) | (((uint32_t)val) << PIE_COMMON_CTL_DIS_MAP_POGO_EN_SHIFT))

#define  PIE_COMMON_CTL_RESERVED2_MASK 0x40
#define  PIE_COMMON_CTL_RESERVED2_SHIFT 6
#define  PIE_COMMON_CTL_RESERVED2_MASK_SHIFT(reg) (((reg) & PIE_COMMON_CTL_RESERVED2_MASK) >> PIE_COMMON_CTL_RESERVED2_SHIFT)
#define  PIE_COMMON_CTL_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~PIE_COMMON_CTL_RESERVED2_MASK) | (((uint32_t)val) << PIE_COMMON_CTL_RESERVED2_SHIFT))

#define  PIE_COMMON_CTL_DISTORT_DMA_EN_MASK 0x20
#define  PIE_COMMON_CTL_DISTORT_DMA_EN_SHIFT 5
#define  PIE_COMMON_CTL_DISTORT_DMA_EN_MASK_SHIFT(reg) (((reg) & PIE_COMMON_CTL_DISTORT_DMA_EN_MASK) >> PIE_COMMON_CTL_DISTORT_DMA_EN_SHIFT)
#define  PIE_COMMON_CTL_DISTORT_DMA_EN_REPLACE_VAL(reg,val) (((reg) & ~PIE_COMMON_CTL_DISTORT_DMA_EN_MASK) | (((uint32_t)val) << PIE_COMMON_CTL_DISTORT_DMA_EN_SHIFT))

#define  PIE_COMMON_CTL_RESERVE_MODE_EN_MASK 0x10
#define  PIE_COMMON_CTL_RESERVE_MODE_EN_SHIFT 4
#define  PIE_COMMON_CTL_RESERVE_MODE_EN_MASK_SHIFT(reg) (((reg) & PIE_COMMON_CTL_RESERVE_MODE_EN_MASK) >> PIE_COMMON_CTL_RESERVE_MODE_EN_SHIFT)
#define  PIE_COMMON_CTL_RESERVE_MODE_EN_REPLACE_VAL(reg,val) (((reg) & ~PIE_COMMON_CTL_RESERVE_MODE_EN_MASK) | (((uint32_t)val) << PIE_COMMON_CTL_RESERVE_MODE_EN_SHIFT))

#define  PIE_COMMON_CTL_RESERVED3_MASK 0x8
#define  PIE_COMMON_CTL_RESERVED3_SHIFT 3
#define  PIE_COMMON_CTL_RESERVED3_MASK_SHIFT(reg) (((reg) & PIE_COMMON_CTL_RESERVED3_MASK) >> PIE_COMMON_CTL_RESERVED3_SHIFT)
#define  PIE_COMMON_CTL_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~PIE_COMMON_CTL_RESERVED3_MASK) | (((uint32_t)val) << PIE_COMMON_CTL_RESERVED3_SHIFT))

#define  PIE_COMMON_CTL_PIPEORDER_CONFIG_MASK 0x7
#define  PIE_COMMON_CTL_PIPEORDER_CONFIG_SHIFT 0
#define  PIE_COMMON_CTL_PIPEORDER_CONFIG_MASK_SHIFT(reg) (((reg) & PIE_COMMON_CTL_PIPEORDER_CONFIG_MASK) >> PIE_COMMON_CTL_PIPEORDER_CONFIG_SHIFT)
#define  PIE_COMMON_CTL_PIPEORDER_CONFIG_REPLACE_VAL(reg,val) (((reg) & ~PIE_COMMON_CTL_PIPEORDER_CONFIG_MASK) | (((uint32_t)val) << PIE_COMMON_CTL_PIPEORDER_CONFIG_SHIFT))

//====================================================================
//Register: DEBUG Bus Observation (DBG)
/** \brief Read only observation of db_debug_bus, 32 bit selection via db_debug_sel field.*/
//====================================================================

#define  PIE_COMMON_DBG_PIE_COMMON_DEBUG_MASK 0xffffffff
#define  PIE_COMMON_DBG_PIE_COMMON_DEBUG_SHIFT 0
#define  PIE_COMMON_DBG_PIE_COMMON_DEBUG_MASK_SHIFT(reg) (((reg) & PIE_COMMON_DBG_PIE_COMMON_DEBUG_MASK) >> PIE_COMMON_DBG_PIE_COMMON_DEBUG_SHIFT)
#define  PIE_COMMON_DBG_PIE_COMMON_DEBUG_REPLACE_VAL(reg,val) (((reg) & ~PIE_COMMON_DBG_PIE_COMMON_DEBUG_MASK) | (((uint32_t)val) << PIE_COMMON_DBG_PIE_COMMON_DEBUG_SHIFT))

//====================================================================
//Register: IP Tagging Revision 0 (REV0)
/** \brief Provide means for firmware to read IP tagging information.
      This register of particular interest to firmware.*/
//====================================================================

#define  PIE_COMMON_REV0_MAJ_MASK 0xffff0000
#define  PIE_COMMON_REV0_MAJ_SHIFT 16
#define  PIE_COMMON_REV0_MAJ_MASK_SHIFT(reg) (((reg) & PIE_COMMON_REV0_MAJ_MASK) >> PIE_COMMON_REV0_MAJ_SHIFT)
#define  PIE_COMMON_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~PIE_COMMON_REV0_MAJ_MASK) | (((uint32_t)val) << PIE_COMMON_REV0_MAJ_SHIFT))

#define  PIE_COMMON_REV0_MID_MASK 0xffff
#define  PIE_COMMON_REV0_MID_SHIFT 0
#define  PIE_COMMON_REV0_MID_MASK_SHIFT(reg) (((reg) & PIE_COMMON_REV0_MID_MASK) >> PIE_COMMON_REV0_MID_SHIFT)
#define  PIE_COMMON_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~PIE_COMMON_REV0_MID_MASK) | (((uint32_t)val) << PIE_COMMON_REV0_MID_SHIFT))

//====================================================================
//Register: IP Tagging Revision 1 (REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  PIE_COMMON_REV1_RESERVED1_MASK 0xffff0000
#define  PIE_COMMON_REV1_RESERVED1_SHIFT 16
#define  PIE_COMMON_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & PIE_COMMON_REV1_RESERVED1_MASK) >> PIE_COMMON_REV1_RESERVED1_SHIFT)
#define  PIE_COMMON_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PIE_COMMON_REV1_RESERVED1_MASK) | (((uint32_t)val) << PIE_COMMON_REV1_RESERVED1_SHIFT))

#define  PIE_COMMON_REV1_CFG_MASK 0xffff
#define  PIE_COMMON_REV1_CFG_SHIFT 0
#define  PIE_COMMON_REV1_CFG_MASK_SHIFT(reg) (((reg) & PIE_COMMON_REV1_CFG_MASK) >> PIE_COMMON_REV1_CFG_SHIFT)
#define  PIE_COMMON_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~PIE_COMMON_REV1_CFG_MASK) | (((uint32_t)val) << PIE_COMMON_REV1_CFG_SHIFT))

//====================================================================
//
//Register File: PIE POGO Input DMA (Instance 1 of 3) (POGO_IDMA0)
//
//====================================================================

//====================================================================
//
//Register File: PIE POGO Input DMA (Instance 2 of 3) (POGO_IDMA1)
//
//====================================================================

//====================================================================
//
//Register File: PIE POGO Input DMA (Instance 3 of 3) (POGO_IDMA2)
//
//====================================================================

//====================================================================
//
//Register File: PIE POGOIZER (POGOIZER)
/** \brief (rev 0 . 6 . 3 . 0)
    These registers provide the means to program the characteristics of the desired
    pogoizing operation.*/
//
//====================================================================

//====================================================================
//Register: Pogoizer Configuration Register (Cfg)
/** \brief The fields in this register are used to configure the characteristics of the desired
      pogoizing operation.*/
//====================================================================

#define  POGOIZER_CFG_RESERVED1_MASK 0xffffc000
#define  POGOIZER_CFG_RESERVED1_SHIFT 14
#define  POGOIZER_CFG_RESERVED1_MASK_SHIFT(reg) (((reg) & POGOIZER_CFG_RESERVED1_MASK) >> POGOIZER_CFG_RESERVED1_SHIFT)
#define  POGOIZER_CFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~POGOIZER_CFG_RESERVED1_MASK) | (((uint32_t)val) << POGOIZER_CFG_RESERVED1_SHIFT))

#define  POGOIZER_CFG_PIXORDER_MASK 0x2000
#define  POGOIZER_CFG_PIXORDER_SHIFT 13
#define  POGOIZER_CFG_PIXORDER_MASK_SHIFT(reg) (((reg) & POGOIZER_CFG_PIXORDER_MASK) >> POGOIZER_CFG_PIXORDER_SHIFT)
#define  POGOIZER_CFG_PIXORDER_REPLACE_VAL(reg,val) (((reg) & ~POGOIZER_CFG_PIXORDER_MASK) | (((uint32_t)val) << POGOIZER_CFG_PIXORDER_SHIFT))

#define  POGOIZER_CFG_RESERVED2_MASK 0x1000
#define  POGOIZER_CFG_RESERVED2_SHIFT 12
#define  POGOIZER_CFG_RESERVED2_MASK_SHIFT(reg) (((reg) & POGOIZER_CFG_RESERVED2_MASK) >> POGOIZER_CFG_RESERVED2_SHIFT)
#define  POGOIZER_CFG_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~POGOIZER_CFG_RESERVED2_MASK) | (((uint32_t)val) << POGOIZER_CFG_RESERVED2_SHIFT))

#define  POGOIZER_CFG_SCALEX_MASK 0xc00
#define  POGOIZER_CFG_SCALEX_SHIFT 10
#define  POGOIZER_CFG_SCALEX_MASK_SHIFT(reg) (((reg) & POGOIZER_CFG_SCALEX_MASK) >> POGOIZER_CFG_SCALEX_SHIFT)
#define  POGOIZER_CFG_SCALEX_REPLACE_VAL(reg,val) (((reg) & ~POGOIZER_CFG_SCALEX_MASK) | (((uint32_t)val) << POGOIZER_CFG_SCALEX_SHIFT))

#define  POGOIZER_CFG_SCALEY_MASK 0x300
#define  POGOIZER_CFG_SCALEY_SHIFT 8
#define  POGOIZER_CFG_SCALEY_MASK_SHIFT(reg) (((reg) & POGOIZER_CFG_SCALEY_MASK) >> POGOIZER_CFG_SCALEY_SHIFT)
#define  POGOIZER_CFG_SCALEY_REPLACE_VAL(reg,val) (((reg) & ~POGOIZER_CFG_SCALEY_MASK) | (((uint32_t)val) << POGOIZER_CFG_SCALEY_SHIFT))

#define  POGOIZER_CFG_RESERVED3_MASK 0x80
#define  POGOIZER_CFG_RESERVED3_SHIFT 7
#define  POGOIZER_CFG_RESERVED3_MASK_SHIFT(reg) (((reg) & POGOIZER_CFG_RESERVED3_MASK) >> POGOIZER_CFG_RESERVED3_SHIFT)
#define  POGOIZER_CFG_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~POGOIZER_CFG_RESERVED3_MASK) | (((uint32_t)val) << POGOIZER_CFG_RESERVED3_SHIFT))

#define  POGOIZER_CFG_BPP_MASK 0x70
#define  POGOIZER_CFG_BPP_SHIFT 4
#define  POGOIZER_CFG_BPP_MASK_SHIFT(reg) (((reg) & POGOIZER_CFG_BPP_MASK) >> POGOIZER_CFG_BPP_SHIFT)
#define  POGOIZER_CFG_BPP_REPLACE_VAL(reg,val) (((reg) & ~POGOIZER_CFG_BPP_MASK) | (((uint32_t)val) << POGOIZER_CFG_BPP_SHIFT))

#define  POGOIZER_CFG_COLORSWAP_MASK 0x8
#define  POGOIZER_CFG_COLORSWAP_SHIFT 3
#define  POGOIZER_CFG_COLORSWAP_MASK_SHIFT(reg) (((reg) & POGOIZER_CFG_COLORSWAP_MASK) >> POGOIZER_CFG_COLORSWAP_SHIFT)
#define  POGOIZER_CFG_COLORSWAP_REPLACE_VAL(reg,val) (((reg) & ~POGOIZER_CFG_COLORSWAP_MASK) | (((uint32_t)val) << POGOIZER_CFG_COLORSWAP_SHIFT))

#define  POGOIZER_CFG_FMT_MASK 0x7
#define  POGOIZER_CFG_FMT_SHIFT 0
#define  POGOIZER_CFG_FMT_MASK_SHIFT(reg) (((reg) & POGOIZER_CFG_FMT_MASK) >> POGOIZER_CFG_FMT_SHIFT)
#define  POGOIZER_CFG_FMT_REPLACE_VAL(reg,val) (((reg) & ~POGOIZER_CFG_FMT_MASK) | (((uint32_t)val) << POGOIZER_CFG_FMT_SHIFT))

//====================================================================
//Register: Left Side Padding Register (LPad)
/** \brief This register configures left side padding.*/
//====================================================================

#define  POGOIZER_LPAD_RESERVED1_MASK 0xfffe0000
#define  POGOIZER_LPAD_RESERVED1_SHIFT 17
#define  POGOIZER_LPAD_RESERVED1_MASK_SHIFT(reg) (((reg) & POGOIZER_LPAD_RESERVED1_MASK) >> POGOIZER_LPAD_RESERVED1_SHIFT)
#define  POGOIZER_LPAD_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~POGOIZER_LPAD_RESERVED1_MASK) | (((uint32_t)val) << POGOIZER_LPAD_RESERVED1_SHIFT))

#define  POGOIZER_LPAD_LEFTEDGEFILL_MASK 0x10000
#define  POGOIZER_LPAD_LEFTEDGEFILL_SHIFT 16
#define  POGOIZER_LPAD_LEFTEDGEFILL_MASK_SHIFT(reg) (((reg) & POGOIZER_LPAD_LEFTEDGEFILL_MASK) >> POGOIZER_LPAD_LEFTEDGEFILL_SHIFT)
#define  POGOIZER_LPAD_LEFTEDGEFILL_REPLACE_VAL(reg,val) (((reg) & ~POGOIZER_LPAD_LEFTEDGEFILL_MASK) | (((uint32_t)val) << POGOIZER_LPAD_LEFTEDGEFILL_SHIFT))

#define  POGOIZER_LPAD_LEFTLEN_MASK 0xffff
#define  POGOIZER_LPAD_LEFTLEN_SHIFT 0
#define  POGOIZER_LPAD_LEFTLEN_MASK_SHIFT(reg) (((reg) & POGOIZER_LPAD_LEFTLEN_MASK) >> POGOIZER_LPAD_LEFTLEN_SHIFT)
#define  POGOIZER_LPAD_LEFTLEN_REPLACE_VAL(reg,val) (((reg) & ~POGOIZER_LPAD_LEFTLEN_MASK) | (((uint32_t)val) << POGOIZER_LPAD_LEFTLEN_SHIFT))

//====================================================================
//Register: Right Side Padding Register (RPad)
/** \brief This register configures right side padding.*/
//====================================================================

#define  POGOIZER_RPAD_RESERVED1_MASK 0xfffe0000
#define  POGOIZER_RPAD_RESERVED1_SHIFT 17
#define  POGOIZER_RPAD_RESERVED1_MASK_SHIFT(reg) (((reg) & POGOIZER_RPAD_RESERVED1_MASK) >> POGOIZER_RPAD_RESERVED1_SHIFT)
#define  POGOIZER_RPAD_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~POGOIZER_RPAD_RESERVED1_MASK) | (((uint32_t)val) << POGOIZER_RPAD_RESERVED1_SHIFT))

#define  POGOIZER_RPAD_RIGHTEDGEFILL_MASK 0x10000
#define  POGOIZER_RPAD_RIGHTEDGEFILL_SHIFT 16
#define  POGOIZER_RPAD_RIGHTEDGEFILL_MASK_SHIFT(reg) (((reg) & POGOIZER_RPAD_RIGHTEDGEFILL_MASK) >> POGOIZER_RPAD_RIGHTEDGEFILL_SHIFT)
#define  POGOIZER_RPAD_RIGHTEDGEFILL_REPLACE_VAL(reg,val) (((reg) & ~POGOIZER_RPAD_RIGHTEDGEFILL_MASK) | (((uint32_t)val) << POGOIZER_RPAD_RIGHTEDGEFILL_SHIFT))

#define  POGOIZER_RPAD_RIGHTLEN_MASK 0xffff
#define  POGOIZER_RPAD_RIGHTLEN_SHIFT 0
#define  POGOIZER_RPAD_RIGHTLEN_MASK_SHIFT(reg) (((reg) & POGOIZER_RPAD_RIGHTLEN_MASK) >> POGOIZER_RPAD_RIGHTLEN_SHIFT)
#define  POGOIZER_RPAD_RIGHTLEN_REPLACE_VAL(reg,val) (((reg) & ~POGOIZER_RPAD_RIGHTLEN_MASK) | (((uint32_t)val) << POGOIZER_RPAD_RIGHTLEN_SHIFT))

//====================================================================
//Register: Left Side Padding Value Register (Instance 1 of 3) (LVal0)
/** \brief This register contains the pad value for the left side if leftEdgeFill is not set.
      There is one register per color. For RGB data, the R left pad value should be written
      to the 0th register in the array, the G value should be written to the 1st register,
      and the B value should be written to the 2nd register. For CMYK, the C value should
      written to the 0th register, the M value to the 1st register, and so forth. (Instance 1 of 3)*/
//====================================================================

#define  POGOIZER_LVAL0_RESERVED1_MASK 0xffff0000
#define  POGOIZER_LVAL0_RESERVED1_SHIFT 16
#define  POGOIZER_LVAL0_RESERVED1_MASK_SHIFT(reg) (((reg) & POGOIZER_LVAL0_RESERVED1_MASK) >> POGOIZER_LVAL0_RESERVED1_SHIFT)
#define  POGOIZER_LVAL0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~POGOIZER_LVAL0_RESERVED1_MASK) | (((uint32_t)val) << POGOIZER_LVAL0_RESERVED1_SHIFT))

#define  POGOIZER_LVAL0_LEFTVAL_MASK 0xffff
#define  POGOIZER_LVAL0_LEFTVAL_SHIFT 0
#define  POGOIZER_LVAL0_LEFTVAL_MASK_SHIFT(reg) (((reg) & POGOIZER_LVAL0_LEFTVAL_MASK) >> POGOIZER_LVAL0_LEFTVAL_SHIFT)
#define  POGOIZER_LVAL0_LEFTVAL_REPLACE_VAL(reg,val) (((reg) & ~POGOIZER_LVAL0_LEFTVAL_MASK) | (((uint32_t)val) << POGOIZER_LVAL0_LEFTVAL_SHIFT))

//====================================================================
//Register: Left Side Padding Value Register (Instance 2 of 3) (LVal1)
/** \brief This register contains the pad value for the left side if leftEdgeFill is not set.
      There is one register per color. For RGB data, the R left pad value should be written
      to the 0th register in the array, the G value should be written to the 1st register,
      and the B value should be written to the 2nd register. For CMYK, the C value should
      written to the 0th register, the M value to the 1st register, and so forth. (Instance 2 of 3)*/
//====================================================================

#define  POGOIZER_LVAL1_RESERVED1_MASK 0xffff0000
#define  POGOIZER_LVAL1_RESERVED1_SHIFT 16
#define  POGOIZER_LVAL1_RESERVED1_MASK_SHIFT(reg) (((reg) & POGOIZER_LVAL1_RESERVED1_MASK) >> POGOIZER_LVAL1_RESERVED1_SHIFT)
#define  POGOIZER_LVAL1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~POGOIZER_LVAL1_RESERVED1_MASK) | (((uint32_t)val) << POGOIZER_LVAL1_RESERVED1_SHIFT))

#define  POGOIZER_LVAL1_LEFTVAL_MASK 0xffff
#define  POGOIZER_LVAL1_LEFTVAL_SHIFT 0
#define  POGOIZER_LVAL1_LEFTVAL_MASK_SHIFT(reg) (((reg) & POGOIZER_LVAL1_LEFTVAL_MASK) >> POGOIZER_LVAL1_LEFTVAL_SHIFT)
#define  POGOIZER_LVAL1_LEFTVAL_REPLACE_VAL(reg,val) (((reg) & ~POGOIZER_LVAL1_LEFTVAL_MASK) | (((uint32_t)val) << POGOIZER_LVAL1_LEFTVAL_SHIFT))

//====================================================================
//Register: Left Side Padding Value Register (Instance 3 of 3) (LVal2)
/** \brief This register contains the pad value for the left side if leftEdgeFill is not set.
      There is one register per color. For RGB data, the R left pad value should be written
      to the 0th register in the array, the G value should be written to the 1st register,
      and the B value should be written to the 2nd register. For CMYK, the C value should
      written to the 0th register, the M value to the 1st register, and so forth. (Instance 3 of 3)*/
//====================================================================

#define  POGOIZER_LVAL2_RESERVED1_MASK 0xffff0000
#define  POGOIZER_LVAL2_RESERVED1_SHIFT 16
#define  POGOIZER_LVAL2_RESERVED1_MASK_SHIFT(reg) (((reg) & POGOIZER_LVAL2_RESERVED1_MASK) >> POGOIZER_LVAL2_RESERVED1_SHIFT)
#define  POGOIZER_LVAL2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~POGOIZER_LVAL2_RESERVED1_MASK) | (((uint32_t)val) << POGOIZER_LVAL2_RESERVED1_SHIFT))

#define  POGOIZER_LVAL2_LEFTVAL_MASK 0xffff
#define  POGOIZER_LVAL2_LEFTVAL_SHIFT 0
#define  POGOIZER_LVAL2_LEFTVAL_MASK_SHIFT(reg) (((reg) & POGOIZER_LVAL2_LEFTVAL_MASK) >> POGOIZER_LVAL2_LEFTVAL_SHIFT)
#define  POGOIZER_LVAL2_LEFTVAL_REPLACE_VAL(reg,val) (((reg) & ~POGOIZER_LVAL2_LEFTVAL_MASK) | (((uint32_t)val) << POGOIZER_LVAL2_LEFTVAL_SHIFT))

//====================================================================
//Register: Right Side Padding Value Register (Instance 1 of 3) (RVal0)
/** \brief This register contains the pad value for the right side if rightEdgeFill is not set.
      There is one register per color. For RGB data, the R right pad value should be written
      to the 0th register in the array, the G value should be written to the 1st register,
      and the B value should be written to the 2nd register. For CMYK, the C value should
      written to the 0th register, the M value to the 1st register, and so forth. (Instance 1 of 3)*/
//====================================================================

#define  POGOIZER_RVAL0_RESERVED1_MASK 0xffff0000
#define  POGOIZER_RVAL0_RESERVED1_SHIFT 16
#define  POGOIZER_RVAL0_RESERVED1_MASK_SHIFT(reg) (((reg) & POGOIZER_RVAL0_RESERVED1_MASK) >> POGOIZER_RVAL0_RESERVED1_SHIFT)
#define  POGOIZER_RVAL0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~POGOIZER_RVAL0_RESERVED1_MASK) | (((uint32_t)val) << POGOIZER_RVAL0_RESERVED1_SHIFT))

#define  POGOIZER_RVAL0_RIGHTVAL_MASK 0xffff
#define  POGOIZER_RVAL0_RIGHTVAL_SHIFT 0
#define  POGOIZER_RVAL0_RIGHTVAL_MASK_SHIFT(reg) (((reg) & POGOIZER_RVAL0_RIGHTVAL_MASK) >> POGOIZER_RVAL0_RIGHTVAL_SHIFT)
#define  POGOIZER_RVAL0_RIGHTVAL_REPLACE_VAL(reg,val) (((reg) & ~POGOIZER_RVAL0_RIGHTVAL_MASK) | (((uint32_t)val) << POGOIZER_RVAL0_RIGHTVAL_SHIFT))

//====================================================================
//Register: Right Side Padding Value Register (Instance 2 of 3) (RVal1)
/** \brief This register contains the pad value for the right side if rightEdgeFill is not set.
      There is one register per color. For RGB data, the R right pad value should be written
      to the 0th register in the array, the G value should be written to the 1st register,
      and the B value should be written to the 2nd register. For CMYK, the C value should
      written to the 0th register, the M value to the 1st register, and so forth. (Instance 2 of 3)*/
//====================================================================

#define  POGOIZER_RVAL1_RESERVED1_MASK 0xffff0000
#define  POGOIZER_RVAL1_RESERVED1_SHIFT 16
#define  POGOIZER_RVAL1_RESERVED1_MASK_SHIFT(reg) (((reg) & POGOIZER_RVAL1_RESERVED1_MASK) >> POGOIZER_RVAL1_RESERVED1_SHIFT)
#define  POGOIZER_RVAL1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~POGOIZER_RVAL1_RESERVED1_MASK) | (((uint32_t)val) << POGOIZER_RVAL1_RESERVED1_SHIFT))

#define  POGOIZER_RVAL1_RIGHTVAL_MASK 0xffff
#define  POGOIZER_RVAL1_RIGHTVAL_SHIFT 0
#define  POGOIZER_RVAL1_RIGHTVAL_MASK_SHIFT(reg) (((reg) & POGOIZER_RVAL1_RIGHTVAL_MASK) >> POGOIZER_RVAL1_RIGHTVAL_SHIFT)
#define  POGOIZER_RVAL1_RIGHTVAL_REPLACE_VAL(reg,val) (((reg) & ~POGOIZER_RVAL1_RIGHTVAL_MASK) | (((uint32_t)val) << POGOIZER_RVAL1_RIGHTVAL_SHIFT))

//====================================================================
//Register: Right Side Padding Value Register (Instance 3 of 3) (RVal2)
/** \brief This register contains the pad value for the right side if rightEdgeFill is not set.
      There is one register per color. For RGB data, the R right pad value should be written
      to the 0th register in the array, the G value should be written to the 1st register,
      and the B value should be written to the 2nd register. For CMYK, the C value should
      written to the 0th register, the M value to the 1st register, and so forth. (Instance 3 of 3)*/
//====================================================================

#define  POGOIZER_RVAL2_RESERVED1_MASK 0xffff0000
#define  POGOIZER_RVAL2_RESERVED1_SHIFT 16
#define  POGOIZER_RVAL2_RESERVED1_MASK_SHIFT(reg) (((reg) & POGOIZER_RVAL2_RESERVED1_MASK) >> POGOIZER_RVAL2_RESERVED1_SHIFT)
#define  POGOIZER_RVAL2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~POGOIZER_RVAL2_RESERVED1_MASK) | (((uint32_t)val) << POGOIZER_RVAL2_RESERVED1_SHIFT))

#define  POGOIZER_RVAL2_RIGHTVAL_MASK 0xffff
#define  POGOIZER_RVAL2_RIGHTVAL_SHIFT 0
#define  POGOIZER_RVAL2_RIGHTVAL_MASK_SHIFT(reg) (((reg) & POGOIZER_RVAL2_RIGHTVAL_MASK) >> POGOIZER_RVAL2_RIGHTVAL_SHIFT)
#define  POGOIZER_RVAL2_RIGHTVAL_REPLACE_VAL(reg,val) (((reg) & ~POGOIZER_RVAL2_RIGHTVAL_MASK) | (((uint32_t)val) << POGOIZER_RVAL2_RIGHTVAL_SHIFT))

//====================================================================
//Register: Left Side Truncation Boundary (LTrunc)
/** \brief This register is used to specify the left side truncation boundary. Specify the first
      column of the scaled input image that should be included in the output. Note that if
      left side replicate padding is also specified, the specified column will be the one
      that is replicated on the left side of the image.*/
//====================================================================

#define  POGOIZER_LTRUNC_RESERVED1_MASK 0xffff0000
#define  POGOIZER_LTRUNC_RESERVED1_SHIFT 16
#define  POGOIZER_LTRUNC_RESERVED1_MASK_SHIFT(reg) (((reg) & POGOIZER_LTRUNC_RESERVED1_MASK) >> POGOIZER_LTRUNC_RESERVED1_SHIFT)
#define  POGOIZER_LTRUNC_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~POGOIZER_LTRUNC_RESERVED1_MASK) | (((uint32_t)val) << POGOIZER_LTRUNC_RESERVED1_SHIFT))

#define  POGOIZER_LTRUNC_FIRSTCOLUMN_MASK 0xffff
#define  POGOIZER_LTRUNC_FIRSTCOLUMN_SHIFT 0
#define  POGOIZER_LTRUNC_FIRSTCOLUMN_MASK_SHIFT(reg) (((reg) & POGOIZER_LTRUNC_FIRSTCOLUMN_MASK) >> POGOIZER_LTRUNC_FIRSTCOLUMN_SHIFT)
#define  POGOIZER_LTRUNC_FIRSTCOLUMN_REPLACE_VAL(reg,val) (((reg) & ~POGOIZER_LTRUNC_FIRSTCOLUMN_MASK) | (((uint32_t)val) << POGOIZER_LTRUNC_FIRSTCOLUMN_SHIFT))

//====================================================================
//Register: Right Side Truncation Boundary (RTrunc)
/** \brief This register is used to specify the right side truncation boundary. Specify the last
      column of the scaled input image that should be included in the output. Note that if
      right side replicate padding is also specified, the specified column will be the one
      that is replicated on the right side of the image.*/
//====================================================================

#define  POGOIZER_RTRUNC_RESERVED1_MASK 0xffff0000
#define  POGOIZER_RTRUNC_RESERVED1_SHIFT 16
#define  POGOIZER_RTRUNC_RESERVED1_MASK_SHIFT(reg) (((reg) & POGOIZER_RTRUNC_RESERVED1_MASK) >> POGOIZER_RTRUNC_RESERVED1_SHIFT)
#define  POGOIZER_RTRUNC_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~POGOIZER_RTRUNC_RESERVED1_MASK) | (((uint32_t)val) << POGOIZER_RTRUNC_RESERVED1_SHIFT))

#define  POGOIZER_RTRUNC_LASTCOLUMN_MASK 0xffff
#define  POGOIZER_RTRUNC_LASTCOLUMN_SHIFT 0
#define  POGOIZER_RTRUNC_LASTCOLUMN_MASK_SHIFT(reg) (((reg) & POGOIZER_RTRUNC_LASTCOLUMN_MASK) >> POGOIZER_RTRUNC_LASTCOLUMN_SHIFT)
#define  POGOIZER_RTRUNC_LASTCOLUMN_REPLACE_VAL(reg,val) (((reg) & ~POGOIZER_RTRUNC_LASTCOLUMN_MASK) | (((uint32_t)val) << POGOIZER_RTRUNC_LASTCOLUMN_SHIFT))

//====================================================================
//Register: IP Tagging Revision 0 (REV0)
/** \brief Provide means for firmware to read IP tagging information.
      This register of particular interest to firmware.*/
//====================================================================

#define  POGOIZER_REV0_MAJ_MASK 0xffff0000
#define  POGOIZER_REV0_MAJ_SHIFT 16
#define  POGOIZER_REV0_MAJ_MASK_SHIFT(reg) (((reg) & POGOIZER_REV0_MAJ_MASK) >> POGOIZER_REV0_MAJ_SHIFT)
#define  POGOIZER_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~POGOIZER_REV0_MAJ_MASK) | (((uint32_t)val) << POGOIZER_REV0_MAJ_SHIFT))

#define  POGOIZER_REV0_MID_MASK 0xffff
#define  POGOIZER_REV0_MID_SHIFT 0
#define  POGOIZER_REV0_MID_MASK_SHIFT(reg) (((reg) & POGOIZER_REV0_MID_MASK) >> POGOIZER_REV0_MID_SHIFT)
#define  POGOIZER_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~POGOIZER_REV0_MID_MASK) | (((uint32_t)val) << POGOIZER_REV0_MID_SHIFT))

//====================================================================
//Register: IP Tagging Revision 1 (REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  POGOIZER_REV1_RESERVED1_MASK 0xffff0000
#define  POGOIZER_REV1_RESERVED1_SHIFT 16
#define  POGOIZER_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & POGOIZER_REV1_RESERVED1_MASK) >> POGOIZER_REV1_RESERVED1_SHIFT)
#define  POGOIZER_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~POGOIZER_REV1_RESERVED1_MASK) | (((uint32_t)val) << POGOIZER_REV1_RESERVED1_SHIFT))

#define  POGOIZER_REV1_CFG_MASK 0xffff
#define  POGOIZER_REV1_CFG_SHIFT 0
#define  POGOIZER_REV1_CFG_MASK_SHIFT(reg) (((reg) & POGOIZER_REV1_CFG_MASK) >> POGOIZER_REV1_CFG_SHIFT)
#define  POGOIZER_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~POGOIZER_REV1_CFG_MASK) | (((uint32_t)val) << POGOIZER_REV1_CFG_SHIFT))

//====================================================================
//
//Register File: PIE POGO Input OT DMA (OT_POGO_IDMA)
//
//====================================================================

//====================================================================
//
//Register File: PIE OT POGOIZER (OTPOGOIZER)
/** \brief (rev 0 . 6 . 3 . 0)
    These registers provide the means to program the characteristics of the desired
    pogoizing operation.*/
//
//====================================================================

//====================================================================
//Register: Pogoizer Configuration Register (Cfg)
/** \brief The fields in this register are used to configure the characteristics of the desired
      pogoizing operation.*/
//====================================================================

#define  OTPOGOIZER_CFG_RESERVED1_MASK 0xffffc000
#define  OTPOGOIZER_CFG_RESERVED1_SHIFT 14
#define  OTPOGOIZER_CFG_RESERVED1_MASK_SHIFT(reg) (((reg) & OTPOGOIZER_CFG_RESERVED1_MASK) >> OTPOGOIZER_CFG_RESERVED1_SHIFT)
#define  OTPOGOIZER_CFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~OTPOGOIZER_CFG_RESERVED1_MASK) | (((uint32_t)val) << OTPOGOIZER_CFG_RESERVED1_SHIFT))

#define  OTPOGOIZER_CFG_PIXORDER_MASK 0x2000
#define  OTPOGOIZER_CFG_PIXORDER_SHIFT 13
#define  OTPOGOIZER_CFG_PIXORDER_MASK_SHIFT(reg) (((reg) & OTPOGOIZER_CFG_PIXORDER_MASK) >> OTPOGOIZER_CFG_PIXORDER_SHIFT)
#define  OTPOGOIZER_CFG_PIXORDER_REPLACE_VAL(reg,val) (((reg) & ~OTPOGOIZER_CFG_PIXORDER_MASK) | (((uint32_t)val) << OTPOGOIZER_CFG_PIXORDER_SHIFT))

#define  OTPOGOIZER_CFG_RESERVED2_MASK 0x1000
#define  OTPOGOIZER_CFG_RESERVED2_SHIFT 12
#define  OTPOGOIZER_CFG_RESERVED2_MASK_SHIFT(reg) (((reg) & OTPOGOIZER_CFG_RESERVED2_MASK) >> OTPOGOIZER_CFG_RESERVED2_SHIFT)
#define  OTPOGOIZER_CFG_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~OTPOGOIZER_CFG_RESERVED2_MASK) | (((uint32_t)val) << OTPOGOIZER_CFG_RESERVED2_SHIFT))

#define  OTPOGOIZER_CFG_SCALEX_MASK 0xc00
#define  OTPOGOIZER_CFG_SCALEX_SHIFT 10
#define  OTPOGOIZER_CFG_SCALEX_MASK_SHIFT(reg) (((reg) & OTPOGOIZER_CFG_SCALEX_MASK) >> OTPOGOIZER_CFG_SCALEX_SHIFT)
#define  OTPOGOIZER_CFG_SCALEX_REPLACE_VAL(reg,val) (((reg) & ~OTPOGOIZER_CFG_SCALEX_MASK) | (((uint32_t)val) << OTPOGOIZER_CFG_SCALEX_SHIFT))

#define  OTPOGOIZER_CFG_SCALEY_MASK 0x300
#define  OTPOGOIZER_CFG_SCALEY_SHIFT 8
#define  OTPOGOIZER_CFG_SCALEY_MASK_SHIFT(reg) (((reg) & OTPOGOIZER_CFG_SCALEY_MASK) >> OTPOGOIZER_CFG_SCALEY_SHIFT)
#define  OTPOGOIZER_CFG_SCALEY_REPLACE_VAL(reg,val) (((reg) & ~OTPOGOIZER_CFG_SCALEY_MASK) | (((uint32_t)val) << OTPOGOIZER_CFG_SCALEY_SHIFT))

#define  OTPOGOIZER_CFG_RESERVED3_MASK 0x80
#define  OTPOGOIZER_CFG_RESERVED3_SHIFT 7
#define  OTPOGOIZER_CFG_RESERVED3_MASK_SHIFT(reg) (((reg) & OTPOGOIZER_CFG_RESERVED3_MASK) >> OTPOGOIZER_CFG_RESERVED3_SHIFT)
#define  OTPOGOIZER_CFG_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~OTPOGOIZER_CFG_RESERVED3_MASK) | (((uint32_t)val) << OTPOGOIZER_CFG_RESERVED3_SHIFT))

#define  OTPOGOIZER_CFG_BPP_MASK 0x70
#define  OTPOGOIZER_CFG_BPP_SHIFT 4
#define  OTPOGOIZER_CFG_BPP_MASK_SHIFT(reg) (((reg) & OTPOGOIZER_CFG_BPP_MASK) >> OTPOGOIZER_CFG_BPP_SHIFT)
#define  OTPOGOIZER_CFG_BPP_REPLACE_VAL(reg,val) (((reg) & ~OTPOGOIZER_CFG_BPP_MASK) | (((uint32_t)val) << OTPOGOIZER_CFG_BPP_SHIFT))

#define  OTPOGOIZER_CFG_COLORSWAP_MASK 0x8
#define  OTPOGOIZER_CFG_COLORSWAP_SHIFT 3
#define  OTPOGOIZER_CFG_COLORSWAP_MASK_SHIFT(reg) (((reg) & OTPOGOIZER_CFG_COLORSWAP_MASK) >> OTPOGOIZER_CFG_COLORSWAP_SHIFT)
#define  OTPOGOIZER_CFG_COLORSWAP_REPLACE_VAL(reg,val) (((reg) & ~OTPOGOIZER_CFG_COLORSWAP_MASK) | (((uint32_t)val) << OTPOGOIZER_CFG_COLORSWAP_SHIFT))

#define  OTPOGOIZER_CFG_FMT_MASK 0x7
#define  OTPOGOIZER_CFG_FMT_SHIFT 0
#define  OTPOGOIZER_CFG_FMT_MASK_SHIFT(reg) (((reg) & OTPOGOIZER_CFG_FMT_MASK) >> OTPOGOIZER_CFG_FMT_SHIFT)
#define  OTPOGOIZER_CFG_FMT_REPLACE_VAL(reg,val) (((reg) & ~OTPOGOIZER_CFG_FMT_MASK) | (((uint32_t)val) << OTPOGOIZER_CFG_FMT_SHIFT))

//====================================================================
//Register: Left Side Padding Register (LPad)
/** \brief This register configures left side padding.*/
//====================================================================

#define  OTPOGOIZER_LPAD_RESERVED1_MASK 0xfffe0000
#define  OTPOGOIZER_LPAD_RESERVED1_SHIFT 17
#define  OTPOGOIZER_LPAD_RESERVED1_MASK_SHIFT(reg) (((reg) & OTPOGOIZER_LPAD_RESERVED1_MASK) >> OTPOGOIZER_LPAD_RESERVED1_SHIFT)
#define  OTPOGOIZER_LPAD_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~OTPOGOIZER_LPAD_RESERVED1_MASK) | (((uint32_t)val) << OTPOGOIZER_LPAD_RESERVED1_SHIFT))

#define  OTPOGOIZER_LPAD_LEFTEDGEFILL_MASK 0x10000
#define  OTPOGOIZER_LPAD_LEFTEDGEFILL_SHIFT 16
#define  OTPOGOIZER_LPAD_LEFTEDGEFILL_MASK_SHIFT(reg) (((reg) & OTPOGOIZER_LPAD_LEFTEDGEFILL_MASK) >> OTPOGOIZER_LPAD_LEFTEDGEFILL_SHIFT)
#define  OTPOGOIZER_LPAD_LEFTEDGEFILL_REPLACE_VAL(reg,val) (((reg) & ~OTPOGOIZER_LPAD_LEFTEDGEFILL_MASK) | (((uint32_t)val) << OTPOGOIZER_LPAD_LEFTEDGEFILL_SHIFT))

#define  OTPOGOIZER_LPAD_LEFTLEN_MASK 0xffff
#define  OTPOGOIZER_LPAD_LEFTLEN_SHIFT 0
#define  OTPOGOIZER_LPAD_LEFTLEN_MASK_SHIFT(reg) (((reg) & OTPOGOIZER_LPAD_LEFTLEN_MASK) >> OTPOGOIZER_LPAD_LEFTLEN_SHIFT)
#define  OTPOGOIZER_LPAD_LEFTLEN_REPLACE_VAL(reg,val) (((reg) & ~OTPOGOIZER_LPAD_LEFTLEN_MASK) | (((uint32_t)val) << OTPOGOIZER_LPAD_LEFTLEN_SHIFT))

//====================================================================
//Register: Right Side Padding Register (RPad)
/** \brief This register configures right side padding.*/
//====================================================================

#define  OTPOGOIZER_RPAD_RESERVED1_MASK 0xfffe0000
#define  OTPOGOIZER_RPAD_RESERVED1_SHIFT 17
#define  OTPOGOIZER_RPAD_RESERVED1_MASK_SHIFT(reg) (((reg) & OTPOGOIZER_RPAD_RESERVED1_MASK) >> OTPOGOIZER_RPAD_RESERVED1_SHIFT)
#define  OTPOGOIZER_RPAD_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~OTPOGOIZER_RPAD_RESERVED1_MASK) | (((uint32_t)val) << OTPOGOIZER_RPAD_RESERVED1_SHIFT))

#define  OTPOGOIZER_RPAD_RIGHTEDGEFILL_MASK 0x10000
#define  OTPOGOIZER_RPAD_RIGHTEDGEFILL_SHIFT 16
#define  OTPOGOIZER_RPAD_RIGHTEDGEFILL_MASK_SHIFT(reg) (((reg) & OTPOGOIZER_RPAD_RIGHTEDGEFILL_MASK) >> OTPOGOIZER_RPAD_RIGHTEDGEFILL_SHIFT)
#define  OTPOGOIZER_RPAD_RIGHTEDGEFILL_REPLACE_VAL(reg,val) (((reg) & ~OTPOGOIZER_RPAD_RIGHTEDGEFILL_MASK) | (((uint32_t)val) << OTPOGOIZER_RPAD_RIGHTEDGEFILL_SHIFT))

#define  OTPOGOIZER_RPAD_RIGHTLEN_MASK 0xffff
#define  OTPOGOIZER_RPAD_RIGHTLEN_SHIFT 0
#define  OTPOGOIZER_RPAD_RIGHTLEN_MASK_SHIFT(reg) (((reg) & OTPOGOIZER_RPAD_RIGHTLEN_MASK) >> OTPOGOIZER_RPAD_RIGHTLEN_SHIFT)
#define  OTPOGOIZER_RPAD_RIGHTLEN_REPLACE_VAL(reg,val) (((reg) & ~OTPOGOIZER_RPAD_RIGHTLEN_MASK) | (((uint32_t)val) << OTPOGOIZER_RPAD_RIGHTLEN_SHIFT))

//====================================================================
//Register: Left Side Padding Value Register (Instance 1 of 1) (LVal0)
/** \brief This register contains the pad value for the left side if leftEdgeFill is not set.
      There is one register per color. For RGB data, the R left pad value should be written
      to the 0th register in the array, the G value should be written to the 1st register,
      and the B value should be written to the 2nd register. For CMYK, the C value should
      written to the 0th register, the M value to the 1st register, and so forth. (Instance 1 of 1)*/
//====================================================================

#define  OTPOGOIZER_LVAL0_LEFTVAL_MASK 0xffffffff
#define  OTPOGOIZER_LVAL0_LEFTVAL_SHIFT 0
#define  OTPOGOIZER_LVAL0_LEFTVAL_MASK_SHIFT(reg) (((reg) & OTPOGOIZER_LVAL0_LEFTVAL_MASK) >> OTPOGOIZER_LVAL0_LEFTVAL_SHIFT)
#define  OTPOGOIZER_LVAL0_LEFTVAL_REPLACE_VAL(reg,val) (((reg) & ~OTPOGOIZER_LVAL0_LEFTVAL_MASK) | (((uint32_t)val) << OTPOGOIZER_LVAL0_LEFTVAL_SHIFT))

//====================================================================
//Register: Right Side Padding Value Register (Instance 1 of 1) (RVal0)
/** \brief This register contains the pad value for the right side if rightEdgeFill is not set.
      There is one register per color. For RGB data, the R right pad value should be written
      to the 0th register in the array, the G value should be written to the 1st register,
      and the B value should be written to the 2nd register. For CMYK, the C value should
      written to the 0th register, the M value to the 1st register, and so forth. (Instance 1 of 1)*/
//====================================================================

#define  OTPOGOIZER_RVAL0_RIGHTVAL_MASK 0xffffffff
#define  OTPOGOIZER_RVAL0_RIGHTVAL_SHIFT 0
#define  OTPOGOIZER_RVAL0_RIGHTVAL_MASK_SHIFT(reg) (((reg) & OTPOGOIZER_RVAL0_RIGHTVAL_MASK) >> OTPOGOIZER_RVAL0_RIGHTVAL_SHIFT)
#define  OTPOGOIZER_RVAL0_RIGHTVAL_REPLACE_VAL(reg,val) (((reg) & ~OTPOGOIZER_RVAL0_RIGHTVAL_MASK) | (((uint32_t)val) << OTPOGOIZER_RVAL0_RIGHTVAL_SHIFT))

//====================================================================
//Register: Left Side Truncation Boundary (LTrunc)
/** \brief This register is used to specify the left side truncation boundary. Specify the first
      column of the scaled input image that should be included in the output. Note that if
      left side replicate padding is also specified, the specified column will be the one
      that is replicated on the left side of the image.*/
//====================================================================

#define  OTPOGOIZER_LTRUNC_RESERVED1_MASK 0xffff0000
#define  OTPOGOIZER_LTRUNC_RESERVED1_SHIFT 16
#define  OTPOGOIZER_LTRUNC_RESERVED1_MASK_SHIFT(reg) (((reg) & OTPOGOIZER_LTRUNC_RESERVED1_MASK) >> OTPOGOIZER_LTRUNC_RESERVED1_SHIFT)
#define  OTPOGOIZER_LTRUNC_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~OTPOGOIZER_LTRUNC_RESERVED1_MASK) | (((uint32_t)val) << OTPOGOIZER_LTRUNC_RESERVED1_SHIFT))

#define  OTPOGOIZER_LTRUNC_FIRSTCOLUMN_MASK 0xffff
#define  OTPOGOIZER_LTRUNC_FIRSTCOLUMN_SHIFT 0
#define  OTPOGOIZER_LTRUNC_FIRSTCOLUMN_MASK_SHIFT(reg) (((reg) & OTPOGOIZER_LTRUNC_FIRSTCOLUMN_MASK) >> OTPOGOIZER_LTRUNC_FIRSTCOLUMN_SHIFT)
#define  OTPOGOIZER_LTRUNC_FIRSTCOLUMN_REPLACE_VAL(reg,val) (((reg) & ~OTPOGOIZER_LTRUNC_FIRSTCOLUMN_MASK) | (((uint32_t)val) << OTPOGOIZER_LTRUNC_FIRSTCOLUMN_SHIFT))

//====================================================================
//Register: Right Side Truncation Boundary (RTrunc)
/** \brief This register is used to specify the right side truncation boundary. Specify the last
      column of the scaled input image that should be included in the output. Note that if
      right side replicate padding is also specified, the specified column will be the one
      that is replicated on the right side of the image.*/
//====================================================================

#define  OTPOGOIZER_RTRUNC_RESERVED1_MASK 0xffff0000
#define  OTPOGOIZER_RTRUNC_RESERVED1_SHIFT 16
#define  OTPOGOIZER_RTRUNC_RESERVED1_MASK_SHIFT(reg) (((reg) & OTPOGOIZER_RTRUNC_RESERVED1_MASK) >> OTPOGOIZER_RTRUNC_RESERVED1_SHIFT)
#define  OTPOGOIZER_RTRUNC_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~OTPOGOIZER_RTRUNC_RESERVED1_MASK) | (((uint32_t)val) << OTPOGOIZER_RTRUNC_RESERVED1_SHIFT))

#define  OTPOGOIZER_RTRUNC_LASTCOLUMN_MASK 0xffff
#define  OTPOGOIZER_RTRUNC_LASTCOLUMN_SHIFT 0
#define  OTPOGOIZER_RTRUNC_LASTCOLUMN_MASK_SHIFT(reg) (((reg) & OTPOGOIZER_RTRUNC_LASTCOLUMN_MASK) >> OTPOGOIZER_RTRUNC_LASTCOLUMN_SHIFT)
#define  OTPOGOIZER_RTRUNC_LASTCOLUMN_REPLACE_VAL(reg,val) (((reg) & ~OTPOGOIZER_RTRUNC_LASTCOLUMN_MASK) | (((uint32_t)val) << OTPOGOIZER_RTRUNC_LASTCOLUMN_SHIFT))

//====================================================================
//Register: IP Tagging Revision 0 (REV0)
/** \brief Provide means for firmware to read IP tagging information.
      This register of particular interest to firmware.*/
//====================================================================

#define  OTPOGOIZER_REV0_MAJ_MASK 0xffff0000
#define  OTPOGOIZER_REV0_MAJ_SHIFT 16
#define  OTPOGOIZER_REV0_MAJ_MASK_SHIFT(reg) (((reg) & OTPOGOIZER_REV0_MAJ_MASK) >> OTPOGOIZER_REV0_MAJ_SHIFT)
#define  OTPOGOIZER_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~OTPOGOIZER_REV0_MAJ_MASK) | (((uint32_t)val) << OTPOGOIZER_REV0_MAJ_SHIFT))

#define  OTPOGOIZER_REV0_MID_MASK 0xffff
#define  OTPOGOIZER_REV0_MID_SHIFT 0
#define  OTPOGOIZER_REV0_MID_MASK_SHIFT(reg) (((reg) & OTPOGOIZER_REV0_MID_MASK) >> OTPOGOIZER_REV0_MID_SHIFT)
#define  OTPOGOIZER_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~OTPOGOIZER_REV0_MID_MASK) | (((uint32_t)val) << OTPOGOIZER_REV0_MID_SHIFT))

//====================================================================
//Register: IP Tagging Revision 1 (REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  OTPOGOIZER_REV1_RESERVED1_MASK 0xffff0000
#define  OTPOGOIZER_REV1_RESERVED1_SHIFT 16
#define  OTPOGOIZER_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & OTPOGOIZER_REV1_RESERVED1_MASK) >> OTPOGOIZER_REV1_RESERVED1_SHIFT)
#define  OTPOGOIZER_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~OTPOGOIZER_REV1_RESERVED1_MASK) | (((uint32_t)val) << OTPOGOIZER_REV1_RESERVED1_SHIFT))

#define  OTPOGOIZER_REV1_CFG_MASK 0xffff
#define  OTPOGOIZER_REV1_CFG_SHIFT 0
#define  OTPOGOIZER_REV1_CFG_MASK_SHIFT(reg) (((reg) & OTPOGOIZER_REV1_CFG_MASK) >> OTPOGOIZER_REV1_CFG_SHIFT)
#define  OTPOGOIZER_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~OTPOGOIZER_REV1_CFG_MASK) | (((uint32_t)val) << OTPOGOIZER_REV1_CFG_SHIFT))

//====================================================================
//
//Register File: PIE CIS Color Shift Correction (ColorShift)
/** \brief Register Descriptions for the CIS Color Shift Block
    (rev 0 . 2 . 1 . 3)*/
//
//====================================================================

//====================================================================
//Register: CIS Color Shift Configuration Register (CCSCR)
/** \brief This register controls the configuration of the CIS Color Shift Block*/
//====================================================================

#define  COLORSHIFT_CCSCR_RESERVED1_MASK 0xfffffff0
#define  COLORSHIFT_CCSCR_RESERVED1_SHIFT 4
#define  COLORSHIFT_CCSCR_RESERVED1_MASK_SHIFT(reg) (((reg) & COLORSHIFT_CCSCR_RESERVED1_MASK) >> COLORSHIFT_CCSCR_RESERVED1_SHIFT)
#define  COLORSHIFT_CCSCR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~COLORSHIFT_CCSCR_RESERVED1_MASK) | (((uint32_t)val) << COLORSHIFT_CCSCR_RESERVED1_SHIFT))

#define  COLORSHIFT_CCSCR_ROUND_MASK 0xc
#define  COLORSHIFT_CCSCR_ROUND_SHIFT 2
#define  COLORSHIFT_CCSCR_ROUND_MASK_SHIFT(reg) (((reg) & COLORSHIFT_CCSCR_ROUND_MASK) >> COLORSHIFT_CCSCR_ROUND_SHIFT)
#define  COLORSHIFT_CCSCR_ROUND_REPLACE_VAL(reg,val) (((reg) & ~COLORSHIFT_CCSCR_ROUND_MASK) | (((uint32_t)val) << COLORSHIFT_CCSCR_ROUND_SHIFT))

#define  COLORSHIFT_CCSCR_TWOLINE_MASK 0x2
#define  COLORSHIFT_CCSCR_TWOLINE_SHIFT 1
#define  COLORSHIFT_CCSCR_TWOLINE_MASK_SHIFT(reg) (((reg) & COLORSHIFT_CCSCR_TWOLINE_MASK) >> COLORSHIFT_CCSCR_TWOLINE_SHIFT)
#define  COLORSHIFT_CCSCR_TWOLINE_REPLACE_VAL(reg,val) (((reg) & ~COLORSHIFT_CCSCR_TWOLINE_MASK) | (((uint32_t)val) << COLORSHIFT_CCSCR_TWOLINE_SHIFT))

#define  COLORSHIFT_CCSCR_BYPASS_MASK 0x1
#define  COLORSHIFT_CCSCR_BYPASS_SHIFT 0
#define  COLORSHIFT_CCSCR_BYPASS_MASK_SHIFT(reg) (((reg) & COLORSHIFT_CCSCR_BYPASS_MASK) >> COLORSHIFT_CCSCR_BYPASS_SHIFT)
#define  COLORSHIFT_CCSCR_BYPASS_REPLACE_VAL(reg,val) (((reg) & ~COLORSHIFT_CCSCR_BYPASS_MASK) | (((uint32_t)val) << COLORSHIFT_CCSCR_BYPASS_SHIFT))

//====================================================================
//Register: CIS Color Shift Multiplier Mode Register (CCSMMR)
/** \brief This register controls the multiplier modes of the CIS Color Shift Block*/
//====================================================================

#define  COLORSHIFT_CCSMMR_RESERVED1_MASK 0xfffffc00
#define  COLORSHIFT_CCSMMR_RESERVED1_SHIFT 10
#define  COLORSHIFT_CCSMMR_RESERVED1_MASK_SHIFT(reg) (((reg) & COLORSHIFT_CCSMMR_RESERVED1_MASK) >> COLORSHIFT_CCSMMR_RESERVED1_SHIFT)
#define  COLORSHIFT_CCSMMR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~COLORSHIFT_CCSMMR_RESERVED1_MASK) | (((uint32_t)val) << COLORSHIFT_CCSMMR_RESERVED1_SHIFT))

#define  COLORSHIFT_CCSMMR_BLUE_MASK 0x300
#define  COLORSHIFT_CCSMMR_BLUE_SHIFT 8
#define  COLORSHIFT_CCSMMR_BLUE_MASK_SHIFT(reg) (((reg) & COLORSHIFT_CCSMMR_BLUE_MASK) >> COLORSHIFT_CCSMMR_BLUE_SHIFT)
#define  COLORSHIFT_CCSMMR_BLUE_REPLACE_VAL(reg,val) (((reg) & ~COLORSHIFT_CCSMMR_BLUE_MASK) | (((uint32_t)val) << COLORSHIFT_CCSMMR_BLUE_SHIFT))

#define  COLORSHIFT_CCSMMR_RESERVED2_MASK 0xc0
#define  COLORSHIFT_CCSMMR_RESERVED2_SHIFT 6
#define  COLORSHIFT_CCSMMR_RESERVED2_MASK_SHIFT(reg) (((reg) & COLORSHIFT_CCSMMR_RESERVED2_MASK) >> COLORSHIFT_CCSMMR_RESERVED2_SHIFT)
#define  COLORSHIFT_CCSMMR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~COLORSHIFT_CCSMMR_RESERVED2_MASK) | (((uint32_t)val) << COLORSHIFT_CCSMMR_RESERVED2_SHIFT))

#define  COLORSHIFT_CCSMMR_GREEN_MASK 0x30
#define  COLORSHIFT_CCSMMR_GREEN_SHIFT 4
#define  COLORSHIFT_CCSMMR_GREEN_MASK_SHIFT(reg) (((reg) & COLORSHIFT_CCSMMR_GREEN_MASK) >> COLORSHIFT_CCSMMR_GREEN_SHIFT)
#define  COLORSHIFT_CCSMMR_GREEN_REPLACE_VAL(reg,val) (((reg) & ~COLORSHIFT_CCSMMR_GREEN_MASK) | (((uint32_t)val) << COLORSHIFT_CCSMMR_GREEN_SHIFT))

#define  COLORSHIFT_CCSMMR_RESERVED3_MASK 0xc
#define  COLORSHIFT_CCSMMR_RESERVED3_SHIFT 2
#define  COLORSHIFT_CCSMMR_RESERVED3_MASK_SHIFT(reg) (((reg) & COLORSHIFT_CCSMMR_RESERVED3_MASK) >> COLORSHIFT_CCSMMR_RESERVED3_SHIFT)
#define  COLORSHIFT_CCSMMR_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~COLORSHIFT_CCSMMR_RESERVED3_MASK) | (((uint32_t)val) << COLORSHIFT_CCSMMR_RESERVED3_SHIFT))

#define  COLORSHIFT_CCSMMR_RED_MASK 0x3
#define  COLORSHIFT_CCSMMR_RED_SHIFT 0
#define  COLORSHIFT_CCSMMR_RED_MASK_SHIFT(reg) (((reg) & COLORSHIFT_CCSMMR_RED_MASK) >> COLORSHIFT_CCSMMR_RED_SHIFT)
#define  COLORSHIFT_CCSMMR_RED_REPLACE_VAL(reg,val) (((reg) & ~COLORSHIFT_CCSMMR_RED_MASK) | (((uint32_t)val) << COLORSHIFT_CCSMMR_RED_SHIFT))

//====================================================================
//Register: CIS Color Shift Multiplier Weights Register (CCSMWR)
/** \brief This register controls the multiplier weights of the CIS Color Shift Block*/
//====================================================================

#define  COLORSHIFT_CCSMWR_RESERVED1_MASK 0xffe00000
#define  COLORSHIFT_CCSMWR_RESERVED1_SHIFT 21
#define  COLORSHIFT_CCSMWR_RESERVED1_MASK_SHIFT(reg) (((reg) & COLORSHIFT_CCSMWR_RESERVED1_MASK) >> COLORSHIFT_CCSMWR_RESERVED1_SHIFT)
#define  COLORSHIFT_CCSMWR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~COLORSHIFT_CCSMWR_RESERVED1_MASK) | (((uint32_t)val) << COLORSHIFT_CCSMWR_RESERVED1_SHIFT))

#define  COLORSHIFT_CCSMWR_BLUE_MASK 0x1f0000
#define  COLORSHIFT_CCSMWR_BLUE_SHIFT 16
#define  COLORSHIFT_CCSMWR_BLUE_MASK_SHIFT(reg) (((reg) & COLORSHIFT_CCSMWR_BLUE_MASK) >> COLORSHIFT_CCSMWR_BLUE_SHIFT)
#define  COLORSHIFT_CCSMWR_BLUE_REPLACE_VAL(reg,val) (((reg) & ~COLORSHIFT_CCSMWR_BLUE_MASK) | (((uint32_t)val) << COLORSHIFT_CCSMWR_BLUE_SHIFT))

#define  COLORSHIFT_CCSMWR_RESERVED2_MASK 0xe000
#define  COLORSHIFT_CCSMWR_RESERVED2_SHIFT 13
#define  COLORSHIFT_CCSMWR_RESERVED2_MASK_SHIFT(reg) (((reg) & COLORSHIFT_CCSMWR_RESERVED2_MASK) >> COLORSHIFT_CCSMWR_RESERVED2_SHIFT)
#define  COLORSHIFT_CCSMWR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~COLORSHIFT_CCSMWR_RESERVED2_MASK) | (((uint32_t)val) << COLORSHIFT_CCSMWR_RESERVED2_SHIFT))

#define  COLORSHIFT_CCSMWR_GREEN_MASK 0x1f00
#define  COLORSHIFT_CCSMWR_GREEN_SHIFT 8
#define  COLORSHIFT_CCSMWR_GREEN_MASK_SHIFT(reg) (((reg) & COLORSHIFT_CCSMWR_GREEN_MASK) >> COLORSHIFT_CCSMWR_GREEN_SHIFT)
#define  COLORSHIFT_CCSMWR_GREEN_REPLACE_VAL(reg,val) (((reg) & ~COLORSHIFT_CCSMWR_GREEN_MASK) | (((uint32_t)val) << COLORSHIFT_CCSMWR_GREEN_SHIFT))

#define  COLORSHIFT_CCSMWR_RESERVED3_MASK 0xe0
#define  COLORSHIFT_CCSMWR_RESERVED3_SHIFT 5
#define  COLORSHIFT_CCSMWR_RESERVED3_MASK_SHIFT(reg) (((reg) & COLORSHIFT_CCSMWR_RESERVED3_MASK) >> COLORSHIFT_CCSMWR_RESERVED3_SHIFT)
#define  COLORSHIFT_CCSMWR_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~COLORSHIFT_CCSMWR_RESERVED3_MASK) | (((uint32_t)val) << COLORSHIFT_CCSMWR_RESERVED3_SHIFT))

#define  COLORSHIFT_CCSMWR_RED_MASK 0x1f
#define  COLORSHIFT_CCSMWR_RED_SHIFT 0
#define  COLORSHIFT_CCSMWR_RED_MASK_SHIFT(reg) (((reg) & COLORSHIFT_CCSMWR_RED_MASK) >> COLORSHIFT_CCSMWR_RED_SHIFT)
#define  COLORSHIFT_CCSMWR_RED_REPLACE_VAL(reg,val) (((reg) & ~COLORSHIFT_CCSMWR_RED_MASK) | (((uint32_t)val) << COLORSHIFT_CCSMWR_RED_SHIFT))

//====================================================================
//Register: CIS Color Shift LFSR Starting Seed Register (CCSLSSR)
/** \brief This register controls the LFSR starting seed value of the CIS Color Shift Block*/
//====================================================================

#define  COLORSHIFT_CCSLSSR_RESERVED1_MASK 0xfffff000
#define  COLORSHIFT_CCSLSSR_RESERVED1_SHIFT 12
#define  COLORSHIFT_CCSLSSR_RESERVED1_MASK_SHIFT(reg) (((reg) & COLORSHIFT_CCSLSSR_RESERVED1_MASK) >> COLORSHIFT_CCSLSSR_RESERVED1_SHIFT)
#define  COLORSHIFT_CCSLSSR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~COLORSHIFT_CCSLSSR_RESERVED1_MASK) | (((uint32_t)val) << COLORSHIFT_CCSLSSR_RESERVED1_SHIFT))

#define  COLORSHIFT_CCSLSSR_SEED_MASK 0xfff
#define  COLORSHIFT_CCSLSSR_SEED_SHIFT 0
#define  COLORSHIFT_CCSLSSR_SEED_MASK_SHIFT(reg) (((reg) & COLORSHIFT_CCSLSSR_SEED_MASK) >> COLORSHIFT_CCSLSSR_SEED_SHIFT)
#define  COLORSHIFT_CCSLSSR_SEED_REPLACE_VAL(reg,val) (((reg) & ~COLORSHIFT_CCSLSSR_SEED_MASK) | (((uint32_t)val) << COLORSHIFT_CCSLSSR_SEED_SHIFT))

//====================================================================
//Register: CIS Color Shift LFSR Status Register (CCSLSR)
/** \brief This register provides LFSR status information of the CIS Color Shift Block*/
//====================================================================

#define  COLORSHIFT_CCSLSR_RESERVED1_MASK 0xffe00000
#define  COLORSHIFT_CCSLSR_RESERVED1_SHIFT 21
#define  COLORSHIFT_CCSLSR_RESERVED1_MASK_SHIFT(reg) (((reg) & COLORSHIFT_CCSLSR_RESERVED1_MASK) >> COLORSHIFT_CCSLSR_RESERVED1_SHIFT)
#define  COLORSHIFT_CCSLSR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~COLORSHIFT_CCSLSR_RESERVED1_MASK) | (((uint32_t)val) << COLORSHIFT_CCSLSR_RESERVED1_SHIFT))

#define  COLORSHIFT_CCSLSR_BLUELFSR_MASK 0x1f0000
#define  COLORSHIFT_CCSLSR_BLUELFSR_SHIFT 16
#define  COLORSHIFT_CCSLSR_BLUELFSR_MASK_SHIFT(reg) (((reg) & COLORSHIFT_CCSLSR_BLUELFSR_MASK) >> COLORSHIFT_CCSLSR_BLUELFSR_SHIFT)
#define  COLORSHIFT_CCSLSR_BLUELFSR_REPLACE_VAL(reg,val) (((reg) & ~COLORSHIFT_CCSLSR_BLUELFSR_MASK) | (((uint32_t)val) << COLORSHIFT_CCSLSR_BLUELFSR_SHIFT))

#define  COLORSHIFT_CCSLSR_RESERVED2_MASK 0xe000
#define  COLORSHIFT_CCSLSR_RESERVED2_SHIFT 13
#define  COLORSHIFT_CCSLSR_RESERVED2_MASK_SHIFT(reg) (((reg) & COLORSHIFT_CCSLSR_RESERVED2_MASK) >> COLORSHIFT_CCSLSR_RESERVED2_SHIFT)
#define  COLORSHIFT_CCSLSR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~COLORSHIFT_CCSLSR_RESERVED2_MASK) | (((uint32_t)val) << COLORSHIFT_CCSLSR_RESERVED2_SHIFT))

#define  COLORSHIFT_CCSLSR_GREENLFSR_MASK 0x1f00
#define  COLORSHIFT_CCSLSR_GREENLFSR_SHIFT 8
#define  COLORSHIFT_CCSLSR_GREENLFSR_MASK_SHIFT(reg) (((reg) & COLORSHIFT_CCSLSR_GREENLFSR_MASK) >> COLORSHIFT_CCSLSR_GREENLFSR_SHIFT)
#define  COLORSHIFT_CCSLSR_GREENLFSR_REPLACE_VAL(reg,val) (((reg) & ~COLORSHIFT_CCSLSR_GREENLFSR_MASK) | (((uint32_t)val) << COLORSHIFT_CCSLSR_GREENLFSR_SHIFT))

#define  COLORSHIFT_CCSLSR_RESERVED3_MASK 0xe0
#define  COLORSHIFT_CCSLSR_RESERVED3_SHIFT 5
#define  COLORSHIFT_CCSLSR_RESERVED3_MASK_SHIFT(reg) (((reg) & COLORSHIFT_CCSLSR_RESERVED3_MASK) >> COLORSHIFT_CCSLSR_RESERVED3_SHIFT)
#define  COLORSHIFT_CCSLSR_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~COLORSHIFT_CCSLSR_RESERVED3_MASK) | (((uint32_t)val) << COLORSHIFT_CCSLSR_RESERVED3_SHIFT))

#define  COLORSHIFT_CCSLSR_REDLFSR_MASK 0x1f
#define  COLORSHIFT_CCSLSR_REDLFSR_SHIFT 0
#define  COLORSHIFT_CCSLSR_REDLFSR_MASK_SHIFT(reg) (((reg) & COLORSHIFT_CCSLSR_REDLFSR_MASK) >> COLORSHIFT_CCSLSR_REDLFSR_SHIFT)
#define  COLORSHIFT_CCSLSR_REDLFSR_REPLACE_VAL(reg,val) (((reg) & ~COLORSHIFT_CCSLSR_REDLFSR_MASK) | (((uint32_t)val) << COLORSHIFT_CCSLSR_REDLFSR_SHIFT))

//====================================================================
//Register: IP Tagging Revision 0 (REV0)
/** \brief Provide means for firmware to read IP tagging information.
      This register of particular interest to firmware.*/
//====================================================================

#define  COLORSHIFT_REV0_MAJ_MASK 0xffff0000
#define  COLORSHIFT_REV0_MAJ_SHIFT 16
#define  COLORSHIFT_REV0_MAJ_MASK_SHIFT(reg) (((reg) & COLORSHIFT_REV0_MAJ_MASK) >> COLORSHIFT_REV0_MAJ_SHIFT)
#define  COLORSHIFT_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~COLORSHIFT_REV0_MAJ_MASK) | (((uint32_t)val) << COLORSHIFT_REV0_MAJ_SHIFT))

#define  COLORSHIFT_REV0_MID_MASK 0xffff
#define  COLORSHIFT_REV0_MID_SHIFT 0
#define  COLORSHIFT_REV0_MID_MASK_SHIFT(reg) (((reg) & COLORSHIFT_REV0_MID_MASK) >> COLORSHIFT_REV0_MID_SHIFT)
#define  COLORSHIFT_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~COLORSHIFT_REV0_MID_MASK) | (((uint32_t)val) << COLORSHIFT_REV0_MID_SHIFT))

//====================================================================
//Register: IP Tagging Revision 1 (REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  COLORSHIFT_REV1_RESERVED1_MASK 0xffff0000
#define  COLORSHIFT_REV1_RESERVED1_SHIFT 16
#define  COLORSHIFT_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & COLORSHIFT_REV1_RESERVED1_MASK) >> COLORSHIFT_REV1_RESERVED1_SHIFT)
#define  COLORSHIFT_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~COLORSHIFT_REV1_RESERVED1_MASK) | (((uint32_t)val) << COLORSHIFT_REV1_RESERVED1_SHIFT))

#define  COLORSHIFT_REV1_CFG_MASK 0xffff
#define  COLORSHIFT_REV1_CFG_SHIFT 0
#define  COLORSHIFT_REV1_CFG_MASK_SHIFT(reg) (((reg) & COLORSHIFT_REV1_CFG_MASK) >> COLORSHIFT_REV1_CFG_SHIFT)
#define  COLORSHIFT_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~COLORSHIFT_REV1_CFG_MASK) | (((uint32_t)val) << COLORSHIFT_REV1_CFG_SHIFT))

//====================================================================
//
//Register File: PIE RGB2esRGB (LUT1D_RGB2esRGB)
/** \brief (rev 0 . 1 . 6 . 3)
    Register descriptions for the LUT1D block.*/
//
//====================================================================

//====================================================================
//Register: IP Tagging Revision 0 (REV0)
/** \brief Provide means for firmware to read IP tagging information.
      This register of particular interest to firmware.*/
//====================================================================

#define  LUT1D_RGB2ESRGB_REV0_MAJ_MASK 0xffff0000
#define  LUT1D_RGB2ESRGB_REV0_MAJ_SHIFT 16
#define  LUT1D_RGB2ESRGB_REV0_MAJ_MASK_SHIFT(reg) (((reg) & LUT1D_RGB2ESRGB_REV0_MAJ_MASK) >> LUT1D_RGB2ESRGB_REV0_MAJ_SHIFT)
#define  LUT1D_RGB2ESRGB_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~LUT1D_RGB2ESRGB_REV0_MAJ_MASK) | (((uint32_t)val) << LUT1D_RGB2ESRGB_REV0_MAJ_SHIFT))

#define  LUT1D_RGB2ESRGB_REV0_MID_MASK 0xffff
#define  LUT1D_RGB2ESRGB_REV0_MID_SHIFT 0
#define  LUT1D_RGB2ESRGB_REV0_MID_MASK_SHIFT(reg) (((reg) & LUT1D_RGB2ESRGB_REV0_MID_MASK) >> LUT1D_RGB2ESRGB_REV0_MID_SHIFT)
#define  LUT1D_RGB2ESRGB_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~LUT1D_RGB2ESRGB_REV0_MID_MASK) | (((uint32_t)val) << LUT1D_RGB2ESRGB_REV0_MID_SHIFT))

//====================================================================
//Register: IP Tagging Revision 1 (REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  LUT1D_RGB2ESRGB_REV1_RESERVED1_MASK 0xffff0000
#define  LUT1D_RGB2ESRGB_REV1_RESERVED1_SHIFT 16
#define  LUT1D_RGB2ESRGB_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & LUT1D_RGB2ESRGB_REV1_RESERVED1_MASK) >> LUT1D_RGB2ESRGB_REV1_RESERVED1_SHIFT)
#define  LUT1D_RGB2ESRGB_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~LUT1D_RGB2ESRGB_REV1_RESERVED1_MASK) | (((uint32_t)val) << LUT1D_RGB2ESRGB_REV1_RESERVED1_SHIFT))

#define  LUT1D_RGB2ESRGB_REV1_CFG_MASK 0xffff
#define  LUT1D_RGB2ESRGB_REV1_CFG_SHIFT 0
#define  LUT1D_RGB2ESRGB_REV1_CFG_MASK_SHIFT(reg) (((reg) & LUT1D_RGB2ESRGB_REV1_CFG_MASK) >> LUT1D_RGB2ESRGB_REV1_CFG_SHIFT)
#define  LUT1D_RGB2ESRGB_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~LUT1D_RGB2ESRGB_REV1_CFG_MASK) | (((uint32_t)val) << LUT1D_RGB2ESRGB_REV1_CFG_SHIFT))

//====================================================================
//Register: LUT1D Configuration Register (LUT_CR)
/** \brief The Control Register allows for setting the block mode and CPU access to the SRAMs*/
//====================================================================

#define  LUT1D_RGB2ESRGB_LUT_CR_RESERVED1_MASK 0xfffc0000
#define  LUT1D_RGB2ESRGB_LUT_CR_RESERVED1_SHIFT 18
#define  LUT1D_RGB2ESRGB_LUT_CR_RESERVED1_MASK_SHIFT(reg) (((reg) & LUT1D_RGB2ESRGB_LUT_CR_RESERVED1_MASK) >> LUT1D_RGB2ESRGB_LUT_CR_RESERVED1_SHIFT)
#define  LUT1D_RGB2ESRGB_LUT_CR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~LUT1D_RGB2ESRGB_LUT_CR_RESERVED1_MASK) | (((uint32_t)val) << LUT1D_RGB2ESRGB_LUT_CR_RESERVED1_SHIFT))

#define  LUT1D_RGB2ESRGB_LUT_CR_WRITE_ALL_MASK 0x20000
#define  LUT1D_RGB2ESRGB_LUT_CR_WRITE_ALL_SHIFT 17
#define  LUT1D_RGB2ESRGB_LUT_CR_WRITE_ALL_MASK_SHIFT(reg) (((reg) & LUT1D_RGB2ESRGB_LUT_CR_WRITE_ALL_MASK) >> LUT1D_RGB2ESRGB_LUT_CR_WRITE_ALL_SHIFT)
#define  LUT1D_RGB2ESRGB_LUT_CR_WRITE_ALL_REPLACE_VAL(reg,val) (((reg) & ~LUT1D_RGB2ESRGB_LUT_CR_WRITE_ALL_MASK) | (((uint32_t)val) << LUT1D_RGB2ESRGB_LUT_CR_WRITE_ALL_SHIFT))

#define  LUT1D_RGB2ESRGB_LUT_CR_CPU_ACCESS_MASK 0x10000
#define  LUT1D_RGB2ESRGB_LUT_CR_CPU_ACCESS_SHIFT 16
#define  LUT1D_RGB2ESRGB_LUT_CR_CPU_ACCESS_MASK_SHIFT(reg) (((reg) & LUT1D_RGB2ESRGB_LUT_CR_CPU_ACCESS_MASK) >> LUT1D_RGB2ESRGB_LUT_CR_CPU_ACCESS_SHIFT)
#define  LUT1D_RGB2ESRGB_LUT_CR_CPU_ACCESS_REPLACE_VAL(reg,val) (((reg) & ~LUT1D_RGB2ESRGB_LUT_CR_CPU_ACCESS_MASK) | (((uint32_t)val) << LUT1D_RGB2ESRGB_LUT_CR_CPU_ACCESS_SHIFT))

#define  LUT1D_RGB2ESRGB_LUT_CR_RESERVED2_MASK 0xfffe
#define  LUT1D_RGB2ESRGB_LUT_CR_RESERVED2_SHIFT 1
#define  LUT1D_RGB2ESRGB_LUT_CR_RESERVED2_MASK_SHIFT(reg) (((reg) & LUT1D_RGB2ESRGB_LUT_CR_RESERVED2_MASK) >> LUT1D_RGB2ESRGB_LUT_CR_RESERVED2_SHIFT)
#define  LUT1D_RGB2ESRGB_LUT_CR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~LUT1D_RGB2ESRGB_LUT_CR_RESERVED2_MASK) | (((uint32_t)val) << LUT1D_RGB2ESRGB_LUT_CR_RESERVED2_SHIFT))

#define  LUT1D_RGB2ESRGB_LUT_CR_BYPASS_ENABLE_MASK 0x1
#define  LUT1D_RGB2ESRGB_LUT_CR_BYPASS_ENABLE_SHIFT 0
#define  LUT1D_RGB2ESRGB_LUT_CR_BYPASS_ENABLE_MASK_SHIFT(reg) (((reg) & LUT1D_RGB2ESRGB_LUT_CR_BYPASS_ENABLE_MASK) >> LUT1D_RGB2ESRGB_LUT_CR_BYPASS_ENABLE_SHIFT)
#define  LUT1D_RGB2ESRGB_LUT_CR_BYPASS_ENABLE_REPLACE_VAL(reg,val) (((reg) & ~LUT1D_RGB2ESRGB_LUT_CR_BYPASS_ENABLE_MASK) | (((uint32_t)val) << LUT1D_RGB2ESRGB_LUT_CR_BYPASS_ENABLE_SHIFT))

//====================================================================
//Register: LUT1D Look Up Table 0 Extra Register (EXTRAREG0)
/** \brief The LUT Extra Register 0 is the extra register used when interpolating the highest address.*/
//====================================================================

#define  LUT1D_RGB2ESRGB_EXTRAREG0_RESERVED1_MASK 0xfffffc00
#define  LUT1D_RGB2ESRGB_EXTRAREG0_RESERVED1_SHIFT 10
#define  LUT1D_RGB2ESRGB_EXTRAREG0_RESERVED1_MASK_SHIFT(reg) (((reg) & LUT1D_RGB2ESRGB_EXTRAREG0_RESERVED1_MASK) >> LUT1D_RGB2ESRGB_EXTRAREG0_RESERVED1_SHIFT)
#define  LUT1D_RGB2ESRGB_EXTRAREG0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~LUT1D_RGB2ESRGB_EXTRAREG0_RESERVED1_MASK) | (((uint32_t)val) << LUT1D_RGB2ESRGB_EXTRAREG0_RESERVED1_SHIFT))

#define  LUT1D_RGB2ESRGB_EXTRAREG0_LUT_VAL_MASK 0x3ff
#define  LUT1D_RGB2ESRGB_EXTRAREG0_LUT_VAL_SHIFT 0
#define  LUT1D_RGB2ESRGB_EXTRAREG0_LUT_VAL_MASK_SHIFT(reg) (((reg) & LUT1D_RGB2ESRGB_EXTRAREG0_LUT_VAL_MASK) >> LUT1D_RGB2ESRGB_EXTRAREG0_LUT_VAL_SHIFT)
#define  LUT1D_RGB2ESRGB_EXTRAREG0_LUT_VAL_REPLACE_VAL(reg,val) (((reg) & ~LUT1D_RGB2ESRGB_EXTRAREG0_LUT_VAL_MASK) | (((uint32_t)val) << LUT1D_RGB2ESRGB_EXTRAREG0_LUT_VAL_SHIFT))

//====================================================================
//Register: LUT1D Look Up Table 1 Extra Register (EXTRAREG1)
/** \brief The LUT Extra Register 1 is the extra register used when interpolating the highest address.*/
//====================================================================

#define  LUT1D_RGB2ESRGB_EXTRAREG1_RESERVED1_MASK 0xfffffc00
#define  LUT1D_RGB2ESRGB_EXTRAREG1_RESERVED1_SHIFT 10
#define  LUT1D_RGB2ESRGB_EXTRAREG1_RESERVED1_MASK_SHIFT(reg) (((reg) & LUT1D_RGB2ESRGB_EXTRAREG1_RESERVED1_MASK) >> LUT1D_RGB2ESRGB_EXTRAREG1_RESERVED1_SHIFT)
#define  LUT1D_RGB2ESRGB_EXTRAREG1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~LUT1D_RGB2ESRGB_EXTRAREG1_RESERVED1_MASK) | (((uint32_t)val) << LUT1D_RGB2ESRGB_EXTRAREG1_RESERVED1_SHIFT))

#define  LUT1D_RGB2ESRGB_EXTRAREG1_LUT_VAL_MASK 0x3ff
#define  LUT1D_RGB2ESRGB_EXTRAREG1_LUT_VAL_SHIFT 0
#define  LUT1D_RGB2ESRGB_EXTRAREG1_LUT_VAL_MASK_SHIFT(reg) (((reg) & LUT1D_RGB2ESRGB_EXTRAREG1_LUT_VAL_MASK) >> LUT1D_RGB2ESRGB_EXTRAREG1_LUT_VAL_SHIFT)
#define  LUT1D_RGB2ESRGB_EXTRAREG1_LUT_VAL_REPLACE_VAL(reg,val) (((reg) & ~LUT1D_RGB2ESRGB_EXTRAREG1_LUT_VAL_MASK) | (((uint32_t)val) << LUT1D_RGB2ESRGB_EXTRAREG1_LUT_VAL_SHIFT))

//====================================================================
//Register: LUT1D Look Up Table 2 Extra Register (EXTRAREG2)
/** \brief The LUT Extra Register 2 is the extra register used when interpolating the highest address.*/
//====================================================================

#define  LUT1D_RGB2ESRGB_EXTRAREG2_RESERVED1_MASK 0xfffffc00
#define  LUT1D_RGB2ESRGB_EXTRAREG2_RESERVED1_SHIFT 10
#define  LUT1D_RGB2ESRGB_EXTRAREG2_RESERVED1_MASK_SHIFT(reg) (((reg) & LUT1D_RGB2ESRGB_EXTRAREG2_RESERVED1_MASK) >> LUT1D_RGB2ESRGB_EXTRAREG2_RESERVED1_SHIFT)
#define  LUT1D_RGB2ESRGB_EXTRAREG2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~LUT1D_RGB2ESRGB_EXTRAREG2_RESERVED1_MASK) | (((uint32_t)val) << LUT1D_RGB2ESRGB_EXTRAREG2_RESERVED1_SHIFT))

#define  LUT1D_RGB2ESRGB_EXTRAREG2_LUT_VAL_MASK 0x3ff
#define  LUT1D_RGB2ESRGB_EXTRAREG2_LUT_VAL_SHIFT 0
#define  LUT1D_RGB2ESRGB_EXTRAREG2_LUT_VAL_MASK_SHIFT(reg) (((reg) & LUT1D_RGB2ESRGB_EXTRAREG2_LUT_VAL_MASK) >> LUT1D_RGB2ESRGB_EXTRAREG2_LUT_VAL_SHIFT)
#define  LUT1D_RGB2ESRGB_EXTRAREG2_LUT_VAL_REPLACE_VAL(reg,val) (((reg) & ~LUT1D_RGB2ESRGB_EXTRAREG2_LUT_VAL_MASK) | (((uint32_t)val) << LUT1D_RGB2ESRGB_EXTRAREG2_LUT_VAL_SHIFT))

//====================================================================
//Register: LUT1D Look Up Table 0 (LUT0)
/** \brief The LUT0 registers are memory mapped to the first LUT (comprised of either 1 of 2 SRAMs). Write to this register to set the value of a particular LUT entry.
      Note the LUT Write Enable register must be enabled, otherwise writing to this register will have no effect.*/
//====================================================================

#define  LUT1D_RGB2ESRGB_LUT0_RESERVED1_MASK 0xfffffc00
#define  LUT1D_RGB2ESRGB_LUT0_RESERVED1_SHIFT 10
#define  LUT1D_RGB2ESRGB_LUT0_RESERVED1_MASK_SHIFT(reg) (((reg) & LUT1D_RGB2ESRGB_LUT0_RESERVED1_MASK) >> LUT1D_RGB2ESRGB_LUT0_RESERVED1_SHIFT)
#define  LUT1D_RGB2ESRGB_LUT0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~LUT1D_RGB2ESRGB_LUT0_RESERVED1_MASK) | (((uint32_t)val) << LUT1D_RGB2ESRGB_LUT0_RESERVED1_SHIFT))

#define  LUT1D_RGB2ESRGB_LUT0_LUT_VAL_MASK 0x3ff
#define  LUT1D_RGB2ESRGB_LUT0_LUT_VAL_SHIFT 0
#define  LUT1D_RGB2ESRGB_LUT0_LUT_VAL_MASK_SHIFT(reg) (((reg) & LUT1D_RGB2ESRGB_LUT0_LUT_VAL_MASK) >> LUT1D_RGB2ESRGB_LUT0_LUT_VAL_SHIFT)
#define  LUT1D_RGB2ESRGB_LUT0_LUT_VAL_REPLACE_VAL(reg,val) (((reg) & ~LUT1D_RGB2ESRGB_LUT0_LUT_VAL_MASK) | (((uint32_t)val) << LUT1D_RGB2ESRGB_LUT0_LUT_VAL_SHIFT))

//====================================================================
//Register: LUT1D Look Up Table 1 (LUT1)
/** \brief The LUT1 registers are memory mapped to the second LUT (comprised of either 1 of 2 SRAMs). Write to this register to set the value of a particular LUT entry.
      Note the LUT Write Enable register must be enabled, otherwise writing to this register will have no effect.*/
//====================================================================

#define  LUT1D_RGB2ESRGB_LUT1_RESERVED1_MASK 0xfffffc00
#define  LUT1D_RGB2ESRGB_LUT1_RESERVED1_SHIFT 10
#define  LUT1D_RGB2ESRGB_LUT1_RESERVED1_MASK_SHIFT(reg) (((reg) & LUT1D_RGB2ESRGB_LUT1_RESERVED1_MASK) >> LUT1D_RGB2ESRGB_LUT1_RESERVED1_SHIFT)
#define  LUT1D_RGB2ESRGB_LUT1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~LUT1D_RGB2ESRGB_LUT1_RESERVED1_MASK) | (((uint32_t)val) << LUT1D_RGB2ESRGB_LUT1_RESERVED1_SHIFT))

#define  LUT1D_RGB2ESRGB_LUT1_LUT_VAL_MASK 0x3ff
#define  LUT1D_RGB2ESRGB_LUT1_LUT_VAL_SHIFT 0
#define  LUT1D_RGB2ESRGB_LUT1_LUT_VAL_MASK_SHIFT(reg) (((reg) & LUT1D_RGB2ESRGB_LUT1_LUT_VAL_MASK) >> LUT1D_RGB2ESRGB_LUT1_LUT_VAL_SHIFT)
#define  LUT1D_RGB2ESRGB_LUT1_LUT_VAL_REPLACE_VAL(reg,val) (((reg) & ~LUT1D_RGB2ESRGB_LUT1_LUT_VAL_MASK) | (((uint32_t)val) << LUT1D_RGB2ESRGB_LUT1_LUT_VAL_SHIFT))

//====================================================================
//Register: LUT1D Look Up Table 2 (LUT2)
/** \brief The LUT2 registers are memory mapped to the third LUT (comprised of either 1 of 2 SRAMs). Write to this register to set the value of a particular LUT entry.
      Note the LUT Write Enable register must be enabled, otherwise writing to this register will have no effect.*/
//====================================================================

#define  LUT1D_RGB2ESRGB_LUT2_RESERVED1_MASK 0xfffffc00
#define  LUT1D_RGB2ESRGB_LUT2_RESERVED1_SHIFT 10
#define  LUT1D_RGB2ESRGB_LUT2_RESERVED1_MASK_SHIFT(reg) (((reg) & LUT1D_RGB2ESRGB_LUT2_RESERVED1_MASK) >> LUT1D_RGB2ESRGB_LUT2_RESERVED1_SHIFT)
#define  LUT1D_RGB2ESRGB_LUT2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~LUT1D_RGB2ESRGB_LUT2_RESERVED1_MASK) | (((uint32_t)val) << LUT1D_RGB2ESRGB_LUT2_RESERVED1_SHIFT))

#define  LUT1D_RGB2ESRGB_LUT2_LUT_VAL_MASK 0x3ff
#define  LUT1D_RGB2ESRGB_LUT2_LUT_VAL_SHIFT 0
#define  LUT1D_RGB2ESRGB_LUT2_LUT_VAL_MASK_SHIFT(reg) (((reg) & LUT1D_RGB2ESRGB_LUT2_LUT_VAL_MASK) >> LUT1D_RGB2ESRGB_LUT2_LUT_VAL_SHIFT)
#define  LUT1D_RGB2ESRGB_LUT2_LUT_VAL_REPLACE_VAL(reg,val) (((reg) & ~LUT1D_RGB2ESRGB_LUT2_LUT_VAL_MASK) | (((uint32_t)val) << LUT1D_RGB2ESRGB_LUT2_LUT_VAL_SHIFT))

//====================================================================
//
//Register File: PIE Subcube Color Space Conversion (ScCSC)
/** \brief Top-level register file for ScCSC*/
//
//====================================================================

//====================================================================
//Register: NOT USED (STATUS)
/** \brief Place holder for ScCSC Status Register*/
//====================================================================

#define  SCCSC_STATUS_RESERVED1_MASK 0xffffffff
#define  SCCSC_STATUS_RESERVED1_SHIFT 0
#define  SCCSC_STATUS_RESERVED1_MASK_SHIFT(reg) (((reg) & SCCSC_STATUS_RESERVED1_MASK) >> SCCSC_STATUS_RESERVED1_SHIFT)
#define  SCCSC_STATUS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SCCSC_STATUS_RESERVED1_MASK) | (((uint32_t)val) << SCCSC_STATUS_RESERVED1_SHIFT))

//====================================================================
//Register: ScCSC CONTROL REG (CNTRL)
/** \brief ScCSC Control Register*/
//====================================================================

#define  SCCSC_CNTRL_BYPASSALL_MASK 0x80000000
#define  SCCSC_CNTRL_BYPASSALL_SHIFT 31
#define  SCCSC_CNTRL_BYPASSALL_MASK_SHIFT(reg) (((reg) & SCCSC_CNTRL_BYPASSALL_MASK) >> SCCSC_CNTRL_BYPASSALL_SHIFT)
#define  SCCSC_CNTRL_BYPASSALL_REPLACE_VAL(reg,val) (((reg) & ~SCCSC_CNTRL_BYPASSALL_MASK) | (((uint32_t)val) << SCCSC_CNTRL_BYPASSALL_SHIFT))

#define  SCCSC_CNTRL_RESERVED1_MASK 0x60000000
#define  SCCSC_CNTRL_RESERVED1_SHIFT 29
#define  SCCSC_CNTRL_RESERVED1_MASK_SHIFT(reg) (((reg) & SCCSC_CNTRL_RESERVED1_MASK) >> SCCSC_CNTRL_RESERVED1_SHIFT)
#define  SCCSC_CNTRL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SCCSC_CNTRL_RESERVED1_MASK) | (((uint32_t)val) << SCCSC_CNTRL_RESERVED1_SHIFT))

#define  SCCSC_CNTRL_CPUACCESS_MASK 0x10000000
#define  SCCSC_CNTRL_CPUACCESS_SHIFT 28
#define  SCCSC_CNTRL_CPUACCESS_MASK_SHIFT(reg) (((reg) & SCCSC_CNTRL_CPUACCESS_MASK) >> SCCSC_CNTRL_CPUACCESS_SHIFT)
#define  SCCSC_CNTRL_CPUACCESS_REPLACE_VAL(reg,val) (((reg) & ~SCCSC_CNTRL_CPUACCESS_MASK) | (((uint32_t)val) << SCCSC_CNTRL_CPUACCESS_SHIFT))

#define  SCCSC_CNTRL_RESERVED2_MASK 0xe000000
#define  SCCSC_CNTRL_RESERVED2_SHIFT 25
#define  SCCSC_CNTRL_RESERVED2_MASK_SHIFT(reg) (((reg) & SCCSC_CNTRL_RESERVED2_MASK) >> SCCSC_CNTRL_RESERVED2_SHIFT)
#define  SCCSC_CNTRL_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SCCSC_CNTRL_RESERVED2_MASK) | (((uint32_t)val) << SCCSC_CNTRL_RESERVED2_SHIFT))

#define  SCCSC_CNTRL_IALG_MASK 0x1000000
#define  SCCSC_CNTRL_IALG_SHIFT 24
#define  SCCSC_CNTRL_IALG_MASK_SHIFT(reg) (((reg) & SCCSC_CNTRL_IALG_MASK) >> SCCSC_CNTRL_IALG_SHIFT)
#define  SCCSC_CNTRL_IALG_REPLACE_VAL(reg,val) (((reg) & ~SCCSC_CNTRL_IALG_MASK) | (((uint32_t)val) << SCCSC_CNTRL_IALG_SHIFT))

#define  SCCSC_CNTRL_RESERVED3_MASK 0xc00000
#define  SCCSC_CNTRL_RESERVED3_SHIFT 22
#define  SCCSC_CNTRL_RESERVED3_MASK_SHIFT(reg) (((reg) & SCCSC_CNTRL_RESERVED3_MASK) >> SCCSC_CNTRL_RESERVED3_SHIFT)
#define  SCCSC_CNTRL_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~SCCSC_CNTRL_RESERVED3_MASK) | (((uint32_t)val) << SCCSC_CNTRL_RESERVED3_SHIFT))

#define  SCCSC_CNTRL_WME_MASK 0x200000
#define  SCCSC_CNTRL_WME_SHIFT 21
#define  SCCSC_CNTRL_WME_MASK_SHIFT(reg) (((reg) & SCCSC_CNTRL_WME_MASK) >> SCCSC_CNTRL_WME_SHIFT)
#define  SCCSC_CNTRL_WME_REPLACE_VAL(reg,val) (((reg) & ~SCCSC_CNTRL_WME_MASK) | (((uint32_t)val) << SCCSC_CNTRL_WME_SHIFT))

#define  SCCSC_CNTRL_KME_MASK 0x180000
#define  SCCSC_CNTRL_KME_SHIFT 19
#define  SCCSC_CNTRL_KME_MASK_SHIFT(reg) (((reg) & SCCSC_CNTRL_KME_MASK) >> SCCSC_CNTRL_KME_SHIFT)
#define  SCCSC_CNTRL_KME_REPLACE_VAL(reg,val) (((reg) & ~SCCSC_CNTRL_KME_MASK) | (((uint32_t)val) << SCCSC_CNTRL_KME_SHIFT))

#define  SCCSC_CNTRL_RESERVED4_MASK 0x7ffff
#define  SCCSC_CNTRL_RESERVED4_SHIFT 0
#define  SCCSC_CNTRL_RESERVED4_MASK_SHIFT(reg) (((reg) & SCCSC_CNTRL_RESERVED4_MASK) >> SCCSC_CNTRL_RESERVED4_SHIFT)
#define  SCCSC_CNTRL_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~SCCSC_CNTRL_RESERVED4_MASK) | (((uint32_t)val) << SCCSC_CNTRL_RESERVED4_SHIFT))

//====================================================================
//Register: NOT USED (MCClr)
/** \brief Register not used in implementations without cache LUT.*/
//====================================================================

#define  SCCSC_MCCLR_RESERVED1_MASK 0xffffffff
#define  SCCSC_MCCLR_RESERVED1_SHIFT 0
#define  SCCSC_MCCLR_RESERVED1_MASK_SHIFT(reg) (((reg) & SCCSC_MCCLR_RESERVED1_MASK) >> SCCSC_MCCLR_RESERVED1_SHIFT)
#define  SCCSC_MCCLR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SCCSC_MCCLR_RESERVED1_MASK) | (((uint32_t)val) << SCCSC_MCCLR_RESERVED1_SHIFT))

//====================================================================
//Register: NOT USED (LCClr)
/** \brief Register not used in implementations without cache LUT.*/
//====================================================================

#define  SCCSC_LCCLR_RESERVED1_MASK 0xffffffff
#define  SCCSC_LCCLR_RESERVED1_SHIFT 0
#define  SCCSC_LCCLR_RESERVED1_MASK_SHIFT(reg) (((reg) & SCCSC_LCCLR_RESERVED1_MASK) >> SCCSC_LCCLR_RESERVED1_SHIFT)
#define  SCCSC_LCCLR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SCCSC_LCCLR_RESERVED1_MASK) | (((uint32_t)val) << SCCSC_LCCLR_RESERVED1_SHIFT))

//====================================================================
//Register: NOT USED (CACHE_INVLD)
/** \brief Register not used in implementations without cache LUT.*/
//====================================================================

#define  SCCSC_CACHE_INVLD_RESERVED1_MASK 0xffffffff
#define  SCCSC_CACHE_INVLD_RESERVED1_SHIFT 0
#define  SCCSC_CACHE_INVLD_RESERVED1_MASK_SHIFT(reg) (((reg) & SCCSC_CACHE_INVLD_RESERVED1_MASK) >> SCCSC_CACHE_INVLD_RESERVED1_SHIFT)
#define  SCCSC_CACHE_INVLD_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SCCSC_CACHE_INVLD_RESERVED1_MASK) | (((uint32_t)val) << SCCSC_CACHE_INVLD_RESERVED1_SHIFT))

//====================================================================
//Register: NOT USED (CACHE_CNTRL)
/** \brief Register not used in implementations without cache LUT.*/
//====================================================================

#define  SCCSC_CACHE_CNTRL_RESERVED1_MASK 0xffffffff
#define  SCCSC_CACHE_CNTRL_RESERVED1_SHIFT 0
#define  SCCSC_CACHE_CNTRL_RESERVED1_MASK_SHIFT(reg) (((reg) & SCCSC_CACHE_CNTRL_RESERVED1_MASK) >> SCCSC_CACHE_CNTRL_RESERVED1_SHIFT)
#define  SCCSC_CACHE_CNTRL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SCCSC_CACHE_CNTRL_RESERVED1_MASK) | (((uint32_t)val) << SCCSC_CACHE_CNTRL_RESERVED1_SHIFT))

//====================================================================
//Register: NOT USED (IDX_MISS_COUNTER)
/** \brief Register not used in implementations without cache LUT.*/
//====================================================================

#define  SCCSC_IDX_MISS_COUNTER_RESERVED1_MASK 0xffffffff
#define  SCCSC_IDX_MISS_COUNTER_RESERVED1_SHIFT 0
#define  SCCSC_IDX_MISS_COUNTER_RESERVED1_MASK_SHIFT(reg) (((reg) & SCCSC_IDX_MISS_COUNTER_RESERVED1_MASK) >> SCCSC_IDX_MISS_COUNTER_RESERVED1_SHIFT)
#define  SCCSC_IDX_MISS_COUNTER_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SCCSC_IDX_MISS_COUNTER_RESERVED1_MASK) | (((uint32_t)val) << SCCSC_IDX_MISS_COUNTER_RESERVED1_SHIFT))

//====================================================================
//Register: NOT USED (PIXEL_MISS_COUNTER)
/** \brief Register not used in implementations without cache LUT.*/
//====================================================================

#define  SCCSC_PIXEL_MISS_COUNTER_RESERVED1_MASK 0xffffffff
#define  SCCSC_PIXEL_MISS_COUNTER_RESERVED1_SHIFT 0
#define  SCCSC_PIXEL_MISS_COUNTER_RESERVED1_MASK_SHIFT(reg) (((reg) & SCCSC_PIXEL_MISS_COUNTER_RESERVED1_MASK) >> SCCSC_PIXEL_MISS_COUNTER_RESERVED1_SHIFT)
#define  SCCSC_PIXEL_MISS_COUNTER_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SCCSC_PIXEL_MISS_COUNTER_RESERVED1_MASK) | (((uint32_t)val) << SCCSC_PIXEL_MISS_COUNTER_RESERVED1_SHIFT))

//====================================================================
//Register: NOT USED (LATENCY_COUNTER)
/** \brief Register not used in implementations without cache LUT.*/
//====================================================================

#define  SCCSC_LATENCY_COUNTER_RESERVED1_MASK 0xffffffff
#define  SCCSC_LATENCY_COUNTER_RESERVED1_SHIFT 0
#define  SCCSC_LATENCY_COUNTER_RESERVED1_MASK_SHIFT(reg) (((reg) & SCCSC_LATENCY_COUNTER_RESERVED1_MASK) >> SCCSC_LATENCY_COUNTER_RESERVED1_SHIFT)
#define  SCCSC_LATENCY_COUNTER_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SCCSC_LATENCY_COUNTER_RESERVED1_MASK) | (((uint32_t)val) << SCCSC_LATENCY_COUNTER_RESERVED1_SHIFT))

//====================================================================
//Register: NOT USED (BASE_ADDR)
/** \brief Register not used in implementations without cache LUT.*/
//====================================================================

#define  SCCSC_BASE_ADDR_RESERVED1_MASK 0xffffffff
#define  SCCSC_BASE_ADDR_RESERVED1_SHIFT 0
#define  SCCSC_BASE_ADDR_RESERVED1_MASK_SHIFT(reg) (((reg) & SCCSC_BASE_ADDR_RESERVED1_MASK) >> SCCSC_BASE_ADDR_RESERVED1_SHIFT)
#define  SCCSC_BASE_ADDR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SCCSC_BASE_ADDR_RESERVED1_MASK) | (((uint32_t)val) << SCCSC_BASE_ADDR_RESERVED1_SHIFT))

//====================================================================
//Register: White Threshold settings (WT)
/** \brief Input White Threshold settings.
If white mapping is enabled (WME=1) and the incoming pixel exceeds all input channel White thresholds, the pre-defined WHITE RESPONSE (WR register) will be output.*/
//====================================================================

#define  SCCSC_WT_RESERVED1_MASK 0xc0000000
#define  SCCSC_WT_RESERVED1_SHIFT 30
#define  SCCSC_WT_RESERVED1_MASK_SHIFT(reg) (((reg) & SCCSC_WT_RESERVED1_MASK) >> SCCSC_WT_RESERVED1_SHIFT)
#define  SCCSC_WT_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SCCSC_WT_RESERVED1_MASK) | (((uint32_t)val) << SCCSC_WT_RESERVED1_SHIFT))

#define  SCCSC_WT_CH0_WT_MASK 0x3ff00000
#define  SCCSC_WT_CH0_WT_SHIFT 20
#define  SCCSC_WT_CH0_WT_MASK_SHIFT(reg) (((reg) & SCCSC_WT_CH0_WT_MASK) >> SCCSC_WT_CH0_WT_SHIFT)
#define  SCCSC_WT_CH0_WT_REPLACE_VAL(reg,val) (((reg) & ~SCCSC_WT_CH0_WT_MASK) | (((uint32_t)val) << SCCSC_WT_CH0_WT_SHIFT))

#define  SCCSC_WT_CH1_WT_MASK 0xffc00
#define  SCCSC_WT_CH1_WT_SHIFT 10
#define  SCCSC_WT_CH1_WT_MASK_SHIFT(reg) (((reg) & SCCSC_WT_CH1_WT_MASK) >> SCCSC_WT_CH1_WT_SHIFT)
#define  SCCSC_WT_CH1_WT_REPLACE_VAL(reg,val) (((reg) & ~SCCSC_WT_CH1_WT_MASK) | (((uint32_t)val) << SCCSC_WT_CH1_WT_SHIFT))

#define  SCCSC_WT_CH2_WT_MASK 0x3ff
#define  SCCSC_WT_CH2_WT_SHIFT 0
#define  SCCSC_WT_CH2_WT_MASK_SHIFT(reg) (((reg) & SCCSC_WT_CH2_WT_MASK) >> SCCSC_WT_CH2_WT_SHIFT)
#define  SCCSC_WT_CH2_WT_REPLACE_VAL(reg,val) (((reg) & ~SCCSC_WT_CH2_WT_MASK) | (((uint32_t)val) << SCCSC_WT_CH2_WT_SHIFT))

//====================================================================
//Register: White Response reg 0  (WR_REG0)
/** \brief White pixel response values for output channels 0 - 2.*/
//====================================================================

#define  SCCSC_WR_REG0_RESERVED1_MASK 0xc0000000
#define  SCCSC_WR_REG0_RESERVED1_SHIFT 30
#define  SCCSC_WR_REG0_RESERVED1_MASK_SHIFT(reg) (((reg) & SCCSC_WR_REG0_RESERVED1_MASK) >> SCCSC_WR_REG0_RESERVED1_SHIFT)
#define  SCCSC_WR_REG0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SCCSC_WR_REG0_RESERVED1_MASK) | (((uint32_t)val) << SCCSC_WR_REG0_RESERVED1_SHIFT))

#define  SCCSC_WR_REG0_CH0_WR_MASK 0x3ff00000
#define  SCCSC_WR_REG0_CH0_WR_SHIFT 20
#define  SCCSC_WR_REG0_CH0_WR_MASK_SHIFT(reg) (((reg) & SCCSC_WR_REG0_CH0_WR_MASK) >> SCCSC_WR_REG0_CH0_WR_SHIFT)
#define  SCCSC_WR_REG0_CH0_WR_REPLACE_VAL(reg,val) (((reg) & ~SCCSC_WR_REG0_CH0_WR_MASK) | (((uint32_t)val) << SCCSC_WR_REG0_CH0_WR_SHIFT))

#define  SCCSC_WR_REG0_CH1_WR_MASK 0xffc00
#define  SCCSC_WR_REG0_CH1_WR_SHIFT 10
#define  SCCSC_WR_REG0_CH1_WR_MASK_SHIFT(reg) (((reg) & SCCSC_WR_REG0_CH1_WR_MASK) >> SCCSC_WR_REG0_CH1_WR_SHIFT)
#define  SCCSC_WR_REG0_CH1_WR_REPLACE_VAL(reg,val) (((reg) & ~SCCSC_WR_REG0_CH1_WR_MASK) | (((uint32_t)val) << SCCSC_WR_REG0_CH1_WR_SHIFT))

#define  SCCSC_WR_REG0_CH2_WR_MASK 0x3ff
#define  SCCSC_WR_REG0_CH2_WR_SHIFT 0
#define  SCCSC_WR_REG0_CH2_WR_MASK_SHIFT(reg) (((reg) & SCCSC_WR_REG0_CH2_WR_MASK) >> SCCSC_WR_REG0_CH2_WR_SHIFT)
#define  SCCSC_WR_REG0_CH2_WR_REPLACE_VAL(reg,val) (((reg) & ~SCCSC_WR_REG0_CH2_WR_MASK) | (((uint32_t)val) << SCCSC_WR_REG0_CH2_WR_SHIFT))

//====================================================================
//Register: White Response reg 1  (WR_REG1)
/** \brief White pixel response values for output channels 3 - 5.*/
//====================================================================

#define  SCCSC_WR_REG1_RESERVED1_MASK 0xffffffff
#define  SCCSC_WR_REG1_RESERVED1_SHIFT 0
#define  SCCSC_WR_REG1_RESERVED1_MASK_SHIFT(reg) (((reg) & SCCSC_WR_REG1_RESERVED1_MASK) >> SCCSC_WR_REG1_RESERVED1_SHIFT)
#define  SCCSC_WR_REG1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SCCSC_WR_REG1_RESERVED1_MASK) | (((uint32_t)val) << SCCSC_WR_REG1_RESERVED1_SHIFT))

//====================================================================
//Register: White Response reg 2  (WR_REG2)
/** \brief White pixel response values for output channels 6 - 7.*/
//====================================================================

#define  SCCSC_WR_REG2_RESERVED1_MASK 0xffffffff
#define  SCCSC_WR_REG2_RESERVED1_SHIFT 0
#define  SCCSC_WR_REG2_RESERVED1_MASK_SHIFT(reg) (((reg) & SCCSC_WR_REG2_RESERVED1_MASK) >> SCCSC_WR_REG2_RESERVED1_SHIFT)
#define  SCCSC_WR_REG2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SCCSC_WR_REG2_RESERVED1_MASK) | (((uint32_t)val) << SCCSC_WR_REG2_RESERVED1_SHIFT))

//====================================================================
//Register: Black Response Reg 0  (KR_REG0)
/** \brief Black pixel response values for output channels 0 - 2.*/
//====================================================================

#define  SCCSC_KR_REG0_RESERVED1_MASK 0xc0000000
#define  SCCSC_KR_REG0_RESERVED1_SHIFT 30
#define  SCCSC_KR_REG0_RESERVED1_MASK_SHIFT(reg) (((reg) & SCCSC_KR_REG0_RESERVED1_MASK) >> SCCSC_KR_REG0_RESERVED1_SHIFT)
#define  SCCSC_KR_REG0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SCCSC_KR_REG0_RESERVED1_MASK) | (((uint32_t)val) << SCCSC_KR_REG0_RESERVED1_SHIFT))

#define  SCCSC_KR_REG0_CH0_KR_MASK 0x3ff00000
#define  SCCSC_KR_REG0_CH0_KR_SHIFT 20
#define  SCCSC_KR_REG0_CH0_KR_MASK_SHIFT(reg) (((reg) & SCCSC_KR_REG0_CH0_KR_MASK) >> SCCSC_KR_REG0_CH0_KR_SHIFT)
#define  SCCSC_KR_REG0_CH0_KR_REPLACE_VAL(reg,val) (((reg) & ~SCCSC_KR_REG0_CH0_KR_MASK) | (((uint32_t)val) << SCCSC_KR_REG0_CH0_KR_SHIFT))

#define  SCCSC_KR_REG0_CH1_KR_MASK 0xffc00
#define  SCCSC_KR_REG0_CH1_KR_SHIFT 10
#define  SCCSC_KR_REG0_CH1_KR_MASK_SHIFT(reg) (((reg) & SCCSC_KR_REG0_CH1_KR_MASK) >> SCCSC_KR_REG0_CH1_KR_SHIFT)
#define  SCCSC_KR_REG0_CH1_KR_REPLACE_VAL(reg,val) (((reg) & ~SCCSC_KR_REG0_CH1_KR_MASK) | (((uint32_t)val) << SCCSC_KR_REG0_CH1_KR_SHIFT))

#define  SCCSC_KR_REG0_CH2_KR_MASK 0x3ff
#define  SCCSC_KR_REG0_CH2_KR_SHIFT 0
#define  SCCSC_KR_REG0_CH2_KR_MASK_SHIFT(reg) (((reg) & SCCSC_KR_REG0_CH2_KR_MASK) >> SCCSC_KR_REG0_CH2_KR_SHIFT)
#define  SCCSC_KR_REG0_CH2_KR_REPLACE_VAL(reg,val) (((reg) & ~SCCSC_KR_REG0_CH2_KR_MASK) | (((uint32_t)val) << SCCSC_KR_REG0_CH2_KR_SHIFT))

//====================================================================
//Register: Black Response Reg 1  (KR_REG1)
/** \brief Black pixel response values for output channels 3 - 5.*/
//====================================================================

#define  SCCSC_KR_REG1_RESERVED1_MASK 0xffffffff
#define  SCCSC_KR_REG1_RESERVED1_SHIFT 0
#define  SCCSC_KR_REG1_RESERVED1_MASK_SHIFT(reg) (((reg) & SCCSC_KR_REG1_RESERVED1_MASK) >> SCCSC_KR_REG1_RESERVED1_SHIFT)
#define  SCCSC_KR_REG1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SCCSC_KR_REG1_RESERVED1_MASK) | (((uint32_t)val) << SCCSC_KR_REG1_RESERVED1_SHIFT))

//====================================================================
//Register: Black Response Reg 2  (KR_REG2)
/** \brief Black pixel response values for output channels 6 - 7.*/
//====================================================================

#define  SCCSC_KR_REG2_RESERVED1_MASK 0xffffffff
#define  SCCSC_KR_REG2_RESERVED1_SHIFT 0
#define  SCCSC_KR_REG2_RESERVED1_MASK_SHIFT(reg) (((reg) & SCCSC_KR_REG2_RESERVED1_MASK) >> SCCSC_KR_REG2_RESERVED1_SHIFT)
#define  SCCSC_KR_REG2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SCCSC_KR_REG2_RESERVED1_MASK) | (((uint32_t)val) << SCCSC_KR_REG2_RESERVED1_SHIFT))

//====================================================================
//Register: SRAM Address  (RAR)
/** \brief Write Only RAM address and control for CPU Access to the 8 iLUT and 8 Cache RAMS
Register is ignored unless CPUAccess bit of the CNTRL register is asserted.*/
//====================================================================

#define  SCCSC_RAR_AUTOINC_MASK 0xc0000000
#define  SCCSC_RAR_AUTOINC_SHIFT 30
#define  SCCSC_RAR_AUTOINC_MASK_SHIFT(reg) (((reg) & SCCSC_RAR_AUTOINC_MASK) >> SCCSC_RAR_AUTOINC_SHIFT)
#define  SCCSC_RAR_AUTOINC_REPLACE_VAL(reg,val) (((reg) & ~SCCSC_RAR_AUTOINC_MASK) | (((uint32_t)val) << SCCSC_RAR_AUTOINC_SHIFT))

#define  SCCSC_RAR_RESERVED1_MASK 0x3ffe0000
#define  SCCSC_RAR_RESERVED1_SHIFT 17
#define  SCCSC_RAR_RESERVED1_MASK_SHIFT(reg) (((reg) & SCCSC_RAR_RESERVED1_MASK) >> SCCSC_RAR_RESERVED1_SHIFT)
#define  SCCSC_RAR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SCCSC_RAR_RESERVED1_MASK) | (((uint32_t)val) << SCCSC_RAR_RESERVED1_SHIFT))

#define  SCCSC_RAR_RNW_MASK 0x10000
#define  SCCSC_RAR_RNW_SHIFT 16
#define  SCCSC_RAR_RNW_MASK_SHIFT(reg) (((reg) & SCCSC_RAR_RNW_MASK) >> SCCSC_RAR_RNW_SHIFT)
#define  SCCSC_RAR_RNW_REPLACE_VAL(reg,val) (((reg) & ~SCCSC_RAR_RNW_MASK) | (((uint32_t)val) << SCCSC_RAR_RNW_SHIFT))

#define  SCCSC_RAR_RESERVED2_MASK 0xc000
#define  SCCSC_RAR_RESERVED2_SHIFT 14
#define  SCCSC_RAR_RESERVED2_MASK_SHIFT(reg) (((reg) & SCCSC_RAR_RESERVED2_MASK) >> SCCSC_RAR_RESERVED2_SHIFT)
#define  SCCSC_RAR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SCCSC_RAR_RESERVED2_MASK) | (((uint32_t)val) << SCCSC_RAR_RESERVED2_SHIFT))

#define  SCCSC_RAR_ADDR_MASK 0x3fff
#define  SCCSC_RAR_ADDR_SHIFT 0
#define  SCCSC_RAR_ADDR_MASK_SHIFT(reg) (((reg) & SCCSC_RAR_ADDR_MASK) >> SCCSC_RAR_ADDR_SHIFT)
#define  SCCSC_RAR_ADDR_REPLACE_VAL(reg,val) (((reg) & ~SCCSC_RAR_ADDR_MASK) | (((uint32_t)val) << SCCSC_RAR_ADDR_SHIFT))

//====================================================================
//Register: RAM Data Write 0 (RDW0)
/** \brief CPU Access Write data[31:0] to RAMs*/
//====================================================================

#define  SCCSC_RDW0_DATA_MASK 0xffffffff
#define  SCCSC_RDW0_DATA_SHIFT 0
#define  SCCSC_RDW0_DATA_MASK_SHIFT(reg) (((reg) & SCCSC_RDW0_DATA_MASK) >> SCCSC_RDW0_DATA_SHIFT)
#define  SCCSC_RDW0_DATA_REPLACE_VAL(reg,val) (((reg) & ~SCCSC_RDW0_DATA_MASK) | (((uint32_t)val) << SCCSC_RDW0_DATA_SHIFT))

//====================================================================
//Register: RAM Data Write 1 (RDW1)
/** \brief CPU Access Write data[63:32] to RAMs. These bits are only used if the cache or ilut RAM width exceeds 32 bits. The RAM width is a function of the number of channels and their widths. It is up to the user to determine if this register needs to be used depending on the block configuration. The hardware does understand which registers are needed for AUTOINC mode 2'b10.*/
//====================================================================

#define  SCCSC_RDW1_DATA_MASK 0xffffffff
#define  SCCSC_RDW1_DATA_SHIFT 0
#define  SCCSC_RDW1_DATA_MASK_SHIFT(reg) (((reg) & SCCSC_RDW1_DATA_MASK) >> SCCSC_RDW1_DATA_SHIFT)
#define  SCCSC_RDW1_DATA_REPLACE_VAL(reg,val) (((reg) & ~SCCSC_RDW1_DATA_MASK) | (((uint32_t)val) << SCCSC_RDW1_DATA_SHIFT))

//====================================================================
//Register: RAM Data Write 2 (RDW2)
/** \brief CPU Access Write data[79:64] to RAMs. These bits are only used if the cache or ilut RAM width exceed 64 bits. The RAM width is a function of the number of channels and their widths. It is up to the user to determine if this register needs to be used depending on the block configuration. The hardware does understand which registers are needed for AUTOINC mode 2'b10*/
//====================================================================

#define  SCCSC_RDW2_RESERVED1_MASK 0xffff0000
#define  SCCSC_RDW2_RESERVED1_SHIFT 16
#define  SCCSC_RDW2_RESERVED1_MASK_SHIFT(reg) (((reg) & SCCSC_RDW2_RESERVED1_MASK) >> SCCSC_RDW2_RESERVED1_SHIFT)
#define  SCCSC_RDW2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SCCSC_RDW2_RESERVED1_MASK) | (((uint32_t)val) << SCCSC_RDW2_RESERVED1_SHIFT))

#define  SCCSC_RDW2_DATA_MASK 0xffff
#define  SCCSC_RDW2_DATA_SHIFT 0
#define  SCCSC_RDW2_DATA_MASK_SHIFT(reg) (((reg) & SCCSC_RDW2_DATA_MASK) >> SCCSC_RDW2_DATA_SHIFT)
#define  SCCSC_RDW2_DATA_REPLACE_VAL(reg,val) (((reg) & ~SCCSC_RDW2_DATA_MASK) | (((uint32_t)val) << SCCSC_RDW2_DATA_SHIFT))

//====================================================================
//Register: RAM Data Read 0 (RDR0)
/** \brief CPU Access Read data[31:0] from RAMs*/
//====================================================================

#define  SCCSC_RDR0_DATA_MASK 0xffffffff
#define  SCCSC_RDR0_DATA_SHIFT 0
#define  SCCSC_RDR0_DATA_MASK_SHIFT(reg) (((reg) & SCCSC_RDR0_DATA_MASK) >> SCCSC_RDR0_DATA_SHIFT)
#define  SCCSC_RDR0_DATA_REPLACE_VAL(reg,val) (((reg) & ~SCCSC_RDR0_DATA_MASK) | (((uint32_t)val) << SCCSC_RDR0_DATA_SHIFT))

//====================================================================
//Register: RAM Data Read 1 (RDR1)
/** \brief CPU Access Read data[63:32] from RAMs. These bits are only used if the cache or ilut RAM width exceed 32 bits. The ram width is a function of the number of channels and their widths. It is up to the user to determine if this register is needed. The hardware does understand which registers are needed for AUTOINC mode.*/
//====================================================================

#define  SCCSC_RDR1_DATA_MASK 0xffffffff
#define  SCCSC_RDR1_DATA_SHIFT 0
#define  SCCSC_RDR1_DATA_MASK_SHIFT(reg) (((reg) & SCCSC_RDR1_DATA_MASK) >> SCCSC_RDR1_DATA_SHIFT)
#define  SCCSC_RDR1_DATA_REPLACE_VAL(reg,val) (((reg) & ~SCCSC_RDR1_DATA_MASK) | (((uint32_t)val) << SCCSC_RDR1_DATA_SHIFT))

//====================================================================
//Register: RAM Data Read 2 (RDR2)
/** \brief CPU Access Read data[79:64] from RAMs. These bits are only used if the cache or ilut RAM width exceed 64 bits. The ram width is a function of the number of channels and their widths. It is up to the user to determine if this register is needed. The hardware does understand which registers are needed for AUTOINC mode.*/
//====================================================================

#define  SCCSC_RDR2_RESERVED1_MASK 0xffff0000
#define  SCCSC_RDR2_RESERVED1_SHIFT 16
#define  SCCSC_RDR2_RESERVED1_MASK_SHIFT(reg) (((reg) & SCCSC_RDR2_RESERVED1_MASK) >> SCCSC_RDR2_RESERVED1_SHIFT)
#define  SCCSC_RDR2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SCCSC_RDR2_RESERVED1_MASK) | (((uint32_t)val) << SCCSC_RDR2_RESERVED1_SHIFT))

#define  SCCSC_RDR2_DATA_MASK 0xffff
#define  SCCSC_RDR2_DATA_SHIFT 0
#define  SCCSC_RDR2_DATA_MASK_SHIFT(reg) (((reg) & SCCSC_RDR2_DATA_MASK) >> SCCSC_RDR2_DATA_SHIFT)
#define  SCCSC_RDR2_DATA_REPLACE_VAL(reg,val) (((reg) & ~SCCSC_RDR2_DATA_MASK) | (((uint32_t)val) << SCCSC_RDR2_DATA_SHIFT))

//====================================================================
//Register: IIP Tagging Revision (REV)
/** \brief Provide means to firmware to read IP revision.*/
//====================================================================

#define  SCCSC_REV_CFG_MASK 0xffc00000
#define  SCCSC_REV_CFG_SHIFT 22
#define  SCCSC_REV_CFG_MASK_SHIFT(reg) (((reg) & SCCSC_REV_CFG_MASK) >> SCCSC_REV_CFG_SHIFT)
#define  SCCSC_REV_CFG_REPLACE_VAL(reg,val) (((reg) & ~SCCSC_REV_CFG_MASK) | (((uint32_t)val) << SCCSC_REV_CFG_SHIFT))

#define  SCCSC_REV_MID_MASK 0x3ff000
#define  SCCSC_REV_MID_SHIFT 12
#define  SCCSC_REV_MID_MASK_SHIFT(reg) (((reg) & SCCSC_REV_MID_MASK) >> SCCSC_REV_MID_SHIFT)
#define  SCCSC_REV_MID_REPLACE_VAL(reg,val) (((reg) & ~SCCSC_REV_MID_MASK) | (((uint32_t)val) << SCCSC_REV_MID_SHIFT))

#define  SCCSC_REV_MAJ_MASK 0xfff
#define  SCCSC_REV_MAJ_SHIFT 0
#define  SCCSC_REV_MAJ_MASK_SHIFT(reg) (((reg) & SCCSC_REV_MAJ_MASK) >> SCCSC_REV_MAJ_SHIFT)
#define  SCCSC_REV_MAJ_REPLACE_VAL(reg,val) (((reg) & ~SCCSC_REV_MAJ_MASK) | (((uint32_t)val) << SCCSC_REV_MAJ_SHIFT))

//====================================================================
//Register: PARAMETERS (PARAMS)
/** \brief Provide means to firmware to read PARAMETERS used to generate this BLOCK.*/
//====================================================================

#define  SCCSC_PARAMS_CACHELINES_MASK 0xffff0000
#define  SCCSC_PARAMS_CACHELINES_SHIFT 16
#define  SCCSC_PARAMS_CACHELINES_MASK_SHIFT(reg) (((reg) & SCCSC_PARAMS_CACHELINES_MASK) >> SCCSC_PARAMS_CACHELINES_SHIFT)
#define  SCCSC_PARAMS_CACHELINES_REPLACE_VAL(reg,val) (((reg) & ~SCCSC_PARAMS_CACHELINES_MASK) | (((uint32_t)val) << SCCSC_PARAMS_CACHELINES_SHIFT))

#define  SCCSC_PARAMS_NUMOUTS_MASK 0xf000
#define  SCCSC_PARAMS_NUMOUTS_SHIFT 12
#define  SCCSC_PARAMS_NUMOUTS_MASK_SHIFT(reg) (((reg) & SCCSC_PARAMS_NUMOUTS_MASK) >> SCCSC_PARAMS_NUMOUTS_SHIFT)
#define  SCCSC_PARAMS_NUMOUTS_REPLACE_VAL(reg,val) (((reg) & ~SCCSC_PARAMS_NUMOUTS_MASK) | (((uint32_t)val) << SCCSC_PARAMS_NUMOUTS_SHIFT))

#define  SCCSC_PARAMS_OUTWIDTH_MASK 0xf00
#define  SCCSC_PARAMS_OUTWIDTH_SHIFT 8
#define  SCCSC_PARAMS_OUTWIDTH_MASK_SHIFT(reg) (((reg) & SCCSC_PARAMS_OUTWIDTH_MASK) >> SCCSC_PARAMS_OUTWIDTH_SHIFT)
#define  SCCSC_PARAMS_OUTWIDTH_REPLACE_VAL(reg,val) (((reg) & ~SCCSC_PARAMS_OUTWIDTH_MASK) | (((uint32_t)val) << SCCSC_PARAMS_OUTWIDTH_SHIFT))

#define  SCCSC_PARAMS_INWIDTH_MASK 0xf0
#define  SCCSC_PARAMS_INWIDTH_SHIFT 4
#define  SCCSC_PARAMS_INWIDTH_MASK_SHIFT(reg) (((reg) & SCCSC_PARAMS_INWIDTH_MASK) >> SCCSC_PARAMS_INWIDTH_SHIFT)
#define  SCCSC_PARAMS_INWIDTH_REPLACE_VAL(reg,val) (((reg) & ~SCCSC_PARAMS_INWIDTH_MASK) | (((uint32_t)val) << SCCSC_PARAMS_INWIDTH_SHIFT))

#define  SCCSC_PARAMS_RESERVED1_MASK 0xe
#define  SCCSC_PARAMS_RESERVED1_SHIFT 1
#define  SCCSC_PARAMS_RESERVED1_MASK_SHIFT(reg) (((reg) & SCCSC_PARAMS_RESERVED1_MASK) >> SCCSC_PARAMS_RESERVED1_SHIFT)
#define  SCCSC_PARAMS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SCCSC_PARAMS_RESERVED1_MASK) | (((uint32_t)val) << SCCSC_PARAMS_RESERVED1_SHIFT))

#define  SCCSC_PARAMS_NINECUBED_MASK 0x1
#define  SCCSC_PARAMS_NINECUBED_SHIFT 0
#define  SCCSC_PARAMS_NINECUBED_MASK_SHIFT(reg) (((reg) & SCCSC_PARAMS_NINECUBED_MASK) >> SCCSC_PARAMS_NINECUBED_SHIFT)
#define  SCCSC_PARAMS_NINECUBED_REPLACE_VAL(reg,val) (((reg) & ~SCCSC_PARAMS_NINECUBED_MASK) | (((uint32_t)val) << SCCSC_PARAMS_NINECUBED_SHIFT))

//====================================================================
//
//Register File: PIE esRGB2YCrCb (ES2Y)
/** \brief (rev 0 . 4 . 4 . 0)
    Register Descriptions for the 1 CSC block*/
//
//====================================================================

//====================================================================
//Register: CSC Configuration Register (CCR)
/** \brief The CSC Configuration Register (CCR) manages the configuration of the CSC block. For normal operation of the CSC block, all bits in this register should be set to '0'.*/
//====================================================================

#define  ES2Y_CCR_RESERVED1_MASK 0xffffff00
#define  ES2Y_CCR_RESERVED1_SHIFT 8
#define  ES2Y_CCR_RESERVED1_MASK_SHIFT(reg) (((reg) & ES2Y_CCR_RESERVED1_MASK) >> ES2Y_CCR_RESERVED1_SHIFT)
#define  ES2Y_CCR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ES2Y_CCR_RESERVED1_MASK) | (((uint32_t)val) << ES2Y_CCR_RESERVED1_SHIFT))

#define  ES2Y_CCR_RESERVED2_MASK 0x80
#define  ES2Y_CCR_RESERVED2_SHIFT 7
#define  ES2Y_CCR_RESERVED2_MASK_SHIFT(reg) (((reg) & ES2Y_CCR_RESERVED2_MASK) >> ES2Y_CCR_RESERVED2_SHIFT)
#define  ES2Y_CCR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~ES2Y_CCR_RESERVED2_MASK) | (((uint32_t)val) << ES2Y_CCR_RESERVED2_SHIFT))

#define  ES2Y_CCR_POSTOFFBYPASS_MASK 0x40
#define  ES2Y_CCR_POSTOFFBYPASS_SHIFT 6
#define  ES2Y_CCR_POSTOFFBYPASS_MASK_SHIFT(reg) (((reg) & ES2Y_CCR_POSTOFFBYPASS_MASK) >> ES2Y_CCR_POSTOFFBYPASS_SHIFT)
#define  ES2Y_CCR_POSTOFFBYPASS_REPLACE_VAL(reg,val) (((reg) & ~ES2Y_CCR_POSTOFFBYPASS_MASK) | (((uint32_t)val) << ES2Y_CCR_POSTOFFBYPASS_SHIFT))

#define  ES2Y_CCR_RESERVED3_MASK 0x20
#define  ES2Y_CCR_RESERVED3_SHIFT 5
#define  ES2Y_CCR_RESERVED3_MASK_SHIFT(reg) (((reg) & ES2Y_CCR_RESERVED3_MASK) >> ES2Y_CCR_RESERVED3_SHIFT)
#define  ES2Y_CCR_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~ES2Y_CCR_RESERVED3_MASK) | (((uint32_t)val) << ES2Y_CCR_RESERVED3_SHIFT))

#define  ES2Y_CCR_RESERVED4_MASK 0x10
#define  ES2Y_CCR_RESERVED4_SHIFT 4
#define  ES2Y_CCR_RESERVED4_MASK_SHIFT(reg) (((reg) & ES2Y_CCR_RESERVED4_MASK) >> ES2Y_CCR_RESERVED4_SHIFT)
#define  ES2Y_CCR_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~ES2Y_CCR_RESERVED4_MASK) | (((uint32_t)val) << ES2Y_CCR_RESERVED4_SHIFT))

#define  ES2Y_CCR_RESERVED5_MASK 0x8
#define  ES2Y_CCR_RESERVED5_SHIFT 3
#define  ES2Y_CCR_RESERVED5_MASK_SHIFT(reg) (((reg) & ES2Y_CCR_RESERVED5_MASK) >> ES2Y_CCR_RESERVED5_SHIFT)
#define  ES2Y_CCR_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~ES2Y_CCR_RESERVED5_MASK) | (((uint32_t)val) << ES2Y_CCR_RESERVED5_SHIFT))

#define  ES2Y_CCR_RESERVED6_MASK 0x4
#define  ES2Y_CCR_RESERVED6_SHIFT 2
#define  ES2Y_CCR_RESERVED6_MASK_SHIFT(reg) (((reg) & ES2Y_CCR_RESERVED6_MASK) >> ES2Y_CCR_RESERVED6_SHIFT)
#define  ES2Y_CCR_RESERVED6_REPLACE_VAL(reg,val) (((reg) & ~ES2Y_CCR_RESERVED6_MASK) | (((uint32_t)val) << ES2Y_CCR_RESERVED6_SHIFT))

#define  ES2Y_CCR_OFFSETBYPASS_MASK 0x2
#define  ES2Y_CCR_OFFSETBYPASS_SHIFT 1
#define  ES2Y_CCR_OFFSETBYPASS_MASK_SHIFT(reg) (((reg) & ES2Y_CCR_OFFSETBYPASS_MASK) >> ES2Y_CCR_OFFSETBYPASS_SHIFT)
#define  ES2Y_CCR_OFFSETBYPASS_REPLACE_VAL(reg,val) (((reg) & ~ES2Y_CCR_OFFSETBYPASS_MASK) | (((uint32_t)val) << ES2Y_CCR_OFFSETBYPASS_SHIFT))

#define  ES2Y_CCR_BYPASSALL_MASK 0x1
#define  ES2Y_CCR_BYPASSALL_SHIFT 0
#define  ES2Y_CCR_BYPASSALL_MASK_SHIFT(reg) (((reg) & ES2Y_CCR_BYPASSALL_MASK) >> ES2Y_CCR_BYPASSALL_SHIFT)
#define  ES2Y_CCR_BYPASSALL_REPLACE_VAL(reg,val) (((reg) & ~ES2Y_CCR_BYPASSALL_MASK) | (((uint32_t)val) << ES2Y_CCR_BYPASSALL_SHIFT))

//====================================================================
//Register: Multiply Coefficient Register 0 (row 0, col 0) (MCR0)
/** \brief <p class=Body>
      There are nine Multiply Coefficient Registers (MCRn), each of which stores one
      coefficient needed for the 3x3 multiply. MCR0 stores the coefficient for row 0, column 0
      of the coefficient matrix; MCR1 stores the coefficient for row 0, column 1, etc. In other
      words, the 'n' in the address is equal to (row*3)+column.
      </p>
      <p class=Body>
      The coefficients are stored as signed 2's compliment values. Each coefficient represents 
      a number in the range (-2,2). This range is obtained by normalizing the value in the
      register by 4096 . For positive numbers (MSB = 0), the second MSB will be interpreted
      as the integer portion of the number, and the remaining bits will represent the fractional
      portion. </p>*/
//====================================================================

#define  ES2Y_MCR0_RESERVED1_MASK 0xffffc000
#define  ES2Y_MCR0_RESERVED1_SHIFT 14
#define  ES2Y_MCR0_RESERVED1_MASK_SHIFT(reg) (((reg) & ES2Y_MCR0_RESERVED1_MASK) >> ES2Y_MCR0_RESERVED1_SHIFT)
#define  ES2Y_MCR0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ES2Y_MCR0_RESERVED1_MASK) | (((uint32_t)val) << ES2Y_MCR0_RESERVED1_SHIFT))

#define  ES2Y_MCR0_COEFF_MASK 0x3fff
#define  ES2Y_MCR0_COEFF_SHIFT 0
#define  ES2Y_MCR0_COEFF_MASK_SHIFT(reg) (((reg) & ES2Y_MCR0_COEFF_MASK) >> ES2Y_MCR0_COEFF_SHIFT)
#define  ES2Y_MCR0_COEFF_REPLACE_VAL(reg,val) (((reg) & ~ES2Y_MCR0_COEFF_MASK) | (((uint32_t)val) << ES2Y_MCR0_COEFF_SHIFT))

//====================================================================
//Register: Multiply Coefficient Register 1 (row 0, col 1) (MCR1)
/** \brief <p class=Body>
      There are nine Multiply Coefficient Registers (MCRn), each of which stores one
      coefficient needed for the 3x3 multiply. MCR0 stores the coefficient for row 0, column 0
      of the coefficient matrix; MCR1 stores the coefficient for row 0, column 1, etc. In other
      words, the 'n' in the address is equal to (row*3)+column.
      </p>
      <p class=Body>
      The coefficients are stored as signed 2's compliment values. Each coefficient represents 
      a number in the range (-2,2). This range is obtained by normalizing the value in the
      register by 4096 . For positive numbers (MSB = 0), the second MSB will be interpreted
      as the integer portion of the number, and the remaining bits will represent the fractional
      portion. </p>*/
//====================================================================

#define  ES2Y_MCR1_RESERVED1_MASK 0xffffc000
#define  ES2Y_MCR1_RESERVED1_SHIFT 14
#define  ES2Y_MCR1_RESERVED1_MASK_SHIFT(reg) (((reg) & ES2Y_MCR1_RESERVED1_MASK) >> ES2Y_MCR1_RESERVED1_SHIFT)
#define  ES2Y_MCR1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ES2Y_MCR1_RESERVED1_MASK) | (((uint32_t)val) << ES2Y_MCR1_RESERVED1_SHIFT))

#define  ES2Y_MCR1_COEFF_MASK 0x3fff
#define  ES2Y_MCR1_COEFF_SHIFT 0
#define  ES2Y_MCR1_COEFF_MASK_SHIFT(reg) (((reg) & ES2Y_MCR1_COEFF_MASK) >> ES2Y_MCR1_COEFF_SHIFT)
#define  ES2Y_MCR1_COEFF_REPLACE_VAL(reg,val) (((reg) & ~ES2Y_MCR1_COEFF_MASK) | (((uint32_t)val) << ES2Y_MCR1_COEFF_SHIFT))

//====================================================================
//Register: Multiply Coefficient Register 2 (row 0, col 2) (MCR2)
/** \brief <p class=Body>
      There are nine Multiply Coefficient Registers (MCRn), each of which stores one
      coefficient needed for the 3x3 multiply. MCR0 stores the coefficient for row 0, column 0
      of the coefficient matrix; MCR1 stores the coefficient for row 0, column 1, etc. In other
      words, the 'n' in the address is equal to (row*3)+column.
      </p>
      <p class=Body>
      The coefficients are stored as signed 2's compliment values. Each coefficient represents 
      a number in the range (-2,2). This range is obtained by normalizing the value in the
      register by 4096 . For positive numbers (MSB = 0), the second MSB will be interpreted
      as the integer portion of the number, and the remaining bits will represent the fractional
      portion. </p>*/
//====================================================================

#define  ES2Y_MCR2_RESERVED1_MASK 0xffffc000
#define  ES2Y_MCR2_RESERVED1_SHIFT 14
#define  ES2Y_MCR2_RESERVED1_MASK_SHIFT(reg) (((reg) & ES2Y_MCR2_RESERVED1_MASK) >> ES2Y_MCR2_RESERVED1_SHIFT)
#define  ES2Y_MCR2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ES2Y_MCR2_RESERVED1_MASK) | (((uint32_t)val) << ES2Y_MCR2_RESERVED1_SHIFT))

#define  ES2Y_MCR2_COEFF_MASK 0x3fff
#define  ES2Y_MCR2_COEFF_SHIFT 0
#define  ES2Y_MCR2_COEFF_MASK_SHIFT(reg) (((reg) & ES2Y_MCR2_COEFF_MASK) >> ES2Y_MCR2_COEFF_SHIFT)
#define  ES2Y_MCR2_COEFF_REPLACE_VAL(reg,val) (((reg) & ~ES2Y_MCR2_COEFF_MASK) | (((uint32_t)val) << ES2Y_MCR2_COEFF_SHIFT))

//====================================================================
//Register: Multiply Coefficient Register 3 (row 1, col 0) (MCR3)
/** \brief <p class=Body>
      There are nine Multiply Coefficient Registers (MCRn), each of which stores one
      coefficient needed for the 3x3 multiply. MCR0 stores the coefficient for row 0, column 0
      of the coefficient matrix; MCR1 stores the coefficient for row 0, column 1, etc. In other
      words, the 'n' in the address is equal to (row*3)+column.
      </p>
      <p class=Body>
      The coefficients are stored as signed 2's compliment values. Each coefficient represents 
      a number in the range (-2,2). This range is obtained by normalizing the value in the
      register by 4096 . For positive numbers (MSB = 0), the second MSB will be interpreted
      as the integer portion of the number, and the remaining bits will represent the fractional
      portion. </p>*/
//====================================================================

#define  ES2Y_MCR3_RESERVED1_MASK 0xffffc000
#define  ES2Y_MCR3_RESERVED1_SHIFT 14
#define  ES2Y_MCR3_RESERVED1_MASK_SHIFT(reg) (((reg) & ES2Y_MCR3_RESERVED1_MASK) >> ES2Y_MCR3_RESERVED1_SHIFT)
#define  ES2Y_MCR3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ES2Y_MCR3_RESERVED1_MASK) | (((uint32_t)val) << ES2Y_MCR3_RESERVED1_SHIFT))

#define  ES2Y_MCR3_COEFF_MASK 0x3fff
#define  ES2Y_MCR3_COEFF_SHIFT 0
#define  ES2Y_MCR3_COEFF_MASK_SHIFT(reg) (((reg) & ES2Y_MCR3_COEFF_MASK) >> ES2Y_MCR3_COEFF_SHIFT)
#define  ES2Y_MCR3_COEFF_REPLACE_VAL(reg,val) (((reg) & ~ES2Y_MCR3_COEFF_MASK) | (((uint32_t)val) << ES2Y_MCR3_COEFF_SHIFT))

//====================================================================
//Register: Multiply Coefficient Register 4 (row 1, col 1) (MCR4)
/** \brief <p class=Body>
      There are nine Multiply Coefficient Registers (MCRn), each of which stores one
      coefficient needed for the 3x3 multiply. MCR0 stores the coefficient for row 0, column 0
      of the coefficient matrix; MCR1 stores the coefficient for row 0, column 1, etc. In other
      words, the 'n' in the address is equal to (row*3)+column.
      </p>
      <p class=Body>
      The coefficients are stored as signed 2's compliment values. Each coefficient represents 
      a number in the range (-2,2). This range is obtained by normalizing the value in the
      register by 4096 . For positive numbers (MSB = 0), the second MSB will be interpreted
      as the integer portion of the number, and the remaining bits will represent the fractional
      portion. </p>*/
//====================================================================

#define  ES2Y_MCR4_RESERVED1_MASK 0xffffc000
#define  ES2Y_MCR4_RESERVED1_SHIFT 14
#define  ES2Y_MCR4_RESERVED1_MASK_SHIFT(reg) (((reg) & ES2Y_MCR4_RESERVED1_MASK) >> ES2Y_MCR4_RESERVED1_SHIFT)
#define  ES2Y_MCR4_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ES2Y_MCR4_RESERVED1_MASK) | (((uint32_t)val) << ES2Y_MCR4_RESERVED1_SHIFT))

#define  ES2Y_MCR4_COEFF_MASK 0x3fff
#define  ES2Y_MCR4_COEFF_SHIFT 0
#define  ES2Y_MCR4_COEFF_MASK_SHIFT(reg) (((reg) & ES2Y_MCR4_COEFF_MASK) >> ES2Y_MCR4_COEFF_SHIFT)
#define  ES2Y_MCR4_COEFF_REPLACE_VAL(reg,val) (((reg) & ~ES2Y_MCR4_COEFF_MASK) | (((uint32_t)val) << ES2Y_MCR4_COEFF_SHIFT))

//====================================================================
//Register: Multiply Coefficient Register 5 (row 1, col 2) (MCR5)
/** \brief <p class=Body>
      There are nine Multiply Coefficient Registers (MCRn), each of which stores one
      coefficient needed for the 3x3 multiply. MCR0 stores the coefficient for row 0, column 0
      of the coefficient matrix; MCR1 stores the coefficient for row 0, column 1, etc. In other
      words, the 'n' in the address is equal to (row*3)+column.
      </p>
      <p class=Body>
      The coefficients are stored as signed 2's compliment values. Each coefficient represents 
      a number in the range (-2,2). This range is obtained by normalizing the value in the
      register by 4096 . For positive numbers (MSB = 0), the second MSB will be interpreted
      as the integer portion of the number, and the remaining bits will represent the fractional
      portion. </p>*/
//====================================================================

#define  ES2Y_MCR5_RESERVED1_MASK 0xffffc000
#define  ES2Y_MCR5_RESERVED1_SHIFT 14
#define  ES2Y_MCR5_RESERVED1_MASK_SHIFT(reg) (((reg) & ES2Y_MCR5_RESERVED1_MASK) >> ES2Y_MCR5_RESERVED1_SHIFT)
#define  ES2Y_MCR5_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ES2Y_MCR5_RESERVED1_MASK) | (((uint32_t)val) << ES2Y_MCR5_RESERVED1_SHIFT))

#define  ES2Y_MCR5_COEFF_MASK 0x3fff
#define  ES2Y_MCR5_COEFF_SHIFT 0
#define  ES2Y_MCR5_COEFF_MASK_SHIFT(reg) (((reg) & ES2Y_MCR5_COEFF_MASK) >> ES2Y_MCR5_COEFF_SHIFT)
#define  ES2Y_MCR5_COEFF_REPLACE_VAL(reg,val) (((reg) & ~ES2Y_MCR5_COEFF_MASK) | (((uint32_t)val) << ES2Y_MCR5_COEFF_SHIFT))

//====================================================================
//Register: Multiply Coefficient Register 6 (row 2, col 0) (MCR6)
/** \brief <p class=Body>
      There are nine Multiply Coefficient Registers (MCRn), each of which stores one
      coefficient needed for the 3x3 multiply. MCR0 stores the coefficient for row 0, column 0
      of the coefficient matrix; MCR1 stores the coefficient for row 0, column 1, etc. In other
      words, the 'n' in the address is equal to (row*3)+column.
      </p>
      <p class=Body>
      The coefficients are stored as signed 2's compliment values. Each coefficient represents 
      a number in the range (-2,2). This range is obtained by normalizing the value in the
      register by 4096 . For positive numbers (MSB = 0), the second MSB will be interpreted
      as the integer portion of the number, and the remaining bits will represent the fractional
      portion. </p>*/
//====================================================================

#define  ES2Y_MCR6_RESERVED1_MASK 0xffffc000
#define  ES2Y_MCR6_RESERVED1_SHIFT 14
#define  ES2Y_MCR6_RESERVED1_MASK_SHIFT(reg) (((reg) & ES2Y_MCR6_RESERVED1_MASK) >> ES2Y_MCR6_RESERVED1_SHIFT)
#define  ES2Y_MCR6_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ES2Y_MCR6_RESERVED1_MASK) | (((uint32_t)val) << ES2Y_MCR6_RESERVED1_SHIFT))

#define  ES2Y_MCR6_COEFF_MASK 0x3fff
#define  ES2Y_MCR6_COEFF_SHIFT 0
#define  ES2Y_MCR6_COEFF_MASK_SHIFT(reg) (((reg) & ES2Y_MCR6_COEFF_MASK) >> ES2Y_MCR6_COEFF_SHIFT)
#define  ES2Y_MCR6_COEFF_REPLACE_VAL(reg,val) (((reg) & ~ES2Y_MCR6_COEFF_MASK) | (((uint32_t)val) << ES2Y_MCR6_COEFF_SHIFT))

//====================================================================
//Register: Multiply Coefficient Register 7 (row 2, col 1) (MCR7)
/** \brief <p class=Body>
      There are nine Multiply Coefficient Registers (MCRn), each of which stores one
      coefficient needed for the 3x3 multiply. MCR0 stores the coefficient for row 0, column 0
      of the coefficient matrix; MCR1 stores the coefficient for row 0, column 1, etc. In other
      words, the 'n' in the address is equal to (row*3)+column.
      </p>
      <p class=Body>
      The coefficients are stored as signed 2's compliment values. Each coefficient represents 
      a number in the range (-2,2). This range is obtained by normalizing the value in the
      register by 4096 . For positive numbers (MSB = 0), the second MSB will be interpreted
      as the integer portion of the number, and the remaining bits will represent the fractional
      portion. </p>*/
//====================================================================

#define  ES2Y_MCR7_RESERVED1_MASK 0xffffc000
#define  ES2Y_MCR7_RESERVED1_SHIFT 14
#define  ES2Y_MCR7_RESERVED1_MASK_SHIFT(reg) (((reg) & ES2Y_MCR7_RESERVED1_MASK) >> ES2Y_MCR7_RESERVED1_SHIFT)
#define  ES2Y_MCR7_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ES2Y_MCR7_RESERVED1_MASK) | (((uint32_t)val) << ES2Y_MCR7_RESERVED1_SHIFT))

#define  ES2Y_MCR7_COEFF_MASK 0x3fff
#define  ES2Y_MCR7_COEFF_SHIFT 0
#define  ES2Y_MCR7_COEFF_MASK_SHIFT(reg) (((reg) & ES2Y_MCR7_COEFF_MASK) >> ES2Y_MCR7_COEFF_SHIFT)
#define  ES2Y_MCR7_COEFF_REPLACE_VAL(reg,val) (((reg) & ~ES2Y_MCR7_COEFF_MASK) | (((uint32_t)val) << ES2Y_MCR7_COEFF_SHIFT))

//====================================================================
//Register: Multiply Coefficient Register 8 (row 2, col 2) (MCR8)
/** \brief <p class=Body>
      There are nine Multiply Coefficient Registers (MCRn), each of which stores one
      coefficient needed for the 3x3 multiply. MCR0 stores the coefficient for row 0, column 0
      of the coefficient matrix; MCR1 stores the coefficient for row 0, column 1, etc. In other
      words, the 'n' in the address is equal to (row*3)+column.
      </p>
      <p class=Body>
      The coefficients are stored as signed 2's compliment values. Each coefficient represents 
      a number in the range (-2,2). This range is obtained by normalizing the value in the
      register by 4096 . For positive numbers (MSB = 0), the second MSB will be interpreted
      as the integer portion of the number, and the remaining bits will represent the fractional
      portion. </p>*/
//====================================================================

#define  ES2Y_MCR8_RESERVED1_MASK 0xffffc000
#define  ES2Y_MCR8_RESERVED1_SHIFT 14
#define  ES2Y_MCR8_RESERVED1_MASK_SHIFT(reg) (((reg) & ES2Y_MCR8_RESERVED1_MASK) >> ES2Y_MCR8_RESERVED1_SHIFT)
#define  ES2Y_MCR8_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ES2Y_MCR8_RESERVED1_MASK) | (((uint32_t)val) << ES2Y_MCR8_RESERVED1_SHIFT))

#define  ES2Y_MCR8_COEFF_MASK 0x3fff
#define  ES2Y_MCR8_COEFF_SHIFT 0
#define  ES2Y_MCR8_COEFF_MASK_SHIFT(reg) (((reg) & ES2Y_MCR8_COEFF_MASK) >> ES2Y_MCR8_COEFF_SHIFT)
#define  ES2Y_MCR8_COEFF_REPLACE_VAL(reg,val) (((reg) & ~ES2Y_MCR8_COEFF_MASK) | (((uint32_t)val) << ES2Y_MCR8_COEFF_SHIFT))

//====================================================================
//Register: IP Tagging Revision 0 (REV0)
/** \brief Provide means for firmware to read IP tagging information.
      This register of particular interest to firmware.*/
//====================================================================

#define  ES2Y_REV0_MAJ_MASK 0xffff0000
#define  ES2Y_REV0_MAJ_SHIFT 16
#define  ES2Y_REV0_MAJ_MASK_SHIFT(reg) (((reg) & ES2Y_REV0_MAJ_MASK) >> ES2Y_REV0_MAJ_SHIFT)
#define  ES2Y_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~ES2Y_REV0_MAJ_MASK) | (((uint32_t)val) << ES2Y_REV0_MAJ_SHIFT))

#define  ES2Y_REV0_MID_MASK 0xffff
#define  ES2Y_REV0_MID_SHIFT 0
#define  ES2Y_REV0_MID_MASK_SHIFT(reg) (((reg) & ES2Y_REV0_MID_MASK) >> ES2Y_REV0_MID_SHIFT)
#define  ES2Y_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~ES2Y_REV0_MID_MASK) | (((uint32_t)val) << ES2Y_REV0_MID_SHIFT))

//====================================================================
//Register: IP Tagging Revision 1 (REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  ES2Y_REV1_RESERVED1_MASK 0xffff0000
#define  ES2Y_REV1_RESERVED1_SHIFT 16
#define  ES2Y_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & ES2Y_REV1_RESERVED1_MASK) >> ES2Y_REV1_RESERVED1_SHIFT)
#define  ES2Y_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ES2Y_REV1_RESERVED1_MASK) | (((uint32_t)val) << ES2Y_REV1_RESERVED1_SHIFT))

#define  ES2Y_REV1_CFG_MASK 0xffff
#define  ES2Y_REV1_CFG_SHIFT 0
#define  ES2Y_REV1_CFG_MASK_SHIFT(reg) (((reg) & ES2Y_REV1_CFG_MASK) >> ES2Y_REV1_CFG_SHIFT)
#define  ES2Y_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~ES2Y_REV1_CFG_MASK) | (((uint32_t)val) << ES2Y_REV1_CFG_SHIFT))

//====================================================================
//
//Register File: PIE Histogram (CStats)
/** \brief (rev 0 . 3 . 2 . 0)
         CStats (Histogram) register interface.*/
//
//====================================================================

//====================================================================
//Register: Configure CStats Register (CFG)
//====================================================================

#define  CSTATS_CFG_RESERVED1_MASK 0xff800000
#define  CSTATS_CFG_RESERVED1_SHIFT 23
#define  CSTATS_CFG_RESERVED1_MASK_SHIFT(reg) (((reg) & CSTATS_CFG_RESERVED1_MASK) >> CSTATS_CFG_RESERVED1_SHIFT)
#define  CSTATS_CFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CSTATS_CFG_RESERVED1_MASK) | (((uint32_t)val) << CSTATS_CFG_RESERVED1_SHIFT))

#define  CSTATS_CFG_MH_MASK 0x400000
#define  CSTATS_CFG_MH_SHIFT 22
#define  CSTATS_CFG_MH_MASK_SHIFT(reg) (((reg) & CSTATS_CFG_MH_MASK) >> CSTATS_CFG_MH_SHIFT)
#define  CSTATS_CFG_MH_REPLACE_VAL(reg,val) (((reg) & ~CSTATS_CFG_MH_MASK) | (((uint32_t)val) << CSTATS_CFG_MH_SHIFT))

#define  CSTATS_CFG_IM_MASK 0x300000
#define  CSTATS_CFG_IM_SHIFT 20
#define  CSTATS_CFG_IM_MASK_SHIFT(reg) (((reg) & CSTATS_CFG_IM_MASK) >> CSTATS_CFG_IM_SHIFT)
#define  CSTATS_CFG_IM_REPLACE_VAL(reg,val) (((reg) & ~CSTATS_CFG_IM_MASK) | (((uint32_t)val) << CSTATS_CFG_IM_SHIFT))

#define  CSTATS_CFG_SO_MASK 0xf0000
#define  CSTATS_CFG_SO_SHIFT 16
#define  CSTATS_CFG_SO_MASK_SHIFT(reg) (((reg) & CSTATS_CFG_SO_MASK) >> CSTATS_CFG_SO_SHIFT)
#define  CSTATS_CFG_SO_REPLACE_VAL(reg,val) (((reg) & ~CSTATS_CFG_SO_MASK) | (((uint32_t)val) << CSTATS_CFG_SO_SHIFT))

#define  CSTATS_CFG_MCC_MASK 0x8000
#define  CSTATS_CFG_MCC_SHIFT 15
#define  CSTATS_CFG_MCC_MASK_SHIFT(reg) (((reg) & CSTATS_CFG_MCC_MASK) >> CSTATS_CFG_MCC_SHIFT)
#define  CSTATS_CFG_MCC_REPLACE_VAL(reg,val) (((reg) & ~CSTATS_CFG_MCC_MASK) | (((uint32_t)val) << CSTATS_CFG_MCC_SHIFT))

#define  CSTATS_CFG_MSC_MASK 0x4000
#define  CSTATS_CFG_MSC_SHIFT 14
#define  CSTATS_CFG_MSC_MASK_SHIFT(reg) (((reg) & CSTATS_CFG_MSC_MASK) >> CSTATS_CFG_MSC_SHIFT)
#define  CSTATS_CFG_MSC_REPLACE_VAL(reg,val) (((reg) & ~CSTATS_CFG_MSC_MASK) | (((uint32_t)val) << CSTATS_CFG_MSC_SHIFT))

#define  CSTATS_CFG_SCMODE_MASK 0x3000
#define  CSTATS_CFG_SCMODE_SHIFT 12
#define  CSTATS_CFG_SCMODE_MASK_SHIFT(reg) (((reg) & CSTATS_CFG_SCMODE_MASK) >> CSTATS_CFG_SCMODE_SHIFT)
#define  CSTATS_CFG_SCMODE_REPLACE_VAL(reg,val) (((reg) & ~CSTATS_CFG_SCMODE_MASK) | (((uint32_t)val) << CSTATS_CFG_SCMODE_SHIFT))

#define  CSTATS_CFG_RESERVED2_MASK 0xf80
#define  CSTATS_CFG_RESERVED2_SHIFT 7
#define  CSTATS_CFG_RESERVED2_MASK_SHIFT(reg) (((reg) & CSTATS_CFG_RESERVED2_MASK) >> CSTATS_CFG_RESERVED2_SHIFT)
#define  CSTATS_CFG_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~CSTATS_CFG_RESERVED2_MASK) | (((uint32_t)val) << CSTATS_CFG_RESERVED2_SHIFT))

#define  CSTATS_CFG_ECC_MASK 0x40
#define  CSTATS_CFG_ECC_SHIFT 6
#define  CSTATS_CFG_ECC_MASK_SHIFT(reg) (((reg) & CSTATS_CFG_ECC_MASK) >> CSTATS_CFG_ECC_SHIFT)
#define  CSTATS_CFG_ECC_REPLACE_VAL(reg,val) (((reg) & ~CSTATS_CFG_ECC_MASK) | (((uint32_t)val) << CSTATS_CFG_ECC_SHIFT))

#define  CSTATS_CFG_CS_MASK 0x20
#define  CSTATS_CFG_CS_SHIFT 5
#define  CSTATS_CFG_CS_MASK_SHIFT(reg) (((reg) & CSTATS_CFG_CS_MASK) >> CSTATS_CFG_CS_SHIFT)
#define  CSTATS_CFG_CS_REPLACE_VAL(reg,val) (((reg) & ~CSTATS_CFG_CS_MASK) | (((uint32_t)val) << CSTATS_CFG_CS_SHIFT))

#define  CSTATS_CFG_MONO_MASK 0x10
#define  CSTATS_CFG_MONO_SHIFT 4
#define  CSTATS_CFG_MONO_MASK_SHIFT(reg) (((reg) & CSTATS_CFG_MONO_MASK) >> CSTATS_CFG_MONO_SHIFT)
#define  CSTATS_CFG_MONO_REPLACE_VAL(reg,val) (((reg) & ~CSTATS_CFG_MONO_MASK) | (((uint32_t)val) << CSTATS_CFG_MONO_SHIFT))

#define  CSTATS_CFG_EH_MASK 0xc
#define  CSTATS_CFG_EH_SHIFT 2
#define  CSTATS_CFG_EH_MASK_SHIFT(reg) (((reg) & CSTATS_CFG_EH_MASK) >> CSTATS_CFG_EH_SHIFT)
#define  CSTATS_CFG_EH_REPLACE_VAL(reg,val) (((reg) & ~CSTATS_CFG_EH_MASK) | (((uint32_t)val) << CSTATS_CFG_EH_SHIFT))

#define  CSTATS_CFG_ESC_MASK 0x2
#define  CSTATS_CFG_ESC_SHIFT 1
#define  CSTATS_CFG_ESC_MASK_SHIFT(reg) (((reg) & CSTATS_CFG_ESC_MASK) >> CSTATS_CFG_ESC_SHIFT)
#define  CSTATS_CFG_ESC_REPLACE_VAL(reg,val) (((reg) & ~CSTATS_CFG_ESC_MASK) | (((uint32_t)val) << CSTATS_CFG_ESC_SHIFT))

#define  CSTATS_CFG_E_MASK 0x1
#define  CSTATS_CFG_E_SHIFT 0
#define  CSTATS_CFG_E_MASK_SHIFT(reg) (((reg) & CSTATS_CFG_E_MASK) >> CSTATS_CFG_E_SHIFT)
#define  CSTATS_CFG_E_REPLACE_VAL(reg,val) (((reg) & ~CSTATS_CFG_E_MASK) | (((uint32_t)val) << CSTATS_CFG_E_SHIFT))

//====================================================================
//Register: Left Margin Register (LM)
//====================================================================

#define  CSTATS_LM_RESERVED1_MASK 0xfffc0000
#define  CSTATS_LM_RESERVED1_SHIFT 18
#define  CSTATS_LM_RESERVED1_MASK_SHIFT(reg) (((reg) & CSTATS_LM_RESERVED1_MASK) >> CSTATS_LM_RESERVED1_SHIFT)
#define  CSTATS_LM_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CSTATS_LM_RESERVED1_MASK) | (((uint32_t)val) << CSTATS_LM_RESERVED1_SHIFT))

#define  CSTATS_LM_LM_MASK 0x3ffff
#define  CSTATS_LM_LM_SHIFT 0
#define  CSTATS_LM_LM_MASK_SHIFT(reg) (((reg) & CSTATS_LM_LM_MASK) >> CSTATS_LM_LM_SHIFT)
#define  CSTATS_LM_LM_REPLACE_VAL(reg,val) (((reg) & ~CSTATS_LM_LM_MASK) | (((uint32_t)val) << CSTATS_LM_LM_SHIFT))

//====================================================================
//Register: Right Margin Register (RM)
//====================================================================

#define  CSTATS_RM_RESERVED1_MASK 0xfffc0000
#define  CSTATS_RM_RESERVED1_SHIFT 18
#define  CSTATS_RM_RESERVED1_MASK_SHIFT(reg) (((reg) & CSTATS_RM_RESERVED1_MASK) >> CSTATS_RM_RESERVED1_SHIFT)
#define  CSTATS_RM_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CSTATS_RM_RESERVED1_MASK) | (((uint32_t)val) << CSTATS_RM_RESERVED1_SHIFT))

#define  CSTATS_RM_RM_MASK 0x3ffff
#define  CSTATS_RM_RM_SHIFT 0
#define  CSTATS_RM_RM_MASK_SHIFT(reg) (((reg) & CSTATS_RM_RM_MASK) >> CSTATS_RM_RM_SHIFT)
#define  CSTATS_RM_RM_REPLACE_VAL(reg,val) (((reg) & ~CSTATS_RM_RM_MASK) | (((uint32_t)val) << CSTATS_RM_RM_SHIFT))

//====================================================================
//Register: Section Width (SW)
//====================================================================

#define  CSTATS_SW_RESERVED1_MASK 0xffffe000
#define  CSTATS_SW_RESERVED1_SHIFT 13
#define  CSTATS_SW_RESERVED1_MASK_SHIFT(reg) (((reg) & CSTATS_SW_RESERVED1_MASK) >> CSTATS_SW_RESERVED1_SHIFT)
#define  CSTATS_SW_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CSTATS_SW_RESERVED1_MASK) | (((uint32_t)val) << CSTATS_SW_RESERVED1_SHIFT))

#define  CSTATS_SW_SW_MASK 0x1fff
#define  CSTATS_SW_SW_SHIFT 0
#define  CSTATS_SW_SW_MASK_SHIFT(reg) (((reg) & CSTATS_SW_SW_MASK) >> CSTATS_SW_SW_SHIFT)
#define  CSTATS_SW_SW_REPLACE_VAL(reg,val) (((reg) & ~CSTATS_SW_SW_MASK) | (((uint32_t)val) << CSTATS_SW_SW_SHIFT))

//====================================================================
//Register: Strip Width (STW)
//====================================================================

#define  CSTATS_STW_RESERVED1_MASK 0xfffc0000
#define  CSTATS_STW_RESERVED1_SHIFT 18
#define  CSTATS_STW_RESERVED1_MASK_SHIFT(reg) (((reg) & CSTATS_STW_RESERVED1_MASK) >> CSTATS_STW_RESERVED1_SHIFT)
#define  CSTATS_STW_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CSTATS_STW_RESERVED1_MASK) | (((uint32_t)val) << CSTATS_STW_RESERVED1_SHIFT))

#define  CSTATS_STW_SW_MASK 0x3ffff
#define  CSTATS_STW_SW_SHIFT 0
#define  CSTATS_STW_SW_MASK_SHIFT(reg) (((reg) & CSTATS_STW_SW_MASK) >> CSTATS_STW_SW_SHIFT)
#define  CSTATS_STW_SW_REPLACE_VAL(reg,val) (((reg) & ~CSTATS_STW_SW_MASK) | (((uint32_t)val) << CSTATS_STW_SW_SHIFT))

//====================================================================
//Register: Threshold Register 1 (TR1)
//====================================================================

#define  CSTATS_TR1_CBH_MASK 0xff000000
#define  CSTATS_TR1_CBH_SHIFT 24
#define  CSTATS_TR1_CBH_MASK_SHIFT(reg) (((reg) & CSTATS_TR1_CBH_MASK) >> CSTATS_TR1_CBH_SHIFT)
#define  CSTATS_TR1_CBH_REPLACE_VAL(reg,val) (((reg) & ~CSTATS_TR1_CBH_MASK) | (((uint32_t)val) << CSTATS_TR1_CBH_SHIFT))

#define  CSTATS_TR1_CBL_MASK 0xff0000
#define  CSTATS_TR1_CBL_SHIFT 16
#define  CSTATS_TR1_CBL_MASK_SHIFT(reg) (((reg) & CSTATS_TR1_CBL_MASK) >> CSTATS_TR1_CBL_SHIFT)
#define  CSTATS_TR1_CBL_REPLACE_VAL(reg,val) (((reg) & ~CSTATS_TR1_CBL_MASK) | (((uint32_t)val) << CSTATS_TR1_CBL_SHIFT))

#define  CSTATS_TR1_CRH_MASK 0xff00
#define  CSTATS_TR1_CRH_SHIFT 8
#define  CSTATS_TR1_CRH_MASK_SHIFT(reg) (((reg) & CSTATS_TR1_CRH_MASK) >> CSTATS_TR1_CRH_SHIFT)
#define  CSTATS_TR1_CRH_REPLACE_VAL(reg,val) (((reg) & ~CSTATS_TR1_CRH_MASK) | (((uint32_t)val) << CSTATS_TR1_CRH_SHIFT))

#define  CSTATS_TR1_CRL_MASK 0xff
#define  CSTATS_TR1_CRL_SHIFT 0
#define  CSTATS_TR1_CRL_MASK_SHIFT(reg) (((reg) & CSTATS_TR1_CRL_MASK) >> CSTATS_TR1_CRL_SHIFT)
#define  CSTATS_TR1_CRL_REPLACE_VAL(reg,val) (((reg) & ~CSTATS_TR1_CRL_MASK) | (((uint32_t)val) << CSTATS_TR1_CRL_SHIFT))

//====================================================================
//Register: Threshold Register 2 (TR2)
//====================================================================

#define  CSTATS_TR2_RESERVED1_MASK 0xff000000
#define  CSTATS_TR2_RESERVED1_SHIFT 24
#define  CSTATS_TR2_RESERVED1_MASK_SHIFT(reg) (((reg) & CSTATS_TR2_RESERVED1_MASK) >> CSTATS_TR2_RESERVED1_SHIFT)
#define  CSTATS_TR2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CSTATS_TR2_RESERVED1_MASK) | (((uint32_t)val) << CSTATS_TR2_RESERVED1_SHIFT))

#define  CSTATS_TR2_RGBT_MASK 0xff0000
#define  CSTATS_TR2_RGBT_SHIFT 16
#define  CSTATS_TR2_RGBT_MASK_SHIFT(reg) (((reg) & CSTATS_TR2_RGBT_MASK) >> CSTATS_TR2_RGBT_SHIFT)
#define  CSTATS_TR2_RGBT_REPLACE_VAL(reg,val) (((reg) & ~CSTATS_TR2_RGBT_MASK) | (((uint32_t)val) << CSTATS_TR2_RGBT_SHIFT))

#define  CSTATS_TR2_WT_MASK 0xff00
#define  CSTATS_TR2_WT_SHIFT 8
#define  CSTATS_TR2_WT_MASK_SHIFT(reg) (((reg) & CSTATS_TR2_WT_MASK) >> CSTATS_TR2_WT_SHIFT)
#define  CSTATS_TR2_WT_REPLACE_VAL(reg,val) (((reg) & ~CSTATS_TR2_WT_MASK) | (((uint32_t)val) << CSTATS_TR2_WT_SHIFT))

#define  CSTATS_TR2_BT_MASK 0xff
#define  CSTATS_TR2_BT_SHIFT 0
#define  CSTATS_TR2_BT_MASK_SHIFT(reg) (((reg) & CSTATS_TR2_BT_MASK) >> CSTATS_TR2_BT_SHIFT)
#define  CSTATS_TR2_BT_REPLACE_VAL(reg,val) (((reg) & ~CSTATS_TR2_BT_MASK) | (((uint32_t)val) << CSTATS_TR2_BT_SHIFT))

//====================================================================
//Register: Strip Black (SBLK)
//====================================================================

#define  CSTATS_SBLK_SBLK_MASK 0xffffffff
#define  CSTATS_SBLK_SBLK_SHIFT 0
#define  CSTATS_SBLK_SBLK_MASK_SHIFT(reg) (((reg) & CSTATS_SBLK_SBLK_MASK) >> CSTATS_SBLK_SBLK_SHIFT)
#define  CSTATS_SBLK_SBLK_REPLACE_VAL(reg,val) (((reg) & ~CSTATS_SBLK_SBLK_MASK) | (((uint32_t)val) << CSTATS_SBLK_SBLK_SHIFT))

//====================================================================
//Register: Strip Grey (SGRY)
//====================================================================

#define  CSTATS_SGRY_SGRY_MASK 0xffffffff
#define  CSTATS_SGRY_SGRY_SHIFT 0
#define  CSTATS_SGRY_SGRY_MASK_SHIFT(reg) (((reg) & CSTATS_SGRY_SGRY_MASK) >> CSTATS_SGRY_SGRY_SHIFT)
#define  CSTATS_SGRY_SGRY_REPLACE_VAL(reg,val) (((reg) & ~CSTATS_SGRY_SGRY_MASK) | (((uint32_t)val) << CSTATS_SGRY_SGRY_SHIFT))

//====================================================================
//Register: Strip Color (SC)
//====================================================================

#define  CSTATS_SC_SC_MASK 0xffffffff
#define  CSTATS_SC_SC_SHIFT 0
#define  CSTATS_SC_SC_MASK_SHIFT(reg) (((reg) & CSTATS_SC_SC_MASK) >> CSTATS_SC_SC_SHIFT)
#define  CSTATS_SC_SC_REPLACE_VAL(reg,val) (((reg) & ~CSTATS_SC_SC_MASK) | (((uint32_t)val) << CSTATS_SC_SC_SHIFT))

//====================================================================
//Register: Configure Register B Write (CFGBW)
//====================================================================

#define  CSTATS_CFGBW_RESERVED1_MASK 0xfffffffc
#define  CSTATS_CFGBW_RESERVED1_SHIFT 2
#define  CSTATS_CFGBW_RESERVED1_MASK_SHIFT(reg) (((reg) & CSTATS_CFGBW_RESERVED1_MASK) >> CSTATS_CFGBW_RESERVED1_SHIFT)
#define  CSTATS_CFGBW_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CSTATS_CFGBW_RESERVED1_MASK) | (((uint32_t)val) << CSTATS_CFGBW_RESERVED1_SHIFT))

#define  CSTATS_CFGBW_BSO_MASK 0x2
#define  CSTATS_CFGBW_BSO_SHIFT 1
#define  CSTATS_CFGBW_BSO_MASK_SHIFT(reg) (((reg) & CSTATS_CFGBW_BSO_MASK) >> CSTATS_CFGBW_BSO_SHIFT)
#define  CSTATS_CFGBW_BSO_REPLACE_VAL(reg,val) (((reg) & ~CSTATS_CFGBW_BSO_MASK) | (((uint32_t)val) << CSTATS_CFGBW_BSO_SHIFT))

#define  CSTATS_CFGBW_HCLR_MASK 0x1
#define  CSTATS_CFGBW_HCLR_SHIFT 0
#define  CSTATS_CFGBW_HCLR_MASK_SHIFT(reg) (((reg) & CSTATS_CFGBW_HCLR_MASK) >> CSTATS_CFGBW_HCLR_SHIFT)
#define  CSTATS_CFGBW_HCLR_REPLACE_VAL(reg,val) (((reg) & ~CSTATS_CFGBW_HCLR_MASK) | (((uint32_t)val) << CSTATS_CFGBW_HCLR_SHIFT))

//====================================================================
//Register: Configure Register B Read (CFGBR)
//====================================================================

#define  CSTATS_CFGBR_RESERVED1_MASK 0xfffffffc
#define  CSTATS_CFGBR_RESERVED1_SHIFT 2
#define  CSTATS_CFGBR_RESERVED1_MASK_SHIFT(reg) (((reg) & CSTATS_CFGBR_RESERVED1_MASK) >> CSTATS_CFGBR_RESERVED1_SHIFT)
#define  CSTATS_CFGBR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CSTATS_CFGBR_RESERVED1_MASK) | (((uint32_t)val) << CSTATS_CFGBR_RESERVED1_SHIFT))

#define  CSTATS_CFGBR_BSO_MASK 0x2
#define  CSTATS_CFGBR_BSO_SHIFT 1
#define  CSTATS_CFGBR_BSO_MASK_SHIFT(reg) (((reg) & CSTATS_CFGBR_BSO_MASK) >> CSTATS_CFGBR_BSO_SHIFT)
#define  CSTATS_CFGBR_BSO_REPLACE_VAL(reg,val) (((reg) & ~CSTATS_CFGBR_BSO_MASK) | (((uint32_t)val) << CSTATS_CFGBR_BSO_SHIFT))

#define  CSTATS_CFGBR_HCLR_MASK 0x1
#define  CSTATS_CFGBR_HCLR_SHIFT 0
#define  CSTATS_CFGBR_HCLR_MASK_SHIFT(reg) (((reg) & CSTATS_CFGBR_HCLR_MASK) >> CSTATS_CFGBR_HCLR_SHIFT)
#define  CSTATS_CFGBR_HCLR_REPLACE_VAL(reg,val) (((reg) & ~CSTATS_CFGBR_HCLR_MASK) | (((uint32_t)val) << CSTATS_CFGBR_HCLR_SHIFT))

//====================================================================
//Register: Ram 0 (RAM0)
//====================================================================

#define  CSTATS_RAM0_D_MASK 0xffffffff
#define  CSTATS_RAM0_D_SHIFT 0
#define  CSTATS_RAM0_D_MASK_SHIFT(reg) (((reg) & CSTATS_RAM0_D_MASK) >> CSTATS_RAM0_D_SHIFT)
#define  CSTATS_RAM0_D_REPLACE_VAL(reg,val) (((reg) & ~CSTATS_RAM0_D_MASK) | (((uint32_t)val) << CSTATS_RAM0_D_SHIFT))

//====================================================================
//Register: Ram 1 (RAM1)
//====================================================================

#define  CSTATS_RAM1_D_MASK 0xffffffff
#define  CSTATS_RAM1_D_SHIFT 0
#define  CSTATS_RAM1_D_MASK_SHIFT(reg) (((reg) & CSTATS_RAM1_D_MASK) >> CSTATS_RAM1_D_SHIFT)
#define  CSTATS_RAM1_D_REPLACE_VAL(reg,val) (((reg) & ~CSTATS_RAM1_D_MASK) | (((uint32_t)val) << CSTATS_RAM1_D_SHIFT))

//====================================================================
//Register: Ram 2 (RAM2)
//====================================================================

#define  CSTATS_RAM2_D_MASK 0xffffffff
#define  CSTATS_RAM2_D_SHIFT 0
#define  CSTATS_RAM2_D_MASK_SHIFT(reg) (((reg) & CSTATS_RAM2_D_MASK) >> CSTATS_RAM2_D_SHIFT)
#define  CSTATS_RAM2_D_REPLACE_VAL(reg,val) (((reg) & ~CSTATS_RAM2_D_MASK) | (((uint32_t)val) << CSTATS_RAM2_D_SHIFT))

//====================================================================
//Register: Ram 3 (RAM3)
//====================================================================

#define  CSTATS_RAM3_RESERVED1_MASK 0xf8000000
#define  CSTATS_RAM3_RESERVED1_SHIFT 27
#define  CSTATS_RAM3_RESERVED1_MASK_SHIFT(reg) (((reg) & CSTATS_RAM3_RESERVED1_MASK) >> CSTATS_RAM3_RESERVED1_SHIFT)
#define  CSTATS_RAM3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CSTATS_RAM3_RESERVED1_MASK) | (((uint32_t)val) << CSTATS_RAM3_RESERVED1_SHIFT))

#define  CSTATS_RAM3_D_MASK 0x7ffffff
#define  CSTATS_RAM3_D_SHIFT 0
#define  CSTATS_RAM3_D_MASK_SHIFT(reg) (((reg) & CSTATS_RAM3_D_MASK) >> CSTATS_RAM3_D_SHIFT)
#define  CSTATS_RAM3_D_REPLACE_VAL(reg,val) (((reg) & ~CSTATS_RAM3_D_MASK) | (((uint32_t)val) << CSTATS_RAM3_D_SHIFT))

//====================================================================
//Register: IP Tagging Revision 0 (REV0)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  CSTATS_REV0_MAJ_MASK 0xffff0000
#define  CSTATS_REV0_MAJ_SHIFT 16
#define  CSTATS_REV0_MAJ_MASK_SHIFT(reg) (((reg) & CSTATS_REV0_MAJ_MASK) >> CSTATS_REV0_MAJ_SHIFT)
#define  CSTATS_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~CSTATS_REV0_MAJ_MASK) | (((uint32_t)val) << CSTATS_REV0_MAJ_SHIFT))

#define  CSTATS_REV0_MID_MASK 0xffff
#define  CSTATS_REV0_MID_SHIFT 0
#define  CSTATS_REV0_MID_MASK_SHIFT(reg) (((reg) & CSTATS_REV0_MID_MASK) >> CSTATS_REV0_MID_SHIFT)
#define  CSTATS_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~CSTATS_REV0_MID_MASK) | (((uint32_t)val) << CSTATS_REV0_MID_SHIFT))

//====================================================================
//Register: IP Tagging Revision 1 (REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  CSTATS_REV1_RESERVED1_MASK 0xffff0000
#define  CSTATS_REV1_RESERVED1_SHIFT 16
#define  CSTATS_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & CSTATS_REV1_RESERVED1_MASK) >> CSTATS_REV1_RESERVED1_SHIFT)
#define  CSTATS_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CSTATS_REV1_RESERVED1_MASK) | (((uint32_t)val) << CSTATS_REV1_RESERVED1_SHIFT))

#define  CSTATS_REV1_CFG_MASK 0xffff
#define  CSTATS_REV1_CFG_SHIFT 0
#define  CSTATS_REV1_CFG_MASK_SHIFT(reg) (((reg) & CSTATS_REV1_CFG_MASK) >> CSTATS_REV1_CFG_SHIFT)
#define  CSTATS_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~CSTATS_REV1_CFG_MASK) | (((uint32_t)val) << CSTATS_REV1_CFG_SHIFT))

//====================================================================
//
//Register File: PIE Object Type Merge and Background Replace (OTMARB)
/** \brief (rev 0 . 1 . 0 . 1)
    Registers for the Object Type Merge and Replace Background Color block*/
//
//====================================================================

//====================================================================
//Register: Configuration Register (Config)
/** \brief Register used to configure the the Object Type Merge and Replace Background Color block.*/
//====================================================================

#define  OTMARB_CONFIG_BRENABLE_MASK 0xffff0000
#define  OTMARB_CONFIG_BRENABLE_SHIFT 16
#define  OTMARB_CONFIG_BRENABLE_MASK_SHIFT(reg) (((reg) & OTMARB_CONFIG_BRENABLE_MASK) >> OTMARB_CONFIG_BRENABLE_SHIFT)
#define  OTMARB_CONFIG_BRENABLE_REPLACE_VAL(reg,val) (((reg) & ~OTMARB_CONFIG_BRENABLE_MASK) | (((uint32_t)val) << OTMARB_CONFIG_BRENABLE_SHIFT))

#define  OTMARB_CONFIG_RESERVED1_MASK 0xfffe
#define  OTMARB_CONFIG_RESERVED1_SHIFT 1
#define  OTMARB_CONFIG_RESERVED1_MASK_SHIFT(reg) (((reg) & OTMARB_CONFIG_RESERVED1_MASK) >> OTMARB_CONFIG_RESERVED1_SHIFT)
#define  OTMARB_CONFIG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~OTMARB_CONFIG_RESERVED1_MASK) | (((uint32_t)val) << OTMARB_CONFIG_RESERVED1_SHIFT))

#define  OTMARB_CONFIG_BYPASS_MASK 0x1
#define  OTMARB_CONFIG_BYPASS_SHIFT 0
#define  OTMARB_CONFIG_BYPASS_MASK_SHIFT(reg) (((reg) & OTMARB_CONFIG_BYPASS_MASK) >> OTMARB_CONFIG_BYPASS_SHIFT)
#define  OTMARB_CONFIG_BYPASS_REPLACE_VAL(reg,val) (((reg) & ~OTMARB_CONFIG_BYPASS_MASK) | (((uint32_t)val) << OTMARB_CONFIG_BYPASS_SHIFT))

//====================================================================
//Register: Background Color Replacement Value (BGColor)
/** \brief This register should be programmed with the value that will be used to replace the value
      of any pixels that have an object type which has background replacement enabled in the
      BREnable field of the Config register.*/
//====================================================================

#define  OTMARB_BGCOLOR_RESERVED1_MASK 0xc0000000
#define  OTMARB_BGCOLOR_RESERVED1_SHIFT 30
#define  OTMARB_BGCOLOR_RESERVED1_MASK_SHIFT(reg) (((reg) & OTMARB_BGCOLOR_RESERVED1_MASK) >> OTMARB_BGCOLOR_RESERVED1_SHIFT)
#define  OTMARB_BGCOLOR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~OTMARB_BGCOLOR_RESERVED1_MASK) | (((uint32_t)val) << OTMARB_BGCOLOR_RESERVED1_SHIFT))

#define  OTMARB_BGCOLOR_CH0_MASK 0x3ff00000
#define  OTMARB_BGCOLOR_CH0_SHIFT 20
#define  OTMARB_BGCOLOR_CH0_MASK_SHIFT(reg) (((reg) & OTMARB_BGCOLOR_CH0_MASK) >> OTMARB_BGCOLOR_CH0_SHIFT)
#define  OTMARB_BGCOLOR_CH0_REPLACE_VAL(reg,val) (((reg) & ~OTMARB_BGCOLOR_CH0_MASK) | (((uint32_t)val) << OTMARB_BGCOLOR_CH0_SHIFT))

#define  OTMARB_BGCOLOR_CH1_MASK 0xffc00
#define  OTMARB_BGCOLOR_CH1_SHIFT 10
#define  OTMARB_BGCOLOR_CH1_MASK_SHIFT(reg) (((reg) & OTMARB_BGCOLOR_CH1_MASK) >> OTMARB_BGCOLOR_CH1_SHIFT)
#define  OTMARB_BGCOLOR_CH1_REPLACE_VAL(reg,val) (((reg) & ~OTMARB_BGCOLOR_CH1_MASK) | (((uint32_t)val) << OTMARB_BGCOLOR_CH1_SHIFT))

#define  OTMARB_BGCOLOR_CH2_MASK 0x3ff
#define  OTMARB_BGCOLOR_CH2_SHIFT 0
#define  OTMARB_BGCOLOR_CH2_MASK_SHIFT(reg) (((reg) & OTMARB_BGCOLOR_CH2_MASK) >> OTMARB_BGCOLOR_CH2_SHIFT)
#define  OTMARB_BGCOLOR_CH2_REPLACE_VAL(reg,val) (((reg) & ~OTMARB_BGCOLOR_CH2_MASK) | (((uint32_t)val) << OTMARB_BGCOLOR_CH2_SHIFT))

//====================================================================
//Register: OTMARB Interrupt Enable Register (IntEnable)
/** \brief This register is used to enable/disable the OTMARB interrupt.*/
//====================================================================

#define  OTMARB_INTENABLE_RESERVED1_MASK 0xfffffffe
#define  OTMARB_INTENABLE_RESERVED1_SHIFT 1
#define  OTMARB_INTENABLE_RESERVED1_MASK_SHIFT(reg) (((reg) & OTMARB_INTENABLE_RESERVED1_MASK) >> OTMARB_INTENABLE_RESERVED1_SHIFT)
#define  OTMARB_INTENABLE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~OTMARB_INTENABLE_RESERVED1_MASK) | (((uint32_t)val) << OTMARB_INTENABLE_RESERVED1_SHIFT))

#define  OTMARB_INTENABLE_MISMATCHINTEN_MASK 0x1
#define  OTMARB_INTENABLE_MISMATCHINTEN_SHIFT 0
#define  OTMARB_INTENABLE_MISMATCHINTEN_MASK_SHIFT(reg) (((reg) & OTMARB_INTENABLE_MISMATCHINTEN_MASK) >> OTMARB_INTENABLE_MISMATCHINTEN_SHIFT)
#define  OTMARB_INTENABLE_MISMATCHINTEN_REPLACE_VAL(reg,val) (((reg) & ~OTMARB_INTENABLE_MISMATCHINTEN_MASK) | (((uint32_t)val) << OTMARB_INTENABLE_MISMATCHINTEN_SHIFT))

//====================================================================
//Register: OTMARB Interrupt Acknowledge Register (IntAck)
/** \brief This register is used to acknowledge the OTMARB interrupt.*/
//====================================================================

#define  OTMARB_INTACK_RESERVED1_MASK 0xfffffffe
#define  OTMARB_INTACK_RESERVED1_SHIFT 1
#define  OTMARB_INTACK_RESERVED1_MASK_SHIFT(reg) (((reg) & OTMARB_INTACK_RESERVED1_MASK) >> OTMARB_INTACK_RESERVED1_SHIFT)
#define  OTMARB_INTACK_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~OTMARB_INTACK_RESERVED1_MASK) | (((uint32_t)val) << OTMARB_INTACK_RESERVED1_SHIFT))

#define  OTMARB_INTACK_MISMATCHINTACK_MASK 0x1
#define  OTMARB_INTACK_MISMATCHINTACK_SHIFT 0
#define  OTMARB_INTACK_MISMATCHINTACK_MASK_SHIFT(reg) (((reg) & OTMARB_INTACK_MISMATCHINTACK_MASK) >> OTMARB_INTACK_MISMATCHINTACK_SHIFT)
#define  OTMARB_INTACK_MISMATCHINTACK_REPLACE_VAL(reg,val) (((reg) & ~OTMARB_INTACK_MISMATCHINTACK_MASK) | (((uint32_t)val) << OTMARB_INTACK_MISMATCHINTACK_SHIFT))

//====================================================================
//Register: OTMARB Interrupt Status Register (IntStat)
/** \brief This register provides the raw interrupt status, prior to masking by the IntEn register bit."*/
//====================================================================

#define  OTMARB_INTSTAT_RESERVED1_MASK 0xfffffffe
#define  OTMARB_INTSTAT_RESERVED1_SHIFT 1
#define  OTMARB_INTSTAT_RESERVED1_MASK_SHIFT(reg) (((reg) & OTMARB_INTSTAT_RESERVED1_MASK) >> OTMARB_INTSTAT_RESERVED1_SHIFT)
#define  OTMARB_INTSTAT_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~OTMARB_INTSTAT_RESERVED1_MASK) | (((uint32_t)val) << OTMARB_INTSTAT_RESERVED1_SHIFT))

#define  OTMARB_INTSTAT_MISMATCHINTPEND_MASK 0x1
#define  OTMARB_INTSTAT_MISMATCHINTPEND_SHIFT 0
#define  OTMARB_INTSTAT_MISMATCHINTPEND_MASK_SHIFT(reg) (((reg) & OTMARB_INTSTAT_MISMATCHINTPEND_MASK) >> OTMARB_INTSTAT_MISMATCHINTPEND_SHIFT)
#define  OTMARB_INTSTAT_MISMATCHINTPEND_REPLACE_VAL(reg,val) (((reg) & ~OTMARB_INTSTAT_MISMATCHINTPEND_MASK) | (((uint32_t)val) << OTMARB_INTSTAT_MISMATCHINTPEND_SHIFT))

//====================================================================
//Register: OTMARB Interrupt Test Register (IntTest)
/** \brief This register provides firmware with the means to manually generate a OTMARB interrupt."*/
//====================================================================

#define  OTMARB_INTTEST_RESERVED1_MASK 0xfffffffe
#define  OTMARB_INTTEST_RESERVED1_SHIFT 1
#define  OTMARB_INTTEST_RESERVED1_MASK_SHIFT(reg) (((reg) & OTMARB_INTTEST_RESERVED1_MASK) >> OTMARB_INTTEST_RESERVED1_SHIFT)
#define  OTMARB_INTTEST_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~OTMARB_INTTEST_RESERVED1_MASK) | (((uint32_t)val) << OTMARB_INTTEST_RESERVED1_SHIFT))

#define  OTMARB_INTTEST_MISMATCHINTTEST_MASK 0x1
#define  OTMARB_INTTEST_MISMATCHINTTEST_SHIFT 0
#define  OTMARB_INTTEST_MISMATCHINTTEST_MASK_SHIFT(reg) (((reg) & OTMARB_INTTEST_MISMATCHINTTEST_MASK) >> OTMARB_INTTEST_MISMATCHINTTEST_SHIFT)
#define  OTMARB_INTTEST_MISMATCHINTTEST_REPLACE_VAL(reg,val) (((reg) & ~OTMARB_INTTEST_MISMATCHINTTEST_MASK) | (((uint32_t)val) << OTMARB_INTTEST_MISMATCHINTTEST_SHIFT))

//====================================================================
//Register: IP Tagging Revision 0 (REV0)
/** \brief Provide means for firmware to read IP tagging information.
      This register of particular interest to firmware.*/
//====================================================================

#define  OTMARB_REV0_MAJ_MASK 0xffff0000
#define  OTMARB_REV0_MAJ_SHIFT 16
#define  OTMARB_REV0_MAJ_MASK_SHIFT(reg) (((reg) & OTMARB_REV0_MAJ_MASK) >> OTMARB_REV0_MAJ_SHIFT)
#define  OTMARB_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~OTMARB_REV0_MAJ_MASK) | (((uint32_t)val) << OTMARB_REV0_MAJ_SHIFT))

#define  OTMARB_REV0_MID_MASK 0xffff
#define  OTMARB_REV0_MID_SHIFT 0
#define  OTMARB_REV0_MID_MASK_SHIFT(reg) (((reg) & OTMARB_REV0_MID_MASK) >> OTMARB_REV0_MID_SHIFT)
#define  OTMARB_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~OTMARB_REV0_MID_MASK) | (((uint32_t)val) << OTMARB_REV0_MID_SHIFT))

//====================================================================
//Register: IP Tagging Revision 1 (REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  OTMARB_REV1_RESERVED1_MASK 0xffff0000
#define  OTMARB_REV1_RESERVED1_SHIFT 16
#define  OTMARB_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & OTMARB_REV1_RESERVED1_MASK) >> OTMARB_REV1_RESERVED1_SHIFT)
#define  OTMARB_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~OTMARB_REV1_RESERVED1_MASK) | (((uint32_t)val) << OTMARB_REV1_RESERVED1_SHIFT))

#define  OTMARB_REV1_CFG_MASK 0xffff
#define  OTMARB_REV1_CFG_SHIFT 0
#define  OTMARB_REV1_CFG_MASK_SHIFT(reg) (((reg) & OTMARB_REV1_CFG_MASK) >> OTMARB_REV1_CFG_SHIFT)
#define  OTMARB_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~OTMARB_REV1_CFG_MASK) | (((uint32_t)val) << OTMARB_REV1_CFG_SHIFT))

//====================================================================
//
//Register File: PIE Neutral Gray Adjust (NGAdjust)
/** \brief Register Descriptions for the 1 NGAdjust block
    (rev 0 . 4 . 0 . 4)*/
//
//====================================================================

//====================================================================
//Register: NGA Configuration Register (Config)
/** \brief General configuration register for NGAdjust block.*/
//====================================================================

#define  NGADJUST_CONFIG_OTENABLE_MASK 0xffff0000
#define  NGADJUST_CONFIG_OTENABLE_SHIFT 16
#define  NGADJUST_CONFIG_OTENABLE_MASK_SHIFT(reg) (((reg) & NGADJUST_CONFIG_OTENABLE_MASK) >> NGADJUST_CONFIG_OTENABLE_SHIFT)
#define  NGADJUST_CONFIG_OTENABLE_REPLACE_VAL(reg,val) (((reg) & ~NGADJUST_CONFIG_OTENABLE_MASK) | (((uint32_t)val) << NGADJUST_CONFIG_OTENABLE_SHIFT))

#define  NGADJUST_CONFIG_RESERVED1_MASK 0xfff8
#define  NGADJUST_CONFIG_RESERVED1_SHIFT 3
#define  NGADJUST_CONFIG_RESERVED1_MASK_SHIFT(reg) (((reg) & NGADJUST_CONFIG_RESERVED1_MASK) >> NGADJUST_CONFIG_RESERVED1_SHIFT)
#define  NGADJUST_CONFIG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~NGADJUST_CONFIG_RESERVED1_MASK) | (((uint32_t)val) << NGADJUST_CONFIG_RESERVED1_SHIFT))

#define  NGADJUST_CONFIG_METHOD_MASK 0x4
#define  NGADJUST_CONFIG_METHOD_SHIFT 2
#define  NGADJUST_CONFIG_METHOD_MASK_SHIFT(reg) (((reg) & NGADJUST_CONFIG_METHOD_MASK) >> NGADJUST_CONFIG_METHOD_SHIFT)
#define  NGADJUST_CONFIG_METHOD_REPLACE_VAL(reg,val) (((reg) & ~NGADJUST_CONFIG_METHOD_MASK) | (((uint32_t)val) << NGADJUST_CONFIG_METHOD_SHIFT))

#define  NGADJUST_CONFIG_CPU_ACCESS_MASK 0x2
#define  NGADJUST_CONFIG_CPU_ACCESS_SHIFT 1
#define  NGADJUST_CONFIG_CPU_ACCESS_MASK_SHIFT(reg) (((reg) & NGADJUST_CONFIG_CPU_ACCESS_MASK) >> NGADJUST_CONFIG_CPU_ACCESS_SHIFT)
#define  NGADJUST_CONFIG_CPU_ACCESS_REPLACE_VAL(reg,val) (((reg) & ~NGADJUST_CONFIG_CPU_ACCESS_MASK) | (((uint32_t)val) << NGADJUST_CONFIG_CPU_ACCESS_SHIFT))

#define  NGADJUST_CONFIG_BYPASS_MASK 0x1
#define  NGADJUST_CONFIG_BYPASS_SHIFT 0
#define  NGADJUST_CONFIG_BYPASS_MASK_SHIFT(reg) (((reg) & NGADJUST_CONFIG_BYPASS_MASK) >> NGADJUST_CONFIG_BYPASS_SHIFT)
#define  NGADJUST_CONFIG_BYPASS_REPLACE_VAL(reg,val) (((reg) & ~NGADJUST_CONFIG_BYPASS_MASK) | (((uint32_t)val) << NGADJUST_CONFIG_BYPASS_SHIFT))

//====================================================================
//Register: IP Tagging Revision 0 (REV0)
/** \brief Provide means for firmware to read IP tagging information.
      This register of particular interest to firmware.*/
//====================================================================

#define  NGADJUST_REV0_MAJ_MASK 0xffff0000
#define  NGADJUST_REV0_MAJ_SHIFT 16
#define  NGADJUST_REV0_MAJ_MASK_SHIFT(reg) (((reg) & NGADJUST_REV0_MAJ_MASK) >> NGADJUST_REV0_MAJ_SHIFT)
#define  NGADJUST_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~NGADJUST_REV0_MAJ_MASK) | (((uint32_t)val) << NGADJUST_REV0_MAJ_SHIFT))

#define  NGADJUST_REV0_MID_MASK 0xffff
#define  NGADJUST_REV0_MID_SHIFT 0
#define  NGADJUST_REV0_MID_MASK_SHIFT(reg) (((reg) & NGADJUST_REV0_MID_MASK) >> NGADJUST_REV0_MID_SHIFT)
#define  NGADJUST_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~NGADJUST_REV0_MID_MASK) | (((uint32_t)val) << NGADJUST_REV0_MID_SHIFT))

//====================================================================
//Register: IP Tagging Revision 1 (REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  NGADJUST_REV1_RESERVED1_MASK 0xffff0000
#define  NGADJUST_REV1_RESERVED1_SHIFT 16
#define  NGADJUST_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & NGADJUST_REV1_RESERVED1_MASK) >> NGADJUST_REV1_RESERVED1_SHIFT)
#define  NGADJUST_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~NGADJUST_REV1_RESERVED1_MASK) | (((uint32_t)val) << NGADJUST_REV1_RESERVED1_SHIFT))

#define  NGADJUST_REV1_CFG_MASK 0xffff
#define  NGADJUST_REV1_CFG_SHIFT 0
#define  NGADJUST_REV1_CFG_MASK_SHIFT(reg) (((reg) & NGADJUST_REV1_CFG_MASK) >> NGADJUST_REV1_CFG_SHIFT)
#define  NGADJUST_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~NGADJUST_REV1_CFG_MASK) | (((uint32_t)val) << NGADJUST_REV1_CFG_SHIFT))

//====================================================================
//Register: Look Up Table Access (LUTAccess)
/** \brief <p>The LUT, look up table, is used for Neutral Gray Adjust. The processor requires
    Read/Write access to the LUT to set up the values needed. The CPU Access bit must be set in
    the NGA Configuration register in order to access the LUTs. The LUT values have a smaller
    width than the data path, since they are intended to shift the incoming pixels somewhat and
    not over their entire value range.</p>
    <p>Note that the processor view of the LUT is 256 registers (1024 for 10-bit data
    paths), word addressed.</p>*/
//====================================================================

#define  NGADJUST_LUTACCESS_RESERVED1_MASK 0xffff0000
#define  NGADJUST_LUTACCESS_RESERVED1_SHIFT 16
#define  NGADJUST_LUTACCESS_RESERVED1_MASK_SHIFT(reg) (((reg) & NGADJUST_LUTACCESS_RESERVED1_MASK) >> NGADJUST_LUTACCESS_RESERVED1_SHIFT)
#define  NGADJUST_LUTACCESS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~NGADJUST_LUTACCESS_RESERVED1_MASK) | (((uint32_t)val) << NGADJUST_LUTACCESS_RESERVED1_SHIFT))

#define  NGADJUST_LUTACCESS_C1_MASK 0xff00
#define  NGADJUST_LUTACCESS_C1_SHIFT 8
#define  NGADJUST_LUTACCESS_C1_MASK_SHIFT(reg) (((reg) & NGADJUST_LUTACCESS_C1_MASK) >> NGADJUST_LUTACCESS_C1_SHIFT)
#define  NGADJUST_LUTACCESS_C1_REPLACE_VAL(reg,val) (((reg) & ~NGADJUST_LUTACCESS_C1_MASK) | (((uint32_t)val) << NGADJUST_LUTACCESS_C1_SHIFT))

#define  NGADJUST_LUTACCESS_C2_MASK 0xff
#define  NGADJUST_LUTACCESS_C2_SHIFT 0
#define  NGADJUST_LUTACCESS_C2_MASK_SHIFT(reg) (((reg) & NGADJUST_LUTACCESS_C2_MASK) >> NGADJUST_LUTACCESS_C2_SHIFT)
#define  NGADJUST_LUTACCESS_C2_REPLACE_VAL(reg,val) (((reg) & ~NGADJUST_LUTACCESS_C2_MASK) | (((uint32_t)val) << NGADJUST_LUTACCESS_C2_SHIFT))

//====================================================================
//
//Register File: PIE Is Tone (ISTONE)
/** \brief (rev 0 . 3 . 2 . 0)
    Top-level register file for the IsTone block*/
//
//====================================================================

//====================================================================
//Register: IsTone Control Register (IsCtrl)
/** \brief This register contains control bits for the tone detection block.*/
//====================================================================

#define  ISTONE_ISCTRL_RESERVED1_MASK 0xffffffe0
#define  ISTONE_ISCTRL_RESERVED1_SHIFT 5
#define  ISTONE_ISCTRL_RESERVED1_MASK_SHIFT(reg) (((reg) & ISTONE_ISCTRL_RESERVED1_MASK) >> ISTONE_ISCTRL_RESERVED1_SHIFT)
#define  ISTONE_ISCTRL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ISTONE_ISCTRL_RESERVED1_MASK) | (((uint32_t)val) << ISTONE_ISCTRL_RESERVED1_SHIFT))

#define  ISTONE_ISCTRL_BYPASSALL_MASK 0x10
#define  ISTONE_ISCTRL_BYPASSALL_SHIFT 4
#define  ISTONE_ISCTRL_BYPASSALL_MASK_SHIFT(reg) (((reg) & ISTONE_ISCTRL_BYPASSALL_MASK) >> ISTONE_ISCTRL_BYPASSALL_SHIFT)
#define  ISTONE_ISCTRL_BYPASSALL_REPLACE_VAL(reg,val) (((reg) & ~ISTONE_ISCTRL_BYPASSALL_MASK) | (((uint32_t)val) << ISTONE_ISCTRL_BYPASSALL_SHIFT))

#define  ISTONE_ISCTRL_RESERVED2_MASK 0xe
#define  ISTONE_ISCTRL_RESERVED2_SHIFT 1
#define  ISTONE_ISCTRL_RESERVED2_MASK_SHIFT(reg) (((reg) & ISTONE_ISCTRL_RESERVED2_MASK) >> ISTONE_ISCTRL_RESERVED2_SHIFT)
#define  ISTONE_ISCTRL_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~ISTONE_ISCTRL_RESERVED2_MASK) | (((uint32_t)val) << ISTONE_ISCTRL_RESERVED2_SHIFT))

#define  ISTONE_ISCTRL_ISTONE_EN_MASK 0x1
#define  ISTONE_ISCTRL_ISTONE_EN_SHIFT 0
#define  ISTONE_ISCTRL_ISTONE_EN_MASK_SHIFT(reg) (((reg) & ISTONE_ISCTRL_ISTONE_EN_MASK) >> ISTONE_ISCTRL_ISTONE_EN_SHIFT)
#define  ISTONE_ISCTRL_ISTONE_EN_REPLACE_VAL(reg,val) (((reg) & ~ISTONE_ISCTRL_ISTONE_EN_MASK) | (((uint32_t)val) << ISTONE_ISCTRL_ISTONE_EN_SHIFT))

//====================================================================
//Register: Luminance Thresholds Register (IsLumThresh)
/** \brief This register contains the 2 different sets of luminance channel thresholds that the Y
      channel must pass for the tone detection logic.*/
//====================================================================

#define  ISTONE_ISLUMTHRESH_YTHRESH_MAX_MASK 0xff000000
#define  ISTONE_ISLUMTHRESH_YTHRESH_MAX_SHIFT 24
#define  ISTONE_ISLUMTHRESH_YTHRESH_MAX_MASK_SHIFT(reg) (((reg) & ISTONE_ISLUMTHRESH_YTHRESH_MAX_MASK) >> ISTONE_ISLUMTHRESH_YTHRESH_MAX_SHIFT)
#define  ISTONE_ISLUMTHRESH_YTHRESH_MAX_REPLACE_VAL(reg,val) (((reg) & ~ISTONE_ISLUMTHRESH_YTHRESH_MAX_MASK) | (((uint32_t)val) << ISTONE_ISLUMTHRESH_YTHRESH_MAX_SHIFT))

#define  ISTONE_ISLUMTHRESH_YTHRESH_MIN_MASK 0xff0000
#define  ISTONE_ISLUMTHRESH_YTHRESH_MIN_SHIFT 16
#define  ISTONE_ISLUMTHRESH_YTHRESH_MIN_MASK_SHIFT(reg) (((reg) & ISTONE_ISLUMTHRESH_YTHRESH_MIN_MASK) >> ISTONE_ISLUMTHRESH_YTHRESH_MIN_SHIFT)
#define  ISTONE_ISLUMTHRESH_YTHRESH_MIN_REPLACE_VAL(reg,val) (((reg) & ~ISTONE_ISLUMTHRESH_YTHRESH_MIN_MASK) | (((uint32_t)val) << ISTONE_ISLUMTHRESH_YTHRESH_MIN_SHIFT))

#define  ISTONE_ISLUMTHRESH_YMAX_MASK 0xff00
#define  ISTONE_ISLUMTHRESH_YMAX_SHIFT 8
#define  ISTONE_ISLUMTHRESH_YMAX_MASK_SHIFT(reg) (((reg) & ISTONE_ISLUMTHRESH_YMAX_MASK) >> ISTONE_ISLUMTHRESH_YMAX_SHIFT)
#define  ISTONE_ISLUMTHRESH_YMAX_REPLACE_VAL(reg,val) (((reg) & ~ISTONE_ISLUMTHRESH_YMAX_MASK) | (((uint32_t)val) << ISTONE_ISLUMTHRESH_YMAX_SHIFT))

#define  ISTONE_ISLUMTHRESH_YMIN_MASK 0xff
#define  ISTONE_ISLUMTHRESH_YMIN_SHIFT 0
#define  ISTONE_ISLUMTHRESH_YMIN_MASK_SHIFT(reg) (((reg) & ISTONE_ISLUMTHRESH_YMIN_MASK) >> ISTONE_ISLUMTHRESH_YMIN_SHIFT)
#define  ISTONE_ISLUMTHRESH_YMIN_REPLACE_VAL(reg,val) (((reg) & ~ISTONE_ISLUMTHRESH_YMIN_MASK) | (((uint32_t)val) << ISTONE_ISLUMTHRESH_YMIN_SHIFT))

//====================================================================
//Register: Chrominance Thresholds Register (IsChromThresh)
/** \brief This register contains the chrominance channel thresholds that the Cr and Cb channels must
      pass for the tone detection logic.*/
//====================================================================

#define  ISTONE_ISCHROMTHRESH_CRMAX_MASK 0xff000000
#define  ISTONE_ISCHROMTHRESH_CRMAX_SHIFT 24
#define  ISTONE_ISCHROMTHRESH_CRMAX_MASK_SHIFT(reg) (((reg) & ISTONE_ISCHROMTHRESH_CRMAX_MASK) >> ISTONE_ISCHROMTHRESH_CRMAX_SHIFT)
#define  ISTONE_ISCHROMTHRESH_CRMAX_REPLACE_VAL(reg,val) (((reg) & ~ISTONE_ISCHROMTHRESH_CRMAX_MASK) | (((uint32_t)val) << ISTONE_ISCHROMTHRESH_CRMAX_SHIFT))

#define  ISTONE_ISCHROMTHRESH_CRMIN_MASK 0xff0000
#define  ISTONE_ISCHROMTHRESH_CRMIN_SHIFT 16
#define  ISTONE_ISCHROMTHRESH_CRMIN_MASK_SHIFT(reg) (((reg) & ISTONE_ISCHROMTHRESH_CRMIN_MASK) >> ISTONE_ISCHROMTHRESH_CRMIN_SHIFT)
#define  ISTONE_ISCHROMTHRESH_CRMIN_REPLACE_VAL(reg,val) (((reg) & ~ISTONE_ISCHROMTHRESH_CRMIN_MASK) | (((uint32_t)val) << ISTONE_ISCHROMTHRESH_CRMIN_SHIFT))

#define  ISTONE_ISCHROMTHRESH_CBMAX_MASK 0xff00
#define  ISTONE_ISCHROMTHRESH_CBMAX_SHIFT 8
#define  ISTONE_ISCHROMTHRESH_CBMAX_MASK_SHIFT(reg) (((reg) & ISTONE_ISCHROMTHRESH_CBMAX_MASK) >> ISTONE_ISCHROMTHRESH_CBMAX_SHIFT)
#define  ISTONE_ISCHROMTHRESH_CBMAX_REPLACE_VAL(reg,val) (((reg) & ~ISTONE_ISCHROMTHRESH_CBMAX_MASK) | (((uint32_t)val) << ISTONE_ISCHROMTHRESH_CBMAX_SHIFT))

#define  ISTONE_ISCHROMTHRESH_CBMIN_MASK 0xff
#define  ISTONE_ISCHROMTHRESH_CBMIN_SHIFT 0
#define  ISTONE_ISCHROMTHRESH_CBMIN_MASK_SHIFT(reg) (((reg) & ISTONE_ISCHROMTHRESH_CBMIN_MASK) >> ISTONE_ISCHROMTHRESH_CBMIN_SHIFT)
#define  ISTONE_ISCHROMTHRESH_CBMIN_REPLACE_VAL(reg,val) (((reg) & ~ISTONE_ISCHROMTHRESH_CBMIN_MASK) | (((uint32_t)val) << ISTONE_ISCHROMTHRESH_CBMIN_SHIFT))

//====================================================================
//Register: Rotation Matrix Coefficient Register (IsRotCoeff)
/** \brief This register contains the 4 chrominance rotation matrix coefficients to be used in the
      tone detection calculations.
      These values must be written prior to enabling IsTone function for proper operation.*/
//====================================================================

#define  ISTONE_ISROTCOEFF_ROT22_MASK 0xff000000
#define  ISTONE_ISROTCOEFF_ROT22_SHIFT 24
#define  ISTONE_ISROTCOEFF_ROT22_MASK_SHIFT(reg) (((reg) & ISTONE_ISROTCOEFF_ROT22_MASK) >> ISTONE_ISROTCOEFF_ROT22_SHIFT)
#define  ISTONE_ISROTCOEFF_ROT22_REPLACE_VAL(reg,val) (((reg) & ~ISTONE_ISROTCOEFF_ROT22_MASK) | (((uint32_t)val) << ISTONE_ISROTCOEFF_ROT22_SHIFT))

#define  ISTONE_ISROTCOEFF_ROT21_MASK 0xff0000
#define  ISTONE_ISROTCOEFF_ROT21_SHIFT 16
#define  ISTONE_ISROTCOEFF_ROT21_MASK_SHIFT(reg) (((reg) & ISTONE_ISROTCOEFF_ROT21_MASK) >> ISTONE_ISROTCOEFF_ROT21_SHIFT)
#define  ISTONE_ISROTCOEFF_ROT21_REPLACE_VAL(reg,val) (((reg) & ~ISTONE_ISROTCOEFF_ROT21_MASK) | (((uint32_t)val) << ISTONE_ISROTCOEFF_ROT21_SHIFT))

#define  ISTONE_ISROTCOEFF_ROT12_MASK 0xff00
#define  ISTONE_ISROTCOEFF_ROT12_SHIFT 8
#define  ISTONE_ISROTCOEFF_ROT12_MASK_SHIFT(reg) (((reg) & ISTONE_ISROTCOEFF_ROT12_MASK) >> ISTONE_ISROTCOEFF_ROT12_SHIFT)
#define  ISTONE_ISROTCOEFF_ROT12_REPLACE_VAL(reg,val) (((reg) & ~ISTONE_ISROTCOEFF_ROT12_MASK) | (((uint32_t)val) << ISTONE_ISROTCOEFF_ROT12_SHIFT))

#define  ISTONE_ISROTCOEFF_ROT11_MASK 0xff
#define  ISTONE_ISROTCOEFF_ROT11_SHIFT 0
#define  ISTONE_ISROTCOEFF_ROT11_MASK_SHIFT(reg) (((reg) & ISTONE_ISROTCOEFF_ROT11_MASK) >> ISTONE_ISROTCOEFF_ROT11_SHIFT)
#define  ISTONE_ISROTCOEFF_ROT11_REPLACE_VAL(reg,val) (((reg) & ~ISTONE_ISROTCOEFF_ROT11_MASK) | (((uint32_t)val) << ISTONE_ISROTCOEFF_ROT11_SHIFT))

//====================================================================
//Register: Rotation Offset Register (IsRotOffst)
/** \brief This register contains the 2 rotation matix offset values. These values must be written
      prior to enabling IsTone for proper operation.*/
//====================================================================

#define  ISTONE_ISROTOFFST_RESERVED1_MASK 0xfe000000
#define  ISTONE_ISROTOFFST_RESERVED1_SHIFT 25
#define  ISTONE_ISROTOFFST_RESERVED1_MASK_SHIFT(reg) (((reg) & ISTONE_ISROTOFFST_RESERVED1_MASK) >> ISTONE_ISROTOFFST_RESERVED1_SHIFT)
#define  ISTONE_ISROTOFFST_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ISTONE_ISROTOFFST_RESERVED1_MASK) | (((uint32_t)val) << ISTONE_ISROTOFFST_RESERVED1_SHIFT))

#define  ISTONE_ISROTOFFST_DIFFY_MASK 0x1ff0000
#define  ISTONE_ISROTOFFST_DIFFY_SHIFT 16
#define  ISTONE_ISROTOFFST_DIFFY_MASK_SHIFT(reg) (((reg) & ISTONE_ISROTOFFST_DIFFY_MASK) >> ISTONE_ISROTOFFST_DIFFY_SHIFT)
#define  ISTONE_ISROTOFFST_DIFFY_REPLACE_VAL(reg,val) (((reg) & ~ISTONE_ISROTOFFST_DIFFY_MASK) | (((uint32_t)val) << ISTONE_ISROTOFFST_DIFFY_SHIFT))

#define  ISTONE_ISROTOFFST_RESERVED2_MASK 0xfe00
#define  ISTONE_ISROTOFFST_RESERVED2_SHIFT 9
#define  ISTONE_ISROTOFFST_RESERVED2_MASK_SHIFT(reg) (((reg) & ISTONE_ISROTOFFST_RESERVED2_MASK) >> ISTONE_ISROTOFFST_RESERVED2_SHIFT)
#define  ISTONE_ISROTOFFST_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~ISTONE_ISROTOFFST_RESERVED2_MASK) | (((uint32_t)val) << ISTONE_ISROTOFFST_RESERVED2_SHIFT))

#define  ISTONE_ISROTOFFST_DIFFX_MASK 0x1ff
#define  ISTONE_ISROTOFFST_DIFFX_SHIFT 0
#define  ISTONE_ISROTOFFST_DIFFX_MASK_SHIFT(reg) (((reg) & ISTONE_ISROTOFFST_DIFFX_MASK) >> ISTONE_ISROTOFFST_DIFFX_SHIFT)
#define  ISTONE_ISROTOFFST_DIFFX_REPLACE_VAL(reg,val) (((reg) & ~ISTONE_ISROTOFFST_DIFFX_MASK) | (((uint32_t)val) << ISTONE_ISROTOFFST_DIFFX_SHIFT))

//====================================================================
//Register: Chrominance Pixel Offset Register (IsPxlOffst)
/** \brief This register contains the chrominance offset values to be used in the initial stage of
      the tone detection calculations.
      These values must be written prior to enabling IsTone for proper operation.*/
//====================================================================

#define  ISTONE_ISPXLOFFST_RESERVED1_MASK 0xffff0000
#define  ISTONE_ISPXLOFFST_RESERVED1_SHIFT 16
#define  ISTONE_ISPXLOFFST_RESERVED1_MASK_SHIFT(reg) (((reg) & ISTONE_ISPXLOFFST_RESERVED1_MASK) >> ISTONE_ISPXLOFFST_RESERVED1_SHIFT)
#define  ISTONE_ISPXLOFFST_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ISTONE_ISPXLOFFST_RESERVED1_MASK) | (((uint32_t)val) << ISTONE_ISPXLOFFST_RESERVED1_SHIFT))

#define  ISTONE_ISPXLOFFST_CRSHIFT_MASK 0xff00
#define  ISTONE_ISPXLOFFST_CRSHIFT_SHIFT 8
#define  ISTONE_ISPXLOFFST_CRSHIFT_MASK_SHIFT(reg) (((reg) & ISTONE_ISPXLOFFST_CRSHIFT_MASK) >> ISTONE_ISPXLOFFST_CRSHIFT_SHIFT)
#define  ISTONE_ISPXLOFFST_CRSHIFT_REPLACE_VAL(reg,val) (((reg) & ~ISTONE_ISPXLOFFST_CRSHIFT_MASK) | (((uint32_t)val) << ISTONE_ISPXLOFFST_CRSHIFT_SHIFT))

#define  ISTONE_ISPXLOFFST_CBSHIFT_MASK 0xff
#define  ISTONE_ISPXLOFFST_CBSHIFT_SHIFT 0
#define  ISTONE_ISPXLOFFST_CBSHIFT_MASK_SHIFT(reg) (((reg) & ISTONE_ISPXLOFFST_CBSHIFT_MASK) >> ISTONE_ISPXLOFFST_CBSHIFT_SHIFT)
#define  ISTONE_ISPXLOFFST_CBSHIFT_REPLACE_VAL(reg,val) (((reg) & ~ISTONE_ISPXLOFFST_CBSHIFT_MASK) | (((uint32_t)val) << ISTONE_ISPXLOFFST_CBSHIFT_SHIFT))

//====================================================================
//Register: Luminance Shift Register (IsLumShift)
/** \brief This register contains offset values needed for the luminance compensation portion of the
      tone detection calculations.
      This value must be written prior to enabling IsTone for proper operation.*/
//====================================================================

#define  ISTONE_ISLUMSHIFT_RESERVED1_MASK 0xffffff00
#define  ISTONE_ISLUMSHIFT_RESERVED1_SHIFT 8
#define  ISTONE_ISLUMSHIFT_RESERVED1_MASK_SHIFT(reg) (((reg) & ISTONE_ISLUMSHIFT_RESERVED1_MASK) >> ISTONE_ISLUMSHIFT_RESERVED1_SHIFT)
#define  ISTONE_ISLUMSHIFT_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ISTONE_ISLUMSHIFT_RESERVED1_MASK) | (((uint32_t)val) << ISTONE_ISLUMSHIFT_RESERVED1_SHIFT))

#define  ISTONE_ISLUMSHIFT_YSHIFT_MASK 0xff
#define  ISTONE_ISLUMSHIFT_YSHIFT_SHIFT 0
#define  ISTONE_ISLUMSHIFT_YSHIFT_MASK_SHIFT(reg) (((reg) & ISTONE_ISLUMSHIFT_YSHIFT_MASK) >> ISTONE_ISLUMSHIFT_YSHIFT_SHIFT)
#define  ISTONE_ISLUMSHIFT_YSHIFT_REPLACE_VAL(reg,val) (((reg) & ~ISTONE_ISLUMSHIFT_YSHIFT_MASK) | (((uint32_t)val) << ISTONE_ISLUMSHIFT_YSHIFT_SHIFT))

//====================================================================
//Register: Luminance Compensation Register (IsLumComp)
/** \brief This register contains multiplier values needed for the luminance compensation portion
      of the tone detection calculations.
      These values must be written prior to enabling IsTone for proper operation.*/
//====================================================================

#define  ISTONE_ISLUMCOMP_RESERVED1_MASK 0xfffffe00
#define  ISTONE_ISLUMCOMP_RESERVED1_SHIFT 9
#define  ISTONE_ISLUMCOMP_RESERVED1_MASK_SHIFT(reg) (((reg) & ISTONE_ISLUMCOMP_RESERVED1_MASK) >> ISTONE_ISLUMCOMP_RESERVED1_SHIFT)
#define  ISTONE_ISLUMCOMP_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ISTONE_ISLUMCOMP_RESERVED1_MASK) | (((uint32_t)val) << ISTONE_ISLUMCOMP_RESERVED1_SHIFT))

#define  ISTONE_ISLUMCOMP_YSIGN_MASK 0x100
#define  ISTONE_ISLUMCOMP_YSIGN_SHIFT 8
#define  ISTONE_ISLUMCOMP_YSIGN_MASK_SHIFT(reg) (((reg) & ISTONE_ISLUMCOMP_YSIGN_MASK) >> ISTONE_ISLUMCOMP_YSIGN_SHIFT)
#define  ISTONE_ISLUMCOMP_YSIGN_REPLACE_VAL(reg,val) (((reg) & ~ISTONE_ISLUMCOMP_YSIGN_MASK) | (((uint32_t)val) << ISTONE_ISLUMCOMP_YSIGN_SHIFT))

#define  ISTONE_ISLUMCOMP_RESERVED2_MASK 0xe0
#define  ISTONE_ISLUMCOMP_RESERVED2_SHIFT 5
#define  ISTONE_ISLUMCOMP_RESERVED2_MASK_SHIFT(reg) (((reg) & ISTONE_ISLUMCOMP_RESERVED2_MASK) >> ISTONE_ISLUMCOMP_RESERVED2_SHIFT)
#define  ISTONE_ISLUMCOMP_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~ISTONE_ISLUMCOMP_RESERVED2_MASK) | (((uint32_t)val) << ISTONE_ISLUMCOMP_RESERVED2_SHIFT))

#define  ISTONE_ISLUMCOMP_YDIV_MASK 0x10
#define  ISTONE_ISLUMCOMP_YDIV_SHIFT 4
#define  ISTONE_ISLUMCOMP_YDIV_MASK_SHIFT(reg) (((reg) & ISTONE_ISLUMCOMP_YDIV_MASK) >> ISTONE_ISLUMCOMP_YDIV_SHIFT)
#define  ISTONE_ISLUMCOMP_YDIV_REPLACE_VAL(reg,val) (((reg) & ~ISTONE_ISLUMCOMP_YDIV_MASK) | (((uint32_t)val) << ISTONE_ISLUMCOMP_YDIV_SHIFT))

#define  ISTONE_ISLUMCOMP_RESERVED3_MASK 0xc
#define  ISTONE_ISLUMCOMP_RESERVED3_SHIFT 2
#define  ISTONE_ISLUMCOMP_RESERVED3_MASK_SHIFT(reg) (((reg) & ISTONE_ISLUMCOMP_RESERVED3_MASK) >> ISTONE_ISLUMCOMP_RESERVED3_SHIFT)
#define  ISTONE_ISLUMCOMP_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~ISTONE_ISLUMCOMP_RESERVED3_MASK) | (((uint32_t)val) << ISTONE_ISLUMCOMP_RESERVED3_SHIFT))

#define  ISTONE_ISLUMCOMP_YMULTDIV_MASK 0x3
#define  ISTONE_ISLUMCOMP_YMULTDIV_SHIFT 0
#define  ISTONE_ISLUMCOMP_YMULTDIV_MASK_SHIFT(reg) (((reg) & ISTONE_ISLUMCOMP_YMULTDIV_MASK) >> ISTONE_ISLUMCOMP_YMULTDIV_SHIFT)
#define  ISTONE_ISLUMCOMP_YMULTDIV_REPLACE_VAL(reg,val) (((reg) & ~ISTONE_ISLUMCOMP_YMULTDIV_MASK) | (((uint32_t)val) << ISTONE_ISLUMCOMP_YMULTDIV_SHIFT))

//====================================================================
//Register: Chrominance Multiply / Divide Register (IsMultDiv)
/** \brief This register contains the chrominance multiply and divide values to be used in the tone
      detection calculations.
      These values must be written prior to enabling IsTone for proper operation.*/
//====================================================================

#define  ISTONE_ISMULTDIV_DIVCR_MASK 0xf0000000
#define  ISTONE_ISMULTDIV_DIVCR_SHIFT 28
#define  ISTONE_ISMULTDIV_DIVCR_MASK_SHIFT(reg) (((reg) & ISTONE_ISMULTDIV_DIVCR_MASK) >> ISTONE_ISMULTDIV_DIVCR_SHIFT)
#define  ISTONE_ISMULTDIV_DIVCR_REPLACE_VAL(reg,val) (((reg) & ~ISTONE_ISMULTDIV_DIVCR_MASK) | (((uint32_t)val) << ISTONE_ISMULTDIV_DIVCR_SHIFT))

#define  ISTONE_ISMULTDIV_RESERVED1_MASK 0xc000000
#define  ISTONE_ISMULTDIV_RESERVED1_SHIFT 26
#define  ISTONE_ISMULTDIV_RESERVED1_MASK_SHIFT(reg) (((reg) & ISTONE_ISMULTDIV_RESERVED1_MASK) >> ISTONE_ISMULTDIV_RESERVED1_SHIFT)
#define  ISTONE_ISMULTDIV_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ISTONE_ISMULTDIV_RESERVED1_MASK) | (((uint32_t)val) << ISTONE_ISMULTDIV_RESERVED1_SHIFT))

#define  ISTONE_ISMULTDIV_MULTCR_MASK 0x3ff0000
#define  ISTONE_ISMULTDIV_MULTCR_SHIFT 16
#define  ISTONE_ISMULTDIV_MULTCR_MASK_SHIFT(reg) (((reg) & ISTONE_ISMULTDIV_MULTCR_MASK) >> ISTONE_ISMULTDIV_MULTCR_SHIFT)
#define  ISTONE_ISMULTDIV_MULTCR_REPLACE_VAL(reg,val) (((reg) & ~ISTONE_ISMULTDIV_MULTCR_MASK) | (((uint32_t)val) << ISTONE_ISMULTDIV_MULTCR_SHIFT))

#define  ISTONE_ISMULTDIV_DIVCB_MASK 0xf000
#define  ISTONE_ISMULTDIV_DIVCB_SHIFT 12
#define  ISTONE_ISMULTDIV_DIVCB_MASK_SHIFT(reg) (((reg) & ISTONE_ISMULTDIV_DIVCB_MASK) >> ISTONE_ISMULTDIV_DIVCB_SHIFT)
#define  ISTONE_ISMULTDIV_DIVCB_REPLACE_VAL(reg,val) (((reg) & ~ISTONE_ISMULTDIV_DIVCB_MASK) | (((uint32_t)val) << ISTONE_ISMULTDIV_DIVCB_SHIFT))

#define  ISTONE_ISMULTDIV_RESERVED2_MASK 0xc00
#define  ISTONE_ISMULTDIV_RESERVED2_SHIFT 10
#define  ISTONE_ISMULTDIV_RESERVED2_MASK_SHIFT(reg) (((reg) & ISTONE_ISMULTDIV_RESERVED2_MASK) >> ISTONE_ISMULTDIV_RESERVED2_SHIFT)
#define  ISTONE_ISMULTDIV_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~ISTONE_ISMULTDIV_RESERVED2_MASK) | (((uint32_t)val) << ISTONE_ISMULTDIV_RESERVED2_SHIFT))

#define  ISTONE_ISMULTDIV_MULTCB_MASK 0x3ff
#define  ISTONE_ISMULTDIV_MULTCB_SHIFT 0
#define  ISTONE_ISMULTDIV_MULTCB_MASK_SHIFT(reg) (((reg) & ISTONE_ISMULTDIV_MULTCB_MASK) >> ISTONE_ISMULTDIV_MULTCB_SHIFT)
#define  ISTONE_ISMULTDIV_MULTCB_REPLACE_VAL(reg,val) (((reg) & ~ISTONE_ISMULTDIV_MULTCB_MASK) | (((uint32_t)val) << ISTONE_ISMULTDIV_MULTCB_SHIFT))

//====================================================================
//Register: Test Value Threshold Register (IsThresh)
/** \brief This register contains the final comparison value used in the tone detection calculations
      to determine if the pixel matches the desired tone.
      This value must be written prior to enabling IsTone for proper operation.*/
//====================================================================

#define  ISTONE_ISTHRESH_TESTVALUE_MASK 0xffffffff
#define  ISTONE_ISTHRESH_TESTVALUE_SHIFT 0
#define  ISTONE_ISTHRESH_TESTVALUE_MASK_SHIFT(reg) (((reg) & ISTONE_ISTHRESH_TESTVALUE_MASK) >> ISTONE_ISTHRESH_TESTVALUE_SHIFT)
#define  ISTONE_ISTHRESH_TESTVALUE_REPLACE_VAL(reg,val) (((reg) & ~ISTONE_ISTHRESH_TESTVALUE_MASK) | (((uint32_t)val) << ISTONE_ISTHRESH_TESTVALUE_SHIFT))

//====================================================================
//Register: IsTone Data Mask 0 Register (IsDataMask0)
/** \brief This register controls what bits of the CBI DataOut are overwritten by this block.
      This block supports 30 bits of YCrCb data, plus 4 bits of OT data. This register controls
      The DT field is not overwrite-able.*/
//====================================================================

#define  ISTONE_ISDATAMASK0_RESERVED1_MASK 0xc0000000
#define  ISTONE_ISDATAMASK0_RESERVED1_SHIFT 30
#define  ISTONE_ISDATAMASK0_RESERVED1_MASK_SHIFT(reg) (((reg) & ISTONE_ISDATAMASK0_RESERVED1_MASK) >> ISTONE_ISDATAMASK0_RESERVED1_SHIFT)
#define  ISTONE_ISDATAMASK0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ISTONE_ISDATAMASK0_RESERVED1_MASK) | (((uint32_t)val) << ISTONE_ISDATAMASK0_RESERVED1_SHIFT))

#define  ISTONE_ISDATAMASK0_DATA_MASK_MASK 0x3fffffff
#define  ISTONE_ISDATAMASK0_DATA_MASK_SHIFT 0
#define  ISTONE_ISDATAMASK0_DATA_MASK_MASK_SHIFT(reg) (((reg) & ISTONE_ISDATAMASK0_DATA_MASK_MASK) >> ISTONE_ISDATAMASK0_DATA_MASK_SHIFT)
#define  ISTONE_ISDATAMASK0_DATA_MASK_REPLACE_VAL(reg,val) (((reg) & ~ISTONE_ISDATAMASK0_DATA_MASK_MASK) | (((uint32_t)val) << ISTONE_ISDATAMASK0_DATA_MASK_SHIFT))

//====================================================================
//Register: IsTone Data Mask 1 Register (IsDataMask1)
/** \brief This register controls which bits of the OT field are overwrite-able. The DT field is not overwrite-able.*/
//====================================================================

#define  ISTONE_ISDATAMASK1_RESERVED1_MASK 0xfffffff0
#define  ISTONE_ISDATAMASK1_RESERVED1_SHIFT 4
#define  ISTONE_ISDATAMASK1_RESERVED1_MASK_SHIFT(reg) (((reg) & ISTONE_ISDATAMASK1_RESERVED1_MASK) >> ISTONE_ISDATAMASK1_RESERVED1_SHIFT)
#define  ISTONE_ISDATAMASK1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ISTONE_ISDATAMASK1_RESERVED1_MASK) | (((uint32_t)val) << ISTONE_ISDATAMASK1_RESERVED1_SHIFT))

#define  ISTONE_ISDATAMASK1_DATA_MASK_MASK 0xf
#define  ISTONE_ISDATAMASK1_DATA_MASK_SHIFT 0
#define  ISTONE_ISDATAMASK1_DATA_MASK_MASK_SHIFT(reg) (((reg) & ISTONE_ISDATAMASK1_DATA_MASK_MASK) >> ISTONE_ISDATAMASK1_DATA_MASK_SHIFT)
#define  ISTONE_ISDATAMASK1_DATA_MASK_REPLACE_VAL(reg,val) (((reg) & ~ISTONE_ISDATAMASK1_DATA_MASK_MASK) | (((uint32_t)val) << ISTONE_ISDATAMASK1_DATA_MASK_SHIFT))

//====================================================================
//Register: IP Tagging Revision 0 (REV0)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  ISTONE_REV0_MAJ_MASK 0xffff0000
#define  ISTONE_REV0_MAJ_SHIFT 16
#define  ISTONE_REV0_MAJ_MASK_SHIFT(reg) (((reg) & ISTONE_REV0_MAJ_MASK) >> ISTONE_REV0_MAJ_SHIFT)
#define  ISTONE_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~ISTONE_REV0_MAJ_MASK) | (((uint32_t)val) << ISTONE_REV0_MAJ_SHIFT))

#define  ISTONE_REV0_MID_MASK 0xffff
#define  ISTONE_REV0_MID_SHIFT 0
#define  ISTONE_REV0_MID_MASK_SHIFT(reg) (((reg) & ISTONE_REV0_MID_MASK) >> ISTONE_REV0_MID_SHIFT)
#define  ISTONE_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~ISTONE_REV0_MID_MASK) | (((uint32_t)val) << ISTONE_REV0_MID_SHIFT))

//====================================================================
//Register: IP Tagging Revision 1 (REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  ISTONE_REV1_RESERVED1_MASK 0xffff0000
#define  ISTONE_REV1_RESERVED1_SHIFT 16
#define  ISTONE_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & ISTONE_REV1_RESERVED1_MASK) >> ISTONE_REV1_RESERVED1_SHIFT)
#define  ISTONE_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ISTONE_REV1_RESERVED1_MASK) | (((uint32_t)val) << ISTONE_REV1_RESERVED1_SHIFT))

#define  ISTONE_REV1_CFG_MASK 0xffff
#define  ISTONE_REV1_CFG_SHIFT 0
#define  ISTONE_REV1_CFG_MASK_SHIFT(reg) (((reg) & ISTONE_REV1_CFG_MASK) >> ISTONE_REV1_CFG_SHIFT)
#define  ISTONE_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~ISTONE_REV1_CFG_MASK) | (((uint32_t)val) << ISTONE_REV1_CFG_SHIFT))

//====================================================================
//
//Register File: PIE Tone/Contrast & Neutral Sensitivity (TCNSense)
/** \brief Register Descriptions for the PIE TCNSense block
    (rev 0 . 3 . 1 . 3)*/
//
//====================================================================

//====================================================================
//Register: TCNS Configuration Register (TCNSCR)
/** \brief General configuration register for TCNSense block.*/
//====================================================================

#define  TCNSENSE_TCNSCR_OTLUTSEL_MASK 0xffff0000
#define  TCNSENSE_TCNSCR_OTLUTSEL_SHIFT 16
#define  TCNSENSE_TCNSCR_OTLUTSEL_MASK_SHIFT(reg) (((reg) & TCNSENSE_TCNSCR_OTLUTSEL_MASK) >> TCNSENSE_TCNSCR_OTLUTSEL_SHIFT)
#define  TCNSENSE_TCNSCR_OTLUTSEL_REPLACE_VAL(reg,val) (((reg) & ~TCNSENSE_TCNSCR_OTLUTSEL_MASK) | (((uint32_t)val) << TCNSENSE_TCNSCR_OTLUTSEL_SHIFT))

#define  TCNSENSE_TCNSCR_RESERVED1_MASK 0xfffc
#define  TCNSENSE_TCNSCR_RESERVED1_SHIFT 2
#define  TCNSENSE_TCNSCR_RESERVED1_MASK_SHIFT(reg) (((reg) & TCNSENSE_TCNSCR_RESERVED1_MASK) >> TCNSENSE_TCNSCR_RESERVED1_SHIFT)
#define  TCNSENSE_TCNSCR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~TCNSENSE_TCNSCR_RESERVED1_MASK) | (((uint32_t)val) << TCNSENSE_TCNSCR_RESERVED1_SHIFT))

#define  TCNSENSE_TCNSCR_C_MASK 0x2
#define  TCNSENSE_TCNSCR_C_SHIFT 1
#define  TCNSENSE_TCNSCR_C_MASK_SHIFT(reg) (((reg) & TCNSENSE_TCNSCR_C_MASK) >> TCNSENSE_TCNSCR_C_SHIFT)
#define  TCNSENSE_TCNSCR_C_REPLACE_VAL(reg,val) (((reg) & ~TCNSENSE_TCNSCR_C_MASK) | (((uint32_t)val) << TCNSENSE_TCNSCR_C_SHIFT))

#define  TCNSENSE_TCNSCR_B_MASK 0x1
#define  TCNSENSE_TCNSCR_B_SHIFT 0
#define  TCNSENSE_TCNSCR_B_MASK_SHIFT(reg) (((reg) & TCNSENSE_TCNSCR_B_MASK) >> TCNSENSE_TCNSCR_B_SHIFT)
#define  TCNSENSE_TCNSCR_B_REPLACE_VAL(reg,val) (((reg) & ~TCNSENSE_TCNSCR_B_MASK) | (((uint32_t)val) << TCNSENSE_TCNSCR_B_SHIFT))

//====================================================================
//Register: IP Tagging Revision 0 (REV0)
/** \brief Provide means for firmware to read IP tagging information.
      This register of particular interest to firmware.*/
//====================================================================

#define  TCNSENSE_REV0_MAJ_MASK 0xffff0000
#define  TCNSENSE_REV0_MAJ_SHIFT 16
#define  TCNSENSE_REV0_MAJ_MASK_SHIFT(reg) (((reg) & TCNSENSE_REV0_MAJ_MASK) >> TCNSENSE_REV0_MAJ_SHIFT)
#define  TCNSENSE_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~TCNSENSE_REV0_MAJ_MASK) | (((uint32_t)val) << TCNSENSE_REV0_MAJ_SHIFT))

#define  TCNSENSE_REV0_MID_MASK 0xffff
#define  TCNSENSE_REV0_MID_SHIFT 0
#define  TCNSENSE_REV0_MID_MASK_SHIFT(reg) (((reg) & TCNSENSE_REV0_MID_MASK) >> TCNSENSE_REV0_MID_SHIFT)
#define  TCNSENSE_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~TCNSENSE_REV0_MID_MASK) | (((uint32_t)val) << TCNSENSE_REV0_MID_SHIFT))

//====================================================================
//Register: IP Tagging Revision 1 (REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  TCNSENSE_REV1_RESERVED1_MASK 0xffff0000
#define  TCNSENSE_REV1_RESERVED1_SHIFT 16
#define  TCNSENSE_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & TCNSENSE_REV1_RESERVED1_MASK) >> TCNSENSE_REV1_RESERVED1_SHIFT)
#define  TCNSENSE_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~TCNSENSE_REV1_RESERVED1_MASK) | (((uint32_t)val) << TCNSENSE_REV1_RESERVED1_SHIFT))

#define  TCNSENSE_REV1_CFG_MASK 0xffff
#define  TCNSENSE_REV1_CFG_SHIFT 0
#define  TCNSENSE_REV1_CFG_MASK_SHIFT(reg) (((reg) & TCNSENSE_REV1_CFG_MASK) >> TCNSENSE_REV1_CFG_SHIFT)
#define  TCNSENSE_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~TCNSENSE_REV1_CFG_MASK) | (((uint32_t)val) << TCNSENSE_REV1_CFG_SHIFT))

//====================================================================
//Register: Main TCNS Look Up Table (TCNSLUT)
/** \brief Processor access to the main look-up table (LUT1). When the C field of the TCNSCR register
      is set to '1', the CPU can read/write the values in the main LUT via this register space.*/
//====================================================================

#define  TCNSENSE_TCNSLUT_RESERVED1_MASK 0xc0000000
#define  TCNSENSE_TCNSLUT_RESERVED1_SHIFT 30
#define  TCNSENSE_TCNSLUT_RESERVED1_MASK_SHIFT(reg) (((reg) & TCNSENSE_TCNSLUT_RESERVED1_MASK) >> TCNSENSE_TCNSLUT_RESERVED1_SHIFT)
#define  TCNSENSE_TCNSLUT_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~TCNSENSE_TCNSLUT_RESERVED1_MASK) | (((uint32_t)val) << TCNSENSE_TCNSLUT_RESERVED1_SHIFT))

#define  TCNSENSE_TCNSLUT_Y_MASK 0x3fc00000
#define  TCNSENSE_TCNSLUT_Y_SHIFT 22
#define  TCNSENSE_TCNSLUT_Y_MASK_SHIFT(reg) (((reg) & TCNSENSE_TCNSLUT_Y_MASK) >> TCNSENSE_TCNSLUT_Y_SHIFT)
#define  TCNSENSE_TCNSLUT_Y_REPLACE_VAL(reg,val) (((reg) & ~TCNSENSE_TCNSLUT_Y_MASK) | (((uint32_t)val) << TCNSENSE_TCNSLUT_Y_SHIFT))

#define  TCNSENSE_TCNSLUT_RESERVED2_MASK 0x380000
#define  TCNSENSE_TCNSLUT_RESERVED2_SHIFT 19
#define  TCNSENSE_TCNSLUT_RESERVED2_MASK_SHIFT(reg) (((reg) & TCNSENSE_TCNSLUT_RESERVED2_MASK) >> TCNSENSE_TCNSLUT_RESERVED2_SHIFT)
#define  TCNSENSE_TCNSLUT_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~TCNSENSE_TCNSLUT_RESERVED2_MASK) | (((uint32_t)val) << TCNSENSE_TCNSLUT_RESERVED2_SHIFT))

#define  TCNSENSE_TCNSLUT_CR_MASK 0x7f800
#define  TCNSENSE_TCNSLUT_CR_SHIFT 11
#define  TCNSENSE_TCNSLUT_CR_MASK_SHIFT(reg) (((reg) & TCNSENSE_TCNSLUT_CR_MASK) >> TCNSENSE_TCNSLUT_CR_SHIFT)
#define  TCNSENSE_TCNSLUT_CR_REPLACE_VAL(reg,val) (((reg) & ~TCNSENSE_TCNSLUT_CR_MASK) | (((uint32_t)val) << TCNSENSE_TCNSLUT_CR_SHIFT))

#define  TCNSENSE_TCNSLUT_RESERVED3_MASK 0x700
#define  TCNSENSE_TCNSLUT_RESERVED3_SHIFT 8
#define  TCNSENSE_TCNSLUT_RESERVED3_MASK_SHIFT(reg) (((reg) & TCNSENSE_TCNSLUT_RESERVED3_MASK) >> TCNSENSE_TCNSLUT_RESERVED3_SHIFT)
#define  TCNSENSE_TCNSLUT_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~TCNSENSE_TCNSLUT_RESERVED3_MASK) | (((uint32_t)val) << TCNSENSE_TCNSLUT_RESERVED3_SHIFT))

#define  TCNSENSE_TCNSLUT_CB_MASK 0xff
#define  TCNSENSE_TCNSLUT_CB_SHIFT 0
#define  TCNSENSE_TCNSLUT_CB_MASK_SHIFT(reg) (((reg) & TCNSENSE_TCNSLUT_CB_MASK) >> TCNSENSE_TCNSLUT_CB_SHIFT)
#define  TCNSENSE_TCNSLUT_CB_REPLACE_VAL(reg,val) (((reg) & ~TCNSENSE_TCNSLUT_CB_MASK) | (((uint32_t)val) << TCNSENSE_TCNSLUT_CB_SHIFT))

//====================================================================
//Register: Alternate TCNS Look Up Table (TCNSLUT2)
/** \brief Processor access to the alternate look-up table (LUT2). When the C field of the TCNSCR
      register is set to '1', the CPU can read/write the values in the alternate LUT via this
      register space.*/
//====================================================================

#define  TCNSENSE_TCNSLUT2_RESERVED1_MASK 0xc0000000
#define  TCNSENSE_TCNSLUT2_RESERVED1_SHIFT 30
#define  TCNSENSE_TCNSLUT2_RESERVED1_MASK_SHIFT(reg) (((reg) & TCNSENSE_TCNSLUT2_RESERVED1_MASK) >> TCNSENSE_TCNSLUT2_RESERVED1_SHIFT)
#define  TCNSENSE_TCNSLUT2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~TCNSENSE_TCNSLUT2_RESERVED1_MASK) | (((uint32_t)val) << TCNSENSE_TCNSLUT2_RESERVED1_SHIFT))

#define  TCNSENSE_TCNSLUT2_Y_MASK 0x3fc00000
#define  TCNSENSE_TCNSLUT2_Y_SHIFT 22
#define  TCNSENSE_TCNSLUT2_Y_MASK_SHIFT(reg) (((reg) & TCNSENSE_TCNSLUT2_Y_MASK) >> TCNSENSE_TCNSLUT2_Y_SHIFT)
#define  TCNSENSE_TCNSLUT2_Y_REPLACE_VAL(reg,val) (((reg) & ~TCNSENSE_TCNSLUT2_Y_MASK) | (((uint32_t)val) << TCNSENSE_TCNSLUT2_Y_SHIFT))

#define  TCNSENSE_TCNSLUT2_RESERVED2_MASK 0x380000
#define  TCNSENSE_TCNSLUT2_RESERVED2_SHIFT 19
#define  TCNSENSE_TCNSLUT2_RESERVED2_MASK_SHIFT(reg) (((reg) & TCNSENSE_TCNSLUT2_RESERVED2_MASK) >> TCNSENSE_TCNSLUT2_RESERVED2_SHIFT)
#define  TCNSENSE_TCNSLUT2_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~TCNSENSE_TCNSLUT2_RESERVED2_MASK) | (((uint32_t)val) << TCNSENSE_TCNSLUT2_RESERVED2_SHIFT))

#define  TCNSENSE_TCNSLUT2_CR_MASK 0x7f800
#define  TCNSENSE_TCNSLUT2_CR_SHIFT 11
#define  TCNSENSE_TCNSLUT2_CR_MASK_SHIFT(reg) (((reg) & TCNSENSE_TCNSLUT2_CR_MASK) >> TCNSENSE_TCNSLUT2_CR_SHIFT)
#define  TCNSENSE_TCNSLUT2_CR_REPLACE_VAL(reg,val) (((reg) & ~TCNSENSE_TCNSLUT2_CR_MASK) | (((uint32_t)val) << TCNSENSE_TCNSLUT2_CR_SHIFT))

#define  TCNSENSE_TCNSLUT2_RESERVED3_MASK 0x700
#define  TCNSENSE_TCNSLUT2_RESERVED3_SHIFT 8
#define  TCNSENSE_TCNSLUT2_RESERVED3_MASK_SHIFT(reg) (((reg) & TCNSENSE_TCNSLUT2_RESERVED3_MASK) >> TCNSENSE_TCNSLUT2_RESERVED3_SHIFT)
#define  TCNSENSE_TCNSLUT2_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~TCNSENSE_TCNSLUT2_RESERVED3_MASK) | (((uint32_t)val) << TCNSENSE_TCNSLUT2_RESERVED3_SHIFT))

#define  TCNSENSE_TCNSLUT2_CB_MASK 0xff
#define  TCNSENSE_TCNSLUT2_CB_SHIFT 0
#define  TCNSENSE_TCNSLUT2_CB_MASK_SHIFT(reg) (((reg) & TCNSENSE_TCNSLUT2_CB_MASK) >> TCNSENSE_TCNSLUT2_CB_SHIFT)
#define  TCNSENSE_TCNSLUT2_CB_REPLACE_VAL(reg,val) (((reg) & ~TCNSENSE_TCNSLUT2_CB_MASK) | (((uint32_t)val) << TCNSENSE_TCNSLUT2_CB_SHIFT))

//====================================================================
//
//Register File: PIE DENOISE (DENOISE)
/** \brief (rev 0 . 1 . 0 . 1)
    Top-level register file for the DENOISE block*/
//
//====================================================================

//====================================================================
//Register: IP Tagging Revision 0 (REV0)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  DENOISE_REV0_MAJ_MASK 0xffff0000
#define  DENOISE_REV0_MAJ_SHIFT 16
#define  DENOISE_REV0_MAJ_MASK_SHIFT(reg) (((reg) & DENOISE_REV0_MAJ_MASK) >> DENOISE_REV0_MAJ_SHIFT)
#define  DENOISE_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~DENOISE_REV0_MAJ_MASK) | (((uint32_t)val) << DENOISE_REV0_MAJ_SHIFT))

#define  DENOISE_REV0_MID_MASK 0xffff
#define  DENOISE_REV0_MID_SHIFT 0
#define  DENOISE_REV0_MID_MASK_SHIFT(reg) (((reg) & DENOISE_REV0_MID_MASK) >> DENOISE_REV0_MID_SHIFT)
#define  DENOISE_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~DENOISE_REV0_MID_MASK) | (((uint32_t)val) << DENOISE_REV0_MID_SHIFT))

//====================================================================
//Register: IP Tagging Revision 1 (REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  DENOISE_REV1_RESERVED1_MASK 0xffff0000
#define  DENOISE_REV1_RESERVED1_SHIFT 16
#define  DENOISE_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & DENOISE_REV1_RESERVED1_MASK) >> DENOISE_REV1_RESERVED1_SHIFT)
#define  DENOISE_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DENOISE_REV1_RESERVED1_MASK) | (((uint32_t)val) << DENOISE_REV1_RESERVED1_SHIFT))

#define  DENOISE_REV1_CFG_MASK 0xffff
#define  DENOISE_REV1_CFG_SHIFT 0
#define  DENOISE_REV1_CFG_MASK_SHIFT(reg) (((reg) & DENOISE_REV1_CFG_MASK) >> DENOISE_REV1_CFG_SHIFT)
#define  DENOISE_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~DENOISE_REV1_CFG_MASK) | (((uint32_t)val) << DENOISE_REV1_CFG_SHIFT))

//====================================================================
//Register: Configuration Register (CFG)
/** \brief Configuration Register for Denoise block.*/
//====================================================================

#define  DENOISE_CFG_CRTHRESH_MASK 0xff000000
#define  DENOISE_CFG_CRTHRESH_SHIFT 24
#define  DENOISE_CFG_CRTHRESH_MASK_SHIFT(reg) (((reg) & DENOISE_CFG_CRTHRESH_MASK) >> DENOISE_CFG_CRTHRESH_SHIFT)
#define  DENOISE_CFG_CRTHRESH_REPLACE_VAL(reg,val) (((reg) & ~DENOISE_CFG_CRTHRESH_MASK) | (((uint32_t)val) << DENOISE_CFG_CRTHRESH_SHIFT))

#define  DENOISE_CFG_CBTHRESH_MASK 0xff0000
#define  DENOISE_CFG_CBTHRESH_SHIFT 16
#define  DENOISE_CFG_CBTHRESH_MASK_SHIFT(reg) (((reg) & DENOISE_CFG_CBTHRESH_MASK) >> DENOISE_CFG_CBTHRESH_SHIFT)
#define  DENOISE_CFG_CBTHRESH_REPLACE_VAL(reg,val) (((reg) & ~DENOISE_CFG_CBTHRESH_MASK) | (((uint32_t)val) << DENOISE_CFG_CBTHRESH_SHIFT))

#define  DENOISE_CFG_YTHRESH_MASK 0xff00
#define  DENOISE_CFG_YTHRESH_SHIFT 8
#define  DENOISE_CFG_YTHRESH_MASK_SHIFT(reg) (((reg) & DENOISE_CFG_YTHRESH_MASK) >> DENOISE_CFG_YTHRESH_SHIFT)
#define  DENOISE_CFG_YTHRESH_REPLACE_VAL(reg,val) (((reg) & ~DENOISE_CFG_YTHRESH_MASK) | (((uint32_t)val) << DENOISE_CFG_YTHRESH_SHIFT))

#define  DENOISE_CFG_RESERVED1_MASK 0x80
#define  DENOISE_CFG_RESERVED1_SHIFT 7
#define  DENOISE_CFG_RESERVED1_MASK_SHIFT(reg) (((reg) & DENOISE_CFG_RESERVED1_MASK) >> DENOISE_CFG_RESERVED1_SHIFT)
#define  DENOISE_CFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DENOISE_CFG_RESERVED1_MASK) | (((uint32_t)val) << DENOISE_CFG_RESERVED1_SHIFT))

#define  DENOISE_CFG_KEEP_MASK 0x70
#define  DENOISE_CFG_KEEP_SHIFT 4
#define  DENOISE_CFG_KEEP_MASK_SHIFT(reg) (((reg) & DENOISE_CFG_KEEP_MASK) >> DENOISE_CFG_KEEP_SHIFT)
#define  DENOISE_CFG_KEEP_REPLACE_VAL(reg,val) (((reg) & ~DENOISE_CFG_KEEP_MASK) | (((uint32_t)val) << DENOISE_CFG_KEEP_SHIFT))

#define  DENOISE_CFG_RESERVED2_MASK 0x8
#define  DENOISE_CFG_RESERVED2_SHIFT 3
#define  DENOISE_CFG_RESERVED2_MASK_SHIFT(reg) (((reg) & DENOISE_CFG_RESERVED2_MASK) >> DENOISE_CFG_RESERVED2_SHIFT)
#define  DENOISE_CFG_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DENOISE_CFG_RESERVED2_MASK) | (((uint32_t)val) << DENOISE_CFG_RESERVED2_SHIFT))

#define  DENOISE_CFG_GAUSSEN_MASK 0x4
#define  DENOISE_CFG_GAUSSEN_SHIFT 2
#define  DENOISE_CFG_GAUSSEN_MASK_SHIFT(reg) (((reg) & DENOISE_CFG_GAUSSEN_MASK) >> DENOISE_CFG_GAUSSEN_SHIFT)
#define  DENOISE_CFG_GAUSSEN_REPLACE_VAL(reg,val) (((reg) & ~DENOISE_CFG_GAUSSEN_MASK) | (((uint32_t)val) << DENOISE_CFG_GAUSSEN_SHIFT))

#define  DENOISE_CFG_SPEN_MASK 0x2
#define  DENOISE_CFG_SPEN_SHIFT 1
#define  DENOISE_CFG_SPEN_MASK_SHIFT(reg) (((reg) & DENOISE_CFG_SPEN_MASK) >> DENOISE_CFG_SPEN_SHIFT)
#define  DENOISE_CFG_SPEN_REPLACE_VAL(reg,val) (((reg) & ~DENOISE_CFG_SPEN_MASK) | (((uint32_t)val) << DENOISE_CFG_SPEN_SHIFT))

#define  DENOISE_CFG_BYPASS_MASK 0x1
#define  DENOISE_CFG_BYPASS_SHIFT 0
#define  DENOISE_CFG_BYPASS_MASK_SHIFT(reg) (((reg) & DENOISE_CFG_BYPASS_MASK) >> DENOISE_CFG_BYPASS_SHIFT)
#define  DENOISE_CFG_BYPASS_REPLACE_VAL(reg,val) (((reg) & ~DENOISE_CFG_BYPASS_MASK) | (((uint32_t)val) << DENOISE_CFG_BYPASS_SHIFT))

//====================================================================
//
//Register File: PIE DeScreen MultiFilter (DSMF)
/** \brief Register Descriptions for the Descreen / MultiFilter block
(rev 0 . 1 . 2 . 2)*/
//
//====================================================================

//====================================================================
//Register: DSMF Control Register (DSMF_Ctl)
/** \brief General configuration register for DSMF module*/
//====================================================================

#define  DSMF_DSMF_CTL_RESERVED1_MASK 0xfc000000
#define  DSMF_DSMF_CTL_RESERVED1_SHIFT 26
#define  DSMF_DSMF_CTL_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CTL_RESERVED1_MASK) >> DSMF_DSMF_CTL_RESERVED1_SHIFT)
#define  DSMF_DSMF_CTL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CTL_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_CTL_RESERVED1_SHIFT))

#define  DSMF_DSMF_CTL_EN_POGO_OFFSET_MASK 0x2000000
#define  DSMF_DSMF_CTL_EN_POGO_OFFSET_SHIFT 25
#define  DSMF_DSMF_CTL_EN_POGO_OFFSET_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CTL_EN_POGO_OFFSET_MASK) >> DSMF_DSMF_CTL_EN_POGO_OFFSET_SHIFT)
#define  DSMF_DSMF_CTL_EN_POGO_OFFSET_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CTL_EN_POGO_OFFSET_MASK) | (((uint32_t)val) << DSMF_DSMF_CTL_EN_POGO_OFFSET_SHIFT))

#define  DSMF_DSMF_CTL_AI_LUT_OUT_EN_MASK 0x1000000
#define  DSMF_DSMF_CTL_AI_LUT_OUT_EN_SHIFT 24
#define  DSMF_DSMF_CTL_AI_LUT_OUT_EN_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CTL_AI_LUT_OUT_EN_MASK) >> DSMF_DSMF_CTL_AI_LUT_OUT_EN_SHIFT)
#define  DSMF_DSMF_CTL_AI_LUT_OUT_EN_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CTL_AI_LUT_OUT_EN_MASK) | (((uint32_t)val) << DSMF_DSMF_CTL_AI_LUT_OUT_EN_SHIFT))

#define  DSMF_DSMF_CTL_BYPASS_FILT_SEL_MASK 0x800000
#define  DSMF_DSMF_CTL_BYPASS_FILT_SEL_SHIFT 23
#define  DSMF_DSMF_CTL_BYPASS_FILT_SEL_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CTL_BYPASS_FILT_SEL_MASK) >> DSMF_DSMF_CTL_BYPASS_FILT_SEL_SHIFT)
#define  DSMF_DSMF_CTL_BYPASS_FILT_SEL_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CTL_BYPASS_FILT_SEL_MASK) | (((uint32_t)val) << DSMF_DSMF_CTL_BYPASS_FILT_SEL_SHIFT))

#define  DSMF_DSMF_CTL_BYPASS_FILT_MASK 0x400000
#define  DSMF_DSMF_CTL_BYPASS_FILT_SHIFT 22
#define  DSMF_DSMF_CTL_BYPASS_FILT_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CTL_BYPASS_FILT_MASK) >> DSMF_DSMF_CTL_BYPASS_FILT_SHIFT)
#define  DSMF_DSMF_CTL_BYPASS_FILT_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CTL_BYPASS_FILT_MASK) | (((uint32_t)val) << DSMF_DSMF_CTL_BYPASS_FILT_SHIFT))

#define  DSMF_DSMF_CTL_WIN_SHRINK_MASK 0x300000
#define  DSMF_DSMF_CTL_WIN_SHRINK_SHIFT 20
#define  DSMF_DSMF_CTL_WIN_SHRINK_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CTL_WIN_SHRINK_MASK) >> DSMF_DSMF_CTL_WIN_SHRINK_SHIFT)
#define  DSMF_DSMF_CTL_WIN_SHRINK_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CTL_WIN_SHRINK_MASK) | (((uint32_t)val) << DSMF_DSMF_CTL_WIN_SHRINK_SHIFT))

#define  DSMF_DSMF_CTL_FILT_IDX_SEL_MASK 0xf0000
#define  DSMF_DSMF_CTL_FILT_IDX_SEL_SHIFT 16
#define  DSMF_DSMF_CTL_FILT_IDX_SEL_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CTL_FILT_IDX_SEL_MASK) >> DSMF_DSMF_CTL_FILT_IDX_SEL_SHIFT)
#define  DSMF_DSMF_CTL_FILT_IDX_SEL_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CTL_FILT_IDX_SEL_MASK) | (((uint32_t)val) << DSMF_DSMF_CTL_FILT_IDX_SEL_SHIFT))

#define  DSMF_DSMF_CTL_OT_OUT_SEL_MASK 0xf000
#define  DSMF_DSMF_CTL_OT_OUT_SEL_SHIFT 12
#define  DSMF_DSMF_CTL_OT_OUT_SEL_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CTL_OT_OUT_SEL_MASK) >> DSMF_DSMF_CTL_OT_OUT_SEL_SHIFT)
#define  DSMF_DSMF_CTL_OT_OUT_SEL_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CTL_OT_OUT_SEL_MASK) | (((uint32_t)val) << DSMF_DSMF_CTL_OT_OUT_SEL_SHIFT))

#define  DSMF_DSMF_CTL_ALPHA_FILT_EN_MASK 0x800
#define  DSMF_DSMF_CTL_ALPHA_FILT_EN_SHIFT 11
#define  DSMF_DSMF_CTL_ALPHA_FILT_EN_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CTL_ALPHA_FILT_EN_MASK) >> DSMF_DSMF_CTL_ALPHA_FILT_EN_SHIFT)
#define  DSMF_DSMF_CTL_ALPHA_FILT_EN_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CTL_ALPHA_FILT_EN_MASK) | (((uint32_t)val) << DSMF_DSMF_CTL_ALPHA_FILT_EN_SHIFT))

#define  DSMF_DSMF_CTL_RESERVED2_MASK 0x600
#define  DSMF_DSMF_CTL_RESERVED2_SHIFT 9
#define  DSMF_DSMF_CTL_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CTL_RESERVED2_MASK) >> DSMF_DSMF_CTL_RESERVED2_SHIFT)
#define  DSMF_DSMF_CTL_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CTL_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_CTL_RESERVED2_SHIFT))

#define  DSMF_DSMF_CTL_CPU_ACCESS_LUT_MASK 0x100
#define  DSMF_DSMF_CTL_CPU_ACCESS_LUT_SHIFT 8
#define  DSMF_DSMF_CTL_CPU_ACCESS_LUT_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CTL_CPU_ACCESS_LUT_MASK) >> DSMF_DSMF_CTL_CPU_ACCESS_LUT_SHIFT)
#define  DSMF_DSMF_CTL_CPU_ACCESS_LUT_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CTL_CPU_ACCESS_LUT_MASK) | (((uint32_t)val) << DSMF_DSMF_CTL_CPU_ACCESS_LUT_SHIFT))

#define  DSMF_DSMF_CTL_TEST_MIXED_MASK 0x80
#define  DSMF_DSMF_CTL_TEST_MIXED_SHIFT 7
#define  DSMF_DSMF_CTL_TEST_MIXED_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CTL_TEST_MIXED_MASK) >> DSMF_DSMF_CTL_TEST_MIXED_SHIFT)
#define  DSMF_DSMF_CTL_TEST_MIXED_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CTL_TEST_MIXED_MASK) | (((uint32_t)val) << DSMF_DSMF_CTL_TEST_MIXED_SHIFT))

#define  DSMF_DSMF_CTL_TEST_HALFTONE_MASK 0x40
#define  DSMF_DSMF_CTL_TEST_HALFTONE_SHIFT 6
#define  DSMF_DSMF_CTL_TEST_HALFTONE_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CTL_TEST_HALFTONE_MASK) >> DSMF_DSMF_CTL_TEST_HALFTONE_SHIFT)
#define  DSMF_DSMF_CTL_TEST_HALFTONE_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CTL_TEST_HALFTONE_MASK) | (((uint32_t)val) << DSMF_DSMF_CTL_TEST_HALFTONE_SHIFT))

#define  DSMF_DSMF_CTL_TEST_TEXT_MASK 0x20
#define  DSMF_DSMF_CTL_TEST_TEXT_SHIFT 5
#define  DSMF_DSMF_CTL_TEST_TEXT_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CTL_TEST_TEXT_MASK) >> DSMF_DSMF_CTL_TEST_TEXT_SHIFT)
#define  DSMF_DSMF_CTL_TEST_TEXT_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CTL_TEST_TEXT_MASK) | (((uint32_t)val) << DSMF_DSMF_CTL_TEST_TEXT_SHIFT))

#define  DSMF_DSMF_CTL_TEST_ISOLATED_MASK 0x10
#define  DSMF_DSMF_CTL_TEST_ISOLATED_SHIFT 4
#define  DSMF_DSMF_CTL_TEST_ISOLATED_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CTL_TEST_ISOLATED_MASK) >> DSMF_DSMF_CTL_TEST_ISOLATED_SHIFT)
#define  DSMF_DSMF_CTL_TEST_ISOLATED_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CTL_TEST_ISOLATED_MASK) | (((uint32_t)val) << DSMF_DSMF_CTL_TEST_ISOLATED_SHIFT))

#define  DSMF_DSMF_CTL_RESERVED3_MASK 0xe
#define  DSMF_DSMF_CTL_RESERVED3_SHIFT 1
#define  DSMF_DSMF_CTL_RESERVED3_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CTL_RESERVED3_MASK) >> DSMF_DSMF_CTL_RESERVED3_SHIFT)
#define  DSMF_DSMF_CTL_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CTL_RESERVED3_MASK) | (((uint32_t)val) << DSMF_DSMF_CTL_RESERVED3_SHIFT))

#define  DSMF_DSMF_CTL_BYPASS_ALL_MASK 0x1
#define  DSMF_DSMF_CTL_BYPASS_ALL_SHIFT 0
#define  DSMF_DSMF_CTL_BYPASS_ALL_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CTL_BYPASS_ALL_MASK) >> DSMF_DSMF_CTL_BYPASS_ALL_SHIFT)
#define  DSMF_DSMF_CTL_BYPASS_ALL_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CTL_BYPASS_ALL_MASK) | (((uint32_t)val) << DSMF_DSMF_CTL_BYPASS_ALL_SHIFT))

//====================================================================
//Register: DSMF Segmentation Threshold - Horizontal and Vertical Projection Register (DSMF_Seg_HV_Proj)
/** \brief Horizontal and Vertical Projection Register*/
//====================================================================

#define  DSMF_DSMF_SEG_HV_PROJ_RESERVED1_MASK 0xc0000000
#define  DSMF_DSMF_SEG_HV_PROJ_RESERVED1_SHIFT 30
#define  DSMF_DSMF_SEG_HV_PROJ_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_SEG_HV_PROJ_RESERVED1_MASK) >> DSMF_DSMF_SEG_HV_PROJ_RESERVED1_SHIFT)
#define  DSMF_DSMF_SEG_HV_PROJ_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_SEG_HV_PROJ_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_SEG_HV_PROJ_RESERVED1_SHIFT))

#define  DSMF_DSMF_SEG_HV_PROJ_THRESH_PROJ_HORIZ_X55_MASK 0x3fff0000
#define  DSMF_DSMF_SEG_HV_PROJ_THRESH_PROJ_HORIZ_X55_SHIFT 16
#define  DSMF_DSMF_SEG_HV_PROJ_THRESH_PROJ_HORIZ_X55_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_SEG_HV_PROJ_THRESH_PROJ_HORIZ_X55_MASK) >> DSMF_DSMF_SEG_HV_PROJ_THRESH_PROJ_HORIZ_X55_SHIFT)
#define  DSMF_DSMF_SEG_HV_PROJ_THRESH_PROJ_HORIZ_X55_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_SEG_HV_PROJ_THRESH_PROJ_HORIZ_X55_MASK) | (((uint32_t)val) << DSMF_DSMF_SEG_HV_PROJ_THRESH_PROJ_HORIZ_X55_SHIFT))

#define  DSMF_DSMF_SEG_HV_PROJ_RESERVED2_MASK 0xc000
#define  DSMF_DSMF_SEG_HV_PROJ_RESERVED2_SHIFT 14
#define  DSMF_DSMF_SEG_HV_PROJ_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_SEG_HV_PROJ_RESERVED2_MASK) >> DSMF_DSMF_SEG_HV_PROJ_RESERVED2_SHIFT)
#define  DSMF_DSMF_SEG_HV_PROJ_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_SEG_HV_PROJ_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_SEG_HV_PROJ_RESERVED2_SHIFT))

#define  DSMF_DSMF_SEG_HV_PROJ_THRESH_PROJ_VERT_X55_MASK 0x3fff
#define  DSMF_DSMF_SEG_HV_PROJ_THRESH_PROJ_VERT_X55_SHIFT 0
#define  DSMF_DSMF_SEG_HV_PROJ_THRESH_PROJ_VERT_X55_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_SEG_HV_PROJ_THRESH_PROJ_VERT_X55_MASK) >> DSMF_DSMF_SEG_HV_PROJ_THRESH_PROJ_VERT_X55_SHIFT)
#define  DSMF_DSMF_SEG_HV_PROJ_THRESH_PROJ_VERT_X55_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_SEG_HV_PROJ_THRESH_PROJ_VERT_X55_MASK) | (((uint32_t)val) << DSMF_DSMF_SEG_HV_PROJ_THRESH_PROJ_VERT_X55_SHIFT))

//====================================================================
//Register: DSMF Segmentation Threshold - Diagonal Projection Register (DSMF_Seg_Diag_Proj)
/** \brief Diagonal Projection Register*/
//====================================================================

#define  DSMF_DSMF_SEG_DIAG_PROJ_RESERVED1_MASK 0xffffe000
#define  DSMF_DSMF_SEG_DIAG_PROJ_RESERVED1_SHIFT 13
#define  DSMF_DSMF_SEG_DIAG_PROJ_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_SEG_DIAG_PROJ_RESERVED1_MASK) >> DSMF_DSMF_SEG_DIAG_PROJ_RESERVED1_SHIFT)
#define  DSMF_DSMF_SEG_DIAG_PROJ_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_SEG_DIAG_PROJ_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_SEG_DIAG_PROJ_RESERVED1_SHIFT))

#define  DSMF_DSMF_SEG_DIAG_PROJ_THRESH_PROJ_DIAG_X25_MASK 0x1fff
#define  DSMF_DSMF_SEG_DIAG_PROJ_THRESH_PROJ_DIAG_X25_SHIFT 0
#define  DSMF_DSMF_SEG_DIAG_PROJ_THRESH_PROJ_DIAG_X25_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_SEG_DIAG_PROJ_THRESH_PROJ_DIAG_X25_MASK) >> DSMF_DSMF_SEG_DIAG_PROJ_THRESH_PROJ_DIAG_X25_SHIFT)
#define  DSMF_DSMF_SEG_DIAG_PROJ_THRESH_PROJ_DIAG_X25_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_SEG_DIAG_PROJ_THRESH_PROJ_DIAG_X25_MASK) | (((uint32_t)val) << DSMF_DSMF_SEG_DIAG_PROJ_THRESH_PROJ_DIAG_X25_SHIFT))

//====================================================================
//Register: DSMF Segmentation Threshold - Isolated Detection Register (DSMF_Seg_Isolated)
/** \brief Isolated Detection Register*/
//====================================================================

#define  DSMF_DSMF_SEG_ISOLATED_RESERVED1_MASK 0xff000000
#define  DSMF_DSMF_SEG_ISOLATED_RESERVED1_SHIFT 24
#define  DSMF_DSMF_SEG_ISOLATED_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_SEG_ISOLATED_RESERVED1_MASK) >> DSMF_DSMF_SEG_ISOLATED_RESERVED1_SHIFT)
#define  DSMF_DSMF_SEG_ISOLATED_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_SEG_ISOLATED_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_SEG_ISOLATED_RESERVED1_SHIFT))

#define  DSMF_DSMF_SEG_ISOLATED_THRESH_ISOLATED_HORIZ_MASK 0xff0000
#define  DSMF_DSMF_SEG_ISOLATED_THRESH_ISOLATED_HORIZ_SHIFT 16
#define  DSMF_DSMF_SEG_ISOLATED_THRESH_ISOLATED_HORIZ_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_SEG_ISOLATED_THRESH_ISOLATED_HORIZ_MASK) >> DSMF_DSMF_SEG_ISOLATED_THRESH_ISOLATED_HORIZ_SHIFT)
#define  DSMF_DSMF_SEG_ISOLATED_THRESH_ISOLATED_HORIZ_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_SEG_ISOLATED_THRESH_ISOLATED_HORIZ_MASK) | (((uint32_t)val) << DSMF_DSMF_SEG_ISOLATED_THRESH_ISOLATED_HORIZ_SHIFT))

#define  DSMF_DSMF_SEG_ISOLATED_THRESH_ISOLATED_VERT_MASK 0xff00
#define  DSMF_DSMF_SEG_ISOLATED_THRESH_ISOLATED_VERT_SHIFT 8
#define  DSMF_DSMF_SEG_ISOLATED_THRESH_ISOLATED_VERT_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_SEG_ISOLATED_THRESH_ISOLATED_VERT_MASK) >> DSMF_DSMF_SEG_ISOLATED_THRESH_ISOLATED_VERT_SHIFT)
#define  DSMF_DSMF_SEG_ISOLATED_THRESH_ISOLATED_VERT_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_SEG_ISOLATED_THRESH_ISOLATED_VERT_MASK) | (((uint32_t)val) << DSMF_DSMF_SEG_ISOLATED_THRESH_ISOLATED_VERT_SHIFT))

#define  DSMF_DSMF_SEG_ISOLATED_THRESH_ISOLATED_DIAG_MASK 0xff
#define  DSMF_DSMF_SEG_ISOLATED_THRESH_ISOLATED_DIAG_SHIFT 0
#define  DSMF_DSMF_SEG_ISOLATED_THRESH_ISOLATED_DIAG_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_SEG_ISOLATED_THRESH_ISOLATED_DIAG_MASK) >> DSMF_DSMF_SEG_ISOLATED_THRESH_ISOLATED_DIAG_SHIFT)
#define  DSMF_DSMF_SEG_ISOLATED_THRESH_ISOLATED_DIAG_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_SEG_ISOLATED_THRESH_ISOLATED_DIAG_MASK) | (((uint32_t)val) << DSMF_DSMF_SEG_ISOLATED_THRESH_ISOLATED_DIAG_SHIFT))

//====================================================================
//Register: DSMF Segmentation Threshold - 3x3 Text Detection Register (DSMF_Seg_3x3_Text)
/** \brief 3x3 Text Detection Register*/
//====================================================================

#define  DSMF_DSMF_SEG_3X3_TEXT_RESERVED1_MASK 0xff000000
#define  DSMF_DSMF_SEG_3X3_TEXT_RESERVED1_SHIFT 24
#define  DSMF_DSMF_SEG_3X3_TEXT_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_SEG_3X3_TEXT_RESERVED1_MASK) >> DSMF_DSMF_SEG_3X3_TEXT_RESERVED1_SHIFT)
#define  DSMF_DSMF_SEG_3X3_TEXT_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_SEG_3X3_TEXT_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_SEG_3X3_TEXT_RESERVED1_SHIFT))

#define  DSMF_DSMF_SEG_3X3_TEXT_THRESH_3X3_TEXT_HORIZ_MASK 0xff0000
#define  DSMF_DSMF_SEG_3X3_TEXT_THRESH_3X3_TEXT_HORIZ_SHIFT 16
#define  DSMF_DSMF_SEG_3X3_TEXT_THRESH_3X3_TEXT_HORIZ_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_SEG_3X3_TEXT_THRESH_3X3_TEXT_HORIZ_MASK) >> DSMF_DSMF_SEG_3X3_TEXT_THRESH_3X3_TEXT_HORIZ_SHIFT)
#define  DSMF_DSMF_SEG_3X3_TEXT_THRESH_3X3_TEXT_HORIZ_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_SEG_3X3_TEXT_THRESH_3X3_TEXT_HORIZ_MASK) | (((uint32_t)val) << DSMF_DSMF_SEG_3X3_TEXT_THRESH_3X3_TEXT_HORIZ_SHIFT))

#define  DSMF_DSMF_SEG_3X3_TEXT_THRESH_3X3_TEXT_VERT_MASK 0xff00
#define  DSMF_DSMF_SEG_3X3_TEXT_THRESH_3X3_TEXT_VERT_SHIFT 8
#define  DSMF_DSMF_SEG_3X3_TEXT_THRESH_3X3_TEXT_VERT_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_SEG_3X3_TEXT_THRESH_3X3_TEXT_VERT_MASK) >> DSMF_DSMF_SEG_3X3_TEXT_THRESH_3X3_TEXT_VERT_SHIFT)
#define  DSMF_DSMF_SEG_3X3_TEXT_THRESH_3X3_TEXT_VERT_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_SEG_3X3_TEXT_THRESH_3X3_TEXT_VERT_MASK) | (((uint32_t)val) << DSMF_DSMF_SEG_3X3_TEXT_THRESH_3X3_TEXT_VERT_SHIFT))

#define  DSMF_DSMF_SEG_3X3_TEXT_THRESH_3X3_TEXT_DIAG_MASK 0xff
#define  DSMF_DSMF_SEG_3X3_TEXT_THRESH_3X3_TEXT_DIAG_SHIFT 0
#define  DSMF_DSMF_SEG_3X3_TEXT_THRESH_3X3_TEXT_DIAG_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_SEG_3X3_TEXT_THRESH_3X3_TEXT_DIAG_MASK) >> DSMF_DSMF_SEG_3X3_TEXT_THRESH_3X3_TEXT_DIAG_SHIFT)
#define  DSMF_DSMF_SEG_3X3_TEXT_THRESH_3X3_TEXT_DIAG_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_SEG_3X3_TEXT_THRESH_3X3_TEXT_DIAG_MASK) | (((uint32_t)val) << DSMF_DSMF_SEG_3X3_TEXT_THRESH_3X3_TEXT_DIAG_SHIFT))

//====================================================================
//Register: DSMF Segmentation Threshold - 3x3 Mixed Detection Register (DSMF_Seg_3x3_Mixed)
/** \brief 3x3 Mixed Detection Register*/
//====================================================================

#define  DSMF_DSMF_SEG_3X3_MIXED_RESERVED1_MASK 0xff000000
#define  DSMF_DSMF_SEG_3X3_MIXED_RESERVED1_SHIFT 24
#define  DSMF_DSMF_SEG_3X3_MIXED_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_SEG_3X3_MIXED_RESERVED1_MASK) >> DSMF_DSMF_SEG_3X3_MIXED_RESERVED1_SHIFT)
#define  DSMF_DSMF_SEG_3X3_MIXED_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_SEG_3X3_MIXED_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_SEG_3X3_MIXED_RESERVED1_SHIFT))

#define  DSMF_DSMF_SEG_3X3_MIXED_THRESH_3X3_MIXED_HORIZ_MASK 0xff0000
#define  DSMF_DSMF_SEG_3X3_MIXED_THRESH_3X3_MIXED_HORIZ_SHIFT 16
#define  DSMF_DSMF_SEG_3X3_MIXED_THRESH_3X3_MIXED_HORIZ_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_SEG_3X3_MIXED_THRESH_3X3_MIXED_HORIZ_MASK) >> DSMF_DSMF_SEG_3X3_MIXED_THRESH_3X3_MIXED_HORIZ_SHIFT)
#define  DSMF_DSMF_SEG_3X3_MIXED_THRESH_3X3_MIXED_HORIZ_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_SEG_3X3_MIXED_THRESH_3X3_MIXED_HORIZ_MASK) | (((uint32_t)val) << DSMF_DSMF_SEG_3X3_MIXED_THRESH_3X3_MIXED_HORIZ_SHIFT))

#define  DSMF_DSMF_SEG_3X3_MIXED_THRESH_3X3_MIXED_VERT_MASK 0xff00
#define  DSMF_DSMF_SEG_3X3_MIXED_THRESH_3X3_MIXED_VERT_SHIFT 8
#define  DSMF_DSMF_SEG_3X3_MIXED_THRESH_3X3_MIXED_VERT_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_SEG_3X3_MIXED_THRESH_3X3_MIXED_VERT_MASK) >> DSMF_DSMF_SEG_3X3_MIXED_THRESH_3X3_MIXED_VERT_SHIFT)
#define  DSMF_DSMF_SEG_3X3_MIXED_THRESH_3X3_MIXED_VERT_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_SEG_3X3_MIXED_THRESH_3X3_MIXED_VERT_MASK) | (((uint32_t)val) << DSMF_DSMF_SEG_3X3_MIXED_THRESH_3X3_MIXED_VERT_SHIFT))

#define  DSMF_DSMF_SEG_3X3_MIXED_THRESH_3X3_MIXED_DIAG_MASK 0xff
#define  DSMF_DSMF_SEG_3X3_MIXED_THRESH_3X3_MIXED_DIAG_SHIFT 0
#define  DSMF_DSMF_SEG_3X3_MIXED_THRESH_3X3_MIXED_DIAG_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_SEG_3X3_MIXED_THRESH_3X3_MIXED_DIAG_MASK) >> DSMF_DSMF_SEG_3X3_MIXED_THRESH_3X3_MIXED_DIAG_SHIFT)
#define  DSMF_DSMF_SEG_3X3_MIXED_THRESH_3X3_MIXED_DIAG_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_SEG_3X3_MIXED_THRESH_3X3_MIXED_DIAG_MASK) | (((uint32_t)val) << DSMF_DSMF_SEG_3X3_MIXED_THRESH_3X3_MIXED_DIAG_SHIFT))

//====================================================================
//Register: DSMF Segmentation Threshold - 5x5 Text Detection Register (DSMF_Seg_5x5_Text)
/** \brief 5x5 Text Detection Register*/
//====================================================================

#define  DSMF_DSMF_SEG_5X5_TEXT_RESERVED1_MASK 0xff000000
#define  DSMF_DSMF_SEG_5X5_TEXT_RESERVED1_SHIFT 24
#define  DSMF_DSMF_SEG_5X5_TEXT_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_SEG_5X5_TEXT_RESERVED1_MASK) >> DSMF_DSMF_SEG_5X5_TEXT_RESERVED1_SHIFT)
#define  DSMF_DSMF_SEG_5X5_TEXT_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_SEG_5X5_TEXT_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_SEG_5X5_TEXT_RESERVED1_SHIFT))

#define  DSMF_DSMF_SEG_5X5_TEXT_THRESH_5X5_TEXT_HORIZ_MASK 0xff0000
#define  DSMF_DSMF_SEG_5X5_TEXT_THRESH_5X5_TEXT_HORIZ_SHIFT 16
#define  DSMF_DSMF_SEG_5X5_TEXT_THRESH_5X5_TEXT_HORIZ_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_SEG_5X5_TEXT_THRESH_5X5_TEXT_HORIZ_MASK) >> DSMF_DSMF_SEG_5X5_TEXT_THRESH_5X5_TEXT_HORIZ_SHIFT)
#define  DSMF_DSMF_SEG_5X5_TEXT_THRESH_5X5_TEXT_HORIZ_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_SEG_5X5_TEXT_THRESH_5X5_TEXT_HORIZ_MASK) | (((uint32_t)val) << DSMF_DSMF_SEG_5X5_TEXT_THRESH_5X5_TEXT_HORIZ_SHIFT))

#define  DSMF_DSMF_SEG_5X5_TEXT_THRESH_5X5_TEXT_VERT_MASK 0xff00
#define  DSMF_DSMF_SEG_5X5_TEXT_THRESH_5X5_TEXT_VERT_SHIFT 8
#define  DSMF_DSMF_SEG_5X5_TEXT_THRESH_5X5_TEXT_VERT_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_SEG_5X5_TEXT_THRESH_5X5_TEXT_VERT_MASK) >> DSMF_DSMF_SEG_5X5_TEXT_THRESH_5X5_TEXT_VERT_SHIFT)
#define  DSMF_DSMF_SEG_5X5_TEXT_THRESH_5X5_TEXT_VERT_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_SEG_5X5_TEXT_THRESH_5X5_TEXT_VERT_MASK) | (((uint32_t)val) << DSMF_DSMF_SEG_5X5_TEXT_THRESH_5X5_TEXT_VERT_SHIFT))

#define  DSMF_DSMF_SEG_5X5_TEXT_THRESH_5X5_TEXT_DIAG_MASK 0xff
#define  DSMF_DSMF_SEG_5X5_TEXT_THRESH_5X5_TEXT_DIAG_SHIFT 0
#define  DSMF_DSMF_SEG_5X5_TEXT_THRESH_5X5_TEXT_DIAG_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_SEG_5X5_TEXT_THRESH_5X5_TEXT_DIAG_MASK) >> DSMF_DSMF_SEG_5X5_TEXT_THRESH_5X5_TEXT_DIAG_SHIFT)
#define  DSMF_DSMF_SEG_5X5_TEXT_THRESH_5X5_TEXT_DIAG_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_SEG_5X5_TEXT_THRESH_5X5_TEXT_DIAG_MASK) | (((uint32_t)val) << DSMF_DSMF_SEG_5X5_TEXT_THRESH_5X5_TEXT_DIAG_SHIFT))

//====================================================================
//Register: DSMF Segmentation Threshold - 5x5 Mixed Detection Register (DSMF_Seg_5x5_Mixed)
/** \brief 5x5 Mixed Detection Register*/
//====================================================================

#define  DSMF_DSMF_SEG_5X5_MIXED_RESERVED1_MASK 0xff000000
#define  DSMF_DSMF_SEG_5X5_MIXED_RESERVED1_SHIFT 24
#define  DSMF_DSMF_SEG_5X5_MIXED_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_SEG_5X5_MIXED_RESERVED1_MASK) >> DSMF_DSMF_SEG_5X5_MIXED_RESERVED1_SHIFT)
#define  DSMF_DSMF_SEG_5X5_MIXED_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_SEG_5X5_MIXED_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_SEG_5X5_MIXED_RESERVED1_SHIFT))

#define  DSMF_DSMF_SEG_5X5_MIXED_THRESH_5X5_MIXED_HORIZ_MASK 0xff0000
#define  DSMF_DSMF_SEG_5X5_MIXED_THRESH_5X5_MIXED_HORIZ_SHIFT 16
#define  DSMF_DSMF_SEG_5X5_MIXED_THRESH_5X5_MIXED_HORIZ_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_SEG_5X5_MIXED_THRESH_5X5_MIXED_HORIZ_MASK) >> DSMF_DSMF_SEG_5X5_MIXED_THRESH_5X5_MIXED_HORIZ_SHIFT)
#define  DSMF_DSMF_SEG_5X5_MIXED_THRESH_5X5_MIXED_HORIZ_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_SEG_5X5_MIXED_THRESH_5X5_MIXED_HORIZ_MASK) | (((uint32_t)val) << DSMF_DSMF_SEG_5X5_MIXED_THRESH_5X5_MIXED_HORIZ_SHIFT))

#define  DSMF_DSMF_SEG_5X5_MIXED_THRESH_5X5_MIXED_VERT_MASK 0xff00
#define  DSMF_DSMF_SEG_5X5_MIXED_THRESH_5X5_MIXED_VERT_SHIFT 8
#define  DSMF_DSMF_SEG_5X5_MIXED_THRESH_5X5_MIXED_VERT_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_SEG_5X5_MIXED_THRESH_5X5_MIXED_VERT_MASK) >> DSMF_DSMF_SEG_5X5_MIXED_THRESH_5X5_MIXED_VERT_SHIFT)
#define  DSMF_DSMF_SEG_5X5_MIXED_THRESH_5X5_MIXED_VERT_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_SEG_5X5_MIXED_THRESH_5X5_MIXED_VERT_MASK) | (((uint32_t)val) << DSMF_DSMF_SEG_5X5_MIXED_THRESH_5X5_MIXED_VERT_SHIFT))

#define  DSMF_DSMF_SEG_5X5_MIXED_THRESH_5X5_MIXED_DIAG_MASK 0xff
#define  DSMF_DSMF_SEG_5X5_MIXED_THRESH_5X5_MIXED_DIAG_SHIFT 0
#define  DSMF_DSMF_SEG_5X5_MIXED_THRESH_5X5_MIXED_DIAG_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_SEG_5X5_MIXED_THRESH_5X5_MIXED_DIAG_MASK) >> DSMF_DSMF_SEG_5X5_MIXED_THRESH_5X5_MIXED_DIAG_SHIFT)
#define  DSMF_DSMF_SEG_5X5_MIXED_THRESH_5X5_MIXED_DIAG_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_SEG_5X5_MIXED_THRESH_5X5_MIXED_DIAG_MASK) | (((uint32_t)val) << DSMF_DSMF_SEG_5X5_MIXED_THRESH_5X5_MIXED_DIAG_SHIFT))

//====================================================================
//Register: DSMF Segmentation Threshold - Line Detection Register (DSMF_Seg_Line)
/** \brief Line Detection Register*/
//====================================================================

#define  DSMF_DSMF_SEG_LINE_RESERVED1_MASK 0xffff0000
#define  DSMF_DSMF_SEG_LINE_RESERVED1_SHIFT 16
#define  DSMF_DSMF_SEG_LINE_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_SEG_LINE_RESERVED1_MASK) >> DSMF_DSMF_SEG_LINE_RESERVED1_SHIFT)
#define  DSMF_DSMF_SEG_LINE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_SEG_LINE_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_SEG_LINE_RESERVED1_SHIFT))

#define  DSMF_DSMF_SEG_LINE_THRESH_LINE_VERT_MASK 0xff00
#define  DSMF_DSMF_SEG_LINE_THRESH_LINE_VERT_SHIFT 8
#define  DSMF_DSMF_SEG_LINE_THRESH_LINE_VERT_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_SEG_LINE_THRESH_LINE_VERT_MASK) >> DSMF_DSMF_SEG_LINE_THRESH_LINE_VERT_SHIFT)
#define  DSMF_DSMF_SEG_LINE_THRESH_LINE_VERT_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_SEG_LINE_THRESH_LINE_VERT_MASK) | (((uint32_t)val) << DSMF_DSMF_SEG_LINE_THRESH_LINE_VERT_SHIFT))

#define  DSMF_DSMF_SEG_LINE_THRESH_LINE_HORIZ_MASK 0xff
#define  DSMF_DSMF_SEG_LINE_THRESH_LINE_HORIZ_SHIFT 0
#define  DSMF_DSMF_SEG_LINE_THRESH_LINE_HORIZ_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_SEG_LINE_THRESH_LINE_HORIZ_MASK) >> DSMF_DSMF_SEG_LINE_THRESH_LINE_HORIZ_SHIFT)
#define  DSMF_DSMF_SEG_LINE_THRESH_LINE_HORIZ_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_SEG_LINE_THRESH_LINE_HORIZ_MASK) | (((uint32_t)val) << DSMF_DSMF_SEG_LINE_THRESH_LINE_HORIZ_SHIFT))

//====================================================================
//Register: DSMF Segmentation Threshold - Line Diagonal Detection Register (DSMF_Seg_Line_Diag)
/** \brief Line Diagonal Detection Register*/
//====================================================================

#define  DSMF_DSMF_SEG_LINE_DIAG_RESERVED1_MASK 0xff000000
#define  DSMF_DSMF_SEG_LINE_DIAG_RESERVED1_SHIFT 24
#define  DSMF_DSMF_SEG_LINE_DIAG_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_SEG_LINE_DIAG_RESERVED1_MASK) >> DSMF_DSMF_SEG_LINE_DIAG_RESERVED1_SHIFT)
#define  DSMF_DSMF_SEG_LINE_DIAG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_SEG_LINE_DIAG_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_SEG_LINE_DIAG_RESERVED1_SHIFT))

#define  DSMF_DSMF_SEG_LINE_DIAG_THRESH_LINE_DIAG2_MASK 0xff0000
#define  DSMF_DSMF_SEG_LINE_DIAG_THRESH_LINE_DIAG2_SHIFT 16
#define  DSMF_DSMF_SEG_LINE_DIAG_THRESH_LINE_DIAG2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_SEG_LINE_DIAG_THRESH_LINE_DIAG2_MASK) >> DSMF_DSMF_SEG_LINE_DIAG_THRESH_LINE_DIAG2_SHIFT)
#define  DSMF_DSMF_SEG_LINE_DIAG_THRESH_LINE_DIAG2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_SEG_LINE_DIAG_THRESH_LINE_DIAG2_MASK) | (((uint32_t)val) << DSMF_DSMF_SEG_LINE_DIAG_THRESH_LINE_DIAG2_SHIFT))

#define  DSMF_DSMF_SEG_LINE_DIAG_THRESH_LINE_DIAG1_MASK 0xff00
#define  DSMF_DSMF_SEG_LINE_DIAG_THRESH_LINE_DIAG1_SHIFT 8
#define  DSMF_DSMF_SEG_LINE_DIAG_THRESH_LINE_DIAG1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_SEG_LINE_DIAG_THRESH_LINE_DIAG1_MASK) >> DSMF_DSMF_SEG_LINE_DIAG_THRESH_LINE_DIAG1_SHIFT)
#define  DSMF_DSMF_SEG_LINE_DIAG_THRESH_LINE_DIAG1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_SEG_LINE_DIAG_THRESH_LINE_DIAG1_MASK) | (((uint32_t)val) << DSMF_DSMF_SEG_LINE_DIAG_THRESH_LINE_DIAG1_SHIFT))

#define  DSMF_DSMF_SEG_LINE_DIAG_THRESH_LINE_DIAG_MASK 0xff
#define  DSMF_DSMF_SEG_LINE_DIAG_THRESH_LINE_DIAG_SHIFT 0
#define  DSMF_DSMF_SEG_LINE_DIAG_THRESH_LINE_DIAG_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_SEG_LINE_DIAG_THRESH_LINE_DIAG_MASK) >> DSMF_DSMF_SEG_LINE_DIAG_THRESH_LINE_DIAG_SHIFT)
#define  DSMF_DSMF_SEG_LINE_DIAG_THRESH_LINE_DIAG_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_SEG_LINE_DIAG_THRESH_LINE_DIAG_MASK) | (((uint32_t)val) << DSMF_DSMF_SEG_LINE_DIAG_THRESH_LINE_DIAG_SHIFT))

//====================================================================
//Register: DSMF Sculptor Configuration 1 Register (DSMF_SCR1)
//====================================================================

#define  DSMF_DSMF_SCR1_OFFSET_MASK 0xff800000
#define  DSMF_DSMF_SCR1_OFFSET_SHIFT 23
#define  DSMF_DSMF_SCR1_OFFSET_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_SCR1_OFFSET_MASK) >> DSMF_DSMF_SCR1_OFFSET_SHIFT)
#define  DSMF_DSMF_SCR1_OFFSET_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_SCR1_OFFSET_MASK) | (((uint32_t)val) << DSMF_DSMF_SCR1_OFFSET_SHIFT))

#define  DSMF_DSMF_SCR1_RESERVED1_MASK 0x400000
#define  DSMF_DSMF_SCR1_RESERVED1_SHIFT 22
#define  DSMF_DSMF_SCR1_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_SCR1_RESERVED1_MASK) >> DSMF_DSMF_SCR1_RESERVED1_SHIFT)
#define  DSMF_DSMF_SCR1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_SCR1_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_SCR1_RESERVED1_SHIFT))

#define  DSMF_DSMF_SCR1_LUT_SCALE_MASK 0x300000
#define  DSMF_DSMF_SCR1_LUT_SCALE_SHIFT 20
#define  DSMF_DSMF_SCR1_LUT_SCALE_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_SCR1_LUT_SCALE_MASK) >> DSMF_DSMF_SCR1_LUT_SCALE_SHIFT)
#define  DSMF_DSMF_SCR1_LUT_SCALE_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_SCR1_LUT_SCALE_MASK) | (((uint32_t)val) << DSMF_DSMF_SCR1_LUT_SCALE_SHIFT))

#define  DSMF_DSMF_SCR1_RESERVED2_MASK 0xc0000
#define  DSMF_DSMF_SCR1_RESERVED2_SHIFT 18
#define  DSMF_DSMF_SCR1_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_SCR1_RESERVED2_MASK) >> DSMF_DSMF_SCR1_RESERVED2_SHIFT)
#define  DSMF_DSMF_SCR1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_SCR1_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_SCR1_RESERVED2_SHIFT))

#define  DSMF_DSMF_SCR1_SCALE_2_MASK 0x30000
#define  DSMF_DSMF_SCR1_SCALE_2_SHIFT 16
#define  DSMF_DSMF_SCR1_SCALE_2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_SCR1_SCALE_2_MASK) >> DSMF_DSMF_SCR1_SCALE_2_SHIFT)
#define  DSMF_DSMF_SCR1_SCALE_2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_SCR1_SCALE_2_MASK) | (((uint32_t)val) << DSMF_DSMF_SCR1_SCALE_2_SHIFT))

#define  DSMF_DSMF_SCR1_RESERVED3_MASK 0xc000
#define  DSMF_DSMF_SCR1_RESERVED3_SHIFT 14
#define  DSMF_DSMF_SCR1_RESERVED3_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_SCR1_RESERVED3_MASK) >> DSMF_DSMF_SCR1_RESERVED3_SHIFT)
#define  DSMF_DSMF_SCR1_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_SCR1_RESERVED3_MASK) | (((uint32_t)val) << DSMF_DSMF_SCR1_RESERVED3_SHIFT))

#define  DSMF_DSMF_SCR1_SCALE_1_5_MASK 0x3000
#define  DSMF_DSMF_SCR1_SCALE_1_5_SHIFT 12
#define  DSMF_DSMF_SCR1_SCALE_1_5_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_SCR1_SCALE_1_5_MASK) >> DSMF_DSMF_SCR1_SCALE_1_5_SHIFT)
#define  DSMF_DSMF_SCR1_SCALE_1_5_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_SCR1_SCALE_1_5_MASK) | (((uint32_t)val) << DSMF_DSMF_SCR1_SCALE_1_5_SHIFT))

#define  DSMF_DSMF_SCR1_RESERVED4_MASK 0xc00
#define  DSMF_DSMF_SCR1_RESERVED4_SHIFT 10
#define  DSMF_DSMF_SCR1_RESERVED4_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_SCR1_RESERVED4_MASK) >> DSMF_DSMF_SCR1_RESERVED4_SHIFT)
#define  DSMF_DSMF_SCR1_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_SCR1_RESERVED4_MASK) | (((uint32_t)val) << DSMF_DSMF_SCR1_RESERVED4_SHIFT))

#define  DSMF_DSMF_SCR1_SCALE_MASK 0x300
#define  DSMF_DSMF_SCR1_SCALE_SHIFT 8
#define  DSMF_DSMF_SCR1_SCALE_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_SCR1_SCALE_MASK) >> DSMF_DSMF_SCR1_SCALE_SHIFT)
#define  DSMF_DSMF_SCR1_SCALE_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_SCR1_SCALE_MASK) | (((uint32_t)val) << DSMF_DSMF_SCR1_SCALE_SHIFT))

#define  DSMF_DSMF_SCR1_RESERVED5_MASK 0xff
#define  DSMF_DSMF_SCR1_RESERVED5_SHIFT 0
#define  DSMF_DSMF_SCR1_RESERVED5_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_SCR1_RESERVED5_MASK) >> DSMF_DSMF_SCR1_RESERVED5_SHIFT)
#define  DSMF_DSMF_SCR1_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_SCR1_RESERVED5_MASK) | (((uint32_t)val) << DSMF_DSMF_SCR1_RESERVED5_SHIFT))

//====================================================================
//Register: DSMF Sculptor Configuration 2 Register (DSMF_SCR2)
//====================================================================

#define  DSMF_DSMF_SCR2_RESERVED1_MASK 0xe0000000
#define  DSMF_DSMF_SCR2_RESERVED1_SHIFT 29
#define  DSMF_DSMF_SCR2_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_SCR2_RESERVED1_MASK) >> DSMF_DSMF_SCR2_RESERVED1_SHIFT)
#define  DSMF_DSMF_SCR2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_SCR2_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_SCR2_RESERVED1_SHIFT))

#define  DSMF_DSMF_SCR2_EN_EROSION_MASK 0x10000000
#define  DSMF_DSMF_SCR2_EN_EROSION_SHIFT 28
#define  DSMF_DSMF_SCR2_EN_EROSION_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_SCR2_EN_EROSION_MASK) >> DSMF_DSMF_SCR2_EN_EROSION_SHIFT)
#define  DSMF_DSMF_SCR2_EN_EROSION_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_SCR2_EN_EROSION_MASK) | (((uint32_t)val) << DSMF_DSMF_SCR2_EN_EROSION_SHIFT))

#define  DSMF_DSMF_SCR2_RESERVED2_MASK 0xe000000
#define  DSMF_DSMF_SCR2_RESERVED2_SHIFT 25
#define  DSMF_DSMF_SCR2_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_SCR2_RESERVED2_MASK) >> DSMF_DSMF_SCR2_RESERVED2_SHIFT)
#define  DSMF_DSMF_SCR2_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_SCR2_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_SCR2_RESERVED2_SHIFT))

#define  DSMF_DSMF_SCR2_EN_DILATION_MASK 0x1000000
#define  DSMF_DSMF_SCR2_EN_DILATION_SHIFT 24
#define  DSMF_DSMF_SCR2_EN_DILATION_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_SCR2_EN_DILATION_MASK) >> DSMF_DSMF_SCR2_EN_DILATION_SHIFT)
#define  DSMF_DSMF_SCR2_EN_DILATION_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_SCR2_EN_DILATION_MASK) | (((uint32_t)val) << DSMF_DSMF_SCR2_EN_DILATION_SHIFT))

#define  DSMF_DSMF_SCR2_RESERVED3_MASK 0xfffffe
#define  DSMF_DSMF_SCR2_RESERVED3_SHIFT 1
#define  DSMF_DSMF_SCR2_RESERVED3_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_SCR2_RESERVED3_MASK) >> DSMF_DSMF_SCR2_RESERVED3_SHIFT)
#define  DSMF_DSMF_SCR2_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_SCR2_RESERVED3_MASK) | (((uint32_t)val) << DSMF_DSMF_SCR2_RESERVED3_SHIFT))

#define  DSMF_DSMF_SCR2_FIVEXFIVE_TE_MASK 0x1
#define  DSMF_DSMF_SCR2_FIVEXFIVE_TE_SHIFT 0
#define  DSMF_DSMF_SCR2_FIVEXFIVE_TE_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_SCR2_FIVEXFIVE_TE_MASK) >> DSMF_DSMF_SCR2_FIVEXFIVE_TE_SHIFT)
#define  DSMF_DSMF_SCR2_FIVEXFIVE_TE_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_SCR2_FIVEXFIVE_TE_MASK) | (((uint32_t)val) << DSMF_DSMF_SCR2_FIVEXFIVE_TE_SHIFT))

//====================================================================
//Register: DSMF Text Enhance Limit 1 Register (DSMF_TEL1R)
//====================================================================

#define  DSMF_DSMF_TEL1R_RESERVED1_MASK 0x80000000
#define  DSMF_DSMF_TEL1R_RESERVED1_SHIFT 31
#define  DSMF_DSMF_TEL1R_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_TEL1R_RESERVED1_MASK) >> DSMF_DSMF_TEL1R_RESERVED1_SHIFT)
#define  DSMF_DSMF_TEL1R_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_TEL1R_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_TEL1R_RESERVED1_SHIFT))

#define  DSMF_DSMF_TEL1R_CENTERCMAX_MASK 0x7f000000
#define  DSMF_DSMF_TEL1R_CENTERCMAX_SHIFT 24
#define  DSMF_DSMF_TEL1R_CENTERCMAX_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_TEL1R_CENTERCMAX_MASK) >> DSMF_DSMF_TEL1R_CENTERCMAX_SHIFT)
#define  DSMF_DSMF_TEL1R_CENTERCMAX_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_TEL1R_CENTERCMAX_MASK) | (((uint32_t)val) << DSMF_DSMF_TEL1R_CENTERCMAX_SHIFT))

#define  DSMF_DSMF_TEL1R_RESERVED2_MASK 0xc00000
#define  DSMF_DSMF_TEL1R_RESERVED2_SHIFT 22
#define  DSMF_DSMF_TEL1R_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_TEL1R_RESERVED2_MASK) >> DSMF_DSMF_TEL1R_RESERVED2_SHIFT)
#define  DSMF_DSMF_TEL1R_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_TEL1R_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_TEL1R_RESERVED2_SHIFT))

#define  DSMF_DSMF_TEL1R_COUNTBWMIN_MASK 0x3f0000
#define  DSMF_DSMF_TEL1R_COUNTBWMIN_SHIFT 16
#define  DSMF_DSMF_TEL1R_COUNTBWMIN_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_TEL1R_COUNTBWMIN_MASK) >> DSMF_DSMF_TEL1R_COUNTBWMIN_SHIFT)
#define  DSMF_DSMF_TEL1R_COUNTBWMIN_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_TEL1R_COUNTBWMIN_MASK) | (((uint32_t)val) << DSMF_DSMF_TEL1R_COUNTBWMIN_SHIFT))

#define  DSMF_DSMF_TEL1R_RESERVED3_MASK 0xe000
#define  DSMF_DSMF_TEL1R_RESERVED3_SHIFT 13
#define  DSMF_DSMF_TEL1R_RESERVED3_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_TEL1R_RESERVED3_MASK) >> DSMF_DSMF_TEL1R_RESERVED3_SHIFT)
#define  DSMF_DSMF_TEL1R_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_TEL1R_RESERVED3_MASK) | (((uint32_t)val) << DSMF_DSMF_TEL1R_RESERVED3_SHIFT))

#define  DSMF_DSMF_TEL1R_COUNTWMIN_MASK 0x1f00
#define  DSMF_DSMF_TEL1R_COUNTWMIN_SHIFT 8
#define  DSMF_DSMF_TEL1R_COUNTWMIN_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_TEL1R_COUNTWMIN_MASK) >> DSMF_DSMF_TEL1R_COUNTWMIN_SHIFT)
#define  DSMF_DSMF_TEL1R_COUNTWMIN_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_TEL1R_COUNTWMIN_MASK) | (((uint32_t)val) << DSMF_DSMF_TEL1R_COUNTWMIN_SHIFT))

#define  DSMF_DSMF_TEL1R_RESERVED4_MASK 0xe0
#define  DSMF_DSMF_TEL1R_RESERVED4_SHIFT 5
#define  DSMF_DSMF_TEL1R_RESERVED4_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_TEL1R_RESERVED4_MASK) >> DSMF_DSMF_TEL1R_RESERVED4_SHIFT)
#define  DSMF_DSMF_TEL1R_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_TEL1R_RESERVED4_MASK) | (((uint32_t)val) << DSMF_DSMF_TEL1R_RESERVED4_SHIFT))

#define  DSMF_DSMF_TEL1R_COUNTBMIN_MASK 0x1f
#define  DSMF_DSMF_TEL1R_COUNTBMIN_SHIFT 0
#define  DSMF_DSMF_TEL1R_COUNTBMIN_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_TEL1R_COUNTBMIN_MASK) >> DSMF_DSMF_TEL1R_COUNTBMIN_SHIFT)
#define  DSMF_DSMF_TEL1R_COUNTBMIN_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_TEL1R_COUNTBMIN_MASK) | (((uint32_t)val) << DSMF_DSMF_TEL1R_COUNTBMIN_SHIFT))

//====================================================================
//Register: DSMF Text Enhance Limit 2 Register (DSMF_TEL2R)
//====================================================================

#define  DSMF_DSMF_TEL2R_RESERVED1_MASK 0xffffff80
#define  DSMF_DSMF_TEL2R_RESERVED1_SHIFT 7
#define  DSMF_DSMF_TEL2R_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_TEL2R_RESERVED1_MASK) >> DSMF_DSMF_TEL2R_RESERVED1_SHIFT)
#define  DSMF_DSMF_TEL2R_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_TEL2R_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_TEL2R_RESERVED1_SHIFT))

#define  DSMF_DSMF_TEL2R_CMAX_MASK 0x7f
#define  DSMF_DSMF_TEL2R_CMAX_SHIFT 0
#define  DSMF_DSMF_TEL2R_CMAX_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_TEL2R_CMAX_MASK) >> DSMF_DSMF_TEL2R_CMAX_SHIFT)
#define  DSMF_DSMF_TEL2R_CMAX_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_TEL2R_CMAX_MASK) | (((uint32_t)val) << DSMF_DSMF_TEL2R_CMAX_SHIFT))

//====================================================================
//Register: DSMF Text Enhance Limit 3 Register (DSMF_TEL3R)
//====================================================================

#define  DSMF_DSMF_TEL3R_RESERVED1_MASK 0x80000000
#define  DSMF_DSMF_TEL3R_RESERVED1_SHIFT 31
#define  DSMF_DSMF_TEL3R_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_TEL3R_RESERVED1_MASK) >> DSMF_DSMF_TEL3R_RESERVED1_SHIFT)
#define  DSMF_DSMF_TEL3R_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_TEL3R_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_TEL3R_RESERVED1_SHIFT))

#define  DSMF_DSMF_TEL3R_WHITECRCBMAX_MASK 0x7f000000
#define  DSMF_DSMF_TEL3R_WHITECRCBMAX_SHIFT 24
#define  DSMF_DSMF_TEL3R_WHITECRCBMAX_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_TEL3R_WHITECRCBMAX_MASK) >> DSMF_DSMF_TEL3R_WHITECRCBMAX_SHIFT)
#define  DSMF_DSMF_TEL3R_WHITECRCBMAX_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_TEL3R_WHITECRCBMAX_MASK) | (((uint32_t)val) << DSMF_DSMF_TEL3R_WHITECRCBMAX_SHIFT))

#define  DSMF_DSMF_TEL3R_RESERVED2_MASK 0x800000
#define  DSMF_DSMF_TEL3R_RESERVED2_SHIFT 23
#define  DSMF_DSMF_TEL3R_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_TEL3R_RESERVED2_MASK) >> DSMF_DSMF_TEL3R_RESERVED2_SHIFT)
#define  DSMF_DSMF_TEL3R_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_TEL3R_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_TEL3R_RESERVED2_SHIFT))

#define  DSMF_DSMF_TEL3R_WHITEYMIN_MASK 0x7f0000
#define  DSMF_DSMF_TEL3R_WHITEYMIN_SHIFT 16
#define  DSMF_DSMF_TEL3R_WHITEYMIN_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_TEL3R_WHITEYMIN_MASK) >> DSMF_DSMF_TEL3R_WHITEYMIN_SHIFT)
#define  DSMF_DSMF_TEL3R_WHITEYMIN_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_TEL3R_WHITEYMIN_MASK) | (((uint32_t)val) << DSMF_DSMF_TEL3R_WHITEYMIN_SHIFT))

#define  DSMF_DSMF_TEL3R_RESERVED3_MASK 0x8000
#define  DSMF_DSMF_TEL3R_RESERVED3_SHIFT 15
#define  DSMF_DSMF_TEL3R_RESERVED3_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_TEL3R_RESERVED3_MASK) >> DSMF_DSMF_TEL3R_RESERVED3_SHIFT)
#define  DSMF_DSMF_TEL3R_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_TEL3R_RESERVED3_MASK) | (((uint32_t)val) << DSMF_DSMF_TEL3R_RESERVED3_SHIFT))

#define  DSMF_DSMF_TEL3R_BLACKCRCBMAX_MASK 0x7f00
#define  DSMF_DSMF_TEL3R_BLACKCRCBMAX_SHIFT 8
#define  DSMF_DSMF_TEL3R_BLACKCRCBMAX_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_TEL3R_BLACKCRCBMAX_MASK) >> DSMF_DSMF_TEL3R_BLACKCRCBMAX_SHIFT)
#define  DSMF_DSMF_TEL3R_BLACKCRCBMAX_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_TEL3R_BLACKCRCBMAX_MASK) | (((uint32_t)val) << DSMF_DSMF_TEL3R_BLACKCRCBMAX_SHIFT))

#define  DSMF_DSMF_TEL3R_RESERVED4_MASK 0x80
#define  DSMF_DSMF_TEL3R_RESERVED4_SHIFT 7
#define  DSMF_DSMF_TEL3R_RESERVED4_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_TEL3R_RESERVED4_MASK) >> DSMF_DSMF_TEL3R_RESERVED4_SHIFT)
#define  DSMF_DSMF_TEL3R_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_TEL3R_RESERVED4_MASK) | (((uint32_t)val) << DSMF_DSMF_TEL3R_RESERVED4_SHIFT))

#define  DSMF_DSMF_TEL3R_BLACKYMAX_MASK 0x7f
#define  DSMF_DSMF_TEL3R_BLACKYMAX_SHIFT 0
#define  DSMF_DSMF_TEL3R_BLACKYMAX_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_TEL3R_BLACKYMAX_MASK) >> DSMF_DSMF_TEL3R_BLACKYMAX_SHIFT)
#define  DSMF_DSMF_TEL3R_BLACKYMAX_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_TEL3R_BLACKYMAX_MASK) | (((uint32_t)val) << DSMF_DSMF_TEL3R_BLACKYMAX_SHIFT))

//====================================================================
//Register: DSMF Edge Count Compare (DSMF_EC_COMPARE)
//====================================================================

#define  DSMF_DSMF_EC_COMPARE_EC_COMPARE_MASK 0xff000000
#define  DSMF_DSMF_EC_COMPARE_EC_COMPARE_SHIFT 24
#define  DSMF_DSMF_EC_COMPARE_EC_COMPARE_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_EC_COMPARE_EC_COMPARE_MASK) >> DSMF_DSMF_EC_COMPARE_EC_COMPARE_SHIFT)
#define  DSMF_DSMF_EC_COMPARE_EC_COMPARE_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_EC_COMPARE_EC_COMPARE_MASK) | (((uint32_t)val) << DSMF_DSMF_EC_COMPARE_EC_COMPARE_SHIFT))

#define  DSMF_DSMF_EC_COMPARE_RESERVED1_MASK 0xffffff
#define  DSMF_DSMF_EC_COMPARE_RESERVED1_SHIFT 0
#define  DSMF_DSMF_EC_COMPARE_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_EC_COMPARE_RESERVED1_MASK) >> DSMF_DSMF_EC_COMPARE_RESERVED1_SHIFT)
#define  DSMF_DSMF_EC_COMPARE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_EC_COMPARE_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_EC_COMPARE_RESERVED1_SHIFT))

//====================================================================
//Register: DSMF Edge Count Write (DSMF_EC_WR)
//====================================================================

#define  DSMF_DSMF_EC_WR_RESERVED1_MASK 0xfe000000
#define  DSMF_DSMF_EC_WR_RESERVED1_SHIFT 25
#define  DSMF_DSMF_EC_WR_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_EC_WR_RESERVED1_MASK) >> DSMF_DSMF_EC_WR_RESERVED1_SHIFT)
#define  DSMF_DSMF_EC_WR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_EC_WR_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_EC_WR_RESERVED1_SHIFT))

#define  DSMF_DSMF_EC_WR_EDGE_COUNT_BYP_START_IDX_MASK 0x1000000
#define  DSMF_DSMF_EC_WR_EDGE_COUNT_BYP_START_IDX_SHIFT 24
#define  DSMF_DSMF_EC_WR_EDGE_COUNT_BYP_START_IDX_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_EC_WR_EDGE_COUNT_BYP_START_IDX_MASK) >> DSMF_DSMF_EC_WR_EDGE_COUNT_BYP_START_IDX_SHIFT)
#define  DSMF_DSMF_EC_WR_EDGE_COUNT_BYP_START_IDX_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_EC_WR_EDGE_COUNT_BYP_START_IDX_MASK) | (((uint32_t)val) << DSMF_DSMF_EC_WR_EDGE_COUNT_BYP_START_IDX_SHIFT))

#define  DSMF_DSMF_EC_WR_EDGE_COUNT_MASK 0xffffff
#define  DSMF_DSMF_EC_WR_EDGE_COUNT_SHIFT 0
#define  DSMF_DSMF_EC_WR_EDGE_COUNT_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_EC_WR_EDGE_COUNT_MASK) >> DSMF_DSMF_EC_WR_EDGE_COUNT_SHIFT)
#define  DSMF_DSMF_EC_WR_EDGE_COUNT_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_EC_WR_EDGE_COUNT_MASK) | (((uint32_t)val) << DSMF_DSMF_EC_WR_EDGE_COUNT_SHIFT))

//====================================================================
//Register: DSMF Edge Count Observation (DSMF_EC_OBS)
//====================================================================

#define  DSMF_DSMF_EC_OBS_RESERVED1_MASK 0xfe000000
#define  DSMF_DSMF_EC_OBS_RESERVED1_SHIFT 25
#define  DSMF_DSMF_EC_OBS_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_EC_OBS_RESERVED1_MASK) >> DSMF_DSMF_EC_OBS_RESERVED1_SHIFT)
#define  DSMF_DSMF_EC_OBS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_EC_OBS_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_EC_OBS_RESERVED1_SHIFT))

#define  DSMF_DSMF_EC_OBS_EDGE_COUNT_BYP_START_IDX_OBS_MASK 0x1000000
#define  DSMF_DSMF_EC_OBS_EDGE_COUNT_BYP_START_IDX_OBS_SHIFT 24
#define  DSMF_DSMF_EC_OBS_EDGE_COUNT_BYP_START_IDX_OBS_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_EC_OBS_EDGE_COUNT_BYP_START_IDX_OBS_MASK) >> DSMF_DSMF_EC_OBS_EDGE_COUNT_BYP_START_IDX_OBS_SHIFT)
#define  DSMF_DSMF_EC_OBS_EDGE_COUNT_BYP_START_IDX_OBS_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_EC_OBS_EDGE_COUNT_BYP_START_IDX_OBS_MASK) | (((uint32_t)val) << DSMF_DSMF_EC_OBS_EDGE_COUNT_BYP_START_IDX_OBS_SHIFT))

#define  DSMF_DSMF_EC_OBS_EDGE_COUNT_OBS_MASK 0xffffff
#define  DSMF_DSMF_EC_OBS_EDGE_COUNT_OBS_SHIFT 0
#define  DSMF_DSMF_EC_OBS_EDGE_COUNT_OBS_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_EC_OBS_EDGE_COUNT_OBS_MASK) >> DSMF_DSMF_EC_OBS_EDGE_COUNT_OBS_SHIFT)
#define  DSMF_DSMF_EC_OBS_EDGE_COUNT_OBS_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_EC_OBS_EDGE_COUNT_OBS_MASK) | (((uint32_t)val) << DSMF_DSMF_EC_OBS_EDGE_COUNT_OBS_SHIFT))

//====================================================================
//Register: DSMF Edge Count Indices (DSMF_ECI)
//====================================================================

#define  DSMF_DSMF_ECI_RESERVED1_MASK 0xffe00000
#define  DSMF_DSMF_ECI_RESERVED1_SHIFT 21
#define  DSMF_DSMF_ECI_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_ECI_RESERVED1_MASK) >> DSMF_DSMF_ECI_RESERVED1_SHIFT)
#define  DSMF_DSMF_ECI_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_ECI_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_ECI_RESERVED1_SHIFT))

#define  DSMF_DSMF_ECI_EC_RST_IDX_MASK 0x1f0000
#define  DSMF_DSMF_ECI_EC_RST_IDX_SHIFT 16
#define  DSMF_DSMF_ECI_EC_RST_IDX_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_ECI_EC_RST_IDX_MASK) >> DSMF_DSMF_ECI_EC_RST_IDX_SHIFT)
#define  DSMF_DSMF_ECI_EC_RST_IDX_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_ECI_EC_RST_IDX_MASK) | (((uint32_t)val) << DSMF_DSMF_ECI_EC_RST_IDX_SHIFT))

#define  DSMF_DSMF_ECI_RESERVED2_MASK 0xe000
#define  DSMF_DSMF_ECI_RESERVED2_SHIFT 13
#define  DSMF_DSMF_ECI_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_ECI_RESERVED2_MASK) >> DSMF_DSMF_ECI_RESERVED2_SHIFT)
#define  DSMF_DSMF_ECI_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_ECI_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_ECI_RESERVED2_SHIFT))

#define  DSMF_DSMF_ECI_EC_END_IDX_MASK 0x1f00
#define  DSMF_DSMF_ECI_EC_END_IDX_SHIFT 8
#define  DSMF_DSMF_ECI_EC_END_IDX_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_ECI_EC_END_IDX_MASK) >> DSMF_DSMF_ECI_EC_END_IDX_SHIFT)
#define  DSMF_DSMF_ECI_EC_END_IDX_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_ECI_EC_END_IDX_MASK) | (((uint32_t)val) << DSMF_DSMF_ECI_EC_END_IDX_SHIFT))

#define  DSMF_DSMF_ECI_RESERVED3_MASK 0xe0
#define  DSMF_DSMF_ECI_RESERVED3_SHIFT 5
#define  DSMF_DSMF_ECI_RESERVED3_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_ECI_RESERVED3_MASK) >> DSMF_DSMF_ECI_RESERVED3_SHIFT)
#define  DSMF_DSMF_ECI_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_ECI_RESERVED3_MASK) | (((uint32_t)val) << DSMF_DSMF_ECI_RESERVED3_SHIFT))

#define  DSMF_DSMF_ECI_EC_ST_IDX_MASK 0x1f
#define  DSMF_DSMF_ECI_EC_ST_IDX_SHIFT 0
#define  DSMF_DSMF_ECI_EC_ST_IDX_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_ECI_EC_ST_IDX_MASK) >> DSMF_DSMF_ECI_EC_ST_IDX_SHIFT)
#define  DSMF_DSMF_ECI_EC_ST_IDX_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_ECI_EC_ST_IDX_MASK) | (((uint32_t)val) << DSMF_DSMF_ECI_EC_ST_IDX_SHIFT))

//====================================================================
//Register: DSMF Y Variable Coefficient00_01, Filter 0 (DSMF_YVC00_01)
/** \brief The following 5x5 filter coefficients (for Y and C) correspond to filt_coeff_sel = 0.
The following table is for reference to understand the names of the
coefficients with their position in a 9x9 pixel window.
<table>
<tr><td>Coef00</td><td>Coef01</td></td><td>Coef02</td><td>Coef03</td><td>Coef04</td><td>Coef03</td><td>Coef02</td><td>Coef01</td><td>Coef00</td></td></td></tr>
<tr><td>Coef10</td><td>Coef11</td></td><td>Coef12</td><td>Coef13</td><td>Coef14</td><td>Coef13</td><td>Coef12</td><td>Coef11</td><td>Coef10</td></td></td></tr>
<tr><td>Coef20</td><td>Coef21</td></td><td>Coef22</td><td>Coef23</td><td>Coef24</td><td>Coef23</td><td>Coef22</td><td>Coef21</td><td>Coef20</td></td></td></tr>
<tr><td>Coef30</td><td>Coef31</td></td><td>Coef32</td><td>Coef33</td><td>Coef34</td><td>Coef33</td><td>Coef32</td><td>Coef31</td><td>Coef30</td></td></td></tr>
<tr><td>Coef40</td><td>Coef41</td></td><td>Coef42</td><td>Coef43</td><td>Coef44</td><td>Coef43</td><td>Coef42</td><td>Coef41</td><td>Coef40</td></td></td></tr>
<tr><td>Coef30</td><td>Coef31</td></td><td>Coef32</td><td>Coef33</td><td>Coef34</td><td>Coef33</td><td>Coef32</td><td>Coef31</td><td>Coef30</td></td></td></tr>
<tr><td>Coef20</td><td>Coef21</td></td><td>Coef22</td><td>Coef23</td><td>Coef24</td><td>Coef23</td><td>Coef22</td><td>Coef21</td><td>Coef20</td></td></td></tr>
<tr><td>Coef10</td><td>Coef11</td></td><td>Coef12</td><td>Coef13</td><td>Coef14</td><td>Coef13</td><td>Coef11</td><td>Coef11</td><td>Coef10</td></td></td></tr>
<tr><td>Coef00</td><td>Coef01</td></td><td>Coef02</td><td>Coef03</td><td>Coef04</td><td>Coef03</td><td>Coef02</td><td>Coef01</td><td>Coef00</td></td></td></tr>
</table>*/
//====================================================================

#define  DSMF_DSMF_YVC00_01_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_YVC00_01_RESERVED1_SHIFT 27
#define  DSMF_DSMF_YVC00_01_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC00_01_RESERVED1_MASK) >> DSMF_DSMF_YVC00_01_RESERVED1_SHIFT)
#define  DSMF_DSMF_YVC00_01_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC00_01_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC00_01_RESERVED1_SHIFT))

#define  DSMF_DSMF_YVC00_01_B_MASK 0x7ff0000
#define  DSMF_DSMF_YVC00_01_B_SHIFT 16
#define  DSMF_DSMF_YVC00_01_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC00_01_B_MASK) >> DSMF_DSMF_YVC00_01_B_SHIFT)
#define  DSMF_DSMF_YVC00_01_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC00_01_B_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC00_01_B_SHIFT))

#define  DSMF_DSMF_YVC00_01_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_YVC00_01_RESERVED2_SHIFT 11
#define  DSMF_DSMF_YVC00_01_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC00_01_RESERVED2_MASK) >> DSMF_DSMF_YVC00_01_RESERVED2_SHIFT)
#define  DSMF_DSMF_YVC00_01_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC00_01_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC00_01_RESERVED2_SHIFT))

#define  DSMF_DSMF_YVC00_01_A_MASK 0x7ff
#define  DSMF_DSMF_YVC00_01_A_SHIFT 0
#define  DSMF_DSMF_YVC00_01_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC00_01_A_MASK) >> DSMF_DSMF_YVC00_01_A_SHIFT)
#define  DSMF_DSMF_YVC00_01_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC00_01_A_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC00_01_A_SHIFT))

//====================================================================
//Register: DSMF Y Variable Coefficient02_03, Filter 0 (DSMF_YVC02_03)
//====================================================================

#define  DSMF_DSMF_YVC02_03_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_YVC02_03_RESERVED1_SHIFT 27
#define  DSMF_DSMF_YVC02_03_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC02_03_RESERVED1_MASK) >> DSMF_DSMF_YVC02_03_RESERVED1_SHIFT)
#define  DSMF_DSMF_YVC02_03_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC02_03_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC02_03_RESERVED1_SHIFT))

#define  DSMF_DSMF_YVC02_03_B_MASK 0x7ff0000
#define  DSMF_DSMF_YVC02_03_B_SHIFT 16
#define  DSMF_DSMF_YVC02_03_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC02_03_B_MASK) >> DSMF_DSMF_YVC02_03_B_SHIFT)
#define  DSMF_DSMF_YVC02_03_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC02_03_B_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC02_03_B_SHIFT))

#define  DSMF_DSMF_YVC02_03_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_YVC02_03_RESERVED2_SHIFT 11
#define  DSMF_DSMF_YVC02_03_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC02_03_RESERVED2_MASK) >> DSMF_DSMF_YVC02_03_RESERVED2_SHIFT)
#define  DSMF_DSMF_YVC02_03_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC02_03_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC02_03_RESERVED2_SHIFT))

#define  DSMF_DSMF_YVC02_03_A_MASK 0x7ff
#define  DSMF_DSMF_YVC02_03_A_SHIFT 0
#define  DSMF_DSMF_YVC02_03_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC02_03_A_MASK) >> DSMF_DSMF_YVC02_03_A_SHIFT)
#define  DSMF_DSMF_YVC02_03_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC02_03_A_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC02_03_A_SHIFT))

//====================================================================
//Register: DSMF Y Variable Coefficient04_10, Filter 0 (DSMF_YVC04_10)
//====================================================================

#define  DSMF_DSMF_YVC04_10_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_YVC04_10_RESERVED1_SHIFT 27
#define  DSMF_DSMF_YVC04_10_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC04_10_RESERVED1_MASK) >> DSMF_DSMF_YVC04_10_RESERVED1_SHIFT)
#define  DSMF_DSMF_YVC04_10_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC04_10_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC04_10_RESERVED1_SHIFT))

#define  DSMF_DSMF_YVC04_10_B_MASK 0x7ff0000
#define  DSMF_DSMF_YVC04_10_B_SHIFT 16
#define  DSMF_DSMF_YVC04_10_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC04_10_B_MASK) >> DSMF_DSMF_YVC04_10_B_SHIFT)
#define  DSMF_DSMF_YVC04_10_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC04_10_B_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC04_10_B_SHIFT))

#define  DSMF_DSMF_YVC04_10_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_YVC04_10_RESERVED2_SHIFT 11
#define  DSMF_DSMF_YVC04_10_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC04_10_RESERVED2_MASK) >> DSMF_DSMF_YVC04_10_RESERVED2_SHIFT)
#define  DSMF_DSMF_YVC04_10_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC04_10_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC04_10_RESERVED2_SHIFT))

#define  DSMF_DSMF_YVC04_10_A_MASK 0x7ff
#define  DSMF_DSMF_YVC04_10_A_SHIFT 0
#define  DSMF_DSMF_YVC04_10_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC04_10_A_MASK) >> DSMF_DSMF_YVC04_10_A_SHIFT)
#define  DSMF_DSMF_YVC04_10_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC04_10_A_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC04_10_A_SHIFT))

//====================================================================
//Register: DSMF Y Variable Coefficient11_12, Filter 0 (DSMF_YVC11_12)
//====================================================================

#define  DSMF_DSMF_YVC11_12_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_YVC11_12_RESERVED1_SHIFT 27
#define  DSMF_DSMF_YVC11_12_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC11_12_RESERVED1_MASK) >> DSMF_DSMF_YVC11_12_RESERVED1_SHIFT)
#define  DSMF_DSMF_YVC11_12_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC11_12_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC11_12_RESERVED1_SHIFT))

#define  DSMF_DSMF_YVC11_12_B_MASK 0x7ff0000
#define  DSMF_DSMF_YVC11_12_B_SHIFT 16
#define  DSMF_DSMF_YVC11_12_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC11_12_B_MASK) >> DSMF_DSMF_YVC11_12_B_SHIFT)
#define  DSMF_DSMF_YVC11_12_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC11_12_B_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC11_12_B_SHIFT))

#define  DSMF_DSMF_YVC11_12_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_YVC11_12_RESERVED2_SHIFT 11
#define  DSMF_DSMF_YVC11_12_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC11_12_RESERVED2_MASK) >> DSMF_DSMF_YVC11_12_RESERVED2_SHIFT)
#define  DSMF_DSMF_YVC11_12_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC11_12_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC11_12_RESERVED2_SHIFT))

#define  DSMF_DSMF_YVC11_12_A_MASK 0x7ff
#define  DSMF_DSMF_YVC11_12_A_SHIFT 0
#define  DSMF_DSMF_YVC11_12_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC11_12_A_MASK) >> DSMF_DSMF_YVC11_12_A_SHIFT)
#define  DSMF_DSMF_YVC11_12_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC11_12_A_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC11_12_A_SHIFT))

//====================================================================
//Register: DSMF Y Variable Coefficient13_14, Filter 0 (DSMF_YVC13_14)
//====================================================================

#define  DSMF_DSMF_YVC13_14_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_YVC13_14_RESERVED1_SHIFT 27
#define  DSMF_DSMF_YVC13_14_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC13_14_RESERVED1_MASK) >> DSMF_DSMF_YVC13_14_RESERVED1_SHIFT)
#define  DSMF_DSMF_YVC13_14_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC13_14_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC13_14_RESERVED1_SHIFT))

#define  DSMF_DSMF_YVC13_14_B_MASK 0x7ff0000
#define  DSMF_DSMF_YVC13_14_B_SHIFT 16
#define  DSMF_DSMF_YVC13_14_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC13_14_B_MASK) >> DSMF_DSMF_YVC13_14_B_SHIFT)
#define  DSMF_DSMF_YVC13_14_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC13_14_B_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC13_14_B_SHIFT))

#define  DSMF_DSMF_YVC13_14_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_YVC13_14_RESERVED2_SHIFT 11
#define  DSMF_DSMF_YVC13_14_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC13_14_RESERVED2_MASK) >> DSMF_DSMF_YVC13_14_RESERVED2_SHIFT)
#define  DSMF_DSMF_YVC13_14_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC13_14_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC13_14_RESERVED2_SHIFT))

#define  DSMF_DSMF_YVC13_14_A_MASK 0x7ff
#define  DSMF_DSMF_YVC13_14_A_SHIFT 0
#define  DSMF_DSMF_YVC13_14_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC13_14_A_MASK) >> DSMF_DSMF_YVC13_14_A_SHIFT)
#define  DSMF_DSMF_YVC13_14_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC13_14_A_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC13_14_A_SHIFT))

//====================================================================
//Register: DSMF Y Variable Coefficient20_21, Filter 0 (DSMF_YVC20_21)
//====================================================================

#define  DSMF_DSMF_YVC20_21_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_YVC20_21_RESERVED1_SHIFT 27
#define  DSMF_DSMF_YVC20_21_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC20_21_RESERVED1_MASK) >> DSMF_DSMF_YVC20_21_RESERVED1_SHIFT)
#define  DSMF_DSMF_YVC20_21_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC20_21_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC20_21_RESERVED1_SHIFT))

#define  DSMF_DSMF_YVC20_21_B_MASK 0x7ff0000
#define  DSMF_DSMF_YVC20_21_B_SHIFT 16
#define  DSMF_DSMF_YVC20_21_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC20_21_B_MASK) >> DSMF_DSMF_YVC20_21_B_SHIFT)
#define  DSMF_DSMF_YVC20_21_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC20_21_B_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC20_21_B_SHIFT))

#define  DSMF_DSMF_YVC20_21_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_YVC20_21_RESERVED2_SHIFT 11
#define  DSMF_DSMF_YVC20_21_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC20_21_RESERVED2_MASK) >> DSMF_DSMF_YVC20_21_RESERVED2_SHIFT)
#define  DSMF_DSMF_YVC20_21_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC20_21_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC20_21_RESERVED2_SHIFT))

#define  DSMF_DSMF_YVC20_21_A_MASK 0x7ff
#define  DSMF_DSMF_YVC20_21_A_SHIFT 0
#define  DSMF_DSMF_YVC20_21_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC20_21_A_MASK) >> DSMF_DSMF_YVC20_21_A_SHIFT)
#define  DSMF_DSMF_YVC20_21_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC20_21_A_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC20_21_A_SHIFT))

//====================================================================
//Register: DSMF Y Variable Coefficient22_23, Filter 0 (DSMF_YVC22_23)
//====================================================================

#define  DSMF_DSMF_YVC22_23_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_YVC22_23_RESERVED1_SHIFT 27
#define  DSMF_DSMF_YVC22_23_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC22_23_RESERVED1_MASK) >> DSMF_DSMF_YVC22_23_RESERVED1_SHIFT)
#define  DSMF_DSMF_YVC22_23_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC22_23_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC22_23_RESERVED1_SHIFT))

#define  DSMF_DSMF_YVC22_23_B_MASK 0x7ff0000
#define  DSMF_DSMF_YVC22_23_B_SHIFT 16
#define  DSMF_DSMF_YVC22_23_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC22_23_B_MASK) >> DSMF_DSMF_YVC22_23_B_SHIFT)
#define  DSMF_DSMF_YVC22_23_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC22_23_B_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC22_23_B_SHIFT))

#define  DSMF_DSMF_YVC22_23_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_YVC22_23_RESERVED2_SHIFT 11
#define  DSMF_DSMF_YVC22_23_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC22_23_RESERVED2_MASK) >> DSMF_DSMF_YVC22_23_RESERVED2_SHIFT)
#define  DSMF_DSMF_YVC22_23_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC22_23_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC22_23_RESERVED2_SHIFT))

#define  DSMF_DSMF_YVC22_23_A_MASK 0x7ff
#define  DSMF_DSMF_YVC22_23_A_SHIFT 0
#define  DSMF_DSMF_YVC22_23_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC22_23_A_MASK) >> DSMF_DSMF_YVC22_23_A_SHIFT)
#define  DSMF_DSMF_YVC22_23_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC22_23_A_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC22_23_A_SHIFT))

//====================================================================
//Register: DSMF Y Variable Coefficient24, Filter 0 (DSMF_YVC24)
//====================================================================

#define  DSMF_DSMF_YVC24_RESERVED1_MASK 0xfffff800
#define  DSMF_DSMF_YVC24_RESERVED1_SHIFT 11
#define  DSMF_DSMF_YVC24_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC24_RESERVED1_MASK) >> DSMF_DSMF_YVC24_RESERVED1_SHIFT)
#define  DSMF_DSMF_YVC24_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC24_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC24_RESERVED1_SHIFT))

#define  DSMF_DSMF_YVC24_A_MASK 0x7ff
#define  DSMF_DSMF_YVC24_A_SHIFT 0
#define  DSMF_DSMF_YVC24_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC24_A_MASK) >> DSMF_DSMF_YVC24_A_SHIFT)
#define  DSMF_DSMF_YVC24_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC24_A_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC24_A_SHIFT))

//====================================================================
//Register: DSMF Y Variable Coefficient30_31, Filter 0 (DSMF_YVC30_31)
//====================================================================

#define  DSMF_DSMF_YVC30_31_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_YVC30_31_RESERVED1_SHIFT 27
#define  DSMF_DSMF_YVC30_31_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC30_31_RESERVED1_MASK) >> DSMF_DSMF_YVC30_31_RESERVED1_SHIFT)
#define  DSMF_DSMF_YVC30_31_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC30_31_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC30_31_RESERVED1_SHIFT))

#define  DSMF_DSMF_YVC30_31_B_MASK 0x7ff0000
#define  DSMF_DSMF_YVC30_31_B_SHIFT 16
#define  DSMF_DSMF_YVC30_31_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC30_31_B_MASK) >> DSMF_DSMF_YVC30_31_B_SHIFT)
#define  DSMF_DSMF_YVC30_31_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC30_31_B_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC30_31_B_SHIFT))

#define  DSMF_DSMF_YVC30_31_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_YVC30_31_RESERVED2_SHIFT 11
#define  DSMF_DSMF_YVC30_31_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC30_31_RESERVED2_MASK) >> DSMF_DSMF_YVC30_31_RESERVED2_SHIFT)
#define  DSMF_DSMF_YVC30_31_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC30_31_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC30_31_RESERVED2_SHIFT))

#define  DSMF_DSMF_YVC30_31_A_MASK 0x7ff
#define  DSMF_DSMF_YVC30_31_A_SHIFT 0
#define  DSMF_DSMF_YVC30_31_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC30_31_A_MASK) >> DSMF_DSMF_YVC30_31_A_SHIFT)
#define  DSMF_DSMF_YVC30_31_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC30_31_A_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC30_31_A_SHIFT))

//====================================================================
//Register: DSMF Y Variable Coefficient32_33, Filter 0 (DSMF_YVC32_33)
//====================================================================

#define  DSMF_DSMF_YVC32_33_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_YVC32_33_RESERVED1_SHIFT 27
#define  DSMF_DSMF_YVC32_33_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC32_33_RESERVED1_MASK) >> DSMF_DSMF_YVC32_33_RESERVED1_SHIFT)
#define  DSMF_DSMF_YVC32_33_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC32_33_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC32_33_RESERVED1_SHIFT))

#define  DSMF_DSMF_YVC32_33_B_MASK 0x7ff0000
#define  DSMF_DSMF_YVC32_33_B_SHIFT 16
#define  DSMF_DSMF_YVC32_33_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC32_33_B_MASK) >> DSMF_DSMF_YVC32_33_B_SHIFT)
#define  DSMF_DSMF_YVC32_33_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC32_33_B_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC32_33_B_SHIFT))

#define  DSMF_DSMF_YVC32_33_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_YVC32_33_RESERVED2_SHIFT 11
#define  DSMF_DSMF_YVC32_33_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC32_33_RESERVED2_MASK) >> DSMF_DSMF_YVC32_33_RESERVED2_SHIFT)
#define  DSMF_DSMF_YVC32_33_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC32_33_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC32_33_RESERVED2_SHIFT))

#define  DSMF_DSMF_YVC32_33_A_MASK 0x7ff
#define  DSMF_DSMF_YVC32_33_A_SHIFT 0
#define  DSMF_DSMF_YVC32_33_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC32_33_A_MASK) >> DSMF_DSMF_YVC32_33_A_SHIFT)
#define  DSMF_DSMF_YVC32_33_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC32_33_A_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC32_33_A_SHIFT))

//====================================================================
//Register: DSMF Y Variable Coefficient34_40, Filter 0 (DSMF_YVC34_40)
//====================================================================

#define  DSMF_DSMF_YVC34_40_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_YVC34_40_RESERVED1_SHIFT 27
#define  DSMF_DSMF_YVC34_40_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC34_40_RESERVED1_MASK) >> DSMF_DSMF_YVC34_40_RESERVED1_SHIFT)
#define  DSMF_DSMF_YVC34_40_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC34_40_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC34_40_RESERVED1_SHIFT))

#define  DSMF_DSMF_YVC34_40_B_MASK 0x7ff0000
#define  DSMF_DSMF_YVC34_40_B_SHIFT 16
#define  DSMF_DSMF_YVC34_40_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC34_40_B_MASK) >> DSMF_DSMF_YVC34_40_B_SHIFT)
#define  DSMF_DSMF_YVC34_40_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC34_40_B_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC34_40_B_SHIFT))

#define  DSMF_DSMF_YVC34_40_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_YVC34_40_RESERVED2_SHIFT 11
#define  DSMF_DSMF_YVC34_40_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC34_40_RESERVED2_MASK) >> DSMF_DSMF_YVC34_40_RESERVED2_SHIFT)
#define  DSMF_DSMF_YVC34_40_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC34_40_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC34_40_RESERVED2_SHIFT))

#define  DSMF_DSMF_YVC34_40_A_MASK 0x7ff
#define  DSMF_DSMF_YVC34_40_A_SHIFT 0
#define  DSMF_DSMF_YVC34_40_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC34_40_A_MASK) >> DSMF_DSMF_YVC34_40_A_SHIFT)
#define  DSMF_DSMF_YVC34_40_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC34_40_A_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC34_40_A_SHIFT))

//====================================================================
//Register: DSMF Y Variable Coefficient41_42, Filter 0 (DSMF_YVC41_42)
//====================================================================

#define  DSMF_DSMF_YVC41_42_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_YVC41_42_RESERVED1_SHIFT 27
#define  DSMF_DSMF_YVC41_42_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC41_42_RESERVED1_MASK) >> DSMF_DSMF_YVC41_42_RESERVED1_SHIFT)
#define  DSMF_DSMF_YVC41_42_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC41_42_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC41_42_RESERVED1_SHIFT))

#define  DSMF_DSMF_YVC41_42_B_MASK 0x7ff0000
#define  DSMF_DSMF_YVC41_42_B_SHIFT 16
#define  DSMF_DSMF_YVC41_42_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC41_42_B_MASK) >> DSMF_DSMF_YVC41_42_B_SHIFT)
#define  DSMF_DSMF_YVC41_42_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC41_42_B_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC41_42_B_SHIFT))

#define  DSMF_DSMF_YVC41_42_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_YVC41_42_RESERVED2_SHIFT 11
#define  DSMF_DSMF_YVC41_42_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC41_42_RESERVED2_MASK) >> DSMF_DSMF_YVC41_42_RESERVED2_SHIFT)
#define  DSMF_DSMF_YVC41_42_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC41_42_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC41_42_RESERVED2_SHIFT))

#define  DSMF_DSMF_YVC41_42_A_MASK 0x7ff
#define  DSMF_DSMF_YVC41_42_A_SHIFT 0
#define  DSMF_DSMF_YVC41_42_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC41_42_A_MASK) >> DSMF_DSMF_YVC41_42_A_SHIFT)
#define  DSMF_DSMF_YVC41_42_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC41_42_A_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC41_42_A_SHIFT))

//====================================================================
//Register: DSMF Y Variable Coefficient43_44, Filter 0 (DSMF_YVC43_44)
//====================================================================

#define  DSMF_DSMF_YVC43_44_RESERVED1_MASK 0xe0000000
#define  DSMF_DSMF_YVC43_44_RESERVED1_SHIFT 29
#define  DSMF_DSMF_YVC43_44_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC43_44_RESERVED1_MASK) >> DSMF_DSMF_YVC43_44_RESERVED1_SHIFT)
#define  DSMF_DSMF_YVC43_44_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC43_44_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC43_44_RESERVED1_SHIFT))

#define  DSMF_DSMF_YVC43_44_B_MASK 0x1fff0000
#define  DSMF_DSMF_YVC43_44_B_SHIFT 16
#define  DSMF_DSMF_YVC43_44_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC43_44_B_MASK) >> DSMF_DSMF_YVC43_44_B_SHIFT)
#define  DSMF_DSMF_YVC43_44_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC43_44_B_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC43_44_B_SHIFT))

#define  DSMF_DSMF_YVC43_44_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_YVC43_44_RESERVED2_SHIFT 11
#define  DSMF_DSMF_YVC43_44_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC43_44_RESERVED2_MASK) >> DSMF_DSMF_YVC43_44_RESERVED2_SHIFT)
#define  DSMF_DSMF_YVC43_44_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC43_44_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC43_44_RESERVED2_SHIFT))

#define  DSMF_DSMF_YVC43_44_A_MASK 0x7ff
#define  DSMF_DSMF_YVC43_44_A_SHIFT 0
#define  DSMF_DSMF_YVC43_44_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC43_44_A_MASK) >> DSMF_DSMF_YVC43_44_A_SHIFT)
#define  DSMF_DSMF_YVC43_44_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC43_44_A_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC43_44_A_SHIFT))

//====================================================================
//Register: DSMF Chroma Variable Coefficient00_01, Filter 0 (DSMF_CVC00_01)
//====================================================================

#define  DSMF_DSMF_CVC00_01_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_CVC00_01_RESERVED1_SHIFT 27
#define  DSMF_DSMF_CVC00_01_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC00_01_RESERVED1_MASK) >> DSMF_DSMF_CVC00_01_RESERVED1_SHIFT)
#define  DSMF_DSMF_CVC00_01_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC00_01_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC00_01_RESERVED1_SHIFT))

#define  DSMF_DSMF_CVC00_01_B_MASK 0x7ff0000
#define  DSMF_DSMF_CVC00_01_B_SHIFT 16
#define  DSMF_DSMF_CVC00_01_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC00_01_B_MASK) >> DSMF_DSMF_CVC00_01_B_SHIFT)
#define  DSMF_DSMF_CVC00_01_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC00_01_B_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC00_01_B_SHIFT))

#define  DSMF_DSMF_CVC00_01_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_CVC00_01_RESERVED2_SHIFT 11
#define  DSMF_DSMF_CVC00_01_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC00_01_RESERVED2_MASK) >> DSMF_DSMF_CVC00_01_RESERVED2_SHIFT)
#define  DSMF_DSMF_CVC00_01_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC00_01_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC00_01_RESERVED2_SHIFT))

#define  DSMF_DSMF_CVC00_01_A_MASK 0x7ff
#define  DSMF_DSMF_CVC00_01_A_SHIFT 0
#define  DSMF_DSMF_CVC00_01_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC00_01_A_MASK) >> DSMF_DSMF_CVC00_01_A_SHIFT)
#define  DSMF_DSMF_CVC00_01_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC00_01_A_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC00_01_A_SHIFT))

//====================================================================
//Register: DSMF Chroma Variable Coefficient02_03, Filter 0 (DSMF_CVC02_03)
//====================================================================

#define  DSMF_DSMF_CVC02_03_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_CVC02_03_RESERVED1_SHIFT 27
#define  DSMF_DSMF_CVC02_03_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC02_03_RESERVED1_MASK) >> DSMF_DSMF_CVC02_03_RESERVED1_SHIFT)
#define  DSMF_DSMF_CVC02_03_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC02_03_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC02_03_RESERVED1_SHIFT))

#define  DSMF_DSMF_CVC02_03_B_MASK 0x7ff0000
#define  DSMF_DSMF_CVC02_03_B_SHIFT 16
#define  DSMF_DSMF_CVC02_03_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC02_03_B_MASK) >> DSMF_DSMF_CVC02_03_B_SHIFT)
#define  DSMF_DSMF_CVC02_03_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC02_03_B_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC02_03_B_SHIFT))

#define  DSMF_DSMF_CVC02_03_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_CVC02_03_RESERVED2_SHIFT 11
#define  DSMF_DSMF_CVC02_03_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC02_03_RESERVED2_MASK) >> DSMF_DSMF_CVC02_03_RESERVED2_SHIFT)
#define  DSMF_DSMF_CVC02_03_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC02_03_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC02_03_RESERVED2_SHIFT))

#define  DSMF_DSMF_CVC02_03_A_MASK 0x7ff
#define  DSMF_DSMF_CVC02_03_A_SHIFT 0
#define  DSMF_DSMF_CVC02_03_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC02_03_A_MASK) >> DSMF_DSMF_CVC02_03_A_SHIFT)
#define  DSMF_DSMF_CVC02_03_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC02_03_A_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC02_03_A_SHIFT))

//====================================================================
//Register: DSMF Chroma Variable Coefficient04_10, Filter 0 (DSMF_CVC04_10)
//====================================================================

#define  DSMF_DSMF_CVC04_10_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_CVC04_10_RESERVED1_SHIFT 27
#define  DSMF_DSMF_CVC04_10_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC04_10_RESERVED1_MASK) >> DSMF_DSMF_CVC04_10_RESERVED1_SHIFT)
#define  DSMF_DSMF_CVC04_10_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC04_10_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC04_10_RESERVED1_SHIFT))

#define  DSMF_DSMF_CVC04_10_B_MASK 0x7ff0000
#define  DSMF_DSMF_CVC04_10_B_SHIFT 16
#define  DSMF_DSMF_CVC04_10_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC04_10_B_MASK) >> DSMF_DSMF_CVC04_10_B_SHIFT)
#define  DSMF_DSMF_CVC04_10_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC04_10_B_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC04_10_B_SHIFT))

#define  DSMF_DSMF_CVC04_10_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_CVC04_10_RESERVED2_SHIFT 11
#define  DSMF_DSMF_CVC04_10_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC04_10_RESERVED2_MASK) >> DSMF_DSMF_CVC04_10_RESERVED2_SHIFT)
#define  DSMF_DSMF_CVC04_10_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC04_10_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC04_10_RESERVED2_SHIFT))

#define  DSMF_DSMF_CVC04_10_A_MASK 0x7ff
#define  DSMF_DSMF_CVC04_10_A_SHIFT 0
#define  DSMF_DSMF_CVC04_10_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC04_10_A_MASK) >> DSMF_DSMF_CVC04_10_A_SHIFT)
#define  DSMF_DSMF_CVC04_10_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC04_10_A_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC04_10_A_SHIFT))

//====================================================================
//Register: DSMF Chroma Variable Coefficient11_12, Filter 0 (DSMF_CVC11_12)
//====================================================================

#define  DSMF_DSMF_CVC11_12_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_CVC11_12_RESERVED1_SHIFT 27
#define  DSMF_DSMF_CVC11_12_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC11_12_RESERVED1_MASK) >> DSMF_DSMF_CVC11_12_RESERVED1_SHIFT)
#define  DSMF_DSMF_CVC11_12_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC11_12_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC11_12_RESERVED1_SHIFT))

#define  DSMF_DSMF_CVC11_12_B_MASK 0x7ff0000
#define  DSMF_DSMF_CVC11_12_B_SHIFT 16
#define  DSMF_DSMF_CVC11_12_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC11_12_B_MASK) >> DSMF_DSMF_CVC11_12_B_SHIFT)
#define  DSMF_DSMF_CVC11_12_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC11_12_B_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC11_12_B_SHIFT))

#define  DSMF_DSMF_CVC11_12_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_CVC11_12_RESERVED2_SHIFT 11
#define  DSMF_DSMF_CVC11_12_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC11_12_RESERVED2_MASK) >> DSMF_DSMF_CVC11_12_RESERVED2_SHIFT)
#define  DSMF_DSMF_CVC11_12_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC11_12_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC11_12_RESERVED2_SHIFT))

#define  DSMF_DSMF_CVC11_12_A_MASK 0x7ff
#define  DSMF_DSMF_CVC11_12_A_SHIFT 0
#define  DSMF_DSMF_CVC11_12_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC11_12_A_MASK) >> DSMF_DSMF_CVC11_12_A_SHIFT)
#define  DSMF_DSMF_CVC11_12_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC11_12_A_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC11_12_A_SHIFT))

//====================================================================
//Register: DSMF Chroma Variable Coefficient13_14, Filter 0 (DSMF_CVC13_14)
//====================================================================

#define  DSMF_DSMF_CVC13_14_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_CVC13_14_RESERVED1_SHIFT 27
#define  DSMF_DSMF_CVC13_14_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC13_14_RESERVED1_MASK) >> DSMF_DSMF_CVC13_14_RESERVED1_SHIFT)
#define  DSMF_DSMF_CVC13_14_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC13_14_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC13_14_RESERVED1_SHIFT))

#define  DSMF_DSMF_CVC13_14_B_MASK 0x7ff0000
#define  DSMF_DSMF_CVC13_14_B_SHIFT 16
#define  DSMF_DSMF_CVC13_14_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC13_14_B_MASK) >> DSMF_DSMF_CVC13_14_B_SHIFT)
#define  DSMF_DSMF_CVC13_14_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC13_14_B_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC13_14_B_SHIFT))

#define  DSMF_DSMF_CVC13_14_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_CVC13_14_RESERVED2_SHIFT 11
#define  DSMF_DSMF_CVC13_14_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC13_14_RESERVED2_MASK) >> DSMF_DSMF_CVC13_14_RESERVED2_SHIFT)
#define  DSMF_DSMF_CVC13_14_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC13_14_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC13_14_RESERVED2_SHIFT))

#define  DSMF_DSMF_CVC13_14_A_MASK 0x7ff
#define  DSMF_DSMF_CVC13_14_A_SHIFT 0
#define  DSMF_DSMF_CVC13_14_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC13_14_A_MASK) >> DSMF_DSMF_CVC13_14_A_SHIFT)
#define  DSMF_DSMF_CVC13_14_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC13_14_A_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC13_14_A_SHIFT))

//====================================================================
//Register: DSMF Chroma Variable Coefficient20_21, Filter 0 (DSMF_CVC20_21)
//====================================================================

#define  DSMF_DSMF_CVC20_21_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_CVC20_21_RESERVED1_SHIFT 27
#define  DSMF_DSMF_CVC20_21_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC20_21_RESERVED1_MASK) >> DSMF_DSMF_CVC20_21_RESERVED1_SHIFT)
#define  DSMF_DSMF_CVC20_21_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC20_21_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC20_21_RESERVED1_SHIFT))

#define  DSMF_DSMF_CVC20_21_B_MASK 0x7ff0000
#define  DSMF_DSMF_CVC20_21_B_SHIFT 16
#define  DSMF_DSMF_CVC20_21_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC20_21_B_MASK) >> DSMF_DSMF_CVC20_21_B_SHIFT)
#define  DSMF_DSMF_CVC20_21_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC20_21_B_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC20_21_B_SHIFT))

#define  DSMF_DSMF_CVC20_21_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_CVC20_21_RESERVED2_SHIFT 11
#define  DSMF_DSMF_CVC20_21_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC20_21_RESERVED2_MASK) >> DSMF_DSMF_CVC20_21_RESERVED2_SHIFT)
#define  DSMF_DSMF_CVC20_21_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC20_21_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC20_21_RESERVED2_SHIFT))

#define  DSMF_DSMF_CVC20_21_A_MASK 0x7ff
#define  DSMF_DSMF_CVC20_21_A_SHIFT 0
#define  DSMF_DSMF_CVC20_21_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC20_21_A_MASK) >> DSMF_DSMF_CVC20_21_A_SHIFT)
#define  DSMF_DSMF_CVC20_21_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC20_21_A_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC20_21_A_SHIFT))

//====================================================================
//Register: DSMF Chroma Variable Coefficient22_23, Filter 0 (DSMF_CVC22_23)
//====================================================================

#define  DSMF_DSMF_CVC22_23_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_CVC22_23_RESERVED1_SHIFT 27
#define  DSMF_DSMF_CVC22_23_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC22_23_RESERVED1_MASK) >> DSMF_DSMF_CVC22_23_RESERVED1_SHIFT)
#define  DSMF_DSMF_CVC22_23_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC22_23_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC22_23_RESERVED1_SHIFT))

#define  DSMF_DSMF_CVC22_23_B_MASK 0x7ff0000
#define  DSMF_DSMF_CVC22_23_B_SHIFT 16
#define  DSMF_DSMF_CVC22_23_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC22_23_B_MASK) >> DSMF_DSMF_CVC22_23_B_SHIFT)
#define  DSMF_DSMF_CVC22_23_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC22_23_B_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC22_23_B_SHIFT))

#define  DSMF_DSMF_CVC22_23_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_CVC22_23_RESERVED2_SHIFT 11
#define  DSMF_DSMF_CVC22_23_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC22_23_RESERVED2_MASK) >> DSMF_DSMF_CVC22_23_RESERVED2_SHIFT)
#define  DSMF_DSMF_CVC22_23_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC22_23_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC22_23_RESERVED2_SHIFT))

#define  DSMF_DSMF_CVC22_23_A_MASK 0x7ff
#define  DSMF_DSMF_CVC22_23_A_SHIFT 0
#define  DSMF_DSMF_CVC22_23_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC22_23_A_MASK) >> DSMF_DSMF_CVC22_23_A_SHIFT)
#define  DSMF_DSMF_CVC22_23_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC22_23_A_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC22_23_A_SHIFT))

//====================================================================
//Register: DSMF Chroma Variable Coefficient24, Filter 0 (DSMF_CVC24)
//====================================================================

#define  DSMF_DSMF_CVC24_RESERVED1_MASK 0xfffff800
#define  DSMF_DSMF_CVC24_RESERVED1_SHIFT 11
#define  DSMF_DSMF_CVC24_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC24_RESERVED1_MASK) >> DSMF_DSMF_CVC24_RESERVED1_SHIFT)
#define  DSMF_DSMF_CVC24_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC24_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC24_RESERVED1_SHIFT))

#define  DSMF_DSMF_CVC24_A_MASK 0x7ff
#define  DSMF_DSMF_CVC24_A_SHIFT 0
#define  DSMF_DSMF_CVC24_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC24_A_MASK) >> DSMF_DSMF_CVC24_A_SHIFT)
#define  DSMF_DSMF_CVC24_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC24_A_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC24_A_SHIFT))

//====================================================================
//Register: DSMF Chroma Variable Coefficient30_31, Filter 0 (DSMF_CVC30_31)
//====================================================================

#define  DSMF_DSMF_CVC30_31_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_CVC30_31_RESERVED1_SHIFT 27
#define  DSMF_DSMF_CVC30_31_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC30_31_RESERVED1_MASK) >> DSMF_DSMF_CVC30_31_RESERVED1_SHIFT)
#define  DSMF_DSMF_CVC30_31_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC30_31_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC30_31_RESERVED1_SHIFT))

#define  DSMF_DSMF_CVC30_31_B_MASK 0x7ff0000
#define  DSMF_DSMF_CVC30_31_B_SHIFT 16
#define  DSMF_DSMF_CVC30_31_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC30_31_B_MASK) >> DSMF_DSMF_CVC30_31_B_SHIFT)
#define  DSMF_DSMF_CVC30_31_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC30_31_B_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC30_31_B_SHIFT))

#define  DSMF_DSMF_CVC30_31_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_CVC30_31_RESERVED2_SHIFT 11
#define  DSMF_DSMF_CVC30_31_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC30_31_RESERVED2_MASK) >> DSMF_DSMF_CVC30_31_RESERVED2_SHIFT)
#define  DSMF_DSMF_CVC30_31_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC30_31_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC30_31_RESERVED2_SHIFT))

#define  DSMF_DSMF_CVC30_31_A_MASK 0x7ff
#define  DSMF_DSMF_CVC30_31_A_SHIFT 0
#define  DSMF_DSMF_CVC30_31_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC30_31_A_MASK) >> DSMF_DSMF_CVC30_31_A_SHIFT)
#define  DSMF_DSMF_CVC30_31_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC30_31_A_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC30_31_A_SHIFT))

//====================================================================
//Register: DSMF Chroma Variable Coefficient32_33, Filter 0 (DSMF_CVC32_33)
//====================================================================

#define  DSMF_DSMF_CVC32_33_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_CVC32_33_RESERVED1_SHIFT 27
#define  DSMF_DSMF_CVC32_33_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC32_33_RESERVED1_MASK) >> DSMF_DSMF_CVC32_33_RESERVED1_SHIFT)
#define  DSMF_DSMF_CVC32_33_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC32_33_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC32_33_RESERVED1_SHIFT))

#define  DSMF_DSMF_CVC32_33_B_MASK 0x7ff0000
#define  DSMF_DSMF_CVC32_33_B_SHIFT 16
#define  DSMF_DSMF_CVC32_33_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC32_33_B_MASK) >> DSMF_DSMF_CVC32_33_B_SHIFT)
#define  DSMF_DSMF_CVC32_33_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC32_33_B_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC32_33_B_SHIFT))

#define  DSMF_DSMF_CVC32_33_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_CVC32_33_RESERVED2_SHIFT 11
#define  DSMF_DSMF_CVC32_33_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC32_33_RESERVED2_MASK) >> DSMF_DSMF_CVC32_33_RESERVED2_SHIFT)
#define  DSMF_DSMF_CVC32_33_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC32_33_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC32_33_RESERVED2_SHIFT))

#define  DSMF_DSMF_CVC32_33_A_MASK 0x7ff
#define  DSMF_DSMF_CVC32_33_A_SHIFT 0
#define  DSMF_DSMF_CVC32_33_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC32_33_A_MASK) >> DSMF_DSMF_CVC32_33_A_SHIFT)
#define  DSMF_DSMF_CVC32_33_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC32_33_A_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC32_33_A_SHIFT))

//====================================================================
//Register: DSMF Chroma Variable Coefficient34_40, Filter 0 (DSMF_CVC34_40)
//====================================================================

#define  DSMF_DSMF_CVC34_40_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_CVC34_40_RESERVED1_SHIFT 27
#define  DSMF_DSMF_CVC34_40_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC34_40_RESERVED1_MASK) >> DSMF_DSMF_CVC34_40_RESERVED1_SHIFT)
#define  DSMF_DSMF_CVC34_40_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC34_40_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC34_40_RESERVED1_SHIFT))

#define  DSMF_DSMF_CVC34_40_B_MASK 0x7ff0000
#define  DSMF_DSMF_CVC34_40_B_SHIFT 16
#define  DSMF_DSMF_CVC34_40_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC34_40_B_MASK) >> DSMF_DSMF_CVC34_40_B_SHIFT)
#define  DSMF_DSMF_CVC34_40_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC34_40_B_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC34_40_B_SHIFT))

#define  DSMF_DSMF_CVC34_40_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_CVC34_40_RESERVED2_SHIFT 11
#define  DSMF_DSMF_CVC34_40_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC34_40_RESERVED2_MASK) >> DSMF_DSMF_CVC34_40_RESERVED2_SHIFT)
#define  DSMF_DSMF_CVC34_40_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC34_40_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC34_40_RESERVED2_SHIFT))

#define  DSMF_DSMF_CVC34_40_A_MASK 0x7ff
#define  DSMF_DSMF_CVC34_40_A_SHIFT 0
#define  DSMF_DSMF_CVC34_40_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC34_40_A_MASK) >> DSMF_DSMF_CVC34_40_A_SHIFT)
#define  DSMF_DSMF_CVC34_40_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC34_40_A_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC34_40_A_SHIFT))

//====================================================================
//Register: DSMF Chroma Variable Coefficient41_42, Filter 0 (DSMF_CVC41_42)
//====================================================================

#define  DSMF_DSMF_CVC41_42_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_CVC41_42_RESERVED1_SHIFT 27
#define  DSMF_DSMF_CVC41_42_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC41_42_RESERVED1_MASK) >> DSMF_DSMF_CVC41_42_RESERVED1_SHIFT)
#define  DSMF_DSMF_CVC41_42_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC41_42_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC41_42_RESERVED1_SHIFT))

#define  DSMF_DSMF_CVC41_42_B_MASK 0x7ff0000
#define  DSMF_DSMF_CVC41_42_B_SHIFT 16
#define  DSMF_DSMF_CVC41_42_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC41_42_B_MASK) >> DSMF_DSMF_CVC41_42_B_SHIFT)
#define  DSMF_DSMF_CVC41_42_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC41_42_B_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC41_42_B_SHIFT))

#define  DSMF_DSMF_CVC41_42_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_CVC41_42_RESERVED2_SHIFT 11
#define  DSMF_DSMF_CVC41_42_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC41_42_RESERVED2_MASK) >> DSMF_DSMF_CVC41_42_RESERVED2_SHIFT)
#define  DSMF_DSMF_CVC41_42_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC41_42_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC41_42_RESERVED2_SHIFT))

#define  DSMF_DSMF_CVC41_42_A_MASK 0x7ff
#define  DSMF_DSMF_CVC41_42_A_SHIFT 0
#define  DSMF_DSMF_CVC41_42_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC41_42_A_MASK) >> DSMF_DSMF_CVC41_42_A_SHIFT)
#define  DSMF_DSMF_CVC41_42_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC41_42_A_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC41_42_A_SHIFT))

//====================================================================
//Register: DSMF Chroma Variable Coefficient43_44, Filter 0 (DSMF_CVC43_44)
//====================================================================

#define  DSMF_DSMF_CVC43_44_RESERVED1_MASK 0xe0000000
#define  DSMF_DSMF_CVC43_44_RESERVED1_SHIFT 29
#define  DSMF_DSMF_CVC43_44_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC43_44_RESERVED1_MASK) >> DSMF_DSMF_CVC43_44_RESERVED1_SHIFT)
#define  DSMF_DSMF_CVC43_44_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC43_44_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC43_44_RESERVED1_SHIFT))

#define  DSMF_DSMF_CVC43_44_B_MASK 0x1fff0000
#define  DSMF_DSMF_CVC43_44_B_SHIFT 16
#define  DSMF_DSMF_CVC43_44_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC43_44_B_MASK) >> DSMF_DSMF_CVC43_44_B_SHIFT)
#define  DSMF_DSMF_CVC43_44_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC43_44_B_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC43_44_B_SHIFT))

#define  DSMF_DSMF_CVC43_44_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_CVC43_44_RESERVED2_SHIFT 11
#define  DSMF_DSMF_CVC43_44_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC43_44_RESERVED2_MASK) >> DSMF_DSMF_CVC43_44_RESERVED2_SHIFT)
#define  DSMF_DSMF_CVC43_44_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC43_44_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC43_44_RESERVED2_SHIFT))

#define  DSMF_DSMF_CVC43_44_A_MASK 0x7ff
#define  DSMF_DSMF_CVC43_44_A_SHIFT 0
#define  DSMF_DSMF_CVC43_44_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC43_44_A_MASK) >> DSMF_DSMF_CVC43_44_A_SHIFT)
#define  DSMF_DSMF_CVC43_44_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC43_44_A_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC43_44_A_SHIFT))

//====================================================================
//Register: DSMF Filter Sum Multiplier, Filter 0 (DSMF_FILT_MULT)
//====================================================================

#define  DSMF_DSMF_FILT_MULT_Y_MULT_MASK 0xffff0000
#define  DSMF_DSMF_FILT_MULT_Y_MULT_SHIFT 16
#define  DSMF_DSMF_FILT_MULT_Y_MULT_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_FILT_MULT_Y_MULT_MASK) >> DSMF_DSMF_FILT_MULT_Y_MULT_SHIFT)
#define  DSMF_DSMF_FILT_MULT_Y_MULT_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_FILT_MULT_Y_MULT_MASK) | (((uint32_t)val) << DSMF_DSMF_FILT_MULT_Y_MULT_SHIFT))

#define  DSMF_DSMF_FILT_MULT_C_MULT_MASK 0xffff
#define  DSMF_DSMF_FILT_MULT_C_MULT_SHIFT 0
#define  DSMF_DSMF_FILT_MULT_C_MULT_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_FILT_MULT_C_MULT_MASK) >> DSMF_DSMF_FILT_MULT_C_MULT_SHIFT)
#define  DSMF_DSMF_FILT_MULT_C_MULT_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_FILT_MULT_C_MULT_MASK) | (((uint32_t)val) << DSMF_DSMF_FILT_MULT_C_MULT_SHIFT))

//====================================================================
//Register: DSMF Filter Sum Shift Factor, Filter 0 (DSMF_FILT_SHIFT)
//====================================================================

#define  DSMF_DSMF_FILT_SHIFT_RESERVED1_MASK 0xfffffc00
#define  DSMF_DSMF_FILT_SHIFT_RESERVED1_SHIFT 10
#define  DSMF_DSMF_FILT_SHIFT_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_FILT_SHIFT_RESERVED1_MASK) >> DSMF_DSMF_FILT_SHIFT_RESERVED1_SHIFT)
#define  DSMF_DSMF_FILT_SHIFT_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_FILT_SHIFT_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_FILT_SHIFT_RESERVED1_SHIFT))

#define  DSMF_DSMF_FILT_SHIFT_Y_SHIFT_MASK 0x3e0
#define  DSMF_DSMF_FILT_SHIFT_Y_SHIFT_SHIFT 5
#define  DSMF_DSMF_FILT_SHIFT_Y_SHIFT_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_FILT_SHIFT_Y_SHIFT_MASK) >> DSMF_DSMF_FILT_SHIFT_Y_SHIFT_SHIFT)
#define  DSMF_DSMF_FILT_SHIFT_Y_SHIFT_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_FILT_SHIFT_Y_SHIFT_MASK) | (((uint32_t)val) << DSMF_DSMF_FILT_SHIFT_Y_SHIFT_SHIFT))

#define  DSMF_DSMF_FILT_SHIFT_C_SHIFT_MASK 0x1f
#define  DSMF_DSMF_FILT_SHIFT_C_SHIFT_SHIFT 0
#define  DSMF_DSMF_FILT_SHIFT_C_SHIFT_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_FILT_SHIFT_C_SHIFT_MASK) >> DSMF_DSMF_FILT_SHIFT_C_SHIFT_SHIFT)
#define  DSMF_DSMF_FILT_SHIFT_C_SHIFT_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_FILT_SHIFT_C_SHIFT_MASK) | (((uint32_t)val) << DSMF_DSMF_FILT_SHIFT_C_SHIFT_SHIFT))

//====================================================================
//Register: DSMF Y Variable Coefficient00_01, Filter 1 (DSMF_YVC00_01_F1)
/** \brief The following 5x5 filter coefficients (for Y and C) correspond to filt_coeff_sel = 1.*/
//====================================================================

#define  DSMF_DSMF_YVC00_01_F1_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_YVC00_01_F1_RESERVED1_SHIFT 27
#define  DSMF_DSMF_YVC00_01_F1_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC00_01_F1_RESERVED1_MASK) >> DSMF_DSMF_YVC00_01_F1_RESERVED1_SHIFT)
#define  DSMF_DSMF_YVC00_01_F1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC00_01_F1_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC00_01_F1_RESERVED1_SHIFT))

#define  DSMF_DSMF_YVC00_01_F1_B_MASK 0x7ff0000
#define  DSMF_DSMF_YVC00_01_F1_B_SHIFT 16
#define  DSMF_DSMF_YVC00_01_F1_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC00_01_F1_B_MASK) >> DSMF_DSMF_YVC00_01_F1_B_SHIFT)
#define  DSMF_DSMF_YVC00_01_F1_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC00_01_F1_B_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC00_01_F1_B_SHIFT))

#define  DSMF_DSMF_YVC00_01_F1_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_YVC00_01_F1_RESERVED2_SHIFT 11
#define  DSMF_DSMF_YVC00_01_F1_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC00_01_F1_RESERVED2_MASK) >> DSMF_DSMF_YVC00_01_F1_RESERVED2_SHIFT)
#define  DSMF_DSMF_YVC00_01_F1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC00_01_F1_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC00_01_F1_RESERVED2_SHIFT))

#define  DSMF_DSMF_YVC00_01_F1_A_MASK 0x7ff
#define  DSMF_DSMF_YVC00_01_F1_A_SHIFT 0
#define  DSMF_DSMF_YVC00_01_F1_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC00_01_F1_A_MASK) >> DSMF_DSMF_YVC00_01_F1_A_SHIFT)
#define  DSMF_DSMF_YVC00_01_F1_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC00_01_F1_A_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC00_01_F1_A_SHIFT))

//====================================================================
//Register: DSMF Y Variable Coefficient02_03, Filter 1 (DSMF_YVC02_03_F1)
//====================================================================

#define  DSMF_DSMF_YVC02_03_F1_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_YVC02_03_F1_RESERVED1_SHIFT 27
#define  DSMF_DSMF_YVC02_03_F1_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC02_03_F1_RESERVED1_MASK) >> DSMF_DSMF_YVC02_03_F1_RESERVED1_SHIFT)
#define  DSMF_DSMF_YVC02_03_F1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC02_03_F1_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC02_03_F1_RESERVED1_SHIFT))

#define  DSMF_DSMF_YVC02_03_F1_B_MASK 0x7ff0000
#define  DSMF_DSMF_YVC02_03_F1_B_SHIFT 16
#define  DSMF_DSMF_YVC02_03_F1_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC02_03_F1_B_MASK) >> DSMF_DSMF_YVC02_03_F1_B_SHIFT)
#define  DSMF_DSMF_YVC02_03_F1_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC02_03_F1_B_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC02_03_F1_B_SHIFT))

#define  DSMF_DSMF_YVC02_03_F1_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_YVC02_03_F1_RESERVED2_SHIFT 11
#define  DSMF_DSMF_YVC02_03_F1_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC02_03_F1_RESERVED2_MASK) >> DSMF_DSMF_YVC02_03_F1_RESERVED2_SHIFT)
#define  DSMF_DSMF_YVC02_03_F1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC02_03_F1_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC02_03_F1_RESERVED2_SHIFT))

#define  DSMF_DSMF_YVC02_03_F1_A_MASK 0x7ff
#define  DSMF_DSMF_YVC02_03_F1_A_SHIFT 0
#define  DSMF_DSMF_YVC02_03_F1_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC02_03_F1_A_MASK) >> DSMF_DSMF_YVC02_03_F1_A_SHIFT)
#define  DSMF_DSMF_YVC02_03_F1_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC02_03_F1_A_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC02_03_F1_A_SHIFT))

//====================================================================
//Register: DSMF Y Variable Coefficient04_10, Filter 1 (DSMF_YVC04_10_F1)
//====================================================================

#define  DSMF_DSMF_YVC04_10_F1_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_YVC04_10_F1_RESERVED1_SHIFT 27
#define  DSMF_DSMF_YVC04_10_F1_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC04_10_F1_RESERVED1_MASK) >> DSMF_DSMF_YVC04_10_F1_RESERVED1_SHIFT)
#define  DSMF_DSMF_YVC04_10_F1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC04_10_F1_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC04_10_F1_RESERVED1_SHIFT))

#define  DSMF_DSMF_YVC04_10_F1_B_MASK 0x7ff0000
#define  DSMF_DSMF_YVC04_10_F1_B_SHIFT 16
#define  DSMF_DSMF_YVC04_10_F1_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC04_10_F1_B_MASK) >> DSMF_DSMF_YVC04_10_F1_B_SHIFT)
#define  DSMF_DSMF_YVC04_10_F1_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC04_10_F1_B_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC04_10_F1_B_SHIFT))

#define  DSMF_DSMF_YVC04_10_F1_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_YVC04_10_F1_RESERVED2_SHIFT 11
#define  DSMF_DSMF_YVC04_10_F1_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC04_10_F1_RESERVED2_MASK) >> DSMF_DSMF_YVC04_10_F1_RESERVED2_SHIFT)
#define  DSMF_DSMF_YVC04_10_F1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC04_10_F1_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC04_10_F1_RESERVED2_SHIFT))

#define  DSMF_DSMF_YVC04_10_F1_A_MASK 0x7ff
#define  DSMF_DSMF_YVC04_10_F1_A_SHIFT 0
#define  DSMF_DSMF_YVC04_10_F1_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC04_10_F1_A_MASK) >> DSMF_DSMF_YVC04_10_F1_A_SHIFT)
#define  DSMF_DSMF_YVC04_10_F1_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC04_10_F1_A_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC04_10_F1_A_SHIFT))

//====================================================================
//Register: DSMF Y Variable Coefficient11_12, Filter 1 (DSMF_YVC11_12_F1)
//====================================================================

#define  DSMF_DSMF_YVC11_12_F1_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_YVC11_12_F1_RESERVED1_SHIFT 27
#define  DSMF_DSMF_YVC11_12_F1_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC11_12_F1_RESERVED1_MASK) >> DSMF_DSMF_YVC11_12_F1_RESERVED1_SHIFT)
#define  DSMF_DSMF_YVC11_12_F1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC11_12_F1_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC11_12_F1_RESERVED1_SHIFT))

#define  DSMF_DSMF_YVC11_12_F1_B_MASK 0x7ff0000
#define  DSMF_DSMF_YVC11_12_F1_B_SHIFT 16
#define  DSMF_DSMF_YVC11_12_F1_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC11_12_F1_B_MASK) >> DSMF_DSMF_YVC11_12_F1_B_SHIFT)
#define  DSMF_DSMF_YVC11_12_F1_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC11_12_F1_B_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC11_12_F1_B_SHIFT))

#define  DSMF_DSMF_YVC11_12_F1_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_YVC11_12_F1_RESERVED2_SHIFT 11
#define  DSMF_DSMF_YVC11_12_F1_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC11_12_F1_RESERVED2_MASK) >> DSMF_DSMF_YVC11_12_F1_RESERVED2_SHIFT)
#define  DSMF_DSMF_YVC11_12_F1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC11_12_F1_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC11_12_F1_RESERVED2_SHIFT))

#define  DSMF_DSMF_YVC11_12_F1_A_MASK 0x7ff
#define  DSMF_DSMF_YVC11_12_F1_A_SHIFT 0
#define  DSMF_DSMF_YVC11_12_F1_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC11_12_F1_A_MASK) >> DSMF_DSMF_YVC11_12_F1_A_SHIFT)
#define  DSMF_DSMF_YVC11_12_F1_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC11_12_F1_A_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC11_12_F1_A_SHIFT))

//====================================================================
//Register: DSMF Y Variable Coefficient13_14, Filter 1 (DSMF_YVC13_14_F1)
//====================================================================

#define  DSMF_DSMF_YVC13_14_F1_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_YVC13_14_F1_RESERVED1_SHIFT 27
#define  DSMF_DSMF_YVC13_14_F1_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC13_14_F1_RESERVED1_MASK) >> DSMF_DSMF_YVC13_14_F1_RESERVED1_SHIFT)
#define  DSMF_DSMF_YVC13_14_F1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC13_14_F1_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC13_14_F1_RESERVED1_SHIFT))

#define  DSMF_DSMF_YVC13_14_F1_B_MASK 0x7ff0000
#define  DSMF_DSMF_YVC13_14_F1_B_SHIFT 16
#define  DSMF_DSMF_YVC13_14_F1_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC13_14_F1_B_MASK) >> DSMF_DSMF_YVC13_14_F1_B_SHIFT)
#define  DSMF_DSMF_YVC13_14_F1_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC13_14_F1_B_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC13_14_F1_B_SHIFT))

#define  DSMF_DSMF_YVC13_14_F1_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_YVC13_14_F1_RESERVED2_SHIFT 11
#define  DSMF_DSMF_YVC13_14_F1_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC13_14_F1_RESERVED2_MASK) >> DSMF_DSMF_YVC13_14_F1_RESERVED2_SHIFT)
#define  DSMF_DSMF_YVC13_14_F1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC13_14_F1_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC13_14_F1_RESERVED2_SHIFT))

#define  DSMF_DSMF_YVC13_14_F1_A_MASK 0x7ff
#define  DSMF_DSMF_YVC13_14_F1_A_SHIFT 0
#define  DSMF_DSMF_YVC13_14_F1_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC13_14_F1_A_MASK) >> DSMF_DSMF_YVC13_14_F1_A_SHIFT)
#define  DSMF_DSMF_YVC13_14_F1_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC13_14_F1_A_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC13_14_F1_A_SHIFT))

//====================================================================
//Register: DSMF Y Variable Coefficient20_21, Filter 1 (DSMF_YVC20_21_F1)
//====================================================================

#define  DSMF_DSMF_YVC20_21_F1_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_YVC20_21_F1_RESERVED1_SHIFT 27
#define  DSMF_DSMF_YVC20_21_F1_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC20_21_F1_RESERVED1_MASK) >> DSMF_DSMF_YVC20_21_F1_RESERVED1_SHIFT)
#define  DSMF_DSMF_YVC20_21_F1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC20_21_F1_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC20_21_F1_RESERVED1_SHIFT))

#define  DSMF_DSMF_YVC20_21_F1_B_MASK 0x7ff0000
#define  DSMF_DSMF_YVC20_21_F1_B_SHIFT 16
#define  DSMF_DSMF_YVC20_21_F1_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC20_21_F1_B_MASK) >> DSMF_DSMF_YVC20_21_F1_B_SHIFT)
#define  DSMF_DSMF_YVC20_21_F1_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC20_21_F1_B_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC20_21_F1_B_SHIFT))

#define  DSMF_DSMF_YVC20_21_F1_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_YVC20_21_F1_RESERVED2_SHIFT 11
#define  DSMF_DSMF_YVC20_21_F1_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC20_21_F1_RESERVED2_MASK) >> DSMF_DSMF_YVC20_21_F1_RESERVED2_SHIFT)
#define  DSMF_DSMF_YVC20_21_F1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC20_21_F1_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC20_21_F1_RESERVED2_SHIFT))

#define  DSMF_DSMF_YVC20_21_F1_A_MASK 0x7ff
#define  DSMF_DSMF_YVC20_21_F1_A_SHIFT 0
#define  DSMF_DSMF_YVC20_21_F1_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC20_21_F1_A_MASK) >> DSMF_DSMF_YVC20_21_F1_A_SHIFT)
#define  DSMF_DSMF_YVC20_21_F1_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC20_21_F1_A_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC20_21_F1_A_SHIFT))

//====================================================================
//Register: DSMF Y Variable Coefficient22_23, Filter 1 (DSMF_YVC22_23_F1)
//====================================================================

#define  DSMF_DSMF_YVC22_23_F1_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_YVC22_23_F1_RESERVED1_SHIFT 27
#define  DSMF_DSMF_YVC22_23_F1_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC22_23_F1_RESERVED1_MASK) >> DSMF_DSMF_YVC22_23_F1_RESERVED1_SHIFT)
#define  DSMF_DSMF_YVC22_23_F1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC22_23_F1_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC22_23_F1_RESERVED1_SHIFT))

#define  DSMF_DSMF_YVC22_23_F1_B_MASK 0x7ff0000
#define  DSMF_DSMF_YVC22_23_F1_B_SHIFT 16
#define  DSMF_DSMF_YVC22_23_F1_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC22_23_F1_B_MASK) >> DSMF_DSMF_YVC22_23_F1_B_SHIFT)
#define  DSMF_DSMF_YVC22_23_F1_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC22_23_F1_B_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC22_23_F1_B_SHIFT))

#define  DSMF_DSMF_YVC22_23_F1_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_YVC22_23_F1_RESERVED2_SHIFT 11
#define  DSMF_DSMF_YVC22_23_F1_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC22_23_F1_RESERVED2_MASK) >> DSMF_DSMF_YVC22_23_F1_RESERVED2_SHIFT)
#define  DSMF_DSMF_YVC22_23_F1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC22_23_F1_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC22_23_F1_RESERVED2_SHIFT))

#define  DSMF_DSMF_YVC22_23_F1_A_MASK 0x7ff
#define  DSMF_DSMF_YVC22_23_F1_A_SHIFT 0
#define  DSMF_DSMF_YVC22_23_F1_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC22_23_F1_A_MASK) >> DSMF_DSMF_YVC22_23_F1_A_SHIFT)
#define  DSMF_DSMF_YVC22_23_F1_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC22_23_F1_A_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC22_23_F1_A_SHIFT))

//====================================================================
//Register: DSMF Y Variable Coefficient24, Filter 1 (DSMF_YVC24_F1)
//====================================================================

#define  DSMF_DSMF_YVC24_F1_RESERVED1_MASK 0xfffff800
#define  DSMF_DSMF_YVC24_F1_RESERVED1_SHIFT 11
#define  DSMF_DSMF_YVC24_F1_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC24_F1_RESERVED1_MASK) >> DSMF_DSMF_YVC24_F1_RESERVED1_SHIFT)
#define  DSMF_DSMF_YVC24_F1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC24_F1_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC24_F1_RESERVED1_SHIFT))

#define  DSMF_DSMF_YVC24_F1_A_MASK 0x7ff
#define  DSMF_DSMF_YVC24_F1_A_SHIFT 0
#define  DSMF_DSMF_YVC24_F1_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC24_F1_A_MASK) >> DSMF_DSMF_YVC24_F1_A_SHIFT)
#define  DSMF_DSMF_YVC24_F1_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC24_F1_A_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC24_F1_A_SHIFT))

//====================================================================
//Register: DSMF Y Variable Coefficient30_31, Filter 1 (DSMF_YVC30_31_F1)
//====================================================================

#define  DSMF_DSMF_YVC30_31_F1_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_YVC30_31_F1_RESERVED1_SHIFT 27
#define  DSMF_DSMF_YVC30_31_F1_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC30_31_F1_RESERVED1_MASK) >> DSMF_DSMF_YVC30_31_F1_RESERVED1_SHIFT)
#define  DSMF_DSMF_YVC30_31_F1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC30_31_F1_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC30_31_F1_RESERVED1_SHIFT))

#define  DSMF_DSMF_YVC30_31_F1_B_MASK 0x7ff0000
#define  DSMF_DSMF_YVC30_31_F1_B_SHIFT 16
#define  DSMF_DSMF_YVC30_31_F1_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC30_31_F1_B_MASK) >> DSMF_DSMF_YVC30_31_F1_B_SHIFT)
#define  DSMF_DSMF_YVC30_31_F1_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC30_31_F1_B_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC30_31_F1_B_SHIFT))

#define  DSMF_DSMF_YVC30_31_F1_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_YVC30_31_F1_RESERVED2_SHIFT 11
#define  DSMF_DSMF_YVC30_31_F1_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC30_31_F1_RESERVED2_MASK) >> DSMF_DSMF_YVC30_31_F1_RESERVED2_SHIFT)
#define  DSMF_DSMF_YVC30_31_F1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC30_31_F1_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC30_31_F1_RESERVED2_SHIFT))

#define  DSMF_DSMF_YVC30_31_F1_A_MASK 0x7ff
#define  DSMF_DSMF_YVC30_31_F1_A_SHIFT 0
#define  DSMF_DSMF_YVC30_31_F1_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC30_31_F1_A_MASK) >> DSMF_DSMF_YVC30_31_F1_A_SHIFT)
#define  DSMF_DSMF_YVC30_31_F1_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC30_31_F1_A_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC30_31_F1_A_SHIFT))

//====================================================================
//Register: DSMF Y Variable Coefficient32_33, Filter 1 (DSMF_YVC32_33_F1)
//====================================================================

#define  DSMF_DSMF_YVC32_33_F1_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_YVC32_33_F1_RESERVED1_SHIFT 27
#define  DSMF_DSMF_YVC32_33_F1_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC32_33_F1_RESERVED1_MASK) >> DSMF_DSMF_YVC32_33_F1_RESERVED1_SHIFT)
#define  DSMF_DSMF_YVC32_33_F1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC32_33_F1_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC32_33_F1_RESERVED1_SHIFT))

#define  DSMF_DSMF_YVC32_33_F1_B_MASK 0x7ff0000
#define  DSMF_DSMF_YVC32_33_F1_B_SHIFT 16
#define  DSMF_DSMF_YVC32_33_F1_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC32_33_F1_B_MASK) >> DSMF_DSMF_YVC32_33_F1_B_SHIFT)
#define  DSMF_DSMF_YVC32_33_F1_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC32_33_F1_B_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC32_33_F1_B_SHIFT))

#define  DSMF_DSMF_YVC32_33_F1_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_YVC32_33_F1_RESERVED2_SHIFT 11
#define  DSMF_DSMF_YVC32_33_F1_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC32_33_F1_RESERVED2_MASK) >> DSMF_DSMF_YVC32_33_F1_RESERVED2_SHIFT)
#define  DSMF_DSMF_YVC32_33_F1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC32_33_F1_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC32_33_F1_RESERVED2_SHIFT))

#define  DSMF_DSMF_YVC32_33_F1_A_MASK 0x7ff
#define  DSMF_DSMF_YVC32_33_F1_A_SHIFT 0
#define  DSMF_DSMF_YVC32_33_F1_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC32_33_F1_A_MASK) >> DSMF_DSMF_YVC32_33_F1_A_SHIFT)
#define  DSMF_DSMF_YVC32_33_F1_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC32_33_F1_A_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC32_33_F1_A_SHIFT))

//====================================================================
//Register: DSMF Y Variable Coefficient34_40, Filter 1 (DSMF_YVC34_40_F1)
//====================================================================

#define  DSMF_DSMF_YVC34_40_F1_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_YVC34_40_F1_RESERVED1_SHIFT 27
#define  DSMF_DSMF_YVC34_40_F1_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC34_40_F1_RESERVED1_MASK) >> DSMF_DSMF_YVC34_40_F1_RESERVED1_SHIFT)
#define  DSMF_DSMF_YVC34_40_F1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC34_40_F1_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC34_40_F1_RESERVED1_SHIFT))

#define  DSMF_DSMF_YVC34_40_F1_B_MASK 0x7ff0000
#define  DSMF_DSMF_YVC34_40_F1_B_SHIFT 16
#define  DSMF_DSMF_YVC34_40_F1_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC34_40_F1_B_MASK) >> DSMF_DSMF_YVC34_40_F1_B_SHIFT)
#define  DSMF_DSMF_YVC34_40_F1_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC34_40_F1_B_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC34_40_F1_B_SHIFT))

#define  DSMF_DSMF_YVC34_40_F1_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_YVC34_40_F1_RESERVED2_SHIFT 11
#define  DSMF_DSMF_YVC34_40_F1_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC34_40_F1_RESERVED2_MASK) >> DSMF_DSMF_YVC34_40_F1_RESERVED2_SHIFT)
#define  DSMF_DSMF_YVC34_40_F1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC34_40_F1_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC34_40_F1_RESERVED2_SHIFT))

#define  DSMF_DSMF_YVC34_40_F1_A_MASK 0x7ff
#define  DSMF_DSMF_YVC34_40_F1_A_SHIFT 0
#define  DSMF_DSMF_YVC34_40_F1_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC34_40_F1_A_MASK) >> DSMF_DSMF_YVC34_40_F1_A_SHIFT)
#define  DSMF_DSMF_YVC34_40_F1_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC34_40_F1_A_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC34_40_F1_A_SHIFT))

//====================================================================
//Register: DSMF Y Variable Coefficient41_42, Filter 1 (DSMF_YVC41_42_F1)
//====================================================================

#define  DSMF_DSMF_YVC41_42_F1_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_YVC41_42_F1_RESERVED1_SHIFT 27
#define  DSMF_DSMF_YVC41_42_F1_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC41_42_F1_RESERVED1_MASK) >> DSMF_DSMF_YVC41_42_F1_RESERVED1_SHIFT)
#define  DSMF_DSMF_YVC41_42_F1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC41_42_F1_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC41_42_F1_RESERVED1_SHIFT))

#define  DSMF_DSMF_YVC41_42_F1_B_MASK 0x7ff0000
#define  DSMF_DSMF_YVC41_42_F1_B_SHIFT 16
#define  DSMF_DSMF_YVC41_42_F1_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC41_42_F1_B_MASK) >> DSMF_DSMF_YVC41_42_F1_B_SHIFT)
#define  DSMF_DSMF_YVC41_42_F1_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC41_42_F1_B_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC41_42_F1_B_SHIFT))

#define  DSMF_DSMF_YVC41_42_F1_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_YVC41_42_F1_RESERVED2_SHIFT 11
#define  DSMF_DSMF_YVC41_42_F1_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC41_42_F1_RESERVED2_MASK) >> DSMF_DSMF_YVC41_42_F1_RESERVED2_SHIFT)
#define  DSMF_DSMF_YVC41_42_F1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC41_42_F1_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC41_42_F1_RESERVED2_SHIFT))

#define  DSMF_DSMF_YVC41_42_F1_A_MASK 0x7ff
#define  DSMF_DSMF_YVC41_42_F1_A_SHIFT 0
#define  DSMF_DSMF_YVC41_42_F1_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC41_42_F1_A_MASK) >> DSMF_DSMF_YVC41_42_F1_A_SHIFT)
#define  DSMF_DSMF_YVC41_42_F1_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC41_42_F1_A_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC41_42_F1_A_SHIFT))

//====================================================================
//Register: DSMF Y Variable Coefficient43_44, Filter 1 (DSMF_YVC43_44_F1)
//====================================================================

#define  DSMF_DSMF_YVC43_44_F1_RESERVED1_MASK 0xe0000000
#define  DSMF_DSMF_YVC43_44_F1_RESERVED1_SHIFT 29
#define  DSMF_DSMF_YVC43_44_F1_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC43_44_F1_RESERVED1_MASK) >> DSMF_DSMF_YVC43_44_F1_RESERVED1_SHIFT)
#define  DSMF_DSMF_YVC43_44_F1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC43_44_F1_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC43_44_F1_RESERVED1_SHIFT))

#define  DSMF_DSMF_YVC43_44_F1_B_MASK 0x1fff0000
#define  DSMF_DSMF_YVC43_44_F1_B_SHIFT 16
#define  DSMF_DSMF_YVC43_44_F1_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC43_44_F1_B_MASK) >> DSMF_DSMF_YVC43_44_F1_B_SHIFT)
#define  DSMF_DSMF_YVC43_44_F1_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC43_44_F1_B_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC43_44_F1_B_SHIFT))

#define  DSMF_DSMF_YVC43_44_F1_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_YVC43_44_F1_RESERVED2_SHIFT 11
#define  DSMF_DSMF_YVC43_44_F1_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC43_44_F1_RESERVED2_MASK) >> DSMF_DSMF_YVC43_44_F1_RESERVED2_SHIFT)
#define  DSMF_DSMF_YVC43_44_F1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC43_44_F1_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC43_44_F1_RESERVED2_SHIFT))

#define  DSMF_DSMF_YVC43_44_F1_A_MASK 0x7ff
#define  DSMF_DSMF_YVC43_44_F1_A_SHIFT 0
#define  DSMF_DSMF_YVC43_44_F1_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC43_44_F1_A_MASK) >> DSMF_DSMF_YVC43_44_F1_A_SHIFT)
#define  DSMF_DSMF_YVC43_44_F1_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC43_44_F1_A_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC43_44_F1_A_SHIFT))

//====================================================================
//Register: DSMF Chroma Variable Coefficient00_01, Filter 1 (DSMF_CVC00_01_F1)
//====================================================================

#define  DSMF_DSMF_CVC00_01_F1_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_CVC00_01_F1_RESERVED1_SHIFT 27
#define  DSMF_DSMF_CVC00_01_F1_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC00_01_F1_RESERVED1_MASK) >> DSMF_DSMF_CVC00_01_F1_RESERVED1_SHIFT)
#define  DSMF_DSMF_CVC00_01_F1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC00_01_F1_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC00_01_F1_RESERVED1_SHIFT))

#define  DSMF_DSMF_CVC00_01_F1_B_MASK 0x7ff0000
#define  DSMF_DSMF_CVC00_01_F1_B_SHIFT 16
#define  DSMF_DSMF_CVC00_01_F1_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC00_01_F1_B_MASK) >> DSMF_DSMF_CVC00_01_F1_B_SHIFT)
#define  DSMF_DSMF_CVC00_01_F1_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC00_01_F1_B_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC00_01_F1_B_SHIFT))

#define  DSMF_DSMF_CVC00_01_F1_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_CVC00_01_F1_RESERVED2_SHIFT 11
#define  DSMF_DSMF_CVC00_01_F1_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC00_01_F1_RESERVED2_MASK) >> DSMF_DSMF_CVC00_01_F1_RESERVED2_SHIFT)
#define  DSMF_DSMF_CVC00_01_F1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC00_01_F1_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC00_01_F1_RESERVED2_SHIFT))

#define  DSMF_DSMF_CVC00_01_F1_A_MASK 0x7ff
#define  DSMF_DSMF_CVC00_01_F1_A_SHIFT 0
#define  DSMF_DSMF_CVC00_01_F1_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC00_01_F1_A_MASK) >> DSMF_DSMF_CVC00_01_F1_A_SHIFT)
#define  DSMF_DSMF_CVC00_01_F1_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC00_01_F1_A_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC00_01_F1_A_SHIFT))

//====================================================================
//Register: DSMF Chroma Variable Coefficient02_03, Filter 1 (DSMF_CVC02_03_F1)
//====================================================================

#define  DSMF_DSMF_CVC02_03_F1_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_CVC02_03_F1_RESERVED1_SHIFT 27
#define  DSMF_DSMF_CVC02_03_F1_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC02_03_F1_RESERVED1_MASK) >> DSMF_DSMF_CVC02_03_F1_RESERVED1_SHIFT)
#define  DSMF_DSMF_CVC02_03_F1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC02_03_F1_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC02_03_F1_RESERVED1_SHIFT))

#define  DSMF_DSMF_CVC02_03_F1_B_MASK 0x7ff0000
#define  DSMF_DSMF_CVC02_03_F1_B_SHIFT 16
#define  DSMF_DSMF_CVC02_03_F1_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC02_03_F1_B_MASK) >> DSMF_DSMF_CVC02_03_F1_B_SHIFT)
#define  DSMF_DSMF_CVC02_03_F1_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC02_03_F1_B_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC02_03_F1_B_SHIFT))

#define  DSMF_DSMF_CVC02_03_F1_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_CVC02_03_F1_RESERVED2_SHIFT 11
#define  DSMF_DSMF_CVC02_03_F1_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC02_03_F1_RESERVED2_MASK) >> DSMF_DSMF_CVC02_03_F1_RESERVED2_SHIFT)
#define  DSMF_DSMF_CVC02_03_F1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC02_03_F1_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC02_03_F1_RESERVED2_SHIFT))

#define  DSMF_DSMF_CVC02_03_F1_A_MASK 0x7ff
#define  DSMF_DSMF_CVC02_03_F1_A_SHIFT 0
#define  DSMF_DSMF_CVC02_03_F1_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC02_03_F1_A_MASK) >> DSMF_DSMF_CVC02_03_F1_A_SHIFT)
#define  DSMF_DSMF_CVC02_03_F1_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC02_03_F1_A_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC02_03_F1_A_SHIFT))

//====================================================================
//Register: DSMF Chroma Variable Coefficient04_10, Filter 1 (DSMF_CVC04_10_F1)
//====================================================================

#define  DSMF_DSMF_CVC04_10_F1_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_CVC04_10_F1_RESERVED1_SHIFT 27
#define  DSMF_DSMF_CVC04_10_F1_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC04_10_F1_RESERVED1_MASK) >> DSMF_DSMF_CVC04_10_F1_RESERVED1_SHIFT)
#define  DSMF_DSMF_CVC04_10_F1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC04_10_F1_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC04_10_F1_RESERVED1_SHIFT))

#define  DSMF_DSMF_CVC04_10_F1_B_MASK 0x7ff0000
#define  DSMF_DSMF_CVC04_10_F1_B_SHIFT 16
#define  DSMF_DSMF_CVC04_10_F1_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC04_10_F1_B_MASK) >> DSMF_DSMF_CVC04_10_F1_B_SHIFT)
#define  DSMF_DSMF_CVC04_10_F1_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC04_10_F1_B_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC04_10_F1_B_SHIFT))

#define  DSMF_DSMF_CVC04_10_F1_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_CVC04_10_F1_RESERVED2_SHIFT 11
#define  DSMF_DSMF_CVC04_10_F1_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC04_10_F1_RESERVED2_MASK) >> DSMF_DSMF_CVC04_10_F1_RESERVED2_SHIFT)
#define  DSMF_DSMF_CVC04_10_F1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC04_10_F1_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC04_10_F1_RESERVED2_SHIFT))

#define  DSMF_DSMF_CVC04_10_F1_A_MASK 0x7ff
#define  DSMF_DSMF_CVC04_10_F1_A_SHIFT 0
#define  DSMF_DSMF_CVC04_10_F1_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC04_10_F1_A_MASK) >> DSMF_DSMF_CVC04_10_F1_A_SHIFT)
#define  DSMF_DSMF_CVC04_10_F1_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC04_10_F1_A_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC04_10_F1_A_SHIFT))

//====================================================================
//Register: DSMF Chroma Variable Coefficient11_12, Filter 1 (DSMF_CVC11_12_F1)
//====================================================================

#define  DSMF_DSMF_CVC11_12_F1_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_CVC11_12_F1_RESERVED1_SHIFT 27
#define  DSMF_DSMF_CVC11_12_F1_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC11_12_F1_RESERVED1_MASK) >> DSMF_DSMF_CVC11_12_F1_RESERVED1_SHIFT)
#define  DSMF_DSMF_CVC11_12_F1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC11_12_F1_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC11_12_F1_RESERVED1_SHIFT))

#define  DSMF_DSMF_CVC11_12_F1_B_MASK 0x7ff0000
#define  DSMF_DSMF_CVC11_12_F1_B_SHIFT 16
#define  DSMF_DSMF_CVC11_12_F1_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC11_12_F1_B_MASK) >> DSMF_DSMF_CVC11_12_F1_B_SHIFT)
#define  DSMF_DSMF_CVC11_12_F1_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC11_12_F1_B_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC11_12_F1_B_SHIFT))

#define  DSMF_DSMF_CVC11_12_F1_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_CVC11_12_F1_RESERVED2_SHIFT 11
#define  DSMF_DSMF_CVC11_12_F1_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC11_12_F1_RESERVED2_MASK) >> DSMF_DSMF_CVC11_12_F1_RESERVED2_SHIFT)
#define  DSMF_DSMF_CVC11_12_F1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC11_12_F1_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC11_12_F1_RESERVED2_SHIFT))

#define  DSMF_DSMF_CVC11_12_F1_A_MASK 0x7ff
#define  DSMF_DSMF_CVC11_12_F1_A_SHIFT 0
#define  DSMF_DSMF_CVC11_12_F1_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC11_12_F1_A_MASK) >> DSMF_DSMF_CVC11_12_F1_A_SHIFT)
#define  DSMF_DSMF_CVC11_12_F1_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC11_12_F1_A_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC11_12_F1_A_SHIFT))

//====================================================================
//Register: DSMF Chroma Variable Coefficient13_14, Filter 1 (DSMF_CVC13_14_F1)
//====================================================================

#define  DSMF_DSMF_CVC13_14_F1_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_CVC13_14_F1_RESERVED1_SHIFT 27
#define  DSMF_DSMF_CVC13_14_F1_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC13_14_F1_RESERVED1_MASK) >> DSMF_DSMF_CVC13_14_F1_RESERVED1_SHIFT)
#define  DSMF_DSMF_CVC13_14_F1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC13_14_F1_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC13_14_F1_RESERVED1_SHIFT))

#define  DSMF_DSMF_CVC13_14_F1_B_MASK 0x7ff0000
#define  DSMF_DSMF_CVC13_14_F1_B_SHIFT 16
#define  DSMF_DSMF_CVC13_14_F1_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC13_14_F1_B_MASK) >> DSMF_DSMF_CVC13_14_F1_B_SHIFT)
#define  DSMF_DSMF_CVC13_14_F1_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC13_14_F1_B_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC13_14_F1_B_SHIFT))

#define  DSMF_DSMF_CVC13_14_F1_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_CVC13_14_F1_RESERVED2_SHIFT 11
#define  DSMF_DSMF_CVC13_14_F1_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC13_14_F1_RESERVED2_MASK) >> DSMF_DSMF_CVC13_14_F1_RESERVED2_SHIFT)
#define  DSMF_DSMF_CVC13_14_F1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC13_14_F1_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC13_14_F1_RESERVED2_SHIFT))

#define  DSMF_DSMF_CVC13_14_F1_A_MASK 0x7ff
#define  DSMF_DSMF_CVC13_14_F1_A_SHIFT 0
#define  DSMF_DSMF_CVC13_14_F1_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC13_14_F1_A_MASK) >> DSMF_DSMF_CVC13_14_F1_A_SHIFT)
#define  DSMF_DSMF_CVC13_14_F1_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC13_14_F1_A_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC13_14_F1_A_SHIFT))

//====================================================================
//Register: DSMF Chroma Variable Coefficient20_21, Filter 1 (DSMF_CVC20_21_F1)
//====================================================================

#define  DSMF_DSMF_CVC20_21_F1_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_CVC20_21_F1_RESERVED1_SHIFT 27
#define  DSMF_DSMF_CVC20_21_F1_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC20_21_F1_RESERVED1_MASK) >> DSMF_DSMF_CVC20_21_F1_RESERVED1_SHIFT)
#define  DSMF_DSMF_CVC20_21_F1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC20_21_F1_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC20_21_F1_RESERVED1_SHIFT))

#define  DSMF_DSMF_CVC20_21_F1_B_MASK 0x7ff0000
#define  DSMF_DSMF_CVC20_21_F1_B_SHIFT 16
#define  DSMF_DSMF_CVC20_21_F1_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC20_21_F1_B_MASK) >> DSMF_DSMF_CVC20_21_F1_B_SHIFT)
#define  DSMF_DSMF_CVC20_21_F1_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC20_21_F1_B_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC20_21_F1_B_SHIFT))

#define  DSMF_DSMF_CVC20_21_F1_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_CVC20_21_F1_RESERVED2_SHIFT 11
#define  DSMF_DSMF_CVC20_21_F1_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC20_21_F1_RESERVED2_MASK) >> DSMF_DSMF_CVC20_21_F1_RESERVED2_SHIFT)
#define  DSMF_DSMF_CVC20_21_F1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC20_21_F1_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC20_21_F1_RESERVED2_SHIFT))

#define  DSMF_DSMF_CVC20_21_F1_A_MASK 0x7ff
#define  DSMF_DSMF_CVC20_21_F1_A_SHIFT 0
#define  DSMF_DSMF_CVC20_21_F1_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC20_21_F1_A_MASK) >> DSMF_DSMF_CVC20_21_F1_A_SHIFT)
#define  DSMF_DSMF_CVC20_21_F1_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC20_21_F1_A_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC20_21_F1_A_SHIFT))

//====================================================================
//Register: DSMF Chroma Variable Coefficient22_23, Filter 1 (DSMF_CVC22_23_F1)
//====================================================================

#define  DSMF_DSMF_CVC22_23_F1_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_CVC22_23_F1_RESERVED1_SHIFT 27
#define  DSMF_DSMF_CVC22_23_F1_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC22_23_F1_RESERVED1_MASK) >> DSMF_DSMF_CVC22_23_F1_RESERVED1_SHIFT)
#define  DSMF_DSMF_CVC22_23_F1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC22_23_F1_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC22_23_F1_RESERVED1_SHIFT))

#define  DSMF_DSMF_CVC22_23_F1_B_MASK 0x7ff0000
#define  DSMF_DSMF_CVC22_23_F1_B_SHIFT 16
#define  DSMF_DSMF_CVC22_23_F1_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC22_23_F1_B_MASK) >> DSMF_DSMF_CVC22_23_F1_B_SHIFT)
#define  DSMF_DSMF_CVC22_23_F1_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC22_23_F1_B_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC22_23_F1_B_SHIFT))

#define  DSMF_DSMF_CVC22_23_F1_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_CVC22_23_F1_RESERVED2_SHIFT 11
#define  DSMF_DSMF_CVC22_23_F1_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC22_23_F1_RESERVED2_MASK) >> DSMF_DSMF_CVC22_23_F1_RESERVED2_SHIFT)
#define  DSMF_DSMF_CVC22_23_F1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC22_23_F1_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC22_23_F1_RESERVED2_SHIFT))

#define  DSMF_DSMF_CVC22_23_F1_A_MASK 0x7ff
#define  DSMF_DSMF_CVC22_23_F1_A_SHIFT 0
#define  DSMF_DSMF_CVC22_23_F1_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC22_23_F1_A_MASK) >> DSMF_DSMF_CVC22_23_F1_A_SHIFT)
#define  DSMF_DSMF_CVC22_23_F1_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC22_23_F1_A_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC22_23_F1_A_SHIFT))

//====================================================================
//Register: DSMF Chroma Variable Coefficient24, Filter 1 (DSMF_CVC24_F1)
//====================================================================

#define  DSMF_DSMF_CVC24_F1_RESERVED1_MASK 0xfffff800
#define  DSMF_DSMF_CVC24_F1_RESERVED1_SHIFT 11
#define  DSMF_DSMF_CVC24_F1_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC24_F1_RESERVED1_MASK) >> DSMF_DSMF_CVC24_F1_RESERVED1_SHIFT)
#define  DSMF_DSMF_CVC24_F1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC24_F1_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC24_F1_RESERVED1_SHIFT))

#define  DSMF_DSMF_CVC24_F1_A_MASK 0x7ff
#define  DSMF_DSMF_CVC24_F1_A_SHIFT 0
#define  DSMF_DSMF_CVC24_F1_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC24_F1_A_MASK) >> DSMF_DSMF_CVC24_F1_A_SHIFT)
#define  DSMF_DSMF_CVC24_F1_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC24_F1_A_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC24_F1_A_SHIFT))

//====================================================================
//Register: DSMF Chroma Variable Coefficient30_31, Filter 1 (DSMF_CVC30_31_F1)
//====================================================================

#define  DSMF_DSMF_CVC30_31_F1_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_CVC30_31_F1_RESERVED1_SHIFT 27
#define  DSMF_DSMF_CVC30_31_F1_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC30_31_F1_RESERVED1_MASK) >> DSMF_DSMF_CVC30_31_F1_RESERVED1_SHIFT)
#define  DSMF_DSMF_CVC30_31_F1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC30_31_F1_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC30_31_F1_RESERVED1_SHIFT))

#define  DSMF_DSMF_CVC30_31_F1_B_MASK 0x7ff0000
#define  DSMF_DSMF_CVC30_31_F1_B_SHIFT 16
#define  DSMF_DSMF_CVC30_31_F1_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC30_31_F1_B_MASK) >> DSMF_DSMF_CVC30_31_F1_B_SHIFT)
#define  DSMF_DSMF_CVC30_31_F1_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC30_31_F1_B_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC30_31_F1_B_SHIFT))

#define  DSMF_DSMF_CVC30_31_F1_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_CVC30_31_F1_RESERVED2_SHIFT 11
#define  DSMF_DSMF_CVC30_31_F1_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC30_31_F1_RESERVED2_MASK) >> DSMF_DSMF_CVC30_31_F1_RESERVED2_SHIFT)
#define  DSMF_DSMF_CVC30_31_F1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC30_31_F1_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC30_31_F1_RESERVED2_SHIFT))

#define  DSMF_DSMF_CVC30_31_F1_A_MASK 0x7ff
#define  DSMF_DSMF_CVC30_31_F1_A_SHIFT 0
#define  DSMF_DSMF_CVC30_31_F1_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC30_31_F1_A_MASK) >> DSMF_DSMF_CVC30_31_F1_A_SHIFT)
#define  DSMF_DSMF_CVC30_31_F1_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC30_31_F1_A_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC30_31_F1_A_SHIFT))

//====================================================================
//Register: DSMF Chroma Variable Coefficient32_33, Filter 1 (DSMF_CVC32_33_F1)
//====================================================================

#define  DSMF_DSMF_CVC32_33_F1_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_CVC32_33_F1_RESERVED1_SHIFT 27
#define  DSMF_DSMF_CVC32_33_F1_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC32_33_F1_RESERVED1_MASK) >> DSMF_DSMF_CVC32_33_F1_RESERVED1_SHIFT)
#define  DSMF_DSMF_CVC32_33_F1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC32_33_F1_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC32_33_F1_RESERVED1_SHIFT))

#define  DSMF_DSMF_CVC32_33_F1_B_MASK 0x7ff0000
#define  DSMF_DSMF_CVC32_33_F1_B_SHIFT 16
#define  DSMF_DSMF_CVC32_33_F1_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC32_33_F1_B_MASK) >> DSMF_DSMF_CVC32_33_F1_B_SHIFT)
#define  DSMF_DSMF_CVC32_33_F1_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC32_33_F1_B_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC32_33_F1_B_SHIFT))

#define  DSMF_DSMF_CVC32_33_F1_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_CVC32_33_F1_RESERVED2_SHIFT 11
#define  DSMF_DSMF_CVC32_33_F1_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC32_33_F1_RESERVED2_MASK) >> DSMF_DSMF_CVC32_33_F1_RESERVED2_SHIFT)
#define  DSMF_DSMF_CVC32_33_F1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC32_33_F1_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC32_33_F1_RESERVED2_SHIFT))

#define  DSMF_DSMF_CVC32_33_F1_A_MASK 0x7ff
#define  DSMF_DSMF_CVC32_33_F1_A_SHIFT 0
#define  DSMF_DSMF_CVC32_33_F1_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC32_33_F1_A_MASK) >> DSMF_DSMF_CVC32_33_F1_A_SHIFT)
#define  DSMF_DSMF_CVC32_33_F1_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC32_33_F1_A_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC32_33_F1_A_SHIFT))

//====================================================================
//Register: DSMF Chroma Variable Coefficient34_40, Filter 1 (DSMF_CVC34_40_F1)
//====================================================================

#define  DSMF_DSMF_CVC34_40_F1_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_CVC34_40_F1_RESERVED1_SHIFT 27
#define  DSMF_DSMF_CVC34_40_F1_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC34_40_F1_RESERVED1_MASK) >> DSMF_DSMF_CVC34_40_F1_RESERVED1_SHIFT)
#define  DSMF_DSMF_CVC34_40_F1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC34_40_F1_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC34_40_F1_RESERVED1_SHIFT))

#define  DSMF_DSMF_CVC34_40_F1_B_MASK 0x7ff0000
#define  DSMF_DSMF_CVC34_40_F1_B_SHIFT 16
#define  DSMF_DSMF_CVC34_40_F1_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC34_40_F1_B_MASK) >> DSMF_DSMF_CVC34_40_F1_B_SHIFT)
#define  DSMF_DSMF_CVC34_40_F1_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC34_40_F1_B_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC34_40_F1_B_SHIFT))

#define  DSMF_DSMF_CVC34_40_F1_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_CVC34_40_F1_RESERVED2_SHIFT 11
#define  DSMF_DSMF_CVC34_40_F1_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC34_40_F1_RESERVED2_MASK) >> DSMF_DSMF_CVC34_40_F1_RESERVED2_SHIFT)
#define  DSMF_DSMF_CVC34_40_F1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC34_40_F1_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC34_40_F1_RESERVED2_SHIFT))

#define  DSMF_DSMF_CVC34_40_F1_A_MASK 0x7ff
#define  DSMF_DSMF_CVC34_40_F1_A_SHIFT 0
#define  DSMF_DSMF_CVC34_40_F1_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC34_40_F1_A_MASK) >> DSMF_DSMF_CVC34_40_F1_A_SHIFT)
#define  DSMF_DSMF_CVC34_40_F1_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC34_40_F1_A_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC34_40_F1_A_SHIFT))

//====================================================================
//Register: DSMF Chroma Variable Coefficient41_42, Filter 1 (DSMF_CVC41_42_F1)
//====================================================================

#define  DSMF_DSMF_CVC41_42_F1_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_CVC41_42_F1_RESERVED1_SHIFT 27
#define  DSMF_DSMF_CVC41_42_F1_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC41_42_F1_RESERVED1_MASK) >> DSMF_DSMF_CVC41_42_F1_RESERVED1_SHIFT)
#define  DSMF_DSMF_CVC41_42_F1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC41_42_F1_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC41_42_F1_RESERVED1_SHIFT))

#define  DSMF_DSMF_CVC41_42_F1_B_MASK 0x7ff0000
#define  DSMF_DSMF_CVC41_42_F1_B_SHIFT 16
#define  DSMF_DSMF_CVC41_42_F1_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC41_42_F1_B_MASK) >> DSMF_DSMF_CVC41_42_F1_B_SHIFT)
#define  DSMF_DSMF_CVC41_42_F1_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC41_42_F1_B_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC41_42_F1_B_SHIFT))

#define  DSMF_DSMF_CVC41_42_F1_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_CVC41_42_F1_RESERVED2_SHIFT 11
#define  DSMF_DSMF_CVC41_42_F1_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC41_42_F1_RESERVED2_MASK) >> DSMF_DSMF_CVC41_42_F1_RESERVED2_SHIFT)
#define  DSMF_DSMF_CVC41_42_F1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC41_42_F1_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC41_42_F1_RESERVED2_SHIFT))

#define  DSMF_DSMF_CVC41_42_F1_A_MASK 0x7ff
#define  DSMF_DSMF_CVC41_42_F1_A_SHIFT 0
#define  DSMF_DSMF_CVC41_42_F1_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC41_42_F1_A_MASK) >> DSMF_DSMF_CVC41_42_F1_A_SHIFT)
#define  DSMF_DSMF_CVC41_42_F1_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC41_42_F1_A_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC41_42_F1_A_SHIFT))

//====================================================================
//Register: DSMF Chroma Variable Coefficient43_44, Filter 1 (DSMF_CVC43_44_F1)
//====================================================================

#define  DSMF_DSMF_CVC43_44_F1_RESERVED1_MASK 0xe0000000
#define  DSMF_DSMF_CVC43_44_F1_RESERVED1_SHIFT 29
#define  DSMF_DSMF_CVC43_44_F1_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC43_44_F1_RESERVED1_MASK) >> DSMF_DSMF_CVC43_44_F1_RESERVED1_SHIFT)
#define  DSMF_DSMF_CVC43_44_F1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC43_44_F1_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC43_44_F1_RESERVED1_SHIFT))

#define  DSMF_DSMF_CVC43_44_F1_B_MASK 0x1fff0000
#define  DSMF_DSMF_CVC43_44_F1_B_SHIFT 16
#define  DSMF_DSMF_CVC43_44_F1_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC43_44_F1_B_MASK) >> DSMF_DSMF_CVC43_44_F1_B_SHIFT)
#define  DSMF_DSMF_CVC43_44_F1_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC43_44_F1_B_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC43_44_F1_B_SHIFT))

#define  DSMF_DSMF_CVC43_44_F1_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_CVC43_44_F1_RESERVED2_SHIFT 11
#define  DSMF_DSMF_CVC43_44_F1_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC43_44_F1_RESERVED2_MASK) >> DSMF_DSMF_CVC43_44_F1_RESERVED2_SHIFT)
#define  DSMF_DSMF_CVC43_44_F1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC43_44_F1_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC43_44_F1_RESERVED2_SHIFT))

#define  DSMF_DSMF_CVC43_44_F1_A_MASK 0x7ff
#define  DSMF_DSMF_CVC43_44_F1_A_SHIFT 0
#define  DSMF_DSMF_CVC43_44_F1_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC43_44_F1_A_MASK) >> DSMF_DSMF_CVC43_44_F1_A_SHIFT)
#define  DSMF_DSMF_CVC43_44_F1_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC43_44_F1_A_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC43_44_F1_A_SHIFT))

//====================================================================
//Register: DSMF Filter Sum Multiplier, Filter 1 (DSMF_FILT_MULT_F1)
//====================================================================

#define  DSMF_DSMF_FILT_MULT_F1_Y_MULT_MASK 0xffff0000
#define  DSMF_DSMF_FILT_MULT_F1_Y_MULT_SHIFT 16
#define  DSMF_DSMF_FILT_MULT_F1_Y_MULT_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_FILT_MULT_F1_Y_MULT_MASK) >> DSMF_DSMF_FILT_MULT_F1_Y_MULT_SHIFT)
#define  DSMF_DSMF_FILT_MULT_F1_Y_MULT_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_FILT_MULT_F1_Y_MULT_MASK) | (((uint32_t)val) << DSMF_DSMF_FILT_MULT_F1_Y_MULT_SHIFT))

#define  DSMF_DSMF_FILT_MULT_F1_C_MULT_MASK 0xffff
#define  DSMF_DSMF_FILT_MULT_F1_C_MULT_SHIFT 0
#define  DSMF_DSMF_FILT_MULT_F1_C_MULT_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_FILT_MULT_F1_C_MULT_MASK) >> DSMF_DSMF_FILT_MULT_F1_C_MULT_SHIFT)
#define  DSMF_DSMF_FILT_MULT_F1_C_MULT_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_FILT_MULT_F1_C_MULT_MASK) | (((uint32_t)val) << DSMF_DSMF_FILT_MULT_F1_C_MULT_SHIFT))

//====================================================================
//Register: DSMF Filter Sum Shift Factor, Filter 1 (DSMF_FILT_SHIFT_F1)
//====================================================================

#define  DSMF_DSMF_FILT_SHIFT_F1_RESERVED1_MASK 0xfffffc00
#define  DSMF_DSMF_FILT_SHIFT_F1_RESERVED1_SHIFT 10
#define  DSMF_DSMF_FILT_SHIFT_F1_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_FILT_SHIFT_F1_RESERVED1_MASK) >> DSMF_DSMF_FILT_SHIFT_F1_RESERVED1_SHIFT)
#define  DSMF_DSMF_FILT_SHIFT_F1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_FILT_SHIFT_F1_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_FILT_SHIFT_F1_RESERVED1_SHIFT))

#define  DSMF_DSMF_FILT_SHIFT_F1_Y_SHIFT_MASK 0x3e0
#define  DSMF_DSMF_FILT_SHIFT_F1_Y_SHIFT_SHIFT 5
#define  DSMF_DSMF_FILT_SHIFT_F1_Y_SHIFT_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_FILT_SHIFT_F1_Y_SHIFT_MASK) >> DSMF_DSMF_FILT_SHIFT_F1_Y_SHIFT_SHIFT)
#define  DSMF_DSMF_FILT_SHIFT_F1_Y_SHIFT_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_FILT_SHIFT_F1_Y_SHIFT_MASK) | (((uint32_t)val) << DSMF_DSMF_FILT_SHIFT_F1_Y_SHIFT_SHIFT))

#define  DSMF_DSMF_FILT_SHIFT_F1_C_SHIFT_MASK 0x1f
#define  DSMF_DSMF_FILT_SHIFT_F1_C_SHIFT_SHIFT 0
#define  DSMF_DSMF_FILT_SHIFT_F1_C_SHIFT_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_FILT_SHIFT_F1_C_SHIFT_MASK) >> DSMF_DSMF_FILT_SHIFT_F1_C_SHIFT_SHIFT)
#define  DSMF_DSMF_FILT_SHIFT_F1_C_SHIFT_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_FILT_SHIFT_F1_C_SHIFT_MASK) | (((uint32_t)val) << DSMF_DSMF_FILT_SHIFT_F1_C_SHIFT_SHIFT))

//====================================================================
//Register: DSMF Y Variable Coefficient00_01, Filter 2 (DSMF_YVC00_01_F2)
/** \brief The following 5x5 filter coefficients (for Y and C) correspond to filt_coeff_sel = 2.*/
//====================================================================

#define  DSMF_DSMF_YVC00_01_F2_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_YVC00_01_F2_RESERVED1_SHIFT 27
#define  DSMF_DSMF_YVC00_01_F2_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC00_01_F2_RESERVED1_MASK) >> DSMF_DSMF_YVC00_01_F2_RESERVED1_SHIFT)
#define  DSMF_DSMF_YVC00_01_F2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC00_01_F2_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC00_01_F2_RESERVED1_SHIFT))

#define  DSMF_DSMF_YVC00_01_F2_B_MASK 0x7ff0000
#define  DSMF_DSMF_YVC00_01_F2_B_SHIFT 16
#define  DSMF_DSMF_YVC00_01_F2_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC00_01_F2_B_MASK) >> DSMF_DSMF_YVC00_01_F2_B_SHIFT)
#define  DSMF_DSMF_YVC00_01_F2_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC00_01_F2_B_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC00_01_F2_B_SHIFT))

#define  DSMF_DSMF_YVC00_01_F2_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_YVC00_01_F2_RESERVED2_SHIFT 11
#define  DSMF_DSMF_YVC00_01_F2_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC00_01_F2_RESERVED2_MASK) >> DSMF_DSMF_YVC00_01_F2_RESERVED2_SHIFT)
#define  DSMF_DSMF_YVC00_01_F2_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC00_01_F2_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC00_01_F2_RESERVED2_SHIFT))

#define  DSMF_DSMF_YVC00_01_F2_A_MASK 0x7ff
#define  DSMF_DSMF_YVC00_01_F2_A_SHIFT 0
#define  DSMF_DSMF_YVC00_01_F2_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC00_01_F2_A_MASK) >> DSMF_DSMF_YVC00_01_F2_A_SHIFT)
#define  DSMF_DSMF_YVC00_01_F2_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC00_01_F2_A_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC00_01_F2_A_SHIFT))

//====================================================================
//Register: DSMF Y Variable Coefficient02_03, Filter 2 (DSMF_YVC02_03_F2)
//====================================================================

#define  DSMF_DSMF_YVC02_03_F2_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_YVC02_03_F2_RESERVED1_SHIFT 27
#define  DSMF_DSMF_YVC02_03_F2_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC02_03_F2_RESERVED1_MASK) >> DSMF_DSMF_YVC02_03_F2_RESERVED1_SHIFT)
#define  DSMF_DSMF_YVC02_03_F2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC02_03_F2_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC02_03_F2_RESERVED1_SHIFT))

#define  DSMF_DSMF_YVC02_03_F2_B_MASK 0x7ff0000
#define  DSMF_DSMF_YVC02_03_F2_B_SHIFT 16
#define  DSMF_DSMF_YVC02_03_F2_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC02_03_F2_B_MASK) >> DSMF_DSMF_YVC02_03_F2_B_SHIFT)
#define  DSMF_DSMF_YVC02_03_F2_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC02_03_F2_B_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC02_03_F2_B_SHIFT))

#define  DSMF_DSMF_YVC02_03_F2_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_YVC02_03_F2_RESERVED2_SHIFT 11
#define  DSMF_DSMF_YVC02_03_F2_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC02_03_F2_RESERVED2_MASK) >> DSMF_DSMF_YVC02_03_F2_RESERVED2_SHIFT)
#define  DSMF_DSMF_YVC02_03_F2_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC02_03_F2_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC02_03_F2_RESERVED2_SHIFT))

#define  DSMF_DSMF_YVC02_03_F2_A_MASK 0x7ff
#define  DSMF_DSMF_YVC02_03_F2_A_SHIFT 0
#define  DSMF_DSMF_YVC02_03_F2_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC02_03_F2_A_MASK) >> DSMF_DSMF_YVC02_03_F2_A_SHIFT)
#define  DSMF_DSMF_YVC02_03_F2_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC02_03_F2_A_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC02_03_F2_A_SHIFT))

//====================================================================
//Register: DSMF Y Variable Coefficient04_10, Filter 2 (DSMF_YVC04_10_F2)
//====================================================================

#define  DSMF_DSMF_YVC04_10_F2_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_YVC04_10_F2_RESERVED1_SHIFT 27
#define  DSMF_DSMF_YVC04_10_F2_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC04_10_F2_RESERVED1_MASK) >> DSMF_DSMF_YVC04_10_F2_RESERVED1_SHIFT)
#define  DSMF_DSMF_YVC04_10_F2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC04_10_F2_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC04_10_F2_RESERVED1_SHIFT))

#define  DSMF_DSMF_YVC04_10_F2_B_MASK 0x7ff0000
#define  DSMF_DSMF_YVC04_10_F2_B_SHIFT 16
#define  DSMF_DSMF_YVC04_10_F2_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC04_10_F2_B_MASK) >> DSMF_DSMF_YVC04_10_F2_B_SHIFT)
#define  DSMF_DSMF_YVC04_10_F2_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC04_10_F2_B_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC04_10_F2_B_SHIFT))

#define  DSMF_DSMF_YVC04_10_F2_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_YVC04_10_F2_RESERVED2_SHIFT 11
#define  DSMF_DSMF_YVC04_10_F2_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC04_10_F2_RESERVED2_MASK) >> DSMF_DSMF_YVC04_10_F2_RESERVED2_SHIFT)
#define  DSMF_DSMF_YVC04_10_F2_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC04_10_F2_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC04_10_F2_RESERVED2_SHIFT))

#define  DSMF_DSMF_YVC04_10_F2_A_MASK 0x7ff
#define  DSMF_DSMF_YVC04_10_F2_A_SHIFT 0
#define  DSMF_DSMF_YVC04_10_F2_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC04_10_F2_A_MASK) >> DSMF_DSMF_YVC04_10_F2_A_SHIFT)
#define  DSMF_DSMF_YVC04_10_F2_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC04_10_F2_A_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC04_10_F2_A_SHIFT))

//====================================================================
//Register: DSMF Y Variable Coefficient11_12, Filter 2 (DSMF_YVC11_12_F2)
//====================================================================

#define  DSMF_DSMF_YVC11_12_F2_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_YVC11_12_F2_RESERVED1_SHIFT 27
#define  DSMF_DSMF_YVC11_12_F2_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC11_12_F2_RESERVED1_MASK) >> DSMF_DSMF_YVC11_12_F2_RESERVED1_SHIFT)
#define  DSMF_DSMF_YVC11_12_F2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC11_12_F2_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC11_12_F2_RESERVED1_SHIFT))

#define  DSMF_DSMF_YVC11_12_F2_B_MASK 0x7ff0000
#define  DSMF_DSMF_YVC11_12_F2_B_SHIFT 16
#define  DSMF_DSMF_YVC11_12_F2_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC11_12_F2_B_MASK) >> DSMF_DSMF_YVC11_12_F2_B_SHIFT)
#define  DSMF_DSMF_YVC11_12_F2_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC11_12_F2_B_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC11_12_F2_B_SHIFT))

#define  DSMF_DSMF_YVC11_12_F2_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_YVC11_12_F2_RESERVED2_SHIFT 11
#define  DSMF_DSMF_YVC11_12_F2_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC11_12_F2_RESERVED2_MASK) >> DSMF_DSMF_YVC11_12_F2_RESERVED2_SHIFT)
#define  DSMF_DSMF_YVC11_12_F2_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC11_12_F2_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC11_12_F2_RESERVED2_SHIFT))

#define  DSMF_DSMF_YVC11_12_F2_A_MASK 0x7ff
#define  DSMF_DSMF_YVC11_12_F2_A_SHIFT 0
#define  DSMF_DSMF_YVC11_12_F2_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC11_12_F2_A_MASK) >> DSMF_DSMF_YVC11_12_F2_A_SHIFT)
#define  DSMF_DSMF_YVC11_12_F2_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC11_12_F2_A_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC11_12_F2_A_SHIFT))

//====================================================================
//Register: DSMF Y Variable Coefficient13_14, Filter 2 (DSMF_YVC13_14_F2)
//====================================================================

#define  DSMF_DSMF_YVC13_14_F2_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_YVC13_14_F2_RESERVED1_SHIFT 27
#define  DSMF_DSMF_YVC13_14_F2_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC13_14_F2_RESERVED1_MASK) >> DSMF_DSMF_YVC13_14_F2_RESERVED1_SHIFT)
#define  DSMF_DSMF_YVC13_14_F2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC13_14_F2_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC13_14_F2_RESERVED1_SHIFT))

#define  DSMF_DSMF_YVC13_14_F2_B_MASK 0x7ff0000
#define  DSMF_DSMF_YVC13_14_F2_B_SHIFT 16
#define  DSMF_DSMF_YVC13_14_F2_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC13_14_F2_B_MASK) >> DSMF_DSMF_YVC13_14_F2_B_SHIFT)
#define  DSMF_DSMF_YVC13_14_F2_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC13_14_F2_B_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC13_14_F2_B_SHIFT))

#define  DSMF_DSMF_YVC13_14_F2_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_YVC13_14_F2_RESERVED2_SHIFT 11
#define  DSMF_DSMF_YVC13_14_F2_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC13_14_F2_RESERVED2_MASK) >> DSMF_DSMF_YVC13_14_F2_RESERVED2_SHIFT)
#define  DSMF_DSMF_YVC13_14_F2_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC13_14_F2_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC13_14_F2_RESERVED2_SHIFT))

#define  DSMF_DSMF_YVC13_14_F2_A_MASK 0x7ff
#define  DSMF_DSMF_YVC13_14_F2_A_SHIFT 0
#define  DSMF_DSMF_YVC13_14_F2_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC13_14_F2_A_MASK) >> DSMF_DSMF_YVC13_14_F2_A_SHIFT)
#define  DSMF_DSMF_YVC13_14_F2_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC13_14_F2_A_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC13_14_F2_A_SHIFT))

//====================================================================
//Register: DSMF Y Variable Coefficient20_21, Filter 2 (DSMF_YVC20_21_F2)
//====================================================================

#define  DSMF_DSMF_YVC20_21_F2_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_YVC20_21_F2_RESERVED1_SHIFT 27
#define  DSMF_DSMF_YVC20_21_F2_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC20_21_F2_RESERVED1_MASK) >> DSMF_DSMF_YVC20_21_F2_RESERVED1_SHIFT)
#define  DSMF_DSMF_YVC20_21_F2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC20_21_F2_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC20_21_F2_RESERVED1_SHIFT))

#define  DSMF_DSMF_YVC20_21_F2_B_MASK 0x7ff0000
#define  DSMF_DSMF_YVC20_21_F2_B_SHIFT 16
#define  DSMF_DSMF_YVC20_21_F2_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC20_21_F2_B_MASK) >> DSMF_DSMF_YVC20_21_F2_B_SHIFT)
#define  DSMF_DSMF_YVC20_21_F2_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC20_21_F2_B_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC20_21_F2_B_SHIFT))

#define  DSMF_DSMF_YVC20_21_F2_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_YVC20_21_F2_RESERVED2_SHIFT 11
#define  DSMF_DSMF_YVC20_21_F2_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC20_21_F2_RESERVED2_MASK) >> DSMF_DSMF_YVC20_21_F2_RESERVED2_SHIFT)
#define  DSMF_DSMF_YVC20_21_F2_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC20_21_F2_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC20_21_F2_RESERVED2_SHIFT))

#define  DSMF_DSMF_YVC20_21_F2_A_MASK 0x7ff
#define  DSMF_DSMF_YVC20_21_F2_A_SHIFT 0
#define  DSMF_DSMF_YVC20_21_F2_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC20_21_F2_A_MASK) >> DSMF_DSMF_YVC20_21_F2_A_SHIFT)
#define  DSMF_DSMF_YVC20_21_F2_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC20_21_F2_A_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC20_21_F2_A_SHIFT))

//====================================================================
//Register: DSMF Y Variable Coefficient22_23, Filter 2 (DSMF_YVC22_23_F2)
//====================================================================

#define  DSMF_DSMF_YVC22_23_F2_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_YVC22_23_F2_RESERVED1_SHIFT 27
#define  DSMF_DSMF_YVC22_23_F2_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC22_23_F2_RESERVED1_MASK) >> DSMF_DSMF_YVC22_23_F2_RESERVED1_SHIFT)
#define  DSMF_DSMF_YVC22_23_F2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC22_23_F2_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC22_23_F2_RESERVED1_SHIFT))

#define  DSMF_DSMF_YVC22_23_F2_B_MASK 0x7ff0000
#define  DSMF_DSMF_YVC22_23_F2_B_SHIFT 16
#define  DSMF_DSMF_YVC22_23_F2_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC22_23_F2_B_MASK) >> DSMF_DSMF_YVC22_23_F2_B_SHIFT)
#define  DSMF_DSMF_YVC22_23_F2_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC22_23_F2_B_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC22_23_F2_B_SHIFT))

#define  DSMF_DSMF_YVC22_23_F2_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_YVC22_23_F2_RESERVED2_SHIFT 11
#define  DSMF_DSMF_YVC22_23_F2_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC22_23_F2_RESERVED2_MASK) >> DSMF_DSMF_YVC22_23_F2_RESERVED2_SHIFT)
#define  DSMF_DSMF_YVC22_23_F2_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC22_23_F2_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC22_23_F2_RESERVED2_SHIFT))

#define  DSMF_DSMF_YVC22_23_F2_A_MASK 0x7ff
#define  DSMF_DSMF_YVC22_23_F2_A_SHIFT 0
#define  DSMF_DSMF_YVC22_23_F2_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC22_23_F2_A_MASK) >> DSMF_DSMF_YVC22_23_F2_A_SHIFT)
#define  DSMF_DSMF_YVC22_23_F2_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC22_23_F2_A_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC22_23_F2_A_SHIFT))

//====================================================================
//Register: DSMF Y Variable Coefficient24, Filter 2 (DSMF_YVC24_F2)
//====================================================================

#define  DSMF_DSMF_YVC24_F2_RESERVED1_MASK 0xfffff800
#define  DSMF_DSMF_YVC24_F2_RESERVED1_SHIFT 11
#define  DSMF_DSMF_YVC24_F2_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC24_F2_RESERVED1_MASK) >> DSMF_DSMF_YVC24_F2_RESERVED1_SHIFT)
#define  DSMF_DSMF_YVC24_F2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC24_F2_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC24_F2_RESERVED1_SHIFT))

#define  DSMF_DSMF_YVC24_F2_A_MASK 0x7ff
#define  DSMF_DSMF_YVC24_F2_A_SHIFT 0
#define  DSMF_DSMF_YVC24_F2_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC24_F2_A_MASK) >> DSMF_DSMF_YVC24_F2_A_SHIFT)
#define  DSMF_DSMF_YVC24_F2_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC24_F2_A_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC24_F2_A_SHIFT))

//====================================================================
//Register: DSMF Y Variable Coefficient30_31, Filter 2 (DSMF_YVC30_31_F2)
//====================================================================

#define  DSMF_DSMF_YVC30_31_F2_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_YVC30_31_F2_RESERVED1_SHIFT 27
#define  DSMF_DSMF_YVC30_31_F2_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC30_31_F2_RESERVED1_MASK) >> DSMF_DSMF_YVC30_31_F2_RESERVED1_SHIFT)
#define  DSMF_DSMF_YVC30_31_F2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC30_31_F2_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC30_31_F2_RESERVED1_SHIFT))

#define  DSMF_DSMF_YVC30_31_F2_B_MASK 0x7ff0000
#define  DSMF_DSMF_YVC30_31_F2_B_SHIFT 16
#define  DSMF_DSMF_YVC30_31_F2_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC30_31_F2_B_MASK) >> DSMF_DSMF_YVC30_31_F2_B_SHIFT)
#define  DSMF_DSMF_YVC30_31_F2_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC30_31_F2_B_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC30_31_F2_B_SHIFT))

#define  DSMF_DSMF_YVC30_31_F2_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_YVC30_31_F2_RESERVED2_SHIFT 11
#define  DSMF_DSMF_YVC30_31_F2_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC30_31_F2_RESERVED2_MASK) >> DSMF_DSMF_YVC30_31_F2_RESERVED2_SHIFT)
#define  DSMF_DSMF_YVC30_31_F2_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC30_31_F2_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC30_31_F2_RESERVED2_SHIFT))

#define  DSMF_DSMF_YVC30_31_F2_A_MASK 0x7ff
#define  DSMF_DSMF_YVC30_31_F2_A_SHIFT 0
#define  DSMF_DSMF_YVC30_31_F2_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC30_31_F2_A_MASK) >> DSMF_DSMF_YVC30_31_F2_A_SHIFT)
#define  DSMF_DSMF_YVC30_31_F2_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC30_31_F2_A_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC30_31_F2_A_SHIFT))

//====================================================================
//Register: DSMF Y Variable Coefficient32_33, Filter 2 (DSMF_YVC32_33_F2)
//====================================================================

#define  DSMF_DSMF_YVC32_33_F2_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_YVC32_33_F2_RESERVED1_SHIFT 27
#define  DSMF_DSMF_YVC32_33_F2_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC32_33_F2_RESERVED1_MASK) >> DSMF_DSMF_YVC32_33_F2_RESERVED1_SHIFT)
#define  DSMF_DSMF_YVC32_33_F2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC32_33_F2_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC32_33_F2_RESERVED1_SHIFT))

#define  DSMF_DSMF_YVC32_33_F2_B_MASK 0x7ff0000
#define  DSMF_DSMF_YVC32_33_F2_B_SHIFT 16
#define  DSMF_DSMF_YVC32_33_F2_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC32_33_F2_B_MASK) >> DSMF_DSMF_YVC32_33_F2_B_SHIFT)
#define  DSMF_DSMF_YVC32_33_F2_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC32_33_F2_B_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC32_33_F2_B_SHIFT))

#define  DSMF_DSMF_YVC32_33_F2_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_YVC32_33_F2_RESERVED2_SHIFT 11
#define  DSMF_DSMF_YVC32_33_F2_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC32_33_F2_RESERVED2_MASK) >> DSMF_DSMF_YVC32_33_F2_RESERVED2_SHIFT)
#define  DSMF_DSMF_YVC32_33_F2_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC32_33_F2_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC32_33_F2_RESERVED2_SHIFT))

#define  DSMF_DSMF_YVC32_33_F2_A_MASK 0x7ff
#define  DSMF_DSMF_YVC32_33_F2_A_SHIFT 0
#define  DSMF_DSMF_YVC32_33_F2_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC32_33_F2_A_MASK) >> DSMF_DSMF_YVC32_33_F2_A_SHIFT)
#define  DSMF_DSMF_YVC32_33_F2_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC32_33_F2_A_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC32_33_F2_A_SHIFT))

//====================================================================
//Register: DSMF Y Variable Coefficient34_40, Filter 2 (DSMF_YVC34_40_F2)
//====================================================================

#define  DSMF_DSMF_YVC34_40_F2_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_YVC34_40_F2_RESERVED1_SHIFT 27
#define  DSMF_DSMF_YVC34_40_F2_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC34_40_F2_RESERVED1_MASK) >> DSMF_DSMF_YVC34_40_F2_RESERVED1_SHIFT)
#define  DSMF_DSMF_YVC34_40_F2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC34_40_F2_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC34_40_F2_RESERVED1_SHIFT))

#define  DSMF_DSMF_YVC34_40_F2_B_MASK 0x7ff0000
#define  DSMF_DSMF_YVC34_40_F2_B_SHIFT 16
#define  DSMF_DSMF_YVC34_40_F2_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC34_40_F2_B_MASK) >> DSMF_DSMF_YVC34_40_F2_B_SHIFT)
#define  DSMF_DSMF_YVC34_40_F2_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC34_40_F2_B_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC34_40_F2_B_SHIFT))

#define  DSMF_DSMF_YVC34_40_F2_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_YVC34_40_F2_RESERVED2_SHIFT 11
#define  DSMF_DSMF_YVC34_40_F2_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC34_40_F2_RESERVED2_MASK) >> DSMF_DSMF_YVC34_40_F2_RESERVED2_SHIFT)
#define  DSMF_DSMF_YVC34_40_F2_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC34_40_F2_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC34_40_F2_RESERVED2_SHIFT))

#define  DSMF_DSMF_YVC34_40_F2_A_MASK 0x7ff
#define  DSMF_DSMF_YVC34_40_F2_A_SHIFT 0
#define  DSMF_DSMF_YVC34_40_F2_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC34_40_F2_A_MASK) >> DSMF_DSMF_YVC34_40_F2_A_SHIFT)
#define  DSMF_DSMF_YVC34_40_F2_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC34_40_F2_A_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC34_40_F2_A_SHIFT))

//====================================================================
//Register: DSMF Y Variable Coefficient41_42, Filter 2 (DSMF_YVC41_42_F2)
//====================================================================

#define  DSMF_DSMF_YVC41_42_F2_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_YVC41_42_F2_RESERVED1_SHIFT 27
#define  DSMF_DSMF_YVC41_42_F2_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC41_42_F2_RESERVED1_MASK) >> DSMF_DSMF_YVC41_42_F2_RESERVED1_SHIFT)
#define  DSMF_DSMF_YVC41_42_F2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC41_42_F2_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC41_42_F2_RESERVED1_SHIFT))

#define  DSMF_DSMF_YVC41_42_F2_B_MASK 0x7ff0000
#define  DSMF_DSMF_YVC41_42_F2_B_SHIFT 16
#define  DSMF_DSMF_YVC41_42_F2_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC41_42_F2_B_MASK) >> DSMF_DSMF_YVC41_42_F2_B_SHIFT)
#define  DSMF_DSMF_YVC41_42_F2_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC41_42_F2_B_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC41_42_F2_B_SHIFT))

#define  DSMF_DSMF_YVC41_42_F2_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_YVC41_42_F2_RESERVED2_SHIFT 11
#define  DSMF_DSMF_YVC41_42_F2_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC41_42_F2_RESERVED2_MASK) >> DSMF_DSMF_YVC41_42_F2_RESERVED2_SHIFT)
#define  DSMF_DSMF_YVC41_42_F2_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC41_42_F2_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC41_42_F2_RESERVED2_SHIFT))

#define  DSMF_DSMF_YVC41_42_F2_A_MASK 0x7ff
#define  DSMF_DSMF_YVC41_42_F2_A_SHIFT 0
#define  DSMF_DSMF_YVC41_42_F2_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC41_42_F2_A_MASK) >> DSMF_DSMF_YVC41_42_F2_A_SHIFT)
#define  DSMF_DSMF_YVC41_42_F2_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC41_42_F2_A_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC41_42_F2_A_SHIFT))

//====================================================================
//Register: DSMF Y Variable Coefficient43_44, Filter 2 (DSMF_YVC43_44_F2)
//====================================================================

#define  DSMF_DSMF_YVC43_44_F2_RESERVED1_MASK 0xe0000000
#define  DSMF_DSMF_YVC43_44_F2_RESERVED1_SHIFT 29
#define  DSMF_DSMF_YVC43_44_F2_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC43_44_F2_RESERVED1_MASK) >> DSMF_DSMF_YVC43_44_F2_RESERVED1_SHIFT)
#define  DSMF_DSMF_YVC43_44_F2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC43_44_F2_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC43_44_F2_RESERVED1_SHIFT))

#define  DSMF_DSMF_YVC43_44_F2_B_MASK 0x1fff0000
#define  DSMF_DSMF_YVC43_44_F2_B_SHIFT 16
#define  DSMF_DSMF_YVC43_44_F2_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC43_44_F2_B_MASK) >> DSMF_DSMF_YVC43_44_F2_B_SHIFT)
#define  DSMF_DSMF_YVC43_44_F2_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC43_44_F2_B_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC43_44_F2_B_SHIFT))

#define  DSMF_DSMF_YVC43_44_F2_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_YVC43_44_F2_RESERVED2_SHIFT 11
#define  DSMF_DSMF_YVC43_44_F2_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC43_44_F2_RESERVED2_MASK) >> DSMF_DSMF_YVC43_44_F2_RESERVED2_SHIFT)
#define  DSMF_DSMF_YVC43_44_F2_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC43_44_F2_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC43_44_F2_RESERVED2_SHIFT))

#define  DSMF_DSMF_YVC43_44_F2_A_MASK 0x7ff
#define  DSMF_DSMF_YVC43_44_F2_A_SHIFT 0
#define  DSMF_DSMF_YVC43_44_F2_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC43_44_F2_A_MASK) >> DSMF_DSMF_YVC43_44_F2_A_SHIFT)
#define  DSMF_DSMF_YVC43_44_F2_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC43_44_F2_A_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC43_44_F2_A_SHIFT))

//====================================================================
//Register: DSMF Chroma Variable Coefficient00_01, Filter 2 (DSMF_CVC00_01_F2)
//====================================================================

#define  DSMF_DSMF_CVC00_01_F2_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_CVC00_01_F2_RESERVED1_SHIFT 27
#define  DSMF_DSMF_CVC00_01_F2_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC00_01_F2_RESERVED1_MASK) >> DSMF_DSMF_CVC00_01_F2_RESERVED1_SHIFT)
#define  DSMF_DSMF_CVC00_01_F2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC00_01_F2_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC00_01_F2_RESERVED1_SHIFT))

#define  DSMF_DSMF_CVC00_01_F2_B_MASK 0x7ff0000
#define  DSMF_DSMF_CVC00_01_F2_B_SHIFT 16
#define  DSMF_DSMF_CVC00_01_F2_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC00_01_F2_B_MASK) >> DSMF_DSMF_CVC00_01_F2_B_SHIFT)
#define  DSMF_DSMF_CVC00_01_F2_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC00_01_F2_B_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC00_01_F2_B_SHIFT))

#define  DSMF_DSMF_CVC00_01_F2_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_CVC00_01_F2_RESERVED2_SHIFT 11
#define  DSMF_DSMF_CVC00_01_F2_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC00_01_F2_RESERVED2_MASK) >> DSMF_DSMF_CVC00_01_F2_RESERVED2_SHIFT)
#define  DSMF_DSMF_CVC00_01_F2_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC00_01_F2_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC00_01_F2_RESERVED2_SHIFT))

#define  DSMF_DSMF_CVC00_01_F2_A_MASK 0x7ff
#define  DSMF_DSMF_CVC00_01_F2_A_SHIFT 0
#define  DSMF_DSMF_CVC00_01_F2_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC00_01_F2_A_MASK) >> DSMF_DSMF_CVC00_01_F2_A_SHIFT)
#define  DSMF_DSMF_CVC00_01_F2_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC00_01_F2_A_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC00_01_F2_A_SHIFT))

//====================================================================
//Register: DSMF Chroma Variable Coefficient02_03, Filter 2 (DSMF_CVC02_03_F2)
//====================================================================

#define  DSMF_DSMF_CVC02_03_F2_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_CVC02_03_F2_RESERVED1_SHIFT 27
#define  DSMF_DSMF_CVC02_03_F2_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC02_03_F2_RESERVED1_MASK) >> DSMF_DSMF_CVC02_03_F2_RESERVED1_SHIFT)
#define  DSMF_DSMF_CVC02_03_F2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC02_03_F2_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC02_03_F2_RESERVED1_SHIFT))

#define  DSMF_DSMF_CVC02_03_F2_B_MASK 0x7ff0000
#define  DSMF_DSMF_CVC02_03_F2_B_SHIFT 16
#define  DSMF_DSMF_CVC02_03_F2_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC02_03_F2_B_MASK) >> DSMF_DSMF_CVC02_03_F2_B_SHIFT)
#define  DSMF_DSMF_CVC02_03_F2_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC02_03_F2_B_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC02_03_F2_B_SHIFT))

#define  DSMF_DSMF_CVC02_03_F2_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_CVC02_03_F2_RESERVED2_SHIFT 11
#define  DSMF_DSMF_CVC02_03_F2_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC02_03_F2_RESERVED2_MASK) >> DSMF_DSMF_CVC02_03_F2_RESERVED2_SHIFT)
#define  DSMF_DSMF_CVC02_03_F2_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC02_03_F2_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC02_03_F2_RESERVED2_SHIFT))

#define  DSMF_DSMF_CVC02_03_F2_A_MASK 0x7ff
#define  DSMF_DSMF_CVC02_03_F2_A_SHIFT 0
#define  DSMF_DSMF_CVC02_03_F2_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC02_03_F2_A_MASK) >> DSMF_DSMF_CVC02_03_F2_A_SHIFT)
#define  DSMF_DSMF_CVC02_03_F2_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC02_03_F2_A_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC02_03_F2_A_SHIFT))

//====================================================================
//Register: DSMF Chroma Variable Coefficient04_10, Filter 2 (DSMF_CVC04_10_F2)
//====================================================================

#define  DSMF_DSMF_CVC04_10_F2_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_CVC04_10_F2_RESERVED1_SHIFT 27
#define  DSMF_DSMF_CVC04_10_F2_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC04_10_F2_RESERVED1_MASK) >> DSMF_DSMF_CVC04_10_F2_RESERVED1_SHIFT)
#define  DSMF_DSMF_CVC04_10_F2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC04_10_F2_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC04_10_F2_RESERVED1_SHIFT))

#define  DSMF_DSMF_CVC04_10_F2_B_MASK 0x7ff0000
#define  DSMF_DSMF_CVC04_10_F2_B_SHIFT 16
#define  DSMF_DSMF_CVC04_10_F2_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC04_10_F2_B_MASK) >> DSMF_DSMF_CVC04_10_F2_B_SHIFT)
#define  DSMF_DSMF_CVC04_10_F2_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC04_10_F2_B_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC04_10_F2_B_SHIFT))

#define  DSMF_DSMF_CVC04_10_F2_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_CVC04_10_F2_RESERVED2_SHIFT 11
#define  DSMF_DSMF_CVC04_10_F2_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC04_10_F2_RESERVED2_MASK) >> DSMF_DSMF_CVC04_10_F2_RESERVED2_SHIFT)
#define  DSMF_DSMF_CVC04_10_F2_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC04_10_F2_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC04_10_F2_RESERVED2_SHIFT))

#define  DSMF_DSMF_CVC04_10_F2_A_MASK 0x7ff
#define  DSMF_DSMF_CVC04_10_F2_A_SHIFT 0
#define  DSMF_DSMF_CVC04_10_F2_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC04_10_F2_A_MASK) >> DSMF_DSMF_CVC04_10_F2_A_SHIFT)
#define  DSMF_DSMF_CVC04_10_F2_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC04_10_F2_A_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC04_10_F2_A_SHIFT))

//====================================================================
//Register: DSMF Chroma Variable Coefficient11_12, Filter 2 (DSMF_CVC11_12_F2)
//====================================================================

#define  DSMF_DSMF_CVC11_12_F2_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_CVC11_12_F2_RESERVED1_SHIFT 27
#define  DSMF_DSMF_CVC11_12_F2_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC11_12_F2_RESERVED1_MASK) >> DSMF_DSMF_CVC11_12_F2_RESERVED1_SHIFT)
#define  DSMF_DSMF_CVC11_12_F2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC11_12_F2_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC11_12_F2_RESERVED1_SHIFT))

#define  DSMF_DSMF_CVC11_12_F2_B_MASK 0x7ff0000
#define  DSMF_DSMF_CVC11_12_F2_B_SHIFT 16
#define  DSMF_DSMF_CVC11_12_F2_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC11_12_F2_B_MASK) >> DSMF_DSMF_CVC11_12_F2_B_SHIFT)
#define  DSMF_DSMF_CVC11_12_F2_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC11_12_F2_B_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC11_12_F2_B_SHIFT))

#define  DSMF_DSMF_CVC11_12_F2_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_CVC11_12_F2_RESERVED2_SHIFT 11
#define  DSMF_DSMF_CVC11_12_F2_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC11_12_F2_RESERVED2_MASK) >> DSMF_DSMF_CVC11_12_F2_RESERVED2_SHIFT)
#define  DSMF_DSMF_CVC11_12_F2_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC11_12_F2_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC11_12_F2_RESERVED2_SHIFT))

#define  DSMF_DSMF_CVC11_12_F2_A_MASK 0x7ff
#define  DSMF_DSMF_CVC11_12_F2_A_SHIFT 0
#define  DSMF_DSMF_CVC11_12_F2_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC11_12_F2_A_MASK) >> DSMF_DSMF_CVC11_12_F2_A_SHIFT)
#define  DSMF_DSMF_CVC11_12_F2_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC11_12_F2_A_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC11_12_F2_A_SHIFT))

//====================================================================
//Register: DSMF Chroma Variable Coefficient13_14, Filter 2 (DSMF_CVC13_14_F2)
//====================================================================

#define  DSMF_DSMF_CVC13_14_F2_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_CVC13_14_F2_RESERVED1_SHIFT 27
#define  DSMF_DSMF_CVC13_14_F2_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC13_14_F2_RESERVED1_MASK) >> DSMF_DSMF_CVC13_14_F2_RESERVED1_SHIFT)
#define  DSMF_DSMF_CVC13_14_F2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC13_14_F2_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC13_14_F2_RESERVED1_SHIFT))

#define  DSMF_DSMF_CVC13_14_F2_B_MASK 0x7ff0000
#define  DSMF_DSMF_CVC13_14_F2_B_SHIFT 16
#define  DSMF_DSMF_CVC13_14_F2_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC13_14_F2_B_MASK) >> DSMF_DSMF_CVC13_14_F2_B_SHIFT)
#define  DSMF_DSMF_CVC13_14_F2_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC13_14_F2_B_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC13_14_F2_B_SHIFT))

#define  DSMF_DSMF_CVC13_14_F2_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_CVC13_14_F2_RESERVED2_SHIFT 11
#define  DSMF_DSMF_CVC13_14_F2_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC13_14_F2_RESERVED2_MASK) >> DSMF_DSMF_CVC13_14_F2_RESERVED2_SHIFT)
#define  DSMF_DSMF_CVC13_14_F2_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC13_14_F2_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC13_14_F2_RESERVED2_SHIFT))

#define  DSMF_DSMF_CVC13_14_F2_A_MASK 0x7ff
#define  DSMF_DSMF_CVC13_14_F2_A_SHIFT 0
#define  DSMF_DSMF_CVC13_14_F2_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC13_14_F2_A_MASK) >> DSMF_DSMF_CVC13_14_F2_A_SHIFT)
#define  DSMF_DSMF_CVC13_14_F2_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC13_14_F2_A_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC13_14_F2_A_SHIFT))

//====================================================================
//Register: DSMF Chroma Variable Coefficient20_21, Filter 2 (DSMF_CVC20_21_F2)
//====================================================================

#define  DSMF_DSMF_CVC20_21_F2_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_CVC20_21_F2_RESERVED1_SHIFT 27
#define  DSMF_DSMF_CVC20_21_F2_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC20_21_F2_RESERVED1_MASK) >> DSMF_DSMF_CVC20_21_F2_RESERVED1_SHIFT)
#define  DSMF_DSMF_CVC20_21_F2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC20_21_F2_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC20_21_F2_RESERVED1_SHIFT))

#define  DSMF_DSMF_CVC20_21_F2_B_MASK 0x7ff0000
#define  DSMF_DSMF_CVC20_21_F2_B_SHIFT 16
#define  DSMF_DSMF_CVC20_21_F2_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC20_21_F2_B_MASK) >> DSMF_DSMF_CVC20_21_F2_B_SHIFT)
#define  DSMF_DSMF_CVC20_21_F2_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC20_21_F2_B_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC20_21_F2_B_SHIFT))

#define  DSMF_DSMF_CVC20_21_F2_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_CVC20_21_F2_RESERVED2_SHIFT 11
#define  DSMF_DSMF_CVC20_21_F2_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC20_21_F2_RESERVED2_MASK) >> DSMF_DSMF_CVC20_21_F2_RESERVED2_SHIFT)
#define  DSMF_DSMF_CVC20_21_F2_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC20_21_F2_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC20_21_F2_RESERVED2_SHIFT))

#define  DSMF_DSMF_CVC20_21_F2_A_MASK 0x7ff
#define  DSMF_DSMF_CVC20_21_F2_A_SHIFT 0
#define  DSMF_DSMF_CVC20_21_F2_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC20_21_F2_A_MASK) >> DSMF_DSMF_CVC20_21_F2_A_SHIFT)
#define  DSMF_DSMF_CVC20_21_F2_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC20_21_F2_A_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC20_21_F2_A_SHIFT))

//====================================================================
//Register: DSMF Chroma Variable Coefficient22_23, Filter 2 (DSMF_CVC22_23_F2)
//====================================================================

#define  DSMF_DSMF_CVC22_23_F2_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_CVC22_23_F2_RESERVED1_SHIFT 27
#define  DSMF_DSMF_CVC22_23_F2_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC22_23_F2_RESERVED1_MASK) >> DSMF_DSMF_CVC22_23_F2_RESERVED1_SHIFT)
#define  DSMF_DSMF_CVC22_23_F2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC22_23_F2_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC22_23_F2_RESERVED1_SHIFT))

#define  DSMF_DSMF_CVC22_23_F2_B_MASK 0x7ff0000
#define  DSMF_DSMF_CVC22_23_F2_B_SHIFT 16
#define  DSMF_DSMF_CVC22_23_F2_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC22_23_F2_B_MASK) >> DSMF_DSMF_CVC22_23_F2_B_SHIFT)
#define  DSMF_DSMF_CVC22_23_F2_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC22_23_F2_B_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC22_23_F2_B_SHIFT))

#define  DSMF_DSMF_CVC22_23_F2_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_CVC22_23_F2_RESERVED2_SHIFT 11
#define  DSMF_DSMF_CVC22_23_F2_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC22_23_F2_RESERVED2_MASK) >> DSMF_DSMF_CVC22_23_F2_RESERVED2_SHIFT)
#define  DSMF_DSMF_CVC22_23_F2_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC22_23_F2_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC22_23_F2_RESERVED2_SHIFT))

#define  DSMF_DSMF_CVC22_23_F2_A_MASK 0x7ff
#define  DSMF_DSMF_CVC22_23_F2_A_SHIFT 0
#define  DSMF_DSMF_CVC22_23_F2_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC22_23_F2_A_MASK) >> DSMF_DSMF_CVC22_23_F2_A_SHIFT)
#define  DSMF_DSMF_CVC22_23_F2_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC22_23_F2_A_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC22_23_F2_A_SHIFT))

//====================================================================
//Register: DSMF Chroma Variable Coefficient24, Filter 2 (DSMF_CVC24_F2)
//====================================================================

#define  DSMF_DSMF_CVC24_F2_RESERVED1_MASK 0xfffff800
#define  DSMF_DSMF_CVC24_F2_RESERVED1_SHIFT 11
#define  DSMF_DSMF_CVC24_F2_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC24_F2_RESERVED1_MASK) >> DSMF_DSMF_CVC24_F2_RESERVED1_SHIFT)
#define  DSMF_DSMF_CVC24_F2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC24_F2_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC24_F2_RESERVED1_SHIFT))

#define  DSMF_DSMF_CVC24_F2_A_MASK 0x7ff
#define  DSMF_DSMF_CVC24_F2_A_SHIFT 0
#define  DSMF_DSMF_CVC24_F2_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC24_F2_A_MASK) >> DSMF_DSMF_CVC24_F2_A_SHIFT)
#define  DSMF_DSMF_CVC24_F2_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC24_F2_A_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC24_F2_A_SHIFT))

//====================================================================
//Register: DSMF Chroma Variable Coefficient30_31, Filter 2 (DSMF_CVC30_31_F2)
//====================================================================

#define  DSMF_DSMF_CVC30_31_F2_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_CVC30_31_F2_RESERVED1_SHIFT 27
#define  DSMF_DSMF_CVC30_31_F2_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC30_31_F2_RESERVED1_MASK) >> DSMF_DSMF_CVC30_31_F2_RESERVED1_SHIFT)
#define  DSMF_DSMF_CVC30_31_F2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC30_31_F2_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC30_31_F2_RESERVED1_SHIFT))

#define  DSMF_DSMF_CVC30_31_F2_B_MASK 0x7ff0000
#define  DSMF_DSMF_CVC30_31_F2_B_SHIFT 16
#define  DSMF_DSMF_CVC30_31_F2_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC30_31_F2_B_MASK) >> DSMF_DSMF_CVC30_31_F2_B_SHIFT)
#define  DSMF_DSMF_CVC30_31_F2_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC30_31_F2_B_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC30_31_F2_B_SHIFT))

#define  DSMF_DSMF_CVC30_31_F2_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_CVC30_31_F2_RESERVED2_SHIFT 11
#define  DSMF_DSMF_CVC30_31_F2_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC30_31_F2_RESERVED2_MASK) >> DSMF_DSMF_CVC30_31_F2_RESERVED2_SHIFT)
#define  DSMF_DSMF_CVC30_31_F2_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC30_31_F2_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC30_31_F2_RESERVED2_SHIFT))

#define  DSMF_DSMF_CVC30_31_F2_A_MASK 0x7ff
#define  DSMF_DSMF_CVC30_31_F2_A_SHIFT 0
#define  DSMF_DSMF_CVC30_31_F2_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC30_31_F2_A_MASK) >> DSMF_DSMF_CVC30_31_F2_A_SHIFT)
#define  DSMF_DSMF_CVC30_31_F2_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC30_31_F2_A_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC30_31_F2_A_SHIFT))

//====================================================================
//Register: DSMF Chroma Variable Coefficient32_33, Filter 2 (DSMF_CVC32_33_F2)
//====================================================================

#define  DSMF_DSMF_CVC32_33_F2_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_CVC32_33_F2_RESERVED1_SHIFT 27
#define  DSMF_DSMF_CVC32_33_F2_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC32_33_F2_RESERVED1_MASK) >> DSMF_DSMF_CVC32_33_F2_RESERVED1_SHIFT)
#define  DSMF_DSMF_CVC32_33_F2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC32_33_F2_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC32_33_F2_RESERVED1_SHIFT))

#define  DSMF_DSMF_CVC32_33_F2_B_MASK 0x7ff0000
#define  DSMF_DSMF_CVC32_33_F2_B_SHIFT 16
#define  DSMF_DSMF_CVC32_33_F2_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC32_33_F2_B_MASK) >> DSMF_DSMF_CVC32_33_F2_B_SHIFT)
#define  DSMF_DSMF_CVC32_33_F2_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC32_33_F2_B_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC32_33_F2_B_SHIFT))

#define  DSMF_DSMF_CVC32_33_F2_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_CVC32_33_F2_RESERVED2_SHIFT 11
#define  DSMF_DSMF_CVC32_33_F2_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC32_33_F2_RESERVED2_MASK) >> DSMF_DSMF_CVC32_33_F2_RESERVED2_SHIFT)
#define  DSMF_DSMF_CVC32_33_F2_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC32_33_F2_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC32_33_F2_RESERVED2_SHIFT))

#define  DSMF_DSMF_CVC32_33_F2_A_MASK 0x7ff
#define  DSMF_DSMF_CVC32_33_F2_A_SHIFT 0
#define  DSMF_DSMF_CVC32_33_F2_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC32_33_F2_A_MASK) >> DSMF_DSMF_CVC32_33_F2_A_SHIFT)
#define  DSMF_DSMF_CVC32_33_F2_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC32_33_F2_A_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC32_33_F2_A_SHIFT))

//====================================================================
//Register: DSMF Chroma Variable Coefficient34_40, Filter 2 (DSMF_CVC34_40_F2)
//====================================================================

#define  DSMF_DSMF_CVC34_40_F2_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_CVC34_40_F2_RESERVED1_SHIFT 27
#define  DSMF_DSMF_CVC34_40_F2_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC34_40_F2_RESERVED1_MASK) >> DSMF_DSMF_CVC34_40_F2_RESERVED1_SHIFT)
#define  DSMF_DSMF_CVC34_40_F2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC34_40_F2_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC34_40_F2_RESERVED1_SHIFT))

#define  DSMF_DSMF_CVC34_40_F2_B_MASK 0x7ff0000
#define  DSMF_DSMF_CVC34_40_F2_B_SHIFT 16
#define  DSMF_DSMF_CVC34_40_F2_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC34_40_F2_B_MASK) >> DSMF_DSMF_CVC34_40_F2_B_SHIFT)
#define  DSMF_DSMF_CVC34_40_F2_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC34_40_F2_B_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC34_40_F2_B_SHIFT))

#define  DSMF_DSMF_CVC34_40_F2_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_CVC34_40_F2_RESERVED2_SHIFT 11
#define  DSMF_DSMF_CVC34_40_F2_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC34_40_F2_RESERVED2_MASK) >> DSMF_DSMF_CVC34_40_F2_RESERVED2_SHIFT)
#define  DSMF_DSMF_CVC34_40_F2_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC34_40_F2_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC34_40_F2_RESERVED2_SHIFT))

#define  DSMF_DSMF_CVC34_40_F2_A_MASK 0x7ff
#define  DSMF_DSMF_CVC34_40_F2_A_SHIFT 0
#define  DSMF_DSMF_CVC34_40_F2_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC34_40_F2_A_MASK) >> DSMF_DSMF_CVC34_40_F2_A_SHIFT)
#define  DSMF_DSMF_CVC34_40_F2_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC34_40_F2_A_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC34_40_F2_A_SHIFT))

//====================================================================
//Register: DSMF Chroma Variable Coefficient41_42, Filter 2 (DSMF_CVC41_42_F2)
//====================================================================

#define  DSMF_DSMF_CVC41_42_F2_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_CVC41_42_F2_RESERVED1_SHIFT 27
#define  DSMF_DSMF_CVC41_42_F2_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC41_42_F2_RESERVED1_MASK) >> DSMF_DSMF_CVC41_42_F2_RESERVED1_SHIFT)
#define  DSMF_DSMF_CVC41_42_F2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC41_42_F2_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC41_42_F2_RESERVED1_SHIFT))

#define  DSMF_DSMF_CVC41_42_F2_B_MASK 0x7ff0000
#define  DSMF_DSMF_CVC41_42_F2_B_SHIFT 16
#define  DSMF_DSMF_CVC41_42_F2_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC41_42_F2_B_MASK) >> DSMF_DSMF_CVC41_42_F2_B_SHIFT)
#define  DSMF_DSMF_CVC41_42_F2_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC41_42_F2_B_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC41_42_F2_B_SHIFT))

#define  DSMF_DSMF_CVC41_42_F2_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_CVC41_42_F2_RESERVED2_SHIFT 11
#define  DSMF_DSMF_CVC41_42_F2_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC41_42_F2_RESERVED2_MASK) >> DSMF_DSMF_CVC41_42_F2_RESERVED2_SHIFT)
#define  DSMF_DSMF_CVC41_42_F2_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC41_42_F2_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC41_42_F2_RESERVED2_SHIFT))

#define  DSMF_DSMF_CVC41_42_F2_A_MASK 0x7ff
#define  DSMF_DSMF_CVC41_42_F2_A_SHIFT 0
#define  DSMF_DSMF_CVC41_42_F2_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC41_42_F2_A_MASK) >> DSMF_DSMF_CVC41_42_F2_A_SHIFT)
#define  DSMF_DSMF_CVC41_42_F2_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC41_42_F2_A_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC41_42_F2_A_SHIFT))

//====================================================================
//Register: DSMF Chroma Variable Coefficient43_44, Filter 2 (DSMF_CVC43_44_F2)
//====================================================================

#define  DSMF_DSMF_CVC43_44_F2_RESERVED1_MASK 0xe0000000
#define  DSMF_DSMF_CVC43_44_F2_RESERVED1_SHIFT 29
#define  DSMF_DSMF_CVC43_44_F2_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC43_44_F2_RESERVED1_MASK) >> DSMF_DSMF_CVC43_44_F2_RESERVED1_SHIFT)
#define  DSMF_DSMF_CVC43_44_F2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC43_44_F2_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC43_44_F2_RESERVED1_SHIFT))

#define  DSMF_DSMF_CVC43_44_F2_B_MASK 0x1fff0000
#define  DSMF_DSMF_CVC43_44_F2_B_SHIFT 16
#define  DSMF_DSMF_CVC43_44_F2_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC43_44_F2_B_MASK) >> DSMF_DSMF_CVC43_44_F2_B_SHIFT)
#define  DSMF_DSMF_CVC43_44_F2_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC43_44_F2_B_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC43_44_F2_B_SHIFT))

#define  DSMF_DSMF_CVC43_44_F2_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_CVC43_44_F2_RESERVED2_SHIFT 11
#define  DSMF_DSMF_CVC43_44_F2_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC43_44_F2_RESERVED2_MASK) >> DSMF_DSMF_CVC43_44_F2_RESERVED2_SHIFT)
#define  DSMF_DSMF_CVC43_44_F2_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC43_44_F2_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC43_44_F2_RESERVED2_SHIFT))

#define  DSMF_DSMF_CVC43_44_F2_A_MASK 0x7ff
#define  DSMF_DSMF_CVC43_44_F2_A_SHIFT 0
#define  DSMF_DSMF_CVC43_44_F2_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC43_44_F2_A_MASK) >> DSMF_DSMF_CVC43_44_F2_A_SHIFT)
#define  DSMF_DSMF_CVC43_44_F2_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC43_44_F2_A_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC43_44_F2_A_SHIFT))

//====================================================================
//Register: DSMF Filter Sum Multiplier, Filter 2 (DSMF_FILT_MULT_F2)
//====================================================================

#define  DSMF_DSMF_FILT_MULT_F2_Y_MULT_MASK 0xffff0000
#define  DSMF_DSMF_FILT_MULT_F2_Y_MULT_SHIFT 16
#define  DSMF_DSMF_FILT_MULT_F2_Y_MULT_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_FILT_MULT_F2_Y_MULT_MASK) >> DSMF_DSMF_FILT_MULT_F2_Y_MULT_SHIFT)
#define  DSMF_DSMF_FILT_MULT_F2_Y_MULT_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_FILT_MULT_F2_Y_MULT_MASK) | (((uint32_t)val) << DSMF_DSMF_FILT_MULT_F2_Y_MULT_SHIFT))

#define  DSMF_DSMF_FILT_MULT_F2_C_MULT_MASK 0xffff
#define  DSMF_DSMF_FILT_MULT_F2_C_MULT_SHIFT 0
#define  DSMF_DSMF_FILT_MULT_F2_C_MULT_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_FILT_MULT_F2_C_MULT_MASK) >> DSMF_DSMF_FILT_MULT_F2_C_MULT_SHIFT)
#define  DSMF_DSMF_FILT_MULT_F2_C_MULT_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_FILT_MULT_F2_C_MULT_MASK) | (((uint32_t)val) << DSMF_DSMF_FILT_MULT_F2_C_MULT_SHIFT))

//====================================================================
//Register: DSMF Filter Sum Shift Factor, Filter 2 (DSMF_FILT_SHIFT_F2)
//====================================================================

#define  DSMF_DSMF_FILT_SHIFT_F2_RESERVED1_MASK 0xfffffc00
#define  DSMF_DSMF_FILT_SHIFT_F2_RESERVED1_SHIFT 10
#define  DSMF_DSMF_FILT_SHIFT_F2_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_FILT_SHIFT_F2_RESERVED1_MASK) >> DSMF_DSMF_FILT_SHIFT_F2_RESERVED1_SHIFT)
#define  DSMF_DSMF_FILT_SHIFT_F2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_FILT_SHIFT_F2_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_FILT_SHIFT_F2_RESERVED1_SHIFT))

#define  DSMF_DSMF_FILT_SHIFT_F2_Y_SHIFT_MASK 0x3e0
#define  DSMF_DSMF_FILT_SHIFT_F2_Y_SHIFT_SHIFT 5
#define  DSMF_DSMF_FILT_SHIFT_F2_Y_SHIFT_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_FILT_SHIFT_F2_Y_SHIFT_MASK) >> DSMF_DSMF_FILT_SHIFT_F2_Y_SHIFT_SHIFT)
#define  DSMF_DSMF_FILT_SHIFT_F2_Y_SHIFT_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_FILT_SHIFT_F2_Y_SHIFT_MASK) | (((uint32_t)val) << DSMF_DSMF_FILT_SHIFT_F2_Y_SHIFT_SHIFT))

#define  DSMF_DSMF_FILT_SHIFT_F2_C_SHIFT_MASK 0x1f
#define  DSMF_DSMF_FILT_SHIFT_F2_C_SHIFT_SHIFT 0
#define  DSMF_DSMF_FILT_SHIFT_F2_C_SHIFT_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_FILT_SHIFT_F2_C_SHIFT_MASK) >> DSMF_DSMF_FILT_SHIFT_F2_C_SHIFT_SHIFT)
#define  DSMF_DSMF_FILT_SHIFT_F2_C_SHIFT_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_FILT_SHIFT_F2_C_SHIFT_MASK) | (((uint32_t)val) << DSMF_DSMF_FILT_SHIFT_F2_C_SHIFT_SHIFT))

//====================================================================
//Register: DSMF Y Variable Coefficient00_01, Filter 3 (DSMF_YVC00_01_F3)
/** \brief The following 5x5 filter coefficients (for Y and C) correspond to filt_coeff_sel = 3.*/
//====================================================================

#define  DSMF_DSMF_YVC00_01_F3_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_YVC00_01_F3_RESERVED1_SHIFT 27
#define  DSMF_DSMF_YVC00_01_F3_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC00_01_F3_RESERVED1_MASK) >> DSMF_DSMF_YVC00_01_F3_RESERVED1_SHIFT)
#define  DSMF_DSMF_YVC00_01_F3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC00_01_F3_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC00_01_F3_RESERVED1_SHIFT))

#define  DSMF_DSMF_YVC00_01_F3_B_MASK 0x7ff0000
#define  DSMF_DSMF_YVC00_01_F3_B_SHIFT 16
#define  DSMF_DSMF_YVC00_01_F3_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC00_01_F3_B_MASK) >> DSMF_DSMF_YVC00_01_F3_B_SHIFT)
#define  DSMF_DSMF_YVC00_01_F3_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC00_01_F3_B_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC00_01_F3_B_SHIFT))

#define  DSMF_DSMF_YVC00_01_F3_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_YVC00_01_F3_RESERVED2_SHIFT 11
#define  DSMF_DSMF_YVC00_01_F3_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC00_01_F3_RESERVED2_MASK) >> DSMF_DSMF_YVC00_01_F3_RESERVED2_SHIFT)
#define  DSMF_DSMF_YVC00_01_F3_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC00_01_F3_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC00_01_F3_RESERVED2_SHIFT))

#define  DSMF_DSMF_YVC00_01_F3_A_MASK 0x7ff
#define  DSMF_DSMF_YVC00_01_F3_A_SHIFT 0
#define  DSMF_DSMF_YVC00_01_F3_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC00_01_F3_A_MASK) >> DSMF_DSMF_YVC00_01_F3_A_SHIFT)
#define  DSMF_DSMF_YVC00_01_F3_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC00_01_F3_A_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC00_01_F3_A_SHIFT))

//====================================================================
//Register: DSMF Y Variable Coefficient02_03, Filter 3 (DSMF_YVC02_03_F3)
//====================================================================

#define  DSMF_DSMF_YVC02_03_F3_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_YVC02_03_F3_RESERVED1_SHIFT 27
#define  DSMF_DSMF_YVC02_03_F3_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC02_03_F3_RESERVED1_MASK) >> DSMF_DSMF_YVC02_03_F3_RESERVED1_SHIFT)
#define  DSMF_DSMF_YVC02_03_F3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC02_03_F3_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC02_03_F3_RESERVED1_SHIFT))

#define  DSMF_DSMF_YVC02_03_F3_B_MASK 0x7ff0000
#define  DSMF_DSMF_YVC02_03_F3_B_SHIFT 16
#define  DSMF_DSMF_YVC02_03_F3_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC02_03_F3_B_MASK) >> DSMF_DSMF_YVC02_03_F3_B_SHIFT)
#define  DSMF_DSMF_YVC02_03_F3_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC02_03_F3_B_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC02_03_F3_B_SHIFT))

#define  DSMF_DSMF_YVC02_03_F3_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_YVC02_03_F3_RESERVED2_SHIFT 11
#define  DSMF_DSMF_YVC02_03_F3_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC02_03_F3_RESERVED2_MASK) >> DSMF_DSMF_YVC02_03_F3_RESERVED2_SHIFT)
#define  DSMF_DSMF_YVC02_03_F3_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC02_03_F3_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC02_03_F3_RESERVED2_SHIFT))

#define  DSMF_DSMF_YVC02_03_F3_A_MASK 0x7ff
#define  DSMF_DSMF_YVC02_03_F3_A_SHIFT 0
#define  DSMF_DSMF_YVC02_03_F3_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC02_03_F3_A_MASK) >> DSMF_DSMF_YVC02_03_F3_A_SHIFT)
#define  DSMF_DSMF_YVC02_03_F3_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC02_03_F3_A_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC02_03_F3_A_SHIFT))

//====================================================================
//Register: DSMF Y Variable Coefficient04_10, Filter 3 (DSMF_YVC04_10_F3)
//====================================================================

#define  DSMF_DSMF_YVC04_10_F3_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_YVC04_10_F3_RESERVED1_SHIFT 27
#define  DSMF_DSMF_YVC04_10_F3_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC04_10_F3_RESERVED1_MASK) >> DSMF_DSMF_YVC04_10_F3_RESERVED1_SHIFT)
#define  DSMF_DSMF_YVC04_10_F3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC04_10_F3_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC04_10_F3_RESERVED1_SHIFT))

#define  DSMF_DSMF_YVC04_10_F3_B_MASK 0x7ff0000
#define  DSMF_DSMF_YVC04_10_F3_B_SHIFT 16
#define  DSMF_DSMF_YVC04_10_F3_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC04_10_F3_B_MASK) >> DSMF_DSMF_YVC04_10_F3_B_SHIFT)
#define  DSMF_DSMF_YVC04_10_F3_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC04_10_F3_B_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC04_10_F3_B_SHIFT))

#define  DSMF_DSMF_YVC04_10_F3_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_YVC04_10_F3_RESERVED2_SHIFT 11
#define  DSMF_DSMF_YVC04_10_F3_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC04_10_F3_RESERVED2_MASK) >> DSMF_DSMF_YVC04_10_F3_RESERVED2_SHIFT)
#define  DSMF_DSMF_YVC04_10_F3_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC04_10_F3_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC04_10_F3_RESERVED2_SHIFT))

#define  DSMF_DSMF_YVC04_10_F3_A_MASK 0x7ff
#define  DSMF_DSMF_YVC04_10_F3_A_SHIFT 0
#define  DSMF_DSMF_YVC04_10_F3_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC04_10_F3_A_MASK) >> DSMF_DSMF_YVC04_10_F3_A_SHIFT)
#define  DSMF_DSMF_YVC04_10_F3_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC04_10_F3_A_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC04_10_F3_A_SHIFT))

//====================================================================
//Register: DSMF Y Variable Coefficient11_12, Filter 3 (DSMF_YVC11_12_F3)
//====================================================================

#define  DSMF_DSMF_YVC11_12_F3_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_YVC11_12_F3_RESERVED1_SHIFT 27
#define  DSMF_DSMF_YVC11_12_F3_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC11_12_F3_RESERVED1_MASK) >> DSMF_DSMF_YVC11_12_F3_RESERVED1_SHIFT)
#define  DSMF_DSMF_YVC11_12_F3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC11_12_F3_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC11_12_F3_RESERVED1_SHIFT))

#define  DSMF_DSMF_YVC11_12_F3_B_MASK 0x7ff0000
#define  DSMF_DSMF_YVC11_12_F3_B_SHIFT 16
#define  DSMF_DSMF_YVC11_12_F3_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC11_12_F3_B_MASK) >> DSMF_DSMF_YVC11_12_F3_B_SHIFT)
#define  DSMF_DSMF_YVC11_12_F3_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC11_12_F3_B_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC11_12_F3_B_SHIFT))

#define  DSMF_DSMF_YVC11_12_F3_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_YVC11_12_F3_RESERVED2_SHIFT 11
#define  DSMF_DSMF_YVC11_12_F3_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC11_12_F3_RESERVED2_MASK) >> DSMF_DSMF_YVC11_12_F3_RESERVED2_SHIFT)
#define  DSMF_DSMF_YVC11_12_F3_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC11_12_F3_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC11_12_F3_RESERVED2_SHIFT))

#define  DSMF_DSMF_YVC11_12_F3_A_MASK 0x7ff
#define  DSMF_DSMF_YVC11_12_F3_A_SHIFT 0
#define  DSMF_DSMF_YVC11_12_F3_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC11_12_F3_A_MASK) >> DSMF_DSMF_YVC11_12_F3_A_SHIFT)
#define  DSMF_DSMF_YVC11_12_F3_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC11_12_F3_A_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC11_12_F3_A_SHIFT))

//====================================================================
//Register: DSMF Y Variable Coefficient13_14, Filter 3 (DSMF_YVC13_14_F3)
//====================================================================

#define  DSMF_DSMF_YVC13_14_F3_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_YVC13_14_F3_RESERVED1_SHIFT 27
#define  DSMF_DSMF_YVC13_14_F3_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC13_14_F3_RESERVED1_MASK) >> DSMF_DSMF_YVC13_14_F3_RESERVED1_SHIFT)
#define  DSMF_DSMF_YVC13_14_F3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC13_14_F3_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC13_14_F3_RESERVED1_SHIFT))

#define  DSMF_DSMF_YVC13_14_F3_B_MASK 0x7ff0000
#define  DSMF_DSMF_YVC13_14_F3_B_SHIFT 16
#define  DSMF_DSMF_YVC13_14_F3_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC13_14_F3_B_MASK) >> DSMF_DSMF_YVC13_14_F3_B_SHIFT)
#define  DSMF_DSMF_YVC13_14_F3_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC13_14_F3_B_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC13_14_F3_B_SHIFT))

#define  DSMF_DSMF_YVC13_14_F3_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_YVC13_14_F3_RESERVED2_SHIFT 11
#define  DSMF_DSMF_YVC13_14_F3_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC13_14_F3_RESERVED2_MASK) >> DSMF_DSMF_YVC13_14_F3_RESERVED2_SHIFT)
#define  DSMF_DSMF_YVC13_14_F3_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC13_14_F3_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC13_14_F3_RESERVED2_SHIFT))

#define  DSMF_DSMF_YVC13_14_F3_A_MASK 0x7ff
#define  DSMF_DSMF_YVC13_14_F3_A_SHIFT 0
#define  DSMF_DSMF_YVC13_14_F3_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC13_14_F3_A_MASK) >> DSMF_DSMF_YVC13_14_F3_A_SHIFT)
#define  DSMF_DSMF_YVC13_14_F3_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC13_14_F3_A_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC13_14_F3_A_SHIFT))

//====================================================================
//Register: DSMF Y Variable Coefficient20_21, Filter 3 (DSMF_YVC20_21_F3)
//====================================================================

#define  DSMF_DSMF_YVC20_21_F3_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_YVC20_21_F3_RESERVED1_SHIFT 27
#define  DSMF_DSMF_YVC20_21_F3_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC20_21_F3_RESERVED1_MASK) >> DSMF_DSMF_YVC20_21_F3_RESERVED1_SHIFT)
#define  DSMF_DSMF_YVC20_21_F3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC20_21_F3_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC20_21_F3_RESERVED1_SHIFT))

#define  DSMF_DSMF_YVC20_21_F3_B_MASK 0x7ff0000
#define  DSMF_DSMF_YVC20_21_F3_B_SHIFT 16
#define  DSMF_DSMF_YVC20_21_F3_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC20_21_F3_B_MASK) >> DSMF_DSMF_YVC20_21_F3_B_SHIFT)
#define  DSMF_DSMF_YVC20_21_F3_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC20_21_F3_B_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC20_21_F3_B_SHIFT))

#define  DSMF_DSMF_YVC20_21_F3_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_YVC20_21_F3_RESERVED2_SHIFT 11
#define  DSMF_DSMF_YVC20_21_F3_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC20_21_F3_RESERVED2_MASK) >> DSMF_DSMF_YVC20_21_F3_RESERVED2_SHIFT)
#define  DSMF_DSMF_YVC20_21_F3_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC20_21_F3_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC20_21_F3_RESERVED2_SHIFT))

#define  DSMF_DSMF_YVC20_21_F3_A_MASK 0x7ff
#define  DSMF_DSMF_YVC20_21_F3_A_SHIFT 0
#define  DSMF_DSMF_YVC20_21_F3_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC20_21_F3_A_MASK) >> DSMF_DSMF_YVC20_21_F3_A_SHIFT)
#define  DSMF_DSMF_YVC20_21_F3_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC20_21_F3_A_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC20_21_F3_A_SHIFT))

//====================================================================
//Register: DSMF Y Variable Coefficient22_23, Filter 3 (DSMF_YVC22_23_F3)
//====================================================================

#define  DSMF_DSMF_YVC22_23_F3_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_YVC22_23_F3_RESERVED1_SHIFT 27
#define  DSMF_DSMF_YVC22_23_F3_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC22_23_F3_RESERVED1_MASK) >> DSMF_DSMF_YVC22_23_F3_RESERVED1_SHIFT)
#define  DSMF_DSMF_YVC22_23_F3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC22_23_F3_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC22_23_F3_RESERVED1_SHIFT))

#define  DSMF_DSMF_YVC22_23_F3_B_MASK 0x7ff0000
#define  DSMF_DSMF_YVC22_23_F3_B_SHIFT 16
#define  DSMF_DSMF_YVC22_23_F3_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC22_23_F3_B_MASK) >> DSMF_DSMF_YVC22_23_F3_B_SHIFT)
#define  DSMF_DSMF_YVC22_23_F3_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC22_23_F3_B_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC22_23_F3_B_SHIFT))

#define  DSMF_DSMF_YVC22_23_F3_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_YVC22_23_F3_RESERVED2_SHIFT 11
#define  DSMF_DSMF_YVC22_23_F3_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC22_23_F3_RESERVED2_MASK) >> DSMF_DSMF_YVC22_23_F3_RESERVED2_SHIFT)
#define  DSMF_DSMF_YVC22_23_F3_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC22_23_F3_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC22_23_F3_RESERVED2_SHIFT))

#define  DSMF_DSMF_YVC22_23_F3_A_MASK 0x7ff
#define  DSMF_DSMF_YVC22_23_F3_A_SHIFT 0
#define  DSMF_DSMF_YVC22_23_F3_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC22_23_F3_A_MASK) >> DSMF_DSMF_YVC22_23_F3_A_SHIFT)
#define  DSMF_DSMF_YVC22_23_F3_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC22_23_F3_A_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC22_23_F3_A_SHIFT))

//====================================================================
//Register: DSMF Y Variable Coefficient24, Filter 3 (DSMF_YVC24_F3)
//====================================================================

#define  DSMF_DSMF_YVC24_F3_RESERVED1_MASK 0xfffff800
#define  DSMF_DSMF_YVC24_F3_RESERVED1_SHIFT 11
#define  DSMF_DSMF_YVC24_F3_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC24_F3_RESERVED1_MASK) >> DSMF_DSMF_YVC24_F3_RESERVED1_SHIFT)
#define  DSMF_DSMF_YVC24_F3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC24_F3_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC24_F3_RESERVED1_SHIFT))

#define  DSMF_DSMF_YVC24_F3_A_MASK 0x7ff
#define  DSMF_DSMF_YVC24_F3_A_SHIFT 0
#define  DSMF_DSMF_YVC24_F3_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC24_F3_A_MASK) >> DSMF_DSMF_YVC24_F3_A_SHIFT)
#define  DSMF_DSMF_YVC24_F3_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC24_F3_A_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC24_F3_A_SHIFT))

//====================================================================
//Register: DSMF Y Variable Coefficient30_31, Filter 3 (DSMF_YVC30_31_F3)
//====================================================================

#define  DSMF_DSMF_YVC30_31_F3_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_YVC30_31_F3_RESERVED1_SHIFT 27
#define  DSMF_DSMF_YVC30_31_F3_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC30_31_F3_RESERVED1_MASK) >> DSMF_DSMF_YVC30_31_F3_RESERVED1_SHIFT)
#define  DSMF_DSMF_YVC30_31_F3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC30_31_F3_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC30_31_F3_RESERVED1_SHIFT))

#define  DSMF_DSMF_YVC30_31_F3_B_MASK 0x7ff0000
#define  DSMF_DSMF_YVC30_31_F3_B_SHIFT 16
#define  DSMF_DSMF_YVC30_31_F3_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC30_31_F3_B_MASK) >> DSMF_DSMF_YVC30_31_F3_B_SHIFT)
#define  DSMF_DSMF_YVC30_31_F3_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC30_31_F3_B_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC30_31_F3_B_SHIFT))

#define  DSMF_DSMF_YVC30_31_F3_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_YVC30_31_F3_RESERVED2_SHIFT 11
#define  DSMF_DSMF_YVC30_31_F3_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC30_31_F3_RESERVED2_MASK) >> DSMF_DSMF_YVC30_31_F3_RESERVED2_SHIFT)
#define  DSMF_DSMF_YVC30_31_F3_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC30_31_F3_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC30_31_F3_RESERVED2_SHIFT))

#define  DSMF_DSMF_YVC30_31_F3_A_MASK 0x7ff
#define  DSMF_DSMF_YVC30_31_F3_A_SHIFT 0
#define  DSMF_DSMF_YVC30_31_F3_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC30_31_F3_A_MASK) >> DSMF_DSMF_YVC30_31_F3_A_SHIFT)
#define  DSMF_DSMF_YVC30_31_F3_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC30_31_F3_A_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC30_31_F3_A_SHIFT))

//====================================================================
//Register: DSMF Y Variable Coefficient32_33, Filter 3 (DSMF_YVC32_33_F3)
//====================================================================

#define  DSMF_DSMF_YVC32_33_F3_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_YVC32_33_F3_RESERVED1_SHIFT 27
#define  DSMF_DSMF_YVC32_33_F3_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC32_33_F3_RESERVED1_MASK) >> DSMF_DSMF_YVC32_33_F3_RESERVED1_SHIFT)
#define  DSMF_DSMF_YVC32_33_F3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC32_33_F3_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC32_33_F3_RESERVED1_SHIFT))

#define  DSMF_DSMF_YVC32_33_F3_B_MASK 0x7ff0000
#define  DSMF_DSMF_YVC32_33_F3_B_SHIFT 16
#define  DSMF_DSMF_YVC32_33_F3_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC32_33_F3_B_MASK) >> DSMF_DSMF_YVC32_33_F3_B_SHIFT)
#define  DSMF_DSMF_YVC32_33_F3_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC32_33_F3_B_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC32_33_F3_B_SHIFT))

#define  DSMF_DSMF_YVC32_33_F3_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_YVC32_33_F3_RESERVED2_SHIFT 11
#define  DSMF_DSMF_YVC32_33_F3_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC32_33_F3_RESERVED2_MASK) >> DSMF_DSMF_YVC32_33_F3_RESERVED2_SHIFT)
#define  DSMF_DSMF_YVC32_33_F3_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC32_33_F3_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC32_33_F3_RESERVED2_SHIFT))

#define  DSMF_DSMF_YVC32_33_F3_A_MASK 0x7ff
#define  DSMF_DSMF_YVC32_33_F3_A_SHIFT 0
#define  DSMF_DSMF_YVC32_33_F3_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC32_33_F3_A_MASK) >> DSMF_DSMF_YVC32_33_F3_A_SHIFT)
#define  DSMF_DSMF_YVC32_33_F3_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC32_33_F3_A_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC32_33_F3_A_SHIFT))

//====================================================================
//Register: DSMF Y Variable Coefficient34_40, Filter 3 (DSMF_YVC34_40_F3)
//====================================================================

#define  DSMF_DSMF_YVC34_40_F3_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_YVC34_40_F3_RESERVED1_SHIFT 27
#define  DSMF_DSMF_YVC34_40_F3_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC34_40_F3_RESERVED1_MASK) >> DSMF_DSMF_YVC34_40_F3_RESERVED1_SHIFT)
#define  DSMF_DSMF_YVC34_40_F3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC34_40_F3_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC34_40_F3_RESERVED1_SHIFT))

#define  DSMF_DSMF_YVC34_40_F3_B_MASK 0x7ff0000
#define  DSMF_DSMF_YVC34_40_F3_B_SHIFT 16
#define  DSMF_DSMF_YVC34_40_F3_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC34_40_F3_B_MASK) >> DSMF_DSMF_YVC34_40_F3_B_SHIFT)
#define  DSMF_DSMF_YVC34_40_F3_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC34_40_F3_B_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC34_40_F3_B_SHIFT))

#define  DSMF_DSMF_YVC34_40_F3_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_YVC34_40_F3_RESERVED2_SHIFT 11
#define  DSMF_DSMF_YVC34_40_F3_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC34_40_F3_RESERVED2_MASK) >> DSMF_DSMF_YVC34_40_F3_RESERVED2_SHIFT)
#define  DSMF_DSMF_YVC34_40_F3_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC34_40_F3_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC34_40_F3_RESERVED2_SHIFT))

#define  DSMF_DSMF_YVC34_40_F3_A_MASK 0x7ff
#define  DSMF_DSMF_YVC34_40_F3_A_SHIFT 0
#define  DSMF_DSMF_YVC34_40_F3_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC34_40_F3_A_MASK) >> DSMF_DSMF_YVC34_40_F3_A_SHIFT)
#define  DSMF_DSMF_YVC34_40_F3_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC34_40_F3_A_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC34_40_F3_A_SHIFT))

//====================================================================
//Register: DSMF Y Variable Coefficient41_42, Filter 3 (DSMF_YVC41_42_F3)
//====================================================================

#define  DSMF_DSMF_YVC41_42_F3_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_YVC41_42_F3_RESERVED1_SHIFT 27
#define  DSMF_DSMF_YVC41_42_F3_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC41_42_F3_RESERVED1_MASK) >> DSMF_DSMF_YVC41_42_F3_RESERVED1_SHIFT)
#define  DSMF_DSMF_YVC41_42_F3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC41_42_F3_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC41_42_F3_RESERVED1_SHIFT))

#define  DSMF_DSMF_YVC41_42_F3_B_MASK 0x7ff0000
#define  DSMF_DSMF_YVC41_42_F3_B_SHIFT 16
#define  DSMF_DSMF_YVC41_42_F3_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC41_42_F3_B_MASK) >> DSMF_DSMF_YVC41_42_F3_B_SHIFT)
#define  DSMF_DSMF_YVC41_42_F3_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC41_42_F3_B_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC41_42_F3_B_SHIFT))

#define  DSMF_DSMF_YVC41_42_F3_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_YVC41_42_F3_RESERVED2_SHIFT 11
#define  DSMF_DSMF_YVC41_42_F3_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC41_42_F3_RESERVED2_MASK) >> DSMF_DSMF_YVC41_42_F3_RESERVED2_SHIFT)
#define  DSMF_DSMF_YVC41_42_F3_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC41_42_F3_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC41_42_F3_RESERVED2_SHIFT))

#define  DSMF_DSMF_YVC41_42_F3_A_MASK 0x7ff
#define  DSMF_DSMF_YVC41_42_F3_A_SHIFT 0
#define  DSMF_DSMF_YVC41_42_F3_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC41_42_F3_A_MASK) >> DSMF_DSMF_YVC41_42_F3_A_SHIFT)
#define  DSMF_DSMF_YVC41_42_F3_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC41_42_F3_A_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC41_42_F3_A_SHIFT))

//====================================================================
//Register: DSMF Y Variable Coefficient43_44, Filter 3 (DSMF_YVC43_44_F3)
//====================================================================

#define  DSMF_DSMF_YVC43_44_F3_RESERVED1_MASK 0xe0000000
#define  DSMF_DSMF_YVC43_44_F3_RESERVED1_SHIFT 29
#define  DSMF_DSMF_YVC43_44_F3_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC43_44_F3_RESERVED1_MASK) >> DSMF_DSMF_YVC43_44_F3_RESERVED1_SHIFT)
#define  DSMF_DSMF_YVC43_44_F3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC43_44_F3_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC43_44_F3_RESERVED1_SHIFT))

#define  DSMF_DSMF_YVC43_44_F3_B_MASK 0x1fff0000
#define  DSMF_DSMF_YVC43_44_F3_B_SHIFT 16
#define  DSMF_DSMF_YVC43_44_F3_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC43_44_F3_B_MASK) >> DSMF_DSMF_YVC43_44_F3_B_SHIFT)
#define  DSMF_DSMF_YVC43_44_F3_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC43_44_F3_B_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC43_44_F3_B_SHIFT))

#define  DSMF_DSMF_YVC43_44_F3_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_YVC43_44_F3_RESERVED2_SHIFT 11
#define  DSMF_DSMF_YVC43_44_F3_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC43_44_F3_RESERVED2_MASK) >> DSMF_DSMF_YVC43_44_F3_RESERVED2_SHIFT)
#define  DSMF_DSMF_YVC43_44_F3_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC43_44_F3_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC43_44_F3_RESERVED2_SHIFT))

#define  DSMF_DSMF_YVC43_44_F3_A_MASK 0x7ff
#define  DSMF_DSMF_YVC43_44_F3_A_SHIFT 0
#define  DSMF_DSMF_YVC43_44_F3_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_YVC43_44_F3_A_MASK) >> DSMF_DSMF_YVC43_44_F3_A_SHIFT)
#define  DSMF_DSMF_YVC43_44_F3_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_YVC43_44_F3_A_MASK) | (((uint32_t)val) << DSMF_DSMF_YVC43_44_F3_A_SHIFT))

//====================================================================
//Register: DSMF Chroma Variable Coefficient00_01, Filter 3 (DSMF_CVC00_01_F3)
//====================================================================

#define  DSMF_DSMF_CVC00_01_F3_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_CVC00_01_F3_RESERVED1_SHIFT 27
#define  DSMF_DSMF_CVC00_01_F3_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC00_01_F3_RESERVED1_MASK) >> DSMF_DSMF_CVC00_01_F3_RESERVED1_SHIFT)
#define  DSMF_DSMF_CVC00_01_F3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC00_01_F3_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC00_01_F3_RESERVED1_SHIFT))

#define  DSMF_DSMF_CVC00_01_F3_B_MASK 0x7ff0000
#define  DSMF_DSMF_CVC00_01_F3_B_SHIFT 16
#define  DSMF_DSMF_CVC00_01_F3_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC00_01_F3_B_MASK) >> DSMF_DSMF_CVC00_01_F3_B_SHIFT)
#define  DSMF_DSMF_CVC00_01_F3_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC00_01_F3_B_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC00_01_F3_B_SHIFT))

#define  DSMF_DSMF_CVC00_01_F3_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_CVC00_01_F3_RESERVED2_SHIFT 11
#define  DSMF_DSMF_CVC00_01_F3_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC00_01_F3_RESERVED2_MASK) >> DSMF_DSMF_CVC00_01_F3_RESERVED2_SHIFT)
#define  DSMF_DSMF_CVC00_01_F3_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC00_01_F3_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC00_01_F3_RESERVED2_SHIFT))

#define  DSMF_DSMF_CVC00_01_F3_A_MASK 0x7ff
#define  DSMF_DSMF_CVC00_01_F3_A_SHIFT 0
#define  DSMF_DSMF_CVC00_01_F3_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC00_01_F3_A_MASK) >> DSMF_DSMF_CVC00_01_F3_A_SHIFT)
#define  DSMF_DSMF_CVC00_01_F3_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC00_01_F3_A_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC00_01_F3_A_SHIFT))

//====================================================================
//Register: DSMF Chroma Variable Coefficient02_03, Filter 3 (DSMF_CVC02_03_F3)
//====================================================================

#define  DSMF_DSMF_CVC02_03_F3_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_CVC02_03_F3_RESERVED1_SHIFT 27
#define  DSMF_DSMF_CVC02_03_F3_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC02_03_F3_RESERVED1_MASK) >> DSMF_DSMF_CVC02_03_F3_RESERVED1_SHIFT)
#define  DSMF_DSMF_CVC02_03_F3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC02_03_F3_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC02_03_F3_RESERVED1_SHIFT))

#define  DSMF_DSMF_CVC02_03_F3_B_MASK 0x7ff0000
#define  DSMF_DSMF_CVC02_03_F3_B_SHIFT 16
#define  DSMF_DSMF_CVC02_03_F3_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC02_03_F3_B_MASK) >> DSMF_DSMF_CVC02_03_F3_B_SHIFT)
#define  DSMF_DSMF_CVC02_03_F3_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC02_03_F3_B_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC02_03_F3_B_SHIFT))

#define  DSMF_DSMF_CVC02_03_F3_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_CVC02_03_F3_RESERVED2_SHIFT 11
#define  DSMF_DSMF_CVC02_03_F3_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC02_03_F3_RESERVED2_MASK) >> DSMF_DSMF_CVC02_03_F3_RESERVED2_SHIFT)
#define  DSMF_DSMF_CVC02_03_F3_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC02_03_F3_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC02_03_F3_RESERVED2_SHIFT))

#define  DSMF_DSMF_CVC02_03_F3_A_MASK 0x7ff
#define  DSMF_DSMF_CVC02_03_F3_A_SHIFT 0
#define  DSMF_DSMF_CVC02_03_F3_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC02_03_F3_A_MASK) >> DSMF_DSMF_CVC02_03_F3_A_SHIFT)
#define  DSMF_DSMF_CVC02_03_F3_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC02_03_F3_A_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC02_03_F3_A_SHIFT))

//====================================================================
//Register: DSMF Chroma Variable Coefficient04_10, Filter 3 (DSMF_CVC04_10_F3)
//====================================================================

#define  DSMF_DSMF_CVC04_10_F3_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_CVC04_10_F3_RESERVED1_SHIFT 27
#define  DSMF_DSMF_CVC04_10_F3_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC04_10_F3_RESERVED1_MASK) >> DSMF_DSMF_CVC04_10_F3_RESERVED1_SHIFT)
#define  DSMF_DSMF_CVC04_10_F3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC04_10_F3_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC04_10_F3_RESERVED1_SHIFT))

#define  DSMF_DSMF_CVC04_10_F3_B_MASK 0x7ff0000
#define  DSMF_DSMF_CVC04_10_F3_B_SHIFT 16
#define  DSMF_DSMF_CVC04_10_F3_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC04_10_F3_B_MASK) >> DSMF_DSMF_CVC04_10_F3_B_SHIFT)
#define  DSMF_DSMF_CVC04_10_F3_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC04_10_F3_B_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC04_10_F3_B_SHIFT))

#define  DSMF_DSMF_CVC04_10_F3_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_CVC04_10_F3_RESERVED2_SHIFT 11
#define  DSMF_DSMF_CVC04_10_F3_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC04_10_F3_RESERVED2_MASK) >> DSMF_DSMF_CVC04_10_F3_RESERVED2_SHIFT)
#define  DSMF_DSMF_CVC04_10_F3_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC04_10_F3_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC04_10_F3_RESERVED2_SHIFT))

#define  DSMF_DSMF_CVC04_10_F3_A_MASK 0x7ff
#define  DSMF_DSMF_CVC04_10_F3_A_SHIFT 0
#define  DSMF_DSMF_CVC04_10_F3_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC04_10_F3_A_MASK) >> DSMF_DSMF_CVC04_10_F3_A_SHIFT)
#define  DSMF_DSMF_CVC04_10_F3_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC04_10_F3_A_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC04_10_F3_A_SHIFT))

//====================================================================
//Register: DSMF Chroma Variable Coefficient11_12, Filter 3 (DSMF_CVC11_12_F3)
//====================================================================

#define  DSMF_DSMF_CVC11_12_F3_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_CVC11_12_F3_RESERVED1_SHIFT 27
#define  DSMF_DSMF_CVC11_12_F3_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC11_12_F3_RESERVED1_MASK) >> DSMF_DSMF_CVC11_12_F3_RESERVED1_SHIFT)
#define  DSMF_DSMF_CVC11_12_F3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC11_12_F3_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC11_12_F3_RESERVED1_SHIFT))

#define  DSMF_DSMF_CVC11_12_F3_B_MASK 0x7ff0000
#define  DSMF_DSMF_CVC11_12_F3_B_SHIFT 16
#define  DSMF_DSMF_CVC11_12_F3_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC11_12_F3_B_MASK) >> DSMF_DSMF_CVC11_12_F3_B_SHIFT)
#define  DSMF_DSMF_CVC11_12_F3_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC11_12_F3_B_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC11_12_F3_B_SHIFT))

#define  DSMF_DSMF_CVC11_12_F3_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_CVC11_12_F3_RESERVED2_SHIFT 11
#define  DSMF_DSMF_CVC11_12_F3_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC11_12_F3_RESERVED2_MASK) >> DSMF_DSMF_CVC11_12_F3_RESERVED2_SHIFT)
#define  DSMF_DSMF_CVC11_12_F3_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC11_12_F3_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC11_12_F3_RESERVED2_SHIFT))

#define  DSMF_DSMF_CVC11_12_F3_A_MASK 0x7ff
#define  DSMF_DSMF_CVC11_12_F3_A_SHIFT 0
#define  DSMF_DSMF_CVC11_12_F3_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC11_12_F3_A_MASK) >> DSMF_DSMF_CVC11_12_F3_A_SHIFT)
#define  DSMF_DSMF_CVC11_12_F3_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC11_12_F3_A_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC11_12_F3_A_SHIFT))

//====================================================================
//Register: DSMF Chroma Variable Coefficient13_14, Filter 3 (DSMF_CVC13_14_F3)
//====================================================================

#define  DSMF_DSMF_CVC13_14_F3_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_CVC13_14_F3_RESERVED1_SHIFT 27
#define  DSMF_DSMF_CVC13_14_F3_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC13_14_F3_RESERVED1_MASK) >> DSMF_DSMF_CVC13_14_F3_RESERVED1_SHIFT)
#define  DSMF_DSMF_CVC13_14_F3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC13_14_F3_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC13_14_F3_RESERVED1_SHIFT))

#define  DSMF_DSMF_CVC13_14_F3_B_MASK 0x7ff0000
#define  DSMF_DSMF_CVC13_14_F3_B_SHIFT 16
#define  DSMF_DSMF_CVC13_14_F3_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC13_14_F3_B_MASK) >> DSMF_DSMF_CVC13_14_F3_B_SHIFT)
#define  DSMF_DSMF_CVC13_14_F3_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC13_14_F3_B_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC13_14_F3_B_SHIFT))

#define  DSMF_DSMF_CVC13_14_F3_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_CVC13_14_F3_RESERVED2_SHIFT 11
#define  DSMF_DSMF_CVC13_14_F3_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC13_14_F3_RESERVED2_MASK) >> DSMF_DSMF_CVC13_14_F3_RESERVED2_SHIFT)
#define  DSMF_DSMF_CVC13_14_F3_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC13_14_F3_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC13_14_F3_RESERVED2_SHIFT))

#define  DSMF_DSMF_CVC13_14_F3_A_MASK 0x7ff
#define  DSMF_DSMF_CVC13_14_F3_A_SHIFT 0
#define  DSMF_DSMF_CVC13_14_F3_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC13_14_F3_A_MASK) >> DSMF_DSMF_CVC13_14_F3_A_SHIFT)
#define  DSMF_DSMF_CVC13_14_F3_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC13_14_F3_A_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC13_14_F3_A_SHIFT))

//====================================================================
//Register: DSMF Chroma Variable Coefficient20_21, Filter 3 (DSMF_CVC20_21_F3)
//====================================================================

#define  DSMF_DSMF_CVC20_21_F3_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_CVC20_21_F3_RESERVED1_SHIFT 27
#define  DSMF_DSMF_CVC20_21_F3_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC20_21_F3_RESERVED1_MASK) >> DSMF_DSMF_CVC20_21_F3_RESERVED1_SHIFT)
#define  DSMF_DSMF_CVC20_21_F3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC20_21_F3_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC20_21_F3_RESERVED1_SHIFT))

#define  DSMF_DSMF_CVC20_21_F3_B_MASK 0x7ff0000
#define  DSMF_DSMF_CVC20_21_F3_B_SHIFT 16
#define  DSMF_DSMF_CVC20_21_F3_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC20_21_F3_B_MASK) >> DSMF_DSMF_CVC20_21_F3_B_SHIFT)
#define  DSMF_DSMF_CVC20_21_F3_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC20_21_F3_B_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC20_21_F3_B_SHIFT))

#define  DSMF_DSMF_CVC20_21_F3_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_CVC20_21_F3_RESERVED2_SHIFT 11
#define  DSMF_DSMF_CVC20_21_F3_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC20_21_F3_RESERVED2_MASK) >> DSMF_DSMF_CVC20_21_F3_RESERVED2_SHIFT)
#define  DSMF_DSMF_CVC20_21_F3_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC20_21_F3_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC20_21_F3_RESERVED2_SHIFT))

#define  DSMF_DSMF_CVC20_21_F3_A_MASK 0x7ff
#define  DSMF_DSMF_CVC20_21_F3_A_SHIFT 0
#define  DSMF_DSMF_CVC20_21_F3_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC20_21_F3_A_MASK) >> DSMF_DSMF_CVC20_21_F3_A_SHIFT)
#define  DSMF_DSMF_CVC20_21_F3_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC20_21_F3_A_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC20_21_F3_A_SHIFT))

//====================================================================
//Register: DSMF Chroma Variable Coefficient22_23, Filter 3 (DSMF_CVC22_23_F3)
//====================================================================

#define  DSMF_DSMF_CVC22_23_F3_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_CVC22_23_F3_RESERVED1_SHIFT 27
#define  DSMF_DSMF_CVC22_23_F3_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC22_23_F3_RESERVED1_MASK) >> DSMF_DSMF_CVC22_23_F3_RESERVED1_SHIFT)
#define  DSMF_DSMF_CVC22_23_F3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC22_23_F3_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC22_23_F3_RESERVED1_SHIFT))

#define  DSMF_DSMF_CVC22_23_F3_B_MASK 0x7ff0000
#define  DSMF_DSMF_CVC22_23_F3_B_SHIFT 16
#define  DSMF_DSMF_CVC22_23_F3_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC22_23_F3_B_MASK) >> DSMF_DSMF_CVC22_23_F3_B_SHIFT)
#define  DSMF_DSMF_CVC22_23_F3_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC22_23_F3_B_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC22_23_F3_B_SHIFT))

#define  DSMF_DSMF_CVC22_23_F3_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_CVC22_23_F3_RESERVED2_SHIFT 11
#define  DSMF_DSMF_CVC22_23_F3_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC22_23_F3_RESERVED2_MASK) >> DSMF_DSMF_CVC22_23_F3_RESERVED2_SHIFT)
#define  DSMF_DSMF_CVC22_23_F3_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC22_23_F3_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC22_23_F3_RESERVED2_SHIFT))

#define  DSMF_DSMF_CVC22_23_F3_A_MASK 0x7ff
#define  DSMF_DSMF_CVC22_23_F3_A_SHIFT 0
#define  DSMF_DSMF_CVC22_23_F3_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC22_23_F3_A_MASK) >> DSMF_DSMF_CVC22_23_F3_A_SHIFT)
#define  DSMF_DSMF_CVC22_23_F3_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC22_23_F3_A_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC22_23_F3_A_SHIFT))

//====================================================================
//Register: DSMF Chroma Variable Coefficient24, Filter 3 (DSMF_CVC24_F3)
//====================================================================

#define  DSMF_DSMF_CVC24_F3_RESERVED1_MASK 0xfffff800
#define  DSMF_DSMF_CVC24_F3_RESERVED1_SHIFT 11
#define  DSMF_DSMF_CVC24_F3_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC24_F3_RESERVED1_MASK) >> DSMF_DSMF_CVC24_F3_RESERVED1_SHIFT)
#define  DSMF_DSMF_CVC24_F3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC24_F3_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC24_F3_RESERVED1_SHIFT))

#define  DSMF_DSMF_CVC24_F3_A_MASK 0x7ff
#define  DSMF_DSMF_CVC24_F3_A_SHIFT 0
#define  DSMF_DSMF_CVC24_F3_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC24_F3_A_MASK) >> DSMF_DSMF_CVC24_F3_A_SHIFT)
#define  DSMF_DSMF_CVC24_F3_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC24_F3_A_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC24_F3_A_SHIFT))

//====================================================================
//Register: DSMF Chroma Variable Coefficient30_31, Filter 3 (DSMF_CVC30_31_F3)
//====================================================================

#define  DSMF_DSMF_CVC30_31_F3_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_CVC30_31_F3_RESERVED1_SHIFT 27
#define  DSMF_DSMF_CVC30_31_F3_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC30_31_F3_RESERVED1_MASK) >> DSMF_DSMF_CVC30_31_F3_RESERVED1_SHIFT)
#define  DSMF_DSMF_CVC30_31_F3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC30_31_F3_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC30_31_F3_RESERVED1_SHIFT))

#define  DSMF_DSMF_CVC30_31_F3_B_MASK 0x7ff0000
#define  DSMF_DSMF_CVC30_31_F3_B_SHIFT 16
#define  DSMF_DSMF_CVC30_31_F3_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC30_31_F3_B_MASK) >> DSMF_DSMF_CVC30_31_F3_B_SHIFT)
#define  DSMF_DSMF_CVC30_31_F3_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC30_31_F3_B_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC30_31_F3_B_SHIFT))

#define  DSMF_DSMF_CVC30_31_F3_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_CVC30_31_F3_RESERVED2_SHIFT 11
#define  DSMF_DSMF_CVC30_31_F3_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC30_31_F3_RESERVED2_MASK) >> DSMF_DSMF_CVC30_31_F3_RESERVED2_SHIFT)
#define  DSMF_DSMF_CVC30_31_F3_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC30_31_F3_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC30_31_F3_RESERVED2_SHIFT))

#define  DSMF_DSMF_CVC30_31_F3_A_MASK 0x7ff
#define  DSMF_DSMF_CVC30_31_F3_A_SHIFT 0
#define  DSMF_DSMF_CVC30_31_F3_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC30_31_F3_A_MASK) >> DSMF_DSMF_CVC30_31_F3_A_SHIFT)
#define  DSMF_DSMF_CVC30_31_F3_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC30_31_F3_A_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC30_31_F3_A_SHIFT))

//====================================================================
//Register: DSMF Chroma Variable Coefficient32_33, Filter 3 (DSMF_CVC32_33_F3)
//====================================================================

#define  DSMF_DSMF_CVC32_33_F3_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_CVC32_33_F3_RESERVED1_SHIFT 27
#define  DSMF_DSMF_CVC32_33_F3_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC32_33_F3_RESERVED1_MASK) >> DSMF_DSMF_CVC32_33_F3_RESERVED1_SHIFT)
#define  DSMF_DSMF_CVC32_33_F3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC32_33_F3_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC32_33_F3_RESERVED1_SHIFT))

#define  DSMF_DSMF_CVC32_33_F3_B_MASK 0x7ff0000
#define  DSMF_DSMF_CVC32_33_F3_B_SHIFT 16
#define  DSMF_DSMF_CVC32_33_F3_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC32_33_F3_B_MASK) >> DSMF_DSMF_CVC32_33_F3_B_SHIFT)
#define  DSMF_DSMF_CVC32_33_F3_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC32_33_F3_B_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC32_33_F3_B_SHIFT))

#define  DSMF_DSMF_CVC32_33_F3_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_CVC32_33_F3_RESERVED2_SHIFT 11
#define  DSMF_DSMF_CVC32_33_F3_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC32_33_F3_RESERVED2_MASK) >> DSMF_DSMF_CVC32_33_F3_RESERVED2_SHIFT)
#define  DSMF_DSMF_CVC32_33_F3_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC32_33_F3_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC32_33_F3_RESERVED2_SHIFT))

#define  DSMF_DSMF_CVC32_33_F3_A_MASK 0x7ff
#define  DSMF_DSMF_CVC32_33_F3_A_SHIFT 0
#define  DSMF_DSMF_CVC32_33_F3_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC32_33_F3_A_MASK) >> DSMF_DSMF_CVC32_33_F3_A_SHIFT)
#define  DSMF_DSMF_CVC32_33_F3_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC32_33_F3_A_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC32_33_F3_A_SHIFT))

//====================================================================
//Register: DSMF Chroma Variable Coefficient34_40, Filter 3 (DSMF_CVC34_40_F3)
//====================================================================

#define  DSMF_DSMF_CVC34_40_F3_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_CVC34_40_F3_RESERVED1_SHIFT 27
#define  DSMF_DSMF_CVC34_40_F3_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC34_40_F3_RESERVED1_MASK) >> DSMF_DSMF_CVC34_40_F3_RESERVED1_SHIFT)
#define  DSMF_DSMF_CVC34_40_F3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC34_40_F3_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC34_40_F3_RESERVED1_SHIFT))

#define  DSMF_DSMF_CVC34_40_F3_B_MASK 0x7ff0000
#define  DSMF_DSMF_CVC34_40_F3_B_SHIFT 16
#define  DSMF_DSMF_CVC34_40_F3_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC34_40_F3_B_MASK) >> DSMF_DSMF_CVC34_40_F3_B_SHIFT)
#define  DSMF_DSMF_CVC34_40_F3_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC34_40_F3_B_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC34_40_F3_B_SHIFT))

#define  DSMF_DSMF_CVC34_40_F3_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_CVC34_40_F3_RESERVED2_SHIFT 11
#define  DSMF_DSMF_CVC34_40_F3_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC34_40_F3_RESERVED2_MASK) >> DSMF_DSMF_CVC34_40_F3_RESERVED2_SHIFT)
#define  DSMF_DSMF_CVC34_40_F3_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC34_40_F3_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC34_40_F3_RESERVED2_SHIFT))

#define  DSMF_DSMF_CVC34_40_F3_A_MASK 0x7ff
#define  DSMF_DSMF_CVC34_40_F3_A_SHIFT 0
#define  DSMF_DSMF_CVC34_40_F3_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC34_40_F3_A_MASK) >> DSMF_DSMF_CVC34_40_F3_A_SHIFT)
#define  DSMF_DSMF_CVC34_40_F3_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC34_40_F3_A_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC34_40_F3_A_SHIFT))

//====================================================================
//Register: DSMF Chroma Variable Coefficient41_42, Filter 3 (DSMF_CVC41_42_F3)
//====================================================================

#define  DSMF_DSMF_CVC41_42_F3_RESERVED1_MASK 0xf8000000
#define  DSMF_DSMF_CVC41_42_F3_RESERVED1_SHIFT 27
#define  DSMF_DSMF_CVC41_42_F3_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC41_42_F3_RESERVED1_MASK) >> DSMF_DSMF_CVC41_42_F3_RESERVED1_SHIFT)
#define  DSMF_DSMF_CVC41_42_F3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC41_42_F3_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC41_42_F3_RESERVED1_SHIFT))

#define  DSMF_DSMF_CVC41_42_F3_B_MASK 0x7ff0000
#define  DSMF_DSMF_CVC41_42_F3_B_SHIFT 16
#define  DSMF_DSMF_CVC41_42_F3_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC41_42_F3_B_MASK) >> DSMF_DSMF_CVC41_42_F3_B_SHIFT)
#define  DSMF_DSMF_CVC41_42_F3_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC41_42_F3_B_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC41_42_F3_B_SHIFT))

#define  DSMF_DSMF_CVC41_42_F3_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_CVC41_42_F3_RESERVED2_SHIFT 11
#define  DSMF_DSMF_CVC41_42_F3_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC41_42_F3_RESERVED2_MASK) >> DSMF_DSMF_CVC41_42_F3_RESERVED2_SHIFT)
#define  DSMF_DSMF_CVC41_42_F3_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC41_42_F3_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC41_42_F3_RESERVED2_SHIFT))

#define  DSMF_DSMF_CVC41_42_F3_A_MASK 0x7ff
#define  DSMF_DSMF_CVC41_42_F3_A_SHIFT 0
#define  DSMF_DSMF_CVC41_42_F3_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC41_42_F3_A_MASK) >> DSMF_DSMF_CVC41_42_F3_A_SHIFT)
#define  DSMF_DSMF_CVC41_42_F3_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC41_42_F3_A_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC41_42_F3_A_SHIFT))

//====================================================================
//Register: DSMF Chroma Variable Coefficient43_44, Filter 3 (DSMF_CVC43_44_F3)
//====================================================================

#define  DSMF_DSMF_CVC43_44_F3_RESERVED1_MASK 0xe0000000
#define  DSMF_DSMF_CVC43_44_F3_RESERVED1_SHIFT 29
#define  DSMF_DSMF_CVC43_44_F3_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC43_44_F3_RESERVED1_MASK) >> DSMF_DSMF_CVC43_44_F3_RESERVED1_SHIFT)
#define  DSMF_DSMF_CVC43_44_F3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC43_44_F3_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC43_44_F3_RESERVED1_SHIFT))

#define  DSMF_DSMF_CVC43_44_F3_B_MASK 0x1fff0000
#define  DSMF_DSMF_CVC43_44_F3_B_SHIFT 16
#define  DSMF_DSMF_CVC43_44_F3_B_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC43_44_F3_B_MASK) >> DSMF_DSMF_CVC43_44_F3_B_SHIFT)
#define  DSMF_DSMF_CVC43_44_F3_B_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC43_44_F3_B_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC43_44_F3_B_SHIFT))

#define  DSMF_DSMF_CVC43_44_F3_RESERVED2_MASK 0xf800
#define  DSMF_DSMF_CVC43_44_F3_RESERVED2_SHIFT 11
#define  DSMF_DSMF_CVC43_44_F3_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC43_44_F3_RESERVED2_MASK) >> DSMF_DSMF_CVC43_44_F3_RESERVED2_SHIFT)
#define  DSMF_DSMF_CVC43_44_F3_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC43_44_F3_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC43_44_F3_RESERVED2_SHIFT))

#define  DSMF_DSMF_CVC43_44_F3_A_MASK 0x7ff
#define  DSMF_DSMF_CVC43_44_F3_A_SHIFT 0
#define  DSMF_DSMF_CVC43_44_F3_A_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_CVC43_44_F3_A_MASK) >> DSMF_DSMF_CVC43_44_F3_A_SHIFT)
#define  DSMF_DSMF_CVC43_44_F3_A_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_CVC43_44_F3_A_MASK) | (((uint32_t)val) << DSMF_DSMF_CVC43_44_F3_A_SHIFT))

//====================================================================
//Register: DSMF Filter Sum Multiplier, Filter 3 (DSMF_FILT_MULT_F3)
//====================================================================

#define  DSMF_DSMF_FILT_MULT_F3_Y_MULT_MASK 0xffff0000
#define  DSMF_DSMF_FILT_MULT_F3_Y_MULT_SHIFT 16
#define  DSMF_DSMF_FILT_MULT_F3_Y_MULT_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_FILT_MULT_F3_Y_MULT_MASK) >> DSMF_DSMF_FILT_MULT_F3_Y_MULT_SHIFT)
#define  DSMF_DSMF_FILT_MULT_F3_Y_MULT_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_FILT_MULT_F3_Y_MULT_MASK) | (((uint32_t)val) << DSMF_DSMF_FILT_MULT_F3_Y_MULT_SHIFT))

#define  DSMF_DSMF_FILT_MULT_F3_C_MULT_MASK 0xffff
#define  DSMF_DSMF_FILT_MULT_F3_C_MULT_SHIFT 0
#define  DSMF_DSMF_FILT_MULT_F3_C_MULT_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_FILT_MULT_F3_C_MULT_MASK) >> DSMF_DSMF_FILT_MULT_F3_C_MULT_SHIFT)
#define  DSMF_DSMF_FILT_MULT_F3_C_MULT_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_FILT_MULT_F3_C_MULT_MASK) | (((uint32_t)val) << DSMF_DSMF_FILT_MULT_F3_C_MULT_SHIFT))

//====================================================================
//Register: DSMF Filter Sum Shift Factor, Filter 3 (DSMF_FILT_SHIFT_F3)
//====================================================================

#define  DSMF_DSMF_FILT_SHIFT_F3_RESERVED1_MASK 0xfffffc00
#define  DSMF_DSMF_FILT_SHIFT_F3_RESERVED1_SHIFT 10
#define  DSMF_DSMF_FILT_SHIFT_F3_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_FILT_SHIFT_F3_RESERVED1_MASK) >> DSMF_DSMF_FILT_SHIFT_F3_RESERVED1_SHIFT)
#define  DSMF_DSMF_FILT_SHIFT_F3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_FILT_SHIFT_F3_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_FILT_SHIFT_F3_RESERVED1_SHIFT))

#define  DSMF_DSMF_FILT_SHIFT_F3_Y_SHIFT_MASK 0x3e0
#define  DSMF_DSMF_FILT_SHIFT_F3_Y_SHIFT_SHIFT 5
#define  DSMF_DSMF_FILT_SHIFT_F3_Y_SHIFT_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_FILT_SHIFT_F3_Y_SHIFT_MASK) >> DSMF_DSMF_FILT_SHIFT_F3_Y_SHIFT_SHIFT)
#define  DSMF_DSMF_FILT_SHIFT_F3_Y_SHIFT_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_FILT_SHIFT_F3_Y_SHIFT_MASK) | (((uint32_t)val) << DSMF_DSMF_FILT_SHIFT_F3_Y_SHIFT_SHIFT))

#define  DSMF_DSMF_FILT_SHIFT_F3_C_SHIFT_MASK 0x1f
#define  DSMF_DSMF_FILT_SHIFT_F3_C_SHIFT_SHIFT 0
#define  DSMF_DSMF_FILT_SHIFT_F3_C_SHIFT_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_FILT_SHIFT_F3_C_SHIFT_MASK) >> DSMF_DSMF_FILT_SHIFT_F3_C_SHIFT_SHIFT)
#define  DSMF_DSMF_FILT_SHIFT_F3_C_SHIFT_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_FILT_SHIFT_F3_C_SHIFT_MASK) | (((uint32_t)val) << DSMF_DSMF_FILT_SHIFT_F3_C_SHIFT_SHIFT))

//====================================================================
//Register: DSMF Average Mask Mode (DSMF_AVG_MASK)
//====================================================================

#define  DSMF_DSMF_AVG_MASK_RESERVED1_MASK 0xfffff000
#define  DSMF_DSMF_AVG_MASK_RESERVED1_SHIFT 12
#define  DSMF_DSMF_AVG_MASK_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_AVG_MASK_RESERVED1_MASK) >> DSMF_DSMF_AVG_MASK_RESERVED1_SHIFT)
#define  DSMF_DSMF_AVG_MASK_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_AVG_MASK_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_AVG_MASK_RESERVED1_SHIFT))

#define  DSMF_DSMF_AVG_MASK_AVG_MASK_FIXED_MASK 0xff0
#define  DSMF_DSMF_AVG_MASK_AVG_MASK_FIXED_SHIFT 4
#define  DSMF_DSMF_AVG_MASK_AVG_MASK_FIXED_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_AVG_MASK_AVG_MASK_FIXED_MASK) >> DSMF_DSMF_AVG_MASK_AVG_MASK_FIXED_SHIFT)
#define  DSMF_DSMF_AVG_MASK_AVG_MASK_FIXED_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_AVG_MASK_AVG_MASK_FIXED_MASK) | (((uint32_t)val) << DSMF_DSMF_AVG_MASK_AVG_MASK_FIXED_SHIFT))

#define  DSMF_DSMF_AVG_MASK_RESERVED2_MASK 0x8
#define  DSMF_DSMF_AVG_MASK_RESERVED2_SHIFT 3
#define  DSMF_DSMF_AVG_MASK_RESERVED2_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_AVG_MASK_RESERVED2_MASK) >> DSMF_DSMF_AVG_MASK_RESERVED2_SHIFT)
#define  DSMF_DSMF_AVG_MASK_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_AVG_MASK_RESERVED2_MASK) | (((uint32_t)val) << DSMF_DSMF_AVG_MASK_RESERVED2_SHIFT))

#define  DSMF_DSMF_AVG_MASK_AVG_MASK_SEL_MASK 0x6
#define  DSMF_DSMF_AVG_MASK_AVG_MASK_SEL_SHIFT 1
#define  DSMF_DSMF_AVG_MASK_AVG_MASK_SEL_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_AVG_MASK_AVG_MASK_SEL_MASK) >> DSMF_DSMF_AVG_MASK_AVG_MASK_SEL_SHIFT)
#define  DSMF_DSMF_AVG_MASK_AVG_MASK_SEL_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_AVG_MASK_AVG_MASK_SEL_MASK) | (((uint32_t)val) << DSMF_DSMF_AVG_MASK_AVG_MASK_SEL_SHIFT))

#define  DSMF_DSMF_AVG_MASK_AVG_MASK_EN_MASK 0x1
#define  DSMF_DSMF_AVG_MASK_AVG_MASK_EN_SHIFT 0
#define  DSMF_DSMF_AVG_MASK_AVG_MASK_EN_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_AVG_MASK_AVG_MASK_EN_MASK) >> DSMF_DSMF_AVG_MASK_AVG_MASK_EN_SHIFT)
#define  DSMF_DSMF_AVG_MASK_AVG_MASK_EN_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_AVG_MASK_AVG_MASK_EN_MASK) | (((uint32_t)val) << DSMF_DSMF_AVG_MASK_AVG_MASK_EN_SHIFT))

//====================================================================
//Register: DSMF Filter Control LUT (DSMF_FILT_CTL_LUT)
/** \brief Filter Control LUT ;<BR>
       (Note: cpu_access_lut bit must be set to write this LUT) ;<BR>*/
//====================================================================

#define  DSMF_DSMF_FILT_CTL_LUT_RESERVED1_MASK 0xffffffc0
#define  DSMF_DSMF_FILT_CTL_LUT_RESERVED1_SHIFT 6
#define  DSMF_DSMF_FILT_CTL_LUT_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_FILT_CTL_LUT_RESERVED1_MASK) >> DSMF_DSMF_FILT_CTL_LUT_RESERVED1_SHIFT)
#define  DSMF_DSMF_FILT_CTL_LUT_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_FILT_CTL_LUT_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_FILT_CTL_LUT_RESERVED1_SHIFT))

#define  DSMF_DSMF_FILT_CTL_LUT_FILT_CTL_MASK 0x3f
#define  DSMF_DSMF_FILT_CTL_LUT_FILT_CTL_SHIFT 0
#define  DSMF_DSMF_FILT_CTL_LUT_FILT_CTL_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_FILT_CTL_LUT_FILT_CTL_MASK) >> DSMF_DSMF_FILT_CTL_LUT_FILT_CTL_SHIFT)
#define  DSMF_DSMF_FILT_CTL_LUT_FILT_CTL_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_FILT_CTL_LUT_FILT_CTL_MASK) | (((uint32_t)val) << DSMF_DSMF_FILT_CTL_LUT_FILT_CTL_SHIFT))

//====================================================================
//Register: DSMF Segmentation / Projection LUT (DSMF_SEG_PROJ_LUT)
//====================================================================

#define  DSMF_DSMF_SEG_PROJ_LUT_RESERVED1_MASK 0xffffff00
#define  DSMF_DSMF_SEG_PROJ_LUT_RESERVED1_SHIFT 8
#define  DSMF_DSMF_SEG_PROJ_LUT_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_SEG_PROJ_LUT_RESERVED1_MASK) >> DSMF_DSMF_SEG_PROJ_LUT_RESERVED1_SHIFT)
#define  DSMF_DSMF_SEG_PROJ_LUT_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_SEG_PROJ_LUT_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_SEG_PROJ_LUT_RESERVED1_SHIFT))

#define  DSMF_DSMF_SEG_PROJ_LUT_D_MASK 0xff
#define  DSMF_DSMF_SEG_PROJ_LUT_D_SHIFT 0
#define  DSMF_DSMF_SEG_PROJ_LUT_D_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_SEG_PROJ_LUT_D_MASK) >> DSMF_DSMF_SEG_PROJ_LUT_D_SHIFT)
#define  DSMF_DSMF_SEG_PROJ_LUT_D_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_SEG_PROJ_LUT_D_MASK) | (((uint32_t)val) << DSMF_DSMF_SEG_PROJ_LUT_D_SHIFT))

//====================================================================
//Register: DSMF Activity Index LUT 0 (DSMF_AI_LUT0)
//====================================================================

#define  DSMF_DSMF_AI_LUT0_RESERVED1_MASK 0xffff0000
#define  DSMF_DSMF_AI_LUT0_RESERVED1_SHIFT 16
#define  DSMF_DSMF_AI_LUT0_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_AI_LUT0_RESERVED1_MASK) >> DSMF_DSMF_AI_LUT0_RESERVED1_SHIFT)
#define  DSMF_DSMF_AI_LUT0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_AI_LUT0_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_AI_LUT0_RESERVED1_SHIFT))

#define  DSMF_DSMF_AI_LUT0_Y_MASK 0xff00
#define  DSMF_DSMF_AI_LUT0_Y_SHIFT 8
#define  DSMF_DSMF_AI_LUT0_Y_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_AI_LUT0_Y_MASK) >> DSMF_DSMF_AI_LUT0_Y_SHIFT)
#define  DSMF_DSMF_AI_LUT0_Y_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_AI_LUT0_Y_MASK) | (((uint32_t)val) << DSMF_DSMF_AI_LUT0_Y_SHIFT))

#define  DSMF_DSMF_AI_LUT0_C_MASK 0xff
#define  DSMF_DSMF_AI_LUT0_C_SHIFT 0
#define  DSMF_DSMF_AI_LUT0_C_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_AI_LUT0_C_MASK) >> DSMF_DSMF_AI_LUT0_C_SHIFT)
#define  DSMF_DSMF_AI_LUT0_C_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_AI_LUT0_C_MASK) | (((uint32_t)val) << DSMF_DSMF_AI_LUT0_C_SHIFT))

//====================================================================
//Register: DSMF Activity Index LUT 1 (DSMF_AI_LUT1)
//====================================================================

#define  DSMF_DSMF_AI_LUT1_RESERVED1_MASK 0xffff0000
#define  DSMF_DSMF_AI_LUT1_RESERVED1_SHIFT 16
#define  DSMF_DSMF_AI_LUT1_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_AI_LUT1_RESERVED1_MASK) >> DSMF_DSMF_AI_LUT1_RESERVED1_SHIFT)
#define  DSMF_DSMF_AI_LUT1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_AI_LUT1_RESERVED1_MASK) | (((uint32_t)val) << DSMF_DSMF_AI_LUT1_RESERVED1_SHIFT))

#define  DSMF_DSMF_AI_LUT1_Y_MASK 0xff00
#define  DSMF_DSMF_AI_LUT1_Y_SHIFT 8
#define  DSMF_DSMF_AI_LUT1_Y_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_AI_LUT1_Y_MASK) >> DSMF_DSMF_AI_LUT1_Y_SHIFT)
#define  DSMF_DSMF_AI_LUT1_Y_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_AI_LUT1_Y_MASK) | (((uint32_t)val) << DSMF_DSMF_AI_LUT1_Y_SHIFT))

#define  DSMF_DSMF_AI_LUT1_C_MASK 0xff
#define  DSMF_DSMF_AI_LUT1_C_SHIFT 0
#define  DSMF_DSMF_AI_LUT1_C_MASK_SHIFT(reg) (((reg) & DSMF_DSMF_AI_LUT1_C_MASK) >> DSMF_DSMF_AI_LUT1_C_SHIFT)
#define  DSMF_DSMF_AI_LUT1_C_REPLACE_VAL(reg,val) (((reg) & ~DSMF_DSMF_AI_LUT1_C_MASK) | (((uint32_t)val) << DSMF_DSMF_AI_LUT1_C_SHIFT))

//====================================================================
//Register: IP Tagging Revision 0 (REV0)
/** \brief Provide means for firmware to read IP tagging information.
      This register of particular interest to firmware.*/
//====================================================================

#define  DSMF_REV0_MAJ_MASK 0xffff0000
#define  DSMF_REV0_MAJ_SHIFT 16
#define  DSMF_REV0_MAJ_MASK_SHIFT(reg) (((reg) & DSMF_REV0_MAJ_MASK) >> DSMF_REV0_MAJ_SHIFT)
#define  DSMF_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~DSMF_REV0_MAJ_MASK) | (((uint32_t)val) << DSMF_REV0_MAJ_SHIFT))

#define  DSMF_REV0_MID_MASK 0xffff
#define  DSMF_REV0_MID_SHIFT 0
#define  DSMF_REV0_MID_MASK_SHIFT(reg) (((reg) & DSMF_REV0_MID_MASK) >> DSMF_REV0_MID_SHIFT)
#define  DSMF_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~DSMF_REV0_MID_MASK) | (((uint32_t)val) << DSMF_REV0_MID_SHIFT))

//====================================================================
//Register: IP Tagging Revision 1 (REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  DSMF_REV1_RESERVED1_MASK 0xffff0000
#define  DSMF_REV1_RESERVED1_SHIFT 16
#define  DSMF_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & DSMF_REV1_RESERVED1_MASK) >> DSMF_REV1_RESERVED1_SHIFT)
#define  DSMF_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DSMF_REV1_RESERVED1_MASK) | (((uint32_t)val) << DSMF_REV1_RESERVED1_SHIFT))

#define  DSMF_REV1_CFG_MASK 0xffff
#define  DSMF_REV1_CFG_SHIFT 0
#define  DSMF_REV1_CFG_MASK_SHIFT(reg) (((reg) & DSMF_REV1_CFG_MASK) >> DSMF_REV1_CFG_SHIFT)
#define  DSMF_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~DSMF_REV1_CFG_MASK) | (((uint32_t)val) << DSMF_REV1_CFG_SHIFT))

//====================================================================
//
//Register File: PIE Decimator (DECIM)
/** \brief Top-level register file for the Decimate block <br/> (rev 0 . 1 . 1 . 2)*/
//
//====================================================================

//====================================================================
//Register: Divisor Register (div)
/** \brief This register sets the horizontal and vertical decimation factors. The programmed value should be one less than the desired divisor. For example, when the horizontal period register is set to 2, every third pixel will be output (0, 3, 6, etc.), and the resulting line will be one-third as wide as the input. The division is truncating, for example a 64-pixel wide line divided by 3 will output a 21-pixel wide line. The first input pixel and line will always be output. A setting of 0 will pass all pixels.*/
//====================================================================

#define  DECIM_DIV_RESERVED1_MASK 0xfffff800
#define  DECIM_DIV_RESERVED1_SHIFT 11
#define  DECIM_DIV_RESERVED1_MASK_SHIFT(reg) (((reg) & DECIM_DIV_RESERVED1_MASK) >> DECIM_DIV_RESERVED1_SHIFT)
#define  DECIM_DIV_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DECIM_DIV_RESERVED1_MASK) | (((uint32_t)val) << DECIM_DIV_RESERVED1_SHIFT))

#define  DECIM_DIV_DIV_X_MASK 0x700
#define  DECIM_DIV_DIV_X_SHIFT 8
#define  DECIM_DIV_DIV_X_MASK_SHIFT(reg) (((reg) & DECIM_DIV_DIV_X_MASK) >> DECIM_DIV_DIV_X_SHIFT)
#define  DECIM_DIV_DIV_X_REPLACE_VAL(reg,val) (((reg) & ~DECIM_DIV_DIV_X_MASK) | (((uint32_t)val) << DECIM_DIV_DIV_X_SHIFT))

#define  DECIM_DIV_RESERVED2_MASK 0xf8
#define  DECIM_DIV_RESERVED2_SHIFT 3
#define  DECIM_DIV_RESERVED2_MASK_SHIFT(reg) (((reg) & DECIM_DIV_RESERVED2_MASK) >> DECIM_DIV_RESERVED2_SHIFT)
#define  DECIM_DIV_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DECIM_DIV_RESERVED2_MASK) | (((uint32_t)val) << DECIM_DIV_RESERVED2_SHIFT))

#define  DECIM_DIV_DIV_Y_MASK 0x7
#define  DECIM_DIV_DIV_Y_SHIFT 0
#define  DECIM_DIV_DIV_Y_MASK_SHIFT(reg) (((reg) & DECIM_DIV_DIV_Y_MASK) >> DECIM_DIV_DIV_Y_SHIFT)
#define  DECIM_DIV_DIV_Y_REPLACE_VAL(reg,val) (((reg) & ~DECIM_DIV_DIV_Y_MASK) | (((uint32_t)val) << DECIM_DIV_DIV_Y_SHIFT))

//====================================================================
//Register: Vertical Start Register (start)
/** \brief Normally, the first line of an image is a sampled line. However, if a strip has a height that is not a multiple of the vertical divisor, the first line of the next strip should not be sampled. This register sets the number of the line in the strip which will be the first sampled. When a strip is completed, this register will be automatically updated to have the correct starting line for the next strip, assuming that the divisors are not changed. At the start of an image, this register should be set to 0. This register should always be set to a value less than or equal to the vertical divisor register.*/
//====================================================================

#define  DECIM_START_RESERVED1_MASK 0xfffffff8
#define  DECIM_START_RESERVED1_SHIFT 3
#define  DECIM_START_RESERVED1_MASK_SHIFT(reg) (((reg) & DECIM_START_RESERVED1_MASK) >> DECIM_START_RESERVED1_SHIFT)
#define  DECIM_START_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DECIM_START_RESERVED1_MASK) | (((uint32_t)val) << DECIM_START_RESERVED1_SHIFT))

#define  DECIM_START_Y_START_POS_MASK 0x7
#define  DECIM_START_Y_START_POS_SHIFT 0
#define  DECIM_START_Y_START_POS_MASK_SHIFT(reg) (((reg) & DECIM_START_Y_START_POS_MASK) >> DECIM_START_Y_START_POS_SHIFT)
#define  DECIM_START_Y_START_POS_REPLACE_VAL(reg,val) (((reg) & ~DECIM_START_Y_START_POS_MASK) | (((uint32_t)val) << DECIM_START_Y_START_POS_SHIFT))

//====================================================================
//Register: IP Tagging Revision 0 (REV0)
/** \brief Provide means for firmware to read IP tagging information.
      This register of particular interest to firmware.*/
//====================================================================

#define  DECIM_REV0_MAJ_MASK 0xffff0000
#define  DECIM_REV0_MAJ_SHIFT 16
#define  DECIM_REV0_MAJ_MASK_SHIFT(reg) (((reg) & DECIM_REV0_MAJ_MASK) >> DECIM_REV0_MAJ_SHIFT)
#define  DECIM_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~DECIM_REV0_MAJ_MASK) | (((uint32_t)val) << DECIM_REV0_MAJ_SHIFT))

#define  DECIM_REV0_MID_MASK 0xffff
#define  DECIM_REV0_MID_SHIFT 0
#define  DECIM_REV0_MID_MASK_SHIFT(reg) (((reg) & DECIM_REV0_MID_MASK) >> DECIM_REV0_MID_SHIFT)
#define  DECIM_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~DECIM_REV0_MID_MASK) | (((uint32_t)val) << DECIM_REV0_MID_SHIFT))

//====================================================================
//Register: IP Tagging Revision 1 (REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  DECIM_REV1_RESERVED1_MASK 0xffff0000
#define  DECIM_REV1_RESERVED1_SHIFT 16
#define  DECIM_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & DECIM_REV1_RESERVED1_MASK) >> DECIM_REV1_RESERVED1_SHIFT)
#define  DECIM_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DECIM_REV1_RESERVED1_MASK) | (((uint32_t)val) << DECIM_REV1_RESERVED1_SHIFT))

#define  DECIM_REV1_CFG_MASK 0xffff
#define  DECIM_REV1_CFG_SHIFT 0
#define  DECIM_REV1_CFG_MASK_SHIFT(reg) (((reg) & DECIM_REV1_CFG_MASK) >> DECIM_REV1_CFG_SHIFT)
#define  DECIM_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~DECIM_REV1_CFG_MASK) | (((uint32_t)val) << DECIM_REV1_CFG_SHIFT))

//====================================================================
//
//Register File: PIE YCrCb2esRGB (Y2ES)
/** \brief (rev 0 . 4 . 4 . 0)
    Register Descriptions for the 1 CSC block*/
//
//====================================================================

//====================================================================
//Register: CSC Configuration Register (CCR)
/** \brief The CSC Configuration Register (CCR) manages the configuration of the CSC block. For normal operation of the CSC block, all bits in this register should be set to '0'.*/
//====================================================================

#define  Y2ES_CCR_RESERVED1_MASK 0xffffff00
#define  Y2ES_CCR_RESERVED1_SHIFT 8
#define  Y2ES_CCR_RESERVED1_MASK_SHIFT(reg) (((reg) & Y2ES_CCR_RESERVED1_MASK) >> Y2ES_CCR_RESERVED1_SHIFT)
#define  Y2ES_CCR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~Y2ES_CCR_RESERVED1_MASK) | (((uint32_t)val) << Y2ES_CCR_RESERVED1_SHIFT))

#define  Y2ES_CCR_RESERVED2_MASK 0x80
#define  Y2ES_CCR_RESERVED2_SHIFT 7
#define  Y2ES_CCR_RESERVED2_MASK_SHIFT(reg) (((reg) & Y2ES_CCR_RESERVED2_MASK) >> Y2ES_CCR_RESERVED2_SHIFT)
#define  Y2ES_CCR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~Y2ES_CCR_RESERVED2_MASK) | (((uint32_t)val) << Y2ES_CCR_RESERVED2_SHIFT))

#define  Y2ES_CCR_RESERVED3_MASK 0x40
#define  Y2ES_CCR_RESERVED3_SHIFT 6
#define  Y2ES_CCR_RESERVED3_MASK_SHIFT(reg) (((reg) & Y2ES_CCR_RESERVED3_MASK) >> Y2ES_CCR_RESERVED3_SHIFT)
#define  Y2ES_CCR_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~Y2ES_CCR_RESERVED3_MASK) | (((uint32_t)val) << Y2ES_CCR_RESERVED3_SHIFT))

#define  Y2ES_CCR_PREOFFBYPASS_MASK 0x20
#define  Y2ES_CCR_PREOFFBYPASS_SHIFT 5
#define  Y2ES_CCR_PREOFFBYPASS_MASK_SHIFT(reg) (((reg) & Y2ES_CCR_PREOFFBYPASS_MASK) >> Y2ES_CCR_PREOFFBYPASS_SHIFT)
#define  Y2ES_CCR_PREOFFBYPASS_REPLACE_VAL(reg,val) (((reg) & ~Y2ES_CCR_PREOFFBYPASS_MASK) | (((uint32_t)val) << Y2ES_CCR_PREOFFBYPASS_SHIFT))

#define  Y2ES_CCR_RESERVED4_MASK 0x10
#define  Y2ES_CCR_RESERVED4_SHIFT 4
#define  Y2ES_CCR_RESERVED4_MASK_SHIFT(reg) (((reg) & Y2ES_CCR_RESERVED4_MASK) >> Y2ES_CCR_RESERVED4_SHIFT)
#define  Y2ES_CCR_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~Y2ES_CCR_RESERVED4_MASK) | (((uint32_t)val) << Y2ES_CCR_RESERVED4_SHIFT))

#define  Y2ES_CCR_RESERVED5_MASK 0x8
#define  Y2ES_CCR_RESERVED5_SHIFT 3
#define  Y2ES_CCR_RESERVED5_MASK_SHIFT(reg) (((reg) & Y2ES_CCR_RESERVED5_MASK) >> Y2ES_CCR_RESERVED5_SHIFT)
#define  Y2ES_CCR_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~Y2ES_CCR_RESERVED5_MASK) | (((uint32_t)val) << Y2ES_CCR_RESERVED5_SHIFT))

#define  Y2ES_CCR_RESERVED6_MASK 0x4
#define  Y2ES_CCR_RESERVED6_SHIFT 2
#define  Y2ES_CCR_RESERVED6_MASK_SHIFT(reg) (((reg) & Y2ES_CCR_RESERVED6_MASK) >> Y2ES_CCR_RESERVED6_SHIFT)
#define  Y2ES_CCR_RESERVED6_REPLACE_VAL(reg,val) (((reg) & ~Y2ES_CCR_RESERVED6_MASK) | (((uint32_t)val) << Y2ES_CCR_RESERVED6_SHIFT))

#define  Y2ES_CCR_OFFSETBYPASS_MASK 0x2
#define  Y2ES_CCR_OFFSETBYPASS_SHIFT 1
#define  Y2ES_CCR_OFFSETBYPASS_MASK_SHIFT(reg) (((reg) & Y2ES_CCR_OFFSETBYPASS_MASK) >> Y2ES_CCR_OFFSETBYPASS_SHIFT)
#define  Y2ES_CCR_OFFSETBYPASS_REPLACE_VAL(reg,val) (((reg) & ~Y2ES_CCR_OFFSETBYPASS_MASK) | (((uint32_t)val) << Y2ES_CCR_OFFSETBYPASS_SHIFT))

#define  Y2ES_CCR_BYPASSALL_MASK 0x1
#define  Y2ES_CCR_BYPASSALL_SHIFT 0
#define  Y2ES_CCR_BYPASSALL_MASK_SHIFT(reg) (((reg) & Y2ES_CCR_BYPASSALL_MASK) >> Y2ES_CCR_BYPASSALL_SHIFT)
#define  Y2ES_CCR_BYPASSALL_REPLACE_VAL(reg,val) (((reg) & ~Y2ES_CCR_BYPASSALL_MASK) | (((uint32_t)val) << Y2ES_CCR_BYPASSALL_SHIFT))

//====================================================================
//Register: Multiply Coefficient Register 0 (row 0, col 0) (MCR0)
/** \brief <p class=Body>
      There are nine Multiply Coefficient Registers (MCRn), each of which stores one
      coefficient needed for the 3x3 multiply. MCR0 stores the coefficient for row 0, column 0
      of the coefficient matrix; MCR1 stores the coefficient for row 0, column 1, etc. In other
      words, the 'n' in the address is equal to (row*3)+column.
      </p>
      <p class=Body>
      The coefficients are stored as signed 2's compliment values. Each coefficient represents 
      a number in the range (-2,2). This range is obtained by normalizing the value in the
      register by 4096 . For positive numbers (MSB = 0), the second MSB will be interpreted
      as the integer portion of the number, and the remaining bits will represent the fractional
      portion. </p>*/
//====================================================================

#define  Y2ES_MCR0_RESERVED1_MASK 0xffffc000
#define  Y2ES_MCR0_RESERVED1_SHIFT 14
#define  Y2ES_MCR0_RESERVED1_MASK_SHIFT(reg) (((reg) & Y2ES_MCR0_RESERVED1_MASK) >> Y2ES_MCR0_RESERVED1_SHIFT)
#define  Y2ES_MCR0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~Y2ES_MCR0_RESERVED1_MASK) | (((uint32_t)val) << Y2ES_MCR0_RESERVED1_SHIFT))

#define  Y2ES_MCR0_COEFF_MASK 0x3fff
#define  Y2ES_MCR0_COEFF_SHIFT 0
#define  Y2ES_MCR0_COEFF_MASK_SHIFT(reg) (((reg) & Y2ES_MCR0_COEFF_MASK) >> Y2ES_MCR0_COEFF_SHIFT)
#define  Y2ES_MCR0_COEFF_REPLACE_VAL(reg,val) (((reg) & ~Y2ES_MCR0_COEFF_MASK) | (((uint32_t)val) << Y2ES_MCR0_COEFF_SHIFT))

//====================================================================
//Register: Multiply Coefficient Register 1 (row 0, col 1) (MCR1)
/** \brief <p class=Body>
      There are nine Multiply Coefficient Registers (MCRn), each of which stores one
      coefficient needed for the 3x3 multiply. MCR0 stores the coefficient for row 0, column 0
      of the coefficient matrix; MCR1 stores the coefficient for row 0, column 1, etc. In other
      words, the 'n' in the address is equal to (row*3)+column.
      </p>
      <p class=Body>
      The coefficients are stored as signed 2's compliment values. Each coefficient represents 
      a number in the range (-2,2). This range is obtained by normalizing the value in the
      register by 4096 . For positive numbers (MSB = 0), the second MSB will be interpreted
      as the integer portion of the number, and the remaining bits will represent the fractional
      portion. </p>*/
//====================================================================

#define  Y2ES_MCR1_RESERVED1_MASK 0xffffc000
#define  Y2ES_MCR1_RESERVED1_SHIFT 14
#define  Y2ES_MCR1_RESERVED1_MASK_SHIFT(reg) (((reg) & Y2ES_MCR1_RESERVED1_MASK) >> Y2ES_MCR1_RESERVED1_SHIFT)
#define  Y2ES_MCR1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~Y2ES_MCR1_RESERVED1_MASK) | (((uint32_t)val) << Y2ES_MCR1_RESERVED1_SHIFT))

#define  Y2ES_MCR1_COEFF_MASK 0x3fff
#define  Y2ES_MCR1_COEFF_SHIFT 0
#define  Y2ES_MCR1_COEFF_MASK_SHIFT(reg) (((reg) & Y2ES_MCR1_COEFF_MASK) >> Y2ES_MCR1_COEFF_SHIFT)
#define  Y2ES_MCR1_COEFF_REPLACE_VAL(reg,val) (((reg) & ~Y2ES_MCR1_COEFF_MASK) | (((uint32_t)val) << Y2ES_MCR1_COEFF_SHIFT))

//====================================================================
//Register: Multiply Coefficient Register 2 (row 0, col 2) (MCR2)
/** \brief <p class=Body>
      There are nine Multiply Coefficient Registers (MCRn), each of which stores one
      coefficient needed for the 3x3 multiply. MCR0 stores the coefficient for row 0, column 0
      of the coefficient matrix; MCR1 stores the coefficient for row 0, column 1, etc. In other
      words, the 'n' in the address is equal to (row*3)+column.
      </p>
      <p class=Body>
      The coefficients are stored as signed 2's compliment values. Each coefficient represents 
      a number in the range (-2,2). This range is obtained by normalizing the value in the
      register by 4096 . For positive numbers (MSB = 0), the second MSB will be interpreted
      as the integer portion of the number, and the remaining bits will represent the fractional
      portion. </p>*/
//====================================================================

#define  Y2ES_MCR2_RESERVED1_MASK 0xffffc000
#define  Y2ES_MCR2_RESERVED1_SHIFT 14
#define  Y2ES_MCR2_RESERVED1_MASK_SHIFT(reg) (((reg) & Y2ES_MCR2_RESERVED1_MASK) >> Y2ES_MCR2_RESERVED1_SHIFT)
#define  Y2ES_MCR2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~Y2ES_MCR2_RESERVED1_MASK) | (((uint32_t)val) << Y2ES_MCR2_RESERVED1_SHIFT))

#define  Y2ES_MCR2_COEFF_MASK 0x3fff
#define  Y2ES_MCR2_COEFF_SHIFT 0
#define  Y2ES_MCR2_COEFF_MASK_SHIFT(reg) (((reg) & Y2ES_MCR2_COEFF_MASK) >> Y2ES_MCR2_COEFF_SHIFT)
#define  Y2ES_MCR2_COEFF_REPLACE_VAL(reg,val) (((reg) & ~Y2ES_MCR2_COEFF_MASK) | (((uint32_t)val) << Y2ES_MCR2_COEFF_SHIFT))

//====================================================================
//Register: Multiply Coefficient Register 3 (row 1, col 0) (MCR3)
/** \brief <p class=Body>
      There are nine Multiply Coefficient Registers (MCRn), each of which stores one
      coefficient needed for the 3x3 multiply. MCR0 stores the coefficient for row 0, column 0
      of the coefficient matrix; MCR1 stores the coefficient for row 0, column 1, etc. In other
      words, the 'n' in the address is equal to (row*3)+column.
      </p>
      <p class=Body>
      The coefficients are stored as signed 2's compliment values. Each coefficient represents 
      a number in the range (-2,2). This range is obtained by normalizing the value in the
      register by 4096 . For positive numbers (MSB = 0), the second MSB will be interpreted
      as the integer portion of the number, and the remaining bits will represent the fractional
      portion. </p>*/
//====================================================================

#define  Y2ES_MCR3_RESERVED1_MASK 0xffffc000
#define  Y2ES_MCR3_RESERVED1_SHIFT 14
#define  Y2ES_MCR3_RESERVED1_MASK_SHIFT(reg) (((reg) & Y2ES_MCR3_RESERVED1_MASK) >> Y2ES_MCR3_RESERVED1_SHIFT)
#define  Y2ES_MCR3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~Y2ES_MCR3_RESERVED1_MASK) | (((uint32_t)val) << Y2ES_MCR3_RESERVED1_SHIFT))

#define  Y2ES_MCR3_COEFF_MASK 0x3fff
#define  Y2ES_MCR3_COEFF_SHIFT 0
#define  Y2ES_MCR3_COEFF_MASK_SHIFT(reg) (((reg) & Y2ES_MCR3_COEFF_MASK) >> Y2ES_MCR3_COEFF_SHIFT)
#define  Y2ES_MCR3_COEFF_REPLACE_VAL(reg,val) (((reg) & ~Y2ES_MCR3_COEFF_MASK) | (((uint32_t)val) << Y2ES_MCR3_COEFF_SHIFT))

//====================================================================
//Register: Multiply Coefficient Register 4 (row 1, col 1) (MCR4)
/** \brief <p class=Body>
      There are nine Multiply Coefficient Registers (MCRn), each of which stores one
      coefficient needed for the 3x3 multiply. MCR0 stores the coefficient for row 0, column 0
      of the coefficient matrix; MCR1 stores the coefficient for row 0, column 1, etc. In other
      words, the 'n' in the address is equal to (row*3)+column.
      </p>
      <p class=Body>
      The coefficients are stored as signed 2's compliment values. Each coefficient represents 
      a number in the range (-2,2). This range is obtained by normalizing the value in the
      register by 4096 . For positive numbers (MSB = 0), the second MSB will be interpreted
      as the integer portion of the number, and the remaining bits will represent the fractional
      portion. </p>*/
//====================================================================

#define  Y2ES_MCR4_RESERVED1_MASK 0xffffc000
#define  Y2ES_MCR4_RESERVED1_SHIFT 14
#define  Y2ES_MCR4_RESERVED1_MASK_SHIFT(reg) (((reg) & Y2ES_MCR4_RESERVED1_MASK) >> Y2ES_MCR4_RESERVED1_SHIFT)
#define  Y2ES_MCR4_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~Y2ES_MCR4_RESERVED1_MASK) | (((uint32_t)val) << Y2ES_MCR4_RESERVED1_SHIFT))

#define  Y2ES_MCR4_COEFF_MASK 0x3fff
#define  Y2ES_MCR4_COEFF_SHIFT 0
#define  Y2ES_MCR4_COEFF_MASK_SHIFT(reg) (((reg) & Y2ES_MCR4_COEFF_MASK) >> Y2ES_MCR4_COEFF_SHIFT)
#define  Y2ES_MCR4_COEFF_REPLACE_VAL(reg,val) (((reg) & ~Y2ES_MCR4_COEFF_MASK) | (((uint32_t)val) << Y2ES_MCR4_COEFF_SHIFT))

//====================================================================
//Register: Multiply Coefficient Register 5 (row 1, col 2) (MCR5)
/** \brief <p class=Body>
      There are nine Multiply Coefficient Registers (MCRn), each of which stores one
      coefficient needed for the 3x3 multiply. MCR0 stores the coefficient for row 0, column 0
      of the coefficient matrix; MCR1 stores the coefficient for row 0, column 1, etc. In other
      words, the 'n' in the address is equal to (row*3)+column.
      </p>
      <p class=Body>
      The coefficients are stored as signed 2's compliment values. Each coefficient represents 
      a number in the range (-2,2). This range is obtained by normalizing the value in the
      register by 4096 . For positive numbers (MSB = 0), the second MSB will be interpreted
      as the integer portion of the number, and the remaining bits will represent the fractional
      portion. </p>*/
//====================================================================

#define  Y2ES_MCR5_RESERVED1_MASK 0xffffc000
#define  Y2ES_MCR5_RESERVED1_SHIFT 14
#define  Y2ES_MCR5_RESERVED1_MASK_SHIFT(reg) (((reg) & Y2ES_MCR5_RESERVED1_MASK) >> Y2ES_MCR5_RESERVED1_SHIFT)
#define  Y2ES_MCR5_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~Y2ES_MCR5_RESERVED1_MASK) | (((uint32_t)val) << Y2ES_MCR5_RESERVED1_SHIFT))

#define  Y2ES_MCR5_COEFF_MASK 0x3fff
#define  Y2ES_MCR5_COEFF_SHIFT 0
#define  Y2ES_MCR5_COEFF_MASK_SHIFT(reg) (((reg) & Y2ES_MCR5_COEFF_MASK) >> Y2ES_MCR5_COEFF_SHIFT)
#define  Y2ES_MCR5_COEFF_REPLACE_VAL(reg,val) (((reg) & ~Y2ES_MCR5_COEFF_MASK) | (((uint32_t)val) << Y2ES_MCR5_COEFF_SHIFT))

//====================================================================
//Register: Multiply Coefficient Register 6 (row 2, col 0) (MCR6)
/** \brief <p class=Body>
      There are nine Multiply Coefficient Registers (MCRn), each of which stores one
      coefficient needed for the 3x3 multiply. MCR0 stores the coefficient for row 0, column 0
      of the coefficient matrix; MCR1 stores the coefficient for row 0, column 1, etc. In other
      words, the 'n' in the address is equal to (row*3)+column.
      </p>
      <p class=Body>
      The coefficients are stored as signed 2's compliment values. Each coefficient represents 
      a number in the range (-2,2). This range is obtained by normalizing the value in the
      register by 4096 . For positive numbers (MSB = 0), the second MSB will be interpreted
      as the integer portion of the number, and the remaining bits will represent the fractional
      portion. </p>*/
//====================================================================

#define  Y2ES_MCR6_RESERVED1_MASK 0xffffc000
#define  Y2ES_MCR6_RESERVED1_SHIFT 14
#define  Y2ES_MCR6_RESERVED1_MASK_SHIFT(reg) (((reg) & Y2ES_MCR6_RESERVED1_MASK) >> Y2ES_MCR6_RESERVED1_SHIFT)
#define  Y2ES_MCR6_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~Y2ES_MCR6_RESERVED1_MASK) | (((uint32_t)val) << Y2ES_MCR6_RESERVED1_SHIFT))

#define  Y2ES_MCR6_COEFF_MASK 0x3fff
#define  Y2ES_MCR6_COEFF_SHIFT 0
#define  Y2ES_MCR6_COEFF_MASK_SHIFT(reg) (((reg) & Y2ES_MCR6_COEFF_MASK) >> Y2ES_MCR6_COEFF_SHIFT)
#define  Y2ES_MCR6_COEFF_REPLACE_VAL(reg,val) (((reg) & ~Y2ES_MCR6_COEFF_MASK) | (((uint32_t)val) << Y2ES_MCR6_COEFF_SHIFT))

//====================================================================
//Register: Multiply Coefficient Register 7 (row 2, col 1) (MCR7)
/** \brief <p class=Body>
      There are nine Multiply Coefficient Registers (MCRn), each of which stores one
      coefficient needed for the 3x3 multiply. MCR0 stores the coefficient for row 0, column 0
      of the coefficient matrix; MCR1 stores the coefficient for row 0, column 1, etc. In other
      words, the 'n' in the address is equal to (row*3)+column.
      </p>
      <p class=Body>
      The coefficients are stored as signed 2's compliment values. Each coefficient represents 
      a number in the range (-2,2). This range is obtained by normalizing the value in the
      register by 4096 . For positive numbers (MSB = 0), the second MSB will be interpreted
      as the integer portion of the number, and the remaining bits will represent the fractional
      portion. </p>*/
//====================================================================

#define  Y2ES_MCR7_RESERVED1_MASK 0xffffc000
#define  Y2ES_MCR7_RESERVED1_SHIFT 14
#define  Y2ES_MCR7_RESERVED1_MASK_SHIFT(reg) (((reg) & Y2ES_MCR7_RESERVED1_MASK) >> Y2ES_MCR7_RESERVED1_SHIFT)
#define  Y2ES_MCR7_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~Y2ES_MCR7_RESERVED1_MASK) | (((uint32_t)val) << Y2ES_MCR7_RESERVED1_SHIFT))

#define  Y2ES_MCR7_COEFF_MASK 0x3fff
#define  Y2ES_MCR7_COEFF_SHIFT 0
#define  Y2ES_MCR7_COEFF_MASK_SHIFT(reg) (((reg) & Y2ES_MCR7_COEFF_MASK) >> Y2ES_MCR7_COEFF_SHIFT)
#define  Y2ES_MCR7_COEFF_REPLACE_VAL(reg,val) (((reg) & ~Y2ES_MCR7_COEFF_MASK) | (((uint32_t)val) << Y2ES_MCR7_COEFF_SHIFT))

//====================================================================
//Register: Multiply Coefficient Register 8 (row 2, col 2) (MCR8)
/** \brief <p class=Body>
      There are nine Multiply Coefficient Registers (MCRn), each of which stores one
      coefficient needed for the 3x3 multiply. MCR0 stores the coefficient for row 0, column 0
      of the coefficient matrix; MCR1 stores the coefficient for row 0, column 1, etc. In other
      words, the 'n' in the address is equal to (row*3)+column.
      </p>
      <p class=Body>
      The coefficients are stored as signed 2's compliment values. Each coefficient represents 
      a number in the range (-2,2). This range is obtained by normalizing the value in the
      register by 4096 . For positive numbers (MSB = 0), the second MSB will be interpreted
      as the integer portion of the number, and the remaining bits will represent the fractional
      portion. </p>*/
//====================================================================

#define  Y2ES_MCR8_RESERVED1_MASK 0xffffc000
#define  Y2ES_MCR8_RESERVED1_SHIFT 14
#define  Y2ES_MCR8_RESERVED1_MASK_SHIFT(reg) (((reg) & Y2ES_MCR8_RESERVED1_MASK) >> Y2ES_MCR8_RESERVED1_SHIFT)
#define  Y2ES_MCR8_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~Y2ES_MCR8_RESERVED1_MASK) | (((uint32_t)val) << Y2ES_MCR8_RESERVED1_SHIFT))

#define  Y2ES_MCR8_COEFF_MASK 0x3fff
#define  Y2ES_MCR8_COEFF_SHIFT 0
#define  Y2ES_MCR8_COEFF_MASK_SHIFT(reg) (((reg) & Y2ES_MCR8_COEFF_MASK) >> Y2ES_MCR8_COEFF_SHIFT)
#define  Y2ES_MCR8_COEFF_REPLACE_VAL(reg,val) (((reg) & ~Y2ES_MCR8_COEFF_MASK) | (((uint32_t)val) << Y2ES_MCR8_COEFF_SHIFT))

//====================================================================
//Register: IP Tagging Revision 0 (REV0)
/** \brief Provide means for firmware to read IP tagging information.
      This register of particular interest to firmware.*/
//====================================================================

#define  Y2ES_REV0_MAJ_MASK 0xffff0000
#define  Y2ES_REV0_MAJ_SHIFT 16
#define  Y2ES_REV0_MAJ_MASK_SHIFT(reg) (((reg) & Y2ES_REV0_MAJ_MASK) >> Y2ES_REV0_MAJ_SHIFT)
#define  Y2ES_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~Y2ES_REV0_MAJ_MASK) | (((uint32_t)val) << Y2ES_REV0_MAJ_SHIFT))

#define  Y2ES_REV0_MID_MASK 0xffff
#define  Y2ES_REV0_MID_SHIFT 0
#define  Y2ES_REV0_MID_MASK_SHIFT(reg) (((reg) & Y2ES_REV0_MID_MASK) >> Y2ES_REV0_MID_SHIFT)
#define  Y2ES_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~Y2ES_REV0_MID_MASK) | (((uint32_t)val) << Y2ES_REV0_MID_SHIFT))

//====================================================================
//Register: IP Tagging Revision 1 (REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  Y2ES_REV1_RESERVED1_MASK 0xffff0000
#define  Y2ES_REV1_RESERVED1_SHIFT 16
#define  Y2ES_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & Y2ES_REV1_RESERVED1_MASK) >> Y2ES_REV1_RESERVED1_SHIFT)
#define  Y2ES_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~Y2ES_REV1_RESERVED1_MASK) | (((uint32_t)val) << Y2ES_REV1_RESERVED1_SHIFT))

#define  Y2ES_REV1_CFG_MASK 0xffff
#define  Y2ES_REV1_CFG_SHIFT 0
#define  Y2ES_REV1_CFG_MASK_SHIFT(reg) (((reg) & Y2ES_REV1_CFG_MASK) >> Y2ES_REV1_CFG_SHIFT)
#define  Y2ES_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~Y2ES_REV1_CFG_MASK) | (((uint32_t)val) << Y2ES_REV1_CFG_SHIFT))

//====================================================================
//
//Register File: PIE XYScale (XYScale)
/** \brief Register Descriptions for the PIE XYScale block
    (rev 0 . 3 . 4 . 2)*/
//
//====================================================================

//====================================================================
//Register: Configure X-Y Scale Register (CSR)
/** \brief Bit [8] Switches Algorithms between Running Average Pixel Replication (reset to zero) and
      Linear Mode (set to one).</p>
      Bits [17:16] round up instead of truncate for a potentially closer desired output.
      The round-up bits only work in Running Average Pixel Replication Mode. Bit 16 is used by
      the Y scaler and bit 17 is used by the X scaler. These bits must be set prior to turning
      off Bypass bit 0. Bit 18 was used for rounding in a previous implementation. It is
      unused in this version for backwards compatibility.</p>
      Bypass is ORed into the synchronous reset, and the synchronous reset must be active for
      one clock in order for any reset value to take hold. Therefore, when rounding, two
      sequential writes must be written to the Configuration Register, one with the bits set
      and bypass bit 0 set as well, the second with bypass reset to zero to start functional
      operation.*/
//====================================================================

#define  XYSCALE_CSR_RESERVED1_MASK 0xfff80000
#define  XYSCALE_CSR_RESERVED1_SHIFT 19
#define  XYSCALE_CSR_RESERVED1_MASK_SHIFT(reg) (((reg) & XYSCALE_CSR_RESERVED1_MASK) >> XYSCALE_CSR_RESERVED1_SHIFT)
#define  XYSCALE_CSR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~XYSCALE_CSR_RESERVED1_MASK) | (((uint32_t)val) << XYSCALE_CSR_RESERVED1_SHIFT))

#define  XYSCALE_CSR_RU_MASK 0x70000
#define  XYSCALE_CSR_RU_SHIFT 16
#define  XYSCALE_CSR_RU_MASK_SHIFT(reg) (((reg) & XYSCALE_CSR_RU_MASK) >> XYSCALE_CSR_RU_SHIFT)
#define  XYSCALE_CSR_RU_REPLACE_VAL(reg,val) (((reg) & ~XYSCALE_CSR_RU_MASK) | (((uint32_t)val) << XYSCALE_CSR_RU_SHIFT))

#define  XYSCALE_CSR_RESERVED2_MASK 0xfe00
#define  XYSCALE_CSR_RESERVED2_SHIFT 9
#define  XYSCALE_CSR_RESERVED2_MASK_SHIFT(reg) (((reg) & XYSCALE_CSR_RESERVED2_MASK) >> XYSCALE_CSR_RESERVED2_SHIFT)
#define  XYSCALE_CSR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~XYSCALE_CSR_RESERVED2_MASK) | (((uint32_t)val) << XYSCALE_CSR_RESERVED2_SHIFT))

#define  XYSCALE_CSR_LM_MASK 0x100
#define  XYSCALE_CSR_LM_SHIFT 8
#define  XYSCALE_CSR_LM_MASK_SHIFT(reg) (((reg) & XYSCALE_CSR_LM_MASK) >> XYSCALE_CSR_LM_SHIFT)
#define  XYSCALE_CSR_LM_REPLACE_VAL(reg,val) (((reg) & ~XYSCALE_CSR_LM_MASK) | (((uint32_t)val) << XYSCALE_CSR_LM_SHIFT))

#define  XYSCALE_CSR_RESERVED3_MASK 0xfe
#define  XYSCALE_CSR_RESERVED3_SHIFT 1
#define  XYSCALE_CSR_RESERVED3_MASK_SHIFT(reg) (((reg) & XYSCALE_CSR_RESERVED3_MASK) >> XYSCALE_CSR_RESERVED3_SHIFT)
#define  XYSCALE_CSR_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~XYSCALE_CSR_RESERVED3_MASK) | (((uint32_t)val) << XYSCALE_CSR_RESERVED3_SHIFT))

#define  XYSCALE_CSR_B_MASK 0x1
#define  XYSCALE_CSR_B_SHIFT 0
#define  XYSCALE_CSR_B_MASK_SHIFT(reg) (((reg) & XYSCALE_CSR_B_MASK) >> XYSCALE_CSR_B_SHIFT)
#define  XYSCALE_CSR_B_REPLACE_VAL(reg,val) (((reg) & ~XYSCALE_CSR_B_MASK) | (((uint32_t)val) << XYSCALE_CSR_B_SHIFT))

//====================================================================
//Register: Output Strip Column Count Register (CCR)
/** \brief <p>The Output Column Count may also be thought of as the number of x-direction pixels
      in a given output line. This value may exceed the scaled output count of the input pixels
      in which case data padding will be used to make up the difference. In the case where this
      value is less than the scaled output count the output is cut short to this new count. Data
      padding will either use individual fill data as setup in the color X fill data registers
      below, or if the Replicate Mode bit is set, will use the last column data values to pad
      with.</p>
      <p>This replaces a pad count that extends the data size to some optimal DMA sizing,
      and adds the feature of being able to cut short output data. </p>
      <p>Once written, this register will stick through all subsequent strips until
      changed.</p>*/
//====================================================================

#define  XYSCALE_CCR_RESERVED1_MASK 0xfe000000
#define  XYSCALE_CCR_RESERVED1_SHIFT 25
#define  XYSCALE_CCR_RESERVED1_MASK_SHIFT(reg) (((reg) & XYSCALE_CCR_RESERVED1_MASK) >> XYSCALE_CCR_RESERVED1_SHIFT)
#define  XYSCALE_CCR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~XYSCALE_CCR_RESERVED1_MASK) | (((uint32_t)val) << XYSCALE_CCR_RESERVED1_SHIFT))

#define  XYSCALE_CCR_RM_MASK 0x1000000
#define  XYSCALE_CCR_RM_SHIFT 24
#define  XYSCALE_CCR_RM_MASK_SHIFT(reg) (((reg) & XYSCALE_CCR_RM_MASK) >> XYSCALE_CCR_RM_SHIFT)
#define  XYSCALE_CCR_RM_REPLACE_VAL(reg,val) (((reg) & ~XYSCALE_CCR_RM_MASK) | (((uint32_t)val) << XYSCALE_CCR_RM_SHIFT))

#define  XYSCALE_CCR_RESERVED2_MASK 0xfc0000
#define  XYSCALE_CCR_RESERVED2_SHIFT 18
#define  XYSCALE_CCR_RESERVED2_MASK_SHIFT(reg) (((reg) & XYSCALE_CCR_RESERVED2_MASK) >> XYSCALE_CCR_RESERVED2_SHIFT)
#define  XYSCALE_CCR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~XYSCALE_CCR_RESERVED2_MASK) | (((uint32_t)val) << XYSCALE_CCR_RESERVED2_SHIFT))

#define  XYSCALE_CCR_CC_MASK 0x3ffff
#define  XYSCALE_CCR_CC_SHIFT 0
#define  XYSCALE_CCR_CC_MASK_SHIFT(reg) (((reg) & XYSCALE_CCR_CC_MASK) >> XYSCALE_CCR_CC_SHIFT)
#define  XYSCALE_CCR_CC_REPLACE_VAL(reg,val) (((reg) & ~XYSCALE_CCR_CC_MASK) | (((uint32_t)val) << XYSCALE_CCR_CC_SHIFT))

//====================================================================
//Register: Color 2 and Color 1 Fill Data Register (CFR1)
//====================================================================

#define  XYSCALE_CFR1_RESERVED1_MASK 0xff000000
#define  XYSCALE_CFR1_RESERVED1_SHIFT 24
#define  XYSCALE_CFR1_RESERVED1_MASK_SHIFT(reg) (((reg) & XYSCALE_CFR1_RESERVED1_MASK) >> XYSCALE_CFR1_RESERVED1_SHIFT)
#define  XYSCALE_CFR1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~XYSCALE_CFR1_RESERVED1_MASK) | (((uint32_t)val) << XYSCALE_CFR1_RESERVED1_SHIFT))

#define  XYSCALE_CFR1_FILL2_MASK 0xff0000
#define  XYSCALE_CFR1_FILL2_SHIFT 16
#define  XYSCALE_CFR1_FILL2_MASK_SHIFT(reg) (((reg) & XYSCALE_CFR1_FILL2_MASK) >> XYSCALE_CFR1_FILL2_SHIFT)
#define  XYSCALE_CFR1_FILL2_REPLACE_VAL(reg,val) (((reg) & ~XYSCALE_CFR1_FILL2_MASK) | (((uint32_t)val) << XYSCALE_CFR1_FILL2_SHIFT))

#define  XYSCALE_CFR1_RESERVED2_MASK 0xff00
#define  XYSCALE_CFR1_RESERVED2_SHIFT 8
#define  XYSCALE_CFR1_RESERVED2_MASK_SHIFT(reg) (((reg) & XYSCALE_CFR1_RESERVED2_MASK) >> XYSCALE_CFR1_RESERVED2_SHIFT)
#define  XYSCALE_CFR1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~XYSCALE_CFR1_RESERVED2_MASK) | (((uint32_t)val) << XYSCALE_CFR1_RESERVED2_SHIFT))

#define  XYSCALE_CFR1_FILL1_MASK 0xff
#define  XYSCALE_CFR1_FILL1_SHIFT 0
#define  XYSCALE_CFR1_FILL1_MASK_SHIFT(reg) (((reg) & XYSCALE_CFR1_FILL1_MASK) >> XYSCALE_CFR1_FILL1_SHIFT)
#define  XYSCALE_CFR1_FILL1_REPLACE_VAL(reg,val) (((reg) & ~XYSCALE_CFR1_FILL1_MASK) | (((uint32_t)val) << XYSCALE_CFR1_FILL1_SHIFT))

//====================================================================
//Register: Color 0 Fill Data Register (CFR2)
//====================================================================

#define  XYSCALE_CFR2_RESERVED1_MASK 0xffffff00
#define  XYSCALE_CFR2_RESERVED1_SHIFT 8
#define  XYSCALE_CFR2_RESERVED1_MASK_SHIFT(reg) (((reg) & XYSCALE_CFR2_RESERVED1_MASK) >> XYSCALE_CFR2_RESERVED1_SHIFT)
#define  XYSCALE_CFR2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~XYSCALE_CFR2_RESERVED1_MASK) | (((uint32_t)val) << XYSCALE_CFR2_RESERVED1_SHIFT))

#define  XYSCALE_CFR2_FILL0_MASK 0xff
#define  XYSCALE_CFR2_FILL0_SHIFT 0
#define  XYSCALE_CFR2_FILL0_MASK_SHIFT(reg) (((reg) & XYSCALE_CFR2_FILL0_MASK) >> XYSCALE_CFR2_FILL0_SHIFT)
#define  XYSCALE_CFR2_FILL0_REPLACE_VAL(reg,val) (((reg) & ~XYSCALE_CFR2_FILL0_MASK) | (((uint32_t)val) << XYSCALE_CFR2_FILL0_SHIFT))

//====================================================================
//Register: Horizontal Scale Register (HSR)
/** \brief Scale factor x-direction
      The following table is for reference, loading the scale, transpose and edge count.
      Previous versions of this block also included (X and Y scale - normal) values. This version
      includes these registers for backward firmware compatibility but no longer uses them.
      New firmware driver no longer needs to set the (scale - normal) values.
      <table>
      <th>Hex Program Values</th><th>Mode:</th><th>Running Average Pixel Replication Mode</th><th colspan=4>Bi-Linear Mode</th></tr>
      <tr><td> </td><td>Register:</td><td>(scaleX/Y)</td><td>(scaleX/Y)</td><td>(scaleX/Y)</td><td>(scaleX/YsubN)</td><td>(transposeX/Y)</td></tr>
      <tr><td> </td><td>Bits:</td><td>S: Scale Factor</td><td>S: Scale Factor</td><td>E: Edge pixel count</td><td>S: Scale Factor minus Normal</td><td>Dx/Dy: x/y-direction Delta Initial Value</td></tr>
      <tr><td>Scale</td><td>Percentage</td><td>Hex value</td><td>Hex value</td><td>Hex value</td><td>Hex value</td><td>Hex value</td></tr>
      <tr><td>1x</td><td>100%</td><td>1_0000h</td><td>1_0000h</td><td>0h</td><td>0_0000h</td><td>0_0000h</td></tr>
      <tr><td> </td><td>100.00153%</td><td>1_0001h</td><td>0_FFFFh</td><td>1h</td><td>F_FFFFh</td><td>0_FFFEh</td></tr>
      <tr><td>1.01x</td><td>101%</td><td>1_028Fh</td><td>0_FD77h</td><td>1h</td><td>F_FD77h</td><td>0_FC32h</td></tr>
      <tr><td>1.5x</td><td>150%</td><td>1_8000h</td><td>0_AAAAh</td><td>1h</td><td>F_AAAAh</td><td>0_7FFFh</td></tr>
      <tr><td>2x</td><td>200%</td><td>2_0000h</td><td>0_8000h</td><td>1h</td><td>F_8000h</td><td>0_4000h</td></tr>
      <tr><td>3x</td><td>300%</td><td>3_0000h</td><td>0_5555h</td><td>1h</td><td>F_5555h</td><td>0_0000h</td></tr>
      <tr><td>4x</td><td>400%</td><td>4_0000h</td><td>0_4000h</td><td>2h</td><td>F_4000h</td><td>0_2000h</td></tr>
      <tr><td></td><td>99%</td><td>0_FD70h</td><td>1_0295h</td><td>0h</td><td>0_0295</td><td>0_0014h</td></tr>
      <tr><td></td><td>99.99847%</td><td>0_FFFFh</td><td>1_0001h</td><td>0h</td><td>0_0001h</td><td>0_0000h</td></tr>
      <tr><td>.75x</td><td></td><td>0_C000h</td><td>1_5555h</td><td>0h</td><td>0_5555h</td><td>0_2AAAh</td></tr>
      <tr><td>.5x</td><td>50%</td><td>0_8000h</td><td>2_0000h</td><td>0h</td><td>1_0000h</td><td>0_8000h</td></tr>
      <tr><td>.25x</td><td>25%</td><td>0_4000h</td><td>N/A</td><td>N/A</td><td>N/A</td><td>N/A</td></tr>
      </table>
      <p>Once written, this register will stick through all subsequent strips until changed.
      The edge pixel count is ignored if in Average Pixel Replication mode. The edge pixel count
      is reloaded internally for the first column of each new row. An internal countdown commences
      to zero before the scale gets underway. The pixels are padded with the first input pixel of
      each row.</p>*/
//====================================================================

#define  XYSCALE_HSR_RESERVED1_MASK 0xf0000000
#define  XYSCALE_HSR_RESERVED1_SHIFT 28
#define  XYSCALE_HSR_RESERVED1_MASK_SHIFT(reg) (((reg) & XYSCALE_HSR_RESERVED1_MASK) >> XYSCALE_HSR_RESERVED1_SHIFT)
#define  XYSCALE_HSR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~XYSCALE_HSR_RESERVED1_MASK) | (((uint32_t)val) << XYSCALE_HSR_RESERVED1_SHIFT))

#define  XYSCALE_HSR_E_MASK 0xf000000
#define  XYSCALE_HSR_E_SHIFT 24
#define  XYSCALE_HSR_E_MASK_SHIFT(reg) (((reg) & XYSCALE_HSR_E_MASK) >> XYSCALE_HSR_E_SHIFT)
#define  XYSCALE_HSR_E_REPLACE_VAL(reg,val) (((reg) & ~XYSCALE_HSR_E_MASK) | (((uint32_t)val) << XYSCALE_HSR_E_SHIFT))

#define  XYSCALE_HSR_RESERVED2_MASK 0xf00000
#define  XYSCALE_HSR_RESERVED2_SHIFT 20
#define  XYSCALE_HSR_RESERVED2_MASK_SHIFT(reg) (((reg) & XYSCALE_HSR_RESERVED2_MASK) >> XYSCALE_HSR_RESERVED2_SHIFT)
#define  XYSCALE_HSR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~XYSCALE_HSR_RESERVED2_MASK) | (((uint32_t)val) << XYSCALE_HSR_RESERVED2_SHIFT))

#define  XYSCALE_HSR_S_MASK 0xfffff
#define  XYSCALE_HSR_S_SHIFT 0
#define  XYSCALE_HSR_S_MASK_SHIFT(reg) (((reg) & XYSCALE_HSR_S_MASK) >> XYSCALE_HSR_S_SHIFT)
#define  XYSCALE_HSR_S_REPLACE_VAL(reg,val) (((reg) & ~XYSCALE_HSR_S_MASK) | (((uint32_t)val) << XYSCALE_HSR_S_SHIFT))

//====================================================================
//Register: Vertical Scale Register (VSR)
/** \brief Vertical Scale does not implement the Edge Pixel Pad Option. Instead firmware is required
      to pad the top and bottom of page with extra bits when enlarging an image. The reason for
      any padding is that the bi-linear scale when enlarging will have its output transpose grid
      overlapping the input grid, such that the overlapping output pixels can only reference one
      input pixel and a slope cannot be determined.*/
//====================================================================

#define  XYSCALE_VSR_RESERVED1_MASK 0xfff00000
#define  XYSCALE_VSR_RESERVED1_SHIFT 20
#define  XYSCALE_VSR_RESERVED1_MASK_SHIFT(reg) (((reg) & XYSCALE_VSR_RESERVED1_MASK) >> XYSCALE_VSR_RESERVED1_SHIFT)
#define  XYSCALE_VSR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~XYSCALE_VSR_RESERVED1_MASK) | (((uint32_t)val) << XYSCALE_VSR_RESERVED1_SHIFT))

#define  XYSCALE_VSR_S_MASK 0xfffff
#define  XYSCALE_VSR_S_SHIFT 0
#define  XYSCALE_VSR_S_MASK_SHIFT(reg) (((reg) & XYSCALE_VSR_S_MASK) >> XYSCALE_VSR_S_SHIFT)
#define  XYSCALE_VSR_S_REPLACE_VAL(reg,val) (((reg) & ~XYSCALE_VSR_S_MASK) | (((uint32_t)val) << XYSCALE_VSR_S_SHIFT))

//====================================================================
//Register: Horizontal Scale Minus Normal Register (HSMR)
/** \brief This register is included for backward compatibility but is not used in this version
      of the XYScale module.</p>
      Scale factor x-direction minus the Normal. Only required for linear mode operation.*/
//====================================================================

#define  XYSCALE_HSMR_RESERVED1_MASK 0xfff00000
#define  XYSCALE_HSMR_RESERVED1_SHIFT 20
#define  XYSCALE_HSMR_RESERVED1_MASK_SHIFT(reg) (((reg) & XYSCALE_HSMR_RESERVED1_MASK) >> XYSCALE_HSMR_RESERVED1_SHIFT)
#define  XYSCALE_HSMR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~XYSCALE_HSMR_RESERVED1_MASK) | (((uint32_t)val) << XYSCALE_HSMR_RESERVED1_SHIFT))

#define  XYSCALE_HSMR_S_MASK 0xfffff
#define  XYSCALE_HSMR_S_SHIFT 0
#define  XYSCALE_HSMR_S_MASK_SHIFT(reg) (((reg) & XYSCALE_HSMR_S_MASK) >> XYSCALE_HSMR_S_SHIFT)
#define  XYSCALE_HSMR_S_REPLACE_VAL(reg,val) (((reg) & ~XYSCALE_HSMR_S_MASK) | (((uint32_t)val) << XYSCALE_HSMR_S_SHIFT))

//====================================================================
//Register: Vertical Scale Minus Normal Register (VSMR)
/** \brief This register is included for backward compatibility but is not used in this version
      of the XYScale module.</p>
      Scale factor y-direction minus the Normal. Only required for linear mode operation.*/
//====================================================================

#define  XYSCALE_VSMR_RESERVED1_MASK 0xfff00000
#define  XYSCALE_VSMR_RESERVED1_SHIFT 20
#define  XYSCALE_VSMR_RESERVED1_MASK_SHIFT(reg) (((reg) & XYSCALE_VSMR_RESERVED1_MASK) >> XYSCALE_VSMR_RESERVED1_SHIFT)
#define  XYSCALE_VSMR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~XYSCALE_VSMR_RESERVED1_MASK) | (((uint32_t)val) << XYSCALE_VSMR_RESERVED1_SHIFT))

#define  XYSCALE_VSMR_S_MASK 0xfffff
#define  XYSCALE_VSMR_S_SHIFT 0
#define  XYSCALE_VSMR_S_MASK_SHIFT(reg) (((reg) & XYSCALE_VSMR_S_MASK) >> XYSCALE_VSMR_S_SHIFT)
#define  XYSCALE_VSMR_S_REPLACE_VAL(reg,val) (((reg) & ~XYSCALE_VSMR_S_MASK) | (((uint32_t)val) << XYSCALE_VSMR_S_SHIFT))

//====================================================================
//Register: X-Transpose Configuration Register (XTR)
/** \brief This register in conjunction with the Horizontal Scale register stores configuration
      information beyond scale factors that the X-Y Scale block uses. The Dx calculation
      requires values from the Horizontal Scale register, which should be calculated first.
      Within the block, the Dx value is automatically re-loaded at the beginning of
      each line.*/
//====================================================================

#define  XYSCALE_XTR_RESERVED1_MASK 0xfff00000
#define  XYSCALE_XTR_RESERVED1_SHIFT 20
#define  XYSCALE_XTR_RESERVED1_MASK_SHIFT(reg) (((reg) & XYSCALE_XTR_RESERVED1_MASK) >> XYSCALE_XTR_RESERVED1_SHIFT)
#define  XYSCALE_XTR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~XYSCALE_XTR_RESERVED1_MASK) | (((uint32_t)val) << XYSCALE_XTR_RESERVED1_SHIFT))

#define  XYSCALE_XTR_DX_MASK 0xfffff
#define  XYSCALE_XTR_DX_SHIFT 0
#define  XYSCALE_XTR_DX_MASK_SHIFT(reg) (((reg) & XYSCALE_XTR_DX_MASK) >> XYSCALE_XTR_DX_SHIFT)
#define  XYSCALE_XTR_DX_REPLACE_VAL(reg,val) (((reg) & ~XYSCALE_XTR_DX_MASK) | (((uint32_t)val) << XYSCALE_XTR_DX_SHIFT))

//====================================================================
//Register: Y-Transpose Configuration Register (YTR)
/** \brief In linear mode, this register in conjunction with the Vertical Scale register
      stores configuration information beyond scale factors that the X-Y Scale block uses.
      Calculation of Dy requires values from the Vertical Scale register which should be
      calculated first. The Vertical Edge Pixel Count is determined as if it were being
      used. In actuality, FW is padding the top & bottom of strips. Typically, Dy
      is loaded only once for top of page. The transpose in the vertical direction is
      maintained by the Current Y-Start register. The value from the Current Y-Start
      register can be saved when stopping the current image. This register can then
      be initialized to start an alternate image. When returning to the original image
      the value that was saved from the Current Y-Start register should be re-written into
      this register before re-starting the image on the next strip.*/
//====================================================================

#define  XYSCALE_YTR_RESERVED1_MASK 0xfff00000
#define  XYSCALE_YTR_RESERVED1_SHIFT 20
#define  XYSCALE_YTR_RESERVED1_MASK_SHIFT(reg) (((reg) & XYSCALE_YTR_RESERVED1_MASK) >> XYSCALE_YTR_RESERVED1_SHIFT)
#define  XYSCALE_YTR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~XYSCALE_YTR_RESERVED1_MASK) | (((uint32_t)val) << XYSCALE_YTR_RESERVED1_SHIFT))

#define  XYSCALE_YTR_DY_MASK 0xfffff
#define  XYSCALE_YTR_DY_SHIFT 0
#define  XYSCALE_YTR_DY_MASK_SHIFT(reg) (((reg) & XYSCALE_YTR_DY_MASK) >> XYSCALE_YTR_DY_SHIFT)
#define  XYSCALE_YTR_DY_REPLACE_VAL(reg,val) (((reg) & ~XYSCALE_YTR_DY_MASK) | (((uint32_t)val) << XYSCALE_YTR_DY_SHIFT))

//====================================================================
//Register: Current X-Start Register (CXR)
/** \brief This register allows read access of the current internal start Dx register. The initial
      value comes from the X-Transpose Register and can be read back as such during page
      initialization.*/
//====================================================================

#define  XYSCALE_CXR_RESERVED1_MASK 0xfff00000
#define  XYSCALE_CXR_RESERVED1_SHIFT 20
#define  XYSCALE_CXR_RESERVED1_MASK_SHIFT(reg) (((reg) & XYSCALE_CXR_RESERVED1_MASK) >> XYSCALE_CXR_RESERVED1_SHIFT)
#define  XYSCALE_CXR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~XYSCALE_CXR_RESERVED1_MASK) | (((uint32_t)val) << XYSCALE_CXR_RESERVED1_SHIFT))

#define  XYSCALE_CXR_DX_MASK 0xfffff
#define  XYSCALE_CXR_DX_SHIFT 0
#define  XYSCALE_CXR_DX_MASK_SHIFT(reg) (((reg) & XYSCALE_CXR_DX_MASK) >> XYSCALE_CXR_DX_SHIFT)
#define  XYSCALE_CXR_DX_REPLACE_VAL(reg,val) (((reg) & ~XYSCALE_CXR_DX_MASK) | (((uint32_t)val) << XYSCALE_CXR_DX_SHIFT))

//====================================================================
//Register: Current Y Transpose Register (CYR)
/** \brief In linear mode, this register allows read access of the current internal Dy register. The
      initial value comes from the Y-Transpose Register and can be read back as such during page
      initialization. When switching between images, the value of this register should be read and
      saved before starting the other image, and then the saved value should be written to the
      Y-Transpose Register before resuming the original image.*/
//====================================================================

#define  XYSCALE_CYR_RESERVED1_MASK 0xfff00000
#define  XYSCALE_CYR_RESERVED1_SHIFT 20
#define  XYSCALE_CYR_RESERVED1_MASK_SHIFT(reg) (((reg) & XYSCALE_CYR_RESERVED1_MASK) >> XYSCALE_CYR_RESERVED1_SHIFT)
#define  XYSCALE_CYR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~XYSCALE_CYR_RESERVED1_MASK) | (((uint32_t)val) << XYSCALE_CYR_RESERVED1_SHIFT))

#define  XYSCALE_CYR_DY_MASK 0xfffff
#define  XYSCALE_CYR_DY_SHIFT 0
#define  XYSCALE_CYR_DY_MASK_SHIFT(reg) (((reg) & XYSCALE_CYR_DY_MASK) >> XYSCALE_CYR_DY_SHIFT)
#define  XYSCALE_CYR_DY_REPLACE_VAL(reg,val) (((reg) & ~XYSCALE_CYR_DY_MASK) | (((uint32_t)val) << XYSCALE_CYR_DY_SHIFT))

//====================================================================
//Register: Vertical Start Percentage (VSPR)
/** \brief For RAPR mode, at the beginning of an image this register should be initialized to the
      normal or 2^16 (10000h). When switching between images, the value from the VCPR should be
      saved off before starting the new image. When retuning to the original image the saved value
      should be written back into this register.*/
//====================================================================

#define  XYSCALE_VSPR_RESERVED1_MASK 0xfff00000
#define  XYSCALE_VSPR_RESERVED1_SHIFT 20
#define  XYSCALE_VSPR_RESERVED1_MASK_SHIFT(reg) (((reg) & XYSCALE_VSPR_RESERVED1_MASK) >> XYSCALE_VSPR_RESERVED1_SHIFT)
#define  XYSCALE_VSPR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~XYSCALE_VSPR_RESERVED1_MASK) | (((uint32_t)val) << XYSCALE_VSPR_RESERVED1_SHIFT))

#define  XYSCALE_VSPR_P_MASK 0xfffff
#define  XYSCALE_VSPR_P_SHIFT 0
#define  XYSCALE_VSPR_P_MASK_SHIFT(reg) (((reg) & XYSCALE_VSPR_P_MASK) >> XYSCALE_VSPR_P_SHIFT)
#define  XYSCALE_VSPR_P_REPLACE_VAL(reg,val) (((reg) & ~XYSCALE_VSPR_P_MASK) | (((uint32_t)val) << XYSCALE_VSPR_P_SHIFT))

//====================================================================
//Register: Horizontal Current/End Percentage Register (HCPR)
/** \brief In RAPR mode, the first column of each strip starts with a percentage of the normal or 2^16
      (1000h), and has a running percentage as the X-Y Scale traverses horizontally. This register
      allows looking at the current (or ending) percentage. The normal is re-loaded once the column
      count has been met. This is for debug purposes only.*/
//====================================================================

#define  XYSCALE_HCPR_RESERVED1_MASK 0xfff00000
#define  XYSCALE_HCPR_RESERVED1_SHIFT 20
#define  XYSCALE_HCPR_RESERVED1_MASK_SHIFT(reg) (((reg) & XYSCALE_HCPR_RESERVED1_MASK) >> XYSCALE_HCPR_RESERVED1_SHIFT)
#define  XYSCALE_HCPR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~XYSCALE_HCPR_RESERVED1_MASK) | (((uint32_t)val) << XYSCALE_HCPR_RESERVED1_SHIFT))

#define  XYSCALE_HCPR_P_MASK 0xfffff
#define  XYSCALE_HCPR_P_SHIFT 0
#define  XYSCALE_HCPR_P_MASK_SHIFT(reg) (((reg) & XYSCALE_HCPR_P_MASK) >> XYSCALE_HCPR_P_SHIFT)
#define  XYSCALE_HCPR_P_REPLACE_VAL(reg,val) (((reg) & ~XYSCALE_HCPR_P_MASK) | (((uint32_t)val) << XYSCALE_HCPR_P_SHIFT))

//====================================================================
//Register: Vertical Current/End Percentage Register (VCPR)
/** \brief In RAPR mode, this register tracks the vertical percentage while traversing pixels in a
      column. This register is read only, and may be used to save off the current percentage at
      the end of a strip before switching to a different image. This saved-off value can then be
      written into the VSPR register when re-starting the original image.*/
//====================================================================

#define  XYSCALE_VCPR_RESERVED1_MASK 0xfff00000
#define  XYSCALE_VCPR_RESERVED1_SHIFT 20
#define  XYSCALE_VCPR_RESERVED1_MASK_SHIFT(reg) (((reg) & XYSCALE_VCPR_RESERVED1_MASK) >> XYSCALE_VCPR_RESERVED1_SHIFT)
#define  XYSCALE_VCPR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~XYSCALE_VCPR_RESERVED1_MASK) | (((uint32_t)val) << XYSCALE_VCPR_RESERVED1_SHIFT))

#define  XYSCALE_VCPR_P_MASK 0xfffff
#define  XYSCALE_VCPR_P_SHIFT 0
#define  XYSCALE_VCPR_P_MASK_SHIFT(reg) (((reg) & XYSCALE_VCPR_P_MASK) >> XYSCALE_VCPR_P_SHIFT)
#define  XYSCALE_VCPR_P_REPLACE_VAL(reg,val) (((reg) & ~XYSCALE_VCPR_P_MASK) | (((uint32_t)val) << XYSCALE_VCPR_P_SHIFT))

//====================================================================
//Register: Observation Register (XOR)
/** \brief This register is included for backward compatibility but is not used in this version
      of the XYScale module. Fields are no longer valid and all reads will return 0</p>
      This read only register is for observation of certain XYScale internals.*/
//====================================================================

#define  XYSCALE_XOR_RESERVED1_MASK 0xffffffff
#define  XYSCALE_XOR_RESERVED1_SHIFT 0
#define  XYSCALE_XOR_RESERVED1_MASK_SHIFT(reg) (((reg) & XYSCALE_XOR_RESERVED1_MASK) >> XYSCALE_XOR_RESERVED1_SHIFT)
#define  XYSCALE_XOR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~XYSCALE_XOR_RESERVED1_MASK) | (((uint32_t)val) << XYSCALE_XOR_RESERVED1_SHIFT))

//====================================================================
//Register: IP Tagging Revision 0 (REV0)
/** \brief Provide means for firmware to read IP tagging information.
      This register of particular interest to firmware.*/
//====================================================================

#define  XYSCALE_REV0_MAJ_MASK 0xffff0000
#define  XYSCALE_REV0_MAJ_SHIFT 16
#define  XYSCALE_REV0_MAJ_MASK_SHIFT(reg) (((reg) & XYSCALE_REV0_MAJ_MASK) >> XYSCALE_REV0_MAJ_SHIFT)
#define  XYSCALE_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~XYSCALE_REV0_MAJ_MASK) | (((uint32_t)val) << XYSCALE_REV0_MAJ_SHIFT))

#define  XYSCALE_REV0_MID_MASK 0xffff
#define  XYSCALE_REV0_MID_SHIFT 0
#define  XYSCALE_REV0_MID_MASK_SHIFT(reg) (((reg) & XYSCALE_REV0_MID_MASK) >> XYSCALE_REV0_MID_SHIFT)
#define  XYSCALE_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~XYSCALE_REV0_MID_MASK) | (((uint32_t)val) << XYSCALE_REV0_MID_SHIFT))

//====================================================================
//Register: IP Tagging Revision 1 (REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  XYSCALE_REV1_RESERVED1_MASK 0xffff0000
#define  XYSCALE_REV1_RESERVED1_SHIFT 16
#define  XYSCALE_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & XYSCALE_REV1_RESERVED1_MASK) >> XYSCALE_REV1_RESERVED1_SHIFT)
#define  XYSCALE_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~XYSCALE_REV1_RESERVED1_MASK) | (((uint32_t)val) << XYSCALE_REV1_RESERVED1_SHIFT))

#define  XYSCALE_REV1_CFG_MASK 0xffff
#define  XYSCALE_REV1_CFG_SHIFT 0
#define  XYSCALE_REV1_CFG_MASK_SHIFT(reg) (((reg) & XYSCALE_REV1_CFG_MASK) >> XYSCALE_REV1_CFG_SHIFT)
#define  XYSCALE_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~XYSCALE_REV1_CFG_MASK) | (((uint32_t)val) << XYSCALE_REV1_CFG_SHIFT))

//====================================================================
//
//Register File: PIE Clip and Pad (CLIPPAD)
/** \brief Top-level register file for the Clip Pad block*/
//
//====================================================================

//====================================================================
//Register: CLIPPAD Configuration Register (Cfg)
/** \brief This register configures the major features of the CLIPPAD module*/
//====================================================================

#define  CLIPPAD_CFG_RESERVED1_MASK 0xfffffe00
#define  CLIPPAD_CFG_RESERVED1_SHIFT 9
#define  CLIPPAD_CFG_RESERVED1_MASK_SHIFT(reg) (((reg) & CLIPPAD_CFG_RESERVED1_MASK) >> CLIPPAD_CFG_RESERVED1_SHIFT)
#define  CLIPPAD_CFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CLIPPAD_CFG_RESERVED1_MASK) | (((uint32_t)val) << CLIPPAD_CFG_RESERVED1_SHIFT))

#define  CLIPPAD_CFG_PIXORDER_MASK 0x100
#define  CLIPPAD_CFG_PIXORDER_SHIFT 8
#define  CLIPPAD_CFG_PIXORDER_MASK_SHIFT(reg) (((reg) & CLIPPAD_CFG_PIXORDER_MASK) >> CLIPPAD_CFG_PIXORDER_SHIFT)
#define  CLIPPAD_CFG_PIXORDER_REPLACE_VAL(reg,val) (((reg) & ~CLIPPAD_CFG_PIXORDER_MASK) | (((uint32_t)val) << CLIPPAD_CFG_PIXORDER_SHIFT))

#define  CLIPPAD_CFG_RESERVED2_MASK 0xe0
#define  CLIPPAD_CFG_RESERVED2_SHIFT 5
#define  CLIPPAD_CFG_RESERVED2_MASK_SHIFT(reg) (((reg) & CLIPPAD_CFG_RESERVED2_MASK) >> CLIPPAD_CFG_RESERVED2_SHIFT)
#define  CLIPPAD_CFG_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~CLIPPAD_CFG_RESERVED2_MASK) | (((uint32_t)val) << CLIPPAD_CFG_RESERVED2_SHIFT))

#define  CLIPPAD_CFG_NIBBLESEL_MASK 0x10
#define  CLIPPAD_CFG_NIBBLESEL_SHIFT 4
#define  CLIPPAD_CFG_NIBBLESEL_MASK_SHIFT(reg) (((reg) & CLIPPAD_CFG_NIBBLESEL_MASK) >> CLIPPAD_CFG_NIBBLESEL_SHIFT)
#define  CLIPPAD_CFG_NIBBLESEL_REPLACE_VAL(reg,val) (((reg) & ~CLIPPAD_CFG_NIBBLESEL_MASK) | (((uint32_t)val) << CLIPPAD_CFG_NIBBLESEL_SHIFT))

#define  CLIPPAD_CFG_RESERVED3_MASK 0x8
#define  CLIPPAD_CFG_RESERVED3_SHIFT 3
#define  CLIPPAD_CFG_RESERVED3_MASK_SHIFT(reg) (((reg) & CLIPPAD_CFG_RESERVED3_MASK) >> CLIPPAD_CFG_RESERVED3_SHIFT)
#define  CLIPPAD_CFG_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~CLIPPAD_CFG_RESERVED3_MASK) | (((uint32_t)val) << CLIPPAD_CFG_RESERVED3_SHIFT))

#define  CLIPPAD_CFG_BPP_MASK 0x6
#define  CLIPPAD_CFG_BPP_SHIFT 1
#define  CLIPPAD_CFG_BPP_MASK_SHIFT(reg) (((reg) & CLIPPAD_CFG_BPP_MASK) >> CLIPPAD_CFG_BPP_SHIFT)
#define  CLIPPAD_CFG_BPP_REPLACE_VAL(reg,val) (((reg) & ~CLIPPAD_CFG_BPP_MASK) | (((uint32_t)val) << CLIPPAD_CFG_BPP_SHIFT))

#define  CLIPPAD_CFG_BYPASS_MASK 0x1
#define  CLIPPAD_CFG_BYPASS_SHIFT 0
#define  CLIPPAD_CFG_BYPASS_MASK_SHIFT(reg) (((reg) & CLIPPAD_CFG_BYPASS_MASK) >> CLIPPAD_CFG_BYPASS_SHIFT)
#define  CLIPPAD_CFG_BYPASS_REPLACE_VAL(reg,val) (((reg) & ~CLIPPAD_CFG_BYPASS_MASK) | (((uint32_t)val) << CLIPPAD_CFG_BYPASS_SHIFT))

//====================================================================
//Register: Left Side Padding Register (LPad)
/** \brief This register configures left side padding.*/
//====================================================================

#define  CLIPPAD_LPAD_RESERVED1_MASK 0xfffe0000
#define  CLIPPAD_LPAD_RESERVED1_SHIFT 17
#define  CLIPPAD_LPAD_RESERVED1_MASK_SHIFT(reg) (((reg) & CLIPPAD_LPAD_RESERVED1_MASK) >> CLIPPAD_LPAD_RESERVED1_SHIFT)
#define  CLIPPAD_LPAD_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CLIPPAD_LPAD_RESERVED1_MASK) | (((uint32_t)val) << CLIPPAD_LPAD_RESERVED1_SHIFT))

#define  CLIPPAD_LPAD_LEFTEDGEFILL_MASK 0x10000
#define  CLIPPAD_LPAD_LEFTEDGEFILL_SHIFT 16
#define  CLIPPAD_LPAD_LEFTEDGEFILL_MASK_SHIFT(reg) (((reg) & CLIPPAD_LPAD_LEFTEDGEFILL_MASK) >> CLIPPAD_LPAD_LEFTEDGEFILL_SHIFT)
#define  CLIPPAD_LPAD_LEFTEDGEFILL_REPLACE_VAL(reg,val) (((reg) & ~CLIPPAD_LPAD_LEFTEDGEFILL_MASK) | (((uint32_t)val) << CLIPPAD_LPAD_LEFTEDGEFILL_SHIFT))

#define  CLIPPAD_LPAD_LEFTLEN_MASK 0xffff
#define  CLIPPAD_LPAD_LEFTLEN_SHIFT 0
#define  CLIPPAD_LPAD_LEFTLEN_MASK_SHIFT(reg) (((reg) & CLIPPAD_LPAD_LEFTLEN_MASK) >> CLIPPAD_LPAD_LEFTLEN_SHIFT)
#define  CLIPPAD_LPAD_LEFTLEN_REPLACE_VAL(reg,val) (((reg) & ~CLIPPAD_LPAD_LEFTLEN_MASK) | (((uint32_t)val) << CLIPPAD_LPAD_LEFTLEN_SHIFT))

//====================================================================
//Register: Right Side Padding Register (RPad)
/** \brief This register configures right side padding.*/
//====================================================================

#define  CLIPPAD_RPAD_RESERVED1_MASK 0xfffe0000
#define  CLIPPAD_RPAD_RESERVED1_SHIFT 17
#define  CLIPPAD_RPAD_RESERVED1_MASK_SHIFT(reg) (((reg) & CLIPPAD_RPAD_RESERVED1_MASK) >> CLIPPAD_RPAD_RESERVED1_SHIFT)
#define  CLIPPAD_RPAD_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CLIPPAD_RPAD_RESERVED1_MASK) | (((uint32_t)val) << CLIPPAD_RPAD_RESERVED1_SHIFT))

#define  CLIPPAD_RPAD_RIGHTEDGEFILL_MASK 0x10000
#define  CLIPPAD_RPAD_RIGHTEDGEFILL_SHIFT 16
#define  CLIPPAD_RPAD_RIGHTEDGEFILL_MASK_SHIFT(reg) (((reg) & CLIPPAD_RPAD_RIGHTEDGEFILL_MASK) >> CLIPPAD_RPAD_RIGHTEDGEFILL_SHIFT)
#define  CLIPPAD_RPAD_RIGHTEDGEFILL_REPLACE_VAL(reg,val) (((reg) & ~CLIPPAD_RPAD_RIGHTEDGEFILL_MASK) | (((uint32_t)val) << CLIPPAD_RPAD_RIGHTEDGEFILL_SHIFT))

#define  CLIPPAD_RPAD_RIGHTLEN_MASK 0xffff
#define  CLIPPAD_RPAD_RIGHTLEN_SHIFT 0
#define  CLIPPAD_RPAD_RIGHTLEN_MASK_SHIFT(reg) (((reg) & CLIPPAD_RPAD_RIGHTLEN_MASK) >> CLIPPAD_RPAD_RIGHTLEN_SHIFT)
#define  CLIPPAD_RPAD_RIGHTLEN_REPLACE_VAL(reg,val) (((reg) & ~CLIPPAD_RPAD_RIGHTLEN_MASK) | (((uint32_t)val) << CLIPPAD_RPAD_RIGHTLEN_SHIFT))

//====================================================================
//Register: Left Side Padding Value Register (Instance 1 of 4) (LVal0)
/** \brief This register contains the pad value for the left side if leftEdgeFill is not set.
      There is a unique register for every CBI input channel meaning. (Instance 1 of 4)*/
//====================================================================

#define  CLIPPAD_LVAL0_RESERVED1_MASK 0xffffff00
#define  CLIPPAD_LVAL0_RESERVED1_SHIFT 8
#define  CLIPPAD_LVAL0_RESERVED1_MASK_SHIFT(reg) (((reg) & CLIPPAD_LVAL0_RESERVED1_MASK) >> CLIPPAD_LVAL0_RESERVED1_SHIFT)
#define  CLIPPAD_LVAL0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CLIPPAD_LVAL0_RESERVED1_MASK) | (((uint32_t)val) << CLIPPAD_LVAL0_RESERVED1_SHIFT))

#define  CLIPPAD_LVAL0_LEFTVAL_MASK 0xff
#define  CLIPPAD_LVAL0_LEFTVAL_SHIFT 0
#define  CLIPPAD_LVAL0_LEFTVAL_MASK_SHIFT(reg) (((reg) & CLIPPAD_LVAL0_LEFTVAL_MASK) >> CLIPPAD_LVAL0_LEFTVAL_SHIFT)
#define  CLIPPAD_LVAL0_LEFTVAL_REPLACE_VAL(reg,val) (((reg) & ~CLIPPAD_LVAL0_LEFTVAL_MASK) | (((uint32_t)val) << CLIPPAD_LVAL0_LEFTVAL_SHIFT))

//====================================================================
//Register: Left Side Padding Value Register (Instance 2 of 4) (LVal1)
/** \brief This register contains the pad value for the left side if leftEdgeFill is not set.
      There is a unique register for every CBI input channel meaning. (Instance 2 of 4)*/
//====================================================================

#define  CLIPPAD_LVAL1_RESERVED1_MASK 0xffffff00
#define  CLIPPAD_LVAL1_RESERVED1_SHIFT 8
#define  CLIPPAD_LVAL1_RESERVED1_MASK_SHIFT(reg) (((reg) & CLIPPAD_LVAL1_RESERVED1_MASK) >> CLIPPAD_LVAL1_RESERVED1_SHIFT)
#define  CLIPPAD_LVAL1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CLIPPAD_LVAL1_RESERVED1_MASK) | (((uint32_t)val) << CLIPPAD_LVAL1_RESERVED1_SHIFT))

#define  CLIPPAD_LVAL1_LEFTVAL_MASK 0xff
#define  CLIPPAD_LVAL1_LEFTVAL_SHIFT 0
#define  CLIPPAD_LVAL1_LEFTVAL_MASK_SHIFT(reg) (((reg) & CLIPPAD_LVAL1_LEFTVAL_MASK) >> CLIPPAD_LVAL1_LEFTVAL_SHIFT)
#define  CLIPPAD_LVAL1_LEFTVAL_REPLACE_VAL(reg,val) (((reg) & ~CLIPPAD_LVAL1_LEFTVAL_MASK) | (((uint32_t)val) << CLIPPAD_LVAL1_LEFTVAL_SHIFT))

//====================================================================
//Register: Left Side Padding Value Register (Instance 3 of 4) (LVal2)
/** \brief This register contains the pad value for the left side if leftEdgeFill is not set.
      There is a unique register for every CBI input channel meaning. (Instance 3 of 4)*/
//====================================================================

#define  CLIPPAD_LVAL2_RESERVED1_MASK 0xffffff00
#define  CLIPPAD_LVAL2_RESERVED1_SHIFT 8
#define  CLIPPAD_LVAL2_RESERVED1_MASK_SHIFT(reg) (((reg) & CLIPPAD_LVAL2_RESERVED1_MASK) >> CLIPPAD_LVAL2_RESERVED1_SHIFT)
#define  CLIPPAD_LVAL2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CLIPPAD_LVAL2_RESERVED1_MASK) | (((uint32_t)val) << CLIPPAD_LVAL2_RESERVED1_SHIFT))

#define  CLIPPAD_LVAL2_LEFTVAL_MASK 0xff
#define  CLIPPAD_LVAL2_LEFTVAL_SHIFT 0
#define  CLIPPAD_LVAL2_LEFTVAL_MASK_SHIFT(reg) (((reg) & CLIPPAD_LVAL2_LEFTVAL_MASK) >> CLIPPAD_LVAL2_LEFTVAL_SHIFT)
#define  CLIPPAD_LVAL2_LEFTVAL_REPLACE_VAL(reg,val) (((reg) & ~CLIPPAD_LVAL2_LEFTVAL_MASK) | (((uint32_t)val) << CLIPPAD_LVAL2_LEFTVAL_SHIFT))

//====================================================================
//Register: Left Side Padding Value Register (Instance 4 of 4) (LVal3)
/** \brief This register contains the pad value for the left side if leftEdgeFill is not set.
      There is a unique register for every CBI input channel meaning. (Instance 4 of 4)*/
//====================================================================

#define  CLIPPAD_LVAL3_RESERVED1_MASK 0xffffff00
#define  CLIPPAD_LVAL3_RESERVED1_SHIFT 8
#define  CLIPPAD_LVAL3_RESERVED1_MASK_SHIFT(reg) (((reg) & CLIPPAD_LVAL3_RESERVED1_MASK) >> CLIPPAD_LVAL3_RESERVED1_SHIFT)
#define  CLIPPAD_LVAL3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CLIPPAD_LVAL3_RESERVED1_MASK) | (((uint32_t)val) << CLIPPAD_LVAL3_RESERVED1_SHIFT))

#define  CLIPPAD_LVAL3_LEFTVAL_MASK 0xff
#define  CLIPPAD_LVAL3_LEFTVAL_SHIFT 0
#define  CLIPPAD_LVAL3_LEFTVAL_MASK_SHIFT(reg) (((reg) & CLIPPAD_LVAL3_LEFTVAL_MASK) >> CLIPPAD_LVAL3_LEFTVAL_SHIFT)
#define  CLIPPAD_LVAL3_LEFTVAL_REPLACE_VAL(reg,val) (((reg) & ~CLIPPAD_LVAL3_LEFTVAL_MASK) | (((uint32_t)val) << CLIPPAD_LVAL3_LEFTVAL_SHIFT))

//====================================================================
//Register: Right Side Padding Value Register (Instance 1 of 4) (RVal0)
/** \brief This register contains the pad value for the right side if rightEdgeFill is not set.
      There is a unique register for every CBI input channel meaning. (Instance 1 of 4)*/
//====================================================================

#define  CLIPPAD_RVAL0_RESERVED1_MASK 0xffffff00
#define  CLIPPAD_RVAL0_RESERVED1_SHIFT 8
#define  CLIPPAD_RVAL0_RESERVED1_MASK_SHIFT(reg) (((reg) & CLIPPAD_RVAL0_RESERVED1_MASK) >> CLIPPAD_RVAL0_RESERVED1_SHIFT)
#define  CLIPPAD_RVAL0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CLIPPAD_RVAL0_RESERVED1_MASK) | (((uint32_t)val) << CLIPPAD_RVAL0_RESERVED1_SHIFT))

#define  CLIPPAD_RVAL0_RIGHTVAL_MASK 0xff
#define  CLIPPAD_RVAL0_RIGHTVAL_SHIFT 0
#define  CLIPPAD_RVAL0_RIGHTVAL_MASK_SHIFT(reg) (((reg) & CLIPPAD_RVAL0_RIGHTVAL_MASK) >> CLIPPAD_RVAL0_RIGHTVAL_SHIFT)
#define  CLIPPAD_RVAL0_RIGHTVAL_REPLACE_VAL(reg,val) (((reg) & ~CLIPPAD_RVAL0_RIGHTVAL_MASK) | (((uint32_t)val) << CLIPPAD_RVAL0_RIGHTVAL_SHIFT))

//====================================================================
//Register: Right Side Padding Value Register (Instance 2 of 4) (RVal1)
/** \brief This register contains the pad value for the right side if rightEdgeFill is not set.
      There is a unique register for every CBI input channel meaning. (Instance 2 of 4)*/
//====================================================================

#define  CLIPPAD_RVAL1_RESERVED1_MASK 0xffffff00
#define  CLIPPAD_RVAL1_RESERVED1_SHIFT 8
#define  CLIPPAD_RVAL1_RESERVED1_MASK_SHIFT(reg) (((reg) & CLIPPAD_RVAL1_RESERVED1_MASK) >> CLIPPAD_RVAL1_RESERVED1_SHIFT)
#define  CLIPPAD_RVAL1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CLIPPAD_RVAL1_RESERVED1_MASK) | (((uint32_t)val) << CLIPPAD_RVAL1_RESERVED1_SHIFT))

#define  CLIPPAD_RVAL1_RIGHTVAL_MASK 0xff
#define  CLIPPAD_RVAL1_RIGHTVAL_SHIFT 0
#define  CLIPPAD_RVAL1_RIGHTVAL_MASK_SHIFT(reg) (((reg) & CLIPPAD_RVAL1_RIGHTVAL_MASK) >> CLIPPAD_RVAL1_RIGHTVAL_SHIFT)
#define  CLIPPAD_RVAL1_RIGHTVAL_REPLACE_VAL(reg,val) (((reg) & ~CLIPPAD_RVAL1_RIGHTVAL_MASK) | (((uint32_t)val) << CLIPPAD_RVAL1_RIGHTVAL_SHIFT))

//====================================================================
//Register: Right Side Padding Value Register (Instance 3 of 4) (RVal2)
/** \brief This register contains the pad value for the right side if rightEdgeFill is not set.
      There is a unique register for every CBI input channel meaning. (Instance 3 of 4)*/
//====================================================================

#define  CLIPPAD_RVAL2_RESERVED1_MASK 0xffffff00
#define  CLIPPAD_RVAL2_RESERVED1_SHIFT 8
#define  CLIPPAD_RVAL2_RESERVED1_MASK_SHIFT(reg) (((reg) & CLIPPAD_RVAL2_RESERVED1_MASK) >> CLIPPAD_RVAL2_RESERVED1_SHIFT)
#define  CLIPPAD_RVAL2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CLIPPAD_RVAL2_RESERVED1_MASK) | (((uint32_t)val) << CLIPPAD_RVAL2_RESERVED1_SHIFT))

#define  CLIPPAD_RVAL2_RIGHTVAL_MASK 0xff
#define  CLIPPAD_RVAL2_RIGHTVAL_SHIFT 0
#define  CLIPPAD_RVAL2_RIGHTVAL_MASK_SHIFT(reg) (((reg) & CLIPPAD_RVAL2_RIGHTVAL_MASK) >> CLIPPAD_RVAL2_RIGHTVAL_SHIFT)
#define  CLIPPAD_RVAL2_RIGHTVAL_REPLACE_VAL(reg,val) (((reg) & ~CLIPPAD_RVAL2_RIGHTVAL_MASK) | (((uint32_t)val) << CLIPPAD_RVAL2_RIGHTVAL_SHIFT))

//====================================================================
//Register: Right Side Padding Value Register (Instance 4 of 4) (RVal3)
/** \brief This register contains the pad value for the right side if rightEdgeFill is not set.
      There is a unique register for every CBI input channel meaning. (Instance 4 of 4)*/
//====================================================================

#define  CLIPPAD_RVAL3_RESERVED1_MASK 0xffffff00
#define  CLIPPAD_RVAL3_RESERVED1_SHIFT 8
#define  CLIPPAD_RVAL3_RESERVED1_MASK_SHIFT(reg) (((reg) & CLIPPAD_RVAL3_RESERVED1_MASK) >> CLIPPAD_RVAL3_RESERVED1_SHIFT)
#define  CLIPPAD_RVAL3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CLIPPAD_RVAL3_RESERVED1_MASK) | (((uint32_t)val) << CLIPPAD_RVAL3_RESERVED1_SHIFT))

#define  CLIPPAD_RVAL3_RIGHTVAL_MASK 0xff
#define  CLIPPAD_RVAL3_RIGHTVAL_SHIFT 0
#define  CLIPPAD_RVAL3_RIGHTVAL_MASK_SHIFT(reg) (((reg) & CLIPPAD_RVAL3_RIGHTVAL_MASK) >> CLIPPAD_RVAL3_RIGHTVAL_SHIFT)
#define  CLIPPAD_RVAL3_RIGHTVAL_REPLACE_VAL(reg,val) (((reg) & ~CLIPPAD_RVAL3_RIGHTVAL_MASK) | (((uint32_t)val) << CLIPPAD_RVAL3_RIGHTVAL_SHIFT))

//====================================================================
//Register: Left Side Truncation Boundary (LTrunc)
/** \brief This register is used to specify the left side truncation boundary. Specify the first
       column of the input image (zero-based) that should be included in the output. Note that if
       left side replicate padding is also specified, the specified column will be the one
       that is replicated on the left side of the image.*/
//====================================================================

#define  CLIPPAD_LTRUNC_RESERVED1_MASK 0xffff0000
#define  CLIPPAD_LTRUNC_RESERVED1_SHIFT 16
#define  CLIPPAD_LTRUNC_RESERVED1_MASK_SHIFT(reg) (((reg) & CLIPPAD_LTRUNC_RESERVED1_MASK) >> CLIPPAD_LTRUNC_RESERVED1_SHIFT)
#define  CLIPPAD_LTRUNC_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CLIPPAD_LTRUNC_RESERVED1_MASK) | (((uint32_t)val) << CLIPPAD_LTRUNC_RESERVED1_SHIFT))

#define  CLIPPAD_LTRUNC_FIRSTCOLUMN_MASK 0xffff
#define  CLIPPAD_LTRUNC_FIRSTCOLUMN_SHIFT 0
#define  CLIPPAD_LTRUNC_FIRSTCOLUMN_MASK_SHIFT(reg) (((reg) & CLIPPAD_LTRUNC_FIRSTCOLUMN_MASK) >> CLIPPAD_LTRUNC_FIRSTCOLUMN_SHIFT)
#define  CLIPPAD_LTRUNC_FIRSTCOLUMN_REPLACE_VAL(reg,val) (((reg) & ~CLIPPAD_LTRUNC_FIRSTCOLUMN_MASK) | (((uint32_t)val) << CLIPPAD_LTRUNC_FIRSTCOLUMN_SHIFT))

//====================================================================
//Register: Right Side Truncation Boundary (RTrunc)
/** \brief This register is used to specify the right side truncation boundary. Specify the last
      column of the input image that should be included in the output. Note that if
      right side replicate padding is also specified, the specified column will be the one
      that is replicated on the right side of the image.*/
//====================================================================

#define  CLIPPAD_RTRUNC_RESERVED1_MASK 0xffff0000
#define  CLIPPAD_RTRUNC_RESERVED1_SHIFT 16
#define  CLIPPAD_RTRUNC_RESERVED1_MASK_SHIFT(reg) (((reg) & CLIPPAD_RTRUNC_RESERVED1_MASK) >> CLIPPAD_RTRUNC_RESERVED1_SHIFT)
#define  CLIPPAD_RTRUNC_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CLIPPAD_RTRUNC_RESERVED1_MASK) | (((uint32_t)val) << CLIPPAD_RTRUNC_RESERVED1_SHIFT))

#define  CLIPPAD_RTRUNC_LASTCOLUMN_MASK 0xffff
#define  CLIPPAD_RTRUNC_LASTCOLUMN_SHIFT 0
#define  CLIPPAD_RTRUNC_LASTCOLUMN_MASK_SHIFT(reg) (((reg) & CLIPPAD_RTRUNC_LASTCOLUMN_MASK) >> CLIPPAD_RTRUNC_LASTCOLUMN_SHIFT)
#define  CLIPPAD_RTRUNC_LASTCOLUMN_REPLACE_VAL(reg,val) (((reg) & ~CLIPPAD_RTRUNC_LASTCOLUMN_MASK) | (((uint32_t)val) << CLIPPAD_RTRUNC_LASTCOLUMN_SHIFT))

//====================================================================
//Register: Line Width Register (LineWidth)
/** \brief This register contains the line width in pixels*/
//====================================================================

#define  CLIPPAD_LINEWIDTH_RESERVED1_MASK 0xffff0000
#define  CLIPPAD_LINEWIDTH_RESERVED1_SHIFT 16
#define  CLIPPAD_LINEWIDTH_RESERVED1_MASK_SHIFT(reg) (((reg) & CLIPPAD_LINEWIDTH_RESERVED1_MASK) >> CLIPPAD_LINEWIDTH_RESERVED1_SHIFT)
#define  CLIPPAD_LINEWIDTH_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CLIPPAD_LINEWIDTH_RESERVED1_MASK) | (((uint32_t)val) << CLIPPAD_LINEWIDTH_RESERVED1_SHIFT))

#define  CLIPPAD_LINEWIDTH_LINEWIDTH_MASK 0xffff
#define  CLIPPAD_LINEWIDTH_LINEWIDTH_SHIFT 0
#define  CLIPPAD_LINEWIDTH_LINEWIDTH_MASK_SHIFT(reg) (((reg) & CLIPPAD_LINEWIDTH_LINEWIDTH_MASK) >> CLIPPAD_LINEWIDTH_LINEWIDTH_SHIFT)
#define  CLIPPAD_LINEWIDTH_LINEWIDTH_REPLACE_VAL(reg,val) (((reg) & ~CLIPPAD_LINEWIDTH_LINEWIDTH_MASK) | (((uint32_t)val) << CLIPPAD_LINEWIDTH_LINEWIDTH_SHIFT))

//====================================================================
//Register: CLIPPAD Parameter Register (CLIPPADPR)
/** \brief Contains the parameter settings for this instantiation of CLIPPAD*/
//====================================================================

#define  CLIPPAD_CLIPPADPR_RESERVED1_MASK 0x80000000
#define  CLIPPAD_CLIPPADPR_RESERVED1_SHIFT 31
#define  CLIPPAD_CLIPPADPR_RESERVED1_MASK_SHIFT(reg) (((reg) & CLIPPAD_CLIPPADPR_RESERVED1_MASK) >> CLIPPAD_CLIPPADPR_RESERVED1_SHIFT)
#define  CLIPPAD_CLIPPADPR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CLIPPAD_CLIPPADPR_RESERVED1_MASK) | (((uint32_t)val) << CLIPPAD_CLIPPADPR_RESERVED1_SHIFT))

#define  CLIPPAD_CLIPPADPR_POGO_HEIGHT_MASK 0x7e000000
#define  CLIPPAD_CLIPPADPR_POGO_HEIGHT_SHIFT 25
#define  CLIPPAD_CLIPPADPR_POGO_HEIGHT_MASK_SHIFT(reg) (((reg) & CLIPPAD_CLIPPADPR_POGO_HEIGHT_MASK) >> CLIPPAD_CLIPPADPR_POGO_HEIGHT_SHIFT)
#define  CLIPPAD_CLIPPADPR_POGO_HEIGHT_REPLACE_VAL(reg,val) (((reg) & ~CLIPPAD_CLIPPADPR_POGO_HEIGHT_MASK) | (((uint32_t)val) << CLIPPAD_CLIPPADPR_POGO_HEIGHT_SHIFT))

#define  CLIPPAD_CLIPPADPR_POGO_MASK 0x1000000
#define  CLIPPAD_CLIPPADPR_POGO_SHIFT 24
#define  CLIPPAD_CLIPPADPR_POGO_MASK_SHIFT(reg) (((reg) & CLIPPAD_CLIPPADPR_POGO_MASK) >> CLIPPAD_CLIPPADPR_POGO_SHIFT)
#define  CLIPPAD_CLIPPADPR_POGO_REPLACE_VAL(reg,val) (((reg) & ~CLIPPAD_CLIPPADPR_POGO_MASK) | (((uint32_t)val) << CLIPPAD_CLIPPADPR_POGO_SHIFT))

#define  CLIPPAD_CLIPPADPR_SERP_MASK 0x800000
#define  CLIPPAD_CLIPPADPR_SERP_SHIFT 23
#define  CLIPPAD_CLIPPADPR_SERP_MASK_SHIFT(reg) (((reg) & CLIPPAD_CLIPPADPR_SERP_MASK) >> CLIPPAD_CLIPPADPR_SERP_SHIFT)
#define  CLIPPAD_CLIPPADPR_SERP_REPLACE_VAL(reg,val) (((reg) & ~CLIPPAD_CLIPPADPR_SERP_MASK) | (((uint32_t)val) << CLIPPAD_CLIPPADPR_SERP_SHIFT))

#define  CLIPPAD_CLIPPADPR_UNPACK_MASK 0x400000
#define  CLIPPAD_CLIPPADPR_UNPACK_SHIFT 22
#define  CLIPPAD_CLIPPADPR_UNPACK_MASK_SHIFT(reg) (((reg) & CLIPPAD_CLIPPADPR_UNPACK_MASK) >> CLIPPAD_CLIPPADPR_UNPACK_SHIFT)
#define  CLIPPAD_CLIPPADPR_UNPACK_REPLACE_VAL(reg,val) (((reg) & ~CLIPPAD_CLIPPADPR_UNPACK_MASK) | (((uint32_t)val) << CLIPPAD_CLIPPADPR_UNPACK_SHIFT))

#define  CLIPPAD_CLIPPADPR_NUM_CHAN_MASK 0x3f0000
#define  CLIPPAD_CLIPPADPR_NUM_CHAN_SHIFT 16
#define  CLIPPAD_CLIPPADPR_NUM_CHAN_MASK_SHIFT(reg) (((reg) & CLIPPAD_CLIPPADPR_NUM_CHAN_MASK) >> CLIPPAD_CLIPPADPR_NUM_CHAN_SHIFT)
#define  CLIPPAD_CLIPPADPR_NUM_CHAN_REPLACE_VAL(reg,val) (((reg) & ~CLIPPAD_CLIPPADPR_NUM_CHAN_MASK) | (((uint32_t)val) << CLIPPAD_CLIPPADPR_NUM_CHAN_SHIFT))

#define  CLIPPAD_CLIPPADPR_OUT_WIDTH_MASK 0xfc00
#define  CLIPPAD_CLIPPADPR_OUT_WIDTH_SHIFT 10
#define  CLIPPAD_CLIPPADPR_OUT_WIDTH_MASK_SHIFT(reg) (((reg) & CLIPPAD_CLIPPADPR_OUT_WIDTH_MASK) >> CLIPPAD_CLIPPADPR_OUT_WIDTH_SHIFT)
#define  CLIPPAD_CLIPPADPR_OUT_WIDTH_REPLACE_VAL(reg,val) (((reg) & ~CLIPPAD_CLIPPADPR_OUT_WIDTH_MASK) | (((uint32_t)val) << CLIPPAD_CLIPPADPR_OUT_WIDTH_SHIFT))

#define  CLIPPAD_CLIPPADPR_IN_WIDTH_MASK 0x3f0
#define  CLIPPAD_CLIPPADPR_IN_WIDTH_SHIFT 4
#define  CLIPPAD_CLIPPADPR_IN_WIDTH_MASK_SHIFT(reg) (((reg) & CLIPPAD_CLIPPADPR_IN_WIDTH_MASK) >> CLIPPAD_CLIPPADPR_IN_WIDTH_SHIFT)
#define  CLIPPAD_CLIPPADPR_IN_WIDTH_REPLACE_VAL(reg,val) (((reg) & ~CLIPPAD_CLIPPADPR_IN_WIDTH_MASK) | (((uint32_t)val) << CLIPPAD_CLIPPADPR_IN_WIDTH_SHIFT))

#define  CLIPPAD_CLIPPADPR_AWIDTH_MASK 0xf
#define  CLIPPAD_CLIPPADPR_AWIDTH_SHIFT 0
#define  CLIPPAD_CLIPPADPR_AWIDTH_MASK_SHIFT(reg) (((reg) & CLIPPAD_CLIPPADPR_AWIDTH_MASK) >> CLIPPAD_CLIPPADPR_AWIDTH_SHIFT)
#define  CLIPPAD_CLIPPADPR_AWIDTH_REPLACE_VAL(reg,val) (((reg) & ~CLIPPAD_CLIPPADPR_AWIDTH_MASK) | (((uint32_t)val) << CLIPPAD_CLIPPADPR_AWIDTH_SHIFT))

//====================================================================
//Register: CLIPPAD Tagging Revision 0 (REV0)
/** \brief Provide means for firmware to read IP tagging information.
      This register of particular interest to firmware.*/
//====================================================================

#define  CLIPPAD_REV0_MAJ_MASK 0xffff0000
#define  CLIPPAD_REV0_MAJ_SHIFT 16
#define  CLIPPAD_REV0_MAJ_MASK_SHIFT(reg) (((reg) & CLIPPAD_REV0_MAJ_MASK) >> CLIPPAD_REV0_MAJ_SHIFT)
#define  CLIPPAD_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~CLIPPAD_REV0_MAJ_MASK) | (((uint32_t)val) << CLIPPAD_REV0_MAJ_SHIFT))

#define  CLIPPAD_REV0_MID_MASK 0xffff
#define  CLIPPAD_REV0_MID_SHIFT 0
#define  CLIPPAD_REV0_MID_MASK_SHIFT(reg) (((reg) & CLIPPAD_REV0_MID_MASK) >> CLIPPAD_REV0_MID_SHIFT)
#define  CLIPPAD_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~CLIPPAD_REV0_MID_MASK) | (((uint32_t)val) << CLIPPAD_REV0_MID_SHIFT))

//====================================================================
//Register: CLIPPAD Tagging Revision 1 (REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  CLIPPAD_REV1_RESERVED1_MASK 0xffff0000
#define  CLIPPAD_REV1_RESERVED1_SHIFT 16
#define  CLIPPAD_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & CLIPPAD_REV1_RESERVED1_MASK) >> CLIPPAD_REV1_RESERVED1_SHIFT)
#define  CLIPPAD_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~CLIPPAD_REV1_RESERVED1_MASK) | (((uint32_t)val) << CLIPPAD_REV1_RESERVED1_SHIFT))

#define  CLIPPAD_REV1_CFG_MASK 0xffff
#define  CLIPPAD_REV1_CFG_SHIFT 0
#define  CLIPPAD_REV1_CFG_MASK_SHIFT(reg) (((reg) & CLIPPAD_REV1_CFG_MASK) >> CLIPPAD_REV1_CFG_SHIFT)
#define  CLIPPAD_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~CLIPPAD_REV1_CFG_MASK) | (((uint32_t)val) << CLIPPAD_REV1_CFG_SHIFT))

//====================================================================
//
//Register File: PIE Depogoizer (DEPOGOIZER)
/** \brief (rev 0 . 6 . 5 . 0)
    The DEPOGO registers provide the means to program the characteristics of the desired
    depogoizing operation.*/
//
//====================================================================

//====================================================================
//Register: Depogoizer Configuration Register (Cfg)
/** \brief The fields in this register are used to configure the characteristics of the desired
      pogoizing operation.*/
//====================================================================

#define  DEPOGOIZER_CFG_RESERVED1_MASK 0xfffff800
#define  DEPOGOIZER_CFG_RESERVED1_SHIFT 11
#define  DEPOGOIZER_CFG_RESERVED1_MASK_SHIFT(reg) (((reg) & DEPOGOIZER_CFG_RESERVED1_MASK) >> DEPOGOIZER_CFG_RESERVED1_SHIFT)
#define  DEPOGOIZER_CFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DEPOGOIZER_CFG_RESERVED1_MASK) | (((uint32_t)val) << DEPOGOIZER_CFG_RESERVED1_SHIFT))

#define  DEPOGOIZER_CFG_MONOCHAN_MASK 0x700
#define  DEPOGOIZER_CFG_MONOCHAN_SHIFT 8
#define  DEPOGOIZER_CFG_MONOCHAN_MASK_SHIFT(reg) (((reg) & DEPOGOIZER_CFG_MONOCHAN_MASK) >> DEPOGOIZER_CFG_MONOCHAN_SHIFT)
#define  DEPOGOIZER_CFG_MONOCHAN_REPLACE_VAL(reg,val) (((reg) & ~DEPOGOIZER_CFG_MONOCHAN_MASK) | (((uint32_t)val) << DEPOGOIZER_CFG_MONOCHAN_SHIFT))

#define  DEPOGOIZER_CFG_PIXORDER_MASK 0x80
#define  DEPOGOIZER_CFG_PIXORDER_SHIFT 7
#define  DEPOGOIZER_CFG_PIXORDER_MASK_SHIFT(reg) (((reg) & DEPOGOIZER_CFG_PIXORDER_MASK) >> DEPOGOIZER_CFG_PIXORDER_SHIFT)
#define  DEPOGOIZER_CFG_PIXORDER_REPLACE_VAL(reg,val) (((reg) & ~DEPOGOIZER_CFG_PIXORDER_MASK) | (((uint32_t)val) << DEPOGOIZER_CFG_PIXORDER_SHIFT))

#define  DEPOGOIZER_CFG_BPP_MASK 0x70
#define  DEPOGOIZER_CFG_BPP_SHIFT 4
#define  DEPOGOIZER_CFG_BPP_MASK_SHIFT(reg) (((reg) & DEPOGOIZER_CFG_BPP_MASK) >> DEPOGOIZER_CFG_BPP_SHIFT)
#define  DEPOGOIZER_CFG_BPP_REPLACE_VAL(reg,val) (((reg) & ~DEPOGOIZER_CFG_BPP_MASK) | (((uint32_t)val) << DEPOGOIZER_CFG_BPP_SHIFT))

#define  DEPOGOIZER_CFG_COLORSWAP_MASK 0x8
#define  DEPOGOIZER_CFG_COLORSWAP_SHIFT 3
#define  DEPOGOIZER_CFG_COLORSWAP_MASK_SHIFT(reg) (((reg) & DEPOGOIZER_CFG_COLORSWAP_MASK) >> DEPOGOIZER_CFG_COLORSWAP_SHIFT)
#define  DEPOGOIZER_CFG_COLORSWAP_REPLACE_VAL(reg,val) (((reg) & ~DEPOGOIZER_CFG_COLORSWAP_MASK) | (((uint32_t)val) << DEPOGOIZER_CFG_COLORSWAP_SHIFT))

#define  DEPOGOIZER_CFG_FMT_MASK 0x7
#define  DEPOGOIZER_CFG_FMT_SHIFT 0
#define  DEPOGOIZER_CFG_FMT_MASK_SHIFT(reg) (((reg) & DEPOGOIZER_CFG_FMT_MASK) >> DEPOGOIZER_CFG_FMT_SHIFT)
#define  DEPOGOIZER_CFG_FMT_REPLACE_VAL(reg,val) (((reg) & ~DEPOGOIZER_CFG_FMT_MASK) | (((uint32_t)val) << DEPOGOIZER_CFG_FMT_SHIFT))

//====================================================================
//Register: IP Tagging Revision 0 (REV0)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  DEPOGOIZER_REV0_MAJ_MASK 0xffff0000
#define  DEPOGOIZER_REV0_MAJ_SHIFT 16
#define  DEPOGOIZER_REV0_MAJ_MASK_SHIFT(reg) (((reg) & DEPOGOIZER_REV0_MAJ_MASK) >> DEPOGOIZER_REV0_MAJ_SHIFT)
#define  DEPOGOIZER_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~DEPOGOIZER_REV0_MAJ_MASK) | (((uint32_t)val) << DEPOGOIZER_REV0_MAJ_SHIFT))

#define  DEPOGOIZER_REV0_MID_MASK 0xffff
#define  DEPOGOIZER_REV0_MID_SHIFT 0
#define  DEPOGOIZER_REV0_MID_MASK_SHIFT(reg) (((reg) & DEPOGOIZER_REV0_MID_MASK) >> DEPOGOIZER_REV0_MID_SHIFT)
#define  DEPOGOIZER_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~DEPOGOIZER_REV0_MID_MASK) | (((uint32_t)val) << DEPOGOIZER_REV0_MID_SHIFT))

//====================================================================
//Register: IP Tagging Revision 1 (REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  DEPOGOIZER_REV1_RESERVED1_MASK 0xffff0000
#define  DEPOGOIZER_REV1_RESERVED1_SHIFT 16
#define  DEPOGOIZER_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & DEPOGOIZER_REV1_RESERVED1_MASK) >> DEPOGOIZER_REV1_RESERVED1_SHIFT)
#define  DEPOGOIZER_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DEPOGOIZER_REV1_RESERVED1_MASK) | (((uint32_t)val) << DEPOGOIZER_REV1_RESERVED1_SHIFT))

#define  DEPOGOIZER_REV1_CFG_MASK 0xffff
#define  DEPOGOIZER_REV1_CFG_SHIFT 0
#define  DEPOGOIZER_REV1_CFG_MASK_SHIFT(reg) (((reg) & DEPOGOIZER_REV1_CFG_MASK) >> DEPOGOIZER_REV1_CFG_SHIFT)
#define  DEPOGOIZER_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~DEPOGOIZER_REV1_CFG_MASK) | (((uint32_t)val) << DEPOGOIZER_REV1_CFG_SHIFT))

//====================================================================
//
//Register File: PIE Write DMA (POGO_ODMA)
//
//====================================================================

//====================================================================
//
//Register File: PIE OT Depogoizer (OTDEPOGOIZER)
/** \brief (rev 0 . 6 . 5 . 0)
    The DEPOGO registers provide the means to program the characteristics of the desired
    depogoizing operation.*/
//
//====================================================================

//====================================================================
//Register: Depogoizer Configuration Register (Cfg)
/** \brief The fields in this register are used to configure the characteristics of the desired
      pogoizing operation.*/
//====================================================================

#define  OTDEPOGOIZER_CFG_RESERVED1_MASK 0xfffff800
#define  OTDEPOGOIZER_CFG_RESERVED1_SHIFT 11
#define  OTDEPOGOIZER_CFG_RESERVED1_MASK_SHIFT(reg) (((reg) & OTDEPOGOIZER_CFG_RESERVED1_MASK) >> OTDEPOGOIZER_CFG_RESERVED1_SHIFT)
#define  OTDEPOGOIZER_CFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~OTDEPOGOIZER_CFG_RESERVED1_MASK) | (((uint32_t)val) << OTDEPOGOIZER_CFG_RESERVED1_SHIFT))

#define  OTDEPOGOIZER_CFG_MONOCHAN_MASK 0x700
#define  OTDEPOGOIZER_CFG_MONOCHAN_SHIFT 8
#define  OTDEPOGOIZER_CFG_MONOCHAN_MASK_SHIFT(reg) (((reg) & OTDEPOGOIZER_CFG_MONOCHAN_MASK) >> OTDEPOGOIZER_CFG_MONOCHAN_SHIFT)
#define  OTDEPOGOIZER_CFG_MONOCHAN_REPLACE_VAL(reg,val) (((reg) & ~OTDEPOGOIZER_CFG_MONOCHAN_MASK) | (((uint32_t)val) << OTDEPOGOIZER_CFG_MONOCHAN_SHIFT))

#define  OTDEPOGOIZER_CFG_PIXORDER_MASK 0x80
#define  OTDEPOGOIZER_CFG_PIXORDER_SHIFT 7
#define  OTDEPOGOIZER_CFG_PIXORDER_MASK_SHIFT(reg) (((reg) & OTDEPOGOIZER_CFG_PIXORDER_MASK) >> OTDEPOGOIZER_CFG_PIXORDER_SHIFT)
#define  OTDEPOGOIZER_CFG_PIXORDER_REPLACE_VAL(reg,val) (((reg) & ~OTDEPOGOIZER_CFG_PIXORDER_MASK) | (((uint32_t)val) << OTDEPOGOIZER_CFG_PIXORDER_SHIFT))

#define  OTDEPOGOIZER_CFG_BPP_MASK 0x70
#define  OTDEPOGOIZER_CFG_BPP_SHIFT 4
#define  OTDEPOGOIZER_CFG_BPP_MASK_SHIFT(reg) (((reg) & OTDEPOGOIZER_CFG_BPP_MASK) >> OTDEPOGOIZER_CFG_BPP_SHIFT)
#define  OTDEPOGOIZER_CFG_BPP_REPLACE_VAL(reg,val) (((reg) & ~OTDEPOGOIZER_CFG_BPP_MASK) | (((uint32_t)val) << OTDEPOGOIZER_CFG_BPP_SHIFT))

#define  OTDEPOGOIZER_CFG_COLORSWAP_MASK 0x8
#define  OTDEPOGOIZER_CFG_COLORSWAP_SHIFT 3
#define  OTDEPOGOIZER_CFG_COLORSWAP_MASK_SHIFT(reg) (((reg) & OTDEPOGOIZER_CFG_COLORSWAP_MASK) >> OTDEPOGOIZER_CFG_COLORSWAP_SHIFT)
#define  OTDEPOGOIZER_CFG_COLORSWAP_REPLACE_VAL(reg,val) (((reg) & ~OTDEPOGOIZER_CFG_COLORSWAP_MASK) | (((uint32_t)val) << OTDEPOGOIZER_CFG_COLORSWAP_SHIFT))

#define  OTDEPOGOIZER_CFG_FMT_MASK 0x7
#define  OTDEPOGOIZER_CFG_FMT_SHIFT 0
#define  OTDEPOGOIZER_CFG_FMT_MASK_SHIFT(reg) (((reg) & OTDEPOGOIZER_CFG_FMT_MASK) >> OTDEPOGOIZER_CFG_FMT_SHIFT)
#define  OTDEPOGOIZER_CFG_FMT_REPLACE_VAL(reg,val) (((reg) & ~OTDEPOGOIZER_CFG_FMT_MASK) | (((uint32_t)val) << OTDEPOGOIZER_CFG_FMT_SHIFT))

//====================================================================
//Register: IP Tagging Revision 0 (REV0)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  OTDEPOGOIZER_REV0_MAJ_MASK 0xffff0000
#define  OTDEPOGOIZER_REV0_MAJ_SHIFT 16
#define  OTDEPOGOIZER_REV0_MAJ_MASK_SHIFT(reg) (((reg) & OTDEPOGOIZER_REV0_MAJ_MASK) >> OTDEPOGOIZER_REV0_MAJ_SHIFT)
#define  OTDEPOGOIZER_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~OTDEPOGOIZER_REV0_MAJ_MASK) | (((uint32_t)val) << OTDEPOGOIZER_REV0_MAJ_SHIFT))

#define  OTDEPOGOIZER_REV0_MID_MASK 0xffff
#define  OTDEPOGOIZER_REV0_MID_SHIFT 0
#define  OTDEPOGOIZER_REV0_MID_MASK_SHIFT(reg) (((reg) & OTDEPOGOIZER_REV0_MID_MASK) >> OTDEPOGOIZER_REV0_MID_SHIFT)
#define  OTDEPOGOIZER_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~OTDEPOGOIZER_REV0_MID_MASK) | (((uint32_t)val) << OTDEPOGOIZER_REV0_MID_SHIFT))

//====================================================================
//Register: IP Tagging Revision 1 (REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  OTDEPOGOIZER_REV1_RESERVED1_MASK 0xffff0000
#define  OTDEPOGOIZER_REV1_RESERVED1_SHIFT 16
#define  OTDEPOGOIZER_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & OTDEPOGOIZER_REV1_RESERVED1_MASK) >> OTDEPOGOIZER_REV1_RESERVED1_SHIFT)
#define  OTDEPOGOIZER_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~OTDEPOGOIZER_REV1_RESERVED1_MASK) | (((uint32_t)val) << OTDEPOGOIZER_REV1_RESERVED1_SHIFT))

#define  OTDEPOGOIZER_REV1_CFG_MASK 0xffff
#define  OTDEPOGOIZER_REV1_CFG_SHIFT 0
#define  OTDEPOGOIZER_REV1_CFG_MASK_SHIFT(reg) (((reg) & OTDEPOGOIZER_REV1_CFG_MASK) >> OTDEPOGOIZER_REV1_CFG_SHIFT)
#define  OTDEPOGOIZER_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~OTDEPOGOIZER_REV1_CFG_MASK) | (((uint32_t)val) << OTDEPOGOIZER_REV1_CFG_SHIFT))

//====================================================================
//
//Register File: PIE Write OT DMA (POGO_OTODMA)
//
//====================================================================

//====================================================================
//
//Register File: PIE DISTORT_TOP (DISTORT_TOP)
/** \brief Register Descriptions for the DISTORT_TOP Testbench*/
//
//====================================================================

//====================================================================
//
//Register File: PIE XYCScale (XYCScale)
/** \brief (rev 0 . 3 . 0 . 0)*/
//
//====================================================================

//====================================================================
//Register: Configure X-Y Scale Register (CSR)
//====================================================================

#define  XYCSCALE_CSR_RESERVED1_MASK 0xfffffffc
#define  XYCSCALE_CSR_RESERVED1_SHIFT 2
#define  XYCSCALE_CSR_RESERVED1_MASK_SHIFT(reg) (((reg) & XYCSCALE_CSR_RESERVED1_MASK) >> XYCSCALE_CSR_RESERVED1_SHIFT)
#define  XYCSCALE_CSR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~XYCSCALE_CSR_RESERVED1_MASK) | (((uint32_t)val) << XYCSCALE_CSR_RESERVED1_SHIFT))

#define  XYCSCALE_CSR_O_MASK 0x2
#define  XYCSCALE_CSR_O_SHIFT 1
#define  XYCSCALE_CSR_O_MASK_SHIFT(reg) (((reg) & XYCSCALE_CSR_O_MASK) >> XYCSCALE_CSR_O_SHIFT)
#define  XYCSCALE_CSR_O_REPLACE_VAL(reg,val) (((reg) & ~XYCSCALE_CSR_O_MASK) | (((uint32_t)val) << XYCSCALE_CSR_O_SHIFT))

#define  XYCSCALE_CSR_B_MASK 0x1
#define  XYCSCALE_CSR_B_SHIFT 0
#define  XYCSCALE_CSR_B_MASK_SHIFT(reg) (((reg) & XYCSCALE_CSR_B_MASK) >> XYCSCALE_CSR_B_SHIFT)
#define  XYCSCALE_CSR_B_REPLACE_VAL(reg,val) (((reg) & ~XYCSCALE_CSR_B_MASK) | (((uint32_t)val) << XYCSCALE_CSR_B_SHIFT))

//====================================================================
//Register: Input Strip Column and Line Count Register  (CLCR)
/** \brief The Input Strip Column Count may also be thought of as the number of x-direction pixels in a given input line. The Input Strip Line Count may also be thought of as the number of y-direction pixels in a given input column. The Line Count is not dependent upon the scale whether reducing or enlarging.
When reducing, the maximum count may not exceed the capabilities of the preceding ICE blocks, this is set to 17 lines. A Bi-Cubic reducing scale range near or equal to one takes 17 input lines and creates 14 output lines. This Y-Scale output is stored in fourteen intermediate registers as the X-Scale traverses column to column.
When enlarging, the maximum count may not exceed the floor of the Maximum Lines per Strip (L) divided by the enlarging Y scale (Sy). For example with L = 16 and if the scale is 7x (700%) the maximum Line Count is the floor [16 / 7] = floor [2.286] = 2. Two lines may seem limiting but, at a scale 7x in both directions, each input pixel will generate 49 output pixels.
               Once written, this register will stick through all subsequent strips until changed.*/
//====================================================================

#define  XYCSCALE_CLCR_RESERVED1_MASK 0xc0000000
#define  XYCSCALE_CLCR_RESERVED1_SHIFT 30
#define  XYCSCALE_CLCR_RESERVED1_MASK_SHIFT(reg) (((reg) & XYCSCALE_CLCR_RESERVED1_MASK) >> XYCSCALE_CLCR_RESERVED1_SHIFT)
#define  XYCSCALE_CLCR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~XYCSCALE_CLCR_RESERVED1_MASK) | (((uint32_t)val) << XYCSCALE_CLCR_RESERVED1_SHIFT))

#define  XYCSCALE_CLCR_LC_MASK 0x3f000000
#define  XYCSCALE_CLCR_LC_SHIFT 24
#define  XYCSCALE_CLCR_LC_MASK_SHIFT(reg) (((reg) & XYCSCALE_CLCR_LC_MASK) >> XYCSCALE_CLCR_LC_SHIFT)
#define  XYCSCALE_CLCR_LC_REPLACE_VAL(reg,val) (((reg) & ~XYCSCALE_CLCR_LC_MASK) | (((uint32_t)val) << XYCSCALE_CLCR_LC_SHIFT))

#define  XYCSCALE_CLCR_RESERVED2_MASK 0xfc0000
#define  XYCSCALE_CLCR_RESERVED2_SHIFT 18
#define  XYCSCALE_CLCR_RESERVED2_MASK_SHIFT(reg) (((reg) & XYCSCALE_CLCR_RESERVED2_MASK) >> XYCSCALE_CLCR_RESERVED2_SHIFT)
#define  XYCSCALE_CLCR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~XYCSCALE_CLCR_RESERVED2_MASK) | (((uint32_t)val) << XYCSCALE_CLCR_RESERVED2_SHIFT))

#define  XYCSCALE_CLCR_CC_MASK 0x3ffff
#define  XYCSCALE_CLCR_CC_SHIFT 0
#define  XYCSCALE_CLCR_CC_MASK_SHIFT(reg) (((reg) & XYCSCALE_CLCR_CC_MASK) >> XYCSCALE_CLCR_CC_SHIFT)
#define  XYCSCALE_CLCR_CC_REPLACE_VAL(reg,val) (((reg) & ~XYCSCALE_CLCR_CC_MASK) | (((uint32_t)val) << XYCSCALE_CLCR_CC_SHIFT))

//====================================================================
//Register: Output Strip Column Count Register (CCR)
/** \brief The Output Column Count may also be thought of as the number of x-direction pixels in a given output line. This value may exceed the scaled output count of the input pixels in which case data padding will be used to make up the difference. In the case where this value is less than the scaled output count the output is cut short to this new count. Data padding will either use individual fill data as setup in the color X fill data registers below, or if the Replicate Mode bit is set, will use the last column data values to pad with.
This replaces a pad count that extends the data size to some optimal DMA sizing, and adds the feature of being able to cut short output data.
               Once written, this register will stick through all subsequent strips until changed.*/
//====================================================================

#define  XYCSCALE_CCR_RESERVED1_MASK 0xfe000000
#define  XYCSCALE_CCR_RESERVED1_SHIFT 25
#define  XYCSCALE_CCR_RESERVED1_MASK_SHIFT(reg) (((reg) & XYCSCALE_CCR_RESERVED1_MASK) >> XYCSCALE_CCR_RESERVED1_SHIFT)
#define  XYCSCALE_CCR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~XYCSCALE_CCR_RESERVED1_MASK) | (((uint32_t)val) << XYCSCALE_CCR_RESERVED1_SHIFT))

#define  XYCSCALE_CCR_RM_MASK 0x1000000
#define  XYCSCALE_CCR_RM_SHIFT 24
#define  XYCSCALE_CCR_RM_MASK_SHIFT(reg) (((reg) & XYCSCALE_CCR_RM_MASK) >> XYCSCALE_CCR_RM_SHIFT)
#define  XYCSCALE_CCR_RM_REPLACE_VAL(reg,val) (((reg) & ~XYCSCALE_CCR_RM_MASK) | (((uint32_t)val) << XYCSCALE_CCR_RM_SHIFT))

#define  XYCSCALE_CCR_RESERVED2_MASK 0xfc0000
#define  XYCSCALE_CCR_RESERVED2_SHIFT 18
#define  XYCSCALE_CCR_RESERVED2_MASK_SHIFT(reg) (((reg) & XYCSCALE_CCR_RESERVED2_MASK) >> XYCSCALE_CCR_RESERVED2_SHIFT)
#define  XYCSCALE_CCR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~XYCSCALE_CCR_RESERVED2_MASK) | (((uint32_t)val) << XYCSCALE_CCR_RESERVED2_SHIFT))

#define  XYCSCALE_CCR_CC_MASK 0x3ffff
#define  XYCSCALE_CCR_CC_SHIFT 0
#define  XYCSCALE_CCR_CC_MASK_SHIFT(reg) (((reg) & XYCSCALE_CCR_CC_MASK) >> XYCSCALE_CCR_CC_SHIFT)
#define  XYCSCALE_CCR_CC_REPLACE_VAL(reg,val) (((reg) & ~XYCSCALE_CCR_CC_MASK) | (((uint32_t)val) << XYCSCALE_CCR_CC_SHIFT))

//====================================================================
//Register: Color 2 and Color 1 Fill Data Register (CFR1)
//====================================================================

#define  XYCSCALE_CFR1_RESERVED1_MASK 0xff000000
#define  XYCSCALE_CFR1_RESERVED1_SHIFT 24
#define  XYCSCALE_CFR1_RESERVED1_MASK_SHIFT(reg) (((reg) & XYCSCALE_CFR1_RESERVED1_MASK) >> XYCSCALE_CFR1_RESERVED1_SHIFT)
#define  XYCSCALE_CFR1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~XYCSCALE_CFR1_RESERVED1_MASK) | (((uint32_t)val) << XYCSCALE_CFR1_RESERVED1_SHIFT))

#define  XYCSCALE_CFR1_FILL2_MASK 0xff0000
#define  XYCSCALE_CFR1_FILL2_SHIFT 16
#define  XYCSCALE_CFR1_FILL2_MASK_SHIFT(reg) (((reg) & XYCSCALE_CFR1_FILL2_MASK) >> XYCSCALE_CFR1_FILL2_SHIFT)
#define  XYCSCALE_CFR1_FILL2_REPLACE_VAL(reg,val) (((reg) & ~XYCSCALE_CFR1_FILL2_MASK) | (((uint32_t)val) << XYCSCALE_CFR1_FILL2_SHIFT))

#define  XYCSCALE_CFR1_RESERVED2_MASK 0xff00
#define  XYCSCALE_CFR1_RESERVED2_SHIFT 8
#define  XYCSCALE_CFR1_RESERVED2_MASK_SHIFT(reg) (((reg) & XYCSCALE_CFR1_RESERVED2_MASK) >> XYCSCALE_CFR1_RESERVED2_SHIFT)
#define  XYCSCALE_CFR1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~XYCSCALE_CFR1_RESERVED2_MASK) | (((uint32_t)val) << XYCSCALE_CFR1_RESERVED2_SHIFT))

#define  XYCSCALE_CFR1_FILL1_MASK 0xff
#define  XYCSCALE_CFR1_FILL1_SHIFT 0
#define  XYCSCALE_CFR1_FILL1_MASK_SHIFT(reg) (((reg) & XYCSCALE_CFR1_FILL1_MASK) >> XYCSCALE_CFR1_FILL1_SHIFT)
#define  XYCSCALE_CFR1_FILL1_REPLACE_VAL(reg,val) (((reg) & ~XYCSCALE_CFR1_FILL1_MASK) | (((uint32_t)val) << XYCSCALE_CFR1_FILL1_SHIFT))

//====================================================================
//Register: Color 0 Fill Data Register (CFR2)
//====================================================================

#define  XYCSCALE_CFR2_RESERVED1_MASK 0xffffff00
#define  XYCSCALE_CFR2_RESERVED1_SHIFT 8
#define  XYCSCALE_CFR2_RESERVED1_MASK_SHIFT(reg) (((reg) & XYCSCALE_CFR2_RESERVED1_MASK) >> XYCSCALE_CFR2_RESERVED1_SHIFT)
#define  XYCSCALE_CFR2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~XYCSCALE_CFR2_RESERVED1_MASK) | (((uint32_t)val) << XYCSCALE_CFR2_RESERVED1_SHIFT))

#define  XYCSCALE_CFR2_FILL0_MASK 0xff
#define  XYCSCALE_CFR2_FILL0_SHIFT 0
#define  XYCSCALE_CFR2_FILL0_MASK_SHIFT(reg) (((reg) & XYCSCALE_CFR2_FILL0_MASK) >> XYCSCALE_CFR2_FILL0_SHIFT)
#define  XYCSCALE_CFR2_FILL0_REPLACE_VAL(reg,val) (((reg) & ~XYCSCALE_CFR2_FILL0_MASK) | (((uint32_t)val) << XYCSCALE_CFR2_FILL0_SHIFT))

//====================================================================
//Register: Horizontal Scale Register (HSR)
/** \brief Scale factor x-direction
The following table is for reference, loading the scale, transpose, edge count, and scale - normal.
<table>
<th>Hex Program Values</th><th>Mode:</th></th><th colspan=4>Bi-Cubic Mode</th></tr>
<tr><td> </td><td>Register:</td></td><td>(scaleX/Y)</td></td></tr>
<tr><td> </td><td>Bits:</td></td><td>S: Scale Factor</td></td></td></tr>
<tr><td>Scale</td><td>Percentage</td></td><td>Hex value</td></td></tr>
<tr><td>1x</td><td>100%</td></td><td>1_0000h</td></td></tr>
<tr><td> </td><td>100.00153%</td></td><td>0_FFFFh</td></td></tr>
<tr><td>1.01x</td><td>101%</td></td><td>0_FD77h</td></td></td></tr>
<tr><td>1.5x</td><td>150%</td></td><td>0_AAAAh</td></td></td></tr>
<tr><td>2x</td><td>200%</td></td><td>0_8000h</td></td></td></tr>
<tr><td>3x</td><td>300%</td></td><td>0_5555h</td></td></td></tr>
<tr><td>4x</td><td>400%</td></td><td>0_4000h</td></td></td></tr>
<tr><td></td><td>99%</td></td><td>1_0295h</td></td></td></tr>
<tr><td></td><td>99.99847%</td></td><td>1_1001h</td></td></td></tr>
<tr><td>.75x</td><td></td></td><td>1_5555h</td></td></td></tr>
<tr><td>.5x</td><td>50%</td></td><td>2_0000h</td></td></td></tr>
<tr><td>.25x</td><td>25%</td></td><td>N/A</td></td></td></tr>
</table>
               <p>Once written, this register will stick through all subsequent strips until changed.</p>*/
//====================================================================

#define  XYCSCALE_HSR_RESERVED1_MASK 0xfff00000
#define  XYCSCALE_HSR_RESERVED1_SHIFT 20
#define  XYCSCALE_HSR_RESERVED1_MASK_SHIFT(reg) (((reg) & XYCSCALE_HSR_RESERVED1_MASK) >> XYCSCALE_HSR_RESERVED1_SHIFT)
#define  XYCSCALE_HSR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~XYCSCALE_HSR_RESERVED1_MASK) | (((uint32_t)val) << XYCSCALE_HSR_RESERVED1_SHIFT))

#define  XYCSCALE_HSR_S_MASK 0xfffff
#define  XYCSCALE_HSR_S_SHIFT 0
#define  XYCSCALE_HSR_S_MASK_SHIFT(reg) (((reg) & XYCSCALE_HSR_S_MASK) >> XYCSCALE_HSR_S_SHIFT)
#define  XYCSCALE_HSR_S_REPLACE_VAL(reg,val) (((reg) & ~XYCSCALE_HSR_S_MASK) | (((uint32_t)val) << XYCSCALE_HSR_S_SHIFT))

//====================================================================
//Register: Vertical Scale Register (VSR)
/** \brief Scale factor y-direction
              Firmware is required to pad the top and bottom of page with extra bits when enlarging an image.*/
//====================================================================

#define  XYCSCALE_VSR_RESERVED1_MASK 0xfff00000
#define  XYCSCALE_VSR_RESERVED1_SHIFT 20
#define  XYCSCALE_VSR_RESERVED1_MASK_SHIFT(reg) (((reg) & XYCSCALE_VSR_RESERVED1_MASK) >> XYCSCALE_VSR_RESERVED1_SHIFT)
#define  XYCSCALE_VSR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~XYCSCALE_VSR_RESERVED1_MASK) | (((uint32_t)val) << XYCSCALE_VSR_RESERVED1_SHIFT))

#define  XYCSCALE_VSR_S_MASK 0xfffff
#define  XYCSCALE_VSR_S_SHIFT 0
#define  XYCSCALE_VSR_S_MASK_SHIFT(reg) (((reg) & XYCSCALE_VSR_S_MASK) >> XYCSCALE_VSR_S_SHIFT)
#define  XYCSCALE_VSR_S_REPLACE_VAL(reg,val) (((reg) & ~XYCSCALE_VSR_S_MASK) | (((uint32_t)val) << XYCSCALE_VSR_S_SHIFT))

//====================================================================
//Register: X-Transpose Configuration Register (XTR)
/** \brief This register in conjunction with the Horizontal Scale register stores configuration information beyond scale factors that the Scale block uses.
               Within the block, the Dx is reloaded after the column count is met.*/
//====================================================================

#define  XYCSCALE_XTR_RESERVED1_MASK 0xfff00000
#define  XYCSCALE_XTR_RESERVED1_SHIFT 20
#define  XYCSCALE_XTR_RESERVED1_MASK_SHIFT(reg) (((reg) & XYCSCALE_XTR_RESERVED1_MASK) >> XYCSCALE_XTR_RESERVED1_SHIFT)
#define  XYCSCALE_XTR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~XYCSCALE_XTR_RESERVED1_MASK) | (((uint32_t)val) << XYCSCALE_XTR_RESERVED1_SHIFT))

#define  XYCSCALE_XTR_DX_MASK 0xfffff
#define  XYCSCALE_XTR_DX_SHIFT 0
#define  XYCSCALE_XTR_DX_MASK_SHIFT(reg) (((reg) & XYCSCALE_XTR_DX_MASK) >> XYCSCALE_XTR_DX_SHIFT)
#define  XYCSCALE_XTR_DX_REPLACE_VAL(reg,val) (((reg) & ~XYCSCALE_XTR_DX_MASK) | (((uint32_t)val) << XYCSCALE_XTR_DX_SHIFT))

//====================================================================
//Register: Y-Transpose Configuration Register (YTR)
/** \brief This register in conjunction with the Vertical Scale register stores configuration information beyond scale factors that the Scale block uses.
               Typically, Dy is loaded only once for top of page. The transpose in the vertical direction is maintained by the Current Y-Start register. The Current Y-Start register can be saved and re-written into this register to stop current image, write this register start & finish a different image strip, and then resume.*/
//====================================================================

#define  XYCSCALE_YTR_RESERVED1_MASK 0xfff00000
#define  XYCSCALE_YTR_RESERVED1_SHIFT 20
#define  XYCSCALE_YTR_RESERVED1_MASK_SHIFT(reg) (((reg) & XYCSCALE_YTR_RESERVED1_MASK) >> XYCSCALE_YTR_RESERVED1_SHIFT)
#define  XYCSCALE_YTR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~XYCSCALE_YTR_RESERVED1_MASK) | (((uint32_t)val) << XYCSCALE_YTR_RESERVED1_SHIFT))

#define  XYCSCALE_YTR_DY_MASK 0xfffff
#define  XYCSCALE_YTR_DY_SHIFT 0
#define  XYCSCALE_YTR_DY_MASK_SHIFT(reg) (((reg) & XYCSCALE_YTR_DY_MASK) >> XYCSCALE_YTR_DY_SHIFT)
#define  XYCSCALE_YTR_DY_REPLACE_VAL(reg,val) (((reg) & ~XYCSCALE_YTR_DY_MASK) | (((uint32_t)val) << XYCSCALE_YTR_DY_SHIFT))

//====================================================================
//Register: Current X-Start Register (CXR)
/** \brief This register allows read access of the current internal start Dx register. The initial value comes from the X-Transpose Register and should be read back as such during page initialization.*/
//====================================================================

#define  XYCSCALE_CXR_RESERVED1_MASK 0xfff00000
#define  XYCSCALE_CXR_RESERVED1_SHIFT 20
#define  XYCSCALE_CXR_RESERVED1_MASK_SHIFT(reg) (((reg) & XYCSCALE_CXR_RESERVED1_MASK) >> XYCSCALE_CXR_RESERVED1_SHIFT)
#define  XYCSCALE_CXR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~XYCSCALE_CXR_RESERVED1_MASK) | (((uint32_t)val) << XYCSCALE_CXR_RESERVED1_SHIFT))

#define  XYCSCALE_CXR_DX_MASK 0xfffff
#define  XYCSCALE_CXR_DX_SHIFT 0
#define  XYCSCALE_CXR_DX_MASK_SHIFT(reg) (((reg) & XYCSCALE_CXR_DX_MASK) >> XYCSCALE_CXR_DX_SHIFT)
#define  XYCSCALE_CXR_DX_REPLACE_VAL(reg,val) (((reg) & ~XYCSCALE_CXR_DX_MASK) | (((uint32_t)val) << XYCSCALE_CXR_DX_SHIFT))

//====================================================================
//Register: Current Y-Start Register (CYR)
/** \brief This register in allows read access of the current internal start Dy register. The initial value comes from the Y-Transpose Register and should be read back as such during page initialization.*/
//====================================================================

#define  XYCSCALE_CYR_RESERVED1_MASK 0xfff00000
#define  XYCSCALE_CYR_RESERVED1_SHIFT 20
#define  XYCSCALE_CYR_RESERVED1_MASK_SHIFT(reg) (((reg) & XYCSCALE_CYR_RESERVED1_MASK) >> XYCSCALE_CYR_RESERVED1_SHIFT)
#define  XYCSCALE_CYR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~XYCSCALE_CYR_RESERVED1_MASK) | (((uint32_t)val) << XYCSCALE_CYR_RESERVED1_SHIFT))

#define  XYCSCALE_CYR_DY_MASK 0xfffff
#define  XYCSCALE_CYR_DY_SHIFT 0
#define  XYCSCALE_CYR_DY_MASK_SHIFT(reg) (((reg) & XYCSCALE_CYR_DY_MASK) >> XYCSCALE_CYR_DY_SHIFT)
#define  XYCSCALE_CYR_DY_REPLACE_VAL(reg,val) (((reg) & ~XYCSCALE_CYR_DY_MASK) | (((uint32_t)val) << XYCSCALE_CYR_DY_SHIFT))

//====================================================================
//Register: Observation Register (XOR)
/** \brief This read only register is for observation of certain XYCScale internals.*/
//====================================================================

#define  XYCSCALE_XOR_DEBUG_MASK 0xffffffff
#define  XYCSCALE_XOR_DEBUG_SHIFT 0
#define  XYCSCALE_XOR_DEBUG_MASK_SHIFT(reg) (((reg) & XYCSCALE_XOR_DEBUG_MASK) >> XYCSCALE_XOR_DEBUG_SHIFT)
#define  XYCSCALE_XOR_DEBUG_REPLACE_VAL(reg,val) (((reg) & ~XYCSCALE_XOR_DEBUG_MASK) | (((uint32_t)val) << XYCSCALE_XOR_DEBUG_SHIFT))

//====================================================================
//Register: Status Register (SR)
//====================================================================

#define  XYCSCALE_SR_RESERVED1_MASK 0xfffffffe
#define  XYCSCALE_SR_RESERVED1_SHIFT 1
#define  XYCSCALE_SR_RESERVED1_MASK_SHIFT(reg) (((reg) & XYCSCALE_SR_RESERVED1_MASK) >> XYCSCALE_SR_RESERVED1_SHIFT)
#define  XYCSCALE_SR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~XYCSCALE_SR_RESERVED1_MASK) | (((uint32_t)val) << XYCSCALE_SR_RESERVED1_SHIFT))

#define  XYCSCALE_SR_B_MASK 0x1
#define  XYCSCALE_SR_B_SHIFT 0
#define  XYCSCALE_SR_B_MASK_SHIFT(reg) (((reg) & XYCSCALE_SR_B_MASK) >> XYCSCALE_SR_B_SHIFT)
#define  XYCSCALE_SR_B_REPLACE_VAL(reg,val) (((reg) & ~XYCSCALE_SR_B_MASK) | (((uint32_t)val) << XYCSCALE_SR_B_SHIFT))

//====================================================================
//Register: IP Tagging Revision 0 (REV0)
/** \brief Provide means for firmware to read IP tagging information.
          This register of particular interest to firmware.*/
//====================================================================

#define  XYCSCALE_REV0_MAJ_MASK 0xffff0000
#define  XYCSCALE_REV0_MAJ_SHIFT 16
#define  XYCSCALE_REV0_MAJ_MASK_SHIFT(reg) (((reg) & XYCSCALE_REV0_MAJ_MASK) >> XYCSCALE_REV0_MAJ_SHIFT)
#define  XYCSCALE_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~XYCSCALE_REV0_MAJ_MASK) | (((uint32_t)val) << XYCSCALE_REV0_MAJ_SHIFT))

#define  XYCSCALE_REV0_MID_MASK 0xffff
#define  XYCSCALE_REV0_MID_SHIFT 0
#define  XYCSCALE_REV0_MID_MASK_SHIFT(reg) (((reg) & XYCSCALE_REV0_MID_MASK) >> XYCSCALE_REV0_MID_SHIFT)
#define  XYCSCALE_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~XYCSCALE_REV0_MID_MASK) | (((uint32_t)val) << XYCSCALE_REV0_MID_SHIFT))

//====================================================================
//Register: IP Tagging Revision 1 (REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  XYCSCALE_REV1_RESERVED1_MASK 0xffff0000
#define  XYCSCALE_REV1_RESERVED1_SHIFT 16
#define  XYCSCALE_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & XYCSCALE_REV1_RESERVED1_MASK) >> XYCSCALE_REV1_RESERVED1_SHIFT)
#define  XYCSCALE_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~XYCSCALE_REV1_RESERVED1_MASK) | (((uint32_t)val) << XYCSCALE_REV1_RESERVED1_SHIFT))

#define  XYCSCALE_REV1_CFG_MASK 0xffff
#define  XYCSCALE_REV1_CFG_SHIFT 0
#define  XYCSCALE_REV1_CFG_MASK_SHIFT(reg) (((reg) & XYCSCALE_REV1_CFG_MASK) >> XYCSCALE_REV1_CFG_SHIFT)
#define  XYCSCALE_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~XYCSCALE_REV1_CFG_MASK) | (((uint32_t)val) << XYCSCALE_REV1_CFG_SHIFT))

//====================================================================
//
//Register File: PIE IHI (IHI)
/** \brief Top-level register file for the IHI block
(rev 0 . 0 . 7 . 4)*/
//
//====================================================================

//====================================================================
//Register: IHI Control Register (Control)
/** \brief This register contains control bits for the IHI Edge Detection stage. See the usage notes for more explanation of the algorithm.*/
//====================================================================

#define  IHI_CONTROL_EN_MASK 0x80000000
#define  IHI_CONTROL_EN_SHIFT 31
#define  IHI_CONTROL_EN_MASK_SHIFT(reg) (((reg) & IHI_CONTROL_EN_MASK) >> IHI_CONTROL_EN_SHIFT)
#define  IHI_CONTROL_EN_REPLACE_VAL(reg,val) (((reg) & ~IHI_CONTROL_EN_MASK) | (((uint32_t)val) << IHI_CONTROL_EN_SHIFT))

#define  IHI_CONTROL_BYPASS_MASK 0x40000000
#define  IHI_CONTROL_BYPASS_SHIFT 30
#define  IHI_CONTROL_BYPASS_MASK_SHIFT(reg) (((reg) & IHI_CONTROL_BYPASS_MASK) >> IHI_CONTROL_BYPASS_SHIFT)
#define  IHI_CONTROL_BYPASS_REPLACE_VAL(reg,val) (((reg) & ~IHI_CONTROL_BYPASS_MASK) | (((uint32_t)val) << IHI_CONTROL_BYPASS_SHIFT))

#define  IHI_CONTROL_RESERVED1_MASK 0x3fff0000
#define  IHI_CONTROL_RESERVED1_SHIFT 16
#define  IHI_CONTROL_RESERVED1_MASK_SHIFT(reg) (((reg) & IHI_CONTROL_RESERVED1_MASK) >> IHI_CONTROL_RESERVED1_SHIFT)
#define  IHI_CONTROL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IHI_CONTROL_RESERVED1_MASK) | (((uint32_t)val) << IHI_CONTROL_RESERVED1_SHIFT))

#define  IHI_CONTROL_ED_DIL_MASK 0xf000
#define  IHI_CONTROL_ED_DIL_SHIFT 12
#define  IHI_CONTROL_ED_DIL_MASK_SHIFT(reg) (((reg) & IHI_CONTROL_ED_DIL_MASK) >> IHI_CONTROL_ED_DIL_SHIFT)
#define  IHI_CONTROL_ED_DIL_REPLACE_VAL(reg,val) (((reg) & ~IHI_CONTROL_ED_DIL_MASK) | (((uint32_t)val) << IHI_CONTROL_ED_DIL_SHIFT))

#define  IHI_CONTROL_RESERVED2_MASK 0xc00
#define  IHI_CONTROL_RESERVED2_SHIFT 10
#define  IHI_CONTROL_RESERVED2_MASK_SHIFT(reg) (((reg) & IHI_CONTROL_RESERVED2_MASK) >> IHI_CONTROL_RESERVED2_SHIFT)
#define  IHI_CONTROL_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~IHI_CONTROL_RESERVED2_MASK) | (((uint32_t)val) << IHI_CONTROL_RESERVED2_SHIFT))

#define  IHI_CONTROL_ED_THRESH_MASK 0x3ff
#define  IHI_CONTROL_ED_THRESH_SHIFT 0
#define  IHI_CONTROL_ED_THRESH_MASK_SHIFT(reg) (((reg) & IHI_CONTROL_ED_THRESH_MASK) >> IHI_CONTROL_ED_THRESH_SHIFT)
#define  IHI_CONTROL_ED_THRESH_REPLACE_VAL(reg,val) (((reg) & ~IHI_CONTROL_ED_THRESH_MASK) | (((uint32_t)val) << IHI_CONTROL_ED_THRESH_SHIFT))

//====================================================================
//Register: IHI Image Size Register (ImgSize)
/** \brief This register contains image width/height fields for the IHI block.*/
//====================================================================

#define  IHI_IMGSIZE_IMG_WIDTH_MASK 0xffff0000
#define  IHI_IMGSIZE_IMG_WIDTH_SHIFT 16
#define  IHI_IMGSIZE_IMG_WIDTH_MASK_SHIFT(reg) (((reg) & IHI_IMGSIZE_IMG_WIDTH_MASK) >> IHI_IMGSIZE_IMG_WIDTH_SHIFT)
#define  IHI_IMGSIZE_IMG_WIDTH_REPLACE_VAL(reg,val) (((reg) & ~IHI_IMGSIZE_IMG_WIDTH_MASK) | (((uint32_t)val) << IHI_IMGSIZE_IMG_WIDTH_SHIFT))

#define  IHI_IMGSIZE_IMG_HEIGHT_MASK 0xffff
#define  IHI_IMGSIZE_IMG_HEIGHT_SHIFT 0
#define  IHI_IMGSIZE_IMG_HEIGHT_MASK_SHIFT(reg) (((reg) & IHI_IMGSIZE_IMG_HEIGHT_MASK) >> IHI_IMGSIZE_IMG_HEIGHT_SHIFT)
#define  IHI_IMGSIZE_IMG_HEIGHT_REPLACE_VAL(reg,val) (((reg) & ~IHI_IMGSIZE_IMG_HEIGHT_MASK) | (((uint32_t)val) << IHI_IMGSIZE_IMG_HEIGHT_SHIFT))

//====================================================================
//Register: IHI Edge Detect Boundaries Register (ED_Bndry)
/** \brief This register contains edge boundary settings for the IHI Edge Detection block.*/
//====================================================================

#define  IHI_ED_BNDRY_RESERVED1_MASK 0xfffff000
#define  IHI_ED_BNDRY_RESERVED1_SHIFT 12
#define  IHI_ED_BNDRY_RESERVED1_MASK_SHIFT(reg) (((reg) & IHI_ED_BNDRY_RESERVED1_MASK) >> IHI_ED_BNDRY_RESERVED1_SHIFT)
#define  IHI_ED_BNDRY_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IHI_ED_BNDRY_RESERVED1_MASK) | (((uint32_t)val) << IHI_ED_BNDRY_RESERVED1_SHIFT))

#define  IHI_ED_BNDRY_ROW_CNT_BASE_MASK 0xf00
#define  IHI_ED_BNDRY_ROW_CNT_BASE_SHIFT 8
#define  IHI_ED_BNDRY_ROW_CNT_BASE_MASK_SHIFT(reg) (((reg) & IHI_ED_BNDRY_ROW_CNT_BASE_MASK) >> IHI_ED_BNDRY_ROW_CNT_BASE_SHIFT)
#define  IHI_ED_BNDRY_ROW_CNT_BASE_REPLACE_VAL(reg,val) (((reg) & ~IHI_ED_BNDRY_ROW_CNT_BASE_MASK) | (((uint32_t)val) << IHI_ED_BNDRY_ROW_CNT_BASE_SHIFT))

#define  IHI_ED_BNDRY_LEFT_COL_CNT_MASK 0xf0
#define  IHI_ED_BNDRY_LEFT_COL_CNT_SHIFT 4
#define  IHI_ED_BNDRY_LEFT_COL_CNT_MASK_SHIFT(reg) (((reg) & IHI_ED_BNDRY_LEFT_COL_CNT_MASK) >> IHI_ED_BNDRY_LEFT_COL_CNT_SHIFT)
#define  IHI_ED_BNDRY_LEFT_COL_CNT_REPLACE_VAL(reg,val) (((reg) & ~IHI_ED_BNDRY_LEFT_COL_CNT_MASK) | (((uint32_t)val) << IHI_ED_BNDRY_LEFT_COL_CNT_SHIFT))

#define  IHI_ED_BNDRY_TOP_ROW_CNT_MASK 0xf
#define  IHI_ED_BNDRY_TOP_ROW_CNT_SHIFT 0
#define  IHI_ED_BNDRY_TOP_ROW_CNT_MASK_SHIFT(reg) (((reg) & IHI_ED_BNDRY_TOP_ROW_CNT_MASK) >> IHI_ED_BNDRY_TOP_ROW_CNT_SHIFT)
#define  IHI_ED_BNDRY_TOP_ROW_CNT_REPLACE_VAL(reg,val) (((reg) & ~IHI_ED_BNDRY_TOP_ROW_CNT_MASK) | (((uint32_t)val) << IHI_ED_BNDRY_TOP_ROW_CNT_SHIFT))

//====================================================================
//Register: IHI Edge Detect Boundaries 2 Register (ED_Bndry2)
/** \brief This register contains edge boundary settings for the IHI Edge Detection block.*/
//====================================================================

#define  IHI_ED_BNDRY2_BOT_ROW_CNT_MASK 0xffff0000
#define  IHI_ED_BNDRY2_BOT_ROW_CNT_SHIFT 16
#define  IHI_ED_BNDRY2_BOT_ROW_CNT_MASK_SHIFT(reg) (((reg) & IHI_ED_BNDRY2_BOT_ROW_CNT_MASK) >> IHI_ED_BNDRY2_BOT_ROW_CNT_SHIFT)
#define  IHI_ED_BNDRY2_BOT_ROW_CNT_REPLACE_VAL(reg,val) (((reg) & ~IHI_ED_BNDRY2_BOT_ROW_CNT_MASK) | (((uint32_t)val) << IHI_ED_BNDRY2_BOT_ROW_CNT_SHIFT))

#define  IHI_ED_BNDRY2_RIGHT_COL_CNT_MASK 0xffff
#define  IHI_ED_BNDRY2_RIGHT_COL_CNT_SHIFT 0
#define  IHI_ED_BNDRY2_RIGHT_COL_CNT_MASK_SHIFT(reg) (((reg) & IHI_ED_BNDRY2_RIGHT_COL_CNT_MASK) >> IHI_ED_BNDRY2_RIGHT_COL_CNT_SHIFT)
#define  IHI_ED_BNDRY2_RIGHT_COL_CNT_REPLACE_VAL(reg,val) (((reg) & ~IHI_ED_BNDRY2_RIGHT_COL_CNT_MASK) | (((uint32_t)val) << IHI_ED_BNDRY2_RIGHT_COL_CNT_SHIFT))

//====================================================================
//Register: IHI Cluster Control Register (Cluster_Control)
/** \brief This register contains control bits for the IHI Adaptive Clustering stage. See the usage notes for more explanation of the algorithm.*/
//====================================================================

#define  IHI_CLUSTER_CONTROL_RESERVED1_MASK 0xfffffc00
#define  IHI_CLUSTER_CONTROL_RESERVED1_SHIFT 10
#define  IHI_CLUSTER_CONTROL_RESERVED1_MASK_SHIFT(reg) (((reg) & IHI_CLUSTER_CONTROL_RESERVED1_MASK) >> IHI_CLUSTER_CONTROL_RESERVED1_SHIFT)
#define  IHI_CLUSTER_CONTROL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IHI_CLUSTER_CONTROL_RESERVED1_MASK) | (((uint32_t)val) << IHI_CLUSTER_CONTROL_RESERVED1_SHIFT))

#define  IHI_CLUSTER_CONTROL_AVG_CNT_MASK 0x300
#define  IHI_CLUSTER_CONTROL_AVG_CNT_SHIFT 8
#define  IHI_CLUSTER_CONTROL_AVG_CNT_MASK_SHIFT(reg) (((reg) & IHI_CLUSTER_CONTROL_AVG_CNT_MASK) >> IHI_CLUSTER_CONTROL_AVG_CNT_SHIFT)
#define  IHI_CLUSTER_CONTROL_AVG_CNT_REPLACE_VAL(reg,val) (((reg) & ~IHI_CLUSTER_CONTROL_AVG_CNT_MASK) | (((uint32_t)val) << IHI_CLUSTER_CONTROL_AVG_CNT_SHIFT))

#define  IHI_CLUSTER_CONTROL_FG_FIXED_MASK 0xff
#define  IHI_CLUSTER_CONTROL_FG_FIXED_SHIFT 0
#define  IHI_CLUSTER_CONTROL_FG_FIXED_MASK_SHIFT(reg) (((reg) & IHI_CLUSTER_CONTROL_FG_FIXED_MASK) >> IHI_CLUSTER_CONTROL_FG_FIXED_SHIFT)
#define  IHI_CLUSTER_CONTROL_FG_FIXED_REPLACE_VAL(reg,val) (((reg) & ~IHI_CLUSTER_CONTROL_FG_FIXED_MASK) | (((uint32_t)val) << IHI_CLUSTER_CONTROL_FG_FIXED_SHIFT))

//====================================================================
//Register: IHI Background Tonal Correct (BG_Tonal)
/** \brief Each input 'x' will be tonal corrected based on the following equation: <BR>
          y = max[min_clip,min{max_clip,((a*x)>>4)+b}] AND (0xFF S.L. mask_shift) <BR>*/
//====================================================================

#define  IHI_BG_TONAL_MIN_CLIP_BG_MASK 0xff000000
#define  IHI_BG_TONAL_MIN_CLIP_BG_SHIFT 24
#define  IHI_BG_TONAL_MIN_CLIP_BG_MASK_SHIFT(reg) (((reg) & IHI_BG_TONAL_MIN_CLIP_BG_MASK) >> IHI_BG_TONAL_MIN_CLIP_BG_SHIFT)
#define  IHI_BG_TONAL_MIN_CLIP_BG_REPLACE_VAL(reg,val) (((reg) & ~IHI_BG_TONAL_MIN_CLIP_BG_MASK) | (((uint32_t)val) << IHI_BG_TONAL_MIN_CLIP_BG_SHIFT))

#define  IHI_BG_TONAL_MAX_CLIP_BG_MASK 0xff0000
#define  IHI_BG_TONAL_MAX_CLIP_BG_SHIFT 16
#define  IHI_BG_TONAL_MAX_CLIP_BG_MASK_SHIFT(reg) (((reg) & IHI_BG_TONAL_MAX_CLIP_BG_MASK) >> IHI_BG_TONAL_MAX_CLIP_BG_SHIFT)
#define  IHI_BG_TONAL_MAX_CLIP_BG_REPLACE_VAL(reg,val) (((reg) & ~IHI_BG_TONAL_MAX_CLIP_BG_MASK) | (((uint32_t)val) << IHI_BG_TONAL_MAX_CLIP_BG_SHIFT))

#define  IHI_BG_TONAL_MASK_SHIFT_BG_MASK 0xf000
#define  IHI_BG_TONAL_MASK_SHIFT_BG_SHIFT 12
#define  IHI_BG_TONAL_MASK_SHIFT_BG_MASK_SHIFT(reg) (((reg) & IHI_BG_TONAL_MASK_SHIFT_BG_MASK) >> IHI_BG_TONAL_MASK_SHIFT_BG_SHIFT)
#define  IHI_BG_TONAL_MASK_SHIFT_BG_REPLACE_VAL(reg,val) (((reg) & ~IHI_BG_TONAL_MASK_SHIFT_BG_MASK) | (((uint32_t)val) << IHI_BG_TONAL_MASK_SHIFT_BG_SHIFT))

#define  IHI_BG_TONAL_RESERVED1_MASK 0xc00
#define  IHI_BG_TONAL_RESERVED1_SHIFT 10
#define  IHI_BG_TONAL_RESERVED1_MASK_SHIFT(reg) (((reg) & IHI_BG_TONAL_RESERVED1_MASK) >> IHI_BG_TONAL_RESERVED1_SHIFT)
#define  IHI_BG_TONAL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IHI_BG_TONAL_RESERVED1_MASK) | (((uint32_t)val) << IHI_BG_TONAL_RESERVED1_SHIFT))

#define  IHI_BG_TONAL_B_BG_MASK 0x3e0
#define  IHI_BG_TONAL_B_BG_SHIFT 5
#define  IHI_BG_TONAL_B_BG_MASK_SHIFT(reg) (((reg) & IHI_BG_TONAL_B_BG_MASK) >> IHI_BG_TONAL_B_BG_SHIFT)
#define  IHI_BG_TONAL_B_BG_REPLACE_VAL(reg,val) (((reg) & ~IHI_BG_TONAL_B_BG_MASK) | (((uint32_t)val) << IHI_BG_TONAL_B_BG_SHIFT))

#define  IHI_BG_TONAL_A_BG_MASK 0x1f
#define  IHI_BG_TONAL_A_BG_SHIFT 0
#define  IHI_BG_TONAL_A_BG_MASK_SHIFT(reg) (((reg) & IHI_BG_TONAL_A_BG_MASK) >> IHI_BG_TONAL_A_BG_SHIFT)
#define  IHI_BG_TONAL_A_BG_REPLACE_VAL(reg,val) (((reg) & ~IHI_BG_TONAL_A_BG_MASK) | (((uint32_t)val) << IHI_BG_TONAL_A_BG_SHIFT))

//====================================================================
//Register: IHI Foreground Tonal Correct (FG_Tonal)
/** \brief Each input 'x' will be tonal corrected based on the following equation: <BR>
          y = max[min_clip,min{max_clip,((a*x)>>4)+b}] AND (0xFF S.L. mask_shift) <BR>*/
//====================================================================

#define  IHI_FG_TONAL_MIN_CLIP_FG_MASK 0xff000000
#define  IHI_FG_TONAL_MIN_CLIP_FG_SHIFT 24
#define  IHI_FG_TONAL_MIN_CLIP_FG_MASK_SHIFT(reg) (((reg) & IHI_FG_TONAL_MIN_CLIP_FG_MASK) >> IHI_FG_TONAL_MIN_CLIP_FG_SHIFT)
#define  IHI_FG_TONAL_MIN_CLIP_FG_REPLACE_VAL(reg,val) (((reg) & ~IHI_FG_TONAL_MIN_CLIP_FG_MASK) | (((uint32_t)val) << IHI_FG_TONAL_MIN_CLIP_FG_SHIFT))

#define  IHI_FG_TONAL_MAX_CLIP_FG_MASK 0xff0000
#define  IHI_FG_TONAL_MAX_CLIP_FG_SHIFT 16
#define  IHI_FG_TONAL_MAX_CLIP_FG_MASK_SHIFT(reg) (((reg) & IHI_FG_TONAL_MAX_CLIP_FG_MASK) >> IHI_FG_TONAL_MAX_CLIP_FG_SHIFT)
#define  IHI_FG_TONAL_MAX_CLIP_FG_REPLACE_VAL(reg,val) (((reg) & ~IHI_FG_TONAL_MAX_CLIP_FG_MASK) | (((uint32_t)val) << IHI_FG_TONAL_MAX_CLIP_FG_SHIFT))

#define  IHI_FG_TONAL_MASK_SHIFT_FG_MASK 0xf000
#define  IHI_FG_TONAL_MASK_SHIFT_FG_SHIFT 12
#define  IHI_FG_TONAL_MASK_SHIFT_FG_MASK_SHIFT(reg) (((reg) & IHI_FG_TONAL_MASK_SHIFT_FG_MASK) >> IHI_FG_TONAL_MASK_SHIFT_FG_SHIFT)
#define  IHI_FG_TONAL_MASK_SHIFT_FG_REPLACE_VAL(reg,val) (((reg) & ~IHI_FG_TONAL_MASK_SHIFT_FG_MASK) | (((uint32_t)val) << IHI_FG_TONAL_MASK_SHIFT_FG_SHIFT))

#define  IHI_FG_TONAL_RESERVED1_MASK 0xc00
#define  IHI_FG_TONAL_RESERVED1_SHIFT 10
#define  IHI_FG_TONAL_RESERVED1_MASK_SHIFT(reg) (((reg) & IHI_FG_TONAL_RESERVED1_MASK) >> IHI_FG_TONAL_RESERVED1_SHIFT)
#define  IHI_FG_TONAL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IHI_FG_TONAL_RESERVED1_MASK) | (((uint32_t)val) << IHI_FG_TONAL_RESERVED1_SHIFT))

#define  IHI_FG_TONAL_B_FG_MASK 0x3e0
#define  IHI_FG_TONAL_B_FG_SHIFT 5
#define  IHI_FG_TONAL_B_FG_MASK_SHIFT(reg) (((reg) & IHI_FG_TONAL_B_FG_MASK) >> IHI_FG_TONAL_B_FG_SHIFT)
#define  IHI_FG_TONAL_B_FG_REPLACE_VAL(reg,val) (((reg) & ~IHI_FG_TONAL_B_FG_MASK) | (((uint32_t)val) << IHI_FG_TONAL_B_FG_SHIFT))

#define  IHI_FG_TONAL_A_FG_MASK 0x1f
#define  IHI_FG_TONAL_A_FG_SHIFT 0
#define  IHI_FG_TONAL_A_FG_MASK_SHIFT(reg) (((reg) & IHI_FG_TONAL_A_FG_MASK) >> IHI_FG_TONAL_A_FG_SHIFT)
#define  IHI_FG_TONAL_A_FG_REPLACE_VAL(reg,val) (((reg) & ~IHI_FG_TONAL_A_FG_MASK) | (((uint32_t)val) << IHI_FG_TONAL_A_FG_SHIFT))

//====================================================================
//Register: IHI DB Debug Control (DB_CTL)
/** \brief Each input 'x' will be tonal corrected based on the following equation: <BR>*/
//====================================================================

#define  IHI_DB_CTL_RESERVED1_MASK 0xfffffff0
#define  IHI_DB_CTL_RESERVED1_SHIFT 4
#define  IHI_DB_CTL_RESERVED1_MASK_SHIFT(reg) (((reg) & IHI_DB_CTL_RESERVED1_MASK) >> IHI_DB_CTL_RESERVED1_SHIFT)
#define  IHI_DB_CTL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IHI_DB_CTL_RESERVED1_MASK) | (((uint32_t)val) << IHI_DB_CTL_RESERVED1_SHIFT))

#define  IHI_DB_CTL_DB_DEBUG_SEL_MASK 0xf
#define  IHI_DB_CTL_DB_DEBUG_SEL_SHIFT 0
#define  IHI_DB_CTL_DB_DEBUG_SEL_MASK_SHIFT(reg) (((reg) & IHI_DB_CTL_DB_DEBUG_SEL_MASK) >> IHI_DB_CTL_DB_DEBUG_SEL_SHIFT)
#define  IHI_DB_CTL_DB_DEBUG_SEL_REPLACE_VAL(reg,val) (((reg) & ~IHI_DB_CTL_DB_DEBUG_SEL_MASK) | (((uint32_t)val) << IHI_DB_CTL_DB_DEBUG_SEL_SHIFT))

//====================================================================
//Register: IP Tagging Revision 0 (REV0)
/** \brief Provide means for firmware to read IP tagging information.
      This register of particular interest to firmware.*/
//====================================================================

#define  IHI_REV0_RESERVED1_MASK 0xffff0000
#define  IHI_REV0_RESERVED1_SHIFT 16
#define  IHI_REV0_RESERVED1_MASK_SHIFT(reg) (((reg) & IHI_REV0_RESERVED1_MASK) >> IHI_REV0_RESERVED1_SHIFT)
#define  IHI_REV0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IHI_REV0_RESERVED1_MASK) | (((uint32_t)val) << IHI_REV0_RESERVED1_SHIFT))

#define  IHI_REV0_CFG_MASK 0xffff
#define  IHI_REV0_CFG_SHIFT 0
#define  IHI_REV0_CFG_MASK_SHIFT(reg) (((reg) & IHI_REV0_CFG_MASK) >> IHI_REV0_CFG_SHIFT)
#define  IHI_REV0_CFG_REPLACE_VAL(reg,val) (((reg) & ~IHI_REV0_CFG_MASK) | (((uint32_t)val) << IHI_REV0_CFG_SHIFT))

//====================================================================
//Register: IP Tagging Revision 1 (REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  IHI_REV1_MAJ_MASK 0xffff0000
#define  IHI_REV1_MAJ_SHIFT 16
#define  IHI_REV1_MAJ_MASK_SHIFT(reg) (((reg) & IHI_REV1_MAJ_MASK) >> IHI_REV1_MAJ_SHIFT)
#define  IHI_REV1_MAJ_REPLACE_VAL(reg,val) (((reg) & ~IHI_REV1_MAJ_MASK) | (((uint32_t)val) << IHI_REV1_MAJ_SHIFT))

#define  IHI_REV1_MID_MASK 0xffff
#define  IHI_REV1_MID_SHIFT 0
#define  IHI_REV1_MID_MASK_SHIFT(reg) (((reg) & IHI_REV1_MID_MASK) >> IHI_REV1_MID_SHIFT)
#define  IHI_REV1_MID_REPLACE_VAL(reg,val) (((reg) & ~IHI_REV1_MID_MASK) | (((uint32_t)val) << IHI_REV1_MID_SHIFT))

//====================================================================
//
//Register File: PIE IHI Depogoizer (IHIDEPOGOIZER)
/** \brief (rev 0 . 6 . 5 . 0)
    The DEPOGO registers provide the means to program the characteristics of the desired
    depogoizing operation.*/
//
//====================================================================

//====================================================================
//Register: Depogoizer Configuration Register (Cfg)
/** \brief The fields in this register are used to configure the characteristics of the desired
      pogoizing operation.*/
//====================================================================

#define  IHIDEPOGOIZER_CFG_RESERVED1_MASK 0xfffff800
#define  IHIDEPOGOIZER_CFG_RESERVED1_SHIFT 11
#define  IHIDEPOGOIZER_CFG_RESERVED1_MASK_SHIFT(reg) (((reg) & IHIDEPOGOIZER_CFG_RESERVED1_MASK) >> IHIDEPOGOIZER_CFG_RESERVED1_SHIFT)
#define  IHIDEPOGOIZER_CFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IHIDEPOGOIZER_CFG_RESERVED1_MASK) | (((uint32_t)val) << IHIDEPOGOIZER_CFG_RESERVED1_SHIFT))

#define  IHIDEPOGOIZER_CFG_MONOCHAN_MASK 0x700
#define  IHIDEPOGOIZER_CFG_MONOCHAN_SHIFT 8
#define  IHIDEPOGOIZER_CFG_MONOCHAN_MASK_SHIFT(reg) (((reg) & IHIDEPOGOIZER_CFG_MONOCHAN_MASK) >> IHIDEPOGOIZER_CFG_MONOCHAN_SHIFT)
#define  IHIDEPOGOIZER_CFG_MONOCHAN_REPLACE_VAL(reg,val) (((reg) & ~IHIDEPOGOIZER_CFG_MONOCHAN_MASK) | (((uint32_t)val) << IHIDEPOGOIZER_CFG_MONOCHAN_SHIFT))

#define  IHIDEPOGOIZER_CFG_PIXORDER_MASK 0x80
#define  IHIDEPOGOIZER_CFG_PIXORDER_SHIFT 7
#define  IHIDEPOGOIZER_CFG_PIXORDER_MASK_SHIFT(reg) (((reg) & IHIDEPOGOIZER_CFG_PIXORDER_MASK) >> IHIDEPOGOIZER_CFG_PIXORDER_SHIFT)
#define  IHIDEPOGOIZER_CFG_PIXORDER_REPLACE_VAL(reg,val) (((reg) & ~IHIDEPOGOIZER_CFG_PIXORDER_MASK) | (((uint32_t)val) << IHIDEPOGOIZER_CFG_PIXORDER_SHIFT))

#define  IHIDEPOGOIZER_CFG_BPP_MASK 0x70
#define  IHIDEPOGOIZER_CFG_BPP_SHIFT 4
#define  IHIDEPOGOIZER_CFG_BPP_MASK_SHIFT(reg) (((reg) & IHIDEPOGOIZER_CFG_BPP_MASK) >> IHIDEPOGOIZER_CFG_BPP_SHIFT)
#define  IHIDEPOGOIZER_CFG_BPP_REPLACE_VAL(reg,val) (((reg) & ~IHIDEPOGOIZER_CFG_BPP_MASK) | (((uint32_t)val) << IHIDEPOGOIZER_CFG_BPP_SHIFT))

#define  IHIDEPOGOIZER_CFG_COLORSWAP_MASK 0x8
#define  IHIDEPOGOIZER_CFG_COLORSWAP_SHIFT 3
#define  IHIDEPOGOIZER_CFG_COLORSWAP_MASK_SHIFT(reg) (((reg) & IHIDEPOGOIZER_CFG_COLORSWAP_MASK) >> IHIDEPOGOIZER_CFG_COLORSWAP_SHIFT)
#define  IHIDEPOGOIZER_CFG_COLORSWAP_REPLACE_VAL(reg,val) (((reg) & ~IHIDEPOGOIZER_CFG_COLORSWAP_MASK) | (((uint32_t)val) << IHIDEPOGOIZER_CFG_COLORSWAP_SHIFT))

#define  IHIDEPOGOIZER_CFG_FMT_MASK 0x7
#define  IHIDEPOGOIZER_CFG_FMT_SHIFT 0
#define  IHIDEPOGOIZER_CFG_FMT_MASK_SHIFT(reg) (((reg) & IHIDEPOGOIZER_CFG_FMT_MASK) >> IHIDEPOGOIZER_CFG_FMT_SHIFT)
#define  IHIDEPOGOIZER_CFG_FMT_REPLACE_VAL(reg,val) (((reg) & ~IHIDEPOGOIZER_CFG_FMT_MASK) | (((uint32_t)val) << IHIDEPOGOIZER_CFG_FMT_SHIFT))

//====================================================================
//Register: IP Tagging Revision 0 (REV0)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  IHIDEPOGOIZER_REV0_MAJ_MASK 0xffff0000
#define  IHIDEPOGOIZER_REV0_MAJ_SHIFT 16
#define  IHIDEPOGOIZER_REV0_MAJ_MASK_SHIFT(reg) (((reg) & IHIDEPOGOIZER_REV0_MAJ_MASK) >> IHIDEPOGOIZER_REV0_MAJ_SHIFT)
#define  IHIDEPOGOIZER_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~IHIDEPOGOIZER_REV0_MAJ_MASK) | (((uint32_t)val) << IHIDEPOGOIZER_REV0_MAJ_SHIFT))

#define  IHIDEPOGOIZER_REV0_MID_MASK 0xffff
#define  IHIDEPOGOIZER_REV0_MID_SHIFT 0
#define  IHIDEPOGOIZER_REV0_MID_MASK_SHIFT(reg) (((reg) & IHIDEPOGOIZER_REV0_MID_MASK) >> IHIDEPOGOIZER_REV0_MID_SHIFT)
#define  IHIDEPOGOIZER_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~IHIDEPOGOIZER_REV0_MID_MASK) | (((uint32_t)val) << IHIDEPOGOIZER_REV0_MID_SHIFT))

//====================================================================
//Register: IP Tagging Revision 1 (REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  IHIDEPOGOIZER_REV1_RESERVED1_MASK 0xffff0000
#define  IHIDEPOGOIZER_REV1_RESERVED1_SHIFT 16
#define  IHIDEPOGOIZER_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & IHIDEPOGOIZER_REV1_RESERVED1_MASK) >> IHIDEPOGOIZER_REV1_RESERVED1_SHIFT)
#define  IHIDEPOGOIZER_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IHIDEPOGOIZER_REV1_RESERVED1_MASK) | (((uint32_t)val) << IHIDEPOGOIZER_REV1_RESERVED1_SHIFT))

#define  IHIDEPOGOIZER_REV1_CFG_MASK 0xffff
#define  IHIDEPOGOIZER_REV1_CFG_SHIFT 0
#define  IHIDEPOGOIZER_REV1_CFG_MASK_SHIFT(reg) (((reg) & IHIDEPOGOIZER_REV1_CFG_MASK) >> IHIDEPOGOIZER_REV1_CFG_SHIFT)
#define  IHIDEPOGOIZER_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~IHIDEPOGOIZER_REV1_CFG_MASK) | (((uint32_t)val) << IHIDEPOGOIZER_REV1_CFG_SHIFT))

//====================================================================
//
//Register File: PIE Write IHI DMA (POGO_IHI_ODMA)
//
//====================================================================

//====================================================================
//
//Register File: POGO_IDMA_UDMA (POGO_IDMA0_POGO_IDMA_UDMA)
//
//====================================================================

//====================================================================
//Register: UDMA Configuration Register (UCR)
//====================================================================

#define  POGO_IDMA0_POGO_IDMA_UDMA_UCR_RESERVED1_MASK 0xfff00000
#define  POGO_IDMA0_POGO_IDMA_UDMA_UCR_RESERVED1_SHIFT 20
#define  POGO_IDMA0_POGO_IDMA_UDMA_UCR_RESERVED1_MASK_SHIFT(reg) (((reg) & POGO_IDMA0_POGO_IDMA_UDMA_UCR_RESERVED1_MASK) >> POGO_IDMA0_POGO_IDMA_UDMA_UCR_RESERVED1_SHIFT)
#define  POGO_IDMA0_POGO_IDMA_UDMA_UCR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA0_POGO_IDMA_UDMA_UCR_RESERVED1_MASK) | (((uint32_t)val) << POGO_IDMA0_POGO_IDMA_UDMA_UCR_RESERVED1_SHIFT))

#define  POGO_IDMA0_POGO_IDMA_UDMA_UCR_DATAAXCACHE_MASK 0xf0000
#define  POGO_IDMA0_POGO_IDMA_UDMA_UCR_DATAAXCACHE_SHIFT 16
#define  POGO_IDMA0_POGO_IDMA_UDMA_UCR_DATAAXCACHE_MASK_SHIFT(reg) (((reg) & POGO_IDMA0_POGO_IDMA_UDMA_UCR_DATAAXCACHE_MASK) >> POGO_IDMA0_POGO_IDMA_UDMA_UCR_DATAAXCACHE_SHIFT)
#define  POGO_IDMA0_POGO_IDMA_UDMA_UCR_DATAAXCACHE_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA0_POGO_IDMA_UDMA_UCR_DATAAXCACHE_MASK) | (((uint32_t)val) << POGO_IDMA0_POGO_IDMA_UDMA_UCR_DATAAXCACHE_SHIFT))

#define  POGO_IDMA0_POGO_IDMA_UDMA_UCR_DESCARCACHE_MASK 0xf000
#define  POGO_IDMA0_POGO_IDMA_UDMA_UCR_DESCARCACHE_SHIFT 12
#define  POGO_IDMA0_POGO_IDMA_UDMA_UCR_DESCARCACHE_MASK_SHIFT(reg) (((reg) & POGO_IDMA0_POGO_IDMA_UDMA_UCR_DESCARCACHE_MASK) >> POGO_IDMA0_POGO_IDMA_UDMA_UCR_DESCARCACHE_SHIFT)
#define  POGO_IDMA0_POGO_IDMA_UDMA_UCR_DESCARCACHE_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA0_POGO_IDMA_UDMA_UCR_DESCARCACHE_MASK) | (((uint32_t)val) << POGO_IDMA0_POGO_IDMA_UDMA_UCR_DESCARCACHE_SHIFT))

#define  POGO_IDMA0_POGO_IDMA_UDMA_UCR_DESCAWCACHE_MASK 0xf00
#define  POGO_IDMA0_POGO_IDMA_UDMA_UCR_DESCAWCACHE_SHIFT 8
#define  POGO_IDMA0_POGO_IDMA_UDMA_UCR_DESCAWCACHE_MASK_SHIFT(reg) (((reg) & POGO_IDMA0_POGO_IDMA_UDMA_UCR_DESCAWCACHE_MASK) >> POGO_IDMA0_POGO_IDMA_UDMA_UCR_DESCAWCACHE_SHIFT)
#define  POGO_IDMA0_POGO_IDMA_UDMA_UCR_DESCAWCACHE_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA0_POGO_IDMA_UDMA_UCR_DESCAWCACHE_MASK) | (((uint32_t)val) << POGO_IDMA0_POGO_IDMA_UDMA_UCR_DESCAWCACHE_SHIFT))

#define  POGO_IDMA0_POGO_IDMA_UDMA_UCR_RESERVED2_MASK 0xc0
#define  POGO_IDMA0_POGO_IDMA_UDMA_UCR_RESERVED2_SHIFT 6
#define  POGO_IDMA0_POGO_IDMA_UDMA_UCR_RESERVED2_MASK_SHIFT(reg) (((reg) & POGO_IDMA0_POGO_IDMA_UDMA_UCR_RESERVED2_MASK) >> POGO_IDMA0_POGO_IDMA_UDMA_UCR_RESERVED2_SHIFT)
#define  POGO_IDMA0_POGO_IDMA_UDMA_UCR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA0_POGO_IDMA_UDMA_UCR_RESERVED2_MASK) | (((uint32_t)val) << POGO_IDMA0_POGO_IDMA_UDMA_UCR_RESERVED2_SHIFT))

#define  POGO_IDMA0_POGO_IDMA_UDMA_UCR_HANDSHAKEENABLE_MASK 0x20
#define  POGO_IDMA0_POGO_IDMA_UDMA_UCR_HANDSHAKEENABLE_SHIFT 5
#define  POGO_IDMA0_POGO_IDMA_UDMA_UCR_HANDSHAKEENABLE_MASK_SHIFT(reg) (((reg) & POGO_IDMA0_POGO_IDMA_UDMA_UCR_HANDSHAKEENABLE_MASK) >> POGO_IDMA0_POGO_IDMA_UDMA_UCR_HANDSHAKEENABLE_SHIFT)
#define  POGO_IDMA0_POGO_IDMA_UDMA_UCR_HANDSHAKEENABLE_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA0_POGO_IDMA_UDMA_UCR_HANDSHAKEENABLE_MASK) | (((uint32_t)val) << POGO_IDMA0_POGO_IDMA_UDMA_UCR_HANDSHAKEENABLE_SHIFT))

#define  POGO_IDMA0_POGO_IDMA_UDMA_UCR_OWNWRITEDISABLE_MASK 0x10
#define  POGO_IDMA0_POGO_IDMA_UDMA_UCR_OWNWRITEDISABLE_SHIFT 4
#define  POGO_IDMA0_POGO_IDMA_UDMA_UCR_OWNWRITEDISABLE_MASK_SHIFT(reg) (((reg) & POGO_IDMA0_POGO_IDMA_UDMA_UCR_OWNWRITEDISABLE_MASK) >> POGO_IDMA0_POGO_IDMA_UDMA_UCR_OWNWRITEDISABLE_SHIFT)
#define  POGO_IDMA0_POGO_IDMA_UDMA_UCR_OWNWRITEDISABLE_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA0_POGO_IDMA_UDMA_UCR_OWNWRITEDISABLE_MASK) | (((uint32_t)val) << POGO_IDMA0_POGO_IDMA_UDMA_UCR_OWNWRITEDISABLE_SHIFT))

#define  POGO_IDMA0_POGO_IDMA_UDMA_UCR_OWNPOLARITY_MASK 0x8
#define  POGO_IDMA0_POGO_IDMA_UDMA_UCR_OWNPOLARITY_SHIFT 3
#define  POGO_IDMA0_POGO_IDMA_UDMA_UCR_OWNPOLARITY_MASK_SHIFT(reg) (((reg) & POGO_IDMA0_POGO_IDMA_UDMA_UCR_OWNPOLARITY_MASK) >> POGO_IDMA0_POGO_IDMA_UDMA_UCR_OWNPOLARITY_SHIFT)
#define  POGO_IDMA0_POGO_IDMA_UDMA_UCR_OWNPOLARITY_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA0_POGO_IDMA_UDMA_UCR_OWNPOLARITY_MASK) | (((uint32_t)val) << POGO_IDMA0_POGO_IDMA_UDMA_UCR_OWNPOLARITY_SHIFT))

#define  POGO_IDMA0_POGO_IDMA_UDMA_UCR_BEATS_MASK 0x6
#define  POGO_IDMA0_POGO_IDMA_UDMA_UCR_BEATS_SHIFT 1
#define  POGO_IDMA0_POGO_IDMA_UDMA_UCR_BEATS_MASK_SHIFT(reg) (((reg) & POGO_IDMA0_POGO_IDMA_UDMA_UCR_BEATS_MASK) >> POGO_IDMA0_POGO_IDMA_UDMA_UCR_BEATS_SHIFT)
#define  POGO_IDMA0_POGO_IDMA_UDMA_UCR_BEATS_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA0_POGO_IDMA_UDMA_UCR_BEATS_MASK) | (((uint32_t)val) << POGO_IDMA0_POGO_IDMA_UDMA_UCR_BEATS_SHIFT))

#define  POGO_IDMA0_POGO_IDMA_UDMA_UCR_ENABLE_MASK 0x1
#define  POGO_IDMA0_POGO_IDMA_UDMA_UCR_ENABLE_SHIFT 0
#define  POGO_IDMA0_POGO_IDMA_UDMA_UCR_ENABLE_MASK_SHIFT(reg) (((reg) & POGO_IDMA0_POGO_IDMA_UDMA_UCR_ENABLE_MASK) >> POGO_IDMA0_POGO_IDMA_UDMA_UCR_ENABLE_SHIFT)
#define  POGO_IDMA0_POGO_IDMA_UDMA_UCR_ENABLE_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA0_POGO_IDMA_UDMA_UCR_ENABLE_MASK) | (((uint32_t)val) << POGO_IDMA0_POGO_IDMA_UDMA_UCR_ENABLE_SHIFT))

//====================================================================
//Register: UDMA Status Register (USR)
//====================================================================

#define  POGO_IDMA0_POGO_IDMA_UDMA_USR_RESERVED1_MASK 0xfffff800
#define  POGO_IDMA0_POGO_IDMA_UDMA_USR_RESERVED1_SHIFT 11
#define  POGO_IDMA0_POGO_IDMA_UDMA_USR_RESERVED1_MASK_SHIFT(reg) (((reg) & POGO_IDMA0_POGO_IDMA_UDMA_USR_RESERVED1_MASK) >> POGO_IDMA0_POGO_IDMA_UDMA_USR_RESERVED1_SHIFT)
#define  POGO_IDMA0_POGO_IDMA_UDMA_USR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA0_POGO_IDMA_UDMA_USR_RESERVED1_MASK) | (((uint32_t)val) << POGO_IDMA0_POGO_IDMA_UDMA_USR_RESERVED1_SHIFT))

#define  POGO_IDMA0_POGO_IDMA_UDMA_USR_DMAPAUSED_MASK 0x400
#define  POGO_IDMA0_POGO_IDMA_UDMA_USR_DMAPAUSED_SHIFT 10
#define  POGO_IDMA0_POGO_IDMA_UDMA_USR_DMAPAUSED_MASK_SHIFT(reg) (((reg) & POGO_IDMA0_POGO_IDMA_UDMA_USR_DMAPAUSED_MASK) >> POGO_IDMA0_POGO_IDMA_UDMA_USR_DMAPAUSED_SHIFT)
#define  POGO_IDMA0_POGO_IDMA_UDMA_USR_DMAPAUSED_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA0_POGO_IDMA_UDMA_USR_DMAPAUSED_MASK) | (((uint32_t)val) << POGO_IDMA0_POGO_IDMA_UDMA_USR_DMAPAUSED_SHIFT))

#define  POGO_IDMA0_POGO_IDMA_UDMA_USR_PAUSEAFTER_MASK 0x200
#define  POGO_IDMA0_POGO_IDMA_UDMA_USR_PAUSEAFTER_SHIFT 9
#define  POGO_IDMA0_POGO_IDMA_UDMA_USR_PAUSEAFTER_MASK_SHIFT(reg) (((reg) & POGO_IDMA0_POGO_IDMA_UDMA_USR_PAUSEAFTER_MASK) >> POGO_IDMA0_POGO_IDMA_UDMA_USR_PAUSEAFTER_SHIFT)
#define  POGO_IDMA0_POGO_IDMA_UDMA_USR_PAUSEAFTER_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA0_POGO_IDMA_UDMA_USR_PAUSEAFTER_MASK) | (((uint32_t)val) << POGO_IDMA0_POGO_IDMA_UDMA_USR_PAUSEAFTER_SHIFT))

#define  POGO_IDMA0_POGO_IDMA_UDMA_USR_PAUSEBEFORE_MASK 0x100
#define  POGO_IDMA0_POGO_IDMA_UDMA_USR_PAUSEBEFORE_SHIFT 8
#define  POGO_IDMA0_POGO_IDMA_UDMA_USR_PAUSEBEFORE_MASK_SHIFT(reg) (((reg) & POGO_IDMA0_POGO_IDMA_UDMA_USR_PAUSEBEFORE_MASK) >> POGO_IDMA0_POGO_IDMA_UDMA_USR_PAUSEBEFORE_SHIFT)
#define  POGO_IDMA0_POGO_IDMA_UDMA_USR_PAUSEBEFORE_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA0_POGO_IDMA_UDMA_USR_PAUSEBEFORE_MASK) | (((uint32_t)val) << POGO_IDMA0_POGO_IDMA_UDMA_USR_PAUSEBEFORE_SHIFT))

#define  POGO_IDMA0_POGO_IDMA_UDMA_USR_INTONFINISH_MASK 0x80
#define  POGO_IDMA0_POGO_IDMA_UDMA_USR_INTONFINISH_SHIFT 7
#define  POGO_IDMA0_POGO_IDMA_UDMA_USR_INTONFINISH_MASK_SHIFT(reg) (((reg) & POGO_IDMA0_POGO_IDMA_UDMA_USR_INTONFINISH_MASK) >> POGO_IDMA0_POGO_IDMA_UDMA_USR_INTONFINISH_SHIFT)
#define  POGO_IDMA0_POGO_IDMA_UDMA_USR_INTONFINISH_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA0_POGO_IDMA_UDMA_USR_INTONFINISH_MASK) | (((uint32_t)val) << POGO_IDMA0_POGO_IDMA_UDMA_USR_INTONFINISH_SHIFT))

#define  POGO_IDMA0_POGO_IDMA_UDMA_USR_STOPONFINISH_MASK 0x40
#define  POGO_IDMA0_POGO_IDMA_UDMA_USR_STOPONFINISH_SHIFT 6
#define  POGO_IDMA0_POGO_IDMA_UDMA_USR_STOPONFINISH_MASK_SHIFT(reg) (((reg) & POGO_IDMA0_POGO_IDMA_UDMA_USR_STOPONFINISH_MASK) >> POGO_IDMA0_POGO_IDMA_UDMA_USR_STOPONFINISH_SHIFT)
#define  POGO_IDMA0_POGO_IDMA_UDMA_USR_STOPONFINISH_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA0_POGO_IDMA_UDMA_USR_STOPONFINISH_MASK) | (((uint32_t)val) << POGO_IDMA0_POGO_IDMA_UDMA_USR_STOPONFINISH_SHIFT))

#define  POGO_IDMA0_POGO_IDMA_UDMA_USR_CMDBUFFULL_MASK 0x20
#define  POGO_IDMA0_POGO_IDMA_UDMA_USR_CMDBUFFULL_SHIFT 5
#define  POGO_IDMA0_POGO_IDMA_UDMA_USR_CMDBUFFULL_MASK_SHIFT(reg) (((reg) & POGO_IDMA0_POGO_IDMA_UDMA_USR_CMDBUFFULL_MASK) >> POGO_IDMA0_POGO_IDMA_UDMA_USR_CMDBUFFULL_SHIFT)
#define  POGO_IDMA0_POGO_IDMA_UDMA_USR_CMDBUFFULL_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA0_POGO_IDMA_UDMA_USR_CMDBUFFULL_MASK) | (((uint32_t)val) << POGO_IDMA0_POGO_IDMA_UDMA_USR_CMDBUFFULL_SHIFT))

#define  POGO_IDMA0_POGO_IDMA_UDMA_USR_CMDBUFEMPTY_MASK 0x10
#define  POGO_IDMA0_POGO_IDMA_UDMA_USR_CMDBUFEMPTY_SHIFT 4
#define  POGO_IDMA0_POGO_IDMA_UDMA_USR_CMDBUFEMPTY_MASK_SHIFT(reg) (((reg) & POGO_IDMA0_POGO_IDMA_UDMA_USR_CMDBUFEMPTY_MASK) >> POGO_IDMA0_POGO_IDMA_UDMA_USR_CMDBUFEMPTY_SHIFT)
#define  POGO_IDMA0_POGO_IDMA_UDMA_USR_CMDBUFEMPTY_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA0_POGO_IDMA_UDMA_USR_CMDBUFEMPTY_MASK) | (((uint32_t)val) << POGO_IDMA0_POGO_IDMA_UDMA_USR_CMDBUFEMPTY_SHIFT))

#define  POGO_IDMA0_POGO_IDMA_UDMA_USR_DATABUFFULL_MASK 0x8
#define  POGO_IDMA0_POGO_IDMA_UDMA_USR_DATABUFFULL_SHIFT 3
#define  POGO_IDMA0_POGO_IDMA_UDMA_USR_DATABUFFULL_MASK_SHIFT(reg) (((reg) & POGO_IDMA0_POGO_IDMA_UDMA_USR_DATABUFFULL_MASK) >> POGO_IDMA0_POGO_IDMA_UDMA_USR_DATABUFFULL_SHIFT)
#define  POGO_IDMA0_POGO_IDMA_UDMA_USR_DATABUFFULL_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA0_POGO_IDMA_UDMA_USR_DATABUFFULL_MASK) | (((uint32_t)val) << POGO_IDMA0_POGO_IDMA_UDMA_USR_DATABUFFULL_SHIFT))

#define  POGO_IDMA0_POGO_IDMA_UDMA_USR_DATABUFEMPTY_MASK 0x4
#define  POGO_IDMA0_POGO_IDMA_UDMA_USR_DATABUFEMPTY_SHIFT 2
#define  POGO_IDMA0_POGO_IDMA_UDMA_USR_DATABUFEMPTY_MASK_SHIFT(reg) (((reg) & POGO_IDMA0_POGO_IDMA_UDMA_USR_DATABUFEMPTY_MASK) >> POGO_IDMA0_POGO_IDMA_UDMA_USR_DATABUFEMPTY_SHIFT)
#define  POGO_IDMA0_POGO_IDMA_UDMA_USR_DATABUFEMPTY_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA0_POGO_IDMA_UDMA_USR_DATABUFEMPTY_MASK) | (((uint32_t)val) << POGO_IDMA0_POGO_IDMA_UDMA_USR_DATABUFEMPTY_SHIFT))

#define  POGO_IDMA0_POGO_IDMA_UDMA_USR_CLEAR_MASK 0x2
#define  POGO_IDMA0_POGO_IDMA_UDMA_USR_CLEAR_SHIFT 1
#define  POGO_IDMA0_POGO_IDMA_UDMA_USR_CLEAR_MASK_SHIFT(reg) (((reg) & POGO_IDMA0_POGO_IDMA_UDMA_USR_CLEAR_MASK) >> POGO_IDMA0_POGO_IDMA_UDMA_USR_CLEAR_SHIFT)
#define  POGO_IDMA0_POGO_IDMA_UDMA_USR_CLEAR_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA0_POGO_IDMA_UDMA_USR_CLEAR_MASK) | (((uint32_t)val) << POGO_IDMA0_POGO_IDMA_UDMA_USR_CLEAR_SHIFT))

#define  POGO_IDMA0_POGO_IDMA_UDMA_USR_BUSY_MASK 0x1
#define  POGO_IDMA0_POGO_IDMA_UDMA_USR_BUSY_SHIFT 0
#define  POGO_IDMA0_POGO_IDMA_UDMA_USR_BUSY_MASK_SHIFT(reg) (((reg) & POGO_IDMA0_POGO_IDMA_UDMA_USR_BUSY_MASK) >> POGO_IDMA0_POGO_IDMA_UDMA_USR_BUSY_SHIFT)
#define  POGO_IDMA0_POGO_IDMA_UDMA_USR_BUSY_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA0_POGO_IDMA_UDMA_USR_BUSY_MASK) | (((uint32_t)val) << POGO_IDMA0_POGO_IDMA_UDMA_USR_BUSY_SHIFT))

//====================================================================
//Register: UDMA Parameter Register (UPR)
//====================================================================

#define  POGO_IDMA0_POGO_IDMA_UDMA_UPR_RESERVED1_MASK 0xff000000
#define  POGO_IDMA0_POGO_IDMA_UDMA_UPR_RESERVED1_SHIFT 24
#define  POGO_IDMA0_POGO_IDMA_UDMA_UPR_RESERVED1_MASK_SHIFT(reg) (((reg) & POGO_IDMA0_POGO_IDMA_UDMA_UPR_RESERVED1_MASK) >> POGO_IDMA0_POGO_IDMA_UDMA_UPR_RESERVED1_SHIFT)
#define  POGO_IDMA0_POGO_IDMA_UDMA_UPR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA0_POGO_IDMA_UDMA_UPR_RESERVED1_MASK) | (((uint32_t)val) << POGO_IDMA0_POGO_IDMA_UDMA_UPR_RESERVED1_SHIFT))

#define  POGO_IDMA0_POGO_IDMA_UDMA_UPR_FIFODEPTH_MASK 0xffff00
#define  POGO_IDMA0_POGO_IDMA_UDMA_UPR_FIFODEPTH_SHIFT 8
#define  POGO_IDMA0_POGO_IDMA_UDMA_UPR_FIFODEPTH_MASK_SHIFT(reg) (((reg) & POGO_IDMA0_POGO_IDMA_UDMA_UPR_FIFODEPTH_MASK) >> POGO_IDMA0_POGO_IDMA_UDMA_UPR_FIFODEPTH_SHIFT)
#define  POGO_IDMA0_POGO_IDMA_UDMA_UPR_FIFODEPTH_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA0_POGO_IDMA_UDMA_UPR_FIFODEPTH_MASK) | (((uint32_t)val) << POGO_IDMA0_POGO_IDMA_UDMA_UPR_FIFODEPTH_SHIFT))

#define  POGO_IDMA0_POGO_IDMA_UDMA_UPR_RESERVED2_MASK 0xe0
#define  POGO_IDMA0_POGO_IDMA_UDMA_UPR_RESERVED2_SHIFT 5
#define  POGO_IDMA0_POGO_IDMA_UDMA_UPR_RESERVED2_MASK_SHIFT(reg) (((reg) & POGO_IDMA0_POGO_IDMA_UDMA_UPR_RESERVED2_MASK) >> POGO_IDMA0_POGO_IDMA_UDMA_UPR_RESERVED2_SHIFT)
#define  POGO_IDMA0_POGO_IDMA_UDMA_UPR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA0_POGO_IDMA_UDMA_UPR_RESERVED2_MASK) | (((uint32_t)val) << POGO_IDMA0_POGO_IDMA_UDMA_UPR_RESERVED2_SHIFT))

#define  POGO_IDMA0_POGO_IDMA_UDMA_UPR_SERPSUPPORT_MASK 0x10
#define  POGO_IDMA0_POGO_IDMA_UDMA_UPR_SERPSUPPORT_SHIFT 4
#define  POGO_IDMA0_POGO_IDMA_UDMA_UPR_SERPSUPPORT_MASK_SHIFT(reg) (((reg) & POGO_IDMA0_POGO_IDMA_UDMA_UPR_SERPSUPPORT_MASK) >> POGO_IDMA0_POGO_IDMA_UDMA_UPR_SERPSUPPORT_SHIFT)
#define  POGO_IDMA0_POGO_IDMA_UDMA_UPR_SERPSUPPORT_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA0_POGO_IDMA_UDMA_UPR_SERPSUPPORT_MASK) | (((uint32_t)val) << POGO_IDMA0_POGO_IDMA_UDMA_UPR_SERPSUPPORT_SHIFT))

#define  POGO_IDMA0_POGO_IDMA_UDMA_UPR_DESCLENGTH_MASK 0x8
#define  POGO_IDMA0_POGO_IDMA_UDMA_UPR_DESCLENGTH_SHIFT 3
#define  POGO_IDMA0_POGO_IDMA_UDMA_UPR_DESCLENGTH_MASK_SHIFT(reg) (((reg) & POGO_IDMA0_POGO_IDMA_UDMA_UPR_DESCLENGTH_MASK) >> POGO_IDMA0_POGO_IDMA_UDMA_UPR_DESCLENGTH_SHIFT)
#define  POGO_IDMA0_POGO_IDMA_UDMA_UPR_DESCLENGTH_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA0_POGO_IDMA_UDMA_UPR_DESCLENGTH_MASK) | (((uint32_t)val) << POGO_IDMA0_POGO_IDMA_UDMA_UPR_DESCLENGTH_SHIFT))

#define  POGO_IDMA0_POGO_IDMA_UDMA_UPR_BUSWIDTH_MASK 0x4
#define  POGO_IDMA0_POGO_IDMA_UDMA_UPR_BUSWIDTH_SHIFT 2
#define  POGO_IDMA0_POGO_IDMA_UDMA_UPR_BUSWIDTH_MASK_SHIFT(reg) (((reg) & POGO_IDMA0_POGO_IDMA_UDMA_UPR_BUSWIDTH_MASK) >> POGO_IDMA0_POGO_IDMA_UDMA_UPR_BUSWIDTH_SHIFT)
#define  POGO_IDMA0_POGO_IDMA_UDMA_UPR_BUSWIDTH_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA0_POGO_IDMA_UDMA_UPR_BUSWIDTH_MASK) | (((uint32_t)val) << POGO_IDMA0_POGO_IDMA_UDMA_UPR_BUSWIDTH_SHIFT))

#define  POGO_IDMA0_POGO_IDMA_UDMA_UPR_MEMALIGN_MASK 0x3
#define  POGO_IDMA0_POGO_IDMA_UDMA_UPR_MEMALIGN_SHIFT 0
#define  POGO_IDMA0_POGO_IDMA_UDMA_UPR_MEMALIGN_MASK_SHIFT(reg) (((reg) & POGO_IDMA0_POGO_IDMA_UDMA_UPR_MEMALIGN_MASK) >> POGO_IDMA0_POGO_IDMA_UDMA_UPR_MEMALIGN_SHIFT)
#define  POGO_IDMA0_POGO_IDMA_UDMA_UPR_MEMALIGN_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA0_POGO_IDMA_UDMA_UPR_MEMALIGN_MASK) | (((uint32_t)val) << POGO_IDMA0_POGO_IDMA_UDMA_UPR_MEMALIGN_SHIFT))

//====================================================================
//Register: UDMA Interrupt Enable Register (UIER)
//====================================================================

#define  POGO_IDMA0_POGO_IDMA_UDMA_UIER_RESERVED1_MASK 0xffffffc0
#define  POGO_IDMA0_POGO_IDMA_UDMA_UIER_RESERVED1_SHIFT 6
#define  POGO_IDMA0_POGO_IDMA_UDMA_UIER_RESERVED1_MASK_SHIFT(reg) (((reg) & POGO_IDMA0_POGO_IDMA_UDMA_UIER_RESERVED1_MASK) >> POGO_IDMA0_POGO_IDMA_UDMA_UIER_RESERVED1_SHIFT)
#define  POGO_IDMA0_POGO_IDMA_UDMA_UIER_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA0_POGO_IDMA_UDMA_UIER_RESERVED1_MASK) | (((uint32_t)val) << POGO_IDMA0_POGO_IDMA_UDMA_UIER_RESERVED1_SHIFT))

#define  POGO_IDMA0_POGO_IDMA_UDMA_UIER_OUTOFRANGE_MASK 0x20
#define  POGO_IDMA0_POGO_IDMA_UDMA_UIER_OUTOFRANGE_SHIFT 5
#define  POGO_IDMA0_POGO_IDMA_UDMA_UIER_OUTOFRANGE_MASK_SHIFT(reg) (((reg) & POGO_IDMA0_POGO_IDMA_UDMA_UIER_OUTOFRANGE_MASK) >> POGO_IDMA0_POGO_IDMA_UDMA_UIER_OUTOFRANGE_SHIFT)
#define  POGO_IDMA0_POGO_IDMA_UDMA_UIER_OUTOFRANGE_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA0_POGO_IDMA_UDMA_UIER_OUTOFRANGE_MASK) | (((uint32_t)val) << POGO_IDMA0_POGO_IDMA_UDMA_UIER_OUTOFRANGE_SHIFT))

#define  POGO_IDMA0_POGO_IDMA_UDMA_UIER_RRESP_MASK 0x10
#define  POGO_IDMA0_POGO_IDMA_UDMA_UIER_RRESP_SHIFT 4
#define  POGO_IDMA0_POGO_IDMA_UDMA_UIER_RRESP_MASK_SHIFT(reg) (((reg) & POGO_IDMA0_POGO_IDMA_UDMA_UIER_RRESP_MASK) >> POGO_IDMA0_POGO_IDMA_UDMA_UIER_RRESP_SHIFT)
#define  POGO_IDMA0_POGO_IDMA_UDMA_UIER_RRESP_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA0_POGO_IDMA_UDMA_UIER_RRESP_MASK) | (((uint32_t)val) << POGO_IDMA0_POGO_IDMA_UDMA_UIER_RRESP_SHIFT))

#define  POGO_IDMA0_POGO_IDMA_UDMA_UIER_BRESP_MASK 0x8
#define  POGO_IDMA0_POGO_IDMA_UDMA_UIER_BRESP_SHIFT 3
#define  POGO_IDMA0_POGO_IDMA_UDMA_UIER_BRESP_MASK_SHIFT(reg) (((reg) & POGO_IDMA0_POGO_IDMA_UDMA_UIER_BRESP_MASK) >> POGO_IDMA0_POGO_IDMA_UDMA_UIER_BRESP_SHIFT)
#define  POGO_IDMA0_POGO_IDMA_UDMA_UIER_BRESP_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA0_POGO_IDMA_UDMA_UIER_BRESP_MASK) | (((uint32_t)val) << POGO_IDMA0_POGO_IDMA_UDMA_UIER_BRESP_SHIFT))

#define  POGO_IDMA0_POGO_IDMA_UDMA_UIER_CLEARCOMPLETE_MASK 0x4
#define  POGO_IDMA0_POGO_IDMA_UDMA_UIER_CLEARCOMPLETE_SHIFT 2
#define  POGO_IDMA0_POGO_IDMA_UDMA_UIER_CLEARCOMPLETE_MASK_SHIFT(reg) (((reg) & POGO_IDMA0_POGO_IDMA_UDMA_UIER_CLEARCOMPLETE_MASK) >> POGO_IDMA0_POGO_IDMA_UDMA_UIER_CLEARCOMPLETE_SHIFT)
#define  POGO_IDMA0_POGO_IDMA_UDMA_UIER_CLEARCOMPLETE_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA0_POGO_IDMA_UDMA_UIER_CLEARCOMPLETE_MASK) | (((uint32_t)val) << POGO_IDMA0_POGO_IDMA_UDMA_UIER_CLEARCOMPLETE_SHIFT))

#define  POGO_IDMA0_POGO_IDMA_UDMA_UIER_DESC_MASK 0x2
#define  POGO_IDMA0_POGO_IDMA_UDMA_UIER_DESC_SHIFT 1
#define  POGO_IDMA0_POGO_IDMA_UDMA_UIER_DESC_MASK_SHIFT(reg) (((reg) & POGO_IDMA0_POGO_IDMA_UDMA_UIER_DESC_MASK) >> POGO_IDMA0_POGO_IDMA_UDMA_UIER_DESC_SHIFT)
#define  POGO_IDMA0_POGO_IDMA_UDMA_UIER_DESC_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA0_POGO_IDMA_UDMA_UIER_DESC_MASK) | (((uint32_t)val) << POGO_IDMA0_POGO_IDMA_UDMA_UIER_DESC_SHIFT))

#define  POGO_IDMA0_POGO_IDMA_UDMA_UIER_OWN_MASK 0x1
#define  POGO_IDMA0_POGO_IDMA_UDMA_UIER_OWN_SHIFT 0
#define  POGO_IDMA0_POGO_IDMA_UDMA_UIER_OWN_MASK_SHIFT(reg) (((reg) & POGO_IDMA0_POGO_IDMA_UDMA_UIER_OWN_MASK) >> POGO_IDMA0_POGO_IDMA_UDMA_UIER_OWN_SHIFT)
#define  POGO_IDMA0_POGO_IDMA_UDMA_UIER_OWN_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA0_POGO_IDMA_UDMA_UIER_OWN_MASK) | (((uint32_t)val) << POGO_IDMA0_POGO_IDMA_UDMA_UIER_OWN_SHIFT))

//====================================================================
//Register: UDMA Interrupt Pending Register (UIPR)
//====================================================================

#define  POGO_IDMA0_POGO_IDMA_UDMA_UIPR_RESERVED1_MASK 0xffffffc0
#define  POGO_IDMA0_POGO_IDMA_UDMA_UIPR_RESERVED1_SHIFT 6
#define  POGO_IDMA0_POGO_IDMA_UDMA_UIPR_RESERVED1_MASK_SHIFT(reg) (((reg) & POGO_IDMA0_POGO_IDMA_UDMA_UIPR_RESERVED1_MASK) >> POGO_IDMA0_POGO_IDMA_UDMA_UIPR_RESERVED1_SHIFT)
#define  POGO_IDMA0_POGO_IDMA_UDMA_UIPR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA0_POGO_IDMA_UDMA_UIPR_RESERVED1_MASK) | (((uint32_t)val) << POGO_IDMA0_POGO_IDMA_UDMA_UIPR_RESERVED1_SHIFT))

#define  POGO_IDMA0_POGO_IDMA_UDMA_UIPR_OUTOFRANGE_MASK 0x20
#define  POGO_IDMA0_POGO_IDMA_UDMA_UIPR_OUTOFRANGE_SHIFT 5
#define  POGO_IDMA0_POGO_IDMA_UDMA_UIPR_OUTOFRANGE_MASK_SHIFT(reg) (((reg) & POGO_IDMA0_POGO_IDMA_UDMA_UIPR_OUTOFRANGE_MASK) >> POGO_IDMA0_POGO_IDMA_UDMA_UIPR_OUTOFRANGE_SHIFT)
#define  POGO_IDMA0_POGO_IDMA_UDMA_UIPR_OUTOFRANGE_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA0_POGO_IDMA_UDMA_UIPR_OUTOFRANGE_MASK) | (((uint32_t)val) << POGO_IDMA0_POGO_IDMA_UDMA_UIPR_OUTOFRANGE_SHIFT))

#define  POGO_IDMA0_POGO_IDMA_UDMA_UIPR_RRESP_MASK 0x10
#define  POGO_IDMA0_POGO_IDMA_UDMA_UIPR_RRESP_SHIFT 4
#define  POGO_IDMA0_POGO_IDMA_UDMA_UIPR_RRESP_MASK_SHIFT(reg) (((reg) & POGO_IDMA0_POGO_IDMA_UDMA_UIPR_RRESP_MASK) >> POGO_IDMA0_POGO_IDMA_UDMA_UIPR_RRESP_SHIFT)
#define  POGO_IDMA0_POGO_IDMA_UDMA_UIPR_RRESP_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA0_POGO_IDMA_UDMA_UIPR_RRESP_MASK) | (((uint32_t)val) << POGO_IDMA0_POGO_IDMA_UDMA_UIPR_RRESP_SHIFT))

#define  POGO_IDMA0_POGO_IDMA_UDMA_UIPR_BRESP_MASK 0x8
#define  POGO_IDMA0_POGO_IDMA_UDMA_UIPR_BRESP_SHIFT 3
#define  POGO_IDMA0_POGO_IDMA_UDMA_UIPR_BRESP_MASK_SHIFT(reg) (((reg) & POGO_IDMA0_POGO_IDMA_UDMA_UIPR_BRESP_MASK) >> POGO_IDMA0_POGO_IDMA_UDMA_UIPR_BRESP_SHIFT)
#define  POGO_IDMA0_POGO_IDMA_UDMA_UIPR_BRESP_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA0_POGO_IDMA_UDMA_UIPR_BRESP_MASK) | (((uint32_t)val) << POGO_IDMA0_POGO_IDMA_UDMA_UIPR_BRESP_SHIFT))

#define  POGO_IDMA0_POGO_IDMA_UDMA_UIPR_CLEARCOMPLETE_MASK 0x4
#define  POGO_IDMA0_POGO_IDMA_UDMA_UIPR_CLEARCOMPLETE_SHIFT 2
#define  POGO_IDMA0_POGO_IDMA_UDMA_UIPR_CLEARCOMPLETE_MASK_SHIFT(reg) (((reg) & POGO_IDMA0_POGO_IDMA_UDMA_UIPR_CLEARCOMPLETE_MASK) >> POGO_IDMA0_POGO_IDMA_UDMA_UIPR_CLEARCOMPLETE_SHIFT)
#define  POGO_IDMA0_POGO_IDMA_UDMA_UIPR_CLEARCOMPLETE_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA0_POGO_IDMA_UDMA_UIPR_CLEARCOMPLETE_MASK) | (((uint32_t)val) << POGO_IDMA0_POGO_IDMA_UDMA_UIPR_CLEARCOMPLETE_SHIFT))

#define  POGO_IDMA0_POGO_IDMA_UDMA_UIPR_DESC_MASK 0x2
#define  POGO_IDMA0_POGO_IDMA_UDMA_UIPR_DESC_SHIFT 1
#define  POGO_IDMA0_POGO_IDMA_UDMA_UIPR_DESC_MASK_SHIFT(reg) (((reg) & POGO_IDMA0_POGO_IDMA_UDMA_UIPR_DESC_MASK) >> POGO_IDMA0_POGO_IDMA_UDMA_UIPR_DESC_SHIFT)
#define  POGO_IDMA0_POGO_IDMA_UDMA_UIPR_DESC_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA0_POGO_IDMA_UDMA_UIPR_DESC_MASK) | (((uint32_t)val) << POGO_IDMA0_POGO_IDMA_UDMA_UIPR_DESC_SHIFT))

#define  POGO_IDMA0_POGO_IDMA_UDMA_UIPR_OWN_MASK 0x1
#define  POGO_IDMA0_POGO_IDMA_UDMA_UIPR_OWN_SHIFT 0
#define  POGO_IDMA0_POGO_IDMA_UDMA_UIPR_OWN_MASK_SHIFT(reg) (((reg) & POGO_IDMA0_POGO_IDMA_UDMA_UIPR_OWN_MASK) >> POGO_IDMA0_POGO_IDMA_UDMA_UIPR_OWN_SHIFT)
#define  POGO_IDMA0_POGO_IDMA_UDMA_UIPR_OWN_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA0_POGO_IDMA_UDMA_UIPR_OWN_MASK) | (((uint32_t)val) << POGO_IDMA0_POGO_IDMA_UDMA_UIPR_OWN_SHIFT))

//====================================================================
//Register: UDMA Interrupt Clear Register (UICR)
//====================================================================

#define  POGO_IDMA0_POGO_IDMA_UDMA_UICR_RESERVED1_MASK 0xffffffc0
#define  POGO_IDMA0_POGO_IDMA_UDMA_UICR_RESERVED1_SHIFT 6
#define  POGO_IDMA0_POGO_IDMA_UDMA_UICR_RESERVED1_MASK_SHIFT(reg) (((reg) & POGO_IDMA0_POGO_IDMA_UDMA_UICR_RESERVED1_MASK) >> POGO_IDMA0_POGO_IDMA_UDMA_UICR_RESERVED1_SHIFT)
#define  POGO_IDMA0_POGO_IDMA_UDMA_UICR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA0_POGO_IDMA_UDMA_UICR_RESERVED1_MASK) | (((uint32_t)val) << POGO_IDMA0_POGO_IDMA_UDMA_UICR_RESERVED1_SHIFT))

#define  POGO_IDMA0_POGO_IDMA_UDMA_UICR_OUTOFRANGE_MASK 0x20
#define  POGO_IDMA0_POGO_IDMA_UDMA_UICR_OUTOFRANGE_SHIFT 5
#define  POGO_IDMA0_POGO_IDMA_UDMA_UICR_OUTOFRANGE_MASK_SHIFT(reg) (((reg) & POGO_IDMA0_POGO_IDMA_UDMA_UICR_OUTOFRANGE_MASK) >> POGO_IDMA0_POGO_IDMA_UDMA_UICR_OUTOFRANGE_SHIFT)
#define  POGO_IDMA0_POGO_IDMA_UDMA_UICR_OUTOFRANGE_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA0_POGO_IDMA_UDMA_UICR_OUTOFRANGE_MASK) | (((uint32_t)val) << POGO_IDMA0_POGO_IDMA_UDMA_UICR_OUTOFRANGE_SHIFT))

#define  POGO_IDMA0_POGO_IDMA_UDMA_UICR_RRESP_MASK 0x10
#define  POGO_IDMA0_POGO_IDMA_UDMA_UICR_RRESP_SHIFT 4
#define  POGO_IDMA0_POGO_IDMA_UDMA_UICR_RRESP_MASK_SHIFT(reg) (((reg) & POGO_IDMA0_POGO_IDMA_UDMA_UICR_RRESP_MASK) >> POGO_IDMA0_POGO_IDMA_UDMA_UICR_RRESP_SHIFT)
#define  POGO_IDMA0_POGO_IDMA_UDMA_UICR_RRESP_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA0_POGO_IDMA_UDMA_UICR_RRESP_MASK) | (((uint32_t)val) << POGO_IDMA0_POGO_IDMA_UDMA_UICR_RRESP_SHIFT))

#define  POGO_IDMA0_POGO_IDMA_UDMA_UICR_BRESP_MASK 0x8
#define  POGO_IDMA0_POGO_IDMA_UDMA_UICR_BRESP_SHIFT 3
#define  POGO_IDMA0_POGO_IDMA_UDMA_UICR_BRESP_MASK_SHIFT(reg) (((reg) & POGO_IDMA0_POGO_IDMA_UDMA_UICR_BRESP_MASK) >> POGO_IDMA0_POGO_IDMA_UDMA_UICR_BRESP_SHIFT)
#define  POGO_IDMA0_POGO_IDMA_UDMA_UICR_BRESP_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA0_POGO_IDMA_UDMA_UICR_BRESP_MASK) | (((uint32_t)val) << POGO_IDMA0_POGO_IDMA_UDMA_UICR_BRESP_SHIFT))

#define  POGO_IDMA0_POGO_IDMA_UDMA_UICR_CLEARCOMPLETE_MASK 0x4
#define  POGO_IDMA0_POGO_IDMA_UDMA_UICR_CLEARCOMPLETE_SHIFT 2
#define  POGO_IDMA0_POGO_IDMA_UDMA_UICR_CLEARCOMPLETE_MASK_SHIFT(reg) (((reg) & POGO_IDMA0_POGO_IDMA_UDMA_UICR_CLEARCOMPLETE_MASK) >> POGO_IDMA0_POGO_IDMA_UDMA_UICR_CLEARCOMPLETE_SHIFT)
#define  POGO_IDMA0_POGO_IDMA_UDMA_UICR_CLEARCOMPLETE_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA0_POGO_IDMA_UDMA_UICR_CLEARCOMPLETE_MASK) | (((uint32_t)val) << POGO_IDMA0_POGO_IDMA_UDMA_UICR_CLEARCOMPLETE_SHIFT))

#define  POGO_IDMA0_POGO_IDMA_UDMA_UICR_DESC_MASK 0x2
#define  POGO_IDMA0_POGO_IDMA_UDMA_UICR_DESC_SHIFT 1
#define  POGO_IDMA0_POGO_IDMA_UDMA_UICR_DESC_MASK_SHIFT(reg) (((reg) & POGO_IDMA0_POGO_IDMA_UDMA_UICR_DESC_MASK) >> POGO_IDMA0_POGO_IDMA_UDMA_UICR_DESC_SHIFT)
#define  POGO_IDMA0_POGO_IDMA_UDMA_UICR_DESC_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA0_POGO_IDMA_UDMA_UICR_DESC_MASK) | (((uint32_t)val) << POGO_IDMA0_POGO_IDMA_UDMA_UICR_DESC_SHIFT))

#define  POGO_IDMA0_POGO_IDMA_UDMA_UICR_OWN_MASK 0x1
#define  POGO_IDMA0_POGO_IDMA_UDMA_UICR_OWN_SHIFT 0
#define  POGO_IDMA0_POGO_IDMA_UDMA_UICR_OWN_MASK_SHIFT(reg) (((reg) & POGO_IDMA0_POGO_IDMA_UDMA_UICR_OWN_MASK) >> POGO_IDMA0_POGO_IDMA_UDMA_UICR_OWN_SHIFT)
#define  POGO_IDMA0_POGO_IDMA_UDMA_UICR_OWN_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA0_POGO_IDMA_UDMA_UICR_OWN_MASK) | (((uint32_t)val) << POGO_IDMA0_POGO_IDMA_UDMA_UICR_OWN_SHIFT))

//====================================================================
//Register: UDMA Interrupt Force Register (UIFR)
//====================================================================

#define  POGO_IDMA0_POGO_IDMA_UDMA_UIFR_RESERVED1_MASK 0xffffffc0
#define  POGO_IDMA0_POGO_IDMA_UDMA_UIFR_RESERVED1_SHIFT 6
#define  POGO_IDMA0_POGO_IDMA_UDMA_UIFR_RESERVED1_MASK_SHIFT(reg) (((reg) & POGO_IDMA0_POGO_IDMA_UDMA_UIFR_RESERVED1_MASK) >> POGO_IDMA0_POGO_IDMA_UDMA_UIFR_RESERVED1_SHIFT)
#define  POGO_IDMA0_POGO_IDMA_UDMA_UIFR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA0_POGO_IDMA_UDMA_UIFR_RESERVED1_MASK) | (((uint32_t)val) << POGO_IDMA0_POGO_IDMA_UDMA_UIFR_RESERVED1_SHIFT))

#define  POGO_IDMA0_POGO_IDMA_UDMA_UIFR_OUTOFRANGE_MASK 0x20
#define  POGO_IDMA0_POGO_IDMA_UDMA_UIFR_OUTOFRANGE_SHIFT 5
#define  POGO_IDMA0_POGO_IDMA_UDMA_UIFR_OUTOFRANGE_MASK_SHIFT(reg) (((reg) & POGO_IDMA0_POGO_IDMA_UDMA_UIFR_OUTOFRANGE_MASK) >> POGO_IDMA0_POGO_IDMA_UDMA_UIFR_OUTOFRANGE_SHIFT)
#define  POGO_IDMA0_POGO_IDMA_UDMA_UIFR_OUTOFRANGE_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA0_POGO_IDMA_UDMA_UIFR_OUTOFRANGE_MASK) | (((uint32_t)val) << POGO_IDMA0_POGO_IDMA_UDMA_UIFR_OUTOFRANGE_SHIFT))

#define  POGO_IDMA0_POGO_IDMA_UDMA_UIFR_RRESP_MASK 0x10
#define  POGO_IDMA0_POGO_IDMA_UDMA_UIFR_RRESP_SHIFT 4
#define  POGO_IDMA0_POGO_IDMA_UDMA_UIFR_RRESP_MASK_SHIFT(reg) (((reg) & POGO_IDMA0_POGO_IDMA_UDMA_UIFR_RRESP_MASK) >> POGO_IDMA0_POGO_IDMA_UDMA_UIFR_RRESP_SHIFT)
#define  POGO_IDMA0_POGO_IDMA_UDMA_UIFR_RRESP_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA0_POGO_IDMA_UDMA_UIFR_RRESP_MASK) | (((uint32_t)val) << POGO_IDMA0_POGO_IDMA_UDMA_UIFR_RRESP_SHIFT))

#define  POGO_IDMA0_POGO_IDMA_UDMA_UIFR_BRESP_MASK 0x8
#define  POGO_IDMA0_POGO_IDMA_UDMA_UIFR_BRESP_SHIFT 3
#define  POGO_IDMA0_POGO_IDMA_UDMA_UIFR_BRESP_MASK_SHIFT(reg) (((reg) & POGO_IDMA0_POGO_IDMA_UDMA_UIFR_BRESP_MASK) >> POGO_IDMA0_POGO_IDMA_UDMA_UIFR_BRESP_SHIFT)
#define  POGO_IDMA0_POGO_IDMA_UDMA_UIFR_BRESP_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA0_POGO_IDMA_UDMA_UIFR_BRESP_MASK) | (((uint32_t)val) << POGO_IDMA0_POGO_IDMA_UDMA_UIFR_BRESP_SHIFT))

#define  POGO_IDMA0_POGO_IDMA_UDMA_UIFR_CLEARCOMPLETE_MASK 0x4
#define  POGO_IDMA0_POGO_IDMA_UDMA_UIFR_CLEARCOMPLETE_SHIFT 2
#define  POGO_IDMA0_POGO_IDMA_UDMA_UIFR_CLEARCOMPLETE_MASK_SHIFT(reg) (((reg) & POGO_IDMA0_POGO_IDMA_UDMA_UIFR_CLEARCOMPLETE_MASK) >> POGO_IDMA0_POGO_IDMA_UDMA_UIFR_CLEARCOMPLETE_SHIFT)
#define  POGO_IDMA0_POGO_IDMA_UDMA_UIFR_CLEARCOMPLETE_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA0_POGO_IDMA_UDMA_UIFR_CLEARCOMPLETE_MASK) | (((uint32_t)val) << POGO_IDMA0_POGO_IDMA_UDMA_UIFR_CLEARCOMPLETE_SHIFT))

#define  POGO_IDMA0_POGO_IDMA_UDMA_UIFR_DESC_MASK 0x2
#define  POGO_IDMA0_POGO_IDMA_UDMA_UIFR_DESC_SHIFT 1
#define  POGO_IDMA0_POGO_IDMA_UDMA_UIFR_DESC_MASK_SHIFT(reg) (((reg) & POGO_IDMA0_POGO_IDMA_UDMA_UIFR_DESC_MASK) >> POGO_IDMA0_POGO_IDMA_UDMA_UIFR_DESC_SHIFT)
#define  POGO_IDMA0_POGO_IDMA_UDMA_UIFR_DESC_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA0_POGO_IDMA_UDMA_UIFR_DESC_MASK) | (((uint32_t)val) << POGO_IDMA0_POGO_IDMA_UDMA_UIFR_DESC_SHIFT))

#define  POGO_IDMA0_POGO_IDMA_UDMA_UIFR_OWN_MASK 0x1
#define  POGO_IDMA0_POGO_IDMA_UDMA_UIFR_OWN_SHIFT 0
#define  POGO_IDMA0_POGO_IDMA_UDMA_UIFR_OWN_MASK_SHIFT(reg) (((reg) & POGO_IDMA0_POGO_IDMA_UDMA_UIFR_OWN_MASK) >> POGO_IDMA0_POGO_IDMA_UDMA_UIFR_OWN_SHIFT)
#define  POGO_IDMA0_POGO_IDMA_UDMA_UIFR_OWN_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA0_POGO_IDMA_UDMA_UIFR_OWN_MASK) | (((uint32_t)val) << POGO_IDMA0_POGO_IDMA_UDMA_UIFR_OWN_SHIFT))

//====================================================================
//Register: UDMA Descriptor Register (UDR)
//====================================================================

#define  POGO_IDMA0_POGO_IDMA_UDMA_UDR_DESC_MASK 0xffffffff
#define  POGO_IDMA0_POGO_IDMA_UDMA_UDR_DESC_SHIFT 0
#define  POGO_IDMA0_POGO_IDMA_UDMA_UDR_DESC_MASK_SHIFT(reg) (((reg) & POGO_IDMA0_POGO_IDMA_UDMA_UDR_DESC_MASK) >> POGO_IDMA0_POGO_IDMA_UDMA_UDR_DESC_SHIFT)
#define  POGO_IDMA0_POGO_IDMA_UDMA_UDR_DESC_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA0_POGO_IDMA_UDMA_UDR_DESC_MASK) | (((uint32_t)val) << POGO_IDMA0_POGO_IDMA_UDMA_UDR_DESC_SHIFT))

//====================================================================
//Register: UDMA Burst Address Register (UBAR)
//====================================================================

#define  POGO_IDMA0_POGO_IDMA_UDMA_UBAR_BURSTADDR_MASK 0xffffffff
#define  POGO_IDMA0_POGO_IDMA_UDMA_UBAR_BURSTADDR_SHIFT 0
#define  POGO_IDMA0_POGO_IDMA_UDMA_UBAR_BURSTADDR_MASK_SHIFT(reg) (((reg) & POGO_IDMA0_POGO_IDMA_UDMA_UBAR_BURSTADDR_MASK) >> POGO_IDMA0_POGO_IDMA_UDMA_UBAR_BURSTADDR_SHIFT)
#define  POGO_IDMA0_POGO_IDMA_UDMA_UBAR_BURSTADDR_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA0_POGO_IDMA_UDMA_UBAR_BURSTADDR_MASK) | (((uint32_t)val) << POGO_IDMA0_POGO_IDMA_UDMA_UBAR_BURSTADDR_SHIFT))

//====================================================================
//Register: UDMA Burst Length Register (UBLR)
//====================================================================

#define  POGO_IDMA0_POGO_IDMA_UDMA_UBLR_RESERVED1_MASK 0xfffffc00
#define  POGO_IDMA0_POGO_IDMA_UDMA_UBLR_RESERVED1_SHIFT 10
#define  POGO_IDMA0_POGO_IDMA_UDMA_UBLR_RESERVED1_MASK_SHIFT(reg) (((reg) & POGO_IDMA0_POGO_IDMA_UDMA_UBLR_RESERVED1_MASK) >> POGO_IDMA0_POGO_IDMA_UDMA_UBLR_RESERVED1_SHIFT)
#define  POGO_IDMA0_POGO_IDMA_UDMA_UBLR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA0_POGO_IDMA_UDMA_UBLR_RESERVED1_MASK) | (((uint32_t)val) << POGO_IDMA0_POGO_IDMA_UDMA_UBLR_RESERVED1_SHIFT))

#define  POGO_IDMA0_POGO_IDMA_UDMA_UBLR_BURSTDIR_MASK 0x200
#define  POGO_IDMA0_POGO_IDMA_UDMA_UBLR_BURSTDIR_SHIFT 9
#define  POGO_IDMA0_POGO_IDMA_UDMA_UBLR_BURSTDIR_MASK_SHIFT(reg) (((reg) & POGO_IDMA0_POGO_IDMA_UDMA_UBLR_BURSTDIR_MASK) >> POGO_IDMA0_POGO_IDMA_UDMA_UBLR_BURSTDIR_SHIFT)
#define  POGO_IDMA0_POGO_IDMA_UDMA_UBLR_BURSTDIR_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA0_POGO_IDMA_UDMA_UBLR_BURSTDIR_MASK) | (((uint32_t)val) << POGO_IDMA0_POGO_IDMA_UDMA_UBLR_BURSTDIR_SHIFT))

#define  POGO_IDMA0_POGO_IDMA_UDMA_UBLR_BURSTLAST_MASK 0x100
#define  POGO_IDMA0_POGO_IDMA_UDMA_UBLR_BURSTLAST_SHIFT 8
#define  POGO_IDMA0_POGO_IDMA_UDMA_UBLR_BURSTLAST_MASK_SHIFT(reg) (((reg) & POGO_IDMA0_POGO_IDMA_UDMA_UBLR_BURSTLAST_MASK) >> POGO_IDMA0_POGO_IDMA_UDMA_UBLR_BURSTLAST_SHIFT)
#define  POGO_IDMA0_POGO_IDMA_UDMA_UBLR_BURSTLAST_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA0_POGO_IDMA_UDMA_UBLR_BURSTLAST_MASK) | (((uint32_t)val) << POGO_IDMA0_POGO_IDMA_UDMA_UBLR_BURSTLAST_SHIFT))

#define  POGO_IDMA0_POGO_IDMA_UDMA_UBLR_BURSTLENGTH_MASK 0xff
#define  POGO_IDMA0_POGO_IDMA_UDMA_UBLR_BURSTLENGTH_SHIFT 0
#define  POGO_IDMA0_POGO_IDMA_UDMA_UBLR_BURSTLENGTH_MASK_SHIFT(reg) (((reg) & POGO_IDMA0_POGO_IDMA_UDMA_UBLR_BURSTLENGTH_MASK) >> POGO_IDMA0_POGO_IDMA_UDMA_UBLR_BURSTLENGTH_SHIFT)
#define  POGO_IDMA0_POGO_IDMA_UDMA_UBLR_BURSTLENGTH_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA0_POGO_IDMA_UDMA_UBLR_BURSTLENGTH_MASK) | (((uint32_t)val) << POGO_IDMA0_POGO_IDMA_UDMA_UBLR_BURSTLENGTH_SHIFT))

//====================================================================
//Register: UDMA Transfer Bytes Remaining Register (UBRR)
//====================================================================

#define  POGO_IDMA0_POGO_IDMA_UDMA_UBRR_BYTESREMAIN_MASK 0xffffffff
#define  POGO_IDMA0_POGO_IDMA_UDMA_UBRR_BYTESREMAIN_SHIFT 0
#define  POGO_IDMA0_POGO_IDMA_UDMA_UBRR_BYTESREMAIN_MASK_SHIFT(reg) (((reg) & POGO_IDMA0_POGO_IDMA_UDMA_UBRR_BYTESREMAIN_MASK) >> POGO_IDMA0_POGO_IDMA_UDMA_UBRR_BYTESREMAIN_SHIFT)
#define  POGO_IDMA0_POGO_IDMA_UDMA_UBRR_BYTESREMAIN_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA0_POGO_IDMA_UDMA_UBRR_BYTESREMAIN_MASK) | (((uint32_t)val) << POGO_IDMA0_POGO_IDMA_UDMA_UBRR_BYTESREMAIN_SHIFT))

//====================================================================
//Register: UDMA Tag Register 0 (UTR0)
//====================================================================

#define  POGO_IDMA0_POGO_IDMA_UDMA_UTR0_TAGMAJ_MASK 0xffff0000
#define  POGO_IDMA0_POGO_IDMA_UDMA_UTR0_TAGMAJ_SHIFT 16
#define  POGO_IDMA0_POGO_IDMA_UDMA_UTR0_TAGMAJ_MASK_SHIFT(reg) (((reg) & POGO_IDMA0_POGO_IDMA_UDMA_UTR0_TAGMAJ_MASK) >> POGO_IDMA0_POGO_IDMA_UDMA_UTR0_TAGMAJ_SHIFT)
#define  POGO_IDMA0_POGO_IDMA_UDMA_UTR0_TAGMAJ_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA0_POGO_IDMA_UDMA_UTR0_TAGMAJ_MASK) | (((uint32_t)val) << POGO_IDMA0_POGO_IDMA_UDMA_UTR0_TAGMAJ_SHIFT))

#define  POGO_IDMA0_POGO_IDMA_UDMA_UTR0_TAGMID_MASK 0xffff
#define  POGO_IDMA0_POGO_IDMA_UDMA_UTR0_TAGMID_SHIFT 0
#define  POGO_IDMA0_POGO_IDMA_UDMA_UTR0_TAGMID_MASK_SHIFT(reg) (((reg) & POGO_IDMA0_POGO_IDMA_UDMA_UTR0_TAGMID_MASK) >> POGO_IDMA0_POGO_IDMA_UDMA_UTR0_TAGMID_SHIFT)
#define  POGO_IDMA0_POGO_IDMA_UDMA_UTR0_TAGMID_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA0_POGO_IDMA_UDMA_UTR0_TAGMID_MASK) | (((uint32_t)val) << POGO_IDMA0_POGO_IDMA_UDMA_UTR0_TAGMID_SHIFT))

//====================================================================
//Register: UDMA Tag Register 1 (UTR1)
//====================================================================

#define  POGO_IDMA0_POGO_IDMA_UDMA_UTR1_RESERVED1_MASK 0xffff0000
#define  POGO_IDMA0_POGO_IDMA_UDMA_UTR1_RESERVED1_SHIFT 16
#define  POGO_IDMA0_POGO_IDMA_UDMA_UTR1_RESERVED1_MASK_SHIFT(reg) (((reg) & POGO_IDMA0_POGO_IDMA_UDMA_UTR1_RESERVED1_MASK) >> POGO_IDMA0_POGO_IDMA_UDMA_UTR1_RESERVED1_SHIFT)
#define  POGO_IDMA0_POGO_IDMA_UDMA_UTR1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA0_POGO_IDMA_UDMA_UTR1_RESERVED1_MASK) | (((uint32_t)val) << POGO_IDMA0_POGO_IDMA_UDMA_UTR1_RESERVED1_SHIFT))

#define  POGO_IDMA0_POGO_IDMA_UDMA_UTR1_TAGCFG_MASK 0xffff
#define  POGO_IDMA0_POGO_IDMA_UDMA_UTR1_TAGCFG_SHIFT 0
#define  POGO_IDMA0_POGO_IDMA_UDMA_UTR1_TAGCFG_MASK_SHIFT(reg) (((reg) & POGO_IDMA0_POGO_IDMA_UDMA_UTR1_TAGCFG_MASK) >> POGO_IDMA0_POGO_IDMA_UDMA_UTR1_TAGCFG_SHIFT)
#define  POGO_IDMA0_POGO_IDMA_UDMA_UTR1_TAGCFG_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA0_POGO_IDMA_UDMA_UTR1_TAGCFG_MASK) | (((uint32_t)val) << POGO_IDMA0_POGO_IDMA_UDMA_UTR1_TAGCFG_SHIFT))

//====================================================================
//
//Register File: POGO_IDMA_CORE (POGO_IDMA0_POGO_IDMA_CORE)
//
//====================================================================

//====================================================================
//Register: IDMA Configuration Register (ICR)
//====================================================================

#define  POGO_IDMA0_POGO_IDMA_CORE_ICR_RESERVED1_MASK 0xfffffffc
#define  POGO_IDMA0_POGO_IDMA_CORE_ICR_RESERVED1_SHIFT 2
#define  POGO_IDMA0_POGO_IDMA_CORE_ICR_RESERVED1_MASK_SHIFT(reg) (((reg) & POGO_IDMA0_POGO_IDMA_CORE_ICR_RESERVED1_MASK) >> POGO_IDMA0_POGO_IDMA_CORE_ICR_RESERVED1_SHIFT)
#define  POGO_IDMA0_POGO_IDMA_CORE_ICR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA0_POGO_IDMA_CORE_ICR_RESERVED1_MASK) | (((uint32_t)val) << POGO_IDMA0_POGO_IDMA_CORE_ICR_RESERVED1_SHIFT))

#define  POGO_IDMA0_POGO_IDMA_CORE_ICR_BURSTSIZE_MASK 0x3
#define  POGO_IDMA0_POGO_IDMA_CORE_ICR_BURSTSIZE_SHIFT 0
#define  POGO_IDMA0_POGO_IDMA_CORE_ICR_BURSTSIZE_MASK_SHIFT(reg) (((reg) & POGO_IDMA0_POGO_IDMA_CORE_ICR_BURSTSIZE_MASK) >> POGO_IDMA0_POGO_IDMA_CORE_ICR_BURSTSIZE_SHIFT)
#define  POGO_IDMA0_POGO_IDMA_CORE_ICR_BURSTSIZE_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA0_POGO_IDMA_CORE_ICR_BURSTSIZE_MASK) | (((uint32_t)val) << POGO_IDMA0_POGO_IDMA_CORE_ICR_BURSTSIZE_SHIFT))

//====================================================================
//Register: IDMA Interrupt Enable Register (IIER)
//====================================================================

#define  POGO_IDMA0_POGO_IDMA_CORE_IIER_RESERVED1_MASK 0xfffffffc
#define  POGO_IDMA0_POGO_IDMA_CORE_IIER_RESERVED1_SHIFT 2
#define  POGO_IDMA0_POGO_IDMA_CORE_IIER_RESERVED1_MASK_SHIFT(reg) (((reg) & POGO_IDMA0_POGO_IDMA_CORE_IIER_RESERVED1_MASK) >> POGO_IDMA0_POGO_IDMA_CORE_IIER_RESERVED1_SHIFT)
#define  POGO_IDMA0_POGO_IDMA_CORE_IIER_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA0_POGO_IDMA_CORE_IIER_RESERVED1_MASK) | (((uint32_t)val) << POGO_IDMA0_POGO_IDMA_CORE_IIER_RESERVED1_SHIFT))

#define  POGO_IDMA0_POGO_IDMA_CORE_IIER_LENGTHERR_MASK 0x2
#define  POGO_IDMA0_POGO_IDMA_CORE_IIER_LENGTHERR_SHIFT 1
#define  POGO_IDMA0_POGO_IDMA_CORE_IIER_LENGTHERR_MASK_SHIFT(reg) (((reg) & POGO_IDMA0_POGO_IDMA_CORE_IIER_LENGTHERR_MASK) >> POGO_IDMA0_POGO_IDMA_CORE_IIER_LENGTHERR_SHIFT)
#define  POGO_IDMA0_POGO_IDMA_CORE_IIER_LENGTHERR_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA0_POGO_IDMA_CORE_IIER_LENGTHERR_MASK) | (((uint32_t)val) << POGO_IDMA0_POGO_IDMA_CORE_IIER_LENGTHERR_SHIFT))

#define  POGO_IDMA0_POGO_IDMA_CORE_IIER_EOS_MASK 0x1
#define  POGO_IDMA0_POGO_IDMA_CORE_IIER_EOS_SHIFT 0
#define  POGO_IDMA0_POGO_IDMA_CORE_IIER_EOS_MASK_SHIFT(reg) (((reg) & POGO_IDMA0_POGO_IDMA_CORE_IIER_EOS_MASK) >> POGO_IDMA0_POGO_IDMA_CORE_IIER_EOS_SHIFT)
#define  POGO_IDMA0_POGO_IDMA_CORE_IIER_EOS_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA0_POGO_IDMA_CORE_IIER_EOS_MASK) | (((uint32_t)val) << POGO_IDMA0_POGO_IDMA_CORE_IIER_EOS_SHIFT))

//====================================================================
//Register: IDMA Interrupt Pending Register (IIPR)
//====================================================================

#define  POGO_IDMA0_POGO_IDMA_CORE_IIPR_RESERVED1_MASK 0xfffffffc
#define  POGO_IDMA0_POGO_IDMA_CORE_IIPR_RESERVED1_SHIFT 2
#define  POGO_IDMA0_POGO_IDMA_CORE_IIPR_RESERVED1_MASK_SHIFT(reg) (((reg) & POGO_IDMA0_POGO_IDMA_CORE_IIPR_RESERVED1_MASK) >> POGO_IDMA0_POGO_IDMA_CORE_IIPR_RESERVED1_SHIFT)
#define  POGO_IDMA0_POGO_IDMA_CORE_IIPR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA0_POGO_IDMA_CORE_IIPR_RESERVED1_MASK) | (((uint32_t)val) << POGO_IDMA0_POGO_IDMA_CORE_IIPR_RESERVED1_SHIFT))

#define  POGO_IDMA0_POGO_IDMA_CORE_IIPR_LENGTHERR_MASK 0x2
#define  POGO_IDMA0_POGO_IDMA_CORE_IIPR_LENGTHERR_SHIFT 1
#define  POGO_IDMA0_POGO_IDMA_CORE_IIPR_LENGTHERR_MASK_SHIFT(reg) (((reg) & POGO_IDMA0_POGO_IDMA_CORE_IIPR_LENGTHERR_MASK) >> POGO_IDMA0_POGO_IDMA_CORE_IIPR_LENGTHERR_SHIFT)
#define  POGO_IDMA0_POGO_IDMA_CORE_IIPR_LENGTHERR_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA0_POGO_IDMA_CORE_IIPR_LENGTHERR_MASK) | (((uint32_t)val) << POGO_IDMA0_POGO_IDMA_CORE_IIPR_LENGTHERR_SHIFT))

#define  POGO_IDMA0_POGO_IDMA_CORE_IIPR_EOS_MASK 0x1
#define  POGO_IDMA0_POGO_IDMA_CORE_IIPR_EOS_SHIFT 0
#define  POGO_IDMA0_POGO_IDMA_CORE_IIPR_EOS_MASK_SHIFT(reg) (((reg) & POGO_IDMA0_POGO_IDMA_CORE_IIPR_EOS_MASK) >> POGO_IDMA0_POGO_IDMA_CORE_IIPR_EOS_SHIFT)
#define  POGO_IDMA0_POGO_IDMA_CORE_IIPR_EOS_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA0_POGO_IDMA_CORE_IIPR_EOS_MASK) | (((uint32_t)val) << POGO_IDMA0_POGO_IDMA_CORE_IIPR_EOS_SHIFT))

//====================================================================
//Register: IDMA Interrupt Clear Register (IICR)
//====================================================================

#define  POGO_IDMA0_POGO_IDMA_CORE_IICR_RESERVED1_MASK 0xfffffffc
#define  POGO_IDMA0_POGO_IDMA_CORE_IICR_RESERVED1_SHIFT 2
#define  POGO_IDMA0_POGO_IDMA_CORE_IICR_RESERVED1_MASK_SHIFT(reg) (((reg) & POGO_IDMA0_POGO_IDMA_CORE_IICR_RESERVED1_MASK) >> POGO_IDMA0_POGO_IDMA_CORE_IICR_RESERVED1_SHIFT)
#define  POGO_IDMA0_POGO_IDMA_CORE_IICR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA0_POGO_IDMA_CORE_IICR_RESERVED1_MASK) | (((uint32_t)val) << POGO_IDMA0_POGO_IDMA_CORE_IICR_RESERVED1_SHIFT))

#define  POGO_IDMA0_POGO_IDMA_CORE_IICR_LENGTHERR_MASK 0x2
#define  POGO_IDMA0_POGO_IDMA_CORE_IICR_LENGTHERR_SHIFT 1
#define  POGO_IDMA0_POGO_IDMA_CORE_IICR_LENGTHERR_MASK_SHIFT(reg) (((reg) & POGO_IDMA0_POGO_IDMA_CORE_IICR_LENGTHERR_MASK) >> POGO_IDMA0_POGO_IDMA_CORE_IICR_LENGTHERR_SHIFT)
#define  POGO_IDMA0_POGO_IDMA_CORE_IICR_LENGTHERR_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA0_POGO_IDMA_CORE_IICR_LENGTHERR_MASK) | (((uint32_t)val) << POGO_IDMA0_POGO_IDMA_CORE_IICR_LENGTHERR_SHIFT))

#define  POGO_IDMA0_POGO_IDMA_CORE_IICR_EOS_MASK 0x1
#define  POGO_IDMA0_POGO_IDMA_CORE_IICR_EOS_SHIFT 0
#define  POGO_IDMA0_POGO_IDMA_CORE_IICR_EOS_MASK_SHIFT(reg) (((reg) & POGO_IDMA0_POGO_IDMA_CORE_IICR_EOS_MASK) >> POGO_IDMA0_POGO_IDMA_CORE_IICR_EOS_SHIFT)
#define  POGO_IDMA0_POGO_IDMA_CORE_IICR_EOS_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA0_POGO_IDMA_CORE_IICR_EOS_MASK) | (((uint32_t)val) << POGO_IDMA0_POGO_IDMA_CORE_IICR_EOS_SHIFT))

//====================================================================
//Register: IDMA Interrupt Force Register (IIFR)
//====================================================================

#define  POGO_IDMA0_POGO_IDMA_CORE_IIFR_RESERVED1_MASK 0xfffffffc
#define  POGO_IDMA0_POGO_IDMA_CORE_IIFR_RESERVED1_SHIFT 2
#define  POGO_IDMA0_POGO_IDMA_CORE_IIFR_RESERVED1_MASK_SHIFT(reg) (((reg) & POGO_IDMA0_POGO_IDMA_CORE_IIFR_RESERVED1_MASK) >> POGO_IDMA0_POGO_IDMA_CORE_IIFR_RESERVED1_SHIFT)
#define  POGO_IDMA0_POGO_IDMA_CORE_IIFR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA0_POGO_IDMA_CORE_IIFR_RESERVED1_MASK) | (((uint32_t)val) << POGO_IDMA0_POGO_IDMA_CORE_IIFR_RESERVED1_SHIFT))

#define  POGO_IDMA0_POGO_IDMA_CORE_IIFR_LENGTHERR_MASK 0x2
#define  POGO_IDMA0_POGO_IDMA_CORE_IIFR_LENGTHERR_SHIFT 1
#define  POGO_IDMA0_POGO_IDMA_CORE_IIFR_LENGTHERR_MASK_SHIFT(reg) (((reg) & POGO_IDMA0_POGO_IDMA_CORE_IIFR_LENGTHERR_MASK) >> POGO_IDMA0_POGO_IDMA_CORE_IIFR_LENGTHERR_SHIFT)
#define  POGO_IDMA0_POGO_IDMA_CORE_IIFR_LENGTHERR_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA0_POGO_IDMA_CORE_IIFR_LENGTHERR_MASK) | (((uint32_t)val) << POGO_IDMA0_POGO_IDMA_CORE_IIFR_LENGTHERR_SHIFT))

#define  POGO_IDMA0_POGO_IDMA_CORE_IIFR_EOS_MASK 0x1
#define  POGO_IDMA0_POGO_IDMA_CORE_IIFR_EOS_SHIFT 0
#define  POGO_IDMA0_POGO_IDMA_CORE_IIFR_EOS_MASK_SHIFT(reg) (((reg) & POGO_IDMA0_POGO_IDMA_CORE_IIFR_EOS_MASK) >> POGO_IDMA0_POGO_IDMA_CORE_IIFR_EOS_SHIFT)
#define  POGO_IDMA0_POGO_IDMA_CORE_IIFR_EOS_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA0_POGO_IDMA_CORE_IIFR_EOS_MASK) | (((uint32_t)val) << POGO_IDMA0_POGO_IDMA_CORE_IIFR_EOS_SHIFT))

//====================================================================
//Register: IDMA Line Width Register (ILWR)
//====================================================================

#define  POGO_IDMA0_POGO_IDMA_CORE_ILWR_RESERVED1_MASK 0xfff00000
#define  POGO_IDMA0_POGO_IDMA_CORE_ILWR_RESERVED1_SHIFT 20
#define  POGO_IDMA0_POGO_IDMA_CORE_ILWR_RESERVED1_MASK_SHIFT(reg) (((reg) & POGO_IDMA0_POGO_IDMA_CORE_ILWR_RESERVED1_MASK) >> POGO_IDMA0_POGO_IDMA_CORE_ILWR_RESERVED1_SHIFT)
#define  POGO_IDMA0_POGO_IDMA_CORE_ILWR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA0_POGO_IDMA_CORE_ILWR_RESERVED1_MASK) | (((uint32_t)val) << POGO_IDMA0_POGO_IDMA_CORE_ILWR_RESERVED1_SHIFT))

#define  POGO_IDMA0_POGO_IDMA_CORE_ILWR_LINEWIDTH_MASK 0xfffff
#define  POGO_IDMA0_POGO_IDMA_CORE_ILWR_LINEWIDTH_SHIFT 0
#define  POGO_IDMA0_POGO_IDMA_CORE_ILWR_LINEWIDTH_MASK_SHIFT(reg) (((reg) & POGO_IDMA0_POGO_IDMA_CORE_ILWR_LINEWIDTH_MASK) >> POGO_IDMA0_POGO_IDMA_CORE_ILWR_LINEWIDTH_SHIFT)
#define  POGO_IDMA0_POGO_IDMA_CORE_ILWR_LINEWIDTH_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA0_POGO_IDMA_CORE_ILWR_LINEWIDTH_MASK) | (((uint32_t)val) << POGO_IDMA0_POGO_IDMA_CORE_ILWR_LINEWIDTH_SHIFT))

//====================================================================
//Register: IDMA Row Height Register (IRHR)
//====================================================================

#define  POGO_IDMA0_POGO_IDMA_CORE_IRHR_RESERVED1_MASK 0xffffffc0
#define  POGO_IDMA0_POGO_IDMA_CORE_IRHR_RESERVED1_SHIFT 6
#define  POGO_IDMA0_POGO_IDMA_CORE_IRHR_RESERVED1_MASK_SHIFT(reg) (((reg) & POGO_IDMA0_POGO_IDMA_CORE_IRHR_RESERVED1_MASK) >> POGO_IDMA0_POGO_IDMA_CORE_IRHR_RESERVED1_SHIFT)
#define  POGO_IDMA0_POGO_IDMA_CORE_IRHR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA0_POGO_IDMA_CORE_IRHR_RESERVED1_MASK) | (((uint32_t)val) << POGO_IDMA0_POGO_IDMA_CORE_IRHR_RESERVED1_SHIFT))

#define  POGO_IDMA0_POGO_IDMA_CORE_IRHR_ROWHEIGHT_MASK 0x3f
#define  POGO_IDMA0_POGO_IDMA_CORE_IRHR_ROWHEIGHT_SHIFT 0
#define  POGO_IDMA0_POGO_IDMA_CORE_IRHR_ROWHEIGHT_MASK_SHIFT(reg) (((reg) & POGO_IDMA0_POGO_IDMA_CORE_IRHR_ROWHEIGHT_MASK) >> POGO_IDMA0_POGO_IDMA_CORE_IRHR_ROWHEIGHT_SHIFT)
#define  POGO_IDMA0_POGO_IDMA_CORE_IRHR_ROWHEIGHT_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA0_POGO_IDMA_CORE_IRHR_ROWHEIGHT_MASK) | (((uint32_t)val) << POGO_IDMA0_POGO_IDMA_CORE_IRHR_ROWHEIGHT_SHIFT))

//====================================================================
//Register: IDMA Tag Register 0 (ITR0)
//====================================================================

#define  POGO_IDMA0_POGO_IDMA_CORE_ITR0_RESERVED1_MASK 0xffff0000
#define  POGO_IDMA0_POGO_IDMA_CORE_ITR0_RESERVED1_SHIFT 16
#define  POGO_IDMA0_POGO_IDMA_CORE_ITR0_RESERVED1_MASK_SHIFT(reg) (((reg) & POGO_IDMA0_POGO_IDMA_CORE_ITR0_RESERVED1_MASK) >> POGO_IDMA0_POGO_IDMA_CORE_ITR0_RESERVED1_SHIFT)
#define  POGO_IDMA0_POGO_IDMA_CORE_ITR0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA0_POGO_IDMA_CORE_ITR0_RESERVED1_MASK) | (((uint32_t)val) << POGO_IDMA0_POGO_IDMA_CORE_ITR0_RESERVED1_SHIFT))

#define  POGO_IDMA0_POGO_IDMA_CORE_ITR0_TAGCFG_MASK 0xffff
#define  POGO_IDMA0_POGO_IDMA_CORE_ITR0_TAGCFG_SHIFT 0
#define  POGO_IDMA0_POGO_IDMA_CORE_ITR0_TAGCFG_MASK_SHIFT(reg) (((reg) & POGO_IDMA0_POGO_IDMA_CORE_ITR0_TAGCFG_MASK) >> POGO_IDMA0_POGO_IDMA_CORE_ITR0_TAGCFG_SHIFT)
#define  POGO_IDMA0_POGO_IDMA_CORE_ITR0_TAGCFG_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA0_POGO_IDMA_CORE_ITR0_TAGCFG_MASK) | (((uint32_t)val) << POGO_IDMA0_POGO_IDMA_CORE_ITR0_TAGCFG_SHIFT))

//====================================================================
//Register: IDMA Tag Register 1 (ITR1)
//====================================================================

#define  POGO_IDMA0_POGO_IDMA_CORE_ITR1_RESERVED1_MASK 0xffff0000
#define  POGO_IDMA0_POGO_IDMA_CORE_ITR1_RESERVED1_SHIFT 16
#define  POGO_IDMA0_POGO_IDMA_CORE_ITR1_RESERVED1_MASK_SHIFT(reg) (((reg) & POGO_IDMA0_POGO_IDMA_CORE_ITR1_RESERVED1_MASK) >> POGO_IDMA0_POGO_IDMA_CORE_ITR1_RESERVED1_SHIFT)
#define  POGO_IDMA0_POGO_IDMA_CORE_ITR1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA0_POGO_IDMA_CORE_ITR1_RESERVED1_MASK) | (((uint32_t)val) << POGO_IDMA0_POGO_IDMA_CORE_ITR1_RESERVED1_SHIFT))

#define  POGO_IDMA0_POGO_IDMA_CORE_ITR1_TAGMAJ_MASK 0xffff
#define  POGO_IDMA0_POGO_IDMA_CORE_ITR1_TAGMAJ_SHIFT 0
#define  POGO_IDMA0_POGO_IDMA_CORE_ITR1_TAGMAJ_MASK_SHIFT(reg) (((reg) & POGO_IDMA0_POGO_IDMA_CORE_ITR1_TAGMAJ_MASK) >> POGO_IDMA0_POGO_IDMA_CORE_ITR1_TAGMAJ_SHIFT)
#define  POGO_IDMA0_POGO_IDMA_CORE_ITR1_TAGMAJ_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA0_POGO_IDMA_CORE_ITR1_TAGMAJ_MASK) | (((uint32_t)val) << POGO_IDMA0_POGO_IDMA_CORE_ITR1_TAGMAJ_SHIFT))

//====================================================================
//Register: IDMA Tag Register 2 (ITR2)
//====================================================================

#define  POGO_IDMA0_POGO_IDMA_CORE_ITR2_RESERVED1_MASK 0xffff0000
#define  POGO_IDMA0_POGO_IDMA_CORE_ITR2_RESERVED1_SHIFT 16
#define  POGO_IDMA0_POGO_IDMA_CORE_ITR2_RESERVED1_MASK_SHIFT(reg) (((reg) & POGO_IDMA0_POGO_IDMA_CORE_ITR2_RESERVED1_MASK) >> POGO_IDMA0_POGO_IDMA_CORE_ITR2_RESERVED1_SHIFT)
#define  POGO_IDMA0_POGO_IDMA_CORE_ITR2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA0_POGO_IDMA_CORE_ITR2_RESERVED1_MASK) | (((uint32_t)val) << POGO_IDMA0_POGO_IDMA_CORE_ITR2_RESERVED1_SHIFT))

#define  POGO_IDMA0_POGO_IDMA_CORE_ITR2_TAGMID_MASK 0xffff
#define  POGO_IDMA0_POGO_IDMA_CORE_ITR2_TAGMID_SHIFT 0
#define  POGO_IDMA0_POGO_IDMA_CORE_ITR2_TAGMID_MASK_SHIFT(reg) (((reg) & POGO_IDMA0_POGO_IDMA_CORE_ITR2_TAGMID_MASK) >> POGO_IDMA0_POGO_IDMA_CORE_ITR2_TAGMID_SHIFT)
#define  POGO_IDMA0_POGO_IDMA_CORE_ITR2_TAGMID_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA0_POGO_IDMA_CORE_ITR2_TAGMID_MASK) | (((uint32_t)val) << POGO_IDMA0_POGO_IDMA_CORE_ITR2_TAGMID_SHIFT))

//====================================================================
//
//Register File: POGO_IDMA_UDMA (POGO_IDMA1_POGO_IDMA_UDMA)
//
//====================================================================

//====================================================================
//Register: UDMA Configuration Register (UCR)
//====================================================================

#define  POGO_IDMA1_POGO_IDMA_UDMA_UCR_RESERVED1_MASK 0xfff00000
#define  POGO_IDMA1_POGO_IDMA_UDMA_UCR_RESERVED1_SHIFT 20
#define  POGO_IDMA1_POGO_IDMA_UDMA_UCR_RESERVED1_MASK_SHIFT(reg) (((reg) & POGO_IDMA1_POGO_IDMA_UDMA_UCR_RESERVED1_MASK) >> POGO_IDMA1_POGO_IDMA_UDMA_UCR_RESERVED1_SHIFT)
#define  POGO_IDMA1_POGO_IDMA_UDMA_UCR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA1_POGO_IDMA_UDMA_UCR_RESERVED1_MASK) | (((uint32_t)val) << POGO_IDMA1_POGO_IDMA_UDMA_UCR_RESERVED1_SHIFT))

#define  POGO_IDMA1_POGO_IDMA_UDMA_UCR_DATAAXCACHE_MASK 0xf0000
#define  POGO_IDMA1_POGO_IDMA_UDMA_UCR_DATAAXCACHE_SHIFT 16
#define  POGO_IDMA1_POGO_IDMA_UDMA_UCR_DATAAXCACHE_MASK_SHIFT(reg) (((reg) & POGO_IDMA1_POGO_IDMA_UDMA_UCR_DATAAXCACHE_MASK) >> POGO_IDMA1_POGO_IDMA_UDMA_UCR_DATAAXCACHE_SHIFT)
#define  POGO_IDMA1_POGO_IDMA_UDMA_UCR_DATAAXCACHE_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA1_POGO_IDMA_UDMA_UCR_DATAAXCACHE_MASK) | (((uint32_t)val) << POGO_IDMA1_POGO_IDMA_UDMA_UCR_DATAAXCACHE_SHIFT))

#define  POGO_IDMA1_POGO_IDMA_UDMA_UCR_DESCARCACHE_MASK 0xf000
#define  POGO_IDMA1_POGO_IDMA_UDMA_UCR_DESCARCACHE_SHIFT 12
#define  POGO_IDMA1_POGO_IDMA_UDMA_UCR_DESCARCACHE_MASK_SHIFT(reg) (((reg) & POGO_IDMA1_POGO_IDMA_UDMA_UCR_DESCARCACHE_MASK) >> POGO_IDMA1_POGO_IDMA_UDMA_UCR_DESCARCACHE_SHIFT)
#define  POGO_IDMA1_POGO_IDMA_UDMA_UCR_DESCARCACHE_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA1_POGO_IDMA_UDMA_UCR_DESCARCACHE_MASK) | (((uint32_t)val) << POGO_IDMA1_POGO_IDMA_UDMA_UCR_DESCARCACHE_SHIFT))

#define  POGO_IDMA1_POGO_IDMA_UDMA_UCR_DESCAWCACHE_MASK 0xf00
#define  POGO_IDMA1_POGO_IDMA_UDMA_UCR_DESCAWCACHE_SHIFT 8
#define  POGO_IDMA1_POGO_IDMA_UDMA_UCR_DESCAWCACHE_MASK_SHIFT(reg) (((reg) & POGO_IDMA1_POGO_IDMA_UDMA_UCR_DESCAWCACHE_MASK) >> POGO_IDMA1_POGO_IDMA_UDMA_UCR_DESCAWCACHE_SHIFT)
#define  POGO_IDMA1_POGO_IDMA_UDMA_UCR_DESCAWCACHE_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA1_POGO_IDMA_UDMA_UCR_DESCAWCACHE_MASK) | (((uint32_t)val) << POGO_IDMA1_POGO_IDMA_UDMA_UCR_DESCAWCACHE_SHIFT))

#define  POGO_IDMA1_POGO_IDMA_UDMA_UCR_RESERVED2_MASK 0xc0
#define  POGO_IDMA1_POGO_IDMA_UDMA_UCR_RESERVED2_SHIFT 6
#define  POGO_IDMA1_POGO_IDMA_UDMA_UCR_RESERVED2_MASK_SHIFT(reg) (((reg) & POGO_IDMA1_POGO_IDMA_UDMA_UCR_RESERVED2_MASK) >> POGO_IDMA1_POGO_IDMA_UDMA_UCR_RESERVED2_SHIFT)
#define  POGO_IDMA1_POGO_IDMA_UDMA_UCR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA1_POGO_IDMA_UDMA_UCR_RESERVED2_MASK) | (((uint32_t)val) << POGO_IDMA1_POGO_IDMA_UDMA_UCR_RESERVED2_SHIFT))

#define  POGO_IDMA1_POGO_IDMA_UDMA_UCR_HANDSHAKEENABLE_MASK 0x20
#define  POGO_IDMA1_POGO_IDMA_UDMA_UCR_HANDSHAKEENABLE_SHIFT 5
#define  POGO_IDMA1_POGO_IDMA_UDMA_UCR_HANDSHAKEENABLE_MASK_SHIFT(reg) (((reg) & POGO_IDMA1_POGO_IDMA_UDMA_UCR_HANDSHAKEENABLE_MASK) >> POGO_IDMA1_POGO_IDMA_UDMA_UCR_HANDSHAKEENABLE_SHIFT)
#define  POGO_IDMA1_POGO_IDMA_UDMA_UCR_HANDSHAKEENABLE_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA1_POGO_IDMA_UDMA_UCR_HANDSHAKEENABLE_MASK) | (((uint32_t)val) << POGO_IDMA1_POGO_IDMA_UDMA_UCR_HANDSHAKEENABLE_SHIFT))

#define  POGO_IDMA1_POGO_IDMA_UDMA_UCR_OWNWRITEDISABLE_MASK 0x10
#define  POGO_IDMA1_POGO_IDMA_UDMA_UCR_OWNWRITEDISABLE_SHIFT 4
#define  POGO_IDMA1_POGO_IDMA_UDMA_UCR_OWNWRITEDISABLE_MASK_SHIFT(reg) (((reg) & POGO_IDMA1_POGO_IDMA_UDMA_UCR_OWNWRITEDISABLE_MASK) >> POGO_IDMA1_POGO_IDMA_UDMA_UCR_OWNWRITEDISABLE_SHIFT)
#define  POGO_IDMA1_POGO_IDMA_UDMA_UCR_OWNWRITEDISABLE_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA1_POGO_IDMA_UDMA_UCR_OWNWRITEDISABLE_MASK) | (((uint32_t)val) << POGO_IDMA1_POGO_IDMA_UDMA_UCR_OWNWRITEDISABLE_SHIFT))

#define  POGO_IDMA1_POGO_IDMA_UDMA_UCR_OWNPOLARITY_MASK 0x8
#define  POGO_IDMA1_POGO_IDMA_UDMA_UCR_OWNPOLARITY_SHIFT 3
#define  POGO_IDMA1_POGO_IDMA_UDMA_UCR_OWNPOLARITY_MASK_SHIFT(reg) (((reg) & POGO_IDMA1_POGO_IDMA_UDMA_UCR_OWNPOLARITY_MASK) >> POGO_IDMA1_POGO_IDMA_UDMA_UCR_OWNPOLARITY_SHIFT)
#define  POGO_IDMA1_POGO_IDMA_UDMA_UCR_OWNPOLARITY_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA1_POGO_IDMA_UDMA_UCR_OWNPOLARITY_MASK) | (((uint32_t)val) << POGO_IDMA1_POGO_IDMA_UDMA_UCR_OWNPOLARITY_SHIFT))

#define  POGO_IDMA1_POGO_IDMA_UDMA_UCR_BEATS_MASK 0x6
#define  POGO_IDMA1_POGO_IDMA_UDMA_UCR_BEATS_SHIFT 1
#define  POGO_IDMA1_POGO_IDMA_UDMA_UCR_BEATS_MASK_SHIFT(reg) (((reg) & POGO_IDMA1_POGO_IDMA_UDMA_UCR_BEATS_MASK) >> POGO_IDMA1_POGO_IDMA_UDMA_UCR_BEATS_SHIFT)
#define  POGO_IDMA1_POGO_IDMA_UDMA_UCR_BEATS_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA1_POGO_IDMA_UDMA_UCR_BEATS_MASK) | (((uint32_t)val) << POGO_IDMA1_POGO_IDMA_UDMA_UCR_BEATS_SHIFT))

#define  POGO_IDMA1_POGO_IDMA_UDMA_UCR_ENABLE_MASK 0x1
#define  POGO_IDMA1_POGO_IDMA_UDMA_UCR_ENABLE_SHIFT 0
#define  POGO_IDMA1_POGO_IDMA_UDMA_UCR_ENABLE_MASK_SHIFT(reg) (((reg) & POGO_IDMA1_POGO_IDMA_UDMA_UCR_ENABLE_MASK) >> POGO_IDMA1_POGO_IDMA_UDMA_UCR_ENABLE_SHIFT)
#define  POGO_IDMA1_POGO_IDMA_UDMA_UCR_ENABLE_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA1_POGO_IDMA_UDMA_UCR_ENABLE_MASK) | (((uint32_t)val) << POGO_IDMA1_POGO_IDMA_UDMA_UCR_ENABLE_SHIFT))

//====================================================================
//Register: UDMA Status Register (USR)
//====================================================================

#define  POGO_IDMA1_POGO_IDMA_UDMA_USR_RESERVED1_MASK 0xfffff800
#define  POGO_IDMA1_POGO_IDMA_UDMA_USR_RESERVED1_SHIFT 11
#define  POGO_IDMA1_POGO_IDMA_UDMA_USR_RESERVED1_MASK_SHIFT(reg) (((reg) & POGO_IDMA1_POGO_IDMA_UDMA_USR_RESERVED1_MASK) >> POGO_IDMA1_POGO_IDMA_UDMA_USR_RESERVED1_SHIFT)
#define  POGO_IDMA1_POGO_IDMA_UDMA_USR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA1_POGO_IDMA_UDMA_USR_RESERVED1_MASK) | (((uint32_t)val) << POGO_IDMA1_POGO_IDMA_UDMA_USR_RESERVED1_SHIFT))

#define  POGO_IDMA1_POGO_IDMA_UDMA_USR_DMAPAUSED_MASK 0x400
#define  POGO_IDMA1_POGO_IDMA_UDMA_USR_DMAPAUSED_SHIFT 10
#define  POGO_IDMA1_POGO_IDMA_UDMA_USR_DMAPAUSED_MASK_SHIFT(reg) (((reg) & POGO_IDMA1_POGO_IDMA_UDMA_USR_DMAPAUSED_MASK) >> POGO_IDMA1_POGO_IDMA_UDMA_USR_DMAPAUSED_SHIFT)
#define  POGO_IDMA1_POGO_IDMA_UDMA_USR_DMAPAUSED_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA1_POGO_IDMA_UDMA_USR_DMAPAUSED_MASK) | (((uint32_t)val) << POGO_IDMA1_POGO_IDMA_UDMA_USR_DMAPAUSED_SHIFT))

#define  POGO_IDMA1_POGO_IDMA_UDMA_USR_PAUSEAFTER_MASK 0x200
#define  POGO_IDMA1_POGO_IDMA_UDMA_USR_PAUSEAFTER_SHIFT 9
#define  POGO_IDMA1_POGO_IDMA_UDMA_USR_PAUSEAFTER_MASK_SHIFT(reg) (((reg) & POGO_IDMA1_POGO_IDMA_UDMA_USR_PAUSEAFTER_MASK) >> POGO_IDMA1_POGO_IDMA_UDMA_USR_PAUSEAFTER_SHIFT)
#define  POGO_IDMA1_POGO_IDMA_UDMA_USR_PAUSEAFTER_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA1_POGO_IDMA_UDMA_USR_PAUSEAFTER_MASK) | (((uint32_t)val) << POGO_IDMA1_POGO_IDMA_UDMA_USR_PAUSEAFTER_SHIFT))

#define  POGO_IDMA1_POGO_IDMA_UDMA_USR_PAUSEBEFORE_MASK 0x100
#define  POGO_IDMA1_POGO_IDMA_UDMA_USR_PAUSEBEFORE_SHIFT 8
#define  POGO_IDMA1_POGO_IDMA_UDMA_USR_PAUSEBEFORE_MASK_SHIFT(reg) (((reg) & POGO_IDMA1_POGO_IDMA_UDMA_USR_PAUSEBEFORE_MASK) >> POGO_IDMA1_POGO_IDMA_UDMA_USR_PAUSEBEFORE_SHIFT)
#define  POGO_IDMA1_POGO_IDMA_UDMA_USR_PAUSEBEFORE_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA1_POGO_IDMA_UDMA_USR_PAUSEBEFORE_MASK) | (((uint32_t)val) << POGO_IDMA1_POGO_IDMA_UDMA_USR_PAUSEBEFORE_SHIFT))

#define  POGO_IDMA1_POGO_IDMA_UDMA_USR_INTONFINISH_MASK 0x80
#define  POGO_IDMA1_POGO_IDMA_UDMA_USR_INTONFINISH_SHIFT 7
#define  POGO_IDMA1_POGO_IDMA_UDMA_USR_INTONFINISH_MASK_SHIFT(reg) (((reg) & POGO_IDMA1_POGO_IDMA_UDMA_USR_INTONFINISH_MASK) >> POGO_IDMA1_POGO_IDMA_UDMA_USR_INTONFINISH_SHIFT)
#define  POGO_IDMA1_POGO_IDMA_UDMA_USR_INTONFINISH_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA1_POGO_IDMA_UDMA_USR_INTONFINISH_MASK) | (((uint32_t)val) << POGO_IDMA1_POGO_IDMA_UDMA_USR_INTONFINISH_SHIFT))

#define  POGO_IDMA1_POGO_IDMA_UDMA_USR_STOPONFINISH_MASK 0x40
#define  POGO_IDMA1_POGO_IDMA_UDMA_USR_STOPONFINISH_SHIFT 6
#define  POGO_IDMA1_POGO_IDMA_UDMA_USR_STOPONFINISH_MASK_SHIFT(reg) (((reg) & POGO_IDMA1_POGO_IDMA_UDMA_USR_STOPONFINISH_MASK) >> POGO_IDMA1_POGO_IDMA_UDMA_USR_STOPONFINISH_SHIFT)
#define  POGO_IDMA1_POGO_IDMA_UDMA_USR_STOPONFINISH_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA1_POGO_IDMA_UDMA_USR_STOPONFINISH_MASK) | (((uint32_t)val) << POGO_IDMA1_POGO_IDMA_UDMA_USR_STOPONFINISH_SHIFT))

#define  POGO_IDMA1_POGO_IDMA_UDMA_USR_CMDBUFFULL_MASK 0x20
#define  POGO_IDMA1_POGO_IDMA_UDMA_USR_CMDBUFFULL_SHIFT 5
#define  POGO_IDMA1_POGO_IDMA_UDMA_USR_CMDBUFFULL_MASK_SHIFT(reg) (((reg) & POGO_IDMA1_POGO_IDMA_UDMA_USR_CMDBUFFULL_MASK) >> POGO_IDMA1_POGO_IDMA_UDMA_USR_CMDBUFFULL_SHIFT)
#define  POGO_IDMA1_POGO_IDMA_UDMA_USR_CMDBUFFULL_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA1_POGO_IDMA_UDMA_USR_CMDBUFFULL_MASK) | (((uint32_t)val) << POGO_IDMA1_POGO_IDMA_UDMA_USR_CMDBUFFULL_SHIFT))

#define  POGO_IDMA1_POGO_IDMA_UDMA_USR_CMDBUFEMPTY_MASK 0x10
#define  POGO_IDMA1_POGO_IDMA_UDMA_USR_CMDBUFEMPTY_SHIFT 4
#define  POGO_IDMA1_POGO_IDMA_UDMA_USR_CMDBUFEMPTY_MASK_SHIFT(reg) (((reg) & POGO_IDMA1_POGO_IDMA_UDMA_USR_CMDBUFEMPTY_MASK) >> POGO_IDMA1_POGO_IDMA_UDMA_USR_CMDBUFEMPTY_SHIFT)
#define  POGO_IDMA1_POGO_IDMA_UDMA_USR_CMDBUFEMPTY_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA1_POGO_IDMA_UDMA_USR_CMDBUFEMPTY_MASK) | (((uint32_t)val) << POGO_IDMA1_POGO_IDMA_UDMA_USR_CMDBUFEMPTY_SHIFT))

#define  POGO_IDMA1_POGO_IDMA_UDMA_USR_DATABUFFULL_MASK 0x8
#define  POGO_IDMA1_POGO_IDMA_UDMA_USR_DATABUFFULL_SHIFT 3
#define  POGO_IDMA1_POGO_IDMA_UDMA_USR_DATABUFFULL_MASK_SHIFT(reg) (((reg) & POGO_IDMA1_POGO_IDMA_UDMA_USR_DATABUFFULL_MASK) >> POGO_IDMA1_POGO_IDMA_UDMA_USR_DATABUFFULL_SHIFT)
#define  POGO_IDMA1_POGO_IDMA_UDMA_USR_DATABUFFULL_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA1_POGO_IDMA_UDMA_USR_DATABUFFULL_MASK) | (((uint32_t)val) << POGO_IDMA1_POGO_IDMA_UDMA_USR_DATABUFFULL_SHIFT))

#define  POGO_IDMA1_POGO_IDMA_UDMA_USR_DATABUFEMPTY_MASK 0x4
#define  POGO_IDMA1_POGO_IDMA_UDMA_USR_DATABUFEMPTY_SHIFT 2
#define  POGO_IDMA1_POGO_IDMA_UDMA_USR_DATABUFEMPTY_MASK_SHIFT(reg) (((reg) & POGO_IDMA1_POGO_IDMA_UDMA_USR_DATABUFEMPTY_MASK) >> POGO_IDMA1_POGO_IDMA_UDMA_USR_DATABUFEMPTY_SHIFT)
#define  POGO_IDMA1_POGO_IDMA_UDMA_USR_DATABUFEMPTY_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA1_POGO_IDMA_UDMA_USR_DATABUFEMPTY_MASK) | (((uint32_t)val) << POGO_IDMA1_POGO_IDMA_UDMA_USR_DATABUFEMPTY_SHIFT))

#define  POGO_IDMA1_POGO_IDMA_UDMA_USR_CLEAR_MASK 0x2
#define  POGO_IDMA1_POGO_IDMA_UDMA_USR_CLEAR_SHIFT 1
#define  POGO_IDMA1_POGO_IDMA_UDMA_USR_CLEAR_MASK_SHIFT(reg) (((reg) & POGO_IDMA1_POGO_IDMA_UDMA_USR_CLEAR_MASK) >> POGO_IDMA1_POGO_IDMA_UDMA_USR_CLEAR_SHIFT)
#define  POGO_IDMA1_POGO_IDMA_UDMA_USR_CLEAR_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA1_POGO_IDMA_UDMA_USR_CLEAR_MASK) | (((uint32_t)val) << POGO_IDMA1_POGO_IDMA_UDMA_USR_CLEAR_SHIFT))

#define  POGO_IDMA1_POGO_IDMA_UDMA_USR_BUSY_MASK 0x1
#define  POGO_IDMA1_POGO_IDMA_UDMA_USR_BUSY_SHIFT 0
#define  POGO_IDMA1_POGO_IDMA_UDMA_USR_BUSY_MASK_SHIFT(reg) (((reg) & POGO_IDMA1_POGO_IDMA_UDMA_USR_BUSY_MASK) >> POGO_IDMA1_POGO_IDMA_UDMA_USR_BUSY_SHIFT)
#define  POGO_IDMA1_POGO_IDMA_UDMA_USR_BUSY_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA1_POGO_IDMA_UDMA_USR_BUSY_MASK) | (((uint32_t)val) << POGO_IDMA1_POGO_IDMA_UDMA_USR_BUSY_SHIFT))

//====================================================================
//Register: UDMA Parameter Register (UPR)
//====================================================================

#define  POGO_IDMA1_POGO_IDMA_UDMA_UPR_RESERVED1_MASK 0xff000000
#define  POGO_IDMA1_POGO_IDMA_UDMA_UPR_RESERVED1_SHIFT 24
#define  POGO_IDMA1_POGO_IDMA_UDMA_UPR_RESERVED1_MASK_SHIFT(reg) (((reg) & POGO_IDMA1_POGO_IDMA_UDMA_UPR_RESERVED1_MASK) >> POGO_IDMA1_POGO_IDMA_UDMA_UPR_RESERVED1_SHIFT)
#define  POGO_IDMA1_POGO_IDMA_UDMA_UPR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA1_POGO_IDMA_UDMA_UPR_RESERVED1_MASK) | (((uint32_t)val) << POGO_IDMA1_POGO_IDMA_UDMA_UPR_RESERVED1_SHIFT))

#define  POGO_IDMA1_POGO_IDMA_UDMA_UPR_FIFODEPTH_MASK 0xffff00
#define  POGO_IDMA1_POGO_IDMA_UDMA_UPR_FIFODEPTH_SHIFT 8
#define  POGO_IDMA1_POGO_IDMA_UDMA_UPR_FIFODEPTH_MASK_SHIFT(reg) (((reg) & POGO_IDMA1_POGO_IDMA_UDMA_UPR_FIFODEPTH_MASK) >> POGO_IDMA1_POGO_IDMA_UDMA_UPR_FIFODEPTH_SHIFT)
#define  POGO_IDMA1_POGO_IDMA_UDMA_UPR_FIFODEPTH_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA1_POGO_IDMA_UDMA_UPR_FIFODEPTH_MASK) | (((uint32_t)val) << POGO_IDMA1_POGO_IDMA_UDMA_UPR_FIFODEPTH_SHIFT))

#define  POGO_IDMA1_POGO_IDMA_UDMA_UPR_RESERVED2_MASK 0xe0
#define  POGO_IDMA1_POGO_IDMA_UDMA_UPR_RESERVED2_SHIFT 5
#define  POGO_IDMA1_POGO_IDMA_UDMA_UPR_RESERVED2_MASK_SHIFT(reg) (((reg) & POGO_IDMA1_POGO_IDMA_UDMA_UPR_RESERVED2_MASK) >> POGO_IDMA1_POGO_IDMA_UDMA_UPR_RESERVED2_SHIFT)
#define  POGO_IDMA1_POGO_IDMA_UDMA_UPR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA1_POGO_IDMA_UDMA_UPR_RESERVED2_MASK) | (((uint32_t)val) << POGO_IDMA1_POGO_IDMA_UDMA_UPR_RESERVED2_SHIFT))

#define  POGO_IDMA1_POGO_IDMA_UDMA_UPR_SERPSUPPORT_MASK 0x10
#define  POGO_IDMA1_POGO_IDMA_UDMA_UPR_SERPSUPPORT_SHIFT 4
#define  POGO_IDMA1_POGO_IDMA_UDMA_UPR_SERPSUPPORT_MASK_SHIFT(reg) (((reg) & POGO_IDMA1_POGO_IDMA_UDMA_UPR_SERPSUPPORT_MASK) >> POGO_IDMA1_POGO_IDMA_UDMA_UPR_SERPSUPPORT_SHIFT)
#define  POGO_IDMA1_POGO_IDMA_UDMA_UPR_SERPSUPPORT_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA1_POGO_IDMA_UDMA_UPR_SERPSUPPORT_MASK) | (((uint32_t)val) << POGO_IDMA1_POGO_IDMA_UDMA_UPR_SERPSUPPORT_SHIFT))

#define  POGO_IDMA1_POGO_IDMA_UDMA_UPR_DESCLENGTH_MASK 0x8
#define  POGO_IDMA1_POGO_IDMA_UDMA_UPR_DESCLENGTH_SHIFT 3
#define  POGO_IDMA1_POGO_IDMA_UDMA_UPR_DESCLENGTH_MASK_SHIFT(reg) (((reg) & POGO_IDMA1_POGO_IDMA_UDMA_UPR_DESCLENGTH_MASK) >> POGO_IDMA1_POGO_IDMA_UDMA_UPR_DESCLENGTH_SHIFT)
#define  POGO_IDMA1_POGO_IDMA_UDMA_UPR_DESCLENGTH_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA1_POGO_IDMA_UDMA_UPR_DESCLENGTH_MASK) | (((uint32_t)val) << POGO_IDMA1_POGO_IDMA_UDMA_UPR_DESCLENGTH_SHIFT))

#define  POGO_IDMA1_POGO_IDMA_UDMA_UPR_BUSWIDTH_MASK 0x4
#define  POGO_IDMA1_POGO_IDMA_UDMA_UPR_BUSWIDTH_SHIFT 2
#define  POGO_IDMA1_POGO_IDMA_UDMA_UPR_BUSWIDTH_MASK_SHIFT(reg) (((reg) & POGO_IDMA1_POGO_IDMA_UDMA_UPR_BUSWIDTH_MASK) >> POGO_IDMA1_POGO_IDMA_UDMA_UPR_BUSWIDTH_SHIFT)
#define  POGO_IDMA1_POGO_IDMA_UDMA_UPR_BUSWIDTH_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA1_POGO_IDMA_UDMA_UPR_BUSWIDTH_MASK) | (((uint32_t)val) << POGO_IDMA1_POGO_IDMA_UDMA_UPR_BUSWIDTH_SHIFT))

#define  POGO_IDMA1_POGO_IDMA_UDMA_UPR_MEMALIGN_MASK 0x3
#define  POGO_IDMA1_POGO_IDMA_UDMA_UPR_MEMALIGN_SHIFT 0
#define  POGO_IDMA1_POGO_IDMA_UDMA_UPR_MEMALIGN_MASK_SHIFT(reg) (((reg) & POGO_IDMA1_POGO_IDMA_UDMA_UPR_MEMALIGN_MASK) >> POGO_IDMA1_POGO_IDMA_UDMA_UPR_MEMALIGN_SHIFT)
#define  POGO_IDMA1_POGO_IDMA_UDMA_UPR_MEMALIGN_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA1_POGO_IDMA_UDMA_UPR_MEMALIGN_MASK) | (((uint32_t)val) << POGO_IDMA1_POGO_IDMA_UDMA_UPR_MEMALIGN_SHIFT))

//====================================================================
//Register: UDMA Interrupt Enable Register (UIER)
//====================================================================

#define  POGO_IDMA1_POGO_IDMA_UDMA_UIER_RESERVED1_MASK 0xffffffc0
#define  POGO_IDMA1_POGO_IDMA_UDMA_UIER_RESERVED1_SHIFT 6
#define  POGO_IDMA1_POGO_IDMA_UDMA_UIER_RESERVED1_MASK_SHIFT(reg) (((reg) & POGO_IDMA1_POGO_IDMA_UDMA_UIER_RESERVED1_MASK) >> POGO_IDMA1_POGO_IDMA_UDMA_UIER_RESERVED1_SHIFT)
#define  POGO_IDMA1_POGO_IDMA_UDMA_UIER_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA1_POGO_IDMA_UDMA_UIER_RESERVED1_MASK) | (((uint32_t)val) << POGO_IDMA1_POGO_IDMA_UDMA_UIER_RESERVED1_SHIFT))

#define  POGO_IDMA1_POGO_IDMA_UDMA_UIER_OUTOFRANGE_MASK 0x20
#define  POGO_IDMA1_POGO_IDMA_UDMA_UIER_OUTOFRANGE_SHIFT 5
#define  POGO_IDMA1_POGO_IDMA_UDMA_UIER_OUTOFRANGE_MASK_SHIFT(reg) (((reg) & POGO_IDMA1_POGO_IDMA_UDMA_UIER_OUTOFRANGE_MASK) >> POGO_IDMA1_POGO_IDMA_UDMA_UIER_OUTOFRANGE_SHIFT)
#define  POGO_IDMA1_POGO_IDMA_UDMA_UIER_OUTOFRANGE_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA1_POGO_IDMA_UDMA_UIER_OUTOFRANGE_MASK) | (((uint32_t)val) << POGO_IDMA1_POGO_IDMA_UDMA_UIER_OUTOFRANGE_SHIFT))

#define  POGO_IDMA1_POGO_IDMA_UDMA_UIER_RRESP_MASK 0x10
#define  POGO_IDMA1_POGO_IDMA_UDMA_UIER_RRESP_SHIFT 4
#define  POGO_IDMA1_POGO_IDMA_UDMA_UIER_RRESP_MASK_SHIFT(reg) (((reg) & POGO_IDMA1_POGO_IDMA_UDMA_UIER_RRESP_MASK) >> POGO_IDMA1_POGO_IDMA_UDMA_UIER_RRESP_SHIFT)
#define  POGO_IDMA1_POGO_IDMA_UDMA_UIER_RRESP_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA1_POGO_IDMA_UDMA_UIER_RRESP_MASK) | (((uint32_t)val) << POGO_IDMA1_POGO_IDMA_UDMA_UIER_RRESP_SHIFT))

#define  POGO_IDMA1_POGO_IDMA_UDMA_UIER_BRESP_MASK 0x8
#define  POGO_IDMA1_POGO_IDMA_UDMA_UIER_BRESP_SHIFT 3
#define  POGO_IDMA1_POGO_IDMA_UDMA_UIER_BRESP_MASK_SHIFT(reg) (((reg) & POGO_IDMA1_POGO_IDMA_UDMA_UIER_BRESP_MASK) >> POGO_IDMA1_POGO_IDMA_UDMA_UIER_BRESP_SHIFT)
#define  POGO_IDMA1_POGO_IDMA_UDMA_UIER_BRESP_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA1_POGO_IDMA_UDMA_UIER_BRESP_MASK) | (((uint32_t)val) << POGO_IDMA1_POGO_IDMA_UDMA_UIER_BRESP_SHIFT))

#define  POGO_IDMA1_POGO_IDMA_UDMA_UIER_CLEARCOMPLETE_MASK 0x4
#define  POGO_IDMA1_POGO_IDMA_UDMA_UIER_CLEARCOMPLETE_SHIFT 2
#define  POGO_IDMA1_POGO_IDMA_UDMA_UIER_CLEARCOMPLETE_MASK_SHIFT(reg) (((reg) & POGO_IDMA1_POGO_IDMA_UDMA_UIER_CLEARCOMPLETE_MASK) >> POGO_IDMA1_POGO_IDMA_UDMA_UIER_CLEARCOMPLETE_SHIFT)
#define  POGO_IDMA1_POGO_IDMA_UDMA_UIER_CLEARCOMPLETE_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA1_POGO_IDMA_UDMA_UIER_CLEARCOMPLETE_MASK) | (((uint32_t)val) << POGO_IDMA1_POGO_IDMA_UDMA_UIER_CLEARCOMPLETE_SHIFT))

#define  POGO_IDMA1_POGO_IDMA_UDMA_UIER_DESC_MASK 0x2
#define  POGO_IDMA1_POGO_IDMA_UDMA_UIER_DESC_SHIFT 1
#define  POGO_IDMA1_POGO_IDMA_UDMA_UIER_DESC_MASK_SHIFT(reg) (((reg) & POGO_IDMA1_POGO_IDMA_UDMA_UIER_DESC_MASK) >> POGO_IDMA1_POGO_IDMA_UDMA_UIER_DESC_SHIFT)
#define  POGO_IDMA1_POGO_IDMA_UDMA_UIER_DESC_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA1_POGO_IDMA_UDMA_UIER_DESC_MASK) | (((uint32_t)val) << POGO_IDMA1_POGO_IDMA_UDMA_UIER_DESC_SHIFT))

#define  POGO_IDMA1_POGO_IDMA_UDMA_UIER_OWN_MASK 0x1
#define  POGO_IDMA1_POGO_IDMA_UDMA_UIER_OWN_SHIFT 0
#define  POGO_IDMA1_POGO_IDMA_UDMA_UIER_OWN_MASK_SHIFT(reg) (((reg) & POGO_IDMA1_POGO_IDMA_UDMA_UIER_OWN_MASK) >> POGO_IDMA1_POGO_IDMA_UDMA_UIER_OWN_SHIFT)
#define  POGO_IDMA1_POGO_IDMA_UDMA_UIER_OWN_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA1_POGO_IDMA_UDMA_UIER_OWN_MASK) | (((uint32_t)val) << POGO_IDMA1_POGO_IDMA_UDMA_UIER_OWN_SHIFT))

//====================================================================
//Register: UDMA Interrupt Pending Register (UIPR)
//====================================================================

#define  POGO_IDMA1_POGO_IDMA_UDMA_UIPR_RESERVED1_MASK 0xffffffc0
#define  POGO_IDMA1_POGO_IDMA_UDMA_UIPR_RESERVED1_SHIFT 6
#define  POGO_IDMA1_POGO_IDMA_UDMA_UIPR_RESERVED1_MASK_SHIFT(reg) (((reg) & POGO_IDMA1_POGO_IDMA_UDMA_UIPR_RESERVED1_MASK) >> POGO_IDMA1_POGO_IDMA_UDMA_UIPR_RESERVED1_SHIFT)
#define  POGO_IDMA1_POGO_IDMA_UDMA_UIPR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA1_POGO_IDMA_UDMA_UIPR_RESERVED1_MASK) | (((uint32_t)val) << POGO_IDMA1_POGO_IDMA_UDMA_UIPR_RESERVED1_SHIFT))

#define  POGO_IDMA1_POGO_IDMA_UDMA_UIPR_OUTOFRANGE_MASK 0x20
#define  POGO_IDMA1_POGO_IDMA_UDMA_UIPR_OUTOFRANGE_SHIFT 5
#define  POGO_IDMA1_POGO_IDMA_UDMA_UIPR_OUTOFRANGE_MASK_SHIFT(reg) (((reg) & POGO_IDMA1_POGO_IDMA_UDMA_UIPR_OUTOFRANGE_MASK) >> POGO_IDMA1_POGO_IDMA_UDMA_UIPR_OUTOFRANGE_SHIFT)
#define  POGO_IDMA1_POGO_IDMA_UDMA_UIPR_OUTOFRANGE_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA1_POGO_IDMA_UDMA_UIPR_OUTOFRANGE_MASK) | (((uint32_t)val) << POGO_IDMA1_POGO_IDMA_UDMA_UIPR_OUTOFRANGE_SHIFT))

#define  POGO_IDMA1_POGO_IDMA_UDMA_UIPR_RRESP_MASK 0x10
#define  POGO_IDMA1_POGO_IDMA_UDMA_UIPR_RRESP_SHIFT 4
#define  POGO_IDMA1_POGO_IDMA_UDMA_UIPR_RRESP_MASK_SHIFT(reg) (((reg) & POGO_IDMA1_POGO_IDMA_UDMA_UIPR_RRESP_MASK) >> POGO_IDMA1_POGO_IDMA_UDMA_UIPR_RRESP_SHIFT)
#define  POGO_IDMA1_POGO_IDMA_UDMA_UIPR_RRESP_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA1_POGO_IDMA_UDMA_UIPR_RRESP_MASK) | (((uint32_t)val) << POGO_IDMA1_POGO_IDMA_UDMA_UIPR_RRESP_SHIFT))

#define  POGO_IDMA1_POGO_IDMA_UDMA_UIPR_BRESP_MASK 0x8
#define  POGO_IDMA1_POGO_IDMA_UDMA_UIPR_BRESP_SHIFT 3
#define  POGO_IDMA1_POGO_IDMA_UDMA_UIPR_BRESP_MASK_SHIFT(reg) (((reg) & POGO_IDMA1_POGO_IDMA_UDMA_UIPR_BRESP_MASK) >> POGO_IDMA1_POGO_IDMA_UDMA_UIPR_BRESP_SHIFT)
#define  POGO_IDMA1_POGO_IDMA_UDMA_UIPR_BRESP_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA1_POGO_IDMA_UDMA_UIPR_BRESP_MASK) | (((uint32_t)val) << POGO_IDMA1_POGO_IDMA_UDMA_UIPR_BRESP_SHIFT))

#define  POGO_IDMA1_POGO_IDMA_UDMA_UIPR_CLEARCOMPLETE_MASK 0x4
#define  POGO_IDMA1_POGO_IDMA_UDMA_UIPR_CLEARCOMPLETE_SHIFT 2
#define  POGO_IDMA1_POGO_IDMA_UDMA_UIPR_CLEARCOMPLETE_MASK_SHIFT(reg) (((reg) & POGO_IDMA1_POGO_IDMA_UDMA_UIPR_CLEARCOMPLETE_MASK) >> POGO_IDMA1_POGO_IDMA_UDMA_UIPR_CLEARCOMPLETE_SHIFT)
#define  POGO_IDMA1_POGO_IDMA_UDMA_UIPR_CLEARCOMPLETE_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA1_POGO_IDMA_UDMA_UIPR_CLEARCOMPLETE_MASK) | (((uint32_t)val) << POGO_IDMA1_POGO_IDMA_UDMA_UIPR_CLEARCOMPLETE_SHIFT))

#define  POGO_IDMA1_POGO_IDMA_UDMA_UIPR_DESC_MASK 0x2
#define  POGO_IDMA1_POGO_IDMA_UDMA_UIPR_DESC_SHIFT 1
#define  POGO_IDMA1_POGO_IDMA_UDMA_UIPR_DESC_MASK_SHIFT(reg) (((reg) & POGO_IDMA1_POGO_IDMA_UDMA_UIPR_DESC_MASK) >> POGO_IDMA1_POGO_IDMA_UDMA_UIPR_DESC_SHIFT)
#define  POGO_IDMA1_POGO_IDMA_UDMA_UIPR_DESC_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA1_POGO_IDMA_UDMA_UIPR_DESC_MASK) | (((uint32_t)val) << POGO_IDMA1_POGO_IDMA_UDMA_UIPR_DESC_SHIFT))

#define  POGO_IDMA1_POGO_IDMA_UDMA_UIPR_OWN_MASK 0x1
#define  POGO_IDMA1_POGO_IDMA_UDMA_UIPR_OWN_SHIFT 0
#define  POGO_IDMA1_POGO_IDMA_UDMA_UIPR_OWN_MASK_SHIFT(reg) (((reg) & POGO_IDMA1_POGO_IDMA_UDMA_UIPR_OWN_MASK) >> POGO_IDMA1_POGO_IDMA_UDMA_UIPR_OWN_SHIFT)
#define  POGO_IDMA1_POGO_IDMA_UDMA_UIPR_OWN_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA1_POGO_IDMA_UDMA_UIPR_OWN_MASK) | (((uint32_t)val) << POGO_IDMA1_POGO_IDMA_UDMA_UIPR_OWN_SHIFT))

//====================================================================
//Register: UDMA Interrupt Clear Register (UICR)
//====================================================================

#define  POGO_IDMA1_POGO_IDMA_UDMA_UICR_RESERVED1_MASK 0xffffffc0
#define  POGO_IDMA1_POGO_IDMA_UDMA_UICR_RESERVED1_SHIFT 6
#define  POGO_IDMA1_POGO_IDMA_UDMA_UICR_RESERVED1_MASK_SHIFT(reg) (((reg) & POGO_IDMA1_POGO_IDMA_UDMA_UICR_RESERVED1_MASK) >> POGO_IDMA1_POGO_IDMA_UDMA_UICR_RESERVED1_SHIFT)
#define  POGO_IDMA1_POGO_IDMA_UDMA_UICR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA1_POGO_IDMA_UDMA_UICR_RESERVED1_MASK) | (((uint32_t)val) << POGO_IDMA1_POGO_IDMA_UDMA_UICR_RESERVED1_SHIFT))

#define  POGO_IDMA1_POGO_IDMA_UDMA_UICR_OUTOFRANGE_MASK 0x20
#define  POGO_IDMA1_POGO_IDMA_UDMA_UICR_OUTOFRANGE_SHIFT 5
#define  POGO_IDMA1_POGO_IDMA_UDMA_UICR_OUTOFRANGE_MASK_SHIFT(reg) (((reg) & POGO_IDMA1_POGO_IDMA_UDMA_UICR_OUTOFRANGE_MASK) >> POGO_IDMA1_POGO_IDMA_UDMA_UICR_OUTOFRANGE_SHIFT)
#define  POGO_IDMA1_POGO_IDMA_UDMA_UICR_OUTOFRANGE_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA1_POGO_IDMA_UDMA_UICR_OUTOFRANGE_MASK) | (((uint32_t)val) << POGO_IDMA1_POGO_IDMA_UDMA_UICR_OUTOFRANGE_SHIFT))

#define  POGO_IDMA1_POGO_IDMA_UDMA_UICR_RRESP_MASK 0x10
#define  POGO_IDMA1_POGO_IDMA_UDMA_UICR_RRESP_SHIFT 4
#define  POGO_IDMA1_POGO_IDMA_UDMA_UICR_RRESP_MASK_SHIFT(reg) (((reg) & POGO_IDMA1_POGO_IDMA_UDMA_UICR_RRESP_MASK) >> POGO_IDMA1_POGO_IDMA_UDMA_UICR_RRESP_SHIFT)
#define  POGO_IDMA1_POGO_IDMA_UDMA_UICR_RRESP_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA1_POGO_IDMA_UDMA_UICR_RRESP_MASK) | (((uint32_t)val) << POGO_IDMA1_POGO_IDMA_UDMA_UICR_RRESP_SHIFT))

#define  POGO_IDMA1_POGO_IDMA_UDMA_UICR_BRESP_MASK 0x8
#define  POGO_IDMA1_POGO_IDMA_UDMA_UICR_BRESP_SHIFT 3
#define  POGO_IDMA1_POGO_IDMA_UDMA_UICR_BRESP_MASK_SHIFT(reg) (((reg) & POGO_IDMA1_POGO_IDMA_UDMA_UICR_BRESP_MASK) >> POGO_IDMA1_POGO_IDMA_UDMA_UICR_BRESP_SHIFT)
#define  POGO_IDMA1_POGO_IDMA_UDMA_UICR_BRESP_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA1_POGO_IDMA_UDMA_UICR_BRESP_MASK) | (((uint32_t)val) << POGO_IDMA1_POGO_IDMA_UDMA_UICR_BRESP_SHIFT))

#define  POGO_IDMA1_POGO_IDMA_UDMA_UICR_CLEARCOMPLETE_MASK 0x4
#define  POGO_IDMA1_POGO_IDMA_UDMA_UICR_CLEARCOMPLETE_SHIFT 2
#define  POGO_IDMA1_POGO_IDMA_UDMA_UICR_CLEARCOMPLETE_MASK_SHIFT(reg) (((reg) & POGO_IDMA1_POGO_IDMA_UDMA_UICR_CLEARCOMPLETE_MASK) >> POGO_IDMA1_POGO_IDMA_UDMA_UICR_CLEARCOMPLETE_SHIFT)
#define  POGO_IDMA1_POGO_IDMA_UDMA_UICR_CLEARCOMPLETE_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA1_POGO_IDMA_UDMA_UICR_CLEARCOMPLETE_MASK) | (((uint32_t)val) << POGO_IDMA1_POGO_IDMA_UDMA_UICR_CLEARCOMPLETE_SHIFT))

#define  POGO_IDMA1_POGO_IDMA_UDMA_UICR_DESC_MASK 0x2
#define  POGO_IDMA1_POGO_IDMA_UDMA_UICR_DESC_SHIFT 1
#define  POGO_IDMA1_POGO_IDMA_UDMA_UICR_DESC_MASK_SHIFT(reg) (((reg) & POGO_IDMA1_POGO_IDMA_UDMA_UICR_DESC_MASK) >> POGO_IDMA1_POGO_IDMA_UDMA_UICR_DESC_SHIFT)
#define  POGO_IDMA1_POGO_IDMA_UDMA_UICR_DESC_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA1_POGO_IDMA_UDMA_UICR_DESC_MASK) | (((uint32_t)val) << POGO_IDMA1_POGO_IDMA_UDMA_UICR_DESC_SHIFT))

#define  POGO_IDMA1_POGO_IDMA_UDMA_UICR_OWN_MASK 0x1
#define  POGO_IDMA1_POGO_IDMA_UDMA_UICR_OWN_SHIFT 0
#define  POGO_IDMA1_POGO_IDMA_UDMA_UICR_OWN_MASK_SHIFT(reg) (((reg) & POGO_IDMA1_POGO_IDMA_UDMA_UICR_OWN_MASK) >> POGO_IDMA1_POGO_IDMA_UDMA_UICR_OWN_SHIFT)
#define  POGO_IDMA1_POGO_IDMA_UDMA_UICR_OWN_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA1_POGO_IDMA_UDMA_UICR_OWN_MASK) | (((uint32_t)val) << POGO_IDMA1_POGO_IDMA_UDMA_UICR_OWN_SHIFT))

//====================================================================
//Register: UDMA Interrupt Force Register (UIFR)
//====================================================================

#define  POGO_IDMA1_POGO_IDMA_UDMA_UIFR_RESERVED1_MASK 0xffffffc0
#define  POGO_IDMA1_POGO_IDMA_UDMA_UIFR_RESERVED1_SHIFT 6
#define  POGO_IDMA1_POGO_IDMA_UDMA_UIFR_RESERVED1_MASK_SHIFT(reg) (((reg) & POGO_IDMA1_POGO_IDMA_UDMA_UIFR_RESERVED1_MASK) >> POGO_IDMA1_POGO_IDMA_UDMA_UIFR_RESERVED1_SHIFT)
#define  POGO_IDMA1_POGO_IDMA_UDMA_UIFR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA1_POGO_IDMA_UDMA_UIFR_RESERVED1_MASK) | (((uint32_t)val) << POGO_IDMA1_POGO_IDMA_UDMA_UIFR_RESERVED1_SHIFT))

#define  POGO_IDMA1_POGO_IDMA_UDMA_UIFR_OUTOFRANGE_MASK 0x20
#define  POGO_IDMA1_POGO_IDMA_UDMA_UIFR_OUTOFRANGE_SHIFT 5
#define  POGO_IDMA1_POGO_IDMA_UDMA_UIFR_OUTOFRANGE_MASK_SHIFT(reg) (((reg) & POGO_IDMA1_POGO_IDMA_UDMA_UIFR_OUTOFRANGE_MASK) >> POGO_IDMA1_POGO_IDMA_UDMA_UIFR_OUTOFRANGE_SHIFT)
#define  POGO_IDMA1_POGO_IDMA_UDMA_UIFR_OUTOFRANGE_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA1_POGO_IDMA_UDMA_UIFR_OUTOFRANGE_MASK) | (((uint32_t)val) << POGO_IDMA1_POGO_IDMA_UDMA_UIFR_OUTOFRANGE_SHIFT))

#define  POGO_IDMA1_POGO_IDMA_UDMA_UIFR_RRESP_MASK 0x10
#define  POGO_IDMA1_POGO_IDMA_UDMA_UIFR_RRESP_SHIFT 4
#define  POGO_IDMA1_POGO_IDMA_UDMA_UIFR_RRESP_MASK_SHIFT(reg) (((reg) & POGO_IDMA1_POGO_IDMA_UDMA_UIFR_RRESP_MASK) >> POGO_IDMA1_POGO_IDMA_UDMA_UIFR_RRESP_SHIFT)
#define  POGO_IDMA1_POGO_IDMA_UDMA_UIFR_RRESP_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA1_POGO_IDMA_UDMA_UIFR_RRESP_MASK) | (((uint32_t)val) << POGO_IDMA1_POGO_IDMA_UDMA_UIFR_RRESP_SHIFT))

#define  POGO_IDMA1_POGO_IDMA_UDMA_UIFR_BRESP_MASK 0x8
#define  POGO_IDMA1_POGO_IDMA_UDMA_UIFR_BRESP_SHIFT 3
#define  POGO_IDMA1_POGO_IDMA_UDMA_UIFR_BRESP_MASK_SHIFT(reg) (((reg) & POGO_IDMA1_POGO_IDMA_UDMA_UIFR_BRESP_MASK) >> POGO_IDMA1_POGO_IDMA_UDMA_UIFR_BRESP_SHIFT)
#define  POGO_IDMA1_POGO_IDMA_UDMA_UIFR_BRESP_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA1_POGO_IDMA_UDMA_UIFR_BRESP_MASK) | (((uint32_t)val) << POGO_IDMA1_POGO_IDMA_UDMA_UIFR_BRESP_SHIFT))

#define  POGO_IDMA1_POGO_IDMA_UDMA_UIFR_CLEARCOMPLETE_MASK 0x4
#define  POGO_IDMA1_POGO_IDMA_UDMA_UIFR_CLEARCOMPLETE_SHIFT 2
#define  POGO_IDMA1_POGO_IDMA_UDMA_UIFR_CLEARCOMPLETE_MASK_SHIFT(reg) (((reg) & POGO_IDMA1_POGO_IDMA_UDMA_UIFR_CLEARCOMPLETE_MASK) >> POGO_IDMA1_POGO_IDMA_UDMA_UIFR_CLEARCOMPLETE_SHIFT)
#define  POGO_IDMA1_POGO_IDMA_UDMA_UIFR_CLEARCOMPLETE_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA1_POGO_IDMA_UDMA_UIFR_CLEARCOMPLETE_MASK) | (((uint32_t)val) << POGO_IDMA1_POGO_IDMA_UDMA_UIFR_CLEARCOMPLETE_SHIFT))

#define  POGO_IDMA1_POGO_IDMA_UDMA_UIFR_DESC_MASK 0x2
#define  POGO_IDMA1_POGO_IDMA_UDMA_UIFR_DESC_SHIFT 1
#define  POGO_IDMA1_POGO_IDMA_UDMA_UIFR_DESC_MASK_SHIFT(reg) (((reg) & POGO_IDMA1_POGO_IDMA_UDMA_UIFR_DESC_MASK) >> POGO_IDMA1_POGO_IDMA_UDMA_UIFR_DESC_SHIFT)
#define  POGO_IDMA1_POGO_IDMA_UDMA_UIFR_DESC_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA1_POGO_IDMA_UDMA_UIFR_DESC_MASK) | (((uint32_t)val) << POGO_IDMA1_POGO_IDMA_UDMA_UIFR_DESC_SHIFT))

#define  POGO_IDMA1_POGO_IDMA_UDMA_UIFR_OWN_MASK 0x1
#define  POGO_IDMA1_POGO_IDMA_UDMA_UIFR_OWN_SHIFT 0
#define  POGO_IDMA1_POGO_IDMA_UDMA_UIFR_OWN_MASK_SHIFT(reg) (((reg) & POGO_IDMA1_POGO_IDMA_UDMA_UIFR_OWN_MASK) >> POGO_IDMA1_POGO_IDMA_UDMA_UIFR_OWN_SHIFT)
#define  POGO_IDMA1_POGO_IDMA_UDMA_UIFR_OWN_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA1_POGO_IDMA_UDMA_UIFR_OWN_MASK) | (((uint32_t)val) << POGO_IDMA1_POGO_IDMA_UDMA_UIFR_OWN_SHIFT))

//====================================================================
//Register: UDMA Descriptor Register (UDR)
//====================================================================

#define  POGO_IDMA1_POGO_IDMA_UDMA_UDR_DESC_MASK 0xffffffff
#define  POGO_IDMA1_POGO_IDMA_UDMA_UDR_DESC_SHIFT 0
#define  POGO_IDMA1_POGO_IDMA_UDMA_UDR_DESC_MASK_SHIFT(reg) (((reg) & POGO_IDMA1_POGO_IDMA_UDMA_UDR_DESC_MASK) >> POGO_IDMA1_POGO_IDMA_UDMA_UDR_DESC_SHIFT)
#define  POGO_IDMA1_POGO_IDMA_UDMA_UDR_DESC_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA1_POGO_IDMA_UDMA_UDR_DESC_MASK) | (((uint32_t)val) << POGO_IDMA1_POGO_IDMA_UDMA_UDR_DESC_SHIFT))

//====================================================================
//Register: UDMA Burst Address Register (UBAR)
//====================================================================

#define  POGO_IDMA1_POGO_IDMA_UDMA_UBAR_BURSTADDR_MASK 0xffffffff
#define  POGO_IDMA1_POGO_IDMA_UDMA_UBAR_BURSTADDR_SHIFT 0
#define  POGO_IDMA1_POGO_IDMA_UDMA_UBAR_BURSTADDR_MASK_SHIFT(reg) (((reg) & POGO_IDMA1_POGO_IDMA_UDMA_UBAR_BURSTADDR_MASK) >> POGO_IDMA1_POGO_IDMA_UDMA_UBAR_BURSTADDR_SHIFT)
#define  POGO_IDMA1_POGO_IDMA_UDMA_UBAR_BURSTADDR_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA1_POGO_IDMA_UDMA_UBAR_BURSTADDR_MASK) | (((uint32_t)val) << POGO_IDMA1_POGO_IDMA_UDMA_UBAR_BURSTADDR_SHIFT))

//====================================================================
//Register: UDMA Burst Length Register (UBLR)
//====================================================================

#define  POGO_IDMA1_POGO_IDMA_UDMA_UBLR_RESERVED1_MASK 0xfffffc00
#define  POGO_IDMA1_POGO_IDMA_UDMA_UBLR_RESERVED1_SHIFT 10
#define  POGO_IDMA1_POGO_IDMA_UDMA_UBLR_RESERVED1_MASK_SHIFT(reg) (((reg) & POGO_IDMA1_POGO_IDMA_UDMA_UBLR_RESERVED1_MASK) >> POGO_IDMA1_POGO_IDMA_UDMA_UBLR_RESERVED1_SHIFT)
#define  POGO_IDMA1_POGO_IDMA_UDMA_UBLR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA1_POGO_IDMA_UDMA_UBLR_RESERVED1_MASK) | (((uint32_t)val) << POGO_IDMA1_POGO_IDMA_UDMA_UBLR_RESERVED1_SHIFT))

#define  POGO_IDMA1_POGO_IDMA_UDMA_UBLR_BURSTDIR_MASK 0x200
#define  POGO_IDMA1_POGO_IDMA_UDMA_UBLR_BURSTDIR_SHIFT 9
#define  POGO_IDMA1_POGO_IDMA_UDMA_UBLR_BURSTDIR_MASK_SHIFT(reg) (((reg) & POGO_IDMA1_POGO_IDMA_UDMA_UBLR_BURSTDIR_MASK) >> POGO_IDMA1_POGO_IDMA_UDMA_UBLR_BURSTDIR_SHIFT)
#define  POGO_IDMA1_POGO_IDMA_UDMA_UBLR_BURSTDIR_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA1_POGO_IDMA_UDMA_UBLR_BURSTDIR_MASK) | (((uint32_t)val) << POGO_IDMA1_POGO_IDMA_UDMA_UBLR_BURSTDIR_SHIFT))

#define  POGO_IDMA1_POGO_IDMA_UDMA_UBLR_BURSTLAST_MASK 0x100
#define  POGO_IDMA1_POGO_IDMA_UDMA_UBLR_BURSTLAST_SHIFT 8
#define  POGO_IDMA1_POGO_IDMA_UDMA_UBLR_BURSTLAST_MASK_SHIFT(reg) (((reg) & POGO_IDMA1_POGO_IDMA_UDMA_UBLR_BURSTLAST_MASK) >> POGO_IDMA1_POGO_IDMA_UDMA_UBLR_BURSTLAST_SHIFT)
#define  POGO_IDMA1_POGO_IDMA_UDMA_UBLR_BURSTLAST_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA1_POGO_IDMA_UDMA_UBLR_BURSTLAST_MASK) | (((uint32_t)val) << POGO_IDMA1_POGO_IDMA_UDMA_UBLR_BURSTLAST_SHIFT))

#define  POGO_IDMA1_POGO_IDMA_UDMA_UBLR_BURSTLENGTH_MASK 0xff
#define  POGO_IDMA1_POGO_IDMA_UDMA_UBLR_BURSTLENGTH_SHIFT 0
#define  POGO_IDMA1_POGO_IDMA_UDMA_UBLR_BURSTLENGTH_MASK_SHIFT(reg) (((reg) & POGO_IDMA1_POGO_IDMA_UDMA_UBLR_BURSTLENGTH_MASK) >> POGO_IDMA1_POGO_IDMA_UDMA_UBLR_BURSTLENGTH_SHIFT)
#define  POGO_IDMA1_POGO_IDMA_UDMA_UBLR_BURSTLENGTH_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA1_POGO_IDMA_UDMA_UBLR_BURSTLENGTH_MASK) | (((uint32_t)val) << POGO_IDMA1_POGO_IDMA_UDMA_UBLR_BURSTLENGTH_SHIFT))

//====================================================================
//Register: UDMA Transfer Bytes Remaining Register (UBRR)
//====================================================================

#define  POGO_IDMA1_POGO_IDMA_UDMA_UBRR_BYTESREMAIN_MASK 0xffffffff
#define  POGO_IDMA1_POGO_IDMA_UDMA_UBRR_BYTESREMAIN_SHIFT 0
#define  POGO_IDMA1_POGO_IDMA_UDMA_UBRR_BYTESREMAIN_MASK_SHIFT(reg) (((reg) & POGO_IDMA1_POGO_IDMA_UDMA_UBRR_BYTESREMAIN_MASK) >> POGO_IDMA1_POGO_IDMA_UDMA_UBRR_BYTESREMAIN_SHIFT)
#define  POGO_IDMA1_POGO_IDMA_UDMA_UBRR_BYTESREMAIN_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA1_POGO_IDMA_UDMA_UBRR_BYTESREMAIN_MASK) | (((uint32_t)val) << POGO_IDMA1_POGO_IDMA_UDMA_UBRR_BYTESREMAIN_SHIFT))

//====================================================================
//Register: UDMA Tag Register 0 (UTR0)
//====================================================================

#define  POGO_IDMA1_POGO_IDMA_UDMA_UTR0_TAGMAJ_MASK 0xffff0000
#define  POGO_IDMA1_POGO_IDMA_UDMA_UTR0_TAGMAJ_SHIFT 16
#define  POGO_IDMA1_POGO_IDMA_UDMA_UTR0_TAGMAJ_MASK_SHIFT(reg) (((reg) & POGO_IDMA1_POGO_IDMA_UDMA_UTR0_TAGMAJ_MASK) >> POGO_IDMA1_POGO_IDMA_UDMA_UTR0_TAGMAJ_SHIFT)
#define  POGO_IDMA1_POGO_IDMA_UDMA_UTR0_TAGMAJ_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA1_POGO_IDMA_UDMA_UTR0_TAGMAJ_MASK) | (((uint32_t)val) << POGO_IDMA1_POGO_IDMA_UDMA_UTR0_TAGMAJ_SHIFT))

#define  POGO_IDMA1_POGO_IDMA_UDMA_UTR0_TAGMID_MASK 0xffff
#define  POGO_IDMA1_POGO_IDMA_UDMA_UTR0_TAGMID_SHIFT 0
#define  POGO_IDMA1_POGO_IDMA_UDMA_UTR0_TAGMID_MASK_SHIFT(reg) (((reg) & POGO_IDMA1_POGO_IDMA_UDMA_UTR0_TAGMID_MASK) >> POGO_IDMA1_POGO_IDMA_UDMA_UTR0_TAGMID_SHIFT)
#define  POGO_IDMA1_POGO_IDMA_UDMA_UTR0_TAGMID_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA1_POGO_IDMA_UDMA_UTR0_TAGMID_MASK) | (((uint32_t)val) << POGO_IDMA1_POGO_IDMA_UDMA_UTR0_TAGMID_SHIFT))

//====================================================================
//Register: UDMA Tag Register 1 (UTR1)
//====================================================================

#define  POGO_IDMA1_POGO_IDMA_UDMA_UTR1_RESERVED1_MASK 0xffff0000
#define  POGO_IDMA1_POGO_IDMA_UDMA_UTR1_RESERVED1_SHIFT 16
#define  POGO_IDMA1_POGO_IDMA_UDMA_UTR1_RESERVED1_MASK_SHIFT(reg) (((reg) & POGO_IDMA1_POGO_IDMA_UDMA_UTR1_RESERVED1_MASK) >> POGO_IDMA1_POGO_IDMA_UDMA_UTR1_RESERVED1_SHIFT)
#define  POGO_IDMA1_POGO_IDMA_UDMA_UTR1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA1_POGO_IDMA_UDMA_UTR1_RESERVED1_MASK) | (((uint32_t)val) << POGO_IDMA1_POGO_IDMA_UDMA_UTR1_RESERVED1_SHIFT))

#define  POGO_IDMA1_POGO_IDMA_UDMA_UTR1_TAGCFG_MASK 0xffff
#define  POGO_IDMA1_POGO_IDMA_UDMA_UTR1_TAGCFG_SHIFT 0
#define  POGO_IDMA1_POGO_IDMA_UDMA_UTR1_TAGCFG_MASK_SHIFT(reg) (((reg) & POGO_IDMA1_POGO_IDMA_UDMA_UTR1_TAGCFG_MASK) >> POGO_IDMA1_POGO_IDMA_UDMA_UTR1_TAGCFG_SHIFT)
#define  POGO_IDMA1_POGO_IDMA_UDMA_UTR1_TAGCFG_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA1_POGO_IDMA_UDMA_UTR1_TAGCFG_MASK) | (((uint32_t)val) << POGO_IDMA1_POGO_IDMA_UDMA_UTR1_TAGCFG_SHIFT))

//====================================================================
//
//Register File: POGO_IDMA_CORE (POGO_IDMA1_POGO_IDMA_CORE)
//
//====================================================================

//====================================================================
//Register: IDMA Configuration Register (ICR)
//====================================================================

#define  POGO_IDMA1_POGO_IDMA_CORE_ICR_RESERVED1_MASK 0xfffffffc
#define  POGO_IDMA1_POGO_IDMA_CORE_ICR_RESERVED1_SHIFT 2
#define  POGO_IDMA1_POGO_IDMA_CORE_ICR_RESERVED1_MASK_SHIFT(reg) (((reg) & POGO_IDMA1_POGO_IDMA_CORE_ICR_RESERVED1_MASK) >> POGO_IDMA1_POGO_IDMA_CORE_ICR_RESERVED1_SHIFT)
#define  POGO_IDMA1_POGO_IDMA_CORE_ICR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA1_POGO_IDMA_CORE_ICR_RESERVED1_MASK) | (((uint32_t)val) << POGO_IDMA1_POGO_IDMA_CORE_ICR_RESERVED1_SHIFT))

#define  POGO_IDMA1_POGO_IDMA_CORE_ICR_BURSTSIZE_MASK 0x3
#define  POGO_IDMA1_POGO_IDMA_CORE_ICR_BURSTSIZE_SHIFT 0
#define  POGO_IDMA1_POGO_IDMA_CORE_ICR_BURSTSIZE_MASK_SHIFT(reg) (((reg) & POGO_IDMA1_POGO_IDMA_CORE_ICR_BURSTSIZE_MASK) >> POGO_IDMA1_POGO_IDMA_CORE_ICR_BURSTSIZE_SHIFT)
#define  POGO_IDMA1_POGO_IDMA_CORE_ICR_BURSTSIZE_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA1_POGO_IDMA_CORE_ICR_BURSTSIZE_MASK) | (((uint32_t)val) << POGO_IDMA1_POGO_IDMA_CORE_ICR_BURSTSIZE_SHIFT))

//====================================================================
//Register: IDMA Interrupt Enable Register (IIER)
//====================================================================

#define  POGO_IDMA1_POGO_IDMA_CORE_IIER_RESERVED1_MASK 0xfffffffc
#define  POGO_IDMA1_POGO_IDMA_CORE_IIER_RESERVED1_SHIFT 2
#define  POGO_IDMA1_POGO_IDMA_CORE_IIER_RESERVED1_MASK_SHIFT(reg) (((reg) & POGO_IDMA1_POGO_IDMA_CORE_IIER_RESERVED1_MASK) >> POGO_IDMA1_POGO_IDMA_CORE_IIER_RESERVED1_SHIFT)
#define  POGO_IDMA1_POGO_IDMA_CORE_IIER_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA1_POGO_IDMA_CORE_IIER_RESERVED1_MASK) | (((uint32_t)val) << POGO_IDMA1_POGO_IDMA_CORE_IIER_RESERVED1_SHIFT))

#define  POGO_IDMA1_POGO_IDMA_CORE_IIER_LENGTHERR_MASK 0x2
#define  POGO_IDMA1_POGO_IDMA_CORE_IIER_LENGTHERR_SHIFT 1
#define  POGO_IDMA1_POGO_IDMA_CORE_IIER_LENGTHERR_MASK_SHIFT(reg) (((reg) & POGO_IDMA1_POGO_IDMA_CORE_IIER_LENGTHERR_MASK) >> POGO_IDMA1_POGO_IDMA_CORE_IIER_LENGTHERR_SHIFT)
#define  POGO_IDMA1_POGO_IDMA_CORE_IIER_LENGTHERR_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA1_POGO_IDMA_CORE_IIER_LENGTHERR_MASK) | (((uint32_t)val) << POGO_IDMA1_POGO_IDMA_CORE_IIER_LENGTHERR_SHIFT))

#define  POGO_IDMA1_POGO_IDMA_CORE_IIER_EOS_MASK 0x1
#define  POGO_IDMA1_POGO_IDMA_CORE_IIER_EOS_SHIFT 0
#define  POGO_IDMA1_POGO_IDMA_CORE_IIER_EOS_MASK_SHIFT(reg) (((reg) & POGO_IDMA1_POGO_IDMA_CORE_IIER_EOS_MASK) >> POGO_IDMA1_POGO_IDMA_CORE_IIER_EOS_SHIFT)
#define  POGO_IDMA1_POGO_IDMA_CORE_IIER_EOS_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA1_POGO_IDMA_CORE_IIER_EOS_MASK) | (((uint32_t)val) << POGO_IDMA1_POGO_IDMA_CORE_IIER_EOS_SHIFT))

//====================================================================
//Register: IDMA Interrupt Pending Register (IIPR)
//====================================================================

#define  POGO_IDMA1_POGO_IDMA_CORE_IIPR_RESERVED1_MASK 0xfffffffc
#define  POGO_IDMA1_POGO_IDMA_CORE_IIPR_RESERVED1_SHIFT 2
#define  POGO_IDMA1_POGO_IDMA_CORE_IIPR_RESERVED1_MASK_SHIFT(reg) (((reg) & POGO_IDMA1_POGO_IDMA_CORE_IIPR_RESERVED1_MASK) >> POGO_IDMA1_POGO_IDMA_CORE_IIPR_RESERVED1_SHIFT)
#define  POGO_IDMA1_POGO_IDMA_CORE_IIPR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA1_POGO_IDMA_CORE_IIPR_RESERVED1_MASK) | (((uint32_t)val) << POGO_IDMA1_POGO_IDMA_CORE_IIPR_RESERVED1_SHIFT))

#define  POGO_IDMA1_POGO_IDMA_CORE_IIPR_LENGTHERR_MASK 0x2
#define  POGO_IDMA1_POGO_IDMA_CORE_IIPR_LENGTHERR_SHIFT 1
#define  POGO_IDMA1_POGO_IDMA_CORE_IIPR_LENGTHERR_MASK_SHIFT(reg) (((reg) & POGO_IDMA1_POGO_IDMA_CORE_IIPR_LENGTHERR_MASK) >> POGO_IDMA1_POGO_IDMA_CORE_IIPR_LENGTHERR_SHIFT)
#define  POGO_IDMA1_POGO_IDMA_CORE_IIPR_LENGTHERR_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA1_POGO_IDMA_CORE_IIPR_LENGTHERR_MASK) | (((uint32_t)val) << POGO_IDMA1_POGO_IDMA_CORE_IIPR_LENGTHERR_SHIFT))

#define  POGO_IDMA1_POGO_IDMA_CORE_IIPR_EOS_MASK 0x1
#define  POGO_IDMA1_POGO_IDMA_CORE_IIPR_EOS_SHIFT 0
#define  POGO_IDMA1_POGO_IDMA_CORE_IIPR_EOS_MASK_SHIFT(reg) (((reg) & POGO_IDMA1_POGO_IDMA_CORE_IIPR_EOS_MASK) >> POGO_IDMA1_POGO_IDMA_CORE_IIPR_EOS_SHIFT)
#define  POGO_IDMA1_POGO_IDMA_CORE_IIPR_EOS_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA1_POGO_IDMA_CORE_IIPR_EOS_MASK) | (((uint32_t)val) << POGO_IDMA1_POGO_IDMA_CORE_IIPR_EOS_SHIFT))

//====================================================================
//Register: IDMA Interrupt Clear Register (IICR)
//====================================================================

#define  POGO_IDMA1_POGO_IDMA_CORE_IICR_RESERVED1_MASK 0xfffffffc
#define  POGO_IDMA1_POGO_IDMA_CORE_IICR_RESERVED1_SHIFT 2
#define  POGO_IDMA1_POGO_IDMA_CORE_IICR_RESERVED1_MASK_SHIFT(reg) (((reg) & POGO_IDMA1_POGO_IDMA_CORE_IICR_RESERVED1_MASK) >> POGO_IDMA1_POGO_IDMA_CORE_IICR_RESERVED1_SHIFT)
#define  POGO_IDMA1_POGO_IDMA_CORE_IICR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA1_POGO_IDMA_CORE_IICR_RESERVED1_MASK) | (((uint32_t)val) << POGO_IDMA1_POGO_IDMA_CORE_IICR_RESERVED1_SHIFT))

#define  POGO_IDMA1_POGO_IDMA_CORE_IICR_LENGTHERR_MASK 0x2
#define  POGO_IDMA1_POGO_IDMA_CORE_IICR_LENGTHERR_SHIFT 1
#define  POGO_IDMA1_POGO_IDMA_CORE_IICR_LENGTHERR_MASK_SHIFT(reg) (((reg) & POGO_IDMA1_POGO_IDMA_CORE_IICR_LENGTHERR_MASK) >> POGO_IDMA1_POGO_IDMA_CORE_IICR_LENGTHERR_SHIFT)
#define  POGO_IDMA1_POGO_IDMA_CORE_IICR_LENGTHERR_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA1_POGO_IDMA_CORE_IICR_LENGTHERR_MASK) | (((uint32_t)val) << POGO_IDMA1_POGO_IDMA_CORE_IICR_LENGTHERR_SHIFT))

#define  POGO_IDMA1_POGO_IDMA_CORE_IICR_EOS_MASK 0x1
#define  POGO_IDMA1_POGO_IDMA_CORE_IICR_EOS_SHIFT 0
#define  POGO_IDMA1_POGO_IDMA_CORE_IICR_EOS_MASK_SHIFT(reg) (((reg) & POGO_IDMA1_POGO_IDMA_CORE_IICR_EOS_MASK) >> POGO_IDMA1_POGO_IDMA_CORE_IICR_EOS_SHIFT)
#define  POGO_IDMA1_POGO_IDMA_CORE_IICR_EOS_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA1_POGO_IDMA_CORE_IICR_EOS_MASK) | (((uint32_t)val) << POGO_IDMA1_POGO_IDMA_CORE_IICR_EOS_SHIFT))

//====================================================================
//Register: IDMA Interrupt Force Register (IIFR)
//====================================================================

#define  POGO_IDMA1_POGO_IDMA_CORE_IIFR_RESERVED1_MASK 0xfffffffc
#define  POGO_IDMA1_POGO_IDMA_CORE_IIFR_RESERVED1_SHIFT 2
#define  POGO_IDMA1_POGO_IDMA_CORE_IIFR_RESERVED1_MASK_SHIFT(reg) (((reg) & POGO_IDMA1_POGO_IDMA_CORE_IIFR_RESERVED1_MASK) >> POGO_IDMA1_POGO_IDMA_CORE_IIFR_RESERVED1_SHIFT)
#define  POGO_IDMA1_POGO_IDMA_CORE_IIFR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA1_POGO_IDMA_CORE_IIFR_RESERVED1_MASK) | (((uint32_t)val) << POGO_IDMA1_POGO_IDMA_CORE_IIFR_RESERVED1_SHIFT))

#define  POGO_IDMA1_POGO_IDMA_CORE_IIFR_LENGTHERR_MASK 0x2
#define  POGO_IDMA1_POGO_IDMA_CORE_IIFR_LENGTHERR_SHIFT 1
#define  POGO_IDMA1_POGO_IDMA_CORE_IIFR_LENGTHERR_MASK_SHIFT(reg) (((reg) & POGO_IDMA1_POGO_IDMA_CORE_IIFR_LENGTHERR_MASK) >> POGO_IDMA1_POGO_IDMA_CORE_IIFR_LENGTHERR_SHIFT)
#define  POGO_IDMA1_POGO_IDMA_CORE_IIFR_LENGTHERR_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA1_POGO_IDMA_CORE_IIFR_LENGTHERR_MASK) | (((uint32_t)val) << POGO_IDMA1_POGO_IDMA_CORE_IIFR_LENGTHERR_SHIFT))

#define  POGO_IDMA1_POGO_IDMA_CORE_IIFR_EOS_MASK 0x1
#define  POGO_IDMA1_POGO_IDMA_CORE_IIFR_EOS_SHIFT 0
#define  POGO_IDMA1_POGO_IDMA_CORE_IIFR_EOS_MASK_SHIFT(reg) (((reg) & POGO_IDMA1_POGO_IDMA_CORE_IIFR_EOS_MASK) >> POGO_IDMA1_POGO_IDMA_CORE_IIFR_EOS_SHIFT)
#define  POGO_IDMA1_POGO_IDMA_CORE_IIFR_EOS_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA1_POGO_IDMA_CORE_IIFR_EOS_MASK) | (((uint32_t)val) << POGO_IDMA1_POGO_IDMA_CORE_IIFR_EOS_SHIFT))

//====================================================================
//Register: IDMA Line Width Register (ILWR)
//====================================================================

#define  POGO_IDMA1_POGO_IDMA_CORE_ILWR_RESERVED1_MASK 0xfff00000
#define  POGO_IDMA1_POGO_IDMA_CORE_ILWR_RESERVED1_SHIFT 20
#define  POGO_IDMA1_POGO_IDMA_CORE_ILWR_RESERVED1_MASK_SHIFT(reg) (((reg) & POGO_IDMA1_POGO_IDMA_CORE_ILWR_RESERVED1_MASK) >> POGO_IDMA1_POGO_IDMA_CORE_ILWR_RESERVED1_SHIFT)
#define  POGO_IDMA1_POGO_IDMA_CORE_ILWR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA1_POGO_IDMA_CORE_ILWR_RESERVED1_MASK) | (((uint32_t)val) << POGO_IDMA1_POGO_IDMA_CORE_ILWR_RESERVED1_SHIFT))

#define  POGO_IDMA1_POGO_IDMA_CORE_ILWR_LINEWIDTH_MASK 0xfffff
#define  POGO_IDMA1_POGO_IDMA_CORE_ILWR_LINEWIDTH_SHIFT 0
#define  POGO_IDMA1_POGO_IDMA_CORE_ILWR_LINEWIDTH_MASK_SHIFT(reg) (((reg) & POGO_IDMA1_POGO_IDMA_CORE_ILWR_LINEWIDTH_MASK) >> POGO_IDMA1_POGO_IDMA_CORE_ILWR_LINEWIDTH_SHIFT)
#define  POGO_IDMA1_POGO_IDMA_CORE_ILWR_LINEWIDTH_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA1_POGO_IDMA_CORE_ILWR_LINEWIDTH_MASK) | (((uint32_t)val) << POGO_IDMA1_POGO_IDMA_CORE_ILWR_LINEWIDTH_SHIFT))

//====================================================================
//Register: IDMA Row Height Register (IRHR)
//====================================================================

#define  POGO_IDMA1_POGO_IDMA_CORE_IRHR_RESERVED1_MASK 0xffffffc0
#define  POGO_IDMA1_POGO_IDMA_CORE_IRHR_RESERVED1_SHIFT 6
#define  POGO_IDMA1_POGO_IDMA_CORE_IRHR_RESERVED1_MASK_SHIFT(reg) (((reg) & POGO_IDMA1_POGO_IDMA_CORE_IRHR_RESERVED1_MASK) >> POGO_IDMA1_POGO_IDMA_CORE_IRHR_RESERVED1_SHIFT)
#define  POGO_IDMA1_POGO_IDMA_CORE_IRHR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA1_POGO_IDMA_CORE_IRHR_RESERVED1_MASK) | (((uint32_t)val) << POGO_IDMA1_POGO_IDMA_CORE_IRHR_RESERVED1_SHIFT))

#define  POGO_IDMA1_POGO_IDMA_CORE_IRHR_ROWHEIGHT_MASK 0x3f
#define  POGO_IDMA1_POGO_IDMA_CORE_IRHR_ROWHEIGHT_SHIFT 0
#define  POGO_IDMA1_POGO_IDMA_CORE_IRHR_ROWHEIGHT_MASK_SHIFT(reg) (((reg) & POGO_IDMA1_POGO_IDMA_CORE_IRHR_ROWHEIGHT_MASK) >> POGO_IDMA1_POGO_IDMA_CORE_IRHR_ROWHEIGHT_SHIFT)
#define  POGO_IDMA1_POGO_IDMA_CORE_IRHR_ROWHEIGHT_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA1_POGO_IDMA_CORE_IRHR_ROWHEIGHT_MASK) | (((uint32_t)val) << POGO_IDMA1_POGO_IDMA_CORE_IRHR_ROWHEIGHT_SHIFT))

//====================================================================
//Register: IDMA Tag Register 0 (ITR0)
//====================================================================

#define  POGO_IDMA1_POGO_IDMA_CORE_ITR0_RESERVED1_MASK 0xffff0000
#define  POGO_IDMA1_POGO_IDMA_CORE_ITR0_RESERVED1_SHIFT 16
#define  POGO_IDMA1_POGO_IDMA_CORE_ITR0_RESERVED1_MASK_SHIFT(reg) (((reg) & POGO_IDMA1_POGO_IDMA_CORE_ITR0_RESERVED1_MASK) >> POGO_IDMA1_POGO_IDMA_CORE_ITR0_RESERVED1_SHIFT)
#define  POGO_IDMA1_POGO_IDMA_CORE_ITR0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA1_POGO_IDMA_CORE_ITR0_RESERVED1_MASK) | (((uint32_t)val) << POGO_IDMA1_POGO_IDMA_CORE_ITR0_RESERVED1_SHIFT))

#define  POGO_IDMA1_POGO_IDMA_CORE_ITR0_TAGCFG_MASK 0xffff
#define  POGO_IDMA1_POGO_IDMA_CORE_ITR0_TAGCFG_SHIFT 0
#define  POGO_IDMA1_POGO_IDMA_CORE_ITR0_TAGCFG_MASK_SHIFT(reg) (((reg) & POGO_IDMA1_POGO_IDMA_CORE_ITR0_TAGCFG_MASK) >> POGO_IDMA1_POGO_IDMA_CORE_ITR0_TAGCFG_SHIFT)
#define  POGO_IDMA1_POGO_IDMA_CORE_ITR0_TAGCFG_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA1_POGO_IDMA_CORE_ITR0_TAGCFG_MASK) | (((uint32_t)val) << POGO_IDMA1_POGO_IDMA_CORE_ITR0_TAGCFG_SHIFT))

//====================================================================
//Register: IDMA Tag Register 1 (ITR1)
//====================================================================

#define  POGO_IDMA1_POGO_IDMA_CORE_ITR1_RESERVED1_MASK 0xffff0000
#define  POGO_IDMA1_POGO_IDMA_CORE_ITR1_RESERVED1_SHIFT 16
#define  POGO_IDMA1_POGO_IDMA_CORE_ITR1_RESERVED1_MASK_SHIFT(reg) (((reg) & POGO_IDMA1_POGO_IDMA_CORE_ITR1_RESERVED1_MASK) >> POGO_IDMA1_POGO_IDMA_CORE_ITR1_RESERVED1_SHIFT)
#define  POGO_IDMA1_POGO_IDMA_CORE_ITR1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA1_POGO_IDMA_CORE_ITR1_RESERVED1_MASK) | (((uint32_t)val) << POGO_IDMA1_POGO_IDMA_CORE_ITR1_RESERVED1_SHIFT))

#define  POGO_IDMA1_POGO_IDMA_CORE_ITR1_TAGMAJ_MASK 0xffff
#define  POGO_IDMA1_POGO_IDMA_CORE_ITR1_TAGMAJ_SHIFT 0
#define  POGO_IDMA1_POGO_IDMA_CORE_ITR1_TAGMAJ_MASK_SHIFT(reg) (((reg) & POGO_IDMA1_POGO_IDMA_CORE_ITR1_TAGMAJ_MASK) >> POGO_IDMA1_POGO_IDMA_CORE_ITR1_TAGMAJ_SHIFT)
#define  POGO_IDMA1_POGO_IDMA_CORE_ITR1_TAGMAJ_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA1_POGO_IDMA_CORE_ITR1_TAGMAJ_MASK) | (((uint32_t)val) << POGO_IDMA1_POGO_IDMA_CORE_ITR1_TAGMAJ_SHIFT))

//====================================================================
//Register: IDMA Tag Register 2 (ITR2)
//====================================================================

#define  POGO_IDMA1_POGO_IDMA_CORE_ITR2_RESERVED1_MASK 0xffff0000
#define  POGO_IDMA1_POGO_IDMA_CORE_ITR2_RESERVED1_SHIFT 16
#define  POGO_IDMA1_POGO_IDMA_CORE_ITR2_RESERVED1_MASK_SHIFT(reg) (((reg) & POGO_IDMA1_POGO_IDMA_CORE_ITR2_RESERVED1_MASK) >> POGO_IDMA1_POGO_IDMA_CORE_ITR2_RESERVED1_SHIFT)
#define  POGO_IDMA1_POGO_IDMA_CORE_ITR2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA1_POGO_IDMA_CORE_ITR2_RESERVED1_MASK) | (((uint32_t)val) << POGO_IDMA1_POGO_IDMA_CORE_ITR2_RESERVED1_SHIFT))

#define  POGO_IDMA1_POGO_IDMA_CORE_ITR2_TAGMID_MASK 0xffff
#define  POGO_IDMA1_POGO_IDMA_CORE_ITR2_TAGMID_SHIFT 0
#define  POGO_IDMA1_POGO_IDMA_CORE_ITR2_TAGMID_MASK_SHIFT(reg) (((reg) & POGO_IDMA1_POGO_IDMA_CORE_ITR2_TAGMID_MASK) >> POGO_IDMA1_POGO_IDMA_CORE_ITR2_TAGMID_SHIFT)
#define  POGO_IDMA1_POGO_IDMA_CORE_ITR2_TAGMID_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA1_POGO_IDMA_CORE_ITR2_TAGMID_MASK) | (((uint32_t)val) << POGO_IDMA1_POGO_IDMA_CORE_ITR2_TAGMID_SHIFT))

//====================================================================
//
//Register File: POGO_IDMA_UDMA (POGO_IDMA2_POGO_IDMA_UDMA)
//
//====================================================================

//====================================================================
//Register: UDMA Configuration Register (UCR)
//====================================================================

#define  POGO_IDMA2_POGO_IDMA_UDMA_UCR_RESERVED1_MASK 0xfff00000
#define  POGO_IDMA2_POGO_IDMA_UDMA_UCR_RESERVED1_SHIFT 20
#define  POGO_IDMA2_POGO_IDMA_UDMA_UCR_RESERVED1_MASK_SHIFT(reg) (((reg) & POGO_IDMA2_POGO_IDMA_UDMA_UCR_RESERVED1_MASK) >> POGO_IDMA2_POGO_IDMA_UDMA_UCR_RESERVED1_SHIFT)
#define  POGO_IDMA2_POGO_IDMA_UDMA_UCR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA2_POGO_IDMA_UDMA_UCR_RESERVED1_MASK) | (((uint32_t)val) << POGO_IDMA2_POGO_IDMA_UDMA_UCR_RESERVED1_SHIFT))

#define  POGO_IDMA2_POGO_IDMA_UDMA_UCR_DATAAXCACHE_MASK 0xf0000
#define  POGO_IDMA2_POGO_IDMA_UDMA_UCR_DATAAXCACHE_SHIFT 16
#define  POGO_IDMA2_POGO_IDMA_UDMA_UCR_DATAAXCACHE_MASK_SHIFT(reg) (((reg) & POGO_IDMA2_POGO_IDMA_UDMA_UCR_DATAAXCACHE_MASK) >> POGO_IDMA2_POGO_IDMA_UDMA_UCR_DATAAXCACHE_SHIFT)
#define  POGO_IDMA2_POGO_IDMA_UDMA_UCR_DATAAXCACHE_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA2_POGO_IDMA_UDMA_UCR_DATAAXCACHE_MASK) | (((uint32_t)val) << POGO_IDMA2_POGO_IDMA_UDMA_UCR_DATAAXCACHE_SHIFT))

#define  POGO_IDMA2_POGO_IDMA_UDMA_UCR_DESCARCACHE_MASK 0xf000
#define  POGO_IDMA2_POGO_IDMA_UDMA_UCR_DESCARCACHE_SHIFT 12
#define  POGO_IDMA2_POGO_IDMA_UDMA_UCR_DESCARCACHE_MASK_SHIFT(reg) (((reg) & POGO_IDMA2_POGO_IDMA_UDMA_UCR_DESCARCACHE_MASK) >> POGO_IDMA2_POGO_IDMA_UDMA_UCR_DESCARCACHE_SHIFT)
#define  POGO_IDMA2_POGO_IDMA_UDMA_UCR_DESCARCACHE_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA2_POGO_IDMA_UDMA_UCR_DESCARCACHE_MASK) | (((uint32_t)val) << POGO_IDMA2_POGO_IDMA_UDMA_UCR_DESCARCACHE_SHIFT))

#define  POGO_IDMA2_POGO_IDMA_UDMA_UCR_DESCAWCACHE_MASK 0xf00
#define  POGO_IDMA2_POGO_IDMA_UDMA_UCR_DESCAWCACHE_SHIFT 8
#define  POGO_IDMA2_POGO_IDMA_UDMA_UCR_DESCAWCACHE_MASK_SHIFT(reg) (((reg) & POGO_IDMA2_POGO_IDMA_UDMA_UCR_DESCAWCACHE_MASK) >> POGO_IDMA2_POGO_IDMA_UDMA_UCR_DESCAWCACHE_SHIFT)
#define  POGO_IDMA2_POGO_IDMA_UDMA_UCR_DESCAWCACHE_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA2_POGO_IDMA_UDMA_UCR_DESCAWCACHE_MASK) | (((uint32_t)val) << POGO_IDMA2_POGO_IDMA_UDMA_UCR_DESCAWCACHE_SHIFT))

#define  POGO_IDMA2_POGO_IDMA_UDMA_UCR_RESERVED2_MASK 0xc0
#define  POGO_IDMA2_POGO_IDMA_UDMA_UCR_RESERVED2_SHIFT 6
#define  POGO_IDMA2_POGO_IDMA_UDMA_UCR_RESERVED2_MASK_SHIFT(reg) (((reg) & POGO_IDMA2_POGO_IDMA_UDMA_UCR_RESERVED2_MASK) >> POGO_IDMA2_POGO_IDMA_UDMA_UCR_RESERVED2_SHIFT)
#define  POGO_IDMA2_POGO_IDMA_UDMA_UCR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA2_POGO_IDMA_UDMA_UCR_RESERVED2_MASK) | (((uint32_t)val) << POGO_IDMA2_POGO_IDMA_UDMA_UCR_RESERVED2_SHIFT))

#define  POGO_IDMA2_POGO_IDMA_UDMA_UCR_HANDSHAKEENABLE_MASK 0x20
#define  POGO_IDMA2_POGO_IDMA_UDMA_UCR_HANDSHAKEENABLE_SHIFT 5
#define  POGO_IDMA2_POGO_IDMA_UDMA_UCR_HANDSHAKEENABLE_MASK_SHIFT(reg) (((reg) & POGO_IDMA2_POGO_IDMA_UDMA_UCR_HANDSHAKEENABLE_MASK) >> POGO_IDMA2_POGO_IDMA_UDMA_UCR_HANDSHAKEENABLE_SHIFT)
#define  POGO_IDMA2_POGO_IDMA_UDMA_UCR_HANDSHAKEENABLE_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA2_POGO_IDMA_UDMA_UCR_HANDSHAKEENABLE_MASK) | (((uint32_t)val) << POGO_IDMA2_POGO_IDMA_UDMA_UCR_HANDSHAKEENABLE_SHIFT))

#define  POGO_IDMA2_POGO_IDMA_UDMA_UCR_OWNWRITEDISABLE_MASK 0x10
#define  POGO_IDMA2_POGO_IDMA_UDMA_UCR_OWNWRITEDISABLE_SHIFT 4
#define  POGO_IDMA2_POGO_IDMA_UDMA_UCR_OWNWRITEDISABLE_MASK_SHIFT(reg) (((reg) & POGO_IDMA2_POGO_IDMA_UDMA_UCR_OWNWRITEDISABLE_MASK) >> POGO_IDMA2_POGO_IDMA_UDMA_UCR_OWNWRITEDISABLE_SHIFT)
#define  POGO_IDMA2_POGO_IDMA_UDMA_UCR_OWNWRITEDISABLE_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA2_POGO_IDMA_UDMA_UCR_OWNWRITEDISABLE_MASK) | (((uint32_t)val) << POGO_IDMA2_POGO_IDMA_UDMA_UCR_OWNWRITEDISABLE_SHIFT))

#define  POGO_IDMA2_POGO_IDMA_UDMA_UCR_OWNPOLARITY_MASK 0x8
#define  POGO_IDMA2_POGO_IDMA_UDMA_UCR_OWNPOLARITY_SHIFT 3
#define  POGO_IDMA2_POGO_IDMA_UDMA_UCR_OWNPOLARITY_MASK_SHIFT(reg) (((reg) & POGO_IDMA2_POGO_IDMA_UDMA_UCR_OWNPOLARITY_MASK) >> POGO_IDMA2_POGO_IDMA_UDMA_UCR_OWNPOLARITY_SHIFT)
#define  POGO_IDMA2_POGO_IDMA_UDMA_UCR_OWNPOLARITY_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA2_POGO_IDMA_UDMA_UCR_OWNPOLARITY_MASK) | (((uint32_t)val) << POGO_IDMA2_POGO_IDMA_UDMA_UCR_OWNPOLARITY_SHIFT))

#define  POGO_IDMA2_POGO_IDMA_UDMA_UCR_BEATS_MASK 0x6
#define  POGO_IDMA2_POGO_IDMA_UDMA_UCR_BEATS_SHIFT 1
#define  POGO_IDMA2_POGO_IDMA_UDMA_UCR_BEATS_MASK_SHIFT(reg) (((reg) & POGO_IDMA2_POGO_IDMA_UDMA_UCR_BEATS_MASK) >> POGO_IDMA2_POGO_IDMA_UDMA_UCR_BEATS_SHIFT)
#define  POGO_IDMA2_POGO_IDMA_UDMA_UCR_BEATS_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA2_POGO_IDMA_UDMA_UCR_BEATS_MASK) | (((uint32_t)val) << POGO_IDMA2_POGO_IDMA_UDMA_UCR_BEATS_SHIFT))

#define  POGO_IDMA2_POGO_IDMA_UDMA_UCR_ENABLE_MASK 0x1
#define  POGO_IDMA2_POGO_IDMA_UDMA_UCR_ENABLE_SHIFT 0
#define  POGO_IDMA2_POGO_IDMA_UDMA_UCR_ENABLE_MASK_SHIFT(reg) (((reg) & POGO_IDMA2_POGO_IDMA_UDMA_UCR_ENABLE_MASK) >> POGO_IDMA2_POGO_IDMA_UDMA_UCR_ENABLE_SHIFT)
#define  POGO_IDMA2_POGO_IDMA_UDMA_UCR_ENABLE_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA2_POGO_IDMA_UDMA_UCR_ENABLE_MASK) | (((uint32_t)val) << POGO_IDMA2_POGO_IDMA_UDMA_UCR_ENABLE_SHIFT))

//====================================================================
//Register: UDMA Status Register (USR)
//====================================================================

#define  POGO_IDMA2_POGO_IDMA_UDMA_USR_RESERVED1_MASK 0xfffff800
#define  POGO_IDMA2_POGO_IDMA_UDMA_USR_RESERVED1_SHIFT 11
#define  POGO_IDMA2_POGO_IDMA_UDMA_USR_RESERVED1_MASK_SHIFT(reg) (((reg) & POGO_IDMA2_POGO_IDMA_UDMA_USR_RESERVED1_MASK) >> POGO_IDMA2_POGO_IDMA_UDMA_USR_RESERVED1_SHIFT)
#define  POGO_IDMA2_POGO_IDMA_UDMA_USR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA2_POGO_IDMA_UDMA_USR_RESERVED1_MASK) | (((uint32_t)val) << POGO_IDMA2_POGO_IDMA_UDMA_USR_RESERVED1_SHIFT))

#define  POGO_IDMA2_POGO_IDMA_UDMA_USR_DMAPAUSED_MASK 0x400
#define  POGO_IDMA2_POGO_IDMA_UDMA_USR_DMAPAUSED_SHIFT 10
#define  POGO_IDMA2_POGO_IDMA_UDMA_USR_DMAPAUSED_MASK_SHIFT(reg) (((reg) & POGO_IDMA2_POGO_IDMA_UDMA_USR_DMAPAUSED_MASK) >> POGO_IDMA2_POGO_IDMA_UDMA_USR_DMAPAUSED_SHIFT)
#define  POGO_IDMA2_POGO_IDMA_UDMA_USR_DMAPAUSED_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA2_POGO_IDMA_UDMA_USR_DMAPAUSED_MASK) | (((uint32_t)val) << POGO_IDMA2_POGO_IDMA_UDMA_USR_DMAPAUSED_SHIFT))

#define  POGO_IDMA2_POGO_IDMA_UDMA_USR_PAUSEAFTER_MASK 0x200
#define  POGO_IDMA2_POGO_IDMA_UDMA_USR_PAUSEAFTER_SHIFT 9
#define  POGO_IDMA2_POGO_IDMA_UDMA_USR_PAUSEAFTER_MASK_SHIFT(reg) (((reg) & POGO_IDMA2_POGO_IDMA_UDMA_USR_PAUSEAFTER_MASK) >> POGO_IDMA2_POGO_IDMA_UDMA_USR_PAUSEAFTER_SHIFT)
#define  POGO_IDMA2_POGO_IDMA_UDMA_USR_PAUSEAFTER_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA2_POGO_IDMA_UDMA_USR_PAUSEAFTER_MASK) | (((uint32_t)val) << POGO_IDMA2_POGO_IDMA_UDMA_USR_PAUSEAFTER_SHIFT))

#define  POGO_IDMA2_POGO_IDMA_UDMA_USR_PAUSEBEFORE_MASK 0x100
#define  POGO_IDMA2_POGO_IDMA_UDMA_USR_PAUSEBEFORE_SHIFT 8
#define  POGO_IDMA2_POGO_IDMA_UDMA_USR_PAUSEBEFORE_MASK_SHIFT(reg) (((reg) & POGO_IDMA2_POGO_IDMA_UDMA_USR_PAUSEBEFORE_MASK) >> POGO_IDMA2_POGO_IDMA_UDMA_USR_PAUSEBEFORE_SHIFT)
#define  POGO_IDMA2_POGO_IDMA_UDMA_USR_PAUSEBEFORE_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA2_POGO_IDMA_UDMA_USR_PAUSEBEFORE_MASK) | (((uint32_t)val) << POGO_IDMA2_POGO_IDMA_UDMA_USR_PAUSEBEFORE_SHIFT))

#define  POGO_IDMA2_POGO_IDMA_UDMA_USR_INTONFINISH_MASK 0x80
#define  POGO_IDMA2_POGO_IDMA_UDMA_USR_INTONFINISH_SHIFT 7
#define  POGO_IDMA2_POGO_IDMA_UDMA_USR_INTONFINISH_MASK_SHIFT(reg) (((reg) & POGO_IDMA2_POGO_IDMA_UDMA_USR_INTONFINISH_MASK) >> POGO_IDMA2_POGO_IDMA_UDMA_USR_INTONFINISH_SHIFT)
#define  POGO_IDMA2_POGO_IDMA_UDMA_USR_INTONFINISH_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA2_POGO_IDMA_UDMA_USR_INTONFINISH_MASK) | (((uint32_t)val) << POGO_IDMA2_POGO_IDMA_UDMA_USR_INTONFINISH_SHIFT))

#define  POGO_IDMA2_POGO_IDMA_UDMA_USR_STOPONFINISH_MASK 0x40
#define  POGO_IDMA2_POGO_IDMA_UDMA_USR_STOPONFINISH_SHIFT 6
#define  POGO_IDMA2_POGO_IDMA_UDMA_USR_STOPONFINISH_MASK_SHIFT(reg) (((reg) & POGO_IDMA2_POGO_IDMA_UDMA_USR_STOPONFINISH_MASK) >> POGO_IDMA2_POGO_IDMA_UDMA_USR_STOPONFINISH_SHIFT)
#define  POGO_IDMA2_POGO_IDMA_UDMA_USR_STOPONFINISH_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA2_POGO_IDMA_UDMA_USR_STOPONFINISH_MASK) | (((uint32_t)val) << POGO_IDMA2_POGO_IDMA_UDMA_USR_STOPONFINISH_SHIFT))

#define  POGO_IDMA2_POGO_IDMA_UDMA_USR_CMDBUFFULL_MASK 0x20
#define  POGO_IDMA2_POGO_IDMA_UDMA_USR_CMDBUFFULL_SHIFT 5
#define  POGO_IDMA2_POGO_IDMA_UDMA_USR_CMDBUFFULL_MASK_SHIFT(reg) (((reg) & POGO_IDMA2_POGO_IDMA_UDMA_USR_CMDBUFFULL_MASK) >> POGO_IDMA2_POGO_IDMA_UDMA_USR_CMDBUFFULL_SHIFT)
#define  POGO_IDMA2_POGO_IDMA_UDMA_USR_CMDBUFFULL_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA2_POGO_IDMA_UDMA_USR_CMDBUFFULL_MASK) | (((uint32_t)val) << POGO_IDMA2_POGO_IDMA_UDMA_USR_CMDBUFFULL_SHIFT))

#define  POGO_IDMA2_POGO_IDMA_UDMA_USR_CMDBUFEMPTY_MASK 0x10
#define  POGO_IDMA2_POGO_IDMA_UDMA_USR_CMDBUFEMPTY_SHIFT 4
#define  POGO_IDMA2_POGO_IDMA_UDMA_USR_CMDBUFEMPTY_MASK_SHIFT(reg) (((reg) & POGO_IDMA2_POGO_IDMA_UDMA_USR_CMDBUFEMPTY_MASK) >> POGO_IDMA2_POGO_IDMA_UDMA_USR_CMDBUFEMPTY_SHIFT)
#define  POGO_IDMA2_POGO_IDMA_UDMA_USR_CMDBUFEMPTY_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA2_POGO_IDMA_UDMA_USR_CMDBUFEMPTY_MASK) | (((uint32_t)val) << POGO_IDMA2_POGO_IDMA_UDMA_USR_CMDBUFEMPTY_SHIFT))

#define  POGO_IDMA2_POGO_IDMA_UDMA_USR_DATABUFFULL_MASK 0x8
#define  POGO_IDMA2_POGO_IDMA_UDMA_USR_DATABUFFULL_SHIFT 3
#define  POGO_IDMA2_POGO_IDMA_UDMA_USR_DATABUFFULL_MASK_SHIFT(reg) (((reg) & POGO_IDMA2_POGO_IDMA_UDMA_USR_DATABUFFULL_MASK) >> POGO_IDMA2_POGO_IDMA_UDMA_USR_DATABUFFULL_SHIFT)
#define  POGO_IDMA2_POGO_IDMA_UDMA_USR_DATABUFFULL_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA2_POGO_IDMA_UDMA_USR_DATABUFFULL_MASK) | (((uint32_t)val) << POGO_IDMA2_POGO_IDMA_UDMA_USR_DATABUFFULL_SHIFT))

#define  POGO_IDMA2_POGO_IDMA_UDMA_USR_DATABUFEMPTY_MASK 0x4
#define  POGO_IDMA2_POGO_IDMA_UDMA_USR_DATABUFEMPTY_SHIFT 2
#define  POGO_IDMA2_POGO_IDMA_UDMA_USR_DATABUFEMPTY_MASK_SHIFT(reg) (((reg) & POGO_IDMA2_POGO_IDMA_UDMA_USR_DATABUFEMPTY_MASK) >> POGO_IDMA2_POGO_IDMA_UDMA_USR_DATABUFEMPTY_SHIFT)
#define  POGO_IDMA2_POGO_IDMA_UDMA_USR_DATABUFEMPTY_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA2_POGO_IDMA_UDMA_USR_DATABUFEMPTY_MASK) | (((uint32_t)val) << POGO_IDMA2_POGO_IDMA_UDMA_USR_DATABUFEMPTY_SHIFT))

#define  POGO_IDMA2_POGO_IDMA_UDMA_USR_CLEAR_MASK 0x2
#define  POGO_IDMA2_POGO_IDMA_UDMA_USR_CLEAR_SHIFT 1
#define  POGO_IDMA2_POGO_IDMA_UDMA_USR_CLEAR_MASK_SHIFT(reg) (((reg) & POGO_IDMA2_POGO_IDMA_UDMA_USR_CLEAR_MASK) >> POGO_IDMA2_POGO_IDMA_UDMA_USR_CLEAR_SHIFT)
#define  POGO_IDMA2_POGO_IDMA_UDMA_USR_CLEAR_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA2_POGO_IDMA_UDMA_USR_CLEAR_MASK) | (((uint32_t)val) << POGO_IDMA2_POGO_IDMA_UDMA_USR_CLEAR_SHIFT))

#define  POGO_IDMA2_POGO_IDMA_UDMA_USR_BUSY_MASK 0x1
#define  POGO_IDMA2_POGO_IDMA_UDMA_USR_BUSY_SHIFT 0
#define  POGO_IDMA2_POGO_IDMA_UDMA_USR_BUSY_MASK_SHIFT(reg) (((reg) & POGO_IDMA2_POGO_IDMA_UDMA_USR_BUSY_MASK) >> POGO_IDMA2_POGO_IDMA_UDMA_USR_BUSY_SHIFT)
#define  POGO_IDMA2_POGO_IDMA_UDMA_USR_BUSY_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA2_POGO_IDMA_UDMA_USR_BUSY_MASK) | (((uint32_t)val) << POGO_IDMA2_POGO_IDMA_UDMA_USR_BUSY_SHIFT))

//====================================================================
//Register: UDMA Parameter Register (UPR)
//====================================================================

#define  POGO_IDMA2_POGO_IDMA_UDMA_UPR_RESERVED1_MASK 0xff000000
#define  POGO_IDMA2_POGO_IDMA_UDMA_UPR_RESERVED1_SHIFT 24
#define  POGO_IDMA2_POGO_IDMA_UDMA_UPR_RESERVED1_MASK_SHIFT(reg) (((reg) & POGO_IDMA2_POGO_IDMA_UDMA_UPR_RESERVED1_MASK) >> POGO_IDMA2_POGO_IDMA_UDMA_UPR_RESERVED1_SHIFT)
#define  POGO_IDMA2_POGO_IDMA_UDMA_UPR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA2_POGO_IDMA_UDMA_UPR_RESERVED1_MASK) | (((uint32_t)val) << POGO_IDMA2_POGO_IDMA_UDMA_UPR_RESERVED1_SHIFT))

#define  POGO_IDMA2_POGO_IDMA_UDMA_UPR_FIFODEPTH_MASK 0xffff00
#define  POGO_IDMA2_POGO_IDMA_UDMA_UPR_FIFODEPTH_SHIFT 8
#define  POGO_IDMA2_POGO_IDMA_UDMA_UPR_FIFODEPTH_MASK_SHIFT(reg) (((reg) & POGO_IDMA2_POGO_IDMA_UDMA_UPR_FIFODEPTH_MASK) >> POGO_IDMA2_POGO_IDMA_UDMA_UPR_FIFODEPTH_SHIFT)
#define  POGO_IDMA2_POGO_IDMA_UDMA_UPR_FIFODEPTH_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA2_POGO_IDMA_UDMA_UPR_FIFODEPTH_MASK) | (((uint32_t)val) << POGO_IDMA2_POGO_IDMA_UDMA_UPR_FIFODEPTH_SHIFT))

#define  POGO_IDMA2_POGO_IDMA_UDMA_UPR_RESERVED2_MASK 0xe0
#define  POGO_IDMA2_POGO_IDMA_UDMA_UPR_RESERVED2_SHIFT 5
#define  POGO_IDMA2_POGO_IDMA_UDMA_UPR_RESERVED2_MASK_SHIFT(reg) (((reg) & POGO_IDMA2_POGO_IDMA_UDMA_UPR_RESERVED2_MASK) >> POGO_IDMA2_POGO_IDMA_UDMA_UPR_RESERVED2_SHIFT)
#define  POGO_IDMA2_POGO_IDMA_UDMA_UPR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA2_POGO_IDMA_UDMA_UPR_RESERVED2_MASK) | (((uint32_t)val) << POGO_IDMA2_POGO_IDMA_UDMA_UPR_RESERVED2_SHIFT))

#define  POGO_IDMA2_POGO_IDMA_UDMA_UPR_SERPSUPPORT_MASK 0x10
#define  POGO_IDMA2_POGO_IDMA_UDMA_UPR_SERPSUPPORT_SHIFT 4
#define  POGO_IDMA2_POGO_IDMA_UDMA_UPR_SERPSUPPORT_MASK_SHIFT(reg) (((reg) & POGO_IDMA2_POGO_IDMA_UDMA_UPR_SERPSUPPORT_MASK) >> POGO_IDMA2_POGO_IDMA_UDMA_UPR_SERPSUPPORT_SHIFT)
#define  POGO_IDMA2_POGO_IDMA_UDMA_UPR_SERPSUPPORT_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA2_POGO_IDMA_UDMA_UPR_SERPSUPPORT_MASK) | (((uint32_t)val) << POGO_IDMA2_POGO_IDMA_UDMA_UPR_SERPSUPPORT_SHIFT))

#define  POGO_IDMA2_POGO_IDMA_UDMA_UPR_DESCLENGTH_MASK 0x8
#define  POGO_IDMA2_POGO_IDMA_UDMA_UPR_DESCLENGTH_SHIFT 3
#define  POGO_IDMA2_POGO_IDMA_UDMA_UPR_DESCLENGTH_MASK_SHIFT(reg) (((reg) & POGO_IDMA2_POGO_IDMA_UDMA_UPR_DESCLENGTH_MASK) >> POGO_IDMA2_POGO_IDMA_UDMA_UPR_DESCLENGTH_SHIFT)
#define  POGO_IDMA2_POGO_IDMA_UDMA_UPR_DESCLENGTH_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA2_POGO_IDMA_UDMA_UPR_DESCLENGTH_MASK) | (((uint32_t)val) << POGO_IDMA2_POGO_IDMA_UDMA_UPR_DESCLENGTH_SHIFT))

#define  POGO_IDMA2_POGO_IDMA_UDMA_UPR_BUSWIDTH_MASK 0x4
#define  POGO_IDMA2_POGO_IDMA_UDMA_UPR_BUSWIDTH_SHIFT 2
#define  POGO_IDMA2_POGO_IDMA_UDMA_UPR_BUSWIDTH_MASK_SHIFT(reg) (((reg) & POGO_IDMA2_POGO_IDMA_UDMA_UPR_BUSWIDTH_MASK) >> POGO_IDMA2_POGO_IDMA_UDMA_UPR_BUSWIDTH_SHIFT)
#define  POGO_IDMA2_POGO_IDMA_UDMA_UPR_BUSWIDTH_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA2_POGO_IDMA_UDMA_UPR_BUSWIDTH_MASK) | (((uint32_t)val) << POGO_IDMA2_POGO_IDMA_UDMA_UPR_BUSWIDTH_SHIFT))

#define  POGO_IDMA2_POGO_IDMA_UDMA_UPR_MEMALIGN_MASK 0x3
#define  POGO_IDMA2_POGO_IDMA_UDMA_UPR_MEMALIGN_SHIFT 0
#define  POGO_IDMA2_POGO_IDMA_UDMA_UPR_MEMALIGN_MASK_SHIFT(reg) (((reg) & POGO_IDMA2_POGO_IDMA_UDMA_UPR_MEMALIGN_MASK) >> POGO_IDMA2_POGO_IDMA_UDMA_UPR_MEMALIGN_SHIFT)
#define  POGO_IDMA2_POGO_IDMA_UDMA_UPR_MEMALIGN_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA2_POGO_IDMA_UDMA_UPR_MEMALIGN_MASK) | (((uint32_t)val) << POGO_IDMA2_POGO_IDMA_UDMA_UPR_MEMALIGN_SHIFT))

//====================================================================
//Register: UDMA Interrupt Enable Register (UIER)
//====================================================================

#define  POGO_IDMA2_POGO_IDMA_UDMA_UIER_RESERVED1_MASK 0xffffffc0
#define  POGO_IDMA2_POGO_IDMA_UDMA_UIER_RESERVED1_SHIFT 6
#define  POGO_IDMA2_POGO_IDMA_UDMA_UIER_RESERVED1_MASK_SHIFT(reg) (((reg) & POGO_IDMA2_POGO_IDMA_UDMA_UIER_RESERVED1_MASK) >> POGO_IDMA2_POGO_IDMA_UDMA_UIER_RESERVED1_SHIFT)
#define  POGO_IDMA2_POGO_IDMA_UDMA_UIER_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA2_POGO_IDMA_UDMA_UIER_RESERVED1_MASK) | (((uint32_t)val) << POGO_IDMA2_POGO_IDMA_UDMA_UIER_RESERVED1_SHIFT))

#define  POGO_IDMA2_POGO_IDMA_UDMA_UIER_OUTOFRANGE_MASK 0x20
#define  POGO_IDMA2_POGO_IDMA_UDMA_UIER_OUTOFRANGE_SHIFT 5
#define  POGO_IDMA2_POGO_IDMA_UDMA_UIER_OUTOFRANGE_MASK_SHIFT(reg) (((reg) & POGO_IDMA2_POGO_IDMA_UDMA_UIER_OUTOFRANGE_MASK) >> POGO_IDMA2_POGO_IDMA_UDMA_UIER_OUTOFRANGE_SHIFT)
#define  POGO_IDMA2_POGO_IDMA_UDMA_UIER_OUTOFRANGE_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA2_POGO_IDMA_UDMA_UIER_OUTOFRANGE_MASK) | (((uint32_t)val) << POGO_IDMA2_POGO_IDMA_UDMA_UIER_OUTOFRANGE_SHIFT))

#define  POGO_IDMA2_POGO_IDMA_UDMA_UIER_RRESP_MASK 0x10
#define  POGO_IDMA2_POGO_IDMA_UDMA_UIER_RRESP_SHIFT 4
#define  POGO_IDMA2_POGO_IDMA_UDMA_UIER_RRESP_MASK_SHIFT(reg) (((reg) & POGO_IDMA2_POGO_IDMA_UDMA_UIER_RRESP_MASK) >> POGO_IDMA2_POGO_IDMA_UDMA_UIER_RRESP_SHIFT)
#define  POGO_IDMA2_POGO_IDMA_UDMA_UIER_RRESP_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA2_POGO_IDMA_UDMA_UIER_RRESP_MASK) | (((uint32_t)val) << POGO_IDMA2_POGO_IDMA_UDMA_UIER_RRESP_SHIFT))

#define  POGO_IDMA2_POGO_IDMA_UDMA_UIER_BRESP_MASK 0x8
#define  POGO_IDMA2_POGO_IDMA_UDMA_UIER_BRESP_SHIFT 3
#define  POGO_IDMA2_POGO_IDMA_UDMA_UIER_BRESP_MASK_SHIFT(reg) (((reg) & POGO_IDMA2_POGO_IDMA_UDMA_UIER_BRESP_MASK) >> POGO_IDMA2_POGO_IDMA_UDMA_UIER_BRESP_SHIFT)
#define  POGO_IDMA2_POGO_IDMA_UDMA_UIER_BRESP_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA2_POGO_IDMA_UDMA_UIER_BRESP_MASK) | (((uint32_t)val) << POGO_IDMA2_POGO_IDMA_UDMA_UIER_BRESP_SHIFT))

#define  POGO_IDMA2_POGO_IDMA_UDMA_UIER_CLEARCOMPLETE_MASK 0x4
#define  POGO_IDMA2_POGO_IDMA_UDMA_UIER_CLEARCOMPLETE_SHIFT 2
#define  POGO_IDMA2_POGO_IDMA_UDMA_UIER_CLEARCOMPLETE_MASK_SHIFT(reg) (((reg) & POGO_IDMA2_POGO_IDMA_UDMA_UIER_CLEARCOMPLETE_MASK) >> POGO_IDMA2_POGO_IDMA_UDMA_UIER_CLEARCOMPLETE_SHIFT)
#define  POGO_IDMA2_POGO_IDMA_UDMA_UIER_CLEARCOMPLETE_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA2_POGO_IDMA_UDMA_UIER_CLEARCOMPLETE_MASK) | (((uint32_t)val) << POGO_IDMA2_POGO_IDMA_UDMA_UIER_CLEARCOMPLETE_SHIFT))

#define  POGO_IDMA2_POGO_IDMA_UDMA_UIER_DESC_MASK 0x2
#define  POGO_IDMA2_POGO_IDMA_UDMA_UIER_DESC_SHIFT 1
#define  POGO_IDMA2_POGO_IDMA_UDMA_UIER_DESC_MASK_SHIFT(reg) (((reg) & POGO_IDMA2_POGO_IDMA_UDMA_UIER_DESC_MASK) >> POGO_IDMA2_POGO_IDMA_UDMA_UIER_DESC_SHIFT)
#define  POGO_IDMA2_POGO_IDMA_UDMA_UIER_DESC_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA2_POGO_IDMA_UDMA_UIER_DESC_MASK) | (((uint32_t)val) << POGO_IDMA2_POGO_IDMA_UDMA_UIER_DESC_SHIFT))

#define  POGO_IDMA2_POGO_IDMA_UDMA_UIER_OWN_MASK 0x1
#define  POGO_IDMA2_POGO_IDMA_UDMA_UIER_OWN_SHIFT 0
#define  POGO_IDMA2_POGO_IDMA_UDMA_UIER_OWN_MASK_SHIFT(reg) (((reg) & POGO_IDMA2_POGO_IDMA_UDMA_UIER_OWN_MASK) >> POGO_IDMA2_POGO_IDMA_UDMA_UIER_OWN_SHIFT)
#define  POGO_IDMA2_POGO_IDMA_UDMA_UIER_OWN_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA2_POGO_IDMA_UDMA_UIER_OWN_MASK) | (((uint32_t)val) << POGO_IDMA2_POGO_IDMA_UDMA_UIER_OWN_SHIFT))

//====================================================================
//Register: UDMA Interrupt Pending Register (UIPR)
//====================================================================

#define  POGO_IDMA2_POGO_IDMA_UDMA_UIPR_RESERVED1_MASK 0xffffffc0
#define  POGO_IDMA2_POGO_IDMA_UDMA_UIPR_RESERVED1_SHIFT 6
#define  POGO_IDMA2_POGO_IDMA_UDMA_UIPR_RESERVED1_MASK_SHIFT(reg) (((reg) & POGO_IDMA2_POGO_IDMA_UDMA_UIPR_RESERVED1_MASK) >> POGO_IDMA2_POGO_IDMA_UDMA_UIPR_RESERVED1_SHIFT)
#define  POGO_IDMA2_POGO_IDMA_UDMA_UIPR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA2_POGO_IDMA_UDMA_UIPR_RESERVED1_MASK) | (((uint32_t)val) << POGO_IDMA2_POGO_IDMA_UDMA_UIPR_RESERVED1_SHIFT))

#define  POGO_IDMA2_POGO_IDMA_UDMA_UIPR_OUTOFRANGE_MASK 0x20
#define  POGO_IDMA2_POGO_IDMA_UDMA_UIPR_OUTOFRANGE_SHIFT 5
#define  POGO_IDMA2_POGO_IDMA_UDMA_UIPR_OUTOFRANGE_MASK_SHIFT(reg) (((reg) & POGO_IDMA2_POGO_IDMA_UDMA_UIPR_OUTOFRANGE_MASK) >> POGO_IDMA2_POGO_IDMA_UDMA_UIPR_OUTOFRANGE_SHIFT)
#define  POGO_IDMA2_POGO_IDMA_UDMA_UIPR_OUTOFRANGE_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA2_POGO_IDMA_UDMA_UIPR_OUTOFRANGE_MASK) | (((uint32_t)val) << POGO_IDMA2_POGO_IDMA_UDMA_UIPR_OUTOFRANGE_SHIFT))

#define  POGO_IDMA2_POGO_IDMA_UDMA_UIPR_RRESP_MASK 0x10
#define  POGO_IDMA2_POGO_IDMA_UDMA_UIPR_RRESP_SHIFT 4
#define  POGO_IDMA2_POGO_IDMA_UDMA_UIPR_RRESP_MASK_SHIFT(reg) (((reg) & POGO_IDMA2_POGO_IDMA_UDMA_UIPR_RRESP_MASK) >> POGO_IDMA2_POGO_IDMA_UDMA_UIPR_RRESP_SHIFT)
#define  POGO_IDMA2_POGO_IDMA_UDMA_UIPR_RRESP_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA2_POGO_IDMA_UDMA_UIPR_RRESP_MASK) | (((uint32_t)val) << POGO_IDMA2_POGO_IDMA_UDMA_UIPR_RRESP_SHIFT))

#define  POGO_IDMA2_POGO_IDMA_UDMA_UIPR_BRESP_MASK 0x8
#define  POGO_IDMA2_POGO_IDMA_UDMA_UIPR_BRESP_SHIFT 3
#define  POGO_IDMA2_POGO_IDMA_UDMA_UIPR_BRESP_MASK_SHIFT(reg) (((reg) & POGO_IDMA2_POGO_IDMA_UDMA_UIPR_BRESP_MASK) >> POGO_IDMA2_POGO_IDMA_UDMA_UIPR_BRESP_SHIFT)
#define  POGO_IDMA2_POGO_IDMA_UDMA_UIPR_BRESP_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA2_POGO_IDMA_UDMA_UIPR_BRESP_MASK) | (((uint32_t)val) << POGO_IDMA2_POGO_IDMA_UDMA_UIPR_BRESP_SHIFT))

#define  POGO_IDMA2_POGO_IDMA_UDMA_UIPR_CLEARCOMPLETE_MASK 0x4
#define  POGO_IDMA2_POGO_IDMA_UDMA_UIPR_CLEARCOMPLETE_SHIFT 2
#define  POGO_IDMA2_POGO_IDMA_UDMA_UIPR_CLEARCOMPLETE_MASK_SHIFT(reg) (((reg) & POGO_IDMA2_POGO_IDMA_UDMA_UIPR_CLEARCOMPLETE_MASK) >> POGO_IDMA2_POGO_IDMA_UDMA_UIPR_CLEARCOMPLETE_SHIFT)
#define  POGO_IDMA2_POGO_IDMA_UDMA_UIPR_CLEARCOMPLETE_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA2_POGO_IDMA_UDMA_UIPR_CLEARCOMPLETE_MASK) | (((uint32_t)val) << POGO_IDMA2_POGO_IDMA_UDMA_UIPR_CLEARCOMPLETE_SHIFT))

#define  POGO_IDMA2_POGO_IDMA_UDMA_UIPR_DESC_MASK 0x2
#define  POGO_IDMA2_POGO_IDMA_UDMA_UIPR_DESC_SHIFT 1
#define  POGO_IDMA2_POGO_IDMA_UDMA_UIPR_DESC_MASK_SHIFT(reg) (((reg) & POGO_IDMA2_POGO_IDMA_UDMA_UIPR_DESC_MASK) >> POGO_IDMA2_POGO_IDMA_UDMA_UIPR_DESC_SHIFT)
#define  POGO_IDMA2_POGO_IDMA_UDMA_UIPR_DESC_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA2_POGO_IDMA_UDMA_UIPR_DESC_MASK) | (((uint32_t)val) << POGO_IDMA2_POGO_IDMA_UDMA_UIPR_DESC_SHIFT))

#define  POGO_IDMA2_POGO_IDMA_UDMA_UIPR_OWN_MASK 0x1
#define  POGO_IDMA2_POGO_IDMA_UDMA_UIPR_OWN_SHIFT 0
#define  POGO_IDMA2_POGO_IDMA_UDMA_UIPR_OWN_MASK_SHIFT(reg) (((reg) & POGO_IDMA2_POGO_IDMA_UDMA_UIPR_OWN_MASK) >> POGO_IDMA2_POGO_IDMA_UDMA_UIPR_OWN_SHIFT)
#define  POGO_IDMA2_POGO_IDMA_UDMA_UIPR_OWN_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA2_POGO_IDMA_UDMA_UIPR_OWN_MASK) | (((uint32_t)val) << POGO_IDMA2_POGO_IDMA_UDMA_UIPR_OWN_SHIFT))

//====================================================================
//Register: UDMA Interrupt Clear Register (UICR)
//====================================================================

#define  POGO_IDMA2_POGO_IDMA_UDMA_UICR_RESERVED1_MASK 0xffffffc0
#define  POGO_IDMA2_POGO_IDMA_UDMA_UICR_RESERVED1_SHIFT 6
#define  POGO_IDMA2_POGO_IDMA_UDMA_UICR_RESERVED1_MASK_SHIFT(reg) (((reg) & POGO_IDMA2_POGO_IDMA_UDMA_UICR_RESERVED1_MASK) >> POGO_IDMA2_POGO_IDMA_UDMA_UICR_RESERVED1_SHIFT)
#define  POGO_IDMA2_POGO_IDMA_UDMA_UICR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA2_POGO_IDMA_UDMA_UICR_RESERVED1_MASK) | (((uint32_t)val) << POGO_IDMA2_POGO_IDMA_UDMA_UICR_RESERVED1_SHIFT))

#define  POGO_IDMA2_POGO_IDMA_UDMA_UICR_OUTOFRANGE_MASK 0x20
#define  POGO_IDMA2_POGO_IDMA_UDMA_UICR_OUTOFRANGE_SHIFT 5
#define  POGO_IDMA2_POGO_IDMA_UDMA_UICR_OUTOFRANGE_MASK_SHIFT(reg) (((reg) & POGO_IDMA2_POGO_IDMA_UDMA_UICR_OUTOFRANGE_MASK) >> POGO_IDMA2_POGO_IDMA_UDMA_UICR_OUTOFRANGE_SHIFT)
#define  POGO_IDMA2_POGO_IDMA_UDMA_UICR_OUTOFRANGE_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA2_POGO_IDMA_UDMA_UICR_OUTOFRANGE_MASK) | (((uint32_t)val) << POGO_IDMA2_POGO_IDMA_UDMA_UICR_OUTOFRANGE_SHIFT))

#define  POGO_IDMA2_POGO_IDMA_UDMA_UICR_RRESP_MASK 0x10
#define  POGO_IDMA2_POGO_IDMA_UDMA_UICR_RRESP_SHIFT 4
#define  POGO_IDMA2_POGO_IDMA_UDMA_UICR_RRESP_MASK_SHIFT(reg) (((reg) & POGO_IDMA2_POGO_IDMA_UDMA_UICR_RRESP_MASK) >> POGO_IDMA2_POGO_IDMA_UDMA_UICR_RRESP_SHIFT)
#define  POGO_IDMA2_POGO_IDMA_UDMA_UICR_RRESP_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA2_POGO_IDMA_UDMA_UICR_RRESP_MASK) | (((uint32_t)val) << POGO_IDMA2_POGO_IDMA_UDMA_UICR_RRESP_SHIFT))

#define  POGO_IDMA2_POGO_IDMA_UDMA_UICR_BRESP_MASK 0x8
#define  POGO_IDMA2_POGO_IDMA_UDMA_UICR_BRESP_SHIFT 3
#define  POGO_IDMA2_POGO_IDMA_UDMA_UICR_BRESP_MASK_SHIFT(reg) (((reg) & POGO_IDMA2_POGO_IDMA_UDMA_UICR_BRESP_MASK) >> POGO_IDMA2_POGO_IDMA_UDMA_UICR_BRESP_SHIFT)
#define  POGO_IDMA2_POGO_IDMA_UDMA_UICR_BRESP_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA2_POGO_IDMA_UDMA_UICR_BRESP_MASK) | (((uint32_t)val) << POGO_IDMA2_POGO_IDMA_UDMA_UICR_BRESP_SHIFT))

#define  POGO_IDMA2_POGO_IDMA_UDMA_UICR_CLEARCOMPLETE_MASK 0x4
#define  POGO_IDMA2_POGO_IDMA_UDMA_UICR_CLEARCOMPLETE_SHIFT 2
#define  POGO_IDMA2_POGO_IDMA_UDMA_UICR_CLEARCOMPLETE_MASK_SHIFT(reg) (((reg) & POGO_IDMA2_POGO_IDMA_UDMA_UICR_CLEARCOMPLETE_MASK) >> POGO_IDMA2_POGO_IDMA_UDMA_UICR_CLEARCOMPLETE_SHIFT)
#define  POGO_IDMA2_POGO_IDMA_UDMA_UICR_CLEARCOMPLETE_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA2_POGO_IDMA_UDMA_UICR_CLEARCOMPLETE_MASK) | (((uint32_t)val) << POGO_IDMA2_POGO_IDMA_UDMA_UICR_CLEARCOMPLETE_SHIFT))

#define  POGO_IDMA2_POGO_IDMA_UDMA_UICR_DESC_MASK 0x2
#define  POGO_IDMA2_POGO_IDMA_UDMA_UICR_DESC_SHIFT 1
#define  POGO_IDMA2_POGO_IDMA_UDMA_UICR_DESC_MASK_SHIFT(reg) (((reg) & POGO_IDMA2_POGO_IDMA_UDMA_UICR_DESC_MASK) >> POGO_IDMA2_POGO_IDMA_UDMA_UICR_DESC_SHIFT)
#define  POGO_IDMA2_POGO_IDMA_UDMA_UICR_DESC_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA2_POGO_IDMA_UDMA_UICR_DESC_MASK) | (((uint32_t)val) << POGO_IDMA2_POGO_IDMA_UDMA_UICR_DESC_SHIFT))

#define  POGO_IDMA2_POGO_IDMA_UDMA_UICR_OWN_MASK 0x1
#define  POGO_IDMA2_POGO_IDMA_UDMA_UICR_OWN_SHIFT 0
#define  POGO_IDMA2_POGO_IDMA_UDMA_UICR_OWN_MASK_SHIFT(reg) (((reg) & POGO_IDMA2_POGO_IDMA_UDMA_UICR_OWN_MASK) >> POGO_IDMA2_POGO_IDMA_UDMA_UICR_OWN_SHIFT)
#define  POGO_IDMA2_POGO_IDMA_UDMA_UICR_OWN_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA2_POGO_IDMA_UDMA_UICR_OWN_MASK) | (((uint32_t)val) << POGO_IDMA2_POGO_IDMA_UDMA_UICR_OWN_SHIFT))

//====================================================================
//Register: UDMA Interrupt Force Register (UIFR)
//====================================================================

#define  POGO_IDMA2_POGO_IDMA_UDMA_UIFR_RESERVED1_MASK 0xffffffc0
#define  POGO_IDMA2_POGO_IDMA_UDMA_UIFR_RESERVED1_SHIFT 6
#define  POGO_IDMA2_POGO_IDMA_UDMA_UIFR_RESERVED1_MASK_SHIFT(reg) (((reg) & POGO_IDMA2_POGO_IDMA_UDMA_UIFR_RESERVED1_MASK) >> POGO_IDMA2_POGO_IDMA_UDMA_UIFR_RESERVED1_SHIFT)
#define  POGO_IDMA2_POGO_IDMA_UDMA_UIFR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA2_POGO_IDMA_UDMA_UIFR_RESERVED1_MASK) | (((uint32_t)val) << POGO_IDMA2_POGO_IDMA_UDMA_UIFR_RESERVED1_SHIFT))

#define  POGO_IDMA2_POGO_IDMA_UDMA_UIFR_OUTOFRANGE_MASK 0x20
#define  POGO_IDMA2_POGO_IDMA_UDMA_UIFR_OUTOFRANGE_SHIFT 5
#define  POGO_IDMA2_POGO_IDMA_UDMA_UIFR_OUTOFRANGE_MASK_SHIFT(reg) (((reg) & POGO_IDMA2_POGO_IDMA_UDMA_UIFR_OUTOFRANGE_MASK) >> POGO_IDMA2_POGO_IDMA_UDMA_UIFR_OUTOFRANGE_SHIFT)
#define  POGO_IDMA2_POGO_IDMA_UDMA_UIFR_OUTOFRANGE_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA2_POGO_IDMA_UDMA_UIFR_OUTOFRANGE_MASK) | (((uint32_t)val) << POGO_IDMA2_POGO_IDMA_UDMA_UIFR_OUTOFRANGE_SHIFT))

#define  POGO_IDMA2_POGO_IDMA_UDMA_UIFR_RRESP_MASK 0x10
#define  POGO_IDMA2_POGO_IDMA_UDMA_UIFR_RRESP_SHIFT 4
#define  POGO_IDMA2_POGO_IDMA_UDMA_UIFR_RRESP_MASK_SHIFT(reg) (((reg) & POGO_IDMA2_POGO_IDMA_UDMA_UIFR_RRESP_MASK) >> POGO_IDMA2_POGO_IDMA_UDMA_UIFR_RRESP_SHIFT)
#define  POGO_IDMA2_POGO_IDMA_UDMA_UIFR_RRESP_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA2_POGO_IDMA_UDMA_UIFR_RRESP_MASK) | (((uint32_t)val) << POGO_IDMA2_POGO_IDMA_UDMA_UIFR_RRESP_SHIFT))

#define  POGO_IDMA2_POGO_IDMA_UDMA_UIFR_BRESP_MASK 0x8
#define  POGO_IDMA2_POGO_IDMA_UDMA_UIFR_BRESP_SHIFT 3
#define  POGO_IDMA2_POGO_IDMA_UDMA_UIFR_BRESP_MASK_SHIFT(reg) (((reg) & POGO_IDMA2_POGO_IDMA_UDMA_UIFR_BRESP_MASK) >> POGO_IDMA2_POGO_IDMA_UDMA_UIFR_BRESP_SHIFT)
#define  POGO_IDMA2_POGO_IDMA_UDMA_UIFR_BRESP_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA2_POGO_IDMA_UDMA_UIFR_BRESP_MASK) | (((uint32_t)val) << POGO_IDMA2_POGO_IDMA_UDMA_UIFR_BRESP_SHIFT))

#define  POGO_IDMA2_POGO_IDMA_UDMA_UIFR_CLEARCOMPLETE_MASK 0x4
#define  POGO_IDMA2_POGO_IDMA_UDMA_UIFR_CLEARCOMPLETE_SHIFT 2
#define  POGO_IDMA2_POGO_IDMA_UDMA_UIFR_CLEARCOMPLETE_MASK_SHIFT(reg) (((reg) & POGO_IDMA2_POGO_IDMA_UDMA_UIFR_CLEARCOMPLETE_MASK) >> POGO_IDMA2_POGO_IDMA_UDMA_UIFR_CLEARCOMPLETE_SHIFT)
#define  POGO_IDMA2_POGO_IDMA_UDMA_UIFR_CLEARCOMPLETE_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA2_POGO_IDMA_UDMA_UIFR_CLEARCOMPLETE_MASK) | (((uint32_t)val) << POGO_IDMA2_POGO_IDMA_UDMA_UIFR_CLEARCOMPLETE_SHIFT))

#define  POGO_IDMA2_POGO_IDMA_UDMA_UIFR_DESC_MASK 0x2
#define  POGO_IDMA2_POGO_IDMA_UDMA_UIFR_DESC_SHIFT 1
#define  POGO_IDMA2_POGO_IDMA_UDMA_UIFR_DESC_MASK_SHIFT(reg) (((reg) & POGO_IDMA2_POGO_IDMA_UDMA_UIFR_DESC_MASK) >> POGO_IDMA2_POGO_IDMA_UDMA_UIFR_DESC_SHIFT)
#define  POGO_IDMA2_POGO_IDMA_UDMA_UIFR_DESC_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA2_POGO_IDMA_UDMA_UIFR_DESC_MASK) | (((uint32_t)val) << POGO_IDMA2_POGO_IDMA_UDMA_UIFR_DESC_SHIFT))

#define  POGO_IDMA2_POGO_IDMA_UDMA_UIFR_OWN_MASK 0x1
#define  POGO_IDMA2_POGO_IDMA_UDMA_UIFR_OWN_SHIFT 0
#define  POGO_IDMA2_POGO_IDMA_UDMA_UIFR_OWN_MASK_SHIFT(reg) (((reg) & POGO_IDMA2_POGO_IDMA_UDMA_UIFR_OWN_MASK) >> POGO_IDMA2_POGO_IDMA_UDMA_UIFR_OWN_SHIFT)
#define  POGO_IDMA2_POGO_IDMA_UDMA_UIFR_OWN_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA2_POGO_IDMA_UDMA_UIFR_OWN_MASK) | (((uint32_t)val) << POGO_IDMA2_POGO_IDMA_UDMA_UIFR_OWN_SHIFT))

//====================================================================
//Register: UDMA Descriptor Register (UDR)
//====================================================================

#define  POGO_IDMA2_POGO_IDMA_UDMA_UDR_DESC_MASK 0xffffffff
#define  POGO_IDMA2_POGO_IDMA_UDMA_UDR_DESC_SHIFT 0
#define  POGO_IDMA2_POGO_IDMA_UDMA_UDR_DESC_MASK_SHIFT(reg) (((reg) & POGO_IDMA2_POGO_IDMA_UDMA_UDR_DESC_MASK) >> POGO_IDMA2_POGO_IDMA_UDMA_UDR_DESC_SHIFT)
#define  POGO_IDMA2_POGO_IDMA_UDMA_UDR_DESC_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA2_POGO_IDMA_UDMA_UDR_DESC_MASK) | (((uint32_t)val) << POGO_IDMA2_POGO_IDMA_UDMA_UDR_DESC_SHIFT))

//====================================================================
//Register: UDMA Burst Address Register (UBAR)
//====================================================================

#define  POGO_IDMA2_POGO_IDMA_UDMA_UBAR_BURSTADDR_MASK 0xffffffff
#define  POGO_IDMA2_POGO_IDMA_UDMA_UBAR_BURSTADDR_SHIFT 0
#define  POGO_IDMA2_POGO_IDMA_UDMA_UBAR_BURSTADDR_MASK_SHIFT(reg) (((reg) & POGO_IDMA2_POGO_IDMA_UDMA_UBAR_BURSTADDR_MASK) >> POGO_IDMA2_POGO_IDMA_UDMA_UBAR_BURSTADDR_SHIFT)
#define  POGO_IDMA2_POGO_IDMA_UDMA_UBAR_BURSTADDR_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA2_POGO_IDMA_UDMA_UBAR_BURSTADDR_MASK) | (((uint32_t)val) << POGO_IDMA2_POGO_IDMA_UDMA_UBAR_BURSTADDR_SHIFT))

//====================================================================
//Register: UDMA Burst Length Register (UBLR)
//====================================================================

#define  POGO_IDMA2_POGO_IDMA_UDMA_UBLR_RESERVED1_MASK 0xfffffc00
#define  POGO_IDMA2_POGO_IDMA_UDMA_UBLR_RESERVED1_SHIFT 10
#define  POGO_IDMA2_POGO_IDMA_UDMA_UBLR_RESERVED1_MASK_SHIFT(reg) (((reg) & POGO_IDMA2_POGO_IDMA_UDMA_UBLR_RESERVED1_MASK) >> POGO_IDMA2_POGO_IDMA_UDMA_UBLR_RESERVED1_SHIFT)
#define  POGO_IDMA2_POGO_IDMA_UDMA_UBLR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA2_POGO_IDMA_UDMA_UBLR_RESERVED1_MASK) | (((uint32_t)val) << POGO_IDMA2_POGO_IDMA_UDMA_UBLR_RESERVED1_SHIFT))

#define  POGO_IDMA2_POGO_IDMA_UDMA_UBLR_BURSTDIR_MASK 0x200
#define  POGO_IDMA2_POGO_IDMA_UDMA_UBLR_BURSTDIR_SHIFT 9
#define  POGO_IDMA2_POGO_IDMA_UDMA_UBLR_BURSTDIR_MASK_SHIFT(reg) (((reg) & POGO_IDMA2_POGO_IDMA_UDMA_UBLR_BURSTDIR_MASK) >> POGO_IDMA2_POGO_IDMA_UDMA_UBLR_BURSTDIR_SHIFT)
#define  POGO_IDMA2_POGO_IDMA_UDMA_UBLR_BURSTDIR_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA2_POGO_IDMA_UDMA_UBLR_BURSTDIR_MASK) | (((uint32_t)val) << POGO_IDMA2_POGO_IDMA_UDMA_UBLR_BURSTDIR_SHIFT))

#define  POGO_IDMA2_POGO_IDMA_UDMA_UBLR_BURSTLAST_MASK 0x100
#define  POGO_IDMA2_POGO_IDMA_UDMA_UBLR_BURSTLAST_SHIFT 8
#define  POGO_IDMA2_POGO_IDMA_UDMA_UBLR_BURSTLAST_MASK_SHIFT(reg) (((reg) & POGO_IDMA2_POGO_IDMA_UDMA_UBLR_BURSTLAST_MASK) >> POGO_IDMA2_POGO_IDMA_UDMA_UBLR_BURSTLAST_SHIFT)
#define  POGO_IDMA2_POGO_IDMA_UDMA_UBLR_BURSTLAST_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA2_POGO_IDMA_UDMA_UBLR_BURSTLAST_MASK) | (((uint32_t)val) << POGO_IDMA2_POGO_IDMA_UDMA_UBLR_BURSTLAST_SHIFT))

#define  POGO_IDMA2_POGO_IDMA_UDMA_UBLR_BURSTLENGTH_MASK 0xff
#define  POGO_IDMA2_POGO_IDMA_UDMA_UBLR_BURSTLENGTH_SHIFT 0
#define  POGO_IDMA2_POGO_IDMA_UDMA_UBLR_BURSTLENGTH_MASK_SHIFT(reg) (((reg) & POGO_IDMA2_POGO_IDMA_UDMA_UBLR_BURSTLENGTH_MASK) >> POGO_IDMA2_POGO_IDMA_UDMA_UBLR_BURSTLENGTH_SHIFT)
#define  POGO_IDMA2_POGO_IDMA_UDMA_UBLR_BURSTLENGTH_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA2_POGO_IDMA_UDMA_UBLR_BURSTLENGTH_MASK) | (((uint32_t)val) << POGO_IDMA2_POGO_IDMA_UDMA_UBLR_BURSTLENGTH_SHIFT))

//====================================================================
//Register: UDMA Transfer Bytes Remaining Register (UBRR)
//====================================================================

#define  POGO_IDMA2_POGO_IDMA_UDMA_UBRR_BYTESREMAIN_MASK 0xffffffff
#define  POGO_IDMA2_POGO_IDMA_UDMA_UBRR_BYTESREMAIN_SHIFT 0
#define  POGO_IDMA2_POGO_IDMA_UDMA_UBRR_BYTESREMAIN_MASK_SHIFT(reg) (((reg) & POGO_IDMA2_POGO_IDMA_UDMA_UBRR_BYTESREMAIN_MASK) >> POGO_IDMA2_POGO_IDMA_UDMA_UBRR_BYTESREMAIN_SHIFT)
#define  POGO_IDMA2_POGO_IDMA_UDMA_UBRR_BYTESREMAIN_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA2_POGO_IDMA_UDMA_UBRR_BYTESREMAIN_MASK) | (((uint32_t)val) << POGO_IDMA2_POGO_IDMA_UDMA_UBRR_BYTESREMAIN_SHIFT))

//====================================================================
//Register: UDMA Tag Register 0 (UTR0)
//====================================================================

#define  POGO_IDMA2_POGO_IDMA_UDMA_UTR0_TAGMAJ_MASK 0xffff0000
#define  POGO_IDMA2_POGO_IDMA_UDMA_UTR0_TAGMAJ_SHIFT 16
#define  POGO_IDMA2_POGO_IDMA_UDMA_UTR0_TAGMAJ_MASK_SHIFT(reg) (((reg) & POGO_IDMA2_POGO_IDMA_UDMA_UTR0_TAGMAJ_MASK) >> POGO_IDMA2_POGO_IDMA_UDMA_UTR0_TAGMAJ_SHIFT)
#define  POGO_IDMA2_POGO_IDMA_UDMA_UTR0_TAGMAJ_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA2_POGO_IDMA_UDMA_UTR0_TAGMAJ_MASK) | (((uint32_t)val) << POGO_IDMA2_POGO_IDMA_UDMA_UTR0_TAGMAJ_SHIFT))

#define  POGO_IDMA2_POGO_IDMA_UDMA_UTR0_TAGMID_MASK 0xffff
#define  POGO_IDMA2_POGO_IDMA_UDMA_UTR0_TAGMID_SHIFT 0
#define  POGO_IDMA2_POGO_IDMA_UDMA_UTR0_TAGMID_MASK_SHIFT(reg) (((reg) & POGO_IDMA2_POGO_IDMA_UDMA_UTR0_TAGMID_MASK) >> POGO_IDMA2_POGO_IDMA_UDMA_UTR0_TAGMID_SHIFT)
#define  POGO_IDMA2_POGO_IDMA_UDMA_UTR0_TAGMID_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA2_POGO_IDMA_UDMA_UTR0_TAGMID_MASK) | (((uint32_t)val) << POGO_IDMA2_POGO_IDMA_UDMA_UTR0_TAGMID_SHIFT))

//====================================================================
//Register: UDMA Tag Register 1 (UTR1)
//====================================================================

#define  POGO_IDMA2_POGO_IDMA_UDMA_UTR1_RESERVED1_MASK 0xffff0000
#define  POGO_IDMA2_POGO_IDMA_UDMA_UTR1_RESERVED1_SHIFT 16
#define  POGO_IDMA2_POGO_IDMA_UDMA_UTR1_RESERVED1_MASK_SHIFT(reg) (((reg) & POGO_IDMA2_POGO_IDMA_UDMA_UTR1_RESERVED1_MASK) >> POGO_IDMA2_POGO_IDMA_UDMA_UTR1_RESERVED1_SHIFT)
#define  POGO_IDMA2_POGO_IDMA_UDMA_UTR1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA2_POGO_IDMA_UDMA_UTR1_RESERVED1_MASK) | (((uint32_t)val) << POGO_IDMA2_POGO_IDMA_UDMA_UTR1_RESERVED1_SHIFT))

#define  POGO_IDMA2_POGO_IDMA_UDMA_UTR1_TAGCFG_MASK 0xffff
#define  POGO_IDMA2_POGO_IDMA_UDMA_UTR1_TAGCFG_SHIFT 0
#define  POGO_IDMA2_POGO_IDMA_UDMA_UTR1_TAGCFG_MASK_SHIFT(reg) (((reg) & POGO_IDMA2_POGO_IDMA_UDMA_UTR1_TAGCFG_MASK) >> POGO_IDMA2_POGO_IDMA_UDMA_UTR1_TAGCFG_SHIFT)
#define  POGO_IDMA2_POGO_IDMA_UDMA_UTR1_TAGCFG_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA2_POGO_IDMA_UDMA_UTR1_TAGCFG_MASK) | (((uint32_t)val) << POGO_IDMA2_POGO_IDMA_UDMA_UTR1_TAGCFG_SHIFT))

//====================================================================
//
//Register File: POGO_IDMA_CORE (POGO_IDMA2_POGO_IDMA_CORE)
//
//====================================================================

//====================================================================
//Register: IDMA Configuration Register (ICR)
//====================================================================

#define  POGO_IDMA2_POGO_IDMA_CORE_ICR_RESERVED1_MASK 0xfffffffc
#define  POGO_IDMA2_POGO_IDMA_CORE_ICR_RESERVED1_SHIFT 2
#define  POGO_IDMA2_POGO_IDMA_CORE_ICR_RESERVED1_MASK_SHIFT(reg) (((reg) & POGO_IDMA2_POGO_IDMA_CORE_ICR_RESERVED1_MASK) >> POGO_IDMA2_POGO_IDMA_CORE_ICR_RESERVED1_SHIFT)
#define  POGO_IDMA2_POGO_IDMA_CORE_ICR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA2_POGO_IDMA_CORE_ICR_RESERVED1_MASK) | (((uint32_t)val) << POGO_IDMA2_POGO_IDMA_CORE_ICR_RESERVED1_SHIFT))

#define  POGO_IDMA2_POGO_IDMA_CORE_ICR_BURSTSIZE_MASK 0x3
#define  POGO_IDMA2_POGO_IDMA_CORE_ICR_BURSTSIZE_SHIFT 0
#define  POGO_IDMA2_POGO_IDMA_CORE_ICR_BURSTSIZE_MASK_SHIFT(reg) (((reg) & POGO_IDMA2_POGO_IDMA_CORE_ICR_BURSTSIZE_MASK) >> POGO_IDMA2_POGO_IDMA_CORE_ICR_BURSTSIZE_SHIFT)
#define  POGO_IDMA2_POGO_IDMA_CORE_ICR_BURSTSIZE_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA2_POGO_IDMA_CORE_ICR_BURSTSIZE_MASK) | (((uint32_t)val) << POGO_IDMA2_POGO_IDMA_CORE_ICR_BURSTSIZE_SHIFT))

//====================================================================
//Register: IDMA Interrupt Enable Register (IIER)
//====================================================================

#define  POGO_IDMA2_POGO_IDMA_CORE_IIER_RESERVED1_MASK 0xfffffffc
#define  POGO_IDMA2_POGO_IDMA_CORE_IIER_RESERVED1_SHIFT 2
#define  POGO_IDMA2_POGO_IDMA_CORE_IIER_RESERVED1_MASK_SHIFT(reg) (((reg) & POGO_IDMA2_POGO_IDMA_CORE_IIER_RESERVED1_MASK) >> POGO_IDMA2_POGO_IDMA_CORE_IIER_RESERVED1_SHIFT)
#define  POGO_IDMA2_POGO_IDMA_CORE_IIER_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA2_POGO_IDMA_CORE_IIER_RESERVED1_MASK) | (((uint32_t)val) << POGO_IDMA2_POGO_IDMA_CORE_IIER_RESERVED1_SHIFT))

#define  POGO_IDMA2_POGO_IDMA_CORE_IIER_LENGTHERR_MASK 0x2
#define  POGO_IDMA2_POGO_IDMA_CORE_IIER_LENGTHERR_SHIFT 1
#define  POGO_IDMA2_POGO_IDMA_CORE_IIER_LENGTHERR_MASK_SHIFT(reg) (((reg) & POGO_IDMA2_POGO_IDMA_CORE_IIER_LENGTHERR_MASK) >> POGO_IDMA2_POGO_IDMA_CORE_IIER_LENGTHERR_SHIFT)
#define  POGO_IDMA2_POGO_IDMA_CORE_IIER_LENGTHERR_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA2_POGO_IDMA_CORE_IIER_LENGTHERR_MASK) | (((uint32_t)val) << POGO_IDMA2_POGO_IDMA_CORE_IIER_LENGTHERR_SHIFT))

#define  POGO_IDMA2_POGO_IDMA_CORE_IIER_EOS_MASK 0x1
#define  POGO_IDMA2_POGO_IDMA_CORE_IIER_EOS_SHIFT 0
#define  POGO_IDMA2_POGO_IDMA_CORE_IIER_EOS_MASK_SHIFT(reg) (((reg) & POGO_IDMA2_POGO_IDMA_CORE_IIER_EOS_MASK) >> POGO_IDMA2_POGO_IDMA_CORE_IIER_EOS_SHIFT)
#define  POGO_IDMA2_POGO_IDMA_CORE_IIER_EOS_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA2_POGO_IDMA_CORE_IIER_EOS_MASK) | (((uint32_t)val) << POGO_IDMA2_POGO_IDMA_CORE_IIER_EOS_SHIFT))

//====================================================================
//Register: IDMA Interrupt Pending Register (IIPR)
//====================================================================

#define  POGO_IDMA2_POGO_IDMA_CORE_IIPR_RESERVED1_MASK 0xfffffffc
#define  POGO_IDMA2_POGO_IDMA_CORE_IIPR_RESERVED1_SHIFT 2
#define  POGO_IDMA2_POGO_IDMA_CORE_IIPR_RESERVED1_MASK_SHIFT(reg) (((reg) & POGO_IDMA2_POGO_IDMA_CORE_IIPR_RESERVED1_MASK) >> POGO_IDMA2_POGO_IDMA_CORE_IIPR_RESERVED1_SHIFT)
#define  POGO_IDMA2_POGO_IDMA_CORE_IIPR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA2_POGO_IDMA_CORE_IIPR_RESERVED1_MASK) | (((uint32_t)val) << POGO_IDMA2_POGO_IDMA_CORE_IIPR_RESERVED1_SHIFT))

#define  POGO_IDMA2_POGO_IDMA_CORE_IIPR_LENGTHERR_MASK 0x2
#define  POGO_IDMA2_POGO_IDMA_CORE_IIPR_LENGTHERR_SHIFT 1
#define  POGO_IDMA2_POGO_IDMA_CORE_IIPR_LENGTHERR_MASK_SHIFT(reg) (((reg) & POGO_IDMA2_POGO_IDMA_CORE_IIPR_LENGTHERR_MASK) >> POGO_IDMA2_POGO_IDMA_CORE_IIPR_LENGTHERR_SHIFT)
#define  POGO_IDMA2_POGO_IDMA_CORE_IIPR_LENGTHERR_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA2_POGO_IDMA_CORE_IIPR_LENGTHERR_MASK) | (((uint32_t)val) << POGO_IDMA2_POGO_IDMA_CORE_IIPR_LENGTHERR_SHIFT))

#define  POGO_IDMA2_POGO_IDMA_CORE_IIPR_EOS_MASK 0x1
#define  POGO_IDMA2_POGO_IDMA_CORE_IIPR_EOS_SHIFT 0
#define  POGO_IDMA2_POGO_IDMA_CORE_IIPR_EOS_MASK_SHIFT(reg) (((reg) & POGO_IDMA2_POGO_IDMA_CORE_IIPR_EOS_MASK) >> POGO_IDMA2_POGO_IDMA_CORE_IIPR_EOS_SHIFT)
#define  POGO_IDMA2_POGO_IDMA_CORE_IIPR_EOS_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA2_POGO_IDMA_CORE_IIPR_EOS_MASK) | (((uint32_t)val) << POGO_IDMA2_POGO_IDMA_CORE_IIPR_EOS_SHIFT))

//====================================================================
//Register: IDMA Interrupt Clear Register (IICR)
//====================================================================

#define  POGO_IDMA2_POGO_IDMA_CORE_IICR_RESERVED1_MASK 0xfffffffc
#define  POGO_IDMA2_POGO_IDMA_CORE_IICR_RESERVED1_SHIFT 2
#define  POGO_IDMA2_POGO_IDMA_CORE_IICR_RESERVED1_MASK_SHIFT(reg) (((reg) & POGO_IDMA2_POGO_IDMA_CORE_IICR_RESERVED1_MASK) >> POGO_IDMA2_POGO_IDMA_CORE_IICR_RESERVED1_SHIFT)
#define  POGO_IDMA2_POGO_IDMA_CORE_IICR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA2_POGO_IDMA_CORE_IICR_RESERVED1_MASK) | (((uint32_t)val) << POGO_IDMA2_POGO_IDMA_CORE_IICR_RESERVED1_SHIFT))

#define  POGO_IDMA2_POGO_IDMA_CORE_IICR_LENGTHERR_MASK 0x2
#define  POGO_IDMA2_POGO_IDMA_CORE_IICR_LENGTHERR_SHIFT 1
#define  POGO_IDMA2_POGO_IDMA_CORE_IICR_LENGTHERR_MASK_SHIFT(reg) (((reg) & POGO_IDMA2_POGO_IDMA_CORE_IICR_LENGTHERR_MASK) >> POGO_IDMA2_POGO_IDMA_CORE_IICR_LENGTHERR_SHIFT)
#define  POGO_IDMA2_POGO_IDMA_CORE_IICR_LENGTHERR_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA2_POGO_IDMA_CORE_IICR_LENGTHERR_MASK) | (((uint32_t)val) << POGO_IDMA2_POGO_IDMA_CORE_IICR_LENGTHERR_SHIFT))

#define  POGO_IDMA2_POGO_IDMA_CORE_IICR_EOS_MASK 0x1
#define  POGO_IDMA2_POGO_IDMA_CORE_IICR_EOS_SHIFT 0
#define  POGO_IDMA2_POGO_IDMA_CORE_IICR_EOS_MASK_SHIFT(reg) (((reg) & POGO_IDMA2_POGO_IDMA_CORE_IICR_EOS_MASK) >> POGO_IDMA2_POGO_IDMA_CORE_IICR_EOS_SHIFT)
#define  POGO_IDMA2_POGO_IDMA_CORE_IICR_EOS_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA2_POGO_IDMA_CORE_IICR_EOS_MASK) | (((uint32_t)val) << POGO_IDMA2_POGO_IDMA_CORE_IICR_EOS_SHIFT))

//====================================================================
//Register: IDMA Interrupt Force Register (IIFR)
//====================================================================

#define  POGO_IDMA2_POGO_IDMA_CORE_IIFR_RESERVED1_MASK 0xfffffffc
#define  POGO_IDMA2_POGO_IDMA_CORE_IIFR_RESERVED1_SHIFT 2
#define  POGO_IDMA2_POGO_IDMA_CORE_IIFR_RESERVED1_MASK_SHIFT(reg) (((reg) & POGO_IDMA2_POGO_IDMA_CORE_IIFR_RESERVED1_MASK) >> POGO_IDMA2_POGO_IDMA_CORE_IIFR_RESERVED1_SHIFT)
#define  POGO_IDMA2_POGO_IDMA_CORE_IIFR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA2_POGO_IDMA_CORE_IIFR_RESERVED1_MASK) | (((uint32_t)val) << POGO_IDMA2_POGO_IDMA_CORE_IIFR_RESERVED1_SHIFT))

#define  POGO_IDMA2_POGO_IDMA_CORE_IIFR_LENGTHERR_MASK 0x2
#define  POGO_IDMA2_POGO_IDMA_CORE_IIFR_LENGTHERR_SHIFT 1
#define  POGO_IDMA2_POGO_IDMA_CORE_IIFR_LENGTHERR_MASK_SHIFT(reg) (((reg) & POGO_IDMA2_POGO_IDMA_CORE_IIFR_LENGTHERR_MASK) >> POGO_IDMA2_POGO_IDMA_CORE_IIFR_LENGTHERR_SHIFT)
#define  POGO_IDMA2_POGO_IDMA_CORE_IIFR_LENGTHERR_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA2_POGO_IDMA_CORE_IIFR_LENGTHERR_MASK) | (((uint32_t)val) << POGO_IDMA2_POGO_IDMA_CORE_IIFR_LENGTHERR_SHIFT))

#define  POGO_IDMA2_POGO_IDMA_CORE_IIFR_EOS_MASK 0x1
#define  POGO_IDMA2_POGO_IDMA_CORE_IIFR_EOS_SHIFT 0
#define  POGO_IDMA2_POGO_IDMA_CORE_IIFR_EOS_MASK_SHIFT(reg) (((reg) & POGO_IDMA2_POGO_IDMA_CORE_IIFR_EOS_MASK) >> POGO_IDMA2_POGO_IDMA_CORE_IIFR_EOS_SHIFT)
#define  POGO_IDMA2_POGO_IDMA_CORE_IIFR_EOS_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA2_POGO_IDMA_CORE_IIFR_EOS_MASK) | (((uint32_t)val) << POGO_IDMA2_POGO_IDMA_CORE_IIFR_EOS_SHIFT))

//====================================================================
//Register: IDMA Line Width Register (ILWR)
//====================================================================

#define  POGO_IDMA2_POGO_IDMA_CORE_ILWR_RESERVED1_MASK 0xfff00000
#define  POGO_IDMA2_POGO_IDMA_CORE_ILWR_RESERVED1_SHIFT 20
#define  POGO_IDMA2_POGO_IDMA_CORE_ILWR_RESERVED1_MASK_SHIFT(reg) (((reg) & POGO_IDMA2_POGO_IDMA_CORE_ILWR_RESERVED1_MASK) >> POGO_IDMA2_POGO_IDMA_CORE_ILWR_RESERVED1_SHIFT)
#define  POGO_IDMA2_POGO_IDMA_CORE_ILWR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA2_POGO_IDMA_CORE_ILWR_RESERVED1_MASK) | (((uint32_t)val) << POGO_IDMA2_POGO_IDMA_CORE_ILWR_RESERVED1_SHIFT))

#define  POGO_IDMA2_POGO_IDMA_CORE_ILWR_LINEWIDTH_MASK 0xfffff
#define  POGO_IDMA2_POGO_IDMA_CORE_ILWR_LINEWIDTH_SHIFT 0
#define  POGO_IDMA2_POGO_IDMA_CORE_ILWR_LINEWIDTH_MASK_SHIFT(reg) (((reg) & POGO_IDMA2_POGO_IDMA_CORE_ILWR_LINEWIDTH_MASK) >> POGO_IDMA2_POGO_IDMA_CORE_ILWR_LINEWIDTH_SHIFT)
#define  POGO_IDMA2_POGO_IDMA_CORE_ILWR_LINEWIDTH_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA2_POGO_IDMA_CORE_ILWR_LINEWIDTH_MASK) | (((uint32_t)val) << POGO_IDMA2_POGO_IDMA_CORE_ILWR_LINEWIDTH_SHIFT))

//====================================================================
//Register: IDMA Row Height Register (IRHR)
//====================================================================

#define  POGO_IDMA2_POGO_IDMA_CORE_IRHR_RESERVED1_MASK 0xffffffc0
#define  POGO_IDMA2_POGO_IDMA_CORE_IRHR_RESERVED1_SHIFT 6
#define  POGO_IDMA2_POGO_IDMA_CORE_IRHR_RESERVED1_MASK_SHIFT(reg) (((reg) & POGO_IDMA2_POGO_IDMA_CORE_IRHR_RESERVED1_MASK) >> POGO_IDMA2_POGO_IDMA_CORE_IRHR_RESERVED1_SHIFT)
#define  POGO_IDMA2_POGO_IDMA_CORE_IRHR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA2_POGO_IDMA_CORE_IRHR_RESERVED1_MASK) | (((uint32_t)val) << POGO_IDMA2_POGO_IDMA_CORE_IRHR_RESERVED1_SHIFT))

#define  POGO_IDMA2_POGO_IDMA_CORE_IRHR_ROWHEIGHT_MASK 0x3f
#define  POGO_IDMA2_POGO_IDMA_CORE_IRHR_ROWHEIGHT_SHIFT 0
#define  POGO_IDMA2_POGO_IDMA_CORE_IRHR_ROWHEIGHT_MASK_SHIFT(reg) (((reg) & POGO_IDMA2_POGO_IDMA_CORE_IRHR_ROWHEIGHT_MASK) >> POGO_IDMA2_POGO_IDMA_CORE_IRHR_ROWHEIGHT_SHIFT)
#define  POGO_IDMA2_POGO_IDMA_CORE_IRHR_ROWHEIGHT_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA2_POGO_IDMA_CORE_IRHR_ROWHEIGHT_MASK) | (((uint32_t)val) << POGO_IDMA2_POGO_IDMA_CORE_IRHR_ROWHEIGHT_SHIFT))

//====================================================================
//Register: IDMA Tag Register 0 (ITR0)
//====================================================================

#define  POGO_IDMA2_POGO_IDMA_CORE_ITR0_RESERVED1_MASK 0xffff0000
#define  POGO_IDMA2_POGO_IDMA_CORE_ITR0_RESERVED1_SHIFT 16
#define  POGO_IDMA2_POGO_IDMA_CORE_ITR0_RESERVED1_MASK_SHIFT(reg) (((reg) & POGO_IDMA2_POGO_IDMA_CORE_ITR0_RESERVED1_MASK) >> POGO_IDMA2_POGO_IDMA_CORE_ITR0_RESERVED1_SHIFT)
#define  POGO_IDMA2_POGO_IDMA_CORE_ITR0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA2_POGO_IDMA_CORE_ITR0_RESERVED1_MASK) | (((uint32_t)val) << POGO_IDMA2_POGO_IDMA_CORE_ITR0_RESERVED1_SHIFT))

#define  POGO_IDMA2_POGO_IDMA_CORE_ITR0_TAGCFG_MASK 0xffff
#define  POGO_IDMA2_POGO_IDMA_CORE_ITR0_TAGCFG_SHIFT 0
#define  POGO_IDMA2_POGO_IDMA_CORE_ITR0_TAGCFG_MASK_SHIFT(reg) (((reg) & POGO_IDMA2_POGO_IDMA_CORE_ITR0_TAGCFG_MASK) >> POGO_IDMA2_POGO_IDMA_CORE_ITR0_TAGCFG_SHIFT)
#define  POGO_IDMA2_POGO_IDMA_CORE_ITR0_TAGCFG_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA2_POGO_IDMA_CORE_ITR0_TAGCFG_MASK) | (((uint32_t)val) << POGO_IDMA2_POGO_IDMA_CORE_ITR0_TAGCFG_SHIFT))

//====================================================================
//Register: IDMA Tag Register 1 (ITR1)
//====================================================================

#define  POGO_IDMA2_POGO_IDMA_CORE_ITR1_RESERVED1_MASK 0xffff0000
#define  POGO_IDMA2_POGO_IDMA_CORE_ITR1_RESERVED1_SHIFT 16
#define  POGO_IDMA2_POGO_IDMA_CORE_ITR1_RESERVED1_MASK_SHIFT(reg) (((reg) & POGO_IDMA2_POGO_IDMA_CORE_ITR1_RESERVED1_MASK) >> POGO_IDMA2_POGO_IDMA_CORE_ITR1_RESERVED1_SHIFT)
#define  POGO_IDMA2_POGO_IDMA_CORE_ITR1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA2_POGO_IDMA_CORE_ITR1_RESERVED1_MASK) | (((uint32_t)val) << POGO_IDMA2_POGO_IDMA_CORE_ITR1_RESERVED1_SHIFT))

#define  POGO_IDMA2_POGO_IDMA_CORE_ITR1_TAGMAJ_MASK 0xffff
#define  POGO_IDMA2_POGO_IDMA_CORE_ITR1_TAGMAJ_SHIFT 0
#define  POGO_IDMA2_POGO_IDMA_CORE_ITR1_TAGMAJ_MASK_SHIFT(reg) (((reg) & POGO_IDMA2_POGO_IDMA_CORE_ITR1_TAGMAJ_MASK) >> POGO_IDMA2_POGO_IDMA_CORE_ITR1_TAGMAJ_SHIFT)
#define  POGO_IDMA2_POGO_IDMA_CORE_ITR1_TAGMAJ_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA2_POGO_IDMA_CORE_ITR1_TAGMAJ_MASK) | (((uint32_t)val) << POGO_IDMA2_POGO_IDMA_CORE_ITR1_TAGMAJ_SHIFT))

//====================================================================
//Register: IDMA Tag Register 2 (ITR2)
//====================================================================

#define  POGO_IDMA2_POGO_IDMA_CORE_ITR2_RESERVED1_MASK 0xffff0000
#define  POGO_IDMA2_POGO_IDMA_CORE_ITR2_RESERVED1_SHIFT 16
#define  POGO_IDMA2_POGO_IDMA_CORE_ITR2_RESERVED1_MASK_SHIFT(reg) (((reg) & POGO_IDMA2_POGO_IDMA_CORE_ITR2_RESERVED1_MASK) >> POGO_IDMA2_POGO_IDMA_CORE_ITR2_RESERVED1_SHIFT)
#define  POGO_IDMA2_POGO_IDMA_CORE_ITR2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA2_POGO_IDMA_CORE_ITR2_RESERVED1_MASK) | (((uint32_t)val) << POGO_IDMA2_POGO_IDMA_CORE_ITR2_RESERVED1_SHIFT))

#define  POGO_IDMA2_POGO_IDMA_CORE_ITR2_TAGMID_MASK 0xffff
#define  POGO_IDMA2_POGO_IDMA_CORE_ITR2_TAGMID_SHIFT 0
#define  POGO_IDMA2_POGO_IDMA_CORE_ITR2_TAGMID_MASK_SHIFT(reg) (((reg) & POGO_IDMA2_POGO_IDMA_CORE_ITR2_TAGMID_MASK) >> POGO_IDMA2_POGO_IDMA_CORE_ITR2_TAGMID_SHIFT)
#define  POGO_IDMA2_POGO_IDMA_CORE_ITR2_TAGMID_REPLACE_VAL(reg,val) (((reg) & ~POGO_IDMA2_POGO_IDMA_CORE_ITR2_TAGMID_MASK) | (((uint32_t)val) << POGO_IDMA2_POGO_IDMA_CORE_ITR2_TAGMID_SHIFT))

//====================================================================
//
//Register File: POGO_IDMA_UDMA (OT_POGO_IDMA_POGO_IDMA_UDMA)
//
//====================================================================

//====================================================================
//Register: UDMA Configuration Register (UCR)
//====================================================================

#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UCR_RESERVED1_MASK 0xfff00000
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UCR_RESERVED1_SHIFT 20
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UCR_RESERVED1_MASK_SHIFT(reg) (((reg) & OT_POGO_IDMA_POGO_IDMA_UDMA_UCR_RESERVED1_MASK) >> OT_POGO_IDMA_POGO_IDMA_UDMA_UCR_RESERVED1_SHIFT)
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UCR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~OT_POGO_IDMA_POGO_IDMA_UDMA_UCR_RESERVED1_MASK) | (((uint32_t)val) << OT_POGO_IDMA_POGO_IDMA_UDMA_UCR_RESERVED1_SHIFT))

#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UCR_DATAAXCACHE_MASK 0xf0000
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UCR_DATAAXCACHE_SHIFT 16
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UCR_DATAAXCACHE_MASK_SHIFT(reg) (((reg) & OT_POGO_IDMA_POGO_IDMA_UDMA_UCR_DATAAXCACHE_MASK) >> OT_POGO_IDMA_POGO_IDMA_UDMA_UCR_DATAAXCACHE_SHIFT)
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UCR_DATAAXCACHE_REPLACE_VAL(reg,val) (((reg) & ~OT_POGO_IDMA_POGO_IDMA_UDMA_UCR_DATAAXCACHE_MASK) | (((uint32_t)val) << OT_POGO_IDMA_POGO_IDMA_UDMA_UCR_DATAAXCACHE_SHIFT))

#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UCR_DESCARCACHE_MASK 0xf000
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UCR_DESCARCACHE_SHIFT 12
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UCR_DESCARCACHE_MASK_SHIFT(reg) (((reg) & OT_POGO_IDMA_POGO_IDMA_UDMA_UCR_DESCARCACHE_MASK) >> OT_POGO_IDMA_POGO_IDMA_UDMA_UCR_DESCARCACHE_SHIFT)
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UCR_DESCARCACHE_REPLACE_VAL(reg,val) (((reg) & ~OT_POGO_IDMA_POGO_IDMA_UDMA_UCR_DESCARCACHE_MASK) | (((uint32_t)val) << OT_POGO_IDMA_POGO_IDMA_UDMA_UCR_DESCARCACHE_SHIFT))

#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UCR_DESCAWCACHE_MASK 0xf00
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UCR_DESCAWCACHE_SHIFT 8
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UCR_DESCAWCACHE_MASK_SHIFT(reg) (((reg) & OT_POGO_IDMA_POGO_IDMA_UDMA_UCR_DESCAWCACHE_MASK) >> OT_POGO_IDMA_POGO_IDMA_UDMA_UCR_DESCAWCACHE_SHIFT)
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UCR_DESCAWCACHE_REPLACE_VAL(reg,val) (((reg) & ~OT_POGO_IDMA_POGO_IDMA_UDMA_UCR_DESCAWCACHE_MASK) | (((uint32_t)val) << OT_POGO_IDMA_POGO_IDMA_UDMA_UCR_DESCAWCACHE_SHIFT))

#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UCR_RESERVED2_MASK 0xc0
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UCR_RESERVED2_SHIFT 6
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UCR_RESERVED2_MASK_SHIFT(reg) (((reg) & OT_POGO_IDMA_POGO_IDMA_UDMA_UCR_RESERVED2_MASK) >> OT_POGO_IDMA_POGO_IDMA_UDMA_UCR_RESERVED2_SHIFT)
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UCR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~OT_POGO_IDMA_POGO_IDMA_UDMA_UCR_RESERVED2_MASK) | (((uint32_t)val) << OT_POGO_IDMA_POGO_IDMA_UDMA_UCR_RESERVED2_SHIFT))

#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UCR_HANDSHAKEENABLE_MASK 0x20
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UCR_HANDSHAKEENABLE_SHIFT 5
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UCR_HANDSHAKEENABLE_MASK_SHIFT(reg) (((reg) & OT_POGO_IDMA_POGO_IDMA_UDMA_UCR_HANDSHAKEENABLE_MASK) >> OT_POGO_IDMA_POGO_IDMA_UDMA_UCR_HANDSHAKEENABLE_SHIFT)
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UCR_HANDSHAKEENABLE_REPLACE_VAL(reg,val) (((reg) & ~OT_POGO_IDMA_POGO_IDMA_UDMA_UCR_HANDSHAKEENABLE_MASK) | (((uint32_t)val) << OT_POGO_IDMA_POGO_IDMA_UDMA_UCR_HANDSHAKEENABLE_SHIFT))

#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UCR_OWNWRITEDISABLE_MASK 0x10
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UCR_OWNWRITEDISABLE_SHIFT 4
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UCR_OWNWRITEDISABLE_MASK_SHIFT(reg) (((reg) & OT_POGO_IDMA_POGO_IDMA_UDMA_UCR_OWNWRITEDISABLE_MASK) >> OT_POGO_IDMA_POGO_IDMA_UDMA_UCR_OWNWRITEDISABLE_SHIFT)
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UCR_OWNWRITEDISABLE_REPLACE_VAL(reg,val) (((reg) & ~OT_POGO_IDMA_POGO_IDMA_UDMA_UCR_OWNWRITEDISABLE_MASK) | (((uint32_t)val) << OT_POGO_IDMA_POGO_IDMA_UDMA_UCR_OWNWRITEDISABLE_SHIFT))

#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UCR_OWNPOLARITY_MASK 0x8
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UCR_OWNPOLARITY_SHIFT 3
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UCR_OWNPOLARITY_MASK_SHIFT(reg) (((reg) & OT_POGO_IDMA_POGO_IDMA_UDMA_UCR_OWNPOLARITY_MASK) >> OT_POGO_IDMA_POGO_IDMA_UDMA_UCR_OWNPOLARITY_SHIFT)
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UCR_OWNPOLARITY_REPLACE_VAL(reg,val) (((reg) & ~OT_POGO_IDMA_POGO_IDMA_UDMA_UCR_OWNPOLARITY_MASK) | (((uint32_t)val) << OT_POGO_IDMA_POGO_IDMA_UDMA_UCR_OWNPOLARITY_SHIFT))

#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UCR_BEATS_MASK 0x6
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UCR_BEATS_SHIFT 1
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UCR_BEATS_MASK_SHIFT(reg) (((reg) & OT_POGO_IDMA_POGO_IDMA_UDMA_UCR_BEATS_MASK) >> OT_POGO_IDMA_POGO_IDMA_UDMA_UCR_BEATS_SHIFT)
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UCR_BEATS_REPLACE_VAL(reg,val) (((reg) & ~OT_POGO_IDMA_POGO_IDMA_UDMA_UCR_BEATS_MASK) | (((uint32_t)val) << OT_POGO_IDMA_POGO_IDMA_UDMA_UCR_BEATS_SHIFT))

#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UCR_ENABLE_MASK 0x1
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UCR_ENABLE_SHIFT 0
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UCR_ENABLE_MASK_SHIFT(reg) (((reg) & OT_POGO_IDMA_POGO_IDMA_UDMA_UCR_ENABLE_MASK) >> OT_POGO_IDMA_POGO_IDMA_UDMA_UCR_ENABLE_SHIFT)
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UCR_ENABLE_REPLACE_VAL(reg,val) (((reg) & ~OT_POGO_IDMA_POGO_IDMA_UDMA_UCR_ENABLE_MASK) | (((uint32_t)val) << OT_POGO_IDMA_POGO_IDMA_UDMA_UCR_ENABLE_SHIFT))

//====================================================================
//Register: UDMA Status Register (USR)
//====================================================================

#define  OT_POGO_IDMA_POGO_IDMA_UDMA_USR_RESERVED1_MASK 0xfffff800
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_USR_RESERVED1_SHIFT 11
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_USR_RESERVED1_MASK_SHIFT(reg) (((reg) & OT_POGO_IDMA_POGO_IDMA_UDMA_USR_RESERVED1_MASK) >> OT_POGO_IDMA_POGO_IDMA_UDMA_USR_RESERVED1_SHIFT)
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_USR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~OT_POGO_IDMA_POGO_IDMA_UDMA_USR_RESERVED1_MASK) | (((uint32_t)val) << OT_POGO_IDMA_POGO_IDMA_UDMA_USR_RESERVED1_SHIFT))

#define  OT_POGO_IDMA_POGO_IDMA_UDMA_USR_DMAPAUSED_MASK 0x400
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_USR_DMAPAUSED_SHIFT 10
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_USR_DMAPAUSED_MASK_SHIFT(reg) (((reg) & OT_POGO_IDMA_POGO_IDMA_UDMA_USR_DMAPAUSED_MASK) >> OT_POGO_IDMA_POGO_IDMA_UDMA_USR_DMAPAUSED_SHIFT)
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_USR_DMAPAUSED_REPLACE_VAL(reg,val) (((reg) & ~OT_POGO_IDMA_POGO_IDMA_UDMA_USR_DMAPAUSED_MASK) | (((uint32_t)val) << OT_POGO_IDMA_POGO_IDMA_UDMA_USR_DMAPAUSED_SHIFT))

#define  OT_POGO_IDMA_POGO_IDMA_UDMA_USR_PAUSEAFTER_MASK 0x200
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_USR_PAUSEAFTER_SHIFT 9
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_USR_PAUSEAFTER_MASK_SHIFT(reg) (((reg) & OT_POGO_IDMA_POGO_IDMA_UDMA_USR_PAUSEAFTER_MASK) >> OT_POGO_IDMA_POGO_IDMA_UDMA_USR_PAUSEAFTER_SHIFT)
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_USR_PAUSEAFTER_REPLACE_VAL(reg,val) (((reg) & ~OT_POGO_IDMA_POGO_IDMA_UDMA_USR_PAUSEAFTER_MASK) | (((uint32_t)val) << OT_POGO_IDMA_POGO_IDMA_UDMA_USR_PAUSEAFTER_SHIFT))

#define  OT_POGO_IDMA_POGO_IDMA_UDMA_USR_PAUSEBEFORE_MASK 0x100
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_USR_PAUSEBEFORE_SHIFT 8
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_USR_PAUSEBEFORE_MASK_SHIFT(reg) (((reg) & OT_POGO_IDMA_POGO_IDMA_UDMA_USR_PAUSEBEFORE_MASK) >> OT_POGO_IDMA_POGO_IDMA_UDMA_USR_PAUSEBEFORE_SHIFT)
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_USR_PAUSEBEFORE_REPLACE_VAL(reg,val) (((reg) & ~OT_POGO_IDMA_POGO_IDMA_UDMA_USR_PAUSEBEFORE_MASK) | (((uint32_t)val) << OT_POGO_IDMA_POGO_IDMA_UDMA_USR_PAUSEBEFORE_SHIFT))

#define  OT_POGO_IDMA_POGO_IDMA_UDMA_USR_INTONFINISH_MASK 0x80
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_USR_INTONFINISH_SHIFT 7
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_USR_INTONFINISH_MASK_SHIFT(reg) (((reg) & OT_POGO_IDMA_POGO_IDMA_UDMA_USR_INTONFINISH_MASK) >> OT_POGO_IDMA_POGO_IDMA_UDMA_USR_INTONFINISH_SHIFT)
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_USR_INTONFINISH_REPLACE_VAL(reg,val) (((reg) & ~OT_POGO_IDMA_POGO_IDMA_UDMA_USR_INTONFINISH_MASK) | (((uint32_t)val) << OT_POGO_IDMA_POGO_IDMA_UDMA_USR_INTONFINISH_SHIFT))

#define  OT_POGO_IDMA_POGO_IDMA_UDMA_USR_STOPONFINISH_MASK 0x40
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_USR_STOPONFINISH_SHIFT 6
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_USR_STOPONFINISH_MASK_SHIFT(reg) (((reg) & OT_POGO_IDMA_POGO_IDMA_UDMA_USR_STOPONFINISH_MASK) >> OT_POGO_IDMA_POGO_IDMA_UDMA_USR_STOPONFINISH_SHIFT)
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_USR_STOPONFINISH_REPLACE_VAL(reg,val) (((reg) & ~OT_POGO_IDMA_POGO_IDMA_UDMA_USR_STOPONFINISH_MASK) | (((uint32_t)val) << OT_POGO_IDMA_POGO_IDMA_UDMA_USR_STOPONFINISH_SHIFT))

#define  OT_POGO_IDMA_POGO_IDMA_UDMA_USR_CMDBUFFULL_MASK 0x20
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_USR_CMDBUFFULL_SHIFT 5
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_USR_CMDBUFFULL_MASK_SHIFT(reg) (((reg) & OT_POGO_IDMA_POGO_IDMA_UDMA_USR_CMDBUFFULL_MASK) >> OT_POGO_IDMA_POGO_IDMA_UDMA_USR_CMDBUFFULL_SHIFT)
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_USR_CMDBUFFULL_REPLACE_VAL(reg,val) (((reg) & ~OT_POGO_IDMA_POGO_IDMA_UDMA_USR_CMDBUFFULL_MASK) | (((uint32_t)val) << OT_POGO_IDMA_POGO_IDMA_UDMA_USR_CMDBUFFULL_SHIFT))

#define  OT_POGO_IDMA_POGO_IDMA_UDMA_USR_CMDBUFEMPTY_MASK 0x10
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_USR_CMDBUFEMPTY_SHIFT 4
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_USR_CMDBUFEMPTY_MASK_SHIFT(reg) (((reg) & OT_POGO_IDMA_POGO_IDMA_UDMA_USR_CMDBUFEMPTY_MASK) >> OT_POGO_IDMA_POGO_IDMA_UDMA_USR_CMDBUFEMPTY_SHIFT)
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_USR_CMDBUFEMPTY_REPLACE_VAL(reg,val) (((reg) & ~OT_POGO_IDMA_POGO_IDMA_UDMA_USR_CMDBUFEMPTY_MASK) | (((uint32_t)val) << OT_POGO_IDMA_POGO_IDMA_UDMA_USR_CMDBUFEMPTY_SHIFT))

#define  OT_POGO_IDMA_POGO_IDMA_UDMA_USR_DATABUFFULL_MASK 0x8
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_USR_DATABUFFULL_SHIFT 3
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_USR_DATABUFFULL_MASK_SHIFT(reg) (((reg) & OT_POGO_IDMA_POGO_IDMA_UDMA_USR_DATABUFFULL_MASK) >> OT_POGO_IDMA_POGO_IDMA_UDMA_USR_DATABUFFULL_SHIFT)
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_USR_DATABUFFULL_REPLACE_VAL(reg,val) (((reg) & ~OT_POGO_IDMA_POGO_IDMA_UDMA_USR_DATABUFFULL_MASK) | (((uint32_t)val) << OT_POGO_IDMA_POGO_IDMA_UDMA_USR_DATABUFFULL_SHIFT))

#define  OT_POGO_IDMA_POGO_IDMA_UDMA_USR_DATABUFEMPTY_MASK 0x4
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_USR_DATABUFEMPTY_SHIFT 2
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_USR_DATABUFEMPTY_MASK_SHIFT(reg) (((reg) & OT_POGO_IDMA_POGO_IDMA_UDMA_USR_DATABUFEMPTY_MASK) >> OT_POGO_IDMA_POGO_IDMA_UDMA_USR_DATABUFEMPTY_SHIFT)
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_USR_DATABUFEMPTY_REPLACE_VAL(reg,val) (((reg) & ~OT_POGO_IDMA_POGO_IDMA_UDMA_USR_DATABUFEMPTY_MASK) | (((uint32_t)val) << OT_POGO_IDMA_POGO_IDMA_UDMA_USR_DATABUFEMPTY_SHIFT))

#define  OT_POGO_IDMA_POGO_IDMA_UDMA_USR_CLEAR_MASK 0x2
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_USR_CLEAR_SHIFT 1
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_USR_CLEAR_MASK_SHIFT(reg) (((reg) & OT_POGO_IDMA_POGO_IDMA_UDMA_USR_CLEAR_MASK) >> OT_POGO_IDMA_POGO_IDMA_UDMA_USR_CLEAR_SHIFT)
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_USR_CLEAR_REPLACE_VAL(reg,val) (((reg) & ~OT_POGO_IDMA_POGO_IDMA_UDMA_USR_CLEAR_MASK) | (((uint32_t)val) << OT_POGO_IDMA_POGO_IDMA_UDMA_USR_CLEAR_SHIFT))

#define  OT_POGO_IDMA_POGO_IDMA_UDMA_USR_BUSY_MASK 0x1
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_USR_BUSY_SHIFT 0
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_USR_BUSY_MASK_SHIFT(reg) (((reg) & OT_POGO_IDMA_POGO_IDMA_UDMA_USR_BUSY_MASK) >> OT_POGO_IDMA_POGO_IDMA_UDMA_USR_BUSY_SHIFT)
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_USR_BUSY_REPLACE_VAL(reg,val) (((reg) & ~OT_POGO_IDMA_POGO_IDMA_UDMA_USR_BUSY_MASK) | (((uint32_t)val) << OT_POGO_IDMA_POGO_IDMA_UDMA_USR_BUSY_SHIFT))

//====================================================================
//Register: UDMA Parameter Register (UPR)
//====================================================================

#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UPR_RESERVED1_MASK 0xff000000
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UPR_RESERVED1_SHIFT 24
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UPR_RESERVED1_MASK_SHIFT(reg) (((reg) & OT_POGO_IDMA_POGO_IDMA_UDMA_UPR_RESERVED1_MASK) >> OT_POGO_IDMA_POGO_IDMA_UDMA_UPR_RESERVED1_SHIFT)
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UPR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~OT_POGO_IDMA_POGO_IDMA_UDMA_UPR_RESERVED1_MASK) | (((uint32_t)val) << OT_POGO_IDMA_POGO_IDMA_UDMA_UPR_RESERVED1_SHIFT))

#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UPR_FIFODEPTH_MASK 0xffff00
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UPR_FIFODEPTH_SHIFT 8
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UPR_FIFODEPTH_MASK_SHIFT(reg) (((reg) & OT_POGO_IDMA_POGO_IDMA_UDMA_UPR_FIFODEPTH_MASK) >> OT_POGO_IDMA_POGO_IDMA_UDMA_UPR_FIFODEPTH_SHIFT)
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UPR_FIFODEPTH_REPLACE_VAL(reg,val) (((reg) & ~OT_POGO_IDMA_POGO_IDMA_UDMA_UPR_FIFODEPTH_MASK) | (((uint32_t)val) << OT_POGO_IDMA_POGO_IDMA_UDMA_UPR_FIFODEPTH_SHIFT))

#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UPR_RESERVED2_MASK 0xe0
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UPR_RESERVED2_SHIFT 5
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UPR_RESERVED2_MASK_SHIFT(reg) (((reg) & OT_POGO_IDMA_POGO_IDMA_UDMA_UPR_RESERVED2_MASK) >> OT_POGO_IDMA_POGO_IDMA_UDMA_UPR_RESERVED2_SHIFT)
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UPR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~OT_POGO_IDMA_POGO_IDMA_UDMA_UPR_RESERVED2_MASK) | (((uint32_t)val) << OT_POGO_IDMA_POGO_IDMA_UDMA_UPR_RESERVED2_SHIFT))

#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UPR_SERPSUPPORT_MASK 0x10
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UPR_SERPSUPPORT_SHIFT 4
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UPR_SERPSUPPORT_MASK_SHIFT(reg) (((reg) & OT_POGO_IDMA_POGO_IDMA_UDMA_UPR_SERPSUPPORT_MASK) >> OT_POGO_IDMA_POGO_IDMA_UDMA_UPR_SERPSUPPORT_SHIFT)
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UPR_SERPSUPPORT_REPLACE_VAL(reg,val) (((reg) & ~OT_POGO_IDMA_POGO_IDMA_UDMA_UPR_SERPSUPPORT_MASK) | (((uint32_t)val) << OT_POGO_IDMA_POGO_IDMA_UDMA_UPR_SERPSUPPORT_SHIFT))

#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UPR_DESCLENGTH_MASK 0x8
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UPR_DESCLENGTH_SHIFT 3
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UPR_DESCLENGTH_MASK_SHIFT(reg) (((reg) & OT_POGO_IDMA_POGO_IDMA_UDMA_UPR_DESCLENGTH_MASK) >> OT_POGO_IDMA_POGO_IDMA_UDMA_UPR_DESCLENGTH_SHIFT)
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UPR_DESCLENGTH_REPLACE_VAL(reg,val) (((reg) & ~OT_POGO_IDMA_POGO_IDMA_UDMA_UPR_DESCLENGTH_MASK) | (((uint32_t)val) << OT_POGO_IDMA_POGO_IDMA_UDMA_UPR_DESCLENGTH_SHIFT))

#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UPR_BUSWIDTH_MASK 0x4
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UPR_BUSWIDTH_SHIFT 2
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UPR_BUSWIDTH_MASK_SHIFT(reg) (((reg) & OT_POGO_IDMA_POGO_IDMA_UDMA_UPR_BUSWIDTH_MASK) >> OT_POGO_IDMA_POGO_IDMA_UDMA_UPR_BUSWIDTH_SHIFT)
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UPR_BUSWIDTH_REPLACE_VAL(reg,val) (((reg) & ~OT_POGO_IDMA_POGO_IDMA_UDMA_UPR_BUSWIDTH_MASK) | (((uint32_t)val) << OT_POGO_IDMA_POGO_IDMA_UDMA_UPR_BUSWIDTH_SHIFT))

#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UPR_MEMALIGN_MASK 0x3
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UPR_MEMALIGN_SHIFT 0
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UPR_MEMALIGN_MASK_SHIFT(reg) (((reg) & OT_POGO_IDMA_POGO_IDMA_UDMA_UPR_MEMALIGN_MASK) >> OT_POGO_IDMA_POGO_IDMA_UDMA_UPR_MEMALIGN_SHIFT)
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UPR_MEMALIGN_REPLACE_VAL(reg,val) (((reg) & ~OT_POGO_IDMA_POGO_IDMA_UDMA_UPR_MEMALIGN_MASK) | (((uint32_t)val) << OT_POGO_IDMA_POGO_IDMA_UDMA_UPR_MEMALIGN_SHIFT))

//====================================================================
//Register: UDMA Interrupt Enable Register (UIER)
//====================================================================

#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UIER_RESERVED1_MASK 0xffffffc0
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UIER_RESERVED1_SHIFT 6
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UIER_RESERVED1_MASK_SHIFT(reg) (((reg) & OT_POGO_IDMA_POGO_IDMA_UDMA_UIER_RESERVED1_MASK) >> OT_POGO_IDMA_POGO_IDMA_UDMA_UIER_RESERVED1_SHIFT)
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UIER_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~OT_POGO_IDMA_POGO_IDMA_UDMA_UIER_RESERVED1_MASK) | (((uint32_t)val) << OT_POGO_IDMA_POGO_IDMA_UDMA_UIER_RESERVED1_SHIFT))

#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UIER_OUTOFRANGE_MASK 0x20
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UIER_OUTOFRANGE_SHIFT 5
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UIER_OUTOFRANGE_MASK_SHIFT(reg) (((reg) & OT_POGO_IDMA_POGO_IDMA_UDMA_UIER_OUTOFRANGE_MASK) >> OT_POGO_IDMA_POGO_IDMA_UDMA_UIER_OUTOFRANGE_SHIFT)
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UIER_OUTOFRANGE_REPLACE_VAL(reg,val) (((reg) & ~OT_POGO_IDMA_POGO_IDMA_UDMA_UIER_OUTOFRANGE_MASK) | (((uint32_t)val) << OT_POGO_IDMA_POGO_IDMA_UDMA_UIER_OUTOFRANGE_SHIFT))

#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UIER_RRESP_MASK 0x10
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UIER_RRESP_SHIFT 4
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UIER_RRESP_MASK_SHIFT(reg) (((reg) & OT_POGO_IDMA_POGO_IDMA_UDMA_UIER_RRESP_MASK) >> OT_POGO_IDMA_POGO_IDMA_UDMA_UIER_RRESP_SHIFT)
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UIER_RRESP_REPLACE_VAL(reg,val) (((reg) & ~OT_POGO_IDMA_POGO_IDMA_UDMA_UIER_RRESP_MASK) | (((uint32_t)val) << OT_POGO_IDMA_POGO_IDMA_UDMA_UIER_RRESP_SHIFT))

#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UIER_BRESP_MASK 0x8
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UIER_BRESP_SHIFT 3
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UIER_BRESP_MASK_SHIFT(reg) (((reg) & OT_POGO_IDMA_POGO_IDMA_UDMA_UIER_BRESP_MASK) >> OT_POGO_IDMA_POGO_IDMA_UDMA_UIER_BRESP_SHIFT)
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UIER_BRESP_REPLACE_VAL(reg,val) (((reg) & ~OT_POGO_IDMA_POGO_IDMA_UDMA_UIER_BRESP_MASK) | (((uint32_t)val) << OT_POGO_IDMA_POGO_IDMA_UDMA_UIER_BRESP_SHIFT))

#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UIER_CLEARCOMPLETE_MASK 0x4
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UIER_CLEARCOMPLETE_SHIFT 2
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UIER_CLEARCOMPLETE_MASK_SHIFT(reg) (((reg) & OT_POGO_IDMA_POGO_IDMA_UDMA_UIER_CLEARCOMPLETE_MASK) >> OT_POGO_IDMA_POGO_IDMA_UDMA_UIER_CLEARCOMPLETE_SHIFT)
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UIER_CLEARCOMPLETE_REPLACE_VAL(reg,val) (((reg) & ~OT_POGO_IDMA_POGO_IDMA_UDMA_UIER_CLEARCOMPLETE_MASK) | (((uint32_t)val) << OT_POGO_IDMA_POGO_IDMA_UDMA_UIER_CLEARCOMPLETE_SHIFT))

#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UIER_DESC_MASK 0x2
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UIER_DESC_SHIFT 1
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UIER_DESC_MASK_SHIFT(reg) (((reg) & OT_POGO_IDMA_POGO_IDMA_UDMA_UIER_DESC_MASK) >> OT_POGO_IDMA_POGO_IDMA_UDMA_UIER_DESC_SHIFT)
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UIER_DESC_REPLACE_VAL(reg,val) (((reg) & ~OT_POGO_IDMA_POGO_IDMA_UDMA_UIER_DESC_MASK) | (((uint32_t)val) << OT_POGO_IDMA_POGO_IDMA_UDMA_UIER_DESC_SHIFT))

#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UIER_OWN_MASK 0x1
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UIER_OWN_SHIFT 0
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UIER_OWN_MASK_SHIFT(reg) (((reg) & OT_POGO_IDMA_POGO_IDMA_UDMA_UIER_OWN_MASK) >> OT_POGO_IDMA_POGO_IDMA_UDMA_UIER_OWN_SHIFT)
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UIER_OWN_REPLACE_VAL(reg,val) (((reg) & ~OT_POGO_IDMA_POGO_IDMA_UDMA_UIER_OWN_MASK) | (((uint32_t)val) << OT_POGO_IDMA_POGO_IDMA_UDMA_UIER_OWN_SHIFT))

//====================================================================
//Register: UDMA Interrupt Pending Register (UIPR)
//====================================================================

#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UIPR_RESERVED1_MASK 0xffffffc0
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UIPR_RESERVED1_SHIFT 6
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UIPR_RESERVED1_MASK_SHIFT(reg) (((reg) & OT_POGO_IDMA_POGO_IDMA_UDMA_UIPR_RESERVED1_MASK) >> OT_POGO_IDMA_POGO_IDMA_UDMA_UIPR_RESERVED1_SHIFT)
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UIPR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~OT_POGO_IDMA_POGO_IDMA_UDMA_UIPR_RESERVED1_MASK) | (((uint32_t)val) << OT_POGO_IDMA_POGO_IDMA_UDMA_UIPR_RESERVED1_SHIFT))

#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UIPR_OUTOFRANGE_MASK 0x20
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UIPR_OUTOFRANGE_SHIFT 5
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UIPR_OUTOFRANGE_MASK_SHIFT(reg) (((reg) & OT_POGO_IDMA_POGO_IDMA_UDMA_UIPR_OUTOFRANGE_MASK) >> OT_POGO_IDMA_POGO_IDMA_UDMA_UIPR_OUTOFRANGE_SHIFT)
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UIPR_OUTOFRANGE_REPLACE_VAL(reg,val) (((reg) & ~OT_POGO_IDMA_POGO_IDMA_UDMA_UIPR_OUTOFRANGE_MASK) | (((uint32_t)val) << OT_POGO_IDMA_POGO_IDMA_UDMA_UIPR_OUTOFRANGE_SHIFT))

#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UIPR_RRESP_MASK 0x10
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UIPR_RRESP_SHIFT 4
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UIPR_RRESP_MASK_SHIFT(reg) (((reg) & OT_POGO_IDMA_POGO_IDMA_UDMA_UIPR_RRESP_MASK) >> OT_POGO_IDMA_POGO_IDMA_UDMA_UIPR_RRESP_SHIFT)
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UIPR_RRESP_REPLACE_VAL(reg,val) (((reg) & ~OT_POGO_IDMA_POGO_IDMA_UDMA_UIPR_RRESP_MASK) | (((uint32_t)val) << OT_POGO_IDMA_POGO_IDMA_UDMA_UIPR_RRESP_SHIFT))

#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UIPR_BRESP_MASK 0x8
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UIPR_BRESP_SHIFT 3
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UIPR_BRESP_MASK_SHIFT(reg) (((reg) & OT_POGO_IDMA_POGO_IDMA_UDMA_UIPR_BRESP_MASK) >> OT_POGO_IDMA_POGO_IDMA_UDMA_UIPR_BRESP_SHIFT)
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UIPR_BRESP_REPLACE_VAL(reg,val) (((reg) & ~OT_POGO_IDMA_POGO_IDMA_UDMA_UIPR_BRESP_MASK) | (((uint32_t)val) << OT_POGO_IDMA_POGO_IDMA_UDMA_UIPR_BRESP_SHIFT))

#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UIPR_CLEARCOMPLETE_MASK 0x4
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UIPR_CLEARCOMPLETE_SHIFT 2
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UIPR_CLEARCOMPLETE_MASK_SHIFT(reg) (((reg) & OT_POGO_IDMA_POGO_IDMA_UDMA_UIPR_CLEARCOMPLETE_MASK) >> OT_POGO_IDMA_POGO_IDMA_UDMA_UIPR_CLEARCOMPLETE_SHIFT)
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UIPR_CLEARCOMPLETE_REPLACE_VAL(reg,val) (((reg) & ~OT_POGO_IDMA_POGO_IDMA_UDMA_UIPR_CLEARCOMPLETE_MASK) | (((uint32_t)val) << OT_POGO_IDMA_POGO_IDMA_UDMA_UIPR_CLEARCOMPLETE_SHIFT))

#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UIPR_DESC_MASK 0x2
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UIPR_DESC_SHIFT 1
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UIPR_DESC_MASK_SHIFT(reg) (((reg) & OT_POGO_IDMA_POGO_IDMA_UDMA_UIPR_DESC_MASK) >> OT_POGO_IDMA_POGO_IDMA_UDMA_UIPR_DESC_SHIFT)
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UIPR_DESC_REPLACE_VAL(reg,val) (((reg) & ~OT_POGO_IDMA_POGO_IDMA_UDMA_UIPR_DESC_MASK) | (((uint32_t)val) << OT_POGO_IDMA_POGO_IDMA_UDMA_UIPR_DESC_SHIFT))

#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UIPR_OWN_MASK 0x1
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UIPR_OWN_SHIFT 0
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UIPR_OWN_MASK_SHIFT(reg) (((reg) & OT_POGO_IDMA_POGO_IDMA_UDMA_UIPR_OWN_MASK) >> OT_POGO_IDMA_POGO_IDMA_UDMA_UIPR_OWN_SHIFT)
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UIPR_OWN_REPLACE_VAL(reg,val) (((reg) & ~OT_POGO_IDMA_POGO_IDMA_UDMA_UIPR_OWN_MASK) | (((uint32_t)val) << OT_POGO_IDMA_POGO_IDMA_UDMA_UIPR_OWN_SHIFT))

//====================================================================
//Register: UDMA Interrupt Clear Register (UICR)
//====================================================================

#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UICR_RESERVED1_MASK 0xffffffc0
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UICR_RESERVED1_SHIFT 6
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UICR_RESERVED1_MASK_SHIFT(reg) (((reg) & OT_POGO_IDMA_POGO_IDMA_UDMA_UICR_RESERVED1_MASK) >> OT_POGO_IDMA_POGO_IDMA_UDMA_UICR_RESERVED1_SHIFT)
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UICR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~OT_POGO_IDMA_POGO_IDMA_UDMA_UICR_RESERVED1_MASK) | (((uint32_t)val) << OT_POGO_IDMA_POGO_IDMA_UDMA_UICR_RESERVED1_SHIFT))

#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UICR_OUTOFRANGE_MASK 0x20
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UICR_OUTOFRANGE_SHIFT 5
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UICR_OUTOFRANGE_MASK_SHIFT(reg) (((reg) & OT_POGO_IDMA_POGO_IDMA_UDMA_UICR_OUTOFRANGE_MASK) >> OT_POGO_IDMA_POGO_IDMA_UDMA_UICR_OUTOFRANGE_SHIFT)
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UICR_OUTOFRANGE_REPLACE_VAL(reg,val) (((reg) & ~OT_POGO_IDMA_POGO_IDMA_UDMA_UICR_OUTOFRANGE_MASK) | (((uint32_t)val) << OT_POGO_IDMA_POGO_IDMA_UDMA_UICR_OUTOFRANGE_SHIFT))

#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UICR_RRESP_MASK 0x10
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UICR_RRESP_SHIFT 4
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UICR_RRESP_MASK_SHIFT(reg) (((reg) & OT_POGO_IDMA_POGO_IDMA_UDMA_UICR_RRESP_MASK) >> OT_POGO_IDMA_POGO_IDMA_UDMA_UICR_RRESP_SHIFT)
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UICR_RRESP_REPLACE_VAL(reg,val) (((reg) & ~OT_POGO_IDMA_POGO_IDMA_UDMA_UICR_RRESP_MASK) | (((uint32_t)val) << OT_POGO_IDMA_POGO_IDMA_UDMA_UICR_RRESP_SHIFT))

#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UICR_BRESP_MASK 0x8
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UICR_BRESP_SHIFT 3
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UICR_BRESP_MASK_SHIFT(reg) (((reg) & OT_POGO_IDMA_POGO_IDMA_UDMA_UICR_BRESP_MASK) >> OT_POGO_IDMA_POGO_IDMA_UDMA_UICR_BRESP_SHIFT)
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UICR_BRESP_REPLACE_VAL(reg,val) (((reg) & ~OT_POGO_IDMA_POGO_IDMA_UDMA_UICR_BRESP_MASK) | (((uint32_t)val) << OT_POGO_IDMA_POGO_IDMA_UDMA_UICR_BRESP_SHIFT))

#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UICR_CLEARCOMPLETE_MASK 0x4
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UICR_CLEARCOMPLETE_SHIFT 2
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UICR_CLEARCOMPLETE_MASK_SHIFT(reg) (((reg) & OT_POGO_IDMA_POGO_IDMA_UDMA_UICR_CLEARCOMPLETE_MASK) >> OT_POGO_IDMA_POGO_IDMA_UDMA_UICR_CLEARCOMPLETE_SHIFT)
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UICR_CLEARCOMPLETE_REPLACE_VAL(reg,val) (((reg) & ~OT_POGO_IDMA_POGO_IDMA_UDMA_UICR_CLEARCOMPLETE_MASK) | (((uint32_t)val) << OT_POGO_IDMA_POGO_IDMA_UDMA_UICR_CLEARCOMPLETE_SHIFT))

#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UICR_DESC_MASK 0x2
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UICR_DESC_SHIFT 1
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UICR_DESC_MASK_SHIFT(reg) (((reg) & OT_POGO_IDMA_POGO_IDMA_UDMA_UICR_DESC_MASK) >> OT_POGO_IDMA_POGO_IDMA_UDMA_UICR_DESC_SHIFT)
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UICR_DESC_REPLACE_VAL(reg,val) (((reg) & ~OT_POGO_IDMA_POGO_IDMA_UDMA_UICR_DESC_MASK) | (((uint32_t)val) << OT_POGO_IDMA_POGO_IDMA_UDMA_UICR_DESC_SHIFT))

#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UICR_OWN_MASK 0x1
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UICR_OWN_SHIFT 0
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UICR_OWN_MASK_SHIFT(reg) (((reg) & OT_POGO_IDMA_POGO_IDMA_UDMA_UICR_OWN_MASK) >> OT_POGO_IDMA_POGO_IDMA_UDMA_UICR_OWN_SHIFT)
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UICR_OWN_REPLACE_VAL(reg,val) (((reg) & ~OT_POGO_IDMA_POGO_IDMA_UDMA_UICR_OWN_MASK) | (((uint32_t)val) << OT_POGO_IDMA_POGO_IDMA_UDMA_UICR_OWN_SHIFT))

//====================================================================
//Register: UDMA Interrupt Force Register (UIFR)
//====================================================================

#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UIFR_RESERVED1_MASK 0xffffffc0
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UIFR_RESERVED1_SHIFT 6
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UIFR_RESERVED1_MASK_SHIFT(reg) (((reg) & OT_POGO_IDMA_POGO_IDMA_UDMA_UIFR_RESERVED1_MASK) >> OT_POGO_IDMA_POGO_IDMA_UDMA_UIFR_RESERVED1_SHIFT)
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UIFR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~OT_POGO_IDMA_POGO_IDMA_UDMA_UIFR_RESERVED1_MASK) | (((uint32_t)val) << OT_POGO_IDMA_POGO_IDMA_UDMA_UIFR_RESERVED1_SHIFT))

#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UIFR_OUTOFRANGE_MASK 0x20
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UIFR_OUTOFRANGE_SHIFT 5
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UIFR_OUTOFRANGE_MASK_SHIFT(reg) (((reg) & OT_POGO_IDMA_POGO_IDMA_UDMA_UIFR_OUTOFRANGE_MASK) >> OT_POGO_IDMA_POGO_IDMA_UDMA_UIFR_OUTOFRANGE_SHIFT)
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UIFR_OUTOFRANGE_REPLACE_VAL(reg,val) (((reg) & ~OT_POGO_IDMA_POGO_IDMA_UDMA_UIFR_OUTOFRANGE_MASK) | (((uint32_t)val) << OT_POGO_IDMA_POGO_IDMA_UDMA_UIFR_OUTOFRANGE_SHIFT))

#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UIFR_RRESP_MASK 0x10
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UIFR_RRESP_SHIFT 4
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UIFR_RRESP_MASK_SHIFT(reg) (((reg) & OT_POGO_IDMA_POGO_IDMA_UDMA_UIFR_RRESP_MASK) >> OT_POGO_IDMA_POGO_IDMA_UDMA_UIFR_RRESP_SHIFT)
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UIFR_RRESP_REPLACE_VAL(reg,val) (((reg) & ~OT_POGO_IDMA_POGO_IDMA_UDMA_UIFR_RRESP_MASK) | (((uint32_t)val) << OT_POGO_IDMA_POGO_IDMA_UDMA_UIFR_RRESP_SHIFT))

#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UIFR_BRESP_MASK 0x8
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UIFR_BRESP_SHIFT 3
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UIFR_BRESP_MASK_SHIFT(reg) (((reg) & OT_POGO_IDMA_POGO_IDMA_UDMA_UIFR_BRESP_MASK) >> OT_POGO_IDMA_POGO_IDMA_UDMA_UIFR_BRESP_SHIFT)
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UIFR_BRESP_REPLACE_VAL(reg,val) (((reg) & ~OT_POGO_IDMA_POGO_IDMA_UDMA_UIFR_BRESP_MASK) | (((uint32_t)val) << OT_POGO_IDMA_POGO_IDMA_UDMA_UIFR_BRESP_SHIFT))

#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UIFR_CLEARCOMPLETE_MASK 0x4
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UIFR_CLEARCOMPLETE_SHIFT 2
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UIFR_CLEARCOMPLETE_MASK_SHIFT(reg) (((reg) & OT_POGO_IDMA_POGO_IDMA_UDMA_UIFR_CLEARCOMPLETE_MASK) >> OT_POGO_IDMA_POGO_IDMA_UDMA_UIFR_CLEARCOMPLETE_SHIFT)
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UIFR_CLEARCOMPLETE_REPLACE_VAL(reg,val) (((reg) & ~OT_POGO_IDMA_POGO_IDMA_UDMA_UIFR_CLEARCOMPLETE_MASK) | (((uint32_t)val) << OT_POGO_IDMA_POGO_IDMA_UDMA_UIFR_CLEARCOMPLETE_SHIFT))

#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UIFR_DESC_MASK 0x2
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UIFR_DESC_SHIFT 1
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UIFR_DESC_MASK_SHIFT(reg) (((reg) & OT_POGO_IDMA_POGO_IDMA_UDMA_UIFR_DESC_MASK) >> OT_POGO_IDMA_POGO_IDMA_UDMA_UIFR_DESC_SHIFT)
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UIFR_DESC_REPLACE_VAL(reg,val) (((reg) & ~OT_POGO_IDMA_POGO_IDMA_UDMA_UIFR_DESC_MASK) | (((uint32_t)val) << OT_POGO_IDMA_POGO_IDMA_UDMA_UIFR_DESC_SHIFT))

#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UIFR_OWN_MASK 0x1
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UIFR_OWN_SHIFT 0
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UIFR_OWN_MASK_SHIFT(reg) (((reg) & OT_POGO_IDMA_POGO_IDMA_UDMA_UIFR_OWN_MASK) >> OT_POGO_IDMA_POGO_IDMA_UDMA_UIFR_OWN_SHIFT)
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UIFR_OWN_REPLACE_VAL(reg,val) (((reg) & ~OT_POGO_IDMA_POGO_IDMA_UDMA_UIFR_OWN_MASK) | (((uint32_t)val) << OT_POGO_IDMA_POGO_IDMA_UDMA_UIFR_OWN_SHIFT))

//====================================================================
//Register: UDMA Descriptor Register (UDR)
//====================================================================

#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UDR_DESC_MASK 0xffffffff
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UDR_DESC_SHIFT 0
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UDR_DESC_MASK_SHIFT(reg) (((reg) & OT_POGO_IDMA_POGO_IDMA_UDMA_UDR_DESC_MASK) >> OT_POGO_IDMA_POGO_IDMA_UDMA_UDR_DESC_SHIFT)
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UDR_DESC_REPLACE_VAL(reg,val) (((reg) & ~OT_POGO_IDMA_POGO_IDMA_UDMA_UDR_DESC_MASK) | (((uint32_t)val) << OT_POGO_IDMA_POGO_IDMA_UDMA_UDR_DESC_SHIFT))

//====================================================================
//Register: UDMA Burst Address Register (UBAR)
//====================================================================

#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UBAR_BURSTADDR_MASK 0xffffffff
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UBAR_BURSTADDR_SHIFT 0
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UBAR_BURSTADDR_MASK_SHIFT(reg) (((reg) & OT_POGO_IDMA_POGO_IDMA_UDMA_UBAR_BURSTADDR_MASK) >> OT_POGO_IDMA_POGO_IDMA_UDMA_UBAR_BURSTADDR_SHIFT)
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UBAR_BURSTADDR_REPLACE_VAL(reg,val) (((reg) & ~OT_POGO_IDMA_POGO_IDMA_UDMA_UBAR_BURSTADDR_MASK) | (((uint32_t)val) << OT_POGO_IDMA_POGO_IDMA_UDMA_UBAR_BURSTADDR_SHIFT))

//====================================================================
//Register: UDMA Burst Length Register (UBLR)
//====================================================================

#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UBLR_RESERVED1_MASK 0xfffffc00
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UBLR_RESERVED1_SHIFT 10
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UBLR_RESERVED1_MASK_SHIFT(reg) (((reg) & OT_POGO_IDMA_POGO_IDMA_UDMA_UBLR_RESERVED1_MASK) >> OT_POGO_IDMA_POGO_IDMA_UDMA_UBLR_RESERVED1_SHIFT)
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UBLR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~OT_POGO_IDMA_POGO_IDMA_UDMA_UBLR_RESERVED1_MASK) | (((uint32_t)val) << OT_POGO_IDMA_POGO_IDMA_UDMA_UBLR_RESERVED1_SHIFT))

#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UBLR_BURSTDIR_MASK 0x200
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UBLR_BURSTDIR_SHIFT 9
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UBLR_BURSTDIR_MASK_SHIFT(reg) (((reg) & OT_POGO_IDMA_POGO_IDMA_UDMA_UBLR_BURSTDIR_MASK) >> OT_POGO_IDMA_POGO_IDMA_UDMA_UBLR_BURSTDIR_SHIFT)
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UBLR_BURSTDIR_REPLACE_VAL(reg,val) (((reg) & ~OT_POGO_IDMA_POGO_IDMA_UDMA_UBLR_BURSTDIR_MASK) | (((uint32_t)val) << OT_POGO_IDMA_POGO_IDMA_UDMA_UBLR_BURSTDIR_SHIFT))

#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UBLR_BURSTLAST_MASK 0x100
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UBLR_BURSTLAST_SHIFT 8
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UBLR_BURSTLAST_MASK_SHIFT(reg) (((reg) & OT_POGO_IDMA_POGO_IDMA_UDMA_UBLR_BURSTLAST_MASK) >> OT_POGO_IDMA_POGO_IDMA_UDMA_UBLR_BURSTLAST_SHIFT)
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UBLR_BURSTLAST_REPLACE_VAL(reg,val) (((reg) & ~OT_POGO_IDMA_POGO_IDMA_UDMA_UBLR_BURSTLAST_MASK) | (((uint32_t)val) << OT_POGO_IDMA_POGO_IDMA_UDMA_UBLR_BURSTLAST_SHIFT))

#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UBLR_BURSTLENGTH_MASK 0xff
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UBLR_BURSTLENGTH_SHIFT 0
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UBLR_BURSTLENGTH_MASK_SHIFT(reg) (((reg) & OT_POGO_IDMA_POGO_IDMA_UDMA_UBLR_BURSTLENGTH_MASK) >> OT_POGO_IDMA_POGO_IDMA_UDMA_UBLR_BURSTLENGTH_SHIFT)
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UBLR_BURSTLENGTH_REPLACE_VAL(reg,val) (((reg) & ~OT_POGO_IDMA_POGO_IDMA_UDMA_UBLR_BURSTLENGTH_MASK) | (((uint32_t)val) << OT_POGO_IDMA_POGO_IDMA_UDMA_UBLR_BURSTLENGTH_SHIFT))

//====================================================================
//Register: UDMA Transfer Bytes Remaining Register (UBRR)
//====================================================================

#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UBRR_BYTESREMAIN_MASK 0xffffffff
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UBRR_BYTESREMAIN_SHIFT 0
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UBRR_BYTESREMAIN_MASK_SHIFT(reg) (((reg) & OT_POGO_IDMA_POGO_IDMA_UDMA_UBRR_BYTESREMAIN_MASK) >> OT_POGO_IDMA_POGO_IDMA_UDMA_UBRR_BYTESREMAIN_SHIFT)
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UBRR_BYTESREMAIN_REPLACE_VAL(reg,val) (((reg) & ~OT_POGO_IDMA_POGO_IDMA_UDMA_UBRR_BYTESREMAIN_MASK) | (((uint32_t)val) << OT_POGO_IDMA_POGO_IDMA_UDMA_UBRR_BYTESREMAIN_SHIFT))

//====================================================================
//Register: UDMA Tag Register 0 (UTR0)
//====================================================================

#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UTR0_TAGMAJ_MASK 0xffff0000
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UTR0_TAGMAJ_SHIFT 16
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UTR0_TAGMAJ_MASK_SHIFT(reg) (((reg) & OT_POGO_IDMA_POGO_IDMA_UDMA_UTR0_TAGMAJ_MASK) >> OT_POGO_IDMA_POGO_IDMA_UDMA_UTR0_TAGMAJ_SHIFT)
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UTR0_TAGMAJ_REPLACE_VAL(reg,val) (((reg) & ~OT_POGO_IDMA_POGO_IDMA_UDMA_UTR0_TAGMAJ_MASK) | (((uint32_t)val) << OT_POGO_IDMA_POGO_IDMA_UDMA_UTR0_TAGMAJ_SHIFT))

#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UTR0_TAGMID_MASK 0xffff
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UTR0_TAGMID_SHIFT 0
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UTR0_TAGMID_MASK_SHIFT(reg) (((reg) & OT_POGO_IDMA_POGO_IDMA_UDMA_UTR0_TAGMID_MASK) >> OT_POGO_IDMA_POGO_IDMA_UDMA_UTR0_TAGMID_SHIFT)
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UTR0_TAGMID_REPLACE_VAL(reg,val) (((reg) & ~OT_POGO_IDMA_POGO_IDMA_UDMA_UTR0_TAGMID_MASK) | (((uint32_t)val) << OT_POGO_IDMA_POGO_IDMA_UDMA_UTR0_TAGMID_SHIFT))

//====================================================================
//Register: UDMA Tag Register 1 (UTR1)
//====================================================================

#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UTR1_RESERVED1_MASK 0xffff0000
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UTR1_RESERVED1_SHIFT 16
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UTR1_RESERVED1_MASK_SHIFT(reg) (((reg) & OT_POGO_IDMA_POGO_IDMA_UDMA_UTR1_RESERVED1_MASK) >> OT_POGO_IDMA_POGO_IDMA_UDMA_UTR1_RESERVED1_SHIFT)
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UTR1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~OT_POGO_IDMA_POGO_IDMA_UDMA_UTR1_RESERVED1_MASK) | (((uint32_t)val) << OT_POGO_IDMA_POGO_IDMA_UDMA_UTR1_RESERVED1_SHIFT))

#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UTR1_TAGCFG_MASK 0xffff
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UTR1_TAGCFG_SHIFT 0
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UTR1_TAGCFG_MASK_SHIFT(reg) (((reg) & OT_POGO_IDMA_POGO_IDMA_UDMA_UTR1_TAGCFG_MASK) >> OT_POGO_IDMA_POGO_IDMA_UDMA_UTR1_TAGCFG_SHIFT)
#define  OT_POGO_IDMA_POGO_IDMA_UDMA_UTR1_TAGCFG_REPLACE_VAL(reg,val) (((reg) & ~OT_POGO_IDMA_POGO_IDMA_UDMA_UTR1_TAGCFG_MASK) | (((uint32_t)val) << OT_POGO_IDMA_POGO_IDMA_UDMA_UTR1_TAGCFG_SHIFT))

//====================================================================
//
//Register File: POGO_IDMA_CORE (OT_POGO_IDMA_POGO_IDMA_CORE)
//
//====================================================================

//====================================================================
//Register: IDMA Configuration Register (ICR)
//====================================================================

#define  OT_POGO_IDMA_POGO_IDMA_CORE_ICR_RESERVED1_MASK 0xfffffffc
#define  OT_POGO_IDMA_POGO_IDMA_CORE_ICR_RESERVED1_SHIFT 2
#define  OT_POGO_IDMA_POGO_IDMA_CORE_ICR_RESERVED1_MASK_SHIFT(reg) (((reg) & OT_POGO_IDMA_POGO_IDMA_CORE_ICR_RESERVED1_MASK) >> OT_POGO_IDMA_POGO_IDMA_CORE_ICR_RESERVED1_SHIFT)
#define  OT_POGO_IDMA_POGO_IDMA_CORE_ICR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~OT_POGO_IDMA_POGO_IDMA_CORE_ICR_RESERVED1_MASK) | (((uint32_t)val) << OT_POGO_IDMA_POGO_IDMA_CORE_ICR_RESERVED1_SHIFT))

#define  OT_POGO_IDMA_POGO_IDMA_CORE_ICR_BURSTSIZE_MASK 0x3
#define  OT_POGO_IDMA_POGO_IDMA_CORE_ICR_BURSTSIZE_SHIFT 0
#define  OT_POGO_IDMA_POGO_IDMA_CORE_ICR_BURSTSIZE_MASK_SHIFT(reg) (((reg) & OT_POGO_IDMA_POGO_IDMA_CORE_ICR_BURSTSIZE_MASK) >> OT_POGO_IDMA_POGO_IDMA_CORE_ICR_BURSTSIZE_SHIFT)
#define  OT_POGO_IDMA_POGO_IDMA_CORE_ICR_BURSTSIZE_REPLACE_VAL(reg,val) (((reg) & ~OT_POGO_IDMA_POGO_IDMA_CORE_ICR_BURSTSIZE_MASK) | (((uint32_t)val) << OT_POGO_IDMA_POGO_IDMA_CORE_ICR_BURSTSIZE_SHIFT))

//====================================================================
//Register: IDMA Interrupt Enable Register (IIER)
//====================================================================

#define  OT_POGO_IDMA_POGO_IDMA_CORE_IIER_RESERVED1_MASK 0xfffffffc
#define  OT_POGO_IDMA_POGO_IDMA_CORE_IIER_RESERVED1_SHIFT 2
#define  OT_POGO_IDMA_POGO_IDMA_CORE_IIER_RESERVED1_MASK_SHIFT(reg) (((reg) & OT_POGO_IDMA_POGO_IDMA_CORE_IIER_RESERVED1_MASK) >> OT_POGO_IDMA_POGO_IDMA_CORE_IIER_RESERVED1_SHIFT)
#define  OT_POGO_IDMA_POGO_IDMA_CORE_IIER_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~OT_POGO_IDMA_POGO_IDMA_CORE_IIER_RESERVED1_MASK) | (((uint32_t)val) << OT_POGO_IDMA_POGO_IDMA_CORE_IIER_RESERVED1_SHIFT))

#define  OT_POGO_IDMA_POGO_IDMA_CORE_IIER_LENGTHERR_MASK 0x2
#define  OT_POGO_IDMA_POGO_IDMA_CORE_IIER_LENGTHERR_SHIFT 1
#define  OT_POGO_IDMA_POGO_IDMA_CORE_IIER_LENGTHERR_MASK_SHIFT(reg) (((reg) & OT_POGO_IDMA_POGO_IDMA_CORE_IIER_LENGTHERR_MASK) >> OT_POGO_IDMA_POGO_IDMA_CORE_IIER_LENGTHERR_SHIFT)
#define  OT_POGO_IDMA_POGO_IDMA_CORE_IIER_LENGTHERR_REPLACE_VAL(reg,val) (((reg) & ~OT_POGO_IDMA_POGO_IDMA_CORE_IIER_LENGTHERR_MASK) | (((uint32_t)val) << OT_POGO_IDMA_POGO_IDMA_CORE_IIER_LENGTHERR_SHIFT))

#define  OT_POGO_IDMA_POGO_IDMA_CORE_IIER_EOS_MASK 0x1
#define  OT_POGO_IDMA_POGO_IDMA_CORE_IIER_EOS_SHIFT 0
#define  OT_POGO_IDMA_POGO_IDMA_CORE_IIER_EOS_MASK_SHIFT(reg) (((reg) & OT_POGO_IDMA_POGO_IDMA_CORE_IIER_EOS_MASK) >> OT_POGO_IDMA_POGO_IDMA_CORE_IIER_EOS_SHIFT)
#define  OT_POGO_IDMA_POGO_IDMA_CORE_IIER_EOS_REPLACE_VAL(reg,val) (((reg) & ~OT_POGO_IDMA_POGO_IDMA_CORE_IIER_EOS_MASK) | (((uint32_t)val) << OT_POGO_IDMA_POGO_IDMA_CORE_IIER_EOS_SHIFT))

//====================================================================
//Register: IDMA Interrupt Pending Register (IIPR)
//====================================================================

#define  OT_POGO_IDMA_POGO_IDMA_CORE_IIPR_RESERVED1_MASK 0xfffffffc
#define  OT_POGO_IDMA_POGO_IDMA_CORE_IIPR_RESERVED1_SHIFT 2
#define  OT_POGO_IDMA_POGO_IDMA_CORE_IIPR_RESERVED1_MASK_SHIFT(reg) (((reg) & OT_POGO_IDMA_POGO_IDMA_CORE_IIPR_RESERVED1_MASK) >> OT_POGO_IDMA_POGO_IDMA_CORE_IIPR_RESERVED1_SHIFT)
#define  OT_POGO_IDMA_POGO_IDMA_CORE_IIPR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~OT_POGO_IDMA_POGO_IDMA_CORE_IIPR_RESERVED1_MASK) | (((uint32_t)val) << OT_POGO_IDMA_POGO_IDMA_CORE_IIPR_RESERVED1_SHIFT))

#define  OT_POGO_IDMA_POGO_IDMA_CORE_IIPR_LENGTHERR_MASK 0x2
#define  OT_POGO_IDMA_POGO_IDMA_CORE_IIPR_LENGTHERR_SHIFT 1
#define  OT_POGO_IDMA_POGO_IDMA_CORE_IIPR_LENGTHERR_MASK_SHIFT(reg) (((reg) & OT_POGO_IDMA_POGO_IDMA_CORE_IIPR_LENGTHERR_MASK) >> OT_POGO_IDMA_POGO_IDMA_CORE_IIPR_LENGTHERR_SHIFT)
#define  OT_POGO_IDMA_POGO_IDMA_CORE_IIPR_LENGTHERR_REPLACE_VAL(reg,val) (((reg) & ~OT_POGO_IDMA_POGO_IDMA_CORE_IIPR_LENGTHERR_MASK) | (((uint32_t)val) << OT_POGO_IDMA_POGO_IDMA_CORE_IIPR_LENGTHERR_SHIFT))

#define  OT_POGO_IDMA_POGO_IDMA_CORE_IIPR_EOS_MASK 0x1
#define  OT_POGO_IDMA_POGO_IDMA_CORE_IIPR_EOS_SHIFT 0
#define  OT_POGO_IDMA_POGO_IDMA_CORE_IIPR_EOS_MASK_SHIFT(reg) (((reg) & OT_POGO_IDMA_POGO_IDMA_CORE_IIPR_EOS_MASK) >> OT_POGO_IDMA_POGO_IDMA_CORE_IIPR_EOS_SHIFT)
#define  OT_POGO_IDMA_POGO_IDMA_CORE_IIPR_EOS_REPLACE_VAL(reg,val) (((reg) & ~OT_POGO_IDMA_POGO_IDMA_CORE_IIPR_EOS_MASK) | (((uint32_t)val) << OT_POGO_IDMA_POGO_IDMA_CORE_IIPR_EOS_SHIFT))

//====================================================================
//Register: IDMA Interrupt Clear Register (IICR)
//====================================================================

#define  OT_POGO_IDMA_POGO_IDMA_CORE_IICR_RESERVED1_MASK 0xfffffffc
#define  OT_POGO_IDMA_POGO_IDMA_CORE_IICR_RESERVED1_SHIFT 2
#define  OT_POGO_IDMA_POGO_IDMA_CORE_IICR_RESERVED1_MASK_SHIFT(reg) (((reg) & OT_POGO_IDMA_POGO_IDMA_CORE_IICR_RESERVED1_MASK) >> OT_POGO_IDMA_POGO_IDMA_CORE_IICR_RESERVED1_SHIFT)
#define  OT_POGO_IDMA_POGO_IDMA_CORE_IICR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~OT_POGO_IDMA_POGO_IDMA_CORE_IICR_RESERVED1_MASK) | (((uint32_t)val) << OT_POGO_IDMA_POGO_IDMA_CORE_IICR_RESERVED1_SHIFT))

#define  OT_POGO_IDMA_POGO_IDMA_CORE_IICR_LENGTHERR_MASK 0x2
#define  OT_POGO_IDMA_POGO_IDMA_CORE_IICR_LENGTHERR_SHIFT 1
#define  OT_POGO_IDMA_POGO_IDMA_CORE_IICR_LENGTHERR_MASK_SHIFT(reg) (((reg) & OT_POGO_IDMA_POGO_IDMA_CORE_IICR_LENGTHERR_MASK) >> OT_POGO_IDMA_POGO_IDMA_CORE_IICR_LENGTHERR_SHIFT)
#define  OT_POGO_IDMA_POGO_IDMA_CORE_IICR_LENGTHERR_REPLACE_VAL(reg,val) (((reg) & ~OT_POGO_IDMA_POGO_IDMA_CORE_IICR_LENGTHERR_MASK) | (((uint32_t)val) << OT_POGO_IDMA_POGO_IDMA_CORE_IICR_LENGTHERR_SHIFT))

#define  OT_POGO_IDMA_POGO_IDMA_CORE_IICR_EOS_MASK 0x1
#define  OT_POGO_IDMA_POGO_IDMA_CORE_IICR_EOS_SHIFT 0
#define  OT_POGO_IDMA_POGO_IDMA_CORE_IICR_EOS_MASK_SHIFT(reg) (((reg) & OT_POGO_IDMA_POGO_IDMA_CORE_IICR_EOS_MASK) >> OT_POGO_IDMA_POGO_IDMA_CORE_IICR_EOS_SHIFT)
#define  OT_POGO_IDMA_POGO_IDMA_CORE_IICR_EOS_REPLACE_VAL(reg,val) (((reg) & ~OT_POGO_IDMA_POGO_IDMA_CORE_IICR_EOS_MASK) | (((uint32_t)val) << OT_POGO_IDMA_POGO_IDMA_CORE_IICR_EOS_SHIFT))

//====================================================================
//Register: IDMA Interrupt Force Register (IIFR)
//====================================================================

#define  OT_POGO_IDMA_POGO_IDMA_CORE_IIFR_RESERVED1_MASK 0xfffffffc
#define  OT_POGO_IDMA_POGO_IDMA_CORE_IIFR_RESERVED1_SHIFT 2
#define  OT_POGO_IDMA_POGO_IDMA_CORE_IIFR_RESERVED1_MASK_SHIFT(reg) (((reg) & OT_POGO_IDMA_POGO_IDMA_CORE_IIFR_RESERVED1_MASK) >> OT_POGO_IDMA_POGO_IDMA_CORE_IIFR_RESERVED1_SHIFT)
#define  OT_POGO_IDMA_POGO_IDMA_CORE_IIFR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~OT_POGO_IDMA_POGO_IDMA_CORE_IIFR_RESERVED1_MASK) | (((uint32_t)val) << OT_POGO_IDMA_POGO_IDMA_CORE_IIFR_RESERVED1_SHIFT))

#define  OT_POGO_IDMA_POGO_IDMA_CORE_IIFR_LENGTHERR_MASK 0x2
#define  OT_POGO_IDMA_POGO_IDMA_CORE_IIFR_LENGTHERR_SHIFT 1
#define  OT_POGO_IDMA_POGO_IDMA_CORE_IIFR_LENGTHERR_MASK_SHIFT(reg) (((reg) & OT_POGO_IDMA_POGO_IDMA_CORE_IIFR_LENGTHERR_MASK) >> OT_POGO_IDMA_POGO_IDMA_CORE_IIFR_LENGTHERR_SHIFT)
#define  OT_POGO_IDMA_POGO_IDMA_CORE_IIFR_LENGTHERR_REPLACE_VAL(reg,val) (((reg) & ~OT_POGO_IDMA_POGO_IDMA_CORE_IIFR_LENGTHERR_MASK) | (((uint32_t)val) << OT_POGO_IDMA_POGO_IDMA_CORE_IIFR_LENGTHERR_SHIFT))

#define  OT_POGO_IDMA_POGO_IDMA_CORE_IIFR_EOS_MASK 0x1
#define  OT_POGO_IDMA_POGO_IDMA_CORE_IIFR_EOS_SHIFT 0
#define  OT_POGO_IDMA_POGO_IDMA_CORE_IIFR_EOS_MASK_SHIFT(reg) (((reg) & OT_POGO_IDMA_POGO_IDMA_CORE_IIFR_EOS_MASK) >> OT_POGO_IDMA_POGO_IDMA_CORE_IIFR_EOS_SHIFT)
#define  OT_POGO_IDMA_POGO_IDMA_CORE_IIFR_EOS_REPLACE_VAL(reg,val) (((reg) & ~OT_POGO_IDMA_POGO_IDMA_CORE_IIFR_EOS_MASK) | (((uint32_t)val) << OT_POGO_IDMA_POGO_IDMA_CORE_IIFR_EOS_SHIFT))

//====================================================================
//Register: IDMA Line Width Register (ILWR)
//====================================================================

#define  OT_POGO_IDMA_POGO_IDMA_CORE_ILWR_RESERVED1_MASK 0xfff00000
#define  OT_POGO_IDMA_POGO_IDMA_CORE_ILWR_RESERVED1_SHIFT 20
#define  OT_POGO_IDMA_POGO_IDMA_CORE_ILWR_RESERVED1_MASK_SHIFT(reg) (((reg) & OT_POGO_IDMA_POGO_IDMA_CORE_ILWR_RESERVED1_MASK) >> OT_POGO_IDMA_POGO_IDMA_CORE_ILWR_RESERVED1_SHIFT)
#define  OT_POGO_IDMA_POGO_IDMA_CORE_ILWR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~OT_POGO_IDMA_POGO_IDMA_CORE_ILWR_RESERVED1_MASK) | (((uint32_t)val) << OT_POGO_IDMA_POGO_IDMA_CORE_ILWR_RESERVED1_SHIFT))

#define  OT_POGO_IDMA_POGO_IDMA_CORE_ILWR_LINEWIDTH_MASK 0xfffff
#define  OT_POGO_IDMA_POGO_IDMA_CORE_ILWR_LINEWIDTH_SHIFT 0
#define  OT_POGO_IDMA_POGO_IDMA_CORE_ILWR_LINEWIDTH_MASK_SHIFT(reg) (((reg) & OT_POGO_IDMA_POGO_IDMA_CORE_ILWR_LINEWIDTH_MASK) >> OT_POGO_IDMA_POGO_IDMA_CORE_ILWR_LINEWIDTH_SHIFT)
#define  OT_POGO_IDMA_POGO_IDMA_CORE_ILWR_LINEWIDTH_REPLACE_VAL(reg,val) (((reg) & ~OT_POGO_IDMA_POGO_IDMA_CORE_ILWR_LINEWIDTH_MASK) | (((uint32_t)val) << OT_POGO_IDMA_POGO_IDMA_CORE_ILWR_LINEWIDTH_SHIFT))

//====================================================================
//Register: IDMA Row Height Register (IRHR)
//====================================================================

#define  OT_POGO_IDMA_POGO_IDMA_CORE_IRHR_RESERVED1_MASK 0xffffffc0
#define  OT_POGO_IDMA_POGO_IDMA_CORE_IRHR_RESERVED1_SHIFT 6
#define  OT_POGO_IDMA_POGO_IDMA_CORE_IRHR_RESERVED1_MASK_SHIFT(reg) (((reg) & OT_POGO_IDMA_POGO_IDMA_CORE_IRHR_RESERVED1_MASK) >> OT_POGO_IDMA_POGO_IDMA_CORE_IRHR_RESERVED1_SHIFT)
#define  OT_POGO_IDMA_POGO_IDMA_CORE_IRHR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~OT_POGO_IDMA_POGO_IDMA_CORE_IRHR_RESERVED1_MASK) | (((uint32_t)val) << OT_POGO_IDMA_POGO_IDMA_CORE_IRHR_RESERVED1_SHIFT))

#define  OT_POGO_IDMA_POGO_IDMA_CORE_IRHR_ROWHEIGHT_MASK 0x3f
#define  OT_POGO_IDMA_POGO_IDMA_CORE_IRHR_ROWHEIGHT_SHIFT 0
#define  OT_POGO_IDMA_POGO_IDMA_CORE_IRHR_ROWHEIGHT_MASK_SHIFT(reg) (((reg) & OT_POGO_IDMA_POGO_IDMA_CORE_IRHR_ROWHEIGHT_MASK) >> OT_POGO_IDMA_POGO_IDMA_CORE_IRHR_ROWHEIGHT_SHIFT)
#define  OT_POGO_IDMA_POGO_IDMA_CORE_IRHR_ROWHEIGHT_REPLACE_VAL(reg,val) (((reg) & ~OT_POGO_IDMA_POGO_IDMA_CORE_IRHR_ROWHEIGHT_MASK) | (((uint32_t)val) << OT_POGO_IDMA_POGO_IDMA_CORE_IRHR_ROWHEIGHT_SHIFT))

//====================================================================
//Register: IDMA Tag Register 0 (ITR0)
//====================================================================

#define  OT_POGO_IDMA_POGO_IDMA_CORE_ITR0_RESERVED1_MASK 0xffff0000
#define  OT_POGO_IDMA_POGO_IDMA_CORE_ITR0_RESERVED1_SHIFT 16
#define  OT_POGO_IDMA_POGO_IDMA_CORE_ITR0_RESERVED1_MASK_SHIFT(reg) (((reg) & OT_POGO_IDMA_POGO_IDMA_CORE_ITR0_RESERVED1_MASK) >> OT_POGO_IDMA_POGO_IDMA_CORE_ITR0_RESERVED1_SHIFT)
#define  OT_POGO_IDMA_POGO_IDMA_CORE_ITR0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~OT_POGO_IDMA_POGO_IDMA_CORE_ITR0_RESERVED1_MASK) | (((uint32_t)val) << OT_POGO_IDMA_POGO_IDMA_CORE_ITR0_RESERVED1_SHIFT))

#define  OT_POGO_IDMA_POGO_IDMA_CORE_ITR0_TAGCFG_MASK 0xffff
#define  OT_POGO_IDMA_POGO_IDMA_CORE_ITR0_TAGCFG_SHIFT 0
#define  OT_POGO_IDMA_POGO_IDMA_CORE_ITR0_TAGCFG_MASK_SHIFT(reg) (((reg) & OT_POGO_IDMA_POGO_IDMA_CORE_ITR0_TAGCFG_MASK) >> OT_POGO_IDMA_POGO_IDMA_CORE_ITR0_TAGCFG_SHIFT)
#define  OT_POGO_IDMA_POGO_IDMA_CORE_ITR0_TAGCFG_REPLACE_VAL(reg,val) (((reg) & ~OT_POGO_IDMA_POGO_IDMA_CORE_ITR0_TAGCFG_MASK) | (((uint32_t)val) << OT_POGO_IDMA_POGO_IDMA_CORE_ITR0_TAGCFG_SHIFT))

//====================================================================
//Register: IDMA Tag Register 1 (ITR1)
//====================================================================

#define  OT_POGO_IDMA_POGO_IDMA_CORE_ITR1_RESERVED1_MASK 0xffff0000
#define  OT_POGO_IDMA_POGO_IDMA_CORE_ITR1_RESERVED1_SHIFT 16
#define  OT_POGO_IDMA_POGO_IDMA_CORE_ITR1_RESERVED1_MASK_SHIFT(reg) (((reg) & OT_POGO_IDMA_POGO_IDMA_CORE_ITR1_RESERVED1_MASK) >> OT_POGO_IDMA_POGO_IDMA_CORE_ITR1_RESERVED1_SHIFT)
#define  OT_POGO_IDMA_POGO_IDMA_CORE_ITR1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~OT_POGO_IDMA_POGO_IDMA_CORE_ITR1_RESERVED1_MASK) | (((uint32_t)val) << OT_POGO_IDMA_POGO_IDMA_CORE_ITR1_RESERVED1_SHIFT))

#define  OT_POGO_IDMA_POGO_IDMA_CORE_ITR1_TAGMAJ_MASK 0xffff
#define  OT_POGO_IDMA_POGO_IDMA_CORE_ITR1_TAGMAJ_SHIFT 0
#define  OT_POGO_IDMA_POGO_IDMA_CORE_ITR1_TAGMAJ_MASK_SHIFT(reg) (((reg) & OT_POGO_IDMA_POGO_IDMA_CORE_ITR1_TAGMAJ_MASK) >> OT_POGO_IDMA_POGO_IDMA_CORE_ITR1_TAGMAJ_SHIFT)
#define  OT_POGO_IDMA_POGO_IDMA_CORE_ITR1_TAGMAJ_REPLACE_VAL(reg,val) (((reg) & ~OT_POGO_IDMA_POGO_IDMA_CORE_ITR1_TAGMAJ_MASK) | (((uint32_t)val) << OT_POGO_IDMA_POGO_IDMA_CORE_ITR1_TAGMAJ_SHIFT))

//====================================================================
//Register: IDMA Tag Register 2 (ITR2)
//====================================================================

#define  OT_POGO_IDMA_POGO_IDMA_CORE_ITR2_RESERVED1_MASK 0xffff0000
#define  OT_POGO_IDMA_POGO_IDMA_CORE_ITR2_RESERVED1_SHIFT 16
#define  OT_POGO_IDMA_POGO_IDMA_CORE_ITR2_RESERVED1_MASK_SHIFT(reg) (((reg) & OT_POGO_IDMA_POGO_IDMA_CORE_ITR2_RESERVED1_MASK) >> OT_POGO_IDMA_POGO_IDMA_CORE_ITR2_RESERVED1_SHIFT)
#define  OT_POGO_IDMA_POGO_IDMA_CORE_ITR2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~OT_POGO_IDMA_POGO_IDMA_CORE_ITR2_RESERVED1_MASK) | (((uint32_t)val) << OT_POGO_IDMA_POGO_IDMA_CORE_ITR2_RESERVED1_SHIFT))

#define  OT_POGO_IDMA_POGO_IDMA_CORE_ITR2_TAGMID_MASK 0xffff
#define  OT_POGO_IDMA_POGO_IDMA_CORE_ITR2_TAGMID_SHIFT 0
#define  OT_POGO_IDMA_POGO_IDMA_CORE_ITR2_TAGMID_MASK_SHIFT(reg) (((reg) & OT_POGO_IDMA_POGO_IDMA_CORE_ITR2_TAGMID_MASK) >> OT_POGO_IDMA_POGO_IDMA_CORE_ITR2_TAGMID_SHIFT)
#define  OT_POGO_IDMA_POGO_IDMA_CORE_ITR2_TAGMID_REPLACE_VAL(reg,val) (((reg) & ~OT_POGO_IDMA_POGO_IDMA_CORE_ITR2_TAGMID_MASK) | (((uint32_t)val) << OT_POGO_IDMA_POGO_IDMA_CORE_ITR2_TAGMID_SHIFT))

//====================================================================
//
//Register File: POGO_ODMA_UDMA (POGO_ODMA_POGO_ODMA_UDMA)
//
//====================================================================

//====================================================================
//Register: UDMA Configuration Register (UCR)
//====================================================================

#define  POGO_ODMA_POGO_ODMA_UDMA_UCR_RESERVED1_MASK 0xfff00000
#define  POGO_ODMA_POGO_ODMA_UDMA_UCR_RESERVED1_SHIFT 20
#define  POGO_ODMA_POGO_ODMA_UDMA_UCR_RESERVED1_MASK_SHIFT(reg) (((reg) & POGO_ODMA_POGO_ODMA_UDMA_UCR_RESERVED1_MASK) >> POGO_ODMA_POGO_ODMA_UDMA_UCR_RESERVED1_SHIFT)
#define  POGO_ODMA_POGO_ODMA_UDMA_UCR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~POGO_ODMA_POGO_ODMA_UDMA_UCR_RESERVED1_MASK) | (((uint32_t)val) << POGO_ODMA_POGO_ODMA_UDMA_UCR_RESERVED1_SHIFT))

#define  POGO_ODMA_POGO_ODMA_UDMA_UCR_DATAAXCACHE_MASK 0xf0000
#define  POGO_ODMA_POGO_ODMA_UDMA_UCR_DATAAXCACHE_SHIFT 16
#define  POGO_ODMA_POGO_ODMA_UDMA_UCR_DATAAXCACHE_MASK_SHIFT(reg) (((reg) & POGO_ODMA_POGO_ODMA_UDMA_UCR_DATAAXCACHE_MASK) >> POGO_ODMA_POGO_ODMA_UDMA_UCR_DATAAXCACHE_SHIFT)
#define  POGO_ODMA_POGO_ODMA_UDMA_UCR_DATAAXCACHE_REPLACE_VAL(reg,val) (((reg) & ~POGO_ODMA_POGO_ODMA_UDMA_UCR_DATAAXCACHE_MASK) | (((uint32_t)val) << POGO_ODMA_POGO_ODMA_UDMA_UCR_DATAAXCACHE_SHIFT))

#define  POGO_ODMA_POGO_ODMA_UDMA_UCR_DESCARCACHE_MASK 0xf000
#define  POGO_ODMA_POGO_ODMA_UDMA_UCR_DESCARCACHE_SHIFT 12
#define  POGO_ODMA_POGO_ODMA_UDMA_UCR_DESCARCACHE_MASK_SHIFT(reg) (((reg) & POGO_ODMA_POGO_ODMA_UDMA_UCR_DESCARCACHE_MASK) >> POGO_ODMA_POGO_ODMA_UDMA_UCR_DESCARCACHE_SHIFT)
#define  POGO_ODMA_POGO_ODMA_UDMA_UCR_DESCARCACHE_REPLACE_VAL(reg,val) (((reg) & ~POGO_ODMA_POGO_ODMA_UDMA_UCR_DESCARCACHE_MASK) | (((uint32_t)val) << POGO_ODMA_POGO_ODMA_UDMA_UCR_DESCARCACHE_SHIFT))

#define  POGO_ODMA_POGO_ODMA_UDMA_UCR_DESCAWCACHE_MASK 0xf00
#define  POGO_ODMA_POGO_ODMA_UDMA_UCR_DESCAWCACHE_SHIFT 8
#define  POGO_ODMA_POGO_ODMA_UDMA_UCR_DESCAWCACHE_MASK_SHIFT(reg) (((reg) & POGO_ODMA_POGO_ODMA_UDMA_UCR_DESCAWCACHE_MASK) >> POGO_ODMA_POGO_ODMA_UDMA_UCR_DESCAWCACHE_SHIFT)
#define  POGO_ODMA_POGO_ODMA_UDMA_UCR_DESCAWCACHE_REPLACE_VAL(reg,val) (((reg) & ~POGO_ODMA_POGO_ODMA_UDMA_UCR_DESCAWCACHE_MASK) | (((uint32_t)val) << POGO_ODMA_POGO_ODMA_UDMA_UCR_DESCAWCACHE_SHIFT))

#define  POGO_ODMA_POGO_ODMA_UDMA_UCR_RESERVED2_MASK 0xc0
#define  POGO_ODMA_POGO_ODMA_UDMA_UCR_RESERVED2_SHIFT 6
#define  POGO_ODMA_POGO_ODMA_UDMA_UCR_RESERVED2_MASK_SHIFT(reg) (((reg) & POGO_ODMA_POGO_ODMA_UDMA_UCR_RESERVED2_MASK) >> POGO_ODMA_POGO_ODMA_UDMA_UCR_RESERVED2_SHIFT)
#define  POGO_ODMA_POGO_ODMA_UDMA_UCR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~POGO_ODMA_POGO_ODMA_UDMA_UCR_RESERVED2_MASK) | (((uint32_t)val) << POGO_ODMA_POGO_ODMA_UDMA_UCR_RESERVED2_SHIFT))

#define  POGO_ODMA_POGO_ODMA_UDMA_UCR_HANDSHAKEENABLE_MASK 0x20
#define  POGO_ODMA_POGO_ODMA_UDMA_UCR_HANDSHAKEENABLE_SHIFT 5
#define  POGO_ODMA_POGO_ODMA_UDMA_UCR_HANDSHAKEENABLE_MASK_SHIFT(reg) (((reg) & POGO_ODMA_POGO_ODMA_UDMA_UCR_HANDSHAKEENABLE_MASK) >> POGO_ODMA_POGO_ODMA_UDMA_UCR_HANDSHAKEENABLE_SHIFT)
#define  POGO_ODMA_POGO_ODMA_UDMA_UCR_HANDSHAKEENABLE_REPLACE_VAL(reg,val) (((reg) & ~POGO_ODMA_POGO_ODMA_UDMA_UCR_HANDSHAKEENABLE_MASK) | (((uint32_t)val) << POGO_ODMA_POGO_ODMA_UDMA_UCR_HANDSHAKEENABLE_SHIFT))

#define  POGO_ODMA_POGO_ODMA_UDMA_UCR_OWNWRITEDISABLE_MASK 0x10
#define  POGO_ODMA_POGO_ODMA_UDMA_UCR_OWNWRITEDISABLE_SHIFT 4
#define  POGO_ODMA_POGO_ODMA_UDMA_UCR_OWNWRITEDISABLE_MASK_SHIFT(reg) (((reg) & POGO_ODMA_POGO_ODMA_UDMA_UCR_OWNWRITEDISABLE_MASK) >> POGO_ODMA_POGO_ODMA_UDMA_UCR_OWNWRITEDISABLE_SHIFT)
#define  POGO_ODMA_POGO_ODMA_UDMA_UCR_OWNWRITEDISABLE_REPLACE_VAL(reg,val) (((reg) & ~POGO_ODMA_POGO_ODMA_UDMA_UCR_OWNWRITEDISABLE_MASK) | (((uint32_t)val) << POGO_ODMA_POGO_ODMA_UDMA_UCR_OWNWRITEDISABLE_SHIFT))

#define  POGO_ODMA_POGO_ODMA_UDMA_UCR_OWNPOLARITY_MASK 0x8
#define  POGO_ODMA_POGO_ODMA_UDMA_UCR_OWNPOLARITY_SHIFT 3
#define  POGO_ODMA_POGO_ODMA_UDMA_UCR_OWNPOLARITY_MASK_SHIFT(reg) (((reg) & POGO_ODMA_POGO_ODMA_UDMA_UCR_OWNPOLARITY_MASK) >> POGO_ODMA_POGO_ODMA_UDMA_UCR_OWNPOLARITY_SHIFT)
#define  POGO_ODMA_POGO_ODMA_UDMA_UCR_OWNPOLARITY_REPLACE_VAL(reg,val) (((reg) & ~POGO_ODMA_POGO_ODMA_UDMA_UCR_OWNPOLARITY_MASK) | (((uint32_t)val) << POGO_ODMA_POGO_ODMA_UDMA_UCR_OWNPOLARITY_SHIFT))

#define  POGO_ODMA_POGO_ODMA_UDMA_UCR_BEATS_MASK 0x6
#define  POGO_ODMA_POGO_ODMA_UDMA_UCR_BEATS_SHIFT 1
#define  POGO_ODMA_POGO_ODMA_UDMA_UCR_BEATS_MASK_SHIFT(reg) (((reg) & POGO_ODMA_POGO_ODMA_UDMA_UCR_BEATS_MASK) >> POGO_ODMA_POGO_ODMA_UDMA_UCR_BEATS_SHIFT)
#define  POGO_ODMA_POGO_ODMA_UDMA_UCR_BEATS_REPLACE_VAL(reg,val) (((reg) & ~POGO_ODMA_POGO_ODMA_UDMA_UCR_BEATS_MASK) | (((uint32_t)val) << POGO_ODMA_POGO_ODMA_UDMA_UCR_BEATS_SHIFT))

#define  POGO_ODMA_POGO_ODMA_UDMA_UCR_ENABLE_MASK 0x1
#define  POGO_ODMA_POGO_ODMA_UDMA_UCR_ENABLE_SHIFT 0
#define  POGO_ODMA_POGO_ODMA_UDMA_UCR_ENABLE_MASK_SHIFT(reg) (((reg) & POGO_ODMA_POGO_ODMA_UDMA_UCR_ENABLE_MASK) >> POGO_ODMA_POGO_ODMA_UDMA_UCR_ENABLE_SHIFT)
#define  POGO_ODMA_POGO_ODMA_UDMA_UCR_ENABLE_REPLACE_VAL(reg,val) (((reg) & ~POGO_ODMA_POGO_ODMA_UDMA_UCR_ENABLE_MASK) | (((uint32_t)val) << POGO_ODMA_POGO_ODMA_UDMA_UCR_ENABLE_SHIFT))

//====================================================================
//Register: UDMA Status Register (USR)
//====================================================================

#define  POGO_ODMA_POGO_ODMA_UDMA_USR_RESERVED1_MASK 0xfffff800
#define  POGO_ODMA_POGO_ODMA_UDMA_USR_RESERVED1_SHIFT 11
#define  POGO_ODMA_POGO_ODMA_UDMA_USR_RESERVED1_MASK_SHIFT(reg) (((reg) & POGO_ODMA_POGO_ODMA_UDMA_USR_RESERVED1_MASK) >> POGO_ODMA_POGO_ODMA_UDMA_USR_RESERVED1_SHIFT)
#define  POGO_ODMA_POGO_ODMA_UDMA_USR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~POGO_ODMA_POGO_ODMA_UDMA_USR_RESERVED1_MASK) | (((uint32_t)val) << POGO_ODMA_POGO_ODMA_UDMA_USR_RESERVED1_SHIFT))

#define  POGO_ODMA_POGO_ODMA_UDMA_USR_DMAPAUSED_MASK 0x400
#define  POGO_ODMA_POGO_ODMA_UDMA_USR_DMAPAUSED_SHIFT 10
#define  POGO_ODMA_POGO_ODMA_UDMA_USR_DMAPAUSED_MASK_SHIFT(reg) (((reg) & POGO_ODMA_POGO_ODMA_UDMA_USR_DMAPAUSED_MASK) >> POGO_ODMA_POGO_ODMA_UDMA_USR_DMAPAUSED_SHIFT)
#define  POGO_ODMA_POGO_ODMA_UDMA_USR_DMAPAUSED_REPLACE_VAL(reg,val) (((reg) & ~POGO_ODMA_POGO_ODMA_UDMA_USR_DMAPAUSED_MASK) | (((uint32_t)val) << POGO_ODMA_POGO_ODMA_UDMA_USR_DMAPAUSED_SHIFT))

#define  POGO_ODMA_POGO_ODMA_UDMA_USR_PAUSEAFTER_MASK 0x200
#define  POGO_ODMA_POGO_ODMA_UDMA_USR_PAUSEAFTER_SHIFT 9
#define  POGO_ODMA_POGO_ODMA_UDMA_USR_PAUSEAFTER_MASK_SHIFT(reg) (((reg) & POGO_ODMA_POGO_ODMA_UDMA_USR_PAUSEAFTER_MASK) >> POGO_ODMA_POGO_ODMA_UDMA_USR_PAUSEAFTER_SHIFT)
#define  POGO_ODMA_POGO_ODMA_UDMA_USR_PAUSEAFTER_REPLACE_VAL(reg,val) (((reg) & ~POGO_ODMA_POGO_ODMA_UDMA_USR_PAUSEAFTER_MASK) | (((uint32_t)val) << POGO_ODMA_POGO_ODMA_UDMA_USR_PAUSEAFTER_SHIFT))

#define  POGO_ODMA_POGO_ODMA_UDMA_USR_PAUSEBEFORE_MASK 0x100
#define  POGO_ODMA_POGO_ODMA_UDMA_USR_PAUSEBEFORE_SHIFT 8
#define  POGO_ODMA_POGO_ODMA_UDMA_USR_PAUSEBEFORE_MASK_SHIFT(reg) (((reg) & POGO_ODMA_POGO_ODMA_UDMA_USR_PAUSEBEFORE_MASK) >> POGO_ODMA_POGO_ODMA_UDMA_USR_PAUSEBEFORE_SHIFT)
#define  POGO_ODMA_POGO_ODMA_UDMA_USR_PAUSEBEFORE_REPLACE_VAL(reg,val) (((reg) & ~POGO_ODMA_POGO_ODMA_UDMA_USR_PAUSEBEFORE_MASK) | (((uint32_t)val) << POGO_ODMA_POGO_ODMA_UDMA_USR_PAUSEBEFORE_SHIFT))

#define  POGO_ODMA_POGO_ODMA_UDMA_USR_INTONFINISH_MASK 0x80
#define  POGO_ODMA_POGO_ODMA_UDMA_USR_INTONFINISH_SHIFT 7
#define  POGO_ODMA_POGO_ODMA_UDMA_USR_INTONFINISH_MASK_SHIFT(reg) (((reg) & POGO_ODMA_POGO_ODMA_UDMA_USR_INTONFINISH_MASK) >> POGO_ODMA_POGO_ODMA_UDMA_USR_INTONFINISH_SHIFT)
#define  POGO_ODMA_POGO_ODMA_UDMA_USR_INTONFINISH_REPLACE_VAL(reg,val) (((reg) & ~POGO_ODMA_POGO_ODMA_UDMA_USR_INTONFINISH_MASK) | (((uint32_t)val) << POGO_ODMA_POGO_ODMA_UDMA_USR_INTONFINISH_SHIFT))

#define  POGO_ODMA_POGO_ODMA_UDMA_USR_STOPONFINISH_MASK 0x40
#define  POGO_ODMA_POGO_ODMA_UDMA_USR_STOPONFINISH_SHIFT 6
#define  POGO_ODMA_POGO_ODMA_UDMA_USR_STOPONFINISH_MASK_SHIFT(reg) (((reg) & POGO_ODMA_POGO_ODMA_UDMA_USR_STOPONFINISH_MASK) >> POGO_ODMA_POGO_ODMA_UDMA_USR_STOPONFINISH_SHIFT)
#define  POGO_ODMA_POGO_ODMA_UDMA_USR_STOPONFINISH_REPLACE_VAL(reg,val) (((reg) & ~POGO_ODMA_POGO_ODMA_UDMA_USR_STOPONFINISH_MASK) | (((uint32_t)val) << POGO_ODMA_POGO_ODMA_UDMA_USR_STOPONFINISH_SHIFT))

#define  POGO_ODMA_POGO_ODMA_UDMA_USR_CMDBUFFULL_MASK 0x20
#define  POGO_ODMA_POGO_ODMA_UDMA_USR_CMDBUFFULL_SHIFT 5
#define  POGO_ODMA_POGO_ODMA_UDMA_USR_CMDBUFFULL_MASK_SHIFT(reg) (((reg) & POGO_ODMA_POGO_ODMA_UDMA_USR_CMDBUFFULL_MASK) >> POGO_ODMA_POGO_ODMA_UDMA_USR_CMDBUFFULL_SHIFT)
#define  POGO_ODMA_POGO_ODMA_UDMA_USR_CMDBUFFULL_REPLACE_VAL(reg,val) (((reg) & ~POGO_ODMA_POGO_ODMA_UDMA_USR_CMDBUFFULL_MASK) | (((uint32_t)val) << POGO_ODMA_POGO_ODMA_UDMA_USR_CMDBUFFULL_SHIFT))

#define  POGO_ODMA_POGO_ODMA_UDMA_USR_CMDBUFEMPTY_MASK 0x10
#define  POGO_ODMA_POGO_ODMA_UDMA_USR_CMDBUFEMPTY_SHIFT 4
#define  POGO_ODMA_POGO_ODMA_UDMA_USR_CMDBUFEMPTY_MASK_SHIFT(reg) (((reg) & POGO_ODMA_POGO_ODMA_UDMA_USR_CMDBUFEMPTY_MASK) >> POGO_ODMA_POGO_ODMA_UDMA_USR_CMDBUFEMPTY_SHIFT)
#define  POGO_ODMA_POGO_ODMA_UDMA_USR_CMDBUFEMPTY_REPLACE_VAL(reg,val) (((reg) & ~POGO_ODMA_POGO_ODMA_UDMA_USR_CMDBUFEMPTY_MASK) | (((uint32_t)val) << POGO_ODMA_POGO_ODMA_UDMA_USR_CMDBUFEMPTY_SHIFT))

#define  POGO_ODMA_POGO_ODMA_UDMA_USR_DATABUFFULL_MASK 0x8
#define  POGO_ODMA_POGO_ODMA_UDMA_USR_DATABUFFULL_SHIFT 3
#define  POGO_ODMA_POGO_ODMA_UDMA_USR_DATABUFFULL_MASK_SHIFT(reg) (((reg) & POGO_ODMA_POGO_ODMA_UDMA_USR_DATABUFFULL_MASK) >> POGO_ODMA_POGO_ODMA_UDMA_USR_DATABUFFULL_SHIFT)
#define  POGO_ODMA_POGO_ODMA_UDMA_USR_DATABUFFULL_REPLACE_VAL(reg,val) (((reg) & ~POGO_ODMA_POGO_ODMA_UDMA_USR_DATABUFFULL_MASK) | (((uint32_t)val) << POGO_ODMA_POGO_ODMA_UDMA_USR_DATABUFFULL_SHIFT))

#define  POGO_ODMA_POGO_ODMA_UDMA_USR_DATABUFEMPTY_MASK 0x4
#define  POGO_ODMA_POGO_ODMA_UDMA_USR_DATABUFEMPTY_SHIFT 2
#define  POGO_ODMA_POGO_ODMA_UDMA_USR_DATABUFEMPTY_MASK_SHIFT(reg) (((reg) & POGO_ODMA_POGO_ODMA_UDMA_USR_DATABUFEMPTY_MASK) >> POGO_ODMA_POGO_ODMA_UDMA_USR_DATABUFEMPTY_SHIFT)
#define  POGO_ODMA_POGO_ODMA_UDMA_USR_DATABUFEMPTY_REPLACE_VAL(reg,val) (((reg) & ~POGO_ODMA_POGO_ODMA_UDMA_USR_DATABUFEMPTY_MASK) | (((uint32_t)val) << POGO_ODMA_POGO_ODMA_UDMA_USR_DATABUFEMPTY_SHIFT))

#define  POGO_ODMA_POGO_ODMA_UDMA_USR_CLEAR_MASK 0x2
#define  POGO_ODMA_POGO_ODMA_UDMA_USR_CLEAR_SHIFT 1
#define  POGO_ODMA_POGO_ODMA_UDMA_USR_CLEAR_MASK_SHIFT(reg) (((reg) & POGO_ODMA_POGO_ODMA_UDMA_USR_CLEAR_MASK) >> POGO_ODMA_POGO_ODMA_UDMA_USR_CLEAR_SHIFT)
#define  POGO_ODMA_POGO_ODMA_UDMA_USR_CLEAR_REPLACE_VAL(reg,val) (((reg) & ~POGO_ODMA_POGO_ODMA_UDMA_USR_CLEAR_MASK) | (((uint32_t)val) << POGO_ODMA_POGO_ODMA_UDMA_USR_CLEAR_SHIFT))

#define  POGO_ODMA_POGO_ODMA_UDMA_USR_BUSY_MASK 0x1
#define  POGO_ODMA_POGO_ODMA_UDMA_USR_BUSY_SHIFT 0
#define  POGO_ODMA_POGO_ODMA_UDMA_USR_BUSY_MASK_SHIFT(reg) (((reg) & POGO_ODMA_POGO_ODMA_UDMA_USR_BUSY_MASK) >> POGO_ODMA_POGO_ODMA_UDMA_USR_BUSY_SHIFT)
#define  POGO_ODMA_POGO_ODMA_UDMA_USR_BUSY_REPLACE_VAL(reg,val) (((reg) & ~POGO_ODMA_POGO_ODMA_UDMA_USR_BUSY_MASK) | (((uint32_t)val) << POGO_ODMA_POGO_ODMA_UDMA_USR_BUSY_SHIFT))

//====================================================================
//Register: UDMA Parameter Register (UPR)
//====================================================================

#define  POGO_ODMA_POGO_ODMA_UDMA_UPR_RESERVED1_MASK 0xff000000
#define  POGO_ODMA_POGO_ODMA_UDMA_UPR_RESERVED1_SHIFT 24
#define  POGO_ODMA_POGO_ODMA_UDMA_UPR_RESERVED1_MASK_SHIFT(reg) (((reg) & POGO_ODMA_POGO_ODMA_UDMA_UPR_RESERVED1_MASK) >> POGO_ODMA_POGO_ODMA_UDMA_UPR_RESERVED1_SHIFT)
#define  POGO_ODMA_POGO_ODMA_UDMA_UPR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~POGO_ODMA_POGO_ODMA_UDMA_UPR_RESERVED1_MASK) | (((uint32_t)val) << POGO_ODMA_POGO_ODMA_UDMA_UPR_RESERVED1_SHIFT))

#define  POGO_ODMA_POGO_ODMA_UDMA_UPR_FIFODEPTH_MASK 0xffff00
#define  POGO_ODMA_POGO_ODMA_UDMA_UPR_FIFODEPTH_SHIFT 8
#define  POGO_ODMA_POGO_ODMA_UDMA_UPR_FIFODEPTH_MASK_SHIFT(reg) (((reg) & POGO_ODMA_POGO_ODMA_UDMA_UPR_FIFODEPTH_MASK) >> POGO_ODMA_POGO_ODMA_UDMA_UPR_FIFODEPTH_SHIFT)
#define  POGO_ODMA_POGO_ODMA_UDMA_UPR_FIFODEPTH_REPLACE_VAL(reg,val) (((reg) & ~POGO_ODMA_POGO_ODMA_UDMA_UPR_FIFODEPTH_MASK) | (((uint32_t)val) << POGO_ODMA_POGO_ODMA_UDMA_UPR_FIFODEPTH_SHIFT))

#define  POGO_ODMA_POGO_ODMA_UDMA_UPR_RESERVED2_MASK 0xe0
#define  POGO_ODMA_POGO_ODMA_UDMA_UPR_RESERVED2_SHIFT 5
#define  POGO_ODMA_POGO_ODMA_UDMA_UPR_RESERVED2_MASK_SHIFT(reg) (((reg) & POGO_ODMA_POGO_ODMA_UDMA_UPR_RESERVED2_MASK) >> POGO_ODMA_POGO_ODMA_UDMA_UPR_RESERVED2_SHIFT)
#define  POGO_ODMA_POGO_ODMA_UDMA_UPR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~POGO_ODMA_POGO_ODMA_UDMA_UPR_RESERVED2_MASK) | (((uint32_t)val) << POGO_ODMA_POGO_ODMA_UDMA_UPR_RESERVED2_SHIFT))

#define  POGO_ODMA_POGO_ODMA_UDMA_UPR_SERPSUPPORT_MASK 0x10
#define  POGO_ODMA_POGO_ODMA_UDMA_UPR_SERPSUPPORT_SHIFT 4
#define  POGO_ODMA_POGO_ODMA_UDMA_UPR_SERPSUPPORT_MASK_SHIFT(reg) (((reg) & POGO_ODMA_POGO_ODMA_UDMA_UPR_SERPSUPPORT_MASK) >> POGO_ODMA_POGO_ODMA_UDMA_UPR_SERPSUPPORT_SHIFT)
#define  POGO_ODMA_POGO_ODMA_UDMA_UPR_SERPSUPPORT_REPLACE_VAL(reg,val) (((reg) & ~POGO_ODMA_POGO_ODMA_UDMA_UPR_SERPSUPPORT_MASK) | (((uint32_t)val) << POGO_ODMA_POGO_ODMA_UDMA_UPR_SERPSUPPORT_SHIFT))

#define  POGO_ODMA_POGO_ODMA_UDMA_UPR_DESCLENGTH_MASK 0x8
#define  POGO_ODMA_POGO_ODMA_UDMA_UPR_DESCLENGTH_SHIFT 3
#define  POGO_ODMA_POGO_ODMA_UDMA_UPR_DESCLENGTH_MASK_SHIFT(reg) (((reg) & POGO_ODMA_POGO_ODMA_UDMA_UPR_DESCLENGTH_MASK) >> POGO_ODMA_POGO_ODMA_UDMA_UPR_DESCLENGTH_SHIFT)
#define  POGO_ODMA_POGO_ODMA_UDMA_UPR_DESCLENGTH_REPLACE_VAL(reg,val) (((reg) & ~POGO_ODMA_POGO_ODMA_UDMA_UPR_DESCLENGTH_MASK) | (((uint32_t)val) << POGO_ODMA_POGO_ODMA_UDMA_UPR_DESCLENGTH_SHIFT))

#define  POGO_ODMA_POGO_ODMA_UDMA_UPR_BUSWIDTH_MASK 0x4
#define  POGO_ODMA_POGO_ODMA_UDMA_UPR_BUSWIDTH_SHIFT 2
#define  POGO_ODMA_POGO_ODMA_UDMA_UPR_BUSWIDTH_MASK_SHIFT(reg) (((reg) & POGO_ODMA_POGO_ODMA_UDMA_UPR_BUSWIDTH_MASK) >> POGO_ODMA_POGO_ODMA_UDMA_UPR_BUSWIDTH_SHIFT)
#define  POGO_ODMA_POGO_ODMA_UDMA_UPR_BUSWIDTH_REPLACE_VAL(reg,val) (((reg) & ~POGO_ODMA_POGO_ODMA_UDMA_UPR_BUSWIDTH_MASK) | (((uint32_t)val) << POGO_ODMA_POGO_ODMA_UDMA_UPR_BUSWIDTH_SHIFT))

#define  POGO_ODMA_POGO_ODMA_UDMA_UPR_MEMALIGN_MASK 0x3
#define  POGO_ODMA_POGO_ODMA_UDMA_UPR_MEMALIGN_SHIFT 0
#define  POGO_ODMA_POGO_ODMA_UDMA_UPR_MEMALIGN_MASK_SHIFT(reg) (((reg) & POGO_ODMA_POGO_ODMA_UDMA_UPR_MEMALIGN_MASK) >> POGO_ODMA_POGO_ODMA_UDMA_UPR_MEMALIGN_SHIFT)
#define  POGO_ODMA_POGO_ODMA_UDMA_UPR_MEMALIGN_REPLACE_VAL(reg,val) (((reg) & ~POGO_ODMA_POGO_ODMA_UDMA_UPR_MEMALIGN_MASK) | (((uint32_t)val) << POGO_ODMA_POGO_ODMA_UDMA_UPR_MEMALIGN_SHIFT))

//====================================================================
//Register: UDMA Interrupt Enable Register (UIER)
//====================================================================

#define  POGO_ODMA_POGO_ODMA_UDMA_UIER_RESERVED1_MASK 0xffffffc0
#define  POGO_ODMA_POGO_ODMA_UDMA_UIER_RESERVED1_SHIFT 6
#define  POGO_ODMA_POGO_ODMA_UDMA_UIER_RESERVED1_MASK_SHIFT(reg) (((reg) & POGO_ODMA_POGO_ODMA_UDMA_UIER_RESERVED1_MASK) >> POGO_ODMA_POGO_ODMA_UDMA_UIER_RESERVED1_SHIFT)
#define  POGO_ODMA_POGO_ODMA_UDMA_UIER_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~POGO_ODMA_POGO_ODMA_UDMA_UIER_RESERVED1_MASK) | (((uint32_t)val) << POGO_ODMA_POGO_ODMA_UDMA_UIER_RESERVED1_SHIFT))

#define  POGO_ODMA_POGO_ODMA_UDMA_UIER_OUTOFRANGE_MASK 0x20
#define  POGO_ODMA_POGO_ODMA_UDMA_UIER_OUTOFRANGE_SHIFT 5
#define  POGO_ODMA_POGO_ODMA_UDMA_UIER_OUTOFRANGE_MASK_SHIFT(reg) (((reg) & POGO_ODMA_POGO_ODMA_UDMA_UIER_OUTOFRANGE_MASK) >> POGO_ODMA_POGO_ODMA_UDMA_UIER_OUTOFRANGE_SHIFT)
#define  POGO_ODMA_POGO_ODMA_UDMA_UIER_OUTOFRANGE_REPLACE_VAL(reg,val) (((reg) & ~POGO_ODMA_POGO_ODMA_UDMA_UIER_OUTOFRANGE_MASK) | (((uint32_t)val) << POGO_ODMA_POGO_ODMA_UDMA_UIER_OUTOFRANGE_SHIFT))

#define  POGO_ODMA_POGO_ODMA_UDMA_UIER_RRESP_MASK 0x10
#define  POGO_ODMA_POGO_ODMA_UDMA_UIER_RRESP_SHIFT 4
#define  POGO_ODMA_POGO_ODMA_UDMA_UIER_RRESP_MASK_SHIFT(reg) (((reg) & POGO_ODMA_POGO_ODMA_UDMA_UIER_RRESP_MASK) >> POGO_ODMA_POGO_ODMA_UDMA_UIER_RRESP_SHIFT)
#define  POGO_ODMA_POGO_ODMA_UDMA_UIER_RRESP_REPLACE_VAL(reg,val) (((reg) & ~POGO_ODMA_POGO_ODMA_UDMA_UIER_RRESP_MASK) | (((uint32_t)val) << POGO_ODMA_POGO_ODMA_UDMA_UIER_RRESP_SHIFT))

#define  POGO_ODMA_POGO_ODMA_UDMA_UIER_BRESP_MASK 0x8
#define  POGO_ODMA_POGO_ODMA_UDMA_UIER_BRESP_SHIFT 3
#define  POGO_ODMA_POGO_ODMA_UDMA_UIER_BRESP_MASK_SHIFT(reg) (((reg) & POGO_ODMA_POGO_ODMA_UDMA_UIER_BRESP_MASK) >> POGO_ODMA_POGO_ODMA_UDMA_UIER_BRESP_SHIFT)
#define  POGO_ODMA_POGO_ODMA_UDMA_UIER_BRESP_REPLACE_VAL(reg,val) (((reg) & ~POGO_ODMA_POGO_ODMA_UDMA_UIER_BRESP_MASK) | (((uint32_t)val) << POGO_ODMA_POGO_ODMA_UDMA_UIER_BRESP_SHIFT))

#define  POGO_ODMA_POGO_ODMA_UDMA_UIER_CLEARCOMPLETE_MASK 0x4
#define  POGO_ODMA_POGO_ODMA_UDMA_UIER_CLEARCOMPLETE_SHIFT 2
#define  POGO_ODMA_POGO_ODMA_UDMA_UIER_CLEARCOMPLETE_MASK_SHIFT(reg) (((reg) & POGO_ODMA_POGO_ODMA_UDMA_UIER_CLEARCOMPLETE_MASK) >> POGO_ODMA_POGO_ODMA_UDMA_UIER_CLEARCOMPLETE_SHIFT)
#define  POGO_ODMA_POGO_ODMA_UDMA_UIER_CLEARCOMPLETE_REPLACE_VAL(reg,val) (((reg) & ~POGO_ODMA_POGO_ODMA_UDMA_UIER_CLEARCOMPLETE_MASK) | (((uint32_t)val) << POGO_ODMA_POGO_ODMA_UDMA_UIER_CLEARCOMPLETE_SHIFT))

#define  POGO_ODMA_POGO_ODMA_UDMA_UIER_DESC_MASK 0x2
#define  POGO_ODMA_POGO_ODMA_UDMA_UIER_DESC_SHIFT 1
#define  POGO_ODMA_POGO_ODMA_UDMA_UIER_DESC_MASK_SHIFT(reg) (((reg) & POGO_ODMA_POGO_ODMA_UDMA_UIER_DESC_MASK) >> POGO_ODMA_POGO_ODMA_UDMA_UIER_DESC_SHIFT)
#define  POGO_ODMA_POGO_ODMA_UDMA_UIER_DESC_REPLACE_VAL(reg,val) (((reg) & ~POGO_ODMA_POGO_ODMA_UDMA_UIER_DESC_MASK) | (((uint32_t)val) << POGO_ODMA_POGO_ODMA_UDMA_UIER_DESC_SHIFT))

#define  POGO_ODMA_POGO_ODMA_UDMA_UIER_OWN_MASK 0x1
#define  POGO_ODMA_POGO_ODMA_UDMA_UIER_OWN_SHIFT 0
#define  POGO_ODMA_POGO_ODMA_UDMA_UIER_OWN_MASK_SHIFT(reg) (((reg) & POGO_ODMA_POGO_ODMA_UDMA_UIER_OWN_MASK) >> POGO_ODMA_POGO_ODMA_UDMA_UIER_OWN_SHIFT)
#define  POGO_ODMA_POGO_ODMA_UDMA_UIER_OWN_REPLACE_VAL(reg,val) (((reg) & ~POGO_ODMA_POGO_ODMA_UDMA_UIER_OWN_MASK) | (((uint32_t)val) << POGO_ODMA_POGO_ODMA_UDMA_UIER_OWN_SHIFT))

//====================================================================
//Register: UDMA Interrupt Pending Register (UIPR)
//====================================================================

#define  POGO_ODMA_POGO_ODMA_UDMA_UIPR_RESERVED1_MASK 0xffffffc0
#define  POGO_ODMA_POGO_ODMA_UDMA_UIPR_RESERVED1_SHIFT 6
#define  POGO_ODMA_POGO_ODMA_UDMA_UIPR_RESERVED1_MASK_SHIFT(reg) (((reg) & POGO_ODMA_POGO_ODMA_UDMA_UIPR_RESERVED1_MASK) >> POGO_ODMA_POGO_ODMA_UDMA_UIPR_RESERVED1_SHIFT)
#define  POGO_ODMA_POGO_ODMA_UDMA_UIPR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~POGO_ODMA_POGO_ODMA_UDMA_UIPR_RESERVED1_MASK) | (((uint32_t)val) << POGO_ODMA_POGO_ODMA_UDMA_UIPR_RESERVED1_SHIFT))

#define  POGO_ODMA_POGO_ODMA_UDMA_UIPR_OUTOFRANGE_MASK 0x20
#define  POGO_ODMA_POGO_ODMA_UDMA_UIPR_OUTOFRANGE_SHIFT 5
#define  POGO_ODMA_POGO_ODMA_UDMA_UIPR_OUTOFRANGE_MASK_SHIFT(reg) (((reg) & POGO_ODMA_POGO_ODMA_UDMA_UIPR_OUTOFRANGE_MASK) >> POGO_ODMA_POGO_ODMA_UDMA_UIPR_OUTOFRANGE_SHIFT)
#define  POGO_ODMA_POGO_ODMA_UDMA_UIPR_OUTOFRANGE_REPLACE_VAL(reg,val) (((reg) & ~POGO_ODMA_POGO_ODMA_UDMA_UIPR_OUTOFRANGE_MASK) | (((uint32_t)val) << POGO_ODMA_POGO_ODMA_UDMA_UIPR_OUTOFRANGE_SHIFT))

#define  POGO_ODMA_POGO_ODMA_UDMA_UIPR_RRESP_MASK 0x10
#define  POGO_ODMA_POGO_ODMA_UDMA_UIPR_RRESP_SHIFT 4
#define  POGO_ODMA_POGO_ODMA_UDMA_UIPR_RRESP_MASK_SHIFT(reg) (((reg) & POGO_ODMA_POGO_ODMA_UDMA_UIPR_RRESP_MASK) >> POGO_ODMA_POGO_ODMA_UDMA_UIPR_RRESP_SHIFT)
#define  POGO_ODMA_POGO_ODMA_UDMA_UIPR_RRESP_REPLACE_VAL(reg,val) (((reg) & ~POGO_ODMA_POGO_ODMA_UDMA_UIPR_RRESP_MASK) | (((uint32_t)val) << POGO_ODMA_POGO_ODMA_UDMA_UIPR_RRESP_SHIFT))

#define  POGO_ODMA_POGO_ODMA_UDMA_UIPR_BRESP_MASK 0x8
#define  POGO_ODMA_POGO_ODMA_UDMA_UIPR_BRESP_SHIFT 3
#define  POGO_ODMA_POGO_ODMA_UDMA_UIPR_BRESP_MASK_SHIFT(reg) (((reg) & POGO_ODMA_POGO_ODMA_UDMA_UIPR_BRESP_MASK) >> POGO_ODMA_POGO_ODMA_UDMA_UIPR_BRESP_SHIFT)
#define  POGO_ODMA_POGO_ODMA_UDMA_UIPR_BRESP_REPLACE_VAL(reg,val) (((reg) & ~POGO_ODMA_POGO_ODMA_UDMA_UIPR_BRESP_MASK) | (((uint32_t)val) << POGO_ODMA_POGO_ODMA_UDMA_UIPR_BRESP_SHIFT))

#define  POGO_ODMA_POGO_ODMA_UDMA_UIPR_CLEARCOMPLETE_MASK 0x4
#define  POGO_ODMA_POGO_ODMA_UDMA_UIPR_CLEARCOMPLETE_SHIFT 2
#define  POGO_ODMA_POGO_ODMA_UDMA_UIPR_CLEARCOMPLETE_MASK_SHIFT(reg) (((reg) & POGO_ODMA_POGO_ODMA_UDMA_UIPR_CLEARCOMPLETE_MASK) >> POGO_ODMA_POGO_ODMA_UDMA_UIPR_CLEARCOMPLETE_SHIFT)
#define  POGO_ODMA_POGO_ODMA_UDMA_UIPR_CLEARCOMPLETE_REPLACE_VAL(reg,val) (((reg) & ~POGO_ODMA_POGO_ODMA_UDMA_UIPR_CLEARCOMPLETE_MASK) | (((uint32_t)val) << POGO_ODMA_POGO_ODMA_UDMA_UIPR_CLEARCOMPLETE_SHIFT))

#define  POGO_ODMA_POGO_ODMA_UDMA_UIPR_DESC_MASK 0x2
#define  POGO_ODMA_POGO_ODMA_UDMA_UIPR_DESC_SHIFT 1
#define  POGO_ODMA_POGO_ODMA_UDMA_UIPR_DESC_MASK_SHIFT(reg) (((reg) & POGO_ODMA_POGO_ODMA_UDMA_UIPR_DESC_MASK) >> POGO_ODMA_POGO_ODMA_UDMA_UIPR_DESC_SHIFT)
#define  POGO_ODMA_POGO_ODMA_UDMA_UIPR_DESC_REPLACE_VAL(reg,val) (((reg) & ~POGO_ODMA_POGO_ODMA_UDMA_UIPR_DESC_MASK) | (((uint32_t)val) << POGO_ODMA_POGO_ODMA_UDMA_UIPR_DESC_SHIFT))

#define  POGO_ODMA_POGO_ODMA_UDMA_UIPR_OWN_MASK 0x1
#define  POGO_ODMA_POGO_ODMA_UDMA_UIPR_OWN_SHIFT 0
#define  POGO_ODMA_POGO_ODMA_UDMA_UIPR_OWN_MASK_SHIFT(reg) (((reg) & POGO_ODMA_POGO_ODMA_UDMA_UIPR_OWN_MASK) >> POGO_ODMA_POGO_ODMA_UDMA_UIPR_OWN_SHIFT)
#define  POGO_ODMA_POGO_ODMA_UDMA_UIPR_OWN_REPLACE_VAL(reg,val) (((reg) & ~POGO_ODMA_POGO_ODMA_UDMA_UIPR_OWN_MASK) | (((uint32_t)val) << POGO_ODMA_POGO_ODMA_UDMA_UIPR_OWN_SHIFT))

//====================================================================
//Register: UDMA Interrupt Clear Register (UICR)
//====================================================================

#define  POGO_ODMA_POGO_ODMA_UDMA_UICR_RESERVED1_MASK 0xffffffc0
#define  POGO_ODMA_POGO_ODMA_UDMA_UICR_RESERVED1_SHIFT 6
#define  POGO_ODMA_POGO_ODMA_UDMA_UICR_RESERVED1_MASK_SHIFT(reg) (((reg) & POGO_ODMA_POGO_ODMA_UDMA_UICR_RESERVED1_MASK) >> POGO_ODMA_POGO_ODMA_UDMA_UICR_RESERVED1_SHIFT)
#define  POGO_ODMA_POGO_ODMA_UDMA_UICR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~POGO_ODMA_POGO_ODMA_UDMA_UICR_RESERVED1_MASK) | (((uint32_t)val) << POGO_ODMA_POGO_ODMA_UDMA_UICR_RESERVED1_SHIFT))

#define  POGO_ODMA_POGO_ODMA_UDMA_UICR_OUTOFRANGE_MASK 0x20
#define  POGO_ODMA_POGO_ODMA_UDMA_UICR_OUTOFRANGE_SHIFT 5
#define  POGO_ODMA_POGO_ODMA_UDMA_UICR_OUTOFRANGE_MASK_SHIFT(reg) (((reg) & POGO_ODMA_POGO_ODMA_UDMA_UICR_OUTOFRANGE_MASK) >> POGO_ODMA_POGO_ODMA_UDMA_UICR_OUTOFRANGE_SHIFT)
#define  POGO_ODMA_POGO_ODMA_UDMA_UICR_OUTOFRANGE_REPLACE_VAL(reg,val) (((reg) & ~POGO_ODMA_POGO_ODMA_UDMA_UICR_OUTOFRANGE_MASK) | (((uint32_t)val) << POGO_ODMA_POGO_ODMA_UDMA_UICR_OUTOFRANGE_SHIFT))

#define  POGO_ODMA_POGO_ODMA_UDMA_UICR_RRESP_MASK 0x10
#define  POGO_ODMA_POGO_ODMA_UDMA_UICR_RRESP_SHIFT 4
#define  POGO_ODMA_POGO_ODMA_UDMA_UICR_RRESP_MASK_SHIFT(reg) (((reg) & POGO_ODMA_POGO_ODMA_UDMA_UICR_RRESP_MASK) >> POGO_ODMA_POGO_ODMA_UDMA_UICR_RRESP_SHIFT)
#define  POGO_ODMA_POGO_ODMA_UDMA_UICR_RRESP_REPLACE_VAL(reg,val) (((reg) & ~POGO_ODMA_POGO_ODMA_UDMA_UICR_RRESP_MASK) | (((uint32_t)val) << POGO_ODMA_POGO_ODMA_UDMA_UICR_RRESP_SHIFT))

#define  POGO_ODMA_POGO_ODMA_UDMA_UICR_BRESP_MASK 0x8
#define  POGO_ODMA_POGO_ODMA_UDMA_UICR_BRESP_SHIFT 3
#define  POGO_ODMA_POGO_ODMA_UDMA_UICR_BRESP_MASK_SHIFT(reg) (((reg) & POGO_ODMA_POGO_ODMA_UDMA_UICR_BRESP_MASK) >> POGO_ODMA_POGO_ODMA_UDMA_UICR_BRESP_SHIFT)
#define  POGO_ODMA_POGO_ODMA_UDMA_UICR_BRESP_REPLACE_VAL(reg,val) (((reg) & ~POGO_ODMA_POGO_ODMA_UDMA_UICR_BRESP_MASK) | (((uint32_t)val) << POGO_ODMA_POGO_ODMA_UDMA_UICR_BRESP_SHIFT))

#define  POGO_ODMA_POGO_ODMA_UDMA_UICR_CLEARCOMPLETE_MASK 0x4
#define  POGO_ODMA_POGO_ODMA_UDMA_UICR_CLEARCOMPLETE_SHIFT 2
#define  POGO_ODMA_POGO_ODMA_UDMA_UICR_CLEARCOMPLETE_MASK_SHIFT(reg) (((reg) & POGO_ODMA_POGO_ODMA_UDMA_UICR_CLEARCOMPLETE_MASK) >> POGO_ODMA_POGO_ODMA_UDMA_UICR_CLEARCOMPLETE_SHIFT)
#define  POGO_ODMA_POGO_ODMA_UDMA_UICR_CLEARCOMPLETE_REPLACE_VAL(reg,val) (((reg) & ~POGO_ODMA_POGO_ODMA_UDMA_UICR_CLEARCOMPLETE_MASK) | (((uint32_t)val) << POGO_ODMA_POGO_ODMA_UDMA_UICR_CLEARCOMPLETE_SHIFT))

#define  POGO_ODMA_POGO_ODMA_UDMA_UICR_DESC_MASK 0x2
#define  POGO_ODMA_POGO_ODMA_UDMA_UICR_DESC_SHIFT 1
#define  POGO_ODMA_POGO_ODMA_UDMA_UICR_DESC_MASK_SHIFT(reg) (((reg) & POGO_ODMA_POGO_ODMA_UDMA_UICR_DESC_MASK) >> POGO_ODMA_POGO_ODMA_UDMA_UICR_DESC_SHIFT)
#define  POGO_ODMA_POGO_ODMA_UDMA_UICR_DESC_REPLACE_VAL(reg,val) (((reg) & ~POGO_ODMA_POGO_ODMA_UDMA_UICR_DESC_MASK) | (((uint32_t)val) << POGO_ODMA_POGO_ODMA_UDMA_UICR_DESC_SHIFT))

#define  POGO_ODMA_POGO_ODMA_UDMA_UICR_OWN_MASK 0x1
#define  POGO_ODMA_POGO_ODMA_UDMA_UICR_OWN_SHIFT 0
#define  POGO_ODMA_POGO_ODMA_UDMA_UICR_OWN_MASK_SHIFT(reg) (((reg) & POGO_ODMA_POGO_ODMA_UDMA_UICR_OWN_MASK) >> POGO_ODMA_POGO_ODMA_UDMA_UICR_OWN_SHIFT)
#define  POGO_ODMA_POGO_ODMA_UDMA_UICR_OWN_REPLACE_VAL(reg,val) (((reg) & ~POGO_ODMA_POGO_ODMA_UDMA_UICR_OWN_MASK) | (((uint32_t)val) << POGO_ODMA_POGO_ODMA_UDMA_UICR_OWN_SHIFT))

//====================================================================
//Register: UDMA Interrupt Force Register (UIFR)
//====================================================================

#define  POGO_ODMA_POGO_ODMA_UDMA_UIFR_RESERVED1_MASK 0xffffffc0
#define  POGO_ODMA_POGO_ODMA_UDMA_UIFR_RESERVED1_SHIFT 6
#define  POGO_ODMA_POGO_ODMA_UDMA_UIFR_RESERVED1_MASK_SHIFT(reg) (((reg) & POGO_ODMA_POGO_ODMA_UDMA_UIFR_RESERVED1_MASK) >> POGO_ODMA_POGO_ODMA_UDMA_UIFR_RESERVED1_SHIFT)
#define  POGO_ODMA_POGO_ODMA_UDMA_UIFR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~POGO_ODMA_POGO_ODMA_UDMA_UIFR_RESERVED1_MASK) | (((uint32_t)val) << POGO_ODMA_POGO_ODMA_UDMA_UIFR_RESERVED1_SHIFT))

#define  POGO_ODMA_POGO_ODMA_UDMA_UIFR_OUTOFRANGE_MASK 0x20
#define  POGO_ODMA_POGO_ODMA_UDMA_UIFR_OUTOFRANGE_SHIFT 5
#define  POGO_ODMA_POGO_ODMA_UDMA_UIFR_OUTOFRANGE_MASK_SHIFT(reg) (((reg) & POGO_ODMA_POGO_ODMA_UDMA_UIFR_OUTOFRANGE_MASK) >> POGO_ODMA_POGO_ODMA_UDMA_UIFR_OUTOFRANGE_SHIFT)
#define  POGO_ODMA_POGO_ODMA_UDMA_UIFR_OUTOFRANGE_REPLACE_VAL(reg,val) (((reg) & ~POGO_ODMA_POGO_ODMA_UDMA_UIFR_OUTOFRANGE_MASK) | (((uint32_t)val) << POGO_ODMA_POGO_ODMA_UDMA_UIFR_OUTOFRANGE_SHIFT))

#define  POGO_ODMA_POGO_ODMA_UDMA_UIFR_RRESP_MASK 0x10
#define  POGO_ODMA_POGO_ODMA_UDMA_UIFR_RRESP_SHIFT 4
#define  POGO_ODMA_POGO_ODMA_UDMA_UIFR_RRESP_MASK_SHIFT(reg) (((reg) & POGO_ODMA_POGO_ODMA_UDMA_UIFR_RRESP_MASK) >> POGO_ODMA_POGO_ODMA_UDMA_UIFR_RRESP_SHIFT)
#define  POGO_ODMA_POGO_ODMA_UDMA_UIFR_RRESP_REPLACE_VAL(reg,val) (((reg) & ~POGO_ODMA_POGO_ODMA_UDMA_UIFR_RRESP_MASK) | (((uint32_t)val) << POGO_ODMA_POGO_ODMA_UDMA_UIFR_RRESP_SHIFT))

#define  POGO_ODMA_POGO_ODMA_UDMA_UIFR_BRESP_MASK 0x8
#define  POGO_ODMA_POGO_ODMA_UDMA_UIFR_BRESP_SHIFT 3
#define  POGO_ODMA_POGO_ODMA_UDMA_UIFR_BRESP_MASK_SHIFT(reg) (((reg) & POGO_ODMA_POGO_ODMA_UDMA_UIFR_BRESP_MASK) >> POGO_ODMA_POGO_ODMA_UDMA_UIFR_BRESP_SHIFT)
#define  POGO_ODMA_POGO_ODMA_UDMA_UIFR_BRESP_REPLACE_VAL(reg,val) (((reg) & ~POGO_ODMA_POGO_ODMA_UDMA_UIFR_BRESP_MASK) | (((uint32_t)val) << POGO_ODMA_POGO_ODMA_UDMA_UIFR_BRESP_SHIFT))

#define  POGO_ODMA_POGO_ODMA_UDMA_UIFR_CLEARCOMPLETE_MASK 0x4
#define  POGO_ODMA_POGO_ODMA_UDMA_UIFR_CLEARCOMPLETE_SHIFT 2
#define  POGO_ODMA_POGO_ODMA_UDMA_UIFR_CLEARCOMPLETE_MASK_SHIFT(reg) (((reg) & POGO_ODMA_POGO_ODMA_UDMA_UIFR_CLEARCOMPLETE_MASK) >> POGO_ODMA_POGO_ODMA_UDMA_UIFR_CLEARCOMPLETE_SHIFT)
#define  POGO_ODMA_POGO_ODMA_UDMA_UIFR_CLEARCOMPLETE_REPLACE_VAL(reg,val) (((reg) & ~POGO_ODMA_POGO_ODMA_UDMA_UIFR_CLEARCOMPLETE_MASK) | (((uint32_t)val) << POGO_ODMA_POGO_ODMA_UDMA_UIFR_CLEARCOMPLETE_SHIFT))

#define  POGO_ODMA_POGO_ODMA_UDMA_UIFR_DESC_MASK 0x2
#define  POGO_ODMA_POGO_ODMA_UDMA_UIFR_DESC_SHIFT 1
#define  POGO_ODMA_POGO_ODMA_UDMA_UIFR_DESC_MASK_SHIFT(reg) (((reg) & POGO_ODMA_POGO_ODMA_UDMA_UIFR_DESC_MASK) >> POGO_ODMA_POGO_ODMA_UDMA_UIFR_DESC_SHIFT)
#define  POGO_ODMA_POGO_ODMA_UDMA_UIFR_DESC_REPLACE_VAL(reg,val) (((reg) & ~POGO_ODMA_POGO_ODMA_UDMA_UIFR_DESC_MASK) | (((uint32_t)val) << POGO_ODMA_POGO_ODMA_UDMA_UIFR_DESC_SHIFT))

#define  POGO_ODMA_POGO_ODMA_UDMA_UIFR_OWN_MASK 0x1
#define  POGO_ODMA_POGO_ODMA_UDMA_UIFR_OWN_SHIFT 0
#define  POGO_ODMA_POGO_ODMA_UDMA_UIFR_OWN_MASK_SHIFT(reg) (((reg) & POGO_ODMA_POGO_ODMA_UDMA_UIFR_OWN_MASK) >> POGO_ODMA_POGO_ODMA_UDMA_UIFR_OWN_SHIFT)
#define  POGO_ODMA_POGO_ODMA_UDMA_UIFR_OWN_REPLACE_VAL(reg,val) (((reg) & ~POGO_ODMA_POGO_ODMA_UDMA_UIFR_OWN_MASK) | (((uint32_t)val) << POGO_ODMA_POGO_ODMA_UDMA_UIFR_OWN_SHIFT))

//====================================================================
//Register: UDMA Descriptor Register (UDR)
//====================================================================

#define  POGO_ODMA_POGO_ODMA_UDMA_UDR_DESC_MASK 0xffffffff
#define  POGO_ODMA_POGO_ODMA_UDMA_UDR_DESC_SHIFT 0
#define  POGO_ODMA_POGO_ODMA_UDMA_UDR_DESC_MASK_SHIFT(reg) (((reg) & POGO_ODMA_POGO_ODMA_UDMA_UDR_DESC_MASK) >> POGO_ODMA_POGO_ODMA_UDMA_UDR_DESC_SHIFT)
#define  POGO_ODMA_POGO_ODMA_UDMA_UDR_DESC_REPLACE_VAL(reg,val) (((reg) & ~POGO_ODMA_POGO_ODMA_UDMA_UDR_DESC_MASK) | (((uint32_t)val) << POGO_ODMA_POGO_ODMA_UDMA_UDR_DESC_SHIFT))

//====================================================================
//Register: UDMA Burst Address Register (UBAR)
//====================================================================

#define  POGO_ODMA_POGO_ODMA_UDMA_UBAR_BURSTADDR_MASK 0xffffffff
#define  POGO_ODMA_POGO_ODMA_UDMA_UBAR_BURSTADDR_SHIFT 0
#define  POGO_ODMA_POGO_ODMA_UDMA_UBAR_BURSTADDR_MASK_SHIFT(reg) (((reg) & POGO_ODMA_POGO_ODMA_UDMA_UBAR_BURSTADDR_MASK) >> POGO_ODMA_POGO_ODMA_UDMA_UBAR_BURSTADDR_SHIFT)
#define  POGO_ODMA_POGO_ODMA_UDMA_UBAR_BURSTADDR_REPLACE_VAL(reg,val) (((reg) & ~POGO_ODMA_POGO_ODMA_UDMA_UBAR_BURSTADDR_MASK) | (((uint32_t)val) << POGO_ODMA_POGO_ODMA_UDMA_UBAR_BURSTADDR_SHIFT))

//====================================================================
//Register: UDMA Burst Length Register (UBLR)
//====================================================================

#define  POGO_ODMA_POGO_ODMA_UDMA_UBLR_RESERVED1_MASK 0xfffffc00
#define  POGO_ODMA_POGO_ODMA_UDMA_UBLR_RESERVED1_SHIFT 10
#define  POGO_ODMA_POGO_ODMA_UDMA_UBLR_RESERVED1_MASK_SHIFT(reg) (((reg) & POGO_ODMA_POGO_ODMA_UDMA_UBLR_RESERVED1_MASK) >> POGO_ODMA_POGO_ODMA_UDMA_UBLR_RESERVED1_SHIFT)
#define  POGO_ODMA_POGO_ODMA_UDMA_UBLR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~POGO_ODMA_POGO_ODMA_UDMA_UBLR_RESERVED1_MASK) | (((uint32_t)val) << POGO_ODMA_POGO_ODMA_UDMA_UBLR_RESERVED1_SHIFT))

#define  POGO_ODMA_POGO_ODMA_UDMA_UBLR_BURSTDIR_MASK 0x200
#define  POGO_ODMA_POGO_ODMA_UDMA_UBLR_BURSTDIR_SHIFT 9
#define  POGO_ODMA_POGO_ODMA_UDMA_UBLR_BURSTDIR_MASK_SHIFT(reg) (((reg) & POGO_ODMA_POGO_ODMA_UDMA_UBLR_BURSTDIR_MASK) >> POGO_ODMA_POGO_ODMA_UDMA_UBLR_BURSTDIR_SHIFT)
#define  POGO_ODMA_POGO_ODMA_UDMA_UBLR_BURSTDIR_REPLACE_VAL(reg,val) (((reg) & ~POGO_ODMA_POGO_ODMA_UDMA_UBLR_BURSTDIR_MASK) | (((uint32_t)val) << POGO_ODMA_POGO_ODMA_UDMA_UBLR_BURSTDIR_SHIFT))

#define  POGO_ODMA_POGO_ODMA_UDMA_UBLR_BURSTLAST_MASK 0x100
#define  POGO_ODMA_POGO_ODMA_UDMA_UBLR_BURSTLAST_SHIFT 8
#define  POGO_ODMA_POGO_ODMA_UDMA_UBLR_BURSTLAST_MASK_SHIFT(reg) (((reg) & POGO_ODMA_POGO_ODMA_UDMA_UBLR_BURSTLAST_MASK) >> POGO_ODMA_POGO_ODMA_UDMA_UBLR_BURSTLAST_SHIFT)
#define  POGO_ODMA_POGO_ODMA_UDMA_UBLR_BURSTLAST_REPLACE_VAL(reg,val) (((reg) & ~POGO_ODMA_POGO_ODMA_UDMA_UBLR_BURSTLAST_MASK) | (((uint32_t)val) << POGO_ODMA_POGO_ODMA_UDMA_UBLR_BURSTLAST_SHIFT))

#define  POGO_ODMA_POGO_ODMA_UDMA_UBLR_BURSTLENGTH_MASK 0xff
#define  POGO_ODMA_POGO_ODMA_UDMA_UBLR_BURSTLENGTH_SHIFT 0
#define  POGO_ODMA_POGO_ODMA_UDMA_UBLR_BURSTLENGTH_MASK_SHIFT(reg) (((reg) & POGO_ODMA_POGO_ODMA_UDMA_UBLR_BURSTLENGTH_MASK) >> POGO_ODMA_POGO_ODMA_UDMA_UBLR_BURSTLENGTH_SHIFT)
#define  POGO_ODMA_POGO_ODMA_UDMA_UBLR_BURSTLENGTH_REPLACE_VAL(reg,val) (((reg) & ~POGO_ODMA_POGO_ODMA_UDMA_UBLR_BURSTLENGTH_MASK) | (((uint32_t)val) << POGO_ODMA_POGO_ODMA_UDMA_UBLR_BURSTLENGTH_SHIFT))

//====================================================================
//Register: UDMA Transfer Bytes Remaining Register (UBRR)
//====================================================================

#define  POGO_ODMA_POGO_ODMA_UDMA_UBRR_BYTESREMAIN_MASK 0xffffffff
#define  POGO_ODMA_POGO_ODMA_UDMA_UBRR_BYTESREMAIN_SHIFT 0
#define  POGO_ODMA_POGO_ODMA_UDMA_UBRR_BYTESREMAIN_MASK_SHIFT(reg) (((reg) & POGO_ODMA_POGO_ODMA_UDMA_UBRR_BYTESREMAIN_MASK) >> POGO_ODMA_POGO_ODMA_UDMA_UBRR_BYTESREMAIN_SHIFT)
#define  POGO_ODMA_POGO_ODMA_UDMA_UBRR_BYTESREMAIN_REPLACE_VAL(reg,val) (((reg) & ~POGO_ODMA_POGO_ODMA_UDMA_UBRR_BYTESREMAIN_MASK) | (((uint32_t)val) << POGO_ODMA_POGO_ODMA_UDMA_UBRR_BYTESREMAIN_SHIFT))

//====================================================================
//Register: UDMA Tag Register 0 (UTR0)
//====================================================================

#define  POGO_ODMA_POGO_ODMA_UDMA_UTR0_TAGMAJ_MASK 0xffff0000
#define  POGO_ODMA_POGO_ODMA_UDMA_UTR0_TAGMAJ_SHIFT 16
#define  POGO_ODMA_POGO_ODMA_UDMA_UTR0_TAGMAJ_MASK_SHIFT(reg) (((reg) & POGO_ODMA_POGO_ODMA_UDMA_UTR0_TAGMAJ_MASK) >> POGO_ODMA_POGO_ODMA_UDMA_UTR0_TAGMAJ_SHIFT)
#define  POGO_ODMA_POGO_ODMA_UDMA_UTR0_TAGMAJ_REPLACE_VAL(reg,val) (((reg) & ~POGO_ODMA_POGO_ODMA_UDMA_UTR0_TAGMAJ_MASK) | (((uint32_t)val) << POGO_ODMA_POGO_ODMA_UDMA_UTR0_TAGMAJ_SHIFT))

#define  POGO_ODMA_POGO_ODMA_UDMA_UTR0_TAGMID_MASK 0xffff
#define  POGO_ODMA_POGO_ODMA_UDMA_UTR0_TAGMID_SHIFT 0
#define  POGO_ODMA_POGO_ODMA_UDMA_UTR0_TAGMID_MASK_SHIFT(reg) (((reg) & POGO_ODMA_POGO_ODMA_UDMA_UTR0_TAGMID_MASK) >> POGO_ODMA_POGO_ODMA_UDMA_UTR0_TAGMID_SHIFT)
#define  POGO_ODMA_POGO_ODMA_UDMA_UTR0_TAGMID_REPLACE_VAL(reg,val) (((reg) & ~POGO_ODMA_POGO_ODMA_UDMA_UTR0_TAGMID_MASK) | (((uint32_t)val) << POGO_ODMA_POGO_ODMA_UDMA_UTR0_TAGMID_SHIFT))

//====================================================================
//Register: UDMA Tag Register 1 (UTR1)
//====================================================================

#define  POGO_ODMA_POGO_ODMA_UDMA_UTR1_RESERVED1_MASK 0xffff0000
#define  POGO_ODMA_POGO_ODMA_UDMA_UTR1_RESERVED1_SHIFT 16
#define  POGO_ODMA_POGO_ODMA_UDMA_UTR1_RESERVED1_MASK_SHIFT(reg) (((reg) & POGO_ODMA_POGO_ODMA_UDMA_UTR1_RESERVED1_MASK) >> POGO_ODMA_POGO_ODMA_UDMA_UTR1_RESERVED1_SHIFT)
#define  POGO_ODMA_POGO_ODMA_UDMA_UTR1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~POGO_ODMA_POGO_ODMA_UDMA_UTR1_RESERVED1_MASK) | (((uint32_t)val) << POGO_ODMA_POGO_ODMA_UDMA_UTR1_RESERVED1_SHIFT))

#define  POGO_ODMA_POGO_ODMA_UDMA_UTR1_TAGCFG_MASK 0xffff
#define  POGO_ODMA_POGO_ODMA_UDMA_UTR1_TAGCFG_SHIFT 0
#define  POGO_ODMA_POGO_ODMA_UDMA_UTR1_TAGCFG_MASK_SHIFT(reg) (((reg) & POGO_ODMA_POGO_ODMA_UDMA_UTR1_TAGCFG_MASK) >> POGO_ODMA_POGO_ODMA_UDMA_UTR1_TAGCFG_SHIFT)
#define  POGO_ODMA_POGO_ODMA_UDMA_UTR1_TAGCFG_REPLACE_VAL(reg,val) (((reg) & ~POGO_ODMA_POGO_ODMA_UDMA_UTR1_TAGCFG_MASK) | (((uint32_t)val) << POGO_ODMA_POGO_ODMA_UDMA_UTR1_TAGCFG_SHIFT))

//====================================================================
//
//Register File: POGO_ODMA_CORE (POGO_ODMA_POGO_ODMA_CORE)
//
//====================================================================

//====================================================================
//Register: ODMA Interrupt Enable Register (OIER)
//====================================================================

#define  POGO_ODMA_POGO_ODMA_CORE_OIER_RESERVED1_MASK 0xfffffffc
#define  POGO_ODMA_POGO_ODMA_CORE_OIER_RESERVED1_SHIFT 2
#define  POGO_ODMA_POGO_ODMA_CORE_OIER_RESERVED1_MASK_SHIFT(reg) (((reg) & POGO_ODMA_POGO_ODMA_CORE_OIER_RESERVED1_MASK) >> POGO_ODMA_POGO_ODMA_CORE_OIER_RESERVED1_SHIFT)
#define  POGO_ODMA_POGO_ODMA_CORE_OIER_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~POGO_ODMA_POGO_ODMA_CORE_OIER_RESERVED1_MASK) | (((uint32_t)val) << POGO_ODMA_POGO_ODMA_CORE_OIER_RESERVED1_SHIFT))

#define  POGO_ODMA_POGO_ODMA_CORE_OIER_LENGTHERR_MASK 0x2
#define  POGO_ODMA_POGO_ODMA_CORE_OIER_LENGTHERR_SHIFT 1
#define  POGO_ODMA_POGO_ODMA_CORE_OIER_LENGTHERR_MASK_SHIFT(reg) (((reg) & POGO_ODMA_POGO_ODMA_CORE_OIER_LENGTHERR_MASK) >> POGO_ODMA_POGO_ODMA_CORE_OIER_LENGTHERR_SHIFT)
#define  POGO_ODMA_POGO_ODMA_CORE_OIER_LENGTHERR_REPLACE_VAL(reg,val) (((reg) & ~POGO_ODMA_POGO_ODMA_CORE_OIER_LENGTHERR_MASK) | (((uint32_t)val) << POGO_ODMA_POGO_ODMA_CORE_OIER_LENGTHERR_SHIFT))

#define  POGO_ODMA_POGO_ODMA_CORE_OIER_EOS_MASK 0x1
#define  POGO_ODMA_POGO_ODMA_CORE_OIER_EOS_SHIFT 0
#define  POGO_ODMA_POGO_ODMA_CORE_OIER_EOS_MASK_SHIFT(reg) (((reg) & POGO_ODMA_POGO_ODMA_CORE_OIER_EOS_MASK) >> POGO_ODMA_POGO_ODMA_CORE_OIER_EOS_SHIFT)
#define  POGO_ODMA_POGO_ODMA_CORE_OIER_EOS_REPLACE_VAL(reg,val) (((reg) & ~POGO_ODMA_POGO_ODMA_CORE_OIER_EOS_MASK) | (((uint32_t)val) << POGO_ODMA_POGO_ODMA_CORE_OIER_EOS_SHIFT))

//====================================================================
//Register: ODMA Interrupt Pending Register (OIPR)
//====================================================================

#define  POGO_ODMA_POGO_ODMA_CORE_OIPR_RESERVED1_MASK 0xfffffffc
#define  POGO_ODMA_POGO_ODMA_CORE_OIPR_RESERVED1_SHIFT 2
#define  POGO_ODMA_POGO_ODMA_CORE_OIPR_RESERVED1_MASK_SHIFT(reg) (((reg) & POGO_ODMA_POGO_ODMA_CORE_OIPR_RESERVED1_MASK) >> POGO_ODMA_POGO_ODMA_CORE_OIPR_RESERVED1_SHIFT)
#define  POGO_ODMA_POGO_ODMA_CORE_OIPR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~POGO_ODMA_POGO_ODMA_CORE_OIPR_RESERVED1_MASK) | (((uint32_t)val) << POGO_ODMA_POGO_ODMA_CORE_OIPR_RESERVED1_SHIFT))

#define  POGO_ODMA_POGO_ODMA_CORE_OIPR_LENGTHERR_MASK 0x2
#define  POGO_ODMA_POGO_ODMA_CORE_OIPR_LENGTHERR_SHIFT 1
#define  POGO_ODMA_POGO_ODMA_CORE_OIPR_LENGTHERR_MASK_SHIFT(reg) (((reg) & POGO_ODMA_POGO_ODMA_CORE_OIPR_LENGTHERR_MASK) >> POGO_ODMA_POGO_ODMA_CORE_OIPR_LENGTHERR_SHIFT)
#define  POGO_ODMA_POGO_ODMA_CORE_OIPR_LENGTHERR_REPLACE_VAL(reg,val) (((reg) & ~POGO_ODMA_POGO_ODMA_CORE_OIPR_LENGTHERR_MASK) | (((uint32_t)val) << POGO_ODMA_POGO_ODMA_CORE_OIPR_LENGTHERR_SHIFT))

#define  POGO_ODMA_POGO_ODMA_CORE_OIPR_EOS_MASK 0x1
#define  POGO_ODMA_POGO_ODMA_CORE_OIPR_EOS_SHIFT 0
#define  POGO_ODMA_POGO_ODMA_CORE_OIPR_EOS_MASK_SHIFT(reg) (((reg) & POGO_ODMA_POGO_ODMA_CORE_OIPR_EOS_MASK) >> POGO_ODMA_POGO_ODMA_CORE_OIPR_EOS_SHIFT)
#define  POGO_ODMA_POGO_ODMA_CORE_OIPR_EOS_REPLACE_VAL(reg,val) (((reg) & ~POGO_ODMA_POGO_ODMA_CORE_OIPR_EOS_MASK) | (((uint32_t)val) << POGO_ODMA_POGO_ODMA_CORE_OIPR_EOS_SHIFT))

//====================================================================
//Register: ODMA Interrupt Clear Register (OICR)
//====================================================================

#define  POGO_ODMA_POGO_ODMA_CORE_OICR_RESERVED1_MASK 0xfffffffc
#define  POGO_ODMA_POGO_ODMA_CORE_OICR_RESERVED1_SHIFT 2
#define  POGO_ODMA_POGO_ODMA_CORE_OICR_RESERVED1_MASK_SHIFT(reg) (((reg) & POGO_ODMA_POGO_ODMA_CORE_OICR_RESERVED1_MASK) >> POGO_ODMA_POGO_ODMA_CORE_OICR_RESERVED1_SHIFT)
#define  POGO_ODMA_POGO_ODMA_CORE_OICR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~POGO_ODMA_POGO_ODMA_CORE_OICR_RESERVED1_MASK) | (((uint32_t)val) << POGO_ODMA_POGO_ODMA_CORE_OICR_RESERVED1_SHIFT))

#define  POGO_ODMA_POGO_ODMA_CORE_OICR_LENGTHERR_MASK 0x2
#define  POGO_ODMA_POGO_ODMA_CORE_OICR_LENGTHERR_SHIFT 1
#define  POGO_ODMA_POGO_ODMA_CORE_OICR_LENGTHERR_MASK_SHIFT(reg) (((reg) & POGO_ODMA_POGO_ODMA_CORE_OICR_LENGTHERR_MASK) >> POGO_ODMA_POGO_ODMA_CORE_OICR_LENGTHERR_SHIFT)
#define  POGO_ODMA_POGO_ODMA_CORE_OICR_LENGTHERR_REPLACE_VAL(reg,val) (((reg) & ~POGO_ODMA_POGO_ODMA_CORE_OICR_LENGTHERR_MASK) | (((uint32_t)val) << POGO_ODMA_POGO_ODMA_CORE_OICR_LENGTHERR_SHIFT))

#define  POGO_ODMA_POGO_ODMA_CORE_OICR_EOS_MASK 0x1
#define  POGO_ODMA_POGO_ODMA_CORE_OICR_EOS_SHIFT 0
#define  POGO_ODMA_POGO_ODMA_CORE_OICR_EOS_MASK_SHIFT(reg) (((reg) & POGO_ODMA_POGO_ODMA_CORE_OICR_EOS_MASK) >> POGO_ODMA_POGO_ODMA_CORE_OICR_EOS_SHIFT)
#define  POGO_ODMA_POGO_ODMA_CORE_OICR_EOS_REPLACE_VAL(reg,val) (((reg) & ~POGO_ODMA_POGO_ODMA_CORE_OICR_EOS_MASK) | (((uint32_t)val) << POGO_ODMA_POGO_ODMA_CORE_OICR_EOS_SHIFT))

//====================================================================
//Register: ODMA Interrupt Force Register (OIFR)
//====================================================================

#define  POGO_ODMA_POGO_ODMA_CORE_OIFR_RESERVED1_MASK 0xfffffffc
#define  POGO_ODMA_POGO_ODMA_CORE_OIFR_RESERVED1_SHIFT 2
#define  POGO_ODMA_POGO_ODMA_CORE_OIFR_RESERVED1_MASK_SHIFT(reg) (((reg) & POGO_ODMA_POGO_ODMA_CORE_OIFR_RESERVED1_MASK) >> POGO_ODMA_POGO_ODMA_CORE_OIFR_RESERVED1_SHIFT)
#define  POGO_ODMA_POGO_ODMA_CORE_OIFR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~POGO_ODMA_POGO_ODMA_CORE_OIFR_RESERVED1_MASK) | (((uint32_t)val) << POGO_ODMA_POGO_ODMA_CORE_OIFR_RESERVED1_SHIFT))

#define  POGO_ODMA_POGO_ODMA_CORE_OIFR_LENGTHERR_MASK 0x2
#define  POGO_ODMA_POGO_ODMA_CORE_OIFR_LENGTHERR_SHIFT 1
#define  POGO_ODMA_POGO_ODMA_CORE_OIFR_LENGTHERR_MASK_SHIFT(reg) (((reg) & POGO_ODMA_POGO_ODMA_CORE_OIFR_LENGTHERR_MASK) >> POGO_ODMA_POGO_ODMA_CORE_OIFR_LENGTHERR_SHIFT)
#define  POGO_ODMA_POGO_ODMA_CORE_OIFR_LENGTHERR_REPLACE_VAL(reg,val) (((reg) & ~POGO_ODMA_POGO_ODMA_CORE_OIFR_LENGTHERR_MASK) | (((uint32_t)val) << POGO_ODMA_POGO_ODMA_CORE_OIFR_LENGTHERR_SHIFT))

#define  POGO_ODMA_POGO_ODMA_CORE_OIFR_EOS_MASK 0x1
#define  POGO_ODMA_POGO_ODMA_CORE_OIFR_EOS_SHIFT 0
#define  POGO_ODMA_POGO_ODMA_CORE_OIFR_EOS_MASK_SHIFT(reg) (((reg) & POGO_ODMA_POGO_ODMA_CORE_OIFR_EOS_MASK) >> POGO_ODMA_POGO_ODMA_CORE_OIFR_EOS_SHIFT)
#define  POGO_ODMA_POGO_ODMA_CORE_OIFR_EOS_REPLACE_VAL(reg,val) (((reg) & ~POGO_ODMA_POGO_ODMA_CORE_OIFR_EOS_MASK) | (((uint32_t)val) << POGO_ODMA_POGO_ODMA_CORE_OIFR_EOS_SHIFT))

//====================================================================
//Register: ODMA Line Width Register (OLWR)
//====================================================================

#define  POGO_ODMA_POGO_ODMA_CORE_OLWR_RESERVED1_MASK 0xfff00000
#define  POGO_ODMA_POGO_ODMA_CORE_OLWR_RESERVED1_SHIFT 20
#define  POGO_ODMA_POGO_ODMA_CORE_OLWR_RESERVED1_MASK_SHIFT(reg) (((reg) & POGO_ODMA_POGO_ODMA_CORE_OLWR_RESERVED1_MASK) >> POGO_ODMA_POGO_ODMA_CORE_OLWR_RESERVED1_SHIFT)
#define  POGO_ODMA_POGO_ODMA_CORE_OLWR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~POGO_ODMA_POGO_ODMA_CORE_OLWR_RESERVED1_MASK) | (((uint32_t)val) << POGO_ODMA_POGO_ODMA_CORE_OLWR_RESERVED1_SHIFT))

#define  POGO_ODMA_POGO_ODMA_CORE_OLWR_LINEWIDTH_MASK 0xfffff
#define  POGO_ODMA_POGO_ODMA_CORE_OLWR_LINEWIDTH_SHIFT 0
#define  POGO_ODMA_POGO_ODMA_CORE_OLWR_LINEWIDTH_MASK_SHIFT(reg) (((reg) & POGO_ODMA_POGO_ODMA_CORE_OLWR_LINEWIDTH_MASK) >> POGO_ODMA_POGO_ODMA_CORE_OLWR_LINEWIDTH_SHIFT)
#define  POGO_ODMA_POGO_ODMA_CORE_OLWR_LINEWIDTH_REPLACE_VAL(reg,val) (((reg) & ~POGO_ODMA_POGO_ODMA_CORE_OLWR_LINEWIDTH_MASK) | (((uint32_t)val) << POGO_ODMA_POGO_ODMA_CORE_OLWR_LINEWIDTH_SHIFT))

//====================================================================
//Register: ODMA Control Register (OCNTRL)
//====================================================================

#define  POGO_ODMA_POGO_ODMA_CORE_OCNTRL_RESERVED1_MASK 0xfffffffc
#define  POGO_ODMA_POGO_ODMA_CORE_OCNTRL_RESERVED1_SHIFT 2
#define  POGO_ODMA_POGO_ODMA_CORE_OCNTRL_RESERVED1_MASK_SHIFT(reg) (((reg) & POGO_ODMA_POGO_ODMA_CORE_OCNTRL_RESERVED1_MASK) >> POGO_ODMA_POGO_ODMA_CORE_OCNTRL_RESERVED1_SHIFT)
#define  POGO_ODMA_POGO_ODMA_CORE_OCNTRL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~POGO_ODMA_POGO_ODMA_CORE_OCNTRL_RESERVED1_MASK) | (((uint32_t)val) << POGO_ODMA_POGO_ODMA_CORE_OCNTRL_RESERVED1_SHIFT))

#define  POGO_ODMA_POGO_ODMA_CORE_OCNTRL_LINEREVERSE_MASK 0x2
#define  POGO_ODMA_POGO_ODMA_CORE_OCNTRL_LINEREVERSE_SHIFT 1
#define  POGO_ODMA_POGO_ODMA_CORE_OCNTRL_LINEREVERSE_MASK_SHIFT(reg) (((reg) & POGO_ODMA_POGO_ODMA_CORE_OCNTRL_LINEREVERSE_MASK) >> POGO_ODMA_POGO_ODMA_CORE_OCNTRL_LINEREVERSE_SHIFT)
#define  POGO_ODMA_POGO_ODMA_CORE_OCNTRL_LINEREVERSE_REPLACE_VAL(reg,val) (((reg) & ~POGO_ODMA_POGO_ODMA_CORE_OCNTRL_LINEREVERSE_MASK) | (((uint32_t)val) << POGO_ODMA_POGO_ODMA_CORE_OCNTRL_LINEREVERSE_SHIFT))

#define  POGO_ODMA_POGO_ODMA_CORE_OCNTRL_DUMPENABLE_MASK 0x1
#define  POGO_ODMA_POGO_ODMA_CORE_OCNTRL_DUMPENABLE_SHIFT 0
#define  POGO_ODMA_POGO_ODMA_CORE_OCNTRL_DUMPENABLE_MASK_SHIFT(reg) (((reg) & POGO_ODMA_POGO_ODMA_CORE_OCNTRL_DUMPENABLE_MASK) >> POGO_ODMA_POGO_ODMA_CORE_OCNTRL_DUMPENABLE_SHIFT)
#define  POGO_ODMA_POGO_ODMA_CORE_OCNTRL_DUMPENABLE_REPLACE_VAL(reg,val) (((reg) & ~POGO_ODMA_POGO_ODMA_CORE_OCNTRL_DUMPENABLE_MASK) | (((uint32_t)val) << POGO_ODMA_POGO_ODMA_CORE_OCNTRL_DUMPENABLE_SHIFT))

//====================================================================
//Register: ODMA Tag Register 0 (OTR0)
//====================================================================

#define  POGO_ODMA_POGO_ODMA_CORE_OTR0_RESERVED1_MASK 0xffff0000
#define  POGO_ODMA_POGO_ODMA_CORE_OTR0_RESERVED1_SHIFT 16
#define  POGO_ODMA_POGO_ODMA_CORE_OTR0_RESERVED1_MASK_SHIFT(reg) (((reg) & POGO_ODMA_POGO_ODMA_CORE_OTR0_RESERVED1_MASK) >> POGO_ODMA_POGO_ODMA_CORE_OTR0_RESERVED1_SHIFT)
#define  POGO_ODMA_POGO_ODMA_CORE_OTR0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~POGO_ODMA_POGO_ODMA_CORE_OTR0_RESERVED1_MASK) | (((uint32_t)val) << POGO_ODMA_POGO_ODMA_CORE_OTR0_RESERVED1_SHIFT))

#define  POGO_ODMA_POGO_ODMA_CORE_OTR0_TAGCFG_MASK 0xffff
#define  POGO_ODMA_POGO_ODMA_CORE_OTR0_TAGCFG_SHIFT 0
#define  POGO_ODMA_POGO_ODMA_CORE_OTR0_TAGCFG_MASK_SHIFT(reg) (((reg) & POGO_ODMA_POGO_ODMA_CORE_OTR0_TAGCFG_MASK) >> POGO_ODMA_POGO_ODMA_CORE_OTR0_TAGCFG_SHIFT)
#define  POGO_ODMA_POGO_ODMA_CORE_OTR0_TAGCFG_REPLACE_VAL(reg,val) (((reg) & ~POGO_ODMA_POGO_ODMA_CORE_OTR0_TAGCFG_MASK) | (((uint32_t)val) << POGO_ODMA_POGO_ODMA_CORE_OTR0_TAGCFG_SHIFT))

//====================================================================
//Register: ODMA Tag Register 1 (OTR1)
//====================================================================

#define  POGO_ODMA_POGO_ODMA_CORE_OTR1_RESERVED1_MASK 0xffff0000
#define  POGO_ODMA_POGO_ODMA_CORE_OTR1_RESERVED1_SHIFT 16
#define  POGO_ODMA_POGO_ODMA_CORE_OTR1_RESERVED1_MASK_SHIFT(reg) (((reg) & POGO_ODMA_POGO_ODMA_CORE_OTR1_RESERVED1_MASK) >> POGO_ODMA_POGO_ODMA_CORE_OTR1_RESERVED1_SHIFT)
#define  POGO_ODMA_POGO_ODMA_CORE_OTR1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~POGO_ODMA_POGO_ODMA_CORE_OTR1_RESERVED1_MASK) | (((uint32_t)val) << POGO_ODMA_POGO_ODMA_CORE_OTR1_RESERVED1_SHIFT))

#define  POGO_ODMA_POGO_ODMA_CORE_OTR1_TAGMAJ_MASK 0xffff
#define  POGO_ODMA_POGO_ODMA_CORE_OTR1_TAGMAJ_SHIFT 0
#define  POGO_ODMA_POGO_ODMA_CORE_OTR1_TAGMAJ_MASK_SHIFT(reg) (((reg) & POGO_ODMA_POGO_ODMA_CORE_OTR1_TAGMAJ_MASK) >> POGO_ODMA_POGO_ODMA_CORE_OTR1_TAGMAJ_SHIFT)
#define  POGO_ODMA_POGO_ODMA_CORE_OTR1_TAGMAJ_REPLACE_VAL(reg,val) (((reg) & ~POGO_ODMA_POGO_ODMA_CORE_OTR1_TAGMAJ_MASK) | (((uint32_t)val) << POGO_ODMA_POGO_ODMA_CORE_OTR1_TAGMAJ_SHIFT))

//====================================================================
//Register: ODMA Tag Register 2 (OTR2)
//====================================================================

#define  POGO_ODMA_POGO_ODMA_CORE_OTR2_RESERVED1_MASK 0xffff0000
#define  POGO_ODMA_POGO_ODMA_CORE_OTR2_RESERVED1_SHIFT 16
#define  POGO_ODMA_POGO_ODMA_CORE_OTR2_RESERVED1_MASK_SHIFT(reg) (((reg) & POGO_ODMA_POGO_ODMA_CORE_OTR2_RESERVED1_MASK) >> POGO_ODMA_POGO_ODMA_CORE_OTR2_RESERVED1_SHIFT)
#define  POGO_ODMA_POGO_ODMA_CORE_OTR2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~POGO_ODMA_POGO_ODMA_CORE_OTR2_RESERVED1_MASK) | (((uint32_t)val) << POGO_ODMA_POGO_ODMA_CORE_OTR2_RESERVED1_SHIFT))

#define  POGO_ODMA_POGO_ODMA_CORE_OTR2_TAGMID_MASK 0xffff
#define  POGO_ODMA_POGO_ODMA_CORE_OTR2_TAGMID_SHIFT 0
#define  POGO_ODMA_POGO_ODMA_CORE_OTR2_TAGMID_MASK_SHIFT(reg) (((reg) & POGO_ODMA_POGO_ODMA_CORE_OTR2_TAGMID_MASK) >> POGO_ODMA_POGO_ODMA_CORE_OTR2_TAGMID_SHIFT)
#define  POGO_ODMA_POGO_ODMA_CORE_OTR2_TAGMID_REPLACE_VAL(reg,val) (((reg) & ~POGO_ODMA_POGO_ODMA_CORE_OTR2_TAGMID_MASK) | (((uint32_t)val) << POGO_ODMA_POGO_ODMA_CORE_OTR2_TAGMID_SHIFT))

//====================================================================
//
//Register File: POGO_ODMA_UDMA (POGO_OTODMA_POGO_ODMA_UDMA)
//
//====================================================================

//====================================================================
//Register: UDMA Configuration Register (UCR)
//====================================================================

#define  POGO_OTODMA_POGO_ODMA_UDMA_UCR_RESERVED1_MASK 0xfff00000
#define  POGO_OTODMA_POGO_ODMA_UDMA_UCR_RESERVED1_SHIFT 20
#define  POGO_OTODMA_POGO_ODMA_UDMA_UCR_RESERVED1_MASK_SHIFT(reg) (((reg) & POGO_OTODMA_POGO_ODMA_UDMA_UCR_RESERVED1_MASK) >> POGO_OTODMA_POGO_ODMA_UDMA_UCR_RESERVED1_SHIFT)
#define  POGO_OTODMA_POGO_ODMA_UDMA_UCR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~POGO_OTODMA_POGO_ODMA_UDMA_UCR_RESERVED1_MASK) | (((uint32_t)val) << POGO_OTODMA_POGO_ODMA_UDMA_UCR_RESERVED1_SHIFT))

#define  POGO_OTODMA_POGO_ODMA_UDMA_UCR_DATAAXCACHE_MASK 0xf0000
#define  POGO_OTODMA_POGO_ODMA_UDMA_UCR_DATAAXCACHE_SHIFT 16
#define  POGO_OTODMA_POGO_ODMA_UDMA_UCR_DATAAXCACHE_MASK_SHIFT(reg) (((reg) & POGO_OTODMA_POGO_ODMA_UDMA_UCR_DATAAXCACHE_MASK) >> POGO_OTODMA_POGO_ODMA_UDMA_UCR_DATAAXCACHE_SHIFT)
#define  POGO_OTODMA_POGO_ODMA_UDMA_UCR_DATAAXCACHE_REPLACE_VAL(reg,val) (((reg) & ~POGO_OTODMA_POGO_ODMA_UDMA_UCR_DATAAXCACHE_MASK) | (((uint32_t)val) << POGO_OTODMA_POGO_ODMA_UDMA_UCR_DATAAXCACHE_SHIFT))

#define  POGO_OTODMA_POGO_ODMA_UDMA_UCR_DESCARCACHE_MASK 0xf000
#define  POGO_OTODMA_POGO_ODMA_UDMA_UCR_DESCARCACHE_SHIFT 12
#define  POGO_OTODMA_POGO_ODMA_UDMA_UCR_DESCARCACHE_MASK_SHIFT(reg) (((reg) & POGO_OTODMA_POGO_ODMA_UDMA_UCR_DESCARCACHE_MASK) >> POGO_OTODMA_POGO_ODMA_UDMA_UCR_DESCARCACHE_SHIFT)
#define  POGO_OTODMA_POGO_ODMA_UDMA_UCR_DESCARCACHE_REPLACE_VAL(reg,val) (((reg) & ~POGO_OTODMA_POGO_ODMA_UDMA_UCR_DESCARCACHE_MASK) | (((uint32_t)val) << POGO_OTODMA_POGO_ODMA_UDMA_UCR_DESCARCACHE_SHIFT))

#define  POGO_OTODMA_POGO_ODMA_UDMA_UCR_DESCAWCACHE_MASK 0xf00
#define  POGO_OTODMA_POGO_ODMA_UDMA_UCR_DESCAWCACHE_SHIFT 8
#define  POGO_OTODMA_POGO_ODMA_UDMA_UCR_DESCAWCACHE_MASK_SHIFT(reg) (((reg) & POGO_OTODMA_POGO_ODMA_UDMA_UCR_DESCAWCACHE_MASK) >> POGO_OTODMA_POGO_ODMA_UDMA_UCR_DESCAWCACHE_SHIFT)
#define  POGO_OTODMA_POGO_ODMA_UDMA_UCR_DESCAWCACHE_REPLACE_VAL(reg,val) (((reg) & ~POGO_OTODMA_POGO_ODMA_UDMA_UCR_DESCAWCACHE_MASK) | (((uint32_t)val) << POGO_OTODMA_POGO_ODMA_UDMA_UCR_DESCAWCACHE_SHIFT))

#define  POGO_OTODMA_POGO_ODMA_UDMA_UCR_RESERVED2_MASK 0xc0
#define  POGO_OTODMA_POGO_ODMA_UDMA_UCR_RESERVED2_SHIFT 6
#define  POGO_OTODMA_POGO_ODMA_UDMA_UCR_RESERVED2_MASK_SHIFT(reg) (((reg) & POGO_OTODMA_POGO_ODMA_UDMA_UCR_RESERVED2_MASK) >> POGO_OTODMA_POGO_ODMA_UDMA_UCR_RESERVED2_SHIFT)
#define  POGO_OTODMA_POGO_ODMA_UDMA_UCR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~POGO_OTODMA_POGO_ODMA_UDMA_UCR_RESERVED2_MASK) | (((uint32_t)val) << POGO_OTODMA_POGO_ODMA_UDMA_UCR_RESERVED2_SHIFT))

#define  POGO_OTODMA_POGO_ODMA_UDMA_UCR_HANDSHAKEENABLE_MASK 0x20
#define  POGO_OTODMA_POGO_ODMA_UDMA_UCR_HANDSHAKEENABLE_SHIFT 5
#define  POGO_OTODMA_POGO_ODMA_UDMA_UCR_HANDSHAKEENABLE_MASK_SHIFT(reg) (((reg) & POGO_OTODMA_POGO_ODMA_UDMA_UCR_HANDSHAKEENABLE_MASK) >> POGO_OTODMA_POGO_ODMA_UDMA_UCR_HANDSHAKEENABLE_SHIFT)
#define  POGO_OTODMA_POGO_ODMA_UDMA_UCR_HANDSHAKEENABLE_REPLACE_VAL(reg,val) (((reg) & ~POGO_OTODMA_POGO_ODMA_UDMA_UCR_HANDSHAKEENABLE_MASK) | (((uint32_t)val) << POGO_OTODMA_POGO_ODMA_UDMA_UCR_HANDSHAKEENABLE_SHIFT))

#define  POGO_OTODMA_POGO_ODMA_UDMA_UCR_OWNWRITEDISABLE_MASK 0x10
#define  POGO_OTODMA_POGO_ODMA_UDMA_UCR_OWNWRITEDISABLE_SHIFT 4
#define  POGO_OTODMA_POGO_ODMA_UDMA_UCR_OWNWRITEDISABLE_MASK_SHIFT(reg) (((reg) & POGO_OTODMA_POGO_ODMA_UDMA_UCR_OWNWRITEDISABLE_MASK) >> POGO_OTODMA_POGO_ODMA_UDMA_UCR_OWNWRITEDISABLE_SHIFT)
#define  POGO_OTODMA_POGO_ODMA_UDMA_UCR_OWNWRITEDISABLE_REPLACE_VAL(reg,val) (((reg) & ~POGO_OTODMA_POGO_ODMA_UDMA_UCR_OWNWRITEDISABLE_MASK) | (((uint32_t)val) << POGO_OTODMA_POGO_ODMA_UDMA_UCR_OWNWRITEDISABLE_SHIFT))

#define  POGO_OTODMA_POGO_ODMA_UDMA_UCR_OWNPOLARITY_MASK 0x8
#define  POGO_OTODMA_POGO_ODMA_UDMA_UCR_OWNPOLARITY_SHIFT 3
#define  POGO_OTODMA_POGO_ODMA_UDMA_UCR_OWNPOLARITY_MASK_SHIFT(reg) (((reg) & POGO_OTODMA_POGO_ODMA_UDMA_UCR_OWNPOLARITY_MASK) >> POGO_OTODMA_POGO_ODMA_UDMA_UCR_OWNPOLARITY_SHIFT)
#define  POGO_OTODMA_POGO_ODMA_UDMA_UCR_OWNPOLARITY_REPLACE_VAL(reg,val) (((reg) & ~POGO_OTODMA_POGO_ODMA_UDMA_UCR_OWNPOLARITY_MASK) | (((uint32_t)val) << POGO_OTODMA_POGO_ODMA_UDMA_UCR_OWNPOLARITY_SHIFT))

#define  POGO_OTODMA_POGO_ODMA_UDMA_UCR_BEATS_MASK 0x6
#define  POGO_OTODMA_POGO_ODMA_UDMA_UCR_BEATS_SHIFT 1
#define  POGO_OTODMA_POGO_ODMA_UDMA_UCR_BEATS_MASK_SHIFT(reg) (((reg) & POGO_OTODMA_POGO_ODMA_UDMA_UCR_BEATS_MASK) >> POGO_OTODMA_POGO_ODMA_UDMA_UCR_BEATS_SHIFT)
#define  POGO_OTODMA_POGO_ODMA_UDMA_UCR_BEATS_REPLACE_VAL(reg,val) (((reg) & ~POGO_OTODMA_POGO_ODMA_UDMA_UCR_BEATS_MASK) | (((uint32_t)val) << POGO_OTODMA_POGO_ODMA_UDMA_UCR_BEATS_SHIFT))

#define  POGO_OTODMA_POGO_ODMA_UDMA_UCR_ENABLE_MASK 0x1
#define  POGO_OTODMA_POGO_ODMA_UDMA_UCR_ENABLE_SHIFT 0
#define  POGO_OTODMA_POGO_ODMA_UDMA_UCR_ENABLE_MASK_SHIFT(reg) (((reg) & POGO_OTODMA_POGO_ODMA_UDMA_UCR_ENABLE_MASK) >> POGO_OTODMA_POGO_ODMA_UDMA_UCR_ENABLE_SHIFT)
#define  POGO_OTODMA_POGO_ODMA_UDMA_UCR_ENABLE_REPLACE_VAL(reg,val) (((reg) & ~POGO_OTODMA_POGO_ODMA_UDMA_UCR_ENABLE_MASK) | (((uint32_t)val) << POGO_OTODMA_POGO_ODMA_UDMA_UCR_ENABLE_SHIFT))

//====================================================================
//Register: UDMA Status Register (USR)
//====================================================================

#define  POGO_OTODMA_POGO_ODMA_UDMA_USR_RESERVED1_MASK 0xfffff800
#define  POGO_OTODMA_POGO_ODMA_UDMA_USR_RESERVED1_SHIFT 11
#define  POGO_OTODMA_POGO_ODMA_UDMA_USR_RESERVED1_MASK_SHIFT(reg) (((reg) & POGO_OTODMA_POGO_ODMA_UDMA_USR_RESERVED1_MASK) >> POGO_OTODMA_POGO_ODMA_UDMA_USR_RESERVED1_SHIFT)
#define  POGO_OTODMA_POGO_ODMA_UDMA_USR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~POGO_OTODMA_POGO_ODMA_UDMA_USR_RESERVED1_MASK) | (((uint32_t)val) << POGO_OTODMA_POGO_ODMA_UDMA_USR_RESERVED1_SHIFT))

#define  POGO_OTODMA_POGO_ODMA_UDMA_USR_DMAPAUSED_MASK 0x400
#define  POGO_OTODMA_POGO_ODMA_UDMA_USR_DMAPAUSED_SHIFT 10
#define  POGO_OTODMA_POGO_ODMA_UDMA_USR_DMAPAUSED_MASK_SHIFT(reg) (((reg) & POGO_OTODMA_POGO_ODMA_UDMA_USR_DMAPAUSED_MASK) >> POGO_OTODMA_POGO_ODMA_UDMA_USR_DMAPAUSED_SHIFT)
#define  POGO_OTODMA_POGO_ODMA_UDMA_USR_DMAPAUSED_REPLACE_VAL(reg,val) (((reg) & ~POGO_OTODMA_POGO_ODMA_UDMA_USR_DMAPAUSED_MASK) | (((uint32_t)val) << POGO_OTODMA_POGO_ODMA_UDMA_USR_DMAPAUSED_SHIFT))

#define  POGO_OTODMA_POGO_ODMA_UDMA_USR_PAUSEAFTER_MASK 0x200
#define  POGO_OTODMA_POGO_ODMA_UDMA_USR_PAUSEAFTER_SHIFT 9
#define  POGO_OTODMA_POGO_ODMA_UDMA_USR_PAUSEAFTER_MASK_SHIFT(reg) (((reg) & POGO_OTODMA_POGO_ODMA_UDMA_USR_PAUSEAFTER_MASK) >> POGO_OTODMA_POGO_ODMA_UDMA_USR_PAUSEAFTER_SHIFT)
#define  POGO_OTODMA_POGO_ODMA_UDMA_USR_PAUSEAFTER_REPLACE_VAL(reg,val) (((reg) & ~POGO_OTODMA_POGO_ODMA_UDMA_USR_PAUSEAFTER_MASK) | (((uint32_t)val) << POGO_OTODMA_POGO_ODMA_UDMA_USR_PAUSEAFTER_SHIFT))

#define  POGO_OTODMA_POGO_ODMA_UDMA_USR_PAUSEBEFORE_MASK 0x100
#define  POGO_OTODMA_POGO_ODMA_UDMA_USR_PAUSEBEFORE_SHIFT 8
#define  POGO_OTODMA_POGO_ODMA_UDMA_USR_PAUSEBEFORE_MASK_SHIFT(reg) (((reg) & POGO_OTODMA_POGO_ODMA_UDMA_USR_PAUSEBEFORE_MASK) >> POGO_OTODMA_POGO_ODMA_UDMA_USR_PAUSEBEFORE_SHIFT)
#define  POGO_OTODMA_POGO_ODMA_UDMA_USR_PAUSEBEFORE_REPLACE_VAL(reg,val) (((reg) & ~POGO_OTODMA_POGO_ODMA_UDMA_USR_PAUSEBEFORE_MASK) | (((uint32_t)val) << POGO_OTODMA_POGO_ODMA_UDMA_USR_PAUSEBEFORE_SHIFT))

#define  POGO_OTODMA_POGO_ODMA_UDMA_USR_INTONFINISH_MASK 0x80
#define  POGO_OTODMA_POGO_ODMA_UDMA_USR_INTONFINISH_SHIFT 7
#define  POGO_OTODMA_POGO_ODMA_UDMA_USR_INTONFINISH_MASK_SHIFT(reg) (((reg) & POGO_OTODMA_POGO_ODMA_UDMA_USR_INTONFINISH_MASK) >> POGO_OTODMA_POGO_ODMA_UDMA_USR_INTONFINISH_SHIFT)
#define  POGO_OTODMA_POGO_ODMA_UDMA_USR_INTONFINISH_REPLACE_VAL(reg,val) (((reg) & ~POGO_OTODMA_POGO_ODMA_UDMA_USR_INTONFINISH_MASK) | (((uint32_t)val) << POGO_OTODMA_POGO_ODMA_UDMA_USR_INTONFINISH_SHIFT))

#define  POGO_OTODMA_POGO_ODMA_UDMA_USR_STOPONFINISH_MASK 0x40
#define  POGO_OTODMA_POGO_ODMA_UDMA_USR_STOPONFINISH_SHIFT 6
#define  POGO_OTODMA_POGO_ODMA_UDMA_USR_STOPONFINISH_MASK_SHIFT(reg) (((reg) & POGO_OTODMA_POGO_ODMA_UDMA_USR_STOPONFINISH_MASK) >> POGO_OTODMA_POGO_ODMA_UDMA_USR_STOPONFINISH_SHIFT)
#define  POGO_OTODMA_POGO_ODMA_UDMA_USR_STOPONFINISH_REPLACE_VAL(reg,val) (((reg) & ~POGO_OTODMA_POGO_ODMA_UDMA_USR_STOPONFINISH_MASK) | (((uint32_t)val) << POGO_OTODMA_POGO_ODMA_UDMA_USR_STOPONFINISH_SHIFT))

#define  POGO_OTODMA_POGO_ODMA_UDMA_USR_CMDBUFFULL_MASK 0x20
#define  POGO_OTODMA_POGO_ODMA_UDMA_USR_CMDBUFFULL_SHIFT 5
#define  POGO_OTODMA_POGO_ODMA_UDMA_USR_CMDBUFFULL_MASK_SHIFT(reg) (((reg) & POGO_OTODMA_POGO_ODMA_UDMA_USR_CMDBUFFULL_MASK) >> POGO_OTODMA_POGO_ODMA_UDMA_USR_CMDBUFFULL_SHIFT)
#define  POGO_OTODMA_POGO_ODMA_UDMA_USR_CMDBUFFULL_REPLACE_VAL(reg,val) (((reg) & ~POGO_OTODMA_POGO_ODMA_UDMA_USR_CMDBUFFULL_MASK) | (((uint32_t)val) << POGO_OTODMA_POGO_ODMA_UDMA_USR_CMDBUFFULL_SHIFT))

#define  POGO_OTODMA_POGO_ODMA_UDMA_USR_CMDBUFEMPTY_MASK 0x10
#define  POGO_OTODMA_POGO_ODMA_UDMA_USR_CMDBUFEMPTY_SHIFT 4
#define  POGO_OTODMA_POGO_ODMA_UDMA_USR_CMDBUFEMPTY_MASK_SHIFT(reg) (((reg) & POGO_OTODMA_POGO_ODMA_UDMA_USR_CMDBUFEMPTY_MASK) >> POGO_OTODMA_POGO_ODMA_UDMA_USR_CMDBUFEMPTY_SHIFT)
#define  POGO_OTODMA_POGO_ODMA_UDMA_USR_CMDBUFEMPTY_REPLACE_VAL(reg,val) (((reg) & ~POGO_OTODMA_POGO_ODMA_UDMA_USR_CMDBUFEMPTY_MASK) | (((uint32_t)val) << POGO_OTODMA_POGO_ODMA_UDMA_USR_CMDBUFEMPTY_SHIFT))

#define  POGO_OTODMA_POGO_ODMA_UDMA_USR_DATABUFFULL_MASK 0x8
#define  POGO_OTODMA_POGO_ODMA_UDMA_USR_DATABUFFULL_SHIFT 3
#define  POGO_OTODMA_POGO_ODMA_UDMA_USR_DATABUFFULL_MASK_SHIFT(reg) (((reg) & POGO_OTODMA_POGO_ODMA_UDMA_USR_DATABUFFULL_MASK) >> POGO_OTODMA_POGO_ODMA_UDMA_USR_DATABUFFULL_SHIFT)
#define  POGO_OTODMA_POGO_ODMA_UDMA_USR_DATABUFFULL_REPLACE_VAL(reg,val) (((reg) & ~POGO_OTODMA_POGO_ODMA_UDMA_USR_DATABUFFULL_MASK) | (((uint32_t)val) << POGO_OTODMA_POGO_ODMA_UDMA_USR_DATABUFFULL_SHIFT))

#define  POGO_OTODMA_POGO_ODMA_UDMA_USR_DATABUFEMPTY_MASK 0x4
#define  POGO_OTODMA_POGO_ODMA_UDMA_USR_DATABUFEMPTY_SHIFT 2
#define  POGO_OTODMA_POGO_ODMA_UDMA_USR_DATABUFEMPTY_MASK_SHIFT(reg) (((reg) & POGO_OTODMA_POGO_ODMA_UDMA_USR_DATABUFEMPTY_MASK) >> POGO_OTODMA_POGO_ODMA_UDMA_USR_DATABUFEMPTY_SHIFT)
#define  POGO_OTODMA_POGO_ODMA_UDMA_USR_DATABUFEMPTY_REPLACE_VAL(reg,val) (((reg) & ~POGO_OTODMA_POGO_ODMA_UDMA_USR_DATABUFEMPTY_MASK) | (((uint32_t)val) << POGO_OTODMA_POGO_ODMA_UDMA_USR_DATABUFEMPTY_SHIFT))

#define  POGO_OTODMA_POGO_ODMA_UDMA_USR_CLEAR_MASK 0x2
#define  POGO_OTODMA_POGO_ODMA_UDMA_USR_CLEAR_SHIFT 1
#define  POGO_OTODMA_POGO_ODMA_UDMA_USR_CLEAR_MASK_SHIFT(reg) (((reg) & POGO_OTODMA_POGO_ODMA_UDMA_USR_CLEAR_MASK) >> POGO_OTODMA_POGO_ODMA_UDMA_USR_CLEAR_SHIFT)
#define  POGO_OTODMA_POGO_ODMA_UDMA_USR_CLEAR_REPLACE_VAL(reg,val) (((reg) & ~POGO_OTODMA_POGO_ODMA_UDMA_USR_CLEAR_MASK) | (((uint32_t)val) << POGO_OTODMA_POGO_ODMA_UDMA_USR_CLEAR_SHIFT))

#define  POGO_OTODMA_POGO_ODMA_UDMA_USR_BUSY_MASK 0x1
#define  POGO_OTODMA_POGO_ODMA_UDMA_USR_BUSY_SHIFT 0
#define  POGO_OTODMA_POGO_ODMA_UDMA_USR_BUSY_MASK_SHIFT(reg) (((reg) & POGO_OTODMA_POGO_ODMA_UDMA_USR_BUSY_MASK) >> POGO_OTODMA_POGO_ODMA_UDMA_USR_BUSY_SHIFT)
#define  POGO_OTODMA_POGO_ODMA_UDMA_USR_BUSY_REPLACE_VAL(reg,val) (((reg) & ~POGO_OTODMA_POGO_ODMA_UDMA_USR_BUSY_MASK) | (((uint32_t)val) << POGO_OTODMA_POGO_ODMA_UDMA_USR_BUSY_SHIFT))

//====================================================================
//Register: UDMA Parameter Register (UPR)
//====================================================================

#define  POGO_OTODMA_POGO_ODMA_UDMA_UPR_RESERVED1_MASK 0xff000000
#define  POGO_OTODMA_POGO_ODMA_UDMA_UPR_RESERVED1_SHIFT 24
#define  POGO_OTODMA_POGO_ODMA_UDMA_UPR_RESERVED1_MASK_SHIFT(reg) (((reg) & POGO_OTODMA_POGO_ODMA_UDMA_UPR_RESERVED1_MASK) >> POGO_OTODMA_POGO_ODMA_UDMA_UPR_RESERVED1_SHIFT)
#define  POGO_OTODMA_POGO_ODMA_UDMA_UPR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~POGO_OTODMA_POGO_ODMA_UDMA_UPR_RESERVED1_MASK) | (((uint32_t)val) << POGO_OTODMA_POGO_ODMA_UDMA_UPR_RESERVED1_SHIFT))

#define  POGO_OTODMA_POGO_ODMA_UDMA_UPR_FIFODEPTH_MASK 0xffff00
#define  POGO_OTODMA_POGO_ODMA_UDMA_UPR_FIFODEPTH_SHIFT 8
#define  POGO_OTODMA_POGO_ODMA_UDMA_UPR_FIFODEPTH_MASK_SHIFT(reg) (((reg) & POGO_OTODMA_POGO_ODMA_UDMA_UPR_FIFODEPTH_MASK) >> POGO_OTODMA_POGO_ODMA_UDMA_UPR_FIFODEPTH_SHIFT)
#define  POGO_OTODMA_POGO_ODMA_UDMA_UPR_FIFODEPTH_REPLACE_VAL(reg,val) (((reg) & ~POGO_OTODMA_POGO_ODMA_UDMA_UPR_FIFODEPTH_MASK) | (((uint32_t)val) << POGO_OTODMA_POGO_ODMA_UDMA_UPR_FIFODEPTH_SHIFT))

#define  POGO_OTODMA_POGO_ODMA_UDMA_UPR_RESERVED2_MASK 0xe0
#define  POGO_OTODMA_POGO_ODMA_UDMA_UPR_RESERVED2_SHIFT 5
#define  POGO_OTODMA_POGO_ODMA_UDMA_UPR_RESERVED2_MASK_SHIFT(reg) (((reg) & POGO_OTODMA_POGO_ODMA_UDMA_UPR_RESERVED2_MASK) >> POGO_OTODMA_POGO_ODMA_UDMA_UPR_RESERVED2_SHIFT)
#define  POGO_OTODMA_POGO_ODMA_UDMA_UPR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~POGO_OTODMA_POGO_ODMA_UDMA_UPR_RESERVED2_MASK) | (((uint32_t)val) << POGO_OTODMA_POGO_ODMA_UDMA_UPR_RESERVED2_SHIFT))

#define  POGO_OTODMA_POGO_ODMA_UDMA_UPR_SERPSUPPORT_MASK 0x10
#define  POGO_OTODMA_POGO_ODMA_UDMA_UPR_SERPSUPPORT_SHIFT 4
#define  POGO_OTODMA_POGO_ODMA_UDMA_UPR_SERPSUPPORT_MASK_SHIFT(reg) (((reg) & POGO_OTODMA_POGO_ODMA_UDMA_UPR_SERPSUPPORT_MASK) >> POGO_OTODMA_POGO_ODMA_UDMA_UPR_SERPSUPPORT_SHIFT)
#define  POGO_OTODMA_POGO_ODMA_UDMA_UPR_SERPSUPPORT_REPLACE_VAL(reg,val) (((reg) & ~POGO_OTODMA_POGO_ODMA_UDMA_UPR_SERPSUPPORT_MASK) | (((uint32_t)val) << POGO_OTODMA_POGO_ODMA_UDMA_UPR_SERPSUPPORT_SHIFT))

#define  POGO_OTODMA_POGO_ODMA_UDMA_UPR_DESCLENGTH_MASK 0x8
#define  POGO_OTODMA_POGO_ODMA_UDMA_UPR_DESCLENGTH_SHIFT 3
#define  POGO_OTODMA_POGO_ODMA_UDMA_UPR_DESCLENGTH_MASK_SHIFT(reg) (((reg) & POGO_OTODMA_POGO_ODMA_UDMA_UPR_DESCLENGTH_MASK) >> POGO_OTODMA_POGO_ODMA_UDMA_UPR_DESCLENGTH_SHIFT)
#define  POGO_OTODMA_POGO_ODMA_UDMA_UPR_DESCLENGTH_REPLACE_VAL(reg,val) (((reg) & ~POGO_OTODMA_POGO_ODMA_UDMA_UPR_DESCLENGTH_MASK) | (((uint32_t)val) << POGO_OTODMA_POGO_ODMA_UDMA_UPR_DESCLENGTH_SHIFT))

#define  POGO_OTODMA_POGO_ODMA_UDMA_UPR_BUSWIDTH_MASK 0x4
#define  POGO_OTODMA_POGO_ODMA_UDMA_UPR_BUSWIDTH_SHIFT 2
#define  POGO_OTODMA_POGO_ODMA_UDMA_UPR_BUSWIDTH_MASK_SHIFT(reg) (((reg) & POGO_OTODMA_POGO_ODMA_UDMA_UPR_BUSWIDTH_MASK) >> POGO_OTODMA_POGO_ODMA_UDMA_UPR_BUSWIDTH_SHIFT)
#define  POGO_OTODMA_POGO_ODMA_UDMA_UPR_BUSWIDTH_REPLACE_VAL(reg,val) (((reg) & ~POGO_OTODMA_POGO_ODMA_UDMA_UPR_BUSWIDTH_MASK) | (((uint32_t)val) << POGO_OTODMA_POGO_ODMA_UDMA_UPR_BUSWIDTH_SHIFT))

#define  POGO_OTODMA_POGO_ODMA_UDMA_UPR_MEMALIGN_MASK 0x3
#define  POGO_OTODMA_POGO_ODMA_UDMA_UPR_MEMALIGN_SHIFT 0
#define  POGO_OTODMA_POGO_ODMA_UDMA_UPR_MEMALIGN_MASK_SHIFT(reg) (((reg) & POGO_OTODMA_POGO_ODMA_UDMA_UPR_MEMALIGN_MASK) >> POGO_OTODMA_POGO_ODMA_UDMA_UPR_MEMALIGN_SHIFT)
#define  POGO_OTODMA_POGO_ODMA_UDMA_UPR_MEMALIGN_REPLACE_VAL(reg,val) (((reg) & ~POGO_OTODMA_POGO_ODMA_UDMA_UPR_MEMALIGN_MASK) | (((uint32_t)val) << POGO_OTODMA_POGO_ODMA_UDMA_UPR_MEMALIGN_SHIFT))

//====================================================================
//Register: UDMA Interrupt Enable Register (UIER)
//====================================================================

#define  POGO_OTODMA_POGO_ODMA_UDMA_UIER_RESERVED1_MASK 0xffffffc0
#define  POGO_OTODMA_POGO_ODMA_UDMA_UIER_RESERVED1_SHIFT 6
#define  POGO_OTODMA_POGO_ODMA_UDMA_UIER_RESERVED1_MASK_SHIFT(reg) (((reg) & POGO_OTODMA_POGO_ODMA_UDMA_UIER_RESERVED1_MASK) >> POGO_OTODMA_POGO_ODMA_UDMA_UIER_RESERVED1_SHIFT)
#define  POGO_OTODMA_POGO_ODMA_UDMA_UIER_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~POGO_OTODMA_POGO_ODMA_UDMA_UIER_RESERVED1_MASK) | (((uint32_t)val) << POGO_OTODMA_POGO_ODMA_UDMA_UIER_RESERVED1_SHIFT))

#define  POGO_OTODMA_POGO_ODMA_UDMA_UIER_OUTOFRANGE_MASK 0x20
#define  POGO_OTODMA_POGO_ODMA_UDMA_UIER_OUTOFRANGE_SHIFT 5
#define  POGO_OTODMA_POGO_ODMA_UDMA_UIER_OUTOFRANGE_MASK_SHIFT(reg) (((reg) & POGO_OTODMA_POGO_ODMA_UDMA_UIER_OUTOFRANGE_MASK) >> POGO_OTODMA_POGO_ODMA_UDMA_UIER_OUTOFRANGE_SHIFT)
#define  POGO_OTODMA_POGO_ODMA_UDMA_UIER_OUTOFRANGE_REPLACE_VAL(reg,val) (((reg) & ~POGO_OTODMA_POGO_ODMA_UDMA_UIER_OUTOFRANGE_MASK) | (((uint32_t)val) << POGO_OTODMA_POGO_ODMA_UDMA_UIER_OUTOFRANGE_SHIFT))

#define  POGO_OTODMA_POGO_ODMA_UDMA_UIER_RRESP_MASK 0x10
#define  POGO_OTODMA_POGO_ODMA_UDMA_UIER_RRESP_SHIFT 4
#define  POGO_OTODMA_POGO_ODMA_UDMA_UIER_RRESP_MASK_SHIFT(reg) (((reg) & POGO_OTODMA_POGO_ODMA_UDMA_UIER_RRESP_MASK) >> POGO_OTODMA_POGO_ODMA_UDMA_UIER_RRESP_SHIFT)
#define  POGO_OTODMA_POGO_ODMA_UDMA_UIER_RRESP_REPLACE_VAL(reg,val) (((reg) & ~POGO_OTODMA_POGO_ODMA_UDMA_UIER_RRESP_MASK) | (((uint32_t)val) << POGO_OTODMA_POGO_ODMA_UDMA_UIER_RRESP_SHIFT))

#define  POGO_OTODMA_POGO_ODMA_UDMA_UIER_BRESP_MASK 0x8
#define  POGO_OTODMA_POGO_ODMA_UDMA_UIER_BRESP_SHIFT 3
#define  POGO_OTODMA_POGO_ODMA_UDMA_UIER_BRESP_MASK_SHIFT(reg) (((reg) & POGO_OTODMA_POGO_ODMA_UDMA_UIER_BRESP_MASK) >> POGO_OTODMA_POGO_ODMA_UDMA_UIER_BRESP_SHIFT)
#define  POGO_OTODMA_POGO_ODMA_UDMA_UIER_BRESP_REPLACE_VAL(reg,val) (((reg) & ~POGO_OTODMA_POGO_ODMA_UDMA_UIER_BRESP_MASK) | (((uint32_t)val) << POGO_OTODMA_POGO_ODMA_UDMA_UIER_BRESP_SHIFT))

#define  POGO_OTODMA_POGO_ODMA_UDMA_UIER_CLEARCOMPLETE_MASK 0x4
#define  POGO_OTODMA_POGO_ODMA_UDMA_UIER_CLEARCOMPLETE_SHIFT 2
#define  POGO_OTODMA_POGO_ODMA_UDMA_UIER_CLEARCOMPLETE_MASK_SHIFT(reg) (((reg) & POGO_OTODMA_POGO_ODMA_UDMA_UIER_CLEARCOMPLETE_MASK) >> POGO_OTODMA_POGO_ODMA_UDMA_UIER_CLEARCOMPLETE_SHIFT)
#define  POGO_OTODMA_POGO_ODMA_UDMA_UIER_CLEARCOMPLETE_REPLACE_VAL(reg,val) (((reg) & ~POGO_OTODMA_POGO_ODMA_UDMA_UIER_CLEARCOMPLETE_MASK) | (((uint32_t)val) << POGO_OTODMA_POGO_ODMA_UDMA_UIER_CLEARCOMPLETE_SHIFT))

#define  POGO_OTODMA_POGO_ODMA_UDMA_UIER_DESC_MASK 0x2
#define  POGO_OTODMA_POGO_ODMA_UDMA_UIER_DESC_SHIFT 1
#define  POGO_OTODMA_POGO_ODMA_UDMA_UIER_DESC_MASK_SHIFT(reg) (((reg) & POGO_OTODMA_POGO_ODMA_UDMA_UIER_DESC_MASK) >> POGO_OTODMA_POGO_ODMA_UDMA_UIER_DESC_SHIFT)
#define  POGO_OTODMA_POGO_ODMA_UDMA_UIER_DESC_REPLACE_VAL(reg,val) (((reg) & ~POGO_OTODMA_POGO_ODMA_UDMA_UIER_DESC_MASK) | (((uint32_t)val) << POGO_OTODMA_POGO_ODMA_UDMA_UIER_DESC_SHIFT))

#define  POGO_OTODMA_POGO_ODMA_UDMA_UIER_OWN_MASK 0x1
#define  POGO_OTODMA_POGO_ODMA_UDMA_UIER_OWN_SHIFT 0
#define  POGO_OTODMA_POGO_ODMA_UDMA_UIER_OWN_MASK_SHIFT(reg) (((reg) & POGO_OTODMA_POGO_ODMA_UDMA_UIER_OWN_MASK) >> POGO_OTODMA_POGO_ODMA_UDMA_UIER_OWN_SHIFT)
#define  POGO_OTODMA_POGO_ODMA_UDMA_UIER_OWN_REPLACE_VAL(reg,val) (((reg) & ~POGO_OTODMA_POGO_ODMA_UDMA_UIER_OWN_MASK) | (((uint32_t)val) << POGO_OTODMA_POGO_ODMA_UDMA_UIER_OWN_SHIFT))

//====================================================================
//Register: UDMA Interrupt Pending Register (UIPR)
//====================================================================

#define  POGO_OTODMA_POGO_ODMA_UDMA_UIPR_RESERVED1_MASK 0xffffffc0
#define  POGO_OTODMA_POGO_ODMA_UDMA_UIPR_RESERVED1_SHIFT 6
#define  POGO_OTODMA_POGO_ODMA_UDMA_UIPR_RESERVED1_MASK_SHIFT(reg) (((reg) & POGO_OTODMA_POGO_ODMA_UDMA_UIPR_RESERVED1_MASK) >> POGO_OTODMA_POGO_ODMA_UDMA_UIPR_RESERVED1_SHIFT)
#define  POGO_OTODMA_POGO_ODMA_UDMA_UIPR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~POGO_OTODMA_POGO_ODMA_UDMA_UIPR_RESERVED1_MASK) | (((uint32_t)val) << POGO_OTODMA_POGO_ODMA_UDMA_UIPR_RESERVED1_SHIFT))

#define  POGO_OTODMA_POGO_ODMA_UDMA_UIPR_OUTOFRANGE_MASK 0x20
#define  POGO_OTODMA_POGO_ODMA_UDMA_UIPR_OUTOFRANGE_SHIFT 5
#define  POGO_OTODMA_POGO_ODMA_UDMA_UIPR_OUTOFRANGE_MASK_SHIFT(reg) (((reg) & POGO_OTODMA_POGO_ODMA_UDMA_UIPR_OUTOFRANGE_MASK) >> POGO_OTODMA_POGO_ODMA_UDMA_UIPR_OUTOFRANGE_SHIFT)
#define  POGO_OTODMA_POGO_ODMA_UDMA_UIPR_OUTOFRANGE_REPLACE_VAL(reg,val) (((reg) & ~POGO_OTODMA_POGO_ODMA_UDMA_UIPR_OUTOFRANGE_MASK) | (((uint32_t)val) << POGO_OTODMA_POGO_ODMA_UDMA_UIPR_OUTOFRANGE_SHIFT))

#define  POGO_OTODMA_POGO_ODMA_UDMA_UIPR_RRESP_MASK 0x10
#define  POGO_OTODMA_POGO_ODMA_UDMA_UIPR_RRESP_SHIFT 4
#define  POGO_OTODMA_POGO_ODMA_UDMA_UIPR_RRESP_MASK_SHIFT(reg) (((reg) & POGO_OTODMA_POGO_ODMA_UDMA_UIPR_RRESP_MASK) >> POGO_OTODMA_POGO_ODMA_UDMA_UIPR_RRESP_SHIFT)
#define  POGO_OTODMA_POGO_ODMA_UDMA_UIPR_RRESP_REPLACE_VAL(reg,val) (((reg) & ~POGO_OTODMA_POGO_ODMA_UDMA_UIPR_RRESP_MASK) | (((uint32_t)val) << POGO_OTODMA_POGO_ODMA_UDMA_UIPR_RRESP_SHIFT))

#define  POGO_OTODMA_POGO_ODMA_UDMA_UIPR_BRESP_MASK 0x8
#define  POGO_OTODMA_POGO_ODMA_UDMA_UIPR_BRESP_SHIFT 3
#define  POGO_OTODMA_POGO_ODMA_UDMA_UIPR_BRESP_MASK_SHIFT(reg) (((reg) & POGO_OTODMA_POGO_ODMA_UDMA_UIPR_BRESP_MASK) >> POGO_OTODMA_POGO_ODMA_UDMA_UIPR_BRESP_SHIFT)
#define  POGO_OTODMA_POGO_ODMA_UDMA_UIPR_BRESP_REPLACE_VAL(reg,val) (((reg) & ~POGO_OTODMA_POGO_ODMA_UDMA_UIPR_BRESP_MASK) | (((uint32_t)val) << POGO_OTODMA_POGO_ODMA_UDMA_UIPR_BRESP_SHIFT))

#define  POGO_OTODMA_POGO_ODMA_UDMA_UIPR_CLEARCOMPLETE_MASK 0x4
#define  POGO_OTODMA_POGO_ODMA_UDMA_UIPR_CLEARCOMPLETE_SHIFT 2
#define  POGO_OTODMA_POGO_ODMA_UDMA_UIPR_CLEARCOMPLETE_MASK_SHIFT(reg) (((reg) & POGO_OTODMA_POGO_ODMA_UDMA_UIPR_CLEARCOMPLETE_MASK) >> POGO_OTODMA_POGO_ODMA_UDMA_UIPR_CLEARCOMPLETE_SHIFT)
#define  POGO_OTODMA_POGO_ODMA_UDMA_UIPR_CLEARCOMPLETE_REPLACE_VAL(reg,val) (((reg) & ~POGO_OTODMA_POGO_ODMA_UDMA_UIPR_CLEARCOMPLETE_MASK) | (((uint32_t)val) << POGO_OTODMA_POGO_ODMA_UDMA_UIPR_CLEARCOMPLETE_SHIFT))

#define  POGO_OTODMA_POGO_ODMA_UDMA_UIPR_DESC_MASK 0x2
#define  POGO_OTODMA_POGO_ODMA_UDMA_UIPR_DESC_SHIFT 1
#define  POGO_OTODMA_POGO_ODMA_UDMA_UIPR_DESC_MASK_SHIFT(reg) (((reg) & POGO_OTODMA_POGO_ODMA_UDMA_UIPR_DESC_MASK) >> POGO_OTODMA_POGO_ODMA_UDMA_UIPR_DESC_SHIFT)
#define  POGO_OTODMA_POGO_ODMA_UDMA_UIPR_DESC_REPLACE_VAL(reg,val) (((reg) & ~POGO_OTODMA_POGO_ODMA_UDMA_UIPR_DESC_MASK) | (((uint32_t)val) << POGO_OTODMA_POGO_ODMA_UDMA_UIPR_DESC_SHIFT))

#define  POGO_OTODMA_POGO_ODMA_UDMA_UIPR_OWN_MASK 0x1
#define  POGO_OTODMA_POGO_ODMA_UDMA_UIPR_OWN_SHIFT 0
#define  POGO_OTODMA_POGO_ODMA_UDMA_UIPR_OWN_MASK_SHIFT(reg) (((reg) & POGO_OTODMA_POGO_ODMA_UDMA_UIPR_OWN_MASK) >> POGO_OTODMA_POGO_ODMA_UDMA_UIPR_OWN_SHIFT)
#define  POGO_OTODMA_POGO_ODMA_UDMA_UIPR_OWN_REPLACE_VAL(reg,val) (((reg) & ~POGO_OTODMA_POGO_ODMA_UDMA_UIPR_OWN_MASK) | (((uint32_t)val) << POGO_OTODMA_POGO_ODMA_UDMA_UIPR_OWN_SHIFT))

//====================================================================
//Register: UDMA Interrupt Clear Register (UICR)
//====================================================================

#define  POGO_OTODMA_POGO_ODMA_UDMA_UICR_RESERVED1_MASK 0xffffffc0
#define  POGO_OTODMA_POGO_ODMA_UDMA_UICR_RESERVED1_SHIFT 6
#define  POGO_OTODMA_POGO_ODMA_UDMA_UICR_RESERVED1_MASK_SHIFT(reg) (((reg) & POGO_OTODMA_POGO_ODMA_UDMA_UICR_RESERVED1_MASK) >> POGO_OTODMA_POGO_ODMA_UDMA_UICR_RESERVED1_SHIFT)
#define  POGO_OTODMA_POGO_ODMA_UDMA_UICR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~POGO_OTODMA_POGO_ODMA_UDMA_UICR_RESERVED1_MASK) | (((uint32_t)val) << POGO_OTODMA_POGO_ODMA_UDMA_UICR_RESERVED1_SHIFT))

#define  POGO_OTODMA_POGO_ODMA_UDMA_UICR_OUTOFRANGE_MASK 0x20
#define  POGO_OTODMA_POGO_ODMA_UDMA_UICR_OUTOFRANGE_SHIFT 5
#define  POGO_OTODMA_POGO_ODMA_UDMA_UICR_OUTOFRANGE_MASK_SHIFT(reg) (((reg) & POGO_OTODMA_POGO_ODMA_UDMA_UICR_OUTOFRANGE_MASK) >> POGO_OTODMA_POGO_ODMA_UDMA_UICR_OUTOFRANGE_SHIFT)
#define  POGO_OTODMA_POGO_ODMA_UDMA_UICR_OUTOFRANGE_REPLACE_VAL(reg,val) (((reg) & ~POGO_OTODMA_POGO_ODMA_UDMA_UICR_OUTOFRANGE_MASK) | (((uint32_t)val) << POGO_OTODMA_POGO_ODMA_UDMA_UICR_OUTOFRANGE_SHIFT))

#define  POGO_OTODMA_POGO_ODMA_UDMA_UICR_RRESP_MASK 0x10
#define  POGO_OTODMA_POGO_ODMA_UDMA_UICR_RRESP_SHIFT 4
#define  POGO_OTODMA_POGO_ODMA_UDMA_UICR_RRESP_MASK_SHIFT(reg) (((reg) & POGO_OTODMA_POGO_ODMA_UDMA_UICR_RRESP_MASK) >> POGO_OTODMA_POGO_ODMA_UDMA_UICR_RRESP_SHIFT)
#define  POGO_OTODMA_POGO_ODMA_UDMA_UICR_RRESP_REPLACE_VAL(reg,val) (((reg) & ~POGO_OTODMA_POGO_ODMA_UDMA_UICR_RRESP_MASK) | (((uint32_t)val) << POGO_OTODMA_POGO_ODMA_UDMA_UICR_RRESP_SHIFT))

#define  POGO_OTODMA_POGO_ODMA_UDMA_UICR_BRESP_MASK 0x8
#define  POGO_OTODMA_POGO_ODMA_UDMA_UICR_BRESP_SHIFT 3
#define  POGO_OTODMA_POGO_ODMA_UDMA_UICR_BRESP_MASK_SHIFT(reg) (((reg) & POGO_OTODMA_POGO_ODMA_UDMA_UICR_BRESP_MASK) >> POGO_OTODMA_POGO_ODMA_UDMA_UICR_BRESP_SHIFT)
#define  POGO_OTODMA_POGO_ODMA_UDMA_UICR_BRESP_REPLACE_VAL(reg,val) (((reg) & ~POGO_OTODMA_POGO_ODMA_UDMA_UICR_BRESP_MASK) | (((uint32_t)val) << POGO_OTODMA_POGO_ODMA_UDMA_UICR_BRESP_SHIFT))

#define  POGO_OTODMA_POGO_ODMA_UDMA_UICR_CLEARCOMPLETE_MASK 0x4
#define  POGO_OTODMA_POGO_ODMA_UDMA_UICR_CLEARCOMPLETE_SHIFT 2
#define  POGO_OTODMA_POGO_ODMA_UDMA_UICR_CLEARCOMPLETE_MASK_SHIFT(reg) (((reg) & POGO_OTODMA_POGO_ODMA_UDMA_UICR_CLEARCOMPLETE_MASK) >> POGO_OTODMA_POGO_ODMA_UDMA_UICR_CLEARCOMPLETE_SHIFT)
#define  POGO_OTODMA_POGO_ODMA_UDMA_UICR_CLEARCOMPLETE_REPLACE_VAL(reg,val) (((reg) & ~POGO_OTODMA_POGO_ODMA_UDMA_UICR_CLEARCOMPLETE_MASK) | (((uint32_t)val) << POGO_OTODMA_POGO_ODMA_UDMA_UICR_CLEARCOMPLETE_SHIFT))

#define  POGO_OTODMA_POGO_ODMA_UDMA_UICR_DESC_MASK 0x2
#define  POGO_OTODMA_POGO_ODMA_UDMA_UICR_DESC_SHIFT 1
#define  POGO_OTODMA_POGO_ODMA_UDMA_UICR_DESC_MASK_SHIFT(reg) (((reg) & POGO_OTODMA_POGO_ODMA_UDMA_UICR_DESC_MASK) >> POGO_OTODMA_POGO_ODMA_UDMA_UICR_DESC_SHIFT)
#define  POGO_OTODMA_POGO_ODMA_UDMA_UICR_DESC_REPLACE_VAL(reg,val) (((reg) & ~POGO_OTODMA_POGO_ODMA_UDMA_UICR_DESC_MASK) | (((uint32_t)val) << POGO_OTODMA_POGO_ODMA_UDMA_UICR_DESC_SHIFT))

#define  POGO_OTODMA_POGO_ODMA_UDMA_UICR_OWN_MASK 0x1
#define  POGO_OTODMA_POGO_ODMA_UDMA_UICR_OWN_SHIFT 0
#define  POGO_OTODMA_POGO_ODMA_UDMA_UICR_OWN_MASK_SHIFT(reg) (((reg) & POGO_OTODMA_POGO_ODMA_UDMA_UICR_OWN_MASK) >> POGO_OTODMA_POGO_ODMA_UDMA_UICR_OWN_SHIFT)
#define  POGO_OTODMA_POGO_ODMA_UDMA_UICR_OWN_REPLACE_VAL(reg,val) (((reg) & ~POGO_OTODMA_POGO_ODMA_UDMA_UICR_OWN_MASK) | (((uint32_t)val) << POGO_OTODMA_POGO_ODMA_UDMA_UICR_OWN_SHIFT))

//====================================================================
//Register: UDMA Interrupt Force Register (UIFR)
//====================================================================

#define  POGO_OTODMA_POGO_ODMA_UDMA_UIFR_RESERVED1_MASK 0xffffffc0
#define  POGO_OTODMA_POGO_ODMA_UDMA_UIFR_RESERVED1_SHIFT 6
#define  POGO_OTODMA_POGO_ODMA_UDMA_UIFR_RESERVED1_MASK_SHIFT(reg) (((reg) & POGO_OTODMA_POGO_ODMA_UDMA_UIFR_RESERVED1_MASK) >> POGO_OTODMA_POGO_ODMA_UDMA_UIFR_RESERVED1_SHIFT)
#define  POGO_OTODMA_POGO_ODMA_UDMA_UIFR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~POGO_OTODMA_POGO_ODMA_UDMA_UIFR_RESERVED1_MASK) | (((uint32_t)val) << POGO_OTODMA_POGO_ODMA_UDMA_UIFR_RESERVED1_SHIFT))

#define  POGO_OTODMA_POGO_ODMA_UDMA_UIFR_OUTOFRANGE_MASK 0x20
#define  POGO_OTODMA_POGO_ODMA_UDMA_UIFR_OUTOFRANGE_SHIFT 5
#define  POGO_OTODMA_POGO_ODMA_UDMA_UIFR_OUTOFRANGE_MASK_SHIFT(reg) (((reg) & POGO_OTODMA_POGO_ODMA_UDMA_UIFR_OUTOFRANGE_MASK) >> POGO_OTODMA_POGO_ODMA_UDMA_UIFR_OUTOFRANGE_SHIFT)
#define  POGO_OTODMA_POGO_ODMA_UDMA_UIFR_OUTOFRANGE_REPLACE_VAL(reg,val) (((reg) & ~POGO_OTODMA_POGO_ODMA_UDMA_UIFR_OUTOFRANGE_MASK) | (((uint32_t)val) << POGO_OTODMA_POGO_ODMA_UDMA_UIFR_OUTOFRANGE_SHIFT))

#define  POGO_OTODMA_POGO_ODMA_UDMA_UIFR_RRESP_MASK 0x10
#define  POGO_OTODMA_POGO_ODMA_UDMA_UIFR_RRESP_SHIFT 4
#define  POGO_OTODMA_POGO_ODMA_UDMA_UIFR_RRESP_MASK_SHIFT(reg) (((reg) & POGO_OTODMA_POGO_ODMA_UDMA_UIFR_RRESP_MASK) >> POGO_OTODMA_POGO_ODMA_UDMA_UIFR_RRESP_SHIFT)
#define  POGO_OTODMA_POGO_ODMA_UDMA_UIFR_RRESP_REPLACE_VAL(reg,val) (((reg) & ~POGO_OTODMA_POGO_ODMA_UDMA_UIFR_RRESP_MASK) | (((uint32_t)val) << POGO_OTODMA_POGO_ODMA_UDMA_UIFR_RRESP_SHIFT))

#define  POGO_OTODMA_POGO_ODMA_UDMA_UIFR_BRESP_MASK 0x8
#define  POGO_OTODMA_POGO_ODMA_UDMA_UIFR_BRESP_SHIFT 3
#define  POGO_OTODMA_POGO_ODMA_UDMA_UIFR_BRESP_MASK_SHIFT(reg) (((reg) & POGO_OTODMA_POGO_ODMA_UDMA_UIFR_BRESP_MASK) >> POGO_OTODMA_POGO_ODMA_UDMA_UIFR_BRESP_SHIFT)
#define  POGO_OTODMA_POGO_ODMA_UDMA_UIFR_BRESP_REPLACE_VAL(reg,val) (((reg) & ~POGO_OTODMA_POGO_ODMA_UDMA_UIFR_BRESP_MASK) | (((uint32_t)val) << POGO_OTODMA_POGO_ODMA_UDMA_UIFR_BRESP_SHIFT))

#define  POGO_OTODMA_POGO_ODMA_UDMA_UIFR_CLEARCOMPLETE_MASK 0x4
#define  POGO_OTODMA_POGO_ODMA_UDMA_UIFR_CLEARCOMPLETE_SHIFT 2
#define  POGO_OTODMA_POGO_ODMA_UDMA_UIFR_CLEARCOMPLETE_MASK_SHIFT(reg) (((reg) & POGO_OTODMA_POGO_ODMA_UDMA_UIFR_CLEARCOMPLETE_MASK) >> POGO_OTODMA_POGO_ODMA_UDMA_UIFR_CLEARCOMPLETE_SHIFT)
#define  POGO_OTODMA_POGO_ODMA_UDMA_UIFR_CLEARCOMPLETE_REPLACE_VAL(reg,val) (((reg) & ~POGO_OTODMA_POGO_ODMA_UDMA_UIFR_CLEARCOMPLETE_MASK) | (((uint32_t)val) << POGO_OTODMA_POGO_ODMA_UDMA_UIFR_CLEARCOMPLETE_SHIFT))

#define  POGO_OTODMA_POGO_ODMA_UDMA_UIFR_DESC_MASK 0x2
#define  POGO_OTODMA_POGO_ODMA_UDMA_UIFR_DESC_SHIFT 1
#define  POGO_OTODMA_POGO_ODMA_UDMA_UIFR_DESC_MASK_SHIFT(reg) (((reg) & POGO_OTODMA_POGO_ODMA_UDMA_UIFR_DESC_MASK) >> POGO_OTODMA_POGO_ODMA_UDMA_UIFR_DESC_SHIFT)
#define  POGO_OTODMA_POGO_ODMA_UDMA_UIFR_DESC_REPLACE_VAL(reg,val) (((reg) & ~POGO_OTODMA_POGO_ODMA_UDMA_UIFR_DESC_MASK) | (((uint32_t)val) << POGO_OTODMA_POGO_ODMA_UDMA_UIFR_DESC_SHIFT))

#define  POGO_OTODMA_POGO_ODMA_UDMA_UIFR_OWN_MASK 0x1
#define  POGO_OTODMA_POGO_ODMA_UDMA_UIFR_OWN_SHIFT 0
#define  POGO_OTODMA_POGO_ODMA_UDMA_UIFR_OWN_MASK_SHIFT(reg) (((reg) & POGO_OTODMA_POGO_ODMA_UDMA_UIFR_OWN_MASK) >> POGO_OTODMA_POGO_ODMA_UDMA_UIFR_OWN_SHIFT)
#define  POGO_OTODMA_POGO_ODMA_UDMA_UIFR_OWN_REPLACE_VAL(reg,val) (((reg) & ~POGO_OTODMA_POGO_ODMA_UDMA_UIFR_OWN_MASK) | (((uint32_t)val) << POGO_OTODMA_POGO_ODMA_UDMA_UIFR_OWN_SHIFT))

//====================================================================
//Register: UDMA Descriptor Register (UDR)
//====================================================================

#define  POGO_OTODMA_POGO_ODMA_UDMA_UDR_DESC_MASK 0xffffffff
#define  POGO_OTODMA_POGO_ODMA_UDMA_UDR_DESC_SHIFT 0
#define  POGO_OTODMA_POGO_ODMA_UDMA_UDR_DESC_MASK_SHIFT(reg) (((reg) & POGO_OTODMA_POGO_ODMA_UDMA_UDR_DESC_MASK) >> POGO_OTODMA_POGO_ODMA_UDMA_UDR_DESC_SHIFT)
#define  POGO_OTODMA_POGO_ODMA_UDMA_UDR_DESC_REPLACE_VAL(reg,val) (((reg) & ~POGO_OTODMA_POGO_ODMA_UDMA_UDR_DESC_MASK) | (((uint32_t)val) << POGO_OTODMA_POGO_ODMA_UDMA_UDR_DESC_SHIFT))

//====================================================================
//Register: UDMA Burst Address Register (UBAR)
//====================================================================

#define  POGO_OTODMA_POGO_ODMA_UDMA_UBAR_BURSTADDR_MASK 0xffffffff
#define  POGO_OTODMA_POGO_ODMA_UDMA_UBAR_BURSTADDR_SHIFT 0
#define  POGO_OTODMA_POGO_ODMA_UDMA_UBAR_BURSTADDR_MASK_SHIFT(reg) (((reg) & POGO_OTODMA_POGO_ODMA_UDMA_UBAR_BURSTADDR_MASK) >> POGO_OTODMA_POGO_ODMA_UDMA_UBAR_BURSTADDR_SHIFT)
#define  POGO_OTODMA_POGO_ODMA_UDMA_UBAR_BURSTADDR_REPLACE_VAL(reg,val) (((reg) & ~POGO_OTODMA_POGO_ODMA_UDMA_UBAR_BURSTADDR_MASK) | (((uint32_t)val) << POGO_OTODMA_POGO_ODMA_UDMA_UBAR_BURSTADDR_SHIFT))

//====================================================================
//Register: UDMA Burst Length Register (UBLR)
//====================================================================

#define  POGO_OTODMA_POGO_ODMA_UDMA_UBLR_RESERVED1_MASK 0xfffffc00
#define  POGO_OTODMA_POGO_ODMA_UDMA_UBLR_RESERVED1_SHIFT 10
#define  POGO_OTODMA_POGO_ODMA_UDMA_UBLR_RESERVED1_MASK_SHIFT(reg) (((reg) & POGO_OTODMA_POGO_ODMA_UDMA_UBLR_RESERVED1_MASK) >> POGO_OTODMA_POGO_ODMA_UDMA_UBLR_RESERVED1_SHIFT)
#define  POGO_OTODMA_POGO_ODMA_UDMA_UBLR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~POGO_OTODMA_POGO_ODMA_UDMA_UBLR_RESERVED1_MASK) | (((uint32_t)val) << POGO_OTODMA_POGO_ODMA_UDMA_UBLR_RESERVED1_SHIFT))

#define  POGO_OTODMA_POGO_ODMA_UDMA_UBLR_BURSTDIR_MASK 0x200
#define  POGO_OTODMA_POGO_ODMA_UDMA_UBLR_BURSTDIR_SHIFT 9
#define  POGO_OTODMA_POGO_ODMA_UDMA_UBLR_BURSTDIR_MASK_SHIFT(reg) (((reg) & POGO_OTODMA_POGO_ODMA_UDMA_UBLR_BURSTDIR_MASK) >> POGO_OTODMA_POGO_ODMA_UDMA_UBLR_BURSTDIR_SHIFT)
#define  POGO_OTODMA_POGO_ODMA_UDMA_UBLR_BURSTDIR_REPLACE_VAL(reg,val) (((reg) & ~POGO_OTODMA_POGO_ODMA_UDMA_UBLR_BURSTDIR_MASK) | (((uint32_t)val) << POGO_OTODMA_POGO_ODMA_UDMA_UBLR_BURSTDIR_SHIFT))

#define  POGO_OTODMA_POGO_ODMA_UDMA_UBLR_BURSTLAST_MASK 0x100
#define  POGO_OTODMA_POGO_ODMA_UDMA_UBLR_BURSTLAST_SHIFT 8
#define  POGO_OTODMA_POGO_ODMA_UDMA_UBLR_BURSTLAST_MASK_SHIFT(reg) (((reg) & POGO_OTODMA_POGO_ODMA_UDMA_UBLR_BURSTLAST_MASK) >> POGO_OTODMA_POGO_ODMA_UDMA_UBLR_BURSTLAST_SHIFT)
#define  POGO_OTODMA_POGO_ODMA_UDMA_UBLR_BURSTLAST_REPLACE_VAL(reg,val) (((reg) & ~POGO_OTODMA_POGO_ODMA_UDMA_UBLR_BURSTLAST_MASK) | (((uint32_t)val) << POGO_OTODMA_POGO_ODMA_UDMA_UBLR_BURSTLAST_SHIFT))

#define  POGO_OTODMA_POGO_ODMA_UDMA_UBLR_BURSTLENGTH_MASK 0xff
#define  POGO_OTODMA_POGO_ODMA_UDMA_UBLR_BURSTLENGTH_SHIFT 0
#define  POGO_OTODMA_POGO_ODMA_UDMA_UBLR_BURSTLENGTH_MASK_SHIFT(reg) (((reg) & POGO_OTODMA_POGO_ODMA_UDMA_UBLR_BURSTLENGTH_MASK) >> POGO_OTODMA_POGO_ODMA_UDMA_UBLR_BURSTLENGTH_SHIFT)
#define  POGO_OTODMA_POGO_ODMA_UDMA_UBLR_BURSTLENGTH_REPLACE_VAL(reg,val) (((reg) & ~POGO_OTODMA_POGO_ODMA_UDMA_UBLR_BURSTLENGTH_MASK) | (((uint32_t)val) << POGO_OTODMA_POGO_ODMA_UDMA_UBLR_BURSTLENGTH_SHIFT))

//====================================================================
//Register: UDMA Transfer Bytes Remaining Register (UBRR)
//====================================================================

#define  POGO_OTODMA_POGO_ODMA_UDMA_UBRR_BYTESREMAIN_MASK 0xffffffff
#define  POGO_OTODMA_POGO_ODMA_UDMA_UBRR_BYTESREMAIN_SHIFT 0
#define  POGO_OTODMA_POGO_ODMA_UDMA_UBRR_BYTESREMAIN_MASK_SHIFT(reg) (((reg) & POGO_OTODMA_POGO_ODMA_UDMA_UBRR_BYTESREMAIN_MASK) >> POGO_OTODMA_POGO_ODMA_UDMA_UBRR_BYTESREMAIN_SHIFT)
#define  POGO_OTODMA_POGO_ODMA_UDMA_UBRR_BYTESREMAIN_REPLACE_VAL(reg,val) (((reg) & ~POGO_OTODMA_POGO_ODMA_UDMA_UBRR_BYTESREMAIN_MASK) | (((uint32_t)val) << POGO_OTODMA_POGO_ODMA_UDMA_UBRR_BYTESREMAIN_SHIFT))

//====================================================================
//Register: UDMA Tag Register 0 (UTR0)
//====================================================================

#define  POGO_OTODMA_POGO_ODMA_UDMA_UTR0_TAGMAJ_MASK 0xffff0000
#define  POGO_OTODMA_POGO_ODMA_UDMA_UTR0_TAGMAJ_SHIFT 16
#define  POGO_OTODMA_POGO_ODMA_UDMA_UTR0_TAGMAJ_MASK_SHIFT(reg) (((reg) & POGO_OTODMA_POGO_ODMA_UDMA_UTR0_TAGMAJ_MASK) >> POGO_OTODMA_POGO_ODMA_UDMA_UTR0_TAGMAJ_SHIFT)
#define  POGO_OTODMA_POGO_ODMA_UDMA_UTR0_TAGMAJ_REPLACE_VAL(reg,val) (((reg) & ~POGO_OTODMA_POGO_ODMA_UDMA_UTR0_TAGMAJ_MASK) | (((uint32_t)val) << POGO_OTODMA_POGO_ODMA_UDMA_UTR0_TAGMAJ_SHIFT))

#define  POGO_OTODMA_POGO_ODMA_UDMA_UTR0_TAGMID_MASK 0xffff
#define  POGO_OTODMA_POGO_ODMA_UDMA_UTR0_TAGMID_SHIFT 0
#define  POGO_OTODMA_POGO_ODMA_UDMA_UTR0_TAGMID_MASK_SHIFT(reg) (((reg) & POGO_OTODMA_POGO_ODMA_UDMA_UTR0_TAGMID_MASK) >> POGO_OTODMA_POGO_ODMA_UDMA_UTR0_TAGMID_SHIFT)
#define  POGO_OTODMA_POGO_ODMA_UDMA_UTR0_TAGMID_REPLACE_VAL(reg,val) (((reg) & ~POGO_OTODMA_POGO_ODMA_UDMA_UTR0_TAGMID_MASK) | (((uint32_t)val) << POGO_OTODMA_POGO_ODMA_UDMA_UTR0_TAGMID_SHIFT))

//====================================================================
//Register: UDMA Tag Register 1 (UTR1)
//====================================================================

#define  POGO_OTODMA_POGO_ODMA_UDMA_UTR1_RESERVED1_MASK 0xffff0000
#define  POGO_OTODMA_POGO_ODMA_UDMA_UTR1_RESERVED1_SHIFT 16
#define  POGO_OTODMA_POGO_ODMA_UDMA_UTR1_RESERVED1_MASK_SHIFT(reg) (((reg) & POGO_OTODMA_POGO_ODMA_UDMA_UTR1_RESERVED1_MASK) >> POGO_OTODMA_POGO_ODMA_UDMA_UTR1_RESERVED1_SHIFT)
#define  POGO_OTODMA_POGO_ODMA_UDMA_UTR1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~POGO_OTODMA_POGO_ODMA_UDMA_UTR1_RESERVED1_MASK) | (((uint32_t)val) << POGO_OTODMA_POGO_ODMA_UDMA_UTR1_RESERVED1_SHIFT))

#define  POGO_OTODMA_POGO_ODMA_UDMA_UTR1_TAGCFG_MASK 0xffff
#define  POGO_OTODMA_POGO_ODMA_UDMA_UTR1_TAGCFG_SHIFT 0
#define  POGO_OTODMA_POGO_ODMA_UDMA_UTR1_TAGCFG_MASK_SHIFT(reg) (((reg) & POGO_OTODMA_POGO_ODMA_UDMA_UTR1_TAGCFG_MASK) >> POGO_OTODMA_POGO_ODMA_UDMA_UTR1_TAGCFG_SHIFT)
#define  POGO_OTODMA_POGO_ODMA_UDMA_UTR1_TAGCFG_REPLACE_VAL(reg,val) (((reg) & ~POGO_OTODMA_POGO_ODMA_UDMA_UTR1_TAGCFG_MASK) | (((uint32_t)val) << POGO_OTODMA_POGO_ODMA_UDMA_UTR1_TAGCFG_SHIFT))

//====================================================================
//
//Register File: POGO_ODMA_CORE (POGO_OTODMA_POGO_ODMA_CORE)
//
//====================================================================

//====================================================================
//Register: ODMA Interrupt Enable Register (OIER)
//====================================================================

#define  POGO_OTODMA_POGO_ODMA_CORE_OIER_RESERVED1_MASK 0xfffffffc
#define  POGO_OTODMA_POGO_ODMA_CORE_OIER_RESERVED1_SHIFT 2
#define  POGO_OTODMA_POGO_ODMA_CORE_OIER_RESERVED1_MASK_SHIFT(reg) (((reg) & POGO_OTODMA_POGO_ODMA_CORE_OIER_RESERVED1_MASK) >> POGO_OTODMA_POGO_ODMA_CORE_OIER_RESERVED1_SHIFT)
#define  POGO_OTODMA_POGO_ODMA_CORE_OIER_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~POGO_OTODMA_POGO_ODMA_CORE_OIER_RESERVED1_MASK) | (((uint32_t)val) << POGO_OTODMA_POGO_ODMA_CORE_OIER_RESERVED1_SHIFT))

#define  POGO_OTODMA_POGO_ODMA_CORE_OIER_LENGTHERR_MASK 0x2
#define  POGO_OTODMA_POGO_ODMA_CORE_OIER_LENGTHERR_SHIFT 1
#define  POGO_OTODMA_POGO_ODMA_CORE_OIER_LENGTHERR_MASK_SHIFT(reg) (((reg) & POGO_OTODMA_POGO_ODMA_CORE_OIER_LENGTHERR_MASK) >> POGO_OTODMA_POGO_ODMA_CORE_OIER_LENGTHERR_SHIFT)
#define  POGO_OTODMA_POGO_ODMA_CORE_OIER_LENGTHERR_REPLACE_VAL(reg,val) (((reg) & ~POGO_OTODMA_POGO_ODMA_CORE_OIER_LENGTHERR_MASK) | (((uint32_t)val) << POGO_OTODMA_POGO_ODMA_CORE_OIER_LENGTHERR_SHIFT))

#define  POGO_OTODMA_POGO_ODMA_CORE_OIER_EOS_MASK 0x1
#define  POGO_OTODMA_POGO_ODMA_CORE_OIER_EOS_SHIFT 0
#define  POGO_OTODMA_POGO_ODMA_CORE_OIER_EOS_MASK_SHIFT(reg) (((reg) & POGO_OTODMA_POGO_ODMA_CORE_OIER_EOS_MASK) >> POGO_OTODMA_POGO_ODMA_CORE_OIER_EOS_SHIFT)
#define  POGO_OTODMA_POGO_ODMA_CORE_OIER_EOS_REPLACE_VAL(reg,val) (((reg) & ~POGO_OTODMA_POGO_ODMA_CORE_OIER_EOS_MASK) | (((uint32_t)val) << POGO_OTODMA_POGO_ODMA_CORE_OIER_EOS_SHIFT))

//====================================================================
//Register: ODMA Interrupt Pending Register (OIPR)
//====================================================================

#define  POGO_OTODMA_POGO_ODMA_CORE_OIPR_RESERVED1_MASK 0xfffffffc
#define  POGO_OTODMA_POGO_ODMA_CORE_OIPR_RESERVED1_SHIFT 2
#define  POGO_OTODMA_POGO_ODMA_CORE_OIPR_RESERVED1_MASK_SHIFT(reg) (((reg) & POGO_OTODMA_POGO_ODMA_CORE_OIPR_RESERVED1_MASK) >> POGO_OTODMA_POGO_ODMA_CORE_OIPR_RESERVED1_SHIFT)
#define  POGO_OTODMA_POGO_ODMA_CORE_OIPR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~POGO_OTODMA_POGO_ODMA_CORE_OIPR_RESERVED1_MASK) | (((uint32_t)val) << POGO_OTODMA_POGO_ODMA_CORE_OIPR_RESERVED1_SHIFT))

#define  POGO_OTODMA_POGO_ODMA_CORE_OIPR_LENGTHERR_MASK 0x2
#define  POGO_OTODMA_POGO_ODMA_CORE_OIPR_LENGTHERR_SHIFT 1
#define  POGO_OTODMA_POGO_ODMA_CORE_OIPR_LENGTHERR_MASK_SHIFT(reg) (((reg) & POGO_OTODMA_POGO_ODMA_CORE_OIPR_LENGTHERR_MASK) >> POGO_OTODMA_POGO_ODMA_CORE_OIPR_LENGTHERR_SHIFT)
#define  POGO_OTODMA_POGO_ODMA_CORE_OIPR_LENGTHERR_REPLACE_VAL(reg,val) (((reg) & ~POGO_OTODMA_POGO_ODMA_CORE_OIPR_LENGTHERR_MASK) | (((uint32_t)val) << POGO_OTODMA_POGO_ODMA_CORE_OIPR_LENGTHERR_SHIFT))

#define  POGO_OTODMA_POGO_ODMA_CORE_OIPR_EOS_MASK 0x1
#define  POGO_OTODMA_POGO_ODMA_CORE_OIPR_EOS_SHIFT 0
#define  POGO_OTODMA_POGO_ODMA_CORE_OIPR_EOS_MASK_SHIFT(reg) (((reg) & POGO_OTODMA_POGO_ODMA_CORE_OIPR_EOS_MASK) >> POGO_OTODMA_POGO_ODMA_CORE_OIPR_EOS_SHIFT)
#define  POGO_OTODMA_POGO_ODMA_CORE_OIPR_EOS_REPLACE_VAL(reg,val) (((reg) & ~POGO_OTODMA_POGO_ODMA_CORE_OIPR_EOS_MASK) | (((uint32_t)val) << POGO_OTODMA_POGO_ODMA_CORE_OIPR_EOS_SHIFT))

//====================================================================
//Register: ODMA Interrupt Clear Register (OICR)
//====================================================================

#define  POGO_OTODMA_POGO_ODMA_CORE_OICR_RESERVED1_MASK 0xfffffffc
#define  POGO_OTODMA_POGO_ODMA_CORE_OICR_RESERVED1_SHIFT 2
#define  POGO_OTODMA_POGO_ODMA_CORE_OICR_RESERVED1_MASK_SHIFT(reg) (((reg) & POGO_OTODMA_POGO_ODMA_CORE_OICR_RESERVED1_MASK) >> POGO_OTODMA_POGO_ODMA_CORE_OICR_RESERVED1_SHIFT)
#define  POGO_OTODMA_POGO_ODMA_CORE_OICR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~POGO_OTODMA_POGO_ODMA_CORE_OICR_RESERVED1_MASK) | (((uint32_t)val) << POGO_OTODMA_POGO_ODMA_CORE_OICR_RESERVED1_SHIFT))

#define  POGO_OTODMA_POGO_ODMA_CORE_OICR_LENGTHERR_MASK 0x2
#define  POGO_OTODMA_POGO_ODMA_CORE_OICR_LENGTHERR_SHIFT 1
#define  POGO_OTODMA_POGO_ODMA_CORE_OICR_LENGTHERR_MASK_SHIFT(reg) (((reg) & POGO_OTODMA_POGO_ODMA_CORE_OICR_LENGTHERR_MASK) >> POGO_OTODMA_POGO_ODMA_CORE_OICR_LENGTHERR_SHIFT)
#define  POGO_OTODMA_POGO_ODMA_CORE_OICR_LENGTHERR_REPLACE_VAL(reg,val) (((reg) & ~POGO_OTODMA_POGO_ODMA_CORE_OICR_LENGTHERR_MASK) | (((uint32_t)val) << POGO_OTODMA_POGO_ODMA_CORE_OICR_LENGTHERR_SHIFT))

#define  POGO_OTODMA_POGO_ODMA_CORE_OICR_EOS_MASK 0x1
#define  POGO_OTODMA_POGO_ODMA_CORE_OICR_EOS_SHIFT 0
#define  POGO_OTODMA_POGO_ODMA_CORE_OICR_EOS_MASK_SHIFT(reg) (((reg) & POGO_OTODMA_POGO_ODMA_CORE_OICR_EOS_MASK) >> POGO_OTODMA_POGO_ODMA_CORE_OICR_EOS_SHIFT)
#define  POGO_OTODMA_POGO_ODMA_CORE_OICR_EOS_REPLACE_VAL(reg,val) (((reg) & ~POGO_OTODMA_POGO_ODMA_CORE_OICR_EOS_MASK) | (((uint32_t)val) << POGO_OTODMA_POGO_ODMA_CORE_OICR_EOS_SHIFT))

//====================================================================
//Register: ODMA Interrupt Force Register (OIFR)
//====================================================================

#define  POGO_OTODMA_POGO_ODMA_CORE_OIFR_RESERVED1_MASK 0xfffffffc
#define  POGO_OTODMA_POGO_ODMA_CORE_OIFR_RESERVED1_SHIFT 2
#define  POGO_OTODMA_POGO_ODMA_CORE_OIFR_RESERVED1_MASK_SHIFT(reg) (((reg) & POGO_OTODMA_POGO_ODMA_CORE_OIFR_RESERVED1_MASK) >> POGO_OTODMA_POGO_ODMA_CORE_OIFR_RESERVED1_SHIFT)
#define  POGO_OTODMA_POGO_ODMA_CORE_OIFR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~POGO_OTODMA_POGO_ODMA_CORE_OIFR_RESERVED1_MASK) | (((uint32_t)val) << POGO_OTODMA_POGO_ODMA_CORE_OIFR_RESERVED1_SHIFT))

#define  POGO_OTODMA_POGO_ODMA_CORE_OIFR_LENGTHERR_MASK 0x2
#define  POGO_OTODMA_POGO_ODMA_CORE_OIFR_LENGTHERR_SHIFT 1
#define  POGO_OTODMA_POGO_ODMA_CORE_OIFR_LENGTHERR_MASK_SHIFT(reg) (((reg) & POGO_OTODMA_POGO_ODMA_CORE_OIFR_LENGTHERR_MASK) >> POGO_OTODMA_POGO_ODMA_CORE_OIFR_LENGTHERR_SHIFT)
#define  POGO_OTODMA_POGO_ODMA_CORE_OIFR_LENGTHERR_REPLACE_VAL(reg,val) (((reg) & ~POGO_OTODMA_POGO_ODMA_CORE_OIFR_LENGTHERR_MASK) | (((uint32_t)val) << POGO_OTODMA_POGO_ODMA_CORE_OIFR_LENGTHERR_SHIFT))

#define  POGO_OTODMA_POGO_ODMA_CORE_OIFR_EOS_MASK 0x1
#define  POGO_OTODMA_POGO_ODMA_CORE_OIFR_EOS_SHIFT 0
#define  POGO_OTODMA_POGO_ODMA_CORE_OIFR_EOS_MASK_SHIFT(reg) (((reg) & POGO_OTODMA_POGO_ODMA_CORE_OIFR_EOS_MASK) >> POGO_OTODMA_POGO_ODMA_CORE_OIFR_EOS_SHIFT)
#define  POGO_OTODMA_POGO_ODMA_CORE_OIFR_EOS_REPLACE_VAL(reg,val) (((reg) & ~POGO_OTODMA_POGO_ODMA_CORE_OIFR_EOS_MASK) | (((uint32_t)val) << POGO_OTODMA_POGO_ODMA_CORE_OIFR_EOS_SHIFT))

//====================================================================
//Register: ODMA Line Width Register (OLWR)
//====================================================================

#define  POGO_OTODMA_POGO_ODMA_CORE_OLWR_RESERVED1_MASK 0xfff00000
#define  POGO_OTODMA_POGO_ODMA_CORE_OLWR_RESERVED1_SHIFT 20
#define  POGO_OTODMA_POGO_ODMA_CORE_OLWR_RESERVED1_MASK_SHIFT(reg) (((reg) & POGO_OTODMA_POGO_ODMA_CORE_OLWR_RESERVED1_MASK) >> POGO_OTODMA_POGO_ODMA_CORE_OLWR_RESERVED1_SHIFT)
#define  POGO_OTODMA_POGO_ODMA_CORE_OLWR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~POGO_OTODMA_POGO_ODMA_CORE_OLWR_RESERVED1_MASK) | (((uint32_t)val) << POGO_OTODMA_POGO_ODMA_CORE_OLWR_RESERVED1_SHIFT))

#define  POGO_OTODMA_POGO_ODMA_CORE_OLWR_LINEWIDTH_MASK 0xfffff
#define  POGO_OTODMA_POGO_ODMA_CORE_OLWR_LINEWIDTH_SHIFT 0
#define  POGO_OTODMA_POGO_ODMA_CORE_OLWR_LINEWIDTH_MASK_SHIFT(reg) (((reg) & POGO_OTODMA_POGO_ODMA_CORE_OLWR_LINEWIDTH_MASK) >> POGO_OTODMA_POGO_ODMA_CORE_OLWR_LINEWIDTH_SHIFT)
#define  POGO_OTODMA_POGO_ODMA_CORE_OLWR_LINEWIDTH_REPLACE_VAL(reg,val) (((reg) & ~POGO_OTODMA_POGO_ODMA_CORE_OLWR_LINEWIDTH_MASK) | (((uint32_t)val) << POGO_OTODMA_POGO_ODMA_CORE_OLWR_LINEWIDTH_SHIFT))

//====================================================================
//Register: ODMA Control Register (OCNTRL)
//====================================================================

#define  POGO_OTODMA_POGO_ODMA_CORE_OCNTRL_RESERVED1_MASK 0xfffffffc
#define  POGO_OTODMA_POGO_ODMA_CORE_OCNTRL_RESERVED1_SHIFT 2
#define  POGO_OTODMA_POGO_ODMA_CORE_OCNTRL_RESERVED1_MASK_SHIFT(reg) (((reg) & POGO_OTODMA_POGO_ODMA_CORE_OCNTRL_RESERVED1_MASK) >> POGO_OTODMA_POGO_ODMA_CORE_OCNTRL_RESERVED1_SHIFT)
#define  POGO_OTODMA_POGO_ODMA_CORE_OCNTRL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~POGO_OTODMA_POGO_ODMA_CORE_OCNTRL_RESERVED1_MASK) | (((uint32_t)val) << POGO_OTODMA_POGO_ODMA_CORE_OCNTRL_RESERVED1_SHIFT))

#define  POGO_OTODMA_POGO_ODMA_CORE_OCNTRL_LINEREVERSE_MASK 0x2
#define  POGO_OTODMA_POGO_ODMA_CORE_OCNTRL_LINEREVERSE_SHIFT 1
#define  POGO_OTODMA_POGO_ODMA_CORE_OCNTRL_LINEREVERSE_MASK_SHIFT(reg) (((reg) & POGO_OTODMA_POGO_ODMA_CORE_OCNTRL_LINEREVERSE_MASK) >> POGO_OTODMA_POGO_ODMA_CORE_OCNTRL_LINEREVERSE_SHIFT)
#define  POGO_OTODMA_POGO_ODMA_CORE_OCNTRL_LINEREVERSE_REPLACE_VAL(reg,val) (((reg) & ~POGO_OTODMA_POGO_ODMA_CORE_OCNTRL_LINEREVERSE_MASK) | (((uint32_t)val) << POGO_OTODMA_POGO_ODMA_CORE_OCNTRL_LINEREVERSE_SHIFT))

#define  POGO_OTODMA_POGO_ODMA_CORE_OCNTRL_DUMPENABLE_MASK 0x1
#define  POGO_OTODMA_POGO_ODMA_CORE_OCNTRL_DUMPENABLE_SHIFT 0
#define  POGO_OTODMA_POGO_ODMA_CORE_OCNTRL_DUMPENABLE_MASK_SHIFT(reg) (((reg) & POGO_OTODMA_POGO_ODMA_CORE_OCNTRL_DUMPENABLE_MASK) >> POGO_OTODMA_POGO_ODMA_CORE_OCNTRL_DUMPENABLE_SHIFT)
#define  POGO_OTODMA_POGO_ODMA_CORE_OCNTRL_DUMPENABLE_REPLACE_VAL(reg,val) (((reg) & ~POGO_OTODMA_POGO_ODMA_CORE_OCNTRL_DUMPENABLE_MASK) | (((uint32_t)val) << POGO_OTODMA_POGO_ODMA_CORE_OCNTRL_DUMPENABLE_SHIFT))

//====================================================================
//Register: ODMA Tag Register 0 (OTR0)
//====================================================================

#define  POGO_OTODMA_POGO_ODMA_CORE_OTR0_RESERVED1_MASK 0xffff0000
#define  POGO_OTODMA_POGO_ODMA_CORE_OTR0_RESERVED1_SHIFT 16
#define  POGO_OTODMA_POGO_ODMA_CORE_OTR0_RESERVED1_MASK_SHIFT(reg) (((reg) & POGO_OTODMA_POGO_ODMA_CORE_OTR0_RESERVED1_MASK) >> POGO_OTODMA_POGO_ODMA_CORE_OTR0_RESERVED1_SHIFT)
#define  POGO_OTODMA_POGO_ODMA_CORE_OTR0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~POGO_OTODMA_POGO_ODMA_CORE_OTR0_RESERVED1_MASK) | (((uint32_t)val) << POGO_OTODMA_POGO_ODMA_CORE_OTR0_RESERVED1_SHIFT))

#define  POGO_OTODMA_POGO_ODMA_CORE_OTR0_TAGCFG_MASK 0xffff
#define  POGO_OTODMA_POGO_ODMA_CORE_OTR0_TAGCFG_SHIFT 0
#define  POGO_OTODMA_POGO_ODMA_CORE_OTR0_TAGCFG_MASK_SHIFT(reg) (((reg) & POGO_OTODMA_POGO_ODMA_CORE_OTR0_TAGCFG_MASK) >> POGO_OTODMA_POGO_ODMA_CORE_OTR0_TAGCFG_SHIFT)
#define  POGO_OTODMA_POGO_ODMA_CORE_OTR0_TAGCFG_REPLACE_VAL(reg,val) (((reg) & ~POGO_OTODMA_POGO_ODMA_CORE_OTR0_TAGCFG_MASK) | (((uint32_t)val) << POGO_OTODMA_POGO_ODMA_CORE_OTR0_TAGCFG_SHIFT))

//====================================================================
//Register: ODMA Tag Register 1 (OTR1)
//====================================================================

#define  POGO_OTODMA_POGO_ODMA_CORE_OTR1_RESERVED1_MASK 0xffff0000
#define  POGO_OTODMA_POGO_ODMA_CORE_OTR1_RESERVED1_SHIFT 16
#define  POGO_OTODMA_POGO_ODMA_CORE_OTR1_RESERVED1_MASK_SHIFT(reg) (((reg) & POGO_OTODMA_POGO_ODMA_CORE_OTR1_RESERVED1_MASK) >> POGO_OTODMA_POGO_ODMA_CORE_OTR1_RESERVED1_SHIFT)
#define  POGO_OTODMA_POGO_ODMA_CORE_OTR1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~POGO_OTODMA_POGO_ODMA_CORE_OTR1_RESERVED1_MASK) | (((uint32_t)val) << POGO_OTODMA_POGO_ODMA_CORE_OTR1_RESERVED1_SHIFT))

#define  POGO_OTODMA_POGO_ODMA_CORE_OTR1_TAGMAJ_MASK 0xffff
#define  POGO_OTODMA_POGO_ODMA_CORE_OTR1_TAGMAJ_SHIFT 0
#define  POGO_OTODMA_POGO_ODMA_CORE_OTR1_TAGMAJ_MASK_SHIFT(reg) (((reg) & POGO_OTODMA_POGO_ODMA_CORE_OTR1_TAGMAJ_MASK) >> POGO_OTODMA_POGO_ODMA_CORE_OTR1_TAGMAJ_SHIFT)
#define  POGO_OTODMA_POGO_ODMA_CORE_OTR1_TAGMAJ_REPLACE_VAL(reg,val) (((reg) & ~POGO_OTODMA_POGO_ODMA_CORE_OTR1_TAGMAJ_MASK) | (((uint32_t)val) << POGO_OTODMA_POGO_ODMA_CORE_OTR1_TAGMAJ_SHIFT))

//====================================================================
//Register: ODMA Tag Register 2 (OTR2)
//====================================================================

#define  POGO_OTODMA_POGO_ODMA_CORE_OTR2_RESERVED1_MASK 0xffff0000
#define  POGO_OTODMA_POGO_ODMA_CORE_OTR2_RESERVED1_SHIFT 16
#define  POGO_OTODMA_POGO_ODMA_CORE_OTR2_RESERVED1_MASK_SHIFT(reg) (((reg) & POGO_OTODMA_POGO_ODMA_CORE_OTR2_RESERVED1_MASK) >> POGO_OTODMA_POGO_ODMA_CORE_OTR2_RESERVED1_SHIFT)
#define  POGO_OTODMA_POGO_ODMA_CORE_OTR2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~POGO_OTODMA_POGO_ODMA_CORE_OTR2_RESERVED1_MASK) | (((uint32_t)val) << POGO_OTODMA_POGO_ODMA_CORE_OTR2_RESERVED1_SHIFT))

#define  POGO_OTODMA_POGO_ODMA_CORE_OTR2_TAGMID_MASK 0xffff
#define  POGO_OTODMA_POGO_ODMA_CORE_OTR2_TAGMID_SHIFT 0
#define  POGO_OTODMA_POGO_ODMA_CORE_OTR2_TAGMID_MASK_SHIFT(reg) (((reg) & POGO_OTODMA_POGO_ODMA_CORE_OTR2_TAGMID_MASK) >> POGO_OTODMA_POGO_ODMA_CORE_OTR2_TAGMID_SHIFT)
#define  POGO_OTODMA_POGO_ODMA_CORE_OTR2_TAGMID_REPLACE_VAL(reg,val) (((reg) & ~POGO_OTODMA_POGO_ODMA_CORE_OTR2_TAGMID_MASK) | (((uint32_t)val) << POGO_OTODMA_POGO_ODMA_CORE_OTR2_TAGMID_SHIFT))

//====================================================================
//
//Register File: PIE LUT1D_BDE, ANTIFCOR, DISTORT_DMA (DISTORT_TOP_ANTIFCOR_TOP)
/** \brief Register Descriptions for the ANTIFCOR Top Testbench*/
//
//====================================================================

//====================================================================
//
//Register File: PIE Distort (DISTORT_TOP_DISTORT)
/** \brief Register file for the DISTORT block
  (rev 0 . 6 . 1 . 0)*/
//
//====================================================================

//====================================================================
//Register: Configuration Register (Cfg)
/** \brief This register configures the major features of the Distort module.*/
//====================================================================

#define  DISTORT_TOP_DISTORT_CFG_RESERVED1_MASK 0xe0000000
#define  DISTORT_TOP_DISTORT_CFG_RESERVED1_SHIFT 29
#define  DISTORT_TOP_DISTORT_CFG_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_TOP_DISTORT_CFG_RESERVED1_MASK) >> DISTORT_TOP_DISTORT_CFG_RESERVED1_SHIFT)
#define  DISTORT_TOP_DISTORT_CFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_TOP_DISTORT_CFG_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_TOP_DISTORT_CFG_RESERVED1_SHIFT))

#define  DISTORT_TOP_DISTORT_CFG_ENCDMA_MASK 0x10000000
#define  DISTORT_TOP_DISTORT_CFG_ENCDMA_SHIFT 28
#define  DISTORT_TOP_DISTORT_CFG_ENCDMA_MASK_SHIFT(reg) (((reg) & DISTORT_TOP_DISTORT_CFG_ENCDMA_MASK) >> DISTORT_TOP_DISTORT_CFG_ENCDMA_SHIFT)
#define  DISTORT_TOP_DISTORT_CFG_ENCDMA_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_TOP_DISTORT_CFG_ENCDMA_MASK) | (((uint32_t)val) << DISTORT_TOP_DISTORT_CFG_ENCDMA_SHIFT))

#define  DISTORT_TOP_DISTORT_CFG_RESERVED2_MASK 0xc000000
#define  DISTORT_TOP_DISTORT_CFG_RESERVED2_SHIFT 26
#define  DISTORT_TOP_DISTORT_CFG_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_TOP_DISTORT_CFG_RESERVED2_MASK) >> DISTORT_TOP_DISTORT_CFG_RESERVED2_SHIFT)
#define  DISTORT_TOP_DISTORT_CFG_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_TOP_DISTORT_CFG_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_TOP_DISTORT_CFG_RESERVED2_SHIFT))

#define  DISTORT_TOP_DISTORT_CFG_HORZSHIFT_MASK 0x3000000
#define  DISTORT_TOP_DISTORT_CFG_HORZSHIFT_SHIFT 24
#define  DISTORT_TOP_DISTORT_CFG_HORZSHIFT_MASK_SHIFT(reg) (((reg) & DISTORT_TOP_DISTORT_CFG_HORZSHIFT_MASK) >> DISTORT_TOP_DISTORT_CFG_HORZSHIFT_SHIFT)
#define  DISTORT_TOP_DISTORT_CFG_HORZSHIFT_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_TOP_DISTORT_CFG_HORZSHIFT_MASK) | (((uint32_t)val) << DISTORT_TOP_DISTORT_CFG_HORZSHIFT_SHIFT))

#define  DISTORT_TOP_DISTORT_CFG_RESERVED3_MASK 0xfc0000
#define  DISTORT_TOP_DISTORT_CFG_RESERVED3_SHIFT 18
#define  DISTORT_TOP_DISTORT_CFG_RESERVED3_MASK_SHIFT(reg) (((reg) & DISTORT_TOP_DISTORT_CFG_RESERVED3_MASK) >> DISTORT_TOP_DISTORT_CFG_RESERVED3_SHIFT)
#define  DISTORT_TOP_DISTORT_CFG_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_TOP_DISTORT_CFG_RESERVED3_MASK) | (((uint32_t)val) << DISTORT_TOP_DISTORT_CFG_RESERVED3_SHIFT))

#define  DISTORT_TOP_DISTORT_CFG_VERTSHIFT_MASK 0x30000
#define  DISTORT_TOP_DISTORT_CFG_VERTSHIFT_SHIFT 16
#define  DISTORT_TOP_DISTORT_CFG_VERTSHIFT_MASK_SHIFT(reg) (((reg) & DISTORT_TOP_DISTORT_CFG_VERTSHIFT_MASK) >> DISTORT_TOP_DISTORT_CFG_VERTSHIFT_SHIFT)
#define  DISTORT_TOP_DISTORT_CFG_VERTSHIFT_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_TOP_DISTORT_CFG_VERTSHIFT_MASK) | (((uint32_t)val) << DISTORT_TOP_DISTORT_CFG_VERTSHIFT_SHIFT))

#define  DISTORT_TOP_DISTORT_CFG_RESERVED4_MASK 0xff80
#define  DISTORT_TOP_DISTORT_CFG_RESERVED4_SHIFT 7
#define  DISTORT_TOP_DISTORT_CFG_RESERVED4_MASK_SHIFT(reg) (((reg) & DISTORT_TOP_DISTORT_CFG_RESERVED4_MASK) >> DISTORT_TOP_DISTORT_CFG_RESERVED4_SHIFT)
#define  DISTORT_TOP_DISTORT_CFG_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_TOP_DISTORT_CFG_RESERVED4_MASK) | (((uint32_t)val) << DISTORT_TOP_DISTORT_CFG_RESERVED4_SHIFT))

#define  DISTORT_TOP_DISTORT_CFG_ENCOLOR3_MASK 0x40
#define  DISTORT_TOP_DISTORT_CFG_ENCOLOR3_SHIFT 6
#define  DISTORT_TOP_DISTORT_CFG_ENCOLOR3_MASK_SHIFT(reg) (((reg) & DISTORT_TOP_DISTORT_CFG_ENCOLOR3_MASK) >> DISTORT_TOP_DISTORT_CFG_ENCOLOR3_SHIFT)
#define  DISTORT_TOP_DISTORT_CFG_ENCOLOR3_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_TOP_DISTORT_CFG_ENCOLOR3_MASK) | (((uint32_t)val) << DISTORT_TOP_DISTORT_CFG_ENCOLOR3_SHIFT))

#define  DISTORT_TOP_DISTORT_CFG_ENCOLOR2_MASK 0x20
#define  DISTORT_TOP_DISTORT_CFG_ENCOLOR2_SHIFT 5
#define  DISTORT_TOP_DISTORT_CFG_ENCOLOR2_MASK_SHIFT(reg) (((reg) & DISTORT_TOP_DISTORT_CFG_ENCOLOR2_MASK) >> DISTORT_TOP_DISTORT_CFG_ENCOLOR2_SHIFT)
#define  DISTORT_TOP_DISTORT_CFG_ENCOLOR2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_TOP_DISTORT_CFG_ENCOLOR2_MASK) | (((uint32_t)val) << DISTORT_TOP_DISTORT_CFG_ENCOLOR2_SHIFT))

#define  DISTORT_TOP_DISTORT_CFG_ENCOLOR1_MASK 0x10
#define  DISTORT_TOP_DISTORT_CFG_ENCOLOR1_SHIFT 4
#define  DISTORT_TOP_DISTORT_CFG_ENCOLOR1_MASK_SHIFT(reg) (((reg) & DISTORT_TOP_DISTORT_CFG_ENCOLOR1_MASK) >> DISTORT_TOP_DISTORT_CFG_ENCOLOR1_SHIFT)
#define  DISTORT_TOP_DISTORT_CFG_ENCOLOR1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_TOP_DISTORT_CFG_ENCOLOR1_MASK) | (((uint32_t)val) << DISTORT_TOP_DISTORT_CFG_ENCOLOR1_SHIFT))

#define  DISTORT_TOP_DISTORT_CFG_CH3_MAPMODE_MASK 0x8
#define  DISTORT_TOP_DISTORT_CFG_CH3_MAPMODE_SHIFT 3
#define  DISTORT_TOP_DISTORT_CFG_CH3_MAPMODE_MASK_SHIFT(reg) (((reg) & DISTORT_TOP_DISTORT_CFG_CH3_MAPMODE_MASK) >> DISTORT_TOP_DISTORT_CFG_CH3_MAPMODE_SHIFT)
#define  DISTORT_TOP_DISTORT_CFG_CH3_MAPMODE_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_TOP_DISTORT_CFG_CH3_MAPMODE_MASK) | (((uint32_t)val) << DISTORT_TOP_DISTORT_CFG_CH3_MAPMODE_SHIFT))

#define  DISTORT_TOP_DISTORT_CFG_CH2_MAPMODE_MASK 0x4
#define  DISTORT_TOP_DISTORT_CFG_CH2_MAPMODE_SHIFT 2
#define  DISTORT_TOP_DISTORT_CFG_CH2_MAPMODE_MASK_SHIFT(reg) (((reg) & DISTORT_TOP_DISTORT_CFG_CH2_MAPMODE_MASK) >> DISTORT_TOP_DISTORT_CFG_CH2_MAPMODE_SHIFT)
#define  DISTORT_TOP_DISTORT_CFG_CH2_MAPMODE_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_TOP_DISTORT_CFG_CH2_MAPMODE_MASK) | (((uint32_t)val) << DISTORT_TOP_DISTORT_CFG_CH2_MAPMODE_SHIFT))

#define  DISTORT_TOP_DISTORT_CFG_CH1_MAPMODE_MASK 0x2
#define  DISTORT_TOP_DISTORT_CFG_CH1_MAPMODE_SHIFT 1
#define  DISTORT_TOP_DISTORT_CFG_CH1_MAPMODE_MASK_SHIFT(reg) (((reg) & DISTORT_TOP_DISTORT_CFG_CH1_MAPMODE_MASK) >> DISTORT_TOP_DISTORT_CFG_CH1_MAPMODE_SHIFT)
#define  DISTORT_TOP_DISTORT_CFG_CH1_MAPMODE_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_TOP_DISTORT_CFG_CH1_MAPMODE_MASK) | (((uint32_t)val) << DISTORT_TOP_DISTORT_CFG_CH1_MAPMODE_SHIFT))

#define  DISTORT_TOP_DISTORT_CFG_BYPASS_MASK 0x1
#define  DISTORT_TOP_DISTORT_CFG_BYPASS_SHIFT 0
#define  DISTORT_TOP_DISTORT_CFG_BYPASS_MASK_SHIFT(reg) (((reg) & DISTORT_TOP_DISTORT_CFG_BYPASS_MASK) >> DISTORT_TOP_DISTORT_CFG_BYPASS_SHIFT)
#define  DISTORT_TOP_DISTORT_CFG_BYPASS_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_TOP_DISTORT_CFG_BYPASS_MASK) | (((uint32_t)val) << DISTORT_TOP_DISTORT_CFG_BYPASS_SHIFT))

//====================================================================
//Register: Output Strip Configuration (OutputStripConfig)
/** \brief This register adds an output strip of the given configuration to the queue to be processed. This register is not used in Map Mode.*/
//====================================================================

#define  DISTORT_TOP_DISTORT_OUTPUTSTRIPCONFIG_INTAFTER_MASK 0x80000000
#define  DISTORT_TOP_DISTORT_OUTPUTSTRIPCONFIG_INTAFTER_SHIFT 31
#define  DISTORT_TOP_DISTORT_OUTPUTSTRIPCONFIG_INTAFTER_MASK_SHIFT(reg) (((reg) & DISTORT_TOP_DISTORT_OUTPUTSTRIPCONFIG_INTAFTER_MASK) >> DISTORT_TOP_DISTORT_OUTPUTSTRIPCONFIG_INTAFTER_SHIFT)
#define  DISTORT_TOP_DISTORT_OUTPUTSTRIPCONFIG_INTAFTER_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_TOP_DISTORT_OUTPUTSTRIPCONFIG_INTAFTER_MASK) | (((uint32_t)val) << DISTORT_TOP_DISTORT_OUTPUTSTRIPCONFIG_INTAFTER_SHIFT))

#define  DISTORT_TOP_DISTORT_OUTPUTSTRIPCONFIG_RESERVED1_MASK 0x40000000
#define  DISTORT_TOP_DISTORT_OUTPUTSTRIPCONFIG_RESERVED1_SHIFT 30
#define  DISTORT_TOP_DISTORT_OUTPUTSTRIPCONFIG_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_TOP_DISTORT_OUTPUTSTRIPCONFIG_RESERVED1_MASK) >> DISTORT_TOP_DISTORT_OUTPUTSTRIPCONFIG_RESERVED1_SHIFT)
#define  DISTORT_TOP_DISTORT_OUTPUTSTRIPCONFIG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_TOP_DISTORT_OUTPUTSTRIPCONFIG_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_TOP_DISTORT_OUTPUTSTRIPCONFIG_RESERVED1_SHIFT))

#define  DISTORT_TOP_DISTORT_OUTPUTSTRIPCONFIG_STRIPOFFSET_MASK 0x3f000000
#define  DISTORT_TOP_DISTORT_OUTPUTSTRIPCONFIG_STRIPOFFSET_SHIFT 24
#define  DISTORT_TOP_DISTORT_OUTPUTSTRIPCONFIG_STRIPOFFSET_MASK_SHIFT(reg) (((reg) & DISTORT_TOP_DISTORT_OUTPUTSTRIPCONFIG_STRIPOFFSET_MASK) >> DISTORT_TOP_DISTORT_OUTPUTSTRIPCONFIG_STRIPOFFSET_SHIFT)
#define  DISTORT_TOP_DISTORT_OUTPUTSTRIPCONFIG_STRIPOFFSET_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_TOP_DISTORT_OUTPUTSTRIPCONFIG_STRIPOFFSET_MASK) | (((uint32_t)val) << DISTORT_TOP_DISTORT_OUTPUTSTRIPCONFIG_STRIPOFFSET_SHIFT))

#define  DISTORT_TOP_DISTORT_OUTPUTSTRIPCONFIG_RESERVED2_MASK 0xc00000
#define  DISTORT_TOP_DISTORT_OUTPUTSTRIPCONFIG_RESERVED2_SHIFT 22
#define  DISTORT_TOP_DISTORT_OUTPUTSTRIPCONFIG_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_TOP_DISTORT_OUTPUTSTRIPCONFIG_RESERVED2_MASK) >> DISTORT_TOP_DISTORT_OUTPUTSTRIPCONFIG_RESERVED2_SHIFT)
#define  DISTORT_TOP_DISTORT_OUTPUTSTRIPCONFIG_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_TOP_DISTORT_OUTPUTSTRIPCONFIG_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_TOP_DISTORT_OUTPUTSTRIPCONFIG_RESERVED2_SHIFT))

#define  DISTORT_TOP_DISTORT_OUTPUTSTRIPCONFIG_STRIPHEIGHT_MASK 0x3f0000
#define  DISTORT_TOP_DISTORT_OUTPUTSTRIPCONFIG_STRIPHEIGHT_SHIFT 16
#define  DISTORT_TOP_DISTORT_OUTPUTSTRIPCONFIG_STRIPHEIGHT_MASK_SHIFT(reg) (((reg) & DISTORT_TOP_DISTORT_OUTPUTSTRIPCONFIG_STRIPHEIGHT_MASK) >> DISTORT_TOP_DISTORT_OUTPUTSTRIPCONFIG_STRIPHEIGHT_SHIFT)
#define  DISTORT_TOP_DISTORT_OUTPUTSTRIPCONFIG_STRIPHEIGHT_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_TOP_DISTORT_OUTPUTSTRIPCONFIG_STRIPHEIGHT_MASK) | (((uint32_t)val) << DISTORT_TOP_DISTORT_OUTPUTSTRIPCONFIG_STRIPHEIGHT_SHIFT))

#define  DISTORT_TOP_DISTORT_OUTPUTSTRIPCONFIG_STRIPWIDTH_MASK 0xffff
#define  DISTORT_TOP_DISTORT_OUTPUTSTRIPCONFIG_STRIPWIDTH_SHIFT 0
#define  DISTORT_TOP_DISTORT_OUTPUTSTRIPCONFIG_STRIPWIDTH_MASK_SHIFT(reg) (((reg) & DISTORT_TOP_DISTORT_OUTPUTSTRIPCONFIG_STRIPWIDTH_MASK) >> DISTORT_TOP_DISTORT_OUTPUTSTRIPCONFIG_STRIPWIDTH_SHIFT)
#define  DISTORT_TOP_DISTORT_OUTPUTSTRIPCONFIG_STRIPWIDTH_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_TOP_DISTORT_OUTPUTSTRIPCONFIG_STRIPWIDTH_MASK) | (((uint32_t)val) << DISTORT_TOP_DISTORT_OUTPUTSTRIPCONFIG_STRIPWIDTH_SHIFT))

//====================================================================
//Register: Output Strip Status (OutputStripStatus)
/** \brief Displays the configuration of the strip currently being processed. This register is not used in Map Mode.*/
//====================================================================

#define  DISTORT_TOP_DISTORT_OUTPUTSTRIPSTATUS_INTAFTER_MASK 0x80000000
#define  DISTORT_TOP_DISTORT_OUTPUTSTRIPSTATUS_INTAFTER_SHIFT 31
#define  DISTORT_TOP_DISTORT_OUTPUTSTRIPSTATUS_INTAFTER_MASK_SHIFT(reg) (((reg) & DISTORT_TOP_DISTORT_OUTPUTSTRIPSTATUS_INTAFTER_MASK) >> DISTORT_TOP_DISTORT_OUTPUTSTRIPSTATUS_INTAFTER_SHIFT)
#define  DISTORT_TOP_DISTORT_OUTPUTSTRIPSTATUS_INTAFTER_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_TOP_DISTORT_OUTPUTSTRIPSTATUS_INTAFTER_MASK) | (((uint32_t)val) << DISTORT_TOP_DISTORT_OUTPUTSTRIPSTATUS_INTAFTER_SHIFT))

#define  DISTORT_TOP_DISTORT_OUTPUTSTRIPSTATUS_RESERVED1_MASK 0x40000000
#define  DISTORT_TOP_DISTORT_OUTPUTSTRIPSTATUS_RESERVED1_SHIFT 30
#define  DISTORT_TOP_DISTORT_OUTPUTSTRIPSTATUS_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_TOP_DISTORT_OUTPUTSTRIPSTATUS_RESERVED1_MASK) >> DISTORT_TOP_DISTORT_OUTPUTSTRIPSTATUS_RESERVED1_SHIFT)
#define  DISTORT_TOP_DISTORT_OUTPUTSTRIPSTATUS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_TOP_DISTORT_OUTPUTSTRIPSTATUS_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_TOP_DISTORT_OUTPUTSTRIPSTATUS_RESERVED1_SHIFT))

#define  DISTORT_TOP_DISTORT_OUTPUTSTRIPSTATUS_STRIPOFFSET_MASK 0x3f000000
#define  DISTORT_TOP_DISTORT_OUTPUTSTRIPSTATUS_STRIPOFFSET_SHIFT 24
#define  DISTORT_TOP_DISTORT_OUTPUTSTRIPSTATUS_STRIPOFFSET_MASK_SHIFT(reg) (((reg) & DISTORT_TOP_DISTORT_OUTPUTSTRIPSTATUS_STRIPOFFSET_MASK) >> DISTORT_TOP_DISTORT_OUTPUTSTRIPSTATUS_STRIPOFFSET_SHIFT)
#define  DISTORT_TOP_DISTORT_OUTPUTSTRIPSTATUS_STRIPOFFSET_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_TOP_DISTORT_OUTPUTSTRIPSTATUS_STRIPOFFSET_MASK) | (((uint32_t)val) << DISTORT_TOP_DISTORT_OUTPUTSTRIPSTATUS_STRIPOFFSET_SHIFT))

#define  DISTORT_TOP_DISTORT_OUTPUTSTRIPSTATUS_RESERVED2_MASK 0xc00000
#define  DISTORT_TOP_DISTORT_OUTPUTSTRIPSTATUS_RESERVED2_SHIFT 22
#define  DISTORT_TOP_DISTORT_OUTPUTSTRIPSTATUS_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_TOP_DISTORT_OUTPUTSTRIPSTATUS_RESERVED2_MASK) >> DISTORT_TOP_DISTORT_OUTPUTSTRIPSTATUS_RESERVED2_SHIFT)
#define  DISTORT_TOP_DISTORT_OUTPUTSTRIPSTATUS_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_TOP_DISTORT_OUTPUTSTRIPSTATUS_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_TOP_DISTORT_OUTPUTSTRIPSTATUS_RESERVED2_SHIFT))

#define  DISTORT_TOP_DISTORT_OUTPUTSTRIPSTATUS_STRIPHEIGHT_MASK 0x3f0000
#define  DISTORT_TOP_DISTORT_OUTPUTSTRIPSTATUS_STRIPHEIGHT_SHIFT 16
#define  DISTORT_TOP_DISTORT_OUTPUTSTRIPSTATUS_STRIPHEIGHT_MASK_SHIFT(reg) (((reg) & DISTORT_TOP_DISTORT_OUTPUTSTRIPSTATUS_STRIPHEIGHT_MASK) >> DISTORT_TOP_DISTORT_OUTPUTSTRIPSTATUS_STRIPHEIGHT_SHIFT)
#define  DISTORT_TOP_DISTORT_OUTPUTSTRIPSTATUS_STRIPHEIGHT_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_TOP_DISTORT_OUTPUTSTRIPSTATUS_STRIPHEIGHT_MASK) | (((uint32_t)val) << DISTORT_TOP_DISTORT_OUTPUTSTRIPSTATUS_STRIPHEIGHT_SHIFT))

#define  DISTORT_TOP_DISTORT_OUTPUTSTRIPSTATUS_STRIPWIDTH_MASK 0xffff
#define  DISTORT_TOP_DISTORT_OUTPUTSTRIPSTATUS_STRIPWIDTH_SHIFT 0
#define  DISTORT_TOP_DISTORT_OUTPUTSTRIPSTATUS_STRIPWIDTH_MASK_SHIFT(reg) (((reg) & DISTORT_TOP_DISTORT_OUTPUTSTRIPSTATUS_STRIPWIDTH_MASK) >> DISTORT_TOP_DISTORT_OUTPUTSTRIPSTATUS_STRIPWIDTH_SHIFT)
#define  DISTORT_TOP_DISTORT_OUTPUTSTRIPSTATUS_STRIPWIDTH_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_TOP_DISTORT_OUTPUTSTRIPSTATUS_STRIPWIDTH_MASK) | (((uint32_t)val) << DISTORT_TOP_DISTORT_OUTPUTSTRIPSTATUS_STRIPWIDTH_SHIFT))

//====================================================================
//Register: Output Strip Queue and CDMA Handshake Status (QueueHsStatus)
/** \brief Displays the status of the output strip queue and the CDMA Handshake.*/
//====================================================================

#define  DISTORT_TOP_DISTORT_QUEUEHSSTATUS_QUEUEDEPTH_MASK 0xffff0000
#define  DISTORT_TOP_DISTORT_QUEUEHSSTATUS_QUEUEDEPTH_SHIFT 16
#define  DISTORT_TOP_DISTORT_QUEUEHSSTATUS_QUEUEDEPTH_MASK_SHIFT(reg) (((reg) & DISTORT_TOP_DISTORT_QUEUEHSSTATUS_QUEUEDEPTH_MASK) >> DISTORT_TOP_DISTORT_QUEUEHSSTATUS_QUEUEDEPTH_SHIFT)
#define  DISTORT_TOP_DISTORT_QUEUEHSSTATUS_QUEUEDEPTH_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_TOP_DISTORT_QUEUEHSSTATUS_QUEUEDEPTH_MASK) | (((uint32_t)val) << DISTORT_TOP_DISTORT_QUEUEHSSTATUS_QUEUEDEPTH_SHIFT))

#define  DISTORT_TOP_DISTORT_QUEUEHSSTATUS_RESERVED1_MASK 0xe000
#define  DISTORT_TOP_DISTORT_QUEUEHSSTATUS_RESERVED1_SHIFT 13
#define  DISTORT_TOP_DISTORT_QUEUEHSSTATUS_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_TOP_DISTORT_QUEUEHSSTATUS_RESERVED1_MASK) >> DISTORT_TOP_DISTORT_QUEUEHSSTATUS_RESERVED1_SHIFT)
#define  DISTORT_TOP_DISTORT_QUEUEHSSTATUS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_TOP_DISTORT_QUEUEHSSTATUS_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_TOP_DISTORT_QUEUEHSSTATUS_RESERVED1_SHIFT))

#define  DISTORT_TOP_DISTORT_QUEUEHSSTATUS_DMAACK_MASK 0x1000
#define  DISTORT_TOP_DISTORT_QUEUEHSSTATUS_DMAACK_SHIFT 12
#define  DISTORT_TOP_DISTORT_QUEUEHSSTATUS_DMAACK_MASK_SHIFT(reg) (((reg) & DISTORT_TOP_DISTORT_QUEUEHSSTATUS_DMAACK_MASK) >> DISTORT_TOP_DISTORT_QUEUEHSSTATUS_DMAACK_SHIFT)
#define  DISTORT_TOP_DISTORT_QUEUEHSSTATUS_DMAACK_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_TOP_DISTORT_QUEUEHSSTATUS_DMAACK_MASK) | (((uint32_t)val) << DISTORT_TOP_DISTORT_QUEUEHSSTATUS_DMAACK_SHIFT))

#define  DISTORT_TOP_DISTORT_QUEUEHSSTATUS_RESERVED2_MASK 0xe00
#define  DISTORT_TOP_DISTORT_QUEUEHSSTATUS_RESERVED2_SHIFT 9
#define  DISTORT_TOP_DISTORT_QUEUEHSSTATUS_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_TOP_DISTORT_QUEUEHSSTATUS_RESERVED2_MASK) >> DISTORT_TOP_DISTORT_QUEUEHSSTATUS_RESERVED2_SHIFT)
#define  DISTORT_TOP_DISTORT_QUEUEHSSTATUS_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_TOP_DISTORT_QUEUEHSSTATUS_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_TOP_DISTORT_QUEUEHSSTATUS_RESERVED2_SHIFT))

#define  DISTORT_TOP_DISTORT_QUEUEHSSTATUS_DMAREQ_MASK 0x100
#define  DISTORT_TOP_DISTORT_QUEUEHSSTATUS_DMAREQ_SHIFT 8
#define  DISTORT_TOP_DISTORT_QUEUEHSSTATUS_DMAREQ_MASK_SHIFT(reg) (((reg) & DISTORT_TOP_DISTORT_QUEUEHSSTATUS_DMAREQ_MASK) >> DISTORT_TOP_DISTORT_QUEUEHSSTATUS_DMAREQ_SHIFT)
#define  DISTORT_TOP_DISTORT_QUEUEHSSTATUS_DMAREQ_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_TOP_DISTORT_QUEUEHSSTATUS_DMAREQ_MASK) | (((uint32_t)val) << DISTORT_TOP_DISTORT_QUEUEHSSTATUS_DMAREQ_SHIFT))

#define  DISTORT_TOP_DISTORT_QUEUEHSSTATUS_RESERVED3_MASK 0xe0
#define  DISTORT_TOP_DISTORT_QUEUEHSSTATUS_RESERVED3_SHIFT 5
#define  DISTORT_TOP_DISTORT_QUEUEHSSTATUS_RESERVED3_MASK_SHIFT(reg) (((reg) & DISTORT_TOP_DISTORT_QUEUEHSSTATUS_RESERVED3_MASK) >> DISTORT_TOP_DISTORT_QUEUEHSSTATUS_RESERVED3_SHIFT)
#define  DISTORT_TOP_DISTORT_QUEUEHSSTATUS_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_TOP_DISTORT_QUEUEHSSTATUS_RESERVED3_MASK) | (((uint32_t)val) << DISTORT_TOP_DISTORT_QUEUEHSSTATUS_RESERVED3_SHIFT))

#define  DISTORT_TOP_DISTORT_QUEUEHSSTATUS_QUEUEFULL_MASK 0x10
#define  DISTORT_TOP_DISTORT_QUEUEHSSTATUS_QUEUEFULL_SHIFT 4
#define  DISTORT_TOP_DISTORT_QUEUEHSSTATUS_QUEUEFULL_MASK_SHIFT(reg) (((reg) & DISTORT_TOP_DISTORT_QUEUEHSSTATUS_QUEUEFULL_MASK) >> DISTORT_TOP_DISTORT_QUEUEHSSTATUS_QUEUEFULL_SHIFT)
#define  DISTORT_TOP_DISTORT_QUEUEHSSTATUS_QUEUEFULL_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_TOP_DISTORT_QUEUEHSSTATUS_QUEUEFULL_MASK) | (((uint32_t)val) << DISTORT_TOP_DISTORT_QUEUEHSSTATUS_QUEUEFULL_SHIFT))

#define  DISTORT_TOP_DISTORT_QUEUEHSSTATUS_RESERVED4_MASK 0xe
#define  DISTORT_TOP_DISTORT_QUEUEHSSTATUS_RESERVED4_SHIFT 1
#define  DISTORT_TOP_DISTORT_QUEUEHSSTATUS_RESERVED4_MASK_SHIFT(reg) (((reg) & DISTORT_TOP_DISTORT_QUEUEHSSTATUS_RESERVED4_MASK) >> DISTORT_TOP_DISTORT_QUEUEHSSTATUS_RESERVED4_SHIFT)
#define  DISTORT_TOP_DISTORT_QUEUEHSSTATUS_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_TOP_DISTORT_QUEUEHSSTATUS_RESERVED4_MASK) | (((uint32_t)val) << DISTORT_TOP_DISTORT_QUEUEHSSTATUS_RESERVED4_SHIFT))

#define  DISTORT_TOP_DISTORT_QUEUEHSSTATUS_QUEUEEMPTY_MASK 0x1
#define  DISTORT_TOP_DISTORT_QUEUEHSSTATUS_QUEUEEMPTY_SHIFT 0
#define  DISTORT_TOP_DISTORT_QUEUEHSSTATUS_QUEUEEMPTY_MASK_SHIFT(reg) (((reg) & DISTORT_TOP_DISTORT_QUEUEHSSTATUS_QUEUEEMPTY_MASK) >> DISTORT_TOP_DISTORT_QUEUEHSSTATUS_QUEUEEMPTY_SHIFT)
#define  DISTORT_TOP_DISTORT_QUEUEHSSTATUS_QUEUEEMPTY_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_TOP_DISTORT_QUEUEHSSTATUS_QUEUEEMPTY_MASK) | (((uint32_t)val) << DISTORT_TOP_DISTORT_QUEUEHSSTATUS_QUEUEEMPTY_SHIFT))

//====================================================================
//Register: Interrupt Enable Register (IntEnable)
/** \brief This register enables global interrupts. Individual strip interrupts can be disabled by writing the appropriate value to the OutputStripDimension register.*/
//====================================================================

#define  DISTORT_TOP_DISTORT_INTENABLE_RESERVED1_MASK 0xfffffffe
#define  DISTORT_TOP_DISTORT_INTENABLE_RESERVED1_SHIFT 1
#define  DISTORT_TOP_DISTORT_INTENABLE_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_TOP_DISTORT_INTENABLE_RESERVED1_MASK) >> DISTORT_TOP_DISTORT_INTENABLE_RESERVED1_SHIFT)
#define  DISTORT_TOP_DISTORT_INTENABLE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_TOP_DISTORT_INTENABLE_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_TOP_DISTORT_INTENABLE_RESERVED1_SHIFT))

#define  DISTORT_TOP_DISTORT_INTENABLE_ENDOFSTRIP_MASK 0x1
#define  DISTORT_TOP_DISTORT_INTENABLE_ENDOFSTRIP_SHIFT 0
#define  DISTORT_TOP_DISTORT_INTENABLE_ENDOFSTRIP_MASK_SHIFT(reg) (((reg) & DISTORT_TOP_DISTORT_INTENABLE_ENDOFSTRIP_MASK) >> DISTORT_TOP_DISTORT_INTENABLE_ENDOFSTRIP_SHIFT)
#define  DISTORT_TOP_DISTORT_INTENABLE_ENDOFSTRIP_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_TOP_DISTORT_INTENABLE_ENDOFSTRIP_MASK) | (((uint32_t)val) << DISTORT_TOP_DISTORT_INTENABLE_ENDOFSTRIP_SHIFT))

//====================================================================
//Register: Interrupt Pending Register (IntPending)
/** \brief This register contains the interrupt pending bit.*/
//====================================================================

#define  DISTORT_TOP_DISTORT_INTPENDING_RESERVED1_MASK 0xfffffffe
#define  DISTORT_TOP_DISTORT_INTPENDING_RESERVED1_SHIFT 1
#define  DISTORT_TOP_DISTORT_INTPENDING_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_TOP_DISTORT_INTPENDING_RESERVED1_MASK) >> DISTORT_TOP_DISTORT_INTPENDING_RESERVED1_SHIFT)
#define  DISTORT_TOP_DISTORT_INTPENDING_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_TOP_DISTORT_INTPENDING_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_TOP_DISTORT_INTPENDING_RESERVED1_SHIFT))

#define  DISTORT_TOP_DISTORT_INTPENDING_ENDOFSTRIP_MASK 0x1
#define  DISTORT_TOP_DISTORT_INTPENDING_ENDOFSTRIP_SHIFT 0
#define  DISTORT_TOP_DISTORT_INTPENDING_ENDOFSTRIP_MASK_SHIFT(reg) (((reg) & DISTORT_TOP_DISTORT_INTPENDING_ENDOFSTRIP_MASK) >> DISTORT_TOP_DISTORT_INTPENDING_ENDOFSTRIP_SHIFT)
#define  DISTORT_TOP_DISTORT_INTPENDING_ENDOFSTRIP_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_TOP_DISTORT_INTPENDING_ENDOFSTRIP_MASK) | (((uint32_t)val) << DISTORT_TOP_DISTORT_INTPENDING_ENDOFSTRIP_SHIFT))

//====================================================================
//Register: Interrupt Clear Register (IntClear)
/** \brief This register clears the interrupt pending bit.*/
//====================================================================

#define  DISTORT_TOP_DISTORT_INTCLEAR_RESERVED1_MASK 0xfffffffe
#define  DISTORT_TOP_DISTORT_INTCLEAR_RESERVED1_SHIFT 1
#define  DISTORT_TOP_DISTORT_INTCLEAR_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_TOP_DISTORT_INTCLEAR_RESERVED1_MASK) >> DISTORT_TOP_DISTORT_INTCLEAR_RESERVED1_SHIFT)
#define  DISTORT_TOP_DISTORT_INTCLEAR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_TOP_DISTORT_INTCLEAR_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_TOP_DISTORT_INTCLEAR_RESERVED1_SHIFT))

#define  DISTORT_TOP_DISTORT_INTCLEAR_ENDOFSTRIP_MASK 0x1
#define  DISTORT_TOP_DISTORT_INTCLEAR_ENDOFSTRIP_SHIFT 0
#define  DISTORT_TOP_DISTORT_INTCLEAR_ENDOFSTRIP_MASK_SHIFT(reg) (((reg) & DISTORT_TOP_DISTORT_INTCLEAR_ENDOFSTRIP_MASK) >> DISTORT_TOP_DISTORT_INTCLEAR_ENDOFSTRIP_SHIFT)
#define  DISTORT_TOP_DISTORT_INTCLEAR_ENDOFSTRIP_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_TOP_DISTORT_INTCLEAR_ENDOFSTRIP_MASK) | (((uint32_t)val) << DISTORT_TOP_DISTORT_INTCLEAR_ENDOFSTRIP_SHIFT))

//====================================================================
//Register: Interrupt Force Register (IntForce)
/** \brief This register forces an interrupt request.*/
//====================================================================

#define  DISTORT_TOP_DISTORT_INTFORCE_RESERVED1_MASK 0xfffffffe
#define  DISTORT_TOP_DISTORT_INTFORCE_RESERVED1_SHIFT 1
#define  DISTORT_TOP_DISTORT_INTFORCE_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_TOP_DISTORT_INTFORCE_RESERVED1_MASK) >> DISTORT_TOP_DISTORT_INTFORCE_RESERVED1_SHIFT)
#define  DISTORT_TOP_DISTORT_INTFORCE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_TOP_DISTORT_INTFORCE_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_TOP_DISTORT_INTFORCE_RESERVED1_SHIFT))

#define  DISTORT_TOP_DISTORT_INTFORCE_ENDOFSTRIP_MASK 0x1
#define  DISTORT_TOP_DISTORT_INTFORCE_ENDOFSTRIP_SHIFT 0
#define  DISTORT_TOP_DISTORT_INTFORCE_ENDOFSTRIP_MASK_SHIFT(reg) (((reg) & DISTORT_TOP_DISTORT_INTFORCE_ENDOFSTRIP_MASK) >> DISTORT_TOP_DISTORT_INTFORCE_ENDOFSTRIP_SHIFT)
#define  DISTORT_TOP_DISTORT_INTFORCE_ENDOFSTRIP_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_TOP_DISTORT_INTFORCE_ENDOFSTRIP_MASK) | (((uint32_t)val) << DISTORT_TOP_DISTORT_INTFORCE_ENDOFSTRIP_SHIFT))

//====================================================================
//Register: CH1 Input Image Size (Ch1_ImageDimension)
/** \brief This register sets the input image size in pixels for channel 1.*/
//====================================================================

#define  DISTORT_TOP_DISTORT_CH1_IMAGEDIMENSION_RESERVED1_MASK 0x80000000
#define  DISTORT_TOP_DISTORT_CH1_IMAGEDIMENSION_RESERVED1_SHIFT 31
#define  DISTORT_TOP_DISTORT_CH1_IMAGEDIMENSION_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_TOP_DISTORT_CH1_IMAGEDIMENSION_RESERVED1_MASK) >> DISTORT_TOP_DISTORT_CH1_IMAGEDIMENSION_RESERVED1_SHIFT)
#define  DISTORT_TOP_DISTORT_CH1_IMAGEDIMENSION_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_TOP_DISTORT_CH1_IMAGEDIMENSION_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_TOP_DISTORT_CH1_IMAGEDIMENSION_RESERVED1_SHIFT))

#define  DISTORT_TOP_DISTORT_CH1_IMAGEDIMENSION_INHEIGHT_MASK 0x7fff0000
#define  DISTORT_TOP_DISTORT_CH1_IMAGEDIMENSION_INHEIGHT_SHIFT 16
#define  DISTORT_TOP_DISTORT_CH1_IMAGEDIMENSION_INHEIGHT_MASK_SHIFT(reg) (((reg) & DISTORT_TOP_DISTORT_CH1_IMAGEDIMENSION_INHEIGHT_MASK) >> DISTORT_TOP_DISTORT_CH1_IMAGEDIMENSION_INHEIGHT_SHIFT)
#define  DISTORT_TOP_DISTORT_CH1_IMAGEDIMENSION_INHEIGHT_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_TOP_DISTORT_CH1_IMAGEDIMENSION_INHEIGHT_MASK) | (((uint32_t)val) << DISTORT_TOP_DISTORT_CH1_IMAGEDIMENSION_INHEIGHT_SHIFT))

#define  DISTORT_TOP_DISTORT_CH1_IMAGEDIMENSION_RESERVED2_MASK 0x8000
#define  DISTORT_TOP_DISTORT_CH1_IMAGEDIMENSION_RESERVED2_SHIFT 15
#define  DISTORT_TOP_DISTORT_CH1_IMAGEDIMENSION_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_TOP_DISTORT_CH1_IMAGEDIMENSION_RESERVED2_MASK) >> DISTORT_TOP_DISTORT_CH1_IMAGEDIMENSION_RESERVED2_SHIFT)
#define  DISTORT_TOP_DISTORT_CH1_IMAGEDIMENSION_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_TOP_DISTORT_CH1_IMAGEDIMENSION_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_TOP_DISTORT_CH1_IMAGEDIMENSION_RESERVED2_SHIFT))

#define  DISTORT_TOP_DISTORT_CH1_IMAGEDIMENSION_INWIDTH_MASK 0x7fff
#define  DISTORT_TOP_DISTORT_CH1_IMAGEDIMENSION_INWIDTH_SHIFT 0
#define  DISTORT_TOP_DISTORT_CH1_IMAGEDIMENSION_INWIDTH_MASK_SHIFT(reg) (((reg) & DISTORT_TOP_DISTORT_CH1_IMAGEDIMENSION_INWIDTH_MASK) >> DISTORT_TOP_DISTORT_CH1_IMAGEDIMENSION_INWIDTH_SHIFT)
#define  DISTORT_TOP_DISTORT_CH1_IMAGEDIMENSION_INWIDTH_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_TOP_DISTORT_CH1_IMAGEDIMENSION_INWIDTH_MASK) | (((uint32_t)val) << DISTORT_TOP_DISTORT_CH1_IMAGEDIMENSION_INWIDTH_SHIFT))

//====================================================================
//Register: CH2 Input Image Size (Ch2_ImageDimension)
/** \brief This register sets the input image size in pixels for channel 2.*/
//====================================================================

#define  DISTORT_TOP_DISTORT_CH2_IMAGEDIMENSION_RESERVED1_MASK 0x80000000
#define  DISTORT_TOP_DISTORT_CH2_IMAGEDIMENSION_RESERVED1_SHIFT 31
#define  DISTORT_TOP_DISTORT_CH2_IMAGEDIMENSION_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_TOP_DISTORT_CH2_IMAGEDIMENSION_RESERVED1_MASK) >> DISTORT_TOP_DISTORT_CH2_IMAGEDIMENSION_RESERVED1_SHIFT)
#define  DISTORT_TOP_DISTORT_CH2_IMAGEDIMENSION_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_TOP_DISTORT_CH2_IMAGEDIMENSION_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_TOP_DISTORT_CH2_IMAGEDIMENSION_RESERVED1_SHIFT))

#define  DISTORT_TOP_DISTORT_CH2_IMAGEDIMENSION_INHEIGHT_MASK 0x7fff0000
#define  DISTORT_TOP_DISTORT_CH2_IMAGEDIMENSION_INHEIGHT_SHIFT 16
#define  DISTORT_TOP_DISTORT_CH2_IMAGEDIMENSION_INHEIGHT_MASK_SHIFT(reg) (((reg) & DISTORT_TOP_DISTORT_CH2_IMAGEDIMENSION_INHEIGHT_MASK) >> DISTORT_TOP_DISTORT_CH2_IMAGEDIMENSION_INHEIGHT_SHIFT)
#define  DISTORT_TOP_DISTORT_CH2_IMAGEDIMENSION_INHEIGHT_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_TOP_DISTORT_CH2_IMAGEDIMENSION_INHEIGHT_MASK) | (((uint32_t)val) << DISTORT_TOP_DISTORT_CH2_IMAGEDIMENSION_INHEIGHT_SHIFT))

#define  DISTORT_TOP_DISTORT_CH2_IMAGEDIMENSION_RESERVED2_MASK 0x8000
#define  DISTORT_TOP_DISTORT_CH2_IMAGEDIMENSION_RESERVED2_SHIFT 15
#define  DISTORT_TOP_DISTORT_CH2_IMAGEDIMENSION_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_TOP_DISTORT_CH2_IMAGEDIMENSION_RESERVED2_MASK) >> DISTORT_TOP_DISTORT_CH2_IMAGEDIMENSION_RESERVED2_SHIFT)
#define  DISTORT_TOP_DISTORT_CH2_IMAGEDIMENSION_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_TOP_DISTORT_CH2_IMAGEDIMENSION_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_TOP_DISTORT_CH2_IMAGEDIMENSION_RESERVED2_SHIFT))

#define  DISTORT_TOP_DISTORT_CH2_IMAGEDIMENSION_INWIDTH_MASK 0x7fff
#define  DISTORT_TOP_DISTORT_CH2_IMAGEDIMENSION_INWIDTH_SHIFT 0
#define  DISTORT_TOP_DISTORT_CH2_IMAGEDIMENSION_INWIDTH_MASK_SHIFT(reg) (((reg) & DISTORT_TOP_DISTORT_CH2_IMAGEDIMENSION_INWIDTH_MASK) >> DISTORT_TOP_DISTORT_CH2_IMAGEDIMENSION_INWIDTH_SHIFT)
#define  DISTORT_TOP_DISTORT_CH2_IMAGEDIMENSION_INWIDTH_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_TOP_DISTORT_CH2_IMAGEDIMENSION_INWIDTH_MASK) | (((uint32_t)val) << DISTORT_TOP_DISTORT_CH2_IMAGEDIMENSION_INWIDTH_SHIFT))

//====================================================================
//Register: CH3 Input Image Size (Ch3_ImageDimension)
/** \brief This register sets the input image size in pixels for channel 3.*/
//====================================================================

#define  DISTORT_TOP_DISTORT_CH3_IMAGEDIMENSION_RESERVED1_MASK 0x80000000
#define  DISTORT_TOP_DISTORT_CH3_IMAGEDIMENSION_RESERVED1_SHIFT 31
#define  DISTORT_TOP_DISTORT_CH3_IMAGEDIMENSION_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_TOP_DISTORT_CH3_IMAGEDIMENSION_RESERVED1_MASK) >> DISTORT_TOP_DISTORT_CH3_IMAGEDIMENSION_RESERVED1_SHIFT)
#define  DISTORT_TOP_DISTORT_CH3_IMAGEDIMENSION_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_TOP_DISTORT_CH3_IMAGEDIMENSION_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_TOP_DISTORT_CH3_IMAGEDIMENSION_RESERVED1_SHIFT))

#define  DISTORT_TOP_DISTORT_CH3_IMAGEDIMENSION_INHEIGHT_MASK 0x7fff0000
#define  DISTORT_TOP_DISTORT_CH3_IMAGEDIMENSION_INHEIGHT_SHIFT 16
#define  DISTORT_TOP_DISTORT_CH3_IMAGEDIMENSION_INHEIGHT_MASK_SHIFT(reg) (((reg) & DISTORT_TOP_DISTORT_CH3_IMAGEDIMENSION_INHEIGHT_MASK) >> DISTORT_TOP_DISTORT_CH3_IMAGEDIMENSION_INHEIGHT_SHIFT)
#define  DISTORT_TOP_DISTORT_CH3_IMAGEDIMENSION_INHEIGHT_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_TOP_DISTORT_CH3_IMAGEDIMENSION_INHEIGHT_MASK) | (((uint32_t)val) << DISTORT_TOP_DISTORT_CH3_IMAGEDIMENSION_INHEIGHT_SHIFT))

#define  DISTORT_TOP_DISTORT_CH3_IMAGEDIMENSION_RESERVED2_MASK 0x8000
#define  DISTORT_TOP_DISTORT_CH3_IMAGEDIMENSION_RESERVED2_SHIFT 15
#define  DISTORT_TOP_DISTORT_CH3_IMAGEDIMENSION_RESERVED2_MASK_SHIFT(reg) (((reg) & DISTORT_TOP_DISTORT_CH3_IMAGEDIMENSION_RESERVED2_MASK) >> DISTORT_TOP_DISTORT_CH3_IMAGEDIMENSION_RESERVED2_SHIFT)
#define  DISTORT_TOP_DISTORT_CH3_IMAGEDIMENSION_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_TOP_DISTORT_CH3_IMAGEDIMENSION_RESERVED2_MASK) | (((uint32_t)val) << DISTORT_TOP_DISTORT_CH3_IMAGEDIMENSION_RESERVED2_SHIFT))

#define  DISTORT_TOP_DISTORT_CH3_IMAGEDIMENSION_INWIDTH_MASK 0x7fff
#define  DISTORT_TOP_DISTORT_CH3_IMAGEDIMENSION_INWIDTH_SHIFT 0
#define  DISTORT_TOP_DISTORT_CH3_IMAGEDIMENSION_INWIDTH_MASK_SHIFT(reg) (((reg) & DISTORT_TOP_DISTORT_CH3_IMAGEDIMENSION_INWIDTH_MASK) >> DISTORT_TOP_DISTORT_CH3_IMAGEDIMENSION_INWIDTH_SHIFT)
#define  DISTORT_TOP_DISTORT_CH3_IMAGEDIMENSION_INWIDTH_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_TOP_DISTORT_CH3_IMAGEDIMENSION_INWIDTH_MASK) | (((uint32_t)val) << DISTORT_TOP_DISTORT_CH3_IMAGEDIMENSION_INWIDTH_SHIFT))

//====================================================================
//Register: CH1 Horizontal Data Start Position (Ch1_DataStartPos_X)
/** \brief Sets the horizontal data starting position for channel 1. The staring position is a signed value with two parts: a 16-bit whole number and a 16-bit fractional number.*/
//====================================================================

#define  DISTORT_TOP_DISTORT_CH1_DATASTARTPOS_X_POSXY_X_MASK 0xffff0000
#define  DISTORT_TOP_DISTORT_CH1_DATASTARTPOS_X_POSXY_X_SHIFT 16
#define  DISTORT_TOP_DISTORT_CH1_DATASTARTPOS_X_POSXY_X_MASK_SHIFT(reg) (((reg) & DISTORT_TOP_DISTORT_CH1_DATASTARTPOS_X_POSXY_X_MASK) >> DISTORT_TOP_DISTORT_CH1_DATASTARTPOS_X_POSXY_X_SHIFT)
#define  DISTORT_TOP_DISTORT_CH1_DATASTARTPOS_X_POSXY_X_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_TOP_DISTORT_CH1_DATASTARTPOS_X_POSXY_X_MASK) | (((uint32_t)val) << DISTORT_TOP_DISTORT_CH1_DATASTARTPOS_X_POSXY_X_SHIFT))

#define  DISTORT_TOP_DISTORT_CH1_DATASTARTPOS_X_F_POSXY_X_MASK 0xffff
#define  DISTORT_TOP_DISTORT_CH1_DATASTARTPOS_X_F_POSXY_X_SHIFT 0
#define  DISTORT_TOP_DISTORT_CH1_DATASTARTPOS_X_F_POSXY_X_MASK_SHIFT(reg) (((reg) & DISTORT_TOP_DISTORT_CH1_DATASTARTPOS_X_F_POSXY_X_MASK) >> DISTORT_TOP_DISTORT_CH1_DATASTARTPOS_X_F_POSXY_X_SHIFT)
#define  DISTORT_TOP_DISTORT_CH1_DATASTARTPOS_X_F_POSXY_X_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_TOP_DISTORT_CH1_DATASTARTPOS_X_F_POSXY_X_MASK) | (((uint32_t)val) << DISTORT_TOP_DISTORT_CH1_DATASTARTPOS_X_F_POSXY_X_SHIFT))

//====================================================================
//Register: CH2 Horizontal Data Start Position (Ch2_DataStartPos_X)
/** \brief Sets the horizontal data starting position for channel 2. The staring position is a signed value with two parts: a 16-bit whole number and a 16-bit fractional number.*/
//====================================================================

#define  DISTORT_TOP_DISTORT_CH2_DATASTARTPOS_X_POSXY_X_MASK 0xffff0000
#define  DISTORT_TOP_DISTORT_CH2_DATASTARTPOS_X_POSXY_X_SHIFT 16
#define  DISTORT_TOP_DISTORT_CH2_DATASTARTPOS_X_POSXY_X_MASK_SHIFT(reg) (((reg) & DISTORT_TOP_DISTORT_CH2_DATASTARTPOS_X_POSXY_X_MASK) >> DISTORT_TOP_DISTORT_CH2_DATASTARTPOS_X_POSXY_X_SHIFT)
#define  DISTORT_TOP_DISTORT_CH2_DATASTARTPOS_X_POSXY_X_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_TOP_DISTORT_CH2_DATASTARTPOS_X_POSXY_X_MASK) | (((uint32_t)val) << DISTORT_TOP_DISTORT_CH2_DATASTARTPOS_X_POSXY_X_SHIFT))

#define  DISTORT_TOP_DISTORT_CH2_DATASTARTPOS_X_F_POSXY_X_MASK 0xffff
#define  DISTORT_TOP_DISTORT_CH2_DATASTARTPOS_X_F_POSXY_X_SHIFT 0
#define  DISTORT_TOP_DISTORT_CH2_DATASTARTPOS_X_F_POSXY_X_MASK_SHIFT(reg) (((reg) & DISTORT_TOP_DISTORT_CH2_DATASTARTPOS_X_F_POSXY_X_MASK) >> DISTORT_TOP_DISTORT_CH2_DATASTARTPOS_X_F_POSXY_X_SHIFT)
#define  DISTORT_TOP_DISTORT_CH2_DATASTARTPOS_X_F_POSXY_X_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_TOP_DISTORT_CH2_DATASTARTPOS_X_F_POSXY_X_MASK) | (((uint32_t)val) << DISTORT_TOP_DISTORT_CH2_DATASTARTPOS_X_F_POSXY_X_SHIFT))

//====================================================================
//Register: CH3 Horizontal Data Start Position (Ch3_DataStartPos_X)
/** \brief Sets the horizontal data starting position for channel 3. The staring position is a signed value with two parts: a 16-bit whole number and a 16-bit fractional number.*/
//====================================================================

#define  DISTORT_TOP_DISTORT_CH3_DATASTARTPOS_X_POSXY_X_MASK 0xffff0000
#define  DISTORT_TOP_DISTORT_CH3_DATASTARTPOS_X_POSXY_X_SHIFT 16
#define  DISTORT_TOP_DISTORT_CH3_DATASTARTPOS_X_POSXY_X_MASK_SHIFT(reg) (((reg) & DISTORT_TOP_DISTORT_CH3_DATASTARTPOS_X_POSXY_X_MASK) >> DISTORT_TOP_DISTORT_CH3_DATASTARTPOS_X_POSXY_X_SHIFT)
#define  DISTORT_TOP_DISTORT_CH3_DATASTARTPOS_X_POSXY_X_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_TOP_DISTORT_CH3_DATASTARTPOS_X_POSXY_X_MASK) | (((uint32_t)val) << DISTORT_TOP_DISTORT_CH3_DATASTARTPOS_X_POSXY_X_SHIFT))

#define  DISTORT_TOP_DISTORT_CH3_DATASTARTPOS_X_F_POSXY_X_MASK 0xffff
#define  DISTORT_TOP_DISTORT_CH3_DATASTARTPOS_X_F_POSXY_X_SHIFT 0
#define  DISTORT_TOP_DISTORT_CH3_DATASTARTPOS_X_F_POSXY_X_MASK_SHIFT(reg) (((reg) & DISTORT_TOP_DISTORT_CH3_DATASTARTPOS_X_F_POSXY_X_MASK) >> DISTORT_TOP_DISTORT_CH3_DATASTARTPOS_X_F_POSXY_X_SHIFT)
#define  DISTORT_TOP_DISTORT_CH3_DATASTARTPOS_X_F_POSXY_X_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_TOP_DISTORT_CH3_DATASTARTPOS_X_F_POSXY_X_MASK) | (((uint32_t)val) << DISTORT_TOP_DISTORT_CH3_DATASTARTPOS_X_F_POSXY_X_SHIFT))

//====================================================================
//Register: CH1 Vertical Data Start Position (Ch1_DataStartPos_Y)
/** \brief Sets the vertical data starting position for channel 1. The staring position is a signed value with two parts: a 16-bit whole number and a 16-bit fractional number.*/
//====================================================================

#define  DISTORT_TOP_DISTORT_CH1_DATASTARTPOS_Y_POSXY_Y_MASK 0xffff0000
#define  DISTORT_TOP_DISTORT_CH1_DATASTARTPOS_Y_POSXY_Y_SHIFT 16
#define  DISTORT_TOP_DISTORT_CH1_DATASTARTPOS_Y_POSXY_Y_MASK_SHIFT(reg) (((reg) & DISTORT_TOP_DISTORT_CH1_DATASTARTPOS_Y_POSXY_Y_MASK) >> DISTORT_TOP_DISTORT_CH1_DATASTARTPOS_Y_POSXY_Y_SHIFT)
#define  DISTORT_TOP_DISTORT_CH1_DATASTARTPOS_Y_POSXY_Y_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_TOP_DISTORT_CH1_DATASTARTPOS_Y_POSXY_Y_MASK) | (((uint32_t)val) << DISTORT_TOP_DISTORT_CH1_DATASTARTPOS_Y_POSXY_Y_SHIFT))

#define  DISTORT_TOP_DISTORT_CH1_DATASTARTPOS_Y_F_POSXY_Y_MASK 0xffff
#define  DISTORT_TOP_DISTORT_CH1_DATASTARTPOS_Y_F_POSXY_Y_SHIFT 0
#define  DISTORT_TOP_DISTORT_CH1_DATASTARTPOS_Y_F_POSXY_Y_MASK_SHIFT(reg) (((reg) & DISTORT_TOP_DISTORT_CH1_DATASTARTPOS_Y_F_POSXY_Y_MASK) >> DISTORT_TOP_DISTORT_CH1_DATASTARTPOS_Y_F_POSXY_Y_SHIFT)
#define  DISTORT_TOP_DISTORT_CH1_DATASTARTPOS_Y_F_POSXY_Y_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_TOP_DISTORT_CH1_DATASTARTPOS_Y_F_POSXY_Y_MASK) | (((uint32_t)val) << DISTORT_TOP_DISTORT_CH1_DATASTARTPOS_Y_F_POSXY_Y_SHIFT))

//====================================================================
//Register: CH2 Vertical Data Start Position (Ch2_DataStartPos_Y)
/** \brief Sets the vertical data starting position for channel 2. The staring position is a signed value with two parts: a 16-bit whole number and a 16-bit fractional number.*/
//====================================================================

#define  DISTORT_TOP_DISTORT_CH2_DATASTARTPOS_Y_POSXY_Y_MASK 0xffff0000
#define  DISTORT_TOP_DISTORT_CH2_DATASTARTPOS_Y_POSXY_Y_SHIFT 16
#define  DISTORT_TOP_DISTORT_CH2_DATASTARTPOS_Y_POSXY_Y_MASK_SHIFT(reg) (((reg) & DISTORT_TOP_DISTORT_CH2_DATASTARTPOS_Y_POSXY_Y_MASK) >> DISTORT_TOP_DISTORT_CH2_DATASTARTPOS_Y_POSXY_Y_SHIFT)
#define  DISTORT_TOP_DISTORT_CH2_DATASTARTPOS_Y_POSXY_Y_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_TOP_DISTORT_CH2_DATASTARTPOS_Y_POSXY_Y_MASK) | (((uint32_t)val) << DISTORT_TOP_DISTORT_CH2_DATASTARTPOS_Y_POSXY_Y_SHIFT))

#define  DISTORT_TOP_DISTORT_CH2_DATASTARTPOS_Y_F_POSXY_Y_MASK 0xffff
#define  DISTORT_TOP_DISTORT_CH2_DATASTARTPOS_Y_F_POSXY_Y_SHIFT 0
#define  DISTORT_TOP_DISTORT_CH2_DATASTARTPOS_Y_F_POSXY_Y_MASK_SHIFT(reg) (((reg) & DISTORT_TOP_DISTORT_CH2_DATASTARTPOS_Y_F_POSXY_Y_MASK) >> DISTORT_TOP_DISTORT_CH2_DATASTARTPOS_Y_F_POSXY_Y_SHIFT)
#define  DISTORT_TOP_DISTORT_CH2_DATASTARTPOS_Y_F_POSXY_Y_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_TOP_DISTORT_CH2_DATASTARTPOS_Y_F_POSXY_Y_MASK) | (((uint32_t)val) << DISTORT_TOP_DISTORT_CH2_DATASTARTPOS_Y_F_POSXY_Y_SHIFT))

//====================================================================
//Register: CH3 Vertical Data Start Position (Ch3_DataStartPos_Y)
/** \brief Sets the vertical data starting position for channel 3. The staring position is a signed value with two parts: a 16-bit whole number and a 16-bit fractional number.*/
//====================================================================

#define  DISTORT_TOP_DISTORT_CH3_DATASTARTPOS_Y_POSXY_Y_MASK 0xffff0000
#define  DISTORT_TOP_DISTORT_CH3_DATASTARTPOS_Y_POSXY_Y_SHIFT 16
#define  DISTORT_TOP_DISTORT_CH3_DATASTARTPOS_Y_POSXY_Y_MASK_SHIFT(reg) (((reg) & DISTORT_TOP_DISTORT_CH3_DATASTARTPOS_Y_POSXY_Y_MASK) >> DISTORT_TOP_DISTORT_CH3_DATASTARTPOS_Y_POSXY_Y_SHIFT)
#define  DISTORT_TOP_DISTORT_CH3_DATASTARTPOS_Y_POSXY_Y_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_TOP_DISTORT_CH3_DATASTARTPOS_Y_POSXY_Y_MASK) | (((uint32_t)val) << DISTORT_TOP_DISTORT_CH3_DATASTARTPOS_Y_POSXY_Y_SHIFT))

#define  DISTORT_TOP_DISTORT_CH3_DATASTARTPOS_Y_F_POSXY_Y_MASK 0xffff
#define  DISTORT_TOP_DISTORT_CH3_DATASTARTPOS_Y_F_POSXY_Y_SHIFT 0
#define  DISTORT_TOP_DISTORT_CH3_DATASTARTPOS_Y_F_POSXY_Y_MASK_SHIFT(reg) (((reg) & DISTORT_TOP_DISTORT_CH3_DATASTARTPOS_Y_F_POSXY_Y_MASK) >> DISTORT_TOP_DISTORT_CH3_DATASTARTPOS_Y_F_POSXY_Y_SHIFT)
#define  DISTORT_TOP_DISTORT_CH3_DATASTARTPOS_Y_F_POSXY_Y_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_TOP_DISTORT_CH3_DATASTARTPOS_Y_F_POSXY_Y_MASK) | (((uint32_t)val) << DISTORT_TOP_DISTORT_CH3_DATASTARTPOS_Y_F_POSXY_Y_SHIFT))

//====================================================================
//Register: Fixed Row Step X for channel 1 (Ch1_FixedRowStepX)
/** \brief When map mode for channel 1 is disabled, this row step is used instead of reading steps from the map block. This register contains the row step in the X dimension.*/
//====================================================================

#define  DISTORT_TOP_DISTORT_CH1_FIXEDROWSTEPX_RESERVED1_MASK 0xfff00000
#define  DISTORT_TOP_DISTORT_CH1_FIXEDROWSTEPX_RESERVED1_SHIFT 20
#define  DISTORT_TOP_DISTORT_CH1_FIXEDROWSTEPX_RESERVED1_MASK_SHIFT(reg) (((reg) & DISTORT_TOP_DISTORT_CH1_FIXEDROWSTEPX_RESERVED1_MASK) >> DISTORT_TOP_DISTORT_CH1_FIXEDROWSTEPX_RESERVED1_SHIFT)
#define  DISTORT_TOP_DISTORT_CH1_FIXEDROWSTEPX_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_TOP_DISTORT_CH1_FIXEDROWSTEPX_RESERVED1_MASK) | (((uint32_t)val) << DISTORT_TOP_DISTORT_CH1_FIXEDROWSTEPX_RESERVED1_SHIFT))

#define  DISTORT_TOP_DISTORT_CH1_FIXEDROWSTEPX_ROWSTEPX_MASK 0xfffff
#define  DISTORT_TOP_DISTORT_CH1_FIXEDROWSTEPX_ROWSTEPX_SHIFT 0
#define  DISTORT_TOP_DISTORT_CH1_FIXEDROWSTEPX_ROWSTEPX_MASK_SHIFT(reg) (((reg) & DISTORT_TOP_DISTORT_CH1_FIXEDROWSTEPX_ROWSTEPX_MASK) >> DISTORT_TOP_DISTORT_CH1_FIXEDROWSTEPX_ROWSTEPX_SHIFT)
#define  DISTORT_TOP_DISTORT_CH1_FIXEDROWSTEPX_ROWSTEPX_REPLACE_VAL(reg,val) (((reg) & ~DISTORT_TOP_DISTORT_CH1_FIXEDROWSTEPX_ROWSTEPX_MASK) | (((uint32_t)val) << DISTORT_TOP