 /*
 **************************************************************************************
 *
 * (c) Copyright 2013 Marvell International Ltd.
 *
 *
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/.
 *
 **************************************************************************************
 *
 * \file PIE_OT32_POGO_regstructs.h
 * Generated using RegBuild 1.6.3
 *
 **************************************************************************************
 */

#ifndef _POGO_PIE_OT32_REGSTRUCTS_H_
#define _POGO_PIE_OT32_REGSTRUCTS_H_

#include "hwincl.h"

//====================================================================
//
//Register File: PIE Object Type x32 Pogoizer (POGO_PIE_OT32)
/** \brief (rev 0 . 6 . 1 . 0)
    These registers provide the means to program the characteristics of the desired
    pogoizing operation.*/
//
//====================================================================

typedef struct POGO_PIE_OT32_REGS_s
{
  volatile uint32_t Cfg;  ///< 0x0 [R/W]: Pogoizer Configuration Register
  volatile uint32_t LPad;  ///< 0x4 [R/W]: Left Side Padding Register
  volatile uint32_t RPad;  ///< 0x8 [R/W]: Right Side Padding Register
  volatile uint32_t reserved0;
  volatile uint32_t LVal0;  ///< 0x10 [R/W]: Left Side Padding Value Register (Instance 1 of 1)
  volatile uint32_t reserved1[3];
  volatile uint32_t RVal0;  ///< 0x20 [R/W]: Right Side Padding Value Register (Instance 1 of 1)
  volatile uint32_t reserved2[5];
  volatile uint32_t LTrunc;  ///< 0x38 [R/W]: Left Side Truncation Boundary
  volatile uint32_t RTrunc;  ///< 0x3c [R/W]: Right Side Truncation Boundary
  volatile uint32_t REV0;  ///< 0x40 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0x44 [R]: IP Tagging Revision 1
} POGO_PIE_OT32_REGS_t;

#endif // POGO_PIE_OT32
 /*
 **************************************************************************************
 *
 * (c) Copyright 2013 Marvell International Ltd.
 *
 *
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/.
 *
 **************************************************************************************
 *
 * \file PIE_OT32_POGO_regmasks.h
 * Generated using RegBuild 1.6.3
 *
 **************************************************************************************
 */

#ifndef _POGO_PIE_OT32_REGMASKS_H_
#define _POGO_PIE_OT32_REGMASKS_H_

#include "hwincl.h"

//====================================================================
//
//Register File: PIE Object Type x32 Pogoizer (POGO_PIE_OT32)
/** \brief (rev 0 . 6 . 1 . 0)
    These registers provide the means to program the characteristics of the desired
    pogoizing operation.*/
//
//====================================================================

//====================================================================
//Register: Pogoizer Configuration Register (Cfg)
/** \brief The fields in this register are used to configure the characteristics of the desired
      pogoizing operation.*/
//====================================================================

#define  POGO_PIE_OT32_CFG_RESERVED1_MASK 0xffffc000
#define  POGO_PIE_OT32_CFG_RESERVED1_SHIFT 14
#define  POGO_PIE_OT32_CFG_RESERVED1_MASK_SHIFT(reg) (((reg) & POGO_PIE_OT32_CFG_RESERVED1_MASK) >> POGO_PIE_OT32_CFG_RESERVED1_SHIFT)
#define  POGO_PIE_OT32_CFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~POGO_PIE_OT32_CFG_RESERVED1_MASK) | (((uint32_t)val) << POGO_PIE_OT32_CFG_RESERVED1_SHIFT))

#define  POGO_PIE_OT32_CFG_PIXORDER_MASK 0x2000
#define  POGO_PIE_OT32_CFG_PIXORDER_SHIFT 13
#define  POGO_PIE_OT32_CFG_PIXORDER_MASK_SHIFT(reg) (((reg) & POGO_PIE_OT32_CFG_PIXORDER_MASK) >> POGO_PIE_OT32_CFG_PIXORDER_SHIFT)
#define  POGO_PIE_OT32_CFG_PIXORDER_REPLACE_VAL(reg,val) (((reg) & ~POGO_PIE_OT32_CFG_PIXORDER_MASK) | (((uint32_t)val) << POGO_PIE_OT32_CFG_PIXORDER_SHIFT))

#define  POGO_PIE_OT32_CFG_RESERVED2_MASK 0x1000
#define  POGO_PIE_OT32_CFG_RESERVED2_SHIFT 12
#define  POGO_PIE_OT32_CFG_RESERVED2_MASK_SHIFT(reg) (((reg) & POGO_PIE_OT32_CFG_RESERVED2_MASK) >> POGO_PIE_OT32_CFG_RESERVED2_SHIFT)
#define  POGO_PIE_OT32_CFG_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~POGO_PIE_OT32_CFG_RESERVED2_MASK) | (((uint32_t)val) << POGO_PIE_OT32_CFG_RESERVED2_SHIFT))

#define  POGO_PIE_OT32_CFG_SCALEX_MASK 0xc00
#define  POGO_PIE_OT32_CFG_SCALEX_SHIFT 10
#define  POGO_PIE_OT32_CFG_SCALEX_MASK_SHIFT(reg) (((reg) & POGO_PIE_OT32_CFG_SCALEX_MASK) >> POGO_PIE_OT32_CFG_SCALEX_SHIFT)
#define  POGO_PIE_OT32_CFG_SCALEX_REPLACE_VAL(reg,val) (((reg) & ~POGO_PIE_OT32_CFG_SCALEX_MASK) | (((uint32_t)val) << POGO_PIE_OT32_CFG_SCALEX_SHIFT))

#define  POGO_PIE_OT32_CFG_SCALEY_MASK 0x300
#define  POGO_PIE_OT32_CFG_SCALEY_SHIFT 8
#define  POGO_PIE_OT32_CFG_SCALEY_MASK_SHIFT(reg) (((reg) & POGO_PIE_OT32_CFG_SCALEY_MASK) >> POGO_PIE_OT32_CFG_SCALEY_SHIFT)
#define  POGO_PIE_OT32_CFG_SCALEY_REPLACE_VAL(reg,val) (((reg) & ~POGO_PIE_OT32_CFG_SCALEY_MASK) | (((uint32_t)val) << POGO_PIE_OT32_CFG_SCALEY_SHIFT))

#define  POGO_PIE_OT32_CFG_RESERVED3_MASK 0x80
#define  POGO_PIE_OT32_CFG_RESERVED3_SHIFT 7
#define  POGO_PIE_OT32_CFG_RESERVED3_MASK_SHIFT(reg) (((reg) & POGO_PIE_OT32_CFG_RESERVED3_MASK) >> POGO_PIE_OT32_CFG_RESERVED3_SHIFT)
#define  POGO_PIE_OT32_CFG_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~POGO_PIE_OT32_CFG_RESERVED3_MASK) | (((uint32_t)val) << POGO_PIE_OT32_CFG_RESERVED3_SHIFT))

#define  POGO_PIE_OT32_CFG_BPP_MASK 0x70
#define  POGO_PIE_OT32_CFG_BPP_SHIFT 4
#define  POGO_PIE_OT32_CFG_BPP_MASK_SHIFT(reg) (((reg) & POGO_PIE_OT32_CFG_BPP_MASK) >> POGO_PIE_OT32_CFG_BPP_SHIFT)
#define  POGO_PIE_OT32_CFG_BPP_REPLACE_VAL(reg,val) (((reg) & ~POGO_PIE_OT32_CFG_BPP_MASK) | (((uint32_t)val) << POGO_PIE_OT32_CFG_BPP_SHIFT))

#define  POGO_PIE_OT32_CFG_COLORSWAP_MASK 0x8
#define  POGO_PIE_OT32_CFG_COLORSWAP_SHIFT 3
#define  POGO_PIE_OT32_CFG_COLORSWAP_MASK_SHIFT(reg) (((reg) & POGO_PIE_OT32_CFG_COLORSWAP_MASK) >> POGO_PIE_OT32_CFG_COLORSWAP_SHIFT)
#define  POGO_PIE_OT32_CFG_COLORSWAP_REPLACE_VAL(reg,val) (((reg) & ~POGO_PIE_OT32_CFG_COLORSWAP_MASK) | (((uint32_t)val) << POGO_PIE_OT32_CFG_COLORSWAP_SHIFT))

#define  POGO_PIE_OT32_CFG_FMT_MASK 0x7
#define  POGO_PIE_OT32_CFG_FMT_SHIFT 0
#define  POGO_PIE_OT32_CFG_FMT_MASK_SHIFT(reg) (((reg) & POGO_PIE_OT32_CFG_FMT_MASK) >> POGO_PIE_OT32_CFG_FMT_SHIFT)
#define  POGO_PIE_OT32_CFG_FMT_REPLACE_VAL(reg,val) (((reg) & ~POGO_PIE_OT32_CFG_FMT_MASK) | (((uint32_t)val) << POGO_PIE_OT32_CFG_FMT_SHIFT))

//====================================================================
//Register: Left Side Padding Register (LPad)
/** \brief This register configures left side padding.*/
//====================================================================

#define  POGO_PIE_OT32_LPAD_RESERVED1_MASK 0xfffe0000
#define  POGO_PIE_OT32_LPAD_RESERVED1_SHIFT 17
#define  POGO_PIE_OT32_LPAD_RESERVED1_MASK_SHIFT(reg) (((reg) & POGO_PIE_OT32_LPAD_RESERVED1_MASK) >> POGO_PIE_OT32_LPAD_RESERVED1_SHIFT)
#define  POGO_PIE_OT32_LPAD_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~POGO_PIE_OT32_LPAD_RESERVED1_MASK) | (((uint32_t)val) << POGO_PIE_OT32_LPAD_RESERVED1_SHIFT))

#define  POGO_PIE_OT32_LPAD_LEFTEDGEFILL_MASK 0x10000
#define  POGO_PIE_OT32_LPAD_LEFTEDGEFILL_SHIFT 16
#define  POGO_PIE_OT32_LPAD_LEFTEDGEFILL_MASK_SHIFT(reg) (((reg) & POGO_PIE_OT32_LPAD_LEFTEDGEFILL_MASK) >> POGO_PIE_OT32_LPAD_LEFTEDGEFILL_SHIFT)
#define  POGO_PIE_OT32_LPAD_LEFTEDGEFILL_REPLACE_VAL(reg,val) (((reg) & ~POGO_PIE_OT32_LPAD_LEFTEDGEFILL_MASK) | (((uint32_t)val) << POGO_PIE_OT32_LPAD_LEFTEDGEFILL_SHIFT))

#define  POGO_PIE_OT32_LPAD_LEFTLEN_MASK 0xffff
#define  POGO_PIE_OT32_LPAD_LEFTLEN_SHIFT 0
#define  POGO_PIE_OT32_LPAD_LEFTLEN_MASK_SHIFT(reg) (((reg) & POGO_PIE_OT32_LPAD_LEFTLEN_MASK) >> POGO_PIE_OT32_LPAD_LEFTLEN_SHIFT)
#define  POGO_PIE_OT32_LPAD_LEFTLEN_REPLACE_VAL(reg,val) (((reg) & ~POGO_PIE_OT32_LPAD_LEFTLEN_MASK) | (((uint32_t)val) << POGO_PIE_OT32_LPAD_LEFTLEN_SHIFT))

//====================================================================
//Register: Right Side Padding Register (RPad)
/** \brief This register configures right side padding.*/
//====================================================================

#define  POGO_PIE_OT32_RPAD_RESERVED1_MASK 0xfffe0000
#define  POGO_PIE_OT32_RPAD_RESERVED1_SHIFT 17
#define  POGO_PIE_OT32_RPAD_RESERVED1_MASK_SHIFT(reg) (((reg) & POGO_PIE_OT32_RPAD_RESERVED1_MASK) >> POGO_PIE_OT32_RPAD_RESERVED1_SHIFT)
#define  POGO_PIE_OT32_RPAD_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~POGO_PIE_OT32_RPAD_RESERVED1_MASK) | (((uint32_t)val) << POGO_PIE_OT32_RPAD_RESERVED1_SHIFT))

#define  POGO_PIE_OT32_RPAD_RIGHTEDGEFILL_MASK 0x10000
#define  POGO_PIE_OT32_RPAD_RIGHTEDGEFILL_SHIFT 16
#define  POGO_PIE_OT32_RPAD_RIGHTEDGEFILL_MASK_SHIFT(reg) (((reg) & POGO_PIE_OT32_RPAD_RIGHTEDGEFILL_MASK) >> POGO_PIE_OT32_RPAD_RIGHTEDGEFILL_SHIFT)
#define  POGO_PIE_OT32_RPAD_RIGHTEDGEFILL_REPLACE_VAL(reg,val) (((reg) & ~POGO_PIE_OT32_RPAD_RIGHTEDGEFILL_MASK) | (((uint32_t)val) << POGO_PIE_OT32_RPAD_RIGHTEDGEFILL_SHIFT))

#define  POGO_PIE_OT32_RPAD_RIGHTLEN_MASK 0xffff
#define  POGO_PIE_OT32_RPAD_RIGHTLEN_SHIFT 0
#define  POGO_PIE_OT32_RPAD_RIGHTLEN_MASK_SHIFT(reg) (((reg) & POGO_PIE_OT32_RPAD_RIGHTLEN_MASK) >> POGO_PIE_OT32_RPAD_RIGHTLEN_SHIFT)
#define  POGO_PIE_OT32_RPAD_RIGHTLEN_REPLACE_VAL(reg,val) (((reg) & ~POGO_PIE_OT32_RPAD_RIGHTLEN_MASK) | (((uint32_t)val) << POGO_PIE_OT32_RPAD_RIGHTLEN_SHIFT))

//====================================================================
//Register: Left Side Padding Value Register (Instance 1 of 1) (LVal0)
/** \brief This register contains the pad value for the left side if leftEdgeFill is not set.
      There is one register per color. For RGB data, the R left pad value should be written
      to the 0th register in the array, the G value should be written to the 1st register,
      and the B value should be written to the 2nd register. For CMYK, the C value should
      written to the 0th register, the M value to the 1st register, and so forth. (Instance 1 of 1)*/
//====================================================================

#define  POGO_PIE_OT32_LVAL0_LEFTVAL_MASK 0xffffffff
#define  POGO_PIE_OT32_LVAL0_LEFTVAL_SHIFT 0
#define  POGO_PIE_OT32_LVAL0_LEFTVAL_MASK_SHIFT(reg) (((reg) & POGO_PIE_OT32_LVAL0_LEFTVAL_MASK) >> POGO_PIE_OT32_LVAL0_LEFTVAL_SHIFT)
#define  POGO_PIE_OT32_LVAL0_LEFTVAL_REPLACE_VAL(reg,val) (((reg) & ~POGO_PIE_OT32_LVAL0_LEFTVAL_MASK) | (((uint32_t)val) << POGO_PIE_OT32_LVAL0_LEFTVAL_SHIFT))

//====================================================================
//Register: Right Side Padding Value Register (Instance 1 of 1) (RVal0)
/** \brief This register contains the pad value for the right side if rightEdgeFill is not set.
      There is one register per color. For RGB data, the R right pad value should be written
      to the 0th register in the array, the G value should be written to the 1st register,
      and the B value should be written to the 2nd register. For CMYK, the C value should
      written to the 0th register, the M value to the 1st register, and so forth. (Instance 1 of 1)*/
//====================================================================

#define  POGO_PIE_OT32_RVAL0_RIGHTVAL_MASK 0xffffffff
#define  POGO_PIE_OT32_RVAL0_RIGHTVAL_SHIFT 0
#define  POGO_PIE_OT32_RVAL0_RIGHTVAL_MASK_SHIFT(reg) (((reg) & POGO_PIE_OT32_RVAL0_RIGHTVAL_MASK) >> POGO_PIE_OT32_RVAL0_RIGHTVAL_SHIFT)
#define  POGO_PIE_OT32_RVAL0_RIGHTVAL_REPLACE_VAL(reg,val) (((reg) & ~POGO_PIE_OT32_RVAL0_RIGHTVAL_MASK) | (((uint32_t)val) << POGO_PIE_OT32_RVAL0_RIGHTVAL_SHIFT))

//====================================================================
//Register: Left Side Truncation Boundary (LTrunc)
/** \brief This register is used to specify the left side truncation boundary. Specify the first
      column of the scaled input image that should be included in the output. Note that if
      left side replicate padding is also specified, the specified column will be the one
      that is replicated on the left side of the image.*/
//====================================================================

#define  POGO_PIE_OT32_LTRUNC_RESERVED1_MASK 0xffff0000
#define  POGO_PIE_OT32_LTRUNC_RESERVED1_SHIFT 16
#define  POGO_PIE_OT32_LTRUNC_RESERVED1_MASK_SHIFT(reg) (((reg) & POGO_PIE_OT32_LTRUNC_RESERVED1_MASK) >> POGO_PIE_OT32_LTRUNC_RESERVED1_SHIFT)
#define  POGO_PIE_OT32_LTRUNC_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~POGO_PIE_OT32_LTRUNC_RESERVED1_MASK) | (((uint32_t)val) << POGO_PIE_OT32_LTRUNC_RESERVED1_SHIFT))

#define  POGO_PIE_OT32_LTRUNC_FIRSTCOLUMN_MASK 0xffff
#define  POGO_PIE_OT32_LTRUNC_FIRSTCOLUMN_SHIFT 0
#define  POGO_PIE_OT32_LTRUNC_FIRSTCOLUMN_MASK_SHIFT(reg) (((reg) & POGO_PIE_OT32_LTRUNC_FIRSTCOLUMN_MASK) >> POGO_PIE_OT32_LTRUNC_FIRSTCOLUMN_SHIFT)
#define  POGO_PIE_OT32_LTRUNC_FIRSTCOLUMN_REPLACE_VAL(reg,val) (((reg) & ~POGO_PIE_OT32_LTRUNC_FIRSTCOLUMN_MASK) | (((uint32_t)val) << POGO_PIE_OT32_LTRUNC_FIRSTCOLUMN_SHIFT))

//====================================================================
//Register: Right Side Truncation Boundary (RTrunc)
/** \brief This register is used to specify the right side truncation boundary. Specify the last
      column of the scaled input image that should be included in the output. Note that if
      right side replicate padding is also specified, the specified column will be the one
      that is replicated on the right side of the image.*/
//====================================================================

#define  POGO_PIE_OT32_RTRUNC_RESERVED1_MASK 0xffff0000
#define  POGO_PIE_OT32_RTRUNC_RESERVED1_SHIFT 16
#define  POGO_PIE_OT32_RTRUNC_RESERVED1_MASK_SHIFT(reg) (((reg) & POGO_PIE_OT32_RTRUNC_RESERVED1_MASK) >> POGO_PIE_OT32_RTRUNC_RESERVED1_SHIFT)
#define  POGO_PIE_OT32_RTRUNC_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~POGO_PIE_OT32_RTRUNC_RESERVED1_MASK) | (((uint32_t)val) << POGO_PIE_OT32_RTRUNC_RESERVED1_SHIFT))

#define  POGO_PIE_OT32_RTRUNC_LASTCOLUMN_MASK 0xffff
#define  POGO_PIE_OT32_RTRUNC_LASTCOLUMN_SHIFT 0
#define  POGO_PIE_OT32_RTRUNC_LASTCOLUMN_MASK_SHIFT(reg) (((reg) & POGO_PIE_OT32_RTRUNC_LASTCOLUMN_MASK) >> POGO_PIE_OT32_RTRUNC_LASTCOLUMN_SHIFT)
#define  POGO_PIE_OT32_RTRUNC_LASTCOLUMN_REPLACE_VAL(reg,val) (((reg) & ~POGO_PIE_OT32_RTRUNC_LASTCOLUMN_MASK) | (((uint32_t)val) << POGO_PIE_OT32_RTRUNC_LASTCOLUMN_SHIFT))

//====================================================================
//Register: IP Tagging Revision 0 (REV0)
/** \brief Provide means for firmware to read IP tagging information.
      This register of particular interest to firmware.*/
//====================================================================

#define  POGO_PIE_OT32_REV0_MAJ_MASK 0xffff0000
#define  POGO_PIE_OT32_REV0_MAJ_SHIFT 16
#define  POGO_PIE_OT32_REV0_MAJ_MASK_SHIFT(reg) (((reg) & POGO_PIE_OT32_REV0_MAJ_MASK) >> POGO_PIE_OT32_REV0_MAJ_SHIFT)
#define  POGO_PIE_OT32_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~POGO_PIE_OT32_REV0_MAJ_MASK) | (((uint32_t)val) << POGO_PIE_OT32_REV0_MAJ_SHIFT))

#define  POGO_PIE_OT32_REV0_MID_MASK 0xffff
#define  POGO_PIE_OT32_REV0_MID_SHIFT 0
#define  POGO_PIE_OT32_REV0_MID_MASK_SHIFT(reg) (((reg) & POGO_PIE_OT32_REV0_MID_MASK) >> POGO_PIE_OT32_REV0_MID_SHIFT)
#define  POGO_PIE_OT32_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~POGO_PIE_OT32_REV0_MID_MASK) | (((uint32_t)val) << POGO_PIE_OT32_REV0_MID_SHIFT))

//====================================================================
//Register: IP Tagging Revision 1 (REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  POGO_PIE_OT32_REV1_RESERVED1_MASK 0xffff0000
#define  POGO_PIE_OT32_REV1_RESERVED1_SHIFT 16
#define  POGO_PIE_OT32_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & POGO_PIE_OT32_REV1_RESERVED1_MASK) >> POGO_PIE_OT32_REV1_RESERVED1_SHIFT)
#define  POGO_PIE_OT32_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~POGO_PIE_OT32_REV1_RESERVED1_MASK) | (((uint32_t)val) << POGO_PIE_OT32_REV1_RESERVED1_SHIFT))

#define  POGO_PIE_OT32_REV1_CFG_MASK 0xffff
#define  POGO_PIE_OT32_REV1_CFG_SHIFT 0
#define  POGO_PIE_OT32_REV1_CFG_MASK_SHIFT(reg) (((reg) & POGO_PIE_OT32_REV1_CFG_MASK) >> POGO_PIE_OT32_REV1_CFG_SHIFT)
#define  POGO_PIE_OT32_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~POGO_PIE_OT32_REV1_CFG_MASK) | (((uint32_t)val) << POGO_PIE_OT32_REV1_CFG_SHIFT))

#endif // POGO_PIE_OT32
