 /*
 **************************************************************************************
 *
 * (c) Copyright 2014 Marvell International Ltd.
 *
 *
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/.
 *
 **************************************************************************************
 *
 * \file PIC_regstructs.h
 * Generated using RegBuild 1.6.3
 *
 **************************************************************************************
 */

#ifndef _PIC_REGSTRUCTS_H_
#define _PIC_REGSTRUCTS_H_

#include "hwincl.h"

//====================================================================
//
//Register File: PIC (PIC)
/** \brief Register Descriptions for a PIC pipeline <br/> (rev 0 . 3 . 3 . 1)*/
//
//====================================================================

typedef struct PIC_REGS_s
{
  volatile uint32_t PCR;  ///< 0x0 [R/W]: PIC Control Register
  volatile uint32_t IENR;  ///< 0x4 [R/W]: Interrupt Enable Register
  volatile uint32_t IPR;  ///< 0x8 [R]: Interrupt Pending Register (IPR)
  volatile uint32_t IFR;  ///< 0xc [R/W]: Interrupt Force Register
  volatile uint32_t Debug;  ///< 0x10 [R]: Debug Data Observation
  volatile uint32_t REV0;  ///< 0x14 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0x18 [R]: IP Tagging Revision 1
} PIC_REGS_t;

//====================================================================
//
//Register File: PIC ADC Normalization (ADCNorm)
/** \brief Register Descriptions for the PIC ADCNorm block (rev 0 . 2 . 2 . 9)*/
//
//====================================================================

typedef struct ADCNORM_REGS_s
{
  volatile uint32_t ANR;  ///< 0x0 [R/W]: ADC Normalization Register
  volatile uint32_t reserved0[5];
  volatile uint32_t REV0;  ///< 0x18 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0x1c [R]: IP Tagging Revision 1
} ADCNORM_REGS_t;

//====================================================================
//
//Register File: PIC Bulb Monitor (BulbMon)
/** \brief Register Descriptions for the PIC BulbMon block (rev 0 . 0 . 3 . 7)*/
//
//====================================================================

typedef struct BULBMON_REGS_s
{
  volatile uint32_t BMCR;  ///< 0x0 [R/W]: Bulb Monitor Configuration Register
  volatile uint32_t BMR0;  ///< 0x4 [R]: Bulb Monitor Color0 Register
  volatile uint32_t BMR1;  ///< 0x8 [R]: Bulb Monitor Color1 Register
  volatile uint32_t BMR2;  ///< 0xc [R]: Bulb Monitor Color2 Register
  volatile uint32_t BMR3;  ///< 0x10 [R]: Bulb Monitor Exposure Register
  volatile uint32_t REV0;  ///< 0x14 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0x18 [R]: IP Tagging Revision 1
} BULBMON_REGS_t;

//====================================================================
//
//Register File: PIC L/R Margin0 (LRMargin0)
/** \brief Register Descriptions for the PIC LRMargin block (rev 0 . 2 . 3 . 8)*/
//
//====================================================================

typedef struct LRMARGIN0_REGS_s
{
  volatile uint32_t LRCR;  ///< 0x0 [R/W]: Left/Right Margins Configuration Register
  volatile uint32_t LRMR0;  ///< 0x4 [R/W]: Left/Right Margins Register
  volatile uint32_t LRMR1;  ///< 0x8 [R/W]: Left/Right Margins Register
  volatile uint32_t LRMR2;  ///< 0xc [R/W]: Left/Right Margins Register
  volatile uint32_t REV0;  ///< 0x10 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0x14 [R]: IP Tagging Revision 1
} LRMARGIN0_REGS_t;

//====================================================================
//
//Register File: PIC IDMA_2D (IDMA_2D)
/** \brief Register Descriptions for the PIC IDMA_2D block (rev 0 . 1 . 0 . 0)*/
//
//====================================================================

typedef struct IDMA_2D_REGS_s
{
  volatile uint32_t cfg;  ///< 0x0 [R/W]: Configuration register
  volatile uint32_t status;  ///< 0x4 [R]: Status register
  volatile uint32_t line_width;  ///< 0x8 [R/W]: Line Width register
  volatile uint32_t int_en;  ///< 0xc [R/W]: Interrupt Enable Register
  volatile uint32_t int_st;  ///< 0x10 [R]: Interrupt Pending Register
  volatile uint32_t int_cl;  ///< 0x14 [W]: Interrupt Clear Register
  volatile uint32_t int_fo;  ///< 0x18 [W]: Interrupt Force Register
  volatile uint32_t desc_write;  ///< 0x1c [W]: Descriptor Write Register
  volatile uint32_t desc_read;  ///< 0x20 [R]: Descriptor Read Register
  volatile uint32_t xfer_length;  ///< 0x24 [R]: Descriptor Transfer Length Register
  volatile uint32_t xfer_addr;  ///< 0x28 [R]: Descriptor Transfer Address Register
  volatile uint32_t ctrl_word;  ///< 0x2c [R]: Descriptor Control Word Register
  volatile uint32_t reset;  ///< 0x30 [W]: Soft Reset register
  volatile uint32_t REV0;  ///< 0x34 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0x38 [R]: IP Tagging Revision 1
} IDMA_2D_REGS_t;

//====================================================================
//
//Register File: PIC PRNUDSNU Correction (PRNUDSNU)
/** \brief Register Descriptions for the PRNUDSNU Correction block (rev 0 . 2 . 3 . 0)*/
//
//====================================================================

typedef struct PRNUDSNU_REGS_s
{
  volatile uint32_t RLSCR;  ///< 0x0 [R/W]: Left and Right Starting Gain Configuration Register
  volatile uint32_t LSVCR;  ///< 0x4 [R/W]: Left Slope Value Configuration Register
  volatile uint32_t LMPCR0;  ///< 0x8 [R/W]: Left Max Pixel Configuration Register - Color0
  volatile uint32_t LMPCR1;  ///< 0xc [R/W]: Left Max Pixel Configuration Register - Color1
  volatile uint32_t LMPCR2;  ///< 0x10 [R/W]: Left Max Pixel Configuration Register - Color2
  volatile uint32_t RSVCR;  ///< 0x14 [R/W]: Right Slope Value Configuration Register
  volatile uint32_t RSPCR0;  ///< 0x18 [R/W]: Right Start pixel Configuration Register - Color0
  volatile uint32_t RSPCR1;  ///< 0x1c [R/W]: Right Start pixel Configuration Register - Color1
  volatile uint32_t RSPCR2;  ///< 0x20 [R/W]: Right Start pixel Configuration Register - Color2
  volatile uint32_t PDCR1;  ///< 0x24 [R/W]: PRNU/DSNU Configuration Register1
  volatile uint32_t reserved0[3];
  volatile uint32_t PDCR2;  ///< 0x34 [R/W]: PRNU/DSNU Configuration Register2
  volatile uint32_t PONCR;  ///< 0x38 [R/W]: Percentage of Nominal Configuration Register
  volatile uint32_t QUAD;  ///< 0x3c [R/W]: Quadratic Configuration
  volatile uint32_t DOFF0;  ///< 0x40 [R/W]: DSNU Offset Register (Instance 1 of 3)
  volatile uint32_t DOFF1;  ///< 0x44 [R/W]: DSNU Offset Register (Instance 2 of 3)
  volatile uint32_t DOFF2;  ///< 0x48 [R/W]: DSNU Offset Register (Instance 3 of 3)
  volatile uint32_t DMULT0;  ///< 0x4c [R/W]: DSNU Mult/Scale Register (Instance 1 of 3)
  volatile uint32_t DMULT1;  ///< 0x50 [R/W]: DSNU Mult/Scale Register (Instance 2 of 3)
  volatile uint32_t DMULT2;  ///< 0x54 [R/W]: DSNU Mult/Scale Register (Instance 3 of 3)
  volatile uint32_t POFF0;  ///< 0x58 [R/W]: PRNU Offset Register (Instance 1 of 3)
  volatile uint32_t POFF1;  ///< 0x5c [R/W]: PRNU Offset Register (Instance 2 of 3)
  volatile uint32_t POFF2;  ///< 0x60 [R/W]: PRNU Offset Register (Instance 3 of 3)
  volatile uint32_t PMULT0;  ///< 0x64 [R/W]: PRNU Mult/Scale Register (Instance 1 of 3)
  volatile uint32_t PMULT1;  ///< 0x68 [R/W]: PRNU Mult/Scale Register (Instance 2 of 3)
  volatile uint32_t PMULT2;  ///< 0x6c [R/W]: PRNU Mult/Scale Register (Instance 3 of 3)
  volatile uint32_t REV0;  ///< 0x70 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0x74 [R]: IP Tagging Revision 1
} PRNUDSNU_REGS_t;

//====================================================================
//
//Register File: NEWMAN Horizontal Chip Gap Correction (NEWMAN)
/** \brief NEWMAN Horizontal Chip Gap Correction (rev 0 . 0 . 4 . 5)*/
//
//====================================================================

typedef struct NEWMAN_REGS_s
{
  volatile uint32_t CFG;  ///< 0x0 [R/W]: NEWMAN Configuration Register
  volatile uint32_t LOCAT;  ///< 0x4 [R/W]: NEWMAN Location Register
  volatile uint32_t INSERT0;  ///< 0x8 [R/W]: NEWMAN Insertion Register 0/3
  volatile uint32_t INSERT1;  ///< 0xc [R/W]: NEWMAN Insertion Register 0/1
  volatile uint32_t INSERT2;  ///< 0x10 [R/W]: NEWMAN Insertion Register 2/3
  volatile uint32_t INSERT3;  ///< 0x14 [R/W]: NEWMAN Insertion Register 3/3
  volatile uint32_t REV0;  ///< 0x18 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0x1c [R]: IP Tagging Revision 1
} NEWMAN_REGS_t;

//====================================================================
//
//Register File: PageSense / ECD Detect (PS_ESD)
//
//====================================================================

typedef struct PS_ESD_REGS_s
{
  volatile uint32_t ESD_CFG;  ///< 0x0 [R/W]: ESD Configuration
  volatile uint32_t ESD_START_0_R;  ///< 0x4 [R/W]: ESD Start Address
  volatile uint32_t ESD_START_1_G;  ///< 0x8 [R/W]: ESD Start Address 1
  volatile uint32_t ESD_START_2_B;  ///< 0xc [R/W]: ESD Start Address 2
  volatile uint32_t ESD_TOL;  ///< 0x10 [R/W]: ESD Tolerance
  volatile uint32_t ESD_CHG;  ///< 0x14 [R/W]: ESD Change
  volatile uint32_t ESD_RST;  ///< 0x18 [W]: ESD Color Reset
  volatile uint32_t ESD_LCNT0;  ///< 0x1c [R]: ESD Event Line Count Color0
  volatile uint32_t ESD_LCNT1;  ///< 0x20 [R]: ESD Event Line Count Color1
  volatile uint32_t ESD_LCNT2;  ///< 0x24 [R]: ESD Event Line Count Color2
  volatile uint32_t PS_CFG;  ///< 0x28 [R/W]: PageSense Configuration
  volatile uint32_t PS_GO;  ///< 0x2c [W]: PageSense Go
  volatile uint32_t PS_START;  ///< 0x30 [R/W]: PageSense Start Pixel
  volatile uint32_t PS_WIDTH0;  ///< 0x34 [R/W]: PageSense Region Widths 0
  volatile uint32_t PS_WIDTH1;  ///< 0x38 [R/W]: PageSense Region Widths 1
  volatile uint32_t PS_TOL;  ///< 0x3c [R/W]: PageSense Region Tolerance
  volatile uint32_t PS_TOTAL_WID;  ///< 0x40 [R/W]: PageSense Overall Width
  volatile uint32_t PS_TOGGLE;  ///< 0x44 [R/W]: PageSense Toggle Delta
  volatile uint32_t PS_CNT;  ///< 0x48 [R/W]: PageSense Count
  volatile uint32_t PS_LCNT;  ///< 0x4c [R]: PageSense Detect Line Count
  volatile uint32_t PS_FILT;  ///< 0x50 [R]: PageSense Filter Capture
  volatile uint32_t PS_STAT;  ///< 0x54 [R]: PageSense Status
  volatile uint32_t LCNT;  ///< 0x58 [R]: Line Counter
  volatile uint32_t LCNT_WR;  ///< 0x5c [W]: Line Counter
  volatile uint32_t IEN;  ///< 0x60 [R/W]: Interrupt Enable Register
  volatile uint32_t IPEND;  ///< 0x64 [R]: Interrupt Pending Register
  volatile uint32_t IACK;  ///< 0x68 [W]: Interrupt Acknowledge Register
  volatile uint32_t IFORCE;  ///< 0x6c [W]: Interrupt Force Register
  volatile uint32_t REV0;  ///< 0x70 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0x74 [R]: IP Tagging Revision 1
} PS_ESD_REGS_t;

//====================================================================
//
//Register File: PIC Horizontal FIR (HFIR)
/** \brief Register file for the HFIR block (rev 0 . 2 . 2 . 6)*/
//
//====================================================================

typedef struct HFIR_REGS_s
{
  volatile uint32_t Cfg;  ///< 0x0 [R/W]: HFIR Configuration Register
  volatile uint32_t coeff0_1;  ///< 0x4 [R/W]: HFIR Coefficient set 0 and 1
  volatile uint32_t coeff2_3;  ///< 0x8 [R/W]: HFIR Coefficient set 2 and 3
  volatile uint32_t coeff4_5;  ///< 0xc [R/W]: HFIR Coefficient set 4 and 5
  volatile uint32_t coeff6_7;  ///< 0x10 [R/W]: HFIR Coefficient set 6 and 7
  volatile uint32_t coeff8_9;  ///< 0x14 [R/W]: HFIR Coefficient set 8 and 9
  volatile uint32_t coeff10_11;  ///< 0x18 [R/W]: HFIR Coefficient set 10 and 11
  volatile uint32_t coeff12_13;  ///< 0x1c [R/W]: HFIR Coefficient set 12 and 13
  volatile uint32_t coeff14_15;  ///< 0x20 [R/W]: HFIR Coefficient set 14 and 15
  volatile uint32_t CSum;  ///< 0x24 [R]: Check Sum
  volatile uint32_t REV0;  ///< 0x28 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0x2c [R]: IP Tagging Revision 1
} HFIR_REGS_t;

//====================================================================
//
//Register File: PIC Horizontal Scale (HScale)
/** \brief Register Descriptions for the PIC HScale block (rev 0 . 2 . 2 . 5)*/
//
//====================================================================

typedef struct HSCALE_REGS_s
{
  volatile uint32_t HSCR;  ///< 0x0 [R/W]: Horizontal Scaler Configuration Register
  volatile uint32_t HSSR;  ///< 0x4 [R/W]: Horizontal Scaler Scale Register
  volatile uint32_t REV0;  ///< 0x8 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0xc [R]: IP Tagging Revision 1
} HSCALE_REGS_t;

//====================================================================
//
//Register File: PIC L/R Margin1 (LRMargin1)
/** \brief Register Descriptions for the PIC LRMargin block (rev 0 . 2 . 3 . 8)*/
//
//====================================================================

typedef struct LRMARGIN1_REGS_s
{
  volatile uint32_t LRCR;  ///< 0x0 [R/W]: Left/Right Margins Configuration Register
  volatile uint32_t LRMR0;  ///< 0x4 [R/W]: Left/Right Margins Register
  volatile uint32_t LRMR1;  ///< 0x8 [R/W]: Left/Right Margins Register
  volatile uint32_t LRMR2;  ///< 0xc [R/W]: Left/Right Margins Register
  volatile uint32_t REV0;  ///< 0x10 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0x14 [R]: IP Tagging Revision 1
} LRMARGIN1_REGS_t;

//====================================================================
//
//Register File: PIC DMA Write (PIC_WDMA)
/** \brief Register Descriptions for the multi-channel PIC WDMA block (rev 0 . 2 . 4 . 4)*/
//
//====================================================================

typedef struct PIC_WDMA_REGS_s
{
  volatile uint32_t DWOCR;  ///< 0x0 [R/W]: PIC WDMA Configuration Register
  volatile uint32_t DWRTBL;  ///< 0x4 [R/W]: PIC WDMA Router Table Register
  volatile uint32_t DWCIS;  ///< 0x8 [R/W]: PIC Write DMA Common Interrupt Select
  volatile uint32_t REV0;  ///< 0xc [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0x10 [R]: IP Tagging Revision 1
} PIC_WDMA_REGS_t;

//====================================================================
//
//Register File: Skew Detect (SKEWDET)
/** \brief Register descriptions for the SKEWDET block.*/
//
//====================================================================

typedef struct SKEWDET_REGS_s
{
  volatile uint32_t CA;  ///< 0x0 [R/W]: Channel Address
  volatile uint32_t Ctl;  ///< 0x4 [R/W]: Control
  volatile uint32_t Compare;  ///< 0x8 [R/W]: Compare Threshold
  volatile uint32_t MaxLineCnt;  ///< 0xc [R/W]: Max Line Count
  volatile uint32_t RdMemAddr;  ///< 0x10 [R]: Read Memory Address
  volatile uint32_t WrMemAddr;  ///< 0x14 [W]: Write Memory Address
  volatile uint32_t RdMemData;  ///< 0x18 [R]: Memory Read
  volatile uint32_t WrMemData;  ///< 0x1c [W]: Memory Write
  volatile uint32_t int_enable;  ///< 0x20 [R/W]: Interrupt enable register
  volatile uint32_t int_pending;  ///< 0x24 [R]: Interrupt pending register
  volatile uint32_t int_status;  ///< 0x28 [R]: Interrupt status register
  volatile uint32_t int_ack;  ///< 0x2c [W]: Interrupt acknowledge register
  volatile uint32_t int_force;  ///< 0x30 [W]: Interrupt force register
  volatile uint32_t REV0;  ///< 0x34 [R]: SKEWDET Tagging Revision 0
  volatile uint32_t REV1;  ///< 0x38 [R]: SKEWDET Tagging Revision 1
} SKEWDET_REGS_t;

//====================================================================
//
//Register File: Skew Detect ODMA (SKEW_ODMA)
/** \brief Register Descriptions for the ODMA_AXI block (rev 0 . 4 . 3 . 1)*/
//
//====================================================================

typedef struct SKEW_ODMA_REGS_s
{
  volatile uint32_t cfg;  ///< 0x0 [R/W]: Configuration register
  volatile uint32_t status;  ///< 0x4 [R]: Status register
  volatile uint32_t line_size;  ///< 0x8 [R/W]: Line Size Register
  volatile uint32_t int_en;  ///< 0xc [R/W]: Interrupt Enable Register
  volatile uint32_t int_pend;  ///< 0x10 [R]: Interrupt Pending Register
  volatile uint32_t int_ack;  ///< 0x14 [W]: Interrupt Acknowledge Register
  volatile uint32_t int_fo;  ///< 0x18 [W]: Interrupt Force Register
  volatile uint32_t desc_write;  ///< 0x1c [W]: Descriptor Write Register
  volatile uint32_t desc_read;  ///< 0x20 [R]: Descriptor Read Register
  volatile uint32_t xfer_length;  ///< 0x24 [R]: Descriptor Transfer Length Register
  volatile uint32_t xfer_addr;  ///< 0x28 [R]: Descriptor Transfer Address Register
  volatile uint32_t xfer_burst;  ///< 0x2c [R]: Descriptor Transfer Burst Register
  volatile uint32_t reserved0;
  volatile uint32_t reset;  ///< 0x34 [W]: Soft Reset register
  volatile uint32_t REV0;  ///< 0x38 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0x3c [R]: IP Tagging Revision 1
} SKEW_ODMA_REGS_t;

//====================================================================
//
//Register File: AntiFlin (ANTIFLIN)
/** \brief Register descriptions for the ANTIFLIN block.
    (rev 0 . 0 . 5 . 1)*/
//
//====================================================================

typedef struct ANTIFLIN_REGS_s
{
  volatile uint32_t Control;  ///< 0x0 [R/W]: Control
  volatile uint32_t C1;  ///< 0x4 [R/W]: Channel 1
  volatile uint32_t C2;  ///< 0x8 [R/W]: Channel 2
  volatile uint32_t C3;  ///< 0xc [R/W]: Channel 3
  volatile uint32_t RAR;  ///< 0x10 [R/W]: RAM Access Control Register
  volatile uint32_t RAWR;  ///< 0x14 [W]: RAM Address Write Register
  volatile uint32_t RASR;  ///< 0x18 [R]: RAM Address Status Register
  volatile uint32_t RDWR;  ///< 0x1c [W]: RAM Data Write Register
  volatile uint32_t RDRR;  ///< 0x20 [R]: RAM Data Read Register
  volatile uint32_t debug_ch0;  ///< 0x24 [R]: ANTIFLIN channel 0 Debug Register
  volatile uint32_t debug_ch1;  ///< 0x28 [R]: ANTIFLIN channel 1 Debug Register
  volatile uint32_t debug_ch2;  ///< 0x2c [R]: ANTIFLIN channel 2 Debug Register
  volatile uint32_t REV0;  ///< 0x30 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0x34 [R]: IP Tagging Revision 1
} ANTIFLIN_REGS_t;

//====================================================================
//
//Register File: AntiFlin ODMA Channel (Instance 1 of 3) (ANTIFLIN_WDMA0)
/** \brief Register Descriptions for the ODMA_AXI block (rev 0 . 4 . 3 . 1)*/
//
//====================================================================

typedef struct ANTIFLIN_WDMA0_REGS_s
{
  volatile uint32_t cfg;  ///< 0x0 [R/W]: Configuration register
  volatile uint32_t status;  ///< 0x4 [R]: Status register
  volatile uint32_t line_size;  ///< 0x8 [R/W]: Line Size Register
  volatile uint32_t int_en;  ///< 0xc [R/W]: Interrupt Enable Register
  volatile uint32_t int_pend;  ///< 0x10 [R]: Interrupt Pending Register
  volatile uint32_t int_ack;  ///< 0x14 [W]: Interrupt Acknowledge Register
  volatile uint32_t int_fo;  ///< 0x18 [W]: Interrupt Force Register
  volatile uint32_t desc_write;  ///< 0x1c [W]: Descriptor Write Register
  volatile uint32_t desc_read;  ///< 0x20 [R]: Descriptor Read Register
  volatile uint32_t xfer_length;  ///< 0x24 [R]: Descriptor Transfer Length Register
  volatile uint32_t xfer_addr;  ///< 0x28 [R]: Descriptor Transfer Address Register
  volatile uint32_t xfer_burst;  ///< 0x2c [R]: Descriptor Transfer Burst Register
  volatile uint32_t reserved0;
  volatile uint32_t reset;  ///< 0x34 [W]: Soft Reset register
  volatile uint32_t REV0;  ///< 0x38 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0x3c [R]: IP Tagging Revision 1
} ANTIFLIN_WDMA0_REGS_t;

//====================================================================
//
//Register File: AntiFlin ODMA Channel (Instance 2 of 3) (ANTIFLIN_WDMA1)
/** \brief Register Descriptions for the ODMA_AXI block (rev 0 . 4 . 3 . 1)*/
//
//====================================================================

typedef struct ANTIFLIN_WDMA1_REGS_s
{
  volatile uint32_t cfg;  ///< 0x0 [R/W]: Configuration register
  volatile uint32_t status;  ///< 0x4 [R]: Status register
  volatile uint32_t line_size;  ///< 0x8 [R/W]: Line Size Register
  volatile uint32_t int_en;  ///< 0xc [R/W]: Interrupt Enable Register
  volatile uint32_t int_pend;  ///< 0x10 [R]: Interrupt Pending Register
  volatile uint32_t int_ack;  ///< 0x14 [W]: Interrupt Acknowledge Register
  volatile uint32_t int_fo;  ///< 0x18 [W]: Interrupt Force Register
  volatile uint32_t desc_write;  ///< 0x1c [W]: Descriptor Write Register
  volatile uint32_t desc_read;  ///< 0x20 [R]: Descriptor Read Register
  volatile uint32_t xfer_length;  ///< 0x24 [R]: Descriptor Transfer Length Register
  volatile uint32_t xfer_addr;  ///< 0x28 [R]: Descriptor Transfer Address Register
  volatile uint32_t xfer_burst;  ///< 0x2c [R]: Descriptor Transfer Burst Register
  volatile uint32_t reserved0;
  volatile uint32_t reset;  ///< 0x34 [W]: Soft Reset register
  volatile uint32_t REV0;  ///< 0x38 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0x3c [R]: IP Tagging Revision 1
} ANTIFLIN_WDMA1_REGS_t;

//====================================================================
//
//Register File: AntiFlin ODMA Channel (Instance 3 of 3) (ANTIFLIN_WDMA2)
/** \brief Register Descriptions for the ODMA_AXI block (rev 0 . 4 . 3 . 1)*/
//
//====================================================================

typedef struct ANTIFLIN_WDMA2_REGS_s
{
  volatile uint32_t cfg;  ///< 0x0 [R/W]: Configuration register
  volatile uint32_t status;  ///< 0x4 [R]: Status register
  volatile uint32_t line_size;  ///< 0x8 [R/W]: Line Size Register
  volatile uint32_t int_en;  ///< 0xc [R/W]: Interrupt Enable Register
  volatile uint32_t int_pend;  ///< 0x10 [R]: Interrupt Pending Register
  volatile uint32_t int_ack;  ///< 0x14 [W]: Interrupt Acknowledge Register
  volatile uint32_t int_fo;  ///< 0x18 [W]: Interrupt Force Register
  volatile uint32_t desc_write;  ///< 0x1c [W]: Descriptor Write Register
  volatile uint32_t desc_read;  ///< 0x20 [R]: Descriptor Read Register
  volatile uint32_t xfer_length;  ///< 0x24 [R]: Descriptor Transfer Length Register
  volatile uint32_t xfer_addr;  ///< 0x28 [R]: Descriptor Transfer Address Register
  volatile uint32_t xfer_burst;  ///< 0x2c [R]: Descriptor Transfer Burst Register
  volatile uint32_t reserved0;
  volatile uint32_t reset;  ///< 0x34 [W]: Soft Reset register
  volatile uint32_t REV0;  ///< 0x38 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0x3c [R]: IP Tagging Revision 1
} ANTIFLIN_WDMA2_REGS_t;

//====================================================================
//
//Register File: PIC Bit Depth Reduction (BitReduct)
/** \brief Register Descriptions for the PIC BitReduct block (rev 0 . 2 . 2 . 5)*/
//
//====================================================================

typedef struct BITREDUCT_REGS_s
{
  volatile uint32_t BDRLUT[1024];  ///< 0x0 [R/W]: BDR Look Up Table
  volatile uint32_t BDRLUTR;  ///< 0x1000 [R/W]: BDR Look Up Table Register
  volatile uint32_t BDRCR;  ///< 0x1004 [R/W]: BDR Configuration Register
  volatile uint32_t REV0;  ///< 0x1008 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0x100c [R]: IP Tagging Revision 1
} BITREDUCT_REGS_t;

//====================================================================
//
//Register File: DMA channel (Instance 1 of 3) (PIC_WDMA_DMA0)
/** \brief Register Descriptions for the ODMA_AXI block (rev 0 . 4 . 3 . 1)*/
//
//====================================================================

typedef struct PIC_WDMA_DMA0_REGS_s
{
  volatile uint32_t cfg;  ///< 0x0 [R/W]: Configuration register
  volatile uint32_t status;  ///< 0x4 [R]: Status register
  volatile uint32_t line_size;  ///< 0x8 [R/W]: Line Size Register
  volatile uint32_t int_en;  ///< 0xc [R/W]: Interrupt Enable Register
  volatile uint32_t int_pend;  ///< 0x10 [R]: Interrupt Pending Register
  volatile uint32_t int_ack;  ///< 0x14 [W]: Interrupt Acknowledge Register
  volatile uint32_t int_fo;  ///< 0x18 [W]: Interrupt Force Register
  volatile uint32_t desc_write;  ///< 0x1c [W]: Descriptor Write Register
  volatile uint32_t desc_read;  ///< 0x20 [R]: Descriptor Read Register
  volatile uint32_t xfer_length;  ///< 0x24 [R]: Descriptor Transfer Length Register
  volatile uint32_t xfer_addr;  ///< 0x28 [R]: Descriptor Transfer Address Register
  volatile uint32_t xfer_burst;  ///< 0x2c [R]: Descriptor Transfer Burst Register
  volatile uint32_t reserved0;
  volatile uint32_t reset;  ///< 0x34 [W]: Soft Reset register
  volatile uint32_t REV0;  ///< 0x38 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0x3c [R]: IP Tagging Revision 1
} PIC_WDMA_DMA0_REGS_t;

//====================================================================
//
//Register File: DMA channel (Instance 2 of 3) (PIC_WDMA_DMA1)
/** \brief Register Descriptions for the ODMA_AXI block (rev 0 . 4 . 3 . 1)*/
//
//====================================================================

typedef struct PIC_WDMA_DMA1_REGS_s
{
  volatile uint32_t cfg;  ///< 0x0 [R/W]: Configuration register
  volatile uint32_t status;  ///< 0x4 [R]: Status register
  volatile uint32_t line_size;  ///< 0x8 [R/W]: Line Size Register
  volatile uint32_t int_en;  ///< 0xc [R/W]: Interrupt Enable Register
  volatile uint32_t int_pend;  ///< 0x10 [R]: Interrupt Pending Register
  volatile uint32_t int_ack;  ///< 0x14 [W]: Interrupt Acknowledge Register
  volatile uint32_t int_fo;  ///< 0x18 [W]: Interrupt Force Register
  volatile uint32_t desc_write;  ///< 0x1c [W]: Descriptor Write Register
  volatile uint32_t desc_read;  ///< 0x20 [R]: Descriptor Read Register
  volatile uint32_t xfer_length;  ///< 0x24 [R]: Descriptor Transfer Length Register
  volatile uint32_t xfer_addr;  ///< 0x28 [R]: Descriptor Transfer Address Register
  volatile uint32_t xfer_burst;  ///< 0x2c [R]: Descriptor Transfer Burst Register
  volatile uint32_t reserved0;
  volatile uint32_t reset;  ///< 0x34 [W]: Soft Reset register
  volatile uint32_t REV0;  ///< 0x38 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0x3c [R]: IP Tagging Revision 1
} PIC_WDMA_DMA1_REGS_t;

//====================================================================
//
//Register File: DMA channel (Instance 3 of 3) (PIC_WDMA_DMA2)
/** \brief Register Descriptions for the ODMA_AXI block (rev 0 . 4 . 3 . 1)*/
//
//====================================================================

typedef struct PIC_WDMA_DMA2_REGS_s
{
  volatile uint32_t cfg;  ///< 0x0 [R/W]: Configuration register
  volatile uint32_t status;  ///< 0x4 [R]: Status register
  volatile uint32_t line_size;  ///< 0x8 [R/W]: Line Size Register
  volatile uint32_t int_en;  ///< 0xc [R/W]: Interrupt Enable Register
  volatile uint32_t int_pend;  ///< 0x10 [R]: Interrupt Pending Register
  volatile uint32_t int_ack;  ///< 0x14 [W]: Interrupt Acknowledge Register
  volatile uint32_t int_fo;  ///< 0x18 [W]: Interrupt Force Register
  volatile uint32_t desc_write;  ///< 0x1c [W]: Descriptor Write Register
  volatile uint32_t desc_read;  ///< 0x20 [R]: Descriptor Read Register
  volatile uint32_t xfer_length;  ///< 0x24 [R]: Descriptor Transfer Length Register
  volatile uint32_t xfer_addr;  ///< 0x28 [R]: Descriptor Transfer Address Register
  volatile uint32_t xfer_burst;  ///< 0x2c [R]: Descriptor Transfer Burst Register
  volatile uint32_t reserved0;
  volatile uint32_t reset;  ///< 0x34 [W]: Soft Reset register
  volatile uint32_t REV0;  ///< 0x38 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0x3c [R]: IP Tagging Revision 1
} PIC_WDMA_DMA2_REGS_t;

#endif // PIC
 /*
 **************************************************************************************
 *
 * (c) Copyright 2014 Marvell International Ltd.
 *
 *
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/.
 *
 **************************************************************************************
 *
 * \file PIC_regmasks.h
 * Generated using RegBuild 1.6.3
 *
 **************************************************************************************
 */

#ifndef _PIC_REGMASKS_H_
#define _PIC_REGMASKS_H_

#include "hwincl.h"

//====================================================================
//
//Register File: PIC (PIC)
/** \brief Register Descriptions for a PIC pipeline <br/> (rev 0 . 3 . 3 . 1)*/
//
//====================================================================

//====================================================================
//Register: PIC Control Register (PCR)
/** \brief PIC PIPE Control Register*/
//====================================================================

#define  PIC_PCR_RESERVED1_MASK 0xfffffe00
#define  PIC_PCR_RESERVED1_SHIFT 9
#define  PIC_PCR_RESERVED1_MASK_SHIFT(reg) (((reg) & PIC_PCR_RESERVED1_MASK) >> PIC_PCR_RESERVED1_SHIFT)
#define  PIC_PCR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PIC_PCR_RESERVED1_MASK) | (((uint32_t)val) << PIC_PCR_RESERVED1_SHIFT))

#define  PIC_PCR_DEBUGENB_MASK 0x100
#define  PIC_PCR_DEBUGENB_SHIFT 8
#define  PIC_PCR_DEBUGENB_MASK_SHIFT(reg) (((reg) & PIC_PCR_DEBUGENB_MASK) >> PIC_PCR_DEBUGENB_SHIFT)
#define  PIC_PCR_DEBUGENB_REPLACE_VAL(reg,val) (((reg) & ~PIC_PCR_DEBUGENB_MASK) | (((uint32_t)val) << PIC_PCR_DEBUGENB_SHIFT))

#define  PIC_PCR_RESERVED2_MASK 0xfe
#define  PIC_PCR_RESERVED2_SHIFT 1
#define  PIC_PCR_RESERVED2_MASK_SHIFT(reg) (((reg) & PIC_PCR_RESERVED2_MASK) >> PIC_PCR_RESERVED2_SHIFT)
#define  PIC_PCR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~PIC_PCR_RESERVED2_MASK) | (((uint32_t)val) << PIC_PCR_RESERVED2_SHIFT))

#define  PIC_PCR_SOFTRESET_MASK 0x1
#define  PIC_PCR_SOFTRESET_SHIFT 0
#define  PIC_PCR_SOFTRESET_MASK_SHIFT(reg) (((reg) & PIC_PCR_SOFTRESET_MASK) >> PIC_PCR_SOFTRESET_SHIFT)
#define  PIC_PCR_SOFTRESET_REPLACE_VAL(reg,val) (((reg) & ~PIC_PCR_SOFTRESET_MASK) | (((uint32_t)val) << PIC_PCR_SOFTRESET_SHIFT))

//====================================================================
//Register: Interrupt Enable Register (IENR)
/** \brief Interrupt Enable Register (IENR)*/
//====================================================================

#define  PIC_IENR_RESERVED1_MASK 0xfffc0000
#define  PIC_IENR_RESERVED1_SHIFT 18
#define  PIC_IENR_RESERVED1_MASK_SHIFT(reg) (((reg) & PIC_IENR_RESERVED1_MASK) >> PIC_IENR_RESERVED1_SHIFT)
#define  PIC_IENR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PIC_IENR_RESERVED1_MASK) | (((uint32_t)val) << PIC_IENR_RESERVED1_SHIFT))

#define  PIC_IENR_SKEW_MASK 0x20000
#define  PIC_IENR_SKEW_SHIFT 17
#define  PIC_IENR_SKEW_MASK_SHIFT(reg) (((reg) & PIC_IENR_SKEW_MASK) >> PIC_IENR_SKEW_SHIFT)
#define  PIC_IENR_SKEW_REPLACE_VAL(reg,val) (((reg) & ~PIC_IENR_SKEW_MASK) | (((uint32_t)val) << PIC_IENR_SKEW_SHIFT))

#define  PIC_IENR_SKEW_ODMA_MASK 0x10000
#define  PIC_IENR_SKEW_ODMA_SHIFT 16
#define  PIC_IENR_SKEW_ODMA_MASK_SHIFT(reg) (((reg) & PIC_IENR_SKEW_ODMA_MASK) >> PIC_IENR_SKEW_ODMA_SHIFT)
#define  PIC_IENR_SKEW_ODMA_REPLACE_VAL(reg,val) (((reg) & ~PIC_IENR_SKEW_ODMA_MASK) | (((uint32_t)val) << PIC_IENR_SKEW_ODMA_SHIFT))

#define  PIC_IENR_AF_DMA_COMMON_MASK 0x8000
#define  PIC_IENR_AF_DMA_COMMON_SHIFT 15
#define  PIC_IENR_AF_DMA_COMMON_MASK_SHIFT(reg) (((reg) & PIC_IENR_AF_DMA_COMMON_MASK) >> PIC_IENR_AF_DMA_COMMON_SHIFT)
#define  PIC_IENR_AF_DMA_COMMON_REPLACE_VAL(reg,val) (((reg) & ~PIC_IENR_AF_DMA_COMMON_MASK) | (((uint32_t)val) << PIC_IENR_AF_DMA_COMMON_SHIFT))

#define  PIC_IENR_AF_DMA2_MASK 0x4000
#define  PIC_IENR_AF_DMA2_SHIFT 14
#define  PIC_IENR_AF_DMA2_MASK_SHIFT(reg) (((reg) & PIC_IENR_AF_DMA2_MASK) >> PIC_IENR_AF_DMA2_SHIFT)
#define  PIC_IENR_AF_DMA2_REPLACE_VAL(reg,val) (((reg) & ~PIC_IENR_AF_DMA2_MASK) | (((uint32_t)val) << PIC_IENR_AF_DMA2_SHIFT))

#define  PIC_IENR_AF_DMA1_MASK 0x2000
#define  PIC_IENR_AF_DMA1_SHIFT 13
#define  PIC_IENR_AF_DMA1_MASK_SHIFT(reg) (((reg) & PIC_IENR_AF_DMA1_MASK) >> PIC_IENR_AF_DMA1_SHIFT)
#define  PIC_IENR_AF_DMA1_REPLACE_VAL(reg,val) (((reg) & ~PIC_IENR_AF_DMA1_MASK) | (((uint32_t)val) << PIC_IENR_AF_DMA1_SHIFT))

#define  PIC_IENR_AF_DMA0_MASK 0x1000
#define  PIC_IENR_AF_DMA0_SHIFT 12
#define  PIC_IENR_AF_DMA0_MASK_SHIFT(reg) (((reg) & PIC_IENR_AF_DMA0_MASK) >> PIC_IENR_AF_DMA0_SHIFT)
#define  PIC_IENR_AF_DMA0_REPLACE_VAL(reg,val) (((reg) & ~PIC_IENR_AF_DMA0_MASK) | (((uint32_t)val) << PIC_IENR_AF_DMA0_SHIFT))

#define  PIC_IENR_WDMA_COMMON_MASK 0x800
#define  PIC_IENR_WDMA_COMMON_SHIFT 11
#define  PIC_IENR_WDMA_COMMON_MASK_SHIFT(reg) (((reg) & PIC_IENR_WDMA_COMMON_MASK) >> PIC_IENR_WDMA_COMMON_SHIFT)
#define  PIC_IENR_WDMA_COMMON_REPLACE_VAL(reg,val) (((reg) & ~PIC_IENR_WDMA_COMMON_MASK) | (((uint32_t)val) << PIC_IENR_WDMA_COMMON_SHIFT))

#define  PIC_IENR_WDMA2_MASK 0x400
#define  PIC_IENR_WDMA2_SHIFT 10
#define  PIC_IENR_WDMA2_MASK_SHIFT(reg) (((reg) & PIC_IENR_WDMA2_MASK) >> PIC_IENR_WDMA2_SHIFT)
#define  PIC_IENR_WDMA2_REPLACE_VAL(reg,val) (((reg) & ~PIC_IENR_WDMA2_MASK) | (((uint32_t)val) << PIC_IENR_WDMA2_SHIFT))

#define  PIC_IENR_WDMA1_MASK 0x200
#define  PIC_IENR_WDMA1_SHIFT 9
#define  PIC_IENR_WDMA1_MASK_SHIFT(reg) (((reg) & PIC_IENR_WDMA1_MASK) >> PIC_IENR_WDMA1_SHIFT)
#define  PIC_IENR_WDMA1_REPLACE_VAL(reg,val) (((reg) & ~PIC_IENR_WDMA1_MASK) | (((uint32_t)val) << PIC_IENR_WDMA1_SHIFT))

#define  PIC_IENR_WDMA0_MASK 0x100
#define  PIC_IENR_WDMA0_SHIFT 8
#define  PIC_IENR_WDMA0_MASK_SHIFT(reg) (((reg) & PIC_IENR_WDMA0_MASK) >> PIC_IENR_WDMA0_SHIFT)
#define  PIC_IENR_WDMA0_REPLACE_VAL(reg,val) (((reg) & ~PIC_IENR_WDMA0_MASK) | (((uint32_t)val) << PIC_IENR_WDMA0_SHIFT))

#define  PIC_IENR_RESERVED2_MASK 0xe0
#define  PIC_IENR_RESERVED2_SHIFT 5
#define  PIC_IENR_RESERVED2_MASK_SHIFT(reg) (((reg) & PIC_IENR_RESERVED2_MASK) >> PIC_IENR_RESERVED2_SHIFT)
#define  PIC_IENR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~PIC_IENR_RESERVED2_MASK) | (((uint32_t)val) << PIC_IENR_RESERVED2_SHIFT))

#define  PIC_IENR_PS_ESD_MASK 0x10
#define  PIC_IENR_PS_ESD_SHIFT 4
#define  PIC_IENR_PS_ESD_MASK_SHIFT(reg) (((reg) & PIC_IENR_PS_ESD_MASK) >> PIC_IENR_PS_ESD_SHIFT)
#define  PIC_IENR_PS_ESD_REPLACE_VAL(reg,val) (((reg) & ~PIC_IENR_PS_ESD_MASK) | (((uint32_t)val) << PIC_IENR_PS_ESD_SHIFT))

#define  PIC_IENR_RESERVED3_MASK 0xe
#define  PIC_IENR_RESERVED3_SHIFT 1
#define  PIC_IENR_RESERVED3_MASK_SHIFT(reg) (((reg) & PIC_IENR_RESERVED3_MASK) >> PIC_IENR_RESERVED3_SHIFT)
#define  PIC_IENR_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~PIC_IENR_RESERVED3_MASK) | (((uint32_t)val) << PIC_IENR_RESERVED3_SHIFT))

#define  PIC_IENR_IDMA_2D_MASK 0x1
#define  PIC_IENR_IDMA_2D_SHIFT 0
#define  PIC_IENR_IDMA_2D_MASK_SHIFT(reg) (((reg) & PIC_IENR_IDMA_2D_MASK) >> PIC_IENR_IDMA_2D_SHIFT)
#define  PIC_IENR_IDMA_2D_REPLACE_VAL(reg,val) (((reg) & ~PIC_IENR_IDMA_2D_MASK) | (((uint32_t)val) << PIC_IENR_IDMA_2D_SHIFT))

//====================================================================
//Register: Interrupt Pending Register (IPR) (IPR)
/** \brief Interrupt Pending Register (IPR) NOTE: This is a read-only observation register for the
IRQ signals from the respective PIC blocks. Writing to this register has no effect.*/
//====================================================================

#define  PIC_IPR_RESERVED1_MASK 0xfffc0000
#define  PIC_IPR_RESERVED1_SHIFT 18
#define  PIC_IPR_RESERVED1_MASK_SHIFT(reg) (((reg) & PIC_IPR_RESERVED1_MASK) >> PIC_IPR_RESERVED1_SHIFT)
#define  PIC_IPR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PIC_IPR_RESERVED1_MASK) | (((uint32_t)val) << PIC_IPR_RESERVED1_SHIFT))

#define  PIC_IPR_SKEW_MASK 0x20000
#define  PIC_IPR_SKEW_SHIFT 17
#define  PIC_IPR_SKEW_MASK_SHIFT(reg) (((reg) & PIC_IPR_SKEW_MASK) >> PIC_IPR_SKEW_SHIFT)
#define  PIC_IPR_SKEW_REPLACE_VAL(reg,val) (((reg) & ~PIC_IPR_SKEW_MASK) | (((uint32_t)val) << PIC_IPR_SKEW_SHIFT))

#define  PIC_IPR_SKEW_ODMA_MASK 0x10000
#define  PIC_IPR_SKEW_ODMA_SHIFT 16
#define  PIC_IPR_SKEW_ODMA_MASK_SHIFT(reg) (((reg) & PIC_IPR_SKEW_ODMA_MASK) >> PIC_IPR_SKEW_ODMA_SHIFT)
#define  PIC_IPR_SKEW_ODMA_REPLACE_VAL(reg,val) (((reg) & ~PIC_IPR_SKEW_ODMA_MASK) | (((uint32_t)val) << PIC_IPR_SKEW_ODMA_SHIFT))

#define  PIC_IPR_AF_WDMA_COMMON_MASK 0x8000
#define  PIC_IPR_AF_WDMA_COMMON_SHIFT 15
#define  PIC_IPR_AF_WDMA_COMMON_MASK_SHIFT(reg) (((reg) & PIC_IPR_AF_WDMA_COMMON_MASK) >> PIC_IPR_AF_WDMA_COMMON_SHIFT)
#define  PIC_IPR_AF_WDMA_COMMON_REPLACE_VAL(reg,val) (((reg) & ~PIC_IPR_AF_WDMA_COMMON_MASK) | (((uint32_t)val) << PIC_IPR_AF_WDMA_COMMON_SHIFT))

#define  PIC_IPR_AF_DMA2_MASK 0x4000
#define  PIC_IPR_AF_DMA2_SHIFT 14
#define  PIC_IPR_AF_DMA2_MASK_SHIFT(reg) (((reg) & PIC_IPR_AF_DMA2_MASK) >> PIC_IPR_AF_DMA2_SHIFT)
#define  PIC_IPR_AF_DMA2_REPLACE_VAL(reg,val) (((reg) & ~PIC_IPR_AF_DMA2_MASK) | (((uint32_t)val) << PIC_IPR_AF_DMA2_SHIFT))

#define  PIC_IPR_AF_DMA1_MASK 0x2000
#define  PIC_IPR_AF_DMA1_SHIFT 13
#define  PIC_IPR_AF_DMA1_MASK_SHIFT(reg) (((reg) & PIC_IPR_AF_DMA1_MASK) >> PIC_IPR_AF_DMA1_SHIFT)
#define  PIC_IPR_AF_DMA1_REPLACE_VAL(reg,val) (((reg) & ~PIC_IPR_AF_DMA1_MASK) | (((uint32_t)val) << PIC_IPR_AF_DMA1_SHIFT))

#define  PIC_IPR_AF_DMA0_MASK 0x1000
#define  PIC_IPR_AF_DMA0_SHIFT 12
#define  PIC_IPR_AF_DMA0_MASK_SHIFT(reg) (((reg) & PIC_IPR_AF_DMA0_MASK) >> PIC_IPR_AF_DMA0_SHIFT)
#define  PIC_IPR_AF_DMA0_REPLACE_VAL(reg,val) (((reg) & ~PIC_IPR_AF_DMA0_MASK) | (((uint32_t)val) << PIC_IPR_AF_DMA0_SHIFT))

#define  PIC_IPR_WDMA_COMMON_MASK 0x800
#define  PIC_IPR_WDMA_COMMON_SHIFT 11
#define  PIC_IPR_WDMA_COMMON_MASK_SHIFT(reg) (((reg) & PIC_IPR_WDMA_COMMON_MASK) >> PIC_IPR_WDMA_COMMON_SHIFT)
#define  PIC_IPR_WDMA_COMMON_REPLACE_VAL(reg,val) (((reg) & ~PIC_IPR_WDMA_COMMON_MASK) | (((uint32_t)val) << PIC_IPR_WDMA_COMMON_SHIFT))

#define  PIC_IPR_WDMA2_MASK 0x400
#define  PIC_IPR_WDMA2_SHIFT 10
#define  PIC_IPR_WDMA2_MASK_SHIFT(reg) (((reg) & PIC_IPR_WDMA2_MASK) >> PIC_IPR_WDMA2_SHIFT)
#define  PIC_IPR_WDMA2_REPLACE_VAL(reg,val) (((reg) & ~PIC_IPR_WDMA2_MASK) | (((uint32_t)val) << PIC_IPR_WDMA2_SHIFT))

#define  PIC_IPR_WDMA1_MASK 0x200
#define  PIC_IPR_WDMA1_SHIFT 9
#define  PIC_IPR_WDMA1_MASK_SHIFT(reg) (((reg) & PIC_IPR_WDMA1_MASK) >> PIC_IPR_WDMA1_SHIFT)
#define  PIC_IPR_WDMA1_REPLACE_VAL(reg,val) (((reg) & ~PIC_IPR_WDMA1_MASK) | (((uint32_t)val) << PIC_IPR_WDMA1_SHIFT))

#define  PIC_IPR_WDMA0_MASK 0x100
#define  PIC_IPR_WDMA0_SHIFT 8
#define  PIC_IPR_WDMA0_MASK_SHIFT(reg) (((reg) & PIC_IPR_WDMA0_MASK) >> PIC_IPR_WDMA0_SHIFT)
#define  PIC_IPR_WDMA0_REPLACE_VAL(reg,val) (((reg) & ~PIC_IPR_WDMA0_MASK) | (((uint32_t)val) << PIC_IPR_WDMA0_SHIFT))

#define  PIC_IPR_RESERVED2_MASK 0xe0
#define  PIC_IPR_RESERVED2_SHIFT 5
#define  PIC_IPR_RESERVED2_MASK_SHIFT(reg) (((reg) & PIC_IPR_RESERVED2_MASK) >> PIC_IPR_RESERVED2_SHIFT)
#define  PIC_IPR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~PIC_IPR_RESERVED2_MASK) | (((uint32_t)val) << PIC_IPR_RESERVED2_SHIFT))

#define  PIC_IPR_PS_ESD_MASK 0x10
#define  PIC_IPR_PS_ESD_SHIFT 4
#define  PIC_IPR_PS_ESD_MASK_SHIFT(reg) (((reg) & PIC_IPR_PS_ESD_MASK) >> PIC_IPR_PS_ESD_SHIFT)
#define  PIC_IPR_PS_ESD_REPLACE_VAL(reg,val) (((reg) & ~PIC_IPR_PS_ESD_MASK) | (((uint32_t)val) << PIC_IPR_PS_ESD_SHIFT))

#define  PIC_IPR_RESERVED3_MASK 0xe
#define  PIC_IPR_RESERVED3_SHIFT 1
#define  PIC_IPR_RESERVED3_MASK_SHIFT(reg) (((reg) & PIC_IPR_RESERVED3_MASK) >> PIC_IPR_RESERVED3_SHIFT)
#define  PIC_IPR_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~PIC_IPR_RESERVED3_MASK) | (((uint32_t)val) << PIC_IPR_RESERVED3_SHIFT))

#define  PIC_IPR_IDMA_2D_MASK 0x1
#define  PIC_IPR_IDMA_2D_SHIFT 0
#define  PIC_IPR_IDMA_2D_MASK_SHIFT(reg) (((reg) & PIC_IPR_IDMA_2D_MASK) >> PIC_IPR_IDMA_2D_SHIFT)
#define  PIC_IPR_IDMA_2D_REPLACE_VAL(reg,val) (((reg) & ~PIC_IPR_IDMA_2D_MASK) | (((uint32_t)val) << PIC_IPR_IDMA_2D_SHIFT))

//====================================================================
//Register: Interrupt Force Register (IFR)
/** \brief Interrupt Force Register (IFR) NOTE: Setting a force bit here, if the corresponding interrupt is
enabled, will cause a continuous PIC interrupt until either the force bit is cleared or the
interrupt is disabled. Note that setting a bit in IFR will not cause the respective IPR pending bit
to go to '1'. The IPR and IFR registers are independent - the IFR bits are OR'd with IPR to generate 
the interrupt.*/
//====================================================================

#define  PIC_IFR_RESERVED1_MASK 0xfffc0000
#define  PIC_IFR_RESERVED1_SHIFT 18
#define  PIC_IFR_RESERVED1_MASK_SHIFT(reg) (((reg) & PIC_IFR_RESERVED1_MASK) >> PIC_IFR_RESERVED1_SHIFT)
#define  PIC_IFR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PIC_IFR_RESERVED1_MASK) | (((uint32_t)val) << PIC_IFR_RESERVED1_SHIFT))

#define  PIC_IFR_SKEW_MASK 0x20000
#define  PIC_IFR_SKEW_SHIFT 17
#define  PIC_IFR_SKEW_MASK_SHIFT(reg) (((reg) & PIC_IFR_SKEW_MASK) >> PIC_IFR_SKEW_SHIFT)
#define  PIC_IFR_SKEW_REPLACE_VAL(reg,val) (((reg) & ~PIC_IFR_SKEW_MASK) | (((uint32_t)val) << PIC_IFR_SKEW_SHIFT))

#define  PIC_IFR_SKEW_ODMA_MASK 0x10000
#define  PIC_IFR_SKEW_ODMA_SHIFT 16
#define  PIC_IFR_SKEW_ODMA_MASK_SHIFT(reg) (((reg) & PIC_IFR_SKEW_ODMA_MASK) >> PIC_IFR_SKEW_ODMA_SHIFT)
#define  PIC_IFR_SKEW_ODMA_REPLACE_VAL(reg,val) (((reg) & ~PIC_IFR_SKEW_ODMA_MASK) | (((uint32_t)val) << PIC_IFR_SKEW_ODMA_SHIFT))

#define  PIC_IFR_AF_WDMA_COMMON_MASK 0x8000
#define  PIC_IFR_AF_WDMA_COMMON_SHIFT 15
#define  PIC_IFR_AF_WDMA_COMMON_MASK_SHIFT(reg) (((reg) & PIC_IFR_AF_WDMA_COMMON_MASK) >> PIC_IFR_AF_WDMA_COMMON_SHIFT)
#define  PIC_IFR_AF_WDMA_COMMON_REPLACE_VAL(reg,val) (((reg) & ~PIC_IFR_AF_WDMA_COMMON_MASK) | (((uint32_t)val) << PIC_IFR_AF_WDMA_COMMON_SHIFT))

#define  PIC_IFR_AF_WDMA2_MASK 0x4000
#define  PIC_IFR_AF_WDMA2_SHIFT 14
#define  PIC_IFR_AF_WDMA2_MASK_SHIFT(reg) (((reg) & PIC_IFR_AF_WDMA2_MASK) >> PIC_IFR_AF_WDMA2_SHIFT)
#define  PIC_IFR_AF_WDMA2_REPLACE_VAL(reg,val) (((reg) & ~PIC_IFR_AF_WDMA2_MASK) | (((uint32_t)val) << PIC_IFR_AF_WDMA2_SHIFT))

#define  PIC_IFR_AF_WDMA1_MASK 0x2000
#define  PIC_IFR_AF_WDMA1_SHIFT 13
#define  PIC_IFR_AF_WDMA1_MASK_SHIFT(reg) (((reg) & PIC_IFR_AF_WDMA1_MASK) >> PIC_IFR_AF_WDMA1_SHIFT)
#define  PIC_IFR_AF_WDMA1_REPLACE_VAL(reg,val) (((reg) & ~PIC_IFR_AF_WDMA1_MASK) | (((uint32_t)val) << PIC_IFR_AF_WDMA1_SHIFT))

#define  PIC_IFR_AF_WDMA0_MASK 0x1000
#define  PIC_IFR_AF_WDMA0_SHIFT 12
#define  PIC_IFR_AF_WDMA0_MASK_SHIFT(reg) (((reg) & PIC_IFR_AF_WDMA0_MASK) >> PIC_IFR_AF_WDMA0_SHIFT)
#define  PIC_IFR_AF_WDMA0_REPLACE_VAL(reg,val) (((reg) & ~PIC_IFR_AF_WDMA0_MASK) | (((uint32_t)val) << PIC_IFR_AF_WDMA0_SHIFT))

#define  PIC_IFR_WDMA_COMMON_MASK 0x800
#define  PIC_IFR_WDMA_COMMON_SHIFT 11
#define  PIC_IFR_WDMA_COMMON_MASK_SHIFT(reg) (((reg) & PIC_IFR_WDMA_COMMON_MASK) >> PIC_IFR_WDMA_COMMON_SHIFT)
#define  PIC_IFR_WDMA_COMMON_REPLACE_VAL(reg,val) (((reg) & ~PIC_IFR_WDMA_COMMON_MASK) | (((uint32_t)val) << PIC_IFR_WDMA_COMMON_SHIFT))

#define  PIC_IFR_WDMA2_MASK 0x400
#define  PIC_IFR_WDMA2_SHIFT 10
#define  PIC_IFR_WDMA2_MASK_SHIFT(reg) (((reg) & PIC_IFR_WDMA2_MASK) >> PIC_IFR_WDMA2_SHIFT)
#define  PIC_IFR_WDMA2_REPLACE_VAL(reg,val) (((reg) & ~PIC_IFR_WDMA2_MASK) | (((uint32_t)val) << PIC_IFR_WDMA2_SHIFT))

#define  PIC_IFR_WDMA1_MASK 0x200
#define  PIC_IFR_WDMA1_SHIFT 9
#define  PIC_IFR_WDMA1_MASK_SHIFT(reg) (((reg) & PIC_IFR_WDMA1_MASK) >> PIC_IFR_WDMA1_SHIFT)
#define  PIC_IFR_WDMA1_REPLACE_VAL(reg,val) (((reg) & ~PIC_IFR_WDMA1_MASK) | (((uint32_t)val) << PIC_IFR_WDMA1_SHIFT))

#define  PIC_IFR_WDMA0_MASK 0x100
#define  PIC_IFR_WDMA0_SHIFT 8
#define  PIC_IFR_WDMA0_MASK_SHIFT(reg) (((reg) & PIC_IFR_WDMA0_MASK) >> PIC_IFR_WDMA0_SHIFT)
#define  PIC_IFR_WDMA0_REPLACE_VAL(reg,val) (((reg) & ~PIC_IFR_WDMA0_MASK) | (((uint32_t)val) << PIC_IFR_WDMA0_SHIFT))

#define  PIC_IFR_RESERVED2_MASK 0xe0
#define  PIC_IFR_RESERVED2_SHIFT 5
#define  PIC_IFR_RESERVED2_MASK_SHIFT(reg) (((reg) & PIC_IFR_RESERVED2_MASK) >> PIC_IFR_RESERVED2_SHIFT)
#define  PIC_IFR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~PIC_IFR_RESERVED2_MASK) | (((uint32_t)val) << PIC_IFR_RESERVED2_SHIFT))

#define  PIC_IFR_PS_ESD_MASK 0x10
#define  PIC_IFR_PS_ESD_SHIFT 4
#define  PIC_IFR_PS_ESD_MASK_SHIFT(reg) (((reg) & PIC_IFR_PS_ESD_MASK) >> PIC_IFR_PS_ESD_SHIFT)
#define  PIC_IFR_PS_ESD_REPLACE_VAL(reg,val) (((reg) & ~PIC_IFR_PS_ESD_MASK) | (((uint32_t)val) << PIC_IFR_PS_ESD_SHIFT))

#define  PIC_IFR_RESERVED3_MASK 0xe
#define  PIC_IFR_RESERVED3_SHIFT 1
#define  PIC_IFR_RESERVED3_MASK_SHIFT(reg) (((reg) & PIC_IFR_RESERVED3_MASK) >> PIC_IFR_RESERVED3_SHIFT)
#define  PIC_IFR_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~PIC_IFR_RESERVED3_MASK) | (((uint32_t)val) << PIC_IFR_RESERVED3_SHIFT))

#define  PIC_IFR_IDMA_2D_MASK 0x1
#define  PIC_IFR_IDMA_2D_SHIFT 0
#define  PIC_IFR_IDMA_2D_MASK_SHIFT(reg) (((reg) & PIC_IFR_IDMA_2D_MASK) >> PIC_IFR_IDMA_2D_SHIFT)
#define  PIC_IFR_IDMA_2D_REPLACE_VAL(reg,val) (((reg) & ~PIC_IFR_IDMA_2D_MASK) | (((uint32_t)val) << PIC_IFR_IDMA_2D_SHIFT))

//====================================================================
//Register: Debug Data Observation (Debug)
/** \brief Observe certain internal control signals*/
//====================================================================

#define  PIC_DEBUG_DATA_MASK 0xffffffff
#define  PIC_DEBUG_DATA_SHIFT 0
#define  PIC_DEBUG_DATA_MASK_SHIFT(reg) (((reg) & PIC_DEBUG_DATA_MASK) >> PIC_DEBUG_DATA_SHIFT)
#define  PIC_DEBUG_DATA_REPLACE_VAL(reg,val) (((reg) & ~PIC_DEBUG_DATA_MASK) | (((uint32_t)val) << PIC_DEBUG_DATA_SHIFT))

//====================================================================
//Register: IP Tagging Revision 0 (REV0)
/** \brief Provide means for firmware to read IP tagging information.
      This register of particular interest to firmware.*/
//====================================================================

#define  PIC_REV0_MAJ_MASK 0xffff0000
#define  PIC_REV0_MAJ_SHIFT 16
#define  PIC_REV0_MAJ_MASK_SHIFT(reg) (((reg) & PIC_REV0_MAJ_MASK) >> PIC_REV0_MAJ_SHIFT)
#define  PIC_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~PIC_REV0_MAJ_MASK) | (((uint32_t)val) << PIC_REV0_MAJ_SHIFT))

#define  PIC_REV0_MID_MASK 0xffff
#define  PIC_REV0_MID_SHIFT 0
#define  PIC_REV0_MID_MASK_SHIFT(reg) (((reg) & PIC_REV0_MID_MASK) >> PIC_REV0_MID_SHIFT)
#define  PIC_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~PIC_REV0_MID_MASK) | (((uint32_t)val) << PIC_REV0_MID_SHIFT))

//====================================================================
//Register: IP Tagging Revision 1 (REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  PIC_REV1_RESERVED1_MASK 0xffff0000
#define  PIC_REV1_RESERVED1_SHIFT 16
#define  PIC_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & PIC_REV1_RESERVED1_MASK) >> PIC_REV1_RESERVED1_SHIFT)
#define  PIC_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PIC_REV1_RESERVED1_MASK) | (((uint32_t)val) << PIC_REV1_RESERVED1_SHIFT))

#define  PIC_REV1_CFG_MASK 0xffff
#define  PIC_REV1_CFG_SHIFT 0
#define  PIC_REV1_CFG_MASK_SHIFT(reg) (((reg) & PIC_REV1_CFG_MASK) >> PIC_REV1_CFG_SHIFT)
#define  PIC_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~PIC_REV1_CFG_MASK) | (((uint32_t)val) << PIC_REV1_CFG_SHIFT))

//====================================================================
//
//Register File: PIC ADC Normalization (ADCNorm)
/** \brief Register Descriptions for the PIC ADCNorm block (rev 0 . 2 . 2 . 9)*/
//
//====================================================================

//====================================================================
//Register: ADC Normalization Register (ANR)
/** \brief The ANR Register controls the normalization functions as defined below. Note that the normalization logic is bypassed in Bypass Mode and when the ExposureIn CBI signal is valid.*/
//====================================================================

#define  ADCNORM_ANR_RESERVED1_MASK 0xfffffe00
#define  ADCNORM_ANR_RESERVED1_SHIFT 9
#define  ADCNORM_ANR_RESERVED1_MASK_SHIFT(reg) (((reg) & ADCNORM_ANR_RESERVED1_MASK) >> ADCNORM_ANR_RESERVED1_SHIFT)
#define  ADCNORM_ANR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ADCNORM_ANR_RESERVED1_MASK) | (((uint32_t)val) << ADCNORM_ANR_RESERVED1_SHIFT))

#define  ADCNORM_ANR_BYPASS_MASK 0x100
#define  ADCNORM_ANR_BYPASS_SHIFT 8
#define  ADCNORM_ANR_BYPASS_MASK_SHIFT(reg) (((reg) & ADCNORM_ANR_BYPASS_MASK) >> ADCNORM_ANR_BYPASS_SHIFT)
#define  ADCNORM_ANR_BYPASS_REPLACE_VAL(reg,val) (((reg) & ~ADCNORM_ANR_BYPASS_MASK) | (((uint32_t)val) << ADCNORM_ANR_BYPASS_SHIFT))

#define  ADCNORM_ANR_INVERT_MASK 0x80
#define  ADCNORM_ANR_INVERT_SHIFT 7
#define  ADCNORM_ANR_INVERT_MASK_SHIFT(reg) (((reg) & ADCNORM_ANR_INVERT_MASK) >> ADCNORM_ANR_INVERT_SHIFT)
#define  ADCNORM_ANR_INVERT_REPLACE_VAL(reg,val) (((reg) & ~ADCNORM_ANR_INVERT_MASK) | (((uint32_t)val) << ADCNORM_ANR_INVERT_SHIFT))

#define  ADCNORM_ANR_JUSTIFY_MASK 0x40
#define  ADCNORM_ANR_JUSTIFY_SHIFT 6
#define  ADCNORM_ANR_JUSTIFY_MASK_SHIFT(reg) (((reg) & ADCNORM_ANR_JUSTIFY_MASK) >> ADCNORM_ANR_JUSTIFY_SHIFT)
#define  ADCNORM_ANR_JUSTIFY_REPLACE_VAL(reg,val) (((reg) & ~ADCNORM_ANR_JUSTIFY_MASK) | (((uint32_t)val) << ADCNORM_ANR_JUSTIFY_SHIFT))

#define  ADCNORM_ANR_PADFILL_MASK 0x30
#define  ADCNORM_ANR_PADFILL_SHIFT 4
#define  ADCNORM_ANR_PADFILL_MASK_SHIFT(reg) (((reg) & ADCNORM_ANR_PADFILL_MASK) >> ADCNORM_ANR_PADFILL_SHIFT)
#define  ADCNORM_ANR_PADFILL_REPLACE_VAL(reg,val) (((reg) & ~ADCNORM_ANR_PADFILL_MASK) | (((uint32_t)val) << ADCNORM_ANR_PADFILL_SHIFT))

#define  ADCNORM_ANR_ADCBITS_MASK 0xf
#define  ADCNORM_ANR_ADCBITS_SHIFT 0
#define  ADCNORM_ANR_ADCBITS_MASK_SHIFT(reg) (((reg) & ADCNORM_ANR_ADCBITS_MASK) >> ADCNORM_ANR_ADCBITS_SHIFT)
#define  ADCNORM_ANR_ADCBITS_REPLACE_VAL(reg,val) (((reg) & ~ADCNORM_ANR_ADCBITS_MASK) | (((uint32_t)val) << ADCNORM_ANR_ADCBITS_SHIFT))

//====================================================================
//Register: IP Tagging Revision 0 (REV0)
/** \brief Provide means for firmware to read IP tagging information.
                    This register of particular interest to firmware.*/
//====================================================================

#define  ADCNORM_REV0_MAJ_MASK 0xffff0000
#define  ADCNORM_REV0_MAJ_SHIFT 16
#define  ADCNORM_REV0_MAJ_MASK_SHIFT(reg) (((reg) & ADCNORM_REV0_MAJ_MASK) >> ADCNORM_REV0_MAJ_SHIFT)
#define  ADCNORM_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~ADCNORM_REV0_MAJ_MASK) | (((uint32_t)val) << ADCNORM_REV0_MAJ_SHIFT))

#define  ADCNORM_REV0_MID_MASK 0xffff
#define  ADCNORM_REV0_MID_SHIFT 0
#define  ADCNORM_REV0_MID_MASK_SHIFT(reg) (((reg) & ADCNORM_REV0_MID_MASK) >> ADCNORM_REV0_MID_SHIFT)
#define  ADCNORM_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~ADCNORM_REV0_MID_MASK) | (((uint32_t)val) << ADCNORM_REV0_MID_SHIFT))

//====================================================================
//Register: IP Tagging Revision 1 (REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  ADCNORM_REV1_RESERVED1_MASK 0xffff0000
#define  ADCNORM_REV1_RESERVED1_SHIFT 16
#define  ADCNORM_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & ADCNORM_REV1_RESERVED1_MASK) >> ADCNORM_REV1_RESERVED1_SHIFT)
#define  ADCNORM_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ADCNORM_REV1_RESERVED1_MASK) | (((uint32_t)val) << ADCNORM_REV1_RESERVED1_SHIFT))

#define  ADCNORM_REV1_CFG_MASK 0xffff
#define  ADCNORM_REV1_CFG_SHIFT 0
#define  ADCNORM_REV1_CFG_MASK_SHIFT(reg) (((reg) & ADCNORM_REV1_CFG_MASK) >> ADCNORM_REV1_CFG_SHIFT)
#define  ADCNORM_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~ADCNORM_REV1_CFG_MASK) | (((uint32_t)val) << ADCNORM_REV1_CFG_SHIFT))

//====================================================================
//
//Register File: PIC Bulb Monitor (BulbMon)
/** \brief Register Descriptions for the PIC BulbMon block (rev 0 . 0 . 3 . 7)*/
//
//====================================================================

//====================================================================
//Register: Bulb Monitor Configuration Register (BMCR)
/** \brief General configuration register for BulbMon block.*/
//====================================================================

#define  BULBMON_BMCR_BYPASS_MASK 0x80000000
#define  BULBMON_BMCR_BYPASS_SHIFT 31
#define  BULBMON_BMCR_BYPASS_MASK_SHIFT(reg) (((reg) & BULBMON_BMCR_BYPASS_MASK) >> BULBMON_BMCR_BYPASS_SHIFT)
#define  BULBMON_BMCR_BYPASS_REPLACE_VAL(reg,val) (((reg) & ~BULBMON_BMCR_BYPASS_MASK) | (((uint32_t)val) << BULBMON_BMCR_BYPASS_SHIFT))

#define  BULBMON_BMCR_RESERVED1_MASK 0x78000000
#define  BULBMON_BMCR_RESERVED1_SHIFT 27
#define  BULBMON_BMCR_RESERVED1_MASK_SHIFT(reg) (((reg) & BULBMON_BMCR_RESERVED1_MASK) >> BULBMON_BMCR_RESERVED1_SHIFT)
#define  BULBMON_BMCR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~BULBMON_BMCR_RESERVED1_MASK) | (((uint32_t)val) << BULBMON_BMCR_RESERVED1_SHIFT))

#define  BULBMON_BMCR_LINESTOAVE_MASK 0x7000000
#define  BULBMON_BMCR_LINESTOAVE_SHIFT 24
#define  BULBMON_BMCR_LINESTOAVE_MASK_SHIFT(reg) (((reg) & BULBMON_BMCR_LINESTOAVE_MASK) >> BULBMON_BMCR_LINESTOAVE_SHIFT)
#define  BULBMON_BMCR_LINESTOAVE_REPLACE_VAL(reg,val) (((reg) & ~BULBMON_BMCR_LINESTOAVE_MASK) | (((uint32_t)val) << BULBMON_BMCR_LINESTOAVE_SHIFT))

#define  BULBMON_BMCR_WINLEN_MASK 0xff0000
#define  BULBMON_BMCR_WINLEN_SHIFT 16
#define  BULBMON_BMCR_WINLEN_MASK_SHIFT(reg) (((reg) & BULBMON_BMCR_WINLEN_MASK) >> BULBMON_BMCR_WINLEN_SHIFT)
#define  BULBMON_BMCR_WINLEN_REPLACE_VAL(reg,val) (((reg) & ~BULBMON_BMCR_WINLEN_MASK) | (((uint32_t)val) << BULBMON_BMCR_WINLEN_SHIFT))

#define  BULBMON_BMCR_STARTPIX_MASK 0xffff
#define  BULBMON_BMCR_STARTPIX_SHIFT 0
#define  BULBMON_BMCR_STARTPIX_MASK_SHIFT(reg) (((reg) & BULBMON_BMCR_STARTPIX_MASK) >> BULBMON_BMCR_STARTPIX_SHIFT)
#define  BULBMON_BMCR_STARTPIX_REPLACE_VAL(reg,val) (((reg) & ~BULBMON_BMCR_STARTPIX_MASK) | (((uint32_t)val) << BULBMON_BMCR_STARTPIX_SHIFT))

//====================================================================
//Register: Bulb Monitor Color0 Register (BMR0)
/** \brief BMR0 is cleared by BypassALL, SoftReset and Hard Reset (nReset)*/
//====================================================================

#define  BULBMON_BMR0_RESERVED1_MASK 0xff000000
#define  BULBMON_BMR0_RESERVED1_SHIFT 24
#define  BULBMON_BMR0_RESERVED1_MASK_SHIFT(reg) (((reg) & BULBMON_BMR0_RESERVED1_MASK) >> BULBMON_BMR0_RESERVED1_SHIFT)
#define  BULBMON_BMR0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~BULBMON_BMR0_RESERVED1_MASK) | (((uint32_t)val) << BULBMON_BMR0_RESERVED1_SHIFT))

#define  BULBMON_BMR0_AVERAGEC0_MASK 0xffffff
#define  BULBMON_BMR0_AVERAGEC0_SHIFT 0
#define  BULBMON_BMR0_AVERAGEC0_MASK_SHIFT(reg) (((reg) & BULBMON_BMR0_AVERAGEC0_MASK) >> BULBMON_BMR0_AVERAGEC0_SHIFT)
#define  BULBMON_BMR0_AVERAGEC0_REPLACE_VAL(reg,val) (((reg) & ~BULBMON_BMR0_AVERAGEC0_MASK) | (((uint32_t)val) << BULBMON_BMR0_AVERAGEC0_SHIFT))

//====================================================================
//Register: Bulb Monitor Color1 Register (BMR1)
/** \brief BMR1 is cleared by BypassALL, SoftReset and Hard Reset (nReset)*/
//====================================================================

#define  BULBMON_BMR1_RESERVED1_MASK 0xff000000
#define  BULBMON_BMR1_RESERVED1_SHIFT 24
#define  BULBMON_BMR1_RESERVED1_MASK_SHIFT(reg) (((reg) & BULBMON_BMR1_RESERVED1_MASK) >> BULBMON_BMR1_RESERVED1_SHIFT)
#define  BULBMON_BMR1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~BULBMON_BMR1_RESERVED1_MASK) | (((uint32_t)val) << BULBMON_BMR1_RESERVED1_SHIFT))

#define  BULBMON_BMR1_AVERAGEC1_MASK 0xffffff
#define  BULBMON_BMR1_AVERAGEC1_SHIFT 0
#define  BULBMON_BMR1_AVERAGEC1_MASK_SHIFT(reg) (((reg) & BULBMON_BMR1_AVERAGEC1_MASK) >> BULBMON_BMR1_AVERAGEC1_SHIFT)
#define  BULBMON_BMR1_AVERAGEC1_REPLACE_VAL(reg,val) (((reg) & ~BULBMON_BMR1_AVERAGEC1_MASK) | (((uint32_t)val) << BULBMON_BMR1_AVERAGEC1_SHIFT))

//====================================================================
//Register: Bulb Monitor Color2 Register (BMR2)
/** \brief BMR2 is cleared by BypassALL, SoftReset and Hard Reset (nReset)*/
//====================================================================

#define  BULBMON_BMR2_RESERVED1_MASK 0xff000000
#define  BULBMON_BMR2_RESERVED1_SHIFT 24
#define  BULBMON_BMR2_RESERVED1_MASK_SHIFT(reg) (((reg) & BULBMON_BMR2_RESERVED1_MASK) >> BULBMON_BMR2_RESERVED1_SHIFT)
#define  BULBMON_BMR2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~BULBMON_BMR2_RESERVED1_MASK) | (((uint32_t)val) << BULBMON_BMR2_RESERVED1_SHIFT))

#define  BULBMON_BMR2_AVERAGEC2_MASK 0xffffff
#define  BULBMON_BMR2_AVERAGEC2_SHIFT 0
#define  BULBMON_BMR2_AVERAGEC2_MASK_SHIFT(reg) (((reg) & BULBMON_BMR2_AVERAGEC2_MASK) >> BULBMON_BMR2_AVERAGEC2_SHIFT)
#define  BULBMON_BMR2_AVERAGEC2_REPLACE_VAL(reg,val) (((reg) & ~BULBMON_BMR2_AVERAGEC2_MASK) | (((uint32_t)val) << BULBMON_BMR2_AVERAGEC2_SHIFT))

//====================================================================
//Register: Bulb Monitor Exposure Register (BMR3)
/** \brief BMR2 is cleared by BypassALL, SoftReset and Hard Reset (nReset)*/
//====================================================================

#define  BULBMON_BMR3_RESERVED1_MASK 0xfff00000
#define  BULBMON_BMR3_RESERVED1_SHIFT 20
#define  BULBMON_BMR3_RESERVED1_MASK_SHIFT(reg) (((reg) & BULBMON_BMR3_RESERVED1_MASK) >> BULBMON_BMR3_RESERVED1_SHIFT)
#define  BULBMON_BMR3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~BULBMON_BMR3_RESERVED1_MASK) | (((uint32_t)val) << BULBMON_BMR3_RESERVED1_SHIFT))

#define  BULBMON_BMR3_ACCEXP_MASK 0xfffff
#define  BULBMON_BMR3_ACCEXP_SHIFT 0
#define  BULBMON_BMR3_ACCEXP_MASK_SHIFT(reg) (((reg) & BULBMON_BMR3_ACCEXP_MASK) >> BULBMON_BMR3_ACCEXP_SHIFT)
#define  BULBMON_BMR3_ACCEXP_REPLACE_VAL(reg,val) (((reg) & ~BULBMON_BMR3_ACCEXP_MASK) | (((uint32_t)val) << BULBMON_BMR3_ACCEXP_SHIFT))

//====================================================================
//Register: IP Tagging Revision 0 (REV0)
/** \brief Provide means for firmware to read IP tagging information.
      This register of particular interest to firmware.*/
//====================================================================

#define  BULBMON_REV0_MAJ_MASK 0xffff0000
#define  BULBMON_REV0_MAJ_SHIFT 16
#define  BULBMON_REV0_MAJ_MASK_SHIFT(reg) (((reg) & BULBMON_REV0_MAJ_MASK) >> BULBMON_REV0_MAJ_SHIFT)
#define  BULBMON_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~BULBMON_REV0_MAJ_MASK) | (((uint32_t)val) << BULBMON_REV0_MAJ_SHIFT))

#define  BULBMON_REV0_MID_MASK 0xffff
#define  BULBMON_REV0_MID_SHIFT 0
#define  BULBMON_REV0_MID_MASK_SHIFT(reg) (((reg) & BULBMON_REV0_MID_MASK) >> BULBMON_REV0_MID_SHIFT)
#define  BULBMON_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~BULBMON_REV0_MID_MASK) | (((uint32_t)val) << BULBMON_REV0_MID_SHIFT))

//====================================================================
//Register: IP Tagging Revision 1 (REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  BULBMON_REV1_RESERVED1_MASK 0xffff0000
#define  BULBMON_REV1_RESERVED1_SHIFT 16
#define  BULBMON_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & BULBMON_REV1_RESERVED1_MASK) >> BULBMON_REV1_RESERVED1_SHIFT)
#define  BULBMON_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~BULBMON_REV1_RESERVED1_MASK) | (((uint32_t)val) << BULBMON_REV1_RESERVED1_SHIFT))

#define  BULBMON_REV1_CFG_MASK 0xffff
#define  BULBMON_REV1_CFG_SHIFT 0
#define  BULBMON_REV1_CFG_MASK_SHIFT(reg) (((reg) & BULBMON_REV1_CFG_MASK) >> BULBMON_REV1_CFG_SHIFT)
#define  BULBMON_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~BULBMON_REV1_CFG_MASK) | (((uint32_t)val) << BULBMON_REV1_CFG_SHIFT))

//====================================================================
//
//Register File: PIC L/R Margin0 (LRMargin0)
/** \brief Register Descriptions for the PIC LRMargin block (rev 0 . 2 . 3 . 8)*/
//
//====================================================================

//====================================================================
//Register: Left/Right Margins Configuration Register (LRCR)
/** \brief General configuration register for LRMargin block.*/
//====================================================================

#define  LRMARGIN0_LRCR_BYPASS_MASK 0x80000000
#define  LRMARGIN0_LRCR_BYPASS_SHIFT 31
#define  LRMARGIN0_LRCR_BYPASS_MASK_SHIFT(reg) (((reg) & LRMARGIN0_LRCR_BYPASS_MASK) >> LRMARGIN0_LRCR_BYPASS_SHIFT)
#define  LRMARGIN0_LRCR_BYPASS_REPLACE_VAL(reg,val) (((reg) & ~LRMARGIN0_LRCR_BYPASS_MASK) | (((uint32_t)val) << LRMARGIN0_LRCR_BYPASS_SHIFT))

#define  LRMARGIN0_LRCR_RESERVED1_MASK 0x7fffffff
#define  LRMARGIN0_LRCR_RESERVED1_SHIFT 0
#define  LRMARGIN0_LRCR_RESERVED1_MASK_SHIFT(reg) (((reg) & LRMARGIN0_LRCR_RESERVED1_MASK) >> LRMARGIN0_LRCR_RESERVED1_SHIFT)
#define  LRMARGIN0_LRCR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~LRMARGIN0_LRCR_RESERVED1_MASK) | (((uint32_t)val) << LRMARGIN0_LRCR_RESERVED1_SHIFT))

//====================================================================
//Register: Left/Right Margins Register (LRMR0)
//====================================================================

#define  LRMARGIN0_LRMR0_RIGHTMARGINC0_MASK 0xffff0000
#define  LRMARGIN0_LRMR0_RIGHTMARGINC0_SHIFT 16
#define  LRMARGIN0_LRMR0_RIGHTMARGINC0_MASK_SHIFT(reg) (((reg) & LRMARGIN0_LRMR0_RIGHTMARGINC0_MASK) >> LRMARGIN0_LRMR0_RIGHTMARGINC0_SHIFT)
#define  LRMARGIN0_LRMR0_RIGHTMARGINC0_REPLACE_VAL(reg,val) (((reg) & ~LRMARGIN0_LRMR0_RIGHTMARGINC0_MASK) | (((uint32_t)val) << LRMARGIN0_LRMR0_RIGHTMARGINC0_SHIFT))

#define  LRMARGIN0_LRMR0_LEFTMARGINC0_MASK 0xffff
#define  LRMARGIN0_LRMR0_LEFTMARGINC0_SHIFT 0
#define  LRMARGIN0_LRMR0_LEFTMARGINC0_MASK_SHIFT(reg) (((reg) & LRMARGIN0_LRMR0_LEFTMARGINC0_MASK) >> LRMARGIN0_LRMR0_LEFTMARGINC0_SHIFT)
#define  LRMARGIN0_LRMR0_LEFTMARGINC0_REPLACE_VAL(reg,val) (((reg) & ~LRMARGIN0_LRMR0_LEFTMARGINC0_MASK) | (((uint32_t)val) << LRMARGIN0_LRMR0_LEFTMARGINC0_SHIFT))

//====================================================================
//Register: Left/Right Margins Register (LRMR1)
//====================================================================

#define  LRMARGIN0_LRMR1_RIGHTMARGINC1_MASK 0xffff0000
#define  LRMARGIN0_LRMR1_RIGHTMARGINC1_SHIFT 16
#define  LRMARGIN0_LRMR1_RIGHTMARGINC1_MASK_SHIFT(reg) (((reg) & LRMARGIN0_LRMR1_RIGHTMARGINC1_MASK) >> LRMARGIN0_LRMR1_RIGHTMARGINC1_SHIFT)
#define  LRMARGIN0_LRMR1_RIGHTMARGINC1_REPLACE_VAL(reg,val) (((reg) & ~LRMARGIN0_LRMR1_RIGHTMARGINC1_MASK) | (((uint32_t)val) << LRMARGIN0_LRMR1_RIGHTMARGINC1_SHIFT))

#define  LRMARGIN0_LRMR1_LEFTMARGINC1_MASK 0xffff
#define  LRMARGIN0_LRMR1_LEFTMARGINC1_SHIFT 0
#define  LRMARGIN0_LRMR1_LEFTMARGINC1_MASK_SHIFT(reg) (((reg) & LRMARGIN0_LRMR1_LEFTMARGINC1_MASK) >> LRMARGIN0_LRMR1_LEFTMARGINC1_SHIFT)
#define  LRMARGIN0_LRMR1_LEFTMARGINC1_REPLACE_VAL(reg,val) (((reg) & ~LRMARGIN0_LRMR1_LEFTMARGINC1_MASK) | (((uint32_t)val) << LRMARGIN0_LRMR1_LEFTMARGINC1_SHIFT))

//====================================================================
//Register: Left/Right Margins Register (LRMR2)
//====================================================================

#define  LRMARGIN0_LRMR2_RIGHTMARGINC2_MASK 0xffff0000
#define  LRMARGIN0_LRMR2_RIGHTMARGINC2_SHIFT 16
#define  LRMARGIN0_LRMR2_RIGHTMARGINC2_MASK_SHIFT(reg) (((reg) & LRMARGIN0_LRMR2_RIGHTMARGINC2_MASK) >> LRMARGIN0_LRMR2_RIGHTMARGINC2_SHIFT)
#define  LRMARGIN0_LRMR2_RIGHTMARGINC2_REPLACE_VAL(reg,val) (((reg) & ~LRMARGIN0_LRMR2_RIGHTMARGINC2_MASK) | (((uint32_t)val) << LRMARGIN0_LRMR2_RIGHTMARGINC2_SHIFT))

#define  LRMARGIN0_LRMR2_LEFTMARGINC2_MASK 0xffff
#define  LRMARGIN0_LRMR2_LEFTMARGINC2_SHIFT 0
#define  LRMARGIN0_LRMR2_LEFTMARGINC2_MASK_SHIFT(reg) (((reg) & LRMARGIN0_LRMR2_LEFTMARGINC2_MASK) >> LRMARGIN0_LRMR2_LEFTMARGINC2_SHIFT)
#define  LRMARGIN0_LRMR2_LEFTMARGINC2_REPLACE_VAL(reg,val) (((reg) & ~LRMARGIN0_LRMR2_LEFTMARGINC2_MASK) | (((uint32_t)val) << LRMARGIN0_LRMR2_LEFTMARGINC2_SHIFT))

//====================================================================
//Register: IP Tagging Revision 0 (REV0)
/** \brief Provide means for firmware to read IP tagging information.
      This register of particular interest to firmware.*/
//====================================================================

#define  LRMARGIN0_REV0_MAJ_MASK 0xffff0000
#define  LRMARGIN0_REV0_MAJ_SHIFT 16
#define  LRMARGIN0_REV0_MAJ_MASK_SHIFT(reg) (((reg) & LRMARGIN0_REV0_MAJ_MASK) >> LRMARGIN0_REV0_MAJ_SHIFT)
#define  LRMARGIN0_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~LRMARGIN0_REV0_MAJ_MASK) | (((uint32_t)val) << LRMARGIN0_REV0_MAJ_SHIFT))

#define  LRMARGIN0_REV0_MID_MASK 0xffff
#define  LRMARGIN0_REV0_MID_SHIFT 0
#define  LRMARGIN0_REV0_MID_MASK_SHIFT(reg) (((reg) & LRMARGIN0_REV0_MID_MASK) >> LRMARGIN0_REV0_MID_SHIFT)
#define  LRMARGIN0_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~LRMARGIN0_REV0_MID_MASK) | (((uint32_t)val) << LRMARGIN0_REV0_MID_SHIFT))

//====================================================================
//Register: IP Tagging Revision 1 (REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  LRMARGIN0_REV1_RESERVED1_MASK 0xffff0000
#define  LRMARGIN0_REV1_RESERVED1_SHIFT 16
#define  LRMARGIN0_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & LRMARGIN0_REV1_RESERVED1_MASK) >> LRMARGIN0_REV1_RESERVED1_SHIFT)
#define  LRMARGIN0_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~LRMARGIN0_REV1_RESERVED1_MASK) | (((uint32_t)val) << LRMARGIN0_REV1_RESERVED1_SHIFT))

#define  LRMARGIN0_REV1_CFG_MASK 0xffff
#define  LRMARGIN0_REV1_CFG_SHIFT 0
#define  LRMARGIN0_REV1_CFG_MASK_SHIFT(reg) (((reg) & LRMARGIN0_REV1_CFG_MASK) >> LRMARGIN0_REV1_CFG_SHIFT)
#define  LRMARGIN0_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~LRMARGIN0_REV1_CFG_MASK) | (((uint32_t)val) << LRMARGIN0_REV1_CFG_SHIFT))

//====================================================================
//
//Register File: PIC IDMA_2D (IDMA_2D)
/** \brief Register Descriptions for the PIC IDMA_2D block (rev 0 . 1 . 0 . 0)*/
//
//====================================================================

//====================================================================
//Register: Configuration register (cfg)
//====================================================================

#define  IDMA_2D_CFG_RESERVED1_MASK 0xfffe0000
#define  IDMA_2D_CFG_RESERVED1_SHIFT 17
#define  IDMA_2D_CFG_RESERVED1_MASK_SHIFT(reg) (((reg) & IDMA_2D_CFG_RESERVED1_MASK) >> IDMA_2D_CFG_RESERVED1_SHIFT)
#define  IDMA_2D_CFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IDMA_2D_CFG_RESERVED1_MASK) | (((uint32_t)val) << IDMA_2D_CFG_RESERVED1_SHIFT))

#define  IDMA_2D_CFG_ENABLE_MASK 0x10000
#define  IDMA_2D_CFG_ENABLE_SHIFT 16
#define  IDMA_2D_CFG_ENABLE_MASK_SHIFT(reg) (((reg) & IDMA_2D_CFG_ENABLE_MASK) >> IDMA_2D_CFG_ENABLE_SHIFT)
#define  IDMA_2D_CFG_ENABLE_REPLACE_VAL(reg,val) (((reg) & ~IDMA_2D_CFG_ENABLE_MASK) | (((uint32_t)val) << IDMA_2D_CFG_ENABLE_SHIFT))

#define  IDMA_2D_CFG_DATAAXCACHE_MASK 0xf000
#define  IDMA_2D_CFG_DATAAXCACHE_SHIFT 12
#define  IDMA_2D_CFG_DATAAXCACHE_MASK_SHIFT(reg) (((reg) & IDMA_2D_CFG_DATAAXCACHE_MASK) >> IDMA_2D_CFG_DATAAXCACHE_SHIFT)
#define  IDMA_2D_CFG_DATAAXCACHE_REPLACE_VAL(reg,val) (((reg) & ~IDMA_2D_CFG_DATAAXCACHE_MASK) | (((uint32_t)val) << IDMA_2D_CFG_DATAAXCACHE_SHIFT))

#define  IDMA_2D_CFG_DESCARCACHE_MASK 0xf00
#define  IDMA_2D_CFG_DESCARCACHE_SHIFT 8
#define  IDMA_2D_CFG_DESCARCACHE_MASK_SHIFT(reg) (((reg) & IDMA_2D_CFG_DESCARCACHE_MASK) >> IDMA_2D_CFG_DESCARCACHE_SHIFT)
#define  IDMA_2D_CFG_DESCARCACHE_REPLACE_VAL(reg,val) (((reg) & ~IDMA_2D_CFG_DESCARCACHE_MASK) | (((uint32_t)val) << IDMA_2D_CFG_DESCARCACHE_SHIFT))

#define  IDMA_2D_CFG_DESCAWCACHE_MASK 0xf0
#define  IDMA_2D_CFG_DESCAWCACHE_SHIFT 4
#define  IDMA_2D_CFG_DESCAWCACHE_MASK_SHIFT(reg) (((reg) & IDMA_2D_CFG_DESCAWCACHE_MASK) >> IDMA_2D_CFG_DESCAWCACHE_SHIFT)
#define  IDMA_2D_CFG_DESCAWCACHE_REPLACE_VAL(reg,val) (((reg) & ~IDMA_2D_CFG_DESCAWCACHE_MASK) | (((uint32_t)val) << IDMA_2D_CFG_DESCAWCACHE_SHIFT))

#define  IDMA_2D_CFG_RESERVED2_MASK 0xc
#define  IDMA_2D_CFG_RESERVED2_SHIFT 2
#define  IDMA_2D_CFG_RESERVED2_MASK_SHIFT(reg) (((reg) & IDMA_2D_CFG_RESERVED2_MASK) >> IDMA_2D_CFG_RESERVED2_SHIFT)
#define  IDMA_2D_CFG_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~IDMA_2D_CFG_RESERVED2_MASK) | (((uint32_t)val) << IDMA_2D_CFG_RESERVED2_SHIFT))

#define  IDMA_2D_CFG_BURST_LEN_MASK 0x3
#define  IDMA_2D_CFG_BURST_LEN_SHIFT 0
#define  IDMA_2D_CFG_BURST_LEN_MASK_SHIFT(reg) (((reg) & IDMA_2D_CFG_BURST_LEN_MASK) >> IDMA_2D_CFG_BURST_LEN_SHIFT)
#define  IDMA_2D_CFG_BURST_LEN_REPLACE_VAL(reg,val) (((reg) & ~IDMA_2D_CFG_BURST_LEN_MASK) | (((uint32_t)val) << IDMA_2D_CFG_BURST_LEN_SHIFT))

//====================================================================
//Register: Status register (status)
//====================================================================

#define  IDMA_2D_STATUS_RESERVED1_MASK 0xfffffe00
#define  IDMA_2D_STATUS_RESERVED1_SHIFT 9
#define  IDMA_2D_STATUS_RESERVED1_MASK_SHIFT(reg) (((reg) & IDMA_2D_STATUS_RESERVED1_MASK) >> IDMA_2D_STATUS_RESERVED1_SHIFT)
#define  IDMA_2D_STATUS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IDMA_2D_STATUS_RESERVED1_MASK) | (((uint32_t)val) << IDMA_2D_STATUS_RESERVED1_SHIFT))

#define  IDMA_2D_STATUS_SOI_MASK 0x100
#define  IDMA_2D_STATUS_SOI_SHIFT 8
#define  IDMA_2D_STATUS_SOI_MASK_SHIFT(reg) (((reg) & IDMA_2D_STATUS_SOI_MASK) >> IDMA_2D_STATUS_SOI_SHIFT)
#define  IDMA_2D_STATUS_SOI_REPLACE_VAL(reg,val) (((reg) & ~IDMA_2D_STATUS_SOI_MASK) | (((uint32_t)val) << IDMA_2D_STATUS_SOI_SHIFT))

#define  IDMA_2D_STATUS_EOI_MASK 0x80
#define  IDMA_2D_STATUS_EOI_SHIFT 7
#define  IDMA_2D_STATUS_EOI_MASK_SHIFT(reg) (((reg) & IDMA_2D_STATUS_EOI_MASK) >> IDMA_2D_STATUS_EOI_SHIFT)
#define  IDMA_2D_STATUS_EOI_REPLACE_VAL(reg,val) (((reg) & ~IDMA_2D_STATUS_EOI_MASK) | (((uint32_t)val) << IDMA_2D_STATUS_EOI_SHIFT))

#define  IDMA_2D_STATUS_SOFTRESET_MASK 0x40
#define  IDMA_2D_STATUS_SOFTRESET_SHIFT 6
#define  IDMA_2D_STATUS_SOFTRESET_MASK_SHIFT(reg) (((reg) & IDMA_2D_STATUS_SOFTRESET_MASK) >> IDMA_2D_STATUS_SOFTRESET_SHIFT)
#define  IDMA_2D_STATUS_SOFTRESET_REPLACE_VAL(reg,val) (((reg) & ~IDMA_2D_STATUS_SOFTRESET_MASK) | (((uint32_t)val) << IDMA_2D_STATUS_SOFTRESET_SHIFT))

#define  IDMA_2D_STATUS_FULL_CBUF_MASK 0x20
#define  IDMA_2D_STATUS_FULL_CBUF_SHIFT 5
#define  IDMA_2D_STATUS_FULL_CBUF_MASK_SHIFT(reg) (((reg) & IDMA_2D_STATUS_FULL_CBUF_MASK) >> IDMA_2D_STATUS_FULL_CBUF_SHIFT)
#define  IDMA_2D_STATUS_FULL_CBUF_REPLACE_VAL(reg,val) (((reg) & ~IDMA_2D_STATUS_FULL_CBUF_MASK) | (((uint32_t)val) << IDMA_2D_STATUS_FULL_CBUF_SHIFT))

#define  IDMA_2D_STATUS_EMPTY_CBUF_MASK 0x10
#define  IDMA_2D_STATUS_EMPTY_CBUF_SHIFT 4
#define  IDMA_2D_STATUS_EMPTY_CBUF_MASK_SHIFT(reg) (((reg) & IDMA_2D_STATUS_EMPTY_CBUF_MASK) >> IDMA_2D_STATUS_EMPTY_CBUF_SHIFT)
#define  IDMA_2D_STATUS_EMPTY_CBUF_REPLACE_VAL(reg,val) (((reg) & ~IDMA_2D_STATUS_EMPTY_CBUF_MASK) | (((uint32_t)val) << IDMA_2D_STATUS_EMPTY_CBUF_SHIFT))

#define  IDMA_2D_STATUS_FULL_DBUF_MASK 0x8
#define  IDMA_2D_STATUS_FULL_DBUF_SHIFT 3
#define  IDMA_2D_STATUS_FULL_DBUF_MASK_SHIFT(reg) (((reg) & IDMA_2D_STATUS_FULL_DBUF_MASK) >> IDMA_2D_STATUS_FULL_DBUF_SHIFT)
#define  IDMA_2D_STATUS_FULL_DBUF_REPLACE_VAL(reg,val) (((reg) & ~IDMA_2D_STATUS_FULL_DBUF_MASK) | (((uint32_t)val) << IDMA_2D_STATUS_FULL_DBUF_SHIFT))

#define  IDMA_2D_STATUS_EMPTY_DBUF_MASK 0x4
#define  IDMA_2D_STATUS_EMPTY_DBUF_SHIFT 2
#define  IDMA_2D_STATUS_EMPTY_DBUF_MASK_SHIFT(reg) (((reg) & IDMA_2D_STATUS_EMPTY_DBUF_MASK) >> IDMA_2D_STATUS_EMPTY_DBUF_SHIFT)
#define  IDMA_2D_STATUS_EMPTY_DBUF_REPLACE_VAL(reg,val) (((reg) & ~IDMA_2D_STATUS_EMPTY_DBUF_MASK) | (((uint32_t)val) << IDMA_2D_STATUS_EMPTY_DBUF_SHIFT))

#define  IDMA_2D_STATUS_PACKER_EMPTY_MASK 0x2
#define  IDMA_2D_STATUS_PACKER_EMPTY_SHIFT 1
#define  IDMA_2D_STATUS_PACKER_EMPTY_MASK_SHIFT(reg) (((reg) & IDMA_2D_STATUS_PACKER_EMPTY_MASK) >> IDMA_2D_STATUS_PACKER_EMPTY_SHIFT)
#define  IDMA_2D_STATUS_PACKER_EMPTY_REPLACE_VAL(reg,val) (((reg) & ~IDMA_2D_STATUS_PACKER_EMPTY_MASK) | (((uint32_t)val) << IDMA_2D_STATUS_PACKER_EMPTY_SHIFT))

#define  IDMA_2D_STATUS_DMA_BUSY_MASK 0x1
#define  IDMA_2D_STATUS_DMA_BUSY_SHIFT 0
#define  IDMA_2D_STATUS_DMA_BUSY_MASK_SHIFT(reg) (((reg) & IDMA_2D_STATUS_DMA_BUSY_MASK) >> IDMA_2D_STATUS_DMA_BUSY_SHIFT)
#define  IDMA_2D_STATUS_DMA_BUSY_REPLACE_VAL(reg,val) (((reg) & ~IDMA_2D_STATUS_DMA_BUSY_MASK) | (((uint32_t)val) << IDMA_2D_STATUS_DMA_BUSY_SHIFT))

//====================================================================
//Register: Line Width register (line_width)
//====================================================================

#define  IDMA_2D_LINE_WIDTH_REPEAT_FOREVER_MASK 0x80000000
#define  IDMA_2D_LINE_WIDTH_REPEAT_FOREVER_SHIFT 31
#define  IDMA_2D_LINE_WIDTH_REPEAT_FOREVER_MASK_SHIFT(reg) (((reg) & IDMA_2D_LINE_WIDTH_REPEAT_FOREVER_MASK) >> IDMA_2D_LINE_WIDTH_REPEAT_FOREVER_SHIFT)
#define  IDMA_2D_LINE_WIDTH_REPEAT_FOREVER_REPLACE_VAL(reg,val) (((reg) & ~IDMA_2D_LINE_WIDTH_REPEAT_FOREVER_MASK) | (((uint32_t)val) << IDMA_2D_LINE_WIDTH_REPEAT_FOREVER_SHIFT))

#define  IDMA_2D_LINE_WIDTH_RESERVED1_MASK 0x70000000
#define  IDMA_2D_LINE_WIDTH_RESERVED1_SHIFT 28
#define  IDMA_2D_LINE_WIDTH_RESERVED1_MASK_SHIFT(reg) (((reg) & IDMA_2D_LINE_WIDTH_RESERVED1_MASK) >> IDMA_2D_LINE_WIDTH_RESERVED1_SHIFT)
#define  IDMA_2D_LINE_WIDTH_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IDMA_2D_LINE_WIDTH_RESERVED1_MASK) | (((uint32_t)val) << IDMA_2D_LINE_WIDTH_RESERVED1_SHIFT))

#define  IDMA_2D_LINE_WIDTH_REPEAT_LINE_CNT_MASK 0xff00000
#define  IDMA_2D_LINE_WIDTH_REPEAT_LINE_CNT_SHIFT 20
#define  IDMA_2D_LINE_WIDTH_REPEAT_LINE_CNT_MASK_SHIFT(reg) (((reg) & IDMA_2D_LINE_WIDTH_REPEAT_LINE_CNT_MASK) >> IDMA_2D_LINE_WIDTH_REPEAT_LINE_CNT_SHIFT)
#define  IDMA_2D_LINE_WIDTH_REPEAT_LINE_CNT_REPLACE_VAL(reg,val) (((reg) & ~IDMA_2D_LINE_WIDTH_REPEAT_LINE_CNT_MASK) | (((uint32_t)val) << IDMA_2D_LINE_WIDTH_REPEAT_LINE_CNT_SHIFT))

#define  IDMA_2D_LINE_WIDTH_LINE_WIDTH_MASK 0xfffff
#define  IDMA_2D_LINE_WIDTH_LINE_WIDTH_SHIFT 0
#define  IDMA_2D_LINE_WIDTH_LINE_WIDTH_MASK_SHIFT(reg) (((reg) & IDMA_2D_LINE_WIDTH_LINE_WIDTH_MASK) >> IDMA_2D_LINE_WIDTH_LINE_WIDTH_SHIFT)
#define  IDMA_2D_LINE_WIDTH_LINE_WIDTH_REPLACE_VAL(reg,val) (((reg) & ~IDMA_2D_LINE_WIDTH_LINE_WIDTH_MASK) | (((uint32_t)val) << IDMA_2D_LINE_WIDTH_LINE_WIDTH_SHIFT))

//====================================================================
//Register: Interrupt Enable Register (int_en)
//====================================================================

#define  IDMA_2D_INT_EN_RESERVED1_MASK 0xffffffe0
#define  IDMA_2D_INT_EN_RESERVED1_SHIFT 5
#define  IDMA_2D_INT_EN_RESERVED1_MASK_SHIFT(reg) (((reg) & IDMA_2D_INT_EN_RESERVED1_MASK) >> IDMA_2D_INT_EN_RESERVED1_SHIFT)
#define  IDMA_2D_INT_EN_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IDMA_2D_INT_EN_RESERVED1_MASK) | (((uint32_t)val) << IDMA_2D_INT_EN_RESERVED1_SHIFT))

#define  IDMA_2D_INT_EN_EOL_INT_EN_MASK 0x10
#define  IDMA_2D_INT_EN_EOL_INT_EN_SHIFT 4
#define  IDMA_2D_INT_EN_EOL_INT_EN_MASK_SHIFT(reg) (((reg) & IDMA_2D_INT_EN_EOL_INT_EN_MASK) >> IDMA_2D_INT_EN_EOL_INT_EN_SHIFT)
#define  IDMA_2D_INT_EN_EOL_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~IDMA_2D_INT_EN_EOL_INT_EN_MASK) | (((uint32_t)val) << IDMA_2D_INT_EN_EOL_INT_EN_SHIFT))

#define  IDMA_2D_INT_EN_RST_INT_EN_MASK 0x8
#define  IDMA_2D_INT_EN_RST_INT_EN_SHIFT 3
#define  IDMA_2D_INT_EN_RST_INT_EN_MASK_SHIFT(reg) (((reg) & IDMA_2D_INT_EN_RST_INT_EN_MASK) >> IDMA_2D_INT_EN_RST_INT_EN_SHIFT)
#define  IDMA_2D_INT_EN_RST_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~IDMA_2D_INT_EN_RST_INT_EN_MASK) | (((uint32_t)val) << IDMA_2D_INT_EN_RST_INT_EN_SHIFT))

#define  IDMA_2D_INT_EN_EOI_INT_EN_MASK 0x4
#define  IDMA_2D_INT_EN_EOI_INT_EN_SHIFT 2
#define  IDMA_2D_INT_EN_EOI_INT_EN_MASK_SHIFT(reg) (((reg) & IDMA_2D_INT_EN_EOI_INT_EN_MASK) >> IDMA_2D_INT_EN_EOI_INT_EN_SHIFT)
#define  IDMA_2D_INT_EN_EOI_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~IDMA_2D_INT_EN_EOI_INT_EN_MASK) | (((uint32_t)val) << IDMA_2D_INT_EN_EOI_INT_EN_SHIFT))

#define  IDMA_2D_INT_EN_FIN_INT_EN_MASK 0x2
#define  IDMA_2D_INT_EN_FIN_INT_EN_SHIFT 1
#define  IDMA_2D_INT_EN_FIN_INT_EN_MASK_SHIFT(reg) (((reg) & IDMA_2D_INT_EN_FIN_INT_EN_MASK) >> IDMA_2D_INT_EN_FIN_INT_EN_SHIFT)
#define  IDMA_2D_INT_EN_FIN_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~IDMA_2D_INT_EN_FIN_INT_EN_MASK) | (((uint32_t)val) << IDMA_2D_INT_EN_FIN_INT_EN_SHIFT))

#define  IDMA_2D_INT_EN_WHO_INT_EN_MASK 0x1
#define  IDMA_2D_INT_EN_WHO_INT_EN_SHIFT 0
#define  IDMA_2D_INT_EN_WHO_INT_EN_MASK_SHIFT(reg) (((reg) & IDMA_2D_INT_EN_WHO_INT_EN_MASK) >> IDMA_2D_INT_EN_WHO_INT_EN_SHIFT)
#define  IDMA_2D_INT_EN_WHO_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~IDMA_2D_INT_EN_WHO_INT_EN_MASK) | (((uint32_t)val) << IDMA_2D_INT_EN_WHO_INT_EN_SHIFT))

//====================================================================
//Register: Interrupt Pending Register (int_st)
//====================================================================

#define  IDMA_2D_INT_ST_RESERVED1_MASK 0xffffffe0
#define  IDMA_2D_INT_ST_RESERVED1_SHIFT 5
#define  IDMA_2D_INT_ST_RESERVED1_MASK_SHIFT(reg) (((reg) & IDMA_2D_INT_ST_RESERVED1_MASK) >> IDMA_2D_INT_ST_RESERVED1_SHIFT)
#define  IDMA_2D_INT_ST_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IDMA_2D_INT_ST_RESERVED1_MASK) | (((uint32_t)val) << IDMA_2D_INT_ST_RESERVED1_SHIFT))

#define  IDMA_2D_INT_ST_EOL_INT_ST_MASK 0x10
#define  IDMA_2D_INT_ST_EOL_INT_ST_SHIFT 4
#define  IDMA_2D_INT_ST_EOL_INT_ST_MASK_SHIFT(reg) (((reg) & IDMA_2D_INT_ST_EOL_INT_ST_MASK) >> IDMA_2D_INT_ST_EOL_INT_ST_SHIFT)
#define  IDMA_2D_INT_ST_EOL_INT_ST_REPLACE_VAL(reg,val) (((reg) & ~IDMA_2D_INT_ST_EOL_INT_ST_MASK) | (((uint32_t)val) << IDMA_2D_INT_ST_EOL_INT_ST_SHIFT))

#define  IDMA_2D_INT_ST_RST_INT_ST_MASK 0x8
#define  IDMA_2D_INT_ST_RST_INT_ST_SHIFT 3
#define  IDMA_2D_INT_ST_RST_INT_ST_MASK_SHIFT(reg) (((reg) & IDMA_2D_INT_ST_RST_INT_ST_MASK) >> IDMA_2D_INT_ST_RST_INT_ST_SHIFT)
#define  IDMA_2D_INT_ST_RST_INT_ST_REPLACE_VAL(reg,val) (((reg) & ~IDMA_2D_INT_ST_RST_INT_ST_MASK) | (((uint32_t)val) << IDMA_2D_INT_ST_RST_INT_ST_SHIFT))

#define  IDMA_2D_INT_ST_EOI_INT_ST_MASK 0x4
#define  IDMA_2D_INT_ST_EOI_INT_ST_SHIFT 2
#define  IDMA_2D_INT_ST_EOI_INT_ST_MASK_SHIFT(reg) (((reg) & IDMA_2D_INT_ST_EOI_INT_ST_MASK) >> IDMA_2D_INT_ST_EOI_INT_ST_SHIFT)
#define  IDMA_2D_INT_ST_EOI_INT_ST_REPLACE_VAL(reg,val) (((reg) & ~IDMA_2D_INT_ST_EOI_INT_ST_MASK) | (((uint32_t)val) << IDMA_2D_INT_ST_EOI_INT_ST_SHIFT))

#define  IDMA_2D_INT_ST_FIN_INT_ST_MASK 0x2
#define  IDMA_2D_INT_ST_FIN_INT_ST_SHIFT 1
#define  IDMA_2D_INT_ST_FIN_INT_ST_MASK_SHIFT(reg) (((reg) & IDMA_2D_INT_ST_FIN_INT_ST_MASK) >> IDMA_2D_INT_ST_FIN_INT_ST_SHIFT)
#define  IDMA_2D_INT_ST_FIN_INT_ST_REPLACE_VAL(reg,val) (((reg) & ~IDMA_2D_INT_ST_FIN_INT_ST_MASK) | (((uint32_t)val) << IDMA_2D_INT_ST_FIN_INT_ST_SHIFT))

#define  IDMA_2D_INT_ST_WHO_INT_ST_MASK 0x1
#define  IDMA_2D_INT_ST_WHO_INT_ST_SHIFT 0
#define  IDMA_2D_INT_ST_WHO_INT_ST_MASK_SHIFT(reg) (((reg) & IDMA_2D_INT_ST_WHO_INT_ST_MASK) >> IDMA_2D_INT_ST_WHO_INT_ST_SHIFT)
#define  IDMA_2D_INT_ST_WHO_INT_ST_REPLACE_VAL(reg,val) (((reg) & ~IDMA_2D_INT_ST_WHO_INT_ST_MASK) | (((uint32_t)val) << IDMA_2D_INT_ST_WHO_INT_ST_SHIFT))

//====================================================================
//Register: Interrupt Clear Register (int_cl)
//====================================================================

#define  IDMA_2D_INT_CL_RESERVED1_MASK 0xffffffe0
#define  IDMA_2D_INT_CL_RESERVED1_SHIFT 5
#define  IDMA_2D_INT_CL_RESERVED1_MASK_SHIFT(reg) (((reg) & IDMA_2D_INT_CL_RESERVED1_MASK) >> IDMA_2D_INT_CL_RESERVED1_SHIFT)
#define  IDMA_2D_INT_CL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IDMA_2D_INT_CL_RESERVED1_MASK) | (((uint32_t)val) << IDMA_2D_INT_CL_RESERVED1_SHIFT))

#define  IDMA_2D_INT_CL_EOL_INT_CL_MASK 0x10
#define  IDMA_2D_INT_CL_EOL_INT_CL_SHIFT 4
#define  IDMA_2D_INT_CL_EOL_INT_CL_MASK_SHIFT(reg) (((reg) & IDMA_2D_INT_CL_EOL_INT_CL_MASK) >> IDMA_2D_INT_CL_EOL_INT_CL_SHIFT)
#define  IDMA_2D_INT_CL_EOL_INT_CL_REPLACE_VAL(reg,val) (((reg) & ~IDMA_2D_INT_CL_EOL_INT_CL_MASK) | (((uint32_t)val) << IDMA_2D_INT_CL_EOL_INT_CL_SHIFT))

#define  IDMA_2D_INT_CL_RST_INT_CL_MASK 0x8
#define  IDMA_2D_INT_CL_RST_INT_CL_SHIFT 3
#define  IDMA_2D_INT_CL_RST_INT_CL_MASK_SHIFT(reg) (((reg) & IDMA_2D_INT_CL_RST_INT_CL_MASK) >> IDMA_2D_INT_CL_RST_INT_CL_SHIFT)
#define  IDMA_2D_INT_CL_RST_INT_CL_REPLACE_VAL(reg,val) (((reg) & ~IDMA_2D_INT_CL_RST_INT_CL_MASK) | (((uint32_t)val) << IDMA_2D_INT_CL_RST_INT_CL_SHIFT))

#define  IDMA_2D_INT_CL_EOI_INT_CL_MASK 0x4
#define  IDMA_2D_INT_CL_EOI_INT_CL_SHIFT 2
#define  IDMA_2D_INT_CL_EOI_INT_CL_MASK_SHIFT(reg) (((reg) & IDMA_2D_INT_CL_EOI_INT_CL_MASK) >> IDMA_2D_INT_CL_EOI_INT_CL_SHIFT)
#define  IDMA_2D_INT_CL_EOI_INT_CL_REPLACE_VAL(reg,val) (((reg) & ~IDMA_2D_INT_CL_EOI_INT_CL_MASK) | (((uint32_t)val) << IDMA_2D_INT_CL_EOI_INT_CL_SHIFT))

#define  IDMA_2D_INT_CL_FIN_INT_CL_MASK 0x2
#define  IDMA_2D_INT_CL_FIN_INT_CL_SHIFT 1
#define  IDMA_2D_INT_CL_FIN_INT_CL_MASK_SHIFT(reg) (((reg) & IDMA_2D_INT_CL_FIN_INT_CL_MASK) >> IDMA_2D_INT_CL_FIN_INT_CL_SHIFT)
#define  IDMA_2D_INT_CL_FIN_INT_CL_REPLACE_VAL(reg,val) (((reg) & ~IDMA_2D_INT_CL_FIN_INT_CL_MASK) | (((uint32_t)val) << IDMA_2D_INT_CL_FIN_INT_CL_SHIFT))

#define  IDMA_2D_INT_CL_WHO_INT_CL_MASK 0x1
#define  IDMA_2D_INT_CL_WHO_INT_CL_SHIFT 0
#define  IDMA_2D_INT_CL_WHO_INT_CL_MASK_SHIFT(reg) (((reg) & IDMA_2D_INT_CL_WHO_INT_CL_MASK) >> IDMA_2D_INT_CL_WHO_INT_CL_SHIFT)
#define  IDMA_2D_INT_CL_WHO_INT_CL_REPLACE_VAL(reg,val) (((reg) & ~IDMA_2D_INT_CL_WHO_INT_CL_MASK) | (((uint32_t)val) << IDMA_2D_INT_CL_WHO_INT_CL_SHIFT))

//====================================================================
//Register: Interrupt Force Register (int_fo)
//====================================================================

#define  IDMA_2D_INT_FO_RESERVED1_MASK 0xffffffe0
#define  IDMA_2D_INT_FO_RESERVED1_SHIFT 5
#define  IDMA_2D_INT_FO_RESERVED1_MASK_SHIFT(reg) (((reg) & IDMA_2D_INT_FO_RESERVED1_MASK) >> IDMA_2D_INT_FO_RESERVED1_SHIFT)
#define  IDMA_2D_INT_FO_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IDMA_2D_INT_FO_RESERVED1_MASK) | (((uint32_t)val) << IDMA_2D_INT_FO_RESERVED1_SHIFT))

#define  IDMA_2D_INT_FO_EOL_INT_FO_MASK 0x10
#define  IDMA_2D_INT_FO_EOL_INT_FO_SHIFT 4
#define  IDMA_2D_INT_FO_EOL_INT_FO_MASK_SHIFT(reg) (((reg) & IDMA_2D_INT_FO_EOL_INT_FO_MASK) >> IDMA_2D_INT_FO_EOL_INT_FO_SHIFT)
#define  IDMA_2D_INT_FO_EOL_INT_FO_REPLACE_VAL(reg,val) (((reg) & ~IDMA_2D_INT_FO_EOL_INT_FO_MASK) | (((uint32_t)val) << IDMA_2D_INT_FO_EOL_INT_FO_SHIFT))

#define  IDMA_2D_INT_FO_RST_INT_FO_MASK 0x8
#define  IDMA_2D_INT_FO_RST_INT_FO_SHIFT 3
#define  IDMA_2D_INT_FO_RST_INT_FO_MASK_SHIFT(reg) (((reg) & IDMA_2D_INT_FO_RST_INT_FO_MASK) >> IDMA_2D_INT_FO_RST_INT_FO_SHIFT)
#define  IDMA_2D_INT_FO_RST_INT_FO_REPLACE_VAL(reg,val) (((reg) & ~IDMA_2D_INT_FO_RST_INT_FO_MASK) | (((uint32_t)val) << IDMA_2D_INT_FO_RST_INT_FO_SHIFT))

#define  IDMA_2D_INT_FO_EOI_INT_FO_MASK 0x4
#define  IDMA_2D_INT_FO_EOI_INT_FO_SHIFT 2
#define  IDMA_2D_INT_FO_EOI_INT_FO_MASK_SHIFT(reg) (((reg) & IDMA_2D_INT_FO_EOI_INT_FO_MASK) >> IDMA_2D_INT_FO_EOI_INT_FO_SHIFT)
#define  IDMA_2D_INT_FO_EOI_INT_FO_REPLACE_VAL(reg,val) (((reg) & ~IDMA_2D_INT_FO_EOI_INT_FO_MASK) | (((uint32_t)val) << IDMA_2D_INT_FO_EOI_INT_FO_SHIFT))

#define  IDMA_2D_INT_FO_FIN_INT_FO_MASK 0x2
#define  IDMA_2D_INT_FO_FIN_INT_FO_SHIFT 1
#define  IDMA_2D_INT_FO_FIN_INT_FO_MASK_SHIFT(reg) (((reg) & IDMA_2D_INT_FO_FIN_INT_FO_MASK) >> IDMA_2D_INT_FO_FIN_INT_FO_SHIFT)
#define  IDMA_2D_INT_FO_FIN_INT_FO_REPLACE_VAL(reg,val) (((reg) & ~IDMA_2D_INT_FO_FIN_INT_FO_MASK) | (((uint32_t)val) << IDMA_2D_INT_FO_FIN_INT_FO_SHIFT))

#define  IDMA_2D_INT_FO_WHO_INT_FO_MASK 0x1
#define  IDMA_2D_INT_FO_WHO_INT_FO_SHIFT 0
#define  IDMA_2D_INT_FO_WHO_INT_FO_MASK_SHIFT(reg) (((reg) & IDMA_2D_INT_FO_WHO_INT_FO_MASK) >> IDMA_2D_INT_FO_WHO_INT_FO_SHIFT)
#define  IDMA_2D_INT_FO_WHO_INT_FO_REPLACE_VAL(reg,val) (((reg) & ~IDMA_2D_INT_FO_WHO_INT_FO_MASK) | (((uint32_t)val) << IDMA_2D_INT_FO_WHO_INT_FO_SHIFT))

//====================================================================
//Register: Descriptor Write Register (desc_write)
//====================================================================

#define  IDMA_2D_DESC_WRITE_DESC_MASK 0xffffffff
#define  IDMA_2D_DESC_WRITE_DESC_SHIFT 0
#define  IDMA_2D_DESC_WRITE_DESC_MASK_SHIFT(reg) (((reg) & IDMA_2D_DESC_WRITE_DESC_MASK) >> IDMA_2D_DESC_WRITE_DESC_SHIFT)
#define  IDMA_2D_DESC_WRITE_DESC_REPLACE_VAL(reg,val) (((reg) & ~IDMA_2D_DESC_WRITE_DESC_MASK) | (((uint32_t)val) << IDMA_2D_DESC_WRITE_DESC_SHIFT))

//====================================================================
//Register: Descriptor Read Register (desc_read)
//====================================================================

#define  IDMA_2D_DESC_READ_DESC_MASK 0xffffffff
#define  IDMA_2D_DESC_READ_DESC_SHIFT 0
#define  IDMA_2D_DESC_READ_DESC_MASK_SHIFT(reg) (((reg) & IDMA_2D_DESC_READ_DESC_MASK) >> IDMA_2D_DESC_READ_DESC_SHIFT)
#define  IDMA_2D_DESC_READ_DESC_REPLACE_VAL(reg,val) (((reg) & ~IDMA_2D_DESC_READ_DESC_MASK) | (((uint32_t)val) << IDMA_2D_DESC_READ_DESC_SHIFT))

//====================================================================
//Register: Descriptor Transfer Length Register (xfer_length)
//====================================================================

#define  IDMA_2D_XFER_LENGTH_LEN_MASK 0xffffffff
#define  IDMA_2D_XFER_LENGTH_LEN_SHIFT 0
#define  IDMA_2D_XFER_LENGTH_LEN_MASK_SHIFT(reg) (((reg) & IDMA_2D_XFER_LENGTH_LEN_MASK) >> IDMA_2D_XFER_LENGTH_LEN_SHIFT)
#define  IDMA_2D_XFER_LENGTH_LEN_REPLACE_VAL(reg,val) (((reg) & ~IDMA_2D_XFER_LENGTH_LEN_MASK) | (((uint32_t)val) << IDMA_2D_XFER_LENGTH_LEN_SHIFT))

//====================================================================
//Register: Descriptor Transfer Address Register (xfer_addr)
//====================================================================

#define  IDMA_2D_XFER_ADDR_ADDR_MASK 0xffffffff
#define  IDMA_2D_XFER_ADDR_ADDR_SHIFT 0
#define  IDMA_2D_XFER_ADDR_ADDR_MASK_SHIFT(reg) (((reg) & IDMA_2D_XFER_ADDR_ADDR_MASK) >> IDMA_2D_XFER_ADDR_ADDR_SHIFT)
#define  IDMA_2D_XFER_ADDR_ADDR_REPLACE_VAL(reg,val) (((reg) & ~IDMA_2D_XFER_ADDR_ADDR_MASK) | (((uint32_t)val) << IDMA_2D_XFER_ADDR_ADDR_SHIFT))

//====================================================================
//Register: Descriptor Control Word Register (ctrl_word)
//====================================================================

#define  IDMA_2D_CTRL_WORD_CTRL_WORD_MASK 0xffffffff
#define  IDMA_2D_CTRL_WORD_CTRL_WORD_SHIFT 0
#define  IDMA_2D_CTRL_WORD_CTRL_WORD_MASK_SHIFT(reg) (((reg) & IDMA_2D_CTRL_WORD_CTRL_WORD_MASK) >> IDMA_2D_CTRL_WORD_CTRL_WORD_SHIFT)
#define  IDMA_2D_CTRL_WORD_CTRL_WORD_REPLACE_VAL(reg,val) (((reg) & ~IDMA_2D_CTRL_WORD_CTRL_WORD_MASK) | (((uint32_t)val) << IDMA_2D_CTRL_WORD_CTRL_WORD_SHIFT))

//====================================================================
//Register: Soft Reset register (reset)
//====================================================================

#define  IDMA_2D_RESET_RESERVED1_MASK 0xfffffffe
#define  IDMA_2D_RESET_RESERVED1_SHIFT 1
#define  IDMA_2D_RESET_RESERVED1_MASK_SHIFT(reg) (((reg) & IDMA_2D_RESET_RESERVED1_MASK) >> IDMA_2D_RESET_RESERVED1_SHIFT)
#define  IDMA_2D_RESET_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IDMA_2D_RESET_RESERVED1_MASK) | (((uint32_t)val) << IDMA_2D_RESET_RESERVED1_SHIFT))

#define  IDMA_2D_RESET_SOFT_RESET_MASK 0x1
#define  IDMA_2D_RESET_SOFT_RESET_SHIFT 0
#define  IDMA_2D_RESET_SOFT_RESET_MASK_SHIFT(reg) (((reg) & IDMA_2D_RESET_SOFT_RESET_MASK) >> IDMA_2D_RESET_SOFT_RESET_SHIFT)
#define  IDMA_2D_RESET_SOFT_RESET_REPLACE_VAL(reg,val) (((reg) & ~IDMA_2D_RESET_SOFT_RESET_MASK) | (((uint32_t)val) << IDMA_2D_RESET_SOFT_RESET_SHIFT))

//====================================================================
//Register: IP Tagging Revision 0 (REV0)
/** \brief Provide means for firmware to read IP tagging information.
      This register of particular interest to firmware.*/
//====================================================================

#define  IDMA_2D_REV0_MAJ_MASK 0xffff0000
#define  IDMA_2D_REV0_MAJ_SHIFT 16
#define  IDMA_2D_REV0_MAJ_MASK_SHIFT(reg) (((reg) & IDMA_2D_REV0_MAJ_MASK) >> IDMA_2D_REV0_MAJ_SHIFT)
#define  IDMA_2D_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~IDMA_2D_REV0_MAJ_MASK) | (((uint32_t)val) << IDMA_2D_REV0_MAJ_SHIFT))

#define  IDMA_2D_REV0_MID_MASK 0xffff
#define  IDMA_2D_REV0_MID_SHIFT 0
#define  IDMA_2D_REV0_MID_MASK_SHIFT(reg) (((reg) & IDMA_2D_REV0_MID_MASK) >> IDMA_2D_REV0_MID_SHIFT)
#define  IDMA_2D_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~IDMA_2D_REV0_MID_MASK) | (((uint32_t)val) << IDMA_2D_REV0_MID_SHIFT))

//====================================================================
//Register: IP Tagging Revision 1 (REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  IDMA_2D_REV1_RESERVED1_MASK 0xffff0000
#define  IDMA_2D_REV1_RESERVED1_SHIFT 16
#define  IDMA_2D_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & IDMA_2D_REV1_RESERVED1_MASK) >> IDMA_2D_REV1_RESERVED1_SHIFT)
#define  IDMA_2D_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IDMA_2D_REV1_RESERVED1_MASK) | (((uint32_t)val) << IDMA_2D_REV1_RESERVED1_SHIFT))

#define  IDMA_2D_REV1_CFG_MASK 0xffff
#define  IDMA_2D_REV1_CFG_SHIFT 0
#define  IDMA_2D_REV1_CFG_MASK_SHIFT(reg) (((reg) & IDMA_2D_REV1_CFG_MASK) >> IDMA_2D_REV1_CFG_SHIFT)
#define  IDMA_2D_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~IDMA_2D_REV1_CFG_MASK) | (((uint32_t)val) << IDMA_2D_REV1_CFG_SHIFT))

//====================================================================
//
//Register File: PIC PRNUDSNU Correction (PRNUDSNU)
/** \brief Register Descriptions for the PRNUDSNU Correction block (rev 0 . 2 . 3 . 0)*/
//
//====================================================================

//====================================================================
//Register: Left and Right Starting Gain Configuration Register (RLSCR)
/** \brief The value of Left Max Gain (or Right Min Gain) varies from 0 to 1.875.*/
//====================================================================

#define  PRNUDSNU_RLSCR_RESERVED1_MASK 0xff000000
#define  PRNUDSNU_RLSCR_RESERVED1_SHIFT 24
#define  PRNUDSNU_RLSCR_RESERVED1_MASK_SHIFT(reg) (((reg) & PRNUDSNU_RLSCR_RESERVED1_MASK) >> PRNUDSNU_RLSCR_RESERVED1_SHIFT)
#define  PRNUDSNU_RLSCR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PRNUDSNU_RLSCR_RESERVED1_MASK) | (((uint32_t)val) << PRNUDSNU_RLSCR_RESERVED1_SHIFT))

#define  PRNUDSNU_RLSCR_LEFTGAININTC2_MASK 0x800000
#define  PRNUDSNU_RLSCR_LEFTGAININTC2_SHIFT 23
#define  PRNUDSNU_RLSCR_LEFTGAININTC2_MASK_SHIFT(reg) (((reg) & PRNUDSNU_RLSCR_LEFTGAININTC2_MASK) >> PRNUDSNU_RLSCR_LEFTGAININTC2_SHIFT)
#define  PRNUDSNU_RLSCR_LEFTGAININTC2_REPLACE_VAL(reg,val) (((reg) & ~PRNUDSNU_RLSCR_LEFTGAININTC2_MASK) | (((uint32_t)val) << PRNUDSNU_RLSCR_LEFTGAININTC2_SHIFT))

#define  PRNUDSNU_RLSCR_LEFTGAINDECC2_MASK 0x700000
#define  PRNUDSNU_RLSCR_LEFTGAINDECC2_SHIFT 20
#define  PRNUDSNU_RLSCR_LEFTGAINDECC2_MASK_SHIFT(reg) (((reg) & PRNUDSNU_RLSCR_LEFTGAINDECC2_MASK) >> PRNUDSNU_RLSCR_LEFTGAINDECC2_SHIFT)
#define  PRNUDSNU_RLSCR_LEFTGAINDECC2_REPLACE_VAL(reg,val) (((reg) & ~PRNUDSNU_RLSCR_LEFTGAINDECC2_MASK) | (((uint32_t)val) << PRNUDSNU_RLSCR_LEFTGAINDECC2_SHIFT))

#define  PRNUDSNU_RLSCR_RIGHTGAININTC2_MASK 0x80000
#define  PRNUDSNU_RLSCR_RIGHTGAININTC2_SHIFT 19
#define  PRNUDSNU_RLSCR_RIGHTGAININTC2_MASK_SHIFT(reg) (((reg) & PRNUDSNU_RLSCR_RIGHTGAININTC2_MASK) >> PRNUDSNU_RLSCR_RIGHTGAININTC2_SHIFT)
#define  PRNUDSNU_RLSCR_RIGHTGAININTC2_REPLACE_VAL(reg,val) (((reg) & ~PRNUDSNU_RLSCR_RIGHTGAININTC2_MASK) | (((uint32_t)val) << PRNUDSNU_RLSCR_RIGHTGAININTC2_SHIFT))

#define  PRNUDSNU_RLSCR_RIGHTGAINDECC2_MASK 0x70000
#define  PRNUDSNU_RLSCR_RIGHTGAINDECC2_SHIFT 16
#define  PRNUDSNU_RLSCR_RIGHTGAINDECC2_MASK_SHIFT(reg) (((reg) & PRNUDSNU_RLSCR_RIGHTGAINDECC2_MASK) >> PRNUDSNU_RLSCR_RIGHTGAINDECC2_SHIFT)
#define  PRNUDSNU_RLSCR_RIGHTGAINDECC2_REPLACE_VAL(reg,val) (((reg) & ~PRNUDSNU_RLSCR_RIGHTGAINDECC2_MASK) | (((uint32_t)val) << PRNUDSNU_RLSCR_RIGHTGAINDECC2_SHIFT))

#define  PRNUDSNU_RLSCR_LEFTGAININTC1_MASK 0x8000
#define  PRNUDSNU_RLSCR_LEFTGAININTC1_SHIFT 15
#define  PRNUDSNU_RLSCR_LEFTGAININTC1_MASK_SHIFT(reg) (((reg) & PRNUDSNU_RLSCR_LEFTGAININTC1_MASK) >> PRNUDSNU_RLSCR_LEFTGAININTC1_SHIFT)
#define  PRNUDSNU_RLSCR_LEFTGAININTC1_REPLACE_VAL(reg,val) (((reg) & ~PRNUDSNU_RLSCR_LEFTGAININTC1_MASK) | (((uint32_t)val) << PRNUDSNU_RLSCR_LEFTGAININTC1_SHIFT))

#define  PRNUDSNU_RLSCR_LEFTGAINDECC1_MASK 0x7000
#define  PRNUDSNU_RLSCR_LEFTGAINDECC1_SHIFT 12
#define  PRNUDSNU_RLSCR_LEFTGAINDECC1_MASK_SHIFT(reg) (((reg) & PRNUDSNU_RLSCR_LEFTGAINDECC1_MASK) >> PRNUDSNU_RLSCR_LEFTGAINDECC1_SHIFT)
#define  PRNUDSNU_RLSCR_LEFTGAINDECC1_REPLACE_VAL(reg,val) (((reg) & ~PRNUDSNU_RLSCR_LEFTGAINDECC1_MASK) | (((uint32_t)val) << PRNUDSNU_RLSCR_LEFTGAINDECC1_SHIFT))

#define  PRNUDSNU_RLSCR_RIGHTGAININTC1_MASK 0x800
#define  PRNUDSNU_RLSCR_RIGHTGAININTC1_SHIFT 11
#define  PRNUDSNU_RLSCR_RIGHTGAININTC1_MASK_SHIFT(reg) (((reg) & PRNUDSNU_RLSCR_RIGHTGAININTC1_MASK) >> PRNUDSNU_RLSCR_RIGHTGAININTC1_SHIFT)
#define  PRNUDSNU_RLSCR_RIGHTGAININTC1_REPLACE_VAL(reg,val) (((reg) & ~PRNUDSNU_RLSCR_RIGHTGAININTC1_MASK) | (((uint32_t)val) << PRNUDSNU_RLSCR_RIGHTGAININTC1_SHIFT))

#define  PRNUDSNU_RLSCR_RIGHTGAINDECC1_MASK 0x700
#define  PRNUDSNU_RLSCR_RIGHTGAINDECC1_SHIFT 8
#define  PRNUDSNU_RLSCR_RIGHTGAINDECC1_MASK_SHIFT(reg) (((reg) & PRNUDSNU_RLSCR_RIGHTGAINDECC1_MASK) >> PRNUDSNU_RLSCR_RIGHTGAINDECC1_SHIFT)
#define  PRNUDSNU_RLSCR_RIGHTGAINDECC1_REPLACE_VAL(reg,val) (((reg) & ~PRNUDSNU_RLSCR_RIGHTGAINDECC1_MASK) | (((uint32_t)val) << PRNUDSNU_RLSCR_RIGHTGAINDECC1_SHIFT))

#define  PRNUDSNU_RLSCR_LEFTGAININTC0_MASK 0x80
#define  PRNUDSNU_RLSCR_LEFTGAININTC0_SHIFT 7
#define  PRNUDSNU_RLSCR_LEFTGAININTC0_MASK_SHIFT(reg) (((reg) & PRNUDSNU_RLSCR_LEFTGAININTC0_MASK) >> PRNUDSNU_RLSCR_LEFTGAININTC0_SHIFT)
#define  PRNUDSNU_RLSCR_LEFTGAININTC0_REPLACE_VAL(reg,val) (((reg) & ~PRNUDSNU_RLSCR_LEFTGAININTC0_MASK) | (((uint32_t)val) << PRNUDSNU_RLSCR_LEFTGAININTC0_SHIFT))

#define  PRNUDSNU_RLSCR_LEFTGAINDECC0_MASK 0x70
#define  PRNUDSNU_RLSCR_LEFTGAINDECC0_SHIFT 4
#define  PRNUDSNU_RLSCR_LEFTGAINDECC0_MASK_SHIFT(reg) (((reg) & PRNUDSNU_RLSCR_LEFTGAINDECC0_MASK) >> PRNUDSNU_RLSCR_LEFTGAINDECC0_SHIFT)
#define  PRNUDSNU_RLSCR_LEFTGAINDECC0_REPLACE_VAL(reg,val) (((reg) & ~PRNUDSNU_RLSCR_LEFTGAINDECC0_MASK) | (((uint32_t)val) << PRNUDSNU_RLSCR_LEFTGAINDECC0_SHIFT))

#define  PRNUDSNU_RLSCR_RIGHTGAININTC0_MASK 0x8
#define  PRNUDSNU_RLSCR_RIGHTGAININTC0_SHIFT 3
#define  PRNUDSNU_RLSCR_RIGHTGAININTC0_MASK_SHIFT(reg) (((reg) & PRNUDSNU_RLSCR_RIGHTGAININTC0_MASK) >> PRNUDSNU_RLSCR_RIGHTGAININTC0_SHIFT)
#define  PRNUDSNU_RLSCR_RIGHTGAININTC0_REPLACE_VAL(reg,val) (((reg) & ~PRNUDSNU_RLSCR_RIGHTGAININTC0_MASK) | (((uint32_t)val) << PRNUDSNU_RLSCR_RIGHTGAININTC0_SHIFT))

#define  PRNUDSNU_RLSCR_RIGHTGAINDECC0_MASK 0x7
#define  PRNUDSNU_RLSCR_RIGHTGAINDECC0_SHIFT 0
#define  PRNUDSNU_RLSCR_RIGHTGAINDECC0_MASK_SHIFT(reg) (((reg) & PRNUDSNU_RLSCR_RIGHTGAINDECC0_MASK) >> PRNUDSNU_RLSCR_RIGHTGAINDECC0_SHIFT)
#define  PRNUDSNU_RLSCR_RIGHTGAINDECC0_REPLACE_VAL(reg,val) (((reg) & ~PRNUDSNU_RLSCR_RIGHTGAINDECC0_MASK) | (((uint32_t)val) << PRNUDSNU_RLSCR_RIGHTGAINDECC0_SHIFT))

//====================================================================
//Register: Left Slope Value Configuration Register (LSVCR)
/** \brief The left slope value is varies from 0 to (2^8 - 1)/2^14 or 0 to 1/64 or 0 to 0.015625.*/
//====================================================================

#define  PRNUDSNU_LSVCR_RESERVED1_MASK 0xff000000
#define  PRNUDSNU_LSVCR_RESERVED1_SHIFT 24
#define  PRNUDSNU_LSVCR_RESERVED1_MASK_SHIFT(reg) (((reg) & PRNUDSNU_LSVCR_RESERVED1_MASK) >> PRNUDSNU_LSVCR_RESERVED1_SHIFT)
#define  PRNUDSNU_LSVCR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PRNUDSNU_LSVCR_RESERVED1_MASK) | (((uint32_t)val) << PRNUDSNU_LSVCR_RESERVED1_SHIFT))

#define  PRNUDSNU_LSVCR_LEFTSLOPEC2_MASK 0xff0000
#define  PRNUDSNU_LSVCR_LEFTSLOPEC2_SHIFT 16
#define  PRNUDSNU_LSVCR_LEFTSLOPEC2_MASK_SHIFT(reg) (((reg) & PRNUDSNU_LSVCR_LEFTSLOPEC2_MASK) >> PRNUDSNU_LSVCR_LEFTSLOPEC2_SHIFT)
#define  PRNUDSNU_LSVCR_LEFTSLOPEC2_REPLACE_VAL(reg,val) (((reg) & ~PRNUDSNU_LSVCR_LEFTSLOPEC2_MASK) | (((uint32_t)val) << PRNUDSNU_LSVCR_LEFTSLOPEC2_SHIFT))

#define  PRNUDSNU_LSVCR_LEFTSLOPEC1_MASK 0xff00
#define  PRNUDSNU_LSVCR_LEFTSLOPEC1_SHIFT 8
#define  PRNUDSNU_LSVCR_LEFTSLOPEC1_MASK_SHIFT(reg) (((reg) & PRNUDSNU_LSVCR_LEFTSLOPEC1_MASK) >> PRNUDSNU_LSVCR_LEFTSLOPEC1_SHIFT)
#define  PRNUDSNU_LSVCR_LEFTSLOPEC1_REPLACE_VAL(reg,val) (((reg) & ~PRNUDSNU_LSVCR_LEFTSLOPEC1_MASK) | (((uint32_t)val) << PRNUDSNU_LSVCR_LEFTSLOPEC1_SHIFT))

#define  PRNUDSNU_LSVCR_LEFTSLOPEC0_MASK 0xff
#define  PRNUDSNU_LSVCR_LEFTSLOPEC0_SHIFT 0
#define  PRNUDSNU_LSVCR_LEFTSLOPEC0_MASK_SHIFT(reg) (((reg) & PRNUDSNU_LSVCR_LEFTSLOPEC0_MASK) >> PRNUDSNU_LSVCR_LEFTSLOPEC0_SHIFT)
#define  PRNUDSNU_LSVCR_LEFTSLOPEC0_REPLACE_VAL(reg,val) (((reg) & ~PRNUDSNU_LSVCR_LEFTSLOPEC0_MASK) | (((uint32_t)val) << PRNUDSNU_LSVCR_LEFTSLOPEC0_SHIFT))

//====================================================================
//Register: Left Max Pixel Configuration Register - Color0 (LMPCR0)
//====================================================================

#define  PRNUDSNU_LMPCR0_RESERVED1_MASK 0xffff0000
#define  PRNUDSNU_LMPCR0_RESERVED1_SHIFT 16
#define  PRNUDSNU_LMPCR0_RESERVED1_MASK_SHIFT(reg) (((reg) & PRNUDSNU_LMPCR0_RESERVED1_MASK) >> PRNUDSNU_LMPCR0_RESERVED1_SHIFT)
#define  PRNUDSNU_LMPCR0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PRNUDSNU_LMPCR0_RESERVED1_MASK) | (((uint32_t)val) << PRNUDSNU_LMPCR0_RESERVED1_SHIFT))

#define  PRNUDSNU_LMPCR0_LEFTCORR_MASK 0xffff
#define  PRNUDSNU_LMPCR0_LEFTCORR_SHIFT 0
#define  PRNUDSNU_LMPCR0_LEFTCORR_MASK_SHIFT(reg) (((reg) & PRNUDSNU_LMPCR0_LEFTCORR_MASK) >> PRNUDSNU_LMPCR0_LEFTCORR_SHIFT)
#define  PRNUDSNU_LMPCR0_LEFTCORR_REPLACE_VAL(reg,val) (((reg) & ~PRNUDSNU_LMPCR0_LEFTCORR_MASK) | (((uint32_t)val) << PRNUDSNU_LMPCR0_LEFTCORR_SHIFT))

//====================================================================
//Register: Left Max Pixel Configuration Register - Color1 (LMPCR1)
//====================================================================

#define  PRNUDSNU_LMPCR1_RESERVED1_MASK 0xffff0000
#define  PRNUDSNU_LMPCR1_RESERVED1_SHIFT 16
#define  PRNUDSNU_LMPCR1_RESERVED1_MASK_SHIFT(reg) (((reg) & PRNUDSNU_LMPCR1_RESERVED1_MASK) >> PRNUDSNU_LMPCR1_RESERVED1_SHIFT)
#define  PRNUDSNU_LMPCR1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PRNUDSNU_LMPCR1_RESERVED1_MASK) | (((uint32_t)val) << PRNUDSNU_LMPCR1_RESERVED1_SHIFT))

#define  PRNUDSNU_LMPCR1_LEFTCORR_MASK 0xffff
#define  PRNUDSNU_LMPCR1_LEFTCORR_SHIFT 0
#define  PRNUDSNU_LMPCR1_LEFTCORR_MASK_SHIFT(reg) (((reg) & PRNUDSNU_LMPCR1_LEFTCORR_MASK) >> PRNUDSNU_LMPCR1_LEFTCORR_SHIFT)
#define  PRNUDSNU_LMPCR1_LEFTCORR_REPLACE_VAL(reg,val) (((reg) & ~PRNUDSNU_LMPCR1_LEFTCORR_MASK) | (((uint32_t)val) << PRNUDSNU_LMPCR1_LEFTCORR_SHIFT))

//====================================================================
//Register: Left Max Pixel Configuration Register - Color2 (LMPCR2)
//====================================================================

#define  PRNUDSNU_LMPCR2_RESERVED1_MASK 0xffff0000
#define  PRNUDSNU_LMPCR2_RESERVED1_SHIFT 16
#define  PRNUDSNU_LMPCR2_RESERVED1_MASK_SHIFT(reg) (((reg) & PRNUDSNU_LMPCR2_RESERVED1_MASK) >> PRNUDSNU_LMPCR2_RESERVED1_SHIFT)
#define  PRNUDSNU_LMPCR2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PRNUDSNU_LMPCR2_RESERVED1_MASK) | (((uint32_t)val) << PRNUDSNU_LMPCR2_RESERVED1_SHIFT))

#define  PRNUDSNU_LMPCR2_LEFTCORR_MASK 0xffff
#define  PRNUDSNU_LMPCR2_LEFTCORR_SHIFT 0
#define  PRNUDSNU_LMPCR2_LEFTCORR_MASK_SHIFT(reg) (((reg) & PRNUDSNU_LMPCR2_LEFTCORR_MASK) >> PRNUDSNU_LMPCR2_LEFTCORR_SHIFT)
#define  PRNUDSNU_LMPCR2_LEFTCORR_REPLACE_VAL(reg,val) (((reg) & ~PRNUDSNU_LMPCR2_LEFTCORR_MASK) | (((uint32_t)val) << PRNUDSNU_LMPCR2_LEFTCORR_SHIFT))

//====================================================================
//Register: Right Slope Value Configuration Register (RSVCR)
/** \brief The right slope value is varies from 0 to 2^8/2^14 or 0 to 1/64 or 0 to 0.015625.*/
//====================================================================

#define  PRNUDSNU_RSVCR_RESERVED1_MASK 0xff000000
#define  PRNUDSNU_RSVCR_RESERVED1_SHIFT 24
#define  PRNUDSNU_RSVCR_RESERVED1_MASK_SHIFT(reg) (((reg) & PRNUDSNU_RSVCR_RESERVED1_MASK) >> PRNUDSNU_RSVCR_RESERVED1_SHIFT)
#define  PRNUDSNU_RSVCR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PRNUDSNU_RSVCR_RESERVED1_MASK) | (((uint32_t)val) << PRNUDSNU_RSVCR_RESERVED1_SHIFT))

#define  PRNUDSNU_RSVCR_RIGHTSLOPEC2_MASK 0xff0000
#define  PRNUDSNU_RSVCR_RIGHTSLOPEC2_SHIFT 16
#define  PRNUDSNU_RSVCR_RIGHTSLOPEC2_MASK_SHIFT(reg) (((reg) & PRNUDSNU_RSVCR_RIGHTSLOPEC2_MASK) >> PRNUDSNU_RSVCR_RIGHTSLOPEC2_SHIFT)
#define  PRNUDSNU_RSVCR_RIGHTSLOPEC2_REPLACE_VAL(reg,val) (((reg) & ~PRNUDSNU_RSVCR_RIGHTSLOPEC2_MASK) | (((uint32_t)val) << PRNUDSNU_RSVCR_RIGHTSLOPEC2_SHIFT))

#define  PRNUDSNU_RSVCR_RIGHTSLOPEC1_MASK 0xff00
#define  PRNUDSNU_RSVCR_RIGHTSLOPEC1_SHIFT 8
#define  PRNUDSNU_RSVCR_RIGHTSLOPEC1_MASK_SHIFT(reg) (((reg) & PRNUDSNU_RSVCR_RIGHTSLOPEC1_MASK) >> PRNUDSNU_RSVCR_RIGHTSLOPEC1_SHIFT)
#define  PRNUDSNU_RSVCR_RIGHTSLOPEC1_REPLACE_VAL(reg,val) (((reg) & ~PRNUDSNU_RSVCR_RIGHTSLOPEC1_MASK) | (((uint32_t)val) << PRNUDSNU_RSVCR_RIGHTSLOPEC1_SHIFT))

#define  PRNUDSNU_RSVCR_RIGHTSLOPEC0_MASK 0xff
#define  PRNUDSNU_RSVCR_RIGHTSLOPEC0_SHIFT 0
#define  PRNUDSNU_RSVCR_RIGHTSLOPEC0_MASK_SHIFT(reg) (((reg) & PRNUDSNU_RSVCR_RIGHTSLOPEC0_MASK) >> PRNUDSNU_RSVCR_RIGHTSLOPEC0_SHIFT)
#define  PRNUDSNU_RSVCR_RIGHTSLOPEC0_REPLACE_VAL(reg,val) (((reg) & ~PRNUDSNU_RSVCR_RIGHTSLOPEC0_MASK) | (((uint32_t)val) << PRNUDSNU_RSVCR_RIGHTSLOPEC0_SHIFT))

//====================================================================
//Register: Right Start pixel Configuration Register - Color0 (RSPCR0)
//====================================================================

#define  PRNUDSNU_RSPCR0_RESERVED1_MASK 0xffff0000
#define  PRNUDSNU_RSPCR0_RESERVED1_SHIFT 16
#define  PRNUDSNU_RSPCR0_RESERVED1_MASK_SHIFT(reg) (((reg) & PRNUDSNU_RSPCR0_RESERVED1_MASK) >> PRNUDSNU_RSPCR0_RESERVED1_SHIFT)
#define  PRNUDSNU_RSPCR0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PRNUDSNU_RSPCR0_RESERVED1_MASK) | (((uint32_t)val) << PRNUDSNU_RSPCR0_RESERVED1_SHIFT))

#define  PRNUDSNU_RSPCR0_RIGHTSTART_MASK 0xffff
#define  PRNUDSNU_RSPCR0_RIGHTSTART_SHIFT 0
#define  PRNUDSNU_RSPCR0_RIGHTSTART_MASK_SHIFT(reg) (((reg) & PRNUDSNU_RSPCR0_RIGHTSTART_MASK) >> PRNUDSNU_RSPCR0_RIGHTSTART_SHIFT)
#define  PRNUDSNU_RSPCR0_RIGHTSTART_REPLACE_VAL(reg,val) (((reg) & ~PRNUDSNU_RSPCR0_RIGHTSTART_MASK) | (((uint32_t)val) << PRNUDSNU_RSPCR0_RIGHTSTART_SHIFT))

//====================================================================
//Register: Right Start pixel Configuration Register - Color1 (RSPCR1)
//====================================================================

#define  PRNUDSNU_RSPCR1_RESERVED1_MASK 0xffff0000
#define  PRNUDSNU_RSPCR1_RESERVED1_SHIFT 16
#define  PRNUDSNU_RSPCR1_RESERVED1_MASK_SHIFT(reg) (((reg) & PRNUDSNU_RSPCR1_RESERVED1_MASK) >> PRNUDSNU_RSPCR1_RESERVED1_SHIFT)
#define  PRNUDSNU_RSPCR1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PRNUDSNU_RSPCR1_RESERVED1_MASK) | (((uint32_t)val) << PRNUDSNU_RSPCR1_RESERVED1_SHIFT))

#define  PRNUDSNU_RSPCR1_RIGHTSTART_MASK 0xffff
#define  PRNUDSNU_RSPCR1_RIGHTSTART_SHIFT 0
#define  PRNUDSNU_RSPCR1_RIGHTSTART_MASK_SHIFT(reg) (((reg) & PRNUDSNU_RSPCR1_RIGHTSTART_MASK) >> PRNUDSNU_RSPCR1_RIGHTSTART_SHIFT)
#define  PRNUDSNU_RSPCR1_RIGHTSTART_REPLACE_VAL(reg,val) (((reg) & ~PRNUDSNU_RSPCR1_RIGHTSTART_MASK) | (((uint32_t)val) << PRNUDSNU_RSPCR1_RIGHTSTART_SHIFT))

//====================================================================
//Register: Right Start pixel Configuration Register - Color2 (RSPCR2)
//====================================================================

#define  PRNUDSNU_RSPCR2_RESERVED1_MASK 0xffff0000
#define  PRNUDSNU_RSPCR2_RESERVED1_SHIFT 16
#define  PRNUDSNU_RSPCR2_RESERVED1_MASK_SHIFT(reg) (((reg) & PRNUDSNU_RSPCR2_RESERVED1_MASK) >> PRNUDSNU_RSPCR2_RESERVED1_SHIFT)
#define  PRNUDSNU_RSPCR2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PRNUDSNU_RSPCR2_RESERVED1_MASK) | (((uint32_t)val) << PRNUDSNU_RSPCR2_RESERVED1_SHIFT))

#define  PRNUDSNU_RSPCR2_RIGHTSTART_MASK 0xffff
#define  PRNUDSNU_RSPCR2_RIGHTSTART_SHIFT 0
#define  PRNUDSNU_RSPCR2_RIGHTSTART_MASK_SHIFT(reg) (((reg) & PRNUDSNU_RSPCR2_RIGHTSTART_MASK) >> PRNUDSNU_RSPCR2_RIGHTSTART_SHIFT)
#define  PRNUDSNU_RSPCR2_RIGHTSTART_REPLACE_VAL(reg,val) (((reg) & ~PRNUDSNU_RSPCR2_RIGHTSTART_MASK) | (((uint32_t)val) << PRNUDSNU_RSPCR2_RIGHTSTART_SHIFT))

//====================================================================
//Register: PRNU/DSNU Configuration Register1 (PDCR1)
//====================================================================

#define  PRNUDSNU_PDCR1_RESERVED1_MASK 0xfc000000
#define  PRNUDSNU_PDCR1_RESERVED1_SHIFT 26
#define  PRNUDSNU_PDCR1_RESERVED1_MASK_SHIFT(reg) (((reg) & PRNUDSNU_PDCR1_RESERVED1_MASK) >> PRNUDSNU_PDCR1_RESERVED1_SHIFT)
#define  PRNUDSNU_PDCR1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PRNUDSNU_PDCR1_RESERVED1_MASK) | (((uint32_t)val) << PRNUDSNU_PDCR1_RESERVED1_SHIFT))

#define  PRNUDSNU_PDCR1_CORRBITS_MASK 0x3800000
#define  PRNUDSNU_PDCR1_CORRBITS_SHIFT 23
#define  PRNUDSNU_PDCR1_CORRBITS_MASK_SHIFT(reg) (((reg) & PRNUDSNU_PDCR1_CORRBITS_MASK) >> PRNUDSNU_PDCR1_CORRBITS_SHIFT)
#define  PRNUDSNU_PDCR1_CORRBITS_REPLACE_VAL(reg,val) (((reg) & ~PRNUDSNU_PDCR1_CORRBITS_MASK) | (((uint32_t)val) << PRNUDSNU_PDCR1_CORRBITS_SHIFT))

#define  PRNUDSNU_PDCR1_RESERVED2_MASK 0x780000
#define  PRNUDSNU_PDCR1_RESERVED2_SHIFT 19
#define  PRNUDSNU_PDCR1_RESERVED2_MASK_SHIFT(reg) (((reg) & PRNUDSNU_PDCR1_RESERVED2_MASK) >> PRNUDSNU_PDCR1_RESERVED2_SHIFT)
#define  PRNUDSNU_PDCR1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~PRNUDSNU_PDCR1_RESERVED2_MASK) | (((uint32_t)val) << PRNUDSNU_PDCR1_RESERVED2_SHIFT))

#define  PRNUDSNU_PDCR1_ALLOCC2_MASK 0x70000
#define  PRNUDSNU_PDCR1_ALLOCC2_SHIFT 16
#define  PRNUDSNU_PDCR1_ALLOCC2_MASK_SHIFT(reg) (((reg) & PRNUDSNU_PDCR1_ALLOCC2_MASK) >> PRNUDSNU_PDCR1_ALLOCC2_SHIFT)
#define  PRNUDSNU_PDCR1_ALLOCC2_REPLACE_VAL(reg,val) (((reg) & ~PRNUDSNU_PDCR1_ALLOCC2_MASK) | (((uint32_t)val) << PRNUDSNU_PDCR1_ALLOCC2_SHIFT))

#define  PRNUDSNU_PDCR1_RESERVED3_MASK 0xf800
#define  PRNUDSNU_PDCR1_RESERVED3_SHIFT 11
#define  PRNUDSNU_PDCR1_RESERVED3_MASK_SHIFT(reg) (((reg) & PRNUDSNU_PDCR1_RESERVED3_MASK) >> PRNUDSNU_PDCR1_RESERVED3_SHIFT)
#define  PRNUDSNU_PDCR1_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~PRNUDSNU_PDCR1_RESERVED3_MASK) | (((uint32_t)val) << PRNUDSNU_PDCR1_RESERVED3_SHIFT))

#define  PRNUDSNU_PDCR1_ALLOCC1_MASK 0x700
#define  PRNUDSNU_PDCR1_ALLOCC1_SHIFT 8
#define  PRNUDSNU_PDCR1_ALLOCC1_MASK_SHIFT(reg) (((reg) & PRNUDSNU_PDCR1_ALLOCC1_MASK) >> PRNUDSNU_PDCR1_ALLOCC1_SHIFT)
#define  PRNUDSNU_PDCR1_ALLOCC1_REPLACE_VAL(reg,val) (((reg) & ~PRNUDSNU_PDCR1_ALLOCC1_MASK) | (((uint32_t)val) << PRNUDSNU_PDCR1_ALLOCC1_SHIFT))

#define  PRNUDSNU_PDCR1_RESERVED4_MASK 0xf8
#define  PRNUDSNU_PDCR1_RESERVED4_SHIFT 3
#define  PRNUDSNU_PDCR1_RESERVED4_MASK_SHIFT(reg) (((reg) & PRNUDSNU_PDCR1_RESERVED4_MASK) >> PRNUDSNU_PDCR1_RESERVED4_SHIFT)
#define  PRNUDSNU_PDCR1_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~PRNUDSNU_PDCR1_RESERVED4_MASK) | (((uint32_t)val) << PRNUDSNU_PDCR1_RESERVED4_SHIFT))

#define  PRNUDSNU_PDCR1_ALLOCC0_MASK 0x7
#define  PRNUDSNU_PDCR1_ALLOCC0_SHIFT 0
#define  PRNUDSNU_PDCR1_ALLOCC0_MASK_SHIFT(reg) (((reg) & PRNUDSNU_PDCR1_ALLOCC0_MASK) >> PRNUDSNU_PDCR1_ALLOCC0_SHIFT)
#define  PRNUDSNU_PDCR1_ALLOCC0_REPLACE_VAL(reg,val) (((reg) & ~PRNUDSNU_PDCR1_ALLOCC0_MASK) | (((uint32_t)val) << PRNUDSNU_PDCR1_ALLOCC0_SHIFT))

//====================================================================
//Register: PRNU/DSNU Configuration Register2 (PDCR2)
//====================================================================

#define  PRNUDSNU_PDCR2_RESERVED1_MASK 0xffff8000
#define  PRNUDSNU_PDCR2_RESERVED1_SHIFT 15
#define  PRNUDSNU_PDCR2_RESERVED1_MASK_SHIFT(reg) (((reg) & PRNUDSNU_PDCR2_RESERVED1_MASK) >> PRNUDSNU_PDCR2_RESERVED1_SHIFT)
#define  PRNUDSNU_PDCR2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PRNUDSNU_PDCR2_RESERVED1_MASK) | (((uint32_t)val) << PRNUDSNU_PDCR2_RESERVED1_SHIFT))

#define  PRNUDSNU_PDCR2_COEFFWIDTH_MASK 0x7000
#define  PRNUDSNU_PDCR2_COEFFWIDTH_SHIFT 12
#define  PRNUDSNU_PDCR2_COEFFWIDTH_MASK_SHIFT(reg) (((reg) & PRNUDSNU_PDCR2_COEFFWIDTH_MASK) >> PRNUDSNU_PDCR2_COEFFWIDTH_SHIFT)
#define  PRNUDSNU_PDCR2_COEFFWIDTH_REPLACE_VAL(reg,val) (((reg) & ~PRNUDSNU_PDCR2_COEFFWIDTH_MASK) | (((uint32_t)val) << PRNUDSNU_PDCR2_COEFFWIDTH_SHIFT))

#define  PRNUDSNU_PDCR2_RESERVED2_MASK 0xe00
#define  PRNUDSNU_PDCR2_RESERVED2_SHIFT 9
#define  PRNUDSNU_PDCR2_RESERVED2_MASK_SHIFT(reg) (((reg) & PRNUDSNU_PDCR2_RESERVED2_MASK) >> PRNUDSNU_PDCR2_RESERVED2_SHIFT)
#define  PRNUDSNU_PDCR2_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~PRNUDSNU_PDCR2_RESERVED2_MASK) | (((uint32_t)val) << PRNUDSNU_PDCR2_RESERVED2_SHIFT))

#define  PRNUDSNU_PDCR2_BYPASS_MASK 0x100
#define  PRNUDSNU_PDCR2_BYPASS_SHIFT 8
#define  PRNUDSNU_PDCR2_BYPASS_MASK_SHIFT(reg) (((reg) & PRNUDSNU_PDCR2_BYPASS_MASK) >> PRNUDSNU_PDCR2_BYPASS_SHIFT)
#define  PRNUDSNU_PDCR2_BYPASS_REPLACE_VAL(reg,val) (((reg) & ~PRNUDSNU_PDCR2_BYPASS_MASK) | (((uint32_t)val) << PRNUDSNU_PDCR2_BYPASS_SHIFT))

#define  PRNUDSNU_PDCR2_RESERVED3_MASK 0xe0
#define  PRNUDSNU_PDCR2_RESERVED3_SHIFT 5
#define  PRNUDSNU_PDCR2_RESERVED3_MASK_SHIFT(reg) (((reg) & PRNUDSNU_PDCR2_RESERVED3_MASK) >> PRNUDSNU_PDCR2_RESERVED3_SHIFT)
#define  PRNUDSNU_PDCR2_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~PRNUDSNU_PDCR2_RESERVED3_MASK) | (((uint32_t)val) << PRNUDSNU_PDCR2_RESERVED3_SHIFT))

#define  PRNUDSNU_PDCR2_BYPASSQUAD_MASK 0x10
#define  PRNUDSNU_PDCR2_BYPASSQUAD_SHIFT 4
#define  PRNUDSNU_PDCR2_BYPASSQUAD_MASK_SHIFT(reg) (((reg) & PRNUDSNU_PDCR2_BYPASSQUAD_MASK) >> PRNUDSNU_PDCR2_BYPASSQUAD_SHIFT)
#define  PRNUDSNU_PDCR2_BYPASSQUAD_REPLACE_VAL(reg,val) (((reg) & ~PRNUDSNU_PDCR2_BYPASSQUAD_MASK) | (((uint32_t)val) << PRNUDSNU_PDCR2_BYPASSQUAD_SHIFT))

#define  PRNUDSNU_PDCR2_BYPASSEXP_MASK 0x8
#define  PRNUDSNU_PDCR2_BYPASSEXP_SHIFT 3
#define  PRNUDSNU_PDCR2_BYPASSEXP_MASK_SHIFT(reg) (((reg) & PRNUDSNU_PDCR2_BYPASSEXP_MASK) >> PRNUDSNU_PDCR2_BYPASSEXP_SHIFT)
#define  PRNUDSNU_PDCR2_BYPASSEXP_REPLACE_VAL(reg,val) (((reg) & ~PRNUDSNU_PDCR2_BYPASSEXP_MASK) | (((uint32_t)val) << PRNUDSNU_PDCR2_BYPASSEXP_SHIFT))

#define  PRNUDSNU_PDCR2_BYPASSPRNU_MASK 0x4
#define  PRNUDSNU_PDCR2_BYPASSPRNU_SHIFT 2
#define  PRNUDSNU_PDCR2_BYPASSPRNU_MASK_SHIFT(reg) (((reg) & PRNUDSNU_PDCR2_BYPASSPRNU_MASK) >> PRNUDSNU_PDCR2_BYPASSPRNU_SHIFT)
#define  PRNUDSNU_PDCR2_BYPASSPRNU_REPLACE_VAL(reg,val) (((reg) & ~PRNUDSNU_PDCR2_BYPASSPRNU_MASK) | (((uint32_t)val) << PRNUDSNU_PDCR2_BYPASSPRNU_SHIFT))

#define  PRNUDSNU_PDCR2_BYPASSDSNU_MASK 0x2
#define  PRNUDSNU_PDCR2_BYPASSDSNU_SHIFT 1
#define  PRNUDSNU_PDCR2_BYPASSDSNU_MASK_SHIFT(reg) (((reg) & PRNUDSNU_PDCR2_BYPASSDSNU_MASK) >> PRNUDSNU_PDCR2_BYPASSDSNU_SHIFT)
#define  PRNUDSNU_PDCR2_BYPASSDSNU_REPLACE_VAL(reg,val) (((reg) & ~PRNUDSNU_PDCR2_BYPASSDSNU_MASK) | (((uint32_t)val) << PRNUDSNU_PDCR2_BYPASSDSNU_SHIFT))

#define  PRNUDSNU_PDCR2_BYPASSBADPIX_MASK 0x1
#define  PRNUDSNU_PDCR2_BYPASSBADPIX_SHIFT 0
#define  PRNUDSNU_PDCR2_BYPASSBADPIX_MASK_SHIFT(reg) (((reg) & PRNUDSNU_PDCR2_BYPASSBADPIX_MASK) >> PRNUDSNU_PDCR2_BYPASSBADPIX_SHIFT)
#define  PRNUDSNU_PDCR2_BYPASSBADPIX_REPLACE_VAL(reg,val) (((reg) & ~PRNUDSNU_PDCR2_BYPASSBADPIX_MASK) | (((uint32_t)val) << PRNUDSNU_PDCR2_BYPASSBADPIX_SHIFT))

//====================================================================
//Register: Percentage of Nominal Configuration Register (PONCR)
//====================================================================

#define  PRNUDSNU_PONCR_RESERVED1_MASK 0xffff0000
#define  PRNUDSNU_PONCR_RESERVED1_SHIFT 16
#define  PRNUDSNU_PONCR_RESERVED1_MASK_SHIFT(reg) (((reg) & PRNUDSNU_PONCR_RESERVED1_MASK) >> PRNUDSNU_PONCR_RESERVED1_SHIFT)
#define  PRNUDSNU_PONCR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PRNUDSNU_PONCR_RESERVED1_MASK) | (((uint32_t)val) << PRNUDSNU_PONCR_RESERVED1_SHIFT))

#define  PRNUDSNU_PONCR_PONN_MASK 0xe000
#define  PRNUDSNU_PONCR_PONN_SHIFT 13
#define  PRNUDSNU_PONCR_PONN_MASK_SHIFT(reg) (((reg) & PRNUDSNU_PONCR_PONN_MASK) >> PRNUDSNU_PONCR_PONN_SHIFT)
#define  PRNUDSNU_PONCR_PONN_REPLACE_VAL(reg,val) (((reg) & ~PRNUDSNU_PONCR_PONN_MASK) | (((uint32_t)val) << PRNUDSNU_PONCR_PONN_SHIFT))

#define  PRNUDSNU_PONCR_PONNORM_MASK 0x1fff
#define  PRNUDSNU_PONCR_PONNORM_SHIFT 0
#define  PRNUDSNU_PONCR_PONNORM_MASK_SHIFT(reg) (((reg) & PRNUDSNU_PONCR_PONNORM_MASK) >> PRNUDSNU_PONCR_PONNORM_SHIFT)
#define  PRNUDSNU_PONCR_PONNORM_REPLACE_VAL(reg,val) (((reg) & ~PRNUDSNU_PONCR_PONNORM_MASK) | (((uint32_t)val) << PRNUDSNU_PONCR_PONNORM_SHIFT))

//====================================================================
//Register: Quadratic Configuration (QUAD)
/** \brief This register is used to configure the quadratic correction operation.
</BR>
</BR>
The quadratic correction is performed on the linearly corrected (prnu/dsnu) pixel x:
</BR>
PixOut(x) = (Qfract * xfract + (1-Qfract)) * x = ((Q*x)/2^16 + (1 - Q/2^16)) * x.
</BR>
Where the quadratic term Q is given by:
</BR>
Q = (SF1 * Q' * L) >> 8
</BR>
L is the quadratic limiting factor given by:
</BR>
L = Min(256, (x>>4) * SF2 >> 7)
</BR>
and Q' is the shifted quadratic coefficient
</BR>
Q' = quad << q_shift*/
//====================================================================

#define  PRNUDSNU_QUAD_RESERVED1_MASK 0xff000000
#define  PRNUDSNU_QUAD_RESERVED1_SHIFT 24
#define  PRNUDSNU_QUAD_RESERVED1_MASK_SHIFT(reg) (((reg) & PRNUDSNU_QUAD_RESERVED1_MASK) >> PRNUDSNU_QUAD_RESERVED1_SHIFT)
#define  PRNUDSNU_QUAD_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PRNUDSNU_QUAD_RESERVED1_MASK) | (((uint32_t)val) << PRNUDSNU_QUAD_RESERVED1_SHIFT))

#define  PRNUDSNU_QUAD_SF2_MASK 0xff0000
#define  PRNUDSNU_QUAD_SF2_SHIFT 16
#define  PRNUDSNU_QUAD_SF2_MASK_SHIFT(reg) (((reg) & PRNUDSNU_QUAD_SF2_MASK) >> PRNUDSNU_QUAD_SF2_SHIFT)
#define  PRNUDSNU_QUAD_SF2_REPLACE_VAL(reg,val) (((reg) & ~PRNUDSNU_QUAD_SF2_MASK) | (((uint32_t)val) << PRNUDSNU_QUAD_SF2_SHIFT))

#define  PRNUDSNU_QUAD_SF1_MASK 0xff00
#define  PRNUDSNU_QUAD_SF1_SHIFT 8
#define  PRNUDSNU_QUAD_SF1_MASK_SHIFT(reg) (((reg) & PRNUDSNU_QUAD_SF1_MASK) >> PRNUDSNU_QUAD_SF1_SHIFT)
#define  PRNUDSNU_QUAD_SF1_REPLACE_VAL(reg,val) (((reg) & ~PRNUDSNU_QUAD_SF1_MASK) | (((uint32_t)val) << PRNUDSNU_QUAD_SF1_SHIFT))

#define  PRNUDSNU_QUAD_RESERVED2_MASK 0xf8
#define  PRNUDSNU_QUAD_RESERVED2_SHIFT 3
#define  PRNUDSNU_QUAD_RESERVED2_MASK_SHIFT(reg) (((reg) & PRNUDSNU_QUAD_RESERVED2_MASK) >> PRNUDSNU_QUAD_RESERVED2_SHIFT)
#define  PRNUDSNU_QUAD_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~PRNUDSNU_QUAD_RESERVED2_MASK) | (((uint32_t)val) << PRNUDSNU_QUAD_RESERVED2_SHIFT))

#define  PRNUDSNU_QUAD_Q_SHIFT_MASK 0x7
#define  PRNUDSNU_QUAD_Q_SHIFT_SHIFT 0
#define  PRNUDSNU_QUAD_Q_SHIFT_MASK_SHIFT(reg) (((reg) & PRNUDSNU_QUAD_Q_SHIFT_MASK) >> PRNUDSNU_QUAD_Q_SHIFT_SHIFT)
#define  PRNUDSNU_QUAD_Q_SHIFT_REPLACE_VAL(reg,val) (((reg) & ~PRNUDSNU_QUAD_Q_SHIFT_MASK) | (((uint32_t)val) << PRNUDSNU_QUAD_Q_SHIFT_SHIFT))

//====================================================================
//Register: DSNU Offset Register (Instance 1 of 3) (DOFF0)
/** \brief  (Instance 1 of 3)*/
//====================================================================

#define  PRNUDSNU_DOFF0_RESERVED1_MASK 0xffffc000
#define  PRNUDSNU_DOFF0_RESERVED1_SHIFT 14
#define  PRNUDSNU_DOFF0_RESERVED1_MASK_SHIFT(reg) (((reg) & PRNUDSNU_DOFF0_RESERVED1_MASK) >> PRNUDSNU_DOFF0_RESERVED1_SHIFT)
#define  PRNUDSNU_DOFF0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PRNUDSNU_DOFF0_RESERVED1_MASK) | (((uint32_t)val) << PRNUDSNU_DOFF0_RESERVED1_SHIFT))

#define  PRNUDSNU_DOFF0_OFFSET_MASK 0x3fff
#define  PRNUDSNU_DOFF0_OFFSET_SHIFT 0
#define  PRNUDSNU_DOFF0_OFFSET_MASK_SHIFT(reg) (((reg) & PRNUDSNU_DOFF0_OFFSET_MASK) >> PRNUDSNU_DOFF0_OFFSET_SHIFT)
#define  PRNUDSNU_DOFF0_OFFSET_REPLACE_VAL(reg,val) (((reg) & ~PRNUDSNU_DOFF0_OFFSET_MASK) | (((uint32_t)val) << PRNUDSNU_DOFF0_OFFSET_SHIFT))

//====================================================================
//Register: DSNU Offset Register (Instance 2 of 3) (DOFF1)
/** \brief  (Instance 2 of 3)*/
//====================================================================

#define  PRNUDSNU_DOFF1_RESERVED1_MASK 0xffffc000
#define  PRNUDSNU_DOFF1_RESERVED1_SHIFT 14
#define  PRNUDSNU_DOFF1_RESERVED1_MASK_SHIFT(reg) (((reg) & PRNUDSNU_DOFF1_RESERVED1_MASK) >> PRNUDSNU_DOFF1_RESERVED1_SHIFT)
#define  PRNUDSNU_DOFF1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PRNUDSNU_DOFF1_RESERVED1_MASK) | (((uint32_t)val) << PRNUDSNU_DOFF1_RESERVED1_SHIFT))

#define  PRNUDSNU_DOFF1_OFFSET_MASK 0x3fff
#define  PRNUDSNU_DOFF1_OFFSET_SHIFT 0
#define  PRNUDSNU_DOFF1_OFFSET_MASK_SHIFT(reg) (((reg) & PRNUDSNU_DOFF1_OFFSET_MASK) >> PRNUDSNU_DOFF1_OFFSET_SHIFT)
#define  PRNUDSNU_DOFF1_OFFSET_REPLACE_VAL(reg,val) (((reg) & ~PRNUDSNU_DOFF1_OFFSET_MASK) | (((uint32_t)val) << PRNUDSNU_DOFF1_OFFSET_SHIFT))

//====================================================================
//Register: DSNU Offset Register (Instance 3 of 3) (DOFF2)
/** \brief  (Instance 3 of 3)*/
//====================================================================

#define  PRNUDSNU_DOFF2_RESERVED1_MASK 0xffffc000
#define  PRNUDSNU_DOFF2_RESERVED1_SHIFT 14
#define  PRNUDSNU_DOFF2_RESERVED1_MASK_SHIFT(reg) (((reg) & PRNUDSNU_DOFF2_RESERVED1_MASK) >> PRNUDSNU_DOFF2_RESERVED1_SHIFT)
#define  PRNUDSNU_DOFF2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PRNUDSNU_DOFF2_RESERVED1_MASK) | (((uint32_t)val) << PRNUDSNU_DOFF2_RESERVED1_SHIFT))

#define  PRNUDSNU_DOFF2_OFFSET_MASK 0x3fff
#define  PRNUDSNU_DOFF2_OFFSET_SHIFT 0
#define  PRNUDSNU_DOFF2_OFFSET_MASK_SHIFT(reg) (((reg) & PRNUDSNU_DOFF2_OFFSET_MASK) >> PRNUDSNU_DOFF2_OFFSET_SHIFT)
#define  PRNUDSNU_DOFF2_OFFSET_REPLACE_VAL(reg,val) (((reg) & ~PRNUDSNU_DOFF2_OFFSET_MASK) | (((uint32_t)val) << PRNUDSNU_DOFF2_OFFSET_SHIFT))

//====================================================================
//Register: DSNU Mult/Scale Register (Instance 1 of 3) (DMULT0)
/** \brief  (Instance 1 of 3)*/
//====================================================================

#define  PRNUDSNU_DMULT0_RESERVED1_MASK 0xfff00000
#define  PRNUDSNU_DMULT0_RESERVED1_SHIFT 20
#define  PRNUDSNU_DMULT0_RESERVED1_MASK_SHIFT(reg) (((reg) & PRNUDSNU_DMULT0_RESERVED1_MASK) >> PRNUDSNU_DMULT0_RESERVED1_SHIFT)
#define  PRNUDSNU_DMULT0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PRNUDSNU_DMULT0_RESERVED1_MASK) | (((uint32_t)val) << PRNUDSNU_DMULT0_RESERVED1_SHIFT))

#define  PRNUDSNU_DMULT0_SCALE_MASK 0xf0000
#define  PRNUDSNU_DMULT0_SCALE_SHIFT 16
#define  PRNUDSNU_DMULT0_SCALE_MASK_SHIFT(reg) (((reg) & PRNUDSNU_DMULT0_SCALE_MASK) >> PRNUDSNU_DMULT0_SCALE_SHIFT)
#define  PRNUDSNU_DMULT0_SCALE_REPLACE_VAL(reg,val) (((reg) & ~PRNUDSNU_DMULT0_SCALE_MASK) | (((uint32_t)val) << PRNUDSNU_DMULT0_SCALE_SHIFT))

#define  PRNUDSNU_DMULT0_MULT_MASK 0xffff
#define  PRNUDSNU_DMULT0_MULT_SHIFT 0
#define  PRNUDSNU_DMULT0_MULT_MASK_SHIFT(reg) (((reg) & PRNUDSNU_DMULT0_MULT_MASK) >> PRNUDSNU_DMULT0_MULT_SHIFT)
#define  PRNUDSNU_DMULT0_MULT_REPLACE_VAL(reg,val) (((reg) & ~PRNUDSNU_DMULT0_MULT_MASK) | (((uint32_t)val) << PRNUDSNU_DMULT0_MULT_SHIFT))

//====================================================================
//Register: DSNU Mult/Scale Register (Instance 2 of 3) (DMULT1)
/** \brief  (Instance 2 of 3)*/
//====================================================================

#define  PRNUDSNU_DMULT1_RESERVED1_MASK 0xfff00000
#define  PRNUDSNU_DMULT1_RESERVED1_SHIFT 20
#define  PRNUDSNU_DMULT1_RESERVED1_MASK_SHIFT(reg) (((reg) & PRNUDSNU_DMULT1_RESERVED1_MASK) >> PRNUDSNU_DMULT1_RESERVED1_SHIFT)
#define  PRNUDSNU_DMULT1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PRNUDSNU_DMULT1_RESERVED1_MASK) | (((uint32_t)val) << PRNUDSNU_DMULT1_RESERVED1_SHIFT))

#define  PRNUDSNU_DMULT1_SCALE_MASK 0xf0000
#define  PRNUDSNU_DMULT1_SCALE_SHIFT 16
#define  PRNUDSNU_DMULT1_SCALE_MASK_SHIFT(reg) (((reg) & PRNUDSNU_DMULT1_SCALE_MASK) >> PRNUDSNU_DMULT1_SCALE_SHIFT)
#define  PRNUDSNU_DMULT1_SCALE_REPLACE_VAL(reg,val) (((reg) & ~PRNUDSNU_DMULT1_SCALE_MASK) | (((uint32_t)val) << PRNUDSNU_DMULT1_SCALE_SHIFT))

#define  PRNUDSNU_DMULT1_MULT_MASK 0xffff
#define  PRNUDSNU_DMULT1_MULT_SHIFT 0
#define  PRNUDSNU_DMULT1_MULT_MASK_SHIFT(reg) (((reg) & PRNUDSNU_DMULT1_MULT_MASK) >> PRNUDSNU_DMULT1_MULT_SHIFT)
#define  PRNUDSNU_DMULT1_MULT_REPLACE_VAL(reg,val) (((reg) & ~PRNUDSNU_DMULT1_MULT_MASK) | (((uint32_t)val) << PRNUDSNU_DMULT1_MULT_SHIFT))

//====================================================================
//Register: DSNU Mult/Scale Register (Instance 3 of 3) (DMULT2)
/** \brief  (Instance 3 of 3)*/
//====================================================================

#define  PRNUDSNU_DMULT2_RESERVED1_MASK 0xfff00000
#define  PRNUDSNU_DMULT2_RESERVED1_SHIFT 20
#define  PRNUDSNU_DMULT2_RESERVED1_MASK_SHIFT(reg) (((reg) & PRNUDSNU_DMULT2_RESERVED1_MASK) >> PRNUDSNU_DMULT2_RESERVED1_SHIFT)
#define  PRNUDSNU_DMULT2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PRNUDSNU_DMULT2_RESERVED1_MASK) | (((uint32_t)val) << PRNUDSNU_DMULT2_RESERVED1_SHIFT))

#define  PRNUDSNU_DMULT2_SCALE_MASK 0xf0000
#define  PRNUDSNU_DMULT2_SCALE_SHIFT 16
#define  PRNUDSNU_DMULT2_SCALE_MASK_SHIFT(reg) (((reg) & PRNUDSNU_DMULT2_SCALE_MASK) >> PRNUDSNU_DMULT2_SCALE_SHIFT)
#define  PRNUDSNU_DMULT2_SCALE_REPLACE_VAL(reg,val) (((reg) & ~PRNUDSNU_DMULT2_SCALE_MASK) | (((uint32_t)val) << PRNUDSNU_DMULT2_SCALE_SHIFT))

#define  PRNUDSNU_DMULT2_MULT_MASK 0xffff
#define  PRNUDSNU_DMULT2_MULT_SHIFT 0
#define  PRNUDSNU_DMULT2_MULT_MASK_SHIFT(reg) (((reg) & PRNUDSNU_DMULT2_MULT_MASK) >> PRNUDSNU_DMULT2_MULT_SHIFT)
#define  PRNUDSNU_DMULT2_MULT_REPLACE_VAL(reg,val) (((reg) & ~PRNUDSNU_DMULT2_MULT_MASK) | (((uint32_t)val) << PRNUDSNU_DMULT2_MULT_SHIFT))

//====================================================================
//Register: PRNU Offset Register (Instance 1 of 3) (POFF0)
/** \brief  (Instance 1 of 3)*/
//====================================================================

#define  PRNUDSNU_POFF0_RESERVED1_MASK 0xffff0000
#define  PRNUDSNU_POFF0_RESERVED1_SHIFT 16
#define  PRNUDSNU_POFF0_RESERVED1_MASK_SHIFT(reg) (((reg) & PRNUDSNU_POFF0_RESERVED1_MASK) >> PRNUDSNU_POFF0_RESERVED1_SHIFT)
#define  PRNUDSNU_POFF0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PRNUDSNU_POFF0_RESERVED1_MASK) | (((uint32_t)val) << PRNUDSNU_POFF0_RESERVED1_SHIFT))

#define  PRNUDSNU_POFF0_OFFSET_MASK 0xffff
#define  PRNUDSNU_POFF0_OFFSET_SHIFT 0
#define  PRNUDSNU_POFF0_OFFSET_MASK_SHIFT(reg) (((reg) & PRNUDSNU_POFF0_OFFSET_MASK) >> PRNUDSNU_POFF0_OFFSET_SHIFT)
#define  PRNUDSNU_POFF0_OFFSET_REPLACE_VAL(reg,val) (((reg) & ~PRNUDSNU_POFF0_OFFSET_MASK) | (((uint32_t)val) << PRNUDSNU_POFF0_OFFSET_SHIFT))

//====================================================================
//Register: PRNU Offset Register (Instance 2 of 3) (POFF1)
/** \brief  (Instance 2 of 3)*/
//====================================================================

#define  PRNUDSNU_POFF1_RESERVED1_MASK 0xffff0000
#define  PRNUDSNU_POFF1_RESERVED1_SHIFT 16
#define  PRNUDSNU_POFF1_RESERVED1_MASK_SHIFT(reg) (((reg) & PRNUDSNU_POFF1_RESERVED1_MASK) >> PRNUDSNU_POFF1_RESERVED1_SHIFT)
#define  PRNUDSNU_POFF1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PRNUDSNU_POFF1_RESERVED1_MASK) | (((uint32_t)val) << PRNUDSNU_POFF1_RESERVED1_SHIFT))

#define  PRNUDSNU_POFF1_OFFSET_MASK 0xffff
#define  PRNUDSNU_POFF1_OFFSET_SHIFT 0
#define  PRNUDSNU_POFF1_OFFSET_MASK_SHIFT(reg) (((reg) & PRNUDSNU_POFF1_OFFSET_MASK) >> PRNUDSNU_POFF1_OFFSET_SHIFT)
#define  PRNUDSNU_POFF1_OFFSET_REPLACE_VAL(reg,val) (((reg) & ~PRNUDSNU_POFF1_OFFSET_MASK) | (((uint32_t)val) << PRNUDSNU_POFF1_OFFSET_SHIFT))

//====================================================================
//Register: PRNU Offset Register (Instance 3 of 3) (POFF2)
/** \brief  (Instance 3 of 3)*/
//====================================================================

#define  PRNUDSNU_POFF2_RESERVED1_MASK 0xffff0000
#define  PRNUDSNU_POFF2_RESERVED1_SHIFT 16
#define  PRNUDSNU_POFF2_RESERVED1_MASK_SHIFT(reg) (((reg) & PRNUDSNU_POFF2_RESERVED1_MASK) >> PRNUDSNU_POFF2_RESERVED1_SHIFT)
#define  PRNUDSNU_POFF2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PRNUDSNU_POFF2_RESERVED1_MASK) | (((uint32_t)val) << PRNUDSNU_POFF2_RESERVED1_SHIFT))

#define  PRNUDSNU_POFF2_OFFSET_MASK 0xffff
#define  PRNUDSNU_POFF2_OFFSET_SHIFT 0
#define  PRNUDSNU_POFF2_OFFSET_MASK_SHIFT(reg) (((reg) & PRNUDSNU_POFF2_OFFSET_MASK) >> PRNUDSNU_POFF2_OFFSET_SHIFT)
#define  PRNUDSNU_POFF2_OFFSET_REPLACE_VAL(reg,val) (((reg) & ~PRNUDSNU_POFF2_OFFSET_MASK) | (((uint32_t)val) << PRNUDSNU_POFF2_OFFSET_SHIFT))

//====================================================================
//Register: PRNU Mult/Scale Register (Instance 1 of 3) (PMULT0)
/** \brief  (Instance 1 of 3)*/
//====================================================================

#define  PRNUDSNU_PMULT0_RESERVED1_MASK 0xfff00000
#define  PRNUDSNU_PMULT0_RESERVED1_SHIFT 20
#define  PRNUDSNU_PMULT0_RESERVED1_MASK_SHIFT(reg) (((reg) & PRNUDSNU_PMULT0_RESERVED1_MASK) >> PRNUDSNU_PMULT0_RESERVED1_SHIFT)
#define  PRNUDSNU_PMULT0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PRNUDSNU_PMULT0_RESERVED1_MASK) | (((uint32_t)val) << PRNUDSNU_PMULT0_RESERVED1_SHIFT))

#define  PRNUDSNU_PMULT0_SCALE_MASK 0xf0000
#define  PRNUDSNU_PMULT0_SCALE_SHIFT 16
#define  PRNUDSNU_PMULT0_SCALE_MASK_SHIFT(reg) (((reg) & PRNUDSNU_PMULT0_SCALE_MASK) >> PRNUDSNU_PMULT0_SCALE_SHIFT)
#define  PRNUDSNU_PMULT0_SCALE_REPLACE_VAL(reg,val) (((reg) & ~PRNUDSNU_PMULT0_SCALE_MASK) | (((uint32_t)val) << PRNUDSNU_PMULT0_SCALE_SHIFT))

#define  PRNUDSNU_PMULT0_MULT_MASK 0xffff
#define  PRNUDSNU_PMULT0_MULT_SHIFT 0
#define  PRNUDSNU_PMULT0_MULT_MASK_SHIFT(reg) (((reg) & PRNUDSNU_PMULT0_MULT_MASK) >> PRNUDSNU_PMULT0_MULT_SHIFT)
#define  PRNUDSNU_PMULT0_MULT_REPLACE_VAL(reg,val) (((reg) & ~PRNUDSNU_PMULT0_MULT_MASK) | (((uint32_t)val) << PRNUDSNU_PMULT0_MULT_SHIFT))

//====================================================================
//Register: PRNU Mult/Scale Register (Instance 2 of 3) (PMULT1)
/** \brief  (Instance 2 of 3)*/
//====================================================================

#define  PRNUDSNU_PMULT1_RESERVED1_MASK 0xfff00000
#define  PRNUDSNU_PMULT1_RESERVED1_SHIFT 20
#define  PRNUDSNU_PMULT1_RESERVED1_MASK_SHIFT(reg) (((reg) & PRNUDSNU_PMULT1_RESERVED1_MASK) >> PRNUDSNU_PMULT1_RESERVED1_SHIFT)
#define  PRNUDSNU_PMULT1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PRNUDSNU_PMULT1_RESERVED1_MASK) | (((uint32_t)val) << PRNUDSNU_PMULT1_RESERVED1_SHIFT))

#define  PRNUDSNU_PMULT1_SCALE_MASK 0xf0000
#define  PRNUDSNU_PMULT1_SCALE_SHIFT 16
#define  PRNUDSNU_PMULT1_SCALE_MASK_SHIFT(reg) (((reg) & PRNUDSNU_PMULT1_SCALE_MASK) >> PRNUDSNU_PMULT1_SCALE_SHIFT)
#define  PRNUDSNU_PMULT1_SCALE_REPLACE_VAL(reg,val) (((reg) & ~PRNUDSNU_PMULT1_SCALE_MASK) | (((uint32_t)val) << PRNUDSNU_PMULT1_SCALE_SHIFT))

#define  PRNUDSNU_PMULT1_MULT_MASK 0xffff
#define  PRNUDSNU_PMULT1_MULT_SHIFT 0
#define  PRNUDSNU_PMULT1_MULT_MASK_SHIFT(reg) (((reg) & PRNUDSNU_PMULT1_MULT_MASK) >> PRNUDSNU_PMULT1_MULT_SHIFT)
#define  PRNUDSNU_PMULT1_MULT_REPLACE_VAL(reg,val) (((reg) & ~PRNUDSNU_PMULT1_MULT_MASK) | (((uint32_t)val) << PRNUDSNU_PMULT1_MULT_SHIFT))

//====================================================================
//Register: PRNU Mult/Scale Register (Instance 3 of 3) (PMULT2)
/** \brief  (Instance 3 of 3)*/
//====================================================================

#define  PRNUDSNU_PMULT2_RESERVED1_MASK 0xfff00000
#define  PRNUDSNU_PMULT2_RESERVED1_SHIFT 20
#define  PRNUDSNU_PMULT2_RESERVED1_MASK_SHIFT(reg) (((reg) & PRNUDSNU_PMULT2_RESERVED1_MASK) >> PRNUDSNU_PMULT2_RESERVED1_SHIFT)
#define  PRNUDSNU_PMULT2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PRNUDSNU_PMULT2_RESERVED1_MASK) | (((uint32_t)val) << PRNUDSNU_PMULT2_RESERVED1_SHIFT))

#define  PRNUDSNU_PMULT2_SCALE_MASK 0xf0000
#define  PRNUDSNU_PMULT2_SCALE_SHIFT 16
#define  PRNUDSNU_PMULT2_SCALE_MASK_SHIFT(reg) (((reg) & PRNUDSNU_PMULT2_SCALE_MASK) >> PRNUDSNU_PMULT2_SCALE_SHIFT)
#define  PRNUDSNU_PMULT2_SCALE_REPLACE_VAL(reg,val) (((reg) & ~PRNUDSNU_PMULT2_SCALE_MASK) | (((uint32_t)val) << PRNUDSNU_PMULT2_SCALE_SHIFT))

#define  PRNUDSNU_PMULT2_MULT_MASK 0xffff
#define  PRNUDSNU_PMULT2_MULT_SHIFT 0
#define  PRNUDSNU_PMULT2_MULT_MASK_SHIFT(reg) (((reg) & PRNUDSNU_PMULT2_MULT_MASK) >> PRNUDSNU_PMULT2_MULT_SHIFT)
#define  PRNUDSNU_PMULT2_MULT_REPLACE_VAL(reg,val) (((reg) & ~PRNUDSNU_PMULT2_MULT_MASK) | (((uint32_t)val) << PRNUDSNU_PMULT2_MULT_SHIFT))

//====================================================================
//Register: IP Tagging Revision 0 (REV0)
/** \brief Provide means for firmware to read IP tagging information.
      This register of particular interest to firmware.*/
//====================================================================

#define  PRNUDSNU_REV0_MAJ_MASK 0xffff0000
#define  PRNUDSNU_REV0_MAJ_SHIFT 16
#define  PRNUDSNU_REV0_MAJ_MASK_SHIFT(reg) (((reg) & PRNUDSNU_REV0_MAJ_MASK) >> PRNUDSNU_REV0_MAJ_SHIFT)
#define  PRNUDSNU_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~PRNUDSNU_REV0_MAJ_MASK) | (((uint32_t)val) << PRNUDSNU_REV0_MAJ_SHIFT))

#define  PRNUDSNU_REV0_MID_MASK 0xffff
#define  PRNUDSNU_REV0_MID_SHIFT 0
#define  PRNUDSNU_REV0_MID_MASK_SHIFT(reg) (((reg) & PRNUDSNU_REV0_MID_MASK) >> PRNUDSNU_REV0_MID_SHIFT)
#define  PRNUDSNU_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~PRNUDSNU_REV0_MID_MASK) | (((uint32_t)val) << PRNUDSNU_REV0_MID_SHIFT))

//====================================================================
//Register: IP Tagging Revision 1 (REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  PRNUDSNU_REV1_RESERVED1_MASK 0xffff0000
#define  PRNUDSNU_REV1_RESERVED1_SHIFT 16
#define  PRNUDSNU_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & PRNUDSNU_REV1_RESERVED1_MASK) >> PRNUDSNU_REV1_RESERVED1_SHIFT)
#define  PRNUDSNU_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PRNUDSNU_REV1_RESERVED1_MASK) | (((uint32_t)val) << PRNUDSNU_REV1_RESERVED1_SHIFT))

#define  PRNUDSNU_REV1_CFG_MASK 0xffff
#define  PRNUDSNU_REV1_CFG_SHIFT 0
#define  PRNUDSNU_REV1_CFG_MASK_SHIFT(reg) (((reg) & PRNUDSNU_REV1_CFG_MASK) >> PRNUDSNU_REV1_CFG_SHIFT)
#define  PRNUDSNU_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~PRNUDSNU_REV1_CFG_MASK) | (((uint32_t)val) << PRNUDSNU_REV1_CFG_SHIFT))

//====================================================================
//
//Register File: NEWMAN Horizontal Chip Gap Correction (NEWMAN)
/** \brief NEWMAN Horizontal Chip Gap Correction (rev 0 . 0 . 4 . 5)*/
//
//====================================================================

//====================================================================
//Register: NEWMAN Configuration Register (CFG)
/** \brief Overall configuration register for NEWMAN.*/
//====================================================================

#define  NEWMAN_CFG_RESERVED1_MASK 0xfffffffe
#define  NEWMAN_CFG_RESERVED1_SHIFT 1
#define  NEWMAN_CFG_RESERVED1_MASK_SHIFT(reg) (((reg) & NEWMAN_CFG_RESERVED1_MASK) >> NEWMAN_CFG_RESERVED1_SHIFT)
#define  NEWMAN_CFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~NEWMAN_CFG_RESERVED1_MASK) | (((uint32_t)val) << NEWMAN_CFG_RESERVED1_SHIFT))

#define  NEWMAN_CFG_BYPASS_MASK 0x1
#define  NEWMAN_CFG_BYPASS_SHIFT 0
#define  NEWMAN_CFG_BYPASS_MASK_SHIFT(reg) (((reg) & NEWMAN_CFG_BYPASS_MASK) >> NEWMAN_CFG_BYPASS_SHIFT)
#define  NEWMAN_CFG_BYPASS_REPLACE_VAL(reg,val) (((reg) & ~NEWMAN_CFG_BYPASS_MASK) | (((uint32_t)val) << NEWMAN_CFG_BYPASS_SHIFT))

//====================================================================
//Register: NEWMAN Location Register (LOCAT)
/** \brief Controls the chip gap locations via a initial chip gap and a gap to gap spacing.*/
//====================================================================

#define  NEWMAN_LOCAT_WIDTH_MASK 0xffff0000
#define  NEWMAN_LOCAT_WIDTH_SHIFT 16
#define  NEWMAN_LOCAT_WIDTH_MASK_SHIFT(reg) (((reg) & NEWMAN_LOCAT_WIDTH_MASK) >> NEWMAN_LOCAT_WIDTH_SHIFT)
#define  NEWMAN_LOCAT_WIDTH_REPLACE_VAL(reg,val) (((reg) & ~NEWMAN_LOCAT_WIDTH_MASK) | (((uint32_t)val) << NEWMAN_LOCAT_WIDTH_SHIFT))

#define  NEWMAN_LOCAT_START_MASK 0xffff
#define  NEWMAN_LOCAT_START_SHIFT 0
#define  NEWMAN_LOCAT_START_MASK_SHIFT(reg) (((reg) & NEWMAN_LOCAT_START_MASK) >> NEWMAN_LOCAT_START_SHIFT)
#define  NEWMAN_LOCAT_START_REPLACE_VAL(reg,val) (((reg) & ~NEWMAN_LOCAT_START_MASK) | (((uint32_t)val) << NEWMAN_LOCAT_START_SHIFT))

//====================================================================
//Register: NEWMAN Insertion Register 0/3 (INSERT0)
/** \brief Number of pixels to insert for the gaps 0-3. There are up to 16 gaps which requires four registers.*/
//====================================================================

#define  NEWMAN_INSERT0_RESERVED1_MASK 0xf0000000
#define  NEWMAN_INSERT0_RESERVED1_SHIFT 28
#define  NEWMAN_INSERT0_RESERVED1_MASK_SHIFT(reg) (((reg) & NEWMAN_INSERT0_RESERVED1_MASK) >> NEWMAN_INSERT0_RESERVED1_SHIFT)
#define  NEWMAN_INSERT0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~NEWMAN_INSERT0_RESERVED1_MASK) | (((uint32_t)val) << NEWMAN_INSERT0_RESERVED1_SHIFT))

#define  NEWMAN_INSERT0_GAP3_MASK 0xf000000
#define  NEWMAN_INSERT0_GAP3_SHIFT 24
#define  NEWMAN_INSERT0_GAP3_MASK_SHIFT(reg) (((reg) & NEWMAN_INSERT0_GAP3_MASK) >> NEWMAN_INSERT0_GAP3_SHIFT)
#define  NEWMAN_INSERT0_GAP3_REPLACE_VAL(reg,val) (((reg) & ~NEWMAN_INSERT0_GAP3_MASK) | (((uint32_t)val) << NEWMAN_INSERT0_GAP3_SHIFT))

#define  NEWMAN_INSERT0_RESERVED2_MASK 0xf00000
#define  NEWMAN_INSERT0_RESERVED2_SHIFT 20
#define  NEWMAN_INSERT0_RESERVED2_MASK_SHIFT(reg) (((reg) & NEWMAN_INSERT0_RESERVED2_MASK) >> NEWMAN_INSERT0_RESERVED2_SHIFT)
#define  NEWMAN_INSERT0_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~NEWMAN_INSERT0_RESERVED2_MASK) | (((uint32_t)val) << NEWMAN_INSERT0_RESERVED2_SHIFT))

#define  NEWMAN_INSERT0_GAP2_MASK 0xf0000
#define  NEWMAN_INSERT0_GAP2_SHIFT 16
#define  NEWMAN_INSERT0_GAP2_MASK_SHIFT(reg) (((reg) & NEWMAN_INSERT0_GAP2_MASK) >> NEWMAN_INSERT0_GAP2_SHIFT)
#define  NEWMAN_INSERT0_GAP2_REPLACE_VAL(reg,val) (((reg) & ~NEWMAN_INSERT0_GAP2_MASK) | (((uint32_t)val) << NEWMAN_INSERT0_GAP2_SHIFT))

#define  NEWMAN_INSERT0_RESERVED3_MASK 0xf000
#define  NEWMAN_INSERT0_RESERVED3_SHIFT 12
#define  NEWMAN_INSERT0_RESERVED3_MASK_SHIFT(reg) (((reg) & NEWMAN_INSERT0_RESERVED3_MASK) >> NEWMAN_INSERT0_RESERVED3_SHIFT)
#define  NEWMAN_INSERT0_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~NEWMAN_INSERT0_RESERVED3_MASK) | (((uint32_t)val) << NEWMAN_INSERT0_RESERVED3_SHIFT))

#define  NEWMAN_INSERT0_GAP1_MASK 0xf00
#define  NEWMAN_INSERT0_GAP1_SHIFT 8
#define  NEWMAN_INSERT0_GAP1_MASK_SHIFT(reg) (((reg) & NEWMAN_INSERT0_GAP1_MASK) >> NEWMAN_INSERT0_GAP1_SHIFT)
#define  NEWMAN_INSERT0_GAP1_REPLACE_VAL(reg,val) (((reg) & ~NEWMAN_INSERT0_GAP1_MASK) | (((uint32_t)val) << NEWMAN_INSERT0_GAP1_SHIFT))

#define  NEWMAN_INSERT0_RESERVED4_MASK 0xf0
#define  NEWMAN_INSERT0_RESERVED4_SHIFT 4
#define  NEWMAN_INSERT0_RESERVED4_MASK_SHIFT(reg) (((reg) & NEWMAN_INSERT0_RESERVED4_MASK) >> NEWMAN_INSERT0_RESERVED4_SHIFT)
#define  NEWMAN_INSERT0_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~NEWMAN_INSERT0_RESERVED4_MASK) | (((uint32_t)val) << NEWMAN_INSERT0_RESERVED4_SHIFT))

#define  NEWMAN_INSERT0_GAP0_MASK 0xf
#define  NEWMAN_INSERT0_GAP0_SHIFT 0
#define  NEWMAN_INSERT0_GAP0_MASK_SHIFT(reg) (((reg) & NEWMAN_INSERT0_GAP0_MASK) >> NEWMAN_INSERT0_GAP0_SHIFT)
#define  NEWMAN_INSERT0_GAP0_REPLACE_VAL(reg,val) (((reg) & ~NEWMAN_INSERT0_GAP0_MASK) | (((uint32_t)val) << NEWMAN_INSERT0_GAP0_SHIFT))

//====================================================================
//Register: NEWMAN Insertion Register 0/1 (INSERT1)
/** \brief Number of pixels to insert for the gaps 4-7. There are up to 16 gaps which requires four registers.*/
//====================================================================

#define  NEWMAN_INSERT1_RESERVED1_MASK 0xf0000000
#define  NEWMAN_INSERT1_RESERVED1_SHIFT 28
#define  NEWMAN_INSERT1_RESERVED1_MASK_SHIFT(reg) (((reg) & NEWMAN_INSERT1_RESERVED1_MASK) >> NEWMAN_INSERT1_RESERVED1_SHIFT)
#define  NEWMAN_INSERT1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~NEWMAN_INSERT1_RESERVED1_MASK) | (((uint32_t)val) << NEWMAN_INSERT1_RESERVED1_SHIFT))

#define  NEWMAN_INSERT1_GAP7_MASK 0xf000000
#define  NEWMAN_INSERT1_GAP7_SHIFT 24
#define  NEWMAN_INSERT1_GAP7_MASK_SHIFT(reg) (((reg) & NEWMAN_INSERT1_GAP7_MASK) >> NEWMAN_INSERT1_GAP7_SHIFT)
#define  NEWMAN_INSERT1_GAP7_REPLACE_VAL(reg,val) (((reg) & ~NEWMAN_INSERT1_GAP7_MASK) | (((uint32_t)val) << NEWMAN_INSERT1_GAP7_SHIFT))

#define  NEWMAN_INSERT1_RESERVED2_MASK 0xf00000
#define  NEWMAN_INSERT1_RESERVED2_SHIFT 20
#define  NEWMAN_INSERT1_RESERVED2_MASK_SHIFT(reg) (((reg) & NEWMAN_INSERT1_RESERVED2_MASK) >> NEWMAN_INSERT1_RESERVED2_SHIFT)
#define  NEWMAN_INSERT1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~NEWMAN_INSERT1_RESERVED2_MASK) | (((uint32_t)val) << NEWMAN_INSERT1_RESERVED2_SHIFT))

#define  NEWMAN_INSERT1_GAP6_MASK 0xf0000
#define  NEWMAN_INSERT1_GAP6_SHIFT 16
#define  NEWMAN_INSERT1_GAP6_MASK_SHIFT(reg) (((reg) & NEWMAN_INSERT1_GAP6_MASK) >> NEWMAN_INSERT1_GAP6_SHIFT)
#define  NEWMAN_INSERT1_GAP6_REPLACE_VAL(reg,val) (((reg) & ~NEWMAN_INSERT1_GAP6_MASK) | (((uint32_t)val) << NEWMAN_INSERT1_GAP6_SHIFT))

#define  NEWMAN_INSERT1_RESERVED3_MASK 0xf000
#define  NEWMAN_INSERT1_RESERVED3_SHIFT 12
#define  NEWMAN_INSERT1_RESERVED3_MASK_SHIFT(reg) (((reg) & NEWMAN_INSERT1_RESERVED3_MASK) >> NEWMAN_INSERT1_RESERVED3_SHIFT)
#define  NEWMAN_INSERT1_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~NEWMAN_INSERT1_RESERVED3_MASK) | (((uint32_t)val) << NEWMAN_INSERT1_RESERVED3_SHIFT))

#define  NEWMAN_INSERT1_GAP5_MASK 0xf00
#define  NEWMAN_INSERT1_GAP5_SHIFT 8
#define  NEWMAN_INSERT1_GAP5_MASK_SHIFT(reg) (((reg) & NEWMAN_INSERT1_GAP5_MASK) >> NEWMAN_INSERT1_GAP5_SHIFT)
#define  NEWMAN_INSERT1_GAP5_REPLACE_VAL(reg,val) (((reg) & ~NEWMAN_INSERT1_GAP5_MASK) | (((uint32_t)val) << NEWMAN_INSERT1_GAP5_SHIFT))

#define  NEWMAN_INSERT1_RESERVED4_MASK 0xf0
#define  NEWMAN_INSERT1_RESERVED4_SHIFT 4
#define  NEWMAN_INSERT1_RESERVED4_MASK_SHIFT(reg) (((reg) & NEWMAN_INSERT1_RESERVED4_MASK) >> NEWMAN_INSERT1_RESERVED4_SHIFT)
#define  NEWMAN_INSERT1_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~NEWMAN_INSERT1_RESERVED4_MASK) | (((uint32_t)val) << NEWMAN_INSERT1_RESERVED4_SHIFT))

#define  NEWMAN_INSERT1_GAP4_MASK 0xf
#define  NEWMAN_INSERT1_GAP4_SHIFT 0
#define  NEWMAN_INSERT1_GAP4_MASK_SHIFT(reg) (((reg) & NEWMAN_INSERT1_GAP4_MASK) >> NEWMAN_INSERT1_GAP4_SHIFT)
#define  NEWMAN_INSERT1_GAP4_REPLACE_VAL(reg,val) (((reg) & ~NEWMAN_INSERT1_GAP4_MASK) | (((uint32_t)val) << NEWMAN_INSERT1_GAP4_SHIFT))

//====================================================================
//Register: NEWMAN Insertion Register 2/3 (INSERT2)
/** \brief Number of pixels to insert for the gaps 8-11. There are up to 16 gaps which requires four registers.*/
//====================================================================

#define  NEWMAN_INSERT2_RESERVED1_MASK 0xf0000000
#define  NEWMAN_INSERT2_RESERVED1_SHIFT 28
#define  NEWMAN_INSERT2_RESERVED1_MASK_SHIFT(reg) (((reg) & NEWMAN_INSERT2_RESERVED1_MASK) >> NEWMAN_INSERT2_RESERVED1_SHIFT)
#define  NEWMAN_INSERT2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~NEWMAN_INSERT2_RESERVED1_MASK) | (((uint32_t)val) << NEWMAN_INSERT2_RESERVED1_SHIFT))

#define  NEWMAN_INSERT2_GAP11_MASK 0xf000000
#define  NEWMAN_INSERT2_GAP11_SHIFT 24
#define  NEWMAN_INSERT2_GAP11_MASK_SHIFT(reg) (((reg) & NEWMAN_INSERT2_GAP11_MASK) >> NEWMAN_INSERT2_GAP11_SHIFT)
#define  NEWMAN_INSERT2_GAP11_REPLACE_VAL(reg,val) (((reg) & ~NEWMAN_INSERT2_GAP11_MASK) | (((uint32_t)val) << NEWMAN_INSERT2_GAP11_SHIFT))

#define  NEWMAN_INSERT2_RESERVED2_MASK 0xf00000
#define  NEWMAN_INSERT2_RESERVED2_SHIFT 20
#define  NEWMAN_INSERT2_RESERVED2_MASK_SHIFT(reg) (((reg) & NEWMAN_INSERT2_RESERVED2_MASK) >> NEWMAN_INSERT2_RESERVED2_SHIFT)
#define  NEWMAN_INSERT2_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~NEWMAN_INSERT2_RESERVED2_MASK) | (((uint32_t)val) << NEWMAN_INSERT2_RESERVED2_SHIFT))

#define  NEWMAN_INSERT2_GAP10_MASK 0xf0000
#define  NEWMAN_INSERT2_GAP10_SHIFT 16
#define  NEWMAN_INSERT2_GAP10_MASK_SHIFT(reg) (((reg) & NEWMAN_INSERT2_GAP10_MASK) >> NEWMAN_INSERT2_GAP10_SHIFT)
#define  NEWMAN_INSERT2_GAP10_REPLACE_VAL(reg,val) (((reg) & ~NEWMAN_INSERT2_GAP10_MASK) | (((uint32_t)val) << NEWMAN_INSERT2_GAP10_SHIFT))

#define  NEWMAN_INSERT2_RESERVED3_MASK 0xf000
#define  NEWMAN_INSERT2_RESERVED3_SHIFT 12
#define  NEWMAN_INSERT2_RESERVED3_MASK_SHIFT(reg) (((reg) & NEWMAN_INSERT2_RESERVED3_MASK) >> NEWMAN_INSERT2_RESERVED3_SHIFT)
#define  NEWMAN_INSERT2_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~NEWMAN_INSERT2_RESERVED3_MASK) | (((uint32_t)val) << NEWMAN_INSERT2_RESERVED3_SHIFT))

#define  NEWMAN_INSERT2_GAP9_MASK 0xf00
#define  NEWMAN_INSERT2_GAP9_SHIFT 8
#define  NEWMAN_INSERT2_GAP9_MASK_SHIFT(reg) (((reg) & NEWMAN_INSERT2_GAP9_MASK) >> NEWMAN_INSERT2_GAP9_SHIFT)
#define  NEWMAN_INSERT2_GAP9_REPLACE_VAL(reg,val) (((reg) & ~NEWMAN_INSERT2_GAP9_MASK) | (((uint32_t)val) << NEWMAN_INSERT2_GAP9_SHIFT))

#define  NEWMAN_INSERT2_RESERVED4_MASK 0xf0
#define  NEWMAN_INSERT2_RESERVED4_SHIFT 4
#define  NEWMAN_INSERT2_RESERVED4_MASK_SHIFT(reg) (((reg) & NEWMAN_INSERT2_RESERVED4_MASK) >> NEWMAN_INSERT2_RESERVED4_SHIFT)
#define  NEWMAN_INSERT2_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~NEWMAN_INSERT2_RESERVED4_MASK) | (((uint32_t)val) << NEWMAN_INSERT2_RESERVED4_SHIFT))

#define  NEWMAN_INSERT2_GAP8_MASK 0xf
#define  NEWMAN_INSERT2_GAP8_SHIFT 0
#define  NEWMAN_INSERT2_GAP8_MASK_SHIFT(reg) (((reg) & NEWMAN_INSERT2_GAP8_MASK) >> NEWMAN_INSERT2_GAP8_SHIFT)
#define  NEWMAN_INSERT2_GAP8_REPLACE_VAL(reg,val) (((reg) & ~NEWMAN_INSERT2_GAP8_MASK) | (((uint32_t)val) << NEWMAN_INSERT2_GAP8_SHIFT))

//====================================================================
//Register: NEWMAN Insertion Register 3/3 (INSERT3)
/** \brief Number of pixels to insert for the gaps 12-15. There are up to 16 gaps which requires four registers.*/
//====================================================================

#define  NEWMAN_INSERT3_RESERVED1_MASK 0xf0000000
#define  NEWMAN_INSERT3_RESERVED1_SHIFT 28
#define  NEWMAN_INSERT3_RESERVED1_MASK_SHIFT(reg) (((reg) & NEWMAN_INSERT3_RESERVED1_MASK) >> NEWMAN_INSERT3_RESERVED1_SHIFT)
#define  NEWMAN_INSERT3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~NEWMAN_INSERT3_RESERVED1_MASK) | (((uint32_t)val) << NEWMAN_INSERT3_RESERVED1_SHIFT))

#define  NEWMAN_INSERT3_GAP15_MASK 0xf000000
#define  NEWMAN_INSERT3_GAP15_SHIFT 24
#define  NEWMAN_INSERT3_GAP15_MASK_SHIFT(reg) (((reg) & NEWMAN_INSERT3_GAP15_MASK) >> NEWMAN_INSERT3_GAP15_SHIFT)
#define  NEWMAN_INSERT3_GAP15_REPLACE_VAL(reg,val) (((reg) & ~NEWMAN_INSERT3_GAP15_MASK) | (((uint32_t)val) << NEWMAN_INSERT3_GAP15_SHIFT))

#define  NEWMAN_INSERT3_RESERVED2_MASK 0xf00000
#define  NEWMAN_INSERT3_RESERVED2_SHIFT 20
#define  NEWMAN_INSERT3_RESERVED2_MASK_SHIFT(reg) (((reg) & NEWMAN_INSERT3_RESERVED2_MASK) >> NEWMAN_INSERT3_RESERVED2_SHIFT)
#define  NEWMAN_INSERT3_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~NEWMAN_INSERT3_RESERVED2_MASK) | (((uint32_t)val) << NEWMAN_INSERT3_RESERVED2_SHIFT))

#define  NEWMAN_INSERT3_GAP14_MASK 0xf0000
#define  NEWMAN_INSERT3_GAP14_SHIFT 16
#define  NEWMAN_INSERT3_GAP14_MASK_SHIFT(reg) (((reg) & NEWMAN_INSERT3_GAP14_MASK) >> NEWMAN_INSERT3_GAP14_SHIFT)
#define  NEWMAN_INSERT3_GAP14_REPLACE_VAL(reg,val) (((reg) & ~NEWMAN_INSERT3_GAP14_MASK) | (((uint32_t)val) << NEWMAN_INSERT3_GAP14_SHIFT))

#define  NEWMAN_INSERT3_RESERVED3_MASK 0xf000
#define  NEWMAN_INSERT3_RESERVED3_SHIFT 12
#define  NEWMAN_INSERT3_RESERVED3_MASK_SHIFT(reg) (((reg) & NEWMAN_INSERT3_RESERVED3_MASK) >> NEWMAN_INSERT3_RESERVED3_SHIFT)
#define  NEWMAN_INSERT3_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~NEWMAN_INSERT3_RESERVED3_MASK) | (((uint32_t)val) << NEWMAN_INSERT3_RESERVED3_SHIFT))

#define  NEWMAN_INSERT3_GAP13_MASK 0xf00
#define  NEWMAN_INSERT3_GAP13_SHIFT 8
#define  NEWMAN_INSERT3_GAP13_MASK_SHIFT(reg) (((reg) & NEWMAN_INSERT3_GAP13_MASK) >> NEWMAN_INSERT3_GAP13_SHIFT)
#define  NEWMAN_INSERT3_GAP13_REPLACE_VAL(reg,val) (((reg) & ~NEWMAN_INSERT3_GAP13_MASK) | (((uint32_t)val) << NEWMAN_INSERT3_GAP13_SHIFT))

#define  NEWMAN_INSERT3_RESERVED4_MASK 0xf0
#define  NEWMAN_INSERT3_RESERVED4_SHIFT 4
#define  NEWMAN_INSERT3_RESERVED4_MASK_SHIFT(reg) (((reg) & NEWMAN_INSERT3_RESERVED4_MASK) >> NEWMAN_INSERT3_RESERVED4_SHIFT)
#define  NEWMAN_INSERT3_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~NEWMAN_INSERT3_RESERVED4_MASK) | (((uint32_t)val) << NEWMAN_INSERT3_RESERVED4_SHIFT))

#define  NEWMAN_INSERT3_GAP12_MASK 0xf
#define  NEWMAN_INSERT3_GAP12_SHIFT 0
#define  NEWMAN_INSERT3_GAP12_MASK_SHIFT(reg) (((reg) & NEWMAN_INSERT3_GAP12_MASK) >> NEWMAN_INSERT3_GAP12_SHIFT)
#define  NEWMAN_INSERT3_GAP12_REPLACE_VAL(reg,val) (((reg) & ~NEWMAN_INSERT3_GAP12_MASK) | (((uint32_t)val) << NEWMAN_INSERT3_GAP12_SHIFT))

//====================================================================
//Register: IP Tagging Revision 0 (REV0)
/** \brief Provide means for firmware to read IP tagging information.
      This register of particular interest to firmware.*/
//====================================================================

#define  NEWMAN_REV0_MAJ_MASK 0xffff0000
#define  NEWMAN_REV0_MAJ_SHIFT 16
#define  NEWMAN_REV0_MAJ_MASK_SHIFT(reg) (((reg) & NEWMAN_REV0_MAJ_MASK) >> NEWMAN_REV0_MAJ_SHIFT)
#define  NEWMAN_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~NEWMAN_REV0_MAJ_MASK) | (((uint32_t)val) << NEWMAN_REV0_MAJ_SHIFT))

#define  NEWMAN_REV0_MID_MASK 0xffff
#define  NEWMAN_REV0_MID_SHIFT 0
#define  NEWMAN_REV0_MID_MASK_SHIFT(reg) (((reg) & NEWMAN_REV0_MID_MASK) >> NEWMAN_REV0_MID_SHIFT)
#define  NEWMAN_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~NEWMAN_REV0_MID_MASK) | (((uint32_t)val) << NEWMAN_REV0_MID_SHIFT))

//====================================================================
//Register: IP Tagging Revision 1 (REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  NEWMAN_REV1_RESERVED1_MASK 0xffff0000
#define  NEWMAN_REV1_RESERVED1_SHIFT 16
#define  NEWMAN_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & NEWMAN_REV1_RESERVED1_MASK) >> NEWMAN_REV1_RESERVED1_SHIFT)
#define  NEWMAN_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~NEWMAN_REV1_RESERVED1_MASK) | (((uint32_t)val) << NEWMAN_REV1_RESERVED1_SHIFT))

#define  NEWMAN_REV1_CFG_MASK 0xffff
#define  NEWMAN_REV1_CFG_SHIFT 0
#define  NEWMAN_REV1_CFG_MASK_SHIFT(reg) (((reg) & NEWMAN_REV1_CFG_MASK) >> NEWMAN_REV1_CFG_SHIFT)
#define  NEWMAN_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~NEWMAN_REV1_CFG_MASK) | (((uint32_t)val) << NEWMAN_REV1_CFG_SHIFT))

//====================================================================
//
//Register File: PageSense / ECD Detect (PS_ESD)
//
//====================================================================

//====================================================================
//Register: ESD Configuration (ESD_CFG)
/** \brief Overall configuration register for ESD detection logic (rev 0 . 3 . 1 . 5)*/
//====================================================================

#define  PS_ESD_ESD_CFG_RESERVED1_MASK 0xffffffe0
#define  PS_ESD_ESD_CFG_RESERVED1_SHIFT 5
#define  PS_ESD_ESD_CFG_RESERVED1_MASK_SHIFT(reg) (((reg) & PS_ESD_ESD_CFG_RESERVED1_MASK) >> PS_ESD_ESD_CFG_RESERVED1_SHIFT)
#define  PS_ESD_ESD_CFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_ESD_CFG_RESERVED1_MASK) | (((uint32_t)val) << PS_ESD_ESD_CFG_RESERVED1_SHIFT))

#define  PS_ESD_ESD_CFG_CHAN3_EN_MASK 0x10
#define  PS_ESD_ESD_CFG_CHAN3_EN_SHIFT 4
#define  PS_ESD_ESD_CFG_CHAN3_EN_MASK_SHIFT(reg) (((reg) & PS_ESD_ESD_CFG_CHAN3_EN_MASK) >> PS_ESD_ESD_CFG_CHAN3_EN_SHIFT)
#define  PS_ESD_ESD_CFG_CHAN3_EN_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_ESD_CFG_CHAN3_EN_MASK) | (((uint32_t)val) << PS_ESD_ESD_CFG_CHAN3_EN_SHIFT))

#define  PS_ESD_ESD_CFG_ESD_DIR_MASK 0x8
#define  PS_ESD_ESD_CFG_ESD_DIR_SHIFT 3
#define  PS_ESD_ESD_CFG_ESD_DIR_MASK_SHIFT(reg) (((reg) & PS_ESD_ESD_CFG_ESD_DIR_MASK) >> PS_ESD_ESD_CFG_ESD_DIR_SHIFT)
#define  PS_ESD_ESD_CFG_ESD_DIR_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_ESD_CFG_ESD_DIR_MASK) | (((uint32_t)val) << PS_ESD_ESD_CFG_ESD_DIR_SHIFT))

#define  PS_ESD_ESD_CFG_ACCUM_SIZE_MASK 0x6
#define  PS_ESD_ESD_CFG_ACCUM_SIZE_SHIFT 1
#define  PS_ESD_ESD_CFG_ACCUM_SIZE_MASK_SHIFT(reg) (((reg) & PS_ESD_ESD_CFG_ACCUM_SIZE_MASK) >> PS_ESD_ESD_CFG_ACCUM_SIZE_SHIFT)
#define  PS_ESD_ESD_CFG_ACCUM_SIZE_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_ESD_CFG_ACCUM_SIZE_MASK) | (((uint32_t)val) << PS_ESD_ESD_CFG_ACCUM_SIZE_SHIFT))

#define  PS_ESD_ESD_CFG_ENABLE_MASK 0x1
#define  PS_ESD_ESD_CFG_ENABLE_SHIFT 0
#define  PS_ESD_ESD_CFG_ENABLE_MASK_SHIFT(reg) (((reg) & PS_ESD_ESD_CFG_ENABLE_MASK) >> PS_ESD_ESD_CFG_ENABLE_SHIFT)
#define  PS_ESD_ESD_CFG_ENABLE_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_ESD_CFG_ENABLE_MASK) | (((uint32_t)val) << PS_ESD_ESD_CFG_ENABLE_SHIFT))

//====================================================================
//Register: ESD Start Address (ESD_START_0_R)
/** \brief Sets the pixel start address for the ESD accumulation region. If ESD_CFG.chan3_en is set, then ESD_START_0_R is the starting pixel address for the first sensor segment.*/
//====================================================================

#define  PS_ESD_ESD_START_0_R_RESERVED1_MASK 0xffff0000
#define  PS_ESD_ESD_START_0_R_RESERVED1_SHIFT 16
#define  PS_ESD_ESD_START_0_R_RESERVED1_MASK_SHIFT(reg) (((reg) & PS_ESD_ESD_START_0_R_RESERVED1_MASK) >> PS_ESD_ESD_START_0_R_RESERVED1_SHIFT)
#define  PS_ESD_ESD_START_0_R_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_ESD_START_0_R_RESERVED1_MASK) | (((uint32_t)val) << PS_ESD_ESD_START_0_R_RESERVED1_SHIFT))

#define  PS_ESD_ESD_START_0_R_ADDR_MASK 0xffff
#define  PS_ESD_ESD_START_0_R_ADDR_SHIFT 0
#define  PS_ESD_ESD_START_0_R_ADDR_MASK_SHIFT(reg) (((reg) & PS_ESD_ESD_START_0_R_ADDR_MASK) >> PS_ESD_ESD_START_0_R_ADDR_SHIFT)
#define  PS_ESD_ESD_START_0_R_ADDR_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_ESD_START_0_R_ADDR_MASK) | (((uint32_t)val) << PS_ESD_ESD_START_0_R_ADDR_SHIFT))

//====================================================================
//Register: ESD Start Address 1 (ESD_START_1_G)
/** \brief If ESD_CFG.chan3_en is set, sets the pixel start address for the ESD accumulation region for the second sensor segment.*/
//====================================================================

#define  PS_ESD_ESD_START_1_G_RESERVED1_MASK 0xffff0000
#define  PS_ESD_ESD_START_1_G_RESERVED1_SHIFT 16
#define  PS_ESD_ESD_START_1_G_RESERVED1_MASK_SHIFT(reg) (((reg) & PS_ESD_ESD_START_1_G_RESERVED1_MASK) >> PS_ESD_ESD_START_1_G_RESERVED1_SHIFT)
#define  PS_ESD_ESD_START_1_G_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_ESD_START_1_G_RESERVED1_MASK) | (((uint32_t)val) << PS_ESD_ESD_START_1_G_RESERVED1_SHIFT))

#define  PS_ESD_ESD_START_1_G_ADDR_MASK 0xffff
#define  PS_ESD_ESD_START_1_G_ADDR_SHIFT 0
#define  PS_ESD_ESD_START_1_G_ADDR_MASK_SHIFT(reg) (((reg) & PS_ESD_ESD_START_1_G_ADDR_MASK) >> PS_ESD_ESD_START_1_G_ADDR_SHIFT)
#define  PS_ESD_ESD_START_1_G_ADDR_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_ESD_START_1_G_ADDR_MASK) | (((uint32_t)val) << PS_ESD_ESD_START_1_G_ADDR_SHIFT))

//====================================================================
//Register: ESD Start Address 2 (ESD_START_2_B)
/** \brief If ESD_CFG.chan3_en is set, sets the pixel start address for the ESD accumulation region for the third sensor segment.*/
//====================================================================

#define  PS_ESD_ESD_START_2_B_RESERVED1_MASK 0xffff0000
#define  PS_ESD_ESD_START_2_B_RESERVED1_SHIFT 16
#define  PS_ESD_ESD_START_2_B_RESERVED1_MASK_SHIFT(reg) (((reg) & PS_ESD_ESD_START_2_B_RESERVED1_MASK) >> PS_ESD_ESD_START_2_B_RESERVED1_SHIFT)
#define  PS_ESD_ESD_START_2_B_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_ESD_START_2_B_RESERVED1_MASK) | (((uint32_t)val) << PS_ESD_ESD_START_2_B_RESERVED1_SHIFT))

#define  PS_ESD_ESD_START_2_B_ADDR_MASK 0xffff
#define  PS_ESD_ESD_START_2_B_ADDR_SHIFT 0
#define  PS_ESD_ESD_START_2_B_ADDR_MASK_SHIFT(reg) (((reg) & PS_ESD_ESD_START_2_B_ADDR_MASK) >> PS_ESD_ESD_START_2_B_ADDR_SHIFT)
#define  PS_ESD_ESD_START_2_B_ADDR_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_ESD_START_2_B_ADDR_MASK) | (((uint32_t)val) << PS_ESD_ESD_START_2_B_ADDR_SHIFT))

//====================================================================
//Register: ESD Tolerance (ESD_TOL)
/** \brief Sets the tolerance level for the ESD detection algorithm. ESD event is conditioned on the ABS(Line2 - Line0) being less than or equal to the Tolerance.*/
//====================================================================

#define  PS_ESD_ESD_TOL_RESERVED1_MASK 0xffffff00
#define  PS_ESD_ESD_TOL_RESERVED1_SHIFT 8
#define  PS_ESD_ESD_TOL_RESERVED1_MASK_SHIFT(reg) (((reg) & PS_ESD_ESD_TOL_RESERVED1_MASK) >> PS_ESD_ESD_TOL_RESERVED1_SHIFT)
#define  PS_ESD_ESD_TOL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_ESD_TOL_RESERVED1_MASK) | (((uint32_t)val) << PS_ESD_ESD_TOL_RESERVED1_SHIFT))

#define  PS_ESD_ESD_TOL_TOL_MASK 0xff
#define  PS_ESD_ESD_TOL_TOL_SHIFT 0
#define  PS_ESD_ESD_TOL_TOL_MASK_SHIFT(reg) (((reg) & PS_ESD_ESD_TOL_TOL_MASK) >> PS_ESD_ESD_TOL_TOL_SHIFT)
#define  PS_ESD_ESD_TOL_TOL_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_ESD_TOL_TOL_MASK) | (((uint32_t)val) << PS_ESD_ESD_TOL_TOL_SHIFT))

//====================================================================
//Register: ESD Change (ESD_CHG)
/** \brief Sets the change level for the ESD detection algorithm. If Line1 differs from the AVG(Line2 and Line0) by the ammount set in the change field, then a valid ESD event is flagged.*/
//====================================================================

#define  PS_ESD_ESD_CHG_RESERVED1_MASK 0xffffff00
#define  PS_ESD_ESD_CHG_RESERVED1_SHIFT 8
#define  PS_ESD_ESD_CHG_RESERVED1_MASK_SHIFT(reg) (((reg) & PS_ESD_ESD_CHG_RESERVED1_MASK) >> PS_ESD_ESD_CHG_RESERVED1_SHIFT)
#define  PS_ESD_ESD_CHG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_ESD_CHG_RESERVED1_MASK) | (((uint32_t)val) << PS_ESD_ESD_CHG_RESERVED1_SHIFT))

#define  PS_ESD_ESD_CHG_CHG_MASK 0xff
#define  PS_ESD_ESD_CHG_CHG_SHIFT 0
#define  PS_ESD_ESD_CHG_CHG_MASK_SHIFT(reg) (((reg) & PS_ESD_ESD_CHG_CHG_MASK) >> PS_ESD_ESD_CHG_CHG_SHIFT)
#define  PS_ESD_ESD_CHG_CHG_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_ESD_CHG_CHG_MASK) | (((uint32_t)val) << PS_ESD_ESD_CHG_CHG_SHIFT))

//====================================================================
//Register: ESD Color Reset (ESD_RST)
/** \brief Used to clear the internal ESD detection logic. One bit per color. Writing a '1' clears the color's accumulator and two previous value registers, clears the color's ESD event line number, and causes the color's state machine to wait for the next start of line to re-start monitoring.*/
//====================================================================

#define  PS_ESD_ESD_RST_RESERVED1_MASK 0xfffffff0
#define  PS_ESD_ESD_RST_RESERVED1_SHIFT 4
#define  PS_ESD_ESD_RST_RESERVED1_MASK_SHIFT(reg) (((reg) & PS_ESD_ESD_RST_RESERVED1_MASK) >> PS_ESD_ESD_RST_RESERVED1_SHIFT)
#define  PS_ESD_ESD_RST_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_ESD_RST_RESERVED1_MASK) | (((uint32_t)val) << PS_ESD_ESD_RST_RESERVED1_SHIFT))

#define  PS_ESD_ESD_RST_LCNT_MASK 0x8
#define  PS_ESD_ESD_RST_LCNT_SHIFT 3
#define  PS_ESD_ESD_RST_LCNT_MASK_SHIFT(reg) (((reg) & PS_ESD_ESD_RST_LCNT_MASK) >> PS_ESD_ESD_RST_LCNT_SHIFT)
#define  PS_ESD_ESD_RST_LCNT_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_ESD_RST_LCNT_MASK) | (((uint32_t)val) << PS_ESD_ESD_RST_LCNT_SHIFT))

#define  PS_ESD_ESD_RST_C2_MASK 0x4
#define  PS_ESD_ESD_RST_C2_SHIFT 2
#define  PS_ESD_ESD_RST_C2_MASK_SHIFT(reg) (((reg) & PS_ESD_ESD_RST_C2_MASK) >> PS_ESD_ESD_RST_C2_SHIFT)
#define  PS_ESD_ESD_RST_C2_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_ESD_RST_C2_MASK) | (((uint32_t)val) << PS_ESD_ESD_RST_C2_SHIFT))

#define  PS_ESD_ESD_RST_C1_MASK 0x2
#define  PS_ESD_ESD_RST_C1_SHIFT 1
#define  PS_ESD_ESD_RST_C1_MASK_SHIFT(reg) (((reg) & PS_ESD_ESD_RST_C1_MASK) >> PS_ESD_ESD_RST_C1_SHIFT)
#define  PS_ESD_ESD_RST_C1_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_ESD_RST_C1_MASK) | (((uint32_t)val) << PS_ESD_ESD_RST_C1_SHIFT))

#define  PS_ESD_ESD_RST_C0_MASK 0x1
#define  PS_ESD_ESD_RST_C0_SHIFT 0
#define  PS_ESD_ESD_RST_C0_MASK_SHIFT(reg) (((reg) & PS_ESD_ESD_RST_C0_MASK) >> PS_ESD_ESD_RST_C0_SHIFT)
#define  PS_ESD_ESD_RST_C0_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_ESD_RST_C0_MASK) | (((uint32_t)val) << PS_ESD_ESD_RST_C0_SHIFT))

//====================================================================
//Register: ESD Event Line Count Color0 (ESD_LCNT0)
/** \brief Provides the line number at which the ESD event was detected for color0. The line number is cleared when the color0 ESD interrupt is acknowledged.*/
//====================================================================

#define  PS_ESD_ESD_LCNT0_CRC_MASK 0x80000000
#define  PS_ESD_ESD_LCNT0_CRC_SHIFT 31
#define  PS_ESD_ESD_LCNT0_CRC_MASK_SHIFT(reg) (((reg) & PS_ESD_ESD_LCNT0_CRC_MASK) >> PS_ESD_ESD_LCNT0_CRC_SHIFT)
#define  PS_ESD_ESD_LCNT0_CRC_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_ESD_LCNT0_CRC_MASK) | (((uint32_t)val) << PS_ESD_ESD_LCNT0_CRC_SHIFT))

#define  PS_ESD_ESD_LCNT0_SEGS_MASK 0x70000000
#define  PS_ESD_ESD_LCNT0_SEGS_SHIFT 28
#define  PS_ESD_ESD_LCNT0_SEGS_MASK_SHIFT(reg) (((reg) & PS_ESD_ESD_LCNT0_SEGS_MASK) >> PS_ESD_ESD_LCNT0_SEGS_SHIFT)
#define  PS_ESD_ESD_LCNT0_SEGS_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_ESD_LCNT0_SEGS_MASK) | (((uint32_t)val) << PS_ESD_ESD_LCNT0_SEGS_SHIFT))

#define  PS_ESD_ESD_LCNT0_CNT_MASK 0xfffffff
#define  PS_ESD_ESD_LCNT0_CNT_SHIFT 0
#define  PS_ESD_ESD_LCNT0_CNT_MASK_SHIFT(reg) (((reg) & PS_ESD_ESD_LCNT0_CNT_MASK) >> PS_ESD_ESD_LCNT0_CNT_SHIFT)
#define  PS_ESD_ESD_LCNT0_CNT_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_ESD_LCNT0_CNT_MASK) | (((uint32_t)val) << PS_ESD_ESD_LCNT0_CNT_SHIFT))

//====================================================================
//Register: ESD Event Line Count Color1 (ESD_LCNT1)
/** \brief Provides the line number at which the ESD event was detected for color1. The line number is cleared when the color1 ESD interrupt is acknowledged.*/
//====================================================================

#define  PS_ESD_ESD_LCNT1_CRC_MASK 0x80000000
#define  PS_ESD_ESD_LCNT1_CRC_SHIFT 31
#define  PS_ESD_ESD_LCNT1_CRC_MASK_SHIFT(reg) (((reg) & PS_ESD_ESD_LCNT1_CRC_MASK) >> PS_ESD_ESD_LCNT1_CRC_SHIFT)
#define  PS_ESD_ESD_LCNT1_CRC_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_ESD_LCNT1_CRC_MASK) | (((uint32_t)val) << PS_ESD_ESD_LCNT1_CRC_SHIFT))

#define  PS_ESD_ESD_LCNT1_SEGS_MASK 0x70000000
#define  PS_ESD_ESD_LCNT1_SEGS_SHIFT 28
#define  PS_ESD_ESD_LCNT1_SEGS_MASK_SHIFT(reg) (((reg) & PS_ESD_ESD_LCNT1_SEGS_MASK) >> PS_ESD_ESD_LCNT1_SEGS_SHIFT)
#define  PS_ESD_ESD_LCNT1_SEGS_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_ESD_LCNT1_SEGS_MASK) | (((uint32_t)val) << PS_ESD_ESD_LCNT1_SEGS_SHIFT))

#define  PS_ESD_ESD_LCNT1_CNT_MASK 0xfffffff
#define  PS_ESD_ESD_LCNT1_CNT_SHIFT 0
#define  PS_ESD_ESD_LCNT1_CNT_MASK_SHIFT(reg) (((reg) & PS_ESD_ESD_LCNT1_CNT_MASK) >> PS_ESD_ESD_LCNT1_CNT_SHIFT)
#define  PS_ESD_ESD_LCNT1_CNT_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_ESD_LCNT1_CNT_MASK) | (((uint32_t)val) << PS_ESD_ESD_LCNT1_CNT_SHIFT))

//====================================================================
//Register: ESD Event Line Count Color2 (ESD_LCNT2)
/** \brief Provides the line number at which the ESD event was detected for color2. The line number is cleared when the color2 ESD interrupt is acknowledged.*/
//====================================================================

#define  PS_ESD_ESD_LCNT2_CRC_MASK 0x80000000
#define  PS_ESD_ESD_LCNT2_CRC_SHIFT 31
#define  PS_ESD_ESD_LCNT2_CRC_MASK_SHIFT(reg) (((reg) & PS_ESD_ESD_LCNT2_CRC_MASK) >> PS_ESD_ESD_LCNT2_CRC_SHIFT)
#define  PS_ESD_ESD_LCNT2_CRC_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_ESD_LCNT2_CRC_MASK) | (((uint32_t)val) << PS_ESD_ESD_LCNT2_CRC_SHIFT))

#define  PS_ESD_ESD_LCNT2_SEGS_MASK 0x70000000
#define  PS_ESD_ESD_LCNT2_SEGS_SHIFT 28
#define  PS_ESD_ESD_LCNT2_SEGS_MASK_SHIFT(reg) (((reg) & PS_ESD_ESD_LCNT2_SEGS_MASK) >> PS_ESD_ESD_LCNT2_SEGS_SHIFT)
#define  PS_ESD_ESD_LCNT2_SEGS_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_ESD_LCNT2_SEGS_MASK) | (((uint32_t)val) << PS_ESD_ESD_LCNT2_SEGS_SHIFT))

#define  PS_ESD_ESD_LCNT2_CNT_MASK 0xfffffff
#define  PS_ESD_ESD_LCNT2_CNT_SHIFT 0
#define  PS_ESD_ESD_LCNT2_CNT_MASK_SHIFT(reg) (((reg) & PS_ESD_ESD_LCNT2_CNT_MASK) >> PS_ESD_ESD_LCNT2_CNT_SHIFT)
#define  PS_ESD_ESD_LCNT2_CNT_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_ESD_LCNT2_CNT_MASK) | (((uint32_t)val) << PS_ESD_ESD_LCNT2_CNT_SHIFT))

//====================================================================
//Register: PageSense Configuration (PS_CFG)
/** \brief Overall configuration register for PageSense detection logic.*/
//====================================================================

#define  PS_ESD_PS_CFG_RESERVED1_MASK 0xfffffc00
#define  PS_ESD_PS_CFG_RESERVED1_SHIFT 10
#define  PS_ESD_PS_CFG_RESERVED1_MASK_SHIFT(reg) (((reg) & PS_ESD_PS_CFG_RESERVED1_MASK) >> PS_ESD_PS_CFG_RESERVED1_SHIFT)
#define  PS_ESD_PS_CFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_PS_CFG_RESERVED1_MASK) | (((uint32_t)val) << PS_ESD_PS_CFG_RESERVED1_SHIFT))

#define  PS_ESD_PS_CFG_RES_AVG_MASK 0x300
#define  PS_ESD_PS_CFG_RES_AVG_SHIFT 8
#define  PS_ESD_PS_CFG_RES_AVG_MASK_SHIFT(reg) (((reg) & PS_ESD_PS_CFG_RES_AVG_MASK) >> PS_ESD_PS_CFG_RES_AVG_SHIFT)
#define  PS_ESD_PS_CFG_RES_AVG_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_PS_CFG_RES_AVG_MASK) | (((uint32_t)val) << PS_ESD_PS_CFG_RES_AVG_SHIFT))

#define  PS_ESD_PS_CFG_RESERVED2_MASK 0x80
#define  PS_ESD_PS_CFG_RESERVED2_SHIFT 7
#define  PS_ESD_PS_CFG_RESERVED2_MASK_SHIFT(reg) (((reg) & PS_ESD_PS_CFG_RESERVED2_MASK) >> PS_ESD_PS_CFG_RESERVED2_SHIFT)
#define  PS_ESD_PS_CFG_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_PS_CFG_RESERVED2_MASK) | (((uint32_t)val) << PS_ESD_PS_CFG_RESERVED2_SHIFT))

#define  PS_ESD_PS_CFG_CHAN_EN_MASK 0x70
#define  PS_ESD_PS_CFG_CHAN_EN_SHIFT 4
#define  PS_ESD_PS_CFG_CHAN_EN_MASK_SHIFT(reg) (((reg) & PS_ESD_PS_CFG_CHAN_EN_MASK) >> PS_ESD_PS_CFG_CHAN_EN_SHIFT)
#define  PS_ESD_PS_CFG_CHAN_EN_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_PS_CFG_CHAN_EN_MASK) | (((uint32_t)val) << PS_ESD_PS_CFG_CHAN_EN_SHIFT))

#define  PS_ESD_PS_CFG_RESERVED3_MASK 0x8
#define  PS_ESD_PS_CFG_RESERVED3_SHIFT 3
#define  PS_ESD_PS_CFG_RESERVED3_MASK_SHIFT(reg) (((reg) & PS_ESD_PS_CFG_RESERVED3_MASK) >> PS_ESD_PS_CFG_RESERVED3_SHIFT)
#define  PS_ESD_PS_CFG_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_PS_CFG_RESERVED3_MASK) | (((uint32_t)val) << PS_ESD_PS_CFG_RESERVED3_SHIFT))

#define  PS_ESD_PS_CFG_TOF_NBOF_MASK 0x4
#define  PS_ESD_PS_CFG_TOF_NBOF_SHIFT 2
#define  PS_ESD_PS_CFG_TOF_NBOF_MASK_SHIFT(reg) (((reg) & PS_ESD_PS_CFG_TOF_NBOF_MASK) >> PS_ESD_PS_CFG_TOF_NBOF_SHIFT)
#define  PS_ESD_PS_CFG_TOF_NBOF_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_PS_CFG_TOF_NBOF_MASK) | (((uint32_t)val) << PS_ESD_PS_CFG_TOF_NBOF_SHIFT))

#define  PS_ESD_PS_CFG_START_BIT_MASK 0x2
#define  PS_ESD_PS_CFG_START_BIT_SHIFT 1
#define  PS_ESD_PS_CFG_START_BIT_MASK_SHIFT(reg) (((reg) & PS_ESD_PS_CFG_START_BIT_MASK) >> PS_ESD_PS_CFG_START_BIT_SHIFT)
#define  PS_ESD_PS_CFG_START_BIT_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_PS_CFG_START_BIT_MASK) | (((uint32_t)val) << PS_ESD_PS_CFG_START_BIT_SHIFT))

#define  PS_ESD_PS_CFG_COLOR_MODE_MASK 0x1
#define  PS_ESD_PS_CFG_COLOR_MODE_SHIFT 0
#define  PS_ESD_PS_CFG_COLOR_MODE_MASK_SHIFT(reg) (((reg) & PS_ESD_PS_CFG_COLOR_MODE_MASK) >> PS_ESD_PS_CFG_COLOR_MODE_SHIFT)
#define  PS_ESD_PS_CFG_COLOR_MODE_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_PS_CFG_COLOR_MODE_MASK) | (((uint32_t)val) << PS_ESD_PS_CFG_COLOR_MODE_SHIFT))

//====================================================================
//Register: PageSense Go (PS_GO)
/** \brief Primes the PageSense logic and causes it to begin searching for TOF or BOF.*/
//====================================================================

#define  PS_ESD_PS_GO_RESERVED1_MASK 0xfffffffe
#define  PS_ESD_PS_GO_RESERVED1_SHIFT 1
#define  PS_ESD_PS_GO_RESERVED1_MASK_SHIFT(reg) (((reg) & PS_ESD_PS_GO_RESERVED1_MASK) >> PS_ESD_PS_GO_RESERVED1_SHIFT)
#define  PS_ESD_PS_GO_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_PS_GO_RESERVED1_MASK) | (((uint32_t)val) << PS_ESD_PS_GO_RESERVED1_SHIFT))

#define  PS_ESD_PS_GO_GO_MASK 0x1
#define  PS_ESD_PS_GO_GO_SHIFT 0
#define  PS_ESD_PS_GO_GO_MASK_SHIFT(reg) (((reg) & PS_ESD_PS_GO_GO_MASK) >> PS_ESD_PS_GO_GO_SHIFT)
#define  PS_ESD_PS_GO_GO_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_PS_GO_GO_MASK) | (((uint32_t)val) << PS_ESD_PS_GO_GO_SHIFT))

//====================================================================
//Register: PageSense Start Pixel (PS_START)
/** \brief Sets the pixel number within a row where PageSense detection begins. Note that this is prior to the resolution reduction down to 300dpi.*/
//====================================================================

#define  PS_ESD_PS_START_RESERVED1_MASK 0xffff0000
#define  PS_ESD_PS_START_RESERVED1_SHIFT 16
#define  PS_ESD_PS_START_RESERVED1_MASK_SHIFT(reg) (((reg) & PS_ESD_PS_START_RESERVED1_MASK) >> PS_ESD_PS_START_RESERVED1_SHIFT)
#define  PS_ESD_PS_START_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_PS_START_RESERVED1_MASK) | (((uint32_t)val) << PS_ESD_PS_START_RESERVED1_SHIFT))

#define  PS_ESD_PS_START_START_PIX_MASK 0xffff
#define  PS_ESD_PS_START_START_PIX_SHIFT 0
#define  PS_ESD_PS_START_START_PIX_MASK_SHIFT(reg) (((reg) & PS_ESD_PS_START_START_PIX_MASK) >> PS_ESD_PS_START_START_PIX_SHIFT)
#define  PS_ESD_PS_START_START_PIX_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_PS_START_START_PIX_MASK) | (((uint32_t)val) << PS_ESD_PS_START_START_PIX_SHIFT))

//====================================================================
//Register: PageSense Region Widths 0 (PS_WIDTH0)
/** \brief Configures the widths (at 300dpi) for the each of the detection regions. This register configures regions 0-3.*/
//====================================================================

#define  PS_ESD_PS_WIDTH0_REGION3_MASK 0xff000000
#define  PS_ESD_PS_WIDTH0_REGION3_SHIFT 24
#define  PS_ESD_PS_WIDTH0_REGION3_MASK_SHIFT(reg) (((reg) & PS_ESD_PS_WIDTH0_REGION3_MASK) >> PS_ESD_PS_WIDTH0_REGION3_SHIFT)
#define  PS_ESD_PS_WIDTH0_REGION3_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_PS_WIDTH0_REGION3_MASK) | (((uint32_t)val) << PS_ESD_PS_WIDTH0_REGION3_SHIFT))

#define  PS_ESD_PS_WIDTH0_REGION2_MASK 0xff0000
#define  PS_ESD_PS_WIDTH0_REGION2_SHIFT 16
#define  PS_ESD_PS_WIDTH0_REGION2_MASK_SHIFT(reg) (((reg) & PS_ESD_PS_WIDTH0_REGION2_MASK) >> PS_ESD_PS_WIDTH0_REGION2_SHIFT)
#define  PS_ESD_PS_WIDTH0_REGION2_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_PS_WIDTH0_REGION2_MASK) | (((uint32_t)val) << PS_ESD_PS_WIDTH0_REGION2_SHIFT))

#define  PS_ESD_PS_WIDTH0_REGION1_MASK 0xff00
#define  PS_ESD_PS_WIDTH0_REGION1_SHIFT 8
#define  PS_ESD_PS_WIDTH0_REGION1_MASK_SHIFT(reg) (((reg) & PS_ESD_PS_WIDTH0_REGION1_MASK) >> PS_ESD_PS_WIDTH0_REGION1_SHIFT)
#define  PS_ESD_PS_WIDTH0_REGION1_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_PS_WIDTH0_REGION1_MASK) | (((uint32_t)val) << PS_ESD_PS_WIDTH0_REGION1_SHIFT))

#define  PS_ESD_PS_WIDTH0_REGION0_MASK 0xff
#define  PS_ESD_PS_WIDTH0_REGION0_SHIFT 0
#define  PS_ESD_PS_WIDTH0_REGION0_MASK_SHIFT(reg) (((reg) & PS_ESD_PS_WIDTH0_REGION0_MASK) >> PS_ESD_PS_WIDTH0_REGION0_SHIFT)
#define  PS_ESD_PS_WIDTH0_REGION0_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_PS_WIDTH0_REGION0_MASK) | (((uint32_t)val) << PS_ESD_PS_WIDTH0_REGION0_SHIFT))

//====================================================================
//Register: PageSense Region Widths 1 (PS_WIDTH1)
/** \brief Configures the widths (at 300dpi) for the each of the detection regions. This register configures regions 0-3.*/
//====================================================================

#define  PS_ESD_PS_WIDTH1_REGION7_MASK 0xff000000
#define  PS_ESD_PS_WIDTH1_REGION7_SHIFT 24
#define  PS_ESD_PS_WIDTH1_REGION7_MASK_SHIFT(reg) (((reg) & PS_ESD_PS_WIDTH1_REGION7_MASK) >> PS_ESD_PS_WIDTH1_REGION7_SHIFT)
#define  PS_ESD_PS_WIDTH1_REGION7_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_PS_WIDTH1_REGION7_MASK) | (((uint32_t)val) << PS_ESD_PS_WIDTH1_REGION7_SHIFT))

#define  PS_ESD_PS_WIDTH1_REGION6_MASK 0xff0000
#define  PS_ESD_PS_WIDTH1_REGION6_SHIFT 16
#define  PS_ESD_PS_WIDTH1_REGION6_MASK_SHIFT(reg) (((reg) & PS_ESD_PS_WIDTH1_REGION6_MASK) >> PS_ESD_PS_WIDTH1_REGION6_SHIFT)
#define  PS_ESD_PS_WIDTH1_REGION6_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_PS_WIDTH1_REGION6_MASK) | (((uint32_t)val) << PS_ESD_PS_WIDTH1_REGION6_SHIFT))

#define  PS_ESD_PS_WIDTH1_REGION5_MASK 0xff00
#define  PS_ESD_PS_WIDTH1_REGION5_SHIFT 8
#define  PS_ESD_PS_WIDTH1_REGION5_MASK_SHIFT(reg) (((reg) & PS_ESD_PS_WIDTH1_REGION5_MASK) >> PS_ESD_PS_WIDTH1_REGION5_SHIFT)
#define  PS_ESD_PS_WIDTH1_REGION5_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_PS_WIDTH1_REGION5_MASK) | (((uint32_t)val) << PS_ESD_PS_WIDTH1_REGION5_SHIFT))

#define  PS_ESD_PS_WIDTH1_REGION4_MASK 0xff
#define  PS_ESD_PS_WIDTH1_REGION4_SHIFT 0
#define  PS_ESD_PS_WIDTH1_REGION4_MASK_SHIFT(reg) (((reg) & PS_ESD_PS_WIDTH1_REGION4_MASK) >> PS_ESD_PS_WIDTH1_REGION4_SHIFT)
#define  PS_ESD_PS_WIDTH1_REGION4_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_PS_WIDTH1_REGION4_MASK) | (((uint32_t)val) << PS_ESD_PS_WIDTH1_REGION4_SHIFT))

//====================================================================
//Register: PageSense Region Tolerance (PS_TOL)
/** \brief Used to configure the region width tolerances (+/- from values programmed in PS_WIDTH0/PS_WIDTH1)*/
//====================================================================

#define  PS_ESD_PS_TOL_RESERVED1_MASK 0xffffc000
#define  PS_ESD_PS_TOL_RESERVED1_SHIFT 14
#define  PS_ESD_PS_TOL_RESERVED1_MASK_SHIFT(reg) (((reg) & PS_ESD_PS_TOL_RESERVED1_MASK) >> PS_ESD_PS_TOL_RESERVED1_SHIFT)
#define  PS_ESD_PS_TOL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_PS_TOL_RESERVED1_MASK) | (((uint32_t)val) << PS_ESD_PS_TOL_RESERVED1_SHIFT))

#define  PS_ESD_PS_TOL_TOTAL_TOL_MASK 0x3f00
#define  PS_ESD_PS_TOL_TOTAL_TOL_SHIFT 8
#define  PS_ESD_PS_TOL_TOTAL_TOL_MASK_SHIFT(reg) (((reg) & PS_ESD_PS_TOL_TOTAL_TOL_MASK) >> PS_ESD_PS_TOL_TOTAL_TOL_SHIFT)
#define  PS_ESD_PS_TOL_TOTAL_TOL_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_PS_TOL_TOTAL_TOL_MASK) | (((uint32_t)val) << PS_ESD_PS_TOL_TOTAL_TOL_SHIFT))

#define  PS_ESD_PS_TOL_RESERVED2_MASK 0xc0
#define  PS_ESD_PS_TOL_RESERVED2_SHIFT 6
#define  PS_ESD_PS_TOL_RESERVED2_MASK_SHIFT(reg) (((reg) & PS_ESD_PS_TOL_RESERVED2_MASK) >> PS_ESD_PS_TOL_RESERVED2_SHIFT)
#define  PS_ESD_PS_TOL_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_PS_TOL_RESERVED2_MASK) | (((uint32_t)val) << PS_ESD_PS_TOL_RESERVED2_SHIFT))

#define  PS_ESD_PS_TOL_REG_TOL_MASK 0x3f
#define  PS_ESD_PS_TOL_REG_TOL_SHIFT 0
#define  PS_ESD_PS_TOL_REG_TOL_MASK_SHIFT(reg) (((reg) & PS_ESD_PS_TOL_REG_TOL_MASK) >> PS_ESD_PS_TOL_REG_TOL_SHIFT)
#define  PS_ESD_PS_TOL_REG_TOL_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_PS_TOL_REG_TOL_MASK) | (((uint32_t)val) << PS_ESD_PS_TOL_REG_TOL_SHIFT))

//====================================================================
//Register: PageSense Overall Width (PS_TOTAL_WID)
/** \brief Used to configure the overall width of regions 1-7. Should be programmed with the sum of the regions PS_WIDTH0.region1 through PS_WIDTH1.region7.*/
//====================================================================

#define  PS_ESD_PS_TOTAL_WID_RESERVED1_MASK 0xfffff800
#define  PS_ESD_PS_TOTAL_WID_RESERVED1_SHIFT 11
#define  PS_ESD_PS_TOTAL_WID_RESERVED1_MASK_SHIFT(reg) (((reg) & PS_ESD_PS_TOTAL_WID_RESERVED1_MASK) >> PS_ESD_PS_TOTAL_WID_RESERVED1_SHIFT)
#define  PS_ESD_PS_TOTAL_WID_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_PS_TOTAL_WID_RESERVED1_MASK) | (((uint32_t)val) << PS_ESD_PS_TOTAL_WID_RESERVED1_SHIFT))

#define  PS_ESD_PS_TOTAL_WID_TOTAL_WID_MASK 0x7ff
#define  PS_ESD_PS_TOTAL_WID_TOTAL_WID_SHIFT 0
#define  PS_ESD_PS_TOTAL_WID_TOTAL_WID_MASK_SHIFT(reg) (((reg) & PS_ESD_PS_TOTAL_WID_TOTAL_WID_MASK) >> PS_ESD_PS_TOTAL_WID_TOTAL_WID_SHIFT)
#define  PS_ESD_PS_TOTAL_WID_TOTAL_WID_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_PS_TOTAL_WID_TOTAL_WID_MASK) | (((uint32_t)val) << PS_ESD_PS_TOTAL_WID_TOTAL_WID_SHIFT))

//====================================================================
//Register: PageSense Toggle Delta (PS_TOGGLE)
/** \brief Used to configure the deltas required to toggle between the dark and light regions.*/
//====================================================================

#define  PS_ESD_PS_TOGGLE_RESERVED1_MASK 0xffff0000
#define  PS_ESD_PS_TOGGLE_RESERVED1_SHIFT 16
#define  PS_ESD_PS_TOGGLE_RESERVED1_MASK_SHIFT(reg) (((reg) & PS_ESD_PS_TOGGLE_RESERVED1_MASK) >> PS_ESD_PS_TOGGLE_RESERVED1_SHIFT)
#define  PS_ESD_PS_TOGGLE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_PS_TOGGLE_RESERVED1_MASK) | (((uint32_t)val) << PS_ESD_PS_TOGGLE_RESERVED1_SHIFT))

#define  PS_ESD_PS_TOGGLE_TOGGLE10_MASK 0xff00
#define  PS_ESD_PS_TOGGLE_TOGGLE10_SHIFT 8
#define  PS_ESD_PS_TOGGLE_TOGGLE10_MASK_SHIFT(reg) (((reg) & PS_ESD_PS_TOGGLE_TOGGLE10_MASK) >> PS_ESD_PS_TOGGLE_TOGGLE10_SHIFT)
#define  PS_ESD_PS_TOGGLE_TOGGLE10_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_PS_TOGGLE_TOGGLE10_MASK) | (((uint32_t)val) << PS_ESD_PS_TOGGLE_TOGGLE10_SHIFT))

#define  PS_ESD_PS_TOGGLE_TOGGLE01_MASK 0xff
#define  PS_ESD_PS_TOGGLE_TOGGLE01_SHIFT 0
#define  PS_ESD_PS_TOGGLE_TOGGLE01_MASK_SHIFT(reg) (((reg) & PS_ESD_PS_TOGGLE_TOGGLE01_MASK) >> PS_ESD_PS_TOGGLE_TOGGLE01_SHIFT)
#define  PS_ESD_PS_TOGGLE_TOGGLE01_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_PS_TOGGLE_TOGGLE01_MASK) | (((uint32_t)val) << PS_ESD_PS_TOGGLE_TOGGLE01_SHIFT))

//====================================================================
//Register: PageSense Count (PS_CNT)
/** \brief Used to configure the number of detects required for a positive pattern match.*/
//====================================================================

#define  PS_ESD_PS_CNT_RESERVED1_MASK 0xffffff80
#define  PS_ESD_PS_CNT_RESERVED1_SHIFT 7
#define  PS_ESD_PS_CNT_RESERVED1_MASK_SHIFT(reg) (((reg) & PS_ESD_PS_CNT_RESERVED1_MASK) >> PS_ESD_PS_CNT_RESERVED1_SHIFT)
#define  PS_ESD_PS_CNT_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_PS_CNT_RESERVED1_MASK) | (((uint32_t)val) << PS_ESD_PS_CNT_RESERVED1_SHIFT))

#define  PS_ESD_PS_CNT_COUNT1_MASK 0x70
#define  PS_ESD_PS_CNT_COUNT1_SHIFT 4
#define  PS_ESD_PS_CNT_COUNT1_MASK_SHIFT(reg) (((reg) & PS_ESD_PS_CNT_COUNT1_MASK) >> PS_ESD_PS_CNT_COUNT1_SHIFT)
#define  PS_ESD_PS_CNT_COUNT1_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_PS_CNT_COUNT1_MASK) | (((uint32_t)val) << PS_ESD_PS_CNT_COUNT1_SHIFT))

#define  PS_ESD_PS_CNT_RESERVED2_MASK 0x8
#define  PS_ESD_PS_CNT_RESERVED2_SHIFT 3
#define  PS_ESD_PS_CNT_RESERVED2_MASK_SHIFT(reg) (((reg) & PS_ESD_PS_CNT_RESERVED2_MASK) >> PS_ESD_PS_CNT_RESERVED2_SHIFT)
#define  PS_ESD_PS_CNT_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_PS_CNT_RESERVED2_MASK) | (((uint32_t)val) << PS_ESD_PS_CNT_RESERVED2_SHIFT))

#define  PS_ESD_PS_CNT_COUNT0_MASK 0x7
#define  PS_ESD_PS_CNT_COUNT0_SHIFT 0
#define  PS_ESD_PS_CNT_COUNT0_MASK_SHIFT(reg) (((reg) & PS_ESD_PS_CNT_COUNT0_MASK) >> PS_ESD_PS_CNT_COUNT0_SHIFT)
#define  PS_ESD_PS_CNT_COUNT0_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_PS_CNT_COUNT0_MASK) | (((uint32_t)val) << PS_ESD_PS_CNT_COUNT0_SHIFT))

//====================================================================
//Register: PageSense Detect Line Count (PS_LCNT)
/** \brief Provides the line number at which the TOF/BOF event was detected. Cleared when PS_GO is written.*/
//====================================================================

#define  PS_ESD_PS_LCNT_VALID_MASK 0x80000000
#define  PS_ESD_PS_LCNT_VALID_SHIFT 31
#define  PS_ESD_PS_LCNT_VALID_MASK_SHIFT(reg) (((reg) & PS_ESD_PS_LCNT_VALID_MASK) >> PS_ESD_PS_LCNT_VALID_SHIFT)
#define  PS_ESD_PS_LCNT_VALID_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_PS_LCNT_VALID_MASK) | (((uint32_t)val) << PS_ESD_PS_LCNT_VALID_SHIFT))

#define  PS_ESD_PS_LCNT_RESERVED1_MASK 0x70000000
#define  PS_ESD_PS_LCNT_RESERVED1_SHIFT 28
#define  PS_ESD_PS_LCNT_RESERVED1_MASK_SHIFT(reg) (((reg) & PS_ESD_PS_LCNT_RESERVED1_MASK) >> PS_ESD_PS_LCNT_RESERVED1_SHIFT)
#define  PS_ESD_PS_LCNT_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_PS_LCNT_RESERVED1_MASK) | (((uint32_t)val) << PS_ESD_PS_LCNT_RESERVED1_SHIFT))

#define  PS_ESD_PS_LCNT_CNT_MASK 0xfffffff
#define  PS_ESD_PS_LCNT_CNT_SHIFT 0
#define  PS_ESD_PS_LCNT_CNT_MASK_SHIFT(reg) (((reg) & PS_ESD_PS_LCNT_CNT_MASK) >> PS_ESD_PS_LCNT_CNT_SHIFT)
#define  PS_ESD_PS_LCNT_CNT_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_PS_LCNT_CNT_MASK) | (((uint32_t)val) << PS_ESD_PS_LCNT_CNT_SHIFT))

//====================================================================
//Register: PageSense Filter Capture (PS_FILT)
/** \brief Provides the filter values that are captured when the PageSense interrupt fires. Cleared when PS_GO is written*/
//====================================================================

#define  PS_ESD_PS_FILT_VALID_MASK 0x80000000
#define  PS_ESD_PS_FILT_VALID_SHIFT 31
#define  PS_ESD_PS_FILT_VALID_MASK_SHIFT(reg) (((reg) & PS_ESD_PS_FILT_VALID_MASK) >> PS_ESD_PS_FILT_VALID_SHIFT)
#define  PS_ESD_PS_FILT_VALID_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_PS_FILT_VALID_MASK) | (((uint32_t)val) << PS_ESD_PS_FILT_VALID_SHIFT))

#define  PS_ESD_PS_FILT_RESERVED1_MASK 0x7fffff00
#define  PS_ESD_PS_FILT_RESERVED1_SHIFT 8
#define  PS_ESD_PS_FILT_RESERVED1_MASK_SHIFT(reg) (((reg) & PS_ESD_PS_FILT_RESERVED1_MASK) >> PS_ESD_PS_FILT_RESERVED1_SHIFT)
#define  PS_ESD_PS_FILT_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_PS_FILT_RESERVED1_MASK) | (((uint32_t)val) << PS_ESD_PS_FILT_RESERVED1_SHIFT))

#define  PS_ESD_PS_FILT_FILTER_MASK 0xff
#define  PS_ESD_PS_FILT_FILTER_SHIFT 0
#define  PS_ESD_PS_FILT_FILTER_MASK_SHIFT(reg) (((reg) & PS_ESD_PS_FILT_FILTER_MASK) >> PS_ESD_PS_FILT_FILTER_SHIFT)
#define  PS_ESD_PS_FILT_FILTER_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_PS_FILT_FILTER_MASK) | (((uint32_t)val) << PS_ESD_PS_FILT_FILTER_SHIFT))

//====================================================================
//Register: PageSense Status (PS_STAT)
/** \brief Provides read only status information for the PageSense function.*/
//====================================================================

#define  PS_ESD_PS_STAT_RESERVED1_MASK 0xfffffffe
#define  PS_ESD_PS_STAT_RESERVED1_SHIFT 1
#define  PS_ESD_PS_STAT_RESERVED1_MASK_SHIFT(reg) (((reg) & PS_ESD_PS_STAT_RESERVED1_MASK) >> PS_ESD_PS_STAT_RESERVED1_SHIFT)
#define  PS_ESD_PS_STAT_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_PS_STAT_RESERVED1_MASK) | (((uint32_t)val) << PS_ESD_PS_STAT_RESERVED1_SHIFT))

#define  PS_ESD_PS_STAT_BUSY_MASK 0x1
#define  PS_ESD_PS_STAT_BUSY_SHIFT 0
#define  PS_ESD_PS_STAT_BUSY_MASK_SHIFT(reg) (((reg) & PS_ESD_PS_STAT_BUSY_MASK) >> PS_ESD_PS_STAT_BUSY_SHIFT)
#define  PS_ESD_PS_STAT_BUSY_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_PS_STAT_BUSY_MASK) | (((uint32_t)val) << PS_ESD_PS_STAT_BUSY_SHIFT))

//====================================================================
//Register: Line Counter (LCNT)
/** \brief Provides the current value of the internal line counter.*/
//====================================================================

#define  PS_ESD_LCNT_CT_MASK 0xc0000000
#define  PS_ESD_LCNT_CT_SHIFT 30
#define  PS_ESD_LCNT_CT_MASK_SHIFT(reg) (((reg) & PS_ESD_LCNT_CT_MASK) >> PS_ESD_LCNT_CT_SHIFT)
#define  PS_ESD_LCNT_CT_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_LCNT_CT_MASK) | (((uint32_t)val) << PS_ESD_LCNT_CT_SHIFT))

#define  PS_ESD_LCNT_RESERVED1_MASK 0x30000000
#define  PS_ESD_LCNT_RESERVED1_SHIFT 28
#define  PS_ESD_LCNT_RESERVED1_MASK_SHIFT(reg) (((reg) & PS_ESD_LCNT_RESERVED1_MASK) >> PS_ESD_LCNT_RESERVED1_SHIFT)
#define  PS_ESD_LCNT_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_LCNT_RESERVED1_MASK) | (((uint32_t)val) << PS_ESD_LCNT_RESERVED1_SHIFT))

#define  PS_ESD_LCNT_CNT_MASK 0xfffffff
#define  PS_ESD_LCNT_CNT_SHIFT 0
#define  PS_ESD_LCNT_CNT_MASK_SHIFT(reg) (((reg) & PS_ESD_LCNT_CNT_MASK) >> PS_ESD_LCNT_CNT_SHIFT)
#define  PS_ESD_LCNT_CNT_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_LCNT_CNT_MASK) | (((uint32_t)val) << PS_ESD_LCNT_CNT_SHIFT))

//====================================================================
//Register: Line Counter (LCNT_WR)
/** \brief Allows the current value of the internal line counter to be written by firmware.*/
//====================================================================

#define  PS_ESD_LCNT_WR_CT_MASK 0xc0000000
#define  PS_ESD_LCNT_WR_CT_SHIFT 30
#define  PS_ESD_LCNT_WR_CT_MASK_SHIFT(reg) (((reg) & PS_ESD_LCNT_WR_CT_MASK) >> PS_ESD_LCNT_WR_CT_SHIFT)
#define  PS_ESD_LCNT_WR_CT_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_LCNT_WR_CT_MASK) | (((uint32_t)val) << PS_ESD_LCNT_WR_CT_SHIFT))

#define  PS_ESD_LCNT_WR_RESERVED1_MASK 0x30000000
#define  PS_ESD_LCNT_WR_RESERVED1_SHIFT 28
#define  PS_ESD_LCNT_WR_RESERVED1_MASK_SHIFT(reg) (((reg) & PS_ESD_LCNT_WR_RESERVED1_MASK) >> PS_ESD_LCNT_WR_RESERVED1_SHIFT)
#define  PS_ESD_LCNT_WR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_LCNT_WR_RESERVED1_MASK) | (((uint32_t)val) << PS_ESD_LCNT_WR_RESERVED1_SHIFT))

#define  PS_ESD_LCNT_WR_CNT_MASK 0xfffffff
#define  PS_ESD_LCNT_WR_CNT_SHIFT 0
#define  PS_ESD_LCNT_WR_CNT_MASK_SHIFT(reg) (((reg) & PS_ESD_LCNT_WR_CNT_MASK) >> PS_ESD_LCNT_WR_CNT_SHIFT)
#define  PS_ESD_LCNT_WR_CNT_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_LCNT_WR_CNT_MASK) | (((uint32_t)val) << PS_ESD_LCNT_WR_CNT_SHIFT))

//====================================================================
//Register: Interrupt Enable Register (IEN)
/** \brief Interrupt Enable.*/
//====================================================================

#define  PS_ESD_IEN_RESERVED1_MASK 0xfffffff0
#define  PS_ESD_IEN_RESERVED1_SHIFT 4
#define  PS_ESD_IEN_RESERVED1_MASK_SHIFT(reg) (((reg) & PS_ESD_IEN_RESERVED1_MASK) >> PS_ESD_IEN_RESERVED1_SHIFT)
#define  PS_ESD_IEN_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_IEN_RESERVED1_MASK) | (((uint32_t)val) << PS_ESD_IEN_RESERVED1_SHIFT))

#define  PS_ESD_IEN_PSENSE_MASK 0x8
#define  PS_ESD_IEN_PSENSE_SHIFT 3
#define  PS_ESD_IEN_PSENSE_MASK_SHIFT(reg) (((reg) & PS_ESD_IEN_PSENSE_MASK) >> PS_ESD_IEN_PSENSE_SHIFT)
#define  PS_ESD_IEN_PSENSE_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_IEN_PSENSE_MASK) | (((uint32_t)val) << PS_ESD_IEN_PSENSE_SHIFT))

#define  PS_ESD_IEN_ESD_COLOR2_MASK 0x4
#define  PS_ESD_IEN_ESD_COLOR2_SHIFT 2
#define  PS_ESD_IEN_ESD_COLOR2_MASK_SHIFT(reg) (((reg) & PS_ESD_IEN_ESD_COLOR2_MASK) >> PS_ESD_IEN_ESD_COLOR2_SHIFT)
#define  PS_ESD_IEN_ESD_COLOR2_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_IEN_ESD_COLOR2_MASK) | (((uint32_t)val) << PS_ESD_IEN_ESD_COLOR2_SHIFT))

#define  PS_ESD_IEN_ESD_COLOR1_MASK 0x2
#define  PS_ESD_IEN_ESD_COLOR1_SHIFT 1
#define  PS_ESD_IEN_ESD_COLOR1_MASK_SHIFT(reg) (((reg) & PS_ESD_IEN_ESD_COLOR1_MASK) >> PS_ESD_IEN_ESD_COLOR1_SHIFT)
#define  PS_ESD_IEN_ESD_COLOR1_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_IEN_ESD_COLOR1_MASK) | (((uint32_t)val) << PS_ESD_IEN_ESD_COLOR1_SHIFT))

#define  PS_ESD_IEN_ESD_COLOR0_MASK 0x1
#define  PS_ESD_IEN_ESD_COLOR0_SHIFT 0
#define  PS_ESD_IEN_ESD_COLOR0_MASK_SHIFT(reg) (((reg) & PS_ESD_IEN_ESD_COLOR0_MASK) >> PS_ESD_IEN_ESD_COLOR0_SHIFT)
#define  PS_ESD_IEN_ESD_COLOR0_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_IEN_ESD_COLOR0_MASK) | (((uint32_t)val) << PS_ESD_IEN_ESD_COLOR0_SHIFT))

//====================================================================
//Register: Interrupt Pending Register (IPEND)
/** \brief Interrupt Pending*/
//====================================================================

#define  PS_ESD_IPEND_RESERVED1_MASK 0xfffffff0
#define  PS_ESD_IPEND_RESERVED1_SHIFT 4
#define  PS_ESD_IPEND_RESERVED1_MASK_SHIFT(reg) (((reg) & PS_ESD_IPEND_RESERVED1_MASK) >> PS_ESD_IPEND_RESERVED1_SHIFT)
#define  PS_ESD_IPEND_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_IPEND_RESERVED1_MASK) | (((uint32_t)val) << PS_ESD_IPEND_RESERVED1_SHIFT))

#define  PS_ESD_IPEND_PSENSE_MASK 0x8
#define  PS_ESD_IPEND_PSENSE_SHIFT 3
#define  PS_ESD_IPEND_PSENSE_MASK_SHIFT(reg) (((reg) & PS_ESD_IPEND_PSENSE_MASK) >> PS_ESD_IPEND_PSENSE_SHIFT)
#define  PS_ESD_IPEND_PSENSE_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_IPEND_PSENSE_MASK) | (((uint32_t)val) << PS_ESD_IPEND_PSENSE_SHIFT))

#define  PS_ESD_IPEND_ESD_COLOR2_MASK 0x4
#define  PS_ESD_IPEND_ESD_COLOR2_SHIFT 2
#define  PS_ESD_IPEND_ESD_COLOR2_MASK_SHIFT(reg) (((reg) & PS_ESD_IPEND_ESD_COLOR2_MASK) >> PS_ESD_IPEND_ESD_COLOR2_SHIFT)
#define  PS_ESD_IPEND_ESD_COLOR2_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_IPEND_ESD_COLOR2_MASK) | (((uint32_t)val) << PS_ESD_IPEND_ESD_COLOR2_SHIFT))

#define  PS_ESD_IPEND_ESD_COLOR1_MASK 0x2
#define  PS_ESD_IPEND_ESD_COLOR1_SHIFT 1
#define  PS_ESD_IPEND_ESD_COLOR1_MASK_SHIFT(reg) (((reg) & PS_ESD_IPEND_ESD_COLOR1_MASK) >> PS_ESD_IPEND_ESD_COLOR1_SHIFT)
#define  PS_ESD_IPEND_ESD_COLOR1_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_IPEND_ESD_COLOR1_MASK) | (((uint32_t)val) << PS_ESD_IPEND_ESD_COLOR1_SHIFT))

#define  PS_ESD_IPEND_ESD_COLOR0_MASK 0x1
#define  PS_ESD_IPEND_ESD_COLOR0_SHIFT 0
#define  PS_ESD_IPEND_ESD_COLOR0_MASK_SHIFT(reg) (((reg) & PS_ESD_IPEND_ESD_COLOR0_MASK) >> PS_ESD_IPEND_ESD_COLOR0_SHIFT)
#define  PS_ESD_IPEND_ESD_COLOR0_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_IPEND_ESD_COLOR0_MASK) | (((uint32_t)val) << PS_ESD_IPEND_ESD_COLOR0_SHIFT))

//====================================================================
//Register: Interrupt Acknowledge Register (IACK)
/** \brief Interrupt Acknowledge.*/
//====================================================================

#define  PS_ESD_IACK_RESERVED1_MASK 0xfffffff0
#define  PS_ESD_IACK_RESERVED1_SHIFT 4
#define  PS_ESD_IACK_RESERVED1_MASK_SHIFT(reg) (((reg) & PS_ESD_IACK_RESERVED1_MASK) >> PS_ESD_IACK_RESERVED1_SHIFT)
#define  PS_ESD_IACK_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_IACK_RESERVED1_MASK) | (((uint32_t)val) << PS_ESD_IACK_RESERVED1_SHIFT))

#define  PS_ESD_IACK_PSENSE_MASK 0x8
#define  PS_ESD_IACK_PSENSE_SHIFT 3
#define  PS_ESD_IACK_PSENSE_MASK_SHIFT(reg) (((reg) & PS_ESD_IACK_PSENSE_MASK) >> PS_ESD_IACK_PSENSE_SHIFT)
#define  PS_ESD_IACK_PSENSE_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_IACK_PSENSE_MASK) | (((uint32_t)val) << PS_ESD_IACK_PSENSE_SHIFT))

#define  PS_ESD_IACK_ESD_COLOR2_MASK 0x4
#define  PS_ESD_IACK_ESD_COLOR2_SHIFT 2
#define  PS_ESD_IACK_ESD_COLOR2_MASK_SHIFT(reg) (((reg) & PS_ESD_IACK_ESD_COLOR2_MASK) >> PS_ESD_IACK_ESD_COLOR2_SHIFT)
#define  PS_ESD_IACK_ESD_COLOR2_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_IACK_ESD_COLOR2_MASK) | (((uint32_t)val) << PS_ESD_IACK_ESD_COLOR2_SHIFT))

#define  PS_ESD_IACK_ESD_COLOR1_MASK 0x2
#define  PS_ESD_IACK_ESD_COLOR1_SHIFT 1
#define  PS_ESD_IACK_ESD_COLOR1_MASK_SHIFT(reg) (((reg) & PS_ESD_IACK_ESD_COLOR1_MASK) >> PS_ESD_IACK_ESD_COLOR1_SHIFT)
#define  PS_ESD_IACK_ESD_COLOR1_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_IACK_ESD_COLOR1_MASK) | (((uint32_t)val) << PS_ESD_IACK_ESD_COLOR1_SHIFT))

#define  PS_ESD_IACK_ESD_COLOR0_MASK 0x1
#define  PS_ESD_IACK_ESD_COLOR0_SHIFT 0
#define  PS_ESD_IACK_ESD_COLOR0_MASK_SHIFT(reg) (((reg) & PS_ESD_IACK_ESD_COLOR0_MASK) >> PS_ESD_IACK_ESD_COLOR0_SHIFT)
#define  PS_ESD_IACK_ESD_COLOR0_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_IACK_ESD_COLOR0_MASK) | (((uint32_t)val) << PS_ESD_IACK_ESD_COLOR0_SHIFT))

//====================================================================
//Register: Interrupt Force Register (IFORCE)
/** \brief Interrupt Force.*/
//====================================================================

#define  PS_ESD_IFORCE_RESERVED1_MASK 0xfffffff0
#define  PS_ESD_IFORCE_RESERVED1_SHIFT 4
#define  PS_ESD_IFORCE_RESERVED1_MASK_SHIFT(reg) (((reg) & PS_ESD_IFORCE_RESERVED1_MASK) >> PS_ESD_IFORCE_RESERVED1_SHIFT)
#define  PS_ESD_IFORCE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_IFORCE_RESERVED1_MASK) | (((uint32_t)val) << PS_ESD_IFORCE_RESERVED1_SHIFT))

#define  PS_ESD_IFORCE_PSENSE_MASK 0x8
#define  PS_ESD_IFORCE_PSENSE_SHIFT 3
#define  PS_ESD_IFORCE_PSENSE_MASK_SHIFT(reg) (((reg) & PS_ESD_IFORCE_PSENSE_MASK) >> PS_ESD_IFORCE_PSENSE_SHIFT)
#define  PS_ESD_IFORCE_PSENSE_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_IFORCE_PSENSE_MASK) | (((uint32_t)val) << PS_ESD_IFORCE_PSENSE_SHIFT))

#define  PS_ESD_IFORCE_ESD_COLOR2_MASK 0x4
#define  PS_ESD_IFORCE_ESD_COLOR2_SHIFT 2
#define  PS_ESD_IFORCE_ESD_COLOR2_MASK_SHIFT(reg) (((reg) & PS_ESD_IFORCE_ESD_COLOR2_MASK) >> PS_ESD_IFORCE_ESD_COLOR2_SHIFT)
#define  PS_ESD_IFORCE_ESD_COLOR2_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_IFORCE_ESD_COLOR2_MASK) | (((uint32_t)val) << PS_ESD_IFORCE_ESD_COLOR2_SHIFT))

#define  PS_ESD_IFORCE_ESD_COLOR1_MASK 0x2
#define  PS_ESD_IFORCE_ESD_COLOR1_SHIFT 1
#define  PS_ESD_IFORCE_ESD_COLOR1_MASK_SHIFT(reg) (((reg) & PS_ESD_IFORCE_ESD_COLOR1_MASK) >> PS_ESD_IFORCE_ESD_COLOR1_SHIFT)
#define  PS_ESD_IFORCE_ESD_COLOR1_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_IFORCE_ESD_COLOR1_MASK) | (((uint32_t)val) << PS_ESD_IFORCE_ESD_COLOR1_SHIFT))

#define  PS_ESD_IFORCE_ESD_COLOR0_MASK 0x1
#define  PS_ESD_IFORCE_ESD_COLOR0_SHIFT 0
#define  PS_ESD_IFORCE_ESD_COLOR0_MASK_SHIFT(reg) (((reg) & PS_ESD_IFORCE_ESD_COLOR0_MASK) >> PS_ESD_IFORCE_ESD_COLOR0_SHIFT)
#define  PS_ESD_IFORCE_ESD_COLOR0_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_IFORCE_ESD_COLOR0_MASK) | (((uint32_t)val) << PS_ESD_IFORCE_ESD_COLOR0_SHIFT))

//====================================================================
//Register: IP Tagging Revision 0 (REV0)
/** \brief Provide means for firmware to read IP tagging information.
      This register of particular interest to firmware.*/
//====================================================================

#define  PS_ESD_REV0_MAJ_MASK 0xffff0000
#define  PS_ESD_REV0_MAJ_SHIFT 16
#define  PS_ESD_REV0_MAJ_MASK_SHIFT(reg) (((reg) & PS_ESD_REV0_MAJ_MASK) >> PS_ESD_REV0_MAJ_SHIFT)
#define  PS_ESD_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_REV0_MAJ_MASK) | (((uint32_t)val) << PS_ESD_REV0_MAJ_SHIFT))

#define  PS_ESD_REV0_MID_MASK 0xffff
#define  PS_ESD_REV0_MID_SHIFT 0
#define  PS_ESD_REV0_MID_MASK_SHIFT(reg) (((reg) & PS_ESD_REV0_MID_MASK) >> PS_ESD_REV0_MID_SHIFT)
#define  PS_ESD_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_REV0_MID_MASK) | (((uint32_t)val) << PS_ESD_REV0_MID_SHIFT))

//====================================================================
//Register: IP Tagging Revision 1 (REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  PS_ESD_REV1_RESERVED1_MASK 0xffff0000
#define  PS_ESD_REV1_RESERVED1_SHIFT 16
#define  PS_ESD_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & PS_ESD_REV1_RESERVED1_MASK) >> PS_ESD_REV1_RESERVED1_SHIFT)
#define  PS_ESD_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_REV1_RESERVED1_MASK) | (((uint32_t)val) << PS_ESD_REV1_RESERVED1_SHIFT))

#define  PS_ESD_REV1_CFG_MASK 0xffff
#define  PS_ESD_REV1_CFG_SHIFT 0
#define  PS_ESD_REV1_CFG_MASK_SHIFT(reg) (((reg) & PS_ESD_REV1_CFG_MASK) >> PS_ESD_REV1_CFG_SHIFT)
#define  PS_ESD_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~PS_ESD_REV1_CFG_MASK) | (((uint32_t)val) << PS_ESD_REV1_CFG_SHIFT))

//====================================================================
//
//Register File: PIC Horizontal FIR (HFIR)
/** \brief Register file for the HFIR block (rev 0 . 2 . 2 . 6)*/
//
//====================================================================

//====================================================================
//Register: HFIR Configuration Register (Cfg)
/** \brief This register configures the major features of the HFIR module*/
//====================================================================

#define  HFIR_CFG_RESERVED1_MASK 0xffff0000
#define  HFIR_CFG_RESERVED1_SHIFT 16
#define  HFIR_CFG_RESERVED1_MASK_SHIFT(reg) (((reg) & HFIR_CFG_RESERVED1_MASK) >> HFIR_CFG_RESERVED1_SHIFT)
#define  HFIR_CFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~HFIR_CFG_RESERVED1_MASK) | (((uint32_t)val) << HFIR_CFG_RESERVED1_SHIFT))

#define  HFIR_CFG_BCONFIGDATA_MASK 0xfff0
#define  HFIR_CFG_BCONFIGDATA_SHIFT 4
#define  HFIR_CFG_BCONFIGDATA_MASK_SHIFT(reg) (((reg) & HFIR_CFG_BCONFIGDATA_MASK) >> HFIR_CFG_BCONFIGDATA_SHIFT)
#define  HFIR_CFG_BCONFIGDATA_REPLACE_VAL(reg,val) (((reg) & ~HFIR_CFG_BCONFIGDATA_MASK) | (((uint32_t)val) << HFIR_CFG_BCONFIGDATA_SHIFT))

#define  HFIR_CFG_RESERVED2_MASK 0x8
#define  HFIR_CFG_RESERVED2_SHIFT 3
#define  HFIR_CFG_RESERVED2_MASK_SHIFT(reg) (((reg) & HFIR_CFG_RESERVED2_MASK) >> HFIR_CFG_RESERVED2_SHIFT)
#define  HFIR_CFG_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~HFIR_CFG_RESERVED2_MASK) | (((uint32_t)val) << HFIR_CFG_RESERVED2_SHIFT))

#define  HFIR_CFG_BCONFIG_MASK 0x4
#define  HFIR_CFG_BCONFIG_SHIFT 2
#define  HFIR_CFG_BCONFIG_MASK_SHIFT(reg) (((reg) & HFIR_CFG_BCONFIG_MASK) >> HFIR_CFG_BCONFIG_SHIFT)
#define  HFIR_CFG_BCONFIG_REPLACE_VAL(reg,val) (((reg) & ~HFIR_CFG_BCONFIG_MASK) | (((uint32_t)val) << HFIR_CFG_BCONFIG_SHIFT))

#define  HFIR_CFG_EVEN_MASK 0x2
#define  HFIR_CFG_EVEN_SHIFT 1
#define  HFIR_CFG_EVEN_MASK_SHIFT(reg) (((reg) & HFIR_CFG_EVEN_MASK) >> HFIR_CFG_EVEN_SHIFT)
#define  HFIR_CFG_EVEN_REPLACE_VAL(reg,val) (((reg) & ~HFIR_CFG_EVEN_MASK) | (((uint32_t)val) << HFIR_CFG_EVEN_SHIFT))

#define  HFIR_CFG_BYPASS_MASK 0x1
#define  HFIR_CFG_BYPASS_SHIFT 0
#define  HFIR_CFG_BYPASS_MASK_SHIFT(reg) (((reg) & HFIR_CFG_BYPASS_MASK) >> HFIR_CFG_BYPASS_SHIFT)
#define  HFIR_CFG_BYPASS_REPLACE_VAL(reg,val) (((reg) & ~HFIR_CFG_BYPASS_MASK) | (((uint32_t)val) << HFIR_CFG_BYPASS_SHIFT))

//====================================================================
//Register: HFIR Coefficient set 0 and 1 (coeff0_1)
/** \brief This register sets coefficient value for set 0 and 1*/
//====================================================================

#define  HFIR_COEFF0_1_COEFF1_MASK 0xffff0000
#define  HFIR_COEFF0_1_COEFF1_SHIFT 16
#define  HFIR_COEFF0_1_COEFF1_MASK_SHIFT(reg) (((reg) & HFIR_COEFF0_1_COEFF1_MASK) >> HFIR_COEFF0_1_COEFF1_SHIFT)
#define  HFIR_COEFF0_1_COEFF1_REPLACE_VAL(reg,val) (((reg) & ~HFIR_COEFF0_1_COEFF1_MASK) | (((uint32_t)val) << HFIR_COEFF0_1_COEFF1_SHIFT))

#define  HFIR_COEFF0_1_COEFF0_MASK 0xffff
#define  HFIR_COEFF0_1_COEFF0_SHIFT 0
#define  HFIR_COEFF0_1_COEFF0_MASK_SHIFT(reg) (((reg) & HFIR_COEFF0_1_COEFF0_MASK) >> HFIR_COEFF0_1_COEFF0_SHIFT)
#define  HFIR_COEFF0_1_COEFF0_REPLACE_VAL(reg,val) (((reg) & ~HFIR_COEFF0_1_COEFF0_MASK) | (((uint32_t)val) << HFIR_COEFF0_1_COEFF0_SHIFT))

//====================================================================
//Register: HFIR Coefficient set 2 and 3 (coeff2_3)
/** \brief This register sets coefficient value for set 2 and 3*/
//====================================================================

#define  HFIR_COEFF2_3_COEFF3_MASK 0xffff0000
#define  HFIR_COEFF2_3_COEFF3_SHIFT 16
#define  HFIR_COEFF2_3_COEFF3_MASK_SHIFT(reg) (((reg) & HFIR_COEFF2_3_COEFF3_MASK) >> HFIR_COEFF2_3_COEFF3_SHIFT)
#define  HFIR_COEFF2_3_COEFF3_REPLACE_VAL(reg,val) (((reg) & ~HFIR_COEFF2_3_COEFF3_MASK) | (((uint32_t)val) << HFIR_COEFF2_3_COEFF3_SHIFT))

#define  HFIR_COEFF2_3_COEFF2_MASK 0xffff
#define  HFIR_COEFF2_3_COEFF2_SHIFT 0
#define  HFIR_COEFF2_3_COEFF2_MASK_SHIFT(reg) (((reg) & HFIR_COEFF2_3_COEFF2_MASK) >> HFIR_COEFF2_3_COEFF2_SHIFT)
#define  HFIR_COEFF2_3_COEFF2_REPLACE_VAL(reg,val) (((reg) & ~HFIR_COEFF2_3_COEFF2_MASK) | (((uint32_t)val) << HFIR_COEFF2_3_COEFF2_SHIFT))

//====================================================================
//Register: HFIR Coefficient set 4 and 5 (coeff4_5)
/** \brief This register sets coefficient value for set 4 and 5*/
//====================================================================

#define  HFIR_COEFF4_5_COEFF5_MASK 0xffff0000
#define  HFIR_COEFF4_5_COEFF5_SHIFT 16
#define  HFIR_COEFF4_5_COEFF5_MASK_SHIFT(reg) (((reg) & HFIR_COEFF4_5_COEFF5_MASK) >> HFIR_COEFF4_5_COEFF5_SHIFT)
#define  HFIR_COEFF4_5_COEFF5_REPLACE_VAL(reg,val) (((reg) & ~HFIR_COEFF4_5_COEFF5_MASK) | (((uint32_t)val) << HFIR_COEFF4_5_COEFF5_SHIFT))

#define  HFIR_COEFF4_5_COEFF4_MASK 0xffff
#define  HFIR_COEFF4_5_COEFF4_SHIFT 0
#define  HFIR_COEFF4_5_COEFF4_MASK_SHIFT(reg) (((reg) & HFIR_COEFF4_5_COEFF4_MASK) >> HFIR_COEFF4_5_COEFF4_SHIFT)
#define  HFIR_COEFF4_5_COEFF4_REPLACE_VAL(reg,val) (((reg) & ~HFIR_COEFF4_5_COEFF4_MASK) | (((uint32_t)val) << HFIR_COEFF4_5_COEFF4_SHIFT))

//====================================================================
//Register: HFIR Coefficient set 6 and 7 (coeff6_7)
/** \brief This register sets coefficient value for set 6 and 7*/
//====================================================================

#define  HFIR_COEFF6_7_COEFF7_MASK 0xffff0000
#define  HFIR_COEFF6_7_COEFF7_SHIFT 16
#define  HFIR_COEFF6_7_COEFF7_MASK_SHIFT(reg) (((reg) & HFIR_COEFF6_7_COEFF7_MASK) >> HFIR_COEFF6_7_COEFF7_SHIFT)
#define  HFIR_COEFF6_7_COEFF7_REPLACE_VAL(reg,val) (((reg) & ~HFIR_COEFF6_7_COEFF7_MASK) | (((uint32_t)val) << HFIR_COEFF6_7_COEFF7_SHIFT))

#define  HFIR_COEFF6_7_COEFF6_MASK 0xffff
#define  HFIR_COEFF6_7_COEFF6_SHIFT 0
#define  HFIR_COEFF6_7_COEFF6_MASK_SHIFT(reg) (((reg) & HFIR_COEFF6_7_COEFF6_MASK) >> HFIR_COEFF6_7_COEFF6_SHIFT)
#define  HFIR_COEFF6_7_COEFF6_REPLACE_VAL(reg,val) (((reg) & ~HFIR_COEFF6_7_COEFF6_MASK) | (((uint32_t)val) << HFIR_COEFF6_7_COEFF6_SHIFT))

//====================================================================
//Register: HFIR Coefficient set 8 and 9 (coeff8_9)
/** \brief This register sets coefficient value for set 8 and 9*/
//====================================================================

#define  HFIR_COEFF8_9_COEFF9_MASK 0xffff0000
#define  HFIR_COEFF8_9_COEFF9_SHIFT 16
#define  HFIR_COEFF8_9_COEFF9_MASK_SHIFT(reg) (((reg) & HFIR_COEFF8_9_COEFF9_MASK) >> HFIR_COEFF8_9_COEFF9_SHIFT)
#define  HFIR_COEFF8_9_COEFF9_REPLACE_VAL(reg,val) (((reg) & ~HFIR_COEFF8_9_COEFF9_MASK) | (((uint32_t)val) << HFIR_COEFF8_9_COEFF9_SHIFT))

#define  HFIR_COEFF8_9_COEFF8_MASK 0xffff
#define  HFIR_COEFF8_9_COEFF8_SHIFT 0
#define  HFIR_COEFF8_9_COEFF8_MASK_SHIFT(reg) (((reg) & HFIR_COEFF8_9_COEFF8_MASK) >> HFIR_COEFF8_9_COEFF8_SHIFT)
#define  HFIR_COEFF8_9_COEFF8_REPLACE_VAL(reg,val) (((reg) & ~HFIR_COEFF8_9_COEFF8_MASK) | (((uint32_t)val) << HFIR_COEFF8_9_COEFF8_SHIFT))

//====================================================================
//Register: HFIR Coefficient set 10 and 11 (coeff10_11)
/** \brief This register sets coefficient value for set 10 and 11*/
//====================================================================

#define  HFIR_COEFF10_11_COEFF11_MASK 0xffff0000
#define  HFIR_COEFF10_11_COEFF11_SHIFT 16
#define  HFIR_COEFF10_11_COEFF11_MASK_SHIFT(reg) (((reg) & HFIR_COEFF10_11_COEFF11_MASK) >> HFIR_COEFF10_11_COEFF11_SHIFT)
#define  HFIR_COEFF10_11_COEFF11_REPLACE_VAL(reg,val) (((reg) & ~HFIR_COEFF10_11_COEFF11_MASK) | (((uint32_t)val) << HFIR_COEFF10_11_COEFF11_SHIFT))

#define  HFIR_COEFF10_11_COEFF10_MASK 0xffff
#define  HFIR_COEFF10_11_COEFF10_SHIFT 0
#define  HFIR_COEFF10_11_COEFF10_MASK_SHIFT(reg) (((reg) & HFIR_COEFF10_11_COEFF10_MASK) >> HFIR_COEFF10_11_COEFF10_SHIFT)
#define  HFIR_COEFF10_11_COEFF10_REPLACE_VAL(reg,val) (((reg) & ~HFIR_COEFF10_11_COEFF10_MASK) | (((uint32_t)val) << HFIR_COEFF10_11_COEFF10_SHIFT))

//====================================================================
//Register: HFIR Coefficient set 12 and 13 (coeff12_13)
/** \brief This register sets coefficient value for set 12 and 13*/
//====================================================================

#define  HFIR_COEFF12_13_COEFF13_MASK 0xffff0000
#define  HFIR_COEFF12_13_COEFF13_SHIFT 16
#define  HFIR_COEFF12_13_COEFF13_MASK_SHIFT(reg) (((reg) & HFIR_COEFF12_13_COEFF13_MASK) >> HFIR_COEFF12_13_COEFF13_SHIFT)
#define  HFIR_COEFF12_13_COEFF13_REPLACE_VAL(reg,val) (((reg) & ~HFIR_COEFF12_13_COEFF13_MASK) | (((uint32_t)val) << HFIR_COEFF12_13_COEFF13_SHIFT))

#define  HFIR_COEFF12_13_COEFF12_MASK 0xffff
#define  HFIR_COEFF12_13_COEFF12_SHIFT 0
#define  HFIR_COEFF12_13_COEFF12_MASK_SHIFT(reg) (((reg) & HFIR_COEFF12_13_COEFF12_MASK) >> HFIR_COEFF12_13_COEFF12_SHIFT)
#define  HFIR_COEFF12_13_COEFF12_REPLACE_VAL(reg,val) (((reg) & ~HFIR_COEFF12_13_COEFF12_MASK) | (((uint32_t)val) << HFIR_COEFF12_13_COEFF12_SHIFT))

//====================================================================
//Register: HFIR Coefficient set 14 and 15 (coeff14_15)
/** \brief This register sets coefficient value for set 14 and 15*/
//====================================================================

#define  HFIR_COEFF14_15_COEFF15_MASK 0xffff0000
#define  HFIR_COEFF14_15_COEFF15_SHIFT 16
#define  HFIR_COEFF14_15_COEFF15_MASK_SHIFT(reg) (((reg) & HFIR_COEFF14_15_COEFF15_MASK) >> HFIR_COEFF14_15_COEFF15_SHIFT)
#define  HFIR_COEFF14_15_COEFF15_REPLACE_VAL(reg,val) (((reg) & ~HFIR_COEFF14_15_COEFF15_MASK) | (((uint32_t)val) << HFIR_COEFF14_15_COEFF15_SHIFT))

#define  HFIR_COEFF14_15_COEFF14_MASK 0xffff
#define  HFIR_COEFF14_15_COEFF14_SHIFT 0
#define  HFIR_COEFF14_15_COEFF14_MASK_SHIFT(reg) (((reg) & HFIR_COEFF14_15_COEFF14_MASK) >> HFIR_COEFF14_15_COEFF14_SHIFT)
#define  HFIR_COEFF14_15_COEFF14_REPLACE_VAL(reg,val) (((reg) & ~HFIR_COEFF14_15_COEFF14_MASK) | (((uint32_t)val) << HFIR_COEFF14_15_COEFF14_SHIFT))

//====================================================================
//Register: Check Sum (CSum)
/** \brief This register is used for debug and test only*/
//====================================================================

#define  HFIR_CSUM_CSUM_MASK 0xffffffff
#define  HFIR_CSUM_CSUM_SHIFT 0
#define  HFIR_CSUM_CSUM_MASK_SHIFT(reg) (((reg) & HFIR_CSUM_CSUM_MASK) >> HFIR_CSUM_CSUM_SHIFT)
#define  HFIR_CSUM_CSUM_REPLACE_VAL(reg,val) (((reg) & ~HFIR_CSUM_CSUM_MASK) | (((uint32_t)val) << HFIR_CSUM_CSUM_SHIFT))

//====================================================================
//Register: IP Tagging Revision 0 (REV0)
/** \brief Provide means for firmware to read IP tagging information.
      This register of particular interest to firmware.*/
//====================================================================

#define  HFIR_REV0_MAJ_MASK 0xffff0000
#define  HFIR_REV0_MAJ_SHIFT 16
#define  HFIR_REV0_MAJ_MASK_SHIFT(reg) (((reg) & HFIR_REV0_MAJ_MASK) >> HFIR_REV0_MAJ_SHIFT)
#define  HFIR_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~HFIR_REV0_MAJ_MASK) | (((uint32_t)val) << HFIR_REV0_MAJ_SHIFT))

#define  HFIR_REV0_MID_MASK 0xffff
#define  HFIR_REV0_MID_SHIFT 0
#define  HFIR_REV0_MID_MASK_SHIFT(reg) (((reg) & HFIR_REV0_MID_MASK) >> HFIR_REV0_MID_SHIFT)
#define  HFIR_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~HFIR_REV0_MID_MASK) | (((uint32_t)val) << HFIR_REV0_MID_SHIFT))

//====================================================================
//Register: IP Tagging Revision 1 (REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  HFIR_REV1_RESERVED1_MASK 0xffff0000
#define  HFIR_REV1_RESERVED1_SHIFT 16
#define  HFIR_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & HFIR_REV1_RESERVED1_MASK) >> HFIR_REV1_RESERVED1_SHIFT)
#define  HFIR_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~HFIR_REV1_RESERVED1_MASK) | (((uint32_t)val) << HFIR_REV1_RESERVED1_SHIFT))

#define  HFIR_REV1_CFG_MASK 0xffff
#define  HFIR_REV1_CFG_SHIFT 0
#define  HFIR_REV1_CFG_MASK_SHIFT(reg) (((reg) & HFIR_REV1_CFG_MASK) >> HFIR_REV1_CFG_SHIFT)
#define  HFIR_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~HFIR_REV1_CFG_MASK) | (((uint32_t)val) << HFIR_REV1_CFG_SHIFT))

//====================================================================
//
//Register File: PIC Horizontal Scale (HScale)
/** \brief Register Descriptions for the PIC HScale block (rev 0 . 2 . 2 . 5)*/
//
//====================================================================

//====================================================================
//Register: Horizontal Scaler Configuration Register (HSCR)
/** \brief General configuration register for HScale block.*/
//====================================================================

#define  HSCALE_HSCR_RESERVED1_MASK 0xfffffffe
#define  HSCALE_HSCR_RESERVED1_SHIFT 1
#define  HSCALE_HSCR_RESERVED1_MASK_SHIFT(reg) (((reg) & HSCALE_HSCR_RESERVED1_MASK) >> HSCALE_HSCR_RESERVED1_SHIFT)
#define  HSCALE_HSCR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~HSCALE_HSCR_RESERVED1_MASK) | (((uint32_t)val) << HSCALE_HSCR_RESERVED1_SHIFT))

#define  HSCALE_HSCR_BYPASS_MASK 0x1
#define  HSCALE_HSCR_BYPASS_SHIFT 0
#define  HSCALE_HSCR_BYPASS_MASK_SHIFT(reg) (((reg) & HSCALE_HSCR_BYPASS_MASK) >> HSCALE_HSCR_BYPASS_SHIFT)
#define  HSCALE_HSCR_BYPASS_REPLACE_VAL(reg,val) (((reg) & ~HSCALE_HSCR_BYPASS_MASK) | (((uint32_t)val) << HSCALE_HSCR_BYPASS_SHIFT))

//====================================================================
//Register: Horizontal Scaler Scale Register (HSSR)
/** \brief Horizontal Scaler Scale Factor*/
//====================================================================

#define  HSCALE_HSSR_RESERVED1_MASK 0xfffe0000
#define  HSCALE_HSSR_RESERVED1_SHIFT 17
#define  HSCALE_HSSR_RESERVED1_MASK_SHIFT(reg) (((reg) & HSCALE_HSSR_RESERVED1_MASK) >> HSCALE_HSSR_RESERVED1_SHIFT)
#define  HSCALE_HSSR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~HSCALE_HSSR_RESERVED1_MASK) | (((uint32_t)val) << HSCALE_HSSR_RESERVED1_SHIFT))

#define  HSCALE_HSSR_SCALE_MASK 0x1ffff
#define  HSCALE_HSSR_SCALE_SHIFT 0
#define  HSCALE_HSSR_SCALE_MASK_SHIFT(reg) (((reg) & HSCALE_HSSR_SCALE_MASK) >> HSCALE_HSSR_SCALE_SHIFT)
#define  HSCALE_HSSR_SCALE_REPLACE_VAL(reg,val) (((reg) & ~HSCALE_HSSR_SCALE_MASK) | (((uint32_t)val) << HSCALE_HSSR_SCALE_SHIFT))

//====================================================================
//Register: IP Tagging Revision 0 (REV0)
/** \brief Provide means for firmware to read IP tagging information.
      This register of particular interest to firmware.*/
//====================================================================

#define  HSCALE_REV0_MAJ_MASK 0xffff0000
#define  HSCALE_REV0_MAJ_SHIFT 16
#define  HSCALE_REV0_MAJ_MASK_SHIFT(reg) (((reg) & HSCALE_REV0_MAJ_MASK) >> HSCALE_REV0_MAJ_SHIFT)
#define  HSCALE_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~HSCALE_REV0_MAJ_MASK) | (((uint32_t)val) << HSCALE_REV0_MAJ_SHIFT))

#define  HSCALE_REV0_MID_MASK 0xffff
#define  HSCALE_REV0_MID_SHIFT 0
#define  HSCALE_REV0_MID_MASK_SHIFT(reg) (((reg) & HSCALE_REV0_MID_MASK) >> HSCALE_REV0_MID_SHIFT)
#define  HSCALE_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~HSCALE_REV0_MID_MASK) | (((uint32_t)val) << HSCALE_REV0_MID_SHIFT))

//====================================================================
//Register: IP Tagging Revision 1 (REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  HSCALE_REV1_RESERVED1_MASK 0xffff0000
#define  HSCALE_REV1_RESERVED1_SHIFT 16
#define  HSCALE_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & HSCALE_REV1_RESERVED1_MASK) >> HSCALE_REV1_RESERVED1_SHIFT)
#define  HSCALE_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~HSCALE_REV1_RESERVED1_MASK) | (((uint32_t)val) << HSCALE_REV1_RESERVED1_SHIFT))

#define  HSCALE_REV1_CFG_MASK 0xffff
#define  HSCALE_REV1_CFG_SHIFT 0
#define  HSCALE_REV1_CFG_MASK_SHIFT(reg) (((reg) & HSCALE_REV1_CFG_MASK) >> HSCALE_REV1_CFG_SHIFT)
#define  HSCALE_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~HSCALE_REV1_CFG_MASK) | (((uint32_t)val) << HSCALE_REV1_CFG_SHIFT))

//====================================================================
//
//Register File: PIC L/R Margin1 (LRMargin1)
/** \brief Register Descriptions for the PIC LRMargin block (rev 0 . 2 . 3 . 8)*/
//
//====================================================================

//====================================================================
//Register: Left/Right Margins Configuration Register (LRCR)
/** \brief General configuration register for LRMargin block.*/
//====================================================================

#define  LRMARGIN1_LRCR_BYPASS_MASK 0x80000000
#define  LRMARGIN1_LRCR_BYPASS_SHIFT 31
#define  LRMARGIN1_LRCR_BYPASS_MASK_SHIFT(reg) (((reg) & LRMARGIN1_LRCR_BYPASS_MASK) >> LRMARGIN1_LRCR_BYPASS_SHIFT)
#define  LRMARGIN1_LRCR_BYPASS_REPLACE_VAL(reg,val) (((reg) & ~LRMARGIN1_LRCR_BYPASS_MASK) | (((uint32_t)val) << LRMARGIN1_LRCR_BYPASS_SHIFT))

#define  LRMARGIN1_LRCR_RESERVED1_MASK 0x7fffffff
#define  LRMARGIN1_LRCR_RESERVED1_SHIFT 0
#define  LRMARGIN1_LRCR_RESERVED1_MASK_SHIFT(reg) (((reg) & LRMARGIN1_LRCR_RESERVED1_MASK) >> LRMARGIN1_LRCR_RESERVED1_SHIFT)
#define  LRMARGIN1_LRCR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~LRMARGIN1_LRCR_RESERVED1_MASK) | (((uint32_t)val) << LRMARGIN1_LRCR_RESERVED1_SHIFT))

//====================================================================
//Register: Left/Right Margins Register (LRMR0)
//====================================================================

#define  LRMARGIN1_LRMR0_RIGHTMARGINC0_MASK 0xffff0000
#define  LRMARGIN1_LRMR0_RIGHTMARGINC0_SHIFT 16
#define  LRMARGIN1_LRMR0_RIGHTMARGINC0_MASK_SHIFT(reg) (((reg) & LRMARGIN1_LRMR0_RIGHTMARGINC0_MASK) >> LRMARGIN1_LRMR0_RIGHTMARGINC0_SHIFT)
#define  LRMARGIN1_LRMR0_RIGHTMARGINC0_REPLACE_VAL(reg,val) (((reg) & ~LRMARGIN1_LRMR0_RIGHTMARGINC0_MASK) | (((uint32_t)val) << LRMARGIN1_LRMR0_RIGHTMARGINC0_SHIFT))

#define  LRMARGIN1_LRMR0_LEFTMARGINC0_MASK 0xffff
#define  LRMARGIN1_LRMR0_LEFTMARGINC0_SHIFT 0
#define  LRMARGIN1_LRMR0_LEFTMARGINC0_MASK_SHIFT(reg) (((reg) & LRMARGIN1_LRMR0_LEFTMARGINC0_MASK) >> LRMARGIN1_LRMR0_LEFTMARGINC0_SHIFT)
#define  LRMARGIN1_LRMR0_LEFTMARGINC0_REPLACE_VAL(reg,val) (((reg) & ~LRMARGIN1_LRMR0_LEFTMARGINC0_MASK) | (((uint32_t)val) << LRMARGIN1_LRMR0_LEFTMARGINC0_SHIFT))

//====================================================================
//Register: Left/Right Margins Register (LRMR1)
//====================================================================

#define  LRMARGIN1_LRMR1_RIGHTMARGINC1_MASK 0xffff0000
#define  LRMARGIN1_LRMR1_RIGHTMARGINC1_SHIFT 16
#define  LRMARGIN1_LRMR1_RIGHTMARGINC1_MASK_SHIFT(reg) (((reg) & LRMARGIN1_LRMR1_RIGHTMARGINC1_MASK) >> LRMARGIN1_LRMR1_RIGHTMARGINC1_SHIFT)
#define  LRMARGIN1_LRMR1_RIGHTMARGINC1_REPLACE_VAL(reg,val) (((reg) & ~LRMARGIN1_LRMR1_RIGHTMARGINC1_MASK) | (((uint32_t)val) << LRMARGIN1_LRMR1_RIGHTMARGINC1_SHIFT))

#define  LRMARGIN1_LRMR1_LEFTMARGINC1_MASK 0xffff
#define  LRMARGIN1_LRMR1_LEFTMARGINC1_SHIFT 0
#define  LRMARGIN1_LRMR1_LEFTMARGINC1_MASK_SHIFT(reg) (((reg) & LRMARGIN1_LRMR1_LEFTMARGINC1_MASK) >> LRMARGIN1_LRMR1_LEFTMARGINC1_SHIFT)
#define  LRMARGIN1_LRMR1_LEFTMARGINC1_REPLACE_VAL(reg,val) (((reg) & ~LRMARGIN1_LRMR1_LEFTMARGINC1_MASK) | (((uint32_t)val) << LRMARGIN1_LRMR1_LEFTMARGINC1_SHIFT))

//====================================================================
//Register: Left/Right Margins Register (LRMR2)
//====================================================================

#define  LRMARGIN1_LRMR2_RIGHTMARGINC2_MASK 0xffff0000
#define  LRMARGIN1_LRMR2_RIGHTMARGINC2_SHIFT 16
#define  LRMARGIN1_LRMR2_RIGHTMARGINC2_MASK_SHIFT(reg) (((reg) & LRMARGIN1_LRMR2_RIGHTMARGINC2_MASK) >> LRMARGIN1_LRMR2_RIGHTMARGINC2_SHIFT)
#define  LRMARGIN1_LRMR2_RIGHTMARGINC2_REPLACE_VAL(reg,val) (((reg) & ~LRMARGIN1_LRMR2_RIGHTMARGINC2_MASK) | (((uint32_t)val) << LRMARGIN1_LRMR2_RIGHTMARGINC2_SHIFT))

#define  LRMARGIN1_LRMR2_LEFTMARGINC2_MASK 0xffff
#define  LRMARGIN1_LRMR2_LEFTMARGINC2_SHIFT 0
#define  LRMARGIN1_LRMR2_LEFTMARGINC2_MASK_SHIFT(reg) (((reg) & LRMARGIN1_LRMR2_LEFTMARGINC2_MASK) >> LRMARGIN1_LRMR2_LEFTMARGINC2_SHIFT)
#define  LRMARGIN1_LRMR2_LEFTMARGINC2_REPLACE_VAL(reg,val) (((reg) & ~LRMARGIN1_LRMR2_LEFTMARGINC2_MASK) | (((uint32_t)val) << LRMARGIN1_LRMR2_LEFTMARGINC2_SHIFT))

//====================================================================
//Register: IP Tagging Revision 0 (REV0)
/** \brief Provide means for firmware to read IP tagging information.
      This register of particular interest to firmware.*/
//====================================================================

#define  LRMARGIN1_REV0_MAJ_MASK 0xffff0000
#define  LRMARGIN1_REV0_MAJ_SHIFT 16
#define  LRMARGIN1_REV0_MAJ_MASK_SHIFT(reg) (((reg) & LRMARGIN1_REV0_MAJ_MASK) >> LRMARGIN1_REV0_MAJ_SHIFT)
#define  LRMARGIN1_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~LRMARGIN1_REV0_MAJ_MASK) | (((uint32_t)val) << LRMARGIN1_REV0_MAJ_SHIFT))

#define  LRMARGIN1_REV0_MID_MASK 0xffff
#define  LRMARGIN1_REV0_MID_SHIFT 0
#define  LRMARGIN1_REV0_MID_MASK_SHIFT(reg) (((reg) & LRMARGIN1_REV0_MID_MASK) >> LRMARGIN1_REV0_MID_SHIFT)
#define  LRMARGIN1_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~LRMARGIN1_REV0_MID_MASK) | (((uint32_t)val) << LRMARGIN1_REV0_MID_SHIFT))

//====================================================================
//Register: IP Tagging Revision 1 (REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  LRMARGIN1_REV1_RESERVED1_MASK 0xffff0000
#define  LRMARGIN1_REV1_RESERVED1_SHIFT 16
#define  LRMARGIN1_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & LRMARGIN1_REV1_RESERVED1_MASK) >> LRMARGIN1_REV1_RESERVED1_SHIFT)
#define  LRMARGIN1_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~LRMARGIN1_REV1_RESERVED1_MASK) | (((uint32_t)val) << LRMARGIN1_REV1_RESERVED1_SHIFT))

#define  LRMARGIN1_REV1_CFG_MASK 0xffff
#define  LRMARGIN1_REV1_CFG_SHIFT 0
#define  LRMARGIN1_REV1_CFG_MASK_SHIFT(reg) (((reg) & LRMARGIN1_REV1_CFG_MASK) >> LRMARGIN1_REV1_CFG_SHIFT)
#define  LRMARGIN1_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~LRMARGIN1_REV1_CFG_MASK) | (((uint32_t)val) << LRMARGIN1_REV1_CFG_SHIFT))

//====================================================================
//
//Register File: PIC DMA Write (PIC_WDMA)
/** \brief Register Descriptions for the multi-channel PIC WDMA block (rev 0 . 2 . 4 . 4)*/
//
//====================================================================

//====================================================================
//Register: PIC WDMA Configuration Register (DWOCR)
/** \brief General configuration register for all DMAs in this block.*/
//====================================================================

#define  PIC_WDMA_DWOCR_RESERVED1_MASK 0xfffc0000
#define  PIC_WDMA_DWOCR_RESERVED1_SHIFT 18
#define  PIC_WDMA_DWOCR_RESERVED1_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DWOCR_RESERVED1_MASK) >> PIC_WDMA_DWOCR_RESERVED1_SHIFT)
#define  PIC_WDMA_DWOCR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DWOCR_RESERVED1_MASK) | (((uint32_t)val) << PIC_WDMA_DWOCR_RESERVED1_SHIFT))

#define  PIC_WDMA_DWOCR_DISABLEMODE_MASK 0x30000
#define  PIC_WDMA_DWOCR_DISABLEMODE_SHIFT 16
#define  PIC_WDMA_DWOCR_DISABLEMODE_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DWOCR_DISABLEMODE_MASK) >> PIC_WDMA_DWOCR_DISABLEMODE_SHIFT)
#define  PIC_WDMA_DWOCR_DISABLEMODE_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DWOCR_DISABLEMODE_MASK) | (((uint32_t)val) << PIC_WDMA_DWOCR_DISABLEMODE_SHIFT))

#define  PIC_WDMA_DWOCR_RESERVED2_MASK 0xffff
#define  PIC_WDMA_DWOCR_RESERVED2_SHIFT 0
#define  PIC_WDMA_DWOCR_RESERVED2_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DWOCR_RESERVED2_MASK) >> PIC_WDMA_DWOCR_RESERVED2_SHIFT)
#define  PIC_WDMA_DWOCR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DWOCR_RESERVED2_MASK) | (((uint32_t)val) << PIC_WDMA_DWOCR_RESERVED2_SHIFT))

//====================================================================
//Register: PIC WDMA Router Table Register (DWRTBL)
/** \brief PIC Write DMA Router Table <br>
    <br>
    For all fields in this register, the value should be in the range '0-NUMBER_OF_PIC_WDMA_CHANNELS-1'. Values outside these ranges will be forced into the ranges using the 'mod' function.*/
//====================================================================

#define  PIC_WDMA_DWRTBL_RESERVED1_MASK 0xffff0000
#define  PIC_WDMA_DWRTBL_RESERVED1_SHIFT 16
#define  PIC_WDMA_DWRTBL_RESERVED1_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DWRTBL_RESERVED1_MASK) >> PIC_WDMA_DWRTBL_RESERVED1_SHIFT)
#define  PIC_WDMA_DWRTBL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DWRTBL_RESERVED1_MASK) | (((uint32_t)val) << PIC_WDMA_DWRTBL_RESERVED1_SHIFT))

#define  PIC_WDMA_DWRTBL_MONODMACRV_MASK 0xf000
#define  PIC_WDMA_DWRTBL_MONODMACRV_SHIFT 12
#define  PIC_WDMA_DWRTBL_MONODMACRV_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DWRTBL_MONODMACRV_MASK) >> PIC_WDMA_DWRTBL_MONODMACRV_SHIFT)
#define  PIC_WDMA_DWRTBL_MONODMACRV_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DWRTBL_MONODMACRV_MASK) | (((uint32_t)val) << PIC_WDMA_DWRTBL_MONODMACRV_SHIFT))

#define  PIC_WDMA_DWRTBL_COLOR2DMACRV_MASK 0xf00
#define  PIC_WDMA_DWRTBL_COLOR2DMACRV_SHIFT 8
#define  PIC_WDMA_DWRTBL_COLOR2DMACRV_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DWRTBL_COLOR2DMACRV_MASK) >> PIC_WDMA_DWRTBL_COLOR2DMACRV_SHIFT)
#define  PIC_WDMA_DWRTBL_COLOR2DMACRV_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DWRTBL_COLOR2DMACRV_MASK) | (((uint32_t)val) << PIC_WDMA_DWRTBL_COLOR2DMACRV_SHIFT))

#define  PIC_WDMA_DWRTBL_COLOR1DMACRV_MASK 0xf0
#define  PIC_WDMA_DWRTBL_COLOR1DMACRV_SHIFT 4
#define  PIC_WDMA_DWRTBL_COLOR1DMACRV_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DWRTBL_COLOR1DMACRV_MASK) >> PIC_WDMA_DWRTBL_COLOR1DMACRV_SHIFT)
#define  PIC_WDMA_DWRTBL_COLOR1DMACRV_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DWRTBL_COLOR1DMACRV_MASK) | (((uint32_t)val) << PIC_WDMA_DWRTBL_COLOR1DMACRV_SHIFT))

#define  PIC_WDMA_DWRTBL_COLOR0DMACRV_MASK 0xf
#define  PIC_WDMA_DWRTBL_COLOR0DMACRV_SHIFT 0
#define  PIC_WDMA_DWRTBL_COLOR0DMACRV_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DWRTBL_COLOR0DMACRV_MASK) >> PIC_WDMA_DWRTBL_COLOR0DMACRV_SHIFT)
#define  PIC_WDMA_DWRTBL_COLOR0DMACRV_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DWRTBL_COLOR0DMACRV_MASK) | (((uint32_t)val) << PIC_WDMA_DWRTBL_COLOR0DMACRV_SHIFT))

//====================================================================
//Register: PIC Write DMA Common Interrupt Select (DWCIS)
/** \brief DMA Channel Common Interrupt Select*/
//====================================================================

#define  PIC_WDMA_DWCIS_RESERVED1_MASK 0xfffffff8
#define  PIC_WDMA_DWCIS_RESERVED1_SHIFT 3
#define  PIC_WDMA_DWCIS_RESERVED1_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DWCIS_RESERVED1_MASK) >> PIC_WDMA_DWCIS_RESERVED1_SHIFT)
#define  PIC_WDMA_DWCIS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DWCIS_RESERVED1_MASK) | (((uint32_t)val) << PIC_WDMA_DWCIS_RESERVED1_SHIFT))

#define  PIC_WDMA_DWCIS_SELECT_MASK 0x7
#define  PIC_WDMA_DWCIS_SELECT_SHIFT 0
#define  PIC_WDMA_DWCIS_SELECT_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DWCIS_SELECT_MASK) >> PIC_WDMA_DWCIS_SELECT_SHIFT)
#define  PIC_WDMA_DWCIS_SELECT_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DWCIS_SELECT_MASK) | (((uint32_t)val) << PIC_WDMA_DWCIS_SELECT_SHIFT))

//====================================================================
//Register: IP Tagging Revision 0 (REV0)
/** \brief Provide means for firmware to read IP tagging information.
      This register of particular interest to firmware.*/
//====================================================================

#define  PIC_WDMA_REV0_MAJ_MASK 0xffff0000
#define  PIC_WDMA_REV0_MAJ_SHIFT 16
#define  PIC_WDMA_REV0_MAJ_MASK_SHIFT(reg) (((reg) & PIC_WDMA_REV0_MAJ_MASK) >> PIC_WDMA_REV0_MAJ_SHIFT)
#define  PIC_WDMA_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_REV0_MAJ_MASK) | (((uint32_t)val) << PIC_WDMA_REV0_MAJ_SHIFT))

#define  PIC_WDMA_REV0_MID_MASK 0xffff
#define  PIC_WDMA_REV0_MID_SHIFT 0
#define  PIC_WDMA_REV0_MID_MASK_SHIFT(reg) (((reg) & PIC_WDMA_REV0_MID_MASK) >> PIC_WDMA_REV0_MID_SHIFT)
#define  PIC_WDMA_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_REV0_MID_MASK) | (((uint32_t)val) << PIC_WDMA_REV0_MID_SHIFT))

//====================================================================
//Register: IP Tagging Revision 1 (REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  PIC_WDMA_REV1_RESERVED1_MASK 0xffff0000
#define  PIC_WDMA_REV1_RESERVED1_SHIFT 16
#define  PIC_WDMA_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & PIC_WDMA_REV1_RESERVED1_MASK) >> PIC_WDMA_REV1_RESERVED1_SHIFT)
#define  PIC_WDMA_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_REV1_RESERVED1_MASK) | (((uint32_t)val) << PIC_WDMA_REV1_RESERVED1_SHIFT))

#define  PIC_WDMA_REV1_CFG_MASK 0xffff
#define  PIC_WDMA_REV1_CFG_SHIFT 0
#define  PIC_WDMA_REV1_CFG_MASK_SHIFT(reg) (((reg) & PIC_WDMA_REV1_CFG_MASK) >> PIC_WDMA_REV1_CFG_SHIFT)
#define  PIC_WDMA_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_REV1_CFG_MASK) | (((uint32_t)val) << PIC_WDMA_REV1_CFG_SHIFT))

//====================================================================
//
//Register File: Skew Detect (SKEWDET)
/** \brief Register descriptions for the SKEWDET block.*/
//
//====================================================================

//====================================================================
//Register: SKEWDET Tagging Revision 0 (REV0)
/** \brief Provide means for firmware to read IP tagging information.
      This register of particular interest to firmware.*/
//====================================================================

#define  SKEWDET_REV0_MAJ_MASK 0xffff0000
#define  SKEWDET_REV0_MAJ_SHIFT 16
#define  SKEWDET_REV0_MAJ_MASK_SHIFT(reg) (((reg) & SKEWDET_REV0_MAJ_MASK) >> SKEWDET_REV0_MAJ_SHIFT)
#define  SKEWDET_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~SKEWDET_REV0_MAJ_MASK) | (((uint32_t)val) << SKEWDET_REV0_MAJ_SHIFT))

#define  SKEWDET_REV0_MID_MASK 0xffff
#define  SKEWDET_REV0_MID_SHIFT 0
#define  SKEWDET_REV0_MID_MASK_SHIFT(reg) (((reg) & SKEWDET_REV0_MID_MASK) >> SKEWDET_REV0_MID_SHIFT)
#define  SKEWDET_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~SKEWDET_REV0_MID_MASK) | (((uint32_t)val) << SKEWDET_REV0_MID_SHIFT))

//====================================================================
//Register: SKEWDET Tagging Revision 1 (REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  SKEWDET_REV1_RESERVED1_MASK 0xffff0000
#define  SKEWDET_REV1_RESERVED1_SHIFT 16
#define  SKEWDET_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & SKEWDET_REV1_RESERVED1_MASK) >> SKEWDET_REV1_RESERVED1_SHIFT)
#define  SKEWDET_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SKEWDET_REV1_RESERVED1_MASK) | (((uint32_t)val) << SKEWDET_REV1_RESERVED1_SHIFT))

#define  SKEWDET_REV1_CFG_MASK 0xffff
#define  SKEWDET_REV1_CFG_SHIFT 0
#define  SKEWDET_REV1_CFG_MASK_SHIFT(reg) (((reg) & SKEWDET_REV1_CFG_MASK) >> SKEWDET_REV1_CFG_SHIFT)
#define  SKEWDET_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~SKEWDET_REV1_CFG_MASK) | (((uint32_t)val) << SKEWDET_REV1_CFG_SHIFT))

//====================================================================
//Register: Channel Address (CA)
//====================================================================

#define  SKEWDET_CA_RESERVED1_MASK 0xfffffffc
#define  SKEWDET_CA_RESERVED1_SHIFT 2
#define  SKEWDET_CA_RESERVED1_MASK_SHIFT(reg) (((reg) & SKEWDET_CA_RESERVED1_MASK) >> SKEWDET_CA_RESERVED1_SHIFT)
#define  SKEWDET_CA_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SKEWDET_CA_RESERVED1_MASK) | (((uint32_t)val) << SKEWDET_CA_RESERVED1_SHIFT))

#define  SKEWDET_CA_ADDR_MASK 0x3
#define  SKEWDET_CA_ADDR_SHIFT 0
#define  SKEWDET_CA_ADDR_MASK_SHIFT(reg) (((reg) & SKEWDET_CA_ADDR_MASK) >> SKEWDET_CA_ADDR_SHIFT)
#define  SKEWDET_CA_ADDR_REPLACE_VAL(reg,val) (((reg) & ~SKEWDET_CA_ADDR_MASK) | (((uint32_t)val) << SKEWDET_CA_ADDR_SHIFT))

//====================================================================
//Register: Control (Ctl)
//====================================================================

#define  SKEWDET_CTL_RESERVED1_MASK 0xfffe0000
#define  SKEWDET_CTL_RESERVED1_SHIFT 17
#define  SKEWDET_CTL_RESERVED1_MASK_SHIFT(reg) (((reg) & SKEWDET_CTL_RESERVED1_MASK) >> SKEWDET_CTL_RESERVED1_SHIFT)
#define  SKEWDET_CTL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SKEWDET_CTL_RESERVED1_MASK) | (((uint32_t)val) << SKEWDET_CTL_RESERVED1_SHIFT))

#define  SKEWDET_CTL_PX_MASK 0x1f000
#define  SKEWDET_CTL_PX_SHIFT 12
#define  SKEWDET_CTL_PX_MASK_SHIFT(reg) (((reg) & SKEWDET_CTL_PX_MASK) >> SKEWDET_CTL_PX_SHIFT)
#define  SKEWDET_CTL_PX_REPLACE_VAL(reg,val) (((reg) & ~SKEWDET_CTL_PX_MASK) | (((uint32_t)val) << SKEWDET_CTL_PX_SHIFT))

#define  SKEWDET_CTL_RESERVED2_MASK 0xc00
#define  SKEWDET_CTL_RESERVED2_SHIFT 10
#define  SKEWDET_CTL_RESERVED2_MASK_SHIFT(reg) (((reg) & SKEWDET_CTL_RESERVED2_MASK) >> SKEWDET_CTL_RESERVED2_SHIFT)
#define  SKEWDET_CTL_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SKEWDET_CTL_RESERVED2_MASK) | (((uint32_t)val) << SKEWDET_CTL_RESERVED2_SHIFT))

#define  SKEWDET_CTL_ADVEDGE_MASK 0x200
#define  SKEWDET_CTL_ADVEDGE_SHIFT 9
#define  SKEWDET_CTL_ADVEDGE_MASK_SHIFT(reg) (((reg) & SKEWDET_CTL_ADVEDGE_MASK) >> SKEWDET_CTL_ADVEDGE_SHIFT)
#define  SKEWDET_CTL_ADVEDGE_REPLACE_VAL(reg,val) (((reg) & ~SKEWDET_CTL_ADVEDGE_MASK) | (((uint32_t)val) << SKEWDET_CTL_ADVEDGE_SHIFT))

#define  SKEWDET_CTL_DIVIDE_MASK 0x1c0
#define  SKEWDET_CTL_DIVIDE_SHIFT 6
#define  SKEWDET_CTL_DIVIDE_MASK_SHIFT(reg) (((reg) & SKEWDET_CTL_DIVIDE_MASK) >> SKEWDET_CTL_DIVIDE_SHIFT)
#define  SKEWDET_CTL_DIVIDE_REPLACE_VAL(reg,val) (((reg) & ~SKEWDET_CTL_DIVIDE_MASK) | (((uint32_t)val) << SKEWDET_CTL_DIVIDE_SHIFT))

#define  SKEWDET_CTL_DETECTMODE_MASK 0x30
#define  SKEWDET_CTL_DETECTMODE_SHIFT 4
#define  SKEWDET_CTL_DETECTMODE_MASK_SHIFT(reg) (((reg) & SKEWDET_CTL_DETECTMODE_MASK) >> SKEWDET_CTL_DETECTMODE_SHIFT)
#define  SKEWDET_CTL_DETECTMODE_REPLACE_VAL(reg,val) (((reg) & ~SKEWDET_CTL_DETECTMODE_MASK) | (((uint32_t)val) << SKEWDET_CTL_DETECTMODE_SHIFT))

#define  SKEWDET_CTL_MULTIEDGE_MASK 0x8
#define  SKEWDET_CTL_MULTIEDGE_SHIFT 3
#define  SKEWDET_CTL_MULTIEDGE_MASK_SHIFT(reg) (((reg) & SKEWDET_CTL_MULTIEDGE_MASK) >> SKEWDET_CTL_MULTIEDGE_SHIFT)
#define  SKEWDET_CTL_MULTIEDGE_REPLACE_VAL(reg,val) (((reg) & ~SKEWDET_CTL_MULTIEDGE_MASK) | (((uint32_t)val) << SKEWDET_CTL_MULTIEDGE_SHIFT))

#define  SKEWDET_CTL_INPUTMODE_MASK 0x6
#define  SKEWDET_CTL_INPUTMODE_SHIFT 1
#define  SKEWDET_CTL_INPUTMODE_MASK_SHIFT(reg) (((reg) & SKEWDET_CTL_INPUTMODE_MASK) >> SKEWDET_CTL_INPUTMODE_SHIFT)
#define  SKEWDET_CTL_INPUTMODE_REPLACE_VAL(reg,val) (((reg) & ~SKEWDET_CTL_INPUTMODE_MASK) | (((uint32_t)val) << SKEWDET_CTL_INPUTMODE_SHIFT))

#define  SKEWDET_CTL_ENABLE_MASK 0x1
#define  SKEWDET_CTL_ENABLE_SHIFT 0
#define  SKEWDET_CTL_ENABLE_MASK_SHIFT(reg) (((reg) & SKEWDET_CTL_ENABLE_MASK) >> SKEWDET_CTL_ENABLE_SHIFT)
#define  SKEWDET_CTL_ENABLE_REPLACE_VAL(reg,val) (((reg) & ~SKEWDET_CTL_ENABLE_MASK) | (((uint32_t)val) << SKEWDET_CTL_ENABLE_SHIFT))

//====================================================================
//Register: Compare Threshold (Compare)
//====================================================================

#define  SKEWDET_COMPARE_RESERVED1_MASK 0xffff0000
#define  SKEWDET_COMPARE_RESERVED1_SHIFT 16
#define  SKEWDET_COMPARE_RESERVED1_MASK_SHIFT(reg) (((reg) & SKEWDET_COMPARE_RESERVED1_MASK) >> SKEWDET_COMPARE_RESERVED1_SHIFT)
#define  SKEWDET_COMPARE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SKEWDET_COMPARE_RESERVED1_MASK) | (((uint32_t)val) << SKEWDET_COMPARE_RESERVED1_SHIFT))

#define  SKEWDET_COMPARE_THRESHOLD2_MASK 0xff00
#define  SKEWDET_COMPARE_THRESHOLD2_SHIFT 8
#define  SKEWDET_COMPARE_THRESHOLD2_MASK_SHIFT(reg) (((reg) & SKEWDET_COMPARE_THRESHOLD2_MASK) >> SKEWDET_COMPARE_THRESHOLD2_SHIFT)
#define  SKEWDET_COMPARE_THRESHOLD2_REPLACE_VAL(reg,val) (((reg) & ~SKEWDET_COMPARE_THRESHOLD2_MASK) | (((uint32_t)val) << SKEWDET_COMPARE_THRESHOLD2_SHIFT))

#define  SKEWDET_COMPARE_THRESHOLD1_MASK 0xff
#define  SKEWDET_COMPARE_THRESHOLD1_SHIFT 0
#define  SKEWDET_COMPARE_THRESHOLD1_MASK_SHIFT(reg) (((reg) & SKEWDET_COMPARE_THRESHOLD1_MASK) >> SKEWDET_COMPARE_THRESHOLD1_SHIFT)
#define  SKEWDET_COMPARE_THRESHOLD1_REPLACE_VAL(reg,val) (((reg) & ~SKEWDET_COMPARE_THRESHOLD1_MASK) | (((uint32_t)val) << SKEWDET_COMPARE_THRESHOLD1_SHIFT))

//====================================================================
//Register: Max Line Count (MaxLineCnt)
//====================================================================

#define  SKEWDET_MAXLINECNT_RESERVED1_MASK 0xffff0000
#define  SKEWDET_MAXLINECNT_RESERVED1_SHIFT 16
#define  SKEWDET_MAXLINECNT_RESERVED1_MASK_SHIFT(reg) (((reg) & SKEWDET_MAXLINECNT_RESERVED1_MASK) >> SKEWDET_MAXLINECNT_RESERVED1_SHIFT)
#define  SKEWDET_MAXLINECNT_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SKEWDET_MAXLINECNT_RESERVED1_MASK) | (((uint32_t)val) << SKEWDET_MAXLINECNT_RESERVED1_SHIFT))

#define  SKEWDET_MAXLINECNT_MAXLINECNT_MASK 0xffff
#define  SKEWDET_MAXLINECNT_MAXLINECNT_SHIFT 0
#define  SKEWDET_MAXLINECNT_MAXLINECNT_MASK_SHIFT(reg) (((reg) & SKEWDET_MAXLINECNT_MAXLINECNT_MASK) >> SKEWDET_MAXLINECNT_MAXLINECNT_SHIFT)
#define  SKEWDET_MAXLINECNT_MAXLINECNT_REPLACE_VAL(reg,val) (((reg) & ~SKEWDET_MAXLINECNT_MAXLINECNT_MASK) | (((uint32_t)val) << SKEWDET_MAXLINECNT_MAXLINECNT_SHIFT))

//====================================================================
//Register: Read Memory Address (RdMemAddr)
/** \brief Can read current memory address.*/
//====================================================================

#define  SKEWDET_RDMEMADDR_RESERVED1_MASK 0xfffffc00
#define  SKEWDET_RDMEMADDR_RESERVED1_SHIFT 10
#define  SKEWDET_RDMEMADDR_RESERVED1_MASK_SHIFT(reg) (((reg) & SKEWDET_RDMEMADDR_RESERVED1_MASK) >> SKEWDET_RDMEMADDR_RESERVED1_SHIFT)
#define  SKEWDET_RDMEMADDR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SKEWDET_RDMEMADDR_RESERVED1_MASK) | (((uint32_t)val) << SKEWDET_RDMEMADDR_RESERVED1_SHIFT))

#define  SKEWDET_RDMEMADDR_ADDRESS_MASK 0x3ff
#define  SKEWDET_RDMEMADDR_ADDRESS_SHIFT 0
#define  SKEWDET_RDMEMADDR_ADDRESS_MASK_SHIFT(reg) (((reg) & SKEWDET_RDMEMADDR_ADDRESS_MASK) >> SKEWDET_RDMEMADDR_ADDRESS_SHIFT)
#define  SKEWDET_RDMEMADDR_ADDRESS_REPLACE_VAL(reg,val) (((reg) & ~SKEWDET_RDMEMADDR_ADDRESS_MASK) | (((uint32_t)val) << SKEWDET_RDMEMADDR_ADDRESS_SHIFT))

//====================================================================
//Register: Write Memory Address (WrMemAddr)
/** \brief Write memory address.*/
//====================================================================

#define  SKEWDET_WRMEMADDR_RESERVED1_MASK 0xfffffc00
#define  SKEWDET_WRMEMADDR_RESERVED1_SHIFT 10
#define  SKEWDET_WRMEMADDR_RESERVED1_MASK_SHIFT(reg) (((reg) & SKEWDET_WRMEMADDR_RESERVED1_MASK) >> SKEWDET_WRMEMADDR_RESERVED1_SHIFT)
#define  SKEWDET_WRMEMADDR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SKEWDET_WRMEMADDR_RESERVED1_MASK) | (((uint32_t)val) << SKEWDET_WRMEMADDR_RESERVED1_SHIFT))

#define  SKEWDET_WRMEMADDR_ADDRESS_MASK 0x3ff
#define  SKEWDET_WRMEMADDR_ADDRESS_SHIFT 0
#define  SKEWDET_WRMEMADDR_ADDRESS_MASK_SHIFT(reg) (((reg) & SKEWDET_WRMEMADDR_ADDRESS_MASK) >> SKEWDET_WRMEMADDR_ADDRESS_SHIFT)
#define  SKEWDET_WRMEMADDR_ADDRESS_REPLACE_VAL(reg,val) (((reg) & ~SKEWDET_WRMEMADDR_ADDRESS_MASK) | (((uint32_t)val) << SKEWDET_WRMEMADDR_ADDRESS_SHIFT))

//====================================================================
//Register: Memory Read (RdMemData)
/** \brief Read the Memory. Used for single edge detect*/
//====================================================================

#define  SKEWDET_RDMEMDATA_RESERVED1_MASK 0xfffc0000
#define  SKEWDET_RDMEMDATA_RESERVED1_SHIFT 18
#define  SKEWDET_RDMEMDATA_RESERVED1_MASK_SHIFT(reg) (((reg) & SKEWDET_RDMEMDATA_RESERVED1_MASK) >> SKEWDET_RDMEMDATA_RESERVED1_SHIFT)
#define  SKEWDET_RDMEMDATA_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SKEWDET_RDMEMDATA_RESERVED1_MASK) | (((uint32_t)val) << SKEWDET_RDMEMDATA_RESERVED1_SHIFT))

#define  SKEWDET_RDMEMDATA_DATA_MASK 0x3ffff
#define  SKEWDET_RDMEMDATA_DATA_SHIFT 0
#define  SKEWDET_RDMEMDATA_DATA_MASK_SHIFT(reg) (((reg) & SKEWDET_RDMEMDATA_DATA_MASK) >> SKEWDET_RDMEMDATA_DATA_SHIFT)
#define  SKEWDET_RDMEMDATA_DATA_REPLACE_VAL(reg,val) (((reg) & ~SKEWDET_RDMEMDATA_DATA_MASK) | (((uint32_t)val) << SKEWDET_RDMEMDATA_DATA_SHIFT))

//====================================================================
//Register: Memory Write (WrMemData)
/** \brief Write to line buffer memory. Used only for ram testing*/
//====================================================================

#define  SKEWDET_WRMEMDATA_RESERVED1_MASK 0xfffc0000
#define  SKEWDET_WRMEMDATA_RESERVED1_SHIFT 18
#define  SKEWDET_WRMEMDATA_RESERVED1_MASK_SHIFT(reg) (((reg) & SKEWDET_WRMEMDATA_RESERVED1_MASK) >> SKEWDET_WRMEMDATA_RESERVED1_SHIFT)
#define  SKEWDET_WRMEMDATA_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SKEWDET_WRMEMDATA_RESERVED1_MASK) | (((uint32_t)val) << SKEWDET_WRMEMDATA_RESERVED1_SHIFT))

#define  SKEWDET_WRMEMDATA_DATA_MASK 0x3ffff
#define  SKEWDET_WRMEMDATA_DATA_SHIFT 0
#define  SKEWDET_WRMEMDATA_DATA_MASK_SHIFT(reg) (((reg) & SKEWDET_WRMEMDATA_DATA_MASK) >> SKEWDET_WRMEMDATA_DATA_SHIFT)
#define  SKEWDET_WRMEMDATA_DATA_REPLACE_VAL(reg,val) (((reg) & ~SKEWDET_WRMEMDATA_DATA_MASK) | (((uint32_t)val) << SKEWDET_WRMEMDATA_DATA_SHIFT))

//====================================================================
//Register: Interrupt enable register (int_enable)
//====================================================================

#define  SKEWDET_INT_ENABLE_RESERVED1_MASK 0xfffffff8
#define  SKEWDET_INT_ENABLE_RESERVED1_SHIFT 3
#define  SKEWDET_INT_ENABLE_RESERVED1_MASK_SHIFT(reg) (((reg) & SKEWDET_INT_ENABLE_RESERVED1_MASK) >> SKEWDET_INT_ENABLE_RESERVED1_SHIFT)
#define  SKEWDET_INT_ENABLE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SKEWDET_INT_ENABLE_RESERVED1_MASK) | (((uint32_t)val) << SKEWDET_INT_ENABLE_RESERVED1_SHIFT))

#define  SKEWDET_INT_ENABLE_ALLEDGEDET_MASK 0x4
#define  SKEWDET_INT_ENABLE_ALLEDGEDET_SHIFT 2
#define  SKEWDET_INT_ENABLE_ALLEDGEDET_MASK_SHIFT(reg) (((reg) & SKEWDET_INT_ENABLE_ALLEDGEDET_MASK) >> SKEWDET_INT_ENABLE_ALLEDGEDET_SHIFT)
#define  SKEWDET_INT_ENABLE_ALLEDGEDET_REPLACE_VAL(reg,val) (((reg) & ~SKEWDET_INT_ENABLE_ALLEDGEDET_MASK) | (((uint32_t)val) << SKEWDET_INT_ENABLE_ALLEDGEDET_SHIFT))

#define  SKEWDET_INT_ENABLE_RAMOVERFLOW_MASK 0x2
#define  SKEWDET_INT_ENABLE_RAMOVERFLOW_SHIFT 1
#define  SKEWDET_INT_ENABLE_RAMOVERFLOW_MASK_SHIFT(reg) (((reg) & SKEWDET_INT_ENABLE_RAMOVERFLOW_MASK) >> SKEWDET_INT_ENABLE_RAMOVERFLOW_SHIFT)
#define  SKEWDET_INT_ENABLE_RAMOVERFLOW_REPLACE_VAL(reg,val) (((reg) & ~SKEWDET_INT_ENABLE_RAMOVERFLOW_MASK) | (((uint32_t)val) << SKEWDET_INT_ENABLE_RAMOVERFLOW_SHIFT))

#define  SKEWDET_INT_ENABLE_MAXLINECNT_MASK 0x1
#define  SKEWDET_INT_ENABLE_MAXLINECNT_SHIFT 0
#define  SKEWDET_INT_ENABLE_MAXLINECNT_MASK_SHIFT(reg) (((reg) & SKEWDET_INT_ENABLE_MAXLINECNT_MASK) >> SKEWDET_INT_ENABLE_MAXLINECNT_SHIFT)
#define  SKEWDET_INT_ENABLE_MAXLINECNT_REPLACE_VAL(reg,val) (((reg) & ~SKEWDET_INT_ENABLE_MAXLINECNT_MASK) | (((uint32_t)val) << SKEWDET_INT_ENABLE_MAXLINECNT_SHIFT))

//====================================================================
//Register: Interrupt pending register (int_pending)
//====================================================================

#define  SKEWDET_INT_PENDING_RESERVED1_MASK 0xfffffff8
#define  SKEWDET_INT_PENDING_RESERVED1_SHIFT 3
#define  SKEWDET_INT_PENDING_RESERVED1_MASK_SHIFT(reg) (((reg) & SKEWDET_INT_PENDING_RESERVED1_MASK) >> SKEWDET_INT_PENDING_RESERVED1_SHIFT)
#define  SKEWDET_INT_PENDING_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SKEWDET_INT_PENDING_RESERVED1_MASK) | (((uint32_t)val) << SKEWDET_INT_PENDING_RESERVED1_SHIFT))

#define  SKEWDET_INT_PENDING_ALLEDGEDET_MASK 0x4
#define  SKEWDET_INT_PENDING_ALLEDGEDET_SHIFT 2
#define  SKEWDET_INT_PENDING_ALLEDGEDET_MASK_SHIFT(reg) (((reg) & SKEWDET_INT_PENDING_ALLEDGEDET_MASK) >> SKEWDET_INT_PENDING_ALLEDGEDET_SHIFT)
#define  SKEWDET_INT_PENDING_ALLEDGEDET_REPLACE_VAL(reg,val) (((reg) & ~SKEWDET_INT_PENDING_ALLEDGEDET_MASK) | (((uint32_t)val) << SKEWDET_INT_PENDING_ALLEDGEDET_SHIFT))

#define  SKEWDET_INT_PENDING_RAMOVERFLOW_MASK 0x2
#define  SKEWDET_INT_PENDING_RAMOVERFLOW_SHIFT 1
#define  SKEWDET_INT_PENDING_RAMOVERFLOW_MASK_SHIFT(reg) (((reg) & SKEWDET_INT_PENDING_RAMOVERFLOW_MASK) >> SKEWDET_INT_PENDING_RAMOVERFLOW_SHIFT)
#define  SKEWDET_INT_PENDING_RAMOVERFLOW_REPLACE_VAL(reg,val) (((reg) & ~SKEWDET_INT_PENDING_RAMOVERFLOW_MASK) | (((uint32_t)val) << SKEWDET_INT_PENDING_RAMOVERFLOW_SHIFT))

#define  SKEWDET_INT_PENDING_MAXLINECNT_MASK 0x1
#define  SKEWDET_INT_PENDING_MAXLINECNT_SHIFT 0
#define  SKEWDET_INT_PENDING_MAXLINECNT_MASK_SHIFT(reg) (((reg) & SKEWDET_INT_PENDING_MAXLINECNT_MASK) >> SKEWDET_INT_PENDING_MAXLINECNT_SHIFT)
#define  SKEWDET_INT_PENDING_MAXLINECNT_REPLACE_VAL(reg,val) (((reg) & ~SKEWDET_INT_PENDING_MAXLINECNT_MASK) | (((uint32_t)val) << SKEWDET_INT_PENDING_MAXLINECNT_SHIFT))

//====================================================================
//Register: Interrupt status register (int_status)
//====================================================================

#define  SKEWDET_INT_STATUS_RESERVED1_MASK 0xfffffff8
#define  SKEWDET_INT_STATUS_RESERVED1_SHIFT 3
#define  SKEWDET_INT_STATUS_RESERVED1_MASK_SHIFT(reg) (((reg) & SKEWDET_INT_STATUS_RESERVED1_MASK) >> SKEWDET_INT_STATUS_RESERVED1_SHIFT)
#define  SKEWDET_INT_STATUS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SKEWDET_INT_STATUS_RESERVED1_MASK) | (((uint32_t)val) << SKEWDET_INT_STATUS_RESERVED1_SHIFT))

#define  SKEWDET_INT_STATUS_ALLEDGEDET_MASK 0x4
#define  SKEWDET_INT_STATUS_ALLEDGEDET_SHIFT 2
#define  SKEWDET_INT_STATUS_ALLEDGEDET_MASK_SHIFT(reg) (((reg) & SKEWDET_INT_STATUS_ALLEDGEDET_MASK) >> SKEWDET_INT_STATUS_ALLEDGEDET_SHIFT)
#define  SKEWDET_INT_STATUS_ALLEDGEDET_REPLACE_VAL(reg,val) (((reg) & ~SKEWDET_INT_STATUS_ALLEDGEDET_MASK) | (((uint32_t)val) << SKEWDET_INT_STATUS_ALLEDGEDET_SHIFT))

#define  SKEWDET_INT_STATUS_RAMOVERFLOW_MASK 0x2
#define  SKEWDET_INT_STATUS_RAMOVERFLOW_SHIFT 1
#define  SKEWDET_INT_STATUS_RAMOVERFLOW_MASK_SHIFT(reg) (((reg) & SKEWDET_INT_STATUS_RAMOVERFLOW_MASK) >> SKEWDET_INT_STATUS_RAMOVERFLOW_SHIFT)
#define  SKEWDET_INT_STATUS_RAMOVERFLOW_REPLACE_VAL(reg,val) (((reg) & ~SKEWDET_INT_STATUS_RAMOVERFLOW_MASK) | (((uint32_t)val) << SKEWDET_INT_STATUS_RAMOVERFLOW_SHIFT))

#define  SKEWDET_INT_STATUS_MAXLINECNT_MASK 0x1
#define  SKEWDET_INT_STATUS_MAXLINECNT_SHIFT 0
#define  SKEWDET_INT_STATUS_MAXLINECNT_MASK_SHIFT(reg) (((reg) & SKEWDET_INT_STATUS_MAXLINECNT_MASK) >> SKEWDET_INT_STATUS_MAXLINECNT_SHIFT)
#define  SKEWDET_INT_STATUS_MAXLINECNT_REPLACE_VAL(reg,val) (((reg) & ~SKEWDET_INT_STATUS_MAXLINECNT_MASK) | (((uint32_t)val) << SKEWDET_INT_STATUS_MAXLINECNT_SHIFT))

//====================================================================
//Register: Interrupt acknowledge register (int_ack)
//====================================================================

#define  SKEWDET_INT_ACK_RESERVED1_MASK 0xfffffff8
#define  SKEWDET_INT_ACK_RESERVED1_SHIFT 3
#define  SKEWDET_INT_ACK_RESERVED1_MASK_SHIFT(reg) (((reg) & SKEWDET_INT_ACK_RESERVED1_MASK) >> SKEWDET_INT_ACK_RESERVED1_SHIFT)
#define  SKEWDET_INT_ACK_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SKEWDET_INT_ACK_RESERVED1_MASK) | (((uint32_t)val) << SKEWDET_INT_ACK_RESERVED1_SHIFT))

#define  SKEWDET_INT_ACK_ALLEDGEDET_MASK 0x4
#define  SKEWDET_INT_ACK_ALLEDGEDET_SHIFT 2
#define  SKEWDET_INT_ACK_ALLEDGEDET_MASK_SHIFT(reg) (((reg) & SKEWDET_INT_ACK_ALLEDGEDET_MASK) >> SKEWDET_INT_ACK_ALLEDGEDET_SHIFT)
#define  SKEWDET_INT_ACK_ALLEDGEDET_REPLACE_VAL(reg,val) (((reg) & ~SKEWDET_INT_ACK_ALLEDGEDET_MASK) | (((uint32_t)val) << SKEWDET_INT_ACK_ALLEDGEDET_SHIFT))

#define  SKEWDET_INT_ACK_RAMOVERFLOW_MASK 0x2
#define  SKEWDET_INT_ACK_RAMOVERFLOW_SHIFT 1
#define  SKEWDET_INT_ACK_RAMOVERFLOW_MASK_SHIFT(reg) (((reg) & SKEWDET_INT_ACK_RAMOVERFLOW_MASK) >> SKEWDET_INT_ACK_RAMOVERFLOW_SHIFT)
#define  SKEWDET_INT_ACK_RAMOVERFLOW_REPLACE_VAL(reg,val) (((reg) & ~SKEWDET_INT_ACK_RAMOVERFLOW_MASK) | (((uint32_t)val) << SKEWDET_INT_ACK_RAMOVERFLOW_SHIFT))

#define  SKEWDET_INT_ACK_MAXLINECNT_MASK 0x1
#define  SKEWDET_INT_ACK_MAXLINECNT_SHIFT 0
#define  SKEWDET_INT_ACK_MAXLINECNT_MASK_SHIFT(reg) (((reg) & SKEWDET_INT_ACK_MAXLINECNT_MASK) >> SKEWDET_INT_ACK_MAXLINECNT_SHIFT)
#define  SKEWDET_INT_ACK_MAXLINECNT_REPLACE_VAL(reg,val) (((reg) & ~SKEWDET_INT_ACK_MAXLINECNT_MASK) | (((uint32_t)val) << SKEWDET_INT_ACK_MAXLINECNT_SHIFT))

//====================================================================
//Register: Interrupt force register (int_force)
//====================================================================

#define  SKEWDET_INT_FORCE_RESERVED1_MASK 0xfffffff8
#define  SKEWDET_INT_FORCE_RESERVED1_SHIFT 3
#define  SKEWDET_INT_FORCE_RESERVED1_MASK_SHIFT(reg) (((reg) & SKEWDET_INT_FORCE_RESERVED1_MASK) >> SKEWDET_INT_FORCE_RESERVED1_SHIFT)
#define  SKEWDET_INT_FORCE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SKEWDET_INT_FORCE_RESERVED1_MASK) | (((uint32_t)val) << SKEWDET_INT_FORCE_RESERVED1_SHIFT))

#define  SKEWDET_INT_FORCE_ALLEDGEDET_MASK 0x4
#define  SKEWDET_INT_FORCE_ALLEDGEDET_SHIFT 2
#define  SKEWDET_INT_FORCE_ALLEDGEDET_MASK_SHIFT(reg) (((reg) & SKEWDET_INT_FORCE_ALLEDGEDET_MASK) >> SKEWDET_INT_FORCE_ALLEDGEDET_SHIFT)
#define  SKEWDET_INT_FORCE_ALLEDGEDET_REPLACE_VAL(reg,val) (((reg) & ~SKEWDET_INT_FORCE_ALLEDGEDET_MASK) | (((uint32_t)val) << SKEWDET_INT_FORCE_ALLEDGEDET_SHIFT))

#define  SKEWDET_INT_FORCE_RAMOVERFLOW_MASK 0x2
#define  SKEWDET_INT_FORCE_RAMOVERFLOW_SHIFT 1
#define  SKEWDET_INT_FORCE_RAMOVERFLOW_MASK_SHIFT(reg) (((reg) & SKEWDET_INT_FORCE_RAMOVERFLOW_MASK) >> SKEWDET_INT_FORCE_RAMOVERFLOW_SHIFT)
#define  SKEWDET_INT_FORCE_RAMOVERFLOW_REPLACE_VAL(reg,val) (((reg) & ~SKEWDET_INT_FORCE_RAMOVERFLOW_MASK) | (((uint32_t)val) << SKEWDET_INT_FORCE_RAMOVERFLOW_SHIFT))

#define  SKEWDET_INT_FORCE_MAXLINECNT_MASK 0x1
#define  SKEWDET_INT_FORCE_MAXLINECNT_SHIFT 0
#define  SKEWDET_INT_FORCE_MAXLINECNT_MASK_SHIFT(reg) (((reg) & SKEWDET_INT_FORCE_MAXLINECNT_MASK) >> SKEWDET_INT_FORCE_MAXLINECNT_SHIFT)
#define  SKEWDET_INT_FORCE_MAXLINECNT_REPLACE_VAL(reg,val) (((reg) & ~SKEWDET_INT_FORCE_MAXLINECNT_MASK) | (((uint32_t)val) << SKEWDET_INT_FORCE_MAXLINECNT_SHIFT))

//====================================================================
//
//Register File: Skew Detect ODMA (SKEW_ODMA)
/** \brief Register Descriptions for the ODMA_AXI block (rev 0 . 4 . 3 . 1)*/
//
//====================================================================

//====================================================================
//Register: Configuration register (cfg)
//====================================================================

#define  SKEW_ODMA_CFG_RESERVED1_MASK 0xfe000000
#define  SKEW_ODMA_CFG_RESERVED1_SHIFT 25
#define  SKEW_ODMA_CFG_RESERVED1_MASK_SHIFT(reg) (((reg) & SKEW_ODMA_CFG_RESERVED1_MASK) >> SKEW_ODMA_CFG_RESERVED1_SHIFT)
#define  SKEW_ODMA_CFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SKEW_ODMA_CFG_RESERVED1_MASK) | (((uint32_t)val) << SKEW_ODMA_CFG_RESERVED1_SHIFT))

#define  SKEW_ODMA_CFG_HANDSHAKEENABLE_MASK 0x1000000
#define  SKEW_ODMA_CFG_HANDSHAKEENABLE_SHIFT 24
#define  SKEW_ODMA_CFG_HANDSHAKEENABLE_MASK_SHIFT(reg) (((reg) & SKEW_ODMA_CFG_HANDSHAKEENABLE_MASK) >> SKEW_ODMA_CFG_HANDSHAKEENABLE_SHIFT)
#define  SKEW_ODMA_CFG_HANDSHAKEENABLE_REPLACE_VAL(reg,val) (((reg) & ~SKEW_ODMA_CFG_HANDSHAKEENABLE_MASK) | (((uint32_t)val) << SKEW_ODMA_CFG_HANDSHAKEENABLE_SHIFT))

#define  SKEW_ODMA_CFG_OWNPOLARITY_MASK 0x800000
#define  SKEW_ODMA_CFG_OWNPOLARITY_SHIFT 23
#define  SKEW_ODMA_CFG_OWNPOLARITY_MASK_SHIFT(reg) (((reg) & SKEW_ODMA_CFG_OWNPOLARITY_MASK) >> SKEW_ODMA_CFG_OWNPOLARITY_SHIFT)
#define  SKEW_ODMA_CFG_OWNPOLARITY_REPLACE_VAL(reg,val) (((reg) & ~SKEW_ODMA_CFG_OWNPOLARITY_MASK) | (((uint32_t)val) << SKEW_ODMA_CFG_OWNPOLARITY_SHIFT))

#define  SKEW_ODMA_CFG_OWNWRITEDISABLE_MASK 0x400000
#define  SKEW_ODMA_CFG_OWNWRITEDISABLE_SHIFT 22
#define  SKEW_ODMA_CFG_OWNWRITEDISABLE_MASK_SHIFT(reg) (((reg) & SKEW_ODMA_CFG_OWNWRITEDISABLE_MASK) >> SKEW_ODMA_CFG_OWNWRITEDISABLE_SHIFT)
#define  SKEW_ODMA_CFG_OWNWRITEDISABLE_REPLACE_VAL(reg,val) (((reg) & ~SKEW_ODMA_CFG_OWNWRITEDISABLE_MASK) | (((uint32_t)val) << SKEW_ODMA_CFG_OWNWRITEDISABLE_SHIFT))

#define  SKEW_ODMA_CFG_SERPENTINE_MASK 0x200000
#define  SKEW_ODMA_CFG_SERPENTINE_SHIFT 21
#define  SKEW_ODMA_CFG_SERPENTINE_MASK_SHIFT(reg) (((reg) & SKEW_ODMA_CFG_SERPENTINE_MASK) >> SKEW_ODMA_CFG_SERPENTINE_SHIFT)
#define  SKEW_ODMA_CFG_SERPENTINE_REPLACE_VAL(reg,val) (((reg) & ~SKEW_ODMA_CFG_SERPENTINE_MASK) | (((uint32_t)val) << SKEW_ODMA_CFG_SERPENTINE_SHIFT))

#define  SKEW_ODMA_CFG_LINE_REV_MASK 0x100000
#define  SKEW_ODMA_CFG_LINE_REV_SHIFT 20
#define  SKEW_ODMA_CFG_LINE_REV_MASK_SHIFT(reg) (((reg) & SKEW_ODMA_CFG_LINE_REV_MASK) >> SKEW_ODMA_CFG_LINE_REV_SHIFT)
#define  SKEW_ODMA_CFG_LINE_REV_REPLACE_VAL(reg,val) (((reg) & ~SKEW_ODMA_CFG_LINE_REV_MASK) | (((uint32_t)val) << SKEW_ODMA_CFG_LINE_REV_SHIFT))

#define  SKEW_ODMA_CFG_TRAN_REV_MASK 0x80000
#define  SKEW_ODMA_CFG_TRAN_REV_SHIFT 19
#define  SKEW_ODMA_CFG_TRAN_REV_MASK_SHIFT(reg) (((reg) & SKEW_ODMA_CFG_TRAN_REV_MASK) >> SKEW_ODMA_CFG_TRAN_REV_SHIFT)
#define  SKEW_ODMA_CFG_TRAN_REV_REPLACE_VAL(reg,val) (((reg) & ~SKEW_ODMA_CFG_TRAN_REV_MASK) | (((uint32_t)val) << SKEW_ODMA_CFG_TRAN_REV_SHIFT))

#define  SKEW_ODMA_CFG_UPPER_HALF_MASK 0x40000
#define  SKEW_ODMA_CFG_UPPER_HALF_SHIFT 18
#define  SKEW_ODMA_CFG_UPPER_HALF_MASK_SHIFT(reg) (((reg) & SKEW_ODMA_CFG_UPPER_HALF_MASK) >> SKEW_ODMA_CFG_UPPER_HALF_SHIFT)
#define  SKEW_ODMA_CFG_UPPER_HALF_REPLACE_VAL(reg,val) (((reg) & ~SKEW_ODMA_CFG_UPPER_HALF_MASK) | (((uint32_t)val) << SKEW_ODMA_CFG_UPPER_HALF_SHIFT))

#define  SKEW_ODMA_CFG_MSB_IN_MASK 0x20000
#define  SKEW_ODMA_CFG_MSB_IN_SHIFT 17
#define  SKEW_ODMA_CFG_MSB_IN_MASK_SHIFT(reg) (((reg) & SKEW_ODMA_CFG_MSB_IN_MASK) >> SKEW_ODMA_CFG_MSB_IN_SHIFT)
#define  SKEW_ODMA_CFG_MSB_IN_REPLACE_VAL(reg,val) (((reg) & ~SKEW_ODMA_CFG_MSB_IN_MASK) | (((uint32_t)val) << SKEW_ODMA_CFG_MSB_IN_SHIFT))

#define  SKEW_ODMA_CFG_ENABLE_MASK 0x10000
#define  SKEW_ODMA_CFG_ENABLE_SHIFT 16
#define  SKEW_ODMA_CFG_ENABLE_MASK_SHIFT(reg) (((reg) & SKEW_ODMA_CFG_ENABLE_MASK) >> SKEW_ODMA_CFG_ENABLE_SHIFT)
#define  SKEW_ODMA_CFG_ENABLE_REPLACE_VAL(reg,val) (((reg) & ~SKEW_ODMA_CFG_ENABLE_MASK) | (((uint32_t)val) << SKEW_ODMA_CFG_ENABLE_SHIFT))

#define  SKEW_ODMA_CFG_RESERVED2_MASK 0xf800
#define  SKEW_ODMA_CFG_RESERVED2_SHIFT 11
#define  SKEW_ODMA_CFG_RESERVED2_MASK_SHIFT(reg) (((reg) & SKEW_ODMA_CFG_RESERVED2_MASK) >> SKEW_ODMA_CFG_RESERVED2_SHIFT)
#define  SKEW_ODMA_CFG_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SKEW_ODMA_CFG_RESERVED2_MASK) | (((uint32_t)val) << SKEW_ODMA_CFG_RESERVED2_SHIFT))

#define  SKEW_ODMA_CFG_IN_WIDTH_MASK 0x700
#define  SKEW_ODMA_CFG_IN_WIDTH_SHIFT 8
#define  SKEW_ODMA_CFG_IN_WIDTH_MASK_SHIFT(reg) (((reg) & SKEW_ODMA_CFG_IN_WIDTH_MASK) >> SKEW_ODMA_CFG_IN_WIDTH_SHIFT)
#define  SKEW_ODMA_CFG_IN_WIDTH_REPLACE_VAL(reg,val) (((reg) & ~SKEW_ODMA_CFG_IN_WIDTH_MASK) | (((uint32_t)val) << SKEW_ODMA_CFG_IN_WIDTH_SHIFT))

#define  SKEW_ODMA_CFG_RESERVED3_MASK 0xfc
#define  SKEW_ODMA_CFG_RESERVED3_SHIFT 2
#define  SKEW_ODMA_CFG_RESERVED3_MASK_SHIFT(reg) (((reg) & SKEW_ODMA_CFG_RESERVED3_MASK) >> SKEW_ODMA_CFG_RESERVED3_SHIFT)
#define  SKEW_ODMA_CFG_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~SKEW_ODMA_CFG_RESERVED3_MASK) | (((uint32_t)val) << SKEW_ODMA_CFG_RESERVED3_SHIFT))

#define  SKEW_ODMA_CFG_BURST_LEN_MASK 0x3
#define  SKEW_ODMA_CFG_BURST_LEN_SHIFT 0
#define  SKEW_ODMA_CFG_BURST_LEN_MASK_SHIFT(reg) (((reg) & SKEW_ODMA_CFG_BURST_LEN_MASK) >> SKEW_ODMA_CFG_BURST_LEN_SHIFT)
#define  SKEW_ODMA_CFG_BURST_LEN_REPLACE_VAL(reg,val) (((reg) & ~SKEW_ODMA_CFG_BURST_LEN_MASK) | (((uint32_t)val) << SKEW_ODMA_CFG_BURST_LEN_SHIFT))

//====================================================================
//Register: Status register (status)
//====================================================================

#define  SKEW_ODMA_STATUS_RESERVED1_MASK 0xff000000
#define  SKEW_ODMA_STATUS_RESERVED1_SHIFT 24
#define  SKEW_ODMA_STATUS_RESERVED1_MASK_SHIFT(reg) (((reg) & SKEW_ODMA_STATUS_RESERVED1_MASK) >> SKEW_ODMA_STATUS_RESERVED1_SHIFT)
#define  SKEW_ODMA_STATUS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SKEW_ODMA_STATUS_RESERVED1_MASK) | (((uint32_t)val) << SKEW_ODMA_STATUS_RESERVED1_SHIFT))

#define  SKEW_ODMA_STATUS_BYTESWAITING_MASK 0xff0000
#define  SKEW_ODMA_STATUS_BYTESWAITING_SHIFT 16
#define  SKEW_ODMA_STATUS_BYTESWAITING_MASK_SHIFT(reg) (((reg) & SKEW_ODMA_STATUS_BYTESWAITING_MASK) >> SKEW_ODMA_STATUS_BYTESWAITING_SHIFT)
#define  SKEW_ODMA_STATUS_BYTESWAITING_REPLACE_VAL(reg,val) (((reg) & ~SKEW_ODMA_STATUS_BYTESWAITING_MASK) | (((uint32_t)val) << SKEW_ODMA_STATUS_BYTESWAITING_SHIFT))

#define  SKEW_ODMA_STATUS_RESERVED2_MASK 0x8000
#define  SKEW_ODMA_STATUS_RESERVED2_SHIFT 15
#define  SKEW_ODMA_STATUS_RESERVED2_MASK_SHIFT(reg) (((reg) & SKEW_ODMA_STATUS_RESERVED2_MASK) >> SKEW_ODMA_STATUS_RESERVED2_SHIFT)
#define  SKEW_ODMA_STATUS_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~SKEW_ODMA_STATUS_RESERVED2_MASK) | (((uint32_t)val) << SKEW_ODMA_STATUS_RESERVED2_SHIFT))

#define  SKEW_ODMA_STATUS_FORCE_BURST_BUSY_MASK 0x4000
#define  SKEW_ODMA_STATUS_FORCE_BURST_BUSY_SHIFT 14
#define  SKEW_ODMA_STATUS_FORCE_BURST_BUSY_MASK_SHIFT(reg) (((reg) & SKEW_ODMA_STATUS_FORCE_BURST_BUSY_MASK) >> SKEW_ODMA_STATUS_FORCE_BURST_BUSY_SHIFT)
#define  SKEW_ODMA_STATUS_FORCE_BURST_BUSY_REPLACE_VAL(reg,val) (((reg) & ~SKEW_ODMA_STATUS_FORCE_BURST_BUSY_MASK) | (((uint32_t)val) << SKEW_ODMA_STATUS_FORCE_BURST_BUSY_SHIFT))

#define  SKEW_ODMA_STATUS_DMAPAUSED_MASK 0x2000
#define  SKEW_ODMA_STATUS_DMAPAUSED_SHIFT 13
#define  SKEW_ODMA_STATUS_DMAPAUSED_MASK_SHIFT(reg) (((reg) & SKEW_ODMA_STATUS_DMAPAUSED_MASK) >> SKEW_ODMA_STATUS_DMAPAUSED_SHIFT)
#define  SKEW_ODMA_STATUS_DMAPAUSED_REPLACE_VAL(reg,val) (((reg) & ~SKEW_ODMA_STATUS_DMAPAUSED_MASK) | (((uint32_t)val) << SKEW_ODMA_STATUS_DMAPAUSED_SHIFT))

#define  SKEW_ODMA_STATUS_PAUSEAFTER_MASK 0x1000
#define  SKEW_ODMA_STATUS_PAUSEAFTER_SHIFT 12
#define  SKEW_ODMA_STATUS_PAUSEAFTER_MASK_SHIFT(reg) (((reg) & SKEW_ODMA_STATUS_PAUSEAFTER_MASK) >> SKEW_ODMA_STATUS_PAUSEAFTER_SHIFT)
#define  SKEW_ODMA_STATUS_PAUSEAFTER_REPLACE_VAL(reg,val) (((reg) & ~SKEW_ODMA_STATUS_PAUSEAFTER_MASK) | (((uint32_t)val) << SKEW_ODMA_STATUS_PAUSEAFTER_SHIFT))

#define  SKEW_ODMA_STATUS_PAUSEBEFORE_MASK 0x800
#define  SKEW_ODMA_STATUS_PAUSEBEFORE_SHIFT 11
#define  SKEW_ODMA_STATUS_PAUSEBEFORE_MASK_SHIFT(reg) (((reg) & SKEW_ODMA_STATUS_PAUSEBEFORE_MASK) >> SKEW_ODMA_STATUS_PAUSEBEFORE_SHIFT)
#define  SKEW_ODMA_STATUS_PAUSEBEFORE_REPLACE_VAL(reg,val) (((reg) & ~SKEW_ODMA_STATUS_PAUSEBEFORE_MASK) | (((uint32_t)val) << SKEW_ODMA_STATUS_PAUSEBEFORE_SHIFT))

#define  SKEW_ODMA_STATUS_DESC_OWN_MASK 0x400
#define  SKEW_ODMA_STATUS_DESC_OWN_SHIFT 10
#define  SKEW_ODMA_STATUS_DESC_OWN_MASK_SHIFT(reg) (((reg) & SKEW_ODMA_STATUS_DESC_OWN_MASK) >> SKEW_ODMA_STATUS_DESC_OWN_SHIFT)
#define  SKEW_ODMA_STATUS_DESC_OWN_REPLACE_VAL(reg,val) (((reg) & ~SKEW_ODMA_STATUS_DESC_OWN_MASK) | (((uint32_t)val) << SKEW_ODMA_STATUS_DESC_OWN_SHIFT))

#define  SKEW_ODMA_STATUS_DESC_EOI_MASK 0x200
#define  SKEW_ODMA_STATUS_DESC_EOI_SHIFT 9
#define  SKEW_ODMA_STATUS_DESC_EOI_MASK_SHIFT(reg) (((reg) & SKEW_ODMA_STATUS_DESC_EOI_MASK) >> SKEW_ODMA_STATUS_DESC_EOI_SHIFT)
#define  SKEW_ODMA_STATUS_DESC_EOI_REPLACE_VAL(reg,val) (((reg) & ~SKEW_ODMA_STATUS_DESC_EOI_MASK) | (((uint32_t)val) << SKEW_ODMA_STATUS_DESC_EOI_SHIFT))

#define  SKEW_ODMA_STATUS_DESC_SOI_MASK 0x100
#define  SKEW_ODMA_STATUS_DESC_SOI_SHIFT 8
#define  SKEW_ODMA_STATUS_DESC_SOI_MASK_SHIFT(reg) (((reg) & SKEW_ODMA_STATUS_DESC_SOI_MASK) >> SKEW_ODMA_STATUS_DESC_SOI_SHIFT)
#define  SKEW_ODMA_STATUS_DESC_SOI_REPLACE_VAL(reg,val) (((reg) & ~SKEW_ODMA_STATUS_DESC_SOI_MASK) | (((uint32_t)val) << SKEW_ODMA_STATUS_DESC_SOI_SHIFT))

#define  SKEW_ODMA_STATUS_REVERSE_MASK 0x80
#define  SKEW_ODMA_STATUS_REVERSE_SHIFT 7
#define  SKEW_ODMA_STATUS_REVERSE_MASK_SHIFT(reg) (((reg) & SKEW_ODMA_STATUS_REVERSE_MASK) >> SKEW_ODMA_STATUS_REVERSE_SHIFT)
#define  SKEW_ODMA_STATUS_REVERSE_REPLACE_VAL(reg,val) (((reg) & ~SKEW_ODMA_STATUS_REVERSE_MASK) | (((uint32_t)val) << SKEW_ODMA_STATUS_REVERSE_SHIFT))

#define  SKEW_ODMA_STATUS_SOFTRESET_MASK 0x40
#define  SKEW_ODMA_STATUS_SOFTRESET_SHIFT 6
#define  SKEW_ODMA_STATUS_SOFTRESET_MASK_SHIFT(reg) (((reg) & SKEW_ODMA_STATUS_SOFTRESET_MASK) >> SKEW_ODMA_STATUS_SOFTRESET_SHIFT)
#define  SKEW_ODMA_STATUS_SOFTRESET_REPLACE_VAL(reg,val) (((reg) & ~SKEW_ODMA_STATUS_SOFTRESET_MASK) | (((uint32_t)val) << SKEW_ODMA_STATUS_SOFTRESET_SHIFT))

#define  SKEW_ODMA_STATUS_FULL_CBUF_MASK 0x20
#define  SKEW_ODMA_STATUS_FULL_CBUF_SHIFT 5
#define  SKEW_ODMA_STATUS_FULL_CBUF_MASK_SHIFT(reg) (((reg) & SKEW_ODMA_STATUS_FULL_CBUF_MASK) >> SKEW_ODMA_STATUS_FULL_CBUF_SHIFT)
#define  SKEW_ODMA_STATUS_FULL_CBUF_REPLACE_VAL(reg,val) (((reg) & ~SKEW_ODMA_STATUS_FULL_CBUF_MASK) | (((uint32_t)val) << SKEW_ODMA_STATUS_FULL_CBUF_SHIFT))

#define  SKEW_ODMA_STATUS_EMPTY_CBUF_MASK 0x10
#define  SKEW_ODMA_STATUS_EMPTY_CBUF_SHIFT 4
#define  SKEW_ODMA_STATUS_EMPTY_CBUF_MASK_SHIFT(reg) (((reg) & SKEW_ODMA_STATUS_EMPTY_CBUF_MASK) >> SKEW_ODMA_STATUS_EMPTY_CBUF_SHIFT)
#define  SKEW_ODMA_STATUS_EMPTY_CBUF_REPLACE_VAL(reg,val) (((reg) & ~SKEW_ODMA_STATUS_EMPTY_CBUF_MASK) | (((uint32_t)val) << SKEW_ODMA_STATUS_EMPTY_CBUF_SHIFT))

#define  SKEW_ODMA_STATUS_FULL_DBUF_MASK 0x8
#define  SKEW_ODMA_STATUS_FULL_DBUF_SHIFT 3
#define  SKEW_ODMA_STATUS_FULL_DBUF_MASK_SHIFT(reg) (((reg) & SKEW_ODMA_STATUS_FULL_DBUF_MASK) >> SKEW_ODMA_STATUS_FULL_DBUF_SHIFT)
#define  SKEW_ODMA_STATUS_FULL_DBUF_REPLACE_VAL(reg,val) (((reg) & ~SKEW_ODMA_STATUS_FULL_DBUF_MASK) | (((uint32_t)val) << SKEW_ODMA_STATUS_FULL_DBUF_SHIFT))

#define  SKEW_ODMA_STATUS_EMPTY_DBUF_MASK 0x4
#define  SKEW_ODMA_STATUS_EMPTY_DBUF_SHIFT 2
#define  SKEW_ODMA_STATUS_EMPTY_DBUF_MASK_SHIFT(reg) (((reg) & SKEW_ODMA_STATUS_EMPTY_DBUF_MASK) >> SKEW_ODMA_STATUS_EMPTY_DBUF_SHIFT)
#define  SKEW_ODMA_STATUS_EMPTY_DBUF_REPLACE_VAL(reg,val) (((reg) & ~SKEW_ODMA_STATUS_EMPTY_DBUF_MASK) | (((uint32_t)val) << SKEW_ODMA_STATUS_EMPTY_DBUF_SHIFT))

#define  SKEW_ODMA_STATUS_PACKER_EMPTY_MASK 0x2
#define  SKEW_ODMA_STATUS_PACKER_EMPTY_SHIFT 1
#define  SKEW_ODMA_STATUS_PACKER_EMPTY_MASK_SHIFT(reg) (((reg) & SKEW_ODMA_STATUS_PACKER_EMPTY_MASK) >> SKEW_ODMA_STATUS_PACKER_EMPTY_SHIFT)
#define  SKEW_ODMA_STATUS_PACKER_EMPTY_REPLACE_VAL(reg,val) (((reg) & ~SKEW_ODMA_STATUS_PACKER_EMPTY_MASK) | (((uint32_t)val) << SKEW_ODMA_STATUS_PACKER_EMPTY_SHIFT))

#define  SKEW_ODMA_STATUS_DMA_BUSY_MASK 0x1
#define  SKEW_ODMA_STATUS_DMA_BUSY_SHIFT 0
#define  SKEW_ODMA_STATUS_DMA_BUSY_MASK_SHIFT(reg) (((reg) & SKEW_ODMA_STATUS_DMA_BUSY_MASK) >> SKEW_ODMA_STATUS_DMA_BUSY_SHIFT)
#define  SKEW_ODMA_STATUS_DMA_BUSY_REPLACE_VAL(reg,val) (((reg) & ~SKEW_ODMA_STATUS_DMA_BUSY_MASK) | (((uint32_t)val) << SKEW_ODMA_STATUS_DMA_BUSY_SHIFT))

//====================================================================
//Register: Line Size Register (line_size)
//====================================================================

#define  SKEW_ODMA_LINE_SIZE_RESERVED1_MASK 0xfffc0000
#define  SKEW_ODMA_LINE_SIZE_RESERVED1_SHIFT 18
#define  SKEW_ODMA_LINE_SIZE_RESERVED1_MASK_SHIFT(reg) (((reg) & SKEW_ODMA_LINE_SIZE_RESERVED1_MASK) >> SKEW_ODMA_LINE_SIZE_RESERVED1_SHIFT)
#define  SKEW_ODMA_LINE_SIZE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SKEW_ODMA_LINE_SIZE_RESERVED1_MASK) | (((uint32_t)val) << SKEW_ODMA_LINE_SIZE_RESERVED1_SHIFT))

#define  SKEW_ODMA_LINE_SIZE_LINE_SIZE_MASK 0x3ffff
#define  SKEW_ODMA_LINE_SIZE_LINE_SIZE_SHIFT 0
#define  SKEW_ODMA_LINE_SIZE_LINE_SIZE_MASK_SHIFT(reg) (((reg) & SKEW_ODMA_LINE_SIZE_LINE_SIZE_MASK) >> SKEW_ODMA_LINE_SIZE_LINE_SIZE_SHIFT)
#define  SKEW_ODMA_LINE_SIZE_LINE_SIZE_REPLACE_VAL(reg,val) (((reg) & ~SKEW_ODMA_LINE_SIZE_LINE_SIZE_MASK) | (((uint32_t)val) << SKEW_ODMA_LINE_SIZE_LINE_SIZE_SHIFT))

//====================================================================
//Register: Interrupt Enable Register (int_en)
//====================================================================

#define  SKEW_ODMA_INT_EN_RESERVED1_MASK 0xfffff800
#define  SKEW_ODMA_INT_EN_RESERVED1_SHIFT 11
#define  SKEW_ODMA_INT_EN_RESERVED1_MASK_SHIFT(reg) (((reg) & SKEW_ODMA_INT_EN_RESERVED1_MASK) >> SKEW_ODMA_INT_EN_RESERVED1_SHIFT)
#define  SKEW_ODMA_INT_EN_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SKEW_ODMA_INT_EN_RESERVED1_MASK) | (((uint32_t)val) << SKEW_ODMA_INT_EN_RESERVED1_SHIFT))

#define  SKEW_ODMA_INT_EN_RRESP_INT_EN_MASK 0x400
#define  SKEW_ODMA_INT_EN_RRESP_INT_EN_SHIFT 10
#define  SKEW_ODMA_INT_EN_RRESP_INT_EN_MASK_SHIFT(reg) (((reg) & SKEW_ODMA_INT_EN_RRESP_INT_EN_MASK) >> SKEW_ODMA_INT_EN_RRESP_INT_EN_SHIFT)
#define  SKEW_ODMA_INT_EN_RRESP_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~SKEW_ODMA_INT_EN_RRESP_INT_EN_MASK) | (((uint32_t)val) << SKEW_ODMA_INT_EN_RRESP_INT_EN_SHIFT))

#define  SKEW_ODMA_INT_EN_BRESP_INT_EN_MASK 0x200
#define  SKEW_ODMA_INT_EN_BRESP_INT_EN_SHIFT 9
#define  SKEW_ODMA_INT_EN_BRESP_INT_EN_MASK_SHIFT(reg) (((reg) & SKEW_ODMA_INT_EN_BRESP_INT_EN_MASK) >> SKEW_ODMA_INT_EN_BRESP_INT_EN_SHIFT)
#define  SKEW_ODMA_INT_EN_BRESP_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~SKEW_ODMA_INT_EN_BRESP_INT_EN_MASK) | (((uint32_t)val) << SKEW_ODMA_INT_EN_BRESP_INT_EN_SHIFT))

#define  SKEW_ODMA_INT_EN_RST_INT_EN_MASK 0x100
#define  SKEW_ODMA_INT_EN_RST_INT_EN_SHIFT 8
#define  SKEW_ODMA_INT_EN_RST_INT_EN_MASK_SHIFT(reg) (((reg) & SKEW_ODMA_INT_EN_RST_INT_EN_MASK) >> SKEW_ODMA_INT_EN_RST_INT_EN_SHIFT)
#define  SKEW_ODMA_INT_EN_RST_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~SKEW_ODMA_INT_EN_RST_INT_EN_MASK) | (((uint32_t)val) << SKEW_ODMA_INT_EN_RST_INT_EN_SHIFT))

#define  SKEW_ODMA_INT_EN_EOI_INT_EN_MASK 0x80
#define  SKEW_ODMA_INT_EN_EOI_INT_EN_SHIFT 7
#define  SKEW_ODMA_INT_EN_EOI_INT_EN_MASK_SHIFT(reg) (((reg) & SKEW_ODMA_INT_EN_EOI_INT_EN_MASK) >> SKEW_ODMA_INT_EN_EOI_INT_EN_SHIFT)
#define  SKEW_ODMA_INT_EN_EOI_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~SKEW_ODMA_INT_EN_EOI_INT_EN_MASK) | (((uint32_t)val) << SKEW_ODMA_INT_EN_EOI_INT_EN_SHIFT))

#define  SKEW_ODMA_INT_EN_DIR_INT_EN_MASK 0x40
#define  SKEW_ODMA_INT_EN_DIR_INT_EN_SHIFT 6
#define  SKEW_ODMA_INT_EN_DIR_INT_EN_MASK_SHIFT(reg) (((reg) & SKEW_ODMA_INT_EN_DIR_INT_EN_MASK) >> SKEW_ODMA_INT_EN_DIR_INT_EN_SHIFT)
#define  SKEW_ODMA_INT_EN_DIR_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~SKEW_ODMA_INT_EN_DIR_INT_EN_MASK) | (((uint32_t)val) << SKEW_ODMA_INT_EN_DIR_INT_EN_SHIFT))

#define  SKEW_ODMA_INT_EN_CL_ALI_INT_EN_MASK 0x20
#define  SKEW_ODMA_INT_EN_CL_ALI_INT_EN_SHIFT 5
#define  SKEW_ODMA_INT_EN_CL_ALI_INT_EN_MASK_SHIFT(reg) (((reg) & SKEW_ODMA_INT_EN_CL_ALI_INT_EN_MASK) >> SKEW_ODMA_INT_EN_CL_ALI_INT_EN_SHIFT)
#define  SKEW_ODMA_INT_EN_CL_ALI_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~SKEW_ODMA_INT_EN_CL_ALI_INT_EN_MASK) | (((uint32_t)val) << SKEW_ODMA_INT_EN_CL_ALI_INT_EN_SHIFT))

#define  SKEW_ODMA_INT_EN_EOL_ALI_INT_EN_MASK 0x10
#define  SKEW_ODMA_INT_EN_EOL_ALI_INT_EN_SHIFT 4
#define  SKEW_ODMA_INT_EN_EOL_ALI_INT_EN_MASK_SHIFT(reg) (((reg) & SKEW_ODMA_INT_EN_EOL_ALI_INT_EN_MASK) >> SKEW_ODMA_INT_EN_EOL_ALI_INT_EN_SHIFT)
#define  SKEW_ODMA_INT_EN_EOL_ALI_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~SKEW_ODMA_INT_EN_EOL_ALI_INT_EN_MASK) | (((uint32_t)val) << SKEW_ODMA_INT_EN_EOL_ALI_INT_EN_SHIFT))

#define  SKEW_ODMA_INT_EN_EOI_ALI_INT_EN_MASK 0x8
#define  SKEW_ODMA_INT_EN_EOI_ALI_INT_EN_SHIFT 3
#define  SKEW_ODMA_INT_EN_EOI_ALI_INT_EN_MASK_SHIFT(reg) (((reg) & SKEW_ODMA_INT_EN_EOI_ALI_INT_EN_MASK) >> SKEW_ODMA_INT_EN_EOI_ALI_INT_EN_SHIFT)
#define  SKEW_ODMA_INT_EN_EOI_ALI_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~SKEW_ODMA_INT_EN_EOI_ALI_INT_EN_MASK) | (((uint32_t)val) << SKEW_ODMA_INT_EN_EOI_ALI_INT_EN_SHIFT))

#define  SKEW_ODMA_INT_EN_EOI_ERR_INT_EN_MASK 0x4
#define  SKEW_ODMA_INT_EN_EOI_ERR_INT_EN_SHIFT 2
#define  SKEW_ODMA_INT_EN_EOI_ERR_INT_EN_MASK_SHIFT(reg) (((reg) & SKEW_ODMA_INT_EN_EOI_ERR_INT_EN_MASK) >> SKEW_ODMA_INT_EN_EOI_ERR_INT_EN_SHIFT)
#define  SKEW_ODMA_INT_EN_EOI_ERR_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~SKEW_ODMA_INT_EN_EOI_ERR_INT_EN_MASK) | (((uint32_t)val) << SKEW_ODMA_INT_EN_EOI_ERR_INT_EN_SHIFT))

#define  SKEW_ODMA_INT_EN_FIN_INT_EN_MASK 0x2
#define  SKEW_ODMA_INT_EN_FIN_INT_EN_SHIFT 1
#define  SKEW_ODMA_INT_EN_FIN_INT_EN_MASK_SHIFT(reg) (((reg) & SKEW_ODMA_INT_EN_FIN_INT_EN_MASK) >> SKEW_ODMA_INT_EN_FIN_INT_EN_SHIFT)
#define  SKEW_ODMA_INT_EN_FIN_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~SKEW_ODMA_INT_EN_FIN_INT_EN_MASK) | (((uint32_t)val) << SKEW_ODMA_INT_EN_FIN_INT_EN_SHIFT))

#define  SKEW_ODMA_INT_EN_WHO_INT_EN_MASK 0x1
#define  SKEW_ODMA_INT_EN_WHO_INT_EN_SHIFT 0
#define  SKEW_ODMA_INT_EN_WHO_INT_EN_MASK_SHIFT(reg) (((reg) & SKEW_ODMA_INT_EN_WHO_INT_EN_MASK) >> SKEW_ODMA_INT_EN_WHO_INT_EN_SHIFT)
#define  SKEW_ODMA_INT_EN_WHO_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~SKEW_ODMA_INT_EN_WHO_INT_EN_MASK) | (((uint32_t)val) << SKEW_ODMA_INT_EN_WHO_INT_EN_SHIFT))

//====================================================================
//Register: Interrupt Pending Register (int_pend)
//====================================================================

#define  SKEW_ODMA_INT_PEND_RESERVED1_MASK 0xfffff800
#define  SKEW_ODMA_INT_PEND_RESERVED1_SHIFT 11
#define  SKEW_ODMA_INT_PEND_RESERVED1_MASK_SHIFT(reg) (((reg) & SKEW_ODMA_INT_PEND_RESERVED1_MASK) >> SKEW_ODMA_INT_PEND_RESERVED1_SHIFT)
#define  SKEW_ODMA_INT_PEND_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SKEW_ODMA_INT_PEND_RESERVED1_MASK) | (((uint32_t)val) << SKEW_ODMA_INT_PEND_RESERVED1_SHIFT))

#define  SKEW_ODMA_INT_PEND_RRESP_INT_PEND_MASK 0x400
#define  SKEW_ODMA_INT_PEND_RRESP_INT_PEND_SHIFT 10
#define  SKEW_ODMA_INT_PEND_RRESP_INT_PEND_MASK_SHIFT(reg) (((reg) & SKEW_ODMA_INT_PEND_RRESP_INT_PEND_MASK) >> SKEW_ODMA_INT_PEND_RRESP_INT_PEND_SHIFT)
#define  SKEW_ODMA_INT_PEND_RRESP_INT_PEND_REPLACE_VAL(reg,val) (((reg) & ~SKEW_ODMA_INT_PEND_RRESP_INT_PEND_MASK) | (((uint32_t)val) << SKEW_ODMA_INT_PEND_RRESP_INT_PEND_SHIFT))

#define  SKEW_ODMA_INT_PEND_BRESP_INT_PEND_MASK 0x200
#define  SKEW_ODMA_INT_PEND_BRESP_INT_PEND_SHIFT 9
#define  SKEW_ODMA_INT_PEND_BRESP_INT_PEND_MASK_SHIFT(reg) (((reg) & SKEW_ODMA_INT_PEND_BRESP_INT_PEND_MASK) >> SKEW_ODMA_INT_PEND_BRESP_INT_PEND_SHIFT)
#define  SKEW_ODMA_INT_PEND_BRESP_INT_PEND_REPLACE_VAL(reg,val) (((reg) & ~SKEW_ODMA_INT_PEND_BRESP_INT_PEND_MASK) | (((uint32_t)val) << SKEW_ODMA_INT_PEND_BRESP_INT_PEND_SHIFT))

#define  SKEW_ODMA_INT_PEND_RST_INT_PEND_MASK 0x100
#define  SKEW_ODMA_INT_PEND_RST_INT_PEND_SHIFT 8
#define  SKEW_ODMA_INT_PEND_RST_INT_PEND_MASK_SHIFT(reg) (((reg) & SKEW_ODMA_INT_PEND_RST_INT_PEND_MASK) >> SKEW_ODMA_INT_PEND_RST_INT_PEND_SHIFT)
#define  SKEW_ODMA_INT_PEND_RST_INT_PEND_REPLACE_VAL(reg,val) (((reg) & ~SKEW_ODMA_INT_PEND_RST_INT_PEND_MASK) | (((uint32_t)val) << SKEW_ODMA_INT_PEND_RST_INT_PEND_SHIFT))

#define  SKEW_ODMA_INT_PEND_EOI_INT_PEND_MASK 0x80
#define  SKEW_ODMA_INT_PEND_EOI_INT_PEND_SHIFT 7
#define  SKEW_ODMA_INT_PEND_EOI_INT_PEND_MASK_SHIFT(reg) (((reg) & SKEW_ODMA_INT_PEND_EOI_INT_PEND_MASK) >> SKEW_ODMA_INT_PEND_EOI_INT_PEND_SHIFT)
#define  SKEW_ODMA_INT_PEND_EOI_INT_PEND_REPLACE_VAL(reg,val) (((reg) & ~SKEW_ODMA_INT_PEND_EOI_INT_PEND_MASK) | (((uint32_t)val) << SKEW_ODMA_INT_PEND_EOI_INT_PEND_SHIFT))

#define  SKEW_ODMA_INT_PEND_DIR_INT_PEND_MASK 0x40
#define  SKEW_ODMA_INT_PEND_DIR_INT_PEND_SHIFT 6
#define  SKEW_ODMA_INT_PEND_DIR_INT_PEND_MASK_SHIFT(reg) (((reg) & SKEW_ODMA_INT_PEND_DIR_INT_PEND_MASK) >> SKEW_ODMA_INT_PEND_DIR_INT_PEND_SHIFT)
#define  SKEW_ODMA_INT_PEND_DIR_INT_PEND_REPLACE_VAL(reg,val) (((reg) & ~SKEW_ODMA_INT_PEND_DIR_INT_PEND_MASK) | (((uint32_t)val) << SKEW_ODMA_INT_PEND_DIR_INT_PEND_SHIFT))

#define  SKEW_ODMA_INT_PEND_CL_ALI_INT_PEND_MASK 0x20
#define  SKEW_ODMA_INT_PEND_CL_ALI_INT_PEND_SHIFT 5
#define  SKEW_ODMA_INT_PEND_CL_ALI_INT_PEND_MASK_SHIFT(reg) (((reg) & SKEW_ODMA_INT_PEND_CL_ALI_INT_PEND_MASK) >> SKEW_ODMA_INT_PEND_CL_ALI_INT_PEND_SHIFT)
#define  SKEW_ODMA_INT_PEND_CL_ALI_INT_PEND_REPLACE_VAL(reg,val) (((reg) & ~SKEW_ODMA_INT_PEND_CL_ALI_INT_PEND_MASK) | (((uint32_t)val) << SKEW_ODMA_INT_PEND_CL_ALI_INT_PEND_SHIFT))

#define  SKEW_ODMA_INT_PEND_EOL_ALI_INT_PEND_MASK 0x10
#define  SKEW_ODMA_INT_PEND_EOL_ALI_INT_PEND_SHIFT 4
#define  SKEW_ODMA_INT_PEND_EOL_ALI_INT_PEND_MASK_SHIFT(reg) (((reg) & SKEW_ODMA_INT_PEND_EOL_ALI_INT_PEND_MASK) >> SKEW_ODMA_INT_PEND_EOL_ALI_INT_PEND_SHIFT)
#define  SKEW_ODMA_INT_PEND_EOL_ALI_INT_PEND_REPLACE_VAL(reg,val) (((reg) & ~SKEW_ODMA_INT_PEND_EOL_ALI_INT_PEND_MASK) | (((uint32_t)val) << SKEW_ODMA_INT_PEND_EOL_ALI_INT_PEND_SHIFT))

#define  SKEW_ODMA_INT_PEND_EOI_ALI_INT_PEND_MASK 0x8
#define  SKEW_ODMA_INT_PEND_EOI_ALI_INT_PEND_SHIFT 3
#define  SKEW_ODMA_INT_PEND_EOI_ALI_INT_PEND_MASK_SHIFT(reg) (((reg) & SKEW_ODMA_INT_PEND_EOI_ALI_INT_PEND_MASK) >> SKEW_ODMA_INT_PEND_EOI_ALI_INT_PEND_SHIFT)
#define  SKEW_ODMA_INT_PEND_EOI_ALI_INT_PEND_REPLACE_VAL(reg,val) (((reg) & ~SKEW_ODMA_INT_PEND_EOI_ALI_INT_PEND_MASK) | (((uint32_t)val) << SKEW_ODMA_INT_PEND_EOI_ALI_INT_PEND_SHIFT))

#define  SKEW_ODMA_INT_PEND_EOI_ERR_INT_PEND_MASK 0x4
#define  SKEW_ODMA_INT_PEND_EOI_ERR_INT_PEND_SHIFT 2
#define  SKEW_ODMA_INT_PEND_EOI_ERR_INT_PEND_MASK_SHIFT(reg) (((reg) & SKEW_ODMA_INT_PEND_EOI_ERR_INT_PEND_MASK) >> SKEW_ODMA_INT_PEND_EOI_ERR_INT_PEND_SHIFT)
#define  SKEW_ODMA_INT_PEND_EOI_ERR_INT_PEND_REPLACE_VAL(reg,val) (((reg) & ~SKEW_ODMA_INT_PEND_EOI_ERR_INT_PEND_MASK) | (((uint32_t)val) << SKEW_ODMA_INT_PEND_EOI_ERR_INT_PEND_SHIFT))

#define  SKEW_ODMA_INT_PEND_FIN_INT_PEND_MASK 0x2
#define  SKEW_ODMA_INT_PEND_FIN_INT_PEND_SHIFT 1
#define  SKEW_ODMA_INT_PEND_FIN_INT_PEND_MASK_SHIFT(reg) (((reg) & SKEW_ODMA_INT_PEND_FIN_INT_PEND_MASK) >> SKEW_ODMA_INT_PEND_FIN_INT_PEND_SHIFT)
#define  SKEW_ODMA_INT_PEND_FIN_INT_PEND_REPLACE_VAL(reg,val) (((reg) & ~SKEW_ODMA_INT_PEND_FIN_INT_PEND_MASK) | (((uint32_t)val) << SKEW_ODMA_INT_PEND_FIN_INT_PEND_SHIFT))

#define  SKEW_ODMA_INT_PEND_WHO_INT_PEND_MASK 0x1
#define  SKEW_ODMA_INT_PEND_WHO_INT_PEND_SHIFT 0
#define  SKEW_ODMA_INT_PEND_WHO_INT_PEND_MASK_SHIFT(reg) (((reg) & SKEW_ODMA_INT_PEND_WHO_INT_PEND_MASK) >> SKEW_ODMA_INT_PEND_WHO_INT_PEND_SHIFT)
#define  SKEW_ODMA_INT_PEND_WHO_INT_PEND_REPLACE_VAL(reg,val) (((reg) & ~SKEW_ODMA_INT_PEND_WHO_INT_PEND_MASK) | (((uint32_t)val) << SKEW_ODMA_INT_PEND_WHO_INT_PEND_SHIFT))

//====================================================================
//Register: Interrupt Acknowledge Register (int_ack)
//====================================================================

#define  SKEW_ODMA_INT_ACK_RESERVED1_MASK 0xfffff800
#define  SKEW_ODMA_INT_ACK_RESERVED1_SHIFT 11
#define  SKEW_ODMA_INT_ACK_RESERVED1_MASK_SHIFT(reg) (((reg) & SKEW_ODMA_INT_ACK_RESERVED1_MASK) >> SKEW_ODMA_INT_ACK_RESERVED1_SHIFT)
#define  SKEW_ODMA_INT_ACK_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SKEW_ODMA_INT_ACK_RESERVED1_MASK) | (((uint32_t)val) << SKEW_ODMA_INT_ACK_RESERVED1_SHIFT))

#define  SKEW_ODMA_INT_ACK_RRESP_INT_ACK_MASK 0x400
#define  SKEW_ODMA_INT_ACK_RRESP_INT_ACK_SHIFT 10
#define  SKEW_ODMA_INT_ACK_RRESP_INT_ACK_MASK_SHIFT(reg) (((reg) & SKEW_ODMA_INT_ACK_RRESP_INT_ACK_MASK) >> SKEW_ODMA_INT_ACK_RRESP_INT_ACK_SHIFT)
#define  SKEW_ODMA_INT_ACK_RRESP_INT_ACK_REPLACE_VAL(reg,val) (((reg) & ~SKEW_ODMA_INT_ACK_RRESP_INT_ACK_MASK) | (((uint32_t)val) << SKEW_ODMA_INT_ACK_RRESP_INT_ACK_SHIFT))

#define  SKEW_ODMA_INT_ACK_BRESP_INT_ACK_MASK 0x200
#define  SKEW_ODMA_INT_ACK_BRESP_INT_ACK_SHIFT 9
#define  SKEW_ODMA_INT_ACK_BRESP_INT_ACK_MASK_SHIFT(reg) (((reg) & SKEW_ODMA_INT_ACK_BRESP_INT_ACK_MASK) >> SKEW_ODMA_INT_ACK_BRESP_INT_ACK_SHIFT)
#define  SKEW_ODMA_INT_ACK_BRESP_INT_ACK_REPLACE_VAL(reg,val) (((reg) & ~SKEW_ODMA_INT_ACK_BRESP_INT_ACK_MASK) | (((uint32_t)val) << SKEW_ODMA_INT_ACK_BRESP_INT_ACK_SHIFT))

#define  SKEW_ODMA_INT_ACK_RST_INT_ACK_MASK 0x100
#define  SKEW_ODMA_INT_ACK_RST_INT_ACK_SHIFT 8
#define  SKEW_ODMA_INT_ACK_RST_INT_ACK_MASK_SHIFT(reg) (((reg) & SKEW_ODMA_INT_ACK_RST_INT_ACK_MASK) >> SKEW_ODMA_INT_ACK_RST_INT_ACK_SHIFT)
#define  SKEW_ODMA_INT_ACK_RST_INT_ACK_REPLACE_VAL(reg,val) (((reg) & ~SKEW_ODMA_INT_ACK_RST_INT_ACK_MASK) | (((uint32_t)val) << SKEW_ODMA_INT_ACK_RST_INT_ACK_SHIFT))

#define  SKEW_ODMA_INT_ACK_EOI_INT_ACK_MASK 0x80
#define  SKEW_ODMA_INT_ACK_EOI_INT_ACK_SHIFT 7
#define  SKEW_ODMA_INT_ACK_EOI_INT_ACK_MASK_SHIFT(reg) (((reg) & SKEW_ODMA_INT_ACK_EOI_INT_ACK_MASK) >> SKEW_ODMA_INT_ACK_EOI_INT_ACK_SHIFT)
#define  SKEW_ODMA_INT_ACK_EOI_INT_ACK_REPLACE_VAL(reg,val) (((reg) & ~SKEW_ODMA_INT_ACK_EOI_INT_ACK_MASK) | (((uint32_t)val) << SKEW_ODMA_INT_ACK_EOI_INT_ACK_SHIFT))

#define  SKEW_ODMA_INT_ACK_DIR_INT_ACK_MASK 0x40
#define  SKEW_ODMA_INT_ACK_DIR_INT_ACK_SHIFT 6
#define  SKEW_ODMA_INT_ACK_DIR_INT_ACK_MASK_SHIFT(reg) (((reg) & SKEW_ODMA_INT_ACK_DIR_INT_ACK_MASK) >> SKEW_ODMA_INT_ACK_DIR_INT_ACK_SHIFT)
#define  SKEW_ODMA_INT_ACK_DIR_INT_ACK_REPLACE_VAL(reg,val) (((reg) & ~SKEW_ODMA_INT_ACK_DIR_INT_ACK_MASK) | (((uint32_t)val) << SKEW_ODMA_INT_ACK_DIR_INT_ACK_SHIFT))

#define  SKEW_ODMA_INT_ACK_CL_ALI_INT_ACK_MASK 0x20
#define  SKEW_ODMA_INT_ACK_CL_ALI_INT_ACK_SHIFT 5
#define  SKEW_ODMA_INT_ACK_CL_ALI_INT_ACK_MASK_SHIFT(reg) (((reg) & SKEW_ODMA_INT_ACK_CL_ALI_INT_ACK_MASK) >> SKEW_ODMA_INT_ACK_CL_ALI_INT_ACK_SHIFT)
#define  SKEW_ODMA_INT_ACK_CL_ALI_INT_ACK_REPLACE_VAL(reg,val) (((reg) & ~SKEW_ODMA_INT_ACK_CL_ALI_INT_ACK_MASK) | (((uint32_t)val) << SKEW_ODMA_INT_ACK_CL_ALI_INT_ACK_SHIFT))

#define  SKEW_ODMA_INT_ACK_EOL_ALI_INT_ACK_MASK 0x10
#define  SKEW_ODMA_INT_ACK_EOL_ALI_INT_ACK_SHIFT 4
#define  SKEW_ODMA_INT_ACK_EOL_ALI_INT_ACK_MASK_SHIFT(reg) (((reg) & SKEW_ODMA_INT_ACK_EOL_ALI_INT_ACK_MASK) >> SKEW_ODMA_INT_ACK_EOL_ALI_INT_ACK_SHIFT)
#define  SKEW_ODMA_INT_ACK_EOL_ALI_INT_ACK_REPLACE_VAL(reg,val) (((reg) & ~SKEW_ODMA_INT_ACK_EOL_ALI_INT_ACK_MASK) | (((uint32_t)val) << SKEW_ODMA_INT_ACK_EOL_ALI_INT_ACK_SHIFT))

#define  SKEW_ODMA_INT_ACK_EOI_ALI_INT_ACK_MASK 0x8
#define  SKEW_ODMA_INT_ACK_EOI_ALI_INT_ACK_SHIFT 3
#define  SKEW_ODMA_INT_ACK_EOI_ALI_INT_ACK_MASK_SHIFT(reg) (((reg) & SKEW_ODMA_INT_ACK_EOI_ALI_INT_ACK_MASK) >> SKEW_ODMA_INT_ACK_EOI_ALI_INT_ACK_SHIFT)
#define  SKEW_ODMA_INT_ACK_EOI_ALI_INT_ACK_REPLACE_VAL(reg,val) (((reg) & ~SKEW_ODMA_INT_ACK_EOI_ALI_INT_ACK_MASK) | (((uint32_t)val) << SKEW_ODMA_INT_ACK_EOI_ALI_INT_ACK_SHIFT))

#define  SKEW_ODMA_INT_ACK_EOI_ERR_INT_ACK_MASK 0x4
#define  SKEW_ODMA_INT_ACK_EOI_ERR_INT_ACK_SHIFT 2
#define  SKEW_ODMA_INT_ACK_EOI_ERR_INT_ACK_MASK_SHIFT(reg) (((reg) & SKEW_ODMA_INT_ACK_EOI_ERR_INT_ACK_MASK) >> SKEW_ODMA_INT_ACK_EOI_ERR_INT_ACK_SHIFT)
#define  SKEW_ODMA_INT_ACK_EOI_ERR_INT_ACK_REPLACE_VAL(reg,val) (((reg) & ~SKEW_ODMA_INT_ACK_EOI_ERR_INT_ACK_MASK) | (((uint32_t)val) << SKEW_ODMA_INT_ACK_EOI_ERR_INT_ACK_SHIFT))

#define  SKEW_ODMA_INT_ACK_FIN_INT_ACK_MASK 0x2
#define  SKEW_ODMA_INT_ACK_FIN_INT_ACK_SHIFT 1
#define  SKEW_ODMA_INT_ACK_FIN_INT_ACK_MASK_SHIFT(reg) (((reg) & SKEW_ODMA_INT_ACK_FIN_INT_ACK_MASK) >> SKEW_ODMA_INT_ACK_FIN_INT_ACK_SHIFT)
#define  SKEW_ODMA_INT_ACK_FIN_INT_ACK_REPLACE_VAL(reg,val) (((reg) & ~SKEW_ODMA_INT_ACK_FIN_INT_ACK_MASK) | (((uint32_t)val) << SKEW_ODMA_INT_ACK_FIN_INT_ACK_SHIFT))

#define  SKEW_ODMA_INT_ACK_WHO_INT_ACK_MASK 0x1
#define  SKEW_ODMA_INT_ACK_WHO_INT_ACK_SHIFT 0
#define  SKEW_ODMA_INT_ACK_WHO_INT_ACK_MASK_SHIFT(reg) (((reg) & SKEW_ODMA_INT_ACK_WHO_INT_ACK_MASK) >> SKEW_ODMA_INT_ACK_WHO_INT_ACK_SHIFT)
#define  SKEW_ODMA_INT_ACK_WHO_INT_ACK_REPLACE_VAL(reg,val) (((reg) & ~SKEW_ODMA_INT_ACK_WHO_INT_ACK_MASK) | (((uint32_t)val) << SKEW_ODMA_INT_ACK_WHO_INT_ACK_SHIFT))

//====================================================================
//Register: Interrupt Force Register (int_fo)
//====================================================================

#define  SKEW_ODMA_INT_FO_RESERVED1_MASK 0xfffff800
#define  SKEW_ODMA_INT_FO_RESERVED1_SHIFT 11
#define  SKEW_ODMA_INT_FO_RESERVED1_MASK_SHIFT(reg) (((reg) & SKEW_ODMA_INT_FO_RESERVED1_MASK) >> SKEW_ODMA_INT_FO_RESERVED1_SHIFT)
#define  SKEW_ODMA_INT_FO_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SKEW_ODMA_INT_FO_RESERVED1_MASK) | (((uint32_t)val) << SKEW_ODMA_INT_FO_RESERVED1_SHIFT))

#define  SKEW_ODMA_INT_FO_RRESP_INT_FO_MASK 0x400
#define  SKEW_ODMA_INT_FO_RRESP_INT_FO_SHIFT 10
#define  SKEW_ODMA_INT_FO_RRESP_INT_FO_MASK_SHIFT(reg) (((reg) & SKEW_ODMA_INT_FO_RRESP_INT_FO_MASK) >> SKEW_ODMA_INT_FO_RRESP_INT_FO_SHIFT)
#define  SKEW_ODMA_INT_FO_RRESP_INT_FO_REPLACE_VAL(reg,val) (((reg) & ~SKEW_ODMA_INT_FO_RRESP_INT_FO_MASK) | (((uint32_t)val) << SKEW_ODMA_INT_FO_RRESP_INT_FO_SHIFT))

#define  SKEW_ODMA_INT_FO_BRESP_INT_FO_MASK 0x200
#define  SKEW_ODMA_INT_FO_BRESP_INT_FO_SHIFT 9
#define  SKEW_ODMA_INT_FO_BRESP_INT_FO_MASK_SHIFT(reg) (((reg) & SKEW_ODMA_INT_FO_BRESP_INT_FO_MASK) >> SKEW_ODMA_INT_FO_BRESP_INT_FO_SHIFT)
#define  SKEW_ODMA_INT_FO_BRESP_INT_FO_REPLACE_VAL(reg,val) (((reg) & ~SKEW_ODMA_INT_FO_BRESP_INT_FO_MASK) | (((uint32_t)val) << SKEW_ODMA_INT_FO_BRESP_INT_FO_SHIFT))

#define  SKEW_ODMA_INT_FO_RST_INT_FO_MASK 0x100
#define  SKEW_ODMA_INT_FO_RST_INT_FO_SHIFT 8
#define  SKEW_ODMA_INT_FO_RST_INT_FO_MASK_SHIFT(reg) (((reg) & SKEW_ODMA_INT_FO_RST_INT_FO_MASK) >> SKEW_ODMA_INT_FO_RST_INT_FO_SHIFT)
#define  SKEW_ODMA_INT_FO_RST_INT_FO_REPLACE_VAL(reg,val) (((reg) & ~SKEW_ODMA_INT_FO_RST_INT_FO_MASK) | (((uint32_t)val) << SKEW_ODMA_INT_FO_RST_INT_FO_SHIFT))

#define  SKEW_ODMA_INT_FO_EOI_INT_FO_MASK 0x80
#define  SKEW_ODMA_INT_FO_EOI_INT_FO_SHIFT 7
#define  SKEW_ODMA_INT_FO_EOI_INT_FO_MASK_SHIFT(reg) (((reg) & SKEW_ODMA_INT_FO_EOI_INT_FO_MASK) >> SKEW_ODMA_INT_FO_EOI_INT_FO_SHIFT)
#define  SKEW_ODMA_INT_FO_EOI_INT_FO_REPLACE_VAL(reg,val) (((reg) & ~SKEW_ODMA_INT_FO_EOI_INT_FO_MASK) | (((uint32_t)val) << SKEW_ODMA_INT_FO_EOI_INT_FO_SHIFT))

#define  SKEW_ODMA_INT_FO_DIR_INT_FO_MASK 0x40
#define  SKEW_ODMA_INT_FO_DIR_INT_FO_SHIFT 6
#define  SKEW_ODMA_INT_FO_DIR_INT_FO_MASK_SHIFT(reg) (((reg) & SKEW_ODMA_INT_FO_DIR_INT_FO_MASK) >> SKEW_ODMA_INT_FO_DIR_INT_FO_SHIFT)
#define  SKEW_ODMA_INT_FO_DIR_INT_FO_REPLACE_VAL(reg,val) (((reg) & ~SKEW_ODMA_INT_FO_DIR_INT_FO_MASK) | (((uint32_t)val) << SKEW_ODMA_INT_FO_DIR_INT_FO_SHIFT))

#define  SKEW_ODMA_INT_FO_CL_ALI_INT_FO_MASK 0x20
#define  SKEW_ODMA_INT_FO_CL_ALI_INT_FO_SHIFT 5
#define  SKEW_ODMA_INT_FO_CL_ALI_INT_FO_MASK_SHIFT(reg) (((reg) & SKEW_ODMA_INT_FO_CL_ALI_INT_FO_MASK) >> SKEW_ODMA_INT_FO_CL_ALI_INT_FO_SHIFT)
#define  SKEW_ODMA_INT_FO_CL_ALI_INT_FO_REPLACE_VAL(reg,val) (((reg) & ~SKEW_ODMA_INT_FO_CL_ALI_INT_FO_MASK) | (((uint32_t)val) << SKEW_ODMA_INT_FO_CL_ALI_INT_FO_SHIFT))

#define  SKEW_ODMA_INT_FO_EOL_ALI_INT_FO_MASK 0x10
#define  SKEW_ODMA_INT_FO_EOL_ALI_INT_FO_SHIFT 4
#define  SKEW_ODMA_INT_FO_EOL_ALI_INT_FO_MASK_SHIFT(reg) (((reg) & SKEW_ODMA_INT_FO_EOL_ALI_INT_FO_MASK) >> SKEW_ODMA_INT_FO_EOL_ALI_INT_FO_SHIFT)
#define  SKEW_ODMA_INT_FO_EOL_ALI_INT_FO_REPLACE_VAL(reg,val) (((reg) & ~SKEW_ODMA_INT_FO_EOL_ALI_INT_FO_MASK) | (((uint32_t)val) << SKEW_ODMA_INT_FO_EOL_ALI_INT_FO_SHIFT))

#define  SKEW_ODMA_INT_FO_EOI_ALI_INT_FO_MASK 0x8
#define  SKEW_ODMA_INT_FO_EOI_ALI_INT_FO_SHIFT 3
#define  SKEW_ODMA_INT_FO_EOI_ALI_INT_FO_MASK_SHIFT(reg) (((reg) & SKEW_ODMA_INT_FO_EOI_ALI_INT_FO_MASK) >> SKEW_ODMA_INT_FO_EOI_ALI_INT_FO_SHIFT)
#define  SKEW_ODMA_INT_FO_EOI_ALI_INT_FO_REPLACE_VAL(reg,val) (((reg) & ~SKEW_ODMA_INT_FO_EOI_ALI_INT_FO_MASK) | (((uint32_t)val) << SKEW_ODMA_INT_FO_EOI_ALI_INT_FO_SHIFT))

#define  SKEW_ODMA_INT_FO_EOI_ERR_INT_FO_MASK 0x4
#define  SKEW_ODMA_INT_FO_EOI_ERR_INT_FO_SHIFT 2
#define  SKEW_ODMA_INT_FO_EOI_ERR_INT_FO_MASK_SHIFT(reg) (((reg) & SKEW_ODMA_INT_FO_EOI_ERR_INT_FO_MASK) >> SKEW_ODMA_INT_FO_EOI_ERR_INT_FO_SHIFT)
#define  SKEW_ODMA_INT_FO_EOI_ERR_INT_FO_REPLACE_VAL(reg,val) (((reg) & ~SKEW_ODMA_INT_FO_EOI_ERR_INT_FO_MASK) | (((uint32_t)val) << SKEW_ODMA_INT_FO_EOI_ERR_INT_FO_SHIFT))

#define  SKEW_ODMA_INT_FO_FIN_INT_FO_MASK 0x2
#define  SKEW_ODMA_INT_FO_FIN_INT_FO_SHIFT 1
#define  SKEW_ODMA_INT_FO_FIN_INT_FO_MASK_SHIFT(reg) (((reg) & SKEW_ODMA_INT_FO_FIN_INT_FO_MASK) >> SKEW_ODMA_INT_FO_FIN_INT_FO_SHIFT)
#define  SKEW_ODMA_INT_FO_FIN_INT_FO_REPLACE_VAL(reg,val) (((reg) & ~SKEW_ODMA_INT_FO_FIN_INT_FO_MASK) | (((uint32_t)val) << SKEW_ODMA_INT_FO_FIN_INT_FO_SHIFT))

#define  SKEW_ODMA_INT_FO_WHO_INT_FO_MASK 0x1
#define  SKEW_ODMA_INT_FO_WHO_INT_FO_SHIFT 0
#define  SKEW_ODMA_INT_FO_WHO_INT_FO_MASK_SHIFT(reg) (((reg) & SKEW_ODMA_INT_FO_WHO_INT_FO_MASK) >> SKEW_ODMA_INT_FO_WHO_INT_FO_SHIFT)
#define  SKEW_ODMA_INT_FO_WHO_INT_FO_REPLACE_VAL(reg,val) (((reg) & ~SKEW_ODMA_INT_FO_WHO_INT_FO_MASK) | (((uint32_t)val) << SKEW_ODMA_INT_FO_WHO_INT_FO_SHIFT))

//====================================================================
//Register: Descriptor Write Register (desc_write)
//====================================================================

#define  SKEW_ODMA_DESC_WRITE_DESC_MASK 0xfffffffc
#define  SKEW_ODMA_DESC_WRITE_DESC_SHIFT 2
#define  SKEW_ODMA_DESC_WRITE_DESC_MASK_SHIFT(reg) (((reg) & SKEW_ODMA_DESC_WRITE_DESC_MASK) >> SKEW_ODMA_DESC_WRITE_DESC_SHIFT)
#define  SKEW_ODMA_DESC_WRITE_DESC_REPLACE_VAL(reg,val) (((reg) & ~SKEW_ODMA_DESC_WRITE_DESC_MASK) | (((uint32_t)val) << SKEW_ODMA_DESC_WRITE_DESC_SHIFT))

#define  SKEW_ODMA_DESC_WRITE_RESERVED1_MASK 0x3
#define  SKEW_ODMA_DESC_WRITE_RESERVED1_SHIFT 0
#define  SKEW_ODMA_DESC_WRITE_RESERVED1_MASK_SHIFT(reg) (((reg) & SKEW_ODMA_DESC_WRITE_RESERVED1_MASK) >> SKEW_ODMA_DESC_WRITE_RESERVED1_SHIFT)
#define  SKEW_ODMA_DESC_WRITE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SKEW_ODMA_DESC_WRITE_RESERVED1_MASK) | (((uint32_t)val) << SKEW_ODMA_DESC_WRITE_RESERVED1_SHIFT))

//====================================================================
//Register: Descriptor Read Register (desc_read)
//====================================================================

#define  SKEW_ODMA_DESC_READ_DESC_MASK 0xffffffff
#define  SKEW_ODMA_DESC_READ_DESC_SHIFT 0
#define  SKEW_ODMA_DESC_READ_DESC_MASK_SHIFT(reg) (((reg) & SKEW_ODMA_DESC_READ_DESC_MASK) >> SKEW_ODMA_DESC_READ_DESC_SHIFT)
#define  SKEW_ODMA_DESC_READ_DESC_REPLACE_VAL(reg,val) (((reg) & ~SKEW_ODMA_DESC_READ_DESC_MASK) | (((uint32_t)val) << SKEW_ODMA_DESC_READ_DESC_SHIFT))

//====================================================================
//Register: Descriptor Transfer Length Register (xfer_length)
//====================================================================

#define  SKEW_ODMA_XFER_LENGTH_LEN_MASK 0xffffffff
#define  SKEW_ODMA_XFER_LENGTH_LEN_SHIFT 0
#define  SKEW_ODMA_XFER_LENGTH_LEN_MASK_SHIFT(reg) (((reg) & SKEW_ODMA_XFER_LENGTH_LEN_MASK) >> SKEW_ODMA_XFER_LENGTH_LEN_SHIFT)
#define  SKEW_ODMA_XFER_LENGTH_LEN_REPLACE_VAL(reg,val) (((reg) & ~SKEW_ODMA_XFER_LENGTH_LEN_MASK) | (((uint32_t)val) << SKEW_ODMA_XFER_LENGTH_LEN_SHIFT))

//====================================================================
//Register: Descriptor Transfer Address Register (xfer_addr)
//====================================================================

#define  SKEW_ODMA_XFER_ADDR_ADDR_MASK 0xffffffff
#define  SKEW_ODMA_XFER_ADDR_ADDR_SHIFT 0
#define  SKEW_ODMA_XFER_ADDR_ADDR_MASK_SHIFT(reg) (((reg) & SKEW_ODMA_XFER_ADDR_ADDR_MASK) >> SKEW_ODMA_XFER_ADDR_ADDR_SHIFT)
#define  SKEW_ODMA_XFER_ADDR_ADDR_REPLACE_VAL(reg,val) (((reg) & ~SKEW_ODMA_XFER_ADDR_ADDR_MASK) | (((uint32_t)val) << SKEW_ODMA_XFER_ADDR_ADDR_SHIFT))

//====================================================================
//Register: Descriptor Transfer Burst Register (xfer_burst)
//====================================================================

#define  SKEW_ODMA_XFER_BURST_RESERVED1_MASK 0xffffffe0
#define  SKEW_ODMA_XFER_BURST_RESERVED1_SHIFT 5
#define  SKEW_ODMA_XFER_BURST_RESERVED1_MASK_SHIFT(reg) (((reg) & SKEW_ODMA_XFER_BURST_RESERVED1_MASK) >> SKEW_ODMA_XFER_BURST_RESERVED1_SHIFT)
#define  SKEW_ODMA_XFER_BURST_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SKEW_ODMA_XFER_BURST_RESERVED1_MASK) | (((uint32_t)val) << SKEW_ODMA_XFER_BURST_RESERVED1_SHIFT))

#define  SKEW_ODMA_XFER_BURST_BURST_MASK 0x1f
#define  SKEW_ODMA_XFER_BURST_BURST_SHIFT 0
#define  SKEW_ODMA_XFER_BURST_BURST_MASK_SHIFT(reg) (((reg) & SKEW_ODMA_XFER_BURST_BURST_MASK) >> SKEW_ODMA_XFER_BURST_BURST_SHIFT)
#define  SKEW_ODMA_XFER_BURST_BURST_REPLACE_VAL(reg,val) (((reg) & ~SKEW_ODMA_XFER_BURST_BURST_MASK) | (((uint32_t)val) << SKEW_ODMA_XFER_BURST_BURST_SHIFT))

//====================================================================
//Register: Soft Reset register (reset)
//====================================================================

#define  SKEW_ODMA_RESET_RESERVED1_MASK 0xfffffffc
#define  SKEW_ODMA_RESET_RESERVED1_SHIFT 2
#define  SKEW_ODMA_RESET_RESERVED1_MASK_SHIFT(reg) (((reg) & SKEW_ODMA_RESET_RESERVED1_MASK) >> SKEW_ODMA_RESET_RESERVED1_SHIFT)
#define  SKEW_ODMA_RESET_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SKEW_ODMA_RESET_RESERVED1_MASK) | (((uint32_t)val) << SKEW_ODMA_RESET_RESERVED1_SHIFT))

#define  SKEW_ODMA_RESET_FORCE_LAST_BURST_MASK 0x2
#define  SKEW_ODMA_RESET_FORCE_LAST_BURST_SHIFT 1
#define  SKEW_ODMA_RESET_FORCE_LAST_BURST_MASK_SHIFT(reg) (((reg) & SKEW_ODMA_RESET_FORCE_LAST_BURST_MASK) >> SKEW_ODMA_RESET_FORCE_LAST_BURST_SHIFT)
#define  SKEW_ODMA_RESET_FORCE_LAST_BURST_REPLACE_VAL(reg,val) (((reg) & ~SKEW_ODMA_RESET_FORCE_LAST_BURST_MASK) | (((uint32_t)val) << SKEW_ODMA_RESET_FORCE_LAST_BURST_SHIFT))

#define  SKEW_ODMA_RESET_SOFT_RESET_MASK 0x1
#define  SKEW_ODMA_RESET_SOFT_RESET_SHIFT 0
#define  SKEW_ODMA_RESET_SOFT_RESET_MASK_SHIFT(reg) (((reg) & SKEW_ODMA_RESET_SOFT_RESET_MASK) >> SKEW_ODMA_RESET_SOFT_RESET_SHIFT)
#define  SKEW_ODMA_RESET_SOFT_RESET_REPLACE_VAL(reg,val) (((reg) & ~SKEW_ODMA_RESET_SOFT_RESET_MASK) | (((uint32_t)val) << SKEW_ODMA_RESET_SOFT_RESET_SHIFT))

//====================================================================
//Register: IP Tagging Revision 0 (REV0)
/** \brief Provide means for firmware to read IP tagging information.
      This register of particular interest to firmware.*/
//====================================================================

#define  SKEW_ODMA_REV0_MAJ_MASK 0xffff0000
#define  SKEW_ODMA_REV0_MAJ_SHIFT 16
#define  SKEW_ODMA_REV0_MAJ_MASK_SHIFT(reg) (((reg) & SKEW_ODMA_REV0_MAJ_MASK) >> SKEW_ODMA_REV0_MAJ_SHIFT)
#define  SKEW_ODMA_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~SKEW_ODMA_REV0_MAJ_MASK) | (((uint32_t)val) << SKEW_ODMA_REV0_MAJ_SHIFT))

#define  SKEW_ODMA_REV0_MID_MASK 0xffff
#define  SKEW_ODMA_REV0_MID_SHIFT 0
#define  SKEW_ODMA_REV0_MID_MASK_SHIFT(reg) (((reg) & SKEW_ODMA_REV0_MID_MASK) >> SKEW_ODMA_REV0_MID_SHIFT)
#define  SKEW_ODMA_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~SKEW_ODMA_REV0_MID_MASK) | (((uint32_t)val) << SKEW_ODMA_REV0_MID_SHIFT))

//====================================================================
//Register: IP Tagging Revision 1 (REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  SKEW_ODMA_REV1_RESERVED1_MASK 0xffff0000
#define  SKEW_ODMA_REV1_RESERVED1_SHIFT 16
#define  SKEW_ODMA_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & SKEW_ODMA_REV1_RESERVED1_MASK) >> SKEW_ODMA_REV1_RESERVED1_SHIFT)
#define  SKEW_ODMA_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~SKEW_ODMA_REV1_RESERVED1_MASK) | (((uint32_t)val) << SKEW_ODMA_REV1_RESERVED1_SHIFT))

#define  SKEW_ODMA_REV1_CFG_MASK 0xffff
#define  SKEW_ODMA_REV1_CFG_SHIFT 0
#define  SKEW_ODMA_REV1_CFG_MASK_SHIFT(reg) (((reg) & SKEW_ODMA_REV1_CFG_MASK) >> SKEW_ODMA_REV1_CFG_SHIFT)
#define  SKEW_ODMA_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~SKEW_ODMA_REV1_CFG_MASK) | (((uint32_t)val) << SKEW_ODMA_REV1_CFG_SHIFT))

//====================================================================
//
//Register File: AntiFlin (ANTIFLIN)
/** \brief Register descriptions for the ANTIFLIN block.
    (rev 0 . 0 . 5 . 1)*/
//
//====================================================================

//====================================================================
//Register: Control (Control)
//====================================================================

#define  ANTIFLIN_CONTROL_RESERVED1_MASK 0xfffffff8
#define  ANTIFLIN_CONTROL_RESERVED1_SHIFT 3
#define  ANTIFLIN_CONTROL_RESERVED1_MASK_SHIFT(reg) (((reg) & ANTIFLIN_CONTROL_RESERVED1_MASK) >> ANTIFLIN_CONTROL_RESERVED1_SHIFT)
#define  ANTIFLIN_CONTROL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_CONTROL_RESERVED1_MASK) | (((uint32_t)val) << ANTIFLIN_CONTROL_RESERVED1_SHIFT))

#define  ANTIFLIN_CONTROL_RAMACCESS_MASK 0x4
#define  ANTIFLIN_CONTROL_RAMACCESS_SHIFT 2
#define  ANTIFLIN_CONTROL_RAMACCESS_MASK_SHIFT(reg) (((reg) & ANTIFLIN_CONTROL_RAMACCESS_MASK) >> ANTIFLIN_CONTROL_RAMACCESS_SHIFT)
#define  ANTIFLIN_CONTROL_RAMACCESS_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_CONTROL_RAMACCESS_MASK) | (((uint32_t)val) << ANTIFLIN_CONTROL_RAMACCESS_SHIFT))

#define  ANTIFLIN_CONTROL_PSENABLE_MASK 0x2
#define  ANTIFLIN_CONTROL_PSENABLE_SHIFT 1
#define  ANTIFLIN_CONTROL_PSENABLE_MASK_SHIFT(reg) (((reg) & ANTIFLIN_CONTROL_PSENABLE_MASK) >> ANTIFLIN_CONTROL_PSENABLE_SHIFT)
#define  ANTIFLIN_CONTROL_PSENABLE_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_CONTROL_PSENABLE_MASK) | (((uint32_t)val) << ANTIFLIN_CONTROL_PSENABLE_SHIFT))

#define  ANTIFLIN_CONTROL_BYPASS_MASK 0x1
#define  ANTIFLIN_CONTROL_BYPASS_SHIFT 0
#define  ANTIFLIN_CONTROL_BYPASS_MASK_SHIFT(reg) (((reg) & ANTIFLIN_CONTROL_BYPASS_MASK) >> ANTIFLIN_CONTROL_BYPASS_SHIFT)
#define  ANTIFLIN_CONTROL_BYPASS_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_CONTROL_BYPASS_MASK) | (((uint32_t)val) << ANTIFLIN_CONTROL_BYPASS_SHIFT))

//====================================================================
//Register: Channel 1 (C1)
//====================================================================

#define  ANTIFLIN_C1_RESERVED1_MASK 0x80000000
#define  ANTIFLIN_C1_RESERVED1_SHIFT 31
#define  ANTIFLIN_C1_RESERVED1_MASK_SHIFT(reg) (((reg) & ANTIFLIN_C1_RESERVED1_MASK) >> ANTIFLIN_C1_RESERVED1_SHIFT)
#define  ANTIFLIN_C1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_C1_RESERVED1_MASK) | (((uint32_t)val) << ANTIFLIN_C1_RESERVED1_SHIFT))

#define  ANTIFLIN_C1_PASSTHRU_MASK 0x40000000
#define  ANTIFLIN_C1_PASSTHRU_SHIFT 30
#define  ANTIFLIN_C1_PASSTHRU_MASK_SHIFT(reg) (((reg) & ANTIFLIN_C1_PASSTHRU_MASK) >> ANTIFLIN_C1_PASSTHRU_SHIFT)
#define  ANTIFLIN_C1_PASSTHRU_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_C1_PASSTHRU_MASK) | (((uint32_t)val) << ANTIFLIN_C1_PASSTHRU_SHIFT))

#define  ANTIFLIN_C1_RESERVED2_MASK 0x3ff00000
#define  ANTIFLIN_C1_RESERVED2_SHIFT 20
#define  ANTIFLIN_C1_RESERVED2_MASK_SHIFT(reg) (((reg) & ANTIFLIN_C1_RESERVED2_MASK) >> ANTIFLIN_C1_RESERVED2_SHIFT)
#define  ANTIFLIN_C1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_C1_RESERVED2_MASK) | (((uint32_t)val) << ANTIFLIN_C1_RESERVED2_SHIFT))

#define  ANTIFLIN_C1_FRACTIONSHIFT_MASK 0xf0000
#define  ANTIFLIN_C1_FRACTIONSHIFT_SHIFT 16
#define  ANTIFLIN_C1_FRACTIONSHIFT_MASK_SHIFT(reg) (((reg) & ANTIFLIN_C1_FRACTIONSHIFT_MASK) >> ANTIFLIN_C1_FRACTIONSHIFT_SHIFT)
#define  ANTIFLIN_C1_FRACTIONSHIFT_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_C1_FRACTIONSHIFT_MASK) | (((uint32_t)val) << ANTIFLIN_C1_FRACTIONSHIFT_SHIFT))

#define  ANTIFLIN_C1_RESERVED3_MASK 0x8000
#define  ANTIFLIN_C1_RESERVED3_SHIFT 15
#define  ANTIFLIN_C1_RESERVED3_MASK_SHIFT(reg) (((reg) & ANTIFLIN_C1_RESERVED3_MASK) >> ANTIFLIN_C1_RESERVED3_SHIFT)
#define  ANTIFLIN_C1_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_C1_RESERVED3_MASK) | (((uint32_t)val) << ANTIFLIN_C1_RESERVED3_SHIFT))

#define  ANTIFLIN_C1_SUBSAMPLEY_MASK 0x7000
#define  ANTIFLIN_C1_SUBSAMPLEY_SHIFT 12
#define  ANTIFLIN_C1_SUBSAMPLEY_MASK_SHIFT(reg) (((reg) & ANTIFLIN_C1_SUBSAMPLEY_MASK) >> ANTIFLIN_C1_SUBSAMPLEY_SHIFT)
#define  ANTIFLIN_C1_SUBSAMPLEY_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_C1_SUBSAMPLEY_MASK) | (((uint32_t)val) << ANTIFLIN_C1_SUBSAMPLEY_SHIFT))

#define  ANTIFLIN_C1_RESERVED4_MASK 0x800
#define  ANTIFLIN_C1_RESERVED4_SHIFT 11
#define  ANTIFLIN_C1_RESERVED4_MASK_SHIFT(reg) (((reg) & ANTIFLIN_C1_RESERVED4_MASK) >> ANTIFLIN_C1_RESERVED4_SHIFT)
#define  ANTIFLIN_C1_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_C1_RESERVED4_MASK) | (((uint32_t)val) << ANTIFLIN_C1_RESERVED4_SHIFT))

#define  ANTIFLIN_C1_SUBSAMPLEX_MASK 0x700
#define  ANTIFLIN_C1_SUBSAMPLEX_SHIFT 8
#define  ANTIFLIN_C1_SUBSAMPLEX_MASK_SHIFT(reg) (((reg) & ANTIFLIN_C1_SUBSAMPLEX_MASK) >> ANTIFLIN_C1_SUBSAMPLEX_SHIFT)
#define  ANTIFLIN_C1_SUBSAMPLEX_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_C1_SUBSAMPLEX_MASK) | (((uint32_t)val) << ANTIFLIN_C1_SUBSAMPLEX_SHIFT))

#define  ANTIFLIN_C1_IGNOREY_MASK 0xff
#define  ANTIFLIN_C1_IGNOREY_SHIFT 0
#define  ANTIFLIN_C1_IGNOREY_MASK_SHIFT(reg) (((reg) & ANTIFLIN_C1_IGNOREY_MASK) >> ANTIFLIN_C1_IGNOREY_SHIFT)
#define  ANTIFLIN_C1_IGNOREY_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_C1_IGNOREY_MASK) | (((uint32_t)val) << ANTIFLIN_C1_IGNOREY_SHIFT))

//====================================================================
//Register: Channel 2 (C2)
//====================================================================

#define  ANTIFLIN_C2_RESERVED1_MASK 0x80000000
#define  ANTIFLIN_C2_RESERVED1_SHIFT 31
#define  ANTIFLIN_C2_RESERVED1_MASK_SHIFT(reg) (((reg) & ANTIFLIN_C2_RESERVED1_MASK) >> ANTIFLIN_C2_RESERVED1_SHIFT)
#define  ANTIFLIN_C2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_C2_RESERVED1_MASK) | (((uint32_t)val) << ANTIFLIN_C2_RESERVED1_SHIFT))

#define  ANTIFLIN_C2_PASSTHRU_MASK 0x40000000
#define  ANTIFLIN_C2_PASSTHRU_SHIFT 30
#define  ANTIFLIN_C2_PASSTHRU_MASK_SHIFT(reg) (((reg) & ANTIFLIN_C2_PASSTHRU_MASK) >> ANTIFLIN_C2_PASSTHRU_SHIFT)
#define  ANTIFLIN_C2_PASSTHRU_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_C2_PASSTHRU_MASK) | (((uint32_t)val) << ANTIFLIN_C2_PASSTHRU_SHIFT))

#define  ANTIFLIN_C2_RESERVED2_MASK 0x3ff00000
#define  ANTIFLIN_C2_RESERVED2_SHIFT 20
#define  ANTIFLIN_C2_RESERVED2_MASK_SHIFT(reg) (((reg) & ANTIFLIN_C2_RESERVED2_MASK) >> ANTIFLIN_C2_RESERVED2_SHIFT)
#define  ANTIFLIN_C2_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_C2_RESERVED2_MASK) | (((uint32_t)val) << ANTIFLIN_C2_RESERVED2_SHIFT))

#define  ANTIFLIN_C2_FRACTIONSHIFT_MASK 0xf0000
#define  ANTIFLIN_C2_FRACTIONSHIFT_SHIFT 16
#define  ANTIFLIN_C2_FRACTIONSHIFT_MASK_SHIFT(reg) (((reg) & ANTIFLIN_C2_FRACTIONSHIFT_MASK) >> ANTIFLIN_C2_FRACTIONSHIFT_SHIFT)
#define  ANTIFLIN_C2_FRACTIONSHIFT_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_C2_FRACTIONSHIFT_MASK) | (((uint32_t)val) << ANTIFLIN_C2_FRACTIONSHIFT_SHIFT))

#define  ANTIFLIN_C2_RESERVED3_MASK 0x8000
#define  ANTIFLIN_C2_RESERVED3_SHIFT 15
#define  ANTIFLIN_C2_RESERVED3_MASK_SHIFT(reg) (((reg) & ANTIFLIN_C2_RESERVED3_MASK) >> ANTIFLIN_C2_RESERVED3_SHIFT)
#define  ANTIFLIN_C2_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_C2_RESERVED3_MASK) | (((uint32_t)val) << ANTIFLIN_C2_RESERVED3_SHIFT))

#define  ANTIFLIN_C2_SUBSAMPLEY_MASK 0x7000
#define  ANTIFLIN_C2_SUBSAMPLEY_SHIFT 12
#define  ANTIFLIN_C2_SUBSAMPLEY_MASK_SHIFT(reg) (((reg) & ANTIFLIN_C2_SUBSAMPLEY_MASK) >> ANTIFLIN_C2_SUBSAMPLEY_SHIFT)
#define  ANTIFLIN_C2_SUBSAMPLEY_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_C2_SUBSAMPLEY_MASK) | (((uint32_t)val) << ANTIFLIN_C2_SUBSAMPLEY_SHIFT))

#define  ANTIFLIN_C2_RESERVED4_MASK 0x800
#define  ANTIFLIN_C2_RESERVED4_SHIFT 11
#define  ANTIFLIN_C2_RESERVED4_MASK_SHIFT(reg) (((reg) & ANTIFLIN_C2_RESERVED4_MASK) >> ANTIFLIN_C2_RESERVED4_SHIFT)
#define  ANTIFLIN_C2_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_C2_RESERVED4_MASK) | (((uint32_t)val) << ANTIFLIN_C2_RESERVED4_SHIFT))

#define  ANTIFLIN_C2_SUBSAMPLEX_MASK 0x700
#define  ANTIFLIN_C2_SUBSAMPLEX_SHIFT 8
#define  ANTIFLIN_C2_SUBSAMPLEX_MASK_SHIFT(reg) (((reg) & ANTIFLIN_C2_SUBSAMPLEX_MASK) >> ANTIFLIN_C2_SUBSAMPLEX_SHIFT)
#define  ANTIFLIN_C2_SUBSAMPLEX_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_C2_SUBSAMPLEX_MASK) | (((uint32_t)val) << ANTIFLIN_C2_SUBSAMPLEX_SHIFT))

#define  ANTIFLIN_C2_IGNOREY_MASK 0xff
#define  ANTIFLIN_C2_IGNOREY_SHIFT 0
#define  ANTIFLIN_C2_IGNOREY_MASK_SHIFT(reg) (((reg) & ANTIFLIN_C2_IGNOREY_MASK) >> ANTIFLIN_C2_IGNOREY_SHIFT)
#define  ANTIFLIN_C2_IGNOREY_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_C2_IGNOREY_MASK) | (((uint32_t)val) << ANTIFLIN_C2_IGNOREY_SHIFT))

//====================================================================
//Register: Channel 3 (C3)
//====================================================================

#define  ANTIFLIN_C3_RESERVED1_MASK 0x80000000
#define  ANTIFLIN_C3_RESERVED1_SHIFT 31
#define  ANTIFLIN_C3_RESERVED1_MASK_SHIFT(reg) (((reg) & ANTIFLIN_C3_RESERVED1_MASK) >> ANTIFLIN_C3_RESERVED1_SHIFT)
#define  ANTIFLIN_C3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_C3_RESERVED1_MASK) | (((uint32_t)val) << ANTIFLIN_C3_RESERVED1_SHIFT))

#define  ANTIFLIN_C3_PASSTHRU_MASK 0x40000000
#define  ANTIFLIN_C3_PASSTHRU_SHIFT 30
#define  ANTIFLIN_C3_PASSTHRU_MASK_SHIFT(reg) (((reg) & ANTIFLIN_C3_PASSTHRU_MASK) >> ANTIFLIN_C3_PASSTHRU_SHIFT)
#define  ANTIFLIN_C3_PASSTHRU_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_C3_PASSTHRU_MASK) | (((uint32_t)val) << ANTIFLIN_C3_PASSTHRU_SHIFT))

#define  ANTIFLIN_C3_RESERVED2_MASK 0x3ff00000
#define  ANTIFLIN_C3_RESERVED2_SHIFT 20
#define  ANTIFLIN_C3_RESERVED2_MASK_SHIFT(reg) (((reg) & ANTIFLIN_C3_RESERVED2_MASK) >> ANTIFLIN_C3_RESERVED2_SHIFT)
#define  ANTIFLIN_C3_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_C3_RESERVED2_MASK) | (((uint32_t)val) << ANTIFLIN_C3_RESERVED2_SHIFT))

#define  ANTIFLIN_C3_FRACTIONSHIFT_MASK 0xf0000
#define  ANTIFLIN_C3_FRACTIONSHIFT_SHIFT 16
#define  ANTIFLIN_C3_FRACTIONSHIFT_MASK_SHIFT(reg) (((reg) & ANTIFLIN_C3_FRACTIONSHIFT_MASK) >> ANTIFLIN_C3_FRACTIONSHIFT_SHIFT)
#define  ANTIFLIN_C3_FRACTIONSHIFT_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_C3_FRACTIONSHIFT_MASK) | (((uint32_t)val) << ANTIFLIN_C3_FRACTIONSHIFT_SHIFT))

#define  ANTIFLIN_C3_RESERVED3_MASK 0x8000
#define  ANTIFLIN_C3_RESERVED3_SHIFT 15
#define  ANTIFLIN_C3_RESERVED3_MASK_SHIFT(reg) (((reg) & ANTIFLIN_C3_RESERVED3_MASK) >> ANTIFLIN_C3_RESERVED3_SHIFT)
#define  ANTIFLIN_C3_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_C3_RESERVED3_MASK) | (((uint32_t)val) << ANTIFLIN_C3_RESERVED3_SHIFT))

#define  ANTIFLIN_C3_SUBSAMPLEY_MASK 0x7000
#define  ANTIFLIN_C3_SUBSAMPLEY_SHIFT 12
#define  ANTIFLIN_C3_SUBSAMPLEY_MASK_SHIFT(reg) (((reg) & ANTIFLIN_C3_SUBSAMPLEY_MASK) >> ANTIFLIN_C3_SUBSAMPLEY_SHIFT)
#define  ANTIFLIN_C3_SUBSAMPLEY_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_C3_SUBSAMPLEY_MASK) | (((uint32_t)val) << ANTIFLIN_C3_SUBSAMPLEY_SHIFT))

#define  ANTIFLIN_C3_RESERVED4_MASK 0x800
#define  ANTIFLIN_C3_RESERVED4_SHIFT 11
#define  ANTIFLIN_C3_RESERVED4_MASK_SHIFT(reg) (((reg) & ANTIFLIN_C3_RESERVED4_MASK) >> ANTIFLIN_C3_RESERVED4_SHIFT)
#define  ANTIFLIN_C3_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_C3_RESERVED4_MASK) | (((uint32_t)val) << ANTIFLIN_C3_RESERVED4_SHIFT))

#define  ANTIFLIN_C3_SUBSAMPLEX_MASK 0x700
#define  ANTIFLIN_C3_SUBSAMPLEX_SHIFT 8
#define  ANTIFLIN_C3_SUBSAMPLEX_MASK_SHIFT(reg) (((reg) & ANTIFLIN_C3_SUBSAMPLEX_MASK) >> ANTIFLIN_C3_SUBSAMPLEX_SHIFT)
#define  ANTIFLIN_C3_SUBSAMPLEX_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_C3_SUBSAMPLEX_MASK) | (((uint32_t)val) << ANTIFLIN_C3_SUBSAMPLEX_SHIFT))

#define  ANTIFLIN_C3_IGNOREY_MASK 0xff
#define  ANTIFLIN_C3_IGNOREY_SHIFT 0
#define  ANTIFLIN_C3_IGNOREY_MASK_SHIFT(reg) (((reg) & ANTIFLIN_C3_IGNOREY_MASK) >> ANTIFLIN_C3_IGNOREY_SHIFT)
#define  ANTIFLIN_C3_IGNOREY_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_C3_IGNOREY_MASK) | (((uint32_t)val) << ANTIFLIN_C3_IGNOREY_SHIFT))

//====================================================================
//Register: RAM Access Control Register (RAR)
//====================================================================

#define  ANTIFLIN_RAR_RESERVED1_MASK 0xfffffff0
#define  ANTIFLIN_RAR_RESERVED1_SHIFT 4
#define  ANTIFLIN_RAR_RESERVED1_MASK_SHIFT(reg) (((reg) & ANTIFLIN_RAR_RESERVED1_MASK) >> ANTIFLIN_RAR_RESERVED1_SHIFT)
#define  ANTIFLIN_RAR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_RAR_RESERVED1_MASK) | (((uint32_t)val) << ANTIFLIN_RAR_RESERVED1_SHIFT))

#define  ANTIFLIN_RAR_RAM_SELECT_MASK 0xc
#define  ANTIFLIN_RAR_RAM_SELECT_SHIFT 2
#define  ANTIFLIN_RAR_RAM_SELECT_MASK_SHIFT(reg) (((reg) & ANTIFLIN_RAR_RAM_SELECT_MASK) >> ANTIFLIN_RAR_RAM_SELECT_SHIFT)
#define  ANTIFLIN_RAR_RAM_SELECT_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_RAR_RAM_SELECT_MASK) | (((uint32_t)val) << ANTIFLIN_RAR_RAM_SELECT_SHIFT))

#define  ANTIFLIN_RAR_INC_ADDR_MODE_MASK 0x2
#define  ANTIFLIN_RAR_INC_ADDR_MODE_SHIFT 1
#define  ANTIFLIN_RAR_INC_ADDR_MODE_MASK_SHIFT(reg) (((reg) & ANTIFLIN_RAR_INC_ADDR_MODE_MASK) >> ANTIFLIN_RAR_INC_ADDR_MODE_SHIFT)
#define  ANTIFLIN_RAR_INC_ADDR_MODE_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_RAR_INC_ADDR_MODE_MASK) | (((uint32_t)val) << ANTIFLIN_RAR_INC_ADDR_MODE_SHIFT))

#define  ANTIFLIN_RAR_LB_RNW_MASK 0x1
#define  ANTIFLIN_RAR_LB_RNW_SHIFT 0
#define  ANTIFLIN_RAR_LB_RNW_MASK_SHIFT(reg) (((reg) & ANTIFLIN_RAR_LB_RNW_MASK) >> ANTIFLIN_RAR_LB_RNW_SHIFT)
#define  ANTIFLIN_RAR_LB_RNW_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_RAR_LB_RNW_MASK) | (((uint32_t)val) << ANTIFLIN_RAR_LB_RNW_SHIFT))

//====================================================================
//Register: RAM Address Write Register (RAWR)
//====================================================================

#define  ANTIFLIN_RAWR_RESERVED1_MASK 0xfffffc00
#define  ANTIFLIN_RAWR_RESERVED1_SHIFT 10
#define  ANTIFLIN_RAWR_RESERVED1_MASK_SHIFT(reg) (((reg) & ANTIFLIN_RAWR_RESERVED1_MASK) >> ANTIFLIN_RAWR_RESERVED1_SHIFT)
#define  ANTIFLIN_RAWR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_RAWR_RESERVED1_MASK) | (((uint32_t)val) << ANTIFLIN_RAWR_RESERVED1_SHIFT))

#define  ANTIFLIN_RAWR_ADDRESS_MASK 0x3ff
#define  ANTIFLIN_RAWR_ADDRESS_SHIFT 0
#define  ANTIFLIN_RAWR_ADDRESS_MASK_SHIFT(reg) (((reg) & ANTIFLIN_RAWR_ADDRESS_MASK) >> ANTIFLIN_RAWR_ADDRESS_SHIFT)
#define  ANTIFLIN_RAWR_ADDRESS_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_RAWR_ADDRESS_MASK) | (((uint32_t)val) << ANTIFLIN_RAWR_ADDRESS_SHIFT))

//====================================================================
//Register: RAM Address Status Register (RASR)
//====================================================================

#define  ANTIFLIN_RASR_RESERVED1_MASK 0xfffffc00
#define  ANTIFLIN_RASR_RESERVED1_SHIFT 10
#define  ANTIFLIN_RASR_RESERVED1_MASK_SHIFT(reg) (((reg) & ANTIFLIN_RASR_RESERVED1_MASK) >> ANTIFLIN_RASR_RESERVED1_SHIFT)
#define  ANTIFLIN_RASR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_RASR_RESERVED1_MASK) | (((uint32_t)val) << ANTIFLIN_RASR_RESERVED1_SHIFT))

#define  ANTIFLIN_RASR_ADDRESS_MASK 0x3ff
#define  ANTIFLIN_RASR_ADDRESS_SHIFT 0
#define  ANTIFLIN_RASR_ADDRESS_MASK_SHIFT(reg) (((reg) & ANTIFLIN_RASR_ADDRESS_MASK) >> ANTIFLIN_RASR_ADDRESS_SHIFT)
#define  ANTIFLIN_RASR_ADDRESS_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_RASR_ADDRESS_MASK) | (((uint32_t)val) << ANTIFLIN_RASR_ADDRESS_SHIFT))

//====================================================================
//Register: RAM Data Write Register (RDWR)
/** \brief This register writes the RAM.*/
//====================================================================

#define  ANTIFLIN_RDWR_RESERVED1_MASK 0xff000000
#define  ANTIFLIN_RDWR_RESERVED1_SHIFT 24
#define  ANTIFLIN_RDWR_RESERVED1_MASK_SHIFT(reg) (((reg) & ANTIFLIN_RDWR_RESERVED1_MASK) >> ANTIFLIN_RDWR_RESERVED1_SHIFT)
#define  ANTIFLIN_RDWR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_RDWR_RESERVED1_MASK) | (((uint32_t)val) << ANTIFLIN_RDWR_RESERVED1_SHIFT))

#define  ANTIFLIN_RDWR_DATA_MASK 0xffffff
#define  ANTIFLIN_RDWR_DATA_SHIFT 0
#define  ANTIFLIN_RDWR_DATA_MASK_SHIFT(reg) (((reg) & ANTIFLIN_RDWR_DATA_MASK) >> ANTIFLIN_RDWR_DATA_SHIFT)
#define  ANTIFLIN_RDWR_DATA_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_RDWR_DATA_MASK) | (((uint32_t)val) << ANTIFLIN_RDWR_DATA_SHIFT))

//====================================================================
//Register: RAM Data Read Register (RDRR)
/** \brief This register reads the SRAM.*/
//====================================================================

#define  ANTIFLIN_RDRR_RESERVED1_MASK 0xff000000
#define  ANTIFLIN_RDRR_RESERVED1_SHIFT 24
#define  ANTIFLIN_RDRR_RESERVED1_MASK_SHIFT(reg) (((reg) & ANTIFLIN_RDRR_RESERVED1_MASK) >> ANTIFLIN_RDRR_RESERVED1_SHIFT)
#define  ANTIFLIN_RDRR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_RDRR_RESERVED1_MASK) | (((uint32_t)val) << ANTIFLIN_RDRR_RESERVED1_SHIFT))

#define  ANTIFLIN_RDRR_DATA_MASK 0xffffff
#define  ANTIFLIN_RDRR_DATA_SHIFT 0
#define  ANTIFLIN_RDRR_DATA_MASK_SHIFT(reg) (((reg) & ANTIFLIN_RDRR_DATA_MASK) >> ANTIFLIN_RDRR_DATA_SHIFT)
#define  ANTIFLIN_RDRR_DATA_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_RDRR_DATA_MASK) | (((uint32_t)val) << ANTIFLIN_RDRR_DATA_SHIFT))

//====================================================================
//Register: ANTIFLIN channel 0 Debug Register (debug_ch0)
/** \brief Debug information for ANTIFLIN*/
//====================================================================

#define  ANTIFLIN_DEBUG_CH0_DATA_MASK 0xffffffff
#define  ANTIFLIN_DEBUG_CH0_DATA_SHIFT 0
#define  ANTIFLIN_DEBUG_CH0_DATA_MASK_SHIFT(reg) (((reg) & ANTIFLIN_DEBUG_CH0_DATA_MASK) >> ANTIFLIN_DEBUG_CH0_DATA_SHIFT)
#define  ANTIFLIN_DEBUG_CH0_DATA_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_DEBUG_CH0_DATA_MASK) | (((uint32_t)val) << ANTIFLIN_DEBUG_CH0_DATA_SHIFT))

//====================================================================
//Register: ANTIFLIN channel 1 Debug Register (debug_ch1)
/** \brief Debug information for ANTIFLIN*/
//====================================================================

#define  ANTIFLIN_DEBUG_CH1_DATA_MASK 0xffffffff
#define  ANTIFLIN_DEBUG_CH1_DATA_SHIFT 0
#define  ANTIFLIN_DEBUG_CH1_DATA_MASK_SHIFT(reg) (((reg) & ANTIFLIN_DEBUG_CH1_DATA_MASK) >> ANTIFLIN_DEBUG_CH1_DATA_SHIFT)
#define  ANTIFLIN_DEBUG_CH1_DATA_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_DEBUG_CH1_DATA_MASK) | (((uint32_t)val) << ANTIFLIN_DEBUG_CH1_DATA_SHIFT))

//====================================================================
//Register: ANTIFLIN channel 2 Debug Register (debug_ch2)
/** \brief Debug information for ANTIFLIN*/
//====================================================================

#define  ANTIFLIN_DEBUG_CH2_DATA_MASK 0xffffffff
#define  ANTIFLIN_DEBUG_CH2_DATA_SHIFT 0
#define  ANTIFLIN_DEBUG_CH2_DATA_MASK_SHIFT(reg) (((reg) & ANTIFLIN_DEBUG_CH2_DATA_MASK) >> ANTIFLIN_DEBUG_CH2_DATA_SHIFT)
#define  ANTIFLIN_DEBUG_CH2_DATA_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_DEBUG_CH2_DATA_MASK) | (((uint32_t)val) << ANTIFLIN_DEBUG_CH2_DATA_SHIFT))

//====================================================================
//Register: IP Tagging Revision 0 (REV0)
/** \brief Provide means for firmware to read IP tagging information.
      This register of particular interest to firmware.*/
//====================================================================

#define  ANTIFLIN_REV0_MAJ_MASK 0xffff0000
#define  ANTIFLIN_REV0_MAJ_SHIFT 16
#define  ANTIFLIN_REV0_MAJ_MASK_SHIFT(reg) (((reg) & ANTIFLIN_REV0_MAJ_MASK) >> ANTIFLIN_REV0_MAJ_SHIFT)
#define  ANTIFLIN_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_REV0_MAJ_MASK) | (((uint32_t)val) << ANTIFLIN_REV0_MAJ_SHIFT))

#define  ANTIFLIN_REV0_MID_MASK 0xffff
#define  ANTIFLIN_REV0_MID_SHIFT 0
#define  ANTIFLIN_REV0_MID_MASK_SHIFT(reg) (((reg) & ANTIFLIN_REV0_MID_MASK) >> ANTIFLIN_REV0_MID_SHIFT)
#define  ANTIFLIN_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_REV0_MID_MASK) | (((uint32_t)val) << ANTIFLIN_REV0_MID_SHIFT))

//====================================================================
//Register: IP Tagging Revision 1 (REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  ANTIFLIN_REV1_RESERVED1_MASK 0xffff0000
#define  ANTIFLIN_REV1_RESERVED1_SHIFT 16
#define  ANTIFLIN_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & ANTIFLIN_REV1_RESERVED1_MASK) >> ANTIFLIN_REV1_RESERVED1_SHIFT)
#define  ANTIFLIN_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_REV1_RESERVED1_MASK) | (((uint32_t)val) << ANTIFLIN_REV1_RESERVED1_SHIFT))

#define  ANTIFLIN_REV1_CFG_MASK 0xffff
#define  ANTIFLIN_REV1_CFG_SHIFT 0
#define  ANTIFLIN_REV1_CFG_MASK_SHIFT(reg) (((reg) & ANTIFLIN_REV1_CFG_MASK) >> ANTIFLIN_REV1_CFG_SHIFT)
#define  ANTIFLIN_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_REV1_CFG_MASK) | (((uint32_t)val) << ANTIFLIN_REV1_CFG_SHIFT))

//====================================================================
//
//Register File: AntiFlin ODMA Channel (Instance 1 of 3) (ANTIFLIN_WDMA0)
/** \brief Register Descriptions for the ODMA_AXI block (rev 0 . 4 . 3 . 1)*/
//
//====================================================================

//====================================================================
//Register: Configuration register (cfg)
//====================================================================

#define  ANTIFLIN_WDMA0_CFG_RESERVED1_MASK 0xfe000000
#define  ANTIFLIN_WDMA0_CFG_RESERVED1_SHIFT 25
#define  ANTIFLIN_WDMA0_CFG_RESERVED1_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA0_CFG_RESERVED1_MASK) >> ANTIFLIN_WDMA0_CFG_RESERVED1_SHIFT)
#define  ANTIFLIN_WDMA0_CFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA0_CFG_RESERVED1_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA0_CFG_RESERVED1_SHIFT))

#define  ANTIFLIN_WDMA0_CFG_HANDSHAKEENABLE_MASK 0x1000000
#define  ANTIFLIN_WDMA0_CFG_HANDSHAKEENABLE_SHIFT 24
#define  ANTIFLIN_WDMA0_CFG_HANDSHAKEENABLE_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA0_CFG_HANDSHAKEENABLE_MASK) >> ANTIFLIN_WDMA0_CFG_HANDSHAKEENABLE_SHIFT)
#define  ANTIFLIN_WDMA0_CFG_HANDSHAKEENABLE_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA0_CFG_HANDSHAKEENABLE_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA0_CFG_HANDSHAKEENABLE_SHIFT))

#define  ANTIFLIN_WDMA0_CFG_OWNPOLARITY_MASK 0x800000
#define  ANTIFLIN_WDMA0_CFG_OWNPOLARITY_SHIFT 23
#define  ANTIFLIN_WDMA0_CFG_OWNPOLARITY_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA0_CFG_OWNPOLARITY_MASK) >> ANTIFLIN_WDMA0_CFG_OWNPOLARITY_SHIFT)
#define  ANTIFLIN_WDMA0_CFG_OWNPOLARITY_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA0_CFG_OWNPOLARITY_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA0_CFG_OWNPOLARITY_SHIFT))

#define  ANTIFLIN_WDMA0_CFG_OWNWRITEDISABLE_MASK 0x400000
#define  ANTIFLIN_WDMA0_CFG_OWNWRITEDISABLE_SHIFT 22
#define  ANTIFLIN_WDMA0_CFG_OWNWRITEDISABLE_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA0_CFG_OWNWRITEDISABLE_MASK) >> ANTIFLIN_WDMA0_CFG_OWNWRITEDISABLE_SHIFT)
#define  ANTIFLIN_WDMA0_CFG_OWNWRITEDISABLE_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA0_CFG_OWNWRITEDISABLE_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA0_CFG_OWNWRITEDISABLE_SHIFT))

#define  ANTIFLIN_WDMA0_CFG_SERPENTINE_MASK 0x200000
#define  ANTIFLIN_WDMA0_CFG_SERPENTINE_SHIFT 21
#define  ANTIFLIN_WDMA0_CFG_SERPENTINE_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA0_CFG_SERPENTINE_MASK) >> ANTIFLIN_WDMA0_CFG_SERPENTINE_SHIFT)
#define  ANTIFLIN_WDMA0_CFG_SERPENTINE_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA0_CFG_SERPENTINE_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA0_CFG_SERPENTINE_SHIFT))

#define  ANTIFLIN_WDMA0_CFG_LINE_REV_MASK 0x100000
#define  ANTIFLIN_WDMA0_CFG_LINE_REV_SHIFT 20
#define  ANTIFLIN_WDMA0_CFG_LINE_REV_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA0_CFG_LINE_REV_MASK) >> ANTIFLIN_WDMA0_CFG_LINE_REV_SHIFT)
#define  ANTIFLIN_WDMA0_CFG_LINE_REV_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA0_CFG_LINE_REV_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA0_CFG_LINE_REV_SHIFT))

#define  ANTIFLIN_WDMA0_CFG_TRAN_REV_MASK 0x80000
#define  ANTIFLIN_WDMA0_CFG_TRAN_REV_SHIFT 19
#define  ANTIFLIN_WDMA0_CFG_TRAN_REV_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA0_CFG_TRAN_REV_MASK) >> ANTIFLIN_WDMA0_CFG_TRAN_REV_SHIFT)
#define  ANTIFLIN_WDMA0_CFG_TRAN_REV_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA0_CFG_TRAN_REV_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA0_CFG_TRAN_REV_SHIFT))

#define  ANTIFLIN_WDMA0_CFG_UPPER_HALF_MASK 0x40000
#define  ANTIFLIN_WDMA0_CFG_UPPER_HALF_SHIFT 18
#define  ANTIFLIN_WDMA0_CFG_UPPER_HALF_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA0_CFG_UPPER_HALF_MASK) >> ANTIFLIN_WDMA0_CFG_UPPER_HALF_SHIFT)
#define  ANTIFLIN_WDMA0_CFG_UPPER_HALF_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA0_CFG_UPPER_HALF_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA0_CFG_UPPER_HALF_SHIFT))

#define  ANTIFLIN_WDMA0_CFG_MSB_IN_MASK 0x20000
#define  ANTIFLIN_WDMA0_CFG_MSB_IN_SHIFT 17
#define  ANTIFLIN_WDMA0_CFG_MSB_IN_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA0_CFG_MSB_IN_MASK) >> ANTIFLIN_WDMA0_CFG_MSB_IN_SHIFT)
#define  ANTIFLIN_WDMA0_CFG_MSB_IN_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA0_CFG_MSB_IN_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA0_CFG_MSB_IN_SHIFT))

#define  ANTIFLIN_WDMA0_CFG_ENABLE_MASK 0x10000
#define  ANTIFLIN_WDMA0_CFG_ENABLE_SHIFT 16
#define  ANTIFLIN_WDMA0_CFG_ENABLE_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA0_CFG_ENABLE_MASK) >> ANTIFLIN_WDMA0_CFG_ENABLE_SHIFT)
#define  ANTIFLIN_WDMA0_CFG_ENABLE_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA0_CFG_ENABLE_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA0_CFG_ENABLE_SHIFT))

#define  ANTIFLIN_WDMA0_CFG_RESERVED2_MASK 0xf800
#define  ANTIFLIN_WDMA0_CFG_RESERVED2_SHIFT 11
#define  ANTIFLIN_WDMA0_CFG_RESERVED2_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA0_CFG_RESERVED2_MASK) >> ANTIFLIN_WDMA0_CFG_RESERVED2_SHIFT)
#define  ANTIFLIN_WDMA0_CFG_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA0_CFG_RESERVED2_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA0_CFG_RESERVED2_SHIFT))

#define  ANTIFLIN_WDMA0_CFG_IN_WIDTH_MASK 0x700
#define  ANTIFLIN_WDMA0_CFG_IN_WIDTH_SHIFT 8
#define  ANTIFLIN_WDMA0_CFG_IN_WIDTH_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA0_CFG_IN_WIDTH_MASK) >> ANTIFLIN_WDMA0_CFG_IN_WIDTH_SHIFT)
#define  ANTIFLIN_WDMA0_CFG_IN_WIDTH_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA0_CFG_IN_WIDTH_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA0_CFG_IN_WIDTH_SHIFT))

#define  ANTIFLIN_WDMA0_CFG_RESERVED3_MASK 0xfc
#define  ANTIFLIN_WDMA0_CFG_RESERVED3_SHIFT 2
#define  ANTIFLIN_WDMA0_CFG_RESERVED3_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA0_CFG_RESERVED3_MASK) >> ANTIFLIN_WDMA0_CFG_RESERVED3_SHIFT)
#define  ANTIFLIN_WDMA0_CFG_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA0_CFG_RESERVED3_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA0_CFG_RESERVED3_SHIFT))

#define  ANTIFLIN_WDMA0_CFG_BURST_LEN_MASK 0x3
#define  ANTIFLIN_WDMA0_CFG_BURST_LEN_SHIFT 0
#define  ANTIFLIN_WDMA0_CFG_BURST_LEN_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA0_CFG_BURST_LEN_MASK) >> ANTIFLIN_WDMA0_CFG_BURST_LEN_SHIFT)
#define  ANTIFLIN_WDMA0_CFG_BURST_LEN_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA0_CFG_BURST_LEN_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA0_CFG_BURST_LEN_SHIFT))

//====================================================================
//Register: Status register (status)
//====================================================================

#define  ANTIFLIN_WDMA0_STATUS_RESERVED1_MASK 0xff000000
#define  ANTIFLIN_WDMA0_STATUS_RESERVED1_SHIFT 24
#define  ANTIFLIN_WDMA0_STATUS_RESERVED1_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA0_STATUS_RESERVED1_MASK) >> ANTIFLIN_WDMA0_STATUS_RESERVED1_SHIFT)
#define  ANTIFLIN_WDMA0_STATUS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA0_STATUS_RESERVED1_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA0_STATUS_RESERVED1_SHIFT))

#define  ANTIFLIN_WDMA0_STATUS_BYTESWAITING_MASK 0xff0000
#define  ANTIFLIN_WDMA0_STATUS_BYTESWAITING_SHIFT 16
#define  ANTIFLIN_WDMA0_STATUS_BYTESWAITING_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA0_STATUS_BYTESWAITING_MASK) >> ANTIFLIN_WDMA0_STATUS_BYTESWAITING_SHIFT)
#define  ANTIFLIN_WDMA0_STATUS_BYTESWAITING_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA0_STATUS_BYTESWAITING_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA0_STATUS_BYTESWAITING_SHIFT))

#define  ANTIFLIN_WDMA0_STATUS_RESERVED2_MASK 0x8000
#define  ANTIFLIN_WDMA0_STATUS_RESERVED2_SHIFT 15
#define  ANTIFLIN_WDMA0_STATUS_RESERVED2_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA0_STATUS_RESERVED2_MASK) >> ANTIFLIN_WDMA0_STATUS_RESERVED2_SHIFT)
#define  ANTIFLIN_WDMA0_STATUS_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA0_STATUS_RESERVED2_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA0_STATUS_RESERVED2_SHIFT))

#define  ANTIFLIN_WDMA0_STATUS_FORCE_BURST_BUSY_MASK 0x4000
#define  ANTIFLIN_WDMA0_STATUS_FORCE_BURST_BUSY_SHIFT 14
#define  ANTIFLIN_WDMA0_STATUS_FORCE_BURST_BUSY_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA0_STATUS_FORCE_BURST_BUSY_MASK) >> ANTIFLIN_WDMA0_STATUS_FORCE_BURST_BUSY_SHIFT)
#define  ANTIFLIN_WDMA0_STATUS_FORCE_BURST_BUSY_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA0_STATUS_FORCE_BURST_BUSY_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA0_STATUS_FORCE_BURST_BUSY_SHIFT))

#define  ANTIFLIN_WDMA0_STATUS_DMAPAUSED_MASK 0x2000
#define  ANTIFLIN_WDMA0_STATUS_DMAPAUSED_SHIFT 13
#define  ANTIFLIN_WDMA0_STATUS_DMAPAUSED_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA0_STATUS_DMAPAUSED_MASK) >> ANTIFLIN_WDMA0_STATUS_DMAPAUSED_SHIFT)
#define  ANTIFLIN_WDMA0_STATUS_DMAPAUSED_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA0_STATUS_DMAPAUSED_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA0_STATUS_DMAPAUSED_SHIFT))

#define  ANTIFLIN_WDMA0_STATUS_PAUSEAFTER_MASK 0x1000
#define  ANTIFLIN_WDMA0_STATUS_PAUSEAFTER_SHIFT 12
#define  ANTIFLIN_WDMA0_STATUS_PAUSEAFTER_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA0_STATUS_PAUSEAFTER_MASK) >> ANTIFLIN_WDMA0_STATUS_PAUSEAFTER_SHIFT)
#define  ANTIFLIN_WDMA0_STATUS_PAUSEAFTER_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA0_STATUS_PAUSEAFTER_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA0_STATUS_PAUSEAFTER_SHIFT))

#define  ANTIFLIN_WDMA0_STATUS_PAUSEBEFORE_MASK 0x800
#define  ANTIFLIN_WDMA0_STATUS_PAUSEBEFORE_SHIFT 11
#define  ANTIFLIN_WDMA0_STATUS_PAUSEBEFORE_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA0_STATUS_PAUSEBEFORE_MASK) >> ANTIFLIN_WDMA0_STATUS_PAUSEBEFORE_SHIFT)
#define  ANTIFLIN_WDMA0_STATUS_PAUSEBEFORE_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA0_STATUS_PAUSEBEFORE_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA0_STATUS_PAUSEBEFORE_SHIFT))

#define  ANTIFLIN_WDMA0_STATUS_DESC_OWN_MASK 0x400
#define  ANTIFLIN_WDMA0_STATUS_DESC_OWN_SHIFT 10
#define  ANTIFLIN_WDMA0_STATUS_DESC_OWN_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA0_STATUS_DESC_OWN_MASK) >> ANTIFLIN_WDMA0_STATUS_DESC_OWN_SHIFT)
#define  ANTIFLIN_WDMA0_STATUS_DESC_OWN_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA0_STATUS_DESC_OWN_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA0_STATUS_DESC_OWN_SHIFT))

#define  ANTIFLIN_WDMA0_STATUS_DESC_EOI_MASK 0x200
#define  ANTIFLIN_WDMA0_STATUS_DESC_EOI_SHIFT 9
#define  ANTIFLIN_WDMA0_STATUS_DESC_EOI_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA0_STATUS_DESC_EOI_MASK) >> ANTIFLIN_WDMA0_STATUS_DESC_EOI_SHIFT)
#define  ANTIFLIN_WDMA0_STATUS_DESC_EOI_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA0_STATUS_DESC_EOI_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA0_STATUS_DESC_EOI_SHIFT))

#define  ANTIFLIN_WDMA0_STATUS_DESC_SOI_MASK 0x100
#define  ANTIFLIN_WDMA0_STATUS_DESC_SOI_SHIFT 8
#define  ANTIFLIN_WDMA0_STATUS_DESC_SOI_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA0_STATUS_DESC_SOI_MASK) >> ANTIFLIN_WDMA0_STATUS_DESC_SOI_SHIFT)
#define  ANTIFLIN_WDMA0_STATUS_DESC_SOI_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA0_STATUS_DESC_SOI_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA0_STATUS_DESC_SOI_SHIFT))

#define  ANTIFLIN_WDMA0_STATUS_REVERSE_MASK 0x80
#define  ANTIFLIN_WDMA0_STATUS_REVERSE_SHIFT 7
#define  ANTIFLIN_WDMA0_STATUS_REVERSE_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA0_STATUS_REVERSE_MASK) >> ANTIFLIN_WDMA0_STATUS_REVERSE_SHIFT)
#define  ANTIFLIN_WDMA0_STATUS_REVERSE_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA0_STATUS_REVERSE_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA0_STATUS_REVERSE_SHIFT))

#define  ANTIFLIN_WDMA0_STATUS_SOFTRESET_MASK 0x40
#define  ANTIFLIN_WDMA0_STATUS_SOFTRESET_SHIFT 6
#define  ANTIFLIN_WDMA0_STATUS_SOFTRESET_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA0_STATUS_SOFTRESET_MASK) >> ANTIFLIN_WDMA0_STATUS_SOFTRESET_SHIFT)
#define  ANTIFLIN_WDMA0_STATUS_SOFTRESET_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA0_STATUS_SOFTRESET_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA0_STATUS_SOFTRESET_SHIFT))

#define  ANTIFLIN_WDMA0_STATUS_FULL_CBUF_MASK 0x20
#define  ANTIFLIN_WDMA0_STATUS_FULL_CBUF_SHIFT 5
#define  ANTIFLIN_WDMA0_STATUS_FULL_CBUF_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA0_STATUS_FULL_CBUF_MASK) >> ANTIFLIN_WDMA0_STATUS_FULL_CBUF_SHIFT)
#define  ANTIFLIN_WDMA0_STATUS_FULL_CBUF_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA0_STATUS_FULL_CBUF_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA0_STATUS_FULL_CBUF_SHIFT))

#define  ANTIFLIN_WDMA0_STATUS_EMPTY_CBUF_MASK 0x10
#define  ANTIFLIN_WDMA0_STATUS_EMPTY_CBUF_SHIFT 4
#define  ANTIFLIN_WDMA0_STATUS_EMPTY_CBUF_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA0_STATUS_EMPTY_CBUF_MASK) >> ANTIFLIN_WDMA0_STATUS_EMPTY_CBUF_SHIFT)
#define  ANTIFLIN_WDMA0_STATUS_EMPTY_CBUF_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA0_STATUS_EMPTY_CBUF_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA0_STATUS_EMPTY_CBUF_SHIFT))

#define  ANTIFLIN_WDMA0_STATUS_FULL_DBUF_MASK 0x8
#define  ANTIFLIN_WDMA0_STATUS_FULL_DBUF_SHIFT 3
#define  ANTIFLIN_WDMA0_STATUS_FULL_DBUF_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA0_STATUS_FULL_DBUF_MASK) >> ANTIFLIN_WDMA0_STATUS_FULL_DBUF_SHIFT)
#define  ANTIFLIN_WDMA0_STATUS_FULL_DBUF_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA0_STATUS_FULL_DBUF_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA0_STATUS_FULL_DBUF_SHIFT))

#define  ANTIFLIN_WDMA0_STATUS_EMPTY_DBUF_MASK 0x4
#define  ANTIFLIN_WDMA0_STATUS_EMPTY_DBUF_SHIFT 2
#define  ANTIFLIN_WDMA0_STATUS_EMPTY_DBUF_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA0_STATUS_EMPTY_DBUF_MASK) >> ANTIFLIN_WDMA0_STATUS_EMPTY_DBUF_SHIFT)
#define  ANTIFLIN_WDMA0_STATUS_EMPTY_DBUF_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA0_STATUS_EMPTY_DBUF_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA0_STATUS_EMPTY_DBUF_SHIFT))

#define  ANTIFLIN_WDMA0_STATUS_PACKER_EMPTY_MASK 0x2
#define  ANTIFLIN_WDMA0_STATUS_PACKER_EMPTY_SHIFT 1
#define  ANTIFLIN_WDMA0_STATUS_PACKER_EMPTY_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA0_STATUS_PACKER_EMPTY_MASK) >> ANTIFLIN_WDMA0_STATUS_PACKER_EMPTY_SHIFT)
#define  ANTIFLIN_WDMA0_STATUS_PACKER_EMPTY_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA0_STATUS_PACKER_EMPTY_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA0_STATUS_PACKER_EMPTY_SHIFT))

#define  ANTIFLIN_WDMA0_STATUS_DMA_BUSY_MASK 0x1
#define  ANTIFLIN_WDMA0_STATUS_DMA_BUSY_SHIFT 0
#define  ANTIFLIN_WDMA0_STATUS_DMA_BUSY_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA0_STATUS_DMA_BUSY_MASK) >> ANTIFLIN_WDMA0_STATUS_DMA_BUSY_SHIFT)
#define  ANTIFLIN_WDMA0_STATUS_DMA_BUSY_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA0_STATUS_DMA_BUSY_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA0_STATUS_DMA_BUSY_SHIFT))

//====================================================================
//Register: Line Size Register (line_size)
//====================================================================

#define  ANTIFLIN_WDMA0_LINE_SIZE_RESERVED1_MASK 0xfffc0000
#define  ANTIFLIN_WDMA0_LINE_SIZE_RESERVED1_SHIFT 18
#define  ANTIFLIN_WDMA0_LINE_SIZE_RESERVED1_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA0_LINE_SIZE_RESERVED1_MASK) >> ANTIFLIN_WDMA0_LINE_SIZE_RESERVED1_SHIFT)
#define  ANTIFLIN_WDMA0_LINE_SIZE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA0_LINE_SIZE_RESERVED1_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA0_LINE_SIZE_RESERVED1_SHIFT))

#define  ANTIFLIN_WDMA0_LINE_SIZE_LINE_SIZE_MASK 0x3ffff
#define  ANTIFLIN_WDMA0_LINE_SIZE_LINE_SIZE_SHIFT 0
#define  ANTIFLIN_WDMA0_LINE_SIZE_LINE_SIZE_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA0_LINE_SIZE_LINE_SIZE_MASK) >> ANTIFLIN_WDMA0_LINE_SIZE_LINE_SIZE_SHIFT)
#define  ANTIFLIN_WDMA0_LINE_SIZE_LINE_SIZE_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA0_LINE_SIZE_LINE_SIZE_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA0_LINE_SIZE_LINE_SIZE_SHIFT))

//====================================================================
//Register: Interrupt Enable Register (int_en)
//====================================================================

#define  ANTIFLIN_WDMA0_INT_EN_RESERVED1_MASK 0xfffff800
#define  ANTIFLIN_WDMA0_INT_EN_RESERVED1_SHIFT 11
#define  ANTIFLIN_WDMA0_INT_EN_RESERVED1_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA0_INT_EN_RESERVED1_MASK) >> ANTIFLIN_WDMA0_INT_EN_RESERVED1_SHIFT)
#define  ANTIFLIN_WDMA0_INT_EN_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA0_INT_EN_RESERVED1_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA0_INT_EN_RESERVED1_SHIFT))

#define  ANTIFLIN_WDMA0_INT_EN_RRESP_INT_EN_MASK 0x400
#define  ANTIFLIN_WDMA0_INT_EN_RRESP_INT_EN_SHIFT 10
#define  ANTIFLIN_WDMA0_INT_EN_RRESP_INT_EN_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA0_INT_EN_RRESP_INT_EN_MASK) >> ANTIFLIN_WDMA0_INT_EN_RRESP_INT_EN_SHIFT)
#define  ANTIFLIN_WDMA0_INT_EN_RRESP_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA0_INT_EN_RRESP_INT_EN_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA0_INT_EN_RRESP_INT_EN_SHIFT))

#define  ANTIFLIN_WDMA0_INT_EN_BRESP_INT_EN_MASK 0x200
#define  ANTIFLIN_WDMA0_INT_EN_BRESP_INT_EN_SHIFT 9
#define  ANTIFLIN_WDMA0_INT_EN_BRESP_INT_EN_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA0_INT_EN_BRESP_INT_EN_MASK) >> ANTIFLIN_WDMA0_INT_EN_BRESP_INT_EN_SHIFT)
#define  ANTIFLIN_WDMA0_INT_EN_BRESP_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA0_INT_EN_BRESP_INT_EN_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA0_INT_EN_BRESP_INT_EN_SHIFT))

#define  ANTIFLIN_WDMA0_INT_EN_RST_INT_EN_MASK 0x100
#define  ANTIFLIN_WDMA0_INT_EN_RST_INT_EN_SHIFT 8
#define  ANTIFLIN_WDMA0_INT_EN_RST_INT_EN_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA0_INT_EN_RST_INT_EN_MASK) >> ANTIFLIN_WDMA0_INT_EN_RST_INT_EN_SHIFT)
#define  ANTIFLIN_WDMA0_INT_EN_RST_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA0_INT_EN_RST_INT_EN_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA0_INT_EN_RST_INT_EN_SHIFT))

#define  ANTIFLIN_WDMA0_INT_EN_EOI_INT_EN_MASK 0x80
#define  ANTIFLIN_WDMA0_INT_EN_EOI_INT_EN_SHIFT 7
#define  ANTIFLIN_WDMA0_INT_EN_EOI_INT_EN_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA0_INT_EN_EOI_INT_EN_MASK) >> ANTIFLIN_WDMA0_INT_EN_EOI_INT_EN_SHIFT)
#define  ANTIFLIN_WDMA0_INT_EN_EOI_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA0_INT_EN_EOI_INT_EN_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA0_INT_EN_EOI_INT_EN_SHIFT))

#define  ANTIFLIN_WDMA0_INT_EN_DIR_INT_EN_MASK 0x40
#define  ANTIFLIN_WDMA0_INT_EN_DIR_INT_EN_SHIFT 6
#define  ANTIFLIN_WDMA0_INT_EN_DIR_INT_EN_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA0_INT_EN_DIR_INT_EN_MASK) >> ANTIFLIN_WDMA0_INT_EN_DIR_INT_EN_SHIFT)
#define  ANTIFLIN_WDMA0_INT_EN_DIR_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA0_INT_EN_DIR_INT_EN_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA0_INT_EN_DIR_INT_EN_SHIFT))

#define  ANTIFLIN_WDMA0_INT_EN_CL_ALI_INT_EN_MASK 0x20
#define  ANTIFLIN_WDMA0_INT_EN_CL_ALI_INT_EN_SHIFT 5
#define  ANTIFLIN_WDMA0_INT_EN_CL_ALI_INT_EN_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA0_INT_EN_CL_ALI_INT_EN_MASK) >> ANTIFLIN_WDMA0_INT_EN_CL_ALI_INT_EN_SHIFT)
#define  ANTIFLIN_WDMA0_INT_EN_CL_ALI_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA0_INT_EN_CL_ALI_INT_EN_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA0_INT_EN_CL_ALI_INT_EN_SHIFT))

#define  ANTIFLIN_WDMA0_INT_EN_EOL_ALI_INT_EN_MASK 0x10
#define  ANTIFLIN_WDMA0_INT_EN_EOL_ALI_INT_EN_SHIFT 4
#define  ANTIFLIN_WDMA0_INT_EN_EOL_ALI_INT_EN_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA0_INT_EN_EOL_ALI_INT_EN_MASK) >> ANTIFLIN_WDMA0_INT_EN_EOL_ALI_INT_EN_SHIFT)
#define  ANTIFLIN_WDMA0_INT_EN_EOL_ALI_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA0_INT_EN_EOL_ALI_INT_EN_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA0_INT_EN_EOL_ALI_INT_EN_SHIFT))

#define  ANTIFLIN_WDMA0_INT_EN_EOI_ALI_INT_EN_MASK 0x8
#define  ANTIFLIN_WDMA0_INT_EN_EOI_ALI_INT_EN_SHIFT 3
#define  ANTIFLIN_WDMA0_INT_EN_EOI_ALI_INT_EN_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA0_INT_EN_EOI_ALI_INT_EN_MASK) >> ANTIFLIN_WDMA0_INT_EN_EOI_ALI_INT_EN_SHIFT)
#define  ANTIFLIN_WDMA0_INT_EN_EOI_ALI_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA0_INT_EN_EOI_ALI_INT_EN_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA0_INT_EN_EOI_ALI_INT_EN_SHIFT))

#define  ANTIFLIN_WDMA0_INT_EN_EOI_ERR_INT_EN_MASK 0x4
#define  ANTIFLIN_WDMA0_INT_EN_EOI_ERR_INT_EN_SHIFT 2
#define  ANTIFLIN_WDMA0_INT_EN_EOI_ERR_INT_EN_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA0_INT_EN_EOI_ERR_INT_EN_MASK) >> ANTIFLIN_WDMA0_INT_EN_EOI_ERR_INT_EN_SHIFT)
#define  ANTIFLIN_WDMA0_INT_EN_EOI_ERR_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA0_INT_EN_EOI_ERR_INT_EN_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA0_INT_EN_EOI_ERR_INT_EN_SHIFT))

#define  ANTIFLIN_WDMA0_INT_EN_FIN_INT_EN_MASK 0x2
#define  ANTIFLIN_WDMA0_INT_EN_FIN_INT_EN_SHIFT 1
#define  ANTIFLIN_WDMA0_INT_EN_FIN_INT_EN_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA0_INT_EN_FIN_INT_EN_MASK) >> ANTIFLIN_WDMA0_INT_EN_FIN_INT_EN_SHIFT)
#define  ANTIFLIN_WDMA0_INT_EN_FIN_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA0_INT_EN_FIN_INT_EN_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA0_INT_EN_FIN_INT_EN_SHIFT))

#define  ANTIFLIN_WDMA0_INT_EN_WHO_INT_EN_MASK 0x1
#define  ANTIFLIN_WDMA0_INT_EN_WHO_INT_EN_SHIFT 0
#define  ANTIFLIN_WDMA0_INT_EN_WHO_INT_EN_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA0_INT_EN_WHO_INT_EN_MASK) >> ANTIFLIN_WDMA0_INT_EN_WHO_INT_EN_SHIFT)
#define  ANTIFLIN_WDMA0_INT_EN_WHO_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA0_INT_EN_WHO_INT_EN_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA0_INT_EN_WHO_INT_EN_SHIFT))

//====================================================================
//Register: Interrupt Pending Register (int_pend)
//====================================================================

#define  ANTIFLIN_WDMA0_INT_PEND_RESERVED1_MASK 0xfffff800
#define  ANTIFLIN_WDMA0_INT_PEND_RESERVED1_SHIFT 11
#define  ANTIFLIN_WDMA0_INT_PEND_RESERVED1_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA0_INT_PEND_RESERVED1_MASK) >> ANTIFLIN_WDMA0_INT_PEND_RESERVED1_SHIFT)
#define  ANTIFLIN_WDMA0_INT_PEND_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA0_INT_PEND_RESERVED1_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA0_INT_PEND_RESERVED1_SHIFT))

#define  ANTIFLIN_WDMA0_INT_PEND_RRESP_INT_PEND_MASK 0x400
#define  ANTIFLIN_WDMA0_INT_PEND_RRESP_INT_PEND_SHIFT 10
#define  ANTIFLIN_WDMA0_INT_PEND_RRESP_INT_PEND_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA0_INT_PEND_RRESP_INT_PEND_MASK) >> ANTIFLIN_WDMA0_INT_PEND_RRESP_INT_PEND_SHIFT)
#define  ANTIFLIN_WDMA0_INT_PEND_RRESP_INT_PEND_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA0_INT_PEND_RRESP_INT_PEND_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA0_INT_PEND_RRESP_INT_PEND_SHIFT))

#define  ANTIFLIN_WDMA0_INT_PEND_BRESP_INT_PEND_MASK 0x200
#define  ANTIFLIN_WDMA0_INT_PEND_BRESP_INT_PEND_SHIFT 9
#define  ANTIFLIN_WDMA0_INT_PEND_BRESP_INT_PEND_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA0_INT_PEND_BRESP_INT_PEND_MASK) >> ANTIFLIN_WDMA0_INT_PEND_BRESP_INT_PEND_SHIFT)
#define  ANTIFLIN_WDMA0_INT_PEND_BRESP_INT_PEND_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA0_INT_PEND_BRESP_INT_PEND_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA0_INT_PEND_BRESP_INT_PEND_SHIFT))

#define  ANTIFLIN_WDMA0_INT_PEND_RST_INT_PEND_MASK 0x100
#define  ANTIFLIN_WDMA0_INT_PEND_RST_INT_PEND_SHIFT 8
#define  ANTIFLIN_WDMA0_INT_PEND_RST_INT_PEND_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA0_INT_PEND_RST_INT_PEND_MASK) >> ANTIFLIN_WDMA0_INT_PEND_RST_INT_PEND_SHIFT)
#define  ANTIFLIN_WDMA0_INT_PEND_RST_INT_PEND_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA0_INT_PEND_RST_INT_PEND_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA0_INT_PEND_RST_INT_PEND_SHIFT))

#define  ANTIFLIN_WDMA0_INT_PEND_EOI_INT_PEND_MASK 0x80
#define  ANTIFLIN_WDMA0_INT_PEND_EOI_INT_PEND_SHIFT 7
#define  ANTIFLIN_WDMA0_INT_PEND_EOI_INT_PEND_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA0_INT_PEND_EOI_INT_PEND_MASK) >> ANTIFLIN_WDMA0_INT_PEND_EOI_INT_PEND_SHIFT)
#define  ANTIFLIN_WDMA0_INT_PEND_EOI_INT_PEND_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA0_INT_PEND_EOI_INT_PEND_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA0_INT_PEND_EOI_INT_PEND_SHIFT))

#define  ANTIFLIN_WDMA0_INT_PEND_DIR_INT_PEND_MASK 0x40
#define  ANTIFLIN_WDMA0_INT_PEND_DIR_INT_PEND_SHIFT 6
#define  ANTIFLIN_WDMA0_INT_PEND_DIR_INT_PEND_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA0_INT_PEND_DIR_INT_PEND_MASK) >> ANTIFLIN_WDMA0_INT_PEND_DIR_INT_PEND_SHIFT)
#define  ANTIFLIN_WDMA0_INT_PEND_DIR_INT_PEND_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA0_INT_PEND_DIR_INT_PEND_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA0_INT_PEND_DIR_INT_PEND_SHIFT))

#define  ANTIFLIN_WDMA0_INT_PEND_CL_ALI_INT_PEND_MASK 0x20
#define  ANTIFLIN_WDMA0_INT_PEND_CL_ALI_INT_PEND_SHIFT 5
#define  ANTIFLIN_WDMA0_INT_PEND_CL_ALI_INT_PEND_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA0_INT_PEND_CL_ALI_INT_PEND_MASK) >> ANTIFLIN_WDMA0_INT_PEND_CL_ALI_INT_PEND_SHIFT)
#define  ANTIFLIN_WDMA0_INT_PEND_CL_ALI_INT_PEND_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA0_INT_PEND_CL_ALI_INT_PEND_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA0_INT_PEND_CL_ALI_INT_PEND_SHIFT))

#define  ANTIFLIN_WDMA0_INT_PEND_EOL_ALI_INT_PEND_MASK 0x10
#define  ANTIFLIN_WDMA0_INT_PEND_EOL_ALI_INT_PEND_SHIFT 4
#define  ANTIFLIN_WDMA0_INT_PEND_EOL_ALI_INT_PEND_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA0_INT_PEND_EOL_ALI_INT_PEND_MASK) >> ANTIFLIN_WDMA0_INT_PEND_EOL_ALI_INT_PEND_SHIFT)
#define  ANTIFLIN_WDMA0_INT_PEND_EOL_ALI_INT_PEND_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA0_INT_PEND_EOL_ALI_INT_PEND_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA0_INT_PEND_EOL_ALI_INT_PEND_SHIFT))

#define  ANTIFLIN_WDMA0_INT_PEND_EOI_ALI_INT_PEND_MASK 0x8
#define  ANTIFLIN_WDMA0_INT_PEND_EOI_ALI_INT_PEND_SHIFT 3
#define  ANTIFLIN_WDMA0_INT_PEND_EOI_ALI_INT_PEND_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA0_INT_PEND_EOI_ALI_INT_PEND_MASK) >> ANTIFLIN_WDMA0_INT_PEND_EOI_ALI_INT_PEND_SHIFT)
#define  ANTIFLIN_WDMA0_INT_PEND_EOI_ALI_INT_PEND_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA0_INT_PEND_EOI_ALI_INT_PEND_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA0_INT_PEND_EOI_ALI_INT_PEND_SHIFT))

#define  ANTIFLIN_WDMA0_INT_PEND_EOI_ERR_INT_PEND_MASK 0x4
#define  ANTIFLIN_WDMA0_INT_PEND_EOI_ERR_INT_PEND_SHIFT 2
#define  ANTIFLIN_WDMA0_INT_PEND_EOI_ERR_INT_PEND_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA0_INT_PEND_EOI_ERR_INT_PEND_MASK) >> ANTIFLIN_WDMA0_INT_PEND_EOI_ERR_INT_PEND_SHIFT)
#define  ANTIFLIN_WDMA0_INT_PEND_EOI_ERR_INT_PEND_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA0_INT_PEND_EOI_ERR_INT_PEND_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA0_INT_PEND_EOI_ERR_INT_PEND_SHIFT))

#define  ANTIFLIN_WDMA0_INT_PEND_FIN_INT_PEND_MASK 0x2
#define  ANTIFLIN_WDMA0_INT_PEND_FIN_INT_PEND_SHIFT 1
#define  ANTIFLIN_WDMA0_INT_PEND_FIN_INT_PEND_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA0_INT_PEND_FIN_INT_PEND_MASK) >> ANTIFLIN_WDMA0_INT_PEND_FIN_INT_PEND_SHIFT)
#define  ANTIFLIN_WDMA0_INT_PEND_FIN_INT_PEND_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA0_INT_PEND_FIN_INT_PEND_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA0_INT_PEND_FIN_INT_PEND_SHIFT))

#define  ANTIFLIN_WDMA0_INT_PEND_WHO_INT_PEND_MASK 0x1
#define  ANTIFLIN_WDMA0_INT_PEND_WHO_INT_PEND_SHIFT 0
#define  ANTIFLIN_WDMA0_INT_PEND_WHO_INT_PEND_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA0_INT_PEND_WHO_INT_PEND_MASK) >> ANTIFLIN_WDMA0_INT_PEND_WHO_INT_PEND_SHIFT)
#define  ANTIFLIN_WDMA0_INT_PEND_WHO_INT_PEND_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA0_INT_PEND_WHO_INT_PEND_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA0_INT_PEND_WHO_INT_PEND_SHIFT))

//====================================================================
//Register: Interrupt Acknowledge Register (int_ack)
//====================================================================

#define  ANTIFLIN_WDMA0_INT_ACK_RESERVED1_MASK 0xfffff800
#define  ANTIFLIN_WDMA0_INT_ACK_RESERVED1_SHIFT 11
#define  ANTIFLIN_WDMA0_INT_ACK_RESERVED1_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA0_INT_ACK_RESERVED1_MASK) >> ANTIFLIN_WDMA0_INT_ACK_RESERVED1_SHIFT)
#define  ANTIFLIN_WDMA0_INT_ACK_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA0_INT_ACK_RESERVED1_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA0_INT_ACK_RESERVED1_SHIFT))

#define  ANTIFLIN_WDMA0_INT_ACK_RRESP_INT_ACK_MASK 0x400
#define  ANTIFLIN_WDMA0_INT_ACK_RRESP_INT_ACK_SHIFT 10
#define  ANTIFLIN_WDMA0_INT_ACK_RRESP_INT_ACK_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA0_INT_ACK_RRESP_INT_ACK_MASK) >> ANTIFLIN_WDMA0_INT_ACK_RRESP_INT_ACK_SHIFT)
#define  ANTIFLIN_WDMA0_INT_ACK_RRESP_INT_ACK_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA0_INT_ACK_RRESP_INT_ACK_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA0_INT_ACK_RRESP_INT_ACK_SHIFT))

#define  ANTIFLIN_WDMA0_INT_ACK_BRESP_INT_ACK_MASK 0x200
#define  ANTIFLIN_WDMA0_INT_ACK_BRESP_INT_ACK_SHIFT 9
#define  ANTIFLIN_WDMA0_INT_ACK_BRESP_INT_ACK_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA0_INT_ACK_BRESP_INT_ACK_MASK) >> ANTIFLIN_WDMA0_INT_ACK_BRESP_INT_ACK_SHIFT)
#define  ANTIFLIN_WDMA0_INT_ACK_BRESP_INT_ACK_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA0_INT_ACK_BRESP_INT_ACK_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA0_INT_ACK_BRESP_INT_ACK_SHIFT))

#define  ANTIFLIN_WDMA0_INT_ACK_RST_INT_ACK_MASK 0x100
#define  ANTIFLIN_WDMA0_INT_ACK_RST_INT_ACK_SHIFT 8
#define  ANTIFLIN_WDMA0_INT_ACK_RST_INT_ACK_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA0_INT_ACK_RST_INT_ACK_MASK) >> ANTIFLIN_WDMA0_INT_ACK_RST_INT_ACK_SHIFT)
#define  ANTIFLIN_WDMA0_INT_ACK_RST_INT_ACK_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA0_INT_ACK_RST_INT_ACK_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA0_INT_ACK_RST_INT_ACK_SHIFT))

#define  ANTIFLIN_WDMA0_INT_ACK_EOI_INT_ACK_MASK 0x80
#define  ANTIFLIN_WDMA0_INT_ACK_EOI_INT_ACK_SHIFT 7
#define  ANTIFLIN_WDMA0_INT_ACK_EOI_INT_ACK_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA0_INT_ACK_EOI_INT_ACK_MASK) >> ANTIFLIN_WDMA0_INT_ACK_EOI_INT_ACK_SHIFT)
#define  ANTIFLIN_WDMA0_INT_ACK_EOI_INT_ACK_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA0_INT_ACK_EOI_INT_ACK_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA0_INT_ACK_EOI_INT_ACK_SHIFT))

#define  ANTIFLIN_WDMA0_INT_ACK_DIR_INT_ACK_MASK 0x40
#define  ANTIFLIN_WDMA0_INT_ACK_DIR_INT_ACK_SHIFT 6
#define  ANTIFLIN_WDMA0_INT_ACK_DIR_INT_ACK_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA0_INT_ACK_DIR_INT_ACK_MASK) >> ANTIFLIN_WDMA0_INT_ACK_DIR_INT_ACK_SHIFT)
#define  ANTIFLIN_WDMA0_INT_ACK_DIR_INT_ACK_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA0_INT_ACK_DIR_INT_ACK_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA0_INT_ACK_DIR_INT_ACK_SHIFT))

#define  ANTIFLIN_WDMA0_INT_ACK_CL_ALI_INT_ACK_MASK 0x20
#define  ANTIFLIN_WDMA0_INT_ACK_CL_ALI_INT_ACK_SHIFT 5
#define  ANTIFLIN_WDMA0_INT_ACK_CL_ALI_INT_ACK_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA0_INT_ACK_CL_ALI_INT_ACK_MASK) >> ANTIFLIN_WDMA0_INT_ACK_CL_ALI_INT_ACK_SHIFT)
#define  ANTIFLIN_WDMA0_INT_ACK_CL_ALI_INT_ACK_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA0_INT_ACK_CL_ALI_INT_ACK_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA0_INT_ACK_CL_ALI_INT_ACK_SHIFT))

#define  ANTIFLIN_WDMA0_INT_ACK_EOL_ALI_INT_ACK_MASK 0x10
#define  ANTIFLIN_WDMA0_INT_ACK_EOL_ALI_INT_ACK_SHIFT 4
#define  ANTIFLIN_WDMA0_INT_ACK_EOL_ALI_INT_ACK_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA0_INT_ACK_EOL_ALI_INT_ACK_MASK) >> ANTIFLIN_WDMA0_INT_ACK_EOL_ALI_INT_ACK_SHIFT)
#define  ANTIFLIN_WDMA0_INT_ACK_EOL_ALI_INT_ACK_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA0_INT_ACK_EOL_ALI_INT_ACK_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA0_INT_ACK_EOL_ALI_INT_ACK_SHIFT))

#define  ANTIFLIN_WDMA0_INT_ACK_EOI_ALI_INT_ACK_MASK 0x8
#define  ANTIFLIN_WDMA0_INT_ACK_EOI_ALI_INT_ACK_SHIFT 3
#define  ANTIFLIN_WDMA0_INT_ACK_EOI_ALI_INT_ACK_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA0_INT_ACK_EOI_ALI_INT_ACK_MASK) >> ANTIFLIN_WDMA0_INT_ACK_EOI_ALI_INT_ACK_SHIFT)
#define  ANTIFLIN_WDMA0_INT_ACK_EOI_ALI_INT_ACK_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA0_INT_ACK_EOI_ALI_INT_ACK_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA0_INT_ACK_EOI_ALI_INT_ACK_SHIFT))

#define  ANTIFLIN_WDMA0_INT_ACK_EOI_ERR_INT_ACK_MASK 0x4
#define  ANTIFLIN_WDMA0_INT_ACK_EOI_ERR_INT_ACK_SHIFT 2
#define  ANTIFLIN_WDMA0_INT_ACK_EOI_ERR_INT_ACK_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA0_INT_ACK_EOI_ERR_INT_ACK_MASK) >> ANTIFLIN_WDMA0_INT_ACK_EOI_ERR_INT_ACK_SHIFT)
#define  ANTIFLIN_WDMA0_INT_ACK_EOI_ERR_INT_ACK_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA0_INT_ACK_EOI_ERR_INT_ACK_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA0_INT_ACK_EOI_ERR_INT_ACK_SHIFT))

#define  ANTIFLIN_WDMA0_INT_ACK_FIN_INT_ACK_MASK 0x2
#define  ANTIFLIN_WDMA0_INT_ACK_FIN_INT_ACK_SHIFT 1
#define  ANTIFLIN_WDMA0_INT_ACK_FIN_INT_ACK_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA0_INT_ACK_FIN_INT_ACK_MASK) >> ANTIFLIN_WDMA0_INT_ACK_FIN_INT_ACK_SHIFT)
#define  ANTIFLIN_WDMA0_INT_ACK_FIN_INT_ACK_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA0_INT_ACK_FIN_INT_ACK_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA0_INT_ACK_FIN_INT_ACK_SHIFT))

#define  ANTIFLIN_WDMA0_INT_ACK_WHO_INT_ACK_MASK 0x1
#define  ANTIFLIN_WDMA0_INT_ACK_WHO_INT_ACK_SHIFT 0
#define  ANTIFLIN_WDMA0_INT_ACK_WHO_INT_ACK_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA0_INT_ACK_WHO_INT_ACK_MASK) >> ANTIFLIN_WDMA0_INT_ACK_WHO_INT_ACK_SHIFT)
#define  ANTIFLIN_WDMA0_INT_ACK_WHO_INT_ACK_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA0_INT_ACK_WHO_INT_ACK_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA0_INT_ACK_WHO_INT_ACK_SHIFT))

//====================================================================
//Register: Interrupt Force Register (int_fo)
//====================================================================

#define  ANTIFLIN_WDMA0_INT_FO_RESERVED1_MASK 0xfffff800
#define  ANTIFLIN_WDMA0_INT_FO_RESERVED1_SHIFT 11
#define  ANTIFLIN_WDMA0_INT_FO_RESERVED1_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA0_INT_FO_RESERVED1_MASK) >> ANTIFLIN_WDMA0_INT_FO_RESERVED1_SHIFT)
#define  ANTIFLIN_WDMA0_INT_FO_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA0_INT_FO_RESERVED1_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA0_INT_FO_RESERVED1_SHIFT))

#define  ANTIFLIN_WDMA0_INT_FO_RRESP_INT_FO_MASK 0x400
#define  ANTIFLIN_WDMA0_INT_FO_RRESP_INT_FO_SHIFT 10
#define  ANTIFLIN_WDMA0_INT_FO_RRESP_INT_FO_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA0_INT_FO_RRESP_INT_FO_MASK) >> ANTIFLIN_WDMA0_INT_FO_RRESP_INT_FO_SHIFT)
#define  ANTIFLIN_WDMA0_INT_FO_RRESP_INT_FO_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA0_INT_FO_RRESP_INT_FO_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA0_INT_FO_RRESP_INT_FO_SHIFT))

#define  ANTIFLIN_WDMA0_INT_FO_BRESP_INT_FO_MASK 0x200
#define  ANTIFLIN_WDMA0_INT_FO_BRESP_INT_FO_SHIFT 9
#define  ANTIFLIN_WDMA0_INT_FO_BRESP_INT_FO_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA0_INT_FO_BRESP_INT_FO_MASK) >> ANTIFLIN_WDMA0_INT_FO_BRESP_INT_FO_SHIFT)
#define  ANTIFLIN_WDMA0_INT_FO_BRESP_INT_FO_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA0_INT_FO_BRESP_INT_FO_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA0_INT_FO_BRESP_INT_FO_SHIFT))

#define  ANTIFLIN_WDMA0_INT_FO_RST_INT_FO_MASK 0x100
#define  ANTIFLIN_WDMA0_INT_FO_RST_INT_FO_SHIFT 8
#define  ANTIFLIN_WDMA0_INT_FO_RST_INT_FO_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA0_INT_FO_RST_INT_FO_MASK) >> ANTIFLIN_WDMA0_INT_FO_RST_INT_FO_SHIFT)
#define  ANTIFLIN_WDMA0_INT_FO_RST_INT_FO_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA0_INT_FO_RST_INT_FO_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA0_INT_FO_RST_INT_FO_SHIFT))

#define  ANTIFLIN_WDMA0_INT_FO_EOI_INT_FO_MASK 0x80
#define  ANTIFLIN_WDMA0_INT_FO_EOI_INT_FO_SHIFT 7
#define  ANTIFLIN_WDMA0_INT_FO_EOI_INT_FO_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA0_INT_FO_EOI_INT_FO_MASK) >> ANTIFLIN_WDMA0_INT_FO_EOI_INT_FO_SHIFT)
#define  ANTIFLIN_WDMA0_INT_FO_EOI_INT_FO_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA0_INT_FO_EOI_INT_FO_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA0_INT_FO_EOI_INT_FO_SHIFT))

#define  ANTIFLIN_WDMA0_INT_FO_DIR_INT_FO_MASK 0x40
#define  ANTIFLIN_WDMA0_INT_FO_DIR_INT_FO_SHIFT 6
#define  ANTIFLIN_WDMA0_INT_FO_DIR_INT_FO_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA0_INT_FO_DIR_INT_FO_MASK) >> ANTIFLIN_WDMA0_INT_FO_DIR_INT_FO_SHIFT)
#define  ANTIFLIN_WDMA0_INT_FO_DIR_INT_FO_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA0_INT_FO_DIR_INT_FO_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA0_INT_FO_DIR_INT_FO_SHIFT))

#define  ANTIFLIN_WDMA0_INT_FO_CL_ALI_INT_FO_MASK 0x20
#define  ANTIFLIN_WDMA0_INT_FO_CL_ALI_INT_FO_SHIFT 5
#define  ANTIFLIN_WDMA0_INT_FO_CL_ALI_INT_FO_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA0_INT_FO_CL_ALI_INT_FO_MASK) >> ANTIFLIN_WDMA0_INT_FO_CL_ALI_INT_FO_SHIFT)
#define  ANTIFLIN_WDMA0_INT_FO_CL_ALI_INT_FO_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA0_INT_FO_CL_ALI_INT_FO_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA0_INT_FO_CL_ALI_INT_FO_SHIFT))

#define  ANTIFLIN_WDMA0_INT_FO_EOL_ALI_INT_FO_MASK 0x10
#define  ANTIFLIN_WDMA0_INT_FO_EOL_ALI_INT_FO_SHIFT 4
#define  ANTIFLIN_WDMA0_INT_FO_EOL_ALI_INT_FO_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA0_INT_FO_EOL_ALI_INT_FO_MASK) >> ANTIFLIN_WDMA0_INT_FO_EOL_ALI_INT_FO_SHIFT)
#define  ANTIFLIN_WDMA0_INT_FO_EOL_ALI_INT_FO_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA0_INT_FO_EOL_ALI_INT_FO_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA0_INT_FO_EOL_ALI_INT_FO_SHIFT))

#define  ANTIFLIN_WDMA0_INT_FO_EOI_ALI_INT_FO_MASK 0x8
#define  ANTIFLIN_WDMA0_INT_FO_EOI_ALI_INT_FO_SHIFT 3
#define  ANTIFLIN_WDMA0_INT_FO_EOI_ALI_INT_FO_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA0_INT_FO_EOI_ALI_INT_FO_MASK) >> ANTIFLIN_WDMA0_INT_FO_EOI_ALI_INT_FO_SHIFT)
#define  ANTIFLIN_WDMA0_INT_FO_EOI_ALI_INT_FO_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA0_INT_FO_EOI_ALI_INT_FO_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA0_INT_FO_EOI_ALI_INT_FO_SHIFT))

#define  ANTIFLIN_WDMA0_INT_FO_EOI_ERR_INT_FO_MASK 0x4
#define  ANTIFLIN_WDMA0_INT_FO_EOI_ERR_INT_FO_SHIFT 2
#define  ANTIFLIN_WDMA0_INT_FO_EOI_ERR_INT_FO_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA0_INT_FO_EOI_ERR_INT_FO_MASK) >> ANTIFLIN_WDMA0_INT_FO_EOI_ERR_INT_FO_SHIFT)
#define  ANTIFLIN_WDMA0_INT_FO_EOI_ERR_INT_FO_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA0_INT_FO_EOI_ERR_INT_FO_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA0_INT_FO_EOI_ERR_INT_FO_SHIFT))

#define  ANTIFLIN_WDMA0_INT_FO_FIN_INT_FO_MASK 0x2
#define  ANTIFLIN_WDMA0_INT_FO_FIN_INT_FO_SHIFT 1
#define  ANTIFLIN_WDMA0_INT_FO_FIN_INT_FO_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA0_INT_FO_FIN_INT_FO_MASK) >> ANTIFLIN_WDMA0_INT_FO_FIN_INT_FO_SHIFT)
#define  ANTIFLIN_WDMA0_INT_FO_FIN_INT_FO_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA0_INT_FO_FIN_INT_FO_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA0_INT_FO_FIN_INT_FO_SHIFT))

#define  ANTIFLIN_WDMA0_INT_FO_WHO_INT_FO_MASK 0x1
#define  ANTIFLIN_WDMA0_INT_FO_WHO_INT_FO_SHIFT 0
#define  ANTIFLIN_WDMA0_INT_FO_WHO_INT_FO_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA0_INT_FO_WHO_INT_FO_MASK) >> ANTIFLIN_WDMA0_INT_FO_WHO_INT_FO_SHIFT)
#define  ANTIFLIN_WDMA0_INT_FO_WHO_INT_FO_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA0_INT_FO_WHO_INT_FO_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA0_INT_FO_WHO_INT_FO_SHIFT))

//====================================================================
//Register: Descriptor Write Register (desc_write)
//====================================================================

#define  ANTIFLIN_WDMA0_DESC_WRITE_DESC_MASK 0xfffffffc
#define  ANTIFLIN_WDMA0_DESC_WRITE_DESC_SHIFT 2
#define  ANTIFLIN_WDMA0_DESC_WRITE_DESC_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA0_DESC_WRITE_DESC_MASK) >> ANTIFLIN_WDMA0_DESC_WRITE_DESC_SHIFT)
#define  ANTIFLIN_WDMA0_DESC_WRITE_DESC_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA0_DESC_WRITE_DESC_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA0_DESC_WRITE_DESC_SHIFT))

#define  ANTIFLIN_WDMA0_DESC_WRITE_RESERVED1_MASK 0x3
#define  ANTIFLIN_WDMA0_DESC_WRITE_RESERVED1_SHIFT 0
#define  ANTIFLIN_WDMA0_DESC_WRITE_RESERVED1_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA0_DESC_WRITE_RESERVED1_MASK) >> ANTIFLIN_WDMA0_DESC_WRITE_RESERVED1_SHIFT)
#define  ANTIFLIN_WDMA0_DESC_WRITE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA0_DESC_WRITE_RESERVED1_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA0_DESC_WRITE_RESERVED1_SHIFT))

//====================================================================
//Register: Descriptor Read Register (desc_read)
//====================================================================

#define  ANTIFLIN_WDMA0_DESC_READ_DESC_MASK 0xffffffff
#define  ANTIFLIN_WDMA0_DESC_READ_DESC_SHIFT 0
#define  ANTIFLIN_WDMA0_DESC_READ_DESC_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA0_DESC_READ_DESC_MASK) >> ANTIFLIN_WDMA0_DESC_READ_DESC_SHIFT)
#define  ANTIFLIN_WDMA0_DESC_READ_DESC_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA0_DESC_READ_DESC_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA0_DESC_READ_DESC_SHIFT))

//====================================================================
//Register: Descriptor Transfer Length Register (xfer_length)
//====================================================================

#define  ANTIFLIN_WDMA0_XFER_LENGTH_LEN_MASK 0xffffffff
#define  ANTIFLIN_WDMA0_XFER_LENGTH_LEN_SHIFT 0
#define  ANTIFLIN_WDMA0_XFER_LENGTH_LEN_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA0_XFER_LENGTH_LEN_MASK) >> ANTIFLIN_WDMA0_XFER_LENGTH_LEN_SHIFT)
#define  ANTIFLIN_WDMA0_XFER_LENGTH_LEN_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA0_XFER_LENGTH_LEN_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA0_XFER_LENGTH_LEN_SHIFT))

//====================================================================
//Register: Descriptor Transfer Address Register (xfer_addr)
//====================================================================

#define  ANTIFLIN_WDMA0_XFER_ADDR_ADDR_MASK 0xffffffff
#define  ANTIFLIN_WDMA0_XFER_ADDR_ADDR_SHIFT 0
#define  ANTIFLIN_WDMA0_XFER_ADDR_ADDR_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA0_XFER_ADDR_ADDR_MASK) >> ANTIFLIN_WDMA0_XFER_ADDR_ADDR_SHIFT)
#define  ANTIFLIN_WDMA0_XFER_ADDR_ADDR_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA0_XFER_ADDR_ADDR_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA0_XFER_ADDR_ADDR_SHIFT))

//====================================================================
//Register: Descriptor Transfer Burst Register (xfer_burst)
//====================================================================

#define  ANTIFLIN_WDMA0_XFER_BURST_RESERVED1_MASK 0xffffffe0
#define  ANTIFLIN_WDMA0_XFER_BURST_RESERVED1_SHIFT 5
#define  ANTIFLIN_WDMA0_XFER_BURST_RESERVED1_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA0_XFER_BURST_RESERVED1_MASK) >> ANTIFLIN_WDMA0_XFER_BURST_RESERVED1_SHIFT)
#define  ANTIFLIN_WDMA0_XFER_BURST_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA0_XFER_BURST_RESERVED1_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA0_XFER_BURST_RESERVED1_SHIFT))

#define  ANTIFLIN_WDMA0_XFER_BURST_BURST_MASK 0x1f
#define  ANTIFLIN_WDMA0_XFER_BURST_BURST_SHIFT 0
#define  ANTIFLIN_WDMA0_XFER_BURST_BURST_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA0_XFER_BURST_BURST_MASK) >> ANTIFLIN_WDMA0_XFER_BURST_BURST_SHIFT)
#define  ANTIFLIN_WDMA0_XFER_BURST_BURST_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA0_XFER_BURST_BURST_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA0_XFER_BURST_BURST_SHIFT))

//====================================================================
//Register: Soft Reset register (reset)
//====================================================================

#define  ANTIFLIN_WDMA0_RESET_RESERVED1_MASK 0xfffffffc
#define  ANTIFLIN_WDMA0_RESET_RESERVED1_SHIFT 2
#define  ANTIFLIN_WDMA0_RESET_RESERVED1_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA0_RESET_RESERVED1_MASK) >> ANTIFLIN_WDMA0_RESET_RESERVED1_SHIFT)
#define  ANTIFLIN_WDMA0_RESET_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA0_RESET_RESERVED1_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA0_RESET_RESERVED1_SHIFT))

#define  ANTIFLIN_WDMA0_RESET_FORCE_LAST_BURST_MASK 0x2
#define  ANTIFLIN_WDMA0_RESET_FORCE_LAST_BURST_SHIFT 1
#define  ANTIFLIN_WDMA0_RESET_FORCE_LAST_BURST_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA0_RESET_FORCE_LAST_BURST_MASK) >> ANTIFLIN_WDMA0_RESET_FORCE_LAST_BURST_SHIFT)
#define  ANTIFLIN_WDMA0_RESET_FORCE_LAST_BURST_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA0_RESET_FORCE_LAST_BURST_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA0_RESET_FORCE_LAST_BURST_SHIFT))

#define  ANTIFLIN_WDMA0_RESET_SOFT_RESET_MASK 0x1
#define  ANTIFLIN_WDMA0_RESET_SOFT_RESET_SHIFT 0
#define  ANTIFLIN_WDMA0_RESET_SOFT_RESET_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA0_RESET_SOFT_RESET_MASK) >> ANTIFLIN_WDMA0_RESET_SOFT_RESET_SHIFT)
#define  ANTIFLIN_WDMA0_RESET_SOFT_RESET_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA0_RESET_SOFT_RESET_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA0_RESET_SOFT_RESET_SHIFT))

//====================================================================
//Register: IP Tagging Revision 0 (REV0)
/** \brief Provide means for firmware to read IP tagging information.
      This register of particular interest to firmware.*/
//====================================================================

#define  ANTIFLIN_WDMA0_REV0_MAJ_MASK 0xffff0000
#define  ANTIFLIN_WDMA0_REV0_MAJ_SHIFT 16
#define  ANTIFLIN_WDMA0_REV0_MAJ_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA0_REV0_MAJ_MASK) >> ANTIFLIN_WDMA0_REV0_MAJ_SHIFT)
#define  ANTIFLIN_WDMA0_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA0_REV0_MAJ_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA0_REV0_MAJ_SHIFT))

#define  ANTIFLIN_WDMA0_REV0_MID_MASK 0xffff
#define  ANTIFLIN_WDMA0_REV0_MID_SHIFT 0
#define  ANTIFLIN_WDMA0_REV0_MID_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA0_REV0_MID_MASK) >> ANTIFLIN_WDMA0_REV0_MID_SHIFT)
#define  ANTIFLIN_WDMA0_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA0_REV0_MID_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA0_REV0_MID_SHIFT))

//====================================================================
//Register: IP Tagging Revision 1 (REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  ANTIFLIN_WDMA0_REV1_RESERVED1_MASK 0xffff0000
#define  ANTIFLIN_WDMA0_REV1_RESERVED1_SHIFT 16
#define  ANTIFLIN_WDMA0_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA0_REV1_RESERVED1_MASK) >> ANTIFLIN_WDMA0_REV1_RESERVED1_SHIFT)
#define  ANTIFLIN_WDMA0_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA0_REV1_RESERVED1_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA0_REV1_RESERVED1_SHIFT))

#define  ANTIFLIN_WDMA0_REV1_CFG_MASK 0xffff
#define  ANTIFLIN_WDMA0_REV1_CFG_SHIFT 0
#define  ANTIFLIN_WDMA0_REV1_CFG_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA0_REV1_CFG_MASK) >> ANTIFLIN_WDMA0_REV1_CFG_SHIFT)
#define  ANTIFLIN_WDMA0_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA0_REV1_CFG_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA0_REV1_CFG_SHIFT))

//====================================================================
//
//Register File: AntiFlin ODMA Channel (Instance 2 of 3) (ANTIFLIN_WDMA1)
/** \brief Register Descriptions for the ODMA_AXI block (rev 0 . 4 . 3 . 1)*/
//
//====================================================================

//====================================================================
//Register: Configuration register (cfg)
//====================================================================

#define  ANTIFLIN_WDMA1_CFG_RESERVED1_MASK 0xfe000000
#define  ANTIFLIN_WDMA1_CFG_RESERVED1_SHIFT 25
#define  ANTIFLIN_WDMA1_CFG_RESERVED1_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA1_CFG_RESERVED1_MASK) >> ANTIFLIN_WDMA1_CFG_RESERVED1_SHIFT)
#define  ANTIFLIN_WDMA1_CFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA1_CFG_RESERVED1_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA1_CFG_RESERVED1_SHIFT))

#define  ANTIFLIN_WDMA1_CFG_HANDSHAKEENABLE_MASK 0x1000000
#define  ANTIFLIN_WDMA1_CFG_HANDSHAKEENABLE_SHIFT 24
#define  ANTIFLIN_WDMA1_CFG_HANDSHAKEENABLE_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA1_CFG_HANDSHAKEENABLE_MASK) >> ANTIFLIN_WDMA1_CFG_HANDSHAKEENABLE_SHIFT)
#define  ANTIFLIN_WDMA1_CFG_HANDSHAKEENABLE_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA1_CFG_HANDSHAKEENABLE_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA1_CFG_HANDSHAKEENABLE_SHIFT))

#define  ANTIFLIN_WDMA1_CFG_OWNPOLARITY_MASK 0x800000
#define  ANTIFLIN_WDMA1_CFG_OWNPOLARITY_SHIFT 23
#define  ANTIFLIN_WDMA1_CFG_OWNPOLARITY_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA1_CFG_OWNPOLARITY_MASK) >> ANTIFLIN_WDMA1_CFG_OWNPOLARITY_SHIFT)
#define  ANTIFLIN_WDMA1_CFG_OWNPOLARITY_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA1_CFG_OWNPOLARITY_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA1_CFG_OWNPOLARITY_SHIFT))

#define  ANTIFLIN_WDMA1_CFG_OWNWRITEDISABLE_MASK 0x400000
#define  ANTIFLIN_WDMA1_CFG_OWNWRITEDISABLE_SHIFT 22
#define  ANTIFLIN_WDMA1_CFG_OWNWRITEDISABLE_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA1_CFG_OWNWRITEDISABLE_MASK) >> ANTIFLIN_WDMA1_CFG_OWNWRITEDISABLE_SHIFT)
#define  ANTIFLIN_WDMA1_CFG_OWNWRITEDISABLE_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA1_CFG_OWNWRITEDISABLE_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA1_CFG_OWNWRITEDISABLE_SHIFT))

#define  ANTIFLIN_WDMA1_CFG_SERPENTINE_MASK 0x200000
#define  ANTIFLIN_WDMA1_CFG_SERPENTINE_SHIFT 21
#define  ANTIFLIN_WDMA1_CFG_SERPENTINE_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA1_CFG_SERPENTINE_MASK) >> ANTIFLIN_WDMA1_CFG_SERPENTINE_SHIFT)
#define  ANTIFLIN_WDMA1_CFG_SERPENTINE_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA1_CFG_SERPENTINE_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA1_CFG_SERPENTINE_SHIFT))

#define  ANTIFLIN_WDMA1_CFG_LINE_REV_MASK 0x100000
#define  ANTIFLIN_WDMA1_CFG_LINE_REV_SHIFT 20
#define  ANTIFLIN_WDMA1_CFG_LINE_REV_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA1_CFG_LINE_REV_MASK) >> ANTIFLIN_WDMA1_CFG_LINE_REV_SHIFT)
#define  ANTIFLIN_WDMA1_CFG_LINE_REV_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA1_CFG_LINE_REV_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA1_CFG_LINE_REV_SHIFT))

#define  ANTIFLIN_WDMA1_CFG_TRAN_REV_MASK 0x80000
#define  ANTIFLIN_WDMA1_CFG_TRAN_REV_SHIFT 19
#define  ANTIFLIN_WDMA1_CFG_TRAN_REV_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA1_CFG_TRAN_REV_MASK) >> ANTIFLIN_WDMA1_CFG_TRAN_REV_SHIFT)
#define  ANTIFLIN_WDMA1_CFG_TRAN_REV_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA1_CFG_TRAN_REV_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA1_CFG_TRAN_REV_SHIFT))

#define  ANTIFLIN_WDMA1_CFG_UPPER_HALF_MASK 0x40000
#define  ANTIFLIN_WDMA1_CFG_UPPER_HALF_SHIFT 18
#define  ANTIFLIN_WDMA1_CFG_UPPER_HALF_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA1_CFG_UPPER_HALF_MASK) >> ANTIFLIN_WDMA1_CFG_UPPER_HALF_SHIFT)
#define  ANTIFLIN_WDMA1_CFG_UPPER_HALF_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA1_CFG_UPPER_HALF_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA1_CFG_UPPER_HALF_SHIFT))

#define  ANTIFLIN_WDMA1_CFG_MSB_IN_MASK 0x20000
#define  ANTIFLIN_WDMA1_CFG_MSB_IN_SHIFT 17
#define  ANTIFLIN_WDMA1_CFG_MSB_IN_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA1_CFG_MSB_IN_MASK) >> ANTIFLIN_WDMA1_CFG_MSB_IN_SHIFT)
#define  ANTIFLIN_WDMA1_CFG_MSB_IN_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA1_CFG_MSB_IN_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA1_CFG_MSB_IN_SHIFT))

#define  ANTIFLIN_WDMA1_CFG_ENABLE_MASK 0x10000
#define  ANTIFLIN_WDMA1_CFG_ENABLE_SHIFT 16
#define  ANTIFLIN_WDMA1_CFG_ENABLE_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA1_CFG_ENABLE_MASK) >> ANTIFLIN_WDMA1_CFG_ENABLE_SHIFT)
#define  ANTIFLIN_WDMA1_CFG_ENABLE_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA1_CFG_ENABLE_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA1_CFG_ENABLE_SHIFT))

#define  ANTIFLIN_WDMA1_CFG_RESERVED2_MASK 0xf800
#define  ANTIFLIN_WDMA1_CFG_RESERVED2_SHIFT 11
#define  ANTIFLIN_WDMA1_CFG_RESERVED2_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA1_CFG_RESERVED2_MASK) >> ANTIFLIN_WDMA1_CFG_RESERVED2_SHIFT)
#define  ANTIFLIN_WDMA1_CFG_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA1_CFG_RESERVED2_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA1_CFG_RESERVED2_SHIFT))

#define  ANTIFLIN_WDMA1_CFG_IN_WIDTH_MASK 0x700
#define  ANTIFLIN_WDMA1_CFG_IN_WIDTH_SHIFT 8
#define  ANTIFLIN_WDMA1_CFG_IN_WIDTH_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA1_CFG_IN_WIDTH_MASK) >> ANTIFLIN_WDMA1_CFG_IN_WIDTH_SHIFT)
#define  ANTIFLIN_WDMA1_CFG_IN_WIDTH_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA1_CFG_IN_WIDTH_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA1_CFG_IN_WIDTH_SHIFT))

#define  ANTIFLIN_WDMA1_CFG_RESERVED3_MASK 0xfc
#define  ANTIFLIN_WDMA1_CFG_RESERVED3_SHIFT 2
#define  ANTIFLIN_WDMA1_CFG_RESERVED3_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA1_CFG_RESERVED3_MASK) >> ANTIFLIN_WDMA1_CFG_RESERVED3_SHIFT)
#define  ANTIFLIN_WDMA1_CFG_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA1_CFG_RESERVED3_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA1_CFG_RESERVED3_SHIFT))

#define  ANTIFLIN_WDMA1_CFG_BURST_LEN_MASK 0x3
#define  ANTIFLIN_WDMA1_CFG_BURST_LEN_SHIFT 0
#define  ANTIFLIN_WDMA1_CFG_BURST_LEN_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA1_CFG_BURST_LEN_MASK) >> ANTIFLIN_WDMA1_CFG_BURST_LEN_SHIFT)
#define  ANTIFLIN_WDMA1_CFG_BURST_LEN_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA1_CFG_BURST_LEN_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA1_CFG_BURST_LEN_SHIFT))

//====================================================================
//Register: Status register (status)
//====================================================================

#define  ANTIFLIN_WDMA1_STATUS_RESERVED1_MASK 0xff000000
#define  ANTIFLIN_WDMA1_STATUS_RESERVED1_SHIFT 24
#define  ANTIFLIN_WDMA1_STATUS_RESERVED1_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA1_STATUS_RESERVED1_MASK) >> ANTIFLIN_WDMA1_STATUS_RESERVED1_SHIFT)
#define  ANTIFLIN_WDMA1_STATUS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA1_STATUS_RESERVED1_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA1_STATUS_RESERVED1_SHIFT))

#define  ANTIFLIN_WDMA1_STATUS_BYTESWAITING_MASK 0xff0000
#define  ANTIFLIN_WDMA1_STATUS_BYTESWAITING_SHIFT 16
#define  ANTIFLIN_WDMA1_STATUS_BYTESWAITING_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA1_STATUS_BYTESWAITING_MASK) >> ANTIFLIN_WDMA1_STATUS_BYTESWAITING_SHIFT)
#define  ANTIFLIN_WDMA1_STATUS_BYTESWAITING_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA1_STATUS_BYTESWAITING_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA1_STATUS_BYTESWAITING_SHIFT))

#define  ANTIFLIN_WDMA1_STATUS_RESERVED2_MASK 0x8000
#define  ANTIFLIN_WDMA1_STATUS_RESERVED2_SHIFT 15
#define  ANTIFLIN_WDMA1_STATUS_RESERVED2_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA1_STATUS_RESERVED2_MASK) >> ANTIFLIN_WDMA1_STATUS_RESERVED2_SHIFT)
#define  ANTIFLIN_WDMA1_STATUS_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA1_STATUS_RESERVED2_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA1_STATUS_RESERVED2_SHIFT))

#define  ANTIFLIN_WDMA1_STATUS_FORCE_BURST_BUSY_MASK 0x4000
#define  ANTIFLIN_WDMA1_STATUS_FORCE_BURST_BUSY_SHIFT 14
#define  ANTIFLIN_WDMA1_STATUS_FORCE_BURST_BUSY_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA1_STATUS_FORCE_BURST_BUSY_MASK) >> ANTIFLIN_WDMA1_STATUS_FORCE_BURST_BUSY_SHIFT)
#define  ANTIFLIN_WDMA1_STATUS_FORCE_BURST_BUSY_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA1_STATUS_FORCE_BURST_BUSY_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA1_STATUS_FORCE_BURST_BUSY_SHIFT))

#define  ANTIFLIN_WDMA1_STATUS_DMAPAUSED_MASK 0x2000
#define  ANTIFLIN_WDMA1_STATUS_DMAPAUSED_SHIFT 13
#define  ANTIFLIN_WDMA1_STATUS_DMAPAUSED_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA1_STATUS_DMAPAUSED_MASK) >> ANTIFLIN_WDMA1_STATUS_DMAPAUSED_SHIFT)
#define  ANTIFLIN_WDMA1_STATUS_DMAPAUSED_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA1_STATUS_DMAPAUSED_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA1_STATUS_DMAPAUSED_SHIFT))

#define  ANTIFLIN_WDMA1_STATUS_PAUSEAFTER_MASK 0x1000
#define  ANTIFLIN_WDMA1_STATUS_PAUSEAFTER_SHIFT 12
#define  ANTIFLIN_WDMA1_STATUS_PAUSEAFTER_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA1_STATUS_PAUSEAFTER_MASK) >> ANTIFLIN_WDMA1_STATUS_PAUSEAFTER_SHIFT)
#define  ANTIFLIN_WDMA1_STATUS_PAUSEAFTER_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA1_STATUS_PAUSEAFTER_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA1_STATUS_PAUSEAFTER_SHIFT))

#define  ANTIFLIN_WDMA1_STATUS_PAUSEBEFORE_MASK 0x800
#define  ANTIFLIN_WDMA1_STATUS_PAUSEBEFORE_SHIFT 11
#define  ANTIFLIN_WDMA1_STATUS_PAUSEBEFORE_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA1_STATUS_PAUSEBEFORE_MASK) >> ANTIFLIN_WDMA1_STATUS_PAUSEBEFORE_SHIFT)
#define  ANTIFLIN_WDMA1_STATUS_PAUSEBEFORE_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA1_STATUS_PAUSEBEFORE_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA1_STATUS_PAUSEBEFORE_SHIFT))

#define  ANTIFLIN_WDMA1_STATUS_DESC_OWN_MASK 0x400
#define  ANTIFLIN_WDMA1_STATUS_DESC_OWN_SHIFT 10
#define  ANTIFLIN_WDMA1_STATUS_DESC_OWN_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA1_STATUS_DESC_OWN_MASK) >> ANTIFLIN_WDMA1_STATUS_DESC_OWN_SHIFT)
#define  ANTIFLIN_WDMA1_STATUS_DESC_OWN_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA1_STATUS_DESC_OWN_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA1_STATUS_DESC_OWN_SHIFT))

#define  ANTIFLIN_WDMA1_STATUS_DESC_EOI_MASK 0x200
#define  ANTIFLIN_WDMA1_STATUS_DESC_EOI_SHIFT 9
#define  ANTIFLIN_WDMA1_STATUS_DESC_EOI_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA1_STATUS_DESC_EOI_MASK) >> ANTIFLIN_WDMA1_STATUS_DESC_EOI_SHIFT)
#define  ANTIFLIN_WDMA1_STATUS_DESC_EOI_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA1_STATUS_DESC_EOI_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA1_STATUS_DESC_EOI_SHIFT))

#define  ANTIFLIN_WDMA1_STATUS_DESC_SOI_MASK 0x100
#define  ANTIFLIN_WDMA1_STATUS_DESC_SOI_SHIFT 8
#define  ANTIFLIN_WDMA1_STATUS_DESC_SOI_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA1_STATUS_DESC_SOI_MASK) >> ANTIFLIN_WDMA1_STATUS_DESC_SOI_SHIFT)
#define  ANTIFLIN_WDMA1_STATUS_DESC_SOI_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA1_STATUS_DESC_SOI_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA1_STATUS_DESC_SOI_SHIFT))

#define  ANTIFLIN_WDMA1_STATUS_REVERSE_MASK 0x80
#define  ANTIFLIN_WDMA1_STATUS_REVERSE_SHIFT 7
#define  ANTIFLIN_WDMA1_STATUS_REVERSE_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA1_STATUS_REVERSE_MASK) >> ANTIFLIN_WDMA1_STATUS_REVERSE_SHIFT)
#define  ANTIFLIN_WDMA1_STATUS_REVERSE_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA1_STATUS_REVERSE_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA1_STATUS_REVERSE_SHIFT))

#define  ANTIFLIN_WDMA1_STATUS_SOFTRESET_MASK 0x40
#define  ANTIFLIN_WDMA1_STATUS_SOFTRESET_SHIFT 6
#define  ANTIFLIN_WDMA1_STATUS_SOFTRESET_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA1_STATUS_SOFTRESET_MASK) >> ANTIFLIN_WDMA1_STATUS_SOFTRESET_SHIFT)
#define  ANTIFLIN_WDMA1_STATUS_SOFTRESET_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA1_STATUS_SOFTRESET_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA1_STATUS_SOFTRESET_SHIFT))

#define  ANTIFLIN_WDMA1_STATUS_FULL_CBUF_MASK 0x20
#define  ANTIFLIN_WDMA1_STATUS_FULL_CBUF_SHIFT 5
#define  ANTIFLIN_WDMA1_STATUS_FULL_CBUF_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA1_STATUS_FULL_CBUF_MASK) >> ANTIFLIN_WDMA1_STATUS_FULL_CBUF_SHIFT)
#define  ANTIFLIN_WDMA1_STATUS_FULL_CBUF_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA1_STATUS_FULL_CBUF_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA1_STATUS_FULL_CBUF_SHIFT))

#define  ANTIFLIN_WDMA1_STATUS_EMPTY_CBUF_MASK 0x10
#define  ANTIFLIN_WDMA1_STATUS_EMPTY_CBUF_SHIFT 4
#define  ANTIFLIN_WDMA1_STATUS_EMPTY_CBUF_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA1_STATUS_EMPTY_CBUF_MASK) >> ANTIFLIN_WDMA1_STATUS_EMPTY_CBUF_SHIFT)
#define  ANTIFLIN_WDMA1_STATUS_EMPTY_CBUF_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA1_STATUS_EMPTY_CBUF_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA1_STATUS_EMPTY_CBUF_SHIFT))

#define  ANTIFLIN_WDMA1_STATUS_FULL_DBUF_MASK 0x8
#define  ANTIFLIN_WDMA1_STATUS_FULL_DBUF_SHIFT 3
#define  ANTIFLIN_WDMA1_STATUS_FULL_DBUF_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA1_STATUS_FULL_DBUF_MASK) >> ANTIFLIN_WDMA1_STATUS_FULL_DBUF_SHIFT)
#define  ANTIFLIN_WDMA1_STATUS_FULL_DBUF_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA1_STATUS_FULL_DBUF_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA1_STATUS_FULL_DBUF_SHIFT))

#define  ANTIFLIN_WDMA1_STATUS_EMPTY_DBUF_MASK 0x4
#define  ANTIFLIN_WDMA1_STATUS_EMPTY_DBUF_SHIFT 2
#define  ANTIFLIN_WDMA1_STATUS_EMPTY_DBUF_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA1_STATUS_EMPTY_DBUF_MASK) >> ANTIFLIN_WDMA1_STATUS_EMPTY_DBUF_SHIFT)
#define  ANTIFLIN_WDMA1_STATUS_EMPTY_DBUF_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA1_STATUS_EMPTY_DBUF_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA1_STATUS_EMPTY_DBUF_SHIFT))

#define  ANTIFLIN_WDMA1_STATUS_PACKER_EMPTY_MASK 0x2
#define  ANTIFLIN_WDMA1_STATUS_PACKER_EMPTY_SHIFT 1
#define  ANTIFLIN_WDMA1_STATUS_PACKER_EMPTY_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA1_STATUS_PACKER_EMPTY_MASK) >> ANTIFLIN_WDMA1_STATUS_PACKER_EMPTY_SHIFT)
#define  ANTIFLIN_WDMA1_STATUS_PACKER_EMPTY_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA1_STATUS_PACKER_EMPTY_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA1_STATUS_PACKER_EMPTY_SHIFT))

#define  ANTIFLIN_WDMA1_STATUS_DMA_BUSY_MASK 0x1
#define  ANTIFLIN_WDMA1_STATUS_DMA_BUSY_SHIFT 0
#define  ANTIFLIN_WDMA1_STATUS_DMA_BUSY_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA1_STATUS_DMA_BUSY_MASK) >> ANTIFLIN_WDMA1_STATUS_DMA_BUSY_SHIFT)
#define  ANTIFLIN_WDMA1_STATUS_DMA_BUSY_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA1_STATUS_DMA_BUSY_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA1_STATUS_DMA_BUSY_SHIFT))

//====================================================================
//Register: Line Size Register (line_size)
//====================================================================

#define  ANTIFLIN_WDMA1_LINE_SIZE_RESERVED1_MASK 0xfffc0000
#define  ANTIFLIN_WDMA1_LINE_SIZE_RESERVED1_SHIFT 18
#define  ANTIFLIN_WDMA1_LINE_SIZE_RESERVED1_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA1_LINE_SIZE_RESERVED1_MASK) >> ANTIFLIN_WDMA1_LINE_SIZE_RESERVED1_SHIFT)
#define  ANTIFLIN_WDMA1_LINE_SIZE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA1_LINE_SIZE_RESERVED1_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA1_LINE_SIZE_RESERVED1_SHIFT))

#define  ANTIFLIN_WDMA1_LINE_SIZE_LINE_SIZE_MASK 0x3ffff
#define  ANTIFLIN_WDMA1_LINE_SIZE_LINE_SIZE_SHIFT 0
#define  ANTIFLIN_WDMA1_LINE_SIZE_LINE_SIZE_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA1_LINE_SIZE_LINE_SIZE_MASK) >> ANTIFLIN_WDMA1_LINE_SIZE_LINE_SIZE_SHIFT)
#define  ANTIFLIN_WDMA1_LINE_SIZE_LINE_SIZE_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA1_LINE_SIZE_LINE_SIZE_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA1_LINE_SIZE_LINE_SIZE_SHIFT))

//====================================================================
//Register: Interrupt Enable Register (int_en)
//====================================================================

#define  ANTIFLIN_WDMA1_INT_EN_RESERVED1_MASK 0xfffff800
#define  ANTIFLIN_WDMA1_INT_EN_RESERVED1_SHIFT 11
#define  ANTIFLIN_WDMA1_INT_EN_RESERVED1_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA1_INT_EN_RESERVED1_MASK) >> ANTIFLIN_WDMA1_INT_EN_RESERVED1_SHIFT)
#define  ANTIFLIN_WDMA1_INT_EN_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA1_INT_EN_RESERVED1_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA1_INT_EN_RESERVED1_SHIFT))

#define  ANTIFLIN_WDMA1_INT_EN_RRESP_INT_EN_MASK 0x400
#define  ANTIFLIN_WDMA1_INT_EN_RRESP_INT_EN_SHIFT 10
#define  ANTIFLIN_WDMA1_INT_EN_RRESP_INT_EN_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA1_INT_EN_RRESP_INT_EN_MASK) >> ANTIFLIN_WDMA1_INT_EN_RRESP_INT_EN_SHIFT)
#define  ANTIFLIN_WDMA1_INT_EN_RRESP_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA1_INT_EN_RRESP_INT_EN_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA1_INT_EN_RRESP_INT_EN_SHIFT))

#define  ANTIFLIN_WDMA1_INT_EN_BRESP_INT_EN_MASK 0x200
#define  ANTIFLIN_WDMA1_INT_EN_BRESP_INT_EN_SHIFT 9
#define  ANTIFLIN_WDMA1_INT_EN_BRESP_INT_EN_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA1_INT_EN_BRESP_INT_EN_MASK) >> ANTIFLIN_WDMA1_INT_EN_BRESP_INT_EN_SHIFT)
#define  ANTIFLIN_WDMA1_INT_EN_BRESP_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA1_INT_EN_BRESP_INT_EN_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA1_INT_EN_BRESP_INT_EN_SHIFT))

#define  ANTIFLIN_WDMA1_INT_EN_RST_INT_EN_MASK 0x100
#define  ANTIFLIN_WDMA1_INT_EN_RST_INT_EN_SHIFT 8
#define  ANTIFLIN_WDMA1_INT_EN_RST_INT_EN_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA1_INT_EN_RST_INT_EN_MASK) >> ANTIFLIN_WDMA1_INT_EN_RST_INT_EN_SHIFT)
#define  ANTIFLIN_WDMA1_INT_EN_RST_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA1_INT_EN_RST_INT_EN_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA1_INT_EN_RST_INT_EN_SHIFT))

#define  ANTIFLIN_WDMA1_INT_EN_EOI_INT_EN_MASK 0x80
#define  ANTIFLIN_WDMA1_INT_EN_EOI_INT_EN_SHIFT 7
#define  ANTIFLIN_WDMA1_INT_EN_EOI_INT_EN_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA1_INT_EN_EOI_INT_EN_MASK) >> ANTIFLIN_WDMA1_INT_EN_EOI_INT_EN_SHIFT)
#define  ANTIFLIN_WDMA1_INT_EN_EOI_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA1_INT_EN_EOI_INT_EN_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA1_INT_EN_EOI_INT_EN_SHIFT))

#define  ANTIFLIN_WDMA1_INT_EN_DIR_INT_EN_MASK 0x40
#define  ANTIFLIN_WDMA1_INT_EN_DIR_INT_EN_SHIFT 6
#define  ANTIFLIN_WDMA1_INT_EN_DIR_INT_EN_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA1_INT_EN_DIR_INT_EN_MASK) >> ANTIFLIN_WDMA1_INT_EN_DIR_INT_EN_SHIFT)
#define  ANTIFLIN_WDMA1_INT_EN_DIR_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA1_INT_EN_DIR_INT_EN_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA1_INT_EN_DIR_INT_EN_SHIFT))

#define  ANTIFLIN_WDMA1_INT_EN_CL_ALI_INT_EN_MASK 0x20
#define  ANTIFLIN_WDMA1_INT_EN_CL_ALI_INT_EN_SHIFT 5
#define  ANTIFLIN_WDMA1_INT_EN_CL_ALI_INT_EN_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA1_INT_EN_CL_ALI_INT_EN_MASK) >> ANTIFLIN_WDMA1_INT_EN_CL_ALI_INT_EN_SHIFT)
#define  ANTIFLIN_WDMA1_INT_EN_CL_ALI_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA1_INT_EN_CL_ALI_INT_EN_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA1_INT_EN_CL_ALI_INT_EN_SHIFT))

#define  ANTIFLIN_WDMA1_INT_EN_EOL_ALI_INT_EN_MASK 0x10
#define  ANTIFLIN_WDMA1_INT_EN_EOL_ALI_INT_EN_SHIFT 4
#define  ANTIFLIN_WDMA1_INT_EN_EOL_ALI_INT_EN_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA1_INT_EN_EOL_ALI_INT_EN_MASK) >> ANTIFLIN_WDMA1_INT_EN_EOL_ALI_INT_EN_SHIFT)
#define  ANTIFLIN_WDMA1_INT_EN_EOL_ALI_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA1_INT_EN_EOL_ALI_INT_EN_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA1_INT_EN_EOL_ALI_INT_EN_SHIFT))

#define  ANTIFLIN_WDMA1_INT_EN_EOI_ALI_INT_EN_MASK 0x8
#define  ANTIFLIN_WDMA1_INT_EN_EOI_ALI_INT_EN_SHIFT 3
#define  ANTIFLIN_WDMA1_INT_EN_EOI_ALI_INT_EN_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA1_INT_EN_EOI_ALI_INT_EN_MASK) >> ANTIFLIN_WDMA1_INT_EN_EOI_ALI_INT_EN_SHIFT)
#define  ANTIFLIN_WDMA1_INT_EN_EOI_ALI_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA1_INT_EN_EOI_ALI_INT_EN_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA1_INT_EN_EOI_ALI_INT_EN_SHIFT))

#define  ANTIFLIN_WDMA1_INT_EN_EOI_ERR_INT_EN_MASK 0x4
#define  ANTIFLIN_WDMA1_INT_EN_EOI_ERR_INT_EN_SHIFT 2
#define  ANTIFLIN_WDMA1_INT_EN_EOI_ERR_INT_EN_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA1_INT_EN_EOI_ERR_INT_EN_MASK) >> ANTIFLIN_WDMA1_INT_EN_EOI_ERR_INT_EN_SHIFT)
#define  ANTIFLIN_WDMA1_INT_EN_EOI_ERR_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA1_INT_EN_EOI_ERR_INT_EN_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA1_INT_EN_EOI_ERR_INT_EN_SHIFT))

#define  ANTIFLIN_WDMA1_INT_EN_FIN_INT_EN_MASK 0x2
#define  ANTIFLIN_WDMA1_INT_EN_FIN_INT_EN_SHIFT 1
#define  ANTIFLIN_WDMA1_INT_EN_FIN_INT_EN_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA1_INT_EN_FIN_INT_EN_MASK) >> ANTIFLIN_WDMA1_INT_EN_FIN_INT_EN_SHIFT)
#define  ANTIFLIN_WDMA1_INT_EN_FIN_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA1_INT_EN_FIN_INT_EN_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA1_INT_EN_FIN_INT_EN_SHIFT))

#define  ANTIFLIN_WDMA1_INT_EN_WHO_INT_EN_MASK 0x1
#define  ANTIFLIN_WDMA1_INT_EN_WHO_INT_EN_SHIFT 0
#define  ANTIFLIN_WDMA1_INT_EN_WHO_INT_EN_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA1_INT_EN_WHO_INT_EN_MASK) >> ANTIFLIN_WDMA1_INT_EN_WHO_INT_EN_SHIFT)
#define  ANTIFLIN_WDMA1_INT_EN_WHO_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA1_INT_EN_WHO_INT_EN_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA1_INT_EN_WHO_INT_EN_SHIFT))

//====================================================================
//Register: Interrupt Pending Register (int_pend)
//====================================================================

#define  ANTIFLIN_WDMA1_INT_PEND_RESERVED1_MASK 0xfffff800
#define  ANTIFLIN_WDMA1_INT_PEND_RESERVED1_SHIFT 11
#define  ANTIFLIN_WDMA1_INT_PEND_RESERVED1_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA1_INT_PEND_RESERVED1_MASK) >> ANTIFLIN_WDMA1_INT_PEND_RESERVED1_SHIFT)
#define  ANTIFLIN_WDMA1_INT_PEND_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA1_INT_PEND_RESERVED1_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA1_INT_PEND_RESERVED1_SHIFT))

#define  ANTIFLIN_WDMA1_INT_PEND_RRESP_INT_PEND_MASK 0x400
#define  ANTIFLIN_WDMA1_INT_PEND_RRESP_INT_PEND_SHIFT 10
#define  ANTIFLIN_WDMA1_INT_PEND_RRESP_INT_PEND_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA1_INT_PEND_RRESP_INT_PEND_MASK) >> ANTIFLIN_WDMA1_INT_PEND_RRESP_INT_PEND_SHIFT)
#define  ANTIFLIN_WDMA1_INT_PEND_RRESP_INT_PEND_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA1_INT_PEND_RRESP_INT_PEND_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA1_INT_PEND_RRESP_INT_PEND_SHIFT))

#define  ANTIFLIN_WDMA1_INT_PEND_BRESP_INT_PEND_MASK 0x200
#define  ANTIFLIN_WDMA1_INT_PEND_BRESP_INT_PEND_SHIFT 9
#define  ANTIFLIN_WDMA1_INT_PEND_BRESP_INT_PEND_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA1_INT_PEND_BRESP_INT_PEND_MASK) >> ANTIFLIN_WDMA1_INT_PEND_BRESP_INT_PEND_SHIFT)
#define  ANTIFLIN_WDMA1_INT_PEND_BRESP_INT_PEND_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA1_INT_PEND_BRESP_INT_PEND_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA1_INT_PEND_BRESP_INT_PEND_SHIFT))

#define  ANTIFLIN_WDMA1_INT_PEND_RST_INT_PEND_MASK 0x100
#define  ANTIFLIN_WDMA1_INT_PEND_RST_INT_PEND_SHIFT 8
#define  ANTIFLIN_WDMA1_INT_PEND_RST_INT_PEND_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA1_INT_PEND_RST_INT_PEND_MASK) >> ANTIFLIN_WDMA1_INT_PEND_RST_INT_PEND_SHIFT)
#define  ANTIFLIN_WDMA1_INT_PEND_RST_INT_PEND_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA1_INT_PEND_RST_INT_PEND_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA1_INT_PEND_RST_INT_PEND_SHIFT))

#define  ANTIFLIN_WDMA1_INT_PEND_EOI_INT_PEND_MASK 0x80
#define  ANTIFLIN_WDMA1_INT_PEND_EOI_INT_PEND_SHIFT 7
#define  ANTIFLIN_WDMA1_INT_PEND_EOI_INT_PEND_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA1_INT_PEND_EOI_INT_PEND_MASK) >> ANTIFLIN_WDMA1_INT_PEND_EOI_INT_PEND_SHIFT)
#define  ANTIFLIN_WDMA1_INT_PEND_EOI_INT_PEND_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA1_INT_PEND_EOI_INT_PEND_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA1_INT_PEND_EOI_INT_PEND_SHIFT))

#define  ANTIFLIN_WDMA1_INT_PEND_DIR_INT_PEND_MASK 0x40
#define  ANTIFLIN_WDMA1_INT_PEND_DIR_INT_PEND_SHIFT 6
#define  ANTIFLIN_WDMA1_INT_PEND_DIR_INT_PEND_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA1_INT_PEND_DIR_INT_PEND_MASK) >> ANTIFLIN_WDMA1_INT_PEND_DIR_INT_PEND_SHIFT)
#define  ANTIFLIN_WDMA1_INT_PEND_DIR_INT_PEND_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA1_INT_PEND_DIR_INT_PEND_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA1_INT_PEND_DIR_INT_PEND_SHIFT))

#define  ANTIFLIN_WDMA1_INT_PEND_CL_ALI_INT_PEND_MASK 0x20
#define  ANTIFLIN_WDMA1_INT_PEND_CL_ALI_INT_PEND_SHIFT 5
#define  ANTIFLIN_WDMA1_INT_PEND_CL_ALI_INT_PEND_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA1_INT_PEND_CL_ALI_INT_PEND_MASK) >> ANTIFLIN_WDMA1_INT_PEND_CL_ALI_INT_PEND_SHIFT)
#define  ANTIFLIN_WDMA1_INT_PEND_CL_ALI_INT_PEND_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA1_INT_PEND_CL_ALI_INT_PEND_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA1_INT_PEND_CL_ALI_INT_PEND_SHIFT))

#define  ANTIFLIN_WDMA1_INT_PEND_EOL_ALI_INT_PEND_MASK 0x10
#define  ANTIFLIN_WDMA1_INT_PEND_EOL_ALI_INT_PEND_SHIFT 4
#define  ANTIFLIN_WDMA1_INT_PEND_EOL_ALI_INT_PEND_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA1_INT_PEND_EOL_ALI_INT_PEND_MASK) >> ANTIFLIN_WDMA1_INT_PEND_EOL_ALI_INT_PEND_SHIFT)
#define  ANTIFLIN_WDMA1_INT_PEND_EOL_ALI_INT_PEND_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA1_INT_PEND_EOL_ALI_INT_PEND_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA1_INT_PEND_EOL_ALI_INT_PEND_SHIFT))

#define  ANTIFLIN_WDMA1_INT_PEND_EOI_ALI_INT_PEND_MASK 0x8
#define  ANTIFLIN_WDMA1_INT_PEND_EOI_ALI_INT_PEND_SHIFT 3
#define  ANTIFLIN_WDMA1_INT_PEND_EOI_ALI_INT_PEND_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA1_INT_PEND_EOI_ALI_INT_PEND_MASK) >> ANTIFLIN_WDMA1_INT_PEND_EOI_ALI_INT_PEND_SHIFT)
#define  ANTIFLIN_WDMA1_INT_PEND_EOI_ALI_INT_PEND_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA1_INT_PEND_EOI_ALI_INT_PEND_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA1_INT_PEND_EOI_ALI_INT_PEND_SHIFT))

#define  ANTIFLIN_WDMA1_INT_PEND_EOI_ERR_INT_PEND_MASK 0x4
#define  ANTIFLIN_WDMA1_INT_PEND_EOI_ERR_INT_PEND_SHIFT 2
#define  ANTIFLIN_WDMA1_INT_PEND_EOI_ERR_INT_PEND_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA1_INT_PEND_EOI_ERR_INT_PEND_MASK) >> ANTIFLIN_WDMA1_INT_PEND_EOI_ERR_INT_PEND_SHIFT)
#define  ANTIFLIN_WDMA1_INT_PEND_EOI_ERR_INT_PEND_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA1_INT_PEND_EOI_ERR_INT_PEND_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA1_INT_PEND_EOI_ERR_INT_PEND_SHIFT))

#define  ANTIFLIN_WDMA1_INT_PEND_FIN_INT_PEND_MASK 0x2
#define  ANTIFLIN_WDMA1_INT_PEND_FIN_INT_PEND_SHIFT 1
#define  ANTIFLIN_WDMA1_INT_PEND_FIN_INT_PEND_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA1_INT_PEND_FIN_INT_PEND_MASK) >> ANTIFLIN_WDMA1_INT_PEND_FIN_INT_PEND_SHIFT)
#define  ANTIFLIN_WDMA1_INT_PEND_FIN_INT_PEND_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA1_INT_PEND_FIN_INT_PEND_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA1_INT_PEND_FIN_INT_PEND_SHIFT))

#define  ANTIFLIN_WDMA1_INT_PEND_WHO_INT_PEND_MASK 0x1
#define  ANTIFLIN_WDMA1_INT_PEND_WHO_INT_PEND_SHIFT 0
#define  ANTIFLIN_WDMA1_INT_PEND_WHO_INT_PEND_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA1_INT_PEND_WHO_INT_PEND_MASK) >> ANTIFLIN_WDMA1_INT_PEND_WHO_INT_PEND_SHIFT)
#define  ANTIFLIN_WDMA1_INT_PEND_WHO_INT_PEND_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA1_INT_PEND_WHO_INT_PEND_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA1_INT_PEND_WHO_INT_PEND_SHIFT))

//====================================================================
//Register: Interrupt Acknowledge Register (int_ack)
//====================================================================

#define  ANTIFLIN_WDMA1_INT_ACK_RESERVED1_MASK 0xfffff800
#define  ANTIFLIN_WDMA1_INT_ACK_RESERVED1_SHIFT 11
#define  ANTIFLIN_WDMA1_INT_ACK_RESERVED1_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA1_INT_ACK_RESERVED1_MASK) >> ANTIFLIN_WDMA1_INT_ACK_RESERVED1_SHIFT)
#define  ANTIFLIN_WDMA1_INT_ACK_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA1_INT_ACK_RESERVED1_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA1_INT_ACK_RESERVED1_SHIFT))

#define  ANTIFLIN_WDMA1_INT_ACK_RRESP_INT_ACK_MASK 0x400
#define  ANTIFLIN_WDMA1_INT_ACK_RRESP_INT_ACK_SHIFT 10
#define  ANTIFLIN_WDMA1_INT_ACK_RRESP_INT_ACK_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA1_INT_ACK_RRESP_INT_ACK_MASK) >> ANTIFLIN_WDMA1_INT_ACK_RRESP_INT_ACK_SHIFT)
#define  ANTIFLIN_WDMA1_INT_ACK_RRESP_INT_ACK_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA1_INT_ACK_RRESP_INT_ACK_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA1_INT_ACK_RRESP_INT_ACK_SHIFT))

#define  ANTIFLIN_WDMA1_INT_ACK_BRESP_INT_ACK_MASK 0x200
#define  ANTIFLIN_WDMA1_INT_ACK_BRESP_INT_ACK_SHIFT 9
#define  ANTIFLIN_WDMA1_INT_ACK_BRESP_INT_ACK_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA1_INT_ACK_BRESP_INT_ACK_MASK) >> ANTIFLIN_WDMA1_INT_ACK_BRESP_INT_ACK_SHIFT)
#define  ANTIFLIN_WDMA1_INT_ACK_BRESP_INT_ACK_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA1_INT_ACK_BRESP_INT_ACK_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA1_INT_ACK_BRESP_INT_ACK_SHIFT))

#define  ANTIFLIN_WDMA1_INT_ACK_RST_INT_ACK_MASK 0x100
#define  ANTIFLIN_WDMA1_INT_ACK_RST_INT_ACK_SHIFT 8
#define  ANTIFLIN_WDMA1_INT_ACK_RST_INT_ACK_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA1_INT_ACK_RST_INT_ACK_MASK) >> ANTIFLIN_WDMA1_INT_ACK_RST_INT_ACK_SHIFT)
#define  ANTIFLIN_WDMA1_INT_ACK_RST_INT_ACK_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA1_INT_ACK_RST_INT_ACK_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA1_INT_ACK_RST_INT_ACK_SHIFT))

#define  ANTIFLIN_WDMA1_INT_ACK_EOI_INT_ACK_MASK 0x80
#define  ANTIFLIN_WDMA1_INT_ACK_EOI_INT_ACK_SHIFT 7
#define  ANTIFLIN_WDMA1_INT_ACK_EOI_INT_ACK_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA1_INT_ACK_EOI_INT_ACK_MASK) >> ANTIFLIN_WDMA1_INT_ACK_EOI_INT_ACK_SHIFT)
#define  ANTIFLIN_WDMA1_INT_ACK_EOI_INT_ACK_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA1_INT_ACK_EOI_INT_ACK_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA1_INT_ACK_EOI_INT_ACK_SHIFT))

#define  ANTIFLIN_WDMA1_INT_ACK_DIR_INT_ACK_MASK 0x40
#define  ANTIFLIN_WDMA1_INT_ACK_DIR_INT_ACK_SHIFT 6
#define  ANTIFLIN_WDMA1_INT_ACK_DIR_INT_ACK_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA1_INT_ACK_DIR_INT_ACK_MASK) >> ANTIFLIN_WDMA1_INT_ACK_DIR_INT_ACK_SHIFT)
#define  ANTIFLIN_WDMA1_INT_ACK_DIR_INT_ACK_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA1_INT_ACK_DIR_INT_ACK_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA1_INT_ACK_DIR_INT_ACK_SHIFT))

#define  ANTIFLIN_WDMA1_INT_ACK_CL_ALI_INT_ACK_MASK 0x20
#define  ANTIFLIN_WDMA1_INT_ACK_CL_ALI_INT_ACK_SHIFT 5
#define  ANTIFLIN_WDMA1_INT_ACK_CL_ALI_INT_ACK_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA1_INT_ACK_CL_ALI_INT_ACK_MASK) >> ANTIFLIN_WDMA1_INT_ACK_CL_ALI_INT_ACK_SHIFT)
#define  ANTIFLIN_WDMA1_INT_ACK_CL_ALI_INT_ACK_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA1_INT_ACK_CL_ALI_INT_ACK_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA1_INT_ACK_CL_ALI_INT_ACK_SHIFT))

#define  ANTIFLIN_WDMA1_INT_ACK_EOL_ALI_INT_ACK_MASK 0x10
#define  ANTIFLIN_WDMA1_INT_ACK_EOL_ALI_INT_ACK_SHIFT 4
#define  ANTIFLIN_WDMA1_INT_ACK_EOL_ALI_INT_ACK_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA1_INT_ACK_EOL_ALI_INT_ACK_MASK) >> ANTIFLIN_WDMA1_INT_ACK_EOL_ALI_INT_ACK_SHIFT)
#define  ANTIFLIN_WDMA1_INT_ACK_EOL_ALI_INT_ACK_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA1_INT_ACK_EOL_ALI_INT_ACK_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA1_INT_ACK_EOL_ALI_INT_ACK_SHIFT))

#define  ANTIFLIN_WDMA1_INT_ACK_EOI_ALI_INT_ACK_MASK 0x8
#define  ANTIFLIN_WDMA1_INT_ACK_EOI_ALI_INT_ACK_SHIFT 3
#define  ANTIFLIN_WDMA1_INT_ACK_EOI_ALI_INT_ACK_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA1_INT_ACK_EOI_ALI_INT_ACK_MASK) >> ANTIFLIN_WDMA1_INT_ACK_EOI_ALI_INT_ACK_SHIFT)
#define  ANTIFLIN_WDMA1_INT_ACK_EOI_ALI_INT_ACK_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA1_INT_ACK_EOI_ALI_INT_ACK_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA1_INT_ACK_EOI_ALI_INT_ACK_SHIFT))

#define  ANTIFLIN_WDMA1_INT_ACK_EOI_ERR_INT_ACK_MASK 0x4
#define  ANTIFLIN_WDMA1_INT_ACK_EOI_ERR_INT_ACK_SHIFT 2
#define  ANTIFLIN_WDMA1_INT_ACK_EOI_ERR_INT_ACK_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA1_INT_ACK_EOI_ERR_INT_ACK_MASK) >> ANTIFLIN_WDMA1_INT_ACK_EOI_ERR_INT_ACK_SHIFT)
#define  ANTIFLIN_WDMA1_INT_ACK_EOI_ERR_INT_ACK_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA1_INT_ACK_EOI_ERR_INT_ACK_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA1_INT_ACK_EOI_ERR_INT_ACK_SHIFT))

#define  ANTIFLIN_WDMA1_INT_ACK_FIN_INT_ACK_MASK 0x2
#define  ANTIFLIN_WDMA1_INT_ACK_FIN_INT_ACK_SHIFT 1
#define  ANTIFLIN_WDMA1_INT_ACK_FIN_INT_ACK_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA1_INT_ACK_FIN_INT_ACK_MASK) >> ANTIFLIN_WDMA1_INT_ACK_FIN_INT_ACK_SHIFT)
#define  ANTIFLIN_WDMA1_INT_ACK_FIN_INT_ACK_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA1_INT_ACK_FIN_INT_ACK_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA1_INT_ACK_FIN_INT_ACK_SHIFT))

#define  ANTIFLIN_WDMA1_INT_ACK_WHO_INT_ACK_MASK 0x1
#define  ANTIFLIN_WDMA1_INT_ACK_WHO_INT_ACK_SHIFT 0
#define  ANTIFLIN_WDMA1_INT_ACK_WHO_INT_ACK_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA1_INT_ACK_WHO_INT_ACK_MASK) >> ANTIFLIN_WDMA1_INT_ACK_WHO_INT_ACK_SHIFT)
#define  ANTIFLIN_WDMA1_INT_ACK_WHO_INT_ACK_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA1_INT_ACK_WHO_INT_ACK_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA1_INT_ACK_WHO_INT_ACK_SHIFT))

//====================================================================
//Register: Interrupt Force Register (int_fo)
//====================================================================

#define  ANTIFLIN_WDMA1_INT_FO_RESERVED1_MASK 0xfffff800
#define  ANTIFLIN_WDMA1_INT_FO_RESERVED1_SHIFT 11
#define  ANTIFLIN_WDMA1_INT_FO_RESERVED1_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA1_INT_FO_RESERVED1_MASK) >> ANTIFLIN_WDMA1_INT_FO_RESERVED1_SHIFT)
#define  ANTIFLIN_WDMA1_INT_FO_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA1_INT_FO_RESERVED1_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA1_INT_FO_RESERVED1_SHIFT))

#define  ANTIFLIN_WDMA1_INT_FO_RRESP_INT_FO_MASK 0x400
#define  ANTIFLIN_WDMA1_INT_FO_RRESP_INT_FO_SHIFT 10
#define  ANTIFLIN_WDMA1_INT_FO_RRESP_INT_FO_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA1_INT_FO_RRESP_INT_FO_MASK) >> ANTIFLIN_WDMA1_INT_FO_RRESP_INT_FO_SHIFT)
#define  ANTIFLIN_WDMA1_INT_FO_RRESP_INT_FO_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA1_INT_FO_RRESP_INT_FO_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA1_INT_FO_RRESP_INT_FO_SHIFT))

#define  ANTIFLIN_WDMA1_INT_FO_BRESP_INT_FO_MASK 0x200
#define  ANTIFLIN_WDMA1_INT_FO_BRESP_INT_FO_SHIFT 9
#define  ANTIFLIN_WDMA1_INT_FO_BRESP_INT_FO_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA1_INT_FO_BRESP_INT_FO_MASK) >> ANTIFLIN_WDMA1_INT_FO_BRESP_INT_FO_SHIFT)
#define  ANTIFLIN_WDMA1_INT_FO_BRESP_INT_FO_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA1_INT_FO_BRESP_INT_FO_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA1_INT_FO_BRESP_INT_FO_SHIFT))

#define  ANTIFLIN_WDMA1_INT_FO_RST_INT_FO_MASK 0x100
#define  ANTIFLIN_WDMA1_INT_FO_RST_INT_FO_SHIFT 8
#define  ANTIFLIN_WDMA1_INT_FO_RST_INT_FO_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA1_INT_FO_RST_INT_FO_MASK) >> ANTIFLIN_WDMA1_INT_FO_RST_INT_FO_SHIFT)
#define  ANTIFLIN_WDMA1_INT_FO_RST_INT_FO_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA1_INT_FO_RST_INT_FO_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA1_INT_FO_RST_INT_FO_SHIFT))

#define  ANTIFLIN_WDMA1_INT_FO_EOI_INT_FO_MASK 0x80
#define  ANTIFLIN_WDMA1_INT_FO_EOI_INT_FO_SHIFT 7
#define  ANTIFLIN_WDMA1_INT_FO_EOI_INT_FO_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA1_INT_FO_EOI_INT_FO_MASK) >> ANTIFLIN_WDMA1_INT_FO_EOI_INT_FO_SHIFT)
#define  ANTIFLIN_WDMA1_INT_FO_EOI_INT_FO_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA1_INT_FO_EOI_INT_FO_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA1_INT_FO_EOI_INT_FO_SHIFT))

#define  ANTIFLIN_WDMA1_INT_FO_DIR_INT_FO_MASK 0x40
#define  ANTIFLIN_WDMA1_INT_FO_DIR_INT_FO_SHIFT 6
#define  ANTIFLIN_WDMA1_INT_FO_DIR_INT_FO_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA1_INT_FO_DIR_INT_FO_MASK) >> ANTIFLIN_WDMA1_INT_FO_DIR_INT_FO_SHIFT)
#define  ANTIFLIN_WDMA1_INT_FO_DIR_INT_FO_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA1_INT_FO_DIR_INT_FO_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA1_INT_FO_DIR_INT_FO_SHIFT))

#define  ANTIFLIN_WDMA1_INT_FO_CL_ALI_INT_FO_MASK 0x20
#define  ANTIFLIN_WDMA1_INT_FO_CL_ALI_INT_FO_SHIFT 5
#define  ANTIFLIN_WDMA1_INT_FO_CL_ALI_INT_FO_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA1_INT_FO_CL_ALI_INT_FO_MASK) >> ANTIFLIN_WDMA1_INT_FO_CL_ALI_INT_FO_SHIFT)
#define  ANTIFLIN_WDMA1_INT_FO_CL_ALI_INT_FO_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA1_INT_FO_CL_ALI_INT_FO_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA1_INT_FO_CL_ALI_INT_FO_SHIFT))

#define  ANTIFLIN_WDMA1_INT_FO_EOL_ALI_INT_FO_MASK 0x10
#define  ANTIFLIN_WDMA1_INT_FO_EOL_ALI_INT_FO_SHIFT 4
#define  ANTIFLIN_WDMA1_INT_FO_EOL_ALI_INT_FO_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA1_INT_FO_EOL_ALI_INT_FO_MASK) >> ANTIFLIN_WDMA1_INT_FO_EOL_ALI_INT_FO_SHIFT)
#define  ANTIFLIN_WDMA1_INT_FO_EOL_ALI_INT_FO_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA1_INT_FO_EOL_ALI_INT_FO_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA1_INT_FO_EOL_ALI_INT_FO_SHIFT))

#define  ANTIFLIN_WDMA1_INT_FO_EOI_ALI_INT_FO_MASK 0x8
#define  ANTIFLIN_WDMA1_INT_FO_EOI_ALI_INT_FO_SHIFT 3
#define  ANTIFLIN_WDMA1_INT_FO_EOI_ALI_INT_FO_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA1_INT_FO_EOI_ALI_INT_FO_MASK) >> ANTIFLIN_WDMA1_INT_FO_EOI_ALI_INT_FO_SHIFT)
#define  ANTIFLIN_WDMA1_INT_FO_EOI_ALI_INT_FO_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA1_INT_FO_EOI_ALI_INT_FO_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA1_INT_FO_EOI_ALI_INT_FO_SHIFT))

#define  ANTIFLIN_WDMA1_INT_FO_EOI_ERR_INT_FO_MASK 0x4
#define  ANTIFLIN_WDMA1_INT_FO_EOI_ERR_INT_FO_SHIFT 2
#define  ANTIFLIN_WDMA1_INT_FO_EOI_ERR_INT_FO_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA1_INT_FO_EOI_ERR_INT_FO_MASK) >> ANTIFLIN_WDMA1_INT_FO_EOI_ERR_INT_FO_SHIFT)
#define  ANTIFLIN_WDMA1_INT_FO_EOI_ERR_INT_FO_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA1_INT_FO_EOI_ERR_INT_FO_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA1_INT_FO_EOI_ERR_INT_FO_SHIFT))

#define  ANTIFLIN_WDMA1_INT_FO_FIN_INT_FO_MASK 0x2
#define  ANTIFLIN_WDMA1_INT_FO_FIN_INT_FO_SHIFT 1
#define  ANTIFLIN_WDMA1_INT_FO_FIN_INT_FO_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA1_INT_FO_FIN_INT_FO_MASK) >> ANTIFLIN_WDMA1_INT_FO_FIN_INT_FO_SHIFT)
#define  ANTIFLIN_WDMA1_INT_FO_FIN_INT_FO_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA1_INT_FO_FIN_INT_FO_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA1_INT_FO_FIN_INT_FO_SHIFT))

#define  ANTIFLIN_WDMA1_INT_FO_WHO_INT_FO_MASK 0x1
#define  ANTIFLIN_WDMA1_INT_FO_WHO_INT_FO_SHIFT 0
#define  ANTIFLIN_WDMA1_INT_FO_WHO_INT_FO_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA1_INT_FO_WHO_INT_FO_MASK) >> ANTIFLIN_WDMA1_INT_FO_WHO_INT_FO_SHIFT)
#define  ANTIFLIN_WDMA1_INT_FO_WHO_INT_FO_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA1_INT_FO_WHO_INT_FO_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA1_INT_FO_WHO_INT_FO_SHIFT))

//====================================================================
//Register: Descriptor Write Register (desc_write)
//====================================================================

#define  ANTIFLIN_WDMA1_DESC_WRITE_DESC_MASK 0xfffffffc
#define  ANTIFLIN_WDMA1_DESC_WRITE_DESC_SHIFT 2
#define  ANTIFLIN_WDMA1_DESC_WRITE_DESC_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA1_DESC_WRITE_DESC_MASK) >> ANTIFLIN_WDMA1_DESC_WRITE_DESC_SHIFT)
#define  ANTIFLIN_WDMA1_DESC_WRITE_DESC_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA1_DESC_WRITE_DESC_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA1_DESC_WRITE_DESC_SHIFT))

#define  ANTIFLIN_WDMA1_DESC_WRITE_RESERVED1_MASK 0x3
#define  ANTIFLIN_WDMA1_DESC_WRITE_RESERVED1_SHIFT 0
#define  ANTIFLIN_WDMA1_DESC_WRITE_RESERVED1_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA1_DESC_WRITE_RESERVED1_MASK) >> ANTIFLIN_WDMA1_DESC_WRITE_RESERVED1_SHIFT)
#define  ANTIFLIN_WDMA1_DESC_WRITE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA1_DESC_WRITE_RESERVED1_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA1_DESC_WRITE_RESERVED1_SHIFT))

//====================================================================
//Register: Descriptor Read Register (desc_read)
//====================================================================

#define  ANTIFLIN_WDMA1_DESC_READ_DESC_MASK 0xffffffff
#define  ANTIFLIN_WDMA1_DESC_READ_DESC_SHIFT 0
#define  ANTIFLIN_WDMA1_DESC_READ_DESC_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA1_DESC_READ_DESC_MASK) >> ANTIFLIN_WDMA1_DESC_READ_DESC_SHIFT)
#define  ANTIFLIN_WDMA1_DESC_READ_DESC_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA1_DESC_READ_DESC_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA1_DESC_READ_DESC_SHIFT))

//====================================================================
//Register: Descriptor Transfer Length Register (xfer_length)
//====================================================================

#define  ANTIFLIN_WDMA1_XFER_LENGTH_LEN_MASK 0xffffffff
#define  ANTIFLIN_WDMA1_XFER_LENGTH_LEN_SHIFT 0
#define  ANTIFLIN_WDMA1_XFER_LENGTH_LEN_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA1_XFER_LENGTH_LEN_MASK) >> ANTIFLIN_WDMA1_XFER_LENGTH_LEN_SHIFT)
#define  ANTIFLIN_WDMA1_XFER_LENGTH_LEN_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA1_XFER_LENGTH_LEN_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA1_XFER_LENGTH_LEN_SHIFT))

//====================================================================
//Register: Descriptor Transfer Address Register (xfer_addr)
//====================================================================

#define  ANTIFLIN_WDMA1_XFER_ADDR_ADDR_MASK 0xffffffff
#define  ANTIFLIN_WDMA1_XFER_ADDR_ADDR_SHIFT 0
#define  ANTIFLIN_WDMA1_XFER_ADDR_ADDR_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA1_XFER_ADDR_ADDR_MASK) >> ANTIFLIN_WDMA1_XFER_ADDR_ADDR_SHIFT)
#define  ANTIFLIN_WDMA1_XFER_ADDR_ADDR_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA1_XFER_ADDR_ADDR_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA1_XFER_ADDR_ADDR_SHIFT))

//====================================================================
//Register: Descriptor Transfer Burst Register (xfer_burst)
//====================================================================

#define  ANTIFLIN_WDMA1_XFER_BURST_RESERVED1_MASK 0xffffffe0
#define  ANTIFLIN_WDMA1_XFER_BURST_RESERVED1_SHIFT 5
#define  ANTIFLIN_WDMA1_XFER_BURST_RESERVED1_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA1_XFER_BURST_RESERVED1_MASK) >> ANTIFLIN_WDMA1_XFER_BURST_RESERVED1_SHIFT)
#define  ANTIFLIN_WDMA1_XFER_BURST_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA1_XFER_BURST_RESERVED1_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA1_XFER_BURST_RESERVED1_SHIFT))

#define  ANTIFLIN_WDMA1_XFER_BURST_BURST_MASK 0x1f
#define  ANTIFLIN_WDMA1_XFER_BURST_BURST_SHIFT 0
#define  ANTIFLIN_WDMA1_XFER_BURST_BURST_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA1_XFER_BURST_BURST_MASK) >> ANTIFLIN_WDMA1_XFER_BURST_BURST_SHIFT)
#define  ANTIFLIN_WDMA1_XFER_BURST_BURST_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA1_XFER_BURST_BURST_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA1_XFER_BURST_BURST_SHIFT))

//====================================================================
//Register: Soft Reset register (reset)
//====================================================================

#define  ANTIFLIN_WDMA1_RESET_RESERVED1_MASK 0xfffffffc
#define  ANTIFLIN_WDMA1_RESET_RESERVED1_SHIFT 2
#define  ANTIFLIN_WDMA1_RESET_RESERVED1_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA1_RESET_RESERVED1_MASK) >> ANTIFLIN_WDMA1_RESET_RESERVED1_SHIFT)
#define  ANTIFLIN_WDMA1_RESET_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA1_RESET_RESERVED1_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA1_RESET_RESERVED1_SHIFT))

#define  ANTIFLIN_WDMA1_RESET_FORCE_LAST_BURST_MASK 0x2
#define  ANTIFLIN_WDMA1_RESET_FORCE_LAST_BURST_SHIFT 1
#define  ANTIFLIN_WDMA1_RESET_FORCE_LAST_BURST_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA1_RESET_FORCE_LAST_BURST_MASK) >> ANTIFLIN_WDMA1_RESET_FORCE_LAST_BURST_SHIFT)
#define  ANTIFLIN_WDMA1_RESET_FORCE_LAST_BURST_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA1_RESET_FORCE_LAST_BURST_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA1_RESET_FORCE_LAST_BURST_SHIFT))

#define  ANTIFLIN_WDMA1_RESET_SOFT_RESET_MASK 0x1
#define  ANTIFLIN_WDMA1_RESET_SOFT_RESET_SHIFT 0
#define  ANTIFLIN_WDMA1_RESET_SOFT_RESET_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA1_RESET_SOFT_RESET_MASK) >> ANTIFLIN_WDMA1_RESET_SOFT_RESET_SHIFT)
#define  ANTIFLIN_WDMA1_RESET_SOFT_RESET_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA1_RESET_SOFT_RESET_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA1_RESET_SOFT_RESET_SHIFT))

//====================================================================
//Register: IP Tagging Revision 0 (REV0)
/** \brief Provide means for firmware to read IP tagging information.
      This register of particular interest to firmware.*/
//====================================================================

#define  ANTIFLIN_WDMA1_REV0_MAJ_MASK 0xffff0000
#define  ANTIFLIN_WDMA1_REV0_MAJ_SHIFT 16
#define  ANTIFLIN_WDMA1_REV0_MAJ_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA1_REV0_MAJ_MASK) >> ANTIFLIN_WDMA1_REV0_MAJ_SHIFT)
#define  ANTIFLIN_WDMA1_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA1_REV0_MAJ_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA1_REV0_MAJ_SHIFT))

#define  ANTIFLIN_WDMA1_REV0_MID_MASK 0xffff
#define  ANTIFLIN_WDMA1_REV0_MID_SHIFT 0
#define  ANTIFLIN_WDMA1_REV0_MID_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA1_REV0_MID_MASK) >> ANTIFLIN_WDMA1_REV0_MID_SHIFT)
#define  ANTIFLIN_WDMA1_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA1_REV0_MID_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA1_REV0_MID_SHIFT))

//====================================================================
//Register: IP Tagging Revision 1 (REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  ANTIFLIN_WDMA1_REV1_RESERVED1_MASK 0xffff0000
#define  ANTIFLIN_WDMA1_REV1_RESERVED1_SHIFT 16
#define  ANTIFLIN_WDMA1_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA1_REV1_RESERVED1_MASK) >> ANTIFLIN_WDMA1_REV1_RESERVED1_SHIFT)
#define  ANTIFLIN_WDMA1_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA1_REV1_RESERVED1_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA1_REV1_RESERVED1_SHIFT))

#define  ANTIFLIN_WDMA1_REV1_CFG_MASK 0xffff
#define  ANTIFLIN_WDMA1_REV1_CFG_SHIFT 0
#define  ANTIFLIN_WDMA1_REV1_CFG_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA1_REV1_CFG_MASK) >> ANTIFLIN_WDMA1_REV1_CFG_SHIFT)
#define  ANTIFLIN_WDMA1_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA1_REV1_CFG_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA1_REV1_CFG_SHIFT))

//====================================================================
//
//Register File: AntiFlin ODMA Channel (Instance 3 of 3) (ANTIFLIN_WDMA2)
/** \brief Register Descriptions for the ODMA_AXI block (rev 0 . 4 . 3 . 1)*/
//
//====================================================================

//====================================================================
//Register: Configuration register (cfg)
//====================================================================

#define  ANTIFLIN_WDMA2_CFG_RESERVED1_MASK 0xfe000000
#define  ANTIFLIN_WDMA2_CFG_RESERVED1_SHIFT 25
#define  ANTIFLIN_WDMA2_CFG_RESERVED1_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA2_CFG_RESERVED1_MASK) >> ANTIFLIN_WDMA2_CFG_RESERVED1_SHIFT)
#define  ANTIFLIN_WDMA2_CFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA2_CFG_RESERVED1_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA2_CFG_RESERVED1_SHIFT))

#define  ANTIFLIN_WDMA2_CFG_HANDSHAKEENABLE_MASK 0x1000000
#define  ANTIFLIN_WDMA2_CFG_HANDSHAKEENABLE_SHIFT 24
#define  ANTIFLIN_WDMA2_CFG_HANDSHAKEENABLE_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA2_CFG_HANDSHAKEENABLE_MASK) >> ANTIFLIN_WDMA2_CFG_HANDSHAKEENABLE_SHIFT)
#define  ANTIFLIN_WDMA2_CFG_HANDSHAKEENABLE_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA2_CFG_HANDSHAKEENABLE_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA2_CFG_HANDSHAKEENABLE_SHIFT))

#define  ANTIFLIN_WDMA2_CFG_OWNPOLARITY_MASK 0x800000
#define  ANTIFLIN_WDMA2_CFG_OWNPOLARITY_SHIFT 23
#define  ANTIFLIN_WDMA2_CFG_OWNPOLARITY_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA2_CFG_OWNPOLARITY_MASK) >> ANTIFLIN_WDMA2_CFG_OWNPOLARITY_SHIFT)
#define  ANTIFLIN_WDMA2_CFG_OWNPOLARITY_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA2_CFG_OWNPOLARITY_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA2_CFG_OWNPOLARITY_SHIFT))

#define  ANTIFLIN_WDMA2_CFG_OWNWRITEDISABLE_MASK 0x400000
#define  ANTIFLIN_WDMA2_CFG_OWNWRITEDISABLE_SHIFT 22
#define  ANTIFLIN_WDMA2_CFG_OWNWRITEDISABLE_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA2_CFG_OWNWRITEDISABLE_MASK) >> ANTIFLIN_WDMA2_CFG_OWNWRITEDISABLE_SHIFT)
#define  ANTIFLIN_WDMA2_CFG_OWNWRITEDISABLE_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA2_CFG_OWNWRITEDISABLE_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA2_CFG_OWNWRITEDISABLE_SHIFT))

#define  ANTIFLIN_WDMA2_CFG_SERPENTINE_MASK 0x200000
#define  ANTIFLIN_WDMA2_CFG_SERPENTINE_SHIFT 21
#define  ANTIFLIN_WDMA2_CFG_SERPENTINE_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA2_CFG_SERPENTINE_MASK) >> ANTIFLIN_WDMA2_CFG_SERPENTINE_SHIFT)
#define  ANTIFLIN_WDMA2_CFG_SERPENTINE_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA2_CFG_SERPENTINE_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA2_CFG_SERPENTINE_SHIFT))

#define  ANTIFLIN_WDMA2_CFG_LINE_REV_MASK 0x100000
#define  ANTIFLIN_WDMA2_CFG_LINE_REV_SHIFT 20
#define  ANTIFLIN_WDMA2_CFG_LINE_REV_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA2_CFG_LINE_REV_MASK) >> ANTIFLIN_WDMA2_CFG_LINE_REV_SHIFT)
#define  ANTIFLIN_WDMA2_CFG_LINE_REV_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA2_CFG_LINE_REV_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA2_CFG_LINE_REV_SHIFT))

#define  ANTIFLIN_WDMA2_CFG_TRAN_REV_MASK 0x80000
#define  ANTIFLIN_WDMA2_CFG_TRAN_REV_SHIFT 19
#define  ANTIFLIN_WDMA2_CFG_TRAN_REV_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA2_CFG_TRAN_REV_MASK) >> ANTIFLIN_WDMA2_CFG_TRAN_REV_SHIFT)
#define  ANTIFLIN_WDMA2_CFG_TRAN_REV_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA2_CFG_TRAN_REV_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA2_CFG_TRAN_REV_SHIFT))

#define  ANTIFLIN_WDMA2_CFG_UPPER_HALF_MASK 0x40000
#define  ANTIFLIN_WDMA2_CFG_UPPER_HALF_SHIFT 18
#define  ANTIFLIN_WDMA2_CFG_UPPER_HALF_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA2_CFG_UPPER_HALF_MASK) >> ANTIFLIN_WDMA2_CFG_UPPER_HALF_SHIFT)
#define  ANTIFLIN_WDMA2_CFG_UPPER_HALF_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA2_CFG_UPPER_HALF_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA2_CFG_UPPER_HALF_SHIFT))

#define  ANTIFLIN_WDMA2_CFG_MSB_IN_MASK 0x20000
#define  ANTIFLIN_WDMA2_CFG_MSB_IN_SHIFT 17
#define  ANTIFLIN_WDMA2_CFG_MSB_IN_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA2_CFG_MSB_IN_MASK) >> ANTIFLIN_WDMA2_CFG_MSB_IN_SHIFT)
#define  ANTIFLIN_WDMA2_CFG_MSB_IN_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA2_CFG_MSB_IN_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA2_CFG_MSB_IN_SHIFT))

#define  ANTIFLIN_WDMA2_CFG_ENABLE_MASK 0x10000
#define  ANTIFLIN_WDMA2_CFG_ENABLE_SHIFT 16
#define  ANTIFLIN_WDMA2_CFG_ENABLE_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA2_CFG_ENABLE_MASK) >> ANTIFLIN_WDMA2_CFG_ENABLE_SHIFT)
#define  ANTIFLIN_WDMA2_CFG_ENABLE_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA2_CFG_ENABLE_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA2_CFG_ENABLE_SHIFT))

#define  ANTIFLIN_WDMA2_CFG_RESERVED2_MASK 0xf800
#define  ANTIFLIN_WDMA2_CFG_RESERVED2_SHIFT 11
#define  ANTIFLIN_WDMA2_CFG_RESERVED2_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA2_CFG_RESERVED2_MASK) >> ANTIFLIN_WDMA2_CFG_RESERVED2_SHIFT)
#define  ANTIFLIN_WDMA2_CFG_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA2_CFG_RESERVED2_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA2_CFG_RESERVED2_SHIFT))

#define  ANTIFLIN_WDMA2_CFG_IN_WIDTH_MASK 0x700
#define  ANTIFLIN_WDMA2_CFG_IN_WIDTH_SHIFT 8
#define  ANTIFLIN_WDMA2_CFG_IN_WIDTH_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA2_CFG_IN_WIDTH_MASK) >> ANTIFLIN_WDMA2_CFG_IN_WIDTH_SHIFT)
#define  ANTIFLIN_WDMA2_CFG_IN_WIDTH_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA2_CFG_IN_WIDTH_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA2_CFG_IN_WIDTH_SHIFT))

#define  ANTIFLIN_WDMA2_CFG_RESERVED3_MASK 0xfc
#define  ANTIFLIN_WDMA2_CFG_RESERVED3_SHIFT 2
#define  ANTIFLIN_WDMA2_CFG_RESERVED3_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA2_CFG_RESERVED3_MASK) >> ANTIFLIN_WDMA2_CFG_RESERVED3_SHIFT)
#define  ANTIFLIN_WDMA2_CFG_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA2_CFG_RESERVED3_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA2_CFG_RESERVED3_SHIFT))

#define  ANTIFLIN_WDMA2_CFG_BURST_LEN_MASK 0x3
#define  ANTIFLIN_WDMA2_CFG_BURST_LEN_SHIFT 0
#define  ANTIFLIN_WDMA2_CFG_BURST_LEN_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA2_CFG_BURST_LEN_MASK) >> ANTIFLIN_WDMA2_CFG_BURST_LEN_SHIFT)
#define  ANTIFLIN_WDMA2_CFG_BURST_LEN_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA2_CFG_BURST_LEN_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA2_CFG_BURST_LEN_SHIFT))

//====================================================================
//Register: Status register (status)
//====================================================================

#define  ANTIFLIN_WDMA2_STATUS_RESERVED1_MASK 0xff000000
#define  ANTIFLIN_WDMA2_STATUS_RESERVED1_SHIFT 24
#define  ANTIFLIN_WDMA2_STATUS_RESERVED1_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA2_STATUS_RESERVED1_MASK) >> ANTIFLIN_WDMA2_STATUS_RESERVED1_SHIFT)
#define  ANTIFLIN_WDMA2_STATUS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA2_STATUS_RESERVED1_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA2_STATUS_RESERVED1_SHIFT))

#define  ANTIFLIN_WDMA2_STATUS_BYTESWAITING_MASK 0xff0000
#define  ANTIFLIN_WDMA2_STATUS_BYTESWAITING_SHIFT 16
#define  ANTIFLIN_WDMA2_STATUS_BYTESWAITING_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA2_STATUS_BYTESWAITING_MASK) >> ANTIFLIN_WDMA2_STATUS_BYTESWAITING_SHIFT)
#define  ANTIFLIN_WDMA2_STATUS_BYTESWAITING_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA2_STATUS_BYTESWAITING_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA2_STATUS_BYTESWAITING_SHIFT))

#define  ANTIFLIN_WDMA2_STATUS_RESERVED2_MASK 0x8000
#define  ANTIFLIN_WDMA2_STATUS_RESERVED2_SHIFT 15
#define  ANTIFLIN_WDMA2_STATUS_RESERVED2_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA2_STATUS_RESERVED2_MASK) >> ANTIFLIN_WDMA2_STATUS_RESERVED2_SHIFT)
#define  ANTIFLIN_WDMA2_STATUS_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA2_STATUS_RESERVED2_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA2_STATUS_RESERVED2_SHIFT))

#define  ANTIFLIN_WDMA2_STATUS_FORCE_BURST_BUSY_MASK 0x4000
#define  ANTIFLIN_WDMA2_STATUS_FORCE_BURST_BUSY_SHIFT 14
#define  ANTIFLIN_WDMA2_STATUS_FORCE_BURST_BUSY_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA2_STATUS_FORCE_BURST_BUSY_MASK) >> ANTIFLIN_WDMA2_STATUS_FORCE_BURST_BUSY_SHIFT)
#define  ANTIFLIN_WDMA2_STATUS_FORCE_BURST_BUSY_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA2_STATUS_FORCE_BURST_BUSY_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA2_STATUS_FORCE_BURST_BUSY_SHIFT))

#define  ANTIFLIN_WDMA2_STATUS_DMAPAUSED_MASK 0x2000
#define  ANTIFLIN_WDMA2_STATUS_DMAPAUSED_SHIFT 13
#define  ANTIFLIN_WDMA2_STATUS_DMAPAUSED_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA2_STATUS_DMAPAUSED_MASK) >> ANTIFLIN_WDMA2_STATUS_DMAPAUSED_SHIFT)
#define  ANTIFLIN_WDMA2_STATUS_DMAPAUSED_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA2_STATUS_DMAPAUSED_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA2_STATUS_DMAPAUSED_SHIFT))

#define  ANTIFLIN_WDMA2_STATUS_PAUSEAFTER_MASK 0x1000
#define  ANTIFLIN_WDMA2_STATUS_PAUSEAFTER_SHIFT 12
#define  ANTIFLIN_WDMA2_STATUS_PAUSEAFTER_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA2_STATUS_PAUSEAFTER_MASK) >> ANTIFLIN_WDMA2_STATUS_PAUSEAFTER_SHIFT)
#define  ANTIFLIN_WDMA2_STATUS_PAUSEAFTER_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA2_STATUS_PAUSEAFTER_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA2_STATUS_PAUSEAFTER_SHIFT))

#define  ANTIFLIN_WDMA2_STATUS_PAUSEBEFORE_MASK 0x800
#define  ANTIFLIN_WDMA2_STATUS_PAUSEBEFORE_SHIFT 11
#define  ANTIFLIN_WDMA2_STATUS_PAUSEBEFORE_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA2_STATUS_PAUSEBEFORE_MASK) >> ANTIFLIN_WDMA2_STATUS_PAUSEBEFORE_SHIFT)
#define  ANTIFLIN_WDMA2_STATUS_PAUSEBEFORE_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA2_STATUS_PAUSEBEFORE_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA2_STATUS_PAUSEBEFORE_SHIFT))

#define  ANTIFLIN_WDMA2_STATUS_DESC_OWN_MASK 0x400
#define  ANTIFLIN_WDMA2_STATUS_DESC_OWN_SHIFT 10
#define  ANTIFLIN_WDMA2_STATUS_DESC_OWN_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA2_STATUS_DESC_OWN_MASK) >> ANTIFLIN_WDMA2_STATUS_DESC_OWN_SHIFT)
#define  ANTIFLIN_WDMA2_STATUS_DESC_OWN_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA2_STATUS_DESC_OWN_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA2_STATUS_DESC_OWN_SHIFT))

#define  ANTIFLIN_WDMA2_STATUS_DESC_EOI_MASK 0x200
#define  ANTIFLIN_WDMA2_STATUS_DESC_EOI_SHIFT 9
#define  ANTIFLIN_WDMA2_STATUS_DESC_EOI_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA2_STATUS_DESC_EOI_MASK) >> ANTIFLIN_WDMA2_STATUS_DESC_EOI_SHIFT)
#define  ANTIFLIN_WDMA2_STATUS_DESC_EOI_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA2_STATUS_DESC_EOI_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA2_STATUS_DESC_EOI_SHIFT))

#define  ANTIFLIN_WDMA2_STATUS_DESC_SOI_MASK 0x100
#define  ANTIFLIN_WDMA2_STATUS_DESC_SOI_SHIFT 8
#define  ANTIFLIN_WDMA2_STATUS_DESC_SOI_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA2_STATUS_DESC_SOI_MASK) >> ANTIFLIN_WDMA2_STATUS_DESC_SOI_SHIFT)
#define  ANTIFLIN_WDMA2_STATUS_DESC_SOI_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA2_STATUS_DESC_SOI_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA2_STATUS_DESC_SOI_SHIFT))

#define  ANTIFLIN_WDMA2_STATUS_REVERSE_MASK 0x80
#define  ANTIFLIN_WDMA2_STATUS_REVERSE_SHIFT 7
#define  ANTIFLIN_WDMA2_STATUS_REVERSE_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA2_STATUS_REVERSE_MASK) >> ANTIFLIN_WDMA2_STATUS_REVERSE_SHIFT)
#define  ANTIFLIN_WDMA2_STATUS_REVERSE_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA2_STATUS_REVERSE_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA2_STATUS_REVERSE_SHIFT))

#define  ANTIFLIN_WDMA2_STATUS_SOFTRESET_MASK 0x40
#define  ANTIFLIN_WDMA2_STATUS_SOFTRESET_SHIFT 6
#define  ANTIFLIN_WDMA2_STATUS_SOFTRESET_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA2_STATUS_SOFTRESET_MASK) >> ANTIFLIN_WDMA2_STATUS_SOFTRESET_SHIFT)
#define  ANTIFLIN_WDMA2_STATUS_SOFTRESET_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA2_STATUS_SOFTRESET_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA2_STATUS_SOFTRESET_SHIFT))

#define  ANTIFLIN_WDMA2_STATUS_FULL_CBUF_MASK 0x20
#define  ANTIFLIN_WDMA2_STATUS_FULL_CBUF_SHIFT 5
#define  ANTIFLIN_WDMA2_STATUS_FULL_CBUF_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA2_STATUS_FULL_CBUF_MASK) >> ANTIFLIN_WDMA2_STATUS_FULL_CBUF_SHIFT)
#define  ANTIFLIN_WDMA2_STATUS_FULL_CBUF_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA2_STATUS_FULL_CBUF_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA2_STATUS_FULL_CBUF_SHIFT))

#define  ANTIFLIN_WDMA2_STATUS_EMPTY_CBUF_MASK 0x10
#define  ANTIFLIN_WDMA2_STATUS_EMPTY_CBUF_SHIFT 4
#define  ANTIFLIN_WDMA2_STATUS_EMPTY_CBUF_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA2_STATUS_EMPTY_CBUF_MASK) >> ANTIFLIN_WDMA2_STATUS_EMPTY_CBUF_SHIFT)
#define  ANTIFLIN_WDMA2_STATUS_EMPTY_CBUF_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA2_STATUS_EMPTY_CBUF_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA2_STATUS_EMPTY_CBUF_SHIFT))

#define  ANTIFLIN_WDMA2_STATUS_FULL_DBUF_MASK 0x8
#define  ANTIFLIN_WDMA2_STATUS_FULL_DBUF_SHIFT 3
#define  ANTIFLIN_WDMA2_STATUS_FULL_DBUF_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA2_STATUS_FULL_DBUF_MASK) >> ANTIFLIN_WDMA2_STATUS_FULL_DBUF_SHIFT)
#define  ANTIFLIN_WDMA2_STATUS_FULL_DBUF_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA2_STATUS_FULL_DBUF_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA2_STATUS_FULL_DBUF_SHIFT))

#define  ANTIFLIN_WDMA2_STATUS_EMPTY_DBUF_MASK 0x4
#define  ANTIFLIN_WDMA2_STATUS_EMPTY_DBUF_SHIFT 2
#define  ANTIFLIN_WDMA2_STATUS_EMPTY_DBUF_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA2_STATUS_EMPTY_DBUF_MASK) >> ANTIFLIN_WDMA2_STATUS_EMPTY_DBUF_SHIFT)
#define  ANTIFLIN_WDMA2_STATUS_EMPTY_DBUF_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA2_STATUS_EMPTY_DBUF_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA2_STATUS_EMPTY_DBUF_SHIFT))

#define  ANTIFLIN_WDMA2_STATUS_PACKER_EMPTY_MASK 0x2
#define  ANTIFLIN_WDMA2_STATUS_PACKER_EMPTY_SHIFT 1
#define  ANTIFLIN_WDMA2_STATUS_PACKER_EMPTY_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA2_STATUS_PACKER_EMPTY_MASK) >> ANTIFLIN_WDMA2_STATUS_PACKER_EMPTY_SHIFT)
#define  ANTIFLIN_WDMA2_STATUS_PACKER_EMPTY_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA2_STATUS_PACKER_EMPTY_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA2_STATUS_PACKER_EMPTY_SHIFT))

#define  ANTIFLIN_WDMA2_STATUS_DMA_BUSY_MASK 0x1
#define  ANTIFLIN_WDMA2_STATUS_DMA_BUSY_SHIFT 0
#define  ANTIFLIN_WDMA2_STATUS_DMA_BUSY_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA2_STATUS_DMA_BUSY_MASK) >> ANTIFLIN_WDMA2_STATUS_DMA_BUSY_SHIFT)
#define  ANTIFLIN_WDMA2_STATUS_DMA_BUSY_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA2_STATUS_DMA_BUSY_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA2_STATUS_DMA_BUSY_SHIFT))

//====================================================================
//Register: Line Size Register (line_size)
//====================================================================

#define  ANTIFLIN_WDMA2_LINE_SIZE_RESERVED1_MASK 0xfffc0000
#define  ANTIFLIN_WDMA2_LINE_SIZE_RESERVED1_SHIFT 18
#define  ANTIFLIN_WDMA2_LINE_SIZE_RESERVED1_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA2_LINE_SIZE_RESERVED1_MASK) >> ANTIFLIN_WDMA2_LINE_SIZE_RESERVED1_SHIFT)
#define  ANTIFLIN_WDMA2_LINE_SIZE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA2_LINE_SIZE_RESERVED1_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA2_LINE_SIZE_RESERVED1_SHIFT))

#define  ANTIFLIN_WDMA2_LINE_SIZE_LINE_SIZE_MASK 0x3ffff
#define  ANTIFLIN_WDMA2_LINE_SIZE_LINE_SIZE_SHIFT 0
#define  ANTIFLIN_WDMA2_LINE_SIZE_LINE_SIZE_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA2_LINE_SIZE_LINE_SIZE_MASK) >> ANTIFLIN_WDMA2_LINE_SIZE_LINE_SIZE_SHIFT)
#define  ANTIFLIN_WDMA2_LINE_SIZE_LINE_SIZE_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA2_LINE_SIZE_LINE_SIZE_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA2_LINE_SIZE_LINE_SIZE_SHIFT))

//====================================================================
//Register: Interrupt Enable Register (int_en)
//====================================================================

#define  ANTIFLIN_WDMA2_INT_EN_RESERVED1_MASK 0xfffff800
#define  ANTIFLIN_WDMA2_INT_EN_RESERVED1_SHIFT 11
#define  ANTIFLIN_WDMA2_INT_EN_RESERVED1_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA2_INT_EN_RESERVED1_MASK) >> ANTIFLIN_WDMA2_INT_EN_RESERVED1_SHIFT)
#define  ANTIFLIN_WDMA2_INT_EN_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA2_INT_EN_RESERVED1_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA2_INT_EN_RESERVED1_SHIFT))

#define  ANTIFLIN_WDMA2_INT_EN_RRESP_INT_EN_MASK 0x400
#define  ANTIFLIN_WDMA2_INT_EN_RRESP_INT_EN_SHIFT 10
#define  ANTIFLIN_WDMA2_INT_EN_RRESP_INT_EN_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA2_INT_EN_RRESP_INT_EN_MASK) >> ANTIFLIN_WDMA2_INT_EN_RRESP_INT_EN_SHIFT)
#define  ANTIFLIN_WDMA2_INT_EN_RRESP_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA2_INT_EN_RRESP_INT_EN_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA2_INT_EN_RRESP_INT_EN_SHIFT))

#define  ANTIFLIN_WDMA2_INT_EN_BRESP_INT_EN_MASK 0x200
#define  ANTIFLIN_WDMA2_INT_EN_BRESP_INT_EN_SHIFT 9
#define  ANTIFLIN_WDMA2_INT_EN_BRESP_INT_EN_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA2_INT_EN_BRESP_INT_EN_MASK) >> ANTIFLIN_WDMA2_INT_EN_BRESP_INT_EN_SHIFT)
#define  ANTIFLIN_WDMA2_INT_EN_BRESP_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA2_INT_EN_BRESP_INT_EN_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA2_INT_EN_BRESP_INT_EN_SHIFT))

#define  ANTIFLIN_WDMA2_INT_EN_RST_INT_EN_MASK 0x100
#define  ANTIFLIN_WDMA2_INT_EN_RST_INT_EN_SHIFT 8
#define  ANTIFLIN_WDMA2_INT_EN_RST_INT_EN_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA2_INT_EN_RST_INT_EN_MASK) >> ANTIFLIN_WDMA2_INT_EN_RST_INT_EN_SHIFT)
#define  ANTIFLIN_WDMA2_INT_EN_RST_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA2_INT_EN_RST_INT_EN_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA2_INT_EN_RST_INT_EN_SHIFT))

#define  ANTIFLIN_WDMA2_INT_EN_EOI_INT_EN_MASK 0x80
#define  ANTIFLIN_WDMA2_INT_EN_EOI_INT_EN_SHIFT 7
#define  ANTIFLIN_WDMA2_INT_EN_EOI_INT_EN_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA2_INT_EN_EOI_INT_EN_MASK) >> ANTIFLIN_WDMA2_INT_EN_EOI_INT_EN_SHIFT)
#define  ANTIFLIN_WDMA2_INT_EN_EOI_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA2_INT_EN_EOI_INT_EN_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA2_INT_EN_EOI_INT_EN_SHIFT))

#define  ANTIFLIN_WDMA2_INT_EN_DIR_INT_EN_MASK 0x40
#define  ANTIFLIN_WDMA2_INT_EN_DIR_INT_EN_SHIFT 6
#define  ANTIFLIN_WDMA2_INT_EN_DIR_INT_EN_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA2_INT_EN_DIR_INT_EN_MASK) >> ANTIFLIN_WDMA2_INT_EN_DIR_INT_EN_SHIFT)
#define  ANTIFLIN_WDMA2_INT_EN_DIR_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA2_INT_EN_DIR_INT_EN_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA2_INT_EN_DIR_INT_EN_SHIFT))

#define  ANTIFLIN_WDMA2_INT_EN_CL_ALI_INT_EN_MASK 0x20
#define  ANTIFLIN_WDMA2_INT_EN_CL_ALI_INT_EN_SHIFT 5
#define  ANTIFLIN_WDMA2_INT_EN_CL_ALI_INT_EN_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA2_INT_EN_CL_ALI_INT_EN_MASK) >> ANTIFLIN_WDMA2_INT_EN_CL_ALI_INT_EN_SHIFT)
#define  ANTIFLIN_WDMA2_INT_EN_CL_ALI_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA2_INT_EN_CL_ALI_INT_EN_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA2_INT_EN_CL_ALI_INT_EN_SHIFT))

#define  ANTIFLIN_WDMA2_INT_EN_EOL_ALI_INT_EN_MASK 0x10
#define  ANTIFLIN_WDMA2_INT_EN_EOL_ALI_INT_EN_SHIFT 4
#define  ANTIFLIN_WDMA2_INT_EN_EOL_ALI_INT_EN_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA2_INT_EN_EOL_ALI_INT_EN_MASK) >> ANTIFLIN_WDMA2_INT_EN_EOL_ALI_INT_EN_SHIFT)
#define  ANTIFLIN_WDMA2_INT_EN_EOL_ALI_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA2_INT_EN_EOL_ALI_INT_EN_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA2_INT_EN_EOL_ALI_INT_EN_SHIFT))

#define  ANTIFLIN_WDMA2_INT_EN_EOI_ALI_INT_EN_MASK 0x8
#define  ANTIFLIN_WDMA2_INT_EN_EOI_ALI_INT_EN_SHIFT 3
#define  ANTIFLIN_WDMA2_INT_EN_EOI_ALI_INT_EN_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA2_INT_EN_EOI_ALI_INT_EN_MASK) >> ANTIFLIN_WDMA2_INT_EN_EOI_ALI_INT_EN_SHIFT)
#define  ANTIFLIN_WDMA2_INT_EN_EOI_ALI_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA2_INT_EN_EOI_ALI_INT_EN_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA2_INT_EN_EOI_ALI_INT_EN_SHIFT))

#define  ANTIFLIN_WDMA2_INT_EN_EOI_ERR_INT_EN_MASK 0x4
#define  ANTIFLIN_WDMA2_INT_EN_EOI_ERR_INT_EN_SHIFT 2
#define  ANTIFLIN_WDMA2_INT_EN_EOI_ERR_INT_EN_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA2_INT_EN_EOI_ERR_INT_EN_MASK) >> ANTIFLIN_WDMA2_INT_EN_EOI_ERR_INT_EN_SHIFT)
#define  ANTIFLIN_WDMA2_INT_EN_EOI_ERR_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA2_INT_EN_EOI_ERR_INT_EN_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA2_INT_EN_EOI_ERR_INT_EN_SHIFT))

#define  ANTIFLIN_WDMA2_INT_EN_FIN_INT_EN_MASK 0x2
#define  ANTIFLIN_WDMA2_INT_EN_FIN_INT_EN_SHIFT 1
#define  ANTIFLIN_WDMA2_INT_EN_FIN_INT_EN_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA2_INT_EN_FIN_INT_EN_MASK) >> ANTIFLIN_WDMA2_INT_EN_FIN_INT_EN_SHIFT)
#define  ANTIFLIN_WDMA2_INT_EN_FIN_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA2_INT_EN_FIN_INT_EN_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA2_INT_EN_FIN_INT_EN_SHIFT))

#define  ANTIFLIN_WDMA2_INT_EN_WHO_INT_EN_MASK 0x1
#define  ANTIFLIN_WDMA2_INT_EN_WHO_INT_EN_SHIFT 0
#define  ANTIFLIN_WDMA2_INT_EN_WHO_INT_EN_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA2_INT_EN_WHO_INT_EN_MASK) >> ANTIFLIN_WDMA2_INT_EN_WHO_INT_EN_SHIFT)
#define  ANTIFLIN_WDMA2_INT_EN_WHO_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA2_INT_EN_WHO_INT_EN_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA2_INT_EN_WHO_INT_EN_SHIFT))

//====================================================================
//Register: Interrupt Pending Register (int_pend)
//====================================================================

#define  ANTIFLIN_WDMA2_INT_PEND_RESERVED1_MASK 0xfffff800
#define  ANTIFLIN_WDMA2_INT_PEND_RESERVED1_SHIFT 11
#define  ANTIFLIN_WDMA2_INT_PEND_RESERVED1_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA2_INT_PEND_RESERVED1_MASK) >> ANTIFLIN_WDMA2_INT_PEND_RESERVED1_SHIFT)
#define  ANTIFLIN_WDMA2_INT_PEND_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA2_INT_PEND_RESERVED1_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA2_INT_PEND_RESERVED1_SHIFT))

#define  ANTIFLIN_WDMA2_INT_PEND_RRESP_INT_PEND_MASK 0x400
#define  ANTIFLIN_WDMA2_INT_PEND_RRESP_INT_PEND_SHIFT 10
#define  ANTIFLIN_WDMA2_INT_PEND_RRESP_INT_PEND_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA2_INT_PEND_RRESP_INT_PEND_MASK) >> ANTIFLIN_WDMA2_INT_PEND_RRESP_INT_PEND_SHIFT)
#define  ANTIFLIN_WDMA2_INT_PEND_RRESP_INT_PEND_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA2_INT_PEND_RRESP_INT_PEND_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA2_INT_PEND_RRESP_INT_PEND_SHIFT))

#define  ANTIFLIN_WDMA2_INT_PEND_BRESP_INT_PEND_MASK 0x200
#define  ANTIFLIN_WDMA2_INT_PEND_BRESP_INT_PEND_SHIFT 9
#define  ANTIFLIN_WDMA2_INT_PEND_BRESP_INT_PEND_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA2_INT_PEND_BRESP_INT_PEND_MASK) >> ANTIFLIN_WDMA2_INT_PEND_BRESP_INT_PEND_SHIFT)
#define  ANTIFLIN_WDMA2_INT_PEND_BRESP_INT_PEND_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA2_INT_PEND_BRESP_INT_PEND_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA2_INT_PEND_BRESP_INT_PEND_SHIFT))

#define  ANTIFLIN_WDMA2_INT_PEND_RST_INT_PEND_MASK 0x100
#define  ANTIFLIN_WDMA2_INT_PEND_RST_INT_PEND_SHIFT 8
#define  ANTIFLIN_WDMA2_INT_PEND_RST_INT_PEND_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA2_INT_PEND_RST_INT_PEND_MASK) >> ANTIFLIN_WDMA2_INT_PEND_RST_INT_PEND_SHIFT)
#define  ANTIFLIN_WDMA2_INT_PEND_RST_INT_PEND_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA2_INT_PEND_RST_INT_PEND_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA2_INT_PEND_RST_INT_PEND_SHIFT))

#define  ANTIFLIN_WDMA2_INT_PEND_EOI_INT_PEND_MASK 0x80
#define  ANTIFLIN_WDMA2_INT_PEND_EOI_INT_PEND_SHIFT 7
#define  ANTIFLIN_WDMA2_INT_PEND_EOI_INT_PEND_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA2_INT_PEND_EOI_INT_PEND_MASK) >> ANTIFLIN_WDMA2_INT_PEND_EOI_INT_PEND_SHIFT)
#define  ANTIFLIN_WDMA2_INT_PEND_EOI_INT_PEND_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA2_INT_PEND_EOI_INT_PEND_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA2_INT_PEND_EOI_INT_PEND_SHIFT))

#define  ANTIFLIN_WDMA2_INT_PEND_DIR_INT_PEND_MASK 0x40
#define  ANTIFLIN_WDMA2_INT_PEND_DIR_INT_PEND_SHIFT 6
#define  ANTIFLIN_WDMA2_INT_PEND_DIR_INT_PEND_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA2_INT_PEND_DIR_INT_PEND_MASK) >> ANTIFLIN_WDMA2_INT_PEND_DIR_INT_PEND_SHIFT)
#define  ANTIFLIN_WDMA2_INT_PEND_DIR_INT_PEND_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA2_INT_PEND_DIR_INT_PEND_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA2_INT_PEND_DIR_INT_PEND_SHIFT))

#define  ANTIFLIN_WDMA2_INT_PEND_CL_ALI_INT_PEND_MASK 0x20
#define  ANTIFLIN_WDMA2_INT_PEND_CL_ALI_INT_PEND_SHIFT 5
#define  ANTIFLIN_WDMA2_INT_PEND_CL_ALI_INT_PEND_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA2_INT_PEND_CL_ALI_INT_PEND_MASK) >> ANTIFLIN_WDMA2_INT_PEND_CL_ALI_INT_PEND_SHIFT)
#define  ANTIFLIN_WDMA2_INT_PEND_CL_ALI_INT_PEND_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA2_INT_PEND_CL_ALI_INT_PEND_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA2_INT_PEND_CL_ALI_INT_PEND_SHIFT))

#define  ANTIFLIN_WDMA2_INT_PEND_EOL_ALI_INT_PEND_MASK 0x10
#define  ANTIFLIN_WDMA2_INT_PEND_EOL_ALI_INT_PEND_SHIFT 4
#define  ANTIFLIN_WDMA2_INT_PEND_EOL_ALI_INT_PEND_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA2_INT_PEND_EOL_ALI_INT_PEND_MASK) >> ANTIFLIN_WDMA2_INT_PEND_EOL_ALI_INT_PEND_SHIFT)
#define  ANTIFLIN_WDMA2_INT_PEND_EOL_ALI_INT_PEND_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA2_INT_PEND_EOL_ALI_INT_PEND_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA2_INT_PEND_EOL_ALI_INT_PEND_SHIFT))

#define  ANTIFLIN_WDMA2_INT_PEND_EOI_ALI_INT_PEND_MASK 0x8
#define  ANTIFLIN_WDMA2_INT_PEND_EOI_ALI_INT_PEND_SHIFT 3
#define  ANTIFLIN_WDMA2_INT_PEND_EOI_ALI_INT_PEND_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA2_INT_PEND_EOI_ALI_INT_PEND_MASK) >> ANTIFLIN_WDMA2_INT_PEND_EOI_ALI_INT_PEND_SHIFT)
#define  ANTIFLIN_WDMA2_INT_PEND_EOI_ALI_INT_PEND_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA2_INT_PEND_EOI_ALI_INT_PEND_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA2_INT_PEND_EOI_ALI_INT_PEND_SHIFT))

#define  ANTIFLIN_WDMA2_INT_PEND_EOI_ERR_INT_PEND_MASK 0x4
#define  ANTIFLIN_WDMA2_INT_PEND_EOI_ERR_INT_PEND_SHIFT 2
#define  ANTIFLIN_WDMA2_INT_PEND_EOI_ERR_INT_PEND_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA2_INT_PEND_EOI_ERR_INT_PEND_MASK) >> ANTIFLIN_WDMA2_INT_PEND_EOI_ERR_INT_PEND_SHIFT)
#define  ANTIFLIN_WDMA2_INT_PEND_EOI_ERR_INT_PEND_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA2_INT_PEND_EOI_ERR_INT_PEND_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA2_INT_PEND_EOI_ERR_INT_PEND_SHIFT))

#define  ANTIFLIN_WDMA2_INT_PEND_FIN_INT_PEND_MASK 0x2
#define  ANTIFLIN_WDMA2_INT_PEND_FIN_INT_PEND_SHIFT 1
#define  ANTIFLIN_WDMA2_INT_PEND_FIN_INT_PEND_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA2_INT_PEND_FIN_INT_PEND_MASK) >> ANTIFLIN_WDMA2_INT_PEND_FIN_INT_PEND_SHIFT)
#define  ANTIFLIN_WDMA2_INT_PEND_FIN_INT_PEND_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA2_INT_PEND_FIN_INT_PEND_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA2_INT_PEND_FIN_INT_PEND_SHIFT))

#define  ANTIFLIN_WDMA2_INT_PEND_WHO_INT_PEND_MASK 0x1
#define  ANTIFLIN_WDMA2_INT_PEND_WHO_INT_PEND_SHIFT 0
#define  ANTIFLIN_WDMA2_INT_PEND_WHO_INT_PEND_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA2_INT_PEND_WHO_INT_PEND_MASK) >> ANTIFLIN_WDMA2_INT_PEND_WHO_INT_PEND_SHIFT)
#define  ANTIFLIN_WDMA2_INT_PEND_WHO_INT_PEND_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA2_INT_PEND_WHO_INT_PEND_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA2_INT_PEND_WHO_INT_PEND_SHIFT))

//====================================================================
//Register: Interrupt Acknowledge Register (int_ack)
//====================================================================

#define  ANTIFLIN_WDMA2_INT_ACK_RESERVED1_MASK 0xfffff800
#define  ANTIFLIN_WDMA2_INT_ACK_RESERVED1_SHIFT 11
#define  ANTIFLIN_WDMA2_INT_ACK_RESERVED1_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA2_INT_ACK_RESERVED1_MASK) >> ANTIFLIN_WDMA2_INT_ACK_RESERVED1_SHIFT)
#define  ANTIFLIN_WDMA2_INT_ACK_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA2_INT_ACK_RESERVED1_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA2_INT_ACK_RESERVED1_SHIFT))

#define  ANTIFLIN_WDMA2_INT_ACK_RRESP_INT_ACK_MASK 0x400
#define  ANTIFLIN_WDMA2_INT_ACK_RRESP_INT_ACK_SHIFT 10
#define  ANTIFLIN_WDMA2_INT_ACK_RRESP_INT_ACK_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA2_INT_ACK_RRESP_INT_ACK_MASK) >> ANTIFLIN_WDMA2_INT_ACK_RRESP_INT_ACK_SHIFT)
#define  ANTIFLIN_WDMA2_INT_ACK_RRESP_INT_ACK_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA2_INT_ACK_RRESP_INT_ACK_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA2_INT_ACK_RRESP_INT_ACK_SHIFT))

#define  ANTIFLIN_WDMA2_INT_ACK_BRESP_INT_ACK_MASK 0x200
#define  ANTIFLIN_WDMA2_INT_ACK_BRESP_INT_ACK_SHIFT 9
#define  ANTIFLIN_WDMA2_INT_ACK_BRESP_INT_ACK_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA2_INT_ACK_BRESP_INT_ACK_MASK) >> ANTIFLIN_WDMA2_INT_ACK_BRESP_INT_ACK_SHIFT)
#define  ANTIFLIN_WDMA2_INT_ACK_BRESP_INT_ACK_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA2_INT_ACK_BRESP_INT_ACK_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA2_INT_ACK_BRESP_INT_ACK_SHIFT))

#define  ANTIFLIN_WDMA2_INT_ACK_RST_INT_ACK_MASK 0x100
#define  ANTIFLIN_WDMA2_INT_ACK_RST_INT_ACK_SHIFT 8
#define  ANTIFLIN_WDMA2_INT_ACK_RST_INT_ACK_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA2_INT_ACK_RST_INT_ACK_MASK) >> ANTIFLIN_WDMA2_INT_ACK_RST_INT_ACK_SHIFT)
#define  ANTIFLIN_WDMA2_INT_ACK_RST_INT_ACK_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA2_INT_ACK_RST_INT_ACK_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA2_INT_ACK_RST_INT_ACK_SHIFT))

#define  ANTIFLIN_WDMA2_INT_ACK_EOI_INT_ACK_MASK 0x80
#define  ANTIFLIN_WDMA2_INT_ACK_EOI_INT_ACK_SHIFT 7
#define  ANTIFLIN_WDMA2_INT_ACK_EOI_INT_ACK_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA2_INT_ACK_EOI_INT_ACK_MASK) >> ANTIFLIN_WDMA2_INT_ACK_EOI_INT_ACK_SHIFT)
#define  ANTIFLIN_WDMA2_INT_ACK_EOI_INT_ACK_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA2_INT_ACK_EOI_INT_ACK_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA2_INT_ACK_EOI_INT_ACK_SHIFT))

#define  ANTIFLIN_WDMA2_INT_ACK_DIR_INT_ACK_MASK 0x40
#define  ANTIFLIN_WDMA2_INT_ACK_DIR_INT_ACK_SHIFT 6
#define  ANTIFLIN_WDMA2_INT_ACK_DIR_INT_ACK_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA2_INT_ACK_DIR_INT_ACK_MASK) >> ANTIFLIN_WDMA2_INT_ACK_DIR_INT_ACK_SHIFT)
#define  ANTIFLIN_WDMA2_INT_ACK_DIR_INT_ACK_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA2_INT_ACK_DIR_INT_ACK_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA2_INT_ACK_DIR_INT_ACK_SHIFT))

#define  ANTIFLIN_WDMA2_INT_ACK_CL_ALI_INT_ACK_MASK 0x20
#define  ANTIFLIN_WDMA2_INT_ACK_CL_ALI_INT_ACK_SHIFT 5
#define  ANTIFLIN_WDMA2_INT_ACK_CL_ALI_INT_ACK_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA2_INT_ACK_CL_ALI_INT_ACK_MASK) >> ANTIFLIN_WDMA2_INT_ACK_CL_ALI_INT_ACK_SHIFT)
#define  ANTIFLIN_WDMA2_INT_ACK_CL_ALI_INT_ACK_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA2_INT_ACK_CL_ALI_INT_ACK_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA2_INT_ACK_CL_ALI_INT_ACK_SHIFT))

#define  ANTIFLIN_WDMA2_INT_ACK_EOL_ALI_INT_ACK_MASK 0x10
#define  ANTIFLIN_WDMA2_INT_ACK_EOL_ALI_INT_ACK_SHIFT 4
#define  ANTIFLIN_WDMA2_INT_ACK_EOL_ALI_INT_ACK_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA2_INT_ACK_EOL_ALI_INT_ACK_MASK) >> ANTIFLIN_WDMA2_INT_ACK_EOL_ALI_INT_ACK_SHIFT)
#define  ANTIFLIN_WDMA2_INT_ACK_EOL_ALI_INT_ACK_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA2_INT_ACK_EOL_ALI_INT_ACK_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA2_INT_ACK_EOL_ALI_INT_ACK_SHIFT))

#define  ANTIFLIN_WDMA2_INT_ACK_EOI_ALI_INT_ACK_MASK 0x8
#define  ANTIFLIN_WDMA2_INT_ACK_EOI_ALI_INT_ACK_SHIFT 3
#define  ANTIFLIN_WDMA2_INT_ACK_EOI_ALI_INT_ACK_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA2_INT_ACK_EOI_ALI_INT_ACK_MASK) >> ANTIFLIN_WDMA2_INT_ACK_EOI_ALI_INT_ACK_SHIFT)
#define  ANTIFLIN_WDMA2_INT_ACK_EOI_ALI_INT_ACK_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA2_INT_ACK_EOI_ALI_INT_ACK_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA2_INT_ACK_EOI_ALI_INT_ACK_SHIFT))

#define  ANTIFLIN_WDMA2_INT_ACK_EOI_ERR_INT_ACK_MASK 0x4
#define  ANTIFLIN_WDMA2_INT_ACK_EOI_ERR_INT_ACK_SHIFT 2
#define  ANTIFLIN_WDMA2_INT_ACK_EOI_ERR_INT_ACK_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA2_INT_ACK_EOI_ERR_INT_ACK_MASK) >> ANTIFLIN_WDMA2_INT_ACK_EOI_ERR_INT_ACK_SHIFT)
#define  ANTIFLIN_WDMA2_INT_ACK_EOI_ERR_INT_ACK_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA2_INT_ACK_EOI_ERR_INT_ACK_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA2_INT_ACK_EOI_ERR_INT_ACK_SHIFT))

#define  ANTIFLIN_WDMA2_INT_ACK_FIN_INT_ACK_MASK 0x2
#define  ANTIFLIN_WDMA2_INT_ACK_FIN_INT_ACK_SHIFT 1
#define  ANTIFLIN_WDMA2_INT_ACK_FIN_INT_ACK_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA2_INT_ACK_FIN_INT_ACK_MASK) >> ANTIFLIN_WDMA2_INT_ACK_FIN_INT_ACK_SHIFT)
#define  ANTIFLIN_WDMA2_INT_ACK_FIN_INT_ACK_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA2_INT_ACK_FIN_INT_ACK_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA2_INT_ACK_FIN_INT_ACK_SHIFT))

#define  ANTIFLIN_WDMA2_INT_ACK_WHO_INT_ACK_MASK 0x1
#define  ANTIFLIN_WDMA2_INT_ACK_WHO_INT_ACK_SHIFT 0
#define  ANTIFLIN_WDMA2_INT_ACK_WHO_INT_ACK_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA2_INT_ACK_WHO_INT_ACK_MASK) >> ANTIFLIN_WDMA2_INT_ACK_WHO_INT_ACK_SHIFT)
#define  ANTIFLIN_WDMA2_INT_ACK_WHO_INT_ACK_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA2_INT_ACK_WHO_INT_ACK_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA2_INT_ACK_WHO_INT_ACK_SHIFT))

//====================================================================
//Register: Interrupt Force Register (int_fo)
//====================================================================

#define  ANTIFLIN_WDMA2_INT_FO_RESERVED1_MASK 0xfffff800
#define  ANTIFLIN_WDMA2_INT_FO_RESERVED1_SHIFT 11
#define  ANTIFLIN_WDMA2_INT_FO_RESERVED1_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA2_INT_FO_RESERVED1_MASK) >> ANTIFLIN_WDMA2_INT_FO_RESERVED1_SHIFT)
#define  ANTIFLIN_WDMA2_INT_FO_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA2_INT_FO_RESERVED1_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA2_INT_FO_RESERVED1_SHIFT))

#define  ANTIFLIN_WDMA2_INT_FO_RRESP_INT_FO_MASK 0x400
#define  ANTIFLIN_WDMA2_INT_FO_RRESP_INT_FO_SHIFT 10
#define  ANTIFLIN_WDMA2_INT_FO_RRESP_INT_FO_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA2_INT_FO_RRESP_INT_FO_MASK) >> ANTIFLIN_WDMA2_INT_FO_RRESP_INT_FO_SHIFT)
#define  ANTIFLIN_WDMA2_INT_FO_RRESP_INT_FO_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA2_INT_FO_RRESP_INT_FO_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA2_INT_FO_RRESP_INT_FO_SHIFT))

#define  ANTIFLIN_WDMA2_INT_FO_BRESP_INT_FO_MASK 0x200
#define  ANTIFLIN_WDMA2_INT_FO_BRESP_INT_FO_SHIFT 9
#define  ANTIFLIN_WDMA2_INT_FO_BRESP_INT_FO_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA2_INT_FO_BRESP_INT_FO_MASK) >> ANTIFLIN_WDMA2_INT_FO_BRESP_INT_FO_SHIFT)
#define  ANTIFLIN_WDMA2_INT_FO_BRESP_INT_FO_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA2_INT_FO_BRESP_INT_FO_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA2_INT_FO_BRESP_INT_FO_SHIFT))

#define  ANTIFLIN_WDMA2_INT_FO_RST_INT_FO_MASK 0x100
#define  ANTIFLIN_WDMA2_INT_FO_RST_INT_FO_SHIFT 8
#define  ANTIFLIN_WDMA2_INT_FO_RST_INT_FO_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA2_INT_FO_RST_INT_FO_MASK) >> ANTIFLIN_WDMA2_INT_FO_RST_INT_FO_SHIFT)
#define  ANTIFLIN_WDMA2_INT_FO_RST_INT_FO_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA2_INT_FO_RST_INT_FO_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA2_INT_FO_RST_INT_FO_SHIFT))

#define  ANTIFLIN_WDMA2_INT_FO_EOI_INT_FO_MASK 0x80
#define  ANTIFLIN_WDMA2_INT_FO_EOI_INT_FO_SHIFT 7
#define  ANTIFLIN_WDMA2_INT_FO_EOI_INT_FO_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA2_INT_FO_EOI_INT_FO_MASK) >> ANTIFLIN_WDMA2_INT_FO_EOI_INT_FO_SHIFT)
#define  ANTIFLIN_WDMA2_INT_FO_EOI_INT_FO_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA2_INT_FO_EOI_INT_FO_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA2_INT_FO_EOI_INT_FO_SHIFT))

#define  ANTIFLIN_WDMA2_INT_FO_DIR_INT_FO_MASK 0x40
#define  ANTIFLIN_WDMA2_INT_FO_DIR_INT_FO_SHIFT 6
#define  ANTIFLIN_WDMA2_INT_FO_DIR_INT_FO_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA2_INT_FO_DIR_INT_FO_MASK) >> ANTIFLIN_WDMA2_INT_FO_DIR_INT_FO_SHIFT)
#define  ANTIFLIN_WDMA2_INT_FO_DIR_INT_FO_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA2_INT_FO_DIR_INT_FO_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA2_INT_FO_DIR_INT_FO_SHIFT))

#define  ANTIFLIN_WDMA2_INT_FO_CL_ALI_INT_FO_MASK 0x20
#define  ANTIFLIN_WDMA2_INT_FO_CL_ALI_INT_FO_SHIFT 5
#define  ANTIFLIN_WDMA2_INT_FO_CL_ALI_INT_FO_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA2_INT_FO_CL_ALI_INT_FO_MASK) >> ANTIFLIN_WDMA2_INT_FO_CL_ALI_INT_FO_SHIFT)
#define  ANTIFLIN_WDMA2_INT_FO_CL_ALI_INT_FO_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA2_INT_FO_CL_ALI_INT_FO_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA2_INT_FO_CL_ALI_INT_FO_SHIFT))

#define  ANTIFLIN_WDMA2_INT_FO_EOL_ALI_INT_FO_MASK 0x10
#define  ANTIFLIN_WDMA2_INT_FO_EOL_ALI_INT_FO_SHIFT 4
#define  ANTIFLIN_WDMA2_INT_FO_EOL_ALI_INT_FO_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA2_INT_FO_EOL_ALI_INT_FO_MASK) >> ANTIFLIN_WDMA2_INT_FO_EOL_ALI_INT_FO_SHIFT)
#define  ANTIFLIN_WDMA2_INT_FO_EOL_ALI_INT_FO_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA2_INT_FO_EOL_ALI_INT_FO_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA2_INT_FO_EOL_ALI_INT_FO_SHIFT))

#define  ANTIFLIN_WDMA2_INT_FO_EOI_ALI_INT_FO_MASK 0x8
#define  ANTIFLIN_WDMA2_INT_FO_EOI_ALI_INT_FO_SHIFT 3
#define  ANTIFLIN_WDMA2_INT_FO_EOI_ALI_INT_FO_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA2_INT_FO_EOI_ALI_INT_FO_MASK) >> ANTIFLIN_WDMA2_INT_FO_EOI_ALI_INT_FO_SHIFT)
#define  ANTIFLIN_WDMA2_INT_FO_EOI_ALI_INT_FO_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA2_INT_FO_EOI_ALI_INT_FO_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA2_INT_FO_EOI_ALI_INT_FO_SHIFT))

#define  ANTIFLIN_WDMA2_INT_FO_EOI_ERR_INT_FO_MASK 0x4
#define  ANTIFLIN_WDMA2_INT_FO_EOI_ERR_INT_FO_SHIFT 2
#define  ANTIFLIN_WDMA2_INT_FO_EOI_ERR_INT_FO_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA2_INT_FO_EOI_ERR_INT_FO_MASK) >> ANTIFLIN_WDMA2_INT_FO_EOI_ERR_INT_FO_SHIFT)
#define  ANTIFLIN_WDMA2_INT_FO_EOI_ERR_INT_FO_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA2_INT_FO_EOI_ERR_INT_FO_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA2_INT_FO_EOI_ERR_INT_FO_SHIFT))

#define  ANTIFLIN_WDMA2_INT_FO_FIN_INT_FO_MASK 0x2
#define  ANTIFLIN_WDMA2_INT_FO_FIN_INT_FO_SHIFT 1
#define  ANTIFLIN_WDMA2_INT_FO_FIN_INT_FO_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA2_INT_FO_FIN_INT_FO_MASK) >> ANTIFLIN_WDMA2_INT_FO_FIN_INT_FO_SHIFT)
#define  ANTIFLIN_WDMA2_INT_FO_FIN_INT_FO_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA2_INT_FO_FIN_INT_FO_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA2_INT_FO_FIN_INT_FO_SHIFT))

#define  ANTIFLIN_WDMA2_INT_FO_WHO_INT_FO_MASK 0x1
#define  ANTIFLIN_WDMA2_INT_FO_WHO_INT_FO_SHIFT 0
#define  ANTIFLIN_WDMA2_INT_FO_WHO_INT_FO_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA2_INT_FO_WHO_INT_FO_MASK) >> ANTIFLIN_WDMA2_INT_FO_WHO_INT_FO_SHIFT)
#define  ANTIFLIN_WDMA2_INT_FO_WHO_INT_FO_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA2_INT_FO_WHO_INT_FO_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA2_INT_FO_WHO_INT_FO_SHIFT))

//====================================================================
//Register: Descriptor Write Register (desc_write)
//====================================================================

#define  ANTIFLIN_WDMA2_DESC_WRITE_DESC_MASK 0xfffffffc
#define  ANTIFLIN_WDMA2_DESC_WRITE_DESC_SHIFT 2
#define  ANTIFLIN_WDMA2_DESC_WRITE_DESC_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA2_DESC_WRITE_DESC_MASK) >> ANTIFLIN_WDMA2_DESC_WRITE_DESC_SHIFT)
#define  ANTIFLIN_WDMA2_DESC_WRITE_DESC_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA2_DESC_WRITE_DESC_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA2_DESC_WRITE_DESC_SHIFT))

#define  ANTIFLIN_WDMA2_DESC_WRITE_RESERVED1_MASK 0x3
#define  ANTIFLIN_WDMA2_DESC_WRITE_RESERVED1_SHIFT 0
#define  ANTIFLIN_WDMA2_DESC_WRITE_RESERVED1_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA2_DESC_WRITE_RESERVED1_MASK) >> ANTIFLIN_WDMA2_DESC_WRITE_RESERVED1_SHIFT)
#define  ANTIFLIN_WDMA2_DESC_WRITE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA2_DESC_WRITE_RESERVED1_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA2_DESC_WRITE_RESERVED1_SHIFT))

//====================================================================
//Register: Descriptor Read Register (desc_read)
//====================================================================

#define  ANTIFLIN_WDMA2_DESC_READ_DESC_MASK 0xffffffff
#define  ANTIFLIN_WDMA2_DESC_READ_DESC_SHIFT 0
#define  ANTIFLIN_WDMA2_DESC_READ_DESC_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA2_DESC_READ_DESC_MASK) >> ANTIFLIN_WDMA2_DESC_READ_DESC_SHIFT)
#define  ANTIFLIN_WDMA2_DESC_READ_DESC_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA2_DESC_READ_DESC_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA2_DESC_READ_DESC_SHIFT))

//====================================================================
//Register: Descriptor Transfer Length Register (xfer_length)
//====================================================================

#define  ANTIFLIN_WDMA2_XFER_LENGTH_LEN_MASK 0xffffffff
#define  ANTIFLIN_WDMA2_XFER_LENGTH_LEN_SHIFT 0
#define  ANTIFLIN_WDMA2_XFER_LENGTH_LEN_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA2_XFER_LENGTH_LEN_MASK) >> ANTIFLIN_WDMA2_XFER_LENGTH_LEN_SHIFT)
#define  ANTIFLIN_WDMA2_XFER_LENGTH_LEN_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA2_XFER_LENGTH_LEN_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA2_XFER_LENGTH_LEN_SHIFT))

//====================================================================
//Register: Descriptor Transfer Address Register (xfer_addr)
//====================================================================

#define  ANTIFLIN_WDMA2_XFER_ADDR_ADDR_MASK 0xffffffff
#define  ANTIFLIN_WDMA2_XFER_ADDR_ADDR_SHIFT 0
#define  ANTIFLIN_WDMA2_XFER_ADDR_ADDR_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA2_XFER_ADDR_ADDR_MASK) >> ANTIFLIN_WDMA2_XFER_ADDR_ADDR_SHIFT)
#define  ANTIFLIN_WDMA2_XFER_ADDR_ADDR_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA2_XFER_ADDR_ADDR_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA2_XFER_ADDR_ADDR_SHIFT))

//====================================================================
//Register: Descriptor Transfer Burst Register (xfer_burst)
//====================================================================

#define  ANTIFLIN_WDMA2_XFER_BURST_RESERVED1_MASK 0xffffffe0
#define  ANTIFLIN_WDMA2_XFER_BURST_RESERVED1_SHIFT 5
#define  ANTIFLIN_WDMA2_XFER_BURST_RESERVED1_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA2_XFER_BURST_RESERVED1_MASK) >> ANTIFLIN_WDMA2_XFER_BURST_RESERVED1_SHIFT)
#define  ANTIFLIN_WDMA2_XFER_BURST_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA2_XFER_BURST_RESERVED1_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA2_XFER_BURST_RESERVED1_SHIFT))

#define  ANTIFLIN_WDMA2_XFER_BURST_BURST_MASK 0x1f
#define  ANTIFLIN_WDMA2_XFER_BURST_BURST_SHIFT 0
#define  ANTIFLIN_WDMA2_XFER_BURST_BURST_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA2_XFER_BURST_BURST_MASK) >> ANTIFLIN_WDMA2_XFER_BURST_BURST_SHIFT)
#define  ANTIFLIN_WDMA2_XFER_BURST_BURST_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA2_XFER_BURST_BURST_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA2_XFER_BURST_BURST_SHIFT))

//====================================================================
//Register: Soft Reset register (reset)
//====================================================================

#define  ANTIFLIN_WDMA2_RESET_RESERVED1_MASK 0xfffffffc
#define  ANTIFLIN_WDMA2_RESET_RESERVED1_SHIFT 2
#define  ANTIFLIN_WDMA2_RESET_RESERVED1_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA2_RESET_RESERVED1_MASK) >> ANTIFLIN_WDMA2_RESET_RESERVED1_SHIFT)
#define  ANTIFLIN_WDMA2_RESET_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA2_RESET_RESERVED1_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA2_RESET_RESERVED1_SHIFT))

#define  ANTIFLIN_WDMA2_RESET_FORCE_LAST_BURST_MASK 0x2
#define  ANTIFLIN_WDMA2_RESET_FORCE_LAST_BURST_SHIFT 1
#define  ANTIFLIN_WDMA2_RESET_FORCE_LAST_BURST_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA2_RESET_FORCE_LAST_BURST_MASK) >> ANTIFLIN_WDMA2_RESET_FORCE_LAST_BURST_SHIFT)
#define  ANTIFLIN_WDMA2_RESET_FORCE_LAST_BURST_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA2_RESET_FORCE_LAST_BURST_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA2_RESET_FORCE_LAST_BURST_SHIFT))

#define  ANTIFLIN_WDMA2_RESET_SOFT_RESET_MASK 0x1
#define  ANTIFLIN_WDMA2_RESET_SOFT_RESET_SHIFT 0
#define  ANTIFLIN_WDMA2_RESET_SOFT_RESET_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA2_RESET_SOFT_RESET_MASK) >> ANTIFLIN_WDMA2_RESET_SOFT_RESET_SHIFT)
#define  ANTIFLIN_WDMA2_RESET_SOFT_RESET_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA2_RESET_SOFT_RESET_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA2_RESET_SOFT_RESET_SHIFT))

//====================================================================
//Register: IP Tagging Revision 0 (REV0)
/** \brief Provide means for firmware to read IP tagging information.
      This register of particular interest to firmware.*/
//====================================================================

#define  ANTIFLIN_WDMA2_REV0_MAJ_MASK 0xffff0000
#define  ANTIFLIN_WDMA2_REV0_MAJ_SHIFT 16
#define  ANTIFLIN_WDMA2_REV0_MAJ_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA2_REV0_MAJ_MASK) >> ANTIFLIN_WDMA2_REV0_MAJ_SHIFT)
#define  ANTIFLIN_WDMA2_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA2_REV0_MAJ_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA2_REV0_MAJ_SHIFT))

#define  ANTIFLIN_WDMA2_REV0_MID_MASK 0xffff
#define  ANTIFLIN_WDMA2_REV0_MID_SHIFT 0
#define  ANTIFLIN_WDMA2_REV0_MID_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA2_REV0_MID_MASK) >> ANTIFLIN_WDMA2_REV0_MID_SHIFT)
#define  ANTIFLIN_WDMA2_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA2_REV0_MID_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA2_REV0_MID_SHIFT))

//====================================================================
//Register: IP Tagging Revision 1 (REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  ANTIFLIN_WDMA2_REV1_RESERVED1_MASK 0xffff0000
#define  ANTIFLIN_WDMA2_REV1_RESERVED1_SHIFT 16
#define  ANTIFLIN_WDMA2_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA2_REV1_RESERVED1_MASK) >> ANTIFLIN_WDMA2_REV1_RESERVED1_SHIFT)
#define  ANTIFLIN_WDMA2_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA2_REV1_RESERVED1_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA2_REV1_RESERVED1_SHIFT))

#define  ANTIFLIN_WDMA2_REV1_CFG_MASK 0xffff
#define  ANTIFLIN_WDMA2_REV1_CFG_SHIFT 0
#define  ANTIFLIN_WDMA2_REV1_CFG_MASK_SHIFT(reg) (((reg) & ANTIFLIN_WDMA2_REV1_CFG_MASK) >> ANTIFLIN_WDMA2_REV1_CFG_SHIFT)
#define  ANTIFLIN_WDMA2_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~ANTIFLIN_WDMA2_REV1_CFG_MASK) | (((uint32_t)val) << ANTIFLIN_WDMA2_REV1_CFG_SHIFT))

//====================================================================
//
//Register File: PIC Bit Depth Reduction (BitReduct)
/** \brief Register Descriptions for the PIC BitReduct block (rev 0 . 2 . 2 . 5)*/
//
//====================================================================

//====================================================================
//Register: BDR Look Up Table (BDRLUT)
/** \brief The LUT, look up table, is used for the "LUT method" of bit depth reduction, and is implemented using a SRAM and a flop register as explained below. Firmware (processor) can read/write entries of the LUT SRAM/register only when the Enable CPU Access bit of the BDR Configuration Register (BDRCR.CPU bit) is set to 1. <br>
In bit depth reduction mode, hardware will access the LUT for two values: LUT(addr) and LUT(addr+1). The LUT size is 1025entries X 8bits, address input is 10bits, and data output is 8bits. The reason for 1025 entries is: 2^10=1024 entries for addr={0,1,...,1023}, and one additional entry for addr+1=1023+1=1024. The LUT implementation consists of <br>
"	SRAM: 1024entries X 8bits, dual-ported for concurrent lookup of LUT(addr) and LUT(addr+1) <br>
"	Flip-flop Register: 1entry x 8bits, specifically for lookup of (addr+1)=1024. <br>
Note that the processor view of the LUT is 1025 registers, word addressed. For example, the CPU address to LUT entry0 is Base+0x0000_0000, and the address to LUT entry1 is Base+0x0000_0004, and the address to LUT entry1024 is Base+0x0000_1000.*/
//====================================================================

#define  BITREDUCT_BDRLUT_RESERVED1_MASK 0xffffff00
#define  BITREDUCT_BDRLUT_RESERVED1_SHIFT 8
#define  BITREDUCT_BDRLUT_RESERVED1_MASK_SHIFT(reg) (((reg) & BITREDUCT_BDRLUT_RESERVED1_MASK) >> BITREDUCT_BDRLUT_RESERVED1_SHIFT)
#define  BITREDUCT_BDRLUT_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~BITREDUCT_BDRLUT_RESERVED1_MASK) | (((uint32_t)val) << BITREDUCT_BDRLUT_RESERVED1_SHIFT))

#define  BITREDUCT_BDRLUT_VAL_MASK 0xff
#define  BITREDUCT_BDRLUT_VAL_SHIFT 0
#define  BITREDUCT_BDRLUT_VAL_MASK_SHIFT(reg) (((reg) & BITREDUCT_BDRLUT_VAL_MASK) >> BITREDUCT_BDRLUT_VAL_SHIFT)
#define  BITREDUCT_BDRLUT_VAL_REPLACE_VAL(reg,val) (((reg) & ~BITREDUCT_BDRLUT_VAL_MASK) | (((uint32_t)val) << BITREDUCT_BDRLUT_VAL_SHIFT))

//====================================================================
//Register: BDR Look Up Table Register (BDRLUTR)
/** \brief Flip-flop Register: 1entry x 8bits, specifically for lookup of (addr+1)=1024*/
//====================================================================

#define  BITREDUCT_BDRLUTR_RESERVED1_MASK 0xffffff00
#define  BITREDUCT_BDRLUTR_RESERVED1_SHIFT 8
#define  BITREDUCT_BDRLUTR_RESERVED1_MASK_SHIFT(reg) (((reg) & BITREDUCT_BDRLUTR_RESERVED1_MASK) >> BITREDUCT_BDRLUTR_RESERVED1_SHIFT)
#define  BITREDUCT_BDRLUTR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~BITREDUCT_BDRLUTR_RESERVED1_MASK) | (((uint32_t)val) << BITREDUCT_BDRLUTR_RESERVED1_SHIFT))

#define  BITREDUCT_BDRLUTR_VAL_MASK 0xff
#define  BITREDUCT_BDRLUTR_VAL_SHIFT 0
#define  BITREDUCT_BDRLUTR_VAL_MASK_SHIFT(reg) (((reg) & BITREDUCT_BDRLUTR_VAL_MASK) >> BITREDUCT_BDRLUTR_VAL_SHIFT)
#define  BITREDUCT_BDRLUTR_VAL_REPLACE_VAL(reg,val) (((reg) & ~BITREDUCT_BDRLUTR_VAL_MASK) | (((uint32_t)val) << BITREDUCT_BDRLUTR_VAL_SHIFT))

//====================================================================
//Register: BDR Configuration Register (BDRCR)
/** \brief General configuration register for BitReduct block. (rev 0 . 2 . 0 . 4)*/
//====================================================================

#define  BITREDUCT_BDRCR_RESERVED1_MASK 0xffffff80
#define  BITREDUCT_BDRCR_RESERVED1_SHIFT 7
#define  BITREDUCT_BDRCR_RESERVED1_MASK_SHIFT(reg) (((reg) & BITREDUCT_BDRCR_RESERVED1_MASK) >> BITREDUCT_BDRCR_RESERVED1_SHIFT)
#define  BITREDUCT_BDRCR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~BITREDUCT_BDRCR_RESERVED1_MASK) | (((uint32_t)val) << BITREDUCT_BDRCR_RESERVED1_SHIFT))

#define  BITREDUCT_BDRCR_NUMLUTS_MASK 0x40
#define  BITREDUCT_BDRCR_NUMLUTS_SHIFT 6
#define  BITREDUCT_BDRCR_NUMLUTS_MASK_SHIFT(reg) (((reg) & BITREDUCT_BDRCR_NUMLUTS_MASK) >> BITREDUCT_BDRCR_NUMLUTS_SHIFT)
#define  BITREDUCT_BDRCR_NUMLUTS_REPLACE_VAL(reg,val) (((reg) & ~BITREDUCT_BDRCR_NUMLUTS_MASK) | (((uint32_t)val) << BITREDUCT_BDRCR_NUMLUTS_SHIFT))

#define  BITREDUCT_BDRCR_LUTSEL_MASK 0x30
#define  BITREDUCT_BDRCR_LUTSEL_SHIFT 4
#define  BITREDUCT_BDRCR_LUTSEL_MASK_SHIFT(reg) (((reg) & BITREDUCT_BDRCR_LUTSEL_MASK) >> BITREDUCT_BDRCR_LUTSEL_SHIFT)
#define  BITREDUCT_BDRCR_LUTSEL_REPLACE_VAL(reg,val) (((reg) & ~BITREDUCT_BDRCR_LUTSEL_MASK) | (((uint32_t)val) << BITREDUCT_BDRCR_LUTSEL_SHIFT))

#define  BITREDUCT_BDRCR_RESERVED2_MASK 0xc
#define  BITREDUCT_BDRCR_RESERVED2_SHIFT 2
#define  BITREDUCT_BDRCR_RESERVED2_MASK_SHIFT(reg) (((reg) & BITREDUCT_BDRCR_RESERVED2_MASK) >> BITREDUCT_BDRCR_RESERVED2_SHIFT)
#define  BITREDUCT_BDRCR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~BITREDUCT_BDRCR_RESERVED2_MASK) | (((uint32_t)val) << BITREDUCT_BDRCR_RESERVED2_SHIFT))

#define  BITREDUCT_BDRCR_CPU_MASK 0x2
#define  BITREDUCT_BDRCR_CPU_SHIFT 1
#define  BITREDUCT_BDRCR_CPU_MASK_SHIFT(reg) (((reg) & BITREDUCT_BDRCR_CPU_MASK) >> BITREDUCT_BDRCR_CPU_SHIFT)
#define  BITREDUCT_BDRCR_CPU_REPLACE_VAL(reg,val) (((reg) & ~BITREDUCT_BDRCR_CPU_MASK) | (((uint32_t)val) << BITREDUCT_BDRCR_CPU_SHIFT))

#define  BITREDUCT_BDRCR_BYPASS_MASK 0x1
#define  BITREDUCT_BDRCR_BYPASS_SHIFT 0
#define  BITREDUCT_BDRCR_BYPASS_MASK_SHIFT(reg) (((reg) & BITREDUCT_BDRCR_BYPASS_MASK) >> BITREDUCT_BDRCR_BYPASS_SHIFT)
#define  BITREDUCT_BDRCR_BYPASS_REPLACE_VAL(reg,val) (((reg) & ~BITREDUCT_BDRCR_BYPASS_MASK) | (((uint32_t)val) << BITREDUCT_BDRCR_BYPASS_SHIFT))

//====================================================================
//Register: IP Tagging Revision 0 (REV0)
/** \brief Provide means for firmware to read IP tagging information.
      This register of particular interest to firmware.*/
//====================================================================

#define  BITREDUCT_REV0_MAJ_MASK 0xffff0000
#define  BITREDUCT_REV0_MAJ_SHIFT 16
#define  BITREDUCT_REV0_MAJ_MASK_SHIFT(reg) (((reg) & BITREDUCT_REV0_MAJ_MASK) >> BITREDUCT_REV0_MAJ_SHIFT)
#define  BITREDUCT_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~BITREDUCT_REV0_MAJ_MASK) | (((uint32_t)val) << BITREDUCT_REV0_MAJ_SHIFT))

#define  BITREDUCT_REV0_MID_MASK 0xffff
#define  BITREDUCT_REV0_MID_SHIFT 0
#define  BITREDUCT_REV0_MID_MASK_SHIFT(reg) (((reg) & BITREDUCT_REV0_MID_MASK) >> BITREDUCT_REV0_MID_SHIFT)
#define  BITREDUCT_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~BITREDUCT_REV0_MID_MASK) | (((uint32_t)val) << BITREDUCT_REV0_MID_SHIFT))

//====================================================================
//Register: IP Tagging Revision 1 (REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  BITREDUCT_REV1_RESERVED1_MASK 0xffff0000
#define  BITREDUCT_REV1_RESERVED1_SHIFT 16
#define  BITREDUCT_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & BITREDUCT_REV1_RESERVED1_MASK) >> BITREDUCT_REV1_RESERVED1_SHIFT)
#define  BITREDUCT_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~BITREDUCT_REV1_RESERVED1_MASK) | (((uint32_t)val) << BITREDUCT_REV1_RESERVED1_SHIFT))

#define  BITREDUCT_REV1_CFG_MASK 0xffff
#define  BITREDUCT_REV1_CFG_SHIFT 0
#define  BITREDUCT_REV1_CFG_MASK_SHIFT(reg) (((reg) & BITREDUCT_REV1_CFG_MASK) >> BITREDUCT_REV1_CFG_SHIFT)
#define  BITREDUCT_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~BITREDUCT_REV1_CFG_MASK) | (((uint32_t)val) << BITREDUCT_REV1_CFG_SHIFT))

//====================================================================
//
//Register File: DMA channel (Instance 1 of 3) (PIC_WDMA_DMA0)
/** \brief Register Descriptions for the ODMA_AXI block (rev 0 . 4 . 3 . 1)*/
//
//====================================================================

//====================================================================
//Register: Configuration register (cfg)
//====================================================================

#define  PIC_WDMA_DMA0_CFG_RESERVED1_MASK 0xfe000000
#define  PIC_WDMA_DMA0_CFG_RESERVED1_SHIFT 25
#define  PIC_WDMA_DMA0_CFG_RESERVED1_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA0_CFG_RESERVED1_MASK) >> PIC_WDMA_DMA0_CFG_RESERVED1_SHIFT)
#define  PIC_WDMA_DMA0_CFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA0_CFG_RESERVED1_MASK) | (((uint32_t)val) << PIC_WDMA_DMA0_CFG_RESERVED1_SHIFT))

#define  PIC_WDMA_DMA0_CFG_HANDSHAKEENABLE_MASK 0x1000000
#define  PIC_WDMA_DMA0_CFG_HANDSHAKEENABLE_SHIFT 24
#define  PIC_WDMA_DMA0_CFG_HANDSHAKEENABLE_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA0_CFG_HANDSHAKEENABLE_MASK) >> PIC_WDMA_DMA0_CFG_HANDSHAKEENABLE_SHIFT)
#define  PIC_WDMA_DMA0_CFG_HANDSHAKEENABLE_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA0_CFG_HANDSHAKEENABLE_MASK) | (((uint32_t)val) << PIC_WDMA_DMA0_CFG_HANDSHAKEENABLE_SHIFT))

#define  PIC_WDMA_DMA0_CFG_OWNPOLARITY_MASK 0x800000
#define  PIC_WDMA_DMA0_CFG_OWNPOLARITY_SHIFT 23
#define  PIC_WDMA_DMA0_CFG_OWNPOLARITY_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA0_CFG_OWNPOLARITY_MASK) >> PIC_WDMA_DMA0_CFG_OWNPOLARITY_SHIFT)
#define  PIC_WDMA_DMA0_CFG_OWNPOLARITY_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA0_CFG_OWNPOLARITY_MASK) | (((uint32_t)val) << PIC_WDMA_DMA0_CFG_OWNPOLARITY_SHIFT))

#define  PIC_WDMA_DMA0_CFG_OWNWRITEDISABLE_MASK 0x400000
#define  PIC_WDMA_DMA0_CFG_OWNWRITEDISABLE_SHIFT 22
#define  PIC_WDMA_DMA0_CFG_OWNWRITEDISABLE_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA0_CFG_OWNWRITEDISABLE_MASK) >> PIC_WDMA_DMA0_CFG_OWNWRITEDISABLE_SHIFT)
#define  PIC_WDMA_DMA0_CFG_OWNWRITEDISABLE_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA0_CFG_OWNWRITEDISABLE_MASK) | (((uint32_t)val) << PIC_WDMA_DMA0_CFG_OWNWRITEDISABLE_SHIFT))

#define  PIC_WDMA_DMA0_CFG_SERPENTINE_MASK 0x200000
#define  PIC_WDMA_DMA0_CFG_SERPENTINE_SHIFT 21
#define  PIC_WDMA_DMA0_CFG_SERPENTINE_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA0_CFG_SERPENTINE_MASK) >> PIC_WDMA_DMA0_CFG_SERPENTINE_SHIFT)
#define  PIC_WDMA_DMA0_CFG_SERPENTINE_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA0_CFG_SERPENTINE_MASK) | (((uint32_t)val) << PIC_WDMA_DMA0_CFG_SERPENTINE_SHIFT))

#define  PIC_WDMA_DMA0_CFG_LINE_REV_MASK 0x100000
#define  PIC_WDMA_DMA0_CFG_LINE_REV_SHIFT 20
#define  PIC_WDMA_DMA0_CFG_LINE_REV_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA0_CFG_LINE_REV_MASK) >> PIC_WDMA_DMA0_CFG_LINE_REV_SHIFT)
#define  PIC_WDMA_DMA0_CFG_LINE_REV_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA0_CFG_LINE_REV_MASK) | (((uint32_t)val) << PIC_WDMA_DMA0_CFG_LINE_REV_SHIFT))

#define  PIC_WDMA_DMA0_CFG_TRAN_REV_MASK 0x80000
#define  PIC_WDMA_DMA0_CFG_TRAN_REV_SHIFT 19
#define  PIC_WDMA_DMA0_CFG_TRAN_REV_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA0_CFG_TRAN_REV_MASK) >> PIC_WDMA_DMA0_CFG_TRAN_REV_SHIFT)
#define  PIC_WDMA_DMA0_CFG_TRAN_REV_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA0_CFG_TRAN_REV_MASK) | (((uint32_t)val) << PIC_WDMA_DMA0_CFG_TRAN_REV_SHIFT))

#define  PIC_WDMA_DMA0_CFG_UPPER_HALF_MASK 0x40000
#define  PIC_WDMA_DMA0_CFG_UPPER_HALF_SHIFT 18
#define  PIC_WDMA_DMA0_CFG_UPPER_HALF_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA0_CFG_UPPER_HALF_MASK) >> PIC_WDMA_DMA0_CFG_UPPER_HALF_SHIFT)
#define  PIC_WDMA_DMA0_CFG_UPPER_HALF_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA0_CFG_UPPER_HALF_MASK) | (((uint32_t)val) << PIC_WDMA_DMA0_CFG_UPPER_HALF_SHIFT))

#define  PIC_WDMA_DMA0_CFG_MSB_IN_MASK 0x20000
#define  PIC_WDMA_DMA0_CFG_MSB_IN_SHIFT 17
#define  PIC_WDMA_DMA0_CFG_MSB_IN_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA0_CFG_MSB_IN_MASK) >> PIC_WDMA_DMA0_CFG_MSB_IN_SHIFT)
#define  PIC_WDMA_DMA0_CFG_MSB_IN_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA0_CFG_MSB_IN_MASK) | (((uint32_t)val) << PIC_WDMA_DMA0_CFG_MSB_IN_SHIFT))

#define  PIC_WDMA_DMA0_CFG_ENABLE_MASK 0x10000
#define  PIC_WDMA_DMA0_CFG_ENABLE_SHIFT 16
#define  PIC_WDMA_DMA0_CFG_ENABLE_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA0_CFG_ENABLE_MASK) >> PIC_WDMA_DMA0_CFG_ENABLE_SHIFT)
#define  PIC_WDMA_DMA0_CFG_ENABLE_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA0_CFG_ENABLE_MASK) | (((uint32_t)val) << PIC_WDMA_DMA0_CFG_ENABLE_SHIFT))

#define  PIC_WDMA_DMA0_CFG_RESERVED2_MASK 0xf800
#define  PIC_WDMA_DMA0_CFG_RESERVED2_SHIFT 11
#define  PIC_WDMA_DMA0_CFG_RESERVED2_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA0_CFG_RESERVED2_MASK) >> PIC_WDMA_DMA0_CFG_RESERVED2_SHIFT)
#define  PIC_WDMA_DMA0_CFG_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA0_CFG_RESERVED2_MASK) | (((uint32_t)val) << PIC_WDMA_DMA0_CFG_RESERVED2_SHIFT))

#define  PIC_WDMA_DMA0_CFG_IN_WIDTH_MASK 0x700
#define  PIC_WDMA_DMA0_CFG_IN_WIDTH_SHIFT 8
#define  PIC_WDMA_DMA0_CFG_IN_WIDTH_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA0_CFG_IN_WIDTH_MASK) >> PIC_WDMA_DMA0_CFG_IN_WIDTH_SHIFT)
#define  PIC_WDMA_DMA0_CFG_IN_WIDTH_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA0_CFG_IN_WIDTH_MASK) | (((uint32_t)val) << PIC_WDMA_DMA0_CFG_IN_WIDTH_SHIFT))

#define  PIC_WDMA_DMA0_CFG_RESERVED3_MASK 0xfc
#define  PIC_WDMA_DMA0_CFG_RESERVED3_SHIFT 2
#define  PIC_WDMA_DMA0_CFG_RESERVED3_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA0_CFG_RESERVED3_MASK) >> PIC_WDMA_DMA0_CFG_RESERVED3_SHIFT)
#define  PIC_WDMA_DMA0_CFG_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA0_CFG_RESERVED3_MASK) | (((uint32_t)val) << PIC_WDMA_DMA0_CFG_RESERVED3_SHIFT))

#define  PIC_WDMA_DMA0_CFG_BURST_LEN_MASK 0x3
#define  PIC_WDMA_DMA0_CFG_BURST_LEN_SHIFT 0
#define  PIC_WDMA_DMA0_CFG_BURST_LEN_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA0_CFG_BURST_LEN_MASK) >> PIC_WDMA_DMA0_CFG_BURST_LEN_SHIFT)
#define  PIC_WDMA_DMA0_CFG_BURST_LEN_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA0_CFG_BURST_LEN_MASK) | (((uint32_t)val) << PIC_WDMA_DMA0_CFG_BURST_LEN_SHIFT))

//====================================================================
//Register: Status register (status)
//====================================================================

#define  PIC_WDMA_DMA0_STATUS_RESERVED1_MASK 0xff000000
#define  PIC_WDMA_DMA0_STATUS_RESERVED1_SHIFT 24
#define  PIC_WDMA_DMA0_STATUS_RESERVED1_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA0_STATUS_RESERVED1_MASK) >> PIC_WDMA_DMA0_STATUS_RESERVED1_SHIFT)
#define  PIC_WDMA_DMA0_STATUS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA0_STATUS_RESERVED1_MASK) | (((uint32_t)val) << PIC_WDMA_DMA0_STATUS_RESERVED1_SHIFT))

#define  PIC_WDMA_DMA0_STATUS_BYTESWAITING_MASK 0xff0000
#define  PIC_WDMA_DMA0_STATUS_BYTESWAITING_SHIFT 16
#define  PIC_WDMA_DMA0_STATUS_BYTESWAITING_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA0_STATUS_BYTESWAITING_MASK) >> PIC_WDMA_DMA0_STATUS_BYTESWAITING_SHIFT)
#define  PIC_WDMA_DMA0_STATUS_BYTESWAITING_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA0_STATUS_BYTESWAITING_MASK) | (((uint32_t)val) << PIC_WDMA_DMA0_STATUS_BYTESWAITING_SHIFT))

#define  PIC_WDMA_DMA0_STATUS_RESERVED2_MASK 0x8000
#define  PIC_WDMA_DMA0_STATUS_RESERVED2_SHIFT 15
#define  PIC_WDMA_DMA0_STATUS_RESERVED2_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA0_STATUS_RESERVED2_MASK) >> PIC_WDMA_DMA0_STATUS_RESERVED2_SHIFT)
#define  PIC_WDMA_DMA0_STATUS_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA0_STATUS_RESERVED2_MASK) | (((uint32_t)val) << PIC_WDMA_DMA0_STATUS_RESERVED2_SHIFT))

#define  PIC_WDMA_DMA0_STATUS_FORCE_BURST_BUSY_MASK 0x4000
#define  PIC_WDMA_DMA0_STATUS_FORCE_BURST_BUSY_SHIFT 14
#define  PIC_WDMA_DMA0_STATUS_FORCE_BURST_BUSY_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA0_STATUS_FORCE_BURST_BUSY_MASK) >> PIC_WDMA_DMA0_STATUS_FORCE_BURST_BUSY_SHIFT)
#define  PIC_WDMA_DMA0_STATUS_FORCE_BURST_BUSY_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA0_STATUS_FORCE_BURST_BUSY_MASK) | (((uint32_t)val) << PIC_WDMA_DMA0_STATUS_FORCE_BURST_BUSY_SHIFT))

#define  PIC_WDMA_DMA0_STATUS_DMAPAUSED_MASK 0x2000
#define  PIC_WDMA_DMA0_STATUS_DMAPAUSED_SHIFT 13
#define  PIC_WDMA_DMA0_STATUS_DMAPAUSED_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA0_STATUS_DMAPAUSED_MASK) >> PIC_WDMA_DMA0_STATUS_DMAPAUSED_SHIFT)
#define  PIC_WDMA_DMA0_STATUS_DMAPAUSED_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA0_STATUS_DMAPAUSED_MASK) | (((uint32_t)val) << PIC_WDMA_DMA0_STATUS_DMAPAUSED_SHIFT))

#define  PIC_WDMA_DMA0_STATUS_PAUSEAFTER_MASK 0x1000
#define  PIC_WDMA_DMA0_STATUS_PAUSEAFTER_SHIFT 12
#define  PIC_WDMA_DMA0_STATUS_PAUSEAFTER_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA0_STATUS_PAUSEAFTER_MASK) >> PIC_WDMA_DMA0_STATUS_PAUSEAFTER_SHIFT)
#define  PIC_WDMA_DMA0_STATUS_PAUSEAFTER_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA0_STATUS_PAUSEAFTER_MASK) | (((uint32_t)val) << PIC_WDMA_DMA0_STATUS_PAUSEAFTER_SHIFT))

#define  PIC_WDMA_DMA0_STATUS_PAUSEBEFORE_MASK 0x800
#define  PIC_WDMA_DMA0_STATUS_PAUSEBEFORE_SHIFT 11
#define  PIC_WDMA_DMA0_STATUS_PAUSEBEFORE_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA0_STATUS_PAUSEBEFORE_MASK) >> PIC_WDMA_DMA0_STATUS_PAUSEBEFORE_SHIFT)
#define  PIC_WDMA_DMA0_STATUS_PAUSEBEFORE_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA0_STATUS_PAUSEBEFORE_MASK) | (((uint32_t)val) << PIC_WDMA_DMA0_STATUS_PAUSEBEFORE_SHIFT))

#define  PIC_WDMA_DMA0_STATUS_DESC_OWN_MASK 0x400
#define  PIC_WDMA_DMA0_STATUS_DESC_OWN_SHIFT 10
#define  PIC_WDMA_DMA0_STATUS_DESC_OWN_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA0_STATUS_DESC_OWN_MASK) >> PIC_WDMA_DMA0_STATUS_DESC_OWN_SHIFT)
#define  PIC_WDMA_DMA0_STATUS_DESC_OWN_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA0_STATUS_DESC_OWN_MASK) | (((uint32_t)val) << PIC_WDMA_DMA0_STATUS_DESC_OWN_SHIFT))

#define  PIC_WDMA_DMA0_STATUS_DESC_EOI_MASK 0x200
#define  PIC_WDMA_DMA0_STATUS_DESC_EOI_SHIFT 9
#define  PIC_WDMA_DMA0_STATUS_DESC_EOI_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA0_STATUS_DESC_EOI_MASK) >> PIC_WDMA_DMA0_STATUS_DESC_EOI_SHIFT)
#define  PIC_WDMA_DMA0_STATUS_DESC_EOI_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA0_STATUS_DESC_EOI_MASK) | (((uint32_t)val) << PIC_WDMA_DMA0_STATUS_DESC_EOI_SHIFT))

#define  PIC_WDMA_DMA0_STATUS_DESC_SOI_MASK 0x100
#define  PIC_WDMA_DMA0_STATUS_DESC_SOI_SHIFT 8
#define  PIC_WDMA_DMA0_STATUS_DESC_SOI_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA0_STATUS_DESC_SOI_MASK) >> PIC_WDMA_DMA0_STATUS_DESC_SOI_SHIFT)
#define  PIC_WDMA_DMA0_STATUS_DESC_SOI_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA0_STATUS_DESC_SOI_MASK) | (((uint32_t)val) << PIC_WDMA_DMA0_STATUS_DESC_SOI_SHIFT))

#define  PIC_WDMA_DMA0_STATUS_REVERSE_MASK 0x80
#define  PIC_WDMA_DMA0_STATUS_REVERSE_SHIFT 7
#define  PIC_WDMA_DMA0_STATUS_REVERSE_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA0_STATUS_REVERSE_MASK) >> PIC_WDMA_DMA0_STATUS_REVERSE_SHIFT)
#define  PIC_WDMA_DMA0_STATUS_REVERSE_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA0_STATUS_REVERSE_MASK) | (((uint32_t)val) << PIC_WDMA_DMA0_STATUS_REVERSE_SHIFT))

#define  PIC_WDMA_DMA0_STATUS_SOFTRESET_MASK 0x40
#define  PIC_WDMA_DMA0_STATUS_SOFTRESET_SHIFT 6
#define  PIC_WDMA_DMA0_STATUS_SOFTRESET_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA0_STATUS_SOFTRESET_MASK) >> PIC_WDMA_DMA0_STATUS_SOFTRESET_SHIFT)
#define  PIC_WDMA_DMA0_STATUS_SOFTRESET_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA0_STATUS_SOFTRESET_MASK) | (((uint32_t)val) << PIC_WDMA_DMA0_STATUS_SOFTRESET_SHIFT))

#define  PIC_WDMA_DMA0_STATUS_FULL_CBUF_MASK 0x20
#define  PIC_WDMA_DMA0_STATUS_FULL_CBUF_SHIFT 5
#define  PIC_WDMA_DMA0_STATUS_FULL_CBUF_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA0_STATUS_FULL_CBUF_MASK) >> PIC_WDMA_DMA0_STATUS_FULL_CBUF_SHIFT)
#define  PIC_WDMA_DMA0_STATUS_FULL_CBUF_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA0_STATUS_FULL_CBUF_MASK) | (((uint32_t)val) << PIC_WDMA_DMA0_STATUS_FULL_CBUF_SHIFT))

#define  PIC_WDMA_DMA0_STATUS_EMPTY_CBUF_MASK 0x10
#define  PIC_WDMA_DMA0_STATUS_EMPTY_CBUF_SHIFT 4
#define  PIC_WDMA_DMA0_STATUS_EMPTY_CBUF_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA0_STATUS_EMPTY_CBUF_MASK) >> PIC_WDMA_DMA0_STATUS_EMPTY_CBUF_SHIFT)
#define  PIC_WDMA_DMA0_STATUS_EMPTY_CBUF_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA0_STATUS_EMPTY_CBUF_MASK) | (((uint32_t)val) << PIC_WDMA_DMA0_STATUS_EMPTY_CBUF_SHIFT))

#define  PIC_WDMA_DMA0_STATUS_FULL_DBUF_MASK 0x8
#define  PIC_WDMA_DMA0_STATUS_FULL_DBUF_SHIFT 3
#define  PIC_WDMA_DMA0_STATUS_FULL_DBUF_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA0_STATUS_FULL_DBUF_MASK) >> PIC_WDMA_DMA0_STATUS_FULL_DBUF_SHIFT)
#define  PIC_WDMA_DMA0_STATUS_FULL_DBUF_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA0_STATUS_FULL_DBUF_MASK) | (((uint32_t)val) << PIC_WDMA_DMA0_STATUS_FULL_DBUF_SHIFT))

#define  PIC_WDMA_DMA0_STATUS_EMPTY_DBUF_MASK 0x4
#define  PIC_WDMA_DMA0_STATUS_EMPTY_DBUF_SHIFT 2
#define  PIC_WDMA_DMA0_STATUS_EMPTY_DBUF_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA0_STATUS_EMPTY_DBUF_MASK) >> PIC_WDMA_DMA0_STATUS_EMPTY_DBUF_SHIFT)
#define  PIC_WDMA_DMA0_STATUS_EMPTY_DBUF_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA0_STATUS_EMPTY_DBUF_MASK) | (((uint32_t)val) << PIC_WDMA_DMA0_STATUS_EMPTY_DBUF_SHIFT))

#define  PIC_WDMA_DMA0_STATUS_PACKER_EMPTY_MASK 0x2
#define  PIC_WDMA_DMA0_STATUS_PACKER_EMPTY_SHIFT 1
#define  PIC_WDMA_DMA0_STATUS_PACKER_EMPTY_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA0_STATUS_PACKER_EMPTY_MASK) >> PIC_WDMA_DMA0_STATUS_PACKER_EMPTY_SHIFT)
#define  PIC_WDMA_DMA0_STATUS_PACKER_EMPTY_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA0_STATUS_PACKER_EMPTY_MASK) | (((uint32_t)val) << PIC_WDMA_DMA0_STATUS_PACKER_EMPTY_SHIFT))

#define  PIC_WDMA_DMA0_STATUS_DMA_BUSY_MASK 0x1
#define  PIC_WDMA_DMA0_STATUS_DMA_BUSY_SHIFT 0
#define  PIC_WDMA_DMA0_STATUS_DMA_BUSY_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA0_STATUS_DMA_BUSY_MASK) >> PIC_WDMA_DMA0_STATUS_DMA_BUSY_SHIFT)
#define  PIC_WDMA_DMA0_STATUS_DMA_BUSY_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA0_STATUS_DMA_BUSY_MASK) | (((uint32_t)val) << PIC_WDMA_DMA0_STATUS_DMA_BUSY_SHIFT))

//====================================================================
//Register: Line Size Register (line_size)
//====================================================================

#define  PIC_WDMA_DMA0_LINE_SIZE_RESERVED1_MASK 0xfffc0000
#define  PIC_WDMA_DMA0_LINE_SIZE_RESERVED1_SHIFT 18
#define  PIC_WDMA_DMA0_LINE_SIZE_RESERVED1_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA0_LINE_SIZE_RESERVED1_MASK) >> PIC_WDMA_DMA0_LINE_SIZE_RESERVED1_SHIFT)
#define  PIC_WDMA_DMA0_LINE_SIZE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA0_LINE_SIZE_RESERVED1_MASK) | (((uint32_t)val) << PIC_WDMA_DMA0_LINE_SIZE_RESERVED1_SHIFT))

#define  PIC_WDMA_DMA0_LINE_SIZE_LINE_SIZE_MASK 0x3ffff
#define  PIC_WDMA_DMA0_LINE_SIZE_LINE_SIZE_SHIFT 0
#define  PIC_WDMA_DMA0_LINE_SIZE_LINE_SIZE_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA0_LINE_SIZE_LINE_SIZE_MASK) >> PIC_WDMA_DMA0_LINE_SIZE_LINE_SIZE_SHIFT)
#define  PIC_WDMA_DMA0_LINE_SIZE_LINE_SIZE_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA0_LINE_SIZE_LINE_SIZE_MASK) | (((uint32_t)val) << PIC_WDMA_DMA0_LINE_SIZE_LINE_SIZE_SHIFT))

//====================================================================
//Register: Interrupt Enable Register (int_en)
//====================================================================

#define  PIC_WDMA_DMA0_INT_EN_RESERVED1_MASK 0xfffff800
#define  PIC_WDMA_DMA0_INT_EN_RESERVED1_SHIFT 11
#define  PIC_WDMA_DMA0_INT_EN_RESERVED1_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA0_INT_EN_RESERVED1_MASK) >> PIC_WDMA_DMA0_INT_EN_RESERVED1_SHIFT)
#define  PIC_WDMA_DMA0_INT_EN_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA0_INT_EN_RESERVED1_MASK) | (((uint32_t)val) << PIC_WDMA_DMA0_INT_EN_RESERVED1_SHIFT))

#define  PIC_WDMA_DMA0_INT_EN_RRESP_INT_EN_MASK 0x400
#define  PIC_WDMA_DMA0_INT_EN_RRESP_INT_EN_SHIFT 10
#define  PIC_WDMA_DMA0_INT_EN_RRESP_INT_EN_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA0_INT_EN_RRESP_INT_EN_MASK) >> PIC_WDMA_DMA0_INT_EN_RRESP_INT_EN_SHIFT)
#define  PIC_WDMA_DMA0_INT_EN_RRESP_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA0_INT_EN_RRESP_INT_EN_MASK) | (((uint32_t)val) << PIC_WDMA_DMA0_INT_EN_RRESP_INT_EN_SHIFT))

#define  PIC_WDMA_DMA0_INT_EN_BRESP_INT_EN_MASK 0x200
#define  PIC_WDMA_DMA0_INT_EN_BRESP_INT_EN_SHIFT 9
#define  PIC_WDMA_DMA0_INT_EN_BRESP_INT_EN_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA0_INT_EN_BRESP_INT_EN_MASK) >> PIC_WDMA_DMA0_INT_EN_BRESP_INT_EN_SHIFT)
#define  PIC_WDMA_DMA0_INT_EN_BRESP_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA0_INT_EN_BRESP_INT_EN_MASK) | (((uint32_t)val) << PIC_WDMA_DMA0_INT_EN_BRESP_INT_EN_SHIFT))

#define  PIC_WDMA_DMA0_INT_EN_RST_INT_EN_MASK 0x100
#define  PIC_WDMA_DMA0_INT_EN_RST_INT_EN_SHIFT 8
#define  PIC_WDMA_DMA0_INT_EN_RST_INT_EN_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA0_INT_EN_RST_INT_EN_MASK) >> PIC_WDMA_DMA0_INT_EN_RST_INT_EN_SHIFT)
#define  PIC_WDMA_DMA0_INT_EN_RST_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA0_INT_EN_RST_INT_EN_MASK) | (((uint32_t)val) << PIC_WDMA_DMA0_INT_EN_RST_INT_EN_SHIFT))

#define  PIC_WDMA_DMA0_INT_EN_EOI_INT_EN_MASK 0x80
#define  PIC_WDMA_DMA0_INT_EN_EOI_INT_EN_SHIFT 7
#define  PIC_WDMA_DMA0_INT_EN_EOI_INT_EN_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA0_INT_EN_EOI_INT_EN_MASK) >> PIC_WDMA_DMA0_INT_EN_EOI_INT_EN_SHIFT)
#define  PIC_WDMA_DMA0_INT_EN_EOI_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA0_INT_EN_EOI_INT_EN_MASK) | (((uint32_t)val) << PIC_WDMA_DMA0_INT_EN_EOI_INT_EN_SHIFT))

#define  PIC_WDMA_DMA0_INT_EN_DIR_INT_EN_MASK 0x40
#define  PIC_WDMA_DMA0_INT_EN_DIR_INT_EN_SHIFT 6
#define  PIC_WDMA_DMA0_INT_EN_DIR_INT_EN_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA0_INT_EN_DIR_INT_EN_MASK) >> PIC_WDMA_DMA0_INT_EN_DIR_INT_EN_SHIFT)
#define  PIC_WDMA_DMA0_INT_EN_DIR_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA0_INT_EN_DIR_INT_EN_MASK) | (((uint32_t)val) << PIC_WDMA_DMA0_INT_EN_DIR_INT_EN_SHIFT))

#define  PIC_WDMA_DMA0_INT_EN_CL_ALI_INT_EN_MASK 0x20
#define  PIC_WDMA_DMA0_INT_EN_CL_ALI_INT_EN_SHIFT 5
#define  PIC_WDMA_DMA0_INT_EN_CL_ALI_INT_EN_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA0_INT_EN_CL_ALI_INT_EN_MASK) >> PIC_WDMA_DMA0_INT_EN_CL_ALI_INT_EN_SHIFT)
#define  PIC_WDMA_DMA0_INT_EN_CL_ALI_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA0_INT_EN_CL_ALI_INT_EN_MASK) | (((uint32_t)val) << PIC_WDMA_DMA0_INT_EN_CL_ALI_INT_EN_SHIFT))

#define  PIC_WDMA_DMA0_INT_EN_EOL_ALI_INT_EN_MASK 0x10
#define  PIC_WDMA_DMA0_INT_EN_EOL_ALI_INT_EN_SHIFT 4
#define  PIC_WDMA_DMA0_INT_EN_EOL_ALI_INT_EN_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA0_INT_EN_EOL_ALI_INT_EN_MASK) >> PIC_WDMA_DMA0_INT_EN_EOL_ALI_INT_EN_SHIFT)
#define  PIC_WDMA_DMA0_INT_EN_EOL_ALI_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA0_INT_EN_EOL_ALI_INT_EN_MASK) | (((uint32_t)val) << PIC_WDMA_DMA0_INT_EN_EOL_ALI_INT_EN_SHIFT))

#define  PIC_WDMA_DMA0_INT_EN_EOI_ALI_INT_EN_MASK 0x8
#define  PIC_WDMA_DMA0_INT_EN_EOI_ALI_INT_EN_SHIFT 3
#define  PIC_WDMA_DMA0_INT_EN_EOI_ALI_INT_EN_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA0_INT_EN_EOI_ALI_INT_EN_MASK) >> PIC_WDMA_DMA0_INT_EN_EOI_ALI_INT_EN_SHIFT)
#define  PIC_WDMA_DMA0_INT_EN_EOI_ALI_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA0_INT_EN_EOI_ALI_INT_EN_MASK) | (((uint32_t)val) << PIC_WDMA_DMA0_INT_EN_EOI_ALI_INT_EN_SHIFT))

#define  PIC_WDMA_DMA0_INT_EN_EOI_ERR_INT_EN_MASK 0x4
#define  PIC_WDMA_DMA0_INT_EN_EOI_ERR_INT_EN_SHIFT 2
#define  PIC_WDMA_DMA0_INT_EN_EOI_ERR_INT_EN_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA0_INT_EN_EOI_ERR_INT_EN_MASK) >> PIC_WDMA_DMA0_INT_EN_EOI_ERR_INT_EN_SHIFT)
#define  PIC_WDMA_DMA0_INT_EN_EOI_ERR_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA0_INT_EN_EOI_ERR_INT_EN_MASK) | (((uint32_t)val) << PIC_WDMA_DMA0_INT_EN_EOI_ERR_INT_EN_SHIFT))

#define  PIC_WDMA_DMA0_INT_EN_FIN_INT_EN_MASK 0x2
#define  PIC_WDMA_DMA0_INT_EN_FIN_INT_EN_SHIFT 1
#define  PIC_WDMA_DMA0_INT_EN_FIN_INT_EN_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA0_INT_EN_FIN_INT_EN_MASK) >> PIC_WDMA_DMA0_INT_EN_FIN_INT_EN_SHIFT)
#define  PIC_WDMA_DMA0_INT_EN_FIN_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA0_INT_EN_FIN_INT_EN_MASK) | (((uint32_t)val) << PIC_WDMA_DMA0_INT_EN_FIN_INT_EN_SHIFT))

#define  PIC_WDMA_DMA0_INT_EN_WHO_INT_EN_MASK 0x1
#define  PIC_WDMA_DMA0_INT_EN_WHO_INT_EN_SHIFT 0
#define  PIC_WDMA_DMA0_INT_EN_WHO_INT_EN_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA0_INT_EN_WHO_INT_EN_MASK) >> PIC_WDMA_DMA0_INT_EN_WHO_INT_EN_SHIFT)
#define  PIC_WDMA_DMA0_INT_EN_WHO_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA0_INT_EN_WHO_INT_EN_MASK) | (((uint32_t)val) << PIC_WDMA_DMA0_INT_EN_WHO_INT_EN_SHIFT))

//====================================================================
//Register: Interrupt Pending Register (int_pend)
//====================================================================

#define  PIC_WDMA_DMA0_INT_PEND_RESERVED1_MASK 0xfffff800
#define  PIC_WDMA_DMA0_INT_PEND_RESERVED1_SHIFT 11
#define  PIC_WDMA_DMA0_INT_PEND_RESERVED1_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA0_INT_PEND_RESERVED1_MASK) >> PIC_WDMA_DMA0_INT_PEND_RESERVED1_SHIFT)
#define  PIC_WDMA_DMA0_INT_PEND_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA0_INT_PEND_RESERVED1_MASK) | (((uint32_t)val) << PIC_WDMA_DMA0_INT_PEND_RESERVED1_SHIFT))

#define  PIC_WDMA_DMA0_INT_PEND_RRESP_INT_PEND_MASK 0x400
#define  PIC_WDMA_DMA0_INT_PEND_RRESP_INT_PEND_SHIFT 10
#define  PIC_WDMA_DMA0_INT_PEND_RRESP_INT_PEND_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA0_INT_PEND_RRESP_INT_PEND_MASK) >> PIC_WDMA_DMA0_INT_PEND_RRESP_INT_PEND_SHIFT)
#define  PIC_WDMA_DMA0_INT_PEND_RRESP_INT_PEND_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA0_INT_PEND_RRESP_INT_PEND_MASK) | (((uint32_t)val) << PIC_WDMA_DMA0_INT_PEND_RRESP_INT_PEND_SHIFT))

#define  PIC_WDMA_DMA0_INT_PEND_BRESP_INT_PEND_MASK 0x200
#define  PIC_WDMA_DMA0_INT_PEND_BRESP_INT_PEND_SHIFT 9
#define  PIC_WDMA_DMA0_INT_PEND_BRESP_INT_PEND_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA0_INT_PEND_BRESP_INT_PEND_MASK) >> PIC_WDMA_DMA0_INT_PEND_BRESP_INT_PEND_SHIFT)
#define  PIC_WDMA_DMA0_INT_PEND_BRESP_INT_PEND_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA0_INT_PEND_BRESP_INT_PEND_MASK) | (((uint32_t)val) << PIC_WDMA_DMA0_INT_PEND_BRESP_INT_PEND_SHIFT))

#define  PIC_WDMA_DMA0_INT_PEND_RST_INT_PEND_MASK 0x100
#define  PIC_WDMA_DMA0_INT_PEND_RST_INT_PEND_SHIFT 8
#define  PIC_WDMA_DMA0_INT_PEND_RST_INT_PEND_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA0_INT_PEND_RST_INT_PEND_MASK) >> PIC_WDMA_DMA0_INT_PEND_RST_INT_PEND_SHIFT)
#define  PIC_WDMA_DMA0_INT_PEND_RST_INT_PEND_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA0_INT_PEND_RST_INT_PEND_MASK) | (((uint32_t)val) << PIC_WDMA_DMA0_INT_PEND_RST_INT_PEND_SHIFT))

#define  PIC_WDMA_DMA0_INT_PEND_EOI_INT_PEND_MASK 0x80
#define  PIC_WDMA_DMA0_INT_PEND_EOI_INT_PEND_SHIFT 7
#define  PIC_WDMA_DMA0_INT_PEND_EOI_INT_PEND_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA0_INT_PEND_EOI_INT_PEND_MASK) >> PIC_WDMA_DMA0_INT_PEND_EOI_INT_PEND_SHIFT)
#define  PIC_WDMA_DMA0_INT_PEND_EOI_INT_PEND_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA0_INT_PEND_EOI_INT_PEND_MASK) | (((uint32_t)val) << PIC_WDMA_DMA0_INT_PEND_EOI_INT_PEND_SHIFT))

#define  PIC_WDMA_DMA0_INT_PEND_DIR_INT_PEND_MASK 0x40
#define  PIC_WDMA_DMA0_INT_PEND_DIR_INT_PEND_SHIFT 6
#define  PIC_WDMA_DMA0_INT_PEND_DIR_INT_PEND_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA0_INT_PEND_DIR_INT_PEND_MASK) >> PIC_WDMA_DMA0_INT_PEND_DIR_INT_PEND_SHIFT)
#define  PIC_WDMA_DMA0_INT_PEND_DIR_INT_PEND_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA0_INT_PEND_DIR_INT_PEND_MASK) | (((uint32_t)val) << PIC_WDMA_DMA0_INT_PEND_DIR_INT_PEND_SHIFT))

#define  PIC_WDMA_DMA0_INT_PEND_CL_ALI_INT_PEND_MASK 0x20
#define  PIC_WDMA_DMA0_INT_PEND_CL_ALI_INT_PEND_SHIFT 5
#define  PIC_WDMA_DMA0_INT_PEND_CL_ALI_INT_PEND_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA0_INT_PEND_CL_ALI_INT_PEND_MASK) >> PIC_WDMA_DMA0_INT_PEND_CL_ALI_INT_PEND_SHIFT)
#define  PIC_WDMA_DMA0_INT_PEND_CL_ALI_INT_PEND_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA0_INT_PEND_CL_ALI_INT_PEND_MASK) | (((uint32_t)val) << PIC_WDMA_DMA0_INT_PEND_CL_ALI_INT_PEND_SHIFT))

#define  PIC_WDMA_DMA0_INT_PEND_EOL_ALI_INT_PEND_MASK 0x10
#define  PIC_WDMA_DMA0_INT_PEND_EOL_ALI_INT_PEND_SHIFT 4
#define  PIC_WDMA_DMA0_INT_PEND_EOL_ALI_INT_PEND_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA0_INT_PEND_EOL_ALI_INT_PEND_MASK) >> PIC_WDMA_DMA0_INT_PEND_EOL_ALI_INT_PEND_SHIFT)
#define  PIC_WDMA_DMA0_INT_PEND_EOL_ALI_INT_PEND_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA0_INT_PEND_EOL_ALI_INT_PEND_MASK) | (((uint32_t)val) << PIC_WDMA_DMA0_INT_PEND_EOL_ALI_INT_PEND_SHIFT))

#define  PIC_WDMA_DMA0_INT_PEND_EOI_ALI_INT_PEND_MASK 0x8
#define  PIC_WDMA_DMA0_INT_PEND_EOI_ALI_INT_PEND_SHIFT 3
#define  PIC_WDMA_DMA0_INT_PEND_EOI_ALI_INT_PEND_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA0_INT_PEND_EOI_ALI_INT_PEND_MASK) >> PIC_WDMA_DMA0_INT_PEND_EOI_ALI_INT_PEND_SHIFT)
#define  PIC_WDMA_DMA0_INT_PEND_EOI_ALI_INT_PEND_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA0_INT_PEND_EOI_ALI_INT_PEND_MASK) | (((uint32_t)val) << PIC_WDMA_DMA0_INT_PEND_EOI_ALI_INT_PEND_SHIFT))

#define  PIC_WDMA_DMA0_INT_PEND_EOI_ERR_INT_PEND_MASK 0x4
#define  PIC_WDMA_DMA0_INT_PEND_EOI_ERR_INT_PEND_SHIFT 2
#define  PIC_WDMA_DMA0_INT_PEND_EOI_ERR_INT_PEND_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA0_INT_PEND_EOI_ERR_INT_PEND_MASK) >> PIC_WDMA_DMA0_INT_PEND_EOI_ERR_INT_PEND_SHIFT)
#define  PIC_WDMA_DMA0_INT_PEND_EOI_ERR_INT_PEND_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA0_INT_PEND_EOI_ERR_INT_PEND_MASK) | (((uint32_t)val) << PIC_WDMA_DMA0_INT_PEND_EOI_ERR_INT_PEND_SHIFT))

#define  PIC_WDMA_DMA0_INT_PEND_FIN_INT_PEND_MASK 0x2
#define  PIC_WDMA_DMA0_INT_PEND_FIN_INT_PEND_SHIFT 1
#define  PIC_WDMA_DMA0_INT_PEND_FIN_INT_PEND_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA0_INT_PEND_FIN_INT_PEND_MASK) >> PIC_WDMA_DMA0_INT_PEND_FIN_INT_PEND_SHIFT)
#define  PIC_WDMA_DMA0_INT_PEND_FIN_INT_PEND_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA0_INT_PEND_FIN_INT_PEND_MASK) | (((uint32_t)val) << PIC_WDMA_DMA0_INT_PEND_FIN_INT_PEND_SHIFT))

#define  PIC_WDMA_DMA0_INT_PEND_WHO_INT_PEND_MASK 0x1
#define  PIC_WDMA_DMA0_INT_PEND_WHO_INT_PEND_SHIFT 0
#define  PIC_WDMA_DMA0_INT_PEND_WHO_INT_PEND_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA0_INT_PEND_WHO_INT_PEND_MASK) >> PIC_WDMA_DMA0_INT_PEND_WHO_INT_PEND_SHIFT)
#define  PIC_WDMA_DMA0_INT_PEND_WHO_INT_PEND_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA0_INT_PEND_WHO_INT_PEND_MASK) | (((uint32_t)val) << PIC_WDMA_DMA0_INT_PEND_WHO_INT_PEND_SHIFT))

//====================================================================
//Register: Interrupt Acknowledge Register (int_ack)
//====================================================================

#define  PIC_WDMA_DMA0_INT_ACK_RESERVED1_MASK 0xfffff800
#define  PIC_WDMA_DMA0_INT_ACK_RESERVED1_SHIFT 11
#define  PIC_WDMA_DMA0_INT_ACK_RESERVED1_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA0_INT_ACK_RESERVED1_MASK) >> PIC_WDMA_DMA0_INT_ACK_RESERVED1_SHIFT)
#define  PIC_WDMA_DMA0_INT_ACK_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA0_INT_ACK_RESERVED1_MASK) | (((uint32_t)val) << PIC_WDMA_DMA0_INT_ACK_RESERVED1_SHIFT))

#define  PIC_WDMA_DMA0_INT_ACK_RRESP_INT_ACK_MASK 0x400
#define  PIC_WDMA_DMA0_INT_ACK_RRESP_INT_ACK_SHIFT 10
#define  PIC_WDMA_DMA0_INT_ACK_RRESP_INT_ACK_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA0_INT_ACK_RRESP_INT_ACK_MASK) >> PIC_WDMA_DMA0_INT_ACK_RRESP_INT_ACK_SHIFT)
#define  PIC_WDMA_DMA0_INT_ACK_RRESP_INT_ACK_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA0_INT_ACK_RRESP_INT_ACK_MASK) | (((uint32_t)val) << PIC_WDMA_DMA0_INT_ACK_RRESP_INT_ACK_SHIFT))

#define  PIC_WDMA_DMA0_INT_ACK_BRESP_INT_ACK_MASK 0x200
#define  PIC_WDMA_DMA0_INT_ACK_BRESP_INT_ACK_SHIFT 9
#define  PIC_WDMA_DMA0_INT_ACK_BRESP_INT_ACK_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA0_INT_ACK_BRESP_INT_ACK_MASK) >> PIC_WDMA_DMA0_INT_ACK_BRESP_INT_ACK_SHIFT)
#define  PIC_WDMA_DMA0_INT_ACK_BRESP_INT_ACK_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA0_INT_ACK_BRESP_INT_ACK_MASK) | (((uint32_t)val) << PIC_WDMA_DMA0_INT_ACK_BRESP_INT_ACK_SHIFT))

#define  PIC_WDMA_DMA0_INT_ACK_RST_INT_ACK_MASK 0x100
#define  PIC_WDMA_DMA0_INT_ACK_RST_INT_ACK_SHIFT 8
#define  PIC_WDMA_DMA0_INT_ACK_RST_INT_ACK_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA0_INT_ACK_RST_INT_ACK_MASK) >> PIC_WDMA_DMA0_INT_ACK_RST_INT_ACK_SHIFT)
#define  PIC_WDMA_DMA0_INT_ACK_RST_INT_ACK_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA0_INT_ACK_RST_INT_ACK_MASK) | (((uint32_t)val) << PIC_WDMA_DMA0_INT_ACK_RST_INT_ACK_SHIFT))

#define  PIC_WDMA_DMA0_INT_ACK_EOI_INT_ACK_MASK 0x80
#define  PIC_WDMA_DMA0_INT_ACK_EOI_INT_ACK_SHIFT 7
#define  PIC_WDMA_DMA0_INT_ACK_EOI_INT_ACK_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA0_INT_ACK_EOI_INT_ACK_MASK) >> PIC_WDMA_DMA0_INT_ACK_EOI_INT_ACK_SHIFT)
#define  PIC_WDMA_DMA0_INT_ACK_EOI_INT_ACK_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA0_INT_ACK_EOI_INT_ACK_MASK) | (((uint32_t)val) << PIC_WDMA_DMA0_INT_ACK_EOI_INT_ACK_SHIFT))

#define  PIC_WDMA_DMA0_INT_ACK_DIR_INT_ACK_MASK 0x40
#define  PIC_WDMA_DMA0_INT_ACK_DIR_INT_ACK_SHIFT 6
#define  PIC_WDMA_DMA0_INT_ACK_DIR_INT_ACK_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA0_INT_ACK_DIR_INT_ACK_MASK) >> PIC_WDMA_DMA0_INT_ACK_DIR_INT_ACK_SHIFT)
#define  PIC_WDMA_DMA0_INT_ACK_DIR_INT_ACK_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA0_INT_ACK_DIR_INT_ACK_MASK) | (((uint32_t)val) << PIC_WDMA_DMA0_INT_ACK_DIR_INT_ACK_SHIFT))

#define  PIC_WDMA_DMA0_INT_ACK_CL_ALI_INT_ACK_MASK 0x20
#define  PIC_WDMA_DMA0_INT_ACK_CL_ALI_INT_ACK_SHIFT 5
#define  PIC_WDMA_DMA0_INT_ACK_CL_ALI_INT_ACK_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA0_INT_ACK_CL_ALI_INT_ACK_MASK) >> PIC_WDMA_DMA0_INT_ACK_CL_ALI_INT_ACK_SHIFT)
#define  PIC_WDMA_DMA0_INT_ACK_CL_ALI_INT_ACK_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA0_INT_ACK_CL_ALI_INT_ACK_MASK) | (((uint32_t)val) << PIC_WDMA_DMA0_INT_ACK_CL_ALI_INT_ACK_SHIFT))

#define  PIC_WDMA_DMA0_INT_ACK_EOL_ALI_INT_ACK_MASK 0x10
#define  PIC_WDMA_DMA0_INT_ACK_EOL_ALI_INT_ACK_SHIFT 4
#define  PIC_WDMA_DMA0_INT_ACK_EOL_ALI_INT_ACK_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA0_INT_ACK_EOL_ALI_INT_ACK_MASK) >> PIC_WDMA_DMA0_INT_ACK_EOL_ALI_INT_ACK_SHIFT)
#define  PIC_WDMA_DMA0_INT_ACK_EOL_ALI_INT_ACK_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA0_INT_ACK_EOL_ALI_INT_ACK_MASK) | (((uint32_t)val) << PIC_WDMA_DMA0_INT_ACK_EOL_ALI_INT_ACK_SHIFT))

#define  PIC_WDMA_DMA0_INT_ACK_EOI_ALI_INT_ACK_MASK 0x8
#define  PIC_WDMA_DMA0_INT_ACK_EOI_ALI_INT_ACK_SHIFT 3
#define  PIC_WDMA_DMA0_INT_ACK_EOI_ALI_INT_ACK_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA0_INT_ACK_EOI_ALI_INT_ACK_MASK) >> PIC_WDMA_DMA0_INT_ACK_EOI_ALI_INT_ACK_SHIFT)
#define  PIC_WDMA_DMA0_INT_ACK_EOI_ALI_INT_ACK_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA0_INT_ACK_EOI_ALI_INT_ACK_MASK) | (((uint32_t)val) << PIC_WDMA_DMA0_INT_ACK_EOI_ALI_INT_ACK_SHIFT))

#define  PIC_WDMA_DMA0_INT_ACK_EOI_ERR_INT_ACK_MASK 0x4
#define  PIC_WDMA_DMA0_INT_ACK_EOI_ERR_INT_ACK_SHIFT 2
#define  PIC_WDMA_DMA0_INT_ACK_EOI_ERR_INT_ACK_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA0_INT_ACK_EOI_ERR_INT_ACK_MASK) >> PIC_WDMA_DMA0_INT_ACK_EOI_ERR_INT_ACK_SHIFT)
#define  PIC_WDMA_DMA0_INT_ACK_EOI_ERR_INT_ACK_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA0_INT_ACK_EOI_ERR_INT_ACK_MASK) | (((uint32_t)val) << PIC_WDMA_DMA0_INT_ACK_EOI_ERR_INT_ACK_SHIFT))

#define  PIC_WDMA_DMA0_INT_ACK_FIN_INT_ACK_MASK 0x2
#define  PIC_WDMA_DMA0_INT_ACK_FIN_INT_ACK_SHIFT 1
#define  PIC_WDMA_DMA0_INT_ACK_FIN_INT_ACK_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA0_INT_ACK_FIN_INT_ACK_MASK) >> PIC_WDMA_DMA0_INT_ACK_FIN_INT_ACK_SHIFT)
#define  PIC_WDMA_DMA0_INT_ACK_FIN_INT_ACK_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA0_INT_ACK_FIN_INT_ACK_MASK) | (((uint32_t)val) << PIC_WDMA_DMA0_INT_ACK_FIN_INT_ACK_SHIFT))

#define  PIC_WDMA_DMA0_INT_ACK_WHO_INT_ACK_MASK 0x1
#define  PIC_WDMA_DMA0_INT_ACK_WHO_INT_ACK_SHIFT 0
#define  PIC_WDMA_DMA0_INT_ACK_WHO_INT_ACK_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA0_INT_ACK_WHO_INT_ACK_MASK) >> PIC_WDMA_DMA0_INT_ACK_WHO_INT_ACK_SHIFT)
#define  PIC_WDMA_DMA0_INT_ACK_WHO_INT_ACK_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA0_INT_ACK_WHO_INT_ACK_MASK) | (((uint32_t)val) << PIC_WDMA_DMA0_INT_ACK_WHO_INT_ACK_SHIFT))

//====================================================================
//Register: Interrupt Force Register (int_fo)
//====================================================================

#define  PIC_WDMA_DMA0_INT_FO_RESERVED1_MASK 0xfffff800
#define  PIC_WDMA_DMA0_INT_FO_RESERVED1_SHIFT 11
#define  PIC_WDMA_DMA0_INT_FO_RESERVED1_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA0_INT_FO_RESERVED1_MASK) >> PIC_WDMA_DMA0_INT_FO_RESERVED1_SHIFT)
#define  PIC_WDMA_DMA0_INT_FO_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA0_INT_FO_RESERVED1_MASK) | (((uint32_t)val) << PIC_WDMA_DMA0_INT_FO_RESERVED1_SHIFT))

#define  PIC_WDMA_DMA0_INT_FO_RRESP_INT_FO_MASK 0x400
#define  PIC_WDMA_DMA0_INT_FO_RRESP_INT_FO_SHIFT 10
#define  PIC_WDMA_DMA0_INT_FO_RRESP_INT_FO_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA0_INT_FO_RRESP_INT_FO_MASK) >> PIC_WDMA_DMA0_INT_FO_RRESP_INT_FO_SHIFT)
#define  PIC_WDMA_DMA0_INT_FO_RRESP_INT_FO_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA0_INT_FO_RRESP_INT_FO_MASK) | (((uint32_t)val) << PIC_WDMA_DMA0_INT_FO_RRESP_INT_FO_SHIFT))

#define  PIC_WDMA_DMA0_INT_FO_BRESP_INT_FO_MASK 0x200
#define  PIC_WDMA_DMA0_INT_FO_BRESP_INT_FO_SHIFT 9
#define  PIC_WDMA_DMA0_INT_FO_BRESP_INT_FO_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA0_INT_FO_BRESP_INT_FO_MASK) >> PIC_WDMA_DMA0_INT_FO_BRESP_INT_FO_SHIFT)
#define  PIC_WDMA_DMA0_INT_FO_BRESP_INT_FO_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA0_INT_FO_BRESP_INT_FO_MASK) | (((uint32_t)val) << PIC_WDMA_DMA0_INT_FO_BRESP_INT_FO_SHIFT))

#define  PIC_WDMA_DMA0_INT_FO_RST_INT_FO_MASK 0x100
#define  PIC_WDMA_DMA0_INT_FO_RST_INT_FO_SHIFT 8
#define  PIC_WDMA_DMA0_INT_FO_RST_INT_FO_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA0_INT_FO_RST_INT_FO_MASK) >> PIC_WDMA_DMA0_INT_FO_RST_INT_FO_SHIFT)
#define  PIC_WDMA_DMA0_INT_FO_RST_INT_FO_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA0_INT_FO_RST_INT_FO_MASK) | (((uint32_t)val) << PIC_WDMA_DMA0_INT_FO_RST_INT_FO_SHIFT))

#define  PIC_WDMA_DMA0_INT_FO_EOI_INT_FO_MASK 0x80
#define  PIC_WDMA_DMA0_INT_FO_EOI_INT_FO_SHIFT 7
#define  PIC_WDMA_DMA0_INT_FO_EOI_INT_FO_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA0_INT_FO_EOI_INT_FO_MASK) >> PIC_WDMA_DMA0_INT_FO_EOI_INT_FO_SHIFT)
#define  PIC_WDMA_DMA0_INT_FO_EOI_INT_FO_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA0_INT_FO_EOI_INT_FO_MASK) | (((uint32_t)val) << PIC_WDMA_DMA0_INT_FO_EOI_INT_FO_SHIFT))

#define  PIC_WDMA_DMA0_INT_FO_DIR_INT_FO_MASK 0x40
#define  PIC_WDMA_DMA0_INT_FO_DIR_INT_FO_SHIFT 6
#define  PIC_WDMA_DMA0_INT_FO_DIR_INT_FO_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA0_INT_FO_DIR_INT_FO_MASK) >> PIC_WDMA_DMA0_INT_FO_DIR_INT_FO_SHIFT)
#define  PIC_WDMA_DMA0_INT_FO_DIR_INT_FO_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA0_INT_FO_DIR_INT_FO_MASK) | (((uint32_t)val) << PIC_WDMA_DMA0_INT_FO_DIR_INT_FO_SHIFT))

#define  PIC_WDMA_DMA0_INT_FO_CL_ALI_INT_FO_MASK 0x20
#define  PIC_WDMA_DMA0_INT_FO_CL_ALI_INT_FO_SHIFT 5
#define  PIC_WDMA_DMA0_INT_FO_CL_ALI_INT_FO_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA0_INT_FO_CL_ALI_INT_FO_MASK) >> PIC_WDMA_DMA0_INT_FO_CL_ALI_INT_FO_SHIFT)
#define  PIC_WDMA_DMA0_INT_FO_CL_ALI_INT_FO_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA0_INT_FO_CL_ALI_INT_FO_MASK) | (((uint32_t)val) << PIC_WDMA_DMA0_INT_FO_CL_ALI_INT_FO_SHIFT))

#define  PIC_WDMA_DMA0_INT_FO_EOL_ALI_INT_FO_MASK 0x10
#define  PIC_WDMA_DMA0_INT_FO_EOL_ALI_INT_FO_SHIFT 4
#define  PIC_WDMA_DMA0_INT_FO_EOL_ALI_INT_FO_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA0_INT_FO_EOL_ALI_INT_FO_MASK) >> PIC_WDMA_DMA0_INT_FO_EOL_ALI_INT_FO_SHIFT)
#define  PIC_WDMA_DMA0_INT_FO_EOL_ALI_INT_FO_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA0_INT_FO_EOL_ALI_INT_FO_MASK) | (((uint32_t)val) << PIC_WDMA_DMA0_INT_FO_EOL_ALI_INT_FO_SHIFT))

#define  PIC_WDMA_DMA0_INT_FO_EOI_ALI_INT_FO_MASK 0x8
#define  PIC_WDMA_DMA0_INT_FO_EOI_ALI_INT_FO_SHIFT 3
#define  PIC_WDMA_DMA0_INT_FO_EOI_ALI_INT_FO_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA0_INT_FO_EOI_ALI_INT_FO_MASK) >> PIC_WDMA_DMA0_INT_FO_EOI_ALI_INT_FO_SHIFT)
#define  PIC_WDMA_DMA0_INT_FO_EOI_ALI_INT_FO_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA0_INT_FO_EOI_ALI_INT_FO_MASK) | (((uint32_t)val) << PIC_WDMA_DMA0_INT_FO_EOI_ALI_INT_FO_SHIFT))

#define  PIC_WDMA_DMA0_INT_FO_EOI_ERR_INT_FO_MASK 0x4
#define  PIC_WDMA_DMA0_INT_FO_EOI_ERR_INT_FO_SHIFT 2
#define  PIC_WDMA_DMA0_INT_FO_EOI_ERR_INT_FO_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA0_INT_FO_EOI_ERR_INT_FO_MASK) >> PIC_WDMA_DMA0_INT_FO_EOI_ERR_INT_FO_SHIFT)
#define  PIC_WDMA_DMA0_INT_FO_EOI_ERR_INT_FO_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA0_INT_FO_EOI_ERR_INT_FO_MASK) | (((uint32_t)val) << PIC_WDMA_DMA0_INT_FO_EOI_ERR_INT_FO_SHIFT))

#define  PIC_WDMA_DMA0_INT_FO_FIN_INT_FO_MASK 0x2
#define  PIC_WDMA_DMA0_INT_FO_FIN_INT_FO_SHIFT 1
#define  PIC_WDMA_DMA0_INT_FO_FIN_INT_FO_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA0_INT_FO_FIN_INT_FO_MASK) >> PIC_WDMA_DMA0_INT_FO_FIN_INT_FO_SHIFT)
#define  PIC_WDMA_DMA0_INT_FO_FIN_INT_FO_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA0_INT_FO_FIN_INT_FO_MASK) | (((uint32_t)val) << PIC_WDMA_DMA0_INT_FO_FIN_INT_FO_SHIFT))

#define  PIC_WDMA_DMA0_INT_FO_WHO_INT_FO_MASK 0x1
#define  PIC_WDMA_DMA0_INT_FO_WHO_INT_FO_SHIFT 0
#define  PIC_WDMA_DMA0_INT_FO_WHO_INT_FO_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA0_INT_FO_WHO_INT_FO_MASK) >> PIC_WDMA_DMA0_INT_FO_WHO_INT_FO_SHIFT)
#define  PIC_WDMA_DMA0_INT_FO_WHO_INT_FO_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA0_INT_FO_WHO_INT_FO_MASK) | (((uint32_t)val) << PIC_WDMA_DMA0_INT_FO_WHO_INT_FO_SHIFT))

//====================================================================
//Register: Descriptor Write Register (desc_write)
//====================================================================

#define  PIC_WDMA_DMA0_DESC_WRITE_DESC_MASK 0xfffffffc
#define  PIC_WDMA_DMA0_DESC_WRITE_DESC_SHIFT 2
#define  PIC_WDMA_DMA0_DESC_WRITE_DESC_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA0_DESC_WRITE_DESC_MASK) >> PIC_WDMA_DMA0_DESC_WRITE_DESC_SHIFT)
#define  PIC_WDMA_DMA0_DESC_WRITE_DESC_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA0_DESC_WRITE_DESC_MASK) | (((uint32_t)val) << PIC_WDMA_DMA0_DESC_WRITE_DESC_SHIFT))

#define  PIC_WDMA_DMA0_DESC_WRITE_RESERVED1_MASK 0x3
#define  PIC_WDMA_DMA0_DESC_WRITE_RESERVED1_SHIFT 0
#define  PIC_WDMA_DMA0_DESC_WRITE_RESERVED1_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA0_DESC_WRITE_RESERVED1_MASK) >> PIC_WDMA_DMA0_DESC_WRITE_RESERVED1_SHIFT)
#define  PIC_WDMA_DMA0_DESC_WRITE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA0_DESC_WRITE_RESERVED1_MASK) | (((uint32_t)val) << PIC_WDMA_DMA0_DESC_WRITE_RESERVED1_SHIFT))

//====================================================================
//Register: Descriptor Read Register (desc_read)
//====================================================================

#define  PIC_WDMA_DMA0_DESC_READ_DESC_MASK 0xffffffff
#define  PIC_WDMA_DMA0_DESC_READ_DESC_SHIFT 0
#define  PIC_WDMA_DMA0_DESC_READ_DESC_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA0_DESC_READ_DESC_MASK) >> PIC_WDMA_DMA0_DESC_READ_DESC_SHIFT)
#define  PIC_WDMA_DMA0_DESC_READ_DESC_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA0_DESC_READ_DESC_MASK) | (((uint32_t)val) << PIC_WDMA_DMA0_DESC_READ_DESC_SHIFT))

//====================================================================
//Register: Descriptor Transfer Length Register (xfer_length)
//====================================================================

#define  PIC_WDMA_DMA0_XFER_LENGTH_LEN_MASK 0xffffffff
#define  PIC_WDMA_DMA0_XFER_LENGTH_LEN_SHIFT 0
#define  PIC_WDMA_DMA0_XFER_LENGTH_LEN_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA0_XFER_LENGTH_LEN_MASK) >> PIC_WDMA_DMA0_XFER_LENGTH_LEN_SHIFT)
#define  PIC_WDMA_DMA0_XFER_LENGTH_LEN_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA0_XFER_LENGTH_LEN_MASK) | (((uint32_t)val) << PIC_WDMA_DMA0_XFER_LENGTH_LEN_SHIFT))

//====================================================================
//Register: Descriptor Transfer Address Register (xfer_addr)
//====================================================================

#define  PIC_WDMA_DMA0_XFER_ADDR_ADDR_MASK 0xffffffff
#define  PIC_WDMA_DMA0_XFER_ADDR_ADDR_SHIFT 0
#define  PIC_WDMA_DMA0_XFER_ADDR_ADDR_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA0_XFER_ADDR_ADDR_MASK) >> PIC_WDMA_DMA0_XFER_ADDR_ADDR_SHIFT)
#define  PIC_WDMA_DMA0_XFER_ADDR_ADDR_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA0_XFER_ADDR_ADDR_MASK) | (((uint32_t)val) << PIC_WDMA_DMA0_XFER_ADDR_ADDR_SHIFT))

//====================================================================
//Register: Descriptor Transfer Burst Register (xfer_burst)
//====================================================================

#define  PIC_WDMA_DMA0_XFER_BURST_RESERVED1_MASK 0xffffffe0
#define  PIC_WDMA_DMA0_XFER_BURST_RESERVED1_SHIFT 5
#define  PIC_WDMA_DMA0_XFER_BURST_RESERVED1_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA0_XFER_BURST_RESERVED1_MASK) >> PIC_WDMA_DMA0_XFER_BURST_RESERVED1_SHIFT)
#define  PIC_WDMA_DMA0_XFER_BURST_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA0_XFER_BURST_RESERVED1_MASK) | (((uint32_t)val) << PIC_WDMA_DMA0_XFER_BURST_RESERVED1_SHIFT))

#define  PIC_WDMA_DMA0_XFER_BURST_BURST_MASK 0x1f
#define  PIC_WDMA_DMA0_XFER_BURST_BURST_SHIFT 0
#define  PIC_WDMA_DMA0_XFER_BURST_BURST_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA0_XFER_BURST_BURST_MASK) >> PIC_WDMA_DMA0_XFER_BURST_BURST_SHIFT)
#define  PIC_WDMA_DMA0_XFER_BURST_BURST_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA0_XFER_BURST_BURST_MASK) | (((uint32_t)val) << PIC_WDMA_DMA0_XFER_BURST_BURST_SHIFT))

//====================================================================
//Register: Soft Reset register (reset)
//====================================================================

#define  PIC_WDMA_DMA0_RESET_RESERVED1_MASK 0xfffffffc
#define  PIC_WDMA_DMA0_RESET_RESERVED1_SHIFT 2
#define  PIC_WDMA_DMA0_RESET_RESERVED1_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA0_RESET_RESERVED1_MASK) >> PIC_WDMA_DMA0_RESET_RESERVED1_SHIFT)
#define  PIC_WDMA_DMA0_RESET_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA0_RESET_RESERVED1_MASK) | (((uint32_t)val) << PIC_WDMA_DMA0_RESET_RESERVED1_SHIFT))

#define  PIC_WDMA_DMA0_RESET_FORCE_LAST_BURST_MASK 0x2
#define  PIC_WDMA_DMA0_RESET_FORCE_LAST_BURST_SHIFT 1
#define  PIC_WDMA_DMA0_RESET_FORCE_LAST_BURST_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA0_RESET_FORCE_LAST_BURST_MASK) >> PIC_WDMA_DMA0_RESET_FORCE_LAST_BURST_SHIFT)
#define  PIC_WDMA_DMA0_RESET_FORCE_LAST_BURST_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA0_RESET_FORCE_LAST_BURST_MASK) | (((uint32_t)val) << PIC_WDMA_DMA0_RESET_FORCE_LAST_BURST_SHIFT))

#define  PIC_WDMA_DMA0_RESET_SOFT_RESET_MASK 0x1
#define  PIC_WDMA_DMA0_RESET_SOFT_RESET_SHIFT 0
#define  PIC_WDMA_DMA0_RESET_SOFT_RESET_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA0_RESET_SOFT_RESET_MASK) >> PIC_WDMA_DMA0_RESET_SOFT_RESET_SHIFT)
#define  PIC_WDMA_DMA0_RESET_SOFT_RESET_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA0_RESET_SOFT_RESET_MASK) | (((uint32_t)val) << PIC_WDMA_DMA0_RESET_SOFT_RESET_SHIFT))

//====================================================================
//Register: IP Tagging Revision 0 (REV0)
/** \brief Provide means for firmware to read IP tagging information.
      This register of particular interest to firmware.*/
//====================================================================

#define  PIC_WDMA_DMA0_REV0_MAJ_MASK 0xffff0000
#define  PIC_WDMA_DMA0_REV0_MAJ_SHIFT 16
#define  PIC_WDMA_DMA0_REV0_MAJ_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA0_REV0_MAJ_MASK) >> PIC_WDMA_DMA0_REV0_MAJ_SHIFT)
#define  PIC_WDMA_DMA0_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA0_REV0_MAJ_MASK) | (((uint32_t)val) << PIC_WDMA_DMA0_REV0_MAJ_SHIFT))

#define  PIC_WDMA_DMA0_REV0_MID_MASK 0xffff
#define  PIC_WDMA_DMA0_REV0_MID_SHIFT 0
#define  PIC_WDMA_DMA0_REV0_MID_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA0_REV0_MID_MASK) >> PIC_WDMA_DMA0_REV0_MID_SHIFT)
#define  PIC_WDMA_DMA0_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA0_REV0_MID_MASK) | (((uint32_t)val) << PIC_WDMA_DMA0_REV0_MID_SHIFT))

//====================================================================
//Register: IP Tagging Revision 1 (REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  PIC_WDMA_DMA0_REV1_RESERVED1_MASK 0xffff0000
#define  PIC_WDMA_DMA0_REV1_RESERVED1_SHIFT 16
#define  PIC_WDMA_DMA0_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA0_REV1_RESERVED1_MASK) >> PIC_WDMA_DMA0_REV1_RESERVED1_SHIFT)
#define  PIC_WDMA_DMA0_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA0_REV1_RESERVED1_MASK) | (((uint32_t)val) << PIC_WDMA_DMA0_REV1_RESERVED1_SHIFT))

#define  PIC_WDMA_DMA0_REV1_CFG_MASK 0xffff
#define  PIC_WDMA_DMA0_REV1_CFG_SHIFT 0
#define  PIC_WDMA_DMA0_REV1_CFG_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA0_REV1_CFG_MASK) >> PIC_WDMA_DMA0_REV1_CFG_SHIFT)
#define  PIC_WDMA_DMA0_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA0_REV1_CFG_MASK) | (((uint32_t)val) << PIC_WDMA_DMA0_REV1_CFG_SHIFT))

//====================================================================
//
//Register File: DMA channel (Instance 2 of 3) (PIC_WDMA_DMA1)
/** \brief Register Descriptions for the ODMA_AXI block (rev 0 . 4 . 3 . 1)*/
//
//====================================================================

//====================================================================
//Register: Configuration register (cfg)
//====================================================================

#define  PIC_WDMA_DMA1_CFG_RESERVED1_MASK 0xfe000000
#define  PIC_WDMA_DMA1_CFG_RESERVED1_SHIFT 25
#define  PIC_WDMA_DMA1_CFG_RESERVED1_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA1_CFG_RESERVED1_MASK) >> PIC_WDMA_DMA1_CFG_RESERVED1_SHIFT)
#define  PIC_WDMA_DMA1_CFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA1_CFG_RESERVED1_MASK) | (((uint32_t)val) << PIC_WDMA_DMA1_CFG_RESERVED1_SHIFT))

#define  PIC_WDMA_DMA1_CFG_HANDSHAKEENABLE_MASK 0x1000000
#define  PIC_WDMA_DMA1_CFG_HANDSHAKEENABLE_SHIFT 24
#define  PIC_WDMA_DMA1_CFG_HANDSHAKEENABLE_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA1_CFG_HANDSHAKEENABLE_MASK) >> PIC_WDMA_DMA1_CFG_HANDSHAKEENABLE_SHIFT)
#define  PIC_WDMA_DMA1_CFG_HANDSHAKEENABLE_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA1_CFG_HANDSHAKEENABLE_MASK) | (((uint32_t)val) << PIC_WDMA_DMA1_CFG_HANDSHAKEENABLE_SHIFT))

#define  PIC_WDMA_DMA1_CFG_OWNPOLARITY_MASK 0x800000
#define  PIC_WDMA_DMA1_CFG_OWNPOLARITY_SHIFT 23
#define  PIC_WDMA_DMA1_CFG_OWNPOLARITY_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA1_CFG_OWNPOLARITY_MASK) >> PIC_WDMA_DMA1_CFG_OWNPOLARITY_SHIFT)
#define  PIC_WDMA_DMA1_CFG_OWNPOLARITY_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA1_CFG_OWNPOLARITY_MASK) | (((uint32_t)val) << PIC_WDMA_DMA1_CFG_OWNPOLARITY_SHIFT))

#define  PIC_WDMA_DMA1_CFG_OWNWRITEDISABLE_MASK 0x400000
#define  PIC_WDMA_DMA1_CFG_OWNWRITEDISABLE_SHIFT 22
#define  PIC_WDMA_DMA1_CFG_OWNWRITEDISABLE_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA1_CFG_OWNWRITEDISABLE_MASK) >> PIC_WDMA_DMA1_CFG_OWNWRITEDISABLE_SHIFT)
#define  PIC_WDMA_DMA1_CFG_OWNWRITEDISABLE_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA1_CFG_OWNWRITEDISABLE_MASK) | (((uint32_t)val) << PIC_WDMA_DMA1_CFG_OWNWRITEDISABLE_SHIFT))

#define  PIC_WDMA_DMA1_CFG_SERPENTINE_MASK 0x200000
#define  PIC_WDMA_DMA1_CFG_SERPENTINE_SHIFT 21
#define  PIC_WDMA_DMA1_CFG_SERPENTINE_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA1_CFG_SERPENTINE_MASK) >> PIC_WDMA_DMA1_CFG_SERPENTINE_SHIFT)
#define  PIC_WDMA_DMA1_CFG_SERPENTINE_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA1_CFG_SERPENTINE_MASK) | (((uint32_t)val) << PIC_WDMA_DMA1_CFG_SERPENTINE_SHIFT))

#define  PIC_WDMA_DMA1_CFG_LINE_REV_MASK 0x100000
#define  PIC_WDMA_DMA1_CFG_LINE_REV_SHIFT 20
#define  PIC_WDMA_DMA1_CFG_LINE_REV_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA1_CFG_LINE_REV_MASK) >> PIC_WDMA_DMA1_CFG_LINE_REV_SHIFT)
#define  PIC_WDMA_DMA1_CFG_LINE_REV_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA1_CFG_LINE_REV_MASK) | (((uint32_t)val) << PIC_WDMA_DMA1_CFG_LINE_REV_SHIFT))

#define  PIC_WDMA_DMA1_CFG_TRAN_REV_MASK 0x80000
#define  PIC_WDMA_DMA1_CFG_TRAN_REV_SHIFT 19
#define  PIC_WDMA_DMA1_CFG_TRAN_REV_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA1_CFG_TRAN_REV_MASK) >> PIC_WDMA_DMA1_CFG_TRAN_REV_SHIFT)
#define  PIC_WDMA_DMA1_CFG_TRAN_REV_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA1_CFG_TRAN_REV_MASK) | (((uint32_t)val) << PIC_WDMA_DMA1_CFG_TRAN_REV_SHIFT))

#define  PIC_WDMA_DMA1_CFG_UPPER_HALF_MASK 0x40000
#define  PIC_WDMA_DMA1_CFG_UPPER_HALF_SHIFT 18
#define  PIC_WDMA_DMA1_CFG_UPPER_HALF_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA1_CFG_UPPER_HALF_MASK) >> PIC_WDMA_DMA1_CFG_UPPER_HALF_SHIFT)
#define  PIC_WDMA_DMA1_CFG_UPPER_HALF_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA1_CFG_UPPER_HALF_MASK) | (((uint32_t)val) << PIC_WDMA_DMA1_CFG_UPPER_HALF_SHIFT))

#define  PIC_WDMA_DMA1_CFG_MSB_IN_MASK 0x20000
#define  PIC_WDMA_DMA1_CFG_MSB_IN_SHIFT 17
#define  PIC_WDMA_DMA1_CFG_MSB_IN_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA1_CFG_MSB_IN_MASK) >> PIC_WDMA_DMA1_CFG_MSB_IN_SHIFT)
#define  PIC_WDMA_DMA1_CFG_MSB_IN_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA1_CFG_MSB_IN_MASK) | (((uint32_t)val) << PIC_WDMA_DMA1_CFG_MSB_IN_SHIFT))

#define  PIC_WDMA_DMA1_CFG_ENABLE_MASK 0x10000
#define  PIC_WDMA_DMA1_CFG_ENABLE_SHIFT 16
#define  PIC_WDMA_DMA1_CFG_ENABLE_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA1_CFG_ENABLE_MASK) >> PIC_WDMA_DMA1_CFG_ENABLE_SHIFT)
#define  PIC_WDMA_DMA1_CFG_ENABLE_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA1_CFG_ENABLE_MASK) | (((uint32_t)val) << PIC_WDMA_DMA1_CFG_ENABLE_SHIFT))

#define  PIC_WDMA_DMA1_CFG_RESERVED2_MASK 0xf800
#define  PIC_WDMA_DMA1_CFG_RESERVED2_SHIFT 11
#define  PIC_WDMA_DMA1_CFG_RESERVED2_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA1_CFG_RESERVED2_MASK) >> PIC_WDMA_DMA1_CFG_RESERVED2_SHIFT)
#define  PIC_WDMA_DMA1_CFG_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA1_CFG_RESERVED2_MASK) | (((uint32_t)val) << PIC_WDMA_DMA1_CFG_RESERVED2_SHIFT))

#define  PIC_WDMA_DMA1_CFG_IN_WIDTH_MASK 0x700
#define  PIC_WDMA_DMA1_CFG_IN_WIDTH_SHIFT 8
#define  PIC_WDMA_DMA1_CFG_IN_WIDTH_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA1_CFG_IN_WIDTH_MASK) >> PIC_WDMA_DMA1_CFG_IN_WIDTH_SHIFT)
#define  PIC_WDMA_DMA1_CFG_IN_WIDTH_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA1_CFG_IN_WIDTH_MASK) | (((uint32_t)val) << PIC_WDMA_DMA1_CFG_IN_WIDTH_SHIFT))

#define  PIC_WDMA_DMA1_CFG_RESERVED3_MASK 0xfc
#define  PIC_WDMA_DMA1_CFG_RESERVED3_SHIFT 2
#define  PIC_WDMA_DMA1_CFG_RESERVED3_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA1_CFG_RESERVED3_MASK) >> PIC_WDMA_DMA1_CFG_RESERVED3_SHIFT)
#define  PIC_WDMA_DMA1_CFG_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA1_CFG_RESERVED3_MASK) | (((uint32_t)val) << PIC_WDMA_DMA1_CFG_RESERVED3_SHIFT))

#define  PIC_WDMA_DMA1_CFG_BURST_LEN_MASK 0x3
#define  PIC_WDMA_DMA1_CFG_BURST_LEN_SHIFT 0
#define  PIC_WDMA_DMA1_CFG_BURST_LEN_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA1_CFG_BURST_LEN_MASK) >> PIC_WDMA_DMA1_CFG_BURST_LEN_SHIFT)
#define  PIC_WDMA_DMA1_CFG_BURST_LEN_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA1_CFG_BURST_LEN_MASK) | (((uint32_t)val) << PIC_WDMA_DMA1_CFG_BURST_LEN_SHIFT))

//====================================================================
//Register: Status register (status)
//====================================================================

#define  PIC_WDMA_DMA1_STATUS_RESERVED1_MASK 0xff000000
#define  PIC_WDMA_DMA1_STATUS_RESERVED1_SHIFT 24
#define  PIC_WDMA_DMA1_STATUS_RESERVED1_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA1_STATUS_RESERVED1_MASK) >> PIC_WDMA_DMA1_STATUS_RESERVED1_SHIFT)
#define  PIC_WDMA_DMA1_STATUS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA1_STATUS_RESERVED1_MASK) | (((uint32_t)val) << PIC_WDMA_DMA1_STATUS_RESERVED1_SHIFT))

#define  PIC_WDMA_DMA1_STATUS_BYTESWAITING_MASK 0xff0000
#define  PIC_WDMA_DMA1_STATUS_BYTESWAITING_SHIFT 16
#define  PIC_WDMA_DMA1_STATUS_BYTESWAITING_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA1_STATUS_BYTESWAITING_MASK) >> PIC_WDMA_DMA1_STATUS_BYTESWAITING_SHIFT)
#define  PIC_WDMA_DMA1_STATUS_BYTESWAITING_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA1_STATUS_BYTESWAITING_MASK) | (((uint32_t)val) << PIC_WDMA_DMA1_STATUS_BYTESWAITING_SHIFT))

#define  PIC_WDMA_DMA1_STATUS_RESERVED2_MASK 0x8000
#define  PIC_WDMA_DMA1_STATUS_RESERVED2_SHIFT 15
#define  PIC_WDMA_DMA1_STATUS_RESERVED2_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA1_STATUS_RESERVED2_MASK) >> PIC_WDMA_DMA1_STATUS_RESERVED2_SHIFT)
#define  PIC_WDMA_DMA1_STATUS_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA1_STATUS_RESERVED2_MASK) | (((uint32_t)val) << PIC_WDMA_DMA1_STATUS_RESERVED2_SHIFT))

#define  PIC_WDMA_DMA1_STATUS_FORCE_BURST_BUSY_MASK 0x4000
#define  PIC_WDMA_DMA1_STATUS_FORCE_BURST_BUSY_SHIFT 14
#define  PIC_WDMA_DMA1_STATUS_FORCE_BURST_BUSY_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA1_STATUS_FORCE_BURST_BUSY_MASK) >> PIC_WDMA_DMA1_STATUS_FORCE_BURST_BUSY_SHIFT)
#define  PIC_WDMA_DMA1_STATUS_FORCE_BURST_BUSY_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA1_STATUS_FORCE_BURST_BUSY_MASK) | (((uint32_t)val) << PIC_WDMA_DMA1_STATUS_FORCE_BURST_BUSY_SHIFT))

#define  PIC_WDMA_DMA1_STATUS_DMAPAUSED_MASK 0x2000
#define  PIC_WDMA_DMA1_STATUS_DMAPAUSED_SHIFT 13
#define  PIC_WDMA_DMA1_STATUS_DMAPAUSED_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA1_STATUS_DMAPAUSED_MASK) >> PIC_WDMA_DMA1_STATUS_DMAPAUSED_SHIFT)
#define  PIC_WDMA_DMA1_STATUS_DMAPAUSED_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA1_STATUS_DMAPAUSED_MASK) | (((uint32_t)val) << PIC_WDMA_DMA1_STATUS_DMAPAUSED_SHIFT))

#define  PIC_WDMA_DMA1_STATUS_PAUSEAFTER_MASK 0x1000
#define  PIC_WDMA_DMA1_STATUS_PAUSEAFTER_SHIFT 12
#define  PIC_WDMA_DMA1_STATUS_PAUSEAFTER_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA1_STATUS_PAUSEAFTER_MASK) >> PIC_WDMA_DMA1_STATUS_PAUSEAFTER_SHIFT)
#define  PIC_WDMA_DMA1_STATUS_PAUSEAFTER_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA1_STATUS_PAUSEAFTER_MASK) | (((uint32_t)val) << PIC_WDMA_DMA1_STATUS_PAUSEAFTER_SHIFT))

#define  PIC_WDMA_DMA1_STATUS_PAUSEBEFORE_MASK 0x800
#define  PIC_WDMA_DMA1_STATUS_PAUSEBEFORE_SHIFT 11
#define  PIC_WDMA_DMA1_STATUS_PAUSEBEFORE_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA1_STATUS_PAUSEBEFORE_MASK) >> PIC_WDMA_DMA1_STATUS_PAUSEBEFORE_SHIFT)
#define  PIC_WDMA_DMA1_STATUS_PAUSEBEFORE_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA1_STATUS_PAUSEBEFORE_MASK) | (((uint32_t)val) << PIC_WDMA_DMA1_STATUS_PAUSEBEFORE_SHIFT))

#define  PIC_WDMA_DMA1_STATUS_DESC_OWN_MASK 0x400
#define  PIC_WDMA_DMA1_STATUS_DESC_OWN_SHIFT 10
#define  PIC_WDMA_DMA1_STATUS_DESC_OWN_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA1_STATUS_DESC_OWN_MASK) >> PIC_WDMA_DMA1_STATUS_DESC_OWN_SHIFT)
#define  PIC_WDMA_DMA1_STATUS_DESC_OWN_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA1_STATUS_DESC_OWN_MASK) | (((uint32_t)val) << PIC_WDMA_DMA1_STATUS_DESC_OWN_SHIFT))

#define  PIC_WDMA_DMA1_STATUS_DESC_EOI_MASK 0x200
#define  PIC_WDMA_DMA1_STATUS_DESC_EOI_SHIFT 9
#define  PIC_WDMA_DMA1_STATUS_DESC_EOI_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA1_STATUS_DESC_EOI_MASK) >> PIC_WDMA_DMA1_STATUS_DESC_EOI_SHIFT)
#define  PIC_WDMA_DMA1_STATUS_DESC_EOI_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA1_STATUS_DESC_EOI_MASK) | (((uint32_t)val) << PIC_WDMA_DMA1_STATUS_DESC_EOI_SHIFT))

#define  PIC_WDMA_DMA1_STATUS_DESC_SOI_MASK 0x100
#define  PIC_WDMA_DMA1_STATUS_DESC_SOI_SHIFT 8
#define  PIC_WDMA_DMA1_STATUS_DESC_SOI_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA1_STATUS_DESC_SOI_MASK) >> PIC_WDMA_DMA1_STATUS_DESC_SOI_SHIFT)
#define  PIC_WDMA_DMA1_STATUS_DESC_SOI_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA1_STATUS_DESC_SOI_MASK) | (((uint32_t)val) << PIC_WDMA_DMA1_STATUS_DESC_SOI_SHIFT))

#define  PIC_WDMA_DMA1_STATUS_REVERSE_MASK 0x80
#define  PIC_WDMA_DMA1_STATUS_REVERSE_SHIFT 7
#define  PIC_WDMA_DMA1_STATUS_REVERSE_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA1_STATUS_REVERSE_MASK) >> PIC_WDMA_DMA1_STATUS_REVERSE_SHIFT)
#define  PIC_WDMA_DMA1_STATUS_REVERSE_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA1_STATUS_REVERSE_MASK) | (((uint32_t)val) << PIC_WDMA_DMA1_STATUS_REVERSE_SHIFT))

#define  PIC_WDMA_DMA1_STATUS_SOFTRESET_MASK 0x40
#define  PIC_WDMA_DMA1_STATUS_SOFTRESET_SHIFT 6
#define  PIC_WDMA_DMA1_STATUS_SOFTRESET_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA1_STATUS_SOFTRESET_MASK) >> PIC_WDMA_DMA1_STATUS_SOFTRESET_SHIFT)
#define  PIC_WDMA_DMA1_STATUS_SOFTRESET_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA1_STATUS_SOFTRESET_MASK) | (((uint32_t)val) << PIC_WDMA_DMA1_STATUS_SOFTRESET_SHIFT))

#define  PIC_WDMA_DMA1_STATUS_FULL_CBUF_MASK 0x20
#define  PIC_WDMA_DMA1_STATUS_FULL_CBUF_SHIFT 5
#define  PIC_WDMA_DMA1_STATUS_FULL_CBUF_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA1_STATUS_FULL_CBUF_MASK) >> PIC_WDMA_DMA1_STATUS_FULL_CBUF_SHIFT)
#define  PIC_WDMA_DMA1_STATUS_FULL_CBUF_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA1_STATUS_FULL_CBUF_MASK) | (((uint32_t)val) << PIC_WDMA_DMA1_STATUS_FULL_CBUF_SHIFT))

#define  PIC_WDMA_DMA1_STATUS_EMPTY_CBUF_MASK 0x10
#define  PIC_WDMA_DMA1_STATUS_EMPTY_CBUF_SHIFT 4
#define  PIC_WDMA_DMA1_STATUS_EMPTY_CBUF_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA1_STATUS_EMPTY_CBUF_MASK) >> PIC_WDMA_DMA1_STATUS_EMPTY_CBUF_SHIFT)
#define  PIC_WDMA_DMA1_STATUS_EMPTY_CBUF_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA1_STATUS_EMPTY_CBUF_MASK) | (((uint32_t)val) << PIC_WDMA_DMA1_STATUS_EMPTY_CBUF_SHIFT))

#define  PIC_WDMA_DMA1_STATUS_FULL_DBUF_MASK 0x8
#define  PIC_WDMA_DMA1_STATUS_FULL_DBUF_SHIFT 3
#define  PIC_WDMA_DMA1_STATUS_FULL_DBUF_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA1_STATUS_FULL_DBUF_MASK) >> PIC_WDMA_DMA1_STATUS_FULL_DBUF_SHIFT)
#define  PIC_WDMA_DMA1_STATUS_FULL_DBUF_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA1_STATUS_FULL_DBUF_MASK) | (((uint32_t)val) << PIC_WDMA_DMA1_STATUS_FULL_DBUF_SHIFT))

#define  PIC_WDMA_DMA1_STATUS_EMPTY_DBUF_MASK 0x4
#define  PIC_WDMA_DMA1_STATUS_EMPTY_DBUF_SHIFT 2
#define  PIC_WDMA_DMA1_STATUS_EMPTY_DBUF_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA1_STATUS_EMPTY_DBUF_MASK) >> PIC_WDMA_DMA1_STATUS_EMPTY_DBUF_SHIFT)
#define  PIC_WDMA_DMA1_STATUS_EMPTY_DBUF_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA1_STATUS_EMPTY_DBUF_MASK) | (((uint32_t)val) << PIC_WDMA_DMA1_STATUS_EMPTY_DBUF_SHIFT))

#define  PIC_WDMA_DMA1_STATUS_PACKER_EMPTY_MASK 0x2
#define  PIC_WDMA_DMA1_STATUS_PACKER_EMPTY_SHIFT 1
#define  PIC_WDMA_DMA1_STATUS_PACKER_EMPTY_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA1_STATUS_PACKER_EMPTY_MASK) >> PIC_WDMA_DMA1_STATUS_PACKER_EMPTY_SHIFT)
#define  PIC_WDMA_DMA1_STATUS_PACKER_EMPTY_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA1_STATUS_PACKER_EMPTY_MASK) | (((uint32_t)val) << PIC_WDMA_DMA1_STATUS_PACKER_EMPTY_SHIFT))

#define  PIC_WDMA_DMA1_STATUS_DMA_BUSY_MASK 0x1
#define  PIC_WDMA_DMA1_STATUS_DMA_BUSY_SHIFT 0
#define  PIC_WDMA_DMA1_STATUS_DMA_BUSY_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA1_STATUS_DMA_BUSY_MASK) >> PIC_WDMA_DMA1_STATUS_DMA_BUSY_SHIFT)
#define  PIC_WDMA_DMA1_STATUS_DMA_BUSY_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA1_STATUS_DMA_BUSY_MASK) | (((uint32_t)val) << PIC_WDMA_DMA1_STATUS_DMA_BUSY_SHIFT))

//====================================================================
//Register: Line Size Register (line_size)
//====================================================================

#define  PIC_WDMA_DMA1_LINE_SIZE_RESERVED1_MASK 0xfffc0000
#define  PIC_WDMA_DMA1_LINE_SIZE_RESERVED1_SHIFT 18
#define  PIC_WDMA_DMA1_LINE_SIZE_RESERVED1_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA1_LINE_SIZE_RESERVED1_MASK) >> PIC_WDMA_DMA1_LINE_SIZE_RESERVED1_SHIFT)
#define  PIC_WDMA_DMA1_LINE_SIZE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA1_LINE_SIZE_RESERVED1_MASK) | (((uint32_t)val) << PIC_WDMA_DMA1_LINE_SIZE_RESERVED1_SHIFT))

#define  PIC_WDMA_DMA1_LINE_SIZE_LINE_SIZE_MASK 0x3ffff
#define  PIC_WDMA_DMA1_LINE_SIZE_LINE_SIZE_SHIFT 0
#define  PIC_WDMA_DMA1_LINE_SIZE_LINE_SIZE_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA1_LINE_SIZE_LINE_SIZE_MASK) >> PIC_WDMA_DMA1_LINE_SIZE_LINE_SIZE_SHIFT)
#define  PIC_WDMA_DMA1_LINE_SIZE_LINE_SIZE_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA1_LINE_SIZE_LINE_SIZE_MASK) | (((uint32_t)val) << PIC_WDMA_DMA1_LINE_SIZE_LINE_SIZE_SHIFT))

//====================================================================
//Register: Interrupt Enable Register (int_en)
//====================================================================

#define  PIC_WDMA_DMA1_INT_EN_RESERVED1_MASK 0xfffff800
#define  PIC_WDMA_DMA1_INT_EN_RESERVED1_SHIFT 11
#define  PIC_WDMA_DMA1_INT_EN_RESERVED1_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA1_INT_EN_RESERVED1_MASK) >> PIC_WDMA_DMA1_INT_EN_RESERVED1_SHIFT)
#define  PIC_WDMA_DMA1_INT_EN_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA1_INT_EN_RESERVED1_MASK) | (((uint32_t)val) << PIC_WDMA_DMA1_INT_EN_RESERVED1_SHIFT))

#define  PIC_WDMA_DMA1_INT_EN_RRESP_INT_EN_MASK 0x400
#define  PIC_WDMA_DMA1_INT_EN_RRESP_INT_EN_SHIFT 10
#define  PIC_WDMA_DMA1_INT_EN_RRESP_INT_EN_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA1_INT_EN_RRESP_INT_EN_MASK) >> PIC_WDMA_DMA1_INT_EN_RRESP_INT_EN_SHIFT)
#define  PIC_WDMA_DMA1_INT_EN_RRESP_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA1_INT_EN_RRESP_INT_EN_MASK) | (((uint32_t)val) << PIC_WDMA_DMA1_INT_EN_RRESP_INT_EN_SHIFT))

#define  PIC_WDMA_DMA1_INT_EN_BRESP_INT_EN_MASK 0x200
#define  PIC_WDMA_DMA1_INT_EN_BRESP_INT_EN_SHIFT 9
#define  PIC_WDMA_DMA1_INT_EN_BRESP_INT_EN_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA1_INT_EN_BRESP_INT_EN_MASK) >> PIC_WDMA_DMA1_INT_EN_BRESP_INT_EN_SHIFT)
#define  PIC_WDMA_DMA1_INT_EN_BRESP_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA1_INT_EN_BRESP_INT_EN_MASK) | (((uint32_t)val) << PIC_WDMA_DMA1_INT_EN_BRESP_INT_EN_SHIFT))

#define  PIC_WDMA_DMA1_INT_EN_RST_INT_EN_MASK 0x100
#define  PIC_WDMA_DMA1_INT_EN_RST_INT_EN_SHIFT 8
#define  PIC_WDMA_DMA1_INT_EN_RST_INT_EN_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA1_INT_EN_RST_INT_EN_MASK) >> PIC_WDMA_DMA1_INT_EN_RST_INT_EN_SHIFT)
#define  PIC_WDMA_DMA1_INT_EN_RST_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA1_INT_EN_RST_INT_EN_MASK) | (((uint32_t)val) << PIC_WDMA_DMA1_INT_EN_RST_INT_EN_SHIFT))

#define  PIC_WDMA_DMA1_INT_EN_EOI_INT_EN_MASK 0x80
#define  PIC_WDMA_DMA1_INT_EN_EOI_INT_EN_SHIFT 7
#define  PIC_WDMA_DMA1_INT_EN_EOI_INT_EN_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA1_INT_EN_EOI_INT_EN_MASK) >> PIC_WDMA_DMA1_INT_EN_EOI_INT_EN_SHIFT)
#define  PIC_WDMA_DMA1_INT_EN_EOI_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA1_INT_EN_EOI_INT_EN_MASK) | (((uint32_t)val) << PIC_WDMA_DMA1_INT_EN_EOI_INT_EN_SHIFT))

#define  PIC_WDMA_DMA1_INT_EN_DIR_INT_EN_MASK 0x40
#define  PIC_WDMA_DMA1_INT_EN_DIR_INT_EN_SHIFT 6
#define  PIC_WDMA_DMA1_INT_EN_DIR_INT_EN_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA1_INT_EN_DIR_INT_EN_MASK) >> PIC_WDMA_DMA1_INT_EN_DIR_INT_EN_SHIFT)
#define  PIC_WDMA_DMA1_INT_EN_DIR_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA1_INT_EN_DIR_INT_EN_MASK) | (((uint32_t)val) << PIC_WDMA_DMA1_INT_EN_DIR_INT_EN_SHIFT))

#define  PIC_WDMA_DMA1_INT_EN_CL_ALI_INT_EN_MASK 0x20
#define  PIC_WDMA_DMA1_INT_EN_CL_ALI_INT_EN_SHIFT 5
#define  PIC_WDMA_DMA1_INT_EN_CL_ALI_INT_EN_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA1_INT_EN_CL_ALI_INT_EN_MASK) >> PIC_WDMA_DMA1_INT_EN_CL_ALI_INT_EN_SHIFT)
#define  PIC_WDMA_DMA1_INT_EN_CL_ALI_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA1_INT_EN_CL_ALI_INT_EN_MASK) | (((uint32_t)val) << PIC_WDMA_DMA1_INT_EN_CL_ALI_INT_EN_SHIFT))

#define  PIC_WDMA_DMA1_INT_EN_EOL_ALI_INT_EN_MASK 0x10
#define  PIC_WDMA_DMA1_INT_EN_EOL_ALI_INT_EN_SHIFT 4
#define  PIC_WDMA_DMA1_INT_EN_EOL_ALI_INT_EN_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA1_INT_EN_EOL_ALI_INT_EN_MASK) >> PIC_WDMA_DMA1_INT_EN_EOL_ALI_INT_EN_SHIFT)
#define  PIC_WDMA_DMA1_INT_EN_EOL_ALI_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA1_INT_EN_EOL_ALI_INT_EN_MASK) | (((uint32_t)val) << PIC_WDMA_DMA1_INT_EN_EOL_ALI_INT_EN_SHIFT))

#define  PIC_WDMA_DMA1_INT_EN_EOI_ALI_INT_EN_MASK 0x8
#define  PIC_WDMA_DMA1_INT_EN_EOI_ALI_INT_EN_SHIFT 3
#define  PIC_WDMA_DMA1_INT_EN_EOI_ALI_INT_EN_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA1_INT_EN_EOI_ALI_INT_EN_MASK) >> PIC_WDMA_DMA1_INT_EN_EOI_ALI_INT_EN_SHIFT)
#define  PIC_WDMA_DMA1_INT_EN_EOI_ALI_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA1_INT_EN_EOI_ALI_INT_EN_MASK) | (((uint32_t)val) << PIC_WDMA_DMA1_INT_EN_EOI_ALI_INT_EN_SHIFT))

#define  PIC_WDMA_DMA1_INT_EN_EOI_ERR_INT_EN_MASK 0x4
#define  PIC_WDMA_DMA1_INT_EN_EOI_ERR_INT_EN_SHIFT 2
#define  PIC_WDMA_DMA1_INT_EN_EOI_ERR_INT_EN_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA1_INT_EN_EOI_ERR_INT_EN_MASK) >> PIC_WDMA_DMA1_INT_EN_EOI_ERR_INT_EN_SHIFT)
#define  PIC_WDMA_DMA1_INT_EN_EOI_ERR_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA1_INT_EN_EOI_ERR_INT_EN_MASK) | (((uint32_t)val) << PIC_WDMA_DMA1_INT_EN_EOI_ERR_INT_EN_SHIFT))

#define  PIC_WDMA_DMA1_INT_EN_FIN_INT_EN_MASK 0x2
#define  PIC_WDMA_DMA1_INT_EN_FIN_INT_EN_SHIFT 1
#define  PIC_WDMA_DMA1_INT_EN_FIN_INT_EN_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA1_INT_EN_FIN_INT_EN_MASK) >> PIC_WDMA_DMA1_INT_EN_FIN_INT_EN_SHIFT)
#define  PIC_WDMA_DMA1_INT_EN_FIN_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA1_INT_EN_FIN_INT_EN_MASK) | (((uint32_t)val) << PIC_WDMA_DMA1_INT_EN_FIN_INT_EN_SHIFT))

#define  PIC_WDMA_DMA1_INT_EN_WHO_INT_EN_MASK 0x1
#define  PIC_WDMA_DMA1_INT_EN_WHO_INT_EN_SHIFT 0
#define  PIC_WDMA_DMA1_INT_EN_WHO_INT_EN_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA1_INT_EN_WHO_INT_EN_MASK) >> PIC_WDMA_DMA1_INT_EN_WHO_INT_EN_SHIFT)
#define  PIC_WDMA_DMA1_INT_EN_WHO_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA1_INT_EN_WHO_INT_EN_MASK) | (((uint32_t)val) << PIC_WDMA_DMA1_INT_EN_WHO_INT_EN_SHIFT))

//====================================================================
//Register: Interrupt Pending Register (int_pend)
//====================================================================

#define  PIC_WDMA_DMA1_INT_PEND_RESERVED1_MASK 0xfffff800
#define  PIC_WDMA_DMA1_INT_PEND_RESERVED1_SHIFT 11
#define  PIC_WDMA_DMA1_INT_PEND_RESERVED1_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA1_INT_PEND_RESERVED1_MASK) >> PIC_WDMA_DMA1_INT_PEND_RESERVED1_SHIFT)
#define  PIC_WDMA_DMA1_INT_PEND_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA1_INT_PEND_RESERVED1_MASK) | (((uint32_t)val) << PIC_WDMA_DMA1_INT_PEND_RESERVED1_SHIFT))

#define  PIC_WDMA_DMA1_INT_PEND_RRESP_INT_PEND_MASK 0x400
#define  PIC_WDMA_DMA1_INT_PEND_RRESP_INT_PEND_SHIFT 10
#define  PIC_WDMA_DMA1_INT_PEND_RRESP_INT_PEND_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA1_INT_PEND_RRESP_INT_PEND_MASK) >> PIC_WDMA_DMA1_INT_PEND_RRESP_INT_PEND_SHIFT)
#define  PIC_WDMA_DMA1_INT_PEND_RRESP_INT_PEND_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA1_INT_PEND_RRESP_INT_PEND_MASK) | (((uint32_t)val) << PIC_WDMA_DMA1_INT_PEND_RRESP_INT_PEND_SHIFT))

#define  PIC_WDMA_DMA1_INT_PEND_BRESP_INT_PEND_MASK 0x200
#define  PIC_WDMA_DMA1_INT_PEND_BRESP_INT_PEND_SHIFT 9
#define  PIC_WDMA_DMA1_INT_PEND_BRESP_INT_PEND_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA1_INT_PEND_BRESP_INT_PEND_MASK) >> PIC_WDMA_DMA1_INT_PEND_BRESP_INT_PEND_SHIFT)
#define  PIC_WDMA_DMA1_INT_PEND_BRESP_INT_PEND_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA1_INT_PEND_BRESP_INT_PEND_MASK) | (((uint32_t)val) << PIC_WDMA_DMA1_INT_PEND_BRESP_INT_PEND_SHIFT))

#define  PIC_WDMA_DMA1_INT_PEND_RST_INT_PEND_MASK 0x100
#define  PIC_WDMA_DMA1_INT_PEND_RST_INT_PEND_SHIFT 8
#define  PIC_WDMA_DMA1_INT_PEND_RST_INT_PEND_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA1_INT_PEND_RST_INT_PEND_MASK) >> PIC_WDMA_DMA1_INT_PEND_RST_INT_PEND_SHIFT)
#define  PIC_WDMA_DMA1_INT_PEND_RST_INT_PEND_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA1_INT_PEND_RST_INT_PEND_MASK) | (((uint32_t)val) << PIC_WDMA_DMA1_INT_PEND_RST_INT_PEND_SHIFT))

#define  PIC_WDMA_DMA1_INT_PEND_EOI_INT_PEND_MASK 0x80
#define  PIC_WDMA_DMA1_INT_PEND_EOI_INT_PEND_SHIFT 7
#define  PIC_WDMA_DMA1_INT_PEND_EOI_INT_PEND_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA1_INT_PEND_EOI_INT_PEND_MASK) >> PIC_WDMA_DMA1_INT_PEND_EOI_INT_PEND_SHIFT)
#define  PIC_WDMA_DMA1_INT_PEND_EOI_INT_PEND_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA1_INT_PEND_EOI_INT_PEND_MASK) | (((uint32_t)val) << PIC_WDMA_DMA1_INT_PEND_EOI_INT_PEND_SHIFT))

#define  PIC_WDMA_DMA1_INT_PEND_DIR_INT_PEND_MASK 0x40
#define  PIC_WDMA_DMA1_INT_PEND_DIR_INT_PEND_SHIFT 6
#define  PIC_WDMA_DMA1_INT_PEND_DIR_INT_PEND_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA1_INT_PEND_DIR_INT_PEND_MASK) >> PIC_WDMA_DMA1_INT_PEND_DIR_INT_PEND_SHIFT)
#define  PIC_WDMA_DMA1_INT_PEND_DIR_INT_PEND_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA1_INT_PEND_DIR_INT_PEND_MASK) | (((uint32_t)val) << PIC_WDMA_DMA1_INT_PEND_DIR_INT_PEND_SHIFT))

#define  PIC_WDMA_DMA1_INT_PEND_CL_ALI_INT_PEND_MASK 0x20
#define  PIC_WDMA_DMA1_INT_PEND_CL_ALI_INT_PEND_SHIFT 5
#define  PIC_WDMA_DMA1_INT_PEND_CL_ALI_INT_PEND_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA1_INT_PEND_CL_ALI_INT_PEND_MASK) >> PIC_WDMA_DMA1_INT_PEND_CL_ALI_INT_PEND_SHIFT)
#define  PIC_WDMA_DMA1_INT_PEND_CL_ALI_INT_PEND_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA1_INT_PEND_CL_ALI_INT_PEND_MASK) | (((uint32_t)val) << PIC_WDMA_DMA1_INT_PEND_CL_ALI_INT_PEND_SHIFT))

#define  PIC_WDMA_DMA1_INT_PEND_EOL_ALI_INT_PEND_MASK 0x10
#define  PIC_WDMA_DMA1_INT_PEND_EOL_ALI_INT_PEND_SHIFT 4
#define  PIC_WDMA_DMA1_INT_PEND_EOL_ALI_INT_PEND_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA1_INT_PEND_EOL_ALI_INT_PEND_MASK) >> PIC_WDMA_DMA1_INT_PEND_EOL_ALI_INT_PEND_SHIFT)
#define  PIC_WDMA_DMA1_INT_PEND_EOL_ALI_INT_PEND_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA1_INT_PEND_EOL_ALI_INT_PEND_MASK) | (((uint32_t)val) << PIC_WDMA_DMA1_INT_PEND_EOL_ALI_INT_PEND_SHIFT))

#define  PIC_WDMA_DMA1_INT_PEND_EOI_ALI_INT_PEND_MASK 0x8
#define  PIC_WDMA_DMA1_INT_PEND_EOI_ALI_INT_PEND_SHIFT 3
#define  PIC_WDMA_DMA1_INT_PEND_EOI_ALI_INT_PEND_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA1_INT_PEND_EOI_ALI_INT_PEND_MASK) >> PIC_WDMA_DMA1_INT_PEND_EOI_ALI_INT_PEND_SHIFT)
#define  PIC_WDMA_DMA1_INT_PEND_EOI_ALI_INT_PEND_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA1_INT_PEND_EOI_ALI_INT_PEND_MASK) | (((uint32_t)val) << PIC_WDMA_DMA1_INT_PEND_EOI_ALI_INT_PEND_SHIFT))

#define  PIC_WDMA_DMA1_INT_PEND_EOI_ERR_INT_PEND_MASK 0x4
#define  PIC_WDMA_DMA1_INT_PEND_EOI_ERR_INT_PEND_SHIFT 2
#define  PIC_WDMA_DMA1_INT_PEND_EOI_ERR_INT_PEND_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA1_INT_PEND_EOI_ERR_INT_PEND_MASK) >> PIC_WDMA_DMA1_INT_PEND_EOI_ERR_INT_PEND_SHIFT)
#define  PIC_WDMA_DMA1_INT_PEND_EOI_ERR_INT_PEND_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA1_INT_PEND_EOI_ERR_INT_PEND_MASK) | (((uint32_t)val) << PIC_WDMA_DMA1_INT_PEND_EOI_ERR_INT_PEND_SHIFT))

#define  PIC_WDMA_DMA1_INT_PEND_FIN_INT_PEND_MASK 0x2
#define  PIC_WDMA_DMA1_INT_PEND_FIN_INT_PEND_SHIFT 1
#define  PIC_WDMA_DMA1_INT_PEND_FIN_INT_PEND_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA1_INT_PEND_FIN_INT_PEND_MASK) >> PIC_WDMA_DMA1_INT_PEND_FIN_INT_PEND_SHIFT)
#define  PIC_WDMA_DMA1_INT_PEND_FIN_INT_PEND_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA1_INT_PEND_FIN_INT_PEND_MASK) | (((uint32_t)val) << PIC_WDMA_DMA1_INT_PEND_FIN_INT_PEND_SHIFT))

#define  PIC_WDMA_DMA1_INT_PEND_WHO_INT_PEND_MASK 0x1
#define  PIC_WDMA_DMA1_INT_PEND_WHO_INT_PEND_SHIFT 0
#define  PIC_WDMA_DMA1_INT_PEND_WHO_INT_PEND_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA1_INT_PEND_WHO_INT_PEND_MASK) >> PIC_WDMA_DMA1_INT_PEND_WHO_INT_PEND_SHIFT)
#define  PIC_WDMA_DMA1_INT_PEND_WHO_INT_PEND_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA1_INT_PEND_WHO_INT_PEND_MASK) | (((uint32_t)val) << PIC_WDMA_DMA1_INT_PEND_WHO_INT_PEND_SHIFT))

//====================================================================
//Register: Interrupt Acknowledge Register (int_ack)
//====================================================================

#define  PIC_WDMA_DMA1_INT_ACK_RESERVED1_MASK 0xfffff800
#define  PIC_WDMA_DMA1_INT_ACK_RESERVED1_SHIFT 11
#define  PIC_WDMA_DMA1_INT_ACK_RESERVED1_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA1_INT_ACK_RESERVED1_MASK) >> PIC_WDMA_DMA1_INT_ACK_RESERVED1_SHIFT)
#define  PIC_WDMA_DMA1_INT_ACK_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA1_INT_ACK_RESERVED1_MASK) | (((uint32_t)val) << PIC_WDMA_DMA1_INT_ACK_RESERVED1_SHIFT))

#define  PIC_WDMA_DMA1_INT_ACK_RRESP_INT_ACK_MASK 0x400
#define  PIC_WDMA_DMA1_INT_ACK_RRESP_INT_ACK_SHIFT 10
#define  PIC_WDMA_DMA1_INT_ACK_RRESP_INT_ACK_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA1_INT_ACK_RRESP_INT_ACK_MASK) >> PIC_WDMA_DMA1_INT_ACK_RRESP_INT_ACK_SHIFT)
#define  PIC_WDMA_DMA1_INT_ACK_RRESP_INT_ACK_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA1_INT_ACK_RRESP_INT_ACK_MASK) | (((uint32_t)val) << PIC_WDMA_DMA1_INT_ACK_RRESP_INT_ACK_SHIFT))

#define  PIC_WDMA_DMA1_INT_ACK_BRESP_INT_ACK_MASK 0x200
#define  PIC_WDMA_DMA1_INT_ACK_BRESP_INT_ACK_SHIFT 9
#define  PIC_WDMA_DMA1_INT_ACK_BRESP_INT_ACK_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA1_INT_ACK_BRESP_INT_ACK_MASK) >> PIC_WDMA_DMA1_INT_ACK_BRESP_INT_ACK_SHIFT)
#define  PIC_WDMA_DMA1_INT_ACK_BRESP_INT_ACK_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA1_INT_ACK_BRESP_INT_ACK_MASK) | (((uint32_t)val) << PIC_WDMA_DMA1_INT_ACK_BRESP_INT_ACK_SHIFT))

#define  PIC_WDMA_DMA1_INT_ACK_RST_INT_ACK_MASK 0x100
#define  PIC_WDMA_DMA1_INT_ACK_RST_INT_ACK_SHIFT 8
#define  PIC_WDMA_DMA1_INT_ACK_RST_INT_ACK_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA1_INT_ACK_RST_INT_ACK_MASK) >> PIC_WDMA_DMA1_INT_ACK_RST_INT_ACK_SHIFT)
#define  PIC_WDMA_DMA1_INT_ACK_RST_INT_ACK_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA1_INT_ACK_RST_INT_ACK_MASK) | (((uint32_t)val) << PIC_WDMA_DMA1_INT_ACK_RST_INT_ACK_SHIFT))

#define  PIC_WDMA_DMA1_INT_ACK_EOI_INT_ACK_MASK 0x80
#define  PIC_WDMA_DMA1_INT_ACK_EOI_INT_ACK_SHIFT 7
#define  PIC_WDMA_DMA1_INT_ACK_EOI_INT_ACK_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA1_INT_ACK_EOI_INT_ACK_MASK) >> PIC_WDMA_DMA1_INT_ACK_EOI_INT_ACK_SHIFT)
#define  PIC_WDMA_DMA1_INT_ACK_EOI_INT_ACK_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA1_INT_ACK_EOI_INT_ACK_MASK) | (((uint32_t)val) << PIC_WDMA_DMA1_INT_ACK_EOI_INT_ACK_SHIFT))

#define  PIC_WDMA_DMA1_INT_ACK_DIR_INT_ACK_MASK 0x40
#define  PIC_WDMA_DMA1_INT_ACK_DIR_INT_ACK_SHIFT 6
#define  PIC_WDMA_DMA1_INT_ACK_DIR_INT_ACK_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA1_INT_ACK_DIR_INT_ACK_MASK) >> PIC_WDMA_DMA1_INT_ACK_DIR_INT_ACK_SHIFT)
#define  PIC_WDMA_DMA1_INT_ACK_DIR_INT_ACK_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA1_INT_ACK_DIR_INT_ACK_MASK) | (((uint32_t)val) << PIC_WDMA_DMA1_INT_ACK_DIR_INT_ACK_SHIFT))

#define  PIC_WDMA_DMA1_INT_ACK_CL_ALI_INT_ACK_MASK 0x20
#define  PIC_WDMA_DMA1_INT_ACK_CL_ALI_INT_ACK_SHIFT 5
#define  PIC_WDMA_DMA1_INT_ACK_CL_ALI_INT_ACK_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA1_INT_ACK_CL_ALI_INT_ACK_MASK) >> PIC_WDMA_DMA1_INT_ACK_CL_ALI_INT_ACK_SHIFT)
#define  PIC_WDMA_DMA1_INT_ACK_CL_ALI_INT_ACK_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA1_INT_ACK_CL_ALI_INT_ACK_MASK) | (((uint32_t)val) << PIC_WDMA_DMA1_INT_ACK_CL_ALI_INT_ACK_SHIFT))

#define  PIC_WDMA_DMA1_INT_ACK_EOL_ALI_INT_ACK_MASK 0x10
#define  PIC_WDMA_DMA1_INT_ACK_EOL_ALI_INT_ACK_SHIFT 4
#define  PIC_WDMA_DMA1_INT_ACK_EOL_ALI_INT_ACK_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA1_INT_ACK_EOL_ALI_INT_ACK_MASK) >> PIC_WDMA_DMA1_INT_ACK_EOL_ALI_INT_ACK_SHIFT)
#define  PIC_WDMA_DMA1_INT_ACK_EOL_ALI_INT_ACK_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA1_INT_ACK_EOL_ALI_INT_ACK_MASK) | (((uint32_t)val) << PIC_WDMA_DMA1_INT_ACK_EOL_ALI_INT_ACK_SHIFT))

#define  PIC_WDMA_DMA1_INT_ACK_EOI_ALI_INT_ACK_MASK 0x8
#define  PIC_WDMA_DMA1_INT_ACK_EOI_ALI_INT_ACK_SHIFT 3
#define  PIC_WDMA_DMA1_INT_ACK_EOI_ALI_INT_ACK_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA1_INT_ACK_EOI_ALI_INT_ACK_MASK) >> PIC_WDMA_DMA1_INT_ACK_EOI_ALI_INT_ACK_SHIFT)
#define  PIC_WDMA_DMA1_INT_ACK_EOI_ALI_INT_ACK_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA1_INT_ACK_EOI_ALI_INT_ACK_MASK) | (((uint32_t)val) << PIC_WDMA_DMA1_INT_ACK_EOI_ALI_INT_ACK_SHIFT))

#define  PIC_WDMA_DMA1_INT_ACK_EOI_ERR_INT_ACK_MASK 0x4
#define  PIC_WDMA_DMA1_INT_ACK_EOI_ERR_INT_ACK_SHIFT 2
#define  PIC_WDMA_DMA1_INT_ACK_EOI_ERR_INT_ACK_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA1_INT_ACK_EOI_ERR_INT_ACK_MASK) >> PIC_WDMA_DMA1_INT_ACK_EOI_ERR_INT_ACK_SHIFT)
#define  PIC_WDMA_DMA1_INT_ACK_EOI_ERR_INT_ACK_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA1_INT_ACK_EOI_ERR_INT_ACK_MASK) | (((uint32_t)val) << PIC_WDMA_DMA1_INT_ACK_EOI_ERR_INT_ACK_SHIFT))

#define  PIC_WDMA_DMA1_INT_ACK_FIN_INT_ACK_MASK 0x2
#define  PIC_WDMA_DMA1_INT_ACK_FIN_INT_ACK_SHIFT 1
#define  PIC_WDMA_DMA1_INT_ACK_FIN_INT_ACK_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA1_INT_ACK_FIN_INT_ACK_MASK) >> PIC_WDMA_DMA1_INT_ACK_FIN_INT_ACK_SHIFT)
#define  PIC_WDMA_DMA1_INT_ACK_FIN_INT_ACK_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA1_INT_ACK_FIN_INT_ACK_MASK) | (((uint32_t)val) << PIC_WDMA_DMA1_INT_ACK_FIN_INT_ACK_SHIFT))

#define  PIC_WDMA_DMA1_INT_ACK_WHO_INT_ACK_MASK 0x1
#define  PIC_WDMA_DMA1_INT_ACK_WHO_INT_ACK_SHIFT 0
#define  PIC_WDMA_DMA1_INT_ACK_WHO_INT_ACK_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA1_INT_ACK_WHO_INT_ACK_MASK) >> PIC_WDMA_DMA1_INT_ACK_WHO_INT_ACK_SHIFT)
#define  PIC_WDMA_DMA1_INT_ACK_WHO_INT_ACK_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA1_INT_ACK_WHO_INT_ACK_MASK) | (((uint32_t)val) << PIC_WDMA_DMA1_INT_ACK_WHO_INT_ACK_SHIFT))

//====================================================================
//Register: Interrupt Force Register (int_fo)
//====================================================================

#define  PIC_WDMA_DMA1_INT_FO_RESERVED1_MASK 0xfffff800
#define  PIC_WDMA_DMA1_INT_FO_RESERVED1_SHIFT 11
#define  PIC_WDMA_DMA1_INT_FO_RESERVED1_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA1_INT_FO_RESERVED1_MASK) >> PIC_WDMA_DMA1_INT_FO_RESERVED1_SHIFT)
#define  PIC_WDMA_DMA1_INT_FO_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA1_INT_FO_RESERVED1_MASK) | (((uint32_t)val) << PIC_WDMA_DMA1_INT_FO_RESERVED1_SHIFT))

#define  PIC_WDMA_DMA1_INT_FO_RRESP_INT_FO_MASK 0x400
#define  PIC_WDMA_DMA1_INT_FO_RRESP_INT_FO_SHIFT 10
#define  PIC_WDMA_DMA1_INT_FO_RRESP_INT_FO_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA1_INT_FO_RRESP_INT_FO_MASK) >> PIC_WDMA_DMA1_INT_FO_RRESP_INT_FO_SHIFT)
#define  PIC_WDMA_DMA1_INT_FO_RRESP_INT_FO_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA1_INT_FO_RRESP_INT_FO_MASK) | (((uint32_t)val) << PIC_WDMA_DMA1_INT_FO_RRESP_INT_FO_SHIFT))

#define  PIC_WDMA_DMA1_INT_FO_BRESP_INT_FO_MASK 0x200
#define  PIC_WDMA_DMA1_INT_FO_BRESP_INT_FO_SHIFT 9
#define  PIC_WDMA_DMA1_INT_FO_BRESP_INT_FO_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA1_INT_FO_BRESP_INT_FO_MASK) >> PIC_WDMA_DMA1_INT_FO_BRESP_INT_FO_SHIFT)
#define  PIC_WDMA_DMA1_INT_FO_BRESP_INT_FO_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA1_INT_FO_BRESP_INT_FO_MASK) | (((uint32_t)val) << PIC_WDMA_DMA1_INT_FO_BRESP_INT_FO_SHIFT))

#define  PIC_WDMA_DMA1_INT_FO_RST_INT_FO_MASK 0x100
#define  PIC_WDMA_DMA1_INT_FO_RST_INT_FO_SHIFT 8
#define  PIC_WDMA_DMA1_INT_FO_RST_INT_FO_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA1_INT_FO_RST_INT_FO_MASK) >> PIC_WDMA_DMA1_INT_FO_RST_INT_FO_SHIFT)
#define  PIC_WDMA_DMA1_INT_FO_RST_INT_FO_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA1_INT_FO_RST_INT_FO_MASK) | (((uint32_t)val) << PIC_WDMA_DMA1_INT_FO_RST_INT_FO_SHIFT))

#define  PIC_WDMA_DMA1_INT_FO_EOI_INT_FO_MASK 0x80
#define  PIC_WDMA_DMA1_INT_FO_EOI_INT_FO_SHIFT 7
#define  PIC_WDMA_DMA1_INT_FO_EOI_INT_FO_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA1_INT_FO_EOI_INT_FO_MASK) >> PIC_WDMA_DMA1_INT_FO_EOI_INT_FO_SHIFT)
#define  PIC_WDMA_DMA1_INT_FO_EOI_INT_FO_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA1_INT_FO_EOI_INT_FO_MASK) | (((uint32_t)val) << PIC_WDMA_DMA1_INT_FO_EOI_INT_FO_SHIFT))

#define  PIC_WDMA_DMA1_INT_FO_DIR_INT_FO_MASK 0x40
#define  PIC_WDMA_DMA1_INT_FO_DIR_INT_FO_SHIFT 6
#define  PIC_WDMA_DMA1_INT_FO_DIR_INT_FO_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA1_INT_FO_DIR_INT_FO_MASK) >> PIC_WDMA_DMA1_INT_FO_DIR_INT_FO_SHIFT)
#define  PIC_WDMA_DMA1_INT_FO_DIR_INT_FO_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA1_INT_FO_DIR_INT_FO_MASK) | (((uint32_t)val) << PIC_WDMA_DMA1_INT_FO_DIR_INT_FO_SHIFT))

#define  PIC_WDMA_DMA1_INT_FO_CL_ALI_INT_FO_MASK 0x20
#define  PIC_WDMA_DMA1_INT_FO_CL_ALI_INT_FO_SHIFT 5
#define  PIC_WDMA_DMA1_INT_FO_CL_ALI_INT_FO_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA1_INT_FO_CL_ALI_INT_FO_MASK) >> PIC_WDMA_DMA1_INT_FO_CL_ALI_INT_FO_SHIFT)
#define  PIC_WDMA_DMA1_INT_FO_CL_ALI_INT_FO_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA1_INT_FO_CL_ALI_INT_FO_MASK) | (((uint32_t)val) << PIC_WDMA_DMA1_INT_FO_CL_ALI_INT_FO_SHIFT))

#define  PIC_WDMA_DMA1_INT_FO_EOL_ALI_INT_FO_MASK 0x10
#define  PIC_WDMA_DMA1_INT_FO_EOL_ALI_INT_FO_SHIFT 4
#define  PIC_WDMA_DMA1_INT_FO_EOL_ALI_INT_FO_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA1_INT_FO_EOL_ALI_INT_FO_MASK) >> PIC_WDMA_DMA1_INT_FO_EOL_ALI_INT_FO_SHIFT)
#define  PIC_WDMA_DMA1_INT_FO_EOL_ALI_INT_FO_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA1_INT_FO_EOL_ALI_INT_FO_MASK) | (((uint32_t)val) << PIC_WDMA_DMA1_INT_FO_EOL_ALI_INT_FO_SHIFT))

#define  PIC_WDMA_DMA1_INT_FO_EOI_ALI_INT_FO_MASK 0x8
#define  PIC_WDMA_DMA1_INT_FO_EOI_ALI_INT_FO_SHIFT 3
#define  PIC_WDMA_DMA1_INT_FO_EOI_ALI_INT_FO_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA1_INT_FO_EOI_ALI_INT_FO_MASK) >> PIC_WDMA_DMA1_INT_FO_EOI_ALI_INT_FO_SHIFT)
#define  PIC_WDMA_DMA1_INT_FO_EOI_ALI_INT_FO_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA1_INT_FO_EOI_ALI_INT_FO_MASK) | (((uint32_t)val) << PIC_WDMA_DMA1_INT_FO_EOI_ALI_INT_FO_SHIFT))

#define  PIC_WDMA_DMA1_INT_FO_EOI_ERR_INT_FO_MASK 0x4
#define  PIC_WDMA_DMA1_INT_FO_EOI_ERR_INT_FO_SHIFT 2
#define  PIC_WDMA_DMA1_INT_FO_EOI_ERR_INT_FO_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA1_INT_FO_EOI_ERR_INT_FO_MASK) >> PIC_WDMA_DMA1_INT_FO_EOI_ERR_INT_FO_SHIFT)
#define  PIC_WDMA_DMA1_INT_FO_EOI_ERR_INT_FO_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA1_INT_FO_EOI_ERR_INT_FO_MASK) | (((uint32_t)val) << PIC_WDMA_DMA1_INT_FO_EOI_ERR_INT_FO_SHIFT))

#define  PIC_WDMA_DMA1_INT_FO_FIN_INT_FO_MASK 0x2
#define  PIC_WDMA_DMA1_INT_FO_FIN_INT_FO_SHIFT 1
#define  PIC_WDMA_DMA1_INT_FO_FIN_INT_FO_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA1_INT_FO_FIN_INT_FO_MASK) >> PIC_WDMA_DMA1_INT_FO_FIN_INT_FO_SHIFT)
#define  PIC_WDMA_DMA1_INT_FO_FIN_INT_FO_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA1_INT_FO_FIN_INT_FO_MASK) | (((uint32_t)val) << PIC_WDMA_DMA1_INT_FO_FIN_INT_FO_SHIFT))

#define  PIC_WDMA_DMA1_INT_FO_WHO_INT_FO_MASK 0x1
#define  PIC_WDMA_DMA1_INT_FO_WHO_INT_FO_SHIFT 0
#define  PIC_WDMA_DMA1_INT_FO_WHO_INT_FO_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA1_INT_FO_WHO_INT_FO_MASK) >> PIC_WDMA_DMA1_INT_FO_WHO_INT_FO_SHIFT)
#define  PIC_WDMA_DMA1_INT_FO_WHO_INT_FO_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA1_INT_FO_WHO_INT_FO_MASK) | (((uint32_t)val) << PIC_WDMA_DMA1_INT_FO_WHO_INT_FO_SHIFT))

//====================================================================
//Register: Descriptor Write Register (desc_write)
//====================================================================

#define  PIC_WDMA_DMA1_DESC_WRITE_DESC_MASK 0xfffffffc
#define  PIC_WDMA_DMA1_DESC_WRITE_DESC_SHIFT 2
#define  PIC_WDMA_DMA1_DESC_WRITE_DESC_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA1_DESC_WRITE_DESC_MASK) >> PIC_WDMA_DMA1_DESC_WRITE_DESC_SHIFT)
#define  PIC_WDMA_DMA1_DESC_WRITE_DESC_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA1_DESC_WRITE_DESC_MASK) | (((uint32_t)val) << PIC_WDMA_DMA1_DESC_WRITE_DESC_SHIFT))

#define  PIC_WDMA_DMA1_DESC_WRITE_RESERVED1_MASK 0x3
#define  PIC_WDMA_DMA1_DESC_WRITE_RESERVED1_SHIFT 0
#define  PIC_WDMA_DMA1_DESC_WRITE_RESERVED1_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA1_DESC_WRITE_RESERVED1_MASK) >> PIC_WDMA_DMA1_DESC_WRITE_RESERVED1_SHIFT)
#define  PIC_WDMA_DMA1_DESC_WRITE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA1_DESC_WRITE_RESERVED1_MASK) | (((uint32_t)val) << PIC_WDMA_DMA1_DESC_WRITE_RESERVED1_SHIFT))

//====================================================================
//Register: Descriptor Read Register (desc_read)
//====================================================================

#define  PIC_WDMA_DMA1_DESC_READ_DESC_MASK 0xffffffff
#define  PIC_WDMA_DMA1_DESC_READ_DESC_SHIFT 0
#define  PIC_WDMA_DMA1_DESC_READ_DESC_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA1_DESC_READ_DESC_MASK) >> PIC_WDMA_DMA1_DESC_READ_DESC_SHIFT)
#define  PIC_WDMA_DMA1_DESC_READ_DESC_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA1_DESC_READ_DESC_MASK) | (((uint32_t)val) << PIC_WDMA_DMA1_DESC_READ_DESC_SHIFT))

//====================================================================
//Register: Descriptor Transfer Length Register (xfer_length)
//====================================================================

#define  PIC_WDMA_DMA1_XFER_LENGTH_LEN_MASK 0xffffffff
#define  PIC_WDMA_DMA1_XFER_LENGTH_LEN_SHIFT 0
#define  PIC_WDMA_DMA1_XFER_LENGTH_LEN_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA1_XFER_LENGTH_LEN_MASK) >> PIC_WDMA_DMA1_XFER_LENGTH_LEN_SHIFT)
#define  PIC_WDMA_DMA1_XFER_LENGTH_LEN_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA1_XFER_LENGTH_LEN_MASK) | (((uint32_t)val) << PIC_WDMA_DMA1_XFER_LENGTH_LEN_SHIFT))

//====================================================================
//Register: Descriptor Transfer Address Register (xfer_addr)
//====================================================================

#define  PIC_WDMA_DMA1_XFER_ADDR_ADDR_MASK 0xffffffff
#define  PIC_WDMA_DMA1_XFER_ADDR_ADDR_SHIFT 0
#define  PIC_WDMA_DMA1_XFER_ADDR_ADDR_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA1_XFER_ADDR_ADDR_MASK) >> PIC_WDMA_DMA1_XFER_ADDR_ADDR_SHIFT)
#define  PIC_WDMA_DMA1_XFER_ADDR_ADDR_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA1_XFER_ADDR_ADDR_MASK) | (((uint32_t)val) << PIC_WDMA_DMA1_XFER_ADDR_ADDR_SHIFT))

//====================================================================
//Register: Descriptor Transfer Burst Register (xfer_burst)
//====================================================================

#define  PIC_WDMA_DMA1_XFER_BURST_RESERVED1_MASK 0xffffffe0
#define  PIC_WDMA_DMA1_XFER_BURST_RESERVED1_SHIFT 5
#define  PIC_WDMA_DMA1_XFER_BURST_RESERVED1_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA1_XFER_BURST_RESERVED1_MASK) >> PIC_WDMA_DMA1_XFER_BURST_RESERVED1_SHIFT)
#define  PIC_WDMA_DMA1_XFER_BURST_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA1_XFER_BURST_RESERVED1_MASK) | (((uint32_t)val) << PIC_WDMA_DMA1_XFER_BURST_RESERVED1_SHIFT))

#define  PIC_WDMA_DMA1_XFER_BURST_BURST_MASK 0x1f
#define  PIC_WDMA_DMA1_XFER_BURST_BURST_SHIFT 0
#define  PIC_WDMA_DMA1_XFER_BURST_BURST_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA1_XFER_BURST_BURST_MASK) >> PIC_WDMA_DMA1_XFER_BURST_BURST_SHIFT)
#define  PIC_WDMA_DMA1_XFER_BURST_BURST_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA1_XFER_BURST_BURST_MASK) | (((uint32_t)val) << PIC_WDMA_DMA1_XFER_BURST_BURST_SHIFT))

//====================================================================
//Register: Soft Reset register (reset)
//====================================================================

#define  PIC_WDMA_DMA1_RESET_RESERVED1_MASK 0xfffffffc
#define  PIC_WDMA_DMA1_RESET_RESERVED1_SHIFT 2
#define  PIC_WDMA_DMA1_RESET_RESERVED1_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA1_RESET_RESERVED1_MASK) >> PIC_WDMA_DMA1_RESET_RESERVED1_SHIFT)
#define  PIC_WDMA_DMA1_RESET_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA1_RESET_RESERVED1_MASK) | (((uint32_t)val) << PIC_WDMA_DMA1_RESET_RESERVED1_SHIFT))

#define  PIC_WDMA_DMA1_RESET_FORCE_LAST_BURST_MASK 0x2
#define  PIC_WDMA_DMA1_RESET_FORCE_LAST_BURST_SHIFT 1
#define  PIC_WDMA_DMA1_RESET_FORCE_LAST_BURST_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA1_RESET_FORCE_LAST_BURST_MASK) >> PIC_WDMA_DMA1_RESET_FORCE_LAST_BURST_SHIFT)
#define  PIC_WDMA_DMA1_RESET_FORCE_LAST_BURST_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA1_RESET_FORCE_LAST_BURST_MASK) | (((uint32_t)val) << PIC_WDMA_DMA1_RESET_FORCE_LAST_BURST_SHIFT))

#define  PIC_WDMA_DMA1_RESET_SOFT_RESET_MASK 0x1
#define  PIC_WDMA_DMA1_RESET_SOFT_RESET_SHIFT 0
#define  PIC_WDMA_DMA1_RESET_SOFT_RESET_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA1_RESET_SOFT_RESET_MASK) >> PIC_WDMA_DMA1_RESET_SOFT_RESET_SHIFT)
#define  PIC_WDMA_DMA1_RESET_SOFT_RESET_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA1_RESET_SOFT_RESET_MASK) | (((uint32_t)val) << PIC_WDMA_DMA1_RESET_SOFT_RESET_SHIFT))

//====================================================================
//Register: IP Tagging Revision 0 (REV0)
/** \brief Provide means for firmware to read IP tagging information.
      This register of particular interest to firmware.*/
//====================================================================

#define  PIC_WDMA_DMA1_REV0_MAJ_MASK 0xffff0000
#define  PIC_WDMA_DMA1_REV0_MAJ_SHIFT 16
#define  PIC_WDMA_DMA1_REV0_MAJ_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA1_REV0_MAJ_MASK) >> PIC_WDMA_DMA1_REV0_MAJ_SHIFT)
#define  PIC_WDMA_DMA1_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA1_REV0_MAJ_MASK) | (((uint32_t)val) << PIC_WDMA_DMA1_REV0_MAJ_SHIFT))

#define  PIC_WDMA_DMA1_REV0_MID_MASK 0xffff
#define  PIC_WDMA_DMA1_REV0_MID_SHIFT 0
#define  PIC_WDMA_DMA1_REV0_MID_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA1_REV0_MID_MASK) >> PIC_WDMA_DMA1_REV0_MID_SHIFT)
#define  PIC_WDMA_DMA1_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA1_REV0_MID_MASK) | (((uint32_t)val) << PIC_WDMA_DMA1_REV0_MID_SHIFT))

//====================================================================
//Register: IP Tagging Revision 1 (REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  PIC_WDMA_DMA1_REV1_RESERVED1_MASK 0xffff0000
#define  PIC_WDMA_DMA1_REV1_RESERVED1_SHIFT 16
#define  PIC_WDMA_DMA1_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA1_REV1_RESERVED1_MASK) >> PIC_WDMA_DMA1_REV1_RESERVED1_SHIFT)
#define  PIC_WDMA_DMA1_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA1_REV1_RESERVED1_MASK) | (((uint32_t)val) << PIC_WDMA_DMA1_REV1_RESERVED1_SHIFT))

#define  PIC_WDMA_DMA1_REV1_CFG_MASK 0xffff
#define  PIC_WDMA_DMA1_REV1_CFG_SHIFT 0
#define  PIC_WDMA_DMA1_REV1_CFG_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA1_REV1_CFG_MASK) >> PIC_WDMA_DMA1_REV1_CFG_SHIFT)
#define  PIC_WDMA_DMA1_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA1_REV1_CFG_MASK) | (((uint32_t)val) << PIC_WDMA_DMA1_REV1_CFG_SHIFT))

//====================================================================
//
//Register File: DMA channel (Instance 3 of 3) (PIC_WDMA_DMA2)
/** \brief Register Descriptions for the ODMA_AXI block (rev 0 . 4 . 3 . 1)*/
//
//====================================================================

//====================================================================
//Register: Configuration register (cfg)
//====================================================================

#define  PIC_WDMA_DMA2_CFG_RESERVED1_MASK 0xfe000000
#define  PIC_WDMA_DMA2_CFG_RESERVED1_SHIFT 25
#define  PIC_WDMA_DMA2_CFG_RESERVED1_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA2_CFG_RESERVED1_MASK) >> PIC_WDMA_DMA2_CFG_RESERVED1_SHIFT)
#define  PIC_WDMA_DMA2_CFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA2_CFG_RESERVED1_MASK) | (((uint32_t)val) << PIC_WDMA_DMA2_CFG_RESERVED1_SHIFT))

#define  PIC_WDMA_DMA2_CFG_HANDSHAKEENABLE_MASK 0x1000000
#define  PIC_WDMA_DMA2_CFG_HANDSHAKEENABLE_SHIFT 24
#define  PIC_WDMA_DMA2_CFG_HANDSHAKEENABLE_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA2_CFG_HANDSHAKEENABLE_MASK) >> PIC_WDMA_DMA2_CFG_HANDSHAKEENABLE_SHIFT)
#define  PIC_WDMA_DMA2_CFG_HANDSHAKEENABLE_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA2_CFG_HANDSHAKEENABLE_MASK) | (((uint32_t)val) << PIC_WDMA_DMA2_CFG_HANDSHAKEENABLE_SHIFT))

#define  PIC_WDMA_DMA2_CFG_OWNPOLARITY_MASK 0x800000
#define  PIC_WDMA_DMA2_CFG_OWNPOLARITY_SHIFT 23
#define  PIC_WDMA_DMA2_CFG_OWNPOLARITY_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA2_CFG_OWNPOLARITY_MASK) >> PIC_WDMA_DMA2_CFG_OWNPOLARITY_SHIFT)
#define  PIC_WDMA_DMA2_CFG_OWNPOLARITY_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA2_CFG_OWNPOLARITY_MASK) | (((uint32_t)val) << PIC_WDMA_DMA2_CFG_OWNPOLARITY_SHIFT))

#define  PIC_WDMA_DMA2_CFG_OWNWRITEDISABLE_MASK 0x400000
#define  PIC_WDMA_DMA2_CFG_OWNWRITEDISABLE_SHIFT 22
#define  PIC_WDMA_DMA2_CFG_OWNWRITEDISABLE_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA2_CFG_OWNWRITEDISABLE_MASK) >> PIC_WDMA_DMA2_CFG_OWNWRITEDISABLE_SHIFT)
#define  PIC_WDMA_DMA2_CFG_OWNWRITEDISABLE_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA2_CFG_OWNWRITEDISABLE_MASK) | (((uint32_t)val) << PIC_WDMA_DMA2_CFG_OWNWRITEDISABLE_SHIFT))

#define  PIC_WDMA_DMA2_CFG_SERPENTINE_MASK 0x200000
#define  PIC_WDMA_DMA2_CFG_SERPENTINE_SHIFT 21
#define  PIC_WDMA_DMA2_CFG_SERPENTINE_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA2_CFG_SERPENTINE_MASK) >> PIC_WDMA_DMA2_CFG_SERPENTINE_SHIFT)
#define  PIC_WDMA_DMA2_CFG_SERPENTINE_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA2_CFG_SERPENTINE_MASK) | (((uint32_t)val) << PIC_WDMA_DMA2_CFG_SERPENTINE_SHIFT))

#define  PIC_WDMA_DMA2_CFG_LINE_REV_MASK 0x100000
#define  PIC_WDMA_DMA2_CFG_LINE_REV_SHIFT 20
#define  PIC_WDMA_DMA2_CFG_LINE_REV_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA2_CFG_LINE_REV_MASK) >> PIC_WDMA_DMA2_CFG_LINE_REV_SHIFT)
#define  PIC_WDMA_DMA2_CFG_LINE_REV_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA2_CFG_LINE_REV_MASK) | (((uint32_t)val) << PIC_WDMA_DMA2_CFG_LINE_REV_SHIFT))

#define  PIC_WDMA_DMA2_CFG_TRAN_REV_MASK 0x80000
#define  PIC_WDMA_DMA2_CFG_TRAN_REV_SHIFT 19
#define  PIC_WDMA_DMA2_CFG_TRAN_REV_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA2_CFG_TRAN_REV_MASK) >> PIC_WDMA_DMA2_CFG_TRAN_REV_SHIFT)
#define  PIC_WDMA_DMA2_CFG_TRAN_REV_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA2_CFG_TRAN_REV_MASK) | (((uint32_t)val) << PIC_WDMA_DMA2_CFG_TRAN_REV_SHIFT))

#define  PIC_WDMA_DMA2_CFG_UPPER_HALF_MASK 0x40000
#define  PIC_WDMA_DMA2_CFG_UPPER_HALF_SHIFT 18
#define  PIC_WDMA_DMA2_CFG_UPPER_HALF_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA2_CFG_UPPER_HALF_MASK) >> PIC_WDMA_DMA2_CFG_UPPER_HALF_SHIFT)
#define  PIC_WDMA_DMA2_CFG_UPPER_HALF_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA2_CFG_UPPER_HALF_MASK) | (((uint32_t)val) << PIC_WDMA_DMA2_CFG_UPPER_HALF_SHIFT))

#define  PIC_WDMA_DMA2_CFG_MSB_IN_MASK 0x20000
#define  PIC_WDMA_DMA2_CFG_MSB_IN_SHIFT 17
#define  PIC_WDMA_DMA2_CFG_MSB_IN_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA2_CFG_MSB_IN_MASK) >> PIC_WDMA_DMA2_CFG_MSB_IN_SHIFT)
#define  PIC_WDMA_DMA2_CFG_MSB_IN_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA2_CFG_MSB_IN_MASK) | (((uint32_t)val) << PIC_WDMA_DMA2_CFG_MSB_IN_SHIFT))

#define  PIC_WDMA_DMA2_CFG_ENABLE_MASK 0x10000
#define  PIC_WDMA_DMA2_CFG_ENABLE_SHIFT 16
#define  PIC_WDMA_DMA2_CFG_ENABLE_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA2_CFG_ENABLE_MASK) >> PIC_WDMA_DMA2_CFG_ENABLE_SHIFT)
#define  PIC_WDMA_DMA2_CFG_ENABLE_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA2_CFG_ENABLE_MASK) | (((uint32_t)val) << PIC_WDMA_DMA2_CFG_ENABLE_SHIFT))

#define  PIC_WDMA_DMA2_CFG_RESERVED2_MASK 0xf800
#define  PIC_WDMA_DMA2_CFG_RESERVED2_SHIFT 11
#define  PIC_WDMA_DMA2_CFG_RESERVED2_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA2_CFG_RESERVED2_MASK) >> PIC_WDMA_DMA2_CFG_RESERVED2_SHIFT)
#define  PIC_WDMA_DMA2_CFG_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA2_CFG_RESERVED2_MASK) | (((uint32_t)val) << PIC_WDMA_DMA2_CFG_RESERVED2_SHIFT))

#define  PIC_WDMA_DMA2_CFG_IN_WIDTH_MASK 0x700
#define  PIC_WDMA_DMA2_CFG_IN_WIDTH_SHIFT 8
#define  PIC_WDMA_DMA2_CFG_IN_WIDTH_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA2_CFG_IN_WIDTH_MASK) >> PIC_WDMA_DMA2_CFG_IN_WIDTH_SHIFT)
#define  PIC_WDMA_DMA2_CFG_IN_WIDTH_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA2_CFG_IN_WIDTH_MASK) | (((uint32_t)val) << PIC_WDMA_DMA2_CFG_IN_WIDTH_SHIFT))

#define  PIC_WDMA_DMA2_CFG_RESERVED3_MASK 0xfc
#define  PIC_WDMA_DMA2_CFG_RESERVED3_SHIFT 2
#define  PIC_WDMA_DMA2_CFG_RESERVED3_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA2_CFG_RESERVED3_MASK) >> PIC_WDMA_DMA2_CFG_RESERVED3_SHIFT)
#define  PIC_WDMA_DMA2_CFG_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA2_CFG_RESERVED3_MASK) | (((uint32_t)val) << PIC_WDMA_DMA2_CFG_RESERVED3_SHIFT))

#define  PIC_WDMA_DMA2_CFG_BURST_LEN_MASK 0x3
#define  PIC_WDMA_DMA2_CFG_BURST_LEN_SHIFT 0
#define  PIC_WDMA_DMA2_CFG_BURST_LEN_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA2_CFG_BURST_LEN_MASK) >> PIC_WDMA_DMA2_CFG_BURST_LEN_SHIFT)
#define  PIC_WDMA_DMA2_CFG_BURST_LEN_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA2_CFG_BURST_LEN_MASK) | (((uint32_t)val) << PIC_WDMA_DMA2_CFG_BURST_LEN_SHIFT))

//====================================================================
//Register: Status register (status)
//====================================================================

#define  PIC_WDMA_DMA2_STATUS_RESERVED1_MASK 0xff000000
#define  PIC_WDMA_DMA2_STATUS_RESERVED1_SHIFT 24
#define  PIC_WDMA_DMA2_STATUS_RESERVED1_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA2_STATUS_RESERVED1_MASK) >> PIC_WDMA_DMA2_STATUS_RESERVED1_SHIFT)
#define  PIC_WDMA_DMA2_STATUS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA2_STATUS_RESERVED1_MASK) | (((uint32_t)val) << PIC_WDMA_DMA2_STATUS_RESERVED1_SHIFT))

#define  PIC_WDMA_DMA2_STATUS_BYTESWAITING_MASK 0xff0000
#define  PIC_WDMA_DMA2_STATUS_BYTESWAITING_SHIFT 16
#define  PIC_WDMA_DMA2_STATUS_BYTESWAITING_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA2_STATUS_BYTESWAITING_MASK) >> PIC_WDMA_DMA2_STATUS_BYTESWAITING_SHIFT)
#define  PIC_WDMA_DMA2_STATUS_BYTESWAITING_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA2_STATUS_BYTESWAITING_MASK) | (((uint32_t)val) << PIC_WDMA_DMA2_STATUS_BYTESWAITING_SHIFT))

#define  PIC_WDMA_DMA2_STATUS_RESERVED2_MASK 0x8000
#define  PIC_WDMA_DMA2_STATUS_RESERVED2_SHIFT 15
#define  PIC_WDMA_DMA2_STATUS_RESERVED2_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA2_STATUS_RESERVED2_MASK) >> PIC_WDMA_DMA2_STATUS_RESERVED2_SHIFT)
#define  PIC_WDMA_DMA2_STATUS_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA2_STATUS_RESERVED2_MASK) | (((uint32_t)val) << PIC_WDMA_DMA2_STATUS_RESERVED2_SHIFT))

#define  PIC_WDMA_DMA2_STATUS_FORCE_BURST_BUSY_MASK 0x4000
#define  PIC_WDMA_DMA2_STATUS_FORCE_BURST_BUSY_SHIFT 14
#define  PIC_WDMA_DMA2_STATUS_FORCE_BURST_BUSY_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA2_STATUS_FORCE_BURST_BUSY_MASK) >> PIC_WDMA_DMA2_STATUS_FORCE_BURST_BUSY_SHIFT)
#define  PIC_WDMA_DMA2_STATUS_FORCE_BURST_BUSY_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA2_STATUS_FORCE_BURST_BUSY_MASK) | (((uint32_t)val) << PIC_WDMA_DMA2_STATUS_FORCE_BURST_BUSY_SHIFT))

#define  PIC_WDMA_DMA2_STATUS_DMAPAUSED_MASK 0x2000
#define  PIC_WDMA_DMA2_STATUS_DMAPAUSED_SHIFT 13
#define  PIC_WDMA_DMA2_STATUS_DMAPAUSED_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA2_STATUS_DMAPAUSED_MASK) >> PIC_WDMA_DMA2_STATUS_DMAPAUSED_SHIFT)
#define  PIC_WDMA_DMA2_STATUS_DMAPAUSED_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA2_STATUS_DMAPAUSED_MASK) | (((uint32_t)val) << PIC_WDMA_DMA2_STATUS_DMAPAUSED_SHIFT))

#define  PIC_WDMA_DMA2_STATUS_PAUSEAFTER_MASK 0x1000
#define  PIC_WDMA_DMA2_STATUS_PAUSEAFTER_SHIFT 12
#define  PIC_WDMA_DMA2_STATUS_PAUSEAFTER_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA2_STATUS_PAUSEAFTER_MASK) >> PIC_WDMA_DMA2_STATUS_PAUSEAFTER_SHIFT)
#define  PIC_WDMA_DMA2_STATUS_PAUSEAFTER_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA2_STATUS_PAUSEAFTER_MASK) | (((uint32_t)val) << PIC_WDMA_DMA2_STATUS_PAUSEAFTER_SHIFT))

#define  PIC_WDMA_DMA2_STATUS_PAUSEBEFORE_MASK 0x800
#define  PIC_WDMA_DMA2_STATUS_PAUSEBEFORE_SHIFT 11
#define  PIC_WDMA_DMA2_STATUS_PAUSEBEFORE_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA2_STATUS_PAUSEBEFORE_MASK) >> PIC_WDMA_DMA2_STATUS_PAUSEBEFORE_SHIFT)
#define  PIC_WDMA_DMA2_STATUS_PAUSEBEFORE_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA2_STATUS_PAUSEBEFORE_MASK) | (((uint32_t)val) << PIC_WDMA_DMA2_STATUS_PAUSEBEFORE_SHIFT))

#define  PIC_WDMA_DMA2_STATUS_DESC_OWN_MASK 0x400
#define  PIC_WDMA_DMA2_STATUS_DESC_OWN_SHIFT 10
#define  PIC_WDMA_DMA2_STATUS_DESC_OWN_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA2_STATUS_DESC_OWN_MASK) >> PIC_WDMA_DMA2_STATUS_DESC_OWN_SHIFT)
#define  PIC_WDMA_DMA2_STATUS_DESC_OWN_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA2_STATUS_DESC_OWN_MASK) | (((uint32_t)val) << PIC_WDMA_DMA2_STATUS_DESC_OWN_SHIFT))

#define  PIC_WDMA_DMA2_STATUS_DESC_EOI_MASK 0x200
#define  PIC_WDMA_DMA2_STATUS_DESC_EOI_SHIFT 9
#define  PIC_WDMA_DMA2_STATUS_DESC_EOI_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA2_STATUS_DESC_EOI_MASK) >> PIC_WDMA_DMA2_STATUS_DESC_EOI_SHIFT)
#define  PIC_WDMA_DMA2_STATUS_DESC_EOI_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA2_STATUS_DESC_EOI_MASK) | (((uint32_t)val) << PIC_WDMA_DMA2_STATUS_DESC_EOI_SHIFT))

#define  PIC_WDMA_DMA2_STATUS_DESC_SOI_MASK 0x100
#define  PIC_WDMA_DMA2_STATUS_DESC_SOI_SHIFT 8
#define  PIC_WDMA_DMA2_STATUS_DESC_SOI_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA2_STATUS_DESC_SOI_MASK) >> PIC_WDMA_DMA2_STATUS_DESC_SOI_SHIFT)
#define  PIC_WDMA_DMA2_STATUS_DESC_SOI_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA2_STATUS_DESC_SOI_MASK) | (((uint32_t)val) << PIC_WDMA_DMA2_STATUS_DESC_SOI_SHIFT))

#define  PIC_WDMA_DMA2_STATUS_REVERSE_MASK 0x80
#define  PIC_WDMA_DMA2_STATUS_REVERSE_SHIFT 7
#define  PIC_WDMA_DMA2_STATUS_REVERSE_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA2_STATUS_REVERSE_MASK) >> PIC_WDMA_DMA2_STATUS_REVERSE_SHIFT)
#define  PIC_WDMA_DMA2_STATUS_REVERSE_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA2_STATUS_REVERSE_MASK) | (((uint32_t)val) << PIC_WDMA_DMA2_STATUS_REVERSE_SHIFT))

#define  PIC_WDMA_DMA2_STATUS_SOFTRESET_MASK 0x40
#define  PIC_WDMA_DMA2_STATUS_SOFTRESET_SHIFT 6
#define  PIC_WDMA_DMA2_STATUS_SOFTRESET_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA2_STATUS_SOFTRESET_MASK) >> PIC_WDMA_DMA2_STATUS_SOFTRESET_SHIFT)
#define  PIC_WDMA_DMA2_STATUS_SOFTRESET_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA2_STATUS_SOFTRESET_MASK) | (((uint32_t)val) << PIC_WDMA_DMA2_STATUS_SOFTRESET_SHIFT))

#define  PIC_WDMA_DMA2_STATUS_FULL_CBUF_MASK 0x20
#define  PIC_WDMA_DMA2_STATUS_FULL_CBUF_SHIFT 5
#define  PIC_WDMA_DMA2_STATUS_FULL_CBUF_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA2_STATUS_FULL_CBUF_MASK) >> PIC_WDMA_DMA2_STATUS_FULL_CBUF_SHIFT)
#define  PIC_WDMA_DMA2_STATUS_FULL_CBUF_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA2_STATUS_FULL_CBUF_MASK) | (((uint32_t)val) << PIC_WDMA_DMA2_STATUS_FULL_CBUF_SHIFT))

#define  PIC_WDMA_DMA2_STATUS_EMPTY_CBUF_MASK 0x10
#define  PIC_WDMA_DMA2_STATUS_EMPTY_CBUF_SHIFT 4
#define  PIC_WDMA_DMA2_STATUS_EMPTY_CBUF_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA2_STATUS_EMPTY_CBUF_MASK) >> PIC_WDMA_DMA2_STATUS_EMPTY_CBUF_SHIFT)
#define  PIC_WDMA_DMA2_STATUS_EMPTY_CBUF_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA2_STATUS_EMPTY_CBUF_MASK) | (((uint32_t)val) << PIC_WDMA_DMA2_STATUS_EMPTY_CBUF_SHIFT))

#define  PIC_WDMA_DMA2_STATUS_FULL_DBUF_MASK 0x8
#define  PIC_WDMA_DMA2_STATUS_FULL_DBUF_SHIFT 3
#define  PIC_WDMA_DMA2_STATUS_FULL_DBUF_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA2_STATUS_FULL_DBUF_MASK) >> PIC_WDMA_DMA2_STATUS_FULL_DBUF_SHIFT)
#define  PIC_WDMA_DMA2_STATUS_FULL_DBUF_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA2_STATUS_FULL_DBUF_MASK) | (((uint32_t)val) << PIC_WDMA_DMA2_STATUS_FULL_DBUF_SHIFT))

#define  PIC_WDMA_DMA2_STATUS_EMPTY_DBUF_MASK 0x4
#define  PIC_WDMA_DMA2_STATUS_EMPTY_DBUF_SHIFT 2
#define  PIC_WDMA_DMA2_STATUS_EMPTY_DBUF_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA2_STATUS_EMPTY_DBUF_MASK) >> PIC_WDMA_DMA2_STATUS_EMPTY_DBUF_SHIFT)
#define  PIC_WDMA_DMA2_STATUS_EMPTY_DBUF_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA2_STATUS_EMPTY_DBUF_MASK) | (((uint32_t)val) << PIC_WDMA_DMA2_STATUS_EMPTY_DBUF_SHIFT))

#define  PIC_WDMA_DMA2_STATUS_PACKER_EMPTY_MASK 0x2
#define  PIC_WDMA_DMA2_STATUS_PACKER_EMPTY_SHIFT 1
#define  PIC_WDMA_DMA2_STATUS_PACKER_EMPTY_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA2_STATUS_PACKER_EMPTY_MASK) >> PIC_WDMA_DMA2_STATUS_PACKER_EMPTY_SHIFT)
#define  PIC_WDMA_DMA2_STATUS_PACKER_EMPTY_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA2_STATUS_PACKER_EMPTY_MASK) | (((uint32_t)val) << PIC_WDMA_DMA2_STATUS_PACKER_EMPTY_SHIFT))

#define  PIC_WDMA_DMA2_STATUS_DMA_BUSY_MASK 0x1
#define  PIC_WDMA_DMA2_STATUS_DMA_BUSY_SHIFT 0
#define  PIC_WDMA_DMA2_STATUS_DMA_BUSY_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA2_STATUS_DMA_BUSY_MASK) >> PIC_WDMA_DMA2_STATUS_DMA_BUSY_SHIFT)
#define  PIC_WDMA_DMA2_STATUS_DMA_BUSY_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA2_STATUS_DMA_BUSY_MASK) | (((uint32_t)val) << PIC_WDMA_DMA2_STATUS_DMA_BUSY_SHIFT))

//====================================================================
//Register: Line Size Register (line_size)
//====================================================================

#define  PIC_WDMA_DMA2_LINE_SIZE_RESERVED1_MASK 0xfffc0000
#define  PIC_WDMA_DMA2_LINE_SIZE_RESERVED1_SHIFT 18
#define  PIC_WDMA_DMA2_LINE_SIZE_RESERVED1_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA2_LINE_SIZE_RESERVED1_MASK) >> PIC_WDMA_DMA2_LINE_SIZE_RESERVED1_SHIFT)
#define  PIC_WDMA_DMA2_LINE_SIZE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA2_LINE_SIZE_RESERVED1_MASK) | (((uint32_t)val) << PIC_WDMA_DMA2_LINE_SIZE_RESERVED1_SHIFT))

#define  PIC_WDMA_DMA2_LINE_SIZE_LINE_SIZE_MASK 0x3ffff
#define  PIC_WDMA_DMA2_LINE_SIZE_LINE_SIZE_SHIFT 0
#define  PIC_WDMA_DMA2_LINE_SIZE_LINE_SIZE_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA2_LINE_SIZE_LINE_SIZE_MASK) >> PIC_WDMA_DMA2_LINE_SIZE_LINE_SIZE_SHIFT)
#define  PIC_WDMA_DMA2_LINE_SIZE_LINE_SIZE_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA2_LINE_SIZE_LINE_SIZE_MASK) | (((uint32_t)val) << PIC_WDMA_DMA2_LINE_SIZE_LINE_SIZE_SHIFT))

//====================================================================
//Register: Interrupt Enable Register (int_en)
//====================================================================

#define  PIC_WDMA_DMA2_INT_EN_RESERVED1_MASK 0xfffff800
#define  PIC_WDMA_DMA2_INT_EN_RESERVED1_SHIFT 11
#define  PIC_WDMA_DMA2_INT_EN_RESERVED1_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA2_INT_EN_RESERVED1_MASK) >> PIC_WDMA_DMA2_INT_EN_RESERVED1_SHIFT)
#define  PIC_WDMA_DMA2_INT_EN_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA2_INT_EN_RESERVED1_MASK) | (((uint32_t)val) << PIC_WDMA_DMA2_INT_EN_RESERVED1_SHIFT))

#define  PIC_WDMA_DMA2_INT_EN_RRESP_INT_EN_MASK 0x400
#define  PIC_WDMA_DMA2_INT_EN_RRESP_INT_EN_SHIFT 10
#define  PIC_WDMA_DMA2_INT_EN_RRESP_INT_EN_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA2_INT_EN_RRESP_INT_EN_MASK) >> PIC_WDMA_DMA2_INT_EN_RRESP_INT_EN_SHIFT)
#define  PIC_WDMA_DMA2_INT_EN_RRESP_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA2_INT_EN_RRESP_INT_EN_MASK) | (((uint32_t)val) << PIC_WDMA_DMA2_INT_EN_RRESP_INT_EN_SHIFT))

#define  PIC_WDMA_DMA2_INT_EN_BRESP_INT_EN_MASK 0x200
#define  PIC_WDMA_DMA2_INT_EN_BRESP_INT_EN_SHIFT 9
#define  PIC_WDMA_DMA2_INT_EN_BRESP_INT_EN_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA2_INT_EN_BRESP_INT_EN_MASK) >> PIC_WDMA_DMA2_INT_EN_BRESP_INT_EN_SHIFT)
#define  PIC_WDMA_DMA2_INT_EN_BRESP_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA2_INT_EN_BRESP_INT_EN_MASK) | (((uint32_t)val) << PIC_WDMA_DMA2_INT_EN_BRESP_INT_EN_SHIFT))

#define  PIC_WDMA_DMA2_INT_EN_RST_INT_EN_MASK 0x100
#define  PIC_WDMA_DMA2_INT_EN_RST_INT_EN_SHIFT 8
#define  PIC_WDMA_DMA2_INT_EN_RST_INT_EN_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA2_INT_EN_RST_INT_EN_MASK) >> PIC_WDMA_DMA2_INT_EN_RST_INT_EN_SHIFT)
#define  PIC_WDMA_DMA2_INT_EN_RST_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA2_INT_EN_RST_INT_EN_MASK) | (((uint32_t)val) << PIC_WDMA_DMA2_INT_EN_RST_INT_EN_SHIFT))

#define  PIC_WDMA_DMA2_INT_EN_EOI_INT_EN_MASK 0x80
#define  PIC_WDMA_DMA2_INT_EN_EOI_INT_EN_SHIFT 7
#define  PIC_WDMA_DMA2_INT_EN_EOI_INT_EN_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA2_INT_EN_EOI_INT_EN_MASK) >> PIC_WDMA_DMA2_INT_EN_EOI_INT_EN_SHIFT)
#define  PIC_WDMA_DMA2_INT_EN_EOI_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA2_INT_EN_EOI_INT_EN_MASK) | (((uint32_t)val) << PIC_WDMA_DMA2_INT_EN_EOI_INT_EN_SHIFT))

#define  PIC_WDMA_DMA2_INT_EN_DIR_INT_EN_MASK 0x40
#define  PIC_WDMA_DMA2_INT_EN_DIR_INT_EN_SHIFT 6
#define  PIC_WDMA_DMA2_INT_EN_DIR_INT_EN_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA2_INT_EN_DIR_INT_EN_MASK) >> PIC_WDMA_DMA2_INT_EN_DIR_INT_EN_SHIFT)
#define  PIC_WDMA_DMA2_INT_EN_DIR_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA2_INT_EN_DIR_INT_EN_MASK) | (((uint32_t)val) << PIC_WDMA_DMA2_INT_EN_DIR_INT_EN_SHIFT))

#define  PIC_WDMA_DMA2_INT_EN_CL_ALI_INT_EN_MASK 0x20
#define  PIC_WDMA_DMA2_INT_EN_CL_ALI_INT_EN_SHIFT 5
#define  PIC_WDMA_DMA2_INT_EN_CL_ALI_INT_EN_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA2_INT_EN_CL_ALI_INT_EN_MASK) >> PIC_WDMA_DMA2_INT_EN_CL_ALI_INT_EN_SHIFT)
#define  PIC_WDMA_DMA2_INT_EN_CL_ALI_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA2_INT_EN_CL_ALI_INT_EN_MASK) | (((uint32_t)val) << PIC_WDMA_DMA2_INT_EN_CL_ALI_INT_EN_SHIFT))

#define  PIC_WDMA_DMA2_INT_EN_EOL_ALI_INT_EN_MASK 0x10
#define  PIC_WDMA_DMA2_INT_EN_EOL_ALI_INT_EN_SHIFT 4
#define  PIC_WDMA_DMA2_INT_EN_EOL_ALI_INT_EN_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA2_INT_EN_EOL_ALI_INT_EN_MASK) >> PIC_WDMA_DMA2_INT_EN_EOL_ALI_INT_EN_SHIFT)
#define  PIC_WDMA_DMA2_INT_EN_EOL_ALI_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA2_INT_EN_EOL_ALI_INT_EN_MASK) | (((uint32_t)val) << PIC_WDMA_DMA2_INT_EN_EOL_ALI_INT_EN_SHIFT))

#define  PIC_WDMA_DMA2_INT_EN_EOI_ALI_INT_EN_MASK 0x8
#define  PIC_WDMA_DMA2_INT_EN_EOI_ALI_INT_EN_SHIFT 3
#define  PIC_WDMA_DMA2_INT_EN_EOI_ALI_INT_EN_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA2_INT_EN_EOI_ALI_INT_EN_MASK) >> PIC_WDMA_DMA2_INT_EN_EOI_ALI_INT_EN_SHIFT)
#define  PIC_WDMA_DMA2_INT_EN_EOI_ALI_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA2_INT_EN_EOI_ALI_INT_EN_MASK) | (((uint32_t)val) << PIC_WDMA_DMA2_INT_EN_EOI_ALI_INT_EN_SHIFT))

#define  PIC_WDMA_DMA2_INT_EN_EOI_ERR_INT_EN_MASK 0x4
#define  PIC_WDMA_DMA2_INT_EN_EOI_ERR_INT_EN_SHIFT 2
#define  PIC_WDMA_DMA2_INT_EN_EOI_ERR_INT_EN_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA2_INT_EN_EOI_ERR_INT_EN_MASK) >> PIC_WDMA_DMA2_INT_EN_EOI_ERR_INT_EN_SHIFT)
#define  PIC_WDMA_DMA2_INT_EN_EOI_ERR_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA2_INT_EN_EOI_ERR_INT_EN_MASK) | (((uint32_t)val) << PIC_WDMA_DMA2_INT_EN_EOI_ERR_INT_EN_SHIFT))

#define  PIC_WDMA_DMA2_INT_EN_FIN_INT_EN_MASK 0x2
#define  PIC_WDMA_DMA2_INT_EN_FIN_INT_EN_SHIFT 1
#define  PIC_WDMA_DMA2_INT_EN_FIN_INT_EN_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA2_INT_EN_FIN_INT_EN_MASK) >> PIC_WDMA_DMA2_INT_EN_FIN_INT_EN_SHIFT)
#define  PIC_WDMA_DMA2_INT_EN_FIN_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA2_INT_EN_FIN_INT_EN_MASK) | (((uint32_t)val) << PIC_WDMA_DMA2_INT_EN_FIN_INT_EN_SHIFT))

#define  PIC_WDMA_DMA2_INT_EN_WHO_INT_EN_MASK 0x1
#define  PIC_WDMA_DMA2_INT_EN_WHO_INT_EN_SHIFT 0
#define  PIC_WDMA_DMA2_INT_EN_WHO_INT_EN_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA2_INT_EN_WHO_INT_EN_MASK) >> PIC_WDMA_DMA2_INT_EN_WHO_INT_EN_SHIFT)
#define  PIC_WDMA_DMA2_INT_EN_WHO_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA2_INT_EN_WHO_INT_EN_MASK) | (((uint32_t)val) << PIC_WDMA_DMA2_INT_EN_WHO_INT_EN_SHIFT))

//====================================================================
//Register: Interrupt Pending Register (int_pend)
//====================================================================

#define  PIC_WDMA_DMA2_INT_PEND_RESERVED1_MASK 0xfffff800
#define  PIC_WDMA_DMA2_INT_PEND_RESERVED1_SHIFT 11
#define  PIC_WDMA_DMA2_INT_PEND_RESERVED1_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA2_INT_PEND_RESERVED1_MASK) >> PIC_WDMA_DMA2_INT_PEND_RESERVED1_SHIFT)
#define  PIC_WDMA_DMA2_INT_PEND_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA2_INT_PEND_RESERVED1_MASK) | (((uint32_t)val) << PIC_WDMA_DMA2_INT_PEND_RESERVED1_SHIFT))

#define  PIC_WDMA_DMA2_INT_PEND_RRESP_INT_PEND_MASK 0x400
#define  PIC_WDMA_DMA2_INT_PEND_RRESP_INT_PEND_SHIFT 10
#define  PIC_WDMA_DMA2_INT_PEND_RRESP_INT_PEND_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA2_INT_PEND_RRESP_INT_PEND_MASK) >> PIC_WDMA_DMA2_INT_PEND_RRESP_INT_PEND_SHIFT)
#define  PIC_WDMA_DMA2_INT_PEND_RRESP_INT_PEND_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA2_INT_PEND_RRESP_INT_PEND_MASK) | (((uint32_t)val) << PIC_WDMA_DMA2_INT_PEND_RRESP_INT_PEND_SHIFT))

#define  PIC_WDMA_DMA2_INT_PEND_BRESP_INT_PEND_MASK 0x200
#define  PIC_WDMA_DMA2_INT_PEND_BRESP_INT_PEND_SHIFT 9
#define  PIC_WDMA_DMA2_INT_PEND_BRESP_INT_PEND_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA2_INT_PEND_BRESP_INT_PEND_MASK) >> PIC_WDMA_DMA2_INT_PEND_BRESP_INT_PEND_SHIFT)
#define  PIC_WDMA_DMA2_INT_PEND_BRESP_INT_PEND_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA2_INT_PEND_BRESP_INT_PEND_MASK) | (((uint32_t)val) << PIC_WDMA_DMA2_INT_PEND_BRESP_INT_PEND_SHIFT))

#define  PIC_WDMA_DMA2_INT_PEND_RST_INT_PEND_MASK 0x100
#define  PIC_WDMA_DMA2_INT_PEND_RST_INT_PEND_SHIFT 8
#define  PIC_WDMA_DMA2_INT_PEND_RST_INT_PEND_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA2_INT_PEND_RST_INT_PEND_MASK) >> PIC_WDMA_DMA2_INT_PEND_RST_INT_PEND_SHIFT)
#define  PIC_WDMA_DMA2_INT_PEND_RST_INT_PEND_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA2_INT_PEND_RST_INT_PEND_MASK) | (((uint32_t)val) << PIC_WDMA_DMA2_INT_PEND_RST_INT_PEND_SHIFT))

#define  PIC_WDMA_DMA2_INT_PEND_EOI_INT_PEND_MASK 0x80
#define  PIC_WDMA_DMA2_INT_PEND_EOI_INT_PEND_SHIFT 7
#define  PIC_WDMA_DMA2_INT_PEND_EOI_INT_PEND_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA2_INT_PEND_EOI_INT_PEND_MASK) >> PIC_WDMA_DMA2_INT_PEND_EOI_INT_PEND_SHIFT)
#define  PIC_WDMA_DMA2_INT_PEND_EOI_INT_PEND_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA2_INT_PEND_EOI_INT_PEND_MASK) | (((uint32_t)val) << PIC_WDMA_DMA2_INT_PEND_EOI_INT_PEND_SHIFT))

#define  PIC_WDMA_DMA2_INT_PEND_DIR_INT_PEND_MASK 0x40
#define  PIC_WDMA_DMA2_INT_PEND_DIR_INT_PEND_SHIFT 6
#define  PIC_WDMA_DMA2_INT_PEND_DIR_INT_PEND_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA2_INT_PEND_DIR_INT_PEND_MASK) >> PIC_WDMA_DMA2_INT_PEND_DIR_INT_PEND_SHIFT)
#define  PIC_WDMA_DMA2_INT_PEND_DIR_INT_PEND_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA2_INT_PEND_DIR_INT_PEND_MASK) | (((uint32_t)val) << PIC_WDMA_DMA2_INT_PEND_DIR_INT_PEND_SHIFT))

#define  PIC_WDMA_DMA2_INT_PEND_CL_ALI_INT_PEND_MASK 0x20
#define  PIC_WDMA_DMA2_INT_PEND_CL_ALI_INT_PEND_SHIFT 5
#define  PIC_WDMA_DMA2_INT_PEND_CL_ALI_INT_PEND_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA2_INT_PEND_CL_ALI_INT_PEND_MASK) >> PIC_WDMA_DMA2_INT_PEND_CL_ALI_INT_PEND_SHIFT)
#define  PIC_WDMA_DMA2_INT_PEND_CL_ALI_INT_PEND_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA2_INT_PEND_CL_ALI_INT_PEND_MASK) | (((uint32_t)val) << PIC_WDMA_DMA2_INT_PEND_CL_ALI_INT_PEND_SHIFT))

#define  PIC_WDMA_DMA2_INT_PEND_EOL_ALI_INT_PEND_MASK 0x10
#define  PIC_WDMA_DMA2_INT_PEND_EOL_ALI_INT_PEND_SHIFT 4
#define  PIC_WDMA_DMA2_INT_PEND_EOL_ALI_INT_PEND_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA2_INT_PEND_EOL_ALI_INT_PEND_MASK) >> PIC_WDMA_DMA2_INT_PEND_EOL_ALI_INT_PEND_SHIFT)
#define  PIC_WDMA_DMA2_INT_PEND_EOL_ALI_INT_PEND_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA2_INT_PEND_EOL_ALI_INT_PEND_MASK) | (((uint32_t)val) << PIC_WDMA_DMA2_INT_PEND_EOL_ALI_INT_PEND_SHIFT))

#define  PIC_WDMA_DMA2_INT_PEND_EOI_ALI_INT_PEND_MASK 0x8
#define  PIC_WDMA_DMA2_INT_PEND_EOI_ALI_INT_PEND_SHIFT 3
#define  PIC_WDMA_DMA2_INT_PEND_EOI_ALI_INT_PEND_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA2_INT_PEND_EOI_ALI_INT_PEND_MASK) >> PIC_WDMA_DMA2_INT_PEND_EOI_ALI_INT_PEND_SHIFT)
#define  PIC_WDMA_DMA2_INT_PEND_EOI_ALI_INT_PEND_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA2_INT_PEND_EOI_ALI_INT_PEND_MASK) | (((uint32_t)val) << PIC_WDMA_DMA2_INT_PEND_EOI_ALI_INT_PEND_SHIFT))

#define  PIC_WDMA_DMA2_INT_PEND_EOI_ERR_INT_PEND_MASK 0x4
#define  PIC_WDMA_DMA2_INT_PEND_EOI_ERR_INT_PEND_SHIFT 2
#define  PIC_WDMA_DMA2_INT_PEND_EOI_ERR_INT_PEND_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA2_INT_PEND_EOI_ERR_INT_PEND_MASK) >> PIC_WDMA_DMA2_INT_PEND_EOI_ERR_INT_PEND_SHIFT)
#define  PIC_WDMA_DMA2_INT_PEND_EOI_ERR_INT_PEND_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA2_INT_PEND_EOI_ERR_INT_PEND_MASK) | (((uint32_t)val) << PIC_WDMA_DMA2_INT_PEND_EOI_ERR_INT_PEND_SHIFT))

#define  PIC_WDMA_DMA2_INT_PEND_FIN_INT_PEND_MASK 0x2
#define  PIC_WDMA_DMA2_INT_PEND_FIN_INT_PEND_SHIFT 1
#define  PIC_WDMA_DMA2_INT_PEND_FIN_INT_PEND_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA2_INT_PEND_FIN_INT_PEND_MASK) >> PIC_WDMA_DMA2_INT_PEND_FIN_INT_PEND_SHIFT)
#define  PIC_WDMA_DMA2_INT_PEND_FIN_INT_PEND_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA2_INT_PEND_FIN_INT_PEND_MASK) | (((uint32_t)val) << PIC_WDMA_DMA2_INT_PEND_FIN_INT_PEND_SHIFT))

#define  PIC_WDMA_DMA2_INT_PEND_WHO_INT_PEND_MASK 0x1
#define  PIC_WDMA_DMA2_INT_PEND_WHO_INT_PEND_SHIFT 0
#define  PIC_WDMA_DMA2_INT_PEND_WHO_INT_PEND_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA2_INT_PEND_WHO_INT_PEND_MASK) >> PIC_WDMA_DMA2_INT_PEND_WHO_INT_PEND_SHIFT)
#define  PIC_WDMA_DMA2_INT_PEND_WHO_INT_PEND_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA2_INT_PEND_WHO_INT_PEND_MASK) | (((uint32_t)val) << PIC_WDMA_DMA2_INT_PEND_WHO_INT_PEND_SHIFT))

//====================================================================
//Register: Interrupt Acknowledge Register (int_ack)
//====================================================================

#define  PIC_WDMA_DMA2_INT_ACK_RESERVED1_MASK 0xfffff800
#define  PIC_WDMA_DMA2_INT_ACK_RESERVED1_SHIFT 11
#define  PIC_WDMA_DMA2_INT_ACK_RESERVED1_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA2_INT_ACK_RESERVED1_MASK) >> PIC_WDMA_DMA2_INT_ACK_RESERVED1_SHIFT)
#define  PIC_WDMA_DMA2_INT_ACK_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA2_INT_ACK_RESERVED1_MASK) | (((uint32_t)val) << PIC_WDMA_DMA2_INT_ACK_RESERVED1_SHIFT))

#define  PIC_WDMA_DMA2_INT_ACK_RRESP_INT_ACK_MASK 0x400
#define  PIC_WDMA_DMA2_INT_ACK_RRESP_INT_ACK_SHIFT 10
#define  PIC_WDMA_DMA2_INT_ACK_RRESP_INT_ACK_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA2_INT_ACK_RRESP_INT_ACK_MASK) >> PIC_WDMA_DMA2_INT_ACK_RRESP_INT_ACK_SHIFT)
#define  PIC_WDMA_DMA2_INT_ACK_RRESP_INT_ACK_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA2_INT_ACK_RRESP_INT_ACK_MASK) | (((uint32_t)val) << PIC_WDMA_DMA2_INT_ACK_RRESP_INT_ACK_SHIFT))

#define  PIC_WDMA_DMA2_INT_ACK_BRESP_INT_ACK_MASK 0x200
#define  PIC_WDMA_DMA2_INT_ACK_BRESP_INT_ACK_SHIFT 9
#define  PIC_WDMA_DMA2_INT_ACK_BRESP_INT_ACK_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA2_INT_ACK_BRESP_INT_ACK_MASK) >> PIC_WDMA_DMA2_INT_ACK_BRESP_INT_ACK_SHIFT)
#define  PIC_WDMA_DMA2_INT_ACK_BRESP_INT_ACK_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA2_INT_ACK_BRESP_INT_ACK_MASK) | (((uint32_t)val) << PIC_WDMA_DMA2_INT_ACK_BRESP_INT_ACK_SHIFT))

#define  PIC_WDMA_DMA2_INT_ACK_RST_INT_ACK_MASK 0x100
#define  PIC_WDMA_DMA2_INT_ACK_RST_INT_ACK_SHIFT 8
#define  PIC_WDMA_DMA2_INT_ACK_RST_INT_ACK_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA2_INT_ACK_RST_INT_ACK_MASK) >> PIC_WDMA_DMA2_INT_ACK_RST_INT_ACK_SHIFT)
#define  PIC_WDMA_DMA2_INT_ACK_RST_INT_ACK_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA2_INT_ACK_RST_INT_ACK_MASK) | (((uint32_t)val) << PIC_WDMA_DMA2_INT_ACK_RST_INT_ACK_SHIFT))

#define  PIC_WDMA_DMA2_INT_ACK_EOI_INT_ACK_MASK 0x80
#define  PIC_WDMA_DMA2_INT_ACK_EOI_INT_ACK_SHIFT 7
#define  PIC_WDMA_DMA2_INT_ACK_EOI_INT_ACK_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA2_INT_ACK_EOI_INT_ACK_MASK) >> PIC_WDMA_DMA2_INT_ACK_EOI_INT_ACK_SHIFT)
#define  PIC_WDMA_DMA2_INT_ACK_EOI_INT_ACK_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA2_INT_ACK_EOI_INT_ACK_MASK) | (((uint32_t)val) << PIC_WDMA_DMA2_INT_ACK_EOI_INT_ACK_SHIFT))

#define  PIC_WDMA_DMA2_INT_ACK_DIR_INT_ACK_MASK 0x40
#define  PIC_WDMA_DMA2_INT_ACK_DIR_INT_ACK_SHIFT 6
#define  PIC_WDMA_DMA2_INT_ACK_DIR_INT_ACK_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA2_INT_ACK_DIR_INT_ACK_MASK) >> PIC_WDMA_DMA2_INT_ACK_DIR_INT_ACK_SHIFT)
#define  PIC_WDMA_DMA2_INT_ACK_DIR_INT_ACK_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA2_INT_ACK_DIR_INT_ACK_MASK) | (((uint32_t)val) << PIC_WDMA_DMA2_INT_ACK_DIR_INT_ACK_SHIFT))

#define  PIC_WDMA_DMA2_INT_ACK_CL_ALI_INT_ACK_MASK 0x20
#define  PIC_WDMA_DMA2_INT_ACK_CL_ALI_INT_ACK_SHIFT 5
#define  PIC_WDMA_DMA2_INT_ACK_CL_ALI_INT_ACK_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA2_INT_ACK_CL_ALI_INT_ACK_MASK) >> PIC_WDMA_DMA2_INT_ACK_CL_ALI_INT_ACK_SHIFT)
#define  PIC_WDMA_DMA2_INT_ACK_CL_ALI_INT_ACK_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA2_INT_ACK_CL_ALI_INT_ACK_MASK) | (((uint32_t)val) << PIC_WDMA_DMA2_INT_ACK_CL_ALI_INT_ACK_SHIFT))

#define  PIC_WDMA_DMA2_INT_ACK_EOL_ALI_INT_ACK_MASK 0x10
#define  PIC_WDMA_DMA2_INT_ACK_EOL_ALI_INT_ACK_SHIFT 4
#define  PIC_WDMA_DMA2_INT_ACK_EOL_ALI_INT_ACK_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA2_INT_ACK_EOL_ALI_INT_ACK_MASK) >> PIC_WDMA_DMA2_INT_ACK_EOL_ALI_INT_ACK_SHIFT)
#define  PIC_WDMA_DMA2_INT_ACK_EOL_ALI_INT_ACK_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA2_INT_ACK_EOL_ALI_INT_ACK_MASK) | (((uint32_t)val) << PIC_WDMA_DMA2_INT_ACK_EOL_ALI_INT_ACK_SHIFT))

#define  PIC_WDMA_DMA2_INT_ACK_EOI_ALI_INT_ACK_MASK 0x8
#define  PIC_WDMA_DMA2_INT_ACK_EOI_ALI_INT_ACK_SHIFT 3
#define  PIC_WDMA_DMA2_INT_ACK_EOI_ALI_INT_ACK_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA2_INT_ACK_EOI_ALI_INT_ACK_MASK) >> PIC_WDMA_DMA2_INT_ACK_EOI_ALI_INT_ACK_SHIFT)
#define  PIC_WDMA_DMA2_INT_ACK_EOI_ALI_INT_ACK_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA2_INT_ACK_EOI_ALI_INT_ACK_MASK) | (((uint32_t)val) << PIC_WDMA_DMA2_INT_ACK_EOI_ALI_INT_ACK_SHIFT))

#define  PIC_WDMA_DMA2_INT_ACK_EOI_ERR_INT_ACK_MASK 0x4
#define  PIC_WDMA_DMA2_INT_ACK_EOI_ERR_INT_ACK_SHIFT 2
#define  PIC_WDMA_DMA2_INT_ACK_EOI_ERR_INT_ACK_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA2_INT_ACK_EOI_ERR_INT_ACK_MASK) >> PIC_WDMA_DMA2_INT_ACK_EOI_ERR_INT_ACK_SHIFT)
#define  PIC_WDMA_DMA2_INT_ACK_EOI_ERR_INT_ACK_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA2_INT_ACK_EOI_ERR_INT_ACK_MASK) | (((uint32_t)val) << PIC_WDMA_DMA2_INT_ACK_EOI_ERR_INT_ACK_SHIFT))

#define  PIC_WDMA_DMA2_INT_ACK_FIN_INT_ACK_MASK 0x2
#define  PIC_WDMA_DMA2_INT_ACK_FIN_INT_ACK_SHIFT 1
#define  PIC_WDMA_DMA2_INT_ACK_FIN_INT_ACK_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA2_INT_ACK_FIN_INT_ACK_MASK) >> PIC_WDMA_DMA2_INT_ACK_FIN_INT_ACK_SHIFT)
#define  PIC_WDMA_DMA2_INT_ACK_FIN_INT_ACK_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA2_INT_ACK_FIN_INT_ACK_MASK) | (((uint32_t)val) << PIC_WDMA_DMA2_INT_ACK_FIN_INT_ACK_SHIFT))

#define  PIC_WDMA_DMA2_INT_ACK_WHO_INT_ACK_MASK 0x1
#define  PIC_WDMA_DMA2_INT_ACK_WHO_INT_ACK_SHIFT 0
#define  PIC_WDMA_DMA2_INT_ACK_WHO_INT_ACK_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA2_INT_ACK_WHO_INT_ACK_MASK) >> PIC_WDMA_DMA2_INT_ACK_WHO_INT_ACK_SHIFT)
#define  PIC_WDMA_DMA2_INT_ACK_WHO_INT_ACK_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA2_INT_ACK_WHO_INT_ACK_MASK) | (((uint32_t)val) << PIC_WDMA_DMA2_INT_ACK_WHO_INT_ACK_SHIFT))

//====================================================================
//Register: Interrupt Force Register (int_fo)
//====================================================================

#define  PIC_WDMA_DMA2_INT_FO_RESERVED1_MASK 0xfffff800
#define  PIC_WDMA_DMA2_INT_FO_RESERVED1_SHIFT 11
#define  PIC_WDMA_DMA2_INT_FO_RESERVED1_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA2_INT_FO_RESERVED1_MASK) >> PIC_WDMA_DMA2_INT_FO_RESERVED1_SHIFT)
#define  PIC_WDMA_DMA2_INT_FO_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA2_INT_FO_RESERVED1_MASK) | (((uint32_t)val) << PIC_WDMA_DMA2_INT_FO_RESERVED1_SHIFT))

#define  PIC_WDMA_DMA2_INT_FO_RRESP_INT_FO_MASK 0x400
#define  PIC_WDMA_DMA2_INT_FO_RRESP_INT_FO_SHIFT 10
#define  PIC_WDMA_DMA2_INT_FO_RRESP_INT_FO_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA2_INT_FO_RRESP_INT_FO_MASK) >> PIC_WDMA_DMA2_INT_FO_RRESP_INT_FO_SHIFT)
#define  PIC_WDMA_DMA2_INT_FO_RRESP_INT_FO_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA2_INT_FO_RRESP_INT_FO_MASK) | (((uint32_t)val) << PIC_WDMA_DMA2_INT_FO_RRESP_INT_FO_SHIFT))

#define  PIC_WDMA_DMA2_INT_FO_BRESP_INT_FO_MASK 0x200
#define  PIC_WDMA_DMA2_INT_FO_BRESP_INT_FO_SHIFT 9
#define  PIC_WDMA_DMA2_INT_FO_BRESP_INT_FO_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA2_INT_FO_BRESP_INT_FO_MASK) >> PIC_WDMA_DMA2_INT_FO_BRESP_INT_FO_SHIFT)
#define  PIC_WDMA_DMA2_INT_FO_BRESP_INT_FO_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA2_INT_FO_BRESP_INT_FO_MASK) | (((uint32_t)val) << PIC_WDMA_DMA2_INT_FO_BRESP_INT_FO_SHIFT))

#define  PIC_WDMA_DMA2_INT_FO_RST_INT_FO_MASK 0x100
#define  PIC_WDMA_DMA2_INT_FO_RST_INT_FO_SHIFT 8
#define  PIC_WDMA_DMA2_INT_FO_RST_INT_FO_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA2_INT_FO_RST_INT_FO_MASK) >> PIC_WDMA_DMA2_INT_FO_RST_INT_FO_SHIFT)
#define  PIC_WDMA_DMA2_INT_FO_RST_INT_FO_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA2_INT_FO_RST_INT_FO_MASK) | (((uint32_t)val) << PIC_WDMA_DMA2_INT_FO_RST_INT_FO_SHIFT))

#define  PIC_WDMA_DMA2_INT_FO_EOI_INT_FO_MASK 0x80
#define  PIC_WDMA_DMA2_INT_FO_EOI_INT_FO_SHIFT 7
#define  PIC_WDMA_DMA2_INT_FO_EOI_INT_FO_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA2_INT_FO_EOI_INT_FO_MASK) >> PIC_WDMA_DMA2_INT_FO_EOI_INT_FO_SHIFT)
#define  PIC_WDMA_DMA2_INT_FO_EOI_INT_FO_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA2_INT_FO_EOI_INT_FO_MASK) | (((uint32_t)val) << PIC_WDMA_DMA2_INT_FO_EOI_INT_FO_SHIFT))

#define  PIC_WDMA_DMA2_INT_FO_DIR_INT_FO_MASK 0x40
#define  PIC_WDMA_DMA2_INT_FO_DIR_INT_FO_SHIFT 6
#define  PIC_WDMA_DMA2_INT_FO_DIR_INT_FO_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA2_INT_FO_DIR_INT_FO_MASK) >> PIC_WDMA_DMA2_INT_FO_DIR_INT_FO_SHIFT)
#define  PIC_WDMA_DMA2_INT_FO_DIR_INT_FO_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA2_INT_FO_DIR_INT_FO_MASK) | (((uint32_t)val) << PIC_WDMA_DMA2_INT_FO_DIR_INT_FO_SHIFT))

#define  PIC_WDMA_DMA2_INT_FO_CL_ALI_INT_FO_MASK 0x20
#define  PIC_WDMA_DMA2_INT_FO_CL_ALI_INT_FO_SHIFT 5
#define  PIC_WDMA_DMA2_INT_FO_CL_ALI_INT_FO_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA2_INT_FO_CL_ALI_INT_FO_MASK) >> PIC_WDMA_DMA2_INT_FO_CL_ALI_INT_FO_SHIFT)
#define  PIC_WDMA_DMA2_INT_FO_CL_ALI_INT_FO_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA2_INT_FO_CL_ALI_INT_FO_MASK) | (((uint32_t)val) << PIC_WDMA_DMA2_INT_FO_CL_ALI_INT_FO_SHIFT))

#define  PIC_WDMA_DMA2_INT_FO_EOL_ALI_INT_FO_MASK 0x10
#define  PIC_WDMA_DMA2_INT_FO_EOL_ALI_INT_FO_SHIFT 4
#define  PIC_WDMA_DMA2_INT_FO_EOL_ALI_INT_FO_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA2_INT_FO_EOL_ALI_INT_FO_MASK) >> PIC_WDMA_DMA2_INT_FO_EOL_ALI_INT_FO_SHIFT)
#define  PIC_WDMA_DMA2_INT_FO_EOL_ALI_INT_FO_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA2_INT_FO_EOL_ALI_INT_FO_MASK) | (((uint32_t)val) << PIC_WDMA_DMA2_INT_FO_EOL_ALI_INT_FO_SHIFT))

#define  PIC_WDMA_DMA2_INT_FO_EOI_ALI_INT_FO_MASK 0x8
#define  PIC_WDMA_DMA2_INT_FO_EOI_ALI_INT_FO_SHIFT 3
#define  PIC_WDMA_DMA2_INT_FO_EOI_ALI_INT_FO_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA2_INT_FO_EOI_ALI_INT_FO_MASK) >> PIC_WDMA_DMA2_INT_FO_EOI_ALI_INT_FO_SHIFT)
#define  PIC_WDMA_DMA2_INT_FO_EOI_ALI_INT_FO_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA2_INT_FO_EOI_ALI_INT_FO_MASK) | (((uint32_t)val) << PIC_WDMA_DMA2_INT_FO_EOI_ALI_INT_FO_SHIFT))

#define  PIC_WDMA_DMA2_INT_FO_EOI_ERR_INT_FO_MASK 0x4
#define  PIC_WDMA_DMA2_INT_FO_EOI_ERR_INT_FO_SHIFT 2
#define  PIC_WDMA_DMA2_INT_FO_EOI_ERR_INT_FO_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA2_INT_FO_EOI_ERR_INT_FO_MASK) >> PIC_WDMA_DMA2_INT_FO_EOI_ERR_INT_FO_SHIFT)
#define  PIC_WDMA_DMA2_INT_FO_EOI_ERR_INT_FO_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA2_INT_FO_EOI_ERR_INT_FO_MASK) | (((uint32_t)val) << PIC_WDMA_DMA2_INT_FO_EOI_ERR_INT_FO_SHIFT))

#define  PIC_WDMA_DMA2_INT_FO_FIN_INT_FO_MASK 0x2
#define  PIC_WDMA_DMA2_INT_FO_FIN_INT_FO_SHIFT 1
#define  PIC_WDMA_DMA2_INT_FO_FIN_INT_FO_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA2_INT_FO_FIN_INT_FO_MASK) >> PIC_WDMA_DMA2_INT_FO_FIN_INT_FO_SHIFT)
#define  PIC_WDMA_DMA2_INT_FO_FIN_INT_FO_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA2_INT_FO_FIN_INT_FO_MASK) | (((uint32_t)val) << PIC_WDMA_DMA2_INT_FO_FIN_INT_FO_SHIFT))

#define  PIC_WDMA_DMA2_INT_FO_WHO_INT_FO_MASK 0x1
#define  PIC_WDMA_DMA2_INT_FO_WHO_INT_FO_SHIFT 0
#define  PIC_WDMA_DMA2_INT_FO_WHO_INT_FO_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA2_INT_FO_WHO_INT_FO_MASK) >> PIC_WDMA_DMA2_INT_FO_WHO_INT_FO_SHIFT)
#define  PIC_WDMA_DMA2_INT_FO_WHO_INT_FO_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA2_INT_FO_WHO_INT_FO_MASK) | (((uint32_t)val) << PIC_WDMA_DMA2_INT_FO_WHO_INT_FO_SHIFT))

//====================================================================
//Register: Descriptor Write Register (desc_write)
//====================================================================

#define  PIC_WDMA_DMA2_DESC_WRITE_DESC_MASK 0xfffffffc
#define  PIC_WDMA_DMA2_DESC_WRITE_DESC_SHIFT 2
#define  PIC_WDMA_DMA2_DESC_WRITE_DESC_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA2_DESC_WRITE_DESC_MASK) >> PIC_WDMA_DMA2_DESC_WRITE_DESC_SHIFT)
#define  PIC_WDMA_DMA2_DESC_WRITE_DESC_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA2_DESC_WRITE_DESC_MASK) | (((uint32_t)val) << PIC_WDMA_DMA2_DESC_WRITE_DESC_SHIFT))

#define  PIC_WDMA_DMA2_DESC_WRITE_RESERVED1_MASK 0x3
#define  PIC_WDMA_DMA2_DESC_WRITE_RESERVED1_SHIFT 0
#define  PIC_WDMA_DMA2_DESC_WRITE_RESERVED1_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA2_DESC_WRITE_RESERVED1_MASK) >> PIC_WDMA_DMA2_DESC_WRITE_RESERVED1_SHIFT)
#define  PIC_WDMA_DMA2_DESC_WRITE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA2_DESC_WRITE_RESERVED1_MASK) | (((uint32_t)val) << PIC_WDMA_DMA2_DESC_WRITE_RESERVED1_SHIFT))

//====================================================================
//Register: Descriptor Read Register (desc_read)
//====================================================================

#define  PIC_WDMA_DMA2_DESC_READ_DESC_MASK 0xffffffff
#define  PIC_WDMA_DMA2_DESC_READ_DESC_SHIFT 0
#define  PIC_WDMA_DMA2_DESC_READ_DESC_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA2_DESC_READ_DESC_MASK) >> PIC_WDMA_DMA2_DESC_READ_DESC_SHIFT)
#define  PIC_WDMA_DMA2_DESC_READ_DESC_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA2_DESC_READ_DESC_MASK) | (((uint32_t)val) << PIC_WDMA_DMA2_DESC_READ_DESC_SHIFT))

//====================================================================
//Register: Descriptor Transfer Length Register (xfer_length)
//====================================================================

#define  PIC_WDMA_DMA2_XFER_LENGTH_LEN_MASK 0xffffffff
#define  PIC_WDMA_DMA2_XFER_LENGTH_LEN_SHIFT 0
#define  PIC_WDMA_DMA2_XFER_LENGTH_LEN_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA2_XFER_LENGTH_LEN_MASK) >> PIC_WDMA_DMA2_XFER_LENGTH_LEN_SHIFT)
#define  PIC_WDMA_DMA2_XFER_LENGTH_LEN_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA2_XFER_LENGTH_LEN_MASK) | (((uint32_t)val) << PIC_WDMA_DMA2_XFER_LENGTH_LEN_SHIFT))

//====================================================================
//Register: Descriptor Transfer Address Register (xfer_addr)
//====================================================================

#define  PIC_WDMA_DMA2_XFER_ADDR_ADDR_MASK 0xffffffff
#define  PIC_WDMA_DMA2_XFER_ADDR_ADDR_SHIFT 0
#define  PIC_WDMA_DMA2_XFER_ADDR_ADDR_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA2_XFER_ADDR_ADDR_MASK) >> PIC_WDMA_DMA2_XFER_ADDR_ADDR_SHIFT)
#define  PIC_WDMA_DMA2_XFER_ADDR_ADDR_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA2_XFER_ADDR_ADDR_MASK) | (((uint32_t)val) << PIC_WDMA_DMA2_XFER_ADDR_ADDR_SHIFT))

//====================================================================
//Register: Descriptor Transfer Burst Register (xfer_burst)
//====================================================================

#define  PIC_WDMA_DMA2_XFER_BURST_RESERVED1_MASK 0xffffffe0
#define  PIC_WDMA_DMA2_XFER_BURST_RESERVED1_SHIFT 5
#define  PIC_WDMA_DMA2_XFER_BURST_RESERVED1_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA2_XFER_BURST_RESERVED1_MASK) >> PIC_WDMA_DMA2_XFER_BURST_RESERVED1_SHIFT)
#define  PIC_WDMA_DMA2_XFER_BURST_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA2_XFER_BURST_RESERVED1_MASK) | (((uint32_t)val) << PIC_WDMA_DMA2_XFER_BURST_RESERVED1_SHIFT))

#define  PIC_WDMA_DMA2_XFER_BURST_BURST_MASK 0x1f
#define  PIC_WDMA_DMA2_XFER_BURST_BURST_SHIFT 0
#define  PIC_WDMA_DMA2_XFER_BURST_BURST_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA2_XFER_BURST_BURST_MASK) >> PIC_WDMA_DMA2_XFER_BURST_BURST_SHIFT)
#define  PIC_WDMA_DMA2_XFER_BURST_BURST_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA2_XFER_BURST_BURST_MASK) | (((uint32_t)val) << PIC_WDMA_DMA2_XFER_BURST_BURST_SHIFT))

//====================================================================
//Register: Soft Reset register (reset)
//====================================================================

#define  PIC_WDMA_DMA2_RESET_RESERVED1_MASK 0xfffffffc
#define  PIC_WDMA_DMA2_RESET_RESERVED1_SHIFT 2
#define  PIC_WDMA_DMA2_RESET_RESERVED1_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA2_RESET_RESERVED1_MASK) >> PIC_WDMA_DMA2_RESET_RESERVED1_SHIFT)
#define  PIC_WDMA_DMA2_RESET_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA2_RESET_RESERVED1_MASK) | (((uint32_t)val) << PIC_WDMA_DMA2_RESET_RESERVED1_SHIFT))

#define  PIC_WDMA_DMA2_RESET_FORCE_LAST_BURST_MASK 0x2
#define  PIC_WDMA_DMA2_RESET_FORCE_LAST_BURST_SHIFT 1
#define  PIC_WDMA_DMA2_RESET_FORCE_LAST_BURST_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA2_RESET_FORCE_LAST_BURST_MASK) >> PIC_WDMA_DMA2_RESET_FORCE_LAST_BURST_SHIFT)
#define  PIC_WDMA_DMA2_RESET_FORCE_LAST_BURST_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA2_RESET_FORCE_LAST_BURST_MASK) | (((uint32_t)val) << PIC_WDMA_DMA2_RESET_FORCE_LAST_BURST_SHIFT))

#define  PIC_WDMA_DMA2_RESET_SOFT_RESET_MASK 0x1
#define  PIC_WDMA_DMA2_RESET_SOFT_RESET_SHIFT 0
#define  PIC_WDMA_DMA2_RESET_SOFT_RESET_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA2_RESET_SOFT_RESET_MASK) >> PIC_WDMA_DMA2_RESET_SOFT_RESET_SHIFT)
#define  PIC_WDMA_DMA2_RESET_SOFT_RESET_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA2_RESET_SOFT_RESET_MASK) | (((uint32_t)val) << PIC_WDMA_DMA2_RESET_SOFT_RESET_SHIFT))

//====================================================================
//Register: IP Tagging Revision 0 (REV0)
/** \brief Provide means for firmware to read IP tagging information.
      This register of particular interest to firmware.*/
//====================================================================

#define  PIC_WDMA_DMA2_REV0_MAJ_MASK 0xffff0000
#define  PIC_WDMA_DMA2_REV0_MAJ_SHIFT 16
#define  PIC_WDMA_DMA2_REV0_MAJ_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA2_REV0_MAJ_MASK) >> PIC_WDMA_DMA2_REV0_MAJ_SHIFT)
#define  PIC_WDMA_DMA2_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA2_REV0_MAJ_MASK) | (((uint32_t)val) << PIC_WDMA_DMA2_REV0_MAJ_SHIFT))

#define  PIC_WDMA_DMA2_REV0_MID_MASK 0xffff
#define  PIC_WDMA_DMA2_REV0_MID_SHIFT 0
#define  PIC_WDMA_DMA2_REV0_MID_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA2_REV0_MID_MASK) >> PIC_WDMA_DMA2_REV0_MID_SHIFT)
#define  PIC_WDMA_DMA2_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA2_REV0_MID_MASK) | (((uint32_t)val) << PIC_WDMA_DMA2_REV0_MID_SHIFT))

//====================================================================
//Register: IP Tagging Revision 1 (REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  PIC_WDMA_DMA2_REV1_RESERVED1_MASK 0xffff0000
#define  PIC_WDMA_DMA2_REV1_RESERVED1_SHIFT 16
#define  PIC_WDMA_DMA2_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA2_REV1_RESERVED1_MASK) >> PIC_WDMA_DMA2_REV1_RESERVED1_SHIFT)
#define  PIC_WDMA_DMA2_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA2_REV1_RESERVED1_MASK) | (((uint32_t)val) << PIC_WDMA_DMA2_REV1_RESERVED1_SHIFT))

#define  PIC_WDMA_DMA2_REV1_CFG_MASK 0xffff
#define  PIC_WDMA_DMA2_REV1_CFG_SHIFT 0
#define  PIC_WDMA_DMA2_REV1_CFG_MASK_SHIFT(reg) (((reg) & PIC_WDMA_DMA2_REV1_CFG_MASK) >> PIC_WDMA_DMA2_REV1_CFG_SHIFT)
#define  PIC_WDMA_DMA2_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~PIC_WDMA_DMA2_REV1_CFG_MASK) | (((uint32_t)val) << PIC_WDMA_DMA2_REV1_CFG_SHIFT))

#endif // PIC
