 /*
 **************************************************************************************
 *
 * (c) Copyright 2013 Marvell International Ltd.
 *
 *
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/.
 *
 **************************************************************************************
 *
 * \file PERFTR_regstructs.h
 * Generated using RegBuild 1.6.3
 *
 **************************************************************************************
 */

#ifndef _PERFTR_REGSTRUCTS_H_
#define _PERFTR_REGSTRUCTS_H_

#ifndef __KERNEL__
#include <stdint.h>
#endif

//====================================================================
//
//Register File: Perforator (PERFTR)
/** \brief Top-level register file for the Perforator block <br/> (rev 0 . 1 . 3 . 1)*/
//
//====================================================================

typedef struct PERFTR_REGS_s
{
  volatile uint32_t CfgPerf;  ///< 0x0 [R/W]: Perforator Control
  volatile uint32_t REV0;  ///< 0x4 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0x8 [R]: IP Tagging Revision 1
} PERFTR_REGS_t;

//====================================================================
//
//Register File: PERFTR channel C (PERFTR_CoreC)
/** \brief Control registers for one channel of the Perforator block.*/
//
//====================================================================

typedef struct PERFTR_COREC_REGS_s
{
  volatile uint32_t Rows;  ///< 0x0 [R/W]: Number of Mask Rows
  volatile uint32_t Columns;  ///< 0x4 [R/W]: Number of Mask Columns
  volatile uint32_t Shift;  ///< 0x8 [R/W]: Mask Shift Amount
  volatile uint32_t Thresh;  ///< 0xc [R/W]: Edge Strengh Threshold
  volatile uint32_t StartingRow;  ///< 0x10 [R/W]: Starting Row
  volatile uint32_t StartingCol;  ///< 0x14 [R/W]: Starting Column
  volatile uint32_t SaveState0;  ///< 0x18 [R]: Save State 0
  volatile uint32_t SaveState1;  ///< 0x1c [R]: Save State 1
  volatile uint32_t RestoreState0;  ///< 0x20 [R/W]: Restore State 0
  volatile uint32_t RestoreState1;  ///< 0x24 [R/W]: Restore State 1
  volatile uint32_t reserved0[6];
  volatile uint32_t RAMAcc[16];  ///< 0x40 [R/W]: Mask RAM access
} PERFTR_COREC_REGS_t;

//====================================================================
//
//Register File: PERFTR channel M (PERFTR_CoreM)
/** \brief Control registers for one channel of the Perforator block.*/
//
//====================================================================

typedef struct PERFTR_COREM_REGS_s
{
  volatile uint32_t Rows;  ///< 0x0 [R/W]: Number of Mask Rows
  volatile uint32_t Columns;  ///< 0x4 [R/W]: Number of Mask Columns
  volatile uint32_t Shift;  ///< 0x8 [R/W]: Mask Shift Amount
  volatile uint32_t Thresh;  ///< 0xc [R/W]: Edge Strengh Threshold
  volatile uint32_t StartingRow;  ///< 0x10 [R/W]: Starting Row
  volatile uint32_t StartingCol;  ///< 0x14 [R/W]: Starting Column
  volatile uint32_t SaveState0;  ///< 0x18 [R]: Save State 0
  volatile uint32_t SaveState1;  ///< 0x1c [R]: Save State 1
  volatile uint32_t RestoreState0;  ///< 0x20 [R/W]: Restore State 0
  volatile uint32_t RestoreState1;  ///< 0x24 [R/W]: Restore State 1
  volatile uint32_t reserved0[6];
  volatile uint32_t RAMAcc[16];  ///< 0x40 [R/W]: Mask RAM access
} PERFTR_COREM_REGS_t;

//====================================================================
//
//Register File: PERFTR channel Y (PERFTR_CoreY)
/** \brief Control registers for one channel of the Perforator block.*/
//
//====================================================================

typedef struct PERFTR_COREY_REGS_s
{
  volatile uint32_t Rows;  ///< 0x0 [R/W]: Number of Mask Rows
  volatile uint32_t Columns;  ///< 0x4 [R/W]: Number of Mask Columns
  volatile uint32_t Shift;  ///< 0x8 [R/W]: Mask Shift Amount
  volatile uint32_t Thresh;  ///< 0xc [R/W]: Edge Strengh Threshold
  volatile uint32_t StartingRow;  ///< 0x10 [R/W]: Starting Row
  volatile uint32_t StartingCol;  ///< 0x14 [R/W]: Starting Column
  volatile uint32_t SaveState0;  ///< 0x18 [R]: Save State 0
  volatile uint32_t SaveState1;  ///< 0x1c [R]: Save State 1
  volatile uint32_t RestoreState0;  ///< 0x20 [R/W]: Restore State 0
  volatile uint32_t RestoreState1;  ///< 0x24 [R/W]: Restore State 1
  volatile uint32_t reserved0[6];
  volatile uint32_t RAMAcc[16];  ///< 0x40 [R/W]: Mask RAM access
} PERFTR_COREY_REGS_t;

//====================================================================
//
//Register File: PERFTR channel K (PERFTR_CoreK)
/** \brief Control registers for one channel of the Perforator block.*/
//
//====================================================================

typedef struct PERFTR_COREK_REGS_s
{
  volatile uint32_t Rows;  ///< 0x0 [R/W]: Number of Mask Rows
  volatile uint32_t Columns;  ///< 0x4 [R/W]: Number of Mask Columns
  volatile uint32_t Shift;  ///< 0x8 [R/W]: Mask Shift Amount
  volatile uint32_t Thresh;  ///< 0xc [R/W]: Edge Strengh Threshold
  volatile uint32_t StartingRow;  ///< 0x10 [R/W]: Starting Row
  volatile uint32_t StartingCol;  ///< 0x14 [R/W]: Starting Column
  volatile uint32_t SaveState0;  ///< 0x18 [R]: Save State 0
  volatile uint32_t SaveState1;  ///< 0x1c [R]: Save State 1
  volatile uint32_t RestoreState0;  ///< 0x20 [R/W]: Restore State 0
  volatile uint32_t RestoreState1;  ///< 0x24 [R/W]: Restore State 1
  volatile uint32_t reserved0[6];
  volatile uint32_t RAMAcc[16];  ///< 0x40 [R/W]: Mask RAM access
} PERFTR_COREK_REGS_t;

#endif // PERFTR
