 /*
 **************************************************************************************
 *
 * (c) Copyright 2013 Marvell International Ltd.
 *
 *
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/.
 *
 **************************************************************************************
 *
 * \file PERFTR_regmasks.h
 * Generated using RegBuild 1.6.3
 *
 **************************************************************************************
 */

#ifndef _PERFTR_REGMASKS_H_
#define _PERFTR_REGMASKS_H_

#ifndef __KERNEL__
#include <stdint.h>
#endif

//====================================================================
//
//Register File: Perforator (PERFTR)
/** \brief Top-level register file for the Perforator block <br/> (rev 0 . 1 . 3 . 1)*/
//
//====================================================================

//====================================================================
//Register: Perforator Control (CfgPerf)
/** \brief Common control register for the Peforator block.*/
//====================================================================

#define  PERFTR_CFGPERF_RESERVED1_MASK 0xfffffffc
#define  PERFTR_CFGPERF_RESERVED1_SHIFT 2
#define  PERFTR_CFGPERF_RESERVED1_MASK_SHIFT(reg) (((reg) & PERFTR_CFGPERF_RESERVED1_MASK) >> PERFTR_CFGPERF_RESERVED1_SHIFT)
#define  PERFTR_CFGPERF_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PERFTR_CFGPERF_RESERVED1_MASK) | (((uint32_t)val) << PERFTR_CFGPERF_RESERVED1_SHIFT))

#define  PERFTR_CFGPERF_CPUACCESS_MASK 0x2
#define  PERFTR_CFGPERF_CPUACCESS_SHIFT 1
#define  PERFTR_CFGPERF_CPUACCESS_MASK_SHIFT(reg) (((reg) & PERFTR_CFGPERF_CPUACCESS_MASK) >> PERFTR_CFGPERF_CPUACCESS_SHIFT)
#define  PERFTR_CFGPERF_CPUACCESS_REPLACE_VAL(reg,val) (((reg) & ~PERFTR_CFGPERF_CPUACCESS_MASK) | (((uint32_t)val) << PERFTR_CFGPERF_CPUACCESS_SHIFT))

#define  PERFTR_CFGPERF_BYPASS_MASK 0x1
#define  PERFTR_CFGPERF_BYPASS_SHIFT 0
#define  PERFTR_CFGPERF_BYPASS_MASK_SHIFT(reg) (((reg) & PERFTR_CFGPERF_BYPASS_MASK) >> PERFTR_CFGPERF_BYPASS_SHIFT)
#define  PERFTR_CFGPERF_BYPASS_REPLACE_VAL(reg,val) (((reg) & ~PERFTR_CFGPERF_BYPASS_MASK) | (((uint32_t)val) << PERFTR_CFGPERF_BYPASS_SHIFT))

//====================================================================
//Register: IP Tagging Revision 0 (REV0)
/** \brief Provide means for firmware to read IP tagging information.
      This register of particular interest to firmware.*/
//====================================================================

#define  PERFTR_REV0_MAJ_MASK 0xffff0000
#define  PERFTR_REV0_MAJ_SHIFT 16
#define  PERFTR_REV0_MAJ_MASK_SHIFT(reg) (((reg) & PERFTR_REV0_MAJ_MASK) >> PERFTR_REV0_MAJ_SHIFT)
#define  PERFTR_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~PERFTR_REV0_MAJ_MASK) | (((uint32_t)val) << PERFTR_REV0_MAJ_SHIFT))

#define  PERFTR_REV0_MID_MASK 0xffff
#define  PERFTR_REV0_MID_SHIFT 0
#define  PERFTR_REV0_MID_MASK_SHIFT(reg) (((reg) & PERFTR_REV0_MID_MASK) >> PERFTR_REV0_MID_SHIFT)
#define  PERFTR_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~PERFTR_REV0_MID_MASK) | (((uint32_t)val) << PERFTR_REV0_MID_SHIFT))

//====================================================================
//Register: IP Tagging Revision 1 (REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  PERFTR_REV1_RESERVED1_MASK 0xffff0000
#define  PERFTR_REV1_RESERVED1_SHIFT 16
#define  PERFTR_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & PERFTR_REV1_RESERVED1_MASK) >> PERFTR_REV1_RESERVED1_SHIFT)
#define  PERFTR_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PERFTR_REV1_RESERVED1_MASK) | (((uint32_t)val) << PERFTR_REV1_RESERVED1_SHIFT))

#define  PERFTR_REV1_CFG_MASK 0xffff
#define  PERFTR_REV1_CFG_SHIFT 0
#define  PERFTR_REV1_CFG_MASK_SHIFT(reg) (((reg) & PERFTR_REV1_CFG_MASK) >> PERFTR_REV1_CFG_SHIFT)
#define  PERFTR_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~PERFTR_REV1_CFG_MASK) | (((uint32_t)val) << PERFTR_REV1_CFG_SHIFT))

//====================================================================
//
//Register File: PERFTR channel C (PERFTR_CoreC)
/** \brief Control registers for one channel of the Perforator block.*/
//
//====================================================================

//====================================================================
//Register: Number of Mask Rows (Rows)
/** \brief This register sets the height of the mask rectangle, in rows, for the channel.
        Rows x Columns should not exceed the size of available rectangle memory (in bits).
        The value written is one less than the desired number of rows (0 = 1 row, etc.)*/
//====================================================================

#define  PERFTR_COREC_ROWS_RESERVED1_MASK 0xffffff00
#define  PERFTR_COREC_ROWS_RESERVED1_SHIFT 8
#define  PERFTR_COREC_ROWS_RESERVED1_MASK_SHIFT(reg) (((reg) & PERFTR_COREC_ROWS_RESERVED1_MASK) >> PERFTR_COREC_ROWS_RESERVED1_SHIFT)
#define  PERFTR_COREC_ROWS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PERFTR_COREC_ROWS_RESERVED1_MASK) | (((uint32_t)val) << PERFTR_COREC_ROWS_RESERVED1_SHIFT))

#define  PERFTR_COREC_ROWS_VALUE_MASK 0xff
#define  PERFTR_COREC_ROWS_VALUE_SHIFT 0
#define  PERFTR_COREC_ROWS_VALUE_MASK_SHIFT(reg) (((reg) & PERFTR_COREC_ROWS_VALUE_MASK) >> PERFTR_COREC_ROWS_VALUE_SHIFT)
#define  PERFTR_COREC_ROWS_VALUE_REPLACE_VAL(reg,val) (((reg) & ~PERFTR_COREC_ROWS_VALUE_MASK) | (((uint32_t)val) << PERFTR_COREC_ROWS_VALUE_SHIFT))

//====================================================================
//Register: Number of Mask Columns (Columns)
/** \brief This register sets the width of the mask rectangle, in columns, for the channel.
        Rows x Columns should not exceed the size of available rectangle memory (in bits).
        The value written is one less than the desired number of columns (0 = 1 column, etc.)*/
//====================================================================

#define  PERFTR_COREC_COLUMNS_RESERVED1_MASK 0xffffff00
#define  PERFTR_COREC_COLUMNS_RESERVED1_SHIFT 8
#define  PERFTR_COREC_COLUMNS_RESERVED1_MASK_SHIFT(reg) (((reg) & PERFTR_COREC_COLUMNS_RESERVED1_MASK) >> PERFTR_COREC_COLUMNS_RESERVED1_SHIFT)
#define  PERFTR_COREC_COLUMNS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PERFTR_COREC_COLUMNS_RESERVED1_MASK) | (((uint32_t)val) << PERFTR_COREC_COLUMNS_RESERVED1_SHIFT))

#define  PERFTR_COREC_COLUMNS_VALUE_MASK 0xff
#define  PERFTR_COREC_COLUMNS_VALUE_SHIFT 0
#define  PERFTR_COREC_COLUMNS_VALUE_MASK_SHIFT(reg) (((reg) & PERFTR_COREC_COLUMNS_VALUE_MASK) >> PERFTR_COREC_COLUMNS_VALUE_SHIFT)
#define  PERFTR_COREC_COLUMNS_VALUE_REPLACE_VAL(reg,val) (((reg) & ~PERFTR_COREC_COLUMNS_VALUE_MASK) | (((uint32_t)val) << PERFTR_COREC_COLUMNS_VALUE_SHIFT))

//====================================================================
//Register: Mask Shift Amount (Shift)
/** \brief This register sets the column shift used when tiling the rectangle across the image.*/
//====================================================================

#define  PERFTR_COREC_SHIFT_RESERVED1_MASK 0xffffff00
#define  PERFTR_COREC_SHIFT_RESERVED1_SHIFT 8
#define  PERFTR_COREC_SHIFT_RESERVED1_MASK_SHIFT(reg) (((reg) & PERFTR_COREC_SHIFT_RESERVED1_MASK) >> PERFTR_COREC_SHIFT_RESERVED1_SHIFT)
#define  PERFTR_COREC_SHIFT_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PERFTR_COREC_SHIFT_RESERVED1_MASK) | (((uint32_t)val) << PERFTR_COREC_SHIFT_RESERVED1_SHIFT))

#define  PERFTR_COREC_SHIFT_VALUE_MASK 0xff
#define  PERFTR_COREC_SHIFT_VALUE_SHIFT 0
#define  PERFTR_COREC_SHIFT_VALUE_MASK_SHIFT(reg) (((reg) & PERFTR_COREC_SHIFT_VALUE_MASK) >> PERFTR_COREC_SHIFT_VALUE_SHIFT)
#define  PERFTR_COREC_SHIFT_VALUE_REPLACE_VAL(reg,val) (((reg) & ~PERFTR_COREC_SHIFT_VALUE_MASK) | (((uint32_t)val) << PERFTR_COREC_SHIFT_VALUE_SHIFT))

//====================================================================
//Register: Edge Strengh Threshold (Thresh)
/** \brief This sets an edge strength threshold. If the edge strength for a pixel exceeds this value, then the
        pixel data will not be replaced with zero data, regardless of the mask bit being applied from the
        tiled rectangle. Note that a value of 15 here will prevent edge strength data from overriding the mask.*/
//====================================================================

#define  PERFTR_COREC_THRESH_RESERVED1_MASK 0xfffffff0
#define  PERFTR_COREC_THRESH_RESERVED1_SHIFT 4
#define  PERFTR_COREC_THRESH_RESERVED1_MASK_SHIFT(reg) (((reg) & PERFTR_COREC_THRESH_RESERVED1_MASK) >> PERFTR_COREC_THRESH_RESERVED1_SHIFT)
#define  PERFTR_COREC_THRESH_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PERFTR_COREC_THRESH_RESERVED1_MASK) | (((uint32_t)val) << PERFTR_COREC_THRESH_RESERVED1_SHIFT))

#define  PERFTR_COREC_THRESH_VALUE_MASK 0xf
#define  PERFTR_COREC_THRESH_VALUE_SHIFT 0
#define  PERFTR_COREC_THRESH_VALUE_MASK_SHIFT(reg) (((reg) & PERFTR_COREC_THRESH_VALUE_MASK) >> PERFTR_COREC_THRESH_VALUE_SHIFT)
#define  PERFTR_COREC_THRESH_VALUE_REPLACE_VAL(reg,val) (((reg) & ~PERFTR_COREC_THRESH_VALUE_MASK) | (((uint32_t)val) << PERFTR_COREC_THRESH_VALUE_SHIFT))

//====================================================================
//Register: Starting Row (StartingRow)
/** \brief When a Start-of-Image data type is detected in the pipe, the Current Row register will be set to this value,
        which will then be used as the first active row of the mask.*/
//====================================================================

#define  PERFTR_COREC_STARTINGROW_RESERVED1_MASK 0xffffff00
#define  PERFTR_COREC_STARTINGROW_RESERVED1_SHIFT 8
#define  PERFTR_COREC_STARTINGROW_RESERVED1_MASK_SHIFT(reg) (((reg) & PERFTR_COREC_STARTINGROW_RESERVED1_MASK) >> PERFTR_COREC_STARTINGROW_RESERVED1_SHIFT)
#define  PERFTR_COREC_STARTINGROW_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PERFTR_COREC_STARTINGROW_RESERVED1_MASK) | (((uint32_t)val) << PERFTR_COREC_STARTINGROW_RESERVED1_SHIFT))

#define  PERFTR_COREC_STARTINGROW_VALUE_MASK 0xff
#define  PERFTR_COREC_STARTINGROW_VALUE_SHIFT 0
#define  PERFTR_COREC_STARTINGROW_VALUE_MASK_SHIFT(reg) (((reg) & PERFTR_COREC_STARTINGROW_VALUE_MASK) >> PERFTR_COREC_STARTINGROW_VALUE_SHIFT)
#define  PERFTR_COREC_STARTINGROW_VALUE_REPLACE_VAL(reg,val) (((reg) & ~PERFTR_COREC_STARTINGROW_VALUE_MASK) | (((uint32_t)val) << PERFTR_COREC_STARTINGROW_VALUE_SHIFT))

//====================================================================
//Register: Starting Column (StartingCol)
/** \brief This register sets the column number of the tiling rectangle which is applied to the first pixel
        in a line. Two values are set, one for left-to-right operation, and one for right-to-left operation. These values are loaded into the Line Starting Column registers when a Start-of-Image data type is detected in the pipe. One of these, selected based on line direction, is also loaded into the Current Column register. As the mask is tiled down an image, the Line Starting Column registers are modified by the Shift value each time the Row number returns to 0 and the
        tiling rectangle restarts, shifting the rectangle across the image.*/
//====================================================================

#define  PERFTR_COREC_STARTINGCOL_RESERVED1_MASK 0xffff0000
#define  PERFTR_COREC_STARTINGCOL_RESERVED1_SHIFT 16
#define  PERFTR_COREC_STARTINGCOL_RESERVED1_MASK_SHIFT(reg) (((reg) & PERFTR_COREC_STARTINGCOL_RESERVED1_MASK) >> PERFTR_COREC_STARTINGCOL_RESERVED1_SHIFT)
#define  PERFTR_COREC_STARTINGCOL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PERFTR_COREC_STARTINGCOL_RESERVED1_MASK) | (((uint32_t)val) << PERFTR_COREC_STARTINGCOL_RESERVED1_SHIFT))

#define  PERFTR_COREC_STARTINGCOL_R2L_MASK 0xff00
#define  PERFTR_COREC_STARTINGCOL_R2L_SHIFT 8
#define  PERFTR_COREC_STARTINGCOL_R2L_MASK_SHIFT(reg) (((reg) & PERFTR_COREC_STARTINGCOL_R2L_MASK) >> PERFTR_COREC_STARTINGCOL_R2L_SHIFT)
#define  PERFTR_COREC_STARTINGCOL_R2L_REPLACE_VAL(reg,val) (((reg) & ~PERFTR_COREC_STARTINGCOL_R2L_MASK) | (((uint32_t)val) << PERFTR_COREC_STARTINGCOL_R2L_SHIFT))

#define  PERFTR_COREC_STARTINGCOL_L2R_MASK 0xff
#define  PERFTR_COREC_STARTINGCOL_L2R_SHIFT 0
#define  PERFTR_COREC_STARTINGCOL_L2R_MASK_SHIFT(reg) (((reg) & PERFTR_COREC_STARTINGCOL_L2R_MASK) >> PERFTR_COREC_STARTINGCOL_L2R_SHIFT)
#define  PERFTR_COREC_STARTINGCOL_L2R_REPLACE_VAL(reg,val) (((reg) & ~PERFTR_COREC_STARTINGCOL_L2R_MASK) | (((uint32_t)val) << PERFTR_COREC_STARTINGCOL_L2R_SHIFT))

//====================================================================
//Register: Save State 0 (SaveState0)
/** \brief This register returns internal state information. Used to capture state during a save/restore operation.*/
//====================================================================

#define  PERFTR_COREC_SAVESTATE0_RESERVED1_MASK 0xff000000
#define  PERFTR_COREC_SAVESTATE0_RESERVED1_SHIFT 24
#define  PERFTR_COREC_SAVESTATE0_RESERVED1_MASK_SHIFT(reg) (((reg) & PERFTR_COREC_SAVESTATE0_RESERVED1_MASK) >> PERFTR_COREC_SAVESTATE0_RESERVED1_SHIFT)
#define  PERFTR_COREC_SAVESTATE0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PERFTR_COREC_SAVESTATE0_RESERVED1_MASK) | (((uint32_t)val) << PERFTR_COREC_SAVESTATE0_RESERVED1_SHIFT))

#define  PERFTR_COREC_SAVESTATE0_STATE_MASK 0xffffff
#define  PERFTR_COREC_SAVESTATE0_STATE_SHIFT 0
#define  PERFTR_COREC_SAVESTATE0_STATE_MASK_SHIFT(reg) (((reg) & PERFTR_COREC_SAVESTATE0_STATE_MASK) >> PERFTR_COREC_SAVESTATE0_STATE_SHIFT)
#define  PERFTR_COREC_SAVESTATE0_STATE_REPLACE_VAL(reg,val) (((reg) & ~PERFTR_COREC_SAVESTATE0_STATE_MASK) | (((uint32_t)val) << PERFTR_COREC_SAVESTATE0_STATE_SHIFT))

//====================================================================
//Register: Save State 1 (SaveState1)
/** \brief This register returns internal state information. Used to capture state during a save/restore operation.*/
//====================================================================

#define  PERFTR_COREC_SAVESTATE1_RESERVED1_MASK 0xffe00000
#define  PERFTR_COREC_SAVESTATE1_RESERVED1_SHIFT 21
#define  PERFTR_COREC_SAVESTATE1_RESERVED1_MASK_SHIFT(reg) (((reg) & PERFTR_COREC_SAVESTATE1_RESERVED1_MASK) >> PERFTR_COREC_SAVESTATE1_RESERVED1_SHIFT)
#define  PERFTR_COREC_SAVESTATE1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PERFTR_COREC_SAVESTATE1_RESERVED1_MASK) | (((uint32_t)val) << PERFTR_COREC_SAVESTATE1_RESERVED1_SHIFT))

#define  PERFTR_COREC_SAVESTATE1_STATE_MASK 0x1fffff
#define  PERFTR_COREC_SAVESTATE1_STATE_SHIFT 0
#define  PERFTR_COREC_SAVESTATE1_STATE_MASK_SHIFT(reg) (((reg) & PERFTR_COREC_SAVESTATE1_STATE_MASK) >> PERFTR_COREC_SAVESTATE1_STATE_SHIFT)
#define  PERFTR_COREC_SAVESTATE1_STATE_REPLACE_VAL(reg,val) (((reg) & ~PERFTR_COREC_SAVESTATE1_STATE_MASK) | (((uint32_t)val) << PERFTR_COREC_SAVESTATE1_STATE_SHIFT))

//====================================================================
//Register: Restore State 0 (RestoreState0)
/** \brief Returns internal state information to a prior saved condition. Corresponds with SaveState0. This can be used to restore the PERFTR block to a known operating state before resuming a suspended operation.*/
//====================================================================

#define  PERFTR_COREC_RESTORESTATE0_RESERVED1_MASK 0xff000000
#define  PERFTR_COREC_RESTORESTATE0_RESERVED1_SHIFT 24
#define  PERFTR_COREC_RESTORESTATE0_RESERVED1_MASK_SHIFT(reg) (((reg) & PERFTR_COREC_RESTORESTATE0_RESERVED1_MASK) >> PERFTR_COREC_RESTORESTATE0_RESERVED1_SHIFT)
#define  PERFTR_COREC_RESTORESTATE0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PERFTR_COREC_RESTORESTATE0_RESERVED1_MASK) | (((uint32_t)val) << PERFTR_COREC_RESTORESTATE0_RESERVED1_SHIFT))

#define  PERFTR_COREC_RESTORESTATE0_STATE_MASK 0xffffff
#define  PERFTR_COREC_RESTORESTATE0_STATE_SHIFT 0
#define  PERFTR_COREC_RESTORESTATE0_STATE_MASK_SHIFT(reg) (((reg) & PERFTR_COREC_RESTORESTATE0_STATE_MASK) >> PERFTR_COREC_RESTORESTATE0_STATE_SHIFT)
#define  PERFTR_COREC_RESTORESTATE0_STATE_REPLACE_VAL(reg,val) (((reg) & ~PERFTR_COREC_RESTORESTATE0_STATE_MASK) | (((uint32_t)val) << PERFTR_COREC_RESTORESTATE0_STATE_SHIFT))

//====================================================================
//Register: Restore State 1 (RestoreState1)
/** \brief Returns internal state information to a prior saved condition. Corresponds with SaveState1. This can be used to restore the PERFTR block to a known operating state before resuming a suspended operation.*/
//====================================================================

#define  PERFTR_COREC_RESTORESTATE1_RESERVED1_MASK 0xffe00000
#define  PERFTR_COREC_RESTORESTATE1_RESERVED1_SHIFT 21
#define  PERFTR_COREC_RESTORESTATE1_RESERVED1_MASK_SHIFT(reg) (((reg) & PERFTR_COREC_RESTORESTATE1_RESERVED1_MASK) >> PERFTR_COREC_RESTORESTATE1_RESERVED1_SHIFT)
#define  PERFTR_COREC_RESTORESTATE1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PERFTR_COREC_RESTORESTATE1_RESERVED1_MASK) | (((uint32_t)val) << PERFTR_COREC_RESTORESTATE1_RESERVED1_SHIFT))

#define  PERFTR_COREC_RESTORESTATE1_STATE_MASK 0x1fffff
#define  PERFTR_COREC_RESTORESTATE1_STATE_SHIFT 0
#define  PERFTR_COREC_RESTORESTATE1_STATE_MASK_SHIFT(reg) (((reg) & PERFTR_COREC_RESTORESTATE1_STATE_MASK) >> PERFTR_COREC_RESTORESTATE1_STATE_SHIFT)
#define  PERFTR_COREC_RESTORESTATE1_STATE_REPLACE_VAL(reg,val) (((reg) & ~PERFTR_COREC_RESTORESTATE1_STATE_MASK) | (((uint32_t)val) << PERFTR_COREC_RESTORESTATE1_STATE_SHIFT))

//====================================================================
//Register: Mask RAM access (RAMAcc)
/** \brief Holds the rectangular mask for the channel. Directly accessible when the CpuAccess bit of the Perforator
common control register is set.*/
//====================================================================

#define  PERFTR_COREC_RAMACC_RESERVED1_MASK 0xffff0000
#define  PERFTR_COREC_RAMACC_RESERVED1_SHIFT 16
#define  PERFTR_COREC_RAMACC_RESERVED1_MASK_SHIFT(reg) (((reg) & PERFTR_COREC_RAMACC_RESERVED1_MASK) >> PERFTR_COREC_RAMACC_RESERVED1_SHIFT)
#define  PERFTR_COREC_RAMACC_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PERFTR_COREC_RAMACC_RESERVED1_MASK) | (((uint32_t)val) << PERFTR_COREC_RAMACC_RESERVED1_SHIFT))

#define  PERFTR_COREC_RAMACC_DATA_MASK 0xffff
#define  PERFTR_COREC_RAMACC_DATA_SHIFT 0
#define  PERFTR_COREC_RAMACC_DATA_MASK_SHIFT(reg) (((reg) & PERFTR_COREC_RAMACC_DATA_MASK) >> PERFTR_COREC_RAMACC_DATA_SHIFT)
#define  PERFTR_COREC_RAMACC_DATA_REPLACE_VAL(reg,val) (((reg) & ~PERFTR_COREC_RAMACC_DATA_MASK) | (((uint32_t)val) << PERFTR_COREC_RAMACC_DATA_SHIFT))

//====================================================================
//
//Register File: PERFTR channel M (PERFTR_CoreM)
/** \brief Control registers for one channel of the Perforator block.*/
//
//====================================================================

//====================================================================
//Register: Number of Mask Rows (Rows)
/** \brief This register sets the height of the mask rectangle, in rows, for the channel.
        Rows x Columns should not exceed the size of available rectangle memory (in bits).
        The value written is one less than the desired number of rows (0 = 1 row, etc.)*/
//====================================================================

#define  PERFTR_COREM_ROWS_RESERVED1_MASK 0xffffff00
#define  PERFTR_COREM_ROWS_RESERVED1_SHIFT 8
#define  PERFTR_COREM_ROWS_RESERVED1_MASK_SHIFT(reg) (((reg) & PERFTR_COREM_ROWS_RESERVED1_MASK) >> PERFTR_COREM_ROWS_RESERVED1_SHIFT)
#define  PERFTR_COREM_ROWS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PERFTR_COREM_ROWS_RESERVED1_MASK) | (((uint32_t)val) << PERFTR_COREM_ROWS_RESERVED1_SHIFT))

#define  PERFTR_COREM_ROWS_VALUE_MASK 0xff
#define  PERFTR_COREM_ROWS_VALUE_SHIFT 0
#define  PERFTR_COREM_ROWS_VALUE_MASK_SHIFT(reg) (((reg) & PERFTR_COREM_ROWS_VALUE_MASK) >> PERFTR_COREM_ROWS_VALUE_SHIFT)
#define  PERFTR_COREM_ROWS_VALUE_REPLACE_VAL(reg,val) (((reg) & ~PERFTR_COREM_ROWS_VALUE_MASK) | (((uint32_t)val) << PERFTR_COREM_ROWS_VALUE_SHIFT))

//====================================================================
//Register: Number of Mask Columns (Columns)
/** \brief This register sets the width of the mask rectangle, in columns, for the channel.
        Rows x Columns should not exceed the size of available rectangle memory (in bits).
        The value written is one less than the desired number of columns (0 = 1 column, etc.)*/
//====================================================================

#define  PERFTR_COREM_COLUMNS_RESERVED1_MASK 0xffffff00
#define  PERFTR_COREM_COLUMNS_RESERVED1_SHIFT 8
#define  PERFTR_COREM_COLUMNS_RESERVED1_MASK_SHIFT(reg) (((reg) & PERFTR_COREM_COLUMNS_RESERVED1_MASK) >> PERFTR_COREM_COLUMNS_RESERVED1_SHIFT)
#define  PERFTR_COREM_COLUMNS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PERFTR_COREM_COLUMNS_RESERVED1_MASK) | (((uint32_t)val) << PERFTR_COREM_COLUMNS_RESERVED1_SHIFT))

#define  PERFTR_COREM_COLUMNS_VALUE_MASK 0xff
#define  PERFTR_COREM_COLUMNS_VALUE_SHIFT 0
#define  PERFTR_COREM_COLUMNS_VALUE_MASK_SHIFT(reg) (((reg) & PERFTR_COREM_COLUMNS_VALUE_MASK) >> PERFTR_COREM_COLUMNS_VALUE_SHIFT)
#define  PERFTR_COREM_COLUMNS_VALUE_REPLACE_VAL(reg,val) (((reg) & ~PERFTR_COREM_COLUMNS_VALUE_MASK) | (((uint32_t)val) << PERFTR_COREM_COLUMNS_VALUE_SHIFT))

//====================================================================
//Register: Mask Shift Amount (Shift)
/** \brief This register sets the column shift used when tiling the rectangle across the image.*/
//====================================================================

#define  PERFTR_COREM_SHIFT_RESERVED1_MASK 0xffffff00
#define  PERFTR_COREM_SHIFT_RESERVED1_SHIFT 8
#define  PERFTR_COREM_SHIFT_RESERVED1_MASK_SHIFT(reg) (((reg) & PERFTR_COREM_SHIFT_RESERVED1_MASK) >> PERFTR_COREM_SHIFT_RESERVED1_SHIFT)
#define  PERFTR_COREM_SHIFT_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PERFTR_COREM_SHIFT_RESERVED1_MASK) | (((uint32_t)val) << PERFTR_COREM_SHIFT_RESERVED1_SHIFT))

#define  PERFTR_COREM_SHIFT_VALUE_MASK 0xff
#define  PERFTR_COREM_SHIFT_VALUE_SHIFT 0
#define  PERFTR_COREM_SHIFT_VALUE_MASK_SHIFT(reg) (((reg) & PERFTR_COREM_SHIFT_VALUE_MASK) >> PERFTR_COREM_SHIFT_VALUE_SHIFT)
#define  PERFTR_COREM_SHIFT_VALUE_REPLACE_VAL(reg,val) (((reg) & ~PERFTR_COREM_SHIFT_VALUE_MASK) | (((uint32_t)val) << PERFTR_COREM_SHIFT_VALUE_SHIFT))

//====================================================================
//Register: Edge Strengh Threshold (Thresh)
/** \brief This sets an edge strength threshold. If the edge strength for a pixel exceeds this value, then the
        pixel data will not be replaced with zero data, regardless of the mask bit being applied from the
        tiled rectangle. Note that a value of 15 here will prevent edge strength data from overriding the mask.*/
//====================================================================

#define  PERFTR_COREM_THRESH_RESERVED1_MASK 0xfffffff0
#define  PERFTR_COREM_THRESH_RESERVED1_SHIFT 4
#define  PERFTR_COREM_THRESH_RESERVED1_MASK_SHIFT(reg) (((reg) & PERFTR_COREM_THRESH_RESERVED1_MASK) >> PERFTR_COREM_THRESH_RESERVED1_SHIFT)
#define  PERFTR_COREM_THRESH_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PERFTR_COREM_THRESH_RESERVED1_MASK) | (((uint32_t)val) << PERFTR_COREM_THRESH_RESERVED1_SHIFT))

#define  PERFTR_COREM_THRESH_VALUE_MASK 0xf
#define  PERFTR_COREM_THRESH_VALUE_SHIFT 0
#define  PERFTR_COREM_THRESH_VALUE_MASK_SHIFT(reg) (((reg) & PERFTR_COREM_THRESH_VALUE_MASK) >> PERFTR_COREM_THRESH_VALUE_SHIFT)
#define  PERFTR_COREM_THRESH_VALUE_REPLACE_VAL(reg,val) (((reg) & ~PERFTR_COREM_THRESH_VALUE_MASK) | (((uint32_t)val) << PERFTR_COREM_THRESH_VALUE_SHIFT))

//====================================================================
//Register: Starting Row (StartingRow)
/** \brief When a Start-of-Image data type is detected in the pipe, the Current Row register will be set to this value,
        which will then be used as the first active row of the mask.*/
//====================================================================

#define  PERFTR_COREM_STARTINGROW_RESERVED1_MASK 0xffffff00
#define  PERFTR_COREM_STARTINGROW_RESERVED1_SHIFT 8
#define  PERFTR_COREM_STARTINGROW_RESERVED1_MASK_SHIFT(reg) (((reg) & PERFTR_COREM_STARTINGROW_RESERVED1_MASK) >> PERFTR_COREM_STARTINGROW_RESERVED1_SHIFT)
#define  PERFTR_COREM_STARTINGROW_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PERFTR_COREM_STARTINGROW_RESERVED1_MASK) | (((uint32_t)val) << PERFTR_COREM_STARTINGROW_RESERVED1_SHIFT))

#define  PERFTR_COREM_STARTINGROW_VALUE_MASK 0xff
#define  PERFTR_COREM_STARTINGROW_VALUE_SHIFT 0
#define  PERFTR_COREM_STARTINGROW_VALUE_MASK_SHIFT(reg) (((reg) & PERFTR_COREM_STARTINGROW_VALUE_MASK) >> PERFTR_COREM_STARTINGROW_VALUE_SHIFT)
#define  PERFTR_COREM_STARTINGROW_VALUE_REPLACE_VAL(reg,val) (((reg) & ~PERFTR_COREM_STARTINGROW_VALUE_MASK) | (((uint32_t)val) << PERFTR_COREM_STARTINGROW_VALUE_SHIFT))

//====================================================================
//Register: Starting Column (StartingCol)
/** \brief This register sets the column number of the tiling rectangle which is applied to the first pixel
        in a line. Two values are set, one for left-to-right operation, and one for right-to-left operation. These values are loaded into the Line Starting Column registers when a Start-of-Image data type is detected in the pipe. One of these, selected based on line direction, is also loaded into the Current Column register. As the mask is tiled down an image, the Line Starting Column registers are modified by the Shift value each time the Row number returns to 0 and the
        tiling rectangle restarts, shifting the rectangle across the image.*/
//====================================================================

#define  PERFTR_COREM_STARTINGCOL_RESERVED1_MASK 0xffff0000
#define  PERFTR_COREM_STARTINGCOL_RESERVED1_SHIFT 16
#define  PERFTR_COREM_STARTINGCOL_RESERVED1_MASK_SHIFT(reg) (((reg) & PERFTR_COREM_STARTINGCOL_RESERVED1_MASK) >> PERFTR_COREM_STARTINGCOL_RESERVED1_SHIFT)
#define  PERFTR_COREM_STARTINGCOL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PERFTR_COREM_STARTINGCOL_RESERVED1_MASK) | (((uint32_t)val) << PERFTR_COREM_STARTINGCOL_RESERVED1_SHIFT))

#define  PERFTR_COREM_STARTINGCOL_R2L_MASK 0xff00
#define  PERFTR_COREM_STARTINGCOL_R2L_SHIFT 8
#define  PERFTR_COREM_STARTINGCOL_R2L_MASK_SHIFT(reg) (((reg) & PERFTR_COREM_STARTINGCOL_R2L_MASK) >> PERFTR_COREM_STARTINGCOL_R2L_SHIFT)
#define  PERFTR_COREM_STARTINGCOL_R2L_REPLACE_VAL(reg,val) (((reg) & ~PERFTR_COREM_STARTINGCOL_R2L_MASK) | (((uint32_t)val) << PERFTR_COREM_STARTINGCOL_R2L_SHIFT))

#define  PERFTR_COREM_STARTINGCOL_L2R_MASK 0xff
#define  PERFTR_COREM_STARTINGCOL_L2R_SHIFT 0
#define  PERFTR_COREM_STARTINGCOL_L2R_MASK_SHIFT(reg) (((reg) & PERFTR_COREM_STARTINGCOL_L2R_MASK) >> PERFTR_COREM_STARTINGCOL_L2R_SHIFT)
#define  PERFTR_COREM_STARTINGCOL_L2R_REPLACE_VAL(reg,val) (((reg) & ~PERFTR_COREM_STARTINGCOL_L2R_MASK) | (((uint32_t)val) << PERFTR_COREM_STARTINGCOL_L2R_SHIFT))

//====================================================================
//Register: Save State 0 (SaveState0)
/** \brief This register returns internal state information. Used to capture state during a save/restore operation.*/
//====================================================================

#define  PERFTR_COREM_SAVESTATE0_RESERVED1_MASK 0xff000000
#define  PERFTR_COREM_SAVESTATE0_RESERVED1_SHIFT 24
#define  PERFTR_COREM_SAVESTATE0_RESERVED1_MASK_SHIFT(reg) (((reg) & PERFTR_COREM_SAVESTATE0_RESERVED1_MASK) >> PERFTR_COREM_SAVESTATE0_RESERVED1_SHIFT)
#define  PERFTR_COREM_SAVESTATE0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PERFTR_COREM_SAVESTATE0_RESERVED1_MASK) | (((uint32_t)val) << PERFTR_COREM_SAVESTATE0_RESERVED1_SHIFT))

#define  PERFTR_COREM_SAVESTATE0_STATE_MASK 0xffffff
#define  PERFTR_COREM_SAVESTATE0_STATE_SHIFT 0
#define  PERFTR_COREM_SAVESTATE0_STATE_MASK_SHIFT(reg) (((reg) & PERFTR_COREM_SAVESTATE0_STATE_MASK) >> PERFTR_COREM_SAVESTATE0_STATE_SHIFT)
#define  PERFTR_COREM_SAVESTATE0_STATE_REPLACE_VAL(reg,val) (((reg) & ~PERFTR_COREM_SAVESTATE0_STATE_MASK) | (((uint32_t)val) << PERFTR_COREM_SAVESTATE0_STATE_SHIFT))

//====================================================================
//Register: Save State 1 (SaveState1)
/** \brief This register returns internal state information. Used to capture state during a save/restore operation.*/
//====================================================================

#define  PERFTR_COREM_SAVESTATE1_RESERVED1_MASK 0xffe00000
#define  PERFTR_COREM_SAVESTATE1_RESERVED1_SHIFT 21
#define  PERFTR_COREM_SAVESTATE1_RESERVED1_MASK_SHIFT(reg) (((reg) & PERFTR_COREM_SAVESTATE1_RESERVED1_MASK) >> PERFTR_COREM_SAVESTATE1_RESERVED1_SHIFT)
#define  PERFTR_COREM_SAVESTATE1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PERFTR_COREM_SAVESTATE1_RESERVED1_MASK) | (((uint32_t)val) << PERFTR_COREM_SAVESTATE1_RESERVED1_SHIFT))

#define  PERFTR_COREM_SAVESTATE1_STATE_MASK 0x1fffff
#define  PERFTR_COREM_SAVESTATE1_STATE_SHIFT 0
#define  PERFTR_COREM_SAVESTATE1_STATE_MASK_SHIFT(reg) (((reg) & PERFTR_COREM_SAVESTATE1_STATE_MASK) >> PERFTR_COREM_SAVESTATE1_STATE_SHIFT)
#define  PERFTR_COREM_SAVESTATE1_STATE_REPLACE_VAL(reg,val) (((reg) & ~PERFTR_COREM_SAVESTATE1_STATE_MASK) | (((uint32_t)val) << PERFTR_COREM_SAVESTATE1_STATE_SHIFT))

//====================================================================
//Register: Restore State 0 (RestoreState0)
/** \brief Returns internal state information to a prior saved condition. Corresponds with SaveState0. This can be used to restore the PERFTR block to a known operating state before resuming a suspended operation.*/
//====================================================================

#define  PERFTR_COREM_RESTORESTATE0_RESERVED1_MASK 0xff000000
#define  PERFTR_COREM_RESTORESTATE0_RESERVED1_SHIFT 24
#define  PERFTR_COREM_RESTORESTATE0_RESERVED1_MASK_SHIFT(reg) (((reg) & PERFTR_COREM_RESTORESTATE0_RESERVED1_MASK) >> PERFTR_COREM_RESTORESTATE0_RESERVED1_SHIFT)
#define  PERFTR_COREM_RESTORESTATE0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PERFTR_COREM_RESTORESTATE0_RESERVED1_MASK) | (((uint32_t)val) << PERFTR_COREM_RESTORESTATE0_RESERVED1_SHIFT))

#define  PERFTR_COREM_RESTORESTATE0_STATE_MASK 0xffffff
#define  PERFTR_COREM_RESTORESTATE0_STATE_SHIFT 0
#define  PERFTR_COREM_RESTORESTATE0_STATE_MASK_SHIFT(reg) (((reg) & PERFTR_COREM_RESTORESTATE0_STATE_MASK) >> PERFTR_COREM_RESTORESTATE0_STATE_SHIFT)
#define  PERFTR_COREM_RESTORESTATE0_STATE_REPLACE_VAL(reg,val) (((reg) & ~PERFTR_COREM_RESTORESTATE0_STATE_MASK) | (((uint32_t)val) << PERFTR_COREM_RESTORESTATE0_STATE_SHIFT))

//====================================================================
//Register: Restore State 1 (RestoreState1)
/** \brief Returns internal state information to a prior saved condition. Corresponds with SaveState1. This can be used to restore the PERFTR block to a known operating state before resuming a suspended operation.*/
//====================================================================

#define  PERFTR_COREM_RESTORESTATE1_RESERVED1_MASK 0xffe00000
#define  PERFTR_COREM_RESTORESTATE1_RESERVED1_SHIFT 21
#define  PERFTR_COREM_RESTORESTATE1_RESERVED1_MASK_SHIFT(reg) (((reg) & PERFTR_COREM_RESTORESTATE1_RESERVED1_MASK) >> PERFTR_COREM_RESTORESTATE1_RESERVED1_SHIFT)
#define  PERFTR_COREM_RESTORESTATE1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PERFTR_COREM_RESTORESTATE1_RESERVED1_MASK) | (((uint32_t)val) << PERFTR_COREM_RESTORESTATE1_RESERVED1_SHIFT))

#define  PERFTR_COREM_RESTORESTATE1_STATE_MASK 0x1fffff
#define  PERFTR_COREM_RESTORESTATE1_STATE_SHIFT 0
#define  PERFTR_COREM_RESTORESTATE1_STATE_MASK_SHIFT(reg) (((reg) & PERFTR_COREM_RESTORESTATE1_STATE_MASK) >> PERFTR_COREM_RESTORESTATE1_STATE_SHIFT)
#define  PERFTR_COREM_RESTORESTATE1_STATE_REPLACE_VAL(reg,val) (((reg) & ~PERFTR_COREM_RESTORESTATE1_STATE_MASK) | (((uint32_t)val) << PERFTR_COREM_RESTORESTATE1_STATE_SHIFT))

//====================================================================
//Register: Mask RAM access (RAMAcc)
/** \brief Holds the rectangular mask for the channel. Directly accessible when the CpuAccess bit of the Perforator
common control register is set.*/
//====================================================================

#define  PERFTR_COREM_RAMACC_RESERVED1_MASK 0xffff0000
#define  PERFTR_COREM_RAMACC_RESERVED1_SHIFT 16
#define  PERFTR_COREM_RAMACC_RESERVED1_MASK_SHIFT(reg) (((reg) & PERFTR_COREM_RAMACC_RESERVED1_MASK) >> PERFTR_COREM_RAMACC_RESERVED1_SHIFT)
#define  PERFTR_COREM_RAMACC_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PERFTR_COREM_RAMACC_RESERVED1_MASK) | (((uint32_t)val) << PERFTR_COREM_RAMACC_RESERVED1_SHIFT))

#define  PERFTR_COREM_RAMACC_DATA_MASK 0xffff
#define  PERFTR_COREM_RAMACC_DATA_SHIFT 0
#define  PERFTR_COREM_RAMACC_DATA_MASK_SHIFT(reg) (((reg) & PERFTR_COREM_RAMACC_DATA_MASK) >> PERFTR_COREM_RAMACC_DATA_SHIFT)
#define  PERFTR_COREM_RAMACC_DATA_REPLACE_VAL(reg,val) (((reg) & ~PERFTR_COREM_RAMACC_DATA_MASK) | (((uint32_t)val) << PERFTR_COREM_RAMACC_DATA_SHIFT))

//====================================================================
//
//Register File: PERFTR channel Y (PERFTR_CoreY)
/** \brief Control registers for one channel of the Perforator block.*/
//
//====================================================================

//====================================================================
//Register: Number of Mask Rows (Rows)
/** \brief This register sets the height of the mask rectangle, in rows, for the channel.
        Rows x Columns should not exceed the size of available rectangle memory (in bits).
        The value written is one less than the desired number of rows (0 = 1 row, etc.)*/
//====================================================================

#define  PERFTR_COREY_ROWS_RESERVED1_MASK 0xffffff00
#define  PERFTR_COREY_ROWS_RESERVED1_SHIFT 8
#define  PERFTR_COREY_ROWS_RESERVED1_MASK_SHIFT(reg) (((reg) & PERFTR_COREY_ROWS_RESERVED1_MASK) >> PERFTR_COREY_ROWS_RESERVED1_SHIFT)
#define  PERFTR_COREY_ROWS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PERFTR_COREY_ROWS_RESERVED1_MASK) | (((uint32_t)val) << PERFTR_COREY_ROWS_RESERVED1_SHIFT))

#define  PERFTR_COREY_ROWS_VALUE_MASK 0xff
#define  PERFTR_COREY_ROWS_VALUE_SHIFT 0
#define  PERFTR_COREY_ROWS_VALUE_MASK_SHIFT(reg) (((reg) & PERFTR_COREY_ROWS_VALUE_MASK) >> PERFTR_COREY_ROWS_VALUE_SHIFT)
#define  PERFTR_COREY_ROWS_VALUE_REPLACE_VAL(reg,val) (((reg) & ~PERFTR_COREY_ROWS_VALUE_MASK) | (((uint32_t)val) << PERFTR_COREY_ROWS_VALUE_SHIFT))

//====================================================================
//Register: Number of Mask Columns (Columns)
/** \brief This register sets the width of the mask rectangle, in columns, for the channel.
        Rows x Columns should not exceed the size of available rectangle memory (in bits).
        The value written is one less than the desired number of columns (0 = 1 column, etc.)*/
//====================================================================

#define  PERFTR_COREY_COLUMNS_RESERVED1_MASK 0xffffff00
#define  PERFTR_COREY_COLUMNS_RESERVED1_SHIFT 8
#define  PERFTR_COREY_COLUMNS_RESERVED1_MASK_SHIFT(reg) (((reg) & PERFTR_COREY_COLUMNS_RESERVED1_MASK) >> PERFTR_COREY_COLUMNS_RESERVED1_SHIFT)
#define  PERFTR_COREY_COLUMNS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PERFTR_COREY_COLUMNS_RESERVED1_MASK) | (((uint32_t)val) << PERFTR_COREY_COLUMNS_RESERVED1_SHIFT))

#define  PERFTR_COREY_COLUMNS_VALUE_MASK 0xff
#define  PERFTR_COREY_COLUMNS_VALUE_SHIFT 0
#define  PERFTR_COREY_COLUMNS_VALUE_MASK_SHIFT(reg) (((reg) & PERFTR_COREY_COLUMNS_VALUE_MASK) >> PERFTR_COREY_COLUMNS_VALUE_SHIFT)
#define  PERFTR_COREY_COLUMNS_VALUE_REPLACE_VAL(reg,val) (((reg) & ~PERFTR_COREY_COLUMNS_VALUE_MASK) | (((uint32_t)val) << PERFTR_COREY_COLUMNS_VALUE_SHIFT))

//====================================================================
//Register: Mask Shift Amount (Shift)
/** \brief This register sets the column shift used when tiling the rectangle across the image.*/
//====================================================================

#define  PERFTR_COREY_SHIFT_RESERVED1_MASK 0xffffff00
#define  PERFTR_COREY_SHIFT_RESERVED1_SHIFT 8
#define  PERFTR_COREY_SHIFT_RESERVED1_MASK_SHIFT(reg) (((reg) & PERFTR_COREY_SHIFT_RESERVED1_MASK) >> PERFTR_COREY_SHIFT_RESERVED1_SHIFT)
#define  PERFTR_COREY_SHIFT_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PERFTR_COREY_SHIFT_RESERVED1_MASK) | (((uint32_t)val) << PERFTR_COREY_SHIFT_RESERVED1_SHIFT))

#define  PERFTR_COREY_SHIFT_VALUE_MASK 0xff
#define  PERFTR_COREY_SHIFT_VALUE_SHIFT 0
#define  PERFTR_COREY_SHIFT_VALUE_MASK_SHIFT(reg) (((reg) & PERFTR_COREY_SHIFT_VALUE_MASK) >> PERFTR_COREY_SHIFT_VALUE_SHIFT)
#define  PERFTR_COREY_SHIFT_VALUE_REPLACE_VAL(reg,val) (((reg) & ~PERFTR_COREY_SHIFT_VALUE_MASK) | (((uint32_t)val) << PERFTR_COREY_SHIFT_VALUE_SHIFT))

//====================================================================
//Register: Edge Strengh Threshold (Thresh)
/** \brief This sets an edge strength threshold. If the edge strength for a pixel exceeds this value, then the
        pixel data will not be replaced with zero data, regardless of the mask bit being applied from the
        tiled rectangle. Note that a value of 15 here will prevent edge strength data from overriding the mask.*/
//====================================================================

#define  PERFTR_COREY_THRESH_RESERVED1_MASK 0xfffffff0
#define  PERFTR_COREY_THRESH_RESERVED1_SHIFT 4
#define  PERFTR_COREY_THRESH_RESERVED1_MASK_SHIFT(reg) (((reg) & PERFTR_COREY_THRESH_RESERVED1_MASK) >> PERFTR_COREY_THRESH_RESERVED1_SHIFT)
#define  PERFTR_COREY_THRESH_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PERFTR_COREY_THRESH_RESERVED1_MASK) | (((uint32_t)val) << PERFTR_COREY_THRESH_RESERVED1_SHIFT))

#define  PERFTR_COREY_THRESH_VALUE_MASK 0xf
#define  PERFTR_COREY_THRESH_VALUE_SHIFT 0
#define  PERFTR_COREY_THRESH_VALUE_MASK_SHIFT(reg) (((reg) & PERFTR_COREY_THRESH_VALUE_MASK) >> PERFTR_COREY_THRESH_VALUE_SHIFT)
#define  PERFTR_COREY_THRESH_VALUE_REPLACE_VAL(reg,val) (((reg) & ~PERFTR_COREY_THRESH_VALUE_MASK) | (((uint32_t)val) << PERFTR_COREY_THRESH_VALUE_SHIFT))

//====================================================================
//Register: Starting Row (StartingRow)
/** \brief When a Start-of-Image data type is detected in the pipe, the Current Row register will be set to this value,
        which will then be used as the first active row of the mask.*/
//====================================================================

#define  PERFTR_COREY_STARTINGROW_RESERVED1_MASK 0xffffff00
#define  PERFTR_COREY_STARTINGROW_RESERVED1_SHIFT 8
#define  PERFTR_COREY_STARTINGROW_RESERVED1_MASK_SHIFT(reg) (((reg) & PERFTR_COREY_STARTINGROW_RESERVED1_MASK) >> PERFTR_COREY_STARTINGROW_RESERVED1_SHIFT)
#define  PERFTR_COREY_STARTINGROW_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PERFTR_COREY_STARTINGROW_RESERVED1_MASK) | (((uint32_t)val) << PERFTR_COREY_STARTINGROW_RESERVED1_SHIFT))

#define  PERFTR_COREY_STARTINGROW_VALUE_MASK 0xff
#define  PERFTR_COREY_STARTINGROW_VALUE_SHIFT 0
#define  PERFTR_COREY_STARTINGROW_VALUE_MASK_SHIFT(reg) (((reg) & PERFTR_COREY_STARTINGROW_VALUE_MASK) >> PERFTR_COREY_STARTINGROW_VALUE_SHIFT)
#define  PERFTR_COREY_STARTINGROW_VALUE_REPLACE_VAL(reg,val) (((reg) & ~PERFTR_COREY_STARTINGROW_VALUE_MASK) | (((uint32_t)val) << PERFTR_COREY_STARTINGROW_VALUE_SHIFT))

//====================================================================
//Register: Starting Column (StartingCol)
/** \brief This register sets the column number of the tiling rectangle which is applied to the first pixel
        in a line. Two values are set, one for left-to-right operation, and one for right-to-left operation. These values are loaded into the Line Starting Column registers when a Start-of-Image data type is detected in the pipe. One of these, selected based on line direction, is also loaded into the Current Column register. As the mask is tiled down an image, the Line Starting Column registers are modified by the Shift value each time the Row number returns to 0 and the
        tiling rectangle restarts, shifting the rectangle across the image.*/
//====================================================================

#define  PERFTR_COREY_STARTINGCOL_RESERVED1_MASK 0xffff0000
#define  PERFTR_COREY_STARTINGCOL_RESERVED1_SHIFT 16
#define  PERFTR_COREY_STARTINGCOL_RESERVED1_MASK_SHIFT(reg) (((reg) & PERFTR_COREY_STARTINGCOL_RESERVED1_MASK) >> PERFTR_COREY_STARTINGCOL_RESERVED1_SHIFT)
#define  PERFTR_COREY_STARTINGCOL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PERFTR_COREY_STARTINGCOL_RESERVED1_MASK) | (((uint32_t)val) << PERFTR_COREY_STARTINGCOL_RESERVED1_SHIFT))

#define  PERFTR_COREY_STARTINGCOL_R2L_MASK 0xff00
#define  PERFTR_COREY_STARTINGCOL_R2L_SHIFT 8
#define  PERFTR_COREY_STARTINGCOL_R2L_MASK_SHIFT(reg) (((reg) & PERFTR_COREY_STARTINGCOL_R2L_MASK) >> PERFTR_COREY_STARTINGCOL_R2L_SHIFT)
#define  PERFTR_COREY_STARTINGCOL_R2L_REPLACE_VAL(reg,val) (((reg) & ~PERFTR_COREY_STARTINGCOL_R2L_MASK) | (((uint32_t)val) << PERFTR_COREY_STARTINGCOL_R2L_SHIFT))

#define  PERFTR_COREY_STARTINGCOL_L2R_MASK 0xff
#define  PERFTR_COREY_STARTINGCOL_L2R_SHIFT 0
#define  PERFTR_COREY_STARTINGCOL_L2R_MASK_SHIFT(reg) (((reg) & PERFTR_COREY_STARTINGCOL_L2R_MASK) >> PERFTR_COREY_STARTINGCOL_L2R_SHIFT)
#define  PERFTR_COREY_STARTINGCOL_L2R_REPLACE_VAL(reg,val) (((reg) & ~PERFTR_COREY_STARTINGCOL_L2R_MASK) | (((uint32_t)val) << PERFTR_COREY_STARTINGCOL_L2R_SHIFT))

//====================================================================
//Register: Save State 0 (SaveState0)
/** \brief This register returns internal state information. Used to capture state during a save/restore operation.*/
//====================================================================

#define  PERFTR_COREY_SAVESTATE0_RESERVED1_MASK 0xff000000
#define  PERFTR_COREY_SAVESTATE0_RESERVED1_SHIFT 24
#define  PERFTR_COREY_SAVESTATE0_RESERVED1_MASK_SHIFT(reg) (((reg) & PERFTR_COREY_SAVESTATE0_RESERVED1_MASK) >> PERFTR_COREY_SAVESTATE0_RESERVED1_SHIFT)
#define  PERFTR_COREY_SAVESTATE0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PERFTR_COREY_SAVESTATE0_RESERVED1_MASK) | (((uint32_t)val) << PERFTR_COREY_SAVESTATE0_RESERVED1_SHIFT))

#define  PERFTR_COREY_SAVESTATE0_STATE_MASK 0xffffff
#define  PERFTR_COREY_SAVESTATE0_STATE_SHIFT 0
#define  PERFTR_COREY_SAVESTATE0_STATE_MASK_SHIFT(reg) (((reg) & PERFTR_COREY_SAVESTATE0_STATE_MASK) >> PERFTR_COREY_SAVESTATE0_STATE_SHIFT)
#define  PERFTR_COREY_SAVESTATE0_STATE_REPLACE_VAL(reg,val) (((reg) & ~PERFTR_COREY_SAVESTATE0_STATE_MASK) | (((uint32_t)val) << PERFTR_COREY_SAVESTATE0_STATE_SHIFT))

//====================================================================
//Register: Save State 1 (SaveState1)
/** \brief This register returns internal state information. Used to capture state during a save/restore operation.*/
//====================================================================

#define  PERFTR_COREY_SAVESTATE1_RESERVED1_MASK 0xffe00000
#define  PERFTR_COREY_SAVESTATE1_RESERVED1_SHIFT 21
#define  PERFTR_COREY_SAVESTATE1_RESERVED1_MASK_SHIFT(reg) (((reg) & PERFTR_COREY_SAVESTATE1_RESERVED1_MASK) >> PERFTR_COREY_SAVESTATE1_RESERVED1_SHIFT)
#define  PERFTR_COREY_SAVESTATE1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PERFTR_COREY_SAVESTATE1_RESERVED1_MASK) | (((uint32_t)val) << PERFTR_COREY_SAVESTATE1_RESERVED1_SHIFT))

#define  PERFTR_COREY_SAVESTATE1_STATE_MASK 0x1fffff
#define  PERFTR_COREY_SAVESTATE1_STATE_SHIFT 0
#define  PERFTR_COREY_SAVESTATE1_STATE_MASK_SHIFT(reg) (((reg) & PERFTR_COREY_SAVESTATE1_STATE_MASK) >> PERFTR_COREY_SAVESTATE1_STATE_SHIFT)
#define  PERFTR_COREY_SAVESTATE1_STATE_REPLACE_VAL(reg,val) (((reg) & ~PERFTR_COREY_SAVESTATE1_STATE_MASK) | (((uint32_t)val) << PERFTR_COREY_SAVESTATE1_STATE_SHIFT))

//====================================================================
//Register: Restore State 0 (RestoreState0)
/** \brief Returns internal state information to a prior saved condition. Corresponds with SaveState0. This can be used to restore the PERFTR block to a known operating state before resuming a suspended operation.*/
//====================================================================

#define  PERFTR_COREY_RESTORESTATE0_RESERVED1_MASK 0xff000000
#define  PERFTR_COREY_RESTORESTATE0_RESERVED1_SHIFT 24
#define  PERFTR_COREY_RESTORESTATE0_RESERVED1_MASK_SHIFT(reg) (((reg) & PERFTR_COREY_RESTORESTATE0_RESERVED1_MASK) >> PERFTR_COREY_RESTORESTATE0_RESERVED1_SHIFT)
#define  PERFTR_COREY_RESTORESTATE0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PERFTR_COREY_RESTORESTATE0_RESERVED1_MASK) | (((uint32_t)val) << PERFTR_COREY_RESTORESTATE0_RESERVED1_SHIFT))

#define  PERFTR_COREY_RESTORESTATE0_STATE_MASK 0xffffff
#define  PERFTR_COREY_RESTORESTATE0_STATE_SHIFT 0
#define  PERFTR_COREY_RESTORESTATE0_STATE_MASK_SHIFT(reg) (((reg) & PERFTR_COREY_RESTORESTATE0_STATE_MASK) >> PERFTR_COREY_RESTORESTATE0_STATE_SHIFT)
#define  PERFTR_COREY_RESTORESTATE0_STATE_REPLACE_VAL(reg,val) (((reg) & ~PERFTR_COREY_RESTORESTATE0_STATE_MASK) | (((uint32_t)val) << PERFTR_COREY_RESTORESTATE0_STATE_SHIFT))

//====================================================================
//Register: Restore State 1 (RestoreState1)
/** \brief Returns internal state information to a prior saved condition. Corresponds with SaveState1. This can be used to restore the PERFTR block to a known operating state before resuming a suspended operation.*/
//====================================================================

#define  PERFTR_COREY_RESTORESTATE1_RESERVED1_MASK 0xffe00000
#define  PERFTR_COREY_RESTORESTATE1_RESERVED1_SHIFT 21
#define  PERFTR_COREY_RESTORESTATE1_RESERVED1_MASK_SHIFT(reg) (((reg) & PERFTR_COREY_RESTORESTATE1_RESERVED1_MASK) >> PERFTR_COREY_RESTORESTATE1_RESERVED1_SHIFT)
#define  PERFTR_COREY_RESTORESTATE1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PERFTR_COREY_RESTORESTATE1_RESERVED1_MASK) | (((uint32_t)val) << PERFTR_COREY_RESTORESTATE1_RESERVED1_SHIFT))

#define  PERFTR_COREY_RESTORESTATE1_STATE_MASK 0x1fffff
#define  PERFTR_COREY_RESTORESTATE1_STATE_SHIFT 0
#define  PERFTR_COREY_RESTORESTATE1_STATE_MASK_SHIFT(reg) (((reg) & PERFTR_COREY_RESTORESTATE1_STATE_MASK) >> PERFTR_COREY_RESTORESTATE1_STATE_SHIFT)
#define  PERFTR_COREY_RESTORESTATE1_STATE_REPLACE_VAL(reg,val) (((reg) & ~PERFTR_COREY_RESTORESTATE1_STATE_MASK) | (((uint32_t)val) << PERFTR_COREY_RESTORESTATE1_STATE_SHIFT))

//====================================================================
//Register: Mask RAM access (RAMAcc)
/** \brief Holds the rectangular mask for the channel. Directly accessible when the CpuAccess bit of the Perforator
common control register is set.*/
//====================================================================

#define  PERFTR_COREY_RAMACC_RESERVED1_MASK 0xffff0000
#define  PERFTR_COREY_RAMACC_RESERVED1_SHIFT 16
#define  PERFTR_COREY_RAMACC_RESERVED1_MASK_SHIFT(reg) (((reg) & PERFTR_COREY_RAMACC_RESERVED1_MASK) >> PERFTR_COREY_RAMACC_RESERVED1_SHIFT)
#define  PERFTR_COREY_RAMACC_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PERFTR_COREY_RAMACC_RESERVED1_MASK) | (((uint32_t)val) << PERFTR_COREY_RAMACC_RESERVED1_SHIFT))

#define  PERFTR_COREY_RAMACC_DATA_MASK 0xffff
#define  PERFTR_COREY_RAMACC_DATA_SHIFT 0
#define  PERFTR_COREY_RAMACC_DATA_MASK_SHIFT(reg) (((reg) & PERFTR_COREY_RAMACC_DATA_MASK) >> PERFTR_COREY_RAMACC_DATA_SHIFT)
#define  PERFTR_COREY_RAMACC_DATA_REPLACE_VAL(reg,val) (((reg) & ~PERFTR_COREY_RAMACC_DATA_MASK) | (((uint32_t)val) << PERFTR_COREY_RAMACC_DATA_SHIFT))

//====================================================================
//
//Register File: PERFTR channel K (PERFTR_CoreK)
/** \brief Control registers for one channel of the Perforator block.*/
//
//====================================================================

//====================================================================
//Register: Number of Mask Rows (Rows)
/** \brief This register sets the height of the mask rectangle, in rows, for the channel.
        Rows x Columns should not exceed the size of available rectangle memory (in bits).
        The value written is one less than the desired number of rows (0 = 1 row, etc.)*/
//====================================================================

#define  PERFTR_COREK_ROWS_RESERVED1_MASK 0xffffff00
#define  PERFTR_COREK_ROWS_RESERVED1_SHIFT 8
#define  PERFTR_COREK_ROWS_RESERVED1_MASK_SHIFT(reg) (((reg) & PERFTR_COREK_ROWS_RESERVED1_MASK) >> PERFTR_COREK_ROWS_RESERVED1_SHIFT)
#define  PERFTR_COREK_ROWS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PERFTR_COREK_ROWS_RESERVED1_MASK) | (((uint32_t)val) << PERFTR_COREK_ROWS_RESERVED1_SHIFT))

#define  PERFTR_COREK_ROWS_VALUE_MASK 0xff
#define  PERFTR_COREK_ROWS_VALUE_SHIFT 0
#define  PERFTR_COREK_ROWS_VALUE_MASK_SHIFT(reg) (((reg) & PERFTR_COREK_ROWS_VALUE_MASK) >> PERFTR_COREK_ROWS_VALUE_SHIFT)
#define  PERFTR_COREK_ROWS_VALUE_REPLACE_VAL(reg,val) (((reg) & ~PERFTR_COREK_ROWS_VALUE_MASK) | (((uint32_t)val) << PERFTR_COREK_ROWS_VALUE_SHIFT))

//====================================================================
//Register: Number of Mask Columns (Columns)
/** \brief This register sets the width of the mask rectangle, in columns, for the channel.
        Rows x Columns should not exceed the size of available rectangle memory (in bits).
        The value written is one less than the desired number of columns (0 = 1 column, etc.)*/
//====================================================================

#define  PERFTR_COREK_COLUMNS_RESERVED1_MASK 0xffffff00
#define  PERFTR_COREK_COLUMNS_RESERVED1_SHIFT 8
#define  PERFTR_COREK_COLUMNS_RESERVED1_MASK_SHIFT(reg) (((reg) & PERFTR_COREK_COLUMNS_RESERVED1_MASK) >> PERFTR_COREK_COLUMNS_RESERVED1_SHIFT)
#define  PERFTR_COREK_COLUMNS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PERFTR_COREK_COLUMNS_RESERVED1_MASK) | (((uint32_t)val) << PERFTR_COREK_COLUMNS_RESERVED1_SHIFT))

#define  PERFTR_COREK_COLUMNS_VALUE_MASK 0xff
#define  PERFTR_COREK_COLUMNS_VALUE_SHIFT 0
#define  PERFTR_COREK_COLUMNS_VALUE_MASK_SHIFT(reg) (((reg) & PERFTR_COREK_COLUMNS_VALUE_MASK) >> PERFTR_COREK_COLUMNS_VALUE_SHIFT)
#define  PERFTR_COREK_COLUMNS_VALUE_REPLACE_VAL(reg,val) (((reg) & ~PERFTR_COREK_COLUMNS_VALUE_MASK) | (((uint32_t)val) << PERFTR_COREK_COLUMNS_VALUE_SHIFT))

//====================================================================
//Register: Mask Shift Amount (Shift)
/** \brief This register sets the column shift used when tiling the rectangle across the image.*/
//====================================================================

#define  PERFTR_COREK_SHIFT_RESERVED1_MASK 0xffffff00
#define  PERFTR_COREK_SHIFT_RESERVED1_SHIFT 8
#define  PERFTR_COREK_SHIFT_RESERVED1_MASK_SHIFT(reg) (((reg) & PERFTR_COREK_SHIFT_RESERVED1_MASK) >> PERFTR_COREK_SHIFT_RESERVED1_SHIFT)
#define  PERFTR_COREK_SHIFT_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PERFTR_COREK_SHIFT_RESERVED1_MASK) | (((uint32_t)val) << PERFTR_COREK_SHIFT_RESERVED1_SHIFT))

#define  PERFTR_COREK_SHIFT_VALUE_MASK 0xff
#define  PERFTR_COREK_SHIFT_VALUE_SHIFT 0
#define  PERFTR_COREK_SHIFT_VALUE_MASK_SHIFT(reg) (((reg) & PERFTR_COREK_SHIFT_VALUE_MASK) >> PERFTR_COREK_SHIFT_VALUE_SHIFT)
#define  PERFTR_COREK_SHIFT_VALUE_REPLACE_VAL(reg,val) (((reg) & ~PERFTR_COREK_SHIFT_VALUE_MASK) | (((uint32_t)val) << PERFTR_COREK_SHIFT_VALUE_SHIFT))

//====================================================================
//Register: Edge Strengh Threshold (Thresh)
/** \brief This sets an edge strength threshold. If the edge strength for a pixel exceeds this value, then the
        pixel data will not be replaced with zero data, regardless of the mask bit being applied from the
        tiled rectangle. Note that a value of 15 here will prevent edge strength data from overriding the mask.*/
//====================================================================

#define  PERFTR_COREK_THRESH_RESERVED1_MASK 0xfffffff0
#define  PERFTR_COREK_THRESH_RESERVED1_SHIFT 4
#define  PERFTR_COREK_THRESH_RESERVED1_MASK_SHIFT(reg) (((reg) & PERFTR_COREK_THRESH_RESERVED1_MASK) >> PERFTR_COREK_THRESH_RESERVED1_SHIFT)
#define  PERFTR_COREK_THRESH_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PERFTR_COREK_THRESH_RESERVED1_MASK) | (((uint32_t)val) << PERFTR_COREK_THRESH_RESERVED1_SHIFT))

#define  PERFTR_COREK_THRESH_VALUE_MASK 0xf
#define  PERFTR_COREK_THRESH_VALUE_SHIFT 0
#define  PERFTR_COREK_THRESH_VALUE_MASK_SHIFT(reg) (((reg) & PERFTR_COREK_THRESH_VALUE_MASK) >> PERFTR_COREK_THRESH_VALUE_SHIFT)
#define  PERFTR_COREK_THRESH_VALUE_REPLACE_VAL(reg,val) (((reg) & ~PERFTR_COREK_THRESH_VALUE_MASK) | (((uint32_t)val) << PERFTR_COREK_THRESH_VALUE_SHIFT))

//====================================================================
//Register: Starting Row (StartingRow)
/** \brief When a Start-of-Image data type is detected in the pipe, the Current Row register will be set to this value,
        which will then be used as the first active row of the mask.*/
//====================================================================

#define  PERFTR_COREK_STARTINGROW_RESERVED1_MASK 0xffffff00
#define  PERFTR_COREK_STARTINGROW_RESERVED1_SHIFT 8
#define  PERFTR_COREK_STARTINGROW_RESERVED1_MASK_SHIFT(reg) (((reg) & PERFTR_COREK_STARTINGROW_RESERVED1_MASK) >> PERFTR_COREK_STARTINGROW_RESERVED1_SHIFT)
#define  PERFTR_COREK_STARTINGROW_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PERFTR_COREK_STARTINGROW_RESERVED1_MASK) | (((uint32_t)val) << PERFTR_COREK_STARTINGROW_RESERVED1_SHIFT))

#define  PERFTR_COREK_STARTINGROW_VALUE_MASK 0xff
#define  PERFTR_COREK_STARTINGROW_VALUE_SHIFT 0
#define  PERFTR_COREK_STARTINGROW_VALUE_MASK_SHIFT(reg) (((reg) & PERFTR_COREK_STARTINGROW_VALUE_MASK) >> PERFTR_COREK_STARTINGROW_VALUE_SHIFT)
#define  PERFTR_COREK_STARTINGROW_VALUE_REPLACE_VAL(reg,val) (((reg) & ~PERFTR_COREK_STARTINGROW_VALUE_MASK) | (((uint32_t)val) << PERFTR_COREK_STARTINGROW_VALUE_SHIFT))

//====================================================================
//Register: Starting Column (StartingCol)
/** \brief This register sets the column number of the tiling rectangle which is applied to the first pixel
        in a line. Two values are set, one for left-to-right operation, and one for right-to-left operation. These values are loaded into the Line Starting Column registers when a Start-of-Image data type is detected in the pipe. One of these, selected based on line direction, is also loaded into the Current Column register. As the mask is tiled down an image, the Line Starting Column registers are modified by the Shift value each time the Row number returns to 0 and the
        tiling rectangle restarts, shifting the rectangle across the image.*/
//====================================================================

#define  PERFTR_COREK_STARTINGCOL_RESERVED1_MASK 0xffff0000
#define  PERFTR_COREK_STARTINGCOL_RESERVED1_SHIFT 16
#define  PERFTR_COREK_STARTINGCOL_RESERVED1_MASK_SHIFT(reg) (((reg) & PERFTR_COREK_STARTINGCOL_RESERVED1_MASK) >> PERFTR_COREK_STARTINGCOL_RESERVED1_SHIFT)
#define  PERFTR_COREK_STARTINGCOL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PERFTR_COREK_STARTINGCOL_RESERVED1_MASK) | (((uint32_t)val) << PERFTR_COREK_STARTINGCOL_RESERVED1_SHIFT))

#define  PERFTR_COREK_STARTINGCOL_R2L_MASK 0xff00
#define  PERFTR_COREK_STARTINGCOL_R2L_SHIFT 8
#define  PERFTR_COREK_STARTINGCOL_R2L_MASK_SHIFT(reg) (((reg) & PERFTR_COREK_STARTINGCOL_R2L_MASK) >> PERFTR_COREK_STARTINGCOL_R2L_SHIFT)
#define  PERFTR_COREK_STARTINGCOL_R2L_REPLACE_VAL(reg,val) (((reg) & ~PERFTR_COREK_STARTINGCOL_R2L_MASK) | (((uint32_t)val) << PERFTR_COREK_STARTINGCOL_R2L_SHIFT))

#define  PERFTR_COREK_STARTINGCOL_L2R_MASK 0xff
#define  PERFTR_COREK_STARTINGCOL_L2R_SHIFT 0
#define  PERFTR_COREK_STARTINGCOL_L2R_MASK_SHIFT(reg) (((reg) & PERFTR_COREK_STARTINGCOL_L2R_MASK) >> PERFTR_COREK_STARTINGCOL_L2R_SHIFT)
#define  PERFTR_COREK_STARTINGCOL_L2R_REPLACE_VAL(reg,val) (((reg) & ~PERFTR_COREK_STARTINGCOL_L2R_MASK) | (((uint32_t)val) << PERFTR_COREK_STARTINGCOL_L2R_SHIFT))

//====================================================================
//Register: Save State 0 (SaveState0)
/** \brief This register returns internal state information. Used to capture state during a save/restore operation.*/
//====================================================================

#define  PERFTR_COREK_SAVESTATE0_RESERVED1_MASK 0xff000000
#define  PERFTR_COREK_SAVESTATE0_RESERVED1_SHIFT 24
#define  PERFTR_COREK_SAVESTATE0_RESERVED1_MASK_SHIFT(reg) (((reg) & PERFTR_COREK_SAVESTATE0_RESERVED1_MASK) >> PERFTR_COREK_SAVESTATE0_RESERVED1_SHIFT)
#define  PERFTR_COREK_SAVESTATE0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PERFTR_COREK_SAVESTATE0_RESERVED1_MASK) | (((uint32_t)val) << PERFTR_COREK_SAVESTATE0_RESERVED1_SHIFT))

#define  PERFTR_COREK_SAVESTATE0_STATE_MASK 0xffffff
#define  PERFTR_COREK_SAVESTATE0_STATE_SHIFT 0
#define  PERFTR_COREK_SAVESTATE0_STATE_MASK_SHIFT(reg) (((reg) & PERFTR_COREK_SAVESTATE0_STATE_MASK) >> PERFTR_COREK_SAVESTATE0_STATE_SHIFT)
#define  PERFTR_COREK_SAVESTATE0_STATE_REPLACE_VAL(reg,val) (((reg) & ~PERFTR_COREK_SAVESTATE0_STATE_MASK) | (((uint32_t)val) << PERFTR_COREK_SAVESTATE0_STATE_SHIFT))

//====================================================================
//Register: Save State 1 (SaveState1)
/** \brief This register returns internal state information. Used to capture state during a save/restore operation.*/
//====================================================================

#define  PERFTR_COREK_SAVESTATE1_RESERVED1_MASK 0xffe00000
#define  PERFTR_COREK_SAVESTATE1_RESERVED1_SHIFT 21
#define  PERFTR_COREK_SAVESTATE1_RESERVED1_MASK_SHIFT(reg) (((reg) & PERFTR_COREK_SAVESTATE1_RESERVED1_MASK) >> PERFTR_COREK_SAVESTATE1_RESERVED1_SHIFT)
#define  PERFTR_COREK_SAVESTATE1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PERFTR_COREK_SAVESTATE1_RESERVED1_MASK) | (((uint32_t)val) << PERFTR_COREK_SAVESTATE1_RESERVED1_SHIFT))

#define  PERFTR_COREK_SAVESTATE1_STATE_MASK 0x1fffff
#define  PERFTR_COREK_SAVESTATE1_STATE_SHIFT 0
#define  PERFTR_COREK_SAVESTATE1_STATE_MASK_SHIFT(reg) (((reg) & PERFTR_COREK_SAVESTATE1_STATE_MASK) >> PERFTR_COREK_SAVESTATE1_STATE_SHIFT)
#define  PERFTR_COREK_SAVESTATE1_STATE_REPLACE_VAL(reg,val) (((reg) & ~PERFTR_COREK_SAVESTATE1_STATE_MASK) | (((uint32_t)val) << PERFTR_COREK_SAVESTATE1_STATE_SHIFT))

//====================================================================
//Register: Restore State 0 (RestoreState0)
/** \brief Returns internal state information to a prior saved condition. Corresponds with SaveState0. This can be used to restore the PERFTR block to a known operating state before resuming a suspended operation.*/
//====================================================================

#define  PERFTR_COREK_RESTORESTATE0_RESERVED1_MASK 0xff000000
#define  PERFTR_COREK_RESTORESTATE0_RESERVED1_SHIFT 24
#define  PERFTR_COREK_RESTORESTATE0_RESERVED1_MASK_SHIFT(reg) (((reg) & PERFTR_COREK_RESTORESTATE0_RESERVED1_MASK) >> PERFTR_COREK_RESTORESTATE0_RESERVED1_SHIFT)
#define  PERFTR_COREK_RESTORESTATE0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PERFTR_COREK_RESTORESTATE0_RESERVED1_MASK) | (((uint32_t)val) << PERFTR_COREK_RESTORESTATE0_RESERVED1_SHIFT))

#define  PERFTR_COREK_RESTORESTATE0_STATE_MASK 0xffffff
#define  PERFTR_COREK_RESTORESTATE0_STATE_SHIFT 0
#define  PERFTR_COREK_RESTORESTATE0_STATE_MASK_SHIFT(reg) (((reg) & PERFTR_COREK_RESTORESTATE0_STATE_MASK) >> PERFTR_COREK_RESTORESTATE0_STATE_SHIFT)
#define  PERFTR_COREK_RESTORESTATE0_STATE_REPLACE_VAL(reg,val) (((reg) & ~PERFTR_COREK_RESTORESTATE0_STATE_MASK) | (((uint32_t)val) << PERFTR_COREK_RESTORESTATE0_STATE_SHIFT))

//====================================================================
//Register: Restore State 1 (RestoreState1)
/** \brief Returns internal state information to a prior saved condition. Corresponds with SaveState1. This can be used to restore the PERFTR block to a known operating state before resuming a suspended operation.*/
//====================================================================

#define  PERFTR_COREK_RESTORESTATE1_RESERVED1_MASK 0xffe00000
#define  PERFTR_COREK_RESTORESTATE1_RESERVED1_SHIFT 21
#define  PERFTR_COREK_RESTORESTATE1_RESERVED1_MASK_SHIFT(reg) (((reg) & PERFTR_COREK_RESTORESTATE1_RESERVED1_MASK) >> PERFTR_COREK_RESTORESTATE1_RESERVED1_SHIFT)
#define  PERFTR_COREK_RESTORESTATE1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PERFTR_COREK_RESTORESTATE1_RESERVED1_MASK) | (((uint32_t)val) << PERFTR_COREK_RESTORESTATE1_RESERVED1_SHIFT))

#define  PERFTR_COREK_RESTORESTATE1_STATE_MASK 0x1fffff
#define  PERFTR_COREK_RESTORESTATE1_STATE_SHIFT 0
#define  PERFTR_COREK_RESTORESTATE1_STATE_MASK_SHIFT(reg) (((reg) & PERFTR_COREK_RESTORESTATE1_STATE_MASK) >> PERFTR_COREK_RESTORESTATE1_STATE_SHIFT)
#define  PERFTR_COREK_RESTORESTATE1_STATE_REPLACE_VAL(reg,val) (((reg) & ~PERFTR_COREK_RESTORESTATE1_STATE_MASK) | (((uint32_t)val) << PERFTR_COREK_RESTORESTATE1_STATE_SHIFT))

//====================================================================
//Register: Mask RAM access (RAMAcc)
/** \brief Holds the rectangular mask for the channel. Directly accessible when the CpuAccess bit of the Perforator
common control register is set.*/
//====================================================================

#define  PERFTR_COREK_RAMACC_RESERVED1_MASK 0xffff0000
#define  PERFTR_COREK_RAMACC_RESERVED1_SHIFT 16
#define  PERFTR_COREK_RAMACC_RESERVED1_MASK_SHIFT(reg) (((reg) & PERFTR_COREK_RAMACC_RESERVED1_MASK) >> PERFTR_COREK_RAMACC_RESERVED1_SHIFT)
#define  PERFTR_COREK_RAMACC_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PERFTR_COREK_RAMACC_RESERVED1_MASK) | (((uint32_t)val) << PERFTR_COREK_RAMACC_RESERVED1_SHIFT))

#define  PERFTR_COREK_RAMACC_DATA_MASK 0xffff
#define  PERFTR_COREK_RAMACC_DATA_SHIFT 0
#define  PERFTR_COREK_RAMACC_DATA_MASK_SHIFT(reg) (((reg) & PERFTR_COREK_RAMACC_DATA_MASK) >> PERFTR_COREK_RAMACC_DATA_SHIFT)
#define  PERFTR_COREK_RAMACC_DATA_REPLACE_VAL(reg,val) (((reg) & ~PERFTR_COREK_RAMACC_DATA_MASK) | (((uint32_t)val) << PERFTR_COREK_RAMACC_DATA_SHIFT))

#endif // PERFTR
