 /*
 **************************************************************************************
 *
 * (c) Copyright 2013 Marvell International Ltd.
 *
 *
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/.
 *
 **************************************************************************************
 *
 * \file PDMA_regmasks.h
 * Generated using RegBuild 1.6.3
 *
 **************************************************************************************
 */

#ifndef _PDMA_REGMASKS_H_
#define _PDMA_REGMASKS_H_

#ifndef __KERNEL__
#include <stdint.h>
#endif

//====================================================================
//
//Register File: PDMA (PDMA)
//
//====================================================================

//====================================================================
//Register: DMA Channel Control/Status Registers 0-15 (Instance 1 of 16) (DMA_CSRx0)
/** \brief These read/write registers contain the control and status bits for the channels.
<br>
Ignore reads from reserved bits. Write 0x0 to reserved bits.
<br>
Address offsets:
<br>
DMA Channel 0 Register = 0x0000
<br>
DMA Channel 1 Register = 0x0004
<br>
DMA Channel 2 Register = 0x0008
<br>
DMA Channel 3 Register = 0x000C
<br>
DMA Channel 4 Register = 0x0010
<br>
DMA Channel 5 Register = 0x0014
<br>
DMA Channel 6 Register = 0x0018
<br>
DMA Channel 7 Register = 0x001C
<br>
DMA Channel 8 Register = 0x0020
<br>
DMA Channel 9 Register = 0x0024
<br>
DMA Channel 10 Register = 0x0028
<br>
DMA Channel 11 Register = 0x002C
<br>
DMA Channel 12 Register = 0x0030
<br>
DMA Channel 13 Register = 0x0034
<br>
DMA Channel 14 Register = 0x0038
<br>
DMA Channel 15 Register = 0x003C
<br> (Instance 1 of 16)*/
//====================================================================

#define  PDMA_DMA_CSRX0_RUN_MASK 0x80000000
#define  PDMA_DMA_CSRX0_RUN_SHIFT 31
#define  PDMA_DMA_CSRX0_RUN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX0_RUN_MASK) >> PDMA_DMA_CSRX0_RUN_SHIFT)
#define  PDMA_DMA_CSRX0_RUN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX0_RUN_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX0_RUN_SHIFT))

#define  PDMA_DMA_CSRX0_NODESCFETCH_MASK 0x40000000
#define  PDMA_DMA_CSRX0_NODESCFETCH_SHIFT 30
#define  PDMA_DMA_CSRX0_NODESCFETCH_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX0_NODESCFETCH_MASK) >> PDMA_DMA_CSRX0_NODESCFETCH_SHIFT)
#define  PDMA_DMA_CSRX0_NODESCFETCH_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX0_NODESCFETCH_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX0_NODESCFETCH_SHIFT))

#define  PDMA_DMA_CSRX0_STOPIRQEN_MASK 0x20000000
#define  PDMA_DMA_CSRX0_STOPIRQEN_SHIFT 29
#define  PDMA_DMA_CSRX0_STOPIRQEN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX0_STOPIRQEN_MASK) >> PDMA_DMA_CSRX0_STOPIRQEN_SHIFT)
#define  PDMA_DMA_CSRX0_STOPIRQEN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX0_STOPIRQEN_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX0_STOPIRQEN_SHIFT))

#define  PDMA_DMA_CSRX0_EORIRQEN_MASK 0x10000000
#define  PDMA_DMA_CSRX0_EORIRQEN_SHIFT 28
#define  PDMA_DMA_CSRX0_EORIRQEN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX0_EORIRQEN_MASK) >> PDMA_DMA_CSRX0_EORIRQEN_SHIFT)
#define  PDMA_DMA_CSRX0_EORIRQEN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX0_EORIRQEN_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX0_EORIRQEN_SHIFT))

#define  PDMA_DMA_CSRX0_EORJMPEN_MASK 0x8000000
#define  PDMA_DMA_CSRX0_EORJMPEN_SHIFT 27
#define  PDMA_DMA_CSRX0_EORJMPEN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX0_EORJMPEN_MASK) >> PDMA_DMA_CSRX0_EORJMPEN_SHIFT)
#define  PDMA_DMA_CSRX0_EORJMPEN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX0_EORJMPEN_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX0_EORJMPEN_SHIFT))

#define  PDMA_DMA_CSRX0_EORSTOPEN_MASK 0x4000000
#define  PDMA_DMA_CSRX0_EORSTOPEN_SHIFT 26
#define  PDMA_DMA_CSRX0_EORSTOPEN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX0_EORSTOPEN_MASK) >> PDMA_DMA_CSRX0_EORSTOPEN_SHIFT)
#define  PDMA_DMA_CSRX0_EORSTOPEN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX0_EORSTOPEN_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX0_EORSTOPEN_SHIFT))

#define  PDMA_DMA_CSRX0_SETCMPST_MASK 0x2000000
#define  PDMA_DMA_CSRX0_SETCMPST_SHIFT 25
#define  PDMA_DMA_CSRX0_SETCMPST_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX0_SETCMPST_MASK) >> PDMA_DMA_CSRX0_SETCMPST_SHIFT)
#define  PDMA_DMA_CSRX0_SETCMPST_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX0_SETCMPST_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX0_SETCMPST_SHIFT))

#define  PDMA_DMA_CSRX0_CLRCMPST_MASK 0x1000000
#define  PDMA_DMA_CSRX0_CLRCMPST_SHIFT 24
#define  PDMA_DMA_CSRX0_CLRCMPST_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX0_CLRCMPST_MASK) >> PDMA_DMA_CSRX0_CLRCMPST_SHIFT)
#define  PDMA_DMA_CSRX0_CLRCMPST_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX0_CLRCMPST_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX0_CLRCMPST_SHIFT))

#define  PDMA_DMA_CSRX0_RASIRQEN_MASK 0x800000
#define  PDMA_DMA_CSRX0_RASIRQEN_SHIFT 23
#define  PDMA_DMA_CSRX0_RASIRQEN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX0_RASIRQEN_MASK) >> PDMA_DMA_CSRX0_RASIRQEN_SHIFT)
#define  PDMA_DMA_CSRX0_RASIRQEN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX0_RASIRQEN_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX0_RASIRQEN_SHIFT))

#define  PDMA_DMA_CSRX0_MASKRUN_MASK 0x400000
#define  PDMA_DMA_CSRX0_MASKRUN_SHIFT 22
#define  PDMA_DMA_CSRX0_MASKRUN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX0_MASKRUN_MASK) >> PDMA_DMA_CSRX0_MASKRUN_SHIFT)
#define  PDMA_DMA_CSRX0_MASKRUN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX0_MASKRUN_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX0_MASKRUN_SHIFT))

#define  PDMA_DMA_CSRX0_RESERVED1_MASK 0x3ff800
#define  PDMA_DMA_CSRX0_RESERVED1_SHIFT 11
#define  PDMA_DMA_CSRX0_RESERVED1_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX0_RESERVED1_MASK) >> PDMA_DMA_CSRX0_RESERVED1_SHIFT)
#define  PDMA_DMA_CSRX0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX0_RESERVED1_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX0_RESERVED1_SHIFT))

#define  PDMA_DMA_CSRX0_CMPST_MASK 0x400
#define  PDMA_DMA_CSRX0_CMPST_SHIFT 10
#define  PDMA_DMA_CSRX0_CMPST_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX0_CMPST_MASK) >> PDMA_DMA_CSRX0_CMPST_SHIFT)
#define  PDMA_DMA_CSRX0_CMPST_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX0_CMPST_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX0_CMPST_SHIFT))

#define  PDMA_DMA_CSRX0_EORINT_MASK 0x200
#define  PDMA_DMA_CSRX0_EORINT_SHIFT 9
#define  PDMA_DMA_CSRX0_EORINT_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX0_EORINT_MASK) >> PDMA_DMA_CSRX0_EORINT_SHIFT)
#define  PDMA_DMA_CSRX0_EORINT_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX0_EORINT_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX0_EORINT_SHIFT))

#define  PDMA_DMA_CSRX0_REQPEND_MASK 0x100
#define  PDMA_DMA_CSRX0_REQPEND_SHIFT 8
#define  PDMA_DMA_CSRX0_REQPEND_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX0_REQPEND_MASK) >> PDMA_DMA_CSRX0_REQPEND_SHIFT)
#define  PDMA_DMA_CSRX0_REQPEND_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX0_REQPEND_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX0_REQPEND_SHIFT))

#define  PDMA_DMA_CSRX0_RESERVED2_MASK 0xe0
#define  PDMA_DMA_CSRX0_RESERVED2_SHIFT 5
#define  PDMA_DMA_CSRX0_RESERVED2_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX0_RESERVED2_MASK) >> PDMA_DMA_CSRX0_RESERVED2_SHIFT)
#define  PDMA_DMA_CSRX0_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX0_RESERVED2_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX0_RESERVED2_SHIFT))

#define  PDMA_DMA_CSRX0_RASINTR_MASK 0x10
#define  PDMA_DMA_CSRX0_RASINTR_SHIFT 4
#define  PDMA_DMA_CSRX0_RASINTR_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX0_RASINTR_MASK) >> PDMA_DMA_CSRX0_RASINTR_SHIFT)
#define  PDMA_DMA_CSRX0_RASINTR_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX0_RASINTR_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX0_RASINTR_SHIFT))

#define  PDMA_DMA_CSRX0_STOPINTR_MASK 0x8
#define  PDMA_DMA_CSRX0_STOPINTR_SHIFT 3
#define  PDMA_DMA_CSRX0_STOPINTR_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX0_STOPINTR_MASK) >> PDMA_DMA_CSRX0_STOPINTR_SHIFT)
#define  PDMA_DMA_CSRX0_STOPINTR_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX0_STOPINTR_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX0_STOPINTR_SHIFT))

#define  PDMA_DMA_CSRX0_ENDINTR_MASK 0x4
#define  PDMA_DMA_CSRX0_ENDINTR_SHIFT 2
#define  PDMA_DMA_CSRX0_ENDINTR_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX0_ENDINTR_MASK) >> PDMA_DMA_CSRX0_ENDINTR_SHIFT)
#define  PDMA_DMA_CSRX0_ENDINTR_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX0_ENDINTR_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX0_ENDINTR_SHIFT))

#define  PDMA_DMA_CSRX0_STARTINTR_MASK 0x2
#define  PDMA_DMA_CSRX0_STARTINTR_SHIFT 1
#define  PDMA_DMA_CSRX0_STARTINTR_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX0_STARTINTR_MASK) >> PDMA_DMA_CSRX0_STARTINTR_SHIFT)
#define  PDMA_DMA_CSRX0_STARTINTR_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX0_STARTINTR_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX0_STARTINTR_SHIFT))

#define  PDMA_DMA_CSRX0_BUSERRINTR_MASK 0x1
#define  PDMA_DMA_CSRX0_BUSERRINTR_SHIFT 0
#define  PDMA_DMA_CSRX0_BUSERRINTR_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX0_BUSERRINTR_MASK) >> PDMA_DMA_CSRX0_BUSERRINTR_SHIFT)
#define  PDMA_DMA_CSRX0_BUSERRINTR_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX0_BUSERRINTR_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX0_BUSERRINTR_SHIFT))

//====================================================================
//Register: DMA Channel Control/Status Registers 0-15 (Instance 2 of 16) (DMA_CSRx1)
/** \brief These read/write registers contain the control and status bits for the channels.
<br>
Ignore reads from reserved bits. Write 0x0 to reserved bits.
<br>
Address offsets:
<br>
DMA Channel 0 Register = 0x0000
<br>
DMA Channel 1 Register = 0x0004
<br>
DMA Channel 2 Register = 0x0008
<br>
DMA Channel 3 Register = 0x000C
<br>
DMA Channel 4 Register = 0x0010
<br>
DMA Channel 5 Register = 0x0014
<br>
DMA Channel 6 Register = 0x0018
<br>
DMA Channel 7 Register = 0x001C
<br>
DMA Channel 8 Register = 0x0020
<br>
DMA Channel 9 Register = 0x0024
<br>
DMA Channel 10 Register = 0x0028
<br>
DMA Channel 11 Register = 0x002C
<br>
DMA Channel 12 Register = 0x0030
<br>
DMA Channel 13 Register = 0x0034
<br>
DMA Channel 14 Register = 0x0038
<br>
DMA Channel 15 Register = 0x003C
<br> (Instance 2 of 16)*/
//====================================================================

#define  PDMA_DMA_CSRX1_RUN_MASK 0x80000000
#define  PDMA_DMA_CSRX1_RUN_SHIFT 31
#define  PDMA_DMA_CSRX1_RUN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX1_RUN_MASK) >> PDMA_DMA_CSRX1_RUN_SHIFT)
#define  PDMA_DMA_CSRX1_RUN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX1_RUN_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX1_RUN_SHIFT))

#define  PDMA_DMA_CSRX1_NODESCFETCH_MASK 0x40000000
#define  PDMA_DMA_CSRX1_NODESCFETCH_SHIFT 30
#define  PDMA_DMA_CSRX1_NODESCFETCH_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX1_NODESCFETCH_MASK) >> PDMA_DMA_CSRX1_NODESCFETCH_SHIFT)
#define  PDMA_DMA_CSRX1_NODESCFETCH_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX1_NODESCFETCH_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX1_NODESCFETCH_SHIFT))

#define  PDMA_DMA_CSRX1_STOPIRQEN_MASK 0x20000000
#define  PDMA_DMA_CSRX1_STOPIRQEN_SHIFT 29
#define  PDMA_DMA_CSRX1_STOPIRQEN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX1_STOPIRQEN_MASK) >> PDMA_DMA_CSRX1_STOPIRQEN_SHIFT)
#define  PDMA_DMA_CSRX1_STOPIRQEN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX1_STOPIRQEN_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX1_STOPIRQEN_SHIFT))

#define  PDMA_DMA_CSRX1_EORIRQEN_MASK 0x10000000
#define  PDMA_DMA_CSRX1_EORIRQEN_SHIFT 28
#define  PDMA_DMA_CSRX1_EORIRQEN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX1_EORIRQEN_MASK) >> PDMA_DMA_CSRX1_EORIRQEN_SHIFT)
#define  PDMA_DMA_CSRX1_EORIRQEN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX1_EORIRQEN_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX1_EORIRQEN_SHIFT))

#define  PDMA_DMA_CSRX1_EORJMPEN_MASK 0x8000000
#define  PDMA_DMA_CSRX1_EORJMPEN_SHIFT 27
#define  PDMA_DMA_CSRX1_EORJMPEN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX1_EORJMPEN_MASK) >> PDMA_DMA_CSRX1_EORJMPEN_SHIFT)
#define  PDMA_DMA_CSRX1_EORJMPEN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX1_EORJMPEN_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX1_EORJMPEN_SHIFT))

#define  PDMA_DMA_CSRX1_EORSTOPEN_MASK 0x4000000
#define  PDMA_DMA_CSRX1_EORSTOPEN_SHIFT 26
#define  PDMA_DMA_CSRX1_EORSTOPEN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX1_EORSTOPEN_MASK) >> PDMA_DMA_CSRX1_EORSTOPEN_SHIFT)
#define  PDMA_DMA_CSRX1_EORSTOPEN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX1_EORSTOPEN_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX1_EORSTOPEN_SHIFT))

#define  PDMA_DMA_CSRX1_SETCMPST_MASK 0x2000000
#define  PDMA_DMA_CSRX1_SETCMPST_SHIFT 25
#define  PDMA_DMA_CSRX1_SETCMPST_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX1_SETCMPST_MASK) >> PDMA_DMA_CSRX1_SETCMPST_SHIFT)
#define  PDMA_DMA_CSRX1_SETCMPST_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX1_SETCMPST_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX1_SETCMPST_SHIFT))

#define  PDMA_DMA_CSRX1_CLRCMPST_MASK 0x1000000
#define  PDMA_DMA_CSRX1_CLRCMPST_SHIFT 24
#define  PDMA_DMA_CSRX1_CLRCMPST_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX1_CLRCMPST_MASK) >> PDMA_DMA_CSRX1_CLRCMPST_SHIFT)
#define  PDMA_DMA_CSRX1_CLRCMPST_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX1_CLRCMPST_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX1_CLRCMPST_SHIFT))

#define  PDMA_DMA_CSRX1_RASIRQEN_MASK 0x800000
#define  PDMA_DMA_CSRX1_RASIRQEN_SHIFT 23
#define  PDMA_DMA_CSRX1_RASIRQEN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX1_RASIRQEN_MASK) >> PDMA_DMA_CSRX1_RASIRQEN_SHIFT)
#define  PDMA_DMA_CSRX1_RASIRQEN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX1_RASIRQEN_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX1_RASIRQEN_SHIFT))

#define  PDMA_DMA_CSRX1_MASKRUN_MASK 0x400000
#define  PDMA_DMA_CSRX1_MASKRUN_SHIFT 22
#define  PDMA_DMA_CSRX1_MASKRUN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX1_MASKRUN_MASK) >> PDMA_DMA_CSRX1_MASKRUN_SHIFT)
#define  PDMA_DMA_CSRX1_MASKRUN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX1_MASKRUN_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX1_MASKRUN_SHIFT))

#define  PDMA_DMA_CSRX1_RESERVED1_MASK 0x3ff800
#define  PDMA_DMA_CSRX1_RESERVED1_SHIFT 11
#define  PDMA_DMA_CSRX1_RESERVED1_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX1_RESERVED1_MASK) >> PDMA_DMA_CSRX1_RESERVED1_SHIFT)
#define  PDMA_DMA_CSRX1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX1_RESERVED1_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX1_RESERVED1_SHIFT))

#define  PDMA_DMA_CSRX1_CMPST_MASK 0x400
#define  PDMA_DMA_CSRX1_CMPST_SHIFT 10
#define  PDMA_DMA_CSRX1_CMPST_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX1_CMPST_MASK) >> PDMA_DMA_CSRX1_CMPST_SHIFT)
#define  PDMA_DMA_CSRX1_CMPST_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX1_CMPST_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX1_CMPST_SHIFT))

#define  PDMA_DMA_CSRX1_EORINT_MASK 0x200
#define  PDMA_DMA_CSRX1_EORINT_SHIFT 9
#define  PDMA_DMA_CSRX1_EORINT_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX1_EORINT_MASK) >> PDMA_DMA_CSRX1_EORINT_SHIFT)
#define  PDMA_DMA_CSRX1_EORINT_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX1_EORINT_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX1_EORINT_SHIFT))

#define  PDMA_DMA_CSRX1_REQPEND_MASK 0x100
#define  PDMA_DMA_CSRX1_REQPEND_SHIFT 8
#define  PDMA_DMA_CSRX1_REQPEND_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX1_REQPEND_MASK) >> PDMA_DMA_CSRX1_REQPEND_SHIFT)
#define  PDMA_DMA_CSRX1_REQPEND_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX1_REQPEND_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX1_REQPEND_SHIFT))

#define  PDMA_DMA_CSRX1_RESERVED2_MASK 0xe0
#define  PDMA_DMA_CSRX1_RESERVED2_SHIFT 5
#define  PDMA_DMA_CSRX1_RESERVED2_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX1_RESERVED2_MASK) >> PDMA_DMA_CSRX1_RESERVED2_SHIFT)
#define  PDMA_DMA_CSRX1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX1_RESERVED2_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX1_RESERVED2_SHIFT))

#define  PDMA_DMA_CSRX1_RASINTR_MASK 0x10
#define  PDMA_DMA_CSRX1_RASINTR_SHIFT 4
#define  PDMA_DMA_CSRX1_RASINTR_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX1_RASINTR_MASK) >> PDMA_DMA_CSRX1_RASINTR_SHIFT)
#define  PDMA_DMA_CSRX1_RASINTR_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX1_RASINTR_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX1_RASINTR_SHIFT))

#define  PDMA_DMA_CSRX1_STOPINTR_MASK 0x8
#define  PDMA_DMA_CSRX1_STOPINTR_SHIFT 3
#define  PDMA_DMA_CSRX1_STOPINTR_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX1_STOPINTR_MASK) >> PDMA_DMA_CSRX1_STOPINTR_SHIFT)
#define  PDMA_DMA_CSRX1_STOPINTR_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX1_STOPINTR_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX1_STOPINTR_SHIFT))

#define  PDMA_DMA_CSRX1_ENDINTR_MASK 0x4
#define  PDMA_DMA_CSRX1_ENDINTR_SHIFT 2
#define  PDMA_DMA_CSRX1_ENDINTR_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX1_ENDINTR_MASK) >> PDMA_DMA_CSRX1_ENDINTR_SHIFT)
#define  PDMA_DMA_CSRX1_ENDINTR_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX1_ENDINTR_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX1_ENDINTR_SHIFT))

#define  PDMA_DMA_CSRX1_STARTINTR_MASK 0x2
#define  PDMA_DMA_CSRX1_STARTINTR_SHIFT 1
#define  PDMA_DMA_CSRX1_STARTINTR_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX1_STARTINTR_MASK) >> PDMA_DMA_CSRX1_STARTINTR_SHIFT)
#define  PDMA_DMA_CSRX1_STARTINTR_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX1_STARTINTR_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX1_STARTINTR_SHIFT))

#define  PDMA_DMA_CSRX1_BUSERRINTR_MASK 0x1
#define  PDMA_DMA_CSRX1_BUSERRINTR_SHIFT 0
#define  PDMA_DMA_CSRX1_BUSERRINTR_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX1_BUSERRINTR_MASK) >> PDMA_DMA_CSRX1_BUSERRINTR_SHIFT)
#define  PDMA_DMA_CSRX1_BUSERRINTR_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX1_BUSERRINTR_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX1_BUSERRINTR_SHIFT))

//====================================================================
//Register: DMA Channel Control/Status Registers 0-15 (Instance 3 of 16) (DMA_CSRx2)
/** \brief These read/write registers contain the control and status bits for the channels.
<br>
Ignore reads from reserved bits. Write 0x0 to reserved bits.
<br>
Address offsets:
<br>
DMA Channel 0 Register = 0x0000
<br>
DMA Channel 1 Register = 0x0004
<br>
DMA Channel 2 Register = 0x0008
<br>
DMA Channel 3 Register = 0x000C
<br>
DMA Channel 4 Register = 0x0010
<br>
DMA Channel 5 Register = 0x0014
<br>
DMA Channel 6 Register = 0x0018
<br>
DMA Channel 7 Register = 0x001C
<br>
DMA Channel 8 Register = 0x0020
<br>
DMA Channel 9 Register = 0x0024
<br>
DMA Channel 10 Register = 0x0028
<br>
DMA Channel 11 Register = 0x002C
<br>
DMA Channel 12 Register = 0x0030
<br>
DMA Channel 13 Register = 0x0034
<br>
DMA Channel 14 Register = 0x0038
<br>
DMA Channel 15 Register = 0x003C
<br> (Instance 3 of 16)*/
//====================================================================

#define  PDMA_DMA_CSRX2_RUN_MASK 0x80000000
#define  PDMA_DMA_CSRX2_RUN_SHIFT 31
#define  PDMA_DMA_CSRX2_RUN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX2_RUN_MASK) >> PDMA_DMA_CSRX2_RUN_SHIFT)
#define  PDMA_DMA_CSRX2_RUN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX2_RUN_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX2_RUN_SHIFT))

#define  PDMA_DMA_CSRX2_NODESCFETCH_MASK 0x40000000
#define  PDMA_DMA_CSRX2_NODESCFETCH_SHIFT 30
#define  PDMA_DMA_CSRX2_NODESCFETCH_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX2_NODESCFETCH_MASK) >> PDMA_DMA_CSRX2_NODESCFETCH_SHIFT)
#define  PDMA_DMA_CSRX2_NODESCFETCH_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX2_NODESCFETCH_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX2_NODESCFETCH_SHIFT))

#define  PDMA_DMA_CSRX2_STOPIRQEN_MASK 0x20000000
#define  PDMA_DMA_CSRX2_STOPIRQEN_SHIFT 29
#define  PDMA_DMA_CSRX2_STOPIRQEN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX2_STOPIRQEN_MASK) >> PDMA_DMA_CSRX2_STOPIRQEN_SHIFT)
#define  PDMA_DMA_CSRX2_STOPIRQEN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX2_STOPIRQEN_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX2_STOPIRQEN_SHIFT))

#define  PDMA_DMA_CSRX2_EORIRQEN_MASK 0x10000000
#define  PDMA_DMA_CSRX2_EORIRQEN_SHIFT 28
#define  PDMA_DMA_CSRX2_EORIRQEN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX2_EORIRQEN_MASK) >> PDMA_DMA_CSRX2_EORIRQEN_SHIFT)
#define  PDMA_DMA_CSRX2_EORIRQEN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX2_EORIRQEN_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX2_EORIRQEN_SHIFT))

#define  PDMA_DMA_CSRX2_EORJMPEN_MASK 0x8000000
#define  PDMA_DMA_CSRX2_EORJMPEN_SHIFT 27
#define  PDMA_DMA_CSRX2_EORJMPEN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX2_EORJMPEN_MASK) >> PDMA_DMA_CSRX2_EORJMPEN_SHIFT)
#define  PDMA_DMA_CSRX2_EORJMPEN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX2_EORJMPEN_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX2_EORJMPEN_SHIFT))

#define  PDMA_DMA_CSRX2_EORSTOPEN_MASK 0x4000000
#define  PDMA_DMA_CSRX2_EORSTOPEN_SHIFT 26
#define  PDMA_DMA_CSRX2_EORSTOPEN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX2_EORSTOPEN_MASK) >> PDMA_DMA_CSRX2_EORSTOPEN_SHIFT)
#define  PDMA_DMA_CSRX2_EORSTOPEN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX2_EORSTOPEN_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX2_EORSTOPEN_SHIFT))

#define  PDMA_DMA_CSRX2_SETCMPST_MASK 0x2000000
#define  PDMA_DMA_CSRX2_SETCMPST_SHIFT 25
#define  PDMA_DMA_CSRX2_SETCMPST_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX2_SETCMPST_MASK) >> PDMA_DMA_CSRX2_SETCMPST_SHIFT)
#define  PDMA_DMA_CSRX2_SETCMPST_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX2_SETCMPST_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX2_SETCMPST_SHIFT))

#define  PDMA_DMA_CSRX2_CLRCMPST_MASK 0x1000000
#define  PDMA_DMA_CSRX2_CLRCMPST_SHIFT 24
#define  PDMA_DMA_CSRX2_CLRCMPST_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX2_CLRCMPST_MASK) >> PDMA_DMA_CSRX2_CLRCMPST_SHIFT)
#define  PDMA_DMA_CSRX2_CLRCMPST_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX2_CLRCMPST_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX2_CLRCMPST_SHIFT))

#define  PDMA_DMA_CSRX2_RASIRQEN_MASK 0x800000
#define  PDMA_DMA_CSRX2_RASIRQEN_SHIFT 23
#define  PDMA_DMA_CSRX2_RASIRQEN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX2_RASIRQEN_MASK) >> PDMA_DMA_CSRX2_RASIRQEN_SHIFT)
#define  PDMA_DMA_CSRX2_RASIRQEN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX2_RASIRQEN_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX2_RASIRQEN_SHIFT))

#define  PDMA_DMA_CSRX2_MASKRUN_MASK 0x400000
#define  PDMA_DMA_CSRX2_MASKRUN_SHIFT 22
#define  PDMA_DMA_CSRX2_MASKRUN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX2_MASKRUN_MASK) >> PDMA_DMA_CSRX2_MASKRUN_SHIFT)
#define  PDMA_DMA_CSRX2_MASKRUN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX2_MASKRUN_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX2_MASKRUN_SHIFT))

#define  PDMA_DMA_CSRX2_RESERVED1_MASK 0x3ff800
#define  PDMA_DMA_CSRX2_RESERVED1_SHIFT 11
#define  PDMA_DMA_CSRX2_RESERVED1_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX2_RESERVED1_MASK) >> PDMA_DMA_CSRX2_RESERVED1_SHIFT)
#define  PDMA_DMA_CSRX2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX2_RESERVED1_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX2_RESERVED1_SHIFT))

#define  PDMA_DMA_CSRX2_CMPST_MASK 0x400
#define  PDMA_DMA_CSRX2_CMPST_SHIFT 10
#define  PDMA_DMA_CSRX2_CMPST_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX2_CMPST_MASK) >> PDMA_DMA_CSRX2_CMPST_SHIFT)
#define  PDMA_DMA_CSRX2_CMPST_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX2_CMPST_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX2_CMPST_SHIFT))

#define  PDMA_DMA_CSRX2_EORINT_MASK 0x200
#define  PDMA_DMA_CSRX2_EORINT_SHIFT 9
#define  PDMA_DMA_CSRX2_EORINT_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX2_EORINT_MASK) >> PDMA_DMA_CSRX2_EORINT_SHIFT)
#define  PDMA_DMA_CSRX2_EORINT_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX2_EORINT_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX2_EORINT_SHIFT))

#define  PDMA_DMA_CSRX2_REQPEND_MASK 0x100
#define  PDMA_DMA_CSRX2_REQPEND_SHIFT 8
#define  PDMA_DMA_CSRX2_REQPEND_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX2_REQPEND_MASK) >> PDMA_DMA_CSRX2_REQPEND_SHIFT)
#define  PDMA_DMA_CSRX2_REQPEND_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX2_REQPEND_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX2_REQPEND_SHIFT))

#define  PDMA_DMA_CSRX2_RESERVED2_MASK 0xe0
#define  PDMA_DMA_CSRX2_RESERVED2_SHIFT 5
#define  PDMA_DMA_CSRX2_RESERVED2_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX2_RESERVED2_MASK) >> PDMA_DMA_CSRX2_RESERVED2_SHIFT)
#define  PDMA_DMA_CSRX2_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX2_RESERVED2_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX2_RESERVED2_SHIFT))

#define  PDMA_DMA_CSRX2_RASINTR_MASK 0x10
#define  PDMA_DMA_CSRX2_RASINTR_SHIFT 4
#define  PDMA_DMA_CSRX2_RASINTR_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX2_RASINTR_MASK) >> PDMA_DMA_CSRX2_RASINTR_SHIFT)
#define  PDMA_DMA_CSRX2_RASINTR_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX2_RASINTR_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX2_RASINTR_SHIFT))

#define  PDMA_DMA_CSRX2_STOPINTR_MASK 0x8
#define  PDMA_DMA_CSRX2_STOPINTR_SHIFT 3
#define  PDMA_DMA_CSRX2_STOPINTR_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX2_STOPINTR_MASK) >> PDMA_DMA_CSRX2_STOPINTR_SHIFT)
#define  PDMA_DMA_CSRX2_STOPINTR_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX2_STOPINTR_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX2_STOPINTR_SHIFT))

#define  PDMA_DMA_CSRX2_ENDINTR_MASK 0x4
#define  PDMA_DMA_CSRX2_ENDINTR_SHIFT 2
#define  PDMA_DMA_CSRX2_ENDINTR_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX2_ENDINTR_MASK) >> PDMA_DMA_CSRX2_ENDINTR_SHIFT)
#define  PDMA_DMA_CSRX2_ENDINTR_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX2_ENDINTR_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX2_ENDINTR_SHIFT))

#define  PDMA_DMA_CSRX2_STARTINTR_MASK 0x2
#define  PDMA_DMA_CSRX2_STARTINTR_SHIFT 1
#define  PDMA_DMA_CSRX2_STARTINTR_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX2_STARTINTR_MASK) >> PDMA_DMA_CSRX2_STARTINTR_SHIFT)
#define  PDMA_DMA_CSRX2_STARTINTR_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX2_STARTINTR_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX2_STARTINTR_SHIFT))

#define  PDMA_DMA_CSRX2_BUSERRINTR_MASK 0x1
#define  PDMA_DMA_CSRX2_BUSERRINTR_SHIFT 0
#define  PDMA_DMA_CSRX2_BUSERRINTR_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX2_BUSERRINTR_MASK) >> PDMA_DMA_CSRX2_BUSERRINTR_SHIFT)
#define  PDMA_DMA_CSRX2_BUSERRINTR_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX2_BUSERRINTR_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX2_BUSERRINTR_SHIFT))

//====================================================================
//Register: DMA Channel Control/Status Registers 0-15 (Instance 4 of 16) (DMA_CSRx3)
/** \brief These read/write registers contain the control and status bits for the channels.
<br>
Ignore reads from reserved bits. Write 0x0 to reserved bits.
<br>
Address offsets:
<br>
DMA Channel 0 Register = 0x0000
<br>
DMA Channel 1 Register = 0x0004
<br>
DMA Channel 2 Register = 0x0008
<br>
DMA Channel 3 Register = 0x000C
<br>
DMA Channel 4 Register = 0x0010
<br>
DMA Channel 5 Register = 0x0014
<br>
DMA Channel 6 Register = 0x0018
<br>
DMA Channel 7 Register = 0x001C
<br>
DMA Channel 8 Register = 0x0020
<br>
DMA Channel 9 Register = 0x0024
<br>
DMA Channel 10 Register = 0x0028
<br>
DMA Channel 11 Register = 0x002C
<br>
DMA Channel 12 Register = 0x0030
<br>
DMA Channel 13 Register = 0x0034
<br>
DMA Channel 14 Register = 0x0038
<br>
DMA Channel 15 Register = 0x003C
<br> (Instance 4 of 16)*/
//====================================================================

#define  PDMA_DMA_CSRX3_RUN_MASK 0x80000000
#define  PDMA_DMA_CSRX3_RUN_SHIFT 31
#define  PDMA_DMA_CSRX3_RUN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX3_RUN_MASK) >> PDMA_DMA_CSRX3_RUN_SHIFT)
#define  PDMA_DMA_CSRX3_RUN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX3_RUN_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX3_RUN_SHIFT))

#define  PDMA_DMA_CSRX3_NODESCFETCH_MASK 0x40000000
#define  PDMA_DMA_CSRX3_NODESCFETCH_SHIFT 30
#define  PDMA_DMA_CSRX3_NODESCFETCH_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX3_NODESCFETCH_MASK) >> PDMA_DMA_CSRX3_NODESCFETCH_SHIFT)
#define  PDMA_DMA_CSRX3_NODESCFETCH_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX3_NODESCFETCH_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX3_NODESCFETCH_SHIFT))

#define  PDMA_DMA_CSRX3_STOPIRQEN_MASK 0x20000000
#define  PDMA_DMA_CSRX3_STOPIRQEN_SHIFT 29
#define  PDMA_DMA_CSRX3_STOPIRQEN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX3_STOPIRQEN_MASK) >> PDMA_DMA_CSRX3_STOPIRQEN_SHIFT)
#define  PDMA_DMA_CSRX3_STOPIRQEN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX3_STOPIRQEN_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX3_STOPIRQEN_SHIFT))

#define  PDMA_DMA_CSRX3_EORIRQEN_MASK 0x10000000
#define  PDMA_DMA_CSRX3_EORIRQEN_SHIFT 28
#define  PDMA_DMA_CSRX3_EORIRQEN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX3_EORIRQEN_MASK) >> PDMA_DMA_CSRX3_EORIRQEN_SHIFT)
#define  PDMA_DMA_CSRX3_EORIRQEN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX3_EORIRQEN_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX3_EORIRQEN_SHIFT))

#define  PDMA_DMA_CSRX3_EORJMPEN_MASK 0x8000000
#define  PDMA_DMA_CSRX3_EORJMPEN_SHIFT 27
#define  PDMA_DMA_CSRX3_EORJMPEN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX3_EORJMPEN_MASK) >> PDMA_DMA_CSRX3_EORJMPEN_SHIFT)
#define  PDMA_DMA_CSRX3_EORJMPEN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX3_EORJMPEN_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX3_EORJMPEN_SHIFT))

#define  PDMA_DMA_CSRX3_EORSTOPEN_MASK 0x4000000
#define  PDMA_DMA_CSRX3_EORSTOPEN_SHIFT 26
#define  PDMA_DMA_CSRX3_EORSTOPEN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX3_EORSTOPEN_MASK) >> PDMA_DMA_CSRX3_EORSTOPEN_SHIFT)
#define  PDMA_DMA_CSRX3_EORSTOPEN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX3_EORSTOPEN_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX3_EORSTOPEN_SHIFT))

#define  PDMA_DMA_CSRX3_SETCMPST_MASK 0x2000000
#define  PDMA_DMA_CSRX3_SETCMPST_SHIFT 25
#define  PDMA_DMA_CSRX3_SETCMPST_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX3_SETCMPST_MASK) >> PDMA_DMA_CSRX3_SETCMPST_SHIFT)
#define  PDMA_DMA_CSRX3_SETCMPST_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX3_SETCMPST_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX3_SETCMPST_SHIFT))

#define  PDMA_DMA_CSRX3_CLRCMPST_MASK 0x1000000
#define  PDMA_DMA_CSRX3_CLRCMPST_SHIFT 24
#define  PDMA_DMA_CSRX3_CLRCMPST_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX3_CLRCMPST_MASK) >> PDMA_DMA_CSRX3_CLRCMPST_SHIFT)
#define  PDMA_DMA_CSRX3_CLRCMPST_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX3_CLRCMPST_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX3_CLRCMPST_SHIFT))

#define  PDMA_DMA_CSRX3_RASIRQEN_MASK 0x800000
#define  PDMA_DMA_CSRX3_RASIRQEN_SHIFT 23
#define  PDMA_DMA_CSRX3_RASIRQEN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX3_RASIRQEN_MASK) >> PDMA_DMA_CSRX3_RASIRQEN_SHIFT)
#define  PDMA_DMA_CSRX3_RASIRQEN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX3_RASIRQEN_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX3_RASIRQEN_SHIFT))

#define  PDMA_DMA_CSRX3_MASKRUN_MASK 0x400000
#define  PDMA_DMA_CSRX3_MASKRUN_SHIFT 22
#define  PDMA_DMA_CSRX3_MASKRUN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX3_MASKRUN_MASK) >> PDMA_DMA_CSRX3_MASKRUN_SHIFT)
#define  PDMA_DMA_CSRX3_MASKRUN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX3_MASKRUN_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX3_MASKRUN_SHIFT))

#define  PDMA_DMA_CSRX3_RESERVED1_MASK 0x3ff800
#define  PDMA_DMA_CSRX3_RESERVED1_SHIFT 11
#define  PDMA_DMA_CSRX3_RESERVED1_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX3_RESERVED1_MASK) >> PDMA_DMA_CSRX3_RESERVED1_SHIFT)
#define  PDMA_DMA_CSRX3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX3_RESERVED1_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX3_RESERVED1_SHIFT))

#define  PDMA_DMA_CSRX3_CMPST_MASK 0x400
#define  PDMA_DMA_CSRX3_CMPST_SHIFT 10
#define  PDMA_DMA_CSRX3_CMPST_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX3_CMPST_MASK) >> PDMA_DMA_CSRX3_CMPST_SHIFT)
#define  PDMA_DMA_CSRX3_CMPST_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX3_CMPST_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX3_CMPST_SHIFT))

#define  PDMA_DMA_CSRX3_EORINT_MASK 0x200
#define  PDMA_DMA_CSRX3_EORINT_SHIFT 9
#define  PDMA_DMA_CSRX3_EORINT_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX3_EORINT_MASK) >> PDMA_DMA_CSRX3_EORINT_SHIFT)
#define  PDMA_DMA_CSRX3_EORINT_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX3_EORINT_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX3_EORINT_SHIFT))

#define  PDMA_DMA_CSRX3_REQPEND_MASK 0x100
#define  PDMA_DMA_CSRX3_REQPEND_SHIFT 8
#define  PDMA_DMA_CSRX3_REQPEND_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX3_REQPEND_MASK) >> PDMA_DMA_CSRX3_REQPEND_SHIFT)
#define  PDMA_DMA_CSRX3_REQPEND_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX3_REQPEND_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX3_REQPEND_SHIFT))

#define  PDMA_DMA_CSRX3_RESERVED2_MASK 0xe0
#define  PDMA_DMA_CSRX3_RESERVED2_SHIFT 5
#define  PDMA_DMA_CSRX3_RESERVED2_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX3_RESERVED2_MASK) >> PDMA_DMA_CSRX3_RESERVED2_SHIFT)
#define  PDMA_DMA_CSRX3_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX3_RESERVED2_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX3_RESERVED2_SHIFT))

#define  PDMA_DMA_CSRX3_RASINTR_MASK 0x10
#define  PDMA_DMA_CSRX3_RASINTR_SHIFT 4
#define  PDMA_DMA_CSRX3_RASINTR_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX3_RASINTR_MASK) >> PDMA_DMA_CSRX3_RASINTR_SHIFT)
#define  PDMA_DMA_CSRX3_RASINTR_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX3_RASINTR_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX3_RASINTR_SHIFT))

#define  PDMA_DMA_CSRX3_STOPINTR_MASK 0x8
#define  PDMA_DMA_CSRX3_STOPINTR_SHIFT 3
#define  PDMA_DMA_CSRX3_STOPINTR_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX3_STOPINTR_MASK) >> PDMA_DMA_CSRX3_STOPINTR_SHIFT)
#define  PDMA_DMA_CSRX3_STOPINTR_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX3_STOPINTR_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX3_STOPINTR_SHIFT))

#define  PDMA_DMA_CSRX3_ENDINTR_MASK 0x4
#define  PDMA_DMA_CSRX3_ENDINTR_SHIFT 2
#define  PDMA_DMA_CSRX3_ENDINTR_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX3_ENDINTR_MASK) >> PDMA_DMA_CSRX3_ENDINTR_SHIFT)
#define  PDMA_DMA_CSRX3_ENDINTR_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX3_ENDINTR_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX3_ENDINTR_SHIFT))

#define  PDMA_DMA_CSRX3_STARTINTR_MASK 0x2
#define  PDMA_DMA_CSRX3_STARTINTR_SHIFT 1
#define  PDMA_DMA_CSRX3_STARTINTR_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX3_STARTINTR_MASK) >> PDMA_DMA_CSRX3_STARTINTR_SHIFT)
#define  PDMA_DMA_CSRX3_STARTINTR_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX3_STARTINTR_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX3_STARTINTR_SHIFT))

#define  PDMA_DMA_CSRX3_BUSERRINTR_MASK 0x1
#define  PDMA_DMA_CSRX3_BUSERRINTR_SHIFT 0
#define  PDMA_DMA_CSRX3_BUSERRINTR_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX3_BUSERRINTR_MASK) >> PDMA_DMA_CSRX3_BUSERRINTR_SHIFT)
#define  PDMA_DMA_CSRX3_BUSERRINTR_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX3_BUSERRINTR_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX3_BUSERRINTR_SHIFT))

//====================================================================
//Register: DMA Channel Control/Status Registers 0-15 (Instance 5 of 16) (DMA_CSRx4)
/** \brief These read/write registers contain the control and status bits for the channels.
<br>
Ignore reads from reserved bits. Write 0x0 to reserved bits.
<br>
Address offsets:
<br>
DMA Channel 0 Register = 0x0000
<br>
DMA Channel 1 Register = 0x0004
<br>
DMA Channel 2 Register = 0x0008
<br>
DMA Channel 3 Register = 0x000C
<br>
DMA Channel 4 Register = 0x0010
<br>
DMA Channel 5 Register = 0x0014
<br>
DMA Channel 6 Register = 0x0018
<br>
DMA Channel 7 Register = 0x001C
<br>
DMA Channel 8 Register = 0x0020
<br>
DMA Channel 9 Register = 0x0024
<br>
DMA Channel 10 Register = 0x0028
<br>
DMA Channel 11 Register = 0x002C
<br>
DMA Channel 12 Register = 0x0030
<br>
DMA Channel 13 Register = 0x0034
<br>
DMA Channel 14 Register = 0x0038
<br>
DMA Channel 15 Register = 0x003C
<br> (Instance 5 of 16)*/
//====================================================================

#define  PDMA_DMA_CSRX4_RUN_MASK 0x80000000
#define  PDMA_DMA_CSRX4_RUN_SHIFT 31
#define  PDMA_DMA_CSRX4_RUN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX4_RUN_MASK) >> PDMA_DMA_CSRX4_RUN_SHIFT)
#define  PDMA_DMA_CSRX4_RUN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX4_RUN_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX4_RUN_SHIFT))

#define  PDMA_DMA_CSRX4_NODESCFETCH_MASK 0x40000000
#define  PDMA_DMA_CSRX4_NODESCFETCH_SHIFT 30
#define  PDMA_DMA_CSRX4_NODESCFETCH_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX4_NODESCFETCH_MASK) >> PDMA_DMA_CSRX4_NODESCFETCH_SHIFT)
#define  PDMA_DMA_CSRX4_NODESCFETCH_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX4_NODESCFETCH_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX4_NODESCFETCH_SHIFT))

#define  PDMA_DMA_CSRX4_STOPIRQEN_MASK 0x20000000
#define  PDMA_DMA_CSRX4_STOPIRQEN_SHIFT 29
#define  PDMA_DMA_CSRX4_STOPIRQEN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX4_STOPIRQEN_MASK) >> PDMA_DMA_CSRX4_STOPIRQEN_SHIFT)
#define  PDMA_DMA_CSRX4_STOPIRQEN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX4_STOPIRQEN_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX4_STOPIRQEN_SHIFT))

#define  PDMA_DMA_CSRX4_EORIRQEN_MASK 0x10000000
#define  PDMA_DMA_CSRX4_EORIRQEN_SHIFT 28
#define  PDMA_DMA_CSRX4_EORIRQEN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX4_EORIRQEN_MASK) >> PDMA_DMA_CSRX4_EORIRQEN_SHIFT)
#define  PDMA_DMA_CSRX4_EORIRQEN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX4_EORIRQEN_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX4_EORIRQEN_SHIFT))

#define  PDMA_DMA_CSRX4_EORJMPEN_MASK 0x8000000
#define  PDMA_DMA_CSRX4_EORJMPEN_SHIFT 27
#define  PDMA_DMA_CSRX4_EORJMPEN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX4_EORJMPEN_MASK) >> PDMA_DMA_CSRX4_EORJMPEN_SHIFT)
#define  PDMA_DMA_CSRX4_EORJMPEN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX4_EORJMPEN_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX4_EORJMPEN_SHIFT))

#define  PDMA_DMA_CSRX4_EORSTOPEN_MASK 0x4000000
#define  PDMA_DMA_CSRX4_EORSTOPEN_SHIFT 26
#define  PDMA_DMA_CSRX4_EORSTOPEN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX4_EORSTOPEN_MASK) >> PDMA_DMA_CSRX4_EORSTOPEN_SHIFT)
#define  PDMA_DMA_CSRX4_EORSTOPEN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX4_EORSTOPEN_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX4_EORSTOPEN_SHIFT))

#define  PDMA_DMA_CSRX4_SETCMPST_MASK 0x2000000
#define  PDMA_DMA_CSRX4_SETCMPST_SHIFT 25
#define  PDMA_DMA_CSRX4_SETCMPST_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX4_SETCMPST_MASK) >> PDMA_DMA_CSRX4_SETCMPST_SHIFT)
#define  PDMA_DMA_CSRX4_SETCMPST_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX4_SETCMPST_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX4_SETCMPST_SHIFT))

#define  PDMA_DMA_CSRX4_CLRCMPST_MASK 0x1000000
#define  PDMA_DMA_CSRX4_CLRCMPST_SHIFT 24
#define  PDMA_DMA_CSRX4_CLRCMPST_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX4_CLRCMPST_MASK) >> PDMA_DMA_CSRX4_CLRCMPST_SHIFT)
#define  PDMA_DMA_CSRX4_CLRCMPST_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX4_CLRCMPST_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX4_CLRCMPST_SHIFT))

#define  PDMA_DMA_CSRX4_RASIRQEN_MASK 0x800000
#define  PDMA_DMA_CSRX4_RASIRQEN_SHIFT 23
#define  PDMA_DMA_CSRX4_RASIRQEN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX4_RASIRQEN_MASK) >> PDMA_DMA_CSRX4_RASIRQEN_SHIFT)
#define  PDMA_DMA_CSRX4_RASIRQEN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX4_RASIRQEN_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX4_RASIRQEN_SHIFT))

#define  PDMA_DMA_CSRX4_MASKRUN_MASK 0x400000
#define  PDMA_DMA_CSRX4_MASKRUN_SHIFT 22
#define  PDMA_DMA_CSRX4_MASKRUN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX4_MASKRUN_MASK) >> PDMA_DMA_CSRX4_MASKRUN_SHIFT)
#define  PDMA_DMA_CSRX4_MASKRUN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX4_MASKRUN_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX4_MASKRUN_SHIFT))

#define  PDMA_DMA_CSRX4_RESERVED1_MASK 0x3ff800
#define  PDMA_DMA_CSRX4_RESERVED1_SHIFT 11
#define  PDMA_DMA_CSRX4_RESERVED1_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX4_RESERVED1_MASK) >> PDMA_DMA_CSRX4_RESERVED1_SHIFT)
#define  PDMA_DMA_CSRX4_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX4_RESERVED1_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX4_RESERVED1_SHIFT))

#define  PDMA_DMA_CSRX4_CMPST_MASK 0x400
#define  PDMA_DMA_CSRX4_CMPST_SHIFT 10
#define  PDMA_DMA_CSRX4_CMPST_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX4_CMPST_MASK) >> PDMA_DMA_CSRX4_CMPST_SHIFT)
#define  PDMA_DMA_CSRX4_CMPST_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX4_CMPST_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX4_CMPST_SHIFT))

#define  PDMA_DMA_CSRX4_EORINT_MASK 0x200
#define  PDMA_DMA_CSRX4_EORINT_SHIFT 9
#define  PDMA_DMA_CSRX4_EORINT_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX4_EORINT_MASK) >> PDMA_DMA_CSRX4_EORINT_SHIFT)
#define  PDMA_DMA_CSRX4_EORINT_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX4_EORINT_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX4_EORINT_SHIFT))

#define  PDMA_DMA_CSRX4_REQPEND_MASK 0x100
#define  PDMA_DMA_CSRX4_REQPEND_SHIFT 8
#define  PDMA_DMA_CSRX4_REQPEND_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX4_REQPEND_MASK) >> PDMA_DMA_CSRX4_REQPEND_SHIFT)
#define  PDMA_DMA_CSRX4_REQPEND_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX4_REQPEND_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX4_REQPEND_SHIFT))

#define  PDMA_DMA_CSRX4_RESERVED2_MASK 0xe0
#define  PDMA_DMA_CSRX4_RESERVED2_SHIFT 5
#define  PDMA_DMA_CSRX4_RESERVED2_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX4_RESERVED2_MASK) >> PDMA_DMA_CSRX4_RESERVED2_SHIFT)
#define  PDMA_DMA_CSRX4_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX4_RESERVED2_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX4_RESERVED2_SHIFT))

#define  PDMA_DMA_CSRX4_RASINTR_MASK 0x10
#define  PDMA_DMA_CSRX4_RASINTR_SHIFT 4
#define  PDMA_DMA_CSRX4_RASINTR_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX4_RASINTR_MASK) >> PDMA_DMA_CSRX4_RASINTR_SHIFT)
#define  PDMA_DMA_CSRX4_RASINTR_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX4_RASINTR_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX4_RASINTR_SHIFT))

#define  PDMA_DMA_CSRX4_STOPINTR_MASK 0x8
#define  PDMA_DMA_CSRX4_STOPINTR_SHIFT 3
#define  PDMA_DMA_CSRX4_STOPINTR_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX4_STOPINTR_MASK) >> PDMA_DMA_CSRX4_STOPINTR_SHIFT)
#define  PDMA_DMA_CSRX4_STOPINTR_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX4_STOPINTR_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX4_STOPINTR_SHIFT))

#define  PDMA_DMA_CSRX4_ENDINTR_MASK 0x4
#define  PDMA_DMA_CSRX4_ENDINTR_SHIFT 2
#define  PDMA_DMA_CSRX4_ENDINTR_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX4_ENDINTR_MASK) >> PDMA_DMA_CSRX4_ENDINTR_SHIFT)
#define  PDMA_DMA_CSRX4_ENDINTR_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX4_ENDINTR_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX4_ENDINTR_SHIFT))

#define  PDMA_DMA_CSRX4_STARTINTR_MASK 0x2
#define  PDMA_DMA_CSRX4_STARTINTR_SHIFT 1
#define  PDMA_DMA_CSRX4_STARTINTR_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX4_STARTINTR_MASK) >> PDMA_DMA_CSRX4_STARTINTR_SHIFT)
#define  PDMA_DMA_CSRX4_STARTINTR_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX4_STARTINTR_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX4_STARTINTR_SHIFT))

#define  PDMA_DMA_CSRX4_BUSERRINTR_MASK 0x1
#define  PDMA_DMA_CSRX4_BUSERRINTR_SHIFT 0
#define  PDMA_DMA_CSRX4_BUSERRINTR_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX4_BUSERRINTR_MASK) >> PDMA_DMA_CSRX4_BUSERRINTR_SHIFT)
#define  PDMA_DMA_CSRX4_BUSERRINTR_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX4_BUSERRINTR_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX4_BUSERRINTR_SHIFT))

//====================================================================
//Register: DMA Channel Control/Status Registers 0-15 (Instance 6 of 16) (DMA_CSRx5)
/** \brief These read/write registers contain the control and status bits for the channels.
<br>
Ignore reads from reserved bits. Write 0x0 to reserved bits.
<br>
Address offsets:
<br>
DMA Channel 0 Register = 0x0000
<br>
DMA Channel 1 Register = 0x0004
<br>
DMA Channel 2 Register = 0x0008
<br>
DMA Channel 3 Register = 0x000C
<br>
DMA Channel 4 Register = 0x0010
<br>
DMA Channel 5 Register = 0x0014
<br>
DMA Channel 6 Register = 0x0018
<br>
DMA Channel 7 Register = 0x001C
<br>
DMA Channel 8 Register = 0x0020
<br>
DMA Channel 9 Register = 0x0024
<br>
DMA Channel 10 Register = 0x0028
<br>
DMA Channel 11 Register = 0x002C
<br>
DMA Channel 12 Register = 0x0030
<br>
DMA Channel 13 Register = 0x0034
<br>
DMA Channel 14 Register = 0x0038
<br>
DMA Channel 15 Register = 0x003C
<br> (Instance 6 of 16)*/
//====================================================================

#define  PDMA_DMA_CSRX5_RUN_MASK 0x80000000
#define  PDMA_DMA_CSRX5_RUN_SHIFT 31
#define  PDMA_DMA_CSRX5_RUN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX5_RUN_MASK) >> PDMA_DMA_CSRX5_RUN_SHIFT)
#define  PDMA_DMA_CSRX5_RUN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX5_RUN_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX5_RUN_SHIFT))

#define  PDMA_DMA_CSRX5_NODESCFETCH_MASK 0x40000000
#define  PDMA_DMA_CSRX5_NODESCFETCH_SHIFT 30
#define  PDMA_DMA_CSRX5_NODESCFETCH_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX5_NODESCFETCH_MASK) >> PDMA_DMA_CSRX5_NODESCFETCH_SHIFT)
#define  PDMA_DMA_CSRX5_NODESCFETCH_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX5_NODESCFETCH_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX5_NODESCFETCH_SHIFT))

#define  PDMA_DMA_CSRX5_STOPIRQEN_MASK 0x20000000
#define  PDMA_DMA_CSRX5_STOPIRQEN_SHIFT 29
#define  PDMA_DMA_CSRX5_STOPIRQEN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX5_STOPIRQEN_MASK) >> PDMA_DMA_CSRX5_STOPIRQEN_SHIFT)
#define  PDMA_DMA_CSRX5_STOPIRQEN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX5_STOPIRQEN_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX5_STOPIRQEN_SHIFT))

#define  PDMA_DMA_CSRX5_EORIRQEN_MASK 0x10000000
#define  PDMA_DMA_CSRX5_EORIRQEN_SHIFT 28
#define  PDMA_DMA_CSRX5_EORIRQEN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX5_EORIRQEN_MASK) >> PDMA_DMA_CSRX5_EORIRQEN_SHIFT)
#define  PDMA_DMA_CSRX5_EORIRQEN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX5_EORIRQEN_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX5_EORIRQEN_SHIFT))

#define  PDMA_DMA_CSRX5_EORJMPEN_MASK 0x8000000
#define  PDMA_DMA_CSRX5_EORJMPEN_SHIFT 27
#define  PDMA_DMA_CSRX5_EORJMPEN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX5_EORJMPEN_MASK) >> PDMA_DMA_CSRX5_EORJMPEN_SHIFT)
#define  PDMA_DMA_CSRX5_EORJMPEN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX5_EORJMPEN_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX5_EORJMPEN_SHIFT))

#define  PDMA_DMA_CSRX5_EORSTOPEN_MASK 0x4000000
#define  PDMA_DMA_CSRX5_EORSTOPEN_SHIFT 26
#define  PDMA_DMA_CSRX5_EORSTOPEN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX5_EORSTOPEN_MASK) >> PDMA_DMA_CSRX5_EORSTOPEN_SHIFT)
#define  PDMA_DMA_CSRX5_EORSTOPEN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX5_EORSTOPEN_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX5_EORSTOPEN_SHIFT))

#define  PDMA_DMA_CSRX5_SETCMPST_MASK 0x2000000
#define  PDMA_DMA_CSRX5_SETCMPST_SHIFT 25
#define  PDMA_DMA_CSRX5_SETCMPST_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX5_SETCMPST_MASK) >> PDMA_DMA_CSRX5_SETCMPST_SHIFT)
#define  PDMA_DMA_CSRX5_SETCMPST_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX5_SETCMPST_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX5_SETCMPST_SHIFT))

#define  PDMA_DMA_CSRX5_CLRCMPST_MASK 0x1000000
#define  PDMA_DMA_CSRX5_CLRCMPST_SHIFT 24
#define  PDMA_DMA_CSRX5_CLRCMPST_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX5_CLRCMPST_MASK) >> PDMA_DMA_CSRX5_CLRCMPST_SHIFT)
#define  PDMA_DMA_CSRX5_CLRCMPST_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX5_CLRCMPST_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX5_CLRCMPST_SHIFT))

#define  PDMA_DMA_CSRX5_RASIRQEN_MASK 0x800000
#define  PDMA_DMA_CSRX5_RASIRQEN_SHIFT 23
#define  PDMA_DMA_CSRX5_RASIRQEN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX5_RASIRQEN_MASK) >> PDMA_DMA_CSRX5_RASIRQEN_SHIFT)
#define  PDMA_DMA_CSRX5_RASIRQEN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX5_RASIRQEN_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX5_RASIRQEN_SHIFT))

#define  PDMA_DMA_CSRX5_MASKRUN_MASK 0x400000
#define  PDMA_DMA_CSRX5_MASKRUN_SHIFT 22
#define  PDMA_DMA_CSRX5_MASKRUN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX5_MASKRUN_MASK) >> PDMA_DMA_CSRX5_MASKRUN_SHIFT)
#define  PDMA_DMA_CSRX5_MASKRUN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX5_MASKRUN_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX5_MASKRUN_SHIFT))

#define  PDMA_DMA_CSRX5_RESERVED1_MASK 0x3ff800
#define  PDMA_DMA_CSRX5_RESERVED1_SHIFT 11
#define  PDMA_DMA_CSRX5_RESERVED1_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX5_RESERVED1_MASK) >> PDMA_DMA_CSRX5_RESERVED1_SHIFT)
#define  PDMA_DMA_CSRX5_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX5_RESERVED1_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX5_RESERVED1_SHIFT))

#define  PDMA_DMA_CSRX5_CMPST_MASK 0x400
#define  PDMA_DMA_CSRX5_CMPST_SHIFT 10
#define  PDMA_DMA_CSRX5_CMPST_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX5_CMPST_MASK) >> PDMA_DMA_CSRX5_CMPST_SHIFT)
#define  PDMA_DMA_CSRX5_CMPST_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX5_CMPST_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX5_CMPST_SHIFT))

#define  PDMA_DMA_CSRX5_EORINT_MASK 0x200
#define  PDMA_DMA_CSRX5_EORINT_SHIFT 9
#define  PDMA_DMA_CSRX5_EORINT_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX5_EORINT_MASK) >> PDMA_DMA_CSRX5_EORINT_SHIFT)
#define  PDMA_DMA_CSRX5_EORINT_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX5_EORINT_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX5_EORINT_SHIFT))

#define  PDMA_DMA_CSRX5_REQPEND_MASK 0x100
#define  PDMA_DMA_CSRX5_REQPEND_SHIFT 8
#define  PDMA_DMA_CSRX5_REQPEND_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX5_REQPEND_MASK) >> PDMA_DMA_CSRX5_REQPEND_SHIFT)
#define  PDMA_DMA_CSRX5_REQPEND_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX5_REQPEND_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX5_REQPEND_SHIFT))

#define  PDMA_DMA_CSRX5_RESERVED2_MASK 0xe0
#define  PDMA_DMA_CSRX5_RESERVED2_SHIFT 5
#define  PDMA_DMA_CSRX5_RESERVED2_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX5_RESERVED2_MASK) >> PDMA_DMA_CSRX5_RESERVED2_SHIFT)
#define  PDMA_DMA_CSRX5_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX5_RESERVED2_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX5_RESERVED2_SHIFT))

#define  PDMA_DMA_CSRX5_RASINTR_MASK 0x10
#define  PDMA_DMA_CSRX5_RASINTR_SHIFT 4
#define  PDMA_DMA_CSRX5_RASINTR_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX5_RASINTR_MASK) >> PDMA_DMA_CSRX5_RASINTR_SHIFT)
#define  PDMA_DMA_CSRX5_RASINTR_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX5_RASINTR_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX5_RASINTR_SHIFT))

#define  PDMA_DMA_CSRX5_STOPINTR_MASK 0x8
#define  PDMA_DMA_CSRX5_STOPINTR_SHIFT 3
#define  PDMA_DMA_CSRX5_STOPINTR_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX5_STOPINTR_MASK) >> PDMA_DMA_CSRX5_STOPINTR_SHIFT)
#define  PDMA_DMA_CSRX5_STOPINTR_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX5_STOPINTR_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX5_STOPINTR_SHIFT))

#define  PDMA_DMA_CSRX5_ENDINTR_MASK 0x4
#define  PDMA_DMA_CSRX5_ENDINTR_SHIFT 2
#define  PDMA_DMA_CSRX5_ENDINTR_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX5_ENDINTR_MASK) >> PDMA_DMA_CSRX5_ENDINTR_SHIFT)
#define  PDMA_DMA_CSRX5_ENDINTR_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX5_ENDINTR_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX5_ENDINTR_SHIFT))

#define  PDMA_DMA_CSRX5_STARTINTR_MASK 0x2
#define  PDMA_DMA_CSRX5_STARTINTR_SHIFT 1
#define  PDMA_DMA_CSRX5_STARTINTR_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX5_STARTINTR_MASK) >> PDMA_DMA_CSRX5_STARTINTR_SHIFT)
#define  PDMA_DMA_CSRX5_STARTINTR_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX5_STARTINTR_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX5_STARTINTR_SHIFT))

#define  PDMA_DMA_CSRX5_BUSERRINTR_MASK 0x1
#define  PDMA_DMA_CSRX5_BUSERRINTR_SHIFT 0
#define  PDMA_DMA_CSRX5_BUSERRINTR_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX5_BUSERRINTR_MASK) >> PDMA_DMA_CSRX5_BUSERRINTR_SHIFT)
#define  PDMA_DMA_CSRX5_BUSERRINTR_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX5_BUSERRINTR_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX5_BUSERRINTR_SHIFT))

//====================================================================
//Register: DMA Channel Control/Status Registers 0-15 (Instance 7 of 16) (DMA_CSRx6)
/** \brief These read/write registers contain the control and status bits for the channels.
<br>
Ignore reads from reserved bits. Write 0x0 to reserved bits.
<br>
Address offsets:
<br>
DMA Channel 0 Register = 0x0000
<br>
DMA Channel 1 Register = 0x0004
<br>
DMA Channel 2 Register = 0x0008
<br>
DMA Channel 3 Register = 0x000C
<br>
DMA Channel 4 Register = 0x0010
<br>
DMA Channel 5 Register = 0x0014
<br>
DMA Channel 6 Register = 0x0018
<br>
DMA Channel 7 Register = 0x001C
<br>
DMA Channel 8 Register = 0x0020
<br>
DMA Channel 9 Register = 0x0024
<br>
DMA Channel 10 Register = 0x0028
<br>
DMA Channel 11 Register = 0x002C
<br>
DMA Channel 12 Register = 0x0030
<br>
DMA Channel 13 Register = 0x0034
<br>
DMA Channel 14 Register = 0x0038
<br>
DMA Channel 15 Register = 0x003C
<br> (Instance 7 of 16)*/
//====================================================================

#define  PDMA_DMA_CSRX6_RUN_MASK 0x80000000
#define  PDMA_DMA_CSRX6_RUN_SHIFT 31
#define  PDMA_DMA_CSRX6_RUN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX6_RUN_MASK) >> PDMA_DMA_CSRX6_RUN_SHIFT)
#define  PDMA_DMA_CSRX6_RUN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX6_RUN_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX6_RUN_SHIFT))

#define  PDMA_DMA_CSRX6_NODESCFETCH_MASK 0x40000000
#define  PDMA_DMA_CSRX6_NODESCFETCH_SHIFT 30
#define  PDMA_DMA_CSRX6_NODESCFETCH_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX6_NODESCFETCH_MASK) >> PDMA_DMA_CSRX6_NODESCFETCH_SHIFT)
#define  PDMA_DMA_CSRX6_NODESCFETCH_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX6_NODESCFETCH_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX6_NODESCFETCH_SHIFT))

#define  PDMA_DMA_CSRX6_STOPIRQEN_MASK 0x20000000
#define  PDMA_DMA_CSRX6_STOPIRQEN_SHIFT 29
#define  PDMA_DMA_CSRX6_STOPIRQEN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX6_STOPIRQEN_MASK) >> PDMA_DMA_CSRX6_STOPIRQEN_SHIFT)
#define  PDMA_DMA_CSRX6_STOPIRQEN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX6_STOPIRQEN_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX6_STOPIRQEN_SHIFT))

#define  PDMA_DMA_CSRX6_EORIRQEN_MASK 0x10000000
#define  PDMA_DMA_CSRX6_EORIRQEN_SHIFT 28
#define  PDMA_DMA_CSRX6_EORIRQEN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX6_EORIRQEN_MASK) >> PDMA_DMA_CSRX6_EORIRQEN_SHIFT)
#define  PDMA_DMA_CSRX6_EORIRQEN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX6_EORIRQEN_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX6_EORIRQEN_SHIFT))

#define  PDMA_DMA_CSRX6_EORJMPEN_MASK 0x8000000
#define  PDMA_DMA_CSRX6_EORJMPEN_SHIFT 27
#define  PDMA_DMA_CSRX6_EORJMPEN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX6_EORJMPEN_MASK) >> PDMA_DMA_CSRX6_EORJMPEN_SHIFT)
#define  PDMA_DMA_CSRX6_EORJMPEN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX6_EORJMPEN_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX6_EORJMPEN_SHIFT))

#define  PDMA_DMA_CSRX6_EORSTOPEN_MASK 0x4000000
#define  PDMA_DMA_CSRX6_EORSTOPEN_SHIFT 26
#define  PDMA_DMA_CSRX6_EORSTOPEN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX6_EORSTOPEN_MASK) >> PDMA_DMA_CSRX6_EORSTOPEN_SHIFT)
#define  PDMA_DMA_CSRX6_EORSTOPEN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX6_EORSTOPEN_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX6_EORSTOPEN_SHIFT))

#define  PDMA_DMA_CSRX6_SETCMPST_MASK 0x2000000
#define  PDMA_DMA_CSRX6_SETCMPST_SHIFT 25
#define  PDMA_DMA_CSRX6_SETCMPST_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX6_SETCMPST_MASK) >> PDMA_DMA_CSRX6_SETCMPST_SHIFT)
#define  PDMA_DMA_CSRX6_SETCMPST_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX6_SETCMPST_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX6_SETCMPST_SHIFT))

#define  PDMA_DMA_CSRX6_CLRCMPST_MASK 0x1000000
#define  PDMA_DMA_CSRX6_CLRCMPST_SHIFT 24
#define  PDMA_DMA_CSRX6_CLRCMPST_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX6_CLRCMPST_MASK) >> PDMA_DMA_CSRX6_CLRCMPST_SHIFT)
#define  PDMA_DMA_CSRX6_CLRCMPST_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX6_CLRCMPST_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX6_CLRCMPST_SHIFT))

#define  PDMA_DMA_CSRX6_RASIRQEN_MASK 0x800000
#define  PDMA_DMA_CSRX6_RASIRQEN_SHIFT 23
#define  PDMA_DMA_CSRX6_RASIRQEN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX6_RASIRQEN_MASK) >> PDMA_DMA_CSRX6_RASIRQEN_SHIFT)
#define  PDMA_DMA_CSRX6_RASIRQEN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX6_RASIRQEN_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX6_RASIRQEN_SHIFT))

#define  PDMA_DMA_CSRX6_MASKRUN_MASK 0x400000
#define  PDMA_DMA_CSRX6_MASKRUN_SHIFT 22
#define  PDMA_DMA_CSRX6_MASKRUN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX6_MASKRUN_MASK) >> PDMA_DMA_CSRX6_MASKRUN_SHIFT)
#define  PDMA_DMA_CSRX6_MASKRUN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX6_MASKRUN_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX6_MASKRUN_SHIFT))

#define  PDMA_DMA_CSRX6_RESERVED1_MASK 0x3ff800
#define  PDMA_DMA_CSRX6_RESERVED1_SHIFT 11
#define  PDMA_DMA_CSRX6_RESERVED1_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX6_RESERVED1_MASK) >> PDMA_DMA_CSRX6_RESERVED1_SHIFT)
#define  PDMA_DMA_CSRX6_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX6_RESERVED1_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX6_RESERVED1_SHIFT))

#define  PDMA_DMA_CSRX6_CMPST_MASK 0x400
#define  PDMA_DMA_CSRX6_CMPST_SHIFT 10
#define  PDMA_DMA_CSRX6_CMPST_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX6_CMPST_MASK) >> PDMA_DMA_CSRX6_CMPST_SHIFT)
#define  PDMA_DMA_CSRX6_CMPST_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX6_CMPST_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX6_CMPST_SHIFT))

#define  PDMA_DMA_CSRX6_EORINT_MASK 0x200
#define  PDMA_DMA_CSRX6_EORINT_SHIFT 9
#define  PDMA_DMA_CSRX6_EORINT_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX6_EORINT_MASK) >> PDMA_DMA_CSRX6_EORINT_SHIFT)
#define  PDMA_DMA_CSRX6_EORINT_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX6_EORINT_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX6_EORINT_SHIFT))

#define  PDMA_DMA_CSRX6_REQPEND_MASK 0x100
#define  PDMA_DMA_CSRX6_REQPEND_SHIFT 8
#define  PDMA_DMA_CSRX6_REQPEND_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX6_REQPEND_MASK) >> PDMA_DMA_CSRX6_REQPEND_SHIFT)
#define  PDMA_DMA_CSRX6_REQPEND_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX6_REQPEND_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX6_REQPEND_SHIFT))

#define  PDMA_DMA_CSRX6_RESERVED2_MASK 0xe0
#define  PDMA_DMA_CSRX6_RESERVED2_SHIFT 5
#define  PDMA_DMA_CSRX6_RESERVED2_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX6_RESERVED2_MASK) >> PDMA_DMA_CSRX6_RESERVED2_SHIFT)
#define  PDMA_DMA_CSRX6_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX6_RESERVED2_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX6_RESERVED2_SHIFT))

#define  PDMA_DMA_CSRX6_RASINTR_MASK 0x10
#define  PDMA_DMA_CSRX6_RASINTR_SHIFT 4
#define  PDMA_DMA_CSRX6_RASINTR_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX6_RASINTR_MASK) >> PDMA_DMA_CSRX6_RASINTR_SHIFT)
#define  PDMA_DMA_CSRX6_RASINTR_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX6_RASINTR_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX6_RASINTR_SHIFT))

#define  PDMA_DMA_CSRX6_STOPINTR_MASK 0x8
#define  PDMA_DMA_CSRX6_STOPINTR_SHIFT 3
#define  PDMA_DMA_CSRX6_STOPINTR_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX6_STOPINTR_MASK) >> PDMA_DMA_CSRX6_STOPINTR_SHIFT)
#define  PDMA_DMA_CSRX6_STOPINTR_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX6_STOPINTR_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX6_STOPINTR_SHIFT))

#define  PDMA_DMA_CSRX6_ENDINTR_MASK 0x4
#define  PDMA_DMA_CSRX6_ENDINTR_SHIFT 2
#define  PDMA_DMA_CSRX6_ENDINTR_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX6_ENDINTR_MASK) >> PDMA_DMA_CSRX6_ENDINTR_SHIFT)
#define  PDMA_DMA_CSRX6_ENDINTR_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX6_ENDINTR_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX6_ENDINTR_SHIFT))

#define  PDMA_DMA_CSRX6_STARTINTR_MASK 0x2
#define  PDMA_DMA_CSRX6_STARTINTR_SHIFT 1
#define  PDMA_DMA_CSRX6_STARTINTR_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX6_STARTINTR_MASK) >> PDMA_DMA_CSRX6_STARTINTR_SHIFT)
#define  PDMA_DMA_CSRX6_STARTINTR_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX6_STARTINTR_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX6_STARTINTR_SHIFT))

#define  PDMA_DMA_CSRX6_BUSERRINTR_MASK 0x1
#define  PDMA_DMA_CSRX6_BUSERRINTR_SHIFT 0
#define  PDMA_DMA_CSRX6_BUSERRINTR_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX6_BUSERRINTR_MASK) >> PDMA_DMA_CSRX6_BUSERRINTR_SHIFT)
#define  PDMA_DMA_CSRX6_BUSERRINTR_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX6_BUSERRINTR_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX6_BUSERRINTR_SHIFT))

//====================================================================
//Register: DMA Channel Control/Status Registers 0-15 (Instance 8 of 16) (DMA_CSRx7)
/** \brief These read/write registers contain the control and status bits for the channels.
<br>
Ignore reads from reserved bits. Write 0x0 to reserved bits.
<br>
Address offsets:
<br>
DMA Channel 0 Register = 0x0000
<br>
DMA Channel 1 Register = 0x0004
<br>
DMA Channel 2 Register = 0x0008
<br>
DMA Channel 3 Register = 0x000C
<br>
DMA Channel 4 Register = 0x0010
<br>
DMA Channel 5 Register = 0x0014
<br>
DMA Channel 6 Register = 0x0018
<br>
DMA Channel 7 Register = 0x001C
<br>
DMA Channel 8 Register = 0x0020
<br>
DMA Channel 9 Register = 0x0024
<br>
DMA Channel 10 Register = 0x0028
<br>
DMA Channel 11 Register = 0x002C
<br>
DMA Channel 12 Register = 0x0030
<br>
DMA Channel 13 Register = 0x0034
<br>
DMA Channel 14 Register = 0x0038
<br>
DMA Channel 15 Register = 0x003C
<br> (Instance 8 of 16)*/
//====================================================================

#define  PDMA_DMA_CSRX7_RUN_MASK 0x80000000
#define  PDMA_DMA_CSRX7_RUN_SHIFT 31
#define  PDMA_DMA_CSRX7_RUN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX7_RUN_MASK) >> PDMA_DMA_CSRX7_RUN_SHIFT)
#define  PDMA_DMA_CSRX7_RUN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX7_RUN_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX7_RUN_SHIFT))

#define  PDMA_DMA_CSRX7_NODESCFETCH_MASK 0x40000000
#define  PDMA_DMA_CSRX7_NODESCFETCH_SHIFT 30
#define  PDMA_DMA_CSRX7_NODESCFETCH_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX7_NODESCFETCH_MASK) >> PDMA_DMA_CSRX7_NODESCFETCH_SHIFT)
#define  PDMA_DMA_CSRX7_NODESCFETCH_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX7_NODESCFETCH_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX7_NODESCFETCH_SHIFT))

#define  PDMA_DMA_CSRX7_STOPIRQEN_MASK 0x20000000
#define  PDMA_DMA_CSRX7_STOPIRQEN_SHIFT 29
#define  PDMA_DMA_CSRX7_STOPIRQEN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX7_STOPIRQEN_MASK) >> PDMA_DMA_CSRX7_STOPIRQEN_SHIFT)
#define  PDMA_DMA_CSRX7_STOPIRQEN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX7_STOPIRQEN_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX7_STOPIRQEN_SHIFT))

#define  PDMA_DMA_CSRX7_EORIRQEN_MASK 0x10000000
#define  PDMA_DMA_CSRX7_EORIRQEN_SHIFT 28
#define  PDMA_DMA_CSRX7_EORIRQEN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX7_EORIRQEN_MASK) >> PDMA_DMA_CSRX7_EORIRQEN_SHIFT)
#define  PDMA_DMA_CSRX7_EORIRQEN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX7_EORIRQEN_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX7_EORIRQEN_SHIFT))

#define  PDMA_DMA_CSRX7_EORJMPEN_MASK 0x8000000
#define  PDMA_DMA_CSRX7_EORJMPEN_SHIFT 27
#define  PDMA_DMA_CSRX7_EORJMPEN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX7_EORJMPEN_MASK) >> PDMA_DMA_CSRX7_EORJMPEN_SHIFT)
#define  PDMA_DMA_CSRX7_EORJMPEN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX7_EORJMPEN_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX7_EORJMPEN_SHIFT))

#define  PDMA_DMA_CSRX7_EORSTOPEN_MASK 0x4000000
#define  PDMA_DMA_CSRX7_EORSTOPEN_SHIFT 26
#define  PDMA_DMA_CSRX7_EORSTOPEN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX7_EORSTOPEN_MASK) >> PDMA_DMA_CSRX7_EORSTOPEN_SHIFT)
#define  PDMA_DMA_CSRX7_EORSTOPEN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX7_EORSTOPEN_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX7_EORSTOPEN_SHIFT))

#define  PDMA_DMA_CSRX7_SETCMPST_MASK 0x2000000
#define  PDMA_DMA_CSRX7_SETCMPST_SHIFT 25
#define  PDMA_DMA_CSRX7_SETCMPST_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX7_SETCMPST_MASK) >> PDMA_DMA_CSRX7_SETCMPST_SHIFT)
#define  PDMA_DMA_CSRX7_SETCMPST_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX7_SETCMPST_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX7_SETCMPST_SHIFT))

#define  PDMA_DMA_CSRX7_CLRCMPST_MASK 0x1000000
#define  PDMA_DMA_CSRX7_CLRCMPST_SHIFT 24
#define  PDMA_DMA_CSRX7_CLRCMPST_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX7_CLRCMPST_MASK) >> PDMA_DMA_CSRX7_CLRCMPST_SHIFT)
#define  PDMA_DMA_CSRX7_CLRCMPST_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX7_CLRCMPST_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX7_CLRCMPST_SHIFT))

#define  PDMA_DMA_CSRX7_RASIRQEN_MASK 0x800000
#define  PDMA_DMA_CSRX7_RASIRQEN_SHIFT 23
#define  PDMA_DMA_CSRX7_RASIRQEN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX7_RASIRQEN_MASK) >> PDMA_DMA_CSRX7_RASIRQEN_SHIFT)
#define  PDMA_DMA_CSRX7_RASIRQEN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX7_RASIRQEN_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX7_RASIRQEN_SHIFT))

#define  PDMA_DMA_CSRX7_MASKRUN_MASK 0x400000
#define  PDMA_DMA_CSRX7_MASKRUN_SHIFT 22
#define  PDMA_DMA_CSRX7_MASKRUN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX7_MASKRUN_MASK) >> PDMA_DMA_CSRX7_MASKRUN_SHIFT)
#define  PDMA_DMA_CSRX7_MASKRUN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX7_MASKRUN_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX7_MASKRUN_SHIFT))

#define  PDMA_DMA_CSRX7_RESERVED1_MASK 0x3ff800
#define  PDMA_DMA_CSRX7_RESERVED1_SHIFT 11
#define  PDMA_DMA_CSRX7_RESERVED1_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX7_RESERVED1_MASK) >> PDMA_DMA_CSRX7_RESERVED1_SHIFT)
#define  PDMA_DMA_CSRX7_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX7_RESERVED1_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX7_RESERVED1_SHIFT))

#define  PDMA_DMA_CSRX7_CMPST_MASK 0x400
#define  PDMA_DMA_CSRX7_CMPST_SHIFT 10
#define  PDMA_DMA_CSRX7_CMPST_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX7_CMPST_MASK) >> PDMA_DMA_CSRX7_CMPST_SHIFT)
#define  PDMA_DMA_CSRX7_CMPST_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX7_CMPST_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX7_CMPST_SHIFT))

#define  PDMA_DMA_CSRX7_EORINT_MASK 0x200
#define  PDMA_DMA_CSRX7_EORINT_SHIFT 9
#define  PDMA_DMA_CSRX7_EORINT_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX7_EORINT_MASK) >> PDMA_DMA_CSRX7_EORINT_SHIFT)
#define  PDMA_DMA_CSRX7_EORINT_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX7_EORINT_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX7_EORINT_SHIFT))

#define  PDMA_DMA_CSRX7_REQPEND_MASK 0x100
#define  PDMA_DMA_CSRX7_REQPEND_SHIFT 8
#define  PDMA_DMA_CSRX7_REQPEND_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX7_REQPEND_MASK) >> PDMA_DMA_CSRX7_REQPEND_SHIFT)
#define  PDMA_DMA_CSRX7_REQPEND_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX7_REQPEND_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX7_REQPEND_SHIFT))

#define  PDMA_DMA_CSRX7_RESERVED2_MASK 0xe0
#define  PDMA_DMA_CSRX7_RESERVED2_SHIFT 5
#define  PDMA_DMA_CSRX7_RESERVED2_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX7_RESERVED2_MASK) >> PDMA_DMA_CSRX7_RESERVED2_SHIFT)
#define  PDMA_DMA_CSRX7_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX7_RESERVED2_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX7_RESERVED2_SHIFT))

#define  PDMA_DMA_CSRX7_RASINTR_MASK 0x10
#define  PDMA_DMA_CSRX7_RASINTR_SHIFT 4
#define  PDMA_DMA_CSRX7_RASINTR_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX7_RASINTR_MASK) >> PDMA_DMA_CSRX7_RASINTR_SHIFT)
#define  PDMA_DMA_CSRX7_RASINTR_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX7_RASINTR_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX7_RASINTR_SHIFT))

#define  PDMA_DMA_CSRX7_STOPINTR_MASK 0x8
#define  PDMA_DMA_CSRX7_STOPINTR_SHIFT 3
#define  PDMA_DMA_CSRX7_STOPINTR_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX7_STOPINTR_MASK) >> PDMA_DMA_CSRX7_STOPINTR_SHIFT)
#define  PDMA_DMA_CSRX7_STOPINTR_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX7_STOPINTR_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX7_STOPINTR_SHIFT))

#define  PDMA_DMA_CSRX7_ENDINTR_MASK 0x4
#define  PDMA_DMA_CSRX7_ENDINTR_SHIFT 2
#define  PDMA_DMA_CSRX7_ENDINTR_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX7_ENDINTR_MASK) >> PDMA_DMA_CSRX7_ENDINTR_SHIFT)
#define  PDMA_DMA_CSRX7_ENDINTR_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX7_ENDINTR_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX7_ENDINTR_SHIFT))

#define  PDMA_DMA_CSRX7_STARTINTR_MASK 0x2
#define  PDMA_DMA_CSRX7_STARTINTR_SHIFT 1
#define  PDMA_DMA_CSRX7_STARTINTR_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX7_STARTINTR_MASK) >> PDMA_DMA_CSRX7_STARTINTR_SHIFT)
#define  PDMA_DMA_CSRX7_STARTINTR_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX7_STARTINTR_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX7_STARTINTR_SHIFT))

#define  PDMA_DMA_CSRX7_BUSERRINTR_MASK 0x1
#define  PDMA_DMA_CSRX7_BUSERRINTR_SHIFT 0
#define  PDMA_DMA_CSRX7_BUSERRINTR_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX7_BUSERRINTR_MASK) >> PDMA_DMA_CSRX7_BUSERRINTR_SHIFT)
#define  PDMA_DMA_CSRX7_BUSERRINTR_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX7_BUSERRINTR_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX7_BUSERRINTR_SHIFT))

//====================================================================
//Register: DMA Channel Control/Status Registers 0-15 (Instance 9 of 16) (DMA_CSRx8)
/** \brief These read/write registers contain the control and status bits for the channels.
<br>
Ignore reads from reserved bits. Write 0x0 to reserved bits.
<br>
Address offsets:
<br>
DMA Channel 0 Register = 0x0000
<br>
DMA Channel 1 Register = 0x0004
<br>
DMA Channel 2 Register = 0x0008
<br>
DMA Channel 3 Register = 0x000C
<br>
DMA Channel 4 Register = 0x0010
<br>
DMA Channel 5 Register = 0x0014
<br>
DMA Channel 6 Register = 0x0018
<br>
DMA Channel 7 Register = 0x001C
<br>
DMA Channel 8 Register = 0x0020
<br>
DMA Channel 9 Register = 0x0024
<br>
DMA Channel 10 Register = 0x0028
<br>
DMA Channel 11 Register = 0x002C
<br>
DMA Channel 12 Register = 0x0030
<br>
DMA Channel 13 Register = 0x0034
<br>
DMA Channel 14 Register = 0x0038
<br>
DMA Channel 15 Register = 0x003C
<br> (Instance 9 of 16)*/
//====================================================================

#define  PDMA_DMA_CSRX8_RUN_MASK 0x80000000
#define  PDMA_DMA_CSRX8_RUN_SHIFT 31
#define  PDMA_DMA_CSRX8_RUN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX8_RUN_MASK) >> PDMA_DMA_CSRX8_RUN_SHIFT)
#define  PDMA_DMA_CSRX8_RUN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX8_RUN_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX8_RUN_SHIFT))

#define  PDMA_DMA_CSRX8_NODESCFETCH_MASK 0x40000000
#define  PDMA_DMA_CSRX8_NODESCFETCH_SHIFT 30
#define  PDMA_DMA_CSRX8_NODESCFETCH_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX8_NODESCFETCH_MASK) >> PDMA_DMA_CSRX8_NODESCFETCH_SHIFT)
#define  PDMA_DMA_CSRX8_NODESCFETCH_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX8_NODESCFETCH_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX8_NODESCFETCH_SHIFT))

#define  PDMA_DMA_CSRX8_STOPIRQEN_MASK 0x20000000
#define  PDMA_DMA_CSRX8_STOPIRQEN_SHIFT 29
#define  PDMA_DMA_CSRX8_STOPIRQEN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX8_STOPIRQEN_MASK) >> PDMA_DMA_CSRX8_STOPIRQEN_SHIFT)
#define  PDMA_DMA_CSRX8_STOPIRQEN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX8_STOPIRQEN_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX8_STOPIRQEN_SHIFT))

#define  PDMA_DMA_CSRX8_EORIRQEN_MASK 0x10000000
#define  PDMA_DMA_CSRX8_EORIRQEN_SHIFT 28
#define  PDMA_DMA_CSRX8_EORIRQEN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX8_EORIRQEN_MASK) >> PDMA_DMA_CSRX8_EORIRQEN_SHIFT)
#define  PDMA_DMA_CSRX8_EORIRQEN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX8_EORIRQEN_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX8_EORIRQEN_SHIFT))

#define  PDMA_DMA_CSRX8_EORJMPEN_MASK 0x8000000
#define  PDMA_DMA_CSRX8_EORJMPEN_SHIFT 27
#define  PDMA_DMA_CSRX8_EORJMPEN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX8_EORJMPEN_MASK) >> PDMA_DMA_CSRX8_EORJMPEN_SHIFT)
#define  PDMA_DMA_CSRX8_EORJMPEN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX8_EORJMPEN_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX8_EORJMPEN_SHIFT))

#define  PDMA_DMA_CSRX8_EORSTOPEN_MASK 0x4000000
#define  PDMA_DMA_CSRX8_EORSTOPEN_SHIFT 26
#define  PDMA_DMA_CSRX8_EORSTOPEN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX8_EORSTOPEN_MASK) >> PDMA_DMA_CSRX8_EORSTOPEN_SHIFT)
#define  PDMA_DMA_CSRX8_EORSTOPEN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX8_EORSTOPEN_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX8_EORSTOPEN_SHIFT))

#define  PDMA_DMA_CSRX8_SETCMPST_MASK 0x2000000
#define  PDMA_DMA_CSRX8_SETCMPST_SHIFT 25
#define  PDMA_DMA_CSRX8_SETCMPST_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX8_SETCMPST_MASK) >> PDMA_DMA_CSRX8_SETCMPST_SHIFT)
#define  PDMA_DMA_CSRX8_SETCMPST_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX8_SETCMPST_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX8_SETCMPST_SHIFT))

#define  PDMA_DMA_CSRX8_CLRCMPST_MASK 0x1000000
#define  PDMA_DMA_CSRX8_CLRCMPST_SHIFT 24
#define  PDMA_DMA_CSRX8_CLRCMPST_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX8_CLRCMPST_MASK) >> PDMA_DMA_CSRX8_CLRCMPST_SHIFT)
#define  PDMA_DMA_CSRX8_CLRCMPST_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX8_CLRCMPST_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX8_CLRCMPST_SHIFT))

#define  PDMA_DMA_CSRX8_RASIRQEN_MASK 0x800000
#define  PDMA_DMA_CSRX8_RASIRQEN_SHIFT 23
#define  PDMA_DMA_CSRX8_RASIRQEN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX8_RASIRQEN_MASK) >> PDMA_DMA_CSRX8_RASIRQEN_SHIFT)
#define  PDMA_DMA_CSRX8_RASIRQEN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX8_RASIRQEN_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX8_RASIRQEN_SHIFT))

#define  PDMA_DMA_CSRX8_MASKRUN_MASK 0x400000
#define  PDMA_DMA_CSRX8_MASKRUN_SHIFT 22
#define  PDMA_DMA_CSRX8_MASKRUN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX8_MASKRUN_MASK) >> PDMA_DMA_CSRX8_MASKRUN_SHIFT)
#define  PDMA_DMA_CSRX8_MASKRUN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX8_MASKRUN_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX8_MASKRUN_SHIFT))

#define  PDMA_DMA_CSRX8_RESERVED1_MASK 0x3ff800
#define  PDMA_DMA_CSRX8_RESERVED1_SHIFT 11
#define  PDMA_DMA_CSRX8_RESERVED1_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX8_RESERVED1_MASK) >> PDMA_DMA_CSRX8_RESERVED1_SHIFT)
#define  PDMA_DMA_CSRX8_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX8_RESERVED1_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX8_RESERVED1_SHIFT))

#define  PDMA_DMA_CSRX8_CMPST_MASK 0x400
#define  PDMA_DMA_CSRX8_CMPST_SHIFT 10
#define  PDMA_DMA_CSRX8_CMPST_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX8_CMPST_MASK) >> PDMA_DMA_CSRX8_CMPST_SHIFT)
#define  PDMA_DMA_CSRX8_CMPST_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX8_CMPST_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX8_CMPST_SHIFT))

#define  PDMA_DMA_CSRX8_EORINT_MASK 0x200
#define  PDMA_DMA_CSRX8_EORINT_SHIFT 9
#define  PDMA_DMA_CSRX8_EORINT_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX8_EORINT_MASK) >> PDMA_DMA_CSRX8_EORINT_SHIFT)
#define  PDMA_DMA_CSRX8_EORINT_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX8_EORINT_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX8_EORINT_SHIFT))

#define  PDMA_DMA_CSRX8_REQPEND_MASK 0x100
#define  PDMA_DMA_CSRX8_REQPEND_SHIFT 8
#define  PDMA_DMA_CSRX8_REQPEND_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX8_REQPEND_MASK) >> PDMA_DMA_CSRX8_REQPEND_SHIFT)
#define  PDMA_DMA_CSRX8_REQPEND_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX8_REQPEND_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX8_REQPEND_SHIFT))

#define  PDMA_DMA_CSRX8_RESERVED2_MASK 0xe0
#define  PDMA_DMA_CSRX8_RESERVED2_SHIFT 5
#define  PDMA_DMA_CSRX8_RESERVED2_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX8_RESERVED2_MASK) >> PDMA_DMA_CSRX8_RESERVED2_SHIFT)
#define  PDMA_DMA_CSRX8_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX8_RESERVED2_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX8_RESERVED2_SHIFT))

#define  PDMA_DMA_CSRX8_RASINTR_MASK 0x10
#define  PDMA_DMA_CSRX8_RASINTR_SHIFT 4
#define  PDMA_DMA_CSRX8_RASINTR_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX8_RASINTR_MASK) >> PDMA_DMA_CSRX8_RASINTR_SHIFT)
#define  PDMA_DMA_CSRX8_RASINTR_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX8_RASINTR_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX8_RASINTR_SHIFT))

#define  PDMA_DMA_CSRX8_STOPINTR_MASK 0x8
#define  PDMA_DMA_CSRX8_STOPINTR_SHIFT 3
#define  PDMA_DMA_CSRX8_STOPINTR_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX8_STOPINTR_MASK) >> PDMA_DMA_CSRX8_STOPINTR_SHIFT)
#define  PDMA_DMA_CSRX8_STOPINTR_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX8_STOPINTR_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX8_STOPINTR_SHIFT))

#define  PDMA_DMA_CSRX8_ENDINTR_MASK 0x4
#define  PDMA_DMA_CSRX8_ENDINTR_SHIFT 2
#define  PDMA_DMA_CSRX8_ENDINTR_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX8_ENDINTR_MASK) >> PDMA_DMA_CSRX8_ENDINTR_SHIFT)
#define  PDMA_DMA_CSRX8_ENDINTR_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX8_ENDINTR_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX8_ENDINTR_SHIFT))

#define  PDMA_DMA_CSRX8_STARTINTR_MASK 0x2
#define  PDMA_DMA_CSRX8_STARTINTR_SHIFT 1
#define  PDMA_DMA_CSRX8_STARTINTR_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX8_STARTINTR_MASK) >> PDMA_DMA_CSRX8_STARTINTR_SHIFT)
#define  PDMA_DMA_CSRX8_STARTINTR_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX8_STARTINTR_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX8_STARTINTR_SHIFT))

#define  PDMA_DMA_CSRX8_BUSERRINTR_MASK 0x1
#define  PDMA_DMA_CSRX8_BUSERRINTR_SHIFT 0
#define  PDMA_DMA_CSRX8_BUSERRINTR_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX8_BUSERRINTR_MASK) >> PDMA_DMA_CSRX8_BUSERRINTR_SHIFT)
#define  PDMA_DMA_CSRX8_BUSERRINTR_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX8_BUSERRINTR_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX8_BUSERRINTR_SHIFT))

//====================================================================
//Register: DMA Channel Control/Status Registers 0-15 (Instance 10 of 16) (DMA_CSRx9)
/** \brief These read/write registers contain the control and status bits for the channels.
<br>
Ignore reads from reserved bits. Write 0x0 to reserved bits.
<br>
Address offsets:
<br>
DMA Channel 0 Register = 0x0000
<br>
DMA Channel 1 Register = 0x0004
<br>
DMA Channel 2 Register = 0x0008
<br>
DMA Channel 3 Register = 0x000C
<br>
DMA Channel 4 Register = 0x0010
<br>
DMA Channel 5 Register = 0x0014
<br>
DMA Channel 6 Register = 0x0018
<br>
DMA Channel 7 Register = 0x001C
<br>
DMA Channel 8 Register = 0x0020
<br>
DMA Channel 9 Register = 0x0024
<br>
DMA Channel 10 Register = 0x0028
<br>
DMA Channel 11 Register = 0x002C
<br>
DMA Channel 12 Register = 0x0030
<br>
DMA Channel 13 Register = 0x0034
<br>
DMA Channel 14 Register = 0x0038
<br>
DMA Channel 15 Register = 0x003C
<br> (Instance 10 of 16)*/
//====================================================================

#define  PDMA_DMA_CSRX9_RUN_MASK 0x80000000
#define  PDMA_DMA_CSRX9_RUN_SHIFT 31
#define  PDMA_DMA_CSRX9_RUN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX9_RUN_MASK) >> PDMA_DMA_CSRX9_RUN_SHIFT)
#define  PDMA_DMA_CSRX9_RUN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX9_RUN_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX9_RUN_SHIFT))

#define  PDMA_DMA_CSRX9_NODESCFETCH_MASK 0x40000000
#define  PDMA_DMA_CSRX9_NODESCFETCH_SHIFT 30
#define  PDMA_DMA_CSRX9_NODESCFETCH_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX9_NODESCFETCH_MASK) >> PDMA_DMA_CSRX9_NODESCFETCH_SHIFT)
#define  PDMA_DMA_CSRX9_NODESCFETCH_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX9_NODESCFETCH_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX9_NODESCFETCH_SHIFT))

#define  PDMA_DMA_CSRX9_STOPIRQEN_MASK 0x20000000
#define  PDMA_DMA_CSRX9_STOPIRQEN_SHIFT 29
#define  PDMA_DMA_CSRX9_STOPIRQEN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX9_STOPIRQEN_MASK) >> PDMA_DMA_CSRX9_STOPIRQEN_SHIFT)
#define  PDMA_DMA_CSRX9_STOPIRQEN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX9_STOPIRQEN_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX9_STOPIRQEN_SHIFT))

#define  PDMA_DMA_CSRX9_EORIRQEN_MASK 0x10000000
#define  PDMA_DMA_CSRX9_EORIRQEN_SHIFT 28
#define  PDMA_DMA_CSRX9_EORIRQEN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX9_EORIRQEN_MASK) >> PDMA_DMA_CSRX9_EORIRQEN_SHIFT)
#define  PDMA_DMA_CSRX9_EORIRQEN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX9_EORIRQEN_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX9_EORIRQEN_SHIFT))

#define  PDMA_DMA_CSRX9_EORJMPEN_MASK 0x8000000
#define  PDMA_DMA_CSRX9_EORJMPEN_SHIFT 27
#define  PDMA_DMA_CSRX9_EORJMPEN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX9_EORJMPEN_MASK) >> PDMA_DMA_CSRX9_EORJMPEN_SHIFT)
#define  PDMA_DMA_CSRX9_EORJMPEN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX9_EORJMPEN_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX9_EORJMPEN_SHIFT))

#define  PDMA_DMA_CSRX9_EORSTOPEN_MASK 0x4000000
#define  PDMA_DMA_CSRX9_EORSTOPEN_SHIFT 26
#define  PDMA_DMA_CSRX9_EORSTOPEN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX9_EORSTOPEN_MASK) >> PDMA_DMA_CSRX9_EORSTOPEN_SHIFT)
#define  PDMA_DMA_CSRX9_EORSTOPEN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX9_EORSTOPEN_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX9_EORSTOPEN_SHIFT))

#define  PDMA_DMA_CSRX9_SETCMPST_MASK 0x2000000
#define  PDMA_DMA_CSRX9_SETCMPST_SHIFT 25
#define  PDMA_DMA_CSRX9_SETCMPST_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX9_SETCMPST_MASK) >> PDMA_DMA_CSRX9_SETCMPST_SHIFT)
#define  PDMA_DMA_CSRX9_SETCMPST_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX9_SETCMPST_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX9_SETCMPST_SHIFT))

#define  PDMA_DMA_CSRX9_CLRCMPST_MASK 0x1000000
#define  PDMA_DMA_CSRX9_CLRCMPST_SHIFT 24
#define  PDMA_DMA_CSRX9_CLRCMPST_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX9_CLRCMPST_MASK) >> PDMA_DMA_CSRX9_CLRCMPST_SHIFT)
#define  PDMA_DMA_CSRX9_CLRCMPST_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX9_CLRCMPST_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX9_CLRCMPST_SHIFT))

#define  PDMA_DMA_CSRX9_RASIRQEN_MASK 0x800000
#define  PDMA_DMA_CSRX9_RASIRQEN_SHIFT 23
#define  PDMA_DMA_CSRX9_RASIRQEN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX9_RASIRQEN_MASK) >> PDMA_DMA_CSRX9_RASIRQEN_SHIFT)
#define  PDMA_DMA_CSRX9_RASIRQEN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX9_RASIRQEN_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX9_RASIRQEN_SHIFT))

#define  PDMA_DMA_CSRX9_MASKRUN_MASK 0x400000
#define  PDMA_DMA_CSRX9_MASKRUN_SHIFT 22
#define  PDMA_DMA_CSRX9_MASKRUN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX9_MASKRUN_MASK) >> PDMA_DMA_CSRX9_MASKRUN_SHIFT)
#define  PDMA_DMA_CSRX9_MASKRUN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX9_MASKRUN_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX9_MASKRUN_SHIFT))

#define  PDMA_DMA_CSRX9_RESERVED1_MASK 0x3ff800
#define  PDMA_DMA_CSRX9_RESERVED1_SHIFT 11
#define  PDMA_DMA_CSRX9_RESERVED1_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX9_RESERVED1_MASK) >> PDMA_DMA_CSRX9_RESERVED1_SHIFT)
#define  PDMA_DMA_CSRX9_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX9_RESERVED1_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX9_RESERVED1_SHIFT))

#define  PDMA_DMA_CSRX9_CMPST_MASK 0x400
#define  PDMA_DMA_CSRX9_CMPST_SHIFT 10
#define  PDMA_DMA_CSRX9_CMPST_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX9_CMPST_MASK) >> PDMA_DMA_CSRX9_CMPST_SHIFT)
#define  PDMA_DMA_CSRX9_CMPST_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX9_CMPST_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX9_CMPST_SHIFT))

#define  PDMA_DMA_CSRX9_EORINT_MASK 0x200
#define  PDMA_DMA_CSRX9_EORINT_SHIFT 9
#define  PDMA_DMA_CSRX9_EORINT_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX9_EORINT_MASK) >> PDMA_DMA_CSRX9_EORINT_SHIFT)
#define  PDMA_DMA_CSRX9_EORINT_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX9_EORINT_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX9_EORINT_SHIFT))

#define  PDMA_DMA_CSRX9_REQPEND_MASK 0x100
#define  PDMA_DMA_CSRX9_REQPEND_SHIFT 8
#define  PDMA_DMA_CSRX9_REQPEND_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX9_REQPEND_MASK) >> PDMA_DMA_CSRX9_REQPEND_SHIFT)
#define  PDMA_DMA_CSRX9_REQPEND_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX9_REQPEND_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX9_REQPEND_SHIFT))

#define  PDMA_DMA_CSRX9_RESERVED2_MASK 0xe0
#define  PDMA_DMA_CSRX9_RESERVED2_SHIFT 5
#define  PDMA_DMA_CSRX9_RESERVED2_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX9_RESERVED2_MASK) >> PDMA_DMA_CSRX9_RESERVED2_SHIFT)
#define  PDMA_DMA_CSRX9_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX9_RESERVED2_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX9_RESERVED2_SHIFT))

#define  PDMA_DMA_CSRX9_RASINTR_MASK 0x10
#define  PDMA_DMA_CSRX9_RASINTR_SHIFT 4
#define  PDMA_DMA_CSRX9_RASINTR_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX9_RASINTR_MASK) >> PDMA_DMA_CSRX9_RASINTR_SHIFT)
#define  PDMA_DMA_CSRX9_RASINTR_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX9_RASINTR_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX9_RASINTR_SHIFT))

#define  PDMA_DMA_CSRX9_STOPINTR_MASK 0x8
#define  PDMA_DMA_CSRX9_STOPINTR_SHIFT 3
#define  PDMA_DMA_CSRX9_STOPINTR_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX9_STOPINTR_MASK) >> PDMA_DMA_CSRX9_STOPINTR_SHIFT)
#define  PDMA_DMA_CSRX9_STOPINTR_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX9_STOPINTR_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX9_STOPINTR_SHIFT))

#define  PDMA_DMA_CSRX9_ENDINTR_MASK 0x4
#define  PDMA_DMA_CSRX9_ENDINTR_SHIFT 2
#define  PDMA_DMA_CSRX9_ENDINTR_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX9_ENDINTR_MASK) >> PDMA_DMA_CSRX9_ENDINTR_SHIFT)
#define  PDMA_DMA_CSRX9_ENDINTR_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX9_ENDINTR_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX9_ENDINTR_SHIFT))

#define  PDMA_DMA_CSRX9_STARTINTR_MASK 0x2
#define  PDMA_DMA_CSRX9_STARTINTR_SHIFT 1
#define  PDMA_DMA_CSRX9_STARTINTR_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX9_STARTINTR_MASK) >> PDMA_DMA_CSRX9_STARTINTR_SHIFT)
#define  PDMA_DMA_CSRX9_STARTINTR_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX9_STARTINTR_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX9_STARTINTR_SHIFT))

#define  PDMA_DMA_CSRX9_BUSERRINTR_MASK 0x1
#define  PDMA_DMA_CSRX9_BUSERRINTR_SHIFT 0
#define  PDMA_DMA_CSRX9_BUSERRINTR_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX9_BUSERRINTR_MASK) >> PDMA_DMA_CSRX9_BUSERRINTR_SHIFT)
#define  PDMA_DMA_CSRX9_BUSERRINTR_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX9_BUSERRINTR_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX9_BUSERRINTR_SHIFT))

//====================================================================
//Register: DMA Channel Control/Status Registers 0-15 (Instance 11 of 16) (DMA_CSRx10)
/** \brief These read/write registers contain the control and status bits for the channels.
<br>
Ignore reads from reserved bits. Write 0x0 to reserved bits.
<br>
Address offsets:
<br>
DMA Channel 0 Register = 0x0000
<br>
DMA Channel 1 Register = 0x0004
<br>
DMA Channel 2 Register = 0x0008
<br>
DMA Channel 3 Register = 0x000C
<br>
DMA Channel 4 Register = 0x0010
<br>
DMA Channel 5 Register = 0x0014
<br>
DMA Channel 6 Register = 0x0018
<br>
DMA Channel 7 Register = 0x001C
<br>
DMA Channel 8 Register = 0x0020
<br>
DMA Channel 9 Register = 0x0024
<br>
DMA Channel 10 Register = 0x0028
<br>
DMA Channel 11 Register = 0x002C
<br>
DMA Channel 12 Register = 0x0030
<br>
DMA Channel 13 Register = 0x0034
<br>
DMA Channel 14 Register = 0x0038
<br>
DMA Channel 15 Register = 0x003C
<br> (Instance 11 of 16)*/
//====================================================================

#define  PDMA_DMA_CSRX10_RUN_MASK 0x80000000
#define  PDMA_DMA_CSRX10_RUN_SHIFT 31
#define  PDMA_DMA_CSRX10_RUN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX10_RUN_MASK) >> PDMA_DMA_CSRX10_RUN_SHIFT)
#define  PDMA_DMA_CSRX10_RUN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX10_RUN_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX10_RUN_SHIFT))

#define  PDMA_DMA_CSRX10_NODESCFETCH_MASK 0x40000000
#define  PDMA_DMA_CSRX10_NODESCFETCH_SHIFT 30
#define  PDMA_DMA_CSRX10_NODESCFETCH_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX10_NODESCFETCH_MASK) >> PDMA_DMA_CSRX10_NODESCFETCH_SHIFT)
#define  PDMA_DMA_CSRX10_NODESCFETCH_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX10_NODESCFETCH_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX10_NODESCFETCH_SHIFT))

#define  PDMA_DMA_CSRX10_STOPIRQEN_MASK 0x20000000
#define  PDMA_DMA_CSRX10_STOPIRQEN_SHIFT 29
#define  PDMA_DMA_CSRX10_STOPIRQEN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX10_STOPIRQEN_MASK) >> PDMA_DMA_CSRX10_STOPIRQEN_SHIFT)
#define  PDMA_DMA_CSRX10_STOPIRQEN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX10_STOPIRQEN_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX10_STOPIRQEN_SHIFT))

#define  PDMA_DMA_CSRX10_EORIRQEN_MASK 0x10000000
#define  PDMA_DMA_CSRX10_EORIRQEN_SHIFT 28
#define  PDMA_DMA_CSRX10_EORIRQEN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX10_EORIRQEN_MASK) >> PDMA_DMA_CSRX10_EORIRQEN_SHIFT)
#define  PDMA_DMA_CSRX10_EORIRQEN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX10_EORIRQEN_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX10_EORIRQEN_SHIFT))

#define  PDMA_DMA_CSRX10_EORJMPEN_MASK 0x8000000
#define  PDMA_DMA_CSRX10_EORJMPEN_SHIFT 27
#define  PDMA_DMA_CSRX10_EORJMPEN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX10_EORJMPEN_MASK) >> PDMA_DMA_CSRX10_EORJMPEN_SHIFT)
#define  PDMA_DMA_CSRX10_EORJMPEN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX10_EORJMPEN_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX10_EORJMPEN_SHIFT))

#define  PDMA_DMA_CSRX10_EORSTOPEN_MASK 0x4000000
#define  PDMA_DMA_CSRX10_EORSTOPEN_SHIFT 26
#define  PDMA_DMA_CSRX10_EORSTOPEN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX10_EORSTOPEN_MASK) >> PDMA_DMA_CSRX10_EORSTOPEN_SHIFT)
#define  PDMA_DMA_CSRX10_EORSTOPEN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX10_EORSTOPEN_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX10_EORSTOPEN_SHIFT))

#define  PDMA_DMA_CSRX10_SETCMPST_MASK 0x2000000
#define  PDMA_DMA_CSRX10_SETCMPST_SHIFT 25
#define  PDMA_DMA_CSRX10_SETCMPST_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX10_SETCMPST_MASK) >> PDMA_DMA_CSRX10_SETCMPST_SHIFT)
#define  PDMA_DMA_CSRX10_SETCMPST_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX10_SETCMPST_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX10_SETCMPST_SHIFT))

#define  PDMA_DMA_CSRX10_CLRCMPST_MASK 0x1000000
#define  PDMA_DMA_CSRX10_CLRCMPST_SHIFT 24
#define  PDMA_DMA_CSRX10_CLRCMPST_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX10_CLRCMPST_MASK) >> PDMA_DMA_CSRX10_CLRCMPST_SHIFT)
#define  PDMA_DMA_CSRX10_CLRCMPST_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX10_CLRCMPST_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX10_CLRCMPST_SHIFT))

#define  PDMA_DMA_CSRX10_RASIRQEN_MASK 0x800000
#define  PDMA_DMA_CSRX10_RASIRQEN_SHIFT 23
#define  PDMA_DMA_CSRX10_RASIRQEN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX10_RASIRQEN_MASK) >> PDMA_DMA_CSRX10_RASIRQEN_SHIFT)
#define  PDMA_DMA_CSRX10_RASIRQEN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX10_RASIRQEN_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX10_RASIRQEN_SHIFT))

#define  PDMA_DMA_CSRX10_MASKRUN_MASK 0x400000
#define  PDMA_DMA_CSRX10_MASKRUN_SHIFT 22
#define  PDMA_DMA_CSRX10_MASKRUN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX10_MASKRUN_MASK) >> PDMA_DMA_CSRX10_MASKRUN_SHIFT)
#define  PDMA_DMA_CSRX10_MASKRUN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX10_MASKRUN_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX10_MASKRUN_SHIFT))

#define  PDMA_DMA_CSRX10_RESERVED1_MASK 0x3ff800
#define  PDMA_DMA_CSRX10_RESERVED1_SHIFT 11
#define  PDMA_DMA_CSRX10_RESERVED1_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX10_RESERVED1_MASK) >> PDMA_DMA_CSRX10_RESERVED1_SHIFT)
#define  PDMA_DMA_CSRX10_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX10_RESERVED1_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX10_RESERVED1_SHIFT))

#define  PDMA_DMA_CSRX10_CMPST_MASK 0x400
#define  PDMA_DMA_CSRX10_CMPST_SHIFT 10
#define  PDMA_DMA_CSRX10_CMPST_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX10_CMPST_MASK) >> PDMA_DMA_CSRX10_CMPST_SHIFT)
#define  PDMA_DMA_CSRX10_CMPST_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX10_CMPST_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX10_CMPST_SHIFT))

#define  PDMA_DMA_CSRX10_EORINT_MASK 0x200
#define  PDMA_DMA_CSRX10_EORINT_SHIFT 9
#define  PDMA_DMA_CSRX10_EORINT_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX10_EORINT_MASK) >> PDMA_DMA_CSRX10_EORINT_SHIFT)
#define  PDMA_DMA_CSRX10_EORINT_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX10_EORINT_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX10_EORINT_SHIFT))

#define  PDMA_DMA_CSRX10_REQPEND_MASK 0x100
#define  PDMA_DMA_CSRX10_REQPEND_SHIFT 8
#define  PDMA_DMA_CSRX10_REQPEND_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX10_REQPEND_MASK) >> PDMA_DMA_CSRX10_REQPEND_SHIFT)
#define  PDMA_DMA_CSRX10_REQPEND_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX10_REQPEND_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX10_REQPEND_SHIFT))

#define  PDMA_DMA_CSRX10_RESERVED2_MASK 0xe0
#define  PDMA_DMA_CSRX10_RESERVED2_SHIFT 5
#define  PDMA_DMA_CSRX10_RESERVED2_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX10_RESERVED2_MASK) >> PDMA_DMA_CSRX10_RESERVED2_SHIFT)
#define  PDMA_DMA_CSRX10_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX10_RESERVED2_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX10_RESERVED2_SHIFT))

#define  PDMA_DMA_CSRX10_RASINTR_MASK 0x10
#define  PDMA_DMA_CSRX10_RASINTR_SHIFT 4
#define  PDMA_DMA_CSRX10_RASINTR_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX10_RASINTR_MASK) >> PDMA_DMA_CSRX10_RASINTR_SHIFT)
#define  PDMA_DMA_CSRX10_RASINTR_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX10_RASINTR_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX10_RASINTR_SHIFT))

#define  PDMA_DMA_CSRX10_STOPINTR_MASK 0x8
#define  PDMA_DMA_CSRX10_STOPINTR_SHIFT 3
#define  PDMA_DMA_CSRX10_STOPINTR_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX10_STOPINTR_MASK) >> PDMA_DMA_CSRX10_STOPINTR_SHIFT)
#define  PDMA_DMA_CSRX10_STOPINTR_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX10_STOPINTR_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX10_STOPINTR_SHIFT))

#define  PDMA_DMA_CSRX10_ENDINTR_MASK 0x4
#define  PDMA_DMA_CSRX10_ENDINTR_SHIFT 2
#define  PDMA_DMA_CSRX10_ENDINTR_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX10_ENDINTR_MASK) >> PDMA_DMA_CSRX10_ENDINTR_SHIFT)
#define  PDMA_DMA_CSRX10_ENDINTR_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX10_ENDINTR_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX10_ENDINTR_SHIFT))

#define  PDMA_DMA_CSRX10_STARTINTR_MASK 0x2
#define  PDMA_DMA_CSRX10_STARTINTR_SHIFT 1
#define  PDMA_DMA_CSRX10_STARTINTR_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX10_STARTINTR_MASK) >> PDMA_DMA_CSRX10_STARTINTR_SHIFT)
#define  PDMA_DMA_CSRX10_STARTINTR_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX10_STARTINTR_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX10_STARTINTR_SHIFT))

#define  PDMA_DMA_CSRX10_BUSERRINTR_MASK 0x1
#define  PDMA_DMA_CSRX10_BUSERRINTR_SHIFT 0
#define  PDMA_DMA_CSRX10_BUSERRINTR_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX10_BUSERRINTR_MASK) >> PDMA_DMA_CSRX10_BUSERRINTR_SHIFT)
#define  PDMA_DMA_CSRX10_BUSERRINTR_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX10_BUSERRINTR_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX10_BUSERRINTR_SHIFT))

//====================================================================
//Register: DMA Channel Control/Status Registers 0-15 (Instance 12 of 16) (DMA_CSRx11)
/** \brief These read/write registers contain the control and status bits for the channels.
<br>
Ignore reads from reserved bits. Write 0x0 to reserved bits.
<br>
Address offsets:
<br>
DMA Channel 0 Register = 0x0000
<br>
DMA Channel 1 Register = 0x0004
<br>
DMA Channel 2 Register = 0x0008
<br>
DMA Channel 3 Register = 0x000C
<br>
DMA Channel 4 Register = 0x0010
<br>
DMA Channel 5 Register = 0x0014
<br>
DMA Channel 6 Register = 0x0018
<br>
DMA Channel 7 Register = 0x001C
<br>
DMA Channel 8 Register = 0x0020
<br>
DMA Channel 9 Register = 0x0024
<br>
DMA Channel 10 Register = 0x0028
<br>
DMA Channel 11 Register = 0x002C
<br>
DMA Channel 12 Register = 0x0030
<br>
DMA Channel 13 Register = 0x0034
<br>
DMA Channel 14 Register = 0x0038
<br>
DMA Channel 15 Register = 0x003C
<br> (Instance 12 of 16)*/
//====================================================================

#define  PDMA_DMA_CSRX11_RUN_MASK 0x80000000
#define  PDMA_DMA_CSRX11_RUN_SHIFT 31
#define  PDMA_DMA_CSRX11_RUN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX11_RUN_MASK) >> PDMA_DMA_CSRX11_RUN_SHIFT)
#define  PDMA_DMA_CSRX11_RUN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX11_RUN_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX11_RUN_SHIFT))

#define  PDMA_DMA_CSRX11_NODESCFETCH_MASK 0x40000000
#define  PDMA_DMA_CSRX11_NODESCFETCH_SHIFT 30
#define  PDMA_DMA_CSRX11_NODESCFETCH_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX11_NODESCFETCH_MASK) >> PDMA_DMA_CSRX11_NODESCFETCH_SHIFT)
#define  PDMA_DMA_CSRX11_NODESCFETCH_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX11_NODESCFETCH_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX11_NODESCFETCH_SHIFT))

#define  PDMA_DMA_CSRX11_STOPIRQEN_MASK 0x20000000
#define  PDMA_DMA_CSRX11_STOPIRQEN_SHIFT 29
#define  PDMA_DMA_CSRX11_STOPIRQEN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX11_STOPIRQEN_MASK) >> PDMA_DMA_CSRX11_STOPIRQEN_SHIFT)
#define  PDMA_DMA_CSRX11_STOPIRQEN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX11_STOPIRQEN_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX11_STOPIRQEN_SHIFT))

#define  PDMA_DMA_CSRX11_EORIRQEN_MASK 0x10000000
#define  PDMA_DMA_CSRX11_EORIRQEN_SHIFT 28
#define  PDMA_DMA_CSRX11_EORIRQEN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX11_EORIRQEN_MASK) >> PDMA_DMA_CSRX11_EORIRQEN_SHIFT)
#define  PDMA_DMA_CSRX11_EORIRQEN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX11_EORIRQEN_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX11_EORIRQEN_SHIFT))

#define  PDMA_DMA_CSRX11_EORJMPEN_MASK 0x8000000
#define  PDMA_DMA_CSRX11_EORJMPEN_SHIFT 27
#define  PDMA_DMA_CSRX11_EORJMPEN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX11_EORJMPEN_MASK) >> PDMA_DMA_CSRX11_EORJMPEN_SHIFT)
#define  PDMA_DMA_CSRX11_EORJMPEN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX11_EORJMPEN_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX11_EORJMPEN_SHIFT))

#define  PDMA_DMA_CSRX11_EORSTOPEN_MASK 0x4000000
#define  PDMA_DMA_CSRX11_EORSTOPEN_SHIFT 26
#define  PDMA_DMA_CSRX11_EORSTOPEN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX11_EORSTOPEN_MASK) >> PDMA_DMA_CSRX11_EORSTOPEN_SHIFT)
#define  PDMA_DMA_CSRX11_EORSTOPEN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX11_EORSTOPEN_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX11_EORSTOPEN_SHIFT))

#define  PDMA_DMA_CSRX11_SETCMPST_MASK 0x2000000
#define  PDMA_DMA_CSRX11_SETCMPST_SHIFT 25
#define  PDMA_DMA_CSRX11_SETCMPST_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX11_SETCMPST_MASK) >> PDMA_DMA_CSRX11_SETCMPST_SHIFT)
#define  PDMA_DMA_CSRX11_SETCMPST_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX11_SETCMPST_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX11_SETCMPST_SHIFT))

#define  PDMA_DMA_CSRX11_CLRCMPST_MASK 0x1000000
#define  PDMA_DMA_CSRX11_CLRCMPST_SHIFT 24
#define  PDMA_DMA_CSRX11_CLRCMPST_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX11_CLRCMPST_MASK) >> PDMA_DMA_CSRX11_CLRCMPST_SHIFT)
#define  PDMA_DMA_CSRX11_CLRCMPST_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX11_CLRCMPST_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX11_CLRCMPST_SHIFT))

#define  PDMA_DMA_CSRX11_RASIRQEN_MASK 0x800000
#define  PDMA_DMA_CSRX11_RASIRQEN_SHIFT 23
#define  PDMA_DMA_CSRX11_RASIRQEN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX11_RASIRQEN_MASK) >> PDMA_DMA_CSRX11_RASIRQEN_SHIFT)
#define  PDMA_DMA_CSRX11_RASIRQEN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX11_RASIRQEN_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX11_RASIRQEN_SHIFT))

#define  PDMA_DMA_CSRX11_MASKRUN_MASK 0x400000
#define  PDMA_DMA_CSRX11_MASKRUN_SHIFT 22
#define  PDMA_DMA_CSRX11_MASKRUN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX11_MASKRUN_MASK) >> PDMA_DMA_CSRX11_MASKRUN_SHIFT)
#define  PDMA_DMA_CSRX11_MASKRUN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX11_MASKRUN_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX11_MASKRUN_SHIFT))

#define  PDMA_DMA_CSRX11_RESERVED1_MASK 0x3ff800
#define  PDMA_DMA_CSRX11_RESERVED1_SHIFT 11
#define  PDMA_DMA_CSRX11_RESERVED1_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX11_RESERVED1_MASK) >> PDMA_DMA_CSRX11_RESERVED1_SHIFT)
#define  PDMA_DMA_CSRX11_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX11_RESERVED1_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX11_RESERVED1_SHIFT))

#define  PDMA_DMA_CSRX11_CMPST_MASK 0x400
#define  PDMA_DMA_CSRX11_CMPST_SHIFT 10
#define  PDMA_DMA_CSRX11_CMPST_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX11_CMPST_MASK) >> PDMA_DMA_CSRX11_CMPST_SHIFT)
#define  PDMA_DMA_CSRX11_CMPST_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX11_CMPST_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX11_CMPST_SHIFT))

#define  PDMA_DMA_CSRX11_EORINT_MASK 0x200
#define  PDMA_DMA_CSRX11_EORINT_SHIFT 9
#define  PDMA_DMA_CSRX11_EORINT_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX11_EORINT_MASK) >> PDMA_DMA_CSRX11_EORINT_SHIFT)
#define  PDMA_DMA_CSRX11_EORINT_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX11_EORINT_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX11_EORINT_SHIFT))

#define  PDMA_DMA_CSRX11_REQPEND_MASK 0x100
#define  PDMA_DMA_CSRX11_REQPEND_SHIFT 8
#define  PDMA_DMA_CSRX11_REQPEND_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX11_REQPEND_MASK) >> PDMA_DMA_CSRX11_REQPEND_SHIFT)
#define  PDMA_DMA_CSRX11_REQPEND_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX11_REQPEND_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX11_REQPEND_SHIFT))

#define  PDMA_DMA_CSRX11_RESERVED2_MASK 0xe0
#define  PDMA_DMA_CSRX11_RESERVED2_SHIFT 5
#define  PDMA_DMA_CSRX11_RESERVED2_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX11_RESERVED2_MASK) >> PDMA_DMA_CSRX11_RESERVED2_SHIFT)
#define  PDMA_DMA_CSRX11_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX11_RESERVED2_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX11_RESERVED2_SHIFT))

#define  PDMA_DMA_CSRX11_RASINTR_MASK 0x10
#define  PDMA_DMA_CSRX11_RASINTR_SHIFT 4
#define  PDMA_DMA_CSRX11_RASINTR_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX11_RASINTR_MASK) >> PDMA_DMA_CSRX11_RASINTR_SHIFT)
#define  PDMA_DMA_CSRX11_RASINTR_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX11_RASINTR_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX11_RASINTR_SHIFT))

#define  PDMA_DMA_CSRX11_STOPINTR_MASK 0x8
#define  PDMA_DMA_CSRX11_STOPINTR_SHIFT 3
#define  PDMA_DMA_CSRX11_STOPINTR_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX11_STOPINTR_MASK) >> PDMA_DMA_CSRX11_STOPINTR_SHIFT)
#define  PDMA_DMA_CSRX11_STOPINTR_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX11_STOPINTR_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX11_STOPINTR_SHIFT))

#define  PDMA_DMA_CSRX11_ENDINTR_MASK 0x4
#define  PDMA_DMA_CSRX11_ENDINTR_SHIFT 2
#define  PDMA_DMA_CSRX11_ENDINTR_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX11_ENDINTR_MASK) >> PDMA_DMA_CSRX11_ENDINTR_SHIFT)
#define  PDMA_DMA_CSRX11_ENDINTR_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX11_ENDINTR_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX11_ENDINTR_SHIFT))

#define  PDMA_DMA_CSRX11_STARTINTR_MASK 0x2
#define  PDMA_DMA_CSRX11_STARTINTR_SHIFT 1
#define  PDMA_DMA_CSRX11_STARTINTR_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX11_STARTINTR_MASK) >> PDMA_DMA_CSRX11_STARTINTR_SHIFT)
#define  PDMA_DMA_CSRX11_STARTINTR_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX11_STARTINTR_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX11_STARTINTR_SHIFT))

#define  PDMA_DMA_CSRX11_BUSERRINTR_MASK 0x1
#define  PDMA_DMA_CSRX11_BUSERRINTR_SHIFT 0
#define  PDMA_DMA_CSRX11_BUSERRINTR_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX11_BUSERRINTR_MASK) >> PDMA_DMA_CSRX11_BUSERRINTR_SHIFT)
#define  PDMA_DMA_CSRX11_BUSERRINTR_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX11_BUSERRINTR_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX11_BUSERRINTR_SHIFT))

//====================================================================
//Register: DMA Channel Control/Status Registers 0-15 (Instance 13 of 16) (DMA_CSRx12)
/** \brief These read/write registers contain the control and status bits for the channels.
<br>
Ignore reads from reserved bits. Write 0x0 to reserved bits.
<br>
Address offsets:
<br>
DMA Channel 0 Register = 0x0000
<br>
DMA Channel 1 Register = 0x0004
<br>
DMA Channel 2 Register = 0x0008
<br>
DMA Channel 3 Register = 0x000C
<br>
DMA Channel 4 Register = 0x0010
<br>
DMA Channel 5 Register = 0x0014
<br>
DMA Channel 6 Register = 0x0018
<br>
DMA Channel 7 Register = 0x001C
<br>
DMA Channel 8 Register = 0x0020
<br>
DMA Channel 9 Register = 0x0024
<br>
DMA Channel 10 Register = 0x0028
<br>
DMA Channel 11 Register = 0x002C
<br>
DMA Channel 12 Register = 0x0030
<br>
DMA Channel 13 Register = 0x0034
<br>
DMA Channel 14 Register = 0x0038
<br>
DMA Channel 15 Register = 0x003C
<br> (Instance 13 of 16)*/
//====================================================================

#define  PDMA_DMA_CSRX12_RUN_MASK 0x80000000
#define  PDMA_DMA_CSRX12_RUN_SHIFT 31
#define  PDMA_DMA_CSRX12_RUN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX12_RUN_MASK) >> PDMA_DMA_CSRX12_RUN_SHIFT)
#define  PDMA_DMA_CSRX12_RUN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX12_RUN_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX12_RUN_SHIFT))

#define  PDMA_DMA_CSRX12_NODESCFETCH_MASK 0x40000000
#define  PDMA_DMA_CSRX12_NODESCFETCH_SHIFT 30
#define  PDMA_DMA_CSRX12_NODESCFETCH_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX12_NODESCFETCH_MASK) >> PDMA_DMA_CSRX12_NODESCFETCH_SHIFT)
#define  PDMA_DMA_CSRX12_NODESCFETCH_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX12_NODESCFETCH_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX12_NODESCFETCH_SHIFT))

#define  PDMA_DMA_CSRX12_STOPIRQEN_MASK 0x20000000
#define  PDMA_DMA_CSRX12_STOPIRQEN_SHIFT 29
#define  PDMA_DMA_CSRX12_STOPIRQEN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX12_STOPIRQEN_MASK) >> PDMA_DMA_CSRX12_STOPIRQEN_SHIFT)
#define  PDMA_DMA_CSRX12_STOPIRQEN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX12_STOPIRQEN_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX12_STOPIRQEN_SHIFT))

#define  PDMA_DMA_CSRX12_EORIRQEN_MASK 0x10000000
#define  PDMA_DMA_CSRX12_EORIRQEN_SHIFT 28
#define  PDMA_DMA_CSRX12_EORIRQEN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX12_EORIRQEN_MASK) >> PDMA_DMA_CSRX12_EORIRQEN_SHIFT)
#define  PDMA_DMA_CSRX12_EORIRQEN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX12_EORIRQEN_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX12_EORIRQEN_SHIFT))

#define  PDMA_DMA_CSRX12_EORJMPEN_MASK 0x8000000
#define  PDMA_DMA_CSRX12_EORJMPEN_SHIFT 27
#define  PDMA_DMA_CSRX12_EORJMPEN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX12_EORJMPEN_MASK) >> PDMA_DMA_CSRX12_EORJMPEN_SHIFT)
#define  PDMA_DMA_CSRX12_EORJMPEN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX12_EORJMPEN_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX12_EORJMPEN_SHIFT))

#define  PDMA_DMA_CSRX12_EORSTOPEN_MASK 0x4000000
#define  PDMA_DMA_CSRX12_EORSTOPEN_SHIFT 26
#define  PDMA_DMA_CSRX12_EORSTOPEN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX12_EORSTOPEN_MASK) >> PDMA_DMA_CSRX12_EORSTOPEN_SHIFT)
#define  PDMA_DMA_CSRX12_EORSTOPEN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX12_EORSTOPEN_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX12_EORSTOPEN_SHIFT))

#define  PDMA_DMA_CSRX12_SETCMPST_MASK 0x2000000
#define  PDMA_DMA_CSRX12_SETCMPST_SHIFT 25
#define  PDMA_DMA_CSRX12_SETCMPST_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX12_SETCMPST_MASK) >> PDMA_DMA_CSRX12_SETCMPST_SHIFT)
#define  PDMA_DMA_CSRX12_SETCMPST_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX12_SETCMPST_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX12_SETCMPST_SHIFT))

#define  PDMA_DMA_CSRX12_CLRCMPST_MASK 0x1000000
#define  PDMA_DMA_CSRX12_CLRCMPST_SHIFT 24
#define  PDMA_DMA_CSRX12_CLRCMPST_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX12_CLRCMPST_MASK) >> PDMA_DMA_CSRX12_CLRCMPST_SHIFT)
#define  PDMA_DMA_CSRX12_CLRCMPST_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX12_CLRCMPST_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX12_CLRCMPST_SHIFT))

#define  PDMA_DMA_CSRX12_RASIRQEN_MASK 0x800000
#define  PDMA_DMA_CSRX12_RASIRQEN_SHIFT 23
#define  PDMA_DMA_CSRX12_RASIRQEN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX12_RASIRQEN_MASK) >> PDMA_DMA_CSRX12_RASIRQEN_SHIFT)
#define  PDMA_DMA_CSRX12_RASIRQEN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX12_RASIRQEN_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX12_RASIRQEN_SHIFT))

#define  PDMA_DMA_CSRX12_MASKRUN_MASK 0x400000
#define  PDMA_DMA_CSRX12_MASKRUN_SHIFT 22
#define  PDMA_DMA_CSRX12_MASKRUN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX12_MASKRUN_MASK) >> PDMA_DMA_CSRX12_MASKRUN_SHIFT)
#define  PDMA_DMA_CSRX12_MASKRUN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX12_MASKRUN_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX12_MASKRUN_SHIFT))

#define  PDMA_DMA_CSRX12_RESERVED1_MASK 0x3ff800
#define  PDMA_DMA_CSRX12_RESERVED1_SHIFT 11
#define  PDMA_DMA_CSRX12_RESERVED1_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX12_RESERVED1_MASK) >> PDMA_DMA_CSRX12_RESERVED1_SHIFT)
#define  PDMA_DMA_CSRX12_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX12_RESERVED1_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX12_RESERVED1_SHIFT))

#define  PDMA_DMA_CSRX12_CMPST_MASK 0x400
#define  PDMA_DMA_CSRX12_CMPST_SHIFT 10
#define  PDMA_DMA_CSRX12_CMPST_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX12_CMPST_MASK) >> PDMA_DMA_CSRX12_CMPST_SHIFT)
#define  PDMA_DMA_CSRX12_CMPST_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX12_CMPST_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX12_CMPST_SHIFT))

#define  PDMA_DMA_CSRX12_EORINT_MASK 0x200
#define  PDMA_DMA_CSRX12_EORINT_SHIFT 9
#define  PDMA_DMA_CSRX12_EORINT_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX12_EORINT_MASK) >> PDMA_DMA_CSRX12_EORINT_SHIFT)
#define  PDMA_DMA_CSRX12_EORINT_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX12_EORINT_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX12_EORINT_SHIFT))

#define  PDMA_DMA_CSRX12_REQPEND_MASK 0x100
#define  PDMA_DMA_CSRX12_REQPEND_SHIFT 8
#define  PDMA_DMA_CSRX12_REQPEND_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX12_REQPEND_MASK) >> PDMA_DMA_CSRX12_REQPEND_SHIFT)
#define  PDMA_DMA_CSRX12_REQPEND_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX12_REQPEND_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX12_REQPEND_SHIFT))

#define  PDMA_DMA_CSRX12_RESERVED2_MASK 0xe0
#define  PDMA_DMA_CSRX12_RESERVED2_SHIFT 5
#define  PDMA_DMA_CSRX12_RESERVED2_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX12_RESERVED2_MASK) >> PDMA_DMA_CSRX12_RESERVED2_SHIFT)
#define  PDMA_DMA_CSRX12_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX12_RESERVED2_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX12_RESERVED2_SHIFT))

#define  PDMA_DMA_CSRX12_RASINTR_MASK 0x10
#define  PDMA_DMA_CSRX12_RASINTR_SHIFT 4
#define  PDMA_DMA_CSRX12_RASINTR_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX12_RASINTR_MASK) >> PDMA_DMA_CSRX12_RASINTR_SHIFT)
#define  PDMA_DMA_CSRX12_RASINTR_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX12_RASINTR_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX12_RASINTR_SHIFT))

#define  PDMA_DMA_CSRX12_STOPINTR_MASK 0x8
#define  PDMA_DMA_CSRX12_STOPINTR_SHIFT 3
#define  PDMA_DMA_CSRX12_STOPINTR_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX12_STOPINTR_MASK) >> PDMA_DMA_CSRX12_STOPINTR_SHIFT)
#define  PDMA_DMA_CSRX12_STOPINTR_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX12_STOPINTR_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX12_STOPINTR_SHIFT))

#define  PDMA_DMA_CSRX12_ENDINTR_MASK 0x4
#define  PDMA_DMA_CSRX12_ENDINTR_SHIFT 2
#define  PDMA_DMA_CSRX12_ENDINTR_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX12_ENDINTR_MASK) >> PDMA_DMA_CSRX12_ENDINTR_SHIFT)
#define  PDMA_DMA_CSRX12_ENDINTR_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX12_ENDINTR_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX12_ENDINTR_SHIFT))

#define  PDMA_DMA_CSRX12_STARTINTR_MASK 0x2
#define  PDMA_DMA_CSRX12_STARTINTR_SHIFT 1
#define  PDMA_DMA_CSRX12_STARTINTR_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX12_STARTINTR_MASK) >> PDMA_DMA_CSRX12_STARTINTR_SHIFT)
#define  PDMA_DMA_CSRX12_STARTINTR_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX12_STARTINTR_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX12_STARTINTR_SHIFT))

#define  PDMA_DMA_CSRX12_BUSERRINTR_MASK 0x1
#define  PDMA_DMA_CSRX12_BUSERRINTR_SHIFT 0
#define  PDMA_DMA_CSRX12_BUSERRINTR_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX12_BUSERRINTR_MASK) >> PDMA_DMA_CSRX12_BUSERRINTR_SHIFT)
#define  PDMA_DMA_CSRX12_BUSERRINTR_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX12_BUSERRINTR_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX12_BUSERRINTR_SHIFT))

//====================================================================
//Register: DMA Channel Control/Status Registers 0-15 (Instance 14 of 16) (DMA_CSRx13)
/** \brief These read/write registers contain the control and status bits for the channels.
<br>
Ignore reads from reserved bits. Write 0x0 to reserved bits.
<br>
Address offsets:
<br>
DMA Channel 0 Register = 0x0000
<br>
DMA Channel 1 Register = 0x0004
<br>
DMA Channel 2 Register = 0x0008
<br>
DMA Channel 3 Register = 0x000C
<br>
DMA Channel 4 Register = 0x0010
<br>
DMA Channel 5 Register = 0x0014
<br>
DMA Channel 6 Register = 0x0018
<br>
DMA Channel 7 Register = 0x001C
<br>
DMA Channel 8 Register = 0x0020
<br>
DMA Channel 9 Register = 0x0024
<br>
DMA Channel 10 Register = 0x0028
<br>
DMA Channel 11 Register = 0x002C
<br>
DMA Channel 12 Register = 0x0030
<br>
DMA Channel 13 Register = 0x0034
<br>
DMA Channel 14 Register = 0x0038
<br>
DMA Channel 15 Register = 0x003C
<br> (Instance 14 of 16)*/
//====================================================================

#define  PDMA_DMA_CSRX13_RUN_MASK 0x80000000
#define  PDMA_DMA_CSRX13_RUN_SHIFT 31
#define  PDMA_DMA_CSRX13_RUN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX13_RUN_MASK) >> PDMA_DMA_CSRX13_RUN_SHIFT)
#define  PDMA_DMA_CSRX13_RUN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX13_RUN_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX13_RUN_SHIFT))

#define  PDMA_DMA_CSRX13_NODESCFETCH_MASK 0x40000000
#define  PDMA_DMA_CSRX13_NODESCFETCH_SHIFT 30
#define  PDMA_DMA_CSRX13_NODESCFETCH_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX13_NODESCFETCH_MASK) >> PDMA_DMA_CSRX13_NODESCFETCH_SHIFT)
#define  PDMA_DMA_CSRX13_NODESCFETCH_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX13_NODESCFETCH_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX13_NODESCFETCH_SHIFT))

#define  PDMA_DMA_CSRX13_STOPIRQEN_MASK 0x20000000
#define  PDMA_DMA_CSRX13_STOPIRQEN_SHIFT 29
#define  PDMA_DMA_CSRX13_STOPIRQEN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX13_STOPIRQEN_MASK) >> PDMA_DMA_CSRX13_STOPIRQEN_SHIFT)
#define  PDMA_DMA_CSRX13_STOPIRQEN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX13_STOPIRQEN_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX13_STOPIRQEN_SHIFT))

#define  PDMA_DMA_CSRX13_EORIRQEN_MASK 0x10000000
#define  PDMA_DMA_CSRX13_EORIRQEN_SHIFT 28
#define  PDMA_DMA_CSRX13_EORIRQEN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX13_EORIRQEN_MASK) >> PDMA_DMA_CSRX13_EORIRQEN_SHIFT)
#define  PDMA_DMA_CSRX13_EORIRQEN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX13_EORIRQEN_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX13_EORIRQEN_SHIFT))

#define  PDMA_DMA_CSRX13_EORJMPEN_MASK 0x8000000
#define  PDMA_DMA_CSRX13_EORJMPEN_SHIFT 27
#define  PDMA_DMA_CSRX13_EORJMPEN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX13_EORJMPEN_MASK) >> PDMA_DMA_CSRX13_EORJMPEN_SHIFT)
#define  PDMA_DMA_CSRX13_EORJMPEN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX13_EORJMPEN_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX13_EORJMPEN_SHIFT))

#define  PDMA_DMA_CSRX13_EORSTOPEN_MASK 0x4000000
#define  PDMA_DMA_CSRX13_EORSTOPEN_SHIFT 26
#define  PDMA_DMA_CSRX13_EORSTOPEN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX13_EORSTOPEN_MASK) >> PDMA_DMA_CSRX13_EORSTOPEN_SHIFT)
#define  PDMA_DMA_CSRX13_EORSTOPEN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX13_EORSTOPEN_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX13_EORSTOPEN_SHIFT))

#define  PDMA_DMA_CSRX13_SETCMPST_MASK 0x2000000
#define  PDMA_DMA_CSRX13_SETCMPST_SHIFT 25
#define  PDMA_DMA_CSRX13_SETCMPST_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX13_SETCMPST_MASK) >> PDMA_DMA_CSRX13_SETCMPST_SHIFT)
#define  PDMA_DMA_CSRX13_SETCMPST_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX13_SETCMPST_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX13_SETCMPST_SHIFT))

#define  PDMA_DMA_CSRX13_CLRCMPST_MASK 0x1000000
#define  PDMA_DMA_CSRX13_CLRCMPST_SHIFT 24
#define  PDMA_DMA_CSRX13_CLRCMPST_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX13_CLRCMPST_MASK) >> PDMA_DMA_CSRX13_CLRCMPST_SHIFT)
#define  PDMA_DMA_CSRX13_CLRCMPST_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX13_CLRCMPST_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX13_CLRCMPST_SHIFT))

#define  PDMA_DMA_CSRX13_RASIRQEN_MASK 0x800000
#define  PDMA_DMA_CSRX13_RASIRQEN_SHIFT 23
#define  PDMA_DMA_CSRX13_RASIRQEN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX13_RASIRQEN_MASK) >> PDMA_DMA_CSRX13_RASIRQEN_SHIFT)
#define  PDMA_DMA_CSRX13_RASIRQEN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX13_RASIRQEN_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX13_RASIRQEN_SHIFT))

#define  PDMA_DMA_CSRX13_MASKRUN_MASK 0x400000
#define  PDMA_DMA_CSRX13_MASKRUN_SHIFT 22
#define  PDMA_DMA_CSRX13_MASKRUN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX13_MASKRUN_MASK) >> PDMA_DMA_CSRX13_MASKRUN_SHIFT)
#define  PDMA_DMA_CSRX13_MASKRUN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX13_MASKRUN_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX13_MASKRUN_SHIFT))

#define  PDMA_DMA_CSRX13_RESERVED1_MASK 0x3ff800
#define  PDMA_DMA_CSRX13_RESERVED1_SHIFT 11
#define  PDMA_DMA_CSRX13_RESERVED1_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX13_RESERVED1_MASK) >> PDMA_DMA_CSRX13_RESERVED1_SHIFT)
#define  PDMA_DMA_CSRX13_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX13_RESERVED1_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX13_RESERVED1_SHIFT))

#define  PDMA_DMA_CSRX13_CMPST_MASK 0x400
#define  PDMA_DMA_CSRX13_CMPST_SHIFT 10
#define  PDMA_DMA_CSRX13_CMPST_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX13_CMPST_MASK) >> PDMA_DMA_CSRX13_CMPST_SHIFT)
#define  PDMA_DMA_CSRX13_CMPST_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX13_CMPST_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX13_CMPST_SHIFT))

#define  PDMA_DMA_CSRX13_EORINT_MASK 0x200
#define  PDMA_DMA_CSRX13_EORINT_SHIFT 9
#define  PDMA_DMA_CSRX13_EORINT_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX13_EORINT_MASK) >> PDMA_DMA_CSRX13_EORINT_SHIFT)
#define  PDMA_DMA_CSRX13_EORINT_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX13_EORINT_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX13_EORINT_SHIFT))

#define  PDMA_DMA_CSRX13_REQPEND_MASK 0x100
#define  PDMA_DMA_CSRX13_REQPEND_SHIFT 8
#define  PDMA_DMA_CSRX13_REQPEND_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX13_REQPEND_MASK) >> PDMA_DMA_CSRX13_REQPEND_SHIFT)
#define  PDMA_DMA_CSRX13_REQPEND_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX13_REQPEND_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX13_REQPEND_SHIFT))

#define  PDMA_DMA_CSRX13_RESERVED2_MASK 0xe0
#define  PDMA_DMA_CSRX13_RESERVED2_SHIFT 5
#define  PDMA_DMA_CSRX13_RESERVED2_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX13_RESERVED2_MASK) >> PDMA_DMA_CSRX13_RESERVED2_SHIFT)
#define  PDMA_DMA_CSRX13_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX13_RESERVED2_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX13_RESERVED2_SHIFT))

#define  PDMA_DMA_CSRX13_RASINTR_MASK 0x10
#define  PDMA_DMA_CSRX13_RASINTR_SHIFT 4
#define  PDMA_DMA_CSRX13_RASINTR_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX13_RASINTR_MASK) >> PDMA_DMA_CSRX13_RASINTR_SHIFT)
#define  PDMA_DMA_CSRX13_RASINTR_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX13_RASINTR_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX13_RASINTR_SHIFT))

#define  PDMA_DMA_CSRX13_STOPINTR_MASK 0x8
#define  PDMA_DMA_CSRX13_STOPINTR_SHIFT 3
#define  PDMA_DMA_CSRX13_STOPINTR_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX13_STOPINTR_MASK) >> PDMA_DMA_CSRX13_STOPINTR_SHIFT)
#define  PDMA_DMA_CSRX13_STOPINTR_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX13_STOPINTR_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX13_STOPINTR_SHIFT))

#define  PDMA_DMA_CSRX13_ENDINTR_MASK 0x4
#define  PDMA_DMA_CSRX13_ENDINTR_SHIFT 2
#define  PDMA_DMA_CSRX13_ENDINTR_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX13_ENDINTR_MASK) >> PDMA_DMA_CSRX13_ENDINTR_SHIFT)
#define  PDMA_DMA_CSRX13_ENDINTR_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX13_ENDINTR_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX13_ENDINTR_SHIFT))

#define  PDMA_DMA_CSRX13_STARTINTR_MASK 0x2
#define  PDMA_DMA_CSRX13_STARTINTR_SHIFT 1
#define  PDMA_DMA_CSRX13_STARTINTR_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX13_STARTINTR_MASK) >> PDMA_DMA_CSRX13_STARTINTR_SHIFT)
#define  PDMA_DMA_CSRX13_STARTINTR_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX13_STARTINTR_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX13_STARTINTR_SHIFT))

#define  PDMA_DMA_CSRX13_BUSERRINTR_MASK 0x1
#define  PDMA_DMA_CSRX13_BUSERRINTR_SHIFT 0
#define  PDMA_DMA_CSRX13_BUSERRINTR_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX13_BUSERRINTR_MASK) >> PDMA_DMA_CSRX13_BUSERRINTR_SHIFT)
#define  PDMA_DMA_CSRX13_BUSERRINTR_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX13_BUSERRINTR_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX13_BUSERRINTR_SHIFT))

//====================================================================
//Register: DMA Channel Control/Status Registers 0-15 (Instance 15 of 16) (DMA_CSRx14)
/** \brief These read/write registers contain the control and status bits for the channels.
<br>
Ignore reads from reserved bits. Write 0x0 to reserved bits.
<br>
Address offsets:
<br>
DMA Channel 0 Register = 0x0000
<br>
DMA Channel 1 Register = 0x0004
<br>
DMA Channel 2 Register = 0x0008
<br>
DMA Channel 3 Register = 0x000C
<br>
DMA Channel 4 Register = 0x0010
<br>
DMA Channel 5 Register = 0x0014
<br>
DMA Channel 6 Register = 0x0018
<br>
DMA Channel 7 Register = 0x001C
<br>
DMA Channel 8 Register = 0x0020
<br>
DMA Channel 9 Register = 0x0024
<br>
DMA Channel 10 Register = 0x0028
<br>
DMA Channel 11 Register = 0x002C
<br>
DMA Channel 12 Register = 0x0030
<br>
DMA Channel 13 Register = 0x0034
<br>
DMA Channel 14 Register = 0x0038
<br>
DMA Channel 15 Register = 0x003C
<br> (Instance 15 of 16)*/
//====================================================================

#define  PDMA_DMA_CSRX14_RUN_MASK 0x80000000
#define  PDMA_DMA_CSRX14_RUN_SHIFT 31
#define  PDMA_DMA_CSRX14_RUN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX14_RUN_MASK) >> PDMA_DMA_CSRX14_RUN_SHIFT)
#define  PDMA_DMA_CSRX14_RUN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX14_RUN_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX14_RUN_SHIFT))

#define  PDMA_DMA_CSRX14_NODESCFETCH_MASK 0x40000000
#define  PDMA_DMA_CSRX14_NODESCFETCH_SHIFT 30
#define  PDMA_DMA_CSRX14_NODESCFETCH_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX14_NODESCFETCH_MASK) >> PDMA_DMA_CSRX14_NODESCFETCH_SHIFT)
#define  PDMA_DMA_CSRX14_NODESCFETCH_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX14_NODESCFETCH_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX14_NODESCFETCH_SHIFT))

#define  PDMA_DMA_CSRX14_STOPIRQEN_MASK 0x20000000
#define  PDMA_DMA_CSRX14_STOPIRQEN_SHIFT 29
#define  PDMA_DMA_CSRX14_STOPIRQEN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX14_STOPIRQEN_MASK) >> PDMA_DMA_CSRX14_STOPIRQEN_SHIFT)
#define  PDMA_DMA_CSRX14_STOPIRQEN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX14_STOPIRQEN_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX14_STOPIRQEN_SHIFT))

#define  PDMA_DMA_CSRX14_EORIRQEN_MASK 0x10000000
#define  PDMA_DMA_CSRX14_EORIRQEN_SHIFT 28
#define  PDMA_DMA_CSRX14_EORIRQEN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX14_EORIRQEN_MASK) >> PDMA_DMA_CSRX14_EORIRQEN_SHIFT)
#define  PDMA_DMA_CSRX14_EORIRQEN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX14_EORIRQEN_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX14_EORIRQEN_SHIFT))

#define  PDMA_DMA_CSRX14_EORJMPEN_MASK 0x8000000
#define  PDMA_DMA_CSRX14_EORJMPEN_SHIFT 27
#define  PDMA_DMA_CSRX14_EORJMPEN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX14_EORJMPEN_MASK) >> PDMA_DMA_CSRX14_EORJMPEN_SHIFT)
#define  PDMA_DMA_CSRX14_EORJMPEN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX14_EORJMPEN_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX14_EORJMPEN_SHIFT))

#define  PDMA_DMA_CSRX14_EORSTOPEN_MASK 0x4000000
#define  PDMA_DMA_CSRX14_EORSTOPEN_SHIFT 26
#define  PDMA_DMA_CSRX14_EORSTOPEN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX14_EORSTOPEN_MASK) >> PDMA_DMA_CSRX14_EORSTOPEN_SHIFT)
#define  PDMA_DMA_CSRX14_EORSTOPEN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX14_EORSTOPEN_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX14_EORSTOPEN_SHIFT))

#define  PDMA_DMA_CSRX14_SETCMPST_MASK 0x2000000
#define  PDMA_DMA_CSRX14_SETCMPST_SHIFT 25
#define  PDMA_DMA_CSRX14_SETCMPST_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX14_SETCMPST_MASK) >> PDMA_DMA_CSRX14_SETCMPST_SHIFT)
#define  PDMA_DMA_CSRX14_SETCMPST_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX14_SETCMPST_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX14_SETCMPST_SHIFT))

#define  PDMA_DMA_CSRX14_CLRCMPST_MASK 0x1000000
#define  PDMA_DMA_CSRX14_CLRCMPST_SHIFT 24
#define  PDMA_DMA_CSRX14_CLRCMPST_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX14_CLRCMPST_MASK) >> PDMA_DMA_CSRX14_CLRCMPST_SHIFT)
#define  PDMA_DMA_CSRX14_CLRCMPST_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX14_CLRCMPST_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX14_CLRCMPST_SHIFT))

#define  PDMA_DMA_CSRX14_RASIRQEN_MASK 0x800000
#define  PDMA_DMA_CSRX14_RASIRQEN_SHIFT 23
#define  PDMA_DMA_CSRX14_RASIRQEN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX14_RASIRQEN_MASK) >> PDMA_DMA_CSRX14_RASIRQEN_SHIFT)
#define  PDMA_DMA_CSRX14_RASIRQEN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX14_RASIRQEN_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX14_RASIRQEN_SHIFT))

#define  PDMA_DMA_CSRX14_MASKRUN_MASK 0x400000
#define  PDMA_DMA_CSRX14_MASKRUN_SHIFT 22
#define  PDMA_DMA_CSRX14_MASKRUN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX14_MASKRUN_MASK) >> PDMA_DMA_CSRX14_MASKRUN_SHIFT)
#define  PDMA_DMA_CSRX14_MASKRUN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX14_MASKRUN_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX14_MASKRUN_SHIFT))

#define  PDMA_DMA_CSRX14_RESERVED1_MASK 0x3ff800
#define  PDMA_DMA_CSRX14_RESERVED1_SHIFT 11
#define  PDMA_DMA_CSRX14_RESERVED1_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX14_RESERVED1_MASK) >> PDMA_DMA_CSRX14_RESERVED1_SHIFT)
#define  PDMA_DMA_CSRX14_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX14_RESERVED1_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX14_RESERVED1_SHIFT))

#define  PDMA_DMA_CSRX14_CMPST_MASK 0x400
#define  PDMA_DMA_CSRX14_CMPST_SHIFT 10
#define  PDMA_DMA_CSRX14_CMPST_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX14_CMPST_MASK) >> PDMA_DMA_CSRX14_CMPST_SHIFT)
#define  PDMA_DMA_CSRX14_CMPST_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX14_CMPST_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX14_CMPST_SHIFT))

#define  PDMA_DMA_CSRX14_EORINT_MASK 0x200
#define  PDMA_DMA_CSRX14_EORINT_SHIFT 9
#define  PDMA_DMA_CSRX14_EORINT_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX14_EORINT_MASK) >> PDMA_DMA_CSRX14_EORINT_SHIFT)
#define  PDMA_DMA_CSRX14_EORINT_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX14_EORINT_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX14_EORINT_SHIFT))

#define  PDMA_DMA_CSRX14_REQPEND_MASK 0x100
#define  PDMA_DMA_CSRX14_REQPEND_SHIFT 8
#define  PDMA_DMA_CSRX14_REQPEND_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX14_REQPEND_MASK) >> PDMA_DMA_CSRX14_REQPEND_SHIFT)
#define  PDMA_DMA_CSRX14_REQPEND_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX14_REQPEND_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX14_REQPEND_SHIFT))

#define  PDMA_DMA_CSRX14_RESERVED2_MASK 0xe0
#define  PDMA_DMA_CSRX14_RESERVED2_SHIFT 5
#define  PDMA_DMA_CSRX14_RESERVED2_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX14_RESERVED2_MASK) >> PDMA_DMA_CSRX14_RESERVED2_SHIFT)
#define  PDMA_DMA_CSRX14_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX14_RESERVED2_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX14_RESERVED2_SHIFT))

#define  PDMA_DMA_CSRX14_RASINTR_MASK 0x10
#define  PDMA_DMA_CSRX14_RASINTR_SHIFT 4
#define  PDMA_DMA_CSRX14_RASINTR_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX14_RASINTR_MASK) >> PDMA_DMA_CSRX14_RASINTR_SHIFT)
#define  PDMA_DMA_CSRX14_RASINTR_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX14_RASINTR_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX14_RASINTR_SHIFT))

#define  PDMA_DMA_CSRX14_STOPINTR_MASK 0x8
#define  PDMA_DMA_CSRX14_STOPINTR_SHIFT 3
#define  PDMA_DMA_CSRX14_STOPINTR_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX14_STOPINTR_MASK) >> PDMA_DMA_CSRX14_STOPINTR_SHIFT)
#define  PDMA_DMA_CSRX14_STOPINTR_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX14_STOPINTR_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX14_STOPINTR_SHIFT))

#define  PDMA_DMA_CSRX14_ENDINTR_MASK 0x4
#define  PDMA_DMA_CSRX14_ENDINTR_SHIFT 2
#define  PDMA_DMA_CSRX14_ENDINTR_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX14_ENDINTR_MASK) >> PDMA_DMA_CSRX14_ENDINTR_SHIFT)
#define  PDMA_DMA_CSRX14_ENDINTR_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX14_ENDINTR_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX14_ENDINTR_SHIFT))

#define  PDMA_DMA_CSRX14_STARTINTR_MASK 0x2
#define  PDMA_DMA_CSRX14_STARTINTR_SHIFT 1
#define  PDMA_DMA_CSRX14_STARTINTR_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX14_STARTINTR_MASK) >> PDMA_DMA_CSRX14_STARTINTR_SHIFT)
#define  PDMA_DMA_CSRX14_STARTINTR_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX14_STARTINTR_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX14_STARTINTR_SHIFT))

#define  PDMA_DMA_CSRX14_BUSERRINTR_MASK 0x1
#define  PDMA_DMA_CSRX14_BUSERRINTR_SHIFT 0
#define  PDMA_DMA_CSRX14_BUSERRINTR_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX14_BUSERRINTR_MASK) >> PDMA_DMA_CSRX14_BUSERRINTR_SHIFT)
#define  PDMA_DMA_CSRX14_BUSERRINTR_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX14_BUSERRINTR_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX14_BUSERRINTR_SHIFT))

//====================================================================
//Register: DMA Channel Control/Status Registers 0-15 (Instance 16 of 16) (DMA_CSRx15)
/** \brief These read/write registers contain the control and status bits for the channels.
<br>
Ignore reads from reserved bits. Write 0x0 to reserved bits.
<br>
Address offsets:
<br>
DMA Channel 0 Register = 0x0000
<br>
DMA Channel 1 Register = 0x0004
<br>
DMA Channel 2 Register = 0x0008
<br>
DMA Channel 3 Register = 0x000C
<br>
DMA Channel 4 Register = 0x0010
<br>
DMA Channel 5 Register = 0x0014
<br>
DMA Channel 6 Register = 0x0018
<br>
DMA Channel 7 Register = 0x001C
<br>
DMA Channel 8 Register = 0x0020
<br>
DMA Channel 9 Register = 0x0024
<br>
DMA Channel 10 Register = 0x0028
<br>
DMA Channel 11 Register = 0x002C
<br>
DMA Channel 12 Register = 0x0030
<br>
DMA Channel 13 Register = 0x0034
<br>
DMA Channel 14 Register = 0x0038
<br>
DMA Channel 15 Register = 0x003C
<br> (Instance 16 of 16)*/
//====================================================================

#define  PDMA_DMA_CSRX15_RUN_MASK 0x80000000
#define  PDMA_DMA_CSRX15_RUN_SHIFT 31
#define  PDMA_DMA_CSRX15_RUN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX15_RUN_MASK) >> PDMA_DMA_CSRX15_RUN_SHIFT)
#define  PDMA_DMA_CSRX15_RUN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX15_RUN_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX15_RUN_SHIFT))

#define  PDMA_DMA_CSRX15_NODESCFETCH_MASK 0x40000000
#define  PDMA_DMA_CSRX15_NODESCFETCH_SHIFT 30
#define  PDMA_DMA_CSRX15_NODESCFETCH_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX15_NODESCFETCH_MASK) >> PDMA_DMA_CSRX15_NODESCFETCH_SHIFT)
#define  PDMA_DMA_CSRX15_NODESCFETCH_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX15_NODESCFETCH_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX15_NODESCFETCH_SHIFT))

#define  PDMA_DMA_CSRX15_STOPIRQEN_MASK 0x20000000
#define  PDMA_DMA_CSRX15_STOPIRQEN_SHIFT 29
#define  PDMA_DMA_CSRX15_STOPIRQEN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX15_STOPIRQEN_MASK) >> PDMA_DMA_CSRX15_STOPIRQEN_SHIFT)
#define  PDMA_DMA_CSRX15_STOPIRQEN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX15_STOPIRQEN_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX15_STOPIRQEN_SHIFT))

#define  PDMA_DMA_CSRX15_EORIRQEN_MASK 0x10000000
#define  PDMA_DMA_CSRX15_EORIRQEN_SHIFT 28
#define  PDMA_DMA_CSRX15_EORIRQEN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX15_EORIRQEN_MASK) >> PDMA_DMA_CSRX15_EORIRQEN_SHIFT)
#define  PDMA_DMA_CSRX15_EORIRQEN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX15_EORIRQEN_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX15_EORIRQEN_SHIFT))

#define  PDMA_DMA_CSRX15_EORJMPEN_MASK 0x8000000
#define  PDMA_DMA_CSRX15_EORJMPEN_SHIFT 27
#define  PDMA_DMA_CSRX15_EORJMPEN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX15_EORJMPEN_MASK) >> PDMA_DMA_CSRX15_EORJMPEN_SHIFT)
#define  PDMA_DMA_CSRX15_EORJMPEN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX15_EORJMPEN_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX15_EORJMPEN_SHIFT))

#define  PDMA_DMA_CSRX15_EORSTOPEN_MASK 0x4000000
#define  PDMA_DMA_CSRX15_EORSTOPEN_SHIFT 26
#define  PDMA_DMA_CSRX15_EORSTOPEN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX15_EORSTOPEN_MASK) >> PDMA_DMA_CSRX15_EORSTOPEN_SHIFT)
#define  PDMA_DMA_CSRX15_EORSTOPEN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX15_EORSTOPEN_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX15_EORSTOPEN_SHIFT))

#define  PDMA_DMA_CSRX15_SETCMPST_MASK 0x2000000
#define  PDMA_DMA_CSRX15_SETCMPST_SHIFT 25
#define  PDMA_DMA_CSRX15_SETCMPST_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX15_SETCMPST_MASK) >> PDMA_DMA_CSRX15_SETCMPST_SHIFT)
#define  PDMA_DMA_CSRX15_SETCMPST_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX15_SETCMPST_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX15_SETCMPST_SHIFT))

#define  PDMA_DMA_CSRX15_CLRCMPST_MASK 0x1000000
#define  PDMA_DMA_CSRX15_CLRCMPST_SHIFT 24
#define  PDMA_DMA_CSRX15_CLRCMPST_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX15_CLRCMPST_MASK) >> PDMA_DMA_CSRX15_CLRCMPST_SHIFT)
#define  PDMA_DMA_CSRX15_CLRCMPST_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX15_CLRCMPST_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX15_CLRCMPST_SHIFT))

#define  PDMA_DMA_CSRX15_RASIRQEN_MASK 0x800000
#define  PDMA_DMA_CSRX15_RASIRQEN_SHIFT 23
#define  PDMA_DMA_CSRX15_RASIRQEN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX15_RASIRQEN_MASK) >> PDMA_DMA_CSRX15_RASIRQEN_SHIFT)
#define  PDMA_DMA_CSRX15_RASIRQEN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX15_RASIRQEN_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX15_RASIRQEN_SHIFT))

#define  PDMA_DMA_CSRX15_MASKRUN_MASK 0x400000
#define  PDMA_DMA_CSRX15_MASKRUN_SHIFT 22
#define  PDMA_DMA_CSRX15_MASKRUN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX15_MASKRUN_MASK) >> PDMA_DMA_CSRX15_MASKRUN_SHIFT)
#define  PDMA_DMA_CSRX15_MASKRUN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX15_MASKRUN_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX15_MASKRUN_SHIFT))

#define  PDMA_DMA_CSRX15_RESERVED1_MASK 0x3ff800
#define  PDMA_DMA_CSRX15_RESERVED1_SHIFT 11
#define  PDMA_DMA_CSRX15_RESERVED1_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX15_RESERVED1_MASK) >> PDMA_DMA_CSRX15_RESERVED1_SHIFT)
#define  PDMA_DMA_CSRX15_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX15_RESERVED1_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX15_RESERVED1_SHIFT))

#define  PDMA_DMA_CSRX15_CMPST_MASK 0x400
#define  PDMA_DMA_CSRX15_CMPST_SHIFT 10
#define  PDMA_DMA_CSRX15_CMPST_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX15_CMPST_MASK) >> PDMA_DMA_CSRX15_CMPST_SHIFT)
#define  PDMA_DMA_CSRX15_CMPST_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX15_CMPST_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX15_CMPST_SHIFT))

#define  PDMA_DMA_CSRX15_EORINT_MASK 0x200
#define  PDMA_DMA_CSRX15_EORINT_SHIFT 9
#define  PDMA_DMA_CSRX15_EORINT_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX15_EORINT_MASK) >> PDMA_DMA_CSRX15_EORINT_SHIFT)
#define  PDMA_DMA_CSRX15_EORINT_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX15_EORINT_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX15_EORINT_SHIFT))

#define  PDMA_DMA_CSRX15_REQPEND_MASK 0x100
#define  PDMA_DMA_CSRX15_REQPEND_SHIFT 8
#define  PDMA_DMA_CSRX15_REQPEND_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX15_REQPEND_MASK) >> PDMA_DMA_CSRX15_REQPEND_SHIFT)
#define  PDMA_DMA_CSRX15_REQPEND_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX15_REQPEND_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX15_REQPEND_SHIFT))

#define  PDMA_DMA_CSRX15_RESERVED2_MASK 0xe0
#define  PDMA_DMA_CSRX15_RESERVED2_SHIFT 5
#define  PDMA_DMA_CSRX15_RESERVED2_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX15_RESERVED2_MASK) >> PDMA_DMA_CSRX15_RESERVED2_SHIFT)
#define  PDMA_DMA_CSRX15_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX15_RESERVED2_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX15_RESERVED2_SHIFT))

#define  PDMA_DMA_CSRX15_RASINTR_MASK 0x10
#define  PDMA_DMA_CSRX15_RASINTR_SHIFT 4
#define  PDMA_DMA_CSRX15_RASINTR_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX15_RASINTR_MASK) >> PDMA_DMA_CSRX15_RASINTR_SHIFT)
#define  PDMA_DMA_CSRX15_RASINTR_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX15_RASINTR_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX15_RASINTR_SHIFT))

#define  PDMA_DMA_CSRX15_STOPINTR_MASK 0x8
#define  PDMA_DMA_CSRX15_STOPINTR_SHIFT 3
#define  PDMA_DMA_CSRX15_STOPINTR_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX15_STOPINTR_MASK) >> PDMA_DMA_CSRX15_STOPINTR_SHIFT)
#define  PDMA_DMA_CSRX15_STOPINTR_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX15_STOPINTR_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX15_STOPINTR_SHIFT))

#define  PDMA_DMA_CSRX15_ENDINTR_MASK 0x4
#define  PDMA_DMA_CSRX15_ENDINTR_SHIFT 2
#define  PDMA_DMA_CSRX15_ENDINTR_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX15_ENDINTR_MASK) >> PDMA_DMA_CSRX15_ENDINTR_SHIFT)
#define  PDMA_DMA_CSRX15_ENDINTR_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX15_ENDINTR_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX15_ENDINTR_SHIFT))

#define  PDMA_DMA_CSRX15_STARTINTR_MASK 0x2
#define  PDMA_DMA_CSRX15_STARTINTR_SHIFT 1
#define  PDMA_DMA_CSRX15_STARTINTR_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX15_STARTINTR_MASK) >> PDMA_DMA_CSRX15_STARTINTR_SHIFT)
#define  PDMA_DMA_CSRX15_STARTINTR_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX15_STARTINTR_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX15_STARTINTR_SHIFT))

#define  PDMA_DMA_CSRX15_BUSERRINTR_MASK 0x1
#define  PDMA_DMA_CSRX15_BUSERRINTR_SHIFT 0
#define  PDMA_DMA_CSRX15_BUSERRINTR_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CSRX15_BUSERRINTR_MASK) >> PDMA_DMA_CSRX15_BUSERRINTR_SHIFT)
#define  PDMA_DMA_CSRX15_BUSERRINTR_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CSRX15_BUSERRINTR_MASK) | (((uint32_t)val) << PDMA_DMA_CSRX15_BUSERRINTR_SHIFT))

//====================================================================
//Register: DMA Alignment Register (DMA_ALGN)
/** \brief This register activates byte alignment for source and target addresses. Each bit
in this register corresponds to a DMA channel. By default, during data
transfers, the DMAC forces the least-significant three bits for all external
addresses to zeros and the least significant two bits of all peripheral
addresses to zeros.
<br>
Setting a channel-specific bit in this register causes the corresponding channel
to access the complete user-specified address (none of the LSB bits of the
address will be forced to zeros). For example, if channel 15 is programmed to
transfer data involving a misaligned address, software must write 1 to bit 15 of
this register.
<br>
Clearing a bit position in this register will cause the DMAC to treat the
corresponding channel as the default, a 64-bit aligned channel, the source and
target addresses will be forced to zeros as explained earlier.
<br>
This register must be updated before setting the <Run> field in the DMA Channel
Control/Status Registers 0-15 and then must not be altered until the channel
stops.*/
//====================================================================

#define  PDMA_DMA_ALGN_RESERVED1_MASK 0xffff0000
#define  PDMA_DMA_ALGN_RESERVED1_SHIFT 16
#define  PDMA_DMA_ALGN_RESERVED1_MASK_SHIFT(reg) (((reg) & PDMA_DMA_ALGN_RESERVED1_MASK) >> PDMA_DMA_ALGN_RESERVED1_SHIFT)
#define  PDMA_DMA_ALGN_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_ALGN_RESERVED1_MASK) | (((uint32_t)val) << PDMA_DMA_ALGN_RESERVED1_SHIFT))

#define  PDMA_DMA_ALGN_DALGNX_MASK 0xffff
#define  PDMA_DMA_ALGN_DALGNX_SHIFT 0
#define  PDMA_DMA_ALGN_DALGNX_MASK_SHIFT(reg) (((reg) & PDMA_DMA_ALGN_DALGNX_MASK) >> PDMA_DMA_ALGN_DALGNX_SHIFT)
#define  PDMA_DMA_ALGN_DALGNX_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_ALGN_DALGNX_MASK) | (((uint32_t)val) << PDMA_DMA_ALGN_DALGNX_SHIFT))

//====================================================================
//Register: DMA Programmed I/O Control Status Register (DMA_PCSR)
/** \brief This register is used for activating and monitoring posted writes and split
reads on the system bus when software uses programmed I/O (PIO) instructions to
access the peripheral address domain via the DMA bridge.
<br>
Setting the <Activate posted writes and split reads> activates the following DMA
behavior:
<br>
- If the PIO transaction is a read from a peripheral address domain, the DMA
split responds to the read instruction. The DMA bridge will release the system
bus, then use micro-coded instructions to read data from the peripheral bus.
Once the read completes across the peripheral bus, the DMAC completes the split
transaction by re-capturing the system bus and completing the PIO read
transaction. The core stalls until the read is returned because this is
programmed I/O. Any PIO transactions (reads or writes) that occurs while the
current PIO read transaction is between the split response and the split
completion are retried.
<br>
- If the PIO transaction is a write instruction to a peripheral address domain,
the DMA posts the write instruction. The DMA bridge indicates to the system bus
that the PIO write is complete and then release the system bus. The actual write
transaction is then sent across the peripheral bus using microcoded
instructions. If software requires that a write complete on the peripheral bus
before continuing, then software must write the address, then immediately read
the same address, which guarantees that the address has been updated before
allowing the core to continue execution.
<br>
Clearing the <Activate posted writes and split reads> field deactivates the
posted write and split response behavior. A write transaction on the system bus
is completed only after the write is sent across the peripheral bus. The
targeted address location is guaranteed to be updated by the time the
transaction completes on the system bus. A read transaction on the system bus is
completed only after the DMA bridge receives the data from across the peripheral
bus. There are no split responses, split completions, or retries in this mode.
<br>
Note: If software requires that a write complete on the peripheral bus before
continuing, then software must write the address, then immediately read the same
address, which will guarantee that the address has been updated before allowing
the core to continue execution. The user must perform this read-after-write
transaction to ensure the processor is in a correct state before the core
continues execution.
<br>
Note: The <Activate posted writes and split reads> must be modified only when
the <Bridge busy status> field is clear (no pending peripheral PIO
transactions). Modifying this control bit when a PIO transaction is still
pending might lead to unpredictable results and is therefore not recommended.
<br>
The PIO transactions are always completed in the order they were issued,
irrespective of the <Activate posted writes and split reads> field.
<br>
Note: The <Activate posted writes and split reads> field is set by default
(reset value).
<br>
The <Bridge busy status> field is a status bit which, when set, indicates
a pending PIO transaction across the peripheral bus. Any further PIO
transactions on the system bus are retried when <Bridge busy status> is set.
This bit cannot be modified by software. When <Bridge busy status> is clear,
this indicates that there are no pending PIO transactions across the peripheral
bus. A new PIO transaction is not retried in this case.
<br>
This is a read/write register. Ignore reads from reserved bits. Write 0x0 to
reserved bits.*/
//====================================================================

#define  PDMA_DMA_PCSR_BRGSPLIT_MASK 0x80000000
#define  PDMA_DMA_PCSR_BRGSPLIT_SHIFT 31
#define  PDMA_DMA_PCSR_BRGSPLIT_MASK_SHIFT(reg) (((reg) & PDMA_DMA_PCSR_BRGSPLIT_MASK) >> PDMA_DMA_PCSR_BRGSPLIT_SHIFT)
#define  PDMA_DMA_PCSR_BRGSPLIT_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_PCSR_BRGSPLIT_MASK) | (((uint32_t)val) << PDMA_DMA_PCSR_BRGSPLIT_SHIFT))

#define  PDMA_DMA_PCSR_RESERVED1_MASK 0x7ffffff0
#define  PDMA_DMA_PCSR_RESERVED1_SHIFT 4
#define  PDMA_DMA_PCSR_RESERVED1_MASK_SHIFT(reg) (((reg) & PDMA_DMA_PCSR_RESERVED1_MASK) >> PDMA_DMA_PCSR_RESERVED1_SHIFT)
#define  PDMA_DMA_PCSR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_PCSR_RESERVED1_MASK) | (((uint32_t)val) << PDMA_DMA_PCSR_RESERVED1_SHIFT))

#define  PDMA_DMA_PCSR_POST_WRITE_DISABLE_MASK 0x8
#define  PDMA_DMA_PCSR_POST_WRITE_DISABLE_SHIFT 3
#define  PDMA_DMA_PCSR_POST_WRITE_DISABLE_MASK_SHIFT(reg) (((reg) & PDMA_DMA_PCSR_POST_WRITE_DISABLE_MASK) >> PDMA_DMA_PCSR_POST_WRITE_DISABLE_SHIFT)
#define  PDMA_DMA_PCSR_POST_WRITE_DISABLE_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_PCSR_POST_WRITE_DISABLE_MASK) | (((uint32_t)val) << PDMA_DMA_PCSR_POST_WRITE_DISABLE_SHIFT))

#define  PDMA_DMA_PCSR_BPB_CG_DISABLE_MASK 0x4
#define  PDMA_DMA_PCSR_BPB_CG_DISABLE_SHIFT 2
#define  PDMA_DMA_PCSR_BPB_CG_DISABLE_MASK_SHIFT(reg) (((reg) & PDMA_DMA_PCSR_BPB_CG_DISABLE_MASK) >> PDMA_DMA_PCSR_BPB_CG_DISABLE_SHIFT)
#define  PDMA_DMA_PCSR_BPB_CG_DISABLE_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_PCSR_BPB_CG_DISABLE_MASK) | (((uint32_t)val) << PDMA_DMA_PCSR_BPB_CG_DISABLE_SHIFT))

#define  PDMA_DMA_PCSR_AXI_CG_DISABLE_MASK 0x2
#define  PDMA_DMA_PCSR_AXI_CG_DISABLE_SHIFT 1
#define  PDMA_DMA_PCSR_AXI_CG_DISABLE_MASK_SHIFT(reg) (((reg) & PDMA_DMA_PCSR_AXI_CG_DISABLE_MASK) >> PDMA_DMA_PCSR_AXI_CG_DISABLE_SHIFT)
#define  PDMA_DMA_PCSR_AXI_CG_DISABLE_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_PCSR_AXI_CG_DISABLE_MASK) | (((uint32_t)val) << PDMA_DMA_PCSR_AXI_CG_DISABLE_SHIFT))

#define  PDMA_DMA_PCSR_BRGBUSY_MASK 0x1
#define  PDMA_DMA_PCSR_BRGBUSY_SHIFT 0
#define  PDMA_DMA_PCSR_BRGBUSY_MASK_SHIFT(reg) (((reg) & PDMA_DMA_PCSR_BRGBUSY_MASK) >> PDMA_DMA_PCSR_BRGBUSY_SHIFT)
#define  PDMA_DMA_PCSR_BRGBUSY_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_PCSR_BRGBUSY_MASK) | (((uint32_t)val) << PDMA_DMA_PCSR_BRGBUSY_SHIFT))

//====================================================================
//Register: DREQ Status Register 0 (DMA_RQSR0)
/** \brief This register logs the number of pending requests made by an external companion
chip on the corresponding DREQ pin. The register reflects the status of a 5-bit
counter that is controlled by the DMAC in the following manner:
<br>
- The DMAC increments the counter each time the external companion chip toggles
the DREQ pin from low to high (positive edge trigger). The external companion
chip must follow the rules outlined in the Channel States Section in the PXA2128
Datasheet.
<br>
- For a write to an external peripheral, the DMAC decreases the counter after it
completes the write.
<br>
- For a read from an external peripheral, the DMAC decreases the counter after
it sends the corresponding read request to the memory controller.
<br>
The external companion chip must not have more than 31 pending requests at
a given time.
<br>
This is a read/write register. Ignore reads from reserved bits. Write 0x0 to
reserved bits.*/
//====================================================================

#define  PDMA_DMA_RQSR0_RESERVED1_MASK 0xfffffe00
#define  PDMA_DMA_RQSR0_RESERVED1_SHIFT 9
#define  PDMA_DMA_RQSR0_RESERVED1_MASK_SHIFT(reg) (((reg) & PDMA_DMA_RQSR0_RESERVED1_MASK) >> PDMA_DMA_RQSR0_RESERVED1_SHIFT)
#define  PDMA_DMA_RQSR0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_RQSR0_RESERVED1_MASK) | (((uint32_t)val) << PDMA_DMA_RQSR0_RESERVED1_SHIFT))

#define  PDMA_DMA_RQSR0_CLR_MASK 0x100
#define  PDMA_DMA_RQSR0_CLR_SHIFT 8
#define  PDMA_DMA_RQSR0_CLR_MASK_SHIFT(reg) (((reg) & PDMA_DMA_RQSR0_CLR_MASK) >> PDMA_DMA_RQSR0_CLR_SHIFT)
#define  PDMA_DMA_RQSR0_CLR_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_RQSR0_CLR_MASK) | (((uint32_t)val) << PDMA_DMA_RQSR0_CLR_SHIFT))

#define  PDMA_DMA_RQSR0_RESERVED2_MASK 0xe0
#define  PDMA_DMA_RQSR0_RESERVED2_SHIFT 5
#define  PDMA_DMA_RQSR0_RESERVED2_MASK_SHIFT(reg) (((reg) & PDMA_DMA_RQSR0_RESERVED2_MASK) >> PDMA_DMA_RQSR0_RESERVED2_SHIFT)
#define  PDMA_DMA_RQSR0_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_RQSR0_RESERVED2_MASK) | (((uint32_t)val) << PDMA_DMA_RQSR0_RESERVED2_SHIFT))

#define  PDMA_DMA_RQSR0_REQPEND_MASK 0x1f
#define  PDMA_DMA_RQSR0_REQPEND_SHIFT 0
#define  PDMA_DMA_RQSR0_REQPEND_MASK_SHIFT(reg) (((reg) & PDMA_DMA_RQSR0_REQPEND_MASK) >> PDMA_DMA_RQSR0_REQPEND_SHIFT)
#define  PDMA_DMA_RQSR0_REQPEND_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_RQSR0_REQPEND_MASK) | (((uint32_t)val) << PDMA_DMA_RQSR0_REQPEND_SHIFT))

//====================================================================
//Register: DREQ Status Register 1 (DMA_RQSR1)
/** \brief This register logs the number of pending requests made by an external companion
chip on the corresponding DREQ pin. The register reflects the status of a 5-bit
counter that is controlled by the DMAC in the following manner:
<br>
- The DMAC increments the counter each time the external companion chip toggles
the DREQ pin from low to high (positive edge trigger). The external companion
chip must follow the rules outlined in the Channel States Section in the PXA2128
Datasheet.
<br>
- For a write to an external peripheral, the DMAC decreases the counter after it
completes the write.
<br>
- For a read from an external peripheral, the DMAC decreases the counter after
it sends the corresponding read request to the memory controller.
<br>
The external companion chip must not have more than 31 pending requests at
a given time.
<br>
This is a read/write register. Ignore reads from reserved bits. Write 0x0 to
reserved bits.*/
//====================================================================

#define  PDMA_DMA_RQSR1_RESERVED1_MASK 0xfffffe00
#define  PDMA_DMA_RQSR1_RESERVED1_SHIFT 9
#define  PDMA_DMA_RQSR1_RESERVED1_MASK_SHIFT(reg) (((reg) & PDMA_DMA_RQSR1_RESERVED1_MASK) >> PDMA_DMA_RQSR1_RESERVED1_SHIFT)
#define  PDMA_DMA_RQSR1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_RQSR1_RESERVED1_MASK) | (((uint32_t)val) << PDMA_DMA_RQSR1_RESERVED1_SHIFT))

#define  PDMA_DMA_RQSR1_CLR_MASK 0x100
#define  PDMA_DMA_RQSR1_CLR_SHIFT 8
#define  PDMA_DMA_RQSR1_CLR_MASK_SHIFT(reg) (((reg) & PDMA_DMA_RQSR1_CLR_MASK) >> PDMA_DMA_RQSR1_CLR_SHIFT)
#define  PDMA_DMA_RQSR1_CLR_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_RQSR1_CLR_MASK) | (((uint32_t)val) << PDMA_DMA_RQSR1_CLR_SHIFT))

#define  PDMA_DMA_RQSR1_RESERVED2_MASK 0xe0
#define  PDMA_DMA_RQSR1_RESERVED2_SHIFT 5
#define  PDMA_DMA_RQSR1_RESERVED2_MASK_SHIFT(reg) (((reg) & PDMA_DMA_RQSR1_RESERVED2_MASK) >> PDMA_DMA_RQSR1_RESERVED2_SHIFT)
#define  PDMA_DMA_RQSR1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_RQSR1_RESERVED2_MASK) | (((uint32_t)val) << PDMA_DMA_RQSR1_RESERVED2_SHIFT))

#define  PDMA_DMA_RQSR1_REQPEND_MASK 0x1f
#define  PDMA_DMA_RQSR1_REQPEND_SHIFT 0
#define  PDMA_DMA_RQSR1_REQPEND_MASK_SHIFT(reg) (((reg) & PDMA_DMA_RQSR1_REQPEND_MASK) >> PDMA_DMA_RQSR1_REQPEND_SHIFT)
#define  PDMA_DMA_RQSR1_REQPEND_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_RQSR1_REQPEND_MASK) | (((uint32_t)val) << PDMA_DMA_RQSR1_REQPEND_SHIFT))

//====================================================================
//Register: DREQ Status Register 2 (DMA_RQSR2)
/** \brief This register logs the number of pending requests made by an external companion
chip on the corresponding DREQ pin. The register reflects the status of a 5-bit
counter that is controlled by the DMAC in the following manner:
<br>
- The DMAC increments the counter each time the external companion chip toggles
the DREQ pin from low to high (positive edge trigger). The external companion
chip must follow the rules outlined in the Channel States Section in the PXA2128
Datasheet.
<br>
- For a write to an external peripheral, the DMAC decreases the counter after it
completes the write.
<br>
- For a read from an external peripheral, the DMAC decreases the counter after
it sends the corresponding read request to the memory controller.
<br>
The external companion chip must not have more than 31 pending requests at
a given time.
<br>
This is a read/write register. Ignore reads from reserved bits. Write 0x0 to
reserved bits.*/
//====================================================================

#define  PDMA_DMA_RQSR2_RESERVED1_MASK 0xfffffe00
#define  PDMA_DMA_RQSR2_RESERVED1_SHIFT 9
#define  PDMA_DMA_RQSR2_RESERVED1_MASK_SHIFT(reg) (((reg) & PDMA_DMA_RQSR2_RESERVED1_MASK) >> PDMA_DMA_RQSR2_RESERVED1_SHIFT)
#define  PDMA_DMA_RQSR2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_RQSR2_RESERVED1_MASK) | (((uint32_t)val) << PDMA_DMA_RQSR2_RESERVED1_SHIFT))

#define  PDMA_DMA_RQSR2_CLR_MASK 0x100
#define  PDMA_DMA_RQSR2_CLR_SHIFT 8
#define  PDMA_DMA_RQSR2_CLR_MASK_SHIFT(reg) (((reg) & PDMA_DMA_RQSR2_CLR_MASK) >> PDMA_DMA_RQSR2_CLR_SHIFT)
#define  PDMA_DMA_RQSR2_CLR_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_RQSR2_CLR_MASK) | (((uint32_t)val) << PDMA_DMA_RQSR2_CLR_SHIFT))

#define  PDMA_DMA_RQSR2_RESERVED2_MASK 0xe0
#define  PDMA_DMA_RQSR2_RESERVED2_SHIFT 5
#define  PDMA_DMA_RQSR2_RESERVED2_MASK_SHIFT(reg) (((reg) & PDMA_DMA_RQSR2_RESERVED2_MASK) >> PDMA_DMA_RQSR2_RESERVED2_SHIFT)
#define  PDMA_DMA_RQSR2_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_RQSR2_RESERVED2_MASK) | (((uint32_t)val) << PDMA_DMA_RQSR2_RESERVED2_SHIFT))

#define  PDMA_DMA_RQSR2_REQPEND_MASK 0x1f
#define  PDMA_DMA_RQSR2_REQPEND_SHIFT 0
#define  PDMA_DMA_RQSR2_REQPEND_MASK_SHIFT(reg) (((reg) & PDMA_DMA_RQSR2_REQPEND_MASK) >> PDMA_DMA_RQSR2_REQPEND_SHIFT)
#define  PDMA_DMA_RQSR2_REQPEND_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_RQSR2_REQPEND_MASK) | (((uint32_t)val) << PDMA_DMA_RQSR2_REQPEND_SHIFT))

//====================================================================
//Register: DMA Interrupt Register (DMA_INT)
/** \brief This read-only register logs the interrupt information for each channel. An
interrupt is generated if any of the following conditions occurs:
<br>
- Any transaction error occurs on the internal bus associated with the relevant
channel.
<br>
- The current transfer finishes successfully and the <End interrupt
enable> field in the DMA Command Registers 0-15 is set.
<br>
- The current descriptor is loaded successfully and the <STARTIRQEN> field in
the DMA Command Registers 0-15 is set.
<br>
- The <Stop interrupt enabled> field in the DMA Channel Control/Status
Registers 0-15 is set and the channel is in an uninitialized or stopped state.
<br>
- The <Setting the End-of-Receive interrupt enable> and <End of Receive
Interrupt> (EOR signaled by a peripheral) fields in the DMA Channel
Control/Status Registers 0-15 are set.
<br>
- The <Request after channel stopped interrupt enable> field in the DMA Channel
Control/Status Registers 0-15 is set and the peripheral makes a DMA request
after the channel has stopped.
<br>
All DMAC interrupts, except the one that corresponds to the <Stop
interrupt> field in the DMA Channel Control/Status Registers 0-15 are cleared by
writing 1 to the corresponding interrupt bit in the DMA Channel Control/Status
Registers 0-15*/
//====================================================================

#define  PDMA_DMA_INT_RESERVED1_MASK 0xffff0000
#define  PDMA_DMA_INT_RESERVED1_SHIFT 16
#define  PDMA_DMA_INT_RESERVED1_MASK_SHIFT(reg) (((reg) & PDMA_DMA_INT_RESERVED1_MASK) >> PDMA_DMA_INT_RESERVED1_SHIFT)
#define  PDMA_DMA_INT_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_INT_RESERVED1_MASK) | (((uint32_t)val) << PDMA_DMA_INT_RESERVED1_SHIFT))

#define  PDMA_DMA_INT_CHLINTRX_MASK 0xffff
#define  PDMA_DMA_INT_CHLINTRX_SHIFT 0
#define  PDMA_DMA_INT_CHLINTRX_MASK_SHIFT(reg) (((reg) & PDMA_DMA_INT_CHLINTRX_MASK) >> PDMA_DMA_INT_CHLINTRX_SHIFT)
#define  PDMA_DMA_INT_CHLINTRX_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_INT_CHLINTRX_MASK) | (((uint32_t)val) << PDMA_DMA_INT_CHLINTRX_SHIFT))

//====================================================================
//Register: DMA Request to Channel Map Registers 0-31 (Instance 1 of 32) (DMA_RCMRx0)
/** \brief These registers map the DMA request to a channel.
<br>
These are read/write registers. Ignore reads from reserved bits. Write 0x0 to
reserved bits.
<br>
Here is the address offset for each of the dma requests:
<br>
Request # Request Bus Address DMA0 DMA1<br>
---------- ----------------- ------- --------- ---------<br>
Request 0 ext periph req[0] 0x0000 dreq0 un-used<br>
Request 1 ext periph req[1] 0x0004 dreq1 un-used<br>
Request 2 ext periph req[2] 0x0008 dreq2 un-used<br>
Request 3 periph bus req[0] 0x000C un-used un-used<br>
Request 4 periph bus req[1] 0x0010 UART1 RX un-used<br>
Request 5 periph bus req[2] 0x0014 UART1 TX un-used<br>
Request 6 periph bus req[3] 0x0018 un-used SSP1 RX<br>
Request 7 periph bus req[4] 0x001C un-used SSP1 TX<br>
Request 8 periph bus req[5] 0x0020 un-used un-used<br>
Request 9 periph bus req[6] 0x0024 un-used un-used<br>
Request 10 periph bus req[7] 0x0028 un-used SSP2 RX<br>
Request 11 periph bus req[8] 0x002C un-used SSP2 TX<br>
Request 12 periph bus req[9] 0x0030 SSP3 RX TWSI4 RX<br>
Request 13 periph bus req[10] 0x0034 SSP3 TX TWSI4 TX<br>
Request 14 periph bus req[11] 0x0038 TWSI1 RX TWSI5 RX<br>
Request 15 periph bus req[12] 0x003C TWSI1 TX TWSI5 TX<br>
Request 16 periph bus req[13] 0x0040 TWSI2 RX TWSI6 RX<br>
Request 17 periph bus req[14] 0x0044 TWSI2 TX TWSI6 TX<br>
Request 18 periph bus req[15] 0x0048 TWSI3 RX UART4 RX<br>
Request 19 periph bus req[16] 0x004C TWSI3 TX UART4 TX<br>
Request 20 periph bus req[17] 0x0050 un-used UART2 RX<br>
Request 21 periph bus req[18] 0x0054 un-used UART2 TX<br>
Request 22 periph bus req[19] 0x0058 UART3 RX un-used<br>
Request 23 periph bus req[20] 0x005C UART3 TX un-used<br>
Request 24 system bus req[4] 0x0060 un-used un-used<br>
Request 25 system bus req[5] 0x0064 un-used un-used<br>
Request 26 system bus req[6] 0x0068 un-used un-used<br>
Request 27 system bus req[7] 0x006C un-used un-used<br>
Request 28 system bus req[0] 0x0070 NAND DATA un-used<br>
Request 29 system bus req[1] 0x0074 NAND CMD un-used<br>
Request 30 system bus req[2] 0x0078 un-used un-used<br>
Request 31 system bus req[3] 0x007C un-used un-used<br> (Instance 1 of 32)*/
//====================================================================

#define  PDMA_DMA_RCMRX0_RESERVED1_MASK 0xffffff00
#define  PDMA_DMA_RCMRX0_RESERVED1_SHIFT 8
#define  PDMA_DMA_RCMRX0_RESERVED1_MASK_SHIFT(reg) (((reg) & PDMA_DMA_RCMRX0_RESERVED1_MASK) >> PDMA_DMA_RCMRX0_RESERVED1_SHIFT)
#define  PDMA_DMA_RCMRX0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_RCMRX0_RESERVED1_MASK) | (((uint32_t)val) << PDMA_DMA_RCMRX0_RESERVED1_SHIFT))

#define  PDMA_DMA_RCMRX0_MAPVLD_MASK 0x80
#define  PDMA_DMA_RCMRX0_MAPVLD_SHIFT 7
#define  PDMA_DMA_RCMRX0_MAPVLD_MASK_SHIFT(reg) (((reg) & PDMA_DMA_RCMRX0_MAPVLD_MASK) >> PDMA_DMA_RCMRX0_MAPVLD_SHIFT)
#define  PDMA_DMA_RCMRX0_MAPVLD_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_RCMRX0_MAPVLD_MASK) | (((uint32_t)val) << PDMA_DMA_RCMRX0_MAPVLD_SHIFT))

#define  PDMA_DMA_RCMRX0_RESERVED2_MASK 0x60
#define  PDMA_DMA_RCMRX0_RESERVED2_SHIFT 5
#define  PDMA_DMA_RCMRX0_RESERVED2_MASK_SHIFT(reg) (((reg) & PDMA_DMA_RCMRX0_RESERVED2_MASK) >> PDMA_DMA_RCMRX0_RESERVED2_SHIFT)
#define  PDMA_DMA_RCMRX0_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_RCMRX0_RESERVED2_MASK) | (((uint32_t)val) << PDMA_DMA_RCMRX0_RESERVED2_SHIFT))

#define  PDMA_DMA_RCMRX0_CHLNUM_MASK 0x1f
#define  PDMA_DMA_RCMRX0_CHLNUM_SHIFT 0
#define  PDMA_DMA_RCMRX0_CHLNUM_MASK_SHIFT(reg) (((reg) & PDMA_DMA_RCMRX0_CHLNUM_MASK) >> PDMA_DMA_RCMRX0_CHLNUM_SHIFT)
#define  PDMA_DMA_RCMRX0_CHLNUM_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_RCMRX0_CHLNUM_MASK) | (((uint32_t)val) << PDMA_DMA_RCMRX0_CHLNUM_SHIFT))

//====================================================================
//Register: DMA Request to Channel Map Registers 0-31 (Instance 2 of 32) (DMA_RCMRx1)
/** \brief These registers map the DMA request to a channel.
<br>
These are read/write registers. Ignore reads from reserved bits. Write 0x0 to
reserved bits.
<br>
Here is the address offset for each of the dma requests:
<br>
Request # Request Bus Address DMA0 DMA1<br>
---------- ----------------- ------- --------- ---------<br>
Request 0 ext periph req[0] 0x0000 dreq0 un-used<br>
Request 1 ext periph req[1] 0x0004 dreq1 un-used<br>
Request 2 ext periph req[2] 0x0008 dreq2 un-used<br>
Request 3 periph bus req[0] 0x000C un-used un-used<br>
Request 4 periph bus req[1] 0x0010 UART1 RX un-used<br>
Request 5 periph bus req[2] 0x0014 UART1 TX un-used<br>
Request 6 periph bus req[3] 0x0018 un-used SSP1 RX<br>
Request 7 periph bus req[4] 0x001C un-used SSP1 TX<br>
Request 8 periph bus req[5] 0x0020 un-used un-used<br>
Request 9 periph bus req[6] 0x0024 un-used un-used<br>
Request 10 periph bus req[7] 0x0028 un-used SSP2 RX<br>
Request 11 periph bus req[8] 0x002C un-used SSP2 TX<br>
Request 12 periph bus req[9] 0x0030 SSP3 RX TWSI4 RX<br>
Request 13 periph bus req[10] 0x0034 SSP3 TX TWSI4 TX<br>
Request 14 periph bus req[11] 0x0038 TWSI1 RX TWSI5 RX<br>
Request 15 periph bus req[12] 0x003C TWSI1 TX TWSI5 TX<br>
Request 16 periph bus req[13] 0x0040 TWSI2 RX TWSI6 RX<br>
Request 17 periph bus req[14] 0x0044 TWSI2 TX TWSI6 TX<br>
Request 18 periph bus req[15] 0x0048 TWSI3 RX UART4 RX<br>
Request 19 periph bus req[16] 0x004C TWSI3 TX UART4 TX<br>
Request 20 periph bus req[17] 0x0050 un-used UART2 RX<br>
Request 21 periph bus req[18] 0x0054 un-used UART2 TX<br>
Request 22 periph bus req[19] 0x0058 UART3 RX un-used<br>
Request 23 periph bus req[20] 0x005C UART3 TX un-used<br>
Request 24 system bus req[4] 0x0060 un-used un-used<br>
Request 25 system bus req[5] 0x0064 un-used un-used<br>
Request 26 system bus req[6] 0x0068 un-used un-used<br>
Request 27 system bus req[7] 0x006C un-used un-used<br>
Request 28 system bus req[0] 0x0070 NAND DATA un-used<br>
Request 29 system bus req[1] 0x0074 NAND CMD un-used<br>
Request 30 system bus req[2] 0x0078 un-used un-used<br>
Request 31 system bus req[3] 0x007C un-used un-used<br> (Instance 2 of 32)*/
//====================================================================

#define  PDMA_DMA_RCMRX1_RESERVED1_MASK 0xffffff00
#define  PDMA_DMA_RCMRX1_RESERVED1_SHIFT 8
#define  PDMA_DMA_RCMRX1_RESERVED1_MASK_SHIFT(reg) (((reg) & PDMA_DMA_RCMRX1_RESERVED1_MASK) >> PDMA_DMA_RCMRX1_RESERVED1_SHIFT)
#define  PDMA_DMA_RCMRX1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_RCMRX1_RESERVED1_MASK) | (((uint32_t)val) << PDMA_DMA_RCMRX1_RESERVED1_SHIFT))

#define  PDMA_DMA_RCMRX1_MAPVLD_MASK 0x80
#define  PDMA_DMA_RCMRX1_MAPVLD_SHIFT 7
#define  PDMA_DMA_RCMRX1_MAPVLD_MASK_SHIFT(reg) (((reg) & PDMA_DMA_RCMRX1_MAPVLD_MASK) >> PDMA_DMA_RCMRX1_MAPVLD_SHIFT)
#define  PDMA_DMA_RCMRX1_MAPVLD_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_RCMRX1_MAPVLD_MASK) | (((uint32_t)val) << PDMA_DMA_RCMRX1_MAPVLD_SHIFT))

#define  PDMA_DMA_RCMRX1_RESERVED2_MASK 0x60
#define  PDMA_DMA_RCMRX1_RESERVED2_SHIFT 5
#define  PDMA_DMA_RCMRX1_RESERVED2_MASK_SHIFT(reg) (((reg) & PDMA_DMA_RCMRX1_RESERVED2_MASK) >> PDMA_DMA_RCMRX1_RESERVED2_SHIFT)
#define  PDMA_DMA_RCMRX1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_RCMRX1_RESERVED2_MASK) | (((uint32_t)val) << PDMA_DMA_RCMRX1_RESERVED2_SHIFT))

#define  PDMA_DMA_RCMRX1_CHLNUM_MASK 0x1f
#define  PDMA_DMA_RCMRX1_CHLNUM_SHIFT 0
#define  PDMA_DMA_RCMRX1_CHLNUM_MASK_SHIFT(reg) (((reg) & PDMA_DMA_RCMRX1_CHLNUM_MASK) >> PDMA_DMA_RCMRX1_CHLNUM_SHIFT)
#define  PDMA_DMA_RCMRX1_CHLNUM_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_RCMRX1_CHLNUM_MASK) | (((uint32_t)val) << PDMA_DMA_RCMRX1_CHLNUM_SHIFT))

//====================================================================
//Register: DMA Request to Channel Map Registers 0-31 (Instance 3 of 32) (DMA_RCMRx2)
/** \brief These registers map the DMA request to a channel.
<br>
These are read/write registers. Ignore reads from reserved bits. Write 0x0 to
reserved bits.
<br>
Here is the address offset for each of the dma requests:
<br>
Request # Request Bus Address DMA0 DMA1<br>
---------- ----------------- ------- --------- ---------<br>
Request 0 ext periph req[0] 0x0000 dreq0 un-used<br>
Request 1 ext periph req[1] 0x0004 dreq1 un-used<br>
Request 2 ext periph req[2] 0x0008 dreq2 un-used<br>
Request 3 periph bus req[0] 0x000C un-used un-used<br>
Request 4 periph bus req[1] 0x0010 UART1 RX un-used<br>
Request 5 periph bus req[2] 0x0014 UART1 TX un-used<br>
Request 6 periph bus req[3] 0x0018 un-used SSP1 RX<br>
Request 7 periph bus req[4] 0x001C un-used SSP1 TX<br>
Request 8 periph bus req[5] 0x0020 un-used un-used<br>
Request 9 periph bus req[6] 0x0024 un-used un-used<br>
Request 10 periph bus req[7] 0x0028 un-used SSP2 RX<br>
Request 11 periph bus req[8] 0x002C un-used SSP2 TX<br>
Request 12 periph bus req[9] 0x0030 SSP3 RX TWSI4 RX<br>
Request 13 periph bus req[10] 0x0034 SSP3 TX TWSI4 TX<br>
Request 14 periph bus req[11] 0x0038 TWSI1 RX TWSI5 RX<br>
Request 15 periph bus req[12] 0x003C TWSI1 TX TWSI5 TX<br>
Request 16 periph bus req[13] 0x0040 TWSI2 RX TWSI6 RX<br>
Request 17 periph bus req[14] 0x0044 TWSI2 TX TWSI6 TX<br>
Request 18 periph bus req[15] 0x0048 TWSI3 RX UART4 RX<br>
Request 19 periph bus req[16] 0x004C TWSI3 TX UART4 TX<br>
Request 20 periph bus req[17] 0x0050 un-used UART2 RX<br>
Request 21 periph bus req[18] 0x0054 un-used UART2 TX<br>
Request 22 periph bus req[19] 0x0058 UART3 RX un-used<br>
Request 23 periph bus req[20] 0x005C UART3 TX un-used<br>
Request 24 system bus req[4] 0x0060 un-used un-used<br>
Request 25 system bus req[5] 0x0064 un-used un-used<br>
Request 26 system bus req[6] 0x0068 un-used un-used<br>
Request 27 system bus req[7] 0x006C un-used un-used<br>
Request 28 system bus req[0] 0x0070 NAND DATA un-used<br>
Request 29 system bus req[1] 0x0074 NAND CMD un-used<br>
Request 30 system bus req[2] 0x0078 un-used un-used<br>
Request 31 system bus req[3] 0x007C un-used un-used<br> (Instance 3 of 32)*/
//====================================================================

#define  PDMA_DMA_RCMRX2_RESERVED1_MASK 0xffffff00
#define  PDMA_DMA_RCMRX2_RESERVED1_SHIFT 8
#define  PDMA_DMA_RCMRX2_RESERVED1_MASK_SHIFT(reg) (((reg) & PDMA_DMA_RCMRX2_RESERVED1_MASK) >> PDMA_DMA_RCMRX2_RESERVED1_SHIFT)
#define  PDMA_DMA_RCMRX2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_RCMRX2_RESERVED1_MASK) | (((uint32_t)val) << PDMA_DMA_RCMRX2_RESERVED1_SHIFT))

#define  PDMA_DMA_RCMRX2_MAPVLD_MASK 0x80
#define  PDMA_DMA_RCMRX2_MAPVLD_SHIFT 7
#define  PDMA_DMA_RCMRX2_MAPVLD_MASK_SHIFT(reg) (((reg) & PDMA_DMA_RCMRX2_MAPVLD_MASK) >> PDMA_DMA_RCMRX2_MAPVLD_SHIFT)
#define  PDMA_DMA_RCMRX2_MAPVLD_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_RCMRX2_MAPVLD_MASK) | (((uint32_t)val) << PDMA_DMA_RCMRX2_MAPVLD_SHIFT))

#define  PDMA_DMA_RCMRX2_RESERVED2_MASK 0x60
#define  PDMA_DMA_RCMRX2_RESERVED2_SHIFT 5
#define  PDMA_DMA_RCMRX2_RESERVED2_MASK_SHIFT(reg) (((reg) & PDMA_DMA_RCMRX2_RESERVED2_MASK) >> PDMA_DMA_RCMRX2_RESERVED2_SHIFT)
#define  PDMA_DMA_RCMRX2_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_RCMRX2_RESERVED2_MASK) | (((uint32_t)val) << PDMA_DMA_RCMRX2_RESERVED2_SHIFT))

#define  PDMA_DMA_RCMRX2_CHLNUM_MASK 0x1f
#define  PDMA_DMA_RCMRX2_CHLNUM_SHIFT 0
#define  PDMA_DMA_RCMRX2_CHLNUM_MASK_SHIFT(reg) (((reg) & PDMA_DMA_RCMRX2_CHLNUM_MASK) >> PDMA_DMA_RCMRX2_CHLNUM_SHIFT)
#define  PDMA_DMA_RCMRX2_CHLNUM_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_RCMRX2_CHLNUM_MASK) | (((uint32_t)val) << PDMA_DMA_RCMRX2_CHLNUM_SHIFT))

//====================================================================
//Register: DMA Request to Channel Map Registers 0-31 (Instance 4 of 32) (DMA_RCMRx3)
/** \brief These registers map the DMA request to a channel.
<br>
These are read/write registers. Ignore reads from reserved bits. Write 0x0 to
reserved bits.
<br>
Here is the address offset for each of the dma requests:
<br>
Request # Request Bus Address DMA0 DMA1<br>
---------- ----------------- ------- --------- ---------<br>
Request 0 ext periph req[0] 0x0000 dreq0 un-used<br>
Request 1 ext periph req[1] 0x0004 dreq1 un-used<br>
Request 2 ext periph req[2] 0x0008 dreq2 un-used<br>
Request 3 periph bus req[0] 0x000C un-used un-used<br>
Request 4 periph bus req[1] 0x0010 UART1 RX un-used<br>
Request 5 periph bus req[2] 0x0014 UART1 TX un-used<br>
Request 6 periph bus req[3] 0x0018 un-used SSP1 RX<br>
Request 7 periph bus req[4] 0x001C un-used SSP1 TX<br>
Request 8 periph bus req[5] 0x0020 un-used un-used<br>
Request 9 periph bus req[6] 0x0024 un-used un-used<br>
Request 10 periph bus req[7] 0x0028 un-used SSP2 RX<br>
Request 11 periph bus req[8] 0x002C un-used SSP2 TX<br>
Request 12 periph bus req[9] 0x0030 SSP3 RX TWSI4 RX<br>
Request 13 periph bus req[10] 0x0034 SSP3 TX TWSI4 TX<br>
Request 14 periph bus req[11] 0x0038 TWSI1 RX TWSI5 RX<br>
Request 15 periph bus req[12] 0x003C TWSI1 TX TWSI5 TX<br>
Request 16 periph bus req[13] 0x0040 TWSI2 RX TWSI6 RX<br>
Request 17 periph bus req[14] 0x0044 TWSI2 TX TWSI6 TX<br>
Request 18 periph bus req[15] 0x0048 TWSI3 RX UART4 RX<br>
Request 19 periph bus req[16] 0x004C TWSI3 TX UART4 TX<br>
Request 20 periph bus req[17] 0x0050 un-used UART2 RX<br>
Request 21 periph bus req[18] 0x0054 un-used UART2 TX<br>
Request 22 periph bus req[19] 0x0058 UART3 RX un-used<br>
Request 23 periph bus req[20] 0x005C UART3 TX un-used<br>
Request 24 system bus req[4] 0x0060 un-used un-used<br>
Request 25 system bus req[5] 0x0064 un-used un-used<br>
Request 26 system bus req[6] 0x0068 un-used un-used<br>
Request 27 system bus req[7] 0x006C un-used un-used<br>
Request 28 system bus req[0] 0x0070 NAND DATA un-used<br>
Request 29 system bus req[1] 0x0074 NAND CMD un-used<br>
Request 30 system bus req[2] 0x0078 un-used un-used<br>
Request 31 system bus req[3] 0x007C un-used un-used<br> (Instance 4 of 32)*/
//====================================================================

#define  PDMA_DMA_RCMRX3_RESERVED1_MASK 0xffffff00
#define  PDMA_DMA_RCMRX3_RESERVED1_SHIFT 8
#define  PDMA_DMA_RCMRX3_RESERVED1_MASK_SHIFT(reg) (((reg) & PDMA_DMA_RCMRX3_RESERVED1_MASK) >> PDMA_DMA_RCMRX3_RESERVED1_SHIFT)
#define  PDMA_DMA_RCMRX3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_RCMRX3_RESERVED1_MASK) | (((uint32_t)val) << PDMA_DMA_RCMRX3_RESERVED1_SHIFT))

#define  PDMA_DMA_RCMRX3_MAPVLD_MASK 0x80
#define  PDMA_DMA_RCMRX3_MAPVLD_SHIFT 7
#define  PDMA_DMA_RCMRX3_MAPVLD_MASK_SHIFT(reg) (((reg) & PDMA_DMA_RCMRX3_MAPVLD_MASK) >> PDMA_DMA_RCMRX3_MAPVLD_SHIFT)
#define  PDMA_DMA_RCMRX3_MAPVLD_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_RCMRX3_MAPVLD_MASK) | (((uint32_t)val) << PDMA_DMA_RCMRX3_MAPVLD_SHIFT))

#define  PDMA_DMA_RCMRX3_RESERVED2_MASK 0x60
#define  PDMA_DMA_RCMRX3_RESERVED2_SHIFT 5
#define  PDMA_DMA_RCMRX3_RESERVED2_MASK_SHIFT(reg) (((reg) & PDMA_DMA_RCMRX3_RESERVED2_MASK) >> PDMA_DMA_RCMRX3_RESERVED2_SHIFT)
#define  PDMA_DMA_RCMRX3_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_RCMRX3_RESERVED2_MASK) | (((uint32_t)val) << PDMA_DMA_RCMRX3_RESERVED2_SHIFT))

#define  PDMA_DMA_RCMRX3_CHLNUM_MASK 0x1f
#define  PDMA_DMA_RCMRX3_CHLNUM_SHIFT 0
#define  PDMA_DMA_RCMRX3_CHLNUM_MASK_SHIFT(reg) (((reg) & PDMA_DMA_RCMRX3_CHLNUM_MASK) >> PDMA_DMA_RCMRX3_CHLNUM_SHIFT)
#define  PDMA_DMA_RCMRX3_CHLNUM_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_RCMRX3_CHLNUM_MASK) | (((uint32_t)val) << PDMA_DMA_RCMRX3_CHLNUM_SHIFT))

//====================================================================
//Register: DMA Request to Channel Map Registers 0-31 (Instance 5 of 32) (DMA_RCMRx4)
/** \brief These registers map the DMA request to a channel.
<br>
These are read/write registers. Ignore reads from reserved bits. Write 0x0 to
reserved bits.
<br>
Here is the address offset for each of the dma requests:
<br>
Request # Request Bus Address DMA0 DMA1<br>
---------- ----------------- ------- --------- ---------<br>
Request 0 ext periph req[0] 0x0000 dreq0 un-used<br>
Request 1 ext periph req[1] 0x0004 dreq1 un-used<br>
Request 2 ext periph req[2] 0x0008 dreq2 un-used<br>
Request 3 periph bus req[0] 0x000C un-used un-used<br>
Request 4 periph bus req[1] 0x0010 UART1 RX un-used<br>
Request 5 periph bus req[2] 0x0014 UART1 TX un-used<br>
Request 6 periph bus req[3] 0x0018 un-used SSP1 RX<br>
Request 7 periph bus req[4] 0x001C un-used SSP1 TX<br>
Request 8 periph bus req[5] 0x0020 un-used un-used<br>
Request 9 periph bus req[6] 0x0024 un-used un-used<br>
Request 10 periph bus req[7] 0x0028 un-used SSP2 RX<br>
Request 11 periph bus req[8] 0x002C un-used SSP2 TX<br>
Request 12 periph bus req[9] 0x0030 SSP3 RX TWSI4 RX<br>
Request 13 periph bus req[10] 0x0034 SSP3 TX TWSI4 TX<br>
Request 14 periph bus req[11] 0x0038 TWSI1 RX TWSI5 RX<br>
Request 15 periph bus req[12] 0x003C TWSI1 TX TWSI5 TX<br>
Request 16 periph bus req[13] 0x0040 TWSI2 RX TWSI6 RX<br>
Request 17 periph bus req[14] 0x0044 TWSI2 TX TWSI6 TX<br>
Request 18 periph bus req[15] 0x0048 TWSI3 RX UART4 RX<br>
Request 19 periph bus req[16] 0x004C TWSI3 TX UART4 TX<br>
Request 20 periph bus req[17] 0x0050 un-used UART2 RX<br>
Request 21 periph bus req[18] 0x0054 un-used UART2 TX<br>
Request 22 periph bus req[19] 0x0058 UART3 RX un-used<br>
Request 23 periph bus req[20] 0x005C UART3 TX un-used<br>
Request 24 system bus req[4] 0x0060 un-used un-used<br>
Request 25 system bus req[5] 0x0064 un-used un-used<br>
Request 26 system bus req[6] 0x0068 un-used un-used<br>
Request 27 system bus req[7] 0x006C un-used un-used<br>
Request 28 system bus req[0] 0x0070 NAND DATA un-used<br>
Request 29 system bus req[1] 0x0074 NAND CMD un-used<br>
Request 30 system bus req[2] 0x0078 un-used un-used<br>
Request 31 system bus req[3] 0x007C un-used un-used<br> (Instance 5 of 32)*/
//====================================================================

#define  PDMA_DMA_RCMRX4_RESERVED1_MASK 0xffffff00
#define  PDMA_DMA_RCMRX4_RESERVED1_SHIFT 8
#define  PDMA_DMA_RCMRX4_RESERVED1_MASK_SHIFT(reg) (((reg) & PDMA_DMA_RCMRX4_RESERVED1_MASK) >> PDMA_DMA_RCMRX4_RESERVED1_SHIFT)
#define  PDMA_DMA_RCMRX4_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_RCMRX4_RESERVED1_MASK) | (((uint32_t)val) << PDMA_DMA_RCMRX4_RESERVED1_SHIFT))

#define  PDMA_DMA_RCMRX4_MAPVLD_MASK 0x80
#define  PDMA_DMA_RCMRX4_MAPVLD_SHIFT 7
#define  PDMA_DMA_RCMRX4_MAPVLD_MASK_SHIFT(reg) (((reg) & PDMA_DMA_RCMRX4_MAPVLD_MASK) >> PDMA_DMA_RCMRX4_MAPVLD_SHIFT)
#define  PDMA_DMA_RCMRX4_MAPVLD_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_RCMRX4_MAPVLD_MASK) | (((uint32_t)val) << PDMA_DMA_RCMRX4_MAPVLD_SHIFT))

#define  PDMA_DMA_RCMRX4_RESERVED2_MASK 0x60
#define  PDMA_DMA_RCMRX4_RESERVED2_SHIFT 5
#define  PDMA_DMA_RCMRX4_RESERVED2_MASK_SHIFT(reg) (((reg) & PDMA_DMA_RCMRX4_RESERVED2_MASK) >> PDMA_DMA_RCMRX4_RESERVED2_SHIFT)
#define  PDMA_DMA_RCMRX4_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_RCMRX4_RESERVED2_MASK) | (((uint32_t)val) << PDMA_DMA_RCMRX4_RESERVED2_SHIFT))

#define  PDMA_DMA_RCMRX4_CHLNUM_MASK 0x1f
#define  PDMA_DMA_RCMRX4_CHLNUM_SHIFT 0
#define  PDMA_DMA_RCMRX4_CHLNUM_MASK_SHIFT(reg) (((reg) & PDMA_DMA_RCMRX4_CHLNUM_MASK) >> PDMA_DMA_RCMRX4_CHLNUM_SHIFT)
#define  PDMA_DMA_RCMRX4_CHLNUM_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_RCMRX4_CHLNUM_MASK) | (((uint32_t)val) << PDMA_DMA_RCMRX4_CHLNUM_SHIFT))

//====================================================================
//Register: DMA Request to Channel Map Registers 0-31 (Instance 6 of 32) (DMA_RCMRx5)
/** \brief These registers map the DMA request to a channel.
<br>
These are read/write registers. Ignore reads from reserved bits. Write 0x0 to
reserved bits.
<br>
Here is the address offset for each of the dma requests:
<br>
Request # Request Bus Address DMA0 DMA1<br>
---------- ----------------- ------- --------- ---------<br>
Request 0 ext periph req[0] 0x0000 dreq0 un-used<br>
Request 1 ext periph req[1] 0x0004 dreq1 un-used<br>
Request 2 ext periph req[2] 0x0008 dreq2 un-used<br>
Request 3 periph bus req[0] 0x000C un-used un-used<br>
Request 4 periph bus req[1] 0x0010 UART1 RX un-used<br>
Request 5 periph bus req[2] 0x0014 UART1 TX un-used<br>
Request 6 periph bus req[3] 0x0018 un-used SSP1 RX<br>
Request 7 periph bus req[4] 0x001C un-used SSP1 TX<br>
Request 8 periph bus req[5] 0x0020 un-used un-used<br>
Request 9 periph bus req[6] 0x0024 un-used un-used<br>
Request 10 periph bus req[7] 0x0028 un-used SSP2 RX<br>
Request 11 periph bus req[8] 0x002C un-used SSP2 TX<br>
Request 12 periph bus req[9] 0x0030 SSP3 RX TWSI4 RX<br>
Request 13 periph bus req[10] 0x0034 SSP3 TX TWSI4 TX<br>
Request 14 periph bus req[11] 0x0038 TWSI1 RX TWSI5 RX<br>
Request 15 periph bus req[12] 0x003C TWSI1 TX TWSI5 TX<br>
Request 16 periph bus req[13] 0x0040 TWSI2 RX TWSI6 RX<br>
Request 17 periph bus req[14] 0x0044 TWSI2 TX TWSI6 TX<br>
Request 18 periph bus req[15] 0x0048 TWSI3 RX UART4 RX<br>
Request 19 periph bus req[16] 0x004C TWSI3 TX UART4 TX<br>
Request 20 periph bus req[17] 0x0050 un-used UART2 RX<br>
Request 21 periph bus req[18] 0x0054 un-used UART2 TX<br>
Request 22 periph bus req[19] 0x0058 UART3 RX un-used<br>
Request 23 periph bus req[20] 0x005C UART3 TX un-used<br>
Request 24 system bus req[4] 0x0060 un-used un-used<br>
Request 25 system bus req[5] 0x0064 un-used un-used<br>
Request 26 system bus req[6] 0x0068 un-used un-used<br>
Request 27 system bus req[7] 0x006C un-used un-used<br>
Request 28 system bus req[0] 0x0070 NAND DATA un-used<br>
Request 29 system bus req[1] 0x0074 NAND CMD un-used<br>
Request 30 system bus req[2] 0x0078 un-used un-used<br>
Request 31 system bus req[3] 0x007C un-used un-used<br> (Instance 6 of 32)*/
//====================================================================

#define  PDMA_DMA_RCMRX5_RESERVED1_MASK 0xffffff00
#define  PDMA_DMA_RCMRX5_RESERVED1_SHIFT 8
#define  PDMA_DMA_RCMRX5_RESERVED1_MASK_SHIFT(reg) (((reg) & PDMA_DMA_RCMRX5_RESERVED1_MASK) >> PDMA_DMA_RCMRX5_RESERVED1_SHIFT)
#define  PDMA_DMA_RCMRX5_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_RCMRX5_RESERVED1_MASK) | (((uint32_t)val) << PDMA_DMA_RCMRX5_RESERVED1_SHIFT))

#define  PDMA_DMA_RCMRX5_MAPVLD_MASK 0x80
#define  PDMA_DMA_RCMRX5_MAPVLD_SHIFT 7
#define  PDMA_DMA_RCMRX5_MAPVLD_MASK_SHIFT(reg) (((reg) & PDMA_DMA_RCMRX5_MAPVLD_MASK) >> PDMA_DMA_RCMRX5_MAPVLD_SHIFT)
#define  PDMA_DMA_RCMRX5_MAPVLD_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_RCMRX5_MAPVLD_MASK) | (((uint32_t)val) << PDMA_DMA_RCMRX5_MAPVLD_SHIFT))

#define  PDMA_DMA_RCMRX5_RESERVED2_MASK 0x60
#define  PDMA_DMA_RCMRX5_RESERVED2_SHIFT 5
#define  PDMA_DMA_RCMRX5_RESERVED2_MASK_SHIFT(reg) (((reg) & PDMA_DMA_RCMRX5_RESERVED2_MASK) >> PDMA_DMA_RCMRX5_RESERVED2_SHIFT)
#define  PDMA_DMA_RCMRX5_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_RCMRX5_RESERVED2_MASK) | (((uint32_t)val) << PDMA_DMA_RCMRX5_RESERVED2_SHIFT))

#define  PDMA_DMA_RCMRX5_CHLNUM_MASK 0x1f
#define  PDMA_DMA_RCMRX5_CHLNUM_SHIFT 0
#define  PDMA_DMA_RCMRX5_CHLNUM_MASK_SHIFT(reg) (((reg) & PDMA_DMA_RCMRX5_CHLNUM_MASK) >> PDMA_DMA_RCMRX5_CHLNUM_SHIFT)
#define  PDMA_DMA_RCMRX5_CHLNUM_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_RCMRX5_CHLNUM_MASK) | (((uint32_t)val) << PDMA_DMA_RCMRX5_CHLNUM_SHIFT))

//====================================================================
//Register: DMA Request to Channel Map Registers 0-31 (Instance 7 of 32) (DMA_RCMRx6)
/** \brief These registers map the DMA request to a channel.
<br>
These are read/write registers. Ignore reads from reserved bits. Write 0x0 to
reserved bits.
<br>
Here is the address offset for each of the dma requests:
<br>
Request # Request Bus Address DMA0 DMA1<br>
---------- ----------------- ------- --------- ---------<br>
Request 0 ext periph req[0] 0x0000 dreq0 un-used<br>
Request 1 ext periph req[1] 0x0004 dreq1 un-used<br>
Request 2 ext periph req[2] 0x0008 dreq2 un-used<br>
Request 3 periph bus req[0] 0x000C un-used un-used<br>
Request 4 periph bus req[1] 0x0010 UART1 RX un-used<br>
Request 5 periph bus req[2] 0x0014 UART1 TX un-used<br>
Request 6 periph bus req[3] 0x0018 un-used SSP1 RX<br>
Request 7 periph bus req[4] 0x001C un-used SSP1 TX<br>
Request 8 periph bus req[5] 0x0020 un-used un-used<br>
Request 9 periph bus req[6] 0x0024 un-used un-used<br>
Request 10 periph bus req[7] 0x0028 un-used SSP2 RX<br>
Request 11 periph bus req[8] 0x002C un-used SSP2 TX<br>
Request 12 periph bus req[9] 0x0030 SSP3 RX TWSI4 RX<br>
Request 13 periph bus req[10] 0x0034 SSP3 TX TWSI4 TX<br>
Request 14 periph bus req[11] 0x0038 TWSI1 RX TWSI5 RX<br>
Request 15 periph bus req[12] 0x003C TWSI1 TX TWSI5 TX<br>
Request 16 periph bus req[13] 0x0040 TWSI2 RX TWSI6 RX<br>
Request 17 periph bus req[14] 0x0044 TWSI2 TX TWSI6 TX<br>
Request 18 periph bus req[15] 0x0048 TWSI3 RX UART4 RX<br>
Request 19 periph bus req[16] 0x004C TWSI3 TX UART4 TX<br>
Request 20 periph bus req[17] 0x0050 un-used UART2 RX<br>
Request 21 periph bus req[18] 0x0054 un-used UART2 TX<br>
Request 22 periph bus req[19] 0x0058 UART3 RX un-used<br>
Request 23 periph bus req[20] 0x005C UART3 TX un-used<br>
Request 24 system bus req[4] 0x0060 un-used un-used<br>
Request 25 system bus req[5] 0x0064 un-used un-used<br>
Request 26 system bus req[6] 0x0068 un-used un-used<br>
Request 27 system bus req[7] 0x006C un-used un-used<br>
Request 28 system bus req[0] 0x0070 NAND DATA un-used<br>
Request 29 system bus req[1] 0x0074 NAND CMD un-used<br>
Request 30 system bus req[2] 0x0078 un-used un-used<br>
Request 31 system bus req[3] 0x007C un-used un-used<br> (Instance 7 of 32)*/
//====================================================================

#define  PDMA_DMA_RCMRX6_RESERVED1_MASK 0xffffff00
#define  PDMA_DMA_RCMRX6_RESERVED1_SHIFT 8
#define  PDMA_DMA_RCMRX6_RESERVED1_MASK_SHIFT(reg) (((reg) & PDMA_DMA_RCMRX6_RESERVED1_MASK) >> PDMA_DMA_RCMRX6_RESERVED1_SHIFT)
#define  PDMA_DMA_RCMRX6_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_RCMRX6_RESERVED1_MASK) | (((uint32_t)val) << PDMA_DMA_RCMRX6_RESERVED1_SHIFT))

#define  PDMA_DMA_RCMRX6_MAPVLD_MASK 0x80
#define  PDMA_DMA_RCMRX6_MAPVLD_SHIFT 7
#define  PDMA_DMA_RCMRX6_MAPVLD_MASK_SHIFT(reg) (((reg) & PDMA_DMA_RCMRX6_MAPVLD_MASK) >> PDMA_DMA_RCMRX6_MAPVLD_SHIFT)
#define  PDMA_DMA_RCMRX6_MAPVLD_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_RCMRX6_MAPVLD_MASK) | (((uint32_t)val) << PDMA_DMA_RCMRX6_MAPVLD_SHIFT))

#define  PDMA_DMA_RCMRX6_RESERVED2_MASK 0x60
#define  PDMA_DMA_RCMRX6_RESERVED2_SHIFT 5
#define  PDMA_DMA_RCMRX6_RESERVED2_MASK_SHIFT(reg) (((reg) & PDMA_DMA_RCMRX6_RESERVED2_MASK) >> PDMA_DMA_RCMRX6_RESERVED2_SHIFT)
#define  PDMA_DMA_RCMRX6_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_RCMRX6_RESERVED2_MASK) | (((uint32_t)val) << PDMA_DMA_RCMRX6_RESERVED2_SHIFT))

#define  PDMA_DMA_RCMRX6_CHLNUM_MASK 0x1f
#define  PDMA_DMA_RCMRX6_CHLNUM_SHIFT 0
#define  PDMA_DMA_RCMRX6_CHLNUM_MASK_SHIFT(reg) (((reg) & PDMA_DMA_RCMRX6_CHLNUM_MASK) >> PDMA_DMA_RCMRX6_CHLNUM_SHIFT)
#define  PDMA_DMA_RCMRX6_CHLNUM_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_RCMRX6_CHLNUM_MASK) | (((uint32_t)val) << PDMA_DMA_RCMRX6_CHLNUM_SHIFT))

//====================================================================
//Register: DMA Request to Channel Map Registers 0-31 (Instance 8 of 32) (DMA_RCMRx7)
/** \brief These registers map the DMA request to a channel.
<br>
These are read/write registers. Ignore reads from reserved bits. Write 0x0 to
reserved bits.
<br>
Here is the address offset for each of the dma requests:
<br>
Request # Request Bus Address DMA0 DMA1<br>
---------- ----------------- ------- --------- ---------<br>
Request 0 ext periph req[0] 0x0000 dreq0 un-used<br>
Request 1 ext periph req[1] 0x0004 dreq1 un-used<br>
Request 2 ext periph req[2] 0x0008 dreq2 un-used<br>
Request 3 periph bus req[0] 0x000C un-used un-used<br>
Request 4 periph bus req[1] 0x0010 UART1 RX un-used<br>
Request 5 periph bus req[2] 0x0014 UART1 TX un-used<br>
Request 6 periph bus req[3] 0x0018 un-used SSP1 RX<br>
Request 7 periph bus req[4] 0x001C un-used SSP1 TX<br>
Request 8 periph bus req[5] 0x0020 un-used un-used<br>
Request 9 periph bus req[6] 0x0024 un-used un-used<br>
Request 10 periph bus req[7] 0x0028 un-used SSP2 RX<br>
Request 11 periph bus req[8] 0x002C un-used SSP2 TX<br>
Request 12 periph bus req[9] 0x0030 SSP3 RX TWSI4 RX<br>
Request 13 periph bus req[10] 0x0034 SSP3 TX TWSI4 TX<br>
Request 14 periph bus req[11] 0x0038 TWSI1 RX TWSI5 RX<br>
Request 15 periph bus req[12] 0x003C TWSI1 TX TWSI5 TX<br>
Request 16 periph bus req[13] 0x0040 TWSI2 RX TWSI6 RX<br>
Request 17 periph bus req[14] 0x0044 TWSI2 TX TWSI6 TX<br>
Request 18 periph bus req[15] 0x0048 TWSI3 RX UART4 RX<br>
Request 19 periph bus req[16] 0x004C TWSI3 TX UART4 TX<br>
Request 20 periph bus req[17] 0x0050 un-used UART2 RX<br>
Request 21 periph bus req[18] 0x0054 un-used UART2 TX<br>
Request 22 periph bus req[19] 0x0058 UART3 RX un-used<br>
Request 23 periph bus req[20] 0x005C UART3 TX un-used<br>
Request 24 system bus req[4] 0x0060 un-used un-used<br>
Request 25 system bus req[5] 0x0064 un-used un-used<br>
Request 26 system bus req[6] 0x0068 un-used un-used<br>
Request 27 system bus req[7] 0x006C un-used un-used<br>
Request 28 system bus req[0] 0x0070 NAND DATA un-used<br>
Request 29 system bus req[1] 0x0074 NAND CMD un-used<br>
Request 30 system bus req[2] 0x0078 un-used un-used<br>
Request 31 system bus req[3] 0x007C un-used un-used<br> (Instance 8 of 32)*/
//====================================================================

#define  PDMA_DMA_RCMRX7_RESERVED1_MASK 0xffffff00
#define  PDMA_DMA_RCMRX7_RESERVED1_SHIFT 8
#define  PDMA_DMA_RCMRX7_RESERVED1_MASK_SHIFT(reg) (((reg) & PDMA_DMA_RCMRX7_RESERVED1_MASK) >> PDMA_DMA_RCMRX7_RESERVED1_SHIFT)
#define  PDMA_DMA_RCMRX7_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_RCMRX7_RESERVED1_MASK) | (((uint32_t)val) << PDMA_DMA_RCMRX7_RESERVED1_SHIFT))

#define  PDMA_DMA_RCMRX7_MAPVLD_MASK 0x80
#define  PDMA_DMA_RCMRX7_MAPVLD_SHIFT 7
#define  PDMA_DMA_RCMRX7_MAPVLD_MASK_SHIFT(reg) (((reg) & PDMA_DMA_RCMRX7_MAPVLD_MASK) >> PDMA_DMA_RCMRX7_MAPVLD_SHIFT)
#define  PDMA_DMA_RCMRX7_MAPVLD_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_RCMRX7_MAPVLD_MASK) | (((uint32_t)val) << PDMA_DMA_RCMRX7_MAPVLD_SHIFT))

#define  PDMA_DMA_RCMRX7_RESERVED2_MASK 0x60
#define  PDMA_DMA_RCMRX7_RESERVED2_SHIFT 5
#define  PDMA_DMA_RCMRX7_RESERVED2_MASK_SHIFT(reg) (((reg) & PDMA_DMA_RCMRX7_RESERVED2_MASK) >> PDMA_DMA_RCMRX7_RESERVED2_SHIFT)
#define  PDMA_DMA_RCMRX7_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_RCMRX7_RESERVED2_MASK) | (((uint32_t)val) << PDMA_DMA_RCMRX7_RESERVED2_SHIFT))

#define  PDMA_DMA_RCMRX7_CHLNUM_MASK 0x1f
#define  PDMA_DMA_RCMRX7_CHLNUM_SHIFT 0
#define  PDMA_DMA_RCMRX7_CHLNUM_MASK_SHIFT(reg) (((reg) & PDMA_DMA_RCMRX7_CHLNUM_MASK) >> PDMA_DMA_RCMRX7_CHLNUM_SHIFT)
#define  PDMA_DMA_RCMRX7_CHLNUM_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_RCMRX7_CHLNUM_MASK) | (((uint32_t)val) << PDMA_DMA_RCMRX7_CHLNUM_SHIFT))

//====================================================================
//Register: DMA Request to Channel Map Registers 0-31 (Instance 9 of 32) (DMA_RCMRx8)
/** \brief These registers map the DMA request to a channel.
<br>
These are read/write registers. Ignore reads from reserved bits. Write 0x0 to
reserved bits.
<br>
Here is the address offset for each of the dma requests:
<br>
Request # Request Bus Address DMA0 DMA1<br>
---------- ----------------- ------- --------- ---------<br>
Request 0 ext periph req[0] 0x0000 dreq0 un-used<br>
Request 1 ext periph req[1] 0x0004 dreq1 un-used<br>
Request 2 ext periph req[2] 0x0008 dreq2 un-used<br>
Request 3 periph bus req[0] 0x000C un-used un-used<br>
Request 4 periph bus req[1] 0x0010 UART1 RX un-used<br>
Request 5 periph bus req[2] 0x0014 UART1 TX un-used<br>
Request 6 periph bus req[3] 0x0018 un-used SSP1 RX<br>
Request 7 periph bus req[4] 0x001C un-used SSP1 TX<br>
Request 8 periph bus req[5] 0x0020 un-used un-used<br>
Request 9 periph bus req[6] 0x0024 un-used un-used<br>
Request 10 periph bus req[7] 0x0028 un-used SSP2 RX<br>
Request 11 periph bus req[8] 0x002C un-used SSP2 TX<br>
Request 12 periph bus req[9] 0x0030 SSP3 RX TWSI4 RX<br>
Request 13 periph bus req[10] 0x0034 SSP3 TX TWSI4 TX<br>
Request 14 periph bus req[11] 0x0038 TWSI1 RX TWSI5 RX<br>
Request 15 periph bus req[12] 0x003C TWSI1 TX TWSI5 TX<br>
Request 16 periph bus req[13] 0x0040 TWSI2 RX TWSI6 RX<br>
Request 17 periph bus req[14] 0x0044 TWSI2 TX TWSI6 TX<br>
Request 18 periph bus req[15] 0x0048 TWSI3 RX UART4 RX<br>
Request 19 periph bus req[16] 0x004C TWSI3 TX UART4 TX<br>
Request 20 periph bus req[17] 0x0050 un-used UART2 RX<br>
Request 21 periph bus req[18] 0x0054 un-used UART2 TX<br>
Request 22 periph bus req[19] 0x0058 UART3 RX un-used<br>
Request 23 periph bus req[20] 0x005C UART3 TX un-used<br>
Request 24 system bus req[4] 0x0060 un-used un-used<br>
Request 25 system bus req[5] 0x0064 un-used un-used<br>
Request 26 system bus req[6] 0x0068 un-used un-used<br>
Request 27 system bus req[7] 0x006C un-used un-used<br>
Request 28 system bus req[0] 0x0070 NAND DATA un-used<br>
Request 29 system bus req[1] 0x0074 NAND CMD un-used<br>
Request 30 system bus req[2] 0x0078 un-used un-used<br>
Request 31 system bus req[3] 0x007C un-used un-used<br> (Instance 9 of 32)*/
//====================================================================

#define  PDMA_DMA_RCMRX8_RESERVED1_MASK 0xffffff00
#define  PDMA_DMA_RCMRX8_RESERVED1_SHIFT 8
#define  PDMA_DMA_RCMRX8_RESERVED1_MASK_SHIFT(reg) (((reg) & PDMA_DMA_RCMRX8_RESERVED1_MASK) >> PDMA_DMA_RCMRX8_RESERVED1_SHIFT)
#define  PDMA_DMA_RCMRX8_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_RCMRX8_RESERVED1_MASK) | (((uint32_t)val) << PDMA_DMA_RCMRX8_RESERVED1_SHIFT))

#define  PDMA_DMA_RCMRX8_MAPVLD_MASK 0x80
#define  PDMA_DMA_RCMRX8_MAPVLD_SHIFT 7
#define  PDMA_DMA_RCMRX8_MAPVLD_MASK_SHIFT(reg) (((reg) & PDMA_DMA_RCMRX8_MAPVLD_MASK) >> PDMA_DMA_RCMRX8_MAPVLD_SHIFT)
#define  PDMA_DMA_RCMRX8_MAPVLD_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_RCMRX8_MAPVLD_MASK) | (((uint32_t)val) << PDMA_DMA_RCMRX8_MAPVLD_SHIFT))

#define  PDMA_DMA_RCMRX8_RESERVED2_MASK 0x60
#define  PDMA_DMA_RCMRX8_RESERVED2_SHIFT 5
#define  PDMA_DMA_RCMRX8_RESERVED2_MASK_SHIFT(reg) (((reg) & PDMA_DMA_RCMRX8_RESERVED2_MASK) >> PDMA_DMA_RCMRX8_RESERVED2_SHIFT)
#define  PDMA_DMA_RCMRX8_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_RCMRX8_RESERVED2_MASK) | (((uint32_t)val) << PDMA_DMA_RCMRX8_RESERVED2_SHIFT))

#define  PDMA_DMA_RCMRX8_CHLNUM_MASK 0x1f
#define  PDMA_DMA_RCMRX8_CHLNUM_SHIFT 0
#define  PDMA_DMA_RCMRX8_CHLNUM_MASK_SHIFT(reg) (((reg) & PDMA_DMA_RCMRX8_CHLNUM_MASK) >> PDMA_DMA_RCMRX8_CHLNUM_SHIFT)
#define  PDMA_DMA_RCMRX8_CHLNUM_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_RCMRX8_CHLNUM_MASK) | (((uint32_t)val) << PDMA_DMA_RCMRX8_CHLNUM_SHIFT))

//====================================================================
//Register: DMA Request to Channel Map Registers 0-31 (Instance 10 of 32) (DMA_RCMRx9)
/** \brief These registers map the DMA request to a channel.
<br>
These are read/write registers. Ignore reads from reserved bits. Write 0x0 to
reserved bits.
<br>
Here is the address offset for each of the dma requests:
<br>
Request # Request Bus Address DMA0 DMA1<br>
---------- ----------------- ------- --------- ---------<br>
Request 0 ext periph req[0] 0x0000 dreq0 un-used<br>
Request 1 ext periph req[1] 0x0004 dreq1 un-used<br>
Request 2 ext periph req[2] 0x0008 dreq2 un-used<br>
Request 3 periph bus req[0] 0x000C un-used un-used<br>
Request 4 periph bus req[1] 0x0010 UART1 RX un-used<br>
Request 5 periph bus req[2] 0x0014 UART1 TX un-used<br>
Request 6 periph bus req[3] 0x0018 un-used SSP1 RX<br>
Request 7 periph bus req[4] 0x001C un-used SSP1 TX<br>
Request 8 periph bus req[5] 0x0020 un-used un-used<br>
Request 9 periph bus req[6] 0x0024 un-used un-used<br>
Request 10 periph bus req[7] 0x0028 un-used SSP2 RX<br>
Request 11 periph bus req[8] 0x002C un-used SSP2 TX<br>
Request 12 periph bus req[9] 0x0030 SSP3 RX TWSI4 RX<br>
Request 13 periph bus req[10] 0x0034 SSP3 TX TWSI4 TX<br>
Request 14 periph bus req[11] 0x0038 TWSI1 RX TWSI5 RX<br>
Request 15 periph bus req[12] 0x003C TWSI1 TX TWSI5 TX<br>
Request 16 periph bus req[13] 0x0040 TWSI2 RX TWSI6 RX<br>
Request 17 periph bus req[14] 0x0044 TWSI2 TX TWSI6 TX<br>
Request 18 periph bus req[15] 0x0048 TWSI3 RX UART4 RX<br>
Request 19 periph bus req[16] 0x004C TWSI3 TX UART4 TX<br>
Request 20 periph bus req[17] 0x0050 un-used UART2 RX<br>
Request 21 periph bus req[18] 0x0054 un-used UART2 TX<br>
Request 22 periph bus req[19] 0x0058 UART3 RX un-used<br>
Request 23 periph bus req[20] 0x005C UART3 TX un-used<br>
Request 24 system bus req[4] 0x0060 un-used un-used<br>
Request 25 system bus req[5] 0x0064 un-used un-used<br>
Request 26 system bus req[6] 0x0068 un-used un-used<br>
Request 27 system bus req[7] 0x006C un-used un-used<br>
Request 28 system bus req[0] 0x0070 NAND DATA un-used<br>
Request 29 system bus req[1] 0x0074 NAND CMD un-used<br>
Request 30 system bus req[2] 0x0078 un-used un-used<br>
Request 31 system bus req[3] 0x007C un-used un-used<br> (Instance 10 of 32)*/
//====================================================================

#define  PDMA_DMA_RCMRX9_RESERVED1_MASK 0xffffff00
#define  PDMA_DMA_RCMRX9_RESERVED1_SHIFT 8
#define  PDMA_DMA_RCMRX9_RESERVED1_MASK_SHIFT(reg) (((reg) & PDMA_DMA_RCMRX9_RESERVED1_MASK) >> PDMA_DMA_RCMRX9_RESERVED1_SHIFT)
#define  PDMA_DMA_RCMRX9_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_RCMRX9_RESERVED1_MASK) | (((uint32_t)val) << PDMA_DMA_RCMRX9_RESERVED1_SHIFT))

#define  PDMA_DMA_RCMRX9_MAPVLD_MASK 0x80
#define  PDMA_DMA_RCMRX9_MAPVLD_SHIFT 7
#define  PDMA_DMA_RCMRX9_MAPVLD_MASK_SHIFT(reg) (((reg) & PDMA_DMA_RCMRX9_MAPVLD_MASK) >> PDMA_DMA_RCMRX9_MAPVLD_SHIFT)
#define  PDMA_DMA_RCMRX9_MAPVLD_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_RCMRX9_MAPVLD_MASK) | (((uint32_t)val) << PDMA_DMA_RCMRX9_MAPVLD_SHIFT))

#define  PDMA_DMA_RCMRX9_RESERVED2_MASK 0x60
#define  PDMA_DMA_RCMRX9_RESERVED2_SHIFT 5
#define  PDMA_DMA_RCMRX9_RESERVED2_MASK_SHIFT(reg) (((reg) & PDMA_DMA_RCMRX9_RESERVED2_MASK) >> PDMA_DMA_RCMRX9_RESERVED2_SHIFT)
#define  PDMA_DMA_RCMRX9_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_RCMRX9_RESERVED2_MASK) | (((uint32_t)val) << PDMA_DMA_RCMRX9_RESERVED2_SHIFT))

#define  PDMA_DMA_RCMRX9_CHLNUM_MASK 0x1f
#define  PDMA_DMA_RCMRX9_CHLNUM_SHIFT 0
#define  PDMA_DMA_RCMRX9_CHLNUM_MASK_SHIFT(reg) (((reg) & PDMA_DMA_RCMRX9_CHLNUM_MASK) >> PDMA_DMA_RCMRX9_CHLNUM_SHIFT)
#define  PDMA_DMA_RCMRX9_CHLNUM_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_RCMRX9_CHLNUM_MASK) | (((uint32_t)val) << PDMA_DMA_RCMRX9_CHLNUM_SHIFT))

//====================================================================
//Register: DMA Request to Channel Map Registers 0-31 (Instance 11 of 32) (DMA_RCMRx10)
/** \brief These registers map the DMA request to a channel.
<br>
These are read/write registers. Ignore reads from reserved bits. Write 0x0 to
reserved bits.
<br>
Here is the address offset for each of the dma requests:
<br>
Request # Request Bus Address DMA0 DMA1<br>
---------- ----------------- ------- --------- ---------<br>
Request 0 ext periph req[0] 0x0000 dreq0 un-used<br>
Request 1 ext periph req[1] 0x0004 dreq1 un-used<br>
Request 2 ext periph req[2] 0x0008 dreq2 un-used<br>
Request 3 periph bus req[0] 0x000C un-used un-used<br>
Request 4 periph bus req[1] 0x0010 UART1 RX un-used<br>
Request 5 periph bus req[2] 0x0014 UART1 TX un-used<br>
Request 6 periph bus req[3] 0x0018 un-used SSP1 RX<br>
Request 7 periph bus req[4] 0x001C un-used SSP1 TX<br>
Request 8 periph bus req[5] 0x0020 un-used un-used<br>
Request 9 periph bus req[6] 0x0024 un-used un-used<br>
Request 10 periph bus req[7] 0x0028 un-used SSP2 RX<br>
Request 11 periph bus req[8] 0x002C un-used SSP2 TX<br>
Request 12 periph bus req[9] 0x0030 SSP3 RX TWSI4 RX<br>
Request 13 periph bus req[10] 0x0034 SSP3 TX TWSI4 TX<br>
Request 14 periph bus req[11] 0x0038 TWSI1 RX TWSI5 RX<br>
Request 15 periph bus req[12] 0x003C TWSI1 TX TWSI5 TX<br>
Request 16 periph bus req[13] 0x0040 TWSI2 RX TWSI6 RX<br>
Request 17 periph bus req[14] 0x0044 TWSI2 TX TWSI6 TX<br>
Request 18 periph bus req[15] 0x0048 TWSI3 RX UART4 RX<br>
Request 19 periph bus req[16] 0x004C TWSI3 TX UART4 TX<br>
Request 20 periph bus req[17] 0x0050 un-used UART2 RX<br>
Request 21 periph bus req[18] 0x0054 un-used UART2 TX<br>
Request 22 periph bus req[19] 0x0058 UART3 RX un-used<br>
Request 23 periph bus req[20] 0x005C UART3 TX un-used<br>
Request 24 system bus req[4] 0x0060 un-used un-used<br>
Request 25 system bus req[5] 0x0064 un-used un-used<br>
Request 26 system bus req[6] 0x0068 un-used un-used<br>
Request 27 system bus req[7] 0x006C un-used un-used<br>
Request 28 system bus req[0] 0x0070 NAND DATA un-used<br>
Request 29 system bus req[1] 0x0074 NAND CMD un-used<br>
Request 30 system bus req[2] 0x0078 un-used un-used<br>
Request 31 system bus req[3] 0x007C un-used un-used<br> (Instance 11 of 32)*/
//====================================================================

#define  PDMA_DMA_RCMRX10_RESERVED1_MASK 0xffffff00
#define  PDMA_DMA_RCMRX10_RESERVED1_SHIFT 8
#define  PDMA_DMA_RCMRX10_RESERVED1_MASK_SHIFT(reg) (((reg) & PDMA_DMA_RCMRX10_RESERVED1_MASK) >> PDMA_DMA_RCMRX10_RESERVED1_SHIFT)
#define  PDMA_DMA_RCMRX10_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_RCMRX10_RESERVED1_MASK) | (((uint32_t)val) << PDMA_DMA_RCMRX10_RESERVED1_SHIFT))

#define  PDMA_DMA_RCMRX10_MAPVLD_MASK 0x80
#define  PDMA_DMA_RCMRX10_MAPVLD_SHIFT 7
#define  PDMA_DMA_RCMRX10_MAPVLD_MASK_SHIFT(reg) (((reg) & PDMA_DMA_RCMRX10_MAPVLD_MASK) >> PDMA_DMA_RCMRX10_MAPVLD_SHIFT)
#define  PDMA_DMA_RCMRX10_MAPVLD_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_RCMRX10_MAPVLD_MASK) | (((uint32_t)val) << PDMA_DMA_RCMRX10_MAPVLD_SHIFT))

#define  PDMA_DMA_RCMRX10_RESERVED2_MASK 0x60
#define  PDMA_DMA_RCMRX10_RESERVED2_SHIFT 5
#define  PDMA_DMA_RCMRX10_RESERVED2_MASK_SHIFT(reg) (((reg) & PDMA_DMA_RCMRX10_RESERVED2_MASK) >> PDMA_DMA_RCMRX10_RESERVED2_SHIFT)
#define  PDMA_DMA_RCMRX10_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_RCMRX10_RESERVED2_MASK) | (((uint32_t)val) << PDMA_DMA_RCMRX10_RESERVED2_SHIFT))

#define  PDMA_DMA_RCMRX10_CHLNUM_MASK 0x1f
#define  PDMA_DMA_RCMRX10_CHLNUM_SHIFT 0
#define  PDMA_DMA_RCMRX10_CHLNUM_MASK_SHIFT(reg) (((reg) & PDMA_DMA_RCMRX10_CHLNUM_MASK) >> PDMA_DMA_RCMRX10_CHLNUM_SHIFT)
#define  PDMA_DMA_RCMRX10_CHLNUM_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_RCMRX10_CHLNUM_MASK) | (((uint32_t)val) << PDMA_DMA_RCMRX10_CHLNUM_SHIFT))

//====================================================================
//Register: DMA Request to Channel Map Registers 0-31 (Instance 12 of 32) (DMA_RCMRx11)
/** \brief These registers map the DMA request to a channel.
<br>
These are read/write registers. Ignore reads from reserved bits. Write 0x0 to
reserved bits.
<br>
Here is the address offset for each of the dma requests:
<br>
Request # Request Bus Address DMA0 DMA1<br>
---------- ----------------- ------- --------- ---------<br>
Request 0 ext periph req[0] 0x0000 dreq0 un-used<br>
Request 1 ext periph req[1] 0x0004 dreq1 un-used<br>
Request 2 ext periph req[2] 0x0008 dreq2 un-used<br>
Request 3 periph bus req[0] 0x000C un-used un-used<br>
Request 4 periph bus req[1] 0x0010 UART1 RX un-used<br>
Request 5 periph bus req[2] 0x0014 UART1 TX un-used<br>
Request 6 periph bus req[3] 0x0018 un-used SSP1 RX<br>
Request 7 periph bus req[4] 0x001C un-used SSP1 TX<br>
Request 8 periph bus req[5] 0x0020 un-used un-used<br>
Request 9 periph bus req[6] 0x0024 un-used un-used<br>
Request 10 periph bus req[7] 0x0028 un-used SSP2 RX<br>
Request 11 periph bus req[8] 0x002C un-used SSP2 TX<br>
Request 12 periph bus req[9] 0x0030 SSP3 RX TWSI4 RX<br>
Request 13 periph bus req[10] 0x0034 SSP3 TX TWSI4 TX<br>
Request 14 periph bus req[11] 0x0038 TWSI1 RX TWSI5 RX<br>
Request 15 periph bus req[12] 0x003C TWSI1 TX TWSI5 TX<br>
Request 16 periph bus req[13] 0x0040 TWSI2 RX TWSI6 RX<br>
Request 17 periph bus req[14] 0x0044 TWSI2 TX TWSI6 TX<br>
Request 18 periph bus req[15] 0x0048 TWSI3 RX UART4 RX<br>
Request 19 periph bus req[16] 0x004C TWSI3 TX UART4 TX<br>
Request 20 periph bus req[17] 0x0050 un-used UART2 RX<br>
Request 21 periph bus req[18] 0x0054 un-used UART2 TX<br>
Request 22 periph bus req[19] 0x0058 UART3 RX un-used<br>
Request 23 periph bus req[20] 0x005C UART3 TX un-used<br>
Request 24 system bus req[4] 0x0060 un-used un-used<br>
Request 25 system bus req[5] 0x0064 un-used un-used<br>
Request 26 system bus req[6] 0x0068 un-used un-used<br>
Request 27 system bus req[7] 0x006C un-used un-used<br>
Request 28 system bus req[0] 0x0070 NAND DATA un-used<br>
Request 29 system bus req[1] 0x0074 NAND CMD un-used<br>
Request 30 system bus req[2] 0x0078 un-used un-used<br>
Request 31 system bus req[3] 0x007C un-used un-used<br> (Instance 12 of 32)*/
//====================================================================

#define  PDMA_DMA_RCMRX11_RESERVED1_MASK 0xffffff00
#define  PDMA_DMA_RCMRX11_RESERVED1_SHIFT 8
#define  PDMA_DMA_RCMRX11_RESERVED1_MASK_SHIFT(reg) (((reg) & PDMA_DMA_RCMRX11_RESERVED1_MASK) >> PDMA_DMA_RCMRX11_RESERVED1_SHIFT)
#define  PDMA_DMA_RCMRX11_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_RCMRX11_RESERVED1_MASK) | (((uint32_t)val) << PDMA_DMA_RCMRX11_RESERVED1_SHIFT))

#define  PDMA_DMA_RCMRX11_MAPVLD_MASK 0x80
#define  PDMA_DMA_RCMRX11_MAPVLD_SHIFT 7
#define  PDMA_DMA_RCMRX11_MAPVLD_MASK_SHIFT(reg) (((reg) & PDMA_DMA_RCMRX11_MAPVLD_MASK) >> PDMA_DMA_RCMRX11_MAPVLD_SHIFT)
#define  PDMA_DMA_RCMRX11_MAPVLD_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_RCMRX11_MAPVLD_MASK) | (((uint32_t)val) << PDMA_DMA_RCMRX11_MAPVLD_SHIFT))

#define  PDMA_DMA_RCMRX11_RESERVED2_MASK 0x60
#define  PDMA_DMA_RCMRX11_RESERVED2_SHIFT 5
#define  PDMA_DMA_RCMRX11_RESERVED2_MASK_SHIFT(reg) (((reg) & PDMA_DMA_RCMRX11_RESERVED2_MASK) >> PDMA_DMA_RCMRX11_RESERVED2_SHIFT)
#define  PDMA_DMA_RCMRX11_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_RCMRX11_RESERVED2_MASK) | (((uint32_t)val) << PDMA_DMA_RCMRX11_RESERVED2_SHIFT))

#define  PDMA_DMA_RCMRX11_CHLNUM_MASK 0x1f
#define  PDMA_DMA_RCMRX11_CHLNUM_SHIFT 0
#define  PDMA_DMA_RCMRX11_CHLNUM_MASK_SHIFT(reg) (((reg) & PDMA_DMA_RCMRX11_CHLNUM_MASK) >> PDMA_DMA_RCMRX11_CHLNUM_SHIFT)
#define  PDMA_DMA_RCMRX11_CHLNUM_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_RCMRX11_CHLNUM_MASK) | (((uint32_t)val) << PDMA_DMA_RCMRX11_CHLNUM_SHIFT))

//====================================================================
//Register: DMA Request to Channel Map Registers 0-31 (Instance 13 of 32) (DMA_RCMRx12)
/** \brief These registers map the DMA request to a channel.
<br>
These are read/write registers. Ignore reads from reserved bits. Write 0x0 to
reserved bits.
<br>
Here is the address offset for each of the dma requests:
<br>
Request # Request Bus Address DMA0 DMA1<br>
---------- ----------------- ------- --------- ---------<br>
Request 0 ext periph req[0] 0x0000 dreq0 un-used<br>
Request 1 ext periph req[1] 0x0004 dreq1 un-used<br>
Request 2 ext periph req[2] 0x0008 dreq2 un-used<br>
Request 3 periph bus req[0] 0x000C un-used un-used<br>
Request 4 periph bus req[1] 0x0010 UART1 RX un-used<br>
Request 5 periph bus req[2] 0x0014 UART1 TX un-used<br>
Request 6 periph bus req[3] 0x0018 un-used SSP1 RX<br>
Request 7 periph bus req[4] 0x001C un-used SSP1 TX<br>
Request 8 periph bus req[5] 0x0020 un-used un-used<br>
Request 9 periph bus req[6] 0x0024 un-used un-used<br>
Request 10 periph bus req[7] 0x0028 un-used SSP2 RX<br>
Request 11 periph bus req[8] 0x002C un-used SSP2 TX<br>
Request 12 periph bus req[9] 0x0030 SSP3 RX TWSI4 RX<br>
Request 13 periph bus req[10] 0x0034 SSP3 TX TWSI4 TX<br>
Request 14 periph bus req[11] 0x0038 TWSI1 RX TWSI5 RX<br>
Request 15 periph bus req[12] 0x003C TWSI1 TX TWSI5 TX<br>
Request 16 periph bus req[13] 0x0040 TWSI2 RX TWSI6 RX<br>
Request 17 periph bus req[14] 0x0044 TWSI2 TX TWSI6 TX<br>
Request 18 periph bus req[15] 0x0048 TWSI3 RX UART4 RX<br>
Request 19 periph bus req[16] 0x004C TWSI3 TX UART4 TX<br>
Request 20 periph bus req[17] 0x0050 un-used UART2 RX<br>
Request 21 periph bus req[18] 0x0054 un-used UART2 TX<br>
Request 22 periph bus req[19] 0x0058 UART3 RX un-used<br>
Request 23 periph bus req[20] 0x005C UART3 TX un-used<br>
Request 24 system bus req[4] 0x0060 un-used un-used<br>
Request 25 system bus req[5] 0x0064 un-used un-used<br>
Request 26 system bus req[6] 0x0068 un-used un-used<br>
Request 27 system bus req[7] 0x006C un-used un-used<br>
Request 28 system bus req[0] 0x0070 NAND DATA un-used<br>
Request 29 system bus req[1] 0x0074 NAND CMD un-used<br>
Request 30 system bus req[2] 0x0078 un-used un-used<br>
Request 31 system bus req[3] 0x007C un-used un-used<br> (Instance 13 of 32)*/
//====================================================================

#define  PDMA_DMA_RCMRX12_RESERVED1_MASK 0xffffff00
#define  PDMA_DMA_RCMRX12_RESERVED1_SHIFT 8
#define  PDMA_DMA_RCMRX12_RESERVED1_MASK_SHIFT(reg) (((reg) & PDMA_DMA_RCMRX12_RESERVED1_MASK) >> PDMA_DMA_RCMRX12_RESERVED1_SHIFT)
#define  PDMA_DMA_RCMRX12_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_RCMRX12_RESERVED1_MASK) | (((uint32_t)val) << PDMA_DMA_RCMRX12_RESERVED1_SHIFT))

#define  PDMA_DMA_RCMRX12_MAPVLD_MASK 0x80
#define  PDMA_DMA_RCMRX12_MAPVLD_SHIFT 7
#define  PDMA_DMA_RCMRX12_MAPVLD_MASK_SHIFT(reg) (((reg) & PDMA_DMA_RCMRX12_MAPVLD_MASK) >> PDMA_DMA_RCMRX12_MAPVLD_SHIFT)
#define  PDMA_DMA_RCMRX12_MAPVLD_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_RCMRX12_MAPVLD_MASK) | (((uint32_t)val) << PDMA_DMA_RCMRX12_MAPVLD_SHIFT))

#define  PDMA_DMA_RCMRX12_RESERVED2_MASK 0x60
#define  PDMA_DMA_RCMRX12_RESERVED2_SHIFT 5
#define  PDMA_DMA_RCMRX12_RESERVED2_MASK_SHIFT(reg) (((reg) & PDMA_DMA_RCMRX12_RESERVED2_MASK) >> PDMA_DMA_RCMRX12_RESERVED2_SHIFT)
#define  PDMA_DMA_RCMRX12_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_RCMRX12_RESERVED2_MASK) | (((uint32_t)val) << PDMA_DMA_RCMRX12_RESERVED2_SHIFT))

#define  PDMA_DMA_RCMRX12_CHLNUM_MASK 0x1f
#define  PDMA_DMA_RCMRX12_CHLNUM_SHIFT 0
#define  PDMA_DMA_RCMRX12_CHLNUM_MASK_SHIFT(reg) (((reg) & PDMA_DMA_RCMRX12_CHLNUM_MASK) >> PDMA_DMA_RCMRX12_CHLNUM_SHIFT)
#define  PDMA_DMA_RCMRX12_CHLNUM_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_RCMRX12_CHLNUM_MASK) | (((uint32_t)val) << PDMA_DMA_RCMRX12_CHLNUM_SHIFT))

//====================================================================
//Register: DMA Request to Channel Map Registers 0-31 (Instance 14 of 32) (DMA_RCMRx13)
/** \brief These registers map the DMA request to a channel.
<br>
These are read/write registers. Ignore reads from reserved bits. Write 0x0 to
reserved bits.
<br>
Here is the address offset for each of the dma requests:
<br>
Request # Request Bus Address DMA0 DMA1<br>
---------- ----------------- ------- --------- ---------<br>
Request 0 ext periph req[0] 0x0000 dreq0 un-used<br>
Request 1 ext periph req[1] 0x0004 dreq1 un-used<br>
Request 2 ext periph req[2] 0x0008 dreq2 un-used<br>
Request 3 periph bus req[0] 0x000C un-used un-used<br>
Request 4 periph bus req[1] 0x0010 UART1 RX un-used<br>
Request 5 periph bus req[2] 0x0014 UART1 TX un-used<br>
Request 6 periph bus req[3] 0x0018 un-used SSP1 RX<br>
Request 7 periph bus req[4] 0x001C un-used SSP1 TX<br>
Request 8 periph bus req[5] 0x0020 un-used un-used<br>
Request 9 periph bus req[6] 0x0024 un-used un-used<br>
Request 10 periph bus req[7] 0x0028 un-used SSP2 RX<br>
Request 11 periph bus req[8] 0x002C un-used SSP2 TX<br>
Request 12 periph bus req[9] 0x0030 SSP3 RX TWSI4 RX<br>
Request 13 periph bus req[10] 0x0034 SSP3 TX TWSI4 TX<br>
Request 14 periph bus req[11] 0x0038 TWSI1 RX TWSI5 RX<br>
Request 15 periph bus req[12] 0x003C TWSI1 TX TWSI5 TX<br>
Request 16 periph bus req[13] 0x0040 TWSI2 RX TWSI6 RX<br>
Request 17 periph bus req[14] 0x0044 TWSI2 TX TWSI6 TX<br>
Request 18 periph bus req[15] 0x0048 TWSI3 RX UART4 RX<br>
Request 19 periph bus req[16] 0x004C TWSI3 TX UART4 TX<br>
Request 20 periph bus req[17] 0x0050 un-used UART2 RX<br>
Request 21 periph bus req[18] 0x0054 un-used UART2 TX<br>
Request 22 periph bus req[19] 0x0058 UART3 RX un-used<br>
Request 23 periph bus req[20] 0x005C UART3 TX un-used<br>
Request 24 system bus req[4] 0x0060 un-used un-used<br>
Request 25 system bus req[5] 0x0064 un-used un-used<br>
Request 26 system bus req[6] 0x0068 un-used un-used<br>
Request 27 system bus req[7] 0x006C un-used un-used<br>
Request 28 system bus req[0] 0x0070 NAND DATA un-used<br>
Request 29 system bus req[1] 0x0074 NAND CMD un-used<br>
Request 30 system bus req[2] 0x0078 un-used un-used<br>
Request 31 system bus req[3] 0x007C un-used un-used<br> (Instance 14 of 32)*/
//====================================================================

#define  PDMA_DMA_RCMRX13_RESERVED1_MASK 0xffffff00
#define  PDMA_DMA_RCMRX13_RESERVED1_SHIFT 8
#define  PDMA_DMA_RCMRX13_RESERVED1_MASK_SHIFT(reg) (((reg) & PDMA_DMA_RCMRX13_RESERVED1_MASK) >> PDMA_DMA_RCMRX13_RESERVED1_SHIFT)
#define  PDMA_DMA_RCMRX13_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_RCMRX13_RESERVED1_MASK) | (((uint32_t)val) << PDMA_DMA_RCMRX13_RESERVED1_SHIFT))

#define  PDMA_DMA_RCMRX13_MAPVLD_MASK 0x80
#define  PDMA_DMA_RCMRX13_MAPVLD_SHIFT 7
#define  PDMA_DMA_RCMRX13_MAPVLD_MASK_SHIFT(reg) (((reg) & PDMA_DMA_RCMRX13_MAPVLD_MASK) >> PDMA_DMA_RCMRX13_MAPVLD_SHIFT)
#define  PDMA_DMA_RCMRX13_MAPVLD_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_RCMRX13_MAPVLD_MASK) | (((uint32_t)val) << PDMA_DMA_RCMRX13_MAPVLD_SHIFT))

#define  PDMA_DMA_RCMRX13_RESERVED2_MASK 0x60
#define  PDMA_DMA_RCMRX13_RESERVED2_SHIFT 5
#define  PDMA_DMA_RCMRX13_RESERVED2_MASK_SHIFT(reg) (((reg) & PDMA_DMA_RCMRX13_RESERVED2_MASK) >> PDMA_DMA_RCMRX13_RESERVED2_SHIFT)
#define  PDMA_DMA_RCMRX13_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_RCMRX13_RESERVED2_MASK) | (((uint32_t)val) << PDMA_DMA_RCMRX13_RESERVED2_SHIFT))

#define  PDMA_DMA_RCMRX13_CHLNUM_MASK 0x1f
#define  PDMA_DMA_RCMRX13_CHLNUM_SHIFT 0
#define  PDMA_DMA_RCMRX13_CHLNUM_MASK_SHIFT(reg) (((reg) & PDMA_DMA_RCMRX13_CHLNUM_MASK) >> PDMA_DMA_RCMRX13_CHLNUM_SHIFT)
#define  PDMA_DMA_RCMRX13_CHLNUM_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_RCMRX13_CHLNUM_MASK) | (((uint32_t)val) << PDMA_DMA_RCMRX13_CHLNUM_SHIFT))

//====================================================================
//Register: DMA Request to Channel Map Registers 0-31 (Instance 15 of 32) (DMA_RCMRx14)
/** \brief These registers map the DMA request to a channel.
<br>
These are read/write registers. Ignore reads from reserved bits. Write 0x0 to
reserved bits.
<br>
Here is the address offset for each of the dma requests:
<br>
Request # Request Bus Address DMA0 DMA1<br>
---------- ----------------- ------- --------- ---------<br>
Request 0 ext periph req[0] 0x0000 dreq0 un-used<br>
Request 1 ext periph req[1] 0x0004 dreq1 un-used<br>
Request 2 ext periph req[2] 0x0008 dreq2 un-used<br>
Request 3 periph bus req[0] 0x000C un-used un-used<br>
Request 4 periph bus req[1] 0x0010 UART1 RX un-used<br>
Request 5 periph bus req[2] 0x0014 UART1 TX un-used<br>
Request 6 periph bus req[3] 0x0018 un-used SSP1 RX<br>
Request 7 periph bus req[4] 0x001C un-used SSP1 TX<br>
Request 8 periph bus req[5] 0x0020 un-used un-used<br>
Request 9 periph bus req[6] 0x0024 un-used un-used<br>
Request 10 periph bus req[7] 0x0028 un-used SSP2 RX<br>
Request 11 periph bus req[8] 0x002C un-used SSP2 TX<br>
Request 12 periph bus req[9] 0x0030 SSP3 RX TWSI4 RX<br>
Request 13 periph bus req[10] 0x0034 SSP3 TX TWSI4 TX<br>
Request 14 periph bus req[11] 0x0038 TWSI1 RX TWSI5 RX<br>
Request 15 periph bus req[12] 0x003C TWSI1 TX TWSI5 TX<br>
Request 16 periph bus req[13] 0x0040 TWSI2 RX TWSI6 RX<br>
Request 17 periph bus req[14] 0x0044 TWSI2 TX TWSI6 TX<br>
Request 18 periph bus req[15] 0x0048 TWSI3 RX UART4 RX<br>
Request 19 periph bus req[16] 0x004C TWSI3 TX UART4 TX<br>
Request 20 periph bus req[17] 0x0050 un-used UART2 RX<br>
Request 21 periph bus req[18] 0x0054 un-used UART2 TX<br>
Request 22 periph bus req[19] 0x0058 UART3 RX un-used<br>
Request 23 periph bus req[20] 0x005C UART3 TX un-used<br>
Request 24 system bus req[4] 0x0060 un-used un-used<br>
Request 25 system bus req[5] 0x0064 un-used un-used<br>
Request 26 system bus req[6] 0x0068 un-used un-used<br>
Request 27 system bus req[7] 0x006C un-used un-used<br>
Request 28 system bus req[0] 0x0070 NAND DATA un-used<br>
Request 29 system bus req[1] 0x0074 NAND CMD un-used<br>
Request 30 system bus req[2] 0x0078 un-used un-used<br>
Request 31 system bus req[3] 0x007C un-used un-used<br> (Instance 15 of 32)*/
//====================================================================

#define  PDMA_DMA_RCMRX14_RESERVED1_MASK 0xffffff00
#define  PDMA_DMA_RCMRX14_RESERVED1_SHIFT 8
#define  PDMA_DMA_RCMRX14_RESERVED1_MASK_SHIFT(reg) (((reg) & PDMA_DMA_RCMRX14_RESERVED1_MASK) >> PDMA_DMA_RCMRX14_RESERVED1_SHIFT)
#define  PDMA_DMA_RCMRX14_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_RCMRX14_RESERVED1_MASK) | (((uint32_t)val) << PDMA_DMA_RCMRX14_RESERVED1_SHIFT))

#define  PDMA_DMA_RCMRX14_MAPVLD_MASK 0x80
#define  PDMA_DMA_RCMRX14_MAPVLD_SHIFT 7
#define  PDMA_DMA_RCMRX14_MAPVLD_MASK_SHIFT(reg) (((reg) & PDMA_DMA_RCMRX14_MAPVLD_MASK) >> PDMA_DMA_RCMRX14_MAPVLD_SHIFT)
#define  PDMA_DMA_RCMRX14_MAPVLD_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_RCMRX14_MAPVLD_MASK) | (((uint32_t)val) << PDMA_DMA_RCMRX14_MAPVLD_SHIFT))

#define  PDMA_DMA_RCMRX14_RESERVED2_MASK 0x60
#define  PDMA_DMA_RCMRX14_RESERVED2_SHIFT 5
#define  PDMA_DMA_RCMRX14_RESERVED2_MASK_SHIFT(reg) (((reg) & PDMA_DMA_RCMRX14_RESERVED2_MASK) >> PDMA_DMA_RCMRX14_RESERVED2_SHIFT)
#define  PDMA_DMA_RCMRX14_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_RCMRX14_RESERVED2_MASK) | (((uint32_t)val) << PDMA_DMA_RCMRX14_RESERVED2_SHIFT))

#define  PDMA_DMA_RCMRX14_CHLNUM_MASK 0x1f
#define  PDMA_DMA_RCMRX14_CHLNUM_SHIFT 0
#define  PDMA_DMA_RCMRX14_CHLNUM_MASK_SHIFT(reg) (((reg) & PDMA_DMA_RCMRX14_CHLNUM_MASK) >> PDMA_DMA_RCMRX14_CHLNUM_SHIFT)
#define  PDMA_DMA_RCMRX14_CHLNUM_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_RCMRX14_CHLNUM_MASK) | (((uint32_t)val) << PDMA_DMA_RCMRX14_CHLNUM_SHIFT))

//====================================================================
//Register: DMA Request to Channel Map Registers 0-31 (Instance 16 of 32) (DMA_RCMRx15)
/** \brief These registers map the DMA request to a channel.
<br>
These are read/write registers. Ignore reads from reserved bits. Write 0x0 to
reserved bits.
<br>
Here is the address offset for each of the dma requests:
<br>
Request # Request Bus Address DMA0 DMA1<br>
---------- ----------------- ------- --------- ---------<br>
Request 0 ext periph req[0] 0x0000 dreq0 un-used<br>
Request 1 ext periph req[1] 0x0004 dreq1 un-used<br>
Request 2 ext periph req[2] 0x0008 dreq2 un-used<br>
Request 3 periph bus req[0] 0x000C un-used un-used<br>
Request 4 periph bus req[1] 0x0010 UART1 RX un-used<br>
Request 5 periph bus req[2] 0x0014 UART1 TX un-used<br>
Request 6 periph bus req[3] 0x0018 un-used SSP1 RX<br>
Request 7 periph bus req[4] 0x001C un-used SSP1 TX<br>
Request 8 periph bus req[5] 0x0020 un-used un-used<br>
Request 9 periph bus req[6] 0x0024 un-used un-used<br>
Request 10 periph bus req[7] 0x0028 un-used SSP2 RX<br>
Request 11 periph bus req[8] 0x002C un-used SSP2 TX<br>
Request 12 periph bus req[9] 0x0030 SSP3 RX TWSI4 RX<br>
Request 13 periph bus req[10] 0x0034 SSP3 TX TWSI4 TX<br>
Request 14 periph bus req[11] 0x0038 TWSI1 RX TWSI5 RX<br>
Request 15 periph bus req[12] 0x003C TWSI1 TX TWSI5 TX<br>
Request 16 periph bus req[13] 0x0040 TWSI2 RX TWSI6 RX<br>
Request 17 periph bus req[14] 0x0044 TWSI2 TX TWSI6 TX<br>
Request 18 periph bus req[15] 0x0048 TWSI3 RX UART4 RX<br>
Request 19 periph bus req[16] 0x004C TWSI3 TX UART4 TX<br>
Request 20 periph bus req[17] 0x0050 un-used UART2 RX<br>
Request 21 periph bus req[18] 0x0054 un-used UART2 TX<br>
Request 22 periph bus req[19] 0x0058 UART3 RX un-used<br>
Request 23 periph bus req[20] 0x005C UART3 TX un-used<br>
Request 24 system bus req[4] 0x0060 un-used un-used<br>
Request 25 system bus req[5] 0x0064 un-used un-used<br>
Request 26 system bus req[6] 0x0068 un-used un-used<br>
Request 27 system bus req[7] 0x006C un-used un-used<br>
Request 28 system bus req[0] 0x0070 NAND DATA un-used<br>
Request 29 system bus req[1] 0x0074 NAND CMD un-used<br>
Request 30 system bus req[2] 0x0078 un-used un-used<br>
Request 31 system bus req[3] 0x007C un-used un-used<br> (Instance 16 of 32)*/
//====================================================================

#define  PDMA_DMA_RCMRX15_RESERVED1_MASK 0xffffff00
#define  PDMA_DMA_RCMRX15_RESERVED1_SHIFT 8
#define  PDMA_DMA_RCMRX15_RESERVED1_MASK_SHIFT(reg) (((reg) & PDMA_DMA_RCMRX15_RESERVED1_MASK) >> PDMA_DMA_RCMRX15_RESERVED1_SHIFT)
#define  PDMA_DMA_RCMRX15_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_RCMRX15_RESERVED1_MASK) | (((uint32_t)val) << PDMA_DMA_RCMRX15_RESERVED1_SHIFT))

#define  PDMA_DMA_RCMRX15_MAPVLD_MASK 0x80
#define  PDMA_DMA_RCMRX15_MAPVLD_SHIFT 7
#define  PDMA_DMA_RCMRX15_MAPVLD_MASK_SHIFT(reg) (((reg) & PDMA_DMA_RCMRX15_MAPVLD_MASK) >> PDMA_DMA_RCMRX15_MAPVLD_SHIFT)
#define  PDMA_DMA_RCMRX15_MAPVLD_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_RCMRX15_MAPVLD_MASK) | (((uint32_t)val) << PDMA_DMA_RCMRX15_MAPVLD_SHIFT))

#define  PDMA_DMA_RCMRX15_RESERVED2_MASK 0x60
#define  PDMA_DMA_RCMRX15_RESERVED2_SHIFT 5
#define  PDMA_DMA_RCMRX15_RESERVED2_MASK_SHIFT(reg) (((reg) & PDMA_DMA_RCMRX15_RESERVED2_MASK) >> PDMA_DMA_RCMRX15_RESERVED2_SHIFT)
#define  PDMA_DMA_RCMRX15_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_RCMRX15_RESERVED2_MASK) | (((uint32_t)val) << PDMA_DMA_RCMRX15_RESERVED2_SHIFT))

#define  PDMA_DMA_RCMRX15_CHLNUM_MASK 0x1f
#define  PDMA_DMA_RCMRX15_CHLNUM_SHIFT 0
#define  PDMA_DMA_RCMRX15_CHLNUM_MASK_SHIFT(reg) (((reg) & PDMA_DMA_RCMRX15_CHLNUM_MASK) >> PDMA_DMA_RCMRX15_CHLNUM_SHIFT)
#define  PDMA_DMA_RCMRX15_CHLNUM_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_RCMRX15_CHLNUM_MASK) | (((uint32_t)val) << PDMA_DMA_RCMRX15_CHLNUM_SHIFT))

//====================================================================
//Register: DMA Request to Channel Map Registers 0-31 (Instance 17 of 32) (DMA_RCMRx16)
/** \brief These registers map the DMA request to a channel.
<br>
These are read/write registers. Ignore reads from reserved bits. Write 0x0 to
reserved bits.
<br>
Here is the address offset for each of the dma requests:
<br>
Request # Request Bus Address DMA0 DMA1<br>
---------- ----------------- ------- --------- ---------<br>
Request 0 ext periph req[0] 0x0000 dreq0 un-used<br>
Request 1 ext periph req[1] 0x0004 dreq1 un-used<br>
Request 2 ext periph req[2] 0x0008 dreq2 un-used<br>
Request 3 periph bus req[0] 0x000C un-used un-used<br>
Request 4 periph bus req[1] 0x0010 UART1 RX un-used<br>
Request 5 periph bus req[2] 0x0014 UART1 TX un-used<br>
Request 6 periph bus req[3] 0x0018 un-used SSP1 RX<br>
Request 7 periph bus req[4] 0x001C un-used SSP1 TX<br>
Request 8 periph bus req[5] 0x0020 un-used un-used<br>
Request 9 periph bus req[6] 0x0024 un-used un-used<br>
Request 10 periph bus req[7] 0x0028 un-used SSP2 RX<br>
Request 11 periph bus req[8] 0x002C un-used SSP2 TX<br>
Request 12 periph bus req[9] 0x0030 SSP3 RX TWSI4 RX<br>
Request 13 periph bus req[10] 0x0034 SSP3 TX TWSI4 TX<br>
Request 14 periph bus req[11] 0x0038 TWSI1 RX TWSI5 RX<br>
Request 15 periph bus req[12] 0x003C TWSI1 TX TWSI5 TX<br>
Request 16 periph bus req[13] 0x0040 TWSI2 RX TWSI6 RX<br>
Request 17 periph bus req[14] 0x0044 TWSI2 TX TWSI6 TX<br>
Request 18 periph bus req[15] 0x0048 TWSI3 RX UART4 RX<br>
Request 19 periph bus req[16] 0x004C TWSI3 TX UART4 TX<br>
Request 20 periph bus req[17] 0x0050 un-used UART2 RX<br>
Request 21 periph bus req[18] 0x0054 un-used UART2 TX<br>
Request 22 periph bus req[19] 0x0058 UART3 RX un-used<br>
Request 23 periph bus req[20] 0x005C UART3 TX un-used<br>
Request 24 system bus req[4] 0x0060 un-used un-used<br>
Request 25 system bus req[5] 0x0064 un-used un-used<br>
Request 26 system bus req[6] 0x0068 un-used un-used<br>
Request 27 system bus req[7] 0x006C un-used un-used<br>
Request 28 system bus req[0] 0x0070 NAND DATA un-used<br>
Request 29 system bus req[1] 0x0074 NAND CMD un-used<br>
Request 30 system bus req[2] 0x0078 un-used un-used<br>
Request 31 system bus req[3] 0x007C un-used un-used<br> (Instance 17 of 32)*/
//====================================================================

#define  PDMA_DMA_RCMRX16_RESERVED1_MASK 0xffffff00
#define  PDMA_DMA_RCMRX16_RESERVED1_SHIFT 8
#define  PDMA_DMA_RCMRX16_RESERVED1_MASK_SHIFT(reg) (((reg) & PDMA_DMA_RCMRX16_RESERVED1_MASK) >> PDMA_DMA_RCMRX16_RESERVED1_SHIFT)
#define  PDMA_DMA_RCMRX16_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_RCMRX16_RESERVED1_MASK) | (((uint32_t)val) << PDMA_DMA_RCMRX16_RESERVED1_SHIFT))

#define  PDMA_DMA_RCMRX16_MAPVLD_MASK 0x80
#define  PDMA_DMA_RCMRX16_MAPVLD_SHIFT 7
#define  PDMA_DMA_RCMRX16_MAPVLD_MASK_SHIFT(reg) (((reg) & PDMA_DMA_RCMRX16_MAPVLD_MASK) >> PDMA_DMA_RCMRX16_MAPVLD_SHIFT)
#define  PDMA_DMA_RCMRX16_MAPVLD_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_RCMRX16_MAPVLD_MASK) | (((uint32_t)val) << PDMA_DMA_RCMRX16_MAPVLD_SHIFT))

#define  PDMA_DMA_RCMRX16_RESERVED2_MASK 0x60
#define  PDMA_DMA_RCMRX16_RESERVED2_SHIFT 5
#define  PDMA_DMA_RCMRX16_RESERVED2_MASK_SHIFT(reg) (((reg) & PDMA_DMA_RCMRX16_RESERVED2_MASK) >> PDMA_DMA_RCMRX16_RESERVED2_SHIFT)
#define  PDMA_DMA_RCMRX16_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_RCMRX16_RESERVED2_MASK) | (((uint32_t)val) << PDMA_DMA_RCMRX16_RESERVED2_SHIFT))

#define  PDMA_DMA_RCMRX16_CHLNUM_MASK 0x1f
#define  PDMA_DMA_RCMRX16_CHLNUM_SHIFT 0
#define  PDMA_DMA_RCMRX16_CHLNUM_MASK_SHIFT(reg) (((reg) & PDMA_DMA_RCMRX16_CHLNUM_MASK) >> PDMA_DMA_RCMRX16_CHLNUM_SHIFT)
#define  PDMA_DMA_RCMRX16_CHLNUM_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_RCMRX16_CHLNUM_MASK) | (((uint32_t)val) << PDMA_DMA_RCMRX16_CHLNUM_SHIFT))

//====================================================================
//Register: DMA Request to Channel Map Registers 0-31 (Instance 18 of 32) (DMA_RCMRx17)
/** \brief These registers map the DMA request to a channel.
<br>
These are read/write registers. Ignore reads from reserved bits. Write 0x0 to
reserved bits.
<br>
Here is the address offset for each of the dma requests:
<br>
Request # Request Bus Address DMA0 DMA1<br>
---------- ----------------- ------- --------- ---------<br>
Request 0 ext periph req[0] 0x0000 dreq0 un-used<br>
Request 1 ext periph req[1] 0x0004 dreq1 un-used<br>
Request 2 ext periph req[2] 0x0008 dreq2 un-used<br>
Request 3 periph bus req[0] 0x000C un-used un-used<br>
Request 4 periph bus req[1] 0x0010 UART1 RX un-used<br>
Request 5 periph bus req[2] 0x0014 UART1 TX un-used<br>
Request 6 periph bus req[3] 0x0018 un-used SSP1 RX<br>
Request 7 periph bus req[4] 0x001C un-used SSP1 TX<br>
Request 8 periph bus req[5] 0x0020 un-used un-used<br>
Request 9 periph bus req[6] 0x0024 un-used un-used<br>
Request 10 periph bus req[7] 0x0028 un-used SSP2 RX<br>
Request 11 periph bus req[8] 0x002C un-used SSP2 TX<br>
Request 12 periph bus req[9] 0x0030 SSP3 RX TWSI4 RX<br>
Request 13 periph bus req[10] 0x0034 SSP3 TX TWSI4 TX<br>
Request 14 periph bus req[11] 0x0038 TWSI1 RX TWSI5 RX<br>
Request 15 periph bus req[12] 0x003C TWSI1 TX TWSI5 TX<br>
Request 16 periph bus req[13] 0x0040 TWSI2 RX TWSI6 RX<br>
Request 17 periph bus req[14] 0x0044 TWSI2 TX TWSI6 TX<br>
Request 18 periph bus req[15] 0x0048 TWSI3 RX UART4 RX<br>
Request 19 periph bus req[16] 0x004C TWSI3 TX UART4 TX<br>
Request 20 periph bus req[17] 0x0050 un-used UART2 RX<br>
Request 21 periph bus req[18] 0x0054 un-used UART2 TX<br>
Request 22 periph bus req[19] 0x0058 UART3 RX un-used<br>
Request 23 periph bus req[20] 0x005C UART3 TX un-used<br>
Request 24 system bus req[4] 0x0060 un-used un-used<br>
Request 25 system bus req[5] 0x0064 un-used un-used<br>
Request 26 system bus req[6] 0x0068 un-used un-used<br>
Request 27 system bus req[7] 0x006C un-used un-used<br>
Request 28 system bus req[0] 0x0070 NAND DATA un-used<br>
Request 29 system bus req[1] 0x0074 NAND CMD un-used<br>
Request 30 system bus req[2] 0x0078 un-used un-used<br>
Request 31 system bus req[3] 0x007C un-used un-used<br> (Instance 18 of 32)*/
//====================================================================

#define  PDMA_DMA_RCMRX17_RESERVED1_MASK 0xffffff00
#define  PDMA_DMA_RCMRX17_RESERVED1_SHIFT 8
#define  PDMA_DMA_RCMRX17_RESERVED1_MASK_SHIFT(reg) (((reg) & PDMA_DMA_RCMRX17_RESERVED1_MASK) >> PDMA_DMA_RCMRX17_RESERVED1_SHIFT)
#define  PDMA_DMA_RCMRX17_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_RCMRX17_RESERVED1_MASK) | (((uint32_t)val) << PDMA_DMA_RCMRX17_RESERVED1_SHIFT))

#define  PDMA_DMA_RCMRX17_MAPVLD_MASK 0x80
#define  PDMA_DMA_RCMRX17_MAPVLD_SHIFT 7
#define  PDMA_DMA_RCMRX17_MAPVLD_MASK_SHIFT(reg) (((reg) & PDMA_DMA_RCMRX17_MAPVLD_MASK) >> PDMA_DMA_RCMRX17_MAPVLD_SHIFT)
#define  PDMA_DMA_RCMRX17_MAPVLD_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_RCMRX17_MAPVLD_MASK) | (((uint32_t)val) << PDMA_DMA_RCMRX17_MAPVLD_SHIFT))

#define  PDMA_DMA_RCMRX17_RESERVED2_MASK 0x60
#define  PDMA_DMA_RCMRX17_RESERVED2_SHIFT 5
#define  PDMA_DMA_RCMRX17_RESERVED2_MASK_SHIFT(reg) (((reg) & PDMA_DMA_RCMRX17_RESERVED2_MASK) >> PDMA_DMA_RCMRX17_RESERVED2_SHIFT)
#define  PDMA_DMA_RCMRX17_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_RCMRX17_RESERVED2_MASK) | (((uint32_t)val) << PDMA_DMA_RCMRX17_RESERVED2_SHIFT))

#define  PDMA_DMA_RCMRX17_CHLNUM_MASK 0x1f
#define  PDMA_DMA_RCMRX17_CHLNUM_SHIFT 0
#define  PDMA_DMA_RCMRX17_CHLNUM_MASK_SHIFT(reg) (((reg) & PDMA_DMA_RCMRX17_CHLNUM_MASK) >> PDMA_DMA_RCMRX17_CHLNUM_SHIFT)
#define  PDMA_DMA_RCMRX17_CHLNUM_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_RCMRX17_CHLNUM_MASK) | (((uint32_t)val) << PDMA_DMA_RCMRX17_CHLNUM_SHIFT))

//====================================================================
//Register: DMA Request to Channel Map Registers 0-31 (Instance 19 of 32) (DMA_RCMRx18)
/** \brief These registers map the DMA request to a channel.
<br>
These are read/write registers. Ignore reads from reserved bits. Write 0x0 to
reserved bits.
<br>
Here is the address offset for each of the dma requests:
<br>
Request # Request Bus Address DMA0 DMA1<br>
---------- ----------------- ------- --------- ---------<br>
Request 0 ext periph req[0] 0x0000 dreq0 un-used<br>
Request 1 ext periph req[1] 0x0004 dreq1 un-used<br>
Request 2 ext periph req[2] 0x0008 dreq2 un-used<br>
Request 3 periph bus req[0] 0x000C un-used un-used<br>
Request 4 periph bus req[1] 0x0010 UART1 RX un-used<br>
Request 5 periph bus req[2] 0x0014 UART1 TX un-used<br>
Request 6 periph bus req[3] 0x0018 un-used SSP1 RX<br>
Request 7 periph bus req[4] 0x001C un-used SSP1 TX<br>
Request 8 periph bus req[5] 0x0020 un-used un-used<br>
Request 9 periph bus req[6] 0x0024 un-used un-used<br>
Request 10 periph bus req[7] 0x0028 un-used SSP2 RX<br>
Request 11 periph bus req[8] 0x002C un-used SSP2 TX<br>
Request 12 periph bus req[9] 0x0030 SSP3 RX TWSI4 RX<br>
Request 13 periph bus req[10] 0x0034 SSP3 TX TWSI4 TX<br>
Request 14 periph bus req[11] 0x0038 TWSI1 RX TWSI5 RX<br>
Request 15 periph bus req[12] 0x003C TWSI1 TX TWSI5 TX<br>
Request 16 periph bus req[13] 0x0040 TWSI2 RX TWSI6 RX<br>
Request 17 periph bus req[14] 0x0044 TWSI2 TX TWSI6 TX<br>
Request 18 periph bus req[15] 0x0048 TWSI3 RX UART4 RX<br>
Request 19 periph bus req[16] 0x004C TWSI3 TX UART4 TX<br>
Request 20 periph bus req[17] 0x0050 un-used UART2 RX<br>
Request 21 periph bus req[18] 0x0054 un-used UART2 TX<br>
Request 22 periph bus req[19] 0x0058 UART3 RX un-used<br>
Request 23 periph bus req[20] 0x005C UART3 TX un-used<br>
Request 24 system bus req[4] 0x0060 un-used un-used<br>
Request 25 system bus req[5] 0x0064 un-used un-used<br>
Request 26 system bus req[6] 0x0068 un-used un-used<br>
Request 27 system bus req[7] 0x006C un-used un-used<br>
Request 28 system bus req[0] 0x0070 NAND DATA un-used<br>
Request 29 system bus req[1] 0x0074 NAND CMD un-used<br>
Request 30 system bus req[2] 0x0078 un-used un-used<br>
Request 31 system bus req[3] 0x007C un-used un-used<br> (Instance 19 of 32)*/
//====================================================================

#define  PDMA_DMA_RCMRX18_RESERVED1_MASK 0xffffff00
#define  PDMA_DMA_RCMRX18_RESERVED1_SHIFT 8
#define  PDMA_DMA_RCMRX18_RESERVED1_MASK_SHIFT(reg) (((reg) & PDMA_DMA_RCMRX18_RESERVED1_MASK) >> PDMA_DMA_RCMRX18_RESERVED1_SHIFT)
#define  PDMA_DMA_RCMRX18_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_RCMRX18_RESERVED1_MASK) | (((uint32_t)val) << PDMA_DMA_RCMRX18_RESERVED1_SHIFT))

#define  PDMA_DMA_RCMRX18_MAPVLD_MASK 0x80
#define  PDMA_DMA_RCMRX18_MAPVLD_SHIFT 7
#define  PDMA_DMA_RCMRX18_MAPVLD_MASK_SHIFT(reg) (((reg) & PDMA_DMA_RCMRX18_MAPVLD_MASK) >> PDMA_DMA_RCMRX18_MAPVLD_SHIFT)
#define  PDMA_DMA_RCMRX18_MAPVLD_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_RCMRX18_MAPVLD_MASK) | (((uint32_t)val) << PDMA_DMA_RCMRX18_MAPVLD_SHIFT))

#define  PDMA_DMA_RCMRX18_RESERVED2_MASK 0x60
#define  PDMA_DMA_RCMRX18_RESERVED2_SHIFT 5
#define  PDMA_DMA_RCMRX18_RESERVED2_MASK_SHIFT(reg) (((reg) & PDMA_DMA_RCMRX18_RESERVED2_MASK) >> PDMA_DMA_RCMRX18_RESERVED2_SHIFT)
#define  PDMA_DMA_RCMRX18_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_RCMRX18_RESERVED2_MASK) | (((uint32_t)val) << PDMA_DMA_RCMRX18_RESERVED2_SHIFT))

#define  PDMA_DMA_RCMRX18_CHLNUM_MASK 0x1f
#define  PDMA_DMA_RCMRX18_CHLNUM_SHIFT 0
#define  PDMA_DMA_RCMRX18_CHLNUM_MASK_SHIFT(reg) (((reg) & PDMA_DMA_RCMRX18_CHLNUM_MASK) >> PDMA_DMA_RCMRX18_CHLNUM_SHIFT)
#define  PDMA_DMA_RCMRX18_CHLNUM_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_RCMRX18_CHLNUM_MASK) | (((uint32_t)val) << PDMA_DMA_RCMRX18_CHLNUM_SHIFT))

//====================================================================
//Register: DMA Request to Channel Map Registers 0-31 (Instance 20 of 32) (DMA_RCMRx19)
/** \brief These registers map the DMA request to a channel.
<br>
These are read/write registers. Ignore reads from reserved bits. Write 0x0 to
reserved bits.
<br>
Here is the address offset for each of the dma requests:
<br>
Request # Request Bus Address DMA0 DMA1<br>
---------- ----------------- ------- --------- ---------<br>
Request 0 ext periph req[0] 0x0000 dreq0 un-used<br>
Request 1 ext periph req[1] 0x0004 dreq1 un-used<br>
Request 2 ext periph req[2] 0x0008 dreq2 un-used<br>
Request 3 periph bus req[0] 0x000C un-used un-used<br>
Request 4 periph bus req[1] 0x0010 UART1 RX un-used<br>
Request 5 periph bus req[2] 0x0014 UART1 TX un-used<br>
Request 6 periph bus req[3] 0x0018 un-used SSP1 RX<br>
Request 7 periph bus req[4] 0x001C un-used SSP1 TX<br>
Request 8 periph bus req[5] 0x0020 un-used un-used<br>
Request 9 periph bus req[6] 0x0024 un-used un-used<br>
Request 10 periph bus req[7] 0x0028 un-used SSP2 RX<br>
Request 11 periph bus req[8] 0x002C un-used SSP2 TX<br>
Request 12 periph bus req[9] 0x0030 SSP3 RX TWSI4 RX<br>
Request 13 periph bus req[10] 0x0034 SSP3 TX TWSI4 TX<br>
Request 14 periph bus req[11] 0x0038 TWSI1 RX TWSI5 RX<br>
Request 15 periph bus req[12] 0x003C TWSI1 TX TWSI5 TX<br>
Request 16 periph bus req[13] 0x0040 TWSI2 RX TWSI6 RX<br>
Request 17 periph bus req[14] 0x0044 TWSI2 TX TWSI6 TX<br>
Request 18 periph bus req[15] 0x0048 TWSI3 RX UART4 RX<br>
Request 19 periph bus req[16] 0x004C TWSI3 TX UART4 TX<br>
Request 20 periph bus req[17] 0x0050 un-used UART2 RX<br>
Request 21 periph bus req[18] 0x0054 un-used UART2 TX<br>
Request 22 periph bus req[19] 0x0058 UART3 RX un-used<br>
Request 23 periph bus req[20] 0x005C UART3 TX un-used<br>
Request 24 system bus req[4] 0x0060 un-used un-used<br>
Request 25 system bus req[5] 0x0064 un-used un-used<br>
Request 26 system bus req[6] 0x0068 un-used un-used<br>
Request 27 system bus req[7] 0x006C un-used un-used<br>
Request 28 system bus req[0] 0x0070 NAND DATA un-used<br>
Request 29 system bus req[1] 0x0074 NAND CMD un-used<br>
Request 30 system bus req[2] 0x0078 un-used un-used<br>
Request 31 system bus req[3] 0x007C un-used un-used<br> (Instance 20 of 32)*/
//====================================================================

#define  PDMA_DMA_RCMRX19_RESERVED1_MASK 0xffffff00
#define  PDMA_DMA_RCMRX19_RESERVED1_SHIFT 8
#define  PDMA_DMA_RCMRX19_RESERVED1_MASK_SHIFT(reg) (((reg) & PDMA_DMA_RCMRX19_RESERVED1_MASK) >> PDMA_DMA_RCMRX19_RESERVED1_SHIFT)
#define  PDMA_DMA_RCMRX19_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_RCMRX19_RESERVED1_MASK) | (((uint32_t)val) << PDMA_DMA_RCMRX19_RESERVED1_SHIFT))

#define  PDMA_DMA_RCMRX19_MAPVLD_MASK 0x80
#define  PDMA_DMA_RCMRX19_MAPVLD_SHIFT 7
#define  PDMA_DMA_RCMRX19_MAPVLD_MASK_SHIFT(reg) (((reg) & PDMA_DMA_RCMRX19_MAPVLD_MASK) >> PDMA_DMA_RCMRX19_MAPVLD_SHIFT)
#define  PDMA_DMA_RCMRX19_MAPVLD_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_RCMRX19_MAPVLD_MASK) | (((uint32_t)val) << PDMA_DMA_RCMRX19_MAPVLD_SHIFT))

#define  PDMA_DMA_RCMRX19_RESERVED2_MASK 0x60
#define  PDMA_DMA_RCMRX19_RESERVED2_SHIFT 5
#define  PDMA_DMA_RCMRX19_RESERVED2_MASK_SHIFT(reg) (((reg) & PDMA_DMA_RCMRX19_RESERVED2_MASK) >> PDMA_DMA_RCMRX19_RESERVED2_SHIFT)
#define  PDMA_DMA_RCMRX19_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_RCMRX19_RESERVED2_MASK) | (((uint32_t)val) << PDMA_DMA_RCMRX19_RESERVED2_SHIFT))

#define  PDMA_DMA_RCMRX19_CHLNUM_MASK 0x1f
#define  PDMA_DMA_RCMRX19_CHLNUM_SHIFT 0
#define  PDMA_DMA_RCMRX19_CHLNUM_MASK_SHIFT(reg) (((reg) & PDMA_DMA_RCMRX19_CHLNUM_MASK) >> PDMA_DMA_RCMRX19_CHLNUM_SHIFT)
#define  PDMA_DMA_RCMRX19_CHLNUM_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_RCMRX19_CHLNUM_MASK) | (((uint32_t)val) << PDMA_DMA_RCMRX19_CHLNUM_SHIFT))

//====================================================================
//Register: DMA Request to Channel Map Registers 0-31 (Instance 21 of 32) (DMA_RCMRx20)
/** \brief These registers map the DMA request to a channel.
<br>
These are read/write registers. Ignore reads from reserved bits. Write 0x0 to
reserved bits.
<br>
Here is the address offset for each of the dma requests:
<br>
Request # Request Bus Address DMA0 DMA1<br>
---------- ----------------- ------- --------- ---------<br>
Request 0 ext periph req[0] 0x0000 dreq0 un-used<br>
Request 1 ext periph req[1] 0x0004 dreq1 un-used<br>
Request 2 ext periph req[2] 0x0008 dreq2 un-used<br>
Request 3 periph bus req[0] 0x000C un-used un-used<br>
Request 4 periph bus req[1] 0x0010 UART1 RX un-used<br>
Request 5 periph bus req[2] 0x0014 UART1 TX un-used<br>
Request 6 periph bus req[3] 0x0018 un-used SSP1 RX<br>
Request 7 periph bus req[4] 0x001C un-used SSP1 TX<br>
Request 8 periph bus req[5] 0x0020 un-used un-used<br>
Request 9 periph bus req[6] 0x0024 un-used un-used<br>
Request 10 periph bus req[7] 0x0028 un-used SSP2 RX<br>
Request 11 periph bus req[8] 0x002C un-used SSP2 TX<br>
Request 12 periph bus req[9] 0x0030 SSP3 RX TWSI4 RX<br>
Request 13 periph bus req[10] 0x0034 SSP3 TX TWSI4 TX<br>
Request 14 periph bus req[11] 0x0038 TWSI1 RX TWSI5 RX<br>
Request 15 periph bus req[12] 0x003C TWSI1 TX TWSI5 TX<br>
Request 16 periph bus req[13] 0x0040 TWSI2 RX TWSI6 RX<br>
Request 17 periph bus req[14] 0x0044 TWSI2 TX TWSI6 TX<br>
Request 18 periph bus req[15] 0x0048 TWSI3 RX UART4 RX<br>
Request 19 periph bus req[16] 0x004C TWSI3 TX UART4 TX<br>
Request 20 periph bus req[17] 0x0050 un-used UART2 RX<br>
Request 21 periph bus req[18] 0x0054 un-used UART2 TX<br>
Request 22 periph bus req[19] 0x0058 UART3 RX un-used<br>
Request 23 periph bus req[20] 0x005C UART3 TX un-used<br>
Request 24 system bus req[4] 0x0060 un-used un-used<br>
Request 25 system bus req[5] 0x0064 un-used un-used<br>
Request 26 system bus req[6] 0x0068 un-used un-used<br>
Request 27 system bus req[7] 0x006C un-used un-used<br>
Request 28 system bus req[0] 0x0070 NAND DATA un-used<br>
Request 29 system bus req[1] 0x0074 NAND CMD un-used<br>
Request 30 system bus req[2] 0x0078 un-used un-used<br>
Request 31 system bus req[3] 0x007C un-used un-used<br> (Instance 21 of 32)*/
//====================================================================

#define  PDMA_DMA_RCMRX20_RESERVED1_MASK 0xffffff00
#define  PDMA_DMA_RCMRX20_RESERVED1_SHIFT 8
#define  PDMA_DMA_RCMRX20_RESERVED1_MASK_SHIFT(reg) (((reg) & PDMA_DMA_RCMRX20_RESERVED1_MASK) >> PDMA_DMA_RCMRX20_RESERVED1_SHIFT)
#define  PDMA_DMA_RCMRX20_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_RCMRX20_RESERVED1_MASK) | (((uint32_t)val) << PDMA_DMA_RCMRX20_RESERVED1_SHIFT))

#define  PDMA_DMA_RCMRX20_MAPVLD_MASK 0x80
#define  PDMA_DMA_RCMRX20_MAPVLD_SHIFT 7
#define  PDMA_DMA_RCMRX20_MAPVLD_MASK_SHIFT(reg) (((reg) & PDMA_DMA_RCMRX20_MAPVLD_MASK) >> PDMA_DMA_RCMRX20_MAPVLD_SHIFT)
#define  PDMA_DMA_RCMRX20_MAPVLD_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_RCMRX20_MAPVLD_MASK) | (((uint32_t)val) << PDMA_DMA_RCMRX20_MAPVLD_SHIFT))

#define  PDMA_DMA_RCMRX20_RESERVED2_MASK 0x60
#define  PDMA_DMA_RCMRX20_RESERVED2_SHIFT 5
#define  PDMA_DMA_RCMRX20_RESERVED2_MASK_SHIFT(reg) (((reg) & PDMA_DMA_RCMRX20_RESERVED2_MASK) >> PDMA_DMA_RCMRX20_RESERVED2_SHIFT)
#define  PDMA_DMA_RCMRX20_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_RCMRX20_RESERVED2_MASK) | (((uint32_t)val) << PDMA_DMA_RCMRX20_RESERVED2_SHIFT))

#define  PDMA_DMA_RCMRX20_CHLNUM_MASK 0x1f
#define  PDMA_DMA_RCMRX20_CHLNUM_SHIFT 0
#define  PDMA_DMA_RCMRX20_CHLNUM_MASK_SHIFT(reg) (((reg) & PDMA_DMA_RCMRX20_CHLNUM_MASK) >> PDMA_DMA_RCMRX20_CHLNUM_SHIFT)
#define  PDMA_DMA_RCMRX20_CHLNUM_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_RCMRX20_CHLNUM_MASK) | (((uint32_t)val) << PDMA_DMA_RCMRX20_CHLNUM_SHIFT))

//====================================================================
//Register: DMA Request to Channel Map Registers 0-31 (Instance 22 of 32) (DMA_RCMRx21)
/** \brief These registers map the DMA request to a channel.
<br>
These are read/write registers. Ignore reads from reserved bits. Write 0x0 to
reserved bits.
<br>
Here is the address offset for each of the dma requests:
<br>
Request # Request Bus Address DMA0 DMA1<br>
---------- ----------------- ------- --------- ---------<br>
Request 0 ext periph req[0] 0x0000 dreq0 un-used<br>
Request 1 ext periph req[1] 0x0004 dreq1 un-used<br>
Request 2 ext periph req[2] 0x0008 dreq2 un-used<br>
Request 3 periph bus req[0] 0x000C un-used un-used<br>
Request 4 periph bus req[1] 0x0010 UART1 RX un-used<br>
Request 5 periph bus req[2] 0x0014 UART1 TX un-used<br>
Request 6 periph bus req[3] 0x0018 un-used SSP1 RX<br>
Request 7 periph bus req[4] 0x001C un-used SSP1 TX<br>
Request 8 periph bus req[5] 0x0020 un-used un-used<br>
Request 9 periph bus req[6] 0x0024 un-used un-used<br>
Request 10 periph bus req[7] 0x0028 un-used SSP2 RX<br>
Request 11 periph bus req[8] 0x002C un-used SSP2 TX<br>
Request 12 periph bus req[9] 0x0030 SSP3 RX TWSI4 RX<br>
Request 13 periph bus req[10] 0x0034 SSP3 TX TWSI4 TX<br>
Request 14 periph bus req[11] 0x0038 TWSI1 RX TWSI5 RX<br>
Request 15 periph bus req[12] 0x003C TWSI1 TX TWSI5 TX<br>
Request 16 periph bus req[13] 0x0040 TWSI2 RX TWSI6 RX<br>
Request 17 periph bus req[14] 0x0044 TWSI2 TX TWSI6 TX<br>
Request 18 periph bus req[15] 0x0048 TWSI3 RX UART4 RX<br>
Request 19 periph bus req[16] 0x004C TWSI3 TX UART4 TX<br>
Request 20 periph bus req[17] 0x0050 un-used UART2 RX<br>
Request 21 periph bus req[18] 0x0054 un-used UART2 TX<br>
Request 22 periph bus req[19] 0x0058 UART3 RX un-used<br>
Request 23 periph bus req[20] 0x005C UART3 TX un-used<br>
Request 24 system bus req[4] 0x0060 un-used un-used<br>
Request 25 system bus req[5] 0x0064 un-used un-used<br>
Request 26 system bus req[6] 0x0068 un-used un-used<br>
Request 27 system bus req[7] 0x006C un-used un-used<br>
Request 28 system bus req[0] 0x0070 NAND DATA un-used<br>
Request 29 system bus req[1] 0x0074 NAND CMD un-used<br>
Request 30 system bus req[2] 0x0078 un-used un-used<br>
Request 31 system bus req[3] 0x007C un-used un-used<br> (Instance 22 of 32)*/
//====================================================================

#define  PDMA_DMA_RCMRX21_RESERVED1_MASK 0xffffff00
#define  PDMA_DMA_RCMRX21_RESERVED1_SHIFT 8
#define  PDMA_DMA_RCMRX21_RESERVED1_MASK_SHIFT(reg) (((reg) & PDMA_DMA_RCMRX21_RESERVED1_MASK) >> PDMA_DMA_RCMRX21_RESERVED1_SHIFT)
#define  PDMA_DMA_RCMRX21_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_RCMRX21_RESERVED1_MASK) | (((uint32_t)val) << PDMA_DMA_RCMRX21_RESERVED1_SHIFT))

#define  PDMA_DMA_RCMRX21_MAPVLD_MASK 0x80
#define  PDMA_DMA_RCMRX21_MAPVLD_SHIFT 7
#define  PDMA_DMA_RCMRX21_MAPVLD_MASK_SHIFT(reg) (((reg) & PDMA_DMA_RCMRX21_MAPVLD_MASK) >> PDMA_DMA_RCMRX21_MAPVLD_SHIFT)
#define  PDMA_DMA_RCMRX21_MAPVLD_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_RCMRX21_MAPVLD_MASK) | (((uint32_t)val) << PDMA_DMA_RCMRX21_MAPVLD_SHIFT))

#define  PDMA_DMA_RCMRX21_RESERVED2_MASK 0x60
#define  PDMA_DMA_RCMRX21_RESERVED2_SHIFT 5
#define  PDMA_DMA_RCMRX21_RESERVED2_MASK_SHIFT(reg) (((reg) & PDMA_DMA_RCMRX21_RESERVED2_MASK) >> PDMA_DMA_RCMRX21_RESERVED2_SHIFT)
#define  PDMA_DMA_RCMRX21_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_RCMRX21_RESERVED2_MASK) | (((uint32_t)val) << PDMA_DMA_RCMRX21_RESERVED2_SHIFT))

#define  PDMA_DMA_RCMRX21_CHLNUM_MASK 0x1f
#define  PDMA_DMA_RCMRX21_CHLNUM_SHIFT 0
#define  PDMA_DMA_RCMRX21_CHLNUM_MASK_SHIFT(reg) (((reg) & PDMA_DMA_RCMRX21_CHLNUM_MASK) >> PDMA_DMA_RCMRX21_CHLNUM_SHIFT)
#define  PDMA_DMA_RCMRX21_CHLNUM_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_RCMRX21_CHLNUM_MASK) | (((uint32_t)val) << PDMA_DMA_RCMRX21_CHLNUM_SHIFT))

//====================================================================
//Register: DMA Request to Channel Map Registers 0-31 (Instance 23 of 32) (DMA_RCMRx22)
/** \brief These registers map the DMA request to a channel.
<br>
These are read/write registers. Ignore reads from reserved bits. Write 0x0 to
reserved bits.
<br>
Here is the address offset for each of the dma requests:
<br>
Request # Request Bus Address DMA0 DMA1<br>
---------- ----------------- ------- --------- ---------<br>
Request 0 ext periph req[0] 0x0000 dreq0 un-used<br>
Request 1 ext periph req[1] 0x0004 dreq1 un-used<br>
Request 2 ext periph req[2] 0x0008 dreq2 un-used<br>
Request 3 periph bus req[0] 0x000C un-used un-used<br>
Request 4 periph bus req[1] 0x0010 UART1 RX un-used<br>
Request 5 periph bus req[2] 0x0014 UART1 TX un-used<br>
Request 6 periph bus req[3] 0x0018 un-used SSP1 RX<br>
Request 7 periph bus req[4] 0x001C un-used SSP1 TX<br>
Request 8 periph bus req[5] 0x0020 un-used un-used<br>
Request 9 periph bus req[6] 0x0024 un-used un-used<br>
Request 10 periph bus req[7] 0x0028 un-used SSP2 RX<br>
Request 11 periph bus req[8] 0x002C un-used SSP2 TX<br>
Request 12 periph bus req[9] 0x0030 SSP3 RX TWSI4 RX<br>
Request 13 periph bus req[10] 0x0034 SSP3 TX TWSI4 TX<br>
Request 14 periph bus req[11] 0x0038 TWSI1 RX TWSI5 RX<br>
Request 15 periph bus req[12] 0x003C TWSI1 TX TWSI5 TX<br>
Request 16 periph bus req[13] 0x0040 TWSI2 RX TWSI6 RX<br>
Request 17 periph bus req[14] 0x0044 TWSI2 TX TWSI6 TX<br>
Request 18 periph bus req[15] 0x0048 TWSI3 RX UART4 RX<br>
Request 19 periph bus req[16] 0x004C TWSI3 TX UART4 TX<br>
Request 20 periph bus req[17] 0x0050 un-used UART2 RX<br>
Request 21 periph bus req[18] 0x0054 un-used UART2 TX<br>
Request 22 periph bus req[19] 0x0058 UART3 RX un-used<br>
Request 23 periph bus req[20] 0x005C UART3 TX un-used<br>
Request 24 system bus req[4] 0x0060 un-used un-used<br>
Request 25 system bus req[5] 0x0064 un-used un-used<br>
Request 26 system bus req[6] 0x0068 un-used un-used<br>
Request 27 system bus req[7] 0x006C un-used un-used<br>
Request 28 system bus req[0] 0x0070 NAND DATA un-used<br>
Request 29 system bus req[1] 0x0074 NAND CMD un-used<br>
Request 30 system bus req[2] 0x0078 un-used un-used<br>
Request 31 system bus req[3] 0x007C un-used un-used<br> (Instance 23 of 32)*/
//====================================================================

#define  PDMA_DMA_RCMRX22_RESERVED1_MASK 0xffffff00
#define  PDMA_DMA_RCMRX22_RESERVED1_SHIFT 8
#define  PDMA_DMA_RCMRX22_RESERVED1_MASK_SHIFT(reg) (((reg) & PDMA_DMA_RCMRX22_RESERVED1_MASK) >> PDMA_DMA_RCMRX22_RESERVED1_SHIFT)
#define  PDMA_DMA_RCMRX22_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_RCMRX22_RESERVED1_MASK) | (((uint32_t)val) << PDMA_DMA_RCMRX22_RESERVED1_SHIFT))

#define  PDMA_DMA_RCMRX22_MAPVLD_MASK 0x80
#define  PDMA_DMA_RCMRX22_MAPVLD_SHIFT 7
#define  PDMA_DMA_RCMRX22_MAPVLD_MASK_SHIFT(reg) (((reg) & PDMA_DMA_RCMRX22_MAPVLD_MASK) >> PDMA_DMA_RCMRX22_MAPVLD_SHIFT)
#define  PDMA_DMA_RCMRX22_MAPVLD_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_RCMRX22_MAPVLD_MASK) | (((uint32_t)val) << PDMA_DMA_RCMRX22_MAPVLD_SHIFT))

#define  PDMA_DMA_RCMRX22_RESERVED2_MASK 0x60
#define  PDMA_DMA_RCMRX22_RESERVED2_SHIFT 5
#define  PDMA_DMA_RCMRX22_RESERVED2_MASK_SHIFT(reg) (((reg) & PDMA_DMA_RCMRX22_RESERVED2_MASK) >> PDMA_DMA_RCMRX22_RESERVED2_SHIFT)
#define  PDMA_DMA_RCMRX22_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_RCMRX22_RESERVED2_MASK) | (((uint32_t)val) << PDMA_DMA_RCMRX22_RESERVED2_SHIFT))

#define  PDMA_DMA_RCMRX22_CHLNUM_MASK 0x1f
#define  PDMA_DMA_RCMRX22_CHLNUM_SHIFT 0
#define  PDMA_DMA_RCMRX22_CHLNUM_MASK_SHIFT(reg) (((reg) & PDMA_DMA_RCMRX22_CHLNUM_MASK) >> PDMA_DMA_RCMRX22_CHLNUM_SHIFT)
#define  PDMA_DMA_RCMRX22_CHLNUM_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_RCMRX22_CHLNUM_MASK) | (((uint32_t)val) << PDMA_DMA_RCMRX22_CHLNUM_SHIFT))

//====================================================================
//Register: DMA Request to Channel Map Registers 0-31 (Instance 24 of 32) (DMA_RCMRx23)
/** \brief These registers map the DMA request to a channel.
<br>
These are read/write registers. Ignore reads from reserved bits. Write 0x0 to
reserved bits.
<br>
Here is the address offset for each of the dma requests:
<br>
Request # Request Bus Address DMA0 DMA1<br>
---------- ----------------- ------- --------- ---------<br>
Request 0 ext periph req[0] 0x0000 dreq0 un-used<br>
Request 1 ext periph req[1] 0x0004 dreq1 un-used<br>
Request 2 ext periph req[2] 0x0008 dreq2 un-used<br>
Request 3 periph bus req[0] 0x000C un-used un-used<br>
Request 4 periph bus req[1] 0x0010 UART1 RX un-used<br>
Request 5 periph bus req[2] 0x0014 UART1 TX un-used<br>
Request 6 periph bus req[3] 0x0018 un-used SSP1 RX<br>
Request 7 periph bus req[4] 0x001C un-used SSP1 TX<br>
Request 8 periph bus req[5] 0x0020 un-used un-used<br>
Request 9 periph bus req[6] 0x0024 un-used un-used<br>
Request 10 periph bus req[7] 0x0028 un-used SSP2 RX<br>
Request 11 periph bus req[8] 0x002C un-used SSP2 TX<br>
Request 12 periph bus req[9] 0x0030 SSP3 RX TWSI4 RX<br>
Request 13 periph bus req[10] 0x0034 SSP3 TX TWSI4 TX<br>
Request 14 periph bus req[11] 0x0038 TWSI1 RX TWSI5 RX<br>
Request 15 periph bus req[12] 0x003C TWSI1 TX TWSI5 TX<br>
Request 16 periph bus req[13] 0x0040 TWSI2 RX TWSI6 RX<br>
Request 17 periph bus req[14] 0x0044 TWSI2 TX TWSI6 TX<br>
Request 18 periph bus req[15] 0x0048 TWSI3 RX UART4 RX<br>
Request 19 periph bus req[16] 0x004C TWSI3 TX UART4 TX<br>
Request 20 periph bus req[17] 0x0050 un-used UART2 RX<br>
Request 21 periph bus req[18] 0x0054 un-used UART2 TX<br>
Request 22 periph bus req[19] 0x0058 UART3 RX un-used<br>
Request 23 periph bus req[20] 0x005C UART3 TX un-used<br>
Request 24 system bus req[4] 0x0060 un-used un-used<br>
Request 25 system bus req[5] 0x0064 un-used un-used<br>
Request 26 system bus req[6] 0x0068 un-used un-used<br>
Request 27 system bus req[7] 0x006C un-used un-used<br>
Request 28 system bus req[0] 0x0070 NAND DATA un-used<br>
Request 29 system bus req[1] 0x0074 NAND CMD un-used<br>
Request 30 system bus req[2] 0x0078 un-used un-used<br>
Request 31 system bus req[3] 0x007C un-used un-used<br> (Instance 24 of 32)*/
//====================================================================

#define  PDMA_DMA_RCMRX23_RESERVED1_MASK 0xffffff00
#define  PDMA_DMA_RCMRX23_RESERVED1_SHIFT 8
#define  PDMA_DMA_RCMRX23_RESERVED1_MASK_SHIFT(reg) (((reg) & PDMA_DMA_RCMRX23_RESERVED1_MASK) >> PDMA_DMA_RCMRX23_RESERVED1_SHIFT)
#define  PDMA_DMA_RCMRX23_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_RCMRX23_RESERVED1_MASK) | (((uint32_t)val) << PDMA_DMA_RCMRX23_RESERVED1_SHIFT))

#define  PDMA_DMA_RCMRX23_MAPVLD_MASK 0x80
#define  PDMA_DMA_RCMRX23_MAPVLD_SHIFT 7
#define  PDMA_DMA_RCMRX23_MAPVLD_MASK_SHIFT(reg) (((reg) & PDMA_DMA_RCMRX23_MAPVLD_MASK) >> PDMA_DMA_RCMRX23_MAPVLD_SHIFT)
#define  PDMA_DMA_RCMRX23_MAPVLD_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_RCMRX23_MAPVLD_MASK) | (((uint32_t)val) << PDMA_DMA_RCMRX23_MAPVLD_SHIFT))

#define  PDMA_DMA_RCMRX23_RESERVED2_MASK 0x60
#define  PDMA_DMA_RCMRX23_RESERVED2_SHIFT 5
#define  PDMA_DMA_RCMRX23_RESERVED2_MASK_SHIFT(reg) (((reg) & PDMA_DMA_RCMRX23_RESERVED2_MASK) >> PDMA_DMA_RCMRX23_RESERVED2_SHIFT)
#define  PDMA_DMA_RCMRX23_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_RCMRX23_RESERVED2_MASK) | (((uint32_t)val) << PDMA_DMA_RCMRX23_RESERVED2_SHIFT))

#define  PDMA_DMA_RCMRX23_CHLNUM_MASK 0x1f
#define  PDMA_DMA_RCMRX23_CHLNUM_SHIFT 0
#define  PDMA_DMA_RCMRX23_CHLNUM_MASK_SHIFT(reg) (((reg) & PDMA_DMA_RCMRX23_CHLNUM_MASK) >> PDMA_DMA_RCMRX23_CHLNUM_SHIFT)
#define  PDMA_DMA_RCMRX23_CHLNUM_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_RCMRX23_CHLNUM_MASK) | (((uint32_t)val) << PDMA_DMA_RCMRX23_CHLNUM_SHIFT))

//====================================================================
//Register: DMA Request to Channel Map Registers 0-31 (Instance 25 of 32) (DMA_RCMRx24)
/** \brief These registers map the DMA request to a channel.
<br>
These are read/write registers. Ignore reads from reserved bits. Write 0x0 to
reserved bits.
<br>
Here is the address offset for each of the dma requests:
<br>
Request # Request Bus Address DMA0 DMA1<br>
---------- ----------------- ------- --------- ---------<br>
Request 0 ext periph req[0] 0x0000 dreq0 un-used<br>
Request 1 ext periph req[1] 0x0004 dreq1 un-used<br>
Request 2 ext periph req[2] 0x0008 dreq2 un-used<br>
Request 3 periph bus req[0] 0x000C un-used un-used<br>
Request 4 periph bus req[1] 0x0010 UART1 RX un-used<br>
Request 5 periph bus req[2] 0x0014 UART1 TX un-used<br>
Request 6 periph bus req[3] 0x0018 un-used SSP1 RX<br>
Request 7 periph bus req[4] 0x001C un-used SSP1 TX<br>
Request 8 periph bus req[5] 0x0020 un-used un-used<br>
Request 9 periph bus req[6] 0x0024 un-used un-used<br>
Request 10 periph bus req[7] 0x0028 un-used SSP2 RX<br>
Request 11 periph bus req[8] 0x002C un-used SSP2 TX<br>
Request 12 periph bus req[9] 0x0030 SSP3 RX TWSI4 RX<br>
Request 13 periph bus req[10] 0x0034 SSP3 TX TWSI4 TX<br>
Request 14 periph bus req[11] 0x0038 TWSI1 RX TWSI5 RX<br>
Request 15 periph bus req[12] 0x003C TWSI1 TX TWSI5 TX<br>
Request 16 periph bus req[13] 0x0040 TWSI2 RX TWSI6 RX<br>
Request 17 periph bus req[14] 0x0044 TWSI2 TX TWSI6 TX<br>
Request 18 periph bus req[15] 0x0048 TWSI3 RX UART4 RX<br>
Request 19 periph bus req[16] 0x004C TWSI3 TX UART4 TX<br>
Request 20 periph bus req[17] 0x0050 un-used UART2 RX<br>
Request 21 periph bus req[18] 0x0054 un-used UART2 TX<br>
Request 22 periph bus req[19] 0x0058 UART3 RX un-used<br>
Request 23 periph bus req[20] 0x005C UART3 TX un-used<br>
Request 24 system bus req[4] 0x0060 un-used un-used<br>
Request 25 system bus req[5] 0x0064 un-used un-used<br>
Request 26 system bus req[6] 0x0068 un-used un-used<br>
Request 27 system bus req[7] 0x006C un-used un-used<br>
Request 28 system bus req[0] 0x0070 NAND DATA un-used<br>
Request 29 system bus req[1] 0x0074 NAND CMD un-used<br>
Request 30 system bus req[2] 0x0078 un-used un-used<br>
Request 31 system bus req[3] 0x007C un-used un-used<br> (Instance 25 of 32)*/
//====================================================================

#define  PDMA_DMA_RCMRX24_RESERVED1_MASK 0xffffff00
#define  PDMA_DMA_RCMRX24_RESERVED1_SHIFT 8
#define  PDMA_DMA_RCMRX24_RESERVED1_MASK_SHIFT(reg) (((reg) & PDMA_DMA_RCMRX24_RESERVED1_MASK) >> PDMA_DMA_RCMRX24_RESERVED1_SHIFT)
#define  PDMA_DMA_RCMRX24_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_RCMRX24_RESERVED1_MASK) | (((uint32_t)val) << PDMA_DMA_RCMRX24_RESERVED1_SHIFT))

#define  PDMA_DMA_RCMRX24_MAPVLD_MASK 0x80
#define  PDMA_DMA_RCMRX24_MAPVLD_SHIFT 7
#define  PDMA_DMA_RCMRX24_MAPVLD_MASK_SHIFT(reg) (((reg) & PDMA_DMA_RCMRX24_MAPVLD_MASK) >> PDMA_DMA_RCMRX24_MAPVLD_SHIFT)
#define  PDMA_DMA_RCMRX24_MAPVLD_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_RCMRX24_MAPVLD_MASK) | (((uint32_t)val) << PDMA_DMA_RCMRX24_MAPVLD_SHIFT))

#define  PDMA_DMA_RCMRX24_RESERVED2_MASK 0x60
#define  PDMA_DMA_RCMRX24_RESERVED2_SHIFT 5
#define  PDMA_DMA_RCMRX24_RESERVED2_MASK_SHIFT(reg) (((reg) & PDMA_DMA_RCMRX24_RESERVED2_MASK) >> PDMA_DMA_RCMRX24_RESERVED2_SHIFT)
#define  PDMA_DMA_RCMRX24_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_RCMRX24_RESERVED2_MASK) | (((uint32_t)val) << PDMA_DMA_RCMRX24_RESERVED2_SHIFT))

#define  PDMA_DMA_RCMRX24_CHLNUM_MASK 0x1f
#define  PDMA_DMA_RCMRX24_CHLNUM_SHIFT 0
#define  PDMA_DMA_RCMRX24_CHLNUM_MASK_SHIFT(reg) (((reg) & PDMA_DMA_RCMRX24_CHLNUM_MASK) >> PDMA_DMA_RCMRX24_CHLNUM_SHIFT)
#define  PDMA_DMA_RCMRX24_CHLNUM_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_RCMRX24_CHLNUM_MASK) | (((uint32_t)val) << PDMA_DMA_RCMRX24_CHLNUM_SHIFT))

//====================================================================
//Register: DMA Request to Channel Map Registers 0-31 (Instance 26 of 32) (DMA_RCMRx25)
/** \brief These registers map the DMA request to a channel.
<br>
These are read/write registers. Ignore reads from reserved bits. Write 0x0 to
reserved bits.
<br>
Here is the address offset for each of the dma requests:
<br>
Request # Request Bus Address DMA0 DMA1<br>
---------- ----------------- ------- --------- ---------<br>
Request 0 ext periph req[0] 0x0000 dreq0 un-used<br>
Request 1 ext periph req[1] 0x0004 dreq1 un-used<br>
Request 2 ext periph req[2] 0x0008 dreq2 un-used<br>
Request 3 periph bus req[0] 0x000C un-used un-used<br>
Request 4 periph bus req[1] 0x0010 UART1 RX un-used<br>
Request 5 periph bus req[2] 0x0014 UART1 TX un-used<br>
Request 6 periph bus req[3] 0x0018 un-used SSP1 RX<br>
Request 7 periph bus req[4] 0x001C un-used SSP1 TX<br>
Request 8 periph bus req[5] 0x0020 un-used un-used<br>
Request 9 periph bus req[6] 0x0024 un-used un-used<br>
Request 10 periph bus req[7] 0x0028 un-used SSP2 RX<br>
Request 11 periph bus req[8] 0x002C un-used SSP2 TX<br>
Request 12 periph bus req[9] 0x0030 SSP3 RX TWSI4 RX<br>
Request 13 periph bus req[10] 0x0034 SSP3 TX TWSI4 TX<br>
Request 14 periph bus req[11] 0x0038 TWSI1 RX TWSI5 RX<br>
Request 15 periph bus req[12] 0x003C TWSI1 TX TWSI5 TX<br>
Request 16 periph bus req[13] 0x0040 TWSI2 RX TWSI6 RX<br>
Request 17 periph bus req[14] 0x0044 TWSI2 TX TWSI6 TX<br>
Request 18 periph bus req[15] 0x0048 TWSI3 RX UART4 RX<br>
Request 19 periph bus req[16] 0x004C TWSI3 TX UART4 TX<br>
Request 20 periph bus req[17] 0x0050 un-used UART2 RX<br>
Request 21 periph bus req[18] 0x0054 un-used UART2 TX<br>
Request 22 periph bus req[19] 0x0058 UART3 RX un-used<br>
Request 23 periph bus req[20] 0x005C UART3 TX un-used<br>
Request 24 system bus req[4] 0x0060 un-used un-used<br>
Request 25 system bus req[5] 0x0064 un-used un-used<br>
Request 26 system bus req[6] 0x0068 un-used un-used<br>
Request 27 system bus req[7] 0x006C un-used un-used<br>
Request 28 system bus req[0] 0x0070 NAND DATA un-used<br>
Request 29 system bus req[1] 0x0074 NAND CMD un-used<br>
Request 30 system bus req[2] 0x0078 un-used un-used<br>
Request 31 system bus req[3] 0x007C un-used un-used<br> (Instance 26 of 32)*/
//====================================================================

#define  PDMA_DMA_RCMRX25_RESERVED1_MASK 0xffffff00
#define  PDMA_DMA_RCMRX25_RESERVED1_SHIFT 8
#define  PDMA_DMA_RCMRX25_RESERVED1_MASK_SHIFT(reg) (((reg) & PDMA_DMA_RCMRX25_RESERVED1_MASK) >> PDMA_DMA_RCMRX25_RESERVED1_SHIFT)
#define  PDMA_DMA_RCMRX25_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_RCMRX25_RESERVED1_MASK) | (((uint32_t)val) << PDMA_DMA_RCMRX25_RESERVED1_SHIFT))

#define  PDMA_DMA_RCMRX25_MAPVLD_MASK 0x80
#define  PDMA_DMA_RCMRX25_MAPVLD_SHIFT 7
#define  PDMA_DMA_RCMRX25_MAPVLD_MASK_SHIFT(reg) (((reg) & PDMA_DMA_RCMRX25_MAPVLD_MASK) >> PDMA_DMA_RCMRX25_MAPVLD_SHIFT)
#define  PDMA_DMA_RCMRX25_MAPVLD_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_RCMRX25_MAPVLD_MASK) | (((uint32_t)val) << PDMA_DMA_RCMRX25_MAPVLD_SHIFT))

#define  PDMA_DMA_RCMRX25_RESERVED2_MASK 0x60
#define  PDMA_DMA_RCMRX25_RESERVED2_SHIFT 5
#define  PDMA_DMA_RCMRX25_RESERVED2_MASK_SHIFT(reg) (((reg) & PDMA_DMA_RCMRX25_RESERVED2_MASK) >> PDMA_DMA_RCMRX25_RESERVED2_SHIFT)
#define  PDMA_DMA_RCMRX25_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_RCMRX25_RESERVED2_MASK) | (((uint32_t)val) << PDMA_DMA_RCMRX25_RESERVED2_SHIFT))

#define  PDMA_DMA_RCMRX25_CHLNUM_MASK 0x1f
#define  PDMA_DMA_RCMRX25_CHLNUM_SHIFT 0
#define  PDMA_DMA_RCMRX25_CHLNUM_MASK_SHIFT(reg) (((reg) & PDMA_DMA_RCMRX25_CHLNUM_MASK) >> PDMA_DMA_RCMRX25_CHLNUM_SHIFT)
#define  PDMA_DMA_RCMRX25_CHLNUM_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_RCMRX25_CHLNUM_MASK) | (((uint32_t)val) << PDMA_DMA_RCMRX25_CHLNUM_SHIFT))

//====================================================================
//Register: DMA Request to Channel Map Registers 0-31 (Instance 27 of 32) (DMA_RCMRx26)
/** \brief These registers map the DMA request to a channel.
<br>
These are read/write registers. Ignore reads from reserved bits. Write 0x0 to
reserved bits.
<br>
Here is the address offset for each of the dma requests:
<br>
Request # Request Bus Address DMA0 DMA1<br>
---------- ----------------- ------- --------- ---------<br>
Request 0 ext periph req[0] 0x0000 dreq0 un-used<br>
Request 1 ext periph req[1] 0x0004 dreq1 un-used<br>
Request 2 ext periph req[2] 0x0008 dreq2 un-used<br>
Request 3 periph bus req[0] 0x000C un-used un-used<br>
Request 4 periph bus req[1] 0x0010 UART1 RX un-used<br>
Request 5 periph bus req[2] 0x0014 UART1 TX un-used<br>
Request 6 periph bus req[3] 0x0018 un-used SSP1 RX<br>
Request 7 periph bus req[4] 0x001C un-used SSP1 TX<br>
Request 8 periph bus req[5] 0x0020 un-used un-used<br>
Request 9 periph bus req[6] 0x0024 un-used un-used<br>
Request 10 periph bus req[7] 0x0028 un-used SSP2 RX<br>
Request 11 periph bus req[8] 0x002C un-used SSP2 TX<br>
Request 12 periph bus req[9] 0x0030 SSP3 RX TWSI4 RX<br>
Request 13 periph bus req[10] 0x0034 SSP3 TX TWSI4 TX<br>
Request 14 periph bus req[11] 0x0038 TWSI1 RX TWSI5 RX<br>
Request 15 periph bus req[12] 0x003C TWSI1 TX TWSI5 TX<br>
Request 16 periph bus req[13] 0x0040 TWSI2 RX TWSI6 RX<br>
Request 17 periph bus req[14] 0x0044 TWSI2 TX TWSI6 TX<br>
Request 18 periph bus req[15] 0x0048 TWSI3 RX UART4 RX<br>
Request 19 periph bus req[16] 0x004C TWSI3 TX UART4 TX<br>
Request 20 periph bus req[17] 0x0050 un-used UART2 RX<br>
Request 21 periph bus req[18] 0x0054 un-used UART2 TX<br>
Request 22 periph bus req[19] 0x0058 UART3 RX un-used<br>
Request 23 periph bus req[20] 0x005C UART3 TX un-used<br>
Request 24 system bus req[4] 0x0060 un-used un-used<br>
Request 25 system bus req[5] 0x0064 un-used un-used<br>
Request 26 system bus req[6] 0x0068 un-used un-used<br>
Request 27 system bus req[7] 0x006C un-used un-used<br>
Request 28 system bus req[0] 0x0070 NAND DATA un-used<br>
Request 29 system bus req[1] 0x0074 NAND CMD un-used<br>
Request 30 system bus req[2] 0x0078 un-used un-used<br>
Request 31 system bus req[3] 0x007C un-used un-used<br> (Instance 27 of 32)*/
//====================================================================

#define  PDMA_DMA_RCMRX26_RESERVED1_MASK 0xffffff00
#define  PDMA_DMA_RCMRX26_RESERVED1_SHIFT 8
#define  PDMA_DMA_RCMRX26_RESERVED1_MASK_SHIFT(reg) (((reg) & PDMA_DMA_RCMRX26_RESERVED1_MASK) >> PDMA_DMA_RCMRX26_RESERVED1_SHIFT)
#define  PDMA_DMA_RCMRX26_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_RCMRX26_RESERVED1_MASK) | (((uint32_t)val) << PDMA_DMA_RCMRX26_RESERVED1_SHIFT))

#define  PDMA_DMA_RCMRX26_MAPVLD_MASK 0x80
#define  PDMA_DMA_RCMRX26_MAPVLD_SHIFT 7
#define  PDMA_DMA_RCMRX26_MAPVLD_MASK_SHIFT(reg) (((reg) & PDMA_DMA_RCMRX26_MAPVLD_MASK) >> PDMA_DMA_RCMRX26_MAPVLD_SHIFT)
#define  PDMA_DMA_RCMRX26_MAPVLD_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_RCMRX26_MAPVLD_MASK) | (((uint32_t)val) << PDMA_DMA_RCMRX26_MAPVLD_SHIFT))

#define  PDMA_DMA_RCMRX26_RESERVED2_MASK 0x60
#define  PDMA_DMA_RCMRX26_RESERVED2_SHIFT 5
#define  PDMA_DMA_RCMRX26_RESERVED2_MASK_SHIFT(reg) (((reg) & PDMA_DMA_RCMRX26_RESERVED2_MASK) >> PDMA_DMA_RCMRX26_RESERVED2_SHIFT)
#define  PDMA_DMA_RCMRX26_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_RCMRX26_RESERVED2_MASK) | (((uint32_t)val) << PDMA_DMA_RCMRX26_RESERVED2_SHIFT))

#define  PDMA_DMA_RCMRX26_CHLNUM_MASK 0x1f
#define  PDMA_DMA_RCMRX26_CHLNUM_SHIFT 0
#define  PDMA_DMA_RCMRX26_CHLNUM_MASK_SHIFT(reg) (((reg) & PDMA_DMA_RCMRX26_CHLNUM_MASK) >> PDMA_DMA_RCMRX26_CHLNUM_SHIFT)
#define  PDMA_DMA_RCMRX26_CHLNUM_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_RCMRX26_CHLNUM_MASK) | (((uint32_t)val) << PDMA_DMA_RCMRX26_CHLNUM_SHIFT))

//====================================================================
//Register: DMA Request to Channel Map Registers 0-31 (Instance 28 of 32) (DMA_RCMRx27)
/** \brief These registers map the DMA request to a channel.
<br>
These are read/write registers. Ignore reads from reserved bits. Write 0x0 to
reserved bits.
<br>
Here is the address offset for each of the dma requests:
<br>
Request # Request Bus Address DMA0 DMA1<br>
---------- ----------------- ------- --------- ---------<br>
Request 0 ext periph req[0] 0x0000 dreq0 un-used<br>
Request 1 ext periph req[1] 0x0004 dreq1 un-used<br>
Request 2 ext periph req[2] 0x0008 dreq2 un-used<br>
Request 3 periph bus req[0] 0x000C un-used un-used<br>
Request 4 periph bus req[1] 0x0010 UART1 RX un-used<br>
Request 5 periph bus req[2] 0x0014 UART1 TX un-used<br>
Request 6 periph bus req[3] 0x0018 un-used SSP1 RX<br>
Request 7 periph bus req[4] 0x001C un-used SSP1 TX<br>
Request 8 periph bus req[5] 0x0020 un-used un-used<br>
Request 9 periph bus req[6] 0x0024 un-used un-used<br>
Request 10 periph bus req[7] 0x0028 un-used SSP2 RX<br>
Request 11 periph bus req[8] 0x002C un-used SSP2 TX<br>
Request 12 periph bus req[9] 0x0030 SSP3 RX TWSI4 RX<br>
Request 13 periph bus req[10] 0x0034 SSP3 TX TWSI4 TX<br>
Request 14 periph bus req[11] 0x0038 TWSI1 RX TWSI5 RX<br>
Request 15 periph bus req[12] 0x003C TWSI1 TX TWSI5 TX<br>
Request 16 periph bus req[13] 0x0040 TWSI2 RX TWSI6 RX<br>
Request 17 periph bus req[14] 0x0044 TWSI2 TX TWSI6 TX<br>
Request 18 periph bus req[15] 0x0048 TWSI3 RX UART4 RX<br>
Request 19 periph bus req[16] 0x004C TWSI3 TX UART4 TX<br>
Request 20 periph bus req[17] 0x0050 un-used UART2 RX<br>
Request 21 periph bus req[18] 0x0054 un-used UART2 TX<br>
Request 22 periph bus req[19] 0x0058 UART3 RX un-used<br>
Request 23 periph bus req[20] 0x005C UART3 TX un-used<br>
Request 24 system bus req[4] 0x0060 un-used un-used<br>
Request 25 system bus req[5] 0x0064 un-used un-used<br>
Request 26 system bus req[6] 0x0068 un-used un-used<br>
Request 27 system bus req[7] 0x006C un-used un-used<br>
Request 28 system bus req[0] 0x0070 NAND DATA un-used<br>
Request 29 system bus req[1] 0x0074 NAND CMD un-used<br>
Request 30 system bus req[2] 0x0078 un-used un-used<br>
Request 31 system bus req[3] 0x007C un-used un-used<br> (Instance 28 of 32)*/
//====================================================================

#define  PDMA_DMA_RCMRX27_RESERVED1_MASK 0xffffff00
#define  PDMA_DMA_RCMRX27_RESERVED1_SHIFT 8
#define  PDMA_DMA_RCMRX27_RESERVED1_MASK_SHIFT(reg) (((reg) & PDMA_DMA_RCMRX27_RESERVED1_MASK) >> PDMA_DMA_RCMRX27_RESERVED1_SHIFT)
#define  PDMA_DMA_RCMRX27_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_RCMRX27_RESERVED1_MASK) | (((uint32_t)val) << PDMA_DMA_RCMRX27_RESERVED1_SHIFT))

#define  PDMA_DMA_RCMRX27_MAPVLD_MASK 0x80
#define  PDMA_DMA_RCMRX27_MAPVLD_SHIFT 7
#define  PDMA_DMA_RCMRX27_MAPVLD_MASK_SHIFT(reg) (((reg) & PDMA_DMA_RCMRX27_MAPVLD_MASK) >> PDMA_DMA_RCMRX27_MAPVLD_SHIFT)
#define  PDMA_DMA_RCMRX27_MAPVLD_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_RCMRX27_MAPVLD_MASK) | (((uint32_t)val) << PDMA_DMA_RCMRX27_MAPVLD_SHIFT))

#define  PDMA_DMA_RCMRX27_RESERVED2_MASK 0x60
#define  PDMA_DMA_RCMRX27_RESERVED2_SHIFT 5
#define  PDMA_DMA_RCMRX27_RESERVED2_MASK_SHIFT(reg) (((reg) & PDMA_DMA_RCMRX27_RESERVED2_MASK) >> PDMA_DMA_RCMRX27_RESERVED2_SHIFT)
#define  PDMA_DMA_RCMRX27_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_RCMRX27_RESERVED2_MASK) | (((uint32_t)val) << PDMA_DMA_RCMRX27_RESERVED2_SHIFT))

#define  PDMA_DMA_RCMRX27_CHLNUM_MASK 0x1f
#define  PDMA_DMA_RCMRX27_CHLNUM_SHIFT 0
#define  PDMA_DMA_RCMRX27_CHLNUM_MASK_SHIFT(reg) (((reg) & PDMA_DMA_RCMRX27_CHLNUM_MASK) >> PDMA_DMA_RCMRX27_CHLNUM_SHIFT)
#define  PDMA_DMA_RCMRX27_CHLNUM_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_RCMRX27_CHLNUM_MASK) | (((uint32_t)val) << PDMA_DMA_RCMRX27_CHLNUM_SHIFT))

//====================================================================
//Register: DMA Request to Channel Map Registers 0-31 (Instance 29 of 32) (DMA_RCMRx28)
/** \brief These registers map the DMA request to a channel.
<br>
These are read/write registers. Ignore reads from reserved bits. Write 0x0 to
reserved bits.
<br>
Here is the address offset for each of the dma requests:
<br>
Request # Request Bus Address DMA0 DMA1<br>
---------- ----------------- ------- --------- ---------<br>
Request 0 ext periph req[0] 0x0000 dreq0 un-used<br>
Request 1 ext periph req[1] 0x0004 dreq1 un-used<br>
Request 2 ext periph req[2] 0x0008 dreq2 un-used<br>
Request 3 periph bus req[0] 0x000C un-used un-used<br>
Request 4 periph bus req[1] 0x0010 UART1 RX un-used<br>
Request 5 periph bus req[2] 0x0014 UART1 TX un-used<br>
Request 6 periph bus req[3] 0x0018 un-used SSP1 RX<br>
Request 7 periph bus req[4] 0x001C un-used SSP1 TX<br>
Request 8 periph bus req[5] 0x0020 un-used un-used<br>
Request 9 periph bus req[6] 0x0024 un-used un-used<br>
Request 10 periph bus req[7] 0x0028 un-used SSP2 RX<br>
Request 11 periph bus req[8] 0x002C un-used SSP2 TX<br>
Request 12 periph bus req[9] 0x0030 SSP3 RX TWSI4 RX<br>
Request 13 periph bus req[10] 0x0034 SSP3 TX TWSI4 TX<br>
Request 14 periph bus req[11] 0x0038 TWSI1 RX TWSI5 RX<br>
Request 15 periph bus req[12] 0x003C TWSI1 TX TWSI5 TX<br>
Request 16 periph bus req[13] 0x0040 TWSI2 RX TWSI6 RX<br>
Request 17 periph bus req[14] 0x0044 TWSI2 TX TWSI6 TX<br>
Request 18 periph bus req[15] 0x0048 TWSI3 RX UART4 RX<br>
Request 19 periph bus req[16] 0x004C TWSI3 TX UART4 TX<br>
Request 20 periph bus req[17] 0x0050 un-used UART2 RX<br>
Request 21 periph bus req[18] 0x0054 un-used UART2 TX<br>
Request 22 periph bus req[19] 0x0058 UART3 RX un-used<br>
Request 23 periph bus req[20] 0x005C UART3 TX un-used<br>
Request 24 system bus req[4] 0x0060 un-used un-used<br>
Request 25 system bus req[5] 0x0064 un-used un-used<br>
Request 26 system bus req[6] 0x0068 un-used un-used<br>
Request 27 system bus req[7] 0x006C un-used un-used<br>
Request 28 system bus req[0] 0x0070 NAND DATA un-used<br>
Request 29 system bus req[1] 0x0074 NAND CMD un-used<br>
Request 30 system bus req[2] 0x0078 un-used un-used<br>
Request 31 system bus req[3] 0x007C un-used un-used<br> (Instance 29 of 32)*/
//====================================================================

#define  PDMA_DMA_RCMRX28_RESERVED1_MASK 0xffffff00
#define  PDMA_DMA_RCMRX28_RESERVED1_SHIFT 8
#define  PDMA_DMA_RCMRX28_RESERVED1_MASK_SHIFT(reg) (((reg) & PDMA_DMA_RCMRX28_RESERVED1_MASK) >> PDMA_DMA_RCMRX28_RESERVED1_SHIFT)
#define  PDMA_DMA_RCMRX28_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_RCMRX28_RESERVED1_MASK) | (((uint32_t)val) << PDMA_DMA_RCMRX28_RESERVED1_SHIFT))

#define  PDMA_DMA_RCMRX28_MAPVLD_MASK 0x80
#define  PDMA_DMA_RCMRX28_MAPVLD_SHIFT 7
#define  PDMA_DMA_RCMRX28_MAPVLD_MASK_SHIFT(reg) (((reg) & PDMA_DMA_RCMRX28_MAPVLD_MASK) >> PDMA_DMA_RCMRX28_MAPVLD_SHIFT)
#define  PDMA_DMA_RCMRX28_MAPVLD_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_RCMRX28_MAPVLD_MASK) | (((uint32_t)val) << PDMA_DMA_RCMRX28_MAPVLD_SHIFT))

#define  PDMA_DMA_RCMRX28_RESERVED2_MASK 0x60
#define  PDMA_DMA_RCMRX28_RESERVED2_SHIFT 5
#define  PDMA_DMA_RCMRX28_RESERVED2_MASK_SHIFT(reg) (((reg) & PDMA_DMA_RCMRX28_RESERVED2_MASK) >> PDMA_DMA_RCMRX28_RESERVED2_SHIFT)
#define  PDMA_DMA_RCMRX28_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_RCMRX28_RESERVED2_MASK) | (((uint32_t)val) << PDMA_DMA_RCMRX28_RESERVED2_SHIFT))

#define  PDMA_DMA_RCMRX28_CHLNUM_MASK 0x1f
#define  PDMA_DMA_RCMRX28_CHLNUM_SHIFT 0
#define  PDMA_DMA_RCMRX28_CHLNUM_MASK_SHIFT(reg) (((reg) & PDMA_DMA_RCMRX28_CHLNUM_MASK) >> PDMA_DMA_RCMRX28_CHLNUM_SHIFT)
#define  PDMA_DMA_RCMRX28_CHLNUM_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_RCMRX28_CHLNUM_MASK) | (((uint32_t)val) << PDMA_DMA_RCMRX28_CHLNUM_SHIFT))

//====================================================================
//Register: DMA Request to Channel Map Registers 0-31 (Instance 30 of 32) (DMA_RCMRx29)
/** \brief These registers map the DMA request to a channel.
<br>
These are read/write registers. Ignore reads from reserved bits. Write 0x0 to
reserved bits.
<br>
Here is the address offset for each of the dma requests:
<br>
Request # Request Bus Address DMA0 DMA1<br>
---------- ----------------- ------- --------- ---------<br>
Request 0 ext periph req[0] 0x0000 dreq0 un-used<br>
Request 1 ext periph req[1] 0x0004 dreq1 un-used<br>
Request 2 ext periph req[2] 0x0008 dreq2 un-used<br>
Request 3 periph bus req[0] 0x000C un-used un-used<br>
Request 4 periph bus req[1] 0x0010 UART1 RX un-used<br>
Request 5 periph bus req[2] 0x0014 UART1 TX un-used<br>
Request 6 periph bus req[3] 0x0018 un-used SSP1 RX<br>
Request 7 periph bus req[4] 0x001C un-used SSP1 TX<br>
Request 8 periph bus req[5] 0x0020 un-used un-used<br>
Request 9 periph bus req[6] 0x0024 un-used un-used<br>
Request 10 periph bus req[7] 0x0028 un-used SSP2 RX<br>
Request 11 periph bus req[8] 0x002C un-used SSP2 TX<br>
Request 12 periph bus req[9] 0x0030 SSP3 RX TWSI4 RX<br>
Request 13 periph bus req[10] 0x0034 SSP3 TX TWSI4 TX<br>
Request 14 periph bus req[11] 0x0038 TWSI1 RX TWSI5 RX<br>
Request 15 periph bus req[12] 0x003C TWSI1 TX TWSI5 TX<br>
Request 16 periph bus req[13] 0x0040 TWSI2 RX TWSI6 RX<br>
Request 17 periph bus req[14] 0x0044 TWSI2 TX TWSI6 TX<br>
Request 18 periph bus req[15] 0x0048 TWSI3 RX UART4 RX<br>
Request 19 periph bus req[16] 0x004C TWSI3 TX UART4 TX<br>
Request 20 periph bus req[17] 0x0050 un-used UART2 RX<br>
Request 21 periph bus req[18] 0x0054 un-used UART2 TX<br>
Request 22 periph bus req[19] 0x0058 UART3 RX un-used<br>
Request 23 periph bus req[20] 0x005C UART3 TX un-used<br>
Request 24 system bus req[4] 0x0060 un-used un-used<br>
Request 25 system bus req[5] 0x0064 un-used un-used<br>
Request 26 system bus req[6] 0x0068 un-used un-used<br>
Request 27 system bus req[7] 0x006C un-used un-used<br>
Request 28 system bus req[0] 0x0070 NAND DATA un-used<br>
Request 29 system bus req[1] 0x0074 NAND CMD un-used<br>
Request 30 system bus req[2] 0x0078 un-used un-used<br>
Request 31 system bus req[3] 0x007C un-used un-used<br> (Instance 30 of 32)*/
//====================================================================

#define  PDMA_DMA_RCMRX29_RESERVED1_MASK 0xffffff00
#define  PDMA_DMA_RCMRX29_RESERVED1_SHIFT 8
#define  PDMA_DMA_RCMRX29_RESERVED1_MASK_SHIFT(reg) (((reg) & PDMA_DMA_RCMRX29_RESERVED1_MASK) >> PDMA_DMA_RCMRX29_RESERVED1_SHIFT)
#define  PDMA_DMA_RCMRX29_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_RCMRX29_RESERVED1_MASK) | (((uint32_t)val) << PDMA_DMA_RCMRX29_RESERVED1_SHIFT))

#define  PDMA_DMA_RCMRX29_MAPVLD_MASK 0x80
#define  PDMA_DMA_RCMRX29_MAPVLD_SHIFT 7
#define  PDMA_DMA_RCMRX29_MAPVLD_MASK_SHIFT(reg) (((reg) & PDMA_DMA_RCMRX29_MAPVLD_MASK) >> PDMA_DMA_RCMRX29_MAPVLD_SHIFT)
#define  PDMA_DMA_RCMRX29_MAPVLD_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_RCMRX29_MAPVLD_MASK) | (((uint32_t)val) << PDMA_DMA_RCMRX29_MAPVLD_SHIFT))

#define  PDMA_DMA_RCMRX29_RESERVED2_MASK 0x60
#define  PDMA_DMA_RCMRX29_RESERVED2_SHIFT 5
#define  PDMA_DMA_RCMRX29_RESERVED2_MASK_SHIFT(reg) (((reg) & PDMA_DMA_RCMRX29_RESERVED2_MASK) >> PDMA_DMA_RCMRX29_RESERVED2_SHIFT)
#define  PDMA_DMA_RCMRX29_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_RCMRX29_RESERVED2_MASK) | (((uint32_t)val) << PDMA_DMA_RCMRX29_RESERVED2_SHIFT))

#define  PDMA_DMA_RCMRX29_CHLNUM_MASK 0x1f
#define  PDMA_DMA_RCMRX29_CHLNUM_SHIFT 0
#define  PDMA_DMA_RCMRX29_CHLNUM_MASK_SHIFT(reg) (((reg) & PDMA_DMA_RCMRX29_CHLNUM_MASK) >> PDMA_DMA_RCMRX29_CHLNUM_SHIFT)
#define  PDMA_DMA_RCMRX29_CHLNUM_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_RCMRX29_CHLNUM_MASK) | (((uint32_t)val) << PDMA_DMA_RCMRX29_CHLNUM_SHIFT))

//====================================================================
//Register: DMA Request to Channel Map Registers 0-31 (Instance 31 of 32) (DMA_RCMRx30)
/** \brief These registers map the DMA request to a channel.
<br>
These are read/write registers. Ignore reads from reserved bits. Write 0x0 to
reserved bits.
<br>
Here is the address offset for each of the dma requests:
<br>
Request # Request Bus Address DMA0 DMA1<br>
---------- ----------------- ------- --------- ---------<br>
Request 0 ext periph req[0] 0x0000 dreq0 un-used<br>
Request 1 ext periph req[1] 0x0004 dreq1 un-used<br>
Request 2 ext periph req[2] 0x0008 dreq2 un-used<br>
Request 3 periph bus req[0] 0x000C un-used un-used<br>
Request 4 periph bus req[1] 0x0010 UART1 RX un-used<br>
Request 5 periph bus req[2] 0x0014 UART1 TX un-used<br>
Request 6 periph bus req[3] 0x0018 un-used SSP1 RX<br>
Request 7 periph bus req[4] 0x001C un-used SSP1 TX<br>
Request 8 periph bus req[5] 0x0020 un-used un-used<br>
Request 9 periph bus req[6] 0x0024 un-used un-used<br>
Request 10 periph bus req[7] 0x0028 un-used SSP2 RX<br>
Request 11 periph bus req[8] 0x002C un-used SSP2 TX<br>
Request 12 periph bus req[9] 0x0030 SSP3 RX TWSI4 RX<br>
Request 13 periph bus req[10] 0x0034 SSP3 TX TWSI4 TX<br>
Request 14 periph bus req[11] 0x0038 TWSI1 RX TWSI5 RX<br>
Request 15 periph bus req[12] 0x003C TWSI1 TX TWSI5 TX<br>
Request 16 periph bus req[13] 0x0040 TWSI2 RX TWSI6 RX<br>
Request 17 periph bus req[14] 0x0044 TWSI2 TX TWSI6 TX<br>
Request 18 periph bus req[15] 0x0048 TWSI3 RX UART4 RX<br>
Request 19 periph bus req[16] 0x004C TWSI3 TX UART4 TX<br>
Request 20 periph bus req[17] 0x0050 un-used UART2 RX<br>
Request 21 periph bus req[18] 0x0054 un-used UART2 TX<br>
Request 22 periph bus req[19] 0x0058 UART3 RX un-used<br>
Request 23 periph bus req[20] 0x005C UART3 TX un-used<br>
Request 24 system bus req[4] 0x0060 un-used un-used<br>
Request 25 system bus req[5] 0x0064 un-used un-used<br>
Request 26 system bus req[6] 0x0068 un-used un-used<br>
Request 27 system bus req[7] 0x006C un-used un-used<br>
Request 28 system bus req[0] 0x0070 NAND DATA un-used<br>
Request 29 system bus req[1] 0x0074 NAND CMD un-used<br>
Request 30 system bus req[2] 0x0078 un-used un-used<br>
Request 31 system bus req[3] 0x007C un-used un-used<br> (Instance 31 of 32)*/
//====================================================================

#define  PDMA_DMA_RCMRX30_RESERVED1_MASK 0xffffff00
#define  PDMA_DMA_RCMRX30_RESERVED1_SHIFT 8
#define  PDMA_DMA_RCMRX30_RESERVED1_MASK_SHIFT(reg) (((reg) & PDMA_DMA_RCMRX30_RESERVED1_MASK) >> PDMA_DMA_RCMRX30_RESERVED1_SHIFT)
#define  PDMA_DMA_RCMRX30_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_RCMRX30_RESERVED1_MASK) | (((uint32_t)val) << PDMA_DMA_RCMRX30_RESERVED1_SHIFT))

#define  PDMA_DMA_RCMRX30_MAPVLD_MASK 0x80
#define  PDMA_DMA_RCMRX30_MAPVLD_SHIFT 7
#define  PDMA_DMA_RCMRX30_MAPVLD_MASK_SHIFT(reg) (((reg) & PDMA_DMA_RCMRX30_MAPVLD_MASK) >> PDMA_DMA_RCMRX30_MAPVLD_SHIFT)
#define  PDMA_DMA_RCMRX30_MAPVLD_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_RCMRX30_MAPVLD_MASK) | (((uint32_t)val) << PDMA_DMA_RCMRX30_MAPVLD_SHIFT))

#define  PDMA_DMA_RCMRX30_RESERVED2_MASK 0x60
#define  PDMA_DMA_RCMRX30_RESERVED2_SHIFT 5
#define  PDMA_DMA_RCMRX30_RESERVED2_MASK_SHIFT(reg) (((reg) & PDMA_DMA_RCMRX30_RESERVED2_MASK) >> PDMA_DMA_RCMRX30_RESERVED2_SHIFT)
#define  PDMA_DMA_RCMRX30_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_RCMRX30_RESERVED2_MASK) | (((uint32_t)val) << PDMA_DMA_RCMRX30_RESERVED2_SHIFT))

#define  PDMA_DMA_RCMRX30_CHLNUM_MASK 0x1f
#define  PDMA_DMA_RCMRX30_CHLNUM_SHIFT 0
#define  PDMA_DMA_RCMRX30_CHLNUM_MASK_SHIFT(reg) (((reg) & PDMA_DMA_RCMRX30_CHLNUM_MASK) >> PDMA_DMA_RCMRX30_CHLNUM_SHIFT)
#define  PDMA_DMA_RCMRX30_CHLNUM_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_RCMRX30_CHLNUM_MASK) | (((uint32_t)val) << PDMA_DMA_RCMRX30_CHLNUM_SHIFT))

//====================================================================
//Register: DMA Request to Channel Map Registers 0-31 (Instance 32 of 32) (DMA_RCMRx31)
/** \brief These registers map the DMA request to a channel.
<br>
These are read/write registers. Ignore reads from reserved bits. Write 0x0 to
reserved bits.
<br>
Here is the address offset for each of the dma requests:
<br>
Request # Request Bus Address DMA0 DMA1<br>
---------- ----------------- ------- --------- ---------<br>
Request 0 ext periph req[0] 0x0000 dreq0 un-used<br>
Request 1 ext periph req[1] 0x0004 dreq1 un-used<br>
Request 2 ext periph req[2] 0x0008 dreq2 un-used<br>
Request 3 periph bus req[0] 0x000C un-used un-used<br>
Request 4 periph bus req[1] 0x0010 UART1 RX un-used<br>
Request 5 periph bus req[2] 0x0014 UART1 TX un-used<br>
Request 6 periph bus req[3] 0x0018 un-used SSP1 RX<br>
Request 7 periph bus req[4] 0x001C un-used SSP1 TX<br>
Request 8 periph bus req[5] 0x0020 un-used un-used<br>
Request 9 periph bus req[6] 0x0024 un-used un-used<br>
Request 10 periph bus req[7] 0x0028 un-used SSP2 RX<br>
Request 11 periph bus req[8] 0x002C un-used SSP2 TX<br>
Request 12 periph bus req[9] 0x0030 SSP3 RX TWSI4 RX<br>
Request 13 periph bus req[10] 0x0034 SSP3 TX TWSI4 TX<br>
Request 14 periph bus req[11] 0x0038 TWSI1 RX TWSI5 RX<br>
Request 15 periph bus req[12] 0x003C TWSI1 TX TWSI5 TX<br>
Request 16 periph bus req[13] 0x0040 TWSI2 RX TWSI6 RX<br>
Request 17 periph bus req[14] 0x0044 TWSI2 TX TWSI6 TX<br>
Request 18 periph bus req[15] 0x0048 TWSI3 RX UART4 RX<br>
Request 19 periph bus req[16] 0x004C TWSI3 TX UART4 TX<br>
Request 20 periph bus req[17] 0x0050 un-used UART2 RX<br>
Request 21 periph bus req[18] 0x0054 un-used UART2 TX<br>
Request 22 periph bus req[19] 0x0058 UART3 RX un-used<br>
Request 23 periph bus req[20] 0x005C UART3 TX un-used<br>
Request 24 system bus req[4] 0x0060 un-used un-used<br>
Request 25 system bus req[5] 0x0064 un-used un-used<br>
Request 26 system bus req[6] 0x0068 un-used un-used<br>
Request 27 system bus req[7] 0x006C un-used un-used<br>
Request 28 system bus req[0] 0x0070 NAND DATA un-used<br>
Request 29 system bus req[1] 0x0074 NAND CMD un-used<br>
Request 30 system bus req[2] 0x0078 un-used un-used<br>
Request 31 system bus req[3] 0x007C un-used un-used<br> (Instance 32 of 32)*/
//====================================================================

#define  PDMA_DMA_RCMRX31_RESERVED1_MASK 0xffffff00
#define  PDMA_DMA_RCMRX31_RESERVED1_SHIFT 8
#define  PDMA_DMA_RCMRX31_RESERVED1_MASK_SHIFT(reg) (((reg) & PDMA_DMA_RCMRX31_RESERVED1_MASK) >> PDMA_DMA_RCMRX31_RESERVED1_SHIFT)
#define  PDMA_DMA_RCMRX31_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_RCMRX31_RESERVED1_MASK) | (((uint32_t)val) << PDMA_DMA_RCMRX31_RESERVED1_SHIFT))

#define  PDMA_DMA_RCMRX31_MAPVLD_MASK 0x80
#define  PDMA_DMA_RCMRX31_MAPVLD_SHIFT 7
#define  PDMA_DMA_RCMRX31_MAPVLD_MASK_SHIFT(reg) (((reg) & PDMA_DMA_RCMRX31_MAPVLD_MASK) >> PDMA_DMA_RCMRX31_MAPVLD_SHIFT)
#define  PDMA_DMA_RCMRX31_MAPVLD_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_RCMRX31_MAPVLD_MASK) | (((uint32_t)val) << PDMA_DMA_RCMRX31_MAPVLD_SHIFT))

#define  PDMA_DMA_RCMRX31_RESERVED2_MASK 0x60
#define  PDMA_DMA_RCMRX31_RESERVED2_SHIFT 5
#define  PDMA_DMA_RCMRX31_RESERVED2_MASK_SHIFT(reg) (((reg) & PDMA_DMA_RCMRX31_RESERVED2_MASK) >> PDMA_DMA_RCMRX31_RESERVED2_SHIFT)
#define  PDMA_DMA_RCMRX31_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_RCMRX31_RESERVED2_MASK) | (((uint32_t)val) << PDMA_DMA_RCMRX31_RESERVED2_SHIFT))

#define  PDMA_DMA_RCMRX31_CHLNUM_MASK 0x1f
#define  PDMA_DMA_RCMRX31_CHLNUM_SHIFT 0
#define  PDMA_DMA_RCMRX31_CHLNUM_MASK_SHIFT(reg) (((reg) & PDMA_DMA_RCMRX31_CHLNUM_MASK) >> PDMA_DMA_RCMRX31_CHLNUM_SHIFT)
#define  PDMA_DMA_RCMRX31_CHLNUM_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_RCMRX31_CHLNUM_MASK) | (((uint32_t)val) << PDMA_DMA_RCMRX31_CHLNUM_SHIFT))

//====================================================================
//Register: DMA Descriptor Address Registers 0-15 (Instance 1 of 16) (DMA_DADR0)
/** \brief These registers contain the memory address of the next descriptor for
a channel. The fields in this register, except <Stop>, are undefined on
power up. <Stop> is cleared on power up. The address must be aligned to
a 128-bit (4-word) boundary. This register must not contain the address of
any other internal peripheral register or DMA register as this causes a bus
error.
<br>
This register is reserved if the channel is performing
a no-descriptor-fetch transaction.
<br>
These are read/write registers. Ignore reads from reserved bits. Write 0x0
to reserved bits. (Instance 1 of 16)*/
//====================================================================

#define  PDMA_DMA_DADR0_DESCRIPTOR_ADDRESS_MASK 0xfffffff0
#define  PDMA_DMA_DADR0_DESCRIPTOR_ADDRESS_SHIFT 4
#define  PDMA_DMA_DADR0_DESCRIPTOR_ADDRESS_MASK_SHIFT(reg) (((reg) & PDMA_DMA_DADR0_DESCRIPTOR_ADDRESS_MASK) >> PDMA_DMA_DADR0_DESCRIPTOR_ADDRESS_SHIFT)
#define  PDMA_DMA_DADR0_DESCRIPTOR_ADDRESS_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_DADR0_DESCRIPTOR_ADDRESS_MASK) | (((uint32_t)val) << PDMA_DMA_DADR0_DESCRIPTOR_ADDRESS_SHIFT))

#define  PDMA_DMA_DADR0_RESERVED1_MASK 0xc
#define  PDMA_DMA_DADR0_RESERVED1_SHIFT 2
#define  PDMA_DMA_DADR0_RESERVED1_MASK_SHIFT(reg) (((reg) & PDMA_DMA_DADR0_RESERVED1_MASK) >> PDMA_DMA_DADR0_RESERVED1_SHIFT)
#define  PDMA_DMA_DADR0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_DADR0_RESERVED1_MASK) | (((uint32_t)val) << PDMA_DMA_DADR0_RESERVED1_SHIFT))

#define  PDMA_DMA_DADR0_BREN_MASK 0x2
#define  PDMA_DMA_DADR0_BREN_SHIFT 1
#define  PDMA_DMA_DADR0_BREN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_DADR0_BREN_MASK) >> PDMA_DMA_DADR0_BREN_SHIFT)
#define  PDMA_DMA_DADR0_BREN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_DADR0_BREN_MASK) | (((uint32_t)val) << PDMA_DMA_DADR0_BREN_SHIFT))

#define  PDMA_DMA_DADR0_STOP_MASK 0x1
#define  PDMA_DMA_DADR0_STOP_SHIFT 0
#define  PDMA_DMA_DADR0_STOP_MASK_SHIFT(reg) (((reg) & PDMA_DMA_DADR0_STOP_MASK) >> PDMA_DMA_DADR0_STOP_SHIFT)
#define  PDMA_DMA_DADR0_STOP_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_DADR0_STOP_MASK) | (((uint32_t)val) << PDMA_DMA_DADR0_STOP_SHIFT))

//====================================================================
//Register: DMA Descriptor Address Registers 0-15 (Instance 2 of 16) (DMA_DADR1)
/** \brief These registers contain the memory address of the next descriptor for
a channel. The fields in this register, except <Stop>, are undefined on
power up. <Stop> is cleared on power up. The address must be aligned to
a 128-bit (4-word) boundary. This register must not contain the address of
any other internal peripheral register or DMA register as this causes a bus
error.
<br>
This register is reserved if the channel is performing
a no-descriptor-fetch transaction.
<br>
These are read/write registers. Ignore reads from reserved bits. Write 0x0
to reserved bits. (Instance 2 of 16)*/
//====================================================================

#define  PDMA_DMA_DADR1_DESCRIPTOR_ADDRESS_MASK 0xfffffff0
#define  PDMA_DMA_DADR1_DESCRIPTOR_ADDRESS_SHIFT 4
#define  PDMA_DMA_DADR1_DESCRIPTOR_ADDRESS_MASK_SHIFT(reg) (((reg) & PDMA_DMA_DADR1_DESCRIPTOR_ADDRESS_MASK) >> PDMA_DMA_DADR1_DESCRIPTOR_ADDRESS_SHIFT)
#define  PDMA_DMA_DADR1_DESCRIPTOR_ADDRESS_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_DADR1_DESCRIPTOR_ADDRESS_MASK) | (((uint32_t)val) << PDMA_DMA_DADR1_DESCRIPTOR_ADDRESS_SHIFT))

#define  PDMA_DMA_DADR1_RESERVED1_MASK 0xc
#define  PDMA_DMA_DADR1_RESERVED1_SHIFT 2
#define  PDMA_DMA_DADR1_RESERVED1_MASK_SHIFT(reg) (((reg) & PDMA_DMA_DADR1_RESERVED1_MASK) >> PDMA_DMA_DADR1_RESERVED1_SHIFT)
#define  PDMA_DMA_DADR1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_DADR1_RESERVED1_MASK) | (((uint32_t)val) << PDMA_DMA_DADR1_RESERVED1_SHIFT))

#define  PDMA_DMA_DADR1_BREN_MASK 0x2
#define  PDMA_DMA_DADR1_BREN_SHIFT 1
#define  PDMA_DMA_DADR1_BREN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_DADR1_BREN_MASK) >> PDMA_DMA_DADR1_BREN_SHIFT)
#define  PDMA_DMA_DADR1_BREN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_DADR1_BREN_MASK) | (((uint32_t)val) << PDMA_DMA_DADR1_BREN_SHIFT))

#define  PDMA_DMA_DADR1_STOP_MASK 0x1
#define  PDMA_DMA_DADR1_STOP_SHIFT 0
#define  PDMA_DMA_DADR1_STOP_MASK_SHIFT(reg) (((reg) & PDMA_DMA_DADR1_STOP_MASK) >> PDMA_DMA_DADR1_STOP_SHIFT)
#define  PDMA_DMA_DADR1_STOP_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_DADR1_STOP_MASK) | (((uint32_t)val) << PDMA_DMA_DADR1_STOP_SHIFT))

//====================================================================
//Register: DMA Descriptor Address Registers 0-15 (Instance 3 of 16) (DMA_DADR2)
/** \brief These registers contain the memory address of the next descriptor for
a channel. The fields in this register, except <Stop>, are undefined on
power up. <Stop> is cleared on power up. The address must be aligned to
a 128-bit (4-word) boundary. This register must not contain the address of
any other internal peripheral register or DMA register as this causes a bus
error.
<br>
This register is reserved if the channel is performing
a no-descriptor-fetch transaction.
<br>
These are read/write registers. Ignore reads from reserved bits. Write 0x0
to reserved bits. (Instance 3 of 16)*/
//====================================================================

#define  PDMA_DMA_DADR2_DESCRIPTOR_ADDRESS_MASK 0xfffffff0
#define  PDMA_DMA_DADR2_DESCRIPTOR_ADDRESS_SHIFT 4
#define  PDMA_DMA_DADR2_DESCRIPTOR_ADDRESS_MASK_SHIFT(reg) (((reg) & PDMA_DMA_DADR2_DESCRIPTOR_ADDRESS_MASK) >> PDMA_DMA_DADR2_DESCRIPTOR_ADDRESS_SHIFT)
#define  PDMA_DMA_DADR2_DESCRIPTOR_ADDRESS_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_DADR2_DESCRIPTOR_ADDRESS_MASK) | (((uint32_t)val) << PDMA_DMA_DADR2_DESCRIPTOR_ADDRESS_SHIFT))

#define  PDMA_DMA_DADR2_RESERVED1_MASK 0xc
#define  PDMA_DMA_DADR2_RESERVED1_SHIFT 2
#define  PDMA_DMA_DADR2_RESERVED1_MASK_SHIFT(reg) (((reg) & PDMA_DMA_DADR2_RESERVED1_MASK) >> PDMA_DMA_DADR2_RESERVED1_SHIFT)
#define  PDMA_DMA_DADR2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_DADR2_RESERVED1_MASK) | (((uint32_t)val) << PDMA_DMA_DADR2_RESERVED1_SHIFT))

#define  PDMA_DMA_DADR2_BREN_MASK 0x2
#define  PDMA_DMA_DADR2_BREN_SHIFT 1
#define  PDMA_DMA_DADR2_BREN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_DADR2_BREN_MASK) >> PDMA_DMA_DADR2_BREN_SHIFT)
#define  PDMA_DMA_DADR2_BREN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_DADR2_BREN_MASK) | (((uint32_t)val) << PDMA_DMA_DADR2_BREN_SHIFT))

#define  PDMA_DMA_DADR2_STOP_MASK 0x1
#define  PDMA_DMA_DADR2_STOP_SHIFT 0
#define  PDMA_DMA_DADR2_STOP_MASK_SHIFT(reg) (((reg) & PDMA_DMA_DADR2_STOP_MASK) >> PDMA_DMA_DADR2_STOP_SHIFT)
#define  PDMA_DMA_DADR2_STOP_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_DADR2_STOP_MASK) | (((uint32_t)val) << PDMA_DMA_DADR2_STOP_SHIFT))

//====================================================================
//Register: DMA Descriptor Address Registers 0-15 (Instance 4 of 16) (DMA_DADR3)
/** \brief These registers contain the memory address of the next descriptor for
a channel. The fields in this register, except <Stop>, are undefined on
power up. <Stop> is cleared on power up. The address must be aligned to
a 128-bit (4-word) boundary. This register must not contain the address of
any other internal peripheral register or DMA register as this causes a bus
error.
<br>
This register is reserved if the channel is performing
a no-descriptor-fetch transaction.
<br>
These are read/write registers. Ignore reads from reserved bits. Write 0x0
to reserved bits. (Instance 4 of 16)*/
//====================================================================

#define  PDMA_DMA_DADR3_DESCRIPTOR_ADDRESS_MASK 0xfffffff0
#define  PDMA_DMA_DADR3_DESCRIPTOR_ADDRESS_SHIFT 4
#define  PDMA_DMA_DADR3_DESCRIPTOR_ADDRESS_MASK_SHIFT(reg) (((reg) & PDMA_DMA_DADR3_DESCRIPTOR_ADDRESS_MASK) >> PDMA_DMA_DADR3_DESCRIPTOR_ADDRESS_SHIFT)
#define  PDMA_DMA_DADR3_DESCRIPTOR_ADDRESS_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_DADR3_DESCRIPTOR_ADDRESS_MASK) | (((uint32_t)val) << PDMA_DMA_DADR3_DESCRIPTOR_ADDRESS_SHIFT))

#define  PDMA_DMA_DADR3_RESERVED1_MASK 0xc
#define  PDMA_DMA_DADR3_RESERVED1_SHIFT 2
#define  PDMA_DMA_DADR3_RESERVED1_MASK_SHIFT(reg) (((reg) & PDMA_DMA_DADR3_RESERVED1_MASK) >> PDMA_DMA_DADR3_RESERVED1_SHIFT)
#define  PDMA_DMA_DADR3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_DADR3_RESERVED1_MASK) | (((uint32_t)val) << PDMA_DMA_DADR3_RESERVED1_SHIFT))

#define  PDMA_DMA_DADR3_BREN_MASK 0x2
#define  PDMA_DMA_DADR3_BREN_SHIFT 1
#define  PDMA_DMA_DADR3_BREN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_DADR3_BREN_MASK) >> PDMA_DMA_DADR3_BREN_SHIFT)
#define  PDMA_DMA_DADR3_BREN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_DADR3_BREN_MASK) | (((uint32_t)val) << PDMA_DMA_DADR3_BREN_SHIFT))

#define  PDMA_DMA_DADR3_STOP_MASK 0x1
#define  PDMA_DMA_DADR3_STOP_SHIFT 0
#define  PDMA_DMA_DADR3_STOP_MASK_SHIFT(reg) (((reg) & PDMA_DMA_DADR3_STOP_MASK) >> PDMA_DMA_DADR3_STOP_SHIFT)
#define  PDMA_DMA_DADR3_STOP_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_DADR3_STOP_MASK) | (((uint32_t)val) << PDMA_DMA_DADR3_STOP_SHIFT))

//====================================================================
//Register: DMA Descriptor Address Registers 0-15 (Instance 5 of 16) (DMA_DADR4)
/** \brief These registers contain the memory address of the next descriptor for
a channel. The fields in this register, except <Stop>, are undefined on
power up. <Stop> is cleared on power up. The address must be aligned to
a 128-bit (4-word) boundary. This register must not contain the address of
any other internal peripheral register or DMA register as this causes a bus
error.
<br>
This register is reserved if the channel is performing
a no-descriptor-fetch transaction.
<br>
These are read/write registers. Ignore reads from reserved bits. Write 0x0
to reserved bits. (Instance 5 of 16)*/
//====================================================================

#define  PDMA_DMA_DADR4_DESCRIPTOR_ADDRESS_MASK 0xfffffff0
#define  PDMA_DMA_DADR4_DESCRIPTOR_ADDRESS_SHIFT 4
#define  PDMA_DMA_DADR4_DESCRIPTOR_ADDRESS_MASK_SHIFT(reg) (((reg) & PDMA_DMA_DADR4_DESCRIPTOR_ADDRESS_MASK) >> PDMA_DMA_DADR4_DESCRIPTOR_ADDRESS_SHIFT)
#define  PDMA_DMA_DADR4_DESCRIPTOR_ADDRESS_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_DADR4_DESCRIPTOR_ADDRESS_MASK) | (((uint32_t)val) << PDMA_DMA_DADR4_DESCRIPTOR_ADDRESS_SHIFT))

#define  PDMA_DMA_DADR4_RESERVED1_MASK 0xc
#define  PDMA_DMA_DADR4_RESERVED1_SHIFT 2
#define  PDMA_DMA_DADR4_RESERVED1_MASK_SHIFT(reg) (((reg) & PDMA_DMA_DADR4_RESERVED1_MASK) >> PDMA_DMA_DADR4_RESERVED1_SHIFT)
#define  PDMA_DMA_DADR4_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_DADR4_RESERVED1_MASK) | (((uint32_t)val) << PDMA_DMA_DADR4_RESERVED1_SHIFT))

#define  PDMA_DMA_DADR4_BREN_MASK 0x2
#define  PDMA_DMA_DADR4_BREN_SHIFT 1
#define  PDMA_DMA_DADR4_BREN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_DADR4_BREN_MASK) >> PDMA_DMA_DADR4_BREN_SHIFT)
#define  PDMA_DMA_DADR4_BREN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_DADR4_BREN_MASK) | (((uint32_t)val) << PDMA_DMA_DADR4_BREN_SHIFT))

#define  PDMA_DMA_DADR4_STOP_MASK 0x1
#define  PDMA_DMA_DADR4_STOP_SHIFT 0
#define  PDMA_DMA_DADR4_STOP_MASK_SHIFT(reg) (((reg) & PDMA_DMA_DADR4_STOP_MASK) >> PDMA_DMA_DADR4_STOP_SHIFT)
#define  PDMA_DMA_DADR4_STOP_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_DADR4_STOP_MASK) | (((uint32_t)val) << PDMA_DMA_DADR4_STOP_SHIFT))

//====================================================================
//Register: DMA Descriptor Address Registers 0-15 (Instance 6 of 16) (DMA_DADR5)
/** \brief These registers contain the memory address of the next descriptor for
a channel. The fields in this register, except <Stop>, are undefined on
power up. <Stop> is cleared on power up. The address must be aligned to
a 128-bit (4-word) boundary. This register must not contain the address of
any other internal peripheral register or DMA register as this causes a bus
error.
<br>
This register is reserved if the channel is performing
a no-descriptor-fetch transaction.
<br>
These are read/write registers. Ignore reads from reserved bits. Write 0x0
to reserved bits. (Instance 6 of 16)*/
//====================================================================

#define  PDMA_DMA_DADR5_DESCRIPTOR_ADDRESS_MASK 0xfffffff0
#define  PDMA_DMA_DADR5_DESCRIPTOR_ADDRESS_SHIFT 4
#define  PDMA_DMA_DADR5_DESCRIPTOR_ADDRESS_MASK_SHIFT(reg) (((reg) & PDMA_DMA_DADR5_DESCRIPTOR_ADDRESS_MASK) >> PDMA_DMA_DADR5_DESCRIPTOR_ADDRESS_SHIFT)
#define  PDMA_DMA_DADR5_DESCRIPTOR_ADDRESS_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_DADR5_DESCRIPTOR_ADDRESS_MASK) | (((uint32_t)val) << PDMA_DMA_DADR5_DESCRIPTOR_ADDRESS_SHIFT))

#define  PDMA_DMA_DADR5_RESERVED1_MASK 0xc
#define  PDMA_DMA_DADR5_RESERVED1_SHIFT 2
#define  PDMA_DMA_DADR5_RESERVED1_MASK_SHIFT(reg) (((reg) & PDMA_DMA_DADR5_RESERVED1_MASK) >> PDMA_DMA_DADR5_RESERVED1_SHIFT)
#define  PDMA_DMA_DADR5_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_DADR5_RESERVED1_MASK) | (((uint32_t)val) << PDMA_DMA_DADR5_RESERVED1_SHIFT))

#define  PDMA_DMA_DADR5_BREN_MASK 0x2
#define  PDMA_DMA_DADR5_BREN_SHIFT 1
#define  PDMA_DMA_DADR5_BREN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_DADR5_BREN_MASK) >> PDMA_DMA_DADR5_BREN_SHIFT)
#define  PDMA_DMA_DADR5_BREN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_DADR5_BREN_MASK) | (((uint32_t)val) << PDMA_DMA_DADR5_BREN_SHIFT))

#define  PDMA_DMA_DADR5_STOP_MASK 0x1
#define  PDMA_DMA_DADR5_STOP_SHIFT 0
#define  PDMA_DMA_DADR5_STOP_MASK_SHIFT(reg) (((reg) & PDMA_DMA_DADR5_STOP_MASK) >> PDMA_DMA_DADR5_STOP_SHIFT)
#define  PDMA_DMA_DADR5_STOP_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_DADR5_STOP_MASK) | (((uint32_t)val) << PDMA_DMA_DADR5_STOP_SHIFT))

//====================================================================
//Register: DMA Descriptor Address Registers 0-15 (Instance 7 of 16) (DMA_DADR6)
/** \brief These registers contain the memory address of the next descriptor for
a channel. The fields in this register, except <Stop>, are undefined on
power up. <Stop> is cleared on power up. The address must be aligned to
a 128-bit (4-word) boundary. This register must not contain the address of
any other internal peripheral register or DMA register as this causes a bus
error.
<br>
This register is reserved if the channel is performing
a no-descriptor-fetch transaction.
<br>
These are read/write registers. Ignore reads from reserved bits. Write 0x0
to reserved bits. (Instance 7 of 16)*/
//====================================================================

#define  PDMA_DMA_DADR6_DESCRIPTOR_ADDRESS_MASK 0xfffffff0
#define  PDMA_DMA_DADR6_DESCRIPTOR_ADDRESS_SHIFT 4
#define  PDMA_DMA_DADR6_DESCRIPTOR_ADDRESS_MASK_SHIFT(reg) (((reg) & PDMA_DMA_DADR6_DESCRIPTOR_ADDRESS_MASK) >> PDMA_DMA_DADR6_DESCRIPTOR_ADDRESS_SHIFT)
#define  PDMA_DMA_DADR6_DESCRIPTOR_ADDRESS_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_DADR6_DESCRIPTOR_ADDRESS_MASK) | (((uint32_t)val) << PDMA_DMA_DADR6_DESCRIPTOR_ADDRESS_SHIFT))

#define  PDMA_DMA_DADR6_RESERVED1_MASK 0xc
#define  PDMA_DMA_DADR6_RESERVED1_SHIFT 2
#define  PDMA_DMA_DADR6_RESERVED1_MASK_SHIFT(reg) (((reg) & PDMA_DMA_DADR6_RESERVED1_MASK) >> PDMA_DMA_DADR6_RESERVED1_SHIFT)
#define  PDMA_DMA_DADR6_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_DADR6_RESERVED1_MASK) | (((uint32_t)val) << PDMA_DMA_DADR6_RESERVED1_SHIFT))

#define  PDMA_DMA_DADR6_BREN_MASK 0x2
#define  PDMA_DMA_DADR6_BREN_SHIFT 1
#define  PDMA_DMA_DADR6_BREN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_DADR6_BREN_MASK) >> PDMA_DMA_DADR6_BREN_SHIFT)
#define  PDMA_DMA_DADR6_BREN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_DADR6_BREN_MASK) | (((uint32_t)val) << PDMA_DMA_DADR6_BREN_SHIFT))

#define  PDMA_DMA_DADR6_STOP_MASK 0x1
#define  PDMA_DMA_DADR6_STOP_SHIFT 0
#define  PDMA_DMA_DADR6_STOP_MASK_SHIFT(reg) (((reg) & PDMA_DMA_DADR6_STOP_MASK) >> PDMA_DMA_DADR6_STOP_SHIFT)
#define  PDMA_DMA_DADR6_STOP_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_DADR6_STOP_MASK) | (((uint32_t)val) << PDMA_DMA_DADR6_STOP_SHIFT))

//====================================================================
//Register: DMA Descriptor Address Registers 0-15 (Instance 8 of 16) (DMA_DADR7)
/** \brief These registers contain the memory address of the next descriptor for
a channel. The fields in this register, except <Stop>, are undefined on
power up. <Stop> is cleared on power up. The address must be aligned to
a 128-bit (4-word) boundary. This register must not contain the address of
any other internal peripheral register or DMA register as this causes a bus
error.
<br>
This register is reserved if the channel is performing
a no-descriptor-fetch transaction.
<br>
These are read/write registers. Ignore reads from reserved bits. Write 0x0
to reserved bits. (Instance 8 of 16)*/
//====================================================================

#define  PDMA_DMA_DADR7_DESCRIPTOR_ADDRESS_MASK 0xfffffff0
#define  PDMA_DMA_DADR7_DESCRIPTOR_ADDRESS_SHIFT 4
#define  PDMA_DMA_DADR7_DESCRIPTOR_ADDRESS_MASK_SHIFT(reg) (((reg) & PDMA_DMA_DADR7_DESCRIPTOR_ADDRESS_MASK) >> PDMA_DMA_DADR7_DESCRIPTOR_ADDRESS_SHIFT)
#define  PDMA_DMA_DADR7_DESCRIPTOR_ADDRESS_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_DADR7_DESCRIPTOR_ADDRESS_MASK) | (((uint32_t)val) << PDMA_DMA_DADR7_DESCRIPTOR_ADDRESS_SHIFT))

#define  PDMA_DMA_DADR7_RESERVED1_MASK 0xc
#define  PDMA_DMA_DADR7_RESERVED1_SHIFT 2
#define  PDMA_DMA_DADR7_RESERVED1_MASK_SHIFT(reg) (((reg) & PDMA_DMA_DADR7_RESERVED1_MASK) >> PDMA_DMA_DADR7_RESERVED1_SHIFT)
#define  PDMA_DMA_DADR7_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_DADR7_RESERVED1_MASK) | (((uint32_t)val) << PDMA_DMA_DADR7_RESERVED1_SHIFT))

#define  PDMA_DMA_DADR7_BREN_MASK 0x2
#define  PDMA_DMA_DADR7_BREN_SHIFT 1
#define  PDMA_DMA_DADR7_BREN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_DADR7_BREN_MASK) >> PDMA_DMA_DADR7_BREN_SHIFT)
#define  PDMA_DMA_DADR7_BREN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_DADR7_BREN_MASK) | (((uint32_t)val) << PDMA_DMA_DADR7_BREN_SHIFT))

#define  PDMA_DMA_DADR7_STOP_MASK 0x1
#define  PDMA_DMA_DADR7_STOP_SHIFT 0
#define  PDMA_DMA_DADR7_STOP_MASK_SHIFT(reg) (((reg) & PDMA_DMA_DADR7_STOP_MASK) >> PDMA_DMA_DADR7_STOP_SHIFT)
#define  PDMA_DMA_DADR7_STOP_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_DADR7_STOP_MASK) | (((uint32_t)val) << PDMA_DMA_DADR7_STOP_SHIFT))

//====================================================================
//Register: DMA Descriptor Address Registers 0-15 (Instance 9 of 16) (DMA_DADR8)
/** \brief These registers contain the memory address of the next descriptor for
a channel. The fields in this register, except <Stop>, are undefined on
power up. <Stop> is cleared on power up. The address must be aligned to
a 128-bit (4-word) boundary. This register must not contain the address of
any other internal peripheral register or DMA register as this causes a bus
error.
<br>
This register is reserved if the channel is performing
a no-descriptor-fetch transaction.
<br>
These are read/write registers. Ignore reads from reserved bits. Write 0x0
to reserved bits. (Instance 9 of 16)*/
//====================================================================

#define  PDMA_DMA_DADR8_DESCRIPTOR_ADDRESS_MASK 0xfffffff0
#define  PDMA_DMA_DADR8_DESCRIPTOR_ADDRESS_SHIFT 4
#define  PDMA_DMA_DADR8_DESCRIPTOR_ADDRESS_MASK_SHIFT(reg) (((reg) & PDMA_DMA_DADR8_DESCRIPTOR_ADDRESS_MASK) >> PDMA_DMA_DADR8_DESCRIPTOR_ADDRESS_SHIFT)
#define  PDMA_DMA_DADR8_DESCRIPTOR_ADDRESS_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_DADR8_DESCRIPTOR_ADDRESS_MASK) | (((uint32_t)val) << PDMA_DMA_DADR8_DESCRIPTOR_ADDRESS_SHIFT))

#define  PDMA_DMA_DADR8_RESERVED1_MASK 0xc
#define  PDMA_DMA_DADR8_RESERVED1_SHIFT 2
#define  PDMA_DMA_DADR8_RESERVED1_MASK_SHIFT(reg) (((reg) & PDMA_DMA_DADR8_RESERVED1_MASK) >> PDMA_DMA_DADR8_RESERVED1_SHIFT)
#define  PDMA_DMA_DADR8_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_DADR8_RESERVED1_MASK) | (((uint32_t)val) << PDMA_DMA_DADR8_RESERVED1_SHIFT))

#define  PDMA_DMA_DADR8_BREN_MASK 0x2
#define  PDMA_DMA_DADR8_BREN_SHIFT 1
#define  PDMA_DMA_DADR8_BREN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_DADR8_BREN_MASK) >> PDMA_DMA_DADR8_BREN_SHIFT)
#define  PDMA_DMA_DADR8_BREN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_DADR8_BREN_MASK) | (((uint32_t)val) << PDMA_DMA_DADR8_BREN_SHIFT))

#define  PDMA_DMA_DADR8_STOP_MASK 0x1
#define  PDMA_DMA_DADR8_STOP_SHIFT 0
#define  PDMA_DMA_DADR8_STOP_MASK_SHIFT(reg) (((reg) & PDMA_DMA_DADR8_STOP_MASK) >> PDMA_DMA_DADR8_STOP_SHIFT)
#define  PDMA_DMA_DADR8_STOP_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_DADR8_STOP_MASK) | (((uint32_t)val) << PDMA_DMA_DADR8_STOP_SHIFT))

//====================================================================
//Register: DMA Descriptor Address Registers 0-15 (Instance 10 of 16) (DMA_DADR9)
/** \brief These registers contain the memory address of the next descriptor for
a channel. The fields in this register, except <Stop>, are undefined on
power up. <Stop> is cleared on power up. The address must be aligned to
a 128-bit (4-word) boundary. This register must not contain the address of
any other internal peripheral register or DMA register as this causes a bus
error.
<br>
This register is reserved if the channel is performing
a no-descriptor-fetch transaction.
<br>
These are read/write registers. Ignore reads from reserved bits. Write 0x0
to reserved bits. (Instance 10 of 16)*/
//====================================================================

#define  PDMA_DMA_DADR9_DESCRIPTOR_ADDRESS_MASK 0xfffffff0
#define  PDMA_DMA_DADR9_DESCRIPTOR_ADDRESS_SHIFT 4
#define  PDMA_DMA_DADR9_DESCRIPTOR_ADDRESS_MASK_SHIFT(reg) (((reg) & PDMA_DMA_DADR9_DESCRIPTOR_ADDRESS_MASK) >> PDMA_DMA_DADR9_DESCRIPTOR_ADDRESS_SHIFT)
#define  PDMA_DMA_DADR9_DESCRIPTOR_ADDRESS_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_DADR9_DESCRIPTOR_ADDRESS_MASK) | (((uint32_t)val) << PDMA_DMA_DADR9_DESCRIPTOR_ADDRESS_SHIFT))

#define  PDMA_DMA_DADR9_RESERVED1_MASK 0xc
#define  PDMA_DMA_DADR9_RESERVED1_SHIFT 2
#define  PDMA_DMA_DADR9_RESERVED1_MASK_SHIFT(reg) (((reg) & PDMA_DMA_DADR9_RESERVED1_MASK) >> PDMA_DMA_DADR9_RESERVED1_SHIFT)
#define  PDMA_DMA_DADR9_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_DADR9_RESERVED1_MASK) | (((uint32_t)val) << PDMA_DMA_DADR9_RESERVED1_SHIFT))

#define  PDMA_DMA_DADR9_BREN_MASK 0x2
#define  PDMA_DMA_DADR9_BREN_SHIFT 1
#define  PDMA_DMA_DADR9_BREN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_DADR9_BREN_MASK) >> PDMA_DMA_DADR9_BREN_SHIFT)
#define  PDMA_DMA_DADR9_BREN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_DADR9_BREN_MASK) | (((uint32_t)val) << PDMA_DMA_DADR9_BREN_SHIFT))

#define  PDMA_DMA_DADR9_STOP_MASK 0x1
#define  PDMA_DMA_DADR9_STOP_SHIFT 0
#define  PDMA_DMA_DADR9_STOP_MASK_SHIFT(reg) (((reg) & PDMA_DMA_DADR9_STOP_MASK) >> PDMA_DMA_DADR9_STOP_SHIFT)
#define  PDMA_DMA_DADR9_STOP_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_DADR9_STOP_MASK) | (((uint32_t)val) << PDMA_DMA_DADR9_STOP_SHIFT))

//====================================================================
//Register: DMA Descriptor Address Registers 0-15 (Instance 11 of 16) (DMA_DADR10)
/** \brief These registers contain the memory address of the next descriptor for
a channel. The fields in this register, except <Stop>, are undefined on
power up. <Stop> is cleared on power up. The address must be aligned to
a 128-bit (4-word) boundary. This register must not contain the address of
any other internal peripheral register or DMA register as this causes a bus
error.
<br>
This register is reserved if the channel is performing
a no-descriptor-fetch transaction.
<br>
These are read/write registers. Ignore reads from reserved bits. Write 0x0
to reserved bits. (Instance 11 of 16)*/
//====================================================================

#define  PDMA_DMA_DADR10_DESCRIPTOR_ADDRESS_MASK 0xfffffff0
#define  PDMA_DMA_DADR10_DESCRIPTOR_ADDRESS_SHIFT 4
#define  PDMA_DMA_DADR10_DESCRIPTOR_ADDRESS_MASK_SHIFT(reg) (((reg) & PDMA_DMA_DADR10_DESCRIPTOR_ADDRESS_MASK) >> PDMA_DMA_DADR10_DESCRIPTOR_ADDRESS_SHIFT)
#define  PDMA_DMA_DADR10_DESCRIPTOR_ADDRESS_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_DADR10_DESCRIPTOR_ADDRESS_MASK) | (((uint32_t)val) << PDMA_DMA_DADR10_DESCRIPTOR_ADDRESS_SHIFT))

#define  PDMA_DMA_DADR10_RESERVED1_MASK 0xc
#define  PDMA_DMA_DADR10_RESERVED1_SHIFT 2
#define  PDMA_DMA_DADR10_RESERVED1_MASK_SHIFT(reg) (((reg) & PDMA_DMA_DADR10_RESERVED1_MASK) >> PDMA_DMA_DADR10_RESERVED1_SHIFT)
#define  PDMA_DMA_DADR10_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_DADR10_RESERVED1_MASK) | (((uint32_t)val) << PDMA_DMA_DADR10_RESERVED1_SHIFT))

#define  PDMA_DMA_DADR10_BREN_MASK 0x2
#define  PDMA_DMA_DADR10_BREN_SHIFT 1
#define  PDMA_DMA_DADR10_BREN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_DADR10_BREN_MASK) >> PDMA_DMA_DADR10_BREN_SHIFT)
#define  PDMA_DMA_DADR10_BREN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_DADR10_BREN_MASK) | (((uint32_t)val) << PDMA_DMA_DADR10_BREN_SHIFT))

#define  PDMA_DMA_DADR10_STOP_MASK 0x1
#define  PDMA_DMA_DADR10_STOP_SHIFT 0
#define  PDMA_DMA_DADR10_STOP_MASK_SHIFT(reg) (((reg) & PDMA_DMA_DADR10_STOP_MASK) >> PDMA_DMA_DADR10_STOP_SHIFT)
#define  PDMA_DMA_DADR10_STOP_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_DADR10_STOP_MASK) | (((uint32_t)val) << PDMA_DMA_DADR10_STOP_SHIFT))

//====================================================================
//Register: DMA Descriptor Address Registers 0-15 (Instance 12 of 16) (DMA_DADR11)
/** \brief These registers contain the memory address of the next descriptor for
a channel. The fields in this register, except <Stop>, are undefined on
power up. <Stop> is cleared on power up. The address must be aligned to
a 128-bit (4-word) boundary. This register must not contain the address of
any other internal peripheral register or DMA register as this causes a bus
error.
<br>
This register is reserved if the channel is performing
a no-descriptor-fetch transaction.
<br>
These are read/write registers. Ignore reads from reserved bits. Write 0x0
to reserved bits. (Instance 12 of 16)*/
//====================================================================

#define  PDMA_DMA_DADR11_DESCRIPTOR_ADDRESS_MASK 0xfffffff0
#define  PDMA_DMA_DADR11_DESCRIPTOR_ADDRESS_SHIFT 4
#define  PDMA_DMA_DADR11_DESCRIPTOR_ADDRESS_MASK_SHIFT(reg) (((reg) & PDMA_DMA_DADR11_DESCRIPTOR_ADDRESS_MASK) >> PDMA_DMA_DADR11_DESCRIPTOR_ADDRESS_SHIFT)
#define  PDMA_DMA_DADR11_DESCRIPTOR_ADDRESS_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_DADR11_DESCRIPTOR_ADDRESS_MASK) | (((uint32_t)val) << PDMA_DMA_DADR11_DESCRIPTOR_ADDRESS_SHIFT))

#define  PDMA_DMA_DADR11_RESERVED1_MASK 0xc
#define  PDMA_DMA_DADR11_RESERVED1_SHIFT 2
#define  PDMA_DMA_DADR11_RESERVED1_MASK_SHIFT(reg) (((reg) & PDMA_DMA_DADR11_RESERVED1_MASK) >> PDMA_DMA_DADR11_RESERVED1_SHIFT)
#define  PDMA_DMA_DADR11_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_DADR11_RESERVED1_MASK) | (((uint32_t)val) << PDMA_DMA_DADR11_RESERVED1_SHIFT))

#define  PDMA_DMA_DADR11_BREN_MASK 0x2
#define  PDMA_DMA_DADR11_BREN_SHIFT 1
#define  PDMA_DMA_DADR11_BREN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_DADR11_BREN_MASK) >> PDMA_DMA_DADR11_BREN_SHIFT)
#define  PDMA_DMA_DADR11_BREN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_DADR11_BREN_MASK) | (((uint32_t)val) << PDMA_DMA_DADR11_BREN_SHIFT))

#define  PDMA_DMA_DADR11_STOP_MASK 0x1
#define  PDMA_DMA_DADR11_STOP_SHIFT 0
#define  PDMA_DMA_DADR11_STOP_MASK_SHIFT(reg) (((reg) & PDMA_DMA_DADR11_STOP_MASK) >> PDMA_DMA_DADR11_STOP_SHIFT)
#define  PDMA_DMA_DADR11_STOP_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_DADR11_STOP_MASK) | (((uint32_t)val) << PDMA_DMA_DADR11_STOP_SHIFT))

//====================================================================
//Register: DMA Descriptor Address Registers 0-15 (Instance 13 of 16) (DMA_DADR12)
/** \brief These registers contain the memory address of the next descriptor for
a channel. The fields in this register, except <Stop>, are undefined on
power up. <Stop> is cleared on power up. The address must be aligned to
a 128-bit (4-word) boundary. This register must not contain the address of
any other internal peripheral register or DMA register as this causes a bus
error.
<br>
This register is reserved if the channel is performing
a no-descriptor-fetch transaction.
<br>
These are read/write registers. Ignore reads from reserved bits. Write 0x0
to reserved bits. (Instance 13 of 16)*/
//====================================================================

#define  PDMA_DMA_DADR12_DESCRIPTOR_ADDRESS_MASK 0xfffffff0
#define  PDMA_DMA_DADR12_DESCRIPTOR_ADDRESS_SHIFT 4
#define  PDMA_DMA_DADR12_DESCRIPTOR_ADDRESS_MASK_SHIFT(reg) (((reg) & PDMA_DMA_DADR12_DESCRIPTOR_ADDRESS_MASK) >> PDMA_DMA_DADR12_DESCRIPTOR_ADDRESS_SHIFT)
#define  PDMA_DMA_DADR12_DESCRIPTOR_ADDRESS_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_DADR12_DESCRIPTOR_ADDRESS_MASK) | (((uint32_t)val) << PDMA_DMA_DADR12_DESCRIPTOR_ADDRESS_SHIFT))

#define  PDMA_DMA_DADR12_RESERVED1_MASK 0xc
#define  PDMA_DMA_DADR12_RESERVED1_SHIFT 2
#define  PDMA_DMA_DADR12_RESERVED1_MASK_SHIFT(reg) (((reg) & PDMA_DMA_DADR12_RESERVED1_MASK) >> PDMA_DMA_DADR12_RESERVED1_SHIFT)
#define  PDMA_DMA_DADR12_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_DADR12_RESERVED1_MASK) | (((uint32_t)val) << PDMA_DMA_DADR12_RESERVED1_SHIFT))

#define  PDMA_DMA_DADR12_BREN_MASK 0x2
#define  PDMA_DMA_DADR12_BREN_SHIFT 1
#define  PDMA_DMA_DADR12_BREN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_DADR12_BREN_MASK) >> PDMA_DMA_DADR12_BREN_SHIFT)
#define  PDMA_DMA_DADR12_BREN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_DADR12_BREN_MASK) | (((uint32_t)val) << PDMA_DMA_DADR12_BREN_SHIFT))

#define  PDMA_DMA_DADR12_STOP_MASK 0x1
#define  PDMA_DMA_DADR12_STOP_SHIFT 0
#define  PDMA_DMA_DADR12_STOP_MASK_SHIFT(reg) (((reg) & PDMA_DMA_DADR12_STOP_MASK) >> PDMA_DMA_DADR12_STOP_SHIFT)
#define  PDMA_DMA_DADR12_STOP_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_DADR12_STOP_MASK) | (((uint32_t)val) << PDMA_DMA_DADR12_STOP_SHIFT))

//====================================================================
//Register: DMA Descriptor Address Registers 0-15 (Instance 14 of 16) (DMA_DADR13)
/** \brief These registers contain the memory address of the next descriptor for
a channel. The fields in this register, except <Stop>, are undefined on
power up. <Stop> is cleared on power up. The address must be aligned to
a 128-bit (4-word) boundary. This register must not contain the address of
any other internal peripheral register or DMA register as this causes a bus
error.
<br>
This register is reserved if the channel is performing
a no-descriptor-fetch transaction.
<br>
These are read/write registers. Ignore reads from reserved bits. Write 0x0
to reserved bits. (Instance 14 of 16)*/
//====================================================================

#define  PDMA_DMA_DADR13_DESCRIPTOR_ADDRESS_MASK 0xfffffff0
#define  PDMA_DMA_DADR13_DESCRIPTOR_ADDRESS_SHIFT 4
#define  PDMA_DMA_DADR13_DESCRIPTOR_ADDRESS_MASK_SHIFT(reg) (((reg) & PDMA_DMA_DADR13_DESCRIPTOR_ADDRESS_MASK) >> PDMA_DMA_DADR13_DESCRIPTOR_ADDRESS_SHIFT)
#define  PDMA_DMA_DADR13_DESCRIPTOR_ADDRESS_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_DADR13_DESCRIPTOR_ADDRESS_MASK) | (((uint32_t)val) << PDMA_DMA_DADR13_DESCRIPTOR_ADDRESS_SHIFT))

#define  PDMA_DMA_DADR13_RESERVED1_MASK 0xc
#define  PDMA_DMA_DADR13_RESERVED1_SHIFT 2
#define  PDMA_DMA_DADR13_RESERVED1_MASK_SHIFT(reg) (((reg) & PDMA_DMA_DADR13_RESERVED1_MASK) >> PDMA_DMA_DADR13_RESERVED1_SHIFT)
#define  PDMA_DMA_DADR13_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_DADR13_RESERVED1_MASK) | (((uint32_t)val) << PDMA_DMA_DADR13_RESERVED1_SHIFT))

#define  PDMA_DMA_DADR13_BREN_MASK 0x2
#define  PDMA_DMA_DADR13_BREN_SHIFT 1
#define  PDMA_DMA_DADR13_BREN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_DADR13_BREN_MASK) >> PDMA_DMA_DADR13_BREN_SHIFT)
#define  PDMA_DMA_DADR13_BREN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_DADR13_BREN_MASK) | (((uint32_t)val) << PDMA_DMA_DADR13_BREN_SHIFT))

#define  PDMA_DMA_DADR13_STOP_MASK 0x1
#define  PDMA_DMA_DADR13_STOP_SHIFT 0
#define  PDMA_DMA_DADR13_STOP_MASK_SHIFT(reg) (((reg) & PDMA_DMA_DADR13_STOP_MASK) >> PDMA_DMA_DADR13_STOP_SHIFT)
#define  PDMA_DMA_DADR13_STOP_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_DADR13_STOP_MASK) | (((uint32_t)val) << PDMA_DMA_DADR13_STOP_SHIFT))

//====================================================================
//Register: DMA Descriptor Address Registers 0-15 (Instance 15 of 16) (DMA_DADR14)
/** \brief These registers contain the memory address of the next descriptor for
a channel. The fields in this register, except <Stop>, are undefined on
power up. <Stop> is cleared on power up. The address must be aligned to
a 128-bit (4-word) boundary. This register must not contain the address of
any other internal peripheral register or DMA register as this causes a bus
error.
<br>
This register is reserved if the channel is performing
a no-descriptor-fetch transaction.
<br>
These are read/write registers. Ignore reads from reserved bits. Write 0x0
to reserved bits. (Instance 15 of 16)*/
//====================================================================

#define  PDMA_DMA_DADR14_DESCRIPTOR_ADDRESS_MASK 0xfffffff0
#define  PDMA_DMA_DADR14_DESCRIPTOR_ADDRESS_SHIFT 4
#define  PDMA_DMA_DADR14_DESCRIPTOR_ADDRESS_MASK_SHIFT(reg) (((reg) & PDMA_DMA_DADR14_DESCRIPTOR_ADDRESS_MASK) >> PDMA_DMA_DADR14_DESCRIPTOR_ADDRESS_SHIFT)
#define  PDMA_DMA_DADR14_DESCRIPTOR_ADDRESS_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_DADR14_DESCRIPTOR_ADDRESS_MASK) | (((uint32_t)val) << PDMA_DMA_DADR14_DESCRIPTOR_ADDRESS_SHIFT))

#define  PDMA_DMA_DADR14_RESERVED1_MASK 0xc
#define  PDMA_DMA_DADR14_RESERVED1_SHIFT 2
#define  PDMA_DMA_DADR14_RESERVED1_MASK_SHIFT(reg) (((reg) & PDMA_DMA_DADR14_RESERVED1_MASK) >> PDMA_DMA_DADR14_RESERVED1_SHIFT)
#define  PDMA_DMA_DADR14_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_DADR14_RESERVED1_MASK) | (((uint32_t)val) << PDMA_DMA_DADR14_RESERVED1_SHIFT))

#define  PDMA_DMA_DADR14_BREN_MASK 0x2
#define  PDMA_DMA_DADR14_BREN_SHIFT 1
#define  PDMA_DMA_DADR14_BREN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_DADR14_BREN_MASK) >> PDMA_DMA_DADR14_BREN_SHIFT)
#define  PDMA_DMA_DADR14_BREN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_DADR14_BREN_MASK) | (((uint32_t)val) << PDMA_DMA_DADR14_BREN_SHIFT))

#define  PDMA_DMA_DADR14_STOP_MASK 0x1
#define  PDMA_DMA_DADR14_STOP_SHIFT 0
#define  PDMA_DMA_DADR14_STOP_MASK_SHIFT(reg) (((reg) & PDMA_DMA_DADR14_STOP_MASK) >> PDMA_DMA_DADR14_STOP_SHIFT)
#define  PDMA_DMA_DADR14_STOP_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_DADR14_STOP_MASK) | (((uint32_t)val) << PDMA_DMA_DADR14_STOP_SHIFT))

//====================================================================
//Register: DMA Descriptor Address Registers 0-15 (Instance 16 of 16) (DMA_DADR15)
/** \brief These registers contain the memory address of the next descriptor for
a channel. The fields in this register, except <Stop>, are undefined on
power up. <Stop> is cleared on power up. The address must be aligned to
a 128-bit (4-word) boundary. This register must not contain the address of
any other internal peripheral register or DMA register as this causes a bus
error.
<br>
This register is reserved if the channel is performing
a no-descriptor-fetch transaction.
<br>
These are read/write registers. Ignore reads from reserved bits. Write 0x0
to reserved bits. (Instance 16 of 16)*/
//====================================================================

#define  PDMA_DMA_DADR15_DESCRIPTOR_ADDRESS_MASK 0xfffffff0
#define  PDMA_DMA_DADR15_DESCRIPTOR_ADDRESS_SHIFT 4
#define  PDMA_DMA_DADR15_DESCRIPTOR_ADDRESS_MASK_SHIFT(reg) (((reg) & PDMA_DMA_DADR15_DESCRIPTOR_ADDRESS_MASK) >> PDMA_DMA_DADR15_DESCRIPTOR_ADDRESS_SHIFT)
#define  PDMA_DMA_DADR15_DESCRIPTOR_ADDRESS_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_DADR15_DESCRIPTOR_ADDRESS_MASK) | (((uint32_t)val) << PDMA_DMA_DADR15_DESCRIPTOR_ADDRESS_SHIFT))

#define  PDMA_DMA_DADR15_RESERVED1_MASK 0xc
#define  PDMA_DMA_DADR15_RESERVED1_SHIFT 2
#define  PDMA_DMA_DADR15_RESERVED1_MASK_SHIFT(reg) (((reg) & PDMA_DMA_DADR15_RESERVED1_MASK) >> PDMA_DMA_DADR15_RESERVED1_SHIFT)
#define  PDMA_DMA_DADR15_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_DADR15_RESERVED1_MASK) | (((uint32_t)val) << PDMA_DMA_DADR15_RESERVED1_SHIFT))

#define  PDMA_DMA_DADR15_BREN_MASK 0x2
#define  PDMA_DMA_DADR15_BREN_SHIFT 1
#define  PDMA_DMA_DADR15_BREN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_DADR15_BREN_MASK) >> PDMA_DMA_DADR15_BREN_SHIFT)
#define  PDMA_DMA_DADR15_BREN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_DADR15_BREN_MASK) | (((uint32_t)val) << PDMA_DMA_DADR15_BREN_SHIFT))

#define  PDMA_DMA_DADR15_STOP_MASK 0x1
#define  PDMA_DMA_DADR15_STOP_SHIFT 0
#define  PDMA_DMA_DADR15_STOP_MASK_SHIFT(reg) (((reg) & PDMA_DMA_DADR15_STOP_MASK) >> PDMA_DMA_DADR15_STOP_SHIFT)
#define  PDMA_DMA_DADR15_STOP_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_DADR15_STOP_MASK) | (((uint32_t)val) << PDMA_DMA_DADR15_STOP_SHIFT))

//====================================================================
//Register: DMA Source Address Registers 0-15 (Instance 1 of 16) (DMA_SADR0)
/** \brief These registers are read-only for descriptor-fetch transactions and
read/write for no-descriptor-fetch transactions.
<br>
These registers contain the source address of the current descriptor for
a channel. The source address is the address of the on-chip peripheral,
external peripheral, companion chip, or the address of a memory location.
These registers cannot contain addresses of any other internal DMA
registers as they will cause a bus error.
<br>
If (1) the source address is the address of a memory location, and if (2)
the Alignment register is properly configured, the address can be aligned
to a byte boundary (see DMA Alignment Register). Improper configuration of
the Alignment register defaults the source address to an 8-byte boundary.
<br>
Other restrictions on byte boundary alignment can apply for special DMA
operations (see Misaligned Memory Accesses Section in the PXA2128
Datasheet).
<br>
These are read/write registers. Ignore reads from reserved bits. Write 0x0
to reserved bits. (Instance 1 of 16)*/
//====================================================================

#define  PDMA_DMA_SADR0_SRCADDR_MASK 0xfffffff8
#define  PDMA_DMA_SADR0_SRCADDR_SHIFT 3
#define  PDMA_DMA_SADR0_SRCADDR_MASK_SHIFT(reg) (((reg) & PDMA_DMA_SADR0_SRCADDR_MASK) >> PDMA_DMA_SADR0_SRCADDR_SHIFT)
#define  PDMA_DMA_SADR0_SRCADDR_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_SADR0_SRCADDR_MASK) | (((uint32_t)val) << PDMA_DMA_SADR0_SRCADDR_SHIFT))

#define  PDMA_DMA_SADR0_SRCADDR2_MASK 0x4
#define  PDMA_DMA_SADR0_SRCADDR2_SHIFT 2
#define  PDMA_DMA_SADR0_SRCADDR2_MASK_SHIFT(reg) (((reg) & PDMA_DMA_SADR0_SRCADDR2_MASK) >> PDMA_DMA_SADR0_SRCADDR2_SHIFT)
#define  PDMA_DMA_SADR0_SRCADDR2_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_SADR0_SRCADDR2_MASK) | (((uint32_t)val) << PDMA_DMA_SADR0_SRCADDR2_SHIFT))

#define  PDMA_DMA_SADR0_SRCADDR0_MASK 0x3
#define  PDMA_DMA_SADR0_SRCADDR0_SHIFT 0
#define  PDMA_DMA_SADR0_SRCADDR0_MASK_SHIFT(reg) (((reg) & PDMA_DMA_SADR0_SRCADDR0_MASK) >> PDMA_DMA_SADR0_SRCADDR0_SHIFT)
#define  PDMA_DMA_SADR0_SRCADDR0_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_SADR0_SRCADDR0_MASK) | (((uint32_t)val) << PDMA_DMA_SADR0_SRCADDR0_SHIFT))

//====================================================================
//Register: DMA Source Address Registers 0-15 (Instance 2 of 16) (DMA_SADR1)
/** \brief These registers are read-only for descriptor-fetch transactions and
read/write for no-descriptor-fetch transactions.
<br>
These registers contain the source address of the current descriptor for
a channel. The source address is the address of the on-chip peripheral,
external peripheral, companion chip, or the address of a memory location.
These registers cannot contain addresses of any other internal DMA
registers as they will cause a bus error.
<br>
If (1) the source address is the address of a memory location, and if (2)
the Alignment register is properly configured, the address can be aligned
to a byte boundary (see DMA Alignment Register). Improper configuration of
the Alignment register defaults the source address to an 8-byte boundary.
<br>
Other restrictions on byte boundary alignment can apply for special DMA
operations (see Misaligned Memory Accesses Section in the PXA2128
Datasheet).
<br>
These are read/write registers. Ignore reads from reserved bits. Write 0x0
to reserved bits. (Instance 2 of 16)*/
//====================================================================

#define  PDMA_DMA_SADR1_SRCADDR_MASK 0xfffffff8
#define  PDMA_DMA_SADR1_SRCADDR_SHIFT 3
#define  PDMA_DMA_SADR1_SRCADDR_MASK_SHIFT(reg) (((reg) & PDMA_DMA_SADR1_SRCADDR_MASK) >> PDMA_DMA_SADR1_SRCADDR_SHIFT)
#define  PDMA_DMA_SADR1_SRCADDR_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_SADR1_SRCADDR_MASK) | (((uint32_t)val) << PDMA_DMA_SADR1_SRCADDR_SHIFT))

#define  PDMA_DMA_SADR1_SRCADDR2_MASK 0x4
#define  PDMA_DMA_SADR1_SRCADDR2_SHIFT 2
#define  PDMA_DMA_SADR1_SRCADDR2_MASK_SHIFT(reg) (((reg) & PDMA_DMA_SADR1_SRCADDR2_MASK) >> PDMA_DMA_SADR1_SRCADDR2_SHIFT)
#define  PDMA_DMA_SADR1_SRCADDR2_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_SADR1_SRCADDR2_MASK) | (((uint32_t)val) << PDMA_DMA_SADR1_SRCADDR2_SHIFT))

#define  PDMA_DMA_SADR1_SRCADDR0_MASK 0x3
#define  PDMA_DMA_SADR1_SRCADDR0_SHIFT 0
#define  PDMA_DMA_SADR1_SRCADDR0_MASK_SHIFT(reg) (((reg) & PDMA_DMA_SADR1_SRCADDR0_MASK) >> PDMA_DMA_SADR1_SRCADDR0_SHIFT)
#define  PDMA_DMA_SADR1_SRCADDR0_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_SADR1_SRCADDR0_MASK) | (((uint32_t)val) << PDMA_DMA_SADR1_SRCADDR0_SHIFT))

//====================================================================
//Register: DMA Source Address Registers 0-15 (Instance 3 of 16) (DMA_SADR2)
/** \brief These registers are read-only for descriptor-fetch transactions and
read/write for no-descriptor-fetch transactions.
<br>
These registers contain the source address of the current descriptor for
a channel. The source address is the address of the on-chip peripheral,
external peripheral, companion chip, or the address of a memory location.
These registers cannot contain addresses of any other internal DMA
registers as they will cause a bus error.
<br>
If (1) the source address is the address of a memory location, and if (2)
the Alignment register is properly configured, the address can be aligned
to a byte boundary (see DMA Alignment Register). Improper configuration of
the Alignment register defaults the source address to an 8-byte boundary.
<br>
Other restrictions on byte boundary alignment can apply for special DMA
operations (see Misaligned Memory Accesses Section in the PXA2128
Datasheet).
<br>
These are read/write registers. Ignore reads from reserved bits. Write 0x0
to reserved bits. (Instance 3 of 16)*/
//====================================================================

#define  PDMA_DMA_SADR2_SRCADDR_MASK 0xfffffff8
#define  PDMA_DMA_SADR2_SRCADDR_SHIFT 3
#define  PDMA_DMA_SADR2_SRCADDR_MASK_SHIFT(reg) (((reg) & PDMA_DMA_SADR2_SRCADDR_MASK) >> PDMA_DMA_SADR2_SRCADDR_SHIFT)
#define  PDMA_DMA_SADR2_SRCADDR_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_SADR2_SRCADDR_MASK) | (((uint32_t)val) << PDMA_DMA_SADR2_SRCADDR_SHIFT))

#define  PDMA_DMA_SADR2_SRCADDR2_MASK 0x4
#define  PDMA_DMA_SADR2_SRCADDR2_SHIFT 2
#define  PDMA_DMA_SADR2_SRCADDR2_MASK_SHIFT(reg) (((reg) & PDMA_DMA_SADR2_SRCADDR2_MASK) >> PDMA_DMA_SADR2_SRCADDR2_SHIFT)
#define  PDMA_DMA_SADR2_SRCADDR2_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_SADR2_SRCADDR2_MASK) | (((uint32_t)val) << PDMA_DMA_SADR2_SRCADDR2_SHIFT))

#define  PDMA_DMA_SADR2_SRCADDR0_MASK 0x3
#define  PDMA_DMA_SADR2_SRCADDR0_SHIFT 0
#define  PDMA_DMA_SADR2_SRCADDR0_MASK_SHIFT(reg) (((reg) & PDMA_DMA_SADR2_SRCADDR0_MASK) >> PDMA_DMA_SADR2_SRCADDR0_SHIFT)
#define  PDMA_DMA_SADR2_SRCADDR0_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_SADR2_SRCADDR0_MASK) | (((uint32_t)val) << PDMA_DMA_SADR2_SRCADDR0_SHIFT))

//====================================================================
//Register: DMA Source Address Registers 0-15 (Instance 4 of 16) (DMA_SADR3)
/** \brief These registers are read-only for descriptor-fetch transactions and
read/write for no-descriptor-fetch transactions.
<br>
These registers contain the source address of the current descriptor for
a channel. The source address is the address of the on-chip peripheral,
external peripheral, companion chip, or the address of a memory location.
These registers cannot contain addresses of any other internal DMA
registers as they will cause a bus error.
<br>
If (1) the source address is the address of a memory location, and if (2)
the Alignment register is properly configured, the address can be aligned
to a byte boundary (see DMA Alignment Register). Improper configuration of
the Alignment register defaults the source address to an 8-byte boundary.
<br>
Other restrictions on byte boundary alignment can apply for special DMA
operations (see Misaligned Memory Accesses Section in the PXA2128
Datasheet).
<br>
These are read/write registers. Ignore reads from reserved bits. Write 0x0
to reserved bits. (Instance 4 of 16)*/
//====================================================================

#define  PDMA_DMA_SADR3_SRCADDR_MASK 0xfffffff8
#define  PDMA_DMA_SADR3_SRCADDR_SHIFT 3
#define  PDMA_DMA_SADR3_SRCADDR_MASK_SHIFT(reg) (((reg) & PDMA_DMA_SADR3_SRCADDR_MASK) >> PDMA_DMA_SADR3_SRCADDR_SHIFT)
#define  PDMA_DMA_SADR3_SRCADDR_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_SADR3_SRCADDR_MASK) | (((uint32_t)val) << PDMA_DMA_SADR3_SRCADDR_SHIFT))

#define  PDMA_DMA_SADR3_SRCADDR2_MASK 0x4
#define  PDMA_DMA_SADR3_SRCADDR2_SHIFT 2
#define  PDMA_DMA_SADR3_SRCADDR2_MASK_SHIFT(reg) (((reg) & PDMA_DMA_SADR3_SRCADDR2_MASK) >> PDMA_DMA_SADR3_SRCADDR2_SHIFT)
#define  PDMA_DMA_SADR3_SRCADDR2_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_SADR3_SRCADDR2_MASK) | (((uint32_t)val) << PDMA_DMA_SADR3_SRCADDR2_SHIFT))

#define  PDMA_DMA_SADR3_SRCADDR0_MASK 0x3
#define  PDMA_DMA_SADR3_SRCADDR0_SHIFT 0
#define  PDMA_DMA_SADR3_SRCADDR0_MASK_SHIFT(reg) (((reg) & PDMA_DMA_SADR3_SRCADDR0_MASK) >> PDMA_DMA_SADR3_SRCADDR0_SHIFT)
#define  PDMA_DMA_SADR3_SRCADDR0_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_SADR3_SRCADDR0_MASK) | (((uint32_t)val) << PDMA_DMA_SADR3_SRCADDR0_SHIFT))

//====================================================================
//Register: DMA Source Address Registers 0-15 (Instance 5 of 16) (DMA_SADR4)
/** \brief These registers are read-only for descriptor-fetch transactions and
read/write for no-descriptor-fetch transactions.
<br>
These registers contain the source address of the current descriptor for
a channel. The source address is the address of the on-chip peripheral,
external peripheral, companion chip, or the address of a memory location.
These registers cannot contain addresses of any other internal DMA
registers as they will cause a bus error.
<br>
If (1) the source address is the address of a memory location, and if (2)
the Alignment register is properly configured, the address can be aligned
to a byte boundary (see DMA Alignment Register). Improper configuration of
the Alignment register defaults the source address to an 8-byte boundary.
<br>
Other restrictions on byte boundary alignment can apply for special DMA
operations (see Misaligned Memory Accesses Section in the PXA2128
Datasheet).
<br>
These are read/write registers. Ignore reads from reserved bits. Write 0x0
to reserved bits. (Instance 5 of 16)*/
//====================================================================

#define  PDMA_DMA_SADR4_SRCADDR_MASK 0xfffffff8
#define  PDMA_DMA_SADR4_SRCADDR_SHIFT 3
#define  PDMA_DMA_SADR4_SRCADDR_MASK_SHIFT(reg) (((reg) & PDMA_DMA_SADR4_SRCADDR_MASK) >> PDMA_DMA_SADR4_SRCADDR_SHIFT)
#define  PDMA_DMA_SADR4_SRCADDR_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_SADR4_SRCADDR_MASK) | (((uint32_t)val) << PDMA_DMA_SADR4_SRCADDR_SHIFT))

#define  PDMA_DMA_SADR4_SRCADDR2_MASK 0x4
#define  PDMA_DMA_SADR4_SRCADDR2_SHIFT 2
#define  PDMA_DMA_SADR4_SRCADDR2_MASK_SHIFT(reg) (((reg) & PDMA_DMA_SADR4_SRCADDR2_MASK) >> PDMA_DMA_SADR4_SRCADDR2_SHIFT)
#define  PDMA_DMA_SADR4_SRCADDR2_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_SADR4_SRCADDR2_MASK) | (((uint32_t)val) << PDMA_DMA_SADR4_SRCADDR2_SHIFT))

#define  PDMA_DMA_SADR4_SRCADDR0_MASK 0x3
#define  PDMA_DMA_SADR4_SRCADDR0_SHIFT 0
#define  PDMA_DMA_SADR4_SRCADDR0_MASK_SHIFT(reg) (((reg) & PDMA_DMA_SADR4_SRCADDR0_MASK) >> PDMA_DMA_SADR4_SRCADDR0_SHIFT)
#define  PDMA_DMA_SADR4_SRCADDR0_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_SADR4_SRCADDR0_MASK) | (((uint32_t)val) << PDMA_DMA_SADR4_SRCADDR0_SHIFT))

//====================================================================
//Register: DMA Source Address Registers 0-15 (Instance 6 of 16) (DMA_SADR5)
/** \brief These registers are read-only for descriptor-fetch transactions and
read/write for no-descriptor-fetch transactions.
<br>
These registers contain the source address of the current descriptor for
a channel. The source address is the address of the on-chip peripheral,
external peripheral, companion chip, or the address of a memory location.
These registers cannot contain addresses of any other internal DMA
registers as they will cause a bus error.
<br>
If (1) the source address is the address of a memory location, and if (2)
the Alignment register is properly configured, the address can be aligned
to a byte boundary (see DMA Alignment Register). Improper configuration of
the Alignment register defaults the source address to an 8-byte boundary.
<br>
Other restrictions on byte boundary alignment can apply for special DMA
operations (see Misaligned Memory Accesses Section in the PXA2128
Datasheet).
<br>
These are read/write registers. Ignore reads from reserved bits. Write 0x0
to reserved bits. (Instance 6 of 16)*/
//====================================================================

#define  PDMA_DMA_SADR5_SRCADDR_MASK 0xfffffff8
#define  PDMA_DMA_SADR5_SRCADDR_SHIFT 3
#define  PDMA_DMA_SADR5_SRCADDR_MASK_SHIFT(reg) (((reg) & PDMA_DMA_SADR5_SRCADDR_MASK) >> PDMA_DMA_SADR5_SRCADDR_SHIFT)
#define  PDMA_DMA_SADR5_SRCADDR_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_SADR5_SRCADDR_MASK) | (((uint32_t)val) << PDMA_DMA_SADR5_SRCADDR_SHIFT))

#define  PDMA_DMA_SADR5_SRCADDR2_MASK 0x4
#define  PDMA_DMA_SADR5_SRCADDR2_SHIFT 2
#define  PDMA_DMA_SADR5_SRCADDR2_MASK_SHIFT(reg) (((reg) & PDMA_DMA_SADR5_SRCADDR2_MASK) >> PDMA_DMA_SADR5_SRCADDR2_SHIFT)
#define  PDMA_DMA_SADR5_SRCADDR2_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_SADR5_SRCADDR2_MASK) | (((uint32_t)val) << PDMA_DMA_SADR5_SRCADDR2_SHIFT))

#define  PDMA_DMA_SADR5_SRCADDR0_MASK 0x3
#define  PDMA_DMA_SADR5_SRCADDR0_SHIFT 0
#define  PDMA_DMA_SADR5_SRCADDR0_MASK_SHIFT(reg) (((reg) & PDMA_DMA_SADR5_SRCADDR0_MASK) >> PDMA_DMA_SADR5_SRCADDR0_SHIFT)
#define  PDMA_DMA_SADR5_SRCADDR0_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_SADR5_SRCADDR0_MASK) | (((uint32_t)val) << PDMA_DMA_SADR5_SRCADDR0_SHIFT))

//====================================================================
//Register: DMA Source Address Registers 0-15 (Instance 7 of 16) (DMA_SADR6)
/** \brief These registers are read-only for descriptor-fetch transactions and
read/write for no-descriptor-fetch transactions.
<br>
These registers contain the source address of the current descriptor for
a channel. The source address is the address of the on-chip peripheral,
external peripheral, companion chip, or the address of a memory location.
These registers cannot contain addresses of any other internal DMA
registers as they will cause a bus error.
<br>
If (1) the source address is the address of a memory location, and if (2)
the Alignment register is properly configured, the address can be aligned
to a byte boundary (see DMA Alignment Register). Improper configuration of
the Alignment register defaults the source address to an 8-byte boundary.
<br>
Other restrictions on byte boundary alignment can apply for special DMA
operations (see Misaligned Memory Accesses Section in the PXA2128
Datasheet).
<br>
These are read/write registers. Ignore reads from reserved bits. Write 0x0
to reserved bits. (Instance 7 of 16)*/
//====================================================================

#define  PDMA_DMA_SADR6_SRCADDR_MASK 0xfffffff8
#define  PDMA_DMA_SADR6_SRCADDR_SHIFT 3
#define  PDMA_DMA_SADR6_SRCADDR_MASK_SHIFT(reg) (((reg) & PDMA_DMA_SADR6_SRCADDR_MASK) >> PDMA_DMA_SADR6_SRCADDR_SHIFT)
#define  PDMA_DMA_SADR6_SRCADDR_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_SADR6_SRCADDR_MASK) | (((uint32_t)val) << PDMA_DMA_SADR6_SRCADDR_SHIFT))

#define  PDMA_DMA_SADR6_SRCADDR2_MASK 0x4
#define  PDMA_DMA_SADR6_SRCADDR2_SHIFT 2
#define  PDMA_DMA_SADR6_SRCADDR2_MASK_SHIFT(reg) (((reg) & PDMA_DMA_SADR6_SRCADDR2_MASK) >> PDMA_DMA_SADR6_SRCADDR2_SHIFT)
#define  PDMA_DMA_SADR6_SRCADDR2_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_SADR6_SRCADDR2_MASK) | (((uint32_t)val) << PDMA_DMA_SADR6_SRCADDR2_SHIFT))

#define  PDMA_DMA_SADR6_SRCADDR0_MASK 0x3
#define  PDMA_DMA_SADR6_SRCADDR0_SHIFT 0
#define  PDMA_DMA_SADR6_SRCADDR0_MASK_SHIFT(reg) (((reg) & PDMA_DMA_SADR6_SRCADDR0_MASK) >> PDMA_DMA_SADR6_SRCADDR0_SHIFT)
#define  PDMA_DMA_SADR6_SRCADDR0_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_SADR6_SRCADDR0_MASK) | (((uint32_t)val) << PDMA_DMA_SADR6_SRCADDR0_SHIFT))

//====================================================================
//Register: DMA Source Address Registers 0-15 (Instance 8 of 16) (DMA_SADR7)
/** \brief These registers are read-only for descriptor-fetch transactions and
read/write for no-descriptor-fetch transactions.
<br>
These registers contain the source address of the current descriptor for
a channel. The source address is the address of the on-chip peripheral,
external peripheral, companion chip, or the address of a memory location.
These registers cannot contain addresses of any other internal DMA
registers as they will cause a bus error.
<br>
If (1) the source address is the address of a memory location, and if (2)
the Alignment register is properly configured, the address can be aligned
to a byte boundary (see DMA Alignment Register). Improper configuration of
the Alignment register defaults the source address to an 8-byte boundary.
<br>
Other restrictions on byte boundary alignment can apply for special DMA
operations (see Misaligned Memory Accesses Section in the PXA2128
Datasheet).
<br>
These are read/write registers. Ignore reads from reserved bits. Write 0x0
to reserved bits. (Instance 8 of 16)*/
//====================================================================

#define  PDMA_DMA_SADR7_SRCADDR_MASK 0xfffffff8
#define  PDMA_DMA_SADR7_SRCADDR_SHIFT 3
#define  PDMA_DMA_SADR7_SRCADDR_MASK_SHIFT(reg) (((reg) & PDMA_DMA_SADR7_SRCADDR_MASK) >> PDMA_DMA_SADR7_SRCADDR_SHIFT)
#define  PDMA_DMA_SADR7_SRCADDR_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_SADR7_SRCADDR_MASK) | (((uint32_t)val) << PDMA_DMA_SADR7_SRCADDR_SHIFT))

#define  PDMA_DMA_SADR7_SRCADDR2_MASK 0x4
#define  PDMA_DMA_SADR7_SRCADDR2_SHIFT 2
#define  PDMA_DMA_SADR7_SRCADDR2_MASK_SHIFT(reg) (((reg) & PDMA_DMA_SADR7_SRCADDR2_MASK) >> PDMA_DMA_SADR7_SRCADDR2_SHIFT)
#define  PDMA_DMA_SADR7_SRCADDR2_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_SADR7_SRCADDR2_MASK) | (((uint32_t)val) << PDMA_DMA_SADR7_SRCADDR2_SHIFT))

#define  PDMA_DMA_SADR7_SRCADDR0_MASK 0x3
#define  PDMA_DMA_SADR7_SRCADDR0_SHIFT 0
#define  PDMA_DMA_SADR7_SRCADDR0_MASK_SHIFT(reg) (((reg) & PDMA_DMA_SADR7_SRCADDR0_MASK) >> PDMA_DMA_SADR7_SRCADDR0_SHIFT)
#define  PDMA_DMA_SADR7_SRCADDR0_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_SADR7_SRCADDR0_MASK) | (((uint32_t)val) << PDMA_DMA_SADR7_SRCADDR0_SHIFT))

//====================================================================
//Register: DMA Source Address Registers 0-15 (Instance 9 of 16) (DMA_SADR8)
/** \brief These registers are read-only for descriptor-fetch transactions and
read/write for no-descriptor-fetch transactions.
<br>
These registers contain the source address of the current descriptor for
a channel. The source address is the address of the on-chip peripheral,
external peripheral, companion chip, or the address of a memory location.
These registers cannot contain addresses of any other internal DMA
registers as they will cause a bus error.
<br>
If (1) the source address is the address of a memory location, and if (2)
the Alignment register is properly configured, the address can be aligned
to a byte boundary (see DMA Alignment Register). Improper configuration of
the Alignment register defaults the source address to an 8-byte boundary.
<br>
Other restrictions on byte boundary alignment can apply for special DMA
operations (see Misaligned Memory Accesses Section in the PXA2128
Datasheet).
<br>
These are read/write registers. Ignore reads from reserved bits. Write 0x0
to reserved bits. (Instance 9 of 16)*/
//====================================================================

#define  PDMA_DMA_SADR8_SRCADDR_MASK 0xfffffff8
#define  PDMA_DMA_SADR8_SRCADDR_SHIFT 3
#define  PDMA_DMA_SADR8_SRCADDR_MASK_SHIFT(reg) (((reg) & PDMA_DMA_SADR8_SRCADDR_MASK) >> PDMA_DMA_SADR8_SRCADDR_SHIFT)
#define  PDMA_DMA_SADR8_SRCADDR_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_SADR8_SRCADDR_MASK) | (((uint32_t)val) << PDMA_DMA_SADR8_SRCADDR_SHIFT))

#define  PDMA_DMA_SADR8_SRCADDR2_MASK 0x4
#define  PDMA_DMA_SADR8_SRCADDR2_SHIFT 2
#define  PDMA_DMA_SADR8_SRCADDR2_MASK_SHIFT(reg) (((reg) & PDMA_DMA_SADR8_SRCADDR2_MASK) >> PDMA_DMA_SADR8_SRCADDR2_SHIFT)
#define  PDMA_DMA_SADR8_SRCADDR2_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_SADR8_SRCADDR2_MASK) | (((uint32_t)val) << PDMA_DMA_SADR8_SRCADDR2_SHIFT))

#define  PDMA_DMA_SADR8_SRCADDR0_MASK 0x3
#define  PDMA_DMA_SADR8_SRCADDR0_SHIFT 0
#define  PDMA_DMA_SADR8_SRCADDR0_MASK_SHIFT(reg) (((reg) & PDMA_DMA_SADR8_SRCADDR0_MASK) >> PDMA_DMA_SADR8_SRCADDR0_SHIFT)
#define  PDMA_DMA_SADR8_SRCADDR0_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_SADR8_SRCADDR0_MASK) | (((uint32_t)val) << PDMA_DMA_SADR8_SRCADDR0_SHIFT))

//====================================================================
//Register: DMA Source Address Registers 0-15 (Instance 10 of 16) (DMA_SADR9)
/** \brief These registers are read-only for descriptor-fetch transactions and
read/write for no-descriptor-fetch transactions.
<br>
These registers contain the source address of the current descriptor for
a channel. The source address is the address of the on-chip peripheral,
external peripheral, companion chip, or the address of a memory location.
These registers cannot contain addresses of any other internal DMA
registers as they will cause a bus error.
<br>
If (1) the source address is the address of a memory location, and if (2)
the Alignment register is properly configured, the address can be aligned
to a byte boundary (see DMA Alignment Register). Improper configuration of
the Alignment register defaults the source address to an 8-byte boundary.
<br>
Other restrictions on byte boundary alignment can apply for special DMA
operations (see Misaligned Memory Accesses Section in the PXA2128
Datasheet).
<br>
These are read/write registers. Ignore reads from reserved bits. Write 0x0
to reserved bits. (Instance 10 of 16)*/
//====================================================================

#define  PDMA_DMA_SADR9_SRCADDR_MASK 0xfffffff8
#define  PDMA_DMA_SADR9_SRCADDR_SHIFT 3
#define  PDMA_DMA_SADR9_SRCADDR_MASK_SHIFT(reg) (((reg) & PDMA_DMA_SADR9_SRCADDR_MASK) >> PDMA_DMA_SADR9_SRCADDR_SHIFT)
#define  PDMA_DMA_SADR9_SRCADDR_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_SADR9_SRCADDR_MASK) | (((uint32_t)val) << PDMA_DMA_SADR9_SRCADDR_SHIFT))

#define  PDMA_DMA_SADR9_SRCADDR2_MASK 0x4
#define  PDMA_DMA_SADR9_SRCADDR2_SHIFT 2
#define  PDMA_DMA_SADR9_SRCADDR2_MASK_SHIFT(reg) (((reg) & PDMA_DMA_SADR9_SRCADDR2_MASK) >> PDMA_DMA_SADR9_SRCADDR2_SHIFT)
#define  PDMA_DMA_SADR9_SRCADDR2_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_SADR9_SRCADDR2_MASK) | (((uint32_t)val) << PDMA_DMA_SADR9_SRCADDR2_SHIFT))

#define  PDMA_DMA_SADR9_SRCADDR0_MASK 0x3
#define  PDMA_DMA_SADR9_SRCADDR0_SHIFT 0
#define  PDMA_DMA_SADR9_SRCADDR0_MASK_SHIFT(reg) (((reg) & PDMA_DMA_SADR9_SRCADDR0_MASK) >> PDMA_DMA_SADR9_SRCADDR0_SHIFT)
#define  PDMA_DMA_SADR9_SRCADDR0_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_SADR9_SRCADDR0_MASK) | (((uint32_t)val) << PDMA_DMA_SADR9_SRCADDR0_SHIFT))

//====================================================================
//Register: DMA Source Address Registers 0-15 (Instance 11 of 16) (DMA_SADR10)
/** \brief These registers are read-only for descriptor-fetch transactions and
read/write for no-descriptor-fetch transactions.
<br>
These registers contain the source address of the current descriptor for
a channel. The source address is the address of the on-chip peripheral,
external peripheral, companion chip, or the address of a memory location.
These registers cannot contain addresses of any other internal DMA
registers as they will cause a bus error.
<br>
If (1) the source address is the address of a memory location, and if (2)
the Alignment register is properly configured, the address can be aligned
to a byte boundary (see DMA Alignment Register). Improper configuration of
the Alignment register defaults the source address to an 8-byte boundary.
<br>
Other restrictions on byte boundary alignment can apply for special DMA
operations (see Misaligned Memory Accesses Section in the PXA2128
Datasheet).
<br>
These are read/write registers. Ignore reads from reserved bits. Write 0x0
to reserved bits. (Instance 11 of 16)*/
//====================================================================

#define  PDMA_DMA_SADR10_SRCADDR_MASK 0xfffffff8
#define  PDMA_DMA_SADR10_SRCADDR_SHIFT 3
#define  PDMA_DMA_SADR10_SRCADDR_MASK_SHIFT(reg) (((reg) & PDMA_DMA_SADR10_SRCADDR_MASK) >> PDMA_DMA_SADR10_SRCADDR_SHIFT)
#define  PDMA_DMA_SADR10_SRCADDR_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_SADR10_SRCADDR_MASK) | (((uint32_t)val) << PDMA_DMA_SADR10_SRCADDR_SHIFT))

#define  PDMA_DMA_SADR10_SRCADDR2_MASK 0x4
#define  PDMA_DMA_SADR10_SRCADDR2_SHIFT 2
#define  PDMA_DMA_SADR10_SRCADDR2_MASK_SHIFT(reg) (((reg) & PDMA_DMA_SADR10_SRCADDR2_MASK) >> PDMA_DMA_SADR10_SRCADDR2_SHIFT)
#define  PDMA_DMA_SADR10_SRCADDR2_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_SADR10_SRCADDR2_MASK) | (((uint32_t)val) << PDMA_DMA_SADR10_SRCADDR2_SHIFT))

#define  PDMA_DMA_SADR10_SRCADDR0_MASK 0x3
#define  PDMA_DMA_SADR10_SRCADDR0_SHIFT 0
#define  PDMA_DMA_SADR10_SRCADDR0_MASK_SHIFT(reg) (((reg) & PDMA_DMA_SADR10_SRCADDR0_MASK) >> PDMA_DMA_SADR10_SRCADDR0_SHIFT)
#define  PDMA_DMA_SADR10_SRCADDR0_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_SADR10_SRCADDR0_MASK) | (((uint32_t)val) << PDMA_DMA_SADR10_SRCADDR0_SHIFT))

//====================================================================
//Register: DMA Source Address Registers 0-15 (Instance 12 of 16) (DMA_SADR11)
/** \brief These registers are read-only for descriptor-fetch transactions and
read/write for no-descriptor-fetch transactions.
<br>
These registers contain the source address of the current descriptor for
a channel. The source address is the address of the on-chip peripheral,
external peripheral, companion chip, or the address of a memory location.
These registers cannot contain addresses of any other internal DMA
registers as they will cause a bus error.
<br>
If (1) the source address is the address of a memory location, and if (2)
the Alignment register is properly configured, the address can be aligned
to a byte boundary (see DMA Alignment Register). Improper configuration of
the Alignment register defaults the source address to an 8-byte boundary.
<br>
Other restrictions on byte boundary alignment can apply for special DMA
operations (see Misaligned Memory Accesses Section in the PXA2128
Datasheet).
<br>
These are read/write registers. Ignore reads from reserved bits. Write 0x0
to reserved bits. (Instance 12 of 16)*/
//====================================================================

#define  PDMA_DMA_SADR11_SRCADDR_MASK 0xfffffff8
#define  PDMA_DMA_SADR11_SRCADDR_SHIFT 3
#define  PDMA_DMA_SADR11_SRCADDR_MASK_SHIFT(reg) (((reg) & PDMA_DMA_SADR11_SRCADDR_MASK) >> PDMA_DMA_SADR11_SRCADDR_SHIFT)
#define  PDMA_DMA_SADR11_SRCADDR_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_SADR11_SRCADDR_MASK) | (((uint32_t)val) << PDMA_DMA_SADR11_SRCADDR_SHIFT))

#define  PDMA_DMA_SADR11_SRCADDR2_MASK 0x4
#define  PDMA_DMA_SADR11_SRCADDR2_SHIFT 2
#define  PDMA_DMA_SADR11_SRCADDR2_MASK_SHIFT(reg) (((reg) & PDMA_DMA_SADR11_SRCADDR2_MASK) >> PDMA_DMA_SADR11_SRCADDR2_SHIFT)
#define  PDMA_DMA_SADR11_SRCADDR2_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_SADR11_SRCADDR2_MASK) | (((uint32_t)val) << PDMA_DMA_SADR11_SRCADDR2_SHIFT))

#define  PDMA_DMA_SADR11_SRCADDR0_MASK 0x3
#define  PDMA_DMA_SADR11_SRCADDR0_SHIFT 0
#define  PDMA_DMA_SADR11_SRCADDR0_MASK_SHIFT(reg) (((reg) & PDMA_DMA_SADR11_SRCADDR0_MASK) >> PDMA_DMA_SADR11_SRCADDR0_SHIFT)
#define  PDMA_DMA_SADR11_SRCADDR0_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_SADR11_SRCADDR0_MASK) | (((uint32_t)val) << PDMA_DMA_SADR11_SRCADDR0_SHIFT))

//====================================================================
//Register: DMA Source Address Registers 0-15 (Instance 13 of 16) (DMA_SADR12)
/** \brief These registers are read-only for descriptor-fetch transactions and
read/write for no-descriptor-fetch transactions.
<br>
These registers contain the source address of the current descriptor for
a channel. The source address is the address of the on-chip peripheral,
external peripheral, companion chip, or the address of a memory location.
These registers cannot contain addresses of any other internal DMA
registers as they will cause a bus error.
<br>
If (1) the source address is the address of a memory location, and if (2)
the Alignment register is properly configured, the address can be aligned
to a byte boundary (see DMA Alignment Register). Improper configuration of
the Alignment register defaults the source address to an 8-byte boundary.
<br>
Other restrictions on byte boundary alignment can apply for special DMA
operations (see Misaligned Memory Accesses Section in the PXA2128
Datasheet).
<br>
These are read/write registers. Ignore reads from reserved bits. Write 0x0
to reserved bits. (Instance 13 of 16)*/
//====================================================================

#define  PDMA_DMA_SADR12_SRCADDR_MASK 0xfffffff8
#define  PDMA_DMA_SADR12_SRCADDR_SHIFT 3
#define  PDMA_DMA_SADR12_SRCADDR_MASK_SHIFT(reg) (((reg) & PDMA_DMA_SADR12_SRCADDR_MASK) >> PDMA_DMA_SADR12_SRCADDR_SHIFT)
#define  PDMA_DMA_SADR12_SRCADDR_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_SADR12_SRCADDR_MASK) | (((uint32_t)val) << PDMA_DMA_SADR12_SRCADDR_SHIFT))

#define  PDMA_DMA_SADR12_SRCADDR2_MASK 0x4
#define  PDMA_DMA_SADR12_SRCADDR2_SHIFT 2
#define  PDMA_DMA_SADR12_SRCADDR2_MASK_SHIFT(reg) (((reg) & PDMA_DMA_SADR12_SRCADDR2_MASK) >> PDMA_DMA_SADR12_SRCADDR2_SHIFT)
#define  PDMA_DMA_SADR12_SRCADDR2_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_SADR12_SRCADDR2_MASK) | (((uint32_t)val) << PDMA_DMA_SADR12_SRCADDR2_SHIFT))

#define  PDMA_DMA_SADR12_SRCADDR0_MASK 0x3
#define  PDMA_DMA_SADR12_SRCADDR0_SHIFT 0
#define  PDMA_DMA_SADR12_SRCADDR0_MASK_SHIFT(reg) (((reg) & PDMA_DMA_SADR12_SRCADDR0_MASK) >> PDMA_DMA_SADR12_SRCADDR0_SHIFT)
#define  PDMA_DMA_SADR12_SRCADDR0_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_SADR12_SRCADDR0_MASK) | (((uint32_t)val) << PDMA_DMA_SADR12_SRCADDR0_SHIFT))

//====================================================================
//Register: DMA Source Address Registers 0-15 (Instance 14 of 16) (DMA_SADR13)
/** \brief These registers are read-only for descriptor-fetch transactions and
read/write for no-descriptor-fetch transactions.
<br>
These registers contain the source address of the current descriptor for
a channel. The source address is the address of the on-chip peripheral,
external peripheral, companion chip, or the address of a memory location.
These registers cannot contain addresses of any other internal DMA
registers as they will cause a bus error.
<br>
If (1) the source address is the address of a memory location, and if (2)
the Alignment register is properly configured, the address can be aligned
to a byte boundary (see DMA Alignment Register). Improper configuration of
the Alignment register defaults the source address to an 8-byte boundary.
<br>
Other restrictions on byte boundary alignment can apply for special DMA
operations (see Misaligned Memory Accesses Section in the PXA2128
Datasheet).
<br>
These are read/write registers. Ignore reads from reserved bits. Write 0x0
to reserved bits. (Instance 14 of 16)*/
//====================================================================

#define  PDMA_DMA_SADR13_SRCADDR_MASK 0xfffffff8
#define  PDMA_DMA_SADR13_SRCADDR_SHIFT 3
#define  PDMA_DMA_SADR13_SRCADDR_MASK_SHIFT(reg) (((reg) & PDMA_DMA_SADR13_SRCADDR_MASK) >> PDMA_DMA_SADR13_SRCADDR_SHIFT)
#define  PDMA_DMA_SADR13_SRCADDR_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_SADR13_SRCADDR_MASK) | (((uint32_t)val) << PDMA_DMA_SADR13_SRCADDR_SHIFT))

#define  PDMA_DMA_SADR13_SRCADDR2_MASK 0x4
#define  PDMA_DMA_SADR13_SRCADDR2_SHIFT 2
#define  PDMA_DMA_SADR13_SRCADDR2_MASK_SHIFT(reg) (((reg) & PDMA_DMA_SADR13_SRCADDR2_MASK) >> PDMA_DMA_SADR13_SRCADDR2_SHIFT)
#define  PDMA_DMA_SADR13_SRCADDR2_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_SADR13_SRCADDR2_MASK) | (((uint32_t)val) << PDMA_DMA_SADR13_SRCADDR2_SHIFT))

#define  PDMA_DMA_SADR13_SRCADDR0_MASK 0x3
#define  PDMA_DMA_SADR13_SRCADDR0_SHIFT 0
#define  PDMA_DMA_SADR13_SRCADDR0_MASK_SHIFT(reg) (((reg) & PDMA_DMA_SADR13_SRCADDR0_MASK) >> PDMA_DMA_SADR13_SRCADDR0_SHIFT)
#define  PDMA_DMA_SADR13_SRCADDR0_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_SADR13_SRCADDR0_MASK) | (((uint32_t)val) << PDMA_DMA_SADR13_SRCADDR0_SHIFT))

//====================================================================
//Register: DMA Source Address Registers 0-15 (Instance 15 of 16) (DMA_SADR14)
/** \brief These registers are read-only for descriptor-fetch transactions and
read/write for no-descriptor-fetch transactions.
<br>
These registers contain the source address of the current descriptor for
a channel. The source address is the address of the on-chip peripheral,
external peripheral, companion chip, or the address of a memory location.
These registers cannot contain addresses of any other internal DMA
registers as they will cause a bus error.
<br>
If (1) the source address is the address of a memory location, and if (2)
the Alignment register is properly configured, the address can be aligned
to a byte boundary (see DMA Alignment Register). Improper configuration of
the Alignment register defaults the source address to an 8-byte boundary.
<br>
Other restrictions on byte boundary alignment can apply for special DMA
operations (see Misaligned Memory Accesses Section in the PXA2128
Datasheet).
<br>
These are read/write registers. Ignore reads from reserved bits. Write 0x0
to reserved bits. (Instance 15 of 16)*/
//====================================================================

#define  PDMA_DMA_SADR14_SRCADDR_MASK 0xfffffff8
#define  PDMA_DMA_SADR14_SRCADDR_SHIFT 3
#define  PDMA_DMA_SADR14_SRCADDR_MASK_SHIFT(reg) (((reg) & PDMA_DMA_SADR14_SRCADDR_MASK) >> PDMA_DMA_SADR14_SRCADDR_SHIFT)
#define  PDMA_DMA_SADR14_SRCADDR_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_SADR14_SRCADDR_MASK) | (((uint32_t)val) << PDMA_DMA_SADR14_SRCADDR_SHIFT))

#define  PDMA_DMA_SADR14_SRCADDR2_MASK 0x4
#define  PDMA_DMA_SADR14_SRCADDR2_SHIFT 2
#define  PDMA_DMA_SADR14_SRCADDR2_MASK_SHIFT(reg) (((reg) & PDMA_DMA_SADR14_SRCADDR2_MASK) >> PDMA_DMA_SADR14_SRCADDR2_SHIFT)
#define  PDMA_DMA_SADR14_SRCADDR2_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_SADR14_SRCADDR2_MASK) | (((uint32_t)val) << PDMA_DMA_SADR14_SRCADDR2_SHIFT))

#define  PDMA_DMA_SADR14_SRCADDR0_MASK 0x3
#define  PDMA_DMA_SADR14_SRCADDR0_SHIFT 0
#define  PDMA_DMA_SADR14_SRCADDR0_MASK_SHIFT(reg) (((reg) & PDMA_DMA_SADR14_SRCADDR0_MASK) >> PDMA_DMA_SADR14_SRCADDR0_SHIFT)
#define  PDMA_DMA_SADR14_SRCADDR0_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_SADR14_SRCADDR0_MASK) | (((uint32_t)val) << PDMA_DMA_SADR14_SRCADDR0_SHIFT))

//====================================================================
//Register: DMA Source Address Registers 0-15 (Instance 16 of 16) (DMA_SADR15)
/** \brief These registers are read-only for descriptor-fetch transactions and
read/write for no-descriptor-fetch transactions.
<br>
These registers contain the source address of the current descriptor for
a channel. The source address is the address of the on-chip peripheral,
external peripheral, companion chip, or the address of a memory location.
These registers cannot contain addresses of any other internal DMA
registers as they will cause a bus error.
<br>
If (1) the source address is the address of a memory location, and if (2)
the Alignment register is properly configured, the address can be aligned
to a byte boundary (see DMA Alignment Register). Improper configuration of
the Alignment register defaults the source address to an 8-byte boundary.
<br>
Other restrictions on byte boundary alignment can apply for special DMA
operations (see Misaligned Memory Accesses Section in the PXA2128
Datasheet).
<br>
These are read/write registers. Ignore reads from reserved bits. Write 0x0
to reserved bits. (Instance 16 of 16)*/
//====================================================================

#define  PDMA_DMA_SADR15_SRCADDR_MASK 0xfffffff8
#define  PDMA_DMA_SADR15_SRCADDR_SHIFT 3
#define  PDMA_DMA_SADR15_SRCADDR_MASK_SHIFT(reg) (((reg) & PDMA_DMA_SADR15_SRCADDR_MASK) >> PDMA_DMA_SADR15_SRCADDR_SHIFT)
#define  PDMA_DMA_SADR15_SRCADDR_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_SADR15_SRCADDR_MASK) | (((uint32_t)val) << PDMA_DMA_SADR15_SRCADDR_SHIFT))

#define  PDMA_DMA_SADR15_SRCADDR2_MASK 0x4
#define  PDMA_DMA_SADR15_SRCADDR2_SHIFT 2
#define  PDMA_DMA_SADR15_SRCADDR2_MASK_SHIFT(reg) (((reg) & PDMA_DMA_SADR15_SRCADDR2_MASK) >> PDMA_DMA_SADR15_SRCADDR2_SHIFT)
#define  PDMA_DMA_SADR15_SRCADDR2_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_SADR15_SRCADDR2_MASK) | (((uint32_t)val) << PDMA_DMA_SADR15_SRCADDR2_SHIFT))

#define  PDMA_DMA_SADR15_SRCADDR0_MASK 0x3
#define  PDMA_DMA_SADR15_SRCADDR0_SHIFT 0
#define  PDMA_DMA_SADR15_SRCADDR0_MASK_SHIFT(reg) (((reg) & PDMA_DMA_SADR15_SRCADDR0_MASK) >> PDMA_DMA_SADR15_SRCADDR0_SHIFT)
#define  PDMA_DMA_SADR15_SRCADDR0_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_SADR15_SRCADDR0_MASK) | (((uint32_t)val) << PDMA_DMA_SADR15_SRCADDR0_SHIFT))

//====================================================================
//Register: DMA Target Address Registers 0-15 (Instance 1 of 16) (DMA_TADR0)
/** \brief These registers are read-only for descriptor-fetch transfers and read/write
for no-descriptor-fetch transfers.
<br>
The registers contain the target address of the current descriptor for
a channel. The target address is the address of the on-chip peripheral or
the address of a memory location. These registers cannot contain addresses
of any other internal DMA registers as they cause a bus error.
<br>
If (1) the target address is the address of a memory location, and (2) if
the Alignment register is properly configured, the address can be aligned
to a byte boundary (see DMA Alignment Register). Improper configuration of
the Alignment register defaults the target address to an 8-byte boundary.
<br>
Other restrictions on byte boundary alignment can apply for special DMA
operations (see Misaligned Memory Accesses Section in the PXA2128
Datasheet).
<br>
These are read/write registers. Ignore reads from reserved bits. Write 0x0
to reserved bits. (Instance 1 of 16)*/
//====================================================================

#define  PDMA_DMA_TADR0_TRGADDR_MASK 0xfffffff8
#define  PDMA_DMA_TADR0_TRGADDR_SHIFT 3
#define  PDMA_DMA_TADR0_TRGADDR_MASK_SHIFT(reg) (((reg) & PDMA_DMA_TADR0_TRGADDR_MASK) >> PDMA_DMA_TADR0_TRGADDR_SHIFT)
#define  PDMA_DMA_TADR0_TRGADDR_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_TADR0_TRGADDR_MASK) | (((uint32_t)val) << PDMA_DMA_TADR0_TRGADDR_SHIFT))

#define  PDMA_DMA_TADR0_TRGADDR2_MASK 0x4
#define  PDMA_DMA_TADR0_TRGADDR2_SHIFT 2
#define  PDMA_DMA_TADR0_TRGADDR2_MASK_SHIFT(reg) (((reg) & PDMA_DMA_TADR0_TRGADDR2_MASK) >> PDMA_DMA_TADR0_TRGADDR2_SHIFT)
#define  PDMA_DMA_TADR0_TRGADDR2_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_TADR0_TRGADDR2_MASK) | (((uint32_t)val) << PDMA_DMA_TADR0_TRGADDR2_SHIFT))

#define  PDMA_DMA_TADR0_TRGADDR0_MASK 0x3
#define  PDMA_DMA_TADR0_TRGADDR0_SHIFT 0
#define  PDMA_DMA_TADR0_TRGADDR0_MASK_SHIFT(reg) (((reg) & PDMA_DMA_TADR0_TRGADDR0_MASK) >> PDMA_DMA_TADR0_TRGADDR0_SHIFT)
#define  PDMA_DMA_TADR0_TRGADDR0_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_TADR0_TRGADDR0_MASK) | (((uint32_t)val) << PDMA_DMA_TADR0_TRGADDR0_SHIFT))

//====================================================================
//Register: DMA Target Address Registers 0-15 (Instance 2 of 16) (DMA_TADR1)
/** \brief These registers are read-only for descriptor-fetch transfers and read/write
for no-descriptor-fetch transfers.
<br>
The registers contain the target address of the current descriptor for
a channel. The target address is the address of the on-chip peripheral or
the address of a memory location. These registers cannot contain addresses
of any other internal DMA registers as they cause a bus error.
<br>
If (1) the target address is the address of a memory location, and (2) if
the Alignment register is properly configured, the address can be aligned
to a byte boundary (see DMA Alignment Register). Improper configuration of
the Alignment register defaults the target address to an 8-byte boundary.
<br>
Other restrictions on byte boundary alignment can apply for special DMA
operations (see Misaligned Memory Accesses Section in the PXA2128
Datasheet).
<br>
These are read/write registers. Ignore reads from reserved bits. Write 0x0
to reserved bits. (Instance 2 of 16)*/
//====================================================================

#define  PDMA_DMA_TADR1_TRGADDR_MASK 0xfffffff8
#define  PDMA_DMA_TADR1_TRGADDR_SHIFT 3
#define  PDMA_DMA_TADR1_TRGADDR_MASK_SHIFT(reg) (((reg) & PDMA_DMA_TADR1_TRGADDR_MASK) >> PDMA_DMA_TADR1_TRGADDR_SHIFT)
#define  PDMA_DMA_TADR1_TRGADDR_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_TADR1_TRGADDR_MASK) | (((uint32_t)val) << PDMA_DMA_TADR1_TRGADDR_SHIFT))

#define  PDMA_DMA_TADR1_TRGADDR2_MASK 0x4
#define  PDMA_DMA_TADR1_TRGADDR2_SHIFT 2
#define  PDMA_DMA_TADR1_TRGADDR2_MASK_SHIFT(reg) (((reg) & PDMA_DMA_TADR1_TRGADDR2_MASK) >> PDMA_DMA_TADR1_TRGADDR2_SHIFT)
#define  PDMA_DMA_TADR1_TRGADDR2_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_TADR1_TRGADDR2_MASK) | (((uint32_t)val) << PDMA_DMA_TADR1_TRGADDR2_SHIFT))

#define  PDMA_DMA_TADR1_TRGADDR0_MASK 0x3
#define  PDMA_DMA_TADR1_TRGADDR0_SHIFT 0
#define  PDMA_DMA_TADR1_TRGADDR0_MASK_SHIFT(reg) (((reg) & PDMA_DMA_TADR1_TRGADDR0_MASK) >> PDMA_DMA_TADR1_TRGADDR0_SHIFT)
#define  PDMA_DMA_TADR1_TRGADDR0_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_TADR1_TRGADDR0_MASK) | (((uint32_t)val) << PDMA_DMA_TADR1_TRGADDR0_SHIFT))

//====================================================================
//Register: DMA Target Address Registers 0-15 (Instance 3 of 16) (DMA_TADR2)
/** \brief These registers are read-only for descriptor-fetch transfers and read/write
for no-descriptor-fetch transfers.
<br>
The registers contain the target address of the current descriptor for
a channel. The target address is the address of the on-chip peripheral or
the address of a memory location. These registers cannot contain addresses
of any other internal DMA registers as they cause a bus error.
<br>
If (1) the target address is the address of a memory location, and (2) if
the Alignment register is properly configured, the address can be aligned
to a byte boundary (see DMA Alignment Register). Improper configuration of
the Alignment register defaults the target address to an 8-byte boundary.
<br>
Other restrictions on byte boundary alignment can apply for special DMA
operations (see Misaligned Memory Accesses Section in the PXA2128
Datasheet).
<br>
These are read/write registers. Ignore reads from reserved bits. Write 0x0
to reserved bits. (Instance 3 of 16)*/
//====================================================================

#define  PDMA_DMA_TADR2_TRGADDR_MASK 0xfffffff8
#define  PDMA_DMA_TADR2_TRGADDR_SHIFT 3
#define  PDMA_DMA_TADR2_TRGADDR_MASK_SHIFT(reg) (((reg) & PDMA_DMA_TADR2_TRGADDR_MASK) >> PDMA_DMA_TADR2_TRGADDR_SHIFT)
#define  PDMA_DMA_TADR2_TRGADDR_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_TADR2_TRGADDR_MASK) | (((uint32_t)val) << PDMA_DMA_TADR2_TRGADDR_SHIFT))

#define  PDMA_DMA_TADR2_TRGADDR2_MASK 0x4
#define  PDMA_DMA_TADR2_TRGADDR2_SHIFT 2
#define  PDMA_DMA_TADR2_TRGADDR2_MASK_SHIFT(reg) (((reg) & PDMA_DMA_TADR2_TRGADDR2_MASK) >> PDMA_DMA_TADR2_TRGADDR2_SHIFT)
#define  PDMA_DMA_TADR2_TRGADDR2_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_TADR2_TRGADDR2_MASK) | (((uint32_t)val) << PDMA_DMA_TADR2_TRGADDR2_SHIFT))

#define  PDMA_DMA_TADR2_TRGADDR0_MASK 0x3
#define  PDMA_DMA_TADR2_TRGADDR0_SHIFT 0
#define  PDMA_DMA_TADR2_TRGADDR0_MASK_SHIFT(reg) (((reg) & PDMA_DMA_TADR2_TRGADDR0_MASK) >> PDMA_DMA_TADR2_TRGADDR0_SHIFT)
#define  PDMA_DMA_TADR2_TRGADDR0_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_TADR2_TRGADDR0_MASK) | (((uint32_t)val) << PDMA_DMA_TADR2_TRGADDR0_SHIFT))

//====================================================================
//Register: DMA Target Address Registers 0-15 (Instance 4 of 16) (DMA_TADR3)
/** \brief These registers are read-only for descriptor-fetch transfers and read/write
for no-descriptor-fetch transfers.
<br>
The registers contain the target address of the current descriptor for
a channel. The target address is the address of the on-chip peripheral or
the address of a memory location. These registers cannot contain addresses
of any other internal DMA registers as they cause a bus error.
<br>
If (1) the target address is the address of a memory location, and (2) if
the Alignment register is properly configured, the address can be aligned
to a byte boundary (see DMA Alignment Register). Improper configuration of
the Alignment register defaults the target address to an 8-byte boundary.
<br>
Other restrictions on byte boundary alignment can apply for special DMA
operations (see Misaligned Memory Accesses Section in the PXA2128
Datasheet).
<br>
These are read/write registers. Ignore reads from reserved bits. Write 0x0
to reserved bits. (Instance 4 of 16)*/
//====================================================================

#define  PDMA_DMA_TADR3_TRGADDR_MASK 0xfffffff8
#define  PDMA_DMA_TADR3_TRGADDR_SHIFT 3
#define  PDMA_DMA_TADR3_TRGADDR_MASK_SHIFT(reg) (((reg) & PDMA_DMA_TADR3_TRGADDR_MASK) >> PDMA_DMA_TADR3_TRGADDR_SHIFT)
#define  PDMA_DMA_TADR3_TRGADDR_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_TADR3_TRGADDR_MASK) | (((uint32_t)val) << PDMA_DMA_TADR3_TRGADDR_SHIFT))

#define  PDMA_DMA_TADR3_TRGADDR2_MASK 0x4
#define  PDMA_DMA_TADR3_TRGADDR2_SHIFT 2
#define  PDMA_DMA_TADR3_TRGADDR2_MASK_SHIFT(reg) (((reg) & PDMA_DMA_TADR3_TRGADDR2_MASK) >> PDMA_DMA_TADR3_TRGADDR2_SHIFT)
#define  PDMA_DMA_TADR3_TRGADDR2_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_TADR3_TRGADDR2_MASK) | (((uint32_t)val) << PDMA_DMA_TADR3_TRGADDR2_SHIFT))

#define  PDMA_DMA_TADR3_TRGADDR0_MASK 0x3
#define  PDMA_DMA_TADR3_TRGADDR0_SHIFT 0
#define  PDMA_DMA_TADR3_TRGADDR0_MASK_SHIFT(reg) (((reg) & PDMA_DMA_TADR3_TRGADDR0_MASK) >> PDMA_DMA_TADR3_TRGADDR0_SHIFT)
#define  PDMA_DMA_TADR3_TRGADDR0_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_TADR3_TRGADDR0_MASK) | (((uint32_t)val) << PDMA_DMA_TADR3_TRGADDR0_SHIFT))

//====================================================================
//Register: DMA Target Address Registers 0-15 (Instance 5 of 16) (DMA_TADR4)
/** \brief These registers are read-only for descriptor-fetch transfers and read/write
for no-descriptor-fetch transfers.
<br>
The registers contain the target address of the current descriptor for
a channel. The target address is the address of the on-chip peripheral or
the address of a memory location. These registers cannot contain addresses
of any other internal DMA registers as they cause a bus error.
<br>
If (1) the target address is the address of a memory location, and (2) if
the Alignment register is properly configured, the address can be aligned
to a byte boundary (see DMA Alignment Register). Improper configuration of
the Alignment register defaults the target address to an 8-byte boundary.
<br>
Other restrictions on byte boundary alignment can apply for special DMA
operations (see Misaligned Memory Accesses Section in the PXA2128
Datasheet).
<br>
These are read/write registers. Ignore reads from reserved bits. Write 0x0
to reserved bits. (Instance 5 of 16)*/
//====================================================================

#define  PDMA_DMA_TADR4_TRGADDR_MASK 0xfffffff8
#define  PDMA_DMA_TADR4_TRGADDR_SHIFT 3
#define  PDMA_DMA_TADR4_TRGADDR_MASK_SHIFT(reg) (((reg) & PDMA_DMA_TADR4_TRGADDR_MASK) >> PDMA_DMA_TADR4_TRGADDR_SHIFT)
#define  PDMA_DMA_TADR4_TRGADDR_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_TADR4_TRGADDR_MASK) | (((uint32_t)val) << PDMA_DMA_TADR4_TRGADDR_SHIFT))

#define  PDMA_DMA_TADR4_TRGADDR2_MASK 0x4
#define  PDMA_DMA_TADR4_TRGADDR2_SHIFT 2
#define  PDMA_DMA_TADR4_TRGADDR2_MASK_SHIFT(reg) (((reg) & PDMA_DMA_TADR4_TRGADDR2_MASK) >> PDMA_DMA_TADR4_TRGADDR2_SHIFT)
#define  PDMA_DMA_TADR4_TRGADDR2_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_TADR4_TRGADDR2_MASK) | (((uint32_t)val) << PDMA_DMA_TADR4_TRGADDR2_SHIFT))

#define  PDMA_DMA_TADR4_TRGADDR0_MASK 0x3
#define  PDMA_DMA_TADR4_TRGADDR0_SHIFT 0
#define  PDMA_DMA_TADR4_TRGADDR0_MASK_SHIFT(reg) (((reg) & PDMA_DMA_TADR4_TRGADDR0_MASK) >> PDMA_DMA_TADR4_TRGADDR0_SHIFT)
#define  PDMA_DMA_TADR4_TRGADDR0_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_TADR4_TRGADDR0_MASK) | (((uint32_t)val) << PDMA_DMA_TADR4_TRGADDR0_SHIFT))

//====================================================================
//Register: DMA Target Address Registers 0-15 (Instance 6 of 16) (DMA_TADR5)
/** \brief These registers are read-only for descriptor-fetch transfers and read/write
for no-descriptor-fetch transfers.
<br>
The registers contain the target address of the current descriptor for
a channel. The target address is the address of the on-chip peripheral or
the address of a memory location. These registers cannot contain addresses
of any other internal DMA registers as they cause a bus error.
<br>
If (1) the target address is the address of a memory location, and (2) if
the Alignment register is properly configured, the address can be aligned
to a byte boundary (see DMA Alignment Register). Improper configuration of
the Alignment register defaults the target address to an 8-byte boundary.
<br>
Other restrictions on byte boundary alignment can apply for special DMA
operations (see Misaligned Memory Accesses Section in the PXA2128
Datasheet).
<br>
These are read/write registers. Ignore reads from reserved bits. Write 0x0
to reserved bits. (Instance 6 of 16)*/
//====================================================================

#define  PDMA_DMA_TADR5_TRGADDR_MASK 0xfffffff8
#define  PDMA_DMA_TADR5_TRGADDR_SHIFT 3
#define  PDMA_DMA_TADR5_TRGADDR_MASK_SHIFT(reg) (((reg) & PDMA_DMA_TADR5_TRGADDR_MASK) >> PDMA_DMA_TADR5_TRGADDR_SHIFT)
#define  PDMA_DMA_TADR5_TRGADDR_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_TADR5_TRGADDR_MASK) | (((uint32_t)val) << PDMA_DMA_TADR5_TRGADDR_SHIFT))

#define  PDMA_DMA_TADR5_TRGADDR2_MASK 0x4
#define  PDMA_DMA_TADR5_TRGADDR2_SHIFT 2
#define  PDMA_DMA_TADR5_TRGADDR2_MASK_SHIFT(reg) (((reg) & PDMA_DMA_TADR5_TRGADDR2_MASK) >> PDMA_DMA_TADR5_TRGADDR2_SHIFT)
#define  PDMA_DMA_TADR5_TRGADDR2_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_TADR5_TRGADDR2_MASK) | (((uint32_t)val) << PDMA_DMA_TADR5_TRGADDR2_SHIFT))

#define  PDMA_DMA_TADR5_TRGADDR0_MASK 0x3
#define  PDMA_DMA_TADR5_TRGADDR0_SHIFT 0
#define  PDMA_DMA_TADR5_TRGADDR0_MASK_SHIFT(reg) (((reg) & PDMA_DMA_TADR5_TRGADDR0_MASK) >> PDMA_DMA_TADR5_TRGADDR0_SHIFT)
#define  PDMA_DMA_TADR5_TRGADDR0_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_TADR5_TRGADDR0_MASK) | (((uint32_t)val) << PDMA_DMA_TADR5_TRGADDR0_SHIFT))

//====================================================================
//Register: DMA Target Address Registers 0-15 (Instance 7 of 16) (DMA_TADR6)
/** \brief These registers are read-only for descriptor-fetch transfers and read/write
for no-descriptor-fetch transfers.
<br>
The registers contain the target address of the current descriptor for
a channel. The target address is the address of the on-chip peripheral or
the address of a memory location. These registers cannot contain addresses
of any other internal DMA registers as they cause a bus error.
<br>
If (1) the target address is the address of a memory location, and (2) if
the Alignment register is properly configured, the address can be aligned
to a byte boundary (see DMA Alignment Register). Improper configuration of
the Alignment register defaults the target address to an 8-byte boundary.
<br>
Other restrictions on byte boundary alignment can apply for special DMA
operations (see Misaligned Memory Accesses Section in the PXA2128
Datasheet).
<br>
These are read/write registers. Ignore reads from reserved bits. Write 0x0
to reserved bits. (Instance 7 of 16)*/
//====================================================================

#define  PDMA_DMA_TADR6_TRGADDR_MASK 0xfffffff8
#define  PDMA_DMA_TADR6_TRGADDR_SHIFT 3
#define  PDMA_DMA_TADR6_TRGADDR_MASK_SHIFT(reg) (((reg) & PDMA_DMA_TADR6_TRGADDR_MASK) >> PDMA_DMA_TADR6_TRGADDR_SHIFT)
#define  PDMA_DMA_TADR6_TRGADDR_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_TADR6_TRGADDR_MASK) | (((uint32_t)val) << PDMA_DMA_TADR6_TRGADDR_SHIFT))

#define  PDMA_DMA_TADR6_TRGADDR2_MASK 0x4
#define  PDMA_DMA_TADR6_TRGADDR2_SHIFT 2
#define  PDMA_DMA_TADR6_TRGADDR2_MASK_SHIFT(reg) (((reg) & PDMA_DMA_TADR6_TRGADDR2_MASK) >> PDMA_DMA_TADR6_TRGADDR2_SHIFT)
#define  PDMA_DMA_TADR6_TRGADDR2_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_TADR6_TRGADDR2_MASK) | (((uint32_t)val) << PDMA_DMA_TADR6_TRGADDR2_SHIFT))

#define  PDMA_DMA_TADR6_TRGADDR0_MASK 0x3
#define  PDMA_DMA_TADR6_TRGADDR0_SHIFT 0
#define  PDMA_DMA_TADR6_TRGADDR0_MASK_SHIFT(reg) (((reg) & PDMA_DMA_TADR6_TRGADDR0_MASK) >> PDMA_DMA_TADR6_TRGADDR0_SHIFT)
#define  PDMA_DMA_TADR6_TRGADDR0_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_TADR6_TRGADDR0_MASK) | (((uint32_t)val) << PDMA_DMA_TADR6_TRGADDR0_SHIFT))

//====================================================================
//Register: DMA Target Address Registers 0-15 (Instance 8 of 16) (DMA_TADR7)
/** \brief These registers are read-only for descriptor-fetch transfers and read/write
for no-descriptor-fetch transfers.
<br>
The registers contain the target address of the current descriptor for
a channel. The target address is the address of the on-chip peripheral or
the address of a memory location. These registers cannot contain addresses
of any other internal DMA registers as they cause a bus error.
<br>
If (1) the target address is the address of a memory location, and (2) if
the Alignment register is properly configured, the address can be aligned
to a byte boundary (see DMA Alignment Register). Improper configuration of
the Alignment register defaults the target address to an 8-byte boundary.
<br>
Other restrictions on byte boundary alignment can apply for special DMA
operations (see Misaligned Memory Accesses Section in the PXA2128
Datasheet).
<br>
These are read/write registers. Ignore reads from reserved bits. Write 0x0
to reserved bits. (Instance 8 of 16)*/
//====================================================================

#define  PDMA_DMA_TADR7_TRGADDR_MASK 0xfffffff8
#define  PDMA_DMA_TADR7_TRGADDR_SHIFT 3
#define  PDMA_DMA_TADR7_TRGADDR_MASK_SHIFT(reg) (((reg) & PDMA_DMA_TADR7_TRGADDR_MASK) >> PDMA_DMA_TADR7_TRGADDR_SHIFT)
#define  PDMA_DMA_TADR7_TRGADDR_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_TADR7_TRGADDR_MASK) | (((uint32_t)val) << PDMA_DMA_TADR7_TRGADDR_SHIFT))

#define  PDMA_DMA_TADR7_TRGADDR2_MASK 0x4
#define  PDMA_DMA_TADR7_TRGADDR2_SHIFT 2
#define  PDMA_DMA_TADR7_TRGADDR2_MASK_SHIFT(reg) (((reg) & PDMA_DMA_TADR7_TRGADDR2_MASK) >> PDMA_DMA_TADR7_TRGADDR2_SHIFT)
#define  PDMA_DMA_TADR7_TRGADDR2_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_TADR7_TRGADDR2_MASK) | (((uint32_t)val) << PDMA_DMA_TADR7_TRGADDR2_SHIFT))

#define  PDMA_DMA_TADR7_TRGADDR0_MASK 0x3
#define  PDMA_DMA_TADR7_TRGADDR0_SHIFT 0
#define  PDMA_DMA_TADR7_TRGADDR0_MASK_SHIFT(reg) (((reg) & PDMA_DMA_TADR7_TRGADDR0_MASK) >> PDMA_DMA_TADR7_TRGADDR0_SHIFT)
#define  PDMA_DMA_TADR7_TRGADDR0_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_TADR7_TRGADDR0_MASK) | (((uint32_t)val) << PDMA_DMA_TADR7_TRGADDR0_SHIFT))

//====================================================================
//Register: DMA Target Address Registers 0-15 (Instance 9 of 16) (DMA_TADR8)
/** \brief These registers are read-only for descriptor-fetch transfers and read/write
for no-descriptor-fetch transfers.
<br>
The registers contain the target address of the current descriptor for
a channel. The target address is the address of the on-chip peripheral or
the address of a memory location. These registers cannot contain addresses
of any other internal DMA registers as they cause a bus error.
<br>
If (1) the target address is the address of a memory location, and (2) if
the Alignment register is properly configured, the address can be aligned
to a byte boundary (see DMA Alignment Register). Improper configuration of
the Alignment register defaults the target address to an 8-byte boundary.
<br>
Other restrictions on byte boundary alignment can apply for special DMA
operations (see Misaligned Memory Accesses Section in the PXA2128
Datasheet).
<br>
These are read/write registers. Ignore reads from reserved bits. Write 0x0
to reserved bits. (Instance 9 of 16)*/
//====================================================================

#define  PDMA_DMA_TADR8_TRGADDR_MASK 0xfffffff8
#define  PDMA_DMA_TADR8_TRGADDR_SHIFT 3
#define  PDMA_DMA_TADR8_TRGADDR_MASK_SHIFT(reg) (((reg) & PDMA_DMA_TADR8_TRGADDR_MASK) >> PDMA_DMA_TADR8_TRGADDR_SHIFT)
#define  PDMA_DMA_TADR8_TRGADDR_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_TADR8_TRGADDR_MASK) | (((uint32_t)val) << PDMA_DMA_TADR8_TRGADDR_SHIFT))

#define  PDMA_DMA_TADR8_TRGADDR2_MASK 0x4
#define  PDMA_DMA_TADR8_TRGADDR2_SHIFT 2
#define  PDMA_DMA_TADR8_TRGADDR2_MASK_SHIFT(reg) (((reg) & PDMA_DMA_TADR8_TRGADDR2_MASK) >> PDMA_DMA_TADR8_TRGADDR2_SHIFT)
#define  PDMA_DMA_TADR8_TRGADDR2_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_TADR8_TRGADDR2_MASK) | (((uint32_t)val) << PDMA_DMA_TADR8_TRGADDR2_SHIFT))

#define  PDMA_DMA_TADR8_TRGADDR0_MASK 0x3
#define  PDMA_DMA_TADR8_TRGADDR0_SHIFT 0
#define  PDMA_DMA_TADR8_TRGADDR0_MASK_SHIFT(reg) (((reg) & PDMA_DMA_TADR8_TRGADDR0_MASK) >> PDMA_DMA_TADR8_TRGADDR0_SHIFT)
#define  PDMA_DMA_TADR8_TRGADDR0_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_TADR8_TRGADDR0_MASK) | (((uint32_t)val) << PDMA_DMA_TADR8_TRGADDR0_SHIFT))

//====================================================================
//Register: DMA Target Address Registers 0-15 (Instance 10 of 16) (DMA_TADR9)
/** \brief These registers are read-only for descriptor-fetch transfers and read/write
for no-descriptor-fetch transfers.
<br>
The registers contain the target address of the current descriptor for
a channel. The target address is the address of the on-chip peripheral or
the address of a memory location. These registers cannot contain addresses
of any other internal DMA registers as they cause a bus error.
<br>
If (1) the target address is the address of a memory location, and (2) if
the Alignment register is properly configured, the address can be aligned
to a byte boundary (see DMA Alignment Register). Improper configuration of
the Alignment register defaults the target address to an 8-byte boundary.
<br>
Other restrictions on byte boundary alignment can apply for special DMA
operations (see Misaligned Memory Accesses Section in the PXA2128
Datasheet).
<br>
These are read/write registers. Ignore reads from reserved bits. Write 0x0
to reserved bits. (Instance 10 of 16)*/
//====================================================================

#define  PDMA_DMA_TADR9_TRGADDR_MASK 0xfffffff8
#define  PDMA_DMA_TADR9_TRGADDR_SHIFT 3
#define  PDMA_DMA_TADR9_TRGADDR_MASK_SHIFT(reg) (((reg) & PDMA_DMA_TADR9_TRGADDR_MASK) >> PDMA_DMA_TADR9_TRGADDR_SHIFT)
#define  PDMA_DMA_TADR9_TRGADDR_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_TADR9_TRGADDR_MASK) | (((uint32_t)val) << PDMA_DMA_TADR9_TRGADDR_SHIFT))

#define  PDMA_DMA_TADR9_TRGADDR2_MASK 0x4
#define  PDMA_DMA_TADR9_TRGADDR2_SHIFT 2
#define  PDMA_DMA_TADR9_TRGADDR2_MASK_SHIFT(reg) (((reg) & PDMA_DMA_TADR9_TRGADDR2_MASK) >> PDMA_DMA_TADR9_TRGADDR2_SHIFT)
#define  PDMA_DMA_TADR9_TRGADDR2_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_TADR9_TRGADDR2_MASK) | (((uint32_t)val) << PDMA_DMA_TADR9_TRGADDR2_SHIFT))

#define  PDMA_DMA_TADR9_TRGADDR0_MASK 0x3
#define  PDMA_DMA_TADR9_TRGADDR0_SHIFT 0
#define  PDMA_DMA_TADR9_TRGADDR0_MASK_SHIFT(reg) (((reg) & PDMA_DMA_TADR9_TRGADDR0_MASK) >> PDMA_DMA_TADR9_TRGADDR0_SHIFT)
#define  PDMA_DMA_TADR9_TRGADDR0_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_TADR9_TRGADDR0_MASK) | (((uint32_t)val) << PDMA_DMA_TADR9_TRGADDR0_SHIFT))

//====================================================================
//Register: DMA Target Address Registers 0-15 (Instance 11 of 16) (DMA_TADR10)
/** \brief These registers are read-only for descriptor-fetch transfers and read/write
for no-descriptor-fetch transfers.
<br>
The registers contain the target address of the current descriptor for
a channel. The target address is the address of the on-chip peripheral or
the address of a memory location. These registers cannot contain addresses
of any other internal DMA registers as they cause a bus error.
<br>
If (1) the target address is the address of a memory location, and (2) if
the Alignment register is properly configured, the address can be aligned
to a byte boundary (see DMA Alignment Register). Improper configuration of
the Alignment register defaults the target address to an 8-byte boundary.
<br>
Other restrictions on byte boundary alignment can apply for special DMA
operations (see Misaligned Memory Accesses Section in the PXA2128
Datasheet).
<br>
These are read/write registers. Ignore reads from reserved bits. Write 0x0
to reserved bits. (Instance 11 of 16)*/
//====================================================================

#define  PDMA_DMA_TADR10_TRGADDR_MASK 0xfffffff8
#define  PDMA_DMA_TADR10_TRGADDR_SHIFT 3
#define  PDMA_DMA_TADR10_TRGADDR_MASK_SHIFT(reg) (((reg) & PDMA_DMA_TADR10_TRGADDR_MASK) >> PDMA_DMA_TADR10_TRGADDR_SHIFT)
#define  PDMA_DMA_TADR10_TRGADDR_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_TADR10_TRGADDR_MASK) | (((uint32_t)val) << PDMA_DMA_TADR10_TRGADDR_SHIFT))

#define  PDMA_DMA_TADR10_TRGADDR2_MASK 0x4
#define  PDMA_DMA_TADR10_TRGADDR2_SHIFT 2
#define  PDMA_DMA_TADR10_TRGADDR2_MASK_SHIFT(reg) (((reg) & PDMA_DMA_TADR10_TRGADDR2_MASK) >> PDMA_DMA_TADR10_TRGADDR2_SHIFT)
#define  PDMA_DMA_TADR10_TRGADDR2_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_TADR10_TRGADDR2_MASK) | (((uint32_t)val) << PDMA_DMA_TADR10_TRGADDR2_SHIFT))

#define  PDMA_DMA_TADR10_TRGADDR0_MASK 0x3
#define  PDMA_DMA_TADR10_TRGADDR0_SHIFT 0
#define  PDMA_DMA_TADR10_TRGADDR0_MASK_SHIFT(reg) (((reg) & PDMA_DMA_TADR10_TRGADDR0_MASK) >> PDMA_DMA_TADR10_TRGADDR0_SHIFT)
#define  PDMA_DMA_TADR10_TRGADDR0_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_TADR10_TRGADDR0_MASK) | (((uint32_t)val) << PDMA_DMA_TADR10_TRGADDR0_SHIFT))

//====================================================================
//Register: DMA Target Address Registers 0-15 (Instance 12 of 16) (DMA_TADR11)
/** \brief These registers are read-only for descriptor-fetch transfers and read/write
for no-descriptor-fetch transfers.
<br>
The registers contain the target address of the current descriptor for
a channel. The target address is the address of the on-chip peripheral or
the address of a memory location. These registers cannot contain addresses
of any other internal DMA registers as they cause a bus error.
<br>
If (1) the target address is the address of a memory location, and (2) if
the Alignment register is properly configured, the address can be aligned
to a byte boundary (see DMA Alignment Register). Improper configuration of
the Alignment register defaults the target address to an 8-byte boundary.
<br>
Other restrictions on byte boundary alignment can apply for special DMA
operations (see Misaligned Memory Accesses Section in the PXA2128
Datasheet).
<br>
These are read/write registers. Ignore reads from reserved bits. Write 0x0
to reserved bits. (Instance 12 of 16)*/
//====================================================================

#define  PDMA_DMA_TADR11_TRGADDR_MASK 0xfffffff8
#define  PDMA_DMA_TADR11_TRGADDR_SHIFT 3
#define  PDMA_DMA_TADR11_TRGADDR_MASK_SHIFT(reg) (((reg) & PDMA_DMA_TADR11_TRGADDR_MASK) >> PDMA_DMA_TADR11_TRGADDR_SHIFT)
#define  PDMA_DMA_TADR11_TRGADDR_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_TADR11_TRGADDR_MASK) | (((uint32_t)val) << PDMA_DMA_TADR11_TRGADDR_SHIFT))

#define  PDMA_DMA_TADR11_TRGADDR2_MASK 0x4
#define  PDMA_DMA_TADR11_TRGADDR2_SHIFT 2
#define  PDMA_DMA_TADR11_TRGADDR2_MASK_SHIFT(reg) (((reg) & PDMA_DMA_TADR11_TRGADDR2_MASK) >> PDMA_DMA_TADR11_TRGADDR2_SHIFT)
#define  PDMA_DMA_TADR11_TRGADDR2_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_TADR11_TRGADDR2_MASK) | (((uint32_t)val) << PDMA_DMA_TADR11_TRGADDR2_SHIFT))

#define  PDMA_DMA_TADR11_TRGADDR0_MASK 0x3
#define  PDMA_DMA_TADR11_TRGADDR0_SHIFT 0
#define  PDMA_DMA_TADR11_TRGADDR0_MASK_SHIFT(reg) (((reg) & PDMA_DMA_TADR11_TRGADDR0_MASK) >> PDMA_DMA_TADR11_TRGADDR0_SHIFT)
#define  PDMA_DMA_TADR11_TRGADDR0_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_TADR11_TRGADDR0_MASK) | (((uint32_t)val) << PDMA_DMA_TADR11_TRGADDR0_SHIFT))

//====================================================================
//Register: DMA Target Address Registers 0-15 (Instance 13 of 16) (DMA_TADR12)
/** \brief These registers are read-only for descriptor-fetch transfers and read/write
for no-descriptor-fetch transfers.
<br>
The registers contain the target address of the current descriptor for
a channel. The target address is the address of the on-chip peripheral or
the address of a memory location. These registers cannot contain addresses
of any other internal DMA registers as they cause a bus error.
<br>
If (1) the target address is the address of a memory location, and (2) if
the Alignment register is properly configured, the address can be aligned
to a byte boundary (see DMA Alignment Register). Improper configuration of
the Alignment register defaults the target address to an 8-byte boundary.
<br>
Other restrictions on byte boundary alignment can apply for special DMA
operations (see Misaligned Memory Accesses Section in the PXA2128
Datasheet).
<br>
These are read/write registers. Ignore reads from reserved bits. Write 0x0
to reserved bits. (Instance 13 of 16)*/
//====================================================================

#define  PDMA_DMA_TADR12_TRGADDR_MASK 0xfffffff8
#define  PDMA_DMA_TADR12_TRGADDR_SHIFT 3
#define  PDMA_DMA_TADR12_TRGADDR_MASK_SHIFT(reg) (((reg) & PDMA_DMA_TADR12_TRGADDR_MASK) >> PDMA_DMA_TADR12_TRGADDR_SHIFT)
#define  PDMA_DMA_TADR12_TRGADDR_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_TADR12_TRGADDR_MASK) | (((uint32_t)val) << PDMA_DMA_TADR12_TRGADDR_SHIFT))

#define  PDMA_DMA_TADR12_TRGADDR2_MASK 0x4
#define  PDMA_DMA_TADR12_TRGADDR2_SHIFT 2
#define  PDMA_DMA_TADR12_TRGADDR2_MASK_SHIFT(reg) (((reg) & PDMA_DMA_TADR12_TRGADDR2_MASK) >> PDMA_DMA_TADR12_TRGADDR2_SHIFT)
#define  PDMA_DMA_TADR12_TRGADDR2_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_TADR12_TRGADDR2_MASK) | (((uint32_t)val) << PDMA_DMA_TADR12_TRGADDR2_SHIFT))

#define  PDMA_DMA_TADR12_TRGADDR0_MASK 0x3
#define  PDMA_DMA_TADR12_TRGADDR0_SHIFT 0
#define  PDMA_DMA_TADR12_TRGADDR0_MASK_SHIFT(reg) (((reg) & PDMA_DMA_TADR12_TRGADDR0_MASK) >> PDMA_DMA_TADR12_TRGADDR0_SHIFT)
#define  PDMA_DMA_TADR12_TRGADDR0_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_TADR12_TRGADDR0_MASK) | (((uint32_t)val) << PDMA_DMA_TADR12_TRGADDR0_SHIFT))

//====================================================================
//Register: DMA Target Address Registers 0-15 (Instance 14 of 16) (DMA_TADR13)
/** \brief These registers are read-only for descriptor-fetch transfers and read/write
for no-descriptor-fetch transfers.
<br>
The registers contain the target address of the current descriptor for
a channel. The target address is the address of the on-chip peripheral or
the address of a memory location. These registers cannot contain addresses
of any other internal DMA registers as they cause a bus error.
<br>
If (1) the target address is the address of a memory location, and (2) if
the Alignment register is properly configured, the address can be aligned
to a byte boundary (see DMA Alignment Register). Improper configuration of
the Alignment register defaults the target address to an 8-byte boundary.
<br>
Other restrictions on byte boundary alignment can apply for special DMA
operations (see Misaligned Memory Accesses Section in the PXA2128
Datasheet).
<br>
These are read/write registers. Ignore reads from reserved bits. Write 0x0
to reserved bits. (Instance 14 of 16)*/
//====================================================================

#define  PDMA_DMA_TADR13_TRGADDR_MASK 0xfffffff8
#define  PDMA_DMA_TADR13_TRGADDR_SHIFT 3
#define  PDMA_DMA_TADR13_TRGADDR_MASK_SHIFT(reg) (((reg) & PDMA_DMA_TADR13_TRGADDR_MASK) >> PDMA_DMA_TADR13_TRGADDR_SHIFT)
#define  PDMA_DMA_TADR13_TRGADDR_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_TADR13_TRGADDR_MASK) | (((uint32_t)val) << PDMA_DMA_TADR13_TRGADDR_SHIFT))

#define  PDMA_DMA_TADR13_TRGADDR2_MASK 0x4
#define  PDMA_DMA_TADR13_TRGADDR2_SHIFT 2
#define  PDMA_DMA_TADR13_TRGADDR2_MASK_SHIFT(reg) (((reg) & PDMA_DMA_TADR13_TRGADDR2_MASK) >> PDMA_DMA_TADR13_TRGADDR2_SHIFT)
#define  PDMA_DMA_TADR13_TRGADDR2_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_TADR13_TRGADDR2_MASK) | (((uint32_t)val) << PDMA_DMA_TADR13_TRGADDR2_SHIFT))

#define  PDMA_DMA_TADR13_TRGADDR0_MASK 0x3
#define  PDMA_DMA_TADR13_TRGADDR0_SHIFT 0
#define  PDMA_DMA_TADR13_TRGADDR0_MASK_SHIFT(reg) (((reg) & PDMA_DMA_TADR13_TRGADDR0_MASK) >> PDMA_DMA_TADR13_TRGADDR0_SHIFT)
#define  PDMA_DMA_TADR13_TRGADDR0_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_TADR13_TRGADDR0_MASK) | (((uint32_t)val) << PDMA_DMA_TADR13_TRGADDR0_SHIFT))

//====================================================================
//Register: DMA Target Address Registers 0-15 (Instance 15 of 16) (DMA_TADR14)
/** \brief These registers are read-only for descriptor-fetch transfers and read/write
for no-descriptor-fetch transfers.
<br>
The registers contain the target address of the current descriptor for
a channel. The target address is the address of the on-chip peripheral or
the address of a memory location. These registers cannot contain addresses
of any other internal DMA registers as they cause a bus error.
<br>
If (1) the target address is the address of a memory location, and (2) if
the Alignment register is properly configured, the address can be aligned
to a byte boundary (see DMA Alignment Register). Improper configuration of
the Alignment register defaults the target address to an 8-byte boundary.
<br>
Other restrictions on byte boundary alignment can apply for special DMA
operations (see Misaligned Memory Accesses Section in the PXA2128
Datasheet).
<br>
These are read/write registers. Ignore reads from reserved bits. Write 0x0
to reserved bits. (Instance 15 of 16)*/
//====================================================================

#define  PDMA_DMA_TADR14_TRGADDR_MASK 0xfffffff8
#define  PDMA_DMA_TADR14_TRGADDR_SHIFT 3
#define  PDMA_DMA_TADR14_TRGADDR_MASK_SHIFT(reg) (((reg) & PDMA_DMA_TADR14_TRGADDR_MASK) >> PDMA_DMA_TADR14_TRGADDR_SHIFT)
#define  PDMA_DMA_TADR14_TRGADDR_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_TADR14_TRGADDR_MASK) | (((uint32_t)val) << PDMA_DMA_TADR14_TRGADDR_SHIFT))

#define  PDMA_DMA_TADR14_TRGADDR2_MASK 0x4
#define  PDMA_DMA_TADR14_TRGADDR2_SHIFT 2
#define  PDMA_DMA_TADR14_TRGADDR2_MASK_SHIFT(reg) (((reg) & PDMA_DMA_TADR14_TRGADDR2_MASK) >> PDMA_DMA_TADR14_TRGADDR2_SHIFT)
#define  PDMA_DMA_TADR14_TRGADDR2_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_TADR14_TRGADDR2_MASK) | (((uint32_t)val) << PDMA_DMA_TADR14_TRGADDR2_SHIFT))

#define  PDMA_DMA_TADR14_TRGADDR0_MASK 0x3
#define  PDMA_DMA_TADR14_TRGADDR0_SHIFT 0
#define  PDMA_DMA_TADR14_TRGADDR0_MASK_SHIFT(reg) (((reg) & PDMA_DMA_TADR14_TRGADDR0_MASK) >> PDMA_DMA_TADR14_TRGADDR0_SHIFT)
#define  PDMA_DMA_TADR14_TRGADDR0_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_TADR14_TRGADDR0_MASK) | (((uint32_t)val) << PDMA_DMA_TADR14_TRGADDR0_SHIFT))

//====================================================================
//Register: DMA Target Address Registers 0-15 (Instance 16 of 16) (DMA_TADR15)
/** \brief These registers are read-only for descriptor-fetch transfers and read/write
for no-descriptor-fetch transfers.
<br>
The registers contain the target address of the current descriptor for
a channel. The target address is the address of the on-chip peripheral or
the address of a memory location. These registers cannot contain addresses
of any other internal DMA registers as they cause a bus error.
<br>
If (1) the target address is the address of a memory location, and (2) if
the Alignment register is properly configured, the address can be aligned
to a byte boundary (see DMA Alignment Register). Improper configuration of
the Alignment register defaults the target address to an 8-byte boundary.
<br>
Other restrictions on byte boundary alignment can apply for special DMA
operations (see Misaligned Memory Accesses Section in the PXA2128
Datasheet).
<br>
These are read/write registers. Ignore reads from reserved bits. Write 0x0
to reserved bits. (Instance 16 of 16)*/
//====================================================================

#define  PDMA_DMA_TADR15_TRGADDR_MASK 0xfffffff8
#define  PDMA_DMA_TADR15_TRGADDR_SHIFT 3
#define  PDMA_DMA_TADR15_TRGADDR_MASK_SHIFT(reg) (((reg) & PDMA_DMA_TADR15_TRGADDR_MASK) >> PDMA_DMA_TADR15_TRGADDR_SHIFT)
#define  PDMA_DMA_TADR15_TRGADDR_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_TADR15_TRGADDR_MASK) | (((uint32_t)val) << PDMA_DMA_TADR15_TRGADDR_SHIFT))

#define  PDMA_DMA_TADR15_TRGADDR2_MASK 0x4
#define  PDMA_DMA_TADR15_TRGADDR2_SHIFT 2
#define  PDMA_DMA_TADR15_TRGADDR2_MASK_SHIFT(reg) (((reg) & PDMA_DMA_TADR15_TRGADDR2_MASK) >> PDMA_DMA_TADR15_TRGADDR2_SHIFT)
#define  PDMA_DMA_TADR15_TRGADDR2_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_TADR15_TRGADDR2_MASK) | (((uint32_t)val) << PDMA_DMA_TADR15_TRGADDR2_SHIFT))

#define  PDMA_DMA_TADR15_TRGADDR0_MASK 0x3
#define  PDMA_DMA_TADR15_TRGADDR0_SHIFT 0
#define  PDMA_DMA_TADR15_TRGADDR0_MASK_SHIFT(reg) (((reg) & PDMA_DMA_TADR15_TRGADDR0_MASK) >> PDMA_DMA_TADR15_TRGADDR0_SHIFT)
#define  PDMA_DMA_TADR15_TRGADDR0_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_TADR15_TRGADDR0_MASK) | (((uint32_t)val) << PDMA_DMA_TADR15_TRGADDR0_SHIFT))

//====================================================================
//Register: DMA Command Registers 0-15 (Instance 1 of 16) (DMA_CMD0)
/** \brief These read-only registers are for descriptor-fetch transfers and read/write
for no-descriptor-fetch transfers.
<br>
These are read/write registers. Ignore reads from reserved bits. Write 0x0
to reserved bits. (Instance 1 of 16)*/
//====================================================================

#define  PDMA_DMA_CMD0_INCSRCADDR_MASK 0x80000000
#define  PDMA_DMA_CMD0_INCSRCADDR_SHIFT 31
#define  PDMA_DMA_CMD0_INCSRCADDR_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD0_INCSRCADDR_MASK) >> PDMA_DMA_CMD0_INCSRCADDR_SHIFT)
#define  PDMA_DMA_CMD0_INCSRCADDR_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD0_INCSRCADDR_MASK) | (((uint32_t)val) << PDMA_DMA_CMD0_INCSRCADDR_SHIFT))

#define  PDMA_DMA_CMD0_INCTRGADDR_MASK 0x40000000
#define  PDMA_DMA_CMD0_INCTRGADDR_SHIFT 30
#define  PDMA_DMA_CMD0_INCTRGADDR_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD0_INCTRGADDR_MASK) >> PDMA_DMA_CMD0_INCTRGADDR_SHIFT)
#define  PDMA_DMA_CMD0_INCTRGADDR_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD0_INCTRGADDR_MASK) | (((uint32_t)val) << PDMA_DMA_CMD0_INCTRGADDR_SHIFT))

#define  PDMA_DMA_CMD0_FLOWSRC_MASK 0x20000000
#define  PDMA_DMA_CMD0_FLOWSRC_SHIFT 29
#define  PDMA_DMA_CMD0_FLOWSRC_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD0_FLOWSRC_MASK) >> PDMA_DMA_CMD0_FLOWSRC_SHIFT)
#define  PDMA_DMA_CMD0_FLOWSRC_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD0_FLOWSRC_MASK) | (((uint32_t)val) << PDMA_DMA_CMD0_FLOWSRC_SHIFT))

#define  PDMA_DMA_CMD0_FLOWTRG_MASK 0x10000000
#define  PDMA_DMA_CMD0_FLOWTRG_SHIFT 28
#define  PDMA_DMA_CMD0_FLOWTRG_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD0_FLOWTRG_MASK) >> PDMA_DMA_CMD0_FLOWTRG_SHIFT)
#define  PDMA_DMA_CMD0_FLOWTRG_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD0_FLOWTRG_MASK) | (((uint32_t)val) << PDMA_DMA_CMD0_FLOWTRG_SHIFT))

#define  PDMA_DMA_CMD0_RESERVED1_MASK 0xc000000
#define  PDMA_DMA_CMD0_RESERVED1_SHIFT 26
#define  PDMA_DMA_CMD0_RESERVED1_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD0_RESERVED1_MASK) >> PDMA_DMA_CMD0_RESERVED1_SHIFT)
#define  PDMA_DMA_CMD0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD0_RESERVED1_MASK) | (((uint32_t)val) << PDMA_DMA_CMD0_RESERVED1_SHIFT))

#define  PDMA_DMA_CMD0_CMPEN_MASK 0x2000000
#define  PDMA_DMA_CMD0_CMPEN_SHIFT 25
#define  PDMA_DMA_CMD0_CMPEN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD0_CMPEN_MASK) >> PDMA_DMA_CMD0_CMPEN_SHIFT)
#define  PDMA_DMA_CMD0_CMPEN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD0_CMPEN_MASK) | (((uint32_t)val) << PDMA_DMA_CMD0_CMPEN_SHIFT))

#define  PDMA_DMA_CMD0_RESERVED2_MASK 0x1000000
#define  PDMA_DMA_CMD0_RESERVED2_SHIFT 24
#define  PDMA_DMA_CMD0_RESERVED2_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD0_RESERVED2_MASK) >> PDMA_DMA_CMD0_RESERVED2_SHIFT)
#define  PDMA_DMA_CMD0_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD0_RESERVED2_MASK) | (((uint32_t)val) << PDMA_DMA_CMD0_RESERVED2_SHIFT))

#define  PDMA_DMA_CMD0_ADDRMODE_MASK 0x800000
#define  PDMA_DMA_CMD0_ADDRMODE_SHIFT 23
#define  PDMA_DMA_CMD0_ADDRMODE_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD0_ADDRMODE_MASK) >> PDMA_DMA_CMD0_ADDRMODE_SHIFT)
#define  PDMA_DMA_CMD0_ADDRMODE_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD0_ADDRMODE_MASK) | (((uint32_t)val) << PDMA_DMA_CMD0_ADDRMODE_SHIFT))

#define  PDMA_DMA_CMD0_STARTIRQEN_MASK 0x400000
#define  PDMA_DMA_CMD0_STARTIRQEN_SHIFT 22
#define  PDMA_DMA_CMD0_STARTIRQEN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD0_STARTIRQEN_MASK) >> PDMA_DMA_CMD0_STARTIRQEN_SHIFT)
#define  PDMA_DMA_CMD0_STARTIRQEN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD0_STARTIRQEN_MASK) | (((uint32_t)val) << PDMA_DMA_CMD0_STARTIRQEN_SHIFT))

#define  PDMA_DMA_CMD0_ENDIRQEN_MASK 0x200000
#define  PDMA_DMA_CMD0_ENDIRQEN_SHIFT 21
#define  PDMA_DMA_CMD0_ENDIRQEN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD0_ENDIRQEN_MASK) >> PDMA_DMA_CMD0_ENDIRQEN_SHIFT)
#define  PDMA_DMA_CMD0_ENDIRQEN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD0_ENDIRQEN_MASK) | (((uint32_t)val) << PDMA_DMA_CMD0_ENDIRQEN_SHIFT))

#define  PDMA_DMA_CMD0_RESERVED3_MASK 0x180000
#define  PDMA_DMA_CMD0_RESERVED3_SHIFT 19
#define  PDMA_DMA_CMD0_RESERVED3_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD0_RESERVED3_MASK) >> PDMA_DMA_CMD0_RESERVED3_SHIFT)
#define  PDMA_DMA_CMD0_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD0_RESERVED3_MASK) | (((uint32_t)val) << PDMA_DMA_CMD0_RESERVED3_SHIFT))

#define  PDMA_DMA_CMD0_SIZE_MASK 0x70000
#define  PDMA_DMA_CMD0_SIZE_SHIFT 16
#define  PDMA_DMA_CMD0_SIZE_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD0_SIZE_MASK) >> PDMA_DMA_CMD0_SIZE_SHIFT)
#define  PDMA_DMA_CMD0_SIZE_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD0_SIZE_MASK) | (((uint32_t)val) << PDMA_DMA_CMD0_SIZE_SHIFT))

#define  PDMA_DMA_CMD0_WIDTH_MASK 0xc000
#define  PDMA_DMA_CMD0_WIDTH_SHIFT 14
#define  PDMA_DMA_CMD0_WIDTH_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD0_WIDTH_MASK) >> PDMA_DMA_CMD0_WIDTH_SHIFT)
#define  PDMA_DMA_CMD0_WIDTH_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD0_WIDTH_MASK) | (((uint32_t)val) << PDMA_DMA_CMD0_WIDTH_SHIFT))

#define  PDMA_DMA_CMD0_RESERVED4_MASK 0x2000
#define  PDMA_DMA_CMD0_RESERVED4_SHIFT 13
#define  PDMA_DMA_CMD0_RESERVED4_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD0_RESERVED4_MASK) >> PDMA_DMA_CMD0_RESERVED4_SHIFT)
#define  PDMA_DMA_CMD0_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD0_RESERVED4_MASK) | (((uint32_t)val) << PDMA_DMA_CMD0_RESERVED4_SHIFT))

#define  PDMA_DMA_CMD0_LEN_MASK 0x1fff
#define  PDMA_DMA_CMD0_LEN_SHIFT 0
#define  PDMA_DMA_CMD0_LEN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD0_LEN_MASK) >> PDMA_DMA_CMD0_LEN_SHIFT)
#define  PDMA_DMA_CMD0_LEN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD0_LEN_MASK) | (((uint32_t)val) << PDMA_DMA_CMD0_LEN_SHIFT))

//====================================================================
//Register: DMA Command Registers 0-15 (Instance 2 of 16) (DMA_CMD1)
/** \brief These read-only registers are for descriptor-fetch transfers and read/write
for no-descriptor-fetch transfers.
<br>
These are read/write registers. Ignore reads from reserved bits. Write 0x0
to reserved bits. (Instance 2 of 16)*/
//====================================================================

#define  PDMA_DMA_CMD1_INCSRCADDR_MASK 0x80000000
#define  PDMA_DMA_CMD1_INCSRCADDR_SHIFT 31
#define  PDMA_DMA_CMD1_INCSRCADDR_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD1_INCSRCADDR_MASK) >> PDMA_DMA_CMD1_INCSRCADDR_SHIFT)
#define  PDMA_DMA_CMD1_INCSRCADDR_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD1_INCSRCADDR_MASK) | (((uint32_t)val) << PDMA_DMA_CMD1_INCSRCADDR_SHIFT))

#define  PDMA_DMA_CMD1_INCTRGADDR_MASK 0x40000000
#define  PDMA_DMA_CMD1_INCTRGADDR_SHIFT 30
#define  PDMA_DMA_CMD1_INCTRGADDR_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD1_INCTRGADDR_MASK) >> PDMA_DMA_CMD1_INCTRGADDR_SHIFT)
#define  PDMA_DMA_CMD1_INCTRGADDR_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD1_INCTRGADDR_MASK) | (((uint32_t)val) << PDMA_DMA_CMD1_INCTRGADDR_SHIFT))

#define  PDMA_DMA_CMD1_FLOWSRC_MASK 0x20000000
#define  PDMA_DMA_CMD1_FLOWSRC_SHIFT 29
#define  PDMA_DMA_CMD1_FLOWSRC_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD1_FLOWSRC_MASK) >> PDMA_DMA_CMD1_FLOWSRC_SHIFT)
#define  PDMA_DMA_CMD1_FLOWSRC_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD1_FLOWSRC_MASK) | (((uint32_t)val) << PDMA_DMA_CMD1_FLOWSRC_SHIFT))

#define  PDMA_DMA_CMD1_FLOWTRG_MASK 0x10000000
#define  PDMA_DMA_CMD1_FLOWTRG_SHIFT 28
#define  PDMA_DMA_CMD1_FLOWTRG_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD1_FLOWTRG_MASK) >> PDMA_DMA_CMD1_FLOWTRG_SHIFT)
#define  PDMA_DMA_CMD1_FLOWTRG_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD1_FLOWTRG_MASK) | (((uint32_t)val) << PDMA_DMA_CMD1_FLOWTRG_SHIFT))

#define  PDMA_DMA_CMD1_RESERVED1_MASK 0xc000000
#define  PDMA_DMA_CMD1_RESERVED1_SHIFT 26
#define  PDMA_DMA_CMD1_RESERVED1_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD1_RESERVED1_MASK) >> PDMA_DMA_CMD1_RESERVED1_SHIFT)
#define  PDMA_DMA_CMD1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD1_RESERVED1_MASK) | (((uint32_t)val) << PDMA_DMA_CMD1_RESERVED1_SHIFT))

#define  PDMA_DMA_CMD1_CMPEN_MASK 0x2000000
#define  PDMA_DMA_CMD1_CMPEN_SHIFT 25
#define  PDMA_DMA_CMD1_CMPEN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD1_CMPEN_MASK) >> PDMA_DMA_CMD1_CMPEN_SHIFT)
#define  PDMA_DMA_CMD1_CMPEN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD1_CMPEN_MASK) | (((uint32_t)val) << PDMA_DMA_CMD1_CMPEN_SHIFT))

#define  PDMA_DMA_CMD1_RESERVED2_MASK 0x1000000
#define  PDMA_DMA_CMD1_RESERVED2_SHIFT 24
#define  PDMA_DMA_CMD1_RESERVED2_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD1_RESERVED2_MASK) >> PDMA_DMA_CMD1_RESERVED2_SHIFT)
#define  PDMA_DMA_CMD1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD1_RESERVED2_MASK) | (((uint32_t)val) << PDMA_DMA_CMD1_RESERVED2_SHIFT))

#define  PDMA_DMA_CMD1_ADDRMODE_MASK 0x800000
#define  PDMA_DMA_CMD1_ADDRMODE_SHIFT 23
#define  PDMA_DMA_CMD1_ADDRMODE_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD1_ADDRMODE_MASK) >> PDMA_DMA_CMD1_ADDRMODE_SHIFT)
#define  PDMA_DMA_CMD1_ADDRMODE_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD1_ADDRMODE_MASK) | (((uint32_t)val) << PDMA_DMA_CMD1_ADDRMODE_SHIFT))

#define  PDMA_DMA_CMD1_STARTIRQEN_MASK 0x400000
#define  PDMA_DMA_CMD1_STARTIRQEN_SHIFT 22
#define  PDMA_DMA_CMD1_STARTIRQEN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD1_STARTIRQEN_MASK) >> PDMA_DMA_CMD1_STARTIRQEN_SHIFT)
#define  PDMA_DMA_CMD1_STARTIRQEN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD1_STARTIRQEN_MASK) | (((uint32_t)val) << PDMA_DMA_CMD1_STARTIRQEN_SHIFT))

#define  PDMA_DMA_CMD1_ENDIRQEN_MASK 0x200000
#define  PDMA_DMA_CMD1_ENDIRQEN_SHIFT 21
#define  PDMA_DMA_CMD1_ENDIRQEN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD1_ENDIRQEN_MASK) >> PDMA_DMA_CMD1_ENDIRQEN_SHIFT)
#define  PDMA_DMA_CMD1_ENDIRQEN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD1_ENDIRQEN_MASK) | (((uint32_t)val) << PDMA_DMA_CMD1_ENDIRQEN_SHIFT))

#define  PDMA_DMA_CMD1_RESERVED3_MASK 0x180000
#define  PDMA_DMA_CMD1_RESERVED3_SHIFT 19
#define  PDMA_DMA_CMD1_RESERVED3_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD1_RESERVED3_MASK) >> PDMA_DMA_CMD1_RESERVED3_SHIFT)
#define  PDMA_DMA_CMD1_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD1_RESERVED3_MASK) | (((uint32_t)val) << PDMA_DMA_CMD1_RESERVED3_SHIFT))

#define  PDMA_DMA_CMD1_SIZE_MASK 0x70000
#define  PDMA_DMA_CMD1_SIZE_SHIFT 16
#define  PDMA_DMA_CMD1_SIZE_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD1_SIZE_MASK) >> PDMA_DMA_CMD1_SIZE_SHIFT)
#define  PDMA_DMA_CMD1_SIZE_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD1_SIZE_MASK) | (((uint32_t)val) << PDMA_DMA_CMD1_SIZE_SHIFT))

#define  PDMA_DMA_CMD1_WIDTH_MASK 0xc000
#define  PDMA_DMA_CMD1_WIDTH_SHIFT 14
#define  PDMA_DMA_CMD1_WIDTH_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD1_WIDTH_MASK) >> PDMA_DMA_CMD1_WIDTH_SHIFT)
#define  PDMA_DMA_CMD1_WIDTH_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD1_WIDTH_MASK) | (((uint32_t)val) << PDMA_DMA_CMD1_WIDTH_SHIFT))

#define  PDMA_DMA_CMD1_RESERVED4_MASK 0x2000
#define  PDMA_DMA_CMD1_RESERVED4_SHIFT 13
#define  PDMA_DMA_CMD1_RESERVED4_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD1_RESERVED4_MASK) >> PDMA_DMA_CMD1_RESERVED4_SHIFT)
#define  PDMA_DMA_CMD1_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD1_RESERVED4_MASK) | (((uint32_t)val) << PDMA_DMA_CMD1_RESERVED4_SHIFT))

#define  PDMA_DMA_CMD1_LEN_MASK 0x1fff
#define  PDMA_DMA_CMD1_LEN_SHIFT 0
#define  PDMA_DMA_CMD1_LEN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD1_LEN_MASK) >> PDMA_DMA_CMD1_LEN_SHIFT)
#define  PDMA_DMA_CMD1_LEN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD1_LEN_MASK) | (((uint32_t)val) << PDMA_DMA_CMD1_LEN_SHIFT))

//====================================================================
//Register: DMA Command Registers 0-15 (Instance 3 of 16) (DMA_CMD2)
/** \brief These read-only registers are for descriptor-fetch transfers and read/write
for no-descriptor-fetch transfers.
<br>
These are read/write registers. Ignore reads from reserved bits. Write 0x0
to reserved bits. (Instance 3 of 16)*/
//====================================================================

#define  PDMA_DMA_CMD2_INCSRCADDR_MASK 0x80000000
#define  PDMA_DMA_CMD2_INCSRCADDR_SHIFT 31
#define  PDMA_DMA_CMD2_INCSRCADDR_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD2_INCSRCADDR_MASK) >> PDMA_DMA_CMD2_INCSRCADDR_SHIFT)
#define  PDMA_DMA_CMD2_INCSRCADDR_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD2_INCSRCADDR_MASK) | (((uint32_t)val) << PDMA_DMA_CMD2_INCSRCADDR_SHIFT))

#define  PDMA_DMA_CMD2_INCTRGADDR_MASK 0x40000000
#define  PDMA_DMA_CMD2_INCTRGADDR_SHIFT 30
#define  PDMA_DMA_CMD2_INCTRGADDR_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD2_INCTRGADDR_MASK) >> PDMA_DMA_CMD2_INCTRGADDR_SHIFT)
#define  PDMA_DMA_CMD2_INCTRGADDR_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD2_INCTRGADDR_MASK) | (((uint32_t)val) << PDMA_DMA_CMD2_INCTRGADDR_SHIFT))

#define  PDMA_DMA_CMD2_FLOWSRC_MASK 0x20000000
#define  PDMA_DMA_CMD2_FLOWSRC_SHIFT 29
#define  PDMA_DMA_CMD2_FLOWSRC_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD2_FLOWSRC_MASK) >> PDMA_DMA_CMD2_FLOWSRC_SHIFT)
#define  PDMA_DMA_CMD2_FLOWSRC_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD2_FLOWSRC_MASK) | (((uint32_t)val) << PDMA_DMA_CMD2_FLOWSRC_SHIFT))

#define  PDMA_DMA_CMD2_FLOWTRG_MASK 0x10000000
#define  PDMA_DMA_CMD2_FLOWTRG_SHIFT 28
#define  PDMA_DMA_CMD2_FLOWTRG_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD2_FLOWTRG_MASK) >> PDMA_DMA_CMD2_FLOWTRG_SHIFT)
#define  PDMA_DMA_CMD2_FLOWTRG_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD2_FLOWTRG_MASK) | (((uint32_t)val) << PDMA_DMA_CMD2_FLOWTRG_SHIFT))

#define  PDMA_DMA_CMD2_RESERVED1_MASK 0xc000000
#define  PDMA_DMA_CMD2_RESERVED1_SHIFT 26
#define  PDMA_DMA_CMD2_RESERVED1_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD2_RESERVED1_MASK) >> PDMA_DMA_CMD2_RESERVED1_SHIFT)
#define  PDMA_DMA_CMD2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD2_RESERVED1_MASK) | (((uint32_t)val) << PDMA_DMA_CMD2_RESERVED1_SHIFT))

#define  PDMA_DMA_CMD2_CMPEN_MASK 0x2000000
#define  PDMA_DMA_CMD2_CMPEN_SHIFT 25
#define  PDMA_DMA_CMD2_CMPEN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD2_CMPEN_MASK) >> PDMA_DMA_CMD2_CMPEN_SHIFT)
#define  PDMA_DMA_CMD2_CMPEN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD2_CMPEN_MASK) | (((uint32_t)val) << PDMA_DMA_CMD2_CMPEN_SHIFT))

#define  PDMA_DMA_CMD2_RESERVED2_MASK 0x1000000
#define  PDMA_DMA_CMD2_RESERVED2_SHIFT 24
#define  PDMA_DMA_CMD2_RESERVED2_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD2_RESERVED2_MASK) >> PDMA_DMA_CMD2_RESERVED2_SHIFT)
#define  PDMA_DMA_CMD2_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD2_RESERVED2_MASK) | (((uint32_t)val) << PDMA_DMA_CMD2_RESERVED2_SHIFT))

#define  PDMA_DMA_CMD2_ADDRMODE_MASK 0x800000
#define  PDMA_DMA_CMD2_ADDRMODE_SHIFT 23
#define  PDMA_DMA_CMD2_ADDRMODE_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD2_ADDRMODE_MASK) >> PDMA_DMA_CMD2_ADDRMODE_SHIFT)
#define  PDMA_DMA_CMD2_ADDRMODE_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD2_ADDRMODE_MASK) | (((uint32_t)val) << PDMA_DMA_CMD2_ADDRMODE_SHIFT))

#define  PDMA_DMA_CMD2_STARTIRQEN_MASK 0x400000
#define  PDMA_DMA_CMD2_STARTIRQEN_SHIFT 22
#define  PDMA_DMA_CMD2_STARTIRQEN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD2_STARTIRQEN_MASK) >> PDMA_DMA_CMD2_STARTIRQEN_SHIFT)
#define  PDMA_DMA_CMD2_STARTIRQEN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD2_STARTIRQEN_MASK) | (((uint32_t)val) << PDMA_DMA_CMD2_STARTIRQEN_SHIFT))

#define  PDMA_DMA_CMD2_ENDIRQEN_MASK 0x200000
#define  PDMA_DMA_CMD2_ENDIRQEN_SHIFT 21
#define  PDMA_DMA_CMD2_ENDIRQEN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD2_ENDIRQEN_MASK) >> PDMA_DMA_CMD2_ENDIRQEN_SHIFT)
#define  PDMA_DMA_CMD2_ENDIRQEN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD2_ENDIRQEN_MASK) | (((uint32_t)val) << PDMA_DMA_CMD2_ENDIRQEN_SHIFT))

#define  PDMA_DMA_CMD2_RESERVED3_MASK 0x180000
#define  PDMA_DMA_CMD2_RESERVED3_SHIFT 19
#define  PDMA_DMA_CMD2_RESERVED3_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD2_RESERVED3_MASK) >> PDMA_DMA_CMD2_RESERVED3_SHIFT)
#define  PDMA_DMA_CMD2_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD2_RESERVED3_MASK) | (((uint32_t)val) << PDMA_DMA_CMD2_RESERVED3_SHIFT))

#define  PDMA_DMA_CMD2_SIZE_MASK 0x70000
#define  PDMA_DMA_CMD2_SIZE_SHIFT 16
#define  PDMA_DMA_CMD2_SIZE_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD2_SIZE_MASK) >> PDMA_DMA_CMD2_SIZE_SHIFT)
#define  PDMA_DMA_CMD2_SIZE_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD2_SIZE_MASK) | (((uint32_t)val) << PDMA_DMA_CMD2_SIZE_SHIFT))

#define  PDMA_DMA_CMD2_WIDTH_MASK 0xc000
#define  PDMA_DMA_CMD2_WIDTH_SHIFT 14
#define  PDMA_DMA_CMD2_WIDTH_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD2_WIDTH_MASK) >> PDMA_DMA_CMD2_WIDTH_SHIFT)
#define  PDMA_DMA_CMD2_WIDTH_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD2_WIDTH_MASK) | (((uint32_t)val) << PDMA_DMA_CMD2_WIDTH_SHIFT))

#define  PDMA_DMA_CMD2_RESERVED4_MASK 0x2000
#define  PDMA_DMA_CMD2_RESERVED4_SHIFT 13
#define  PDMA_DMA_CMD2_RESERVED4_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD2_RESERVED4_MASK) >> PDMA_DMA_CMD2_RESERVED4_SHIFT)
#define  PDMA_DMA_CMD2_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD2_RESERVED4_MASK) | (((uint32_t)val) << PDMA_DMA_CMD2_RESERVED4_SHIFT))

#define  PDMA_DMA_CMD2_LEN_MASK 0x1fff
#define  PDMA_DMA_CMD2_LEN_SHIFT 0
#define  PDMA_DMA_CMD2_LEN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD2_LEN_MASK) >> PDMA_DMA_CMD2_LEN_SHIFT)
#define  PDMA_DMA_CMD2_LEN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD2_LEN_MASK) | (((uint32_t)val) << PDMA_DMA_CMD2_LEN_SHIFT))

//====================================================================
//Register: DMA Command Registers 0-15 (Instance 4 of 16) (DMA_CMD3)
/** \brief These read-only registers are for descriptor-fetch transfers and read/write
for no-descriptor-fetch transfers.
<br>
These are read/write registers. Ignore reads from reserved bits. Write 0x0
to reserved bits. (Instance 4 of 16)*/
//====================================================================

#define  PDMA_DMA_CMD3_INCSRCADDR_MASK 0x80000000
#define  PDMA_DMA_CMD3_INCSRCADDR_SHIFT 31
#define  PDMA_DMA_CMD3_INCSRCADDR_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD3_INCSRCADDR_MASK) >> PDMA_DMA_CMD3_INCSRCADDR_SHIFT)
#define  PDMA_DMA_CMD3_INCSRCADDR_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD3_INCSRCADDR_MASK) | (((uint32_t)val) << PDMA_DMA_CMD3_INCSRCADDR_SHIFT))

#define  PDMA_DMA_CMD3_INCTRGADDR_MASK 0x40000000
#define  PDMA_DMA_CMD3_INCTRGADDR_SHIFT 30
#define  PDMA_DMA_CMD3_INCTRGADDR_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD3_INCTRGADDR_MASK) >> PDMA_DMA_CMD3_INCTRGADDR_SHIFT)
#define  PDMA_DMA_CMD3_INCTRGADDR_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD3_INCTRGADDR_MASK) | (((uint32_t)val) << PDMA_DMA_CMD3_INCTRGADDR_SHIFT))

#define  PDMA_DMA_CMD3_FLOWSRC_MASK 0x20000000
#define  PDMA_DMA_CMD3_FLOWSRC_SHIFT 29
#define  PDMA_DMA_CMD3_FLOWSRC_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD3_FLOWSRC_MASK) >> PDMA_DMA_CMD3_FLOWSRC_SHIFT)
#define  PDMA_DMA_CMD3_FLOWSRC_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD3_FLOWSRC_MASK) | (((uint32_t)val) << PDMA_DMA_CMD3_FLOWSRC_SHIFT))

#define  PDMA_DMA_CMD3_FLOWTRG_MASK 0x10000000
#define  PDMA_DMA_CMD3_FLOWTRG_SHIFT 28
#define  PDMA_DMA_CMD3_FLOWTRG_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD3_FLOWTRG_MASK) >> PDMA_DMA_CMD3_FLOWTRG_SHIFT)
#define  PDMA_DMA_CMD3_FLOWTRG_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD3_FLOWTRG_MASK) | (((uint32_t)val) << PDMA_DMA_CMD3_FLOWTRG_SHIFT))

#define  PDMA_DMA_CMD3_RESERVED1_MASK 0xc000000
#define  PDMA_DMA_CMD3_RESERVED1_SHIFT 26
#define  PDMA_DMA_CMD3_RESERVED1_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD3_RESERVED1_MASK) >> PDMA_DMA_CMD3_RESERVED1_SHIFT)
#define  PDMA_DMA_CMD3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD3_RESERVED1_MASK) | (((uint32_t)val) << PDMA_DMA_CMD3_RESERVED1_SHIFT))

#define  PDMA_DMA_CMD3_CMPEN_MASK 0x2000000
#define  PDMA_DMA_CMD3_CMPEN_SHIFT 25
#define  PDMA_DMA_CMD3_CMPEN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD3_CMPEN_MASK) >> PDMA_DMA_CMD3_CMPEN_SHIFT)
#define  PDMA_DMA_CMD3_CMPEN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD3_CMPEN_MASK) | (((uint32_t)val) << PDMA_DMA_CMD3_CMPEN_SHIFT))

#define  PDMA_DMA_CMD3_RESERVED2_MASK 0x1000000
#define  PDMA_DMA_CMD3_RESERVED2_SHIFT 24
#define  PDMA_DMA_CMD3_RESERVED2_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD3_RESERVED2_MASK) >> PDMA_DMA_CMD3_RESERVED2_SHIFT)
#define  PDMA_DMA_CMD3_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD3_RESERVED2_MASK) | (((uint32_t)val) << PDMA_DMA_CMD3_RESERVED2_SHIFT))

#define  PDMA_DMA_CMD3_ADDRMODE_MASK 0x800000
#define  PDMA_DMA_CMD3_ADDRMODE_SHIFT 23
#define  PDMA_DMA_CMD3_ADDRMODE_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD3_ADDRMODE_MASK) >> PDMA_DMA_CMD3_ADDRMODE_SHIFT)
#define  PDMA_DMA_CMD3_ADDRMODE_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD3_ADDRMODE_MASK) | (((uint32_t)val) << PDMA_DMA_CMD3_ADDRMODE_SHIFT))

#define  PDMA_DMA_CMD3_STARTIRQEN_MASK 0x400000
#define  PDMA_DMA_CMD3_STARTIRQEN_SHIFT 22
#define  PDMA_DMA_CMD3_STARTIRQEN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD3_STARTIRQEN_MASK) >> PDMA_DMA_CMD3_STARTIRQEN_SHIFT)
#define  PDMA_DMA_CMD3_STARTIRQEN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD3_STARTIRQEN_MASK) | (((uint32_t)val) << PDMA_DMA_CMD3_STARTIRQEN_SHIFT))

#define  PDMA_DMA_CMD3_ENDIRQEN_MASK 0x200000
#define  PDMA_DMA_CMD3_ENDIRQEN_SHIFT 21
#define  PDMA_DMA_CMD3_ENDIRQEN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD3_ENDIRQEN_MASK) >> PDMA_DMA_CMD3_ENDIRQEN_SHIFT)
#define  PDMA_DMA_CMD3_ENDIRQEN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD3_ENDIRQEN_MASK) | (((uint32_t)val) << PDMA_DMA_CMD3_ENDIRQEN_SHIFT))

#define  PDMA_DMA_CMD3_RESERVED3_MASK 0x180000
#define  PDMA_DMA_CMD3_RESERVED3_SHIFT 19
#define  PDMA_DMA_CMD3_RESERVED3_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD3_RESERVED3_MASK) >> PDMA_DMA_CMD3_RESERVED3_SHIFT)
#define  PDMA_DMA_CMD3_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD3_RESERVED3_MASK) | (((uint32_t)val) << PDMA_DMA_CMD3_RESERVED3_SHIFT))

#define  PDMA_DMA_CMD3_SIZE_MASK 0x70000
#define  PDMA_DMA_CMD3_SIZE_SHIFT 16
#define  PDMA_DMA_CMD3_SIZE_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD3_SIZE_MASK) >> PDMA_DMA_CMD3_SIZE_SHIFT)
#define  PDMA_DMA_CMD3_SIZE_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD3_SIZE_MASK) | (((uint32_t)val) << PDMA_DMA_CMD3_SIZE_SHIFT))

#define  PDMA_DMA_CMD3_WIDTH_MASK 0xc000
#define  PDMA_DMA_CMD3_WIDTH_SHIFT 14
#define  PDMA_DMA_CMD3_WIDTH_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD3_WIDTH_MASK) >> PDMA_DMA_CMD3_WIDTH_SHIFT)
#define  PDMA_DMA_CMD3_WIDTH_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD3_WIDTH_MASK) | (((uint32_t)val) << PDMA_DMA_CMD3_WIDTH_SHIFT))

#define  PDMA_DMA_CMD3_RESERVED4_MASK 0x2000
#define  PDMA_DMA_CMD3_RESERVED4_SHIFT 13
#define  PDMA_DMA_CMD3_RESERVED4_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD3_RESERVED4_MASK) >> PDMA_DMA_CMD3_RESERVED4_SHIFT)
#define  PDMA_DMA_CMD3_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD3_RESERVED4_MASK) | (((uint32_t)val) << PDMA_DMA_CMD3_RESERVED4_SHIFT))

#define  PDMA_DMA_CMD3_LEN_MASK 0x1fff
#define  PDMA_DMA_CMD3_LEN_SHIFT 0
#define  PDMA_DMA_CMD3_LEN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD3_LEN_MASK) >> PDMA_DMA_CMD3_LEN_SHIFT)
#define  PDMA_DMA_CMD3_LEN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD3_LEN_MASK) | (((uint32_t)val) << PDMA_DMA_CMD3_LEN_SHIFT))

//====================================================================
//Register: DMA Command Registers 0-15 (Instance 5 of 16) (DMA_CMD4)
/** \brief These read-only registers are for descriptor-fetch transfers and read/write
for no-descriptor-fetch transfers.
<br>
These are read/write registers. Ignore reads from reserved bits. Write 0x0
to reserved bits. (Instance 5 of 16)*/
//====================================================================

#define  PDMA_DMA_CMD4_INCSRCADDR_MASK 0x80000000
#define  PDMA_DMA_CMD4_INCSRCADDR_SHIFT 31
#define  PDMA_DMA_CMD4_INCSRCADDR_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD4_INCSRCADDR_MASK) >> PDMA_DMA_CMD4_INCSRCADDR_SHIFT)
#define  PDMA_DMA_CMD4_INCSRCADDR_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD4_INCSRCADDR_MASK) | (((uint32_t)val) << PDMA_DMA_CMD4_INCSRCADDR_SHIFT))

#define  PDMA_DMA_CMD4_INCTRGADDR_MASK 0x40000000
#define  PDMA_DMA_CMD4_INCTRGADDR_SHIFT 30
#define  PDMA_DMA_CMD4_INCTRGADDR_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD4_INCTRGADDR_MASK) >> PDMA_DMA_CMD4_INCTRGADDR_SHIFT)
#define  PDMA_DMA_CMD4_INCTRGADDR_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD4_INCTRGADDR_MASK) | (((uint32_t)val) << PDMA_DMA_CMD4_INCTRGADDR_SHIFT))

#define  PDMA_DMA_CMD4_FLOWSRC_MASK 0x20000000
#define  PDMA_DMA_CMD4_FLOWSRC_SHIFT 29
#define  PDMA_DMA_CMD4_FLOWSRC_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD4_FLOWSRC_MASK) >> PDMA_DMA_CMD4_FLOWSRC_SHIFT)
#define  PDMA_DMA_CMD4_FLOWSRC_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD4_FLOWSRC_MASK) | (((uint32_t)val) << PDMA_DMA_CMD4_FLOWSRC_SHIFT))

#define  PDMA_DMA_CMD4_FLOWTRG_MASK 0x10000000
#define  PDMA_DMA_CMD4_FLOWTRG_SHIFT 28
#define  PDMA_DMA_CMD4_FLOWTRG_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD4_FLOWTRG_MASK) >> PDMA_DMA_CMD4_FLOWTRG_SHIFT)
#define  PDMA_DMA_CMD4_FLOWTRG_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD4_FLOWTRG_MASK) | (((uint32_t)val) << PDMA_DMA_CMD4_FLOWTRG_SHIFT))

#define  PDMA_DMA_CMD4_RESERVED1_MASK 0xc000000
#define  PDMA_DMA_CMD4_RESERVED1_SHIFT 26
#define  PDMA_DMA_CMD4_RESERVED1_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD4_RESERVED1_MASK) >> PDMA_DMA_CMD4_RESERVED1_SHIFT)
#define  PDMA_DMA_CMD4_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD4_RESERVED1_MASK) | (((uint32_t)val) << PDMA_DMA_CMD4_RESERVED1_SHIFT))

#define  PDMA_DMA_CMD4_CMPEN_MASK 0x2000000
#define  PDMA_DMA_CMD4_CMPEN_SHIFT 25
#define  PDMA_DMA_CMD4_CMPEN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD4_CMPEN_MASK) >> PDMA_DMA_CMD4_CMPEN_SHIFT)
#define  PDMA_DMA_CMD4_CMPEN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD4_CMPEN_MASK) | (((uint32_t)val) << PDMA_DMA_CMD4_CMPEN_SHIFT))

#define  PDMA_DMA_CMD4_RESERVED2_MASK 0x1000000
#define  PDMA_DMA_CMD4_RESERVED2_SHIFT 24
#define  PDMA_DMA_CMD4_RESERVED2_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD4_RESERVED2_MASK) >> PDMA_DMA_CMD4_RESERVED2_SHIFT)
#define  PDMA_DMA_CMD4_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD4_RESERVED2_MASK) | (((uint32_t)val) << PDMA_DMA_CMD4_RESERVED2_SHIFT))

#define  PDMA_DMA_CMD4_ADDRMODE_MASK 0x800000
#define  PDMA_DMA_CMD4_ADDRMODE_SHIFT 23
#define  PDMA_DMA_CMD4_ADDRMODE_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD4_ADDRMODE_MASK) >> PDMA_DMA_CMD4_ADDRMODE_SHIFT)
#define  PDMA_DMA_CMD4_ADDRMODE_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD4_ADDRMODE_MASK) | (((uint32_t)val) << PDMA_DMA_CMD4_ADDRMODE_SHIFT))

#define  PDMA_DMA_CMD4_STARTIRQEN_MASK 0x400000
#define  PDMA_DMA_CMD4_STARTIRQEN_SHIFT 22
#define  PDMA_DMA_CMD4_STARTIRQEN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD4_STARTIRQEN_MASK) >> PDMA_DMA_CMD4_STARTIRQEN_SHIFT)
#define  PDMA_DMA_CMD4_STARTIRQEN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD4_STARTIRQEN_MASK) | (((uint32_t)val) << PDMA_DMA_CMD4_STARTIRQEN_SHIFT))

#define  PDMA_DMA_CMD4_ENDIRQEN_MASK 0x200000
#define  PDMA_DMA_CMD4_ENDIRQEN_SHIFT 21
#define  PDMA_DMA_CMD4_ENDIRQEN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD4_ENDIRQEN_MASK) >> PDMA_DMA_CMD4_ENDIRQEN_SHIFT)
#define  PDMA_DMA_CMD4_ENDIRQEN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD4_ENDIRQEN_MASK) | (((uint32_t)val) << PDMA_DMA_CMD4_ENDIRQEN_SHIFT))

#define  PDMA_DMA_CMD4_RESERVED3_MASK 0x180000
#define  PDMA_DMA_CMD4_RESERVED3_SHIFT 19
#define  PDMA_DMA_CMD4_RESERVED3_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD4_RESERVED3_MASK) >> PDMA_DMA_CMD4_RESERVED3_SHIFT)
#define  PDMA_DMA_CMD4_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD4_RESERVED3_MASK) | (((uint32_t)val) << PDMA_DMA_CMD4_RESERVED3_SHIFT))

#define  PDMA_DMA_CMD4_SIZE_MASK 0x70000
#define  PDMA_DMA_CMD4_SIZE_SHIFT 16
#define  PDMA_DMA_CMD4_SIZE_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD4_SIZE_MASK) >> PDMA_DMA_CMD4_SIZE_SHIFT)
#define  PDMA_DMA_CMD4_SIZE_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD4_SIZE_MASK) | (((uint32_t)val) << PDMA_DMA_CMD4_SIZE_SHIFT))

#define  PDMA_DMA_CMD4_WIDTH_MASK 0xc000
#define  PDMA_DMA_CMD4_WIDTH_SHIFT 14
#define  PDMA_DMA_CMD4_WIDTH_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD4_WIDTH_MASK) >> PDMA_DMA_CMD4_WIDTH_SHIFT)
#define  PDMA_DMA_CMD4_WIDTH_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD4_WIDTH_MASK) | (((uint32_t)val) << PDMA_DMA_CMD4_WIDTH_SHIFT))

#define  PDMA_DMA_CMD4_RESERVED4_MASK 0x2000
#define  PDMA_DMA_CMD4_RESERVED4_SHIFT 13
#define  PDMA_DMA_CMD4_RESERVED4_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD4_RESERVED4_MASK) >> PDMA_DMA_CMD4_RESERVED4_SHIFT)
#define  PDMA_DMA_CMD4_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD4_RESERVED4_MASK) | (((uint32_t)val) << PDMA_DMA_CMD4_RESERVED4_SHIFT))

#define  PDMA_DMA_CMD4_LEN_MASK 0x1fff
#define  PDMA_DMA_CMD4_LEN_SHIFT 0
#define  PDMA_DMA_CMD4_LEN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD4_LEN_MASK) >> PDMA_DMA_CMD4_LEN_SHIFT)
#define  PDMA_DMA_CMD4_LEN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD4_LEN_MASK) | (((uint32_t)val) << PDMA_DMA_CMD4_LEN_SHIFT))

//====================================================================
//Register: DMA Command Registers 0-15 (Instance 6 of 16) (DMA_CMD5)
/** \brief These read-only registers are for descriptor-fetch transfers and read/write
for no-descriptor-fetch transfers.
<br>
These are read/write registers. Ignore reads from reserved bits. Write 0x0
to reserved bits. (Instance 6 of 16)*/
//====================================================================

#define  PDMA_DMA_CMD5_INCSRCADDR_MASK 0x80000000
#define  PDMA_DMA_CMD5_INCSRCADDR_SHIFT 31
#define  PDMA_DMA_CMD5_INCSRCADDR_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD5_INCSRCADDR_MASK) >> PDMA_DMA_CMD5_INCSRCADDR_SHIFT)
#define  PDMA_DMA_CMD5_INCSRCADDR_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD5_INCSRCADDR_MASK) | (((uint32_t)val) << PDMA_DMA_CMD5_INCSRCADDR_SHIFT))

#define  PDMA_DMA_CMD5_INCTRGADDR_MASK 0x40000000
#define  PDMA_DMA_CMD5_INCTRGADDR_SHIFT 30
#define  PDMA_DMA_CMD5_INCTRGADDR_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD5_INCTRGADDR_MASK) >> PDMA_DMA_CMD5_INCTRGADDR_SHIFT)
#define  PDMA_DMA_CMD5_INCTRGADDR_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD5_INCTRGADDR_MASK) | (((uint32_t)val) << PDMA_DMA_CMD5_INCTRGADDR_SHIFT))

#define  PDMA_DMA_CMD5_FLOWSRC_MASK 0x20000000
#define  PDMA_DMA_CMD5_FLOWSRC_SHIFT 29
#define  PDMA_DMA_CMD5_FLOWSRC_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD5_FLOWSRC_MASK) >> PDMA_DMA_CMD5_FLOWSRC_SHIFT)
#define  PDMA_DMA_CMD5_FLOWSRC_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD5_FLOWSRC_MASK) | (((uint32_t)val) << PDMA_DMA_CMD5_FLOWSRC_SHIFT))

#define  PDMA_DMA_CMD5_FLOWTRG_MASK 0x10000000
#define  PDMA_DMA_CMD5_FLOWTRG_SHIFT 28
#define  PDMA_DMA_CMD5_FLOWTRG_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD5_FLOWTRG_MASK) >> PDMA_DMA_CMD5_FLOWTRG_SHIFT)
#define  PDMA_DMA_CMD5_FLOWTRG_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD5_FLOWTRG_MASK) | (((uint32_t)val) << PDMA_DMA_CMD5_FLOWTRG_SHIFT))

#define  PDMA_DMA_CMD5_RESERVED1_MASK 0xc000000
#define  PDMA_DMA_CMD5_RESERVED1_SHIFT 26
#define  PDMA_DMA_CMD5_RESERVED1_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD5_RESERVED1_MASK) >> PDMA_DMA_CMD5_RESERVED1_SHIFT)
#define  PDMA_DMA_CMD5_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD5_RESERVED1_MASK) | (((uint32_t)val) << PDMA_DMA_CMD5_RESERVED1_SHIFT))

#define  PDMA_DMA_CMD5_CMPEN_MASK 0x2000000
#define  PDMA_DMA_CMD5_CMPEN_SHIFT 25
#define  PDMA_DMA_CMD5_CMPEN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD5_CMPEN_MASK) >> PDMA_DMA_CMD5_CMPEN_SHIFT)
#define  PDMA_DMA_CMD5_CMPEN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD5_CMPEN_MASK) | (((uint32_t)val) << PDMA_DMA_CMD5_CMPEN_SHIFT))

#define  PDMA_DMA_CMD5_RESERVED2_MASK 0x1000000
#define  PDMA_DMA_CMD5_RESERVED2_SHIFT 24
#define  PDMA_DMA_CMD5_RESERVED2_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD5_RESERVED2_MASK) >> PDMA_DMA_CMD5_RESERVED2_SHIFT)
#define  PDMA_DMA_CMD5_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD5_RESERVED2_MASK) | (((uint32_t)val) << PDMA_DMA_CMD5_RESERVED2_SHIFT))

#define  PDMA_DMA_CMD5_ADDRMODE_MASK 0x800000
#define  PDMA_DMA_CMD5_ADDRMODE_SHIFT 23
#define  PDMA_DMA_CMD5_ADDRMODE_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD5_ADDRMODE_MASK) >> PDMA_DMA_CMD5_ADDRMODE_SHIFT)
#define  PDMA_DMA_CMD5_ADDRMODE_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD5_ADDRMODE_MASK) | (((uint32_t)val) << PDMA_DMA_CMD5_ADDRMODE_SHIFT))

#define  PDMA_DMA_CMD5_STARTIRQEN_MASK 0x400000
#define  PDMA_DMA_CMD5_STARTIRQEN_SHIFT 22
#define  PDMA_DMA_CMD5_STARTIRQEN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD5_STARTIRQEN_MASK) >> PDMA_DMA_CMD5_STARTIRQEN_SHIFT)
#define  PDMA_DMA_CMD5_STARTIRQEN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD5_STARTIRQEN_MASK) | (((uint32_t)val) << PDMA_DMA_CMD5_STARTIRQEN_SHIFT))

#define  PDMA_DMA_CMD5_ENDIRQEN_MASK 0x200000
#define  PDMA_DMA_CMD5_ENDIRQEN_SHIFT 21
#define  PDMA_DMA_CMD5_ENDIRQEN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD5_ENDIRQEN_MASK) >> PDMA_DMA_CMD5_ENDIRQEN_SHIFT)
#define  PDMA_DMA_CMD5_ENDIRQEN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD5_ENDIRQEN_MASK) | (((uint32_t)val) << PDMA_DMA_CMD5_ENDIRQEN_SHIFT))

#define  PDMA_DMA_CMD5_RESERVED3_MASK 0x180000
#define  PDMA_DMA_CMD5_RESERVED3_SHIFT 19
#define  PDMA_DMA_CMD5_RESERVED3_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD5_RESERVED3_MASK) >> PDMA_DMA_CMD5_RESERVED3_SHIFT)
#define  PDMA_DMA_CMD5_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD5_RESERVED3_MASK) | (((uint32_t)val) << PDMA_DMA_CMD5_RESERVED3_SHIFT))

#define  PDMA_DMA_CMD5_SIZE_MASK 0x70000
#define  PDMA_DMA_CMD5_SIZE_SHIFT 16
#define  PDMA_DMA_CMD5_SIZE_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD5_SIZE_MASK) >> PDMA_DMA_CMD5_SIZE_SHIFT)
#define  PDMA_DMA_CMD5_SIZE_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD5_SIZE_MASK) | (((uint32_t)val) << PDMA_DMA_CMD5_SIZE_SHIFT))

#define  PDMA_DMA_CMD5_WIDTH_MASK 0xc000
#define  PDMA_DMA_CMD5_WIDTH_SHIFT 14
#define  PDMA_DMA_CMD5_WIDTH_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD5_WIDTH_MASK) >> PDMA_DMA_CMD5_WIDTH_SHIFT)
#define  PDMA_DMA_CMD5_WIDTH_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD5_WIDTH_MASK) | (((uint32_t)val) << PDMA_DMA_CMD5_WIDTH_SHIFT))

#define  PDMA_DMA_CMD5_RESERVED4_MASK 0x2000
#define  PDMA_DMA_CMD5_RESERVED4_SHIFT 13
#define  PDMA_DMA_CMD5_RESERVED4_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD5_RESERVED4_MASK) >> PDMA_DMA_CMD5_RESERVED4_SHIFT)
#define  PDMA_DMA_CMD5_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD5_RESERVED4_MASK) | (((uint32_t)val) << PDMA_DMA_CMD5_RESERVED4_SHIFT))

#define  PDMA_DMA_CMD5_LEN_MASK 0x1fff
#define  PDMA_DMA_CMD5_LEN_SHIFT 0
#define  PDMA_DMA_CMD5_LEN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD5_LEN_MASK) >> PDMA_DMA_CMD5_LEN_SHIFT)
#define  PDMA_DMA_CMD5_LEN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD5_LEN_MASK) | (((uint32_t)val) << PDMA_DMA_CMD5_LEN_SHIFT))

//====================================================================
//Register: DMA Command Registers 0-15 (Instance 7 of 16) (DMA_CMD6)
/** \brief These read-only registers are for descriptor-fetch transfers and read/write
for no-descriptor-fetch transfers.
<br>
These are read/write registers. Ignore reads from reserved bits. Write 0x0
to reserved bits. (Instance 7 of 16)*/
//====================================================================

#define  PDMA_DMA_CMD6_INCSRCADDR_MASK 0x80000000
#define  PDMA_DMA_CMD6_INCSRCADDR_SHIFT 31
#define  PDMA_DMA_CMD6_INCSRCADDR_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD6_INCSRCADDR_MASK) >> PDMA_DMA_CMD6_INCSRCADDR_SHIFT)
#define  PDMA_DMA_CMD6_INCSRCADDR_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD6_INCSRCADDR_MASK) | (((uint32_t)val) << PDMA_DMA_CMD6_INCSRCADDR_SHIFT))

#define  PDMA_DMA_CMD6_INCTRGADDR_MASK 0x40000000
#define  PDMA_DMA_CMD6_INCTRGADDR_SHIFT 30
#define  PDMA_DMA_CMD6_INCTRGADDR_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD6_INCTRGADDR_MASK) >> PDMA_DMA_CMD6_INCTRGADDR_SHIFT)
#define  PDMA_DMA_CMD6_INCTRGADDR_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD6_INCTRGADDR_MASK) | (((uint32_t)val) << PDMA_DMA_CMD6_INCTRGADDR_SHIFT))

#define  PDMA_DMA_CMD6_FLOWSRC_MASK 0x20000000
#define  PDMA_DMA_CMD6_FLOWSRC_SHIFT 29
#define  PDMA_DMA_CMD6_FLOWSRC_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD6_FLOWSRC_MASK) >> PDMA_DMA_CMD6_FLOWSRC_SHIFT)
#define  PDMA_DMA_CMD6_FLOWSRC_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD6_FLOWSRC_MASK) | (((uint32_t)val) << PDMA_DMA_CMD6_FLOWSRC_SHIFT))

#define  PDMA_DMA_CMD6_FLOWTRG_MASK 0x10000000
#define  PDMA_DMA_CMD6_FLOWTRG_SHIFT 28
#define  PDMA_DMA_CMD6_FLOWTRG_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD6_FLOWTRG_MASK) >> PDMA_DMA_CMD6_FLOWTRG_SHIFT)
#define  PDMA_DMA_CMD6_FLOWTRG_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD6_FLOWTRG_MASK) | (((uint32_t)val) << PDMA_DMA_CMD6_FLOWTRG_SHIFT))

#define  PDMA_DMA_CMD6_RESERVED1_MASK 0xc000000
#define  PDMA_DMA_CMD6_RESERVED1_SHIFT 26
#define  PDMA_DMA_CMD6_RESERVED1_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD6_RESERVED1_MASK) >> PDMA_DMA_CMD6_RESERVED1_SHIFT)
#define  PDMA_DMA_CMD6_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD6_RESERVED1_MASK) | (((uint32_t)val) << PDMA_DMA_CMD6_RESERVED1_SHIFT))

#define  PDMA_DMA_CMD6_CMPEN_MASK 0x2000000
#define  PDMA_DMA_CMD6_CMPEN_SHIFT 25
#define  PDMA_DMA_CMD6_CMPEN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD6_CMPEN_MASK) >> PDMA_DMA_CMD6_CMPEN_SHIFT)
#define  PDMA_DMA_CMD6_CMPEN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD6_CMPEN_MASK) | (((uint32_t)val) << PDMA_DMA_CMD6_CMPEN_SHIFT))

#define  PDMA_DMA_CMD6_RESERVED2_MASK 0x1000000
#define  PDMA_DMA_CMD6_RESERVED2_SHIFT 24
#define  PDMA_DMA_CMD6_RESERVED2_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD6_RESERVED2_MASK) >> PDMA_DMA_CMD6_RESERVED2_SHIFT)
#define  PDMA_DMA_CMD6_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD6_RESERVED2_MASK) | (((uint32_t)val) << PDMA_DMA_CMD6_RESERVED2_SHIFT))

#define  PDMA_DMA_CMD6_ADDRMODE_MASK 0x800000
#define  PDMA_DMA_CMD6_ADDRMODE_SHIFT 23
#define  PDMA_DMA_CMD6_ADDRMODE_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD6_ADDRMODE_MASK) >> PDMA_DMA_CMD6_ADDRMODE_SHIFT)
#define  PDMA_DMA_CMD6_ADDRMODE_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD6_ADDRMODE_MASK) | (((uint32_t)val) << PDMA_DMA_CMD6_ADDRMODE_SHIFT))

#define  PDMA_DMA_CMD6_STARTIRQEN_MASK 0x400000
#define  PDMA_DMA_CMD6_STARTIRQEN_SHIFT 22
#define  PDMA_DMA_CMD6_STARTIRQEN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD6_STARTIRQEN_MASK) >> PDMA_DMA_CMD6_STARTIRQEN_SHIFT)
#define  PDMA_DMA_CMD6_STARTIRQEN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD6_STARTIRQEN_MASK) | (((uint32_t)val) << PDMA_DMA_CMD6_STARTIRQEN_SHIFT))

#define  PDMA_DMA_CMD6_ENDIRQEN_MASK 0x200000
#define  PDMA_DMA_CMD6_ENDIRQEN_SHIFT 21
#define  PDMA_DMA_CMD6_ENDIRQEN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD6_ENDIRQEN_MASK) >> PDMA_DMA_CMD6_ENDIRQEN_SHIFT)
#define  PDMA_DMA_CMD6_ENDIRQEN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD6_ENDIRQEN_MASK) | (((uint32_t)val) << PDMA_DMA_CMD6_ENDIRQEN_SHIFT))

#define  PDMA_DMA_CMD6_RESERVED3_MASK 0x180000
#define  PDMA_DMA_CMD6_RESERVED3_SHIFT 19
#define  PDMA_DMA_CMD6_RESERVED3_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD6_RESERVED3_MASK) >> PDMA_DMA_CMD6_RESERVED3_SHIFT)
#define  PDMA_DMA_CMD6_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD6_RESERVED3_MASK) | (((uint32_t)val) << PDMA_DMA_CMD6_RESERVED3_SHIFT))

#define  PDMA_DMA_CMD6_SIZE_MASK 0x70000
#define  PDMA_DMA_CMD6_SIZE_SHIFT 16
#define  PDMA_DMA_CMD6_SIZE_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD6_SIZE_MASK) >> PDMA_DMA_CMD6_SIZE_SHIFT)
#define  PDMA_DMA_CMD6_SIZE_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD6_SIZE_MASK) | (((uint32_t)val) << PDMA_DMA_CMD6_SIZE_SHIFT))

#define  PDMA_DMA_CMD6_WIDTH_MASK 0xc000
#define  PDMA_DMA_CMD6_WIDTH_SHIFT 14
#define  PDMA_DMA_CMD6_WIDTH_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD6_WIDTH_MASK) >> PDMA_DMA_CMD6_WIDTH_SHIFT)
#define  PDMA_DMA_CMD6_WIDTH_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD6_WIDTH_MASK) | (((uint32_t)val) << PDMA_DMA_CMD6_WIDTH_SHIFT))

#define  PDMA_DMA_CMD6_RESERVED4_MASK 0x2000
#define  PDMA_DMA_CMD6_RESERVED4_SHIFT 13
#define  PDMA_DMA_CMD6_RESERVED4_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD6_RESERVED4_MASK) >> PDMA_DMA_CMD6_RESERVED4_SHIFT)
#define  PDMA_DMA_CMD6_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD6_RESERVED4_MASK) | (((uint32_t)val) << PDMA_DMA_CMD6_RESERVED4_SHIFT))

#define  PDMA_DMA_CMD6_LEN_MASK 0x1fff
#define  PDMA_DMA_CMD6_LEN_SHIFT 0
#define  PDMA_DMA_CMD6_LEN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD6_LEN_MASK) >> PDMA_DMA_CMD6_LEN_SHIFT)
#define  PDMA_DMA_CMD6_LEN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD6_LEN_MASK) | (((uint32_t)val) << PDMA_DMA_CMD6_LEN_SHIFT))

//====================================================================
//Register: DMA Command Registers 0-15 (Instance 8 of 16) (DMA_CMD7)
/** \brief These read-only registers are for descriptor-fetch transfers and read/write
for no-descriptor-fetch transfers.
<br>
These are read/write registers. Ignore reads from reserved bits. Write 0x0
to reserved bits. (Instance 8 of 16)*/
//====================================================================

#define  PDMA_DMA_CMD7_INCSRCADDR_MASK 0x80000000
#define  PDMA_DMA_CMD7_INCSRCADDR_SHIFT 31
#define  PDMA_DMA_CMD7_INCSRCADDR_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD7_INCSRCADDR_MASK) >> PDMA_DMA_CMD7_INCSRCADDR_SHIFT)
#define  PDMA_DMA_CMD7_INCSRCADDR_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD7_INCSRCADDR_MASK) | (((uint32_t)val) << PDMA_DMA_CMD7_INCSRCADDR_SHIFT))

#define  PDMA_DMA_CMD7_INCTRGADDR_MASK 0x40000000
#define  PDMA_DMA_CMD7_INCTRGADDR_SHIFT 30
#define  PDMA_DMA_CMD7_INCTRGADDR_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD7_INCTRGADDR_MASK) >> PDMA_DMA_CMD7_INCTRGADDR_SHIFT)
#define  PDMA_DMA_CMD7_INCTRGADDR_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD7_INCTRGADDR_MASK) | (((uint32_t)val) << PDMA_DMA_CMD7_INCTRGADDR_SHIFT))

#define  PDMA_DMA_CMD7_FLOWSRC_MASK 0x20000000
#define  PDMA_DMA_CMD7_FLOWSRC_SHIFT 29
#define  PDMA_DMA_CMD7_FLOWSRC_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD7_FLOWSRC_MASK) >> PDMA_DMA_CMD7_FLOWSRC_SHIFT)
#define  PDMA_DMA_CMD7_FLOWSRC_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD7_FLOWSRC_MASK) | (((uint32_t)val) << PDMA_DMA_CMD7_FLOWSRC_SHIFT))

#define  PDMA_DMA_CMD7_FLOWTRG_MASK 0x10000000
#define  PDMA_DMA_CMD7_FLOWTRG_SHIFT 28
#define  PDMA_DMA_CMD7_FLOWTRG_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD7_FLOWTRG_MASK) >> PDMA_DMA_CMD7_FLOWTRG_SHIFT)
#define  PDMA_DMA_CMD7_FLOWTRG_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD7_FLOWTRG_MASK) | (((uint32_t)val) << PDMA_DMA_CMD7_FLOWTRG_SHIFT))

#define  PDMA_DMA_CMD7_RESERVED1_MASK 0xc000000
#define  PDMA_DMA_CMD7_RESERVED1_SHIFT 26
#define  PDMA_DMA_CMD7_RESERVED1_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD7_RESERVED1_MASK) >> PDMA_DMA_CMD7_RESERVED1_SHIFT)
#define  PDMA_DMA_CMD7_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD7_RESERVED1_MASK) | (((uint32_t)val) << PDMA_DMA_CMD7_RESERVED1_SHIFT))

#define  PDMA_DMA_CMD7_CMPEN_MASK 0x2000000
#define  PDMA_DMA_CMD7_CMPEN_SHIFT 25
#define  PDMA_DMA_CMD7_CMPEN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD7_CMPEN_MASK) >> PDMA_DMA_CMD7_CMPEN_SHIFT)
#define  PDMA_DMA_CMD7_CMPEN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD7_CMPEN_MASK) | (((uint32_t)val) << PDMA_DMA_CMD7_CMPEN_SHIFT))

#define  PDMA_DMA_CMD7_RESERVED2_MASK 0x1000000
#define  PDMA_DMA_CMD7_RESERVED2_SHIFT 24
#define  PDMA_DMA_CMD7_RESERVED2_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD7_RESERVED2_MASK) >> PDMA_DMA_CMD7_RESERVED2_SHIFT)
#define  PDMA_DMA_CMD7_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD7_RESERVED2_MASK) | (((uint32_t)val) << PDMA_DMA_CMD7_RESERVED2_SHIFT))

#define  PDMA_DMA_CMD7_ADDRMODE_MASK 0x800000
#define  PDMA_DMA_CMD7_ADDRMODE_SHIFT 23
#define  PDMA_DMA_CMD7_ADDRMODE_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD7_ADDRMODE_MASK) >> PDMA_DMA_CMD7_ADDRMODE_SHIFT)
#define  PDMA_DMA_CMD7_ADDRMODE_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD7_ADDRMODE_MASK) | (((uint32_t)val) << PDMA_DMA_CMD7_ADDRMODE_SHIFT))

#define  PDMA_DMA_CMD7_STARTIRQEN_MASK 0x400000
#define  PDMA_DMA_CMD7_STARTIRQEN_SHIFT 22
#define  PDMA_DMA_CMD7_STARTIRQEN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD7_STARTIRQEN_MASK) >> PDMA_DMA_CMD7_STARTIRQEN_SHIFT)
#define  PDMA_DMA_CMD7_STARTIRQEN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD7_STARTIRQEN_MASK) | (((uint32_t)val) << PDMA_DMA_CMD7_STARTIRQEN_SHIFT))

#define  PDMA_DMA_CMD7_ENDIRQEN_MASK 0x200000
#define  PDMA_DMA_CMD7_ENDIRQEN_SHIFT 21
#define  PDMA_DMA_CMD7_ENDIRQEN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD7_ENDIRQEN_MASK) >> PDMA_DMA_CMD7_ENDIRQEN_SHIFT)
#define  PDMA_DMA_CMD7_ENDIRQEN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD7_ENDIRQEN_MASK) | (((uint32_t)val) << PDMA_DMA_CMD7_ENDIRQEN_SHIFT))

#define  PDMA_DMA_CMD7_RESERVED3_MASK 0x180000
#define  PDMA_DMA_CMD7_RESERVED3_SHIFT 19
#define  PDMA_DMA_CMD7_RESERVED3_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD7_RESERVED3_MASK) >> PDMA_DMA_CMD7_RESERVED3_SHIFT)
#define  PDMA_DMA_CMD7_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD7_RESERVED3_MASK) | (((uint32_t)val) << PDMA_DMA_CMD7_RESERVED3_SHIFT))

#define  PDMA_DMA_CMD7_SIZE_MASK 0x70000
#define  PDMA_DMA_CMD7_SIZE_SHIFT 16
#define  PDMA_DMA_CMD7_SIZE_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD7_SIZE_MASK) >> PDMA_DMA_CMD7_SIZE_SHIFT)
#define  PDMA_DMA_CMD7_SIZE_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD7_SIZE_MASK) | (((uint32_t)val) << PDMA_DMA_CMD7_SIZE_SHIFT))

#define  PDMA_DMA_CMD7_WIDTH_MASK 0xc000
#define  PDMA_DMA_CMD7_WIDTH_SHIFT 14
#define  PDMA_DMA_CMD7_WIDTH_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD7_WIDTH_MASK) >> PDMA_DMA_CMD7_WIDTH_SHIFT)
#define  PDMA_DMA_CMD7_WIDTH_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD7_WIDTH_MASK) | (((uint32_t)val) << PDMA_DMA_CMD7_WIDTH_SHIFT))

#define  PDMA_DMA_CMD7_RESERVED4_MASK 0x2000
#define  PDMA_DMA_CMD7_RESERVED4_SHIFT 13
#define  PDMA_DMA_CMD7_RESERVED4_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD7_RESERVED4_MASK) >> PDMA_DMA_CMD7_RESERVED4_SHIFT)
#define  PDMA_DMA_CMD7_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD7_RESERVED4_MASK) | (((uint32_t)val) << PDMA_DMA_CMD7_RESERVED4_SHIFT))

#define  PDMA_DMA_CMD7_LEN_MASK 0x1fff
#define  PDMA_DMA_CMD7_LEN_SHIFT 0
#define  PDMA_DMA_CMD7_LEN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD7_LEN_MASK) >> PDMA_DMA_CMD7_LEN_SHIFT)
#define  PDMA_DMA_CMD7_LEN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD7_LEN_MASK) | (((uint32_t)val) << PDMA_DMA_CMD7_LEN_SHIFT))

//====================================================================
//Register: DMA Command Registers 0-15 (Instance 9 of 16) (DMA_CMD8)
/** \brief These read-only registers are for descriptor-fetch transfers and read/write
for no-descriptor-fetch transfers.
<br>
These are read/write registers. Ignore reads from reserved bits. Write 0x0
to reserved bits. (Instance 9 of 16)*/
//====================================================================

#define  PDMA_DMA_CMD8_INCSRCADDR_MASK 0x80000000
#define  PDMA_DMA_CMD8_INCSRCADDR_SHIFT 31
#define  PDMA_DMA_CMD8_INCSRCADDR_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD8_INCSRCADDR_MASK) >> PDMA_DMA_CMD8_INCSRCADDR_SHIFT)
#define  PDMA_DMA_CMD8_INCSRCADDR_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD8_INCSRCADDR_MASK) | (((uint32_t)val) << PDMA_DMA_CMD8_INCSRCADDR_SHIFT))

#define  PDMA_DMA_CMD8_INCTRGADDR_MASK 0x40000000
#define  PDMA_DMA_CMD8_INCTRGADDR_SHIFT 30
#define  PDMA_DMA_CMD8_INCTRGADDR_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD8_INCTRGADDR_MASK) >> PDMA_DMA_CMD8_INCTRGADDR_SHIFT)
#define  PDMA_DMA_CMD8_INCTRGADDR_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD8_INCTRGADDR_MASK) | (((uint32_t)val) << PDMA_DMA_CMD8_INCTRGADDR_SHIFT))

#define  PDMA_DMA_CMD8_FLOWSRC_MASK 0x20000000
#define  PDMA_DMA_CMD8_FLOWSRC_SHIFT 29
#define  PDMA_DMA_CMD8_FLOWSRC_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD8_FLOWSRC_MASK) >> PDMA_DMA_CMD8_FLOWSRC_SHIFT)
#define  PDMA_DMA_CMD8_FLOWSRC_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD8_FLOWSRC_MASK) | (((uint32_t)val) << PDMA_DMA_CMD8_FLOWSRC_SHIFT))

#define  PDMA_DMA_CMD8_FLOWTRG_MASK 0x10000000
#define  PDMA_DMA_CMD8_FLOWTRG_SHIFT 28
#define  PDMA_DMA_CMD8_FLOWTRG_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD8_FLOWTRG_MASK) >> PDMA_DMA_CMD8_FLOWTRG_SHIFT)
#define  PDMA_DMA_CMD8_FLOWTRG_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD8_FLOWTRG_MASK) | (((uint32_t)val) << PDMA_DMA_CMD8_FLOWTRG_SHIFT))

#define  PDMA_DMA_CMD8_RESERVED1_MASK 0xc000000
#define  PDMA_DMA_CMD8_RESERVED1_SHIFT 26
#define  PDMA_DMA_CMD8_RESERVED1_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD8_RESERVED1_MASK) >> PDMA_DMA_CMD8_RESERVED1_SHIFT)
#define  PDMA_DMA_CMD8_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD8_RESERVED1_MASK) | (((uint32_t)val) << PDMA_DMA_CMD8_RESERVED1_SHIFT))

#define  PDMA_DMA_CMD8_CMPEN_MASK 0x2000000
#define  PDMA_DMA_CMD8_CMPEN_SHIFT 25
#define  PDMA_DMA_CMD8_CMPEN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD8_CMPEN_MASK) >> PDMA_DMA_CMD8_CMPEN_SHIFT)
#define  PDMA_DMA_CMD8_CMPEN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD8_CMPEN_MASK) | (((uint32_t)val) << PDMA_DMA_CMD8_CMPEN_SHIFT))

#define  PDMA_DMA_CMD8_RESERVED2_MASK 0x1000000
#define  PDMA_DMA_CMD8_RESERVED2_SHIFT 24
#define  PDMA_DMA_CMD8_RESERVED2_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD8_RESERVED2_MASK) >> PDMA_DMA_CMD8_RESERVED2_SHIFT)
#define  PDMA_DMA_CMD8_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD8_RESERVED2_MASK) | (((uint32_t)val) << PDMA_DMA_CMD8_RESERVED2_SHIFT))

#define  PDMA_DMA_CMD8_ADDRMODE_MASK 0x800000
#define  PDMA_DMA_CMD8_ADDRMODE_SHIFT 23
#define  PDMA_DMA_CMD8_ADDRMODE_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD8_ADDRMODE_MASK) >> PDMA_DMA_CMD8_ADDRMODE_SHIFT)
#define  PDMA_DMA_CMD8_ADDRMODE_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD8_ADDRMODE_MASK) | (((uint32_t)val) << PDMA_DMA_CMD8_ADDRMODE_SHIFT))

#define  PDMA_DMA_CMD8_STARTIRQEN_MASK 0x400000
#define  PDMA_DMA_CMD8_STARTIRQEN_SHIFT 22
#define  PDMA_DMA_CMD8_STARTIRQEN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD8_STARTIRQEN_MASK) >> PDMA_DMA_CMD8_STARTIRQEN_SHIFT)
#define  PDMA_DMA_CMD8_STARTIRQEN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD8_STARTIRQEN_MASK) | (((uint32_t)val) << PDMA_DMA_CMD8_STARTIRQEN_SHIFT))

#define  PDMA_DMA_CMD8_ENDIRQEN_MASK 0x200000
#define  PDMA_DMA_CMD8_ENDIRQEN_SHIFT 21
#define  PDMA_DMA_CMD8_ENDIRQEN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD8_ENDIRQEN_MASK) >> PDMA_DMA_CMD8_ENDIRQEN_SHIFT)
#define  PDMA_DMA_CMD8_ENDIRQEN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD8_ENDIRQEN_MASK) | (((uint32_t)val) << PDMA_DMA_CMD8_ENDIRQEN_SHIFT))

#define  PDMA_DMA_CMD8_RESERVED3_MASK 0x180000
#define  PDMA_DMA_CMD8_RESERVED3_SHIFT 19
#define  PDMA_DMA_CMD8_RESERVED3_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD8_RESERVED3_MASK) >> PDMA_DMA_CMD8_RESERVED3_SHIFT)
#define  PDMA_DMA_CMD8_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD8_RESERVED3_MASK) | (((uint32_t)val) << PDMA_DMA_CMD8_RESERVED3_SHIFT))

#define  PDMA_DMA_CMD8_SIZE_MASK 0x70000
#define  PDMA_DMA_CMD8_SIZE_SHIFT 16
#define  PDMA_DMA_CMD8_SIZE_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD8_SIZE_MASK) >> PDMA_DMA_CMD8_SIZE_SHIFT)
#define  PDMA_DMA_CMD8_SIZE_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD8_SIZE_MASK) | (((uint32_t)val) << PDMA_DMA_CMD8_SIZE_SHIFT))

#define  PDMA_DMA_CMD8_WIDTH_MASK 0xc000
#define  PDMA_DMA_CMD8_WIDTH_SHIFT 14
#define  PDMA_DMA_CMD8_WIDTH_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD8_WIDTH_MASK) >> PDMA_DMA_CMD8_WIDTH_SHIFT)
#define  PDMA_DMA_CMD8_WIDTH_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD8_WIDTH_MASK) | (((uint32_t)val) << PDMA_DMA_CMD8_WIDTH_SHIFT))

#define  PDMA_DMA_CMD8_RESERVED4_MASK 0x2000
#define  PDMA_DMA_CMD8_RESERVED4_SHIFT 13
#define  PDMA_DMA_CMD8_RESERVED4_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD8_RESERVED4_MASK) >> PDMA_DMA_CMD8_RESERVED4_SHIFT)
#define  PDMA_DMA_CMD8_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD8_RESERVED4_MASK) | (((uint32_t)val) << PDMA_DMA_CMD8_RESERVED4_SHIFT))

#define  PDMA_DMA_CMD8_LEN_MASK 0x1fff
#define  PDMA_DMA_CMD8_LEN_SHIFT 0
#define  PDMA_DMA_CMD8_LEN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD8_LEN_MASK) >> PDMA_DMA_CMD8_LEN_SHIFT)
#define  PDMA_DMA_CMD8_LEN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD8_LEN_MASK) | (((uint32_t)val) << PDMA_DMA_CMD8_LEN_SHIFT))

//====================================================================
//Register: DMA Command Registers 0-15 (Instance 10 of 16) (DMA_CMD9)
/** \brief These read-only registers are for descriptor-fetch transfers and read/write
for no-descriptor-fetch transfers.
<br>
These are read/write registers. Ignore reads from reserved bits. Write 0x0
to reserved bits. (Instance 10 of 16)*/
//====================================================================

#define  PDMA_DMA_CMD9_INCSRCADDR_MASK 0x80000000
#define  PDMA_DMA_CMD9_INCSRCADDR_SHIFT 31
#define  PDMA_DMA_CMD9_INCSRCADDR_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD9_INCSRCADDR_MASK) >> PDMA_DMA_CMD9_INCSRCADDR_SHIFT)
#define  PDMA_DMA_CMD9_INCSRCADDR_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD9_INCSRCADDR_MASK) | (((uint32_t)val) << PDMA_DMA_CMD9_INCSRCADDR_SHIFT))

#define  PDMA_DMA_CMD9_INCTRGADDR_MASK 0x40000000
#define  PDMA_DMA_CMD9_INCTRGADDR_SHIFT 30
#define  PDMA_DMA_CMD9_INCTRGADDR_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD9_INCTRGADDR_MASK) >> PDMA_DMA_CMD9_INCTRGADDR_SHIFT)
#define  PDMA_DMA_CMD9_INCTRGADDR_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD9_INCTRGADDR_MASK) | (((uint32_t)val) << PDMA_DMA_CMD9_INCTRGADDR_SHIFT))

#define  PDMA_DMA_CMD9_FLOWSRC_MASK 0x20000000
#define  PDMA_DMA_CMD9_FLOWSRC_SHIFT 29
#define  PDMA_DMA_CMD9_FLOWSRC_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD9_FLOWSRC_MASK) >> PDMA_DMA_CMD9_FLOWSRC_SHIFT)
#define  PDMA_DMA_CMD9_FLOWSRC_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD9_FLOWSRC_MASK) | (((uint32_t)val) << PDMA_DMA_CMD9_FLOWSRC_SHIFT))

#define  PDMA_DMA_CMD9_FLOWTRG_MASK 0x10000000
#define  PDMA_DMA_CMD9_FLOWTRG_SHIFT 28
#define  PDMA_DMA_CMD9_FLOWTRG_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD9_FLOWTRG_MASK) >> PDMA_DMA_CMD9_FLOWTRG_SHIFT)
#define  PDMA_DMA_CMD9_FLOWTRG_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD9_FLOWTRG_MASK) | (((uint32_t)val) << PDMA_DMA_CMD9_FLOWTRG_SHIFT))

#define  PDMA_DMA_CMD9_RESERVED1_MASK 0xc000000
#define  PDMA_DMA_CMD9_RESERVED1_SHIFT 26
#define  PDMA_DMA_CMD9_RESERVED1_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD9_RESERVED1_MASK) >> PDMA_DMA_CMD9_RESERVED1_SHIFT)
#define  PDMA_DMA_CMD9_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD9_RESERVED1_MASK) | (((uint32_t)val) << PDMA_DMA_CMD9_RESERVED1_SHIFT))

#define  PDMA_DMA_CMD9_CMPEN_MASK 0x2000000
#define  PDMA_DMA_CMD9_CMPEN_SHIFT 25
#define  PDMA_DMA_CMD9_CMPEN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD9_CMPEN_MASK) >> PDMA_DMA_CMD9_CMPEN_SHIFT)
#define  PDMA_DMA_CMD9_CMPEN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD9_CMPEN_MASK) | (((uint32_t)val) << PDMA_DMA_CMD9_CMPEN_SHIFT))

#define  PDMA_DMA_CMD9_RESERVED2_MASK 0x1000000
#define  PDMA_DMA_CMD9_RESERVED2_SHIFT 24
#define  PDMA_DMA_CMD9_RESERVED2_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD9_RESERVED2_MASK) >> PDMA_DMA_CMD9_RESERVED2_SHIFT)
#define  PDMA_DMA_CMD9_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD9_RESERVED2_MASK) | (((uint32_t)val) << PDMA_DMA_CMD9_RESERVED2_SHIFT))

#define  PDMA_DMA_CMD9_ADDRMODE_MASK 0x800000
#define  PDMA_DMA_CMD9_ADDRMODE_SHIFT 23
#define  PDMA_DMA_CMD9_ADDRMODE_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD9_ADDRMODE_MASK) >> PDMA_DMA_CMD9_ADDRMODE_SHIFT)
#define  PDMA_DMA_CMD9_ADDRMODE_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD9_ADDRMODE_MASK) | (((uint32_t)val) << PDMA_DMA_CMD9_ADDRMODE_SHIFT))

#define  PDMA_DMA_CMD9_STARTIRQEN_MASK 0x400000
#define  PDMA_DMA_CMD9_STARTIRQEN_SHIFT 22
#define  PDMA_DMA_CMD9_STARTIRQEN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD9_STARTIRQEN_MASK) >> PDMA_DMA_CMD9_STARTIRQEN_SHIFT)
#define  PDMA_DMA_CMD9_STARTIRQEN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD9_STARTIRQEN_MASK) | (((uint32_t)val) << PDMA_DMA_CMD9_STARTIRQEN_SHIFT))

#define  PDMA_DMA_CMD9_ENDIRQEN_MASK 0x200000
#define  PDMA_DMA_CMD9_ENDIRQEN_SHIFT 21
#define  PDMA_DMA_CMD9_ENDIRQEN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD9_ENDIRQEN_MASK) >> PDMA_DMA_CMD9_ENDIRQEN_SHIFT)
#define  PDMA_DMA_CMD9_ENDIRQEN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD9_ENDIRQEN_MASK) | (((uint32_t)val) << PDMA_DMA_CMD9_ENDIRQEN_SHIFT))

#define  PDMA_DMA_CMD9_RESERVED3_MASK 0x180000
#define  PDMA_DMA_CMD9_RESERVED3_SHIFT 19
#define  PDMA_DMA_CMD9_RESERVED3_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD9_RESERVED3_MASK) >> PDMA_DMA_CMD9_RESERVED3_SHIFT)
#define  PDMA_DMA_CMD9_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD9_RESERVED3_MASK) | (((uint32_t)val) << PDMA_DMA_CMD9_RESERVED3_SHIFT))

#define  PDMA_DMA_CMD9_SIZE_MASK 0x70000
#define  PDMA_DMA_CMD9_SIZE_SHIFT 16
#define  PDMA_DMA_CMD9_SIZE_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD9_SIZE_MASK) >> PDMA_DMA_CMD9_SIZE_SHIFT)
#define  PDMA_DMA_CMD9_SIZE_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD9_SIZE_MASK) | (((uint32_t)val) << PDMA_DMA_CMD9_SIZE_SHIFT))

#define  PDMA_DMA_CMD9_WIDTH_MASK 0xc000
#define  PDMA_DMA_CMD9_WIDTH_SHIFT 14
#define  PDMA_DMA_CMD9_WIDTH_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD9_WIDTH_MASK) >> PDMA_DMA_CMD9_WIDTH_SHIFT)
#define  PDMA_DMA_CMD9_WIDTH_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD9_WIDTH_MASK) | (((uint32_t)val) << PDMA_DMA_CMD9_WIDTH_SHIFT))

#define  PDMA_DMA_CMD9_RESERVED4_MASK 0x2000
#define  PDMA_DMA_CMD9_RESERVED4_SHIFT 13
#define  PDMA_DMA_CMD9_RESERVED4_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD9_RESERVED4_MASK) >> PDMA_DMA_CMD9_RESERVED4_SHIFT)
#define  PDMA_DMA_CMD9_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD9_RESERVED4_MASK) | (((uint32_t)val) << PDMA_DMA_CMD9_RESERVED4_SHIFT))

#define  PDMA_DMA_CMD9_LEN_MASK 0x1fff
#define  PDMA_DMA_CMD9_LEN_SHIFT 0
#define  PDMA_DMA_CMD9_LEN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD9_LEN_MASK) >> PDMA_DMA_CMD9_LEN_SHIFT)
#define  PDMA_DMA_CMD9_LEN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD9_LEN_MASK) | (((uint32_t)val) << PDMA_DMA_CMD9_LEN_SHIFT))

//====================================================================
//Register: DMA Command Registers 0-15 (Instance 11 of 16) (DMA_CMD10)
/** \brief These read-only registers are for descriptor-fetch transfers and read/write
for no-descriptor-fetch transfers.
<br>
These are read/write registers. Ignore reads from reserved bits. Write 0x0
to reserved bits. (Instance 11 of 16)*/
//====================================================================

#define  PDMA_DMA_CMD10_INCSRCADDR_MASK 0x80000000
#define  PDMA_DMA_CMD10_INCSRCADDR_SHIFT 31
#define  PDMA_DMA_CMD10_INCSRCADDR_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD10_INCSRCADDR_MASK) >> PDMA_DMA_CMD10_INCSRCADDR_SHIFT)
#define  PDMA_DMA_CMD10_INCSRCADDR_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD10_INCSRCADDR_MASK) | (((uint32_t)val) << PDMA_DMA_CMD10_INCSRCADDR_SHIFT))

#define  PDMA_DMA_CMD10_INCTRGADDR_MASK 0x40000000
#define  PDMA_DMA_CMD10_INCTRGADDR_SHIFT 30
#define  PDMA_DMA_CMD10_INCTRGADDR_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD10_INCTRGADDR_MASK) >> PDMA_DMA_CMD10_INCTRGADDR_SHIFT)
#define  PDMA_DMA_CMD10_INCTRGADDR_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD10_INCTRGADDR_MASK) | (((uint32_t)val) << PDMA_DMA_CMD10_INCTRGADDR_SHIFT))

#define  PDMA_DMA_CMD10_FLOWSRC_MASK 0x20000000
#define  PDMA_DMA_CMD10_FLOWSRC_SHIFT 29
#define  PDMA_DMA_CMD10_FLOWSRC_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD10_FLOWSRC_MASK) >> PDMA_DMA_CMD10_FLOWSRC_SHIFT)
#define  PDMA_DMA_CMD10_FLOWSRC_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD10_FLOWSRC_MASK) | (((uint32_t)val) << PDMA_DMA_CMD10_FLOWSRC_SHIFT))

#define  PDMA_DMA_CMD10_FLOWTRG_MASK 0x10000000
#define  PDMA_DMA_CMD10_FLOWTRG_SHIFT 28
#define  PDMA_DMA_CMD10_FLOWTRG_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD10_FLOWTRG_MASK) >> PDMA_DMA_CMD10_FLOWTRG_SHIFT)
#define  PDMA_DMA_CMD10_FLOWTRG_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD10_FLOWTRG_MASK) | (((uint32_t)val) << PDMA_DMA_CMD10_FLOWTRG_SHIFT))

#define  PDMA_DMA_CMD10_RESERVED1_MASK 0xc000000
#define  PDMA_DMA_CMD10_RESERVED1_SHIFT 26
#define  PDMA_DMA_CMD10_RESERVED1_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD10_RESERVED1_MASK) >> PDMA_DMA_CMD10_RESERVED1_SHIFT)
#define  PDMA_DMA_CMD10_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD10_RESERVED1_MASK) | (((uint32_t)val) << PDMA_DMA_CMD10_RESERVED1_SHIFT))

#define  PDMA_DMA_CMD10_CMPEN_MASK 0x2000000
#define  PDMA_DMA_CMD10_CMPEN_SHIFT 25
#define  PDMA_DMA_CMD10_CMPEN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD10_CMPEN_MASK) >> PDMA_DMA_CMD10_CMPEN_SHIFT)
#define  PDMA_DMA_CMD10_CMPEN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD10_CMPEN_MASK) | (((uint32_t)val) << PDMA_DMA_CMD10_CMPEN_SHIFT))

#define  PDMA_DMA_CMD10_RESERVED2_MASK 0x1000000
#define  PDMA_DMA_CMD10_RESERVED2_SHIFT 24
#define  PDMA_DMA_CMD10_RESERVED2_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD10_RESERVED2_MASK) >> PDMA_DMA_CMD10_RESERVED2_SHIFT)
#define  PDMA_DMA_CMD10_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD10_RESERVED2_MASK) | (((uint32_t)val) << PDMA_DMA_CMD10_RESERVED2_SHIFT))

#define  PDMA_DMA_CMD10_ADDRMODE_MASK 0x800000
#define  PDMA_DMA_CMD10_ADDRMODE_SHIFT 23
#define  PDMA_DMA_CMD10_ADDRMODE_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD10_ADDRMODE_MASK) >> PDMA_DMA_CMD10_ADDRMODE_SHIFT)
#define  PDMA_DMA_CMD10_ADDRMODE_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD10_ADDRMODE_MASK) | (((uint32_t)val) << PDMA_DMA_CMD10_ADDRMODE_SHIFT))

#define  PDMA_DMA_CMD10_STARTIRQEN_MASK 0x400000
#define  PDMA_DMA_CMD10_STARTIRQEN_SHIFT 22
#define  PDMA_DMA_CMD10_STARTIRQEN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD10_STARTIRQEN_MASK) >> PDMA_DMA_CMD10_STARTIRQEN_SHIFT)
#define  PDMA_DMA_CMD10_STARTIRQEN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD10_STARTIRQEN_MASK) | (((uint32_t)val) << PDMA_DMA_CMD10_STARTIRQEN_SHIFT))

#define  PDMA_DMA_CMD10_ENDIRQEN_MASK 0x200000
#define  PDMA_DMA_CMD10_ENDIRQEN_SHIFT 21
#define  PDMA_DMA_CMD10_ENDIRQEN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD10_ENDIRQEN_MASK) >> PDMA_DMA_CMD10_ENDIRQEN_SHIFT)
#define  PDMA_DMA_CMD10_ENDIRQEN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD10_ENDIRQEN_MASK) | (((uint32_t)val) << PDMA_DMA_CMD10_ENDIRQEN_SHIFT))

#define  PDMA_DMA_CMD10_RESERVED3_MASK 0x180000
#define  PDMA_DMA_CMD10_RESERVED3_SHIFT 19
#define  PDMA_DMA_CMD10_RESERVED3_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD10_RESERVED3_MASK) >> PDMA_DMA_CMD10_RESERVED3_SHIFT)
#define  PDMA_DMA_CMD10_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD10_RESERVED3_MASK) | (((uint32_t)val) << PDMA_DMA_CMD10_RESERVED3_SHIFT))

#define  PDMA_DMA_CMD10_SIZE_MASK 0x70000
#define  PDMA_DMA_CMD10_SIZE_SHIFT 16
#define  PDMA_DMA_CMD10_SIZE_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD10_SIZE_MASK) >> PDMA_DMA_CMD10_SIZE_SHIFT)
#define  PDMA_DMA_CMD10_SIZE_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD10_SIZE_MASK) | (((uint32_t)val) << PDMA_DMA_CMD10_SIZE_SHIFT))

#define  PDMA_DMA_CMD10_WIDTH_MASK 0xc000
#define  PDMA_DMA_CMD10_WIDTH_SHIFT 14
#define  PDMA_DMA_CMD10_WIDTH_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD10_WIDTH_MASK) >> PDMA_DMA_CMD10_WIDTH_SHIFT)
#define  PDMA_DMA_CMD10_WIDTH_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD10_WIDTH_MASK) | (((uint32_t)val) << PDMA_DMA_CMD10_WIDTH_SHIFT))

#define  PDMA_DMA_CMD10_RESERVED4_MASK 0x2000
#define  PDMA_DMA_CMD10_RESERVED4_SHIFT 13
#define  PDMA_DMA_CMD10_RESERVED4_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD10_RESERVED4_MASK) >> PDMA_DMA_CMD10_RESERVED4_SHIFT)
#define  PDMA_DMA_CMD10_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD10_RESERVED4_MASK) | (((uint32_t)val) << PDMA_DMA_CMD10_RESERVED4_SHIFT))

#define  PDMA_DMA_CMD10_LEN_MASK 0x1fff
#define  PDMA_DMA_CMD10_LEN_SHIFT 0
#define  PDMA_DMA_CMD10_LEN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD10_LEN_MASK) >> PDMA_DMA_CMD10_LEN_SHIFT)
#define  PDMA_DMA_CMD10_LEN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD10_LEN_MASK) | (((uint32_t)val) << PDMA_DMA_CMD10_LEN_SHIFT))

//====================================================================
//Register: DMA Command Registers 0-15 (Instance 12 of 16) (DMA_CMD11)
/** \brief These read-only registers are for descriptor-fetch transfers and read/write
for no-descriptor-fetch transfers.
<br>
These are read/write registers. Ignore reads from reserved bits. Write 0x0
to reserved bits. (Instance 12 of 16)*/
//====================================================================

#define  PDMA_DMA_CMD11_INCSRCADDR_MASK 0x80000000
#define  PDMA_DMA_CMD11_INCSRCADDR_SHIFT 31
#define  PDMA_DMA_CMD11_INCSRCADDR_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD11_INCSRCADDR_MASK) >> PDMA_DMA_CMD11_INCSRCADDR_SHIFT)
#define  PDMA_DMA_CMD11_INCSRCADDR_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD11_INCSRCADDR_MASK) | (((uint32_t)val) << PDMA_DMA_CMD11_INCSRCADDR_SHIFT))

#define  PDMA_DMA_CMD11_INCTRGADDR_MASK 0x40000000
#define  PDMA_DMA_CMD11_INCTRGADDR_SHIFT 30
#define  PDMA_DMA_CMD11_INCTRGADDR_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD11_INCTRGADDR_MASK) >> PDMA_DMA_CMD11_INCTRGADDR_SHIFT)
#define  PDMA_DMA_CMD11_INCTRGADDR_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD11_INCTRGADDR_MASK) | (((uint32_t)val) << PDMA_DMA_CMD11_INCTRGADDR_SHIFT))

#define  PDMA_DMA_CMD11_FLOWSRC_MASK 0x20000000
#define  PDMA_DMA_CMD11_FLOWSRC_SHIFT 29
#define  PDMA_DMA_CMD11_FLOWSRC_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD11_FLOWSRC_MASK) >> PDMA_DMA_CMD11_FLOWSRC_SHIFT)
#define  PDMA_DMA_CMD11_FLOWSRC_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD11_FLOWSRC_MASK) | (((uint32_t)val) << PDMA_DMA_CMD11_FLOWSRC_SHIFT))

#define  PDMA_DMA_CMD11_FLOWTRG_MASK 0x10000000
#define  PDMA_DMA_CMD11_FLOWTRG_SHIFT 28
#define  PDMA_DMA_CMD11_FLOWTRG_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD11_FLOWTRG_MASK) >> PDMA_DMA_CMD11_FLOWTRG_SHIFT)
#define  PDMA_DMA_CMD11_FLOWTRG_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD11_FLOWTRG_MASK) | (((uint32_t)val) << PDMA_DMA_CMD11_FLOWTRG_SHIFT))

#define  PDMA_DMA_CMD11_RESERVED1_MASK 0xc000000
#define  PDMA_DMA_CMD11_RESERVED1_SHIFT 26
#define  PDMA_DMA_CMD11_RESERVED1_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD11_RESERVED1_MASK) >> PDMA_DMA_CMD11_RESERVED1_SHIFT)
#define  PDMA_DMA_CMD11_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD11_RESERVED1_MASK) | (((uint32_t)val) << PDMA_DMA_CMD11_RESERVED1_SHIFT))

#define  PDMA_DMA_CMD11_CMPEN_MASK 0x2000000
#define  PDMA_DMA_CMD11_CMPEN_SHIFT 25
#define  PDMA_DMA_CMD11_CMPEN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD11_CMPEN_MASK) >> PDMA_DMA_CMD11_CMPEN_SHIFT)
#define  PDMA_DMA_CMD11_CMPEN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD11_CMPEN_MASK) | (((uint32_t)val) << PDMA_DMA_CMD11_CMPEN_SHIFT))

#define  PDMA_DMA_CMD11_RESERVED2_MASK 0x1000000
#define  PDMA_DMA_CMD11_RESERVED2_SHIFT 24
#define  PDMA_DMA_CMD11_RESERVED2_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD11_RESERVED2_MASK) >> PDMA_DMA_CMD11_RESERVED2_SHIFT)
#define  PDMA_DMA_CMD11_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD11_RESERVED2_MASK) | (((uint32_t)val) << PDMA_DMA_CMD11_RESERVED2_SHIFT))

#define  PDMA_DMA_CMD11_ADDRMODE_MASK 0x800000
#define  PDMA_DMA_CMD11_ADDRMODE_SHIFT 23
#define  PDMA_DMA_CMD11_ADDRMODE_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD11_ADDRMODE_MASK) >> PDMA_DMA_CMD11_ADDRMODE_SHIFT)
#define  PDMA_DMA_CMD11_ADDRMODE_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD11_ADDRMODE_MASK) | (((uint32_t)val) << PDMA_DMA_CMD11_ADDRMODE_SHIFT))

#define  PDMA_DMA_CMD11_STARTIRQEN_MASK 0x400000
#define  PDMA_DMA_CMD11_STARTIRQEN_SHIFT 22
#define  PDMA_DMA_CMD11_STARTIRQEN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD11_STARTIRQEN_MASK) >> PDMA_DMA_CMD11_STARTIRQEN_SHIFT)
#define  PDMA_DMA_CMD11_STARTIRQEN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD11_STARTIRQEN_MASK) | (((uint32_t)val) << PDMA_DMA_CMD11_STARTIRQEN_SHIFT))

#define  PDMA_DMA_CMD11_ENDIRQEN_MASK 0x200000
#define  PDMA_DMA_CMD11_ENDIRQEN_SHIFT 21
#define  PDMA_DMA_CMD11_ENDIRQEN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD11_ENDIRQEN_MASK) >> PDMA_DMA_CMD11_ENDIRQEN_SHIFT)
#define  PDMA_DMA_CMD11_ENDIRQEN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD11_ENDIRQEN_MASK) | (((uint32_t)val) << PDMA_DMA_CMD11_ENDIRQEN_SHIFT))

#define  PDMA_DMA_CMD11_RESERVED3_MASK 0x180000
#define  PDMA_DMA_CMD11_RESERVED3_SHIFT 19
#define  PDMA_DMA_CMD11_RESERVED3_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD11_RESERVED3_MASK) >> PDMA_DMA_CMD11_RESERVED3_SHIFT)
#define  PDMA_DMA_CMD11_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD11_RESERVED3_MASK) | (((uint32_t)val) << PDMA_DMA_CMD11_RESERVED3_SHIFT))

#define  PDMA_DMA_CMD11_SIZE_MASK 0x70000
#define  PDMA_DMA_CMD11_SIZE_SHIFT 16
#define  PDMA_DMA_CMD11_SIZE_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD11_SIZE_MASK) >> PDMA_DMA_CMD11_SIZE_SHIFT)
#define  PDMA_DMA_CMD11_SIZE_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD11_SIZE_MASK) | (((uint32_t)val) << PDMA_DMA_CMD11_SIZE_SHIFT))

#define  PDMA_DMA_CMD11_WIDTH_MASK 0xc000
#define  PDMA_DMA_CMD11_WIDTH_SHIFT 14
#define  PDMA_DMA_CMD11_WIDTH_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD11_WIDTH_MASK) >> PDMA_DMA_CMD11_WIDTH_SHIFT)
#define  PDMA_DMA_CMD11_WIDTH_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD11_WIDTH_MASK) | (((uint32_t)val) << PDMA_DMA_CMD11_WIDTH_SHIFT))

#define  PDMA_DMA_CMD11_RESERVED4_MASK 0x2000
#define  PDMA_DMA_CMD11_RESERVED4_SHIFT 13
#define  PDMA_DMA_CMD11_RESERVED4_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD11_RESERVED4_MASK) >> PDMA_DMA_CMD11_RESERVED4_SHIFT)
#define  PDMA_DMA_CMD11_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD11_RESERVED4_MASK) | (((uint32_t)val) << PDMA_DMA_CMD11_RESERVED4_SHIFT))

#define  PDMA_DMA_CMD11_LEN_MASK 0x1fff
#define  PDMA_DMA_CMD11_LEN_SHIFT 0
#define  PDMA_DMA_CMD11_LEN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD11_LEN_MASK) >> PDMA_DMA_CMD11_LEN_SHIFT)
#define  PDMA_DMA_CMD11_LEN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD11_LEN_MASK) | (((uint32_t)val) << PDMA_DMA_CMD11_LEN_SHIFT))

//====================================================================
//Register: DMA Command Registers 0-15 (Instance 13 of 16) (DMA_CMD12)
/** \brief These read-only registers are for descriptor-fetch transfers and read/write
for no-descriptor-fetch transfers.
<br>
These are read/write registers. Ignore reads from reserved bits. Write 0x0
to reserved bits. (Instance 13 of 16)*/
//====================================================================

#define  PDMA_DMA_CMD12_INCSRCADDR_MASK 0x80000000
#define  PDMA_DMA_CMD12_INCSRCADDR_SHIFT 31
#define  PDMA_DMA_CMD12_INCSRCADDR_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD12_INCSRCADDR_MASK) >> PDMA_DMA_CMD12_INCSRCADDR_SHIFT)
#define  PDMA_DMA_CMD12_INCSRCADDR_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD12_INCSRCADDR_MASK) | (((uint32_t)val) << PDMA_DMA_CMD12_INCSRCADDR_SHIFT))

#define  PDMA_DMA_CMD12_INCTRGADDR_MASK 0x40000000
#define  PDMA_DMA_CMD12_INCTRGADDR_SHIFT 30
#define  PDMA_DMA_CMD12_INCTRGADDR_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD12_INCTRGADDR_MASK) >> PDMA_DMA_CMD12_INCTRGADDR_SHIFT)
#define  PDMA_DMA_CMD12_INCTRGADDR_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD12_INCTRGADDR_MASK) | (((uint32_t)val) << PDMA_DMA_CMD12_INCTRGADDR_SHIFT))

#define  PDMA_DMA_CMD12_FLOWSRC_MASK 0x20000000
#define  PDMA_DMA_CMD12_FLOWSRC_SHIFT 29
#define  PDMA_DMA_CMD12_FLOWSRC_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD12_FLOWSRC_MASK) >> PDMA_DMA_CMD12_FLOWSRC_SHIFT)
#define  PDMA_DMA_CMD12_FLOWSRC_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD12_FLOWSRC_MASK) | (((uint32_t)val) << PDMA_DMA_CMD12_FLOWSRC_SHIFT))

#define  PDMA_DMA_CMD12_FLOWTRG_MASK 0x10000000
#define  PDMA_DMA_CMD12_FLOWTRG_SHIFT 28
#define  PDMA_DMA_CMD12_FLOWTRG_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD12_FLOWTRG_MASK) >> PDMA_DMA_CMD12_FLOWTRG_SHIFT)
#define  PDMA_DMA_CMD12_FLOWTRG_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD12_FLOWTRG_MASK) | (((uint32_t)val) << PDMA_DMA_CMD12_FLOWTRG_SHIFT))

#define  PDMA_DMA_CMD12_RESERVED1_MASK 0xc000000
#define  PDMA_DMA_CMD12_RESERVED1_SHIFT 26
#define  PDMA_DMA_CMD12_RESERVED1_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD12_RESERVED1_MASK) >> PDMA_DMA_CMD12_RESERVED1_SHIFT)
#define  PDMA_DMA_CMD12_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD12_RESERVED1_MASK) | (((uint32_t)val) << PDMA_DMA_CMD12_RESERVED1_SHIFT))

#define  PDMA_DMA_CMD12_CMPEN_MASK 0x2000000
#define  PDMA_DMA_CMD12_CMPEN_SHIFT 25
#define  PDMA_DMA_CMD12_CMPEN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD12_CMPEN_MASK) >> PDMA_DMA_CMD12_CMPEN_SHIFT)
#define  PDMA_DMA_CMD12_CMPEN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD12_CMPEN_MASK) | (((uint32_t)val) << PDMA_DMA_CMD12_CMPEN_SHIFT))

#define  PDMA_DMA_CMD12_RESERVED2_MASK 0x1000000
#define  PDMA_DMA_CMD12_RESERVED2_SHIFT 24
#define  PDMA_DMA_CMD12_RESERVED2_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD12_RESERVED2_MASK) >> PDMA_DMA_CMD12_RESERVED2_SHIFT)
#define  PDMA_DMA_CMD12_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD12_RESERVED2_MASK) | (((uint32_t)val) << PDMA_DMA_CMD12_RESERVED2_SHIFT))

#define  PDMA_DMA_CMD12_ADDRMODE_MASK 0x800000
#define  PDMA_DMA_CMD12_ADDRMODE_SHIFT 23
#define  PDMA_DMA_CMD12_ADDRMODE_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD12_ADDRMODE_MASK) >> PDMA_DMA_CMD12_ADDRMODE_SHIFT)
#define  PDMA_DMA_CMD12_ADDRMODE_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD12_ADDRMODE_MASK) | (((uint32_t)val) << PDMA_DMA_CMD12_ADDRMODE_SHIFT))

#define  PDMA_DMA_CMD12_STARTIRQEN_MASK 0x400000
#define  PDMA_DMA_CMD12_STARTIRQEN_SHIFT 22
#define  PDMA_DMA_CMD12_STARTIRQEN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD12_STARTIRQEN_MASK) >> PDMA_DMA_CMD12_STARTIRQEN_SHIFT)
#define  PDMA_DMA_CMD12_STARTIRQEN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD12_STARTIRQEN_MASK) | (((uint32_t)val) << PDMA_DMA_CMD12_STARTIRQEN_SHIFT))

#define  PDMA_DMA_CMD12_ENDIRQEN_MASK 0x200000
#define  PDMA_DMA_CMD12_ENDIRQEN_SHIFT 21
#define  PDMA_DMA_CMD12_ENDIRQEN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD12_ENDIRQEN_MASK) >> PDMA_DMA_CMD12_ENDIRQEN_SHIFT)
#define  PDMA_DMA_CMD12_ENDIRQEN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD12_ENDIRQEN_MASK) | (((uint32_t)val) << PDMA_DMA_CMD12_ENDIRQEN_SHIFT))

#define  PDMA_DMA_CMD12_RESERVED3_MASK 0x180000
#define  PDMA_DMA_CMD12_RESERVED3_SHIFT 19
#define  PDMA_DMA_CMD12_RESERVED3_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD12_RESERVED3_MASK) >> PDMA_DMA_CMD12_RESERVED3_SHIFT)
#define  PDMA_DMA_CMD12_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD12_RESERVED3_MASK) | (((uint32_t)val) << PDMA_DMA_CMD12_RESERVED3_SHIFT))

#define  PDMA_DMA_CMD12_SIZE_MASK 0x70000
#define  PDMA_DMA_CMD12_SIZE_SHIFT 16
#define  PDMA_DMA_CMD12_SIZE_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD12_SIZE_MASK) >> PDMA_DMA_CMD12_SIZE_SHIFT)
#define  PDMA_DMA_CMD12_SIZE_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD12_SIZE_MASK) | (((uint32_t)val) << PDMA_DMA_CMD12_SIZE_SHIFT))

#define  PDMA_DMA_CMD12_WIDTH_MASK 0xc000
#define  PDMA_DMA_CMD12_WIDTH_SHIFT 14
#define  PDMA_DMA_CMD12_WIDTH_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD12_WIDTH_MASK) >> PDMA_DMA_CMD12_WIDTH_SHIFT)
#define  PDMA_DMA_CMD12_WIDTH_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD12_WIDTH_MASK) | (((uint32_t)val) << PDMA_DMA_CMD12_WIDTH_SHIFT))

#define  PDMA_DMA_CMD12_RESERVED4_MASK 0x2000
#define  PDMA_DMA_CMD12_RESERVED4_SHIFT 13
#define  PDMA_DMA_CMD12_RESERVED4_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD12_RESERVED4_MASK) >> PDMA_DMA_CMD12_RESERVED4_SHIFT)
#define  PDMA_DMA_CMD12_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD12_RESERVED4_MASK) | (((uint32_t)val) << PDMA_DMA_CMD12_RESERVED4_SHIFT))

#define  PDMA_DMA_CMD12_LEN_MASK 0x1fff
#define  PDMA_DMA_CMD12_LEN_SHIFT 0
#define  PDMA_DMA_CMD12_LEN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD12_LEN_MASK) >> PDMA_DMA_CMD12_LEN_SHIFT)
#define  PDMA_DMA_CMD12_LEN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD12_LEN_MASK) | (((uint32_t)val) << PDMA_DMA_CMD12_LEN_SHIFT))

//====================================================================
//Register: DMA Command Registers 0-15 (Instance 14 of 16) (DMA_CMD13)
/** \brief These read-only registers are for descriptor-fetch transfers and read/write
for no-descriptor-fetch transfers.
<br>
These are read/write registers. Ignore reads from reserved bits. Write 0x0
to reserved bits. (Instance 14 of 16)*/
//====================================================================

#define  PDMA_DMA_CMD13_INCSRCADDR_MASK 0x80000000
#define  PDMA_DMA_CMD13_INCSRCADDR_SHIFT 31
#define  PDMA_DMA_CMD13_INCSRCADDR_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD13_INCSRCADDR_MASK) >> PDMA_DMA_CMD13_INCSRCADDR_SHIFT)
#define  PDMA_DMA_CMD13_INCSRCADDR_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD13_INCSRCADDR_MASK) | (((uint32_t)val) << PDMA_DMA_CMD13_INCSRCADDR_SHIFT))

#define  PDMA_DMA_CMD13_INCTRGADDR_MASK 0x40000000
#define  PDMA_DMA_CMD13_INCTRGADDR_SHIFT 30
#define  PDMA_DMA_CMD13_INCTRGADDR_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD13_INCTRGADDR_MASK) >> PDMA_DMA_CMD13_INCTRGADDR_SHIFT)
#define  PDMA_DMA_CMD13_INCTRGADDR_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD13_INCTRGADDR_MASK) | (((uint32_t)val) << PDMA_DMA_CMD13_INCTRGADDR_SHIFT))

#define  PDMA_DMA_CMD13_FLOWSRC_MASK 0x20000000
#define  PDMA_DMA_CMD13_FLOWSRC_SHIFT 29
#define  PDMA_DMA_CMD13_FLOWSRC_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD13_FLOWSRC_MASK) >> PDMA_DMA_CMD13_FLOWSRC_SHIFT)
#define  PDMA_DMA_CMD13_FLOWSRC_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD13_FLOWSRC_MASK) | (((uint32_t)val) << PDMA_DMA_CMD13_FLOWSRC_SHIFT))

#define  PDMA_DMA_CMD13_FLOWTRG_MASK 0x10000000
#define  PDMA_DMA_CMD13_FLOWTRG_SHIFT 28
#define  PDMA_DMA_CMD13_FLOWTRG_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD13_FLOWTRG_MASK) >> PDMA_DMA_CMD13_FLOWTRG_SHIFT)
#define  PDMA_DMA_CMD13_FLOWTRG_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD13_FLOWTRG_MASK) | (((uint32_t)val) << PDMA_DMA_CMD13_FLOWTRG_SHIFT))

#define  PDMA_DMA_CMD13_RESERVED1_MASK 0xc000000
#define  PDMA_DMA_CMD13_RESERVED1_SHIFT 26
#define  PDMA_DMA_CMD13_RESERVED1_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD13_RESERVED1_MASK) >> PDMA_DMA_CMD13_RESERVED1_SHIFT)
#define  PDMA_DMA_CMD13_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD13_RESERVED1_MASK) | (((uint32_t)val) << PDMA_DMA_CMD13_RESERVED1_SHIFT))

#define  PDMA_DMA_CMD13_CMPEN_MASK 0x2000000
#define  PDMA_DMA_CMD13_CMPEN_SHIFT 25
#define  PDMA_DMA_CMD13_CMPEN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD13_CMPEN_MASK) >> PDMA_DMA_CMD13_CMPEN_SHIFT)
#define  PDMA_DMA_CMD13_CMPEN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD13_CMPEN_MASK) | (((uint32_t)val) << PDMA_DMA_CMD13_CMPEN_SHIFT))

#define  PDMA_DMA_CMD13_RESERVED2_MASK 0x1000000
#define  PDMA_DMA_CMD13_RESERVED2_SHIFT 24
#define  PDMA_DMA_CMD13_RESERVED2_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD13_RESERVED2_MASK) >> PDMA_DMA_CMD13_RESERVED2_SHIFT)
#define  PDMA_DMA_CMD13_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD13_RESERVED2_MASK) | (((uint32_t)val) << PDMA_DMA_CMD13_RESERVED2_SHIFT))

#define  PDMA_DMA_CMD13_ADDRMODE_MASK 0x800000
#define  PDMA_DMA_CMD13_ADDRMODE_SHIFT 23
#define  PDMA_DMA_CMD13_ADDRMODE_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD13_ADDRMODE_MASK) >> PDMA_DMA_CMD13_ADDRMODE_SHIFT)
#define  PDMA_DMA_CMD13_ADDRMODE_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD13_ADDRMODE_MASK) | (((uint32_t)val) << PDMA_DMA_CMD13_ADDRMODE_SHIFT))

#define  PDMA_DMA_CMD13_STARTIRQEN_MASK 0x400000
#define  PDMA_DMA_CMD13_STARTIRQEN_SHIFT 22
#define  PDMA_DMA_CMD13_STARTIRQEN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD13_STARTIRQEN_MASK) >> PDMA_DMA_CMD13_STARTIRQEN_SHIFT)
#define  PDMA_DMA_CMD13_STARTIRQEN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD13_STARTIRQEN_MASK) | (((uint32_t)val) << PDMA_DMA_CMD13_STARTIRQEN_SHIFT))

#define  PDMA_DMA_CMD13_ENDIRQEN_MASK 0x200000
#define  PDMA_DMA_CMD13_ENDIRQEN_SHIFT 21
#define  PDMA_DMA_CMD13_ENDIRQEN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD13_ENDIRQEN_MASK) >> PDMA_DMA_CMD13_ENDIRQEN_SHIFT)
#define  PDMA_DMA_CMD13_ENDIRQEN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD13_ENDIRQEN_MASK) | (((uint32_t)val) << PDMA_DMA_CMD13_ENDIRQEN_SHIFT))

#define  PDMA_DMA_CMD13_RESERVED3_MASK 0x180000
#define  PDMA_DMA_CMD13_RESERVED3_SHIFT 19
#define  PDMA_DMA_CMD13_RESERVED3_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD13_RESERVED3_MASK) >> PDMA_DMA_CMD13_RESERVED3_SHIFT)
#define  PDMA_DMA_CMD13_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD13_RESERVED3_MASK) | (((uint32_t)val) << PDMA_DMA_CMD13_RESERVED3_SHIFT))

#define  PDMA_DMA_CMD13_SIZE_MASK 0x70000
#define  PDMA_DMA_CMD13_SIZE_SHIFT 16
#define  PDMA_DMA_CMD13_SIZE_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD13_SIZE_MASK) >> PDMA_DMA_CMD13_SIZE_SHIFT)
#define  PDMA_DMA_CMD13_SIZE_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD13_SIZE_MASK) | (((uint32_t)val) << PDMA_DMA_CMD13_SIZE_SHIFT))

#define  PDMA_DMA_CMD13_WIDTH_MASK 0xc000
#define  PDMA_DMA_CMD13_WIDTH_SHIFT 14
#define  PDMA_DMA_CMD13_WIDTH_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD13_WIDTH_MASK) >> PDMA_DMA_CMD13_WIDTH_SHIFT)
#define  PDMA_DMA_CMD13_WIDTH_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD13_WIDTH_MASK) | (((uint32_t)val) << PDMA_DMA_CMD13_WIDTH_SHIFT))

#define  PDMA_DMA_CMD13_RESERVED4_MASK 0x2000
#define  PDMA_DMA_CMD13_RESERVED4_SHIFT 13
#define  PDMA_DMA_CMD13_RESERVED4_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD13_RESERVED4_MASK) >> PDMA_DMA_CMD13_RESERVED4_SHIFT)
#define  PDMA_DMA_CMD13_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD13_RESERVED4_MASK) | (((uint32_t)val) << PDMA_DMA_CMD13_RESERVED4_SHIFT))

#define  PDMA_DMA_CMD13_LEN_MASK 0x1fff
#define  PDMA_DMA_CMD13_LEN_SHIFT 0
#define  PDMA_DMA_CMD13_LEN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD13_LEN_MASK) >> PDMA_DMA_CMD13_LEN_SHIFT)
#define  PDMA_DMA_CMD13_LEN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD13_LEN_MASK) | (((uint32_t)val) << PDMA_DMA_CMD13_LEN_SHIFT))

//====================================================================
//Register: DMA Command Registers 0-15 (Instance 15 of 16) (DMA_CMD14)
/** \brief These read-only registers are for descriptor-fetch transfers and read/write
for no-descriptor-fetch transfers.
<br>
These are read/write registers. Ignore reads from reserved bits. Write 0x0
to reserved bits. (Instance 15 of 16)*/
//====================================================================

#define  PDMA_DMA_CMD14_INCSRCADDR_MASK 0x80000000
#define  PDMA_DMA_CMD14_INCSRCADDR_SHIFT 31
#define  PDMA_DMA_CMD14_INCSRCADDR_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD14_INCSRCADDR_MASK) >> PDMA_DMA_CMD14_INCSRCADDR_SHIFT)
#define  PDMA_DMA_CMD14_INCSRCADDR_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD14_INCSRCADDR_MASK) | (((uint32_t)val) << PDMA_DMA_CMD14_INCSRCADDR_SHIFT))

#define  PDMA_DMA_CMD14_INCTRGADDR_MASK 0x40000000
#define  PDMA_DMA_CMD14_INCTRGADDR_SHIFT 30
#define  PDMA_DMA_CMD14_INCTRGADDR_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD14_INCTRGADDR_MASK) >> PDMA_DMA_CMD14_INCTRGADDR_SHIFT)
#define  PDMA_DMA_CMD14_INCTRGADDR_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD14_INCTRGADDR_MASK) | (((uint32_t)val) << PDMA_DMA_CMD14_INCTRGADDR_SHIFT))

#define  PDMA_DMA_CMD14_FLOWSRC_MASK 0x20000000
#define  PDMA_DMA_CMD14_FLOWSRC_SHIFT 29
#define  PDMA_DMA_CMD14_FLOWSRC_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD14_FLOWSRC_MASK) >> PDMA_DMA_CMD14_FLOWSRC_SHIFT)
#define  PDMA_DMA_CMD14_FLOWSRC_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD14_FLOWSRC_MASK) | (((uint32_t)val) << PDMA_DMA_CMD14_FLOWSRC_SHIFT))

#define  PDMA_DMA_CMD14_FLOWTRG_MASK 0x10000000
#define  PDMA_DMA_CMD14_FLOWTRG_SHIFT 28
#define  PDMA_DMA_CMD14_FLOWTRG_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD14_FLOWTRG_MASK) >> PDMA_DMA_CMD14_FLOWTRG_SHIFT)
#define  PDMA_DMA_CMD14_FLOWTRG_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD14_FLOWTRG_MASK) | (((uint32_t)val) << PDMA_DMA_CMD14_FLOWTRG_SHIFT))

#define  PDMA_DMA_CMD14_RESERVED1_MASK 0xc000000
#define  PDMA_DMA_CMD14_RESERVED1_SHIFT 26
#define  PDMA_DMA_CMD14_RESERVED1_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD14_RESERVED1_MASK) >> PDMA_DMA_CMD14_RESERVED1_SHIFT)
#define  PDMA_DMA_CMD14_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD14_RESERVED1_MASK) | (((uint32_t)val) << PDMA_DMA_CMD14_RESERVED1_SHIFT))

#define  PDMA_DMA_CMD14_CMPEN_MASK 0x2000000
#define  PDMA_DMA_CMD14_CMPEN_SHIFT 25
#define  PDMA_DMA_CMD14_CMPEN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD14_CMPEN_MASK) >> PDMA_DMA_CMD14_CMPEN_SHIFT)
#define  PDMA_DMA_CMD14_CMPEN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD14_CMPEN_MASK) | (((uint32_t)val) << PDMA_DMA_CMD14_CMPEN_SHIFT))

#define  PDMA_DMA_CMD14_RESERVED2_MASK 0x1000000
#define  PDMA_DMA_CMD14_RESERVED2_SHIFT 24
#define  PDMA_DMA_CMD14_RESERVED2_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD14_RESERVED2_MASK) >> PDMA_DMA_CMD14_RESERVED2_SHIFT)
#define  PDMA_DMA_CMD14_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD14_RESERVED2_MASK) | (((uint32_t)val) << PDMA_DMA_CMD14_RESERVED2_SHIFT))

#define  PDMA_DMA_CMD14_ADDRMODE_MASK 0x800000
#define  PDMA_DMA_CMD14_ADDRMODE_SHIFT 23
#define  PDMA_DMA_CMD14_ADDRMODE_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD14_ADDRMODE_MASK) >> PDMA_DMA_CMD14_ADDRMODE_SHIFT)
#define  PDMA_DMA_CMD14_ADDRMODE_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD14_ADDRMODE_MASK) | (((uint32_t)val) << PDMA_DMA_CMD14_ADDRMODE_SHIFT))

#define  PDMA_DMA_CMD14_STARTIRQEN_MASK 0x400000
#define  PDMA_DMA_CMD14_STARTIRQEN_SHIFT 22
#define  PDMA_DMA_CMD14_STARTIRQEN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD14_STARTIRQEN_MASK) >> PDMA_DMA_CMD14_STARTIRQEN_SHIFT)
#define  PDMA_DMA_CMD14_STARTIRQEN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD14_STARTIRQEN_MASK) | (((uint32_t)val) << PDMA_DMA_CMD14_STARTIRQEN_SHIFT))

#define  PDMA_DMA_CMD14_ENDIRQEN_MASK 0x200000
#define  PDMA_DMA_CMD14_ENDIRQEN_SHIFT 21
#define  PDMA_DMA_CMD14_ENDIRQEN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD14_ENDIRQEN_MASK) >> PDMA_DMA_CMD14_ENDIRQEN_SHIFT)
#define  PDMA_DMA_CMD14_ENDIRQEN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD14_ENDIRQEN_MASK) | (((uint32_t)val) << PDMA_DMA_CMD14_ENDIRQEN_SHIFT))

#define  PDMA_DMA_CMD14_RESERVED3_MASK 0x180000
#define  PDMA_DMA_CMD14_RESERVED3_SHIFT 19
#define  PDMA_DMA_CMD14_RESERVED3_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD14_RESERVED3_MASK) >> PDMA_DMA_CMD14_RESERVED3_SHIFT)
#define  PDMA_DMA_CMD14_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD14_RESERVED3_MASK) | (((uint32_t)val) << PDMA_DMA_CMD14_RESERVED3_SHIFT))

#define  PDMA_DMA_CMD14_SIZE_MASK 0x70000
#define  PDMA_DMA_CMD14_SIZE_SHIFT 16
#define  PDMA_DMA_CMD14_SIZE_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD14_SIZE_MASK) >> PDMA_DMA_CMD14_SIZE_SHIFT)
#define  PDMA_DMA_CMD14_SIZE_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD14_SIZE_MASK) | (((uint32_t)val) << PDMA_DMA_CMD14_SIZE_SHIFT))

#define  PDMA_DMA_CMD14_WIDTH_MASK 0xc000
#define  PDMA_DMA_CMD14_WIDTH_SHIFT 14
#define  PDMA_DMA_CMD14_WIDTH_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD14_WIDTH_MASK) >> PDMA_DMA_CMD14_WIDTH_SHIFT)
#define  PDMA_DMA_CMD14_WIDTH_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD14_WIDTH_MASK) | (((uint32_t)val) << PDMA_DMA_CMD14_WIDTH_SHIFT))

#define  PDMA_DMA_CMD14_RESERVED4_MASK 0x2000
#define  PDMA_DMA_CMD14_RESERVED4_SHIFT 13
#define  PDMA_DMA_CMD14_RESERVED4_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD14_RESERVED4_MASK) >> PDMA_DMA_CMD14_RESERVED4_SHIFT)
#define  PDMA_DMA_CMD14_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD14_RESERVED4_MASK) | (((uint32_t)val) << PDMA_DMA_CMD14_RESERVED4_SHIFT))

#define  PDMA_DMA_CMD14_LEN_MASK 0x1fff
#define  PDMA_DMA_CMD14_LEN_SHIFT 0
#define  PDMA_DMA_CMD14_LEN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD14_LEN_MASK) >> PDMA_DMA_CMD14_LEN_SHIFT)
#define  PDMA_DMA_CMD14_LEN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD14_LEN_MASK) | (((uint32_t)val) << PDMA_DMA_CMD14_LEN_SHIFT))

//====================================================================
//Register: DMA Command Registers 0-15 (Instance 16 of 16) (DMA_CMD15)
/** \brief These read-only registers are for descriptor-fetch transfers and read/write
for no-descriptor-fetch transfers.
<br>
These are read/write registers. Ignore reads from reserved bits. Write 0x0
to reserved bits. (Instance 16 of 16)*/
//====================================================================

#define  PDMA_DMA_CMD15_INCSRCADDR_MASK 0x80000000
#define  PDMA_DMA_CMD15_INCSRCADDR_SHIFT 31
#define  PDMA_DMA_CMD15_INCSRCADDR_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD15_INCSRCADDR_MASK) >> PDMA_DMA_CMD15_INCSRCADDR_SHIFT)
#define  PDMA_DMA_CMD15_INCSRCADDR_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD15_INCSRCADDR_MASK) | (((uint32_t)val) << PDMA_DMA_CMD15_INCSRCADDR_SHIFT))

#define  PDMA_DMA_CMD15_INCTRGADDR_MASK 0x40000000
#define  PDMA_DMA_CMD15_INCTRGADDR_SHIFT 30
#define  PDMA_DMA_CMD15_INCTRGADDR_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD15_INCTRGADDR_MASK) >> PDMA_DMA_CMD15_INCTRGADDR_SHIFT)
#define  PDMA_DMA_CMD15_INCTRGADDR_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD15_INCTRGADDR_MASK) | (((uint32_t)val) << PDMA_DMA_CMD15_INCTRGADDR_SHIFT))

#define  PDMA_DMA_CMD15_FLOWSRC_MASK 0x20000000
#define  PDMA_DMA_CMD15_FLOWSRC_SHIFT 29
#define  PDMA_DMA_CMD15_FLOWSRC_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD15_FLOWSRC_MASK) >> PDMA_DMA_CMD15_FLOWSRC_SHIFT)
#define  PDMA_DMA_CMD15_FLOWSRC_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD15_FLOWSRC_MASK) | (((uint32_t)val) << PDMA_DMA_CMD15_FLOWSRC_SHIFT))

#define  PDMA_DMA_CMD15_FLOWTRG_MASK 0x10000000
#define  PDMA_DMA_CMD15_FLOWTRG_SHIFT 28
#define  PDMA_DMA_CMD15_FLOWTRG_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD15_FLOWTRG_MASK) >> PDMA_DMA_CMD15_FLOWTRG_SHIFT)
#define  PDMA_DMA_CMD15_FLOWTRG_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD15_FLOWTRG_MASK) | (((uint32_t)val) << PDMA_DMA_CMD15_FLOWTRG_SHIFT))

#define  PDMA_DMA_CMD15_RESERVED1_MASK 0xc000000
#define  PDMA_DMA_CMD15_RESERVED1_SHIFT 26
#define  PDMA_DMA_CMD15_RESERVED1_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD15_RESERVED1_MASK) >> PDMA_DMA_CMD15_RESERVED1_SHIFT)
#define  PDMA_DMA_CMD15_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD15_RESERVED1_MASK) | (((uint32_t)val) << PDMA_DMA_CMD15_RESERVED1_SHIFT))

#define  PDMA_DMA_CMD15_CMPEN_MASK 0x2000000
#define  PDMA_DMA_CMD15_CMPEN_SHIFT 25
#define  PDMA_DMA_CMD15_CMPEN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD15_CMPEN_MASK) >> PDMA_DMA_CMD15_CMPEN_SHIFT)
#define  PDMA_DMA_CMD15_CMPEN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD15_CMPEN_MASK) | (((uint32_t)val) << PDMA_DMA_CMD15_CMPEN_SHIFT))

#define  PDMA_DMA_CMD15_RESERVED2_MASK 0x1000000
#define  PDMA_DMA_CMD15_RESERVED2_SHIFT 24
#define  PDMA_DMA_CMD15_RESERVED2_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD15_RESERVED2_MASK) >> PDMA_DMA_CMD15_RESERVED2_SHIFT)
#define  PDMA_DMA_CMD15_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD15_RESERVED2_MASK) | (((uint32_t)val) << PDMA_DMA_CMD15_RESERVED2_SHIFT))

#define  PDMA_DMA_CMD15_ADDRMODE_MASK 0x800000
#define  PDMA_DMA_CMD15_ADDRMODE_SHIFT 23
#define  PDMA_DMA_CMD15_ADDRMODE_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD15_ADDRMODE_MASK) >> PDMA_DMA_CMD15_ADDRMODE_SHIFT)
#define  PDMA_DMA_CMD15_ADDRMODE_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD15_ADDRMODE_MASK) | (((uint32_t)val) << PDMA_DMA_CMD15_ADDRMODE_SHIFT))

#define  PDMA_DMA_CMD15_STARTIRQEN_MASK 0x400000
#define  PDMA_DMA_CMD15_STARTIRQEN_SHIFT 22
#define  PDMA_DMA_CMD15_STARTIRQEN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD15_STARTIRQEN_MASK) >> PDMA_DMA_CMD15_STARTIRQEN_SHIFT)
#define  PDMA_DMA_CMD15_STARTIRQEN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD15_STARTIRQEN_MASK) | (((uint32_t)val) << PDMA_DMA_CMD15_STARTIRQEN_SHIFT))

#define  PDMA_DMA_CMD15_ENDIRQEN_MASK 0x200000
#define  PDMA_DMA_CMD15_ENDIRQEN_SHIFT 21
#define  PDMA_DMA_CMD15_ENDIRQEN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD15_ENDIRQEN_MASK) >> PDMA_DMA_CMD15_ENDIRQEN_SHIFT)
#define  PDMA_DMA_CMD15_ENDIRQEN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD15_ENDIRQEN_MASK) | (((uint32_t)val) << PDMA_DMA_CMD15_ENDIRQEN_SHIFT))

#define  PDMA_DMA_CMD15_RESERVED3_MASK 0x180000
#define  PDMA_DMA_CMD15_RESERVED3_SHIFT 19
#define  PDMA_DMA_CMD15_RESERVED3_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD15_RESERVED3_MASK) >> PDMA_DMA_CMD15_RESERVED3_SHIFT)
#define  PDMA_DMA_CMD15_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD15_RESERVED3_MASK) | (((uint32_t)val) << PDMA_DMA_CMD15_RESERVED3_SHIFT))

#define  PDMA_DMA_CMD15_SIZE_MASK 0x70000
#define  PDMA_DMA_CMD15_SIZE_SHIFT 16
#define  PDMA_DMA_CMD15_SIZE_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD15_SIZE_MASK) >> PDMA_DMA_CMD15_SIZE_SHIFT)
#define  PDMA_DMA_CMD15_SIZE_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD15_SIZE_MASK) | (((uint32_t)val) << PDMA_DMA_CMD15_SIZE_SHIFT))

#define  PDMA_DMA_CMD15_WIDTH_MASK 0xc000
#define  PDMA_DMA_CMD15_WIDTH_SHIFT 14
#define  PDMA_DMA_CMD15_WIDTH_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD15_WIDTH_MASK) >> PDMA_DMA_CMD15_WIDTH_SHIFT)
#define  PDMA_DMA_CMD15_WIDTH_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD15_WIDTH_MASK) | (((uint32_t)val) << PDMA_DMA_CMD15_WIDTH_SHIFT))

#define  PDMA_DMA_CMD15_RESERVED4_MASK 0x2000
#define  PDMA_DMA_CMD15_RESERVED4_SHIFT 13
#define  PDMA_DMA_CMD15_RESERVED4_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD15_RESERVED4_MASK) >> PDMA_DMA_CMD15_RESERVED4_SHIFT)
#define  PDMA_DMA_CMD15_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD15_RESERVED4_MASK) | (((uint32_t)val) << PDMA_DMA_CMD15_RESERVED4_SHIFT))

#define  PDMA_DMA_CMD15_LEN_MASK 0x1fff
#define  PDMA_DMA_CMD15_LEN_SHIFT 0
#define  PDMA_DMA_CMD15_LEN_MASK_SHIFT(reg) (((reg) & PDMA_DMA_CMD15_LEN_MASK) >> PDMA_DMA_CMD15_LEN_SHIFT)
#define  PDMA_DMA_CMD15_LEN_REPLACE_VAL(reg,val) (((reg) & ~PDMA_DMA_CMD15_LEN_MASK) | (((uint32_t)val) << PDMA_DMA_CMD15_LEN_SHIFT))

#endif // PDMA
