 /*
 **************************************************************************************
 *
 * (c) Copyright 2013 Marvell International Ltd.
 *
 *
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/.
 *
 **************************************************************************************
 *
 * \file PCIE_regstructs.h
 * Generated using RegBuild 1.6.3
 *
 **************************************************************************************
 */

#ifndef _PCIE_REGSTRUCTS_H_
#define _PCIE_REGSTRUCTS_H_

#ifndef __KERNEL__
#include <stdint.h>
#endif

//====================================================================
//
//Register File: PCIE (PCIE)
/** \brief Top-level register file for PCIE
(rev 0 . 1 . 0 . 4)*/
//
//====================================================================

//====================================================================
//
//Register File: PCIE_Dm_Core Registers (Dm_Core)
/** \brief Register file for PCIE Core (These are asynchronous to the Bus Domain).*/
//
//====================================================================

typedef struct DM_CORE_REGS_s
{
  volatile uint32_t TCfg00;  ///< 0x0 [R/W]: Core Target Configuration Register 00
  volatile uint32_t TCfg04;  ///< 0x4 [R/W]: Core Target Configuration Register 04
  volatile uint32_t TCfg08;  ///< 0x8 [R/W]: Core Target Configuration Register 08
  volatile uint32_t TCfg0C;  ///< 0xc [R/W]: Core Target Configuration Register 0C
  volatile uint32_t TCfg10;  ///< 0x10 [R/W]: Core Target Configuration Register 10 is BAR0
  volatile uint32_t TCfg14;  ///< 0x14 [R/W]: Core Target Configuration Register 14 is BAR1
  volatile uint32_t reserved0[5];
  volatile uint32_t TCfg2C;  ///< 0x2c [R/W]: Core Target Configuration Register 2C, Subsystem ID and Subsystem Vendor ID
  volatile uint32_t reserved1;
  volatile uint32_t TCfg34;  ///< 0x34 [R/W]: Core Target Configuration Register 34
  volatile uint32_t reserved2;
  volatile uint32_t TCfg3C;  ///< 0x3c [R/W]: Core Target Configuration Register 3C, Interrupt Pin  and Interrupt Line
  volatile uint32_t TPMCap;  ///< 0x40 [R/W]: Core Target Power Management Capabilities Register
  volatile uint32_t TPMCSR;  ///< 0x44 [R/W]: Core Target Power Management Control and Status Register
  volatile uint32_t reserved3[2];
  volatile uint32_t TMsiCtrl;  ///< 0x50 [R/W]: Core Target MSI Capabilities Control Register
  volatile uint32_t TMsiAddr;  ///< 0x54 [R/W]: Core Target MSI Capabilities  Address Register
  volatile uint32_t reserved4;
  volatile uint32_t TMsiData;  ///< 0x5c [R/W]: Core Target MSI Capabilities Data  Register
  volatile uint32_t reserved5[4];
  volatile uint32_t TPCIECap;  ///< 0x70 [R/W]: Core Target PCIE Capabilities Register
  volatile uint32_t TDevCap;  ///< 0x74 [R/W]: Core Target Device Capability Register
  volatile uint32_t TDevContStatus;  ///< 0x78 [R/W]: Core Target Device Control and Status Register
  volatile uint32_t TDevLinkCap;  ///< 0x7c [R/W]: Core Target Device Link Capabilities Register
  volatile uint32_t TLinkContStatus;  ///< 0x80 [R/W]: Core Target Link Control and Status Register
  volatile uint32_t reserved6[4];
  volatile uint32_t TDevCap2;  ///< 0x94 [R/W]: Core Target Device Capability2 Register
  volatile uint32_t TDevContStatus2;  ///< 0x98 [R/W]: Core Target Device Control and Status2 Register
  volatile uint32_t TDevLinkCap2;  ///< 0x9c [R/W]: Core Target Device Link Capabilities2 Register
  volatile uint32_t TLinkContStatus2;  ///< 0xa0 [R/W]: Core Target Link Control and Status2 Register
  volatile uint32_t reserved7[23];
  volatile uint32_t TAERCap;  ///< 0x100 [R/W]: Core Target AER Capabilities Register
  volatile uint32_t TUCorrStat;  ///< 0x104 [R/W]: Core Target Uncorrectable Error Status Register
  volatile uint32_t TUCorrMask;  ///< 0x108 [R/W]: Core Target Uncorrectable Error Mask Register
  volatile uint32_t TUCorrSev;  ///< 0x10c [R/W]: Core Target Uncorrectable Error Severity Register
  volatile uint32_t TCorrStat;  ///< 0x110 [R/W]: Core Target Correctable Error Status Register
  volatile uint32_t TCorrMask;  ///< 0x114 [R/W]: Core Target Correctable Error Mask Register
  volatile uint32_t TAERCapCtrl;  ///< 0x118 [R/W]: Core Target AER Capabilities and Control Register
  volatile uint32_t THeaderLog1;  ///< 0x11c [R/W]: Core Target Header Log Register (first DWORD)
  volatile uint32_t THeaderLog2;  ///< 0x120 [R/W]: Core Target Header Log Register (second DWORD)
  volatile uint32_t THeaderLog3;  ///< 0x124 [R/W]: Core Target Header Log Register (third DWORD)
  volatile uint32_t THeaderLog4;  ///< 0x128 [R/W]: Core Target Header Log Register (fourth DWORD)
  volatile uint32_t reserved8[8117];
  volatile uint32_t LCfg00;  ///< 0x8000 [R/W]: Core Local Configuration Register 00
  volatile uint32_t LCfg04;  ///< 0x8004 [R/W]: Core Local Configuration Register 04
  volatile uint32_t LCfg08;  ///< 0x8008 [R/W]: Core Local Configuration Register 08
  volatile uint32_t LCfg0C;  ///< 0x800c [R/W]: Core Local Configuration Register 0C
  volatile uint32_t LCfg10;  ///< 0x8010 [R/W]: Core Local Configuration Register 10 is BAR0
  volatile uint32_t LCfg14;  ///< 0x8014 [R/W]: Core Local Configuration Register 14 is BAR1
  volatile uint32_t reserved9[3];
  volatile uint32_t LCfg24;  ///< 0x8024 [R/W]: Prefetchable Memory Base and Limit Register
  volatile uint32_t reserved10;
  volatile uint32_t LCfg2C;  ///< 0x802c [R/W]: Core Local Configuration Register 2C, Subsystem ID and Subsystem Vendor ID
  volatile uint32_t reserved11;
  volatile uint32_t LCfg34;  ///< 0x8034 [R/W]: Core Local Configuration Register 34
  volatile uint32_t reserved12;
  volatile uint32_t LCfg3C;  ///< 0x803c [R/W]: Core Local Configuration Register 3C, Interrupt Pin  and Interrupt Line
  volatile uint32_t LPMCap;  ///< 0x8040 [R/W]: Core Local Power Management Capabilities Register
  volatile uint32_t LPMCSR;  ///< 0x8044 [R/W]: Core Local Power Management Control and Status Register
  volatile uint32_t reserved13[2];
  volatile uint32_t LMsiCtrl;  ///< 0x8050 [R/W]: Core Local MSI Capabilities Control Register
  volatile uint32_t LMsiAddr;  ///< 0x8054 [R/W]: Core Local MSI Capabilities  Address Register
  volatile uint32_t reserved14;
  volatile uint32_t LMsiData;  ///< 0x805c [R/W]: Core Local MSI Capabilities Data  Register
  volatile uint32_t reserved15[4];
  volatile uint32_t LPCIECap;  ///< 0x8070 [R/W]: Core Local PCIE Capabilities Register
  volatile uint32_t LDevCap;  ///< 0x8074 [R/W]: Core Local Device Capability Register
  volatile uint32_t LDevContStatus;  ///< 0x8078 [R/W]: Core Local Device Control and Status Register
  volatile uint32_t LDevLinkCap;  ///< 0x807c [R/W]: Core Local Device Link Capabilities Register
  volatile uint32_t LLinkContStatus;  ///< 0x8080 [R/W]: Core Local Link Control and Status Register
  volatile uint32_t reserved16[2];
  volatile uint32_t LRootCtrl;  ///< 0x808c [R/W]: Core Local Root Control Register
  volatile uint32_t LRootStat;  ///< 0x8090 [R/W]: Core Local Root Status Register
  volatile uint32_t LDevCap2;  ///< 0x8094 [R/W]: Core Local Device Capability2 Register
  volatile uint32_t LDevContStatus2;  ///< 0x8098 [R/W]: Core Local Device Control and Status2 Register
  volatile uint32_t LDevLinkCap2;  ///< 0x809c [R/W]: Core Local Device Link Capabilities2 Register
  volatile uint32_t LLinkContStatus2;  ///< 0x80a0 [R/W]: Core Local Link Control and Status2 Register
  volatile uint32_t reserved17[23];
  volatile uint32_t LAERCap;  ///< 0x8100 [R/W]: Core Local AER Capabilities Register
  volatile uint32_t LUCorrStat;  ///< 0x8104 [R/W]: Core Local Uncorrectable Error Status Register
  volatile uint32_t LUCorrMask;  ///< 0x8108 [R/W]: Core Local Uncorrectable Error Mask Register
  volatile uint32_t LUCorrSev;  ///< 0x810c [R/W]: Core Local Uncorrectable Error Severity Register
  volatile uint32_t LCorrStat;  ///< 0x8110 [R/W]: Core Local Correctable Error Status Register
  volatile uint32_t LCorrMask;  ///< 0x8114 [R/W]: Core Local Correctable Error Mask Register
  volatile uint32_t LAERCapCtrl;  ///< 0x8118 [R/W]: Core Local AER Capabilities and Control Register
  volatile uint32_t LHeaderLog1;  ///< 0x811c [R/W]: Core Local Header Log Register (first DWORD)
  volatile uint32_t LHeaderLog2;  ///< 0x8120 [R/W]: Core Local Header Log Register (second DWORD)
  volatile uint32_t LHeaderLog3;  ///< 0x8124 [R/W]: Core Local Header Log Register (third DWORD)
  volatile uint32_t LHeaderLog4;  ///< 0x8128 [R/W]: Core Local Header Log Register (fourth DWORD)
  volatile uint32_t LRootErrCmd;  ///< 0x812c [R/W]: Core Local Root Error Command Register
  volatile uint32_t LRootErrStat;  ///< 0x8130 [R/W]: Core Local Root Error Status Register
  volatile uint32_t LErrSrcID;  ///< 0x8134 [R]: Core Local Error Source Identification Register
  volatile uint32_t reserved18[4];
  volatile uint32_t LL1SubCapHeader;  ///< 0x8148 [R/W]: Core Local L1 Substates Capability Header Register
  volatile uint32_t LL1SubCapability;  ///< 0x814c [R/W]: Core Local L1 Substates Capability Register
  volatile uint32_t LL1SubControl1;  ///< 0x8150 [R/W]: Core Local L1 Substates Control 1 Register
  volatile uint32_t LL1SubControl2;  ///< 0x8154 [R/W]: Core Local L1 Substates Control 2 Register
  volatile uint32_t reserved19[362];
  volatile uint32_t LPortTimer;  ///< 0x8700 [R/W]: Core Local Port Logic Ack Latency and Replay Timer Register
  volatile uint32_t LMsgReg;  ///< 0x8704 [R/W]: Core Local Port Logic Message Register
  volatile uint32_t LForceLink;  ///< 0x8708 [R/W]: Core Local Port Logic Force Link Register
  volatile uint32_t LAckFreq;  ///< 0x870c [R/W]: Core Local Port Logic Ack Frequency Register
  volatile uint32_t LPortLink;  ///< 0x8710 [R/W]: Core Local Port Link Control Register
  volatile uint32_t reserved20[62];
  volatile uint32_t LLWidthSpeed;  ///< 0x880c [R/W]: Core Link Width and Speed Change Control Register
  volatile uint32_t reserved21[204];
  volatile uint32_t LAuxClkFreqCtrl;  ///< 0x8b40 [R/W]: Local Auxiliary Clock Frequency Control Register
  volatile uint32_t reserved22[307];
  volatile uint32_t LCfg10M;  ///< 0x9010 [W]: Core Local Configuration BAR0 Mask Register
  volatile uint32_t LCfg14M;  ///< 0x9014 [W]: Core Local Configuration BAR1 Mask Register
} DM_CORE_REGS_t;

//====================================================================
//
//Register File: PCIE_Dm_App Registers (Dm_App)
/** \brief Top-level register file for PCIE_App*/
//
//====================================================================

typedef struct DM_APP_REGS_s
{
  volatile uint32_t ACtrl;  ///< 0x0 [R/W]: Application Control Register
  volatile uint32_t AStat;  ///< 0x4 [R]: Application Status Register
  volatile uint32_t AIntP;  ///< 0x8 [R]: Application Interrupt Pending Register
  volatile uint32_t AIntEn;  ///< 0xc [R/W]: Application Interrupt Enable Register
  volatile uint32_t AIntAck;  ///< 0x10 [W]: Application Interrupt Acknowledge Register
  volatile uint32_t InAddrXlt0;  ///< 0x14 [R/W]: Application Inbound Address Translation Register 0
  volatile uint32_t InAddrXlt1;  ///< 0x18 [R/W]: Application Inbound Address Translation Register 1
  volatile uint32_t InAddrXlt2;  ///< 0x1c [R/W]: Application Inbound Address Translation Register 2
  volatile uint32_t BAR0;  ///< 0x20 [R/W]: Application BAR0
  volatile uint32_t WinMiss;  ///< 0x24 [R/W]: Application Window Miss Register
  volatile uint32_t RC_MSI_IRQ0_Mask;  ///< 0x28 [R/W]: Application RC MSI Interrupt0 Mask 
  volatile uint32_t RC_MSI_IRQ0;  ///< 0x2c [R/W]: Application RC MSI Interrupt0
  volatile uint32_t RC_MSI_IRQ0_Clr;  ///< 0x30 [W]: Application RC MSI Interrupt0 Clear
  volatile uint32_t RC_MSI_IRQ1_Mask;  ///< 0x34 [R/W]: Application RC MSI Interrupt1 Mask 
  volatile uint32_t RC_MSI_IRQ1;  ///< 0x38 [R/W]: Application RC MSI Interrupt1
  volatile uint32_t RC_MSI_IRQ1_Clr;  ///< 0x3c [W]: Application RC MSI Interrupt1 Clear
  volatile uint32_t RC_MSI_IRQ2_Mask;  ///< 0x40 [R/W]: Application RC MSI Interrupt2 Mask 
  volatile uint32_t RC_MSI_IRQ2;  ///< 0x44 [R/W]: Application RC MSI Interrupt2
  volatile uint32_t RC_MSI_IRQ2_Clr;  ///< 0x48 [W]: Application RC MSI Interrupt2 Clear
  volatile uint32_t RC_MSI_IRQ3_Mask;  ///< 0x4c [R/W]: Application RC MSI Interrupt3 Mask 
  volatile uint32_t RC_MSI_IRQ3;  ///< 0x50 [R/W]: Application RC MSI Interrupt3
  volatile uint32_t RC_MSI_IRQ3_Clr;  ///< 0x54 [W]: Application RC MSI Interrupt3 Clear
  volatile uint32_t RC_INTA_IRQ_En;  ///< 0x58 [R/W]: Application INTA Interrupt Enable
  volatile uint32_t RC_INTA_IRQ_Cnt;  ///< 0x5c [R]: Application INTA Count Value
  volatile uint32_t RC_INTB_IRQ_En;  ///< 0x60 [R/W]: Application INTB Interrupt Enable
  volatile uint32_t RC_INTB_IRQ_Cnt;  ///< 0x64 [R]: Application INTB Count Value
  volatile uint32_t RC_INTC_IRQ_En;  ///< 0x68 [R/W]: Application INTC Interrupt Enable
  volatile uint32_t RC_INTC_IRQ_Cnt;  ///< 0x6c [R]: Application INTC Count Value
  volatile uint32_t RC_INTD_IRQ_En;  ///< 0x70 [R/W]: Application INTD Interrupt Enable
  volatile uint32_t RC_INTD_IRQ_Cnt;  ///< 0x74 [R]: Application INTD Count Value
  volatile uint32_t EP_INTA_Gen;  ///< 0x78 [R/W]: Application - EP INTA Generate
  volatile uint32_t EP_MSI_Gen;  ///< 0x7c [R/W]: Application - EP MSI Generate
  volatile uint32_t EP_MSI_Gen_En;  ///< 0x80 [R]: Application - EP MSI Generate Enabled
  volatile uint32_t MB_WR_En0;  ///< 0x84 [R/W]: Application - Mailbox Write Interrupt Enable Register 0-7 (Instance 1 of 8)
  volatile uint32_t MB_WR_En1;  ///< 0x88 [R/W]: Application - Mailbox Write Interrupt Enable Register 0-7 (Instance 2 of 8)
  volatile uint32_t MB_WR_En2;  ///< 0x8c [R/W]: Application - Mailbox Write Interrupt Enable Register 0-7 (Instance 3 of 8)
  volatile uint32_t MB_WR_En3;  ///< 0x90 [R/W]: Application - Mailbox Write Interrupt Enable Register 0-7 (Instance 4 of 8)
  volatile uint32_t MB_WR_En4;  ///< 0x94 [R/W]: Application - Mailbox Write Interrupt Enable Register 0-7 (Instance 5 of 8)
  volatile uint32_t MB_WR_En5;  ///< 0x98 [R/W]: Application - Mailbox Write Interrupt Enable Register 0-7 (Instance 6 of 8)
  volatile uint32_t MB_WR_En6;  ///< 0x9c [R/W]: Application - Mailbox Write Interrupt Enable Register 0-7 (Instance 7 of 8)
  volatile uint32_t MB_WR_En7;  ///< 0xa0 [R/W]: Application - Mailbox Write Interrupt Enable Register 0-7 (Instance 8 of 8)
  volatile uint32_t MB_WR0;  ///< 0xa4 [W]: Application - Mailbox Write Register 0-7 (Instance 1 of 8)
  volatile uint32_t MB_WR1;  ///< 0xa8 [W]: Application - Mailbox Write Register 0-7 (Instance 2 of 8)
  volatile uint32_t MB_WR2;  ///< 0xac [W]: Application - Mailbox Write Register 0-7 (Instance 3 of 8)
  volatile uint32_t MB_WR3;  ///< 0xb0 [W]: Application - Mailbox Write Register 0-7 (Instance 4 of 8)
  volatile uint32_t MB_WR4;  ///< 0xb4 [W]: Application - Mailbox Write Register 0-7 (Instance 5 of 8)
  volatile uint32_t MB_WR5;  ///< 0xb8 [W]: Application - Mailbox Write Register 0-7 (Instance 6 of 8)
  volatile uint32_t MB_WR6;  ///< 0xbc [W]: Application - Mailbox Write Register 0-7 (Instance 7 of 8)
  volatile uint32_t MB_WR7;  ///< 0xc0 [W]: Application - Mailbox Write Register 0-7 (Instance 8 of 8)
  volatile uint32_t MB_WR_Stat0;  ///< 0xc4 [R]: Application - Mailbox Write Register Status 0-7 (Instance 1 of 8)
  volatile uint32_t MB_WR_Stat1;  ///< 0xc8 [R]: Application - Mailbox Write Register Status 0-7 (Instance 2 of 8)
  volatile uint32_t MB_WR_Stat2;  ///< 0xcc [R]: Application - Mailbox Write Register Status 0-7 (Instance 3 of 8)
  volatile uint32_t MB_WR_Stat3;  ///< 0xd0 [R]: Application - Mailbox Write Register Status 0-7 (Instance 4 of 8)
  volatile uint32_t MB_WR_Stat4;  ///< 0xd4 [R]: Application - Mailbox Write Register Status 0-7 (Instance 5 of 8)
  volatile uint32_t MB_WR_Stat5;  ///< 0xd8 [R]: Application - Mailbox Write Register Status 0-7 (Instance 6 of 8)
  volatile uint32_t MB_WR_Stat6;  ///< 0xdc [R]: Application - Mailbox Write Register Status 0-7 (Instance 7 of 8)
  volatile uint32_t MB_WR_Stat7;  ///< 0xe0 [R]: Application - Mailbox Write Register Status 0-7 (Instance 8 of 8)
  volatile uint32_t MB_WR_Ack0;  ///< 0xe4 [W]: Application - Mailbox Write Interrupt Acknowledge Register 0-7 (Instance 1 of 8)
  volatile uint32_t MB_WR_Ack1;  ///< 0xe8 [W]: Application - Mailbox Write Interrupt Acknowledge Register 0-7 (Instance 2 of 8)
  volatile uint32_t MB_WR_Ack2;  ///< 0xec [W]: Application - Mailbox Write Interrupt Acknowledge Register 0-7 (Instance 3 of 8)
  volatile uint32_t MB_WR_Ack3;  ///< 0xf0 [W]: Application - Mailbox Write Interrupt Acknowledge Register 0-7 (Instance 4 of 8)
  volatile uint32_t MB_WR_Ack4;  ///< 0xf4 [W]: Application - Mailbox Write Interrupt Acknowledge Register 0-7 (Instance 5 of 8)
  volatile uint32_t MB_WR_Ack5;  ///< 0xf8 [W]: Application - Mailbox Write Interrupt Acknowledge Register 0-7 (Instance 6 of 8)
  volatile uint32_t MB_WR_Ack6;  ///< 0xfc [W]: Application - Mailbox Write Interrupt Acknowledge Register 0-7 (Instance 7 of 8)
  volatile uint32_t MB_WR_Ack7;  ///< 0x100 [W]: Application - Mailbox Write Interrupt Acknowledge Register 0-7 (Instance 8 of 8)
  volatile uint32_t COMM0;  ///< 0x104 [R/W]: Application - General Purpose Communication Register 0-7 (Instance 1 of 8)
  volatile uint32_t COMM1;  ///< 0x108 [R/W]: Application - General Purpose Communication Register 0-7 (Instance 2 of 8)
  volatile uint32_t COMM2;  ///< 0x10c [R/W]: Application - General Purpose Communication Register 0-7 (Instance 3 of 8)
  volatile uint32_t COMM3;  ///< 0x110 [R/W]: Application - General Purpose Communication Register 0-7 (Instance 4 of 8)
  volatile uint32_t COMM4;  ///< 0x114 [R/W]: Application - General Purpose Communication Register 0-7 (Instance 5 of 8)
  volatile uint32_t COMM5;  ///< 0x118 [R/W]: Application - General Purpose Communication Register 0-7 (Instance 6 of 8)
  volatile uint32_t COMM6;  ///< 0x11c [R/W]: Application - General Purpose Communication Register 0-7 (Instance 7 of 8)
  volatile uint32_t COMM7;  ///< 0x120 [R/W]: Application - General Purpose Communication Register 0-7 (Instance 8 of 8)
  volatile uint32_t AckCount;  ///< 0x124 [R]: Application - Ack Statistics Register
  volatile uint32_t NackCount;  ///< 0x128 [R]: Application - Nack Statistics Register
  volatile uint32_t WrAckCount;  ///< 0x12c [W]: Application - Write Ack Statistics Register
  volatile uint32_t WrNackCount;  ///< 0x130 [W]: Application - Write Nack Statistics Register
  volatile uint32_t reserved0[951];
  volatile uint32_t OutAddrXlt0;  ///< 0x1010 [R/W]: Application Outbound Address Translation Register 0
  volatile uint32_t OutAddrXlt1;  ///< 0x1014 [R/W]: Application Outbound Address Translation Register 1
  volatile uint32_t OutAddrXlt2;  ///< 0x1018 [R/W]: Application Outbound Address Translation Register 2
  volatile uint32_t OutAddrXlt3;  ///< 0x101c [R/W]: Application Outbound Address Translation Register 3
  volatile uint32_t OutAddrXlt4;  ///< 0x1020 [R/W]: Application Outbound Address Translation Register 4
  volatile uint32_t OutAddrXlt5;  ///< 0x1024 [R/W]: Application Outbound Address Translation Register 5
  volatile uint32_t OutAddrXlt6;  ///< 0x1028 [R/W]: Application Outbound Address Translation Register 6
  volatile uint32_t OutAddrXlt7;  ///< 0x102c [R/W]: Application Outbound Address Translation Register 7
  volatile uint32_t CfgControl;  ///< 0x1030 [R/W]: Application Configuration TLP Settings
  volatile uint32_t PhyLaneNum;  ///< 0x1034 [R/W]: Application PHY Lane Number
  volatile uint32_t RefClkBuf;  ///< 0x1038 [R/W]: Reference Clock Buffer Control
  volatile uint32_t reserved1[5];
  volatile uint32_t REV0;  ///< 0x1050 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0x1054 [R]: IP Tagging Revision 1
  volatile uint32_t reserved2[1002];
  volatile uint32_t CID_REG0;  ///< 0x2000 [R]: Chip ID
  volatile uint32_t POWER_REG0;  ///< 0x2004 [R/W]: Power and PLL Control Register
  volatile uint32_t CAL_REG0;  ///< 0x2008 [R/W]: KVCO Calibration Control Register
  volatile uint32_t reserved3[32];
  volatile uint32_t LOOPBACK_REG0;  ///< 0x208c [R/W]: Digital Loopback Enable Register
  volatile uint32_t reserved4[37];
  volatile uint32_t MISC_REG49;  ///< 0x2124 [R/W]: COMPHY Register 0x49
  volatile uint32_t reserved5[5];
  volatile uint32_t MISC_FREQ_SEL;  ///< 0x213c [R/W]: COMPHY Register 0x4f - Misc Freq Select
  volatile uint32_t reserved6;
  volatile uint32_t MISC_REG51;  ///< 0x2144 [R/W]: COMPHY Register 0x51
  volatile uint32_t reserved7[302];
  volatile uint32_t LANE_CFG0;  ///< 0x2600 [R/W]: Lane Configuration 0
  volatile uint32_t LANE_CFG1;  ///< 0x2604 [R/W]: Lane Configuration 1
  volatile uint32_t LANE_STATUS0;  ///< 0x2608 [R]: Lane Status 0
  volatile uint32_t LANE_STATUS1;  ///< 0x260c [R]: Lane Status 1
  volatile uint32_t LANE_STATUS2;  ///< 0x2610 [R]: Lane Status 2
  volatile uint32_t LANE_BEACON;  ///< 0x2614 [R/W]: Lane Beacon Control
  volatile uint32_t reserved8[5];
  volatile uint32_t LANE_TXCMN_CFG;  ///< 0x262c [R/W]: Lane TX Common Mode Configuration Register
  volatile uint32_t reserved9[27];
  volatile uint32_t LANE_EQ_CFG0;  ///< 0x269c [R/W]: Lane Equalization Configuration 0
  volatile uint32_t reserved10[24];
  volatile uint32_t GLOB_PHY_REV;  ///< 0x2700 [R]: Global Phy PIPE Revision
  volatile uint32_t GLOB_CLK_CTRL;  ///< 0x2704 [R/W]: Global Clock Control
  volatile uint32_t GLOB_TEST_CTRL;  ///< 0x2708 [R/W]: Global Test Control
  volatile uint32_t GLOB_CLK_SRC_LO;  ///< 0x270c [R/W]: Clock Source Low
  volatile uint32_t GLOB_CLK_SRC_HI;  ///< 0x2710 [R/W]: Clock Source High
  volatile uint32_t GLOB_TRIGGER;  ///< 0x2714 [R/W]: Global Trigger
  volatile uint32_t GLOB_MISC_CTRL;  ///< 0x2718 [R/W]: Global Miscellaneous Control
  volatile uint32_t GLOB_CLKREQ_CTRL;  ///< 0x271c [R/W]: CLKREQ# Timing Control
  volatile uint32_t GLOB_DP_CFG;  ///< 0x2720 [R/W]: Datapath Configuration
  volatile uint32_t reserved11[9];
  volatile uint32_t GLOB_COUNTER_CTRL;  ///< 0x2748 [R/W]: Counter Type Register
  volatile uint32_t GLOB_COUNTER_LOW;  ///< 0x274c [R]: Counter Low Register
  volatile uint32_t GLOB_COUNTER_HI;  ///< 0x2750 [R]: Counter High Register
  volatile uint32_t reserved12[2];
  volatile uint32_t GLOB_LOW_FREQ_CFG;  ///< 0x275c [R/W]: Low Frequency Configuration Register
} DM_APP_REGS_t;

#endif // PCIE
