 /*
 **************************************************************************************
 *
 * (c) Copyright 2013 Marvell International Ltd.
 *
 *
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/.
 *
 **************************************************************************************
 *
 * \file PCIE_regmasks.h
 * Generated using RegBuild 1.6.3
 *
 **************************************************************************************
 */

#ifndef _PCIE_REGMASKS_H_
#define _PCIE_REGMASKS_H_

#ifndef __KERNEL__
#include <stdint.h>
#endif

//====================================================================
//
//Register File: PCIE (PCIE)
/** \brief Top-level register file for PCIE
(rev 0 . 1 . 0 . 4)*/
//
//====================================================================

//====================================================================
//
//Register File: PCIE_Dm_Core Registers (Dm_Core)
/** \brief Register file for PCIE Core (These are asynchronous to the Bus Domain).*/
//
//====================================================================

//====================================================================
//Register: Core Target Configuration Register 00 (TCfg00)
/** \brief Start of the Core Target EP Cfg Header Space per PCIe 2.0 Specification for Type 0 Headers.*/
//====================================================================

#define  DM_CORE_TCFG00_DEVICEID_MASK 0xffff0000
#define  DM_CORE_TCFG00_DEVICEID_SHIFT 16
#define  DM_CORE_TCFG00_DEVICEID_MASK_SHIFT(reg) (((reg) & DM_CORE_TCFG00_DEVICEID_MASK) >> DM_CORE_TCFG00_DEVICEID_SHIFT)
#define  DM_CORE_TCFG00_DEVICEID_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_TCFG00_DEVICEID_MASK) | (((uint32_t)val) << DM_CORE_TCFG00_DEVICEID_SHIFT))

#define  DM_CORE_TCFG00_VENDORID_MASK 0xffff
#define  DM_CORE_TCFG00_VENDORID_SHIFT 0
#define  DM_CORE_TCFG00_VENDORID_MASK_SHIFT(reg) (((reg) & DM_CORE_TCFG00_VENDORID_MASK) >> DM_CORE_TCFG00_VENDORID_SHIFT)
#define  DM_CORE_TCFG00_VENDORID_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_TCFG00_VENDORID_MASK) | (((uint32_t)val) << DM_CORE_TCFG00_VENDORID_SHIFT))

//====================================================================
//Register: Core Target Configuration Register 04 (TCfg04)
/** \brief Status and Command Registers for Type 0 Header*/
//====================================================================

#define  DM_CORE_TCFG04_STATUS_MASK 0xffff0000
#define  DM_CORE_TCFG04_STATUS_SHIFT 16
#define  DM_CORE_TCFG04_STATUS_MASK_SHIFT(reg) (((reg) & DM_CORE_TCFG04_STATUS_MASK) >> DM_CORE_TCFG04_STATUS_SHIFT)
#define  DM_CORE_TCFG04_STATUS_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_TCFG04_STATUS_MASK) | (((uint32_t)val) << DM_CORE_TCFG04_STATUS_SHIFT))

#define  DM_CORE_TCFG04_COMMAND_MASK 0xffff
#define  DM_CORE_TCFG04_COMMAND_SHIFT 0
#define  DM_CORE_TCFG04_COMMAND_MASK_SHIFT(reg) (((reg) & DM_CORE_TCFG04_COMMAND_MASK) >> DM_CORE_TCFG04_COMMAND_SHIFT)
#define  DM_CORE_TCFG04_COMMAND_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_TCFG04_COMMAND_MASK) | (((uint32_t)val) << DM_CORE_TCFG04_COMMAND_SHIFT))

//====================================================================
//Register: Core Target Configuration Register 08 (TCfg08)
/** \brief Class Code and Revision ID for Type 0 Header*/
//====================================================================

#define  DM_CORE_TCFG08_CLASSCODE_MASK 0xffffff00
#define  DM_CORE_TCFG08_CLASSCODE_SHIFT 8
#define  DM_CORE_TCFG08_CLASSCODE_MASK_SHIFT(reg) (((reg) & DM_CORE_TCFG08_CLASSCODE_MASK) >> DM_CORE_TCFG08_CLASSCODE_SHIFT)
#define  DM_CORE_TCFG08_CLASSCODE_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_TCFG08_CLASSCODE_MASK) | (((uint32_t)val) << DM_CORE_TCFG08_CLASSCODE_SHIFT))

#define  DM_CORE_TCFG08_REVID_MASK 0xff
#define  DM_CORE_TCFG08_REVID_SHIFT 0
#define  DM_CORE_TCFG08_REVID_MASK_SHIFT(reg) (((reg) & DM_CORE_TCFG08_REVID_MASK) >> DM_CORE_TCFG08_REVID_SHIFT)
#define  DM_CORE_TCFG08_REVID_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_TCFG08_REVID_MASK) | (((uint32_t)val) << DM_CORE_TCFG08_REVID_SHIFT))

//====================================================================
//Register: Core Target Configuration Register 0C (TCfg0C)
/** \brief BIST, Header Type, Latency Timer and Cacheline Size for Type 0 Header*/
//====================================================================

#define  DM_CORE_TCFG0C_BIST_MASK 0xff000000
#define  DM_CORE_TCFG0C_BIST_SHIFT 24
#define  DM_CORE_TCFG0C_BIST_MASK_SHIFT(reg) (((reg) & DM_CORE_TCFG0C_BIST_MASK) >> DM_CORE_TCFG0C_BIST_SHIFT)
#define  DM_CORE_TCFG0C_BIST_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_TCFG0C_BIST_MASK) | (((uint32_t)val) << DM_CORE_TCFG0C_BIST_SHIFT))

#define  DM_CORE_TCFG0C_HDRTYPE_MASK 0xff0000
#define  DM_CORE_TCFG0C_HDRTYPE_SHIFT 16
#define  DM_CORE_TCFG0C_HDRTYPE_MASK_SHIFT(reg) (((reg) & DM_CORE_TCFG0C_HDRTYPE_MASK) >> DM_CORE_TCFG0C_HDRTYPE_SHIFT)
#define  DM_CORE_TCFG0C_HDRTYPE_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_TCFG0C_HDRTYPE_MASK) | (((uint32_t)val) << DM_CORE_TCFG0C_HDRTYPE_SHIFT))

#define  DM_CORE_TCFG0C_LATTIMER_MASK 0xff00
#define  DM_CORE_TCFG0C_LATTIMER_SHIFT 8
#define  DM_CORE_TCFG0C_LATTIMER_MASK_SHIFT(reg) (((reg) & DM_CORE_TCFG0C_LATTIMER_MASK) >> DM_CORE_TCFG0C_LATTIMER_SHIFT)
#define  DM_CORE_TCFG0C_LATTIMER_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_TCFG0C_LATTIMER_MASK) | (((uint32_t)val) << DM_CORE_TCFG0C_LATTIMER_SHIFT))

#define  DM_CORE_TCFG0C_CACHELINESIZE_MASK 0xff
#define  DM_CORE_TCFG0C_CACHELINESIZE_SHIFT 0
#define  DM_CORE_TCFG0C_CACHELINESIZE_MASK_SHIFT(reg) (((reg) & DM_CORE_TCFG0C_CACHELINESIZE_MASK) >> DM_CORE_TCFG0C_CACHELINESIZE_SHIFT)
#define  DM_CORE_TCFG0C_CACHELINESIZE_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_TCFG0C_CACHELINESIZE_MASK) | (((uint32_t)val) << DM_CORE_TCFG0C_CACHELINESIZE_SHIFT))

//====================================================================
//Register: Core Target Configuration Register 10 is BAR0 (TCfg10)
/** \brief BAR0 Register*/
//====================================================================

#define  DM_CORE_TCFG10_BAR0_MASK 0xffffffff
#define  DM_CORE_TCFG10_BAR0_SHIFT 0
#define  DM_CORE_TCFG10_BAR0_MASK_SHIFT(reg) (((reg) & DM_CORE_TCFG10_BAR0_MASK) >> DM_CORE_TCFG10_BAR0_SHIFT)
#define  DM_CORE_TCFG10_BAR0_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_TCFG10_BAR0_MASK) | (((uint32_t)val) << DM_CORE_TCFG10_BAR0_SHIFT))

//====================================================================
//Register: Core Target Configuration Register 14 is BAR1 (TCfg14)
/** \brief BAR0 Register*/
//====================================================================

#define  DM_CORE_TCFG14_BAR1_MASK 0xffffffff
#define  DM_CORE_TCFG14_BAR1_SHIFT 0
#define  DM_CORE_TCFG14_BAR1_MASK_SHIFT(reg) (((reg) & DM_CORE_TCFG14_BAR1_MASK) >> DM_CORE_TCFG14_BAR1_SHIFT)
#define  DM_CORE_TCFG14_BAR1_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_TCFG14_BAR1_MASK) | (((uint32_t)val) << DM_CORE_TCFG14_BAR1_SHIFT))

//====================================================================
//Register: Core Target Configuration Register 2C, Subsystem ID and Subsystem Vendor ID (TCfg2C)
/** \brief Subsystem ID/Vendor ID*/
//====================================================================

#define  DM_CORE_TCFG2C_SUBSYSID_MASK 0xffff0000
#define  DM_CORE_TCFG2C_SUBSYSID_SHIFT 16
#define  DM_CORE_TCFG2C_SUBSYSID_MASK_SHIFT(reg) (((reg) & DM_CORE_TCFG2C_SUBSYSID_MASK) >> DM_CORE_TCFG2C_SUBSYSID_SHIFT)
#define  DM_CORE_TCFG2C_SUBSYSID_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_TCFG2C_SUBSYSID_MASK) | (((uint32_t)val) << DM_CORE_TCFG2C_SUBSYSID_SHIFT))

#define  DM_CORE_TCFG2C_SUBSYSVID_MASK 0xffff
#define  DM_CORE_TCFG2C_SUBSYSVID_SHIFT 0
#define  DM_CORE_TCFG2C_SUBSYSVID_MASK_SHIFT(reg) (((reg) & DM_CORE_TCFG2C_SUBSYSVID_MASK) >> DM_CORE_TCFG2C_SUBSYSVID_SHIFT)
#define  DM_CORE_TCFG2C_SUBSYSVID_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_TCFG2C_SUBSYSVID_MASK) | (((uint32_t)val) << DM_CORE_TCFG2C_SUBSYSVID_SHIFT))

//====================================================================
//Register: Core Target Configuration Register 34 (TCfg34)
/** \brief PCIe Cfg Header Capabilities Pointer - contents point to Capabilities Registers.
Must be > 0x3F to be outside basic Type 0 Cfg space.*/
//====================================================================

#define  DM_CORE_TCFG34_RESERVED1_MASK 0xffffff00
#define  DM_CORE_TCFG34_RESERVED1_SHIFT 8
#define  DM_CORE_TCFG34_RESERVED1_MASK_SHIFT(reg) (((reg) & DM_CORE_TCFG34_RESERVED1_MASK) >> DM_CORE_TCFG34_RESERVED1_SHIFT)
#define  DM_CORE_TCFG34_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_TCFG34_RESERVED1_MASK) | (((uint32_t)val) << DM_CORE_TCFG34_RESERVED1_SHIFT))

#define  DM_CORE_TCFG34_CAPABPTR_MASK 0xff
#define  DM_CORE_TCFG34_CAPABPTR_SHIFT 0
#define  DM_CORE_TCFG34_CAPABPTR_MASK_SHIFT(reg) (((reg) & DM_CORE_TCFG34_CAPABPTR_MASK) >> DM_CORE_TCFG34_CAPABPTR_SHIFT)
#define  DM_CORE_TCFG34_CAPABPTR_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_TCFG34_CAPABPTR_MASK) | (((uint32_t)val) << DM_CORE_TCFG34_CAPABPTR_SHIFT))

//====================================================================
//Register: Core Target Configuration Register 3C, Interrupt Pin  and Interrupt Line (TCfg3C)
/** \brief Interrupt Pin and Interrupt Line*/
//====================================================================

#define  DM_CORE_TCFG3C_RESERVED1_MASK 0xffff0000
#define  DM_CORE_TCFG3C_RESERVED1_SHIFT 16
#define  DM_CORE_TCFG3C_RESERVED1_MASK_SHIFT(reg) (((reg) & DM_CORE_TCFG3C_RESERVED1_MASK) >> DM_CORE_TCFG3C_RESERVED1_SHIFT)
#define  DM_CORE_TCFG3C_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_TCFG3C_RESERVED1_MASK) | (((uint32_t)val) << DM_CORE_TCFG3C_RESERVED1_SHIFT))

#define  DM_CORE_TCFG3C_INTPIN_MASK 0xff00
#define  DM_CORE_TCFG3C_INTPIN_SHIFT 8
#define  DM_CORE_TCFG3C_INTPIN_MASK_SHIFT(reg) (((reg) & DM_CORE_TCFG3C_INTPIN_MASK) >> DM_CORE_TCFG3C_INTPIN_SHIFT)
#define  DM_CORE_TCFG3C_INTPIN_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_TCFG3C_INTPIN_MASK) | (((uint32_t)val) << DM_CORE_TCFG3C_INTPIN_SHIFT))

#define  DM_CORE_TCFG3C_INTLINE_MASK 0xff
#define  DM_CORE_TCFG3C_INTLINE_SHIFT 0
#define  DM_CORE_TCFG3C_INTLINE_MASK_SHIFT(reg) (((reg) & DM_CORE_TCFG3C_INTLINE_MASK) >> DM_CORE_TCFG3C_INTLINE_SHIFT)
#define  DM_CORE_TCFG3C_INTLINE_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_TCFG3C_INTLINE_MASK) | (((uint32_t)val) << DM_CORE_TCFG3C_INTLINE_SHIFT))

//====================================================================
//Register: Core Target Power Management Capabilities Register (TPMCap)
/** \brief Power Management Capabilities Register.*/
//====================================================================

#define  DM_CORE_TPMCAP_PMCAP_MASK 0xffff0000
#define  DM_CORE_TPMCAP_PMCAP_SHIFT 16
#define  DM_CORE_TPMCAP_PMCAP_MASK_SHIFT(reg) (((reg) & DM_CORE_TPMCAP_PMCAP_MASK) >> DM_CORE_TPMCAP_PMCAP_SHIFT)
#define  DM_CORE_TPMCAP_PMCAP_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_TPMCAP_PMCAP_MASK) | (((uint32_t)val) << DM_CORE_TPMCAP_PMCAP_SHIFT))

#define  DM_CORE_TPMCAP_NEXTCAPPTR_MASK 0xff00
#define  DM_CORE_TPMCAP_NEXTCAPPTR_SHIFT 8
#define  DM_CORE_TPMCAP_NEXTCAPPTR_MASK_SHIFT(reg) (((reg) & DM_CORE_TPMCAP_NEXTCAPPTR_MASK) >> DM_CORE_TPMCAP_NEXTCAPPTR_SHIFT)
#define  DM_CORE_TPMCAP_NEXTCAPPTR_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_TPMCAP_NEXTCAPPTR_MASK) | (((uint32_t)val) << DM_CORE_TPMCAP_NEXTCAPPTR_SHIFT))

#define  DM_CORE_TPMCAP_CAPABID_MASK 0xff
#define  DM_CORE_TPMCAP_CAPABID_SHIFT 0
#define  DM_CORE_TPMCAP_CAPABID_MASK_SHIFT(reg) (((reg) & DM_CORE_TPMCAP_CAPABID_MASK) >> DM_CORE_TPMCAP_CAPABID_SHIFT)
#define  DM_CORE_TPMCAP_CAPABID_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_TPMCAP_CAPABID_MASK) | (((uint32_t)val) << DM_CORE_TPMCAP_CAPABID_SHIFT))

//====================================================================
//Register: Core Target Power Management Control and Status Register (TPMCSR)
/** \brief Power Management Control and Status Register.*/
//====================================================================

#define  DM_CORE_TPMCSR_RESERVED1_MASK 0xffff0000
#define  DM_CORE_TPMCSR_RESERVED1_SHIFT 16
#define  DM_CORE_TPMCSR_RESERVED1_MASK_SHIFT(reg) (((reg) & DM_CORE_TPMCSR_RESERVED1_MASK) >> DM_CORE_TPMCSR_RESERVED1_SHIFT)
#define  DM_CORE_TPMCSR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_TPMCSR_RESERVED1_MASK) | (((uint32_t)val) << DM_CORE_TPMCSR_RESERVED1_SHIFT))

#define  DM_CORE_TPMCSR_PMESTAT_MASK 0x8000
#define  DM_CORE_TPMCSR_PMESTAT_SHIFT 15
#define  DM_CORE_TPMCSR_PMESTAT_MASK_SHIFT(reg) (((reg) & DM_CORE_TPMCSR_PMESTAT_MASK) >> DM_CORE_TPMCSR_PMESTAT_SHIFT)
#define  DM_CORE_TPMCSR_PMESTAT_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_TPMCSR_PMESTAT_MASK) | (((uint32_t)val) << DM_CORE_TPMCSR_PMESTAT_SHIFT))

#define  DM_CORE_TPMCSR_RESERVED2_MASK 0x7e00
#define  DM_CORE_TPMCSR_RESERVED2_SHIFT 9
#define  DM_CORE_TPMCSR_RESERVED2_MASK_SHIFT(reg) (((reg) & DM_CORE_TPMCSR_RESERVED2_MASK) >> DM_CORE_TPMCSR_RESERVED2_SHIFT)
#define  DM_CORE_TPMCSR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_TPMCSR_RESERVED2_MASK) | (((uint32_t)val) << DM_CORE_TPMCSR_RESERVED2_SHIFT))

#define  DM_CORE_TPMCSR_PME_EN_MASK 0x100
#define  DM_CORE_TPMCSR_PME_EN_SHIFT 8
#define  DM_CORE_TPMCSR_PME_EN_MASK_SHIFT(reg) (((reg) & DM_CORE_TPMCSR_PME_EN_MASK) >> DM_CORE_TPMCSR_PME_EN_SHIFT)
#define  DM_CORE_TPMCSR_PME_EN_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_TPMCSR_PME_EN_MASK) | (((uint32_t)val) << DM_CORE_TPMCSR_PME_EN_SHIFT))

#define  DM_CORE_TPMCSR_RESERVED3_MASK 0xfc
#define  DM_CORE_TPMCSR_RESERVED3_SHIFT 2
#define  DM_CORE_TPMCSR_RESERVED3_MASK_SHIFT(reg) (((reg) & DM_CORE_TPMCSR_RESERVED3_MASK) >> DM_CORE_TPMCSR_RESERVED3_SHIFT)
#define  DM_CORE_TPMCSR_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_TPMCSR_RESERVED3_MASK) | (((uint32_t)val) << DM_CORE_TPMCSR_RESERVED3_SHIFT))

#define  DM_CORE_TPMCSR_PWRSTATE_MASK 0x3
#define  DM_CORE_TPMCSR_PWRSTATE_SHIFT 0
#define  DM_CORE_TPMCSR_PWRSTATE_MASK_SHIFT(reg) (((reg) & DM_CORE_TPMCSR_PWRSTATE_MASK) >> DM_CORE_TPMCSR_PWRSTATE_SHIFT)
#define  DM_CORE_TPMCSR_PWRSTATE_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_TPMCSR_PWRSTATE_MASK) | (((uint32_t)val) << DM_CORE_TPMCSR_PWRSTATE_SHIFT))

//====================================================================
//Register: Core Target MSI Capabilities Control Register (TMsiCtrl)
/** \brief MSI Capabilities Control Register.*/
//====================================================================

#define  DM_CORE_TMSICTRL_RESERVED1_MASK 0xff800000
#define  DM_CORE_TMSICTRL_RESERVED1_SHIFT 23
#define  DM_CORE_TMSICTRL_RESERVED1_MASK_SHIFT(reg) (((reg) & DM_CORE_TMSICTRL_RESERVED1_MASK) >> DM_CORE_TMSICTRL_RESERVED1_SHIFT)
#define  DM_CORE_TMSICTRL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_TMSICTRL_RESERVED1_MASK) | (((uint32_t)val) << DM_CORE_TMSICTRL_RESERVED1_SHIFT))

#define  DM_CORE_TMSICTRL_MULTMSGEN_MASK 0x700000
#define  DM_CORE_TMSICTRL_MULTMSGEN_SHIFT 20
#define  DM_CORE_TMSICTRL_MULTMSGEN_MASK_SHIFT(reg) (((reg) & DM_CORE_TMSICTRL_MULTMSGEN_MASK) >> DM_CORE_TMSICTRL_MULTMSGEN_SHIFT)
#define  DM_CORE_TMSICTRL_MULTMSGEN_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_TMSICTRL_MULTMSGEN_MASK) | (((uint32_t)val) << DM_CORE_TMSICTRL_MULTMSGEN_SHIFT))

#define  DM_CORE_TMSICTRL_MULTMSGCAP_MASK 0xe0000
#define  DM_CORE_TMSICTRL_MULTMSGCAP_SHIFT 17
#define  DM_CORE_TMSICTRL_MULTMSGCAP_MASK_SHIFT(reg) (((reg) & DM_CORE_TMSICTRL_MULTMSGCAP_MASK) >> DM_CORE_TMSICTRL_MULTMSGCAP_SHIFT)
#define  DM_CORE_TMSICTRL_MULTMSGCAP_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_TMSICTRL_MULTMSGCAP_MASK) | (((uint32_t)val) << DM_CORE_TMSICTRL_MULTMSGCAP_SHIFT))

#define  DM_CORE_TMSICTRL_MSIEN_MASK 0x10000
#define  DM_CORE_TMSICTRL_MSIEN_SHIFT 16
#define  DM_CORE_TMSICTRL_MSIEN_MASK_SHIFT(reg) (((reg) & DM_CORE_TMSICTRL_MSIEN_MASK) >> DM_CORE_TMSICTRL_MSIEN_SHIFT)
#define  DM_CORE_TMSICTRL_MSIEN_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_TMSICTRL_MSIEN_MASK) | (((uint32_t)val) << DM_CORE_TMSICTRL_MSIEN_SHIFT))

#define  DM_CORE_TMSICTRL_NEXTCAPPTR_MASK 0xff00
#define  DM_CORE_TMSICTRL_NEXTCAPPTR_SHIFT 8
#define  DM_CORE_TMSICTRL_NEXTCAPPTR_MASK_SHIFT(reg) (((reg) & DM_CORE_TMSICTRL_NEXTCAPPTR_MASK) >> DM_CORE_TMSICTRL_NEXTCAPPTR_SHIFT)
#define  DM_CORE_TMSICTRL_NEXTCAPPTR_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_TMSICTRL_NEXTCAPPTR_MASK) | (((uint32_t)val) << DM_CORE_TMSICTRL_NEXTCAPPTR_SHIFT))

#define  DM_CORE_TMSICTRL_CAPABID_MASK 0xff
#define  DM_CORE_TMSICTRL_CAPABID_SHIFT 0
#define  DM_CORE_TMSICTRL_CAPABID_MASK_SHIFT(reg) (((reg) & DM_CORE_TMSICTRL_CAPABID_MASK) >> DM_CORE_TMSICTRL_CAPABID_SHIFT)
#define  DM_CORE_TMSICTRL_CAPABID_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_TMSICTRL_CAPABID_MASK) | (((uint32_t)val) << DM_CORE_TMSICTRL_CAPABID_SHIFT))

//====================================================================
//Register: Core Target MSI Capabilities  Address Register (TMsiAddr)
/** \brief MSI Capabilities Message Address.*/
//====================================================================

#define  DM_CORE_TMSIADDR_ADDRESS_MASK 0xffffffff
#define  DM_CORE_TMSIADDR_ADDRESS_SHIFT 0
#define  DM_CORE_TMSIADDR_ADDRESS_MASK_SHIFT(reg) (((reg) & DM_CORE_TMSIADDR_ADDRESS_MASK) >> DM_CORE_TMSIADDR_ADDRESS_SHIFT)
#define  DM_CORE_TMSIADDR_ADDRESS_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_TMSIADDR_ADDRESS_MASK) | (((uint32_t)val) << DM_CORE_TMSIADDR_ADDRESS_SHIFT))

//====================================================================
//Register: Core Target MSI Capabilities Data  Register (TMsiData)
/** \brief MSI Capabilities Message Data*/
//====================================================================

#define  DM_CORE_TMSIDATA_RESERVED1_MASK 0xffff0000
#define  DM_CORE_TMSIDATA_RESERVED1_SHIFT 16
#define  DM_CORE_TMSIDATA_RESERVED1_MASK_SHIFT(reg) (((reg) & DM_CORE_TMSIDATA_RESERVED1_MASK) >> DM_CORE_TMSIDATA_RESERVED1_SHIFT)
#define  DM_CORE_TMSIDATA_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_TMSIDATA_RESERVED1_MASK) | (((uint32_t)val) << DM_CORE_TMSIDATA_RESERVED1_SHIFT))

#define  DM_CORE_TMSIDATA_DATA_MASK 0xffff
#define  DM_CORE_TMSIDATA_DATA_SHIFT 0
#define  DM_CORE_TMSIDATA_DATA_MASK_SHIFT(reg) (((reg) & DM_CORE_TMSIDATA_DATA_MASK) >> DM_CORE_TMSIDATA_DATA_SHIFT)
#define  DM_CORE_TMSIDATA_DATA_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_TMSIDATA_DATA_MASK) | (((uint32_t)val) << DM_CORE_TMSIDATA_DATA_SHIFT))

//====================================================================
//Register: Core Target PCIE Capabilities Register (TPCIECap)
/** \brief PCI Express Capabilities Register.*/
//====================================================================

#define  DM_CORE_TPCIECAP_PCIECAP_MASK 0xffff0000
#define  DM_CORE_TPCIECAP_PCIECAP_SHIFT 16
#define  DM_CORE_TPCIECAP_PCIECAP_MASK_SHIFT(reg) (((reg) & DM_CORE_TPCIECAP_PCIECAP_MASK) >> DM_CORE_TPCIECAP_PCIECAP_SHIFT)
#define  DM_CORE_TPCIECAP_PCIECAP_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_TPCIECAP_PCIECAP_MASK) | (((uint32_t)val) << DM_CORE_TPCIECAP_PCIECAP_SHIFT))

#define  DM_CORE_TPCIECAP_NEXTCAPPTR_MASK 0xff00
#define  DM_CORE_TPCIECAP_NEXTCAPPTR_SHIFT 8
#define  DM_CORE_TPCIECAP_NEXTCAPPTR_MASK_SHIFT(reg) (((reg) & DM_CORE_TPCIECAP_NEXTCAPPTR_MASK) >> DM_CORE_TPCIECAP_NEXTCAPPTR_SHIFT)
#define  DM_CORE_TPCIECAP_NEXTCAPPTR_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_TPCIECAP_NEXTCAPPTR_MASK) | (((uint32_t)val) << DM_CORE_TPCIECAP_NEXTCAPPTR_SHIFT))

#define  DM_CORE_TPCIECAP_CAPABID_MASK 0xff
#define  DM_CORE_TPCIECAP_CAPABID_SHIFT 0
#define  DM_CORE_TPCIECAP_CAPABID_MASK_SHIFT(reg) (((reg) & DM_CORE_TPCIECAP_CAPABID_MASK) >> DM_CORE_TPCIECAP_CAPABID_SHIFT)
#define  DM_CORE_TPCIECAP_CAPABID_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_TPCIECAP_CAPABID_MASK) | (((uint32_t)val) << DM_CORE_TPCIECAP_CAPABID_SHIFT))

//====================================================================
//Register: Core Target Device Capability Register (TDevCap)
/** \brief Device Capability Register.*/
//====================================================================

#define  DM_CORE_TDEVCAP_DEVCAP_MASK 0xffffffff
#define  DM_CORE_TDEVCAP_DEVCAP_SHIFT 0
#define  DM_CORE_TDEVCAP_DEVCAP_MASK_SHIFT(reg) (((reg) & DM_CORE_TDEVCAP_DEVCAP_MASK) >> DM_CORE_TDEVCAP_DEVCAP_SHIFT)
#define  DM_CORE_TDEVCAP_DEVCAP_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_TDEVCAP_DEVCAP_MASK) | (((uint32_t)val) << DM_CORE_TDEVCAP_DEVCAP_SHIFT))

//====================================================================
//Register: Core Target Device Control and Status Register (TDevContStatus)
/** \brief PCI Express Capability Device Control and Status Register.*/
//====================================================================

#define  DM_CORE_TDEVCONTSTATUS_STATUS_MASK 0xffff0000
#define  DM_CORE_TDEVCONTSTATUS_STATUS_SHIFT 16
#define  DM_CORE_TDEVCONTSTATUS_STATUS_MASK_SHIFT(reg) (((reg) & DM_CORE_TDEVCONTSTATUS_STATUS_MASK) >> DM_CORE_TDEVCONTSTATUS_STATUS_SHIFT)
#define  DM_CORE_TDEVCONTSTATUS_STATUS_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_TDEVCONTSTATUS_STATUS_MASK) | (((uint32_t)val) << DM_CORE_TDEVCONTSTATUS_STATUS_SHIFT))

#define  DM_CORE_TDEVCONTSTATUS_CONTROL_MASK 0xffff
#define  DM_CORE_TDEVCONTSTATUS_CONTROL_SHIFT 0
#define  DM_CORE_TDEVCONTSTATUS_CONTROL_MASK_SHIFT(reg) (((reg) & DM_CORE_TDEVCONTSTATUS_CONTROL_MASK) >> DM_CORE_TDEVCONTSTATUS_CONTROL_SHIFT)
#define  DM_CORE_TDEVCONTSTATUS_CONTROL_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_TDEVCONTSTATUS_CONTROL_MASK) | (((uint32_t)val) << DM_CORE_TDEVCONTSTATUS_CONTROL_SHIFT))

//====================================================================
//Register: Core Target Device Link Capabilities Register (TDevLinkCap)
/** \brief PCI Express Link Capabilities Register.*/
//====================================================================

#define  DM_CORE_TDEVLINKCAP_DEVLINKCAP_MASK 0xffffffff
#define  DM_CORE_TDEVLINKCAP_DEVLINKCAP_SHIFT 0
#define  DM_CORE_TDEVLINKCAP_DEVLINKCAP_MASK_SHIFT(reg) (((reg) & DM_CORE_TDEVLINKCAP_DEVLINKCAP_MASK) >> DM_CORE_TDEVLINKCAP_DEVLINKCAP_SHIFT)
#define  DM_CORE_TDEVLINKCAP_DEVLINKCAP_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_TDEVLINKCAP_DEVLINKCAP_MASK) | (((uint32_t)val) << DM_CORE_TDEVLINKCAP_DEVLINKCAP_SHIFT))

//====================================================================
//Register: Core Target Link Control and Status Register (TLinkContStatus)
/** \brief PCI Express Capability Device Control and Status Register.*/
//====================================================================

#define  DM_CORE_TLINKCONTSTATUS_STATUS_MASK 0xffff0000
#define  DM_CORE_TLINKCONTSTATUS_STATUS_SHIFT 16
#define  DM_CORE_TLINKCONTSTATUS_STATUS_MASK_SHIFT(reg) (((reg) & DM_CORE_TLINKCONTSTATUS_STATUS_MASK) >> DM_CORE_TLINKCONTSTATUS_STATUS_SHIFT)
#define  DM_CORE_TLINKCONTSTATUS_STATUS_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_TLINKCONTSTATUS_STATUS_MASK) | (((uint32_t)val) << DM_CORE_TLINKCONTSTATUS_STATUS_SHIFT))

#define  DM_CORE_TLINKCONTSTATUS_CONTROL_MASK 0xffff
#define  DM_CORE_TLINKCONTSTATUS_CONTROL_SHIFT 0
#define  DM_CORE_TLINKCONTSTATUS_CONTROL_MASK_SHIFT(reg) (((reg) & DM_CORE_TLINKCONTSTATUS_CONTROL_MASK) >> DM_CORE_TLINKCONTSTATUS_CONTROL_SHIFT)
#define  DM_CORE_TLINKCONTSTATUS_CONTROL_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_TLINKCONTSTATUS_CONTROL_MASK) | (((uint32_t)val) << DM_CORE_TLINKCONTSTATUS_CONTROL_SHIFT))

//====================================================================
//Register: Core Target Device Capability2 Register (TDevCap2)
/** \brief Device Capability2 Register.*/
//====================================================================

#define  DM_CORE_TDEVCAP2_DEVCAP2_MASK 0xffffffff
#define  DM_CORE_TDEVCAP2_DEVCAP2_SHIFT 0
#define  DM_CORE_TDEVCAP2_DEVCAP2_MASK_SHIFT(reg) (((reg) & DM_CORE_TDEVCAP2_DEVCAP2_MASK) >> DM_CORE_TDEVCAP2_DEVCAP2_SHIFT)
#define  DM_CORE_TDEVCAP2_DEVCAP2_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_TDEVCAP2_DEVCAP2_MASK) | (((uint32_t)val) << DM_CORE_TDEVCAP2_DEVCAP2_SHIFT))

//====================================================================
//Register: Core Target Device Control and Status2 Register (TDevContStatus2)
/** \brief PCI Express Capability Device Control and Status2 Register.*/
//====================================================================

#define  DM_CORE_TDEVCONTSTATUS2_STATUS2_MASK 0xffff0000
#define  DM_CORE_TDEVCONTSTATUS2_STATUS2_SHIFT 16
#define  DM_CORE_TDEVCONTSTATUS2_STATUS2_MASK_SHIFT(reg) (((reg) & DM_CORE_TDEVCONTSTATUS2_STATUS2_MASK) >> DM_CORE_TDEVCONTSTATUS2_STATUS2_SHIFT)
#define  DM_CORE_TDEVCONTSTATUS2_STATUS2_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_TDEVCONTSTATUS2_STATUS2_MASK) | (((uint32_t)val) << DM_CORE_TDEVCONTSTATUS2_STATUS2_SHIFT))

#define  DM_CORE_TDEVCONTSTATUS2_CONTROL2_MASK 0xffff
#define  DM_CORE_TDEVCONTSTATUS2_CONTROL2_SHIFT 0
#define  DM_CORE_TDEVCONTSTATUS2_CONTROL2_MASK_SHIFT(reg) (((reg) & DM_CORE_TDEVCONTSTATUS2_CONTROL2_MASK) >> DM_CORE_TDEVCONTSTATUS2_CONTROL2_SHIFT)
#define  DM_CORE_TDEVCONTSTATUS2_CONTROL2_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_TDEVCONTSTATUS2_CONTROL2_MASK) | (((uint32_t)val) << DM_CORE_TDEVCONTSTATUS2_CONTROL2_SHIFT))

//====================================================================
//Register: Core Target Device Link Capabilities2 Register (TDevLinkCap2)
/** \brief PCI Express Link Capabilities2 Register.*/
//====================================================================

#define  DM_CORE_TDEVLINKCAP2_DEVLINKCAP2_MASK 0xffffffff
#define  DM_CORE_TDEVLINKCAP2_DEVLINKCAP2_SHIFT 0
#define  DM_CORE_TDEVLINKCAP2_DEVLINKCAP2_MASK_SHIFT(reg) (((reg) & DM_CORE_TDEVLINKCAP2_DEVLINKCAP2_MASK) >> DM_CORE_TDEVLINKCAP2_DEVLINKCAP2_SHIFT)
#define  DM_CORE_TDEVLINKCAP2_DEVLINKCAP2_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_TDEVLINKCAP2_DEVLINKCAP2_MASK) | (((uint32_t)val) << DM_CORE_TDEVLINKCAP2_DEVLINKCAP2_SHIFT))

//====================================================================
//Register: Core Target Link Control and Status2 Register (TLinkContStatus2)
/** \brief PCI Express Capability Device Control and Status2 Register.*/
//====================================================================

#define  DM_CORE_TLINKCONTSTATUS2_STATUS2_MASK 0xffff0000
#define  DM_CORE_TLINKCONTSTATUS2_STATUS2_SHIFT 16
#define  DM_CORE_TLINKCONTSTATUS2_STATUS2_MASK_SHIFT(reg) (((reg) & DM_CORE_TLINKCONTSTATUS2_STATUS2_MASK) >> DM_CORE_TLINKCONTSTATUS2_STATUS2_SHIFT)
#define  DM_CORE_TLINKCONTSTATUS2_STATUS2_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_TLINKCONTSTATUS2_STATUS2_MASK) | (((uint32_t)val) << DM_CORE_TLINKCONTSTATUS2_STATUS2_SHIFT))

#define  DM_CORE_TLINKCONTSTATUS2_CONTROL2_MASK 0xffff
#define  DM_CORE_TLINKCONTSTATUS2_CONTROL2_SHIFT 0
#define  DM_CORE_TLINKCONTSTATUS2_CONTROL2_MASK_SHIFT(reg) (((reg) & DM_CORE_TLINKCONTSTATUS2_CONTROL2_MASK) >> DM_CORE_TLINKCONTSTATUS2_CONTROL2_SHIFT)
#define  DM_CORE_TLINKCONTSTATUS2_CONTROL2_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_TLINKCONTSTATUS2_CONTROL2_MASK) | (((uint32_t)val) << DM_CORE_TLINKCONTSTATUS2_CONTROL2_SHIFT))

//====================================================================
//Register: Core Target AER Capabilities Register (TAERCap)
/** \brief PCI Express AER Enhanced Capability Header Register.*/
//====================================================================

#define  DM_CORE_TAERCAP_AERHDR_MASK 0xffffffff
#define  DM_CORE_TAERCAP_AERHDR_SHIFT 0
#define  DM_CORE_TAERCAP_AERHDR_MASK_SHIFT(reg) (((reg) & DM_CORE_TAERCAP_AERHDR_MASK) >> DM_CORE_TAERCAP_AERHDR_SHIFT)
#define  DM_CORE_TAERCAP_AERHDR_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_TAERCAP_AERHDR_MASK) | (((uint32_t)val) << DM_CORE_TAERCAP_AERHDR_SHIFT))

//====================================================================
//Register: Core Target Uncorrectable Error Status Register (TUCorrStat)
/** \brief PCI Express AER Uncorrectable Error Status Register.*/
//====================================================================

#define  DM_CORE_TUCORRSTAT_UCORRESTAT_MASK 0xffffffff
#define  DM_CORE_TUCORRSTAT_UCORRESTAT_SHIFT 0
#define  DM_CORE_TUCORRSTAT_UCORRESTAT_MASK_SHIFT(reg) (((reg) & DM_CORE_TUCORRSTAT_UCORRESTAT_MASK) >> DM_CORE_TUCORRSTAT_UCORRESTAT_SHIFT)
#define  DM_CORE_TUCORRSTAT_UCORRESTAT_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_TUCORRSTAT_UCORRESTAT_MASK) | (((uint32_t)val) << DM_CORE_TUCORRSTAT_UCORRESTAT_SHIFT))

//====================================================================
//Register: Core Target Uncorrectable Error Mask Register (TUCorrMask)
/** \brief PCI Express AER Uncorrectable Error Mask Register.*/
//====================================================================

#define  DM_CORE_TUCORRMASK_UCORREMASK_MASK 0xffffffff
#define  DM_CORE_TUCORRMASK_UCORREMASK_SHIFT 0
#define  DM_CORE_TUCORRMASK_UCORREMASK_MASK_SHIFT(reg) (((reg) & DM_CORE_TUCORRMASK_UCORREMASK_MASK) >> DM_CORE_TUCORRMASK_UCORREMASK_SHIFT)
#define  DM_CORE_TUCORRMASK_UCORREMASK_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_TUCORRMASK_UCORREMASK_MASK) | (((uint32_t)val) << DM_CORE_TUCORRMASK_UCORREMASK_SHIFT))

//====================================================================
//Register: Core Target Uncorrectable Error Severity Register (TUCorrSev)
/** \brief PCI Express AER Uncorrectable Error Severity Register.*/
//====================================================================

#define  DM_CORE_TUCORRSEV_UCORRESEV_MASK 0xffffffff
#define  DM_CORE_TUCORRSEV_UCORRESEV_SHIFT 0
#define  DM_CORE_TUCORRSEV_UCORRESEV_MASK_SHIFT(reg) (((reg) & DM_CORE_TUCORRSEV_UCORRESEV_MASK) >> DM_CORE_TUCORRSEV_UCORRESEV_SHIFT)
#define  DM_CORE_TUCORRSEV_UCORRESEV_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_TUCORRSEV_UCORRESEV_MASK) | (((uint32_t)val) << DM_CORE_TUCORRSEV_UCORRESEV_SHIFT))

//====================================================================
//Register: Core Target Correctable Error Status Register (TCorrStat)
/** \brief PCI Express AER Correctable Error Status Register.*/
//====================================================================

#define  DM_CORE_TCORRSTAT_CORRESTAT_MASK 0xffffffff
#define  DM_CORE_TCORRSTAT_CORRESTAT_SHIFT 0
#define  DM_CORE_TCORRSTAT_CORRESTAT_MASK_SHIFT(reg) (((reg) & DM_CORE_TCORRSTAT_CORRESTAT_MASK) >> DM_CORE_TCORRSTAT_CORRESTAT_SHIFT)
#define  DM_CORE_TCORRSTAT_CORRESTAT_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_TCORRSTAT_CORRESTAT_MASK) | (((uint32_t)val) << DM_CORE_TCORRSTAT_CORRESTAT_SHIFT))

//====================================================================
//Register: Core Target Correctable Error Mask Register (TCorrMask)
/** \brief PCI Express AER Correctable Error Mask Register.*/
//====================================================================

#define  DM_CORE_TCORRMASK_CORREMASK_MASK 0xffffffff
#define  DM_CORE_TCORRMASK_CORREMASK_SHIFT 0
#define  DM_CORE_TCORRMASK_CORREMASK_MASK_SHIFT(reg) (((reg) & DM_CORE_TCORRMASK_CORREMASK_MASK) >> DM_CORE_TCORRMASK_CORREMASK_SHIFT)
#define  DM_CORE_TCORRMASK_CORREMASK_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_TCORRMASK_CORREMASK_MASK) | (((uint32_t)val) << DM_CORE_TCORRMASK_CORREMASK_SHIFT))

//====================================================================
//Register: Core Target AER Capabilities and Control Register (TAERCapCtrl)
/** \brief PCI Express AER Capabilities and Control Register.*/
//====================================================================

#define  DM_CORE_TAERCAPCTRL_CAPCTRL_MASK 0xffffffff
#define  DM_CORE_TAERCAPCTRL_CAPCTRL_SHIFT 0
#define  DM_CORE_TAERCAPCTRL_CAPCTRL_MASK_SHIFT(reg) (((reg) & DM_CORE_TAERCAPCTRL_CAPCTRL_MASK) >> DM_CORE_TAERCAPCTRL_CAPCTRL_SHIFT)
#define  DM_CORE_TAERCAPCTRL_CAPCTRL_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_TAERCAPCTRL_CAPCTRL_MASK) | (((uint32_t)val) << DM_CORE_TAERCAPCTRL_CAPCTRL_SHIFT))

//====================================================================
//Register: Core Target Header Log Register (first DWORD) (THeaderLog1)
/** \brief PCI Express Header Log Register, 1st doubleword (32 bits) of 4.*/
//====================================================================

#define  DM_CORE_THEADERLOG1_LOG_MASK 0xffffffff
#define  DM_CORE_THEADERLOG1_LOG_SHIFT 0
#define  DM_CORE_THEADERLOG1_LOG_MASK_SHIFT(reg) (((reg) & DM_CORE_THEADERLOG1_LOG_MASK) >> DM_CORE_THEADERLOG1_LOG_SHIFT)
#define  DM_CORE_THEADERLOG1_LOG_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_THEADERLOG1_LOG_MASK) | (((uint32_t)val) << DM_CORE_THEADERLOG1_LOG_SHIFT))

//====================================================================
//Register: Core Target Header Log Register (second DWORD) (THeaderLog2)
/** \brief PCI Express Header Log Register, 2nd doubleword (32 bits) of 4.*/
//====================================================================

#define  DM_CORE_THEADERLOG2_LOG_MASK 0xffffffff
#define  DM_CORE_THEADERLOG2_LOG_SHIFT 0
#define  DM_CORE_THEADERLOG2_LOG_MASK_SHIFT(reg) (((reg) & DM_CORE_THEADERLOG2_LOG_MASK) >> DM_CORE_THEADERLOG2_LOG_SHIFT)
#define  DM_CORE_THEADERLOG2_LOG_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_THEADERLOG2_LOG_MASK) | (((uint32_t)val) << DM_CORE_THEADERLOG2_LOG_SHIFT))

//====================================================================
//Register: Core Target Header Log Register (third DWORD) (THeaderLog3)
/** \brief PCI Express Header Log Register, 3rd doubleword (32 bits) of 4.*/
//====================================================================

#define  DM_CORE_THEADERLOG3_LOG_MASK 0xffffffff
#define  DM_CORE_THEADERLOG3_LOG_SHIFT 0
#define  DM_CORE_THEADERLOG3_LOG_MASK_SHIFT(reg) (((reg) & DM_CORE_THEADERLOG3_LOG_MASK) >> DM_CORE_THEADERLOG3_LOG_SHIFT)
#define  DM_CORE_THEADERLOG3_LOG_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_THEADERLOG3_LOG_MASK) | (((uint32_t)val) << DM_CORE_THEADERLOG3_LOG_SHIFT))

//====================================================================
//Register: Core Target Header Log Register (fourth DWORD) (THeaderLog4)
/** \brief PCI Express Header Log Register, 4th doubleword (32 bits) of 4.*/
//====================================================================

#define  DM_CORE_THEADERLOG4_LOG_MASK 0xffffffff
#define  DM_CORE_THEADERLOG4_LOG_SHIFT 0
#define  DM_CORE_THEADERLOG4_LOG_MASK_SHIFT(reg) (((reg) & DM_CORE_THEADERLOG4_LOG_MASK) >> DM_CORE_THEADERLOG4_LOG_SHIFT)
#define  DM_CORE_THEADERLOG4_LOG_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_THEADERLOG4_LOG_MASK) | (((uint32_t)val) << DM_CORE_THEADERLOG4_LOG_SHIFT))

//====================================================================
//Register: Core Local Configuration Register 00 (LCfg00)
/** \brief Start of the Core Local EP Cfg Header Space per PCIe 2.0 Specification for Type 0/1 Headers*/
//====================================================================

#define  DM_CORE_LCFG00_DEVICEID_MASK 0xffff0000
#define  DM_CORE_LCFG00_DEVICEID_SHIFT 16
#define  DM_CORE_LCFG00_DEVICEID_MASK_SHIFT(reg) (((reg) & DM_CORE_LCFG00_DEVICEID_MASK) >> DM_CORE_LCFG00_DEVICEID_SHIFT)
#define  DM_CORE_LCFG00_DEVICEID_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_LCFG00_DEVICEID_MASK) | (((uint32_t)val) << DM_CORE_LCFG00_DEVICEID_SHIFT))

#define  DM_CORE_LCFG00_VENDORID_MASK 0xffff
#define  DM_CORE_LCFG00_VENDORID_SHIFT 0
#define  DM_CORE_LCFG00_VENDORID_MASK_SHIFT(reg) (((reg) & DM_CORE_LCFG00_VENDORID_MASK) >> DM_CORE_LCFG00_VENDORID_SHIFT)
#define  DM_CORE_LCFG00_VENDORID_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_LCFG00_VENDORID_MASK) | (((uint32_t)val) << DM_CORE_LCFG00_VENDORID_SHIFT))

//====================================================================
//Register: Core Local Configuration Register 04 (LCfg04)
/** \brief Status and Command Registers for Type 0/1 Header*/
//====================================================================

#define  DM_CORE_LCFG04_STATUS_MASK 0xffff0000
#define  DM_CORE_LCFG04_STATUS_SHIFT 16
#define  DM_CORE_LCFG04_STATUS_MASK_SHIFT(reg) (((reg) & DM_CORE_LCFG04_STATUS_MASK) >> DM_CORE_LCFG04_STATUS_SHIFT)
#define  DM_CORE_LCFG04_STATUS_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_LCFG04_STATUS_MASK) | (((uint32_t)val) << DM_CORE_LCFG04_STATUS_SHIFT))

#define  DM_CORE_LCFG04_COMMAND_MASK 0xffff
#define  DM_CORE_LCFG04_COMMAND_SHIFT 0
#define  DM_CORE_LCFG04_COMMAND_MASK_SHIFT(reg) (((reg) & DM_CORE_LCFG04_COMMAND_MASK) >> DM_CORE_LCFG04_COMMAND_SHIFT)
#define  DM_CORE_LCFG04_COMMAND_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_LCFG04_COMMAND_MASK) | (((uint32_t)val) << DM_CORE_LCFG04_COMMAND_SHIFT))

//====================================================================
//Register: Core Local Configuration Register 08 (LCfg08)
/** \brief Class Code and Revision ID for Type 0/1 Header*/
//====================================================================

#define  DM_CORE_LCFG08_CLASSCODE_MASK 0xffffff00
#define  DM_CORE_LCFG08_CLASSCODE_SHIFT 8
#define  DM_CORE_LCFG08_CLASSCODE_MASK_SHIFT(reg) (((reg) & DM_CORE_LCFG08_CLASSCODE_MASK) >> DM_CORE_LCFG08_CLASSCODE_SHIFT)
#define  DM_CORE_LCFG08_CLASSCODE_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_LCFG08_CLASSCODE_MASK) | (((uint32_t)val) << DM_CORE_LCFG08_CLASSCODE_SHIFT))

#define  DM_CORE_LCFG08_REVID_MASK 0xff
#define  DM_CORE_LCFG08_REVID_SHIFT 0
#define  DM_CORE_LCFG08_REVID_MASK_SHIFT(reg) (((reg) & DM_CORE_LCFG08_REVID_MASK) >> DM_CORE_LCFG08_REVID_SHIFT)
#define  DM_CORE_LCFG08_REVID_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_LCFG08_REVID_MASK) | (((uint32_t)val) << DM_CORE_LCFG08_REVID_SHIFT))

//====================================================================
//Register: Core Local Configuration Register 0C (LCfg0C)
/** \brief BIST, Header Type, Latency Timer and Cacheline Size for Type 0/1 Header*/
//====================================================================

#define  DM_CORE_LCFG0C_BIST_MASK 0xff000000
#define  DM_CORE_LCFG0C_BIST_SHIFT 24
#define  DM_CORE_LCFG0C_BIST_MASK_SHIFT(reg) (((reg) & DM_CORE_LCFG0C_BIST_MASK) >> DM_CORE_LCFG0C_BIST_SHIFT)
#define  DM_CORE_LCFG0C_BIST_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_LCFG0C_BIST_MASK) | (((uint32_t)val) << DM_CORE_LCFG0C_BIST_SHIFT))

#define  DM_CORE_LCFG0C_HDRTYPE_MASK 0xff0000
#define  DM_CORE_LCFG0C_HDRTYPE_SHIFT 16
#define  DM_CORE_LCFG0C_HDRTYPE_MASK_SHIFT(reg) (((reg) & DM_CORE_LCFG0C_HDRTYPE_MASK) >> DM_CORE_LCFG0C_HDRTYPE_SHIFT)
#define  DM_CORE_LCFG0C_HDRTYPE_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_LCFG0C_HDRTYPE_MASK) | (((uint32_t)val) << DM_CORE_LCFG0C_HDRTYPE_SHIFT))

#define  DM_CORE_LCFG0C_LATTIMER_MASK 0xff00
#define  DM_CORE_LCFG0C_LATTIMER_SHIFT 8
#define  DM_CORE_LCFG0C_LATTIMER_MASK_SHIFT(reg) (((reg) & DM_CORE_LCFG0C_LATTIMER_MASK) >> DM_CORE_LCFG0C_LATTIMER_SHIFT)
#define  DM_CORE_LCFG0C_LATTIMER_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_LCFG0C_LATTIMER_MASK) | (((uint32_t)val) << DM_CORE_LCFG0C_LATTIMER_SHIFT))

#define  DM_CORE_LCFG0C_CACHELINESIZE_MASK 0xff
#define  DM_CORE_LCFG0C_CACHELINESIZE_SHIFT 0
#define  DM_CORE_LCFG0C_CACHELINESIZE_MASK_SHIFT(reg) (((reg) & DM_CORE_LCFG0C_CACHELINESIZE_MASK) >> DM_CORE_LCFG0C_CACHELINESIZE_SHIFT)
#define  DM_CORE_LCFG0C_CACHELINESIZE_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_LCFG0C_CACHELINESIZE_MASK) | (((uint32_t)val) << DM_CORE_LCFG0C_CACHELINESIZE_SHIFT))

//====================================================================
//Register: Core Local Configuration Register 10 is BAR0 (LCfg10)
/** \brief BAR0 Register*/
//====================================================================

#define  DM_CORE_LCFG10_BAR0_MASK 0xffffffff
#define  DM_CORE_LCFG10_BAR0_SHIFT 0
#define  DM_CORE_LCFG10_BAR0_MASK_SHIFT(reg) (((reg) & DM_CORE_LCFG10_BAR0_MASK) >> DM_CORE_LCFG10_BAR0_SHIFT)
#define  DM_CORE_LCFG10_BAR0_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_LCFG10_BAR0_MASK) | (((uint32_t)val) << DM_CORE_LCFG10_BAR0_SHIFT))

//====================================================================
//Register: Core Local Configuration Register 14 is BAR1 (LCfg14)
/** \brief BAR0 Register*/
//====================================================================

#define  DM_CORE_LCFG14_BAR1_MASK 0xffffffff
#define  DM_CORE_LCFG14_BAR1_SHIFT 0
#define  DM_CORE_LCFG14_BAR1_MASK_SHIFT(reg) (((reg) & DM_CORE_LCFG14_BAR1_MASK) >> DM_CORE_LCFG14_BAR1_SHIFT)
#define  DM_CORE_LCFG14_BAR1_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_LCFG14_BAR1_MASK) | (((uint32_t)val) << DM_CORE_LCFG14_BAR1_SHIFT))

//====================================================================
//Register: Core Local Configuration BAR0 Mask Register (LCfg10M)
/** \brief BAR0 Mask Register*/
//====================================================================

#define  DM_CORE_LCFG10M_BAR0MASK_MASK 0xffffffff
#define  DM_CORE_LCFG10M_BAR0MASK_SHIFT 0
#define  DM_CORE_LCFG10M_BAR0MASK_MASK_SHIFT(reg) (((reg) & DM_CORE_LCFG10M_BAR0MASK_MASK) >> DM_CORE_LCFG10M_BAR0MASK_SHIFT)
#define  DM_CORE_LCFG10M_BAR0MASK_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_LCFG10M_BAR0MASK_MASK) | (((uint32_t)val) << DM_CORE_LCFG10M_BAR0MASK_SHIFT))

//====================================================================
//Register: Core Local Configuration BAR1 Mask Register (LCfg14M)
/** \brief BAR1 Mask Register*/
//====================================================================

#define  DM_CORE_LCFG14M_BAR1MASK_MASK 0xffffffff
#define  DM_CORE_LCFG14M_BAR1MASK_SHIFT 0
#define  DM_CORE_LCFG14M_BAR1MASK_MASK_SHIFT(reg) (((reg) & DM_CORE_LCFG14M_BAR1MASK_MASK) >> DM_CORE_LCFG14M_BAR1MASK_SHIFT)
#define  DM_CORE_LCFG14M_BAR1MASK_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_LCFG14M_BAR1MASK_MASK) | (((uint32_t)val) << DM_CORE_LCFG14M_BAR1MASK_SHIFT))

//====================================================================
//Register: Prefetchable Memory Base and Limit Register (LCfg24)
/** \brief Used only in RC Mode. Sets the Memory range that encompasses all the EP address ranges.
Any address outside the range is allowed for inbound packets.
Addresses inside the Memory Base and Limit range are rejected.*/
//====================================================================

#define  DM_CORE_LCFG24_ENDADDR_MASK 0xfff00000
#define  DM_CORE_LCFG24_ENDADDR_SHIFT 20
#define  DM_CORE_LCFG24_ENDADDR_MASK_SHIFT(reg) (((reg) & DM_CORE_LCFG24_ENDADDR_MASK) >> DM_CORE_LCFG24_ENDADDR_SHIFT)
#define  DM_CORE_LCFG24_ENDADDR_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_LCFG24_ENDADDR_MASK) | (((uint32_t)val) << DM_CORE_LCFG24_ENDADDR_SHIFT))

#define  DM_CORE_LCFG24_RESERVED1_MASK 0xf0000
#define  DM_CORE_LCFG24_RESERVED1_SHIFT 16
#define  DM_CORE_LCFG24_RESERVED1_MASK_SHIFT(reg) (((reg) & DM_CORE_LCFG24_RESERVED1_MASK) >> DM_CORE_LCFG24_RESERVED1_SHIFT)
#define  DM_CORE_LCFG24_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_LCFG24_RESERVED1_MASK) | (((uint32_t)val) << DM_CORE_LCFG24_RESERVED1_SHIFT))

#define  DM_CORE_LCFG24_STARTADDR_MASK 0xfff0
#define  DM_CORE_LCFG24_STARTADDR_SHIFT 4
#define  DM_CORE_LCFG24_STARTADDR_MASK_SHIFT(reg) (((reg) & DM_CORE_LCFG24_STARTADDR_MASK) >> DM_CORE_LCFG24_STARTADDR_SHIFT)
#define  DM_CORE_LCFG24_STARTADDR_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_LCFG24_STARTADDR_MASK) | (((uint32_t)val) << DM_CORE_LCFG24_STARTADDR_SHIFT))

#define  DM_CORE_LCFG24_RESERVED2_MASK 0xf
#define  DM_CORE_LCFG24_RESERVED2_SHIFT 0
#define  DM_CORE_LCFG24_RESERVED2_MASK_SHIFT(reg) (((reg) & DM_CORE_LCFG24_RESERVED2_MASK) >> DM_CORE_LCFG24_RESERVED2_SHIFT)
#define  DM_CORE_LCFG24_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_LCFG24_RESERVED2_MASK) | (((uint32_t)val) << DM_CORE_LCFG24_RESERVED2_SHIFT))

//====================================================================
//Register: Core Local Configuration Register 2C, Subsystem ID and Subsystem Vendor ID (LCfg2C)
/** \brief Subsystem ID/Vendor ID - for Type 0 Headers only. Type 1 Header uses other definition but is not used for this implementation.*/
//====================================================================

#define  DM_CORE_LCFG2C_SUBSYSID_MASK 0xffff0000
#define  DM_CORE_LCFG2C_SUBSYSID_SHIFT 16
#define  DM_CORE_LCFG2C_SUBSYSID_MASK_SHIFT(reg) (((reg) & DM_CORE_LCFG2C_SUBSYSID_MASK) >> DM_CORE_LCFG2C_SUBSYSID_SHIFT)
#define  DM_CORE_LCFG2C_SUBSYSID_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_LCFG2C_SUBSYSID_MASK) | (((uint32_t)val) << DM_CORE_LCFG2C_SUBSYSID_SHIFT))

#define  DM_CORE_LCFG2C_SUBSYSVID_MASK 0xffff
#define  DM_CORE_LCFG2C_SUBSYSVID_SHIFT 0
#define  DM_CORE_LCFG2C_SUBSYSVID_MASK_SHIFT(reg) (((reg) & DM_CORE_LCFG2C_SUBSYSVID_MASK) >> DM_CORE_LCFG2C_SUBSYSVID_SHIFT)
#define  DM_CORE_LCFG2C_SUBSYSVID_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_LCFG2C_SUBSYSVID_MASK) | (((uint32_t)val) << DM_CORE_LCFG2C_SUBSYSVID_SHIFT))

//====================================================================
//Register: Core Local Configuration Register 34 (LCfg34)
/** \brief PCIe Cfg Header Capabilities Pointer - contents point to Capabilities Registers.
Must be > 0x3F to be outside basic Type 0/1 Cfg space.*/
//====================================================================

#define  DM_CORE_LCFG34_RESERVED1_MASK 0xffffff00
#define  DM_CORE_LCFG34_RESERVED1_SHIFT 8
#define  DM_CORE_LCFG34_RESERVED1_MASK_SHIFT(reg) (((reg) & DM_CORE_LCFG34_RESERVED1_MASK) >> DM_CORE_LCFG34_RESERVED1_SHIFT)
#define  DM_CORE_LCFG34_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_LCFG34_RESERVED1_MASK) | (((uint32_t)val) << DM_CORE_LCFG34_RESERVED1_SHIFT))

#define  DM_CORE_LCFG34_CAPABPTR_MASK 0xff
#define  DM_CORE_LCFG34_CAPABPTR_SHIFT 0
#define  DM_CORE_LCFG34_CAPABPTR_MASK_SHIFT(reg) (((reg) & DM_CORE_LCFG34_CAPABPTR_MASK) >> DM_CORE_LCFG34_CAPABPTR_SHIFT)
#define  DM_CORE_LCFG34_CAPABPTR_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_LCFG34_CAPABPTR_MASK) | (((uint32_t)val) << DM_CORE_LCFG34_CAPABPTR_SHIFT))

//====================================================================
//Register: Core Local Configuration Register 3C, Interrupt Pin  and Interrupt Line (LCfg3C)
/** \brief Interrupt Pin and Interrupt Line*/
//====================================================================

#define  DM_CORE_LCFG3C_RESERVED1_MASK 0xffff0000
#define  DM_CORE_LCFG3C_RESERVED1_SHIFT 16
#define  DM_CORE_LCFG3C_RESERVED1_MASK_SHIFT(reg) (((reg) & DM_CORE_LCFG3C_RESERVED1_MASK) >> DM_CORE_LCFG3C_RESERVED1_SHIFT)
#define  DM_CORE_LCFG3C_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_LCFG3C_RESERVED1_MASK) | (((uint32_t)val) << DM_CORE_LCFG3C_RESERVED1_SHIFT))

#define  DM_CORE_LCFG3C_INTPIN_MASK 0xff00
#define  DM_CORE_LCFG3C_INTPIN_SHIFT 8
#define  DM_CORE_LCFG3C_INTPIN_MASK_SHIFT(reg) (((reg) & DM_CORE_LCFG3C_INTPIN_MASK) >> DM_CORE_LCFG3C_INTPIN_SHIFT)
#define  DM_CORE_LCFG3C_INTPIN_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_LCFG3C_INTPIN_MASK) | (((uint32_t)val) << DM_CORE_LCFG3C_INTPIN_SHIFT))

#define  DM_CORE_LCFG3C_INTLINE_MASK 0xff
#define  DM_CORE_LCFG3C_INTLINE_SHIFT 0
#define  DM_CORE_LCFG3C_INTLINE_MASK_SHIFT(reg) (((reg) & DM_CORE_LCFG3C_INTLINE_MASK) >> DM_CORE_LCFG3C_INTLINE_SHIFT)
#define  DM_CORE_LCFG3C_INTLINE_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_LCFG3C_INTLINE_MASK) | (((uint32_t)val) << DM_CORE_LCFG3C_INTLINE_SHIFT))

//====================================================================
//Register: Core Local Power Management Capabilities Register (LPMCap)
/** \brief Power Management Capabilities Register.*/
//====================================================================

#define  DM_CORE_LPMCAP_PMCAP_MASK 0xffff0000
#define  DM_CORE_LPMCAP_PMCAP_SHIFT 16
#define  DM_CORE_LPMCAP_PMCAP_MASK_SHIFT(reg) (((reg) & DM_CORE_LPMCAP_PMCAP_MASK) >> DM_CORE_LPMCAP_PMCAP_SHIFT)
#define  DM_CORE_LPMCAP_PMCAP_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_LPMCAP_PMCAP_MASK) | (((uint32_t)val) << DM_CORE_LPMCAP_PMCAP_SHIFT))

#define  DM_CORE_LPMCAP_NEXTCAPPTR_MASK 0xff00
#define  DM_CORE_LPMCAP_NEXTCAPPTR_SHIFT 8
#define  DM_CORE_LPMCAP_NEXTCAPPTR_MASK_SHIFT(reg) (((reg) & DM_CORE_LPMCAP_NEXTCAPPTR_MASK) >> DM_CORE_LPMCAP_NEXTCAPPTR_SHIFT)
#define  DM_CORE_LPMCAP_NEXTCAPPTR_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_LPMCAP_NEXTCAPPTR_MASK) | (((uint32_t)val) << DM_CORE_LPMCAP_NEXTCAPPTR_SHIFT))

#define  DM_CORE_LPMCAP_CAPABID_MASK 0xff
#define  DM_CORE_LPMCAP_CAPABID_SHIFT 0
#define  DM_CORE_LPMCAP_CAPABID_MASK_SHIFT(reg) (((reg) & DM_CORE_LPMCAP_CAPABID_MASK) >> DM_CORE_LPMCAP_CAPABID_SHIFT)
#define  DM_CORE_LPMCAP_CAPABID_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_LPMCAP_CAPABID_MASK) | (((uint32_t)val) << DM_CORE_LPMCAP_CAPABID_SHIFT))

//====================================================================
//Register: Core Local Power Management Control and Status Register (LPMCSR)
/** \brief Power Management Control and Status Register.*/
//====================================================================

#define  DM_CORE_LPMCSR_RESERVED1_MASK 0xffff0000
#define  DM_CORE_LPMCSR_RESERVED1_SHIFT 16
#define  DM_CORE_LPMCSR_RESERVED1_MASK_SHIFT(reg) (((reg) & DM_CORE_LPMCSR_RESERVED1_MASK) >> DM_CORE_LPMCSR_RESERVED1_SHIFT)
#define  DM_CORE_LPMCSR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_LPMCSR_RESERVED1_MASK) | (((uint32_t)val) << DM_CORE_LPMCSR_RESERVED1_SHIFT))

#define  DM_CORE_LPMCSR_PMESTAT_MASK 0x8000
#define  DM_CORE_LPMCSR_PMESTAT_SHIFT 15
#define  DM_CORE_LPMCSR_PMESTAT_MASK_SHIFT(reg) (((reg) & DM_CORE_LPMCSR_PMESTAT_MASK) >> DM_CORE_LPMCSR_PMESTAT_SHIFT)
#define  DM_CORE_LPMCSR_PMESTAT_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_LPMCSR_PMESTAT_MASK) | (((uint32_t)val) << DM_CORE_LPMCSR_PMESTAT_SHIFT))

#define  DM_CORE_LPMCSR_RESERVED2_MASK 0x7e00
#define  DM_CORE_LPMCSR_RESERVED2_SHIFT 9
#define  DM_CORE_LPMCSR_RESERVED2_MASK_SHIFT(reg) (((reg) & DM_CORE_LPMCSR_RESERVED2_MASK) >> DM_CORE_LPMCSR_RESERVED2_SHIFT)
#define  DM_CORE_LPMCSR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_LPMCSR_RESERVED2_MASK) | (((uint32_t)val) << DM_CORE_LPMCSR_RESERVED2_SHIFT))

#define  DM_CORE_LPMCSR_PME_EN_MASK 0x100
#define  DM_CORE_LPMCSR_PME_EN_SHIFT 8
#define  DM_CORE_LPMCSR_PME_EN_MASK_SHIFT(reg) (((reg) & DM_CORE_LPMCSR_PME_EN_MASK) >> DM_CORE_LPMCSR_PME_EN_SHIFT)
#define  DM_CORE_LPMCSR_PME_EN_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_LPMCSR_PME_EN_MASK) | (((uint32_t)val) << DM_CORE_LPMCSR_PME_EN_SHIFT))

#define  DM_CORE_LPMCSR_RESERVED3_MASK 0xfc
#define  DM_CORE_LPMCSR_RESERVED3_SHIFT 2
#define  DM_CORE_LPMCSR_RESERVED3_MASK_SHIFT(reg) (((reg) & DM_CORE_LPMCSR_RESERVED3_MASK) >> DM_CORE_LPMCSR_RESERVED3_SHIFT)
#define  DM_CORE_LPMCSR_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_LPMCSR_RESERVED3_MASK) | (((uint32_t)val) << DM_CORE_LPMCSR_RESERVED3_SHIFT))

#define  DM_CORE_LPMCSR_PWRSTATE_MASK 0x3
#define  DM_CORE_LPMCSR_PWRSTATE_SHIFT 0
#define  DM_CORE_LPMCSR_PWRSTATE_MASK_SHIFT(reg) (((reg) & DM_CORE_LPMCSR_PWRSTATE_MASK) >> DM_CORE_LPMCSR_PWRSTATE_SHIFT)
#define  DM_CORE_LPMCSR_PWRSTATE_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_LPMCSR_PWRSTATE_MASK) | (((uint32_t)val) << DM_CORE_LPMCSR_PWRSTATE_SHIFT))

//====================================================================
//Register: Core Local MSI Capabilities Control Register (LMsiCtrl)
/** \brief MSI Capabilities Control Register.*/
//====================================================================

#define  DM_CORE_LMSICTRL_RESERVED1_MASK 0xff800000
#define  DM_CORE_LMSICTRL_RESERVED1_SHIFT 23
#define  DM_CORE_LMSICTRL_RESERVED1_MASK_SHIFT(reg) (((reg) & DM_CORE_LMSICTRL_RESERVED1_MASK) >> DM_CORE_LMSICTRL_RESERVED1_SHIFT)
#define  DM_CORE_LMSICTRL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_LMSICTRL_RESERVED1_MASK) | (((uint32_t)val) << DM_CORE_LMSICTRL_RESERVED1_SHIFT))

#define  DM_CORE_LMSICTRL_MULTMSGEN_MASK 0x700000
#define  DM_CORE_LMSICTRL_MULTMSGEN_SHIFT 20
#define  DM_CORE_LMSICTRL_MULTMSGEN_MASK_SHIFT(reg) (((reg) & DM_CORE_LMSICTRL_MULTMSGEN_MASK) >> DM_CORE_LMSICTRL_MULTMSGEN_SHIFT)
#define  DM_CORE_LMSICTRL_MULTMSGEN_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_LMSICTRL_MULTMSGEN_MASK) | (((uint32_t)val) << DM_CORE_LMSICTRL_MULTMSGEN_SHIFT))

#define  DM_CORE_LMSICTRL_MULTMSGCAP_MASK 0xe0000
#define  DM_CORE_LMSICTRL_MULTMSGCAP_SHIFT 17
#define  DM_CORE_LMSICTRL_MULTMSGCAP_MASK_SHIFT(reg) (((reg) & DM_CORE_LMSICTRL_MULTMSGCAP_MASK) >> DM_CORE_LMSICTRL_MULTMSGCAP_SHIFT)
#define  DM_CORE_LMSICTRL_MULTMSGCAP_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_LMSICTRL_MULTMSGCAP_MASK) | (((uint32_t)val) << DM_CORE_LMSICTRL_MULTMSGCAP_SHIFT))

#define  DM_CORE_LMSICTRL_MSIEN_MASK 0x10000
#define  DM_CORE_LMSICTRL_MSIEN_SHIFT 16
#define  DM_CORE_LMSICTRL_MSIEN_MASK_SHIFT(reg) (((reg) & DM_CORE_LMSICTRL_MSIEN_MASK) >> DM_CORE_LMSICTRL_MSIEN_SHIFT)
#define  DM_CORE_LMSICTRL_MSIEN_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_LMSICTRL_MSIEN_MASK) | (((uint32_t)val) << DM_CORE_LMSICTRL_MSIEN_SHIFT))

#define  DM_CORE_LMSICTRL_NEXTPTR_MASK 0xff00
#define  DM_CORE_LMSICTRL_NEXTPTR_SHIFT 8
#define  DM_CORE_LMSICTRL_NEXTPTR_MASK_SHIFT(reg) (((reg) & DM_CORE_LMSICTRL_NEXTPTR_MASK) >> DM_CORE_LMSICTRL_NEXTPTR_SHIFT)
#define  DM_CORE_LMSICTRL_NEXTPTR_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_LMSICTRL_NEXTPTR_MASK) | (((uint32_t)val) << DM_CORE_LMSICTRL_NEXTPTR_SHIFT))

#define  DM_CORE_LMSICTRL_CAPABID_MASK 0xff
#define  DM_CORE_LMSICTRL_CAPABID_SHIFT 0
#define  DM_CORE_LMSICTRL_CAPABID_MASK_SHIFT(reg) (((reg) & DM_CORE_LMSICTRL_CAPABID_MASK) >> DM_CORE_LMSICTRL_CAPABID_SHIFT)
#define  DM_CORE_LMSICTRL_CAPABID_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_LMSICTRL_CAPABID_MASK) | (((uint32_t)val) << DM_CORE_LMSICTRL_CAPABID_SHIFT))

//====================================================================
//Register: Core Local MSI Capabilities  Address Register (LMsiAddr)
/** \brief MSI Capabilities Message Address.*/
//====================================================================

#define  DM_CORE_LMSIADDR_ADDRESS_MASK 0xffffffff
#define  DM_CORE_LMSIADDR_ADDRESS_SHIFT 0
#define  DM_CORE_LMSIADDR_ADDRESS_MASK_SHIFT(reg) (((reg) & DM_CORE_LMSIADDR_ADDRESS_MASK) >> DM_CORE_LMSIADDR_ADDRESS_SHIFT)
#define  DM_CORE_LMSIADDR_ADDRESS_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_LMSIADDR_ADDRESS_MASK) | (((uint32_t)val) << DM_CORE_LMSIADDR_ADDRESS_SHIFT))

//====================================================================
//Register: Core Local MSI Capabilities Data  Register (LMsiData)
/** \brief MSI Capabilities Message Data*/
//====================================================================

#define  DM_CORE_LMSIDATA_RESERVED1_MASK 0xffff0000
#define  DM_CORE_LMSIDATA_RESERVED1_SHIFT 16
#define  DM_CORE_LMSIDATA_RESERVED1_MASK_SHIFT(reg) (((reg) & DM_CORE_LMSIDATA_RESERVED1_MASK) >> DM_CORE_LMSIDATA_RESERVED1_SHIFT)
#define  DM_CORE_LMSIDATA_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_LMSIDATA_RESERVED1_MASK) | (((uint32_t)val) << DM_CORE_LMSIDATA_RESERVED1_SHIFT))

#define  DM_CORE_LMSIDATA_DATA_MASK 0xffff
#define  DM_CORE_LMSIDATA_DATA_SHIFT 0
#define  DM_CORE_LMSIDATA_DATA_MASK_SHIFT(reg) (((reg) & DM_CORE_LMSIDATA_DATA_MASK) >> DM_CORE_LMSIDATA_DATA_SHIFT)
#define  DM_CORE_LMSIDATA_DATA_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_LMSIDATA_DATA_MASK) | (((uint32_t)val) << DM_CORE_LMSIDATA_DATA_SHIFT))

//====================================================================
//Register: Core Local PCIE Capabilities Register (LPCIECap)
/** \brief PCI Express Capabilities Register.*/
//====================================================================

#define  DM_CORE_LPCIECAP_PCIECAP_MASK 0xffff0000
#define  DM_CORE_LPCIECAP_PCIECAP_SHIFT 16
#define  DM_CORE_LPCIECAP_PCIECAP_MASK_SHIFT(reg) (((reg) & DM_CORE_LPCIECAP_PCIECAP_MASK) >> DM_CORE_LPCIECAP_PCIECAP_SHIFT)
#define  DM_CORE_LPCIECAP_PCIECAP_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_LPCIECAP_PCIECAP_MASK) | (((uint32_t)val) << DM_CORE_LPCIECAP_PCIECAP_SHIFT))

#define  DM_CORE_LPCIECAP_NEXTCAPPTR_MASK 0xff00
#define  DM_CORE_LPCIECAP_NEXTCAPPTR_SHIFT 8
#define  DM_CORE_LPCIECAP_NEXTCAPPTR_MASK_SHIFT(reg) (((reg) & DM_CORE_LPCIECAP_NEXTCAPPTR_MASK) >> DM_CORE_LPCIECAP_NEXTCAPPTR_SHIFT)
#define  DM_CORE_LPCIECAP_NEXTCAPPTR_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_LPCIECAP_NEXTCAPPTR_MASK) | (((uint32_t)val) << DM_CORE_LPCIECAP_NEXTCAPPTR_SHIFT))

#define  DM_CORE_LPCIECAP_CAPABID_MASK 0xff
#define  DM_CORE_LPCIECAP_CAPABID_SHIFT 0
#define  DM_CORE_LPCIECAP_CAPABID_MASK_SHIFT(reg) (((reg) & DM_CORE_LPCIECAP_CAPABID_MASK) >> DM_CORE_LPCIECAP_CAPABID_SHIFT)
#define  DM_CORE_LPCIECAP_CAPABID_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_LPCIECAP_CAPABID_MASK) | (((uint32_t)val) << DM_CORE_LPCIECAP_CAPABID_SHIFT))

//====================================================================
//Register: Core Local Device Capability Register (LDevCap)
/** \brief Device Capability Register.*/
//====================================================================

#define  DM_CORE_LDEVCAP_DEVCAP_MASK 0xffffffff
#define  DM_CORE_LDEVCAP_DEVCAP_SHIFT 0
#define  DM_CORE_LDEVCAP_DEVCAP_MASK_SHIFT(reg) (((reg) & DM_CORE_LDEVCAP_DEVCAP_MASK) >> DM_CORE_LDEVCAP_DEVCAP_SHIFT)
#define  DM_CORE_LDEVCAP_DEVCAP_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_LDEVCAP_DEVCAP_MASK) | (((uint32_t)val) << DM_CORE_LDEVCAP_DEVCAP_SHIFT))

//====================================================================
//Register: Core Local Device Control and Status Register (LDevContStatus)
/** \brief PCI Express Capability Device Control and Status Register.*/
//====================================================================

#define  DM_CORE_LDEVCONTSTATUS_STATUS_MASK 0xffff0000
#define  DM_CORE_LDEVCONTSTATUS_STATUS_SHIFT 16
#define  DM_CORE_LDEVCONTSTATUS_STATUS_MASK_SHIFT(reg) (((reg) & DM_CORE_LDEVCONTSTATUS_STATUS_MASK) >> DM_CORE_LDEVCONTSTATUS_STATUS_SHIFT)
#define  DM_CORE_LDEVCONTSTATUS_STATUS_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_LDEVCONTSTATUS_STATUS_MASK) | (((uint32_t)val) << DM_CORE_LDEVCONTSTATUS_STATUS_SHIFT))

#define  DM_CORE_LDEVCONTSTATUS_CONTROL_MASK 0xffff
#define  DM_CORE_LDEVCONTSTATUS_CONTROL_SHIFT 0
#define  DM_CORE_LDEVCONTSTATUS_CONTROL_MASK_SHIFT(reg) (((reg) & DM_CORE_LDEVCONTSTATUS_CONTROL_MASK) >> DM_CORE_LDEVCONTSTATUS_CONTROL_SHIFT)
#define  DM_CORE_LDEVCONTSTATUS_CONTROL_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_LDEVCONTSTATUS_CONTROL_MASK) | (((uint32_t)val) << DM_CORE_LDEVCONTSTATUS_CONTROL_SHIFT))

//====================================================================
//Register: Core Local Device Link Capabilities Register (LDevLinkCap)
/** \brief PCI Express Link Capabilities Register.*/
//====================================================================

#define  DM_CORE_LDEVLINKCAP_DEVLINKCAP_MASK 0xffffffff
#define  DM_CORE_LDEVLINKCAP_DEVLINKCAP_SHIFT 0
#define  DM_CORE_LDEVLINKCAP_DEVLINKCAP_MASK_SHIFT(reg) (((reg) & DM_CORE_LDEVLINKCAP_DEVLINKCAP_MASK) >> DM_CORE_LDEVLINKCAP_DEVLINKCAP_SHIFT)
#define  DM_CORE_LDEVLINKCAP_DEVLINKCAP_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_LDEVLINKCAP_DEVLINKCAP_MASK) | (((uint32_t)val) << DM_CORE_LDEVLINKCAP_DEVLINKCAP_SHIFT))

//====================================================================
//Register: Core Local Link Control and Status Register (LLinkContStatus)
/** \brief PCI Express Capability Device Control and Status Register.*/
//====================================================================

#define  DM_CORE_LLINKCONTSTATUS_STATUS_MASK 0xffff0000
#define  DM_CORE_LLINKCONTSTATUS_STATUS_SHIFT 16
#define  DM_CORE_LLINKCONTSTATUS_STATUS_MASK_SHIFT(reg) (((reg) & DM_CORE_LLINKCONTSTATUS_STATUS_MASK) >> DM_CORE_LLINKCONTSTATUS_STATUS_SHIFT)
#define  DM_CORE_LLINKCONTSTATUS_STATUS_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_LLINKCONTSTATUS_STATUS_MASK) | (((uint32_t)val) << DM_CORE_LLINKCONTSTATUS_STATUS_SHIFT))

#define  DM_CORE_LLINKCONTSTATUS_CONTROL_MASK 0xffff
#define  DM_CORE_LLINKCONTSTATUS_CONTROL_SHIFT 0
#define  DM_CORE_LLINKCONTSTATUS_CONTROL_MASK_SHIFT(reg) (((reg) & DM_CORE_LLINKCONTSTATUS_CONTROL_MASK) >> DM_CORE_LLINKCONTSTATUS_CONTROL_SHIFT)
#define  DM_CORE_LLINKCONTSTATUS_CONTROL_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_LLINKCONTSTATUS_CONTROL_MASK) | (((uint32_t)val) << DM_CORE_LLINKCONTSTATUS_CONTROL_SHIFT))

//====================================================================
//Register: Core Local Root Control Register (LRootCtrl)
/** \brief PCI Express Root Control Register - RC only.*/
//====================================================================

#define  DM_CORE_LROOTCTRL_RESERVED1_MASK 0xffff0000
#define  DM_CORE_LROOTCTRL_RESERVED1_SHIFT 16
#define  DM_CORE_LROOTCTRL_RESERVED1_MASK_SHIFT(reg) (((reg) & DM_CORE_LROOTCTRL_RESERVED1_MASK) >> DM_CORE_LROOTCTRL_RESERVED1_SHIFT)
#define  DM_CORE_LROOTCTRL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_LROOTCTRL_RESERVED1_MASK) | (((uint32_t)val) << DM_CORE_LROOTCTRL_RESERVED1_SHIFT))

#define  DM_CORE_LROOTCTRL_ROOTCTRL_MASK 0xffff
#define  DM_CORE_LROOTCTRL_ROOTCTRL_SHIFT 0
#define  DM_CORE_LROOTCTRL_ROOTCTRL_MASK_SHIFT(reg) (((reg) & DM_CORE_LROOTCTRL_ROOTCTRL_MASK) >> DM_CORE_LROOTCTRL_ROOTCTRL_SHIFT)
#define  DM_CORE_LROOTCTRL_ROOTCTRL_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_LROOTCTRL_ROOTCTRL_MASK) | (((uint32_t)val) << DM_CORE_LROOTCTRL_ROOTCTRL_SHIFT))

//====================================================================
//Register: Core Local Root Status Register (LRootStat)
/** \brief PCI Express Root Status Register - RC only.*/
//====================================================================

#define  DM_CORE_LROOTSTAT_RESERVED1_MASK 0xfffc0000
#define  DM_CORE_LROOTSTAT_RESERVED1_SHIFT 18
#define  DM_CORE_LROOTSTAT_RESERVED1_MASK_SHIFT(reg) (((reg) & DM_CORE_LROOTSTAT_RESERVED1_MASK) >> DM_CORE_LROOTSTAT_RESERVED1_SHIFT)
#define  DM_CORE_LROOTSTAT_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_LROOTSTAT_RESERVED1_MASK) | (((uint32_t)val) << DM_CORE_LROOTSTAT_RESERVED1_SHIFT))

#define  DM_CORE_LROOTSTAT_ROOTSTAT_MASK 0x3ffff
#define  DM_CORE_LROOTSTAT_ROOTSTAT_SHIFT 0
#define  DM_CORE_LROOTSTAT_ROOTSTAT_MASK_SHIFT(reg) (((reg) & DM_CORE_LROOTSTAT_ROOTSTAT_MASK) >> DM_CORE_LROOTSTAT_ROOTSTAT_SHIFT)
#define  DM_CORE_LROOTSTAT_ROOTSTAT_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_LROOTSTAT_ROOTSTAT_MASK) | (((uint32_t)val) << DM_CORE_LROOTSTAT_ROOTSTAT_SHIFT))

//====================================================================
//Register: Core Local Device Capability2 Register (LDevCap2)
/** \brief Device Capability2 Register.*/
//====================================================================

#define  DM_CORE_LDEVCAP2_DEVCAP2_MASK 0xffffffff
#define  DM_CORE_LDEVCAP2_DEVCAP2_SHIFT 0
#define  DM_CORE_LDEVCAP2_DEVCAP2_MASK_SHIFT(reg) (((reg) & DM_CORE_LDEVCAP2_DEVCAP2_MASK) >> DM_CORE_LDEVCAP2_DEVCAP2_SHIFT)
#define  DM_CORE_LDEVCAP2_DEVCAP2_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_LDEVCAP2_DEVCAP2_MASK) | (((uint32_t)val) << DM_CORE_LDEVCAP2_DEVCAP2_SHIFT))

//====================================================================
//Register: Core Local Device Control and Status2 Register (LDevContStatus2)
/** \brief PCI Express Capability Device Control and Status2 Register.*/
//====================================================================

#define  DM_CORE_LDEVCONTSTATUS2_STATUS2_MASK 0xffff0000
#define  DM_CORE_LDEVCONTSTATUS2_STATUS2_SHIFT 16
#define  DM_CORE_LDEVCONTSTATUS2_STATUS2_MASK_SHIFT(reg) (((reg) & DM_CORE_LDEVCONTSTATUS2_STATUS2_MASK) >> DM_CORE_LDEVCONTSTATUS2_STATUS2_SHIFT)
#define  DM_CORE_LDEVCONTSTATUS2_STATUS2_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_LDEVCONTSTATUS2_STATUS2_MASK) | (((uint32_t)val) << DM_CORE_LDEVCONTSTATUS2_STATUS2_SHIFT))

#define  DM_CORE_LDEVCONTSTATUS2_CONTROL2_MASK 0xffff
#define  DM_CORE_LDEVCONTSTATUS2_CONTROL2_SHIFT 0
#define  DM_CORE_LDEVCONTSTATUS2_CONTROL2_MASK_SHIFT(reg) (((reg) & DM_CORE_LDEVCONTSTATUS2_CONTROL2_MASK) >> DM_CORE_LDEVCONTSTATUS2_CONTROL2_SHIFT)
#define  DM_CORE_LDEVCONTSTATUS2_CONTROL2_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_LDEVCONTSTATUS2_CONTROL2_MASK) | (((uint32_t)val) << DM_CORE_LDEVCONTSTATUS2_CONTROL2_SHIFT))

//====================================================================
//Register: Core Local Device Link Capabilities2 Register (LDevLinkCap2)
/** \brief PCI Express Link Capabilities2 Register.*/
//====================================================================

#define  DM_CORE_LDEVLINKCAP2_DEVLINKCAP2_MASK 0xffffffff
#define  DM_CORE_LDEVLINKCAP2_DEVLINKCAP2_SHIFT 0
#define  DM_CORE_LDEVLINKCAP2_DEVLINKCAP2_MASK_SHIFT(reg) (((reg) & DM_CORE_LDEVLINKCAP2_DEVLINKCAP2_MASK) >> DM_CORE_LDEVLINKCAP2_DEVLINKCAP2_SHIFT)
#define  DM_CORE_LDEVLINKCAP2_DEVLINKCAP2_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_LDEVLINKCAP2_DEVLINKCAP2_MASK) | (((uint32_t)val) << DM_CORE_LDEVLINKCAP2_DEVLINKCAP2_SHIFT))

//====================================================================
//Register: Core Local Link Control and Status2 Register (LLinkContStatus2)
/** \brief PCI Express Capability Device Control and Status2 Register.*/
//====================================================================

#define  DM_CORE_LLINKCONTSTATUS2_STATUS2_MASK 0xffff0000
#define  DM_CORE_LLINKCONTSTATUS2_STATUS2_SHIFT 16
#define  DM_CORE_LLINKCONTSTATUS2_STATUS2_MASK_SHIFT(reg) (((reg) & DM_CORE_LLINKCONTSTATUS2_STATUS2_MASK) >> DM_CORE_LLINKCONTSTATUS2_STATUS2_SHIFT)
#define  DM_CORE_LLINKCONTSTATUS2_STATUS2_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_LLINKCONTSTATUS2_STATUS2_MASK) | (((uint32_t)val) << DM_CORE_LLINKCONTSTATUS2_STATUS2_SHIFT))

#define  DM_CORE_LLINKCONTSTATUS2_CONTROL2_MASK 0xffff
#define  DM_CORE_LLINKCONTSTATUS2_CONTROL2_SHIFT 0
#define  DM_CORE_LLINKCONTSTATUS2_CONTROL2_MASK_SHIFT(reg) (((reg) & DM_CORE_LLINKCONTSTATUS2_CONTROL2_MASK) >> DM_CORE_LLINKCONTSTATUS2_CONTROL2_SHIFT)
#define  DM_CORE_LLINKCONTSTATUS2_CONTROL2_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_LLINKCONTSTATUS2_CONTROL2_MASK) | (((uint32_t)val) << DM_CORE_LLINKCONTSTATUS2_CONTROL2_SHIFT))

//====================================================================
//Register: Core Local AER Capabilities Register (LAERCap)
/** \brief PCI Express AER Enhanced Capability Header Register.*/
//====================================================================

#define  DM_CORE_LAERCAP_AERHDR_MASK 0xffffffff
#define  DM_CORE_LAERCAP_AERHDR_SHIFT 0
#define  DM_CORE_LAERCAP_AERHDR_MASK_SHIFT(reg) (((reg) & DM_CORE_LAERCAP_AERHDR_MASK) >> DM_CORE_LAERCAP_AERHDR_SHIFT)
#define  DM_CORE_LAERCAP_AERHDR_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_LAERCAP_AERHDR_MASK) | (((uint32_t)val) << DM_CORE_LAERCAP_AERHDR_SHIFT))

//====================================================================
//Register: Core Local Uncorrectable Error Status Register (LUCorrStat)
/** \brief PCI Express AER Uncorrectable Error Status Register.*/
//====================================================================

#define  DM_CORE_LUCORRSTAT_UCORRESTAT_MASK 0xffffffff
#define  DM_CORE_LUCORRSTAT_UCORRESTAT_SHIFT 0
#define  DM_CORE_LUCORRSTAT_UCORRESTAT_MASK_SHIFT(reg) (((reg) & DM_CORE_LUCORRSTAT_UCORRESTAT_MASK) >> DM_CORE_LUCORRSTAT_UCORRESTAT_SHIFT)
#define  DM_CORE_LUCORRSTAT_UCORRESTAT_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_LUCORRSTAT_UCORRESTAT_MASK) | (((uint32_t)val) << DM_CORE_LUCORRSTAT_UCORRESTAT_SHIFT))

//====================================================================
//Register: Core Local Uncorrectable Error Mask Register (LUCorrMask)
/** \brief PCI Express AER Uncorrectable Error Mask Register.*/
//====================================================================

#define  DM_CORE_LUCORRMASK_UCORREMASK_MASK 0xffffffff
#define  DM_CORE_LUCORRMASK_UCORREMASK_SHIFT 0
#define  DM_CORE_LUCORRMASK_UCORREMASK_MASK_SHIFT(reg) (((reg) & DM_CORE_LUCORRMASK_UCORREMASK_MASK) >> DM_CORE_LUCORRMASK_UCORREMASK_SHIFT)
#define  DM_CORE_LUCORRMASK_UCORREMASK_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_LUCORRMASK_UCORREMASK_MASK) | (((uint32_t)val) << DM_CORE_LUCORRMASK_UCORREMASK_SHIFT))

//====================================================================
//Register: Core Local Uncorrectable Error Severity Register (LUCorrSev)
/** \brief PCI Express AER Uncorrectable Error Severity Register.*/
//====================================================================

#define  DM_CORE_LUCORRSEV_UCORRESEV_MASK 0xffffffff
#define  DM_CORE_LUCORRSEV_UCORRESEV_SHIFT 0
#define  DM_CORE_LUCORRSEV_UCORRESEV_MASK_SHIFT(reg) (((reg) & DM_CORE_LUCORRSEV_UCORRESEV_MASK) >> DM_CORE_LUCORRSEV_UCORRESEV_SHIFT)
#define  DM_CORE_LUCORRSEV_UCORRESEV_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_LUCORRSEV_UCORRESEV_MASK) | (((uint32_t)val) << DM_CORE_LUCORRSEV_UCORRESEV_SHIFT))

//====================================================================
//Register: Core Local Correctable Error Status Register (LCorrStat)
/** \brief PCI Express AER Correctable Error Status Register.*/
//====================================================================

#define  DM_CORE_LCORRSTAT_CORRESTAT_MASK 0xffffffff
#define  DM_CORE_LCORRSTAT_CORRESTAT_SHIFT 0
#define  DM_CORE_LCORRSTAT_CORRESTAT_MASK_SHIFT(reg) (((reg) & DM_CORE_LCORRSTAT_CORRESTAT_MASK) >> DM_CORE_LCORRSTAT_CORRESTAT_SHIFT)
#define  DM_CORE_LCORRSTAT_CORRESTAT_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_LCORRSTAT_CORRESTAT_MASK) | (((uint32_t)val) << DM_CORE_LCORRSTAT_CORRESTAT_SHIFT))

//====================================================================
//Register: Core Local Correctable Error Mask Register (LCorrMask)
/** \brief PCI Express AER Correctable Error Mask Register.*/
//====================================================================

#define  DM_CORE_LCORRMASK_CORREMASK_MASK 0xffffffff
#define  DM_CORE_LCORRMASK_CORREMASK_SHIFT 0
#define  DM_CORE_LCORRMASK_CORREMASK_MASK_SHIFT(reg) (((reg) & DM_CORE_LCORRMASK_CORREMASK_MASK) >> DM_CORE_LCORRMASK_CORREMASK_SHIFT)
#define  DM_CORE_LCORRMASK_CORREMASK_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_LCORRMASK_CORREMASK_MASK) | (((uint32_t)val) << DM_CORE_LCORRMASK_CORREMASK_SHIFT))

//====================================================================
//Register: Core Local AER Capabilities and Control Register (LAERCapCtrl)
/** \brief PCI Express AER Capabilities and Control Register.*/
//====================================================================

#define  DM_CORE_LAERCAPCTRL_CAPCTRL_MASK 0xffffffff
#define  DM_CORE_LAERCAPCTRL_CAPCTRL_SHIFT 0
#define  DM_CORE_LAERCAPCTRL_CAPCTRL_MASK_SHIFT(reg) (((reg) & DM_CORE_LAERCAPCTRL_CAPCTRL_MASK) >> DM_CORE_LAERCAPCTRL_CAPCTRL_SHIFT)
#define  DM_CORE_LAERCAPCTRL_CAPCTRL_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_LAERCAPCTRL_CAPCTRL_MASK) | (((uint32_t)val) << DM_CORE_LAERCAPCTRL_CAPCTRL_SHIFT))

//====================================================================
//Register: Core Local Header Log Register (first DWORD) (LHeaderLog1)
/** \brief PCI Express Header Log Register, 1st doubleword (32 bits) of 4.*/
//====================================================================

#define  DM_CORE_LHEADERLOG1_LOG_MASK 0xffffffff
#define  DM_CORE_LHEADERLOG1_LOG_SHIFT 0
#define  DM_CORE_LHEADERLOG1_LOG_MASK_SHIFT(reg) (((reg) & DM_CORE_LHEADERLOG1_LOG_MASK) >> DM_CORE_LHEADERLOG1_LOG_SHIFT)
#define  DM_CORE_LHEADERLOG1_LOG_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_LHEADERLOG1_LOG_MASK) | (((uint32_t)val) << DM_CORE_LHEADERLOG1_LOG_SHIFT))

//====================================================================
//Register: Core Local Header Log Register (second DWORD) (LHeaderLog2)
/** \brief PCI Express Header Log Register, 2nd doubleword (32 bits) of 4.*/
//====================================================================

#define  DM_CORE_LHEADERLOG2_LOG_MASK 0xffffffff
#define  DM_CORE_LHEADERLOG2_LOG_SHIFT 0
#define  DM_CORE_LHEADERLOG2_LOG_MASK_SHIFT(reg) (((reg) & DM_CORE_LHEADERLOG2_LOG_MASK) >> DM_CORE_LHEADERLOG2_LOG_SHIFT)
#define  DM_CORE_LHEADERLOG2_LOG_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_LHEADERLOG2_LOG_MASK) | (((uint32_t)val) << DM_CORE_LHEADERLOG2_LOG_SHIFT))

//====================================================================
//Register: Core Local Header Log Register (third DWORD) (LHeaderLog3)
/** \brief PCI Express Header Log Register, 3rd doubleword (32 bits) of 4.*/
//====================================================================

#define  DM_CORE_LHEADERLOG3_LOG_MASK 0xffffffff
#define  DM_CORE_LHEADERLOG3_LOG_SHIFT 0
#define  DM_CORE_LHEADERLOG3_LOG_MASK_SHIFT(reg) (((reg) & DM_CORE_LHEADERLOG3_LOG_MASK) >> DM_CORE_LHEADERLOG3_LOG_SHIFT)
#define  DM_CORE_LHEADERLOG3_LOG_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_LHEADERLOG3_LOG_MASK) | (((uint32_t)val) << DM_CORE_LHEADERLOG3_LOG_SHIFT))

//====================================================================
//Register: Core Local Header Log Register (fourth DWORD) (LHeaderLog4)
/** \brief PCI Express Header Log Register, 4th doubleword (32 bits) of 4.*/
//====================================================================

#define  DM_CORE_LHEADERLOG4_LOG_MASK 0xffffffff
#define  DM_CORE_LHEADERLOG4_LOG_SHIFT 0
#define  DM_CORE_LHEADERLOG4_LOG_MASK_SHIFT(reg) (((reg) & DM_CORE_LHEADERLOG4_LOG_MASK) >> DM_CORE_LHEADERLOG4_LOG_SHIFT)
#define  DM_CORE_LHEADERLOG4_LOG_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_LHEADERLOG4_LOG_MASK) | (((uint32_t)val) << DM_CORE_LHEADERLOG4_LOG_SHIFT))

//====================================================================
//Register: Core Local Root Error Command Register (LRootErrCmd)
/** \brief PCI Express Root Error Command Register - RC only.*/
//====================================================================

#define  DM_CORE_LROOTERRCMD_RESERVED1_MASK 0xfffffff8
#define  DM_CORE_LROOTERRCMD_RESERVED1_SHIFT 3
#define  DM_CORE_LROOTERRCMD_RESERVED1_MASK_SHIFT(reg) (((reg) & DM_CORE_LROOTERRCMD_RESERVED1_MASK) >> DM_CORE_LROOTERRCMD_RESERVED1_SHIFT)
#define  DM_CORE_LROOTERRCMD_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_LROOTERRCMD_RESERVED1_MASK) | (((uint32_t)val) << DM_CORE_LROOTERRCMD_RESERVED1_SHIFT))

#define  DM_CORE_LROOTERRCMD_ERRCMD_MASK 0x7
#define  DM_CORE_LROOTERRCMD_ERRCMD_SHIFT 0
#define  DM_CORE_LROOTERRCMD_ERRCMD_MASK_SHIFT(reg) (((reg) & DM_CORE_LROOTERRCMD_ERRCMD_MASK) >> DM_CORE_LROOTERRCMD_ERRCMD_SHIFT)
#define  DM_CORE_LROOTERRCMD_ERRCMD_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_LROOTERRCMD_ERRCMD_MASK) | (((uint32_t)val) << DM_CORE_LROOTERRCMD_ERRCMD_SHIFT))

//====================================================================
//Register: Core Local Root Error Status Register (LRootErrStat)
/** \brief PCI Express Root Error Status Register - RC only.*/
//====================================================================

#define  DM_CORE_LROOTERRSTAT_MSGNUM_MASK 0xf8000000
#define  DM_CORE_LROOTERRSTAT_MSGNUM_SHIFT 27
#define  DM_CORE_LROOTERRSTAT_MSGNUM_MASK_SHIFT(reg) (((reg) & DM_CORE_LROOTERRSTAT_MSGNUM_MASK) >> DM_CORE_LROOTERRSTAT_MSGNUM_SHIFT)
#define  DM_CORE_LROOTERRSTAT_MSGNUM_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_LROOTERRSTAT_MSGNUM_MASK) | (((uint32_t)val) << DM_CORE_LROOTERRSTAT_MSGNUM_SHIFT))

#define  DM_CORE_LROOTERRSTAT_RESERVED1_MASK 0x7ffff80
#define  DM_CORE_LROOTERRSTAT_RESERVED1_SHIFT 7
#define  DM_CORE_LROOTERRSTAT_RESERVED1_MASK_SHIFT(reg) (((reg) & DM_CORE_LROOTERRSTAT_RESERVED1_MASK) >> DM_CORE_LROOTERRSTAT_RESERVED1_SHIFT)
#define  DM_CORE_LROOTERRSTAT_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_LROOTERRSTAT_RESERVED1_MASK) | (((uint32_t)val) << DM_CORE_LROOTERRSTAT_RESERVED1_SHIFT))

#define  DM_CORE_LROOTERRSTAT_ERRSTAT_MASK 0x7f
#define  DM_CORE_LROOTERRSTAT_ERRSTAT_SHIFT 0
#define  DM_CORE_LROOTERRSTAT_ERRSTAT_MASK_SHIFT(reg) (((reg) & DM_CORE_LROOTERRSTAT_ERRSTAT_MASK) >> DM_CORE_LROOTERRSTAT_ERRSTAT_SHIFT)
#define  DM_CORE_LROOTERRSTAT_ERRSTAT_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_LROOTERRSTAT_ERRSTAT_MASK) | (((uint32_t)val) << DM_CORE_LROOTERRSTAT_ERRSTAT_SHIFT))

//====================================================================
//Register: Core Local Error Source Identification Register (LErrSrcID)
/** \brief PCI Express Error Source Identification Register - RC only.*/
//====================================================================

#define  DM_CORE_LERRSRCID_FATALID_MASK 0xffff0000
#define  DM_CORE_LERRSRCID_FATALID_SHIFT 16
#define  DM_CORE_LERRSRCID_FATALID_MASK_SHIFT(reg) (((reg) & DM_CORE_LERRSRCID_FATALID_MASK) >> DM_CORE_LERRSRCID_FATALID_SHIFT)
#define  DM_CORE_LERRSRCID_FATALID_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_LERRSRCID_FATALID_MASK) | (((uint32_t)val) << DM_CORE_LERRSRCID_FATALID_SHIFT))

#define  DM_CORE_LERRSRCID_CORRID_MASK 0xffff
#define  DM_CORE_LERRSRCID_CORRID_SHIFT 0
#define  DM_CORE_LERRSRCID_CORRID_MASK_SHIFT(reg) (((reg) & DM_CORE_LERRSRCID_CORRID_MASK) >> DM_CORE_LERRSRCID_CORRID_SHIFT)
#define  DM_CORE_LERRSRCID_CORRID_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_LERRSRCID_CORRID_MASK) | (((uint32_t)val) << DM_CORE_LERRSRCID_CORRID_SHIFT))

//====================================================================
//Register: Core Local L1 Substates Capability Header Register (LL1SubCapHeader)
/** \brief PCI Express L1 Substates Capability Header Register<BR>
NOTE: The L1 Substates Registers were added for G2 PCIe Low Power Modes*/
//====================================================================

#define  DM_CORE_LL1SUBCAPHEADER_NEXT_OFFSET_MASK 0xfff00000
#define  DM_CORE_LL1SUBCAPHEADER_NEXT_OFFSET_SHIFT 20
#define  DM_CORE_LL1SUBCAPHEADER_NEXT_OFFSET_MASK_SHIFT(reg) (((reg) & DM_CORE_LL1SUBCAPHEADER_NEXT_OFFSET_MASK) >> DM_CORE_LL1SUBCAPHEADER_NEXT_OFFSET_SHIFT)
#define  DM_CORE_LL1SUBCAPHEADER_NEXT_OFFSET_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_LL1SUBCAPHEADER_NEXT_OFFSET_MASK) | (((uint32_t)val) << DM_CORE_LL1SUBCAPHEADER_NEXT_OFFSET_SHIFT))

#define  DM_CORE_LL1SUBCAPHEADER_CAP_VERSION_MASK 0xf0000
#define  DM_CORE_LL1SUBCAPHEADER_CAP_VERSION_SHIFT 16
#define  DM_CORE_LL1SUBCAPHEADER_CAP_VERSION_MASK_SHIFT(reg) (((reg) & DM_CORE_LL1SUBCAPHEADER_CAP_VERSION_MASK) >> DM_CORE_LL1SUBCAPHEADER_CAP_VERSION_SHIFT)
#define  DM_CORE_LL1SUBCAPHEADER_CAP_VERSION_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_LL1SUBCAPHEADER_CAP_VERSION_MASK) | (((uint32_t)val) << DM_CORE_LL1SUBCAPHEADER_CAP_VERSION_SHIFT))

#define  DM_CORE_LL1SUBCAPHEADER_EXTENDED_CAP_ID_MASK 0xffff
#define  DM_CORE_LL1SUBCAPHEADER_EXTENDED_CAP_ID_SHIFT 0
#define  DM_CORE_LL1SUBCAPHEADER_EXTENDED_CAP_ID_MASK_SHIFT(reg) (((reg) & DM_CORE_LL1SUBCAPHEADER_EXTENDED_CAP_ID_MASK) >> DM_CORE_LL1SUBCAPHEADER_EXTENDED_CAP_ID_SHIFT)
#define  DM_CORE_LL1SUBCAPHEADER_EXTENDED_CAP_ID_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_LL1SUBCAPHEADER_EXTENDED_CAP_ID_MASK) | (((uint32_t)val) << DM_CORE_LL1SUBCAPHEADER_EXTENDED_CAP_ID_SHIFT))

//====================================================================
//Register: Core Local L1 Substates Capability Register (LL1SubCapability)
/** \brief PCI Express L1 Substates Capability Register*/
//====================================================================

#define  DM_CORE_LL1SUBCAPABILITY_RESERVED1_MASK 0xff000000
#define  DM_CORE_LL1SUBCAPABILITY_RESERVED1_SHIFT 24
#define  DM_CORE_LL1SUBCAPABILITY_RESERVED1_MASK_SHIFT(reg) (((reg) & DM_CORE_LL1SUBCAPABILITY_RESERVED1_MASK) >> DM_CORE_LL1SUBCAPABILITY_RESERVED1_SHIFT)
#define  DM_CORE_LL1SUBCAPABILITY_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_LL1SUBCAPABILITY_RESERVED1_MASK) | (((uint32_t)val) << DM_CORE_LL1SUBCAPABILITY_RESERVED1_SHIFT))

#define  DM_CORE_LL1SUBCAPABILITY_PWR_ON_VALUE_SUPPORT_MASK 0xf80000
#define  DM_CORE_LL1SUBCAPABILITY_PWR_ON_VALUE_SUPPORT_SHIFT 19
#define  DM_CORE_LL1SUBCAPABILITY_PWR_ON_VALUE_SUPPORT_MASK_SHIFT(reg) (((reg) & DM_CORE_LL1SUBCAPABILITY_PWR_ON_VALUE_SUPPORT_MASK) >> DM_CORE_LL1SUBCAPABILITY_PWR_ON_VALUE_SUPPORT_SHIFT)
#define  DM_CORE_LL1SUBCAPABILITY_PWR_ON_VALUE_SUPPORT_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_LL1SUBCAPABILITY_PWR_ON_VALUE_SUPPORT_MASK) | (((uint32_t)val) << DM_CORE_LL1SUBCAPABILITY_PWR_ON_VALUE_SUPPORT_SHIFT))

#define  DM_CORE_LL1SUBCAPABILITY_RESERVED2_MASK 0x40000
#define  DM_CORE_LL1SUBCAPABILITY_RESERVED2_SHIFT 18
#define  DM_CORE_LL1SUBCAPABILITY_RESERVED2_MASK_SHIFT(reg) (((reg) & DM_CORE_LL1SUBCAPABILITY_RESERVED2_MASK) >> DM_CORE_LL1SUBCAPABILITY_RESERVED2_SHIFT)
#define  DM_CORE_LL1SUBCAPABILITY_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_LL1SUBCAPABILITY_RESERVED2_MASK) | (((uint32_t)val) << DM_CORE_LL1SUBCAPABILITY_RESERVED2_SHIFT))

#define  DM_CORE_LL1SUBCAPABILITY_PWR_ON_SCALE_SUPPORT_MASK 0x30000
#define  DM_CORE_LL1SUBCAPABILITY_PWR_ON_SCALE_SUPPORT_SHIFT 16
#define  DM_CORE_LL1SUBCAPABILITY_PWR_ON_SCALE_SUPPORT_MASK_SHIFT(reg) (((reg) & DM_CORE_LL1SUBCAPABILITY_PWR_ON_SCALE_SUPPORT_MASK) >> DM_CORE_LL1SUBCAPABILITY_PWR_ON_SCALE_SUPPORT_SHIFT)
#define  DM_CORE_LL1SUBCAPABILITY_PWR_ON_SCALE_SUPPORT_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_LL1SUBCAPABILITY_PWR_ON_SCALE_SUPPORT_MASK) | (((uint32_t)val) << DM_CORE_LL1SUBCAPABILITY_PWR_ON_SCALE_SUPPORT_SHIFT))

#define  DM_CORE_LL1SUBCAPABILITY_COMM_MODE_SUPPORT_MASK 0xff00
#define  DM_CORE_LL1SUBCAPABILITY_COMM_MODE_SUPPORT_SHIFT 8
#define  DM_CORE_LL1SUBCAPABILITY_COMM_MODE_SUPPORT_MASK_SHIFT(reg) (((reg) & DM_CORE_LL1SUBCAPABILITY_COMM_MODE_SUPPORT_MASK) >> DM_CORE_LL1SUBCAPABILITY_COMM_MODE_SUPPORT_SHIFT)
#define  DM_CORE_LL1SUBCAPABILITY_COMM_MODE_SUPPORT_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_LL1SUBCAPABILITY_COMM_MODE_SUPPORT_MASK) | (((uint32_t)val) << DM_CORE_LL1SUBCAPABILITY_COMM_MODE_SUPPORT_SHIFT))

#define  DM_CORE_LL1SUBCAPABILITY_RESERVED3_MASK 0xe0
#define  DM_CORE_LL1SUBCAPABILITY_RESERVED3_SHIFT 5
#define  DM_CORE_LL1SUBCAPABILITY_RESERVED3_MASK_SHIFT(reg) (((reg) & DM_CORE_LL1SUBCAPABILITY_RESERVED3_MASK) >> DM_CORE_LL1SUBCAPABILITY_RESERVED3_SHIFT)
#define  DM_CORE_LL1SUBCAPABILITY_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_LL1SUBCAPABILITY_RESERVED3_MASK) | (((uint32_t)val) << DM_CORE_LL1SUBCAPABILITY_RESERVED3_SHIFT))

#define  DM_CORE_LL1SUBCAPABILITY_L1_PMSUB_SUPPORT_MASK 0x10
#define  DM_CORE_LL1SUBCAPABILITY_L1_PMSUB_SUPPORT_SHIFT 4
#define  DM_CORE_LL1SUBCAPABILITY_L1_PMSUB_SUPPORT_MASK_SHIFT(reg) (((reg) & DM_CORE_LL1SUBCAPABILITY_L1_PMSUB_SUPPORT_MASK) >> DM_CORE_LL1SUBCAPABILITY_L1_PMSUB_SUPPORT_SHIFT)
#define  DM_CORE_LL1SUBCAPABILITY_L1_PMSUB_SUPPORT_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_LL1SUBCAPABILITY_L1_PMSUB_SUPPORT_MASK) | (((uint32_t)val) << DM_CORE_LL1SUBCAPABILITY_L1_PMSUB_SUPPORT_SHIFT))

#define  DM_CORE_LL1SUBCAPABILITY_L1_1_ASPM_SUPPORT_MASK 0x8
#define  DM_CORE_LL1SUBCAPABILITY_L1_1_ASPM_SUPPORT_SHIFT 3
#define  DM_CORE_LL1SUBCAPABILITY_L1_1_ASPM_SUPPORT_MASK_SHIFT(reg) (((reg) & DM_CORE_LL1SUBCAPABILITY_L1_1_ASPM_SUPPORT_MASK) >> DM_CORE_LL1SUBCAPABILITY_L1_1_ASPM_SUPPORT_SHIFT)
#define  DM_CORE_LL1SUBCAPABILITY_L1_1_ASPM_SUPPORT_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_LL1SUBCAPABILITY_L1_1_ASPM_SUPPORT_MASK) | (((uint32_t)val) << DM_CORE_LL1SUBCAPABILITY_L1_1_ASPM_SUPPORT_SHIFT))

#define  DM_CORE_LL1SUBCAPABILITY_L1_2_ASPM_SUPPORT_MASK 0x4
#define  DM_CORE_LL1SUBCAPABILITY_L1_2_ASPM_SUPPORT_SHIFT 2
#define  DM_CORE_LL1SUBCAPABILITY_L1_2_ASPM_SUPPORT_MASK_SHIFT(reg) (((reg) & DM_CORE_LL1SUBCAPABILITY_L1_2_ASPM_SUPPORT_MASK) >> DM_CORE_LL1SUBCAPABILITY_L1_2_ASPM_SUPPORT_SHIFT)
#define  DM_CORE_LL1SUBCAPABILITY_L1_2_ASPM_SUPPORT_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_LL1SUBCAPABILITY_L1_2_ASPM_SUPPORT_MASK) | (((uint32_t)val) << DM_CORE_LL1SUBCAPABILITY_L1_2_ASPM_SUPPORT_SHIFT))

#define  DM_CORE_LL1SUBCAPABILITY_L1_1_PCIPM_SUPPORT_MASK 0x2
#define  DM_CORE_LL1SUBCAPABILITY_L1_1_PCIPM_SUPPORT_SHIFT 1
#define  DM_CORE_LL1SUBCAPABILITY_L1_1_PCIPM_SUPPORT_MASK_SHIFT(reg) (((reg) & DM_CORE_LL1SUBCAPABILITY_L1_1_PCIPM_SUPPORT_MASK) >> DM_CORE_LL1SUBCAPABILITY_L1_1_PCIPM_SUPPORT_SHIFT)
#define  DM_CORE_LL1SUBCAPABILITY_L1_1_PCIPM_SUPPORT_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_LL1SUBCAPABILITY_L1_1_PCIPM_SUPPORT_MASK) | (((uint32_t)val) << DM_CORE_LL1SUBCAPABILITY_L1_1_PCIPM_SUPPORT_SHIFT))

#define  DM_CORE_LL1SUBCAPABILITY_L1_2_PCIPM_SUPPORT_MASK 0x1
#define  DM_CORE_LL1SUBCAPABILITY_L1_2_PCIPM_SUPPORT_SHIFT 0
#define  DM_CORE_LL1SUBCAPABILITY_L1_2_PCIPM_SUPPORT_MASK_SHIFT(reg) (((reg) & DM_CORE_LL1SUBCAPABILITY_L1_2_PCIPM_SUPPORT_MASK) >> DM_CORE_LL1SUBCAPABILITY_L1_2_PCIPM_SUPPORT_SHIFT)
#define  DM_CORE_LL1SUBCAPABILITY_L1_2_PCIPM_SUPPORT_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_LL1SUBCAPABILITY_L1_2_PCIPM_SUPPORT_MASK) | (((uint32_t)val) << DM_CORE_LL1SUBCAPABILITY_L1_2_PCIPM_SUPPORT_SHIFT))

//====================================================================
//Register: Core Local L1 Substates Control 1 Register (LL1SubControl1)
/** \brief PCI Express L1 Substates Control 1 Register*/
//====================================================================

#define  DM_CORE_LL1SUBCONTROL1_L1_2_TH_SCA_MASK 0xe0000000
#define  DM_CORE_LL1SUBCONTROL1_L1_2_TH_SCA_SHIFT 29
#define  DM_CORE_LL1SUBCONTROL1_L1_2_TH_SCA_MASK_SHIFT(reg) (((reg) & DM_CORE_LL1SUBCONTROL1_L1_2_TH_SCA_MASK) >> DM_CORE_LL1SUBCONTROL1_L1_2_TH_SCA_SHIFT)
#define  DM_CORE_LL1SUBCONTROL1_L1_2_TH_SCA_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_LL1SUBCONTROL1_L1_2_TH_SCA_MASK) | (((uint32_t)val) << DM_CORE_LL1SUBCONTROL1_L1_2_TH_SCA_SHIFT))

#define  DM_CORE_LL1SUBCONTROL1_RESERVED1_MASK 0x1c000000
#define  DM_CORE_LL1SUBCONTROL1_RESERVED1_SHIFT 26
#define  DM_CORE_LL1SUBCONTROL1_RESERVED1_MASK_SHIFT(reg) (((reg) & DM_CORE_LL1SUBCONTROL1_RESERVED1_MASK) >> DM_CORE_LL1SUBCONTROL1_RESERVED1_SHIFT)
#define  DM_CORE_LL1SUBCONTROL1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_LL1SUBCONTROL1_RESERVED1_MASK) | (((uint32_t)val) << DM_CORE_LL1SUBCONTROL1_RESERVED1_SHIFT))

#define  DM_CORE_LL1SUBCONTROL1_L1_2_TH_VAL_MASK 0x3ff0000
#define  DM_CORE_LL1SUBCONTROL1_L1_2_TH_VAL_SHIFT 16
#define  DM_CORE_LL1SUBCONTROL1_L1_2_TH_VAL_MASK_SHIFT(reg) (((reg) & DM_CORE_LL1SUBCONTROL1_L1_2_TH_VAL_MASK) >> DM_CORE_LL1SUBCONTROL1_L1_2_TH_VAL_SHIFT)
#define  DM_CORE_LL1SUBCONTROL1_L1_2_TH_VAL_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_LL1SUBCONTROL1_L1_2_TH_VAL_MASK) | (((uint32_t)val) << DM_CORE_LL1SUBCONTROL1_L1_2_TH_VAL_SHIFT))

#define  DM_CORE_LL1SUBCONTROL1_T_COMMON_MODE_MASK 0xff00
#define  DM_CORE_LL1SUBCONTROL1_T_COMMON_MODE_SHIFT 8
#define  DM_CORE_LL1SUBCONTROL1_T_COMMON_MODE_MASK_SHIFT(reg) (((reg) & DM_CORE_LL1SUBCONTROL1_T_COMMON_MODE_MASK) >> DM_CORE_LL1SUBCONTROL1_T_COMMON_MODE_SHIFT)
#define  DM_CORE_LL1SUBCONTROL1_T_COMMON_MODE_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_LL1SUBCONTROL1_T_COMMON_MODE_MASK) | (((uint32_t)val) << DM_CORE_LL1SUBCONTROL1_T_COMMON_MODE_SHIFT))

#define  DM_CORE_LL1SUBCONTROL1_RESERVED2_MASK 0xf0
#define  DM_CORE_LL1SUBCONTROL1_RESERVED2_SHIFT 4
#define  DM_CORE_LL1SUBCONTROL1_RESERVED2_MASK_SHIFT(reg) (((reg) & DM_CORE_LL1SUBCONTROL1_RESERVED2_MASK) >> DM_CORE_LL1SUBCONTROL1_RESERVED2_SHIFT)
#define  DM_CORE_LL1SUBCONTROL1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_LL1SUBCONTROL1_RESERVED2_MASK) | (((uint32_t)val) << DM_CORE_LL1SUBCONTROL1_RESERVED2_SHIFT))

#define  DM_CORE_LL1SUBCONTROL1_L1_1_ASPM_EN_MASK 0x8
#define  DM_CORE_LL1SUBCONTROL1_L1_1_ASPM_EN_SHIFT 3
#define  DM_CORE_LL1SUBCONTROL1_L1_1_ASPM_EN_MASK_SHIFT(reg) (((reg) & DM_CORE_LL1SUBCONTROL1_L1_1_ASPM_EN_MASK) >> DM_CORE_LL1SUBCONTROL1_L1_1_ASPM_EN_SHIFT)
#define  DM_CORE_LL1SUBCONTROL1_L1_1_ASPM_EN_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_LL1SUBCONTROL1_L1_1_ASPM_EN_MASK) | (((uint32_t)val) << DM_CORE_LL1SUBCONTROL1_L1_1_ASPM_EN_SHIFT))

#define  DM_CORE_LL1SUBCONTROL1_L1_2_ASPM_EN_MASK 0x4
#define  DM_CORE_LL1SUBCONTROL1_L1_2_ASPM_EN_SHIFT 2
#define  DM_CORE_LL1SUBCONTROL1_L1_2_ASPM_EN_MASK_SHIFT(reg) (((reg) & DM_CORE_LL1SUBCONTROL1_L1_2_ASPM_EN_MASK) >> DM_CORE_LL1SUBCONTROL1_L1_2_ASPM_EN_SHIFT)
#define  DM_CORE_LL1SUBCONTROL1_L1_2_ASPM_EN_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_LL1SUBCONTROL1_L1_2_ASPM_EN_MASK) | (((uint32_t)val) << DM_CORE_LL1SUBCONTROL1_L1_2_ASPM_EN_SHIFT))

#define  DM_CORE_LL1SUBCONTROL1_L1_1_PCIPM_EN_MASK 0x2
#define  DM_CORE_LL1SUBCONTROL1_L1_1_PCIPM_EN_SHIFT 1
#define  DM_CORE_LL1SUBCONTROL1_L1_1_PCIPM_EN_MASK_SHIFT(reg) (((reg) & DM_CORE_LL1SUBCONTROL1_L1_1_PCIPM_EN_MASK) >> DM_CORE_LL1SUBCONTROL1_L1_1_PCIPM_EN_SHIFT)
#define  DM_CORE_LL1SUBCONTROL1_L1_1_PCIPM_EN_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_LL1SUBCONTROL1_L1_1_PCIPM_EN_MASK) | (((uint32_t)val) << DM_CORE_LL1SUBCONTROL1_L1_1_PCIPM_EN_SHIFT))

#define  DM_CORE_LL1SUBCONTROL1_L1_2_PCIPM_EN_MASK 0x1
#define  DM_CORE_LL1SUBCONTROL1_L1_2_PCIPM_EN_SHIFT 0
#define  DM_CORE_LL1SUBCONTROL1_L1_2_PCIPM_EN_MASK_SHIFT(reg) (((reg) & DM_CORE_LL1SUBCONTROL1_L1_2_PCIPM_EN_MASK) >> DM_CORE_LL1SUBCONTROL1_L1_2_PCIPM_EN_SHIFT)
#define  DM_CORE_LL1SUBCONTROL1_L1_2_PCIPM_EN_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_LL1SUBCONTROL1_L1_2_PCIPM_EN_MASK) | (((uint32_t)val) << DM_CORE_LL1SUBCONTROL1_L1_2_PCIPM_EN_SHIFT))

//====================================================================
//Register: Core Local L1 Substates Control 2 Register (LL1SubControl2)
/** \brief PCI Express L1 Substates Control 2 Register*/
//====================================================================

#define  DM_CORE_LL1SUBCONTROL2_RESERVED1_MASK 0xffffff00
#define  DM_CORE_LL1SUBCONTROL2_RESERVED1_SHIFT 8
#define  DM_CORE_LL1SUBCONTROL2_RESERVED1_MASK_SHIFT(reg) (((reg) & DM_CORE_LL1SUBCONTROL2_RESERVED1_MASK) >> DM_CORE_LL1SUBCONTROL2_RESERVED1_SHIFT)
#define  DM_CORE_LL1SUBCONTROL2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_LL1SUBCONTROL2_RESERVED1_MASK) | (((uint32_t)val) << DM_CORE_LL1SUBCONTROL2_RESERVED1_SHIFT))

#define  DM_CORE_LL1SUBCONTROL2_T_POWER_ON_VALUE_MASK 0xf8
#define  DM_CORE_LL1SUBCONTROL2_T_POWER_ON_VALUE_SHIFT 3
#define  DM_CORE_LL1SUBCONTROL2_T_POWER_ON_VALUE_MASK_SHIFT(reg) (((reg) & DM_CORE_LL1SUBCONTROL2_T_POWER_ON_VALUE_MASK) >> DM_CORE_LL1SUBCONTROL2_T_POWER_ON_VALUE_SHIFT)
#define  DM_CORE_LL1SUBCONTROL2_T_POWER_ON_VALUE_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_LL1SUBCONTROL2_T_POWER_ON_VALUE_MASK) | (((uint32_t)val) << DM_CORE_LL1SUBCONTROL2_T_POWER_ON_VALUE_SHIFT))

#define  DM_CORE_LL1SUBCONTROL2_RESERVED2_MASK 0x4
#define  DM_CORE_LL1SUBCONTROL2_RESERVED2_SHIFT 2
#define  DM_CORE_LL1SUBCONTROL2_RESERVED2_MASK_SHIFT(reg) (((reg) & DM_CORE_LL1SUBCONTROL2_RESERVED2_MASK) >> DM_CORE_LL1SUBCONTROL2_RESERVED2_SHIFT)
#define  DM_CORE_LL1SUBCONTROL2_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_LL1SUBCONTROL2_RESERVED2_MASK) | (((uint32_t)val) << DM_CORE_LL1SUBCONTROL2_RESERVED2_SHIFT))

#define  DM_CORE_LL1SUBCONTROL2_T_POWER_ON_SCALE_MASK 0x3
#define  DM_CORE_LL1SUBCONTROL2_T_POWER_ON_SCALE_SHIFT 0
#define  DM_CORE_LL1SUBCONTROL2_T_POWER_ON_SCALE_MASK_SHIFT(reg) (((reg) & DM_CORE_LL1SUBCONTROL2_T_POWER_ON_SCALE_MASK) >> DM_CORE_LL1SUBCONTROL2_T_POWER_ON_SCALE_SHIFT)
#define  DM_CORE_LL1SUBCONTROL2_T_POWER_ON_SCALE_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_LL1SUBCONTROL2_T_POWER_ON_SCALE_MASK) | (((uint32_t)val) << DM_CORE_LL1SUBCONTROL2_T_POWER_ON_SCALE_SHIFT))

//====================================================================
//Register: Core Local Port Logic Ack Latency and Replay Timer Register (LPortTimer)
/** \brief Port Logic Ack Latency and Replay Timer Register.
NOTE: This is the start of the Port Logic Registers, primarily used for changing default latencies and debug/test.
See Synopsys Core Reference Manual for detailed register and field descriptions.*/
//====================================================================

#define  DM_CORE_LPORTTIMER_REPLAYTIMER_MASK 0xffff0000
#define  DM_CORE_LPORTTIMER_REPLAYTIMER_SHIFT 16
#define  DM_CORE_LPORTTIMER_REPLAYTIMER_MASK_SHIFT(reg) (((reg) & DM_CORE_LPORTTIMER_REPLAYTIMER_MASK) >> DM_CORE_LPORTTIMER_REPLAYTIMER_SHIFT)
#define  DM_CORE_LPORTTIMER_REPLAYTIMER_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_LPORTTIMER_REPLAYTIMER_MASK) | (((uint32_t)val) << DM_CORE_LPORTTIMER_REPLAYTIMER_SHIFT))

#define  DM_CORE_LPORTTIMER_ACKTIMER_MASK 0xffff
#define  DM_CORE_LPORTTIMER_ACKTIMER_SHIFT 0
#define  DM_CORE_LPORTTIMER_ACKTIMER_MASK_SHIFT(reg) (((reg) & DM_CORE_LPORTTIMER_ACKTIMER_MASK) >> DM_CORE_LPORTTIMER_ACKTIMER_SHIFT)
#define  DM_CORE_LPORTTIMER_ACKTIMER_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_LPORTTIMER_ACKTIMER_MASK) | (((uint32_t)val) << DM_CORE_LPORTTIMER_ACKTIMER_SHIFT))

//====================================================================
//Register: Core Local Port Logic Message Register (LMsgReg)
/** \brief Port Logic Message Register.*/
//====================================================================

#define  DM_CORE_LMSGREG_MSG_MASK 0xffffffff
#define  DM_CORE_LMSGREG_MSG_SHIFT 0
#define  DM_CORE_LMSGREG_MSG_MASK_SHIFT(reg) (((reg) & DM_CORE_LMSGREG_MSG_MASK) >> DM_CORE_LMSGREG_MSG_SHIFT)
#define  DM_CORE_LMSGREG_MSG_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_LMSGREG_MSG_MASK) | (((uint32_t)val) << DM_CORE_LMSGREG_MSG_SHIFT))

//====================================================================
//Register: Core Local Port Logic Force Link Register (LForceLink)
/** \brief Port Logic Force Link Register.*/
//====================================================================

#define  DM_CORE_LFORCELINK_FORCELINK_MASK 0xffffffff
#define  DM_CORE_LFORCELINK_FORCELINK_SHIFT 0
#define  DM_CORE_LFORCELINK_FORCELINK_MASK_SHIFT(reg) (((reg) & DM_CORE_LFORCELINK_FORCELINK_MASK) >> DM_CORE_LFORCELINK_FORCELINK_SHIFT)
#define  DM_CORE_LFORCELINK_FORCELINK_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_LFORCELINK_FORCELINK_MASK) | (((uint32_t)val) << DM_CORE_LFORCELINK_FORCELINK_SHIFT))

//====================================================================
//Register: Core Local Port Logic Ack Frequency Register (LAckFreq)
/** \brief PCI Express Port Logic Ack Frequency Register.*/
//====================================================================

#define  DM_CORE_LACKFREQ_RESERVED1_MASK 0x80000000
#define  DM_CORE_LACKFREQ_RESERVED1_SHIFT 31
#define  DM_CORE_LACKFREQ_RESERVED1_MASK_SHIFT(reg) (((reg) & DM_CORE_LACKFREQ_RESERVED1_MASK) >> DM_CORE_LACKFREQ_RESERVED1_SHIFT)
#define  DM_CORE_LACKFREQ_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_LACKFREQ_RESERVED1_MASK) | (((uint32_t)val) << DM_CORE_LACKFREQ_RESERVED1_SHIFT))

#define  DM_CORE_LACKFREQ_L1NOL0S_MASK 0x40000000
#define  DM_CORE_LACKFREQ_L1NOL0S_SHIFT 30
#define  DM_CORE_LACKFREQ_L1NOL0S_MASK_SHIFT(reg) (((reg) & DM_CORE_LACKFREQ_L1NOL0S_MASK) >> DM_CORE_LACKFREQ_L1NOL0S_SHIFT)
#define  DM_CORE_LACKFREQ_L1NOL0S_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_LACKFREQ_L1NOL0S_MASK) | (((uint32_t)val) << DM_CORE_LACKFREQ_L1NOL0S_SHIFT))

#define  DM_CORE_LACKFREQ_L1ENTRYLAT_MASK 0x38000000
#define  DM_CORE_LACKFREQ_L1ENTRYLAT_SHIFT 27
#define  DM_CORE_LACKFREQ_L1ENTRYLAT_MASK_SHIFT(reg) (((reg) & DM_CORE_LACKFREQ_L1ENTRYLAT_MASK) >> DM_CORE_LACKFREQ_L1ENTRYLAT_SHIFT)
#define  DM_CORE_LACKFREQ_L1ENTRYLAT_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_LACKFREQ_L1ENTRYLAT_MASK) | (((uint32_t)val) << DM_CORE_LACKFREQ_L1ENTRYLAT_SHIFT))

#define  DM_CORE_LACKFREQ_L0SENTRYLAT_MASK 0x7000000
#define  DM_CORE_LACKFREQ_L0SENTRYLAT_SHIFT 24
#define  DM_CORE_LACKFREQ_L0SENTRYLAT_MASK_SHIFT(reg) (((reg) & DM_CORE_LACKFREQ_L0SENTRYLAT_MASK) >> DM_CORE_LACKFREQ_L0SENTRYLAT_SHIFT)
#define  DM_CORE_LACKFREQ_L0SENTRYLAT_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_LACKFREQ_L0SENTRYLAT_MASK) | (((uint32_t)val) << DM_CORE_LACKFREQ_L0SENTRYLAT_SHIFT))

#define  DM_CORE_LACKFREQ_CCLKNFTS_MASK 0xff0000
#define  DM_CORE_LACKFREQ_CCLKNFTS_SHIFT 16
#define  DM_CORE_LACKFREQ_CCLKNFTS_MASK_SHIFT(reg) (((reg) & DM_CORE_LACKFREQ_CCLKNFTS_MASK) >> DM_CORE_LACKFREQ_CCLKNFTS_SHIFT)
#define  DM_CORE_LACKFREQ_CCLKNFTS_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_LACKFREQ_CCLKNFTS_MASK) | (((uint32_t)val) << DM_CORE_LACKFREQ_CCLKNFTS_SHIFT))

#define  DM_CORE_LACKFREQ_NFTS_MASK 0xff00
#define  DM_CORE_LACKFREQ_NFTS_SHIFT 8
#define  DM_CORE_LACKFREQ_NFTS_MASK_SHIFT(reg) (((reg) & DM_CORE_LACKFREQ_NFTS_MASK) >> DM_CORE_LACKFREQ_NFTS_SHIFT)
#define  DM_CORE_LACKFREQ_NFTS_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_LACKFREQ_NFTS_MASK) | (((uint32_t)val) << DM_CORE_LACKFREQ_NFTS_SHIFT))

#define  DM_CORE_LACKFREQ_ACKFREQ_MASK 0xff
#define  DM_CORE_LACKFREQ_ACKFREQ_SHIFT 0
#define  DM_CORE_LACKFREQ_ACKFREQ_MASK_SHIFT(reg) (((reg) & DM_CORE_LACKFREQ_ACKFREQ_MASK) >> DM_CORE_LACKFREQ_ACKFREQ_SHIFT)
#define  DM_CORE_LACKFREQ_ACKFREQ_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_LACKFREQ_ACKFREQ_MASK) | (((uint32_t)val) << DM_CORE_LACKFREQ_ACKFREQ_SHIFT))

//====================================================================
//Register: Core Local Port Link Control Register (LPortLink)
/** \brief PCI Express Port Link Control Register. Bit 7 controls Fast Link Training*/
//====================================================================

#define  DM_CORE_LPORTLINK_RESERVED1_MASK 0xffc00000
#define  DM_CORE_LPORTLINK_RESERVED1_SHIFT 22
#define  DM_CORE_LPORTLINK_RESERVED1_MASK_SHIFT(reg) (((reg) & DM_CORE_LPORTLINK_RESERVED1_MASK) >> DM_CORE_LPORTLINK_RESERVED1_SHIFT)
#define  DM_CORE_LPORTLINK_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_LPORTLINK_RESERVED1_MASK) | (((uint32_t)val) << DM_CORE_LPORTLINK_RESERVED1_SHIFT))

#define  DM_CORE_LPORTLINK_LINKMODEENABLE_MASK 0x3f0000
#define  DM_CORE_LPORTLINK_LINKMODEENABLE_SHIFT 16
#define  DM_CORE_LPORTLINK_LINKMODEENABLE_MASK_SHIFT(reg) (((reg) & DM_CORE_LPORTLINK_LINKMODEENABLE_MASK) >> DM_CORE_LPORTLINK_LINKMODEENABLE_SHIFT)
#define  DM_CORE_LPORTLINK_LINKMODEENABLE_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_LPORTLINK_LINKMODEENABLE_MASK) | (((uint32_t)val) << DM_CORE_LPORTLINK_LINKMODEENABLE_SHIFT))

#define  DM_CORE_LPORTLINK_RESERVED2_MASK 0xff00
#define  DM_CORE_LPORTLINK_RESERVED2_SHIFT 8
#define  DM_CORE_LPORTLINK_RESERVED2_MASK_SHIFT(reg) (((reg) & DM_CORE_LPORTLINK_RESERVED2_MASK) >> DM_CORE_LPORTLINK_RESERVED2_SHIFT)
#define  DM_CORE_LPORTLINK_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_LPORTLINK_RESERVED2_MASK) | (((uint32_t)val) << DM_CORE_LPORTLINK_RESERVED2_SHIFT))

#define  DM_CORE_LPORTLINK_FASTLINKTRNG_MASK 0x80
#define  DM_CORE_LPORTLINK_FASTLINKTRNG_SHIFT 7
#define  DM_CORE_LPORTLINK_FASTLINKTRNG_MASK_SHIFT(reg) (((reg) & DM_CORE_LPORTLINK_FASTLINKTRNG_MASK) >> DM_CORE_LPORTLINK_FASTLINKTRNG_SHIFT)
#define  DM_CORE_LPORTLINK_FASTLINKTRNG_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_LPORTLINK_FASTLINKTRNG_MASK) | (((uint32_t)val) << DM_CORE_LPORTLINK_FASTLINKTRNG_SHIFT))

#define  DM_CORE_LPORTLINK_MISCCONTROL_MASK 0x7f
#define  DM_CORE_LPORTLINK_MISCCONTROL_SHIFT 0
#define  DM_CORE_LPORTLINK_MISCCONTROL_MASK_SHIFT(reg) (((reg) & DM_CORE_LPORTLINK_MISCCONTROL_MASK) >> DM_CORE_LPORTLINK_MISCCONTROL_SHIFT)
#define  DM_CORE_LPORTLINK_MISCCONTROL_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_LPORTLINK_MISCCONTROL_MASK) | (((uint32_t)val) << DM_CORE_LPORTLINK_MISCCONTROL_SHIFT))

//====================================================================
//Register: Core Link Width and Speed Change Control Register (LLWidthSpeed)
/** \brief PCI Express Port Link Width and Speed Change Control Register. Offset = 0x700 + 0x10C*/
//====================================================================

#define  DM_CORE_LLWIDTHSPEED_RESERVED1_MASK 0xffe00000
#define  DM_CORE_LLWIDTHSPEED_RESERVED1_SHIFT 21
#define  DM_CORE_LLWIDTHSPEED_RESERVED1_MASK_SHIFT(reg) (((reg) & DM_CORE_LLWIDTHSPEED_RESERVED1_MASK) >> DM_CORE_LLWIDTHSPEED_RESERVED1_SHIFT)
#define  DM_CORE_LLWIDTHSPEED_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_LLWIDTHSPEED_RESERVED1_MASK) | (((uint32_t)val) << DM_CORE_LLWIDTHSPEED_RESERVED1_SHIFT))

#define  DM_CORE_LLWIDTHSPEED_SELDEEMPH_MASK 0x100000
#define  DM_CORE_LLWIDTHSPEED_SELDEEMPH_SHIFT 20
#define  DM_CORE_LLWIDTHSPEED_SELDEEMPH_MASK_SHIFT(reg) (((reg) & DM_CORE_LLWIDTHSPEED_SELDEEMPH_MASK) >> DM_CORE_LLWIDTHSPEED_SELDEEMPH_SHIFT)
#define  DM_CORE_LLWIDTHSPEED_SELDEEMPH_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_LLWIDTHSPEED_SELDEEMPH_MASK) | (((uint32_t)val) << DM_CORE_LLWIDTHSPEED_SELDEEMPH_SHIFT))

#define  DM_CORE_LLWIDTHSPEED_CFGTXCOMPRX_MASK 0x80000
#define  DM_CORE_LLWIDTHSPEED_CFGTXCOMPRX_SHIFT 19
#define  DM_CORE_LLWIDTHSPEED_CFGTXCOMPRX_MASK_SHIFT(reg) (((reg) & DM_CORE_LLWIDTHSPEED_CFGTXCOMPRX_MASK) >> DM_CORE_LLWIDTHSPEED_CFGTXCOMPRX_SHIFT)
#define  DM_CORE_LLWIDTHSPEED_CFGTXCOMPRX_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_LLWIDTHSPEED_CFGTXCOMPRX_MASK) | (((uint32_t)val) << DM_CORE_LLWIDTHSPEED_CFGTXCOMPRX_SHIFT))

#define  DM_CORE_LLWIDTHSPEED_CFGTXSWING_MASK 0x40000
#define  DM_CORE_LLWIDTHSPEED_CFGTXSWING_SHIFT 18
#define  DM_CORE_LLWIDTHSPEED_CFGTXSWING_MASK_SHIFT(reg) (((reg) & DM_CORE_LLWIDTHSPEED_CFGTXSWING_MASK) >> DM_CORE_LLWIDTHSPEED_CFGTXSWING_SHIFT)
#define  DM_CORE_LLWIDTHSPEED_CFGTXSWING_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_LLWIDTHSPEED_CFGTXSWING_MASK) | (((uint32_t)val) << DM_CORE_LLWIDTHSPEED_CFGTXSWING_SHIFT))

#define  DM_CORE_LLWIDTHSPEED_DIRSPEEDCHG_MASK 0x20000
#define  DM_CORE_LLWIDTHSPEED_DIRSPEEDCHG_SHIFT 17
#define  DM_CORE_LLWIDTHSPEED_DIRSPEEDCHG_MASK_SHIFT(reg) (((reg) & DM_CORE_LLWIDTHSPEED_DIRSPEEDCHG_MASK) >> DM_CORE_LLWIDTHSPEED_DIRSPEEDCHG_SHIFT)
#define  DM_CORE_LLWIDTHSPEED_DIRSPEEDCHG_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_LLWIDTHSPEED_DIRSPEEDCHG_MASK) | (((uint32_t)val) << DM_CORE_LLWIDTHSPEED_DIRSPEEDCHG_SHIFT))

#define  DM_CORE_LLWIDTHSPEED_PREDETNUMLANES_MASK 0x1ff00
#define  DM_CORE_LLWIDTHSPEED_PREDETNUMLANES_SHIFT 8
#define  DM_CORE_LLWIDTHSPEED_PREDETNUMLANES_MASK_SHIFT(reg) (((reg) & DM_CORE_LLWIDTHSPEED_PREDETNUMLANES_MASK) >> DM_CORE_LLWIDTHSPEED_PREDETNUMLANES_SHIFT)
#define  DM_CORE_LLWIDTHSPEED_PREDETNUMLANES_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_LLWIDTHSPEED_PREDETNUMLANES_MASK) | (((uint32_t)val) << DM_CORE_LLWIDTHSPEED_PREDETNUMLANES_SHIFT))

#define  DM_CORE_LLWIDTHSPEED_FASTTRNGSEQ_MASK 0xff
#define  DM_CORE_LLWIDTHSPEED_FASTTRNGSEQ_SHIFT 0
#define  DM_CORE_LLWIDTHSPEED_FASTTRNGSEQ_MASK_SHIFT(reg) (((reg) & DM_CORE_LLWIDTHSPEED_FASTTRNGSEQ_MASK) >> DM_CORE_LLWIDTHSPEED_FASTTRNGSEQ_SHIFT)
#define  DM_CORE_LLWIDTHSPEED_FASTTRNGSEQ_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_LLWIDTHSPEED_FASTTRNGSEQ_MASK) | (((uint32_t)val) << DM_CORE_LLWIDTHSPEED_FASTTRNGSEQ_SHIFT))

//====================================================================
//Register: Local Auxiliary Clock Frequency Control Register (LAuxClkFreqCtrl)
/** \brief Port Logic Aux Clock Frequency Control Register. Used in L1 Substates.*/
//====================================================================

#define  DM_CORE_LAUXCLKFREQCTRL_RESERVED1_MASK 0xfffffc00
#define  DM_CORE_LAUXCLKFREQCTRL_RESERVED1_SHIFT 10
#define  DM_CORE_LAUXCLKFREQCTRL_RESERVED1_MASK_SHIFT(reg) (((reg) & DM_CORE_LAUXCLKFREQCTRL_RESERVED1_MASK) >> DM_CORE_LAUXCLKFREQCTRL_RESERVED1_SHIFT)
#define  DM_CORE_LAUXCLKFREQCTRL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_LAUXCLKFREQCTRL_RESERVED1_MASK) | (((uint32_t)val) << DM_CORE_LAUXCLKFREQCTRL_RESERVED1_SHIFT))

#define  DM_CORE_LAUXCLKFREQCTRL_AUXCLKFREQ_MASK 0x3ff
#define  DM_CORE_LAUXCLKFREQCTRL_AUXCLKFREQ_SHIFT 0
#define  DM_CORE_LAUXCLKFREQCTRL_AUXCLKFREQ_MASK_SHIFT(reg) (((reg) & DM_CORE_LAUXCLKFREQCTRL_AUXCLKFREQ_MASK) >> DM_CORE_LAUXCLKFREQCTRL_AUXCLKFREQ_SHIFT)
#define  DM_CORE_LAUXCLKFREQCTRL_AUXCLKFREQ_REPLACE_VAL(reg,val) (((reg) & ~DM_CORE_LAUXCLKFREQCTRL_AUXCLKFREQ_MASK) | (((uint32_t)val) << DM_CORE_LAUXCLKFREQCTRL_AUXCLKFREQ_SHIFT))

//====================================================================
//
//Register File: PCIE_Dm_App Registers (Dm_App)
/** \brief Top-level register file for PCIE_App*/
//
//====================================================================

//====================================================================
//Register: Application Outbound Address Translation Register 0 (OutAddrXlt0)
/** \brief Core Application Outbound Address Translation Register for Memory TLP's.*/
//====================================================================

#define  DM_APP_OUTADDRXLT0_MEM_MASK 0xffffffff
#define  DM_APP_OUTADDRXLT0_MEM_SHIFT 0
#define  DM_APP_OUTADDRXLT0_MEM_MASK_SHIFT(reg) (((reg) & DM_APP_OUTADDRXLT0_MEM_MASK) >> DM_APP_OUTADDRXLT0_MEM_SHIFT)
#define  DM_APP_OUTADDRXLT0_MEM_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_OUTADDRXLT0_MEM_MASK) | (((uint32_t)val) << DM_APP_OUTADDRXLT0_MEM_SHIFT))

//====================================================================
//Register: Application Outbound Address Translation Register 1 (OutAddrXlt1)
/** \brief Core Application Outbound Address Translation Register for Memory TLP's.*/
//====================================================================

#define  DM_APP_OUTADDRXLT1_MEM_MASK 0xffffffff
#define  DM_APP_OUTADDRXLT1_MEM_SHIFT 0
#define  DM_APP_OUTADDRXLT1_MEM_MASK_SHIFT(reg) (((reg) & DM_APP_OUTADDRXLT1_MEM_MASK) >> DM_APP_OUTADDRXLT1_MEM_SHIFT)
#define  DM_APP_OUTADDRXLT1_MEM_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_OUTADDRXLT1_MEM_MASK) | (((uint32_t)val) << DM_APP_OUTADDRXLT1_MEM_SHIFT))

//====================================================================
//Register: Application Outbound Address Translation Register 2 (OutAddrXlt2)
/** \brief Core Application Outbound Address Translation Register for Memory TLP's.*/
//====================================================================

#define  DM_APP_OUTADDRXLT2_MEM_MASK 0xffffffff
#define  DM_APP_OUTADDRXLT2_MEM_SHIFT 0
#define  DM_APP_OUTADDRXLT2_MEM_MASK_SHIFT(reg) (((reg) & DM_APP_OUTADDRXLT2_MEM_MASK) >> DM_APP_OUTADDRXLT2_MEM_SHIFT)
#define  DM_APP_OUTADDRXLT2_MEM_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_OUTADDRXLT2_MEM_MASK) | (((uint32_t)val) << DM_APP_OUTADDRXLT2_MEM_SHIFT))

//====================================================================
//Register: Application Outbound Address Translation Register 3 (OutAddrXlt3)
/** \brief Core Application Outbound Address Translation Register for Memory TLP's.*/
//====================================================================

#define  DM_APP_OUTADDRXLT3_MEM_MASK 0xffffffff
#define  DM_APP_OUTADDRXLT3_MEM_SHIFT 0
#define  DM_APP_OUTADDRXLT3_MEM_MASK_SHIFT(reg) (((reg) & DM_APP_OUTADDRXLT3_MEM_MASK) >> DM_APP_OUTADDRXLT3_MEM_SHIFT)
#define  DM_APP_OUTADDRXLT3_MEM_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_OUTADDRXLT3_MEM_MASK) | (((uint32_t)val) << DM_APP_OUTADDRXLT3_MEM_SHIFT))

//====================================================================
//Register: Application Outbound Address Translation Register 4 (OutAddrXlt4)
/** \brief Core Application Outbound Address Translation Register for Memory TLP's.*/
//====================================================================

#define  DM_APP_OUTADDRXLT4_MEM_MASK 0xffffffff
#define  DM_APP_OUTADDRXLT4_MEM_SHIFT 0
#define  DM_APP_OUTADDRXLT4_MEM_MASK_SHIFT(reg) (((reg) & DM_APP_OUTADDRXLT4_MEM_MASK) >> DM_APP_OUTADDRXLT4_MEM_SHIFT)
#define  DM_APP_OUTADDRXLT4_MEM_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_OUTADDRXLT4_MEM_MASK) | (((uint32_t)val) << DM_APP_OUTADDRXLT4_MEM_SHIFT))

//====================================================================
//Register: Application Outbound Address Translation Register 5 (OutAddrXlt5)
/** \brief Core Application Outbound Address Translation Register for Memory TLP's.*/
//====================================================================

#define  DM_APP_OUTADDRXLT5_MEM_MASK 0xffffffff
#define  DM_APP_OUTADDRXLT5_MEM_SHIFT 0
#define  DM_APP_OUTADDRXLT5_MEM_MASK_SHIFT(reg) (((reg) & DM_APP_OUTADDRXLT5_MEM_MASK) >> DM_APP_OUTADDRXLT5_MEM_SHIFT)
#define  DM_APP_OUTADDRXLT5_MEM_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_OUTADDRXLT5_MEM_MASK) | (((uint32_t)val) << DM_APP_OUTADDRXLT5_MEM_SHIFT))

//====================================================================
//Register: Application Outbound Address Translation Register 6 (OutAddrXlt6)
/** \brief Core Application Outbound Address Translation Register for Memory TLP's.*/
//====================================================================

#define  DM_APP_OUTADDRXLT6_MEM_MASK 0xffffffff
#define  DM_APP_OUTADDRXLT6_MEM_SHIFT 0
#define  DM_APP_OUTADDRXLT6_MEM_MASK_SHIFT(reg) (((reg) & DM_APP_OUTADDRXLT6_MEM_MASK) >> DM_APP_OUTADDRXLT6_MEM_SHIFT)
#define  DM_APP_OUTADDRXLT6_MEM_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_OUTADDRXLT6_MEM_MASK) | (((uint32_t)val) << DM_APP_OUTADDRXLT6_MEM_SHIFT))

//====================================================================
//Register: Application Outbound Address Translation Register 7 (OutAddrXlt7)
/** \brief Core Application Outbound Address Translation Register for I/O TLP's.*/
//====================================================================

#define  DM_APP_OUTADDRXLT7_MEM_MASK 0xffffffff
#define  DM_APP_OUTADDRXLT7_MEM_SHIFT 0
#define  DM_APP_OUTADDRXLT7_MEM_MASK_SHIFT(reg) (((reg) & DM_APP_OUTADDRXLT7_MEM_MASK) >> DM_APP_OUTADDRXLT7_MEM_SHIFT)
#define  DM_APP_OUTADDRXLT7_MEM_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_OUTADDRXLT7_MEM_MASK) | (((uint32_t)val) << DM_APP_OUTADDRXLT7_MEM_SHIFT))

//====================================================================
//Register: Application Configuration TLP Settings (CfgControl)
/** \brief Core Application Outbound Address Translation Register for Configuration TLP's.  
Configuration TLP's require that the Address[31:16] in the outbound TLP header contain the 
{Bus Number[7:0], Device Number[4:0], Funtion Number[2:0]} fields.
This register provides control of those fields in the Cfg TLP Header.*/
//====================================================================

#define  DM_APP_CFGCONTROL_RESERVED1_MASK 0xfffe0000
#define  DM_APP_CFGCONTROL_RESERVED1_SHIFT 17
#define  DM_APP_CFGCONTROL_RESERVED1_MASK_SHIFT(reg) (((reg) & DM_APP_CFGCONTROL_RESERVED1_MASK) >> DM_APP_CFGCONTROL_RESERVED1_SHIFT)
#define  DM_APP_CFGCONTROL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_CFGCONTROL_RESERVED1_MASK) | (((uint32_t)val) << DM_APP_CFGCONTROL_RESERVED1_SHIFT))

#define  DM_APP_CFGCONTROL_TYPE1_MASK 0x10000
#define  DM_APP_CFGCONTROL_TYPE1_SHIFT 16
#define  DM_APP_CFGCONTROL_TYPE1_MASK_SHIFT(reg) (((reg) & DM_APP_CFGCONTROL_TYPE1_MASK) >> DM_APP_CFGCONTROL_TYPE1_SHIFT)
#define  DM_APP_CFGCONTROL_TYPE1_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_CFGCONTROL_TYPE1_MASK) | (((uint32_t)val) << DM_APP_CFGCONTROL_TYPE1_SHIFT))

#define  DM_APP_CFGCONTROL_BUSNUMBER_MASK 0xff00
#define  DM_APP_CFGCONTROL_BUSNUMBER_SHIFT 8
#define  DM_APP_CFGCONTROL_BUSNUMBER_MASK_SHIFT(reg) (((reg) & DM_APP_CFGCONTROL_BUSNUMBER_MASK) >> DM_APP_CFGCONTROL_BUSNUMBER_SHIFT)
#define  DM_APP_CFGCONTROL_BUSNUMBER_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_CFGCONTROL_BUSNUMBER_MASK) | (((uint32_t)val) << DM_APP_CFGCONTROL_BUSNUMBER_SHIFT))

#define  DM_APP_CFGCONTROL_DEVNUMBER_MASK 0xf8
#define  DM_APP_CFGCONTROL_DEVNUMBER_SHIFT 3
#define  DM_APP_CFGCONTROL_DEVNUMBER_MASK_SHIFT(reg) (((reg) & DM_APP_CFGCONTROL_DEVNUMBER_MASK) >> DM_APP_CFGCONTROL_DEVNUMBER_SHIFT)
#define  DM_APP_CFGCONTROL_DEVNUMBER_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_CFGCONTROL_DEVNUMBER_MASK) | (((uint32_t)val) << DM_APP_CFGCONTROL_DEVNUMBER_SHIFT))

#define  DM_APP_CFGCONTROL_FUNCNUMBER_MASK 0x7
#define  DM_APP_CFGCONTROL_FUNCNUMBER_SHIFT 0
#define  DM_APP_CFGCONTROL_FUNCNUMBER_MASK_SHIFT(reg) (((reg) & DM_APP_CFGCONTROL_FUNCNUMBER_MASK) >> DM_APP_CFGCONTROL_FUNCNUMBER_SHIFT)
#define  DM_APP_CFGCONTROL_FUNCNUMBER_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_CFGCONTROL_FUNCNUMBER_MASK) | (((uint32_t)val) << DM_APP_CFGCONTROL_FUNCNUMBER_SHIFT))

//====================================================================
//Register: Application PHY Lane Number (PhyLaneNum)
/** \brief PHY Lane Number for Multi-Lane PHY's*/
//====================================================================

#define  DM_APP_PHYLANENUM_RESERVED1_MASK 0xffffffe0
#define  DM_APP_PHYLANENUM_RESERVED1_SHIFT 5
#define  DM_APP_PHYLANENUM_RESERVED1_MASK_SHIFT(reg) (((reg) & DM_APP_PHYLANENUM_RESERVED1_MASK) >> DM_APP_PHYLANENUM_RESERVED1_SHIFT)
#define  DM_APP_PHYLANENUM_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_PHYLANENUM_RESERVED1_MASK) | (((uint32_t)val) << DM_APP_PHYLANENUM_RESERVED1_SHIFT))

#define  DM_APP_PHYLANENUM_LANE_MASK 0x1f
#define  DM_APP_PHYLANENUM_LANE_SHIFT 0
#define  DM_APP_PHYLANENUM_LANE_MASK_SHIFT(reg) (((reg) & DM_APP_PHYLANENUM_LANE_MASK) >> DM_APP_PHYLANENUM_LANE_SHIFT)
#define  DM_APP_PHYLANENUM_LANE_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_PHYLANENUM_LANE_MASK) | (((uint32_t)val) << DM_APP_PHYLANENUM_LANE_SHIFT))

//====================================================================
//Register: Reference Clock Buffer Control (RefClkBuf)
/** \brief RefClk Buffer Digital input controls*/
//====================================================================

#define  DM_APP_REFCLKBUF_RESERVED1_MASK 0xfffff800
#define  DM_APP_REFCLKBUF_RESERVED1_SHIFT 11
#define  DM_APP_REFCLKBUF_RESERVED1_MASK_SHIFT(reg) (((reg) & DM_APP_REFCLKBUF_RESERVED1_MASK) >> DM_APP_REFCLKBUF_RESERVED1_SHIFT)
#define  DM_APP_REFCLKBUF_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_REFCLKBUF_RESERVED1_MASK) | (((uint32_t)val) << DM_APP_REFCLKBUF_RESERVED1_SHIFT))

#define  DM_APP_REFCLKBUF_OFFSETEN_MASK 0x400
#define  DM_APP_REFCLKBUF_OFFSETEN_SHIFT 10
#define  DM_APP_REFCLKBUF_OFFSETEN_MASK_SHIFT(reg) (((reg) & DM_APP_REFCLKBUF_OFFSETEN_MASK) >> DM_APP_REFCLKBUF_OFFSETEN_SHIFT)
#define  DM_APP_REFCLKBUF_OFFSETEN_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_REFCLKBUF_OFFSETEN_MASK) | (((uint32_t)val) << DM_APP_REFCLKBUF_OFFSETEN_SHIFT))

#define  DM_APP_REFCLKBUF_OFFSETPOL_MASK 0x200
#define  DM_APP_REFCLKBUF_OFFSETPOL_SHIFT 9
#define  DM_APP_REFCLKBUF_OFFSETPOL_MASK_SHIFT(reg) (((reg) & DM_APP_REFCLKBUF_OFFSETPOL_MASK) >> DM_APP_REFCLKBUF_OFFSETPOL_SHIFT)
#define  DM_APP_REFCLKBUF_OFFSETPOL_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_REFCLKBUF_OFFSETPOL_MASK) | (((uint32_t)val) << DM_APP_REFCLKBUF_OFFSETPOL_SHIFT))

#define  DM_APP_REFCLKBUF_LOWOFFSET_MASK 0x100
#define  DM_APP_REFCLKBUF_LOWOFFSET_SHIFT 8
#define  DM_APP_REFCLKBUF_LOWOFFSET_MASK_SHIFT(reg) (((reg) & DM_APP_REFCLKBUF_LOWOFFSET_MASK) >> DM_APP_REFCLKBUF_LOWOFFSET_SHIFT)
#define  DM_APP_REFCLKBUF_LOWOFFSET_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_REFCLKBUF_LOWOFFSET_MASK) | (((uint32_t)val) << DM_APP_REFCLKBUF_LOWOFFSET_SHIFT))

#define  DM_APP_REFCLKBUF_SELREGLV_MASK 0xc0
#define  DM_APP_REFCLKBUF_SELREGLV_SHIFT 6
#define  DM_APP_REFCLKBUF_SELREGLV_MASK_SHIFT(reg) (((reg) & DM_APP_REFCLKBUF_SELREGLV_MASK) >> DM_APP_REFCLKBUF_SELREGLV_SHIFT)
#define  DM_APP_REFCLKBUF_SELREGLV_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_REFCLKBUF_SELREGLV_MASK) | (((uint32_t)val) << DM_APP_REFCLKBUF_SELREGLV_SHIFT))

#define  DM_APP_REFCLKBUF_SELAMP_MASK 0x38
#define  DM_APP_REFCLKBUF_SELAMP_SHIFT 3
#define  DM_APP_REFCLKBUF_SELAMP_MASK_SHIFT(reg) (((reg) & DM_APP_REFCLKBUF_SELAMP_MASK) >> DM_APP_REFCLKBUF_SELAMP_SHIFT)
#define  DM_APP_REFCLKBUF_SELAMP_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_REFCLKBUF_SELAMP_MASK) | (((uint32_t)val) << DM_APP_REFCLKBUF_SELAMP_SHIFT))

#define  DM_APP_REFCLKBUF_TESTANA_MASK 0x7
#define  DM_APP_REFCLKBUF_TESTANA_SHIFT 0
#define  DM_APP_REFCLKBUF_TESTANA_MASK_SHIFT(reg) (((reg) & DM_APP_REFCLKBUF_TESTANA_MASK) >> DM_APP_REFCLKBUF_TESTANA_SHIFT)
#define  DM_APP_REFCLKBUF_TESTANA_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_REFCLKBUF_TESTANA_MASK) | (((uint32_t)val) << DM_APP_REFCLKBUF_TESTANA_SHIFT))

//====================================================================
//Register: IP Tagging Revision 0 (REV0)
/** \brief Provide means for firmware to read IP tagging information.
    This register of particular interest to firmware.*/
//====================================================================

#define  DM_APP_REV0_MAJ_MASK 0xffff0000
#define  DM_APP_REV0_MAJ_SHIFT 16
#define  DM_APP_REV0_MAJ_MASK_SHIFT(reg) (((reg) & DM_APP_REV0_MAJ_MASK) >> DM_APP_REV0_MAJ_SHIFT)
#define  DM_APP_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_REV0_MAJ_MASK) | (((uint32_t)val) << DM_APP_REV0_MAJ_SHIFT))

#define  DM_APP_REV0_MID_MASK 0xffff
#define  DM_APP_REV0_MID_SHIFT 0
#define  DM_APP_REV0_MID_MASK_SHIFT(reg) (((reg) & DM_APP_REV0_MID_MASK) >> DM_APP_REV0_MID_SHIFT)
#define  DM_APP_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_REV0_MID_MASK) | (((uint32_t)val) << DM_APP_REV0_MID_SHIFT))

//====================================================================
//Register: IP Tagging Revision 1 (REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  DM_APP_REV1_RESERVED1_MASK 0xffff0000
#define  DM_APP_REV1_RESERVED1_SHIFT 16
#define  DM_APP_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & DM_APP_REV1_RESERVED1_MASK) >> DM_APP_REV1_RESERVED1_SHIFT)
#define  DM_APP_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_REV1_RESERVED1_MASK) | (((uint32_t)val) << DM_APP_REV1_RESERVED1_SHIFT))

#define  DM_APP_REV1_CFG_MASK 0xffff
#define  DM_APP_REV1_CFG_SHIFT 0
#define  DM_APP_REV1_CFG_MASK_SHIFT(reg) (((reg) & DM_APP_REV1_CFG_MASK) >> DM_APP_REV1_CFG_SHIFT)
#define  DM_APP_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_REV1_CFG_MASK) | (((uint32_t)val) << DM_APP_REV1_CFG_SHIFT))

//====================================================================
//Register: Application Control Register (ACtrl)
/** \brief Start of the Core Application Registers - Control Register*/
//====================================================================

#define  DM_APP_ACTRL_INTP_DIAG_MASK 0x80000000
#define  DM_APP_ACTRL_INTP_DIAG_SHIFT 31
#define  DM_APP_ACTRL_INTP_DIAG_MASK_SHIFT(reg) (((reg) & DM_APP_ACTRL_INTP_DIAG_MASK) >> DM_APP_ACTRL_INTP_DIAG_SHIFT)
#define  DM_APP_ACTRL_INTP_DIAG_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_ACTRL_INTP_DIAG_MASK) | (((uint32_t)val) << DM_APP_ACTRL_INTP_DIAG_SHIFT))

#define  DM_APP_ACTRL_RESERVED1_MASK 0x7fff0000
#define  DM_APP_ACTRL_RESERVED1_SHIFT 16
#define  DM_APP_ACTRL_RESERVED1_MASK_SHIFT(reg) (((reg) & DM_APP_ACTRL_RESERVED1_MASK) >> DM_APP_ACTRL_RESERVED1_SHIFT)
#define  DM_APP_ACTRL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_ACTRL_RESERVED1_MASK) | (((uint32_t)val) << DM_APP_ACTRL_RESERVED1_SHIFT))

#define  DM_APP_ACTRL_LTSSM_EN_MASK 0x8000
#define  DM_APP_ACTRL_LTSSM_EN_SHIFT 15
#define  DM_APP_ACTRL_LTSSM_EN_MASK_SHIFT(reg) (((reg) & DM_APP_ACTRL_LTSSM_EN_MASK) >> DM_APP_ACTRL_LTSSM_EN_SHIFT)
#define  DM_APP_ACTRL_LTSSM_EN_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_ACTRL_LTSSM_EN_MASK) | (((uint32_t)val) << DM_APP_ACTRL_LTSSM_EN_SHIFT))

#define  DM_APP_ACTRL_L1EXIT_MASK 0x4000
#define  DM_APP_ACTRL_L1EXIT_SHIFT 14
#define  DM_APP_ACTRL_L1EXIT_MASK_SHIFT(reg) (((reg) & DM_APP_ACTRL_L1EXIT_MASK) >> DM_APP_ACTRL_L1EXIT_SHIFT)
#define  DM_APP_ACTRL_L1EXIT_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_ACTRL_L1EXIT_MASK) | (((uint32_t)val) << DM_APP_ACTRL_L1EXIT_SHIFT))

#define  DM_APP_ACTRL_APPINITRST_MASK 0x2000
#define  DM_APP_ACTRL_APPINITRST_SHIFT 13
#define  DM_APP_ACTRL_APPINITRST_MASK_SHIFT(reg) (((reg) & DM_APP_ACTRL_APPINITRST_MASK) >> DM_APP_ACTRL_APPINITRST_SHIFT)
#define  DM_APP_ACTRL_APPINITRST_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_ACTRL_APPINITRST_MASK) | (((uint32_t)val) << DM_APP_ACTRL_APPINITRST_SHIFT))

#define  DM_APP_ACTRL_RESERVED2_MASK 0x1c00
#define  DM_APP_ACTRL_RESERVED2_SHIFT 10
#define  DM_APP_ACTRL_RESERVED2_MASK_SHIFT(reg) (((reg) & DM_APP_ACTRL_RESERVED2_MASK) >> DM_APP_ACTRL_RESERVED2_SHIFT)
#define  DM_APP_ACTRL_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_ACTRL_RESERVED2_MASK) | (((uint32_t)val) << DM_APP_ACTRL_RESERVED2_SHIFT))

#define  DM_APP_ACTRL_MSTRRESPERRMAP_MASK 0x300
#define  DM_APP_ACTRL_MSTRRESPERRMAP_SHIFT 8
#define  DM_APP_ACTRL_MSTRRESPERRMAP_MASK_SHIFT(reg) (((reg) & DM_APP_ACTRL_MSTRRESPERRMAP_MASK) >> DM_APP_ACTRL_MSTRRESPERRMAP_SHIFT)
#define  DM_APP_ACTRL_MSTRRESPERRMAP_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_ACTRL_MSTRRESPERRMAP_MASK) | (((uint32_t)val) << DM_APP_ACTRL_MSTRRESPERRMAP_SHIFT))

#define  DM_APP_ACTRL_RESERVED3_MASK 0xc0
#define  DM_APP_ACTRL_RESERVED3_SHIFT 6
#define  DM_APP_ACTRL_RESERVED3_MASK_SHIFT(reg) (((reg) & DM_APP_ACTRL_RESERVED3_MASK) >> DM_APP_ACTRL_RESERVED3_SHIFT)
#define  DM_APP_ACTRL_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_ACTRL_RESERVED3_MASK) | (((uint32_t)val) << DM_APP_ACTRL_RESERVED3_SHIFT))

#define  DM_APP_ACTRL_SLVRESPERRMAP_MASK 0x3f
#define  DM_APP_ACTRL_SLVRESPERRMAP_SHIFT 0
#define  DM_APP_ACTRL_SLVRESPERRMAP_MASK_SHIFT(reg) (((reg) & DM_APP_ACTRL_SLVRESPERRMAP_MASK) >> DM_APP_ACTRL_SLVRESPERRMAP_SHIFT)
#define  DM_APP_ACTRL_SLVRESPERRMAP_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_ACTRL_SLVRESPERRMAP_MASK) | (((uint32_t)val) << DM_APP_ACTRL_SLVRESPERRMAP_SHIFT))

//====================================================================
//Register: Application Status Register (AStat)
/** \brief Collects Non-Interrupt type Status bits*/
//====================================================================

#define  DM_APP_ASTAT_RESERVED1_MASK 0xffffff00
#define  DM_APP_ASTAT_RESERVED1_SHIFT 8
#define  DM_APP_ASTAT_RESERVED1_MASK_SHIFT(reg) (((reg) & DM_APP_ASTAT_RESERVED1_MASK) >> DM_APP_ASTAT_RESERVED1_SHIFT)
#define  DM_APP_ASTAT_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_ASTAT_RESERVED1_MASK) | (((uint32_t)val) << DM_APP_ASTAT_RESERVED1_SHIFT))

#define  DM_APP_ASTAT_LTSSMLINKUP_MASK 0x80
#define  DM_APP_ASTAT_LTSSMLINKUP_SHIFT 7
#define  DM_APP_ASTAT_LTSSMLINKUP_MASK_SHIFT(reg) (((reg) & DM_APP_ASTAT_LTSSMLINKUP_MASK) >> DM_APP_ASTAT_LTSSMLINKUP_SHIFT)
#define  DM_APP_ASTAT_LTSSMLINKUP_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_ASTAT_LTSSMLINKUP_MASK) | (((uint32_t)val) << DM_APP_ASTAT_LTSSMLINKUP_SHIFT))

#define  DM_APP_ASTAT_RESERVED2_MASK 0x40
#define  DM_APP_ASTAT_RESERVED2_SHIFT 6
#define  DM_APP_ASTAT_RESERVED2_MASK_SHIFT(reg) (((reg) & DM_APP_ASTAT_RESERVED2_MASK) >> DM_APP_ASTAT_RESERVED2_SHIFT)
#define  DM_APP_ASTAT_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_ASTAT_RESERVED2_MASK) | (((uint32_t)val) << DM_APP_ASTAT_RESERVED2_SHIFT))

#define  DM_APP_ASTAT_LTSSMLINKSTATUS_MASK 0x3f
#define  DM_APP_ASTAT_LTSSMLINKSTATUS_SHIFT 0
#define  DM_APP_ASTAT_LTSSMLINKSTATUS_MASK_SHIFT(reg) (((reg) & DM_APP_ASTAT_LTSSMLINKSTATUS_MASK) >> DM_APP_ASTAT_LTSSMLINKSTATUS_SHIFT)
#define  DM_APP_ASTAT_LTSSMLINKSTATUS_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_ASTAT_LTSSMLINKSTATUS_MASK) | (((uint32_t)val) << DM_APP_ASTAT_LTSSMLINKSTATUS_SHIFT))

//====================================================================
//Register: Application Interrupt Pending Register (AIntP)
/** \brief Collects Interrupt Pending bits*/
//====================================================================

#define  DM_APP_AINTP_GMCOMPLOOKUPERR_MASK 0x80000000
#define  DM_APP_AINTP_GMCOMPLOOKUPERR_SHIFT 31
#define  DM_APP_AINTP_GMCOMPLOOKUPERR_MASK_SHIFT(reg) (((reg) & DM_APP_AINTP_GMCOMPLOOKUPERR_MASK) >> DM_APP_AINTP_GMCOMPLOOKUPERR_SHIFT)
#define  DM_APP_AINTP_GMCOMPLOOKUPERR_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_AINTP_GMCOMPLOOKUPERR_MASK) | (((uint32_t)val) << DM_APP_AINTP_GMCOMPLOOKUPERR_SHIFT))

#define  DM_APP_AINTP_RADMXCOMPLOOKUPERR_MASK 0x40000000
#define  DM_APP_AINTP_RADMXCOMPLOOKUPERR_SHIFT 30
#define  DM_APP_AINTP_RADMXCOMPLOOKUPERR_MASK_SHIFT(reg) (((reg) & DM_APP_AINTP_RADMXCOMPLOOKUPERR_MASK) >> DM_APP_AINTP_RADMXCOMPLOOKUPERR_SHIFT)
#define  DM_APP_AINTP_RADMXCOMPLOOKUPERR_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_AINTP_RADMXCOMPLOOKUPERR_MASK) | (((uint32_t)val) << DM_APP_AINTP_RADMXCOMPLOOKUPERR_SHIFT))

#define  DM_APP_AINTP_CFGSYSERRRC_MASK 0x20000000
#define  DM_APP_AINTP_CFGSYSERRRC_SHIFT 29
#define  DM_APP_AINTP_CFGSYSERRRC_MASK_SHIFT(reg) (((reg) & DM_APP_AINTP_CFGSYSERRRC_MASK) >> DM_APP_AINTP_CFGSYSERRRC_SHIFT)
#define  DM_APP_AINTP_CFGSYSERRRC_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_AINTP_CFGSYSERRRC_MASK) | (((uint32_t)val) << DM_APP_AINTP_CFGSYSERRRC_SHIFT))

#define  DM_APP_AINTP_INVINTLPTYPE_MASK 0x10000000
#define  DM_APP_AINTP_INVINTLPTYPE_SHIFT 28
#define  DM_APP_AINTP_INVINTLPTYPE_MASK_SHIFT(reg) (((reg) & DM_APP_AINTP_INVINTLPTYPE_MASK) >> DM_APP_AINTP_INVINTLPTYPE_SHIFT)
#define  DM_APP_AINTP_INVINTLPTYPE_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_AINTP_INVINTLPTYPE_MASK) | (((uint32_t)val) << DM_APP_AINTP_INVINTLPTYPE_SHIFT))

#define  DM_APP_AINTP_CFGPMEINT_MASK 0x8000000
#define  DM_APP_AINTP_CFGPMEINT_SHIFT 27
#define  DM_APP_AINTP_CFGPMEINT_MASK_SHIFT(reg) (((reg) & DM_APP_AINTP_CFGPMEINT_MASK) >> DM_APP_AINTP_CFGPMEINT_SHIFT)
#define  DM_APP_AINTP_CFGPMEINT_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_AINTP_CFGPMEINT_MASK) | (((uint32_t)val) << DM_APP_AINTP_CFGPMEINT_SHIFT))

#define  DM_APP_AINTP_CFGPMEMSI_MASK 0x4000000
#define  DM_APP_AINTP_CFGPMEMSI_SHIFT 26
#define  DM_APP_AINTP_CFGPMEMSI_MASK_SHIFT(reg) (((reg) & DM_APP_AINTP_CFGPMEMSI_MASK) >> DM_APP_AINTP_CFGPMEMSI_SHIFT)
#define  DM_APP_AINTP_CFGPMEMSI_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_AINTP_CFGPMEMSI_MASK) | (((uint32_t)val) << DM_APP_AINTP_CFGPMEMSI_SHIFT))

#define  DM_APP_AINTP_RESERVED1_MASK 0x2000000
#define  DM_APP_AINTP_RESERVED1_SHIFT 25
#define  DM_APP_AINTP_RESERVED1_MASK_SHIFT(reg) (((reg) & DM_APP_AINTP_RESERVED1_MASK) >> DM_APP_AINTP_RESERVED1_SHIFT)
#define  DM_APP_AINTP_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_AINTP_RESERVED1_MASK) | (((uint32_t)val) << DM_APP_AINTP_RESERVED1_SHIFT))

#define  DM_APP_AINTP_LINKREQRST_MASK 0x1000000
#define  DM_APP_AINTP_LINKREQRST_SHIFT 24
#define  DM_APP_AINTP_LINKREQRST_MASK_SHIFT(reg) (((reg) & DM_APP_AINTP_LINKREQRST_MASK) >> DM_APP_AINTP_LINKREQRST_SHIFT)
#define  DM_APP_AINTP_LINKREQRST_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_AINTP_LINKREQRST_MASK) | (((uint32_t)val) << DM_APP_AINTP_LINKREQRST_SHIFT))

#define  DM_APP_AINTP_CFGAERERRINT_MASK 0x800000
#define  DM_APP_AINTP_CFGAERERRINT_SHIFT 23
#define  DM_APP_AINTP_CFGAERERRINT_MASK_SHIFT(reg) (((reg) & DM_APP_AINTP_CFGAERERRINT_MASK) >> DM_APP_AINTP_CFGAERERRINT_SHIFT)
#define  DM_APP_AINTP_CFGAERERRINT_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_AINTP_CFGAERERRINT_MASK) | (((uint32_t)val) << DM_APP_AINTP_CFGAERERRINT_SHIFT))

#define  DM_APP_AINTP_CFGAERERRMSI_MASK 0x400000
#define  DM_APP_AINTP_CFGAERERRMSI_SHIFT 22
#define  DM_APP_AINTP_CFGAERERRMSI_MASK_SHIFT(reg) (((reg) & DM_APP_AINTP_CFGAERERRMSI_MASK) >> DM_APP_AINTP_CFGAERERRMSI_SHIFT)
#define  DM_APP_AINTP_CFGAERERRMSI_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_AINTP_CFGAERERRMSI_MASK) | (((uint32_t)val) << DM_APP_AINTP_CFGAERERRMSI_SHIFT))

#define  DM_APP_AINTP_RESERVED2_MASK 0x200000
#define  DM_APP_AINTP_RESERVED2_SHIFT 21
#define  DM_APP_AINTP_RESERVED2_MASK_SHIFT(reg) (((reg) & DM_APP_AINTP_RESERVED2_MASK) >> DM_APP_AINTP_RESERVED2_SHIFT)
#define  DM_APP_AINTP_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_AINTP_RESERVED2_MASK) | (((uint32_t)val) << DM_APP_AINTP_RESERVED2_SHIFT))

#define  DM_APP_AINTP_CFGAERINTMSGNUM_MASK 0x1f0000
#define  DM_APP_AINTP_CFGAERINTMSGNUM_SHIFT 16
#define  DM_APP_AINTP_CFGAERINTMSGNUM_MASK_SHIFT(reg) (((reg) & DM_APP_AINTP_CFGAERINTMSGNUM_MASK) >> DM_APP_AINTP_CFGAERINTMSGNUM_SHIFT)
#define  DM_APP_AINTP_CFGAERINTMSGNUM_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_AINTP_CFGAERINTMSGNUM_MASK) | (((uint32_t)val) << DM_APP_AINTP_CFGAERINTMSGNUM_SHIFT))

#define  DM_APP_AINTP_RADMFATAL_MASK 0x8000
#define  DM_APP_AINTP_RADMFATAL_SHIFT 15
#define  DM_APP_AINTP_RADMFATAL_MASK_SHIFT(reg) (((reg) & DM_APP_AINTP_RADMFATAL_MASK) >> DM_APP_AINTP_RADMFATAL_SHIFT)
#define  DM_APP_AINTP_RADMFATAL_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_AINTP_RADMFATAL_MASK) | (((uint32_t)val) << DM_APP_AINTP_RADMFATAL_SHIFT))

#define  DM_APP_AINTP_RADMNONFATAL_MASK 0x4000
#define  DM_APP_AINTP_RADMNONFATAL_SHIFT 14
#define  DM_APP_AINTP_RADMNONFATAL_MASK_SHIFT(reg) (((reg) & DM_APP_AINTP_RADMNONFATAL_MASK) >> DM_APP_AINTP_RADMNONFATAL_SHIFT)
#define  DM_APP_AINTP_RADMNONFATAL_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_AINTP_RADMNONFATAL_MASK) | (((uint32_t)val) << DM_APP_AINTP_RADMNONFATAL_SHIFT))

#define  DM_APP_AINTP_RADMCORRERR_MASK 0x2000
#define  DM_APP_AINTP_RADMCORRERR_SHIFT 13
#define  DM_APP_AINTP_RADMCORRERR_MASK_SHIFT(reg) (((reg) & DM_APP_AINTP_RADMCORRERR_MASK) >> DM_APP_AINTP_RADMCORRERR_SHIFT)
#define  DM_APP_AINTP_RADMCORRERR_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_AINTP_RADMCORRERR_MASK) | (((uint32_t)val) << DM_APP_AINTP_RADMCORRERR_SHIFT))

#define  DM_APP_AINTP_RADMPME_MASK 0x1000
#define  DM_APP_AINTP_RADMPME_SHIFT 12
#define  DM_APP_AINTP_RADMPME_MASK_SHIFT(reg) (((reg) & DM_APP_AINTP_RADMPME_MASK) >> DM_APP_AINTP_RADMPME_SHIFT)
#define  DM_APP_AINTP_RADMPME_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_AINTP_RADMPME_MASK) | (((uint32_t)val) << DM_APP_AINTP_RADMPME_SHIFT))

#define  DM_APP_AINTP_RADMCPLTIMEOUT_MASK 0x800
#define  DM_APP_AINTP_RADMCPLTIMEOUT_SHIFT 11
#define  DM_APP_AINTP_RADMCPLTIMEOUT_MASK_SHIFT(reg) (((reg) & DM_APP_AINTP_RADMCPLTIMEOUT_MASK) >> DM_APP_AINTP_RADMCPLTIMEOUT_SHIFT)
#define  DM_APP_AINTP_RADMCPLTIMEOUT_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_AINTP_RADMCPLTIMEOUT_MASK) | (((uint32_t)val) << DM_APP_AINTP_RADMCPLTIMEOUT_SHIFT))

#define  DM_APP_AINTP_RESERVED3_MASK 0x400
#define  DM_APP_AINTP_RESERVED3_SHIFT 10
#define  DM_APP_AINTP_RESERVED3_MASK_SHIFT(reg) (((reg) & DM_APP_AINTP_RESERVED3_MASK) >> DM_APP_AINTP_RESERVED3_SHIFT)
#define  DM_APP_AINTP_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_AINTP_RESERVED3_MASK) | (((uint32_t)val) << DM_APP_AINTP_RESERVED3_SHIFT))

#define  DM_APP_AINTP_RADMCPLUR_MASK 0x200
#define  DM_APP_AINTP_RADMCPLUR_SHIFT 9
#define  DM_APP_AINTP_RADMCPLUR_MASK_SHIFT(reg) (((reg) & DM_APP_AINTP_RADMCPLUR_MASK) >> DM_APP_AINTP_RADMCPLUR_SHIFT)
#define  DM_APP_AINTP_RADMCPLUR_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_AINTP_RADMCPLUR_MASK) | (((uint32_t)val) << DM_APP_AINTP_RADMCPLUR_SHIFT))

#define  DM_APP_AINTP_RADMCA_MASK 0x100
#define  DM_APP_AINTP_RADMCA_SHIFT 8
#define  DM_APP_AINTP_RADMCA_MASK_SHIFT(reg) (((reg) & DM_APP_AINTP_RADMCA_MASK) >> DM_APP_AINTP_RADMCA_SHIFT)
#define  DM_APP_AINTP_RADMCA_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_AINTP_RADMCA_MASK) | (((uint32_t)val) << DM_APP_AINTP_RADMCA_SHIFT))

#define  DM_APP_AINTP_RESERVED4_MASK 0xe0
#define  DM_APP_AINTP_RESERVED4_SHIFT 5
#define  DM_APP_AINTP_RESERVED4_MASK_SHIFT(reg) (((reg) & DM_APP_AINTP_RESERVED4_MASK) >> DM_APP_AINTP_RESERVED4_SHIFT)
#define  DM_APP_AINTP_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_AINTP_RESERVED4_MASK) | (((uint32_t)val) << DM_APP_AINTP_RESERVED4_SHIFT))

#define  DM_APP_AINTP_TRGTCPLTIMEOUT_MASK 0x10
#define  DM_APP_AINTP_TRGTCPLTIMEOUT_SHIFT 4
#define  DM_APP_AINTP_TRGTCPLTIMEOUT_MASK_SHIFT(reg) (((reg) & DM_APP_AINTP_TRGTCPLTIMEOUT_MASK) >> DM_APP_AINTP_TRGTCPLTIMEOUT_SHIFT)
#define  DM_APP_AINTP_TRGTCPLTIMEOUT_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_AINTP_TRGTCPLTIMEOUT_MASK) | (((uint32_t)val) << DM_APP_AINTP_TRGTCPLTIMEOUT_SHIFT))

#define  DM_APP_AINTP_TRGTLOOKUPEMPTY_MASK 0x8
#define  DM_APP_AINTP_TRGTLOOKUPEMPTY_SHIFT 3
#define  DM_APP_AINTP_TRGTLOOKUPEMPTY_MASK_SHIFT(reg) (((reg) & DM_APP_AINTP_TRGTLOOKUPEMPTY_MASK) >> DM_APP_AINTP_TRGTLOOKUPEMPTY_SHIFT)
#define  DM_APP_AINTP_TRGTLOOKUPEMPTY_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_AINTP_TRGTLOOKUPEMPTY_MASK) | (((uint32_t)val) << DM_APP_AINTP_TRGTLOOKUPEMPTY_SHIFT))

#define  DM_APP_AINTP_RESERVED5_MASK 0x6
#define  DM_APP_AINTP_RESERVED5_SHIFT 1
#define  DM_APP_AINTP_RESERVED5_MASK_SHIFT(reg) (((reg) & DM_APP_AINTP_RESERVED5_MASK) >> DM_APP_AINTP_RESERVED5_SHIFT)
#define  DM_APP_AINTP_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_AINTP_RESERVED5_MASK) | (((uint32_t)val) << DM_APP_AINTP_RESERVED5_SHIFT))

#define  DM_APP_AINTP_TRNGRESET_MASK 0x1
#define  DM_APP_AINTP_TRNGRESET_SHIFT 0
#define  DM_APP_AINTP_TRNGRESET_MASK_SHIFT(reg) (((reg) & DM_APP_AINTP_TRNGRESET_MASK) >> DM_APP_AINTP_TRNGRESET_SHIFT)
#define  DM_APP_AINTP_TRNGRESET_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_AINTP_TRNGRESET_MASK) | (((uint32_t)val) << DM_APP_AINTP_TRNGRESET_SHIFT))

//====================================================================
//Register: Application Interrupt Enable Register (AIntEn)
/** \brief Enable bits corresonding to each Interrupt Pending Register bit, excepting the
AER Interrupt Message Number status bits.*/
//====================================================================

#define  DM_APP_AINTEN_GMCOMPLOOKUPERR_MASK 0x80000000
#define  DM_APP_AINTEN_GMCOMPLOOKUPERR_SHIFT 31
#define  DM_APP_AINTEN_GMCOMPLOOKUPERR_MASK_SHIFT(reg) (((reg) & DM_APP_AINTEN_GMCOMPLOOKUPERR_MASK) >> DM_APP_AINTEN_GMCOMPLOOKUPERR_SHIFT)
#define  DM_APP_AINTEN_GMCOMPLOOKUPERR_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_AINTEN_GMCOMPLOOKUPERR_MASK) | (((uint32_t)val) << DM_APP_AINTEN_GMCOMPLOOKUPERR_SHIFT))

#define  DM_APP_AINTEN_RADMXCOMPLOOKUPERR_MASK 0x40000000
#define  DM_APP_AINTEN_RADMXCOMPLOOKUPERR_SHIFT 30
#define  DM_APP_AINTEN_RADMXCOMPLOOKUPERR_MASK_SHIFT(reg) (((reg) & DM_APP_AINTEN_RADMXCOMPLOOKUPERR_MASK) >> DM_APP_AINTEN_RADMXCOMPLOOKUPERR_SHIFT)
#define  DM_APP_AINTEN_RADMXCOMPLOOKUPERR_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_AINTEN_RADMXCOMPLOOKUPERR_MASK) | (((uint32_t)val) << DM_APP_AINTEN_RADMXCOMPLOOKUPERR_SHIFT))

#define  DM_APP_AINTEN_CFGSYSERRRC_MASK 0x20000000
#define  DM_APP_AINTEN_CFGSYSERRRC_SHIFT 29
#define  DM_APP_AINTEN_CFGSYSERRRC_MASK_SHIFT(reg) (((reg) & DM_APP_AINTEN_CFGSYSERRRC_MASK) >> DM_APP_AINTEN_CFGSYSERRRC_SHIFT)
#define  DM_APP_AINTEN_CFGSYSERRRC_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_AINTEN_CFGSYSERRRC_MASK) | (((uint32_t)val) << DM_APP_AINTEN_CFGSYSERRRC_SHIFT))

#define  DM_APP_AINTEN_INVINTLPTYPE_MASK 0x10000000
#define  DM_APP_AINTEN_INVINTLPTYPE_SHIFT 28
#define  DM_APP_AINTEN_INVINTLPTYPE_MASK_SHIFT(reg) (((reg) & DM_APP_AINTEN_INVINTLPTYPE_MASK) >> DM_APP_AINTEN_INVINTLPTYPE_SHIFT)
#define  DM_APP_AINTEN_INVINTLPTYPE_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_AINTEN_INVINTLPTYPE_MASK) | (((uint32_t)val) << DM_APP_AINTEN_INVINTLPTYPE_SHIFT))

#define  DM_APP_AINTEN_CFGPMEINT_MASK 0x8000000
#define  DM_APP_AINTEN_CFGPMEINT_SHIFT 27
#define  DM_APP_AINTEN_CFGPMEINT_MASK_SHIFT(reg) (((reg) & DM_APP_AINTEN_CFGPMEINT_MASK) >> DM_APP_AINTEN_CFGPMEINT_SHIFT)
#define  DM_APP_AINTEN_CFGPMEINT_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_AINTEN_CFGPMEINT_MASK) | (((uint32_t)val) << DM_APP_AINTEN_CFGPMEINT_SHIFT))

#define  DM_APP_AINTEN_CFGPMEMSI_MASK 0x4000000
#define  DM_APP_AINTEN_CFGPMEMSI_SHIFT 26
#define  DM_APP_AINTEN_CFGPMEMSI_MASK_SHIFT(reg) (((reg) & DM_APP_AINTEN_CFGPMEMSI_MASK) >> DM_APP_AINTEN_CFGPMEMSI_SHIFT)
#define  DM_APP_AINTEN_CFGPMEMSI_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_AINTEN_CFGPMEMSI_MASK) | (((uint32_t)val) << DM_APP_AINTEN_CFGPMEMSI_SHIFT))

#define  DM_APP_AINTEN_RESERVED1_MASK 0x2000000
#define  DM_APP_AINTEN_RESERVED1_SHIFT 25
#define  DM_APP_AINTEN_RESERVED1_MASK_SHIFT(reg) (((reg) & DM_APP_AINTEN_RESERVED1_MASK) >> DM_APP_AINTEN_RESERVED1_SHIFT)
#define  DM_APP_AINTEN_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_AINTEN_RESERVED1_MASK) | (((uint32_t)val) << DM_APP_AINTEN_RESERVED1_SHIFT))

#define  DM_APP_AINTEN_LINKREQRST_MASK 0x1000000
#define  DM_APP_AINTEN_LINKREQRST_SHIFT 24
#define  DM_APP_AINTEN_LINKREQRST_MASK_SHIFT(reg) (((reg) & DM_APP_AINTEN_LINKREQRST_MASK) >> DM_APP_AINTEN_LINKREQRST_SHIFT)
#define  DM_APP_AINTEN_LINKREQRST_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_AINTEN_LINKREQRST_MASK) | (((uint32_t)val) << DM_APP_AINTEN_LINKREQRST_SHIFT))

#define  DM_APP_AINTEN_CFGAERERRINT_MASK 0x800000
#define  DM_APP_AINTEN_CFGAERERRINT_SHIFT 23
#define  DM_APP_AINTEN_CFGAERERRINT_MASK_SHIFT(reg) (((reg) & DM_APP_AINTEN_CFGAERERRINT_MASK) >> DM_APP_AINTEN_CFGAERERRINT_SHIFT)
#define  DM_APP_AINTEN_CFGAERERRINT_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_AINTEN_CFGAERERRINT_MASK) | (((uint32_t)val) << DM_APP_AINTEN_CFGAERERRINT_SHIFT))

#define  DM_APP_AINTEN_CFGAERERRMSI_MASK 0x400000
#define  DM_APP_AINTEN_CFGAERERRMSI_SHIFT 22
#define  DM_APP_AINTEN_CFGAERERRMSI_MASK_SHIFT(reg) (((reg) & DM_APP_AINTEN_CFGAERERRMSI_MASK) >> DM_APP_AINTEN_CFGAERERRMSI_SHIFT)
#define  DM_APP_AINTEN_CFGAERERRMSI_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_AINTEN_CFGAERERRMSI_MASK) | (((uint32_t)val) << DM_APP_AINTEN_CFGAERERRMSI_SHIFT))

#define  DM_APP_AINTEN_RESERVED2_MASK 0x3f0000
#define  DM_APP_AINTEN_RESERVED2_SHIFT 16
#define  DM_APP_AINTEN_RESERVED2_MASK_SHIFT(reg) (((reg) & DM_APP_AINTEN_RESERVED2_MASK) >> DM_APP_AINTEN_RESERVED2_SHIFT)
#define  DM_APP_AINTEN_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_AINTEN_RESERVED2_MASK) | (((uint32_t)val) << DM_APP_AINTEN_RESERVED2_SHIFT))

#define  DM_APP_AINTEN_RADMFATAL_MASK 0x8000
#define  DM_APP_AINTEN_RADMFATAL_SHIFT 15
#define  DM_APP_AINTEN_RADMFATAL_MASK_SHIFT(reg) (((reg) & DM_APP_AINTEN_RADMFATAL_MASK) >> DM_APP_AINTEN_RADMFATAL_SHIFT)
#define  DM_APP_AINTEN_RADMFATAL_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_AINTEN_RADMFATAL_MASK) | (((uint32_t)val) << DM_APP_AINTEN_RADMFATAL_SHIFT))

#define  DM_APP_AINTEN_RADMNONFATAL_MASK 0x4000
#define  DM_APP_AINTEN_RADMNONFATAL_SHIFT 14
#define  DM_APP_AINTEN_RADMNONFATAL_MASK_SHIFT(reg) (((reg) & DM_APP_AINTEN_RADMNONFATAL_MASK) >> DM_APP_AINTEN_RADMNONFATAL_SHIFT)
#define  DM_APP_AINTEN_RADMNONFATAL_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_AINTEN_RADMNONFATAL_MASK) | (((uint32_t)val) << DM_APP_AINTEN_RADMNONFATAL_SHIFT))

#define  DM_APP_AINTEN_RADMCORRERR_MASK 0x2000
#define  DM_APP_AINTEN_RADMCORRERR_SHIFT 13
#define  DM_APP_AINTEN_RADMCORRERR_MASK_SHIFT(reg) (((reg) & DM_APP_AINTEN_RADMCORRERR_MASK) >> DM_APP_AINTEN_RADMCORRERR_SHIFT)
#define  DM_APP_AINTEN_RADMCORRERR_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_AINTEN_RADMCORRERR_MASK) | (((uint32_t)val) << DM_APP_AINTEN_RADMCORRERR_SHIFT))

#define  DM_APP_AINTEN_RADMPME_MASK 0x1000
#define  DM_APP_AINTEN_RADMPME_SHIFT 12
#define  DM_APP_AINTEN_RADMPME_MASK_SHIFT(reg) (((reg) & DM_APP_AINTEN_RADMPME_MASK) >> DM_APP_AINTEN_RADMPME_SHIFT)
#define  DM_APP_AINTEN_RADMPME_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_AINTEN_RADMPME_MASK) | (((uint32_t)val) << DM_APP_AINTEN_RADMPME_SHIFT))

#define  DM_APP_AINTEN_RADMCPLTIMEOUT_MASK 0x800
#define  DM_APP_AINTEN_RADMCPLTIMEOUT_SHIFT 11
#define  DM_APP_AINTEN_RADMCPLTIMEOUT_MASK_SHIFT(reg) (((reg) & DM_APP_AINTEN_RADMCPLTIMEOUT_MASK) >> DM_APP_AINTEN_RADMCPLTIMEOUT_SHIFT)
#define  DM_APP_AINTEN_RADMCPLTIMEOUT_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_AINTEN_RADMCPLTIMEOUT_MASK) | (((uint32_t)val) << DM_APP_AINTEN_RADMCPLTIMEOUT_SHIFT))

#define  DM_APP_AINTEN_RESERVED3_MASK 0x400
#define  DM_APP_AINTEN_RESERVED3_SHIFT 10
#define  DM_APP_AINTEN_RESERVED3_MASK_SHIFT(reg) (((reg) & DM_APP_AINTEN_RESERVED3_MASK) >> DM_APP_AINTEN_RESERVED3_SHIFT)
#define  DM_APP_AINTEN_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_AINTEN_RESERVED3_MASK) | (((uint32_t)val) << DM_APP_AINTEN_RESERVED3_SHIFT))

#define  DM_APP_AINTEN_RADMCPLUR_MASK 0x200
#define  DM_APP_AINTEN_RADMCPLUR_SHIFT 9
#define  DM_APP_AINTEN_RADMCPLUR_MASK_SHIFT(reg) (((reg) & DM_APP_AINTEN_RADMCPLUR_MASK) >> DM_APP_AINTEN_RADMCPLUR_SHIFT)
#define  DM_APP_AINTEN_RADMCPLUR_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_AINTEN_RADMCPLUR_MASK) | (((uint32_t)val) << DM_APP_AINTEN_RADMCPLUR_SHIFT))

#define  DM_APP_AINTEN_RADMCA_MASK 0x100
#define  DM_APP_AINTEN_RADMCA_SHIFT 8
#define  DM_APP_AINTEN_RADMCA_MASK_SHIFT(reg) (((reg) & DM_APP_AINTEN_RADMCA_MASK) >> DM_APP_AINTEN_RADMCA_SHIFT)
#define  DM_APP_AINTEN_RADMCA_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_AINTEN_RADMCA_MASK) | (((uint32_t)val) << DM_APP_AINTEN_RADMCA_SHIFT))

#define  DM_APP_AINTEN_RESERVED4_MASK 0xe0
#define  DM_APP_AINTEN_RESERVED4_SHIFT 5
#define  DM_APP_AINTEN_RESERVED4_MASK_SHIFT(reg) (((reg) & DM_APP_AINTEN_RESERVED4_MASK) >> DM_APP_AINTEN_RESERVED4_SHIFT)
#define  DM_APP_AINTEN_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_AINTEN_RESERVED4_MASK) | (((uint32_t)val) << DM_APP_AINTEN_RESERVED4_SHIFT))

#define  DM_APP_AINTEN_TRGTCPLTIMEOUT_MASK 0x10
#define  DM_APP_AINTEN_TRGTCPLTIMEOUT_SHIFT 4
#define  DM_APP_AINTEN_TRGTCPLTIMEOUT_MASK_SHIFT(reg) (((reg) & DM_APP_AINTEN_TRGTCPLTIMEOUT_MASK) >> DM_APP_AINTEN_TRGTCPLTIMEOUT_SHIFT)
#define  DM_APP_AINTEN_TRGTCPLTIMEOUT_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_AINTEN_TRGTCPLTIMEOUT_MASK) | (((uint32_t)val) << DM_APP_AINTEN_TRGTCPLTIMEOUT_SHIFT))

#define  DM_APP_AINTEN_TRGTLOOKUPEMPTY_MASK 0x8
#define  DM_APP_AINTEN_TRGTLOOKUPEMPTY_SHIFT 3
#define  DM_APP_AINTEN_TRGTLOOKUPEMPTY_MASK_SHIFT(reg) (((reg) & DM_APP_AINTEN_TRGTLOOKUPEMPTY_MASK) >> DM_APP_AINTEN_TRGTLOOKUPEMPTY_SHIFT)
#define  DM_APP_AINTEN_TRGTLOOKUPEMPTY_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_AINTEN_TRGTLOOKUPEMPTY_MASK) | (((uint32_t)val) << DM_APP_AINTEN_TRGTLOOKUPEMPTY_SHIFT))

#define  DM_APP_AINTEN_RESERVED5_MASK 0x6
#define  DM_APP_AINTEN_RESERVED5_SHIFT 1
#define  DM_APP_AINTEN_RESERVED5_MASK_SHIFT(reg) (((reg) & DM_APP_AINTEN_RESERVED5_MASK) >> DM_APP_AINTEN_RESERVED5_SHIFT)
#define  DM_APP_AINTEN_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_AINTEN_RESERVED5_MASK) | (((uint32_t)val) << DM_APP_AINTEN_RESERVED5_SHIFT))

#define  DM_APP_AINTEN_TRNGRESET_MASK 0x1
#define  DM_APP_AINTEN_TRNGRESET_SHIFT 0
#define  DM_APP_AINTEN_TRNGRESET_MASK_SHIFT(reg) (((reg) & DM_APP_AINTEN_TRNGRESET_MASK) >> DM_APP_AINTEN_TRNGRESET_SHIFT)
#define  DM_APP_AINTEN_TRNGRESET_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_AINTEN_TRNGRESET_MASK) | (((uint32_t)val) << DM_APP_AINTEN_TRNGRESET_SHIFT))

//====================================================================
//Register: Application Interrupt Acknowledge Register (AIntAck)
/** \brief Interrupt Acknowledge bits corresonding to each Interrupt Pending Register bit.
Writing a "1" to a bit will clear the corresponding Interrupt Pending bit,
excepting the AER Interrupt Message Number status bits.
Note that bit 16 is a diagnostic bit that when written, will set all the interrupt pending bits from the PCIe Core.*/
//====================================================================

#define  DM_APP_AINTACK_GMCOMPLOOKUPERR_MASK 0x80000000
#define  DM_APP_AINTACK_GMCOMPLOOKUPERR_SHIFT 31
#define  DM_APP_AINTACK_GMCOMPLOOKUPERR_MASK_SHIFT(reg) (((reg) & DM_APP_AINTACK_GMCOMPLOOKUPERR_MASK) >> DM_APP_AINTACK_GMCOMPLOOKUPERR_SHIFT)
#define  DM_APP_AINTACK_GMCOMPLOOKUPERR_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_AINTACK_GMCOMPLOOKUPERR_MASK) | (((uint32_t)val) << DM_APP_AINTACK_GMCOMPLOOKUPERR_SHIFT))

#define  DM_APP_AINTACK_RADMXCOMPLOOKUPERR_MASK 0x40000000
#define  DM_APP_AINTACK_RADMXCOMPLOOKUPERR_SHIFT 30
#define  DM_APP_AINTACK_RADMXCOMPLOOKUPERR_MASK_SHIFT(reg) (((reg) & DM_APP_AINTACK_RADMXCOMPLOOKUPERR_MASK) >> DM_APP_AINTACK_RADMXCOMPLOOKUPERR_SHIFT)
#define  DM_APP_AINTACK_RADMXCOMPLOOKUPERR_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_AINTACK_RADMXCOMPLOOKUPERR_MASK) | (((uint32_t)val) << DM_APP_AINTACK_RADMXCOMPLOOKUPERR_SHIFT))

#define  DM_APP_AINTACK_CFGSYSERRRC_MASK 0x20000000
#define  DM_APP_AINTACK_CFGSYSERRRC_SHIFT 29
#define  DM_APP_AINTACK_CFGSYSERRRC_MASK_SHIFT(reg) (((reg) & DM_APP_AINTACK_CFGSYSERRRC_MASK) >> DM_APP_AINTACK_CFGSYSERRRC_SHIFT)
#define  DM_APP_AINTACK_CFGSYSERRRC_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_AINTACK_CFGSYSERRRC_MASK) | (((uint32_t)val) << DM_APP_AINTACK_CFGSYSERRRC_SHIFT))

#define  DM_APP_AINTACK_INVINTLPTYPE_MASK 0x10000000
#define  DM_APP_AINTACK_INVINTLPTYPE_SHIFT 28
#define  DM_APP_AINTACK_INVINTLPTYPE_MASK_SHIFT(reg) (((reg) & DM_APP_AINTACK_INVINTLPTYPE_MASK) >> DM_APP_AINTACK_INVINTLPTYPE_SHIFT)
#define  DM_APP_AINTACK_INVINTLPTYPE_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_AINTACK_INVINTLPTYPE_MASK) | (((uint32_t)val) << DM_APP_AINTACK_INVINTLPTYPE_SHIFT))

#define  DM_APP_AINTACK_CFGPMEINT_MASK 0x8000000
#define  DM_APP_AINTACK_CFGPMEINT_SHIFT 27
#define  DM_APP_AINTACK_CFGPMEINT_MASK_SHIFT(reg) (((reg) & DM_APP_AINTACK_CFGPMEINT_MASK) >> DM_APP_AINTACK_CFGPMEINT_SHIFT)
#define  DM_APP_AINTACK_CFGPMEINT_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_AINTACK_CFGPMEINT_MASK) | (((uint32_t)val) << DM_APP_AINTACK_CFGPMEINT_SHIFT))

#define  DM_APP_AINTACK_CFGPMEMSI_MASK 0x4000000
#define  DM_APP_AINTACK_CFGPMEMSI_SHIFT 26
#define  DM_APP_AINTACK_CFGPMEMSI_MASK_SHIFT(reg) (((reg) & DM_APP_AINTACK_CFGPMEMSI_MASK) >> DM_APP_AINTACK_CFGPMEMSI_SHIFT)
#define  DM_APP_AINTACK_CFGPMEMSI_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_AINTACK_CFGPMEMSI_MASK) | (((uint32_t)val) << DM_APP_AINTACK_CFGPMEMSI_SHIFT))

#define  DM_APP_AINTACK_RESERVED1_MASK 0x2000000
#define  DM_APP_AINTACK_RESERVED1_SHIFT 25
#define  DM_APP_AINTACK_RESERVED1_MASK_SHIFT(reg) (((reg) & DM_APP_AINTACK_RESERVED1_MASK) >> DM_APP_AINTACK_RESERVED1_SHIFT)
#define  DM_APP_AINTACK_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_AINTACK_RESERVED1_MASK) | (((uint32_t)val) << DM_APP_AINTACK_RESERVED1_SHIFT))

#define  DM_APP_AINTACK_LINKREQRST_MASK 0x1000000
#define  DM_APP_AINTACK_LINKREQRST_SHIFT 24
#define  DM_APP_AINTACK_LINKREQRST_MASK_SHIFT(reg) (((reg) & DM_APP_AINTACK_LINKREQRST_MASK) >> DM_APP_AINTACK_LINKREQRST_SHIFT)
#define  DM_APP_AINTACK_LINKREQRST_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_AINTACK_LINKREQRST_MASK) | (((uint32_t)val) << DM_APP_AINTACK_LINKREQRST_SHIFT))

#define  DM_APP_AINTACK_CFGAERERRINT_MASK 0x800000
#define  DM_APP_AINTACK_CFGAERERRINT_SHIFT 23
#define  DM_APP_AINTACK_CFGAERERRINT_MASK_SHIFT(reg) (((reg) & DM_APP_AINTACK_CFGAERERRINT_MASK) >> DM_APP_AINTACK_CFGAERERRINT_SHIFT)
#define  DM_APP_AINTACK_CFGAERERRINT_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_AINTACK_CFGAERERRINT_MASK) | (((uint32_t)val) << DM_APP_AINTACK_CFGAERERRINT_SHIFT))

#define  DM_APP_AINTACK_CFGAERERRMSI_MASK 0x400000
#define  DM_APP_AINTACK_CFGAERERRMSI_SHIFT 22
#define  DM_APP_AINTACK_CFGAERERRMSI_MASK_SHIFT(reg) (((reg) & DM_APP_AINTACK_CFGAERERRMSI_MASK) >> DM_APP_AINTACK_CFGAERERRMSI_SHIFT)
#define  DM_APP_AINTACK_CFGAERERRMSI_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_AINTACK_CFGAERERRMSI_MASK) | (((uint32_t)val) << DM_APP_AINTACK_CFGAERERRMSI_SHIFT))

#define  DM_APP_AINTACK_RESERVED2_MASK 0x3e0000
#define  DM_APP_AINTACK_RESERVED2_SHIFT 17
#define  DM_APP_AINTACK_RESERVED2_MASK_SHIFT(reg) (((reg) & DM_APP_AINTACK_RESERVED2_MASK) >> DM_APP_AINTACK_RESERVED2_SHIFT)
#define  DM_APP_AINTACK_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_AINTACK_RESERVED2_MASK) | (((uint32_t)val) << DM_APP_AINTACK_RESERVED2_SHIFT))

#define  DM_APP_AINTACK_INTP_DIAG_MASK 0x10000
#define  DM_APP_AINTACK_INTP_DIAG_SHIFT 16
#define  DM_APP_AINTACK_INTP_DIAG_MASK_SHIFT(reg) (((reg) & DM_APP_AINTACK_INTP_DIAG_MASK) >> DM_APP_AINTACK_INTP_DIAG_SHIFT)
#define  DM_APP_AINTACK_INTP_DIAG_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_AINTACK_INTP_DIAG_MASK) | (((uint32_t)val) << DM_APP_AINTACK_INTP_DIAG_SHIFT))

#define  DM_APP_AINTACK_RADMFATAL_MASK 0x8000
#define  DM_APP_AINTACK_RADMFATAL_SHIFT 15
#define  DM_APP_AINTACK_RADMFATAL_MASK_SHIFT(reg) (((reg) & DM_APP_AINTACK_RADMFATAL_MASK) >> DM_APP_AINTACK_RADMFATAL_SHIFT)
#define  DM_APP_AINTACK_RADMFATAL_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_AINTACK_RADMFATAL_MASK) | (((uint32_t)val) << DM_APP_AINTACK_RADMFATAL_SHIFT))

#define  DM_APP_AINTACK_RADMNONFATAL_MASK 0x4000
#define  DM_APP_AINTACK_RADMNONFATAL_SHIFT 14
#define  DM_APP_AINTACK_RADMNONFATAL_MASK_SHIFT(reg) (((reg) & DM_APP_AINTACK_RADMNONFATAL_MASK) >> DM_APP_AINTACK_RADMNONFATAL_SHIFT)
#define  DM_APP_AINTACK_RADMNONFATAL_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_AINTACK_RADMNONFATAL_MASK) | (((uint32_t)val) << DM_APP_AINTACK_RADMNONFATAL_SHIFT))

#define  DM_APP_AINTACK_RADMCORRERR_MASK 0x2000
#define  DM_APP_AINTACK_RADMCORRERR_SHIFT 13
#define  DM_APP_AINTACK_RADMCORRERR_MASK_SHIFT(reg) (((reg) & DM_APP_AINTACK_RADMCORRERR_MASK) >> DM_APP_AINTACK_RADMCORRERR_SHIFT)
#define  DM_APP_AINTACK_RADMCORRERR_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_AINTACK_RADMCORRERR_MASK) | (((uint32_t)val) << DM_APP_AINTACK_RADMCORRERR_SHIFT))

#define  DM_APP_AINTACK_RADMPME_MASK 0x1000
#define  DM_APP_AINTACK_RADMPME_SHIFT 12
#define  DM_APP_AINTACK_RADMPME_MASK_SHIFT(reg) (((reg) & DM_APP_AINTACK_RADMPME_MASK) >> DM_APP_AINTACK_RADMPME_SHIFT)
#define  DM_APP_AINTACK_RADMPME_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_AINTACK_RADMPME_MASK) | (((uint32_t)val) << DM_APP_AINTACK_RADMPME_SHIFT))

#define  DM_APP_AINTACK_RADMCPLTIMEOUT_MASK 0x800
#define  DM_APP_AINTACK_RADMCPLTIMEOUT_SHIFT 11
#define  DM_APP_AINTACK_RADMCPLTIMEOUT_MASK_SHIFT(reg) (((reg) & DM_APP_AINTACK_RADMCPLTIMEOUT_MASK) >> DM_APP_AINTACK_RADMCPLTIMEOUT_SHIFT)
#define  DM_APP_AINTACK_RADMCPLTIMEOUT_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_AINTACK_RADMCPLTIMEOUT_MASK) | (((uint32_t)val) << DM_APP_AINTACK_RADMCPLTIMEOUT_SHIFT))

#define  DM_APP_AINTACK_RESERVED3_MASK 0x400
#define  DM_APP_AINTACK_RESERVED3_SHIFT 10
#define  DM_APP_AINTACK_RESERVED3_MASK_SHIFT(reg) (((reg) & DM_APP_AINTACK_RESERVED3_MASK) >> DM_APP_AINTACK_RESERVED3_SHIFT)
#define  DM_APP_AINTACK_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_AINTACK_RESERVED3_MASK) | (((uint32_t)val) << DM_APP_AINTACK_RESERVED3_SHIFT))

#define  DM_APP_AINTACK_RADMCPLUR_MASK 0x200
#define  DM_APP_AINTACK_RADMCPLUR_SHIFT 9
#define  DM_APP_AINTACK_RADMCPLUR_MASK_SHIFT(reg) (((reg) & DM_APP_AINTACK_RADMCPLUR_MASK) >> DM_APP_AINTACK_RADMCPLUR_SHIFT)
#define  DM_APP_AINTACK_RADMCPLUR_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_AINTACK_RADMCPLUR_MASK) | (((uint32_t)val) << DM_APP_AINTACK_RADMCPLUR_SHIFT))

#define  DM_APP_AINTACK_RADMCA_MASK 0x100
#define  DM_APP_AINTACK_RADMCA_SHIFT 8
#define  DM_APP_AINTACK_RADMCA_MASK_SHIFT(reg) (((reg) & DM_APP_AINTACK_RADMCA_MASK) >> DM_APP_AINTACK_RADMCA_SHIFT)
#define  DM_APP_AINTACK_RADMCA_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_AINTACK_RADMCA_MASK) | (((uint32_t)val) << DM_APP_AINTACK_RADMCA_SHIFT))

#define  DM_APP_AINTACK_RESERVED4_MASK 0xe0
#define  DM_APP_AINTACK_RESERVED4_SHIFT 5
#define  DM_APP_AINTACK_RESERVED4_MASK_SHIFT(reg) (((reg) & DM_APP_AINTACK_RESERVED4_MASK) >> DM_APP_AINTACK_RESERVED4_SHIFT)
#define  DM_APP_AINTACK_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_AINTACK_RESERVED4_MASK) | (((uint32_t)val) << DM_APP_AINTACK_RESERVED4_SHIFT))

#define  DM_APP_AINTACK_TRGTCPLTIMEOUT_MASK 0x10
#define  DM_APP_AINTACK_TRGTCPLTIMEOUT_SHIFT 4
#define  DM_APP_AINTACK_TRGTCPLTIMEOUT_MASK_SHIFT(reg) (((reg) & DM_APP_AINTACK_TRGTCPLTIMEOUT_MASK) >> DM_APP_AINTACK_TRGTCPLTIMEOUT_SHIFT)
#define  DM_APP_AINTACK_TRGTCPLTIMEOUT_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_AINTACK_TRGTCPLTIMEOUT_MASK) | (((uint32_t)val) << DM_APP_AINTACK_TRGTCPLTIMEOUT_SHIFT))

#define  DM_APP_AINTACK_TRGTLOOKUPEMPTY_MASK 0x8
#define  DM_APP_AINTACK_TRGTLOOKUPEMPTY_SHIFT 3
#define  DM_APP_AINTACK_TRGTLOOKUPEMPTY_MASK_SHIFT(reg) (((reg) & DM_APP_AINTACK_TRGTLOOKUPEMPTY_MASK) >> DM_APP_AINTACK_TRGTLOOKUPEMPTY_SHIFT)
#define  DM_APP_AINTACK_TRGTLOOKUPEMPTY_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_AINTACK_TRGTLOOKUPEMPTY_MASK) | (((uint32_t)val) << DM_APP_AINTACK_TRGTLOOKUPEMPTY_SHIFT))

#define  DM_APP_AINTACK_RESERVED5_MASK 0x6
#define  DM_APP_AINTACK_RESERVED5_SHIFT 1
#define  DM_APP_AINTACK_RESERVED5_MASK_SHIFT(reg) (((reg) & DM_APP_AINTACK_RESERVED5_MASK) >> DM_APP_AINTACK_RESERVED5_SHIFT)
#define  DM_APP_AINTACK_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_AINTACK_RESERVED5_MASK) | (((uint32_t)val) << DM_APP_AINTACK_RESERVED5_SHIFT))

#define  DM_APP_AINTACK_TRNGRESET_MASK 0x1
#define  DM_APP_AINTACK_TRNGRESET_SHIFT 0
#define  DM_APP_AINTACK_TRNGRESET_MASK_SHIFT(reg) (((reg) & DM_APP_AINTACK_TRNGRESET_MASK) >> DM_APP_AINTACK_TRNGRESET_SHIFT)
#define  DM_APP_AINTACK_TRNGRESET_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_AINTACK_TRNGRESET_MASK) | (((uint32_t)val) << DM_APP_AINTACK_TRNGRESET_SHIFT))

//====================================================================
//Register: Application Inbound Address Translation Register 0 (InAddrXlt0)
/** \brief Core Application Inbound Address Translation Register.*/
//====================================================================

#define  DM_APP_INADDRXLT0_MEM_MASK 0xffffffff
#define  DM_APP_INADDRXLT0_MEM_SHIFT 0
#define  DM_APP_INADDRXLT0_MEM_MASK_SHIFT(reg) (((reg) & DM_APP_INADDRXLT0_MEM_MASK) >> DM_APP_INADDRXLT0_MEM_SHIFT)
#define  DM_APP_INADDRXLT0_MEM_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_INADDRXLT0_MEM_MASK) | (((uint32_t)val) << DM_APP_INADDRXLT0_MEM_SHIFT))

//====================================================================
//Register: Application Inbound Address Translation Register 1 (InAddrXlt1)
/** \brief Core Application Inbound Address Translation Register.*/
//====================================================================

#define  DM_APP_INADDRXLT1_MEM_MASK 0xffffffff
#define  DM_APP_INADDRXLT1_MEM_SHIFT 0
#define  DM_APP_INADDRXLT1_MEM_MASK_SHIFT(reg) (((reg) & DM_APP_INADDRXLT1_MEM_MASK) >> DM_APP_INADDRXLT1_MEM_SHIFT)
#define  DM_APP_INADDRXLT1_MEM_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_INADDRXLT1_MEM_MASK) | (((uint32_t)val) << DM_APP_INADDRXLT1_MEM_SHIFT))

//====================================================================
//Register: Application Inbound Address Translation Register 2 (InAddrXlt2)
/** \brief Core Application Inbound Address Translation Register.*/
//====================================================================

#define  DM_APP_INADDRXLT2_MEM_MASK 0xffffffff
#define  DM_APP_INADDRXLT2_MEM_SHIFT 0
#define  DM_APP_INADDRXLT2_MEM_MASK_SHIFT(reg) (((reg) & DM_APP_INADDRXLT2_MEM_MASK) >> DM_APP_INADDRXLT2_MEM_SHIFT)
#define  DM_APP_INADDRXLT2_MEM_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_INADDRXLT2_MEM_MASK) | (((uint32_t)val) << DM_APP_INADDRXLT2_MEM_SHIFT))

//====================================================================
//Register: Application BAR0 (BAR0)
/** \brief Used for Inbound Address Translation logic. Set to the same value as the PCIe Core BAR0 register.*/
//====================================================================

#define  DM_APP_BAR0_BASE_MASK 0xf8000000
#define  DM_APP_BAR0_BASE_SHIFT 27
#define  DM_APP_BAR0_BASE_MASK_SHIFT(reg) (((reg) & DM_APP_BAR0_BASE_MASK) >> DM_APP_BAR0_BASE_SHIFT)
#define  DM_APP_BAR0_BASE_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_BAR0_BASE_MASK) | (((uint32_t)val) << DM_APP_BAR0_BASE_SHIFT))

#define  DM_APP_BAR0_RESERVED1_MASK 0x7ffffff
#define  DM_APP_BAR0_RESERVED1_SHIFT 0
#define  DM_APP_BAR0_RESERVED1_MASK_SHIFT(reg) (((reg) & DM_APP_BAR0_RESERVED1_MASK) >> DM_APP_BAR0_RESERVED1_SHIFT)
#define  DM_APP_BAR0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_BAR0_RESERVED1_MASK) | (((uint32_t)val) << DM_APP_BAR0_RESERVED1_SHIFT))

//====================================================================
//Register: Application Window Miss Register (WinMiss)
//====================================================================

#define  DM_APP_WINMISS_MEM_MASK 0xffffffff
#define  DM_APP_WINMISS_MEM_SHIFT 0
#define  DM_APP_WINMISS_MEM_MASK_SHIFT(reg) (((reg) & DM_APP_WINMISS_MEM_MASK) >> DM_APP_WINMISS_MEM_SHIFT)
#define  DM_APP_WINMISS_MEM_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_WINMISS_MEM_MASK) | (((uint32_t)val) << DM_APP_WINMISS_MEM_SHIFT))

//====================================================================
//Register: Application RC MSI Interrupt0 Mask  (RC_MSI_IRQ0_Mask)
//====================================================================

#define  DM_APP_RC_MSI_IRQ0_MASK_MASK_MASK 0xffffffff
#define  DM_APP_RC_MSI_IRQ0_MASK_MASK_SHIFT 0
#define  DM_APP_RC_MSI_IRQ0_MASK_MASK_MASK_SHIFT(reg) (((reg) & DM_APP_RC_MSI_IRQ0_MASK_MASK_MASK) >> DM_APP_RC_MSI_IRQ0_MASK_MASK_SHIFT)
#define  DM_APP_RC_MSI_IRQ0_MASK_MASK_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_RC_MSI_IRQ0_MASK_MASK_MASK) | (((uint32_t)val) << DM_APP_RC_MSI_IRQ0_MASK_MASK_SHIFT))

//====================================================================
//Register: Application RC MSI Interrupt0 (RC_MSI_IRQ0)
//====================================================================

#define  DM_APP_RC_MSI_IRQ0_INT_MASK 0xffffffff
#define  DM_APP_RC_MSI_IRQ0_INT_SHIFT 0
#define  DM_APP_RC_MSI_IRQ0_INT_MASK_SHIFT(reg) (((reg) & DM_APP_RC_MSI_IRQ0_INT_MASK) >> DM_APP_RC_MSI_IRQ0_INT_SHIFT)
#define  DM_APP_RC_MSI_IRQ0_INT_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_RC_MSI_IRQ0_INT_MASK) | (((uint32_t)val) << DM_APP_RC_MSI_IRQ0_INT_SHIFT))

//====================================================================
//Register: Application RC MSI Interrupt0 Clear (RC_MSI_IRQ0_Clr)
//====================================================================

#define  DM_APP_RC_MSI_IRQ0_CLR_INT_MASK 0xffffffff
#define  DM_APP_RC_MSI_IRQ0_CLR_INT_SHIFT 0
#define  DM_APP_RC_MSI_IRQ0_CLR_INT_MASK_SHIFT(reg) (((reg) & DM_APP_RC_MSI_IRQ0_CLR_INT_MASK) >> DM_APP_RC_MSI_IRQ0_CLR_INT_SHIFT)
#define  DM_APP_RC_MSI_IRQ0_CLR_INT_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_RC_MSI_IRQ0_CLR_INT_MASK) | (((uint32_t)val) << DM_APP_RC_MSI_IRQ0_CLR_INT_SHIFT))

//====================================================================
//Register: Application RC MSI Interrupt1 Mask  (RC_MSI_IRQ1_Mask)
//====================================================================

#define  DM_APP_RC_MSI_IRQ1_MASK_MASK_MASK 0xffffffff
#define  DM_APP_RC_MSI_IRQ1_MASK_MASK_SHIFT 0
#define  DM_APP_RC_MSI_IRQ1_MASK_MASK_MASK_SHIFT(reg) (((reg) & DM_APP_RC_MSI_IRQ1_MASK_MASK_MASK) >> DM_APP_RC_MSI_IRQ1_MASK_MASK_SHIFT)
#define  DM_APP_RC_MSI_IRQ1_MASK_MASK_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_RC_MSI_IRQ1_MASK_MASK_MASK) | (((uint32_t)val) << DM_APP_RC_MSI_IRQ1_MASK_MASK_SHIFT))

//====================================================================
//Register: Application RC MSI Interrupt1 (RC_MSI_IRQ1)
//====================================================================

#define  DM_APP_RC_MSI_IRQ1_INT_MASK 0xffffffff
#define  DM_APP_RC_MSI_IRQ1_INT_SHIFT 0
#define  DM_APP_RC_MSI_IRQ1_INT_MASK_SHIFT(reg) (((reg) & DM_APP_RC_MSI_IRQ1_INT_MASK) >> DM_APP_RC_MSI_IRQ1_INT_SHIFT)
#define  DM_APP_RC_MSI_IRQ1_INT_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_RC_MSI_IRQ1_INT_MASK) | (((uint32_t)val) << DM_APP_RC_MSI_IRQ1_INT_SHIFT))

//====================================================================
//Register: Application RC MSI Interrupt1 Clear (RC_MSI_IRQ1_Clr)
//====================================================================

#define  DM_APP_RC_MSI_IRQ1_CLR_INT_MASK 0xffffffff
#define  DM_APP_RC_MSI_IRQ1_CLR_INT_SHIFT 0
#define  DM_APP_RC_MSI_IRQ1_CLR_INT_MASK_SHIFT(reg) (((reg) & DM_APP_RC_MSI_IRQ1_CLR_INT_MASK) >> DM_APP_RC_MSI_IRQ1_CLR_INT_SHIFT)
#define  DM_APP_RC_MSI_IRQ1_CLR_INT_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_RC_MSI_IRQ1_CLR_INT_MASK) | (((uint32_t)val) << DM_APP_RC_MSI_IRQ1_CLR_INT_SHIFT))

//====================================================================
//Register: Application RC MSI Interrupt2 Mask  (RC_MSI_IRQ2_Mask)
//====================================================================

#define  DM_APP_RC_MSI_IRQ2_MASK_MASK_MASK 0xffffffff
#define  DM_APP_RC_MSI_IRQ2_MASK_MASK_SHIFT 0
#define  DM_APP_RC_MSI_IRQ2_MASK_MASK_MASK_SHIFT(reg) (((reg) & DM_APP_RC_MSI_IRQ2_MASK_MASK_MASK) >> DM_APP_RC_MSI_IRQ2_MASK_MASK_SHIFT)
#define  DM_APP_RC_MSI_IRQ2_MASK_MASK_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_RC_MSI_IRQ2_MASK_MASK_MASK) | (((uint32_t)val) << DM_APP_RC_MSI_IRQ2_MASK_MASK_SHIFT))

//====================================================================
//Register: Application RC MSI Interrupt2 (RC_MSI_IRQ2)
//====================================================================

#define  DM_APP_RC_MSI_IRQ2_INT_MASK 0xffffffff
#define  DM_APP_RC_MSI_IRQ2_INT_SHIFT 0
#define  DM_APP_RC_MSI_IRQ2_INT_MASK_SHIFT(reg) (((reg) & DM_APP_RC_MSI_IRQ2_INT_MASK) >> DM_APP_RC_MSI_IRQ2_INT_SHIFT)
#define  DM_APP_RC_MSI_IRQ2_INT_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_RC_MSI_IRQ2_INT_MASK) | (((uint32_t)val) << DM_APP_RC_MSI_IRQ2_INT_SHIFT))

//====================================================================
//Register: Application RC MSI Interrupt2 Clear (RC_MSI_IRQ2_Clr)
//====================================================================

#define  DM_APP_RC_MSI_IRQ2_CLR_INT_MASK 0xffffffff
#define  DM_APP_RC_MSI_IRQ2_CLR_INT_SHIFT 0
#define  DM_APP_RC_MSI_IRQ2_CLR_INT_MASK_SHIFT(reg) (((reg) & DM_APP_RC_MSI_IRQ2_CLR_INT_MASK) >> DM_APP_RC_MSI_IRQ2_CLR_INT_SHIFT)
#define  DM_APP_RC_MSI_IRQ2_CLR_INT_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_RC_MSI_IRQ2_CLR_INT_MASK) | (((uint32_t)val) << DM_APP_RC_MSI_IRQ2_CLR_INT_SHIFT))

//====================================================================
//Register: Application RC MSI Interrupt3 Mask  (RC_MSI_IRQ3_Mask)
//====================================================================

#define  DM_APP_RC_MSI_IRQ3_MASK_MASK_MASK 0xffffffff
#define  DM_APP_RC_MSI_IRQ3_MASK_MASK_SHIFT 0
#define  DM_APP_RC_MSI_IRQ3_MASK_MASK_MASK_SHIFT(reg) (((reg) & DM_APP_RC_MSI_IRQ3_MASK_MASK_MASK) >> DM_APP_RC_MSI_IRQ3_MASK_MASK_SHIFT)
#define  DM_APP_RC_MSI_IRQ3_MASK_MASK_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_RC_MSI_IRQ3_MASK_MASK_MASK) | (((uint32_t)val) << DM_APP_RC_MSI_IRQ3_MASK_MASK_SHIFT))

//====================================================================
//Register: Application RC MSI Interrupt3 (RC_MSI_IRQ3)
//====================================================================

#define  DM_APP_RC_MSI_IRQ3_INT_MASK 0xffffffff
#define  DM_APP_RC_MSI_IRQ3_INT_SHIFT 0
#define  DM_APP_RC_MSI_IRQ3_INT_MASK_SHIFT(reg) (((reg) & DM_APP_RC_MSI_IRQ3_INT_MASK) >> DM_APP_RC_MSI_IRQ3_INT_SHIFT)
#define  DM_APP_RC_MSI_IRQ3_INT_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_RC_MSI_IRQ3_INT_MASK) | (((uint32_t)val) << DM_APP_RC_MSI_IRQ3_INT_SHIFT))

//====================================================================
//Register: Application RC MSI Interrupt3 Clear (RC_MSI_IRQ3_Clr)
//====================================================================

#define  DM_APP_RC_MSI_IRQ3_CLR_INT_MASK 0xffffffff
#define  DM_APP_RC_MSI_IRQ3_CLR_INT_SHIFT 0
#define  DM_APP_RC_MSI_IRQ3_CLR_INT_MASK_SHIFT(reg) (((reg) & DM_APP_RC_MSI_IRQ3_CLR_INT_MASK) >> DM_APP_RC_MSI_IRQ3_CLR_INT_SHIFT)
#define  DM_APP_RC_MSI_IRQ3_CLR_INT_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_RC_MSI_IRQ3_CLR_INT_MASK) | (((uint32_t)val) << DM_APP_RC_MSI_IRQ3_CLR_INT_SHIFT))

//====================================================================
//Register: Application INTA Interrupt Enable (RC_INTA_IRQ_En)
//====================================================================

#define  DM_APP_RC_INTA_IRQ_EN_RESERVED1_MASK 0xfffffffe
#define  DM_APP_RC_INTA_IRQ_EN_RESERVED1_SHIFT 1
#define  DM_APP_RC_INTA_IRQ_EN_RESERVED1_MASK_SHIFT(reg) (((reg) & DM_APP_RC_INTA_IRQ_EN_RESERVED1_MASK) >> DM_APP_RC_INTA_IRQ_EN_RESERVED1_SHIFT)
#define  DM_APP_RC_INTA_IRQ_EN_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_RC_INTA_IRQ_EN_RESERVED1_MASK) | (((uint32_t)val) << DM_APP_RC_INTA_IRQ_EN_RESERVED1_SHIFT))

#define  DM_APP_RC_INTA_IRQ_EN_EN_MASK 0x1
#define  DM_APP_RC_INTA_IRQ_EN_EN_SHIFT 0
#define  DM_APP_RC_INTA_IRQ_EN_EN_MASK_SHIFT(reg) (((reg) & DM_APP_RC_INTA_IRQ_EN_EN_MASK) >> DM_APP_RC_INTA_IRQ_EN_EN_SHIFT)
#define  DM_APP_RC_INTA_IRQ_EN_EN_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_RC_INTA_IRQ_EN_EN_MASK) | (((uint32_t)val) << DM_APP_RC_INTA_IRQ_EN_EN_SHIFT))

//====================================================================
//Register: Application INTA Count Value (RC_INTA_IRQ_Cnt)
//====================================================================

#define  DM_APP_RC_INTA_IRQ_CNT_RESERVED1_MASK 0xfffffff0
#define  DM_APP_RC_INTA_IRQ_CNT_RESERVED1_SHIFT 4
#define  DM_APP_RC_INTA_IRQ_CNT_RESERVED1_MASK_SHIFT(reg) (((reg) & DM_APP_RC_INTA_IRQ_CNT_RESERVED1_MASK) >> DM_APP_RC_INTA_IRQ_CNT_RESERVED1_SHIFT)
#define  DM_APP_RC_INTA_IRQ_CNT_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_RC_INTA_IRQ_CNT_RESERVED1_MASK) | (((uint32_t)val) << DM_APP_RC_INTA_IRQ_CNT_RESERVED1_SHIFT))

#define  DM_APP_RC_INTA_IRQ_CNT_CNT_MASK 0xf
#define  DM_APP_RC_INTA_IRQ_CNT_CNT_SHIFT 0
#define  DM_APP_RC_INTA_IRQ_CNT_CNT_MASK_SHIFT(reg) (((reg) & DM_APP_RC_INTA_IRQ_CNT_CNT_MASK) >> DM_APP_RC_INTA_IRQ_CNT_CNT_SHIFT)
#define  DM_APP_RC_INTA_IRQ_CNT_CNT_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_RC_INTA_IRQ_CNT_CNT_MASK) | (((uint32_t)val) << DM_APP_RC_INTA_IRQ_CNT_CNT_SHIFT))

//====================================================================
//Register: Application INTB Interrupt Enable (RC_INTB_IRQ_En)
//====================================================================

#define  DM_APP_RC_INTB_IRQ_EN_RESERVED1_MASK 0xfffffffe
#define  DM_APP_RC_INTB_IRQ_EN_RESERVED1_SHIFT 1
#define  DM_APP_RC_INTB_IRQ_EN_RESERVED1_MASK_SHIFT(reg) (((reg) & DM_APP_RC_INTB_IRQ_EN_RESERVED1_MASK) >> DM_APP_RC_INTB_IRQ_EN_RESERVED1_SHIFT)
#define  DM_APP_RC_INTB_IRQ_EN_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_RC_INTB_IRQ_EN_RESERVED1_MASK) | (((uint32_t)val) << DM_APP_RC_INTB_IRQ_EN_RESERVED1_SHIFT))

#define  DM_APP_RC_INTB_IRQ_EN_EN_MASK 0x1
#define  DM_APP_RC_INTB_IRQ_EN_EN_SHIFT 0
#define  DM_APP_RC_INTB_IRQ_EN_EN_MASK_SHIFT(reg) (((reg) & DM_APP_RC_INTB_IRQ_EN_EN_MASK) >> DM_APP_RC_INTB_IRQ_EN_EN_SHIFT)
#define  DM_APP_RC_INTB_IRQ_EN_EN_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_RC_INTB_IRQ_EN_EN_MASK) | (((uint32_t)val) << DM_APP_RC_INTB_IRQ_EN_EN_SHIFT))

//====================================================================
//Register: Application INTB Count Value (RC_INTB_IRQ_Cnt)
//====================================================================

#define  DM_APP_RC_INTB_IRQ_CNT_RESERVED1_MASK 0xfffffff0
#define  DM_APP_RC_INTB_IRQ_CNT_RESERVED1_SHIFT 4
#define  DM_APP_RC_INTB_IRQ_CNT_RESERVED1_MASK_SHIFT(reg) (((reg) & DM_APP_RC_INTB_IRQ_CNT_RESERVED1_MASK) >> DM_APP_RC_INTB_IRQ_CNT_RESERVED1_SHIFT)
#define  DM_APP_RC_INTB_IRQ_CNT_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_RC_INTB_IRQ_CNT_RESERVED1_MASK) | (((uint32_t)val) << DM_APP_RC_INTB_IRQ_CNT_RESERVED1_SHIFT))

#define  DM_APP_RC_INTB_IRQ_CNT_CNT_MASK 0xf
#define  DM_APP_RC_INTB_IRQ_CNT_CNT_SHIFT 0
#define  DM_APP_RC_INTB_IRQ_CNT_CNT_MASK_SHIFT(reg) (((reg) & DM_APP_RC_INTB_IRQ_CNT_CNT_MASK) >> DM_APP_RC_INTB_IRQ_CNT_CNT_SHIFT)
#define  DM_APP_RC_INTB_IRQ_CNT_CNT_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_RC_INTB_IRQ_CNT_CNT_MASK) | (((uint32_t)val) << DM_APP_RC_INTB_IRQ_CNT_CNT_SHIFT))

//====================================================================
//Register: Application INTC Interrupt Enable (RC_INTC_IRQ_En)
//====================================================================

#define  DM_APP_RC_INTC_IRQ_EN_RESERVED1_MASK 0xfffffffe
#define  DM_APP_RC_INTC_IRQ_EN_RESERVED1_SHIFT 1
#define  DM_APP_RC_INTC_IRQ_EN_RESERVED1_MASK_SHIFT(reg) (((reg) & DM_APP_RC_INTC_IRQ_EN_RESERVED1_MASK) >> DM_APP_RC_INTC_IRQ_EN_RESERVED1_SHIFT)
#define  DM_APP_RC_INTC_IRQ_EN_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_RC_INTC_IRQ_EN_RESERVED1_MASK) | (((uint32_t)val) << DM_APP_RC_INTC_IRQ_EN_RESERVED1_SHIFT))

#define  DM_APP_RC_INTC_IRQ_EN_EN_MASK 0x1
#define  DM_APP_RC_INTC_IRQ_EN_EN_SHIFT 0
#define  DM_APP_RC_INTC_IRQ_EN_EN_MASK_SHIFT(reg) (((reg) & DM_APP_RC_INTC_IRQ_EN_EN_MASK) >> DM_APP_RC_INTC_IRQ_EN_EN_SHIFT)
#define  DM_APP_RC_INTC_IRQ_EN_EN_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_RC_INTC_IRQ_EN_EN_MASK) | (((uint32_t)val) << DM_APP_RC_INTC_IRQ_EN_EN_SHIFT))

//====================================================================
//Register: Application INTC Count Value (RC_INTC_IRQ_Cnt)
//====================================================================

#define  DM_APP_RC_INTC_IRQ_CNT_RESERVED1_MASK 0xfffffff0
#define  DM_APP_RC_INTC_IRQ_CNT_RESERVED1_SHIFT 4
#define  DM_APP_RC_INTC_IRQ_CNT_RESERVED1_MASK_SHIFT(reg) (((reg) & DM_APP_RC_INTC_IRQ_CNT_RESERVED1_MASK) >> DM_APP_RC_INTC_IRQ_CNT_RESERVED1_SHIFT)
#define  DM_APP_RC_INTC_IRQ_CNT_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_RC_INTC_IRQ_CNT_RESERVED1_MASK) | (((uint32_t)val) << DM_APP_RC_INTC_IRQ_CNT_RESERVED1_SHIFT))

#define  DM_APP_RC_INTC_IRQ_CNT_CNT_MASK 0xf
#define  DM_APP_RC_INTC_IRQ_CNT_CNT_SHIFT 0
#define  DM_APP_RC_INTC_IRQ_CNT_CNT_MASK_SHIFT(reg) (((reg) & DM_APP_RC_INTC_IRQ_CNT_CNT_MASK) >> DM_APP_RC_INTC_IRQ_CNT_CNT_SHIFT)
#define  DM_APP_RC_INTC_IRQ_CNT_CNT_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_RC_INTC_IRQ_CNT_CNT_MASK) | (((uint32_t)val) << DM_APP_RC_INTC_IRQ_CNT_CNT_SHIFT))

//====================================================================
//Register: Application INTD Interrupt Enable (RC_INTD_IRQ_En)
//====================================================================

#define  DM_APP_RC_INTD_IRQ_EN_RESERVED1_MASK 0xfffffffe
#define  DM_APP_RC_INTD_IRQ_EN_RESERVED1_SHIFT 1
#define  DM_APP_RC_INTD_IRQ_EN_RESERVED1_MASK_SHIFT(reg) (((reg) & DM_APP_RC_INTD_IRQ_EN_RESERVED1_MASK) >> DM_APP_RC_INTD_IRQ_EN_RESERVED1_SHIFT)
#define  DM_APP_RC_INTD_IRQ_EN_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_RC_INTD_IRQ_EN_RESERVED1_MASK) | (((uint32_t)val) << DM_APP_RC_INTD_IRQ_EN_RESERVED1_SHIFT))

#define  DM_APP_RC_INTD_IRQ_EN_EN_MASK 0x1
#define  DM_APP_RC_INTD_IRQ_EN_EN_SHIFT 0
#define  DM_APP_RC_INTD_IRQ_EN_EN_MASK_SHIFT(reg) (((reg) & DM_APP_RC_INTD_IRQ_EN_EN_MASK) >> DM_APP_RC_INTD_IRQ_EN_EN_SHIFT)
#define  DM_APP_RC_INTD_IRQ_EN_EN_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_RC_INTD_IRQ_EN_EN_MASK) | (((uint32_t)val) << DM_APP_RC_INTD_IRQ_EN_EN_SHIFT))

//====================================================================
//Register: Application INTD Count Value (RC_INTD_IRQ_Cnt)
//====================================================================

#define  DM_APP_RC_INTD_IRQ_CNT_RESERVED1_MASK 0xfffffff0
#define  DM_APP_RC_INTD_IRQ_CNT_RESERVED1_SHIFT 4
#define  DM_APP_RC_INTD_IRQ_CNT_RESERVED1_MASK_SHIFT(reg) (((reg) & DM_APP_RC_INTD_IRQ_CNT_RESERVED1_MASK) >> DM_APP_RC_INTD_IRQ_CNT_RESERVED1_SHIFT)
#define  DM_APP_RC_INTD_IRQ_CNT_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_RC_INTD_IRQ_CNT_RESERVED1_MASK) | (((uint32_t)val) << DM_APP_RC_INTD_IRQ_CNT_RESERVED1_SHIFT))

#define  DM_APP_RC_INTD_IRQ_CNT_CNT_MASK 0xf
#define  DM_APP_RC_INTD_IRQ_CNT_CNT_SHIFT 0
#define  DM_APP_RC_INTD_IRQ_CNT_CNT_MASK_SHIFT(reg) (((reg) & DM_APP_RC_INTD_IRQ_CNT_CNT_MASK) >> DM_APP_RC_INTD_IRQ_CNT_CNT_SHIFT)
#define  DM_APP_RC_INTD_IRQ_CNT_CNT_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_RC_INTD_IRQ_CNT_CNT_MASK) | (((uint32_t)val) << DM_APP_RC_INTD_IRQ_CNT_CNT_SHIFT))

//====================================================================
//Register: Application - EP INTA Generate (EP_INTA_Gen)
//====================================================================

#define  DM_APP_EP_INTA_GEN_RESERVED1_MASK 0xfffffffe
#define  DM_APP_EP_INTA_GEN_RESERVED1_SHIFT 1
#define  DM_APP_EP_INTA_GEN_RESERVED1_MASK_SHIFT(reg) (((reg) & DM_APP_EP_INTA_GEN_RESERVED1_MASK) >> DM_APP_EP_INTA_GEN_RESERVED1_SHIFT)
#define  DM_APP_EP_INTA_GEN_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_EP_INTA_GEN_RESERVED1_MASK) | (((uint32_t)val) << DM_APP_EP_INTA_GEN_RESERVED1_SHIFT))

#define  DM_APP_EP_INTA_GEN_TOGGLE_MASK 0x1
#define  DM_APP_EP_INTA_GEN_TOGGLE_SHIFT 0
#define  DM_APP_EP_INTA_GEN_TOGGLE_MASK_SHIFT(reg) (((reg) & DM_APP_EP_INTA_GEN_TOGGLE_MASK) >> DM_APP_EP_INTA_GEN_TOGGLE_SHIFT)
#define  DM_APP_EP_INTA_GEN_TOGGLE_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_EP_INTA_GEN_TOGGLE_MASK) | (((uint32_t)val) << DM_APP_EP_INTA_GEN_TOGGLE_SHIFT))

//====================================================================
//Register: Application - EP MSI Generate (EP_MSI_Gen)
//====================================================================

#define  DM_APP_EP_MSI_GEN_RESERVED1_MASK 0xffffffe0
#define  DM_APP_EP_MSI_GEN_RESERVED1_SHIFT 5
#define  DM_APP_EP_MSI_GEN_RESERVED1_MASK_SHIFT(reg) (((reg) & DM_APP_EP_MSI_GEN_RESERVED1_MASK) >> DM_APP_EP_MSI_GEN_RESERVED1_SHIFT)
#define  DM_APP_EP_MSI_GEN_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_EP_MSI_GEN_RESERVED1_MASK) | (((uint32_t)val) << DM_APP_EP_MSI_GEN_RESERVED1_SHIFT))

#define  DM_APP_EP_MSI_GEN_DATA_MASK 0x1f
#define  DM_APP_EP_MSI_GEN_DATA_SHIFT 0
#define  DM_APP_EP_MSI_GEN_DATA_MASK_SHIFT(reg) (((reg) & DM_APP_EP_MSI_GEN_DATA_MASK) >> DM_APP_EP_MSI_GEN_DATA_SHIFT)
#define  DM_APP_EP_MSI_GEN_DATA_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_EP_MSI_GEN_DATA_MASK) | (((uint32_t)val) << DM_APP_EP_MSI_GEN_DATA_SHIFT))

//====================================================================
//Register: Application - EP MSI Generate Enabled (EP_MSI_Gen_En)
//====================================================================

#define  DM_APP_EP_MSI_GEN_EN_RESERVED1_MASK 0xfffffffc
#define  DM_APP_EP_MSI_GEN_EN_RESERVED1_SHIFT 2
#define  DM_APP_EP_MSI_GEN_EN_RESERVED1_MASK_SHIFT(reg) (((reg) & DM_APP_EP_MSI_GEN_EN_RESERVED1_MASK) >> DM_APP_EP_MSI_GEN_EN_RESERVED1_SHIFT)
#define  DM_APP_EP_MSI_GEN_EN_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_EP_MSI_GEN_EN_RESERVED1_MASK) | (((uint32_t)val) << DM_APP_EP_MSI_GEN_EN_RESERVED1_SHIFT))

#define  DM_APP_EP_MSI_GEN_EN_RDY_MASK 0x2
#define  DM_APP_EP_MSI_GEN_EN_RDY_SHIFT 1
#define  DM_APP_EP_MSI_GEN_EN_RDY_MASK_SHIFT(reg) (((reg) & DM_APP_EP_MSI_GEN_EN_RDY_MASK) >> DM_APP_EP_MSI_GEN_EN_RDY_SHIFT)
#define  DM_APP_EP_MSI_GEN_EN_RDY_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_EP_MSI_GEN_EN_RDY_MASK) | (((uint32_t)val) << DM_APP_EP_MSI_GEN_EN_RDY_SHIFT))

#define  DM_APP_EP_MSI_GEN_EN_DATA_MASK 0x1
#define  DM_APP_EP_MSI_GEN_EN_DATA_SHIFT 0
#define  DM_APP_EP_MSI_GEN_EN_DATA_MASK_SHIFT(reg) (((reg) & DM_APP_EP_MSI_GEN_EN_DATA_MASK) >> DM_APP_EP_MSI_GEN_EN_DATA_SHIFT)
#define  DM_APP_EP_MSI_GEN_EN_DATA_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_EP_MSI_GEN_EN_DATA_MASK) | (((uint32_t)val) << DM_APP_EP_MSI_GEN_EN_DATA_SHIFT))

//====================================================================
//Register: Application - Mailbox Write Interrupt Enable Register 0-7 (Instance 1 of 8) (MB_WR_En0)
/** \brief  (Instance 1 of 8)*/
//====================================================================

#define  DM_APP_MB_WR_EN0_DATA_MASK 0xffffffff
#define  DM_APP_MB_WR_EN0_DATA_SHIFT 0
#define  DM_APP_MB_WR_EN0_DATA_MASK_SHIFT(reg) (((reg) & DM_APP_MB_WR_EN0_DATA_MASK) >> DM_APP_MB_WR_EN0_DATA_SHIFT)
#define  DM_APP_MB_WR_EN0_DATA_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_MB_WR_EN0_DATA_MASK) | (((uint32_t)val) << DM_APP_MB_WR_EN0_DATA_SHIFT))

//====================================================================
//Register: Application - Mailbox Write Interrupt Enable Register 0-7 (Instance 2 of 8) (MB_WR_En1)
/** \brief  (Instance 2 of 8)*/
//====================================================================

#define  DM_APP_MB_WR_EN1_DATA_MASK 0xffffffff
#define  DM_APP_MB_WR_EN1_DATA_SHIFT 0
#define  DM_APP_MB_WR_EN1_DATA_MASK_SHIFT(reg) (((reg) & DM_APP_MB_WR_EN1_DATA_MASK) >> DM_APP_MB_WR_EN1_DATA_SHIFT)
#define  DM_APP_MB_WR_EN1_DATA_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_MB_WR_EN1_DATA_MASK) | (((uint32_t)val) << DM_APP_MB_WR_EN1_DATA_SHIFT))

//====================================================================
//Register: Application - Mailbox Write Interrupt Enable Register 0-7 (Instance 3 of 8) (MB_WR_En2)
/** \brief  (Instance 3 of 8)*/
//====================================================================

#define  DM_APP_MB_WR_EN2_DATA_MASK 0xffffffff
#define  DM_APP_MB_WR_EN2_DATA_SHIFT 0
#define  DM_APP_MB_WR_EN2_DATA_MASK_SHIFT(reg) (((reg) & DM_APP_MB_WR_EN2_DATA_MASK) >> DM_APP_MB_WR_EN2_DATA_SHIFT)
#define  DM_APP_MB_WR_EN2_DATA_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_MB_WR_EN2_DATA_MASK) | (((uint32_t)val) << DM_APP_MB_WR_EN2_DATA_SHIFT))

//====================================================================
//Register: Application - Mailbox Write Interrupt Enable Register 0-7 (Instance 4 of 8) (MB_WR_En3)
/** \brief  (Instance 4 of 8)*/
//====================================================================

#define  DM_APP_MB_WR_EN3_DATA_MASK 0xffffffff
#define  DM_APP_MB_WR_EN3_DATA_SHIFT 0
#define  DM_APP_MB_WR_EN3_DATA_MASK_SHIFT(reg) (((reg) & DM_APP_MB_WR_EN3_DATA_MASK) >> DM_APP_MB_WR_EN3_DATA_SHIFT)
#define  DM_APP_MB_WR_EN3_DATA_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_MB_WR_EN3_DATA_MASK) | (((uint32_t)val) << DM_APP_MB_WR_EN3_DATA_SHIFT))

//====================================================================
//Register: Application - Mailbox Write Interrupt Enable Register 0-7 (Instance 5 of 8) (MB_WR_En4)
/** \brief  (Instance 5 of 8)*/
//====================================================================

#define  DM_APP_MB_WR_EN4_DATA_MASK 0xffffffff
#define  DM_APP_MB_WR_EN4_DATA_SHIFT 0
#define  DM_APP_MB_WR_EN4_DATA_MASK_SHIFT(reg) (((reg) & DM_APP_MB_WR_EN4_DATA_MASK) >> DM_APP_MB_WR_EN4_DATA_SHIFT)
#define  DM_APP_MB_WR_EN4_DATA_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_MB_WR_EN4_DATA_MASK) | (((uint32_t)val) << DM_APP_MB_WR_EN4_DATA_SHIFT))

//====================================================================
//Register: Application - Mailbox Write Interrupt Enable Register 0-7 (Instance 6 of 8) (MB_WR_En5)
/** \brief  (Instance 6 of 8)*/
//====================================================================

#define  DM_APP_MB_WR_EN5_DATA_MASK 0xffffffff
#define  DM_APP_MB_WR_EN5_DATA_SHIFT 0
#define  DM_APP_MB_WR_EN5_DATA_MASK_SHIFT(reg) (((reg) & DM_APP_MB_WR_EN5_DATA_MASK) >> DM_APP_MB_WR_EN5_DATA_SHIFT)
#define  DM_APP_MB_WR_EN5_DATA_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_MB_WR_EN5_DATA_MASK) | (((uint32_t)val) << DM_APP_MB_WR_EN5_DATA_SHIFT))

//====================================================================
//Register: Application - Mailbox Write Interrupt Enable Register 0-7 (Instance 7 of 8) (MB_WR_En6)
/** \brief  (Instance 7 of 8)*/
//====================================================================

#define  DM_APP_MB_WR_EN6_DATA_MASK 0xffffffff
#define  DM_APP_MB_WR_EN6_DATA_SHIFT 0
#define  DM_APP_MB_WR_EN6_DATA_MASK_SHIFT(reg) (((reg) & DM_APP_MB_WR_EN6_DATA_MASK) >> DM_APP_MB_WR_EN6_DATA_SHIFT)
#define  DM_APP_MB_WR_EN6_DATA_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_MB_WR_EN6_DATA_MASK) | (((uint32_t)val) << DM_APP_MB_WR_EN6_DATA_SHIFT))

//====================================================================
//Register: Application - Mailbox Write Interrupt Enable Register 0-7 (Instance 8 of 8) (MB_WR_En7)
/** \brief  (Instance 8 of 8)*/
//====================================================================

#define  DM_APP_MB_WR_EN7_DATA_MASK 0xffffffff
#define  DM_APP_MB_WR_EN7_DATA_SHIFT 0
#define  DM_APP_MB_WR_EN7_DATA_MASK_SHIFT(reg) (((reg) & DM_APP_MB_WR_EN7_DATA_MASK) >> DM_APP_MB_WR_EN7_DATA_SHIFT)
#define  DM_APP_MB_WR_EN7_DATA_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_MB_WR_EN7_DATA_MASK) | (((uint32_t)val) << DM_APP_MB_WR_EN7_DATA_SHIFT))

//====================================================================
//Register: Application - Mailbox Write Register 0-7 (Instance 1 of 8) (MB_WR0)
/** \brief  (Instance 1 of 8)*/
//====================================================================

#define  DM_APP_MB_WR0_DATA_MASK 0xffffffff
#define  DM_APP_MB_WR0_DATA_SHIFT 0
#define  DM_APP_MB_WR0_DATA_MASK_SHIFT(reg) (((reg) & DM_APP_MB_WR0_DATA_MASK) >> DM_APP_MB_WR0_DATA_SHIFT)
#define  DM_APP_MB_WR0_DATA_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_MB_WR0_DATA_MASK) | (((uint32_t)val) << DM_APP_MB_WR0_DATA_SHIFT))

//====================================================================
//Register: Application - Mailbox Write Register 0-7 (Instance 2 of 8) (MB_WR1)
/** \brief  (Instance 2 of 8)*/
//====================================================================

#define  DM_APP_MB_WR1_DATA_MASK 0xffffffff
#define  DM_APP_MB_WR1_DATA_SHIFT 0
#define  DM_APP_MB_WR1_DATA_MASK_SHIFT(reg) (((reg) & DM_APP_MB_WR1_DATA_MASK) >> DM_APP_MB_WR1_DATA_SHIFT)
#define  DM_APP_MB_WR1_DATA_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_MB_WR1_DATA_MASK) | (((uint32_t)val) << DM_APP_MB_WR1_DATA_SHIFT))

//====================================================================
//Register: Application - Mailbox Write Register 0-7 (Instance 3 of 8) (MB_WR2)
/** \brief  (Instance 3 of 8)*/
//====================================================================

#define  DM_APP_MB_WR2_DATA_MASK 0xffffffff
#define  DM_APP_MB_WR2_DATA_SHIFT 0
#define  DM_APP_MB_WR2_DATA_MASK_SHIFT(reg) (((reg) & DM_APP_MB_WR2_DATA_MASK) >> DM_APP_MB_WR2_DATA_SHIFT)
#define  DM_APP_MB_WR2_DATA_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_MB_WR2_DATA_MASK) | (((uint32_t)val) << DM_APP_MB_WR2_DATA_SHIFT))

//====================================================================
//Register: Application - Mailbox Write Register 0-7 (Instance 4 of 8) (MB_WR3)
/** \brief  (Instance 4 of 8)*/
//====================================================================

#define  DM_APP_MB_WR3_DATA_MASK 0xffffffff
#define  DM_APP_MB_WR3_DATA_SHIFT 0
#define  DM_APP_MB_WR3_DATA_MASK_SHIFT(reg) (((reg) & DM_APP_MB_WR3_DATA_MASK) >> DM_APP_MB_WR3_DATA_SHIFT)
#define  DM_APP_MB_WR3_DATA_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_MB_WR3_DATA_MASK) | (((uint32_t)val) << DM_APP_MB_WR3_DATA_SHIFT))

//====================================================================
//Register: Application - Mailbox Write Register 0-7 (Instance 5 of 8) (MB_WR4)
/** \brief  (Instance 5 of 8)*/
//====================================================================

#define  DM_APP_MB_WR4_DATA_MASK 0xffffffff
#define  DM_APP_MB_WR4_DATA_SHIFT 0
#define  DM_APP_MB_WR4_DATA_MASK_SHIFT(reg) (((reg) & DM_APP_MB_WR4_DATA_MASK) >> DM_APP_MB_WR4_DATA_SHIFT)
#define  DM_APP_MB_WR4_DATA_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_MB_WR4_DATA_MASK) | (((uint32_t)val) << DM_APP_MB_WR4_DATA_SHIFT))

//====================================================================
//Register: Application - Mailbox Write Register 0-7 (Instance 6 of 8) (MB_WR5)
/** \brief  (Instance 6 of 8)*/
//====================================================================

#define  DM_APP_MB_WR5_DATA_MASK 0xffffffff
#define  DM_APP_MB_WR5_DATA_SHIFT 0
#define  DM_APP_MB_WR5_DATA_MASK_SHIFT(reg) (((reg) & DM_APP_MB_WR5_DATA_MASK) >> DM_APP_MB_WR5_DATA_SHIFT)
#define  DM_APP_MB_WR5_DATA_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_MB_WR5_DATA_MASK) | (((uint32_t)val) << DM_APP_MB_WR5_DATA_SHIFT))

//====================================================================
//Register: Application - Mailbox Write Register 0-7 (Instance 7 of 8) (MB_WR6)
/** \brief  (Instance 7 of 8)*/
//====================================================================

#define  DM_APP_MB_WR6_DATA_MASK 0xffffffff
#define  DM_APP_MB_WR6_DATA_SHIFT 0
#define  DM_APP_MB_WR6_DATA_MASK_SHIFT(reg) (((reg) & DM_APP_MB_WR6_DATA_MASK) >> DM_APP_MB_WR6_DATA_SHIFT)
#define  DM_APP_MB_WR6_DATA_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_MB_WR6_DATA_MASK) | (((uint32_t)val) << DM_APP_MB_WR6_DATA_SHIFT))

//====================================================================
//Register: Application - Mailbox Write Register 0-7 (Instance 8 of 8) (MB_WR7)
/** \brief  (Instance 8 of 8)*/
//====================================================================

#define  DM_APP_MB_WR7_DATA_MASK 0xffffffff
#define  DM_APP_MB_WR7_DATA_SHIFT 0
#define  DM_APP_MB_WR7_DATA_MASK_SHIFT(reg) (((reg) & DM_APP_MB_WR7_DATA_MASK) >> DM_APP_MB_WR7_DATA_SHIFT)
#define  DM_APP_MB_WR7_DATA_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_MB_WR7_DATA_MASK) | (((uint32_t)val) << DM_APP_MB_WR7_DATA_SHIFT))

//====================================================================
//Register: Application - Mailbox Write Register Status 0-7 (Instance 1 of 8) (MB_WR_Stat0)
/** \brief  (Instance 1 of 8)*/
//====================================================================

#define  DM_APP_MB_WR_STAT0_DATA_MASK 0xffffffff
#define  DM_APP_MB_WR_STAT0_DATA_SHIFT 0
#define  DM_APP_MB_WR_STAT0_DATA_MASK_SHIFT(reg) (((reg) & DM_APP_MB_WR_STAT0_DATA_MASK) >> DM_APP_MB_WR_STAT0_DATA_SHIFT)
#define  DM_APP_MB_WR_STAT0_DATA_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_MB_WR_STAT0_DATA_MASK) | (((uint32_t)val) << DM_APP_MB_WR_STAT0_DATA_SHIFT))

//====================================================================
//Register: Application - Mailbox Write Register Status 0-7 (Instance 2 of 8) (MB_WR_Stat1)
/** \brief  (Instance 2 of 8)*/
//====================================================================

#define  DM_APP_MB_WR_STAT1_DATA_MASK 0xffffffff
#define  DM_APP_MB_WR_STAT1_DATA_SHIFT 0
#define  DM_APP_MB_WR_STAT1_DATA_MASK_SHIFT(reg) (((reg) & DM_APP_MB_WR_STAT1_DATA_MASK) >> DM_APP_MB_WR_STAT1_DATA_SHIFT)
#define  DM_APP_MB_WR_STAT1_DATA_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_MB_WR_STAT1_DATA_MASK) | (((uint32_t)val) << DM_APP_MB_WR_STAT1_DATA_SHIFT))

//====================================================================
//Register: Application - Mailbox Write Register Status 0-7 (Instance 3 of 8) (MB_WR_Stat2)
/** \brief  (Instance 3 of 8)*/
//====================================================================

#define  DM_APP_MB_WR_STAT2_DATA_MASK 0xffffffff
#define  DM_APP_MB_WR_STAT2_DATA_SHIFT 0
#define  DM_APP_MB_WR_STAT2_DATA_MASK_SHIFT(reg) (((reg) & DM_APP_MB_WR_STAT2_DATA_MASK) >> DM_APP_MB_WR_STAT2_DATA_SHIFT)
#define  DM_APP_MB_WR_STAT2_DATA_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_MB_WR_STAT2_DATA_MASK) | (((uint32_t)val) << DM_APP_MB_WR_STAT2_DATA_SHIFT))

//====================================================================
//Register: Application - Mailbox Write Register Status 0-7 (Instance 4 of 8) (MB_WR_Stat3)
/** \brief  (Instance 4 of 8)*/
//====================================================================

#define  DM_APP_MB_WR_STAT3_DATA_MASK 0xffffffff
#define  DM_APP_MB_WR_STAT3_DATA_SHIFT 0
#define  DM_APP_MB_WR_STAT3_DATA_MASK_SHIFT(reg) (((reg) & DM_APP_MB_WR_STAT3_DATA_MASK) >> DM_APP_MB_WR_STAT3_DATA_SHIFT)
#define  DM_APP_MB_WR_STAT3_DATA_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_MB_WR_STAT3_DATA_MASK) | (((uint32_t)val) << DM_APP_MB_WR_STAT3_DATA_SHIFT))

//====================================================================
//Register: Application - Mailbox Write Register Status 0-7 (Instance 5 of 8) (MB_WR_Stat4)
/** \brief  (Instance 5 of 8)*/
//====================================================================

#define  DM_APP_MB_WR_STAT4_DATA_MASK 0xffffffff
#define  DM_APP_MB_WR_STAT4_DATA_SHIFT 0
#define  DM_APP_MB_WR_STAT4_DATA_MASK_SHIFT(reg) (((reg) & DM_APP_MB_WR_STAT4_DATA_MASK) >> DM_APP_MB_WR_STAT4_DATA_SHIFT)
#define  DM_APP_MB_WR_STAT4_DATA_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_MB_WR_STAT4_DATA_MASK) | (((uint32_t)val) << DM_APP_MB_WR_STAT4_DATA_SHIFT))

//====================================================================
//Register: Application - Mailbox Write Register Status 0-7 (Instance 6 of 8) (MB_WR_Stat5)
/** \brief  (Instance 6 of 8)*/
//====================================================================

#define  DM_APP_MB_WR_STAT5_DATA_MASK 0xffffffff
#define  DM_APP_MB_WR_STAT5_DATA_SHIFT 0
#define  DM_APP_MB_WR_STAT5_DATA_MASK_SHIFT(reg) (((reg) & DM_APP_MB_WR_STAT5_DATA_MASK) >> DM_APP_MB_WR_STAT5_DATA_SHIFT)
#define  DM_APP_MB_WR_STAT5_DATA_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_MB_WR_STAT5_DATA_MASK) | (((uint32_t)val) << DM_APP_MB_WR_STAT5_DATA_SHIFT))

//====================================================================
//Register: Application - Mailbox Write Register Status 0-7 (Instance 7 of 8) (MB_WR_Stat6)
/** \brief  (Instance 7 of 8)*/
//====================================================================

#define  DM_APP_MB_WR_STAT6_DATA_MASK 0xffffffff
#define  DM_APP_MB_WR_STAT6_DATA_SHIFT 0
#define  DM_APP_MB_WR_STAT6_DATA_MASK_SHIFT(reg) (((reg) & DM_APP_MB_WR_STAT6_DATA_MASK) >> DM_APP_MB_WR_STAT6_DATA_SHIFT)
#define  DM_APP_MB_WR_STAT6_DATA_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_MB_WR_STAT6_DATA_MASK) | (((uint32_t)val) << DM_APP_MB_WR_STAT6_DATA_SHIFT))

//====================================================================
//Register: Application - Mailbox Write Register Status 0-7 (Instance 8 of 8) (MB_WR_Stat7)
/** \brief  (Instance 8 of 8)*/
//====================================================================

#define  DM_APP_MB_WR_STAT7_DATA_MASK 0xffffffff
#define  DM_APP_MB_WR_STAT7_DATA_SHIFT 0
#define  DM_APP_MB_WR_STAT7_DATA_MASK_SHIFT(reg) (((reg) & DM_APP_MB_WR_STAT7_DATA_MASK) >> DM_APP_MB_WR_STAT7_DATA_SHIFT)
#define  DM_APP_MB_WR_STAT7_DATA_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_MB_WR_STAT7_DATA_MASK) | (((uint32_t)val) << DM_APP_MB_WR_STAT7_DATA_SHIFT))

//====================================================================
//Register: Application - Mailbox Write Interrupt Acknowledge Register 0-7 (Instance 1 of 8) (MB_WR_Ack0)
/** \brief  (Instance 1 of 8)*/
//====================================================================

#define  DM_APP_MB_WR_ACK0_DATA_MASK 0xffffffff
#define  DM_APP_MB_WR_ACK0_DATA_SHIFT 0
#define  DM_APP_MB_WR_ACK0_DATA_MASK_SHIFT(reg) (((reg) & DM_APP_MB_WR_ACK0_DATA_MASK) >> DM_APP_MB_WR_ACK0_DATA_SHIFT)
#define  DM_APP_MB_WR_ACK0_DATA_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_MB_WR_ACK0_DATA_MASK) | (((uint32_t)val) << DM_APP_MB_WR_ACK0_DATA_SHIFT))

//====================================================================
//Register: Application - Mailbox Write Interrupt Acknowledge Register 0-7 (Instance 2 of 8) (MB_WR_Ack1)
/** \brief  (Instance 2 of 8)*/
//====================================================================

#define  DM_APP_MB_WR_ACK1_DATA_MASK 0xffffffff
#define  DM_APP_MB_WR_ACK1_DATA_SHIFT 0
#define  DM_APP_MB_WR_ACK1_DATA_MASK_SHIFT(reg) (((reg) & DM_APP_MB_WR_ACK1_DATA_MASK) >> DM_APP_MB_WR_ACK1_DATA_SHIFT)
#define  DM_APP_MB_WR_ACK1_DATA_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_MB_WR_ACK1_DATA_MASK) | (((uint32_t)val) << DM_APP_MB_WR_ACK1_DATA_SHIFT))

//====================================================================
//Register: Application - Mailbox Write Interrupt Acknowledge Register 0-7 (Instance 3 of 8) (MB_WR_Ack2)
/** \brief  (Instance 3 of 8)*/
//====================================================================

#define  DM_APP_MB_WR_ACK2_DATA_MASK 0xffffffff
#define  DM_APP_MB_WR_ACK2_DATA_SHIFT 0
#define  DM_APP_MB_WR_ACK2_DATA_MASK_SHIFT(reg) (((reg) & DM_APP_MB_WR_ACK2_DATA_MASK) >> DM_APP_MB_WR_ACK2_DATA_SHIFT)
#define  DM_APP_MB_WR_ACK2_DATA_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_MB_WR_ACK2_DATA_MASK) | (((uint32_t)val) << DM_APP_MB_WR_ACK2_DATA_SHIFT))

//====================================================================
//Register: Application - Mailbox Write Interrupt Acknowledge Register 0-7 (Instance 4 of 8) (MB_WR_Ack3)
/** \brief  (Instance 4 of 8)*/
//====================================================================

#define  DM_APP_MB_WR_ACK3_DATA_MASK 0xffffffff
#define  DM_APP_MB_WR_ACK3_DATA_SHIFT 0
#define  DM_APP_MB_WR_ACK3_DATA_MASK_SHIFT(reg) (((reg) & DM_APP_MB_WR_ACK3_DATA_MASK) >> DM_APP_MB_WR_ACK3_DATA_SHIFT)
#define  DM_APP_MB_WR_ACK3_DATA_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_MB_WR_ACK3_DATA_MASK) | (((uint32_t)val) << DM_APP_MB_WR_ACK3_DATA_SHIFT))

//====================================================================
//Register: Application - Mailbox Write Interrupt Acknowledge Register 0-7 (Instance 5 of 8) (MB_WR_Ack4)
/** \brief  (Instance 5 of 8)*/
//====================================================================

#define  DM_APP_MB_WR_ACK4_DATA_MASK 0xffffffff
#define  DM_APP_MB_WR_ACK4_DATA_SHIFT 0
#define  DM_APP_MB_WR_ACK4_DATA_MASK_SHIFT(reg) (((reg) & DM_APP_MB_WR_ACK4_DATA_MASK) >> DM_APP_MB_WR_ACK4_DATA_SHIFT)
#define  DM_APP_MB_WR_ACK4_DATA_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_MB_WR_ACK4_DATA_MASK) | (((uint32_t)val) << DM_APP_MB_WR_ACK4_DATA_SHIFT))

//====================================================================
//Register: Application - Mailbox Write Interrupt Acknowledge Register 0-7 (Instance 6 of 8) (MB_WR_Ack5)
/** \brief  (Instance 6 of 8)*/
//====================================================================

#define  DM_APP_MB_WR_ACK5_DATA_MASK 0xffffffff
#define  DM_APP_MB_WR_ACK5_DATA_SHIFT 0
#define  DM_APP_MB_WR_ACK5_DATA_MASK_SHIFT(reg) (((reg) & DM_APP_MB_WR_ACK5_DATA_MASK) >> DM_APP_MB_WR_ACK5_DATA_SHIFT)
#define  DM_APP_MB_WR_ACK5_DATA_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_MB_WR_ACK5_DATA_MASK) | (((uint32_t)val) << DM_APP_MB_WR_ACK5_DATA_SHIFT))

//====================================================================
//Register: Application - Mailbox Write Interrupt Acknowledge Register 0-7 (Instance 7 of 8) (MB_WR_Ack6)
/** \brief  (Instance 7 of 8)*/
//====================================================================

#define  DM_APP_MB_WR_ACK6_DATA_MASK 0xffffffff
#define  DM_APP_MB_WR_ACK6_DATA_SHIFT 0
#define  DM_APP_MB_WR_ACK6_DATA_MASK_SHIFT(reg) (((reg) & DM_APP_MB_WR_ACK6_DATA_MASK) >> DM_APP_MB_WR_ACK6_DATA_SHIFT)
#define  DM_APP_MB_WR_ACK6_DATA_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_MB_WR_ACK6_DATA_MASK) | (((uint32_t)val) << DM_APP_MB_WR_ACK6_DATA_SHIFT))

//====================================================================
//Register: Application - Mailbox Write Interrupt Acknowledge Register 0-7 (Instance 8 of 8) (MB_WR_Ack7)
/** \brief  (Instance 8 of 8)*/
//====================================================================

#define  DM_APP_MB_WR_ACK7_DATA_MASK 0xffffffff
#define  DM_APP_MB_WR_ACK7_DATA_SHIFT 0
#define  DM_APP_MB_WR_ACK7_DATA_MASK_SHIFT(reg) (((reg) & DM_APP_MB_WR_ACK7_DATA_MASK) >> DM_APP_MB_WR_ACK7_DATA_SHIFT)
#define  DM_APP_MB_WR_ACK7_DATA_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_MB_WR_ACK7_DATA_MASK) | (((uint32_t)val) << DM_APP_MB_WR_ACK7_DATA_SHIFT))

//====================================================================
//Register: Application - General Purpose Communication Register 0-7 (Instance 1 of 8) (COMM0)
/** \brief  (Instance 1 of 8)*/
//====================================================================

#define  DM_APP_COMM0_DATA_MASK 0xffffffff
#define  DM_APP_COMM0_DATA_SHIFT 0
#define  DM_APP_COMM0_DATA_MASK_SHIFT(reg) (((reg) & DM_APP_COMM0_DATA_MASK) >> DM_APP_COMM0_DATA_SHIFT)
#define  DM_APP_COMM0_DATA_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_COMM0_DATA_MASK) | (((uint32_t)val) << DM_APP_COMM0_DATA_SHIFT))

//====================================================================
//Register: Application - General Purpose Communication Register 0-7 (Instance 2 of 8) (COMM1)
/** \brief  (Instance 2 of 8)*/
//====================================================================

#define  DM_APP_COMM1_DATA_MASK 0xffffffff
#define  DM_APP_COMM1_DATA_SHIFT 0
#define  DM_APP_COMM1_DATA_MASK_SHIFT(reg) (((reg) & DM_APP_COMM1_DATA_MASK) >> DM_APP_COMM1_DATA_SHIFT)
#define  DM_APP_COMM1_DATA_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_COMM1_DATA_MASK) | (((uint32_t)val) << DM_APP_COMM1_DATA_SHIFT))

//====================================================================
//Register: Application - General Purpose Communication Register 0-7 (Instance 3 of 8) (COMM2)
/** \brief  (Instance 3 of 8)*/
//====================================================================

#define  DM_APP_COMM2_DATA_MASK 0xffffffff
#define  DM_APP_COMM2_DATA_SHIFT 0
#define  DM_APP_COMM2_DATA_MASK_SHIFT(reg) (((reg) & DM_APP_COMM2_DATA_MASK) >> DM_APP_COMM2_DATA_SHIFT)
#define  DM_APP_COMM2_DATA_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_COMM2_DATA_MASK) | (((uint32_t)val) << DM_APP_COMM2_DATA_SHIFT))

//====================================================================
//Register: Application - General Purpose Communication Register 0-7 (Instance 4 of 8) (COMM3)
/** \brief  (Instance 4 of 8)*/
//====================================================================

#define  DM_APP_COMM3_DATA_MASK 0xffffffff
#define  DM_APP_COMM3_DATA_SHIFT 0
#define  DM_APP_COMM3_DATA_MASK_SHIFT(reg) (((reg) & DM_APP_COMM3_DATA_MASK) >> DM_APP_COMM3_DATA_SHIFT)
#define  DM_APP_COMM3_DATA_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_COMM3_DATA_MASK) | (((uint32_t)val) << DM_APP_COMM3_DATA_SHIFT))

//====================================================================
//Register: Application - General Purpose Communication Register 0-7 (Instance 5 of 8) (COMM4)
/** \brief  (Instance 5 of 8)*/
//====================================================================

#define  DM_APP_COMM4_DATA_MASK 0xffffffff
#define  DM_APP_COMM4_DATA_SHIFT 0
#define  DM_APP_COMM4_DATA_MASK_SHIFT(reg) (((reg) & DM_APP_COMM4_DATA_MASK) >> DM_APP_COMM4_DATA_SHIFT)
#define  DM_APP_COMM4_DATA_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_COMM4_DATA_MASK) | (((uint32_t)val) << DM_APP_COMM4_DATA_SHIFT))

//====================================================================
//Register: Application - General Purpose Communication Register 0-7 (Instance 6 of 8) (COMM5)
/** \brief  (Instance 6 of 8)*/
//====================================================================

#define  DM_APP_COMM5_DATA_MASK 0xffffffff
#define  DM_APP_COMM5_DATA_SHIFT 0
#define  DM_APP_COMM5_DATA_MASK_SHIFT(reg) (((reg) & DM_APP_COMM5_DATA_MASK) >> DM_APP_COMM5_DATA_SHIFT)
#define  DM_APP_COMM5_DATA_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_COMM5_DATA_MASK) | (((uint32_t)val) << DM_APP_COMM5_DATA_SHIFT))

//====================================================================
//Register: Application - General Purpose Communication Register 0-7 (Instance 7 of 8) (COMM6)
/** \brief  (Instance 7 of 8)*/
//====================================================================

#define  DM_APP_COMM6_DATA_MASK 0xffffffff
#define  DM_APP_COMM6_DATA_SHIFT 0
#define  DM_APP_COMM6_DATA_MASK_SHIFT(reg) (((reg) & DM_APP_COMM6_DATA_MASK) >> DM_APP_COMM6_DATA_SHIFT)
#define  DM_APP_COMM6_DATA_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_COMM6_DATA_MASK) | (((uint32_t)val) << DM_APP_COMM6_DATA_SHIFT))

//====================================================================
//Register: Application - General Purpose Communication Register 0-7 (Instance 8 of 8) (COMM7)
/** \brief  (Instance 8 of 8)*/
//====================================================================

#define  DM_APP_COMM7_DATA_MASK 0xffffffff
#define  DM_APP_COMM7_DATA_SHIFT 0
#define  DM_APP_COMM7_DATA_MASK_SHIFT(reg) (((reg) & DM_APP_COMM7_DATA_MASK) >> DM_APP_COMM7_DATA_SHIFT)
#define  DM_APP_COMM7_DATA_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_COMM7_DATA_MASK) | (((uint32_t)val) << DM_APP_COMM7_DATA_SHIFT))

//====================================================================
//Register: Application - Ack Statistics Register (AckCount)
//====================================================================

#define  DM_APP_ACKCOUNT_DATA_MASK 0xffffffff
#define  DM_APP_ACKCOUNT_DATA_SHIFT 0
#define  DM_APP_ACKCOUNT_DATA_MASK_SHIFT(reg) (((reg) & DM_APP_ACKCOUNT_DATA_MASK) >> DM_APP_ACKCOUNT_DATA_SHIFT)
#define  DM_APP_ACKCOUNT_DATA_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_ACKCOUNT_DATA_MASK) | (((uint32_t)val) << DM_APP_ACKCOUNT_DATA_SHIFT))

//====================================================================
//Register: Application - Nack Statistics Register (NackCount)
//====================================================================

#define  DM_APP_NACKCOUNT_DATA_MASK 0xffffffff
#define  DM_APP_NACKCOUNT_DATA_SHIFT 0
#define  DM_APP_NACKCOUNT_DATA_MASK_SHIFT(reg) (((reg) & DM_APP_NACKCOUNT_DATA_MASK) >> DM_APP_NACKCOUNT_DATA_SHIFT)
#define  DM_APP_NACKCOUNT_DATA_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_NACKCOUNT_DATA_MASK) | (((uint32_t)val) << DM_APP_NACKCOUNT_DATA_SHIFT))

//====================================================================
//Register: Application - Write Ack Statistics Register (WrAckCount)
//====================================================================

#define  DM_APP_WRACKCOUNT_DATA_MASK 0xffffffff
#define  DM_APP_WRACKCOUNT_DATA_SHIFT 0
#define  DM_APP_WRACKCOUNT_DATA_MASK_SHIFT(reg) (((reg) & DM_APP_WRACKCOUNT_DATA_MASK) >> DM_APP_WRACKCOUNT_DATA_SHIFT)
#define  DM_APP_WRACKCOUNT_DATA_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_WRACKCOUNT_DATA_MASK) | (((uint32_t)val) << DM_APP_WRACKCOUNT_DATA_SHIFT))

//====================================================================
//Register: Application - Write Nack Statistics Register (WrNackCount)
//====================================================================

#define  DM_APP_WRNACKCOUNT_DATA_MASK 0xffffffff
#define  DM_APP_WRNACKCOUNT_DATA_SHIFT 0
#define  DM_APP_WRNACKCOUNT_DATA_MASK_SHIFT(reg) (((reg) & DM_APP_WRNACKCOUNT_DATA_MASK) >> DM_APP_WRNACKCOUNT_DATA_SHIFT)
#define  DM_APP_WRNACKCOUNT_DATA_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_WRNACKCOUNT_DATA_MASK) | (((uint32_t)val) << DM_APP_WRNACKCOUNT_DATA_SHIFT))

//====================================================================
//Register: Global Phy PIPE Revision (GLOB_PHY_REV)
/** \brief PIPE Revision Address 0x1C0 * 4 = 0x700*/
//====================================================================

#define  DM_APP_GLOB_PHY_REV_RESERVED1_MASK 0xffff0000
#define  DM_APP_GLOB_PHY_REV_RESERVED1_SHIFT 16
#define  DM_APP_GLOB_PHY_REV_RESERVED1_MASK_SHIFT(reg) (((reg) & DM_APP_GLOB_PHY_REV_RESERVED1_MASK) >> DM_APP_GLOB_PHY_REV_RESERVED1_SHIFT)
#define  DM_APP_GLOB_PHY_REV_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_GLOB_PHY_REV_RESERVED1_MASK) | (((uint32_t)val) << DM_APP_GLOB_PHY_REV_RESERVED1_SHIFT))

#define  DM_APP_GLOB_PHY_REV_MAIN_REVISION_MASK 0xff00
#define  DM_APP_GLOB_PHY_REV_MAIN_REVISION_SHIFT 8
#define  DM_APP_GLOB_PHY_REV_MAIN_REVISION_MASK_SHIFT(reg) (((reg) & DM_APP_GLOB_PHY_REV_MAIN_REVISION_MASK) >> DM_APP_GLOB_PHY_REV_MAIN_REVISION_SHIFT)
#define  DM_APP_GLOB_PHY_REV_MAIN_REVISION_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_GLOB_PHY_REV_MAIN_REVISION_MASK) | (((uint32_t)val) << DM_APP_GLOB_PHY_REV_MAIN_REVISION_SHIFT))

#define  DM_APP_GLOB_PHY_REV_SUB_REVISION_MASK 0xff
#define  DM_APP_GLOB_PHY_REV_SUB_REVISION_SHIFT 0
#define  DM_APP_GLOB_PHY_REV_SUB_REVISION_MASK_SHIFT(reg) (((reg) & DM_APP_GLOB_PHY_REV_SUB_REVISION_MASK) >> DM_APP_GLOB_PHY_REV_SUB_REVISION_SHIFT)
#define  DM_APP_GLOB_PHY_REV_SUB_REVISION_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_GLOB_PHY_REV_SUB_REVISION_MASK) | (((uint32_t)val) << DM_APP_GLOB_PHY_REV_SUB_REVISION_SHIFT))

//====================================================================
//Register: Global Clock Control (GLOB_CLK_CTRL)
/** \brief For all lane-dependent PHY registers, must first program the lane number register, DM Application PHY Lane Number, offset 0x11000<BR>
    If no lane dependency; i.e., if multicast mode set in this register, then programming the PHY Lane Number register is not required<BR>
    Address Offset 0x1C1 * 4 = 0x704*/
//====================================================================

#define  DM_APP_GLOB_CLK_CTRL_RESERVED1_MASK 0xfffffc00
#define  DM_APP_GLOB_CLK_CTRL_RESERVED1_SHIFT 10
#define  DM_APP_GLOB_CLK_CTRL_RESERVED1_MASK_SHIFT(reg) (((reg) & DM_APP_GLOB_CLK_CTRL_RESERVED1_MASK) >> DM_APP_GLOB_CLK_CTRL_RESERVED1_SHIFT)
#define  DM_APP_GLOB_CLK_CTRL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_GLOB_CLK_CTRL_RESERVED1_MASK) | (((uint32_t)val) << DM_APP_GLOB_CLK_CTRL_RESERVED1_SHIFT))

#define  DM_APP_GLOB_CLK_CTRL_MODE_CORE_CLK_FREQ_SEL_MASK 0x200
#define  DM_APP_GLOB_CLK_CTRL_MODE_CORE_CLK_FREQ_SEL_SHIFT 9
#define  DM_APP_GLOB_CLK_CTRL_MODE_CORE_CLK_FREQ_SEL_MASK_SHIFT(reg) (((reg) & DM_APP_GLOB_CLK_CTRL_MODE_CORE_CLK_FREQ_SEL_MASK) >> DM_APP_GLOB_CLK_CTRL_MODE_CORE_CLK_FREQ_SEL_SHIFT)
#define  DM_APP_GLOB_CLK_CTRL_MODE_CORE_CLK_FREQ_SEL_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_GLOB_CLK_CTRL_MODE_CORE_CLK_FREQ_SEL_MASK) | (((uint32_t)val) << DM_APP_GLOB_CLK_CTRL_MODE_CORE_CLK_FREQ_SEL_SHIFT))

#define  DM_APP_GLOB_CLK_CTRL_PHY_RESET_MASK 0x100
#define  DM_APP_GLOB_CLK_CTRL_PHY_RESET_SHIFT 8
#define  DM_APP_GLOB_CLK_CTRL_PHY_RESET_MASK_SHIFT(reg) (((reg) & DM_APP_GLOB_CLK_CTRL_PHY_RESET_MASK) >> DM_APP_GLOB_CLK_CTRL_PHY_RESET_SHIFT)
#define  DM_APP_GLOB_CLK_CTRL_PHY_RESET_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_GLOB_CLK_CTRL_PHY_RESET_MASK) | (((uint32_t)val) << DM_APP_GLOB_CLK_CTRL_PHY_RESET_SHIFT))

#define  DM_APP_GLOB_CLK_CTRL_MODE_MULTICAST_MASK 0x80
#define  DM_APP_GLOB_CLK_CTRL_MODE_MULTICAST_SHIFT 7
#define  DM_APP_GLOB_CLK_CTRL_MODE_MULTICAST_MASK_SHIFT(reg) (((reg) & DM_APP_GLOB_CLK_CTRL_MODE_MULTICAST_MASK) >> DM_APP_GLOB_CLK_CTRL_MODE_MULTICAST_SHIFT)
#define  DM_APP_GLOB_CLK_CTRL_MODE_MULTICAST_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_GLOB_CLK_CTRL_MODE_MULTICAST_MASK) | (((uint32_t)val) << DM_APP_GLOB_CLK_CTRL_MODE_MULTICAST_SHIFT))

#define  DM_APP_GLOB_CLK_CTRL_MODE_CORE_CLK_CTRL_MASK 0x40
#define  DM_APP_GLOB_CLK_CTRL_MODE_CORE_CLK_CTRL_SHIFT 6
#define  DM_APP_GLOB_CLK_CTRL_MODE_CORE_CLK_CTRL_MASK_SHIFT(reg) (((reg) & DM_APP_GLOB_CLK_CTRL_MODE_CORE_CLK_CTRL_MASK) >> DM_APP_GLOB_CLK_CTRL_MODE_CORE_CLK_CTRL_SHIFT)
#define  DM_APP_GLOB_CLK_CTRL_MODE_CORE_CLK_CTRL_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_GLOB_CLK_CTRL_MODE_CORE_CLK_CTRL_MASK) | (((uint32_t)val) << DM_APP_GLOB_CLK_CTRL_MODE_CORE_CLK_CTRL_SHIFT))

#define  DM_APP_GLOB_CLK_CTRL_MODE_REFDIV_MASK 0x30
#define  DM_APP_GLOB_CLK_CTRL_MODE_REFDIV_SHIFT 4
#define  DM_APP_GLOB_CLK_CTRL_MODE_REFDIV_MASK_SHIFT(reg) (((reg) & DM_APP_GLOB_CLK_CTRL_MODE_REFDIV_MASK) >> DM_APP_GLOB_CLK_CTRL_MODE_REFDIV_SHIFT)
#define  DM_APP_GLOB_CLK_CTRL_MODE_REFDIV_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_GLOB_CLK_CTRL_MODE_REFDIV_MASK) | (((uint32_t)val) << DM_APP_GLOB_CLK_CTRL_MODE_REFDIV_SHIFT))

#define  DM_APP_GLOB_CLK_CTRL_MODE_PIPE_WIDTH_32_MASK 0x8
#define  DM_APP_GLOB_CLK_CTRL_MODE_PIPE_WIDTH_32_SHIFT 3
#define  DM_APP_GLOB_CLK_CTRL_MODE_PIPE_WIDTH_32_MASK_SHIFT(reg) (((reg) & DM_APP_GLOB_CLK_CTRL_MODE_PIPE_WIDTH_32_MASK) >> DM_APP_GLOB_CLK_CTRL_MODE_PIPE_WIDTH_32_SHIFT)
#define  DM_APP_GLOB_CLK_CTRL_MODE_PIPE_WIDTH_32_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_GLOB_CLK_CTRL_MODE_PIPE_WIDTH_32_MASK) | (((uint32_t)val) << DM_APP_GLOB_CLK_CTRL_MODE_PIPE_WIDTH_32_SHIFT))

#define  DM_APP_GLOB_CLK_CTRL_MODE_FIXED_PCLK_MASK 0x4
#define  DM_APP_GLOB_CLK_CTRL_MODE_FIXED_PCLK_SHIFT 2
#define  DM_APP_GLOB_CLK_CTRL_MODE_FIXED_PCLK_MASK_SHIFT(reg) (((reg) & DM_APP_GLOB_CLK_CTRL_MODE_FIXED_PCLK_MASK) >> DM_APP_GLOB_CLK_CTRL_MODE_FIXED_PCLK_SHIFT)
#define  DM_APP_GLOB_CLK_CTRL_MODE_FIXED_PCLK_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_GLOB_CLK_CTRL_MODE_FIXED_PCLK_MASK) | (((uint32_t)val) << DM_APP_GLOB_CLK_CTRL_MODE_FIXED_PCLK_SHIFT))

#define  DM_APP_GLOB_CLK_CTRL_REG_RESET_MASK 0x2
#define  DM_APP_GLOB_CLK_CTRL_REG_RESET_SHIFT 1
#define  DM_APP_GLOB_CLK_CTRL_REG_RESET_MASK_SHIFT(reg) (((reg) & DM_APP_GLOB_CLK_CTRL_REG_RESET_MASK) >> DM_APP_GLOB_CLK_CTRL_REG_RESET_SHIFT)
#define  DM_APP_GLOB_CLK_CTRL_REG_RESET_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_GLOB_CLK_CTRL_REG_RESET_MASK) | (((uint32_t)val) << DM_APP_GLOB_CLK_CTRL_REG_RESET_SHIFT))

#define  DM_APP_GLOB_CLK_CTRL_SOFT_RESET_MASK 0x1
#define  DM_APP_GLOB_CLK_CTRL_SOFT_RESET_SHIFT 0
#define  DM_APP_GLOB_CLK_CTRL_SOFT_RESET_MASK_SHIFT(reg) (((reg) & DM_APP_GLOB_CLK_CTRL_SOFT_RESET_MASK) >> DM_APP_GLOB_CLK_CTRL_SOFT_RESET_SHIFT)
#define  DM_APP_GLOB_CLK_CTRL_SOFT_RESET_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_GLOB_CLK_CTRL_SOFT_RESET_MASK) | (((uint32_t)val) << DM_APP_GLOB_CLK_CTRL_SOFT_RESET_SHIFT))

//====================================================================
//Register: Global Test Control (GLOB_TEST_CTRL)
/** \brief Address Offset 0x1C2 * 4 = 0x708*/
//====================================================================

#define  DM_APP_GLOB_TEST_CTRL_RESERVED1_MASK 0xffffc000
#define  DM_APP_GLOB_TEST_CTRL_RESERVED1_SHIFT 14
#define  DM_APP_GLOB_TEST_CTRL_RESERVED1_MASK_SHIFT(reg) (((reg) & DM_APP_GLOB_TEST_CTRL_RESERVED1_MASK) >> DM_APP_GLOB_TEST_CTRL_RESERVED1_SHIFT)
#define  DM_APP_GLOB_TEST_CTRL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_GLOB_TEST_CTRL_RESERVED1_MASK) | (((uint32_t)val) << DM_APP_GLOB_TEST_CTRL_RESERVED1_SHIFT))

#define  DM_APP_GLOB_TEST_CTRL_MODE_RST_OVERRIDE_MASK 0x2000
#define  DM_APP_GLOB_TEST_CTRL_MODE_RST_OVERRIDE_SHIFT 13
#define  DM_APP_GLOB_TEST_CTRL_MODE_RST_OVERRIDE_MASK_SHIFT(reg) (((reg) & DM_APP_GLOB_TEST_CTRL_MODE_RST_OVERRIDE_MASK) >> DM_APP_GLOB_TEST_CTRL_MODE_RST_OVERRIDE_SHIFT)
#define  DM_APP_GLOB_TEST_CTRL_MODE_RST_OVERRIDE_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_GLOB_TEST_CTRL_MODE_RST_OVERRIDE_MASK) | (((uint32_t)val) << DM_APP_GLOB_TEST_CTRL_MODE_RST_OVERRIDE_SHIFT))

#define  DM_APP_GLOB_TEST_CTRL_MODE_LB_SERDES_MASK 0x1000
#define  DM_APP_GLOB_TEST_CTRL_MODE_LB_SERDES_SHIFT 12
#define  DM_APP_GLOB_TEST_CTRL_MODE_LB_SERDES_MASK_SHIFT(reg) (((reg) & DM_APP_GLOB_TEST_CTRL_MODE_LB_SERDES_MASK) >> DM_APP_GLOB_TEST_CTRL_MODE_LB_SERDES_SHIFT)
#define  DM_APP_GLOB_TEST_CTRL_MODE_LB_SERDES_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_GLOB_TEST_CTRL_MODE_LB_SERDES_MASK) | (((uint32_t)val) << DM_APP_GLOB_TEST_CTRL_MODE_LB_SERDES_SHIFT))

#define  DM_APP_GLOB_TEST_CTRL_MODE_LB_DEEP_MASK 0x800
#define  DM_APP_GLOB_TEST_CTRL_MODE_LB_DEEP_SHIFT 11
#define  DM_APP_GLOB_TEST_CTRL_MODE_LB_DEEP_MASK_SHIFT(reg) (((reg) & DM_APP_GLOB_TEST_CTRL_MODE_LB_DEEP_MASK) >> DM_APP_GLOB_TEST_CTRL_MODE_LB_DEEP_SHIFT)
#define  DM_APP_GLOB_TEST_CTRL_MODE_LB_DEEP_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_GLOB_TEST_CTRL_MODE_LB_DEEP_MASK) | (((uint32_t)val) << DM_APP_GLOB_TEST_CTRL_MODE_LB_DEEP_SHIFT))

#define  DM_APP_GLOB_TEST_CTRL_MODE_LB_SHALLOW_MASK 0x400
#define  DM_APP_GLOB_TEST_CTRL_MODE_LB_SHALLOW_SHIFT 10
#define  DM_APP_GLOB_TEST_CTRL_MODE_LB_SHALLOW_MASK_SHIFT(reg) (((reg) & DM_APP_GLOB_TEST_CTRL_MODE_LB_SHALLOW_MASK) >> DM_APP_GLOB_TEST_CTRL_MODE_LB_SHALLOW_SHIFT)
#define  DM_APP_GLOB_TEST_CTRL_MODE_LB_SHALLOW_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_GLOB_TEST_CTRL_MODE_LB_SHALLOW_MASK) | (((uint32_t)val) << DM_APP_GLOB_TEST_CTRL_MODE_LB_SHALLOW_SHIFT))

#define  DM_APP_GLOB_TEST_CTRL_RESERVED2_MASK 0x200
#define  DM_APP_GLOB_TEST_CTRL_RESERVED2_SHIFT 9
#define  DM_APP_GLOB_TEST_CTRL_RESERVED2_MASK_SHIFT(reg) (((reg) & DM_APP_GLOB_TEST_CTRL_RESERVED2_MASK) >> DM_APP_GLOB_TEST_CTRL_RESERVED2_SHIFT)
#define  DM_APP_GLOB_TEST_CTRL_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_GLOB_TEST_CTRL_RESERVED2_MASK) | (((uint32_t)val) << DM_APP_GLOB_TEST_CTRL_RESERVED2_SHIFT))

#define  DM_APP_GLOB_TEST_CTRL_DBG_TESTBUS_SEL_MASK 0x1f8
#define  DM_APP_GLOB_TEST_CTRL_DBG_TESTBUS_SEL_SHIFT 3
#define  DM_APP_GLOB_TEST_CTRL_DBG_TESTBUS_SEL_MASK_SHIFT(reg) (((reg) & DM_APP_GLOB_TEST_CTRL_DBG_TESTBUS_SEL_MASK) >> DM_APP_GLOB_TEST_CTRL_DBG_TESTBUS_SEL_SHIFT)
#define  DM_APP_GLOB_TEST_CTRL_DBG_TESTBUS_SEL_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_GLOB_TEST_CTRL_DBG_TESTBUS_SEL_MASK) | (((uint32_t)val) << DM_APP_GLOB_TEST_CTRL_DBG_TESTBUS_SEL_SHIFT))

#define  DM_APP_GLOB_TEST_CTRL_MODE_MARGIN_OVERRIDE_MASK 0x4
#define  DM_APP_GLOB_TEST_CTRL_MODE_MARGIN_OVERRIDE_SHIFT 2
#define  DM_APP_GLOB_TEST_CTRL_MODE_MARGIN_OVERRIDE_MASK_SHIFT(reg) (((reg) & DM_APP_GLOB_TEST_CTRL_MODE_MARGIN_OVERRIDE_MASK) >> DM_APP_GLOB_TEST_CTRL_MODE_MARGIN_OVERRIDE_SHIFT)
#define  DM_APP_GLOB_TEST_CTRL_MODE_MARGIN_OVERRIDE_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_GLOB_TEST_CTRL_MODE_MARGIN_OVERRIDE_MASK) | (((uint32_t)val) << DM_APP_GLOB_TEST_CTRL_MODE_MARGIN_OVERRIDE_SHIFT))

#define  DM_APP_GLOB_TEST_CTRL_MODE_PM_OVERRIDE_MASK 0x2
#define  DM_APP_GLOB_TEST_CTRL_MODE_PM_OVERRIDE_SHIFT 1
#define  DM_APP_GLOB_TEST_CTRL_MODE_PM_OVERRIDE_MASK_SHIFT(reg) (((reg) & DM_APP_GLOB_TEST_CTRL_MODE_PM_OVERRIDE_MASK) >> DM_APP_GLOB_TEST_CTRL_MODE_PM_OVERRIDE_SHIFT)
#define  DM_APP_GLOB_TEST_CTRL_MODE_PM_OVERRIDE_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_GLOB_TEST_CTRL_MODE_PM_OVERRIDE_MASK) | (((uint32_t)val) << DM_APP_GLOB_TEST_CTRL_MODE_PM_OVERRIDE_SHIFT))

#define  DM_APP_GLOB_TEST_CTRL_MODE_BIST_MASK 0x1
#define  DM_APP_GLOB_TEST_CTRL_MODE_BIST_SHIFT 0
#define  DM_APP_GLOB_TEST_CTRL_MODE_BIST_MASK_SHIFT(reg) (((reg) & DM_APP_GLOB_TEST_CTRL_MODE_BIST_MASK) >> DM_APP_GLOB_TEST_CTRL_MODE_BIST_SHIFT)
#define  DM_APP_GLOB_TEST_CTRL_MODE_BIST_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_GLOB_TEST_CTRL_MODE_BIST_MASK) | (((uint32_t)val) << DM_APP_GLOB_TEST_CTRL_MODE_BIST_SHIFT))

//====================================================================
//Register: Clock Source Low (GLOB_CLK_SRC_LO)
/** \brief Address Offset 0x1C3 * 4 = 0x70C*/
//====================================================================

#define  DM_APP_GLOB_CLK_SRC_LO_RESERVED1_MASK 0xffffff80
#define  DM_APP_GLOB_CLK_SRC_LO_RESERVED1_SHIFT 7
#define  DM_APP_GLOB_CLK_SRC_LO_RESERVED1_MASK_SHIFT(reg) (((reg) & DM_APP_GLOB_CLK_SRC_LO_RESERVED1_MASK) >> DM_APP_GLOB_CLK_SRC_LO_RESERVED1_SHIFT)
#define  DM_APP_GLOB_CLK_SRC_LO_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_GLOB_CLK_SRC_LO_RESERVED1_MASK) | (((uint32_t)val) << DM_APP_GLOB_CLK_SRC_LO_RESERVED1_SHIFT))

#define  DM_APP_GLOB_CLK_SRC_LO_PLL_READY_DLY_MASK 0x70
#define  DM_APP_GLOB_CLK_SRC_LO_PLL_READY_DLY_SHIFT 4
#define  DM_APP_GLOB_CLK_SRC_LO_PLL_READY_DLY_MASK_SHIFT(reg) (((reg) & DM_APP_GLOB_CLK_SRC_LO_PLL_READY_DLY_MASK) >> DM_APP_GLOB_CLK_SRC_LO_PLL_READY_DLY_SHIFT)
#define  DM_APP_GLOB_CLK_SRC_LO_PLL_READY_DLY_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_GLOB_CLK_SRC_LO_PLL_READY_DLY_MASK) | (((uint32_t)val) << DM_APP_GLOB_CLK_SRC_LO_PLL_READY_DLY_SHIFT))

#define  DM_APP_GLOB_CLK_SRC_LO_BUNDLE_PERIOD_SCALE_MASK 0xc
#define  DM_APP_GLOB_CLK_SRC_LO_BUNDLE_PERIOD_SCALE_SHIFT 2
#define  DM_APP_GLOB_CLK_SRC_LO_BUNDLE_PERIOD_SCALE_MASK_SHIFT(reg) (((reg) & DM_APP_GLOB_CLK_SRC_LO_BUNDLE_PERIOD_SCALE_MASK) >> DM_APP_GLOB_CLK_SRC_LO_BUNDLE_PERIOD_SCALE_SHIFT)
#define  DM_APP_GLOB_CLK_SRC_LO_BUNDLE_PERIOD_SCALE_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_GLOB_CLK_SRC_LO_BUNDLE_PERIOD_SCALE_MASK) | (((uint32_t)val) << DM_APP_GLOB_CLK_SRC_LO_BUNDLE_PERIOD_SCALE_SHIFT))

#define  DM_APP_GLOB_CLK_SRC_LO_BUNDLE_PERIOD_SEL_MASK 0x2
#define  DM_APP_GLOB_CLK_SRC_LO_BUNDLE_PERIOD_SEL_SHIFT 1
#define  DM_APP_GLOB_CLK_SRC_LO_BUNDLE_PERIOD_SEL_MASK_SHIFT(reg) (((reg) & DM_APP_GLOB_CLK_SRC_LO_BUNDLE_PERIOD_SEL_MASK) >> DM_APP_GLOB_CLK_SRC_LO_BUNDLE_PERIOD_SEL_SHIFT)
#define  DM_APP_GLOB_CLK_SRC_LO_BUNDLE_PERIOD_SEL_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_GLOB_CLK_SRC_LO_BUNDLE_PERIOD_SEL_MASK) | (((uint32_t)val) << DM_APP_GLOB_CLK_SRC_LO_BUNDLE_PERIOD_SEL_SHIFT))

#define  DM_APP_GLOB_CLK_SRC_LO_MODE_CLK_SRC_MASK 0x1
#define  DM_APP_GLOB_CLK_SRC_LO_MODE_CLK_SRC_SHIFT 0
#define  DM_APP_GLOB_CLK_SRC_LO_MODE_CLK_SRC_MASK_SHIFT(reg) (((reg) & DM_APP_GLOB_CLK_SRC_LO_MODE_CLK_SRC_MASK) >> DM_APP_GLOB_CLK_SRC_LO_MODE_CLK_SRC_SHIFT)
#define  DM_APP_GLOB_CLK_SRC_LO_MODE_CLK_SRC_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_GLOB_CLK_SRC_LO_MODE_CLK_SRC_MASK) | (((uint32_t)val) << DM_APP_GLOB_CLK_SRC_LO_MODE_CLK_SRC_SHIFT))

//====================================================================
//Register: Clock Source High (GLOB_CLK_SRC_HI)
/** \brief Controls how the PHY lanes are partitioned into links<BR>
    Must first program the lane number register, DM Application PHY Lane Number, offset 0x11000<BR>
    Address Offset 0x1C4 * 4 = 0x710*/
//====================================================================

#define  DM_APP_GLOB_CLK_SRC_HI_RESERVED1_MASK 0xfffffff8
#define  DM_APP_GLOB_CLK_SRC_HI_RESERVED1_SHIFT 3
#define  DM_APP_GLOB_CLK_SRC_HI_RESERVED1_MASK_SHIFT(reg) (((reg) & DM_APP_GLOB_CLK_SRC_HI_RESERVED1_MASK) >> DM_APP_GLOB_CLK_SRC_HI_RESERVED1_SHIFT)
#define  DM_APP_GLOB_CLK_SRC_HI_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_GLOB_CLK_SRC_HI_RESERVED1_MASK) | (((uint32_t)val) << DM_APP_GLOB_CLK_SRC_HI_RESERVED1_SHIFT))

#define  DM_APP_GLOB_CLK_SRC_HI_LANE_MASTER_MASK 0x4
#define  DM_APP_GLOB_CLK_SRC_HI_LANE_MASTER_SHIFT 2
#define  DM_APP_GLOB_CLK_SRC_HI_LANE_MASTER_MASK_SHIFT(reg) (((reg) & DM_APP_GLOB_CLK_SRC_HI_LANE_MASTER_MASK) >> DM_APP_GLOB_CLK_SRC_HI_LANE_MASTER_SHIFT)
#define  DM_APP_GLOB_CLK_SRC_HI_LANE_MASTER_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_GLOB_CLK_SRC_HI_LANE_MASTER_MASK) | (((uint32_t)val) << DM_APP_GLOB_CLK_SRC_HI_LANE_MASTER_SHIFT))

#define  DM_APP_GLOB_CLK_SRC_HI_LANE_BREAK_MASK 0x2
#define  DM_APP_GLOB_CLK_SRC_HI_LANE_BREAK_SHIFT 1
#define  DM_APP_GLOB_CLK_SRC_HI_LANE_BREAK_MASK_SHIFT(reg) (((reg) & DM_APP_GLOB_CLK_SRC_HI_LANE_BREAK_MASK) >> DM_APP_GLOB_CLK_SRC_HI_LANE_BREAK_SHIFT)
#define  DM_APP_GLOB_CLK_SRC_HI_LANE_BREAK_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_GLOB_CLK_SRC_HI_LANE_BREAK_MASK) | (((uint32_t)val) << DM_APP_GLOB_CLK_SRC_HI_LANE_BREAK_SHIFT))

#define  DM_APP_GLOB_CLK_SRC_HI_LANE_START_MASK 0x1
#define  DM_APP_GLOB_CLK_SRC_HI_LANE_START_SHIFT 0
#define  DM_APP_GLOB_CLK_SRC_HI_LANE_START_MASK_SHIFT(reg) (((reg) & DM_APP_GLOB_CLK_SRC_HI_LANE_START_MASK) >> DM_APP_GLOB_CLK_SRC_HI_LANE_START_SHIFT)
#define  DM_APP_GLOB_CLK_SRC_HI_LANE_START_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_GLOB_CLK_SRC_HI_LANE_START_MASK) | (((uint32_t)val) << DM_APP_GLOB_CLK_SRC_HI_LANE_START_SHIFT))

//====================================================================
//Register: Global Trigger (GLOB_TRIGGER)
/** \brief Used to generate various trigger pulses.<BR>
    See PCI-E MAC/PHY Integration Document for bit details<BR>
    Address Offset 0x1C5 * 4 = 0x714*/
//====================================================================

#define  DM_APP_GLOB_TRIGGER_RESERVED1_MASK 0xffff0000
#define  DM_APP_GLOB_TRIGGER_RESERVED1_SHIFT 16
#define  DM_APP_GLOB_TRIGGER_RESERVED1_MASK_SHIFT(reg) (((reg) & DM_APP_GLOB_TRIGGER_RESERVED1_MASK) >> DM_APP_GLOB_TRIGGER_RESERVED1_SHIFT)
#define  DM_APP_GLOB_TRIGGER_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_GLOB_TRIGGER_RESERVED1_MASK) | (((uint32_t)val) << DM_APP_GLOB_TRIGGER_RESERVED1_SHIFT))

#define  DM_APP_GLOB_TRIGGER_DATA_MASK 0xffff
#define  DM_APP_GLOB_TRIGGER_DATA_SHIFT 0
#define  DM_APP_GLOB_TRIGGER_DATA_MASK_SHIFT(reg) (((reg) & DM_APP_GLOB_TRIGGER_DATA_MASK) >> DM_APP_GLOB_TRIGGER_DATA_SHIFT)
#define  DM_APP_GLOB_TRIGGER_DATA_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_GLOB_TRIGGER_DATA_MASK) | (((uint32_t)val) << DM_APP_GLOB_TRIGGER_DATA_SHIFT))

//====================================================================
//Register: Global Miscellaneous Control (GLOB_MISC_CTRL)
/** \brief Used to generate various Phy parameters, including actions during P1 substates and P2.<BR>
    See PCI-E MAC/PHY Integration Document for bit details<BR>
    Address Offset 0x1C6 * 4 = 0x718*/
//====================================================================

#define  DM_APP_GLOB_MISC_CTRL_RESERVED1_MASK 0xffff0000
#define  DM_APP_GLOB_MISC_CTRL_RESERVED1_SHIFT 16
#define  DM_APP_GLOB_MISC_CTRL_RESERVED1_MASK_SHIFT(reg) (((reg) & DM_APP_GLOB_MISC_CTRL_RESERVED1_MASK) >> DM_APP_GLOB_MISC_CTRL_RESERVED1_SHIFT)
#define  DM_APP_GLOB_MISC_CTRL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_GLOB_MISC_CTRL_RESERVED1_MASK) | (((uint32_t)val) << DM_APP_GLOB_MISC_CTRL_RESERVED1_SHIFT))

#define  DM_APP_GLOB_MISC_CTRL_CFG_CLK_ACK_TIMER_EN_MASK 0x8000
#define  DM_APP_GLOB_MISC_CTRL_CFG_CLK_ACK_TIMER_EN_SHIFT 15
#define  DM_APP_GLOB_MISC_CTRL_CFG_CLK_ACK_TIMER_EN_MASK_SHIFT(reg) (((reg) & DM_APP_GLOB_MISC_CTRL_CFG_CLK_ACK_TIMER_EN_MASK) >> DM_APP_GLOB_MISC_CTRL_CFG_CLK_ACK_TIMER_EN_SHIFT)
#define  DM_APP_GLOB_MISC_CTRL_CFG_CLK_ACK_TIMER_EN_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_GLOB_MISC_CTRL_CFG_CLK_ACK_TIMER_EN_MASK) | (((uint32_t)val) << DM_APP_GLOB_MISC_CTRL_CFG_CLK_ACK_TIMER_EN_SHIFT))

#define  DM_APP_GLOB_MISC_CTRL_CFG_REFCLK_DET_TYPE_MASK 0x4000
#define  DM_APP_GLOB_MISC_CTRL_CFG_REFCLK_DET_TYPE_SHIFT 14
#define  DM_APP_GLOB_MISC_CTRL_CFG_REFCLK_DET_TYPE_MASK_SHIFT(reg) (((reg) & DM_APP_GLOB_MISC_CTRL_CFG_REFCLK_DET_TYPE_MASK) >> DM_APP_GLOB_MISC_CTRL_CFG_REFCLK_DET_TYPE_SHIFT)
#define  DM_APP_GLOB_MISC_CTRL_CFG_REFCLK_DET_TYPE_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_GLOB_MISC_CTRL_CFG_REFCLK_DET_TYPE_MASK) | (((uint32_t)val) << DM_APP_GLOB_MISC_CTRL_CFG_REFCLK_DET_TYPE_SHIFT))

#define  DM_APP_GLOB_MISC_CTRL_MODE_REFCLK_DIS_MASK 0x2000
#define  DM_APP_GLOB_MISC_CTRL_MODE_REFCLK_DIS_SHIFT 13
#define  DM_APP_GLOB_MISC_CTRL_MODE_REFCLK_DIS_MASK_SHIFT(reg) (((reg) & DM_APP_GLOB_MISC_CTRL_MODE_REFCLK_DIS_MASK) >> DM_APP_GLOB_MISC_CTRL_MODE_REFCLK_DIS_SHIFT)
#define  DM_APP_GLOB_MISC_CTRL_MODE_REFCLK_DIS_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_GLOB_MISC_CTRL_MODE_REFCLK_DIS_MASK) | (((uint32_t)val) << DM_APP_GLOB_MISC_CTRL_MODE_REFCLK_DIS_SHIFT))

#define  DM_APP_GLOB_MISC_CTRL_CFG_FREE_OSC_SEL_MASK 0x1000
#define  DM_APP_GLOB_MISC_CTRL_CFG_FREE_OSC_SEL_SHIFT 12
#define  DM_APP_GLOB_MISC_CTRL_CFG_FREE_OSC_SEL_MASK_SHIFT(reg) (((reg) & DM_APP_GLOB_MISC_CTRL_CFG_FREE_OSC_SEL_MASK) >> DM_APP_GLOB_MISC_CTRL_CFG_FREE_OSC_SEL_SHIFT)
#define  DM_APP_GLOB_MISC_CTRL_CFG_FREE_OSC_SEL_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_GLOB_MISC_CTRL_CFG_FREE_OSC_SEL_MASK) | (((uint32_t)val) << DM_APP_GLOB_MISC_CTRL_CFG_FREE_OSC_SEL_SHIFT))

#define  DM_APP_GLOB_MISC_CTRL_RCB_RXEN_SRC_MASK 0x800
#define  DM_APP_GLOB_MISC_CTRL_RCB_RXEN_SRC_SHIFT 11
#define  DM_APP_GLOB_MISC_CTRL_RCB_RXEN_SRC_MASK_SHIFT(reg) (((reg) & DM_APP_GLOB_MISC_CTRL_RCB_RXEN_SRC_MASK) >> DM_APP_GLOB_MISC_CTRL_RCB_RXEN_SRC_SHIFT)
#define  DM_APP_GLOB_MISC_CTRL_RCB_RXEN_SRC_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_GLOB_MISC_CTRL_RCB_RXEN_SRC_MASK) | (((uint32_t)val) << DM_APP_GLOB_MISC_CTRL_RCB_RXEN_SRC_SHIFT))

#define  DM_APP_GLOB_MISC_CTRL_OSC_COUNT_SCALE_MASK 0x700
#define  DM_APP_GLOB_MISC_CTRL_OSC_COUNT_SCALE_SHIFT 8
#define  DM_APP_GLOB_MISC_CTRL_OSC_COUNT_SCALE_MASK_SHIFT(reg) (((reg) & DM_APP_GLOB_MISC_CTRL_OSC_COUNT_SCALE_MASK) >> DM_APP_GLOB_MISC_CTRL_OSC_COUNT_SCALE_SHIFT)
#define  DM_APP_GLOB_MISC_CTRL_OSC_COUNT_SCALE_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_GLOB_MISC_CTRL_OSC_COUNT_SCALE_MASK) | (((uint32_t)val) << DM_APP_GLOB_MISC_CTRL_OSC_COUNT_SCALE_SHIFT))

#define  DM_APP_GLOB_MISC_CTRL_MODE_P1_OFF_MASK 0x80
#define  DM_APP_GLOB_MISC_CTRL_MODE_P1_OFF_SHIFT 7
#define  DM_APP_GLOB_MISC_CTRL_MODE_P1_OFF_MASK_SHIFT(reg) (((reg) & DM_APP_GLOB_MISC_CTRL_MODE_P1_OFF_MASK) >> DM_APP_GLOB_MISC_CTRL_MODE_P1_OFF_SHIFT)
#define  DM_APP_GLOB_MISC_CTRL_MODE_P1_OFF_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_GLOB_MISC_CTRL_MODE_P1_OFF_MASK) | (((uint32_t)val) << DM_APP_GLOB_MISC_CTRL_MODE_P1_OFF_SHIFT))

#define  DM_APP_GLOB_MISC_CTRL_MODE_P1_SNOOZ_MASK 0x40
#define  DM_APP_GLOB_MISC_CTRL_MODE_P1_SNOOZ_SHIFT 6
#define  DM_APP_GLOB_MISC_CTRL_MODE_P1_SNOOZ_MASK_SHIFT(reg) (((reg) & DM_APP_GLOB_MISC_CTRL_MODE_P1_SNOOZ_MASK) >> DM_APP_GLOB_MISC_CTRL_MODE_P1_SNOOZ_SHIFT)
#define  DM_APP_GLOB_MISC_CTRL_MODE_P1_SNOOZ_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_GLOB_MISC_CTRL_MODE_P1_SNOOZ_MASK) | (((uint32_t)val) << DM_APP_GLOB_MISC_CTRL_MODE_P1_SNOOZ_SHIFT))

#define  DM_APP_GLOB_MISC_CTRL_CFG_RX_HIZ_SRC_MASK 0x20
#define  DM_APP_GLOB_MISC_CTRL_CFG_RX_HIZ_SRC_SHIFT 5
#define  DM_APP_GLOB_MISC_CTRL_CFG_RX_HIZ_SRC_MASK_SHIFT(reg) (((reg) & DM_APP_GLOB_MISC_CTRL_CFG_RX_HIZ_SRC_MASK) >> DM_APP_GLOB_MISC_CTRL_CFG_RX_HIZ_SRC_SHIFT)
#define  DM_APP_GLOB_MISC_CTRL_CFG_RX_HIZ_SRC_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_GLOB_MISC_CTRL_CFG_RX_HIZ_SRC_MASK) | (((uint32_t)val) << DM_APP_GLOB_MISC_CTRL_CFG_RX_HIZ_SRC_SHIFT))

#define  DM_APP_GLOB_MISC_CTRL_SQ_DETECT_OVERRIDE_MASK 0x10
#define  DM_APP_GLOB_MISC_CTRL_SQ_DETECT_OVERRIDE_SHIFT 4
#define  DM_APP_GLOB_MISC_CTRL_SQ_DETECT_OVERRIDE_MASK_SHIFT(reg) (((reg) & DM_APP_GLOB_MISC_CTRL_SQ_DETECT_OVERRIDE_MASK) >> DM_APP_GLOB_MISC_CTRL_SQ_DETECT_OVERRIDE_SHIFT)
#define  DM_APP_GLOB_MISC_CTRL_SQ_DETECT_OVERRIDE_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_GLOB_MISC_CTRL_SQ_DETECT_OVERRIDE_MASK) | (((uint32_t)val) << DM_APP_GLOB_MISC_CTRL_SQ_DETECT_OVERRIDE_SHIFT))

#define  DM_APP_GLOB_MISC_CTRL_SQ_DETECT_SRC_MASK 0x8
#define  DM_APP_GLOB_MISC_CTRL_SQ_DETECT_SRC_SHIFT 3
#define  DM_APP_GLOB_MISC_CTRL_SQ_DETECT_SRC_MASK_SHIFT(reg) (((reg) & DM_APP_GLOB_MISC_CTRL_SQ_DETECT_SRC_MASK) >> DM_APP_GLOB_MISC_CTRL_SQ_DETECT_SRC_SHIFT)
#define  DM_APP_GLOB_MISC_CTRL_SQ_DETECT_SRC_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_GLOB_MISC_CTRL_SQ_DETECT_SRC_MASK) | (((uint32_t)val) << DM_APP_GLOB_MISC_CTRL_SQ_DETECT_SRC_SHIFT))

#define  DM_APP_GLOB_MISC_CTRL_MODE_PCLK_CTRL_MASK 0x4
#define  DM_APP_GLOB_MISC_CTRL_MODE_PCLK_CTRL_SHIFT 2
#define  DM_APP_GLOB_MISC_CTRL_MODE_PCLK_CTRL_MASK_SHIFT(reg) (((reg) & DM_APP_GLOB_MISC_CTRL_MODE_PCLK_CTRL_MASK) >> DM_APP_GLOB_MISC_CTRL_MODE_PCLK_CTRL_SHIFT)
#define  DM_APP_GLOB_MISC_CTRL_MODE_PCLK_CTRL_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_GLOB_MISC_CTRL_MODE_PCLK_CTRL_MASK) | (((uint32_t)val) << DM_APP_GLOB_MISC_CTRL_MODE_PCLK_CTRL_SHIFT))

#define  DM_APP_GLOB_MISC_CTRL_MODE_P2_PHYSTATUS_MASK 0x2
#define  DM_APP_GLOB_MISC_CTRL_MODE_P2_PHYSTATUS_SHIFT 1
#define  DM_APP_GLOB_MISC_CTRL_MODE_P2_PHYSTATUS_MASK_SHIFT(reg) (((reg) & DM_APP_GLOB_MISC_CTRL_MODE_P2_PHYSTATUS_MASK) >> DM_APP_GLOB_MISC_CTRL_MODE_P2_PHYSTATUS_SHIFT)
#define  DM_APP_GLOB_MISC_CTRL_MODE_P2_PHYSTATUS_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_GLOB_MISC_CTRL_MODE_P2_PHYSTATUS_MASK) | (((uint32_t)val) << DM_APP_GLOB_MISC_CTRL_MODE_P2_PHYSTATUS_SHIFT))

#define  DM_APP_GLOB_MISC_CTRL_MODE_P1_CLK_REQ_N_MASK 0x1
#define  DM_APP_GLOB_MISC_CTRL_MODE_P1_CLK_REQ_N_SHIFT 0
#define  DM_APP_GLOB_MISC_CTRL_MODE_P1_CLK_REQ_N_MASK_SHIFT(reg) (((reg) & DM_APP_GLOB_MISC_CTRL_MODE_P1_CLK_REQ_N_MASK) >> DM_APP_GLOB_MISC_CTRL_MODE_P1_CLK_REQ_N_SHIFT)
#define  DM_APP_GLOB_MISC_CTRL_MODE_P1_CLK_REQ_N_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_GLOB_MISC_CTRL_MODE_P1_CLK_REQ_N_MASK) | (((uint32_t)val) << DM_APP_GLOB_MISC_CTRL_MODE_P1_CLK_REQ_N_SHIFT))

//====================================================================
//Register: CLKREQ# Timing Control (GLOB_CLKREQ_CTRL)
/** \brief Used to set Phy parameters for the CLKREQ# states.<BR>
    See PCI-E MAC/PHY Integration Document for bit details<BR>
    Address Offset 0x1C7 * 4 = 0x71C*/
//====================================================================

#define  DM_APP_GLOB_CLKREQ_CTRL_RESERVED1_MASK 0xffff0000
#define  DM_APP_GLOB_CLKREQ_CTRL_RESERVED1_SHIFT 16
#define  DM_APP_GLOB_CLKREQ_CTRL_RESERVED1_MASK_SHIFT(reg) (((reg) & DM_APP_GLOB_CLKREQ_CTRL_RESERVED1_MASK) >> DM_APP_GLOB_CLKREQ_CTRL_RESERVED1_SHIFT)
#define  DM_APP_GLOB_CLKREQ_CTRL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_GLOB_CLKREQ_CTRL_RESERVED1_MASK) | (((uint32_t)val) << DM_APP_GLOB_CLKREQ_CTRL_RESERVED1_SHIFT))

#define  DM_APP_GLOB_CLKREQ_CTRL_DATA_MASK 0xffff
#define  DM_APP_GLOB_CLKREQ_CTRL_DATA_SHIFT 0
#define  DM_APP_GLOB_CLKREQ_CTRL_DATA_MASK_SHIFT(reg) (((reg) & DM_APP_GLOB_CLKREQ_CTRL_DATA_MASK) >> DM_APP_GLOB_CLKREQ_CTRL_DATA_SHIFT)
#define  DM_APP_GLOB_CLKREQ_CTRL_DATA_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_GLOB_CLKREQ_CTRL_DATA_MASK) | (((uint32_t)val) << DM_APP_GLOB_CLKREQ_CTRL_DATA_SHIFT))

//====================================================================
//Register: Datapath Configuration (GLOB_DP_CFG)
/** \brief Used to set various Phy parameters.<BR>
    See PCI-E MAC/PHY Integration Document for bit details<BR>
    Address Offset 0x1C8 * 4 = 0x720*/
//====================================================================

#define  DM_APP_GLOB_DP_CFG_RESERVED1_MASK 0xffffe000
#define  DM_APP_GLOB_DP_CFG_RESERVED1_SHIFT 13
#define  DM_APP_GLOB_DP_CFG_RESERVED1_MASK_SHIFT(reg) (((reg) & DM_APP_GLOB_DP_CFG_RESERVED1_MASK) >> DM_APP_GLOB_DP_CFG_RESERVED1_SHIFT)
#define  DM_APP_GLOB_DP_CFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_GLOB_DP_CFG_RESERVED1_MASK) | (((uint32_t)val) << DM_APP_GLOB_DP_CFG_RESERVED1_SHIFT))

#define  DM_APP_GLOB_DP_CFG_DATA_MASK 0x1fff
#define  DM_APP_GLOB_DP_CFG_DATA_SHIFT 0
#define  DM_APP_GLOB_DP_CFG_DATA_MASK_SHIFT(reg) (((reg) & DM_APP_GLOB_DP_CFG_DATA_MASK) >> DM_APP_GLOB_DP_CFG_DATA_SHIFT)
#define  DM_APP_GLOB_DP_CFG_DATA_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_GLOB_DP_CFG_DATA_MASK) | (((uint32_t)val) << DM_APP_GLOB_DP_CFG_DATA_SHIFT))

//====================================================================
//Register: Counter Type Register (GLOB_COUNTER_CTRL)
/** \brief Used to set various Phy parameters.<BR>
    See PCI-E MAC/PHY Integration Document for bit details<BR>
    Address Offset 0x1D2 * 4 = 0x748*/
//====================================================================

#define  DM_APP_GLOB_COUNTER_CTRL_RESERVED1_MASK 0xfffff000
#define  DM_APP_GLOB_COUNTER_CTRL_RESERVED1_SHIFT 12
#define  DM_APP_GLOB_COUNTER_CTRL_RESERVED1_MASK_SHIFT(reg) (((reg) & DM_APP_GLOB_COUNTER_CTRL_RESERVED1_MASK) >> DM_APP_GLOB_COUNTER_CTRL_RESERVED1_SHIFT)
#define  DM_APP_GLOB_COUNTER_CTRL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_GLOB_COUNTER_CTRL_RESERVED1_MASK) | (((uint32_t)val) << DM_APP_GLOB_COUNTER_CTRL_RESERVED1_SHIFT))

#define  DM_APP_GLOB_COUNTER_CTRL_COUNTER_TYPE_MASK 0xf00
#define  DM_APP_GLOB_COUNTER_CTRL_COUNTER_TYPE_SHIFT 8
#define  DM_APP_GLOB_COUNTER_CTRL_COUNTER_TYPE_MASK_SHIFT(reg) (((reg) & DM_APP_GLOB_COUNTER_CTRL_COUNTER_TYPE_MASK) >> DM_APP_GLOB_COUNTER_CTRL_COUNTER_TYPE_SHIFT)
#define  DM_APP_GLOB_COUNTER_CTRL_COUNTER_TYPE_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_GLOB_COUNTER_CTRL_COUNTER_TYPE_MASK) | (((uint32_t)val) << DM_APP_GLOB_COUNTER_CTRL_COUNTER_TYPE_SHIFT))

#define  DM_APP_GLOB_COUNTER_CTRL_RESERVED2_MASK 0xff
#define  DM_APP_GLOB_COUNTER_CTRL_RESERVED2_SHIFT 0
#define  DM_APP_GLOB_COUNTER_CTRL_RESERVED2_MASK_SHIFT(reg) (((reg) & DM_APP_GLOB_COUNTER_CTRL_RESERVED2_MASK) >> DM_APP_GLOB_COUNTER_CTRL_RESERVED2_SHIFT)
#define  DM_APP_GLOB_COUNTER_CTRL_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_GLOB_COUNTER_CTRL_RESERVED2_MASK) | (((uint32_t)val) << DM_APP_GLOB_COUNTER_CTRL_RESERVED2_SHIFT))

//====================================================================
//Register: Counter Low Register (GLOB_COUNTER_LOW)
/** \brief Used to set various Phy parameters.<BR>
    See PCI-E MAC/PHY Integration Document for bit details<BR>
    Address Offset 0x1D3 * 4 = 0x74C*/
//====================================================================

#define  DM_APP_GLOB_COUNTER_LOW_RESERVED1_MASK 0xffff0000
#define  DM_APP_GLOB_COUNTER_LOW_RESERVED1_SHIFT 16
#define  DM_APP_GLOB_COUNTER_LOW_RESERVED1_MASK_SHIFT(reg) (((reg) & DM_APP_GLOB_COUNTER_LOW_RESERVED1_MASK) >> DM_APP_GLOB_COUNTER_LOW_RESERVED1_SHIFT)
#define  DM_APP_GLOB_COUNTER_LOW_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_GLOB_COUNTER_LOW_RESERVED1_MASK) | (((uint32_t)val) << DM_APP_GLOB_COUNTER_LOW_RESERVED1_SHIFT))

#define  DM_APP_GLOB_COUNTER_LOW_DATA_MASK 0xffff
#define  DM_APP_GLOB_COUNTER_LOW_DATA_SHIFT 0
#define  DM_APP_GLOB_COUNTER_LOW_DATA_MASK_SHIFT(reg) (((reg) & DM_APP_GLOB_COUNTER_LOW_DATA_MASK) >> DM_APP_GLOB_COUNTER_LOW_DATA_SHIFT)
#define  DM_APP_GLOB_COUNTER_LOW_DATA_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_GLOB_COUNTER_LOW_DATA_MASK) | (((uint32_t)val) << DM_APP_GLOB_COUNTER_LOW_DATA_SHIFT))

//====================================================================
//Register: Counter High Register (GLOB_COUNTER_HI)
/** \brief Used to set various Phy parameters.<BR>
    See PCI-E MAC/PHY Integration Document for bit details<BR>
    Address Offset 0x1D4 * 4 = 0x750*/
//====================================================================

#define  DM_APP_GLOB_COUNTER_HI_RESERVED1_MASK 0xffff0000
#define  DM_APP_GLOB_COUNTER_HI_RESERVED1_SHIFT 16
#define  DM_APP_GLOB_COUNTER_HI_RESERVED1_MASK_SHIFT(reg) (((reg) & DM_APP_GLOB_COUNTER_HI_RESERVED1_MASK) >> DM_APP_GLOB_COUNTER_HI_RESERVED1_SHIFT)
#define  DM_APP_GLOB_COUNTER_HI_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_GLOB_COUNTER_HI_RESERVED1_MASK) | (((uint32_t)val) << DM_APP_GLOB_COUNTER_HI_RESERVED1_SHIFT))

#define  DM_APP_GLOB_COUNTER_HI_DATA_MASK 0xffff
#define  DM_APP_GLOB_COUNTER_HI_DATA_SHIFT 0
#define  DM_APP_GLOB_COUNTER_HI_DATA_MASK_SHIFT(reg) (((reg) & DM_APP_GLOB_COUNTER_HI_DATA_MASK) >> DM_APP_GLOB_COUNTER_HI_DATA_SHIFT)
#define  DM_APP_GLOB_COUNTER_HI_DATA_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_GLOB_COUNTER_HI_DATA_MASK) | (((uint32_t)val) << DM_APP_GLOB_COUNTER_HI_DATA_SHIFT))

//====================================================================
//Register: Low Frequency Configuration Register (GLOB_LOW_FREQ_CFG)
/** \brief Used to set various Phy parameters.<BR>
    See PCI-E MAC/PHY Integration Document for bit details<BR>
    Address Offset 0x1D7 * 4 = 0x75C*/
//====================================================================

#define  DM_APP_GLOB_LOW_FREQ_CFG_RESERVED1_MASK 0xffff0000
#define  DM_APP_GLOB_LOW_FREQ_CFG_RESERVED1_SHIFT 16
#define  DM_APP_GLOB_LOW_FREQ_CFG_RESERVED1_MASK_SHIFT(reg) (((reg) & DM_APP_GLOB_LOW_FREQ_CFG_RESERVED1_MASK) >> DM_APP_GLOB_LOW_FREQ_CFG_RESERVED1_SHIFT)
#define  DM_APP_GLOB_LOW_FREQ_CFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_GLOB_LOW_FREQ_CFG_RESERVED1_MASK) | (((uint32_t)val) << DM_APP_GLOB_LOW_FREQ_CFG_RESERVED1_SHIFT))

#define  DM_APP_GLOB_LOW_FREQ_CFG_DATA_MASK 0xffff
#define  DM_APP_GLOB_LOW_FREQ_CFG_DATA_SHIFT 0
#define  DM_APP_GLOB_LOW_FREQ_CFG_DATA_MASK_SHIFT(reg) (((reg) & DM_APP_GLOB_LOW_FREQ_CFG_DATA_MASK) >> DM_APP_GLOB_LOW_FREQ_CFG_DATA_SHIFT)
#define  DM_APP_GLOB_LOW_FREQ_CFG_DATA_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_GLOB_LOW_FREQ_CFG_DATA_MASK) | (((uint32_t)val) << DM_APP_GLOB_LOW_FREQ_CFG_DATA_SHIFT))

//====================================================================
//Register: Lane Configuration 0 (LANE_CFG0)
/** \brief Note: this is not a lane-specific register, just the first of 2 lane config registers.<BR>
    Used to set various Phy parameters.<BR>
    See PCI-E MAC/PHY Integration Document for bit details<BR>
    Address Offset 0x180 * 4 = 0x600*/
//====================================================================

#define  DM_APP_LANE_CFG0_RESERVED1_MASK 0xffff0000
#define  DM_APP_LANE_CFG0_RESERVED1_SHIFT 16
#define  DM_APP_LANE_CFG0_RESERVED1_MASK_SHIFT(reg) (((reg) & DM_APP_LANE_CFG0_RESERVED1_MASK) >> DM_APP_LANE_CFG0_RESERVED1_SHIFT)
#define  DM_APP_LANE_CFG0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_LANE_CFG0_RESERVED1_MASK) | (((uint32_t)val) << DM_APP_LANE_CFG0_RESERVED1_SHIFT))

#define  DM_APP_LANE_CFG0_DATA_MASK 0xffff
#define  DM_APP_LANE_CFG0_DATA_SHIFT 0
#define  DM_APP_LANE_CFG0_DATA_MASK_SHIFT(reg) (((reg) & DM_APP_LANE_CFG0_DATA_MASK) >> DM_APP_LANE_CFG0_DATA_SHIFT)
#define  DM_APP_LANE_CFG0_DATA_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_LANE_CFG0_DATA_MASK) | (((uint32_t)val) << DM_APP_LANE_CFG0_DATA_SHIFT))

//====================================================================
//Register: Lane Configuration 1 (LANE_CFG1)
/** \brief Note: this is not a lane-specific register, just the second of 2 lane config registers.<BR>
    Used to set various Phy parameters.<BR>
    See PCI-E MAC/PHY Integration Document for bit details<BR>
    Address Offset 0x181 * 4 = 0x604*/
//====================================================================

#define  DM_APP_LANE_CFG1_RESERVED1_MASK 0xffffff80
#define  DM_APP_LANE_CFG1_RESERVED1_SHIFT 7
#define  DM_APP_LANE_CFG1_RESERVED1_MASK_SHIFT(reg) (((reg) & DM_APP_LANE_CFG1_RESERVED1_MASK) >> DM_APP_LANE_CFG1_RESERVED1_SHIFT)
#define  DM_APP_LANE_CFG1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_LANE_CFG1_RESERVED1_MASK) | (((uint32_t)val) << DM_APP_LANE_CFG1_RESERVED1_SHIFT))

#define  DM_APP_LANE_CFG1_DATA_MASK 0x7f
#define  DM_APP_LANE_CFG1_DATA_SHIFT 0
#define  DM_APP_LANE_CFG1_DATA_MASK_SHIFT(reg) (((reg) & DM_APP_LANE_CFG1_DATA_MASK) >> DM_APP_LANE_CFG1_DATA_SHIFT)
#define  DM_APP_LANE_CFG1_DATA_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_LANE_CFG1_DATA_MASK) | (((uint32_t)val) << DM_APP_LANE_CFG1_DATA_SHIFT))

//====================================================================
//Register: Lane Status 0 (LANE_STATUS0)
/** \brief Note: this is not a lane-specific register, just the first of 3 lane status registers.<BR>
    Used to read various Phy parameters.<BR>
    See PCI-E MAC/PHY Integration Document for bit details<BR>
    Address Offset 0x182 * 4 = 0x608*/
//====================================================================

#define  DM_APP_LANE_STATUS0_RESERVED1_MASK 0xffff0000
#define  DM_APP_LANE_STATUS0_RESERVED1_SHIFT 16
#define  DM_APP_LANE_STATUS0_RESERVED1_MASK_SHIFT(reg) (((reg) & DM_APP_LANE_STATUS0_RESERVED1_MASK) >> DM_APP_LANE_STATUS0_RESERVED1_SHIFT)
#define  DM_APP_LANE_STATUS0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_LANE_STATUS0_RESERVED1_MASK) | (((uint32_t)val) << DM_APP_LANE_STATUS0_RESERVED1_SHIFT))

#define  DM_APP_LANE_STATUS0_DATA_MASK 0xffff
#define  DM_APP_LANE_STATUS0_DATA_SHIFT 0
#define  DM_APP_LANE_STATUS0_DATA_MASK_SHIFT(reg) (((reg) & DM_APP_LANE_STATUS0_DATA_MASK) >> DM_APP_LANE_STATUS0_DATA_SHIFT)
#define  DM_APP_LANE_STATUS0_DATA_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_LANE_STATUS0_DATA_MASK) | (((uint32_t)val) << DM_APP_LANE_STATUS0_DATA_SHIFT))

//====================================================================
//Register: Lane Status 1 (LANE_STATUS1)
/** \brief Note: this is not a lane-specific register, just the second of 3 lane status registers.<BR>
    Used to read various Phy parameters.<BR>
    See PCI-E MAC/PHY Integration Document for bit details<BR>
    Address Offset 0x183 * 4 = 0x60C*/
//====================================================================

#define  DM_APP_LANE_STATUS1_RESERVED1_MASK 0xffff0000
#define  DM_APP_LANE_STATUS1_RESERVED1_SHIFT 16
#define  DM_APP_LANE_STATUS1_RESERVED1_MASK_SHIFT(reg) (((reg) & DM_APP_LANE_STATUS1_RESERVED1_MASK) >> DM_APP_LANE_STATUS1_RESERVED1_SHIFT)
#define  DM_APP_LANE_STATUS1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_LANE_STATUS1_RESERVED1_MASK) | (((uint32_t)val) << DM_APP_LANE_STATUS1_RESERVED1_SHIFT))

#define  DM_APP_LANE_STATUS1_DATA_MASK 0xffff
#define  DM_APP_LANE_STATUS1_DATA_SHIFT 0
#define  DM_APP_LANE_STATUS1_DATA_MASK_SHIFT(reg) (((reg) & DM_APP_LANE_STATUS1_DATA_MASK) >> DM_APP_LANE_STATUS1_DATA_SHIFT)
#define  DM_APP_LANE_STATUS1_DATA_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_LANE_STATUS1_DATA_MASK) | (((uint32_t)val) << DM_APP_LANE_STATUS1_DATA_SHIFT))

//====================================================================
//Register: Lane Status 2 (LANE_STATUS2)
/** \brief Note: this is not a lane-specific register, just the third of 3 lane status registers.<BR>
    Used to read various Phy parameters.<BR>
    See PCI-E MAC/PHY Integration Document for bit details<BR>
    Address Offset 0x184 * 4 = 0x610*/
//====================================================================

#define  DM_APP_LANE_STATUS2_RESERVED1_MASK 0xffff0000
#define  DM_APP_LANE_STATUS2_RESERVED1_SHIFT 16
#define  DM_APP_LANE_STATUS2_RESERVED1_MASK_SHIFT(reg) (((reg) & DM_APP_LANE_STATUS2_RESERVED1_MASK) >> DM_APP_LANE_STATUS2_RESERVED1_SHIFT)
#define  DM_APP_LANE_STATUS2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_LANE_STATUS2_RESERVED1_MASK) | (((uint32_t)val) << DM_APP_LANE_STATUS2_RESERVED1_SHIFT))

#define  DM_APP_LANE_STATUS2_DATA_MASK 0xffff
#define  DM_APP_LANE_STATUS2_DATA_SHIFT 0
#define  DM_APP_LANE_STATUS2_DATA_MASK_SHIFT(reg) (((reg) & DM_APP_LANE_STATUS2_DATA_MASK) >> DM_APP_LANE_STATUS2_DATA_SHIFT)
#define  DM_APP_LANE_STATUS2_DATA_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_LANE_STATUS2_DATA_MASK) | (((uint32_t)val) << DM_APP_LANE_STATUS2_DATA_SHIFT))

//====================================================================
//Register: Lane Beacon Control (LANE_BEACON)
/** \brief Used to set various Phy parameters.<BR>
    See PCI-E MAC/PHY Integration Document for bit details<BR>
    Address Offset 0x185 * 4 = 0x614*/
//====================================================================

#define  DM_APP_LANE_BEACON_RESERVED1_MASK 0xffff0000
#define  DM_APP_LANE_BEACON_RESERVED1_SHIFT 16
#define  DM_APP_LANE_BEACON_RESERVED1_MASK_SHIFT(reg) (((reg) & DM_APP_LANE_BEACON_RESERVED1_MASK) >> DM_APP_LANE_BEACON_RESERVED1_SHIFT)
#define  DM_APP_LANE_BEACON_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_LANE_BEACON_RESERVED1_MASK) | (((uint32_t)val) << DM_APP_LANE_BEACON_RESERVED1_SHIFT))

#define  DM_APP_LANE_BEACON_DATA_MASK 0xffff
#define  DM_APP_LANE_BEACON_DATA_SHIFT 0
#define  DM_APP_LANE_BEACON_DATA_MASK_SHIFT(reg) (((reg) & DM_APP_LANE_BEACON_DATA_MASK) >> DM_APP_LANE_BEACON_DATA_SHIFT)
#define  DM_APP_LANE_BEACON_DATA_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_LANE_BEACON_DATA_MASK) | (((uint32_t)val) << DM_APP_LANE_BEACON_DATA_SHIFT))

//====================================================================
//Register: Lane TX Common Mode Configuration Register (LANE_TXCMN_CFG)
/** \brief Configures Tx Common Mode turn on<BR>
    Address Offset 0x18B * 4 = 0x62C*/
//====================================================================

#define  DM_APP_LANE_TXCMN_CFG_RESERVED1_MASK 0xffffffc0
#define  DM_APP_LANE_TXCMN_CFG_RESERVED1_SHIFT 6
#define  DM_APP_LANE_TXCMN_CFG_RESERVED1_MASK_SHIFT(reg) (((reg) & DM_APP_LANE_TXCMN_CFG_RESERVED1_MASK) >> DM_APP_LANE_TXCMN_CFG_RESERVED1_SHIFT)
#define  DM_APP_LANE_TXCMN_CFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_LANE_TXCMN_CFG_RESERVED1_MASK) | (((uint32_t)val) << DM_APP_LANE_TXCMN_CFG_RESERVED1_SHIFT))

#define  DM_APP_LANE_TXCMN_CFG_CFG_TXCMN_DIS_DLY_MASK 0x3f
#define  DM_APP_LANE_TXCMN_CFG_CFG_TXCMN_DIS_DLY_SHIFT 0
#define  DM_APP_LANE_TXCMN_CFG_CFG_TXCMN_DIS_DLY_MASK_SHIFT(reg) (((reg) & DM_APP_LANE_TXCMN_CFG_CFG_TXCMN_DIS_DLY_MASK) >> DM_APP_LANE_TXCMN_CFG_CFG_TXCMN_DIS_DLY_SHIFT)
#define  DM_APP_LANE_TXCMN_CFG_CFG_TXCMN_DIS_DLY_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_LANE_TXCMN_CFG_CFG_TXCMN_DIS_DLY_MASK) | (((uint32_t)val) << DM_APP_LANE_TXCMN_CFG_CFG_TXCMN_DIS_DLY_SHIFT))

//====================================================================
//Register: Lane Equalization Configuration 0 (LANE_EQ_CFG0)
/** \brief Used to set various Phy parameters.<BR>
    See PCI-E MAC/PHY Integration Document for bit details<BR>
    Address Offset 0x1A7 * 4 = 0x69C*/
//====================================================================

#define  DM_APP_LANE_EQ_CFG0_RESERVED1_MASK 0xffffe000
#define  DM_APP_LANE_EQ_CFG0_RESERVED1_SHIFT 13
#define  DM_APP_LANE_EQ_CFG0_RESERVED1_MASK_SHIFT(reg) (((reg) & DM_APP_LANE_EQ_CFG0_RESERVED1_MASK) >> DM_APP_LANE_EQ_CFG0_RESERVED1_SHIFT)
#define  DM_APP_LANE_EQ_CFG0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_LANE_EQ_CFG0_RESERVED1_MASK) | (((uint32_t)val) << DM_APP_LANE_EQ_CFG0_RESERVED1_SHIFT))

#define  DM_APP_LANE_EQ_CFG0_DATA_MASK 0x1fff
#define  DM_APP_LANE_EQ_CFG0_DATA_SHIFT 0
#define  DM_APP_LANE_EQ_CFG0_DATA_MASK_SHIFT(reg) (((reg) & DM_APP_LANE_EQ_CFG0_DATA_MASK) >> DM_APP_LANE_EQ_CFG0_DATA_SHIFT)
#define  DM_APP_LANE_EQ_CFG0_DATA_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_LANE_EQ_CFG0_DATA_MASK) | (((uint32_t)val) << DM_APP_LANE_EQ_CFG0_DATA_SHIFT))

//====================================================================
//Register: Chip ID (CID_REG0)
/** \brief Start of COMPHY-specific registers.<BR>
    Read COMPHY Chip ID.<BR>
    See Common PHY Control Registers Document for bit details<BR>
    Address Offset 0x00 * 4 = 0x00*/
//====================================================================

#define  DM_APP_CID_REG0_RESERVED1_MASK 0xffff0000
#define  DM_APP_CID_REG0_RESERVED1_SHIFT 16
#define  DM_APP_CID_REG0_RESERVED1_MASK_SHIFT(reg) (((reg) & DM_APP_CID_REG0_RESERVED1_MASK) >> DM_APP_CID_REG0_RESERVED1_SHIFT)
#define  DM_APP_CID_REG0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_CID_REG0_RESERVED1_MASK) | (((uint32_t)val) << DM_APP_CID_REG0_RESERVED1_SHIFT))

#define  DM_APP_CID_REG0_CHIP_ID_MASK 0xffff
#define  DM_APP_CID_REG0_CHIP_ID_SHIFT 0
#define  DM_APP_CID_REG0_CHIP_ID_MASK_SHIFT(reg) (((reg) & DM_APP_CID_REG0_CHIP_ID_MASK) >> DM_APP_CID_REG0_CHIP_ID_SHIFT)
#define  DM_APP_CID_REG0_CHIP_ID_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_CID_REG0_CHIP_ID_MASK) | (((uint32_t)val) << DM_APP_CID_REG0_CHIP_ID_SHIFT))

//====================================================================
//Register: Power and PLL Control Register (POWER_REG0)
/** \brief COMPHY-specific registers.<BR>
    Used to set various Phy parameters.<BR>
    See Common PHY Control Registers Document for further bit details<BR>
    Address Offset 0x01 * 4 = 0x04*/
//====================================================================

#define  DM_APP_POWER_REG0_RESERVED1_MASK 0xffff8000
#define  DM_APP_POWER_REG0_RESERVED1_SHIFT 15
#define  DM_APP_POWER_REG0_RESERVED1_MASK_SHIFT(reg) (((reg) & DM_APP_POWER_REG0_RESERVED1_MASK) >> DM_APP_POWER_REG0_RESERVED1_SHIFT)
#define  DM_APP_POWER_REG0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_POWER_REG0_RESERVED1_MASK) | (((uint32_t)val) << DM_APP_POWER_REG0_RESERVED1_SHIFT))

#define  DM_APP_POWER_REG0_PU_PLL_MASK 0x4000
#define  DM_APP_POWER_REG0_PU_PLL_SHIFT 14
#define  DM_APP_POWER_REG0_PU_PLL_MASK_SHIFT(reg) (((reg) & DM_APP_POWER_REG0_PU_PLL_MASK) >> DM_APP_POWER_REG0_PU_PLL_SHIFT)
#define  DM_APP_POWER_REG0_PU_PLL_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_POWER_REG0_PU_PLL_MASK) | (((uint32_t)val) << DM_APP_POWER_REG0_PU_PLL_SHIFT))

#define  DM_APP_POWER_REG0_PU_RX_MASK 0x2000
#define  DM_APP_POWER_REG0_PU_RX_SHIFT 13
#define  DM_APP_POWER_REG0_PU_RX_MASK_SHIFT(reg) (((reg) & DM_APP_POWER_REG0_PU_RX_MASK) >> DM_APP_POWER_REG0_PU_RX_SHIFT)
#define  DM_APP_POWER_REG0_PU_RX_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_POWER_REG0_PU_RX_MASK) | (((uint32_t)val) << DM_APP_POWER_REG0_PU_RX_SHIFT))

#define  DM_APP_POWER_REG0_PU_TX_MASK 0x1000
#define  DM_APP_POWER_REG0_PU_TX_SHIFT 12
#define  DM_APP_POWER_REG0_PU_TX_MASK_SHIFT(reg) (((reg) & DM_APP_POWER_REG0_PU_TX_MASK) >> DM_APP_POWER_REG0_PU_TX_SHIFT)
#define  DM_APP_POWER_REG0_PU_TX_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_POWER_REG0_PU_TX_MASK) | (((uint32_t)val) << DM_APP_POWER_REG0_PU_TX_SHIFT))

#define  DM_APP_POWER_REG0_RESERVED2_MASK 0x800
#define  DM_APP_POWER_REG0_RESERVED2_SHIFT 11
#define  DM_APP_POWER_REG0_RESERVED2_MASK_SHIFT(reg) (((reg) & DM_APP_POWER_REG0_RESERVED2_MASK) >> DM_APP_POWER_REG0_RESERVED2_SHIFT)
#define  DM_APP_POWER_REG0_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_POWER_REG0_RESERVED2_MASK) | (((uint32_t)val) << DM_APP_POWER_REG0_RESERVED2_SHIFT))

#define  DM_APP_POWER_REG0_PU_DFE_MASK 0x400
#define  DM_APP_POWER_REG0_PU_DFE_SHIFT 10
#define  DM_APP_POWER_REG0_PU_DFE_MASK_SHIFT(reg) (((reg) & DM_APP_POWER_REG0_PU_DFE_MASK) >> DM_APP_POWER_REG0_PU_DFE_SHIFT)
#define  DM_APP_POWER_REG0_PU_DFE_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_POWER_REG0_PU_DFE_MASK) | (((uint32_t)val) << DM_APP_POWER_REG0_PU_DFE_SHIFT))

#define  DM_APP_POWER_REG0_RESERVED3_MASK 0x200
#define  DM_APP_POWER_REG0_RESERVED3_SHIFT 9
#define  DM_APP_POWER_REG0_RESERVED3_MASK_SHIFT(reg) (((reg) & DM_APP_POWER_REG0_RESERVED3_MASK) >> DM_APP_POWER_REG0_RESERVED3_SHIFT)
#define  DM_APP_POWER_REG0_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_POWER_REG0_RESERVED3_MASK) | (((uint32_t)val) << DM_APP_POWER_REG0_RESERVED3_SHIFT))

#define  DM_APP_POWER_REG0_PLL_LOCK_MASK 0x100
#define  DM_APP_POWER_REG0_PLL_LOCK_SHIFT 8
#define  DM_APP_POWER_REG0_PLL_LOCK_MASK_SHIFT(reg) (((reg) & DM_APP_POWER_REG0_PLL_LOCK_MASK) >> DM_APP_POWER_REG0_PLL_LOCK_SHIFT)
#define  DM_APP_POWER_REG0_PLL_LOCK_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_POWER_REG0_PLL_LOCK_MASK) | (((uint32_t)val) << DM_APP_POWER_REG0_PLL_LOCK_SHIFT))

#define  DM_APP_POWER_REG0_PHY_MODE_MASK 0xe0
#define  DM_APP_POWER_REG0_PHY_MODE_SHIFT 5
#define  DM_APP_POWER_REG0_PHY_MODE_MASK_SHIFT(reg) (((reg) & DM_APP_POWER_REG0_PHY_MODE_MASK) >> DM_APP_POWER_REG0_PHY_MODE_SHIFT)
#define  DM_APP_POWER_REG0_PHY_MODE_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_POWER_REG0_PHY_MODE_MASK) | (((uint32_t)val) << DM_APP_POWER_REG0_PHY_MODE_SHIFT))

#define  DM_APP_POWER_REG0_REF_FREQ_SEL_MASK 0x1f
#define  DM_APP_POWER_REG0_REF_FREQ_SEL_SHIFT 0
#define  DM_APP_POWER_REG0_REF_FREQ_SEL_MASK_SHIFT(reg) (((reg) & DM_APP_POWER_REG0_REF_FREQ_SEL_MASK) >> DM_APP_POWER_REG0_REF_FREQ_SEL_SHIFT)
#define  DM_APP_POWER_REG0_REF_FREQ_SEL_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_POWER_REG0_REF_FREQ_SEL_MASK) | (((uint32_t)val) << DM_APP_POWER_REG0_REF_FREQ_SEL_SHIFT))

//====================================================================
//Register: KVCO Calibration Control Register (CAL_REG0)
/** \brief COMPHY-specific registers.<BR>
    Used to set various Phy parameters.<BR>
    Address Offset 0x02 * 4 = 0x08*/
//====================================================================

#define  DM_APP_CAL_REG0_RESERVED1_MASK 0xffff0000
#define  DM_APP_CAL_REG0_RESERVED1_SHIFT 16
#define  DM_APP_CAL_REG0_RESERVED1_MASK_SHIFT(reg) (((reg) & DM_APP_CAL_REG0_RESERVED1_MASK) >> DM_APP_CAL_REG0_RESERVED1_SHIFT)
#define  DM_APP_CAL_REG0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_CAL_REG0_RESERVED1_MASK) | (((uint32_t)val) << DM_APP_CAL_REG0_RESERVED1_SHIFT))

#define  DM_APP_CAL_REG0_CAL_START_MASK 0x8000
#define  DM_APP_CAL_REG0_CAL_START_SHIFT 15
#define  DM_APP_CAL_REG0_CAL_START_MASK_SHIFT(reg) (((reg) & DM_APP_CAL_REG0_CAL_START_MASK) >> DM_APP_CAL_REG0_CAL_START_SHIFT)
#define  DM_APP_CAL_REG0_CAL_START_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_CAL_REG0_CAL_START_MASK) | (((uint32_t)val) << DM_APP_CAL_REG0_CAL_START_SHIFT))

#define  DM_APP_CAL_REG0_CAL_DONE_MASK 0x4000
#define  DM_APP_CAL_REG0_CAL_DONE_SHIFT 14
#define  DM_APP_CAL_REG0_CAL_DONE_MASK_SHIFT(reg) (((reg) & DM_APP_CAL_REG0_CAL_DONE_MASK) >> DM_APP_CAL_REG0_CAL_DONE_SHIFT)
#define  DM_APP_CAL_REG0_CAL_DONE_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_CAL_REG0_CAL_DONE_MASK) | (((uint32_t)val) << DM_APP_CAL_REG0_CAL_DONE_SHIFT))

#define  DM_APP_CAL_REG0_RESERVED2_MASK 0x2000
#define  DM_APP_CAL_REG0_RESERVED2_SHIFT 13
#define  DM_APP_CAL_REG0_RESERVED2_MASK_SHIFT(reg) (((reg) & DM_APP_CAL_REG0_RESERVED2_MASK) >> DM_APP_CAL_REG0_RESERVED2_SHIFT)
#define  DM_APP_CAL_REG0_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_CAL_REG0_RESERVED2_MASK) | (((uint32_t)val) << DM_APP_CAL_REG0_RESERVED2_SHIFT))

#define  DM_APP_CAL_REG0_USE_MAX_PLL_RATE_MASK 0x1000
#define  DM_APP_CAL_REG0_USE_MAX_PLL_RATE_SHIFT 12
#define  DM_APP_CAL_REG0_USE_MAX_PLL_RATE_MASK_SHIFT(reg) (((reg) & DM_APP_CAL_REG0_USE_MAX_PLL_RATE_MASK) >> DM_APP_CAL_REG0_USE_MAX_PLL_RATE_SHIFT)
#define  DM_APP_CAL_REG0_USE_MAX_PLL_RATE_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_CAL_REG0_USE_MAX_PLL_RATE_MASK) | (((uint32_t)val) << DM_APP_CAL_REG0_USE_MAX_PLL_RATE_SHIFT))

#define  DM_APP_CAL_REG0_RESERVED3_MASK 0xc00
#define  DM_APP_CAL_REG0_RESERVED3_SHIFT 10
#define  DM_APP_CAL_REG0_RESERVED3_MASK_SHIFT(reg) (((reg) & DM_APP_CAL_REG0_RESERVED3_MASK) >> DM_APP_CAL_REG0_RESERVED3_SHIFT)
#define  DM_APP_CAL_REG0_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_CAL_REG0_RESERVED3_MASK) | (((uint32_t)val) << DM_APP_CAL_REG0_RESERVED3_SHIFT))

#define  DM_APP_CAL_REG0_EXT_FORCE_CAL_DONE_MASK 0x200
#define  DM_APP_CAL_REG0_EXT_FORCE_CAL_DONE_SHIFT 9
#define  DM_APP_CAL_REG0_EXT_FORCE_CAL_DONE_MASK_SHIFT(reg) (((reg) & DM_APP_CAL_REG0_EXT_FORCE_CAL_DONE_MASK) >> DM_APP_CAL_REG0_EXT_FORCE_CAL_DONE_SHIFT)
#define  DM_APP_CAL_REG0_EXT_FORCE_CAL_DONE_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_CAL_REG0_EXT_FORCE_CAL_DONE_MASK) | (((uint32_t)val) << DM_APP_CAL_REG0_EXT_FORCE_CAL_DONE_SHIFT))

#define  DM_APP_CAL_REG0_SPEED_EXT_EN_MASK 0x100
#define  DM_APP_CAL_REG0_SPEED_EXT_EN_SHIFT 8
#define  DM_APP_CAL_REG0_SPEED_EXT_EN_MASK_SHIFT(reg) (((reg) & DM_APP_CAL_REG0_SPEED_EXT_EN_MASK) >> DM_APP_CAL_REG0_SPEED_EXT_EN_SHIFT)
#define  DM_APP_CAL_REG0_SPEED_EXT_EN_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_CAL_REG0_SPEED_EXT_EN_MASK) | (((uint32_t)val) << DM_APP_CAL_REG0_SPEED_EXT_EN_SHIFT))

#define  DM_APP_CAL_REG0_SPEED_MASK 0xfc
#define  DM_APP_CAL_REG0_SPEED_SHIFT 2
#define  DM_APP_CAL_REG0_SPEED_MASK_SHIFT(reg) (((reg) & DM_APP_CAL_REG0_SPEED_MASK) >> DM_APP_CAL_REG0_SPEED_SHIFT)
#define  DM_APP_CAL_REG0_SPEED_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_CAL_REG0_SPEED_MASK) | (((uint32_t)val) << DM_APP_CAL_REG0_SPEED_SHIFT))

#define  DM_APP_CAL_REG0_RESERVED4_MASK 0x3
#define  DM_APP_CAL_REG0_RESERVED4_SHIFT 0
#define  DM_APP_CAL_REG0_RESERVED4_MASK_SHIFT(reg) (((reg) & DM_APP_CAL_REG0_RESERVED4_MASK) >> DM_APP_CAL_REG0_RESERVED4_SHIFT)
#define  DM_APP_CAL_REG0_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_CAL_REG0_RESERVED4_MASK) | (((uint32_t)val) << DM_APP_CAL_REG0_RESERVED4_SHIFT))

//====================================================================
//Register: Digital Loopback Enable Register (LOOPBACK_REG0)
/** \brief COMPHY-specific registers.<BR>
    Used to set various Phy parameters.<BR>
    See Common PHY Control Registers Document for bit details<BR>
    Address Offset 0x23 * 4 = 0x8C*/
//====================================================================

#define  DM_APP_LOOPBACK_REG0_RESERVED1_MASK 0xffff0000
#define  DM_APP_LOOPBACK_REG0_RESERVED1_SHIFT 16
#define  DM_APP_LOOPBACK_REG0_RESERVED1_MASK_SHIFT(reg) (((reg) & DM_APP_LOOPBACK_REG0_RESERVED1_MASK) >> DM_APP_LOOPBACK_REG0_RESERVED1_SHIFT)
#define  DM_APP_LOOPBACK_REG0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_LOOPBACK_REG0_RESERVED1_MASK) | (((uint32_t)val) << DM_APP_LOOPBACK_REG0_RESERVED1_SHIFT))

#define  DM_APP_LOOPBACK_REG0_DATA_MASK 0xffff
#define  DM_APP_LOOPBACK_REG0_DATA_SHIFT 0
#define  DM_APP_LOOPBACK_REG0_DATA_MASK_SHIFT(reg) (((reg) & DM_APP_LOOPBACK_REG0_DATA_MASK) >> DM_APP_LOOPBACK_REG0_DATA_SHIFT)
#define  DM_APP_LOOPBACK_REG0_DATA_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_LOOPBACK_REG0_DATA_MASK) | (((uint32_t)val) << DM_APP_LOOPBACK_REG0_DATA_SHIFT))

//====================================================================
//Register: COMPHY Register 0x49 (MISC_REG49)
/** \brief COMPHY-specific registers.<BR>
    Used to set various Phy parameters.<BR>
    See Common PHY Control Registers Document for bit details<BR>
    Address Offset 0x49 * 4 = 0x124*/
//====================================================================

#define  DM_APP_MISC_REG49_RESERVED1_MASK 0xffff0000
#define  DM_APP_MISC_REG49_RESERVED1_SHIFT 16
#define  DM_APP_MISC_REG49_RESERVED1_MASK_SHIFT(reg) (((reg) & DM_APP_MISC_REG49_RESERVED1_MASK) >> DM_APP_MISC_REG49_RESERVED1_SHIFT)
#define  DM_APP_MISC_REG49_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_MISC_REG49_RESERVED1_MASK) | (((uint32_t)val) << DM_APP_MISC_REG49_RESERVED1_SHIFT))

#define  DM_APP_MISC_REG49_DATA_MASK 0xffff
#define  DM_APP_MISC_REG49_DATA_SHIFT 0
#define  DM_APP_MISC_REG49_DATA_MASK_SHIFT(reg) (((reg) & DM_APP_MISC_REG49_DATA_MASK) >> DM_APP_MISC_REG49_DATA_SHIFT)
#define  DM_APP_MISC_REG49_DATA_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_MISC_REG49_DATA_MASK) | (((uint32_t)val) << DM_APP_MISC_REG49_DATA_SHIFT))

//====================================================================
//Register: COMPHY Register 0x4f - Misc Freq Select (MISC_FREQ_SEL)
/** \brief COMPHY-specific registers.<BR>
    Used to set various Phy parameters.<BR>
    Address Offset 0x4f * 4 = 0x13C*/
//====================================================================

#define  DM_APP_MISC_FREQ_SEL_RESERVED1_MASK 0xfffff800
#define  DM_APP_MISC_FREQ_SEL_RESERVED1_SHIFT 11
#define  DM_APP_MISC_FREQ_SEL_RESERVED1_MASK_SHIFT(reg) (((reg) & DM_APP_MISC_FREQ_SEL_RESERVED1_MASK) >> DM_APP_MISC_FREQ_SEL_RESERVED1_SHIFT)
#define  DM_APP_MISC_FREQ_SEL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_MISC_FREQ_SEL_RESERVED1_MASK) | (((uint32_t)val) << DM_APP_MISC_FREQ_SEL_RESERVED1_SHIFT))

#define  DM_APP_MISC_FREQ_SEL_REFCLK_SEL_MASK 0x400
#define  DM_APP_MISC_FREQ_SEL_REFCLK_SEL_SHIFT 10
#define  DM_APP_MISC_FREQ_SEL_REFCLK_SEL_MASK_SHIFT(reg) (((reg) & DM_APP_MISC_FREQ_SEL_REFCLK_SEL_MASK) >> DM_APP_MISC_FREQ_SEL_REFCLK_SEL_SHIFT)
#define  DM_APP_MISC_FREQ_SEL_REFCLK_SEL_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_MISC_FREQ_SEL_REFCLK_SEL_MASK) | (((uint32_t)val) << DM_APP_MISC_FREQ_SEL_REFCLK_SEL_SHIFT))

#define  DM_APP_MISC_FREQ_SEL_RESERVED2_MASK 0x200
#define  DM_APP_MISC_FREQ_SEL_RESERVED2_SHIFT 9
#define  DM_APP_MISC_FREQ_SEL_RESERVED2_MASK_SHIFT(reg) (((reg) & DM_APP_MISC_FREQ_SEL_RESERVED2_MASK) >> DM_APP_MISC_FREQ_SEL_RESERVED2_SHIFT)
#define  DM_APP_MISC_FREQ_SEL_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_MISC_FREQ_SEL_RESERVED2_MASK) | (((uint32_t)val) << DM_APP_MISC_FREQ_SEL_RESERVED2_SHIFT))

#define  DM_APP_MISC_FREQ_SEL_CLK100M_125M_SEL_MASK 0x100
#define  DM_APP_MISC_FREQ_SEL_CLK100M_125M_SEL_SHIFT 8
#define  DM_APP_MISC_FREQ_SEL_CLK100M_125M_SEL_MASK_SHIFT(reg) (((reg) & DM_APP_MISC_FREQ_SEL_CLK100M_125M_SEL_MASK) >> DM_APP_MISC_FREQ_SEL_CLK100M_125M_SEL_SHIFT)
#define  DM_APP_MISC_FREQ_SEL_CLK100M_125M_SEL_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_MISC_FREQ_SEL_CLK100M_125M_SEL_MASK) | (((uint32_t)val) << DM_APP_MISC_FREQ_SEL_CLK100M_125M_SEL_SHIFT))

#define  DM_APP_MISC_FREQ_SEL_CLK500M_EN_MASK 0x80
#define  DM_APP_MISC_FREQ_SEL_CLK500M_EN_SHIFT 7
#define  DM_APP_MISC_FREQ_SEL_CLK500M_EN_MASK_SHIFT(reg) (((reg) & DM_APP_MISC_FREQ_SEL_CLK500M_EN_MASK) >> DM_APP_MISC_FREQ_SEL_CLK500M_EN_SHIFT)
#define  DM_APP_MISC_FREQ_SEL_CLK500M_EN_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_MISC_FREQ_SEL_CLK500M_EN_MASK) | (((uint32_t)val) << DM_APP_MISC_FREQ_SEL_CLK500M_EN_SHIFT))

#define  DM_APP_MISC_FREQ_SEL_TXDCLK_2X_SEL_MASK 0x40
#define  DM_APP_MISC_FREQ_SEL_TXDCLK_2X_SEL_SHIFT 6
#define  DM_APP_MISC_FREQ_SEL_TXDCLK_2X_SEL_MASK_SHIFT(reg) (((reg) & DM_APP_MISC_FREQ_SEL_TXDCLK_2X_SEL_MASK) >> DM_APP_MISC_FREQ_SEL_TXDCLK_2X_SEL_SHIFT)
#define  DM_APP_MISC_FREQ_SEL_TXDCLK_2X_SEL_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_MISC_FREQ_SEL_TXDCLK_2X_SEL_MASK) | (((uint32_t)val) << DM_APP_MISC_FREQ_SEL_TXDCLK_2X_SEL_SHIFT))

#define  DM_APP_MISC_FREQ_SEL_RESERVED3_MASK 0x20
#define  DM_APP_MISC_FREQ_SEL_RESERVED3_SHIFT 5
#define  DM_APP_MISC_FREQ_SEL_RESERVED3_MASK_SHIFT(reg) (((reg) & DM_APP_MISC_FREQ_SEL_RESERVED3_MASK) >> DM_APP_MISC_FREQ_SEL_RESERVED3_SHIFT)
#define  DM_APP_MISC_FREQ_SEL_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_MISC_FREQ_SEL_RESERVED3_MASK) | (((uint32_t)val) << DM_APP_MISC_FREQ_SEL_RESERVED3_SHIFT))

#define  DM_APP_MISC_FREQ_SEL_CLK100M_125M_EN_MASK 0x10
#define  DM_APP_MISC_FREQ_SEL_CLK100M_125M_EN_SHIFT 4
#define  DM_APP_MISC_FREQ_SEL_CLK100M_125M_EN_MASK_SHIFT(reg) (((reg) & DM_APP_MISC_FREQ_SEL_CLK100M_125M_EN_MASK) >> DM_APP_MISC_FREQ_SEL_CLK100M_125M_EN_SHIFT)
#define  DM_APP_MISC_FREQ_SEL_CLK100M_125M_EN_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_MISC_FREQ_SEL_CLK100M_125M_EN_MASK) | (((uint32_t)val) << DM_APP_MISC_FREQ_SEL_CLK100M_125M_EN_SHIFT))

#define  DM_APP_MISC_FREQ_SEL_RESERVED4_MASK 0xf
#define  DM_APP_MISC_FREQ_SEL_RESERVED4_SHIFT 0
#define  DM_APP_MISC_FREQ_SEL_RESERVED4_MASK_SHIFT(reg) (((reg) & DM_APP_MISC_FREQ_SEL_RESERVED4_MASK) >> DM_APP_MISC_FREQ_SEL_RESERVED4_SHIFT)
#define  DM_APP_MISC_FREQ_SEL_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_MISC_FREQ_SEL_RESERVED4_MASK) | (((uint32_t)val) << DM_APP_MISC_FREQ_SEL_RESERVED4_SHIFT))

//====================================================================
//Register: COMPHY Register 0x51 (MISC_REG51)
/** \brief COMPHY-specific registers.<BR>
    Used to set various Phy parameters.<BR>
    See Common PHY Control Registers Document for bit details<BR>
    Address Offset 0x51 * 4 = 0x144*/
//====================================================================

#define  DM_APP_MISC_REG51_RESERVED1_MASK 0xffff0000
#define  DM_APP_MISC_REG51_RESERVED1_SHIFT 16
#define  DM_APP_MISC_REG51_RESERVED1_MASK_SHIFT(reg) (((reg) & DM_APP_MISC_REG51_RESERVED1_MASK) >> DM_APP_MISC_REG51_RESERVED1_SHIFT)
#define  DM_APP_MISC_REG51_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_MISC_REG51_RESERVED1_MASK) | (((uint32_t)val) << DM_APP_MISC_REG51_RESERVED1_SHIFT))

#define  DM_APP_MISC_REG51_DATA_MASK 0xffff
#define  DM_APP_MISC_REG51_DATA_SHIFT 0
#define  DM_APP_MISC_REG51_DATA_MASK_SHIFT(reg) (((reg) & DM_APP_MISC_REG51_DATA_MASK) >> DM_APP_MISC_REG51_DATA_SHIFT)
#define  DM_APP_MISC_REG51_DATA_REPLACE_VAL(reg,val) (((reg) & ~DM_APP_MISC_REG51_DATA_MASK) | (((uint32_t)val) << DM_APP_MISC_REG51_DATA_SHIFT))

#endif // PCIE
