 /*
 **************************************************************************************
 *
 * (c) Copyright 2013 Marvell International Ltd.
 *
 *
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/.
 *
 **************************************************************************************
 *
 * \file PASR_regstructs.h
 * Generated using RegBuild 1.6.3
 *
 **************************************************************************************
 */

#ifndef _PASR_REGSTRUCTS_H_
#define _PASR_REGSTRUCTS_H_

#ifndef __KERNEL__
#include <stdint.h>
#endif

//====================================================================
//
//Register File: Pipeline Access Store and Reload (PASR)
/** \brief Register descriptions for the Pipeline Access Store and Reload (PASR) block. This block allows pipe data
    to be stored off into system memory via a DMA operation. Data can then be reloaded back into the
    pipe from system memory. Normally this block operates in bypass mode passing input data on to the
    output. The input and output data are 67 bits wide. There are 64 bits of pixel data and 3 bits of Data Type.
    The Data Type bits are not stored into memory, but they can be generated when data is loaded.*/
//
//====================================================================

typedef struct PASR_REGS_s
{
  volatile uint32_t CSR;  ///< 0x0 [R/W]: Control Register
  volatile uint32_t BStatL;  ///< 0x4 [R]: Output Image Strip Size Status Register
  volatile uint32_t BStatDT;  ///< 0x8 [R]: Output Image Strip DT Status Register
  volatile uint32_t BFormL;  ///< 0xc [W]: Output Format Override Register
  volatile uint32_t BFormDT;  ///< 0x10 [W]: Output Image Strip DT Format Register
  volatile uint32_t REV0;  ///< 0x14 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0x18 [R]: IP Tagging Revision 1
} PASR_REGS_t;

//====================================================================
//
//Register File: Store DMA register set (PipeWriteDMA)
//
//====================================================================

typedef struct PIPEWRITEDMA_REGS_s
{
  volatile uint32_t UCR;  ///< 0x0 [R/W]: UDMA Configuration Register
  volatile uint32_t USR;  ///< 0x4 [R]: UDMA Status Register
  volatile uint32_t UPR;  ///< 0x8 [R]: UDMA Parameter Register
  volatile uint32_t UIER;  ///< 0xc [R/W]: UDMA Interrupt Enable Register
  volatile uint32_t UIPR;  ///< 0x10 [R]: UDMA Interrupt Pending Register
  volatile uint32_t UICR;  ///< 0x14 [W]: UDMA Interrupt Clear Register
  volatile uint32_t UIFR;  ///< 0x18 [W]: UDMA Interrupt Force Register
  volatile uint32_t UDR;  ///< 0x1c [R/W]: UDMA Descriptor Register
  volatile uint32_t UBAR;  ///< 0x20 [R]: UDMA Burst Address Register
  volatile uint32_t UBLR;  ///< 0x24 [R]: UDMA Burst Length Register
  volatile uint32_t UBRR;  ///< 0x28 [R]: UDMA Transfer Bytes Remaining Register
  volatile uint32_t reserved0;
  volatile uint32_t UTR0;  ///< 0x30 [R]: UDMA Tag Register 0
  volatile uint32_t UTR1;  ///< 0x34 [R]: UDMA Tag Register 1
} PIPEWRITEDMA_REGS_t;

//====================================================================
//
//Register File: Reload DMA register set (PipeReadDMA)
//
//====================================================================

typedef struct PIPEREADDMA_REGS_s
{
  volatile uint32_t UCR;  ///< 0x0 [R/W]: UDMA Configuration Register
  volatile uint32_t USR;  ///< 0x4 [R]: UDMA Status Register
  volatile uint32_t UPR;  ///< 0x8 [R]: UDMA Parameter Register
  volatile uint32_t UIER;  ///< 0xc [R/W]: UDMA Interrupt Enable Register
  volatile uint32_t UIPR;  ///< 0x10 [R]: UDMA Interrupt Pending Register
  volatile uint32_t UICR;  ///< 0x14 [W]: UDMA Interrupt Clear Register
  volatile uint32_t UIFR;  ///< 0x18 [W]: UDMA Interrupt Force Register
  volatile uint32_t UDR;  ///< 0x1c [R/W]: UDMA Descriptor Register
  volatile uint32_t UBAR;  ///< 0x20 [R]: UDMA Burst Address Register
  volatile uint32_t UBLR;  ///< 0x24 [R]: UDMA Burst Length Register
  volatile uint32_t UBRR;  ///< 0x28 [R]: UDMA Transfer Bytes Remaining Register
  volatile uint32_t reserved0;
  volatile uint32_t UTR0;  ///< 0x30 [R]: UDMA Tag Register 0
  volatile uint32_t UTR1;  ///< 0x34 [R]: UDMA Tag Register 1
} PIPEREADDMA_REGS_t;

#endif // PASR
