 /*
 **************************************************************************************
 *
 * (c) Copyright 2013 Marvell International Ltd.
 *
 *
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/.
 *
 **************************************************************************************
 *
 * \file PASR_regmasks.h
 * Generated using RegBuild 1.6.3
 *
 **************************************************************************************
 */

#ifndef _PASR_REGMASKS_H_
#define _PASR_REGMASKS_H_

#ifndef __KERNEL__
#include <stdint.h>
#endif

//====================================================================
//
//Register File: Pipeline Access Store and Reload (PASR)
/** \brief Register descriptions for the Pipeline Access Store and Reload (PASR) block. This block allows pipe data
    to be stored off into system memory via a DMA operation. Data can then be reloaded back into the
    pipe from system memory. Normally this block operates in bypass mode passing input data on to the
    output. The input and output data are 67 bits wide. There are 64 bits of pixel data and 3 bits of Data Type.
    The Data Type bits are not stored into memory, but they can be generated when data is loaded.*/
//
//====================================================================

//====================================================================
//Register: Control Register (CSR)
//====================================================================

#define  PASR_CSR_RESERVED1_MASK 0xfffffffc
#define  PASR_CSR_RESERVED1_SHIFT 2
#define  PASR_CSR_RESERVED1_MASK_SHIFT(reg) (((reg) & PASR_CSR_RESERVED1_MASK) >> PASR_CSR_RESERVED1_SHIFT)
#define  PASR_CSR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PASR_CSR_RESERVED1_MASK) | (((uint32_t)val) << PASR_CSR_RESERVED1_SHIFT))

#define  PASR_CSR_DTGEN_MASK 0x2
#define  PASR_CSR_DTGEN_SHIFT 1
#define  PASR_CSR_DTGEN_MASK_SHIFT(reg) (((reg) & PASR_CSR_DTGEN_MASK) >> PASR_CSR_DTGEN_SHIFT)
#define  PASR_CSR_DTGEN_REPLACE_VAL(reg,val) (((reg) & ~PASR_CSR_DTGEN_MASK) | (((uint32_t)val) << PASR_CSR_DTGEN_SHIFT))

#define  PASR_CSR_BYPASS_MASK 0x1
#define  PASR_CSR_BYPASS_SHIFT 0
#define  PASR_CSR_BYPASS_MASK_SHIFT(reg) (((reg) & PASR_CSR_BYPASS_MASK) >> PASR_CSR_BYPASS_SHIFT)
#define  PASR_CSR_BYPASS_REPLACE_VAL(reg,val) (((reg) & ~PASR_CSR_BYPASS_MASK) | (((uint32_t)val) << PASR_CSR_BYPASS_SHIFT))

//====================================================================
//Register: Output Image Strip Size Status Register (BStatL)
/** \brief This register is primarily for debug purposes.*/
//====================================================================

#define  PASR_BSTATL_LLEN_MASK 0xffff0000
#define  PASR_BSTATL_LLEN_SHIFT 16
#define  PASR_BSTATL_LLEN_MASK_SHIFT(reg) (((reg) & PASR_BSTATL_LLEN_MASK) >> PASR_BSTATL_LLEN_SHIFT)
#define  PASR_BSTATL_LLEN_REPLACE_VAL(reg,val) (((reg) & ~PASR_BSTATL_LLEN_MASK) | (((uint32_t)val) << PASR_BSTATL_LLEN_SHIFT))

#define  PASR_BSTATL_BLEN_MASK 0xffff
#define  PASR_BSTATL_BLEN_SHIFT 0
#define  PASR_BSTATL_BLEN_MASK_SHIFT(reg) (((reg) & PASR_BSTATL_BLEN_MASK) >> PASR_BSTATL_BLEN_SHIFT)
#define  PASR_BSTATL_BLEN_REPLACE_VAL(reg,val) (((reg) & ~PASR_BSTATL_BLEN_MASK) | (((uint32_t)val) << PASR_BSTATL_BLEN_SHIFT))

//====================================================================
//Register: Output Image Strip DT Status Register (BStatDT)
/** \brief This register is primarily for debug purposes.*/
//====================================================================

#define  PASR_BSTATDT_RESERVED1_MASK 0xfffffff0
#define  PASR_BSTATDT_RESERVED1_SHIFT 4
#define  PASR_BSTATDT_RESERVED1_MASK_SHIFT(reg) (((reg) & PASR_BSTATDT_RESERVED1_MASK) >> PASR_BSTATDT_RESERVED1_SHIFT)
#define  PASR_BSTATDT_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PASR_BSTATDT_RESERVED1_MASK) | (((uint32_t)val) << PASR_BSTATDT_RESERVED1_SHIFT))

#define  PASR_BSTATDT_SERP_MASK 0x8
#define  PASR_BSTATDT_SERP_SHIFT 3
#define  PASR_BSTATDT_SERP_MASK_SHIFT(reg) (((reg) & PASR_BSTATDT_SERP_MASK) >> PASR_BSTATDT_SERP_SHIFT)
#define  PASR_BSTATDT_SERP_REPLACE_VAL(reg,val) (((reg) & ~PASR_BSTATDT_SERP_MASK) | (((uint32_t)val) << PASR_BSTATDT_SERP_SHIFT))

#define  PASR_BSTATDT_DIR_MASK 0x4
#define  PASR_BSTATDT_DIR_SHIFT 2
#define  PASR_BSTATDT_DIR_MASK_SHIFT(reg) (((reg) & PASR_BSTATDT_DIR_MASK) >> PASR_BSTATDT_DIR_SHIFT)
#define  PASR_BSTATDT_DIR_REPLACE_VAL(reg,val) (((reg) & ~PASR_BSTATDT_DIR_MASK) | (((uint32_t)val) << PASR_BSTATDT_DIR_SHIFT))

#define  PASR_BSTATDT_EOI_MASK 0x2
#define  PASR_BSTATDT_EOI_SHIFT 1
#define  PASR_BSTATDT_EOI_MASK_SHIFT(reg) (((reg) & PASR_BSTATDT_EOI_MASK) >> PASR_BSTATDT_EOI_SHIFT)
#define  PASR_BSTATDT_EOI_REPLACE_VAL(reg,val) (((reg) & ~PASR_BSTATDT_EOI_MASK) | (((uint32_t)val) << PASR_BSTATDT_EOI_SHIFT))

#define  PASR_BSTATDT_SOI_MASK 0x1
#define  PASR_BSTATDT_SOI_SHIFT 0
#define  PASR_BSTATDT_SOI_MASK_SHIFT(reg) (((reg) & PASR_BSTATDT_SOI_MASK) >> PASR_BSTATDT_SOI_SHIFT)
#define  PASR_BSTATDT_SOI_REPLACE_VAL(reg,val) (((reg) & ~PASR_BSTATDT_SOI_MASK) | (((uint32_t)val) << PASR_BSTATDT_SOI_SHIFT))

//====================================================================
//Register: Output Format Override Register (BFormL)
//====================================================================

#define  PASR_BFORML_LLEN_MASK 0xffff0000
#define  PASR_BFORML_LLEN_SHIFT 16
#define  PASR_BFORML_LLEN_MASK_SHIFT(reg) (((reg) & PASR_BFORML_LLEN_MASK) >> PASR_BFORML_LLEN_SHIFT)
#define  PASR_BFORML_LLEN_REPLACE_VAL(reg,val) (((reg) & ~PASR_BFORML_LLEN_MASK) | (((uint32_t)val) << PASR_BFORML_LLEN_SHIFT))

#define  PASR_BFORML_BLEN_MASK 0xffff
#define  PASR_BFORML_BLEN_SHIFT 0
#define  PASR_BFORML_BLEN_MASK_SHIFT(reg) (((reg) & PASR_BFORML_BLEN_MASK) >> PASR_BFORML_BLEN_SHIFT)
#define  PASR_BFORML_BLEN_REPLACE_VAL(reg,val) (((reg) & ~PASR_BFORML_BLEN_MASK) | (((uint32_t)val) << PASR_BFORML_BLEN_SHIFT))

//====================================================================
//Register: Output Image Strip DT Format Register (BFormDT)
//====================================================================

#define  PASR_BFORMDT_RESERVED1_MASK 0xfffffff0
#define  PASR_BFORMDT_RESERVED1_SHIFT 4
#define  PASR_BFORMDT_RESERVED1_MASK_SHIFT(reg) (((reg) & PASR_BFORMDT_RESERVED1_MASK) >> PASR_BFORMDT_RESERVED1_SHIFT)
#define  PASR_BFORMDT_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PASR_BFORMDT_RESERVED1_MASK) | (((uint32_t)val) << PASR_BFORMDT_RESERVED1_SHIFT))

#define  PASR_BFORMDT_SERP_MASK 0x8
#define  PASR_BFORMDT_SERP_SHIFT 3
#define  PASR_BFORMDT_SERP_MASK_SHIFT(reg) (((reg) & PASR_BFORMDT_SERP_MASK) >> PASR_BFORMDT_SERP_SHIFT)
#define  PASR_BFORMDT_SERP_REPLACE_VAL(reg,val) (((reg) & ~PASR_BFORMDT_SERP_MASK) | (((uint32_t)val) << PASR_BFORMDT_SERP_SHIFT))

#define  PASR_BFORMDT_DIR_MASK 0x4
#define  PASR_BFORMDT_DIR_SHIFT 2
#define  PASR_BFORMDT_DIR_MASK_SHIFT(reg) (((reg) & PASR_BFORMDT_DIR_MASK) >> PASR_BFORMDT_DIR_SHIFT)
#define  PASR_BFORMDT_DIR_REPLACE_VAL(reg,val) (((reg) & ~PASR_BFORMDT_DIR_MASK) | (((uint32_t)val) << PASR_BFORMDT_DIR_SHIFT))

#define  PASR_BFORMDT_EOI_MASK 0x2
#define  PASR_BFORMDT_EOI_SHIFT 1
#define  PASR_BFORMDT_EOI_MASK_SHIFT(reg) (((reg) & PASR_BFORMDT_EOI_MASK) >> PASR_BFORMDT_EOI_SHIFT)
#define  PASR_BFORMDT_EOI_REPLACE_VAL(reg,val) (((reg) & ~PASR_BFORMDT_EOI_MASK) | (((uint32_t)val) << PASR_BFORMDT_EOI_SHIFT))

#define  PASR_BFORMDT_SOI_MASK 0x1
#define  PASR_BFORMDT_SOI_SHIFT 0
#define  PASR_BFORMDT_SOI_MASK_SHIFT(reg) (((reg) & PASR_BFORMDT_SOI_MASK) >> PASR_BFORMDT_SOI_SHIFT)
#define  PASR_BFORMDT_SOI_REPLACE_VAL(reg,val) (((reg) & ~PASR_BFORMDT_SOI_MASK) | (((uint32_t)val) << PASR_BFORMDT_SOI_SHIFT))

//====================================================================
//Register: IP Tagging Revision 0 (REV0)
/** \brief Provide means for firmware to read IP tagging information.
      This register of particular interest to firmware.*/
//====================================================================

#define  PASR_REV0_MAJ_MASK 0xffff0000
#define  PASR_REV0_MAJ_SHIFT 16
#define  PASR_REV0_MAJ_MASK_SHIFT(reg) (((reg) & PASR_REV0_MAJ_MASK) >> PASR_REV0_MAJ_SHIFT)
#define  PASR_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~PASR_REV0_MAJ_MASK) | (((uint32_t)val) << PASR_REV0_MAJ_SHIFT))

#define  PASR_REV0_MID_MASK 0xffff
#define  PASR_REV0_MID_SHIFT 0
#define  PASR_REV0_MID_MASK_SHIFT(reg) (((reg) & PASR_REV0_MID_MASK) >> PASR_REV0_MID_SHIFT)
#define  PASR_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~PASR_REV0_MID_MASK) | (((uint32_t)val) << PASR_REV0_MID_SHIFT))

//====================================================================
//Register: IP Tagging Revision 1 (REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  PASR_REV1_RESERVED1_MASK 0xffff0000
#define  PASR_REV1_RESERVED1_SHIFT 16
#define  PASR_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & PASR_REV1_RESERVED1_MASK) >> PASR_REV1_RESERVED1_SHIFT)
#define  PASR_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PASR_REV1_RESERVED1_MASK) | (((uint32_t)val) << PASR_REV1_RESERVED1_SHIFT))

#define  PASR_REV1_CFG_MASK 0xffff
#define  PASR_REV1_CFG_SHIFT 0
#define  PASR_REV1_CFG_MASK_SHIFT(reg) (((reg) & PASR_REV1_CFG_MASK) >> PASR_REV1_CFG_SHIFT)
#define  PASR_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~PASR_REV1_CFG_MASK) | (((uint32_t)val) << PASR_REV1_CFG_SHIFT))

//====================================================================
//
//Register File: Store DMA register set (PipeWriteDMA)
//
//====================================================================

//====================================================================
//Register: UDMA Configuration Register (UCR)
//====================================================================

#define  PIPEWRITEDMA_UCR_RESERVED1_MASK 0xfff00000
#define  PIPEWRITEDMA_UCR_RESERVED1_SHIFT 20
#define  PIPEWRITEDMA_UCR_RESERVED1_MASK_SHIFT(reg) (((reg) & PIPEWRITEDMA_UCR_RESERVED1_MASK) >> PIPEWRITEDMA_UCR_RESERVED1_SHIFT)
#define  PIPEWRITEDMA_UCR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PIPEWRITEDMA_UCR_RESERVED1_MASK) | (((uint32_t)val) << PIPEWRITEDMA_UCR_RESERVED1_SHIFT))

#define  PIPEWRITEDMA_UCR_DATAAXCACHE_MASK 0xf0000
#define  PIPEWRITEDMA_UCR_DATAAXCACHE_SHIFT 16
#define  PIPEWRITEDMA_UCR_DATAAXCACHE_MASK_SHIFT(reg) (((reg) & PIPEWRITEDMA_UCR_DATAAXCACHE_MASK) >> PIPEWRITEDMA_UCR_DATAAXCACHE_SHIFT)
#define  PIPEWRITEDMA_UCR_DATAAXCACHE_REPLACE_VAL(reg,val) (((reg) & ~PIPEWRITEDMA_UCR_DATAAXCACHE_MASK) | (((uint32_t)val) << PIPEWRITEDMA_UCR_DATAAXCACHE_SHIFT))

#define  PIPEWRITEDMA_UCR_DESCARCACHE_MASK 0xf000
#define  PIPEWRITEDMA_UCR_DESCARCACHE_SHIFT 12
#define  PIPEWRITEDMA_UCR_DESCARCACHE_MASK_SHIFT(reg) (((reg) & PIPEWRITEDMA_UCR_DESCARCACHE_MASK) >> PIPEWRITEDMA_UCR_DESCARCACHE_SHIFT)
#define  PIPEWRITEDMA_UCR_DESCARCACHE_REPLACE_VAL(reg,val) (((reg) & ~PIPEWRITEDMA_UCR_DESCARCACHE_MASK) | (((uint32_t)val) << PIPEWRITEDMA_UCR_DESCARCACHE_SHIFT))

#define  PIPEWRITEDMA_UCR_DESCAWCACHE_MASK 0xf00
#define  PIPEWRITEDMA_UCR_DESCAWCACHE_SHIFT 8
#define  PIPEWRITEDMA_UCR_DESCAWCACHE_MASK_SHIFT(reg) (((reg) & PIPEWRITEDMA_UCR_DESCAWCACHE_MASK) >> PIPEWRITEDMA_UCR_DESCAWCACHE_SHIFT)
#define  PIPEWRITEDMA_UCR_DESCAWCACHE_REPLACE_VAL(reg,val) (((reg) & ~PIPEWRITEDMA_UCR_DESCAWCACHE_MASK) | (((uint32_t)val) << PIPEWRITEDMA_UCR_DESCAWCACHE_SHIFT))

#define  PIPEWRITEDMA_UCR_RESERVED2_MASK 0xc0
#define  PIPEWRITEDMA_UCR_RESERVED2_SHIFT 6
#define  PIPEWRITEDMA_UCR_RESERVED2_MASK_SHIFT(reg) (((reg) & PIPEWRITEDMA_UCR_RESERVED2_MASK) >> PIPEWRITEDMA_UCR_RESERVED2_SHIFT)
#define  PIPEWRITEDMA_UCR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~PIPEWRITEDMA_UCR_RESERVED2_MASK) | (((uint32_t)val) << PIPEWRITEDMA_UCR_RESERVED2_SHIFT))

#define  PIPEWRITEDMA_UCR_HANDSHAKEENABLE_MASK 0x20
#define  PIPEWRITEDMA_UCR_HANDSHAKEENABLE_SHIFT 5
#define  PIPEWRITEDMA_UCR_HANDSHAKEENABLE_MASK_SHIFT(reg) (((reg) & PIPEWRITEDMA_UCR_HANDSHAKEENABLE_MASK) >> PIPEWRITEDMA_UCR_HANDSHAKEENABLE_SHIFT)
#define  PIPEWRITEDMA_UCR_HANDSHAKEENABLE_REPLACE_VAL(reg,val) (((reg) & ~PIPEWRITEDMA_UCR_HANDSHAKEENABLE_MASK) | (((uint32_t)val) << PIPEWRITEDMA_UCR_HANDSHAKEENABLE_SHIFT))

#define  PIPEWRITEDMA_UCR_OWNWRITEDISABLE_MASK 0x10
#define  PIPEWRITEDMA_UCR_OWNWRITEDISABLE_SHIFT 4
#define  PIPEWRITEDMA_UCR_OWNWRITEDISABLE_MASK_SHIFT(reg) (((reg) & PIPEWRITEDMA_UCR_OWNWRITEDISABLE_MASK) >> PIPEWRITEDMA_UCR_OWNWRITEDISABLE_SHIFT)
#define  PIPEWRITEDMA_UCR_OWNWRITEDISABLE_REPLACE_VAL(reg,val) (((reg) & ~PIPEWRITEDMA_UCR_OWNWRITEDISABLE_MASK) | (((uint32_t)val) << PIPEWRITEDMA_UCR_OWNWRITEDISABLE_SHIFT))

#define  PIPEWRITEDMA_UCR_OWNPOLARITY_MASK 0x8
#define  PIPEWRITEDMA_UCR_OWNPOLARITY_SHIFT 3
#define  PIPEWRITEDMA_UCR_OWNPOLARITY_MASK_SHIFT(reg) (((reg) & PIPEWRITEDMA_UCR_OWNPOLARITY_MASK) >> PIPEWRITEDMA_UCR_OWNPOLARITY_SHIFT)
#define  PIPEWRITEDMA_UCR_OWNPOLARITY_REPLACE_VAL(reg,val) (((reg) & ~PIPEWRITEDMA_UCR_OWNPOLARITY_MASK) | (((uint32_t)val) << PIPEWRITEDMA_UCR_OWNPOLARITY_SHIFT))

#define  PIPEWRITEDMA_UCR_BEATS_MASK 0x6
#define  PIPEWRITEDMA_UCR_BEATS_SHIFT 1
#define  PIPEWRITEDMA_UCR_BEATS_MASK_SHIFT(reg) (((reg) & PIPEWRITEDMA_UCR_BEATS_MASK) >> PIPEWRITEDMA_UCR_BEATS_SHIFT)
#define  PIPEWRITEDMA_UCR_BEATS_REPLACE_VAL(reg,val) (((reg) & ~PIPEWRITEDMA_UCR_BEATS_MASK) | (((uint32_t)val) << PIPEWRITEDMA_UCR_BEATS_SHIFT))

#define  PIPEWRITEDMA_UCR_ENABLE_MASK 0x1
#define  PIPEWRITEDMA_UCR_ENABLE_SHIFT 0
#define  PIPEWRITEDMA_UCR_ENABLE_MASK_SHIFT(reg) (((reg) & PIPEWRITEDMA_UCR_ENABLE_MASK) >> PIPEWRITEDMA_UCR_ENABLE_SHIFT)
#define  PIPEWRITEDMA_UCR_ENABLE_REPLACE_VAL(reg,val) (((reg) & ~PIPEWRITEDMA_UCR_ENABLE_MASK) | (((uint32_t)val) << PIPEWRITEDMA_UCR_ENABLE_SHIFT))

//====================================================================
//Register: UDMA Status Register (USR)
//====================================================================

#define  PIPEWRITEDMA_USR_RESERVED1_MASK 0xfffff800
#define  PIPEWRITEDMA_USR_RESERVED1_SHIFT 11
#define  PIPEWRITEDMA_USR_RESERVED1_MASK_SHIFT(reg) (((reg) & PIPEWRITEDMA_USR_RESERVED1_MASK) >> PIPEWRITEDMA_USR_RESERVED1_SHIFT)
#define  PIPEWRITEDMA_USR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PIPEWRITEDMA_USR_RESERVED1_MASK) | (((uint32_t)val) << PIPEWRITEDMA_USR_RESERVED1_SHIFT))

#define  PIPEWRITEDMA_USR_DMAPAUSED_MASK 0x400
#define  PIPEWRITEDMA_USR_DMAPAUSED_SHIFT 10
#define  PIPEWRITEDMA_USR_DMAPAUSED_MASK_SHIFT(reg) (((reg) & PIPEWRITEDMA_USR_DMAPAUSED_MASK) >> PIPEWRITEDMA_USR_DMAPAUSED_SHIFT)
#define  PIPEWRITEDMA_USR_DMAPAUSED_REPLACE_VAL(reg,val) (((reg) & ~PIPEWRITEDMA_USR_DMAPAUSED_MASK) | (((uint32_t)val) << PIPEWRITEDMA_USR_DMAPAUSED_SHIFT))

#define  PIPEWRITEDMA_USR_PAUSEAFTER_MASK 0x200
#define  PIPEWRITEDMA_USR_PAUSEAFTER_SHIFT 9
#define  PIPEWRITEDMA_USR_PAUSEAFTER_MASK_SHIFT(reg) (((reg) & PIPEWRITEDMA_USR_PAUSEAFTER_MASK) >> PIPEWRITEDMA_USR_PAUSEAFTER_SHIFT)
#define  PIPEWRITEDMA_USR_PAUSEAFTER_REPLACE_VAL(reg,val) (((reg) & ~PIPEWRITEDMA_USR_PAUSEAFTER_MASK) | (((uint32_t)val) << PIPEWRITEDMA_USR_PAUSEAFTER_SHIFT))

#define  PIPEWRITEDMA_USR_PAUSEBEFORE_MASK 0x100
#define  PIPEWRITEDMA_USR_PAUSEBEFORE_SHIFT 8
#define  PIPEWRITEDMA_USR_PAUSEBEFORE_MASK_SHIFT(reg) (((reg) & PIPEWRITEDMA_USR_PAUSEBEFORE_MASK) >> PIPEWRITEDMA_USR_PAUSEBEFORE_SHIFT)
#define  PIPEWRITEDMA_USR_PAUSEBEFORE_REPLACE_VAL(reg,val) (((reg) & ~PIPEWRITEDMA_USR_PAUSEBEFORE_MASK) | (((uint32_t)val) << PIPEWRITEDMA_USR_PAUSEBEFORE_SHIFT))

#define  PIPEWRITEDMA_USR_INTONFINISH_MASK 0x80
#define  PIPEWRITEDMA_USR_INTONFINISH_SHIFT 7
#define  PIPEWRITEDMA_USR_INTONFINISH_MASK_SHIFT(reg) (((reg) & PIPEWRITEDMA_USR_INTONFINISH_MASK) >> PIPEWRITEDMA_USR_INTONFINISH_SHIFT)
#define  PIPEWRITEDMA_USR_INTONFINISH_REPLACE_VAL(reg,val) (((reg) & ~PIPEWRITEDMA_USR_INTONFINISH_MASK) | (((uint32_t)val) << PIPEWRITEDMA_USR_INTONFINISH_SHIFT))

#define  PIPEWRITEDMA_USR_STOPONFINISH_MASK 0x40
#define  PIPEWRITEDMA_USR_STOPONFINISH_SHIFT 6
#define  PIPEWRITEDMA_USR_STOPONFINISH_MASK_SHIFT(reg) (((reg) & PIPEWRITEDMA_USR_STOPONFINISH_MASK) >> PIPEWRITEDMA_USR_STOPONFINISH_SHIFT)
#define  PIPEWRITEDMA_USR_STOPONFINISH_REPLACE_VAL(reg,val) (((reg) & ~PIPEWRITEDMA_USR_STOPONFINISH_MASK) | (((uint32_t)val) << PIPEWRITEDMA_USR_STOPONFINISH_SHIFT))

#define  PIPEWRITEDMA_USR_CMDBUFFULL_MASK 0x20
#define  PIPEWRITEDMA_USR_CMDBUFFULL_SHIFT 5
#define  PIPEWRITEDMA_USR_CMDBUFFULL_MASK_SHIFT(reg) (((reg) & PIPEWRITEDMA_USR_CMDBUFFULL_MASK) >> PIPEWRITEDMA_USR_CMDBUFFULL_SHIFT)
#define  PIPEWRITEDMA_USR_CMDBUFFULL_REPLACE_VAL(reg,val) (((reg) & ~PIPEWRITEDMA_USR_CMDBUFFULL_MASK) | (((uint32_t)val) << PIPEWRITEDMA_USR_CMDBUFFULL_SHIFT))

#define  PIPEWRITEDMA_USR_CMDBUFEMPTY_MASK 0x10
#define  PIPEWRITEDMA_USR_CMDBUFEMPTY_SHIFT 4
#define  PIPEWRITEDMA_USR_CMDBUFEMPTY_MASK_SHIFT(reg) (((reg) & PIPEWRITEDMA_USR_CMDBUFEMPTY_MASK) >> PIPEWRITEDMA_USR_CMDBUFEMPTY_SHIFT)
#define  PIPEWRITEDMA_USR_CMDBUFEMPTY_REPLACE_VAL(reg,val) (((reg) & ~PIPEWRITEDMA_USR_CMDBUFEMPTY_MASK) | (((uint32_t)val) << PIPEWRITEDMA_USR_CMDBUFEMPTY_SHIFT))

#define  PIPEWRITEDMA_USR_DATABUFFULL_MASK 0x8
#define  PIPEWRITEDMA_USR_DATABUFFULL_SHIFT 3
#define  PIPEWRITEDMA_USR_DATABUFFULL_MASK_SHIFT(reg) (((reg) & PIPEWRITEDMA_USR_DATABUFFULL_MASK) >> PIPEWRITEDMA_USR_DATABUFFULL_SHIFT)
#define  PIPEWRITEDMA_USR_DATABUFFULL_REPLACE_VAL(reg,val) (((reg) & ~PIPEWRITEDMA_USR_DATABUFFULL_MASK) | (((uint32_t)val) << PIPEWRITEDMA_USR_DATABUFFULL_SHIFT))

#define  PIPEWRITEDMA_USR_DATABUFEMPTY_MASK 0x4
#define  PIPEWRITEDMA_USR_DATABUFEMPTY_SHIFT 2
#define  PIPEWRITEDMA_USR_DATABUFEMPTY_MASK_SHIFT(reg) (((reg) & PIPEWRITEDMA_USR_DATABUFEMPTY_MASK) >> PIPEWRITEDMA_USR_DATABUFEMPTY_SHIFT)
#define  PIPEWRITEDMA_USR_DATABUFEMPTY_REPLACE_VAL(reg,val) (((reg) & ~PIPEWRITEDMA_USR_DATABUFEMPTY_MASK) | (((uint32_t)val) << PIPEWRITEDMA_USR_DATABUFEMPTY_SHIFT))

#define  PIPEWRITEDMA_USR_CLEAR_MASK 0x2
#define  PIPEWRITEDMA_USR_CLEAR_SHIFT 1
#define  PIPEWRITEDMA_USR_CLEAR_MASK_SHIFT(reg) (((reg) & PIPEWRITEDMA_USR_CLEAR_MASK) >> PIPEWRITEDMA_USR_CLEAR_SHIFT)
#define  PIPEWRITEDMA_USR_CLEAR_REPLACE_VAL(reg,val) (((reg) & ~PIPEWRITEDMA_USR_CLEAR_MASK) | (((uint32_t)val) << PIPEWRITEDMA_USR_CLEAR_SHIFT))

#define  PIPEWRITEDMA_USR_BUSY_MASK 0x1
#define  PIPEWRITEDMA_USR_BUSY_SHIFT 0
#define  PIPEWRITEDMA_USR_BUSY_MASK_SHIFT(reg) (((reg) & PIPEWRITEDMA_USR_BUSY_MASK) >> PIPEWRITEDMA_USR_BUSY_SHIFT)
#define  PIPEWRITEDMA_USR_BUSY_REPLACE_VAL(reg,val) (((reg) & ~PIPEWRITEDMA_USR_BUSY_MASK) | (((uint32_t)val) << PIPEWRITEDMA_USR_BUSY_SHIFT))

//====================================================================
//Register: UDMA Parameter Register (UPR)
//====================================================================

#define  PIPEWRITEDMA_UPR_RESERVED1_MASK 0xff000000
#define  PIPEWRITEDMA_UPR_RESERVED1_SHIFT 24
#define  PIPEWRITEDMA_UPR_RESERVED1_MASK_SHIFT(reg) (((reg) & PIPEWRITEDMA_UPR_RESERVED1_MASK) >> PIPEWRITEDMA_UPR_RESERVED1_SHIFT)
#define  PIPEWRITEDMA_UPR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PIPEWRITEDMA_UPR_RESERVED1_MASK) | (((uint32_t)val) << PIPEWRITEDMA_UPR_RESERVED1_SHIFT))

#define  PIPEWRITEDMA_UPR_FIFODEPTH_MASK 0xffff00
#define  PIPEWRITEDMA_UPR_FIFODEPTH_SHIFT 8
#define  PIPEWRITEDMA_UPR_FIFODEPTH_MASK_SHIFT(reg) (((reg) & PIPEWRITEDMA_UPR_FIFODEPTH_MASK) >> PIPEWRITEDMA_UPR_FIFODEPTH_SHIFT)
#define  PIPEWRITEDMA_UPR_FIFODEPTH_REPLACE_VAL(reg,val) (((reg) & ~PIPEWRITEDMA_UPR_FIFODEPTH_MASK) | (((uint32_t)val) << PIPEWRITEDMA_UPR_FIFODEPTH_SHIFT))

#define  PIPEWRITEDMA_UPR_RESERVED2_MASK 0xe0
#define  PIPEWRITEDMA_UPR_RESERVED2_SHIFT 5
#define  PIPEWRITEDMA_UPR_RESERVED2_MASK_SHIFT(reg) (((reg) & PIPEWRITEDMA_UPR_RESERVED2_MASK) >> PIPEWRITEDMA_UPR_RESERVED2_SHIFT)
#define  PIPEWRITEDMA_UPR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~PIPEWRITEDMA_UPR_RESERVED2_MASK) | (((uint32_t)val) << PIPEWRITEDMA_UPR_RESERVED2_SHIFT))

#define  PIPEWRITEDMA_UPR_SERPSUPPORT_MASK 0x10
#define  PIPEWRITEDMA_UPR_SERPSUPPORT_SHIFT 4
#define  PIPEWRITEDMA_UPR_SERPSUPPORT_MASK_SHIFT(reg) (((reg) & PIPEWRITEDMA_UPR_SERPSUPPORT_MASK) >> PIPEWRITEDMA_UPR_SERPSUPPORT_SHIFT)
#define  PIPEWRITEDMA_UPR_SERPSUPPORT_REPLACE_VAL(reg,val) (((reg) & ~PIPEWRITEDMA_UPR_SERPSUPPORT_MASK) | (((uint32_t)val) << PIPEWRITEDMA_UPR_SERPSUPPORT_SHIFT))

#define  PIPEWRITEDMA_UPR_DESCLENGTH_MASK 0x8
#define  PIPEWRITEDMA_UPR_DESCLENGTH_SHIFT 3
#define  PIPEWRITEDMA_UPR_DESCLENGTH_MASK_SHIFT(reg) (((reg) & PIPEWRITEDMA_UPR_DESCLENGTH_MASK) >> PIPEWRITEDMA_UPR_DESCLENGTH_SHIFT)
#define  PIPEWRITEDMA_UPR_DESCLENGTH_REPLACE_VAL(reg,val) (((reg) & ~PIPEWRITEDMA_UPR_DESCLENGTH_MASK) | (((uint32_t)val) << PIPEWRITEDMA_UPR_DESCLENGTH_SHIFT))

#define  PIPEWRITEDMA_UPR_BUSWIDTH_MASK 0x4
#define  PIPEWRITEDMA_UPR_BUSWIDTH_SHIFT 2
#define  PIPEWRITEDMA_UPR_BUSWIDTH_MASK_SHIFT(reg) (((reg) & PIPEWRITEDMA_UPR_BUSWIDTH_MASK) >> PIPEWRITEDMA_UPR_BUSWIDTH_SHIFT)
#define  PIPEWRITEDMA_UPR_BUSWIDTH_REPLACE_VAL(reg,val) (((reg) & ~PIPEWRITEDMA_UPR_BUSWIDTH_MASK) | (((uint32_t)val) << PIPEWRITEDMA_UPR_BUSWIDTH_SHIFT))

#define  PIPEWRITEDMA_UPR_MEMALIGN_MASK 0x3
#define  PIPEWRITEDMA_UPR_MEMALIGN_SHIFT 0
#define  PIPEWRITEDMA_UPR_MEMALIGN_MASK_SHIFT(reg) (((reg) & PIPEWRITEDMA_UPR_MEMALIGN_MASK) >> PIPEWRITEDMA_UPR_MEMALIGN_SHIFT)
#define  PIPEWRITEDMA_UPR_MEMALIGN_REPLACE_VAL(reg,val) (((reg) & ~PIPEWRITEDMA_UPR_MEMALIGN_MASK) | (((uint32_t)val) << PIPEWRITEDMA_UPR_MEMALIGN_SHIFT))

//====================================================================
//Register: UDMA Interrupt Enable Register (UIER)
//====================================================================

#define  PIPEWRITEDMA_UIER_RESERVED1_MASK 0xffffffc0
#define  PIPEWRITEDMA_UIER_RESERVED1_SHIFT 6
#define  PIPEWRITEDMA_UIER_RESERVED1_MASK_SHIFT(reg) (((reg) & PIPEWRITEDMA_UIER_RESERVED1_MASK) >> PIPEWRITEDMA_UIER_RESERVED1_SHIFT)
#define  PIPEWRITEDMA_UIER_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PIPEWRITEDMA_UIER_RESERVED1_MASK) | (((uint32_t)val) << PIPEWRITEDMA_UIER_RESERVED1_SHIFT))

#define  PIPEWRITEDMA_UIER_OUTOFRANGE_MASK 0x20
#define  PIPEWRITEDMA_UIER_OUTOFRANGE_SHIFT 5
#define  PIPEWRITEDMA_UIER_OUTOFRANGE_MASK_SHIFT(reg) (((reg) & PIPEWRITEDMA_UIER_OUTOFRANGE_MASK) >> PIPEWRITEDMA_UIER_OUTOFRANGE_SHIFT)
#define  PIPEWRITEDMA_UIER_OUTOFRANGE_REPLACE_VAL(reg,val) (((reg) & ~PIPEWRITEDMA_UIER_OUTOFRANGE_MASK) | (((uint32_t)val) << PIPEWRITEDMA_UIER_OUTOFRANGE_SHIFT))

#define  PIPEWRITEDMA_UIER_RRESP_MASK 0x10
#define  PIPEWRITEDMA_UIER_RRESP_SHIFT 4
#define  PIPEWRITEDMA_UIER_RRESP_MASK_SHIFT(reg) (((reg) & PIPEWRITEDMA_UIER_RRESP_MASK) >> PIPEWRITEDMA_UIER_RRESP_SHIFT)
#define  PIPEWRITEDMA_UIER_RRESP_REPLACE_VAL(reg,val) (((reg) & ~PIPEWRITEDMA_UIER_RRESP_MASK) | (((uint32_t)val) << PIPEWRITEDMA_UIER_RRESP_SHIFT))

#define  PIPEWRITEDMA_UIER_BRESP_MASK 0x8
#define  PIPEWRITEDMA_UIER_BRESP_SHIFT 3
#define  PIPEWRITEDMA_UIER_BRESP_MASK_SHIFT(reg) (((reg) & PIPEWRITEDMA_UIER_BRESP_MASK) >> PIPEWRITEDMA_UIER_BRESP_SHIFT)
#define  PIPEWRITEDMA_UIER_BRESP_REPLACE_VAL(reg,val) (((reg) & ~PIPEWRITEDMA_UIER_BRESP_MASK) | (((uint32_t)val) << PIPEWRITEDMA_UIER_BRESP_SHIFT))

#define  PIPEWRITEDMA_UIER_CLEARCOMPLETE_MASK 0x4
#define  PIPEWRITEDMA_UIER_CLEARCOMPLETE_SHIFT 2
#define  PIPEWRITEDMA_UIER_CLEARCOMPLETE_MASK_SHIFT(reg) (((reg) & PIPEWRITEDMA_UIER_CLEARCOMPLETE_MASK) >> PIPEWRITEDMA_UIER_CLEARCOMPLETE_SHIFT)
#define  PIPEWRITEDMA_UIER_CLEARCOMPLETE_REPLACE_VAL(reg,val) (((reg) & ~PIPEWRITEDMA_UIER_CLEARCOMPLETE_MASK) | (((uint32_t)val) << PIPEWRITEDMA_UIER_CLEARCOMPLETE_SHIFT))

#define  PIPEWRITEDMA_UIER_DESC_MASK 0x2
#define  PIPEWRITEDMA_UIER_DESC_SHIFT 1
#define  PIPEWRITEDMA_UIER_DESC_MASK_SHIFT(reg) (((reg) & PIPEWRITEDMA_UIER_DESC_MASK) >> PIPEWRITEDMA_UIER_DESC_SHIFT)
#define  PIPEWRITEDMA_UIER_DESC_REPLACE_VAL(reg,val) (((reg) & ~PIPEWRITEDMA_UIER_DESC_MASK) | (((uint32_t)val) << PIPEWRITEDMA_UIER_DESC_SHIFT))

#define  PIPEWRITEDMA_UIER_OWN_MASK 0x1
#define  PIPEWRITEDMA_UIER_OWN_SHIFT 0
#define  PIPEWRITEDMA_UIER_OWN_MASK_SHIFT(reg) (((reg) & PIPEWRITEDMA_UIER_OWN_MASK) >> PIPEWRITEDMA_UIER_OWN_SHIFT)
#define  PIPEWRITEDMA_UIER_OWN_REPLACE_VAL(reg,val) (((reg) & ~PIPEWRITEDMA_UIER_OWN_MASK) | (((uint32_t)val) << PIPEWRITEDMA_UIER_OWN_SHIFT))

//====================================================================
//Register: UDMA Interrupt Pending Register (UIPR)
//====================================================================

#define  PIPEWRITEDMA_UIPR_RESERVED1_MASK 0xffffffc0
#define  PIPEWRITEDMA_UIPR_RESERVED1_SHIFT 6
#define  PIPEWRITEDMA_UIPR_RESERVED1_MASK_SHIFT(reg) (((reg) & PIPEWRITEDMA_UIPR_RESERVED1_MASK) >> PIPEWRITEDMA_UIPR_RESERVED1_SHIFT)
#define  PIPEWRITEDMA_UIPR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PIPEWRITEDMA_UIPR_RESERVED1_MASK) | (((uint32_t)val) << PIPEWRITEDMA_UIPR_RESERVED1_SHIFT))

#define  PIPEWRITEDMA_UIPR_OUTOFRANGE_MASK 0x20
#define  PIPEWRITEDMA_UIPR_OUTOFRANGE_SHIFT 5
#define  PIPEWRITEDMA_UIPR_OUTOFRANGE_MASK_SHIFT(reg) (((reg) & PIPEWRITEDMA_UIPR_OUTOFRANGE_MASK) >> PIPEWRITEDMA_UIPR_OUTOFRANGE_SHIFT)
#define  PIPEWRITEDMA_UIPR_OUTOFRANGE_REPLACE_VAL(reg,val) (((reg) & ~PIPEWRITEDMA_UIPR_OUTOFRANGE_MASK) | (((uint32_t)val) << PIPEWRITEDMA_UIPR_OUTOFRANGE_SHIFT))

#define  PIPEWRITEDMA_UIPR_RRESP_MASK 0x10
#define  PIPEWRITEDMA_UIPR_RRESP_SHIFT 4
#define  PIPEWRITEDMA_UIPR_RRESP_MASK_SHIFT(reg) (((reg) & PIPEWRITEDMA_UIPR_RRESP_MASK) >> PIPEWRITEDMA_UIPR_RRESP_SHIFT)
#define  PIPEWRITEDMA_UIPR_RRESP_REPLACE_VAL(reg,val) (((reg) & ~PIPEWRITEDMA_UIPR_RRESP_MASK) | (((uint32_t)val) << PIPEWRITEDMA_UIPR_RRESP_SHIFT))

#define  PIPEWRITEDMA_UIPR_BRESP_MASK 0x8
#define  PIPEWRITEDMA_UIPR_BRESP_SHIFT 3
#define  PIPEWRITEDMA_UIPR_BRESP_MASK_SHIFT(reg) (((reg) & PIPEWRITEDMA_UIPR_BRESP_MASK) >> PIPEWRITEDMA_UIPR_BRESP_SHIFT)
#define  PIPEWRITEDMA_UIPR_BRESP_REPLACE_VAL(reg,val) (((reg) & ~PIPEWRITEDMA_UIPR_BRESP_MASK) | (((uint32_t)val) << PIPEWRITEDMA_UIPR_BRESP_SHIFT))

#define  PIPEWRITEDMA_UIPR_CLEARCOMPLETE_MASK 0x4
#define  PIPEWRITEDMA_UIPR_CLEARCOMPLETE_SHIFT 2
#define  PIPEWRITEDMA_UIPR_CLEARCOMPLETE_MASK_SHIFT(reg) (((reg) & PIPEWRITEDMA_UIPR_CLEARCOMPLETE_MASK) >> PIPEWRITEDMA_UIPR_CLEARCOMPLETE_SHIFT)
#define  PIPEWRITEDMA_UIPR_CLEARCOMPLETE_REPLACE_VAL(reg,val) (((reg) & ~PIPEWRITEDMA_UIPR_CLEARCOMPLETE_MASK) | (((uint32_t)val) << PIPEWRITEDMA_UIPR_CLEARCOMPLETE_SHIFT))

#define  PIPEWRITEDMA_UIPR_DESC_MASK 0x2
#define  PIPEWRITEDMA_UIPR_DESC_SHIFT 1
#define  PIPEWRITEDMA_UIPR_DESC_MASK_SHIFT(reg) (((reg) & PIPEWRITEDMA_UIPR_DESC_MASK) >> PIPEWRITEDMA_UIPR_DESC_SHIFT)
#define  PIPEWRITEDMA_UIPR_DESC_REPLACE_VAL(reg,val) (((reg) & ~PIPEWRITEDMA_UIPR_DESC_MASK) | (((uint32_t)val) << PIPEWRITEDMA_UIPR_DESC_SHIFT))

#define  PIPEWRITEDMA_UIPR_OWN_MASK 0x1
#define  PIPEWRITEDMA_UIPR_OWN_SHIFT 0
#define  PIPEWRITEDMA_UIPR_OWN_MASK_SHIFT(reg) (((reg) & PIPEWRITEDMA_UIPR_OWN_MASK) >> PIPEWRITEDMA_UIPR_OWN_SHIFT)
#define  PIPEWRITEDMA_UIPR_OWN_REPLACE_VAL(reg,val) (((reg) & ~PIPEWRITEDMA_UIPR_OWN_MASK) | (((uint32_t)val) << PIPEWRITEDMA_UIPR_OWN_SHIFT))

//====================================================================
//Register: UDMA Interrupt Clear Register (UICR)
//====================================================================

#define  PIPEWRITEDMA_UICR_RESERVED1_MASK 0xffffffc0
#define  PIPEWRITEDMA_UICR_RESERVED1_SHIFT 6
#define  PIPEWRITEDMA_UICR_RESERVED1_MASK_SHIFT(reg) (((reg) & PIPEWRITEDMA_UICR_RESERVED1_MASK) >> PIPEWRITEDMA_UICR_RESERVED1_SHIFT)
#define  PIPEWRITEDMA_UICR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PIPEWRITEDMA_UICR_RESERVED1_MASK) | (((uint32_t)val) << PIPEWRITEDMA_UICR_RESERVED1_SHIFT))

#define  PIPEWRITEDMA_UICR_OUTOFRANGE_MASK 0x20
#define  PIPEWRITEDMA_UICR_OUTOFRANGE_SHIFT 5
#define  PIPEWRITEDMA_UICR_OUTOFRANGE_MASK_SHIFT(reg) (((reg) & PIPEWRITEDMA_UICR_OUTOFRANGE_MASK) >> PIPEWRITEDMA_UICR_OUTOFRANGE_SHIFT)
#define  PIPEWRITEDMA_UICR_OUTOFRANGE_REPLACE_VAL(reg,val) (((reg) & ~PIPEWRITEDMA_UICR_OUTOFRANGE_MASK) | (((uint32_t)val) << PIPEWRITEDMA_UICR_OUTOFRANGE_SHIFT))

#define  PIPEWRITEDMA_UICR_RRESP_MASK 0x10
#define  PIPEWRITEDMA_UICR_RRESP_SHIFT 4
#define  PIPEWRITEDMA_UICR_RRESP_MASK_SHIFT(reg) (((reg) & PIPEWRITEDMA_UICR_RRESP_MASK) >> PIPEWRITEDMA_UICR_RRESP_SHIFT)
#define  PIPEWRITEDMA_UICR_RRESP_REPLACE_VAL(reg,val) (((reg) & ~PIPEWRITEDMA_UICR_RRESP_MASK) | (((uint32_t)val) << PIPEWRITEDMA_UICR_RRESP_SHIFT))

#define  PIPEWRITEDMA_UICR_BRESP_MASK 0x8
#define  PIPEWRITEDMA_UICR_BRESP_SHIFT 3
#define  PIPEWRITEDMA_UICR_BRESP_MASK_SHIFT(reg) (((reg) & PIPEWRITEDMA_UICR_BRESP_MASK) >> PIPEWRITEDMA_UICR_BRESP_SHIFT)
#define  PIPEWRITEDMA_UICR_BRESP_REPLACE_VAL(reg,val) (((reg) & ~PIPEWRITEDMA_UICR_BRESP_MASK) | (((uint32_t)val) << PIPEWRITEDMA_UICR_BRESP_SHIFT))

#define  PIPEWRITEDMA_UICR_CLEARCOMPLETE_MASK 0x4
#define  PIPEWRITEDMA_UICR_CLEARCOMPLETE_SHIFT 2
#define  PIPEWRITEDMA_UICR_CLEARCOMPLETE_MASK_SHIFT(reg) (((reg) & PIPEWRITEDMA_UICR_CLEARCOMPLETE_MASK) >> PIPEWRITEDMA_UICR_CLEARCOMPLETE_SHIFT)
#define  PIPEWRITEDMA_UICR_CLEARCOMPLETE_REPLACE_VAL(reg,val) (((reg) & ~PIPEWRITEDMA_UICR_CLEARCOMPLETE_MASK) | (((uint32_t)val) << PIPEWRITEDMA_UICR_CLEARCOMPLETE_SHIFT))

#define  PIPEWRITEDMA_UICR_DESC_MASK 0x2
#define  PIPEWRITEDMA_UICR_DESC_SHIFT 1
#define  PIPEWRITEDMA_UICR_DESC_MASK_SHIFT(reg) (((reg) & PIPEWRITEDMA_UICR_DESC_MASK) >> PIPEWRITEDMA_UICR_DESC_SHIFT)
#define  PIPEWRITEDMA_UICR_DESC_REPLACE_VAL(reg,val) (((reg) & ~PIPEWRITEDMA_UICR_DESC_MASK) | (((uint32_t)val) << PIPEWRITEDMA_UICR_DESC_SHIFT))

#define  PIPEWRITEDMA_UICR_OWN_MASK 0x1
#define  PIPEWRITEDMA_UICR_OWN_SHIFT 0
#define  PIPEWRITEDMA_UICR_OWN_MASK_SHIFT(reg) (((reg) & PIPEWRITEDMA_UICR_OWN_MASK) >> PIPEWRITEDMA_UICR_OWN_SHIFT)
#define  PIPEWRITEDMA_UICR_OWN_REPLACE_VAL(reg,val) (((reg) & ~PIPEWRITEDMA_UICR_OWN_MASK) | (((uint32_t)val) << PIPEWRITEDMA_UICR_OWN_SHIFT))

//====================================================================
//Register: UDMA Interrupt Force Register (UIFR)
//====================================================================

#define  PIPEWRITEDMA_UIFR_RESERVED1_MASK 0xffffffc0
#define  PIPEWRITEDMA_UIFR_RESERVED1_SHIFT 6
#define  PIPEWRITEDMA_UIFR_RESERVED1_MASK_SHIFT(reg) (((reg) & PIPEWRITEDMA_UIFR_RESERVED1_MASK) >> PIPEWRITEDMA_UIFR_RESERVED1_SHIFT)
#define  PIPEWRITEDMA_UIFR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PIPEWRITEDMA_UIFR_RESERVED1_MASK) | (((uint32_t)val) << PIPEWRITEDMA_UIFR_RESERVED1_SHIFT))

#define  PIPEWRITEDMA_UIFR_OUTOFRANGE_MASK 0x20
#define  PIPEWRITEDMA_UIFR_OUTOFRANGE_SHIFT 5
#define  PIPEWRITEDMA_UIFR_OUTOFRANGE_MASK_SHIFT(reg) (((reg) & PIPEWRITEDMA_UIFR_OUTOFRANGE_MASK) >> PIPEWRITEDMA_UIFR_OUTOFRANGE_SHIFT)
#define  PIPEWRITEDMA_UIFR_OUTOFRANGE_REPLACE_VAL(reg,val) (((reg) & ~PIPEWRITEDMA_UIFR_OUTOFRANGE_MASK) | (((uint32_t)val) << PIPEWRITEDMA_UIFR_OUTOFRANGE_SHIFT))

#define  PIPEWRITEDMA_UIFR_RRESP_MASK 0x10
#define  PIPEWRITEDMA_UIFR_RRESP_SHIFT 4
#define  PIPEWRITEDMA_UIFR_RRESP_MASK_SHIFT(reg) (((reg) & PIPEWRITEDMA_UIFR_RRESP_MASK) >> PIPEWRITEDMA_UIFR_RRESP_SHIFT)
#define  PIPEWRITEDMA_UIFR_RRESP_REPLACE_VAL(reg,val) (((reg) & ~PIPEWRITEDMA_UIFR_RRESP_MASK) | (((uint32_t)val) << PIPEWRITEDMA_UIFR_RRESP_SHIFT))

#define  PIPEWRITEDMA_UIFR_BRESP_MASK 0x8
#define  PIPEWRITEDMA_UIFR_BRESP_SHIFT 3
#define  PIPEWRITEDMA_UIFR_BRESP_MASK_SHIFT(reg) (((reg) & PIPEWRITEDMA_UIFR_BRESP_MASK) >> PIPEWRITEDMA_UIFR_BRESP_SHIFT)
#define  PIPEWRITEDMA_UIFR_BRESP_REPLACE_VAL(reg,val) (((reg) & ~PIPEWRITEDMA_UIFR_BRESP_MASK) | (((uint32_t)val) << PIPEWRITEDMA_UIFR_BRESP_SHIFT))

#define  PIPEWRITEDMA_UIFR_CLEARCOMPLETE_MASK 0x4
#define  PIPEWRITEDMA_UIFR_CLEARCOMPLETE_SHIFT 2
#define  PIPEWRITEDMA_UIFR_CLEARCOMPLETE_MASK_SHIFT(reg) (((reg) & PIPEWRITEDMA_UIFR_CLEARCOMPLETE_MASK) >> PIPEWRITEDMA_UIFR_CLEARCOMPLETE_SHIFT)
#define  PIPEWRITEDMA_UIFR_CLEARCOMPLETE_REPLACE_VAL(reg,val) (((reg) & ~PIPEWRITEDMA_UIFR_CLEARCOMPLETE_MASK) | (((uint32_t)val) << PIPEWRITEDMA_UIFR_CLEARCOMPLETE_SHIFT))

#define  PIPEWRITEDMA_UIFR_DESC_MASK 0x2
#define  PIPEWRITEDMA_UIFR_DESC_SHIFT 1
#define  PIPEWRITEDMA_UIFR_DESC_MASK_SHIFT(reg) (((reg) & PIPEWRITEDMA_UIFR_DESC_MASK) >> PIPEWRITEDMA_UIFR_DESC_SHIFT)
#define  PIPEWRITEDMA_UIFR_DESC_REPLACE_VAL(reg,val) (((reg) & ~PIPEWRITEDMA_UIFR_DESC_MASK) | (((uint32_t)val) << PIPEWRITEDMA_UIFR_DESC_SHIFT))

#define  PIPEWRITEDMA_UIFR_OWN_MASK 0x1
#define  PIPEWRITEDMA_UIFR_OWN_SHIFT 0
#define  PIPEWRITEDMA_UIFR_OWN_MASK_SHIFT(reg) (((reg) & PIPEWRITEDMA_UIFR_OWN_MASK) >> PIPEWRITEDMA_UIFR_OWN_SHIFT)
#define  PIPEWRITEDMA_UIFR_OWN_REPLACE_VAL(reg,val) (((reg) & ~PIPEWRITEDMA_UIFR_OWN_MASK) | (((uint32_t)val) << PIPEWRITEDMA_UIFR_OWN_SHIFT))

//====================================================================
//Register: UDMA Descriptor Register (UDR)
//====================================================================

#define  PIPEWRITEDMA_UDR_DESC_MASK 0xffffffff
#define  PIPEWRITEDMA_UDR_DESC_SHIFT 0
#define  PIPEWRITEDMA_UDR_DESC_MASK_SHIFT(reg) (((reg) & PIPEWRITEDMA_UDR_DESC_MASK) >> PIPEWRITEDMA_UDR_DESC_SHIFT)
#define  PIPEWRITEDMA_UDR_DESC_REPLACE_VAL(reg,val) (((reg) & ~PIPEWRITEDMA_UDR_DESC_MASK) | (((uint32_t)val) << PIPEWRITEDMA_UDR_DESC_SHIFT))

//====================================================================
//Register: UDMA Burst Address Register (UBAR)
//====================================================================

#define  PIPEWRITEDMA_UBAR_BURSTADDR_MASK 0xffffffff
#define  PIPEWRITEDMA_UBAR_BURSTADDR_SHIFT 0
#define  PIPEWRITEDMA_UBAR_BURSTADDR_MASK_SHIFT(reg) (((reg) & PIPEWRITEDMA_UBAR_BURSTADDR_MASK) >> PIPEWRITEDMA_UBAR_BURSTADDR_SHIFT)
#define  PIPEWRITEDMA_UBAR_BURSTADDR_REPLACE_VAL(reg,val) (((reg) & ~PIPEWRITEDMA_UBAR_BURSTADDR_MASK) | (((uint32_t)val) << PIPEWRITEDMA_UBAR_BURSTADDR_SHIFT))

//====================================================================
//Register: UDMA Burst Length Register (UBLR)
//====================================================================

#define  PIPEWRITEDMA_UBLR_RESERVED1_MASK 0xfffffc00
#define  PIPEWRITEDMA_UBLR_RESERVED1_SHIFT 10
#define  PIPEWRITEDMA_UBLR_RESERVED1_MASK_SHIFT(reg) (((reg) & PIPEWRITEDMA_UBLR_RESERVED1_MASK) >> PIPEWRITEDMA_UBLR_RESERVED1_SHIFT)
#define  PIPEWRITEDMA_UBLR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PIPEWRITEDMA_UBLR_RESERVED1_MASK) | (((uint32_t)val) << PIPEWRITEDMA_UBLR_RESERVED1_SHIFT))

#define  PIPEWRITEDMA_UBLR_BURSTDIR_MASK 0x200
#define  PIPEWRITEDMA_UBLR_BURSTDIR_SHIFT 9
#define  PIPEWRITEDMA_UBLR_BURSTDIR_MASK_SHIFT(reg) (((reg) & PIPEWRITEDMA_UBLR_BURSTDIR_MASK) >> PIPEWRITEDMA_UBLR_BURSTDIR_SHIFT)
#define  PIPEWRITEDMA_UBLR_BURSTDIR_REPLACE_VAL(reg,val) (((reg) & ~PIPEWRITEDMA_UBLR_BURSTDIR_MASK) | (((uint32_t)val) << PIPEWRITEDMA_UBLR_BURSTDIR_SHIFT))

#define  PIPEWRITEDMA_UBLR_BURSTLAST_MASK 0x100
#define  PIPEWRITEDMA_UBLR_BURSTLAST_SHIFT 8
#define  PIPEWRITEDMA_UBLR_BURSTLAST_MASK_SHIFT(reg) (((reg) & PIPEWRITEDMA_UBLR_BURSTLAST_MASK) >> PIPEWRITEDMA_UBLR_BURSTLAST_SHIFT)
#define  PIPEWRITEDMA_UBLR_BURSTLAST_REPLACE_VAL(reg,val) (((reg) & ~PIPEWRITEDMA_UBLR_BURSTLAST_MASK) | (((uint32_t)val) << PIPEWRITEDMA_UBLR_BURSTLAST_SHIFT))

#define  PIPEWRITEDMA_UBLR_BURSTLENGTH_MASK 0xff
#define  PIPEWRITEDMA_UBLR_BURSTLENGTH_SHIFT 0
#define  PIPEWRITEDMA_UBLR_BURSTLENGTH_MASK_SHIFT(reg) (((reg) & PIPEWRITEDMA_UBLR_BURSTLENGTH_MASK) >> PIPEWRITEDMA_UBLR_BURSTLENGTH_SHIFT)
#define  PIPEWRITEDMA_UBLR_BURSTLENGTH_REPLACE_VAL(reg,val) (((reg) & ~PIPEWRITEDMA_UBLR_BURSTLENGTH_MASK) | (((uint32_t)val) << PIPEWRITEDMA_UBLR_BURSTLENGTH_SHIFT))

//====================================================================
//Register: UDMA Transfer Bytes Remaining Register (UBRR)
//====================================================================

#define  PIPEWRITEDMA_UBRR_BYTESREMAIN_MASK 0xffffffff
#define  PIPEWRITEDMA_UBRR_BYTESREMAIN_SHIFT 0
#define  PIPEWRITEDMA_UBRR_BYTESREMAIN_MASK_SHIFT(reg) (((reg) & PIPEWRITEDMA_UBRR_BYTESREMAIN_MASK) >> PIPEWRITEDMA_UBRR_BYTESREMAIN_SHIFT)
#define  PIPEWRITEDMA_UBRR_BYTESREMAIN_REPLACE_VAL(reg,val) (((reg) & ~PIPEWRITEDMA_UBRR_BYTESREMAIN_MASK) | (((uint32_t)val) << PIPEWRITEDMA_UBRR_BYTESREMAIN_SHIFT))

//====================================================================
//Register: UDMA Tag Register 0 (UTR0)
//====================================================================

#define  PIPEWRITEDMA_UTR0_TAGMAJ_MASK 0xffff0000
#define  PIPEWRITEDMA_UTR0_TAGMAJ_SHIFT 16
#define  PIPEWRITEDMA_UTR0_TAGMAJ_MASK_SHIFT(reg) (((reg) & PIPEWRITEDMA_UTR0_TAGMAJ_MASK) >> PIPEWRITEDMA_UTR0_TAGMAJ_SHIFT)
#define  PIPEWRITEDMA_UTR0_TAGMAJ_REPLACE_VAL(reg,val) (((reg) & ~PIPEWRITEDMA_UTR0_TAGMAJ_MASK) | (((uint32_t)val) << PIPEWRITEDMA_UTR0_TAGMAJ_SHIFT))

#define  PIPEWRITEDMA_UTR0_TAGMID_MASK 0xffff
#define  PIPEWRITEDMA_UTR0_TAGMID_SHIFT 0
#define  PIPEWRITEDMA_UTR0_TAGMID_MASK_SHIFT(reg) (((reg) & PIPEWRITEDMA_UTR0_TAGMID_MASK) >> PIPEWRITEDMA_UTR0_TAGMID_SHIFT)
#define  PIPEWRITEDMA_UTR0_TAGMID_REPLACE_VAL(reg,val) (((reg) & ~PIPEWRITEDMA_UTR0_TAGMID_MASK) | (((uint32_t)val) << PIPEWRITEDMA_UTR0_TAGMID_SHIFT))

//====================================================================
//Register: UDMA Tag Register 1 (UTR1)
//====================================================================

#define  PIPEWRITEDMA_UTR1_RESERVED1_MASK 0xffff0000
#define  PIPEWRITEDMA_UTR1_RESERVED1_SHIFT 16
#define  PIPEWRITEDMA_UTR1_RESERVED1_MASK_SHIFT(reg) (((reg) & PIPEWRITEDMA_UTR1_RESERVED1_MASK) >> PIPEWRITEDMA_UTR1_RESERVED1_SHIFT)
#define  PIPEWRITEDMA_UTR1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PIPEWRITEDMA_UTR1_RESERVED1_MASK) | (((uint32_t)val) << PIPEWRITEDMA_UTR1_RESERVED1_SHIFT))

#define  PIPEWRITEDMA_UTR1_TAGCFG_MASK 0xffff
#define  PIPEWRITEDMA_UTR1_TAGCFG_SHIFT 0
#define  PIPEWRITEDMA_UTR1_TAGCFG_MASK_SHIFT(reg) (((reg) & PIPEWRITEDMA_UTR1_TAGCFG_MASK) >> PIPEWRITEDMA_UTR1_TAGCFG_SHIFT)
#define  PIPEWRITEDMA_UTR1_TAGCFG_REPLACE_VAL(reg,val) (((reg) & ~PIPEWRITEDMA_UTR1_TAGCFG_MASK) | (((uint32_t)val) << PIPEWRITEDMA_UTR1_TAGCFG_SHIFT))

//====================================================================
//
//Register File: Reload DMA register set (PipeReadDMA)
//
//====================================================================

//====================================================================
//Register: UDMA Configuration Register (UCR)
//====================================================================

#define  PIPEREADDMA_UCR_RESERVED1_MASK 0xfff00000
#define  PIPEREADDMA_UCR_RESERVED1_SHIFT 20
#define  PIPEREADDMA_UCR_RESERVED1_MASK_SHIFT(reg) (((reg) & PIPEREADDMA_UCR_RESERVED1_MASK) >> PIPEREADDMA_UCR_RESERVED1_SHIFT)
#define  PIPEREADDMA_UCR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PIPEREADDMA_UCR_RESERVED1_MASK) | (((uint32_t)val) << PIPEREADDMA_UCR_RESERVED1_SHIFT))

#define  PIPEREADDMA_UCR_DATAAXCACHE_MASK 0xf0000
#define  PIPEREADDMA_UCR_DATAAXCACHE_SHIFT 16
#define  PIPEREADDMA_UCR_DATAAXCACHE_MASK_SHIFT(reg) (((reg) & PIPEREADDMA_UCR_DATAAXCACHE_MASK) >> PIPEREADDMA_UCR_DATAAXCACHE_SHIFT)
#define  PIPEREADDMA_UCR_DATAAXCACHE_REPLACE_VAL(reg,val) (((reg) & ~PIPEREADDMA_UCR_DATAAXCACHE_MASK) | (((uint32_t)val) << PIPEREADDMA_UCR_DATAAXCACHE_SHIFT))

#define  PIPEREADDMA_UCR_DESCARCACHE_MASK 0xf000
#define  PIPEREADDMA_UCR_DESCARCACHE_SHIFT 12
#define  PIPEREADDMA_UCR_DESCARCACHE_MASK_SHIFT(reg) (((reg) & PIPEREADDMA_UCR_DESCARCACHE_MASK) >> PIPEREADDMA_UCR_DESCARCACHE_SHIFT)
#define  PIPEREADDMA_UCR_DESCARCACHE_REPLACE_VAL(reg,val) (((reg) & ~PIPEREADDMA_UCR_DESCARCACHE_MASK) | (((uint32_t)val) << PIPEREADDMA_UCR_DESCARCACHE_SHIFT))

#define  PIPEREADDMA_UCR_DESCAWCACHE_MASK 0xf00
#define  PIPEREADDMA_UCR_DESCAWCACHE_SHIFT 8
#define  PIPEREADDMA_UCR_DESCAWCACHE_MASK_SHIFT(reg) (((reg) & PIPEREADDMA_UCR_DESCAWCACHE_MASK) >> PIPEREADDMA_UCR_DESCAWCACHE_SHIFT)
#define  PIPEREADDMA_UCR_DESCAWCACHE_REPLACE_VAL(reg,val) (((reg) & ~PIPEREADDMA_UCR_DESCAWCACHE_MASK) | (((uint32_t)val) << PIPEREADDMA_UCR_DESCAWCACHE_SHIFT))

#define  PIPEREADDMA_UCR_RESERVED2_MASK 0xc0
#define  PIPEREADDMA_UCR_RESERVED2_SHIFT 6
#define  PIPEREADDMA_UCR_RESERVED2_MASK_SHIFT(reg) (((reg) & PIPEREADDMA_UCR_RESERVED2_MASK) >> PIPEREADDMA_UCR_RESERVED2_SHIFT)
#define  PIPEREADDMA_UCR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~PIPEREADDMA_UCR_RESERVED2_MASK) | (((uint32_t)val) << PIPEREADDMA_UCR_RESERVED2_SHIFT))

#define  PIPEREADDMA_UCR_HANDSHAKEENABLE_MASK 0x20
#define  PIPEREADDMA_UCR_HANDSHAKEENABLE_SHIFT 5
#define  PIPEREADDMA_UCR_HANDSHAKEENABLE_MASK_SHIFT(reg) (((reg) & PIPEREADDMA_UCR_HANDSHAKEENABLE_MASK) >> PIPEREADDMA_UCR_HANDSHAKEENABLE_SHIFT)
#define  PIPEREADDMA_UCR_HANDSHAKEENABLE_REPLACE_VAL(reg,val) (((reg) & ~PIPEREADDMA_UCR_HANDSHAKEENABLE_MASK) | (((uint32_t)val) << PIPEREADDMA_UCR_HANDSHAKEENABLE_SHIFT))

#define  PIPEREADDMA_UCR_OWNWRITEDISABLE_MASK 0x10
#define  PIPEREADDMA_UCR_OWNWRITEDISABLE_SHIFT 4
#define  PIPEREADDMA_UCR_OWNWRITEDISABLE_MASK_SHIFT(reg) (((reg) & PIPEREADDMA_UCR_OWNWRITEDISABLE_MASK) >> PIPEREADDMA_UCR_OWNWRITEDISABLE_SHIFT)
#define  PIPEREADDMA_UCR_OWNWRITEDISABLE_REPLACE_VAL(reg,val) (((reg) & ~PIPEREADDMA_UCR_OWNWRITEDISABLE_MASK) | (((uint32_t)val) << PIPEREADDMA_UCR_OWNWRITEDISABLE_SHIFT))

#define  PIPEREADDMA_UCR_OWNPOLARITY_MASK 0x8
#define  PIPEREADDMA_UCR_OWNPOLARITY_SHIFT 3
#define  PIPEREADDMA_UCR_OWNPOLARITY_MASK_SHIFT(reg) (((reg) & PIPEREADDMA_UCR_OWNPOLARITY_MASK) >> PIPEREADDMA_UCR_OWNPOLARITY_SHIFT)
#define  PIPEREADDMA_UCR_OWNPOLARITY_REPLACE_VAL(reg,val) (((reg) & ~PIPEREADDMA_UCR_OWNPOLARITY_MASK) | (((uint32_t)val) << PIPEREADDMA_UCR_OWNPOLARITY_SHIFT))

#define  PIPEREADDMA_UCR_BEATS_MASK 0x6
#define  PIPEREADDMA_UCR_BEATS_SHIFT 1
#define  PIPEREADDMA_UCR_BEATS_MASK_SHIFT(reg) (((reg) & PIPEREADDMA_UCR_BEATS_MASK) >> PIPEREADDMA_UCR_BEATS_SHIFT)
#define  PIPEREADDMA_UCR_BEATS_REPLACE_VAL(reg,val) (((reg) & ~PIPEREADDMA_UCR_BEATS_MASK) | (((uint32_t)val) << PIPEREADDMA_UCR_BEATS_SHIFT))

#define  PIPEREADDMA_UCR_ENABLE_MASK 0x1
#define  PIPEREADDMA_UCR_ENABLE_SHIFT 0
#define  PIPEREADDMA_UCR_ENABLE_MASK_SHIFT(reg) (((reg) & PIPEREADDMA_UCR_ENABLE_MASK) >> PIPEREADDMA_UCR_ENABLE_SHIFT)
#define  PIPEREADDMA_UCR_ENABLE_REPLACE_VAL(reg,val) (((reg) & ~PIPEREADDMA_UCR_ENABLE_MASK) | (((uint32_t)val) << PIPEREADDMA_UCR_ENABLE_SHIFT))

//====================================================================
//Register: UDMA Status Register (USR)
//====================================================================

#define  PIPEREADDMA_USR_RESERVED1_MASK 0xfffff800
#define  PIPEREADDMA_USR_RESERVED1_SHIFT 11
#define  PIPEREADDMA_USR_RESERVED1_MASK_SHIFT(reg) (((reg) & PIPEREADDMA_USR_RESERVED1_MASK) >> PIPEREADDMA_USR_RESERVED1_SHIFT)
#define  PIPEREADDMA_USR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PIPEREADDMA_USR_RESERVED1_MASK) | (((uint32_t)val) << PIPEREADDMA_USR_RESERVED1_SHIFT))

#define  PIPEREADDMA_USR_DMAPAUSED_MASK 0x400
#define  PIPEREADDMA_USR_DMAPAUSED_SHIFT 10
#define  PIPEREADDMA_USR_DMAPAUSED_MASK_SHIFT(reg) (((reg) & PIPEREADDMA_USR_DMAPAUSED_MASK) >> PIPEREADDMA_USR_DMAPAUSED_SHIFT)
#define  PIPEREADDMA_USR_DMAPAUSED_REPLACE_VAL(reg,val) (((reg) & ~PIPEREADDMA_USR_DMAPAUSED_MASK) | (((uint32_t)val) << PIPEREADDMA_USR_DMAPAUSED_SHIFT))

#define  PIPEREADDMA_USR_PAUSEAFTER_MASK 0x200
#define  PIPEREADDMA_USR_PAUSEAFTER_SHIFT 9
#define  PIPEREADDMA_USR_PAUSEAFTER_MASK_SHIFT(reg) (((reg) & PIPEREADDMA_USR_PAUSEAFTER_MASK) >> PIPEREADDMA_USR_PAUSEAFTER_SHIFT)
#define  PIPEREADDMA_USR_PAUSEAFTER_REPLACE_VAL(reg,val) (((reg) & ~PIPEREADDMA_USR_PAUSEAFTER_MASK) | (((uint32_t)val) << PIPEREADDMA_USR_PAUSEAFTER_SHIFT))

#define  PIPEREADDMA_USR_PAUSEBEFORE_MASK 0x100
#define  PIPEREADDMA_USR_PAUSEBEFORE_SHIFT 8
#define  PIPEREADDMA_USR_PAUSEBEFORE_MASK_SHIFT(reg) (((reg) & PIPEREADDMA_USR_PAUSEBEFORE_MASK) >> PIPEREADDMA_USR_PAUSEBEFORE_SHIFT)
#define  PIPEREADDMA_USR_PAUSEBEFORE_REPLACE_VAL(reg,val) (((reg) & ~PIPEREADDMA_USR_PAUSEBEFORE_MASK) | (((uint32_t)val) << PIPEREADDMA_USR_PAUSEBEFORE_SHIFT))

#define  PIPEREADDMA_USR_INTONFINISH_MASK 0x80
#define  PIPEREADDMA_USR_INTONFINISH_SHIFT 7
#define  PIPEREADDMA_USR_INTONFINISH_MASK_SHIFT(reg) (((reg) & PIPEREADDMA_USR_INTONFINISH_MASK) >> PIPEREADDMA_USR_INTONFINISH_SHIFT)
#define  PIPEREADDMA_USR_INTONFINISH_REPLACE_VAL(reg,val) (((reg) & ~PIPEREADDMA_USR_INTONFINISH_MASK) | (((uint32_t)val) << PIPEREADDMA_USR_INTONFINISH_SHIFT))

#define  PIPEREADDMA_USR_STOPONFINISH_MASK 0x40
#define  PIPEREADDMA_USR_STOPONFINISH_SHIFT 6
#define  PIPEREADDMA_USR_STOPONFINISH_MASK_SHIFT(reg) (((reg) & PIPEREADDMA_USR_STOPONFINISH_MASK) >> PIPEREADDMA_USR_STOPONFINISH_SHIFT)
#define  PIPEREADDMA_USR_STOPONFINISH_REPLACE_VAL(reg,val) (((reg) & ~PIPEREADDMA_USR_STOPONFINISH_MASK) | (((uint32_t)val) << PIPEREADDMA_USR_STOPONFINISH_SHIFT))

#define  PIPEREADDMA_USR_CMDBUFFULL_MASK 0x20
#define  PIPEREADDMA_USR_CMDBUFFULL_SHIFT 5
#define  PIPEREADDMA_USR_CMDBUFFULL_MASK_SHIFT(reg) (((reg) & PIPEREADDMA_USR_CMDBUFFULL_MASK) >> PIPEREADDMA_USR_CMDBUFFULL_SHIFT)
#define  PIPEREADDMA_USR_CMDBUFFULL_REPLACE_VAL(reg,val) (((reg) & ~PIPEREADDMA_USR_CMDBUFFULL_MASK) | (((uint32_t)val) << PIPEREADDMA_USR_CMDBUFFULL_SHIFT))

#define  PIPEREADDMA_USR_CMDBUFEMPTY_MASK 0x10
#define  PIPEREADDMA_USR_CMDBUFEMPTY_SHIFT 4
#define  PIPEREADDMA_USR_CMDBUFEMPTY_MASK_SHIFT(reg) (((reg) & PIPEREADDMA_USR_CMDBUFEMPTY_MASK) >> PIPEREADDMA_USR_CMDBUFEMPTY_SHIFT)
#define  PIPEREADDMA_USR_CMDBUFEMPTY_REPLACE_VAL(reg,val) (((reg) & ~PIPEREADDMA_USR_CMDBUFEMPTY_MASK) | (((uint32_t)val) << PIPEREADDMA_USR_CMDBUFEMPTY_SHIFT))

#define  PIPEREADDMA_USR_DATABUFFULL_MASK 0x8
#define  PIPEREADDMA_USR_DATABUFFULL_SHIFT 3
#define  PIPEREADDMA_USR_DATABUFFULL_MASK_SHIFT(reg) (((reg) & PIPEREADDMA_USR_DATABUFFULL_MASK) >> PIPEREADDMA_USR_DATABUFFULL_SHIFT)
#define  PIPEREADDMA_USR_DATABUFFULL_REPLACE_VAL(reg,val) (((reg) & ~PIPEREADDMA_USR_DATABUFFULL_MASK) | (((uint32_t)val) << PIPEREADDMA_USR_DATABUFFULL_SHIFT))

#define  PIPEREADDMA_USR_DATABUFEMPTY_MASK 0x4
#define  PIPEREADDMA_USR_DATABUFEMPTY_SHIFT 2
#define  PIPEREADDMA_USR_DATABUFEMPTY_MASK_SHIFT(reg) (((reg) & PIPEREADDMA_USR_DATABUFEMPTY_MASK) >> PIPEREADDMA_USR_DATABUFEMPTY_SHIFT)
#define  PIPEREADDMA_USR_DATABUFEMPTY_REPLACE_VAL(reg,val) (((reg) & ~PIPEREADDMA_USR_DATABUFEMPTY_MASK) | (((uint32_t)val) << PIPEREADDMA_USR_DATABUFEMPTY_SHIFT))

#define  PIPEREADDMA_USR_CLEAR_MASK 0x2
#define  PIPEREADDMA_USR_CLEAR_SHIFT 1
#define  PIPEREADDMA_USR_CLEAR_MASK_SHIFT(reg) (((reg) & PIPEREADDMA_USR_CLEAR_MASK) >> PIPEREADDMA_USR_CLEAR_SHIFT)
#define  PIPEREADDMA_USR_CLEAR_REPLACE_VAL(reg,val) (((reg) & ~PIPEREADDMA_USR_CLEAR_MASK) | (((uint32_t)val) << PIPEREADDMA_USR_CLEAR_SHIFT))

#define  PIPEREADDMA_USR_BUSY_MASK 0x1
#define  PIPEREADDMA_USR_BUSY_SHIFT 0
#define  PIPEREADDMA_USR_BUSY_MASK_SHIFT(reg) (((reg) & PIPEREADDMA_USR_BUSY_MASK) >> PIPEREADDMA_USR_BUSY_SHIFT)
#define  PIPEREADDMA_USR_BUSY_REPLACE_VAL(reg,val) (((reg) & ~PIPEREADDMA_USR_BUSY_MASK) | (((uint32_t)val) << PIPEREADDMA_USR_BUSY_SHIFT))

//====================================================================
//Register: UDMA Parameter Register (UPR)
//====================================================================

#define  PIPEREADDMA_UPR_RESERVED1_MASK 0xff000000
#define  PIPEREADDMA_UPR_RESERVED1_SHIFT 24
#define  PIPEREADDMA_UPR_RESERVED1_MASK_SHIFT(reg) (((reg) & PIPEREADDMA_UPR_RESERVED1_MASK) >> PIPEREADDMA_UPR_RESERVED1_SHIFT)
#define  PIPEREADDMA_UPR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PIPEREADDMA_UPR_RESERVED1_MASK) | (((uint32_t)val) << PIPEREADDMA_UPR_RESERVED1_SHIFT))

#define  PIPEREADDMA_UPR_FIFODEPTH_MASK 0xffff00
#define  PIPEREADDMA_UPR_FIFODEPTH_SHIFT 8
#define  PIPEREADDMA_UPR_FIFODEPTH_MASK_SHIFT(reg) (((reg) & PIPEREADDMA_UPR_FIFODEPTH_MASK) >> PIPEREADDMA_UPR_FIFODEPTH_SHIFT)
#define  PIPEREADDMA_UPR_FIFODEPTH_REPLACE_VAL(reg,val) (((reg) & ~PIPEREADDMA_UPR_FIFODEPTH_MASK) | (((uint32_t)val) << PIPEREADDMA_UPR_FIFODEPTH_SHIFT))

#define  PIPEREADDMA_UPR_RESERVED2_MASK 0xe0
#define  PIPEREADDMA_UPR_RESERVED2_SHIFT 5
#define  PIPEREADDMA_UPR_RESERVED2_MASK_SHIFT(reg) (((reg) & PIPEREADDMA_UPR_RESERVED2_MASK) >> PIPEREADDMA_UPR_RESERVED2_SHIFT)
#define  PIPEREADDMA_UPR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~PIPEREADDMA_UPR_RESERVED2_MASK) | (((uint32_t)val) << PIPEREADDMA_UPR_RESERVED2_SHIFT))

#define  PIPEREADDMA_UPR_SERPSUPPORT_MASK 0x10
#define  PIPEREADDMA_UPR_SERPSUPPORT_SHIFT 4
#define  PIPEREADDMA_UPR_SERPSUPPORT_MASK_SHIFT(reg) (((reg) & PIPEREADDMA_UPR_SERPSUPPORT_MASK) >> PIPEREADDMA_UPR_SERPSUPPORT_SHIFT)
#define  PIPEREADDMA_UPR_SERPSUPPORT_REPLACE_VAL(reg,val) (((reg) & ~PIPEREADDMA_UPR_SERPSUPPORT_MASK) | (((uint32_t)val) << PIPEREADDMA_UPR_SERPSUPPORT_SHIFT))

#define  PIPEREADDMA_UPR_DESCLENGTH_MASK 0x8
#define  PIPEREADDMA_UPR_DESCLENGTH_SHIFT 3
#define  PIPEREADDMA_UPR_DESCLENGTH_MASK_SHIFT(reg) (((reg) & PIPEREADDMA_UPR_DESCLENGTH_MASK) >> PIPEREADDMA_UPR_DESCLENGTH_SHIFT)
#define  PIPEREADDMA_UPR_DESCLENGTH_REPLACE_VAL(reg,val) (((reg) & ~PIPEREADDMA_UPR_DESCLENGTH_MASK) | (((uint32_t)val) << PIPEREADDMA_UPR_DESCLENGTH_SHIFT))

#define  PIPEREADDMA_UPR_BUSWIDTH_MASK 0x4
#define  PIPEREADDMA_UPR_BUSWIDTH_SHIFT 2
#define  PIPEREADDMA_UPR_BUSWIDTH_MASK_SHIFT(reg) (((reg) & PIPEREADDMA_UPR_BUSWIDTH_MASK) >> PIPEREADDMA_UPR_BUSWIDTH_SHIFT)
#define  PIPEREADDMA_UPR_BUSWIDTH_REPLACE_VAL(reg,val) (((reg) & ~PIPEREADDMA_UPR_BUSWIDTH_MASK) | (((uint32_t)val) << PIPEREADDMA_UPR_BUSWIDTH_SHIFT))

#define  PIPEREADDMA_UPR_MEMALIGN_MASK 0x3
#define  PIPEREADDMA_UPR_MEMALIGN_SHIFT 0
#define  PIPEREADDMA_UPR_MEMALIGN_MASK_SHIFT(reg) (((reg) & PIPEREADDMA_UPR_MEMALIGN_MASK) >> PIPEREADDMA_UPR_MEMALIGN_SHIFT)
#define  PIPEREADDMA_UPR_MEMALIGN_REPLACE_VAL(reg,val) (((reg) & ~PIPEREADDMA_UPR_MEMALIGN_MASK) | (((uint32_t)val) << PIPEREADDMA_UPR_MEMALIGN_SHIFT))

//====================================================================
//Register: UDMA Interrupt Enable Register (UIER)
//====================================================================

#define  PIPEREADDMA_UIER_RESERVED1_MASK 0xffffffc0
#define  PIPEREADDMA_UIER_RESERVED1_SHIFT 6
#define  PIPEREADDMA_UIER_RESERVED1_MASK_SHIFT(reg) (((reg) & PIPEREADDMA_UIER_RESERVED1_MASK) >> PIPEREADDMA_UIER_RESERVED1_SHIFT)
#define  PIPEREADDMA_UIER_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PIPEREADDMA_UIER_RESERVED1_MASK) | (((uint32_t)val) << PIPEREADDMA_UIER_RESERVED1_SHIFT))

#define  PIPEREADDMA_UIER_OUTOFRANGE_MASK 0x20
#define  PIPEREADDMA_UIER_OUTOFRANGE_SHIFT 5
#define  PIPEREADDMA_UIER_OUTOFRANGE_MASK_SHIFT(reg) (((reg) & PIPEREADDMA_UIER_OUTOFRANGE_MASK) >> PIPEREADDMA_UIER_OUTOFRANGE_SHIFT)
#define  PIPEREADDMA_UIER_OUTOFRANGE_REPLACE_VAL(reg,val) (((reg) & ~PIPEREADDMA_UIER_OUTOFRANGE_MASK) | (((uint32_t)val) << PIPEREADDMA_UIER_OUTOFRANGE_SHIFT))

#define  PIPEREADDMA_UIER_RRESP_MASK 0x10
#define  PIPEREADDMA_UIER_RRESP_SHIFT 4
#define  PIPEREADDMA_UIER_RRESP_MASK_SHIFT(reg) (((reg) & PIPEREADDMA_UIER_RRESP_MASK) >> PIPEREADDMA_UIER_RRESP_SHIFT)
#define  PIPEREADDMA_UIER_RRESP_REPLACE_VAL(reg,val) (((reg) & ~PIPEREADDMA_UIER_RRESP_MASK) | (((uint32_t)val) << PIPEREADDMA_UIER_RRESP_SHIFT))

#define  PIPEREADDMA_UIER_BRESP_MASK 0x8
#define  PIPEREADDMA_UIER_BRESP_SHIFT 3
#define  PIPEREADDMA_UIER_BRESP_MASK_SHIFT(reg) (((reg) & PIPEREADDMA_UIER_BRESP_MASK) >> PIPEREADDMA_UIER_BRESP_SHIFT)
#define  PIPEREADDMA_UIER_BRESP_REPLACE_VAL(reg,val) (((reg) & ~PIPEREADDMA_UIER_BRESP_MASK) | (((uint32_t)val) << PIPEREADDMA_UIER_BRESP_SHIFT))

#define  PIPEREADDMA_UIER_CLEARCOMPLETE_MASK 0x4
#define  PIPEREADDMA_UIER_CLEARCOMPLETE_SHIFT 2
#define  PIPEREADDMA_UIER_CLEARCOMPLETE_MASK_SHIFT(reg) (((reg) & PIPEREADDMA_UIER_CLEARCOMPLETE_MASK) >> PIPEREADDMA_UIER_CLEARCOMPLETE_SHIFT)
#define  PIPEREADDMA_UIER_CLEARCOMPLETE_REPLACE_VAL(reg,val) (((reg) & ~PIPEREADDMA_UIER_CLEARCOMPLETE_MASK) | (((uint32_t)val) << PIPEREADDMA_UIER_CLEARCOMPLETE_SHIFT))

#define  PIPEREADDMA_UIER_DESC_MASK 0x2
#define  PIPEREADDMA_UIER_DESC_SHIFT 1
#define  PIPEREADDMA_UIER_DESC_MASK_SHIFT(reg) (((reg) & PIPEREADDMA_UIER_DESC_MASK) >> PIPEREADDMA_UIER_DESC_SHIFT)
#define  PIPEREADDMA_UIER_DESC_REPLACE_VAL(reg,val) (((reg) & ~PIPEREADDMA_UIER_DESC_MASK) | (((uint32_t)val) << PIPEREADDMA_UIER_DESC_SHIFT))

#define  PIPEREADDMA_UIER_OWN_MASK 0x1
#define  PIPEREADDMA_UIER_OWN_SHIFT 0
#define  PIPEREADDMA_UIER_OWN_MASK_SHIFT(reg) (((reg) & PIPEREADDMA_UIER_OWN_MASK) >> PIPEREADDMA_UIER_OWN_SHIFT)
#define  PIPEREADDMA_UIER_OWN_REPLACE_VAL(reg,val) (((reg) & ~PIPEREADDMA_UIER_OWN_MASK) | (((uint32_t)val) << PIPEREADDMA_UIER_OWN_SHIFT))

//====================================================================
//Register: UDMA Interrupt Pending Register (UIPR)
//====================================================================

#define  PIPEREADDMA_UIPR_RESERVED1_MASK 0xffffffc0
#define  PIPEREADDMA_UIPR_RESERVED1_SHIFT 6
#define  PIPEREADDMA_UIPR_RESERVED1_MASK_SHIFT(reg) (((reg) & PIPEREADDMA_UIPR_RESERVED1_MASK) >> PIPEREADDMA_UIPR_RESERVED1_SHIFT)
#define  PIPEREADDMA_UIPR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PIPEREADDMA_UIPR_RESERVED1_MASK) | (((uint32_t)val) << PIPEREADDMA_UIPR_RESERVED1_SHIFT))

#define  PIPEREADDMA_UIPR_OUTOFRANGE_MASK 0x20
#define  PIPEREADDMA_UIPR_OUTOFRANGE_SHIFT 5
#define  PIPEREADDMA_UIPR_OUTOFRANGE_MASK_SHIFT(reg) (((reg) & PIPEREADDMA_UIPR_OUTOFRANGE_MASK) >> PIPEREADDMA_UIPR_OUTOFRANGE_SHIFT)
#define  PIPEREADDMA_UIPR_OUTOFRANGE_REPLACE_VAL(reg,val) (((reg) & ~PIPEREADDMA_UIPR_OUTOFRANGE_MASK) | (((uint32_t)val) << PIPEREADDMA_UIPR_OUTOFRANGE_SHIFT))

#define  PIPEREADDMA_UIPR_RRESP_MASK 0x10
#define  PIPEREADDMA_UIPR_RRESP_SHIFT 4
#define  PIPEREADDMA_UIPR_RRESP_MASK_SHIFT(reg) (((reg) & PIPEREADDMA_UIPR_RRESP_MASK) >> PIPEREADDMA_UIPR_RRESP_SHIFT)
#define  PIPEREADDMA_UIPR_RRESP_REPLACE_VAL(reg,val) (((reg) & ~PIPEREADDMA_UIPR_RRESP_MASK) | (((uint32_t)val) << PIPEREADDMA_UIPR_RRESP_SHIFT))

#define  PIPEREADDMA_UIPR_BRESP_MASK 0x8
#define  PIPEREADDMA_UIPR_BRESP_SHIFT 3
#define  PIPEREADDMA_UIPR_BRESP_MASK_SHIFT(reg) (((reg) & PIPEREADDMA_UIPR_BRESP_MASK) >> PIPEREADDMA_UIPR_BRESP_SHIFT)
#define  PIPEREADDMA_UIPR_BRESP_REPLACE_VAL(reg,val) (((reg) & ~PIPEREADDMA_UIPR_BRESP_MASK) | (((uint32_t)val) << PIPEREADDMA_UIPR_BRESP_SHIFT))

#define  PIPEREADDMA_UIPR_CLEARCOMPLETE_MASK 0x4
#define  PIPEREADDMA_UIPR_CLEARCOMPLETE_SHIFT 2
#define  PIPEREADDMA_UIPR_CLEARCOMPLETE_MASK_SHIFT(reg) (((reg) & PIPEREADDMA_UIPR_CLEARCOMPLETE_MASK) >> PIPEREADDMA_UIPR_CLEARCOMPLETE_SHIFT)
#define  PIPEREADDMA_UIPR_CLEARCOMPLETE_REPLACE_VAL(reg,val) (((reg) & ~PIPEREADDMA_UIPR_CLEARCOMPLETE_MASK) | (((uint32_t)val) << PIPEREADDMA_UIPR_CLEARCOMPLETE_SHIFT))

#define  PIPEREADDMA_UIPR_DESC_MASK 0x2
#define  PIPEREADDMA_UIPR_DESC_SHIFT 1
#define  PIPEREADDMA_UIPR_DESC_MASK_SHIFT(reg) (((reg) & PIPEREADDMA_UIPR_DESC_MASK) >> PIPEREADDMA_UIPR_DESC_SHIFT)
#define  PIPEREADDMA_UIPR_DESC_REPLACE_VAL(reg,val) (((reg) & ~PIPEREADDMA_UIPR_DESC_MASK) | (((uint32_t)val) << PIPEREADDMA_UIPR_DESC_SHIFT))

#define  PIPEREADDMA_UIPR_OWN_MASK 0x1
#define  PIPEREADDMA_UIPR_OWN_SHIFT 0
#define  PIPEREADDMA_UIPR_OWN_MASK_SHIFT(reg) (((reg) & PIPEREADDMA_UIPR_OWN_MASK) >> PIPEREADDMA_UIPR_OWN_SHIFT)
#define  PIPEREADDMA_UIPR_OWN_REPLACE_VAL(reg,val) (((reg) & ~PIPEREADDMA_UIPR_OWN_MASK) | (((uint32_t)val) << PIPEREADDMA_UIPR_OWN_SHIFT))

//====================================================================
//Register: UDMA Interrupt Clear Register (UICR)
//====================================================================

#define  PIPEREADDMA_UICR_RESERVED1_MASK 0xffffffc0
#define  PIPEREADDMA_UICR_RESERVED1_SHIFT 6
#define  PIPEREADDMA_UICR_RESERVED1_MASK_SHIFT(reg) (((reg) & PIPEREADDMA_UICR_RESERVED1_MASK) >> PIPEREADDMA_UICR_RESERVED1_SHIFT)
#define  PIPEREADDMA_UICR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PIPEREADDMA_UICR_RESERVED1_MASK) | (((uint32_t)val) << PIPEREADDMA_UICR_RESERVED1_SHIFT))

#define  PIPEREADDMA_UICR_OUTOFRANGE_MASK 0x20
#define  PIPEREADDMA_UICR_OUTOFRANGE_SHIFT 5
#define  PIPEREADDMA_UICR_OUTOFRANGE_MASK_SHIFT(reg) (((reg) & PIPEREADDMA_UICR_OUTOFRANGE_MASK) >> PIPEREADDMA_UICR_OUTOFRANGE_SHIFT)
#define  PIPEREADDMA_UICR_OUTOFRANGE_REPLACE_VAL(reg,val) (((reg) & ~PIPEREADDMA_UICR_OUTOFRANGE_MASK) | (((uint32_t)val) << PIPEREADDMA_UICR_OUTOFRANGE_SHIFT))

#define  PIPEREADDMA_UICR_RRESP_MASK 0x10
#define  PIPEREADDMA_UICR_RRESP_SHIFT 4
#define  PIPEREADDMA_UICR_RRESP_MASK_SHIFT(reg) (((reg) & PIPEREADDMA_UICR_RRESP_MASK) >> PIPEREADDMA_UICR_RRESP_SHIFT)
#define  PIPEREADDMA_UICR_RRESP_REPLACE_VAL(reg,val) (((reg) & ~PIPEREADDMA_UICR_RRESP_MASK) | (((uint32_t)val) << PIPEREADDMA_UICR_RRESP_SHIFT))

#define  PIPEREADDMA_UICR_BRESP_MASK 0x8
#define  PIPEREADDMA_UICR_BRESP_SHIFT 3
#define  PIPEREADDMA_UICR_BRESP_MASK_SHIFT(reg) (((reg) & PIPEREADDMA_UICR_BRESP_MASK) >> PIPEREADDMA_UICR_BRESP_SHIFT)
#define  PIPEREADDMA_UICR_BRESP_REPLACE_VAL(reg,val) (((reg) & ~PIPEREADDMA_UICR_BRESP_MASK) | (((uint32_t)val) << PIPEREADDMA_UICR_BRESP_SHIFT))

#define  PIPEREADDMA_UICR_CLEARCOMPLETE_MASK 0x4
#define  PIPEREADDMA_UICR_CLEARCOMPLETE_SHIFT 2
#define  PIPEREADDMA_UICR_CLEARCOMPLETE_MASK_SHIFT(reg) (((reg) & PIPEREADDMA_UICR_CLEARCOMPLETE_MASK) >> PIPEREADDMA_UICR_CLEARCOMPLETE_SHIFT)
#define  PIPEREADDMA_UICR_CLEARCOMPLETE_REPLACE_VAL(reg,val) (((reg) & ~PIPEREADDMA_UICR_CLEARCOMPLETE_MASK) | (((uint32_t)val) << PIPEREADDMA_UICR_CLEARCOMPLETE_SHIFT))

#define  PIPEREADDMA_UICR_DESC_MASK 0x2
#define  PIPEREADDMA_UICR_DESC_SHIFT 1
#define  PIPEREADDMA_UICR_DESC_MASK_SHIFT(reg) (((reg) & PIPEREADDMA_UICR_DESC_MASK) >> PIPEREADDMA_UICR_DESC_SHIFT)
#define  PIPEREADDMA_UICR_DESC_REPLACE_VAL(reg,val) (((reg) & ~PIPEREADDMA_UICR_DESC_MASK) | (((uint32_t)val) << PIPEREADDMA_UICR_DESC_SHIFT))

#define  PIPEREADDMA_UICR_OWN_MASK 0x1
#define  PIPEREADDMA_UICR_OWN_SHIFT 0
#define  PIPEREADDMA_UICR_OWN_MASK_SHIFT(reg) (((reg) & PIPEREADDMA_UICR_OWN_MASK) >> PIPEREADDMA_UICR_OWN_SHIFT)
#define  PIPEREADDMA_UICR_OWN_REPLACE_VAL(reg,val) (((reg) & ~PIPEREADDMA_UICR_OWN_MASK) | (((uint32_t)val) << PIPEREADDMA_UICR_OWN_SHIFT))

//====================================================================
//Register: UDMA Interrupt Force Register (UIFR)
//====================================================================

#define  PIPEREADDMA_UIFR_RESERVED1_MASK 0xffffffc0
#define  PIPEREADDMA_UIFR_RESERVED1_SHIFT 6
#define  PIPEREADDMA_UIFR_RESERVED1_MASK_SHIFT(reg) (((reg) & PIPEREADDMA_UIFR_RESERVED1_MASK) >> PIPEREADDMA_UIFR_RESERVED1_SHIFT)
#define  PIPEREADDMA_UIFR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PIPEREADDMA_UIFR_RESERVED1_MASK) | (((uint32_t)val) << PIPEREADDMA_UIFR_RESERVED1_SHIFT))

#define  PIPEREADDMA_UIFR_OUTOFRANGE_MASK 0x20
#define  PIPEREADDMA_UIFR_OUTOFRANGE_SHIFT 5
#define  PIPEREADDMA_UIFR_OUTOFRANGE_MASK_SHIFT(reg) (((reg) & PIPEREADDMA_UIFR_OUTOFRANGE_MASK) >> PIPEREADDMA_UIFR_OUTOFRANGE_SHIFT)
#define  PIPEREADDMA_UIFR_OUTOFRANGE_REPLACE_VAL(reg,val) (((reg) & ~PIPEREADDMA_UIFR_OUTOFRANGE_MASK) | (((uint32_t)val) << PIPEREADDMA_UIFR_OUTOFRANGE_SHIFT))

#define  PIPEREADDMA_UIFR_RRESP_MASK 0x10
#define  PIPEREADDMA_UIFR_RRESP_SHIFT 4
#define  PIPEREADDMA_UIFR_RRESP_MASK_SHIFT(reg) (((reg) & PIPEREADDMA_UIFR_RRESP_MASK) >> PIPEREADDMA_UIFR_RRESP_SHIFT)
#define  PIPEREADDMA_UIFR_RRESP_REPLACE_VAL(reg,val) (((reg) & ~PIPEREADDMA_UIFR_RRESP_MASK) | (((uint32_t)val) << PIPEREADDMA_UIFR_RRESP_SHIFT))

#define  PIPEREADDMA_UIFR_BRESP_MASK 0x8
#define  PIPEREADDMA_UIFR_BRESP_SHIFT 3
#define  PIPEREADDMA_UIFR_BRESP_MASK_SHIFT(reg) (((reg) & PIPEREADDMA_UIFR_BRESP_MASK) >> PIPEREADDMA_UIFR_BRESP_SHIFT)
#define  PIPEREADDMA_UIFR_BRESP_REPLACE_VAL(reg,val) (((reg) & ~PIPEREADDMA_UIFR_BRESP_MASK) | (((uint32_t)val) << PIPEREADDMA_UIFR_BRESP_SHIFT))

#define  PIPEREADDMA_UIFR_CLEARCOMPLETE_MASK 0x4
#define  PIPEREADDMA_UIFR_CLEARCOMPLETE_SHIFT 2
#define  PIPEREADDMA_UIFR_CLEARCOMPLETE_MASK_SHIFT(reg) (((reg) & PIPEREADDMA_UIFR_CLEARCOMPLETE_MASK) >> PIPEREADDMA_UIFR_CLEARCOMPLETE_SHIFT)
#define  PIPEREADDMA_UIFR_CLEARCOMPLETE_REPLACE_VAL(reg,val) (((reg) & ~PIPEREADDMA_UIFR_CLEARCOMPLETE_MASK) | (((uint32_t)val) << PIPEREADDMA_UIFR_CLEARCOMPLETE_SHIFT))

#define  PIPEREADDMA_UIFR_DESC_MASK 0x2
#define  PIPEREADDMA_UIFR_DESC_SHIFT 1
#define  PIPEREADDMA_UIFR_DESC_MASK_SHIFT(reg) (((reg) & PIPEREADDMA_UIFR_DESC_MASK) >> PIPEREADDMA_UIFR_DESC_SHIFT)
#define  PIPEREADDMA_UIFR_DESC_REPLACE_VAL(reg,val) (((reg) & ~PIPEREADDMA_UIFR_DESC_MASK) | (((uint32_t)val) << PIPEREADDMA_UIFR_DESC_SHIFT))

#define  PIPEREADDMA_UIFR_OWN_MASK 0x1
#define  PIPEREADDMA_UIFR_OWN_SHIFT 0
#define  PIPEREADDMA_UIFR_OWN_MASK_SHIFT(reg) (((reg) & PIPEREADDMA_UIFR_OWN_MASK) >> PIPEREADDMA_UIFR_OWN_SHIFT)
#define  PIPEREADDMA_UIFR_OWN_REPLACE_VAL(reg,val) (((reg) & ~PIPEREADDMA_UIFR_OWN_MASK) | (((uint32_t)val) << PIPEREADDMA_UIFR_OWN_SHIFT))

//====================================================================
//Register: UDMA Descriptor Register (UDR)
//====================================================================

#define  PIPEREADDMA_UDR_DESC_MASK 0xffffffff
#define  PIPEREADDMA_UDR_DESC_SHIFT 0
#define  PIPEREADDMA_UDR_DESC_MASK_SHIFT(reg) (((reg) & PIPEREADDMA_UDR_DESC_MASK) >> PIPEREADDMA_UDR_DESC_SHIFT)
#define  PIPEREADDMA_UDR_DESC_REPLACE_VAL(reg,val) (((reg) & ~PIPEREADDMA_UDR_DESC_MASK) | (((uint32_t)val) << PIPEREADDMA_UDR_DESC_SHIFT))

//====================================================================
//Register: UDMA Burst Address Register (UBAR)
//====================================================================

#define  PIPEREADDMA_UBAR_BURSTADDR_MASK 0xffffffff
#define  PIPEREADDMA_UBAR_BURSTADDR_SHIFT 0
#define  PIPEREADDMA_UBAR_BURSTADDR_MASK_SHIFT(reg) (((reg) & PIPEREADDMA_UBAR_BURSTADDR_MASK) >> PIPEREADDMA_UBAR_BURSTADDR_SHIFT)
#define  PIPEREADDMA_UBAR_BURSTADDR_REPLACE_VAL(reg,val) (((reg) & ~PIPEREADDMA_UBAR_BURSTADDR_MASK) | (((uint32_t)val) << PIPEREADDMA_UBAR_BURSTADDR_SHIFT))

//====================================================================
//Register: UDMA Burst Length Register (UBLR)
//====================================================================

#define  PIPEREADDMA_UBLR_RESERVED1_MASK 0xfffffc00
#define  PIPEREADDMA_UBLR_RESERVED1_SHIFT 10
#define  PIPEREADDMA_UBLR_RESERVED1_MASK_SHIFT(reg) (((reg) & PIPEREADDMA_UBLR_RESERVED1_MASK) >> PIPEREADDMA_UBLR_RESERVED1_SHIFT)
#define  PIPEREADDMA_UBLR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PIPEREADDMA_UBLR_RESERVED1_MASK) | (((uint32_t)val) << PIPEREADDMA_UBLR_RESERVED1_SHIFT))

#define  PIPEREADDMA_UBLR_BURSTDIR_MASK 0x200
#define  PIPEREADDMA_UBLR_BURSTDIR_SHIFT 9
#define  PIPEREADDMA_UBLR_BURSTDIR_MASK_SHIFT(reg) (((reg) & PIPEREADDMA_UBLR_BURSTDIR_MASK) >> PIPEREADDMA_UBLR_BURSTDIR_SHIFT)
#define  PIPEREADDMA_UBLR_BURSTDIR_REPLACE_VAL(reg,val) (((reg) & ~PIPEREADDMA_UBLR_BURSTDIR_MASK) | (((uint32_t)val) << PIPEREADDMA_UBLR_BURSTDIR_SHIFT))

#define  PIPEREADDMA_UBLR_BURSTLAST_MASK 0x100
#define  PIPEREADDMA_UBLR_BURSTLAST_SHIFT 8
#define  PIPEREADDMA_UBLR_BURSTLAST_MASK_SHIFT(reg) (((reg) & PIPEREADDMA_UBLR_BURSTLAST_MASK) >> PIPEREADDMA_UBLR_BURSTLAST_SHIFT)
#define  PIPEREADDMA_UBLR_BURSTLAST_REPLACE_VAL(reg,val) (((reg) & ~PIPEREADDMA_UBLR_BURSTLAST_MASK) | (((uint32_t)val) << PIPEREADDMA_UBLR_BURSTLAST_SHIFT))

#define  PIPEREADDMA_UBLR_BURSTLENGTH_MASK 0xff
#define  PIPEREADDMA_UBLR_BURSTLENGTH_SHIFT 0
#define  PIPEREADDMA_UBLR_BURSTLENGTH_MASK_SHIFT(reg) (((reg) & PIPEREADDMA_UBLR_BURSTLENGTH_MASK) >> PIPEREADDMA_UBLR_BURSTLENGTH_SHIFT)
#define  PIPEREADDMA_UBLR_BURSTLENGTH_REPLACE_VAL(reg,val) (((reg) & ~PIPEREADDMA_UBLR_BURSTLENGTH_MASK) | (((uint32_t)val) << PIPEREADDMA_UBLR_BURSTLENGTH_SHIFT))

//====================================================================
//Register: UDMA Transfer Bytes Remaining Register (UBRR)
//====================================================================

#define  PIPEREADDMA_UBRR_BYTESREMAIN_MASK 0xffffffff
#define  PIPEREADDMA_UBRR_BYTESREMAIN_SHIFT 0
#define  PIPEREADDMA_UBRR_BYTESREMAIN_MASK_SHIFT(reg) (((reg) & PIPEREADDMA_UBRR_BYTESREMAIN_MASK) >> PIPEREADDMA_UBRR_BYTESREMAIN_SHIFT)
#define  PIPEREADDMA_UBRR_BYTESREMAIN_REPLACE_VAL(reg,val) (((reg) & ~PIPEREADDMA_UBRR_BYTESREMAIN_MASK) | (((uint32_t)val) << PIPEREADDMA_UBRR_BYTESREMAIN_SHIFT))

//====================================================================
//Register: UDMA Tag Register 0 (UTR0)
//====================================================================

#define  PIPEREADDMA_UTR0_TAGMAJ_MASK 0xffff0000
#define  PIPEREADDMA_UTR0_TAGMAJ_SHIFT 16
#define  PIPEREADDMA_UTR0_TAGMAJ_MASK_SHIFT(reg) (((reg) & PIPEREADDMA_UTR0_TAGMAJ_MASK) >> PIPEREADDMA_UTR0_TAGMAJ_SHIFT)
#define  PIPEREADDMA_UTR0_TAGMAJ_REPLACE_VAL(reg,val) (((reg) & ~PIPEREADDMA_UTR0_TAGMAJ_MASK) | (((uint32_t)val) << PIPEREADDMA_UTR0_TAGMAJ_SHIFT))

#define  PIPEREADDMA_UTR0_TAGMID_MASK 0xffff
#define  PIPEREADDMA_UTR0_TAGMID_SHIFT 0
#define  PIPEREADDMA_UTR0_TAGMID_MASK_SHIFT(reg) (((reg) & PIPEREADDMA_UTR0_TAGMID_MASK) >> PIPEREADDMA_UTR0_TAGMID_SHIFT)
#define  PIPEREADDMA_UTR0_TAGMID_REPLACE_VAL(reg,val) (((reg) & ~PIPEREADDMA_UTR0_TAGMID_MASK) | (((uint32_t)val) << PIPEREADDMA_UTR0_TAGMID_SHIFT))

//====================================================================
//Register: UDMA Tag Register 1 (UTR1)
//====================================================================

#define  PIPEREADDMA_UTR1_RESERVED1_MASK 0xffff0000
#define  PIPEREADDMA_UTR1_RESERVED1_SHIFT 16
#define  PIPEREADDMA_UTR1_RESERVED1_MASK_SHIFT(reg) (((reg) & PIPEREADDMA_UTR1_RESERVED1_MASK) >> PIPEREADDMA_UTR1_RESERVED1_SHIFT)
#define  PIPEREADDMA_UTR1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~PIPEREADDMA_UTR1_RESERVED1_MASK) | (((uint32_t)val) << PIPEREADDMA_UTR1_RESERVED1_SHIFT))

#define  PIPEREADDMA_UTR1_TAGCFG_MASK 0xffff
#define  PIPEREADDMA_UTR1_TAGCFG_SHIFT 0
#define  PIPEREADDMA_UTR1_TAGCFG_MASK_SHIFT(reg) (((reg) & PIPEREADDMA_UTR1_TAGCFG_MASK) >> PIPEREADDMA_UTR1_TAGCFG_SHIFT)
#define  PIPEREADDMA_UTR1_TAGCFG_REPLACE_VAL(reg,val) (((reg) & ~PIPEREADDMA_UTR1_TAGCFG_MASK) | (((uint32_t)val) << PIPEREADDMA_UTR1_TAGCFG_SHIFT))

#endif // PASR
