 /*
 **************************************************************************************
 *
 * (c) Copyright 2013 Marvell International Ltd.
 *
 *
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/.
 *
 **************************************************************************************
 *
 * \file OWI_regmasks.h
 * Generated using RegBuild 1.6.3
 *
 **************************************************************************************
 */

#ifndef _OWI_REG_REGMASKS_H_
#define _OWI_REG_REGMASKS_H_

#ifndef __KERNEL__
#include <stdint.h>
#endif

//====================================================================
//
//Register File: OWI Registers (OWI_reg)
/** \brief Registers for the 1-Wire Bus Master block*/
//
//====================================================================

//====================================================================
//Register: OneWire Command Register (W1CMDR)
/** \brief Using this this register, the 1-Wire Master can generate two special commands on the bus (1-Wire Reset and Seach ROM Accelerator) or firmware can directly drive the bus. Note that for normal Reading or Writing a byte on the bus, firmware should use the W1TRR Transmit/Receive Buffer Register.*/
//====================================================================

#define  OWI_REG_W1CMDR_RESERVED1_MASK 0xfffffff0
#define  OWI_REG_W1CMDR_RESERVED1_SHIFT 4
#define  OWI_REG_W1CMDR_RESERVED1_MASK_SHIFT(reg) (((reg) & OWI_REG_W1CMDR_RESERVED1_MASK) >> OWI_REG_W1CMDR_RESERVED1_SHIFT)
#define  OWI_REG_W1CMDR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~OWI_REG_W1CMDR_RESERVED1_MASK) | (((uint32_t)val) << OWI_REG_W1CMDR_RESERVED1_SHIFT))

#define  OWI_REG_W1CMDR_DQI_MASK 0x8
#define  OWI_REG_W1CMDR_DQI_SHIFT 3
#define  OWI_REG_W1CMDR_DQI_MASK_SHIFT(reg) (((reg) & OWI_REG_W1CMDR_DQI_MASK) >> OWI_REG_W1CMDR_DQI_SHIFT)
#define  OWI_REG_W1CMDR_DQI_REPLACE_VAL(reg,val) (((reg) & ~OWI_REG_W1CMDR_DQI_MASK) | (((uint32_t)val) << OWI_REG_W1CMDR_DQI_SHIFT))

#define  OWI_REG_W1CMDR_DQO_MASK 0x4
#define  OWI_REG_W1CMDR_DQO_SHIFT 2
#define  OWI_REG_W1CMDR_DQO_MASK_SHIFT(reg) (((reg) & OWI_REG_W1CMDR_DQO_MASK) >> OWI_REG_W1CMDR_DQO_SHIFT)
#define  OWI_REG_W1CMDR_DQO_REPLACE_VAL(reg,val) (((reg) & ~OWI_REG_W1CMDR_DQO_MASK) | (((uint32_t)val) << OWI_REG_W1CMDR_DQO_SHIFT))

#define  OWI_REG_W1CMDR_SRA_MASK 0x2
#define  OWI_REG_W1CMDR_SRA_SHIFT 1
#define  OWI_REG_W1CMDR_SRA_MASK_SHIFT(reg) (((reg) & OWI_REG_W1CMDR_SRA_MASK) >> OWI_REG_W1CMDR_SRA_SHIFT)
#define  OWI_REG_W1CMDR_SRA_REPLACE_VAL(reg,val) (((reg) & ~OWI_REG_W1CMDR_SRA_MASK) | (((uint32_t)val) << OWI_REG_W1CMDR_SRA_SHIFT))

#define  OWI_REG_W1CMDR_BUSRESET_MASK 0x1
#define  OWI_REG_W1CMDR_BUSRESET_SHIFT 0
#define  OWI_REG_W1CMDR_BUSRESET_MASK_SHIFT(reg) (((reg) & OWI_REG_W1CMDR_BUSRESET_MASK) >> OWI_REG_W1CMDR_BUSRESET_SHIFT)
#define  OWI_REG_W1CMDR_BUSRESET_REPLACE_VAL(reg,val) (((reg) & ~OWI_REG_W1CMDR_BUSRESET_MASK) | (((uint32_t)val) << OWI_REG_W1CMDR_BUSRESET_SHIFT))

//====================================================================
//Register: OneWire Transmit/Receive Buffer (W1TRR)
/** \brief Data sent and received from the 1-Wire bus Master passes through this transmit/receive buffer location. The 1-Wire Master is double-buffered with separate transmit and receive buffers. Writing to this location connects the transmit buffer to the 1-Wire bus, while reading connects the receive buffer to the 1-Wire bus.*/
//====================================================================

#define  OWI_REG_W1TRR_RESERVED1_MASK 0xffffff00
#define  OWI_REG_W1TRR_RESERVED1_SHIFT 8
#define  OWI_REG_W1TRR_RESERVED1_MASK_SHIFT(reg) (((reg) & OWI_REG_W1TRR_RESERVED1_MASK) >> OWI_REG_W1TRR_RESERVED1_SHIFT)
#define  OWI_REG_W1TRR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~OWI_REG_W1TRR_RESERVED1_MASK) | (((uint32_t)val) << OWI_REG_W1TRR_RESERVED1_SHIFT))

#define  OWI_REG_W1TRR_DATA_MASK 0xff
#define  OWI_REG_W1TRR_DATA_SHIFT 0
#define  OWI_REG_W1TRR_DATA_MASK_SHIFT(reg) (((reg) & OWI_REG_W1TRR_DATA_MASK) >> OWI_REG_W1TRR_DATA_SHIFT)
#define  OWI_REG_W1TRR_DATA_REPLACE_VAL(reg,val) (((reg) & ~OWI_REG_W1TRR_DATA_MASK) | (((uint32_t)val) << OWI_REG_W1TRR_DATA_SHIFT))

//====================================================================
//Register: OneWire Interrupt Register (W1INTR)
/** \brief This read-only register contains flags from transmit, receive, and 1-Wire reset operations.<BR>
            The Presence Detect (PD) flag, OW_LOW and OW_SHORT bits are self-cleared when the W1INTR Interrupt Register is read. The other flag bits are cleared automatically when the transmit and receive buffers are written to or read from.<BR>
            These flags can generate an interrupt if the corresponding enable bit is set in the W1IER Interrupt Enable register.<BR> <BR>
            IMPORTANT NOTE: Reading this register will always clear the [physical] interrupt output line of the 1-Wire Master, even if all flags are not cleared!*/
//====================================================================

#define  OWI_REG_W1INTR_RESERVED1_MASK 0xffffff00
#define  OWI_REG_W1INTR_RESERVED1_SHIFT 8
#define  OWI_REG_W1INTR_RESERVED1_MASK_SHIFT(reg) (((reg) & OWI_REG_W1INTR_RESERVED1_MASK) >> OWI_REG_W1INTR_RESERVED1_SHIFT)
#define  OWI_REG_W1INTR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~OWI_REG_W1INTR_RESERVED1_MASK) | (((uint32_t)val) << OWI_REG_W1INTR_RESERVED1_SHIFT))

#define  OWI_REG_W1INTR_OW_LOW_MASK 0x80
#define  OWI_REG_W1INTR_OW_LOW_SHIFT 7
#define  OWI_REG_W1INTR_OW_LOW_MASK_SHIFT(reg) (((reg) & OWI_REG_W1INTR_OW_LOW_MASK) >> OWI_REG_W1INTR_OW_LOW_SHIFT)
#define  OWI_REG_W1INTR_OW_LOW_REPLACE_VAL(reg,val) (((reg) & ~OWI_REG_W1INTR_OW_LOW_MASK) | (((uint32_t)val) << OWI_REG_W1INTR_OW_LOW_SHIFT))

#define  OWI_REG_W1INTR_OW_SHORT_MASK 0x40
#define  OWI_REG_W1INTR_OW_SHORT_SHIFT 6
#define  OWI_REG_W1INTR_OW_SHORT_MASK_SHIFT(reg) (((reg) & OWI_REG_W1INTR_OW_SHORT_MASK) >> OWI_REG_W1INTR_OW_SHORT_SHIFT)
#define  OWI_REG_W1INTR_OW_SHORT_REPLACE_VAL(reg,val) (((reg) & ~OWI_REG_W1INTR_OW_SHORT_MASK) | (((uint32_t)val) << OWI_REG_W1INTR_OW_SHORT_SHIFT))

#define  OWI_REG_W1INTR_RSRF_MASK 0x20
#define  OWI_REG_W1INTR_RSRF_SHIFT 5
#define  OWI_REG_W1INTR_RSRF_MASK_SHIFT(reg) (((reg) & OWI_REG_W1INTR_RSRF_MASK) >> OWI_REG_W1INTR_RSRF_SHIFT)
#define  OWI_REG_W1INTR_RSRF_REPLACE_VAL(reg,val) (((reg) & ~OWI_REG_W1INTR_RSRF_MASK) | (((uint32_t)val) << OWI_REG_W1INTR_RSRF_SHIFT))

#define  OWI_REG_W1INTR_RBF_MASK 0x10
#define  OWI_REG_W1INTR_RBF_SHIFT 4
#define  OWI_REG_W1INTR_RBF_MASK_SHIFT(reg) (((reg) & OWI_REG_W1INTR_RBF_MASK) >> OWI_REG_W1INTR_RBF_SHIFT)
#define  OWI_REG_W1INTR_RBF_REPLACE_VAL(reg,val) (((reg) & ~OWI_REG_W1INTR_RBF_MASK) | (((uint32_t)val) << OWI_REG_W1INTR_RBF_SHIFT))

#define  OWI_REG_W1INTR_TEMT_MASK 0x8
#define  OWI_REG_W1INTR_TEMT_SHIFT 3
#define  OWI_REG_W1INTR_TEMT_MASK_SHIFT(reg) (((reg) & OWI_REG_W1INTR_TEMT_MASK) >> OWI_REG_W1INTR_TEMT_SHIFT)
#define  OWI_REG_W1INTR_TEMT_REPLACE_VAL(reg,val) (((reg) & ~OWI_REG_W1INTR_TEMT_MASK) | (((uint32_t)val) << OWI_REG_W1INTR_TEMT_SHIFT))

#define  OWI_REG_W1INTR_TBE_MASK 0x4
#define  OWI_REG_W1INTR_TBE_SHIFT 2
#define  OWI_REG_W1INTR_TBE_MASK_SHIFT(reg) (((reg) & OWI_REG_W1INTR_TBE_MASK) >> OWI_REG_W1INTR_TBE_SHIFT)
#define  OWI_REG_W1INTR_TBE_REPLACE_VAL(reg,val) (((reg) & ~OWI_REG_W1INTR_TBE_MASK) | (((uint32_t)val) << OWI_REG_W1INTR_TBE_SHIFT))

#define  OWI_REG_W1INTR_PDR_MASK 0x2
#define  OWI_REG_W1INTR_PDR_SHIFT 1
#define  OWI_REG_W1INTR_PDR_MASK_SHIFT(reg) (((reg) & OWI_REG_W1INTR_PDR_MASK) >> OWI_REG_W1INTR_PDR_SHIFT)
#define  OWI_REG_W1INTR_PDR_REPLACE_VAL(reg,val) (((reg) & ~OWI_REG_W1INTR_PDR_MASK) | (((uint32_t)val) << OWI_REG_W1INTR_PDR_SHIFT))

#define  OWI_REG_W1INTR_PD_MASK 0x1
#define  OWI_REG_W1INTR_PD_SHIFT 0
#define  OWI_REG_W1INTR_PD_MASK_SHIFT(reg) (((reg) & OWI_REG_W1INTR_PD_MASK) >> OWI_REG_W1INTR_PD_SHIFT)
#define  OWI_REG_W1INTR_PD_REPLACE_VAL(reg,val) (((reg) & ~OWI_REG_W1INTR_PD_MASK) | (((uint32_t)val) << OWI_REG_W1INTR_PD_SHIFT))

//====================================================================
//Register: OneWire Interrupt Enable Register (W1IER)
/** \brief This register allows system programmers to specify which of the interrupt sources causes an interrupt.*/
//====================================================================

#define  OWI_REG_W1IER_RESERVED1_MASK 0xffffff00
#define  OWI_REG_W1IER_RESERVED1_SHIFT 8
#define  OWI_REG_W1IER_RESERVED1_MASK_SHIFT(reg) (((reg) & OWI_REG_W1IER_RESERVED1_MASK) >> OWI_REG_W1IER_RESERVED1_SHIFT)
#define  OWI_REG_W1IER_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~OWI_REG_W1IER_RESERVED1_MASK) | (((uint32_t)val) << OWI_REG_W1IER_RESERVED1_SHIFT))

#define  OWI_REG_W1IER_EOWL_MASK 0x80
#define  OWI_REG_W1IER_EOWL_SHIFT 7
#define  OWI_REG_W1IER_EOWL_MASK_SHIFT(reg) (((reg) & OWI_REG_W1IER_EOWL_MASK) >> OWI_REG_W1IER_EOWL_SHIFT)
#define  OWI_REG_W1IER_EOWL_REPLACE_VAL(reg,val) (((reg) & ~OWI_REG_W1IER_EOWL_MASK) | (((uint32_t)val) << OWI_REG_W1IER_EOWL_SHIFT))

#define  OWI_REG_W1IER_EOWSH_MASK 0x40
#define  OWI_REG_W1IER_EOWSH_SHIFT 6
#define  OWI_REG_W1IER_EOWSH_MASK_SHIFT(reg) (((reg) & OWI_REG_W1IER_EOWSH_MASK) >> OWI_REG_W1IER_EOWSH_SHIFT)
#define  OWI_REG_W1IER_EOWSH_REPLACE_VAL(reg,val) (((reg) & ~OWI_REG_W1IER_EOWSH_MASK) | (((uint32_t)val) << OWI_REG_W1IER_EOWSH_SHIFT))

#define  OWI_REG_W1IER_ERSF_MASK 0x20
#define  OWI_REG_W1IER_ERSF_SHIFT 5
#define  OWI_REG_W1IER_ERSF_MASK_SHIFT(reg) (((reg) & OWI_REG_W1IER_ERSF_MASK) >> OWI_REG_W1IER_ERSF_SHIFT)
#define  OWI_REG_W1IER_ERSF_REPLACE_VAL(reg,val) (((reg) & ~OWI_REG_W1IER_ERSF_MASK) | (((uint32_t)val) << OWI_REG_W1IER_ERSF_SHIFT))

#define  OWI_REG_W1IER_ERBF_MASK 0x10
#define  OWI_REG_W1IER_ERBF_SHIFT 4
#define  OWI_REG_W1IER_ERBF_MASK_SHIFT(reg) (((reg) & OWI_REG_W1IER_ERBF_MASK) >> OWI_REG_W1IER_ERBF_SHIFT)
#define  OWI_REG_W1IER_ERBF_REPLACE_VAL(reg,val) (((reg) & ~OWI_REG_W1IER_ERBF_MASK) | (((uint32_t)val) << OWI_REG_W1IER_ERBF_SHIFT))

#define  OWI_REG_W1IER_ETMT_MASK 0x8
#define  OWI_REG_W1IER_ETMT_SHIFT 3
#define  OWI_REG_W1IER_ETMT_MASK_SHIFT(reg) (((reg) & OWI_REG_W1IER_ETMT_MASK) >> OWI_REG_W1IER_ETMT_SHIFT)
#define  OWI_REG_W1IER_ETMT_REPLACE_VAL(reg,val) (((reg) & ~OWI_REG_W1IER_ETMT_MASK) | (((uint32_t)val) << OWI_REG_W1IER_ETMT_SHIFT))

#define  OWI_REG_W1IER_ETBE_MASK 0x4
#define  OWI_REG_W1IER_ETBE_SHIFT 2
#define  OWI_REG_W1IER_ETBE_MASK_SHIFT(reg) (((reg) & OWI_REG_W1IER_ETBE_MASK) >> OWI_REG_W1IER_ETBE_SHIFT)
#define  OWI_REG_W1IER_ETBE_REPLACE_VAL(reg,val) (((reg) & ~OWI_REG_W1IER_ETBE_MASK) | (((uint32_t)val) << OWI_REG_W1IER_ETBE_SHIFT))

#define  OWI_REG_W1IER_RESERVED2_MASK 0x2
#define  OWI_REG_W1IER_RESERVED2_SHIFT 1
#define  OWI_REG_W1IER_RESERVED2_MASK_SHIFT(reg) (((reg) & OWI_REG_W1IER_RESERVED2_MASK) >> OWI_REG_W1IER_RESERVED2_SHIFT)
#define  OWI_REG_W1IER_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~OWI_REG_W1IER_RESERVED2_MASK) | (((uint32_t)val) << OWI_REG_W1IER_RESERVED2_SHIFT))

#define  OWI_REG_W1IER_EPD_MASK 0x1
#define  OWI_REG_W1IER_EPD_SHIFT 0
#define  OWI_REG_W1IER_EPD_MASK_SHIFT(reg) (((reg) & OWI_REG_W1IER_EPD_MASK) >> OWI_REG_W1IER_EPD_SHIFT)
#define  OWI_REG_W1IER_EPD_REPLACE_VAL(reg,val) (((reg) & ~OWI_REG_W1IER_EPD_MASK) | (((uint32_t)val) << OWI_REG_W1IER_EPD_SHIFT))

//====================================================================
//Register: OneWire Control Register (W1CTRL)
/** \brief This register controls the functionality of the 1-Wire bus master controller.*/
//====================================================================

#define  OWI_REG_W1CTRL_RESERVED1_MASK 0xffffff80
#define  OWI_REG_W1CTRL_RESERVED1_SHIFT 7
#define  OWI_REG_W1CTRL_RESERVED1_MASK_SHIFT(reg) (((reg) & OWI_REG_W1CTRL_RESERVED1_MASK) >> OWI_REG_W1CTRL_RESERVED1_SHIFT)
#define  OWI_REG_W1CTRL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~OWI_REG_W1CTRL_RESERVED1_MASK) | (((uint32_t)val) << OWI_REG_W1CTRL_RESERVED1_SHIFT))

#define  OWI_REG_W1CTRL_OD_MASK 0x40
#define  OWI_REG_W1CTRL_OD_SHIFT 6
#define  OWI_REG_W1CTRL_OD_MASK_SHIFT(reg) (((reg) & OWI_REG_W1CTRL_OD_MASK) >> OWI_REG_W1CTRL_OD_SHIFT)
#define  OWI_REG_W1CTRL_OD_REPLACE_VAL(reg,val) (((reg) & ~OWI_REG_W1CTRL_OD_MASK) | (((uint32_t)val) << OWI_REG_W1CTRL_OD_SHIFT))

#define  OWI_REG_W1CTRL_BIT_CTL_MASK 0x20
#define  OWI_REG_W1CTRL_BIT_CTL_SHIFT 5
#define  OWI_REG_W1CTRL_BIT_CTL_MASK_SHIFT(reg) (((reg) & OWI_REG_W1CTRL_BIT_CTL_MASK) >> OWI_REG_W1CTRL_BIT_CTL_SHIFT)
#define  OWI_REG_W1CTRL_BIT_CTL_REPLACE_VAL(reg,val) (((reg) & ~OWI_REG_W1CTRL_BIT_CTL_MASK) | (((uint32_t)val) << OWI_REG_W1CTRL_BIT_CTL_SHIFT))

#define  OWI_REG_W1CTRL_STP_SPLY_MASK 0x10
#define  OWI_REG_W1CTRL_STP_SPLY_SHIFT 4
#define  OWI_REG_W1CTRL_STP_SPLY_MASK_SHIFT(reg) (((reg) & OWI_REG_W1CTRL_STP_SPLY_MASK) >> OWI_REG_W1CTRL_STP_SPLY_SHIFT)
#define  OWI_REG_W1CTRL_STP_SPLY_REPLACE_VAL(reg,val) (((reg) & ~OWI_REG_W1CTRL_STP_SPLY_MASK) | (((uint32_t)val) << OWI_REG_W1CTRL_STP_SPLY_SHIFT))

#define  OWI_REG_W1CTRL_STPEN_MASK 0x8
#define  OWI_REG_W1CTRL_STPEN_SHIFT 3
#define  OWI_REG_W1CTRL_STPEN_MASK_SHIFT(reg) (((reg) & OWI_REG_W1CTRL_STPEN_MASK) >> OWI_REG_W1CTRL_STPEN_SHIFT)
#define  OWI_REG_W1CTRL_STPEN_REPLACE_VAL(reg,val) (((reg) & ~OWI_REG_W1CTRL_STPEN_MASK) | (((uint32_t)val) << OWI_REG_W1CTRL_STPEN_SHIFT))

#define  OWI_REG_W1CTRL_EN_FOW_MASK 0x4
#define  OWI_REG_W1CTRL_EN_FOW_SHIFT 2
#define  OWI_REG_W1CTRL_EN_FOW_MASK_SHIFT(reg) (((reg) & OWI_REG_W1CTRL_EN_FOW_MASK) >> OWI_REG_W1CTRL_EN_FOW_SHIFT)
#define  OWI_REG_W1CTRL_EN_FOW_REPLACE_VAL(reg,val) (((reg) & ~OWI_REG_W1CTRL_EN_FOW_MASK) | (((uint32_t)val) << OWI_REG_W1CTRL_EN_FOW_SHIFT))

#define  OWI_REG_W1CTRL_PPM_MASK 0x2
#define  OWI_REG_W1CTRL_PPM_SHIFT 1
#define  OWI_REG_W1CTRL_PPM_MASK_SHIFT(reg) (((reg) & OWI_REG_W1CTRL_PPM_MASK) >> OWI_REG_W1CTRL_PPM_SHIFT)
#define  OWI_REG_W1CTRL_PPM_REPLACE_VAL(reg,val) (((reg) & ~OWI_REG_W1CTRL_PPM_MASK) | (((uint32_t)val) << OWI_REG_W1CTRL_PPM_SHIFT))

#define  OWI_REG_W1CTRL_LLM_MASK 0x1
#define  OWI_REG_W1CTRL_LLM_SHIFT 0
#define  OWI_REG_W1CTRL_LLM_MASK_SHIFT(reg) (((reg) & OWI_REG_W1CTRL_LLM_MASK) >> OWI_REG_W1CTRL_LLM_SHIFT)
#define  OWI_REG_W1CTRL_LLM_REPLACE_VAL(reg,val) (((reg) & ~OWI_REG_W1CTRL_LLM_MASK) | (((uint32_t)val) << OWI_REG_W1CTRL_LLM_SHIFT))

#endif // OWI_REG
