 /*
 **************************************************************************************
 *
 * (c) Copyright 2013 Marvell International Ltd.
 *
 *
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/.
 *
 **************************************************************************************
 *
 * \file OTMARB_regmasks.h
 * Generated using RegBuild 1.6.3
 *
 **************************************************************************************
 */

#ifndef _OTMARB_REGMASKS_H_
#define _OTMARB_REGMASKS_H_

#ifndef __KERNEL__
#include <stdint.h>
#endif

//====================================================================
//
//Register File: Object Type Merge and Replace Background Color (OTMARB)
/** \brief (rev 0 . 0 . 0 . 2)
    Registers for the Object Type Merge and Replace Background Color block*/
//
//====================================================================

//====================================================================
//Register: Configuration Register (Config)
/** \brief Register used to configure the the Object Type Merge and Replace Background Color block.*/
//====================================================================

#define  OTMARB_CONFIG_BRENABLE_MASK 0xffff0000
#define  OTMARB_CONFIG_BRENABLE_SHIFT 16
#define  OTMARB_CONFIG_BRENABLE_MASK_SHIFT(reg) (((reg) & OTMARB_CONFIG_BRENABLE_MASK) >> OTMARB_CONFIG_BRENABLE_SHIFT)
#define  OTMARB_CONFIG_BRENABLE_REPLACE_VAL(reg,val) (((reg) & ~OTMARB_CONFIG_BRENABLE_MASK) | (((uint32_t)val) << OTMARB_CONFIG_BRENABLE_SHIFT))

#define  OTMARB_CONFIG_RESERVED1_MASK 0xfffe
#define  OTMARB_CONFIG_RESERVED1_SHIFT 1
#define  OTMARB_CONFIG_RESERVED1_MASK_SHIFT(reg) (((reg) & OTMARB_CONFIG_RESERVED1_MASK) >> OTMARB_CONFIG_RESERVED1_SHIFT)
#define  OTMARB_CONFIG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~OTMARB_CONFIG_RESERVED1_MASK) | (((uint32_t)val) << OTMARB_CONFIG_RESERVED1_SHIFT))

#define  OTMARB_CONFIG_BYPASS_MASK 0x1
#define  OTMARB_CONFIG_BYPASS_SHIFT 0
#define  OTMARB_CONFIG_BYPASS_MASK_SHIFT(reg) (((reg) & OTMARB_CONFIG_BYPASS_MASK) >> OTMARB_CONFIG_BYPASS_SHIFT)
#define  OTMARB_CONFIG_BYPASS_REPLACE_VAL(reg,val) (((reg) & ~OTMARB_CONFIG_BYPASS_MASK) | (((uint32_t)val) << OTMARB_CONFIG_BYPASS_SHIFT))

//====================================================================
//Register: Background Color Replacement Value (BGColor)
/** \brief This register should be programmed with the value that will be used to replace the value
      of any pixels that have an object type which has background replacement enabled in the
      BREnable field of the Config register.*/
//====================================================================

#define  OTMARB_BGCOLOR_RESERVED1_MASK 0xc0000000
#define  OTMARB_BGCOLOR_RESERVED1_SHIFT 30
#define  OTMARB_BGCOLOR_RESERVED1_MASK_SHIFT(reg) (((reg) & OTMARB_BGCOLOR_RESERVED1_MASK) >> OTMARB_BGCOLOR_RESERVED1_SHIFT)
#define  OTMARB_BGCOLOR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~OTMARB_BGCOLOR_RESERVED1_MASK) | (((uint32_t)val) << OTMARB_BGCOLOR_RESERVED1_SHIFT))

#define  OTMARB_BGCOLOR_CH0_MASK 0x3ff00000
#define  OTMARB_BGCOLOR_CH0_SHIFT 20
#define  OTMARB_BGCOLOR_CH0_MASK_SHIFT(reg) (((reg) & OTMARB_BGCOLOR_CH0_MASK) >> OTMARB_BGCOLOR_CH0_SHIFT)
#define  OTMARB_BGCOLOR_CH0_REPLACE_VAL(reg,val) (((reg) & ~OTMARB_BGCOLOR_CH0_MASK) | (((uint32_t)val) << OTMARB_BGCOLOR_CH0_SHIFT))

#define  OTMARB_BGCOLOR_CH1_MASK 0xffc00
#define  OTMARB_BGCOLOR_CH1_SHIFT 10
#define  OTMARB_BGCOLOR_CH1_MASK_SHIFT(reg) (((reg) & OTMARB_BGCOLOR_CH1_MASK) >> OTMARB_BGCOLOR_CH1_SHIFT)
#define  OTMARB_BGCOLOR_CH1_REPLACE_VAL(reg,val) (((reg) & ~OTMARB_BGCOLOR_CH1_MASK) | (((uint32_t)val) << OTMARB_BGCOLOR_CH1_SHIFT))

#define  OTMARB_BGCOLOR_CH2_MASK 0x3ff
#define  OTMARB_BGCOLOR_CH2_SHIFT 0
#define  OTMARB_BGCOLOR_CH2_MASK_SHIFT(reg) (((reg) & OTMARB_BGCOLOR_CH2_MASK) >> OTMARB_BGCOLOR_CH2_SHIFT)
#define  OTMARB_BGCOLOR_CH2_REPLACE_VAL(reg,val) (((reg) & ~OTMARB_BGCOLOR_CH2_MASK) | (((uint32_t)val) << OTMARB_BGCOLOR_CH2_SHIFT))

//====================================================================
//Register: OTMARB Interrupt Enable Register (IntEnable)
/** \brief This register is used to enable/disable the OTMARB interrupt.*/
//====================================================================

#define  OTMARB_INTENABLE_RESERVED1_MASK 0xfffffffe
#define  OTMARB_INTENABLE_RESERVED1_SHIFT 1
#define  OTMARB_INTENABLE_RESERVED1_MASK_SHIFT(reg) (((reg) & OTMARB_INTENABLE_RESERVED1_MASK) >> OTMARB_INTENABLE_RESERVED1_SHIFT)
#define  OTMARB_INTENABLE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~OTMARB_INTENABLE_RESERVED1_MASK) | (((uint32_t)val) << OTMARB_INTENABLE_RESERVED1_SHIFT))

#define  OTMARB_INTENABLE_MISMATCHINTEN_MASK 0x1
#define  OTMARB_INTENABLE_MISMATCHINTEN_SHIFT 0
#define  OTMARB_INTENABLE_MISMATCHINTEN_MASK_SHIFT(reg) (((reg) & OTMARB_INTENABLE_MISMATCHINTEN_MASK) >> OTMARB_INTENABLE_MISMATCHINTEN_SHIFT)
#define  OTMARB_INTENABLE_MISMATCHINTEN_REPLACE_VAL(reg,val) (((reg) & ~OTMARB_INTENABLE_MISMATCHINTEN_MASK) | (((uint32_t)val) << OTMARB_INTENABLE_MISMATCHINTEN_SHIFT))

//====================================================================
//Register: OTMARB Interrupt Acknowledge Register (IntAck)
/** \brief This register is used to acknowledge the OTMARB interrupt.*/
//====================================================================

#define  OTMARB_INTACK_RESERVED1_MASK 0xfffffffe
#define  OTMARB_INTACK_RESERVED1_SHIFT 1
#define  OTMARB_INTACK_RESERVED1_MASK_SHIFT(reg) (((reg) & OTMARB_INTACK_RESERVED1_MASK) >> OTMARB_INTACK_RESERVED1_SHIFT)
#define  OTMARB_INTACK_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~OTMARB_INTACK_RESERVED1_MASK) | (((uint32_t)val) << OTMARB_INTACK_RESERVED1_SHIFT))

#define  OTMARB_INTACK_MISMATCHINTACK_MASK 0x1
#define  OTMARB_INTACK_MISMATCHINTACK_SHIFT 0
#define  OTMARB_INTACK_MISMATCHINTACK_MASK_SHIFT(reg) (((reg) & OTMARB_INTACK_MISMATCHINTACK_MASK) >> OTMARB_INTACK_MISMATCHINTACK_SHIFT)
#define  OTMARB_INTACK_MISMATCHINTACK_REPLACE_VAL(reg,val) (((reg) & ~OTMARB_INTACK_MISMATCHINTACK_MASK) | (((uint32_t)val) << OTMARB_INTACK_MISMATCHINTACK_SHIFT))

//====================================================================
//Register: OTMARB Interrupt Status Register (IntStat)
/** \brief This register provides the raw interrupt status, prior to masking by the IntEn register bit."*/
//====================================================================

#define  OTMARB_INTSTAT_RESERVED1_MASK 0xfffffffe
#define  OTMARB_INTSTAT_RESERVED1_SHIFT 1
#define  OTMARB_INTSTAT_RESERVED1_MASK_SHIFT(reg) (((reg) & OTMARB_INTSTAT_RESERVED1_MASK) >> OTMARB_INTSTAT_RESERVED1_SHIFT)
#define  OTMARB_INTSTAT_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~OTMARB_INTSTAT_RESERVED1_MASK) | (((uint32_t)val) << OTMARB_INTSTAT_RESERVED1_SHIFT))

#define  OTMARB_INTSTAT_MISMATCHINTPEND_MASK 0x1
#define  OTMARB_INTSTAT_MISMATCHINTPEND_SHIFT 0
#define  OTMARB_INTSTAT_MISMATCHINTPEND_MASK_SHIFT(reg) (((reg) & OTMARB_INTSTAT_MISMATCHINTPEND_MASK) >> OTMARB_INTSTAT_MISMATCHINTPEND_SHIFT)
#define  OTMARB_INTSTAT_MISMATCHINTPEND_REPLACE_VAL(reg,val) (((reg) & ~OTMARB_INTSTAT_MISMATCHINTPEND_MASK) | (((uint32_t)val) << OTMARB_INTSTAT_MISMATCHINTPEND_SHIFT))

//====================================================================
//Register: OTMARB Interrupt Test Register (IntTest)
/** \brief This register provides firmware with the means to manually generate a OTMARB interrupt."*/
//====================================================================

#define  OTMARB_INTTEST_RESERVED1_MASK 0xfffffffe
#define  OTMARB_INTTEST_RESERVED1_SHIFT 1
#define  OTMARB_INTTEST_RESERVED1_MASK_SHIFT(reg) (((reg) & OTMARB_INTTEST_RESERVED1_MASK) >> OTMARB_INTTEST_RESERVED1_SHIFT)
#define  OTMARB_INTTEST_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~OTMARB_INTTEST_RESERVED1_MASK) | (((uint32_t)val) << OTMARB_INTTEST_RESERVED1_SHIFT))

#define  OTMARB_INTTEST_MISMATCHINTTEST_MASK 0x1
#define  OTMARB_INTTEST_MISMATCHINTTEST_SHIFT 0
#define  OTMARB_INTTEST_MISMATCHINTTEST_MASK_SHIFT(reg) (((reg) & OTMARB_INTTEST_MISMATCHINTTEST_MASK) >> OTMARB_INTTEST_MISMATCHINTTEST_SHIFT)
#define  OTMARB_INTTEST_MISMATCHINTTEST_REPLACE_VAL(reg,val) (((reg) & ~OTMARB_INTTEST_MISMATCHINTTEST_MASK) | (((uint32_t)val) << OTMARB_INTTEST_MISMATCHINTTEST_SHIFT))

//====================================================================
//Register: IP Tagging Revision 0 (REV0)
/** \brief Provide means for firmware to read IP tagging information.
      This register of particular interest to firmware.*/
//====================================================================

#define  OTMARB_REV0_MAJ_MASK 0xffff0000
#define  OTMARB_REV0_MAJ_SHIFT 16
#define  OTMARB_REV0_MAJ_MASK_SHIFT(reg) (((reg) & OTMARB_REV0_MAJ_MASK) >> OTMARB_REV0_MAJ_SHIFT)
#define  OTMARB_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~OTMARB_REV0_MAJ_MASK) | (((uint32_t)val) << OTMARB_REV0_MAJ_SHIFT))

#define  OTMARB_REV0_MID_MASK 0xffff
#define  OTMARB_REV0_MID_SHIFT 0
#define  OTMARB_REV0_MID_MASK_SHIFT(reg) (((reg) & OTMARB_REV0_MID_MASK) >> OTMARB_REV0_MID_SHIFT)
#define  OTMARB_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~OTMARB_REV0_MID_MASK) | (((uint32_t)val) << OTMARB_REV0_MID_SHIFT))

//====================================================================
//Register: IP Tagging Revision 1 (REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  OTMARB_REV1_RESERVED1_MASK 0xffff0000
#define  OTMARB_REV1_RESERVED1_SHIFT 16
#define  OTMARB_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & OTMARB_REV1_RESERVED1_MASK) >> OTMARB_REV1_RESERVED1_SHIFT)
#define  OTMARB_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~OTMARB_REV1_RESERVED1_MASK) | (((uint32_t)val) << OTMARB_REV1_RESERVED1_SHIFT))

#define  OTMARB_REV1_CFG_MASK 0xffff
#define  OTMARB_REV1_CFG_SHIFT 0
#define  OTMARB_REV1_CFG_MASK_SHIFT(reg) (((reg) & OTMARB_REV1_CFG_MASK) >> OTMARB_REV1_CFG_SHIFT)
#define  OTMARB_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~OTMARB_REV1_CFG_MASK) | (((uint32_t)val) << OTMARB_REV1_CFG_SHIFT))

#endif // OTMARB
