 /*
 **************************************************************************************
 *
 * (c) Copyright 2013 Marvell International Ltd.
 *
 *
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/.
 *
 **************************************************************************************
 *
 * \file NGAdjust_PIE_regstructs.h
 * Generated using RegBuild 1.6.3
 *
 **************************************************************************************
 */

#ifndef _NGADJUST_PIE_REGSTRUCTS_H_
#define _NGADJUST_PIE_REGSTRUCTS_H_

#include "hwincl.h"

//====================================================================
//
//Register File: Neutral Gray Adjust (NGAdjust_PIE)
/** \brief Register Descriptions for the PIE NGAdjust block
    (rev 0 . 4 . 0 . 1)*/
//
//====================================================================

typedef struct NGADJUST_PIE_REGS_s
{
  volatile uint32_t Config;  ///< 0x0 [R/W]: NGA Configuration Register
  volatile uint32_t REV0;  ///< 0x4 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0x8 [R]: IP Tagging Revision 1
  volatile uint32_t reserved0[1021];
  volatile uint32_t LUTAccess[1024];  ///< 0x1000 [R/W]: Look Up Table Access
} NGADJUST_PIE_REGS_t;

#endif // NGADJUST_PIE
 /*
 **************************************************************************************
 *
 * (c) Copyright 2013 Marvell International Ltd.
 *
 *
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/.
 *
 **************************************************************************************
 *
 * \file NGAdjust_PIE_regmasks.h
 * Generated using RegBuild 1.6.3
 *
 **************************************************************************************
 */

#ifndef _NGADJUST_PIE_REGMASKS_H_
#define _NGADJUST_PIE_REGMASKS_H_

#include "hwincl.h"

//====================================================================
//
//Register File: Neutral Gray Adjust (NGAdjust_PIE)
/** \brief Register Descriptions for the PIE NGAdjust block
    (rev 0 . 4 . 0 . 1)*/
//
//====================================================================

//====================================================================
//Register: NGA Configuration Register (Config)
/** \brief General configuration register for NGAdjust block.*/
//====================================================================

#define  NGADJUST_PIE_CONFIG_OTENABLE_MASK 0xffff0000
#define  NGADJUST_PIE_CONFIG_OTENABLE_SHIFT 16
#define  NGADJUST_PIE_CONFIG_OTENABLE_MASK_SHIFT(reg) (((reg) & NGADJUST_PIE_CONFIG_OTENABLE_MASK) >> NGADJUST_PIE_CONFIG_OTENABLE_SHIFT)
#define  NGADJUST_PIE_CONFIG_OTENABLE_REPLACE_VAL(reg,val) (((reg) & ~NGADJUST_PIE_CONFIG_OTENABLE_MASK) | (((uint32_t)val) << NGADJUST_PIE_CONFIG_OTENABLE_SHIFT))

#define  NGADJUST_PIE_CONFIG_RESERVED1_MASK 0xfff8
#define  NGADJUST_PIE_CONFIG_RESERVED1_SHIFT 3
#define  NGADJUST_PIE_CONFIG_RESERVED1_MASK_SHIFT(reg) (((reg) & NGADJUST_PIE_CONFIG_RESERVED1_MASK) >> NGADJUST_PIE_CONFIG_RESERVED1_SHIFT)
#define  NGADJUST_PIE_CONFIG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~NGADJUST_PIE_CONFIG_RESERVED1_MASK) | (((uint32_t)val) << NGADJUST_PIE_CONFIG_RESERVED1_SHIFT))

#define  NGADJUST_PIE_CONFIG_METHOD_MASK 0x4
#define  NGADJUST_PIE_CONFIG_METHOD_SHIFT 2
#define  NGADJUST_PIE_CONFIG_METHOD_MASK_SHIFT(reg) (((reg) & NGADJUST_PIE_CONFIG_METHOD_MASK) >> NGADJUST_PIE_CONFIG_METHOD_SHIFT)
#define  NGADJUST_PIE_CONFIG_METHOD_REPLACE_VAL(reg,val) (((reg) & ~NGADJUST_PIE_CONFIG_METHOD_MASK) | (((uint32_t)val) << NGADJUST_PIE_CONFIG_METHOD_SHIFT))

#define  NGADJUST_PIE_CONFIG_CPU_ACCESS_MASK 0x2
#define  NGADJUST_PIE_CONFIG_CPU_ACCESS_SHIFT 1
#define  NGADJUST_PIE_CONFIG_CPU_ACCESS_MASK_SHIFT(reg) (((reg) & NGADJUST_PIE_CONFIG_CPU_ACCESS_MASK) >> NGADJUST_PIE_CONFIG_CPU_ACCESS_SHIFT)
#define  NGADJUST_PIE_CONFIG_CPU_ACCESS_REPLACE_VAL(reg,val) (((reg) & ~NGADJUST_PIE_CONFIG_CPU_ACCESS_MASK) | (((uint32_t)val) << NGADJUST_PIE_CONFIG_CPU_ACCESS_SHIFT))

#define  NGADJUST_PIE_CONFIG_BYPASS_MASK 0x1
#define  NGADJUST_PIE_CONFIG_BYPASS_SHIFT 0
#define  NGADJUST_PIE_CONFIG_BYPASS_MASK_SHIFT(reg) (((reg) & NGADJUST_PIE_CONFIG_BYPASS_MASK) >> NGADJUST_PIE_CONFIG_BYPASS_SHIFT)
#define  NGADJUST_PIE_CONFIG_BYPASS_REPLACE_VAL(reg,val) (((reg) & ~NGADJUST_PIE_CONFIG_BYPASS_MASK) | (((uint32_t)val) << NGADJUST_PIE_CONFIG_BYPASS_SHIFT))

//====================================================================
//Register: IP Tagging Revision 0 (REV0)
/** \brief Provide means for firmware to read IP tagging information.
      This register of particular interest to firmware.*/
//====================================================================

#define  NGADJUST_PIE_REV0_MAJ_MASK 0xffff0000
#define  NGADJUST_PIE_REV0_MAJ_SHIFT 16
#define  NGADJUST_PIE_REV0_MAJ_MASK_SHIFT(reg) (((reg) & NGADJUST_PIE_REV0_MAJ_MASK) >> NGADJUST_PIE_REV0_MAJ_SHIFT)
#define  NGADJUST_PIE_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~NGADJUST_PIE_REV0_MAJ_MASK) | (((uint32_t)val) << NGADJUST_PIE_REV0_MAJ_SHIFT))

#define  NGADJUST_PIE_REV0_MID_MASK 0xffff
#define  NGADJUST_PIE_REV0_MID_SHIFT 0
#define  NGADJUST_PIE_REV0_MID_MASK_SHIFT(reg) (((reg) & NGADJUST_PIE_REV0_MID_MASK) >> NGADJUST_PIE_REV0_MID_SHIFT)
#define  NGADJUST_PIE_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~NGADJUST_PIE_REV0_MID_MASK) | (((uint32_t)val) << NGADJUST_PIE_REV0_MID_SHIFT))

//====================================================================
//Register: IP Tagging Revision 1 (REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  NGADJUST_PIE_REV1_RESERVED1_MASK 0xffff0000
#define  NGADJUST_PIE_REV1_RESERVED1_SHIFT 16
#define  NGADJUST_PIE_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & NGADJUST_PIE_REV1_RESERVED1_MASK) >> NGADJUST_PIE_REV1_RESERVED1_SHIFT)
#define  NGADJUST_PIE_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~NGADJUST_PIE_REV1_RESERVED1_MASK) | (((uint32_t)val) << NGADJUST_PIE_REV1_RESERVED1_SHIFT))

#define  NGADJUST_PIE_REV1_CFG_MASK 0xffff
#define  NGADJUST_PIE_REV1_CFG_SHIFT 0
#define  NGADJUST_PIE_REV1_CFG_MASK_SHIFT(reg) (((reg) & NGADJUST_PIE_REV1_CFG_MASK) >> NGADJUST_PIE_REV1_CFG_SHIFT)
#define  NGADJUST_PIE_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~NGADJUST_PIE_REV1_CFG_MASK) | (((uint32_t)val) << NGADJUST_PIE_REV1_CFG_SHIFT))

//====================================================================
//Register: Look Up Table Access (LUTAccess)
/** \brief <p>The LUT, look up table, is used for Neutral Gray Adjust. The processor requires
    Read/Write access to the LUT to set up the values needed. The CPU Access bit must be set in
    the NGA Configuration register in order to access the LUTs. The LUT values have a smaller
    width than the data path, since they are intended to shift the incoming pixels somewhat and
    not over their entire value range.</p>
    <p>Note that the processor view of the LUT is 256 registers (1024 for 10-bit data
    paths), word addressed.</p>*/
//====================================================================

#define  NGADJUST_PIE_LUTACCESS_RESERVED1_MASK 0xffff0000
#define  NGADJUST_PIE_LUTACCESS_RESERVED1_SHIFT 16
#define  NGADJUST_PIE_LUTACCESS_RESERVED1_MASK_SHIFT(reg) (((reg) & NGADJUST_PIE_LUTACCESS_RESERVED1_MASK) >> NGADJUST_PIE_LUTACCESS_RESERVED1_SHIFT)
#define  NGADJUST_PIE_LUTACCESS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~NGADJUST_PIE_LUTACCESS_RESERVED1_MASK) | (((uint32_t)val) << NGADJUST_PIE_LUTACCESS_RESERVED1_SHIFT))

#define  NGADJUST_PIE_LUTACCESS_C1_MASK 0xff00
#define  NGADJUST_PIE_LUTACCESS_C1_SHIFT 8
#define  NGADJUST_PIE_LUTACCESS_C1_MASK_SHIFT(reg) (((reg) & NGADJUST_PIE_LUTACCESS_C1_MASK) >> NGADJUST_PIE_LUTACCESS_C1_SHIFT)
#define  NGADJUST_PIE_LUTACCESS_C1_REPLACE_VAL(reg,val) (((reg) & ~NGADJUST_PIE_LUTACCESS_C1_MASK) | (((uint32_t)val) << NGADJUST_PIE_LUTACCESS_C1_SHIFT))

#define  NGADJUST_PIE_LUTACCESS_C2_MASK 0xff
#define  NGADJUST_PIE_LUTACCESS_C2_SHIFT 0
#define  NGADJUST_PIE_LUTACCESS_C2_MASK_SHIFT(reg) (((reg) & NGADJUST_PIE_LUTACCESS_C2_MASK) >> NGADJUST_PIE_LUTACCESS_C2_SHIFT)
#define  NGADJUST_PIE_LUTACCESS_C2_REPLACE_VAL(reg,val) (((reg) & ~NGADJUST_PIE_LUTACCESS_C2_MASK) | (((uint32_t)val) << NGADJUST_PIE_LUTACCESS_C2_SHIFT))

#endif // NGADJUST_PIE
