 /*
 **************************************************************************************
 *
 * (c) Copyright 2014 Marvell International Ltd.
 *
 *
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/.
 *
 **************************************************************************************
 *
 * \file NFU_regstructs.h
 * Generated using RegBuild 1.6.3
 *
 **************************************************************************************
 */

#ifndef _NFU_REGSTRUCTS_H_
#define _NFU_REGSTRUCTS_H_

#ifndef __KERNEL__
#include <stdint.h>
#endif

//====================================================================
//
//Register File: NFU (NFU)
//
//====================================================================

typedef struct NFU_REGS_s
{
  volatile uint32_t NFC_NDCR;  ///< 0x0 [R/W]: NAND Flash Control Register
  volatile uint32_t NFC_NDTR0CS0;  ///< 0x4 [R/W]: NAND Controller Timing Parameter 0 Register for ND_CS0n
  volatile uint32_t reserved0;
  volatile uint32_t NFC_NDTR1CS0;  ///< 0xc [R/W]: NAND Controller Timing Parameter 1 Register for ND_CS0n
  volatile uint32_t reserved1;
  volatile uint32_t NFC_NDSR;  ///< 0x14 [R/W]: NAND Controller Status Register
  volatile uint32_t NFC_NDPCR;  ///< 0x18 [R]: NAND Controller Page Count Register
  volatile uint32_t NFC_NDBBRx0;  ///< 0x1c [R]: NAND Controller Bad Block Registers 0 and 1 (Instance 1 of 2)
  volatile uint32_t NFC_NDBBRx1;  ///< 0x20 [R]: NAND Controller Bad Block Registers 0 and 1 (Instance 2 of 2)
  volatile uint32_t NFC_NDREDEL;  ///< 0x24 [R/W]: Read Enable Return Delay Register
  volatile uint32_t NFC_NDECCCTRL;  ///< 0x28 [R/W]: ECC Control Register
  volatile uint32_t NFC_NDBZCNT;  ///< 0x2c [R]: Timer for ND_RDY0 and ND_RDY1
  volatile uint32_t NFC_NDMUTEX;  ///< 0x30 [R/W]: NAND Controller MUTEX Lock Register
  volatile uint32_t NFC_NDCMDMAT0;  ///< 0x34 [R/W]: Partition Command Match Registers (Instance 1 of 3)
  volatile uint32_t NFC_NDCMDMAT1;  ///< 0x38 [R/W]: Partition Command Match Registers (Instance 2 of 3)
  volatile uint32_t NFC_NDCMDMAT2;  ///< 0x3c [R/W]: Partition Command Match Registers (Instance 3 of 3)
  volatile uint32_t NFC_NDDB;  ///< 0x40 [R/W]: NAND Controller Data Buffer Register
  volatile uint32_t reserved2;
  volatile uint32_t NFC_NDCB0;  ///< 0x48 [R/W]: NAND Controller Command Buffer 0
  volatile uint32_t NFC_NDCB1;  ///< 0x4c [R]: NAND Controller Command Buffer 1
  volatile uint32_t NFC_NDCB2;  ///< 0x50 [R]: NAND Controller Command Buffer 2
  volatile uint32_t NFC_NDCB3;  ///< 0x54 [R]: NAND Controller Command Buffer 3
  volatile uint32_t reserved3;
  volatile uint32_t NFC_NDARBCR;  ///< 0x5c [R/W]: NAND DFI Arbitration Control Register
  volatile uint32_t NFC_NDPTXCSX0;  ///< 0x60 [R/W]: Partition Region Control Registers for CS0 and CS1 (Instance 1 of 8)
  volatile uint32_t NFC_NDPTXCSX1;  ///< 0x64 [R/W]: Partition Region Control Registers for CS0 and CS1 (Instance 2 of 8)
  volatile uint32_t NFC_NDPTXCSX2;  ///< 0x68 [R/W]: Partition Region Control Registers for CS0 and CS1 (Instance 3 of 8)
  volatile uint32_t NFC_NDPTXCSX3;  ///< 0x6c [R/W]: Partition Region Control Registers for CS0 and CS1 (Instance 4 of 8)
  volatile uint32_t NFC_NDPTXCSX4;  ///< 0x70 [R/W]: Partition Region Control Registers for CS0 and CS1 (Instance 5 of 8)
  volatile uint32_t NFC_NDPTXCSX5;  ///< 0x74 [R/W]: Partition Region Control Registers for CS0 and CS1 (Instance 6 of 8)
  volatile uint32_t NFC_NDPTXCSX6;  ///< 0x78 [R/W]: Partition Region Control Registers for CS0 and CS1 (Instance 7 of 8)
  volatile uint32_t NFC_NDPTXCSX7;  ///< 0x7c [R/W]: Partition Region Control Registers for CS0 and CS1 (Instance 8 of 8)
} NFU_REGS_t;

#endif // NFU
