 /*
 **************************************************************************************
 *
 * (c) Copyright 2014 Marvell International Ltd.
 *
 *
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/.
 *
 **************************************************************************************
 *
 * \file NFU_regmasks.h
 * Generated using RegBuild 1.6.3
 *
 **************************************************************************************
 */

#ifndef _NFU_REGMASKS_H_
#define _NFU_REGMASKS_H_

#ifndef __KERNEL__
#include <stdint.h>
#endif

//====================================================================
//
//Register File: NFU (NFU)
//
//====================================================================

//====================================================================
//Register: NAND Flash Control Register (NFC_NDCR)
/** \brief Program the NAND Controller Timing Parameter 0 Register for NDTR0CSx and NAND
Controller Timing Parameter 1 Register for NDTR1CSx and Control registers before
writing to this register. This register must be programmed before the partition
registers are written because writing any protection regions into the protection
registers disallows updates to the <Pages Per Block> and <Row Address Start
Position> fields. The reason for this blocking is to prevent malicious update of
the control register to confuse the partition address matching functions.
This is a read/write register. Ignore reads from reserved bits. Write 0x0 to
reserved bits.*/
//====================================================================

#define  NFU_NFC_NDCR_SPARE_EN_MASK 0x80000000
#define  NFU_NFC_NDCR_SPARE_EN_SHIFT 31
#define  NFU_NFC_NDCR_SPARE_EN_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDCR_SPARE_EN_MASK) >> NFU_NFC_NDCR_SPARE_EN_SHIFT)
#define  NFU_NFC_NDCR_SPARE_EN_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDCR_SPARE_EN_MASK) | (((uint32_t)val) << NFU_NFC_NDCR_SPARE_EN_SHIFT))

#define  NFU_NFC_NDCR_ECC_EN_MASK 0x40000000
#define  NFU_NFC_NDCR_ECC_EN_SHIFT 30
#define  NFU_NFC_NDCR_ECC_EN_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDCR_ECC_EN_MASK) >> NFU_NFC_NDCR_ECC_EN_SHIFT)
#define  NFU_NFC_NDCR_ECC_EN_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDCR_ECC_EN_MASK) | (((uint32_t)val) << NFU_NFC_NDCR_ECC_EN_SHIFT))

#define  NFU_NFC_NDCR_DMA_EN_MASK 0x20000000
#define  NFU_NFC_NDCR_DMA_EN_SHIFT 29
#define  NFU_NFC_NDCR_DMA_EN_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDCR_DMA_EN_MASK) >> NFU_NFC_NDCR_DMA_EN_SHIFT)
#define  NFU_NFC_NDCR_DMA_EN_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDCR_DMA_EN_MASK) | (((uint32_t)val) << NFU_NFC_NDCR_DMA_EN_SHIFT))

#define  NFU_NFC_NDCR_ND_RUN_MASK 0x10000000
#define  NFU_NFC_NDCR_ND_RUN_SHIFT 28
#define  NFU_NFC_NDCR_ND_RUN_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDCR_ND_RUN_MASK) >> NFU_NFC_NDCR_ND_RUN_SHIFT)
#define  NFU_NFC_NDCR_ND_RUN_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDCR_ND_RUN_MASK) | (((uint32_t)val) << NFU_NFC_NDCR_ND_RUN_SHIFT))

#define  NFU_NFC_NDCR_DWIDTH_C_MASK 0x8000000
#define  NFU_NFC_NDCR_DWIDTH_C_SHIFT 27
#define  NFU_NFC_NDCR_DWIDTH_C_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDCR_DWIDTH_C_MASK) >> NFU_NFC_NDCR_DWIDTH_C_SHIFT)
#define  NFU_NFC_NDCR_DWIDTH_C_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDCR_DWIDTH_C_MASK) | (((uint32_t)val) << NFU_NFC_NDCR_DWIDTH_C_SHIFT))

#define  NFU_NFC_NDCR_DWIDTH_M_MASK 0x4000000
#define  NFU_NFC_NDCR_DWIDTH_M_SHIFT 26
#define  NFU_NFC_NDCR_DWIDTH_M_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDCR_DWIDTH_M_MASK) >> NFU_NFC_NDCR_DWIDTH_M_SHIFT)
#define  NFU_NFC_NDCR_DWIDTH_M_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDCR_DWIDTH_M_MASK) | (((uint32_t)val) << NFU_NFC_NDCR_DWIDTH_M_SHIFT))

#define  NFU_NFC_NDCR_PAGE_SZ_MASK 0x3000000
#define  NFU_NFC_NDCR_PAGE_SZ_SHIFT 24
#define  NFU_NFC_NDCR_PAGE_SZ_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDCR_PAGE_SZ_MASK) >> NFU_NFC_NDCR_PAGE_SZ_SHIFT)
#define  NFU_NFC_NDCR_PAGE_SZ_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDCR_PAGE_SZ_MASK) | (((uint32_t)val) << NFU_NFC_NDCR_PAGE_SZ_SHIFT))

#define  NFU_NFC_NDCR_SEQ_DIS_MASK 0x800000
#define  NFU_NFC_NDCR_SEQ_DIS_SHIFT 23
#define  NFU_NFC_NDCR_SEQ_DIS_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDCR_SEQ_DIS_MASK) >> NFU_NFC_NDCR_SEQ_DIS_SHIFT)
#define  NFU_NFC_NDCR_SEQ_DIS_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDCR_SEQ_DIS_MASK) | (((uint32_t)val) << NFU_NFC_NDCR_SEQ_DIS_SHIFT))

#define  NFU_NFC_NDCR_RESERVED1_MASK 0x400000
#define  NFU_NFC_NDCR_RESERVED1_SHIFT 22
#define  NFU_NFC_NDCR_RESERVED1_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDCR_RESERVED1_MASK) >> NFU_NFC_NDCR_RESERVED1_SHIFT)
#define  NFU_NFC_NDCR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDCR_RESERVED1_MASK) | (((uint32_t)val) << NFU_NFC_NDCR_RESERVED1_SHIFT))

#define  NFU_NFC_NDCR_FORCE_CSX_MASK 0x200000
#define  NFU_NFC_NDCR_FORCE_CSX_SHIFT 21
#define  NFU_NFC_NDCR_FORCE_CSX_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDCR_FORCE_CSX_MASK) >> NFU_NFC_NDCR_FORCE_CSX_SHIFT)
#define  NFU_NFC_NDCR_FORCE_CSX_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDCR_FORCE_CSX_MASK) | (((uint32_t)val) << NFU_NFC_NDCR_FORCE_CSX_SHIFT))

#define  NFU_NFC_NDCR_CLR_PG_CNT_MASK 0x100000
#define  NFU_NFC_NDCR_CLR_PG_CNT_SHIFT 20
#define  NFU_NFC_NDCR_CLR_PG_CNT_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDCR_CLR_PG_CNT_MASK) >> NFU_NFC_NDCR_CLR_PG_CNT_SHIFT)
#define  NFU_NFC_NDCR_CLR_PG_CNT_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDCR_CLR_PG_CNT_MASK) | (((uint32_t)val) << NFU_NFC_NDCR_CLR_PG_CNT_SHIFT))

#define  NFU_NFC_NDCR_STOP_ON_UNCOR_MASK 0x80000
#define  NFU_NFC_NDCR_STOP_ON_UNCOR_SHIFT 19
#define  NFU_NFC_NDCR_STOP_ON_UNCOR_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDCR_STOP_ON_UNCOR_MASK) >> NFU_NFC_NDCR_STOP_ON_UNCOR_SHIFT)
#define  NFU_NFC_NDCR_STOP_ON_UNCOR_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDCR_STOP_ON_UNCOR_MASK) | (((uint32_t)val) << NFU_NFC_NDCR_STOP_ON_UNCOR_SHIFT))

#define  NFU_NFC_NDCR_RD_ID_CNT_MASK 0x70000
#define  NFU_NFC_NDCR_RD_ID_CNT_SHIFT 16
#define  NFU_NFC_NDCR_RD_ID_CNT_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDCR_RD_ID_CNT_MASK) >> NFU_NFC_NDCR_RD_ID_CNT_SHIFT)
#define  NFU_NFC_NDCR_RD_ID_CNT_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDCR_RD_ID_CNT_MASK) | (((uint32_t)val) << NFU_NFC_NDCR_RD_ID_CNT_SHIFT))

#define  NFU_NFC_NDCR_RA_START_MASK 0x8000
#define  NFU_NFC_NDCR_RA_START_SHIFT 15
#define  NFU_NFC_NDCR_RA_START_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDCR_RA_START_MASK) >> NFU_NFC_NDCR_RA_START_SHIFT)
#define  NFU_NFC_NDCR_RA_START_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDCR_RA_START_MASK) | (((uint32_t)val) << NFU_NFC_NDCR_RA_START_SHIFT))

#define  NFU_NFC_NDCR_PG_PER_BLK_MASK 0x6000
#define  NFU_NFC_NDCR_PG_PER_BLK_SHIFT 13
#define  NFU_NFC_NDCR_PG_PER_BLK_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDCR_PG_PER_BLK_MASK) >> NFU_NFC_NDCR_PG_PER_BLK_SHIFT)
#define  NFU_NFC_NDCR_PG_PER_BLK_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDCR_PG_PER_BLK_MASK) | (((uint32_t)val) << NFU_NFC_NDCR_PG_PER_BLK_SHIFT))

#define  NFU_NFC_NDCR_ND_ARB_EN_MASK 0x1000
#define  NFU_NFC_NDCR_ND_ARB_EN_SHIFT 12
#define  NFU_NFC_NDCR_ND_ARB_EN_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDCR_ND_ARB_EN_MASK) >> NFU_NFC_NDCR_ND_ARB_EN_SHIFT)
#define  NFU_NFC_NDCR_ND_ARB_EN_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDCR_ND_ARB_EN_MASK) | (((uint32_t)val) << NFU_NFC_NDCR_ND_ARB_EN_SHIFT))

#define  NFU_NFC_NDCR_RDYM_MASK 0x800
#define  NFU_NFC_NDCR_RDYM_SHIFT 11
#define  NFU_NFC_NDCR_RDYM_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDCR_RDYM_MASK) >> NFU_NFC_NDCR_RDYM_SHIFT)
#define  NFU_NFC_NDCR_RDYM_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDCR_RDYM_MASK) | (((uint32_t)val) << NFU_NFC_NDCR_RDYM_SHIFT))

#define  NFU_NFC_NDCR_CS0_PAGEDM_MASK 0x400
#define  NFU_NFC_NDCR_CS0_PAGEDM_SHIFT 10
#define  NFU_NFC_NDCR_CS0_PAGEDM_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDCR_CS0_PAGEDM_MASK) >> NFU_NFC_NDCR_CS0_PAGEDM_SHIFT)
#define  NFU_NFC_NDCR_CS0_PAGEDM_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDCR_CS0_PAGEDM_MASK) | (((uint32_t)val) << NFU_NFC_NDCR_CS0_PAGEDM_SHIFT))

#define  NFU_NFC_NDCR_CS1_PAGEDM_MASK 0x200
#define  NFU_NFC_NDCR_CS1_PAGEDM_SHIFT 9
#define  NFU_NFC_NDCR_CS1_PAGEDM_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDCR_CS1_PAGEDM_MASK) >> NFU_NFC_NDCR_CS1_PAGEDM_SHIFT)
#define  NFU_NFC_NDCR_CS1_PAGEDM_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDCR_CS1_PAGEDM_MASK) | (((uint32_t)val) << NFU_NFC_NDCR_CS1_PAGEDM_SHIFT))

#define  NFU_NFC_NDCR_CS0_CMDDM_MASK 0x100
#define  NFU_NFC_NDCR_CS0_CMDDM_SHIFT 8
#define  NFU_NFC_NDCR_CS0_CMDDM_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDCR_CS0_CMDDM_MASK) >> NFU_NFC_NDCR_CS0_CMDDM_SHIFT)
#define  NFU_NFC_NDCR_CS0_CMDDM_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDCR_CS0_CMDDM_MASK) | (((uint32_t)val) << NFU_NFC_NDCR_CS0_CMDDM_SHIFT))

#define  NFU_NFC_NDCR_CS1_CMDDM_MASK 0x80
#define  NFU_NFC_NDCR_CS1_CMDDM_SHIFT 7
#define  NFU_NFC_NDCR_CS1_CMDDM_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDCR_CS1_CMDDM_MASK) >> NFU_NFC_NDCR_CS1_CMDDM_SHIFT)
#define  NFU_NFC_NDCR_CS1_CMDDM_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDCR_CS1_CMDDM_MASK) | (((uint32_t)val) << NFU_NFC_NDCR_CS1_CMDDM_SHIFT))

#define  NFU_NFC_NDCR_CS0_BBDM_MASK 0x40
#define  NFU_NFC_NDCR_CS0_BBDM_SHIFT 6
#define  NFU_NFC_NDCR_CS0_BBDM_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDCR_CS0_BBDM_MASK) >> NFU_NFC_NDCR_CS0_BBDM_SHIFT)
#define  NFU_NFC_NDCR_CS0_BBDM_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDCR_CS0_BBDM_MASK) | (((uint32_t)val) << NFU_NFC_NDCR_CS0_BBDM_SHIFT))

#define  NFU_NFC_NDCR_CS1_BBDM_MASK 0x20
#define  NFU_NFC_NDCR_CS1_BBDM_SHIFT 5
#define  NFU_NFC_NDCR_CS1_BBDM_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDCR_CS1_BBDM_MASK) >> NFU_NFC_NDCR_CS1_BBDM_SHIFT)
#define  NFU_NFC_NDCR_CS1_BBDM_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDCR_CS1_BBDM_MASK) | (((uint32_t)val) << NFU_NFC_NDCR_CS1_BBDM_SHIFT))

#define  NFU_NFC_NDCR_UNCERRM_MASK 0x10
#define  NFU_NFC_NDCR_UNCERRM_SHIFT 4
#define  NFU_NFC_NDCR_UNCERRM_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDCR_UNCERRM_MASK) >> NFU_NFC_NDCR_UNCERRM_SHIFT)
#define  NFU_NFC_NDCR_UNCERRM_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDCR_UNCERRM_MASK) | (((uint32_t)val) << NFU_NFC_NDCR_UNCERRM_SHIFT))

#define  NFU_NFC_NDCR_CORERRM_MASK 0x8
#define  NFU_NFC_NDCR_CORERRM_SHIFT 3
#define  NFU_NFC_NDCR_CORERRM_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDCR_CORERRM_MASK) >> NFU_NFC_NDCR_CORERRM_SHIFT)
#define  NFU_NFC_NDCR_CORERRM_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDCR_CORERRM_MASK) | (((uint32_t)val) << NFU_NFC_NDCR_CORERRM_SHIFT))

#define  NFU_NFC_NDCR_WRDREQM_MASK 0x4
#define  NFU_NFC_NDCR_WRDREQM_SHIFT 2
#define  NFU_NFC_NDCR_WRDREQM_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDCR_WRDREQM_MASK) >> NFU_NFC_NDCR_WRDREQM_SHIFT)
#define  NFU_NFC_NDCR_WRDREQM_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDCR_WRDREQM_MASK) | (((uint32_t)val) << NFU_NFC_NDCR_WRDREQM_SHIFT))

#define  NFU_NFC_NDCR_RDDREQM_MASK 0x2
#define  NFU_NFC_NDCR_RDDREQM_SHIFT 1
#define  NFU_NFC_NDCR_RDDREQM_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDCR_RDDREQM_MASK) >> NFU_NFC_NDCR_RDDREQM_SHIFT)
#define  NFU_NFC_NDCR_RDDREQM_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDCR_RDDREQM_MASK) | (((uint32_t)val) << NFU_NFC_NDCR_RDDREQM_SHIFT))

#define  NFU_NFC_NDCR_WRCMDREQM_MASK 0x1
#define  NFU_NFC_NDCR_WRCMDREQM_SHIFT 0
#define  NFU_NFC_NDCR_WRCMDREQM_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDCR_WRCMDREQM_MASK) >> NFU_NFC_NDCR_WRCMDREQM_SHIFT)
#define  NFU_NFC_NDCR_WRCMDREQM_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDCR_WRCMDREQM_MASK) | (((uint32_t)val) << NFU_NFC_NDCR_WRCMDREQM_SHIFT))

//====================================================================
//Register: NAND Controller Timing Parameter 0 Register for ND_CS0n (NFC_NDTR0CS0)
/** \brief Program this register to configure the setup and hold times of outputs driven by
the NAND flash controller (ND_ALE, ND_CLE, ND_CS1n and ND_CS0n) and the pulse
widths and cycle times of ND_REn and ND_WEn. Accesses to NAND flash devices
interfaced using ND_CS0n and ND_CS1n are controlled by the settings in this
register. Programmable timing parameters enable the interface to a wide variety
of NAND flash devices. All timing parameters in this register are set in terms
of NAND controller clock periods. The NAND controller clock runs at a constant
frequency. Refer to the PXA2128 Datasheet for frequency limitations of the NFC
timing parameters. The NAND Controller Timing Parameter 0 Register for ND_CS0n
and the NAND Controller Timing Parameter 1 Register for ND_CS0n define the
timings as integer multiples of the NFC clock. This in combination with the
finer phase alignment achievable with the Read Enable Return Delay Register
allows for considerable interface timing flexibility.
This is a read/write register. Ignore reads from reserved bits. Write 0x0 to
reserved bits.*/
//====================================================================

#define  NFU_NFC_NDTR0CS0_TADL_MASK 0xf8000000
#define  NFU_NFC_NDTR0CS0_TADL_SHIFT 27
#define  NFU_NFC_NDTR0CS0_TADL_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDTR0CS0_TADL_MASK) >> NFU_NFC_NDTR0CS0_TADL_SHIFT)
#define  NFU_NFC_NDTR0CS0_TADL_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDTR0CS0_TADL_MASK) | (((uint32_t)val) << NFU_NFC_NDTR0CS0_TADL_SHIFT))

#define  NFU_NFC_NDTR0CS0_SELCNTR_MASK 0x4000000
#define  NFU_NFC_NDTR0CS0_SELCNTR_SHIFT 26
#define  NFU_NFC_NDTR0CS0_SELCNTR_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDTR0CS0_SELCNTR_MASK) >> NFU_NFC_NDTR0CS0_SELCNTR_SHIFT)
#define  NFU_NFC_NDTR0CS0_SELCNTR_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDTR0CS0_SELCNTR_MASK) | (((uint32_t)val) << NFU_NFC_NDTR0CS0_SELCNTR_SHIFT))

#define  NFU_NFC_NDTR0CS0_RD_CNT_DEL_MASK 0x3c00000
#define  NFU_NFC_NDTR0CS0_RD_CNT_DEL_SHIFT 22
#define  NFU_NFC_NDTR0CS0_RD_CNT_DEL_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDTR0CS0_RD_CNT_DEL_MASK) >> NFU_NFC_NDTR0CS0_RD_CNT_DEL_SHIFT)
#define  NFU_NFC_NDTR0CS0_RD_CNT_DEL_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDTR0CS0_RD_CNT_DEL_MASK) | (((uint32_t)val) << NFU_NFC_NDTR0CS0_RD_CNT_DEL_SHIFT))

#define  NFU_NFC_NDTR0CS0_TCH_MASK 0x380000
#define  NFU_NFC_NDTR0CS0_TCH_SHIFT 19
#define  NFU_NFC_NDTR0CS0_TCH_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDTR0CS0_TCH_MASK) >> NFU_NFC_NDTR0CS0_TCH_SHIFT)
#define  NFU_NFC_NDTR0CS0_TCH_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDTR0CS0_TCH_MASK) | (((uint32_t)val) << NFU_NFC_NDTR0CS0_TCH_SHIFT))

#define  NFU_NFC_NDTR0CS0_TCS_MASK 0x70000
#define  NFU_NFC_NDTR0CS0_TCS_SHIFT 16
#define  NFU_NFC_NDTR0CS0_TCS_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDTR0CS0_TCS_MASK) >> NFU_NFC_NDTR0CS0_TCS_SHIFT)
#define  NFU_NFC_NDTR0CS0_TCS_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDTR0CS0_TCS_MASK) | (((uint32_t)val) << NFU_NFC_NDTR0CS0_TCS_SHIFT))

#define  NFU_NFC_NDTR0CS0_RESERVED1_MASK 0xc000
#define  NFU_NFC_NDTR0CS0_RESERVED1_SHIFT 14
#define  NFU_NFC_NDTR0CS0_RESERVED1_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDTR0CS0_RESERVED1_MASK) >> NFU_NFC_NDTR0CS0_RESERVED1_SHIFT)
#define  NFU_NFC_NDTR0CS0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDTR0CS0_RESERVED1_MASK) | (((uint32_t)val) << NFU_NFC_NDTR0CS0_RESERVED1_SHIFT))

#define  NFU_NFC_NDTR0CS0_TWH_MASK 0x3800
#define  NFU_NFC_NDTR0CS0_TWH_SHIFT 11
#define  NFU_NFC_NDTR0CS0_TWH_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDTR0CS0_TWH_MASK) >> NFU_NFC_NDTR0CS0_TWH_SHIFT)
#define  NFU_NFC_NDTR0CS0_TWH_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDTR0CS0_TWH_MASK) | (((uint32_t)val) << NFU_NFC_NDTR0CS0_TWH_SHIFT))

#define  NFU_NFC_NDTR0CS0_TWP_MASK 0x700
#define  NFU_NFC_NDTR0CS0_TWP_SHIFT 8
#define  NFU_NFC_NDTR0CS0_TWP_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDTR0CS0_TWP_MASK) >> NFU_NFC_NDTR0CS0_TWP_SHIFT)
#define  NFU_NFC_NDTR0CS0_TWP_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDTR0CS0_TWP_MASK) | (((uint32_t)val) << NFU_NFC_NDTR0CS0_TWP_SHIFT))

#define  NFU_NFC_NDTR0CS0_SEL_NRE_EDGE_MASK 0x80
#define  NFU_NFC_NDTR0CS0_SEL_NRE_EDGE_SHIFT 7
#define  NFU_NFC_NDTR0CS0_SEL_NRE_EDGE_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDTR0CS0_SEL_NRE_EDGE_MASK) >> NFU_NFC_NDTR0CS0_SEL_NRE_EDGE_SHIFT)
#define  NFU_NFC_NDTR0CS0_SEL_NRE_EDGE_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDTR0CS0_SEL_NRE_EDGE_MASK) | (((uint32_t)val) << NFU_NFC_NDTR0CS0_SEL_NRE_EDGE_SHIFT))

#define  NFU_NFC_NDTR0CS0_ETRP_MASK 0x40
#define  NFU_NFC_NDTR0CS0_ETRP_SHIFT 6
#define  NFU_NFC_NDTR0CS0_ETRP_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDTR0CS0_ETRP_MASK) >> NFU_NFC_NDTR0CS0_ETRP_SHIFT)
#define  NFU_NFC_NDTR0CS0_ETRP_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDTR0CS0_ETRP_MASK) | (((uint32_t)val) << NFU_NFC_NDTR0CS0_ETRP_SHIFT))

#define  NFU_NFC_NDTR0CS0_TRH_MASK 0x38
#define  NFU_NFC_NDTR0CS0_TRH_SHIFT 3
#define  NFU_NFC_NDTR0CS0_TRH_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDTR0CS0_TRH_MASK) >> NFU_NFC_NDTR0CS0_TRH_SHIFT)
#define  NFU_NFC_NDTR0CS0_TRH_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDTR0CS0_TRH_MASK) | (((uint32_t)val) << NFU_NFC_NDTR0CS0_TRH_SHIFT))

#define  NFU_NFC_NDTR0CS0_TRP_MASK 0x7
#define  NFU_NFC_NDTR0CS0_TRP_SHIFT 0
#define  NFU_NFC_NDTR0CS0_TRP_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDTR0CS0_TRP_MASK) >> NFU_NFC_NDTR0CS0_TRP_SHIFT)
#define  NFU_NFC_NDTR0CS0_TRP_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDTR0CS0_TRP_MASK) | (((uint32_t)val) << NFU_NFC_NDTR0CS0_TRP_SHIFT))

//====================================================================
//Register: NAND Controller Timing Parameter 1 Register for ND_CS0n (NFC_NDTR1CS0)
/** \brief This register can be programmed to set the timing information for read, status
read, and read-ID commands. Accesses to NAND flash devices interfaced using both
ND_CS0n and ND_CS1n are controlled by the settings in this register. All timing
parameters in this register are set in terms of NAND controller-clock periods.
The NAND controller clock runs at a constant frequency of 156 MHz. Refer to the
PXA2128 Datasheet for frequency limitation of the NFC timing parameters.
Although there is only one definition register, because it is possible to
overlap operations on the two chip selects, there are two actual timers (one for
each chip select).
This is a read/write register. Ignore reads from reserved bits. Write 0x0 to
reserved bits.*/
//====================================================================

#define  NFU_NFC_NDTR1CS0_TR_MASK 0xffff0000
#define  NFU_NFC_NDTR1CS0_TR_SHIFT 16
#define  NFU_NFC_NDTR1CS0_TR_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDTR1CS0_TR_MASK) >> NFU_NFC_NDTR1CS0_TR_SHIFT)
#define  NFU_NFC_NDTR1CS0_TR_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDTR1CS0_TR_MASK) | (((uint32_t)val) << NFU_NFC_NDTR1CS0_TR_SHIFT))

#define  NFU_NFC_NDTR1CS0_WAIT_MODE_MASK 0x8000
#define  NFU_NFC_NDTR1CS0_WAIT_MODE_SHIFT 15
#define  NFU_NFC_NDTR1CS0_WAIT_MODE_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDTR1CS0_WAIT_MODE_MASK) >> NFU_NFC_NDTR1CS0_WAIT_MODE_SHIFT)
#define  NFU_NFC_NDTR1CS0_WAIT_MODE_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDTR1CS0_WAIT_MODE_MASK) | (((uint32_t)val) << NFU_NFC_NDTR1CS0_WAIT_MODE_SHIFT))

#define  NFU_NFC_NDTR1CS0_PRESCALE_MASK 0x4000
#define  NFU_NFC_NDTR1CS0_PRESCALE_SHIFT 14
#define  NFU_NFC_NDTR1CS0_PRESCALE_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDTR1CS0_PRESCALE_MASK) >> NFU_NFC_NDTR1CS0_PRESCALE_SHIFT)
#define  NFU_NFC_NDTR1CS0_PRESCALE_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDTR1CS0_PRESCALE_MASK) | (((uint32_t)val) << NFU_NFC_NDTR1CS0_PRESCALE_SHIFT))

#define  NFU_NFC_NDTR1CS0_RESERVED1_MASK 0x3000
#define  NFU_NFC_NDTR1CS0_RESERVED1_SHIFT 12
#define  NFU_NFC_NDTR1CS0_RESERVED1_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDTR1CS0_RESERVED1_MASK) >> NFU_NFC_NDTR1CS0_RESERVED1_SHIFT)
#define  NFU_NFC_NDTR1CS0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDTR1CS0_RESERVED1_MASK) | (((uint32_t)val) << NFU_NFC_NDTR1CS0_RESERVED1_SHIFT))

#define  NFU_NFC_NDTR1CS0_TWHR_TAR_SCALE_MASK 0xc00
#define  NFU_NFC_NDTR1CS0_TWHR_TAR_SCALE_SHIFT 10
#define  NFU_NFC_NDTR1CS0_TWHR_TAR_SCALE_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDTR1CS0_TWHR_TAR_SCALE_MASK) >> NFU_NFC_NDTR1CS0_TWHR_TAR_SCALE_SHIFT)
#define  NFU_NFC_NDTR1CS0_TWHR_TAR_SCALE_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDTR1CS0_TWHR_TAR_SCALE_MASK) | (((uint32_t)val) << NFU_NFC_NDTR1CS0_TWHR_TAR_SCALE_SHIFT))

#define  NFU_NFC_NDTR1CS0_TRHW_MASK 0x300
#define  NFU_NFC_NDTR1CS0_TRHW_SHIFT 8
#define  NFU_NFC_NDTR1CS0_TRHW_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDTR1CS0_TRHW_MASK) >> NFU_NFC_NDTR1CS0_TRHW_SHIFT)
#define  NFU_NFC_NDTR1CS0_TRHW_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDTR1CS0_TRHW_MASK) | (((uint32_t)val) << NFU_NFC_NDTR1CS0_TRHW_SHIFT))

#define  NFU_NFC_NDTR1CS0_TWHR_MASK 0xf0
#define  NFU_NFC_NDTR1CS0_TWHR_SHIFT 4
#define  NFU_NFC_NDTR1CS0_TWHR_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDTR1CS0_TWHR_MASK) >> NFU_NFC_NDTR1CS0_TWHR_SHIFT)
#define  NFU_NFC_NDTR1CS0_TWHR_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDTR1CS0_TWHR_MASK) | (((uint32_t)val) << NFU_NFC_NDTR1CS0_TWHR_SHIFT))

#define  NFU_NFC_NDTR1CS0_TAR_MASK 0xf
#define  NFU_NFC_NDTR1CS0_TAR_SHIFT 0
#define  NFU_NFC_NDTR1CS0_TAR_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDTR1CS0_TAR_MASK) >> NFU_NFC_NDTR1CS0_TAR_SHIFT)
#define  NFU_NFC_NDTR1CS0_TAR_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDTR1CS0_TAR_MASK) | (((uint32_t)val) << NFU_NFC_NDTR1CS0_TAR_SHIFT))

//====================================================================
//Register: NAND Controller Status Register (NFC_NDSR)
/** \brief This register contains bits that signal flash ready status, bad block detected,
read-data-error conditions, data-read/write requests, completion of a page, and
command. Unless masked, each of these hardware-detected events signals an
interrupt request to the interrupt controller. Once set, each of the status bits
is cleared by writing 0x1 to the corresponding bit position. Writing 0x0 has no
effect on the status bits. Each of the fields in this register signals an
interrupt request as long as the bit is set and the corresponding interrupt is
not masked. Once the bit is cleared, the interrupt is cleared.
The status bits in this register are set in both DMA and non-DMA modes of
operation, and they can be polled and cleared by software in either mode.
This is a read/write register. Ignore reads from reserved bits. Write 0x0 to
reserved bits.*/
//====================================================================

#define  NFU_NFC_NDSR_RESERVED1_MASK 0xff000000
#define  NFU_NFC_NDSR_RESERVED1_SHIFT 24
#define  NFU_NFC_NDSR_RESERVED1_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDSR_RESERVED1_MASK) >> NFU_NFC_NDSR_RESERVED1_SHIFT)
#define  NFU_NFC_NDSR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDSR_RESERVED1_MASK) | (((uint32_t)val) << NFU_NFC_NDSR_RESERVED1_SHIFT))

#define  NFU_NFC_NDSR_ERR_CNT_MASK 0xff0000
#define  NFU_NFC_NDSR_ERR_CNT_SHIFT 16
#define  NFU_NFC_NDSR_ERR_CNT_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDSR_ERR_CNT_MASK) >> NFU_NFC_NDSR_ERR_CNT_SHIFT)
#define  NFU_NFC_NDSR_ERR_CNT_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDSR_ERR_CNT_MASK) | (((uint32_t)val) << NFU_NFC_NDSR_ERR_CNT_SHIFT))

#define  NFU_NFC_NDSR_TRUSTVIO_MASK 0x8000
#define  NFU_NFC_NDSR_TRUSTVIO_SHIFT 15
#define  NFU_NFC_NDSR_TRUSTVIO_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDSR_TRUSTVIO_MASK) >> NFU_NFC_NDSR_TRUSTVIO_SHIFT)
#define  NFU_NFC_NDSR_TRUSTVIO_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDSR_TRUSTVIO_MASK) | (((uint32_t)val) << NFU_NFC_NDSR_TRUSTVIO_SHIFT))

#define  NFU_NFC_NDSR_RESERVED2_MASK 0x6000
#define  NFU_NFC_NDSR_RESERVED2_SHIFT 13
#define  NFU_NFC_NDSR_RESERVED2_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDSR_RESERVED2_MASK) >> NFU_NFC_NDSR_RESERVED2_SHIFT)
#define  NFU_NFC_NDSR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDSR_RESERVED2_MASK) | (((uint32_t)val) << NFU_NFC_NDSR_RESERVED2_SHIFT))

#define  NFU_NFC_NDSR_RDY1_MASK 0x1000
#define  NFU_NFC_NDSR_RDY1_SHIFT 12
#define  NFU_NFC_NDSR_RDY1_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDSR_RDY1_MASK) >> NFU_NFC_NDSR_RDY1_SHIFT)
#define  NFU_NFC_NDSR_RDY1_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDSR_RDY1_MASK) | (((uint32_t)val) << NFU_NFC_NDSR_RDY1_SHIFT))

#define  NFU_NFC_NDSR_RDY0_MASK 0x800
#define  NFU_NFC_NDSR_RDY0_SHIFT 11
#define  NFU_NFC_NDSR_RDY0_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDSR_RDY0_MASK) >> NFU_NFC_NDSR_RDY0_SHIFT)
#define  NFU_NFC_NDSR_RDY0_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDSR_RDY0_MASK) | (((uint32_t)val) << NFU_NFC_NDSR_RDY0_SHIFT))

#define  NFU_NFC_NDSR_CS0_PAGED_MASK 0x400
#define  NFU_NFC_NDSR_CS0_PAGED_SHIFT 10
#define  NFU_NFC_NDSR_CS0_PAGED_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDSR_CS0_PAGED_MASK) >> NFU_NFC_NDSR_CS0_PAGED_SHIFT)
#define  NFU_NFC_NDSR_CS0_PAGED_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDSR_CS0_PAGED_MASK) | (((uint32_t)val) << NFU_NFC_NDSR_CS0_PAGED_SHIFT))

#define  NFU_NFC_NDSR_CS1_PAGED_MASK 0x200
#define  NFU_NFC_NDSR_CS1_PAGED_SHIFT 9
#define  NFU_NFC_NDSR_CS1_PAGED_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDSR_CS1_PAGED_MASK) >> NFU_NFC_NDSR_CS1_PAGED_SHIFT)
#define  NFU_NFC_NDSR_CS1_PAGED_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDSR_CS1_PAGED_MASK) | (((uint32_t)val) << NFU_NFC_NDSR_CS1_PAGED_SHIFT))

#define  NFU_NFC_NDSR_CS0_CMDD_MASK 0x100
#define  NFU_NFC_NDSR_CS0_CMDD_SHIFT 8
#define  NFU_NFC_NDSR_CS0_CMDD_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDSR_CS0_CMDD_MASK) >> NFU_NFC_NDSR_CS0_CMDD_SHIFT)
#define  NFU_NFC_NDSR_CS0_CMDD_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDSR_CS0_CMDD_MASK) | (((uint32_t)val) << NFU_NFC_NDSR_CS0_CMDD_SHIFT))

#define  NFU_NFC_NDSR_CS1_CMDD_MASK 0x80
#define  NFU_NFC_NDSR_CS1_CMDD_SHIFT 7
#define  NFU_NFC_NDSR_CS1_CMDD_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDSR_CS1_CMDD_MASK) >> NFU_NFC_NDSR_CS1_CMDD_SHIFT)
#define  NFU_NFC_NDSR_CS1_CMDD_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDSR_CS1_CMDD_MASK) | (((uint32_t)val) << NFU_NFC_NDSR_CS1_CMDD_SHIFT))

#define  NFU_NFC_NDSR_CS0_BBD_MASK 0x40
#define  NFU_NFC_NDSR_CS0_BBD_SHIFT 6
#define  NFU_NFC_NDSR_CS0_BBD_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDSR_CS0_BBD_MASK) >> NFU_NFC_NDSR_CS0_BBD_SHIFT)
#define  NFU_NFC_NDSR_CS0_BBD_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDSR_CS0_BBD_MASK) | (((uint32_t)val) << NFU_NFC_NDSR_CS0_BBD_SHIFT))

#define  NFU_NFC_NDSR_CS1_BBD_MASK 0x20
#define  NFU_NFC_NDSR_CS1_BBD_SHIFT 5
#define  NFU_NFC_NDSR_CS1_BBD_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDSR_CS1_BBD_MASK) >> NFU_NFC_NDSR_CS1_BBD_SHIFT)
#define  NFU_NFC_NDSR_CS1_BBD_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDSR_CS1_BBD_MASK) | (((uint32_t)val) << NFU_NFC_NDSR_CS1_BBD_SHIFT))

#define  NFU_NFC_NDSR_UNCERR_MASK 0x10
#define  NFU_NFC_NDSR_UNCERR_SHIFT 4
#define  NFU_NFC_NDSR_UNCERR_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDSR_UNCERR_MASK) >> NFU_NFC_NDSR_UNCERR_SHIFT)
#define  NFU_NFC_NDSR_UNCERR_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDSR_UNCERR_MASK) | (((uint32_t)val) << NFU_NFC_NDSR_UNCERR_SHIFT))

#define  NFU_NFC_NDSR_CORERR_MASK 0x8
#define  NFU_NFC_NDSR_CORERR_SHIFT 3
#define  NFU_NFC_NDSR_CORERR_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDSR_CORERR_MASK) >> NFU_NFC_NDSR_CORERR_SHIFT)
#define  NFU_NFC_NDSR_CORERR_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDSR_CORERR_MASK) | (((uint32_t)val) << NFU_NFC_NDSR_CORERR_SHIFT))

#define  NFU_NFC_NDSR_WRDREQ_MASK 0x4
#define  NFU_NFC_NDSR_WRDREQ_SHIFT 2
#define  NFU_NFC_NDSR_WRDREQ_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDSR_WRDREQ_MASK) >> NFU_NFC_NDSR_WRDREQ_SHIFT)
#define  NFU_NFC_NDSR_WRDREQ_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDSR_WRDREQ_MASK) | (((uint32_t)val) << NFU_NFC_NDSR_WRDREQ_SHIFT))

#define  NFU_NFC_NDSR_RDDREQ_MASK 0x2
#define  NFU_NFC_NDSR_RDDREQ_SHIFT 1
#define  NFU_NFC_NDSR_RDDREQ_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDSR_RDDREQ_MASK) >> NFU_NFC_NDSR_RDDREQ_SHIFT)
#define  NFU_NFC_NDSR_RDDREQ_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDSR_RDDREQ_MASK) | (((uint32_t)val) << NFU_NFC_NDSR_RDDREQ_SHIFT))

#define  NFU_NFC_NDSR_WRCMDREQ_MASK 0x1
#define  NFU_NFC_NDSR_WRCMDREQ_SHIFT 0
#define  NFU_NFC_NDSR_WRCMDREQ_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDSR_WRCMDREQ_MASK) >> NFU_NFC_NDSR_WRCMDREQ_SHIFT)
#define  NFU_NFC_NDSR_WRCMDREQ_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDSR_WRCMDREQ_MASK) | (((uint32_t)val) << NFU_NFC_NDSR_WRCMDREQ_SHIFT))

//====================================================================
//Register: NAND Controller Page Count Register (NFC_NDPCR)
/** \brief The NAND Controller Page Count register (NDPCR) can be read to determine the
completed number of pages for multi-page program/read operations. Writes to
NDPCR are ignored.
This is a read-only register. Ignore reads from reserved bits.*/
//====================================================================

#define  NFU_NFC_NDPCR_RESERVED1_MASK 0xff000000
#define  NFU_NFC_NDPCR_RESERVED1_SHIFT 24
#define  NFU_NFC_NDPCR_RESERVED1_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDPCR_RESERVED1_MASK) >> NFU_NFC_NDPCR_RESERVED1_SHIFT)
#define  NFU_NFC_NDPCR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDPCR_RESERVED1_MASK) | (((uint32_t)val) << NFU_NFC_NDPCR_RESERVED1_SHIFT))

#define  NFU_NFC_NDPCR_PG_CNT_1_MASK 0xff0000
#define  NFU_NFC_NDPCR_PG_CNT_1_SHIFT 16
#define  NFU_NFC_NDPCR_PG_CNT_1_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDPCR_PG_CNT_1_MASK) >> NFU_NFC_NDPCR_PG_CNT_1_SHIFT)
#define  NFU_NFC_NDPCR_PG_CNT_1_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDPCR_PG_CNT_1_MASK) | (((uint32_t)val) << NFU_NFC_NDPCR_PG_CNT_1_SHIFT))

#define  NFU_NFC_NDPCR_RESERVED2_MASK 0xff00
#define  NFU_NFC_NDPCR_RESERVED2_SHIFT 8
#define  NFU_NFC_NDPCR_RESERVED2_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDPCR_RESERVED2_MASK) >> NFU_NFC_NDPCR_RESERVED2_SHIFT)
#define  NFU_NFC_NDPCR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDPCR_RESERVED2_MASK) | (((uint32_t)val) << NFU_NFC_NDPCR_RESERVED2_SHIFT))

#define  NFU_NFC_NDPCR_PG_CNT_0_MASK 0xff
#define  NFU_NFC_NDPCR_PG_CNT_0_SHIFT 0
#define  NFU_NFC_NDPCR_PG_CNT_0_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDPCR_PG_CNT_0_MASK) >> NFU_NFC_NDPCR_PG_CNT_0_SHIFT)
#define  NFU_NFC_NDPCR_PG_CNT_0_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDPCR_PG_CNT_0_MASK) | (((uint32_t)val) << NFU_NFC_NDPCR_PG_CNT_0_SHIFT))

//====================================================================
//Register: NAND Controller Bad Block Registers 0 and 1 (Instance 1 of 2) (NFC_NDBBRx0)
/** \brief The NAND Controller Bad Block registers (NDBBR0 and NDBBR1) hold the bad-block
information when a bad block is detected. NDBBR0 holds the bad-block information
for a bad- block detected for a device interfaced using ND_CS0n (NDSR[CS0_BBD]
is set). Similarly, NDBBR1 holds the bad-block information for a device
interfaced using ND_CS1n (NDSR[CS1_BBD] set).
These are read-only registers. Ignore reads from reserved bits. (Instance 1 of 2)*/
//====================================================================

#define  NFU_NFC_NDBBRX0_BAD_BLOCK_INFORMATION_MASK 0xffffffff
#define  NFU_NFC_NDBBRX0_BAD_BLOCK_INFORMATION_SHIFT 0
#define  NFU_NFC_NDBBRX0_BAD_BLOCK_INFORMATION_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDBBRX0_BAD_BLOCK_INFORMATION_MASK) >> NFU_NFC_NDBBRX0_BAD_BLOCK_INFORMATION_SHIFT)
#define  NFU_NFC_NDBBRX0_BAD_BLOCK_INFORMATION_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDBBRX0_BAD_BLOCK_INFORMATION_MASK) | (((uint32_t)val) << NFU_NFC_NDBBRX0_BAD_BLOCK_INFORMATION_SHIFT))

//====================================================================
//Register: NAND Controller Bad Block Registers 0 and 1 (Instance 2 of 2) (NFC_NDBBRx1)
/** \brief The NAND Controller Bad Block registers (NDBBR0 and NDBBR1) hold the bad-block
information when a bad block is detected. NDBBR0 holds the bad-block information
for a bad- block detected for a device interfaced using ND_CS0n (NDSR[CS0_BBD]
is set). Similarly, NDBBR1 holds the bad-block information for a device
interfaced using ND_CS1n (NDSR[CS1_BBD] set).
These are read-only registers. Ignore reads from reserved bits. (Instance 2 of 2)*/
//====================================================================

#define  NFU_NFC_NDBBRX1_BAD_BLOCK_INFORMATION_MASK 0xffffffff
#define  NFU_NFC_NDBBRX1_BAD_BLOCK_INFORMATION_SHIFT 0
#define  NFU_NFC_NDBBRX1_BAD_BLOCK_INFORMATION_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDBBRX1_BAD_BLOCK_INFORMATION_MASK) >> NFU_NFC_NDBBRX1_BAD_BLOCK_INFORMATION_SHIFT)
#define  NFU_NFC_NDBBRX1_BAD_BLOCK_INFORMATION_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDBBRX1_BAD_BLOCK_INFORMATION_MASK) | (((uint32_t)val) << NFU_NFC_NDBBRX1_BAD_BLOCK_INFORMATION_SHIFT))

//====================================================================
//Register: Read Enable Return Delay Register (NFC_NDREDEL)
/** \brief The NAND Read Enable Return Delay register (NDREDEL) is used to specify the
amount of delay added to the latching edge of ND_REn during reads of NAND
devices.*/
//====================================================================

#define  NFU_NFC_NDREDEL_RESERVED1_MASK 0xfe000000
#define  NFU_NFC_NDREDEL_RESERVED1_SHIFT 25
#define  NFU_NFC_NDREDEL_RESERVED1_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDREDEL_RESERVED1_MASK) >> NFU_NFC_NDREDEL_RESERVED1_SHIFT)
#define  NFU_NFC_NDREDEL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDREDEL_RESERVED1_MASK) | (((uint32_t)val) << NFU_NFC_NDREDEL_RESERVED1_SHIFT))

#define  NFU_NFC_NDREDEL_ND_DIN_SEL_MASK 0x1000000
#define  NFU_NFC_NDREDEL_ND_DIN_SEL_SHIFT 24
#define  NFU_NFC_NDREDEL_ND_DIN_SEL_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDREDEL_ND_DIN_SEL_MASK) >> NFU_NFC_NDREDEL_ND_DIN_SEL_SHIFT)
#define  NFU_NFC_NDREDEL_ND_DIN_SEL_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDREDEL_ND_DIN_SEL_MASK) | (((uint32_t)val) << NFU_NFC_NDREDEL_ND_DIN_SEL_SHIFT))

#define  NFU_NFC_NDREDEL_RESERVED2_MASK 0xfffc00
#define  NFU_NFC_NDREDEL_RESERVED2_SHIFT 10
#define  NFU_NFC_NDREDEL_RESERVED2_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDREDEL_RESERVED2_MASK) >> NFU_NFC_NDREDEL_RESERVED2_SHIFT)
#define  NFU_NFC_NDREDEL_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDREDEL_RESERVED2_MASK) | (((uint32_t)val) << NFU_NFC_NDREDEL_RESERVED2_SHIFT))

#define  NFU_NFC_NDREDEL_ND_DATA_DLY_MASK 0x300
#define  NFU_NFC_NDREDEL_ND_DATA_DLY_SHIFT 8
#define  NFU_NFC_NDREDEL_ND_DATA_DLY_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDREDEL_ND_DATA_DLY_MASK) >> NFU_NFC_NDREDEL_ND_DATA_DLY_SHIFT)
#define  NFU_NFC_NDREDEL_ND_DATA_DLY_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDREDEL_ND_DATA_DLY_MASK) | (((uint32_t)val) << NFU_NFC_NDREDEL_ND_DATA_DLY_SHIFT))

#define  NFU_NFC_NDREDEL_ND_RECLK_DLY_MASK 0xf0
#define  NFU_NFC_NDREDEL_ND_RECLK_DLY_SHIFT 4
#define  NFU_NFC_NDREDEL_ND_RECLK_DLY_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDREDEL_ND_RECLK_DLY_MASK) >> NFU_NFC_NDREDEL_ND_RECLK_DLY_SHIFT)
#define  NFU_NFC_NDREDEL_ND_RECLK_DLY_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDREDEL_ND_RECLK_DLY_MASK) | (((uint32_t)val) << NFU_NFC_NDREDEL_ND_RECLK_DLY_SHIFT))

#define  NFU_NFC_NDREDEL_ND_RE_DLY_MASK 0xf
#define  NFU_NFC_NDREDEL_ND_RE_DLY_SHIFT 0
#define  NFU_NFC_NDREDEL_ND_RE_DLY_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDREDEL_ND_RE_DLY_MASK) >> NFU_NFC_NDREDEL_ND_RE_DLY_SHIFT)
#define  NFU_NFC_NDREDEL_ND_RE_DLY_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDREDEL_ND_RE_DLY_MASK) | (((uint32_t)val) << NFU_NFC_NDREDEL_ND_RE_DLY_SHIFT))

//====================================================================
//Register: ECC Control Register (NFC_NDECCCTRL)
/** \brief The roadmaps presented from the NAND suppliers all point to the conclusion that
future devices will have a greater need for a more robust ECC algorithm. This
will be true for SLC devices as process geometries shrink and will be
particularly true for MLC devices as the total stored charge per cell per bit
is 1/4 of that of a SLC. In addition smaller geometries are making read disturbs
more likely. The typical NAND topology is to connect 32 cells in series. This
chain of cells are in a single erase block and are the same bit in a series of
pages in that erase block. For example a 32 cell chain can be bit 0 of byte 0 in
pages 0-31 in erase block 0. Reading page 0 of erase block 0 grounds the word
line for transistor cell 0 with all of the gates of the rest of the cells being
at VCC. This behaves as a weak program of cells 1-31 with the effect that over
time the cells become written to '0' Note that this effect occurs in the pages
not read. Since smaller geometries and MLC introduce a much higher probability
of a read disturb effect, the robustness of the ECC mechanism must substantially
increase. In addition it is highly desirable to enable a qualitative estimate of
read disturb degradation so that as pages become 'worn' from the read disturb
mechanism they can be erased and rewritten. Detection of read disturb upsets
will require periodic page sniffing.
As the data in a page becomes disturbed the number of error bits increases. When
these errors exceed a threshold (determined by the usage model and reliability
requirements) it will be necessary to either garbage collect the erase block
where a page has been read with too many errors or to erase and re-write the
data in place.
The NDECCCTRL register controls the algorithm used to perform ECC, either the
conventional Hamming or a extended ECC, and allows for the setting of
a threshold for error detection. Error counts exceeding this threshold will
generate the CORERR condition, and by enabling the Correctable Error Interrupt,
the processor can be notified when a page should be considered for rewrite or
migration. This capability will be required to support read-after-write for MLC
as well as disturb sniffing.
By definition, correctable errors are within the boundaries of the algorithm,
but the CORERR condition serves as a warning that the boundary is close.
The Hamming ECC is being retained along with the new extended requirements being
added as additional capability. This maintains compatibility with previous
versions of the architecture and in those cases where only single bit correction
is needed implies that no changes to the software stack need to be made.
Currently there are 16 bytes of spare area associated with each 512 byte sector.
For small page devices, 6 of these bytes are currently used to hold the Hamming
ECC, two bytes that cannot be accessed, leaving 8 bytes remaining for software
to implement file system flags and other meta-data. For large page devices,
Hamming ECC requires 24 bytes leaving 40 for meta-data. While only a few bytes,
these spare bytes provide valuable information and make it easier to implement
a low overhead file system. For many reasons that were described in the NAND
Features, Requirements, and Restrictions table in the PXA2128 Datasheet, the
software stack will (eventually) need to be redesigned so that none of the spare
area is used by the software for meta-data, but instead the spare area is solely
reserved for ECC. This is a major change in requirements that is not actually
required over the short term. By enabling backward compatibility the software
implementers have time to implement such an extensive redesign and platform
designers can still implement a design using current NAND capabilities.
Enabling BCH changes the proportion of the spare area dedicated to ECC. The
exact details have been listed in the Spare Area Used for ECC table in the
PXA2128 Datasheet.*/
//====================================================================

#define  NFU_NFC_NDECCCTRL_ECC_STRENGTH_MASK 0xff000000
#define  NFU_NFC_NDECCCTRL_ECC_STRENGTH_SHIFT 24
#define  NFU_NFC_NDECCCTRL_ECC_STRENGTH_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDECCCTRL_ECC_STRENGTH_MASK) >> NFU_NFC_NDECCCTRL_ECC_STRENGTH_SHIFT)
#define  NFU_NFC_NDECCCTRL_ECC_STRENGTH_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDECCCTRL_ECC_STRENGTH_MASK) | (((uint32_t)val) << NFU_NFC_NDECCCTRL_ECC_STRENGTH_SHIFT))

#define  NFU_NFC_NDECCCTRL_RESERVED1_MASK 0xfe0000
#define  NFU_NFC_NDECCCTRL_RESERVED1_SHIFT 17
#define  NFU_NFC_NDECCCTRL_RESERVED1_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDECCCTRL_RESERVED1_MASK) >> NFU_NFC_NDECCCTRL_RESERVED1_SHIFT)
#define  NFU_NFC_NDECCCTRL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDECCCTRL_RESERVED1_MASK) | (((uint32_t)val) << NFU_NFC_NDECCCTRL_RESERVED1_SHIFT))

#define  NFU_NFC_NDECCCTRL_EXT_ECC_THRESH_MASK 0x18000
#define  NFU_NFC_NDECCCTRL_EXT_ECC_THRESH_SHIFT 15
#define  NFU_NFC_NDECCCTRL_EXT_ECC_THRESH_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDECCCTRL_EXT_ECC_THRESH_MASK) >> NFU_NFC_NDECCCTRL_EXT_ECC_THRESH_SHIFT)
#define  NFU_NFC_NDECCCTRL_EXT_ECC_THRESH_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDECCCTRL_EXT_ECC_THRESH_MASK) | (((uint32_t)val) << NFU_NFC_NDECCCTRL_EXT_ECC_THRESH_SHIFT))

#define  NFU_NFC_NDECCCTRL_ECC_SPARE_MASK 0x7f80
#define  NFU_NFC_NDECCCTRL_ECC_SPARE_SHIFT 7
#define  NFU_NFC_NDECCCTRL_ECC_SPARE_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDECCCTRL_ECC_SPARE_MASK) >> NFU_NFC_NDECCCTRL_ECC_SPARE_SHIFT)
#define  NFU_NFC_NDECCCTRL_ECC_SPARE_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDECCCTRL_ECC_SPARE_MASK) | (((uint32_t)val) << NFU_NFC_NDECCCTRL_ECC_SPARE_SHIFT))

#define  NFU_NFC_NDECCCTRL_ECC_THRESH_MASK 0x7e
#define  NFU_NFC_NDECCCTRL_ECC_THRESH_SHIFT 1
#define  NFU_NFC_NDECCCTRL_ECC_THRESH_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDECCCTRL_ECC_THRESH_MASK) >> NFU_NFC_NDECCCTRL_ECC_THRESH_SHIFT)
#define  NFU_NFC_NDECCCTRL_ECC_THRESH_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDECCCTRL_ECC_THRESH_MASK) | (((uint32_t)val) << NFU_NFC_NDECCCTRL_ECC_THRESH_SHIFT))

#define  NFU_NFC_NDECCCTRL_BCH_EN_MASK 0x1
#define  NFU_NFC_NDECCCTRL_BCH_EN_SHIFT 0
#define  NFU_NFC_NDECCCTRL_BCH_EN_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDECCCTRL_BCH_EN_MASK) >> NFU_NFC_NDECCCTRL_BCH_EN_SHIFT)
#define  NFU_NFC_NDECCCTRL_BCH_EN_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDECCCTRL_BCH_EN_MASK) | (((uint32_t)val) << NFU_NFC_NDECCCTRL_BCH_EN_SHIFT))

//====================================================================
//Register: Timer for ND_RDY0 and ND_RDY1 (NFC_NDBZCNT)
/** \brief Because of the nature of the NAND roadmap, low level driver monitoring of the
overall health of the storage media will become increasingly important. SLC NAND
devices have lifetime ratings (i.e. erase/write cycles) in the range of 100,000
cycles. MLC is expected to reduce that to 10,000 cycles, and it may be even
lower. To avoid overuse of any given erase block, flash drivers implement wear
leveling so that all erase blocks tend to have the same number of cycles. One
way to implement this wear leveling is to simply count the number of erase
cycles per block, but this method requires that the counts be stored someplace
non-volatile (i.e. inside the NAND itself) and for each erasure, a new count
would be generated, written into the NAND and this overhead itself contributes
to wear.
Because of the nature of the internal workings of NAND devices, read, program
and erase times can vary. Under initial conditions these times are more at one
end or the other of the specification range but as the device is used, these
times tend to change. Internally to the NAND, program and erase algorithms
repeatedly attempt to read the cell state to verify the data. As the cells wear,
it becomes increasingly difficult to erase a cell to 1 and/or increasingly easy
program a cell to 0. This shows up as a change in the length of time the
internal NAND algorithm takes to perform the operation. Measuring the length of
these operations can be used to determine the overall health of a particular
block and to predict incipient failure. In other words, the length of time the
operations take is related to the wear state of the erase block and so the time
can be used to estimate the erase count obviating the need for independent
storage of the counts.
These busy counts are to support wear leveling and are not related to bad block
management. Blocks have a specified lifetime, but this is not a precise number.
Instead, it is a target, and the actual maximum erase counts will instead have
a statistical distribution around some mean. Once any given block goes bad, it
is bad and must be dealt with accordingly.
The length of the operation is the time that the ND_RDY is in the Busy state. It
should be noted that the exact semantic meaning of the busy indication is
context sensitive and device dependent. To correctly use this register, it will
be necessary to take into account the order of operations, the presence of
caching, and the manufacturers performance data for a specific part. This
register is described in the Timer for ND_RDY0 and ND_RDY1 Register.
To measure the ND_RDY for each connection, there are two 16-bit registers in
this register that simply count the number of cycles that each ND_RDY wire is
low (i.e. busy). When the respective ND_RDY signal has a ready to busy
transition (i.e. goes low), the value is initialized to zero. When the ND_RDY
signal indicates ready (i.e. high) the appropriate count freezes for that
ND_RDYx wire. If the count is about to overflow, the value will stop at 0xFFFF.
The count frequency is the base frequency of the NAND controller and not the bus
frequency.
This register is not synchronized between the NAND clock domain and the bus
(i.e. register read) domain, nor does it need to be. The value in this register
is only valid at the end of an operation when RDY is signalling ready and
therefore the value is stable. The usage model is for the software driver to
receive a RDY interrupt on the ready transition, and to read the value in the
register before another operation is programmed. Real time reads of this
register are not advised because the value in the register must always be
interpreted in a context sensitive manner (i.e. erase cycles always take longer
than program cycles which always take longer than read cycles).
Note: Each counter has 4 "hidden" bits which scale the count value, so the count
value represents the NFC clock frequency divided by 16.*/
//====================================================================

#define  NFU_NFC_NDBZCNT_ND_RDYCNT1_MASK 0xffff0000
#define  NFU_NFC_NDBZCNT_ND_RDYCNT1_SHIFT 16
#define  NFU_NFC_NDBZCNT_ND_RDYCNT1_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDBZCNT_ND_RDYCNT1_MASK) >> NFU_NFC_NDBZCNT_ND_RDYCNT1_SHIFT)
#define  NFU_NFC_NDBZCNT_ND_RDYCNT1_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDBZCNT_ND_RDYCNT1_MASK) | (((uint32_t)val) << NFU_NFC_NDBZCNT_ND_RDYCNT1_SHIFT))

#define  NFU_NFC_NDBZCNT_ND_RDYCNT0_MASK 0xffff
#define  NFU_NFC_NDBZCNT_ND_RDYCNT0_SHIFT 0
#define  NFU_NFC_NDBZCNT_ND_RDYCNT0_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDBZCNT_ND_RDYCNT0_MASK) >> NFU_NFC_NDBZCNT_ND_RDYCNT0_SHIFT)
#define  NFU_NFC_NDBZCNT_ND_RDYCNT0_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDBZCNT_ND_RDYCNT0_MASK) | (((uint32_t)val) << NFU_NFC_NDBZCNT_ND_RDYCNT0_SHIFT))

//====================================================================
//Register: NAND Controller MUTEX Lock Register (NFC_NDMUTEX)
/** \brief If there is more than one processor core and if it is possible that those
processor cores can be in different power states and if it is possible that they
both may want to access data on the NAND, it is necessary to make sure that
there is an ownership MUTEX in the same power state as the NAND controller
itself. To support multi-threaded file systems, the OS maintains file system
locks that the threads "compete" for. This lock serializes and atomizes the OS
update. To share the NAND controller, it is necessary to make sure that the
operations are atomic. For this reason, a MUTEX register is added which allows
the application processor to lock out the low power well processor and vice
versa. This lock-out is not intended to be permanent nor does the MUTEX actually
enforce exclusiveness, it only allows a mechanism for the software on the two
processors to communicate. This register is shown in the next table. Note that
the intent is to allow NAND sharing, not necessarily file sharing. It is
expected that either the two processors would be assigned different partitions
to own or that file sharing complexity would be handled elsewhere.*/
//====================================================================

#define  NFU_NFC_NDMUTEX_RESERVED1_MASK 0xfffffffe
#define  NFU_NFC_NDMUTEX_RESERVED1_SHIFT 1
#define  NFU_NFC_NDMUTEX_RESERVED1_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDMUTEX_RESERVED1_MASK) >> NFU_NFC_NDMUTEX_RESERVED1_SHIFT)
#define  NFU_NFC_NDMUTEX_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDMUTEX_RESERVED1_MASK) | (((uint32_t)val) << NFU_NFC_NDMUTEX_RESERVED1_SHIFT))

#define  NFU_NFC_NDMUTEX_MUTEX_MASK 0x1
#define  NFU_NFC_NDMUTEX_MUTEX_SHIFT 0
#define  NFU_NFC_NDMUTEX_MUTEX_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDMUTEX_MUTEX_MASK) >> NFU_NFC_NDMUTEX_MUTEX_SHIFT)
#define  NFU_NFC_NDMUTEX_MUTEX_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDMUTEX_MUTEX_MASK) | (((uint32_t)val) << NFU_NFC_NDMUTEX_MUTEX_SHIFT))

//====================================================================
//Register: Partition Command Match Registers (Instance 1 of 3) (NFC_NDCMDMAT0)
/** \brief The partition match registers define regions where operations can be allowed or
disallowed. These registers define the commands to be disallowed. There are
three registers only to increase the number of possible matches, otherwise each
register (in fact each subfield group of each register) is identical. There are
three command match fields in each register and three registers so a total of
nine commands can be matched.
The command match is only made against CMD1 in NDCB0. This is both because CMD1
is sufficient to guarantee that you understand if the operation is to be
disallowed and also because there are corner cases where the CMD1/CMD2 match
combination could be spoofed (by using "naked" semantics).
These registers are write once (i.e. the valid field count can be set to non
zero and fields written only one time). These registers can be written before or
after the partition registers, in any order. (Instance 1 of 3)*/
//====================================================================

#define  NFU_NFC_NDCMDMAT0_VALIDCNT_MASK 0xc0000000
#define  NFU_NFC_NDCMDMAT0_VALIDCNT_SHIFT 30
#define  NFU_NFC_NDCMDMAT0_VALIDCNT_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDCMDMAT0_VALIDCNT_MASK) >> NFU_NFC_NDCMDMAT0_VALIDCNT_SHIFT)
#define  NFU_NFC_NDCMDMAT0_VALIDCNT_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDCMDMAT0_VALIDCNT_MASK) | (((uint32_t)val) << NFU_NFC_NDCMDMAT0_VALIDCNT_SHIFT))

#define  NFU_NFC_NDCMDMAT0_NAKEDDIS1_MASK 0x20000000
#define  NFU_NFC_NDCMDMAT0_NAKEDDIS1_SHIFT 29
#define  NFU_NFC_NDCMDMAT0_NAKEDDIS1_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDCMDMAT0_NAKEDDIS1_MASK) >> NFU_NFC_NDCMDMAT0_NAKEDDIS1_SHIFT)
#define  NFU_NFC_NDCMDMAT0_NAKEDDIS1_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDCMDMAT0_NAKEDDIS1_MASK) | (((uint32_t)val) << NFU_NFC_NDCMDMAT0_NAKEDDIS1_SHIFT))

#define  NFU_NFC_NDCMDMAT0_ROWADD1_MASK 0x10000000
#define  NFU_NFC_NDCMDMAT0_ROWADD1_SHIFT 28
#define  NFU_NFC_NDCMDMAT0_ROWADD1_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDCMDMAT0_ROWADD1_MASK) >> NFU_NFC_NDCMDMAT0_ROWADD1_SHIFT)
#define  NFU_NFC_NDCMDMAT0_ROWADD1_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDCMDMAT0_ROWADD1_MASK) | (((uint32_t)val) << NFU_NFC_NDCMDMAT0_ROWADD1_SHIFT))

#define  NFU_NFC_NDCMDMAT0_CMD1_MASK 0xff00000
#define  NFU_NFC_NDCMDMAT0_CMD1_SHIFT 20
#define  NFU_NFC_NDCMDMAT0_CMD1_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDCMDMAT0_CMD1_MASK) >> NFU_NFC_NDCMDMAT0_CMD1_SHIFT)
#define  NFU_NFC_NDCMDMAT0_CMD1_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDCMDMAT0_CMD1_MASK) | (((uint32_t)val) << NFU_NFC_NDCMDMAT0_CMD1_SHIFT))

#define  NFU_NFC_NDCMDMAT0_NAKEDDIS0_MASK 0x80000
#define  NFU_NFC_NDCMDMAT0_NAKEDDIS0_SHIFT 19
#define  NFU_NFC_NDCMDMAT0_NAKEDDIS0_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDCMDMAT0_NAKEDDIS0_MASK) >> NFU_NFC_NDCMDMAT0_NAKEDDIS0_SHIFT)
#define  NFU_NFC_NDCMDMAT0_NAKEDDIS0_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDCMDMAT0_NAKEDDIS0_MASK) | (((uint32_t)val) << NFU_NFC_NDCMDMAT0_NAKEDDIS0_SHIFT))

#define  NFU_NFC_NDCMDMAT0_ROWADD0_MASK 0x40000
#define  NFU_NFC_NDCMDMAT0_ROWADD0_SHIFT 18
#define  NFU_NFC_NDCMDMAT0_ROWADD0_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDCMDMAT0_ROWADD0_MASK) >> NFU_NFC_NDCMDMAT0_ROWADD0_SHIFT)
#define  NFU_NFC_NDCMDMAT0_ROWADD0_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDCMDMAT0_ROWADD0_MASK) | (((uint32_t)val) << NFU_NFC_NDCMDMAT0_ROWADD0_SHIFT))

#define  NFU_NFC_NDCMDMAT0_CMD0_MASK 0x3fc00
#define  NFU_NFC_NDCMDMAT0_CMD0_SHIFT 10
#define  NFU_NFC_NDCMDMAT0_CMD0_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDCMDMAT0_CMD0_MASK) >> NFU_NFC_NDCMDMAT0_CMD0_SHIFT)
#define  NFU_NFC_NDCMDMAT0_CMD0_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDCMDMAT0_CMD0_MASK) | (((uint32_t)val) << NFU_NFC_NDCMDMAT0_CMD0_SHIFT))

#define  NFU_NFC_NDCMDMAT0_NAKEDDIS_MASK 0x200
#define  NFU_NFC_NDCMDMAT0_NAKEDDIS_SHIFT 9
#define  NFU_NFC_NDCMDMAT0_NAKEDDIS_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDCMDMAT0_NAKEDDIS_MASK) >> NFU_NFC_NDCMDMAT0_NAKEDDIS_SHIFT)
#define  NFU_NFC_NDCMDMAT0_NAKEDDIS_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDCMDMAT0_NAKEDDIS_MASK) | (((uint32_t)val) << NFU_NFC_NDCMDMAT0_NAKEDDIS_SHIFT))

#define  NFU_NFC_NDCMDMAT0_ROWADD_MASK 0x100
#define  NFU_NFC_NDCMDMAT0_ROWADD_SHIFT 8
#define  NFU_NFC_NDCMDMAT0_ROWADD_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDCMDMAT0_ROWADD_MASK) >> NFU_NFC_NDCMDMAT0_ROWADD_SHIFT)
#define  NFU_NFC_NDCMDMAT0_ROWADD_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDCMDMAT0_ROWADD_MASK) | (((uint32_t)val) << NFU_NFC_NDCMDMAT0_ROWADD_SHIFT))

#define  NFU_NFC_NDCMDMAT0_CMD_MASK 0xff
#define  NFU_NFC_NDCMDMAT0_CMD_SHIFT 0
#define  NFU_NFC_NDCMDMAT0_CMD_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDCMDMAT0_CMD_MASK) >> NFU_NFC_NDCMDMAT0_CMD_SHIFT)
#define  NFU_NFC_NDCMDMAT0_CMD_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDCMDMAT0_CMD_MASK) | (((uint32_t)val) << NFU_NFC_NDCMDMAT0_CMD_SHIFT))

//====================================================================
//Register: Partition Command Match Registers (Instance 2 of 3) (NFC_NDCMDMAT1)
/** \brief The partition match registers define regions where operations can be allowed or
disallowed. These registers define the commands to be disallowed. There are
three registers only to increase the number of possible matches, otherwise each
register (in fact each subfield group of each register) is identical. There are
three command match fields in each register and three registers so a total of
nine commands can be matched.
The command match is only made against CMD1 in NDCB0. This is both because CMD1
is sufficient to guarantee that you understand if the operation is to be
disallowed and also because there are corner cases where the CMD1/CMD2 match
combination could be spoofed (by using "naked" semantics).
These registers are write once (i.e. the valid field count can be set to non
zero and fields written only one time). These registers can be written before or
after the partition registers, in any order. (Instance 2 of 3)*/
//====================================================================

#define  NFU_NFC_NDCMDMAT1_VALIDCNT_MASK 0xc0000000
#define  NFU_NFC_NDCMDMAT1_VALIDCNT_SHIFT 30
#define  NFU_NFC_NDCMDMAT1_VALIDCNT_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDCMDMAT1_VALIDCNT_MASK) >> NFU_NFC_NDCMDMAT1_VALIDCNT_SHIFT)
#define  NFU_NFC_NDCMDMAT1_VALIDCNT_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDCMDMAT1_VALIDCNT_MASK) | (((uint32_t)val) << NFU_NFC_NDCMDMAT1_VALIDCNT_SHIFT))

#define  NFU_NFC_NDCMDMAT1_NAKEDDIS1_MASK 0x20000000
#define  NFU_NFC_NDCMDMAT1_NAKEDDIS1_SHIFT 29
#define  NFU_NFC_NDCMDMAT1_NAKEDDIS1_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDCMDMAT1_NAKEDDIS1_MASK) >> NFU_NFC_NDCMDMAT1_NAKEDDIS1_SHIFT)
#define  NFU_NFC_NDCMDMAT1_NAKEDDIS1_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDCMDMAT1_NAKEDDIS1_MASK) | (((uint32_t)val) << NFU_NFC_NDCMDMAT1_NAKEDDIS1_SHIFT))

#define  NFU_NFC_NDCMDMAT1_ROWADD1_MASK 0x10000000
#define  NFU_NFC_NDCMDMAT1_ROWADD1_SHIFT 28
#define  NFU_NFC_NDCMDMAT1_ROWADD1_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDCMDMAT1_ROWADD1_MASK) >> NFU_NFC_NDCMDMAT1_ROWADD1_SHIFT)
#define  NFU_NFC_NDCMDMAT1_ROWADD1_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDCMDMAT1_ROWADD1_MASK) | (((uint32_t)val) << NFU_NFC_NDCMDMAT1_ROWADD1_SHIFT))

#define  NFU_NFC_NDCMDMAT1_CMD1_MASK 0xff00000
#define  NFU_NFC_NDCMDMAT1_CMD1_SHIFT 20
#define  NFU_NFC_NDCMDMAT1_CMD1_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDCMDMAT1_CMD1_MASK) >> NFU_NFC_NDCMDMAT1_CMD1_SHIFT)
#define  NFU_NFC_NDCMDMAT1_CMD1_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDCMDMAT1_CMD1_MASK) | (((uint32_t)val) << NFU_NFC_NDCMDMAT1_CMD1_SHIFT))

#define  NFU_NFC_NDCMDMAT1_NAKEDDIS0_MASK 0x80000
#define  NFU_NFC_NDCMDMAT1_NAKEDDIS0_SHIFT 19
#define  NFU_NFC_NDCMDMAT1_NAKEDDIS0_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDCMDMAT1_NAKEDDIS0_MASK) >> NFU_NFC_NDCMDMAT1_NAKEDDIS0_SHIFT)
#define  NFU_NFC_NDCMDMAT1_NAKEDDIS0_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDCMDMAT1_NAKEDDIS0_MASK) | (((uint32_t)val) << NFU_NFC_NDCMDMAT1_NAKEDDIS0_SHIFT))

#define  NFU_NFC_NDCMDMAT1_ROWADD0_MASK 0x40000
#define  NFU_NFC_NDCMDMAT1_ROWADD0_SHIFT 18
#define  NFU_NFC_NDCMDMAT1_ROWADD0_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDCMDMAT1_ROWADD0_MASK) >> NFU_NFC_NDCMDMAT1_ROWADD0_SHIFT)
#define  NFU_NFC_NDCMDMAT1_ROWADD0_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDCMDMAT1_ROWADD0_MASK) | (((uint32_t)val) << NFU_NFC_NDCMDMAT1_ROWADD0_SHIFT))

#define  NFU_NFC_NDCMDMAT1_CMD0_MASK 0x3fc00
#define  NFU_NFC_NDCMDMAT1_CMD0_SHIFT 10
#define  NFU_NFC_NDCMDMAT1_CMD0_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDCMDMAT1_CMD0_MASK) >> NFU_NFC_NDCMDMAT1_CMD0_SHIFT)
#define  NFU_NFC_NDCMDMAT1_CMD0_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDCMDMAT1_CMD0_MASK) | (((uint32_t)val) << NFU_NFC_NDCMDMAT1_CMD0_SHIFT))

#define  NFU_NFC_NDCMDMAT1_NAKEDDIS_MASK 0x200
#define  NFU_NFC_NDCMDMAT1_NAKEDDIS_SHIFT 9
#define  NFU_NFC_NDCMDMAT1_NAKEDDIS_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDCMDMAT1_NAKEDDIS_MASK) >> NFU_NFC_NDCMDMAT1_NAKEDDIS_SHIFT)
#define  NFU_NFC_NDCMDMAT1_NAKEDDIS_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDCMDMAT1_NAKEDDIS_MASK) | (((uint32_t)val) << NFU_NFC_NDCMDMAT1_NAKEDDIS_SHIFT))

#define  NFU_NFC_NDCMDMAT1_ROWADD_MASK 0x100
#define  NFU_NFC_NDCMDMAT1_ROWADD_SHIFT 8
#define  NFU_NFC_NDCMDMAT1_ROWADD_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDCMDMAT1_ROWADD_MASK) >> NFU_NFC_NDCMDMAT1_ROWADD_SHIFT)
#define  NFU_NFC_NDCMDMAT1_ROWADD_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDCMDMAT1_ROWADD_MASK) | (((uint32_t)val) << NFU_NFC_NDCMDMAT1_ROWADD_SHIFT))

#define  NFU_NFC_NDCMDMAT1_CMD_MASK 0xff
#define  NFU_NFC_NDCMDMAT1_CMD_SHIFT 0
#define  NFU_NFC_NDCMDMAT1_CMD_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDCMDMAT1_CMD_MASK) >> NFU_NFC_NDCMDMAT1_CMD_SHIFT)
#define  NFU_NFC_NDCMDMAT1_CMD_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDCMDMAT1_CMD_MASK) | (((uint32_t)val) << NFU_NFC_NDCMDMAT1_CMD_SHIFT))

//====================================================================
//Register: Partition Command Match Registers (Instance 3 of 3) (NFC_NDCMDMAT2)
/** \brief The partition match registers define regions where operations can be allowed or
disallowed. These registers define the commands to be disallowed. There are
three registers only to increase the number of possible matches, otherwise each
register (in fact each subfield group of each register) is identical. There are
three command match fields in each register and three registers so a total of
nine commands can be matched.
The command match is only made against CMD1 in NDCB0. This is both because CMD1
is sufficient to guarantee that you understand if the operation is to be
disallowed and also because there are corner cases where the CMD1/CMD2 match
combination could be spoofed (by using "naked" semantics).
These registers are write once (i.e. the valid field count can be set to non
zero and fields written only one time). These registers can be written before or
after the partition registers, in any order. (Instance 3 of 3)*/
//====================================================================

#define  NFU_NFC_NDCMDMAT2_VALIDCNT_MASK 0xc0000000
#define  NFU_NFC_NDCMDMAT2_VALIDCNT_SHIFT 30
#define  NFU_NFC_NDCMDMAT2_VALIDCNT_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDCMDMAT2_VALIDCNT_MASK) >> NFU_NFC_NDCMDMAT2_VALIDCNT_SHIFT)
#define  NFU_NFC_NDCMDMAT2_VALIDCNT_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDCMDMAT2_VALIDCNT_MASK) | (((uint32_t)val) << NFU_NFC_NDCMDMAT2_VALIDCNT_SHIFT))

#define  NFU_NFC_NDCMDMAT2_NAKEDDIS1_MASK 0x20000000
#define  NFU_NFC_NDCMDMAT2_NAKEDDIS1_SHIFT 29
#define  NFU_NFC_NDCMDMAT2_NAKEDDIS1_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDCMDMAT2_NAKEDDIS1_MASK) >> NFU_NFC_NDCMDMAT2_NAKEDDIS1_SHIFT)
#define  NFU_NFC_NDCMDMAT2_NAKEDDIS1_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDCMDMAT2_NAKEDDIS1_MASK) | (((uint32_t)val) << NFU_NFC_NDCMDMAT2_NAKEDDIS1_SHIFT))

#define  NFU_NFC_NDCMDMAT2_ROWADD1_MASK 0x10000000
#define  NFU_NFC_NDCMDMAT2_ROWADD1_SHIFT 28
#define  NFU_NFC_NDCMDMAT2_ROWADD1_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDCMDMAT2_ROWADD1_MASK) >> NFU_NFC_NDCMDMAT2_ROWADD1_SHIFT)
#define  NFU_NFC_NDCMDMAT2_ROWADD1_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDCMDMAT2_ROWADD1_MASK) | (((uint32_t)val) << NFU_NFC_NDCMDMAT2_ROWADD1_SHIFT))

#define  NFU_NFC_NDCMDMAT2_CMD1_MASK 0xff00000
#define  NFU_NFC_NDCMDMAT2_CMD1_SHIFT 20
#define  NFU_NFC_NDCMDMAT2_CMD1_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDCMDMAT2_CMD1_MASK) >> NFU_NFC_NDCMDMAT2_CMD1_SHIFT)
#define  NFU_NFC_NDCMDMAT2_CMD1_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDCMDMAT2_CMD1_MASK) | (((uint32_t)val) << NFU_NFC_NDCMDMAT2_CMD1_SHIFT))

#define  NFU_NFC_NDCMDMAT2_NAKEDDIS0_MASK 0x80000
#define  NFU_NFC_NDCMDMAT2_NAKEDDIS0_SHIFT 19
#define  NFU_NFC_NDCMDMAT2_NAKEDDIS0_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDCMDMAT2_NAKEDDIS0_MASK) >> NFU_NFC_NDCMDMAT2_NAKEDDIS0_SHIFT)
#define  NFU_NFC_NDCMDMAT2_NAKEDDIS0_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDCMDMAT2_NAKEDDIS0_MASK) | (((uint32_t)val) << NFU_NFC_NDCMDMAT2_NAKEDDIS0_SHIFT))

#define  NFU_NFC_NDCMDMAT2_ROWADD0_MASK 0x40000
#define  NFU_NFC_NDCMDMAT2_ROWADD0_SHIFT 18
#define  NFU_NFC_NDCMDMAT2_ROWADD0_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDCMDMAT2_ROWADD0_MASK) >> NFU_NFC_NDCMDMAT2_ROWADD0_SHIFT)
#define  NFU_NFC_NDCMDMAT2_ROWADD0_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDCMDMAT2_ROWADD0_MASK) | (((uint32_t)val) << NFU_NFC_NDCMDMAT2_ROWADD0_SHIFT))

#define  NFU_NFC_NDCMDMAT2_CMD0_MASK 0x3fc00
#define  NFU_NFC_NDCMDMAT2_CMD0_SHIFT 10
#define  NFU_NFC_NDCMDMAT2_CMD0_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDCMDMAT2_CMD0_MASK) >> NFU_NFC_NDCMDMAT2_CMD0_SHIFT)
#define  NFU_NFC_NDCMDMAT2_CMD0_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDCMDMAT2_CMD0_MASK) | (((uint32_t)val) << NFU_NFC_NDCMDMAT2_CMD0_SHIFT))

#define  NFU_NFC_NDCMDMAT2_NAKEDDIS_MASK 0x200
#define  NFU_NFC_NDCMDMAT2_NAKEDDIS_SHIFT 9
#define  NFU_NFC_NDCMDMAT2_NAKEDDIS_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDCMDMAT2_NAKEDDIS_MASK) >> NFU_NFC_NDCMDMAT2_NAKEDDIS_SHIFT)
#define  NFU_NFC_NDCMDMAT2_NAKEDDIS_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDCMDMAT2_NAKEDDIS_MASK) | (((uint32_t)val) << NFU_NFC_NDCMDMAT2_NAKEDDIS_SHIFT))

#define  NFU_NFC_NDCMDMAT2_ROWADD_MASK 0x100
#define  NFU_NFC_NDCMDMAT2_ROWADD_SHIFT 8
#define  NFU_NFC_NDCMDMAT2_ROWADD_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDCMDMAT2_ROWADD_MASK) >> NFU_NFC_NDCMDMAT2_ROWADD_SHIFT)
#define  NFU_NFC_NDCMDMAT2_ROWADD_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDCMDMAT2_ROWADD_MASK) | (((uint32_t)val) << NFU_NFC_NDCMDMAT2_ROWADD_SHIFT))

#define  NFU_NFC_NDCMDMAT2_CMD_MASK 0xff
#define  NFU_NFC_NDCMDMAT2_CMD_SHIFT 0
#define  NFU_NFC_NDCMDMAT2_CMD_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDCMDMAT2_CMD_MASK) >> NFU_NFC_NDCMDMAT2_CMD_SHIFT)
#define  NFU_NFC_NDCMDMAT2_CMD_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDCMDMAT2_CMD_MASK) | (((uint32_t)val) << NFU_NFC_NDCMDMAT2_CMD_SHIFT))

//====================================================================
//Register: NAND Controller Data Buffer Register (NFC_NDDB)
/** \brief NAND controller data buffer (NDDB) is the read/write port of the NAND
controller data buffer. This register is the source for read-data DMA, and
the destination for write-data DMA. In DMA- disabled mode, the application
processor can access this register. Only 4 byte writes and 4 byte reads are
supported for software accesses to this register, mainly because the
application processor cannot perform an 8-byte read. Read/write operations
to this register must occur in the following order: The first write
corresponds to the lower 4 bytes of the data buffer, and the following
operation corresponds to the upper 4 bytes. Eight byte writes and reads are
supported for DMA access to this register.
This register behaves as though it were a FIFO to the actual 2176 byte data
buffer. The buffer contains 2 KB for the "main" data area plus an
additional 128 bytes to accommodate the currently defined spare size as
well as allow for increases in the future.
When ECC is enabled for Hamming, the <Read Data Request> field in the NAND
Controller Status Register is set once per entire data buffer transfer.
When BCH ECC is enabled, <Read Data Request> is set once per 32 bytes of
data read transfer. If not in DMA mode, the processor must check that this
bit is set after each 32 byte read from this register.
This is a read/write register. Ignore reads from reserved bits. Write 0x0
to reserved bits.*/
//====================================================================

#define  NFU_NFC_NDDB_NAND_FLASH_DATA_MASK 0xffffffff
#define  NFU_NFC_NDDB_NAND_FLASH_DATA_SHIFT 0
#define  NFU_NFC_NDDB_NAND_FLASH_DATA_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDDB_NAND_FLASH_DATA_MASK) >> NFU_NFC_NDDB_NAND_FLASH_DATA_SHIFT)
#define  NFU_NFC_NDDB_NAND_FLASH_DATA_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDDB_NAND_FLASH_DATA_MASK) | (((uint32_t)val) << NFU_NFC_NDDB_NAND_FLASH_DATA_SHIFT))

//====================================================================
//Register: NAND Controller Command Buffer 0 (NFC_NDCB0)
/** \brief The NAND controller-command buffer 0 (NDCB0) holds the commands (CMD1, CMD2) to
be sent to the NAND flash device and command-control (CMD_CTRL) information.
This register determines the overall semantic structure of the command sequence.
This is a read/write register. Ignore reads from reserved bits. Write 0x0 to
reserved bits.*/
//====================================================================

#define  NFU_NFC_NDCB0_CMD_XTYPE_MASK 0xe0000000
#define  NFU_NFC_NDCB0_CMD_XTYPE_SHIFT 29
#define  NFU_NFC_NDCB0_CMD_XTYPE_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDCB0_CMD_XTYPE_MASK) >> NFU_NFC_NDCB0_CMD_XTYPE_SHIFT)
#define  NFU_NFC_NDCB0_CMD_XTYPE_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDCB0_CMD_XTYPE_MASK) | (((uint32_t)val) << NFU_NFC_NDCB0_CMD_XTYPE_SHIFT))

#define  NFU_NFC_NDCB0_LEN_OVRD_MASK 0x10000000
#define  NFU_NFC_NDCB0_LEN_OVRD_SHIFT 28
#define  NFU_NFC_NDCB0_LEN_OVRD_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDCB0_LEN_OVRD_MASK) >> NFU_NFC_NDCB0_LEN_OVRD_SHIFT)
#define  NFU_NFC_NDCB0_LEN_OVRD_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDCB0_LEN_OVRD_MASK) | (((uint32_t)val) << NFU_NFC_NDCB0_LEN_OVRD_SHIFT))

#define  NFU_NFC_NDCB0_RDY_BYP_MASK 0x8000000
#define  NFU_NFC_NDCB0_RDY_BYP_SHIFT 27
#define  NFU_NFC_NDCB0_RDY_BYP_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDCB0_RDY_BYP_MASK) >> NFU_NFC_NDCB0_RDY_BYP_SHIFT)
#define  NFU_NFC_NDCB0_RDY_BYP_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDCB0_RDY_BYP_MASK) | (((uint32_t)val) << NFU_NFC_NDCB0_RDY_BYP_SHIFT))

#define  NFU_NFC_NDCB0_ST_ROW_EN_MASK 0x4000000
#define  NFU_NFC_NDCB0_ST_ROW_EN_SHIFT 26
#define  NFU_NFC_NDCB0_ST_ROW_EN_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDCB0_ST_ROW_EN_MASK) >> NFU_NFC_NDCB0_ST_ROW_EN_SHIFT)
#define  NFU_NFC_NDCB0_ST_ROW_EN_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDCB0_ST_ROW_EN_MASK) | (((uint32_t)val) << NFU_NFC_NDCB0_ST_ROW_EN_SHIFT))

#define  NFU_NFC_NDCB0_AUTO_RS_MASK 0x2000000
#define  NFU_NFC_NDCB0_AUTO_RS_SHIFT 25
#define  NFU_NFC_NDCB0_AUTO_RS_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDCB0_AUTO_RS_MASK) >> NFU_NFC_NDCB0_AUTO_RS_SHIFT)
#define  NFU_NFC_NDCB0_AUTO_RS_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDCB0_AUTO_RS_MASK) | (((uint32_t)val) << NFU_NFC_NDCB0_AUTO_RS_SHIFT))

#define  NFU_NFC_NDCB0_CSEL_MASK 0x1000000
#define  NFU_NFC_NDCB0_CSEL_SHIFT 24
#define  NFU_NFC_NDCB0_CSEL_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDCB0_CSEL_MASK) >> NFU_NFC_NDCB0_CSEL_SHIFT)
#define  NFU_NFC_NDCB0_CSEL_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDCB0_CSEL_MASK) | (((uint32_t)val) << NFU_NFC_NDCB0_CSEL_SHIFT))

#define  NFU_NFC_NDCB0_CMD_TYPE_MASK 0xe00000
#define  NFU_NFC_NDCB0_CMD_TYPE_SHIFT 21
#define  NFU_NFC_NDCB0_CMD_TYPE_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDCB0_CMD_TYPE_MASK) >> NFU_NFC_NDCB0_CMD_TYPE_SHIFT)
#define  NFU_NFC_NDCB0_CMD_TYPE_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDCB0_CMD_TYPE_MASK) | (((uint32_t)val) << NFU_NFC_NDCB0_CMD_TYPE_SHIFT))

#define  NFU_NFC_NDCB0_NC_MASK 0x100000
#define  NFU_NFC_NDCB0_NC_SHIFT 20
#define  NFU_NFC_NDCB0_NC_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDCB0_NC_MASK) >> NFU_NFC_NDCB0_NC_SHIFT)
#define  NFU_NFC_NDCB0_NC_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDCB0_NC_MASK) | (((uint32_t)val) << NFU_NFC_NDCB0_NC_SHIFT))

#define  NFU_NFC_NDCB0_DBC_MASK 0x80000
#define  NFU_NFC_NDCB0_DBC_SHIFT 19
#define  NFU_NFC_NDCB0_DBC_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDCB0_DBC_MASK) >> NFU_NFC_NDCB0_DBC_SHIFT)
#define  NFU_NFC_NDCB0_DBC_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDCB0_DBC_MASK) | (((uint32_t)val) << NFU_NFC_NDCB0_DBC_SHIFT))

#define  NFU_NFC_NDCB0_ADDR_CYC_MASK 0x70000
#define  NFU_NFC_NDCB0_ADDR_CYC_SHIFT 16
#define  NFU_NFC_NDCB0_ADDR_CYC_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDCB0_ADDR_CYC_MASK) >> NFU_NFC_NDCB0_ADDR_CYC_SHIFT)
#define  NFU_NFC_NDCB0_ADDR_CYC_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDCB0_ADDR_CYC_MASK) | (((uint32_t)val) << NFU_NFC_NDCB0_ADDR_CYC_SHIFT))

#define  NFU_NFC_NDCB0_CMD2_MASK 0xff00
#define  NFU_NFC_NDCB0_CMD2_SHIFT 8
#define  NFU_NFC_NDCB0_CMD2_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDCB0_CMD2_MASK) >> NFU_NFC_NDCB0_CMD2_SHIFT)
#define  NFU_NFC_NDCB0_CMD2_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDCB0_CMD2_MASK) | (((uint32_t)val) << NFU_NFC_NDCB0_CMD2_SHIFT))

#define  NFU_NFC_NDCB0_CMD1_MASK 0xff
#define  NFU_NFC_NDCB0_CMD1_SHIFT 0
#define  NFU_NFC_NDCB0_CMD1_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDCB0_CMD1_MASK) >> NFU_NFC_NDCB0_CMD1_SHIFT)
#define  NFU_NFC_NDCB0_CMD1_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDCB0_CMD1_MASK) | (((uint32_t)val) << NFU_NFC_NDCB0_CMD1_SHIFT))

//====================================================================
//Register: NAND Controller Command Buffer 1 (NFC_NDCB1)
/** \brief NAND controller-command buffer 1 (NDCB1) contains the addresses to be sent to
the NAND flash in multiple cycles. In NAND-flash mode, I/O[7:0] pins are used to
send ADDRx[7:0], in as many cycles as defined by the <Number of Address
Cycles> field in the NAND Controller Command Buffer 0. The <ADDR5> field in the
NAND Controller Command Buffer 2 is used to specify the fifth cycle of address
for devices supporting five addressing cycles. Contents of the ADDRx fields are
sent out sequentially by the NAND controller during the addressing phase.
Program these fields with address values based on the cycle-by-cycle addressing
specified by the NAND-flash device.
This is a read-only register. Ignore reads from reserved bits.*/
//====================================================================

#define  NFU_NFC_NDCB1_ADDR4_MASK 0xff000000
#define  NFU_NFC_NDCB1_ADDR4_SHIFT 24
#define  NFU_NFC_NDCB1_ADDR4_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDCB1_ADDR4_MASK) >> NFU_NFC_NDCB1_ADDR4_SHIFT)
#define  NFU_NFC_NDCB1_ADDR4_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDCB1_ADDR4_MASK) | (((uint32_t)val) << NFU_NFC_NDCB1_ADDR4_SHIFT))

#define  NFU_NFC_NDCB1_ADDR3_MASK 0xff0000
#define  NFU_NFC_NDCB1_ADDR3_SHIFT 16
#define  NFU_NFC_NDCB1_ADDR3_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDCB1_ADDR3_MASK) >> NFU_NFC_NDCB1_ADDR3_SHIFT)
#define  NFU_NFC_NDCB1_ADDR3_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDCB1_ADDR3_MASK) | (((uint32_t)val) << NFU_NFC_NDCB1_ADDR3_SHIFT))

#define  NFU_NFC_NDCB1_ADDR2_MASK 0xff00
#define  NFU_NFC_NDCB1_ADDR2_SHIFT 8
#define  NFU_NFC_NDCB1_ADDR2_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDCB1_ADDR2_MASK) >> NFU_NFC_NDCB1_ADDR2_SHIFT)
#define  NFU_NFC_NDCB1_ADDR2_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDCB1_ADDR2_MASK) | (((uint32_t)val) << NFU_NFC_NDCB1_ADDR2_SHIFT))

#define  NFU_NFC_NDCB1_ADDR1_MASK 0xff
#define  NFU_NFC_NDCB1_ADDR1_SHIFT 0
#define  NFU_NFC_NDCB1_ADDR1_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDCB1_ADDR1_MASK) >> NFU_NFC_NDCB1_ADDR1_SHIFT)
#define  NFU_NFC_NDCB1_ADDR1_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDCB1_ADDR1_MASK) | (((uint32_t)val) << NFU_NFC_NDCB1_ADDR1_SHIFT))

//====================================================================
//Register: NAND Controller Command Buffer 2 (NFC_NDCB2)
/** \brief The NAND controller-command buffer 2 (NDCB2) holds the address (ADDR5) for the
fifth addressing cycle in NAND-flash mode and the page count for the command.
This is a read-only register. Ignore reads from reserved bits.*/
//====================================================================

#define  NFU_NFC_NDCB2_ST_MASK_MASK 0xff000000
#define  NFU_NFC_NDCB2_ST_MASK_SHIFT 24
#define  NFU_NFC_NDCB2_ST_MASK_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDCB2_ST_MASK_MASK) >> NFU_NFC_NDCB2_ST_MASK_SHIFT)
#define  NFU_NFC_NDCB2_ST_MASK_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDCB2_ST_MASK_MASK) | (((uint32_t)val) << NFU_NFC_NDCB2_ST_MASK_SHIFT))

#define  NFU_NFC_NDCB2_ST_CMD_MASK 0xff0000
#define  NFU_NFC_NDCB2_ST_CMD_SHIFT 16
#define  NFU_NFC_NDCB2_ST_CMD_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDCB2_ST_CMD_MASK) >> NFU_NFC_NDCB2_ST_CMD_SHIFT)
#define  NFU_NFC_NDCB2_ST_CMD_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDCB2_ST_CMD_MASK) | (((uint32_t)val) << NFU_NFC_NDCB2_ST_CMD_SHIFT))

#define  NFU_NFC_NDCB2_PAGE_COUNT_MASK 0xff00
#define  NFU_NFC_NDCB2_PAGE_COUNT_SHIFT 8
#define  NFU_NFC_NDCB2_PAGE_COUNT_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDCB2_PAGE_COUNT_MASK) >> NFU_NFC_NDCB2_PAGE_COUNT_SHIFT)
#define  NFU_NFC_NDCB2_PAGE_COUNT_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDCB2_PAGE_COUNT_MASK) | (((uint32_t)val) << NFU_NFC_NDCB2_PAGE_COUNT_SHIFT))

#define  NFU_NFC_NDCB2_ADDR5_MASK 0xff
#define  NFU_NFC_NDCB2_ADDR5_SHIFT 0
#define  NFU_NFC_NDCB2_ADDR5_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDCB2_ADDR5_MASK) >> NFU_NFC_NDCB2_ADDR5_SHIFT)
#define  NFU_NFC_NDCB2_ADDR5_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDCB2_ADDR5_MASK) | (((uint32_t)val) << NFU_NFC_NDCB2_ADDR5_SHIFT))

//====================================================================
//Register: NAND Controller Command Buffer 3 (NFC_NDCB3)
/** \brief For increased flexibility and to support ONFI, this register allows arbitrary
length read data transfers. For any transfer that uses this arbitrary length
count, the <Spare Area Enable> field in the Data Flash Control Register must be
disabled or the result will be unpredictable. If the <ECC Enable> field in the
Data Flash Control Register is enabled, ECC is applied as described elsewhere.
Arbitrary length transfers are also not supported on program operations.
The register address is after the NDCBx registers and the register is written as
an optional extension of writing a command block to NDCB0. If the <Length
Override> field in the NAND Controller Command Buffer 0 is false and the <Number
of Address Cycles> field in the NAND Controller Command Buffer 0 < 6, this
register must not be written and a fourth write to NDCB0 is ignored. If <Length
Override> is true or <Number of Address Cycles> >= 6, this register must be
written, even if it is not changing value.*/
//====================================================================

#define  NFU_NFC_NDCB3_ADDR7_MASK 0xff000000
#define  NFU_NFC_NDCB3_ADDR7_SHIFT 24
#define  NFU_NFC_NDCB3_ADDR7_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDCB3_ADDR7_MASK) >> NFU_NFC_NDCB3_ADDR7_SHIFT)
#define  NFU_NFC_NDCB3_ADDR7_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDCB3_ADDR7_MASK) | (((uint32_t)val) << NFU_NFC_NDCB3_ADDR7_SHIFT))

#define  NFU_NFC_NDCB3_ADDR6_MASK 0xff0000
#define  NFU_NFC_NDCB3_ADDR6_SHIFT 16
#define  NFU_NFC_NDCB3_ADDR6_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDCB3_ADDR6_MASK) >> NFU_NFC_NDCB3_ADDR6_SHIFT)
#define  NFU_NFC_NDCB3_ADDR6_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDCB3_ADDR6_MASK) | (((uint32_t)val) << NFU_NFC_NDCB3_ADDR6_SHIFT))

#define  NFU_NFC_NDCB3_NDLENCNT_MASK 0xffff
#define  NFU_NFC_NDCB3_NDLENCNT_SHIFT 0
#define  NFU_NFC_NDCB3_NDLENCNT_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDCB3_NDLENCNT_MASK) >> NFU_NFC_NDCB3_NDLENCNT_SHIFT)
#define  NFU_NFC_NDCB3_NDLENCNT_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDCB3_NDLENCNT_MASK) | (((uint32_t)val) << NFU_NFC_NDCB3_NDLENCNT_SHIFT))

//====================================================================
//Register: NAND DFI Arbitration Control Register (NFC_NDARBCR)
/** \brief The NFC shares the DFI bus with the SMC. The arbitration for the DFI is located
in the NFC. Because the NFC checks for SMC arbitration requests after every
cycle, the fact that the average transfer length of the SMC on the DFI is longer
than the average read or write cycle time for the NFC means that the NFC can get
starved for access to the DFI by the SMC.
Some application environments may need to adjust this access bias. The NAND DFI
Arbitration Control Register guarantees that the NFC will retain the DFI for
a minimum of cycles as defined in the <Arbitration Count> field. The optimal
value is a function of the application and usage model.*/
//====================================================================

#define  NFU_NFC_NDARBCR_RESERVED1_MASK 0xffff0000
#define  NFU_NFC_NDARBCR_RESERVED1_SHIFT 16
#define  NFU_NFC_NDARBCR_RESERVED1_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDARBCR_RESERVED1_MASK) >> NFU_NFC_NDARBCR_RESERVED1_SHIFT)
#define  NFU_NFC_NDARBCR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDARBCR_RESERVED1_MASK) | (((uint32_t)val) << NFU_NFC_NDARBCR_RESERVED1_SHIFT))

#define  NFU_NFC_NDARBCR_ARB_CNT_MASK 0xffff
#define  NFU_NFC_NDARBCR_ARB_CNT_SHIFT 0
#define  NFU_NFC_NDARBCR_ARB_CNT_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDARBCR_ARB_CNT_MASK) >> NFU_NFC_NDARBCR_ARB_CNT_SHIFT)
#define  NFU_NFC_NDARBCR_ARB_CNT_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDARBCR_ARB_CNT_MASK) | (((uint32_t)val) << NFU_NFC_NDARBCR_ARB_CNT_SHIFT))

//====================================================================
//Register: Partition Region Control Registers for CS0 and CS1 (Instance 1 of 8) (NFC_NDPTXCSX0)
/** \brief There are eight partition registers, four assigned to CE0 and four assigned to
CE1. The partition registers define the boundaries between a maximum of four
partitions (where the number "four" comes from the industry standard boot block
table). There is an implied boundary of block zero (not defined in these
registers) and "last block" (the highest addressed block in the NAND) which is
defined in the last partition register for each chip select.
To help enforce trust zones, we need partition tables that determine the
disallowed operations in each partition when not in trust mode. Implementations
that do not implement trust zone in hardware simply perform partition exclusion
tests by comparing CMD1 commands to the NDCMDMAT registers.
In the interests of simplicity, only one partition register is documented. The
Partition entry at address 0x4310_0060 specifies a partition block with an
implied start address of greater than or equal to zero and an ending of the
value in the entry. The partition entry at address 0x4310_0064 specifies
a partition block with a start address greater than that in address 0x4310_0060
and less than or equal to the address in 0x4310_0064, and so on.
Address 0x4310_006C specifies the last block in the NAND, and in fact, it must
be set to the maximum block number. If there are 8192 blocks in the NAND,
NDPT3CSx must be set to 8191, the address of the last block. The reason for this
is that out-of-range address behavior on the NAND devices is not well specified
or not specified at all. If one sets up a protection region at block zero, it
might be possible to program block 0xFFFF and have the NAND device alias the
address to block zero. This would mean that block zero could be programmed even
though it was set up in an excluded partition. The block address in NDPT3CSx is
ANDed with the block address extracted from NDCB{2,3} before being compared to
any partition region. This prevents address wrap spoofing. It is assumed that
the block count is a power of two, in fact this must be true.
The partition boundaries are required to be placed on erase block boundaries so
the <Block Address> field is a block number field. The bits of address which
specify the block number are determined by the <Pages Per Block> and <Row
Address Start Position> fields in the Data Flash Control Register. <Pages Per
Block> causes a bit shift of 5, 6, 7, or 8 bits, depending on the field
value. <Row Address Start Position> causes the block field to start either at
ADDR2 or ADDR3, depending on the value. The number of bits is a function of the
number of pages per block. There is no hardware enforcement for this erase block
boundary condition so the NAND driver software must ensure the consistency of
operations.
Generally, the addresses in these registers must be assigned in strictly
monotonically increasing order up to the last addressed block. This raises the
question of what values should be programmed if there are less than four
partitions. Consider the case of only two partitions, in this case, NDPT0CSx
would contain a value which defines the last block in the first partition and
NDPT1CSx contains the last block in the NAND. What values should NDPT{2,3}CSx be
set to? Well, NDPT3CSx is special and must always be set to the last addressable
NAND block. NDPT2CSx can be set to any value in this case because NDPT{0,1}CSx
completely specify the NAND block address space and there is no number that can
cause NDPT2CSx to match because it would have to be greater than the last block
but less than or equal to itself. Obviously no value can be greater than the
last block when it has been masked with the last block number. Alternatively,
NDPT2CSx could be set to INVALID (i.e. the VALID bit is clear). (Instance 1 of 8)*/
//====================================================================

#define  NFU_NFC_NDPTXCSX0_VALID_MASK 0x80000000
#define  NFU_NFC_NDPTXCSX0_VALID_SHIFT 31
#define  NFU_NFC_NDPTXCSX0_VALID_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDPTXCSX0_VALID_MASK) >> NFU_NFC_NDPTXCSX0_VALID_SHIFT)
#define  NFU_NFC_NDPTXCSX0_VALID_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDPTXCSX0_VALID_MASK) | (((uint32_t)val) << NFU_NFC_NDPTXCSX0_VALID_SHIFT))

#define  NFU_NFC_NDPTXCSX0_LOCK_MASK 0x40000000
#define  NFU_NFC_NDPTXCSX0_LOCK_SHIFT 30
#define  NFU_NFC_NDPTXCSX0_LOCK_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDPTXCSX0_LOCK_MASK) >> NFU_NFC_NDPTXCSX0_LOCK_SHIFT)
#define  NFU_NFC_NDPTXCSX0_LOCK_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDPTXCSX0_LOCK_MASK) | (((uint32_t)val) << NFU_NFC_NDPTXCSX0_LOCK_SHIFT))

#define  NFU_NFC_NDPTXCSX0_TRUSTED_MASK 0x20000000
#define  NFU_NFC_NDPTXCSX0_TRUSTED_SHIFT 29
#define  NFU_NFC_NDPTXCSX0_TRUSTED_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDPTXCSX0_TRUSTED_MASK) >> NFU_NFC_NDPTXCSX0_TRUSTED_SHIFT)
#define  NFU_NFC_NDPTXCSX0_TRUSTED_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDPTXCSX0_TRUSTED_MASK) | (((uint32_t)val) << NFU_NFC_NDPTXCSX0_TRUSTED_SHIFT))

#define  NFU_NFC_NDPTXCSX0_RESERVED1_MASK 0x1f000000
#define  NFU_NFC_NDPTXCSX0_RESERVED1_SHIFT 24
#define  NFU_NFC_NDPTXCSX0_RESERVED1_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDPTXCSX0_RESERVED1_MASK) >> NFU_NFC_NDPTXCSX0_RESERVED1_SHIFT)
#define  NFU_NFC_NDPTXCSX0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDPTXCSX0_RESERVED1_MASK) | (((uint32_t)val) << NFU_NFC_NDPTXCSX0_RESERVED1_SHIFT))

#define  NFU_NFC_NDPTXCSX0_BLOCKADD_MASK 0xffffff
#define  NFU_NFC_NDPTXCSX0_BLOCKADD_SHIFT 0
#define  NFU_NFC_NDPTXCSX0_BLOCKADD_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDPTXCSX0_BLOCKADD_MASK) >> NFU_NFC_NDPTXCSX0_BLOCKADD_SHIFT)
#define  NFU_NFC_NDPTXCSX0_BLOCKADD_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDPTXCSX0_BLOCKADD_MASK) | (((uint32_t)val) << NFU_NFC_NDPTXCSX0_BLOCKADD_SHIFT))

//====================================================================
//Register: Partition Region Control Registers for CS0 and CS1 (Instance 2 of 8) (NFC_NDPTXCSX1)
/** \brief There are eight partition registers, four assigned to CE0 and four assigned to
CE1. The partition registers define the boundaries between a maximum of four
partitions (where the number "four" comes from the industry standard boot block
table). There is an implied boundary of block zero (not defined in these
registers) and "last block" (the highest addressed block in the NAND) which is
defined in the last partition register for each chip select.
To help enforce trust zones, we need partition tables that determine the
disallowed operations in each partition when not in trust mode. Implementations
that do not implement trust zone in hardware simply perform partition exclusion
tests by comparing CMD1 commands to the NDCMDMAT registers.
In the interests of simplicity, only one partition register is documented. The
Partition entry at address 0x4310_0060 specifies a partition block with an
implied start address of greater than or equal to zero and an ending of the
value in the entry. The partition entry at address 0x4310_0064 specifies
a partition block with a start address greater than that in address 0x4310_0060
and less than or equal to the address in 0x4310_0064, and so on.
Address 0x4310_006C specifies the last block in the NAND, and in fact, it must
be set to the maximum block number. If there are 8192 blocks in the NAND,
NDPT3CSx must be set to 8191, the address of the last block. The reason for this
is that out-of-range address behavior on the NAND devices is not well specified
or not specified at all. If one sets up a protection region at block zero, it
might be possible to program block 0xFFFF and have the NAND device alias the
address to block zero. This would mean that block zero could be programmed even
though it was set up in an excluded partition. The block address in NDPT3CSx is
ANDed with the block address extracted from NDCB{2,3} before being compared to
any partition region. This prevents address wrap spoofing. It is assumed that
the block count is a power of two, in fact this must be true.
The partition boundaries are required to be placed on erase block boundaries so
the <Block Address> field is a block number field. The bits of address which
specify the block number are determined by the <Pages Per Block> and <Row
Address Start Position> fields in the Data Flash Control Register. <Pages Per
Block> causes a bit shift of 5, 6, 7, or 8 bits, depending on the field
value. <Row Address Start Position> causes the block field to start either at
ADDR2 or ADDR3, depending on the value. The number of bits is a function of the
number of pages per block. There is no hardware enforcement for this erase block
boundary condition so the NAND driver software must ensure the consistency of
operations.
Generally, the addresses in these registers must be assigned in strictly
monotonically increasing order up to the last addressed block. This raises the
question of what values should be programmed if there are less than four
partitions. Consider the case of only two partitions, in this case, NDPT0CSx
would contain a value which defines the last block in the first partition and
NDPT1CSx contains the last block in the NAND. What values should NDPT{2,3}CSx be
set to? Well, NDPT3CSx is special and must always be set to the last addressable
NAND block. NDPT2CSx can be set to any value in this case because NDPT{0,1}CSx
completely specify the NAND block address space and there is no number that can
cause NDPT2CSx to match because it would have to be greater than the last block
but less than or equal to itself. Obviously no value can be greater than the
last block when it has been masked with the last block number. Alternatively,
NDPT2CSx could be set to INVALID (i.e. the VALID bit is clear). (Instance 2 of 8)*/
//====================================================================

#define  NFU_NFC_NDPTXCSX1_VALID_MASK 0x80000000
#define  NFU_NFC_NDPTXCSX1_VALID_SHIFT 31
#define  NFU_NFC_NDPTXCSX1_VALID_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDPTXCSX1_VALID_MASK) >> NFU_NFC_NDPTXCSX1_VALID_SHIFT)
#define  NFU_NFC_NDPTXCSX1_VALID_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDPTXCSX1_VALID_MASK) | (((uint32_t)val) << NFU_NFC_NDPTXCSX1_VALID_SHIFT))

#define  NFU_NFC_NDPTXCSX1_LOCK_MASK 0x40000000
#define  NFU_NFC_NDPTXCSX1_LOCK_SHIFT 30
#define  NFU_NFC_NDPTXCSX1_LOCK_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDPTXCSX1_LOCK_MASK) >> NFU_NFC_NDPTXCSX1_LOCK_SHIFT)
#define  NFU_NFC_NDPTXCSX1_LOCK_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDPTXCSX1_LOCK_MASK) | (((uint32_t)val) << NFU_NFC_NDPTXCSX1_LOCK_SHIFT))

#define  NFU_NFC_NDPTXCSX1_TRUSTED_MASK 0x20000000
#define  NFU_NFC_NDPTXCSX1_TRUSTED_SHIFT 29
#define  NFU_NFC_NDPTXCSX1_TRUSTED_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDPTXCSX1_TRUSTED_MASK) >> NFU_NFC_NDPTXCSX1_TRUSTED_SHIFT)
#define  NFU_NFC_NDPTXCSX1_TRUSTED_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDPTXCSX1_TRUSTED_MASK) | (((uint32_t)val) << NFU_NFC_NDPTXCSX1_TRUSTED_SHIFT))

#define  NFU_NFC_NDPTXCSX1_RESERVED1_MASK 0x1f000000
#define  NFU_NFC_NDPTXCSX1_RESERVED1_SHIFT 24
#define  NFU_NFC_NDPTXCSX1_RESERVED1_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDPTXCSX1_RESERVED1_MASK) >> NFU_NFC_NDPTXCSX1_RESERVED1_SHIFT)
#define  NFU_NFC_NDPTXCSX1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDPTXCSX1_RESERVED1_MASK) | (((uint32_t)val) << NFU_NFC_NDPTXCSX1_RESERVED1_SHIFT))

#define  NFU_NFC_NDPTXCSX1_BLOCKADD_MASK 0xffffff
#define  NFU_NFC_NDPTXCSX1_BLOCKADD_SHIFT 0
#define  NFU_NFC_NDPTXCSX1_BLOCKADD_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDPTXCSX1_BLOCKADD_MASK) >> NFU_NFC_NDPTXCSX1_BLOCKADD_SHIFT)
#define  NFU_NFC_NDPTXCSX1_BLOCKADD_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDPTXCSX1_BLOCKADD_MASK) | (((uint32_t)val) << NFU_NFC_NDPTXCSX1_BLOCKADD_SHIFT))

//====================================================================
//Register: Partition Region Control Registers for CS0 and CS1 (Instance 3 of 8) (NFC_NDPTXCSX2)
/** \brief There are eight partition registers, four assigned to CE0 and four assigned to
CE1. The partition registers define the boundaries between a maximum of four
partitions (where the number "four" comes from the industry standard boot block
table). There is an implied boundary of block zero (not defined in these
registers) and "last block" (the highest addressed block in the NAND) which is
defined in the last partition register for each chip select.
To help enforce trust zones, we need partition tables that determine the
disallowed operations in each partition when not in trust mode. Implementations
that do not implement trust zone in hardware simply perform partition exclusion
tests by comparing CMD1 commands to the NDCMDMAT registers.
In the interests of simplicity, only one partition register is documented. The
Partition entry at address 0x4310_0060 specifies a partition block with an
implied start address of greater than or equal to zero and an ending of the
value in the entry. The partition entry at address 0x4310_0064 specifies
a partition block with a start address greater than that in address 0x4310_0060
and less than or equal to the address in 0x4310_0064, and so on.
Address 0x4310_006C specifies the last block in the NAND, and in fact, it must
be set to the maximum block number. If there are 8192 blocks in the NAND,
NDPT3CSx must be set to 8191, the address of the last block. The reason for this
is that out-of-range address behavior on the NAND devices is not well specified
or not specified at all. If one sets up a protection region at block zero, it
might be possible to program block 0xFFFF and have the NAND device alias the
address to block zero. This would mean that block zero could be programmed even
though it was set up in an excluded partition. The block address in NDPT3CSx is
ANDed with the block address extracted from NDCB{2,3} before being compared to
any partition region. This prevents address wrap spoofing. It is assumed that
the block count is a power of two, in fact this must be true.
The partition boundaries are required to be placed on erase block boundaries so
the <Block Address> field is a block number field. The bits of address which
specify the block number are determined by the <Pages Per Block> and <Row
Address Start Position> fields in the Data Flash Control Register. <Pages Per
Block> causes a bit shift of 5, 6, 7, or 8 bits, depending on the field
value. <Row Address Start Position> causes the block field to start either at
ADDR2 or ADDR3, depending on the value. The number of bits is a function of the
number of pages per block. There is no hardware enforcement for this erase block
boundary condition so the NAND driver software must ensure the consistency of
operations.
Generally, the addresses in these registers must be assigned in strictly
monotonically increasing order up to the last addressed block. This raises the
question of what values should be programmed if there are less than four
partitions. Consider the case of only two partitions, in this case, NDPT0CSx
would contain a value which defines the last block in the first partition and
NDPT1CSx contains the last block in the NAND. What values should NDPT{2,3}CSx be
set to? Well, NDPT3CSx is special and must always be set to the last addressable
NAND block. NDPT2CSx can be set to any value in this case because NDPT{0,1}CSx
completely specify the NAND block address space and there is no number that can
cause NDPT2CSx to match because it would have to be greater than the last block
but less than or equal to itself. Obviously no value can be greater than the
last block when it has been masked with the last block number. Alternatively,
NDPT2CSx could be set to INVALID (i.e. the VALID bit is clear). (Instance 3 of 8)*/
//====================================================================

#define  NFU_NFC_NDPTXCSX2_VALID_MASK 0x80000000
#define  NFU_NFC_NDPTXCSX2_VALID_SHIFT 31
#define  NFU_NFC_NDPTXCSX2_VALID_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDPTXCSX2_VALID_MASK) >> NFU_NFC_NDPTXCSX2_VALID_SHIFT)
#define  NFU_NFC_NDPTXCSX2_VALID_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDPTXCSX2_VALID_MASK) | (((uint32_t)val) << NFU_NFC_NDPTXCSX2_VALID_SHIFT))

#define  NFU_NFC_NDPTXCSX2_LOCK_MASK 0x40000000
#define  NFU_NFC_NDPTXCSX2_LOCK_SHIFT 30
#define  NFU_NFC_NDPTXCSX2_LOCK_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDPTXCSX2_LOCK_MASK) >> NFU_NFC_NDPTXCSX2_LOCK_SHIFT)
#define  NFU_NFC_NDPTXCSX2_LOCK_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDPTXCSX2_LOCK_MASK) | (((uint32_t)val) << NFU_NFC_NDPTXCSX2_LOCK_SHIFT))

#define  NFU_NFC_NDPTXCSX2_TRUSTED_MASK 0x20000000
#define  NFU_NFC_NDPTXCSX2_TRUSTED_SHIFT 29
#define  NFU_NFC_NDPTXCSX2_TRUSTED_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDPTXCSX2_TRUSTED_MASK) >> NFU_NFC_NDPTXCSX2_TRUSTED_SHIFT)
#define  NFU_NFC_NDPTXCSX2_TRUSTED_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDPTXCSX2_TRUSTED_MASK) | (((uint32_t)val) << NFU_NFC_NDPTXCSX2_TRUSTED_SHIFT))

#define  NFU_NFC_NDPTXCSX2_RESERVED1_MASK 0x1f000000
#define  NFU_NFC_NDPTXCSX2_RESERVED1_SHIFT 24
#define  NFU_NFC_NDPTXCSX2_RESERVED1_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDPTXCSX2_RESERVED1_MASK) >> NFU_NFC_NDPTXCSX2_RESERVED1_SHIFT)
#define  NFU_NFC_NDPTXCSX2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDPTXCSX2_RESERVED1_MASK) | (((uint32_t)val) << NFU_NFC_NDPTXCSX2_RESERVED1_SHIFT))

#define  NFU_NFC_NDPTXCSX2_BLOCKADD_MASK 0xffffff
#define  NFU_NFC_NDPTXCSX2_BLOCKADD_SHIFT 0
#define  NFU_NFC_NDPTXCSX2_BLOCKADD_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDPTXCSX2_BLOCKADD_MASK) >> NFU_NFC_NDPTXCSX2_BLOCKADD_SHIFT)
#define  NFU_NFC_NDPTXCSX2_BLOCKADD_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDPTXCSX2_BLOCKADD_MASK) | (((uint32_t)val) << NFU_NFC_NDPTXCSX2_BLOCKADD_SHIFT))

//====================================================================
//Register: Partition Region Control Registers for CS0 and CS1 (Instance 4 of 8) (NFC_NDPTXCSX3)
/** \brief There are eight partition registers, four assigned to CE0 and four assigned to
CE1. The partition registers define the boundaries between a maximum of four
partitions (where the number "four" comes from the industry standard boot block
table). There is an implied boundary of block zero (not defined in these
registers) and "last block" (the highest addressed block in the NAND) which is
defined in the last partition register for each chip select.
To help enforce trust zones, we need partition tables that determine the
disallowed operations in each partition when not in trust mode. Implementations
that do not implement trust zone in hardware simply perform partition exclusion
tests by comparing CMD1 commands to the NDCMDMAT registers.
In the interests of simplicity, only one partition register is documented. The
Partition entry at address 0x4310_0060 specifies a partition block with an
implied start address of greater than or equal to zero and an ending of the
value in the entry. The partition entry at address 0x4310_0064 specifies
a partition block with a start address greater than that in address 0x4310_0060
and less than or equal to the address in 0x4310_0064, and so on.
Address 0x4310_006C specifies the last block in the NAND, and in fact, it must
be set to the maximum block number. If there are 8192 blocks in the NAND,
NDPT3CSx must be set to 8191, the address of the last block. The reason for this
is that out-of-range address behavior on the NAND devices is not well specified
or not specified at all. If one sets up a protection region at block zero, it
might be possible to program block 0xFFFF and have the NAND device alias the
address to block zero. This would mean that block zero could be programmed even
though it was set up in an excluded partition. The block address in NDPT3CSx is
ANDed with the block address extracted from NDCB{2,3} before being compared to
any partition region. This prevents address wrap spoofing. It is assumed that
the block count is a power of two, in fact this must be true.
The partition boundaries are required to be placed on erase block boundaries so
the <Block Address> field is a block number field. The bits of address which
specify the block number are determined by the <Pages Per Block> and <Row
Address Start Position> fields in the Data Flash Control Register. <Pages Per
Block> causes a bit shift of 5, 6, 7, or 8 bits, depending on the field
value. <Row Address Start Position> causes the block field to start either at
ADDR2 or ADDR3, depending on the value. The number of bits is a function of the
number of pages per block. There is no hardware enforcement for this erase block
boundary condition so the NAND driver software must ensure the consistency of
operations.
Generally, the addresses in these registers must be assigned in strictly
monotonically increasing order up to the last addressed block. This raises the
question of what values should be programmed if there are less than four
partitions. Consider the case of only two partitions, in this case, NDPT0CSx
would contain a value which defines the last block in the first partition and
NDPT1CSx contains the last block in the NAND. What values should NDPT{2,3}CSx be
set to? Well, NDPT3CSx is special and must always be set to the last addressable
NAND block. NDPT2CSx can be set to any value in this case because NDPT{0,1}CSx
completely specify the NAND block address space and there is no number that can
cause NDPT2CSx to match because it would have to be greater than the last block
but less than or equal to itself. Obviously no value can be greater than the
last block when it has been masked with the last block number. Alternatively,
NDPT2CSx could be set to INVALID (i.e. the VALID bit is clear). (Instance 4 of 8)*/
//====================================================================

#define  NFU_NFC_NDPTXCSX3_VALID_MASK 0x80000000
#define  NFU_NFC_NDPTXCSX3_VALID_SHIFT 31
#define  NFU_NFC_NDPTXCSX3_VALID_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDPTXCSX3_VALID_MASK) >> NFU_NFC_NDPTXCSX3_VALID_SHIFT)
#define  NFU_NFC_NDPTXCSX3_VALID_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDPTXCSX3_VALID_MASK) | (((uint32_t)val) << NFU_NFC_NDPTXCSX3_VALID_SHIFT))

#define  NFU_NFC_NDPTXCSX3_LOCK_MASK 0x40000000
#define  NFU_NFC_NDPTXCSX3_LOCK_SHIFT 30
#define  NFU_NFC_NDPTXCSX3_LOCK_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDPTXCSX3_LOCK_MASK) >> NFU_NFC_NDPTXCSX3_LOCK_SHIFT)
#define  NFU_NFC_NDPTXCSX3_LOCK_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDPTXCSX3_LOCK_MASK) | (((uint32_t)val) << NFU_NFC_NDPTXCSX3_LOCK_SHIFT))

#define  NFU_NFC_NDPTXCSX3_TRUSTED_MASK 0x20000000
#define  NFU_NFC_NDPTXCSX3_TRUSTED_SHIFT 29
#define  NFU_NFC_NDPTXCSX3_TRUSTED_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDPTXCSX3_TRUSTED_MASK) >> NFU_NFC_NDPTXCSX3_TRUSTED_SHIFT)
#define  NFU_NFC_NDPTXCSX3_TRUSTED_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDPTXCSX3_TRUSTED_MASK) | (((uint32_t)val) << NFU_NFC_NDPTXCSX3_TRUSTED_SHIFT))

#define  NFU_NFC_NDPTXCSX3_RESERVED1_MASK 0x1f000000
#define  NFU_NFC_NDPTXCSX3_RESERVED1_SHIFT 24
#define  NFU_NFC_NDPTXCSX3_RESERVED1_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDPTXCSX3_RESERVED1_MASK) >> NFU_NFC_NDPTXCSX3_RESERVED1_SHIFT)
#define  NFU_NFC_NDPTXCSX3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDPTXCSX3_RESERVED1_MASK) | (((uint32_t)val) << NFU_NFC_NDPTXCSX3_RESERVED1_SHIFT))

#define  NFU_NFC_NDPTXCSX3_BLOCKADD_MASK 0xffffff
#define  NFU_NFC_NDPTXCSX3_BLOCKADD_SHIFT 0
#define  NFU_NFC_NDPTXCSX3_BLOCKADD_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDPTXCSX3_BLOCKADD_MASK) >> NFU_NFC_NDPTXCSX3_BLOCKADD_SHIFT)
#define  NFU_NFC_NDPTXCSX3_BLOCKADD_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDPTXCSX3_BLOCKADD_MASK) | (((uint32_t)val) << NFU_NFC_NDPTXCSX3_BLOCKADD_SHIFT))

//====================================================================
//Register: Partition Region Control Registers for CS0 and CS1 (Instance 5 of 8) (NFC_NDPTXCSX4)
/** \brief There are eight partition registers, four assigned to CE0 and four assigned to
CE1. The partition registers define the boundaries between a maximum of four
partitions (where the number "four" comes from the industry standard boot block
table). There is an implied boundary of block zero (not defined in these
registers) and "last block" (the highest addressed block in the NAND) which is
defined in the last partition register for each chip select.
To help enforce trust zones, we need partition tables that determine the
disallowed operations in each partition when not in trust mode. Implementations
that do not implement trust zone in hardware simply perform partition exclusion
tests by comparing CMD1 commands to the NDCMDMAT registers.
In the interests of simplicity, only one partition register is documented. The
Partition entry at address 0x4310_0060 specifies a partition block with an
implied start address of greater than or equal to zero and an ending of the
value in the entry. The partition entry at address 0x4310_0064 specifies
a partition block with a start address greater than that in address 0x4310_0060
and less than or equal to the address in 0x4310_0064, and so on.
Address 0x4310_006C specifies the last block in the NAND, and in fact, it must
be set to the maximum block number. If there are 8192 blocks in the NAND,
NDPT3CSx must be set to 8191, the address of the last block. The reason for this
is that out-of-range address behavior on the NAND devices is not well specified
or not specified at all. If one sets up a protection region at block zero, it
might be possible to program block 0xFFFF and have the NAND device alias the
address to block zero. This would mean that block zero could be programmed even
though it was set up in an excluded partition. The block address in NDPT3CSx is
ANDed with the block address extracted from NDCB{2,3} before being compared to
any partition region. This prevents address wrap spoofing. It is assumed that
the block count is a power of two, in fact this must be true.
The partition boundaries are required to be placed on erase block boundaries so
the <Block Address> field is a block number field. The bits of address which
specify the block number are determined by the <Pages Per Block> and <Row
Address Start Position> fields in the Data Flash Control Register. <Pages Per
Block> causes a bit shift of 5, 6, 7, or 8 bits, depending on the field
value. <Row Address Start Position> causes the block field to start either at
ADDR2 or ADDR3, depending on the value. The number of bits is a function of the
number of pages per block. There is no hardware enforcement for this erase block
boundary condition so the NAND driver software must ensure the consistency of
operations.
Generally, the addresses in these registers must be assigned in strictly
monotonically increasing order up to the last addressed block. This raises the
question of what values should be programmed if there are less than four
partitions. Consider the case of only two partitions, in this case, NDPT0CSx
would contain a value which defines the last block in the first partition and
NDPT1CSx contains the last block in the NAND. What values should NDPT{2,3}CSx be
set to? Well, NDPT3CSx is special and must always be set to the last addressable
NAND block. NDPT2CSx can be set to any value in this case because NDPT{0,1}CSx
completely specify the NAND block address space and there is no number that can
cause NDPT2CSx to match because it would have to be greater than the last block
but less than or equal to itself. Obviously no value can be greater than the
last block when it has been masked with the last block number. Alternatively,
NDPT2CSx could be set to INVALID (i.e. the VALID bit is clear). (Instance 5 of 8)*/
//====================================================================

#define  NFU_NFC_NDPTXCSX4_VALID_MASK 0x80000000
#define  NFU_NFC_NDPTXCSX4_VALID_SHIFT 31
#define  NFU_NFC_NDPTXCSX4_VALID_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDPTXCSX4_VALID_MASK) >> NFU_NFC_NDPTXCSX4_VALID_SHIFT)
#define  NFU_NFC_NDPTXCSX4_VALID_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDPTXCSX4_VALID_MASK) | (((uint32_t)val) << NFU_NFC_NDPTXCSX4_VALID_SHIFT))

#define  NFU_NFC_NDPTXCSX4_LOCK_MASK 0x40000000
#define  NFU_NFC_NDPTXCSX4_LOCK_SHIFT 30
#define  NFU_NFC_NDPTXCSX4_LOCK_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDPTXCSX4_LOCK_MASK) >> NFU_NFC_NDPTXCSX4_LOCK_SHIFT)
#define  NFU_NFC_NDPTXCSX4_LOCK_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDPTXCSX4_LOCK_MASK) | (((uint32_t)val) << NFU_NFC_NDPTXCSX4_LOCK_SHIFT))

#define  NFU_NFC_NDPTXCSX4_TRUSTED_MASK 0x20000000
#define  NFU_NFC_NDPTXCSX4_TRUSTED_SHIFT 29
#define  NFU_NFC_NDPTXCSX4_TRUSTED_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDPTXCSX4_TRUSTED_MASK) >> NFU_NFC_NDPTXCSX4_TRUSTED_SHIFT)
#define  NFU_NFC_NDPTXCSX4_TRUSTED_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDPTXCSX4_TRUSTED_MASK) | (((uint32_t)val) << NFU_NFC_NDPTXCSX4_TRUSTED_SHIFT))

#define  NFU_NFC_NDPTXCSX4_RESERVED1_MASK 0x1f000000
#define  NFU_NFC_NDPTXCSX4_RESERVED1_SHIFT 24
#define  NFU_NFC_NDPTXCSX4_RESERVED1_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDPTXCSX4_RESERVED1_MASK) >> NFU_NFC_NDPTXCSX4_RESERVED1_SHIFT)
#define  NFU_NFC_NDPTXCSX4_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDPTXCSX4_RESERVED1_MASK) | (((uint32_t)val) << NFU_NFC_NDPTXCSX4_RESERVED1_SHIFT))

#define  NFU_NFC_NDPTXCSX4_BLOCKADD_MASK 0xffffff
#define  NFU_NFC_NDPTXCSX4_BLOCKADD_SHIFT 0
#define  NFU_NFC_NDPTXCSX4_BLOCKADD_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDPTXCSX4_BLOCKADD_MASK) >> NFU_NFC_NDPTXCSX4_BLOCKADD_SHIFT)
#define  NFU_NFC_NDPTXCSX4_BLOCKADD_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDPTXCSX4_BLOCKADD_MASK) | (((uint32_t)val) << NFU_NFC_NDPTXCSX4_BLOCKADD_SHIFT))

//====================================================================
//Register: Partition Region Control Registers for CS0 and CS1 (Instance 6 of 8) (NFC_NDPTXCSX5)
/** \brief There are eight partition registers, four assigned to CE0 and four assigned to
CE1. The partition registers define the boundaries between a maximum of four
partitions (where the number "four" comes from the industry standard boot block
table). There is an implied boundary of block zero (not defined in these
registers) and "last block" (the highest addressed block in the NAND) which is
defined in the last partition register for each chip select.
To help enforce trust zones, we need partition tables that determine the
disallowed operations in each partition when not in trust mode. Implementations
that do not implement trust zone in hardware simply perform partition exclusion
tests by comparing CMD1 commands to the NDCMDMAT registers.
In the interests of simplicity, only one partition register is documented. The
Partition entry at address 0x4310_0060 specifies a partition block with an
implied start address of greater than or equal to zero and an ending of the
value in the entry. The partition entry at address 0x4310_0064 specifies
a partition block with a start address greater than that in address 0x4310_0060
and less than or equal to the address in 0x4310_0064, and so on.
Address 0x4310_006C specifies the last block in the NAND, and in fact, it must
be set to the maximum block number. If there are 8192 blocks in the NAND,
NDPT3CSx must be set to 8191, the address of the last block. The reason for this
is that out-of-range address behavior on the NAND devices is not well specified
or not specified at all. If one sets up a protection region at block zero, it
might be possible to program block 0xFFFF and have the NAND device alias the
address to block zero. This would mean that block zero could be programmed even
though it was set up in an excluded partition. The block address in NDPT3CSx is
ANDed with the block address extracted from NDCB{2,3} before being compared to
any partition region. This prevents address wrap spoofing. It is assumed that
the block count is a power of two, in fact this must be true.
The partition boundaries are required to be placed on erase block boundaries so
the <Block Address> field is a block number field. The bits of address which
specify the block number are determined by the <Pages Per Block> and <Row
Address Start Position> fields in the Data Flash Control Register. <Pages Per
Block> causes a bit shift of 5, 6, 7, or 8 bits, depending on the field
value. <Row Address Start Position> causes the block field to start either at
ADDR2 or ADDR3, depending on the value. The number of bits is a function of the
number of pages per block. There is no hardware enforcement for this erase block
boundary condition so the NAND driver software must ensure the consistency of
operations.
Generally, the addresses in these registers must be assigned in strictly
monotonically increasing order up to the last addressed block. This raises the
question of what values should be programmed if there are less than four
partitions. Consider the case of only two partitions, in this case, NDPT0CSx
would contain a value which defines the last block in the first partition and
NDPT1CSx contains the last block in the NAND. What values should NDPT{2,3}CSx be
set to? Well, NDPT3CSx is special and must always be set to the last addressable
NAND block. NDPT2CSx can be set to any value in this case because NDPT{0,1}CSx
completely specify the NAND block address space and there is no number that can
cause NDPT2CSx to match because it would have to be greater than the last block
but less than or equal to itself. Obviously no value can be greater than the
last block when it has been masked with the last block number. Alternatively,
NDPT2CSx could be set to INVALID (i.e. the VALID bit is clear). (Instance 6 of 8)*/
//====================================================================

#define  NFU_NFC_NDPTXCSX5_VALID_MASK 0x80000000
#define  NFU_NFC_NDPTXCSX5_VALID_SHIFT 31
#define  NFU_NFC_NDPTXCSX5_VALID_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDPTXCSX5_VALID_MASK) >> NFU_NFC_NDPTXCSX5_VALID_SHIFT)
#define  NFU_NFC_NDPTXCSX5_VALID_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDPTXCSX5_VALID_MASK) | (((uint32_t)val) << NFU_NFC_NDPTXCSX5_VALID_SHIFT))

#define  NFU_NFC_NDPTXCSX5_LOCK_MASK 0x40000000
#define  NFU_NFC_NDPTXCSX5_LOCK_SHIFT 30
#define  NFU_NFC_NDPTXCSX5_LOCK_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDPTXCSX5_LOCK_MASK) >> NFU_NFC_NDPTXCSX5_LOCK_SHIFT)
#define  NFU_NFC_NDPTXCSX5_LOCK_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDPTXCSX5_LOCK_MASK) | (((uint32_t)val) << NFU_NFC_NDPTXCSX5_LOCK_SHIFT))

#define  NFU_NFC_NDPTXCSX5_TRUSTED_MASK 0x20000000
#define  NFU_NFC_NDPTXCSX5_TRUSTED_SHIFT 29
#define  NFU_NFC_NDPTXCSX5_TRUSTED_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDPTXCSX5_TRUSTED_MASK) >> NFU_NFC_NDPTXCSX5_TRUSTED_SHIFT)
#define  NFU_NFC_NDPTXCSX5_TRUSTED_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDPTXCSX5_TRUSTED_MASK) | (((uint32_t)val) << NFU_NFC_NDPTXCSX5_TRUSTED_SHIFT))

#define  NFU_NFC_NDPTXCSX5_RESERVED1_MASK 0x1f000000
#define  NFU_NFC_NDPTXCSX5_RESERVED1_SHIFT 24
#define  NFU_NFC_NDPTXCSX5_RESERVED1_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDPTXCSX5_RESERVED1_MASK) >> NFU_NFC_NDPTXCSX5_RESERVED1_SHIFT)
#define  NFU_NFC_NDPTXCSX5_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDPTXCSX5_RESERVED1_MASK) | (((uint32_t)val) << NFU_NFC_NDPTXCSX5_RESERVED1_SHIFT))

#define  NFU_NFC_NDPTXCSX5_BLOCKADD_MASK 0xffffff
#define  NFU_NFC_NDPTXCSX5_BLOCKADD_SHIFT 0
#define  NFU_NFC_NDPTXCSX5_BLOCKADD_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDPTXCSX5_BLOCKADD_MASK) >> NFU_NFC_NDPTXCSX5_BLOCKADD_SHIFT)
#define  NFU_NFC_NDPTXCSX5_BLOCKADD_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDPTXCSX5_BLOCKADD_MASK) | (((uint32_t)val) << NFU_NFC_NDPTXCSX5_BLOCKADD_SHIFT))

//====================================================================
//Register: Partition Region Control Registers for CS0 and CS1 (Instance 7 of 8) (NFC_NDPTXCSX6)
/** \brief There are eight partition registers, four assigned to CE0 and four assigned to
CE1. The partition registers define the boundaries between a maximum of four
partitions (where the number "four" comes from the industry standard boot block
table). There is an implied boundary of block zero (not defined in these
registers) and "last block" (the highest addressed block in the NAND) which is
defined in the last partition register for each chip select.
To help enforce trust zones, we need partition tables that determine the
disallowed operations in each partition when not in trust mode. Implementations
that do not implement trust zone in hardware simply perform partition exclusion
tests by comparing CMD1 commands to the NDCMDMAT registers.
In the interests of simplicity, only one partition register is documented. The
Partition entry at address 0x4310_0060 specifies a partition block with an
implied start address of greater than or equal to zero and an ending of the
value in the entry. The partition entry at address 0x4310_0064 specifies
a partition block with a start address greater than that in address 0x4310_0060
and less than or equal to the address in 0x4310_0064, and so on.
Address 0x4310_006C specifies the last block in the NAND, and in fact, it must
be set to the maximum block number. If there are 8192 blocks in the NAND,
NDPT3CSx must be set to 8191, the address of the last block. The reason for this
is that out-of-range address behavior on the NAND devices is not well specified
or not specified at all. If one sets up a protection region at block zero, it
might be possible to program block 0xFFFF and have the NAND device alias the
address to block zero. This would mean that block zero could be programmed even
though it was set up in an excluded partition. The block address in NDPT3CSx is
ANDed with the block address extracted from NDCB{2,3} before being compared to
any partition region. This prevents address wrap spoofing. It is assumed that
the block count is a power of two, in fact this must be true.
The partition boundaries are required to be placed on erase block boundaries so
the <Block Address> field is a block number field. The bits of address which
specify the block number are determined by the <Pages Per Block> and <Row
Address Start Position> fields in the Data Flash Control Register. <Pages Per
Block> causes a bit shift of 5, 6, 7, or 8 bits, depending on the field
value. <Row Address Start Position> causes the block field to start either at
ADDR2 or ADDR3, depending on the value. The number of bits is a function of the
number of pages per block. There is no hardware enforcement for this erase block
boundary condition so the NAND driver software must ensure the consistency of
operations.
Generally, the addresses in these registers must be assigned in strictly
monotonically increasing order up to the last addressed block. This raises the
question of what values should be programmed if there are less than four
partitions. Consider the case of only two partitions, in this case, NDPT0CSx
would contain a value which defines the last block in the first partition and
NDPT1CSx contains the last block in the NAND. What values should NDPT{2,3}CSx be
set to? Well, NDPT3CSx is special and must always be set to the last addressable
NAND block. NDPT2CSx can be set to any value in this case because NDPT{0,1}CSx
completely specify the NAND block address space and there is no number that can
cause NDPT2CSx to match because it would have to be greater than the last block
but less than or equal to itself. Obviously no value can be greater than the
last block when it has been masked with the last block number. Alternatively,
NDPT2CSx could be set to INVALID (i.e. the VALID bit is clear). (Instance 7 of 8)*/
//====================================================================

#define  NFU_NFC_NDPTXCSX6_VALID_MASK 0x80000000
#define  NFU_NFC_NDPTXCSX6_VALID_SHIFT 31
#define  NFU_NFC_NDPTXCSX6_VALID_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDPTXCSX6_VALID_MASK) >> NFU_NFC_NDPTXCSX6_VALID_SHIFT)
#define  NFU_NFC_NDPTXCSX6_VALID_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDPTXCSX6_VALID_MASK) | (((uint32_t)val) << NFU_NFC_NDPTXCSX6_VALID_SHIFT))

#define  NFU_NFC_NDPTXCSX6_LOCK_MASK 0x40000000
#define  NFU_NFC_NDPTXCSX6_LOCK_SHIFT 30
#define  NFU_NFC_NDPTXCSX6_LOCK_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDPTXCSX6_LOCK_MASK) >> NFU_NFC_NDPTXCSX6_LOCK_SHIFT)
#define  NFU_NFC_NDPTXCSX6_LOCK_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDPTXCSX6_LOCK_MASK) | (((uint32_t)val) << NFU_NFC_NDPTXCSX6_LOCK_SHIFT))

#define  NFU_NFC_NDPTXCSX6_TRUSTED_MASK 0x20000000
#define  NFU_NFC_NDPTXCSX6_TRUSTED_SHIFT 29
#define  NFU_NFC_NDPTXCSX6_TRUSTED_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDPTXCSX6_TRUSTED_MASK) >> NFU_NFC_NDPTXCSX6_TRUSTED_SHIFT)
#define  NFU_NFC_NDPTXCSX6_TRUSTED_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDPTXCSX6_TRUSTED_MASK) | (((uint32_t)val) << NFU_NFC_NDPTXCSX6_TRUSTED_SHIFT))

#define  NFU_NFC_NDPTXCSX6_RESERVED1_MASK 0x1f000000
#define  NFU_NFC_NDPTXCSX6_RESERVED1_SHIFT 24
#define  NFU_NFC_NDPTXCSX6_RESERVED1_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDPTXCSX6_RESERVED1_MASK) >> NFU_NFC_NDPTXCSX6_RESERVED1_SHIFT)
#define  NFU_NFC_NDPTXCSX6_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDPTXCSX6_RESERVED1_MASK) | (((uint32_t)val) << NFU_NFC_NDPTXCSX6_RESERVED1_SHIFT))

#define  NFU_NFC_NDPTXCSX6_BLOCKADD_MASK 0xffffff
#define  NFU_NFC_NDPTXCSX6_BLOCKADD_SHIFT 0
#define  NFU_NFC_NDPTXCSX6_BLOCKADD_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDPTXCSX6_BLOCKADD_MASK) >> NFU_NFC_NDPTXCSX6_BLOCKADD_SHIFT)
#define  NFU_NFC_NDPTXCSX6_BLOCKADD_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDPTXCSX6_BLOCKADD_MASK) | (((uint32_t)val) << NFU_NFC_NDPTXCSX6_BLOCKADD_SHIFT))

//====================================================================
//Register: Partition Region Control Registers for CS0 and CS1 (Instance 8 of 8) (NFC_NDPTXCSX7)
/** \brief There are eight partition registers, four assigned to CE0 and four assigned to
CE1. The partition registers define the boundaries between a maximum of four
partitions (where the number "four" comes from the industry standard boot block
table). There is an implied boundary of block zero (not defined in these
registers) and "last block" (the highest addressed block in the NAND) which is
defined in the last partition register for each chip select.
To help enforce trust zones, we need partition tables that determine the
disallowed operations in each partition when not in trust mode. Implementations
that do not implement trust zone in hardware simply perform partition exclusion
tests by comparing CMD1 commands to the NDCMDMAT registers.
In the interests of simplicity, only one partition register is documented. The
Partition entry at address 0x4310_0060 specifies a partition block with an
implied start address of greater than or equal to zero and an ending of the
value in the entry. The partition entry at address 0x4310_0064 specifies
a partition block with a start address greater than that in address 0x4310_0060
and less than or equal to the address in 0x4310_0064, and so on.
Address 0x4310_006C specifies the last block in the NAND, and in fact, it must
be set to the maximum block number. If there are 8192 blocks in the NAND,
NDPT3CSx must be set to 8191, the address of the last block. The reason for this
is that out-of-range address behavior on the NAND devices is not well specified
or not specified at all. If one sets up a protection region at block zero, it
might be possible to program block 0xFFFF and have the NAND device alias the
address to block zero. This would mean that block zero could be programmed even
though it was set up in an excluded partition. The block address in NDPT3CSx is
ANDed with the block address extracted from NDCB{2,3} before being compared to
any partition region. This prevents address wrap spoofing. It is assumed that
the block count is a power of two, in fact this must be true.
The partition boundaries are required to be placed on erase block boundaries so
the <Block Address> field is a block number field. The bits of address which
specify the block number are determined by the <Pages Per Block> and <Row
Address Start Position> fields in the Data Flash Control Register. <Pages Per
Block> causes a bit shift of 5, 6, 7, or 8 bits, depending on the field
value. <Row Address Start Position> causes the block field to start either at
ADDR2 or ADDR3, depending on the value. The number of bits is a function of the
number of pages per block. There is no hardware enforcement for this erase block
boundary condition so the NAND driver software must ensure the consistency of
operations.
Generally, the addresses in these registers must be assigned in strictly
monotonically increasing order up to the last addressed block. This raises the
question of what values should be programmed if there are less than four
partitions. Consider the case of only two partitions, in this case, NDPT0CSx
would contain a value which defines the last block in the first partition and
NDPT1CSx contains the last block in the NAND. What values should NDPT{2,3}CSx be
set to? Well, NDPT3CSx is special and must always be set to the last addressable
NAND block. NDPT2CSx can be set to any value in this case because NDPT{0,1}CSx
completely specify the NAND block address space and there is no number that can
cause NDPT2CSx to match because it would have to be greater than the last block
but less than or equal to itself. Obviously no value can be greater than the
last block when it has been masked with the last block number. Alternatively,
NDPT2CSx could be set to INVALID (i.e. the VALID bit is clear). (Instance 8 of 8)*/
//====================================================================

#define  NFU_NFC_NDPTXCSX7_VALID_MASK 0x80000000
#define  NFU_NFC_NDPTXCSX7_VALID_SHIFT 31
#define  NFU_NFC_NDPTXCSX7_VALID_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDPTXCSX7_VALID_MASK) >> NFU_NFC_NDPTXCSX7_VALID_SHIFT)
#define  NFU_NFC_NDPTXCSX7_VALID_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDPTXCSX7_VALID_MASK) | (((uint32_t)val) << NFU_NFC_NDPTXCSX7_VALID_SHIFT))

#define  NFU_NFC_NDPTXCSX7_LOCK_MASK 0x40000000
#define  NFU_NFC_NDPTXCSX7_LOCK_SHIFT 30
#define  NFU_NFC_NDPTXCSX7_LOCK_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDPTXCSX7_LOCK_MASK) >> NFU_NFC_NDPTXCSX7_LOCK_SHIFT)
#define  NFU_NFC_NDPTXCSX7_LOCK_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDPTXCSX7_LOCK_MASK) | (((uint32_t)val) << NFU_NFC_NDPTXCSX7_LOCK_SHIFT))

#define  NFU_NFC_NDPTXCSX7_TRUSTED_MASK 0x20000000
#define  NFU_NFC_NDPTXCSX7_TRUSTED_SHIFT 29
#define  NFU_NFC_NDPTXCSX7_TRUSTED_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDPTXCSX7_TRUSTED_MASK) >> NFU_NFC_NDPTXCSX7_TRUSTED_SHIFT)
#define  NFU_NFC_NDPTXCSX7_TRUSTED_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDPTXCSX7_TRUSTED_MASK) | (((uint32_t)val) << NFU_NFC_NDPTXCSX7_TRUSTED_SHIFT))

#define  NFU_NFC_NDPTXCSX7_RESERVED1_MASK 0x1f000000
#define  NFU_NFC_NDPTXCSX7_RESERVED1_SHIFT 24
#define  NFU_NFC_NDPTXCSX7_RESERVED1_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDPTXCSX7_RESERVED1_MASK) >> NFU_NFC_NDPTXCSX7_RESERVED1_SHIFT)
#define  NFU_NFC_NDPTXCSX7_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDPTXCSX7_RESERVED1_MASK) | (((uint32_t)val) << NFU_NFC_NDPTXCSX7_RESERVED1_SHIFT))

#define  NFU_NFC_NDPTXCSX7_BLOCKADD_MASK 0xffffff
#define  NFU_NFC_NDPTXCSX7_BLOCKADD_SHIFT 0
#define  NFU_NFC_NDPTXCSX7_BLOCKADD_MASK_SHIFT(reg) (((reg) & NFU_NFC_NDPTXCSX7_BLOCKADD_MASK) >> NFU_NFC_NDPTXCSX7_BLOCKADD_SHIFT)
#define  NFU_NFC_NDPTXCSX7_BLOCKADD_REPLACE_VAL(reg,val) (((reg) & ~NFU_NFC_NDPTXCSX7_BLOCKADD_MASK) | (((uint32_t)val) << NFU_NFC_NDPTXCSX7_BLOCKADD_SHIFT))

#endif // NFU
