 /*
 **************************************************************************************
 *
 * (c) Copyright 2013 Marvell International Ltd.
 *
 *
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/.
 *
 **************************************************************************************
 *
 * \file NEWMAN_regmasks.h
 * Generated using RegBuild 1.6.3
 *
 **************************************************************************************
 */

#ifndef _NEWMAN_REGMASKS_H_
#define _NEWMAN_REGMASKS_H_

#ifndef __KERNEL__
#include <stdint.h>
#endif

//====================================================================
//
//Register File: NEWMAN Horizontal Chip Gap Correction (NEWMAN)
/** \brief NEWMAN Horizontal Chip Gap Correction (rev 0 . 0 . 4 . 3)*/
//
//====================================================================

//====================================================================
//Register: NEWMAN Configuration Register (CFG)
/** \brief Overall configuration register for NEWMAN.*/
//====================================================================

#define  NEWMAN_CFG_RESERVED1_MASK 0xfffffffe
#define  NEWMAN_CFG_RESERVED1_SHIFT 1
#define  NEWMAN_CFG_RESERVED1_MASK_SHIFT(reg) (((reg) & NEWMAN_CFG_RESERVED1_MASK) >> NEWMAN_CFG_RESERVED1_SHIFT)
#define  NEWMAN_CFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~NEWMAN_CFG_RESERVED1_MASK) | (((uint32_t)val) << NEWMAN_CFG_RESERVED1_SHIFT))

#define  NEWMAN_CFG_BYPASS_MASK 0x1
#define  NEWMAN_CFG_BYPASS_SHIFT 0
#define  NEWMAN_CFG_BYPASS_MASK_SHIFT(reg) (((reg) & NEWMAN_CFG_BYPASS_MASK) >> NEWMAN_CFG_BYPASS_SHIFT)
#define  NEWMAN_CFG_BYPASS_REPLACE_VAL(reg,val) (((reg) & ~NEWMAN_CFG_BYPASS_MASK) | (((uint32_t)val) << NEWMAN_CFG_BYPASS_SHIFT))

//====================================================================
//Register: NEWMAN Location Register (LOCAT)
/** \brief Controls the chip gap locations via a initial chip gap and a gap to gap spacing.*/
//====================================================================

#define  NEWMAN_LOCAT_WIDTH_MASK 0xffff0000
#define  NEWMAN_LOCAT_WIDTH_SHIFT 16
#define  NEWMAN_LOCAT_WIDTH_MASK_SHIFT(reg) (((reg) & NEWMAN_LOCAT_WIDTH_MASK) >> NEWMAN_LOCAT_WIDTH_SHIFT)
#define  NEWMAN_LOCAT_WIDTH_REPLACE_VAL(reg,val) (((reg) & ~NEWMAN_LOCAT_WIDTH_MASK) | (((uint32_t)val) << NEWMAN_LOCAT_WIDTH_SHIFT))

#define  NEWMAN_LOCAT_START_MASK 0xffff
#define  NEWMAN_LOCAT_START_SHIFT 0
#define  NEWMAN_LOCAT_START_MASK_SHIFT(reg) (((reg) & NEWMAN_LOCAT_START_MASK) >> NEWMAN_LOCAT_START_SHIFT)
#define  NEWMAN_LOCAT_START_REPLACE_VAL(reg,val) (((reg) & ~NEWMAN_LOCAT_START_MASK) | (((uint32_t)val) << NEWMAN_LOCAT_START_SHIFT))

//====================================================================
//Register: NEWMAN Insertion Register 0/3 (INSERT0)
/** \brief Number of pixels to insert for the gaps 0-3. There are up to 16 gaps which requires four registers.*/
//====================================================================

#define  NEWMAN_INSERT0_RESERVED1_MASK 0xf0000000
#define  NEWMAN_INSERT0_RESERVED1_SHIFT 28
#define  NEWMAN_INSERT0_RESERVED1_MASK_SHIFT(reg) (((reg) & NEWMAN_INSERT0_RESERVED1_MASK) >> NEWMAN_INSERT0_RESERVED1_SHIFT)
#define  NEWMAN_INSERT0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~NEWMAN_INSERT0_RESERVED1_MASK) | (((uint32_t)val) << NEWMAN_INSERT0_RESERVED1_SHIFT))

#define  NEWMAN_INSERT0_GAP3_MASK 0xf000000
#define  NEWMAN_INSERT0_GAP3_SHIFT 24
#define  NEWMAN_INSERT0_GAP3_MASK_SHIFT(reg) (((reg) & NEWMAN_INSERT0_GAP3_MASK) >> NEWMAN_INSERT0_GAP3_SHIFT)
#define  NEWMAN_INSERT0_GAP3_REPLACE_VAL(reg,val) (((reg) & ~NEWMAN_INSERT0_GAP3_MASK) | (((uint32_t)val) << NEWMAN_INSERT0_GAP3_SHIFT))

#define  NEWMAN_INSERT0_RESERVED2_MASK 0xf00000
#define  NEWMAN_INSERT0_RESERVED2_SHIFT 20
#define  NEWMAN_INSERT0_RESERVED2_MASK_SHIFT(reg) (((reg) & NEWMAN_INSERT0_RESERVED2_MASK) >> NEWMAN_INSERT0_RESERVED2_SHIFT)
#define  NEWMAN_INSERT0_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~NEWMAN_INSERT0_RESERVED2_MASK) | (((uint32_t)val) << NEWMAN_INSERT0_RESERVED2_SHIFT))

#define  NEWMAN_INSERT0_GAP2_MASK 0xf0000
#define  NEWMAN_INSERT0_GAP2_SHIFT 16
#define  NEWMAN_INSERT0_GAP2_MASK_SHIFT(reg) (((reg) & NEWMAN_INSERT0_GAP2_MASK) >> NEWMAN_INSERT0_GAP2_SHIFT)
#define  NEWMAN_INSERT0_GAP2_REPLACE_VAL(reg,val) (((reg) & ~NEWMAN_INSERT0_GAP2_MASK) | (((uint32_t)val) << NEWMAN_INSERT0_GAP2_SHIFT))

#define  NEWMAN_INSERT0_RESERVED3_MASK 0xf000
#define  NEWMAN_INSERT0_RESERVED3_SHIFT 12
#define  NEWMAN_INSERT0_RESERVED3_MASK_SHIFT(reg) (((reg) & NEWMAN_INSERT0_RESERVED3_MASK) >> NEWMAN_INSERT0_RESERVED3_SHIFT)
#define  NEWMAN_INSERT0_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~NEWMAN_INSERT0_RESERVED3_MASK) | (((uint32_t)val) << NEWMAN_INSERT0_RESERVED3_SHIFT))

#define  NEWMAN_INSERT0_GAP1_MASK 0xf00
#define  NEWMAN_INSERT0_GAP1_SHIFT 8
#define  NEWMAN_INSERT0_GAP1_MASK_SHIFT(reg) (((reg) & NEWMAN_INSERT0_GAP1_MASK) >> NEWMAN_INSERT0_GAP1_SHIFT)
#define  NEWMAN_INSERT0_GAP1_REPLACE_VAL(reg,val) (((reg) & ~NEWMAN_INSERT0_GAP1_MASK) | (((uint32_t)val) << NEWMAN_INSERT0_GAP1_SHIFT))

#define  NEWMAN_INSERT0_RESERVED4_MASK 0xf0
#define  NEWMAN_INSERT0_RESERVED4_SHIFT 4
#define  NEWMAN_INSERT0_RESERVED4_MASK_SHIFT(reg) (((reg) & NEWMAN_INSERT0_RESERVED4_MASK) >> NEWMAN_INSERT0_RESERVED4_SHIFT)
#define  NEWMAN_INSERT0_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~NEWMAN_INSERT0_RESERVED4_MASK) | (((uint32_t)val) << NEWMAN_INSERT0_RESERVED4_SHIFT))

#define  NEWMAN_INSERT0_GAP0_MASK 0xf
#define  NEWMAN_INSERT0_GAP0_SHIFT 0
#define  NEWMAN_INSERT0_GAP0_MASK_SHIFT(reg) (((reg) & NEWMAN_INSERT0_GAP0_MASK) >> NEWMAN_INSERT0_GAP0_SHIFT)
#define  NEWMAN_INSERT0_GAP0_REPLACE_VAL(reg,val) (((reg) & ~NEWMAN_INSERT0_GAP0_MASK) | (((uint32_t)val) << NEWMAN_INSERT0_GAP0_SHIFT))

//====================================================================
//Register: NEWMAN Insertion Register 0/1 (INSERT1)
/** \brief Number of pixels to insert for the gaps 4-7. There are up to 16 gaps which requires four registers.*/
//====================================================================

#define  NEWMAN_INSERT1_RESERVED1_MASK 0xf0000000
#define  NEWMAN_INSERT1_RESERVED1_SHIFT 28
#define  NEWMAN_INSERT1_RESERVED1_MASK_SHIFT(reg) (((reg) & NEWMAN_INSERT1_RESERVED1_MASK) >> NEWMAN_INSERT1_RESERVED1_SHIFT)
#define  NEWMAN_INSERT1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~NEWMAN_INSERT1_RESERVED1_MASK) | (((uint32_t)val) << NEWMAN_INSERT1_RESERVED1_SHIFT))

#define  NEWMAN_INSERT1_GAP7_MASK 0xf000000
#define  NEWMAN_INSERT1_GAP7_SHIFT 24
#define  NEWMAN_INSERT1_GAP7_MASK_SHIFT(reg) (((reg) & NEWMAN_INSERT1_GAP7_MASK) >> NEWMAN_INSERT1_GAP7_SHIFT)
#define  NEWMAN_INSERT1_GAP7_REPLACE_VAL(reg,val) (((reg) & ~NEWMAN_INSERT1_GAP7_MASK) | (((uint32_t)val) << NEWMAN_INSERT1_GAP7_SHIFT))

#define  NEWMAN_INSERT1_RESERVED2_MASK 0xf00000
#define  NEWMAN_INSERT1_RESERVED2_SHIFT 20
#define  NEWMAN_INSERT1_RESERVED2_MASK_SHIFT(reg) (((reg) & NEWMAN_INSERT1_RESERVED2_MASK) >> NEWMAN_INSERT1_RESERVED2_SHIFT)
#define  NEWMAN_INSERT1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~NEWMAN_INSERT1_RESERVED2_MASK) | (((uint32_t)val) << NEWMAN_INSERT1_RESERVED2_SHIFT))

#define  NEWMAN_INSERT1_GAP6_MASK 0xf0000
#define  NEWMAN_INSERT1_GAP6_SHIFT 16
#define  NEWMAN_INSERT1_GAP6_MASK_SHIFT(reg) (((reg) & NEWMAN_INSERT1_GAP6_MASK) >> NEWMAN_INSERT1_GAP6_SHIFT)
#define  NEWMAN_INSERT1_GAP6_REPLACE_VAL(reg,val) (((reg) & ~NEWMAN_INSERT1_GAP6_MASK) | (((uint32_t)val) << NEWMAN_INSERT1_GAP6_SHIFT))

#define  NEWMAN_INSERT1_RESERVED3_MASK 0xf000
#define  NEWMAN_INSERT1_RESERVED3_SHIFT 12
#define  NEWMAN_INSERT1_RESERVED3_MASK_SHIFT(reg) (((reg) & NEWMAN_INSERT1_RESERVED3_MASK) >> NEWMAN_INSERT1_RESERVED3_SHIFT)
#define  NEWMAN_INSERT1_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~NEWMAN_INSERT1_RESERVED3_MASK) | (((uint32_t)val) << NEWMAN_INSERT1_RESERVED3_SHIFT))

#define  NEWMAN_INSERT1_GAP5_MASK 0xf00
#define  NEWMAN_INSERT1_GAP5_SHIFT 8
#define  NEWMAN_INSERT1_GAP5_MASK_SHIFT(reg) (((reg) & NEWMAN_INSERT1_GAP5_MASK) >> NEWMAN_INSERT1_GAP5_SHIFT)
#define  NEWMAN_INSERT1_GAP5_REPLACE_VAL(reg,val) (((reg) & ~NEWMAN_INSERT1_GAP5_MASK) | (((uint32_t)val) << NEWMAN_INSERT1_GAP5_SHIFT))

#define  NEWMAN_INSERT1_RESERVED4_MASK 0xf0
#define  NEWMAN_INSERT1_RESERVED4_SHIFT 4
#define  NEWMAN_INSERT1_RESERVED4_MASK_SHIFT(reg) (((reg) & NEWMAN_INSERT1_RESERVED4_MASK) >> NEWMAN_INSERT1_RESERVED4_SHIFT)
#define  NEWMAN_INSERT1_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~NEWMAN_INSERT1_RESERVED4_MASK) | (((uint32_t)val) << NEWMAN_INSERT1_RESERVED4_SHIFT))

#define  NEWMAN_INSERT1_GAP4_MASK 0xf
#define  NEWMAN_INSERT1_GAP4_SHIFT 0
#define  NEWMAN_INSERT1_GAP4_MASK_SHIFT(reg) (((reg) & NEWMAN_INSERT1_GAP4_MASK) >> NEWMAN_INSERT1_GAP4_SHIFT)
#define  NEWMAN_INSERT1_GAP4_REPLACE_VAL(reg,val) (((reg) & ~NEWMAN_INSERT1_GAP4_MASK) | (((uint32_t)val) << NEWMAN_INSERT1_GAP4_SHIFT))

//====================================================================
//Register: NEWMAN Insertion Register 2/3 (INSERT2)
/** \brief Number of pixels to insert for the gaps 8-11. There are up to 16 gaps which requires four registers.*/
//====================================================================

#define  NEWMAN_INSERT2_RESERVED1_MASK 0xf0000000
#define  NEWMAN_INSERT2_RESERVED1_SHIFT 28
#define  NEWMAN_INSERT2_RESERVED1_MASK_SHIFT(reg) (((reg) & NEWMAN_INSERT2_RESERVED1_MASK) >> NEWMAN_INSERT2_RESERVED1_SHIFT)
#define  NEWMAN_INSERT2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~NEWMAN_INSERT2_RESERVED1_MASK) | (((uint32_t)val) << NEWMAN_INSERT2_RESERVED1_SHIFT))

#define  NEWMAN_INSERT2_GAP11_MASK 0xf000000
#define  NEWMAN_INSERT2_GAP11_SHIFT 24
#define  NEWMAN_INSERT2_GAP11_MASK_SHIFT(reg) (((reg) & NEWMAN_INSERT2_GAP11_MASK) >> NEWMAN_INSERT2_GAP11_SHIFT)
#define  NEWMAN_INSERT2_GAP11_REPLACE_VAL(reg,val) (((reg) & ~NEWMAN_INSERT2_GAP11_MASK) | (((uint32_t)val) << NEWMAN_INSERT2_GAP11_SHIFT))

#define  NEWMAN_INSERT2_RESERVED2_MASK 0xf00000
#define  NEWMAN_INSERT2_RESERVED2_SHIFT 20
#define  NEWMAN_INSERT2_RESERVED2_MASK_SHIFT(reg) (((reg) & NEWMAN_INSERT2_RESERVED2_MASK) >> NEWMAN_INSERT2_RESERVED2_SHIFT)
#define  NEWMAN_INSERT2_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~NEWMAN_INSERT2_RESERVED2_MASK) | (((uint32_t)val) << NEWMAN_INSERT2_RESERVED2_SHIFT))

#define  NEWMAN_INSERT2_GAP10_MASK 0xf0000
#define  NEWMAN_INSERT2_GAP10_SHIFT 16
#define  NEWMAN_INSERT2_GAP10_MASK_SHIFT(reg) (((reg) & NEWMAN_INSERT2_GAP10_MASK) >> NEWMAN_INSERT2_GAP10_SHIFT)
#define  NEWMAN_INSERT2_GAP10_REPLACE_VAL(reg,val) (((reg) & ~NEWMAN_INSERT2_GAP10_MASK) | (((uint32_t)val) << NEWMAN_INSERT2_GAP10_SHIFT))

#define  NEWMAN_INSERT2_RESERVED3_MASK 0xf000
#define  NEWMAN_INSERT2_RESERVED3_SHIFT 12
#define  NEWMAN_INSERT2_RESERVED3_MASK_SHIFT(reg) (((reg) & NEWMAN_INSERT2_RESERVED3_MASK) >> NEWMAN_INSERT2_RESERVED3_SHIFT)
#define  NEWMAN_INSERT2_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~NEWMAN_INSERT2_RESERVED3_MASK) | (((uint32_t)val) << NEWMAN_INSERT2_RESERVED3_SHIFT))

#define  NEWMAN_INSERT2_GAP9_MASK 0xf00
#define  NEWMAN_INSERT2_GAP9_SHIFT 8
#define  NEWMAN_INSERT2_GAP9_MASK_SHIFT(reg) (((reg) & NEWMAN_INSERT2_GAP9_MASK) >> NEWMAN_INSERT2_GAP9_SHIFT)
#define  NEWMAN_INSERT2_GAP9_REPLACE_VAL(reg,val) (((reg) & ~NEWMAN_INSERT2_GAP9_MASK) | (((uint32_t)val) << NEWMAN_INSERT2_GAP9_SHIFT))

#define  NEWMAN_INSERT2_RESERVED4_MASK 0xf0
#define  NEWMAN_INSERT2_RESERVED4_SHIFT 4
#define  NEWMAN_INSERT2_RESERVED4_MASK_SHIFT(reg) (((reg) & NEWMAN_INSERT2_RESERVED4_MASK) >> NEWMAN_INSERT2_RESERVED4_SHIFT)
#define  NEWMAN_INSERT2_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~NEWMAN_INSERT2_RESERVED4_MASK) | (((uint32_t)val) << NEWMAN_INSERT2_RESERVED4_SHIFT))

#define  NEWMAN_INSERT2_GAP8_MASK 0xf
#define  NEWMAN_INSERT2_GAP8_SHIFT 0
#define  NEWMAN_INSERT2_GAP8_MASK_SHIFT(reg) (((reg) & NEWMAN_INSERT2_GAP8_MASK) >> NEWMAN_INSERT2_GAP8_SHIFT)
#define  NEWMAN_INSERT2_GAP8_REPLACE_VAL(reg,val) (((reg) & ~NEWMAN_INSERT2_GAP8_MASK) | (((uint32_t)val) << NEWMAN_INSERT2_GAP8_SHIFT))

//====================================================================
//Register: NEWMAN Insertion Register 3/3 (INSERT3)
/** \brief Number of pixels to insert for the gaps 12-15. There are up to 16 gaps which requires four registers.*/
//====================================================================

#define  NEWMAN_INSERT3_RESERVED1_MASK 0xf0000000
#define  NEWMAN_INSERT3_RESERVED1_SHIFT 28
#define  NEWMAN_INSERT3_RESERVED1_MASK_SHIFT(reg) (((reg) & NEWMAN_INSERT3_RESERVED1_MASK) >> NEWMAN_INSERT3_RESERVED1_SHIFT)
#define  NEWMAN_INSERT3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~NEWMAN_INSERT3_RESERVED1_MASK) | (((uint32_t)val) << NEWMAN_INSERT3_RESERVED1_SHIFT))

#define  NEWMAN_INSERT3_GAP15_MASK 0xf000000
#define  NEWMAN_INSERT3_GAP15_SHIFT 24
#define  NEWMAN_INSERT3_GAP15_MASK_SHIFT(reg) (((reg) & NEWMAN_INSERT3_GAP15_MASK) >> NEWMAN_INSERT3_GAP15_SHIFT)
#define  NEWMAN_INSERT3_GAP15_REPLACE_VAL(reg,val) (((reg) & ~NEWMAN_INSERT3_GAP15_MASK) | (((uint32_t)val) << NEWMAN_INSERT3_GAP15_SHIFT))

#define  NEWMAN_INSERT3_RESERVED2_MASK 0xf00000
#define  NEWMAN_INSERT3_RESERVED2_SHIFT 20
#define  NEWMAN_INSERT3_RESERVED2_MASK_SHIFT(reg) (((reg) & NEWMAN_INSERT3_RESERVED2_MASK) >> NEWMAN_INSERT3_RESERVED2_SHIFT)
#define  NEWMAN_INSERT3_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~NEWMAN_INSERT3_RESERVED2_MASK) | (((uint32_t)val) << NEWMAN_INSERT3_RESERVED2_SHIFT))

#define  NEWMAN_INSERT3_GAP14_MASK 0xf0000
#define  NEWMAN_INSERT3_GAP14_SHIFT 16
#define  NEWMAN_INSERT3_GAP14_MASK_SHIFT(reg) (((reg) & NEWMAN_INSERT3_GAP14_MASK) >> NEWMAN_INSERT3_GAP14_SHIFT)
#define  NEWMAN_INSERT3_GAP14_REPLACE_VAL(reg,val) (((reg) & ~NEWMAN_INSERT3_GAP14_MASK) | (((uint32_t)val) << NEWMAN_INSERT3_GAP14_SHIFT))

#define  NEWMAN_INSERT3_RESERVED3_MASK 0xf000
#define  NEWMAN_INSERT3_RESERVED3_SHIFT 12
#define  NEWMAN_INSERT3_RESERVED3_MASK_SHIFT(reg) (((reg) & NEWMAN_INSERT3_RESERVED3_MASK) >> NEWMAN_INSERT3_RESERVED3_SHIFT)
#define  NEWMAN_INSERT3_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~NEWMAN_INSERT3_RESERVED3_MASK) | (((uint32_t)val) << NEWMAN_INSERT3_RESERVED3_SHIFT))

#define  NEWMAN_INSERT3_GAP13_MASK 0xf00
#define  NEWMAN_INSERT3_GAP13_SHIFT 8
#define  NEWMAN_INSERT3_GAP13_MASK_SHIFT(reg) (((reg) & NEWMAN_INSERT3_GAP13_MASK) >> NEWMAN_INSERT3_GAP13_SHIFT)
#define  NEWMAN_INSERT3_GAP13_REPLACE_VAL(reg,val) (((reg) & ~NEWMAN_INSERT3_GAP13_MASK) | (((uint32_t)val) << NEWMAN_INSERT3_GAP13_SHIFT))

#define  NEWMAN_INSERT3_RESERVED4_MASK 0xf0
#define  NEWMAN_INSERT3_RESERVED4_SHIFT 4
#define  NEWMAN_INSERT3_RESERVED4_MASK_SHIFT(reg) (((reg) & NEWMAN_INSERT3_RESERVED4_MASK) >> NEWMAN_INSERT3_RESERVED4_SHIFT)
#define  NEWMAN_INSERT3_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~NEWMAN_INSERT3_RESERVED4_MASK) | (((uint32_t)val) << NEWMAN_INSERT3_RESERVED4_SHIFT))

#define  NEWMAN_INSERT3_GAP12_MASK 0xf
#define  NEWMAN_INSERT3_GAP12_SHIFT 0
#define  NEWMAN_INSERT3_GAP12_MASK_SHIFT(reg) (((reg) & NEWMAN_INSERT3_GAP12_MASK) >> NEWMAN_INSERT3_GAP12_SHIFT)
#define  NEWMAN_INSERT3_GAP12_REPLACE_VAL(reg,val) (((reg) & ~NEWMAN_INSERT3_GAP12_MASK) | (((uint32_t)val) << NEWMAN_INSERT3_GAP12_SHIFT))

//====================================================================
//Register: IP Tagging Revision 0 (REV0)
/** \brief Provide means for firmware to read IP tagging information.
      This register of particular interest to firmware.*/
//====================================================================

#define  NEWMAN_REV0_MAJ_MASK 0xffff0000
#define  NEWMAN_REV0_MAJ_SHIFT 16
#define  NEWMAN_REV0_MAJ_MASK_SHIFT(reg) (((reg) & NEWMAN_REV0_MAJ_MASK) >> NEWMAN_REV0_MAJ_SHIFT)
#define  NEWMAN_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~NEWMAN_REV0_MAJ_MASK) | (((uint32_t)val) << NEWMAN_REV0_MAJ_SHIFT))

#define  NEWMAN_REV0_MID_MASK 0xffff
#define  NEWMAN_REV0_MID_SHIFT 0
#define  NEWMAN_REV0_MID_MASK_SHIFT(reg) (((reg) & NEWMAN_REV0_MID_MASK) >> NEWMAN_REV0_MID_SHIFT)
#define  NEWMAN_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~NEWMAN_REV0_MID_MASK) | (((uint32_t)val) << NEWMAN_REV0_MID_SHIFT))

//====================================================================
//Register: IP Tagging Revision 1 (REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  NEWMAN_REV1_RESERVED1_MASK 0xffff0000
#define  NEWMAN_REV1_RESERVED1_SHIFT 16
#define  NEWMAN_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & NEWMAN_REV1_RESERVED1_MASK) >> NEWMAN_REV1_RESERVED1_SHIFT)
#define  NEWMAN_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~NEWMAN_REV1_RESERVED1_MASK) | (((uint32_t)val) << NEWMAN_REV1_RESERVED1_SHIFT))

#define  NEWMAN_REV1_CFG_MASK 0xffff
#define  NEWMAN_REV1_CFG_SHIFT 0
#define  NEWMAN_REV1_CFG_MASK_SHIFT(reg) (((reg) & NEWMAN_REV1_CFG_MASK) >> NEWMAN_REV1_CFG_SHIFT)
#define  NEWMAN_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~NEWMAN_REV1_CFG_MASK) | (((uint32_t)val) << NEWMAN_REV1_CFG_SHIFT))

#endif // NEWMAN
