 /*
 **************************************************************************************
 *
 * (c) Copyright 2013 Marvell International Ltd.
 *
 *
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/.
 *
 **************************************************************************************
 *
 * \file MC_regmasks.h
 * Generated using RegBuild 1.6.3
 *
 **************************************************************************************
 */

#ifndef _MC_REGMASKS_H_
#define _MC_REGMASKS_H_

#ifndef __KERNEL__
#include <stdint.h>
#endif

//====================================================================
//
//Register File: MC (MC)
/** \brief This defines the registers for the Memory Controller (MC).*/
//
//====================================================================

//====================================================================
//Register: Memory Controller ID and Revision Register (MC_ID)
//====================================================================

#define  MC_MC_ID_RESERVED1_MASK 0xc0000000
#define  MC_MC_ID_RESERVED1_SHIFT 30
#define  MC_MC_ID_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_MC_ID_RESERVED1_MASK) >> MC_MC_ID_RESERVED1_SHIFT)
#define  MC_MC_ID_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_ID_RESERVED1_MASK) | (((uint32_t)val) << MC_MC_ID_RESERVED1_SHIFT))

#define  MC_MC_ID_SHADOWMEM_MASK 0x20000000
#define  MC_MC_ID_SHADOWMEM_SHIFT 29
#define  MC_MC_ID_SHADOWMEM_MASK_SHIFT(reg) (((reg) & MC_MC_ID_SHADOWMEM_MASK) >> MC_MC_ID_SHADOWMEM_SHIFT)
#define  MC_MC_ID_SHADOWMEM_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_ID_SHADOWMEM_MASK) | (((uint32_t)val) << MC_MC_ID_SHADOWMEM_SHIFT))

#define  MC_MC_ID_DUALCHANNEL_MASK 0x10000000
#define  MC_MC_ID_DUALCHANNEL_SHIFT 28
#define  MC_MC_ID_DUALCHANNEL_MASK_SHIFT(reg) (((reg) & MC_MC_ID_DUALCHANNEL_MASK) >> MC_MC_ID_DUALCHANNEL_SHIFT)
#define  MC_MC_ID_DUALCHANNEL_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_ID_DUALCHANNEL_MASK) | (((uint32_t)val) << MC_MC_ID_DUALCHANNEL_SHIFT))

#define  MC_MC_ID_ARCHITECTUREVER_MASK 0xf000000
#define  MC_MC_ID_ARCHITECTUREVER_SHIFT 24
#define  MC_MC_ID_ARCHITECTUREVER_MASK_SHIFT(reg) (((reg) & MC_MC_ID_ARCHITECTUREVER_MASK) >> MC_MC_ID_ARCHITECTUREVER_SHIFT)
#define  MC_MC_ID_ARCHITECTUREVER_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_ID_ARCHITECTUREVER_MASK) | (((uint32_t)val) << MC_MC_ID_ARCHITECTUREVER_SHIFT))

#define  MC_MC_ID_REL_YEAR_MASK 0xf00000
#define  MC_MC_ID_REL_YEAR_SHIFT 20
#define  MC_MC_ID_REL_YEAR_MASK_SHIFT(reg) (((reg) & MC_MC_ID_REL_YEAR_MASK) >> MC_MC_ID_REL_YEAR_SHIFT)
#define  MC_MC_ID_REL_YEAR_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_ID_REL_YEAR_MASK) | (((uint32_t)val) << MC_MC_ID_REL_YEAR_SHIFT))

#define  MC_MC_ID_REL_MONTH_MASK 0xff000
#define  MC_MC_ID_REL_MONTH_SHIFT 12
#define  MC_MC_ID_REL_MONTH_MASK_SHIFT(reg) (((reg) & MC_MC_ID_REL_MONTH_MASK) >> MC_MC_ID_REL_MONTH_SHIFT)
#define  MC_MC_ID_REL_MONTH_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_ID_REL_MONTH_MASK) | (((uint32_t)val) << MC_MC_ID_REL_MONTH_SHIFT))

#define  MC_MC_ID_REL_DATE_MASK 0xff0
#define  MC_MC_ID_REL_DATE_SHIFT 4
#define  MC_MC_ID_REL_DATE_MASK_SHIFT(reg) (((reg) & MC_MC_ID_REL_DATE_MASK) >> MC_MC_ID_REL_DATE_SHIFT)
#define  MC_MC_ID_REL_DATE_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_ID_REL_DATE_MASK) | (((uint32_t)val) << MC_MC_ID_REL_DATE_SHIFT))

#define  MC_MC_ID_REV_ECO_MASK 0xf
#define  MC_MC_ID_REV_ECO_SHIFT 0
#define  MC_MC_ID_REV_ECO_MASK_SHIFT(reg) (((reg) & MC_MC_ID_REV_ECO_MASK) >> MC_MC_ID_REV_ECO_SHIFT)
#define  MC_MC_ID_REV_ECO_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_ID_REV_ECO_MASK) | (((uint32_t)val) << MC_MC_ID_REV_ECO_SHIFT))

//====================================================================
//Register: Memory Controller Status Register (MC_STATUS)
//====================================================================

#define  MC_MC_STATUS_RESERVED1_MASK 0xff800000
#define  MC_MC_STATUS_RESERVED1_SHIFT 23
#define  MC_MC_STATUS_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_MC_STATUS_RESERVED1_MASK) >> MC_MC_STATUS_RESERVED1_SHIFT)
#define  MC_MC_STATUS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_STATUS_RESERVED1_MASK) | (((uint32_t)val) << MC_MC_STATUS_RESERVED1_SHIFT))

#define  MC_MC_STATUS_DPCW_IDLE_1_MASK 0x400000
#define  MC_MC_STATUS_DPCW_IDLE_1_SHIFT 22
#define  MC_MC_STATUS_DPCW_IDLE_1_MASK_SHIFT(reg) (((reg) & MC_MC_STATUS_DPCW_IDLE_1_MASK) >> MC_MC_STATUS_DPCW_IDLE_1_SHIFT)
#define  MC_MC_STATUS_DPCW_IDLE_1_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_STATUS_DPCW_IDLE_1_MASK) | (((uint32_t)val) << MC_MC_STATUS_DPCW_IDLE_1_SHIFT))

#define  MC_MC_STATUS_DPCR_IDLE_1_MASK 0x200000
#define  MC_MC_STATUS_DPCR_IDLE_1_SHIFT 21
#define  MC_MC_STATUS_DPCR_IDLE_1_MASK_SHIFT(reg) (((reg) & MC_MC_STATUS_DPCR_IDLE_1_MASK) >> MC_MC_STATUS_DPCR_IDLE_1_SHIFT)
#define  MC_MC_STATUS_DPCR_IDLE_1_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_STATUS_DPCR_IDLE_1_MASK) | (((uint32_t)val) << MC_MC_STATUS_DPCR_IDLE_1_SHIFT))

#define  MC_MC_STATUS_TC_IDLE_1_MASK 0x100000
#define  MC_MC_STATUS_TC_IDLE_1_SHIFT 20
#define  MC_MC_STATUS_TC_IDLE_1_MASK_SHIFT(reg) (((reg) & MC_MC_STATUS_TC_IDLE_1_MASK) >> MC_MC_STATUS_TC_IDLE_1_SHIFT)
#define  MC_MC_STATUS_TC_IDLE_1_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_STATUS_TC_IDLE_1_MASK) | (((uint32_t)val) << MC_MC_STATUS_TC_IDLE_1_SHIFT))

#define  MC_MC_STATUS_BQ_EMPTY_1_MASK 0x80000
#define  MC_MC_STATUS_BQ_EMPTY_1_SHIFT 19
#define  MC_MC_STATUS_BQ_EMPTY_1_MASK_SHIFT(reg) (((reg) & MC_MC_STATUS_BQ_EMPTY_1_MASK) >> MC_MC_STATUS_BQ_EMPTY_1_SHIFT)
#define  MC_MC_STATUS_BQ_EMPTY_1_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_STATUS_BQ_EMPTY_1_MASK) | (((uint32_t)val) << MC_MC_STATUS_BQ_EMPTY_1_SHIFT))

#define  MC_MC_STATUS_SMTQ_IDLE_1_MASK 0x40000
#define  MC_MC_STATUS_SMTQ_IDLE_1_SHIFT 18
#define  MC_MC_STATUS_SMTQ_IDLE_1_MASK_SHIFT(reg) (((reg) & MC_MC_STATUS_SMTQ_IDLE_1_MASK) >> MC_MC_STATUS_SMTQ_IDLE_1_SHIFT)
#define  MC_MC_STATUS_SMTQ_IDLE_1_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_STATUS_SMTQ_IDLE_1_MASK) | (((uint32_t)val) << MC_MC_STATUS_SMTQ_IDLE_1_SHIFT))

#define  MC_MC_STATUS_RESERVED2_MASK 0x20000
#define  MC_MC_STATUS_RESERVED2_SHIFT 17
#define  MC_MC_STATUS_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_MC_STATUS_RESERVED2_MASK) >> MC_MC_STATUS_RESERVED2_SHIFT)
#define  MC_MC_STATUS_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_STATUS_RESERVED2_MASK) | (((uint32_t)val) << MC_MC_STATUS_RESERVED2_SHIFT))

#define  MC_MC_STATUS_CH_IDLE_1_MASK 0x10000
#define  MC_MC_STATUS_CH_IDLE_1_SHIFT 16
#define  MC_MC_STATUS_CH_IDLE_1_MASK_SHIFT(reg) (((reg) & MC_MC_STATUS_CH_IDLE_1_MASK) >> MC_MC_STATUS_CH_IDLE_1_SHIFT)
#define  MC_MC_STATUS_CH_IDLE_1_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_STATUS_CH_IDLE_1_MASK) | (((uint32_t)val) << MC_MC_STATUS_CH_IDLE_1_SHIFT))

#define  MC_MC_STATUS_RESERVED3_MASK 0x8000
#define  MC_MC_STATUS_RESERVED3_SHIFT 15
#define  MC_MC_STATUS_RESERVED3_MASK_SHIFT(reg) (((reg) & MC_MC_STATUS_RESERVED3_MASK) >> MC_MC_STATUS_RESERVED3_SHIFT)
#define  MC_MC_STATUS_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_STATUS_RESERVED3_MASK) | (((uint32_t)val) << MC_MC_STATUS_RESERVED3_SHIFT))

#define  MC_MC_STATUS_DPCW_IDLE_0_MASK 0x4000
#define  MC_MC_STATUS_DPCW_IDLE_0_SHIFT 14
#define  MC_MC_STATUS_DPCW_IDLE_0_MASK_SHIFT(reg) (((reg) & MC_MC_STATUS_DPCW_IDLE_0_MASK) >> MC_MC_STATUS_DPCW_IDLE_0_SHIFT)
#define  MC_MC_STATUS_DPCW_IDLE_0_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_STATUS_DPCW_IDLE_0_MASK) | (((uint32_t)val) << MC_MC_STATUS_DPCW_IDLE_0_SHIFT))

#define  MC_MC_STATUS_DPCR_IDLE_0_MASK 0x2000
#define  MC_MC_STATUS_DPCR_IDLE_0_SHIFT 13
#define  MC_MC_STATUS_DPCR_IDLE_0_MASK_SHIFT(reg) (((reg) & MC_MC_STATUS_DPCR_IDLE_0_MASK) >> MC_MC_STATUS_DPCR_IDLE_0_SHIFT)
#define  MC_MC_STATUS_DPCR_IDLE_0_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_STATUS_DPCR_IDLE_0_MASK) | (((uint32_t)val) << MC_MC_STATUS_DPCR_IDLE_0_SHIFT))

#define  MC_MC_STATUS_TC_IDLE_0_MASK 0x1000
#define  MC_MC_STATUS_TC_IDLE_0_SHIFT 12
#define  MC_MC_STATUS_TC_IDLE_0_MASK_SHIFT(reg) (((reg) & MC_MC_STATUS_TC_IDLE_0_MASK) >> MC_MC_STATUS_TC_IDLE_0_SHIFT)
#define  MC_MC_STATUS_TC_IDLE_0_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_STATUS_TC_IDLE_0_MASK) | (((uint32_t)val) << MC_MC_STATUS_TC_IDLE_0_SHIFT))

#define  MC_MC_STATUS_BQ_EMPTY_0_MASK 0x800
#define  MC_MC_STATUS_BQ_EMPTY_0_SHIFT 11
#define  MC_MC_STATUS_BQ_EMPTY_0_MASK_SHIFT(reg) (((reg) & MC_MC_STATUS_BQ_EMPTY_0_MASK) >> MC_MC_STATUS_BQ_EMPTY_0_SHIFT)
#define  MC_MC_STATUS_BQ_EMPTY_0_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_STATUS_BQ_EMPTY_0_MASK) | (((uint32_t)val) << MC_MC_STATUS_BQ_EMPTY_0_SHIFT))

#define  MC_MC_STATUS_SMTQ_IDLE_0_MASK 0x400
#define  MC_MC_STATUS_SMTQ_IDLE_0_SHIFT 10
#define  MC_MC_STATUS_SMTQ_IDLE_0_MASK_SHIFT(reg) (((reg) & MC_MC_STATUS_SMTQ_IDLE_0_MASK) >> MC_MC_STATUS_SMTQ_IDLE_0_SHIFT)
#define  MC_MC_STATUS_SMTQ_IDLE_0_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_STATUS_SMTQ_IDLE_0_MASK) | (((uint32_t)val) << MC_MC_STATUS_SMTQ_IDLE_0_SHIFT))

#define  MC_MC_STATUS_RESERVED4_MASK 0x200
#define  MC_MC_STATUS_RESERVED4_SHIFT 9
#define  MC_MC_STATUS_RESERVED4_MASK_SHIFT(reg) (((reg) & MC_MC_STATUS_RESERVED4_MASK) >> MC_MC_STATUS_RESERVED4_SHIFT)
#define  MC_MC_STATUS_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_STATUS_RESERVED4_MASK) | (((uint32_t)val) << MC_MC_STATUS_RESERVED4_SHIFT))

#define  MC_MC_STATUS_CH_IDLE_0_MASK 0x100
#define  MC_MC_STATUS_CH_IDLE_0_SHIFT 8
#define  MC_MC_STATUS_CH_IDLE_0_MASK_SHIFT(reg) (((reg) & MC_MC_STATUS_CH_IDLE_0_MASK) >> MC_MC_STATUS_CH_IDLE_0_SHIFT)
#define  MC_MC_STATUS_CH_IDLE_0_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_STATUS_CH_IDLE_0_MASK) | (((uint32_t)val) << MC_MC_STATUS_CH_IDLE_0_SHIFT))

#define  MC_MC_STATUS_RESERVED5_MASK 0xf0
#define  MC_MC_STATUS_RESERVED5_SHIFT 4
#define  MC_MC_STATUS_RESERVED5_MASK_SHIFT(reg) (((reg) & MC_MC_STATUS_RESERVED5_MASK) >> MC_MC_STATUS_RESERVED5_SHIFT)
#define  MC_MC_STATUS_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_STATUS_RESERVED5_MASK) | (((uint32_t)val) << MC_MC_STATUS_RESERVED5_SHIFT))

#define  MC_MC_STATUS_WCB_EMPTY_MASK 0x8
#define  MC_MC_STATUS_WCB_EMPTY_SHIFT 3
#define  MC_MC_STATUS_WCB_EMPTY_MASK_SHIFT(reg) (((reg) & MC_MC_STATUS_WCB_EMPTY_MASK) >> MC_MC_STATUS_WCB_EMPTY_SHIFT)
#define  MC_MC_STATUS_WCB_EMPTY_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_STATUS_WCB_EMPTY_MASK) | (((uint32_t)val) << MC_MC_STATUS_WCB_EMPTY_SHIFT))

#define  MC_MC_STATUS_ROB_EMPTY_MASK 0x4
#define  MC_MC_STATUS_ROB_EMPTY_SHIFT 2
#define  MC_MC_STATUS_ROB_EMPTY_MASK_SHIFT(reg) (((reg) & MC_MC_STATUS_ROB_EMPTY_MASK) >> MC_MC_STATUS_ROB_EMPTY_SHIFT)
#define  MC_MC_STATUS_ROB_EMPTY_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_STATUS_ROB_EMPTY_MASK) | (((uint32_t)val) << MC_MC_STATUS_ROB_EMPTY_SHIFT))

#define  MC_MC_STATUS_RRB_EMPTY_MASK 0x2
#define  MC_MC_STATUS_RRB_EMPTY_SHIFT 1
#define  MC_MC_STATUS_RRB_EMPTY_MASK_SHIFT(reg) (((reg) & MC_MC_STATUS_RRB_EMPTY_MASK) >> MC_MC_STATUS_RRB_EMPTY_SHIFT)
#define  MC_MC_STATUS_RRB_EMPTY_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_STATUS_RRB_EMPTY_MASK) | (((uint32_t)val) << MC_MC_STATUS_RRB_EMPTY_SHIFT))

#define  MC_MC_STATUS_MC_IDLE_MASK 0x1
#define  MC_MC_STATUS_MC_IDLE_SHIFT 0
#define  MC_MC_STATUS_MC_IDLE_MASK_SHIFT(reg) (((reg) & MC_MC_STATUS_MC_IDLE_MASK) >> MC_MC_STATUS_MC_IDLE_SHIFT)
#define  MC_MC_STATUS_MC_IDLE_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_STATUS_MC_IDLE_MASK) | (((uint32_t)val) << MC_MC_STATUS_MC_IDLE_SHIFT))

//====================================================================
//Register: DRAM Status Register (DRAM_STATUS)
//====================================================================

#define  MC_DRAM_STATUS_STATE_DPD13_MASK 0x80000000
#define  MC_DRAM_STATUS_STATE_DPD13_SHIFT 31
#define  MC_DRAM_STATUS_STATE_DPD13_MASK_SHIFT(reg) (((reg) & MC_DRAM_STATUS_STATE_DPD13_MASK) >> MC_DRAM_STATUS_STATE_DPD13_SHIFT)
#define  MC_DRAM_STATUS_STATE_DPD13_REPLACE_VAL(reg,val) (((reg) & ~MC_DRAM_STATUS_STATE_DPD13_MASK) | (((uint32_t)val) << MC_DRAM_STATUS_STATE_DPD13_SHIFT))

#define  MC_DRAM_STATUS_STATE_SR13_MASK 0x40000000
#define  MC_DRAM_STATUS_STATE_SR13_SHIFT 30
#define  MC_DRAM_STATUS_STATE_SR13_MASK_SHIFT(reg) (((reg) & MC_DRAM_STATUS_STATE_SR13_MASK) >> MC_DRAM_STATUS_STATE_SR13_SHIFT)
#define  MC_DRAM_STATUS_STATE_SR13_REPLACE_VAL(reg,val) (((reg) & ~MC_DRAM_STATUS_STATE_SR13_MASK) | (((uint32_t)val) << MC_DRAM_STATUS_STATE_SR13_SHIFT))

#define  MC_DRAM_STATUS_STATE_PD13_MASK 0x20000000
#define  MC_DRAM_STATUS_STATE_PD13_SHIFT 29
#define  MC_DRAM_STATUS_STATE_PD13_MASK_SHIFT(reg) (((reg) & MC_DRAM_STATUS_STATE_PD13_MASK) >> MC_DRAM_STATUS_STATE_PD13_SHIFT)
#define  MC_DRAM_STATUS_STATE_PD13_REPLACE_VAL(reg,val) (((reg) & ~MC_DRAM_STATUS_STATE_PD13_MASK) | (((uint32_t)val) << MC_DRAM_STATUS_STATE_PD13_SHIFT))

#define  MC_DRAM_STATUS_INIT_DONE13_MASK 0x10000000
#define  MC_DRAM_STATUS_INIT_DONE13_SHIFT 28
#define  MC_DRAM_STATUS_INIT_DONE13_MASK_SHIFT(reg) (((reg) & MC_DRAM_STATUS_INIT_DONE13_MASK) >> MC_DRAM_STATUS_INIT_DONE13_SHIFT)
#define  MC_DRAM_STATUS_INIT_DONE13_REPLACE_VAL(reg,val) (((reg) & ~MC_DRAM_STATUS_INIT_DONE13_MASK) | (((uint32_t)val) << MC_DRAM_STATUS_INIT_DONE13_SHIFT))

#define  MC_DRAM_STATUS_STATE_DPD12_MASK 0x8000000
#define  MC_DRAM_STATUS_STATE_DPD12_SHIFT 27
#define  MC_DRAM_STATUS_STATE_DPD12_MASK_SHIFT(reg) (((reg) & MC_DRAM_STATUS_STATE_DPD12_MASK) >> MC_DRAM_STATUS_STATE_DPD12_SHIFT)
#define  MC_DRAM_STATUS_STATE_DPD12_REPLACE_VAL(reg,val) (((reg) & ~MC_DRAM_STATUS_STATE_DPD12_MASK) | (((uint32_t)val) << MC_DRAM_STATUS_STATE_DPD12_SHIFT))

#define  MC_DRAM_STATUS_STATE_SR12_MASK 0x4000000
#define  MC_DRAM_STATUS_STATE_SR12_SHIFT 26
#define  MC_DRAM_STATUS_STATE_SR12_MASK_SHIFT(reg) (((reg) & MC_DRAM_STATUS_STATE_SR12_MASK) >> MC_DRAM_STATUS_STATE_SR12_SHIFT)
#define  MC_DRAM_STATUS_STATE_SR12_REPLACE_VAL(reg,val) (((reg) & ~MC_DRAM_STATUS_STATE_SR12_MASK) | (((uint32_t)val) << MC_DRAM_STATUS_STATE_SR12_SHIFT))

#define  MC_DRAM_STATUS_STATE_PD12_MASK 0x2000000
#define  MC_DRAM_STATUS_STATE_PD12_SHIFT 25
#define  MC_DRAM_STATUS_STATE_PD12_MASK_SHIFT(reg) (((reg) & MC_DRAM_STATUS_STATE_PD12_MASK) >> MC_DRAM_STATUS_STATE_PD12_SHIFT)
#define  MC_DRAM_STATUS_STATE_PD12_REPLACE_VAL(reg,val) (((reg) & ~MC_DRAM_STATUS_STATE_PD12_MASK) | (((uint32_t)val) << MC_DRAM_STATUS_STATE_PD12_SHIFT))

#define  MC_DRAM_STATUS_INIT_DONE12_MASK 0x1000000
#define  MC_DRAM_STATUS_INIT_DONE12_SHIFT 24
#define  MC_DRAM_STATUS_INIT_DONE12_MASK_SHIFT(reg) (((reg) & MC_DRAM_STATUS_INIT_DONE12_MASK) >> MC_DRAM_STATUS_INIT_DONE12_SHIFT)
#define  MC_DRAM_STATUS_INIT_DONE12_REPLACE_VAL(reg,val) (((reg) & ~MC_DRAM_STATUS_INIT_DONE12_MASK) | (((uint32_t)val) << MC_DRAM_STATUS_INIT_DONE12_SHIFT))

#define  MC_DRAM_STATUS_STATE_DPD11_MASK 0x800000
#define  MC_DRAM_STATUS_STATE_DPD11_SHIFT 23
#define  MC_DRAM_STATUS_STATE_DPD11_MASK_SHIFT(reg) (((reg) & MC_DRAM_STATUS_STATE_DPD11_MASK) >> MC_DRAM_STATUS_STATE_DPD11_SHIFT)
#define  MC_DRAM_STATUS_STATE_DPD11_REPLACE_VAL(reg,val) (((reg) & ~MC_DRAM_STATUS_STATE_DPD11_MASK) | (((uint32_t)val) << MC_DRAM_STATUS_STATE_DPD11_SHIFT))

#define  MC_DRAM_STATUS_STATE_SR11_MASK 0x400000
#define  MC_DRAM_STATUS_STATE_SR11_SHIFT 22
#define  MC_DRAM_STATUS_STATE_SR11_MASK_SHIFT(reg) (((reg) & MC_DRAM_STATUS_STATE_SR11_MASK) >> MC_DRAM_STATUS_STATE_SR11_SHIFT)
#define  MC_DRAM_STATUS_STATE_SR11_REPLACE_VAL(reg,val) (((reg) & ~MC_DRAM_STATUS_STATE_SR11_MASK) | (((uint32_t)val) << MC_DRAM_STATUS_STATE_SR11_SHIFT))

#define  MC_DRAM_STATUS_STATE_PD11_MASK 0x200000
#define  MC_DRAM_STATUS_STATE_PD11_SHIFT 21
#define  MC_DRAM_STATUS_STATE_PD11_MASK_SHIFT(reg) (((reg) & MC_DRAM_STATUS_STATE_PD11_MASK) >> MC_DRAM_STATUS_STATE_PD11_SHIFT)
#define  MC_DRAM_STATUS_STATE_PD11_REPLACE_VAL(reg,val) (((reg) & ~MC_DRAM_STATUS_STATE_PD11_MASK) | (((uint32_t)val) << MC_DRAM_STATUS_STATE_PD11_SHIFT))

#define  MC_DRAM_STATUS_INIT_DONE11_MASK 0x100000
#define  MC_DRAM_STATUS_INIT_DONE11_SHIFT 20
#define  MC_DRAM_STATUS_INIT_DONE11_MASK_SHIFT(reg) (((reg) & MC_DRAM_STATUS_INIT_DONE11_MASK) >> MC_DRAM_STATUS_INIT_DONE11_SHIFT)
#define  MC_DRAM_STATUS_INIT_DONE11_REPLACE_VAL(reg,val) (((reg) & ~MC_DRAM_STATUS_INIT_DONE11_MASK) | (((uint32_t)val) << MC_DRAM_STATUS_INIT_DONE11_SHIFT))

#define  MC_DRAM_STATUS_STATE_DPD10_MASK 0x80000
#define  MC_DRAM_STATUS_STATE_DPD10_SHIFT 19
#define  MC_DRAM_STATUS_STATE_DPD10_MASK_SHIFT(reg) (((reg) & MC_DRAM_STATUS_STATE_DPD10_MASK) >> MC_DRAM_STATUS_STATE_DPD10_SHIFT)
#define  MC_DRAM_STATUS_STATE_DPD10_REPLACE_VAL(reg,val) (((reg) & ~MC_DRAM_STATUS_STATE_DPD10_MASK) | (((uint32_t)val) << MC_DRAM_STATUS_STATE_DPD10_SHIFT))

#define  MC_DRAM_STATUS_STATE_SR10_MASK 0x40000
#define  MC_DRAM_STATUS_STATE_SR10_SHIFT 18
#define  MC_DRAM_STATUS_STATE_SR10_MASK_SHIFT(reg) (((reg) & MC_DRAM_STATUS_STATE_SR10_MASK) >> MC_DRAM_STATUS_STATE_SR10_SHIFT)
#define  MC_DRAM_STATUS_STATE_SR10_REPLACE_VAL(reg,val) (((reg) & ~MC_DRAM_STATUS_STATE_SR10_MASK) | (((uint32_t)val) << MC_DRAM_STATUS_STATE_SR10_SHIFT))

#define  MC_DRAM_STATUS_STATE_PD10_MASK 0x20000
#define  MC_DRAM_STATUS_STATE_PD10_SHIFT 17
#define  MC_DRAM_STATUS_STATE_PD10_MASK_SHIFT(reg) (((reg) & MC_DRAM_STATUS_STATE_PD10_MASK) >> MC_DRAM_STATUS_STATE_PD10_SHIFT)
#define  MC_DRAM_STATUS_STATE_PD10_REPLACE_VAL(reg,val) (((reg) & ~MC_DRAM_STATUS_STATE_PD10_MASK) | (((uint32_t)val) << MC_DRAM_STATUS_STATE_PD10_SHIFT))

#define  MC_DRAM_STATUS_INIT_DONE10_MASK 0x10000
#define  MC_DRAM_STATUS_INIT_DONE10_SHIFT 16
#define  MC_DRAM_STATUS_INIT_DONE10_MASK_SHIFT(reg) (((reg) & MC_DRAM_STATUS_INIT_DONE10_MASK) >> MC_DRAM_STATUS_INIT_DONE10_SHIFT)
#define  MC_DRAM_STATUS_INIT_DONE10_REPLACE_VAL(reg,val) (((reg) & ~MC_DRAM_STATUS_INIT_DONE10_MASK) | (((uint32_t)val) << MC_DRAM_STATUS_INIT_DONE10_SHIFT))

#define  MC_DRAM_STATUS_STATE_DPD03_MASK 0x8000
#define  MC_DRAM_STATUS_STATE_DPD03_SHIFT 15
#define  MC_DRAM_STATUS_STATE_DPD03_MASK_SHIFT(reg) (((reg) & MC_DRAM_STATUS_STATE_DPD03_MASK) >> MC_DRAM_STATUS_STATE_DPD03_SHIFT)
#define  MC_DRAM_STATUS_STATE_DPD03_REPLACE_VAL(reg,val) (((reg) & ~MC_DRAM_STATUS_STATE_DPD03_MASK) | (((uint32_t)val) << MC_DRAM_STATUS_STATE_DPD03_SHIFT))

#define  MC_DRAM_STATUS_STATE_SR03_MASK 0x4000
#define  MC_DRAM_STATUS_STATE_SR03_SHIFT 14
#define  MC_DRAM_STATUS_STATE_SR03_MASK_SHIFT(reg) (((reg) & MC_DRAM_STATUS_STATE_SR03_MASK) >> MC_DRAM_STATUS_STATE_SR03_SHIFT)
#define  MC_DRAM_STATUS_STATE_SR03_REPLACE_VAL(reg,val) (((reg) & ~MC_DRAM_STATUS_STATE_SR03_MASK) | (((uint32_t)val) << MC_DRAM_STATUS_STATE_SR03_SHIFT))

#define  MC_DRAM_STATUS_STATE_PD03_MASK 0x2000
#define  MC_DRAM_STATUS_STATE_PD03_SHIFT 13
#define  MC_DRAM_STATUS_STATE_PD03_MASK_SHIFT(reg) (((reg) & MC_DRAM_STATUS_STATE_PD03_MASK) >> MC_DRAM_STATUS_STATE_PD03_SHIFT)
#define  MC_DRAM_STATUS_STATE_PD03_REPLACE_VAL(reg,val) (((reg) & ~MC_DRAM_STATUS_STATE_PD03_MASK) | (((uint32_t)val) << MC_DRAM_STATUS_STATE_PD03_SHIFT))

#define  MC_DRAM_STATUS_INIT_DONE03_MASK 0x1000
#define  MC_DRAM_STATUS_INIT_DONE03_SHIFT 12
#define  MC_DRAM_STATUS_INIT_DONE03_MASK_SHIFT(reg) (((reg) & MC_DRAM_STATUS_INIT_DONE03_MASK) >> MC_DRAM_STATUS_INIT_DONE03_SHIFT)
#define  MC_DRAM_STATUS_INIT_DONE03_REPLACE_VAL(reg,val) (((reg) & ~MC_DRAM_STATUS_INIT_DONE03_MASK) | (((uint32_t)val) << MC_DRAM_STATUS_INIT_DONE03_SHIFT))

#define  MC_DRAM_STATUS_STATE_DPD02_MASK 0x800
#define  MC_DRAM_STATUS_STATE_DPD02_SHIFT 11
#define  MC_DRAM_STATUS_STATE_DPD02_MASK_SHIFT(reg) (((reg) & MC_DRAM_STATUS_STATE_DPD02_MASK) >> MC_DRAM_STATUS_STATE_DPD02_SHIFT)
#define  MC_DRAM_STATUS_STATE_DPD02_REPLACE_VAL(reg,val) (((reg) & ~MC_DRAM_STATUS_STATE_DPD02_MASK) | (((uint32_t)val) << MC_DRAM_STATUS_STATE_DPD02_SHIFT))

#define  MC_DRAM_STATUS_STATE_SR02_MASK 0x400
#define  MC_DRAM_STATUS_STATE_SR02_SHIFT 10
#define  MC_DRAM_STATUS_STATE_SR02_MASK_SHIFT(reg) (((reg) & MC_DRAM_STATUS_STATE_SR02_MASK) >> MC_DRAM_STATUS_STATE_SR02_SHIFT)
#define  MC_DRAM_STATUS_STATE_SR02_REPLACE_VAL(reg,val) (((reg) & ~MC_DRAM_STATUS_STATE_SR02_MASK) | (((uint32_t)val) << MC_DRAM_STATUS_STATE_SR02_SHIFT))

#define  MC_DRAM_STATUS_STATE_PD02_MASK 0x200
#define  MC_DRAM_STATUS_STATE_PD02_SHIFT 9
#define  MC_DRAM_STATUS_STATE_PD02_MASK_SHIFT(reg) (((reg) & MC_DRAM_STATUS_STATE_PD02_MASK) >> MC_DRAM_STATUS_STATE_PD02_SHIFT)
#define  MC_DRAM_STATUS_STATE_PD02_REPLACE_VAL(reg,val) (((reg) & ~MC_DRAM_STATUS_STATE_PD02_MASK) | (((uint32_t)val) << MC_DRAM_STATUS_STATE_PD02_SHIFT))

#define  MC_DRAM_STATUS_INIT_DONE02_MASK 0x100
#define  MC_DRAM_STATUS_INIT_DONE02_SHIFT 8
#define  MC_DRAM_STATUS_INIT_DONE02_MASK_SHIFT(reg) (((reg) & MC_DRAM_STATUS_INIT_DONE02_MASK) >> MC_DRAM_STATUS_INIT_DONE02_SHIFT)
#define  MC_DRAM_STATUS_INIT_DONE02_REPLACE_VAL(reg,val) (((reg) & ~MC_DRAM_STATUS_INIT_DONE02_MASK) | (((uint32_t)val) << MC_DRAM_STATUS_INIT_DONE02_SHIFT))

#define  MC_DRAM_STATUS_STATE_DPD01_MASK 0x80
#define  MC_DRAM_STATUS_STATE_DPD01_SHIFT 7
#define  MC_DRAM_STATUS_STATE_DPD01_MASK_SHIFT(reg) (((reg) & MC_DRAM_STATUS_STATE_DPD01_MASK) >> MC_DRAM_STATUS_STATE_DPD01_SHIFT)
#define  MC_DRAM_STATUS_STATE_DPD01_REPLACE_VAL(reg,val) (((reg) & ~MC_DRAM_STATUS_STATE_DPD01_MASK) | (((uint32_t)val) << MC_DRAM_STATUS_STATE_DPD01_SHIFT))

#define  MC_DRAM_STATUS_STATE_SR01_MASK 0x40
#define  MC_DRAM_STATUS_STATE_SR01_SHIFT 6
#define  MC_DRAM_STATUS_STATE_SR01_MASK_SHIFT(reg) (((reg) & MC_DRAM_STATUS_STATE_SR01_MASK) >> MC_DRAM_STATUS_STATE_SR01_SHIFT)
#define  MC_DRAM_STATUS_STATE_SR01_REPLACE_VAL(reg,val) (((reg) & ~MC_DRAM_STATUS_STATE_SR01_MASK) | (((uint32_t)val) << MC_DRAM_STATUS_STATE_SR01_SHIFT))

#define  MC_DRAM_STATUS_STATE_PD01_MASK 0x20
#define  MC_DRAM_STATUS_STATE_PD01_SHIFT 5
#define  MC_DRAM_STATUS_STATE_PD01_MASK_SHIFT(reg) (((reg) & MC_DRAM_STATUS_STATE_PD01_MASK) >> MC_DRAM_STATUS_STATE_PD01_SHIFT)
#define  MC_DRAM_STATUS_STATE_PD01_REPLACE_VAL(reg,val) (((reg) & ~MC_DRAM_STATUS_STATE_PD01_MASK) | (((uint32_t)val) << MC_DRAM_STATUS_STATE_PD01_SHIFT))

#define  MC_DRAM_STATUS_INIT_DONE01_MASK 0x10
#define  MC_DRAM_STATUS_INIT_DONE01_SHIFT 4
#define  MC_DRAM_STATUS_INIT_DONE01_MASK_SHIFT(reg) (((reg) & MC_DRAM_STATUS_INIT_DONE01_MASK) >> MC_DRAM_STATUS_INIT_DONE01_SHIFT)
#define  MC_DRAM_STATUS_INIT_DONE01_REPLACE_VAL(reg,val) (((reg) & ~MC_DRAM_STATUS_INIT_DONE01_MASK) | (((uint32_t)val) << MC_DRAM_STATUS_INIT_DONE01_SHIFT))

#define  MC_DRAM_STATUS_STATE_DPD00_MASK 0x8
#define  MC_DRAM_STATUS_STATE_DPD00_SHIFT 3
#define  MC_DRAM_STATUS_STATE_DPD00_MASK_SHIFT(reg) (((reg) & MC_DRAM_STATUS_STATE_DPD00_MASK) >> MC_DRAM_STATUS_STATE_DPD00_SHIFT)
#define  MC_DRAM_STATUS_STATE_DPD00_REPLACE_VAL(reg,val) (((reg) & ~MC_DRAM_STATUS_STATE_DPD00_MASK) | (((uint32_t)val) << MC_DRAM_STATUS_STATE_DPD00_SHIFT))

#define  MC_DRAM_STATUS_STATE_SR00_MASK 0x4
#define  MC_DRAM_STATUS_STATE_SR00_SHIFT 2
#define  MC_DRAM_STATUS_STATE_SR00_MASK_SHIFT(reg) (((reg) & MC_DRAM_STATUS_STATE_SR00_MASK) >> MC_DRAM_STATUS_STATE_SR00_SHIFT)
#define  MC_DRAM_STATUS_STATE_SR00_REPLACE_VAL(reg,val) (((reg) & ~MC_DRAM_STATUS_STATE_SR00_MASK) | (((uint32_t)val) << MC_DRAM_STATUS_STATE_SR00_SHIFT))

#define  MC_DRAM_STATUS_STATE_PD00_MASK 0x2
#define  MC_DRAM_STATUS_STATE_PD00_SHIFT 1
#define  MC_DRAM_STATUS_STATE_PD00_MASK_SHIFT(reg) (((reg) & MC_DRAM_STATUS_STATE_PD00_MASK) >> MC_DRAM_STATUS_STATE_PD00_SHIFT)
#define  MC_DRAM_STATUS_STATE_PD00_REPLACE_VAL(reg,val) (((reg) & ~MC_DRAM_STATUS_STATE_PD00_MASK) | (((uint32_t)val) << MC_DRAM_STATUS_STATE_PD00_SHIFT))

#define  MC_DRAM_STATUS_INIT_DONE00_MASK 0x1
#define  MC_DRAM_STATUS_INIT_DONE00_SHIFT 0
#define  MC_DRAM_STATUS_INIT_DONE00_MASK_SHIFT(reg) (((reg) & MC_DRAM_STATUS_INIT_DONE00_MASK) >> MC_DRAM_STATUS_INIT_DONE00_SHIFT)
#define  MC_DRAM_STATUS_INIT_DONE00_REPLACE_VAL(reg,val) (((reg) & ~MC_DRAM_STATUS_INIT_DONE00_MASK) | (((uint32_t)val) << MC_DRAM_STATUS_INIT_DONE00_SHIFT))

//====================================================================
//Register: DRAM Mode Register (DRAM_MODE)
//====================================================================

#define  MC_DRAM_MODE_RESERVED1_MASK 0xfffffffc
#define  MC_DRAM_MODE_RESERVED1_SHIFT 2
#define  MC_DRAM_MODE_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_DRAM_MODE_RESERVED1_MASK) >> MC_DRAM_MODE_RESERVED1_SHIFT)
#define  MC_DRAM_MODE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_DRAM_MODE_RESERVED1_MASK) | (((uint32_t)val) << MC_DRAM_MODE_RESERVED1_SHIFT))

#define  MC_DRAM_MODE_SDRAM_CAL_MODE_CH1_MASK 0x2
#define  MC_DRAM_MODE_SDRAM_CAL_MODE_CH1_SHIFT 1
#define  MC_DRAM_MODE_SDRAM_CAL_MODE_CH1_MASK_SHIFT(reg) (((reg) & MC_DRAM_MODE_SDRAM_CAL_MODE_CH1_MASK) >> MC_DRAM_MODE_SDRAM_CAL_MODE_CH1_SHIFT)
#define  MC_DRAM_MODE_SDRAM_CAL_MODE_CH1_REPLACE_VAL(reg,val) (((reg) & ~MC_DRAM_MODE_SDRAM_CAL_MODE_CH1_MASK) | (((uint32_t)val) << MC_DRAM_MODE_SDRAM_CAL_MODE_CH1_SHIFT))

#define  MC_DRAM_MODE_SDRAM_CAL_MODE_CH0_MASK 0x1
#define  MC_DRAM_MODE_SDRAM_CAL_MODE_CH0_SHIFT 0
#define  MC_DRAM_MODE_SDRAM_CAL_MODE_CH0_MASK_SHIFT(reg) (((reg) & MC_DRAM_MODE_SDRAM_CAL_MODE_CH0_MASK) >> MC_DRAM_MODE_SDRAM_CAL_MODE_CH0_SHIFT)
#define  MC_DRAM_MODE_SDRAM_CAL_MODE_CH0_REPLACE_VAL(reg,val) (((reg) & ~MC_DRAM_MODE_SDRAM_CAL_MODE_CH0_MASK) | (((uint32_t)val) << MC_DRAM_MODE_SDRAM_CAL_MODE_CH0_SHIFT))

//====================================================================
//Register: MC Write Path Status (MC_WP_STAT)
//====================================================================

#define  MC_MC_WP_STAT_RESERVED1_MASK 0xe0000000
#define  MC_MC_WP_STAT_RESERVED1_SHIFT 29
#define  MC_MC_WP_STAT_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_MC_WP_STAT_RESERVED1_MASK) >> MC_MC_WP_STAT_RESERVED1_SHIFT)
#define  MC_MC_WP_STAT_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_WP_STAT_RESERVED1_MASK) | (((uint32_t)val) << MC_MC_WP_STAT_RESERVED1_SHIFT))

#define  MC_MC_WP_STAT_WCB_DRAINING_MASK 0x10000000
#define  MC_MC_WP_STAT_WCB_DRAINING_SHIFT 28
#define  MC_MC_WP_STAT_WCB_DRAINING_MASK_SHIFT(reg) (((reg) & MC_MC_WP_STAT_WCB_DRAINING_MASK) >> MC_MC_WP_STAT_WCB_DRAINING_SHIFT)
#define  MC_MC_WP_STAT_WCB_DRAINING_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_WP_STAT_WCB_DRAINING_MASK) | (((uint32_t)val) << MC_MC_WP_STAT_WCB_DRAINING_SHIFT))

#define  MC_MC_WP_STAT_WDB_LF_FIFO_EMPTY_MASK 0x8000000
#define  MC_MC_WP_STAT_WDB_LF_FIFO_EMPTY_SHIFT 27
#define  MC_MC_WP_STAT_WDB_LF_FIFO_EMPTY_MASK_SHIFT(reg) (((reg) & MC_MC_WP_STAT_WDB_LF_FIFO_EMPTY_MASK) >> MC_MC_WP_STAT_WDB_LF_FIFO_EMPTY_SHIFT)
#define  MC_MC_WP_STAT_WDB_LF_FIFO_EMPTY_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_WP_STAT_WDB_LF_FIFO_EMPTY_MASK) | (((uint32_t)val) << MC_MC_WP_STAT_WDB_LF_FIFO_EMPTY_SHIFT))

#define  MC_MC_WP_STAT_WDB_LF_PORT_MASK 0x7000000
#define  MC_MC_WP_STAT_WDB_LF_PORT_SHIFT 24
#define  MC_MC_WP_STAT_WDB_LF_PORT_MASK_SHIFT(reg) (((reg) & MC_MC_WP_STAT_WDB_LF_PORT_MASK) >> MC_MC_WP_STAT_WDB_LF_PORT_SHIFT)
#define  MC_MC_WP_STAT_WDB_LF_PORT_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_WP_STAT_WDB_LF_PORT_MASK) | (((uint32_t)val) << MC_MC_WP_STAT_WDB_LF_PORT_SHIFT))

#define  MC_MC_WP_STAT_AXIIF_BR_FIFO_EMPTY_P7_MASK 0x800000
#define  MC_MC_WP_STAT_AXIIF_BR_FIFO_EMPTY_P7_SHIFT 23
#define  MC_MC_WP_STAT_AXIIF_BR_FIFO_EMPTY_P7_MASK_SHIFT(reg) (((reg) & MC_MC_WP_STAT_AXIIF_BR_FIFO_EMPTY_P7_MASK) >> MC_MC_WP_STAT_AXIIF_BR_FIFO_EMPTY_P7_SHIFT)
#define  MC_MC_WP_STAT_AXIIF_BR_FIFO_EMPTY_P7_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_WP_STAT_AXIIF_BR_FIFO_EMPTY_P7_MASK) | (((uint32_t)val) << MC_MC_WP_STAT_AXIIF_BR_FIFO_EMPTY_P7_SHIFT))

#define  MC_MC_WP_STAT_AXIIF_BR_FIFO_EMPTY_P6_MASK 0x400000
#define  MC_MC_WP_STAT_AXIIF_BR_FIFO_EMPTY_P6_SHIFT 22
#define  MC_MC_WP_STAT_AXIIF_BR_FIFO_EMPTY_P6_MASK_SHIFT(reg) (((reg) & MC_MC_WP_STAT_AXIIF_BR_FIFO_EMPTY_P6_MASK) >> MC_MC_WP_STAT_AXIIF_BR_FIFO_EMPTY_P6_SHIFT)
#define  MC_MC_WP_STAT_AXIIF_BR_FIFO_EMPTY_P6_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_WP_STAT_AXIIF_BR_FIFO_EMPTY_P6_MASK) | (((uint32_t)val) << MC_MC_WP_STAT_AXIIF_BR_FIFO_EMPTY_P6_SHIFT))

#define  MC_MC_WP_STAT_AXIIF_BR_FIFO_EMPTY_P5_MASK 0x200000
#define  MC_MC_WP_STAT_AXIIF_BR_FIFO_EMPTY_P5_SHIFT 21
#define  MC_MC_WP_STAT_AXIIF_BR_FIFO_EMPTY_P5_MASK_SHIFT(reg) (((reg) & MC_MC_WP_STAT_AXIIF_BR_FIFO_EMPTY_P5_MASK) >> MC_MC_WP_STAT_AXIIF_BR_FIFO_EMPTY_P5_SHIFT)
#define  MC_MC_WP_STAT_AXIIF_BR_FIFO_EMPTY_P5_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_WP_STAT_AXIIF_BR_FIFO_EMPTY_P5_MASK) | (((uint32_t)val) << MC_MC_WP_STAT_AXIIF_BR_FIFO_EMPTY_P5_SHIFT))

#define  MC_MC_WP_STAT_AXIIF_BR_FIFO_EMPTY_P4_MASK 0x100000
#define  MC_MC_WP_STAT_AXIIF_BR_FIFO_EMPTY_P4_SHIFT 20
#define  MC_MC_WP_STAT_AXIIF_BR_FIFO_EMPTY_P4_MASK_SHIFT(reg) (((reg) & MC_MC_WP_STAT_AXIIF_BR_FIFO_EMPTY_P4_MASK) >> MC_MC_WP_STAT_AXIIF_BR_FIFO_EMPTY_P4_SHIFT)
#define  MC_MC_WP_STAT_AXIIF_BR_FIFO_EMPTY_P4_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_WP_STAT_AXIIF_BR_FIFO_EMPTY_P4_MASK) | (((uint32_t)val) << MC_MC_WP_STAT_AXIIF_BR_FIFO_EMPTY_P4_SHIFT))

#define  MC_MC_WP_STAT_AXIIF_BR_FIFO_EMPTY_P3_MASK 0x80000
#define  MC_MC_WP_STAT_AXIIF_BR_FIFO_EMPTY_P3_SHIFT 19
#define  MC_MC_WP_STAT_AXIIF_BR_FIFO_EMPTY_P3_MASK_SHIFT(reg) (((reg) & MC_MC_WP_STAT_AXIIF_BR_FIFO_EMPTY_P3_MASK) >> MC_MC_WP_STAT_AXIIF_BR_FIFO_EMPTY_P3_SHIFT)
#define  MC_MC_WP_STAT_AXIIF_BR_FIFO_EMPTY_P3_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_WP_STAT_AXIIF_BR_FIFO_EMPTY_P3_MASK) | (((uint32_t)val) << MC_MC_WP_STAT_AXIIF_BR_FIFO_EMPTY_P3_SHIFT))

#define  MC_MC_WP_STAT_AXIIF_BR_FIFO_EMPTY_P2_MASK 0x40000
#define  MC_MC_WP_STAT_AXIIF_BR_FIFO_EMPTY_P2_SHIFT 18
#define  MC_MC_WP_STAT_AXIIF_BR_FIFO_EMPTY_P2_MASK_SHIFT(reg) (((reg) & MC_MC_WP_STAT_AXIIF_BR_FIFO_EMPTY_P2_MASK) >> MC_MC_WP_STAT_AXIIF_BR_FIFO_EMPTY_P2_SHIFT)
#define  MC_MC_WP_STAT_AXIIF_BR_FIFO_EMPTY_P2_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_WP_STAT_AXIIF_BR_FIFO_EMPTY_P2_MASK) | (((uint32_t)val) << MC_MC_WP_STAT_AXIIF_BR_FIFO_EMPTY_P2_SHIFT))

#define  MC_MC_WP_STAT_AXIIF_BR_FIFO_EMPTY_P1_MASK 0x20000
#define  MC_MC_WP_STAT_AXIIF_BR_FIFO_EMPTY_P1_SHIFT 17
#define  MC_MC_WP_STAT_AXIIF_BR_FIFO_EMPTY_P1_MASK_SHIFT(reg) (((reg) & MC_MC_WP_STAT_AXIIF_BR_FIFO_EMPTY_P1_MASK) >> MC_MC_WP_STAT_AXIIF_BR_FIFO_EMPTY_P1_SHIFT)
#define  MC_MC_WP_STAT_AXIIF_BR_FIFO_EMPTY_P1_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_WP_STAT_AXIIF_BR_FIFO_EMPTY_P1_MASK) | (((uint32_t)val) << MC_MC_WP_STAT_AXIIF_BR_FIFO_EMPTY_P1_SHIFT))

#define  MC_MC_WP_STAT_AXIIF_BR_FIFO_EMPTY_P0_MASK 0x10000
#define  MC_MC_WP_STAT_AXIIF_BR_FIFO_EMPTY_P0_SHIFT 16
#define  MC_MC_WP_STAT_AXIIF_BR_FIFO_EMPTY_P0_MASK_SHIFT(reg) (((reg) & MC_MC_WP_STAT_AXIIF_BR_FIFO_EMPTY_P0_MASK) >> MC_MC_WP_STAT_AXIIF_BR_FIFO_EMPTY_P0_SHIFT)
#define  MC_MC_WP_STAT_AXIIF_BR_FIFO_EMPTY_P0_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_WP_STAT_AXIIF_BR_FIFO_EMPTY_P0_MASK) | (((uint32_t)val) << MC_MC_WP_STAT_AXIIF_BR_FIFO_EMPTY_P0_SHIFT))

#define  MC_MC_WP_STAT_AXIIF_WA_FIFO_EMPTY_P7_MASK 0x8000
#define  MC_MC_WP_STAT_AXIIF_WA_FIFO_EMPTY_P7_SHIFT 15
#define  MC_MC_WP_STAT_AXIIF_WA_FIFO_EMPTY_P7_MASK_SHIFT(reg) (((reg) & MC_MC_WP_STAT_AXIIF_WA_FIFO_EMPTY_P7_MASK) >> MC_MC_WP_STAT_AXIIF_WA_FIFO_EMPTY_P7_SHIFT)
#define  MC_MC_WP_STAT_AXIIF_WA_FIFO_EMPTY_P7_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_WP_STAT_AXIIF_WA_FIFO_EMPTY_P7_MASK) | (((uint32_t)val) << MC_MC_WP_STAT_AXIIF_WA_FIFO_EMPTY_P7_SHIFT))

#define  MC_MC_WP_STAT_AXIIF_WA_FIFO_EMPTY_P6_MASK 0x4000
#define  MC_MC_WP_STAT_AXIIF_WA_FIFO_EMPTY_P6_SHIFT 14
#define  MC_MC_WP_STAT_AXIIF_WA_FIFO_EMPTY_P6_MASK_SHIFT(reg) (((reg) & MC_MC_WP_STAT_AXIIF_WA_FIFO_EMPTY_P6_MASK) >> MC_MC_WP_STAT_AXIIF_WA_FIFO_EMPTY_P6_SHIFT)
#define  MC_MC_WP_STAT_AXIIF_WA_FIFO_EMPTY_P6_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_WP_STAT_AXIIF_WA_FIFO_EMPTY_P6_MASK) | (((uint32_t)val) << MC_MC_WP_STAT_AXIIF_WA_FIFO_EMPTY_P6_SHIFT))

#define  MC_MC_WP_STAT_AXIIF_WA_FIFO_EMPTY_P5_MASK 0x2000
#define  MC_MC_WP_STAT_AXIIF_WA_FIFO_EMPTY_P5_SHIFT 13
#define  MC_MC_WP_STAT_AXIIF_WA_FIFO_EMPTY_P5_MASK_SHIFT(reg) (((reg) & MC_MC_WP_STAT_AXIIF_WA_FIFO_EMPTY_P5_MASK) >> MC_MC_WP_STAT_AXIIF_WA_FIFO_EMPTY_P5_SHIFT)
#define  MC_MC_WP_STAT_AXIIF_WA_FIFO_EMPTY_P5_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_WP_STAT_AXIIF_WA_FIFO_EMPTY_P5_MASK) | (((uint32_t)val) << MC_MC_WP_STAT_AXIIF_WA_FIFO_EMPTY_P5_SHIFT))

#define  MC_MC_WP_STAT_AXIIF_WA_FIFO_EMPTY_P4_MASK 0x1000
#define  MC_MC_WP_STAT_AXIIF_WA_FIFO_EMPTY_P4_SHIFT 12
#define  MC_MC_WP_STAT_AXIIF_WA_FIFO_EMPTY_P4_MASK_SHIFT(reg) (((reg) & MC_MC_WP_STAT_AXIIF_WA_FIFO_EMPTY_P4_MASK) >> MC_MC_WP_STAT_AXIIF_WA_FIFO_EMPTY_P4_SHIFT)
#define  MC_MC_WP_STAT_AXIIF_WA_FIFO_EMPTY_P4_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_WP_STAT_AXIIF_WA_FIFO_EMPTY_P4_MASK) | (((uint32_t)val) << MC_MC_WP_STAT_AXIIF_WA_FIFO_EMPTY_P4_SHIFT))

#define  MC_MC_WP_STAT_AXIIF_WA_FIFO_EMPTY_P3_MASK 0x800
#define  MC_MC_WP_STAT_AXIIF_WA_FIFO_EMPTY_P3_SHIFT 11
#define  MC_MC_WP_STAT_AXIIF_WA_FIFO_EMPTY_P3_MASK_SHIFT(reg) (((reg) & MC_MC_WP_STAT_AXIIF_WA_FIFO_EMPTY_P3_MASK) >> MC_MC_WP_STAT_AXIIF_WA_FIFO_EMPTY_P3_SHIFT)
#define  MC_MC_WP_STAT_AXIIF_WA_FIFO_EMPTY_P3_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_WP_STAT_AXIIF_WA_FIFO_EMPTY_P3_MASK) | (((uint32_t)val) << MC_MC_WP_STAT_AXIIF_WA_FIFO_EMPTY_P3_SHIFT))

#define  MC_MC_WP_STAT_AXIIF_WA_FIFO_EMPTY_P2_MASK 0x400
#define  MC_MC_WP_STAT_AXIIF_WA_FIFO_EMPTY_P2_SHIFT 10
#define  MC_MC_WP_STAT_AXIIF_WA_FIFO_EMPTY_P2_MASK_SHIFT(reg) (((reg) & MC_MC_WP_STAT_AXIIF_WA_FIFO_EMPTY_P2_MASK) >> MC_MC_WP_STAT_AXIIF_WA_FIFO_EMPTY_P2_SHIFT)
#define  MC_MC_WP_STAT_AXIIF_WA_FIFO_EMPTY_P2_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_WP_STAT_AXIIF_WA_FIFO_EMPTY_P2_MASK) | (((uint32_t)val) << MC_MC_WP_STAT_AXIIF_WA_FIFO_EMPTY_P2_SHIFT))

#define  MC_MC_WP_STAT_AXIIF_WA_FIFO_EMPTY_P1_MASK 0x200
#define  MC_MC_WP_STAT_AXIIF_WA_FIFO_EMPTY_P1_SHIFT 9
#define  MC_MC_WP_STAT_AXIIF_WA_FIFO_EMPTY_P1_MASK_SHIFT(reg) (((reg) & MC_MC_WP_STAT_AXIIF_WA_FIFO_EMPTY_P1_MASK) >> MC_MC_WP_STAT_AXIIF_WA_FIFO_EMPTY_P1_SHIFT)
#define  MC_MC_WP_STAT_AXIIF_WA_FIFO_EMPTY_P1_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_WP_STAT_AXIIF_WA_FIFO_EMPTY_P1_MASK) | (((uint32_t)val) << MC_MC_WP_STAT_AXIIF_WA_FIFO_EMPTY_P1_SHIFT))

#define  MC_MC_WP_STAT_AXIIF_WA_FIFO_EMPTY_P0_MASK 0x100
#define  MC_MC_WP_STAT_AXIIF_WA_FIFO_EMPTY_P0_SHIFT 8
#define  MC_MC_WP_STAT_AXIIF_WA_FIFO_EMPTY_P0_MASK_SHIFT(reg) (((reg) & MC_MC_WP_STAT_AXIIF_WA_FIFO_EMPTY_P0_MASK) >> MC_MC_WP_STAT_AXIIF_WA_FIFO_EMPTY_P0_SHIFT)
#define  MC_MC_WP_STAT_AXIIF_WA_FIFO_EMPTY_P0_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_WP_STAT_AXIIF_WA_FIFO_EMPTY_P0_MASK) | (((uint32_t)val) << MC_MC_WP_STAT_AXIIF_WA_FIFO_EMPTY_P0_SHIFT))

#define  MC_MC_WP_STAT_AXIIF_WD_FIFO_EMPTY_P7_MASK 0x80
#define  MC_MC_WP_STAT_AXIIF_WD_FIFO_EMPTY_P7_SHIFT 7
#define  MC_MC_WP_STAT_AXIIF_WD_FIFO_EMPTY_P7_MASK_SHIFT(reg) (((reg) & MC_MC_WP_STAT_AXIIF_WD_FIFO_EMPTY_P7_MASK) >> MC_MC_WP_STAT_AXIIF_WD_FIFO_EMPTY_P7_SHIFT)
#define  MC_MC_WP_STAT_AXIIF_WD_FIFO_EMPTY_P7_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_WP_STAT_AXIIF_WD_FIFO_EMPTY_P7_MASK) | (((uint32_t)val) << MC_MC_WP_STAT_AXIIF_WD_FIFO_EMPTY_P7_SHIFT))

#define  MC_MC_WP_STAT_AXIIF_WD_FIFO_EMPTY_P6_MASK 0x40
#define  MC_MC_WP_STAT_AXIIF_WD_FIFO_EMPTY_P6_SHIFT 6
#define  MC_MC_WP_STAT_AXIIF_WD_FIFO_EMPTY_P6_MASK_SHIFT(reg) (((reg) & MC_MC_WP_STAT_AXIIF_WD_FIFO_EMPTY_P6_MASK) >> MC_MC_WP_STAT_AXIIF_WD_FIFO_EMPTY_P6_SHIFT)
#define  MC_MC_WP_STAT_AXIIF_WD_FIFO_EMPTY_P6_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_WP_STAT_AXIIF_WD_FIFO_EMPTY_P6_MASK) | (((uint32_t)val) << MC_MC_WP_STAT_AXIIF_WD_FIFO_EMPTY_P6_SHIFT))

#define  MC_MC_WP_STAT_AXIIF_WD_FIFO_EMPTY_P5_MASK 0x20
#define  MC_MC_WP_STAT_AXIIF_WD_FIFO_EMPTY_P5_SHIFT 5
#define  MC_MC_WP_STAT_AXIIF_WD_FIFO_EMPTY_P5_MASK_SHIFT(reg) (((reg) & MC_MC_WP_STAT_AXIIF_WD_FIFO_EMPTY_P5_MASK) >> MC_MC_WP_STAT_AXIIF_WD_FIFO_EMPTY_P5_SHIFT)
#define  MC_MC_WP_STAT_AXIIF_WD_FIFO_EMPTY_P5_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_WP_STAT_AXIIF_WD_FIFO_EMPTY_P5_MASK) | (((uint32_t)val) << MC_MC_WP_STAT_AXIIF_WD_FIFO_EMPTY_P5_SHIFT))

#define  MC_MC_WP_STAT_AXIIF_WD_FIFO_EMPTY_P4_MASK 0x10
#define  MC_MC_WP_STAT_AXIIF_WD_FIFO_EMPTY_P4_SHIFT 4
#define  MC_MC_WP_STAT_AXIIF_WD_FIFO_EMPTY_P4_MASK_SHIFT(reg) (((reg) & MC_MC_WP_STAT_AXIIF_WD_FIFO_EMPTY_P4_MASK) >> MC_MC_WP_STAT_AXIIF_WD_FIFO_EMPTY_P4_SHIFT)
#define  MC_MC_WP_STAT_AXIIF_WD_FIFO_EMPTY_P4_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_WP_STAT_AXIIF_WD_FIFO_EMPTY_P4_MASK) | (((uint32_t)val) << MC_MC_WP_STAT_AXIIF_WD_FIFO_EMPTY_P4_SHIFT))

#define  MC_MC_WP_STAT_AXIIF_WD_FIFO_EMPTY_P3_MASK 0x8
#define  MC_MC_WP_STAT_AXIIF_WD_FIFO_EMPTY_P3_SHIFT 3
#define  MC_MC_WP_STAT_AXIIF_WD_FIFO_EMPTY_P3_MASK_SHIFT(reg) (((reg) & MC_MC_WP_STAT_AXIIF_WD_FIFO_EMPTY_P3_MASK) >> MC_MC_WP_STAT_AXIIF_WD_FIFO_EMPTY_P3_SHIFT)
#define  MC_MC_WP_STAT_AXIIF_WD_FIFO_EMPTY_P3_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_WP_STAT_AXIIF_WD_FIFO_EMPTY_P3_MASK) | (((uint32_t)val) << MC_MC_WP_STAT_AXIIF_WD_FIFO_EMPTY_P3_SHIFT))

#define  MC_MC_WP_STAT_AXIIF_WD_FIFO_EMPTY_P2_MASK 0x4
#define  MC_MC_WP_STAT_AXIIF_WD_FIFO_EMPTY_P2_SHIFT 2
#define  MC_MC_WP_STAT_AXIIF_WD_FIFO_EMPTY_P2_MASK_SHIFT(reg) (((reg) & MC_MC_WP_STAT_AXIIF_WD_FIFO_EMPTY_P2_MASK) >> MC_MC_WP_STAT_AXIIF_WD_FIFO_EMPTY_P2_SHIFT)
#define  MC_MC_WP_STAT_AXIIF_WD_FIFO_EMPTY_P2_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_WP_STAT_AXIIF_WD_FIFO_EMPTY_P2_MASK) | (((uint32_t)val) << MC_MC_WP_STAT_AXIIF_WD_FIFO_EMPTY_P2_SHIFT))

#define  MC_MC_WP_STAT_AXIIF_WD_FIFO_EMPTY_P1_MASK 0x2
#define  MC_MC_WP_STAT_AXIIF_WD_FIFO_EMPTY_P1_SHIFT 1
#define  MC_MC_WP_STAT_AXIIF_WD_FIFO_EMPTY_P1_MASK_SHIFT(reg) (((reg) & MC_MC_WP_STAT_AXIIF_WD_FIFO_EMPTY_P1_MASK) >> MC_MC_WP_STAT_AXIIF_WD_FIFO_EMPTY_P1_SHIFT)
#define  MC_MC_WP_STAT_AXIIF_WD_FIFO_EMPTY_P1_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_WP_STAT_AXIIF_WD_FIFO_EMPTY_P1_MASK) | (((uint32_t)val) << MC_MC_WP_STAT_AXIIF_WD_FIFO_EMPTY_P1_SHIFT))

#define  MC_MC_WP_STAT_AXIIF_WD_FIFO_EMPTY_P0_MASK 0x1
#define  MC_MC_WP_STAT_AXIIF_WD_FIFO_EMPTY_P0_SHIFT 0
#define  MC_MC_WP_STAT_AXIIF_WD_FIFO_EMPTY_P0_MASK_SHIFT(reg) (((reg) & MC_MC_WP_STAT_AXIIF_WD_FIFO_EMPTY_P0_MASK) >> MC_MC_WP_STAT_AXIIF_WD_FIFO_EMPTY_P0_SHIFT)
#define  MC_MC_WP_STAT_AXIIF_WD_FIFO_EMPTY_P0_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_WP_STAT_AXIIF_WD_FIFO_EMPTY_P0_MASK) | (((uint32_t)val) << MC_MC_WP_STAT_AXIIF_WD_FIFO_EMPTY_P0_SHIFT))

//====================================================================
//Register: MC Read Path Status (MC_RP_STAT)
//====================================================================

#define  MC_MC_RP_STAT_ROB_NOT_FULL_P7_MASK 0x80000000
#define  MC_MC_RP_STAT_ROB_NOT_FULL_P7_SHIFT 31
#define  MC_MC_RP_STAT_ROB_NOT_FULL_P7_MASK_SHIFT(reg) (((reg) & MC_MC_RP_STAT_ROB_NOT_FULL_P7_MASK) >> MC_MC_RP_STAT_ROB_NOT_FULL_P7_SHIFT)
#define  MC_MC_RP_STAT_ROB_NOT_FULL_P7_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_RP_STAT_ROB_NOT_FULL_P7_MASK) | (((uint32_t)val) << MC_MC_RP_STAT_ROB_NOT_FULL_P7_SHIFT))

#define  MC_MC_RP_STAT_ROB_NOT_FULL_P6_MASK 0x40000000
#define  MC_MC_RP_STAT_ROB_NOT_FULL_P6_SHIFT 30
#define  MC_MC_RP_STAT_ROB_NOT_FULL_P6_MASK_SHIFT(reg) (((reg) & MC_MC_RP_STAT_ROB_NOT_FULL_P6_MASK) >> MC_MC_RP_STAT_ROB_NOT_FULL_P6_SHIFT)
#define  MC_MC_RP_STAT_ROB_NOT_FULL_P6_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_RP_STAT_ROB_NOT_FULL_P6_MASK) | (((uint32_t)val) << MC_MC_RP_STAT_ROB_NOT_FULL_P6_SHIFT))

#define  MC_MC_RP_STAT_ROB_NOT_FULL_P5_MASK 0x20000000
#define  MC_MC_RP_STAT_ROB_NOT_FULL_P5_SHIFT 29
#define  MC_MC_RP_STAT_ROB_NOT_FULL_P5_MASK_SHIFT(reg) (((reg) & MC_MC_RP_STAT_ROB_NOT_FULL_P5_MASK) >> MC_MC_RP_STAT_ROB_NOT_FULL_P5_SHIFT)
#define  MC_MC_RP_STAT_ROB_NOT_FULL_P5_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_RP_STAT_ROB_NOT_FULL_P5_MASK) | (((uint32_t)val) << MC_MC_RP_STAT_ROB_NOT_FULL_P5_SHIFT))

#define  MC_MC_RP_STAT_ROB_NOT_FULL_P4_MASK 0x10000000
#define  MC_MC_RP_STAT_ROB_NOT_FULL_P4_SHIFT 28
#define  MC_MC_RP_STAT_ROB_NOT_FULL_P4_MASK_SHIFT(reg) (((reg) & MC_MC_RP_STAT_ROB_NOT_FULL_P4_MASK) >> MC_MC_RP_STAT_ROB_NOT_FULL_P4_SHIFT)
#define  MC_MC_RP_STAT_ROB_NOT_FULL_P4_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_RP_STAT_ROB_NOT_FULL_P4_MASK) | (((uint32_t)val) << MC_MC_RP_STAT_ROB_NOT_FULL_P4_SHIFT))

#define  MC_MC_RP_STAT_ROB_NOT_FULL_P3_MASK 0x8000000
#define  MC_MC_RP_STAT_ROB_NOT_FULL_P3_SHIFT 27
#define  MC_MC_RP_STAT_ROB_NOT_FULL_P3_MASK_SHIFT(reg) (((reg) & MC_MC_RP_STAT_ROB_NOT_FULL_P3_MASK) >> MC_MC_RP_STAT_ROB_NOT_FULL_P3_SHIFT)
#define  MC_MC_RP_STAT_ROB_NOT_FULL_P3_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_RP_STAT_ROB_NOT_FULL_P3_MASK) | (((uint32_t)val) << MC_MC_RP_STAT_ROB_NOT_FULL_P3_SHIFT))

#define  MC_MC_RP_STAT_ROB_NOT_FULL_P2_MASK 0x4000000
#define  MC_MC_RP_STAT_ROB_NOT_FULL_P2_SHIFT 26
#define  MC_MC_RP_STAT_ROB_NOT_FULL_P2_MASK_SHIFT(reg) (((reg) & MC_MC_RP_STAT_ROB_NOT_FULL_P2_MASK) >> MC_MC_RP_STAT_ROB_NOT_FULL_P2_SHIFT)
#define  MC_MC_RP_STAT_ROB_NOT_FULL_P2_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_RP_STAT_ROB_NOT_FULL_P2_MASK) | (((uint32_t)val) << MC_MC_RP_STAT_ROB_NOT_FULL_P2_SHIFT))

#define  MC_MC_RP_STAT_ROB_NOT_FULL_P1_MASK 0x2000000
#define  MC_MC_RP_STAT_ROB_NOT_FULL_P1_SHIFT 25
#define  MC_MC_RP_STAT_ROB_NOT_FULL_P1_MASK_SHIFT(reg) (((reg) & MC_MC_RP_STAT_ROB_NOT_FULL_P1_MASK) >> MC_MC_RP_STAT_ROB_NOT_FULL_P1_SHIFT)
#define  MC_MC_RP_STAT_ROB_NOT_FULL_P1_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_RP_STAT_ROB_NOT_FULL_P1_MASK) | (((uint32_t)val) << MC_MC_RP_STAT_ROB_NOT_FULL_P1_SHIFT))

#define  MC_MC_RP_STAT_ROB_NOT_FULL_P0_MASK 0x1000000
#define  MC_MC_RP_STAT_ROB_NOT_FULL_P0_SHIFT 24
#define  MC_MC_RP_STAT_ROB_NOT_FULL_P0_MASK_SHIFT(reg) (((reg) & MC_MC_RP_STAT_ROB_NOT_FULL_P0_MASK) >> MC_MC_RP_STAT_ROB_NOT_FULL_P0_SHIFT)
#define  MC_MC_RP_STAT_ROB_NOT_FULL_P0_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_RP_STAT_ROB_NOT_FULL_P0_MASK) | (((uint32_t)val) << MC_MC_RP_STAT_ROB_NOT_FULL_P0_SHIFT))

#define  MC_MC_RP_STAT_RRB_HAZARD_P7_MASK 0x800000
#define  MC_MC_RP_STAT_RRB_HAZARD_P7_SHIFT 23
#define  MC_MC_RP_STAT_RRB_HAZARD_P7_MASK_SHIFT(reg) (((reg) & MC_MC_RP_STAT_RRB_HAZARD_P7_MASK) >> MC_MC_RP_STAT_RRB_HAZARD_P7_SHIFT)
#define  MC_MC_RP_STAT_RRB_HAZARD_P7_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_RP_STAT_RRB_HAZARD_P7_MASK) | (((uint32_t)val) << MC_MC_RP_STAT_RRB_HAZARD_P7_SHIFT))

#define  MC_MC_RP_STAT_RRB_HAZARD_P6_MASK 0x400000
#define  MC_MC_RP_STAT_RRB_HAZARD_P6_SHIFT 22
#define  MC_MC_RP_STAT_RRB_HAZARD_P6_MASK_SHIFT(reg) (((reg) & MC_MC_RP_STAT_RRB_HAZARD_P6_MASK) >> MC_MC_RP_STAT_RRB_HAZARD_P6_SHIFT)
#define  MC_MC_RP_STAT_RRB_HAZARD_P6_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_RP_STAT_RRB_HAZARD_P6_MASK) | (((uint32_t)val) << MC_MC_RP_STAT_RRB_HAZARD_P6_SHIFT))

#define  MC_MC_RP_STAT_RRB_HAZARD_P5_MASK 0x200000
#define  MC_MC_RP_STAT_RRB_HAZARD_P5_SHIFT 21
#define  MC_MC_RP_STAT_RRB_HAZARD_P5_MASK_SHIFT(reg) (((reg) & MC_MC_RP_STAT_RRB_HAZARD_P5_MASK) >> MC_MC_RP_STAT_RRB_HAZARD_P5_SHIFT)
#define  MC_MC_RP_STAT_RRB_HAZARD_P5_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_RP_STAT_RRB_HAZARD_P5_MASK) | (((uint32_t)val) << MC_MC_RP_STAT_RRB_HAZARD_P5_SHIFT))

#define  MC_MC_RP_STAT_RRB_HAZARD_P4_MASK 0x100000
#define  MC_MC_RP_STAT_RRB_HAZARD_P4_SHIFT 20
#define  MC_MC_RP_STAT_RRB_HAZARD_P4_MASK_SHIFT(reg) (((reg) & MC_MC_RP_STAT_RRB_HAZARD_P4_MASK) >> MC_MC_RP_STAT_RRB_HAZARD_P4_SHIFT)
#define  MC_MC_RP_STAT_RRB_HAZARD_P4_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_RP_STAT_RRB_HAZARD_P4_MASK) | (((uint32_t)val) << MC_MC_RP_STAT_RRB_HAZARD_P4_SHIFT))

#define  MC_MC_RP_STAT_RRB_HAZARD_P3_MASK 0x80000
#define  MC_MC_RP_STAT_RRB_HAZARD_P3_SHIFT 19
#define  MC_MC_RP_STAT_RRB_HAZARD_P3_MASK_SHIFT(reg) (((reg) & MC_MC_RP_STAT_RRB_HAZARD_P3_MASK) >> MC_MC_RP_STAT_RRB_HAZARD_P3_SHIFT)
#define  MC_MC_RP_STAT_RRB_HAZARD_P3_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_RP_STAT_RRB_HAZARD_P3_MASK) | (((uint32_t)val) << MC_MC_RP_STAT_RRB_HAZARD_P3_SHIFT))

#define  MC_MC_RP_STAT_RRB_HAZARD_P2_MASK 0x40000
#define  MC_MC_RP_STAT_RRB_HAZARD_P2_SHIFT 18
#define  MC_MC_RP_STAT_RRB_HAZARD_P2_MASK_SHIFT(reg) (((reg) & MC_MC_RP_STAT_RRB_HAZARD_P2_MASK) >> MC_MC_RP_STAT_RRB_HAZARD_P2_SHIFT)
#define  MC_MC_RP_STAT_RRB_HAZARD_P2_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_RP_STAT_RRB_HAZARD_P2_MASK) | (((uint32_t)val) << MC_MC_RP_STAT_RRB_HAZARD_P2_SHIFT))

#define  MC_MC_RP_STAT_RRB_HAZARD_P1_MASK 0x20000
#define  MC_MC_RP_STAT_RRB_HAZARD_P1_SHIFT 17
#define  MC_MC_RP_STAT_RRB_HAZARD_P1_MASK_SHIFT(reg) (((reg) & MC_MC_RP_STAT_RRB_HAZARD_P1_MASK) >> MC_MC_RP_STAT_RRB_HAZARD_P1_SHIFT)
#define  MC_MC_RP_STAT_RRB_HAZARD_P1_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_RP_STAT_RRB_HAZARD_P1_MASK) | (((uint32_t)val) << MC_MC_RP_STAT_RRB_HAZARD_P1_SHIFT))

#define  MC_MC_RP_STAT_RRB_HAZARD_P0_MASK 0x10000
#define  MC_MC_RP_STAT_RRB_HAZARD_P0_SHIFT 16
#define  MC_MC_RP_STAT_RRB_HAZARD_P0_MASK_SHIFT(reg) (((reg) & MC_MC_RP_STAT_RRB_HAZARD_P0_MASK) >> MC_MC_RP_STAT_RRB_HAZARD_P0_SHIFT)
#define  MC_MC_RP_STAT_RRB_HAZARD_P0_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_RP_STAT_RRB_HAZARD_P0_MASK) | (((uint32_t)val) << MC_MC_RP_STAT_RRB_HAZARD_P0_SHIFT))

#define  MC_MC_RP_STAT_AXIIF_RA_FIFO_EMPTY_P7_MASK 0x8000
#define  MC_MC_RP_STAT_AXIIF_RA_FIFO_EMPTY_P7_SHIFT 15
#define  MC_MC_RP_STAT_AXIIF_RA_FIFO_EMPTY_P7_MASK_SHIFT(reg) (((reg) & MC_MC_RP_STAT_AXIIF_RA_FIFO_EMPTY_P7_MASK) >> MC_MC_RP_STAT_AXIIF_RA_FIFO_EMPTY_P7_SHIFT)
#define  MC_MC_RP_STAT_AXIIF_RA_FIFO_EMPTY_P7_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_RP_STAT_AXIIF_RA_FIFO_EMPTY_P7_MASK) | (((uint32_t)val) << MC_MC_RP_STAT_AXIIF_RA_FIFO_EMPTY_P7_SHIFT))

#define  MC_MC_RP_STAT_AXIIF_RA_FIFO_EMPTY_P6_MASK 0x4000
#define  MC_MC_RP_STAT_AXIIF_RA_FIFO_EMPTY_P6_SHIFT 14
#define  MC_MC_RP_STAT_AXIIF_RA_FIFO_EMPTY_P6_MASK_SHIFT(reg) (((reg) & MC_MC_RP_STAT_AXIIF_RA_FIFO_EMPTY_P6_MASK) >> MC_MC_RP_STAT_AXIIF_RA_FIFO_EMPTY_P6_SHIFT)
#define  MC_MC_RP_STAT_AXIIF_RA_FIFO_EMPTY_P6_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_RP_STAT_AXIIF_RA_FIFO_EMPTY_P6_MASK) | (((uint32_t)val) << MC_MC_RP_STAT_AXIIF_RA_FIFO_EMPTY_P6_SHIFT))

#define  MC_MC_RP_STAT_AXIIF_RA_FIFO_EMPTY_P5_MASK 0x2000
#define  MC_MC_RP_STAT_AXIIF_RA_FIFO_EMPTY_P5_SHIFT 13
#define  MC_MC_RP_STAT_AXIIF_RA_FIFO_EMPTY_P5_MASK_SHIFT(reg) (((reg) & MC_MC_RP_STAT_AXIIF_RA_FIFO_EMPTY_P5_MASK) >> MC_MC_RP_STAT_AXIIF_RA_FIFO_EMPTY_P5_SHIFT)
#define  MC_MC_RP_STAT_AXIIF_RA_FIFO_EMPTY_P5_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_RP_STAT_AXIIF_RA_FIFO_EMPTY_P5_MASK) | (((uint32_t)val) << MC_MC_RP_STAT_AXIIF_RA_FIFO_EMPTY_P5_SHIFT))

#define  MC_MC_RP_STAT_AXIIF_RA_FIFO_EMPTY_P4_MASK 0x1000
#define  MC_MC_RP_STAT_AXIIF_RA_FIFO_EMPTY_P4_SHIFT 12
#define  MC_MC_RP_STAT_AXIIF_RA_FIFO_EMPTY_P4_MASK_SHIFT(reg) (((reg) & MC_MC_RP_STAT_AXIIF_RA_FIFO_EMPTY_P4_MASK) >> MC_MC_RP_STAT_AXIIF_RA_FIFO_EMPTY_P4_SHIFT)
#define  MC_MC_RP_STAT_AXIIF_RA_FIFO_EMPTY_P4_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_RP_STAT_AXIIF_RA_FIFO_EMPTY_P4_MASK) | (((uint32_t)val) << MC_MC_RP_STAT_AXIIF_RA_FIFO_EMPTY_P4_SHIFT))

#define  MC_MC_RP_STAT_AXIIF_RA_FIFO_EMPTY_P3_MASK 0x800
#define  MC_MC_RP_STAT_AXIIF_RA_FIFO_EMPTY_P3_SHIFT 11
#define  MC_MC_RP_STAT_AXIIF_RA_FIFO_EMPTY_P3_MASK_SHIFT(reg) (((reg) & MC_MC_RP_STAT_AXIIF_RA_FIFO_EMPTY_P3_MASK) >> MC_MC_RP_STAT_AXIIF_RA_FIFO_EMPTY_P3_SHIFT)
#define  MC_MC_RP_STAT_AXIIF_RA_FIFO_EMPTY_P3_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_RP_STAT_AXIIF_RA_FIFO_EMPTY_P3_MASK) | (((uint32_t)val) << MC_MC_RP_STAT_AXIIF_RA_FIFO_EMPTY_P3_SHIFT))

#define  MC_MC_RP_STAT_AXIIF_RA_FIFO_EMPTY_P2_MASK 0x400
#define  MC_MC_RP_STAT_AXIIF_RA_FIFO_EMPTY_P2_SHIFT 10
#define  MC_MC_RP_STAT_AXIIF_RA_FIFO_EMPTY_P2_MASK_SHIFT(reg) (((reg) & MC_MC_RP_STAT_AXIIF_RA_FIFO_EMPTY_P2_MASK) >> MC_MC_RP_STAT_AXIIF_RA_FIFO_EMPTY_P2_SHIFT)
#define  MC_MC_RP_STAT_AXIIF_RA_FIFO_EMPTY_P2_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_RP_STAT_AXIIF_RA_FIFO_EMPTY_P2_MASK) | (((uint32_t)val) << MC_MC_RP_STAT_AXIIF_RA_FIFO_EMPTY_P2_SHIFT))

#define  MC_MC_RP_STAT_AXIIF_RA_FIFO_EMPTY_P1_MASK 0x200
#define  MC_MC_RP_STAT_AXIIF_RA_FIFO_EMPTY_P1_SHIFT 9
#define  MC_MC_RP_STAT_AXIIF_RA_FIFO_EMPTY_P1_MASK_SHIFT(reg) (((reg) & MC_MC_RP_STAT_AXIIF_RA_FIFO_EMPTY_P1_MASK) >> MC_MC_RP_STAT_AXIIF_RA_FIFO_EMPTY_P1_SHIFT)
#define  MC_MC_RP_STAT_AXIIF_RA_FIFO_EMPTY_P1_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_RP_STAT_AXIIF_RA_FIFO_EMPTY_P1_MASK) | (((uint32_t)val) << MC_MC_RP_STAT_AXIIF_RA_FIFO_EMPTY_P1_SHIFT))

#define  MC_MC_RP_STAT_AXIIF_RA_FIFO_EMPTY_P0_MASK 0x100
#define  MC_MC_RP_STAT_AXIIF_RA_FIFO_EMPTY_P0_SHIFT 8
#define  MC_MC_RP_STAT_AXIIF_RA_FIFO_EMPTY_P0_MASK_SHIFT(reg) (((reg) & MC_MC_RP_STAT_AXIIF_RA_FIFO_EMPTY_P0_MASK) >> MC_MC_RP_STAT_AXIIF_RA_FIFO_EMPTY_P0_SHIFT)
#define  MC_MC_RP_STAT_AXIIF_RA_FIFO_EMPTY_P0_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_RP_STAT_AXIIF_RA_FIFO_EMPTY_P0_MASK) | (((uint32_t)val) << MC_MC_RP_STAT_AXIIF_RA_FIFO_EMPTY_P0_SHIFT))

#define  MC_MC_RP_STAT_AXIIF_RD_FIFO_EMPTY_P7_MASK 0x80
#define  MC_MC_RP_STAT_AXIIF_RD_FIFO_EMPTY_P7_SHIFT 7
#define  MC_MC_RP_STAT_AXIIF_RD_FIFO_EMPTY_P7_MASK_SHIFT(reg) (((reg) & MC_MC_RP_STAT_AXIIF_RD_FIFO_EMPTY_P7_MASK) >> MC_MC_RP_STAT_AXIIF_RD_FIFO_EMPTY_P7_SHIFT)
#define  MC_MC_RP_STAT_AXIIF_RD_FIFO_EMPTY_P7_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_RP_STAT_AXIIF_RD_FIFO_EMPTY_P7_MASK) | (((uint32_t)val) << MC_MC_RP_STAT_AXIIF_RD_FIFO_EMPTY_P7_SHIFT))

#define  MC_MC_RP_STAT_AXIIF_RD_FIFO_EMPTY_P6_MASK 0x40
#define  MC_MC_RP_STAT_AXIIF_RD_FIFO_EMPTY_P6_SHIFT 6
#define  MC_MC_RP_STAT_AXIIF_RD_FIFO_EMPTY_P6_MASK_SHIFT(reg) (((reg) & MC_MC_RP_STAT_AXIIF_RD_FIFO_EMPTY_P6_MASK) >> MC_MC_RP_STAT_AXIIF_RD_FIFO_EMPTY_P6_SHIFT)
#define  MC_MC_RP_STAT_AXIIF_RD_FIFO_EMPTY_P6_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_RP_STAT_AXIIF_RD_FIFO_EMPTY_P6_MASK) | (((uint32_t)val) << MC_MC_RP_STAT_AXIIF_RD_FIFO_EMPTY_P6_SHIFT))

#define  MC_MC_RP_STAT_AXIIF_RD_FIFO_EMPTY_P5_MASK 0x20
#define  MC_MC_RP_STAT_AXIIF_RD_FIFO_EMPTY_P5_SHIFT 5
#define  MC_MC_RP_STAT_AXIIF_RD_FIFO_EMPTY_P5_MASK_SHIFT(reg) (((reg) & MC_MC_RP_STAT_AXIIF_RD_FIFO_EMPTY_P5_MASK) >> MC_MC_RP_STAT_AXIIF_RD_FIFO_EMPTY_P5_SHIFT)
#define  MC_MC_RP_STAT_AXIIF_RD_FIFO_EMPTY_P5_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_RP_STAT_AXIIF_RD_FIFO_EMPTY_P5_MASK) | (((uint32_t)val) << MC_MC_RP_STAT_AXIIF_RD_FIFO_EMPTY_P5_SHIFT))

#define  MC_MC_RP_STAT_AXIIF_RD_FIFO_EMPTY_P4_MASK 0x10
#define  MC_MC_RP_STAT_AXIIF_RD_FIFO_EMPTY_P4_SHIFT 4
#define  MC_MC_RP_STAT_AXIIF_RD_FIFO_EMPTY_P4_MASK_SHIFT(reg) (((reg) & MC_MC_RP_STAT_AXIIF_RD_FIFO_EMPTY_P4_MASK) >> MC_MC_RP_STAT_AXIIF_RD_FIFO_EMPTY_P4_SHIFT)
#define  MC_MC_RP_STAT_AXIIF_RD_FIFO_EMPTY_P4_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_RP_STAT_AXIIF_RD_FIFO_EMPTY_P4_MASK) | (((uint32_t)val) << MC_MC_RP_STAT_AXIIF_RD_FIFO_EMPTY_P4_SHIFT))

#define  MC_MC_RP_STAT_AXIIF_RD_FIFO_EMPTY_P3_MASK 0x8
#define  MC_MC_RP_STAT_AXIIF_RD_FIFO_EMPTY_P3_SHIFT 3
#define  MC_MC_RP_STAT_AXIIF_RD_FIFO_EMPTY_P3_MASK_SHIFT(reg) (((reg) & MC_MC_RP_STAT_AXIIF_RD_FIFO_EMPTY_P3_MASK) >> MC_MC_RP_STAT_AXIIF_RD_FIFO_EMPTY_P3_SHIFT)
#define  MC_MC_RP_STAT_AXIIF_RD_FIFO_EMPTY_P3_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_RP_STAT_AXIIF_RD_FIFO_EMPTY_P3_MASK) | (((uint32_t)val) << MC_MC_RP_STAT_AXIIF_RD_FIFO_EMPTY_P3_SHIFT))

#define  MC_MC_RP_STAT_AXIIF_RD_FIFO_EMPTY_P2_MASK 0x4
#define  MC_MC_RP_STAT_AXIIF_RD_FIFO_EMPTY_P2_SHIFT 2
#define  MC_MC_RP_STAT_AXIIF_RD_FIFO_EMPTY_P2_MASK_SHIFT(reg) (((reg) & MC_MC_RP_STAT_AXIIF_RD_FIFO_EMPTY_P2_MASK) >> MC_MC_RP_STAT_AXIIF_RD_FIFO_EMPTY_P2_SHIFT)
#define  MC_MC_RP_STAT_AXIIF_RD_FIFO_EMPTY_P2_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_RP_STAT_AXIIF_RD_FIFO_EMPTY_P2_MASK) | (((uint32_t)val) << MC_MC_RP_STAT_AXIIF_RD_FIFO_EMPTY_P2_SHIFT))

#define  MC_MC_RP_STAT_AXIIF_RD_FIFO_EMPTY_P1_MASK 0x2
#define  MC_MC_RP_STAT_AXIIF_RD_FIFO_EMPTY_P1_SHIFT 1
#define  MC_MC_RP_STAT_AXIIF_RD_FIFO_EMPTY_P1_MASK_SHIFT(reg) (((reg) & MC_MC_RP_STAT_AXIIF_RD_FIFO_EMPTY_P1_MASK) >> MC_MC_RP_STAT_AXIIF_RD_FIFO_EMPTY_P1_SHIFT)
#define  MC_MC_RP_STAT_AXIIF_RD_FIFO_EMPTY_P1_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_RP_STAT_AXIIF_RD_FIFO_EMPTY_P1_MASK) | (((uint32_t)val) << MC_MC_RP_STAT_AXIIF_RD_FIFO_EMPTY_P1_SHIFT))

#define  MC_MC_RP_STAT_AXIIF_RD_FIFO_EMPTY_P0_MASK 0x1
#define  MC_MC_RP_STAT_AXIIF_RD_FIFO_EMPTY_P0_SHIFT 0
#define  MC_MC_RP_STAT_AXIIF_RD_FIFO_EMPTY_P0_MASK_SHIFT(reg) (((reg) & MC_MC_RP_STAT_AXIIF_RD_FIFO_EMPTY_P0_MASK) >> MC_MC_RP_STAT_AXIIF_RD_FIFO_EMPTY_P0_SHIFT)
#define  MC_MC_RP_STAT_AXIIF_RD_FIFO_EMPTY_P0_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_RP_STAT_AXIIF_RD_FIFO_EMPTY_P0_MASK) | (((uint32_t)val) << MC_MC_RP_STAT_AXIIF_RD_FIFO_EMPTY_P0_SHIFT))

//====================================================================
//Register: User Initiated Command Register 0 (USER_COMMAND_0)
//====================================================================

#define  MC_USER_COMMAND_0_RESERVED1_MASK 0xc0000000
#define  MC_USER_COMMAND_0_RESERVED1_SHIFT 30
#define  MC_USER_COMMAND_0_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_USER_COMMAND_0_RESERVED1_MASK) >> MC_USER_COMMAND_0_RESERVED1_SHIFT)
#define  MC_USER_COMMAND_0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_USER_COMMAND_0_RESERVED1_MASK) | (((uint32_t)val) << MC_USER_COMMAND_0_RESERVED1_SHIFT))

#define  MC_USER_COMMAND_0_CH_MASK 0x30000000
#define  MC_USER_COMMAND_0_CH_SHIFT 28
#define  MC_USER_COMMAND_0_CH_MASK_SHIFT(reg) (((reg) & MC_USER_COMMAND_0_CH_MASK) >> MC_USER_COMMAND_0_CH_SHIFT)
#define  MC_USER_COMMAND_0_CH_REPLACE_VAL(reg,val) (((reg) & ~MC_USER_COMMAND_0_CH_MASK) | (((uint32_t)val) << MC_USER_COMMAND_0_CH_SHIFT))

#define  MC_USER_COMMAND_0_CS_MASK 0xf000000
#define  MC_USER_COMMAND_0_CS_SHIFT 24
#define  MC_USER_COMMAND_0_CS_MASK_SHIFT(reg) (((reg) & MC_USER_COMMAND_0_CS_MASK) >> MC_USER_COMMAND_0_CS_SHIFT)
#define  MC_USER_COMMAND_0_CS_REPLACE_VAL(reg,val) (((reg) & ~MC_USER_COMMAND_0_CS_MASK) | (((uint32_t)val) << MC_USER_COMMAND_0_CS_SHIFT))

#define  MC_USER_COMMAND_0_RESERVED2_MASK 0x800000
#define  MC_USER_COMMAND_0_RESERVED2_SHIFT 23
#define  MC_USER_COMMAND_0_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_USER_COMMAND_0_RESERVED2_MASK) >> MC_USER_COMMAND_0_RESERVED2_SHIFT)
#define  MC_USER_COMMAND_0_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_USER_COMMAND_0_RESERVED2_MASK) | (((uint32_t)val) << MC_USER_COMMAND_0_RESERVED2_SHIFT))

#define  MC_USER_COMMAND_0_LMR6_REQ_MASK 0x400000
#define  MC_USER_COMMAND_0_LMR6_REQ_SHIFT 22
#define  MC_USER_COMMAND_0_LMR6_REQ_MASK_SHIFT(reg) (((reg) & MC_USER_COMMAND_0_LMR6_REQ_MASK) >> MC_USER_COMMAND_0_LMR6_REQ_SHIFT)
#define  MC_USER_COMMAND_0_LMR6_REQ_REPLACE_VAL(reg,val) (((reg) & ~MC_USER_COMMAND_0_LMR6_REQ_MASK) | (((uint32_t)val) << MC_USER_COMMAND_0_LMR6_REQ_SHIFT))

#define  MC_USER_COMMAND_0_LMR5_REQ_MASK 0x200000
#define  MC_USER_COMMAND_0_LMR5_REQ_SHIFT 21
#define  MC_USER_COMMAND_0_LMR5_REQ_MASK_SHIFT(reg) (((reg) & MC_USER_COMMAND_0_LMR5_REQ_MASK) >> MC_USER_COMMAND_0_LMR5_REQ_SHIFT)
#define  MC_USER_COMMAND_0_LMR5_REQ_REPLACE_VAL(reg,val) (((reg) & ~MC_USER_COMMAND_0_LMR5_REQ_MASK) | (((uint32_t)val) << MC_USER_COMMAND_0_LMR5_REQ_SHIFT))

#define  MC_USER_COMMAND_0_LMR4_REQ_MASK 0x100000
#define  MC_USER_COMMAND_0_LMR4_REQ_SHIFT 20
#define  MC_USER_COMMAND_0_LMR4_REQ_MASK_SHIFT(reg) (((reg) & MC_USER_COMMAND_0_LMR4_REQ_MASK) >> MC_USER_COMMAND_0_LMR4_REQ_SHIFT)
#define  MC_USER_COMMAND_0_LMR4_REQ_REPLACE_VAL(reg,val) (((reg) & ~MC_USER_COMMAND_0_LMR4_REQ_MASK) | (((uint32_t)val) << MC_USER_COMMAND_0_LMR4_REQ_SHIFT))

#define  MC_USER_COMMAND_0_RESERVED3_MASK 0xc0000
#define  MC_USER_COMMAND_0_RESERVED3_SHIFT 18
#define  MC_USER_COMMAND_0_RESERVED3_MASK_SHIFT(reg) (((reg) & MC_USER_COMMAND_0_RESERVED3_MASK) >> MC_USER_COMMAND_0_RESERVED3_SHIFT)
#define  MC_USER_COMMAND_0_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~MC_USER_COMMAND_0_RESERVED3_MASK) | (((uint32_t)val) << MC_USER_COMMAND_0_RESERVED3_SHIFT))

#define  MC_USER_COMMAND_0_DPD_REQ_MASK 0x30000
#define  MC_USER_COMMAND_0_DPD_REQ_SHIFT 16
#define  MC_USER_COMMAND_0_DPD_REQ_MASK_SHIFT(reg) (((reg) & MC_USER_COMMAND_0_DPD_REQ_MASK) >> MC_USER_COMMAND_0_DPD_REQ_SHIFT)
#define  MC_USER_COMMAND_0_DPD_REQ_REPLACE_VAL(reg,val) (((reg) & ~MC_USER_COMMAND_0_DPD_REQ_MASK) | (((uint32_t)val) << MC_USER_COMMAND_0_DPD_REQ_SHIFT))

#define  MC_USER_COMMAND_0_RESERVED4_MASK 0x8000
#define  MC_USER_COMMAND_0_RESERVED4_SHIFT 15
#define  MC_USER_COMMAND_0_RESERVED4_MASK_SHIFT(reg) (((reg) & MC_USER_COMMAND_0_RESERVED4_MASK) >> MC_USER_COMMAND_0_RESERVED4_SHIFT)
#define  MC_USER_COMMAND_0_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~MC_USER_COMMAND_0_RESERVED4_MASK) | (((uint32_t)val) << MC_USER_COMMAND_0_RESERVED4_SHIFT))

#define  MC_USER_COMMAND_0_ZQ_RESET_MASK 0x4000
#define  MC_USER_COMMAND_0_ZQ_RESET_SHIFT 14
#define  MC_USER_COMMAND_0_ZQ_RESET_MASK_SHIFT(reg) (((reg) & MC_USER_COMMAND_0_ZQ_RESET_MASK) >> MC_USER_COMMAND_0_ZQ_RESET_SHIFT)
#define  MC_USER_COMMAND_0_ZQ_RESET_REPLACE_VAL(reg,val) (((reg) & ~MC_USER_COMMAND_0_ZQ_RESET_MASK) | (((uint32_t)val) << MC_USER_COMMAND_0_ZQ_RESET_SHIFT))

#define  MC_USER_COMMAND_0_ZQC_SHORT_MASK 0x2000
#define  MC_USER_COMMAND_0_ZQC_SHORT_SHIFT 13
#define  MC_USER_COMMAND_0_ZQC_SHORT_MASK_SHIFT(reg) (((reg) & MC_USER_COMMAND_0_ZQC_SHORT_MASK) >> MC_USER_COMMAND_0_ZQC_SHORT_SHIFT)
#define  MC_USER_COMMAND_0_ZQC_SHORT_REPLACE_VAL(reg,val) (((reg) & ~MC_USER_COMMAND_0_ZQC_SHORT_MASK) | (((uint32_t)val) << MC_USER_COMMAND_0_ZQC_SHORT_SHIFT))

#define  MC_USER_COMMAND_0_ZQC_LONG_MASK 0x1000
#define  MC_USER_COMMAND_0_ZQC_LONG_SHIFT 12
#define  MC_USER_COMMAND_0_ZQC_LONG_MASK_SHIFT(reg) (((reg) & MC_USER_COMMAND_0_ZQC_LONG_MASK) >> MC_USER_COMMAND_0_ZQC_LONG_SHIFT)
#define  MC_USER_COMMAND_0_ZQC_LONG_REPLACE_VAL(reg,val) (((reg) & ~MC_USER_COMMAND_0_ZQC_LONG_MASK) | (((uint32_t)val) << MC_USER_COMMAND_0_ZQC_LONG_SHIFT))

#define  MC_USER_COMMAND_0_LMR3_REQ_MASK 0x800
#define  MC_USER_COMMAND_0_LMR3_REQ_SHIFT 11
#define  MC_USER_COMMAND_0_LMR3_REQ_MASK_SHIFT(reg) (((reg) & MC_USER_COMMAND_0_LMR3_REQ_MASK) >> MC_USER_COMMAND_0_LMR3_REQ_SHIFT)
#define  MC_USER_COMMAND_0_LMR3_REQ_REPLACE_VAL(reg,val) (((reg) & ~MC_USER_COMMAND_0_LMR3_REQ_MASK) | (((uint32_t)val) << MC_USER_COMMAND_0_LMR3_REQ_SHIFT))

#define  MC_USER_COMMAND_0_LMR2_REQ_MASK 0x400
#define  MC_USER_COMMAND_0_LMR2_REQ_SHIFT 10
#define  MC_USER_COMMAND_0_LMR2_REQ_MASK_SHIFT(reg) (((reg) & MC_USER_COMMAND_0_LMR2_REQ_MASK) >> MC_USER_COMMAND_0_LMR2_REQ_SHIFT)
#define  MC_USER_COMMAND_0_LMR2_REQ_REPLACE_VAL(reg,val) (((reg) & ~MC_USER_COMMAND_0_LMR2_REQ_MASK) | (((uint32_t)val) << MC_USER_COMMAND_0_LMR2_REQ_SHIFT))

#define  MC_USER_COMMAND_0_LMR1_REQ_MASK 0x200
#define  MC_USER_COMMAND_0_LMR1_REQ_SHIFT 9
#define  MC_USER_COMMAND_0_LMR1_REQ_MASK_SHIFT(reg) (((reg) & MC_USER_COMMAND_0_LMR1_REQ_MASK) >> MC_USER_COMMAND_0_LMR1_REQ_SHIFT)
#define  MC_USER_COMMAND_0_LMR1_REQ_REPLACE_VAL(reg,val) (((reg) & ~MC_USER_COMMAND_0_LMR1_REQ_MASK) | (((uint32_t)val) << MC_USER_COMMAND_0_LMR1_REQ_SHIFT))

#define  MC_USER_COMMAND_0_LMR0_REQ_MASK 0x100
#define  MC_USER_COMMAND_0_LMR0_REQ_SHIFT 8
#define  MC_USER_COMMAND_0_LMR0_REQ_MASK_SHIFT(reg) (((reg) & MC_USER_COMMAND_0_LMR0_REQ_MASK) >> MC_USER_COMMAND_0_LMR0_REQ_SHIFT)
#define  MC_USER_COMMAND_0_LMR0_REQ_REPLACE_VAL(reg,val) (((reg) & ~MC_USER_COMMAND_0_LMR0_REQ_MASK) | (((uint32_t)val) << MC_USER_COMMAND_0_LMR0_REQ_SHIFT))

#define  MC_USER_COMMAND_0_SR_REQ_MASK 0xc0
#define  MC_USER_COMMAND_0_SR_REQ_SHIFT 6
#define  MC_USER_COMMAND_0_SR_REQ_MASK_SHIFT(reg) (((reg) & MC_USER_COMMAND_0_SR_REQ_MASK) >> MC_USER_COMMAND_0_SR_REQ_SHIFT)
#define  MC_USER_COMMAND_0_SR_REQ_REPLACE_VAL(reg,val) (((reg) & ~MC_USER_COMMAND_0_SR_REQ_MASK) | (((uint32_t)val) << MC_USER_COMMAND_0_SR_REQ_SHIFT))

#define  MC_USER_COMMAND_0_PPD_REQ_MASK 0x20
#define  MC_USER_COMMAND_0_PPD_REQ_SHIFT 5
#define  MC_USER_COMMAND_0_PPD_REQ_MASK_SHIFT(reg) (((reg) & MC_USER_COMMAND_0_PPD_REQ_MASK) >> MC_USER_COMMAND_0_PPD_REQ_SHIFT)
#define  MC_USER_COMMAND_0_PPD_REQ_REPLACE_VAL(reg,val) (((reg) & ~MC_USER_COMMAND_0_PPD_REQ_MASK) | (((uint32_t)val) << MC_USER_COMMAND_0_PPD_REQ_SHIFT))

#define  MC_USER_COMMAND_0_APD_REQ_MASK 0x10
#define  MC_USER_COMMAND_0_APD_REQ_SHIFT 4
#define  MC_USER_COMMAND_0_APD_REQ_MASK_SHIFT(reg) (((reg) & MC_USER_COMMAND_0_APD_REQ_MASK) >> MC_USER_COMMAND_0_APD_REQ_SHIFT)
#define  MC_USER_COMMAND_0_APD_REQ_REPLACE_VAL(reg,val) (((reg) & ~MC_USER_COMMAND_0_APD_REQ_MASK) | (((uint32_t)val) << MC_USER_COMMAND_0_APD_REQ_SHIFT))

#define  MC_USER_COMMAND_0_RESERVED5_MASK 0xc
#define  MC_USER_COMMAND_0_RESERVED5_SHIFT 2
#define  MC_USER_COMMAND_0_RESERVED5_MASK_SHIFT(reg) (((reg) & MC_USER_COMMAND_0_RESERVED5_MASK) >> MC_USER_COMMAND_0_RESERVED5_SHIFT)
#define  MC_USER_COMMAND_0_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~MC_USER_COMMAND_0_RESERVED5_MASK) | (((uint32_t)val) << MC_USER_COMMAND_0_RESERVED5_SHIFT))

#define  MC_USER_COMMAND_0_WCB_DRAIN_REQ_MASK 0x2
#define  MC_USER_COMMAND_0_WCB_DRAIN_REQ_SHIFT 1
#define  MC_USER_COMMAND_0_WCB_DRAIN_REQ_MASK_SHIFT(reg) (((reg) & MC_USER_COMMAND_0_WCB_DRAIN_REQ_MASK) >> MC_USER_COMMAND_0_WCB_DRAIN_REQ_SHIFT)
#define  MC_USER_COMMAND_0_WCB_DRAIN_REQ_REPLACE_VAL(reg,val) (((reg) & ~MC_USER_COMMAND_0_WCB_DRAIN_REQ_MASK) | (((uint32_t)val) << MC_USER_COMMAND_0_WCB_DRAIN_REQ_SHIFT))

#define  MC_USER_COMMAND_0_SDRAM_INIT_REQ_MASK 0x1
#define  MC_USER_COMMAND_0_SDRAM_INIT_REQ_SHIFT 0
#define  MC_USER_COMMAND_0_SDRAM_INIT_REQ_MASK_SHIFT(reg) (((reg) & MC_USER_COMMAND_0_SDRAM_INIT_REQ_MASK) >> MC_USER_COMMAND_0_SDRAM_INIT_REQ_SHIFT)
#define  MC_USER_COMMAND_0_SDRAM_INIT_REQ_REPLACE_VAL(reg,val) (((reg) & ~MC_USER_COMMAND_0_SDRAM_INIT_REQ_MASK) | (((uint32_t)val) << MC_USER_COMMAND_0_SDRAM_INIT_REQ_SHIFT))

//====================================================================
//Register: User Initiated Command Register 1 (USER_COMMAND_1)
//====================================================================

#define  MC_USER_COMMAND_1_RESERVED1_MASK 0xc0000000
#define  MC_USER_COMMAND_1_RESERVED1_SHIFT 30
#define  MC_USER_COMMAND_1_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_USER_COMMAND_1_RESERVED1_MASK) >> MC_USER_COMMAND_1_RESERVED1_SHIFT)
#define  MC_USER_COMMAND_1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_USER_COMMAND_1_RESERVED1_MASK) | (((uint32_t)val) << MC_USER_COMMAND_1_RESERVED1_SHIFT))

#define  MC_USER_COMMAND_1_CH_MASK 0x30000000
#define  MC_USER_COMMAND_1_CH_SHIFT 28
#define  MC_USER_COMMAND_1_CH_MASK_SHIFT(reg) (((reg) & MC_USER_COMMAND_1_CH_MASK) >> MC_USER_COMMAND_1_CH_SHIFT)
#define  MC_USER_COMMAND_1_CH_REPLACE_VAL(reg,val) (((reg) & ~MC_USER_COMMAND_1_CH_MASK) | (((uint32_t)val) << MC_USER_COMMAND_1_CH_SHIFT))

#define  MC_USER_COMMAND_1_CS_MASK 0xf000000
#define  MC_USER_COMMAND_1_CS_SHIFT 24
#define  MC_USER_COMMAND_1_CS_MASK_SHIFT(reg) (((reg) & MC_USER_COMMAND_1_CS_MASK) >> MC_USER_COMMAND_1_CS_SHIFT)
#define  MC_USER_COMMAND_1_CS_REPLACE_VAL(reg,val) (((reg) & ~MC_USER_COMMAND_1_CS_MASK) | (((uint32_t)val) << MC_USER_COMMAND_1_CS_SHIFT))

#define  MC_USER_COMMAND_1_RESERVED2_MASK 0xfc0000
#define  MC_USER_COMMAND_1_RESERVED2_SHIFT 18
#define  MC_USER_COMMAND_1_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_USER_COMMAND_1_RESERVED2_MASK) >> MC_USER_COMMAND_1_RESERVED2_SHIFT)
#define  MC_USER_COMMAND_1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_USER_COMMAND_1_RESERVED2_MASK) | (((uint32_t)val) << MC_USER_COMMAND_1_RESERVED2_SHIFT))

#define  MC_USER_COMMAND_1_MRW_MASK 0x20000
#define  MC_USER_COMMAND_1_MRW_SHIFT 17
#define  MC_USER_COMMAND_1_MRW_MASK_SHIFT(reg) (((reg) & MC_USER_COMMAND_1_MRW_MASK) >> MC_USER_COMMAND_1_MRW_SHIFT)
#define  MC_USER_COMMAND_1_MRW_REPLACE_VAL(reg,val) (((reg) & ~MC_USER_COMMAND_1_MRW_MASK) | (((uint32_t)val) << MC_USER_COMMAND_1_MRW_SHIFT))

#define  MC_USER_COMMAND_1_MRR_MASK 0x10000
#define  MC_USER_COMMAND_1_MRR_SHIFT 16
#define  MC_USER_COMMAND_1_MRR_MASK_SHIFT(reg) (((reg) & MC_USER_COMMAND_1_MRR_MASK) >> MC_USER_COMMAND_1_MRR_SHIFT)
#define  MC_USER_COMMAND_1_MRR_REPLACE_VAL(reg,val) (((reg) & ~MC_USER_COMMAND_1_MRR_MASK) | (((uint32_t)val) << MC_USER_COMMAND_1_MRR_SHIFT))

#define  MC_USER_COMMAND_1_RESERVED3_MASK 0xff00
#define  MC_USER_COMMAND_1_RESERVED3_SHIFT 8
#define  MC_USER_COMMAND_1_RESERVED3_MASK_SHIFT(reg) (((reg) & MC_USER_COMMAND_1_RESERVED3_MASK) >> MC_USER_COMMAND_1_RESERVED3_SHIFT)
#define  MC_USER_COMMAND_1_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~MC_USER_COMMAND_1_RESERVED3_MASK) | (((uint32_t)val) << MC_USER_COMMAND_1_RESERVED3_SHIFT))

#define  MC_USER_COMMAND_1_MR_ADDRESS_MASK 0xff
#define  MC_USER_COMMAND_1_MR_ADDRESS_SHIFT 0
#define  MC_USER_COMMAND_1_MR_ADDRESS_MASK_SHIFT(reg) (((reg) & MC_USER_COMMAND_1_MR_ADDRESS_MASK) >> MC_USER_COMMAND_1_MR_ADDRESS_SHIFT)
#define  MC_USER_COMMAND_1_MR_ADDRESS_REPLACE_VAL(reg,val) (((reg) & ~MC_USER_COMMAND_1_MR_ADDRESS_MASK) | (((uint32_t)val) << MC_USER_COMMAND_1_MR_ADDRESS_SHIFT))

//====================================================================
//Register: Internal SRAM Control Register (SRAM_control)
//====================================================================

#define  MC_SRAM_CONTROL_REGTABLE_WTC_MASK 0xf0000000
#define  MC_SRAM_CONTROL_REGTABLE_WTC_SHIFT 28
#define  MC_SRAM_CONTROL_REGTABLE_WTC_MASK_SHIFT(reg) (((reg) & MC_SRAM_CONTROL_REGTABLE_WTC_MASK) >> MC_SRAM_CONTROL_REGTABLE_WTC_SHIFT)
#define  MC_SRAM_CONTROL_REGTABLE_WTC_REPLACE_VAL(reg,val) (((reg) & ~MC_SRAM_CONTROL_REGTABLE_WTC_MASK) | (((uint32_t)val) << MC_SRAM_CONTROL_REGTABLE_WTC_SHIFT))

#define  MC_SRAM_CONTROL_REGTABLE_RTC_MASK 0xf000000
#define  MC_SRAM_CONTROL_REGTABLE_RTC_SHIFT 24
#define  MC_SRAM_CONTROL_REGTABLE_RTC_MASK_SHIFT(reg) (((reg) & MC_SRAM_CONTROL_REGTABLE_RTC_MASK) >> MC_SRAM_CONTROL_REGTABLE_RTC_SHIFT)
#define  MC_SRAM_CONTROL_REGTABLE_RTC_REPLACE_VAL(reg,val) (((reg) & ~MC_SRAM_CONTROL_REGTABLE_RTC_MASK) | (((uint32_t)val) << MC_SRAM_CONTROL_REGTABLE_RTC_SHIFT))

#define  MC_SRAM_CONTROL_WDB_WTC_MASK 0xf00000
#define  MC_SRAM_CONTROL_WDB_WTC_SHIFT 20
#define  MC_SRAM_CONTROL_WDB_WTC_MASK_SHIFT(reg) (((reg) & MC_SRAM_CONTROL_WDB_WTC_MASK) >> MC_SRAM_CONTROL_WDB_WTC_SHIFT)
#define  MC_SRAM_CONTROL_WDB_WTC_REPLACE_VAL(reg,val) (((reg) & ~MC_SRAM_CONTROL_WDB_WTC_MASK) | (((uint32_t)val) << MC_SRAM_CONTROL_WDB_WTC_SHIFT))

#define  MC_SRAM_CONTROL_WDB_RTC_MASK 0xf0000
#define  MC_SRAM_CONTROL_WDB_RTC_SHIFT 16
#define  MC_SRAM_CONTROL_WDB_RTC_MASK_SHIFT(reg) (((reg) & MC_SRAM_CONTROL_WDB_RTC_MASK) >> MC_SRAM_CONTROL_WDB_RTC_SHIFT)
#define  MC_SRAM_CONTROL_WDB_RTC_REPLACE_VAL(reg,val) (((reg) & ~MC_SRAM_CONTROL_WDB_RTC_MASK) | (((uint32_t)val) << MC_SRAM_CONTROL_WDB_RTC_SHIFT))

#define  MC_SRAM_CONTROL_RESERVED1_MASK 0xc000
#define  MC_SRAM_CONTROL_RESERVED1_SHIFT 14
#define  MC_SRAM_CONTROL_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_SRAM_CONTROL_RESERVED1_MASK) >> MC_SRAM_CONTROL_RESERVED1_SHIFT)
#define  MC_SRAM_CONTROL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_SRAM_CONTROL_RESERVED1_MASK) | (((uint32_t)val) << MC_SRAM_CONTROL_RESERVED1_SHIFT))

#define  MC_SRAM_CONTROL_SRAM_PDWN_EXIT_WAIT_CYCLE_MASK 0x3f00
#define  MC_SRAM_CONTROL_SRAM_PDWN_EXIT_WAIT_CYCLE_SHIFT 8
#define  MC_SRAM_CONTROL_SRAM_PDWN_EXIT_WAIT_CYCLE_MASK_SHIFT(reg) (((reg) & MC_SRAM_CONTROL_SRAM_PDWN_EXIT_WAIT_CYCLE_MASK) >> MC_SRAM_CONTROL_SRAM_PDWN_EXIT_WAIT_CYCLE_SHIFT)
#define  MC_SRAM_CONTROL_SRAM_PDWN_EXIT_WAIT_CYCLE_REPLACE_VAL(reg,val) (((reg) & ~MC_SRAM_CONTROL_SRAM_PDWN_EXIT_WAIT_CYCLE_MASK) | (((uint32_t)val) << MC_SRAM_CONTROL_SRAM_PDWN_EXIT_WAIT_CYCLE_SHIFT))

#define  MC_SRAM_CONTROL_ROB_WTC_MASK 0xf0
#define  MC_SRAM_CONTROL_ROB_WTC_SHIFT 4
#define  MC_SRAM_CONTROL_ROB_WTC_MASK_SHIFT(reg) (((reg) & MC_SRAM_CONTROL_ROB_WTC_MASK) >> MC_SRAM_CONTROL_ROB_WTC_SHIFT)
#define  MC_SRAM_CONTROL_ROB_WTC_REPLACE_VAL(reg,val) (((reg) & ~MC_SRAM_CONTROL_ROB_WTC_MASK) | (((uint32_t)val) << MC_SRAM_CONTROL_ROB_WTC_SHIFT))

#define  MC_SRAM_CONTROL_ROB_RTC_MASK 0xf
#define  MC_SRAM_CONTROL_ROB_RTC_SHIFT 0
#define  MC_SRAM_CONTROL_ROB_RTC_MASK_SHIFT(reg) (((reg) & MC_SRAM_CONTROL_ROB_RTC_MASK) >> MC_SRAM_CONTROL_ROB_RTC_SHIFT)
#define  MC_SRAM_CONTROL_ROB_RTC_REPLACE_VAL(reg,val) (((reg) & ~MC_SRAM_CONTROL_ROB_RTC_MASK) | (((uint32_t)val) << MC_SRAM_CONTROL_ROB_RTC_SHIFT))

//====================================================================
//Register: MC Control Register 0 (MC_Control_0)
//====================================================================

#define  MC_MC_CONTROL_0_TRUSTZONE_LOCK_MASK 0x80000000
#define  MC_MC_CONTROL_0_TRUSTZONE_LOCK_SHIFT 31
#define  MC_MC_CONTROL_0_TRUSTZONE_LOCK_MASK_SHIFT(reg) (((reg) & MC_MC_CONTROL_0_TRUSTZONE_LOCK_MASK) >> MC_MC_CONTROL_0_TRUSTZONE_LOCK_SHIFT)
#define  MC_MC_CONTROL_0_TRUSTZONE_LOCK_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_CONTROL_0_TRUSTZONE_LOCK_MASK) | (((uint32_t)val) << MC_MC_CONTROL_0_TRUSTZONE_LOCK_SHIFT))

#define  MC_MC_CONTROL_0_ADDR_MAP_LOCK_MASK 0x40000000
#define  MC_MC_CONTROL_0_ADDR_MAP_LOCK_SHIFT 30
#define  MC_MC_CONTROL_0_ADDR_MAP_LOCK_MASK_SHIFT(reg) (((reg) & MC_MC_CONTROL_0_ADDR_MAP_LOCK_MASK) >> MC_MC_CONTROL_0_ADDR_MAP_LOCK_SHIFT)
#define  MC_MC_CONTROL_0_ADDR_MAP_LOCK_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_CONTROL_0_ADDR_MAP_LOCK_MASK) | (((uint32_t)val) << MC_MC_CONTROL_0_ADDR_MAP_LOCK_SHIFT))

#define  MC_MC_CONTROL_0_RESERVED1_MASK 0x30000000
#define  MC_MC_CONTROL_0_RESERVED1_SHIFT 28
#define  MC_MC_CONTROL_0_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_MC_CONTROL_0_RESERVED1_MASK) >> MC_MC_CONTROL_0_RESERVED1_SHIFT)
#define  MC_MC_CONTROL_0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_CONTROL_0_RESERVED1_MASK) | (((uint32_t)val) << MC_MC_CONTROL_0_RESERVED1_SHIFT))

#define  MC_MC_CONTROL_0_CHOP_CHANGE_MASK 0x8000000
#define  MC_MC_CONTROL_0_CHOP_CHANGE_SHIFT 27
#define  MC_MC_CONTROL_0_CHOP_CHANGE_MASK_SHIFT(reg) (((reg) & MC_MC_CONTROL_0_CHOP_CHANGE_MASK) >> MC_MC_CONTROL_0_CHOP_CHANGE_SHIFT)
#define  MC_MC_CONTROL_0_CHOP_CHANGE_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_CONTROL_0_CHOP_CHANGE_MASK) | (((uint32_t)val) << MC_MC_CONTROL_0_CHOP_CHANGE_SHIFT))

#define  MC_MC_CONTROL_0_AXI_CHOP_MASK 0x7000000
#define  MC_MC_CONTROL_0_AXI_CHOP_SHIFT 24
#define  MC_MC_CONTROL_0_AXI_CHOP_MASK_SHIFT(reg) (((reg) & MC_MC_CONTROL_0_AXI_CHOP_MASK) >> MC_MC_CONTROL_0_AXI_CHOP_SHIFT)
#define  MC_MC_CONTROL_0_AXI_CHOP_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_CONTROL_0_AXI_CHOP_MASK) | (((uint32_t)val) << MC_MC_CONTROL_0_AXI_CHOP_SHIFT))

#define  MC_MC_CONTROL_0_RESERVED2_MASK 0xfe0000
#define  MC_MC_CONTROL_0_RESERVED2_SHIFT 17
#define  MC_MC_CONTROL_0_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_MC_CONTROL_0_RESERVED2_MASK) >> MC_MC_CONTROL_0_RESERVED2_SHIFT)
#define  MC_MC_CONTROL_0_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_CONTROL_0_RESERVED2_MASK) | (((uint32_t)val) << MC_MC_CONTROL_0_RESERVED2_SHIFT))

#define  MC_MC_CONTROL_0_BLOCK_ALL_DATA_REQ_MASK 0x10000
#define  MC_MC_CONTROL_0_BLOCK_ALL_DATA_REQ_SHIFT 16
#define  MC_MC_CONTROL_0_BLOCK_ALL_DATA_REQ_MASK_SHIFT(reg) (((reg) & MC_MC_CONTROL_0_BLOCK_ALL_DATA_REQ_MASK) >> MC_MC_CONTROL_0_BLOCK_ALL_DATA_REQ_SHIFT)
#define  MC_MC_CONTROL_0_BLOCK_ALL_DATA_REQ_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_CONTROL_0_BLOCK_ALL_DATA_REQ_MASK) | (((uint32_t)val) << MC_MC_CONTROL_0_BLOCK_ALL_DATA_REQ_SHIFT))

#define  MC_MC_CONTROL_0_BLOCK_MSTR_DATA_REQ_MASK 0xff00
#define  MC_MC_CONTROL_0_BLOCK_MSTR_DATA_REQ_SHIFT 8
#define  MC_MC_CONTROL_0_BLOCK_MSTR_DATA_REQ_MASK_SHIFT(reg) (((reg) & MC_MC_CONTROL_0_BLOCK_MSTR_DATA_REQ_MASK) >> MC_MC_CONTROL_0_BLOCK_MSTR_DATA_REQ_SHIFT)
#define  MC_MC_CONTROL_0_BLOCK_MSTR_DATA_REQ_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_CONTROL_0_BLOCK_MSTR_DATA_REQ_MASK) | (((uint32_t)val) << MC_MC_CONTROL_0_BLOCK_MSTR_DATA_REQ_SHIFT))

#define  MC_MC_CONTROL_0_RESERVED3_MASK 0x80
#define  MC_MC_CONTROL_0_RESERVED3_SHIFT 7
#define  MC_MC_CONTROL_0_RESERVED3_MASK_SHIFT(reg) (((reg) & MC_MC_CONTROL_0_RESERVED3_MASK) >> MC_MC_CONTROL_0_RESERVED3_SHIFT)
#define  MC_MC_CONTROL_0_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_CONTROL_0_RESERVED3_MASK) | (((uint32_t)val) << MC_MC_CONTROL_0_RESERVED3_SHIFT))

#define  MC_MC_CONTROL_0_ACC_SR_ERR_EN_MASK 0x40
#define  MC_MC_CONTROL_0_ACC_SR_ERR_EN_SHIFT 6
#define  MC_MC_CONTROL_0_ACC_SR_ERR_EN_MASK_SHIFT(reg) (((reg) & MC_MC_CONTROL_0_ACC_SR_ERR_EN_MASK) >> MC_MC_CONTROL_0_ACC_SR_ERR_EN_SHIFT)
#define  MC_MC_CONTROL_0_ACC_SR_ERR_EN_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_CONTROL_0_ACC_SR_ERR_EN_MASK) | (((uint32_t)val) << MC_MC_CONTROL_0_ACC_SR_ERR_EN_SHIFT))

#define  MC_MC_CONTROL_0_TEST_MODE_MASK 0x20
#define  MC_MC_CONTROL_0_TEST_MODE_SHIFT 5
#define  MC_MC_CONTROL_0_TEST_MODE_MASK_SHIFT(reg) (((reg) & MC_MC_CONTROL_0_TEST_MODE_MASK) >> MC_MC_CONTROL_0_TEST_MODE_SHIFT)
#define  MC_MC_CONTROL_0_TEST_MODE_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_CONTROL_0_TEST_MODE_MASK) | (((uint32_t)val) << MC_MC_CONTROL_0_TEST_MODE_SHIFT))

#define  MC_MC_CONTROL_0_WRITE_LEVEL_MODE_MASK 0x10
#define  MC_MC_CONTROL_0_WRITE_LEVEL_MODE_SHIFT 4
#define  MC_MC_CONTROL_0_WRITE_LEVEL_MODE_MASK_SHIFT(reg) (((reg) & MC_MC_CONTROL_0_WRITE_LEVEL_MODE_MASK) >> MC_MC_CONTROL_0_WRITE_LEVEL_MODE_SHIFT)
#define  MC_MC_CONTROL_0_WRITE_LEVEL_MODE_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_CONTROL_0_WRITE_LEVEL_MODE_MASK) | (((uint32_t)val) << MC_MC_CONTROL_0_WRITE_LEVEL_MODE_SHIFT))

#define  MC_MC_CONTROL_0_RESERVED4_MASK 0xc
#define  MC_MC_CONTROL_0_RESERVED4_SHIFT 2
#define  MC_MC_CONTROL_0_RESERVED4_MASK_SHIFT(reg) (((reg) & MC_MC_CONTROL_0_RESERVED4_MASK) >> MC_MC_CONTROL_0_RESERVED4_SHIFT)
#define  MC_MC_CONTROL_0_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_CONTROL_0_RESERVED4_MASK) | (((uint32_t)val) << MC_MC_CONTROL_0_RESERVED4_SHIFT))

#define  MC_MC_CONTROL_0_HALT_SCDLR_MASK 0x2
#define  MC_MC_CONTROL_0_HALT_SCDLR_SHIFT 1
#define  MC_MC_CONTROL_0_HALT_SCDLR_MASK_SHIFT(reg) (((reg) & MC_MC_CONTROL_0_HALT_SCDLR_MASK) >> MC_MC_CONTROL_0_HALT_SCDLR_SHIFT)
#define  MC_MC_CONTROL_0_HALT_SCDLR_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_CONTROL_0_HALT_SCDLR_MASK) | (((uint32_t)val) << MC_MC_CONTROL_0_HALT_SCDLR_SHIFT))

#define  MC_MC_CONTROL_0_DFC_MODE_MASK 0x1
#define  MC_MC_CONTROL_0_DFC_MODE_SHIFT 0
#define  MC_MC_CONTROL_0_DFC_MODE_MASK_SHIFT(reg) (((reg) & MC_MC_CONTROL_0_DFC_MODE_MASK) >> MC_MC_CONTROL_0_DFC_MODE_SHIFT)
#define  MC_MC_CONTROL_0_DFC_MODE_REPLACE_VAL(reg,val) (((reg) & ~MC_MC_CONTROL_0_DFC_MODE_MASK) | (((uint32_t)val) << MC_MC_CONTROL_0_DFC_MODE_SHIFT))

//====================================================================
//Register: Exclusive Monitor Control Register (Exclusive_Monitor)
//====================================================================

#define  MC_EXCLUSIVE_MONITOR_RESERVED1_MASK 0xfff00000
#define  MC_EXCLUSIVE_MONITOR_RESERVED1_SHIFT 20
#define  MC_EXCLUSIVE_MONITOR_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_EXCLUSIVE_MONITOR_RESERVED1_MASK) >> MC_EXCLUSIVE_MONITOR_RESERVED1_SHIFT)
#define  MC_EXCLUSIVE_MONITOR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_EXCLUSIVE_MONITOR_RESERVED1_MASK) | (((uint32_t)val) << MC_EXCLUSIVE_MONITOR_RESERVED1_SHIFT))

#define  MC_EXCLUSIVE_MONITOR_EXCLU_EN_MASK 0xff000
#define  MC_EXCLUSIVE_MONITOR_EXCLU_EN_SHIFT 12
#define  MC_EXCLUSIVE_MONITOR_EXCLU_EN_MASK_SHIFT(reg) (((reg) & MC_EXCLUSIVE_MONITOR_EXCLU_EN_MASK) >> MC_EXCLUSIVE_MONITOR_EXCLU_EN_SHIFT)
#define  MC_EXCLUSIVE_MONITOR_EXCLU_EN_REPLACE_VAL(reg,val) (((reg) & ~MC_EXCLUSIVE_MONITOR_EXCLU_EN_MASK) | (((uint32_t)val) << MC_EXCLUSIVE_MONITOR_EXCLU_EN_SHIFT))

#define  MC_EXCLUSIVE_MONITOR_RESERVED2_MASK 0xfff
#define  MC_EXCLUSIVE_MONITOR_RESERVED2_SHIFT 0
#define  MC_EXCLUSIVE_MONITOR_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_EXCLUSIVE_MONITOR_RESERVED2_MASK) >> MC_EXCLUSIVE_MONITOR_RESERVED2_SHIFT)
#define  MC_EXCLUSIVE_MONITOR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_EXCLUSIVE_MONITOR_RESERVED2_MASK) | (((uint32_t)val) << MC_EXCLUSIVE_MONITOR_RESERVED2_SHIFT))

//====================================================================
//Register: Data Coherency Check Control Register (Coherency)
//====================================================================

#define  MC_COHERENCY_RESERVED1_MASK 0xffffff00
#define  MC_COHERENCY_RESERVED1_SHIFT 8
#define  MC_COHERENCY_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_COHERENCY_RESERVED1_MASK) >> MC_COHERENCY_RESERVED1_SHIFT)
#define  MC_COHERENCY_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_COHERENCY_RESERVED1_MASK) | (((uint32_t)val) << MC_COHERENCY_RESERVED1_SHIFT))

#define  MC_COHERENCY_COHERENCY_CHECK_DISABLE_MASK 0xff
#define  MC_COHERENCY_COHERENCY_CHECK_DISABLE_SHIFT 0
#define  MC_COHERENCY_COHERENCY_CHECK_DISABLE_MASK_SHIFT(reg) (((reg) & MC_COHERENCY_COHERENCY_CHECK_DISABLE_MASK) >> MC_COHERENCY_COHERENCY_CHECK_DISABLE_SHIFT)
#define  MC_COHERENCY_COHERENCY_CHECK_DISABLE_REPLACE_VAL(reg,val) (((reg) & ~MC_COHERENCY_COHERENCY_CHECK_DISABLE_MASK) | (((uint32_t)val) << MC_COHERENCY_COHERENCY_CHECK_DISABLE_SHIFT))

//====================================================================
//Register: Restrict Zone Access Control Register (RZ_access_ctl)
//====================================================================

#define  MC_RZ_ACCESS_CTL_RESERVED1_MASK 0xffffff00
#define  MC_RZ_ACCESS_CTL_RESERVED1_SHIFT 8
#define  MC_RZ_ACCESS_CTL_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_RZ_ACCESS_CTL_RESERVED1_MASK) >> MC_RZ_ACCESS_CTL_RESERVED1_SHIFT)
#define  MC_RZ_ACCESS_CTL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_RZ_ACCESS_CTL_RESERVED1_MASK) | (((uint32_t)val) << MC_RZ_ACCESS_CTL_RESERVED1_SHIFT))

#define  MC_RZ_ACCESS_CTL_RZ_ACCESS_EN_MASK 0xff
#define  MC_RZ_ACCESS_CTL_RZ_ACCESS_EN_SHIFT 0
#define  MC_RZ_ACCESS_CTL_RZ_ACCESS_EN_MASK_SHIFT(reg) (((reg) & MC_RZ_ACCESS_CTL_RZ_ACCESS_EN_MASK) >> MC_RZ_ACCESS_CTL_RZ_ACCESS_EN_SHIFT)
#define  MC_RZ_ACCESS_CTL_RZ_ACCESS_EN_REPLACE_VAL(reg,val) (((reg) & ~MC_RZ_ACCESS_CTL_RZ_ACCESS_EN_MASK) | (((uint32_t)val) << MC_RZ_ACCESS_CTL_RZ_ACCESS_EN_SHIFT))

//====================================================================
//Register: PHY Power Control Register (PHY_pwr_ctl)
//====================================================================

#define  MC_PHY_PWR_CTL_RESERVED1_MASK 0xfffff000
#define  MC_PHY_PWR_CTL_RESERVED1_SHIFT 12
#define  MC_PHY_PWR_CTL_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_PHY_PWR_CTL_RESERVED1_MASK) >> MC_PHY_PWR_CTL_RESERVED1_SHIFT)
#define  MC_PHY_PWR_CTL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_PHY_PWR_CTL_RESERVED1_MASK) | (((uint32_t)val) << MC_PHY_PWR_CTL_RESERVED1_SHIFT))

#define  MC_PHY_PWR_CTL_AC_ON_DLY_MASK 0xf00
#define  MC_PHY_PWR_CTL_AC_ON_DLY_SHIFT 8
#define  MC_PHY_PWR_CTL_AC_ON_DLY_MASK_SHIFT(reg) (((reg) & MC_PHY_PWR_CTL_AC_ON_DLY_MASK) >> MC_PHY_PWR_CTL_AC_ON_DLY_SHIFT)
#define  MC_PHY_PWR_CTL_AC_ON_DLY_REPLACE_VAL(reg,val) (((reg) & ~MC_PHY_PWR_CTL_AC_ON_DLY_MASK) | (((uint32_t)val) << MC_PHY_PWR_CTL_AC_ON_DLY_SHIFT))

#define  MC_PHY_PWR_CTL_AC_OFF_DLY_MASK 0xf0
#define  MC_PHY_PWR_CTL_AC_OFF_DLY_SHIFT 4
#define  MC_PHY_PWR_CTL_AC_OFF_DLY_MASK_SHIFT(reg) (((reg) & MC_PHY_PWR_CTL_AC_OFF_DLY_MASK) >> MC_PHY_PWR_CTL_AC_OFF_DLY_SHIFT)
#define  MC_PHY_PWR_CTL_AC_OFF_DLY_REPLACE_VAL(reg,val) (((reg) & ~MC_PHY_PWR_CTL_AC_OFF_DLY_MASK) | (((uint32_t)val) << MC_PHY_PWR_CTL_AC_OFF_DLY_SHIFT))

#define  MC_PHY_PWR_CTL_RESERVED2_MASK 0xc
#define  MC_PHY_PWR_CTL_RESERVED2_SHIFT 2
#define  MC_PHY_PWR_CTL_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_PHY_PWR_CTL_RESERVED2_MASK) >> MC_PHY_PWR_CTL_RESERVED2_SHIFT)
#define  MC_PHY_PWR_CTL_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_PHY_PWR_CTL_RESERVED2_MASK) | (((uint32_t)val) << MC_PHY_PWR_CTL_RESERVED2_SHIFT))

#define  MC_PHY_PWR_CTL_PHY_CLK_GATING_EN_MASK 0x2
#define  MC_PHY_PWR_CTL_PHY_CLK_GATING_EN_SHIFT 1
#define  MC_PHY_PWR_CTL_PHY_CLK_GATING_EN_MASK_SHIFT(reg) (((reg) & MC_PHY_PWR_CTL_PHY_CLK_GATING_EN_MASK) >> MC_PHY_PWR_CTL_PHY_CLK_GATING_EN_SHIFT)
#define  MC_PHY_PWR_CTL_PHY_CLK_GATING_EN_REPLACE_VAL(reg,val) (((reg) & ~MC_PHY_PWR_CTL_PHY_CLK_GATING_EN_MASK) | (((uint32_t)val) << MC_PHY_PWR_CTL_PHY_CLK_GATING_EN_SHIFT))

#define  MC_PHY_PWR_CTL_PHY_AUTO_AC_OFF_EN_MASK 0x1
#define  MC_PHY_PWR_CTL_PHY_AUTO_AC_OFF_EN_SHIFT 0
#define  MC_PHY_PWR_CTL_PHY_AUTO_AC_OFF_EN_MASK_SHIFT(reg) (((reg) & MC_PHY_PWR_CTL_PHY_AUTO_AC_OFF_EN_MASK) >> MC_PHY_PWR_CTL_PHY_AUTO_AC_OFF_EN_SHIFT)
#define  MC_PHY_PWR_CTL_PHY_AUTO_AC_OFF_EN_REPLACE_VAL(reg,val) (((reg) & ~MC_PHY_PWR_CTL_PHY_AUTO_AC_OFF_EN_MASK) | (((uint32_t)val) << MC_PHY_PWR_CTL_PHY_AUTO_AC_OFF_EN_SHIFT))

//====================================================================
//Register: Bank Queue Control Register (BQ_Control)
//====================================================================

#define  MC_BQ_CONTROL_RESERVED1_MASK 0xfffffffc
#define  MC_BQ_CONTROL_RESERVED1_SHIFT 2
#define  MC_BQ_CONTROL_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_BQ_CONTROL_RESERVED1_MASK) >> MC_BQ_CONTROL_RESERVED1_SHIFT)
#define  MC_BQ_CONTROL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_BQ_CONTROL_RESERVED1_MASK) | (((uint32_t)val) << MC_BQ_CONTROL_RESERVED1_SHIFT))

#define  MC_BQ_CONTROL_BQ_DEPTH_MASK 0x3
#define  MC_BQ_CONTROL_BQ_DEPTH_SHIFT 0
#define  MC_BQ_CONTROL_BQ_DEPTH_MASK_SHIFT(reg) (((reg) & MC_BQ_CONTROL_BQ_DEPTH_MASK) >> MC_BQ_CONTROL_BQ_DEPTH_SHIFT)
#define  MC_BQ_CONTROL_BQ_DEPTH_REPLACE_VAL(reg,val) (((reg) & ~MC_BQ_CONTROL_BQ_DEPTH_MASK) | (((uint32_t)val) << MC_BQ_CONTROL_BQ_DEPTH_SHIFT))

//====================================================================
//Register: ROB Control Register (ROB_Control)
//====================================================================

#define  MC_ROB_CONTROL_RESERVED1_MASK 0xfffffffc
#define  MC_ROB_CONTROL_RESERVED1_SHIFT 2
#define  MC_ROB_CONTROL_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_ROB_CONTROL_RESERVED1_MASK) >> MC_ROB_CONTROL_RESERVED1_SHIFT)
#define  MC_ROB_CONTROL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_ROB_CONTROL_RESERVED1_MASK) | (((uint32_t)val) << MC_ROB_CONTROL_RESERVED1_SHIFT))

#define  MC_ROB_CONTROL_ROB_DATA_INTERLEAVING_DIS_MASK 0x2
#define  MC_ROB_CONTROL_ROB_DATA_INTERLEAVING_DIS_SHIFT 1
#define  MC_ROB_CONTROL_ROB_DATA_INTERLEAVING_DIS_MASK_SHIFT(reg) (((reg) & MC_ROB_CONTROL_ROB_DATA_INTERLEAVING_DIS_MASK) >> MC_ROB_CONTROL_ROB_DATA_INTERLEAVING_DIS_SHIFT)
#define  MC_ROB_CONTROL_ROB_DATA_INTERLEAVING_DIS_REPLACE_VAL(reg,val) (((reg) & ~MC_ROB_CONTROL_ROB_DATA_INTERLEAVING_DIS_MASK) | (((uint32_t)val) << MC_ROB_CONTROL_ROB_DATA_INTERLEAVING_DIS_SHIFT))

#define  MC_ROB_CONTROL_ROB_DELAY_READ_EN_MASK 0x1
#define  MC_ROB_CONTROL_ROB_DELAY_READ_EN_SHIFT 0
#define  MC_ROB_CONTROL_ROB_DELAY_READ_EN_MASK_SHIFT(reg) (((reg) & MC_ROB_CONTROL_ROB_DELAY_READ_EN_MASK) >> MC_ROB_CONTROL_ROB_DELAY_READ_EN_SHIFT)
#define  MC_ROB_CONTROL_ROB_DELAY_READ_EN_REPLACE_VAL(reg,val) (((reg) & ~MC_ROB_CONTROL_ROB_DELAY_READ_EN_MASK) | (((uint32_t)val) << MC_ROB_CONTROL_ROB_DELAY_READ_EN_SHIFT))

//====================================================================
//Register: Port RRB Weight Register (Port_Weight)
//====================================================================

#define  MC_PORT_WEIGHT_WEIGHT_P7_MASK 0xf0000000
#define  MC_PORT_WEIGHT_WEIGHT_P7_SHIFT 28
#define  MC_PORT_WEIGHT_WEIGHT_P7_MASK_SHIFT(reg) (((reg) & MC_PORT_WEIGHT_WEIGHT_P7_MASK) >> MC_PORT_WEIGHT_WEIGHT_P7_SHIFT)
#define  MC_PORT_WEIGHT_WEIGHT_P7_REPLACE_VAL(reg,val) (((reg) & ~MC_PORT_WEIGHT_WEIGHT_P7_MASK) | (((uint32_t)val) << MC_PORT_WEIGHT_WEIGHT_P7_SHIFT))

#define  MC_PORT_WEIGHT_WEIGHT_P6_MASK 0xf000000
#define  MC_PORT_WEIGHT_WEIGHT_P6_SHIFT 24
#define  MC_PORT_WEIGHT_WEIGHT_P6_MASK_SHIFT(reg) (((reg) & MC_PORT_WEIGHT_WEIGHT_P6_MASK) >> MC_PORT_WEIGHT_WEIGHT_P6_SHIFT)
#define  MC_PORT_WEIGHT_WEIGHT_P6_REPLACE_VAL(reg,val) (((reg) & ~MC_PORT_WEIGHT_WEIGHT_P6_MASK) | (((uint32_t)val) << MC_PORT_WEIGHT_WEIGHT_P6_SHIFT))

#define  MC_PORT_WEIGHT_WEIGHT_P5_MASK 0xf00000
#define  MC_PORT_WEIGHT_WEIGHT_P5_SHIFT 20
#define  MC_PORT_WEIGHT_WEIGHT_P5_MASK_SHIFT(reg) (((reg) & MC_PORT_WEIGHT_WEIGHT_P5_MASK) >> MC_PORT_WEIGHT_WEIGHT_P5_SHIFT)
#define  MC_PORT_WEIGHT_WEIGHT_P5_REPLACE_VAL(reg,val) (((reg) & ~MC_PORT_WEIGHT_WEIGHT_P5_MASK) | (((uint32_t)val) << MC_PORT_WEIGHT_WEIGHT_P5_SHIFT))

#define  MC_PORT_WEIGHT_WEIGHT_P4_MASK 0xf0000
#define  MC_PORT_WEIGHT_WEIGHT_P4_SHIFT 16
#define  MC_PORT_WEIGHT_WEIGHT_P4_MASK_SHIFT(reg) (((reg) & MC_PORT_WEIGHT_WEIGHT_P4_MASK) >> MC_PORT_WEIGHT_WEIGHT_P4_SHIFT)
#define  MC_PORT_WEIGHT_WEIGHT_P4_REPLACE_VAL(reg,val) (((reg) & ~MC_PORT_WEIGHT_WEIGHT_P4_MASK) | (((uint32_t)val) << MC_PORT_WEIGHT_WEIGHT_P4_SHIFT))

#define  MC_PORT_WEIGHT_WEIGHT_P3_MASK 0xf000
#define  MC_PORT_WEIGHT_WEIGHT_P3_SHIFT 12
#define  MC_PORT_WEIGHT_WEIGHT_P3_MASK_SHIFT(reg) (((reg) & MC_PORT_WEIGHT_WEIGHT_P3_MASK) >> MC_PORT_WEIGHT_WEIGHT_P3_SHIFT)
#define  MC_PORT_WEIGHT_WEIGHT_P3_REPLACE_VAL(reg,val) (((reg) & ~MC_PORT_WEIGHT_WEIGHT_P3_MASK) | (((uint32_t)val) << MC_PORT_WEIGHT_WEIGHT_P3_SHIFT))

#define  MC_PORT_WEIGHT_WEIGHT_P2_MASK 0xf00
#define  MC_PORT_WEIGHT_WEIGHT_P2_SHIFT 8
#define  MC_PORT_WEIGHT_WEIGHT_P2_MASK_SHIFT(reg) (((reg) & MC_PORT_WEIGHT_WEIGHT_P2_MASK) >> MC_PORT_WEIGHT_WEIGHT_P2_SHIFT)
#define  MC_PORT_WEIGHT_WEIGHT_P2_REPLACE_VAL(reg,val) (((reg) & ~MC_PORT_WEIGHT_WEIGHT_P2_MASK) | (((uint32_t)val) << MC_PORT_WEIGHT_WEIGHT_P2_SHIFT))

#define  MC_PORT_WEIGHT_WEIGHT_P1_MASK 0xf0
#define  MC_PORT_WEIGHT_WEIGHT_P1_SHIFT 4
#define  MC_PORT_WEIGHT_WEIGHT_P1_MASK_SHIFT(reg) (((reg) & MC_PORT_WEIGHT_WEIGHT_P1_MASK) >> MC_PORT_WEIGHT_WEIGHT_P1_SHIFT)
#define  MC_PORT_WEIGHT_WEIGHT_P1_REPLACE_VAL(reg,val) (((reg) & ~MC_PORT_WEIGHT_WEIGHT_P1_MASK) | (((uint32_t)val) << MC_PORT_WEIGHT_WEIGHT_P1_SHIFT))

#define  MC_PORT_WEIGHT_WEIGHT_P0_MASK 0xf
#define  MC_PORT_WEIGHT_WEIGHT_P0_SHIFT 0
#define  MC_PORT_WEIGHT_WEIGHT_P0_MASK_SHIFT(reg) (((reg) & MC_PORT_WEIGHT_WEIGHT_P0_MASK) >> MC_PORT_WEIGHT_WEIGHT_P0_SHIFT)
#define  MC_PORT_WEIGHT_WEIGHT_P0_REPLACE_VAL(reg,val) (((reg) & ~MC_PORT_WEIGHT_WEIGHT_P0_MASK) | (((uint32_t)val) << MC_PORT_WEIGHT_WEIGHT_P0_SHIFT))

//====================================================================
//Register: Port Priority Control Register (Port_priority)
//====================================================================

#define  MC_PORT_PRIORITY_PORT_PRIORITY_EN_MASK 0xff000000
#define  MC_PORT_PRIORITY_PORT_PRIORITY_EN_SHIFT 24
#define  MC_PORT_PRIORITY_PORT_PRIORITY_EN_MASK_SHIFT(reg) (((reg) & MC_PORT_PRIORITY_PORT_PRIORITY_EN_MASK) >> MC_PORT_PRIORITY_PORT_PRIORITY_EN_SHIFT)
#define  MC_PORT_PRIORITY_PORT_PRIORITY_EN_REPLACE_VAL(reg,val) (((reg) & ~MC_PORT_PRIORITY_PORT_PRIORITY_EN_MASK) | (((uint32_t)val) << MC_PORT_PRIORITY_PORT_PRIORITY_EN_SHIFT))

#define  MC_PORT_PRIORITY_RESERVED1_MASK 0xff0000
#define  MC_PORT_PRIORITY_RESERVED1_SHIFT 16
#define  MC_PORT_PRIORITY_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_PORT_PRIORITY_RESERVED1_MASK) >> MC_PORT_PRIORITY_RESERVED1_SHIFT)
#define  MC_PORT_PRIORITY_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_PORT_PRIORITY_RESERVED1_MASK) | (((uint32_t)val) << MC_PORT_PRIORITY_RESERVED1_SHIFT))

#define  MC_PORT_PRIORITY_PRIORITY_P7_MASK 0xc000
#define  MC_PORT_PRIORITY_PRIORITY_P7_SHIFT 14
#define  MC_PORT_PRIORITY_PRIORITY_P7_MASK_SHIFT(reg) (((reg) & MC_PORT_PRIORITY_PRIORITY_P7_MASK) >> MC_PORT_PRIORITY_PRIORITY_P7_SHIFT)
#define  MC_PORT_PRIORITY_PRIORITY_P7_REPLACE_VAL(reg,val) (((reg) & ~MC_PORT_PRIORITY_PRIORITY_P7_MASK) | (((uint32_t)val) << MC_PORT_PRIORITY_PRIORITY_P7_SHIFT))

#define  MC_PORT_PRIORITY_PRIORITY_P6_MASK 0x3000
#define  MC_PORT_PRIORITY_PRIORITY_P6_SHIFT 12
#define  MC_PORT_PRIORITY_PRIORITY_P6_MASK_SHIFT(reg) (((reg) & MC_PORT_PRIORITY_PRIORITY_P6_MASK) >> MC_PORT_PRIORITY_PRIORITY_P6_SHIFT)
#define  MC_PORT_PRIORITY_PRIORITY_P6_REPLACE_VAL(reg,val) (((reg) & ~MC_PORT_PRIORITY_PRIORITY_P6_MASK) | (((uint32_t)val) << MC_PORT_PRIORITY_PRIORITY_P6_SHIFT))

#define  MC_PORT_PRIORITY_PRIORITY_P5_MASK 0xc00
#define  MC_PORT_PRIORITY_PRIORITY_P5_SHIFT 10
#define  MC_PORT_PRIORITY_PRIORITY_P5_MASK_SHIFT(reg) (((reg) & MC_PORT_PRIORITY_PRIORITY_P5_MASK) >> MC_PORT_PRIORITY_PRIORITY_P5_SHIFT)
#define  MC_PORT_PRIORITY_PRIORITY_P5_REPLACE_VAL(reg,val) (((reg) & ~MC_PORT_PRIORITY_PRIORITY_P5_MASK) | (((uint32_t)val) << MC_PORT_PRIORITY_PRIORITY_P5_SHIFT))

#define  MC_PORT_PRIORITY_PRIORITY_P4_MASK 0x300
#define  MC_PORT_PRIORITY_PRIORITY_P4_SHIFT 8
#define  MC_PORT_PRIORITY_PRIORITY_P4_MASK_SHIFT(reg) (((reg) & MC_PORT_PRIORITY_PRIORITY_P4_MASK) >> MC_PORT_PRIORITY_PRIORITY_P4_SHIFT)
#define  MC_PORT_PRIORITY_PRIORITY_P4_REPLACE_VAL(reg,val) (((reg) & ~MC_PORT_PRIORITY_PRIORITY_P4_MASK) | (((uint32_t)val) << MC_PORT_PRIORITY_PRIORITY_P4_SHIFT))

#define  MC_PORT_PRIORITY_PRIORITY_P3_MASK 0xc0
#define  MC_PORT_PRIORITY_PRIORITY_P3_SHIFT 6
#define  MC_PORT_PRIORITY_PRIORITY_P3_MASK_SHIFT(reg) (((reg) & MC_PORT_PRIORITY_PRIORITY_P3_MASK) >> MC_PORT_PRIORITY_PRIORITY_P3_SHIFT)
#define  MC_PORT_PRIORITY_PRIORITY_P3_REPLACE_VAL(reg,val) (((reg) & ~MC_PORT_PRIORITY_PRIORITY_P3_MASK) | (((uint32_t)val) << MC_PORT_PRIORITY_PRIORITY_P3_SHIFT))

#define  MC_PORT_PRIORITY_PRIORITY_P2_MASK 0x30
#define  MC_PORT_PRIORITY_PRIORITY_P2_SHIFT 4
#define  MC_PORT_PRIORITY_PRIORITY_P2_MASK_SHIFT(reg) (((reg) & MC_PORT_PRIORITY_PRIORITY_P2_MASK) >> MC_PORT_PRIORITY_PRIORITY_P2_SHIFT)
#define  MC_PORT_PRIORITY_PRIORITY_P2_REPLACE_VAL(reg,val) (((reg) & ~MC_PORT_PRIORITY_PRIORITY_P2_MASK) | (((uint32_t)val) << MC_PORT_PRIORITY_PRIORITY_P2_SHIFT))

#define  MC_PORT_PRIORITY_PRIORITY_P1_MASK 0xc
#define  MC_PORT_PRIORITY_PRIORITY_P1_SHIFT 2
#define  MC_PORT_PRIORITY_PRIORITY_P1_MASK_SHIFT(reg) (((reg) & MC_PORT_PRIORITY_PRIORITY_P1_MASK) >> MC_PORT_PRIORITY_PRIORITY_P1_SHIFT)
#define  MC_PORT_PRIORITY_PRIORITY_P1_REPLACE_VAL(reg,val) (((reg) & ~MC_PORT_PRIORITY_PRIORITY_P1_MASK) | (((uint32_t)val) << MC_PORT_PRIORITY_PRIORITY_P1_SHIFT))

#define  MC_PORT_PRIORITY_PRIORITY_P0_MASK 0x3
#define  MC_PORT_PRIORITY_PRIORITY_P0_SHIFT 0
#define  MC_PORT_PRIORITY_PRIORITY_P0_MASK_SHIFT(reg) (((reg) & MC_PORT_PRIORITY_PRIORITY_P0_MASK) >> MC_PORT_PRIORITY_PRIORITY_P0_SHIFT)
#define  MC_PORT_PRIORITY_PRIORITY_P0_REPLACE_VAL(reg,val) (((reg) & ~MC_PORT_PRIORITY_PRIORITY_P0_MASK) | (((uint32_t)val) << MC_PORT_PRIORITY_PRIORITY_P0_SHIFT))

//====================================================================
//Register: RRB Starvation Prevention Register 0 (RRB_Starvation_0)
//====================================================================

#define  MC_RRB_STARVATION_0_RRB_STARV_P3_MASK 0xff000000
#define  MC_RRB_STARVATION_0_RRB_STARV_P3_SHIFT 24
#define  MC_RRB_STARVATION_0_RRB_STARV_P3_MASK_SHIFT(reg) (((reg) & MC_RRB_STARVATION_0_RRB_STARV_P3_MASK) >> MC_RRB_STARVATION_0_RRB_STARV_P3_SHIFT)
#define  MC_RRB_STARVATION_0_RRB_STARV_P3_REPLACE_VAL(reg,val) (((reg) & ~MC_RRB_STARVATION_0_RRB_STARV_P3_MASK) | (((uint32_t)val) << MC_RRB_STARVATION_0_RRB_STARV_P3_SHIFT))

#define  MC_RRB_STARVATION_0_RRB_STARV_P2_MASK 0xff0000
#define  MC_RRB_STARVATION_0_RRB_STARV_P2_SHIFT 16
#define  MC_RRB_STARVATION_0_RRB_STARV_P2_MASK_SHIFT(reg) (((reg) & MC_RRB_STARVATION_0_RRB_STARV_P2_MASK) >> MC_RRB_STARVATION_0_RRB_STARV_P2_SHIFT)
#define  MC_RRB_STARVATION_0_RRB_STARV_P2_REPLACE_VAL(reg,val) (((reg) & ~MC_RRB_STARVATION_0_RRB_STARV_P2_MASK) | (((uint32_t)val) << MC_RRB_STARVATION_0_RRB_STARV_P2_SHIFT))

#define  MC_RRB_STARVATION_0_RRB_STARV_P1_MASK 0xff00
#define  MC_RRB_STARVATION_0_RRB_STARV_P1_SHIFT 8
#define  MC_RRB_STARVATION_0_RRB_STARV_P1_MASK_SHIFT(reg) (((reg) & MC_RRB_STARVATION_0_RRB_STARV_P1_MASK) >> MC_RRB_STARVATION_0_RRB_STARV_P1_SHIFT)
#define  MC_RRB_STARVATION_0_RRB_STARV_P1_REPLACE_VAL(reg,val) (((reg) & ~MC_RRB_STARVATION_0_RRB_STARV_P1_MASK) | (((uint32_t)val) << MC_RRB_STARVATION_0_RRB_STARV_P1_SHIFT))

#define  MC_RRB_STARVATION_0_RRB_STARV_P0_MASK 0xff
#define  MC_RRB_STARVATION_0_RRB_STARV_P0_SHIFT 0
#define  MC_RRB_STARVATION_0_RRB_STARV_P0_MASK_SHIFT(reg) (((reg) & MC_RRB_STARVATION_0_RRB_STARV_P0_MASK) >> MC_RRB_STARVATION_0_RRB_STARV_P0_SHIFT)
#define  MC_RRB_STARVATION_0_RRB_STARV_P0_REPLACE_VAL(reg,val) (((reg) & ~MC_RRB_STARVATION_0_RRB_STARV_P0_MASK) | (((uint32_t)val) << MC_RRB_STARVATION_0_RRB_STARV_P0_SHIFT))

//====================================================================
//Register: RRB Starvation Prevention Register 1 (RRB_Starvation_1)
//====================================================================

#define  MC_RRB_STARVATION_1_RRB_STARV_P7_MASK 0xff000000
#define  MC_RRB_STARVATION_1_RRB_STARV_P7_SHIFT 24
#define  MC_RRB_STARVATION_1_RRB_STARV_P7_MASK_SHIFT(reg) (((reg) & MC_RRB_STARVATION_1_RRB_STARV_P7_MASK) >> MC_RRB_STARVATION_1_RRB_STARV_P7_SHIFT)
#define  MC_RRB_STARVATION_1_RRB_STARV_P7_REPLACE_VAL(reg,val) (((reg) & ~MC_RRB_STARVATION_1_RRB_STARV_P7_MASK) | (((uint32_t)val) << MC_RRB_STARVATION_1_RRB_STARV_P7_SHIFT))

#define  MC_RRB_STARVATION_1_RRB_STARV_P6_MASK 0xff0000
#define  MC_RRB_STARVATION_1_RRB_STARV_P6_SHIFT 16
#define  MC_RRB_STARVATION_1_RRB_STARV_P6_MASK_SHIFT(reg) (((reg) & MC_RRB_STARVATION_1_RRB_STARV_P6_MASK) >> MC_RRB_STARVATION_1_RRB_STARV_P6_SHIFT)
#define  MC_RRB_STARVATION_1_RRB_STARV_P6_REPLACE_VAL(reg,val) (((reg) & ~MC_RRB_STARVATION_1_RRB_STARV_P6_MASK) | (((uint32_t)val) << MC_RRB_STARVATION_1_RRB_STARV_P6_SHIFT))

#define  MC_RRB_STARVATION_1_RRB_STARV_P5_MASK 0xff00
#define  MC_RRB_STARVATION_1_RRB_STARV_P5_SHIFT 8
#define  MC_RRB_STARVATION_1_RRB_STARV_P5_MASK_SHIFT(reg) (((reg) & MC_RRB_STARVATION_1_RRB_STARV_P5_MASK) >> MC_RRB_STARVATION_1_RRB_STARV_P5_SHIFT)
#define  MC_RRB_STARVATION_1_RRB_STARV_P5_REPLACE_VAL(reg,val) (((reg) & ~MC_RRB_STARVATION_1_RRB_STARV_P5_MASK) | (((uint32_t)val) << MC_RRB_STARVATION_1_RRB_STARV_P5_SHIFT))

#define  MC_RRB_STARVATION_1_RRB_STARV_P4_MASK 0xff
#define  MC_RRB_STARVATION_1_RRB_STARV_P4_SHIFT 0
#define  MC_RRB_STARVATION_1_RRB_STARV_P4_MASK_SHIFT(reg) (((reg) & MC_RRB_STARVATION_1_RRB_STARV_P4_MASK) >> MC_RRB_STARVATION_1_RRB_STARV_P4_SHIFT)
#define  MC_RRB_STARVATION_1_RRB_STARV_P4_REPLACE_VAL(reg,val) (((reg) & ~MC_RRB_STARVATION_1_RRB_STARV_P4_MASK) | (((uint32_t)val) << MC_RRB_STARVATION_1_RRB_STARV_P4_SHIFT))

//====================================================================
//Register: Register Table Control Register (RegTable_Control)
//====================================================================

#define  MC_REGTABLE_CONTROL_RESERVED1_MASK 0xfffffc00
#define  MC_REGTABLE_CONTROL_RESERVED1_SHIFT 10
#define  MC_REGTABLE_CONTROL_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_REGTABLE_CONTROL_RESERVED1_MASK) >> MC_REGTABLE_CONTROL_RESERVED1_SHIFT)
#define  MC_REGTABLE_CONTROL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_REGTABLE_CONTROL_RESERVED1_MASK) | (((uint32_t)val) << MC_REGTABLE_CONTROL_RESERVED1_SHIFT))

#define  MC_REGTABLE_CONTROL_REGTABLE_SEL_MASK 0x3e0
#define  MC_REGTABLE_CONTROL_REGTABLE_SEL_SHIFT 5
#define  MC_REGTABLE_CONTROL_REGTABLE_SEL_MASK_SHIFT(reg) (((reg) & MC_REGTABLE_CONTROL_REGTABLE_SEL_MASK) >> MC_REGTABLE_CONTROL_REGTABLE_SEL_SHIFT)
#define  MC_REGTABLE_CONTROL_REGTABLE_SEL_REPLACE_VAL(reg,val) (((reg) & ~MC_REGTABLE_CONTROL_REGTABLE_SEL_MASK) | (((uint32_t)val) << MC_REGTABLE_CONTROL_REGTABLE_SEL_SHIFT))

#define  MC_REGTABLE_CONTROL_REGTABLE_ADDR_MASK 0x1f
#define  MC_REGTABLE_CONTROL_REGTABLE_ADDR_SHIFT 0
#define  MC_REGTABLE_CONTROL_REGTABLE_ADDR_MASK_SHIFT(reg) (((reg) & MC_REGTABLE_CONTROL_REGTABLE_ADDR_MASK) >> MC_REGTABLE_CONTROL_REGTABLE_ADDR_SHIFT)
#define  MC_REGTABLE_CONTROL_REGTABLE_ADDR_REPLACE_VAL(reg,val) (((reg) & ~MC_REGTABLE_CONTROL_REGTABLE_ADDR_MASK) | (((uint32_t)val) << MC_REGTABLE_CONTROL_REGTABLE_ADDR_SHIFT))

//====================================================================
//Register: Register Table Data Register 0 (RegTable_Data_0)
//====================================================================

#define  MC_REGTABLE_DATA_0_REGTABLE_REG_DATA_MASK 0xffffffff
#define  MC_REGTABLE_DATA_0_REGTABLE_REG_DATA_SHIFT 0
#define  MC_REGTABLE_DATA_0_REGTABLE_REG_DATA_MASK_SHIFT(reg) (((reg) & MC_REGTABLE_DATA_0_REGTABLE_REG_DATA_MASK) >> MC_REGTABLE_DATA_0_REGTABLE_REG_DATA_SHIFT)
#define  MC_REGTABLE_DATA_0_REGTABLE_REG_DATA_REPLACE_VAL(reg,val) (((reg) & ~MC_REGTABLE_DATA_0_REGTABLE_REG_DATA_MASK) | (((uint32_t)val) << MC_REGTABLE_DATA_0_REGTABLE_REG_DATA_SHIFT))

//====================================================================
//Register: Register Table Data Register 1 (RegTable_Data_1)
//====================================================================

#define  MC_REGTABLE_DATA_1_RESERVED1_MASK 0xfffc0000
#define  MC_REGTABLE_DATA_1_RESERVED1_SHIFT 18
#define  MC_REGTABLE_DATA_1_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_REGTABLE_DATA_1_RESERVED1_MASK) >> MC_REGTABLE_DATA_1_RESERVED1_SHIFT)
#define  MC_REGTABLE_DATA_1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_REGTABLE_DATA_1_RESERVED1_MASK) | (((uint32_t)val) << MC_REGTABLE_DATA_1_RESERVED1_SHIFT))

#define  MC_REGTABLE_DATA_1_REGTABLE_EOP_MASK 0x20000
#define  MC_REGTABLE_DATA_1_REGTABLE_EOP_SHIFT 17
#define  MC_REGTABLE_DATA_1_REGTABLE_EOP_MASK_SHIFT(reg) (((reg) & MC_REGTABLE_DATA_1_REGTABLE_EOP_MASK) >> MC_REGTABLE_DATA_1_REGTABLE_EOP_SHIFT)
#define  MC_REGTABLE_DATA_1_REGTABLE_EOP_REPLACE_VAL(reg,val) (((reg) & ~MC_REGTABLE_DATA_1_REGTABLE_EOP_MASK) | (((uint32_t)val) << MC_REGTABLE_DATA_1_REGTABLE_EOP_SHIFT))

#define  MC_REGTABLE_DATA_1_REGTABLE_PAUSE_MASK 0x10000
#define  MC_REGTABLE_DATA_1_REGTABLE_PAUSE_SHIFT 16
#define  MC_REGTABLE_DATA_1_REGTABLE_PAUSE_MASK_SHIFT(reg) (((reg) & MC_REGTABLE_DATA_1_REGTABLE_PAUSE_MASK) >> MC_REGTABLE_DATA_1_REGTABLE_PAUSE_SHIFT)
#define  MC_REGTABLE_DATA_1_REGTABLE_PAUSE_REPLACE_VAL(reg,val) (((reg) & ~MC_REGTABLE_DATA_1_REGTABLE_PAUSE_MASK) | (((uint32_t)val) << MC_REGTABLE_DATA_1_REGTABLE_PAUSE_SHIFT))

#define  MC_REGTABLE_DATA_1_RESERVED2_MASK 0xf000
#define  MC_REGTABLE_DATA_1_RESERVED2_SHIFT 12
#define  MC_REGTABLE_DATA_1_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_REGTABLE_DATA_1_RESERVED2_MASK) >> MC_REGTABLE_DATA_1_RESERVED2_SHIFT)
#define  MC_REGTABLE_DATA_1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_REGTABLE_DATA_1_RESERVED2_MASK) | (((uint32_t)val) << MC_REGTABLE_DATA_1_RESERVED2_SHIFT))

#define  MC_REGTABLE_DATA_1_REGTABLE_REG_OFFSET_MASK 0xfff
#define  MC_REGTABLE_DATA_1_REGTABLE_REG_OFFSET_SHIFT 0
#define  MC_REGTABLE_DATA_1_REGTABLE_REG_OFFSET_MASK_SHIFT(reg) (((reg) & MC_REGTABLE_DATA_1_REGTABLE_REG_OFFSET_MASK) >> MC_REGTABLE_DATA_1_REGTABLE_REG_OFFSET_SHIFT)
#define  MC_REGTABLE_DATA_1_REGTABLE_REG_OFFSET_REPLACE_VAL(reg,val) (((reg) & ~MC_REGTABLE_DATA_1_REGTABLE_REG_OFFSET_MASK) | (((uint32_t)val) << MC_REGTABLE_DATA_1_REGTABLE_REG_OFFSET_SHIFT))

//====================================================================
//Register: Performance Counter Configuration Register 0 (PC_config0)
//====================================================================

#define  MC_PC_CONFIG0_PC_REG_EN3_MASK 0x80000000
#define  MC_PC_CONFIG0_PC_REG_EN3_SHIFT 31
#define  MC_PC_CONFIG0_PC_REG_EN3_MASK_SHIFT(reg) (((reg) & MC_PC_CONFIG0_PC_REG_EN3_MASK) >> MC_PC_CONFIG0_PC_REG_EN3_SHIFT)
#define  MC_PC_CONFIG0_PC_REG_EN3_REPLACE_VAL(reg,val) (((reg) & ~MC_PC_CONFIG0_PC_REG_EN3_MASK) | (((uint32_t)val) << MC_PC_CONFIG0_PC_REG_EN3_SHIFT))

#define  MC_PC_CONFIG0_RESERVED1_MASK 0x40000000
#define  MC_PC_CONFIG0_RESERVED1_SHIFT 30
#define  MC_PC_CONFIG0_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_PC_CONFIG0_RESERVED1_MASK) >> MC_PC_CONFIG0_RESERVED1_SHIFT)
#define  MC_PC_CONFIG0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_PC_CONFIG0_RESERVED1_MASK) | (((uint32_t)val) << MC_PC_CONFIG0_RESERVED1_SHIFT))

#define  MC_PC_CONFIG0_PC_EVENT_SEL3_MASK 0x3f000000
#define  MC_PC_CONFIG0_PC_EVENT_SEL3_SHIFT 24
#define  MC_PC_CONFIG0_PC_EVENT_SEL3_MASK_SHIFT(reg) (((reg) & MC_PC_CONFIG0_PC_EVENT_SEL3_MASK) >> MC_PC_CONFIG0_PC_EVENT_SEL3_SHIFT)
#define  MC_PC_CONFIG0_PC_EVENT_SEL3_REPLACE_VAL(reg,val) (((reg) & ~MC_PC_CONFIG0_PC_EVENT_SEL3_MASK) | (((uint32_t)val) << MC_PC_CONFIG0_PC_EVENT_SEL3_SHIFT))

#define  MC_PC_CONFIG0_PC_REG_EN2_MASK 0x800000
#define  MC_PC_CONFIG0_PC_REG_EN2_SHIFT 23
#define  MC_PC_CONFIG0_PC_REG_EN2_MASK_SHIFT(reg) (((reg) & MC_PC_CONFIG0_PC_REG_EN2_MASK) >> MC_PC_CONFIG0_PC_REG_EN2_SHIFT)
#define  MC_PC_CONFIG0_PC_REG_EN2_REPLACE_VAL(reg,val) (((reg) & ~MC_PC_CONFIG0_PC_REG_EN2_MASK) | (((uint32_t)val) << MC_PC_CONFIG0_PC_REG_EN2_SHIFT))

#define  MC_PC_CONFIG0_RESERVED2_MASK 0x400000
#define  MC_PC_CONFIG0_RESERVED2_SHIFT 22
#define  MC_PC_CONFIG0_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_PC_CONFIG0_RESERVED2_MASK) >> MC_PC_CONFIG0_RESERVED2_SHIFT)
#define  MC_PC_CONFIG0_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_PC_CONFIG0_RESERVED2_MASK) | (((uint32_t)val) << MC_PC_CONFIG0_RESERVED2_SHIFT))

#define  MC_PC_CONFIG0_PC_EVENT_SEL2_MASK 0x3f0000
#define  MC_PC_CONFIG0_PC_EVENT_SEL2_SHIFT 16
#define  MC_PC_CONFIG0_PC_EVENT_SEL2_MASK_SHIFT(reg) (((reg) & MC_PC_CONFIG0_PC_EVENT_SEL2_MASK) >> MC_PC_CONFIG0_PC_EVENT_SEL2_SHIFT)
#define  MC_PC_CONFIG0_PC_EVENT_SEL2_REPLACE_VAL(reg,val) (((reg) & ~MC_PC_CONFIG0_PC_EVENT_SEL2_MASK) | (((uint32_t)val) << MC_PC_CONFIG0_PC_EVENT_SEL2_SHIFT))

#define  MC_PC_CONFIG0_PC_REG_EN1_MASK 0x8000
#define  MC_PC_CONFIG0_PC_REG_EN1_SHIFT 15
#define  MC_PC_CONFIG0_PC_REG_EN1_MASK_SHIFT(reg) (((reg) & MC_PC_CONFIG0_PC_REG_EN1_MASK) >> MC_PC_CONFIG0_PC_REG_EN1_SHIFT)
#define  MC_PC_CONFIG0_PC_REG_EN1_REPLACE_VAL(reg,val) (((reg) & ~MC_PC_CONFIG0_PC_REG_EN1_MASK) | (((uint32_t)val) << MC_PC_CONFIG0_PC_REG_EN1_SHIFT))

#define  MC_PC_CONFIG0_RESERVED3_MASK 0x4000
#define  MC_PC_CONFIG0_RESERVED3_SHIFT 14
#define  MC_PC_CONFIG0_RESERVED3_MASK_SHIFT(reg) (((reg) & MC_PC_CONFIG0_RESERVED3_MASK) >> MC_PC_CONFIG0_RESERVED3_SHIFT)
#define  MC_PC_CONFIG0_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~MC_PC_CONFIG0_RESERVED3_MASK) | (((uint32_t)val) << MC_PC_CONFIG0_RESERVED3_SHIFT))

#define  MC_PC_CONFIG0_PC_EVENT_SEL1_MASK 0x3f00
#define  MC_PC_CONFIG0_PC_EVENT_SEL1_SHIFT 8
#define  MC_PC_CONFIG0_PC_EVENT_SEL1_MASK_SHIFT(reg) (((reg) & MC_PC_CONFIG0_PC_EVENT_SEL1_MASK) >> MC_PC_CONFIG0_PC_EVENT_SEL1_SHIFT)
#define  MC_PC_CONFIG0_PC_EVENT_SEL1_REPLACE_VAL(reg,val) (((reg) & ~MC_PC_CONFIG0_PC_EVENT_SEL1_MASK) | (((uint32_t)val) << MC_PC_CONFIG0_PC_EVENT_SEL1_SHIFT))

#define  MC_PC_CONFIG0_PC_REG_EN0_MASK 0x80
#define  MC_PC_CONFIG0_PC_REG_EN0_SHIFT 7
#define  MC_PC_CONFIG0_PC_REG_EN0_MASK_SHIFT(reg) (((reg) & MC_PC_CONFIG0_PC_REG_EN0_MASK) >> MC_PC_CONFIG0_PC_REG_EN0_SHIFT)
#define  MC_PC_CONFIG0_PC_REG_EN0_REPLACE_VAL(reg,val) (((reg) & ~MC_PC_CONFIG0_PC_REG_EN0_MASK) | (((uint32_t)val) << MC_PC_CONFIG0_PC_REG_EN0_SHIFT))

#define  MC_PC_CONFIG0_RESERVED4_MASK 0x40
#define  MC_PC_CONFIG0_RESERVED4_SHIFT 6
#define  MC_PC_CONFIG0_RESERVED4_MASK_SHIFT(reg) (((reg) & MC_PC_CONFIG0_RESERVED4_MASK) >> MC_PC_CONFIG0_RESERVED4_SHIFT)
#define  MC_PC_CONFIG0_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~MC_PC_CONFIG0_RESERVED4_MASK) | (((uint32_t)val) << MC_PC_CONFIG0_RESERVED4_SHIFT))

#define  MC_PC_CONFIG0_PC_EVENT_SEL0_MASK 0x3f
#define  MC_PC_CONFIG0_PC_EVENT_SEL0_SHIFT 0
#define  MC_PC_CONFIG0_PC_EVENT_SEL0_MASK_SHIFT(reg) (((reg) & MC_PC_CONFIG0_PC_EVENT_SEL0_MASK) >> MC_PC_CONFIG0_PC_EVENT_SEL0_SHIFT)
#define  MC_PC_CONFIG0_PC_EVENT_SEL0_REPLACE_VAL(reg,val) (((reg) & ~MC_PC_CONFIG0_PC_EVENT_SEL0_MASK) | (((uint32_t)val) << MC_PC_CONFIG0_PC_EVENT_SEL0_SHIFT))

//====================================================================
//Register: Performance Counter Configuration Register 1 (PC_config1)
//====================================================================

#define  MC_PC_CONFIG1_PC_REG_EN7_MASK 0x80000000
#define  MC_PC_CONFIG1_PC_REG_EN7_SHIFT 31
#define  MC_PC_CONFIG1_PC_REG_EN7_MASK_SHIFT(reg) (((reg) & MC_PC_CONFIG1_PC_REG_EN7_MASK) >> MC_PC_CONFIG1_PC_REG_EN7_SHIFT)
#define  MC_PC_CONFIG1_PC_REG_EN7_REPLACE_VAL(reg,val) (((reg) & ~MC_PC_CONFIG1_PC_REG_EN7_MASK) | (((uint32_t)val) << MC_PC_CONFIG1_PC_REG_EN7_SHIFT))

#define  MC_PC_CONFIG1_RESERVED1_MASK 0x40000000
#define  MC_PC_CONFIG1_RESERVED1_SHIFT 30
#define  MC_PC_CONFIG1_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_PC_CONFIG1_RESERVED1_MASK) >> MC_PC_CONFIG1_RESERVED1_SHIFT)
#define  MC_PC_CONFIG1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_PC_CONFIG1_RESERVED1_MASK) | (((uint32_t)val) << MC_PC_CONFIG1_RESERVED1_SHIFT))

#define  MC_PC_CONFIG1_PC_EVENT_SEL7_MASK 0x3f000000
#define  MC_PC_CONFIG1_PC_EVENT_SEL7_SHIFT 24
#define  MC_PC_CONFIG1_PC_EVENT_SEL7_MASK_SHIFT(reg) (((reg) & MC_PC_CONFIG1_PC_EVENT_SEL7_MASK) >> MC_PC_CONFIG1_PC_EVENT_SEL7_SHIFT)
#define  MC_PC_CONFIG1_PC_EVENT_SEL7_REPLACE_VAL(reg,val) (((reg) & ~MC_PC_CONFIG1_PC_EVENT_SEL7_MASK) | (((uint32_t)val) << MC_PC_CONFIG1_PC_EVENT_SEL7_SHIFT))

#define  MC_PC_CONFIG1_PC_REG_EN6_MASK 0x800000
#define  MC_PC_CONFIG1_PC_REG_EN6_SHIFT 23
#define  MC_PC_CONFIG1_PC_REG_EN6_MASK_SHIFT(reg) (((reg) & MC_PC_CONFIG1_PC_REG_EN6_MASK) >> MC_PC_CONFIG1_PC_REG_EN6_SHIFT)
#define  MC_PC_CONFIG1_PC_REG_EN6_REPLACE_VAL(reg,val) (((reg) & ~MC_PC_CONFIG1_PC_REG_EN6_MASK) | (((uint32_t)val) << MC_PC_CONFIG1_PC_REG_EN6_SHIFT))

#define  MC_PC_CONFIG1_RESERVED2_MASK 0x400000
#define  MC_PC_CONFIG1_RESERVED2_SHIFT 22
#define  MC_PC_CONFIG1_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_PC_CONFIG1_RESERVED2_MASK) >> MC_PC_CONFIG1_RESERVED2_SHIFT)
#define  MC_PC_CONFIG1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_PC_CONFIG1_RESERVED2_MASK) | (((uint32_t)val) << MC_PC_CONFIG1_RESERVED2_SHIFT))

#define  MC_PC_CONFIG1_PC_EVENT_SEL6_MASK 0x3f0000
#define  MC_PC_CONFIG1_PC_EVENT_SEL6_SHIFT 16
#define  MC_PC_CONFIG1_PC_EVENT_SEL6_MASK_SHIFT(reg) (((reg) & MC_PC_CONFIG1_PC_EVENT_SEL6_MASK) >> MC_PC_CONFIG1_PC_EVENT_SEL6_SHIFT)
#define  MC_PC_CONFIG1_PC_EVENT_SEL6_REPLACE_VAL(reg,val) (((reg) & ~MC_PC_CONFIG1_PC_EVENT_SEL6_MASK) | (((uint32_t)val) << MC_PC_CONFIG1_PC_EVENT_SEL6_SHIFT))

#define  MC_PC_CONFIG1_PC_REG_EN5_MASK 0x8000
#define  MC_PC_CONFIG1_PC_REG_EN5_SHIFT 15
#define  MC_PC_CONFIG1_PC_REG_EN5_MASK_SHIFT(reg) (((reg) & MC_PC_CONFIG1_PC_REG_EN5_MASK) >> MC_PC_CONFIG1_PC_REG_EN5_SHIFT)
#define  MC_PC_CONFIG1_PC_REG_EN5_REPLACE_VAL(reg,val) (((reg) & ~MC_PC_CONFIG1_PC_REG_EN5_MASK) | (((uint32_t)val) << MC_PC_CONFIG1_PC_REG_EN5_SHIFT))

#define  MC_PC_CONFIG1_RESERVED3_MASK 0x4000
#define  MC_PC_CONFIG1_RESERVED3_SHIFT 14
#define  MC_PC_CONFIG1_RESERVED3_MASK_SHIFT(reg) (((reg) & MC_PC_CONFIG1_RESERVED3_MASK) >> MC_PC_CONFIG1_RESERVED3_SHIFT)
#define  MC_PC_CONFIG1_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~MC_PC_CONFIG1_RESERVED3_MASK) | (((uint32_t)val) << MC_PC_CONFIG1_RESERVED3_SHIFT))

#define  MC_PC_CONFIG1_PC_EVENT_SEL5_MASK 0x3f00
#define  MC_PC_CONFIG1_PC_EVENT_SEL5_SHIFT 8
#define  MC_PC_CONFIG1_PC_EVENT_SEL5_MASK_SHIFT(reg) (((reg) & MC_PC_CONFIG1_PC_EVENT_SEL5_MASK) >> MC_PC_CONFIG1_PC_EVENT_SEL5_SHIFT)
#define  MC_PC_CONFIG1_PC_EVENT_SEL5_REPLACE_VAL(reg,val) (((reg) & ~MC_PC_CONFIG1_PC_EVENT_SEL5_MASK) | (((uint32_t)val) << MC_PC_CONFIG1_PC_EVENT_SEL5_SHIFT))

#define  MC_PC_CONFIG1_PC_REG_EN4_MASK 0x80
#define  MC_PC_CONFIG1_PC_REG_EN4_SHIFT 7
#define  MC_PC_CONFIG1_PC_REG_EN4_MASK_SHIFT(reg) (((reg) & MC_PC_CONFIG1_PC_REG_EN4_MASK) >> MC_PC_CONFIG1_PC_REG_EN4_SHIFT)
#define  MC_PC_CONFIG1_PC_REG_EN4_REPLACE_VAL(reg,val) (((reg) & ~MC_PC_CONFIG1_PC_REG_EN4_MASK) | (((uint32_t)val) << MC_PC_CONFIG1_PC_REG_EN4_SHIFT))

#define  MC_PC_CONFIG1_RESERVED4_MASK 0x40
#define  MC_PC_CONFIG1_RESERVED4_SHIFT 6
#define  MC_PC_CONFIG1_RESERVED4_MASK_SHIFT(reg) (((reg) & MC_PC_CONFIG1_RESERVED4_MASK) >> MC_PC_CONFIG1_RESERVED4_SHIFT)
#define  MC_PC_CONFIG1_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~MC_PC_CONFIG1_RESERVED4_MASK) | (((uint32_t)val) << MC_PC_CONFIG1_RESERVED4_SHIFT))

#define  MC_PC_CONFIG1_PC_EVENT_SEL4_MASK 0x3f
#define  MC_PC_CONFIG1_PC_EVENT_SEL4_SHIFT 0
#define  MC_PC_CONFIG1_PC_EVENT_SEL4_MASK_SHIFT(reg) (((reg) & MC_PC_CONFIG1_PC_EVENT_SEL4_MASK) >> MC_PC_CONFIG1_PC_EVENT_SEL4_SHIFT)
#define  MC_PC_CONFIG1_PC_EVENT_SEL4_REPLACE_VAL(reg,val) (((reg) & ~MC_PC_CONFIG1_PC_EVENT_SEL4_MASK) | (((uint32_t)val) << MC_PC_CONFIG1_PC_EVENT_SEL4_SHIFT))

//====================================================================
//Register: Performance Counter Status Register (PC_status)
//====================================================================

#define  MC_PC_STATUS_RESERVED1_MASK 0xffffff00
#define  MC_PC_STATUS_RESERVED1_SHIFT 8
#define  MC_PC_STATUS_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_PC_STATUS_RESERVED1_MASK) >> MC_PC_STATUS_RESERVED1_SHIFT)
#define  MC_PC_STATUS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_PC_STATUS_RESERVED1_MASK) | (((uint32_t)val) << MC_PC_STATUS_RESERVED1_SHIFT))

#define  MC_PC_STATUS_PC_OVERFLOW_MASK 0xff
#define  MC_PC_STATUS_PC_OVERFLOW_SHIFT 0
#define  MC_PC_STATUS_PC_OVERFLOW_MASK_SHIFT(reg) (((reg) & MC_PC_STATUS_PC_OVERFLOW_MASK) >> MC_PC_STATUS_PC_OVERFLOW_SHIFT)
#define  MC_PC_STATUS_PC_OVERFLOW_REPLACE_VAL(reg,val) (((reg) & ~MC_PC_STATUS_PC_OVERFLOW_MASK) | (((uint32_t)val) << MC_PC_STATUS_PC_OVERFLOW_SHIFT))

//====================================================================
//Register: Performance Counter Control Register (PC_Control)
//====================================================================

#define  MC_PC_CONTROL_RESERVED1_MASK 0xfff80000
#define  MC_PC_CONTROL_RESERVED1_SHIFT 19
#define  MC_PC_CONTROL_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_PC_CONTROL_RESERVED1_MASK) >> MC_PC_CONTROL_RESERVED1_SHIFT)
#define  MC_PC_CONTROL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_PC_CONTROL_RESERVED1_MASK) | (((uint32_t)val) << MC_PC_CONTROL_RESERVED1_SHIFT))

#define  MC_PC_CONTROL_PC_CLK_DIV_MASK 0x70000
#define  MC_PC_CONTROL_PC_CLK_DIV_SHIFT 16
#define  MC_PC_CONTROL_PC_CLK_DIV_MASK_SHIFT(reg) (((reg) & MC_PC_CONTROL_PC_CLK_DIV_MASK) >> MC_PC_CONTROL_PC_CLK_DIV_SHIFT)
#define  MC_PC_CONTROL_PC_CLK_DIV_REPLACE_VAL(reg,val) (((reg) & ~MC_PC_CONTROL_PC_CLK_DIV_MASK) | (((uint32_t)val) << MC_PC_CONTROL_PC_CLK_DIV_SHIFT))

#define  MC_PC_CONTROL_RESERVED2_MASK 0xffe0
#define  MC_PC_CONTROL_RESERVED2_SHIFT 5
#define  MC_PC_CONTROL_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_PC_CONTROL_RESERVED2_MASK) >> MC_PC_CONTROL_RESERVED2_SHIFT)
#define  MC_PC_CONTROL_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_PC_CONTROL_RESERVED2_MASK) | (((uint32_t)val) << MC_PC_CONTROL_RESERVED2_SHIFT))

#define  MC_PC_CONTROL_PC_STOP_COND_MASK 0x10
#define  MC_PC_CONTROL_PC_STOP_COND_SHIFT 4
#define  MC_PC_CONTROL_PC_STOP_COND_MASK_SHIFT(reg) (((reg) & MC_PC_CONTROL_PC_STOP_COND_MASK) >> MC_PC_CONTROL_PC_STOP_COND_SHIFT)
#define  MC_PC_CONTROL_PC_STOP_COND_REPLACE_VAL(reg,val) (((reg) & ~MC_PC_CONTROL_PC_STOP_COND_MASK) | (((uint32_t)val) << MC_PC_CONTROL_PC_STOP_COND_SHIFT))

#define  MC_PC_CONTROL_RESERVED3_MASK 0xe
#define  MC_PC_CONTROL_RESERVED3_SHIFT 1
#define  MC_PC_CONTROL_RESERVED3_MASK_SHIFT(reg) (((reg) & MC_PC_CONTROL_RESERVED3_MASK) >> MC_PC_CONTROL_RESERVED3_SHIFT)
#define  MC_PC_CONTROL_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~MC_PC_CONTROL_RESERVED3_MASK) | (((uint32_t)val) << MC_PC_CONTROL_RESERVED3_SHIFT))

#define  MC_PC_CONTROL_PC_START_COND_MASK 0x1
#define  MC_PC_CONTROL_PC_START_COND_SHIFT 0
#define  MC_PC_CONTROL_PC_START_COND_MASK_SHIFT(reg) (((reg) & MC_PC_CONTROL_PC_START_COND_MASK) >> MC_PC_CONTROL_PC_START_COND_SHIFT)
#define  MC_PC_CONTROL_PC_START_COND_REPLACE_VAL(reg,val) (((reg) & ~MC_PC_CONTROL_PC_START_COND_MASK) | (((uint32_t)val) << MC_PC_CONTROL_PC_START_COND_SHIFT))

//====================================================================
//Register: Performance Counter Register (PC0)
//====================================================================

#define  MC_PC0_PC_COUNTER_MASK 0xffffffff
#define  MC_PC0_PC_COUNTER_SHIFT 0
#define  MC_PC0_PC_COUNTER_MASK_SHIFT(reg) (((reg) & MC_PC0_PC_COUNTER_MASK) >> MC_PC0_PC_COUNTER_SHIFT)
#define  MC_PC0_PC_COUNTER_REPLACE_VAL(reg,val) (((reg) & ~MC_PC0_PC_COUNTER_MASK) | (((uint32_t)val) << MC_PC0_PC_COUNTER_SHIFT))

//====================================================================
//Register: Performance Counter Register (PC1)
//====================================================================

#define  MC_PC1_PC_COUNTER_MASK 0xffffffff
#define  MC_PC1_PC_COUNTER_SHIFT 0
#define  MC_PC1_PC_COUNTER_MASK_SHIFT(reg) (((reg) & MC_PC1_PC_COUNTER_MASK) >> MC_PC1_PC_COUNTER_SHIFT)
#define  MC_PC1_PC_COUNTER_REPLACE_VAL(reg,val) (((reg) & ~MC_PC1_PC_COUNTER_MASK) | (((uint32_t)val) << MC_PC1_PC_COUNTER_SHIFT))

//====================================================================
//Register: Performance Counter Register (PC2)
//====================================================================

#define  MC_PC2_PC_COUNTER_MASK 0xffffffff
#define  MC_PC2_PC_COUNTER_SHIFT 0
#define  MC_PC2_PC_COUNTER_MASK_SHIFT(reg) (((reg) & MC_PC2_PC_COUNTER_MASK) >> MC_PC2_PC_COUNTER_SHIFT)
#define  MC_PC2_PC_COUNTER_REPLACE_VAL(reg,val) (((reg) & ~MC_PC2_PC_COUNTER_MASK) | (((uint32_t)val) << MC_PC2_PC_COUNTER_SHIFT))

//====================================================================
//Register: Performance Counter Register (PC3)
//====================================================================

#define  MC_PC3_PC_COUNTER_MASK 0xffffffff
#define  MC_PC3_PC_COUNTER_SHIFT 0
#define  MC_PC3_PC_COUNTER_MASK_SHIFT(reg) (((reg) & MC_PC3_PC_COUNTER_MASK) >> MC_PC3_PC_COUNTER_SHIFT)
#define  MC_PC3_PC_COUNTER_REPLACE_VAL(reg,val) (((reg) & ~MC_PC3_PC_COUNTER_MASK) | (((uint32_t)val) << MC_PC3_PC_COUNTER_SHIFT))

//====================================================================
//Register: Performance Counter Register (PC4)
//====================================================================

#define  MC_PC4_PC_COUNTER_MASK 0xffffffff
#define  MC_PC4_PC_COUNTER_SHIFT 0
#define  MC_PC4_PC_COUNTER_MASK_SHIFT(reg) (((reg) & MC_PC4_PC_COUNTER_MASK) >> MC_PC4_PC_COUNTER_SHIFT)
#define  MC_PC4_PC_COUNTER_REPLACE_VAL(reg,val) (((reg) & ~MC_PC4_PC_COUNTER_MASK) | (((uint32_t)val) << MC_PC4_PC_COUNTER_SHIFT))

//====================================================================
//Register: Performance Counter Register (PC5)
//====================================================================

#define  MC_PC5_PC_COUNTER_MASK 0xffffffff
#define  MC_PC5_PC_COUNTER_SHIFT 0
#define  MC_PC5_PC_COUNTER_MASK_SHIFT(reg) (((reg) & MC_PC5_PC_COUNTER_MASK) >> MC_PC5_PC_COUNTER_SHIFT)
#define  MC_PC5_PC_COUNTER_REPLACE_VAL(reg,val) (((reg) & ~MC_PC5_PC_COUNTER_MASK) | (((uint32_t)val) << MC_PC5_PC_COUNTER_SHIFT))

//====================================================================
//Register: Performance Counter Register (PC6)
//====================================================================

#define  MC_PC6_PC_COUNTER_MASK 0xffffffff
#define  MC_PC6_PC_COUNTER_SHIFT 0
#define  MC_PC6_PC_COUNTER_MASK_SHIFT(reg) (((reg) & MC_PC6_PC_COUNTER_MASK) >> MC_PC6_PC_COUNTER_SHIFT)
#define  MC_PC6_PC_COUNTER_REPLACE_VAL(reg,val) (((reg) & ~MC_PC6_PC_COUNTER_MASK) | (((uint32_t)val) << MC_PC6_PC_COUNTER_SHIFT))

//====================================================================
//Register: Performance Counter Register (PC7)
//====================================================================

#define  MC_PC7_PC_COUNTER_MASK 0xffffffff
#define  MC_PC7_PC_COUNTER_SHIFT 0
#define  MC_PC7_PC_COUNTER_MASK_SHIFT(reg) (((reg) & MC_PC7_PC_COUNTER_MASK) >> MC_PC7_PC_COUNTER_SHIFT)
#define  MC_PC7_PC_COUNTER_REPLACE_VAL(reg,val) (((reg) & ~MC_PC7_PC_COUNTER_MASK) | (((uint32_t)val) << MC_PC7_PC_COUNTER_SHIFT))

//====================================================================
//Register: Interrupt Status Register (ISR)
//====================================================================

#define  MC_ISR_RESERVED1_MASK 0xffffffc0
#define  MC_ISR_RESERVED1_SHIFT 6
#define  MC_ISR_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_ISR_RESERVED1_MASK) >> MC_ISR_RESERVED1_SHIFT)
#define  MC_ISR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_ISR_RESERVED1_MASK) | (((uint32_t)val) << MC_ISR_RESERVED1_SHIFT))

#define  MC_ISR_TZ_INT_MASK 0x20
#define  MC_ISR_TZ_INT_SHIFT 5
#define  MC_ISR_TZ_INT_MASK_SHIFT(reg) (((reg) & MC_ISR_TZ_INT_MASK) >> MC_ISR_TZ_INT_SHIFT)
#define  MC_ISR_TZ_INT_REPLACE_VAL(reg,val) (((reg) & ~MC_ISR_TZ_INT_MASK) | (((uint32_t)val) << MC_ISR_TZ_INT_SHIFT))

#define  MC_ISR_AM_HIGH_INT_MASK 0x10
#define  MC_ISR_AM_HIGH_INT_SHIFT 4
#define  MC_ISR_AM_HIGH_INT_MASK_SHIFT(reg) (((reg) & MC_ISR_AM_HIGH_INT_MASK) >> MC_ISR_AM_HIGH_INT_SHIFT)
#define  MC_ISR_AM_HIGH_INT_REPLACE_VAL(reg,val) (((reg) & ~MC_ISR_AM_HIGH_INT_MASK) | (((uint32_t)val) << MC_ISR_AM_HIGH_INT_SHIFT))

#define  MC_ISR_AM_LOW_INT_MASK 0x8
#define  MC_ISR_AM_LOW_INT_SHIFT 3
#define  MC_ISR_AM_LOW_INT_MASK_SHIFT(reg) (((reg) & MC_ISR_AM_LOW_INT_MASK) >> MC_ISR_AM_LOW_INT_SHIFT)
#define  MC_ISR_AM_LOW_INT_REPLACE_VAL(reg,val) (((reg) & ~MC_ISR_AM_LOW_INT_MASK) | (((uint32_t)val) << MC_ISR_AM_LOW_INT_SHIFT))

#define  MC_ISR_ADC_INT_MASK 0x4
#define  MC_ISR_ADC_INT_SHIFT 2
#define  MC_ISR_ADC_INT_MASK_SHIFT(reg) (((reg) & MC_ISR_ADC_INT_MASK) >> MC_ISR_ADC_INT_SHIFT)
#define  MC_ISR_ADC_INT_REPLACE_VAL(reg,val) (((reg) & ~MC_ISR_ADC_INT_MASK) | (((uint32_t)val) << MC_ISR_ADC_INT_SHIFT))

#define  MC_ISR_RESERVED2_MASK 0x2
#define  MC_ISR_RESERVED2_SHIFT 1
#define  MC_ISR_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_ISR_RESERVED2_MASK) >> MC_ISR_RESERVED2_SHIFT)
#define  MC_ISR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_ISR_RESERVED2_MASK) | (((uint32_t)val) << MC_ISR_RESERVED2_SHIFT))

#define  MC_ISR_PC_INT_MASK 0x1
#define  MC_ISR_PC_INT_SHIFT 0
#define  MC_ISR_PC_INT_MASK_SHIFT(reg) (((reg) & MC_ISR_PC_INT_MASK) >> MC_ISR_PC_INT_SHIFT)
#define  MC_ISR_PC_INT_REPLACE_VAL(reg,val) (((reg) & ~MC_ISR_PC_INT_MASK) | (((uint32_t)val) << MC_ISR_PC_INT_SHIFT))

//====================================================================
//Register: Interrupt Enable Register (IER)
//====================================================================

#define  MC_IER_RESERVED1_MASK 0xffffffc0
#define  MC_IER_RESERVED1_SHIFT 6
#define  MC_IER_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_IER_RESERVED1_MASK) >> MC_IER_RESERVED1_SHIFT)
#define  MC_IER_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_IER_RESERVED1_MASK) | (((uint32_t)val) << MC_IER_RESERVED1_SHIFT))

#define  MC_IER_TZ_INT_EN_MASK 0x20
#define  MC_IER_TZ_INT_EN_SHIFT 5
#define  MC_IER_TZ_INT_EN_MASK_SHIFT(reg) (((reg) & MC_IER_TZ_INT_EN_MASK) >> MC_IER_TZ_INT_EN_SHIFT)
#define  MC_IER_TZ_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~MC_IER_TZ_INT_EN_MASK) | (((uint32_t)val) << MC_IER_TZ_INT_EN_SHIFT))

#define  MC_IER_RESERVED2_MASK 0x10
#define  MC_IER_RESERVED2_SHIFT 4
#define  MC_IER_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_IER_RESERVED2_MASK) >> MC_IER_RESERVED2_SHIFT)
#define  MC_IER_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_IER_RESERVED2_MASK) | (((uint32_t)val) << MC_IER_RESERVED2_SHIFT))

#define  MC_IER_AM_INT_EN_MASK 0x8
#define  MC_IER_AM_INT_EN_SHIFT 3
#define  MC_IER_AM_INT_EN_MASK_SHIFT(reg) (((reg) & MC_IER_AM_INT_EN_MASK) >> MC_IER_AM_INT_EN_SHIFT)
#define  MC_IER_AM_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~MC_IER_AM_INT_EN_MASK) | (((uint32_t)val) << MC_IER_AM_INT_EN_SHIFT))

#define  MC_IER_ADC_INT_EN_MASK 0x4
#define  MC_IER_ADC_INT_EN_SHIFT 2
#define  MC_IER_ADC_INT_EN_MASK_SHIFT(reg) (((reg) & MC_IER_ADC_INT_EN_MASK) >> MC_IER_ADC_INT_EN_SHIFT)
#define  MC_IER_ADC_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~MC_IER_ADC_INT_EN_MASK) | (((uint32_t)val) << MC_IER_ADC_INT_EN_SHIFT))

#define  MC_IER_RESERVED3_MASK 0x2
#define  MC_IER_RESERVED3_SHIFT 1
#define  MC_IER_RESERVED3_MASK_SHIFT(reg) (((reg) & MC_IER_RESERVED3_MASK) >> MC_IER_RESERVED3_SHIFT)
#define  MC_IER_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~MC_IER_RESERVED3_MASK) | (((uint32_t)val) << MC_IER_RESERVED3_SHIFT))

#define  MC_IER_PC_INT_EN_MASK 0x1
#define  MC_IER_PC_INT_EN_SHIFT 0
#define  MC_IER_PC_INT_EN_MASK_SHIFT(reg) (((reg) & MC_IER_PC_INT_EN_MASK) >> MC_IER_PC_INT_EN_SHIFT)
#define  MC_IER_PC_INT_EN_REPLACE_VAL(reg,val) (((reg) & ~MC_IER_PC_INT_EN_MASK) | (((uint32_t)val) << MC_IER_PC_INT_EN_SHIFT))

//====================================================================
//Register: Address Decode Error Master ID Register (ADC_ERR_ID)
//====================================================================

#define  MC_ADC_ERR_ID_ERR_TRANS_TYPE_MASK 0x80000000
#define  MC_ADC_ERR_ID_ERR_TRANS_TYPE_SHIFT 31
#define  MC_ADC_ERR_ID_ERR_TRANS_TYPE_MASK_SHIFT(reg) (((reg) & MC_ADC_ERR_ID_ERR_TRANS_TYPE_MASK) >> MC_ADC_ERR_ID_ERR_TRANS_TYPE_SHIFT)
#define  MC_ADC_ERR_ID_ERR_TRANS_TYPE_REPLACE_VAL(reg,val) (((reg) & ~MC_ADC_ERR_ID_ERR_TRANS_TYPE_MASK) | (((uint32_t)val) << MC_ADC_ERR_ID_ERR_TRANS_TYPE_SHIFT))

#define  MC_ADC_ERR_ID_ERR_MSTR_ID_MASK 0x70000000
#define  MC_ADC_ERR_ID_ERR_MSTR_ID_SHIFT 28
#define  MC_ADC_ERR_ID_ERR_MSTR_ID_MASK_SHIFT(reg) (((reg) & MC_ADC_ERR_ID_ERR_MSTR_ID_MASK) >> MC_ADC_ERR_ID_ERR_MSTR_ID_SHIFT)
#define  MC_ADC_ERR_ID_ERR_MSTR_ID_REPLACE_VAL(reg,val) (((reg) & ~MC_ADC_ERR_ID_ERR_MSTR_ID_MASK) | (((uint32_t)val) << MC_ADC_ERR_ID_ERR_MSTR_ID_SHIFT))

#define  MC_ADC_ERR_ID_ERR_TRANS_ID_MASK 0xfffffff
#define  MC_ADC_ERR_ID_ERR_TRANS_ID_SHIFT 0
#define  MC_ADC_ERR_ID_ERR_TRANS_ID_MASK_SHIFT(reg) (((reg) & MC_ADC_ERR_ID_ERR_TRANS_ID_MASK) >> MC_ADC_ERR_ID_ERR_TRANS_ID_SHIFT)
#define  MC_ADC_ERR_ID_ERR_TRANS_ID_REPLACE_VAL(reg,val) (((reg) & ~MC_ADC_ERR_ID_ERR_TRANS_ID_MASK) | (((uint32_t)val) << MC_ADC_ERR_ID_ERR_TRANS_ID_SHIFT))

//====================================================================
//Register: Address Decode Error Lower Address Register (ADC_ERR_ADR_L)
//====================================================================

#define  MC_ADC_ERR_ADR_L_ERR_ADR_L_MASK 0xffffffff
#define  MC_ADC_ERR_ADR_L_ERR_ADR_L_SHIFT 0
#define  MC_ADC_ERR_ADR_L_ERR_ADR_L_MASK_SHIFT(reg) (((reg) & MC_ADC_ERR_ADR_L_ERR_ADR_L_MASK) >> MC_ADC_ERR_ADR_L_ERR_ADR_L_SHIFT)
#define  MC_ADC_ERR_ADR_L_ERR_ADR_L_REPLACE_VAL(reg,val) (((reg) & ~MC_ADC_ERR_ADR_L_ERR_ADR_L_MASK) | (((uint32_t)val) << MC_ADC_ERR_ADR_L_ERR_ADR_L_SHIFT))

//====================================================================
//Register: Address Decode Error Higher Address Register (ADC_ERR_ADR_H)
//====================================================================

#define  MC_ADC_ERR_ADR_H_RESERVED1_MASK 0xffffff00
#define  MC_ADC_ERR_ADR_H_RESERVED1_SHIFT 8
#define  MC_ADC_ERR_ADR_H_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_ADC_ERR_ADR_H_RESERVED1_MASK) >> MC_ADC_ERR_ADR_H_RESERVED1_SHIFT)
#define  MC_ADC_ERR_ADR_H_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_ADC_ERR_ADR_H_RESERVED1_MASK) | (((uint32_t)val) << MC_ADC_ERR_ADR_H_RESERVED1_SHIFT))

#define  MC_ADC_ERR_ADR_H_ERR_ADR_H_MASK 0xff
#define  MC_ADC_ERR_ADR_H_ERR_ADR_H_SHIFT 0
#define  MC_ADC_ERR_ADR_H_ERR_ADR_H_MASK_SHIFT(reg) (((reg) & MC_ADC_ERR_ADR_H_ERR_ADR_H_MASK) >> MC_ADC_ERR_ADR_H_ERR_ADR_H_SHIFT)
#define  MC_ADC_ERR_ADR_H_ERR_ADR_H_REPLACE_VAL(reg,val) (((reg) & ~MC_ADC_ERR_ADR_H_ERR_ADR_H_MASK) | (((uint32_t)val) << MC_ADC_ERR_ADR_H_ERR_ADR_H_SHIFT))

//====================================================================
//Register: Activity Monitor Check Period Register (AM_PERIOD)
//====================================================================

#define  MC_AM_PERIOD_AM_PERIOD_MASK 0xffffffff
#define  MC_AM_PERIOD_AM_PERIOD_SHIFT 0
#define  MC_AM_PERIOD_AM_PERIOD_MASK_SHIFT(reg) (((reg) & MC_AM_PERIOD_AM_PERIOD_MASK) >> MC_AM_PERIOD_AM_PERIOD_SHIFT)
#define  MC_AM_PERIOD_AM_PERIOD_REPLACE_VAL(reg,val) (((reg) & ~MC_AM_PERIOD_AM_PERIOD_MASK) | (((uint32_t)val) << MC_AM_PERIOD_AM_PERIOD_SHIFT))

//====================================================================
//Register: Activity Monitor Threshold Register (AM_TH)
//====================================================================

#define  MC_AM_TH_RESERVED1_MASK 0xffff8000
#define  MC_AM_TH_RESERVED1_SHIFT 15
#define  MC_AM_TH_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_AM_TH_RESERVED1_MASK) >> MC_AM_TH_RESERVED1_SHIFT)
#define  MC_AM_TH_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_AM_TH_RESERVED1_MASK) | (((uint32_t)val) << MC_AM_TH_RESERVED1_SHIFT))

#define  MC_AM_TH_AM_TH_HIGH_MASK 0x7f00
#define  MC_AM_TH_AM_TH_HIGH_SHIFT 8
#define  MC_AM_TH_AM_TH_HIGH_MASK_SHIFT(reg) (((reg) & MC_AM_TH_AM_TH_HIGH_MASK) >> MC_AM_TH_AM_TH_HIGH_SHIFT)
#define  MC_AM_TH_AM_TH_HIGH_REPLACE_VAL(reg,val) (((reg) & ~MC_AM_TH_AM_TH_HIGH_MASK) | (((uint32_t)val) << MC_AM_TH_AM_TH_HIGH_SHIFT))

#define  MC_AM_TH_RESERVED2_MASK 0x80
#define  MC_AM_TH_RESERVED2_SHIFT 7
#define  MC_AM_TH_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_AM_TH_RESERVED2_MASK) >> MC_AM_TH_RESERVED2_SHIFT)
#define  MC_AM_TH_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_AM_TH_RESERVED2_MASK) | (((uint32_t)val) << MC_AM_TH_RESERVED2_SHIFT))

#define  MC_AM_TH_AM_TH_LOW_MASK 0x7f
#define  MC_AM_TH_AM_TH_LOW_SHIFT 0
#define  MC_AM_TH_AM_TH_LOW_MASK_SHIFT(reg) (((reg) & MC_AM_TH_AM_TH_LOW_MASK) >> MC_AM_TH_AM_TH_LOW_SHIFT)
#define  MC_AM_TH_AM_TH_LOW_REPLACE_VAL(reg,val) (((reg) & ~MC_AM_TH_AM_TH_LOW_MASK) | (((uint32_t)val) << MC_AM_TH_AM_TH_LOW_SHIFT))

//====================================================================
//Register: TrustZone Error Master ID Register (TZ_ERR_ID)
//====================================================================

#define  MC_TZ_ERR_ID_ERR_TRANS_TYPE_MASK 0x80000000
#define  MC_TZ_ERR_ID_ERR_TRANS_TYPE_SHIFT 31
#define  MC_TZ_ERR_ID_ERR_TRANS_TYPE_MASK_SHIFT(reg) (((reg) & MC_TZ_ERR_ID_ERR_TRANS_TYPE_MASK) >> MC_TZ_ERR_ID_ERR_TRANS_TYPE_SHIFT)
#define  MC_TZ_ERR_ID_ERR_TRANS_TYPE_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_ERR_ID_ERR_TRANS_TYPE_MASK) | (((uint32_t)val) << MC_TZ_ERR_ID_ERR_TRANS_TYPE_SHIFT))

#define  MC_TZ_ERR_ID_ERR_MSTR_ID_MASK 0x70000000
#define  MC_TZ_ERR_ID_ERR_MSTR_ID_SHIFT 28
#define  MC_TZ_ERR_ID_ERR_MSTR_ID_MASK_SHIFT(reg) (((reg) & MC_TZ_ERR_ID_ERR_MSTR_ID_MASK) >> MC_TZ_ERR_ID_ERR_MSTR_ID_SHIFT)
#define  MC_TZ_ERR_ID_ERR_MSTR_ID_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_ERR_ID_ERR_MSTR_ID_MASK) | (((uint32_t)val) << MC_TZ_ERR_ID_ERR_MSTR_ID_SHIFT))

#define  MC_TZ_ERR_ID_ERR_TRANS_ID_MASK 0xfffffff
#define  MC_TZ_ERR_ID_ERR_TRANS_ID_SHIFT 0
#define  MC_TZ_ERR_ID_ERR_TRANS_ID_MASK_SHIFT(reg) (((reg) & MC_TZ_ERR_ID_ERR_TRANS_ID_MASK) >> MC_TZ_ERR_ID_ERR_TRANS_ID_SHIFT)
#define  MC_TZ_ERR_ID_ERR_TRANS_ID_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_ERR_ID_ERR_TRANS_ID_MASK) | (((uint32_t)val) << MC_TZ_ERR_ID_ERR_TRANS_ID_SHIFT))

//====================================================================
//Register: TrustZone Error Lower Address Register (TZ_ERR_ADR_L)
//====================================================================

#define  MC_TZ_ERR_ADR_L_ERR_ADR_L_MASK 0xffffffff
#define  MC_TZ_ERR_ADR_L_ERR_ADR_L_SHIFT 0
#define  MC_TZ_ERR_ADR_L_ERR_ADR_L_MASK_SHIFT(reg) (((reg) & MC_TZ_ERR_ADR_L_ERR_ADR_L_MASK) >> MC_TZ_ERR_ADR_L_ERR_ADR_L_SHIFT)
#define  MC_TZ_ERR_ADR_L_ERR_ADR_L_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_ERR_ADR_L_ERR_ADR_L_MASK) | (((uint32_t)val) << MC_TZ_ERR_ADR_L_ERR_ADR_L_SHIFT))

//====================================================================
//Register: TrustZone Error Higher Address Register (TZ_ERR_ADR_H)
//====================================================================

#define  MC_TZ_ERR_ADR_H_RESERVED1_MASK 0xffffff00
#define  MC_TZ_ERR_ADR_H_RESERVED1_SHIFT 8
#define  MC_TZ_ERR_ADR_H_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_TZ_ERR_ADR_H_RESERVED1_MASK) >> MC_TZ_ERR_ADR_H_RESERVED1_SHIFT)
#define  MC_TZ_ERR_ADR_H_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_ERR_ADR_H_RESERVED1_MASK) | (((uint32_t)val) << MC_TZ_ERR_ADR_H_RESERVED1_SHIFT))

#define  MC_TZ_ERR_ADR_H_ERR_ADR_H_MASK 0xff
#define  MC_TZ_ERR_ADR_H_ERR_ADR_H_SHIFT 0
#define  MC_TZ_ERR_ADR_H_ERR_ADR_H_MASK_SHIFT(reg) (((reg) & MC_TZ_ERR_ADR_H_ERR_ADR_H_MASK) >> MC_TZ_ERR_ADR_H_ERR_ADR_H_SHIFT)
#define  MC_TZ_ERR_ADR_H_ERR_ADR_H_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_ERR_ADR_H_ERR_ADR_H_MASK) | (((uint32_t)val) << MC_TZ_ERR_ADR_H_ERR_ADR_H_SHIFT))

//====================================================================
//Register: Test Mode Register 0 (Test_Control_0)
//====================================================================

#define  MC_TEST_CONTROL_0_RESERVED1_MASK 0xfffffff8
#define  MC_TEST_CONTROL_0_RESERVED1_SHIFT 3
#define  MC_TEST_CONTROL_0_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_TEST_CONTROL_0_RESERVED1_MASK) >> MC_TEST_CONTROL_0_RESERVED1_SHIFT)
#define  MC_TEST_CONTROL_0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_TEST_CONTROL_0_RESERVED1_MASK) | (((uint32_t)val) << MC_TEST_CONTROL_0_RESERVED1_SHIFT))

#define  MC_TEST_CONTROL_0_DDR_COMMAND_MASK 0x7
#define  MC_TEST_CONTROL_0_DDR_COMMAND_SHIFT 0
#define  MC_TEST_CONTROL_0_DDR_COMMAND_MASK_SHIFT(reg) (((reg) & MC_TEST_CONTROL_0_DDR_COMMAND_MASK) >> MC_TEST_CONTROL_0_DDR_COMMAND_SHIFT)
#define  MC_TEST_CONTROL_0_DDR_COMMAND_REPLACE_VAL(reg,val) (((reg) & ~MC_TEST_CONTROL_0_DDR_COMMAND_MASK) | (((uint32_t)val) << MC_TEST_CONTROL_0_DDR_COMMAND_SHIFT))

//====================================================================
//Register: Test Mode Register 1 (Test_Control_1)
//====================================================================

#define  MC_TEST_CONTROL_1_RESERVED1_MASK 0xfc000000
#define  MC_TEST_CONTROL_1_RESERVED1_SHIFT 26
#define  MC_TEST_CONTROL_1_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_TEST_CONTROL_1_RESERVED1_MASK) >> MC_TEST_CONTROL_1_RESERVED1_SHIFT)
#define  MC_TEST_CONTROL_1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_TEST_CONTROL_1_RESERVED1_MASK) | (((uint32_t)val) << MC_TEST_CONTROL_1_RESERVED1_SHIFT))

#define  MC_TEST_CONTROL_1_CHANNEL_MASK 0x3000000
#define  MC_TEST_CONTROL_1_CHANNEL_SHIFT 24
#define  MC_TEST_CONTROL_1_CHANNEL_MASK_SHIFT(reg) (((reg) & MC_TEST_CONTROL_1_CHANNEL_MASK) >> MC_TEST_CONTROL_1_CHANNEL_SHIFT)
#define  MC_TEST_CONTROL_1_CHANNEL_REPLACE_VAL(reg,val) (((reg) & ~MC_TEST_CONTROL_1_CHANNEL_MASK) | (((uint32_t)val) << MC_TEST_CONTROL_1_CHANNEL_SHIFT))

#define  MC_TEST_CONTROL_1_CS_MASK 0xf00000
#define  MC_TEST_CONTROL_1_CS_SHIFT 20
#define  MC_TEST_CONTROL_1_CS_MASK_SHIFT(reg) (((reg) & MC_TEST_CONTROL_1_CS_MASK) >> MC_TEST_CONTROL_1_CS_SHIFT)
#define  MC_TEST_CONTROL_1_CS_REPLACE_VAL(reg,val) (((reg) & ~MC_TEST_CONTROL_1_CS_MASK) | (((uint32_t)val) << MC_TEST_CONTROL_1_CS_SHIFT))

#define  MC_TEST_CONTROL_1_DDR_CA_MASK 0xfffff
#define  MC_TEST_CONTROL_1_DDR_CA_SHIFT 0
#define  MC_TEST_CONTROL_1_DDR_CA_MASK_SHIFT(reg) (((reg) & MC_TEST_CONTROL_1_DDR_CA_MASK) >> MC_TEST_CONTROL_1_DDR_CA_SHIFT)
#define  MC_TEST_CONTROL_1_DDR_CA_REPLACE_VAL(reg,val) (((reg) & ~MC_TEST_CONTROL_1_DDR_CA_MASK) | (((uint32_t)val) << MC_TEST_CONTROL_1_DDR_CA_SHIFT))

//====================================================================
//Register: Memory Address Map Register Channel 0 (CH0_MMAP0)
//====================================================================

#define  MC_CH0_MMAP0_START_ADDRESS_MASK 0xff800000
#define  MC_CH0_MMAP0_START_ADDRESS_SHIFT 23
#define  MC_CH0_MMAP0_START_ADDRESS_MASK_SHIFT(reg) (((reg) & MC_CH0_MMAP0_START_ADDRESS_MASK) >> MC_CH0_MMAP0_START_ADDRESS_SHIFT)
#define  MC_CH0_MMAP0_START_ADDRESS_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_MMAP0_START_ADDRESS_MASK) | (((uint32_t)val) << MC_CH0_MMAP0_START_ADDRESS_SHIFT))

#define  MC_CH0_MMAP0_RESERVED1_MASK 0x600000
#define  MC_CH0_MMAP0_RESERVED1_SHIFT 21
#define  MC_CH0_MMAP0_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_MMAP0_RESERVED1_MASK) >> MC_CH0_MMAP0_RESERVED1_SHIFT)
#define  MC_CH0_MMAP0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_MMAP0_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_MMAP0_RESERVED1_SHIFT))

#define  MC_CH0_MMAP0_AREA_LENGTH_MASK 0x1f0000
#define  MC_CH0_MMAP0_AREA_LENGTH_SHIFT 16
#define  MC_CH0_MMAP0_AREA_LENGTH_MASK_SHIFT(reg) (((reg) & MC_CH0_MMAP0_AREA_LENGTH_MASK) >> MC_CH0_MMAP0_AREA_LENGTH_SHIFT)
#define  MC_CH0_MMAP0_AREA_LENGTH_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_MMAP0_AREA_LENGTH_MASK) | (((uint32_t)val) << MC_CH0_MMAP0_AREA_LENGTH_SHIFT))

#define  MC_CH0_MMAP0_START_ADDRESS_HI_MASK 0xff00
#define  MC_CH0_MMAP0_START_ADDRESS_HI_SHIFT 8
#define  MC_CH0_MMAP0_START_ADDRESS_HI_MASK_SHIFT(reg) (((reg) & MC_CH0_MMAP0_START_ADDRESS_HI_MASK) >> MC_CH0_MMAP0_START_ADDRESS_HI_SHIFT)
#define  MC_CH0_MMAP0_START_ADDRESS_HI_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_MMAP0_START_ADDRESS_HI_MASK) | (((uint32_t)val) << MC_CH0_MMAP0_START_ADDRESS_HI_SHIFT))

#define  MC_CH0_MMAP0_RESERVED2_MASK 0xfe
#define  MC_CH0_MMAP0_RESERVED2_SHIFT 1
#define  MC_CH0_MMAP0_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_CH0_MMAP0_RESERVED2_MASK) >> MC_CH0_MMAP0_RESERVED2_SHIFT)
#define  MC_CH0_MMAP0_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_MMAP0_RESERVED2_MASK) | (((uint32_t)val) << MC_CH0_MMAP0_RESERVED2_SHIFT))

#define  MC_CH0_MMAP0_CS_VALID_MASK 0x1
#define  MC_CH0_MMAP0_CS_VALID_SHIFT 0
#define  MC_CH0_MMAP0_CS_VALID_MASK_SHIFT(reg) (((reg) & MC_CH0_MMAP0_CS_VALID_MASK) >> MC_CH0_MMAP0_CS_VALID_SHIFT)
#define  MC_CH0_MMAP0_CS_VALID_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_MMAP0_CS_VALID_MASK) | (((uint32_t)val) << MC_CH0_MMAP0_CS_VALID_SHIFT))

//====================================================================
//Register: Memory Address Map Register Channel 0 (CH0_MMAP1)
//====================================================================

#define  MC_CH0_MMAP1_START_ADDRESS_MASK 0xff800000
#define  MC_CH0_MMAP1_START_ADDRESS_SHIFT 23
#define  MC_CH0_MMAP1_START_ADDRESS_MASK_SHIFT(reg) (((reg) & MC_CH0_MMAP1_START_ADDRESS_MASK) >> MC_CH0_MMAP1_START_ADDRESS_SHIFT)
#define  MC_CH0_MMAP1_START_ADDRESS_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_MMAP1_START_ADDRESS_MASK) | (((uint32_t)val) << MC_CH0_MMAP1_START_ADDRESS_SHIFT))

#define  MC_CH0_MMAP1_RESERVED1_MASK 0x600000
#define  MC_CH0_MMAP1_RESERVED1_SHIFT 21
#define  MC_CH0_MMAP1_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_MMAP1_RESERVED1_MASK) >> MC_CH0_MMAP1_RESERVED1_SHIFT)
#define  MC_CH0_MMAP1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_MMAP1_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_MMAP1_RESERVED1_SHIFT))

#define  MC_CH0_MMAP1_AREA_LENGTH_MASK 0x1f0000
#define  MC_CH0_MMAP1_AREA_LENGTH_SHIFT 16
#define  MC_CH0_MMAP1_AREA_LENGTH_MASK_SHIFT(reg) (((reg) & MC_CH0_MMAP1_AREA_LENGTH_MASK) >> MC_CH0_MMAP1_AREA_LENGTH_SHIFT)
#define  MC_CH0_MMAP1_AREA_LENGTH_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_MMAP1_AREA_LENGTH_MASK) | (((uint32_t)val) << MC_CH0_MMAP1_AREA_LENGTH_SHIFT))

#define  MC_CH0_MMAP1_START_ADDRESS_HI_MASK 0xff00
#define  MC_CH0_MMAP1_START_ADDRESS_HI_SHIFT 8
#define  MC_CH0_MMAP1_START_ADDRESS_HI_MASK_SHIFT(reg) (((reg) & MC_CH0_MMAP1_START_ADDRESS_HI_MASK) >> MC_CH0_MMAP1_START_ADDRESS_HI_SHIFT)
#define  MC_CH0_MMAP1_START_ADDRESS_HI_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_MMAP1_START_ADDRESS_HI_MASK) | (((uint32_t)val) << MC_CH0_MMAP1_START_ADDRESS_HI_SHIFT))

#define  MC_CH0_MMAP1_RESERVED2_MASK 0xfe
#define  MC_CH0_MMAP1_RESERVED2_SHIFT 1
#define  MC_CH0_MMAP1_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_CH0_MMAP1_RESERVED2_MASK) >> MC_CH0_MMAP1_RESERVED2_SHIFT)
#define  MC_CH0_MMAP1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_MMAP1_RESERVED2_MASK) | (((uint32_t)val) << MC_CH0_MMAP1_RESERVED2_SHIFT))

#define  MC_CH0_MMAP1_CS_VALID_MASK 0x1
#define  MC_CH0_MMAP1_CS_VALID_SHIFT 0
#define  MC_CH0_MMAP1_CS_VALID_MASK_SHIFT(reg) (((reg) & MC_CH0_MMAP1_CS_VALID_MASK) >> MC_CH0_MMAP1_CS_VALID_SHIFT)
#define  MC_CH0_MMAP1_CS_VALID_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_MMAP1_CS_VALID_MASK) | (((uint32_t)val) << MC_CH0_MMAP1_CS_VALID_SHIFT))

//====================================================================
//Register: Memory Address Map Register Channel 0 (CH0_MMAP2)
//====================================================================

#define  MC_CH0_MMAP2_START_ADDRESS_MASK 0xff800000
#define  MC_CH0_MMAP2_START_ADDRESS_SHIFT 23
#define  MC_CH0_MMAP2_START_ADDRESS_MASK_SHIFT(reg) (((reg) & MC_CH0_MMAP2_START_ADDRESS_MASK) >> MC_CH0_MMAP2_START_ADDRESS_SHIFT)
#define  MC_CH0_MMAP2_START_ADDRESS_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_MMAP2_START_ADDRESS_MASK) | (((uint32_t)val) << MC_CH0_MMAP2_START_ADDRESS_SHIFT))

#define  MC_CH0_MMAP2_RESERVED1_MASK 0x600000
#define  MC_CH0_MMAP2_RESERVED1_SHIFT 21
#define  MC_CH0_MMAP2_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_MMAP2_RESERVED1_MASK) >> MC_CH0_MMAP2_RESERVED1_SHIFT)
#define  MC_CH0_MMAP2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_MMAP2_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_MMAP2_RESERVED1_SHIFT))

#define  MC_CH0_MMAP2_AREA_LENGTH_MASK 0x1f0000
#define  MC_CH0_MMAP2_AREA_LENGTH_SHIFT 16
#define  MC_CH0_MMAP2_AREA_LENGTH_MASK_SHIFT(reg) (((reg) & MC_CH0_MMAP2_AREA_LENGTH_MASK) >> MC_CH0_MMAP2_AREA_LENGTH_SHIFT)
#define  MC_CH0_MMAP2_AREA_LENGTH_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_MMAP2_AREA_LENGTH_MASK) | (((uint32_t)val) << MC_CH0_MMAP2_AREA_LENGTH_SHIFT))

#define  MC_CH0_MMAP2_START_ADDRESS_HI_MASK 0xff00
#define  MC_CH0_MMAP2_START_ADDRESS_HI_SHIFT 8
#define  MC_CH0_MMAP2_START_ADDRESS_HI_MASK_SHIFT(reg) (((reg) & MC_CH0_MMAP2_START_ADDRESS_HI_MASK) >> MC_CH0_MMAP2_START_ADDRESS_HI_SHIFT)
#define  MC_CH0_MMAP2_START_ADDRESS_HI_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_MMAP2_START_ADDRESS_HI_MASK) | (((uint32_t)val) << MC_CH0_MMAP2_START_ADDRESS_HI_SHIFT))

#define  MC_CH0_MMAP2_RESERVED2_MASK 0xfe
#define  MC_CH0_MMAP2_RESERVED2_SHIFT 1
#define  MC_CH0_MMAP2_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_CH0_MMAP2_RESERVED2_MASK) >> MC_CH0_MMAP2_RESERVED2_SHIFT)
#define  MC_CH0_MMAP2_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_MMAP2_RESERVED2_MASK) | (((uint32_t)val) << MC_CH0_MMAP2_RESERVED2_SHIFT))

#define  MC_CH0_MMAP2_CS_VALID_MASK 0x1
#define  MC_CH0_MMAP2_CS_VALID_SHIFT 0
#define  MC_CH0_MMAP2_CS_VALID_MASK_SHIFT(reg) (((reg) & MC_CH0_MMAP2_CS_VALID_MASK) >> MC_CH0_MMAP2_CS_VALID_SHIFT)
#define  MC_CH0_MMAP2_CS_VALID_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_MMAP2_CS_VALID_MASK) | (((uint32_t)val) << MC_CH0_MMAP2_CS_VALID_SHIFT))

//====================================================================
//Register: Memory Controller Physical Address Map Register (CH0_PMAP0)
//====================================================================

#define  MC_CH0_PMAP0_RESERVED1_MASK 0xe0000000
#define  MC_CH0_PMAP0_RESERVED1_SHIFT 29
#define  MC_CH0_PMAP0_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_PMAP0_RESERVED1_MASK) >> MC_CH0_PMAP0_RESERVED1_SHIFT)
#define  MC_CH0_PMAP0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PMAP0_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_PMAP0_RESERVED1_SHIFT))

#define  MC_CH0_PMAP0_BANK_MAPPING_MASK 0x1f000000
#define  MC_CH0_PMAP0_BANK_MAPPING_SHIFT 24
#define  MC_CH0_PMAP0_BANK_MAPPING_MASK_SHIFT(reg) (((reg) & MC_CH0_PMAP0_BANK_MAPPING_MASK) >> MC_CH0_PMAP0_BANK_MAPPING_SHIFT)
#define  MC_CH0_PMAP0_BANK_MAPPING_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PMAP0_BANK_MAPPING_MASK) | (((uint32_t)val) << MC_CH0_PMAP0_BANK_MAPPING_SHIFT))

#define  MC_CH0_PMAP0_RESERVED2_MASK 0xfc0000
#define  MC_CH0_PMAP0_RESERVED2_SHIFT 18
#define  MC_CH0_PMAP0_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_CH0_PMAP0_RESERVED2_MASK) >> MC_CH0_PMAP0_RESERVED2_SHIFT)
#define  MC_CH0_PMAP0_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PMAP0_RESERVED2_MASK) | (((uint32_t)val) << MC_CH0_PMAP0_RESERVED2_SHIFT))

#define  MC_CH0_PMAP0_DEVICE_TYPE_MASK 0x30000
#define  MC_CH0_PMAP0_DEVICE_TYPE_SHIFT 16
#define  MC_CH0_PMAP0_DEVICE_TYPE_MASK_SHIFT(reg) (((reg) & MC_CH0_PMAP0_DEVICE_TYPE_MASK) >> MC_CH0_PMAP0_DEVICE_TYPE_SHIFT)
#define  MC_CH0_PMAP0_DEVICE_TYPE_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PMAP0_DEVICE_TYPE_MASK) | (((uint32_t)val) << MC_CH0_PMAP0_DEVICE_TYPE_SHIFT))

#define  MC_CH0_PMAP0_RESERVED3_MASK 0xc000
#define  MC_CH0_PMAP0_RESERVED3_SHIFT 14
#define  MC_CH0_PMAP0_RESERVED3_MASK_SHIFT(reg) (((reg) & MC_CH0_PMAP0_RESERVED3_MASK) >> MC_CH0_PMAP0_RESERVED3_SHIFT)
#define  MC_CH0_PMAP0_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PMAP0_RESERVED3_MASK) | (((uint32_t)val) << MC_CH0_PMAP0_RESERVED3_SHIFT))

#define  MC_CH0_PMAP0_STACKCHIP_MASK 0x3000
#define  MC_CH0_PMAP0_STACKCHIP_SHIFT 12
#define  MC_CH0_PMAP0_STACKCHIP_MASK_SHIFT(reg) (((reg) & MC_CH0_PMAP0_STACKCHIP_MASK) >> MC_CH0_PMAP0_STACKCHIP_SHIFT)
#define  MC_CH0_PMAP0_STACKCHIP_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PMAP0_STACKCHIP_MASK) | (((uint32_t)val) << MC_CH0_PMAP0_STACKCHIP_SHIFT))

#define  MC_CH0_PMAP0_NOROW_MASK 0xf00
#define  MC_CH0_PMAP0_NOROW_SHIFT 8
#define  MC_CH0_PMAP0_NOROW_MASK_SHIFT(reg) (((reg) & MC_CH0_PMAP0_NOROW_MASK) >> MC_CH0_PMAP0_NOROW_SHIFT)
#define  MC_CH0_PMAP0_NOROW_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PMAP0_NOROW_MASK) | (((uint32_t)val) << MC_CH0_PMAP0_NOROW_SHIFT))

#define  MC_CH0_PMAP0_NOCOL_MASK 0xf0
#define  MC_CH0_PMAP0_NOCOL_SHIFT 4
#define  MC_CH0_PMAP0_NOCOL_MASK_SHIFT(reg) (((reg) & MC_CH0_PMAP0_NOCOL_MASK) >> MC_CH0_PMAP0_NOCOL_SHIFT)
#define  MC_CH0_PMAP0_NOCOL_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PMAP0_NOCOL_MASK) | (((uint32_t)val) << MC_CH0_PMAP0_NOCOL_SHIFT))

#define  MC_CH0_PMAP0_NOBANKGROUP_MASK 0xc
#define  MC_CH0_PMAP0_NOBANKGROUP_SHIFT 2
#define  MC_CH0_PMAP0_NOBANKGROUP_MASK_SHIFT(reg) (((reg) & MC_CH0_PMAP0_NOBANKGROUP_MASK) >> MC_CH0_PMAP0_NOBANKGROUP_SHIFT)
#define  MC_CH0_PMAP0_NOBANKGROUP_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PMAP0_NOBANKGROUP_MASK) | (((uint32_t)val) << MC_CH0_PMAP0_NOBANKGROUP_SHIFT))

#define  MC_CH0_PMAP0_NOBANK_MASK 0x3
#define  MC_CH0_PMAP0_NOBANK_SHIFT 0
#define  MC_CH0_PMAP0_NOBANK_MASK_SHIFT(reg) (((reg) & MC_CH0_PMAP0_NOBANK_MASK) >> MC_CH0_PMAP0_NOBANK_SHIFT)
#define  MC_CH0_PMAP0_NOBANK_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PMAP0_NOBANK_MASK) | (((uint32_t)val) << MC_CH0_PMAP0_NOBANK_SHIFT))

//====================================================================
//Register: Memory Controller Physical Address Map Register (CH0_PMAP1)
//====================================================================

#define  MC_CH0_PMAP1_RESERVED1_MASK 0xe0000000
#define  MC_CH0_PMAP1_RESERVED1_SHIFT 29
#define  MC_CH0_PMAP1_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_PMAP1_RESERVED1_MASK) >> MC_CH0_PMAP1_RESERVED1_SHIFT)
#define  MC_CH0_PMAP1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PMAP1_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_PMAP1_RESERVED1_SHIFT))

#define  MC_CH0_PMAP1_BANK_MAPPING_MASK 0x1f000000
#define  MC_CH0_PMAP1_BANK_MAPPING_SHIFT 24
#define  MC_CH0_PMAP1_BANK_MAPPING_MASK_SHIFT(reg) (((reg) & MC_CH0_PMAP1_BANK_MAPPING_MASK) >> MC_CH0_PMAP1_BANK_MAPPING_SHIFT)
#define  MC_CH0_PMAP1_BANK_MAPPING_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PMAP1_BANK_MAPPING_MASK) | (((uint32_t)val) << MC_CH0_PMAP1_BANK_MAPPING_SHIFT))

#define  MC_CH0_PMAP1_RESERVED2_MASK 0xfc0000
#define  MC_CH0_PMAP1_RESERVED2_SHIFT 18
#define  MC_CH0_PMAP1_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_CH0_PMAP1_RESERVED2_MASK) >> MC_CH0_PMAP1_RESERVED2_SHIFT)
#define  MC_CH0_PMAP1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PMAP1_RESERVED2_MASK) | (((uint32_t)val) << MC_CH0_PMAP1_RESERVED2_SHIFT))

#define  MC_CH0_PMAP1_DEVICE_TYPE_MASK 0x30000
#define  MC_CH0_PMAP1_DEVICE_TYPE_SHIFT 16
#define  MC_CH0_PMAP1_DEVICE_TYPE_MASK_SHIFT(reg) (((reg) & MC_CH0_PMAP1_DEVICE_TYPE_MASK) >> MC_CH0_PMAP1_DEVICE_TYPE_SHIFT)
#define  MC_CH0_PMAP1_DEVICE_TYPE_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PMAP1_DEVICE_TYPE_MASK) | (((uint32_t)val) << MC_CH0_PMAP1_DEVICE_TYPE_SHIFT))

#define  MC_CH0_PMAP1_RESERVED3_MASK 0xc000
#define  MC_CH0_PMAP1_RESERVED3_SHIFT 14
#define  MC_CH0_PMAP1_RESERVED3_MASK_SHIFT(reg) (((reg) & MC_CH0_PMAP1_RESERVED3_MASK) >> MC_CH0_PMAP1_RESERVED3_SHIFT)
#define  MC_CH0_PMAP1_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PMAP1_RESERVED3_MASK) | (((uint32_t)val) << MC_CH0_PMAP1_RESERVED3_SHIFT))

#define  MC_CH0_PMAP1_STACKCHIP_MASK 0x3000
#define  MC_CH0_PMAP1_STACKCHIP_SHIFT 12
#define  MC_CH0_PMAP1_STACKCHIP_MASK_SHIFT(reg) (((reg) & MC_CH0_PMAP1_STACKCHIP_MASK) >> MC_CH0_PMAP1_STACKCHIP_SHIFT)
#define  MC_CH0_PMAP1_STACKCHIP_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PMAP1_STACKCHIP_MASK) | (((uint32_t)val) << MC_CH0_PMAP1_STACKCHIP_SHIFT))

#define  MC_CH0_PMAP1_NOROW_MASK 0xf00
#define  MC_CH0_PMAP1_NOROW_SHIFT 8
#define  MC_CH0_PMAP1_NOROW_MASK_SHIFT(reg) (((reg) & MC_CH0_PMAP1_NOROW_MASK) >> MC_CH0_PMAP1_NOROW_SHIFT)
#define  MC_CH0_PMAP1_NOROW_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PMAP1_NOROW_MASK) | (((uint32_t)val) << MC_CH0_PMAP1_NOROW_SHIFT))

#define  MC_CH0_PMAP1_NOCOL_MASK 0xf0
#define  MC_CH0_PMAP1_NOCOL_SHIFT 4
#define  MC_CH0_PMAP1_NOCOL_MASK_SHIFT(reg) (((reg) & MC_CH0_PMAP1_NOCOL_MASK) >> MC_CH0_PMAP1_NOCOL_SHIFT)
#define  MC_CH0_PMAP1_NOCOL_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PMAP1_NOCOL_MASK) | (((uint32_t)val) << MC_CH0_PMAP1_NOCOL_SHIFT))

#define  MC_CH0_PMAP1_NOBANKGROUP_MASK 0xc
#define  MC_CH0_PMAP1_NOBANKGROUP_SHIFT 2
#define  MC_CH0_PMAP1_NOBANKGROUP_MASK_SHIFT(reg) (((reg) & MC_CH0_PMAP1_NOBANKGROUP_MASK) >> MC_CH0_PMAP1_NOBANKGROUP_SHIFT)
#define  MC_CH0_PMAP1_NOBANKGROUP_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PMAP1_NOBANKGROUP_MASK) | (((uint32_t)val) << MC_CH0_PMAP1_NOBANKGROUP_SHIFT))

#define  MC_CH0_PMAP1_NOBANK_MASK 0x3
#define  MC_CH0_PMAP1_NOBANK_SHIFT 0
#define  MC_CH0_PMAP1_NOBANK_MASK_SHIFT(reg) (((reg) & MC_CH0_PMAP1_NOBANK_MASK) >> MC_CH0_PMAP1_NOBANK_SHIFT)
#define  MC_CH0_PMAP1_NOBANK_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PMAP1_NOBANK_MASK) | (((uint32_t)val) << MC_CH0_PMAP1_NOBANK_SHIFT))

//====================================================================
//Register: Memory Controller Physical Address Map Register (CH0_PMAP2)
//====================================================================

#define  MC_CH0_PMAP2_RESERVED1_MASK 0xe0000000
#define  MC_CH0_PMAP2_RESERVED1_SHIFT 29
#define  MC_CH0_PMAP2_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_PMAP2_RESERVED1_MASK) >> MC_CH0_PMAP2_RESERVED1_SHIFT)
#define  MC_CH0_PMAP2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PMAP2_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_PMAP2_RESERVED1_SHIFT))

#define  MC_CH0_PMAP2_BANK_MAPPING_MASK 0x1f000000
#define  MC_CH0_PMAP2_BANK_MAPPING_SHIFT 24
#define  MC_CH0_PMAP2_BANK_MAPPING_MASK_SHIFT(reg) (((reg) & MC_CH0_PMAP2_BANK_MAPPING_MASK) >> MC_CH0_PMAP2_BANK_MAPPING_SHIFT)
#define  MC_CH0_PMAP2_BANK_MAPPING_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PMAP2_BANK_MAPPING_MASK) | (((uint32_t)val) << MC_CH0_PMAP2_BANK_MAPPING_SHIFT))

#define  MC_CH0_PMAP2_RESERVED2_MASK 0xfc0000
#define  MC_CH0_PMAP2_RESERVED2_SHIFT 18
#define  MC_CH0_PMAP2_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_CH0_PMAP2_RESERVED2_MASK) >> MC_CH0_PMAP2_RESERVED2_SHIFT)
#define  MC_CH0_PMAP2_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PMAP2_RESERVED2_MASK) | (((uint32_t)val) << MC_CH0_PMAP2_RESERVED2_SHIFT))

#define  MC_CH0_PMAP2_DEVICE_TYPE_MASK 0x30000
#define  MC_CH0_PMAP2_DEVICE_TYPE_SHIFT 16
#define  MC_CH0_PMAP2_DEVICE_TYPE_MASK_SHIFT(reg) (((reg) & MC_CH0_PMAP2_DEVICE_TYPE_MASK) >> MC_CH0_PMAP2_DEVICE_TYPE_SHIFT)
#define  MC_CH0_PMAP2_DEVICE_TYPE_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PMAP2_DEVICE_TYPE_MASK) | (((uint32_t)val) << MC_CH0_PMAP2_DEVICE_TYPE_SHIFT))

#define  MC_CH0_PMAP2_RESERVED3_MASK 0xc000
#define  MC_CH0_PMAP2_RESERVED3_SHIFT 14
#define  MC_CH0_PMAP2_RESERVED3_MASK_SHIFT(reg) (((reg) & MC_CH0_PMAP2_RESERVED3_MASK) >> MC_CH0_PMAP2_RESERVED3_SHIFT)
#define  MC_CH0_PMAP2_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PMAP2_RESERVED3_MASK) | (((uint32_t)val) << MC_CH0_PMAP2_RESERVED3_SHIFT))

#define  MC_CH0_PMAP2_STACKCHIP_MASK 0x3000
#define  MC_CH0_PMAP2_STACKCHIP_SHIFT 12
#define  MC_CH0_PMAP2_STACKCHIP_MASK_SHIFT(reg) (((reg) & MC_CH0_PMAP2_STACKCHIP_MASK) >> MC_CH0_PMAP2_STACKCHIP_SHIFT)
#define  MC_CH0_PMAP2_STACKCHIP_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PMAP2_STACKCHIP_MASK) | (((uint32_t)val) << MC_CH0_PMAP2_STACKCHIP_SHIFT))

#define  MC_CH0_PMAP2_NOROW_MASK 0xf00
#define  MC_CH0_PMAP2_NOROW_SHIFT 8
#define  MC_CH0_PMAP2_NOROW_MASK_SHIFT(reg) (((reg) & MC_CH0_PMAP2_NOROW_MASK) >> MC_CH0_PMAP2_NOROW_SHIFT)
#define  MC_CH0_PMAP2_NOROW_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PMAP2_NOROW_MASK) | (((uint32_t)val) << MC_CH0_PMAP2_NOROW_SHIFT))

#define  MC_CH0_PMAP2_NOCOL_MASK 0xf0
#define  MC_CH0_PMAP2_NOCOL_SHIFT 4
#define  MC_CH0_PMAP2_NOCOL_MASK_SHIFT(reg) (((reg) & MC_CH0_PMAP2_NOCOL_MASK) >> MC_CH0_PMAP2_NOCOL_SHIFT)
#define  MC_CH0_PMAP2_NOCOL_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PMAP2_NOCOL_MASK) | (((uint32_t)val) << MC_CH0_PMAP2_NOCOL_SHIFT))

#define  MC_CH0_PMAP2_NOBANKGROUP_MASK 0xc
#define  MC_CH0_PMAP2_NOBANKGROUP_SHIFT 2
#define  MC_CH0_PMAP2_NOBANKGROUP_MASK_SHIFT(reg) (((reg) & MC_CH0_PMAP2_NOBANKGROUP_MASK) >> MC_CH0_PMAP2_NOBANKGROUP_SHIFT)
#define  MC_CH0_PMAP2_NOBANKGROUP_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PMAP2_NOBANKGROUP_MASK) | (((uint32_t)val) << MC_CH0_PMAP2_NOBANKGROUP_SHIFT))

#define  MC_CH0_PMAP2_NOBANK_MASK 0x3
#define  MC_CH0_PMAP2_NOBANK_SHIFT 0
#define  MC_CH0_PMAP2_NOBANK_MASK_SHIFT(reg) (((reg) & MC_CH0_PMAP2_NOBANK_MASK) >> MC_CH0_PMAP2_NOBANK_SHIFT)
#define  MC_CH0_PMAP2_NOBANK_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PMAP2_NOBANK_MASK) | (((uint32_t)val) << MC_CH0_PMAP2_NOBANK_SHIFT))

//====================================================================
//Register: MC Control Register 1 (CH0_MC_Control_1)
//====================================================================

#define  MC_CH0_MC_CONTROL_1_RESERVED1_MASK 0x80000000
#define  MC_CH0_MC_CONTROL_1_RESERVED1_SHIFT 31
#define  MC_CH0_MC_CONTROL_1_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_MC_CONTROL_1_RESERVED1_MASK) >> MC_CH0_MC_CONTROL_1_RESERVED1_SHIFT)
#define  MC_CH0_MC_CONTROL_1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_MC_CONTROL_1_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_MC_CONTROL_1_RESERVED1_SHIFT))

#define  MC_CH0_MC_CONTROL_1_APS_TYPE_MASK 0x70000000
#define  MC_CH0_MC_CONTROL_1_APS_TYPE_SHIFT 28
#define  MC_CH0_MC_CONTROL_1_APS_TYPE_MASK_SHIFT(reg) (((reg) & MC_CH0_MC_CONTROL_1_APS_TYPE_MASK) >> MC_CH0_MC_CONTROL_1_APS_TYPE_SHIFT)
#define  MC_CH0_MC_CONTROL_1_APS_TYPE_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_MC_CONTROL_1_APS_TYPE_MASK) | (((uint32_t)val) << MC_CH0_MC_CONTROL_1_APS_TYPE_SHIFT))

#define  MC_CH0_MC_CONTROL_1_APS_VALUE_MASK 0xfff0000
#define  MC_CH0_MC_CONTROL_1_APS_VALUE_SHIFT 16
#define  MC_CH0_MC_CONTROL_1_APS_VALUE_MASK_SHIFT(reg) (((reg) & MC_CH0_MC_CONTROL_1_APS_VALUE_MASK) >> MC_CH0_MC_CONTROL_1_APS_VALUE_SHIFT)
#define  MC_CH0_MC_CONTROL_1_APS_VALUE_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_MC_CONTROL_1_APS_VALUE_MASK) | (((uint32_t)val) << MC_CH0_MC_CONTROL_1_APS_VALUE_SHIFT))

#define  MC_CH0_MC_CONTROL_1_ACS_EN_MASK 0x8000
#define  MC_CH0_MC_CONTROL_1_ACS_EN_SHIFT 15
#define  MC_CH0_MC_CONTROL_1_ACS_EN_MASK_SHIFT(reg) (((reg) & MC_CH0_MC_CONTROL_1_ACS_EN_MASK) >> MC_CH0_MC_CONTROL_1_ACS_EN_SHIFT)
#define  MC_CH0_MC_CONTROL_1_ACS_EN_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_MC_CONTROL_1_ACS_EN_MASK) | (((uint32_t)val) << MC_CH0_MC_CONTROL_1_ACS_EN_SHIFT))

#define  MC_CH0_MC_CONTROL_1_ACS_EXIT_DLY_MASK 0x7000
#define  MC_CH0_MC_CONTROL_1_ACS_EXIT_DLY_SHIFT 12
#define  MC_CH0_MC_CONTROL_1_ACS_EXIT_DLY_MASK_SHIFT(reg) (((reg) & MC_CH0_MC_CONTROL_1_ACS_EXIT_DLY_MASK) >> MC_CH0_MC_CONTROL_1_ACS_EXIT_DLY_SHIFT)
#define  MC_CH0_MC_CONTROL_1_ACS_EXIT_DLY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_MC_CONTROL_1_ACS_EXIT_DLY_MASK) | (((uint32_t)val) << MC_CH0_MC_CONTROL_1_ACS_EXIT_DLY_SHIFT))

#define  MC_CH0_MC_CONTROL_1_REFPB_MODE_MASK 0x800
#define  MC_CH0_MC_CONTROL_1_REFPB_MODE_SHIFT 11
#define  MC_CH0_MC_CONTROL_1_REFPB_MODE_MASK_SHIFT(reg) (((reg) & MC_CH0_MC_CONTROL_1_REFPB_MODE_MASK) >> MC_CH0_MC_CONTROL_1_REFPB_MODE_SHIFT)
#define  MC_CH0_MC_CONTROL_1_REFPB_MODE_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_MC_CONTROL_1_REFPB_MODE_MASK) | (((uint32_t)val) << MC_CH0_MC_CONTROL_1_REFPB_MODE_SHIFT))

#define  MC_CH0_MC_CONTROL_1_RESERVED2_MASK 0x400
#define  MC_CH0_MC_CONTROL_1_RESERVED2_SHIFT 10
#define  MC_CH0_MC_CONTROL_1_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_CH0_MC_CONTROL_1_RESERVED2_MASK) >> MC_CH0_MC_CONTROL_1_RESERVED2_SHIFT)
#define  MC_CH0_MC_CONTROL_1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_MC_CONTROL_1_RESERVED2_MASK) | (((uint32_t)val) << MC_CH0_MC_CONTROL_1_RESERVED2_SHIFT))

#define  MC_CH0_MC_CONTROL_1_SRX_AUTO_ZQCL_DIS_MASK 0x200
#define  MC_CH0_MC_CONTROL_1_SRX_AUTO_ZQCL_DIS_SHIFT 9
#define  MC_CH0_MC_CONTROL_1_SRX_AUTO_ZQCL_DIS_MASK_SHIFT(reg) (((reg) & MC_CH0_MC_CONTROL_1_SRX_AUTO_ZQCL_DIS_MASK) >> MC_CH0_MC_CONTROL_1_SRX_AUTO_ZQCL_DIS_SHIFT)
#define  MC_CH0_MC_CONTROL_1_SRX_AUTO_ZQCL_DIS_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_MC_CONTROL_1_SRX_AUTO_ZQCL_DIS_MASK) | (((uint32_t)val) << MC_CH0_MC_CONTROL_1_SRX_AUTO_ZQCL_DIS_SHIFT))

#define  MC_CH0_MC_CONTROL_1_RESERVED3_MASK 0x180
#define  MC_CH0_MC_CONTROL_1_RESERVED3_SHIFT 7
#define  MC_CH0_MC_CONTROL_1_RESERVED3_MASK_SHIFT(reg) (((reg) & MC_CH0_MC_CONTROL_1_RESERVED3_MASK) >> MC_CH0_MC_CONTROL_1_RESERVED3_SHIFT)
#define  MC_CH0_MC_CONTROL_1_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_MC_CONTROL_1_RESERVED3_MASK) | (((uint32_t)val) << MC_CH0_MC_CONTROL_1_RESERVED3_SHIFT))

#define  MC_CH0_MC_CONTROL_1_RDIMM_MODE_MASK 0x40
#define  MC_CH0_MC_CONTROL_1_RDIMM_MODE_SHIFT 6
#define  MC_CH0_MC_CONTROL_1_RDIMM_MODE_MASK_SHIFT(reg) (((reg) & MC_CH0_MC_CONTROL_1_RDIMM_MODE_MASK) >> MC_CH0_MC_CONTROL_1_RDIMM_MODE_SHIFT)
#define  MC_CH0_MC_CONTROL_1_RDIMM_MODE_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_MC_CONTROL_1_RDIMM_MODE_MASK) | (((uint32_t)val) << MC_CH0_MC_CONTROL_1_RDIMM_MODE_SHIFT))

#define  MC_CH0_MC_CONTROL_1_AVOID_CA_CONTENTION_MASK 0x20
#define  MC_CH0_MC_CONTROL_1_AVOID_CA_CONTENTION_SHIFT 5
#define  MC_CH0_MC_CONTROL_1_AVOID_CA_CONTENTION_MASK_SHIFT(reg) (((reg) & MC_CH0_MC_CONTROL_1_AVOID_CA_CONTENTION_MASK) >> MC_CH0_MC_CONTROL_1_AVOID_CA_CONTENTION_SHIFT)
#define  MC_CH0_MC_CONTROL_1_AVOID_CA_CONTENTION_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_MC_CONTROL_1_AVOID_CA_CONTENTION_MASK) | (((uint32_t)val) << MC_CH0_MC_CONTROL_1_AVOID_CA_CONTENTION_SHIFT))

#define  MC_CH0_MC_CONTROL_1_TW2R_DIS_MASK 0x10
#define  MC_CH0_MC_CONTROL_1_TW2R_DIS_SHIFT 4
#define  MC_CH0_MC_CONTROL_1_TW2R_DIS_MASK_SHIFT(reg) (((reg) & MC_CH0_MC_CONTROL_1_TW2R_DIS_MASK) >> MC_CH0_MC_CONTROL_1_TW2R_DIS_SHIFT)
#define  MC_CH0_MC_CONTROL_1_TW2R_DIS_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_MC_CONTROL_1_TW2R_DIS_MASK) | (((uint32_t)val) << MC_CH0_MC_CONTROL_1_TW2R_DIS_SHIFT))

#define  MC_CH0_MC_CONTROL_1_PHY_MASK_MASK 0x8
#define  MC_CH0_MC_CONTROL_1_PHY_MASK_SHIFT 3
#define  MC_CH0_MC_CONTROL_1_PHY_MASK_MASK_SHIFT(reg) (((reg) & MC_CH0_MC_CONTROL_1_PHY_MASK_MASK) >> MC_CH0_MC_CONTROL_1_PHY_MASK_SHIFT)
#define  MC_CH0_MC_CONTROL_1_PHY_MASK_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_MC_CONTROL_1_PHY_MASK_MASK) | (((uint32_t)val) << MC_CH0_MC_CONTROL_1_PHY_MASK_SHIFT))

#define  MC_CH0_MC_CONTROL_1_FORCE_COLD_BOOT_MASK 0x4
#define  MC_CH0_MC_CONTROL_1_FORCE_COLD_BOOT_SHIFT 2
#define  MC_CH0_MC_CONTROL_1_FORCE_COLD_BOOT_MASK_SHIFT(reg) (((reg) & MC_CH0_MC_CONTROL_1_FORCE_COLD_BOOT_MASK) >> MC_CH0_MC_CONTROL_1_FORCE_COLD_BOOT_SHIFT)
#define  MC_CH0_MC_CONTROL_1_FORCE_COLD_BOOT_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_MC_CONTROL_1_FORCE_COLD_BOOT_MASK) | (((uint32_t)val) << MC_CH0_MC_CONTROL_1_FORCE_COLD_BOOT_SHIFT))

#define  MC_CH0_MC_CONTROL_1_RESERVED4_MASK 0x3
#define  MC_CH0_MC_CONTROL_1_RESERVED4_SHIFT 0
#define  MC_CH0_MC_CONTROL_1_RESERVED4_MASK_SHIFT(reg) (((reg) & MC_CH0_MC_CONTROL_1_RESERVED4_MASK) >> MC_CH0_MC_CONTROL_1_RESERVED4_SHIFT)
#define  MC_CH0_MC_CONTROL_1_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_MC_CONTROL_1_RESERVED4_MASK) | (((uint32_t)val) << MC_CH0_MC_CONTROL_1_RESERVED4_SHIFT))

//====================================================================
//Register: Memory Controller Control Register 2 (CH0_MC_Control_2)
//====================================================================

#define  MC_CH0_MC_CONTROL_2_RESERVED1_MASK 0x80000000
#define  MC_CH0_MC_CONTROL_2_RESERVED1_SHIFT 31
#define  MC_CH0_MC_CONTROL_2_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_MC_CONTROL_2_RESERVED1_MASK) >> MC_CH0_MC_CONTROL_2_RESERVED1_SHIFT)
#define  MC_CH0_MC_CONTROL_2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_MC_CONTROL_2_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_MC_CONTROL_2_RESERVED1_SHIFT))

#define  MC_CH0_MC_CONTROL_2_BLOCK_LOW_MASK 0x40000000
#define  MC_CH0_MC_CONTROL_2_BLOCK_LOW_SHIFT 30
#define  MC_CH0_MC_CONTROL_2_BLOCK_LOW_MASK_SHIFT(reg) (((reg) & MC_CH0_MC_CONTROL_2_BLOCK_LOW_MASK) >> MC_CH0_MC_CONTROL_2_BLOCK_LOW_SHIFT)
#define  MC_CH0_MC_CONTROL_2_BLOCK_LOW_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_MC_CONTROL_2_BLOCK_LOW_MASK) | (((uint32_t)val) << MC_CH0_MC_CONTROL_2_BLOCK_LOW_SHIFT))

#define  MC_CH0_MC_CONTROL_2_BLOCK_HIGH_MASK 0x20000000
#define  MC_CH0_MC_CONTROL_2_BLOCK_HIGH_SHIFT 29
#define  MC_CH0_MC_CONTROL_2_BLOCK_HIGH_MASK_SHIFT(reg) (((reg) & MC_CH0_MC_CONTROL_2_BLOCK_HIGH_MASK) >> MC_CH0_MC_CONTROL_2_BLOCK_HIGH_SHIFT)
#define  MC_CH0_MC_CONTROL_2_BLOCK_HIGH_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_MC_CONTROL_2_BLOCK_HIGH_MASK) | (((uint32_t)val) << MC_CH0_MC_CONTROL_2_BLOCK_HIGH_SHIFT))

#define  MC_CH0_MC_CONTROL_2_LOW_LATENCY_DIS_MASK 0x10000000
#define  MC_CH0_MC_CONTROL_2_LOW_LATENCY_DIS_SHIFT 28
#define  MC_CH0_MC_CONTROL_2_LOW_LATENCY_DIS_MASK_SHIFT(reg) (((reg) & MC_CH0_MC_CONTROL_2_LOW_LATENCY_DIS_MASK) >> MC_CH0_MC_CONTROL_2_LOW_LATENCY_DIS_SHIFT)
#define  MC_CH0_MC_CONTROL_2_LOW_LATENCY_DIS_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_MC_CONTROL_2_LOW_LATENCY_DIS_MASK) | (((uint32_t)val) << MC_CH0_MC_CONTROL_2_LOW_LATENCY_DIS_SHIFT))

#define  MC_CH0_MC_CONTROL_2_RESERVED2_MASK 0xfff0000
#define  MC_CH0_MC_CONTROL_2_RESERVED2_SHIFT 16
#define  MC_CH0_MC_CONTROL_2_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_CH0_MC_CONTROL_2_RESERVED2_MASK) >> MC_CH0_MC_CONTROL_2_RESERVED2_SHIFT)
#define  MC_CH0_MC_CONTROL_2_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_MC_CONTROL_2_RESERVED2_MASK) | (((uint32_t)val) << MC_CH0_MC_CONTROL_2_RESERVED2_SHIFT))

#define  MC_CH0_MC_CONTROL_2_BQ_STARV_TIME_MASK 0xffff
#define  MC_CH0_MC_CONTROL_2_BQ_STARV_TIME_SHIFT 0
#define  MC_CH0_MC_CONTROL_2_BQ_STARV_TIME_MASK_SHIFT(reg) (((reg) & MC_CH0_MC_CONTROL_2_BQ_STARV_TIME_MASK) >> MC_CH0_MC_CONTROL_2_BQ_STARV_TIME_SHIFT)
#define  MC_CH0_MC_CONTROL_2_BQ_STARV_TIME_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_MC_CONTROL_2_BQ_STARV_TIME_MASK) | (((uint32_t)val) << MC_CH0_MC_CONTROL_2_BQ_STARV_TIME_SHIFT))

//====================================================================
//Register: Memory Controller Control Register 3 (CH0_MC_Control_3)
//====================================================================

#define  MC_CH0_MC_CONTROL_3_RESERVED1_MASK 0xffff0000
#define  MC_CH0_MC_CONTROL_3_RESERVED1_SHIFT 16
#define  MC_CH0_MC_CONTROL_3_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_MC_CONTROL_3_RESERVED1_MASK) >> MC_CH0_MC_CONTROL_3_RESERVED1_SHIFT)
#define  MC_CH0_MC_CONTROL_3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_MC_CONTROL_3_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_MC_CONTROL_3_RESERVED1_SHIFT))

#define  MC_CH0_MC_CONTROL_3_PHY_OUT_FF_BYPASS_MASK 0xff00
#define  MC_CH0_MC_CONTROL_3_PHY_OUT_FF_BYPASS_SHIFT 8
#define  MC_CH0_MC_CONTROL_3_PHY_OUT_FF_BYPASS_MASK_SHIFT(reg) (((reg) & MC_CH0_MC_CONTROL_3_PHY_OUT_FF_BYPASS_MASK) >> MC_CH0_MC_CONTROL_3_PHY_OUT_FF_BYPASS_SHIFT)
#define  MC_CH0_MC_CONTROL_3_PHY_OUT_FF_BYPASS_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_MC_CONTROL_3_PHY_OUT_FF_BYPASS_MASK) | (((uint32_t)val) << MC_CH0_MC_CONTROL_3_PHY_OUT_FF_BYPASS_SHIFT))

#define  MC_CH0_MC_CONTROL_3_PHY_IN_FF_BYPASS_MASK 0xff
#define  MC_CH0_MC_CONTROL_3_PHY_IN_FF_BYPASS_SHIFT 0
#define  MC_CH0_MC_CONTROL_3_PHY_IN_FF_BYPASS_MASK_SHIFT(reg) (((reg) & MC_CH0_MC_CONTROL_3_PHY_IN_FF_BYPASS_MASK) >> MC_CH0_MC_CONTROL_3_PHY_IN_FF_BYPASS_SHIFT)
#define  MC_CH0_MC_CONTROL_3_PHY_IN_FF_BYPASS_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_MC_CONTROL_3_PHY_IN_FF_BYPASS_MASK) | (((uint32_t)val) << MC_CH0_MC_CONTROL_3_PHY_IN_FF_BYPASS_SHIFT))

//====================================================================
//Register: Memory Controller Control Register 4 (CH0_MC_Control_4)
//====================================================================

#define  MC_CH0_MC_CONTROL_4_AUTO_SR_IDLE_TIME_MASK 0xffffffff
#define  MC_CH0_MC_CONTROL_4_AUTO_SR_IDLE_TIME_SHIFT 0
#define  MC_CH0_MC_CONTROL_4_AUTO_SR_IDLE_TIME_MASK_SHIFT(reg) (((reg) & MC_CH0_MC_CONTROL_4_AUTO_SR_IDLE_TIME_MASK) >> MC_CH0_MC_CONTROL_4_AUTO_SR_IDLE_TIME_SHIFT)
#define  MC_CH0_MC_CONTROL_4_AUTO_SR_IDLE_TIME_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_MC_CONTROL_4_AUTO_SR_IDLE_TIME_MASK) | (((uint32_t)val) << MC_CH0_MC_CONTROL_4_AUTO_SR_IDLE_TIME_SHIFT))

//====================================================================
//Register: DRAM Configuration Register 1 (CH0_DRAM_Config_1)
//====================================================================

#define  MC_CH0_DRAM_CONFIG_1_CAP_LATENCY_MASK 0xf0000000
#define  MC_CH0_DRAM_CONFIG_1_CAP_LATENCY_SHIFT 28
#define  MC_CH0_DRAM_CONFIG_1_CAP_LATENCY_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONFIG_1_CAP_LATENCY_MASK) >> MC_CH0_DRAM_CONFIG_1_CAP_LATENCY_SHIFT)
#define  MC_CH0_DRAM_CONFIG_1_CAP_LATENCY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONFIG_1_CAP_LATENCY_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONFIG_1_CAP_LATENCY_SHIFT))

#define  MC_CH0_DRAM_CONFIG_1_CA_LATENCY_MASK 0xf000000
#define  MC_CH0_DRAM_CONFIG_1_CA_LATENCY_SHIFT 24
#define  MC_CH0_DRAM_CONFIG_1_CA_LATENCY_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONFIG_1_CA_LATENCY_MASK) >> MC_CH0_DRAM_CONFIG_1_CA_LATENCY_SHIFT)
#define  MC_CH0_DRAM_CONFIG_1_CA_LATENCY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONFIG_1_CA_LATENCY_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONFIG_1_CA_LATENCY_SHIFT))

#define  MC_CH0_DRAM_CONFIG_1_WL_SELECT_MASK 0x800000
#define  MC_CH0_DRAM_CONFIG_1_WL_SELECT_SHIFT 23
#define  MC_CH0_DRAM_CONFIG_1_WL_SELECT_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONFIG_1_WL_SELECT_MASK) >> MC_CH0_DRAM_CONFIG_1_WL_SELECT_SHIFT)
#define  MC_CH0_DRAM_CONFIG_1_WL_SELECT_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONFIG_1_WL_SELECT_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONFIG_1_WL_SELECT_SHIFT))

#define  MC_CH0_DRAM_CONFIG_1_BURST_LENGTH_MASK 0x700000
#define  MC_CH0_DRAM_CONFIG_1_BURST_LENGTH_SHIFT 20
#define  MC_CH0_DRAM_CONFIG_1_BURST_LENGTH_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONFIG_1_BURST_LENGTH_MASK) >> MC_CH0_DRAM_CONFIG_1_BURST_LENGTH_SHIFT)
#define  MC_CH0_DRAM_CONFIG_1_BURST_LENGTH_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONFIG_1_BURST_LENGTH_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONFIG_1_BURST_LENGTH_SHIFT))

#define  MC_CH0_DRAM_CONFIG_1_RL3_OPTION_MASK 0x80000
#define  MC_CH0_DRAM_CONFIG_1_RL3_OPTION_SHIFT 19
#define  MC_CH0_DRAM_CONFIG_1_RL3_OPTION_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONFIG_1_RL3_OPTION_MASK) >> MC_CH0_DRAM_CONFIG_1_RL3_OPTION_SHIFT)
#define  MC_CH0_DRAM_CONFIG_1_RL3_OPTION_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONFIG_1_RL3_OPTION_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONFIG_1_RL3_OPTION_SHIFT))

#define  MC_CH0_DRAM_CONFIG_1_CWL_4_MASK 0x40000
#define  MC_CH0_DRAM_CONFIG_1_CWL_4_SHIFT 18
#define  MC_CH0_DRAM_CONFIG_1_CWL_4_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONFIG_1_CWL_4_MASK) >> MC_CH0_DRAM_CONFIG_1_CWL_4_SHIFT)
#define  MC_CH0_DRAM_CONFIG_1_CWL_4_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONFIG_1_CWL_4_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONFIG_1_CWL_4_SHIFT))

#define  MC_CH0_DRAM_CONFIG_1_RESERVED1_MASK 0x20000
#define  MC_CH0_DRAM_CONFIG_1_RESERVED1_SHIFT 17
#define  MC_CH0_DRAM_CONFIG_1_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONFIG_1_RESERVED1_MASK) >> MC_CH0_DRAM_CONFIG_1_RESERVED1_SHIFT)
#define  MC_CH0_DRAM_CONFIG_1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONFIG_1_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONFIG_1_RESERVED1_SHIFT))

#define  MC_CH0_DRAM_CONFIG_1_CAS_LATENCY_MASK 0x1f000
#define  MC_CH0_DRAM_CONFIG_1_CAS_LATENCY_SHIFT 12
#define  MC_CH0_DRAM_CONFIG_1_CAS_LATENCY_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONFIG_1_CAS_LATENCY_MASK) >> MC_CH0_DRAM_CONFIG_1_CAS_LATENCY_SHIFT)
#define  MC_CH0_DRAM_CONFIG_1_CAS_LATENCY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONFIG_1_CAS_LATENCY_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONFIG_1_CAS_LATENCY_SHIFT))

#define  MC_CH0_DRAM_CONFIG_1_CWL_MASK 0xf00
#define  MC_CH0_DRAM_CONFIG_1_CWL_SHIFT 8
#define  MC_CH0_DRAM_CONFIG_1_CWL_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONFIG_1_CWL_MASK) >> MC_CH0_DRAM_CONFIG_1_CWL_SHIFT)
#define  MC_CH0_DRAM_CONFIG_1_CWL_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONFIG_1_CWL_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONFIG_1_CWL_SHIFT))

#define  MC_CH0_DRAM_CONFIG_1_SDRAM_TYPE_MASK 0xf0
#define  MC_CH0_DRAM_CONFIG_1_SDRAM_TYPE_SHIFT 4
#define  MC_CH0_DRAM_CONFIG_1_SDRAM_TYPE_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONFIG_1_SDRAM_TYPE_MASK) >> MC_CH0_DRAM_CONFIG_1_SDRAM_TYPE_SHIFT)
#define  MC_CH0_DRAM_CONFIG_1_SDRAM_TYPE_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONFIG_1_SDRAM_TYPE_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONFIG_1_SDRAM_TYPE_SHIFT))

#define  MC_CH0_DRAM_CONFIG_1_S4_TYPE_MASK 0x8
#define  MC_CH0_DRAM_CONFIG_1_S4_TYPE_SHIFT 3
#define  MC_CH0_DRAM_CONFIG_1_S4_TYPE_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONFIG_1_S4_TYPE_MASK) >> MC_CH0_DRAM_CONFIG_1_S4_TYPE_SHIFT)
#define  MC_CH0_DRAM_CONFIG_1_S4_TYPE_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONFIG_1_S4_TYPE_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONFIG_1_S4_TYPE_SHIFT))

#define  MC_CH0_DRAM_CONFIG_1_DATA_WIDTH_MASK 0x7
#define  MC_CH0_DRAM_CONFIG_1_DATA_WIDTH_SHIFT 0
#define  MC_CH0_DRAM_CONFIG_1_DATA_WIDTH_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONFIG_1_DATA_WIDTH_MASK) >> MC_CH0_DRAM_CONFIG_1_DATA_WIDTH_SHIFT)
#define  MC_CH0_DRAM_CONFIG_1_DATA_WIDTH_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONFIG_1_DATA_WIDTH_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONFIG_1_DATA_WIDTH_SHIFT))

//====================================================================
//Register: DRAM Configuration Register 2 (CH0_DRAM_Config_2)
//====================================================================

#define  MC_CH0_DRAM_CONFIG_2_RESERVED1_MASK 0xc0000000
#define  MC_CH0_DRAM_CONFIG_2_RESERVED1_SHIFT 30
#define  MC_CH0_DRAM_CONFIG_2_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONFIG_2_RESERVED1_MASK) >> MC_CH0_DRAM_CONFIG_2_RESERVED1_SHIFT)
#define  MC_CH0_DRAM_CONFIG_2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONFIG_2_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONFIG_2_RESERVED1_SHIFT))

#define  MC_CH0_DRAM_CONFIG_2_MRR_DATA_BYTE_MASK 0x30000000
#define  MC_CH0_DRAM_CONFIG_2_MRR_DATA_BYTE_SHIFT 28
#define  MC_CH0_DRAM_CONFIG_2_MRR_DATA_BYTE_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONFIG_2_MRR_DATA_BYTE_MASK) >> MC_CH0_DRAM_CONFIG_2_MRR_DATA_BYTE_SHIFT)
#define  MC_CH0_DRAM_CONFIG_2_MRR_DATA_BYTE_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONFIG_2_MRR_DATA_BYTE_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONFIG_2_MRR_DATA_BYTE_SHIFT))

#define  MC_CH0_DRAM_CONFIG_2_RESERVED2_MASK 0xc000000
#define  MC_CH0_DRAM_CONFIG_2_RESERVED2_SHIFT 26
#define  MC_CH0_DRAM_CONFIG_2_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONFIG_2_RESERVED2_MASK) >> MC_CH0_DRAM_CONFIG_2_RESERVED2_SHIFT)
#define  MC_CH0_DRAM_CONFIG_2_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONFIG_2_RESERVED2_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONFIG_2_RESERVED2_SHIFT))

#define  MC_CH0_DRAM_CONFIG_2_MPR_FORMAT_MASK 0x3000000
#define  MC_CH0_DRAM_CONFIG_2_MPR_FORMAT_SHIFT 24
#define  MC_CH0_DRAM_CONFIG_2_MPR_FORMAT_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONFIG_2_MPR_FORMAT_MASK) >> MC_CH0_DRAM_CONFIG_2_MPR_FORMAT_SHIFT)
#define  MC_CH0_DRAM_CONFIG_2_MPR_FORMAT_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONFIG_2_MPR_FORMAT_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONFIG_2_MPR_FORMAT_SHIFT))

#define  MC_CH0_DRAM_CONFIG_2_RESERVED3_MASK 0x800000
#define  MC_CH0_DRAM_CONFIG_2_RESERVED3_SHIFT 23
#define  MC_CH0_DRAM_CONFIG_2_RESERVED3_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONFIG_2_RESERVED3_MASK) >> MC_CH0_DRAM_CONFIG_2_RESERVED3_SHIFT)
#define  MC_CH0_DRAM_CONFIG_2_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONFIG_2_RESERVED3_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONFIG_2_RESERVED3_SHIFT))

#define  MC_CH0_DRAM_CONFIG_2_FINE_REF_MASK 0x700000
#define  MC_CH0_DRAM_CONFIG_2_FINE_REF_SHIFT 20
#define  MC_CH0_DRAM_CONFIG_2_FINE_REF_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONFIG_2_FINE_REF_MASK) >> MC_CH0_DRAM_CONFIG_2_FINE_REF_SHIFT)
#define  MC_CH0_DRAM_CONFIG_2_FINE_REF_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONFIG_2_FINE_REF_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONFIG_2_FINE_REF_SHIFT))

#define  MC_CH0_DRAM_CONFIG_2_WL_CRC_DM_MASK 0xc0000
#define  MC_CH0_DRAM_CONFIG_2_WL_CRC_DM_SHIFT 18
#define  MC_CH0_DRAM_CONFIG_2_WL_CRC_DM_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONFIG_2_WL_CRC_DM_MASK) >> MC_CH0_DRAM_CONFIG_2_WL_CRC_DM_SHIFT)
#define  MC_CH0_DRAM_CONFIG_2_WL_CRC_DM_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONFIG_2_WL_CRC_DM_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONFIG_2_WL_CRC_DM_SHIFT))

#define  MC_CH0_DRAM_CONFIG_2_PER_DRAM_ADDR_MASK 0x20000
#define  MC_CH0_DRAM_CONFIG_2_PER_DRAM_ADDR_SHIFT 17
#define  MC_CH0_DRAM_CONFIG_2_PER_DRAM_ADDR_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONFIG_2_PER_DRAM_ADDR_MASK) >> MC_CH0_DRAM_CONFIG_2_PER_DRAM_ADDR_SHIFT)
#define  MC_CH0_DRAM_CONFIG_2_PER_DRAM_ADDR_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONFIG_2_PER_DRAM_ADDR_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONFIG_2_PER_DRAM_ADDR_SHIFT))

#define  MC_CH0_DRAM_CONFIG_2_GEARDOWN_MASK 0x10000
#define  MC_CH0_DRAM_CONFIG_2_GEARDOWN_SHIFT 16
#define  MC_CH0_DRAM_CONFIG_2_GEARDOWN_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONFIG_2_GEARDOWN_MASK) >> MC_CH0_DRAM_CONFIG_2_GEARDOWN_SHIFT)
#define  MC_CH0_DRAM_CONFIG_2_GEARDOWN_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONFIG_2_GEARDOWN_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONFIG_2_GEARDOWN_SHIFT))

#define  MC_CH0_DRAM_CONFIG_2_RESERVED4_MASK 0x8000
#define  MC_CH0_DRAM_CONFIG_2_RESERVED4_SHIFT 15
#define  MC_CH0_DRAM_CONFIG_2_RESERVED4_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONFIG_2_RESERVED4_MASK) >> MC_CH0_DRAM_CONFIG_2_RESERVED4_SHIFT)
#define  MC_CH0_DRAM_CONFIG_2_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONFIG_2_RESERVED4_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONFIG_2_RESERVED4_SHIFT))

#define  MC_CH0_DRAM_CONFIG_2_MPR_PAGE_SEL_MASK 0x6000
#define  MC_CH0_DRAM_CONFIG_2_MPR_PAGE_SEL_SHIFT 13
#define  MC_CH0_DRAM_CONFIG_2_MPR_PAGE_SEL_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONFIG_2_MPR_PAGE_SEL_MASK) >> MC_CH0_DRAM_CONFIG_2_MPR_PAGE_SEL_SHIFT)
#define  MC_CH0_DRAM_CONFIG_2_MPR_PAGE_SEL_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONFIG_2_MPR_PAGE_SEL_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONFIG_2_MPR_PAGE_SEL_SHIFT))

#define  MC_CH0_DRAM_CONFIG_2_MPR_MASK 0x1000
#define  MC_CH0_DRAM_CONFIG_2_MPR_SHIFT 12
#define  MC_CH0_DRAM_CONFIG_2_MPR_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONFIG_2_MPR_MASK) >> MC_CH0_DRAM_CONFIG_2_MPR_SHIFT)
#define  MC_CH0_DRAM_CONFIG_2_MPR_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONFIG_2_MPR_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONFIG_2_MPR_SHIFT))

#define  MC_CH0_DRAM_CONFIG_2_WD_CRC_MASK 0x800
#define  MC_CH0_DRAM_CONFIG_2_WD_CRC_SHIFT 11
#define  MC_CH0_DRAM_CONFIG_2_WD_CRC_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONFIG_2_WD_CRC_MASK) >> MC_CH0_DRAM_CONFIG_2_WD_CRC_SHIFT)
#define  MC_CH0_DRAM_CONFIG_2_WD_CRC_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONFIG_2_WD_CRC_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONFIG_2_WD_CRC_SHIFT))

#define  MC_CH0_DRAM_CONFIG_2_RESERVED5_MASK 0x400
#define  MC_CH0_DRAM_CONFIG_2_RESERVED5_SHIFT 10
#define  MC_CH0_DRAM_CONFIG_2_RESERVED5_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONFIG_2_RESERVED5_MASK) >> MC_CH0_DRAM_CONFIG_2_RESERVED5_SHIFT)
#define  MC_CH0_DRAM_CONFIG_2_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONFIG_2_RESERVED5_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONFIG_2_RESERVED5_SHIFT))

#define  MC_CH0_DRAM_CONFIG_2_ASR_MASK 0x300
#define  MC_CH0_DRAM_CONFIG_2_ASR_SHIFT 8
#define  MC_CH0_DRAM_CONFIG_2_ASR_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONFIG_2_ASR_MASK) >> MC_CH0_DRAM_CONFIG_2_ASR_SHIFT)
#define  MC_CH0_DRAM_CONFIG_2_ASR_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONFIG_2_ASR_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONFIG_2_ASR_SHIFT))

#define  MC_CH0_DRAM_CONFIG_2_OUTEN_MASK 0x80
#define  MC_CH0_DRAM_CONFIG_2_OUTEN_SHIFT 7
#define  MC_CH0_DRAM_CONFIG_2_OUTEN_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONFIG_2_OUTEN_MASK) >> MC_CH0_DRAM_CONFIG_2_OUTEN_SHIFT)
#define  MC_CH0_DRAM_CONFIG_2_OUTEN_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONFIG_2_OUTEN_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONFIG_2_OUTEN_SHIFT))

#define  MC_CH0_DRAM_CONFIG_2_RESERVED6_MASK 0x40
#define  MC_CH0_DRAM_CONFIG_2_RESERVED6_SHIFT 6
#define  MC_CH0_DRAM_CONFIG_2_RESERVED6_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONFIG_2_RESERVED6_MASK) >> MC_CH0_DRAM_CONFIG_2_RESERVED6_SHIFT)
#define  MC_CH0_DRAM_CONFIG_2_RESERVED6_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONFIG_2_RESERVED6_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONFIG_2_RESERVED6_SHIFT))

#define  MC_CH0_DRAM_CONFIG_2_WRITE_LEVEL_EN_MASK 0x20
#define  MC_CH0_DRAM_CONFIG_2_WRITE_LEVEL_EN_SHIFT 5
#define  MC_CH0_DRAM_CONFIG_2_WRITE_LEVEL_EN_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONFIG_2_WRITE_LEVEL_EN_MASK) >> MC_CH0_DRAM_CONFIG_2_WRITE_LEVEL_EN_SHIFT)
#define  MC_CH0_DRAM_CONFIG_2_WRITE_LEVEL_EN_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONFIG_2_WRITE_LEVEL_EN_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONFIG_2_WRITE_LEVEL_EN_SHIFT))

#define  MC_CH0_DRAM_CONFIG_2_SDRAM_DLL_DIS_MASK 0x10
#define  MC_CH0_DRAM_CONFIG_2_SDRAM_DLL_DIS_SHIFT 4
#define  MC_CH0_DRAM_CONFIG_2_SDRAM_DLL_DIS_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONFIG_2_SDRAM_DLL_DIS_MASK) >> MC_CH0_DRAM_CONFIG_2_SDRAM_DLL_DIS_SHIFT)
#define  MC_CH0_DRAM_CONFIG_2_SDRAM_DLL_DIS_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONFIG_2_SDRAM_DLL_DIS_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONFIG_2_SDRAM_DLL_DIS_SHIFT))

#define  MC_CH0_DRAM_CONFIG_2_RESERVED7_MASK 0x8
#define  MC_CH0_DRAM_CONFIG_2_RESERVED7_SHIFT 3
#define  MC_CH0_DRAM_CONFIG_2_RESERVED7_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONFIG_2_RESERVED7_MASK) >> MC_CH0_DRAM_CONFIG_2_RESERVED7_SHIFT)
#define  MC_CH0_DRAM_CONFIG_2_RESERVED7_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONFIG_2_RESERVED7_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONFIG_2_RESERVED7_SHIFT))

#define  MC_CH0_DRAM_CONFIG_2_CAS_BT_MASK 0x4
#define  MC_CH0_DRAM_CONFIG_2_CAS_BT_SHIFT 2
#define  MC_CH0_DRAM_CONFIG_2_CAS_BT_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONFIG_2_CAS_BT_MASK) >> MC_CH0_DRAM_CONFIG_2_CAS_BT_SHIFT)
#define  MC_CH0_DRAM_CONFIG_2_CAS_BT_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONFIG_2_CAS_BT_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONFIG_2_CAS_BT_SHIFT))

#define  MC_CH0_DRAM_CONFIG_2_PD_MODE_MASK 0x2
#define  MC_CH0_DRAM_CONFIG_2_PD_MODE_SHIFT 1
#define  MC_CH0_DRAM_CONFIG_2_PD_MODE_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONFIG_2_PD_MODE_MASK) >> MC_CH0_DRAM_CONFIG_2_PD_MODE_SHIFT)
#define  MC_CH0_DRAM_CONFIG_2_PD_MODE_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONFIG_2_PD_MODE_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONFIG_2_PD_MODE_SHIFT))

#define  MC_CH0_DRAM_CONFIG_2_DLL_RESET_MASK 0x1
#define  MC_CH0_DRAM_CONFIG_2_DLL_RESET_SHIFT 0
#define  MC_CH0_DRAM_CONFIG_2_DLL_RESET_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONFIG_2_DLL_RESET_MASK) >> MC_CH0_DRAM_CONFIG_2_DLL_RESET_SHIFT)
#define  MC_CH0_DRAM_CONFIG_2_DLL_RESET_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONFIG_2_DLL_RESET_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONFIG_2_DLL_RESET_SHIFT))

//====================================================================
//Register: DRAM Configuration Register 3 (CH0_DRAM_Config_3)
//====================================================================

#define  MC_CH0_DRAM_CONFIG_3_RESERVED1_MASK 0xfc000000
#define  MC_CH0_DRAM_CONFIG_3_RESERVED1_SHIFT 26
#define  MC_CH0_DRAM_CONFIG_3_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONFIG_3_RESERVED1_MASK) >> MC_CH0_DRAM_CONFIG_3_RESERVED1_SHIFT)
#define  MC_CH0_DRAM_CONFIG_3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONFIG_3_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONFIG_3_RESERVED1_SHIFT))

#define  MC_CH0_DRAM_CONFIG_3_VREF_TRAINING_RANGE_MASK 0x2000000
#define  MC_CH0_DRAM_CONFIG_3_VREF_TRAINING_RANGE_SHIFT 25
#define  MC_CH0_DRAM_CONFIG_3_VREF_TRAINING_RANGE_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONFIG_3_VREF_TRAINING_RANGE_MASK) >> MC_CH0_DRAM_CONFIG_3_VREF_TRAINING_RANGE_SHIFT)
#define  MC_CH0_DRAM_CONFIG_3_VREF_TRAINING_RANGE_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONFIG_3_VREF_TRAINING_RANGE_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONFIG_3_VREF_TRAINING_RANGE_SHIFT))

#define  MC_CH0_DRAM_CONFIG_3_VREF_TRAINING_MASK 0x1000000
#define  MC_CH0_DRAM_CONFIG_3_VREF_TRAINING_SHIFT 24
#define  MC_CH0_DRAM_CONFIG_3_VREF_TRAINING_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONFIG_3_VREF_TRAINING_MASK) >> MC_CH0_DRAM_CONFIG_3_VREF_TRAINING_SHIFT)
#define  MC_CH0_DRAM_CONFIG_3_VREF_TRAINING_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONFIG_3_VREF_TRAINING_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONFIG_3_VREF_TRAINING_SHIFT))

#define  MC_CH0_DRAM_CONFIG_3_RESERVED2_MASK 0xc00000
#define  MC_CH0_DRAM_CONFIG_3_RESERVED2_SHIFT 22
#define  MC_CH0_DRAM_CONFIG_3_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONFIG_3_RESERVED2_MASK) >> MC_CH0_DRAM_CONFIG_3_RESERVED2_SHIFT)
#define  MC_CH0_DRAM_CONFIG_3_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONFIG_3_RESERVED2_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONFIG_3_RESERVED2_SHIFT))

#define  MC_CH0_DRAM_CONFIG_3_VREF_TRAINING_VALUE_MASK 0x3f0000
#define  MC_CH0_DRAM_CONFIG_3_VREF_TRAINING_VALUE_SHIFT 16
#define  MC_CH0_DRAM_CONFIG_3_VREF_TRAINING_VALUE_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONFIG_3_VREF_TRAINING_VALUE_MASK) >> MC_CH0_DRAM_CONFIG_3_VREF_TRAINING_VALUE_SHIFT)
#define  MC_CH0_DRAM_CONFIG_3_VREF_TRAINING_VALUE_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONFIG_3_VREF_TRAINING_VALUE_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONFIG_3_VREF_TRAINING_VALUE_SHIFT))

#define  MC_CH0_DRAM_CONFIG_3_RESERVED3_MASK 0x8000
#define  MC_CH0_DRAM_CONFIG_3_RESERVED3_SHIFT 15
#define  MC_CH0_DRAM_CONFIG_3_RESERVED3_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONFIG_3_RESERVED3_MASK) >> MC_CH0_DRAM_CONFIG_3_RESERVED3_SHIFT)
#define  MC_CH0_DRAM_CONFIG_3_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONFIG_3_RESERVED3_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONFIG_3_RESERVED3_SHIFT))

#define  MC_CH0_DRAM_CONFIG_3_READ_DBI_MASK 0x4000
#define  MC_CH0_DRAM_CONFIG_3_READ_DBI_SHIFT 14
#define  MC_CH0_DRAM_CONFIG_3_READ_DBI_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONFIG_3_READ_DBI_MASK) >> MC_CH0_DRAM_CONFIG_3_READ_DBI_SHIFT)
#define  MC_CH0_DRAM_CONFIG_3_READ_DBI_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONFIG_3_READ_DBI_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONFIG_3_READ_DBI_SHIFT))

#define  MC_CH0_DRAM_CONFIG_3_WRITE_DBI_MASK 0x2000
#define  MC_CH0_DRAM_CONFIG_3_WRITE_DBI_SHIFT 13
#define  MC_CH0_DRAM_CONFIG_3_WRITE_DBI_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONFIG_3_WRITE_DBI_MASK) >> MC_CH0_DRAM_CONFIG_3_WRITE_DBI_SHIFT)
#define  MC_CH0_DRAM_CONFIG_3_WRITE_DBI_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONFIG_3_WRITE_DBI_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONFIG_3_WRITE_DBI_SHIFT))

#define  MC_CH0_DRAM_CONFIG_3_DM_MASK 0x1000
#define  MC_CH0_DRAM_CONFIG_3_DM_SHIFT 12
#define  MC_CH0_DRAM_CONFIG_3_DM_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONFIG_3_DM_MASK) >> MC_CH0_DRAM_CONFIG_3_DM_SHIFT)
#define  MC_CH0_DRAM_CONFIG_3_DM_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONFIG_3_DM_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONFIG_3_DM_SHIFT))

#define  MC_CH0_DRAM_CONFIG_3_RESERVED4_MASK 0x800
#define  MC_CH0_DRAM_CONFIG_3_RESERVED4_SHIFT 11
#define  MC_CH0_DRAM_CONFIG_3_RESERVED4_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONFIG_3_RESERVED4_MASK) >> MC_CH0_DRAM_CONFIG_3_RESERVED4_SHIFT)
#define  MC_CH0_DRAM_CONFIG_3_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONFIG_3_RESERVED4_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONFIG_3_RESERVED4_SHIFT))

#define  MC_CH0_DRAM_CONFIG_3_WR_PRE_MASK 0x400
#define  MC_CH0_DRAM_CONFIG_3_WR_PRE_SHIFT 10
#define  MC_CH0_DRAM_CONFIG_3_WR_PRE_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONFIG_3_WR_PRE_MASK) >> MC_CH0_DRAM_CONFIG_3_WR_PRE_SHIFT)
#define  MC_CH0_DRAM_CONFIG_3_WR_PRE_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONFIG_3_WR_PRE_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONFIG_3_WR_PRE_SHIFT))

#define  MC_CH0_DRAM_CONFIG_3_RESERVED5_MASK 0x200
#define  MC_CH0_DRAM_CONFIG_3_RESERVED5_SHIFT 9
#define  MC_CH0_DRAM_CONFIG_3_RESERVED5_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONFIG_3_RESERVED5_MASK) >> MC_CH0_DRAM_CONFIG_3_RESERVED5_SHIFT)
#define  MC_CH0_DRAM_CONFIG_3_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONFIG_3_RESERVED5_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONFIG_3_RESERVED5_SHIFT))

#define  MC_CH0_DRAM_CONFIG_3_RD_PRE_MASK 0x100
#define  MC_CH0_DRAM_CONFIG_3_RD_PRE_SHIFT 8
#define  MC_CH0_DRAM_CONFIG_3_RD_PRE_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONFIG_3_RD_PRE_MASK) >> MC_CH0_DRAM_CONFIG_3_RD_PRE_SHIFT)
#define  MC_CH0_DRAM_CONFIG_3_RD_PRE_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONFIG_3_RD_PRE_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONFIG_3_RD_PRE_SHIFT))

#define  MC_CH0_DRAM_CONFIG_3_RESERVED6_MASK 0xc0
#define  MC_CH0_DRAM_CONFIG_3_RESERVED6_SHIFT 6
#define  MC_CH0_DRAM_CONFIG_3_RESERVED6_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONFIG_3_RESERVED6_MASK) >> MC_CH0_DRAM_CONFIG_3_RESERVED6_SHIFT)
#define  MC_CH0_DRAM_CONFIG_3_RESERVED6_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONFIG_3_RESERVED6_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONFIG_3_RESERVED6_SHIFT))

#define  MC_CH0_DRAM_CONFIG_3_RD_PRE_TRAINING_MASK 0x20
#define  MC_CH0_DRAM_CONFIG_3_RD_PRE_TRAINING_SHIFT 5
#define  MC_CH0_DRAM_CONFIG_3_RD_PRE_TRAINING_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONFIG_3_RD_PRE_TRAINING_MASK) >> MC_CH0_DRAM_CONFIG_3_RD_PRE_TRAINING_SHIFT)
#define  MC_CH0_DRAM_CONFIG_3_RD_PRE_TRAINING_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONFIG_3_RD_PRE_TRAINING_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONFIG_3_RD_PRE_TRAINING_SHIFT))

#define  MC_CH0_DRAM_CONFIG_3_SR_ABT_MODE_MASK 0x10
#define  MC_CH0_DRAM_CONFIG_3_SR_ABT_MODE_SHIFT 4
#define  MC_CH0_DRAM_CONFIG_3_SR_ABT_MODE_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONFIG_3_SR_ABT_MODE_MASK) >> MC_CH0_DRAM_CONFIG_3_SR_ABT_MODE_SHIFT)
#define  MC_CH0_DRAM_CONFIG_3_SR_ABT_MODE_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONFIG_3_SR_ABT_MODE_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONFIG_3_SR_ABT_MODE_SHIFT))

#define  MC_CH0_DRAM_CONFIG_3_INT_VREF_MON_MASK 0x8
#define  MC_CH0_DRAM_CONFIG_3_INT_VREF_MON_SHIFT 3
#define  MC_CH0_DRAM_CONFIG_3_INT_VREF_MON_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONFIG_3_INT_VREF_MON_MASK) >> MC_CH0_DRAM_CONFIG_3_INT_VREF_MON_SHIFT)
#define  MC_CH0_DRAM_CONFIG_3_INT_VREF_MON_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONFIG_3_INT_VREF_MON_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONFIG_3_INT_VREF_MON_SHIFT))

#define  MC_CH0_DRAM_CONFIG_3_TEMP_CTRL_REF_MODE_MASK 0x4
#define  MC_CH0_DRAM_CONFIG_3_TEMP_CTRL_REF_MODE_SHIFT 2
#define  MC_CH0_DRAM_CONFIG_3_TEMP_CTRL_REF_MODE_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONFIG_3_TEMP_CTRL_REF_MODE_MASK) >> MC_CH0_DRAM_CONFIG_3_TEMP_CTRL_REF_MODE_SHIFT)
#define  MC_CH0_DRAM_CONFIG_3_TEMP_CTRL_REF_MODE_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONFIG_3_TEMP_CTRL_REF_MODE_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONFIG_3_TEMP_CTRL_REF_MODE_SHIFT))

#define  MC_CH0_DRAM_CONFIG_3_RESERVED7_MASK 0x2
#define  MC_CH0_DRAM_CONFIG_3_RESERVED7_SHIFT 1
#define  MC_CH0_DRAM_CONFIG_3_RESERVED7_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONFIG_3_RESERVED7_MASK) >> MC_CH0_DRAM_CONFIG_3_RESERVED7_SHIFT)
#define  MC_CH0_DRAM_CONFIG_3_RESERVED7_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONFIG_3_RESERVED7_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONFIG_3_RESERVED7_SHIFT))

#define  MC_CH0_DRAM_CONFIG_3_TEMP_CTRL_REF_RANGE_MASK 0x1
#define  MC_CH0_DRAM_CONFIG_3_TEMP_CTRL_REF_RANGE_SHIFT 0
#define  MC_CH0_DRAM_CONFIG_3_TEMP_CTRL_REF_RANGE_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONFIG_3_TEMP_CTRL_REF_RANGE_MASK) >> MC_CH0_DRAM_CONFIG_3_TEMP_CTRL_REF_RANGE_SHIFT)
#define  MC_CH0_DRAM_CONFIG_3_TEMP_CTRL_REF_RANGE_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONFIG_3_TEMP_CTRL_REF_RANGE_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONFIG_3_TEMP_CTRL_REF_RANGE_SHIFT))

//====================================================================
//Register: DRAM Configuration Register 5 (CH0_DRAM_Config_5_CS0)
//====================================================================

#define  MC_CH0_DRAM_CONFIG_5_CS0_PD_CONTROL_MASK 0x80000000
#define  MC_CH0_DRAM_CONFIG_5_CS0_PD_CONTROL_SHIFT 31
#define  MC_CH0_DRAM_CONFIG_5_CS0_PD_CONTROL_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONFIG_5_CS0_PD_CONTROL_MASK) >> MC_CH0_DRAM_CONFIG_5_CS0_PD_CONTROL_SHIFT)
#define  MC_CH0_DRAM_CONFIG_5_CS0_PD_CONTROL_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONFIG_5_CS0_PD_CONTROL_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONFIG_5_CS0_PD_CONTROL_SHIFT))

#define  MC_CH0_DRAM_CONFIG_5_CS0_RTT_PARK_MASK 0x70000000
#define  MC_CH0_DRAM_CONFIG_5_CS0_RTT_PARK_SHIFT 28
#define  MC_CH0_DRAM_CONFIG_5_CS0_RTT_PARK_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONFIG_5_CS0_RTT_PARK_MASK) >> MC_CH0_DRAM_CONFIG_5_CS0_RTT_PARK_SHIFT)
#define  MC_CH0_DRAM_CONFIG_5_CS0_RTT_PARK_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONFIG_5_CS0_RTT_PARK_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONFIG_5_CS0_RTT_PARK_SHIFT))

#define  MC_CH0_DRAM_CONFIG_5_CS0_RESERVED1_MASK 0xc000000
#define  MC_CH0_DRAM_CONFIG_5_CS0_RESERVED1_SHIFT 26
#define  MC_CH0_DRAM_CONFIG_5_CS0_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONFIG_5_CS0_RESERVED1_MASK) >> MC_CH0_DRAM_CONFIG_5_CS0_RESERVED1_SHIFT)
#define  MC_CH0_DRAM_CONFIG_5_CS0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONFIG_5_CS0_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONFIG_5_CS0_RESERVED1_SHIFT))

#define  MC_CH0_DRAM_CONFIG_5_CS0_RTT_WR_MASK 0x3000000
#define  MC_CH0_DRAM_CONFIG_5_CS0_RTT_WR_SHIFT 24
#define  MC_CH0_DRAM_CONFIG_5_CS0_RTT_WR_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONFIG_5_CS0_RTT_WR_MASK) >> MC_CH0_DRAM_CONFIG_5_CS0_RTT_WR_SHIFT)
#define  MC_CH0_DRAM_CONFIG_5_CS0_RTT_WR_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONFIG_5_CS0_RTT_WR_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONFIG_5_CS0_RTT_WR_SHIFT))

#define  MC_CH0_DRAM_CONFIG_5_CS0_RESERVED2_MASK 0x800000
#define  MC_CH0_DRAM_CONFIG_5_CS0_RESERVED2_SHIFT 23
#define  MC_CH0_DRAM_CONFIG_5_CS0_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONFIG_5_CS0_RESERVED2_MASK) >> MC_CH0_DRAM_CONFIG_5_CS0_RESERVED2_SHIFT)
#define  MC_CH0_DRAM_CONFIG_5_CS0_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONFIG_5_CS0_RESERVED2_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONFIG_5_CS0_RESERVED2_SHIFT))

#define  MC_CH0_DRAM_CONFIG_5_CS0_RTT_NOM_MASK 0x700000
#define  MC_CH0_DRAM_CONFIG_5_CS0_RTT_NOM_SHIFT 20
#define  MC_CH0_DRAM_CONFIG_5_CS0_RTT_NOM_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONFIG_5_CS0_RTT_NOM_MASK) >> MC_CH0_DRAM_CONFIG_5_CS0_RTT_NOM_SHIFT)
#define  MC_CH0_DRAM_CONFIG_5_CS0_RTT_NOM_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONFIG_5_CS0_RTT_NOM_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONFIG_5_CS0_RTT_NOM_SHIFT))

#define  MC_CH0_DRAM_CONFIG_5_CS0_ODS_MASK 0xf0000
#define  MC_CH0_DRAM_CONFIG_5_CS0_ODS_SHIFT 16
#define  MC_CH0_DRAM_CONFIG_5_CS0_ODS_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONFIG_5_CS0_ODS_MASK) >> MC_CH0_DRAM_CONFIG_5_CS0_ODS_SHIFT)
#define  MC_CH0_DRAM_CONFIG_5_CS0_ODS_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONFIG_5_CS0_ODS_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONFIG_5_CS0_ODS_SHIFT))

#define  MC_CH0_DRAM_CONFIG_5_CS0_PASR_MASK 0xffff
#define  MC_CH0_DRAM_CONFIG_5_CS0_PASR_SHIFT 0
#define  MC_CH0_DRAM_CONFIG_5_CS0_PASR_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONFIG_5_CS0_PASR_MASK) >> MC_CH0_DRAM_CONFIG_5_CS0_PASR_SHIFT)
#define  MC_CH0_DRAM_CONFIG_5_CS0_PASR_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONFIG_5_CS0_PASR_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONFIG_5_CS0_PASR_SHIFT))

//====================================================================
//Register: DRAM Configuration Register 5 (CH0_DRAM_Config_5_CS1)
//====================================================================

#define  MC_CH0_DRAM_CONFIG_5_CS1_PD_CONTROL_MASK 0x80000000
#define  MC_CH0_DRAM_CONFIG_5_CS1_PD_CONTROL_SHIFT 31
#define  MC_CH0_DRAM_CONFIG_5_CS1_PD_CONTROL_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONFIG_5_CS1_PD_CONTROL_MASK) >> MC_CH0_DRAM_CONFIG_5_CS1_PD_CONTROL_SHIFT)
#define  MC_CH0_DRAM_CONFIG_5_CS1_PD_CONTROL_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONFIG_5_CS1_PD_CONTROL_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONFIG_5_CS1_PD_CONTROL_SHIFT))

#define  MC_CH0_DRAM_CONFIG_5_CS1_RTT_PARK_MASK 0x70000000
#define  MC_CH0_DRAM_CONFIG_5_CS1_RTT_PARK_SHIFT 28
#define  MC_CH0_DRAM_CONFIG_5_CS1_RTT_PARK_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONFIG_5_CS1_RTT_PARK_MASK) >> MC_CH0_DRAM_CONFIG_5_CS1_RTT_PARK_SHIFT)
#define  MC_CH0_DRAM_CONFIG_5_CS1_RTT_PARK_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONFIG_5_CS1_RTT_PARK_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONFIG_5_CS1_RTT_PARK_SHIFT))

#define  MC_CH0_DRAM_CONFIG_5_CS1_RESERVED1_MASK 0xc000000
#define  MC_CH0_DRAM_CONFIG_5_CS1_RESERVED1_SHIFT 26
#define  MC_CH0_DRAM_CONFIG_5_CS1_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONFIG_5_CS1_RESERVED1_MASK) >> MC_CH0_DRAM_CONFIG_5_CS1_RESERVED1_SHIFT)
#define  MC_CH0_DRAM_CONFIG_5_CS1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONFIG_5_CS1_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONFIG_5_CS1_RESERVED1_SHIFT))

#define  MC_CH0_DRAM_CONFIG_5_CS1_RTT_WR_MASK 0x3000000
#define  MC_CH0_DRAM_CONFIG_5_CS1_RTT_WR_SHIFT 24
#define  MC_CH0_DRAM_CONFIG_5_CS1_RTT_WR_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONFIG_5_CS1_RTT_WR_MASK) >> MC_CH0_DRAM_CONFIG_5_CS1_RTT_WR_SHIFT)
#define  MC_CH0_DRAM_CONFIG_5_CS1_RTT_WR_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONFIG_5_CS1_RTT_WR_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONFIG_5_CS1_RTT_WR_SHIFT))

#define  MC_CH0_DRAM_CONFIG_5_CS1_RESERVED2_MASK 0x800000
#define  MC_CH0_DRAM_CONFIG_5_CS1_RESERVED2_SHIFT 23
#define  MC_CH0_DRAM_CONFIG_5_CS1_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONFIG_5_CS1_RESERVED2_MASK) >> MC_CH0_DRAM_CONFIG_5_CS1_RESERVED2_SHIFT)
#define  MC_CH0_DRAM_CONFIG_5_CS1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONFIG_5_CS1_RESERVED2_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONFIG_5_CS1_RESERVED2_SHIFT))

#define  MC_CH0_DRAM_CONFIG_5_CS1_RTT_NOM_MASK 0x700000
#define  MC_CH0_DRAM_CONFIG_5_CS1_RTT_NOM_SHIFT 20
#define  MC_CH0_DRAM_CONFIG_5_CS1_RTT_NOM_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONFIG_5_CS1_RTT_NOM_MASK) >> MC_CH0_DRAM_CONFIG_5_CS1_RTT_NOM_SHIFT)
#define  MC_CH0_DRAM_CONFIG_5_CS1_RTT_NOM_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONFIG_5_CS1_RTT_NOM_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONFIG_5_CS1_RTT_NOM_SHIFT))

#define  MC_CH0_DRAM_CONFIG_5_CS1_ODS_MASK 0xf0000
#define  MC_CH0_DRAM_CONFIG_5_CS1_ODS_SHIFT 16
#define  MC_CH0_DRAM_CONFIG_5_CS1_ODS_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONFIG_5_CS1_ODS_MASK) >> MC_CH0_DRAM_CONFIG_5_CS1_ODS_SHIFT)
#define  MC_CH0_DRAM_CONFIG_5_CS1_ODS_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONFIG_5_CS1_ODS_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONFIG_5_CS1_ODS_SHIFT))

#define  MC_CH0_DRAM_CONFIG_5_CS1_PASR_MASK 0xffff
#define  MC_CH0_DRAM_CONFIG_5_CS1_PASR_SHIFT 0
#define  MC_CH0_DRAM_CONFIG_5_CS1_PASR_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONFIG_5_CS1_PASR_MASK) >> MC_CH0_DRAM_CONFIG_5_CS1_PASR_SHIFT)
#define  MC_CH0_DRAM_CONFIG_5_CS1_PASR_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONFIG_5_CS1_PASR_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONFIG_5_CS1_PASR_SHIFT))

//====================================================================
//Register: DRAM Configuration Register 5 (CH0_DRAM_Config_5_CS2)
//====================================================================

#define  MC_CH0_DRAM_CONFIG_5_CS2_PD_CONTROL_MASK 0x80000000
#define  MC_CH0_DRAM_CONFIG_5_CS2_PD_CONTROL_SHIFT 31
#define  MC_CH0_DRAM_CONFIG_5_CS2_PD_CONTROL_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONFIG_5_CS2_PD_CONTROL_MASK) >> MC_CH0_DRAM_CONFIG_5_CS2_PD_CONTROL_SHIFT)
#define  MC_CH0_DRAM_CONFIG_5_CS2_PD_CONTROL_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONFIG_5_CS2_PD_CONTROL_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONFIG_5_CS2_PD_CONTROL_SHIFT))

#define  MC_CH0_DRAM_CONFIG_5_CS2_RTT_PARK_MASK 0x70000000
#define  MC_CH0_DRAM_CONFIG_5_CS2_RTT_PARK_SHIFT 28
#define  MC_CH0_DRAM_CONFIG_5_CS2_RTT_PARK_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONFIG_5_CS2_RTT_PARK_MASK) >> MC_CH0_DRAM_CONFIG_5_CS2_RTT_PARK_SHIFT)
#define  MC_CH0_DRAM_CONFIG_5_CS2_RTT_PARK_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONFIG_5_CS2_RTT_PARK_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONFIG_5_CS2_RTT_PARK_SHIFT))

#define  MC_CH0_DRAM_CONFIG_5_CS2_RESERVED1_MASK 0xc000000
#define  MC_CH0_DRAM_CONFIG_5_CS2_RESERVED1_SHIFT 26
#define  MC_CH0_DRAM_CONFIG_5_CS2_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONFIG_5_CS2_RESERVED1_MASK) >> MC_CH0_DRAM_CONFIG_5_CS2_RESERVED1_SHIFT)
#define  MC_CH0_DRAM_CONFIG_5_CS2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONFIG_5_CS2_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONFIG_5_CS2_RESERVED1_SHIFT))

#define  MC_CH0_DRAM_CONFIG_5_CS2_RTT_WR_MASK 0x3000000
#define  MC_CH0_DRAM_CONFIG_5_CS2_RTT_WR_SHIFT 24
#define  MC_CH0_DRAM_CONFIG_5_CS2_RTT_WR_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONFIG_5_CS2_RTT_WR_MASK) >> MC_CH0_DRAM_CONFIG_5_CS2_RTT_WR_SHIFT)
#define  MC_CH0_DRAM_CONFIG_5_CS2_RTT_WR_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONFIG_5_CS2_RTT_WR_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONFIG_5_CS2_RTT_WR_SHIFT))

#define  MC_CH0_DRAM_CONFIG_5_CS2_RESERVED2_MASK 0x800000
#define  MC_CH0_DRAM_CONFIG_5_CS2_RESERVED2_SHIFT 23
#define  MC_CH0_DRAM_CONFIG_5_CS2_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONFIG_5_CS2_RESERVED2_MASK) >> MC_CH0_DRAM_CONFIG_5_CS2_RESERVED2_SHIFT)
#define  MC_CH0_DRAM_CONFIG_5_CS2_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONFIG_5_CS2_RESERVED2_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONFIG_5_CS2_RESERVED2_SHIFT))

#define  MC_CH0_DRAM_CONFIG_5_CS2_RTT_NOM_MASK 0x700000
#define  MC_CH0_DRAM_CONFIG_5_CS2_RTT_NOM_SHIFT 20
#define  MC_CH0_DRAM_CONFIG_5_CS2_RTT_NOM_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONFIG_5_CS2_RTT_NOM_MASK) >> MC_CH0_DRAM_CONFIG_5_CS2_RTT_NOM_SHIFT)
#define  MC_CH0_DRAM_CONFIG_5_CS2_RTT_NOM_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONFIG_5_CS2_RTT_NOM_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONFIG_5_CS2_RTT_NOM_SHIFT))

#define  MC_CH0_DRAM_CONFIG_5_CS2_ODS_MASK 0xf0000
#define  MC_CH0_DRAM_CONFIG_5_CS2_ODS_SHIFT 16
#define  MC_CH0_DRAM_CONFIG_5_CS2_ODS_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONFIG_5_CS2_ODS_MASK) >> MC_CH0_DRAM_CONFIG_5_CS2_ODS_SHIFT)
#define  MC_CH0_DRAM_CONFIG_5_CS2_ODS_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONFIG_5_CS2_ODS_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONFIG_5_CS2_ODS_SHIFT))

#define  MC_CH0_DRAM_CONFIG_5_CS2_PASR_MASK 0xffff
#define  MC_CH0_DRAM_CONFIG_5_CS2_PASR_SHIFT 0
#define  MC_CH0_DRAM_CONFIG_5_CS2_PASR_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONFIG_5_CS2_PASR_MASK) >> MC_CH0_DRAM_CONFIG_5_CS2_PASR_SHIFT)
#define  MC_CH0_DRAM_CONFIG_5_CS2_PASR_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONFIG_5_CS2_PASR_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONFIG_5_CS2_PASR_SHIFT))

//====================================================================
//Register: DRAM Control Register 1 (CH0_DRAM_Control_1)
//====================================================================

#define  MC_CH0_DRAM_CONTROL_1_ODT3_READ_EN_MASK 0xf0000000
#define  MC_CH0_DRAM_CONTROL_1_ODT3_READ_EN_SHIFT 28
#define  MC_CH0_DRAM_CONTROL_1_ODT3_READ_EN_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONTROL_1_ODT3_READ_EN_MASK) >> MC_CH0_DRAM_CONTROL_1_ODT3_READ_EN_SHIFT)
#define  MC_CH0_DRAM_CONTROL_1_ODT3_READ_EN_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONTROL_1_ODT3_READ_EN_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONTROL_1_ODT3_READ_EN_SHIFT))

#define  MC_CH0_DRAM_CONTROL_1_ODT3_WRITE_EN_MASK 0xf000000
#define  MC_CH0_DRAM_CONTROL_1_ODT3_WRITE_EN_SHIFT 24
#define  MC_CH0_DRAM_CONTROL_1_ODT3_WRITE_EN_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONTROL_1_ODT3_WRITE_EN_MASK) >> MC_CH0_DRAM_CONTROL_1_ODT3_WRITE_EN_SHIFT)
#define  MC_CH0_DRAM_CONTROL_1_ODT3_WRITE_EN_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONTROL_1_ODT3_WRITE_EN_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONTROL_1_ODT3_WRITE_EN_SHIFT))

#define  MC_CH0_DRAM_CONTROL_1_ODT2_READ_EN_MASK 0xf00000
#define  MC_CH0_DRAM_CONTROL_1_ODT2_READ_EN_SHIFT 20
#define  MC_CH0_DRAM_CONTROL_1_ODT2_READ_EN_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONTROL_1_ODT2_READ_EN_MASK) >> MC_CH0_DRAM_CONTROL_1_ODT2_READ_EN_SHIFT)
#define  MC_CH0_DRAM_CONTROL_1_ODT2_READ_EN_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONTROL_1_ODT2_READ_EN_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONTROL_1_ODT2_READ_EN_SHIFT))

#define  MC_CH0_DRAM_CONTROL_1_ODT2_WRITE_EN_MASK 0xf0000
#define  MC_CH0_DRAM_CONTROL_1_ODT2_WRITE_EN_SHIFT 16
#define  MC_CH0_DRAM_CONTROL_1_ODT2_WRITE_EN_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONTROL_1_ODT2_WRITE_EN_MASK) >> MC_CH0_DRAM_CONTROL_1_ODT2_WRITE_EN_SHIFT)
#define  MC_CH0_DRAM_CONTROL_1_ODT2_WRITE_EN_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONTROL_1_ODT2_WRITE_EN_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONTROL_1_ODT2_WRITE_EN_SHIFT))

#define  MC_CH0_DRAM_CONTROL_1_ODT1_READ_EN_MASK 0xf000
#define  MC_CH0_DRAM_CONTROL_1_ODT1_READ_EN_SHIFT 12
#define  MC_CH0_DRAM_CONTROL_1_ODT1_READ_EN_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONTROL_1_ODT1_READ_EN_MASK) >> MC_CH0_DRAM_CONTROL_1_ODT1_READ_EN_SHIFT)
#define  MC_CH0_DRAM_CONTROL_1_ODT1_READ_EN_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONTROL_1_ODT1_READ_EN_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONTROL_1_ODT1_READ_EN_SHIFT))

#define  MC_CH0_DRAM_CONTROL_1_ODT1_WRITE_EN_MASK 0xf00
#define  MC_CH0_DRAM_CONTROL_1_ODT1_WRITE_EN_SHIFT 8
#define  MC_CH0_DRAM_CONTROL_1_ODT1_WRITE_EN_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONTROL_1_ODT1_WRITE_EN_MASK) >> MC_CH0_DRAM_CONTROL_1_ODT1_WRITE_EN_SHIFT)
#define  MC_CH0_DRAM_CONTROL_1_ODT1_WRITE_EN_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONTROL_1_ODT1_WRITE_EN_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONTROL_1_ODT1_WRITE_EN_SHIFT))

#define  MC_CH0_DRAM_CONTROL_1_ODT0_READ_EN_MASK 0xf0
#define  MC_CH0_DRAM_CONTROL_1_ODT0_READ_EN_SHIFT 4
#define  MC_CH0_DRAM_CONTROL_1_ODT0_READ_EN_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONTROL_1_ODT0_READ_EN_MASK) >> MC_CH0_DRAM_CONTROL_1_ODT0_READ_EN_SHIFT)
#define  MC_CH0_DRAM_CONTROL_1_ODT0_READ_EN_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONTROL_1_ODT0_READ_EN_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONTROL_1_ODT0_READ_EN_SHIFT))

#define  MC_CH0_DRAM_CONTROL_1_ODT0_WRITE_EN_MASK 0xf
#define  MC_CH0_DRAM_CONTROL_1_ODT0_WRITE_EN_SHIFT 0
#define  MC_CH0_DRAM_CONTROL_1_ODT0_WRITE_EN_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONTROL_1_ODT0_WRITE_EN_MASK) >> MC_CH0_DRAM_CONTROL_1_ODT0_WRITE_EN_SHIFT)
#define  MC_CH0_DRAM_CONTROL_1_ODT0_WRITE_EN_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONTROL_1_ODT0_WRITE_EN_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONTROL_1_ODT0_WRITE_EN_SHIFT))

//====================================================================
//Register: DRAM Control Register 2 (CH0_DRAM_Control_2)
//====================================================================

#define  MC_CH0_DRAM_CONTROL_2_FORCE_ODT_MASK 0xf0000000
#define  MC_CH0_DRAM_CONTROL_2_FORCE_ODT_SHIFT 28
#define  MC_CH0_DRAM_CONTROL_2_FORCE_ODT_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONTROL_2_FORCE_ODT_MASK) >> MC_CH0_DRAM_CONTROL_2_FORCE_ODT_SHIFT)
#define  MC_CH0_DRAM_CONTROL_2_FORCE_ODT_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONTROL_2_FORCE_ODT_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONTROL_2_FORCE_ODT_SHIFT))

#define  MC_CH0_DRAM_CONTROL_2_RESERVED1_MASK 0xc000000
#define  MC_CH0_DRAM_CONTROL_2_RESERVED1_SHIFT 26
#define  MC_CH0_DRAM_CONTROL_2_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONTROL_2_RESERVED1_MASK) >> MC_CH0_DRAM_CONTROL_2_RESERVED1_SHIFT)
#define  MC_CH0_DRAM_CONTROL_2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONTROL_2_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONTROL_2_RESERVED1_SHIFT))

#define  MC_CH0_DRAM_CONTROL_2_PAD_TERM_SWITCH_MODE_MASK 0x3000000
#define  MC_CH0_DRAM_CONTROL_2_PAD_TERM_SWITCH_MODE_SHIFT 24
#define  MC_CH0_DRAM_CONTROL_2_PAD_TERM_SWITCH_MODE_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONTROL_2_PAD_TERM_SWITCH_MODE_MASK) >> MC_CH0_DRAM_CONTROL_2_PAD_TERM_SWITCH_MODE_SHIFT)
#define  MC_CH0_DRAM_CONTROL_2_PAD_TERM_SWITCH_MODE_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONTROL_2_PAD_TERM_SWITCH_MODE_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONTROL_2_PAD_TERM_SWITCH_MODE_SHIFT))

#define  MC_CH0_DRAM_CONTROL_2_RESERVED2_MASK 0xffff00
#define  MC_CH0_DRAM_CONTROL_2_RESERVED2_SHIFT 8
#define  MC_CH0_DRAM_CONTROL_2_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONTROL_2_RESERVED2_MASK) >> MC_CH0_DRAM_CONTROL_2_RESERVED2_SHIFT)
#define  MC_CH0_DRAM_CONTROL_2_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONTROL_2_RESERVED2_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONTROL_2_RESERVED2_SHIFT))

#define  MC_CH0_DRAM_CONTROL_2_ODT3_SWITCH_MODE_MASK 0xc0
#define  MC_CH0_DRAM_CONTROL_2_ODT3_SWITCH_MODE_SHIFT 6
#define  MC_CH0_DRAM_CONTROL_2_ODT3_SWITCH_MODE_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONTROL_2_ODT3_SWITCH_MODE_MASK) >> MC_CH0_DRAM_CONTROL_2_ODT3_SWITCH_MODE_SHIFT)
#define  MC_CH0_DRAM_CONTROL_2_ODT3_SWITCH_MODE_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONTROL_2_ODT3_SWITCH_MODE_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONTROL_2_ODT3_SWITCH_MODE_SHIFT))

#define  MC_CH0_DRAM_CONTROL_2_ODT2_SWITCH_MODE_MASK 0x30
#define  MC_CH0_DRAM_CONTROL_2_ODT2_SWITCH_MODE_SHIFT 4
#define  MC_CH0_DRAM_CONTROL_2_ODT2_SWITCH_MODE_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONTROL_2_ODT2_SWITCH_MODE_MASK) >> MC_CH0_DRAM_CONTROL_2_ODT2_SWITCH_MODE_SHIFT)
#define  MC_CH0_DRAM_CONTROL_2_ODT2_SWITCH_MODE_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONTROL_2_ODT2_SWITCH_MODE_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONTROL_2_ODT2_SWITCH_MODE_SHIFT))

#define  MC_CH0_DRAM_CONTROL_2_ODT1_SWITCH_MODE_MASK 0xc
#define  MC_CH0_DRAM_CONTROL_2_ODT1_SWITCH_MODE_SHIFT 2
#define  MC_CH0_DRAM_CONTROL_2_ODT1_SWITCH_MODE_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONTROL_2_ODT1_SWITCH_MODE_MASK) >> MC_CH0_DRAM_CONTROL_2_ODT1_SWITCH_MODE_SHIFT)
#define  MC_CH0_DRAM_CONTROL_2_ODT1_SWITCH_MODE_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONTROL_2_ODT1_SWITCH_MODE_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONTROL_2_ODT1_SWITCH_MODE_SHIFT))

#define  MC_CH0_DRAM_CONTROL_2_ODT0_SWITCH_MODE_MASK 0x3
#define  MC_CH0_DRAM_CONTROL_2_ODT0_SWITCH_MODE_SHIFT 0
#define  MC_CH0_DRAM_CONTROL_2_ODT0_SWITCH_MODE_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONTROL_2_ODT0_SWITCH_MODE_MASK) >> MC_CH0_DRAM_CONTROL_2_ODT0_SWITCH_MODE_SHIFT)
#define  MC_CH0_DRAM_CONTROL_2_ODT0_SWITCH_MODE_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONTROL_2_ODT0_SWITCH_MODE_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONTROL_2_ODT0_SWITCH_MODE_SHIFT))

//====================================================================
//Register: DRAM Control Register 3 (CH0_DRAM_Control_3)
//====================================================================

#define  MC_CH0_DRAM_CONTROL_3_RESERVED1_MASK 0xfff00000
#define  MC_CH0_DRAM_CONTROL_3_RESERVED1_SHIFT 20
#define  MC_CH0_DRAM_CONTROL_3_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONTROL_3_RESERVED1_MASK) >> MC_CH0_DRAM_CONTROL_3_RESERVED1_SHIFT)
#define  MC_CH0_DRAM_CONTROL_3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONTROL_3_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONTROL_3_RESERVED1_SHIFT))

#define  MC_CH0_DRAM_CONTROL_3_ODT_WR_DLY_SEL_MASK 0xc0000
#define  MC_CH0_DRAM_CONTROL_3_ODT_WR_DLY_SEL_SHIFT 18
#define  MC_CH0_DRAM_CONTROL_3_ODT_WR_DLY_SEL_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONTROL_3_ODT_WR_DLY_SEL_MASK) >> MC_CH0_DRAM_CONTROL_3_ODT_WR_DLY_SEL_SHIFT)
#define  MC_CH0_DRAM_CONTROL_3_ODT_WR_DLY_SEL_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONTROL_3_ODT_WR_DLY_SEL_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONTROL_3_ODT_WR_DLY_SEL_SHIFT))

#define  MC_CH0_DRAM_CONTROL_3_ODT_RD_DLY_SEL_MASK 0x30000
#define  MC_CH0_DRAM_CONTROL_3_ODT_RD_DLY_SEL_SHIFT 16
#define  MC_CH0_DRAM_CONTROL_3_ODT_RD_DLY_SEL_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONTROL_3_ODT_RD_DLY_SEL_MASK) >> MC_CH0_DRAM_CONTROL_3_ODT_RD_DLY_SEL_SHIFT)
#define  MC_CH0_DRAM_CONTROL_3_ODT_RD_DLY_SEL_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONTROL_3_ODT_RD_DLY_SEL_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONTROL_3_ODT_RD_DLY_SEL_SHIFT))

#define  MC_CH0_DRAM_CONTROL_3_ODT_WR_START_DLY_VAL_MASK 0xf000
#define  MC_CH0_DRAM_CONTROL_3_ODT_WR_START_DLY_VAL_SHIFT 12
#define  MC_CH0_DRAM_CONTROL_3_ODT_WR_START_DLY_VAL_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONTROL_3_ODT_WR_START_DLY_VAL_MASK) >> MC_CH0_DRAM_CONTROL_3_ODT_WR_START_DLY_VAL_SHIFT)
#define  MC_CH0_DRAM_CONTROL_3_ODT_WR_START_DLY_VAL_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONTROL_3_ODT_WR_START_DLY_VAL_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONTROL_3_ODT_WR_START_DLY_VAL_SHIFT))

#define  MC_CH0_DRAM_CONTROL_3_ODT_RD_START_DLY_VAL_MASK 0xf00
#define  MC_CH0_DRAM_CONTROL_3_ODT_RD_START_DLY_VAL_SHIFT 8
#define  MC_CH0_DRAM_CONTROL_3_ODT_RD_START_DLY_VAL_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONTROL_3_ODT_RD_START_DLY_VAL_MASK) >> MC_CH0_DRAM_CONTROL_3_ODT_RD_START_DLY_VAL_SHIFT)
#define  MC_CH0_DRAM_CONTROL_3_ODT_RD_START_DLY_VAL_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONTROL_3_ODT_RD_START_DLY_VAL_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONTROL_3_ODT_RD_START_DLY_VAL_SHIFT))

#define  MC_CH0_DRAM_CONTROL_3_ODT_WR_EXTEND_VAL_MASK 0xf0
#define  MC_CH0_DRAM_CONTROL_3_ODT_WR_EXTEND_VAL_SHIFT 4
#define  MC_CH0_DRAM_CONTROL_3_ODT_WR_EXTEND_VAL_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONTROL_3_ODT_WR_EXTEND_VAL_MASK) >> MC_CH0_DRAM_CONTROL_3_ODT_WR_EXTEND_VAL_SHIFT)
#define  MC_CH0_DRAM_CONTROL_3_ODT_WR_EXTEND_VAL_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONTROL_3_ODT_WR_EXTEND_VAL_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONTROL_3_ODT_WR_EXTEND_VAL_SHIFT))

#define  MC_CH0_DRAM_CONTROL_3_ODT_RD_EXTEND_VAL_MASK 0xf
#define  MC_CH0_DRAM_CONTROL_3_ODT_RD_EXTEND_VAL_SHIFT 0
#define  MC_CH0_DRAM_CONTROL_3_ODT_RD_EXTEND_VAL_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CONTROL_3_ODT_RD_EXTEND_VAL_MASK) >> MC_CH0_DRAM_CONTROL_3_ODT_RD_EXTEND_VAL_SHIFT)
#define  MC_CH0_DRAM_CONTROL_3_ODT_RD_EXTEND_VAL_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CONTROL_3_ODT_RD_EXTEND_VAL_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CONTROL_3_ODT_RD_EXTEND_VAL_SHIFT))

//====================================================================
//Register: Mode Register Read Data Register (CH0_MRR_Data)
//====================================================================

#define  MC_CH0_MRR_DATA_MRR_DATA_VALID_MASK 0x80000000
#define  MC_CH0_MRR_DATA_MRR_DATA_VALID_SHIFT 31
#define  MC_CH0_MRR_DATA_MRR_DATA_VALID_MASK_SHIFT(reg) (((reg) & MC_CH0_MRR_DATA_MRR_DATA_VALID_MASK) >> MC_CH0_MRR_DATA_MRR_DATA_VALID_SHIFT)
#define  MC_CH0_MRR_DATA_MRR_DATA_VALID_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_MRR_DATA_MRR_DATA_VALID_MASK) | (((uint32_t)val) << MC_CH0_MRR_DATA_MRR_DATA_VALID_SHIFT))

#define  MC_CH0_MRR_DATA_RESERVED1_MASK 0x7fffff00
#define  MC_CH0_MRR_DATA_RESERVED1_SHIFT 8
#define  MC_CH0_MRR_DATA_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_MRR_DATA_RESERVED1_MASK) >> MC_CH0_MRR_DATA_RESERVED1_SHIFT)
#define  MC_CH0_MRR_DATA_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_MRR_DATA_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_MRR_DATA_RESERVED1_SHIFT))

#define  MC_CH0_MRR_DATA_MRR_DATA_MASK 0xff
#define  MC_CH0_MRR_DATA_MRR_DATA_SHIFT 0
#define  MC_CH0_MRR_DATA_MRR_DATA_MASK_SHIFT(reg) (((reg) & MC_CH0_MRR_DATA_MRR_DATA_MASK) >> MC_CH0_MRR_DATA_MRR_DATA_SHIFT)
#define  MC_CH0_MRR_DATA_MRR_DATA_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_MRR_DATA_MRR_DATA_MASK) | (((uint32_t)val) << MC_CH0_MRR_DATA_MRR_DATA_SHIFT))

//====================================================================
//Register: Multi-Purpose Register Read Data0 Register (CH0_MPR_Data0)
//====================================================================

#define  MC_CH0_MPR_DATA0_MPR_DATA_VALID_MASK 0x80000000
#define  MC_CH0_MPR_DATA0_MPR_DATA_VALID_SHIFT 31
#define  MC_CH0_MPR_DATA0_MPR_DATA_VALID_MASK_SHIFT(reg) (((reg) & MC_CH0_MPR_DATA0_MPR_DATA_VALID_MASK) >> MC_CH0_MPR_DATA0_MPR_DATA_VALID_SHIFT)
#define  MC_CH0_MPR_DATA0_MPR_DATA_VALID_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_MPR_DATA0_MPR_DATA_VALID_MASK) | (((uint32_t)val) << MC_CH0_MPR_DATA0_MPR_DATA_VALID_SHIFT))

#define  MC_CH0_MPR_DATA0_RESERVED1_MASK 0x7fffff00
#define  MC_CH0_MPR_DATA0_RESERVED1_SHIFT 8
#define  MC_CH0_MPR_DATA0_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_MPR_DATA0_RESERVED1_MASK) >> MC_CH0_MPR_DATA0_RESERVED1_SHIFT)
#define  MC_CH0_MPR_DATA0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_MPR_DATA0_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_MPR_DATA0_RESERVED1_SHIFT))

#define  MC_CH0_MPR_DATA0_MPR_DATA_MASK 0xff
#define  MC_CH0_MPR_DATA0_MPR_DATA_SHIFT 0
#define  MC_CH0_MPR_DATA0_MPR_DATA_MASK_SHIFT(reg) (((reg) & MC_CH0_MPR_DATA0_MPR_DATA_MASK) >> MC_CH0_MPR_DATA0_MPR_DATA_SHIFT)
#define  MC_CH0_MPR_DATA0_MPR_DATA_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_MPR_DATA0_MPR_DATA_MASK) | (((uint32_t)val) << MC_CH0_MPR_DATA0_MPR_DATA_SHIFT))

//====================================================================
//Register: Multi-Purpose Register Read Data1 Register (CH0_MPR_Data1)
//====================================================================

#define  MC_CH0_MPR_DATA1_MPR_DATA_VALID_MASK 0x80000000
#define  MC_CH0_MPR_DATA1_MPR_DATA_VALID_SHIFT 31
#define  MC_CH0_MPR_DATA1_MPR_DATA_VALID_MASK_SHIFT(reg) (((reg) & MC_CH0_MPR_DATA1_MPR_DATA_VALID_MASK) >> MC_CH0_MPR_DATA1_MPR_DATA_VALID_SHIFT)
#define  MC_CH0_MPR_DATA1_MPR_DATA_VALID_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_MPR_DATA1_MPR_DATA_VALID_MASK) | (((uint32_t)val) << MC_CH0_MPR_DATA1_MPR_DATA_VALID_SHIFT))

#define  MC_CH0_MPR_DATA1_RESERVED1_MASK 0x7fffff00
#define  MC_CH0_MPR_DATA1_RESERVED1_SHIFT 8
#define  MC_CH0_MPR_DATA1_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_MPR_DATA1_RESERVED1_MASK) >> MC_CH0_MPR_DATA1_RESERVED1_SHIFT)
#define  MC_CH0_MPR_DATA1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_MPR_DATA1_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_MPR_DATA1_RESERVED1_SHIFT))

#define  MC_CH0_MPR_DATA1_MPR_DATA_MASK 0xff
#define  MC_CH0_MPR_DATA1_MPR_DATA_SHIFT 0
#define  MC_CH0_MPR_DATA1_MPR_DATA_MASK_SHIFT(reg) (((reg) & MC_CH0_MPR_DATA1_MPR_DATA_MASK) >> MC_CH0_MPR_DATA1_MPR_DATA_SHIFT)
#define  MC_CH0_MPR_DATA1_MPR_DATA_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_MPR_DATA1_MPR_DATA_MASK) | (((uint32_t)val) << MC_CH0_MPR_DATA1_MPR_DATA_SHIFT))

//====================================================================
//Register: DRAM Initialization Timing Control Register 0 (CH0_DDR_init_timing_control_0)
//====================================================================

#define  MC_CH0_DDR_INIT_TIMING_CONTROL_0_RESERVED1_MASK 0xfff00000
#define  MC_CH0_DDR_INIT_TIMING_CONTROL_0_RESERVED1_SHIFT 20
#define  MC_CH0_DDR_INIT_TIMING_CONTROL_0_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_DDR_INIT_TIMING_CONTROL_0_RESERVED1_MASK) >> MC_CH0_DDR_INIT_TIMING_CONTROL_0_RESERVED1_SHIFT)
#define  MC_CH0_DDR_INIT_TIMING_CONTROL_0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DDR_INIT_TIMING_CONTROL_0_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_DDR_INIT_TIMING_CONTROL_0_RESERVED1_SHIFT))

#define  MC_CH0_DDR_INIT_TIMING_CONTROL_0_INIT_COUNT_NOP_MASK 0xfffff
#define  MC_CH0_DDR_INIT_TIMING_CONTROL_0_INIT_COUNT_NOP_SHIFT 0
#define  MC_CH0_DDR_INIT_TIMING_CONTROL_0_INIT_COUNT_NOP_MASK_SHIFT(reg) (((reg) & MC_CH0_DDR_INIT_TIMING_CONTROL_0_INIT_COUNT_NOP_MASK) >> MC_CH0_DDR_INIT_TIMING_CONTROL_0_INIT_COUNT_NOP_SHIFT)
#define  MC_CH0_DDR_INIT_TIMING_CONTROL_0_INIT_COUNT_NOP_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DDR_INIT_TIMING_CONTROL_0_INIT_COUNT_NOP_MASK) | (((uint32_t)val) << MC_CH0_DDR_INIT_TIMING_CONTROL_0_INIT_COUNT_NOP_SHIFT))

//====================================================================
//Register: DRAM Initialization Timing Control Register 1 (CH0_DDR_init_timing_control_1)
//====================================================================

#define  MC_CH0_DDR_INIT_TIMING_CONTROL_1_RESERVED1_MASK 0x80000000
#define  MC_CH0_DDR_INIT_TIMING_CONTROL_1_RESERVED1_SHIFT 31
#define  MC_CH0_DDR_INIT_TIMING_CONTROL_1_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_DDR_INIT_TIMING_CONTROL_1_RESERVED1_MASK) >> MC_CH0_DDR_INIT_TIMING_CONTROL_1_RESERVED1_SHIFT)
#define  MC_CH0_DDR_INIT_TIMING_CONTROL_1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DDR_INIT_TIMING_CONTROL_1_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_DDR_INIT_TIMING_CONTROL_1_RESERVED1_SHIFT))

#define  MC_CH0_DDR_INIT_TIMING_CONTROL_1_RESET_COUNT_MASK 0x7ffc0000
#define  MC_CH0_DDR_INIT_TIMING_CONTROL_1_RESET_COUNT_SHIFT 18
#define  MC_CH0_DDR_INIT_TIMING_CONTROL_1_RESET_COUNT_MASK_SHIFT(reg) (((reg) & MC_CH0_DDR_INIT_TIMING_CONTROL_1_RESET_COUNT_MASK) >> MC_CH0_DDR_INIT_TIMING_CONTROL_1_RESET_COUNT_SHIFT)
#define  MC_CH0_DDR_INIT_TIMING_CONTROL_1_RESET_COUNT_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DDR_INIT_TIMING_CONTROL_1_RESET_COUNT_MASK) | (((uint32_t)val) << MC_CH0_DDR_INIT_TIMING_CONTROL_1_RESET_COUNT_SHIFT))

#define  MC_CH0_DDR_INIT_TIMING_CONTROL_1_INIT_COUNT_MASK 0x3ffff
#define  MC_CH0_DDR_INIT_TIMING_CONTROL_1_INIT_COUNT_SHIFT 0
#define  MC_CH0_DDR_INIT_TIMING_CONTROL_1_INIT_COUNT_MASK_SHIFT(reg) (((reg) & MC_CH0_DDR_INIT_TIMING_CONTROL_1_INIT_COUNT_MASK) >> MC_CH0_DDR_INIT_TIMING_CONTROL_1_INIT_COUNT_SHIFT)
#define  MC_CH0_DDR_INIT_TIMING_CONTROL_1_INIT_COUNT_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DDR_INIT_TIMING_CONTROL_1_INIT_COUNT_MASK) | (((uint32_t)val) << MC_CH0_DDR_INIT_TIMING_CONTROL_1_INIT_COUNT_SHIFT))

//====================================================================
//Register: DRAM ZQC Timing Register 0 (CH0_ZQC_Timing_0)
//====================================================================

#define  MC_CH0_ZQC_TIMING_0_RESERVED1_MASK 0xff800000
#define  MC_CH0_ZQC_TIMING_0_RESERVED1_SHIFT 23
#define  MC_CH0_ZQC_TIMING_0_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_ZQC_TIMING_0_RESERVED1_MASK) >> MC_CH0_ZQC_TIMING_0_RESERVED1_SHIFT)
#define  MC_CH0_ZQC_TIMING_0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_ZQC_TIMING_0_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_ZQC_TIMING_0_RESERVED1_SHIFT))

#define  MC_CH0_ZQC_TIMING_0_TZQCR_MASK 0x7f0000
#define  MC_CH0_ZQC_TIMING_0_TZQCR_SHIFT 16
#define  MC_CH0_ZQC_TIMING_0_TZQCR_MASK_SHIFT(reg) (((reg) & MC_CH0_ZQC_TIMING_0_TZQCR_MASK) >> MC_CH0_ZQC_TIMING_0_TZQCR_SHIFT)
#define  MC_CH0_ZQC_TIMING_0_TZQCR_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_ZQC_TIMING_0_TZQCR_MASK) | (((uint32_t)val) << MC_CH0_ZQC_TIMING_0_TZQCR_SHIFT))

#define  MC_CH0_ZQC_TIMING_0_RESERVED2_MASK 0xf800
#define  MC_CH0_ZQC_TIMING_0_RESERVED2_SHIFT 11
#define  MC_CH0_ZQC_TIMING_0_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_CH0_ZQC_TIMING_0_RESERVED2_MASK) >> MC_CH0_ZQC_TIMING_0_RESERVED2_SHIFT)
#define  MC_CH0_ZQC_TIMING_0_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_ZQC_TIMING_0_RESERVED2_MASK) | (((uint32_t)val) << MC_CH0_ZQC_TIMING_0_RESERVED2_SHIFT))

#define  MC_CH0_ZQC_TIMING_0_TZQINIT_MASK 0x7ff
#define  MC_CH0_ZQC_TIMING_0_TZQINIT_SHIFT 0
#define  MC_CH0_ZQC_TIMING_0_TZQINIT_MASK_SHIFT(reg) (((reg) & MC_CH0_ZQC_TIMING_0_TZQINIT_MASK) >> MC_CH0_ZQC_TIMING_0_TZQINIT_SHIFT)
#define  MC_CH0_ZQC_TIMING_0_TZQINIT_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_ZQC_TIMING_0_TZQINIT_MASK) | (((uint32_t)val) << MC_CH0_ZQC_TIMING_0_TZQINIT_SHIFT))

//====================================================================
//Register: DRAM ZQC Timing Register 1 (CH0_ZQC_Timing_1)
//====================================================================

#define  MC_CH0_ZQC_TIMING_1_RESERVED1_MASK 0xff000000
#define  MC_CH0_ZQC_TIMING_1_RESERVED1_SHIFT 24
#define  MC_CH0_ZQC_TIMING_1_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_ZQC_TIMING_1_RESERVED1_MASK) >> MC_CH0_ZQC_TIMING_1_RESERVED1_SHIFT)
#define  MC_CH0_ZQC_TIMING_1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_ZQC_TIMING_1_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_ZQC_TIMING_1_RESERVED1_SHIFT))

#define  MC_CH0_ZQC_TIMING_1_TZQCS_MASK 0xff0000
#define  MC_CH0_ZQC_TIMING_1_TZQCS_SHIFT 16
#define  MC_CH0_ZQC_TIMING_1_TZQCS_MASK_SHIFT(reg) (((reg) & MC_CH0_ZQC_TIMING_1_TZQCS_MASK) >> MC_CH0_ZQC_TIMING_1_TZQCS_SHIFT)
#define  MC_CH0_ZQC_TIMING_1_TZQCS_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_ZQC_TIMING_1_TZQCS_MASK) | (((uint32_t)val) << MC_CH0_ZQC_TIMING_1_TZQCS_SHIFT))

#define  MC_CH0_ZQC_TIMING_1_RESERVED2_MASK 0xfc00
#define  MC_CH0_ZQC_TIMING_1_RESERVED2_SHIFT 10
#define  MC_CH0_ZQC_TIMING_1_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_CH0_ZQC_TIMING_1_RESERVED2_MASK) >> MC_CH0_ZQC_TIMING_1_RESERVED2_SHIFT)
#define  MC_CH0_ZQC_TIMING_1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_ZQC_TIMING_1_RESERVED2_MASK) | (((uint32_t)val) << MC_CH0_ZQC_TIMING_1_RESERVED2_SHIFT))

#define  MC_CH0_ZQC_TIMING_1_TZQOPER_MASK 0x3ff
#define  MC_CH0_ZQC_TIMING_1_TZQOPER_SHIFT 0
#define  MC_CH0_ZQC_TIMING_1_TZQOPER_MASK_SHIFT(reg) (((reg) & MC_CH0_ZQC_TIMING_1_TZQOPER_MASK) >> MC_CH0_ZQC_TIMING_1_TZQOPER_SHIFT)
#define  MC_CH0_ZQC_TIMING_1_TZQOPER_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_ZQC_TIMING_1_TZQOPER_MASK) | (((uint32_t)val) << MC_CH0_ZQC_TIMING_1_TZQOPER_SHIFT))

//====================================================================
//Register: DRAM Refresh Timing Register (CH0_Refresh_timing)
//====================================================================

#define  MC_CH0_REFRESH_TIMING_RESERVED1_MASK 0xf8000000
#define  MC_CH0_REFRESH_TIMING_RESERVED1_SHIFT 27
#define  MC_CH0_REFRESH_TIMING_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_REFRESH_TIMING_RESERVED1_MASK) >> MC_CH0_REFRESH_TIMING_RESERVED1_SHIFT)
#define  MC_CH0_REFRESH_TIMING_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_REFRESH_TIMING_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_REFRESH_TIMING_RESERVED1_SHIFT))

#define  MC_CH0_REFRESH_TIMING_TRFC_MASK 0x7ff0000
#define  MC_CH0_REFRESH_TIMING_TRFC_SHIFT 16
#define  MC_CH0_REFRESH_TIMING_TRFC_MASK_SHIFT(reg) (((reg) & MC_CH0_REFRESH_TIMING_TRFC_MASK) >> MC_CH0_REFRESH_TIMING_TRFC_SHIFT)
#define  MC_CH0_REFRESH_TIMING_TRFC_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_REFRESH_TIMING_TRFC_MASK) | (((uint32_t)val) << MC_CH0_REFRESH_TIMING_TRFC_SHIFT))

#define  MC_CH0_REFRESH_TIMING_RESERVED2_MASK 0xc000
#define  MC_CH0_REFRESH_TIMING_RESERVED2_SHIFT 14
#define  MC_CH0_REFRESH_TIMING_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_CH0_REFRESH_TIMING_RESERVED2_MASK) >> MC_CH0_REFRESH_TIMING_RESERVED2_SHIFT)
#define  MC_CH0_REFRESH_TIMING_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_REFRESH_TIMING_RESERVED2_MASK) | (((uint32_t)val) << MC_CH0_REFRESH_TIMING_RESERVED2_SHIFT))

#define  MC_CH0_REFRESH_TIMING_TREFI_MASK 0x3fff
#define  MC_CH0_REFRESH_TIMING_TREFI_SHIFT 0
#define  MC_CH0_REFRESH_TIMING_TREFI_MASK_SHIFT(reg) (((reg) & MC_CH0_REFRESH_TIMING_TREFI_MASK) >> MC_CH0_REFRESH_TIMING_TREFI_SHIFT)
#define  MC_CH0_REFRESH_TIMING_TREFI_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_REFRESH_TIMING_TREFI_MASK) | (((uint32_t)val) << MC_CH0_REFRESH_TIMING_TREFI_SHIFT))

//====================================================================
//Register: DRAM Self-refresh Timing Register (CH0_SelfRefresh_timing)
//====================================================================

#define  MC_CH0_SELFREFRESH_TIMING_TCKSRE_MASK 0xf0000000
#define  MC_CH0_SELFREFRESH_TIMING_TCKSRE_SHIFT 28
#define  MC_CH0_SELFREFRESH_TIMING_TCKSRE_MASK_SHIFT(reg) (((reg) & MC_CH0_SELFREFRESH_TIMING_TCKSRE_MASK) >> MC_CH0_SELFREFRESH_TIMING_TCKSRE_SHIFT)
#define  MC_CH0_SELFREFRESH_TIMING_TCKSRE_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_SELFREFRESH_TIMING_TCKSRE_MASK) | (((uint32_t)val) << MC_CH0_SELFREFRESH_TIMING_TCKSRE_SHIFT))

#define  MC_CH0_SELFREFRESH_TIMING_RESERVED1_MASK 0x8000000
#define  MC_CH0_SELFREFRESH_TIMING_RESERVED1_SHIFT 27
#define  MC_CH0_SELFREFRESH_TIMING_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_SELFREFRESH_TIMING_RESERVED1_MASK) >> MC_CH0_SELFREFRESH_TIMING_RESERVED1_SHIFT)
#define  MC_CH0_SELFREFRESH_TIMING_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_SELFREFRESH_TIMING_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_SELFREFRESH_TIMING_RESERVED1_SHIFT))

#define  MC_CH0_SELFREFRESH_TIMING_TXSNR_MASK 0x7ff0000
#define  MC_CH0_SELFREFRESH_TIMING_TXSNR_SHIFT 16
#define  MC_CH0_SELFREFRESH_TIMING_TXSNR_MASK_SHIFT(reg) (((reg) & MC_CH0_SELFREFRESH_TIMING_TXSNR_MASK) >> MC_CH0_SELFREFRESH_TIMING_TXSNR_SHIFT)
#define  MC_CH0_SELFREFRESH_TIMING_TXSNR_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_SELFREFRESH_TIMING_TXSNR_MASK) | (((uint32_t)val) << MC_CH0_SELFREFRESH_TIMING_TXSNR_SHIFT))

#define  MC_CH0_SELFREFRESH_TIMING_TCKSRX_MASK 0xf000
#define  MC_CH0_SELFREFRESH_TIMING_TCKSRX_SHIFT 12
#define  MC_CH0_SELFREFRESH_TIMING_TCKSRX_MASK_SHIFT(reg) (((reg) & MC_CH0_SELFREFRESH_TIMING_TCKSRX_MASK) >> MC_CH0_SELFREFRESH_TIMING_TCKSRX_SHIFT)
#define  MC_CH0_SELFREFRESH_TIMING_TCKSRX_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_SELFREFRESH_TIMING_TCKSRX_MASK) | (((uint32_t)val) << MC_CH0_SELFREFRESH_TIMING_TCKSRX_SHIFT))

#define  MC_CH0_SELFREFRESH_TIMING_RESERVED2_MASK 0xc00
#define  MC_CH0_SELFREFRESH_TIMING_RESERVED2_SHIFT 10
#define  MC_CH0_SELFREFRESH_TIMING_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_CH0_SELFREFRESH_TIMING_RESERVED2_MASK) >> MC_CH0_SELFREFRESH_TIMING_RESERVED2_SHIFT)
#define  MC_CH0_SELFREFRESH_TIMING_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_SELFREFRESH_TIMING_RESERVED2_MASK) | (((uint32_t)val) << MC_CH0_SELFREFRESH_TIMING_RESERVED2_SHIFT))

#define  MC_CH0_SELFREFRESH_TIMING_TXSRD_MASK 0x3ff
#define  MC_CH0_SELFREFRESH_TIMING_TXSRD_SHIFT 0
#define  MC_CH0_SELFREFRESH_TIMING_TXSRD_MASK_SHIFT(reg) (((reg) & MC_CH0_SELFREFRESH_TIMING_TXSRD_MASK) >> MC_CH0_SELFREFRESH_TIMING_TXSRD_SHIFT)
#define  MC_CH0_SELFREFRESH_TIMING_TXSRD_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_SELFREFRESH_TIMING_TXSRD_MASK) | (((uint32_t)val) << MC_CH0_SELFREFRESH_TIMING_TXSRD_SHIFT))

//====================================================================
//Register: DRAM Power-down Timing Register (CH0_PowerDown_timing)
//====================================================================

#define  MC_CH0_POWERDOWN_TIMING_RESERVED1_MASK 0x80000000
#define  MC_CH0_POWERDOWN_TIMING_RESERVED1_SHIFT 31
#define  MC_CH0_POWERDOWN_TIMING_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_POWERDOWN_TIMING_RESERVED1_MASK) >> MC_CH0_POWERDOWN_TIMING_RESERVED1_SHIFT)
#define  MC_CH0_POWERDOWN_TIMING_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_POWERDOWN_TIMING_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_POWERDOWN_TIMING_RESERVED1_SHIFT))

#define  MC_CH0_POWERDOWN_TIMING_TPDEN_MASK 0x70000000
#define  MC_CH0_POWERDOWN_TIMING_TPDEN_SHIFT 28
#define  MC_CH0_POWERDOWN_TIMING_TPDEN_MASK_SHIFT(reg) (((reg) & MC_CH0_POWERDOWN_TIMING_TPDEN_MASK) >> MC_CH0_POWERDOWN_TIMING_TPDEN_SHIFT)
#define  MC_CH0_POWERDOWN_TIMING_TPDEN_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_POWERDOWN_TIMING_TPDEN_MASK) | (((uint32_t)val) << MC_CH0_POWERDOWN_TIMING_TPDEN_SHIFT))

#define  MC_CH0_POWERDOWN_TIMING_RESERVED2_MASK 0x8000000
#define  MC_CH0_POWERDOWN_TIMING_RESERVED2_SHIFT 27
#define  MC_CH0_POWERDOWN_TIMING_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_CH0_POWERDOWN_TIMING_RESERVED2_MASK) >> MC_CH0_POWERDOWN_TIMING_RESERVED2_SHIFT)
#define  MC_CH0_POWERDOWN_TIMING_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_POWERDOWN_TIMING_RESERVED2_MASK) | (((uint32_t)val) << MC_CH0_POWERDOWN_TIMING_RESERVED2_SHIFT))

#define  MC_CH0_POWERDOWN_TIMING_TCPDED_MASK 0x7000000
#define  MC_CH0_POWERDOWN_TIMING_TCPDED_SHIFT 24
#define  MC_CH0_POWERDOWN_TIMING_TCPDED_MASK_SHIFT(reg) (((reg) & MC_CH0_POWERDOWN_TIMING_TCPDED_MASK) >> MC_CH0_POWERDOWN_TIMING_TCPDED_SHIFT)
#define  MC_CH0_POWERDOWN_TIMING_TCPDED_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_POWERDOWN_TIMING_TCPDED_MASK) | (((uint32_t)val) << MC_CH0_POWERDOWN_TIMING_TCPDED_SHIFT))

#define  MC_CH0_POWERDOWN_TIMING_RESERVED3_MASK 0xf00000
#define  MC_CH0_POWERDOWN_TIMING_RESERVED3_SHIFT 20
#define  MC_CH0_POWERDOWN_TIMING_RESERVED3_MASK_SHIFT(reg) (((reg) & MC_CH0_POWERDOWN_TIMING_RESERVED3_MASK) >> MC_CH0_POWERDOWN_TIMING_RESERVED3_SHIFT)
#define  MC_CH0_POWERDOWN_TIMING_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_POWERDOWN_TIMING_RESERVED3_MASK) | (((uint32_t)val) << MC_CH0_POWERDOWN_TIMING_RESERVED3_SHIFT))

#define  MC_CH0_POWERDOWN_TIMING_TCKESR_MASK 0xf0000
#define  MC_CH0_POWERDOWN_TIMING_TCKESR_SHIFT 16
#define  MC_CH0_POWERDOWN_TIMING_TCKESR_MASK_SHIFT(reg) (((reg) & MC_CH0_POWERDOWN_TIMING_TCKESR_MASK) >> MC_CH0_POWERDOWN_TIMING_TCKESR_SHIFT)
#define  MC_CH0_POWERDOWN_TIMING_TCKESR_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_POWERDOWN_TIMING_TCKESR_MASK) | (((uint32_t)val) << MC_CH0_POWERDOWN_TIMING_TCKESR_SHIFT))

#define  MC_CH0_POWERDOWN_TIMING_RESERVED4_MASK 0xf000
#define  MC_CH0_POWERDOWN_TIMING_RESERVED4_SHIFT 12
#define  MC_CH0_POWERDOWN_TIMING_RESERVED4_MASK_SHIFT(reg) (((reg) & MC_CH0_POWERDOWN_TIMING_RESERVED4_MASK) >> MC_CH0_POWERDOWN_TIMING_RESERVED4_SHIFT)
#define  MC_CH0_POWERDOWN_TIMING_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_POWERDOWN_TIMING_RESERVED4_MASK) | (((uint32_t)val) << MC_CH0_POWERDOWN_TIMING_RESERVED4_SHIFT))

#define  MC_CH0_POWERDOWN_TIMING_TXP_MASK 0xf00
#define  MC_CH0_POWERDOWN_TIMING_TXP_SHIFT 8
#define  MC_CH0_POWERDOWN_TIMING_TXP_MASK_SHIFT(reg) (((reg) & MC_CH0_POWERDOWN_TIMING_TXP_MASK) >> MC_CH0_POWERDOWN_TIMING_TXP_SHIFT)
#define  MC_CH0_POWERDOWN_TIMING_TXP_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_POWERDOWN_TIMING_TXP_MASK) | (((uint32_t)val) << MC_CH0_POWERDOWN_TIMING_TXP_SHIFT))

#define  MC_CH0_POWERDOWN_TIMING_RESERVED5_MASK 0xe0
#define  MC_CH0_POWERDOWN_TIMING_RESERVED5_SHIFT 5
#define  MC_CH0_POWERDOWN_TIMING_RESERVED5_MASK_SHIFT(reg) (((reg) & MC_CH0_POWERDOWN_TIMING_RESERVED5_MASK) >> MC_CH0_POWERDOWN_TIMING_RESERVED5_SHIFT)
#define  MC_CH0_POWERDOWN_TIMING_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_POWERDOWN_TIMING_RESERVED5_MASK) | (((uint32_t)val) << MC_CH0_POWERDOWN_TIMING_RESERVED5_SHIFT))

#define  MC_CH0_POWERDOWN_TIMING_TXARDS_MASK 0x1f
#define  MC_CH0_POWERDOWN_TIMING_TXARDS_SHIFT 0
#define  MC_CH0_POWERDOWN_TIMING_TXARDS_MASK_SHIFT(reg) (((reg) & MC_CH0_POWERDOWN_TIMING_TXARDS_MASK) >> MC_CH0_POWERDOWN_TIMING_TXARDS_SHIFT)
#define  MC_CH0_POWERDOWN_TIMING_TXARDS_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_POWERDOWN_TIMING_TXARDS_MASK) | (((uint32_t)val) << MC_CH0_POWERDOWN_TIMING_TXARDS_SHIFT))

//====================================================================
//Register: DRAM MRS Timing Register (CH0_MRS_timing)
//====================================================================

#define  MC_CH0_MRS_TIMING_RESERVED1_MASK 0xfffffe00
#define  MC_CH0_MRS_TIMING_RESERVED1_SHIFT 9
#define  MC_CH0_MRS_TIMING_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_MRS_TIMING_RESERVED1_MASK) >> MC_CH0_MRS_TIMING_RESERVED1_SHIFT)
#define  MC_CH0_MRS_TIMING_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_MRS_TIMING_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_MRS_TIMING_RESERVED1_SHIFT))

#define  MC_CH0_MRS_TIMING_TMOD_MASK 0x1f0
#define  MC_CH0_MRS_TIMING_TMOD_SHIFT 4
#define  MC_CH0_MRS_TIMING_TMOD_MASK_SHIFT(reg) (((reg) & MC_CH0_MRS_TIMING_TMOD_MASK) >> MC_CH0_MRS_TIMING_TMOD_SHIFT)
#define  MC_CH0_MRS_TIMING_TMOD_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_MRS_TIMING_TMOD_MASK) | (((uint32_t)val) << MC_CH0_MRS_TIMING_TMOD_SHIFT))

#define  MC_CH0_MRS_TIMING_TMRD_MASK 0xf
#define  MC_CH0_MRS_TIMING_TMRD_SHIFT 0
#define  MC_CH0_MRS_TIMING_TMRD_MASK_SHIFT(reg) (((reg) & MC_CH0_MRS_TIMING_TMRD_MASK) >> MC_CH0_MRS_TIMING_TMRD_SHIFT)
#define  MC_CH0_MRS_TIMING_TMRD_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_MRS_TIMING_TMRD_MASK) | (((uint32_t)val) << MC_CH0_MRS_TIMING_TMRD_SHIFT))

//====================================================================
//Register: DRAM Activate Timing Register (CH0_ACT_timing)
//====================================================================

#define  MC_CH0_ACT_TIMING_RESERVED1_MASK 0xc0000000
#define  MC_CH0_ACT_TIMING_RESERVED1_SHIFT 30
#define  MC_CH0_ACT_TIMING_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_ACT_TIMING_RESERVED1_MASK) >> MC_CH0_ACT_TIMING_RESERVED1_SHIFT)
#define  MC_CH0_ACT_TIMING_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_ACT_TIMING_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_ACT_TIMING_RESERVED1_SHIFT))

#define  MC_CH0_ACT_TIMING_TFAW_MASK 0x3f000000
#define  MC_CH0_ACT_TIMING_TFAW_SHIFT 24
#define  MC_CH0_ACT_TIMING_TFAW_MASK_SHIFT(reg) (((reg) & MC_CH0_ACT_TIMING_TFAW_MASK) >> MC_CH0_ACT_TIMING_TFAW_SHIFT)
#define  MC_CH0_ACT_TIMING_TFAW_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_ACT_TIMING_TFAW_MASK) | (((uint32_t)val) << MC_CH0_ACT_TIMING_TFAW_SHIFT))

#define  MC_CH0_ACT_TIMING_RESERVED2_MASK 0x800000
#define  MC_CH0_ACT_TIMING_RESERVED2_SHIFT 23
#define  MC_CH0_ACT_TIMING_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_CH0_ACT_TIMING_RESERVED2_MASK) >> MC_CH0_ACT_TIMING_RESERVED2_SHIFT)
#define  MC_CH0_ACT_TIMING_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_ACT_TIMING_RESERVED2_MASK) | (((uint32_t)val) << MC_CH0_ACT_TIMING_RESERVED2_SHIFT))

#define  MC_CH0_ACT_TIMING_TRC_MASK 0x7f0000
#define  MC_CH0_ACT_TIMING_TRC_SHIFT 16
#define  MC_CH0_ACT_TIMING_TRC_MASK_SHIFT(reg) (((reg) & MC_CH0_ACT_TIMING_TRC_MASK) >> MC_CH0_ACT_TIMING_TRC_SHIFT)
#define  MC_CH0_ACT_TIMING_TRC_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_ACT_TIMING_TRC_MASK) | (((uint32_t)val) << MC_CH0_ACT_TIMING_TRC_SHIFT))

#define  MC_CH0_ACT_TIMING_RESERVED3_MASK 0xe000
#define  MC_CH0_ACT_TIMING_RESERVED3_SHIFT 13
#define  MC_CH0_ACT_TIMING_RESERVED3_MASK_SHIFT(reg) (((reg) & MC_CH0_ACT_TIMING_RESERVED3_MASK) >> MC_CH0_ACT_TIMING_RESERVED3_SHIFT)
#define  MC_CH0_ACT_TIMING_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_ACT_TIMING_RESERVED3_MASK) | (((uint32_t)val) << MC_CH0_ACT_TIMING_RESERVED3_SHIFT))

#define  MC_CH0_ACT_TIMING_TRCD_MASK 0x1f00
#define  MC_CH0_ACT_TIMING_TRCD_SHIFT 8
#define  MC_CH0_ACT_TIMING_TRCD_MASK_SHIFT(reg) (((reg) & MC_CH0_ACT_TIMING_TRCD_MASK) >> MC_CH0_ACT_TIMING_TRCD_SHIFT)
#define  MC_CH0_ACT_TIMING_TRCD_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_ACT_TIMING_TRCD_MASK) | (((uint32_t)val) << MC_CH0_ACT_TIMING_TRCD_SHIFT))

#define  MC_CH0_ACT_TIMING_RESERVED4_MASK 0xc0
#define  MC_CH0_ACT_TIMING_RESERVED4_SHIFT 6
#define  MC_CH0_ACT_TIMING_RESERVED4_MASK_SHIFT(reg) (((reg) & MC_CH0_ACT_TIMING_RESERVED4_MASK) >> MC_CH0_ACT_TIMING_RESERVED4_SHIFT)
#define  MC_CH0_ACT_TIMING_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_ACT_TIMING_RESERVED4_MASK) | (((uint32_t)val) << MC_CH0_ACT_TIMING_RESERVED4_SHIFT))

#define  MC_CH0_ACT_TIMING_TRAS_MASK 0x3f
#define  MC_CH0_ACT_TIMING_TRAS_SHIFT 0
#define  MC_CH0_ACT_TIMING_TRAS_MASK_SHIFT(reg) (((reg) & MC_CH0_ACT_TIMING_TRAS_MASK) >> MC_CH0_ACT_TIMING_TRAS_SHIFT)
#define  MC_CH0_ACT_TIMING_TRAS_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_ACT_TIMING_TRAS_MASK) | (((uint32_t)val) << MC_CH0_ACT_TIMING_TRAS_SHIFT))

//====================================================================
//Register: DRAM Precharge Timing Register (CH0_PreCharge_Timing)
//====================================================================

#define  MC_CH0_PRECHARGE_TIMING_RESERVED1_MASK 0xfe000000
#define  MC_CH0_PRECHARGE_TIMING_RESERVED1_SHIFT 25
#define  MC_CH0_PRECHARGE_TIMING_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_PRECHARGE_TIMING_RESERVED1_MASK) >> MC_CH0_PRECHARGE_TIMING_RESERVED1_SHIFT)
#define  MC_CH0_PRECHARGE_TIMING_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PRECHARGE_TIMING_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_PRECHARGE_TIMING_RESERVED1_SHIFT))

#define  MC_CH0_PRECHARGE_TIMING_TRPA_MASK 0x1f00000
#define  MC_CH0_PRECHARGE_TIMING_TRPA_SHIFT 20
#define  MC_CH0_PRECHARGE_TIMING_TRPA_MASK_SHIFT(reg) (((reg) & MC_CH0_PRECHARGE_TIMING_TRPA_MASK) >> MC_CH0_PRECHARGE_TIMING_TRPA_SHIFT)
#define  MC_CH0_PRECHARGE_TIMING_TRPA_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PRECHARGE_TIMING_TRPA_MASK) | (((uint32_t)val) << MC_CH0_PRECHARGE_TIMING_TRPA_SHIFT))

#define  MC_CH0_PRECHARGE_TIMING_RESERVED2_MASK 0xe0000
#define  MC_CH0_PRECHARGE_TIMING_RESERVED2_SHIFT 17
#define  MC_CH0_PRECHARGE_TIMING_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_CH0_PRECHARGE_TIMING_RESERVED2_MASK) >> MC_CH0_PRECHARGE_TIMING_RESERVED2_SHIFT)
#define  MC_CH0_PRECHARGE_TIMING_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PRECHARGE_TIMING_RESERVED2_MASK) | (((uint32_t)val) << MC_CH0_PRECHARGE_TIMING_RESERVED2_SHIFT))

#define  MC_CH0_PRECHARGE_TIMING_TWR_MASK 0x1f000
#define  MC_CH0_PRECHARGE_TIMING_TWR_SHIFT 12
#define  MC_CH0_PRECHARGE_TIMING_TWR_MASK_SHIFT(reg) (((reg) & MC_CH0_PRECHARGE_TIMING_TWR_MASK) >> MC_CH0_PRECHARGE_TIMING_TWR_SHIFT)
#define  MC_CH0_PRECHARGE_TIMING_TWR_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PRECHARGE_TIMING_TWR_MASK) | (((uint32_t)val) << MC_CH0_PRECHARGE_TIMING_TWR_SHIFT))

#define  MC_CH0_PRECHARGE_TIMING_TRTP_MASK 0xf00
#define  MC_CH0_PRECHARGE_TIMING_TRTP_SHIFT 8
#define  MC_CH0_PRECHARGE_TIMING_TRTP_MASK_SHIFT(reg) (((reg) & MC_CH0_PRECHARGE_TIMING_TRTP_MASK) >> MC_CH0_PRECHARGE_TIMING_TRTP_SHIFT)
#define  MC_CH0_PRECHARGE_TIMING_TRTP_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PRECHARGE_TIMING_TRTP_MASK) | (((uint32_t)val) << MC_CH0_PRECHARGE_TIMING_TRTP_SHIFT))

#define  MC_CH0_PRECHARGE_TIMING_RESERVED3_MASK 0xe0
#define  MC_CH0_PRECHARGE_TIMING_RESERVED3_SHIFT 5
#define  MC_CH0_PRECHARGE_TIMING_RESERVED3_MASK_SHIFT(reg) (((reg) & MC_CH0_PRECHARGE_TIMING_RESERVED3_MASK) >> MC_CH0_PRECHARGE_TIMING_RESERVED3_SHIFT)
#define  MC_CH0_PRECHARGE_TIMING_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PRECHARGE_TIMING_RESERVED3_MASK) | (((uint32_t)val) << MC_CH0_PRECHARGE_TIMING_RESERVED3_SHIFT))

#define  MC_CH0_PRECHARGE_TIMING_TRP_MASK 0x1f
#define  MC_CH0_PRECHARGE_TIMING_TRP_SHIFT 0
#define  MC_CH0_PRECHARGE_TIMING_TRP_MASK_SHIFT(reg) (((reg) & MC_CH0_PRECHARGE_TIMING_TRP_MASK) >> MC_CH0_PRECHARGE_TIMING_TRP_SHIFT)
#define  MC_CH0_PRECHARGE_TIMING_TRP_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PRECHARGE_TIMING_TRP_MASK) | (((uint32_t)val) << MC_CH0_PRECHARGE_TIMING_TRP_SHIFT))

//====================================================================
//Register: DRAM CAS/RAS Timing Register (CH0_CAS_RAS_timing)
//====================================================================

#define  MC_CH0_CAS_RAS_TIMING_TRRD_MASK 0xf0000000
#define  MC_CH0_CAS_RAS_TIMING_TRRD_SHIFT 28
#define  MC_CH0_CAS_RAS_TIMING_TRRD_MASK_SHIFT(reg) (((reg) & MC_CH0_CAS_RAS_TIMING_TRRD_MASK) >> MC_CH0_CAS_RAS_TIMING_TRRD_SHIFT)
#define  MC_CH0_CAS_RAS_TIMING_TRRD_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_CAS_RAS_TIMING_TRRD_MASK) | (((uint32_t)val) << MC_CH0_CAS_RAS_TIMING_TRRD_SHIFT))

#define  MC_CH0_CAS_RAS_TIMING_TRRD_S_MASK 0xf000000
#define  MC_CH0_CAS_RAS_TIMING_TRRD_S_SHIFT 24
#define  MC_CH0_CAS_RAS_TIMING_TRRD_S_MASK_SHIFT(reg) (((reg) & MC_CH0_CAS_RAS_TIMING_TRRD_S_MASK) >> MC_CH0_CAS_RAS_TIMING_TRRD_S_SHIFT)
#define  MC_CH0_CAS_RAS_TIMING_TRRD_S_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_CAS_RAS_TIMING_TRRD_S_MASK) | (((uint32_t)val) << MC_CH0_CAS_RAS_TIMING_TRRD_S_SHIFT))

#define  MC_CH0_CAS_RAS_TIMING_RESERVED1_MASK 0x800000
#define  MC_CH0_CAS_RAS_TIMING_RESERVED1_SHIFT 23
#define  MC_CH0_CAS_RAS_TIMING_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_CAS_RAS_TIMING_RESERVED1_MASK) >> MC_CH0_CAS_RAS_TIMING_RESERVED1_SHIFT)
#define  MC_CH0_CAS_RAS_TIMING_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_CAS_RAS_TIMING_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_CAS_RAS_TIMING_RESERVED1_SHIFT))

#define  MC_CH0_CAS_RAS_TIMING_TCCD_MASK 0x700000
#define  MC_CH0_CAS_RAS_TIMING_TCCD_SHIFT 20
#define  MC_CH0_CAS_RAS_TIMING_TCCD_MASK_SHIFT(reg) (((reg) & MC_CH0_CAS_RAS_TIMING_TCCD_MASK) >> MC_CH0_CAS_RAS_TIMING_TCCD_SHIFT)
#define  MC_CH0_CAS_RAS_TIMING_TCCD_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_CAS_RAS_TIMING_TCCD_MASK) | (((uint32_t)val) << MC_CH0_CAS_RAS_TIMING_TCCD_SHIFT))

#define  MC_CH0_CAS_RAS_TIMING_RESERVED2_MASK 0x80000
#define  MC_CH0_CAS_RAS_TIMING_RESERVED2_SHIFT 19
#define  MC_CH0_CAS_RAS_TIMING_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_CH0_CAS_RAS_TIMING_RESERVED2_MASK) >> MC_CH0_CAS_RAS_TIMING_RESERVED2_SHIFT)
#define  MC_CH0_CAS_RAS_TIMING_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_CAS_RAS_TIMING_RESERVED2_MASK) | (((uint32_t)val) << MC_CH0_CAS_RAS_TIMING_RESERVED2_SHIFT))

#define  MC_CH0_CAS_RAS_TIMING_TCCD_S_MASK 0x70000
#define  MC_CH0_CAS_RAS_TIMING_TCCD_S_SHIFT 16
#define  MC_CH0_CAS_RAS_TIMING_TCCD_S_MASK_SHIFT(reg) (((reg) & MC_CH0_CAS_RAS_TIMING_TCCD_S_MASK) >> MC_CH0_CAS_RAS_TIMING_TCCD_S_SHIFT)
#define  MC_CH0_CAS_RAS_TIMING_TCCD_S_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_CAS_RAS_TIMING_TCCD_S_MASK) | (((uint32_t)val) << MC_CH0_CAS_RAS_TIMING_TCCD_S_SHIFT))

#define  MC_CH0_CAS_RAS_TIMING_RESERVED3_MASK 0xff00
#define  MC_CH0_CAS_RAS_TIMING_RESERVED3_SHIFT 8
#define  MC_CH0_CAS_RAS_TIMING_RESERVED3_MASK_SHIFT(reg) (((reg) & MC_CH0_CAS_RAS_TIMING_RESERVED3_MASK) >> MC_CH0_CAS_RAS_TIMING_RESERVED3_SHIFT)
#define  MC_CH0_CAS_RAS_TIMING_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_CAS_RAS_TIMING_RESERVED3_MASK) | (((uint32_t)val) << MC_CH0_CAS_RAS_TIMING_RESERVED3_SHIFT))

#define  MC_CH0_CAS_RAS_TIMING_TWTR_MASK 0xf0
#define  MC_CH0_CAS_RAS_TIMING_TWTR_SHIFT 4
#define  MC_CH0_CAS_RAS_TIMING_TWTR_MASK_SHIFT(reg) (((reg) & MC_CH0_CAS_RAS_TIMING_TWTR_MASK) >> MC_CH0_CAS_RAS_TIMING_TWTR_SHIFT)
#define  MC_CH0_CAS_RAS_TIMING_TWTR_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_CAS_RAS_TIMING_TWTR_MASK) | (((uint32_t)val) << MC_CH0_CAS_RAS_TIMING_TWTR_SHIFT))

#define  MC_CH0_CAS_RAS_TIMING_TWTR_S_MASK 0xf
#define  MC_CH0_CAS_RAS_TIMING_TWTR_S_SHIFT 0
#define  MC_CH0_CAS_RAS_TIMING_TWTR_S_MASK_SHIFT(reg) (((reg) & MC_CH0_CAS_RAS_TIMING_TWTR_S_MASK) >> MC_CH0_CAS_RAS_TIMING_TWTR_S_SHIFT)
#define  MC_CH0_CAS_RAS_TIMING_TWTR_S_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_CAS_RAS_TIMING_TWTR_S_MASK) | (((uint32_t)val) << MC_CH0_CAS_RAS_TIMING_TWTR_S_SHIFT))

//====================================================================
//Register: DRAM Off-spec timing Register (CH0_Off_spec_timing)
//====================================================================

#define  MC_CH0_OFF_SPEC_TIMING_RESERVED1_MASK 0xfff80000
#define  MC_CH0_OFF_SPEC_TIMING_RESERVED1_SHIFT 19
#define  MC_CH0_OFF_SPEC_TIMING_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_OFF_SPEC_TIMING_RESERVED1_MASK) >> MC_CH0_OFF_SPEC_TIMING_RESERVED1_SHIFT)
#define  MC_CH0_OFF_SPEC_TIMING_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_OFF_SPEC_TIMING_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_OFF_SPEC_TIMING_RESERVED1_SHIFT))

#define  MC_CH0_OFF_SPEC_TIMING_READ_GAP_EXTEND_MASK 0x70000
#define  MC_CH0_OFF_SPEC_TIMING_READ_GAP_EXTEND_SHIFT 16
#define  MC_CH0_OFF_SPEC_TIMING_READ_GAP_EXTEND_MASK_SHIFT(reg) (((reg) & MC_CH0_OFF_SPEC_TIMING_READ_GAP_EXTEND_MASK) >> MC_CH0_OFF_SPEC_TIMING_READ_GAP_EXTEND_SHIFT)
#define  MC_CH0_OFF_SPEC_TIMING_READ_GAP_EXTEND_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_OFF_SPEC_TIMING_READ_GAP_EXTEND_MASK) | (((uint32_t)val) << MC_CH0_OFF_SPEC_TIMING_READ_GAP_EXTEND_SHIFT))

#define  MC_CH0_OFF_SPEC_TIMING_RESERVED2_MASK 0xc000
#define  MC_CH0_OFF_SPEC_TIMING_RESERVED2_SHIFT 14
#define  MC_CH0_OFF_SPEC_TIMING_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_CH0_OFF_SPEC_TIMING_RESERVED2_MASK) >> MC_CH0_OFF_SPEC_TIMING_RESERVED2_SHIFT)
#define  MC_CH0_OFF_SPEC_TIMING_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_OFF_SPEC_TIMING_RESERVED2_MASK) | (((uint32_t)val) << MC_CH0_OFF_SPEC_TIMING_RESERVED2_SHIFT))

#define  MC_CH0_OFF_SPEC_TIMING_TWL_EARLY_MASK 0x3000
#define  MC_CH0_OFF_SPEC_TIMING_TWL_EARLY_SHIFT 12
#define  MC_CH0_OFF_SPEC_TIMING_TWL_EARLY_MASK_SHIFT(reg) (((reg) & MC_CH0_OFF_SPEC_TIMING_TWL_EARLY_MASK) >> MC_CH0_OFF_SPEC_TIMING_TWL_EARLY_SHIFT)
#define  MC_CH0_OFF_SPEC_TIMING_TWL_EARLY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_OFF_SPEC_TIMING_TWL_EARLY_MASK) | (((uint32_t)val) << MC_CH0_OFF_SPEC_TIMING_TWL_EARLY_SHIFT))

#define  MC_CH0_OFF_SPEC_TIMING_RESERVED3_MASK 0x800
#define  MC_CH0_OFF_SPEC_TIMING_RESERVED3_SHIFT 11
#define  MC_CH0_OFF_SPEC_TIMING_RESERVED3_MASK_SHIFT(reg) (((reg) & MC_CH0_OFF_SPEC_TIMING_RESERVED3_MASK) >> MC_CH0_OFF_SPEC_TIMING_RESERVED3_SHIFT)
#define  MC_CH0_OFF_SPEC_TIMING_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_OFF_SPEC_TIMING_RESERVED3_MASK) | (((uint32_t)val) << MC_CH0_OFF_SPEC_TIMING_RESERVED3_SHIFT))

#define  MC_CH0_OFF_SPEC_TIMING_TRWD_EXT_DLY_MASK 0x700
#define  MC_CH0_OFF_SPEC_TIMING_TRWD_EXT_DLY_SHIFT 8
#define  MC_CH0_OFF_SPEC_TIMING_TRWD_EXT_DLY_MASK_SHIFT(reg) (((reg) & MC_CH0_OFF_SPEC_TIMING_TRWD_EXT_DLY_MASK) >> MC_CH0_OFF_SPEC_TIMING_TRWD_EXT_DLY_SHIFT)
#define  MC_CH0_OFF_SPEC_TIMING_TRWD_EXT_DLY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_OFF_SPEC_TIMING_TRWD_EXT_DLY_MASK) | (((uint32_t)val) << MC_CH0_OFF_SPEC_TIMING_TRWD_EXT_DLY_SHIFT))

#define  MC_CH0_OFF_SPEC_TIMING_RESERVED4_MASK 0x80
#define  MC_CH0_OFF_SPEC_TIMING_RESERVED4_SHIFT 7
#define  MC_CH0_OFF_SPEC_TIMING_RESERVED4_MASK_SHIFT(reg) (((reg) & MC_CH0_OFF_SPEC_TIMING_RESERVED4_MASK) >> MC_CH0_OFF_SPEC_TIMING_RESERVED4_SHIFT)
#define  MC_CH0_OFF_SPEC_TIMING_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_OFF_SPEC_TIMING_RESERVED4_MASK) | (((uint32_t)val) << MC_CH0_OFF_SPEC_TIMING_RESERVED4_SHIFT))

#define  MC_CH0_OFF_SPEC_TIMING_TCCD_CCS_WR_EXT_DLY_MASK 0x70
#define  MC_CH0_OFF_SPEC_TIMING_TCCD_CCS_WR_EXT_DLY_SHIFT 4
#define  MC_CH0_OFF_SPEC_TIMING_TCCD_CCS_WR_EXT_DLY_MASK_SHIFT(reg) (((reg) & MC_CH0_OFF_SPEC_TIMING_TCCD_CCS_WR_EXT_DLY_MASK) >> MC_CH0_OFF_SPEC_TIMING_TCCD_CCS_WR_EXT_DLY_SHIFT)
#define  MC_CH0_OFF_SPEC_TIMING_TCCD_CCS_WR_EXT_DLY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_OFF_SPEC_TIMING_TCCD_CCS_WR_EXT_DLY_MASK) | (((uint32_t)val) << MC_CH0_OFF_SPEC_TIMING_TCCD_CCS_WR_EXT_DLY_SHIFT))

#define  MC_CH0_OFF_SPEC_TIMING_TCCD_CCS_EXT_DLY_MASK 0xf
#define  MC_CH0_OFF_SPEC_TIMING_TCCD_CCS_EXT_DLY_SHIFT 0
#define  MC_CH0_OFF_SPEC_TIMING_TCCD_CCS_EXT_DLY_MASK_SHIFT(reg) (((reg) & MC_CH0_OFF_SPEC_TIMING_TCCD_CCS_EXT_DLY_MASK) >> MC_CH0_OFF_SPEC_TIMING_TCCD_CCS_EXT_DLY_SHIFT)
#define  MC_CH0_OFF_SPEC_TIMING_TCCD_CCS_EXT_DLY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_OFF_SPEC_TIMING_TCCD_CCS_EXT_DLY_MASK) | (((uint32_t)val) << MC_CH0_OFF_SPEC_TIMING_TCCD_CCS_EXT_DLY_SHIFT))

//====================================================================
//Register: DRAM read timing  control register (CH0_dram_read_timing)
//====================================================================

#define  MC_CH0_DRAM_READ_TIMING_RESERVED1_MASK 0xfffffff8
#define  MC_CH0_DRAM_READ_TIMING_RESERVED1_SHIFT 3
#define  MC_CH0_DRAM_READ_TIMING_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_READ_TIMING_RESERVED1_MASK) >> MC_CH0_DRAM_READ_TIMING_RESERVED1_SHIFT)
#define  MC_CH0_DRAM_READ_TIMING_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_READ_TIMING_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_DRAM_READ_TIMING_RESERVED1_SHIFT))

#define  MC_CH0_DRAM_READ_TIMING_TDQSCK_MASK 0x7
#define  MC_CH0_DRAM_READ_TIMING_TDQSCK_SHIFT 0
#define  MC_CH0_DRAM_READ_TIMING_TDQSCK_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_READ_TIMING_TDQSCK_MASK) >> MC_CH0_DRAM_READ_TIMING_TDQSCK_SHIFT)
#define  MC_CH0_DRAM_READ_TIMING_TDQSCK_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_READ_TIMING_TDQSCK_MASK) | (((uint32_t)val) << MC_CH0_DRAM_READ_TIMING_TDQSCK_SHIFT))

//====================================================================
//Register: DRAM read timing  control register (CH1_dram_read_timing)
//====================================================================

#define  MC_CH1_DRAM_READ_TIMING_RESERVED1_MASK 0xfffffff8
#define  MC_CH1_DRAM_READ_TIMING_RESERVED1_SHIFT 3
#define  MC_CH1_DRAM_READ_TIMING_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH1_DRAM_READ_TIMING_RESERVED1_MASK) >> MC_CH1_DRAM_READ_TIMING_RESERVED1_SHIFT)
#define  MC_CH1_DRAM_READ_TIMING_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH1_DRAM_READ_TIMING_RESERVED1_MASK) | (((uint32_t)val) << MC_CH1_DRAM_READ_TIMING_RESERVED1_SHIFT))

#define  MC_CH1_DRAM_READ_TIMING_TDQSCK_MASK 0x7
#define  MC_CH1_DRAM_READ_TIMING_TDQSCK_SHIFT 0
#define  MC_CH1_DRAM_READ_TIMING_TDQSCK_MASK_SHIFT(reg) (((reg) & MC_CH1_DRAM_READ_TIMING_TDQSCK_MASK) >> MC_CH1_DRAM_READ_TIMING_TDQSCK_SHIFT)
#define  MC_CH1_DRAM_READ_TIMING_TDQSCK_REPLACE_VAL(reg,val) (((reg) & ~MC_CH1_DRAM_READ_TIMING_TDQSCK_MASK) | (((uint32_t)val) << MC_CH1_DRAM_READ_TIMING_TDQSCK_SHIFT))

//====================================================================
//Register: DRAM CA Train timing Register (CH0_dram_ca_train_timing)
//====================================================================

#define  MC_CH0_DRAM_CA_TRAIN_TIMING_RESERVED1_MASK 0xfffff000
#define  MC_CH0_DRAM_CA_TRAIN_TIMING_RESERVED1_SHIFT 12
#define  MC_CH0_DRAM_CA_TRAIN_TIMING_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CA_TRAIN_TIMING_RESERVED1_MASK) >> MC_CH0_DRAM_CA_TRAIN_TIMING_RESERVED1_SHIFT)
#define  MC_CH0_DRAM_CA_TRAIN_TIMING_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CA_TRAIN_TIMING_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CA_TRAIN_TIMING_RESERVED1_SHIFT))

#define  MC_CH0_DRAM_CA_TRAIN_TIMING_TCAEXT_MASK 0xf00
#define  MC_CH0_DRAM_CA_TRAIN_TIMING_TCAEXT_SHIFT 8
#define  MC_CH0_DRAM_CA_TRAIN_TIMING_TCAEXT_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CA_TRAIN_TIMING_TCAEXT_MASK) >> MC_CH0_DRAM_CA_TRAIN_TIMING_TCAEXT_SHIFT)
#define  MC_CH0_DRAM_CA_TRAIN_TIMING_TCAEXT_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CA_TRAIN_TIMING_TCAEXT_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CA_TRAIN_TIMING_TCAEXT_SHIFT))

#define  MC_CH0_DRAM_CA_TRAIN_TIMING_RESERVED2_MASK 0xf0
#define  MC_CH0_DRAM_CA_TRAIN_TIMING_RESERVED2_SHIFT 4
#define  MC_CH0_DRAM_CA_TRAIN_TIMING_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CA_TRAIN_TIMING_RESERVED2_MASK) >> MC_CH0_DRAM_CA_TRAIN_TIMING_RESERVED2_SHIFT)
#define  MC_CH0_DRAM_CA_TRAIN_TIMING_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CA_TRAIN_TIMING_RESERVED2_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CA_TRAIN_TIMING_RESERVED2_SHIFT))

#define  MC_CH0_DRAM_CA_TRAIN_TIMING_TCACKEL_MASK 0xf
#define  MC_CH0_DRAM_CA_TRAIN_TIMING_TCACKEL_SHIFT 0
#define  MC_CH0_DRAM_CA_TRAIN_TIMING_TCACKEL_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_CA_TRAIN_TIMING_TCACKEL_MASK) >> MC_CH0_DRAM_CA_TRAIN_TIMING_TCACKEL_SHIFT)
#define  MC_CH0_DRAM_CA_TRAIN_TIMING_TCACKEL_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_CA_TRAIN_TIMING_TCACKEL_MASK) | (((uint32_t)val) << MC_CH0_DRAM_CA_TRAIN_TIMING_TCACKEL_SHIFT))

//====================================================================
//Register: PHY Control Register 1 (CH0_PHY_Control_1)
//====================================================================

#define  MC_CH0_PHY_CONTROL_1_RESERVED1_MASK 0xfff80000
#define  MC_CH0_PHY_CONTROL_1_RESERVED1_SHIFT 19
#define  MC_CH0_PHY_CONTROL_1_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_1_RESERVED1_MASK) >> MC_CH0_PHY_CONTROL_1_RESERVED1_SHIFT)
#define  MC_CH0_PHY_CONTROL_1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_1_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_1_RESERVED1_SHIFT))

#define  MC_CH0_PHY_CONTROL_1_PHY_RFIFO_RDRST_EXPAND_MASK 0x60000
#define  MC_CH0_PHY_CONTROL_1_PHY_RFIFO_RDRST_EXPAND_SHIFT 17
#define  MC_CH0_PHY_CONTROL_1_PHY_RFIFO_RDRST_EXPAND_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_1_PHY_RFIFO_RDRST_EXPAND_MASK) >> MC_CH0_PHY_CONTROL_1_PHY_RFIFO_RDRST_EXPAND_SHIFT)
#define  MC_CH0_PHY_CONTROL_1_PHY_RFIFO_RDRST_EXPAND_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_1_PHY_RFIFO_RDRST_EXPAND_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_1_PHY_RFIFO_RDRST_EXPAND_SHIFT))

#define  MC_CH0_PHY_CONTROL_1_RESERVED2_MASK 0x10000
#define  MC_CH0_PHY_CONTROL_1_RESERVED2_SHIFT 16
#define  MC_CH0_PHY_CONTROL_1_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_1_RESERVED2_MASK) >> MC_CH0_PHY_CONTROL_1_RESERVED2_SHIFT)
#define  MC_CH0_PHY_CONTROL_1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_1_RESERVED2_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_1_RESERVED2_SHIFT))

#define  MC_CH0_PHY_CONTROL_1_PHY_RFIFO_RDRST_EARLY_MASK 0x8000
#define  MC_CH0_PHY_CONTROL_1_PHY_RFIFO_RDRST_EARLY_SHIFT 15
#define  MC_CH0_PHY_CONTROL_1_PHY_RFIFO_RDRST_EARLY_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_1_PHY_RFIFO_RDRST_EARLY_MASK) >> MC_CH0_PHY_CONTROL_1_PHY_RFIFO_RDRST_EARLY_SHIFT)
#define  MC_CH0_PHY_CONTROL_1_PHY_RFIFO_RDRST_EARLY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_1_PHY_RFIFO_RDRST_EARLY_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_1_PHY_RFIFO_RDRST_EARLY_SHIFT))

#define  MC_CH0_PHY_CONTROL_1_PHY_RFIFO_RDRST_EN_MASK 0x4000
#define  MC_CH0_PHY_CONTROL_1_PHY_RFIFO_RDRST_EN_SHIFT 14
#define  MC_CH0_PHY_CONTROL_1_PHY_RFIFO_RDRST_EN_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_1_PHY_RFIFO_RDRST_EN_MASK) >> MC_CH0_PHY_CONTROL_1_PHY_RFIFO_RDRST_EN_SHIFT)
#define  MC_CH0_PHY_CONTROL_1_PHY_RFIFO_RDRST_EN_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_1_PHY_RFIFO_RDRST_EN_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_1_PHY_RFIFO_RDRST_EN_SHIFT))

#define  MC_CH0_PHY_CONTROL_1_RESERVED3_MASK 0x2000
#define  MC_CH0_PHY_CONTROL_1_RESERVED3_SHIFT 13
#define  MC_CH0_PHY_CONTROL_1_RESERVED3_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_1_RESERVED3_MASK) >> MC_CH0_PHY_CONTROL_1_RESERVED3_SHIFT)
#define  MC_CH0_PHY_CONTROL_1_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_1_RESERVED3_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_1_RESERVED3_SHIFT))

#define  MC_CH0_PHY_CONTROL_1_DQ_EN_EXTEND_MASK 0x1000
#define  MC_CH0_PHY_CONTROL_1_DQ_EN_EXTEND_SHIFT 12
#define  MC_CH0_PHY_CONTROL_1_DQ_EN_EXTEND_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_1_DQ_EN_EXTEND_MASK) >> MC_CH0_PHY_CONTROL_1_DQ_EN_EXTEND_SHIFT)
#define  MC_CH0_PHY_CONTROL_1_DQ_EN_EXTEND_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_1_DQ_EN_EXTEND_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_1_DQ_EN_EXTEND_SHIFT))

#define  MC_CH0_PHY_CONTROL_1_RESERVED4_MASK 0x800
#define  MC_CH0_PHY_CONTROL_1_RESERVED4_SHIFT 11
#define  MC_CH0_PHY_CONTROL_1_RESERVED4_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_1_RESERVED4_MASK) >> MC_CH0_PHY_CONTROL_1_RESERVED4_SHIFT)
#define  MC_CH0_PHY_CONTROL_1_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_1_RESERVED4_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_1_RESERVED4_SHIFT))

#define  MC_CH0_PHY_CONTROL_1_RD_EXT_DLY_MASK 0x700
#define  MC_CH0_PHY_CONTROL_1_RD_EXT_DLY_SHIFT 8
#define  MC_CH0_PHY_CONTROL_1_RD_EXT_DLY_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_1_RD_EXT_DLY_MASK) >> MC_CH0_PHY_CONTROL_1_RD_EXT_DLY_SHIFT)
#define  MC_CH0_PHY_CONTROL_1_RD_EXT_DLY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_1_RD_EXT_DLY_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_1_RD_EXT_DLY_SHIFT))

#define  MC_CH0_PHY_CONTROL_1_PHY_RFIFO_RPTR_DLY_VAL_MASK 0xf0
#define  MC_CH0_PHY_CONTROL_1_PHY_RFIFO_RPTR_DLY_VAL_SHIFT 4
#define  MC_CH0_PHY_CONTROL_1_PHY_RFIFO_RPTR_DLY_VAL_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_1_PHY_RFIFO_RPTR_DLY_VAL_MASK) >> MC_CH0_PHY_CONTROL_1_PHY_RFIFO_RPTR_DLY_VAL_SHIFT)
#define  MC_CH0_PHY_CONTROL_1_PHY_RFIFO_RPTR_DLY_VAL_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_1_PHY_RFIFO_RPTR_DLY_VAL_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_1_PHY_RFIFO_RPTR_DLY_VAL_SHIFT))

#define  MC_CH0_PHY_CONTROL_1_DQ_EXT_DLY_MASK 0xf
#define  MC_CH0_PHY_CONTROL_1_DQ_EXT_DLY_SHIFT 0
#define  MC_CH0_PHY_CONTROL_1_DQ_EXT_DLY_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_1_DQ_EXT_DLY_MASK) >> MC_CH0_PHY_CONTROL_1_DQ_EXT_DLY_SHIFT)
#define  MC_CH0_PHY_CONTROL_1_DQ_EXT_DLY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_1_DQ_EXT_DLY_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_1_DQ_EXT_DLY_SHIFT))

//====================================================================
//Register: PHY Control Register 2 (CH0_PHY_Control_2)
//====================================================================

#define  MC_CH0_PHY_CONTROL_2_PHY_DQ_ZNR_MSB_MASK 0x80000000
#define  MC_CH0_PHY_CONTROL_2_PHY_DQ_ZNR_MSB_SHIFT 31
#define  MC_CH0_PHY_CONTROL_2_PHY_DQ_ZNR_MSB_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_2_PHY_DQ_ZNR_MSB_MASK) >> MC_CH0_PHY_CONTROL_2_PHY_DQ_ZNR_MSB_SHIFT)
#define  MC_CH0_PHY_CONTROL_2_PHY_DQ_ZNR_MSB_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_2_PHY_DQ_ZNR_MSB_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_2_PHY_DQ_ZNR_MSB_SHIFT))

#define  MC_CH0_PHY_CONTROL_2_PHY_DQ_ZPR_MSB_MASK 0x40000000
#define  MC_CH0_PHY_CONTROL_2_PHY_DQ_ZPR_MSB_SHIFT 30
#define  MC_CH0_PHY_CONTROL_2_PHY_DQ_ZPR_MSB_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_2_PHY_DQ_ZPR_MSB_MASK) >> MC_CH0_PHY_CONTROL_2_PHY_DQ_ZPR_MSB_SHIFT)
#define  MC_CH0_PHY_CONTROL_2_PHY_DQ_ZPR_MSB_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_2_PHY_DQ_ZPR_MSB_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_2_PHY_DQ_ZPR_MSB_SHIFT))

#define  MC_CH0_PHY_CONTROL_2_PHY_QS_VREF_SEL_MASK 0x30000000
#define  MC_CH0_PHY_CONTROL_2_PHY_QS_VREF_SEL_SHIFT 28
#define  MC_CH0_PHY_CONTROL_2_PHY_QS_VREF_SEL_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_2_PHY_QS_VREF_SEL_MASK) >> MC_CH0_PHY_CONTROL_2_PHY_QS_VREF_SEL_SHIFT)
#define  MC_CH0_PHY_CONTROL_2_PHY_QS_VREF_SEL_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_2_PHY_QS_VREF_SEL_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_2_PHY_QS_VREF_SEL_SHIFT))

#define  MC_CH0_PHY_CONTROL_2_PHY_DQ_ZPDRV_MASK 0xf000000
#define  MC_CH0_PHY_CONTROL_2_PHY_DQ_ZPDRV_SHIFT 24
#define  MC_CH0_PHY_CONTROL_2_PHY_DQ_ZPDRV_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_2_PHY_DQ_ZPDRV_MASK) >> MC_CH0_PHY_CONTROL_2_PHY_DQ_ZPDRV_SHIFT)
#define  MC_CH0_PHY_CONTROL_2_PHY_DQ_ZPDRV_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_2_PHY_DQ_ZPDRV_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_2_PHY_DQ_ZPDRV_SHIFT))

#define  MC_CH0_PHY_CONTROL_2_PHY_DQ_ZNDRV_MASK 0xf00000
#define  MC_CH0_PHY_CONTROL_2_PHY_DQ_ZNDRV_SHIFT 20
#define  MC_CH0_PHY_CONTROL_2_PHY_DQ_ZNDRV_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_2_PHY_DQ_ZNDRV_MASK) >> MC_CH0_PHY_CONTROL_2_PHY_DQ_ZNDRV_SHIFT)
#define  MC_CH0_PHY_CONTROL_2_PHY_DQ_ZNDRV_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_2_PHY_DQ_ZNDRV_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_2_PHY_DQ_ZNDRV_SHIFT))

#define  MC_CH0_PHY_CONTROL_2_PHY_DQ_ZPTRM_MASK 0xf0000
#define  MC_CH0_PHY_CONTROL_2_PHY_DQ_ZPTRM_SHIFT 16
#define  MC_CH0_PHY_CONTROL_2_PHY_DQ_ZPTRM_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_2_PHY_DQ_ZPTRM_MASK) >> MC_CH0_PHY_CONTROL_2_PHY_DQ_ZPTRM_SHIFT)
#define  MC_CH0_PHY_CONTROL_2_PHY_DQ_ZPTRM_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_2_PHY_DQ_ZPTRM_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_2_PHY_DQ_ZPTRM_SHIFT))

#define  MC_CH0_PHY_CONTROL_2_PHY_DQ_ZNTRM_MASK 0xf000
#define  MC_CH0_PHY_CONTROL_2_PHY_DQ_ZNTRM_SHIFT 12
#define  MC_CH0_PHY_CONTROL_2_PHY_DQ_ZNTRM_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_2_PHY_DQ_ZNTRM_MASK) >> MC_CH0_PHY_CONTROL_2_PHY_DQ_ZNTRM_SHIFT)
#define  MC_CH0_PHY_CONTROL_2_PHY_DQ_ZNTRM_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_2_PHY_DQ_ZNTRM_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_2_PHY_DQ_ZNTRM_SHIFT))

#define  MC_CH0_PHY_CONTROL_2_PHY_DQ_ZNR_MASK 0xf00
#define  MC_CH0_PHY_CONTROL_2_PHY_DQ_ZNR_SHIFT 8
#define  MC_CH0_PHY_CONTROL_2_PHY_DQ_ZNR_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_2_PHY_DQ_ZNR_MASK) >> MC_CH0_PHY_CONTROL_2_PHY_DQ_ZNR_SHIFT)
#define  MC_CH0_PHY_CONTROL_2_PHY_DQ_ZNR_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_2_PHY_DQ_ZNR_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_2_PHY_DQ_ZNR_SHIFT))

#define  MC_CH0_PHY_CONTROL_2_PHY_DQ_ZPR_MASK 0xf0
#define  MC_CH0_PHY_CONTROL_2_PHY_DQ_ZPR_SHIFT 4
#define  MC_CH0_PHY_CONTROL_2_PHY_DQ_ZPR_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_2_PHY_DQ_ZPR_MASK) >> MC_CH0_PHY_CONTROL_2_PHY_DQ_ZPR_SHIFT)
#define  MC_CH0_PHY_CONTROL_2_PHY_DQ_ZPR_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_2_PHY_DQ_ZPR_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_2_PHY_DQ_ZPR_SHIFT))

#define  MC_CH0_PHY_CONTROL_2_PHY_DQ_VREF_SEL_MASK 0xc
#define  MC_CH0_PHY_CONTROL_2_PHY_DQ_VREF_SEL_SHIFT 2
#define  MC_CH0_PHY_CONTROL_2_PHY_DQ_VREF_SEL_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_2_PHY_DQ_VREF_SEL_MASK) >> MC_CH0_PHY_CONTROL_2_PHY_DQ_VREF_SEL_SHIFT)
#define  MC_CH0_PHY_CONTROL_2_PHY_DQ_VREF_SEL_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_2_PHY_DQ_VREF_SEL_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_2_PHY_DQ_VREF_SEL_SHIFT))

#define  MC_CH0_PHY_CONTROL_2_PHY_DQ_ZD_MASK 0x2
#define  MC_CH0_PHY_CONTROL_2_PHY_DQ_ZD_SHIFT 1
#define  MC_CH0_PHY_CONTROL_2_PHY_DQ_ZD_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_2_PHY_DQ_ZD_MASK) >> MC_CH0_PHY_CONTROL_2_PHY_DQ_ZD_SHIFT)
#define  MC_CH0_PHY_CONTROL_2_PHY_DQ_ZD_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_2_PHY_DQ_ZD_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_2_PHY_DQ_ZD_SHIFT))

#define  MC_CH0_PHY_CONTROL_2_PHY_DQ_MODE_MASK 0x1
#define  MC_CH0_PHY_CONTROL_2_PHY_DQ_MODE_SHIFT 0
#define  MC_CH0_PHY_CONTROL_2_PHY_DQ_MODE_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_2_PHY_DQ_MODE_MASK) >> MC_CH0_PHY_CONTROL_2_PHY_DQ_MODE_SHIFT)
#define  MC_CH0_PHY_CONTROL_2_PHY_DQ_MODE_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_2_PHY_DQ_MODE_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_2_PHY_DQ_MODE_SHIFT))

//====================================================================
//Register: PHY Control Register 3 (CH0_PHY_Control_3)
//====================================================================

#define  MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZNR_MSB_MASK 0x80000000
#define  MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZNR_MSB_SHIFT 31
#define  MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZNR_MSB_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZNR_MSB_MASK) >> MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZNR_MSB_SHIFT)
#define  MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZNR_MSB_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZNR_MSB_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZNR_MSB_SHIFT))

#define  MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZPR_MSB_MASK 0x40000000
#define  MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZPR_MSB_SHIFT 30
#define  MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZPR_MSB_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZPR_MSB_MASK) >> MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZPR_MSB_SHIFT)
#define  MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZPR_MSB_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZPR_MSB_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZPR_MSB_SHIFT))

#define  MC_CH0_PHY_CONTROL_3_RESERVED1_MASK 0x30000000
#define  MC_CH0_PHY_CONTROL_3_RESERVED1_SHIFT 28
#define  MC_CH0_PHY_CONTROL_3_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_3_RESERVED1_MASK) >> MC_CH0_PHY_CONTROL_3_RESERVED1_SHIFT)
#define  MC_CH0_PHY_CONTROL_3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_3_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_3_RESERVED1_SHIFT))

#define  MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZPDRV_MASK 0xf000000
#define  MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZPDRV_SHIFT 24
#define  MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZPDRV_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZPDRV_MASK) >> MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZPDRV_SHIFT)
#define  MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZPDRV_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZPDRV_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZPDRV_SHIFT))

#define  MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZNDRV_MASK 0xf00000
#define  MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZNDRV_SHIFT 20
#define  MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZNDRV_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZNDRV_MASK) >> MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZNDRV_SHIFT)
#define  MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZNDRV_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZNDRV_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZNDRV_SHIFT))

#define  MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZPTRM_MASK 0xf0000
#define  MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZPTRM_SHIFT 16
#define  MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZPTRM_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZPTRM_MASK) >> MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZPTRM_SHIFT)
#define  MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZPTRM_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZPTRM_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZPTRM_SHIFT))

#define  MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZNTRM_MASK 0xf000
#define  MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZNTRM_SHIFT 12
#define  MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZNTRM_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZNTRM_MASK) >> MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZNTRM_SHIFT)
#define  MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZNTRM_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZNTRM_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZNTRM_SHIFT))

#define  MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZNR_MASK 0xf00
#define  MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZNR_SHIFT 8
#define  MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZNR_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZNR_MASK) >> MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZNR_SHIFT)
#define  MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZNR_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZNR_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZNR_SHIFT))

#define  MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZPR_MASK 0xf0
#define  MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZPR_SHIFT 4
#define  MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZPR_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZPR_MASK) >> MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZPR_SHIFT)
#define  MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZPR_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZPR_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZPR_SHIFT))

#define  MC_CH0_PHY_CONTROL_3_PHY_ADCM_VREF_SEL_MASK 0xc
#define  MC_CH0_PHY_CONTROL_3_PHY_ADCM_VREF_SEL_SHIFT 2
#define  MC_CH0_PHY_CONTROL_3_PHY_ADCM_VREF_SEL_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_3_PHY_ADCM_VREF_SEL_MASK) >> MC_CH0_PHY_CONTROL_3_PHY_ADCM_VREF_SEL_SHIFT)
#define  MC_CH0_PHY_CONTROL_3_PHY_ADCM_VREF_SEL_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_3_PHY_ADCM_VREF_SEL_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_3_PHY_ADCM_VREF_SEL_SHIFT))

#define  MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZD_MASK 0x2
#define  MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZD_SHIFT 1
#define  MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZD_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZD_MASK) >> MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZD_SHIFT)
#define  MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZD_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZD_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_3_PHY_ADCM_ZD_SHIFT))

#define  MC_CH0_PHY_CONTROL_3_PHY_ADCM_MODE_MASK 0x1
#define  MC_CH0_PHY_CONTROL_3_PHY_ADCM_MODE_SHIFT 0
#define  MC_CH0_PHY_CONTROL_3_PHY_ADCM_MODE_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_3_PHY_ADCM_MODE_MASK) >> MC_CH0_PHY_CONTROL_3_PHY_ADCM_MODE_SHIFT)
#define  MC_CH0_PHY_CONTROL_3_PHY_ADCM_MODE_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_3_PHY_ADCM_MODE_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_3_PHY_ADCM_MODE_SHIFT))

//====================================================================
//Register: PHY Control Register 4 (CH0_PHY_Control_4)
//====================================================================

#define  MC_CH0_PHY_CONTROL_4_PHY_QS_RCVTYPE_MASK 0xc0000000
#define  MC_CH0_PHY_CONTROL_4_PHY_QS_RCVTYPE_SHIFT 30
#define  MC_CH0_PHY_CONTROL_4_PHY_QS_RCVTYPE_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_4_PHY_QS_RCVTYPE_MASK) >> MC_CH0_PHY_CONTROL_4_PHY_QS_RCVTYPE_SHIFT)
#define  MC_CH0_PHY_CONTROL_4_PHY_QS_RCVTYPE_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_4_PHY_QS_RCVTYPE_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_4_PHY_QS_RCVTYPE_SHIFT))

#define  MC_CH0_PHY_CONTROL_4_PHY_DQ_RCVEP_MASK 0x38000000
#define  MC_CH0_PHY_CONTROL_4_PHY_DQ_RCVEP_SHIFT 27
#define  MC_CH0_PHY_CONTROL_4_PHY_DQ_RCVEP_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_4_PHY_DQ_RCVEP_MASK) >> MC_CH0_PHY_CONTROL_4_PHY_DQ_RCVEP_SHIFT)
#define  MC_CH0_PHY_CONTROL_4_PHY_DQ_RCVEP_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_4_PHY_DQ_RCVEP_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_4_PHY_DQ_RCVEP_SHIFT))

#define  MC_CH0_PHY_CONTROL_4_PHY_DQ_RCVEN_MASK 0x7000000
#define  MC_CH0_PHY_CONTROL_4_PHY_DQ_RCVEN_SHIFT 24
#define  MC_CH0_PHY_CONTROL_4_PHY_DQ_RCVEN_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_4_PHY_DQ_RCVEN_MASK) >> MC_CH0_PHY_CONTROL_4_PHY_DQ_RCVEN_SHIFT)
#define  MC_CH0_PHY_CONTROL_4_PHY_DQ_RCVEN_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_4_PHY_DQ_RCVEN_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_4_PHY_DQ_RCVEN_SHIFT))

#define  MC_CH0_PHY_CONTROL_4_PHY_DQ_RCVTYPE_MASK 0xc00000
#define  MC_CH0_PHY_CONTROL_4_PHY_DQ_RCVTYPE_SHIFT 22
#define  MC_CH0_PHY_CONTROL_4_PHY_DQ_RCVTYPE_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_4_PHY_DQ_RCVTYPE_MASK) >> MC_CH0_PHY_CONTROL_4_PHY_DQ_RCVTYPE_SHIFT)
#define  MC_CH0_PHY_CONTROL_4_PHY_DQ_RCVTYPE_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_4_PHY_DQ_RCVTYPE_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_4_PHY_DQ_RCVTYPE_SHIFT))

#define  MC_CH0_PHY_CONTROL_4_PHY_CK_ZD_MASK 0x200000
#define  MC_CH0_PHY_CONTROL_4_PHY_CK_ZD_SHIFT 21
#define  MC_CH0_PHY_CONTROL_4_PHY_CK_ZD_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_4_PHY_CK_ZD_MASK) >> MC_CH0_PHY_CONTROL_4_PHY_CK_ZD_SHIFT)
#define  MC_CH0_PHY_CONTROL_4_PHY_CK_ZD_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_4_PHY_CK_ZD_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_4_PHY_CK_ZD_SHIFT))

#define  MC_CH0_PHY_CONTROL_4_RESERVED1_MASK 0x1c0000
#define  MC_CH0_PHY_CONTROL_4_RESERVED1_SHIFT 18
#define  MC_CH0_PHY_CONTROL_4_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_4_RESERVED1_MASK) >> MC_CH0_PHY_CONTROL_4_RESERVED1_SHIFT)
#define  MC_CH0_PHY_CONTROL_4_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_4_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_4_RESERVED1_SHIFT))

#define  MC_CH0_PHY_CONTROL_4_PHY_CK_ZNDRV_MASK 0x3c000
#define  MC_CH0_PHY_CONTROL_4_PHY_CK_ZNDRV_SHIFT 14
#define  MC_CH0_PHY_CONTROL_4_PHY_CK_ZNDRV_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_4_PHY_CK_ZNDRV_MASK) >> MC_CH0_PHY_CONTROL_4_PHY_CK_ZNDRV_SHIFT)
#define  MC_CH0_PHY_CONTROL_4_PHY_CK_ZNDRV_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_4_PHY_CK_ZNDRV_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_4_PHY_CK_ZNDRV_SHIFT))

#define  MC_CH0_PHY_CONTROL_4_PHY_CK_ZPDRV_MASK 0x3c00
#define  MC_CH0_PHY_CONTROL_4_PHY_CK_ZPDRV_SHIFT 10
#define  MC_CH0_PHY_CONTROL_4_PHY_CK_ZPDRV_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_4_PHY_CK_ZPDRV_MASK) >> MC_CH0_PHY_CONTROL_4_PHY_CK_ZPDRV_SHIFT)
#define  MC_CH0_PHY_CONTROL_4_PHY_CK_ZPDRV_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_4_PHY_CK_ZPDRV_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_4_PHY_CK_ZPDRV_SHIFT))

#define  MC_CH0_PHY_CONTROL_4_PHY_CK_ZPR_MSB_MASK 0x200
#define  MC_CH0_PHY_CONTROL_4_PHY_CK_ZPR_MSB_SHIFT 9
#define  MC_CH0_PHY_CONTROL_4_PHY_CK_ZPR_MSB_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_4_PHY_CK_ZPR_MSB_MASK) >> MC_CH0_PHY_CONTROL_4_PHY_CK_ZPR_MSB_SHIFT)
#define  MC_CH0_PHY_CONTROL_4_PHY_CK_ZPR_MSB_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_4_PHY_CK_ZPR_MSB_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_4_PHY_CK_ZPR_MSB_SHIFT))

#define  MC_CH0_PHY_CONTROL_4_PHY_CK_ZNR_MSB_MASK 0x100
#define  MC_CH0_PHY_CONTROL_4_PHY_CK_ZNR_MSB_SHIFT 8
#define  MC_CH0_PHY_CONTROL_4_PHY_CK_ZNR_MSB_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_4_PHY_CK_ZNR_MSB_MASK) >> MC_CH0_PHY_CONTROL_4_PHY_CK_ZNR_MSB_SHIFT)
#define  MC_CH0_PHY_CONTROL_4_PHY_CK_ZNR_MSB_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_4_PHY_CK_ZNR_MSB_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_4_PHY_CK_ZNR_MSB_SHIFT))

#define  MC_CH0_PHY_CONTROL_4_PHY_CK_ZNR_MASK 0xf0
#define  MC_CH0_PHY_CONTROL_4_PHY_CK_ZNR_SHIFT 4
#define  MC_CH0_PHY_CONTROL_4_PHY_CK_ZNR_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_4_PHY_CK_ZNR_MASK) >> MC_CH0_PHY_CONTROL_4_PHY_CK_ZNR_SHIFT)
#define  MC_CH0_PHY_CONTROL_4_PHY_CK_ZNR_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_4_PHY_CK_ZNR_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_4_PHY_CK_ZNR_SHIFT))

#define  MC_CH0_PHY_CONTROL_4_PHY_CK_ZPR_MASK 0xf
#define  MC_CH0_PHY_CONTROL_4_PHY_CK_ZPR_SHIFT 0
#define  MC_CH0_PHY_CONTROL_4_PHY_CK_ZPR_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_4_PHY_CK_ZPR_MASK) >> MC_CH0_PHY_CONTROL_4_PHY_CK_ZPR_SHIFT)
#define  MC_CH0_PHY_CONTROL_4_PHY_CK_ZPR_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_4_PHY_CK_ZPR_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_4_PHY_CK_ZPR_SHIFT))

//====================================================================
//Register: PHY Control Register 5 (CH0_PHY_Control_5)
//====================================================================

#define  MC_CH0_PHY_CONTROL_5_RESERVED1_MASK 0xffc00000
#define  MC_CH0_PHY_CONTROL_5_RESERVED1_SHIFT 22
#define  MC_CH0_PHY_CONTROL_5_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_5_RESERVED1_MASK) >> MC_CH0_PHY_CONTROL_5_RESERVED1_SHIFT)
#define  MC_CH0_PHY_CONTROL_5_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_5_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_5_RESERVED1_SHIFT))

#define  MC_CH0_PHY_CONTROL_5_PAD_CAL_INTERVAL_MASK 0x300000
#define  MC_CH0_PHY_CONTROL_5_PAD_CAL_INTERVAL_SHIFT 20
#define  MC_CH0_PHY_CONTROL_5_PAD_CAL_INTERVAL_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_5_PAD_CAL_INTERVAL_MASK) >> MC_CH0_PHY_CONTROL_5_PAD_CAL_INTERVAL_SHIFT)
#define  MC_CH0_PHY_CONTROL_5_PAD_CAL_INTERVAL_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_5_PAD_CAL_INTERVAL_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_5_PAD_CAL_INTERVAL_SHIFT))

#define  MC_CH0_PHY_CONTROL_5_PAD_CAL_AUTO_SEL_MASK 0xe0000
#define  MC_CH0_PHY_CONTROL_5_PAD_CAL_AUTO_SEL_SHIFT 17
#define  MC_CH0_PHY_CONTROL_5_PAD_CAL_AUTO_SEL_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_5_PAD_CAL_AUTO_SEL_MASK) >> MC_CH0_PHY_CONTROL_5_PAD_CAL_AUTO_SEL_SHIFT)
#define  MC_CH0_PHY_CONTROL_5_PAD_CAL_AUTO_SEL_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_5_PAD_CAL_AUTO_SEL_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_5_PAD_CAL_AUTO_SEL_SHIFT))

#define  MC_CH0_PHY_CONTROL_5_PAD_CAL_AUTO_MASK 0x10000
#define  MC_CH0_PHY_CONTROL_5_PAD_CAL_AUTO_SHIFT 16
#define  MC_CH0_PHY_CONTROL_5_PAD_CAL_AUTO_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_5_PAD_CAL_AUTO_MASK) >> MC_CH0_PHY_CONTROL_5_PAD_CAL_AUTO_SHIFT)
#define  MC_CH0_PHY_CONTROL_5_PAD_CAL_AUTO_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_5_PAD_CAL_AUTO_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_5_PAD_CAL_AUTO_SHIFT))

#define  MC_CH0_PHY_CONTROL_5_PAD_CAL_ONCE_MASK 0x8000
#define  MC_CH0_PHY_CONTROL_5_PAD_CAL_ONCE_SHIFT 15
#define  MC_CH0_PHY_CONTROL_5_PAD_CAL_ONCE_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_5_PAD_CAL_ONCE_MASK) >> MC_CH0_PHY_CONTROL_5_PAD_CAL_ONCE_SHIFT)
#define  MC_CH0_PHY_CONTROL_5_PAD_CAL_ONCE_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_5_PAD_CAL_ONCE_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_5_PAD_CAL_ONCE_SHIFT))

#define  MC_CH0_PHY_CONTROL_5_RESERVED2_MASK 0x7800
#define  MC_CH0_PHY_CONTROL_5_RESERVED2_SHIFT 11
#define  MC_CH0_PHY_CONTROL_5_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_5_RESERVED2_MASK) >> MC_CH0_PHY_CONTROL_5_RESERVED2_SHIFT)
#define  MC_CH0_PHY_CONTROL_5_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_5_RESERVED2_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_5_RESERVED2_SHIFT))

#define  MC_CH0_PHY_CONTROL_5_WRITE_DQSB_ONE_MASK 0x400
#define  MC_CH0_PHY_CONTROL_5_WRITE_DQSB_ONE_SHIFT 10
#define  MC_CH0_PHY_CONTROL_5_WRITE_DQSB_ONE_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_5_WRITE_DQSB_ONE_MASK) >> MC_CH0_PHY_CONTROL_5_WRITE_DQSB_ONE_SHIFT)
#define  MC_CH0_PHY_CONTROL_5_WRITE_DQSB_ONE_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_5_WRITE_DQSB_ONE_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_5_WRITE_DQSB_ONE_SHIFT))

#define  MC_CH0_PHY_CONTROL_5_RESERVED3_MASK 0x200
#define  MC_CH0_PHY_CONTROL_5_RESERVED3_SHIFT 9
#define  MC_CH0_PHY_CONTROL_5_RESERVED3_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_5_RESERVED3_MASK) >> MC_CH0_PHY_CONTROL_5_RESERVED3_SHIFT)
#define  MC_CH0_PHY_CONTROL_5_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_5_RESERVED3_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_5_RESERVED3_SHIFT))

#define  MC_CH0_PHY_CONTROL_5_WRITE_DQSB_EN_MASK 0x100
#define  MC_CH0_PHY_CONTROL_5_WRITE_DQSB_EN_SHIFT 8
#define  MC_CH0_PHY_CONTROL_5_WRITE_DQSB_EN_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_5_WRITE_DQSB_EN_MASK) >> MC_CH0_PHY_CONTROL_5_WRITE_DQSB_EN_SHIFT)
#define  MC_CH0_PHY_CONTROL_5_WRITE_DQSB_EN_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_5_WRITE_DQSB_EN_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_5_WRITE_DQSB_EN_SHIFT))

#define  MC_CH0_PHY_CONTROL_5_ENABLE_ALL_BYTE_PD_MASK 0x80
#define  MC_CH0_PHY_CONTROL_5_ENABLE_ALL_BYTE_PD_SHIFT 7
#define  MC_CH0_PHY_CONTROL_5_ENABLE_ALL_BYTE_PD_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_5_ENABLE_ALL_BYTE_PD_MASK) >> MC_CH0_PHY_CONTROL_5_ENABLE_ALL_BYTE_PD_SHIFT)
#define  MC_CH0_PHY_CONTROL_5_ENABLE_ALL_BYTE_PD_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_5_ENABLE_ALL_BYTE_PD_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_5_ENABLE_ALL_BYTE_PD_SHIFT))

#define  MC_CH0_PHY_CONTROL_5_ENABLE_ALL_BYTE_OE_MASK 0x40
#define  MC_CH0_PHY_CONTROL_5_ENABLE_ALL_BYTE_OE_SHIFT 6
#define  MC_CH0_PHY_CONTROL_5_ENABLE_ALL_BYTE_OE_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_5_ENABLE_ALL_BYTE_OE_MASK) >> MC_CH0_PHY_CONTROL_5_ENABLE_ALL_BYTE_OE_SHIFT)
#define  MC_CH0_PHY_CONTROL_5_ENABLE_ALL_BYTE_OE_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_5_ENABLE_ALL_BYTE_OE_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_5_ENABLE_ALL_BYTE_OE_SHIFT))

#define  MC_CH0_PHY_CONTROL_5_RESERVED4_MASK 0x20
#define  MC_CH0_PHY_CONTROL_5_RESERVED4_SHIFT 5
#define  MC_CH0_PHY_CONTROL_5_RESERVED4_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_5_RESERVED4_MASK) >> MC_CH0_PHY_CONTROL_5_RESERVED4_SHIFT)
#define  MC_CH0_PHY_CONTROL_5_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_5_RESERVED4_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_5_RESERVED4_SHIFT))

#define  MC_CH0_PHY_CONTROL_5_MC_QSN_PD_MASK 0x10
#define  MC_CH0_PHY_CONTROL_5_MC_QSN_PD_SHIFT 4
#define  MC_CH0_PHY_CONTROL_5_MC_QSN_PD_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_5_MC_QSN_PD_MASK) >> MC_CH0_PHY_CONTROL_5_MC_QSN_PD_SHIFT)
#define  MC_CH0_PHY_CONTROL_5_MC_QSN_PD_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_5_MC_QSN_PD_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_5_MC_QSN_PD_SHIFT))

#define  MC_CH0_PHY_CONTROL_5_MC_QSP_PD_MASK 0x8
#define  MC_CH0_PHY_CONTROL_5_MC_QSP_PD_SHIFT 3
#define  MC_CH0_PHY_CONTROL_5_MC_QSP_PD_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_5_MC_QSP_PD_MASK) >> MC_CH0_PHY_CONTROL_5_MC_QSP_PD_SHIFT)
#define  MC_CH0_PHY_CONTROL_5_MC_QSP_PD_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_5_MC_QSP_PD_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_5_MC_QSP_PD_SHIFT))

#define  MC_CH0_PHY_CONTROL_5_MC_DQ_PD_MASK 0x4
#define  MC_CH0_PHY_CONTROL_5_MC_DQ_PD_SHIFT 2
#define  MC_CH0_PHY_CONTROL_5_MC_DQ_PD_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_5_MC_DQ_PD_MASK) >> MC_CH0_PHY_CONTROL_5_MC_DQ_PD_SHIFT)
#define  MC_CH0_PHY_CONTROL_5_MC_DQ_PD_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_5_MC_DQ_PD_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_5_MC_DQ_PD_SHIFT))

#define  MC_CH0_PHY_CONTROL_5_MC_CK_PD_MASK 0x2
#define  MC_CH0_PHY_CONTROL_5_MC_CK_PD_SHIFT 1
#define  MC_CH0_PHY_CONTROL_5_MC_CK_PD_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_5_MC_CK_PD_MASK) >> MC_CH0_PHY_CONTROL_5_MC_CK_PD_SHIFT)
#define  MC_CH0_PHY_CONTROL_5_MC_CK_PD_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_5_MC_CK_PD_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_5_MC_CK_PD_SHIFT))

#define  MC_CH0_PHY_CONTROL_5_MC_AC_PD_MASK 0x1
#define  MC_CH0_PHY_CONTROL_5_MC_AC_PD_SHIFT 0
#define  MC_CH0_PHY_CONTROL_5_MC_AC_PD_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_5_MC_AC_PD_MASK) >> MC_CH0_PHY_CONTROL_5_MC_AC_PD_SHIFT)
#define  MC_CH0_PHY_CONTROL_5_MC_AC_PD_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_5_MC_AC_PD_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_5_MC_AC_PD_SHIFT))

//====================================================================
//Register: PHY Control Register 6 (CH0_PHY_Control_6)
//====================================================================

#define  MC_CH0_PHY_CONTROL_6_RESERVED1_MASK 0xfff00000
#define  MC_CH0_PHY_CONTROL_6_RESERVED1_SHIFT 20
#define  MC_CH0_PHY_CONTROL_6_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_6_RESERVED1_MASK) >> MC_CH0_PHY_CONTROL_6_RESERVED1_SHIFT)
#define  MC_CH0_PHY_CONTROL_6_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_6_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_6_RESERVED1_SHIFT))

#define  MC_CH0_PHY_CONTROL_6_MC_PHY_SYNC_EN_SEL_MASK 0x80000
#define  MC_CH0_PHY_CONTROL_6_MC_PHY_SYNC_EN_SEL_SHIFT 19
#define  MC_CH0_PHY_CONTROL_6_MC_PHY_SYNC_EN_SEL_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_6_MC_PHY_SYNC_EN_SEL_MASK) >> MC_CH0_PHY_CONTROL_6_MC_PHY_SYNC_EN_SEL_SHIFT)
#define  MC_CH0_PHY_CONTROL_6_MC_PHY_SYNC_EN_SEL_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_6_MC_PHY_SYNC_EN_SEL_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_6_MC_PHY_SYNC_EN_SEL_SHIFT))

#define  MC_CH0_PHY_CONTROL_6_RESERVED2_MASK 0x7fc00
#define  MC_CH0_PHY_CONTROL_6_RESERVED2_SHIFT 10
#define  MC_CH0_PHY_CONTROL_6_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_6_RESERVED2_MASK) >> MC_CH0_PHY_CONTROL_6_RESERVED2_SHIFT)
#define  MC_CH0_PHY_CONTROL_6_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_6_RESERVED2_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_6_RESERVED2_SHIFT))

#define  MC_CH0_PHY_CONTROL_6_MC_PHY_WFIFO_LD_PHASE_MASK 0x200
#define  MC_CH0_PHY_CONTROL_6_MC_PHY_WFIFO_LD_PHASE_SHIFT 9
#define  MC_CH0_PHY_CONTROL_6_MC_PHY_WFIFO_LD_PHASE_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_6_MC_PHY_WFIFO_LD_PHASE_MASK) >> MC_CH0_PHY_CONTROL_6_MC_PHY_WFIFO_LD_PHASE_SHIFT)
#define  MC_CH0_PHY_CONTROL_6_MC_PHY_WFIFO_LD_PHASE_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_6_MC_PHY_WFIFO_LD_PHASE_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_6_MC_PHY_WFIFO_LD_PHASE_SHIFT))

#define  MC_CH0_PHY_CONTROL_6_RESERVED3_MASK 0x1f0
#define  MC_CH0_PHY_CONTROL_6_RESERVED3_SHIFT 4
#define  MC_CH0_PHY_CONTROL_6_RESERVED3_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_6_RESERVED3_MASK) >> MC_CH0_PHY_CONTROL_6_RESERVED3_SHIFT)
#define  MC_CH0_PHY_CONTROL_6_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_6_RESERVED3_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_6_RESERVED3_SHIFT))

#define  MC_CH0_PHY_CONTROL_6_MC_PHY_SYNC_MODE_MASK 0x8
#define  MC_CH0_PHY_CONTROL_6_MC_PHY_SYNC_MODE_SHIFT 3
#define  MC_CH0_PHY_CONTROL_6_MC_PHY_SYNC_MODE_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_6_MC_PHY_SYNC_MODE_MASK) >> MC_CH0_PHY_CONTROL_6_MC_PHY_SYNC_MODE_SHIFT)
#define  MC_CH0_PHY_CONTROL_6_MC_PHY_SYNC_MODE_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_6_MC_PHY_SYNC_MODE_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_6_MC_PHY_SYNC_MODE_SHIFT))

#define  MC_CH0_PHY_CONTROL_6_RESERVED4_MASK 0x7
#define  MC_CH0_PHY_CONTROL_6_RESERVED4_SHIFT 0
#define  MC_CH0_PHY_CONTROL_6_RESERVED4_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_6_RESERVED4_MASK) >> MC_CH0_PHY_CONTROL_6_RESERVED4_SHIFT)
#define  MC_CH0_PHY_CONTROL_6_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_6_RESERVED4_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_6_RESERVED4_SHIFT))

//====================================================================
//Register: PHY Control Register 8 (CH0_PHY_Control_8)
//====================================================================

#define  MC_CH0_PHY_CONTROL_8_DLL_RESET_TIMER_MASK 0xff000000
#define  MC_CH0_PHY_CONTROL_8_DLL_RESET_TIMER_SHIFT 24
#define  MC_CH0_PHY_CONTROL_8_DLL_RESET_TIMER_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_8_DLL_RESET_TIMER_MASK) >> MC_CH0_PHY_CONTROL_8_DLL_RESET_TIMER_SHIFT)
#define  MC_CH0_PHY_CONTROL_8_DLL_RESET_TIMER_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_8_DLL_RESET_TIMER_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_8_DLL_RESET_TIMER_SHIFT))

#define  MC_CH0_PHY_CONTROL_8_RESERVED1_MASK 0xe00000
#define  MC_CH0_PHY_CONTROL_8_RESERVED1_SHIFT 21
#define  MC_CH0_PHY_CONTROL_8_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_8_RESERVED1_MASK) >> MC_CH0_PHY_CONTROL_8_RESERVED1_SHIFT)
#define  MC_CH0_PHY_CONTROL_8_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_8_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_8_RESERVED1_SHIFT))

#define  MC_CH0_PHY_CONTROL_8_DLL_UPDATE_TIMER_MASK 0x1f0000
#define  MC_CH0_PHY_CONTROL_8_DLL_UPDATE_TIMER_SHIFT 16
#define  MC_CH0_PHY_CONTROL_8_DLL_UPDATE_TIMER_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_8_DLL_UPDATE_TIMER_MASK) >> MC_CH0_PHY_CONTROL_8_DLL_UPDATE_TIMER_SHIFT)
#define  MC_CH0_PHY_CONTROL_8_DLL_UPDATE_TIMER_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_8_DLL_UPDATE_TIMER_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_8_DLL_UPDATE_TIMER_SHIFT))

#define  MC_CH0_PHY_CONTROL_8_DLL_AUTO_UPDATE_INTERVAL_MASK 0xff00
#define  MC_CH0_PHY_CONTROL_8_DLL_AUTO_UPDATE_INTERVAL_SHIFT 8
#define  MC_CH0_PHY_CONTROL_8_DLL_AUTO_UPDATE_INTERVAL_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_8_DLL_AUTO_UPDATE_INTERVAL_MASK) >> MC_CH0_PHY_CONTROL_8_DLL_AUTO_UPDATE_INTERVAL_SHIFT)
#define  MC_CH0_PHY_CONTROL_8_DLL_AUTO_UPDATE_INTERVAL_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_8_DLL_AUTO_UPDATE_INTERVAL_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_8_DLL_AUTO_UPDATE_INTERVAL_SHIFT))

#define  MC_CH0_PHY_CONTROL_8_RESERVED2_MASK 0xe0
#define  MC_CH0_PHY_CONTROL_8_RESERVED2_SHIFT 5
#define  MC_CH0_PHY_CONTROL_8_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_8_RESERVED2_MASK) >> MC_CH0_PHY_CONTROL_8_RESERVED2_SHIFT)
#define  MC_CH0_PHY_CONTROL_8_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_8_RESERVED2_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_8_RESERVED2_SHIFT))

#define  MC_CH0_PHY_CONTROL_8_DLL_FAST_LOCK_MASK 0x10
#define  MC_CH0_PHY_CONTROL_8_DLL_FAST_LOCK_SHIFT 4
#define  MC_CH0_PHY_CONTROL_8_DLL_FAST_LOCK_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_8_DLL_FAST_LOCK_MASK) >> MC_CH0_PHY_CONTROL_8_DLL_FAST_LOCK_SHIFT)
#define  MC_CH0_PHY_CONTROL_8_DLL_FAST_LOCK_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_8_DLL_FAST_LOCK_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_8_DLL_FAST_LOCK_SHIFT))

#define  MC_CH0_PHY_CONTROL_8_DLL_AUTO_MANUAL_UPDATE_MASK 0x8
#define  MC_CH0_PHY_CONTROL_8_DLL_AUTO_MANUAL_UPDATE_SHIFT 3
#define  MC_CH0_PHY_CONTROL_8_DLL_AUTO_MANUAL_UPDATE_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_8_DLL_AUTO_MANUAL_UPDATE_MASK) >> MC_CH0_PHY_CONTROL_8_DLL_AUTO_MANUAL_UPDATE_SHIFT)
#define  MC_CH0_PHY_CONTROL_8_DLL_AUTO_MANUAL_UPDATE_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_8_DLL_AUTO_MANUAL_UPDATE_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_8_DLL_AUTO_MANUAL_UPDATE_SHIFT))

#define  MC_CH0_PHY_CONTROL_8_DLL_AUTO_UPDATE_EN_MASK 0x4
#define  MC_CH0_PHY_CONTROL_8_DLL_AUTO_UPDATE_EN_SHIFT 2
#define  MC_CH0_PHY_CONTROL_8_DLL_AUTO_UPDATE_EN_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_8_DLL_AUTO_UPDATE_EN_MASK) >> MC_CH0_PHY_CONTROL_8_DLL_AUTO_UPDATE_EN_SHIFT)
#define  MC_CH0_PHY_CONTROL_8_DLL_AUTO_UPDATE_EN_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_8_DLL_AUTO_UPDATE_EN_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_8_DLL_AUTO_UPDATE_EN_SHIFT))

#define  MC_CH0_PHY_CONTROL_8_RESERVED3_MASK 0x2
#define  MC_CH0_PHY_CONTROL_8_RESERVED3_SHIFT 1
#define  MC_CH0_PHY_CONTROL_8_RESERVED3_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_8_RESERVED3_MASK) >> MC_CH0_PHY_CONTROL_8_RESERVED3_SHIFT)
#define  MC_CH0_PHY_CONTROL_8_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_8_RESERVED3_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_8_RESERVED3_SHIFT))

#define  MC_CH0_PHY_CONTROL_8_DLL_UPDATE_BY_REF_EN_MASK 0x1
#define  MC_CH0_PHY_CONTROL_8_DLL_UPDATE_BY_REF_EN_SHIFT 0
#define  MC_CH0_PHY_CONTROL_8_DLL_UPDATE_BY_REF_EN_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_8_DLL_UPDATE_BY_REF_EN_MASK) >> MC_CH0_PHY_CONTROL_8_DLL_UPDATE_BY_REF_EN_SHIFT)
#define  MC_CH0_PHY_CONTROL_8_DLL_UPDATE_BY_REF_EN_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_8_DLL_UPDATE_BY_REF_EN_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_8_DLL_UPDATE_BY_REF_EN_SHIFT))

//====================================================================
//Register: PHY Control Register 9 (CH0_PHY_Control_9)
//====================================================================

#define  MC_CH0_PHY_CONTROL_9_PHY_SYNC_EN_MASK 0x80000000
#define  MC_CH0_PHY_CONTROL_9_PHY_SYNC_EN_SHIFT 31
#define  MC_CH0_PHY_CONTROL_9_PHY_SYNC_EN_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_9_PHY_SYNC_EN_MASK) >> MC_CH0_PHY_CONTROL_9_PHY_SYNC_EN_SHIFT)
#define  MC_CH0_PHY_CONTROL_9_PHY_SYNC_EN_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_9_PHY_SYNC_EN_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_9_PHY_SYNC_EN_SHIFT))

#define  MC_CH0_PHY_CONTROL_9_DLL_UPDATE_EN_PULSE_MASK 0x40000000
#define  MC_CH0_PHY_CONTROL_9_DLL_UPDATE_EN_PULSE_SHIFT 30
#define  MC_CH0_PHY_CONTROL_9_DLL_UPDATE_EN_PULSE_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_9_DLL_UPDATE_EN_PULSE_MASK) >> MC_CH0_PHY_CONTROL_9_DLL_UPDATE_EN_PULSE_SHIFT)
#define  MC_CH0_PHY_CONTROL_9_DLL_UPDATE_EN_PULSE_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_9_DLL_UPDATE_EN_PULSE_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_9_DLL_UPDATE_EN_PULSE_SHIFT))

#define  MC_CH0_PHY_CONTROL_9_PHY_DLL_RST_MASK 0x20000000
#define  MC_CH0_PHY_CONTROL_9_PHY_DLL_RST_SHIFT 29
#define  MC_CH0_PHY_CONTROL_9_PHY_DLL_RST_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_9_PHY_DLL_RST_MASK) >> MC_CH0_PHY_CONTROL_9_PHY_DLL_RST_SHIFT)
#define  MC_CH0_PHY_CONTROL_9_PHY_DLL_RST_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_9_PHY_DLL_RST_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_9_PHY_DLL_RST_SHIFT))

#define  MC_CH0_PHY_CONTROL_9_PHY_PLL_RST_MASK 0x10000000
#define  MC_CH0_PHY_CONTROL_9_PHY_PLL_RST_SHIFT 28
#define  MC_CH0_PHY_CONTROL_9_PHY_PLL_RST_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_9_PHY_PLL_RST_MASK) >> MC_CH0_PHY_CONTROL_9_PHY_PLL_RST_SHIFT)
#define  MC_CH0_PHY_CONTROL_9_PHY_PLL_RST_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_9_PHY_PLL_RST_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_9_PHY_PLL_RST_SHIFT))

#define  MC_CH0_PHY_CONTROL_9_RESERVED1_MASK 0xe000000
#define  MC_CH0_PHY_CONTROL_9_RESERVED1_SHIFT 25
#define  MC_CH0_PHY_CONTROL_9_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_9_RESERVED1_MASK) >> MC_CH0_PHY_CONTROL_9_RESERVED1_SHIFT)
#define  MC_CH0_PHY_CONTROL_9_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_9_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_9_RESERVED1_SHIFT))

#define  MC_CH0_PHY_CONTROL_9_PHY_CAL_ZPR_MASK 0x1f00000
#define  MC_CH0_PHY_CONTROL_9_PHY_CAL_ZPR_SHIFT 20
#define  MC_CH0_PHY_CONTROL_9_PHY_CAL_ZPR_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_9_PHY_CAL_ZPR_MASK) >> MC_CH0_PHY_CONTROL_9_PHY_CAL_ZPR_SHIFT)
#define  MC_CH0_PHY_CONTROL_9_PHY_CAL_ZPR_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_9_PHY_CAL_ZPR_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_9_PHY_CAL_ZPR_SHIFT))

#define  MC_CH0_PHY_CONTROL_9_PHY_CAL_ZNR_MASK 0xf8000
#define  MC_CH0_PHY_CONTROL_9_PHY_CAL_ZNR_SHIFT 15
#define  MC_CH0_PHY_CONTROL_9_PHY_CAL_ZNR_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_9_PHY_CAL_ZNR_MASK) >> MC_CH0_PHY_CONTROL_9_PHY_CAL_ZNR_SHIFT)
#define  MC_CH0_PHY_CONTROL_9_PHY_CAL_ZNR_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_9_PHY_CAL_ZNR_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_9_PHY_CAL_ZNR_SHIFT))

#define  MC_CH0_PHY_CONTROL_9_RESERVED2_MASK 0x7ff0
#define  MC_CH0_PHY_CONTROL_9_RESERVED2_SHIFT 4
#define  MC_CH0_PHY_CONTROL_9_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_9_RESERVED2_MASK) >> MC_CH0_PHY_CONTROL_9_RESERVED2_SHIFT)
#define  MC_CH0_PHY_CONTROL_9_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_9_RESERVED2_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_9_RESERVED2_SHIFT))

#define  MC_CH0_PHY_CONTROL_9_PHY_CAL_ERR_MASK 0x8
#define  MC_CH0_PHY_CONTROL_9_PHY_CAL_ERR_SHIFT 3
#define  MC_CH0_PHY_CONTROL_9_PHY_CAL_ERR_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_9_PHY_CAL_ERR_MASK) >> MC_CH0_PHY_CONTROL_9_PHY_CAL_ERR_SHIFT)
#define  MC_CH0_PHY_CONTROL_9_PHY_CAL_ERR_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_9_PHY_CAL_ERR_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_9_PHY_CAL_ERR_SHIFT))

#define  MC_CH0_PHY_CONTROL_9_PHY_CAL_DONE_MASK 0x4
#define  MC_CH0_PHY_CONTROL_9_PHY_CAL_DONE_SHIFT 2
#define  MC_CH0_PHY_CONTROL_9_PHY_CAL_DONE_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_9_PHY_CAL_DONE_MASK) >> MC_CH0_PHY_CONTROL_9_PHY_CAL_DONE_SHIFT)
#define  MC_CH0_PHY_CONTROL_9_PHY_CAL_DONE_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_9_PHY_CAL_DONE_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_9_PHY_CAL_DONE_SHIFT))

#define  MC_CH0_PHY_CONTROL_9_RESERVED3_MASK 0x3
#define  MC_CH0_PHY_CONTROL_9_RESERVED3_SHIFT 0
#define  MC_CH0_PHY_CONTROL_9_RESERVED3_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_9_RESERVED3_MASK) >> MC_CH0_PHY_CONTROL_9_RESERVED3_SHIFT)
#define  MC_CH0_PHY_CONTROL_9_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_9_RESERVED3_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_9_RESERVED3_SHIFT))

//====================================================================
//Register: PHY Control Register 10 (CH0_PHY_Control_10)
//====================================================================

#define  MC_CH0_PHY_CONTROL_10_PHY_WL_DQS_PULSE_MASK 0x80000000
#define  MC_CH0_PHY_CONTROL_10_PHY_WL_DQS_PULSE_SHIFT 31
#define  MC_CH0_PHY_CONTROL_10_PHY_WL_DQS_PULSE_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_10_PHY_WL_DQS_PULSE_MASK) >> MC_CH0_PHY_CONTROL_10_PHY_WL_DQS_PULSE_SHIFT)
#define  MC_CH0_PHY_CONTROL_10_PHY_WL_DQS_PULSE_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_10_PHY_WL_DQS_PULSE_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_10_PHY_WL_DQS_PULSE_SHIFT))

#define  MC_CH0_PHY_CONTROL_10_RESERVED1_MASK 0x7ffffe00
#define  MC_CH0_PHY_CONTROL_10_RESERVED1_SHIFT 9
#define  MC_CH0_PHY_CONTROL_10_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_10_RESERVED1_MASK) >> MC_CH0_PHY_CONTROL_10_RESERVED1_SHIFT)
#define  MC_CH0_PHY_CONTROL_10_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_10_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_10_RESERVED1_SHIFT))

#define  MC_CH0_PHY_CONTROL_10_PHY_WL_DQ_OUT_MASK 0x1ff
#define  MC_CH0_PHY_CONTROL_10_PHY_WL_DQ_OUT_SHIFT 0
#define  MC_CH0_PHY_CONTROL_10_PHY_WL_DQ_OUT_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_10_PHY_WL_DQ_OUT_MASK) >> MC_CH0_PHY_CONTROL_10_PHY_WL_DQ_OUT_SHIFT)
#define  MC_CH0_PHY_CONTROL_10_PHY_WL_DQ_OUT_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_10_PHY_WL_DQ_OUT_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_10_PHY_WL_DQ_OUT_SHIFT))

//====================================================================
//Register: PHY Control Register 11 (CH0_PHY_Control_11)
//====================================================================

#define  MC_CH0_PHY_CONTROL_11_RESERVED1_MASK 0xffffff80
#define  MC_CH0_PHY_CONTROL_11_RESERVED1_SHIFT 7
#define  MC_CH0_PHY_CONTROL_11_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_11_RESERVED1_MASK) >> MC_CH0_PHY_CONTROL_11_RESERVED1_SHIFT)
#define  MC_CH0_PHY_CONTROL_11_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_11_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_11_RESERVED1_SHIFT))

#define  MC_CH0_PHY_CONTROL_11_PHY_READ_GAP_RESET_CYCLE_MASK 0x70
#define  MC_CH0_PHY_CONTROL_11_PHY_READ_GAP_RESET_CYCLE_SHIFT 4
#define  MC_CH0_PHY_CONTROL_11_PHY_READ_GAP_RESET_CYCLE_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_11_PHY_READ_GAP_RESET_CYCLE_MASK) >> MC_CH0_PHY_CONTROL_11_PHY_READ_GAP_RESET_CYCLE_SHIFT)
#define  MC_CH0_PHY_CONTROL_11_PHY_READ_GAP_RESET_CYCLE_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_11_PHY_READ_GAP_RESET_CYCLE_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_11_PHY_READ_GAP_RESET_CYCLE_SHIFT))

#define  MC_CH0_PHY_CONTROL_11_RESERVED2_MASK 0xe
#define  MC_CH0_PHY_CONTROL_11_RESERVED2_SHIFT 1
#define  MC_CH0_PHY_CONTROL_11_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_11_RESERVED2_MASK) >> MC_CH0_PHY_CONTROL_11_RESERVED2_SHIFT)
#define  MC_CH0_PHY_CONTROL_11_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_11_RESERVED2_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_11_RESERVED2_SHIFT))

#define  MC_CH0_PHY_CONTROL_11_PHY_READ_GAP_RESET_EN_MASK 0x1
#define  MC_CH0_PHY_CONTROL_11_PHY_READ_GAP_RESET_EN_SHIFT 0
#define  MC_CH0_PHY_CONTROL_11_PHY_READ_GAP_RESET_EN_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_11_PHY_READ_GAP_RESET_EN_MASK) >> MC_CH0_PHY_CONTROL_11_PHY_READ_GAP_RESET_EN_SHIFT)
#define  MC_CH0_PHY_CONTROL_11_PHY_READ_GAP_RESET_EN_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_11_PHY_READ_GAP_RESET_EN_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_11_PHY_READ_GAP_RESET_EN_SHIFT))

//====================================================================
//Register: PHY Control Register 12 (CH0_PHY_Control_12)
//====================================================================

#define  MC_CH0_PHY_CONTROL_12_RESERVE_CK_MASK 0xff000000
#define  MC_CH0_PHY_CONTROL_12_RESERVE_CK_SHIFT 24
#define  MC_CH0_PHY_CONTROL_12_RESERVE_CK_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_12_RESERVE_CK_MASK) >> MC_CH0_PHY_CONTROL_12_RESERVE_CK_SHIFT)
#define  MC_CH0_PHY_CONTROL_12_RESERVE_CK_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_12_RESERVE_CK_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_12_RESERVE_CK_SHIFT))

#define  MC_CH0_PHY_CONTROL_12_RESERVE_AC2_MASK 0xff0000
#define  MC_CH0_PHY_CONTROL_12_RESERVE_AC2_SHIFT 16
#define  MC_CH0_PHY_CONTROL_12_RESERVE_AC2_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_12_RESERVE_AC2_MASK) >> MC_CH0_PHY_CONTROL_12_RESERVE_AC2_SHIFT)
#define  MC_CH0_PHY_CONTROL_12_RESERVE_AC2_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_12_RESERVE_AC2_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_12_RESERVE_AC2_SHIFT))

#define  MC_CH0_PHY_CONTROL_12_RESERVE_AC1_MASK 0xff00
#define  MC_CH0_PHY_CONTROL_12_RESERVE_AC1_SHIFT 8
#define  MC_CH0_PHY_CONTROL_12_RESERVE_AC1_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_12_RESERVE_AC1_MASK) >> MC_CH0_PHY_CONTROL_12_RESERVE_AC1_SHIFT)
#define  MC_CH0_PHY_CONTROL_12_RESERVE_AC1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_12_RESERVE_AC1_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_12_RESERVE_AC1_SHIFT))

#define  MC_CH0_PHY_CONTROL_12_RESERVE_AC0_MASK 0xff
#define  MC_CH0_PHY_CONTROL_12_RESERVE_AC0_SHIFT 0
#define  MC_CH0_PHY_CONTROL_12_RESERVE_AC0_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_12_RESERVE_AC0_MASK) >> MC_CH0_PHY_CONTROL_12_RESERVE_AC0_SHIFT)
#define  MC_CH0_PHY_CONTROL_12_RESERVE_AC0_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_12_RESERVE_AC0_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_12_RESERVE_AC0_SHIFT))

//====================================================================
//Register: PHY Control Register 13 (CH0_PHY_Control_13)
//====================================================================

#define  MC_CH0_PHY_CONTROL_13_RESERVED1_MASK 0xff800000
#define  MC_CH0_PHY_CONTROL_13_RESERVED1_SHIFT 23
#define  MC_CH0_PHY_CONTROL_13_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_13_RESERVED1_MASK) >> MC_CH0_PHY_CONTROL_13_RESERVED1_SHIFT)
#define  MC_CH0_PHY_CONTROL_13_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_13_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_13_RESERVED1_SHIFT))

#define  MC_CH0_PHY_CONTROL_13_PHY_BA_PWRDWN_MASK 0x700000
#define  MC_CH0_PHY_CONTROL_13_PHY_BA_PWRDWN_SHIFT 20
#define  MC_CH0_PHY_CONTROL_13_PHY_BA_PWRDWN_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_13_PHY_BA_PWRDWN_MASK) >> MC_CH0_PHY_CONTROL_13_PHY_BA_PWRDWN_SHIFT)
#define  MC_CH0_PHY_CONTROL_13_PHY_BA_PWRDWN_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_13_PHY_BA_PWRDWN_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_13_PHY_BA_PWRDWN_SHIFT))

#define  MC_CH0_PHY_CONTROL_13_RESERVED2_MASK 0xc0000
#define  MC_CH0_PHY_CONTROL_13_RESERVED2_SHIFT 18
#define  MC_CH0_PHY_CONTROL_13_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_13_RESERVED2_MASK) >> MC_CH0_PHY_CONTROL_13_RESERVED2_SHIFT)
#define  MC_CH0_PHY_CONTROL_13_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_13_RESERVED2_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_13_RESERVED2_SHIFT))

#define  MC_CH0_PHY_CONTROL_13_PHY_AD_PWRDWN_MASK 0x3ffff
#define  MC_CH0_PHY_CONTROL_13_PHY_AD_PWRDWN_SHIFT 0
#define  MC_CH0_PHY_CONTROL_13_PHY_AD_PWRDWN_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_13_PHY_AD_PWRDWN_MASK) >> MC_CH0_PHY_CONTROL_13_PHY_AD_PWRDWN_SHIFT)
#define  MC_CH0_PHY_CONTROL_13_PHY_AD_PWRDWN_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_13_PHY_AD_PWRDWN_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_13_PHY_AD_PWRDWN_SHIFT))

//====================================================================
//Register: PHY Control Register 14 (CH0_PHY_Control_14)
//====================================================================

#define  MC_CH0_PHY_CONTROL_14_RESERVED1_MASK 0xfff00000
#define  MC_CH0_PHY_CONTROL_14_RESERVED1_SHIFT 20
#define  MC_CH0_PHY_CONTROL_14_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_14_RESERVED1_MASK) >> MC_CH0_PHY_CONTROL_14_RESERVED1_SHIFT)
#define  MC_CH0_PHY_CONTROL_14_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_14_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_14_RESERVED1_SHIFT))

#define  MC_CH0_PHY_CONTROL_14_PHY_RESETN_PWRDWN_MASK 0x80000
#define  MC_CH0_PHY_CONTROL_14_PHY_RESETN_PWRDWN_SHIFT 19
#define  MC_CH0_PHY_CONTROL_14_PHY_RESETN_PWRDWN_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_14_PHY_RESETN_PWRDWN_MASK) >> MC_CH0_PHY_CONTROL_14_PHY_RESETN_PWRDWN_SHIFT)
#define  MC_CH0_PHY_CONTROL_14_PHY_RESETN_PWRDWN_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_14_PHY_RESETN_PWRDWN_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_14_PHY_RESETN_PWRDWN_SHIFT))

#define  MC_CH0_PHY_CONTROL_14_PHY_WEN_PWRDWN_MASK 0x40000
#define  MC_CH0_PHY_CONTROL_14_PHY_WEN_PWRDWN_SHIFT 18
#define  MC_CH0_PHY_CONTROL_14_PHY_WEN_PWRDWN_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_14_PHY_WEN_PWRDWN_MASK) >> MC_CH0_PHY_CONTROL_14_PHY_WEN_PWRDWN_SHIFT)
#define  MC_CH0_PHY_CONTROL_14_PHY_WEN_PWRDWN_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_14_PHY_WEN_PWRDWN_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_14_PHY_WEN_PWRDWN_SHIFT))

#define  MC_CH0_PHY_CONTROL_14_PHY_CASN_PWRDWN_MASK 0x20000
#define  MC_CH0_PHY_CONTROL_14_PHY_CASN_PWRDWN_SHIFT 17
#define  MC_CH0_PHY_CONTROL_14_PHY_CASN_PWRDWN_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_14_PHY_CASN_PWRDWN_MASK) >> MC_CH0_PHY_CONTROL_14_PHY_CASN_PWRDWN_SHIFT)
#define  MC_CH0_PHY_CONTROL_14_PHY_CASN_PWRDWN_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_14_PHY_CASN_PWRDWN_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_14_PHY_CASN_PWRDWN_SHIFT))

#define  MC_CH0_PHY_CONTROL_14_PHY_RASN_PWRDWN_MASK 0x10000
#define  MC_CH0_PHY_CONTROL_14_PHY_RASN_PWRDWN_SHIFT 16
#define  MC_CH0_PHY_CONTROL_14_PHY_RASN_PWRDWN_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_14_PHY_RASN_PWRDWN_MASK) >> MC_CH0_PHY_CONTROL_14_PHY_RASN_PWRDWN_SHIFT)
#define  MC_CH0_PHY_CONTROL_14_PHY_RASN_PWRDWN_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_14_PHY_RASN_PWRDWN_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_14_PHY_RASN_PWRDWN_SHIFT))

#define  MC_CH0_PHY_CONTROL_14_PHY_ODT_PWRDWN_MASK 0xf000
#define  MC_CH0_PHY_CONTROL_14_PHY_ODT_PWRDWN_SHIFT 12
#define  MC_CH0_PHY_CONTROL_14_PHY_ODT_PWRDWN_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_14_PHY_ODT_PWRDWN_MASK) >> MC_CH0_PHY_CONTROL_14_PHY_ODT_PWRDWN_SHIFT)
#define  MC_CH0_PHY_CONTROL_14_PHY_ODT_PWRDWN_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_14_PHY_ODT_PWRDWN_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_14_PHY_ODT_PWRDWN_SHIFT))

#define  MC_CH0_PHY_CONTROL_14_PHY_CKE_PWRDWN_MASK 0xf00
#define  MC_CH0_PHY_CONTROL_14_PHY_CKE_PWRDWN_SHIFT 8
#define  MC_CH0_PHY_CONTROL_14_PHY_CKE_PWRDWN_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_14_PHY_CKE_PWRDWN_MASK) >> MC_CH0_PHY_CONTROL_14_PHY_CKE_PWRDWN_SHIFT)
#define  MC_CH0_PHY_CONTROL_14_PHY_CKE_PWRDWN_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_14_PHY_CKE_PWRDWN_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_14_PHY_CKE_PWRDWN_SHIFT))

#define  MC_CH0_PHY_CONTROL_14_PHY_CSN_PWRDWN_MASK 0xf0
#define  MC_CH0_PHY_CONTROL_14_PHY_CSN_PWRDWN_SHIFT 4
#define  MC_CH0_PHY_CONTROL_14_PHY_CSN_PWRDWN_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_14_PHY_CSN_PWRDWN_MASK) >> MC_CH0_PHY_CONTROL_14_PHY_CSN_PWRDWN_SHIFT)
#define  MC_CH0_PHY_CONTROL_14_PHY_CSN_PWRDWN_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_14_PHY_CSN_PWRDWN_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_14_PHY_CSN_PWRDWN_SHIFT))

#define  MC_CH0_PHY_CONTROL_14_PHY_CK_PWRDWN_MASK 0xf
#define  MC_CH0_PHY_CONTROL_14_PHY_CK_PWRDWN_SHIFT 0
#define  MC_CH0_PHY_CONTROL_14_PHY_CK_PWRDWN_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_14_PHY_CK_PWRDWN_MASK) >> MC_CH0_PHY_CONTROL_14_PHY_CK_PWRDWN_SHIFT)
#define  MC_CH0_PHY_CONTROL_14_PHY_CK_PWRDWN_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_14_PHY_CK_PWRDWN_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_14_PHY_CK_PWRDWN_SHIFT))

//====================================================================
//Register: PHY Control Register 15 (CH0_PHY_Control_15)
//====================================================================

#define  MC_CH0_PHY_CONTROL_15_PHY_VREF_RNGE_MASK 0x80000000
#define  MC_CH0_PHY_CONTROL_15_PHY_VREF_RNGE_SHIFT 31
#define  MC_CH0_PHY_CONTROL_15_PHY_VREF_RNGE_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_15_PHY_VREF_RNGE_MASK) >> MC_CH0_PHY_CONTROL_15_PHY_VREF_RNGE_SHIFT)
#define  MC_CH0_PHY_CONTROL_15_PHY_VREF_RNGE_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_15_PHY_VREF_RNGE_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_15_PHY_VREF_RNGE_SHIFT))

#define  MC_CH0_PHY_CONTROL_15_RESERVED1_MASK 0x40000000
#define  MC_CH0_PHY_CONTROL_15_RESERVED1_SHIFT 30
#define  MC_CH0_PHY_CONTROL_15_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_15_RESERVED1_MASK) >> MC_CH0_PHY_CONTROL_15_RESERVED1_SHIFT)
#define  MC_CH0_PHY_CONTROL_15_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_15_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_15_RESERVED1_SHIFT))

#define  MC_CH0_PHY_CONTROL_15_PHY_VREF_CTRL_MASK 0x3f000000
#define  MC_CH0_PHY_CONTROL_15_PHY_VREF_CTRL_SHIFT 24
#define  MC_CH0_PHY_CONTROL_15_PHY_VREF_CTRL_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_15_PHY_VREF_CTRL_MASK) >> MC_CH0_PHY_CONTROL_15_PHY_VREF_CTRL_SHIFT)
#define  MC_CH0_PHY_CONTROL_15_PHY_VREF_CTRL_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_15_PHY_VREF_CTRL_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_15_PHY_VREF_CTRL_SHIFT))

#define  MC_CH0_PHY_CONTROL_15_RESERVED2_MASK 0xc00000
#define  MC_CH0_PHY_CONTROL_15_RESERVED2_SHIFT 22
#define  MC_CH0_PHY_CONTROL_15_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_15_RESERVED2_MASK) >> MC_CH0_PHY_CONTROL_15_RESERVED2_SHIFT)
#define  MC_CH0_PHY_CONTROL_15_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_15_RESERVED2_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_15_RESERVED2_SHIFT))

#define  MC_CH0_PHY_CONTROL_15_PHY_TSTPT_SEL_MASK 0x300000
#define  MC_CH0_PHY_CONTROL_15_PHY_TSTPT_SEL_SHIFT 20
#define  MC_CH0_PHY_CONTROL_15_PHY_TSTPT_SEL_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_15_PHY_TSTPT_SEL_MASK) >> MC_CH0_PHY_CONTROL_15_PHY_TSTPT_SEL_SHIFT)
#define  MC_CH0_PHY_CONTROL_15_PHY_TSTPT_SEL_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_15_PHY_TSTPT_SEL_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_15_PHY_TSTPT_SEL_SHIFT))

#define  MC_CH0_PHY_CONTROL_15_RESERVED3_MASK 0x80000
#define  MC_CH0_PHY_CONTROL_15_RESERVED3_SHIFT 19
#define  MC_CH0_PHY_CONTROL_15_RESERVED3_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_15_RESERVED3_MASK) >> MC_CH0_PHY_CONTROL_15_RESERVED3_SHIFT)
#define  MC_CH0_PHY_CONTROL_15_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_15_RESERVED3_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_15_RESERVED3_SHIFT))

#define  MC_CH0_PHY_CONTROL_15_PHY_REFBUF_TRI_MASK 0x40000
#define  MC_CH0_PHY_CONTROL_15_PHY_REFBUF_TRI_SHIFT 18
#define  MC_CH0_PHY_CONTROL_15_PHY_REFBUF_TRI_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_15_PHY_REFBUF_TRI_MASK) >> MC_CH0_PHY_CONTROL_15_PHY_REFBUF_TRI_SHIFT)
#define  MC_CH0_PHY_CONTROL_15_PHY_REFBUF_TRI_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_15_PHY_REFBUF_TRI_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_15_PHY_REFBUF_TRI_SHIFT))

#define  MC_CH0_PHY_CONTROL_15_PHY_REFBUF_BYP_MASK 0x20000
#define  MC_CH0_PHY_CONTROL_15_PHY_REFBUF_BYP_SHIFT 17
#define  MC_CH0_PHY_CONTROL_15_PHY_REFBUF_BYP_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_15_PHY_REFBUF_BYP_MASK) >> MC_CH0_PHY_CONTROL_15_PHY_REFBUF_BYP_SHIFT)
#define  MC_CH0_PHY_CONTROL_15_PHY_REFBUF_BYP_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_15_PHY_REFBUF_BYP_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_15_PHY_REFBUF_BYP_SHIFT))

#define  MC_CH0_PHY_CONTROL_15_PHY_PU_MASK 0x10000
#define  MC_CH0_PHY_CONTROL_15_PHY_PU_SHIFT 16
#define  MC_CH0_PHY_CONTROL_15_PHY_PU_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_15_PHY_PU_MASK) >> MC_CH0_PHY_CONTROL_15_PHY_PU_SHIFT)
#define  MC_CH0_PHY_CONTROL_15_PHY_PU_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_15_PHY_PU_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_15_PHY_PU_SHIFT))

#define  MC_CH0_PHY_CONTROL_15_RESERVED4_MASK 0xf000
#define  MC_CH0_PHY_CONTROL_15_RESERVED4_SHIFT 12
#define  MC_CH0_PHY_CONTROL_15_RESERVED4_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_15_RESERVED4_MASK) >> MC_CH0_PHY_CONTROL_15_RESERVED4_SHIFT)
#define  MC_CH0_PHY_CONTROL_15_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_15_RESERVED4_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_15_RESERVED4_SHIFT))

#define  MC_CH0_PHY_CONTROL_15_PHY_CP_REF_SEL_MASK 0xf00
#define  MC_CH0_PHY_CONTROL_15_PHY_CP_REF_SEL_SHIFT 8
#define  MC_CH0_PHY_CONTROL_15_PHY_CP_REF_SEL_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_15_PHY_CP_REF_SEL_MASK) >> MC_CH0_PHY_CONTROL_15_PHY_CP_REF_SEL_SHIFT)
#define  MC_CH0_PHY_CONTROL_15_PHY_CP_REF_SEL_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_15_PHY_CP_REF_SEL_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_15_PHY_CP_REF_SEL_SHIFT))

#define  MC_CH0_PHY_CONTROL_15_PHY_CP_TEST_EN_MASK 0x80
#define  MC_CH0_PHY_CONTROL_15_PHY_CP_TEST_EN_SHIFT 7
#define  MC_CH0_PHY_CONTROL_15_PHY_CP_TEST_EN_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_15_PHY_CP_TEST_EN_MASK) >> MC_CH0_PHY_CONTROL_15_PHY_CP_TEST_EN_SHIFT)
#define  MC_CH0_PHY_CONTROL_15_PHY_CP_TEST_EN_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_15_PHY_CP_TEST_EN_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_15_PHY_CP_TEST_EN_SHIFT))

#define  MC_CH0_PHY_CONTROL_15_PHY_VREFINT_EN_MASK 0x40
#define  MC_CH0_PHY_CONTROL_15_PHY_VREFINT_EN_SHIFT 6
#define  MC_CH0_PHY_CONTROL_15_PHY_VREFINT_EN_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_15_PHY_VREFINT_EN_MASK) >> MC_CH0_PHY_CONTROL_15_PHY_VREFINT_EN_SHIFT)
#define  MC_CH0_PHY_CONTROL_15_PHY_VREFINT_EN_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_15_PHY_VREFINT_EN_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_15_PHY_VREFINT_EN_SHIFT))

#define  MC_CH0_PHY_CONTROL_15_PHY_REG_SLP_MASK 0x20
#define  MC_CH0_PHY_CONTROL_15_PHY_REG_SLP_SHIFT 5
#define  MC_CH0_PHY_CONTROL_15_PHY_REG_SLP_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_15_PHY_REG_SLP_MASK) >> MC_CH0_PHY_CONTROL_15_PHY_REG_SLP_SHIFT)
#define  MC_CH0_PHY_CONTROL_15_PHY_REG_SLP_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_15_PHY_REG_SLP_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_15_PHY_REG_SLP_SHIFT))

#define  MC_CH0_PHY_CONTROL_15_PHY_REG_PD_MASK 0x10
#define  MC_CH0_PHY_CONTROL_15_PHY_REG_PD_SHIFT 4
#define  MC_CH0_PHY_CONTROL_15_PHY_REG_PD_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_15_PHY_REG_PD_MASK) >> MC_CH0_PHY_CONTROL_15_PHY_REG_PD_SHIFT)
#define  MC_CH0_PHY_CONTROL_15_PHY_REG_PD_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_15_PHY_REG_PD_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_15_PHY_REG_PD_SHIFT))

#define  MC_CH0_PHY_CONTROL_15_RESERVED5_MASK 0xc
#define  MC_CH0_PHY_CONTROL_15_RESERVED5_SHIFT 2
#define  MC_CH0_PHY_CONTROL_15_RESERVED5_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_15_RESERVED5_MASK) >> MC_CH0_PHY_CONTROL_15_RESERVED5_SHIFT)
#define  MC_CH0_PHY_CONTROL_15_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_15_RESERVED5_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_15_RESERVED5_SHIFT))

#define  MC_CH0_PHY_CONTROL_15_PHY_WRST_SEL_MASK 0x3
#define  MC_CH0_PHY_CONTROL_15_PHY_WRST_SEL_SHIFT 0
#define  MC_CH0_PHY_CONTROL_15_PHY_WRST_SEL_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_15_PHY_WRST_SEL_MASK) >> MC_CH0_PHY_CONTROL_15_PHY_WRST_SEL_SHIFT)
#define  MC_CH0_PHY_CONTROL_15_PHY_WRST_SEL_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_15_PHY_WRST_SEL_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_15_PHY_WRST_SEL_SHIFT))

//====================================================================
//Register: PHY Control Register 16 (CH0_PHY_Control_16)
//====================================================================

#define  MC_CH0_PHY_CONTROL_16_RESERVED1_MASK 0xfffff000
#define  MC_CH0_PHY_CONTROL_16_RESERVED1_SHIFT 12
#define  MC_CH0_PHY_CONTROL_16_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_16_RESERVED1_MASK) >> MC_CH0_PHY_CONTROL_16_RESERVED1_SHIFT)
#define  MC_CH0_PHY_CONTROL_16_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_16_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_16_RESERVED1_SHIFT))

#define  MC_CH0_PHY_CONTROL_16_PHY_DMSYNC_RESERVED_MASK 0xf00
#define  MC_CH0_PHY_CONTROL_16_PHY_DMSYNC_RESERVED_SHIFT 8
#define  MC_CH0_PHY_CONTROL_16_PHY_DMSYNC_RESERVED_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_16_PHY_DMSYNC_RESERVED_MASK) >> MC_CH0_PHY_CONTROL_16_PHY_DMSYNC_RESERVED_SHIFT)
#define  MC_CH0_PHY_CONTROL_16_PHY_DMSYNC_RESERVED_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_16_PHY_DMSYNC_RESERVED_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_16_PHY_DMSYNC_RESERVED_SHIFT))

#define  MC_CH0_PHY_CONTROL_16_PHY_WCKG_DLY_MASK 0xf0
#define  MC_CH0_PHY_CONTROL_16_PHY_WCKG_DLY_SHIFT 4
#define  MC_CH0_PHY_CONTROL_16_PHY_WCKG_DLY_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_16_PHY_WCKG_DLY_MASK) >> MC_CH0_PHY_CONTROL_16_PHY_WCKG_DLY_SHIFT)
#define  MC_CH0_PHY_CONTROL_16_PHY_WCKG_DLY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_16_PHY_WCKG_DLY_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_16_PHY_WCKG_DLY_SHIFT))

#define  MC_CH0_PHY_CONTROL_16_RESERVED2_MASK 0xe
#define  MC_CH0_PHY_CONTROL_16_RESERVED2_SHIFT 1
#define  MC_CH0_PHY_CONTROL_16_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_16_RESERVED2_MASK) >> MC_CH0_PHY_CONTROL_16_RESERVED2_SHIFT)
#define  MC_CH0_PHY_CONTROL_16_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_16_RESERVED2_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_16_RESERVED2_SHIFT))

#define  MC_CH0_PHY_CONTROL_16_PHY_WCK_EN_MASK 0x1
#define  MC_CH0_PHY_CONTROL_16_PHY_WCK_EN_SHIFT 0
#define  MC_CH0_PHY_CONTROL_16_PHY_WCK_EN_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_16_PHY_WCK_EN_MASK) >> MC_CH0_PHY_CONTROL_16_PHY_WCK_EN_SHIFT)
#define  MC_CH0_PHY_CONTROL_16_PHY_WCK_EN_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_16_PHY_WCK_EN_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_16_PHY_WCK_EN_SHIFT))

//====================================================================
//Register: PHY Control Register 17 (CH0_PHY_Control_17)
//====================================================================

#define  MC_CH0_PHY_CONTROL_17_RESERVED1_MASK 0xfffff000
#define  MC_CH0_PHY_CONTROL_17_RESERVED1_SHIFT 12
#define  MC_CH0_PHY_CONTROL_17_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_17_RESERVED1_MASK) >> MC_CH0_PHY_CONTROL_17_RESERVED1_SHIFT)
#define  MC_CH0_PHY_CONTROL_17_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_17_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_17_RESERVED1_SHIFT))

#define  MC_CH0_PHY_CONTROL_17_VREG_BYPASS_MASK 0x800
#define  MC_CH0_PHY_CONTROL_17_VREG_BYPASS_SHIFT 11
#define  MC_CH0_PHY_CONTROL_17_VREG_BYPASS_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_17_VREG_BYPASS_MASK) >> MC_CH0_PHY_CONTROL_17_VREG_BYPASS_SHIFT)
#define  MC_CH0_PHY_CONTROL_17_VREG_BYPASS_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_17_VREG_BYPASS_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_17_VREG_BYPASS_SHIFT))

#define  MC_CH0_PHY_CONTROL_17_VREG_PU_MASK 0x400
#define  MC_CH0_PHY_CONTROL_17_VREG_PU_SHIFT 10
#define  MC_CH0_PHY_CONTROL_17_VREG_PU_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_17_VREG_PU_MASK) >> MC_CH0_PHY_CONTROL_17_VREG_PU_SHIFT)
#define  MC_CH0_PHY_CONTROL_17_VREG_PU_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_17_VREG_PU_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_17_VREG_PU_SHIFT))

#define  MC_CH0_PHY_CONTROL_17_VREG_LP_MASK 0x200
#define  MC_CH0_PHY_CONTROL_17_VREG_LP_SHIFT 9
#define  MC_CH0_PHY_CONTROL_17_VREG_LP_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_17_VREG_LP_MASK) >> MC_CH0_PHY_CONTROL_17_VREG_LP_SHIFT)
#define  MC_CH0_PHY_CONTROL_17_VREG_LP_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_17_VREG_LP_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_17_VREG_LP_SHIFT))

#define  MC_CH0_PHY_CONTROL_17_VREG_TSTMON_EN_MASK 0x100
#define  MC_CH0_PHY_CONTROL_17_VREG_TSTMON_EN_SHIFT 8
#define  MC_CH0_PHY_CONTROL_17_VREG_TSTMON_EN_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_17_VREG_TSTMON_EN_MASK) >> MC_CH0_PHY_CONTROL_17_VREG_TSTMON_EN_SHIFT)
#define  MC_CH0_PHY_CONTROL_17_VREG_TSTMON_EN_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_17_VREG_TSTMON_EN_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_17_VREG_TSTMON_EN_SHIFT))

#define  MC_CH0_PHY_CONTROL_17_RESERVED2_MASK 0x80
#define  MC_CH0_PHY_CONTROL_17_RESERVED2_SHIFT 7
#define  MC_CH0_PHY_CONTROL_17_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_17_RESERVED2_MASK) >> MC_CH0_PHY_CONTROL_17_RESERVED2_SHIFT)
#define  MC_CH0_PHY_CONTROL_17_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_17_RESERVED2_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_17_RESERVED2_SHIFT))

#define  MC_CH0_PHY_CONTROL_17_VREG_TESTMON_MASK 0x70
#define  MC_CH0_PHY_CONTROL_17_VREG_TESTMON_SHIFT 4
#define  MC_CH0_PHY_CONTROL_17_VREG_TESTMON_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_17_VREG_TESTMON_MASK) >> MC_CH0_PHY_CONTROL_17_VREG_TESTMON_SHIFT)
#define  MC_CH0_PHY_CONTROL_17_VREG_TESTMON_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_17_VREG_TESTMON_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_17_VREG_TESTMON_SHIFT))

#define  MC_CH0_PHY_CONTROL_17_RESERVED3_MASK 0x8
#define  MC_CH0_PHY_CONTROL_17_RESERVED3_SHIFT 3
#define  MC_CH0_PHY_CONTROL_17_RESERVED3_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_17_RESERVED3_MASK) >> MC_CH0_PHY_CONTROL_17_RESERVED3_SHIFT)
#define  MC_CH0_PHY_CONTROL_17_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_17_RESERVED3_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_17_RESERVED3_SHIFT))

#define  MC_CH0_PHY_CONTROL_17_VREG_VSEL_MASK 0x7
#define  MC_CH0_PHY_CONTROL_17_VREG_VSEL_SHIFT 0
#define  MC_CH0_PHY_CONTROL_17_VREG_VSEL_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CONTROL_17_VREG_VSEL_MASK) >> MC_CH0_PHY_CONTROL_17_VREG_VSEL_SHIFT)
#define  MC_CH0_PHY_CONTROL_17_VREG_VSEL_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CONTROL_17_VREG_VSEL_MASK) | (((uint32_t)val) << MC_CH0_PHY_CONTROL_17_VREG_VSEL_SHIFT))

//====================================================================
//Register: PHY DLL Control Register (CH0_PHY_DLL_control_B0)
//====================================================================

#define  MC_CH0_PHY_DLL_CONTROL_B0_RESERVED1_MASK 0xc0000000
#define  MC_CH0_PHY_DLL_CONTROL_B0_RESERVED1_SHIFT 30
#define  MC_CH0_PHY_DLL_CONTROL_B0_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_DLL_CONTROL_B0_RESERVED1_MASK) >> MC_CH0_PHY_DLL_CONTROL_B0_RESERVED1_SHIFT)
#define  MC_CH0_PHY_DLL_CONTROL_B0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_DLL_CONTROL_B0_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_PHY_DLL_CONTROL_B0_RESERVED1_SHIFT))

#define  MC_CH0_PHY_DLL_CONTROL_B0_DLL_PHSEL1_MASK 0x3f000000
#define  MC_CH0_PHY_DLL_CONTROL_B0_DLL_PHSEL1_SHIFT 24
#define  MC_CH0_PHY_DLL_CONTROL_B0_DLL_PHSEL1_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_DLL_CONTROL_B0_DLL_PHSEL1_MASK) >> MC_CH0_PHY_DLL_CONTROL_B0_DLL_PHSEL1_SHIFT)
#define  MC_CH0_PHY_DLL_CONTROL_B0_DLL_PHSEL1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_DLL_CONTROL_B0_DLL_PHSEL1_MASK) | (((uint32_t)val) << MC_CH0_PHY_DLL_CONTROL_B0_DLL_PHSEL1_SHIFT))

#define  MC_CH0_PHY_DLL_CONTROL_B0_RESERVED2_MASK 0xc00000
#define  MC_CH0_PHY_DLL_CONTROL_B0_RESERVED2_SHIFT 22
#define  MC_CH0_PHY_DLL_CONTROL_B0_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_DLL_CONTROL_B0_RESERVED2_MASK) >> MC_CH0_PHY_DLL_CONTROL_B0_RESERVED2_SHIFT)
#define  MC_CH0_PHY_DLL_CONTROL_B0_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_DLL_CONTROL_B0_RESERVED2_MASK) | (((uint32_t)val) << MC_CH0_PHY_DLL_CONTROL_B0_RESERVED2_SHIFT))

#define  MC_CH0_PHY_DLL_CONTROL_B0_DLL_PHSEL_MASK 0x3f0000
#define  MC_CH0_PHY_DLL_CONTROL_B0_DLL_PHSEL_SHIFT 16
#define  MC_CH0_PHY_DLL_CONTROL_B0_DLL_PHSEL_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_DLL_CONTROL_B0_DLL_PHSEL_MASK) >> MC_CH0_PHY_DLL_CONTROL_B0_DLL_PHSEL_SHIFT)
#define  MC_CH0_PHY_DLL_CONTROL_B0_DLL_PHSEL_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_DLL_CONTROL_B0_DLL_PHSEL_MASK) | (((uint32_t)val) << MC_CH0_PHY_DLL_CONTROL_B0_DLL_PHSEL_SHIFT))

#define  MC_CH0_PHY_DLL_CONTROL_B0_RESERVED3_MASK 0xc000
#define  MC_CH0_PHY_DLL_CONTROL_B0_RESERVED3_SHIFT 14
#define  MC_CH0_PHY_DLL_CONTROL_B0_RESERVED3_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_DLL_CONTROL_B0_RESERVED3_MASK) >> MC_CH0_PHY_DLL_CONTROL_B0_RESERVED3_SHIFT)
#define  MC_CH0_PHY_DLL_CONTROL_B0_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_DLL_CONTROL_B0_RESERVED3_MASK) | (((uint32_t)val) << MC_CH0_PHY_DLL_CONTROL_B0_RESERVED3_SHIFT))

#define  MC_CH0_PHY_DLL_CONTROL_B0_DLL_DELAY_TEST_MASK 0x3ff0
#define  MC_CH0_PHY_DLL_CONTROL_B0_DLL_DELAY_TEST_SHIFT 4
#define  MC_CH0_PHY_DLL_CONTROL_B0_DLL_DELAY_TEST_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_DLL_CONTROL_B0_DLL_DELAY_TEST_MASK) >> MC_CH0_PHY_DLL_CONTROL_B0_DLL_DELAY_TEST_SHIFT)
#define  MC_CH0_PHY_DLL_CONTROL_B0_DLL_DELAY_TEST_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_DLL_CONTROL_B0_DLL_DELAY_TEST_MASK) | (((uint32_t)val) << MC_CH0_PHY_DLL_CONTROL_B0_DLL_DELAY_TEST_SHIFT))

#define  MC_CH0_PHY_DLL_CONTROL_B0_DLL_GAIN2X_MASK 0x8
#define  MC_CH0_PHY_DLL_CONTROL_B0_DLL_GAIN2X_SHIFT 3
#define  MC_CH0_PHY_DLL_CONTROL_B0_DLL_GAIN2X_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_DLL_CONTROL_B0_DLL_GAIN2X_MASK) >> MC_CH0_PHY_DLL_CONTROL_B0_DLL_GAIN2X_SHIFT)
#define  MC_CH0_PHY_DLL_CONTROL_B0_DLL_GAIN2X_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_DLL_CONTROL_B0_DLL_GAIN2X_MASK) | (((uint32_t)val) << MC_CH0_PHY_DLL_CONTROL_B0_DLL_GAIN2X_SHIFT))

#define  MC_CH0_PHY_DLL_CONTROL_B0_RESERVED4_MASK 0x4
#define  MC_CH0_PHY_DLL_CONTROL_B0_RESERVED4_SHIFT 2
#define  MC_CH0_PHY_DLL_CONTROL_B0_RESERVED4_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_DLL_CONTROL_B0_RESERVED4_MASK) >> MC_CH0_PHY_DLL_CONTROL_B0_RESERVED4_SHIFT)
#define  MC_CH0_PHY_DLL_CONTROL_B0_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_DLL_CONTROL_B0_RESERVED4_MASK) | (((uint32_t)val) << MC_CH0_PHY_DLL_CONTROL_B0_RESERVED4_SHIFT))

#define  MC_CH0_PHY_DLL_CONTROL_B0_DLL_TEST_EN_MASK 0x2
#define  MC_CH0_PHY_DLL_CONTROL_B0_DLL_TEST_EN_SHIFT 1
#define  MC_CH0_PHY_DLL_CONTROL_B0_DLL_TEST_EN_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_DLL_CONTROL_B0_DLL_TEST_EN_MASK) >> MC_CH0_PHY_DLL_CONTROL_B0_DLL_TEST_EN_SHIFT)
#define  MC_CH0_PHY_DLL_CONTROL_B0_DLL_TEST_EN_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_DLL_CONTROL_B0_DLL_TEST_EN_MASK) | (((uint32_t)val) << MC_CH0_PHY_DLL_CONTROL_B0_DLL_TEST_EN_SHIFT))

#define  MC_CH0_PHY_DLL_CONTROL_B0_DLL_BYPASS_EN_MASK 0x1
#define  MC_CH0_PHY_DLL_CONTROL_B0_DLL_BYPASS_EN_SHIFT 0
#define  MC_CH0_PHY_DLL_CONTROL_B0_DLL_BYPASS_EN_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_DLL_CONTROL_B0_DLL_BYPASS_EN_MASK) >> MC_CH0_PHY_DLL_CONTROL_B0_DLL_BYPASS_EN_SHIFT)
#define  MC_CH0_PHY_DLL_CONTROL_B0_DLL_BYPASS_EN_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_DLL_CONTROL_B0_DLL_BYPASS_EN_MASK) | (((uint32_t)val) << MC_CH0_PHY_DLL_CONTROL_B0_DLL_BYPASS_EN_SHIFT))

//====================================================================
//Register: PHY DLL Control Register (CH0_PHY_DLL_control_B1)
//====================================================================

#define  MC_CH0_PHY_DLL_CONTROL_B1_RESERVED1_MASK 0xc0000000
#define  MC_CH0_PHY_DLL_CONTROL_B1_RESERVED1_SHIFT 30
#define  MC_CH0_PHY_DLL_CONTROL_B1_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_DLL_CONTROL_B1_RESERVED1_MASK) >> MC_CH0_PHY_DLL_CONTROL_B1_RESERVED1_SHIFT)
#define  MC_CH0_PHY_DLL_CONTROL_B1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_DLL_CONTROL_B1_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_PHY_DLL_CONTROL_B1_RESERVED1_SHIFT))

#define  MC_CH0_PHY_DLL_CONTROL_B1_DLL_PHSEL1_MASK 0x3f000000
#define  MC_CH0_PHY_DLL_CONTROL_B1_DLL_PHSEL1_SHIFT 24
#define  MC_CH0_PHY_DLL_CONTROL_B1_DLL_PHSEL1_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_DLL_CONTROL_B1_DLL_PHSEL1_MASK) >> MC_CH0_PHY_DLL_CONTROL_B1_DLL_PHSEL1_SHIFT)
#define  MC_CH0_PHY_DLL_CONTROL_B1_DLL_PHSEL1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_DLL_CONTROL_B1_DLL_PHSEL1_MASK) | (((uint32_t)val) << MC_CH0_PHY_DLL_CONTROL_B1_DLL_PHSEL1_SHIFT))

#define  MC_CH0_PHY_DLL_CONTROL_B1_RESERVED2_MASK 0xc00000
#define  MC_CH0_PHY_DLL_CONTROL_B1_RESERVED2_SHIFT 22
#define  MC_CH0_PHY_DLL_CONTROL_B1_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_DLL_CONTROL_B1_RESERVED2_MASK) >> MC_CH0_PHY_DLL_CONTROL_B1_RESERVED2_SHIFT)
#define  MC_CH0_PHY_DLL_CONTROL_B1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_DLL_CONTROL_B1_RESERVED2_MASK) | (((uint32_t)val) << MC_CH0_PHY_DLL_CONTROL_B1_RESERVED2_SHIFT))

#define  MC_CH0_PHY_DLL_CONTROL_B1_DLL_PHSEL_MASK 0x3f0000
#define  MC_CH0_PHY_DLL_CONTROL_B1_DLL_PHSEL_SHIFT 16
#define  MC_CH0_PHY_DLL_CONTROL_B1_DLL_PHSEL_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_DLL_CONTROL_B1_DLL_PHSEL_MASK) >> MC_CH0_PHY_DLL_CONTROL_B1_DLL_PHSEL_SHIFT)
#define  MC_CH0_PHY_DLL_CONTROL_B1_DLL_PHSEL_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_DLL_CONTROL_B1_DLL_PHSEL_MASK) | (((uint32_t)val) << MC_CH0_PHY_DLL_CONTROL_B1_DLL_PHSEL_SHIFT))

#define  MC_CH0_PHY_DLL_CONTROL_B1_RESERVED3_MASK 0xc000
#define  MC_CH0_PHY_DLL_CONTROL_B1_RESERVED3_SHIFT 14
#define  MC_CH0_PHY_DLL_CONTROL_B1_RESERVED3_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_DLL_CONTROL_B1_RESERVED3_MASK) >> MC_CH0_PHY_DLL_CONTROL_B1_RESERVED3_SHIFT)
#define  MC_CH0_PHY_DLL_CONTROL_B1_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_DLL_CONTROL_B1_RESERVED3_MASK) | (((uint32_t)val) << MC_CH0_PHY_DLL_CONTROL_B1_RESERVED3_SHIFT))

#define  MC_CH0_PHY_DLL_CONTROL_B1_DLL_DELAY_TEST_MASK 0x3ff0
#define  MC_CH0_PHY_DLL_CONTROL_B1_DLL_DELAY_TEST_SHIFT 4
#define  MC_CH0_PHY_DLL_CONTROL_B1_DLL_DELAY_TEST_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_DLL_CONTROL_B1_DLL_DELAY_TEST_MASK) >> MC_CH0_PHY_DLL_CONTROL_B1_DLL_DELAY_TEST_SHIFT)
#define  MC_CH0_PHY_DLL_CONTROL_B1_DLL_DELAY_TEST_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_DLL_CONTROL_B1_DLL_DELAY_TEST_MASK) | (((uint32_t)val) << MC_CH0_PHY_DLL_CONTROL_B1_DLL_DELAY_TEST_SHIFT))

#define  MC_CH0_PHY_DLL_CONTROL_B1_DLL_GAIN2X_MASK 0x8
#define  MC_CH0_PHY_DLL_CONTROL_B1_DLL_GAIN2X_SHIFT 3
#define  MC_CH0_PHY_DLL_CONTROL_B1_DLL_GAIN2X_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_DLL_CONTROL_B1_DLL_GAIN2X_MASK) >> MC_CH0_PHY_DLL_CONTROL_B1_DLL_GAIN2X_SHIFT)
#define  MC_CH0_PHY_DLL_CONTROL_B1_DLL_GAIN2X_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_DLL_CONTROL_B1_DLL_GAIN2X_MASK) | (((uint32_t)val) << MC_CH0_PHY_DLL_CONTROL_B1_DLL_GAIN2X_SHIFT))

#define  MC_CH0_PHY_DLL_CONTROL_B1_RESERVED4_MASK 0x4
#define  MC_CH0_PHY_DLL_CONTROL_B1_RESERVED4_SHIFT 2
#define  MC_CH0_PHY_DLL_CONTROL_B1_RESERVED4_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_DLL_CONTROL_B1_RESERVED4_MASK) >> MC_CH0_PHY_DLL_CONTROL_B1_RESERVED4_SHIFT)
#define  MC_CH0_PHY_DLL_CONTROL_B1_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_DLL_CONTROL_B1_RESERVED4_MASK) | (((uint32_t)val) << MC_CH0_PHY_DLL_CONTROL_B1_RESERVED4_SHIFT))

#define  MC_CH0_PHY_DLL_CONTROL_B1_DLL_TEST_EN_MASK 0x2
#define  MC_CH0_PHY_DLL_CONTROL_B1_DLL_TEST_EN_SHIFT 1
#define  MC_CH0_PHY_DLL_CONTROL_B1_DLL_TEST_EN_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_DLL_CONTROL_B1_DLL_TEST_EN_MASK) >> MC_CH0_PHY_DLL_CONTROL_B1_DLL_TEST_EN_SHIFT)
#define  MC_CH0_PHY_DLL_CONTROL_B1_DLL_TEST_EN_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_DLL_CONTROL_B1_DLL_TEST_EN_MASK) | (((uint32_t)val) << MC_CH0_PHY_DLL_CONTROL_B1_DLL_TEST_EN_SHIFT))

#define  MC_CH0_PHY_DLL_CONTROL_B1_DLL_BYPASS_EN_MASK 0x1
#define  MC_CH0_PHY_DLL_CONTROL_B1_DLL_BYPASS_EN_SHIFT 0
#define  MC_CH0_PHY_DLL_CONTROL_B1_DLL_BYPASS_EN_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_DLL_CONTROL_B1_DLL_BYPASS_EN_MASK) >> MC_CH0_PHY_DLL_CONTROL_B1_DLL_BYPASS_EN_SHIFT)
#define  MC_CH0_PHY_DLL_CONTROL_B1_DLL_BYPASS_EN_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_DLL_CONTROL_B1_DLL_BYPASS_EN_MASK) | (((uint32_t)val) << MC_CH0_PHY_DLL_CONTROL_B1_DLL_BYPASS_EN_SHIFT))

//====================================================================
//Register: PHY DLL Control Register (CH0_PHY_DLL_control_B2)
//====================================================================

#define  MC_CH0_PHY_DLL_CONTROL_B2_RESERVED1_MASK 0xc0000000
#define  MC_CH0_PHY_DLL_CONTROL_B2_RESERVED1_SHIFT 30
#define  MC_CH0_PHY_DLL_CONTROL_B2_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_DLL_CONTROL_B2_RESERVED1_MASK) >> MC_CH0_PHY_DLL_CONTROL_B2_RESERVED1_SHIFT)
#define  MC_CH0_PHY_DLL_CONTROL_B2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_DLL_CONTROL_B2_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_PHY_DLL_CONTROL_B2_RESERVED1_SHIFT))

#define  MC_CH0_PHY_DLL_CONTROL_B2_DLL_PHSEL1_MASK 0x3f000000
#define  MC_CH0_PHY_DLL_CONTROL_B2_DLL_PHSEL1_SHIFT 24
#define  MC_CH0_PHY_DLL_CONTROL_B2_DLL_PHSEL1_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_DLL_CONTROL_B2_DLL_PHSEL1_MASK) >> MC_CH0_PHY_DLL_CONTROL_B2_DLL_PHSEL1_SHIFT)
#define  MC_CH0_PHY_DLL_CONTROL_B2_DLL_PHSEL1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_DLL_CONTROL_B2_DLL_PHSEL1_MASK) | (((uint32_t)val) << MC_CH0_PHY_DLL_CONTROL_B2_DLL_PHSEL1_SHIFT))

#define  MC_CH0_PHY_DLL_CONTROL_B2_RESERVED2_MASK 0xc00000
#define  MC_CH0_PHY_DLL_CONTROL_B2_RESERVED2_SHIFT 22
#define  MC_CH0_PHY_DLL_CONTROL_B2_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_DLL_CONTROL_B2_RESERVED2_MASK) >> MC_CH0_PHY_DLL_CONTROL_B2_RESERVED2_SHIFT)
#define  MC_CH0_PHY_DLL_CONTROL_B2_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_DLL_CONTROL_B2_RESERVED2_MASK) | (((uint32_t)val) << MC_CH0_PHY_DLL_CONTROL_B2_RESERVED2_SHIFT))

#define  MC_CH0_PHY_DLL_CONTROL_B2_DLL_PHSEL_MASK 0x3f0000
#define  MC_CH0_PHY_DLL_CONTROL_B2_DLL_PHSEL_SHIFT 16
#define  MC_CH0_PHY_DLL_CONTROL_B2_DLL_PHSEL_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_DLL_CONTROL_B2_DLL_PHSEL_MASK) >> MC_CH0_PHY_DLL_CONTROL_B2_DLL_PHSEL_SHIFT)
#define  MC_CH0_PHY_DLL_CONTROL_B2_DLL_PHSEL_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_DLL_CONTROL_B2_DLL_PHSEL_MASK) | (((uint32_t)val) << MC_CH0_PHY_DLL_CONTROL_B2_DLL_PHSEL_SHIFT))

#define  MC_CH0_PHY_DLL_CONTROL_B2_RESERVED3_MASK 0xc000
#define  MC_CH0_PHY_DLL_CONTROL_B2_RESERVED3_SHIFT 14
#define  MC_CH0_PHY_DLL_CONTROL_B2_RESERVED3_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_DLL_CONTROL_B2_RESERVED3_MASK) >> MC_CH0_PHY_DLL_CONTROL_B2_RESERVED3_SHIFT)
#define  MC_CH0_PHY_DLL_CONTROL_B2_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_DLL_CONTROL_B2_RESERVED3_MASK) | (((uint32_t)val) << MC_CH0_PHY_DLL_CONTROL_B2_RESERVED3_SHIFT))

#define  MC_CH0_PHY_DLL_CONTROL_B2_DLL_DELAY_TEST_MASK 0x3ff0
#define  MC_CH0_PHY_DLL_CONTROL_B2_DLL_DELAY_TEST_SHIFT 4
#define  MC_CH0_PHY_DLL_CONTROL_B2_DLL_DELAY_TEST_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_DLL_CONTROL_B2_DLL_DELAY_TEST_MASK) >> MC_CH0_PHY_DLL_CONTROL_B2_DLL_DELAY_TEST_SHIFT)
#define  MC_CH0_PHY_DLL_CONTROL_B2_DLL_DELAY_TEST_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_DLL_CONTROL_B2_DLL_DELAY_TEST_MASK) | (((uint32_t)val) << MC_CH0_PHY_DLL_CONTROL_B2_DLL_DELAY_TEST_SHIFT))

#define  MC_CH0_PHY_DLL_CONTROL_B2_DLL_GAIN2X_MASK 0x8
#define  MC_CH0_PHY_DLL_CONTROL_B2_DLL_GAIN2X_SHIFT 3
#define  MC_CH0_PHY_DLL_CONTROL_B2_DLL_GAIN2X_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_DLL_CONTROL_B2_DLL_GAIN2X_MASK) >> MC_CH0_PHY_DLL_CONTROL_B2_DLL_GAIN2X_SHIFT)
#define  MC_CH0_PHY_DLL_CONTROL_B2_DLL_GAIN2X_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_DLL_CONTROL_B2_DLL_GAIN2X_MASK) | (((uint32_t)val) << MC_CH0_PHY_DLL_CONTROL_B2_DLL_GAIN2X_SHIFT))

#define  MC_CH0_PHY_DLL_CONTROL_B2_RESERVED4_MASK 0x4
#define  MC_CH0_PHY_DLL_CONTROL_B2_RESERVED4_SHIFT 2
#define  MC_CH0_PHY_DLL_CONTROL_B2_RESERVED4_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_DLL_CONTROL_B2_RESERVED4_MASK) >> MC_CH0_PHY_DLL_CONTROL_B2_RESERVED4_SHIFT)
#define  MC_CH0_PHY_DLL_CONTROL_B2_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_DLL_CONTROL_B2_RESERVED4_MASK) | (((uint32_t)val) << MC_CH0_PHY_DLL_CONTROL_B2_RESERVED4_SHIFT))

#define  MC_CH0_PHY_DLL_CONTROL_B2_DLL_TEST_EN_MASK 0x2
#define  MC_CH0_PHY_DLL_CONTROL_B2_DLL_TEST_EN_SHIFT 1
#define  MC_CH0_PHY_DLL_CONTROL_B2_DLL_TEST_EN_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_DLL_CONTROL_B2_DLL_TEST_EN_MASK) >> MC_CH0_PHY_DLL_CONTROL_B2_DLL_TEST_EN_SHIFT)
#define  MC_CH0_PHY_DLL_CONTROL_B2_DLL_TEST_EN_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_DLL_CONTROL_B2_DLL_TEST_EN_MASK) | (((uint32_t)val) << MC_CH0_PHY_DLL_CONTROL_B2_DLL_TEST_EN_SHIFT))

#define  MC_CH0_PHY_DLL_CONTROL_B2_DLL_BYPASS_EN_MASK 0x1
#define  MC_CH0_PHY_DLL_CONTROL_B2_DLL_BYPASS_EN_SHIFT 0
#define  MC_CH0_PHY_DLL_CONTROL_B2_DLL_BYPASS_EN_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_DLL_CONTROL_B2_DLL_BYPASS_EN_MASK) >> MC_CH0_PHY_DLL_CONTROL_B2_DLL_BYPASS_EN_SHIFT)
#define  MC_CH0_PHY_DLL_CONTROL_B2_DLL_BYPASS_EN_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_DLL_CONTROL_B2_DLL_BYPASS_EN_MASK) | (((uint32_t)val) << MC_CH0_PHY_DLL_CONTROL_B2_DLL_BYPASS_EN_SHIFT))

//====================================================================
//Register: PHY DLL Control Register (CH0_PHY_DLL_control_B3)
//====================================================================

#define  MC_CH0_PHY_DLL_CONTROL_B3_RESERVED1_MASK 0xc0000000
#define  MC_CH0_PHY_DLL_CONTROL_B3_RESERVED1_SHIFT 30
#define  MC_CH0_PHY_DLL_CONTROL_B3_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_DLL_CONTROL_B3_RESERVED1_MASK) >> MC_CH0_PHY_DLL_CONTROL_B3_RESERVED1_SHIFT)
#define  MC_CH0_PHY_DLL_CONTROL_B3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_DLL_CONTROL_B3_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_PHY_DLL_CONTROL_B3_RESERVED1_SHIFT))

#define  MC_CH0_PHY_DLL_CONTROL_B3_DLL_PHSEL1_MASK 0x3f000000
#define  MC_CH0_PHY_DLL_CONTROL_B3_DLL_PHSEL1_SHIFT 24
#define  MC_CH0_PHY_DLL_CONTROL_B3_DLL_PHSEL1_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_DLL_CONTROL_B3_DLL_PHSEL1_MASK) >> MC_CH0_PHY_DLL_CONTROL_B3_DLL_PHSEL1_SHIFT)
#define  MC_CH0_PHY_DLL_CONTROL_B3_DLL_PHSEL1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_DLL_CONTROL_B3_DLL_PHSEL1_MASK) | (((uint32_t)val) << MC_CH0_PHY_DLL_CONTROL_B3_DLL_PHSEL1_SHIFT))

#define  MC_CH0_PHY_DLL_CONTROL_B3_RESERVED2_MASK 0xc00000
#define  MC_CH0_PHY_DLL_CONTROL_B3_RESERVED2_SHIFT 22
#define  MC_CH0_PHY_DLL_CONTROL_B3_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_DLL_CONTROL_B3_RESERVED2_MASK) >> MC_CH0_PHY_DLL_CONTROL_B3_RESERVED2_SHIFT)
#define  MC_CH0_PHY_DLL_CONTROL_B3_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_DLL_CONTROL_B3_RESERVED2_MASK) | (((uint32_t)val) << MC_CH0_PHY_DLL_CONTROL_B3_RESERVED2_SHIFT))

#define  MC_CH0_PHY_DLL_CONTROL_B3_DLL_PHSEL_MASK 0x3f0000
#define  MC_CH0_PHY_DLL_CONTROL_B3_DLL_PHSEL_SHIFT 16
#define  MC_CH0_PHY_DLL_CONTROL_B3_DLL_PHSEL_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_DLL_CONTROL_B3_DLL_PHSEL_MASK) >> MC_CH0_PHY_DLL_CONTROL_B3_DLL_PHSEL_SHIFT)
#define  MC_CH0_PHY_DLL_CONTROL_B3_DLL_PHSEL_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_DLL_CONTROL_B3_DLL_PHSEL_MASK) | (((uint32_t)val) << MC_CH0_PHY_DLL_CONTROL_B3_DLL_PHSEL_SHIFT))

#define  MC_CH0_PHY_DLL_CONTROL_B3_RESERVED3_MASK 0xc000
#define  MC_CH0_PHY_DLL_CONTROL_B3_RESERVED3_SHIFT 14
#define  MC_CH0_PHY_DLL_CONTROL_B3_RESERVED3_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_DLL_CONTROL_B3_RESERVED3_MASK) >> MC_CH0_PHY_DLL_CONTROL_B3_RESERVED3_SHIFT)
#define  MC_CH0_PHY_DLL_CONTROL_B3_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_DLL_CONTROL_B3_RESERVED3_MASK) | (((uint32_t)val) << MC_CH0_PHY_DLL_CONTROL_B3_RESERVED3_SHIFT))

#define  MC_CH0_PHY_DLL_CONTROL_B3_DLL_DELAY_TEST_MASK 0x3ff0
#define  MC_CH0_PHY_DLL_CONTROL_B3_DLL_DELAY_TEST_SHIFT 4
#define  MC_CH0_PHY_DLL_CONTROL_B3_DLL_DELAY_TEST_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_DLL_CONTROL_B3_DLL_DELAY_TEST_MASK) >> MC_CH0_PHY_DLL_CONTROL_B3_DLL_DELAY_TEST_SHIFT)
#define  MC_CH0_PHY_DLL_CONTROL_B3_DLL_DELAY_TEST_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_DLL_CONTROL_B3_DLL_DELAY_TEST_MASK) | (((uint32_t)val) << MC_CH0_PHY_DLL_CONTROL_B3_DLL_DELAY_TEST_SHIFT))

#define  MC_CH0_PHY_DLL_CONTROL_B3_DLL_GAIN2X_MASK 0x8
#define  MC_CH0_PHY_DLL_CONTROL_B3_DLL_GAIN2X_SHIFT 3
#define  MC_CH0_PHY_DLL_CONTROL_B3_DLL_GAIN2X_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_DLL_CONTROL_B3_DLL_GAIN2X_MASK) >> MC_CH0_PHY_DLL_CONTROL_B3_DLL_GAIN2X_SHIFT)
#define  MC_CH0_PHY_DLL_CONTROL_B3_DLL_GAIN2X_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_DLL_CONTROL_B3_DLL_GAIN2X_MASK) | (((uint32_t)val) << MC_CH0_PHY_DLL_CONTROL_B3_DLL_GAIN2X_SHIFT))

#define  MC_CH0_PHY_DLL_CONTROL_B3_RESERVED4_MASK 0x4
#define  MC_CH0_PHY_DLL_CONTROL_B3_RESERVED4_SHIFT 2
#define  MC_CH0_PHY_DLL_CONTROL_B3_RESERVED4_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_DLL_CONTROL_B3_RESERVED4_MASK) >> MC_CH0_PHY_DLL_CONTROL_B3_RESERVED4_SHIFT)
#define  MC_CH0_PHY_DLL_CONTROL_B3_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_DLL_CONTROL_B3_RESERVED4_MASK) | (((uint32_t)val) << MC_CH0_PHY_DLL_CONTROL_B3_RESERVED4_SHIFT))

#define  MC_CH0_PHY_DLL_CONTROL_B3_DLL_TEST_EN_MASK 0x2
#define  MC_CH0_PHY_DLL_CONTROL_B3_DLL_TEST_EN_SHIFT 1
#define  MC_CH0_PHY_DLL_CONTROL_B3_DLL_TEST_EN_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_DLL_CONTROL_B3_DLL_TEST_EN_MASK) >> MC_CH0_PHY_DLL_CONTROL_B3_DLL_TEST_EN_SHIFT)
#define  MC_CH0_PHY_DLL_CONTROL_B3_DLL_TEST_EN_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_DLL_CONTROL_B3_DLL_TEST_EN_MASK) | (((uint32_t)val) << MC_CH0_PHY_DLL_CONTROL_B3_DLL_TEST_EN_SHIFT))

#define  MC_CH0_PHY_DLL_CONTROL_B3_DLL_BYPASS_EN_MASK 0x1
#define  MC_CH0_PHY_DLL_CONTROL_B3_DLL_BYPASS_EN_SHIFT 0
#define  MC_CH0_PHY_DLL_CONTROL_B3_DLL_BYPASS_EN_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_DLL_CONTROL_B3_DLL_BYPASS_EN_MASK) >> MC_CH0_PHY_DLL_CONTROL_B3_DLL_BYPASS_EN_SHIFT)
#define  MC_CH0_PHY_DLL_CONTROL_B3_DLL_BYPASS_EN_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_DLL_CONTROL_B3_DLL_BYPASS_EN_MASK) | (((uint32_t)val) << MC_CH0_PHY_DLL_CONTROL_B3_DLL_BYPASS_EN_SHIFT))

//====================================================================
//Register: PHY DLL Byte Select Register (CH0_PHY_DLL_BYTE_SELECT)
//====================================================================

#define  MC_CH0_PHY_DLL_BYTE_SELECT_RESERVED1_MASK 0xfffffff0
#define  MC_CH0_PHY_DLL_BYTE_SELECT_RESERVED1_SHIFT 4
#define  MC_CH0_PHY_DLL_BYTE_SELECT_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_DLL_BYTE_SELECT_RESERVED1_MASK) >> MC_CH0_PHY_DLL_BYTE_SELECT_RESERVED1_SHIFT)
#define  MC_CH0_PHY_DLL_BYTE_SELECT_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_DLL_BYTE_SELECT_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_PHY_DLL_BYTE_SELECT_RESERVED1_SHIFT))

#define  MC_CH0_PHY_DLL_BYTE_SELECT_DLL_BYTE_SEL_MASK 0xf
#define  MC_CH0_PHY_DLL_BYTE_SELECT_DLL_BYTE_SEL_SHIFT 0
#define  MC_CH0_PHY_DLL_BYTE_SELECT_DLL_BYTE_SEL_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_DLL_BYTE_SELECT_DLL_BYTE_SEL_MASK) >> MC_CH0_PHY_DLL_BYTE_SELECT_DLL_BYTE_SEL_SHIFT)
#define  MC_CH0_PHY_DLL_BYTE_SELECT_DLL_BYTE_SEL_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_DLL_BYTE_SELECT_DLL_BYTE_SEL_MASK) | (((uint32_t)val) << MC_CH0_PHY_DLL_BYTE_SELECT_DLL_BYTE_SEL_SHIFT))

//====================================================================
//Register: PHY BYTE DLL Delay Register (CH0_PHY_DLL_DLY)
//====================================================================

#define  MC_CH0_PHY_DLL_DLY_RESERVED1_MASK 0xfc000000
#define  MC_CH0_PHY_DLL_DLY_RESERVED1_SHIFT 26
#define  MC_CH0_PHY_DLL_DLY_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_DLL_DLY_RESERVED1_MASK) >> MC_CH0_PHY_DLL_DLY_RESERVED1_SHIFT)
#define  MC_CH0_PHY_DLL_DLY_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_DLL_DLY_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_PHY_DLL_DLY_RESERVED1_SHIFT))

#define  MC_CH0_PHY_DLL_DLY_DLL_SLAVE_DELAY_OUT_MASK 0x3ff0000
#define  MC_CH0_PHY_DLL_DLY_DLL_SLAVE_DELAY_OUT_SHIFT 16
#define  MC_CH0_PHY_DLL_DLY_DLL_SLAVE_DELAY_OUT_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_DLL_DLY_DLL_SLAVE_DELAY_OUT_MASK) >> MC_CH0_PHY_DLL_DLY_DLL_SLAVE_DELAY_OUT_SHIFT)
#define  MC_CH0_PHY_DLL_DLY_DLL_SLAVE_DELAY_OUT_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_DLL_DLY_DLL_SLAVE_DELAY_OUT_MASK) | (((uint32_t)val) << MC_CH0_PHY_DLL_DLY_DLL_SLAVE_DELAY_OUT_SHIFT))

#define  MC_CH0_PHY_DLL_DLY_RESERVED2_MASK 0xfc00
#define  MC_CH0_PHY_DLL_DLY_RESERVED2_SHIFT 10
#define  MC_CH0_PHY_DLL_DLY_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_DLL_DLY_RESERVED2_MASK) >> MC_CH0_PHY_DLL_DLY_RESERVED2_SHIFT)
#define  MC_CH0_PHY_DLL_DLY_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_DLL_DLY_RESERVED2_MASK) | (((uint32_t)val) << MC_CH0_PHY_DLL_DLY_RESERVED2_SHIFT))

#define  MC_CH0_PHY_DLL_DLY_DLL_MASTER_DELAY_OUT_MASK 0x3ff
#define  MC_CH0_PHY_DLL_DLY_DLL_MASTER_DELAY_OUT_SHIFT 0
#define  MC_CH0_PHY_DLL_DLY_DLL_MASTER_DELAY_OUT_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_DLL_DLY_DLL_MASTER_DELAY_OUT_MASK) >> MC_CH0_PHY_DLL_DLY_DLL_MASTER_DELAY_OUT_SHIFT)
#define  MC_CH0_PHY_DLL_DLY_DLL_MASTER_DELAY_OUT_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_DLL_DLY_DLL_MASTER_DELAY_OUT_MASK) | (((uint32_t)val) << MC_CH0_PHY_DLL_DLY_DLL_MASTER_DELAY_OUT_SHIFT))

//====================================================================
//Register: PHY Data Byte Control Register (CH0_PHY_Data_Byte_Control_B0)
//====================================================================

#define  MC_CH0_PHY_DATA_BYTE_CONTROL_B0_RESERVED1_MASK 0xfffff800
#define  MC_CH0_PHY_DATA_BYTE_CONTROL_B0_RESERVED1_SHIFT 11
#define  MC_CH0_PHY_DATA_BYTE_CONTROL_B0_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_DATA_BYTE_CONTROL_B0_RESERVED1_MASK) >> MC_CH0_PHY_DATA_BYTE_CONTROL_B0_RESERVED1_SHIFT)
#define  MC_CH0_PHY_DATA_BYTE_CONTROL_B0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_DATA_BYTE_CONTROL_B0_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_PHY_DATA_BYTE_CONTROL_B0_RESERVED1_SHIFT))

#define  MC_CH0_PHY_DATA_BYTE_CONTROL_B0_PHY_DQ_PWRDWN_MASK 0x400
#define  MC_CH0_PHY_DATA_BYTE_CONTROL_B0_PHY_DQ_PWRDWN_SHIFT 10
#define  MC_CH0_PHY_DATA_BYTE_CONTROL_B0_PHY_DQ_PWRDWN_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_DATA_BYTE_CONTROL_B0_PHY_DQ_PWRDWN_MASK) >> MC_CH0_PHY_DATA_BYTE_CONTROL_B0_PHY_DQ_PWRDWN_SHIFT)
#define  MC_CH0_PHY_DATA_BYTE_CONTROL_B0_PHY_DQ_PWRDWN_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_DATA_BYTE_CONTROL_B0_PHY_DQ_PWRDWN_MASK) | (((uint32_t)val) << MC_CH0_PHY_DATA_BYTE_CONTROL_B0_PHY_DQ_PWRDWN_SHIFT))

#define  MC_CH0_PHY_DATA_BYTE_CONTROL_B0_PHY_DM_PWRDWN_MASK 0x200
#define  MC_CH0_PHY_DATA_BYTE_CONTROL_B0_PHY_DM_PWRDWN_SHIFT 9
#define  MC_CH0_PHY_DATA_BYTE_CONTROL_B0_PHY_DM_PWRDWN_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_DATA_BYTE_CONTROL_B0_PHY_DM_PWRDWN_MASK) >> MC_CH0_PHY_DATA_BYTE_CONTROL_B0_PHY_DM_PWRDWN_SHIFT)
#define  MC_CH0_PHY_DATA_BYTE_CONTROL_B0_PHY_DM_PWRDWN_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_DATA_BYTE_CONTROL_B0_PHY_DM_PWRDWN_MASK) | (((uint32_t)val) << MC_CH0_PHY_DATA_BYTE_CONTROL_B0_PHY_DM_PWRDWN_SHIFT))

#define  MC_CH0_PHY_DATA_BYTE_CONTROL_B0_PHY_DQS_PWRDWN_MASK 0x100
#define  MC_CH0_PHY_DATA_BYTE_CONTROL_B0_PHY_DQS_PWRDWN_SHIFT 8
#define  MC_CH0_PHY_DATA_BYTE_CONTROL_B0_PHY_DQS_PWRDWN_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_DATA_BYTE_CONTROL_B0_PHY_DQS_PWRDWN_MASK) >> MC_CH0_PHY_DATA_BYTE_CONTROL_B0_PHY_DQS_PWRDWN_SHIFT)
#define  MC_CH0_PHY_DATA_BYTE_CONTROL_B0_PHY_DQS_PWRDWN_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_DATA_BYTE_CONTROL_B0_PHY_DQS_PWRDWN_MASK) | (((uint32_t)val) << MC_CH0_PHY_DATA_BYTE_CONTROL_B0_PHY_DQS_PWRDWN_SHIFT))

#define  MC_CH0_PHY_DATA_BYTE_CONTROL_B0_PHY_DQ_RESERVE_MASK 0xff
#define  MC_CH0_PHY_DATA_BYTE_CONTROL_B0_PHY_DQ_RESERVE_SHIFT 0
#define  MC_CH0_PHY_DATA_BYTE_CONTROL_B0_PHY_DQ_RESERVE_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_DATA_BYTE_CONTROL_B0_PHY_DQ_RESERVE_MASK) >> MC_CH0_PHY_DATA_BYTE_CONTROL_B0_PHY_DQ_RESERVE_SHIFT)
#define  MC_CH0_PHY_DATA_BYTE_CONTROL_B0_PHY_DQ_RESERVE_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_DATA_BYTE_CONTROL_B0_PHY_DQ_RESERVE_MASK) | (((uint32_t)val) << MC_CH0_PHY_DATA_BYTE_CONTROL_B0_PHY_DQ_RESERVE_SHIFT))

//====================================================================
//Register: PHY Data Byte Control Register (CH0_PHY_Data_Byte_Control_B1)
//====================================================================

#define  MC_CH0_PHY_DATA_BYTE_CONTROL_B1_RESERVED1_MASK 0xfffff800
#define  MC_CH0_PHY_DATA_BYTE_CONTROL_B1_RESERVED1_SHIFT 11
#define  MC_CH0_PHY_DATA_BYTE_CONTROL_B1_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_DATA_BYTE_CONTROL_B1_RESERVED1_MASK) >> MC_CH0_PHY_DATA_BYTE_CONTROL_B1_RESERVED1_SHIFT)
#define  MC_CH0_PHY_DATA_BYTE_CONTROL_B1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_DATA_BYTE_CONTROL_B1_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_PHY_DATA_BYTE_CONTROL_B1_RESERVED1_SHIFT))

#define  MC_CH0_PHY_DATA_BYTE_CONTROL_B1_PHY_DQ_PWRDWN_MASK 0x400
#define  MC_CH0_PHY_DATA_BYTE_CONTROL_B1_PHY_DQ_PWRDWN_SHIFT 10
#define  MC_CH0_PHY_DATA_BYTE_CONTROL_B1_PHY_DQ_PWRDWN_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_DATA_BYTE_CONTROL_B1_PHY_DQ_PWRDWN_MASK) >> MC_CH0_PHY_DATA_BYTE_CONTROL_B1_PHY_DQ_PWRDWN_SHIFT)
#define  MC_CH0_PHY_DATA_BYTE_CONTROL_B1_PHY_DQ_PWRDWN_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_DATA_BYTE_CONTROL_B1_PHY_DQ_PWRDWN_MASK) | (((uint32_t)val) << MC_CH0_PHY_DATA_BYTE_CONTROL_B1_PHY_DQ_PWRDWN_SHIFT))

#define  MC_CH0_PHY_DATA_BYTE_CONTROL_B1_PHY_DM_PWRDWN_MASK 0x200
#define  MC_CH0_PHY_DATA_BYTE_CONTROL_B1_PHY_DM_PWRDWN_SHIFT 9
#define  MC_CH0_PHY_DATA_BYTE_CONTROL_B1_PHY_DM_PWRDWN_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_DATA_BYTE_CONTROL_B1_PHY_DM_PWRDWN_MASK) >> MC_CH0_PHY_DATA_BYTE_CONTROL_B1_PHY_DM_PWRDWN_SHIFT)
#define  MC_CH0_PHY_DATA_BYTE_CONTROL_B1_PHY_DM_PWRDWN_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_DATA_BYTE_CONTROL_B1_PHY_DM_PWRDWN_MASK) | (((uint32_t)val) << MC_CH0_PHY_DATA_BYTE_CONTROL_B1_PHY_DM_PWRDWN_SHIFT))

#define  MC_CH0_PHY_DATA_BYTE_CONTROL_B1_PHY_DQS_PWRDWN_MASK 0x100
#define  MC_CH0_PHY_DATA_BYTE_CONTROL_B1_PHY_DQS_PWRDWN_SHIFT 8
#define  MC_CH0_PHY_DATA_BYTE_CONTROL_B1_PHY_DQS_PWRDWN_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_DATA_BYTE_CONTROL_B1_PHY_DQS_PWRDWN_MASK) >> MC_CH0_PHY_DATA_BYTE_CONTROL_B1_PHY_DQS_PWRDWN_SHIFT)
#define  MC_CH0_PHY_DATA_BYTE_CONTROL_B1_PHY_DQS_PWRDWN_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_DATA_BYTE_CONTROL_B1_PHY_DQS_PWRDWN_MASK) | (((uint32_t)val) << MC_CH0_PHY_DATA_BYTE_CONTROL_B1_PHY_DQS_PWRDWN_SHIFT))

#define  MC_CH0_PHY_DATA_BYTE_CONTROL_B1_PHY_DQ_RESERVE_MASK 0xff
#define  MC_CH0_PHY_DATA_BYTE_CONTROL_B1_PHY_DQ_RESERVE_SHIFT 0
#define  MC_CH0_PHY_DATA_BYTE_CONTROL_B1_PHY_DQ_RESERVE_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_DATA_BYTE_CONTROL_B1_PHY_DQ_RESERVE_MASK) >> MC_CH0_PHY_DATA_BYTE_CONTROL_B1_PHY_DQ_RESERVE_SHIFT)
#define  MC_CH0_PHY_DATA_BYTE_CONTROL_B1_PHY_DQ_RESERVE_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_DATA_BYTE_CONTROL_B1_PHY_DQ_RESERVE_MASK) | (((uint32_t)val) << MC_CH0_PHY_DATA_BYTE_CONTROL_B1_PHY_DQ_RESERVE_SHIFT))

//====================================================================
//Register: PHY Data Byte Control Register (CH0_PHY_Data_Byte_Control_B2)
//====================================================================

#define  MC_CH0_PHY_DATA_BYTE_CONTROL_B2_RESERVED1_MASK 0xfffff800
#define  MC_CH0_PHY_DATA_BYTE_CONTROL_B2_RESERVED1_SHIFT 11
#define  MC_CH0_PHY_DATA_BYTE_CONTROL_B2_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_DATA_BYTE_CONTROL_B2_RESERVED1_MASK) >> MC_CH0_PHY_DATA_BYTE_CONTROL_B2_RESERVED1_SHIFT)
#define  MC_CH0_PHY_DATA_BYTE_CONTROL_B2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_DATA_BYTE_CONTROL_B2_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_PHY_DATA_BYTE_CONTROL_B2_RESERVED1_SHIFT))

#define  MC_CH0_PHY_DATA_BYTE_CONTROL_B2_PHY_DQ_PWRDWN_MASK 0x400
#define  MC_CH0_PHY_DATA_BYTE_CONTROL_B2_PHY_DQ_PWRDWN_SHIFT 10
#define  MC_CH0_PHY_DATA_BYTE_CONTROL_B2_PHY_DQ_PWRDWN_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_DATA_BYTE_CONTROL_B2_PHY_DQ_PWRDWN_MASK) >> MC_CH0_PHY_DATA_BYTE_CONTROL_B2_PHY_DQ_PWRDWN_SHIFT)
#define  MC_CH0_PHY_DATA_BYTE_CONTROL_B2_PHY_DQ_PWRDWN_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_DATA_BYTE_CONTROL_B2_PHY_DQ_PWRDWN_MASK) | (((uint32_t)val) << MC_CH0_PHY_DATA_BYTE_CONTROL_B2_PHY_DQ_PWRDWN_SHIFT))

#define  MC_CH0_PHY_DATA_BYTE_CONTROL_B2_PHY_DM_PWRDWN_MASK 0x200
#define  MC_CH0_PHY_DATA_BYTE_CONTROL_B2_PHY_DM_PWRDWN_SHIFT 9
#define  MC_CH0_PHY_DATA_BYTE_CONTROL_B2_PHY_DM_PWRDWN_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_DATA_BYTE_CONTROL_B2_PHY_DM_PWRDWN_MASK) >> MC_CH0_PHY_DATA_BYTE_CONTROL_B2_PHY_DM_PWRDWN_SHIFT)
#define  MC_CH0_PHY_DATA_BYTE_CONTROL_B2_PHY_DM_PWRDWN_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_DATA_BYTE_CONTROL_B2_PHY_DM_PWRDWN_MASK) | (((uint32_t)val) << MC_CH0_PHY_DATA_BYTE_CONTROL_B2_PHY_DM_PWRDWN_SHIFT))

#define  MC_CH0_PHY_DATA_BYTE_CONTROL_B2_PHY_DQS_PWRDWN_MASK 0x100
#define  MC_CH0_PHY_DATA_BYTE_CONTROL_B2_PHY_DQS_PWRDWN_SHIFT 8
#define  MC_CH0_PHY_DATA_BYTE_CONTROL_B2_PHY_DQS_PWRDWN_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_DATA_BYTE_CONTROL_B2_PHY_DQS_PWRDWN_MASK) >> MC_CH0_PHY_DATA_BYTE_CONTROL_B2_PHY_DQS_PWRDWN_SHIFT)
#define  MC_CH0_PHY_DATA_BYTE_CONTROL_B2_PHY_DQS_PWRDWN_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_DATA_BYTE_CONTROL_B2_PHY_DQS_PWRDWN_MASK) | (((uint32_t)val) << MC_CH0_PHY_DATA_BYTE_CONTROL_B2_PHY_DQS_PWRDWN_SHIFT))

#define  MC_CH0_PHY_DATA_BYTE_CONTROL_B2_PHY_DQ_RESERVE_MASK 0xff
#define  MC_CH0_PHY_DATA_BYTE_CONTROL_B2_PHY_DQ_RESERVE_SHIFT 0
#define  MC_CH0_PHY_DATA_BYTE_CONTROL_B2_PHY_DQ_RESERVE_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_DATA_BYTE_CONTROL_B2_PHY_DQ_RESERVE_MASK) >> MC_CH0_PHY_DATA_BYTE_CONTROL_B2_PHY_DQ_RESERVE_SHIFT)
#define  MC_CH0_PHY_DATA_BYTE_CONTROL_B2_PHY_DQ_RESERVE_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_DATA_BYTE_CONTROL_B2_PHY_DQ_RESERVE_MASK) | (((uint32_t)val) << MC_CH0_PHY_DATA_BYTE_CONTROL_B2_PHY_DQ_RESERVE_SHIFT))

//====================================================================
//Register: PHY Data Byte Control Register (CH0_PHY_Data_Byte_Control_B3)
//====================================================================

#define  MC_CH0_PHY_DATA_BYTE_CONTROL_B3_RESERVED1_MASK 0xfffff800
#define  MC_CH0_PHY_DATA_BYTE_CONTROL_B3_RESERVED1_SHIFT 11
#define  MC_CH0_PHY_DATA_BYTE_CONTROL_B3_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_DATA_BYTE_CONTROL_B3_RESERVED1_MASK) >> MC_CH0_PHY_DATA_BYTE_CONTROL_B3_RESERVED1_SHIFT)
#define  MC_CH0_PHY_DATA_BYTE_CONTROL_B3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_DATA_BYTE_CONTROL_B3_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_PHY_DATA_BYTE_CONTROL_B3_RESERVED1_SHIFT))

#define  MC_CH0_PHY_DATA_BYTE_CONTROL_B3_PHY_DQ_PWRDWN_MASK 0x400
#define  MC_CH0_PHY_DATA_BYTE_CONTROL_B3_PHY_DQ_PWRDWN_SHIFT 10
#define  MC_CH0_PHY_DATA_BYTE_CONTROL_B3_PHY_DQ_PWRDWN_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_DATA_BYTE_CONTROL_B3_PHY_DQ_PWRDWN_MASK) >> MC_CH0_PHY_DATA_BYTE_CONTROL_B3_PHY_DQ_PWRDWN_SHIFT)
#define  MC_CH0_PHY_DATA_BYTE_CONTROL_B3_PHY_DQ_PWRDWN_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_DATA_BYTE_CONTROL_B3_PHY_DQ_PWRDWN_MASK) | (((uint32_t)val) << MC_CH0_PHY_DATA_BYTE_CONTROL_B3_PHY_DQ_PWRDWN_SHIFT))

#define  MC_CH0_PHY_DATA_BYTE_CONTROL_B3_PHY_DM_PWRDWN_MASK 0x200
#define  MC_CH0_PHY_DATA_BYTE_CONTROL_B3_PHY_DM_PWRDWN_SHIFT 9
#define  MC_CH0_PHY_DATA_BYTE_CONTROL_B3_PHY_DM_PWRDWN_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_DATA_BYTE_CONTROL_B3_PHY_DM_PWRDWN_MASK) >> MC_CH0_PHY_DATA_BYTE_CONTROL_B3_PHY_DM_PWRDWN_SHIFT)
#define  MC_CH0_PHY_DATA_BYTE_CONTROL_B3_PHY_DM_PWRDWN_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_DATA_BYTE_CONTROL_B3_PHY_DM_PWRDWN_MASK) | (((uint32_t)val) << MC_CH0_PHY_DATA_BYTE_CONTROL_B3_PHY_DM_PWRDWN_SHIFT))

#define  MC_CH0_PHY_DATA_BYTE_CONTROL_B3_PHY_DQS_PWRDWN_MASK 0x100
#define  MC_CH0_PHY_DATA_BYTE_CONTROL_B3_PHY_DQS_PWRDWN_SHIFT 8
#define  MC_CH0_PHY_DATA_BYTE_CONTROL_B3_PHY_DQS_PWRDWN_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_DATA_BYTE_CONTROL_B3_PHY_DQS_PWRDWN_MASK) >> MC_CH0_PHY_DATA_BYTE_CONTROL_B3_PHY_DQS_PWRDWN_SHIFT)
#define  MC_CH0_PHY_DATA_BYTE_CONTROL_B3_PHY_DQS_PWRDWN_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_DATA_BYTE_CONTROL_B3_PHY_DQS_PWRDWN_MASK) | (((uint32_t)val) << MC_CH0_PHY_DATA_BYTE_CONTROL_B3_PHY_DQS_PWRDWN_SHIFT))

#define  MC_CH0_PHY_DATA_BYTE_CONTROL_B3_PHY_DQ_RESERVE_MASK 0xff
#define  MC_CH0_PHY_DATA_BYTE_CONTROL_B3_PHY_DQ_RESERVE_SHIFT 0
#define  MC_CH0_PHY_DATA_BYTE_CONTROL_B3_PHY_DQ_RESERVE_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_DATA_BYTE_CONTROL_B3_PHY_DQ_RESERVE_MASK) >> MC_CH0_PHY_DATA_BYTE_CONTROL_B3_PHY_DQ_RESERVE_SHIFT)
#define  MC_CH0_PHY_DATA_BYTE_CONTROL_B3_PHY_DQ_RESERVE_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_DATA_BYTE_CONTROL_B3_PHY_DQ_RESERVE_MASK) | (((uint32_t)val) << MC_CH0_PHY_DATA_BYTE_CONTROL_B3_PHY_DQ_RESERVE_SHIFT))

//====================================================================
//Register: PHY WL RL Control Register (CH0_PHY_WL_RL_Control)
//====================================================================

#define  MC_CH0_PHY_WL_RL_CONTROL_RESERVED1_MASK 0xfffff000
#define  MC_CH0_PHY_WL_RL_CONTROL_RESERVED1_SHIFT 12
#define  MC_CH0_PHY_WL_RL_CONTROL_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_WL_RL_CONTROL_RESERVED1_MASK) >> MC_CH0_PHY_WL_RL_CONTROL_RESERVED1_SHIFT)
#define  MC_CH0_PHY_WL_RL_CONTROL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_WL_RL_CONTROL_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_PHY_WL_RL_CONTROL_RESERVED1_SHIFT))

#define  MC_CH0_PHY_WL_RL_CONTROL_PHY_WL_CS_SEL_MASK 0xf00
#define  MC_CH0_PHY_WL_RL_CONTROL_PHY_WL_CS_SEL_SHIFT 8
#define  MC_CH0_PHY_WL_RL_CONTROL_PHY_WL_CS_SEL_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_WL_RL_CONTROL_PHY_WL_CS_SEL_MASK) >> MC_CH0_PHY_WL_RL_CONTROL_PHY_WL_CS_SEL_SHIFT)
#define  MC_CH0_PHY_WL_RL_CONTROL_PHY_WL_CS_SEL_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_WL_RL_CONTROL_PHY_WL_CS_SEL_MASK) | (((uint32_t)val) << MC_CH0_PHY_WL_RL_CONTROL_PHY_WL_CS_SEL_SHIFT))

#define  MC_CH0_PHY_WL_RL_CONTROL_RESERVED2_MASK 0xe0
#define  MC_CH0_PHY_WL_RL_CONTROL_RESERVED2_SHIFT 5
#define  MC_CH0_PHY_WL_RL_CONTROL_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_WL_RL_CONTROL_RESERVED2_MASK) >> MC_CH0_PHY_WL_RL_CONTROL_RESERVED2_SHIFT)
#define  MC_CH0_PHY_WL_RL_CONTROL_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_WL_RL_CONTROL_RESERVED2_MASK) | (((uint32_t)val) << MC_CH0_PHY_WL_RL_CONTROL_RESERVED2_SHIFT))

#define  MC_CH0_PHY_WL_RL_CONTROL_PHY_WL_DQS_RECEN_DIS_MASK 0x10
#define  MC_CH0_PHY_WL_RL_CONTROL_PHY_WL_DQS_RECEN_DIS_SHIFT 4
#define  MC_CH0_PHY_WL_RL_CONTROL_PHY_WL_DQS_RECEN_DIS_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_WL_RL_CONTROL_PHY_WL_DQS_RECEN_DIS_MASK) >> MC_CH0_PHY_WL_RL_CONTROL_PHY_WL_DQS_RECEN_DIS_SHIFT)
#define  MC_CH0_PHY_WL_RL_CONTROL_PHY_WL_DQS_RECEN_DIS_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_WL_RL_CONTROL_PHY_WL_DQS_RECEN_DIS_MASK) | (((uint32_t)val) << MC_CH0_PHY_WL_RL_CONTROL_PHY_WL_DQS_RECEN_DIS_SHIFT))

#define  MC_CH0_PHY_WL_RL_CONTROL_RESERVED3_MASK 0xc
#define  MC_CH0_PHY_WL_RL_CONTROL_RESERVED3_SHIFT 2
#define  MC_CH0_PHY_WL_RL_CONTROL_RESERVED3_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_WL_RL_CONTROL_RESERVED3_MASK) >> MC_CH0_PHY_WL_RL_CONTROL_RESERVED3_SHIFT)
#define  MC_CH0_PHY_WL_RL_CONTROL_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_WL_RL_CONTROL_RESERVED3_MASK) | (((uint32_t)val) << MC_CH0_PHY_WL_RL_CONTROL_RESERVED3_SHIFT))

#define  MC_CH0_PHY_WL_RL_CONTROL_PHY_RL_ENABLE_MASK 0x3
#define  MC_CH0_PHY_WL_RL_CONTROL_PHY_RL_ENABLE_SHIFT 0
#define  MC_CH0_PHY_WL_RL_CONTROL_PHY_RL_ENABLE_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_WL_RL_CONTROL_PHY_RL_ENABLE_MASK) >> MC_CH0_PHY_WL_RL_CONTROL_PHY_RL_ENABLE_SHIFT)
#define  MC_CH0_PHY_WL_RL_CONTROL_PHY_RL_ENABLE_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_WL_RL_CONTROL_PHY_RL_ENABLE_MASK) | (((uint32_t)val) << MC_CH0_PHY_WL_RL_CONTROL_PHY_RL_ENABLE_SHIFT))

//====================================================================
//Register: PHY WL Data Control Register (CH0_PHY_WL_DATA_Control_CS0_B0)
//====================================================================

#define  MC_CH0_PHY_WL_DATA_CONTROL_CS0_B0_RESERVED1_MASK 0xffff8000
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS0_B0_RESERVED1_SHIFT 15
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS0_B0_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_WL_DATA_CONTROL_CS0_B0_RESERVED1_MASK) >> MC_CH0_PHY_WL_DATA_CONTROL_CS0_B0_RESERVED1_SHIFT)
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS0_B0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_WL_DATA_CONTROL_CS0_B0_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_PHY_WL_DATA_CONTROL_CS0_B0_RESERVED1_SHIFT))

#define  MC_CH0_PHY_WL_DATA_CONTROL_CS0_B0_PHY_WL_WCK_QS_DLY_MASK 0x7f00
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS0_B0_PHY_WL_WCK_QS_DLY_SHIFT 8
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS0_B0_PHY_WL_WCK_QS_DLY_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_WL_DATA_CONTROL_CS0_B0_PHY_WL_WCK_QS_DLY_MASK) >> MC_CH0_PHY_WL_DATA_CONTROL_CS0_B0_PHY_WL_WCK_QS_DLY_SHIFT)
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS0_B0_PHY_WL_WCK_QS_DLY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_WL_DATA_CONTROL_CS0_B0_PHY_WL_WCK_QS_DLY_MASK) | (((uint32_t)val) << MC_CH0_PHY_WL_DATA_CONTROL_CS0_B0_PHY_WL_WCK_QS_DLY_SHIFT))

#define  MC_CH0_PHY_WL_DATA_CONTROL_CS0_B0_RESERVED2_MASK 0x80
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS0_B0_RESERVED2_SHIFT 7
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS0_B0_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_WL_DATA_CONTROL_CS0_B0_RESERVED2_MASK) >> MC_CH0_PHY_WL_DATA_CONTROL_CS0_B0_RESERVED2_SHIFT)
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS0_B0_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_WL_DATA_CONTROL_CS0_B0_RESERVED2_MASK) | (((uint32_t)val) << MC_CH0_PHY_WL_DATA_CONTROL_CS0_B0_RESERVED2_SHIFT))

#define  MC_CH0_PHY_WL_DATA_CONTROL_CS0_B0_PHY_WL_WCK_DQ_DLY_MASK 0x7f
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS0_B0_PHY_WL_WCK_DQ_DLY_SHIFT 0
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS0_B0_PHY_WL_WCK_DQ_DLY_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_WL_DATA_CONTROL_CS0_B0_PHY_WL_WCK_DQ_DLY_MASK) >> MC_CH0_PHY_WL_DATA_CONTROL_CS0_B0_PHY_WL_WCK_DQ_DLY_SHIFT)
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS0_B0_PHY_WL_WCK_DQ_DLY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_WL_DATA_CONTROL_CS0_B0_PHY_WL_WCK_DQ_DLY_MASK) | (((uint32_t)val) << MC_CH0_PHY_WL_DATA_CONTROL_CS0_B0_PHY_WL_WCK_DQ_DLY_SHIFT))

//====================================================================
//Register: PHY WL Data Control Register (CH0_PHY_WL_DATA_Control_CS0_B1)
//====================================================================

#define  MC_CH0_PHY_WL_DATA_CONTROL_CS0_B1_RESERVED1_MASK 0xffff8000
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS0_B1_RESERVED1_SHIFT 15
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS0_B1_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_WL_DATA_CONTROL_CS0_B1_RESERVED1_MASK) >> MC_CH0_PHY_WL_DATA_CONTROL_CS0_B1_RESERVED1_SHIFT)
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS0_B1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_WL_DATA_CONTROL_CS0_B1_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_PHY_WL_DATA_CONTROL_CS0_B1_RESERVED1_SHIFT))

#define  MC_CH0_PHY_WL_DATA_CONTROL_CS0_B1_PHY_WL_WCK_QS_DLY_MASK 0x7f00
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS0_B1_PHY_WL_WCK_QS_DLY_SHIFT 8
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS0_B1_PHY_WL_WCK_QS_DLY_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_WL_DATA_CONTROL_CS0_B1_PHY_WL_WCK_QS_DLY_MASK) >> MC_CH0_PHY_WL_DATA_CONTROL_CS0_B1_PHY_WL_WCK_QS_DLY_SHIFT)
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS0_B1_PHY_WL_WCK_QS_DLY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_WL_DATA_CONTROL_CS0_B1_PHY_WL_WCK_QS_DLY_MASK) | (((uint32_t)val) << MC_CH0_PHY_WL_DATA_CONTROL_CS0_B1_PHY_WL_WCK_QS_DLY_SHIFT))

#define  MC_CH0_PHY_WL_DATA_CONTROL_CS0_B1_RESERVED2_MASK 0x80
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS0_B1_RESERVED2_SHIFT 7
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS0_B1_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_WL_DATA_CONTROL_CS0_B1_RESERVED2_MASK) >> MC_CH0_PHY_WL_DATA_CONTROL_CS0_B1_RESERVED2_SHIFT)
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS0_B1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_WL_DATA_CONTROL_CS0_B1_RESERVED2_MASK) | (((uint32_t)val) << MC_CH0_PHY_WL_DATA_CONTROL_CS0_B1_RESERVED2_SHIFT))

#define  MC_CH0_PHY_WL_DATA_CONTROL_CS0_B1_PHY_WL_WCK_DQ_DLY_MASK 0x7f
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS0_B1_PHY_WL_WCK_DQ_DLY_SHIFT 0
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS0_B1_PHY_WL_WCK_DQ_DLY_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_WL_DATA_CONTROL_CS0_B1_PHY_WL_WCK_DQ_DLY_MASK) >> MC_CH0_PHY_WL_DATA_CONTROL_CS0_B1_PHY_WL_WCK_DQ_DLY_SHIFT)
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS0_B1_PHY_WL_WCK_DQ_DLY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_WL_DATA_CONTROL_CS0_B1_PHY_WL_WCK_DQ_DLY_MASK) | (((uint32_t)val) << MC_CH0_PHY_WL_DATA_CONTROL_CS0_B1_PHY_WL_WCK_DQ_DLY_SHIFT))

//====================================================================
//Register: PHY WL Data Control Register (CH0_PHY_WL_DATA_Control_CS0_B2)
//====================================================================

#define  MC_CH0_PHY_WL_DATA_CONTROL_CS0_B2_RESERVED1_MASK 0xffff8000
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS0_B2_RESERVED1_SHIFT 15
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS0_B2_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_WL_DATA_CONTROL_CS0_B2_RESERVED1_MASK) >> MC_CH0_PHY_WL_DATA_CONTROL_CS0_B2_RESERVED1_SHIFT)
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS0_B2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_WL_DATA_CONTROL_CS0_B2_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_PHY_WL_DATA_CONTROL_CS0_B2_RESERVED1_SHIFT))

#define  MC_CH0_PHY_WL_DATA_CONTROL_CS0_B2_PHY_WL_WCK_QS_DLY_MASK 0x7f00
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS0_B2_PHY_WL_WCK_QS_DLY_SHIFT 8
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS0_B2_PHY_WL_WCK_QS_DLY_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_WL_DATA_CONTROL_CS0_B2_PHY_WL_WCK_QS_DLY_MASK) >> MC_CH0_PHY_WL_DATA_CONTROL_CS0_B2_PHY_WL_WCK_QS_DLY_SHIFT)
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS0_B2_PHY_WL_WCK_QS_DLY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_WL_DATA_CONTROL_CS0_B2_PHY_WL_WCK_QS_DLY_MASK) | (((uint32_t)val) << MC_CH0_PHY_WL_DATA_CONTROL_CS0_B2_PHY_WL_WCK_QS_DLY_SHIFT))

#define  MC_CH0_PHY_WL_DATA_CONTROL_CS0_B2_RESERVED2_MASK 0x80
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS0_B2_RESERVED2_SHIFT 7
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS0_B2_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_WL_DATA_CONTROL_CS0_B2_RESERVED2_MASK) >> MC_CH0_PHY_WL_DATA_CONTROL_CS0_B2_RESERVED2_SHIFT)
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS0_B2_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_WL_DATA_CONTROL_CS0_B2_RESERVED2_MASK) | (((uint32_t)val) << MC_CH0_PHY_WL_DATA_CONTROL_CS0_B2_RESERVED2_SHIFT))

#define  MC_CH0_PHY_WL_DATA_CONTROL_CS0_B2_PHY_WL_WCK_DQ_DLY_MASK 0x7f
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS0_B2_PHY_WL_WCK_DQ_DLY_SHIFT 0
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS0_B2_PHY_WL_WCK_DQ_DLY_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_WL_DATA_CONTROL_CS0_B2_PHY_WL_WCK_DQ_DLY_MASK) >> MC_CH0_PHY_WL_DATA_CONTROL_CS0_B2_PHY_WL_WCK_DQ_DLY_SHIFT)
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS0_B2_PHY_WL_WCK_DQ_DLY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_WL_DATA_CONTROL_CS0_B2_PHY_WL_WCK_DQ_DLY_MASK) | (((uint32_t)val) << MC_CH0_PHY_WL_DATA_CONTROL_CS0_B2_PHY_WL_WCK_DQ_DLY_SHIFT))

//====================================================================
//Register: PHY WL Data Control Register (CH0_PHY_WL_DATA_Control_CS0_B3)
//====================================================================

#define  MC_CH0_PHY_WL_DATA_CONTROL_CS0_B3_RESERVED1_MASK 0xffff8000
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS0_B3_RESERVED1_SHIFT 15
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS0_B3_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_WL_DATA_CONTROL_CS0_B3_RESERVED1_MASK) >> MC_CH0_PHY_WL_DATA_CONTROL_CS0_B3_RESERVED1_SHIFT)
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS0_B3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_WL_DATA_CONTROL_CS0_B3_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_PHY_WL_DATA_CONTROL_CS0_B3_RESERVED1_SHIFT))

#define  MC_CH0_PHY_WL_DATA_CONTROL_CS0_B3_PHY_WL_WCK_QS_DLY_MASK 0x7f00
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS0_B3_PHY_WL_WCK_QS_DLY_SHIFT 8
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS0_B3_PHY_WL_WCK_QS_DLY_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_WL_DATA_CONTROL_CS0_B3_PHY_WL_WCK_QS_DLY_MASK) >> MC_CH0_PHY_WL_DATA_CONTROL_CS0_B3_PHY_WL_WCK_QS_DLY_SHIFT)
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS0_B3_PHY_WL_WCK_QS_DLY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_WL_DATA_CONTROL_CS0_B3_PHY_WL_WCK_QS_DLY_MASK) | (((uint32_t)val) << MC_CH0_PHY_WL_DATA_CONTROL_CS0_B3_PHY_WL_WCK_QS_DLY_SHIFT))

#define  MC_CH0_PHY_WL_DATA_CONTROL_CS0_B3_RESERVED2_MASK 0x80
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS0_B3_RESERVED2_SHIFT 7
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS0_B3_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_WL_DATA_CONTROL_CS0_B3_RESERVED2_MASK) >> MC_CH0_PHY_WL_DATA_CONTROL_CS0_B3_RESERVED2_SHIFT)
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS0_B3_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_WL_DATA_CONTROL_CS0_B3_RESERVED2_MASK) | (((uint32_t)val) << MC_CH0_PHY_WL_DATA_CONTROL_CS0_B3_RESERVED2_SHIFT))

#define  MC_CH0_PHY_WL_DATA_CONTROL_CS0_B3_PHY_WL_WCK_DQ_DLY_MASK 0x7f
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS0_B3_PHY_WL_WCK_DQ_DLY_SHIFT 0
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS0_B3_PHY_WL_WCK_DQ_DLY_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_WL_DATA_CONTROL_CS0_B3_PHY_WL_WCK_DQ_DLY_MASK) >> MC_CH0_PHY_WL_DATA_CONTROL_CS0_B3_PHY_WL_WCK_DQ_DLY_SHIFT)
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS0_B3_PHY_WL_WCK_DQ_DLY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_WL_DATA_CONTROL_CS0_B3_PHY_WL_WCK_DQ_DLY_MASK) | (((uint32_t)val) << MC_CH0_PHY_WL_DATA_CONTROL_CS0_B3_PHY_WL_WCK_DQ_DLY_SHIFT))

//====================================================================
//Register: PHY WL Data Control Register (CH0_PHY_WL_DATA_Control_CS1_B0)
//====================================================================

#define  MC_CH0_PHY_WL_DATA_CONTROL_CS1_B0_RESERVED1_MASK 0xffff8000
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS1_B0_RESERVED1_SHIFT 15
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS1_B0_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_WL_DATA_CONTROL_CS1_B0_RESERVED1_MASK) >> MC_CH0_PHY_WL_DATA_CONTROL_CS1_B0_RESERVED1_SHIFT)
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS1_B0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_WL_DATA_CONTROL_CS1_B0_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_PHY_WL_DATA_CONTROL_CS1_B0_RESERVED1_SHIFT))

#define  MC_CH0_PHY_WL_DATA_CONTROL_CS1_B0_PHY_WL_WCK_QS_DLY_MASK 0x7f00
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS1_B0_PHY_WL_WCK_QS_DLY_SHIFT 8
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS1_B0_PHY_WL_WCK_QS_DLY_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_WL_DATA_CONTROL_CS1_B0_PHY_WL_WCK_QS_DLY_MASK) >> MC_CH0_PHY_WL_DATA_CONTROL_CS1_B0_PHY_WL_WCK_QS_DLY_SHIFT)
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS1_B0_PHY_WL_WCK_QS_DLY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_WL_DATA_CONTROL_CS1_B0_PHY_WL_WCK_QS_DLY_MASK) | (((uint32_t)val) << MC_CH0_PHY_WL_DATA_CONTROL_CS1_B0_PHY_WL_WCK_QS_DLY_SHIFT))

#define  MC_CH0_PHY_WL_DATA_CONTROL_CS1_B0_RESERVED2_MASK 0x80
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS1_B0_RESERVED2_SHIFT 7
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS1_B0_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_WL_DATA_CONTROL_CS1_B0_RESERVED2_MASK) >> MC_CH0_PHY_WL_DATA_CONTROL_CS1_B0_RESERVED2_SHIFT)
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS1_B0_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_WL_DATA_CONTROL_CS1_B0_RESERVED2_MASK) | (((uint32_t)val) << MC_CH0_PHY_WL_DATA_CONTROL_CS1_B0_RESERVED2_SHIFT))

#define  MC_CH0_PHY_WL_DATA_CONTROL_CS1_B0_PHY_WL_WCK_DQ_DLY_MASK 0x7f
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS1_B0_PHY_WL_WCK_DQ_DLY_SHIFT 0
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS1_B0_PHY_WL_WCK_DQ_DLY_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_WL_DATA_CONTROL_CS1_B0_PHY_WL_WCK_DQ_DLY_MASK) >> MC_CH0_PHY_WL_DATA_CONTROL_CS1_B0_PHY_WL_WCK_DQ_DLY_SHIFT)
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS1_B0_PHY_WL_WCK_DQ_DLY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_WL_DATA_CONTROL_CS1_B0_PHY_WL_WCK_DQ_DLY_MASK) | (((uint32_t)val) << MC_CH0_PHY_WL_DATA_CONTROL_CS1_B0_PHY_WL_WCK_DQ_DLY_SHIFT))

//====================================================================
//Register: PHY WL Data Control Register (CH0_PHY_WL_DATA_Control_CS1_B1)
//====================================================================

#define  MC_CH0_PHY_WL_DATA_CONTROL_CS1_B1_RESERVED1_MASK 0xffff8000
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS1_B1_RESERVED1_SHIFT 15
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS1_B1_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_WL_DATA_CONTROL_CS1_B1_RESERVED1_MASK) >> MC_CH0_PHY_WL_DATA_CONTROL_CS1_B1_RESERVED1_SHIFT)
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS1_B1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_WL_DATA_CONTROL_CS1_B1_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_PHY_WL_DATA_CONTROL_CS1_B1_RESERVED1_SHIFT))

#define  MC_CH0_PHY_WL_DATA_CONTROL_CS1_B1_PHY_WL_WCK_QS_DLY_MASK 0x7f00
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS1_B1_PHY_WL_WCK_QS_DLY_SHIFT 8
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS1_B1_PHY_WL_WCK_QS_DLY_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_WL_DATA_CONTROL_CS1_B1_PHY_WL_WCK_QS_DLY_MASK) >> MC_CH0_PHY_WL_DATA_CONTROL_CS1_B1_PHY_WL_WCK_QS_DLY_SHIFT)
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS1_B1_PHY_WL_WCK_QS_DLY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_WL_DATA_CONTROL_CS1_B1_PHY_WL_WCK_QS_DLY_MASK) | (((uint32_t)val) << MC_CH0_PHY_WL_DATA_CONTROL_CS1_B1_PHY_WL_WCK_QS_DLY_SHIFT))

#define  MC_CH0_PHY_WL_DATA_CONTROL_CS1_B1_RESERVED2_MASK 0x80
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS1_B1_RESERVED2_SHIFT 7
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS1_B1_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_WL_DATA_CONTROL_CS1_B1_RESERVED2_MASK) >> MC_CH0_PHY_WL_DATA_CONTROL_CS1_B1_RESERVED2_SHIFT)
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS1_B1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_WL_DATA_CONTROL_CS1_B1_RESERVED2_MASK) | (((uint32_t)val) << MC_CH0_PHY_WL_DATA_CONTROL_CS1_B1_RESERVED2_SHIFT))

#define  MC_CH0_PHY_WL_DATA_CONTROL_CS1_B1_PHY_WL_WCK_DQ_DLY_MASK 0x7f
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS1_B1_PHY_WL_WCK_DQ_DLY_SHIFT 0
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS1_B1_PHY_WL_WCK_DQ_DLY_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_WL_DATA_CONTROL_CS1_B1_PHY_WL_WCK_DQ_DLY_MASK) >> MC_CH0_PHY_WL_DATA_CONTROL_CS1_B1_PHY_WL_WCK_DQ_DLY_SHIFT)
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS1_B1_PHY_WL_WCK_DQ_DLY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_WL_DATA_CONTROL_CS1_B1_PHY_WL_WCK_DQ_DLY_MASK) | (((uint32_t)val) << MC_CH0_PHY_WL_DATA_CONTROL_CS1_B1_PHY_WL_WCK_DQ_DLY_SHIFT))

//====================================================================
//Register: PHY WL Data Control Register (CH0_PHY_WL_DATA_Control_CS1_B2)
//====================================================================

#define  MC_CH0_PHY_WL_DATA_CONTROL_CS1_B2_RESERVED1_MASK 0xffff8000
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS1_B2_RESERVED1_SHIFT 15
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS1_B2_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_WL_DATA_CONTROL_CS1_B2_RESERVED1_MASK) >> MC_CH0_PHY_WL_DATA_CONTROL_CS1_B2_RESERVED1_SHIFT)
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS1_B2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_WL_DATA_CONTROL_CS1_B2_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_PHY_WL_DATA_CONTROL_CS1_B2_RESERVED1_SHIFT))

#define  MC_CH0_PHY_WL_DATA_CONTROL_CS1_B2_PHY_WL_WCK_QS_DLY_MASK 0x7f00
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS1_B2_PHY_WL_WCK_QS_DLY_SHIFT 8
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS1_B2_PHY_WL_WCK_QS_DLY_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_WL_DATA_CONTROL_CS1_B2_PHY_WL_WCK_QS_DLY_MASK) >> MC_CH0_PHY_WL_DATA_CONTROL_CS1_B2_PHY_WL_WCK_QS_DLY_SHIFT)
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS1_B2_PHY_WL_WCK_QS_DLY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_WL_DATA_CONTROL_CS1_B2_PHY_WL_WCK_QS_DLY_MASK) | (((uint32_t)val) << MC_CH0_PHY_WL_DATA_CONTROL_CS1_B2_PHY_WL_WCK_QS_DLY_SHIFT))

#define  MC_CH0_PHY_WL_DATA_CONTROL_CS1_B2_RESERVED2_MASK 0x80
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS1_B2_RESERVED2_SHIFT 7
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS1_B2_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_WL_DATA_CONTROL_CS1_B2_RESERVED2_MASK) >> MC_CH0_PHY_WL_DATA_CONTROL_CS1_B2_RESERVED2_SHIFT)
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS1_B2_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_WL_DATA_CONTROL_CS1_B2_RESERVED2_MASK) | (((uint32_t)val) << MC_CH0_PHY_WL_DATA_CONTROL_CS1_B2_RESERVED2_SHIFT))

#define  MC_CH0_PHY_WL_DATA_CONTROL_CS1_B2_PHY_WL_WCK_DQ_DLY_MASK 0x7f
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS1_B2_PHY_WL_WCK_DQ_DLY_SHIFT 0
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS1_B2_PHY_WL_WCK_DQ_DLY_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_WL_DATA_CONTROL_CS1_B2_PHY_WL_WCK_DQ_DLY_MASK) >> MC_CH0_PHY_WL_DATA_CONTROL_CS1_B2_PHY_WL_WCK_DQ_DLY_SHIFT)
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS1_B2_PHY_WL_WCK_DQ_DLY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_WL_DATA_CONTROL_CS1_B2_PHY_WL_WCK_DQ_DLY_MASK) | (((uint32_t)val) << MC_CH0_PHY_WL_DATA_CONTROL_CS1_B2_PHY_WL_WCK_DQ_DLY_SHIFT))

//====================================================================
//Register: PHY WL Data Control Register (CH0_PHY_WL_DATA_Control_CS1_B3)
//====================================================================

#define  MC_CH0_PHY_WL_DATA_CONTROL_CS1_B3_RESERVED1_MASK 0xffff8000
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS1_B3_RESERVED1_SHIFT 15
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS1_B3_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_WL_DATA_CONTROL_CS1_B3_RESERVED1_MASK) >> MC_CH0_PHY_WL_DATA_CONTROL_CS1_B3_RESERVED1_SHIFT)
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS1_B3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_WL_DATA_CONTROL_CS1_B3_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_PHY_WL_DATA_CONTROL_CS1_B3_RESERVED1_SHIFT))

#define  MC_CH0_PHY_WL_DATA_CONTROL_CS1_B3_PHY_WL_WCK_QS_DLY_MASK 0x7f00
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS1_B3_PHY_WL_WCK_QS_DLY_SHIFT 8
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS1_B3_PHY_WL_WCK_QS_DLY_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_WL_DATA_CONTROL_CS1_B3_PHY_WL_WCK_QS_DLY_MASK) >> MC_CH0_PHY_WL_DATA_CONTROL_CS1_B3_PHY_WL_WCK_QS_DLY_SHIFT)
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS1_B3_PHY_WL_WCK_QS_DLY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_WL_DATA_CONTROL_CS1_B3_PHY_WL_WCK_QS_DLY_MASK) | (((uint32_t)val) << MC_CH0_PHY_WL_DATA_CONTROL_CS1_B3_PHY_WL_WCK_QS_DLY_SHIFT))

#define  MC_CH0_PHY_WL_DATA_CONTROL_CS1_B3_RESERVED2_MASK 0x80
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS1_B3_RESERVED2_SHIFT 7
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS1_B3_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_WL_DATA_CONTROL_CS1_B3_RESERVED2_MASK) >> MC_CH0_PHY_WL_DATA_CONTROL_CS1_B3_RESERVED2_SHIFT)
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS1_B3_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_WL_DATA_CONTROL_CS1_B3_RESERVED2_MASK) | (((uint32_t)val) << MC_CH0_PHY_WL_DATA_CONTROL_CS1_B3_RESERVED2_SHIFT))

#define  MC_CH0_PHY_WL_DATA_CONTROL_CS1_B3_PHY_WL_WCK_DQ_DLY_MASK 0x7f
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS1_B3_PHY_WL_WCK_DQ_DLY_SHIFT 0
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS1_B3_PHY_WL_WCK_DQ_DLY_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_WL_DATA_CONTROL_CS1_B3_PHY_WL_WCK_DQ_DLY_MASK) >> MC_CH0_PHY_WL_DATA_CONTROL_CS1_B3_PHY_WL_WCK_DQ_DLY_SHIFT)
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS1_B3_PHY_WL_WCK_DQ_DLY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_WL_DATA_CONTROL_CS1_B3_PHY_WL_WCK_DQ_DLY_MASK) | (((uint32_t)val) << MC_CH0_PHY_WL_DATA_CONTROL_CS1_B3_PHY_WL_WCK_DQ_DLY_SHIFT))

//====================================================================
//Register: PHY WL Data Control Register (CH0_PHY_WL_DATA_Control_CS2_B0)
//====================================================================

#define  MC_CH0_PHY_WL_DATA_CONTROL_CS2_B0_RESERVED1_MASK 0xffff8000
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS2_B0_RESERVED1_SHIFT 15
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS2_B0_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_WL_DATA_CONTROL_CS2_B0_RESERVED1_MASK) >> MC_CH0_PHY_WL_DATA_CONTROL_CS2_B0_RESERVED1_SHIFT)
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS2_B0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_WL_DATA_CONTROL_CS2_B0_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_PHY_WL_DATA_CONTROL_CS2_B0_RESERVED1_SHIFT))

#define  MC_CH0_PHY_WL_DATA_CONTROL_CS2_B0_PHY_WL_WCK_QS_DLY_MASK 0x7f00
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS2_B0_PHY_WL_WCK_QS_DLY_SHIFT 8
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS2_B0_PHY_WL_WCK_QS_DLY_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_WL_DATA_CONTROL_CS2_B0_PHY_WL_WCK_QS_DLY_MASK) >> MC_CH0_PHY_WL_DATA_CONTROL_CS2_B0_PHY_WL_WCK_QS_DLY_SHIFT)
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS2_B0_PHY_WL_WCK_QS_DLY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_WL_DATA_CONTROL_CS2_B0_PHY_WL_WCK_QS_DLY_MASK) | (((uint32_t)val) << MC_CH0_PHY_WL_DATA_CONTROL_CS2_B0_PHY_WL_WCK_QS_DLY_SHIFT))

#define  MC_CH0_PHY_WL_DATA_CONTROL_CS2_B0_RESERVED2_MASK 0x80
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS2_B0_RESERVED2_SHIFT 7
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS2_B0_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_WL_DATA_CONTROL_CS2_B0_RESERVED2_MASK) >> MC_CH0_PHY_WL_DATA_CONTROL_CS2_B0_RESERVED2_SHIFT)
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS2_B0_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_WL_DATA_CONTROL_CS2_B0_RESERVED2_MASK) | (((uint32_t)val) << MC_CH0_PHY_WL_DATA_CONTROL_CS2_B0_RESERVED2_SHIFT))

#define  MC_CH0_PHY_WL_DATA_CONTROL_CS2_B0_PHY_WL_WCK_DQ_DLY_MASK 0x7f
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS2_B0_PHY_WL_WCK_DQ_DLY_SHIFT 0
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS2_B0_PHY_WL_WCK_DQ_DLY_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_WL_DATA_CONTROL_CS2_B0_PHY_WL_WCK_DQ_DLY_MASK) >> MC_CH0_PHY_WL_DATA_CONTROL_CS2_B0_PHY_WL_WCK_DQ_DLY_SHIFT)
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS2_B0_PHY_WL_WCK_DQ_DLY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_WL_DATA_CONTROL_CS2_B0_PHY_WL_WCK_DQ_DLY_MASK) | (((uint32_t)val) << MC_CH0_PHY_WL_DATA_CONTROL_CS2_B0_PHY_WL_WCK_DQ_DLY_SHIFT))

//====================================================================
//Register: PHY WL Data Control Register (CH0_PHY_WL_DATA_Control_CS2_B1)
//====================================================================

#define  MC_CH0_PHY_WL_DATA_CONTROL_CS2_B1_RESERVED1_MASK 0xffff8000
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS2_B1_RESERVED1_SHIFT 15
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS2_B1_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_WL_DATA_CONTROL_CS2_B1_RESERVED1_MASK) >> MC_CH0_PHY_WL_DATA_CONTROL_CS2_B1_RESERVED1_SHIFT)
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS2_B1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_WL_DATA_CONTROL_CS2_B1_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_PHY_WL_DATA_CONTROL_CS2_B1_RESERVED1_SHIFT))

#define  MC_CH0_PHY_WL_DATA_CONTROL_CS2_B1_PHY_WL_WCK_QS_DLY_MASK 0x7f00
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS2_B1_PHY_WL_WCK_QS_DLY_SHIFT 8
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS2_B1_PHY_WL_WCK_QS_DLY_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_WL_DATA_CONTROL_CS2_B1_PHY_WL_WCK_QS_DLY_MASK) >> MC_CH0_PHY_WL_DATA_CONTROL_CS2_B1_PHY_WL_WCK_QS_DLY_SHIFT)
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS2_B1_PHY_WL_WCK_QS_DLY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_WL_DATA_CONTROL_CS2_B1_PHY_WL_WCK_QS_DLY_MASK) | (((uint32_t)val) << MC_CH0_PHY_WL_DATA_CONTROL_CS2_B1_PHY_WL_WCK_QS_DLY_SHIFT))

#define  MC_CH0_PHY_WL_DATA_CONTROL_CS2_B1_RESERVED2_MASK 0x80
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS2_B1_RESERVED2_SHIFT 7
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS2_B1_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_WL_DATA_CONTROL_CS2_B1_RESERVED2_MASK) >> MC_CH0_PHY_WL_DATA_CONTROL_CS2_B1_RESERVED2_SHIFT)
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS2_B1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_WL_DATA_CONTROL_CS2_B1_RESERVED2_MASK) | (((uint32_t)val) << MC_CH0_PHY_WL_DATA_CONTROL_CS2_B1_RESERVED2_SHIFT))

#define  MC_CH0_PHY_WL_DATA_CONTROL_CS2_B1_PHY_WL_WCK_DQ_DLY_MASK 0x7f
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS2_B1_PHY_WL_WCK_DQ_DLY_SHIFT 0
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS2_B1_PHY_WL_WCK_DQ_DLY_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_WL_DATA_CONTROL_CS2_B1_PHY_WL_WCK_DQ_DLY_MASK) >> MC_CH0_PHY_WL_DATA_CONTROL_CS2_B1_PHY_WL_WCK_DQ_DLY_SHIFT)
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS2_B1_PHY_WL_WCK_DQ_DLY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_WL_DATA_CONTROL_CS2_B1_PHY_WL_WCK_DQ_DLY_MASK) | (((uint32_t)val) << MC_CH0_PHY_WL_DATA_CONTROL_CS2_B1_PHY_WL_WCK_DQ_DLY_SHIFT))

//====================================================================
//Register: PHY WL Data Control Register (CH0_PHY_WL_DATA_Control_CS2_B2)
//====================================================================

#define  MC_CH0_PHY_WL_DATA_CONTROL_CS2_B2_RESERVED1_MASK 0xffff8000
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS2_B2_RESERVED1_SHIFT 15
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS2_B2_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_WL_DATA_CONTROL_CS2_B2_RESERVED1_MASK) >> MC_CH0_PHY_WL_DATA_CONTROL_CS2_B2_RESERVED1_SHIFT)
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS2_B2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_WL_DATA_CONTROL_CS2_B2_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_PHY_WL_DATA_CONTROL_CS2_B2_RESERVED1_SHIFT))

#define  MC_CH0_PHY_WL_DATA_CONTROL_CS2_B2_PHY_WL_WCK_QS_DLY_MASK 0x7f00
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS2_B2_PHY_WL_WCK_QS_DLY_SHIFT 8
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS2_B2_PHY_WL_WCK_QS_DLY_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_WL_DATA_CONTROL_CS2_B2_PHY_WL_WCK_QS_DLY_MASK) >> MC_CH0_PHY_WL_DATA_CONTROL_CS2_B2_PHY_WL_WCK_QS_DLY_SHIFT)
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS2_B2_PHY_WL_WCK_QS_DLY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_WL_DATA_CONTROL_CS2_B2_PHY_WL_WCK_QS_DLY_MASK) | (((uint32_t)val) << MC_CH0_PHY_WL_DATA_CONTROL_CS2_B2_PHY_WL_WCK_QS_DLY_SHIFT))

#define  MC_CH0_PHY_WL_DATA_CONTROL_CS2_B2_RESERVED2_MASK 0x80
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS2_B2_RESERVED2_SHIFT 7
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS2_B2_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_WL_DATA_CONTROL_CS2_B2_RESERVED2_MASK) >> MC_CH0_PHY_WL_DATA_CONTROL_CS2_B2_RESERVED2_SHIFT)
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS2_B2_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_WL_DATA_CONTROL_CS2_B2_RESERVED2_MASK) | (((uint32_t)val) << MC_CH0_PHY_WL_DATA_CONTROL_CS2_B2_RESERVED2_SHIFT))

#define  MC_CH0_PHY_WL_DATA_CONTROL_CS2_B2_PHY_WL_WCK_DQ_DLY_MASK 0x7f
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS2_B2_PHY_WL_WCK_DQ_DLY_SHIFT 0
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS2_B2_PHY_WL_WCK_DQ_DLY_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_WL_DATA_CONTROL_CS2_B2_PHY_WL_WCK_DQ_DLY_MASK) >> MC_CH0_PHY_WL_DATA_CONTROL_CS2_B2_PHY_WL_WCK_DQ_DLY_SHIFT)
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS2_B2_PHY_WL_WCK_DQ_DLY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_WL_DATA_CONTROL_CS2_B2_PHY_WL_WCK_DQ_DLY_MASK) | (((uint32_t)val) << MC_CH0_PHY_WL_DATA_CONTROL_CS2_B2_PHY_WL_WCK_DQ_DLY_SHIFT))

//====================================================================
//Register: PHY WL Data Control Register (CH0_PHY_WL_DATA_Control_CS2_B3)
//====================================================================

#define  MC_CH0_PHY_WL_DATA_CONTROL_CS2_B3_RESERVED1_MASK 0xffff8000
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS2_B3_RESERVED1_SHIFT 15
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS2_B3_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_WL_DATA_CONTROL_CS2_B3_RESERVED1_MASK) >> MC_CH0_PHY_WL_DATA_CONTROL_CS2_B3_RESERVED1_SHIFT)
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS2_B3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_WL_DATA_CONTROL_CS2_B3_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_PHY_WL_DATA_CONTROL_CS2_B3_RESERVED1_SHIFT))

#define  MC_CH0_PHY_WL_DATA_CONTROL_CS2_B3_PHY_WL_WCK_QS_DLY_MASK 0x7f00
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS2_B3_PHY_WL_WCK_QS_DLY_SHIFT 8
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS2_B3_PHY_WL_WCK_QS_DLY_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_WL_DATA_CONTROL_CS2_B3_PHY_WL_WCK_QS_DLY_MASK) >> MC_CH0_PHY_WL_DATA_CONTROL_CS2_B3_PHY_WL_WCK_QS_DLY_SHIFT)
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS2_B3_PHY_WL_WCK_QS_DLY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_WL_DATA_CONTROL_CS2_B3_PHY_WL_WCK_QS_DLY_MASK) | (((uint32_t)val) << MC_CH0_PHY_WL_DATA_CONTROL_CS2_B3_PHY_WL_WCK_QS_DLY_SHIFT))

#define  MC_CH0_PHY_WL_DATA_CONTROL_CS2_B3_RESERVED2_MASK 0x80
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS2_B3_RESERVED2_SHIFT 7
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS2_B3_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_WL_DATA_CONTROL_CS2_B3_RESERVED2_MASK) >> MC_CH0_PHY_WL_DATA_CONTROL_CS2_B3_RESERVED2_SHIFT)
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS2_B3_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_WL_DATA_CONTROL_CS2_B3_RESERVED2_MASK) | (((uint32_t)val) << MC_CH0_PHY_WL_DATA_CONTROL_CS2_B3_RESERVED2_SHIFT))

#define  MC_CH0_PHY_WL_DATA_CONTROL_CS2_B3_PHY_WL_WCK_DQ_DLY_MASK 0x7f
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS2_B3_PHY_WL_WCK_DQ_DLY_SHIFT 0
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS2_B3_PHY_WL_WCK_DQ_DLY_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_WL_DATA_CONTROL_CS2_B3_PHY_WL_WCK_DQ_DLY_MASK) >> MC_CH0_PHY_WL_DATA_CONTROL_CS2_B3_PHY_WL_WCK_DQ_DLY_SHIFT)
#define  MC_CH0_PHY_WL_DATA_CONTROL_CS2_B3_PHY_WL_WCK_DQ_DLY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_WL_DATA_CONTROL_CS2_B3_PHY_WL_WCK_DQ_DLY_MASK) | (((uint32_t)val) << MC_CH0_PHY_WL_DATA_CONTROL_CS2_B3_PHY_WL_WCK_DQ_DLY_SHIFT))

//====================================================================
//Register: PHY WL CLK Control Register (CH0_PHY_WL_CLK_Control_CS0)
//====================================================================

#define  MC_CH0_PHY_WL_CLK_CONTROL_CS0_RESERVED1_MASK 0xffffffe0
#define  MC_CH0_PHY_WL_CLK_CONTROL_CS0_RESERVED1_SHIFT 5
#define  MC_CH0_PHY_WL_CLK_CONTROL_CS0_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_WL_CLK_CONTROL_CS0_RESERVED1_MASK) >> MC_CH0_PHY_WL_CLK_CONTROL_CS0_RESERVED1_SHIFT)
#define  MC_CH0_PHY_WL_CLK_CONTROL_CS0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_WL_CLK_CONTROL_CS0_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_PHY_WL_CLK_CONTROL_CS0_RESERVED1_SHIFT))

#define  MC_CH0_PHY_WL_CLK_CONTROL_CS0_PHY_WL_WCK_CK_DLY_MASK 0x1f
#define  MC_CH0_PHY_WL_CLK_CONTROL_CS0_PHY_WL_WCK_CK_DLY_SHIFT 0
#define  MC_CH0_PHY_WL_CLK_CONTROL_CS0_PHY_WL_WCK_CK_DLY_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_WL_CLK_CONTROL_CS0_PHY_WL_WCK_CK_DLY_MASK) >> MC_CH0_PHY_WL_CLK_CONTROL_CS0_PHY_WL_WCK_CK_DLY_SHIFT)
#define  MC_CH0_PHY_WL_CLK_CONTROL_CS0_PHY_WL_WCK_CK_DLY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_WL_CLK_CONTROL_CS0_PHY_WL_WCK_CK_DLY_MASK) | (((uint32_t)val) << MC_CH0_PHY_WL_CLK_CONTROL_CS0_PHY_WL_WCK_CK_DLY_SHIFT))

//====================================================================
//Register: PHY WL CLK Control Register (CH0_PHY_WL_CLK_Control_CS1)
//====================================================================

#define  MC_CH0_PHY_WL_CLK_CONTROL_CS1_RESERVED1_MASK 0xffffffe0
#define  MC_CH0_PHY_WL_CLK_CONTROL_CS1_RESERVED1_SHIFT 5
#define  MC_CH0_PHY_WL_CLK_CONTROL_CS1_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_WL_CLK_CONTROL_CS1_RESERVED1_MASK) >> MC_CH0_PHY_WL_CLK_CONTROL_CS1_RESERVED1_SHIFT)
#define  MC_CH0_PHY_WL_CLK_CONTROL_CS1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_WL_CLK_CONTROL_CS1_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_PHY_WL_CLK_CONTROL_CS1_RESERVED1_SHIFT))

#define  MC_CH0_PHY_WL_CLK_CONTROL_CS1_PHY_WL_WCK_CK_DLY_MASK 0x1f
#define  MC_CH0_PHY_WL_CLK_CONTROL_CS1_PHY_WL_WCK_CK_DLY_SHIFT 0
#define  MC_CH0_PHY_WL_CLK_CONTROL_CS1_PHY_WL_WCK_CK_DLY_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_WL_CLK_CONTROL_CS1_PHY_WL_WCK_CK_DLY_MASK) >> MC_CH0_PHY_WL_CLK_CONTROL_CS1_PHY_WL_WCK_CK_DLY_SHIFT)
#define  MC_CH0_PHY_WL_CLK_CONTROL_CS1_PHY_WL_WCK_CK_DLY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_WL_CLK_CONTROL_CS1_PHY_WL_WCK_CK_DLY_MASK) | (((uint32_t)val) << MC_CH0_PHY_WL_CLK_CONTROL_CS1_PHY_WL_WCK_CK_DLY_SHIFT))

//====================================================================
//Register: PHY WL CLK Control Register (CH0_PHY_WL_CLK_Control_CS2)
//====================================================================

#define  MC_CH0_PHY_WL_CLK_CONTROL_CS2_RESERVED1_MASK 0xffffffe0
#define  MC_CH0_PHY_WL_CLK_CONTROL_CS2_RESERVED1_SHIFT 5
#define  MC_CH0_PHY_WL_CLK_CONTROL_CS2_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_WL_CLK_CONTROL_CS2_RESERVED1_MASK) >> MC_CH0_PHY_WL_CLK_CONTROL_CS2_RESERVED1_SHIFT)
#define  MC_CH0_PHY_WL_CLK_CONTROL_CS2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_WL_CLK_CONTROL_CS2_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_PHY_WL_CLK_CONTROL_CS2_RESERVED1_SHIFT))

#define  MC_CH0_PHY_WL_CLK_CONTROL_CS2_PHY_WL_WCK_CK_DLY_MASK 0x1f
#define  MC_CH0_PHY_WL_CLK_CONTROL_CS2_PHY_WL_WCK_CK_DLY_SHIFT 0
#define  MC_CH0_PHY_WL_CLK_CONTROL_CS2_PHY_WL_WCK_CK_DLY_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_WL_CLK_CONTROL_CS2_PHY_WL_WCK_CK_DLY_MASK) >> MC_CH0_PHY_WL_CLK_CONTROL_CS2_PHY_WL_WCK_CK_DLY_SHIFT)
#define  MC_CH0_PHY_WL_CLK_CONTROL_CS2_PHY_WL_WCK_CK_DLY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_WL_CLK_CONTROL_CS2_PHY_WL_WCK_CK_DLY_MASK) | (((uint32_t)val) << MC_CH0_PHY_WL_CLK_CONTROL_CS2_PHY_WL_WCK_CK_DLY_SHIFT))

//====================================================================
//Register: PHY WL AC Control Register (CH0_PHY_WL_AC_Control_0)
//====================================================================

#define  MC_CH0_PHY_WL_AC_CONTROL_0_RESERVED1_MASK 0xffffffe0
#define  MC_CH0_PHY_WL_AC_CONTROL_0_RESERVED1_SHIFT 5
#define  MC_CH0_PHY_WL_AC_CONTROL_0_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_WL_AC_CONTROL_0_RESERVED1_MASK) >> MC_CH0_PHY_WL_AC_CONTROL_0_RESERVED1_SHIFT)
#define  MC_CH0_PHY_WL_AC_CONTROL_0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_WL_AC_CONTROL_0_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_PHY_WL_AC_CONTROL_0_RESERVED1_SHIFT))

#define  MC_CH0_PHY_WL_AC_CONTROL_0_PHY_WL_WCK_AC_DLY_MASK 0x1f
#define  MC_CH0_PHY_WL_AC_CONTROL_0_PHY_WL_WCK_AC_DLY_SHIFT 0
#define  MC_CH0_PHY_WL_AC_CONTROL_0_PHY_WL_WCK_AC_DLY_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_WL_AC_CONTROL_0_PHY_WL_WCK_AC_DLY_MASK) >> MC_CH0_PHY_WL_AC_CONTROL_0_PHY_WL_WCK_AC_DLY_SHIFT)
#define  MC_CH0_PHY_WL_AC_CONTROL_0_PHY_WL_WCK_AC_DLY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_WL_AC_CONTROL_0_PHY_WL_WCK_AC_DLY_MASK) | (((uint32_t)val) << MC_CH0_PHY_WL_AC_CONTROL_0_PHY_WL_WCK_AC_DLY_SHIFT))

//====================================================================
//Register: PHY WL AC Control Register (CH0_PHY_WL_AC_Control_1)
//====================================================================

#define  MC_CH0_PHY_WL_AC_CONTROL_1_RESERVED1_MASK 0xffffffe0
#define  MC_CH0_PHY_WL_AC_CONTROL_1_RESERVED1_SHIFT 5
#define  MC_CH0_PHY_WL_AC_CONTROL_1_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_WL_AC_CONTROL_1_RESERVED1_MASK) >> MC_CH0_PHY_WL_AC_CONTROL_1_RESERVED1_SHIFT)
#define  MC_CH0_PHY_WL_AC_CONTROL_1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_WL_AC_CONTROL_1_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_PHY_WL_AC_CONTROL_1_RESERVED1_SHIFT))

#define  MC_CH0_PHY_WL_AC_CONTROL_1_PHY_WL_WCK_AC_DLY_MASK 0x1f
#define  MC_CH0_PHY_WL_AC_CONTROL_1_PHY_WL_WCK_AC_DLY_SHIFT 0
#define  MC_CH0_PHY_WL_AC_CONTROL_1_PHY_WL_WCK_AC_DLY_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_WL_AC_CONTROL_1_PHY_WL_WCK_AC_DLY_MASK) >> MC_CH0_PHY_WL_AC_CONTROL_1_PHY_WL_WCK_AC_DLY_SHIFT)
#define  MC_CH0_PHY_WL_AC_CONTROL_1_PHY_WL_WCK_AC_DLY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_WL_AC_CONTROL_1_PHY_WL_WCK_AC_DLY_MASK) | (((uint32_t)val) << MC_CH0_PHY_WL_AC_CONTROL_1_PHY_WL_WCK_AC_DLY_SHIFT))

//====================================================================
//Register: PHY WL AC Control Register (CH0_PHY_WL_AC_Control_2)
//====================================================================

#define  MC_CH0_PHY_WL_AC_CONTROL_2_RESERVED1_MASK 0xffffffe0
#define  MC_CH0_PHY_WL_AC_CONTROL_2_RESERVED1_SHIFT 5
#define  MC_CH0_PHY_WL_AC_CONTROL_2_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_WL_AC_CONTROL_2_RESERVED1_MASK) >> MC_CH0_PHY_WL_AC_CONTROL_2_RESERVED1_SHIFT)
#define  MC_CH0_PHY_WL_AC_CONTROL_2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_WL_AC_CONTROL_2_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_PHY_WL_AC_CONTROL_2_RESERVED1_SHIFT))

#define  MC_CH0_PHY_WL_AC_CONTROL_2_PHY_WL_WCK_AC_DLY_MASK 0x1f
#define  MC_CH0_PHY_WL_AC_CONTROL_2_PHY_WL_WCK_AC_DLY_SHIFT 0
#define  MC_CH0_PHY_WL_AC_CONTROL_2_PHY_WL_WCK_AC_DLY_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_WL_AC_CONTROL_2_PHY_WL_WCK_AC_DLY_MASK) >> MC_CH0_PHY_WL_AC_CONTROL_2_PHY_WL_WCK_AC_DLY_SHIFT)
#define  MC_CH0_PHY_WL_AC_CONTROL_2_PHY_WL_WCK_AC_DLY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_WL_AC_CONTROL_2_PHY_WL_WCK_AC_DLY_MASK) | (((uint32_t)val) << MC_CH0_PHY_WL_AC_CONTROL_2_PHY_WL_WCK_AC_DLY_SHIFT))

//====================================================================
//Register: PHY RL Control Register (CH0_PHY_RL_Control_CS0_B0)
//====================================================================

#define  MC_CH0_PHY_RL_CONTROL_CS0_B0_RESERVED1_MASK 0xfffff000
#define  MC_CH0_PHY_RL_CONTROL_CS0_B0_RESERVED1_SHIFT 12
#define  MC_CH0_PHY_RL_CONTROL_CS0_B0_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_RL_CONTROL_CS0_B0_RESERVED1_MASK) >> MC_CH0_PHY_RL_CONTROL_CS0_B0_RESERVED1_SHIFT)
#define  MC_CH0_PHY_RL_CONTROL_CS0_B0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_RL_CONTROL_CS0_B0_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_PHY_RL_CONTROL_CS0_B0_RESERVED1_SHIFT))

#define  MC_CH0_PHY_RL_CONTROL_CS0_B0_PHY_RL_CYCLE_DLY_MASK 0xf00
#define  MC_CH0_PHY_RL_CONTROL_CS0_B0_PHY_RL_CYCLE_DLY_SHIFT 8
#define  MC_CH0_PHY_RL_CONTROL_CS0_B0_PHY_RL_CYCLE_DLY_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_RL_CONTROL_CS0_B0_PHY_RL_CYCLE_DLY_MASK) >> MC_CH0_PHY_RL_CONTROL_CS0_B0_PHY_RL_CYCLE_DLY_SHIFT)
#define  MC_CH0_PHY_RL_CONTROL_CS0_B0_PHY_RL_CYCLE_DLY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_RL_CONTROL_CS0_B0_PHY_RL_CYCLE_DLY_MASK) | (((uint32_t)val) << MC_CH0_PHY_RL_CONTROL_CS0_B0_PHY_RL_CYCLE_DLY_SHIFT))

#define  MC_CH0_PHY_RL_CONTROL_CS0_B0_PHY_RL_TAP_DLY_MASK 0xff
#define  MC_CH0_PHY_RL_CONTROL_CS0_B0_PHY_RL_TAP_DLY_SHIFT 0
#define  MC_CH0_PHY_RL_CONTROL_CS0_B0_PHY_RL_TAP_DLY_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_RL_CONTROL_CS0_B0_PHY_RL_TAP_DLY_MASK) >> MC_CH0_PHY_RL_CONTROL_CS0_B0_PHY_RL_TAP_DLY_SHIFT)
#define  MC_CH0_PHY_RL_CONTROL_CS0_B0_PHY_RL_TAP_DLY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_RL_CONTROL_CS0_B0_PHY_RL_TAP_DLY_MASK) | (((uint32_t)val) << MC_CH0_PHY_RL_CONTROL_CS0_B0_PHY_RL_TAP_DLY_SHIFT))

//====================================================================
//Register: PHY RL Control Register (CH0_PHY_RL_Control_CS0_B1)
//====================================================================

#define  MC_CH0_PHY_RL_CONTROL_CS0_B1_RESERVED1_MASK 0xfffff000
#define  MC_CH0_PHY_RL_CONTROL_CS0_B1_RESERVED1_SHIFT 12
#define  MC_CH0_PHY_RL_CONTROL_CS0_B1_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_RL_CONTROL_CS0_B1_RESERVED1_MASK) >> MC_CH0_PHY_RL_CONTROL_CS0_B1_RESERVED1_SHIFT)
#define  MC_CH0_PHY_RL_CONTROL_CS0_B1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_RL_CONTROL_CS0_B1_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_PHY_RL_CONTROL_CS0_B1_RESERVED1_SHIFT))

#define  MC_CH0_PHY_RL_CONTROL_CS0_B1_PHY_RL_CYCLE_DLY_MASK 0xf00
#define  MC_CH0_PHY_RL_CONTROL_CS0_B1_PHY_RL_CYCLE_DLY_SHIFT 8
#define  MC_CH0_PHY_RL_CONTROL_CS0_B1_PHY_RL_CYCLE_DLY_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_RL_CONTROL_CS0_B1_PHY_RL_CYCLE_DLY_MASK) >> MC_CH0_PHY_RL_CONTROL_CS0_B1_PHY_RL_CYCLE_DLY_SHIFT)
#define  MC_CH0_PHY_RL_CONTROL_CS0_B1_PHY_RL_CYCLE_DLY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_RL_CONTROL_CS0_B1_PHY_RL_CYCLE_DLY_MASK) | (((uint32_t)val) << MC_CH0_PHY_RL_CONTROL_CS0_B1_PHY_RL_CYCLE_DLY_SHIFT))

#define  MC_CH0_PHY_RL_CONTROL_CS0_B1_PHY_RL_TAP_DLY_MASK 0xff
#define  MC_CH0_PHY_RL_CONTROL_CS0_B1_PHY_RL_TAP_DLY_SHIFT 0
#define  MC_CH0_PHY_RL_CONTROL_CS0_B1_PHY_RL_TAP_DLY_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_RL_CONTROL_CS0_B1_PHY_RL_TAP_DLY_MASK) >> MC_CH0_PHY_RL_CONTROL_CS0_B1_PHY_RL_TAP_DLY_SHIFT)
#define  MC_CH0_PHY_RL_CONTROL_CS0_B1_PHY_RL_TAP_DLY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_RL_CONTROL_CS0_B1_PHY_RL_TAP_DLY_MASK) | (((uint32_t)val) << MC_CH0_PHY_RL_CONTROL_CS0_B1_PHY_RL_TAP_DLY_SHIFT))

//====================================================================
//Register: PHY RL Control Register (CH0_PHY_RL_Control_CS0_B2)
//====================================================================

#define  MC_CH0_PHY_RL_CONTROL_CS0_B2_RESERVED1_MASK 0xfffff000
#define  MC_CH0_PHY_RL_CONTROL_CS0_B2_RESERVED1_SHIFT 12
#define  MC_CH0_PHY_RL_CONTROL_CS0_B2_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_RL_CONTROL_CS0_B2_RESERVED1_MASK) >> MC_CH0_PHY_RL_CONTROL_CS0_B2_RESERVED1_SHIFT)
#define  MC_CH0_PHY_RL_CONTROL_CS0_B2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_RL_CONTROL_CS0_B2_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_PHY_RL_CONTROL_CS0_B2_RESERVED1_SHIFT))

#define  MC_CH0_PHY_RL_CONTROL_CS0_B2_PHY_RL_CYCLE_DLY_MASK 0xf00
#define  MC_CH0_PHY_RL_CONTROL_CS0_B2_PHY_RL_CYCLE_DLY_SHIFT 8
#define  MC_CH0_PHY_RL_CONTROL_CS0_B2_PHY_RL_CYCLE_DLY_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_RL_CONTROL_CS0_B2_PHY_RL_CYCLE_DLY_MASK) >> MC_CH0_PHY_RL_CONTROL_CS0_B2_PHY_RL_CYCLE_DLY_SHIFT)
#define  MC_CH0_PHY_RL_CONTROL_CS0_B2_PHY_RL_CYCLE_DLY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_RL_CONTROL_CS0_B2_PHY_RL_CYCLE_DLY_MASK) | (((uint32_t)val) << MC_CH0_PHY_RL_CONTROL_CS0_B2_PHY_RL_CYCLE_DLY_SHIFT))

#define  MC_CH0_PHY_RL_CONTROL_CS0_B2_PHY_RL_TAP_DLY_MASK 0xff
#define  MC_CH0_PHY_RL_CONTROL_CS0_B2_PHY_RL_TAP_DLY_SHIFT 0
#define  MC_CH0_PHY_RL_CONTROL_CS0_B2_PHY_RL_TAP_DLY_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_RL_CONTROL_CS0_B2_PHY_RL_TAP_DLY_MASK) >> MC_CH0_PHY_RL_CONTROL_CS0_B2_PHY_RL_TAP_DLY_SHIFT)
#define  MC_CH0_PHY_RL_CONTROL_CS0_B2_PHY_RL_TAP_DLY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_RL_CONTROL_CS0_B2_PHY_RL_TAP_DLY_MASK) | (((uint32_t)val) << MC_CH0_PHY_RL_CONTROL_CS0_B2_PHY_RL_TAP_DLY_SHIFT))

//====================================================================
//Register: PHY RL Control Register (CH0_PHY_RL_Control_CS0_B3)
//====================================================================

#define  MC_CH0_PHY_RL_CONTROL_CS0_B3_RESERVED1_MASK 0xfffff000
#define  MC_CH0_PHY_RL_CONTROL_CS0_B3_RESERVED1_SHIFT 12
#define  MC_CH0_PHY_RL_CONTROL_CS0_B3_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_RL_CONTROL_CS0_B3_RESERVED1_MASK) >> MC_CH0_PHY_RL_CONTROL_CS0_B3_RESERVED1_SHIFT)
#define  MC_CH0_PHY_RL_CONTROL_CS0_B3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_RL_CONTROL_CS0_B3_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_PHY_RL_CONTROL_CS0_B3_RESERVED1_SHIFT))

#define  MC_CH0_PHY_RL_CONTROL_CS0_B3_PHY_RL_CYCLE_DLY_MASK 0xf00
#define  MC_CH0_PHY_RL_CONTROL_CS0_B3_PHY_RL_CYCLE_DLY_SHIFT 8
#define  MC_CH0_PHY_RL_CONTROL_CS0_B3_PHY_RL_CYCLE_DLY_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_RL_CONTROL_CS0_B3_PHY_RL_CYCLE_DLY_MASK) >> MC_CH0_PHY_RL_CONTROL_CS0_B3_PHY_RL_CYCLE_DLY_SHIFT)
#define  MC_CH0_PHY_RL_CONTROL_CS0_B3_PHY_RL_CYCLE_DLY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_RL_CONTROL_CS0_B3_PHY_RL_CYCLE_DLY_MASK) | (((uint32_t)val) << MC_CH0_PHY_RL_CONTROL_CS0_B3_PHY_RL_CYCLE_DLY_SHIFT))

#define  MC_CH0_PHY_RL_CONTROL_CS0_B3_PHY_RL_TAP_DLY_MASK 0xff
#define  MC_CH0_PHY_RL_CONTROL_CS0_B3_PHY_RL_TAP_DLY_SHIFT 0
#define  MC_CH0_PHY_RL_CONTROL_CS0_B3_PHY_RL_TAP_DLY_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_RL_CONTROL_CS0_B3_PHY_RL_TAP_DLY_MASK) >> MC_CH0_PHY_RL_CONTROL_CS0_B3_PHY_RL_TAP_DLY_SHIFT)
#define  MC_CH0_PHY_RL_CONTROL_CS0_B3_PHY_RL_TAP_DLY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_RL_CONTROL_CS0_B3_PHY_RL_TAP_DLY_MASK) | (((uint32_t)val) << MC_CH0_PHY_RL_CONTROL_CS0_B3_PHY_RL_TAP_DLY_SHIFT))

//====================================================================
//Register: PHY RL Control Register (CH0_PHY_RL_Control_CS1_B0)
//====================================================================

#define  MC_CH0_PHY_RL_CONTROL_CS1_B0_RESERVED1_MASK 0xfffff000
#define  MC_CH0_PHY_RL_CONTROL_CS1_B0_RESERVED1_SHIFT 12
#define  MC_CH0_PHY_RL_CONTROL_CS1_B0_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_RL_CONTROL_CS1_B0_RESERVED1_MASK) >> MC_CH0_PHY_RL_CONTROL_CS1_B0_RESERVED1_SHIFT)
#define  MC_CH0_PHY_RL_CONTROL_CS1_B0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_RL_CONTROL_CS1_B0_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_PHY_RL_CONTROL_CS1_B0_RESERVED1_SHIFT))

#define  MC_CH0_PHY_RL_CONTROL_CS1_B0_PHY_RL_CYCLE_DLY_MASK 0xf00
#define  MC_CH0_PHY_RL_CONTROL_CS1_B0_PHY_RL_CYCLE_DLY_SHIFT 8
#define  MC_CH0_PHY_RL_CONTROL_CS1_B0_PHY_RL_CYCLE_DLY_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_RL_CONTROL_CS1_B0_PHY_RL_CYCLE_DLY_MASK) >> MC_CH0_PHY_RL_CONTROL_CS1_B0_PHY_RL_CYCLE_DLY_SHIFT)
#define  MC_CH0_PHY_RL_CONTROL_CS1_B0_PHY_RL_CYCLE_DLY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_RL_CONTROL_CS1_B0_PHY_RL_CYCLE_DLY_MASK) | (((uint32_t)val) << MC_CH0_PHY_RL_CONTROL_CS1_B0_PHY_RL_CYCLE_DLY_SHIFT))

#define  MC_CH0_PHY_RL_CONTROL_CS1_B0_PHY_RL_TAP_DLY_MASK 0xff
#define  MC_CH0_PHY_RL_CONTROL_CS1_B0_PHY_RL_TAP_DLY_SHIFT 0
#define  MC_CH0_PHY_RL_CONTROL_CS1_B0_PHY_RL_TAP_DLY_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_RL_CONTROL_CS1_B0_PHY_RL_TAP_DLY_MASK) >> MC_CH0_PHY_RL_CONTROL_CS1_B0_PHY_RL_TAP_DLY_SHIFT)
#define  MC_CH0_PHY_RL_CONTROL_CS1_B0_PHY_RL_TAP_DLY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_RL_CONTROL_CS1_B0_PHY_RL_TAP_DLY_MASK) | (((uint32_t)val) << MC_CH0_PHY_RL_CONTROL_CS1_B0_PHY_RL_TAP_DLY_SHIFT))

//====================================================================
//Register: PHY RL Control Register (CH0_PHY_RL_Control_CS1_B1)
//====================================================================

#define  MC_CH0_PHY_RL_CONTROL_CS1_B1_RESERVED1_MASK 0xfffff000
#define  MC_CH0_PHY_RL_CONTROL_CS1_B1_RESERVED1_SHIFT 12
#define  MC_CH0_PHY_RL_CONTROL_CS1_B1_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_RL_CONTROL_CS1_B1_RESERVED1_MASK) >> MC_CH0_PHY_RL_CONTROL_CS1_B1_RESERVED1_SHIFT)
#define  MC_CH0_PHY_RL_CONTROL_CS1_B1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_RL_CONTROL_CS1_B1_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_PHY_RL_CONTROL_CS1_B1_RESERVED1_SHIFT))

#define  MC_CH0_PHY_RL_CONTROL_CS1_B1_PHY_RL_CYCLE_DLY_MASK 0xf00
#define  MC_CH0_PHY_RL_CONTROL_CS1_B1_PHY_RL_CYCLE_DLY_SHIFT 8
#define  MC_CH0_PHY_RL_CONTROL_CS1_B1_PHY_RL_CYCLE_DLY_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_RL_CONTROL_CS1_B1_PHY_RL_CYCLE_DLY_MASK) >> MC_CH0_PHY_RL_CONTROL_CS1_B1_PHY_RL_CYCLE_DLY_SHIFT)
#define  MC_CH0_PHY_RL_CONTROL_CS1_B1_PHY_RL_CYCLE_DLY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_RL_CONTROL_CS1_B1_PHY_RL_CYCLE_DLY_MASK) | (((uint32_t)val) << MC_CH0_PHY_RL_CONTROL_CS1_B1_PHY_RL_CYCLE_DLY_SHIFT))

#define  MC_CH0_PHY_RL_CONTROL_CS1_B1_PHY_RL_TAP_DLY_MASK 0xff
#define  MC_CH0_PHY_RL_CONTROL_CS1_B1_PHY_RL_TAP_DLY_SHIFT 0
#define  MC_CH0_PHY_RL_CONTROL_CS1_B1_PHY_RL_TAP_DLY_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_RL_CONTROL_CS1_B1_PHY_RL_TAP_DLY_MASK) >> MC_CH0_PHY_RL_CONTROL_CS1_B1_PHY_RL_TAP_DLY_SHIFT)
#define  MC_CH0_PHY_RL_CONTROL_CS1_B1_PHY_RL_TAP_DLY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_RL_CONTROL_CS1_B1_PHY_RL_TAP_DLY_MASK) | (((uint32_t)val) << MC_CH0_PHY_RL_CONTROL_CS1_B1_PHY_RL_TAP_DLY_SHIFT))

//====================================================================
//Register: PHY RL Control Register (CH0_PHY_RL_Control_CS1_B2)
//====================================================================

#define  MC_CH0_PHY_RL_CONTROL_CS1_B2_RESERVED1_MASK 0xfffff000
#define  MC_CH0_PHY_RL_CONTROL_CS1_B2_RESERVED1_SHIFT 12
#define  MC_CH0_PHY_RL_CONTROL_CS1_B2_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_RL_CONTROL_CS1_B2_RESERVED1_MASK) >> MC_CH0_PHY_RL_CONTROL_CS1_B2_RESERVED1_SHIFT)
#define  MC_CH0_PHY_RL_CONTROL_CS1_B2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_RL_CONTROL_CS1_B2_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_PHY_RL_CONTROL_CS1_B2_RESERVED1_SHIFT))

#define  MC_CH0_PHY_RL_CONTROL_CS1_B2_PHY_RL_CYCLE_DLY_MASK 0xf00
#define  MC_CH0_PHY_RL_CONTROL_CS1_B2_PHY_RL_CYCLE_DLY_SHIFT 8
#define  MC_CH0_PHY_RL_CONTROL_CS1_B2_PHY_RL_CYCLE_DLY_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_RL_CONTROL_CS1_B2_PHY_RL_CYCLE_DLY_MASK) >> MC_CH0_PHY_RL_CONTROL_CS1_B2_PHY_RL_CYCLE_DLY_SHIFT)
#define  MC_CH0_PHY_RL_CONTROL_CS1_B2_PHY_RL_CYCLE_DLY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_RL_CONTROL_CS1_B2_PHY_RL_CYCLE_DLY_MASK) | (((uint32_t)val) << MC_CH0_PHY_RL_CONTROL_CS1_B2_PHY_RL_CYCLE_DLY_SHIFT))

#define  MC_CH0_PHY_RL_CONTROL_CS1_B2_PHY_RL_TAP_DLY_MASK 0xff
#define  MC_CH0_PHY_RL_CONTROL_CS1_B2_PHY_RL_TAP_DLY_SHIFT 0
#define  MC_CH0_PHY_RL_CONTROL_CS1_B2_PHY_RL_TAP_DLY_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_RL_CONTROL_CS1_B2_PHY_RL_TAP_DLY_MASK) >> MC_CH0_PHY_RL_CONTROL_CS1_B2_PHY_RL_TAP_DLY_SHIFT)
#define  MC_CH0_PHY_RL_CONTROL_CS1_B2_PHY_RL_TAP_DLY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_RL_CONTROL_CS1_B2_PHY_RL_TAP_DLY_MASK) | (((uint32_t)val) << MC_CH0_PHY_RL_CONTROL_CS1_B2_PHY_RL_TAP_DLY_SHIFT))

//====================================================================
//Register: PHY RL Control Register (CH0_PHY_RL_Control_CS1_B3)
//====================================================================

#define  MC_CH0_PHY_RL_CONTROL_CS1_B3_RESERVED1_MASK 0xfffff000
#define  MC_CH0_PHY_RL_CONTROL_CS1_B3_RESERVED1_SHIFT 12
#define  MC_CH0_PHY_RL_CONTROL_CS1_B3_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_RL_CONTROL_CS1_B3_RESERVED1_MASK) >> MC_CH0_PHY_RL_CONTROL_CS1_B3_RESERVED1_SHIFT)
#define  MC_CH0_PHY_RL_CONTROL_CS1_B3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_RL_CONTROL_CS1_B3_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_PHY_RL_CONTROL_CS1_B3_RESERVED1_SHIFT))

#define  MC_CH0_PHY_RL_CONTROL_CS1_B3_PHY_RL_CYCLE_DLY_MASK 0xf00
#define  MC_CH0_PHY_RL_CONTROL_CS1_B3_PHY_RL_CYCLE_DLY_SHIFT 8
#define  MC_CH0_PHY_RL_CONTROL_CS1_B3_PHY_RL_CYCLE_DLY_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_RL_CONTROL_CS1_B3_PHY_RL_CYCLE_DLY_MASK) >> MC_CH0_PHY_RL_CONTROL_CS1_B3_PHY_RL_CYCLE_DLY_SHIFT)
#define  MC_CH0_PHY_RL_CONTROL_CS1_B3_PHY_RL_CYCLE_DLY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_RL_CONTROL_CS1_B3_PHY_RL_CYCLE_DLY_MASK) | (((uint32_t)val) << MC_CH0_PHY_RL_CONTROL_CS1_B3_PHY_RL_CYCLE_DLY_SHIFT))

#define  MC_CH0_PHY_RL_CONTROL_CS1_B3_PHY_RL_TAP_DLY_MASK 0xff
#define  MC_CH0_PHY_RL_CONTROL_CS1_B3_PHY_RL_TAP_DLY_SHIFT 0
#define  MC_CH0_PHY_RL_CONTROL_CS1_B3_PHY_RL_TAP_DLY_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_RL_CONTROL_CS1_B3_PHY_RL_TAP_DLY_MASK) >> MC_CH0_PHY_RL_CONTROL_CS1_B3_PHY_RL_TAP_DLY_SHIFT)
#define  MC_CH0_PHY_RL_CONTROL_CS1_B3_PHY_RL_TAP_DLY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_RL_CONTROL_CS1_B3_PHY_RL_TAP_DLY_MASK) | (((uint32_t)val) << MC_CH0_PHY_RL_CONTROL_CS1_B3_PHY_RL_TAP_DLY_SHIFT))

//====================================================================
//Register: PHY RL Control Register (CH0_PHY_RL_Control_CS2_B0)
//====================================================================

#define  MC_CH0_PHY_RL_CONTROL_CS2_B0_RESERVED1_MASK 0xfffff000
#define  MC_CH0_PHY_RL_CONTROL_CS2_B0_RESERVED1_SHIFT 12
#define  MC_CH0_PHY_RL_CONTROL_CS2_B0_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_RL_CONTROL_CS2_B0_RESERVED1_MASK) >> MC_CH0_PHY_RL_CONTROL_CS2_B0_RESERVED1_SHIFT)
#define  MC_CH0_PHY_RL_CONTROL_CS2_B0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_RL_CONTROL_CS2_B0_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_PHY_RL_CONTROL_CS2_B0_RESERVED1_SHIFT))

#define  MC_CH0_PHY_RL_CONTROL_CS2_B0_PHY_RL_CYCLE_DLY_MASK 0xf00
#define  MC_CH0_PHY_RL_CONTROL_CS2_B0_PHY_RL_CYCLE_DLY_SHIFT 8
#define  MC_CH0_PHY_RL_CONTROL_CS2_B0_PHY_RL_CYCLE_DLY_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_RL_CONTROL_CS2_B0_PHY_RL_CYCLE_DLY_MASK) >> MC_CH0_PHY_RL_CONTROL_CS2_B0_PHY_RL_CYCLE_DLY_SHIFT)
#define  MC_CH0_PHY_RL_CONTROL_CS2_B0_PHY_RL_CYCLE_DLY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_RL_CONTROL_CS2_B0_PHY_RL_CYCLE_DLY_MASK) | (((uint32_t)val) << MC_CH0_PHY_RL_CONTROL_CS2_B0_PHY_RL_CYCLE_DLY_SHIFT))

#define  MC_CH0_PHY_RL_CONTROL_CS2_B0_PHY_RL_TAP_DLY_MASK 0xff
#define  MC_CH0_PHY_RL_CONTROL_CS2_B0_PHY_RL_TAP_DLY_SHIFT 0
#define  MC_CH0_PHY_RL_CONTROL_CS2_B0_PHY_RL_TAP_DLY_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_RL_CONTROL_CS2_B0_PHY_RL_TAP_DLY_MASK) >> MC_CH0_PHY_RL_CONTROL_CS2_B0_PHY_RL_TAP_DLY_SHIFT)
#define  MC_CH0_PHY_RL_CONTROL_CS2_B0_PHY_RL_TAP_DLY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_RL_CONTROL_CS2_B0_PHY_RL_TAP_DLY_MASK) | (((uint32_t)val) << MC_CH0_PHY_RL_CONTROL_CS2_B0_PHY_RL_TAP_DLY_SHIFT))

//====================================================================
//Register: PHY RL Control Register (CH0_PHY_RL_Control_CS2_B1)
//====================================================================

#define  MC_CH0_PHY_RL_CONTROL_CS2_B1_RESERVED1_MASK 0xfffff000
#define  MC_CH0_PHY_RL_CONTROL_CS2_B1_RESERVED1_SHIFT 12
#define  MC_CH0_PHY_RL_CONTROL_CS2_B1_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_RL_CONTROL_CS2_B1_RESERVED1_MASK) >> MC_CH0_PHY_RL_CONTROL_CS2_B1_RESERVED1_SHIFT)
#define  MC_CH0_PHY_RL_CONTROL_CS2_B1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_RL_CONTROL_CS2_B1_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_PHY_RL_CONTROL_CS2_B1_RESERVED1_SHIFT))

#define  MC_CH0_PHY_RL_CONTROL_CS2_B1_PHY_RL_CYCLE_DLY_MASK 0xf00
#define  MC_CH0_PHY_RL_CONTROL_CS2_B1_PHY_RL_CYCLE_DLY_SHIFT 8
#define  MC_CH0_PHY_RL_CONTROL_CS2_B1_PHY_RL_CYCLE_DLY_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_RL_CONTROL_CS2_B1_PHY_RL_CYCLE_DLY_MASK) >> MC_CH0_PHY_RL_CONTROL_CS2_B1_PHY_RL_CYCLE_DLY_SHIFT)
#define  MC_CH0_PHY_RL_CONTROL_CS2_B1_PHY_RL_CYCLE_DLY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_RL_CONTROL_CS2_B1_PHY_RL_CYCLE_DLY_MASK) | (((uint32_t)val) << MC_CH0_PHY_RL_CONTROL_CS2_B1_PHY_RL_CYCLE_DLY_SHIFT))

#define  MC_CH0_PHY_RL_CONTROL_CS2_B1_PHY_RL_TAP_DLY_MASK 0xff
#define  MC_CH0_PHY_RL_CONTROL_CS2_B1_PHY_RL_TAP_DLY_SHIFT 0
#define  MC_CH0_PHY_RL_CONTROL_CS2_B1_PHY_RL_TAP_DLY_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_RL_CONTROL_CS2_B1_PHY_RL_TAP_DLY_MASK) >> MC_CH0_PHY_RL_CONTROL_CS2_B1_PHY_RL_TAP_DLY_SHIFT)
#define  MC_CH0_PHY_RL_CONTROL_CS2_B1_PHY_RL_TAP_DLY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_RL_CONTROL_CS2_B1_PHY_RL_TAP_DLY_MASK) | (((uint32_t)val) << MC_CH0_PHY_RL_CONTROL_CS2_B1_PHY_RL_TAP_DLY_SHIFT))

//====================================================================
//Register: PHY RL Control Register (CH0_PHY_RL_Control_CS2_B2)
//====================================================================

#define  MC_CH0_PHY_RL_CONTROL_CS2_B2_RESERVED1_MASK 0xfffff000
#define  MC_CH0_PHY_RL_CONTROL_CS2_B2_RESERVED1_SHIFT 12
#define  MC_CH0_PHY_RL_CONTROL_CS2_B2_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_RL_CONTROL_CS2_B2_RESERVED1_MASK) >> MC_CH0_PHY_RL_CONTROL_CS2_B2_RESERVED1_SHIFT)
#define  MC_CH0_PHY_RL_CONTROL_CS2_B2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_RL_CONTROL_CS2_B2_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_PHY_RL_CONTROL_CS2_B2_RESERVED1_SHIFT))

#define  MC_CH0_PHY_RL_CONTROL_CS2_B2_PHY_RL_CYCLE_DLY_MASK 0xf00
#define  MC_CH0_PHY_RL_CONTROL_CS2_B2_PHY_RL_CYCLE_DLY_SHIFT 8
#define  MC_CH0_PHY_RL_CONTROL_CS2_B2_PHY_RL_CYCLE_DLY_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_RL_CONTROL_CS2_B2_PHY_RL_CYCLE_DLY_MASK) >> MC_CH0_PHY_RL_CONTROL_CS2_B2_PHY_RL_CYCLE_DLY_SHIFT)
#define  MC_CH0_PHY_RL_CONTROL_CS2_B2_PHY_RL_CYCLE_DLY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_RL_CONTROL_CS2_B2_PHY_RL_CYCLE_DLY_MASK) | (((uint32_t)val) << MC_CH0_PHY_RL_CONTROL_CS2_B2_PHY_RL_CYCLE_DLY_SHIFT))

#define  MC_CH0_PHY_RL_CONTROL_CS2_B2_PHY_RL_TAP_DLY_MASK 0xff
#define  MC_CH0_PHY_RL_CONTROL_CS2_B2_PHY_RL_TAP_DLY_SHIFT 0
#define  MC_CH0_PHY_RL_CONTROL_CS2_B2_PHY_RL_TAP_DLY_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_RL_CONTROL_CS2_B2_PHY_RL_TAP_DLY_MASK) >> MC_CH0_PHY_RL_CONTROL_CS2_B2_PHY_RL_TAP_DLY_SHIFT)
#define  MC_CH0_PHY_RL_CONTROL_CS2_B2_PHY_RL_TAP_DLY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_RL_CONTROL_CS2_B2_PHY_RL_TAP_DLY_MASK) | (((uint32_t)val) << MC_CH0_PHY_RL_CONTROL_CS2_B2_PHY_RL_TAP_DLY_SHIFT))

//====================================================================
//Register: PHY RL Control Register (CH0_PHY_RL_Control_CS2_B3)
//====================================================================

#define  MC_CH0_PHY_RL_CONTROL_CS2_B3_RESERVED1_MASK 0xfffff000
#define  MC_CH0_PHY_RL_CONTROL_CS2_B3_RESERVED1_SHIFT 12
#define  MC_CH0_PHY_RL_CONTROL_CS2_B3_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_RL_CONTROL_CS2_B3_RESERVED1_MASK) >> MC_CH0_PHY_RL_CONTROL_CS2_B3_RESERVED1_SHIFT)
#define  MC_CH0_PHY_RL_CONTROL_CS2_B3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_RL_CONTROL_CS2_B3_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_PHY_RL_CONTROL_CS2_B3_RESERVED1_SHIFT))

#define  MC_CH0_PHY_RL_CONTROL_CS2_B3_PHY_RL_CYCLE_DLY_MASK 0xf00
#define  MC_CH0_PHY_RL_CONTROL_CS2_B3_PHY_RL_CYCLE_DLY_SHIFT 8
#define  MC_CH0_PHY_RL_CONTROL_CS2_B3_PHY_RL_CYCLE_DLY_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_RL_CONTROL_CS2_B3_PHY_RL_CYCLE_DLY_MASK) >> MC_CH0_PHY_RL_CONTROL_CS2_B3_PHY_RL_CYCLE_DLY_SHIFT)
#define  MC_CH0_PHY_RL_CONTROL_CS2_B3_PHY_RL_CYCLE_DLY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_RL_CONTROL_CS2_B3_PHY_RL_CYCLE_DLY_MASK) | (((uint32_t)val) << MC_CH0_PHY_RL_CONTROL_CS2_B3_PHY_RL_CYCLE_DLY_SHIFT))

#define  MC_CH0_PHY_RL_CONTROL_CS2_B3_PHY_RL_TAP_DLY_MASK 0xff
#define  MC_CH0_PHY_RL_CONTROL_CS2_B3_PHY_RL_TAP_DLY_SHIFT 0
#define  MC_CH0_PHY_RL_CONTROL_CS2_B3_PHY_RL_TAP_DLY_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_RL_CONTROL_CS2_B3_PHY_RL_TAP_DLY_MASK) >> MC_CH0_PHY_RL_CONTROL_CS2_B3_PHY_RL_TAP_DLY_SHIFT)
#define  MC_CH0_PHY_RL_CONTROL_CS2_B3_PHY_RL_TAP_DLY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_RL_CONTROL_CS2_B3_PHY_RL_TAP_DLY_MASK) | (((uint32_t)val) << MC_CH0_PHY_RL_CONTROL_CS2_B3_PHY_RL_TAP_DLY_SHIFT))

//====================================================================
//Register: PHY CA Delay Register 0 (CH0_PHY_CA_Delay0)
//====================================================================

#define  MC_CH0_PHY_CA_DELAY0_RESERVED1_MASK 0xf0000000
#define  MC_CH0_PHY_CA_DELAY0_RESERVED1_SHIFT 28
#define  MC_CH0_PHY_CA_DELAY0_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CA_DELAY0_RESERVED1_MASK) >> MC_CH0_PHY_CA_DELAY0_RESERVED1_SHIFT)
#define  MC_CH0_PHY_CA_DELAY0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CA_DELAY0_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_PHY_CA_DELAY0_RESERVED1_SHIFT))

#define  MC_CH0_PHY_CA_DELAY0_CA3_DELAY_MASK 0xf000000
#define  MC_CH0_PHY_CA_DELAY0_CA3_DELAY_SHIFT 24
#define  MC_CH0_PHY_CA_DELAY0_CA3_DELAY_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CA_DELAY0_CA3_DELAY_MASK) >> MC_CH0_PHY_CA_DELAY0_CA3_DELAY_SHIFT)
#define  MC_CH0_PHY_CA_DELAY0_CA3_DELAY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CA_DELAY0_CA3_DELAY_MASK) | (((uint32_t)val) << MC_CH0_PHY_CA_DELAY0_CA3_DELAY_SHIFT))

#define  MC_CH0_PHY_CA_DELAY0_RESERVED2_MASK 0xf00000
#define  MC_CH0_PHY_CA_DELAY0_RESERVED2_SHIFT 20
#define  MC_CH0_PHY_CA_DELAY0_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CA_DELAY0_RESERVED2_MASK) >> MC_CH0_PHY_CA_DELAY0_RESERVED2_SHIFT)
#define  MC_CH0_PHY_CA_DELAY0_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CA_DELAY0_RESERVED2_MASK) | (((uint32_t)val) << MC_CH0_PHY_CA_DELAY0_RESERVED2_SHIFT))

#define  MC_CH0_PHY_CA_DELAY0_CA2_DELAY_MASK 0xf0000
#define  MC_CH0_PHY_CA_DELAY0_CA2_DELAY_SHIFT 16
#define  MC_CH0_PHY_CA_DELAY0_CA2_DELAY_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CA_DELAY0_CA2_DELAY_MASK) >> MC_CH0_PHY_CA_DELAY0_CA2_DELAY_SHIFT)
#define  MC_CH0_PHY_CA_DELAY0_CA2_DELAY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CA_DELAY0_CA2_DELAY_MASK) | (((uint32_t)val) << MC_CH0_PHY_CA_DELAY0_CA2_DELAY_SHIFT))

#define  MC_CH0_PHY_CA_DELAY0_RESERVED3_MASK 0xf000
#define  MC_CH0_PHY_CA_DELAY0_RESERVED3_SHIFT 12
#define  MC_CH0_PHY_CA_DELAY0_RESERVED3_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CA_DELAY0_RESERVED3_MASK) >> MC_CH0_PHY_CA_DELAY0_RESERVED3_SHIFT)
#define  MC_CH0_PHY_CA_DELAY0_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CA_DELAY0_RESERVED3_MASK) | (((uint32_t)val) << MC_CH0_PHY_CA_DELAY0_RESERVED3_SHIFT))

#define  MC_CH0_PHY_CA_DELAY0_CA1_DELAY_MASK 0xf00
#define  MC_CH0_PHY_CA_DELAY0_CA1_DELAY_SHIFT 8
#define  MC_CH0_PHY_CA_DELAY0_CA1_DELAY_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CA_DELAY0_CA1_DELAY_MASK) >> MC_CH0_PHY_CA_DELAY0_CA1_DELAY_SHIFT)
#define  MC_CH0_PHY_CA_DELAY0_CA1_DELAY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CA_DELAY0_CA1_DELAY_MASK) | (((uint32_t)val) << MC_CH0_PHY_CA_DELAY0_CA1_DELAY_SHIFT))

#define  MC_CH0_PHY_CA_DELAY0_RESERVED4_MASK 0xf0
#define  MC_CH0_PHY_CA_DELAY0_RESERVED4_SHIFT 4
#define  MC_CH0_PHY_CA_DELAY0_RESERVED4_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CA_DELAY0_RESERVED4_MASK) >> MC_CH0_PHY_CA_DELAY0_RESERVED4_SHIFT)
#define  MC_CH0_PHY_CA_DELAY0_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CA_DELAY0_RESERVED4_MASK) | (((uint32_t)val) << MC_CH0_PHY_CA_DELAY0_RESERVED4_SHIFT))

#define  MC_CH0_PHY_CA_DELAY0_CA0_DELAY_MASK 0xf
#define  MC_CH0_PHY_CA_DELAY0_CA0_DELAY_SHIFT 0
#define  MC_CH0_PHY_CA_DELAY0_CA0_DELAY_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CA_DELAY0_CA0_DELAY_MASK) >> MC_CH0_PHY_CA_DELAY0_CA0_DELAY_SHIFT)
#define  MC_CH0_PHY_CA_DELAY0_CA0_DELAY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CA_DELAY0_CA0_DELAY_MASK) | (((uint32_t)val) << MC_CH0_PHY_CA_DELAY0_CA0_DELAY_SHIFT))

//====================================================================
//Register: PHY CA Delay Register 1 (CH0_PHY_CA_Delay1)
//====================================================================

#define  MC_CH0_PHY_CA_DELAY1_RESERVED1_MASK 0xf0000000
#define  MC_CH0_PHY_CA_DELAY1_RESERVED1_SHIFT 28
#define  MC_CH0_PHY_CA_DELAY1_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CA_DELAY1_RESERVED1_MASK) >> MC_CH0_PHY_CA_DELAY1_RESERVED1_SHIFT)
#define  MC_CH0_PHY_CA_DELAY1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CA_DELAY1_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_PHY_CA_DELAY1_RESERVED1_SHIFT))

#define  MC_CH0_PHY_CA_DELAY1_CA8_DELAY_MASK 0xf000000
#define  MC_CH0_PHY_CA_DELAY1_CA8_DELAY_SHIFT 24
#define  MC_CH0_PHY_CA_DELAY1_CA8_DELAY_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CA_DELAY1_CA8_DELAY_MASK) >> MC_CH0_PHY_CA_DELAY1_CA8_DELAY_SHIFT)
#define  MC_CH0_PHY_CA_DELAY1_CA8_DELAY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CA_DELAY1_CA8_DELAY_MASK) | (((uint32_t)val) << MC_CH0_PHY_CA_DELAY1_CA8_DELAY_SHIFT))

#define  MC_CH0_PHY_CA_DELAY1_RESERVED2_MASK 0xf00000
#define  MC_CH0_PHY_CA_DELAY1_RESERVED2_SHIFT 20
#define  MC_CH0_PHY_CA_DELAY1_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CA_DELAY1_RESERVED2_MASK) >> MC_CH0_PHY_CA_DELAY1_RESERVED2_SHIFT)
#define  MC_CH0_PHY_CA_DELAY1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CA_DELAY1_RESERVED2_MASK) | (((uint32_t)val) << MC_CH0_PHY_CA_DELAY1_RESERVED2_SHIFT))

#define  MC_CH0_PHY_CA_DELAY1_CA7_DELAY_MASK 0xf0000
#define  MC_CH0_PHY_CA_DELAY1_CA7_DELAY_SHIFT 16
#define  MC_CH0_PHY_CA_DELAY1_CA7_DELAY_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CA_DELAY1_CA7_DELAY_MASK) >> MC_CH0_PHY_CA_DELAY1_CA7_DELAY_SHIFT)
#define  MC_CH0_PHY_CA_DELAY1_CA7_DELAY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CA_DELAY1_CA7_DELAY_MASK) | (((uint32_t)val) << MC_CH0_PHY_CA_DELAY1_CA7_DELAY_SHIFT))

#define  MC_CH0_PHY_CA_DELAY1_RESERVED3_MASK 0xf000
#define  MC_CH0_PHY_CA_DELAY1_RESERVED3_SHIFT 12
#define  MC_CH0_PHY_CA_DELAY1_RESERVED3_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CA_DELAY1_RESERVED3_MASK) >> MC_CH0_PHY_CA_DELAY1_RESERVED3_SHIFT)
#define  MC_CH0_PHY_CA_DELAY1_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CA_DELAY1_RESERVED3_MASK) | (((uint32_t)val) << MC_CH0_PHY_CA_DELAY1_RESERVED3_SHIFT))

#define  MC_CH0_PHY_CA_DELAY1_CA6_DELAY_MASK 0xf00
#define  MC_CH0_PHY_CA_DELAY1_CA6_DELAY_SHIFT 8
#define  MC_CH0_PHY_CA_DELAY1_CA6_DELAY_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CA_DELAY1_CA6_DELAY_MASK) >> MC_CH0_PHY_CA_DELAY1_CA6_DELAY_SHIFT)
#define  MC_CH0_PHY_CA_DELAY1_CA6_DELAY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CA_DELAY1_CA6_DELAY_MASK) | (((uint32_t)val) << MC_CH0_PHY_CA_DELAY1_CA6_DELAY_SHIFT))

#define  MC_CH0_PHY_CA_DELAY1_RESERVED4_MASK 0xf0
#define  MC_CH0_PHY_CA_DELAY1_RESERVED4_SHIFT 4
#define  MC_CH0_PHY_CA_DELAY1_RESERVED4_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CA_DELAY1_RESERVED4_MASK) >> MC_CH0_PHY_CA_DELAY1_RESERVED4_SHIFT)
#define  MC_CH0_PHY_CA_DELAY1_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CA_DELAY1_RESERVED4_MASK) | (((uint32_t)val) << MC_CH0_PHY_CA_DELAY1_RESERVED4_SHIFT))

#define  MC_CH0_PHY_CA_DELAY1_CA5_DELAY_MASK 0xf
#define  MC_CH0_PHY_CA_DELAY1_CA5_DELAY_SHIFT 0
#define  MC_CH0_PHY_CA_DELAY1_CA5_DELAY_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CA_DELAY1_CA5_DELAY_MASK) >> MC_CH0_PHY_CA_DELAY1_CA5_DELAY_SHIFT)
#define  MC_CH0_PHY_CA_DELAY1_CA5_DELAY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CA_DELAY1_CA5_DELAY_MASK) | (((uint32_t)val) << MC_CH0_PHY_CA_DELAY1_CA5_DELAY_SHIFT))

//====================================================================
//Register: PHY CA Delay Register 2 (CH0_PHY_CA_Delay2)
//====================================================================

#define  MC_CH0_PHY_CA_DELAY2_RESERVED1_MASK 0xfffff000
#define  MC_CH0_PHY_CA_DELAY2_RESERVED1_SHIFT 12
#define  MC_CH0_PHY_CA_DELAY2_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CA_DELAY2_RESERVED1_MASK) >> MC_CH0_PHY_CA_DELAY2_RESERVED1_SHIFT)
#define  MC_CH0_PHY_CA_DELAY2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CA_DELAY2_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_PHY_CA_DELAY2_RESERVED1_SHIFT))

#define  MC_CH0_PHY_CA_DELAY2_CA9_DELAY_MASK 0xf00
#define  MC_CH0_PHY_CA_DELAY2_CA9_DELAY_SHIFT 8
#define  MC_CH0_PHY_CA_DELAY2_CA9_DELAY_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CA_DELAY2_CA9_DELAY_MASK) >> MC_CH0_PHY_CA_DELAY2_CA9_DELAY_SHIFT)
#define  MC_CH0_PHY_CA_DELAY2_CA9_DELAY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CA_DELAY2_CA9_DELAY_MASK) | (((uint32_t)val) << MC_CH0_PHY_CA_DELAY2_CA9_DELAY_SHIFT))

#define  MC_CH0_PHY_CA_DELAY2_RESERVED2_MASK 0xf0
#define  MC_CH0_PHY_CA_DELAY2_RESERVED2_SHIFT 4
#define  MC_CH0_PHY_CA_DELAY2_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CA_DELAY2_RESERVED2_MASK) >> MC_CH0_PHY_CA_DELAY2_RESERVED2_SHIFT)
#define  MC_CH0_PHY_CA_DELAY2_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CA_DELAY2_RESERVED2_MASK) | (((uint32_t)val) << MC_CH0_PHY_CA_DELAY2_RESERVED2_SHIFT))

#define  MC_CH0_PHY_CA_DELAY2_CA4_DELAY_MASK 0xf
#define  MC_CH0_PHY_CA_DELAY2_CA4_DELAY_SHIFT 0
#define  MC_CH0_PHY_CA_DELAY2_CA4_DELAY_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CA_DELAY2_CA4_DELAY_MASK) >> MC_CH0_PHY_CA_DELAY2_CA4_DELAY_SHIFT)
#define  MC_CH0_PHY_CA_DELAY2_CA4_DELAY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CA_DELAY2_CA4_DELAY_MASK) | (((uint32_t)val) << MC_CH0_PHY_CA_DELAY2_CA4_DELAY_SHIFT))

//====================================================================
//Register: PHY CA Train Result (CH0_PHY_CA_Train_Result)
//====================================================================

#define  MC_CH0_PHY_CA_TRAIN_RESULT_RESERVED1_MASK 0xffff0000
#define  MC_CH0_PHY_CA_TRAIN_RESULT_RESERVED1_SHIFT 16
#define  MC_CH0_PHY_CA_TRAIN_RESULT_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CA_TRAIN_RESULT_RESERVED1_MASK) >> MC_CH0_PHY_CA_TRAIN_RESULT_RESERVED1_SHIFT)
#define  MC_CH0_PHY_CA_TRAIN_RESULT_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CA_TRAIN_RESULT_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_PHY_CA_TRAIN_RESULT_RESERVED1_SHIFT))

#define  MC_CH0_PHY_CA_TRAIN_RESULT_CA_TRAIN_RESULT_MASK 0xffff
#define  MC_CH0_PHY_CA_TRAIN_RESULT_CA_TRAIN_RESULT_SHIFT 0
#define  MC_CH0_PHY_CA_TRAIN_RESULT_CA_TRAIN_RESULT_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_CA_TRAIN_RESULT_CA_TRAIN_RESULT_MASK) >> MC_CH0_PHY_CA_TRAIN_RESULT_CA_TRAIN_RESULT_SHIFT)
#define  MC_CH0_PHY_CA_TRAIN_RESULT_CA_TRAIN_RESULT_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_CA_TRAIN_RESULT_CA_TRAIN_RESULT_MASK) | (((uint32_t)val) << MC_CH0_PHY_CA_TRAIN_RESULT_CA_TRAIN_RESULT_SHIFT))

//====================================================================
//Register: PHY PRBS Status and Mask Register (CH0_PHY_PRBS_Stat_Mask_B0)
//====================================================================

#define  MC_CH0_PHY_PRBS_STAT_MASK_B0_SUBPHY_PRBS_ERROR_STAT_MASK 0xffff0000
#define  MC_CH0_PHY_PRBS_STAT_MASK_B0_SUBPHY_PRBS_ERROR_STAT_SHIFT 16
#define  MC_CH0_PHY_PRBS_STAT_MASK_B0_SUBPHY_PRBS_ERROR_STAT_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_PRBS_STAT_MASK_B0_SUBPHY_PRBS_ERROR_STAT_MASK) >> MC_CH0_PHY_PRBS_STAT_MASK_B0_SUBPHY_PRBS_ERROR_STAT_SHIFT)
#define  MC_CH0_PHY_PRBS_STAT_MASK_B0_SUBPHY_PRBS_ERROR_STAT_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_PRBS_STAT_MASK_B0_SUBPHY_PRBS_ERROR_STAT_MASK) | (((uint32_t)val) << MC_CH0_PHY_PRBS_STAT_MASK_B0_SUBPHY_PRBS_ERROR_STAT_SHIFT))

#define  MC_CH0_PHY_PRBS_STAT_MASK_B0_SUBPHY_PRBS_MASK_MASK 0xffff
#define  MC_CH0_PHY_PRBS_STAT_MASK_B0_SUBPHY_PRBS_MASK_SHIFT 0
#define  MC_CH0_PHY_PRBS_STAT_MASK_B0_SUBPHY_PRBS_MASK_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_PRBS_STAT_MASK_B0_SUBPHY_PRBS_MASK_MASK) >> MC_CH0_PHY_PRBS_STAT_MASK_B0_SUBPHY_PRBS_MASK_SHIFT)
#define  MC_CH0_PHY_PRBS_STAT_MASK_B0_SUBPHY_PRBS_MASK_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_PRBS_STAT_MASK_B0_SUBPHY_PRBS_MASK_MASK) | (((uint32_t)val) << MC_CH0_PHY_PRBS_STAT_MASK_B0_SUBPHY_PRBS_MASK_SHIFT))

//====================================================================
//Register: PHY PRBS Status and Mask Register (CH0_PHY_PRBS_Stat_Mask_B1)
//====================================================================

#define  MC_CH0_PHY_PRBS_STAT_MASK_B1_SUBPHY_PRBS_ERROR_STAT_MASK 0xffff0000
#define  MC_CH0_PHY_PRBS_STAT_MASK_B1_SUBPHY_PRBS_ERROR_STAT_SHIFT 16
#define  MC_CH0_PHY_PRBS_STAT_MASK_B1_SUBPHY_PRBS_ERROR_STAT_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_PRBS_STAT_MASK_B1_SUBPHY_PRBS_ERROR_STAT_MASK) >> MC_CH0_PHY_PRBS_STAT_MASK_B1_SUBPHY_PRBS_ERROR_STAT_SHIFT)
#define  MC_CH0_PHY_PRBS_STAT_MASK_B1_SUBPHY_PRBS_ERROR_STAT_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_PRBS_STAT_MASK_B1_SUBPHY_PRBS_ERROR_STAT_MASK) | (((uint32_t)val) << MC_CH0_PHY_PRBS_STAT_MASK_B1_SUBPHY_PRBS_ERROR_STAT_SHIFT))

#define  MC_CH0_PHY_PRBS_STAT_MASK_B1_SUBPHY_PRBS_MASK_MASK 0xffff
#define  MC_CH0_PHY_PRBS_STAT_MASK_B1_SUBPHY_PRBS_MASK_SHIFT 0
#define  MC_CH0_PHY_PRBS_STAT_MASK_B1_SUBPHY_PRBS_MASK_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_PRBS_STAT_MASK_B1_SUBPHY_PRBS_MASK_MASK) >> MC_CH0_PHY_PRBS_STAT_MASK_B1_SUBPHY_PRBS_MASK_SHIFT)
#define  MC_CH0_PHY_PRBS_STAT_MASK_B1_SUBPHY_PRBS_MASK_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_PRBS_STAT_MASK_B1_SUBPHY_PRBS_MASK_MASK) | (((uint32_t)val) << MC_CH0_PHY_PRBS_STAT_MASK_B1_SUBPHY_PRBS_MASK_SHIFT))

//====================================================================
//Register: PHY PRBS Status and Mask Register (CH0_PHY_PRBS_Stat_Mask_B2)
//====================================================================

#define  MC_CH0_PHY_PRBS_STAT_MASK_B2_SUBPHY_PRBS_ERROR_STAT_MASK 0xffff0000
#define  MC_CH0_PHY_PRBS_STAT_MASK_B2_SUBPHY_PRBS_ERROR_STAT_SHIFT 16
#define  MC_CH0_PHY_PRBS_STAT_MASK_B2_SUBPHY_PRBS_ERROR_STAT_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_PRBS_STAT_MASK_B2_SUBPHY_PRBS_ERROR_STAT_MASK) >> MC_CH0_PHY_PRBS_STAT_MASK_B2_SUBPHY_PRBS_ERROR_STAT_SHIFT)
#define  MC_CH0_PHY_PRBS_STAT_MASK_B2_SUBPHY_PRBS_ERROR_STAT_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_PRBS_STAT_MASK_B2_SUBPHY_PRBS_ERROR_STAT_MASK) | (((uint32_t)val) << MC_CH0_PHY_PRBS_STAT_MASK_B2_SUBPHY_PRBS_ERROR_STAT_SHIFT))

#define  MC_CH0_PHY_PRBS_STAT_MASK_B2_SUBPHY_PRBS_MASK_MASK 0xffff
#define  MC_CH0_PHY_PRBS_STAT_MASK_B2_SUBPHY_PRBS_MASK_SHIFT 0
#define  MC_CH0_PHY_PRBS_STAT_MASK_B2_SUBPHY_PRBS_MASK_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_PRBS_STAT_MASK_B2_SUBPHY_PRBS_MASK_MASK) >> MC_CH0_PHY_PRBS_STAT_MASK_B2_SUBPHY_PRBS_MASK_SHIFT)
#define  MC_CH0_PHY_PRBS_STAT_MASK_B2_SUBPHY_PRBS_MASK_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_PRBS_STAT_MASK_B2_SUBPHY_PRBS_MASK_MASK) | (((uint32_t)val) << MC_CH0_PHY_PRBS_STAT_MASK_B2_SUBPHY_PRBS_MASK_SHIFT))

//====================================================================
//Register: PHY PRBS Status and Mask Register (CH0_PHY_PRBS_Stat_Mask_B3)
//====================================================================

#define  MC_CH0_PHY_PRBS_STAT_MASK_B3_SUBPHY_PRBS_ERROR_STAT_MASK 0xffff0000
#define  MC_CH0_PHY_PRBS_STAT_MASK_B3_SUBPHY_PRBS_ERROR_STAT_SHIFT 16
#define  MC_CH0_PHY_PRBS_STAT_MASK_B3_SUBPHY_PRBS_ERROR_STAT_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_PRBS_STAT_MASK_B3_SUBPHY_PRBS_ERROR_STAT_MASK) >> MC_CH0_PHY_PRBS_STAT_MASK_B3_SUBPHY_PRBS_ERROR_STAT_SHIFT)
#define  MC_CH0_PHY_PRBS_STAT_MASK_B3_SUBPHY_PRBS_ERROR_STAT_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_PRBS_STAT_MASK_B3_SUBPHY_PRBS_ERROR_STAT_MASK) | (((uint32_t)val) << MC_CH0_PHY_PRBS_STAT_MASK_B3_SUBPHY_PRBS_ERROR_STAT_SHIFT))

#define  MC_CH0_PHY_PRBS_STAT_MASK_B3_SUBPHY_PRBS_MASK_MASK 0xffff
#define  MC_CH0_PHY_PRBS_STAT_MASK_B3_SUBPHY_PRBS_MASK_SHIFT 0
#define  MC_CH0_PHY_PRBS_STAT_MASK_B3_SUBPHY_PRBS_MASK_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_PRBS_STAT_MASK_B3_SUBPHY_PRBS_MASK_MASK) >> MC_CH0_PHY_PRBS_STAT_MASK_B3_SUBPHY_PRBS_MASK_SHIFT)
#define  MC_CH0_PHY_PRBS_STAT_MASK_B3_SUBPHY_PRBS_MASK_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_PRBS_STAT_MASK_B3_SUBPHY_PRBS_MASK_MASK) | (((uint32_t)val) << MC_CH0_PHY_PRBS_STAT_MASK_B3_SUBPHY_PRBS_MASK_SHIFT))

//====================================================================
//Register: PHY PRBS Status and Mask Register (CH0_PHY_PRBS_Stat_Mask_C0)
//====================================================================

#define  MC_CH0_PHY_PRBS_STAT_MASK_C0_SUBPHY_PRBS_ERROR_STAT_MASK 0xffff0000
#define  MC_CH0_PHY_PRBS_STAT_MASK_C0_SUBPHY_PRBS_ERROR_STAT_SHIFT 16
#define  MC_CH0_PHY_PRBS_STAT_MASK_C0_SUBPHY_PRBS_ERROR_STAT_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_PRBS_STAT_MASK_C0_SUBPHY_PRBS_ERROR_STAT_MASK) >> MC_CH0_PHY_PRBS_STAT_MASK_C0_SUBPHY_PRBS_ERROR_STAT_SHIFT)
#define  MC_CH0_PHY_PRBS_STAT_MASK_C0_SUBPHY_PRBS_ERROR_STAT_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_PRBS_STAT_MASK_C0_SUBPHY_PRBS_ERROR_STAT_MASK) | (((uint32_t)val) << MC_CH0_PHY_PRBS_STAT_MASK_C0_SUBPHY_PRBS_ERROR_STAT_SHIFT))

#define  MC_CH0_PHY_PRBS_STAT_MASK_C0_SUBPHY_PRBS_MASK_MASK 0xffff
#define  MC_CH0_PHY_PRBS_STAT_MASK_C0_SUBPHY_PRBS_MASK_SHIFT 0
#define  MC_CH0_PHY_PRBS_STAT_MASK_C0_SUBPHY_PRBS_MASK_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_PRBS_STAT_MASK_C0_SUBPHY_PRBS_MASK_MASK) >> MC_CH0_PHY_PRBS_STAT_MASK_C0_SUBPHY_PRBS_MASK_SHIFT)
#define  MC_CH0_PHY_PRBS_STAT_MASK_C0_SUBPHY_PRBS_MASK_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_PRBS_STAT_MASK_C0_SUBPHY_PRBS_MASK_MASK) | (((uint32_t)val) << MC_CH0_PHY_PRBS_STAT_MASK_C0_SUBPHY_PRBS_MASK_SHIFT))

//====================================================================
//Register: PHY PRBS Status and Mask Register (CH0_PHY_PRBS_Stat_Mask_C1)
//====================================================================

#define  MC_CH0_PHY_PRBS_STAT_MASK_C1_SUBPHY_PRBS_ERROR_STAT_MASK 0xffff0000
#define  MC_CH0_PHY_PRBS_STAT_MASK_C1_SUBPHY_PRBS_ERROR_STAT_SHIFT 16
#define  MC_CH0_PHY_PRBS_STAT_MASK_C1_SUBPHY_PRBS_ERROR_STAT_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_PRBS_STAT_MASK_C1_SUBPHY_PRBS_ERROR_STAT_MASK) >> MC_CH0_PHY_PRBS_STAT_MASK_C1_SUBPHY_PRBS_ERROR_STAT_SHIFT)
#define  MC_CH0_PHY_PRBS_STAT_MASK_C1_SUBPHY_PRBS_ERROR_STAT_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_PRBS_STAT_MASK_C1_SUBPHY_PRBS_ERROR_STAT_MASK) | (((uint32_t)val) << MC_CH0_PHY_PRBS_STAT_MASK_C1_SUBPHY_PRBS_ERROR_STAT_SHIFT))

#define  MC_CH0_PHY_PRBS_STAT_MASK_C1_SUBPHY_PRBS_MASK_MASK 0xffff
#define  MC_CH0_PHY_PRBS_STAT_MASK_C1_SUBPHY_PRBS_MASK_SHIFT 0
#define  MC_CH0_PHY_PRBS_STAT_MASK_C1_SUBPHY_PRBS_MASK_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_PRBS_STAT_MASK_C1_SUBPHY_PRBS_MASK_MASK) >> MC_CH0_PHY_PRBS_STAT_MASK_C1_SUBPHY_PRBS_MASK_SHIFT)
#define  MC_CH0_PHY_PRBS_STAT_MASK_C1_SUBPHY_PRBS_MASK_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_PRBS_STAT_MASK_C1_SUBPHY_PRBS_MASK_MASK) | (((uint32_t)val) << MC_CH0_PHY_PRBS_STAT_MASK_C1_SUBPHY_PRBS_MASK_SHIFT))

//====================================================================
//Register: PHY PRBS Status and Mask Register (CH0_PHY_PRBS_Stat_Mask_C2)
//====================================================================

#define  MC_CH0_PHY_PRBS_STAT_MASK_C2_SUBPHY_PRBS_ERROR_STAT_MASK 0xffff0000
#define  MC_CH0_PHY_PRBS_STAT_MASK_C2_SUBPHY_PRBS_ERROR_STAT_SHIFT 16
#define  MC_CH0_PHY_PRBS_STAT_MASK_C2_SUBPHY_PRBS_ERROR_STAT_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_PRBS_STAT_MASK_C2_SUBPHY_PRBS_ERROR_STAT_MASK) >> MC_CH0_PHY_PRBS_STAT_MASK_C2_SUBPHY_PRBS_ERROR_STAT_SHIFT)
#define  MC_CH0_PHY_PRBS_STAT_MASK_C2_SUBPHY_PRBS_ERROR_STAT_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_PRBS_STAT_MASK_C2_SUBPHY_PRBS_ERROR_STAT_MASK) | (((uint32_t)val) << MC_CH0_PHY_PRBS_STAT_MASK_C2_SUBPHY_PRBS_ERROR_STAT_SHIFT))

#define  MC_CH0_PHY_PRBS_STAT_MASK_C2_SUBPHY_PRBS_MASK_MASK 0xffff
#define  MC_CH0_PHY_PRBS_STAT_MASK_C2_SUBPHY_PRBS_MASK_SHIFT 0
#define  MC_CH0_PHY_PRBS_STAT_MASK_C2_SUBPHY_PRBS_MASK_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_PRBS_STAT_MASK_C2_SUBPHY_PRBS_MASK_MASK) >> MC_CH0_PHY_PRBS_STAT_MASK_C2_SUBPHY_PRBS_MASK_SHIFT)
#define  MC_CH0_PHY_PRBS_STAT_MASK_C2_SUBPHY_PRBS_MASK_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_PRBS_STAT_MASK_C2_SUBPHY_PRBS_MASK_MASK) | (((uint32_t)val) << MC_CH0_PHY_PRBS_STAT_MASK_C2_SUBPHY_PRBS_MASK_SHIFT))

//====================================================================
//Register: PHY PRBS Status and Mask Register (CH0_PHY_PRBS_Stat_Mask_C3)
//====================================================================

#define  MC_CH0_PHY_PRBS_STAT_MASK_C3_SUBPHY_PRBS_ERROR_STAT_MASK 0xffff0000
#define  MC_CH0_PHY_PRBS_STAT_MASK_C3_SUBPHY_PRBS_ERROR_STAT_SHIFT 16
#define  MC_CH0_PHY_PRBS_STAT_MASK_C3_SUBPHY_PRBS_ERROR_STAT_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_PRBS_STAT_MASK_C3_SUBPHY_PRBS_ERROR_STAT_MASK) >> MC_CH0_PHY_PRBS_STAT_MASK_C3_SUBPHY_PRBS_ERROR_STAT_SHIFT)
#define  MC_CH0_PHY_PRBS_STAT_MASK_C3_SUBPHY_PRBS_ERROR_STAT_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_PRBS_STAT_MASK_C3_SUBPHY_PRBS_ERROR_STAT_MASK) | (((uint32_t)val) << MC_CH0_PHY_PRBS_STAT_MASK_C3_SUBPHY_PRBS_ERROR_STAT_SHIFT))

#define  MC_CH0_PHY_PRBS_STAT_MASK_C3_SUBPHY_PRBS_MASK_MASK 0xffff
#define  MC_CH0_PHY_PRBS_STAT_MASK_C3_SUBPHY_PRBS_MASK_SHIFT 0
#define  MC_CH0_PHY_PRBS_STAT_MASK_C3_SUBPHY_PRBS_MASK_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_PRBS_STAT_MASK_C3_SUBPHY_PRBS_MASK_MASK) >> MC_CH0_PHY_PRBS_STAT_MASK_C3_SUBPHY_PRBS_MASK_SHIFT)
#define  MC_CH0_PHY_PRBS_STAT_MASK_C3_SUBPHY_PRBS_MASK_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_PRBS_STAT_MASK_C3_SUBPHY_PRBS_MASK_MASK) | (((uint32_t)val) << MC_CH0_PHY_PRBS_STAT_MASK_C3_SUBPHY_PRBS_MASK_SHIFT))

//====================================================================
//Register: PHY PRBS Status and Mask Register (CH0_PHY_PRBS_Stat_Mask_C4)
//====================================================================

#define  MC_CH0_PHY_PRBS_STAT_MASK_C4_SUBPHY_PRBS_ERROR_STAT_MASK 0xffff0000
#define  MC_CH0_PHY_PRBS_STAT_MASK_C4_SUBPHY_PRBS_ERROR_STAT_SHIFT 16
#define  MC_CH0_PHY_PRBS_STAT_MASK_C4_SUBPHY_PRBS_ERROR_STAT_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_PRBS_STAT_MASK_C4_SUBPHY_PRBS_ERROR_STAT_MASK) >> MC_CH0_PHY_PRBS_STAT_MASK_C4_SUBPHY_PRBS_ERROR_STAT_SHIFT)
#define  MC_CH0_PHY_PRBS_STAT_MASK_C4_SUBPHY_PRBS_ERROR_STAT_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_PRBS_STAT_MASK_C4_SUBPHY_PRBS_ERROR_STAT_MASK) | (((uint32_t)val) << MC_CH0_PHY_PRBS_STAT_MASK_C4_SUBPHY_PRBS_ERROR_STAT_SHIFT))

#define  MC_CH0_PHY_PRBS_STAT_MASK_C4_SUBPHY_PRBS_MASK_MASK 0xffff
#define  MC_CH0_PHY_PRBS_STAT_MASK_C4_SUBPHY_PRBS_MASK_SHIFT 0
#define  MC_CH0_PHY_PRBS_STAT_MASK_C4_SUBPHY_PRBS_MASK_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_PRBS_STAT_MASK_C4_SUBPHY_PRBS_MASK_MASK) >> MC_CH0_PHY_PRBS_STAT_MASK_C4_SUBPHY_PRBS_MASK_SHIFT)
#define  MC_CH0_PHY_PRBS_STAT_MASK_C4_SUBPHY_PRBS_MASK_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_PRBS_STAT_MASK_C4_SUBPHY_PRBS_MASK_MASK) | (((uint32_t)val) << MC_CH0_PHY_PRBS_STAT_MASK_C4_SUBPHY_PRBS_MASK_SHIFT))

//====================================================================
//Register: PHY PRBS Subphy Status Register (CH0_PHY_PRBS_Subphy_Stat)
//====================================================================

#define  MC_CH0_PHY_PRBS_SUBPHY_STAT_RESERVED1_MASK 0xc0000000
#define  MC_CH0_PHY_PRBS_SUBPHY_STAT_RESERVED1_SHIFT 30
#define  MC_CH0_PHY_PRBS_SUBPHY_STAT_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_PRBS_SUBPHY_STAT_RESERVED1_MASK) >> MC_CH0_PHY_PRBS_SUBPHY_STAT_RESERVED1_SHIFT)
#define  MC_CH0_PHY_PRBS_SUBPHY_STAT_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_PRBS_SUBPHY_STAT_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_PHY_PRBS_SUBPHY_STAT_RESERVED1_SHIFT))

#define  MC_CH0_PHY_PRBS_SUBPHY_STAT_CMD_SUBPHY_NEG_ERROR_MASK 0x3e000000
#define  MC_CH0_PHY_PRBS_SUBPHY_STAT_CMD_SUBPHY_NEG_ERROR_SHIFT 25
#define  MC_CH0_PHY_PRBS_SUBPHY_STAT_CMD_SUBPHY_NEG_ERROR_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_PRBS_SUBPHY_STAT_CMD_SUBPHY_NEG_ERROR_MASK) >> MC_CH0_PHY_PRBS_SUBPHY_STAT_CMD_SUBPHY_NEG_ERROR_SHIFT)
#define  MC_CH0_PHY_PRBS_SUBPHY_STAT_CMD_SUBPHY_NEG_ERROR_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_PRBS_SUBPHY_STAT_CMD_SUBPHY_NEG_ERROR_MASK) | (((uint32_t)val) << MC_CH0_PHY_PRBS_SUBPHY_STAT_CMD_SUBPHY_NEG_ERROR_SHIFT))

#define  MC_CH0_PHY_PRBS_SUBPHY_STAT_DATA_SUBPHY_NEG_ERROR_MASK 0x1ff0000
#define  MC_CH0_PHY_PRBS_SUBPHY_STAT_DATA_SUBPHY_NEG_ERROR_SHIFT 16
#define  MC_CH0_PHY_PRBS_SUBPHY_STAT_DATA_SUBPHY_NEG_ERROR_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_PRBS_SUBPHY_STAT_DATA_SUBPHY_NEG_ERROR_MASK) >> MC_CH0_PHY_PRBS_SUBPHY_STAT_DATA_SUBPHY_NEG_ERROR_SHIFT)
#define  MC_CH0_PHY_PRBS_SUBPHY_STAT_DATA_SUBPHY_NEG_ERROR_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_PRBS_SUBPHY_STAT_DATA_SUBPHY_NEG_ERROR_MASK) | (((uint32_t)val) << MC_CH0_PHY_PRBS_SUBPHY_STAT_DATA_SUBPHY_NEG_ERROR_SHIFT))

#define  MC_CH0_PHY_PRBS_SUBPHY_STAT_RESERVED2_MASK 0xc000
#define  MC_CH0_PHY_PRBS_SUBPHY_STAT_RESERVED2_SHIFT 14
#define  MC_CH0_PHY_PRBS_SUBPHY_STAT_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_PRBS_SUBPHY_STAT_RESERVED2_MASK) >> MC_CH0_PHY_PRBS_SUBPHY_STAT_RESERVED2_SHIFT)
#define  MC_CH0_PHY_PRBS_SUBPHY_STAT_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_PRBS_SUBPHY_STAT_RESERVED2_MASK) | (((uint32_t)val) << MC_CH0_PHY_PRBS_SUBPHY_STAT_RESERVED2_SHIFT))

#define  MC_CH0_PHY_PRBS_SUBPHY_STAT_CMD_SUBPHY_POS_ERROR_MASK 0x3e00
#define  MC_CH0_PHY_PRBS_SUBPHY_STAT_CMD_SUBPHY_POS_ERROR_SHIFT 9
#define  MC_CH0_PHY_PRBS_SUBPHY_STAT_CMD_SUBPHY_POS_ERROR_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_PRBS_SUBPHY_STAT_CMD_SUBPHY_POS_ERROR_MASK) >> MC_CH0_PHY_PRBS_SUBPHY_STAT_CMD_SUBPHY_POS_ERROR_SHIFT)
#define  MC_CH0_PHY_PRBS_SUBPHY_STAT_CMD_SUBPHY_POS_ERROR_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_PRBS_SUBPHY_STAT_CMD_SUBPHY_POS_ERROR_MASK) | (((uint32_t)val) << MC_CH0_PHY_PRBS_SUBPHY_STAT_CMD_SUBPHY_POS_ERROR_SHIFT))

#define  MC_CH0_PHY_PRBS_SUBPHY_STAT_DATA_SUBPHY_POS_ERROR_MASK 0x1ff
#define  MC_CH0_PHY_PRBS_SUBPHY_STAT_DATA_SUBPHY_POS_ERROR_SHIFT 0
#define  MC_CH0_PHY_PRBS_SUBPHY_STAT_DATA_SUBPHY_POS_ERROR_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_PRBS_SUBPHY_STAT_DATA_SUBPHY_POS_ERROR_MASK) >> MC_CH0_PHY_PRBS_SUBPHY_STAT_DATA_SUBPHY_POS_ERROR_SHIFT)
#define  MC_CH0_PHY_PRBS_SUBPHY_STAT_DATA_SUBPHY_POS_ERROR_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_PRBS_SUBPHY_STAT_DATA_SUBPHY_POS_ERROR_MASK) | (((uint32_t)val) << MC_CH0_PHY_PRBS_SUBPHY_STAT_DATA_SUBPHY_POS_ERROR_SHIFT))

//====================================================================
//Register: PHY PRBS User Pattern Register (CH0_PHY_PRBS_User_Pattern)
//====================================================================

#define  MC_CH0_PHY_PRBS_USER_PATTERN_PRBS_USER_PATTERN_MASK 0xffffffff
#define  MC_CH0_PHY_PRBS_USER_PATTERN_PRBS_USER_PATTERN_SHIFT 0
#define  MC_CH0_PHY_PRBS_USER_PATTERN_PRBS_USER_PATTERN_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_PRBS_USER_PATTERN_PRBS_USER_PATTERN_MASK) >> MC_CH0_PHY_PRBS_USER_PATTERN_PRBS_USER_PATTERN_SHIFT)
#define  MC_CH0_PHY_PRBS_USER_PATTERN_PRBS_USER_PATTERN_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_PRBS_USER_PATTERN_PRBS_USER_PATTERN_MASK) | (((uint32_t)val) << MC_CH0_PHY_PRBS_USER_PATTERN_PRBS_USER_PATTERN_SHIFT))

//====================================================================
//Register: PHY PRBS Control0 Register (CH0_PHY_PRBS_Control0)
//====================================================================

#define  MC_CH0_PHY_PRBS_CONTROL0_RESERVED1_MASK 0xfff80000
#define  MC_CH0_PHY_PRBS_CONTROL0_RESERVED1_SHIFT 19
#define  MC_CH0_PHY_PRBS_CONTROL0_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_PRBS_CONTROL0_RESERVED1_MASK) >> MC_CH0_PHY_PRBS_CONTROL0_RESERVED1_SHIFT)
#define  MC_CH0_PHY_PRBS_CONTROL0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_PRBS_CONTROL0_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_PHY_PRBS_CONTROL0_RESERVED1_SHIFT))

#define  MC_CH0_PHY_PRBS_CONTROL0_PRBS_CK_DEBUG_MODE_MASK 0x40000
#define  MC_CH0_PHY_PRBS_CONTROL0_PRBS_CK_DEBUG_MODE_SHIFT 18
#define  MC_CH0_PHY_PRBS_CONTROL0_PRBS_CK_DEBUG_MODE_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_PRBS_CONTROL0_PRBS_CK_DEBUG_MODE_MASK) >> MC_CH0_PHY_PRBS_CONTROL0_PRBS_CK_DEBUG_MODE_SHIFT)
#define  MC_CH0_PHY_PRBS_CONTROL0_PRBS_CK_DEBUG_MODE_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_PRBS_CONTROL0_PRBS_CK_DEBUG_MODE_MASK) | (((uint32_t)val) << MC_CH0_PHY_PRBS_CONTROL0_PRBS_CK_DEBUG_MODE_SHIFT))

#define  MC_CH0_PHY_PRBS_CONTROL0_PRBS_USER_MODE_MASK 0x20000
#define  MC_CH0_PHY_PRBS_CONTROL0_PRBS_USER_MODE_SHIFT 17
#define  MC_CH0_PHY_PRBS_CONTROL0_PRBS_USER_MODE_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_PRBS_CONTROL0_PRBS_USER_MODE_MASK) >> MC_CH0_PHY_PRBS_CONTROL0_PRBS_USER_MODE_SHIFT)
#define  MC_CH0_PHY_PRBS_CONTROL0_PRBS_USER_MODE_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_PRBS_CONTROL0_PRBS_USER_MODE_MASK) | (((uint32_t)val) << MC_CH0_PHY_PRBS_CONTROL0_PRBS_USER_MODE_SHIFT))

#define  MC_CH0_PHY_PRBS_CONTROL0_PRBS_START_MASK 0x10000
#define  MC_CH0_PHY_PRBS_CONTROL0_PRBS_START_SHIFT 16
#define  MC_CH0_PHY_PRBS_CONTROL0_PRBS_START_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_PRBS_CONTROL0_PRBS_START_MASK) >> MC_CH0_PHY_PRBS_CONTROL0_PRBS_START_SHIFT)
#define  MC_CH0_PHY_PRBS_CONTROL0_PRBS_START_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_PRBS_CONTROL0_PRBS_START_MASK) | (((uint32_t)val) << MC_CH0_PHY_PRBS_CONTROL0_PRBS_START_SHIFT))

#define  MC_CH0_PHY_PRBS_CONTROL0_RESERVED2_MASK 0xc000
#define  MC_CH0_PHY_PRBS_CONTROL0_RESERVED2_SHIFT 14
#define  MC_CH0_PHY_PRBS_CONTROL0_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_PRBS_CONTROL0_RESERVED2_MASK) >> MC_CH0_PHY_PRBS_CONTROL0_RESERVED2_SHIFT)
#define  MC_CH0_PHY_PRBS_CONTROL0_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_PRBS_CONTROL0_RESERVED2_MASK) | (((uint32_t)val) << MC_CH0_PHY_PRBS_CONTROL0_RESERVED2_SHIFT))

#define  MC_CH0_PHY_PRBS_CONTROL0_PRBS_CKP_DEBUG_VALUE_MASK 0x3e00
#define  MC_CH0_PHY_PRBS_CONTROL0_PRBS_CKP_DEBUG_VALUE_SHIFT 9
#define  MC_CH0_PHY_PRBS_CONTROL0_PRBS_CKP_DEBUG_VALUE_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_PRBS_CONTROL0_PRBS_CKP_DEBUG_VALUE_MASK) >> MC_CH0_PHY_PRBS_CONTROL0_PRBS_CKP_DEBUG_VALUE_SHIFT)
#define  MC_CH0_PHY_PRBS_CONTROL0_PRBS_CKP_DEBUG_VALUE_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_PRBS_CONTROL0_PRBS_CKP_DEBUG_VALUE_MASK) | (((uint32_t)val) << MC_CH0_PHY_PRBS_CONTROL0_PRBS_CKP_DEBUG_VALUE_SHIFT))

#define  MC_CH0_PHY_PRBS_CONTROL0_PRBS_QSP_DEBUG_VALUE_MASK 0x1ff
#define  MC_CH0_PHY_PRBS_CONTROL0_PRBS_QSP_DEBUG_VALUE_SHIFT 0
#define  MC_CH0_PHY_PRBS_CONTROL0_PRBS_QSP_DEBUG_VALUE_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_PRBS_CONTROL0_PRBS_QSP_DEBUG_VALUE_MASK) >> MC_CH0_PHY_PRBS_CONTROL0_PRBS_QSP_DEBUG_VALUE_SHIFT)
#define  MC_CH0_PHY_PRBS_CONTROL0_PRBS_QSP_DEBUG_VALUE_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_PRBS_CONTROL0_PRBS_QSP_DEBUG_VALUE_MASK) | (((uint32_t)val) << MC_CH0_PHY_PRBS_CONTROL0_PRBS_QSP_DEBUG_VALUE_SHIFT))

//====================================================================
//Register: PHY PRBS Control1 Register (CH0_PHY_PRBS_Control1)
//====================================================================

#define  MC_CH0_PHY_PRBS_CONTROL1_RESERVED1_MASK 0xc0000000
#define  MC_CH0_PHY_PRBS_CONTROL1_RESERVED1_SHIFT 30
#define  MC_CH0_PHY_PRBS_CONTROL1_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_PRBS_CONTROL1_RESERVED1_MASK) >> MC_CH0_PHY_PRBS_CONTROL1_RESERVED1_SHIFT)
#define  MC_CH0_PHY_PRBS_CONTROL1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_PRBS_CONTROL1_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_PHY_PRBS_CONTROL1_RESERVED1_SHIFT))

#define  MC_CH0_PHY_PRBS_CONTROL1_PRBS_CMD4_DLY_MASK 0x3e000000
#define  MC_CH0_PHY_PRBS_CONTROL1_PRBS_CMD4_DLY_SHIFT 25
#define  MC_CH0_PHY_PRBS_CONTROL1_PRBS_CMD4_DLY_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_PRBS_CONTROL1_PRBS_CMD4_DLY_MASK) >> MC_CH0_PHY_PRBS_CONTROL1_PRBS_CMD4_DLY_SHIFT)
#define  MC_CH0_PHY_PRBS_CONTROL1_PRBS_CMD4_DLY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_PRBS_CONTROL1_PRBS_CMD4_DLY_MASK) | (((uint32_t)val) << MC_CH0_PHY_PRBS_CONTROL1_PRBS_CMD4_DLY_SHIFT))

#define  MC_CH0_PHY_PRBS_CONTROL1_PRBS_CMD3_DLY_MASK 0x1f00000
#define  MC_CH0_PHY_PRBS_CONTROL1_PRBS_CMD3_DLY_SHIFT 20
#define  MC_CH0_PHY_PRBS_CONTROL1_PRBS_CMD3_DLY_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_PRBS_CONTROL1_PRBS_CMD3_DLY_MASK) >> MC_CH0_PHY_PRBS_CONTROL1_PRBS_CMD3_DLY_SHIFT)
#define  MC_CH0_PHY_PRBS_CONTROL1_PRBS_CMD3_DLY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_PRBS_CONTROL1_PRBS_CMD3_DLY_MASK) | (((uint32_t)val) << MC_CH0_PHY_PRBS_CONTROL1_PRBS_CMD3_DLY_SHIFT))

#define  MC_CH0_PHY_PRBS_CONTROL1_PRBS_CMD2_DLY_MASK 0xf8000
#define  MC_CH0_PHY_PRBS_CONTROL1_PRBS_CMD2_DLY_SHIFT 15
#define  MC_CH0_PHY_PRBS_CONTROL1_PRBS_CMD2_DLY_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_PRBS_CONTROL1_PRBS_CMD2_DLY_MASK) >> MC_CH0_PHY_PRBS_CONTROL1_PRBS_CMD2_DLY_SHIFT)
#define  MC_CH0_PHY_PRBS_CONTROL1_PRBS_CMD2_DLY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_PRBS_CONTROL1_PRBS_CMD2_DLY_MASK) | (((uint32_t)val) << MC_CH0_PHY_PRBS_CONTROL1_PRBS_CMD2_DLY_SHIFT))

#define  MC_CH0_PHY_PRBS_CONTROL1_PRBS_CMD1_DLY_MASK 0x7c00
#define  MC_CH0_PHY_PRBS_CONTROL1_PRBS_CMD1_DLY_SHIFT 10
#define  MC_CH0_PHY_PRBS_CONTROL1_PRBS_CMD1_DLY_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_PRBS_CONTROL1_PRBS_CMD1_DLY_MASK) >> MC_CH0_PHY_PRBS_CONTROL1_PRBS_CMD1_DLY_SHIFT)
#define  MC_CH0_PHY_PRBS_CONTROL1_PRBS_CMD1_DLY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_PRBS_CONTROL1_PRBS_CMD1_DLY_MASK) | (((uint32_t)val) << MC_CH0_PHY_PRBS_CONTROL1_PRBS_CMD1_DLY_SHIFT))

#define  MC_CH0_PHY_PRBS_CONTROL1_PRBS_CMD0_DLY_MASK 0x3e0
#define  MC_CH0_PHY_PRBS_CONTROL1_PRBS_CMD0_DLY_SHIFT 5
#define  MC_CH0_PHY_PRBS_CONTROL1_PRBS_CMD0_DLY_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_PRBS_CONTROL1_PRBS_CMD0_DLY_MASK) >> MC_CH0_PHY_PRBS_CONTROL1_PRBS_CMD0_DLY_SHIFT)
#define  MC_CH0_PHY_PRBS_CONTROL1_PRBS_CMD0_DLY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_PRBS_CONTROL1_PRBS_CMD0_DLY_MASK) | (((uint32_t)val) << MC_CH0_PHY_PRBS_CONTROL1_PRBS_CMD0_DLY_SHIFT))

#define  MC_CH0_PHY_PRBS_CONTROL1_PRBS_DATA_DLY_MASK 0x1f
#define  MC_CH0_PHY_PRBS_CONTROL1_PRBS_DATA_DLY_SHIFT 0
#define  MC_CH0_PHY_PRBS_CONTROL1_PRBS_DATA_DLY_MASK_SHIFT(reg) (((reg) & MC_CH0_PHY_PRBS_CONTROL1_PRBS_DATA_DLY_MASK) >> MC_CH0_PHY_PRBS_CONTROL1_PRBS_DATA_DLY_SHIFT)
#define  MC_CH0_PHY_PRBS_CONTROL1_PRBS_DATA_DLY_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_PHY_PRBS_CONTROL1_PRBS_DATA_DLY_MASK) | (((uint32_t)val) << MC_CH0_PHY_PRBS_CONTROL1_PRBS_DATA_DLY_SHIFT))

//====================================================================
//Register: MC Trustzone Range 0 Low Register (TZ_Range0_Low)
//====================================================================

#define  MC_TZ_RANGE0_LOW_TZ_START_ADDR_L_MASK 0xfff00000
#define  MC_TZ_RANGE0_LOW_TZ_START_ADDR_L_SHIFT 20
#define  MC_TZ_RANGE0_LOW_TZ_START_ADDR_L_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE0_LOW_TZ_START_ADDR_L_MASK) >> MC_TZ_RANGE0_LOW_TZ_START_ADDR_L_SHIFT)
#define  MC_TZ_RANGE0_LOW_TZ_START_ADDR_L_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE0_LOW_TZ_START_ADDR_L_MASK) | (((uint32_t)val) << MC_TZ_RANGE0_LOW_TZ_START_ADDR_L_SHIFT))

#define  MC_TZ_RANGE0_LOW_RESERVED1_MASK 0xfe000
#define  MC_TZ_RANGE0_LOW_RESERVED1_SHIFT 13
#define  MC_TZ_RANGE0_LOW_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE0_LOW_RESERVED1_MASK) >> MC_TZ_RANGE0_LOW_RESERVED1_SHIFT)
#define  MC_TZ_RANGE0_LOW_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE0_LOW_RESERVED1_MASK) | (((uint32_t)val) << MC_TZ_RANGE0_LOW_RESERVED1_SHIFT))

#define  MC_TZ_RANGE0_LOW_TZ_AREA_LEN_MASK 0x1f00
#define  MC_TZ_RANGE0_LOW_TZ_AREA_LEN_SHIFT 8
#define  MC_TZ_RANGE0_LOW_TZ_AREA_LEN_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE0_LOW_TZ_AREA_LEN_MASK) >> MC_TZ_RANGE0_LOW_TZ_AREA_LEN_SHIFT)
#define  MC_TZ_RANGE0_LOW_TZ_AREA_LEN_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE0_LOW_TZ_AREA_LEN_MASK) | (((uint32_t)val) << MC_TZ_RANGE0_LOW_TZ_AREA_LEN_SHIFT))

#define  MC_TZ_RANGE0_LOW_RESERVED2_MASK 0x80
#define  MC_TZ_RANGE0_LOW_RESERVED2_SHIFT 7
#define  MC_TZ_RANGE0_LOW_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE0_LOW_RESERVED2_MASK) >> MC_TZ_RANGE0_LOW_RESERVED2_SHIFT)
#define  MC_TZ_RANGE0_LOW_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE0_LOW_RESERVED2_MASK) | (((uint32_t)val) << MC_TZ_RANGE0_LOW_RESERVED2_SHIFT))

#define  MC_TZ_RANGE0_LOW_RZ_ENB_UR_MASK 0x40
#define  MC_TZ_RANGE0_LOW_RZ_ENB_UR_SHIFT 6
#define  MC_TZ_RANGE0_LOW_RZ_ENB_UR_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE0_LOW_RZ_ENB_UR_MASK) >> MC_TZ_RANGE0_LOW_RZ_ENB_UR_SHIFT)
#define  MC_TZ_RANGE0_LOW_RZ_ENB_UR_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE0_LOW_RZ_ENB_UR_MASK) | (((uint32_t)val) << MC_TZ_RANGE0_LOW_RZ_ENB_UR_SHIFT))

#define  MC_TZ_RANGE0_LOW_TZ_PERM_UR_MASK 0x30
#define  MC_TZ_RANGE0_LOW_TZ_PERM_UR_SHIFT 4
#define  MC_TZ_RANGE0_LOW_TZ_PERM_UR_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE0_LOW_TZ_PERM_UR_MASK) >> MC_TZ_RANGE0_LOW_TZ_PERM_UR_SHIFT)
#define  MC_TZ_RANGE0_LOW_TZ_PERM_UR_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE0_LOW_TZ_PERM_UR_MASK) | (((uint32_t)val) << MC_TZ_RANGE0_LOW_TZ_PERM_UR_SHIFT))

#define  MC_TZ_RANGE0_LOW_RZ_ENB_MASK 0x8
#define  MC_TZ_RANGE0_LOW_RZ_ENB_SHIFT 3
#define  MC_TZ_RANGE0_LOW_RZ_ENB_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE0_LOW_RZ_ENB_MASK) >> MC_TZ_RANGE0_LOW_RZ_ENB_SHIFT)
#define  MC_TZ_RANGE0_LOW_RZ_ENB_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE0_LOW_RZ_ENB_MASK) | (((uint32_t)val) << MC_TZ_RANGE0_LOW_RZ_ENB_SHIFT))

#define  MC_TZ_RANGE0_LOW_TZ_PERM_MASK 0x6
#define  MC_TZ_RANGE0_LOW_TZ_PERM_SHIFT 1
#define  MC_TZ_RANGE0_LOW_TZ_PERM_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE0_LOW_TZ_PERM_MASK) >> MC_TZ_RANGE0_LOW_TZ_PERM_SHIFT)
#define  MC_TZ_RANGE0_LOW_TZ_PERM_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE0_LOW_TZ_PERM_MASK) | (((uint32_t)val) << MC_TZ_RANGE0_LOW_TZ_PERM_SHIFT))

#define  MC_TZ_RANGE0_LOW_TZ_VALID_MASK 0x1
#define  MC_TZ_RANGE0_LOW_TZ_VALID_SHIFT 0
#define  MC_TZ_RANGE0_LOW_TZ_VALID_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE0_LOW_TZ_VALID_MASK) >> MC_TZ_RANGE0_LOW_TZ_VALID_SHIFT)
#define  MC_TZ_RANGE0_LOW_TZ_VALID_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE0_LOW_TZ_VALID_MASK) | (((uint32_t)val) << MC_TZ_RANGE0_LOW_TZ_VALID_SHIFT))

//====================================================================
//Register: MC Trustzone Range High Register (TZ_Range0_High)
//====================================================================

#define  MC_TZ_RANGE0_HIGH_RESERVED1_MASK 0xffffff00
#define  MC_TZ_RANGE0_HIGH_RESERVED1_SHIFT 8
#define  MC_TZ_RANGE0_HIGH_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE0_HIGH_RESERVED1_MASK) >> MC_TZ_RANGE0_HIGH_RESERVED1_SHIFT)
#define  MC_TZ_RANGE0_HIGH_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE0_HIGH_RESERVED1_MASK) | (((uint32_t)val) << MC_TZ_RANGE0_HIGH_RESERVED1_SHIFT))

#define  MC_TZ_RANGE0_HIGH_TZ_START_ADDR_H_MASK 0xff
#define  MC_TZ_RANGE0_HIGH_TZ_START_ADDR_H_SHIFT 0
#define  MC_TZ_RANGE0_HIGH_TZ_START_ADDR_H_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE0_HIGH_TZ_START_ADDR_H_MASK) >> MC_TZ_RANGE0_HIGH_TZ_START_ADDR_H_SHIFT)
#define  MC_TZ_RANGE0_HIGH_TZ_START_ADDR_H_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE0_HIGH_TZ_START_ADDR_H_MASK) | (((uint32_t)val) << MC_TZ_RANGE0_HIGH_TZ_START_ADDR_H_SHIFT))

//====================================================================
//Register: MC Trustzone Range High Register (TZ_Range1_High)
//====================================================================

#define  MC_TZ_RANGE1_HIGH_RESERVED1_MASK 0xffffff00
#define  MC_TZ_RANGE1_HIGH_RESERVED1_SHIFT 8
#define  MC_TZ_RANGE1_HIGH_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE1_HIGH_RESERVED1_MASK) >> MC_TZ_RANGE1_HIGH_RESERVED1_SHIFT)
#define  MC_TZ_RANGE1_HIGH_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE1_HIGH_RESERVED1_MASK) | (((uint32_t)val) << MC_TZ_RANGE1_HIGH_RESERVED1_SHIFT))

#define  MC_TZ_RANGE1_HIGH_TZ_START_ADDR_H_MASK 0xff
#define  MC_TZ_RANGE1_HIGH_TZ_START_ADDR_H_SHIFT 0
#define  MC_TZ_RANGE1_HIGH_TZ_START_ADDR_H_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE1_HIGH_TZ_START_ADDR_H_MASK) >> MC_TZ_RANGE1_HIGH_TZ_START_ADDR_H_SHIFT)
#define  MC_TZ_RANGE1_HIGH_TZ_START_ADDR_H_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE1_HIGH_TZ_START_ADDR_H_MASK) | (((uint32_t)val) << MC_TZ_RANGE1_HIGH_TZ_START_ADDR_H_SHIFT))

//====================================================================
//Register: MC Trustzone Range High Register (TZ_Range2_High)
//====================================================================

#define  MC_TZ_RANGE2_HIGH_RESERVED1_MASK 0xffffff00
#define  MC_TZ_RANGE2_HIGH_RESERVED1_SHIFT 8
#define  MC_TZ_RANGE2_HIGH_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE2_HIGH_RESERVED1_MASK) >> MC_TZ_RANGE2_HIGH_RESERVED1_SHIFT)
#define  MC_TZ_RANGE2_HIGH_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE2_HIGH_RESERVED1_MASK) | (((uint32_t)val) << MC_TZ_RANGE2_HIGH_RESERVED1_SHIFT))

#define  MC_TZ_RANGE2_HIGH_TZ_START_ADDR_H_MASK 0xff
#define  MC_TZ_RANGE2_HIGH_TZ_START_ADDR_H_SHIFT 0
#define  MC_TZ_RANGE2_HIGH_TZ_START_ADDR_H_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE2_HIGH_TZ_START_ADDR_H_MASK) >> MC_TZ_RANGE2_HIGH_TZ_START_ADDR_H_SHIFT)
#define  MC_TZ_RANGE2_HIGH_TZ_START_ADDR_H_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE2_HIGH_TZ_START_ADDR_H_MASK) | (((uint32_t)val) << MC_TZ_RANGE2_HIGH_TZ_START_ADDR_H_SHIFT))

//====================================================================
//Register: MC Trustzone Range High Register (TZ_Range3_High)
//====================================================================

#define  MC_TZ_RANGE3_HIGH_RESERVED1_MASK 0xffffff00
#define  MC_TZ_RANGE3_HIGH_RESERVED1_SHIFT 8
#define  MC_TZ_RANGE3_HIGH_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE3_HIGH_RESERVED1_MASK) >> MC_TZ_RANGE3_HIGH_RESERVED1_SHIFT)
#define  MC_TZ_RANGE3_HIGH_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE3_HIGH_RESERVED1_MASK) | (((uint32_t)val) << MC_TZ_RANGE3_HIGH_RESERVED1_SHIFT))

#define  MC_TZ_RANGE3_HIGH_TZ_START_ADDR_H_MASK 0xff
#define  MC_TZ_RANGE3_HIGH_TZ_START_ADDR_H_SHIFT 0
#define  MC_TZ_RANGE3_HIGH_TZ_START_ADDR_H_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE3_HIGH_TZ_START_ADDR_H_MASK) >> MC_TZ_RANGE3_HIGH_TZ_START_ADDR_H_SHIFT)
#define  MC_TZ_RANGE3_HIGH_TZ_START_ADDR_H_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE3_HIGH_TZ_START_ADDR_H_MASK) | (((uint32_t)val) << MC_TZ_RANGE3_HIGH_TZ_START_ADDR_H_SHIFT))

//====================================================================
//Register: MC Trustzone Range High Register (TZ_Range4_High)
//====================================================================

#define  MC_TZ_RANGE4_HIGH_RESERVED1_MASK 0xffffff00
#define  MC_TZ_RANGE4_HIGH_RESERVED1_SHIFT 8
#define  MC_TZ_RANGE4_HIGH_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE4_HIGH_RESERVED1_MASK) >> MC_TZ_RANGE4_HIGH_RESERVED1_SHIFT)
#define  MC_TZ_RANGE4_HIGH_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE4_HIGH_RESERVED1_MASK) | (((uint32_t)val) << MC_TZ_RANGE4_HIGH_RESERVED1_SHIFT))

#define  MC_TZ_RANGE4_HIGH_TZ_START_ADDR_H_MASK 0xff
#define  MC_TZ_RANGE4_HIGH_TZ_START_ADDR_H_SHIFT 0
#define  MC_TZ_RANGE4_HIGH_TZ_START_ADDR_H_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE4_HIGH_TZ_START_ADDR_H_MASK) >> MC_TZ_RANGE4_HIGH_TZ_START_ADDR_H_SHIFT)
#define  MC_TZ_RANGE4_HIGH_TZ_START_ADDR_H_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE4_HIGH_TZ_START_ADDR_H_MASK) | (((uint32_t)val) << MC_TZ_RANGE4_HIGH_TZ_START_ADDR_H_SHIFT))

//====================================================================
//Register: MC Trustzone Range High Register (TZ_Range5_High)
//====================================================================

#define  MC_TZ_RANGE5_HIGH_RESERVED1_MASK 0xffffff00
#define  MC_TZ_RANGE5_HIGH_RESERVED1_SHIFT 8
#define  MC_TZ_RANGE5_HIGH_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE5_HIGH_RESERVED1_MASK) >> MC_TZ_RANGE5_HIGH_RESERVED1_SHIFT)
#define  MC_TZ_RANGE5_HIGH_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE5_HIGH_RESERVED1_MASK) | (((uint32_t)val) << MC_TZ_RANGE5_HIGH_RESERVED1_SHIFT))

#define  MC_TZ_RANGE5_HIGH_TZ_START_ADDR_H_MASK 0xff
#define  MC_TZ_RANGE5_HIGH_TZ_START_ADDR_H_SHIFT 0
#define  MC_TZ_RANGE5_HIGH_TZ_START_ADDR_H_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE5_HIGH_TZ_START_ADDR_H_MASK) >> MC_TZ_RANGE5_HIGH_TZ_START_ADDR_H_SHIFT)
#define  MC_TZ_RANGE5_HIGH_TZ_START_ADDR_H_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE5_HIGH_TZ_START_ADDR_H_MASK) | (((uint32_t)val) << MC_TZ_RANGE5_HIGH_TZ_START_ADDR_H_SHIFT))

//====================================================================
//Register: MC Trustzone Range High Register (TZ_Range6_High)
//====================================================================

#define  MC_TZ_RANGE6_HIGH_RESERVED1_MASK 0xffffff00
#define  MC_TZ_RANGE6_HIGH_RESERVED1_SHIFT 8
#define  MC_TZ_RANGE6_HIGH_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE6_HIGH_RESERVED1_MASK) >> MC_TZ_RANGE6_HIGH_RESERVED1_SHIFT)
#define  MC_TZ_RANGE6_HIGH_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE6_HIGH_RESERVED1_MASK) | (((uint32_t)val) << MC_TZ_RANGE6_HIGH_RESERVED1_SHIFT))

#define  MC_TZ_RANGE6_HIGH_TZ_START_ADDR_H_MASK 0xff
#define  MC_TZ_RANGE6_HIGH_TZ_START_ADDR_H_SHIFT 0
#define  MC_TZ_RANGE6_HIGH_TZ_START_ADDR_H_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE6_HIGH_TZ_START_ADDR_H_MASK) >> MC_TZ_RANGE6_HIGH_TZ_START_ADDR_H_SHIFT)
#define  MC_TZ_RANGE6_HIGH_TZ_START_ADDR_H_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE6_HIGH_TZ_START_ADDR_H_MASK) | (((uint32_t)val) << MC_TZ_RANGE6_HIGH_TZ_START_ADDR_H_SHIFT))

//====================================================================
//Register: MC Trustzone Range High Register (TZ_Range7_High)
//====================================================================

#define  MC_TZ_RANGE7_HIGH_RESERVED1_MASK 0xffffff00
#define  MC_TZ_RANGE7_HIGH_RESERVED1_SHIFT 8
#define  MC_TZ_RANGE7_HIGH_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE7_HIGH_RESERVED1_MASK) >> MC_TZ_RANGE7_HIGH_RESERVED1_SHIFT)
#define  MC_TZ_RANGE7_HIGH_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE7_HIGH_RESERVED1_MASK) | (((uint32_t)val) << MC_TZ_RANGE7_HIGH_RESERVED1_SHIFT))

#define  MC_TZ_RANGE7_HIGH_TZ_START_ADDR_H_MASK 0xff
#define  MC_TZ_RANGE7_HIGH_TZ_START_ADDR_H_SHIFT 0
#define  MC_TZ_RANGE7_HIGH_TZ_START_ADDR_H_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE7_HIGH_TZ_START_ADDR_H_MASK) >> MC_TZ_RANGE7_HIGH_TZ_START_ADDR_H_SHIFT)
#define  MC_TZ_RANGE7_HIGH_TZ_START_ADDR_H_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE7_HIGH_TZ_START_ADDR_H_MASK) | (((uint32_t)val) << MC_TZ_RANGE7_HIGH_TZ_START_ADDR_H_SHIFT))

//====================================================================
//Register: MC Trustzone Range High Register (TZ_Range8_High)
//====================================================================

#define  MC_TZ_RANGE8_HIGH_RESERVED1_MASK 0xffffff00
#define  MC_TZ_RANGE8_HIGH_RESERVED1_SHIFT 8
#define  MC_TZ_RANGE8_HIGH_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE8_HIGH_RESERVED1_MASK) >> MC_TZ_RANGE8_HIGH_RESERVED1_SHIFT)
#define  MC_TZ_RANGE8_HIGH_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE8_HIGH_RESERVED1_MASK) | (((uint32_t)val) << MC_TZ_RANGE8_HIGH_RESERVED1_SHIFT))

#define  MC_TZ_RANGE8_HIGH_TZ_START_ADDR_H_MASK 0xff
#define  MC_TZ_RANGE8_HIGH_TZ_START_ADDR_H_SHIFT 0
#define  MC_TZ_RANGE8_HIGH_TZ_START_ADDR_H_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE8_HIGH_TZ_START_ADDR_H_MASK) >> MC_TZ_RANGE8_HIGH_TZ_START_ADDR_H_SHIFT)
#define  MC_TZ_RANGE8_HIGH_TZ_START_ADDR_H_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE8_HIGH_TZ_START_ADDR_H_MASK) | (((uint32_t)val) << MC_TZ_RANGE8_HIGH_TZ_START_ADDR_H_SHIFT))

//====================================================================
//Register: MC Trustzone Range High Register (TZ_Range9_High)
//====================================================================

#define  MC_TZ_RANGE9_HIGH_RESERVED1_MASK 0xffffff00
#define  MC_TZ_RANGE9_HIGH_RESERVED1_SHIFT 8
#define  MC_TZ_RANGE9_HIGH_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE9_HIGH_RESERVED1_MASK) >> MC_TZ_RANGE9_HIGH_RESERVED1_SHIFT)
#define  MC_TZ_RANGE9_HIGH_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE9_HIGH_RESERVED1_MASK) | (((uint32_t)val) << MC_TZ_RANGE9_HIGH_RESERVED1_SHIFT))

#define  MC_TZ_RANGE9_HIGH_TZ_START_ADDR_H_MASK 0xff
#define  MC_TZ_RANGE9_HIGH_TZ_START_ADDR_H_SHIFT 0
#define  MC_TZ_RANGE9_HIGH_TZ_START_ADDR_H_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE9_HIGH_TZ_START_ADDR_H_MASK) >> MC_TZ_RANGE9_HIGH_TZ_START_ADDR_H_SHIFT)
#define  MC_TZ_RANGE9_HIGH_TZ_START_ADDR_H_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE9_HIGH_TZ_START_ADDR_H_MASK) | (((uint32_t)val) << MC_TZ_RANGE9_HIGH_TZ_START_ADDR_H_SHIFT))

//====================================================================
//Register: MC Trustzone Range High Register (TZ_Range10_High)
//====================================================================

#define  MC_TZ_RANGE10_HIGH_RESERVED1_MASK 0xffffff00
#define  MC_TZ_RANGE10_HIGH_RESERVED1_SHIFT 8
#define  MC_TZ_RANGE10_HIGH_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE10_HIGH_RESERVED1_MASK) >> MC_TZ_RANGE10_HIGH_RESERVED1_SHIFT)
#define  MC_TZ_RANGE10_HIGH_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE10_HIGH_RESERVED1_MASK) | (((uint32_t)val) << MC_TZ_RANGE10_HIGH_RESERVED1_SHIFT))

#define  MC_TZ_RANGE10_HIGH_TZ_START_ADDR_H_MASK 0xff
#define  MC_TZ_RANGE10_HIGH_TZ_START_ADDR_H_SHIFT 0
#define  MC_TZ_RANGE10_HIGH_TZ_START_ADDR_H_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE10_HIGH_TZ_START_ADDR_H_MASK) >> MC_TZ_RANGE10_HIGH_TZ_START_ADDR_H_SHIFT)
#define  MC_TZ_RANGE10_HIGH_TZ_START_ADDR_H_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE10_HIGH_TZ_START_ADDR_H_MASK) | (((uint32_t)val) << MC_TZ_RANGE10_HIGH_TZ_START_ADDR_H_SHIFT))

//====================================================================
//Register: MC Trustzone Range High Register (TZ_Range11_High)
//====================================================================

#define  MC_TZ_RANGE11_HIGH_RESERVED1_MASK 0xffffff00
#define  MC_TZ_RANGE11_HIGH_RESERVED1_SHIFT 8
#define  MC_TZ_RANGE11_HIGH_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE11_HIGH_RESERVED1_MASK) >> MC_TZ_RANGE11_HIGH_RESERVED1_SHIFT)
#define  MC_TZ_RANGE11_HIGH_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE11_HIGH_RESERVED1_MASK) | (((uint32_t)val) << MC_TZ_RANGE11_HIGH_RESERVED1_SHIFT))

#define  MC_TZ_RANGE11_HIGH_TZ_START_ADDR_H_MASK 0xff
#define  MC_TZ_RANGE11_HIGH_TZ_START_ADDR_H_SHIFT 0
#define  MC_TZ_RANGE11_HIGH_TZ_START_ADDR_H_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE11_HIGH_TZ_START_ADDR_H_MASK) >> MC_TZ_RANGE11_HIGH_TZ_START_ADDR_H_SHIFT)
#define  MC_TZ_RANGE11_HIGH_TZ_START_ADDR_H_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE11_HIGH_TZ_START_ADDR_H_MASK) | (((uint32_t)val) << MC_TZ_RANGE11_HIGH_TZ_START_ADDR_H_SHIFT))

//====================================================================
//Register: MC Trustzone Range High Register (TZ_Range12_High)
//====================================================================

#define  MC_TZ_RANGE12_HIGH_RESERVED1_MASK 0xffffff00
#define  MC_TZ_RANGE12_HIGH_RESERVED1_SHIFT 8
#define  MC_TZ_RANGE12_HIGH_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE12_HIGH_RESERVED1_MASK) >> MC_TZ_RANGE12_HIGH_RESERVED1_SHIFT)
#define  MC_TZ_RANGE12_HIGH_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE12_HIGH_RESERVED1_MASK) | (((uint32_t)val) << MC_TZ_RANGE12_HIGH_RESERVED1_SHIFT))

#define  MC_TZ_RANGE12_HIGH_TZ_START_ADDR_H_MASK 0xff
#define  MC_TZ_RANGE12_HIGH_TZ_START_ADDR_H_SHIFT 0
#define  MC_TZ_RANGE12_HIGH_TZ_START_ADDR_H_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE12_HIGH_TZ_START_ADDR_H_MASK) >> MC_TZ_RANGE12_HIGH_TZ_START_ADDR_H_SHIFT)
#define  MC_TZ_RANGE12_HIGH_TZ_START_ADDR_H_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE12_HIGH_TZ_START_ADDR_H_MASK) | (((uint32_t)val) << MC_TZ_RANGE12_HIGH_TZ_START_ADDR_H_SHIFT))

//====================================================================
//Register: MC Trustzone Range High Register (TZ_Range13_High)
//====================================================================

#define  MC_TZ_RANGE13_HIGH_RESERVED1_MASK 0xffffff00
#define  MC_TZ_RANGE13_HIGH_RESERVED1_SHIFT 8
#define  MC_TZ_RANGE13_HIGH_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE13_HIGH_RESERVED1_MASK) >> MC_TZ_RANGE13_HIGH_RESERVED1_SHIFT)
#define  MC_TZ_RANGE13_HIGH_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE13_HIGH_RESERVED1_MASK) | (((uint32_t)val) << MC_TZ_RANGE13_HIGH_RESERVED1_SHIFT))

#define  MC_TZ_RANGE13_HIGH_TZ_START_ADDR_H_MASK 0xff
#define  MC_TZ_RANGE13_HIGH_TZ_START_ADDR_H_SHIFT 0
#define  MC_TZ_RANGE13_HIGH_TZ_START_ADDR_H_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE13_HIGH_TZ_START_ADDR_H_MASK) >> MC_TZ_RANGE13_HIGH_TZ_START_ADDR_H_SHIFT)
#define  MC_TZ_RANGE13_HIGH_TZ_START_ADDR_H_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE13_HIGH_TZ_START_ADDR_H_MASK) | (((uint32_t)val) << MC_TZ_RANGE13_HIGH_TZ_START_ADDR_H_SHIFT))

//====================================================================
//Register: MC Trustzone Range High Register (TZ_Range14_High)
//====================================================================

#define  MC_TZ_RANGE14_HIGH_RESERVED1_MASK 0xffffff00
#define  MC_TZ_RANGE14_HIGH_RESERVED1_SHIFT 8
#define  MC_TZ_RANGE14_HIGH_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE14_HIGH_RESERVED1_MASK) >> MC_TZ_RANGE14_HIGH_RESERVED1_SHIFT)
#define  MC_TZ_RANGE14_HIGH_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE14_HIGH_RESERVED1_MASK) | (((uint32_t)val) << MC_TZ_RANGE14_HIGH_RESERVED1_SHIFT))

#define  MC_TZ_RANGE14_HIGH_TZ_START_ADDR_H_MASK 0xff
#define  MC_TZ_RANGE14_HIGH_TZ_START_ADDR_H_SHIFT 0
#define  MC_TZ_RANGE14_HIGH_TZ_START_ADDR_H_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE14_HIGH_TZ_START_ADDR_H_MASK) >> MC_TZ_RANGE14_HIGH_TZ_START_ADDR_H_SHIFT)
#define  MC_TZ_RANGE14_HIGH_TZ_START_ADDR_H_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE14_HIGH_TZ_START_ADDR_H_MASK) | (((uint32_t)val) << MC_TZ_RANGE14_HIGH_TZ_START_ADDR_H_SHIFT))

//====================================================================
//Register: MC Trustzone Range High Register (TZ_Range15_High)
//====================================================================

#define  MC_TZ_RANGE15_HIGH_RESERVED1_MASK 0xffffff00
#define  MC_TZ_RANGE15_HIGH_RESERVED1_SHIFT 8
#define  MC_TZ_RANGE15_HIGH_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE15_HIGH_RESERVED1_MASK) >> MC_TZ_RANGE15_HIGH_RESERVED1_SHIFT)
#define  MC_TZ_RANGE15_HIGH_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE15_HIGH_RESERVED1_MASK) | (((uint32_t)val) << MC_TZ_RANGE15_HIGH_RESERVED1_SHIFT))

#define  MC_TZ_RANGE15_HIGH_TZ_START_ADDR_H_MASK 0xff
#define  MC_TZ_RANGE15_HIGH_TZ_START_ADDR_H_SHIFT 0
#define  MC_TZ_RANGE15_HIGH_TZ_START_ADDR_H_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE15_HIGH_TZ_START_ADDR_H_MASK) >> MC_TZ_RANGE15_HIGH_TZ_START_ADDR_H_SHIFT)
#define  MC_TZ_RANGE15_HIGH_TZ_START_ADDR_H_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE15_HIGH_TZ_START_ADDR_H_MASK) | (((uint32_t)val) << MC_TZ_RANGE15_HIGH_TZ_START_ADDR_H_SHIFT))

//====================================================================
//Register: MC Trustzone Range Low Register (TZ_Range1_Low)
//====================================================================

#define  MC_TZ_RANGE1_LOW_TZ_START_ADDR_L_MASK 0xfff00000
#define  MC_TZ_RANGE1_LOW_TZ_START_ADDR_L_SHIFT 20
#define  MC_TZ_RANGE1_LOW_TZ_START_ADDR_L_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE1_LOW_TZ_START_ADDR_L_MASK) >> MC_TZ_RANGE1_LOW_TZ_START_ADDR_L_SHIFT)
#define  MC_TZ_RANGE1_LOW_TZ_START_ADDR_L_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE1_LOW_TZ_START_ADDR_L_MASK) | (((uint32_t)val) << MC_TZ_RANGE1_LOW_TZ_START_ADDR_L_SHIFT))

#define  MC_TZ_RANGE1_LOW_RESERVED1_MASK 0xfe000
#define  MC_TZ_RANGE1_LOW_RESERVED1_SHIFT 13
#define  MC_TZ_RANGE1_LOW_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE1_LOW_RESERVED1_MASK) >> MC_TZ_RANGE1_LOW_RESERVED1_SHIFT)
#define  MC_TZ_RANGE1_LOW_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE1_LOW_RESERVED1_MASK) | (((uint32_t)val) << MC_TZ_RANGE1_LOW_RESERVED1_SHIFT))

#define  MC_TZ_RANGE1_LOW_TZ_AREA_LEN_MASK 0x1f00
#define  MC_TZ_RANGE1_LOW_TZ_AREA_LEN_SHIFT 8
#define  MC_TZ_RANGE1_LOW_TZ_AREA_LEN_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE1_LOW_TZ_AREA_LEN_MASK) >> MC_TZ_RANGE1_LOW_TZ_AREA_LEN_SHIFT)
#define  MC_TZ_RANGE1_LOW_TZ_AREA_LEN_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE1_LOW_TZ_AREA_LEN_MASK) | (((uint32_t)val) << MC_TZ_RANGE1_LOW_TZ_AREA_LEN_SHIFT))

#define  MC_TZ_RANGE1_LOW_RESERVED2_MASK 0xf0
#define  MC_TZ_RANGE1_LOW_RESERVED2_SHIFT 4
#define  MC_TZ_RANGE1_LOW_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE1_LOW_RESERVED2_MASK) >> MC_TZ_RANGE1_LOW_RESERVED2_SHIFT)
#define  MC_TZ_RANGE1_LOW_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE1_LOW_RESERVED2_MASK) | (((uint32_t)val) << MC_TZ_RANGE1_LOW_RESERVED2_SHIFT))

#define  MC_TZ_RANGE1_LOW_RZ_ENB_MASK 0x8
#define  MC_TZ_RANGE1_LOW_RZ_ENB_SHIFT 3
#define  MC_TZ_RANGE1_LOW_RZ_ENB_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE1_LOW_RZ_ENB_MASK) >> MC_TZ_RANGE1_LOW_RZ_ENB_SHIFT)
#define  MC_TZ_RANGE1_LOW_RZ_ENB_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE1_LOW_RZ_ENB_MASK) | (((uint32_t)val) << MC_TZ_RANGE1_LOW_RZ_ENB_SHIFT))

#define  MC_TZ_RANGE1_LOW_TZ_PERM_MASK 0x6
#define  MC_TZ_RANGE1_LOW_TZ_PERM_SHIFT 1
#define  MC_TZ_RANGE1_LOW_TZ_PERM_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE1_LOW_TZ_PERM_MASK) >> MC_TZ_RANGE1_LOW_TZ_PERM_SHIFT)
#define  MC_TZ_RANGE1_LOW_TZ_PERM_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE1_LOW_TZ_PERM_MASK) | (((uint32_t)val) << MC_TZ_RANGE1_LOW_TZ_PERM_SHIFT))

#define  MC_TZ_RANGE1_LOW_TZ_VALID_MASK 0x1
#define  MC_TZ_RANGE1_LOW_TZ_VALID_SHIFT 0
#define  MC_TZ_RANGE1_LOW_TZ_VALID_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE1_LOW_TZ_VALID_MASK) >> MC_TZ_RANGE1_LOW_TZ_VALID_SHIFT)
#define  MC_TZ_RANGE1_LOW_TZ_VALID_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE1_LOW_TZ_VALID_MASK) | (((uint32_t)val) << MC_TZ_RANGE1_LOW_TZ_VALID_SHIFT))

//====================================================================
//Register: MC Trustzone Range Low Register (TZ_Range2_Low)
//====================================================================

#define  MC_TZ_RANGE2_LOW_TZ_START_ADDR_L_MASK 0xfff00000
#define  MC_TZ_RANGE2_LOW_TZ_START_ADDR_L_SHIFT 20
#define  MC_TZ_RANGE2_LOW_TZ_START_ADDR_L_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE2_LOW_TZ_START_ADDR_L_MASK) >> MC_TZ_RANGE2_LOW_TZ_START_ADDR_L_SHIFT)
#define  MC_TZ_RANGE2_LOW_TZ_START_ADDR_L_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE2_LOW_TZ_START_ADDR_L_MASK) | (((uint32_t)val) << MC_TZ_RANGE2_LOW_TZ_START_ADDR_L_SHIFT))

#define  MC_TZ_RANGE2_LOW_RESERVED1_MASK 0xfe000
#define  MC_TZ_RANGE2_LOW_RESERVED1_SHIFT 13
#define  MC_TZ_RANGE2_LOW_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE2_LOW_RESERVED1_MASK) >> MC_TZ_RANGE2_LOW_RESERVED1_SHIFT)
#define  MC_TZ_RANGE2_LOW_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE2_LOW_RESERVED1_MASK) | (((uint32_t)val) << MC_TZ_RANGE2_LOW_RESERVED1_SHIFT))

#define  MC_TZ_RANGE2_LOW_TZ_AREA_LEN_MASK 0x1f00
#define  MC_TZ_RANGE2_LOW_TZ_AREA_LEN_SHIFT 8
#define  MC_TZ_RANGE2_LOW_TZ_AREA_LEN_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE2_LOW_TZ_AREA_LEN_MASK) >> MC_TZ_RANGE2_LOW_TZ_AREA_LEN_SHIFT)
#define  MC_TZ_RANGE2_LOW_TZ_AREA_LEN_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE2_LOW_TZ_AREA_LEN_MASK) | (((uint32_t)val) << MC_TZ_RANGE2_LOW_TZ_AREA_LEN_SHIFT))

#define  MC_TZ_RANGE2_LOW_RESERVED2_MASK 0xf0
#define  MC_TZ_RANGE2_LOW_RESERVED2_SHIFT 4
#define  MC_TZ_RANGE2_LOW_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE2_LOW_RESERVED2_MASK) >> MC_TZ_RANGE2_LOW_RESERVED2_SHIFT)
#define  MC_TZ_RANGE2_LOW_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE2_LOW_RESERVED2_MASK) | (((uint32_t)val) << MC_TZ_RANGE2_LOW_RESERVED2_SHIFT))

#define  MC_TZ_RANGE2_LOW_RZ_ENB_MASK 0x8
#define  MC_TZ_RANGE2_LOW_RZ_ENB_SHIFT 3
#define  MC_TZ_RANGE2_LOW_RZ_ENB_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE2_LOW_RZ_ENB_MASK) >> MC_TZ_RANGE2_LOW_RZ_ENB_SHIFT)
#define  MC_TZ_RANGE2_LOW_RZ_ENB_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE2_LOW_RZ_ENB_MASK) | (((uint32_t)val) << MC_TZ_RANGE2_LOW_RZ_ENB_SHIFT))

#define  MC_TZ_RANGE2_LOW_TZ_PERM_MASK 0x6
#define  MC_TZ_RANGE2_LOW_TZ_PERM_SHIFT 1
#define  MC_TZ_RANGE2_LOW_TZ_PERM_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE2_LOW_TZ_PERM_MASK) >> MC_TZ_RANGE2_LOW_TZ_PERM_SHIFT)
#define  MC_TZ_RANGE2_LOW_TZ_PERM_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE2_LOW_TZ_PERM_MASK) | (((uint32_t)val) << MC_TZ_RANGE2_LOW_TZ_PERM_SHIFT))

#define  MC_TZ_RANGE2_LOW_TZ_VALID_MASK 0x1
#define  MC_TZ_RANGE2_LOW_TZ_VALID_SHIFT 0
#define  MC_TZ_RANGE2_LOW_TZ_VALID_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE2_LOW_TZ_VALID_MASK) >> MC_TZ_RANGE2_LOW_TZ_VALID_SHIFT)
#define  MC_TZ_RANGE2_LOW_TZ_VALID_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE2_LOW_TZ_VALID_MASK) | (((uint32_t)val) << MC_TZ_RANGE2_LOW_TZ_VALID_SHIFT))

//====================================================================
//Register: MC Trustzone Range Low Register (TZ_Range3_Low)
//====================================================================

#define  MC_TZ_RANGE3_LOW_TZ_START_ADDR_L_MASK 0xfff00000
#define  MC_TZ_RANGE3_LOW_TZ_START_ADDR_L_SHIFT 20
#define  MC_TZ_RANGE3_LOW_TZ_START_ADDR_L_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE3_LOW_TZ_START_ADDR_L_MASK) >> MC_TZ_RANGE3_LOW_TZ_START_ADDR_L_SHIFT)
#define  MC_TZ_RANGE3_LOW_TZ_START_ADDR_L_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE3_LOW_TZ_START_ADDR_L_MASK) | (((uint32_t)val) << MC_TZ_RANGE3_LOW_TZ_START_ADDR_L_SHIFT))

#define  MC_TZ_RANGE3_LOW_RESERVED1_MASK 0xfe000
#define  MC_TZ_RANGE3_LOW_RESERVED1_SHIFT 13
#define  MC_TZ_RANGE3_LOW_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE3_LOW_RESERVED1_MASK) >> MC_TZ_RANGE3_LOW_RESERVED1_SHIFT)
#define  MC_TZ_RANGE3_LOW_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE3_LOW_RESERVED1_MASK) | (((uint32_t)val) << MC_TZ_RANGE3_LOW_RESERVED1_SHIFT))

#define  MC_TZ_RANGE3_LOW_TZ_AREA_LEN_MASK 0x1f00
#define  MC_TZ_RANGE3_LOW_TZ_AREA_LEN_SHIFT 8
#define  MC_TZ_RANGE3_LOW_TZ_AREA_LEN_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE3_LOW_TZ_AREA_LEN_MASK) >> MC_TZ_RANGE3_LOW_TZ_AREA_LEN_SHIFT)
#define  MC_TZ_RANGE3_LOW_TZ_AREA_LEN_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE3_LOW_TZ_AREA_LEN_MASK) | (((uint32_t)val) << MC_TZ_RANGE3_LOW_TZ_AREA_LEN_SHIFT))

#define  MC_TZ_RANGE3_LOW_RESERVED2_MASK 0xf0
#define  MC_TZ_RANGE3_LOW_RESERVED2_SHIFT 4
#define  MC_TZ_RANGE3_LOW_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE3_LOW_RESERVED2_MASK) >> MC_TZ_RANGE3_LOW_RESERVED2_SHIFT)
#define  MC_TZ_RANGE3_LOW_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE3_LOW_RESERVED2_MASK) | (((uint32_t)val) << MC_TZ_RANGE3_LOW_RESERVED2_SHIFT))

#define  MC_TZ_RANGE3_LOW_RZ_ENB_MASK 0x8
#define  MC_TZ_RANGE3_LOW_RZ_ENB_SHIFT 3
#define  MC_TZ_RANGE3_LOW_RZ_ENB_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE3_LOW_RZ_ENB_MASK) >> MC_TZ_RANGE3_LOW_RZ_ENB_SHIFT)
#define  MC_TZ_RANGE3_LOW_RZ_ENB_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE3_LOW_RZ_ENB_MASK) | (((uint32_t)val) << MC_TZ_RANGE3_LOW_RZ_ENB_SHIFT))

#define  MC_TZ_RANGE3_LOW_TZ_PERM_MASK 0x6
#define  MC_TZ_RANGE3_LOW_TZ_PERM_SHIFT 1
#define  MC_TZ_RANGE3_LOW_TZ_PERM_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE3_LOW_TZ_PERM_MASK) >> MC_TZ_RANGE3_LOW_TZ_PERM_SHIFT)
#define  MC_TZ_RANGE3_LOW_TZ_PERM_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE3_LOW_TZ_PERM_MASK) | (((uint32_t)val) << MC_TZ_RANGE3_LOW_TZ_PERM_SHIFT))

#define  MC_TZ_RANGE3_LOW_TZ_VALID_MASK 0x1
#define  MC_TZ_RANGE3_LOW_TZ_VALID_SHIFT 0
#define  MC_TZ_RANGE3_LOW_TZ_VALID_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE3_LOW_TZ_VALID_MASK) >> MC_TZ_RANGE3_LOW_TZ_VALID_SHIFT)
#define  MC_TZ_RANGE3_LOW_TZ_VALID_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE3_LOW_TZ_VALID_MASK) | (((uint32_t)val) << MC_TZ_RANGE3_LOW_TZ_VALID_SHIFT))

//====================================================================
//Register: MC Trustzone Range Low Register (TZ_Range4_Low)
//====================================================================

#define  MC_TZ_RANGE4_LOW_TZ_START_ADDR_L_MASK 0xfff00000
#define  MC_TZ_RANGE4_LOW_TZ_START_ADDR_L_SHIFT 20
#define  MC_TZ_RANGE4_LOW_TZ_START_ADDR_L_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE4_LOW_TZ_START_ADDR_L_MASK) >> MC_TZ_RANGE4_LOW_TZ_START_ADDR_L_SHIFT)
#define  MC_TZ_RANGE4_LOW_TZ_START_ADDR_L_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE4_LOW_TZ_START_ADDR_L_MASK) | (((uint32_t)val) << MC_TZ_RANGE4_LOW_TZ_START_ADDR_L_SHIFT))

#define  MC_TZ_RANGE4_LOW_RESERVED1_MASK 0xfe000
#define  MC_TZ_RANGE4_LOW_RESERVED1_SHIFT 13
#define  MC_TZ_RANGE4_LOW_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE4_LOW_RESERVED1_MASK) >> MC_TZ_RANGE4_LOW_RESERVED1_SHIFT)
#define  MC_TZ_RANGE4_LOW_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE4_LOW_RESERVED1_MASK) | (((uint32_t)val) << MC_TZ_RANGE4_LOW_RESERVED1_SHIFT))

#define  MC_TZ_RANGE4_LOW_TZ_AREA_LEN_MASK 0x1f00
#define  MC_TZ_RANGE4_LOW_TZ_AREA_LEN_SHIFT 8
#define  MC_TZ_RANGE4_LOW_TZ_AREA_LEN_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE4_LOW_TZ_AREA_LEN_MASK) >> MC_TZ_RANGE4_LOW_TZ_AREA_LEN_SHIFT)
#define  MC_TZ_RANGE4_LOW_TZ_AREA_LEN_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE4_LOW_TZ_AREA_LEN_MASK) | (((uint32_t)val) << MC_TZ_RANGE4_LOW_TZ_AREA_LEN_SHIFT))

#define  MC_TZ_RANGE4_LOW_RESERVED2_MASK 0xf0
#define  MC_TZ_RANGE4_LOW_RESERVED2_SHIFT 4
#define  MC_TZ_RANGE4_LOW_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE4_LOW_RESERVED2_MASK) >> MC_TZ_RANGE4_LOW_RESERVED2_SHIFT)
#define  MC_TZ_RANGE4_LOW_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE4_LOW_RESERVED2_MASK) | (((uint32_t)val) << MC_TZ_RANGE4_LOW_RESERVED2_SHIFT))

#define  MC_TZ_RANGE4_LOW_RZ_ENB_MASK 0x8
#define  MC_TZ_RANGE4_LOW_RZ_ENB_SHIFT 3
#define  MC_TZ_RANGE4_LOW_RZ_ENB_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE4_LOW_RZ_ENB_MASK) >> MC_TZ_RANGE4_LOW_RZ_ENB_SHIFT)
#define  MC_TZ_RANGE4_LOW_RZ_ENB_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE4_LOW_RZ_ENB_MASK) | (((uint32_t)val) << MC_TZ_RANGE4_LOW_RZ_ENB_SHIFT))

#define  MC_TZ_RANGE4_LOW_TZ_PERM_MASK 0x6
#define  MC_TZ_RANGE4_LOW_TZ_PERM_SHIFT 1
#define  MC_TZ_RANGE4_LOW_TZ_PERM_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE4_LOW_TZ_PERM_MASK) >> MC_TZ_RANGE4_LOW_TZ_PERM_SHIFT)
#define  MC_TZ_RANGE4_LOW_TZ_PERM_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE4_LOW_TZ_PERM_MASK) | (((uint32_t)val) << MC_TZ_RANGE4_LOW_TZ_PERM_SHIFT))

#define  MC_TZ_RANGE4_LOW_TZ_VALID_MASK 0x1
#define  MC_TZ_RANGE4_LOW_TZ_VALID_SHIFT 0
#define  MC_TZ_RANGE4_LOW_TZ_VALID_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE4_LOW_TZ_VALID_MASK) >> MC_TZ_RANGE4_LOW_TZ_VALID_SHIFT)
#define  MC_TZ_RANGE4_LOW_TZ_VALID_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE4_LOW_TZ_VALID_MASK) | (((uint32_t)val) << MC_TZ_RANGE4_LOW_TZ_VALID_SHIFT))

//====================================================================
//Register: MC Trustzone Range Low Register (TZ_Range5_Low)
//====================================================================

#define  MC_TZ_RANGE5_LOW_TZ_START_ADDR_L_MASK 0xfff00000
#define  MC_TZ_RANGE5_LOW_TZ_START_ADDR_L_SHIFT 20
#define  MC_TZ_RANGE5_LOW_TZ_START_ADDR_L_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE5_LOW_TZ_START_ADDR_L_MASK) >> MC_TZ_RANGE5_LOW_TZ_START_ADDR_L_SHIFT)
#define  MC_TZ_RANGE5_LOW_TZ_START_ADDR_L_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE5_LOW_TZ_START_ADDR_L_MASK) | (((uint32_t)val) << MC_TZ_RANGE5_LOW_TZ_START_ADDR_L_SHIFT))

#define  MC_TZ_RANGE5_LOW_RESERVED1_MASK 0xfe000
#define  MC_TZ_RANGE5_LOW_RESERVED1_SHIFT 13
#define  MC_TZ_RANGE5_LOW_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE5_LOW_RESERVED1_MASK) >> MC_TZ_RANGE5_LOW_RESERVED1_SHIFT)
#define  MC_TZ_RANGE5_LOW_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE5_LOW_RESERVED1_MASK) | (((uint32_t)val) << MC_TZ_RANGE5_LOW_RESERVED1_SHIFT))

#define  MC_TZ_RANGE5_LOW_TZ_AREA_LEN_MASK 0x1f00
#define  MC_TZ_RANGE5_LOW_TZ_AREA_LEN_SHIFT 8
#define  MC_TZ_RANGE5_LOW_TZ_AREA_LEN_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE5_LOW_TZ_AREA_LEN_MASK) >> MC_TZ_RANGE5_LOW_TZ_AREA_LEN_SHIFT)
#define  MC_TZ_RANGE5_LOW_TZ_AREA_LEN_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE5_LOW_TZ_AREA_LEN_MASK) | (((uint32_t)val) << MC_TZ_RANGE5_LOW_TZ_AREA_LEN_SHIFT))

#define  MC_TZ_RANGE5_LOW_RESERVED2_MASK 0xf0
#define  MC_TZ_RANGE5_LOW_RESERVED2_SHIFT 4
#define  MC_TZ_RANGE5_LOW_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE5_LOW_RESERVED2_MASK) >> MC_TZ_RANGE5_LOW_RESERVED2_SHIFT)
#define  MC_TZ_RANGE5_LOW_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE5_LOW_RESERVED2_MASK) | (((uint32_t)val) << MC_TZ_RANGE5_LOW_RESERVED2_SHIFT))

#define  MC_TZ_RANGE5_LOW_RZ_ENB_MASK 0x8
#define  MC_TZ_RANGE5_LOW_RZ_ENB_SHIFT 3
#define  MC_TZ_RANGE5_LOW_RZ_ENB_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE5_LOW_RZ_ENB_MASK) >> MC_TZ_RANGE5_LOW_RZ_ENB_SHIFT)
#define  MC_TZ_RANGE5_LOW_RZ_ENB_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE5_LOW_RZ_ENB_MASK) | (((uint32_t)val) << MC_TZ_RANGE5_LOW_RZ_ENB_SHIFT))

#define  MC_TZ_RANGE5_LOW_TZ_PERM_MASK 0x6
#define  MC_TZ_RANGE5_LOW_TZ_PERM_SHIFT 1
#define  MC_TZ_RANGE5_LOW_TZ_PERM_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE5_LOW_TZ_PERM_MASK) >> MC_TZ_RANGE5_LOW_TZ_PERM_SHIFT)
#define  MC_TZ_RANGE5_LOW_TZ_PERM_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE5_LOW_TZ_PERM_MASK) | (((uint32_t)val) << MC_TZ_RANGE5_LOW_TZ_PERM_SHIFT))

#define  MC_TZ_RANGE5_LOW_TZ_VALID_MASK 0x1
#define  MC_TZ_RANGE5_LOW_TZ_VALID_SHIFT 0
#define  MC_TZ_RANGE5_LOW_TZ_VALID_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE5_LOW_TZ_VALID_MASK) >> MC_TZ_RANGE5_LOW_TZ_VALID_SHIFT)
#define  MC_TZ_RANGE5_LOW_TZ_VALID_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE5_LOW_TZ_VALID_MASK) | (((uint32_t)val) << MC_TZ_RANGE5_LOW_TZ_VALID_SHIFT))

//====================================================================
//Register: MC Trustzone Range Low Register (TZ_Range6_Low)
//====================================================================

#define  MC_TZ_RANGE6_LOW_TZ_START_ADDR_L_MASK 0xfff00000
#define  MC_TZ_RANGE6_LOW_TZ_START_ADDR_L_SHIFT 20
#define  MC_TZ_RANGE6_LOW_TZ_START_ADDR_L_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE6_LOW_TZ_START_ADDR_L_MASK) >> MC_TZ_RANGE6_LOW_TZ_START_ADDR_L_SHIFT)
#define  MC_TZ_RANGE6_LOW_TZ_START_ADDR_L_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE6_LOW_TZ_START_ADDR_L_MASK) | (((uint32_t)val) << MC_TZ_RANGE6_LOW_TZ_START_ADDR_L_SHIFT))

#define  MC_TZ_RANGE6_LOW_RESERVED1_MASK 0xfe000
#define  MC_TZ_RANGE6_LOW_RESERVED1_SHIFT 13
#define  MC_TZ_RANGE6_LOW_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE6_LOW_RESERVED1_MASK) >> MC_TZ_RANGE6_LOW_RESERVED1_SHIFT)
#define  MC_TZ_RANGE6_LOW_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE6_LOW_RESERVED1_MASK) | (((uint32_t)val) << MC_TZ_RANGE6_LOW_RESERVED1_SHIFT))

#define  MC_TZ_RANGE6_LOW_TZ_AREA_LEN_MASK 0x1f00
#define  MC_TZ_RANGE6_LOW_TZ_AREA_LEN_SHIFT 8
#define  MC_TZ_RANGE6_LOW_TZ_AREA_LEN_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE6_LOW_TZ_AREA_LEN_MASK) >> MC_TZ_RANGE6_LOW_TZ_AREA_LEN_SHIFT)
#define  MC_TZ_RANGE6_LOW_TZ_AREA_LEN_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE6_LOW_TZ_AREA_LEN_MASK) | (((uint32_t)val) << MC_TZ_RANGE6_LOW_TZ_AREA_LEN_SHIFT))

#define  MC_TZ_RANGE6_LOW_RESERVED2_MASK 0xf0
#define  MC_TZ_RANGE6_LOW_RESERVED2_SHIFT 4
#define  MC_TZ_RANGE6_LOW_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE6_LOW_RESERVED2_MASK) >> MC_TZ_RANGE6_LOW_RESERVED2_SHIFT)
#define  MC_TZ_RANGE6_LOW_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE6_LOW_RESERVED2_MASK) | (((uint32_t)val) << MC_TZ_RANGE6_LOW_RESERVED2_SHIFT))

#define  MC_TZ_RANGE6_LOW_RZ_ENB_MASK 0x8
#define  MC_TZ_RANGE6_LOW_RZ_ENB_SHIFT 3
#define  MC_TZ_RANGE6_LOW_RZ_ENB_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE6_LOW_RZ_ENB_MASK) >> MC_TZ_RANGE6_LOW_RZ_ENB_SHIFT)
#define  MC_TZ_RANGE6_LOW_RZ_ENB_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE6_LOW_RZ_ENB_MASK) | (((uint32_t)val) << MC_TZ_RANGE6_LOW_RZ_ENB_SHIFT))

#define  MC_TZ_RANGE6_LOW_TZ_PERM_MASK 0x6
#define  MC_TZ_RANGE6_LOW_TZ_PERM_SHIFT 1
#define  MC_TZ_RANGE6_LOW_TZ_PERM_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE6_LOW_TZ_PERM_MASK) >> MC_TZ_RANGE6_LOW_TZ_PERM_SHIFT)
#define  MC_TZ_RANGE6_LOW_TZ_PERM_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE6_LOW_TZ_PERM_MASK) | (((uint32_t)val) << MC_TZ_RANGE6_LOW_TZ_PERM_SHIFT))

#define  MC_TZ_RANGE6_LOW_TZ_VALID_MASK 0x1
#define  MC_TZ_RANGE6_LOW_TZ_VALID_SHIFT 0
#define  MC_TZ_RANGE6_LOW_TZ_VALID_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE6_LOW_TZ_VALID_MASK) >> MC_TZ_RANGE6_LOW_TZ_VALID_SHIFT)
#define  MC_TZ_RANGE6_LOW_TZ_VALID_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE6_LOW_TZ_VALID_MASK) | (((uint32_t)val) << MC_TZ_RANGE6_LOW_TZ_VALID_SHIFT))

//====================================================================
//Register: MC Trustzone Range Low Register (TZ_Range7_Low)
//====================================================================

#define  MC_TZ_RANGE7_LOW_TZ_START_ADDR_L_MASK 0xfff00000
#define  MC_TZ_RANGE7_LOW_TZ_START_ADDR_L_SHIFT 20
#define  MC_TZ_RANGE7_LOW_TZ_START_ADDR_L_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE7_LOW_TZ_START_ADDR_L_MASK) >> MC_TZ_RANGE7_LOW_TZ_START_ADDR_L_SHIFT)
#define  MC_TZ_RANGE7_LOW_TZ_START_ADDR_L_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE7_LOW_TZ_START_ADDR_L_MASK) | (((uint32_t)val) << MC_TZ_RANGE7_LOW_TZ_START_ADDR_L_SHIFT))

#define  MC_TZ_RANGE7_LOW_RESERVED1_MASK 0xfe000
#define  MC_TZ_RANGE7_LOW_RESERVED1_SHIFT 13
#define  MC_TZ_RANGE7_LOW_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE7_LOW_RESERVED1_MASK) >> MC_TZ_RANGE7_LOW_RESERVED1_SHIFT)
#define  MC_TZ_RANGE7_LOW_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE7_LOW_RESERVED1_MASK) | (((uint32_t)val) << MC_TZ_RANGE7_LOW_RESERVED1_SHIFT))

#define  MC_TZ_RANGE7_LOW_TZ_AREA_LEN_MASK 0x1f00
#define  MC_TZ_RANGE7_LOW_TZ_AREA_LEN_SHIFT 8
#define  MC_TZ_RANGE7_LOW_TZ_AREA_LEN_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE7_LOW_TZ_AREA_LEN_MASK) >> MC_TZ_RANGE7_LOW_TZ_AREA_LEN_SHIFT)
#define  MC_TZ_RANGE7_LOW_TZ_AREA_LEN_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE7_LOW_TZ_AREA_LEN_MASK) | (((uint32_t)val) << MC_TZ_RANGE7_LOW_TZ_AREA_LEN_SHIFT))

#define  MC_TZ_RANGE7_LOW_RESERVED2_MASK 0xf0
#define  MC_TZ_RANGE7_LOW_RESERVED2_SHIFT 4
#define  MC_TZ_RANGE7_LOW_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE7_LOW_RESERVED2_MASK) >> MC_TZ_RANGE7_LOW_RESERVED2_SHIFT)
#define  MC_TZ_RANGE7_LOW_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE7_LOW_RESERVED2_MASK) | (((uint32_t)val) << MC_TZ_RANGE7_LOW_RESERVED2_SHIFT))

#define  MC_TZ_RANGE7_LOW_RZ_ENB_MASK 0x8
#define  MC_TZ_RANGE7_LOW_RZ_ENB_SHIFT 3
#define  MC_TZ_RANGE7_LOW_RZ_ENB_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE7_LOW_RZ_ENB_MASK) >> MC_TZ_RANGE7_LOW_RZ_ENB_SHIFT)
#define  MC_TZ_RANGE7_LOW_RZ_ENB_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE7_LOW_RZ_ENB_MASK) | (((uint32_t)val) << MC_TZ_RANGE7_LOW_RZ_ENB_SHIFT))

#define  MC_TZ_RANGE7_LOW_TZ_PERM_MASK 0x6
#define  MC_TZ_RANGE7_LOW_TZ_PERM_SHIFT 1
#define  MC_TZ_RANGE7_LOW_TZ_PERM_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE7_LOW_TZ_PERM_MASK) >> MC_TZ_RANGE7_LOW_TZ_PERM_SHIFT)
#define  MC_TZ_RANGE7_LOW_TZ_PERM_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE7_LOW_TZ_PERM_MASK) | (((uint32_t)val) << MC_TZ_RANGE7_LOW_TZ_PERM_SHIFT))

#define  MC_TZ_RANGE7_LOW_TZ_VALID_MASK 0x1
#define  MC_TZ_RANGE7_LOW_TZ_VALID_SHIFT 0
#define  MC_TZ_RANGE7_LOW_TZ_VALID_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE7_LOW_TZ_VALID_MASK) >> MC_TZ_RANGE7_LOW_TZ_VALID_SHIFT)
#define  MC_TZ_RANGE7_LOW_TZ_VALID_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE7_LOW_TZ_VALID_MASK) | (((uint32_t)val) << MC_TZ_RANGE7_LOW_TZ_VALID_SHIFT))

//====================================================================
//Register: MC Trustzone Range Low Register (TZ_Range8_Low)
//====================================================================

#define  MC_TZ_RANGE8_LOW_TZ_START_ADDR_L_MASK 0xfff00000
#define  MC_TZ_RANGE8_LOW_TZ_START_ADDR_L_SHIFT 20
#define  MC_TZ_RANGE8_LOW_TZ_START_ADDR_L_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE8_LOW_TZ_START_ADDR_L_MASK) >> MC_TZ_RANGE8_LOW_TZ_START_ADDR_L_SHIFT)
#define  MC_TZ_RANGE8_LOW_TZ_START_ADDR_L_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE8_LOW_TZ_START_ADDR_L_MASK) | (((uint32_t)val) << MC_TZ_RANGE8_LOW_TZ_START_ADDR_L_SHIFT))

#define  MC_TZ_RANGE8_LOW_RESERVED1_MASK 0xfe000
#define  MC_TZ_RANGE8_LOW_RESERVED1_SHIFT 13
#define  MC_TZ_RANGE8_LOW_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE8_LOW_RESERVED1_MASK) >> MC_TZ_RANGE8_LOW_RESERVED1_SHIFT)
#define  MC_TZ_RANGE8_LOW_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE8_LOW_RESERVED1_MASK) | (((uint32_t)val) << MC_TZ_RANGE8_LOW_RESERVED1_SHIFT))

#define  MC_TZ_RANGE8_LOW_TZ_AREA_LEN_MASK 0x1f00
#define  MC_TZ_RANGE8_LOW_TZ_AREA_LEN_SHIFT 8
#define  MC_TZ_RANGE8_LOW_TZ_AREA_LEN_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE8_LOW_TZ_AREA_LEN_MASK) >> MC_TZ_RANGE8_LOW_TZ_AREA_LEN_SHIFT)
#define  MC_TZ_RANGE8_LOW_TZ_AREA_LEN_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE8_LOW_TZ_AREA_LEN_MASK) | (((uint32_t)val) << MC_TZ_RANGE8_LOW_TZ_AREA_LEN_SHIFT))

#define  MC_TZ_RANGE8_LOW_RESERVED2_MASK 0xf0
#define  MC_TZ_RANGE8_LOW_RESERVED2_SHIFT 4
#define  MC_TZ_RANGE8_LOW_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE8_LOW_RESERVED2_MASK) >> MC_TZ_RANGE8_LOW_RESERVED2_SHIFT)
#define  MC_TZ_RANGE8_LOW_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE8_LOW_RESERVED2_MASK) | (((uint32_t)val) << MC_TZ_RANGE8_LOW_RESERVED2_SHIFT))

#define  MC_TZ_RANGE8_LOW_RZ_ENB_MASK 0x8
#define  MC_TZ_RANGE8_LOW_RZ_ENB_SHIFT 3
#define  MC_TZ_RANGE8_LOW_RZ_ENB_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE8_LOW_RZ_ENB_MASK) >> MC_TZ_RANGE8_LOW_RZ_ENB_SHIFT)
#define  MC_TZ_RANGE8_LOW_RZ_ENB_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE8_LOW_RZ_ENB_MASK) | (((uint32_t)val) << MC_TZ_RANGE8_LOW_RZ_ENB_SHIFT))

#define  MC_TZ_RANGE8_LOW_TZ_PERM_MASK 0x6
#define  MC_TZ_RANGE8_LOW_TZ_PERM_SHIFT 1
#define  MC_TZ_RANGE8_LOW_TZ_PERM_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE8_LOW_TZ_PERM_MASK) >> MC_TZ_RANGE8_LOW_TZ_PERM_SHIFT)
#define  MC_TZ_RANGE8_LOW_TZ_PERM_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE8_LOW_TZ_PERM_MASK) | (((uint32_t)val) << MC_TZ_RANGE8_LOW_TZ_PERM_SHIFT))

#define  MC_TZ_RANGE8_LOW_TZ_VALID_MASK 0x1
#define  MC_TZ_RANGE8_LOW_TZ_VALID_SHIFT 0
#define  MC_TZ_RANGE8_LOW_TZ_VALID_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE8_LOW_TZ_VALID_MASK) >> MC_TZ_RANGE8_LOW_TZ_VALID_SHIFT)
#define  MC_TZ_RANGE8_LOW_TZ_VALID_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE8_LOW_TZ_VALID_MASK) | (((uint32_t)val) << MC_TZ_RANGE8_LOW_TZ_VALID_SHIFT))

//====================================================================
//Register: MC Trustzone Range Low Register (TZ_Range9_Low)
//====================================================================

#define  MC_TZ_RANGE9_LOW_TZ_START_ADDR_L_MASK 0xfff00000
#define  MC_TZ_RANGE9_LOW_TZ_START_ADDR_L_SHIFT 20
#define  MC_TZ_RANGE9_LOW_TZ_START_ADDR_L_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE9_LOW_TZ_START_ADDR_L_MASK) >> MC_TZ_RANGE9_LOW_TZ_START_ADDR_L_SHIFT)
#define  MC_TZ_RANGE9_LOW_TZ_START_ADDR_L_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE9_LOW_TZ_START_ADDR_L_MASK) | (((uint32_t)val) << MC_TZ_RANGE9_LOW_TZ_START_ADDR_L_SHIFT))

#define  MC_TZ_RANGE9_LOW_RESERVED1_MASK 0xfe000
#define  MC_TZ_RANGE9_LOW_RESERVED1_SHIFT 13
#define  MC_TZ_RANGE9_LOW_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE9_LOW_RESERVED1_MASK) >> MC_TZ_RANGE9_LOW_RESERVED1_SHIFT)
#define  MC_TZ_RANGE9_LOW_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE9_LOW_RESERVED1_MASK) | (((uint32_t)val) << MC_TZ_RANGE9_LOW_RESERVED1_SHIFT))

#define  MC_TZ_RANGE9_LOW_TZ_AREA_LEN_MASK 0x1f00
#define  MC_TZ_RANGE9_LOW_TZ_AREA_LEN_SHIFT 8
#define  MC_TZ_RANGE9_LOW_TZ_AREA_LEN_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE9_LOW_TZ_AREA_LEN_MASK) >> MC_TZ_RANGE9_LOW_TZ_AREA_LEN_SHIFT)
#define  MC_TZ_RANGE9_LOW_TZ_AREA_LEN_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE9_LOW_TZ_AREA_LEN_MASK) | (((uint32_t)val) << MC_TZ_RANGE9_LOW_TZ_AREA_LEN_SHIFT))

#define  MC_TZ_RANGE9_LOW_RESERVED2_MASK 0xf0
#define  MC_TZ_RANGE9_LOW_RESERVED2_SHIFT 4
#define  MC_TZ_RANGE9_LOW_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE9_LOW_RESERVED2_MASK) >> MC_TZ_RANGE9_LOW_RESERVED2_SHIFT)
#define  MC_TZ_RANGE9_LOW_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE9_LOW_RESERVED2_MASK) | (((uint32_t)val) << MC_TZ_RANGE9_LOW_RESERVED2_SHIFT))

#define  MC_TZ_RANGE9_LOW_RZ_ENB_MASK 0x8
#define  MC_TZ_RANGE9_LOW_RZ_ENB_SHIFT 3
#define  MC_TZ_RANGE9_LOW_RZ_ENB_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE9_LOW_RZ_ENB_MASK) >> MC_TZ_RANGE9_LOW_RZ_ENB_SHIFT)
#define  MC_TZ_RANGE9_LOW_RZ_ENB_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE9_LOW_RZ_ENB_MASK) | (((uint32_t)val) << MC_TZ_RANGE9_LOW_RZ_ENB_SHIFT))

#define  MC_TZ_RANGE9_LOW_TZ_PERM_MASK 0x6
#define  MC_TZ_RANGE9_LOW_TZ_PERM_SHIFT 1
#define  MC_TZ_RANGE9_LOW_TZ_PERM_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE9_LOW_TZ_PERM_MASK) >> MC_TZ_RANGE9_LOW_TZ_PERM_SHIFT)
#define  MC_TZ_RANGE9_LOW_TZ_PERM_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE9_LOW_TZ_PERM_MASK) | (((uint32_t)val) << MC_TZ_RANGE9_LOW_TZ_PERM_SHIFT))

#define  MC_TZ_RANGE9_LOW_TZ_VALID_MASK 0x1
#define  MC_TZ_RANGE9_LOW_TZ_VALID_SHIFT 0
#define  MC_TZ_RANGE9_LOW_TZ_VALID_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE9_LOW_TZ_VALID_MASK) >> MC_TZ_RANGE9_LOW_TZ_VALID_SHIFT)
#define  MC_TZ_RANGE9_LOW_TZ_VALID_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE9_LOW_TZ_VALID_MASK) | (((uint32_t)val) << MC_TZ_RANGE9_LOW_TZ_VALID_SHIFT))

//====================================================================
//Register: MC Trustzone Range Low Register (TZ_Range10_Low)
//====================================================================

#define  MC_TZ_RANGE10_LOW_TZ_START_ADDR_L_MASK 0xfff00000
#define  MC_TZ_RANGE10_LOW_TZ_START_ADDR_L_SHIFT 20
#define  MC_TZ_RANGE10_LOW_TZ_START_ADDR_L_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE10_LOW_TZ_START_ADDR_L_MASK) >> MC_TZ_RANGE10_LOW_TZ_START_ADDR_L_SHIFT)
#define  MC_TZ_RANGE10_LOW_TZ_START_ADDR_L_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE10_LOW_TZ_START_ADDR_L_MASK) | (((uint32_t)val) << MC_TZ_RANGE10_LOW_TZ_START_ADDR_L_SHIFT))

#define  MC_TZ_RANGE10_LOW_RESERVED1_MASK 0xfe000
#define  MC_TZ_RANGE10_LOW_RESERVED1_SHIFT 13
#define  MC_TZ_RANGE10_LOW_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE10_LOW_RESERVED1_MASK) >> MC_TZ_RANGE10_LOW_RESERVED1_SHIFT)
#define  MC_TZ_RANGE10_LOW_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE10_LOW_RESERVED1_MASK) | (((uint32_t)val) << MC_TZ_RANGE10_LOW_RESERVED1_SHIFT))

#define  MC_TZ_RANGE10_LOW_TZ_AREA_LEN_MASK 0x1f00
#define  MC_TZ_RANGE10_LOW_TZ_AREA_LEN_SHIFT 8
#define  MC_TZ_RANGE10_LOW_TZ_AREA_LEN_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE10_LOW_TZ_AREA_LEN_MASK) >> MC_TZ_RANGE10_LOW_TZ_AREA_LEN_SHIFT)
#define  MC_TZ_RANGE10_LOW_TZ_AREA_LEN_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE10_LOW_TZ_AREA_LEN_MASK) | (((uint32_t)val) << MC_TZ_RANGE10_LOW_TZ_AREA_LEN_SHIFT))

#define  MC_TZ_RANGE10_LOW_RESERVED2_MASK 0xf0
#define  MC_TZ_RANGE10_LOW_RESERVED2_SHIFT 4
#define  MC_TZ_RANGE10_LOW_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE10_LOW_RESERVED2_MASK) >> MC_TZ_RANGE10_LOW_RESERVED2_SHIFT)
#define  MC_TZ_RANGE10_LOW_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE10_LOW_RESERVED2_MASK) | (((uint32_t)val) << MC_TZ_RANGE10_LOW_RESERVED2_SHIFT))

#define  MC_TZ_RANGE10_LOW_RZ_ENB_MASK 0x8
#define  MC_TZ_RANGE10_LOW_RZ_ENB_SHIFT 3
#define  MC_TZ_RANGE10_LOW_RZ_ENB_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE10_LOW_RZ_ENB_MASK) >> MC_TZ_RANGE10_LOW_RZ_ENB_SHIFT)
#define  MC_TZ_RANGE10_LOW_RZ_ENB_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE10_LOW_RZ_ENB_MASK) | (((uint32_t)val) << MC_TZ_RANGE10_LOW_RZ_ENB_SHIFT))

#define  MC_TZ_RANGE10_LOW_TZ_PERM_MASK 0x6
#define  MC_TZ_RANGE10_LOW_TZ_PERM_SHIFT 1
#define  MC_TZ_RANGE10_LOW_TZ_PERM_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE10_LOW_TZ_PERM_MASK) >> MC_TZ_RANGE10_LOW_TZ_PERM_SHIFT)
#define  MC_TZ_RANGE10_LOW_TZ_PERM_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE10_LOW_TZ_PERM_MASK) | (((uint32_t)val) << MC_TZ_RANGE10_LOW_TZ_PERM_SHIFT))

#define  MC_TZ_RANGE10_LOW_TZ_VALID_MASK 0x1
#define  MC_TZ_RANGE10_LOW_TZ_VALID_SHIFT 0
#define  MC_TZ_RANGE10_LOW_TZ_VALID_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE10_LOW_TZ_VALID_MASK) >> MC_TZ_RANGE10_LOW_TZ_VALID_SHIFT)
#define  MC_TZ_RANGE10_LOW_TZ_VALID_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE10_LOW_TZ_VALID_MASK) | (((uint32_t)val) << MC_TZ_RANGE10_LOW_TZ_VALID_SHIFT))

//====================================================================
//Register: MC Trustzone Range Low Register (TZ_Range11_Low)
//====================================================================

#define  MC_TZ_RANGE11_LOW_TZ_START_ADDR_L_MASK 0xfff00000
#define  MC_TZ_RANGE11_LOW_TZ_START_ADDR_L_SHIFT 20
#define  MC_TZ_RANGE11_LOW_TZ_START_ADDR_L_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE11_LOW_TZ_START_ADDR_L_MASK) >> MC_TZ_RANGE11_LOW_TZ_START_ADDR_L_SHIFT)
#define  MC_TZ_RANGE11_LOW_TZ_START_ADDR_L_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE11_LOW_TZ_START_ADDR_L_MASK) | (((uint32_t)val) << MC_TZ_RANGE11_LOW_TZ_START_ADDR_L_SHIFT))

#define  MC_TZ_RANGE11_LOW_RESERVED1_MASK 0xfe000
#define  MC_TZ_RANGE11_LOW_RESERVED1_SHIFT 13
#define  MC_TZ_RANGE11_LOW_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE11_LOW_RESERVED1_MASK) >> MC_TZ_RANGE11_LOW_RESERVED1_SHIFT)
#define  MC_TZ_RANGE11_LOW_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE11_LOW_RESERVED1_MASK) | (((uint32_t)val) << MC_TZ_RANGE11_LOW_RESERVED1_SHIFT))

#define  MC_TZ_RANGE11_LOW_TZ_AREA_LEN_MASK 0x1f00
#define  MC_TZ_RANGE11_LOW_TZ_AREA_LEN_SHIFT 8
#define  MC_TZ_RANGE11_LOW_TZ_AREA_LEN_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE11_LOW_TZ_AREA_LEN_MASK) >> MC_TZ_RANGE11_LOW_TZ_AREA_LEN_SHIFT)
#define  MC_TZ_RANGE11_LOW_TZ_AREA_LEN_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE11_LOW_TZ_AREA_LEN_MASK) | (((uint32_t)val) << MC_TZ_RANGE11_LOW_TZ_AREA_LEN_SHIFT))

#define  MC_TZ_RANGE11_LOW_RESERVED2_MASK 0xf0
#define  MC_TZ_RANGE11_LOW_RESERVED2_SHIFT 4
#define  MC_TZ_RANGE11_LOW_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE11_LOW_RESERVED2_MASK) >> MC_TZ_RANGE11_LOW_RESERVED2_SHIFT)
#define  MC_TZ_RANGE11_LOW_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE11_LOW_RESERVED2_MASK) | (((uint32_t)val) << MC_TZ_RANGE11_LOW_RESERVED2_SHIFT))

#define  MC_TZ_RANGE11_LOW_RZ_ENB_MASK 0x8
#define  MC_TZ_RANGE11_LOW_RZ_ENB_SHIFT 3
#define  MC_TZ_RANGE11_LOW_RZ_ENB_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE11_LOW_RZ_ENB_MASK) >> MC_TZ_RANGE11_LOW_RZ_ENB_SHIFT)
#define  MC_TZ_RANGE11_LOW_RZ_ENB_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE11_LOW_RZ_ENB_MASK) | (((uint32_t)val) << MC_TZ_RANGE11_LOW_RZ_ENB_SHIFT))

#define  MC_TZ_RANGE11_LOW_TZ_PERM_MASK 0x6
#define  MC_TZ_RANGE11_LOW_TZ_PERM_SHIFT 1
#define  MC_TZ_RANGE11_LOW_TZ_PERM_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE11_LOW_TZ_PERM_MASK) >> MC_TZ_RANGE11_LOW_TZ_PERM_SHIFT)
#define  MC_TZ_RANGE11_LOW_TZ_PERM_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE11_LOW_TZ_PERM_MASK) | (((uint32_t)val) << MC_TZ_RANGE11_LOW_TZ_PERM_SHIFT))

#define  MC_TZ_RANGE11_LOW_TZ_VALID_MASK 0x1
#define  MC_TZ_RANGE11_LOW_TZ_VALID_SHIFT 0
#define  MC_TZ_RANGE11_LOW_TZ_VALID_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE11_LOW_TZ_VALID_MASK) >> MC_TZ_RANGE11_LOW_TZ_VALID_SHIFT)
#define  MC_TZ_RANGE11_LOW_TZ_VALID_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE11_LOW_TZ_VALID_MASK) | (((uint32_t)val) << MC_TZ_RANGE11_LOW_TZ_VALID_SHIFT))

//====================================================================
//Register: MC Trustzone Range Low Register (TZ_Range12_Low)
//====================================================================

#define  MC_TZ_RANGE12_LOW_TZ_START_ADDR_L_MASK 0xfff00000
#define  MC_TZ_RANGE12_LOW_TZ_START_ADDR_L_SHIFT 20
#define  MC_TZ_RANGE12_LOW_TZ_START_ADDR_L_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE12_LOW_TZ_START_ADDR_L_MASK) >> MC_TZ_RANGE12_LOW_TZ_START_ADDR_L_SHIFT)
#define  MC_TZ_RANGE12_LOW_TZ_START_ADDR_L_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE12_LOW_TZ_START_ADDR_L_MASK) | (((uint32_t)val) << MC_TZ_RANGE12_LOW_TZ_START_ADDR_L_SHIFT))

#define  MC_TZ_RANGE12_LOW_RESERVED1_MASK 0xfe000
#define  MC_TZ_RANGE12_LOW_RESERVED1_SHIFT 13
#define  MC_TZ_RANGE12_LOW_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE12_LOW_RESERVED1_MASK) >> MC_TZ_RANGE12_LOW_RESERVED1_SHIFT)
#define  MC_TZ_RANGE12_LOW_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE12_LOW_RESERVED1_MASK) | (((uint32_t)val) << MC_TZ_RANGE12_LOW_RESERVED1_SHIFT))

#define  MC_TZ_RANGE12_LOW_TZ_AREA_LEN_MASK 0x1f00
#define  MC_TZ_RANGE12_LOW_TZ_AREA_LEN_SHIFT 8
#define  MC_TZ_RANGE12_LOW_TZ_AREA_LEN_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE12_LOW_TZ_AREA_LEN_MASK) >> MC_TZ_RANGE12_LOW_TZ_AREA_LEN_SHIFT)
#define  MC_TZ_RANGE12_LOW_TZ_AREA_LEN_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE12_LOW_TZ_AREA_LEN_MASK) | (((uint32_t)val) << MC_TZ_RANGE12_LOW_TZ_AREA_LEN_SHIFT))

#define  MC_TZ_RANGE12_LOW_RESERVED2_MASK 0xf0
#define  MC_TZ_RANGE12_LOW_RESERVED2_SHIFT 4
#define  MC_TZ_RANGE12_LOW_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE12_LOW_RESERVED2_MASK) >> MC_TZ_RANGE12_LOW_RESERVED2_SHIFT)
#define  MC_TZ_RANGE12_LOW_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE12_LOW_RESERVED2_MASK) | (((uint32_t)val) << MC_TZ_RANGE12_LOW_RESERVED2_SHIFT))

#define  MC_TZ_RANGE12_LOW_RZ_ENB_MASK 0x8
#define  MC_TZ_RANGE12_LOW_RZ_ENB_SHIFT 3
#define  MC_TZ_RANGE12_LOW_RZ_ENB_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE12_LOW_RZ_ENB_MASK) >> MC_TZ_RANGE12_LOW_RZ_ENB_SHIFT)
#define  MC_TZ_RANGE12_LOW_RZ_ENB_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE12_LOW_RZ_ENB_MASK) | (((uint32_t)val) << MC_TZ_RANGE12_LOW_RZ_ENB_SHIFT))

#define  MC_TZ_RANGE12_LOW_TZ_PERM_MASK 0x6
#define  MC_TZ_RANGE12_LOW_TZ_PERM_SHIFT 1
#define  MC_TZ_RANGE12_LOW_TZ_PERM_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE12_LOW_TZ_PERM_MASK) >> MC_TZ_RANGE12_LOW_TZ_PERM_SHIFT)
#define  MC_TZ_RANGE12_LOW_TZ_PERM_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE12_LOW_TZ_PERM_MASK) | (((uint32_t)val) << MC_TZ_RANGE12_LOW_TZ_PERM_SHIFT))

#define  MC_TZ_RANGE12_LOW_TZ_VALID_MASK 0x1
#define  MC_TZ_RANGE12_LOW_TZ_VALID_SHIFT 0
#define  MC_TZ_RANGE12_LOW_TZ_VALID_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE12_LOW_TZ_VALID_MASK) >> MC_TZ_RANGE12_LOW_TZ_VALID_SHIFT)
#define  MC_TZ_RANGE12_LOW_TZ_VALID_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE12_LOW_TZ_VALID_MASK) | (((uint32_t)val) << MC_TZ_RANGE12_LOW_TZ_VALID_SHIFT))

//====================================================================
//Register: MC Trustzone Range Low Register (TZ_Range13_Low)
//====================================================================

#define  MC_TZ_RANGE13_LOW_TZ_START_ADDR_L_MASK 0xfff00000
#define  MC_TZ_RANGE13_LOW_TZ_START_ADDR_L_SHIFT 20
#define  MC_TZ_RANGE13_LOW_TZ_START_ADDR_L_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE13_LOW_TZ_START_ADDR_L_MASK) >> MC_TZ_RANGE13_LOW_TZ_START_ADDR_L_SHIFT)
#define  MC_TZ_RANGE13_LOW_TZ_START_ADDR_L_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE13_LOW_TZ_START_ADDR_L_MASK) | (((uint32_t)val) << MC_TZ_RANGE13_LOW_TZ_START_ADDR_L_SHIFT))

#define  MC_TZ_RANGE13_LOW_RESERVED1_MASK 0xfe000
#define  MC_TZ_RANGE13_LOW_RESERVED1_SHIFT 13
#define  MC_TZ_RANGE13_LOW_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE13_LOW_RESERVED1_MASK) >> MC_TZ_RANGE13_LOW_RESERVED1_SHIFT)
#define  MC_TZ_RANGE13_LOW_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE13_LOW_RESERVED1_MASK) | (((uint32_t)val) << MC_TZ_RANGE13_LOW_RESERVED1_SHIFT))

#define  MC_TZ_RANGE13_LOW_TZ_AREA_LEN_MASK 0x1f00
#define  MC_TZ_RANGE13_LOW_TZ_AREA_LEN_SHIFT 8
#define  MC_TZ_RANGE13_LOW_TZ_AREA_LEN_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE13_LOW_TZ_AREA_LEN_MASK) >> MC_TZ_RANGE13_LOW_TZ_AREA_LEN_SHIFT)
#define  MC_TZ_RANGE13_LOW_TZ_AREA_LEN_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE13_LOW_TZ_AREA_LEN_MASK) | (((uint32_t)val) << MC_TZ_RANGE13_LOW_TZ_AREA_LEN_SHIFT))

#define  MC_TZ_RANGE13_LOW_RESERVED2_MASK 0xf0
#define  MC_TZ_RANGE13_LOW_RESERVED2_SHIFT 4
#define  MC_TZ_RANGE13_LOW_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE13_LOW_RESERVED2_MASK) >> MC_TZ_RANGE13_LOW_RESERVED2_SHIFT)
#define  MC_TZ_RANGE13_LOW_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE13_LOW_RESERVED2_MASK) | (((uint32_t)val) << MC_TZ_RANGE13_LOW_RESERVED2_SHIFT))

#define  MC_TZ_RANGE13_LOW_RZ_ENB_MASK 0x8
#define  MC_TZ_RANGE13_LOW_RZ_ENB_SHIFT 3
#define  MC_TZ_RANGE13_LOW_RZ_ENB_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE13_LOW_RZ_ENB_MASK) >> MC_TZ_RANGE13_LOW_RZ_ENB_SHIFT)
#define  MC_TZ_RANGE13_LOW_RZ_ENB_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE13_LOW_RZ_ENB_MASK) | (((uint32_t)val) << MC_TZ_RANGE13_LOW_RZ_ENB_SHIFT))

#define  MC_TZ_RANGE13_LOW_TZ_PERM_MASK 0x6
#define  MC_TZ_RANGE13_LOW_TZ_PERM_SHIFT 1
#define  MC_TZ_RANGE13_LOW_TZ_PERM_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE13_LOW_TZ_PERM_MASK) >> MC_TZ_RANGE13_LOW_TZ_PERM_SHIFT)
#define  MC_TZ_RANGE13_LOW_TZ_PERM_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE13_LOW_TZ_PERM_MASK) | (((uint32_t)val) << MC_TZ_RANGE13_LOW_TZ_PERM_SHIFT))

#define  MC_TZ_RANGE13_LOW_TZ_VALID_MASK 0x1
#define  MC_TZ_RANGE13_LOW_TZ_VALID_SHIFT 0
#define  MC_TZ_RANGE13_LOW_TZ_VALID_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE13_LOW_TZ_VALID_MASK) >> MC_TZ_RANGE13_LOW_TZ_VALID_SHIFT)
#define  MC_TZ_RANGE13_LOW_TZ_VALID_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE13_LOW_TZ_VALID_MASK) | (((uint32_t)val) << MC_TZ_RANGE13_LOW_TZ_VALID_SHIFT))

//====================================================================
//Register: MC Trustzone Range Low Register (TZ_Range14_Low)
//====================================================================

#define  MC_TZ_RANGE14_LOW_TZ_START_ADDR_L_MASK 0xfff00000
#define  MC_TZ_RANGE14_LOW_TZ_START_ADDR_L_SHIFT 20
#define  MC_TZ_RANGE14_LOW_TZ_START_ADDR_L_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE14_LOW_TZ_START_ADDR_L_MASK) >> MC_TZ_RANGE14_LOW_TZ_START_ADDR_L_SHIFT)
#define  MC_TZ_RANGE14_LOW_TZ_START_ADDR_L_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE14_LOW_TZ_START_ADDR_L_MASK) | (((uint32_t)val) << MC_TZ_RANGE14_LOW_TZ_START_ADDR_L_SHIFT))

#define  MC_TZ_RANGE14_LOW_RESERVED1_MASK 0xfe000
#define  MC_TZ_RANGE14_LOW_RESERVED1_SHIFT 13
#define  MC_TZ_RANGE14_LOW_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE14_LOW_RESERVED1_MASK) >> MC_TZ_RANGE14_LOW_RESERVED1_SHIFT)
#define  MC_TZ_RANGE14_LOW_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE14_LOW_RESERVED1_MASK) | (((uint32_t)val) << MC_TZ_RANGE14_LOW_RESERVED1_SHIFT))

#define  MC_TZ_RANGE14_LOW_TZ_AREA_LEN_MASK 0x1f00
#define  MC_TZ_RANGE14_LOW_TZ_AREA_LEN_SHIFT 8
#define  MC_TZ_RANGE14_LOW_TZ_AREA_LEN_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE14_LOW_TZ_AREA_LEN_MASK) >> MC_TZ_RANGE14_LOW_TZ_AREA_LEN_SHIFT)
#define  MC_TZ_RANGE14_LOW_TZ_AREA_LEN_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE14_LOW_TZ_AREA_LEN_MASK) | (((uint32_t)val) << MC_TZ_RANGE14_LOW_TZ_AREA_LEN_SHIFT))

#define  MC_TZ_RANGE14_LOW_RESERVED2_MASK 0xf0
#define  MC_TZ_RANGE14_LOW_RESERVED2_SHIFT 4
#define  MC_TZ_RANGE14_LOW_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE14_LOW_RESERVED2_MASK) >> MC_TZ_RANGE14_LOW_RESERVED2_SHIFT)
#define  MC_TZ_RANGE14_LOW_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE14_LOW_RESERVED2_MASK) | (((uint32_t)val) << MC_TZ_RANGE14_LOW_RESERVED2_SHIFT))

#define  MC_TZ_RANGE14_LOW_RZ_ENB_MASK 0x8
#define  MC_TZ_RANGE14_LOW_RZ_ENB_SHIFT 3
#define  MC_TZ_RANGE14_LOW_RZ_ENB_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE14_LOW_RZ_ENB_MASK) >> MC_TZ_RANGE14_LOW_RZ_ENB_SHIFT)
#define  MC_TZ_RANGE14_LOW_RZ_ENB_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE14_LOW_RZ_ENB_MASK) | (((uint32_t)val) << MC_TZ_RANGE14_LOW_RZ_ENB_SHIFT))

#define  MC_TZ_RANGE14_LOW_TZ_PERM_MASK 0x6
#define  MC_TZ_RANGE14_LOW_TZ_PERM_SHIFT 1
#define  MC_TZ_RANGE14_LOW_TZ_PERM_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE14_LOW_TZ_PERM_MASK) >> MC_TZ_RANGE14_LOW_TZ_PERM_SHIFT)
#define  MC_TZ_RANGE14_LOW_TZ_PERM_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE14_LOW_TZ_PERM_MASK) | (((uint32_t)val) << MC_TZ_RANGE14_LOW_TZ_PERM_SHIFT))

#define  MC_TZ_RANGE14_LOW_TZ_VALID_MASK 0x1
#define  MC_TZ_RANGE14_LOW_TZ_VALID_SHIFT 0
#define  MC_TZ_RANGE14_LOW_TZ_VALID_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE14_LOW_TZ_VALID_MASK) >> MC_TZ_RANGE14_LOW_TZ_VALID_SHIFT)
#define  MC_TZ_RANGE14_LOW_TZ_VALID_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE14_LOW_TZ_VALID_MASK) | (((uint32_t)val) << MC_TZ_RANGE14_LOW_TZ_VALID_SHIFT))

//====================================================================
//Register: MC Trustzone Range Low Register (TZ_Range15_Low)
//====================================================================

#define  MC_TZ_RANGE15_LOW_TZ_START_ADDR_L_MASK 0xfff00000
#define  MC_TZ_RANGE15_LOW_TZ_START_ADDR_L_SHIFT 20
#define  MC_TZ_RANGE15_LOW_TZ_START_ADDR_L_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE15_LOW_TZ_START_ADDR_L_MASK) >> MC_TZ_RANGE15_LOW_TZ_START_ADDR_L_SHIFT)
#define  MC_TZ_RANGE15_LOW_TZ_START_ADDR_L_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE15_LOW_TZ_START_ADDR_L_MASK) | (((uint32_t)val) << MC_TZ_RANGE15_LOW_TZ_START_ADDR_L_SHIFT))

#define  MC_TZ_RANGE15_LOW_RESERVED1_MASK 0xfe000
#define  MC_TZ_RANGE15_LOW_RESERVED1_SHIFT 13
#define  MC_TZ_RANGE15_LOW_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE15_LOW_RESERVED1_MASK) >> MC_TZ_RANGE15_LOW_RESERVED1_SHIFT)
#define  MC_TZ_RANGE15_LOW_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE15_LOW_RESERVED1_MASK) | (((uint32_t)val) << MC_TZ_RANGE15_LOW_RESERVED1_SHIFT))

#define  MC_TZ_RANGE15_LOW_TZ_AREA_LEN_MASK 0x1f00
#define  MC_TZ_RANGE15_LOW_TZ_AREA_LEN_SHIFT 8
#define  MC_TZ_RANGE15_LOW_TZ_AREA_LEN_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE15_LOW_TZ_AREA_LEN_MASK) >> MC_TZ_RANGE15_LOW_TZ_AREA_LEN_SHIFT)
#define  MC_TZ_RANGE15_LOW_TZ_AREA_LEN_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE15_LOW_TZ_AREA_LEN_MASK) | (((uint32_t)val) << MC_TZ_RANGE15_LOW_TZ_AREA_LEN_SHIFT))

#define  MC_TZ_RANGE15_LOW_RESERVED2_MASK 0xf0
#define  MC_TZ_RANGE15_LOW_RESERVED2_SHIFT 4
#define  MC_TZ_RANGE15_LOW_RESERVED2_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE15_LOW_RESERVED2_MASK) >> MC_TZ_RANGE15_LOW_RESERVED2_SHIFT)
#define  MC_TZ_RANGE15_LOW_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE15_LOW_RESERVED2_MASK) | (((uint32_t)val) << MC_TZ_RANGE15_LOW_RESERVED2_SHIFT))

#define  MC_TZ_RANGE15_LOW_RZ_ENB_MASK 0x8
#define  MC_TZ_RANGE15_LOW_RZ_ENB_SHIFT 3
#define  MC_TZ_RANGE15_LOW_RZ_ENB_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE15_LOW_RZ_ENB_MASK) >> MC_TZ_RANGE15_LOW_RZ_ENB_SHIFT)
#define  MC_TZ_RANGE15_LOW_RZ_ENB_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE15_LOW_RZ_ENB_MASK) | (((uint32_t)val) << MC_TZ_RANGE15_LOW_RZ_ENB_SHIFT))

#define  MC_TZ_RANGE15_LOW_TZ_PERM_MASK 0x6
#define  MC_TZ_RANGE15_LOW_TZ_PERM_SHIFT 1
#define  MC_TZ_RANGE15_LOW_TZ_PERM_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE15_LOW_TZ_PERM_MASK) >> MC_TZ_RANGE15_LOW_TZ_PERM_SHIFT)
#define  MC_TZ_RANGE15_LOW_TZ_PERM_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE15_LOW_TZ_PERM_MASK) | (((uint32_t)val) << MC_TZ_RANGE15_LOW_TZ_PERM_SHIFT))

#define  MC_TZ_RANGE15_LOW_TZ_VALID_MASK 0x1
#define  MC_TZ_RANGE15_LOW_TZ_VALID_SHIFT 0
#define  MC_TZ_RANGE15_LOW_TZ_VALID_MASK_SHIFT(reg) (((reg) & MC_TZ_RANGE15_LOW_TZ_VALID_MASK) >> MC_TZ_RANGE15_LOW_TZ_VALID_SHIFT)
#define  MC_TZ_RANGE15_LOW_TZ_VALID_REPLACE_VAL(reg,val) (((reg) & ~MC_TZ_RANGE15_LOW_TZ_VALID_MASK) | (((uint32_t)val) << MC_TZ_RANGE15_LOW_TZ_VALID_SHIFT))

//====================================================================
//Register: Write Command Buffer (WCB) Control Register (WCB_Control)
//====================================================================

#define  MC_WCB_CONTROL_RESERVED1_MASK 0xfffffff8
#define  MC_WCB_CONTROL_RESERVED1_SHIFT 3
#define  MC_WCB_CONTROL_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_WCB_CONTROL_RESERVED1_MASK) >> MC_WCB_CONTROL_RESERVED1_SHIFT)
#define  MC_WCB_CONTROL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_WCB_CONTROL_RESERVED1_MASK) | (((uint32_t)val) << MC_WCB_CONTROL_RESERVED1_SHIFT))

#define  MC_WCB_CONTROL_WCB_DRAIN_LEVEL_MASK 0x6
#define  MC_WCB_CONTROL_WCB_DRAIN_LEVEL_SHIFT 1
#define  MC_WCB_CONTROL_WCB_DRAIN_LEVEL_MASK_SHIFT(reg) (((reg) & MC_WCB_CONTROL_WCB_DRAIN_LEVEL_MASK) >> MC_WCB_CONTROL_WCB_DRAIN_LEVEL_SHIFT)
#define  MC_WCB_CONTROL_WCB_DRAIN_LEVEL_REPLACE_VAL(reg,val) (((reg) & ~MC_WCB_CONTROL_WCB_DRAIN_LEVEL_MASK) | (((uint32_t)val) << MC_WCB_CONTROL_WCB_DRAIN_LEVEL_SHIFT))

#define  MC_WCB_CONTROL_AUTO_WCB_DRAIN_EN_MASK 0x1
#define  MC_WCB_CONTROL_AUTO_WCB_DRAIN_EN_SHIFT 0
#define  MC_WCB_CONTROL_AUTO_WCB_DRAIN_EN_MASK_SHIFT(reg) (((reg) & MC_WCB_CONTROL_AUTO_WCB_DRAIN_EN_MASK) >> MC_WCB_CONTROL_AUTO_WCB_DRAIN_EN_SHIFT)
#define  MC_WCB_CONTROL_AUTO_WCB_DRAIN_EN_REPLACE_VAL(reg,val) (((reg) & ~MC_WCB_CONTROL_AUTO_WCB_DRAIN_EN_MASK) | (((uint32_t)val) << MC_WCB_CONTROL_AUTO_WCB_DRAIN_EN_SHIFT))

//====================================================================
//Register: DRAM Maximum Power-Down timing Register (CH0_dram_mpd_timing)
//====================================================================

#define  MC_CH0_DRAM_MPD_TIMING_RESERVED1_MASK 0xfffe0000
#define  MC_CH0_DRAM_MPD_TIMING_RESERVED1_SHIFT 17
#define  MC_CH0_DRAM_MPD_TIMING_RESERVED1_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_MPD_TIMING_RESERVED1_MASK) >> MC_CH0_DRAM_MPD_TIMING_RESERVED1_SHIFT)
#define  MC_CH0_DRAM_MPD_TIMING_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_MPD_TIMING_RESERVED1_MASK) | (((uint32_t)val) << MC_CH0_DRAM_MPD_TIMING_RESERVED1_SHIFT))

#define  MC_CH0_DRAM_MPD_TIMING_TMPX_S_MASK 0x1c000
#define  MC_CH0_DRAM_MPD_TIMING_TMPX_S_SHIFT 14
#define  MC_CH0_DRAM_MPD_TIMING_TMPX_S_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_MPD_TIMING_TMPX_S_MASK) >> MC_CH0_DRAM_MPD_TIMING_TMPX_S_SHIFT)
#define  MC_CH0_DRAM_MPD_TIMING_TMPX_S_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_MPD_TIMING_TMPX_S_MASK) | (((uint32_t)val) << MC_CH0_DRAM_MPD_TIMING_TMPX_S_SHIFT))

#define  MC_CH0_DRAM_MPD_TIMING_TMPX_LH_MASK 0x3c00
#define  MC_CH0_DRAM_MPD_TIMING_TMPX_LH_SHIFT 10
#define  MC_CH0_DRAM_MPD_TIMING_TMPX_LH_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_MPD_TIMING_TMPX_LH_MASK) >> MC_CH0_DRAM_MPD_TIMING_TMPX_LH_SHIFT)
#define  MC_CH0_DRAM_MPD_TIMING_TMPX_LH_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_MPD_TIMING_TMPX_LH_MASK) | (((uint32_t)val) << MC_CH0_DRAM_MPD_TIMING_TMPX_LH_SHIFT))

#define  MC_CH0_DRAM_MPD_TIMING_TXMP_MASK 0x3ff
#define  MC_CH0_DRAM_MPD_TIMING_TXMP_SHIFT 0
#define  MC_CH0_DRAM_MPD_TIMING_TXMP_MASK_SHIFT(reg) (((reg) & MC_CH0_DRAM_MPD_TIMING_TXMP_MASK) >> MC_CH0_DRAM_MPD_TIMING_TXMP_SHIFT)
#define  MC_CH0_DRAM_MPD_TIMING_TXMP_REPLACE_VAL(reg,val) (((reg) & ~MC_CH0_DRAM_MPD_TIMING_TXMP_MASK) | (((uint32_t)val) << MC_CH0_DRAM_MPD_TIMING_TXMP_SHIFT))

#endif // MC
