 /*
 **************************************************************************************
 *
 * (c) Copyright 2013 Marvell International Ltd.
 *
 *
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/.
 *
 **************************************************************************************
 *
 * \file LVDS_regmasks.h
 * Generated using RegBuild 1.6.3
 *
 **************************************************************************************
 */

#ifndef _LVDS_REGMASKS_H_
#define _LVDS_REGMASKS_H_

#ifndef __KERNEL__
#include <stdint.h>
#endif

//====================================================================
//
//Register File: LVDS PHY Configuration and Status Registers (LVDS)
/** \brief These registers support the LVDS_PHY interface.*/
//
//====================================================================

//====================================================================
//Register: LVDS PHY Control0 Register (CTRL0)
/** \brief The names of register fields are identical to the port names of the hardmacro model.
     See lvds_6tx_pll specification/datasheet document for usage of the register bits.*/
//====================================================================

#define  LVDS_CTRL0_RESERVE_I0_MASK 0xff000000
#define  LVDS_CTRL0_RESERVE_I0_SHIFT 24
#define  LVDS_CTRL0_RESERVE_I0_MASK_SHIFT(reg) (((reg) & LVDS_CTRL0_RESERVE_I0_MASK) >> LVDS_CTRL0_RESERVE_I0_SHIFT)
#define  LVDS_CTRL0_RESERVE_I0_REPLACE_VAL(reg,val) (((reg) & ~LVDS_CTRL0_RESERVE_I0_MASK) | (((uint32_t)val) << LVDS_CTRL0_RESERVE_I0_SHIFT))

#define  LVDS_CTRL0_PU_MASK 0x800000
#define  LVDS_CTRL0_PU_SHIFT 23
#define  LVDS_CTRL0_PU_MASK_SHIFT(reg) (((reg) & LVDS_CTRL0_PU_MASK) >> LVDS_CTRL0_PU_SHIFT)
#define  LVDS_CTRL0_PU_REPLACE_VAL(reg,val) (((reg) & ~LVDS_CTRL0_PU_MASK) | (((uint32_t)val) << LVDS_CTRL0_PU_SHIFT))

#define  LVDS_CTRL0_DIG_TSTPNT_MASK 0x7f8000
#define  LVDS_CTRL0_DIG_TSTPNT_SHIFT 15
#define  LVDS_CTRL0_DIG_TSTPNT_MASK_SHIFT(reg) (((reg) & LVDS_CTRL0_DIG_TSTPNT_MASK) >> LVDS_CTRL0_DIG_TSTPNT_SHIFT)
#define  LVDS_CTRL0_DIG_TSTPNT_REPLACE_VAL(reg,val) (((reg) & ~LVDS_CTRL0_DIG_TSTPNT_MASK) | (((uint32_t)val) << LVDS_CTRL0_DIG_TSTPNT_SHIFT))

#define  LVDS_CTRL0_D_NBITS_MASK 0x6000
#define  LVDS_CTRL0_D_NBITS_SHIFT 13
#define  LVDS_CTRL0_D_NBITS_MASK_SHIFT(reg) (((reg) & LVDS_CTRL0_D_NBITS_MASK) >> LVDS_CTRL0_D_NBITS_SHIFT)
#define  LVDS_CTRL0_D_NBITS_REPLACE_VAL(reg,val) (((reg) & ~LVDS_CTRL0_D_NBITS_MASK) | (((uint32_t)val) << LVDS_CTRL0_D_NBITS_SHIFT))

#define  LVDS_CTRL0_BIST_STRT_MASK 0x1000
#define  LVDS_CTRL0_BIST_STRT_SHIFT 12
#define  LVDS_CTRL0_BIST_STRT_MASK_SHIFT(reg) (((reg) & LVDS_CTRL0_BIST_STRT_MASK) >> LVDS_CTRL0_BIST_STRT_SHIFT)
#define  LVDS_CTRL0_BIST_STRT_REPLACE_VAL(reg,val) (((reg) & ~LVDS_CTRL0_BIST_STRT_MASK) | (((uint32_t)val) << LVDS_CTRL0_BIST_STRT_SHIFT))

#define  LVDS_CTRL0_BIST_PAT_MASK 0xc00
#define  LVDS_CTRL0_BIST_PAT_SHIFT 10
#define  LVDS_CTRL0_BIST_PAT_MASK_SHIFT(reg) (((reg) & LVDS_CTRL0_BIST_PAT_MASK) >> LVDS_CTRL0_BIST_PAT_SHIFT)
#define  LVDS_CTRL0_BIST_PAT_REPLACE_VAL(reg,val) (((reg) & ~LVDS_CTRL0_BIST_PAT_MASK) | (((uint32_t)val) << LVDS_CTRL0_BIST_PAT_SHIFT))

#define  LVDS_CTRL0_BIST_DGEN_MASK 0x200
#define  LVDS_CTRL0_BIST_DGEN_SHIFT 9
#define  LVDS_CTRL0_BIST_DGEN_MASK_SHIFT(reg) (((reg) & LVDS_CTRL0_BIST_DGEN_MASK) >> LVDS_CTRL0_BIST_DGEN_SHIFT)
#define  LVDS_CTRL0_BIST_DGEN_REPLACE_VAL(reg,val) (((reg) & ~LVDS_CTRL0_BIST_DGEN_MASK) | (((uint32_t)val) << LVDS_CTRL0_BIST_DGEN_SHIFT))

#define  LVDS_CTRL0_BIST_CK_PH_MASK 0x100
#define  LVDS_CTRL0_BIST_CK_PH_SHIFT 8
#define  LVDS_CTRL0_BIST_CK_PH_MASK_SHIFT(reg) (((reg) & LVDS_CTRL0_BIST_CK_PH_MASK) >> LVDS_CTRL0_BIST_CK_PH_SHIFT)
#define  LVDS_CTRL0_BIST_CK_PH_REPLACE_VAL(reg,val) (((reg) & ~LVDS_CTRL0_BIST_CK_PH_MASK) | (((uint32_t)val) << LVDS_CTRL0_BIST_CK_PH_SHIFT))

#define  LVDS_CTRL0_ANA_TSTPNT_MASK 0xff
#define  LVDS_CTRL0_ANA_TSTPNT_SHIFT 0
#define  LVDS_CTRL0_ANA_TSTPNT_MASK_SHIFT(reg) (((reg) & LVDS_CTRL0_ANA_TSTPNT_MASK) >> LVDS_CTRL0_ANA_TSTPNT_SHIFT)
#define  LVDS_CTRL0_ANA_TSTPNT_REPLACE_VAL(reg,val) (((reg) & ~LVDS_CTRL0_ANA_TSTPNT_MASK) | (((uint32_t)val) << LVDS_CTRL0_ANA_TSTPNT_SHIFT))

//====================================================================
//Register: LVDS PHY Control1 Register (CTRL1)
/** \brief The names of register fields are identical to the port names of the hardmacro model.
     See lvds_6tx_pll specification/datasheet document for usage of the register bits.*/
//====================================================================

#define  LVDS_CTRL1_RESERVE_I4_MASK 0xff000000
#define  LVDS_CTRL1_RESERVE_I4_SHIFT 24
#define  LVDS_CTRL1_RESERVE_I4_MASK_SHIFT(reg) (((reg) & LVDS_CTRL1_RESERVE_I4_MASK) >> LVDS_CTRL1_RESERVE_I4_SHIFT)
#define  LVDS_CTRL1_RESERVE_I4_REPLACE_VAL(reg,val) (((reg) & ~LVDS_CTRL1_RESERVE_I4_MASK) | (((uint32_t)val) << LVDS_CTRL1_RESERVE_I4_SHIFT))

#define  LVDS_CTRL1_RESERVE_I3_MASK 0xff0000
#define  LVDS_CTRL1_RESERVE_I3_SHIFT 16
#define  LVDS_CTRL1_RESERVE_I3_MASK_SHIFT(reg) (((reg) & LVDS_CTRL1_RESERVE_I3_MASK) >> LVDS_CTRL1_RESERVE_I3_SHIFT)
#define  LVDS_CTRL1_RESERVE_I3_REPLACE_VAL(reg,val) (((reg) & ~LVDS_CTRL1_RESERVE_I3_MASK) | (((uint32_t)val) << LVDS_CTRL1_RESERVE_I3_SHIFT))

#define  LVDS_CTRL1_RESERVE_I2_MASK 0xff00
#define  LVDS_CTRL1_RESERVE_I2_SHIFT 8
#define  LVDS_CTRL1_RESERVE_I2_MASK_SHIFT(reg) (((reg) & LVDS_CTRL1_RESERVE_I2_MASK) >> LVDS_CTRL1_RESERVE_I2_SHIFT)
#define  LVDS_CTRL1_RESERVE_I2_REPLACE_VAL(reg,val) (((reg) & ~LVDS_CTRL1_RESERVE_I2_MASK) | (((uint32_t)val) << LVDS_CTRL1_RESERVE_I2_SHIFT))

#define  LVDS_CTRL1_RESERVE_I1_MASK 0xff
#define  LVDS_CTRL1_RESERVE_I1_SHIFT 0
#define  LVDS_CTRL1_RESERVE_I1_MASK_SHIFT(reg) (((reg) & LVDS_CTRL1_RESERVE_I1_MASK) >> LVDS_CTRL1_RESERVE_I1_SHIFT)
#define  LVDS_CTRL1_RESERVE_I1_REPLACE_VAL(reg,val) (((reg) & ~LVDS_CTRL1_RESERVE_I1_MASK) | (((uint32_t)val) << LVDS_CTRL1_RESERVE_I1_SHIFT))

//====================================================================
//Register: LVDS PHY Control2 Register (CTRL2)
/** \brief The names of register fields are identical to the port names of the hardmacro model.
     See lvds_6tx_pll specification/datasheet document for usage of the register bits.*/
//====================================================================

#define  LVDS_CTRL2_TX_OE5_MASK 0x80000000
#define  LVDS_CTRL2_TX_OE5_SHIFT 31
#define  LVDS_CTRL2_TX_OE5_MASK_SHIFT(reg) (((reg) & LVDS_CTRL2_TX_OE5_MASK) >> LVDS_CTRL2_TX_OE5_SHIFT)
#define  LVDS_CTRL2_TX_OE5_REPLACE_VAL(reg,val) (((reg) & ~LVDS_CTRL2_TX_OE5_MASK) | (((uint32_t)val) << LVDS_CTRL2_TX_OE5_SHIFT))

#define  LVDS_CTRL2_TX_OE4_MASK 0x40000000
#define  LVDS_CTRL2_TX_OE4_SHIFT 30
#define  LVDS_CTRL2_TX_OE4_MASK_SHIFT(reg) (((reg) & LVDS_CTRL2_TX_OE4_MASK) >> LVDS_CTRL2_TX_OE4_SHIFT)
#define  LVDS_CTRL2_TX_OE4_REPLACE_VAL(reg,val) (((reg) & ~LVDS_CTRL2_TX_OE4_MASK) | (((uint32_t)val) << LVDS_CTRL2_TX_OE4_SHIFT))

#define  LVDS_CTRL2_TX_OE3_MASK 0x20000000
#define  LVDS_CTRL2_TX_OE3_SHIFT 29
#define  LVDS_CTRL2_TX_OE3_MASK_SHIFT(reg) (((reg) & LVDS_CTRL2_TX_OE3_MASK) >> LVDS_CTRL2_TX_OE3_SHIFT)
#define  LVDS_CTRL2_TX_OE3_REPLACE_VAL(reg,val) (((reg) & ~LVDS_CTRL2_TX_OE3_MASK) | (((uint32_t)val) << LVDS_CTRL2_TX_OE3_SHIFT))

#define  LVDS_CTRL2_TX_OE2_MASK 0x10000000
#define  LVDS_CTRL2_TX_OE2_SHIFT 28
#define  LVDS_CTRL2_TX_OE2_MASK_SHIFT(reg) (((reg) & LVDS_CTRL2_TX_OE2_MASK) >> LVDS_CTRL2_TX_OE2_SHIFT)
#define  LVDS_CTRL2_TX_OE2_REPLACE_VAL(reg,val) (((reg) & ~LVDS_CTRL2_TX_OE2_MASK) | (((uint32_t)val) << LVDS_CTRL2_TX_OE2_SHIFT))

#define  LVDS_CTRL2_TX_OE1_MASK 0x8000000
#define  LVDS_CTRL2_TX_OE1_SHIFT 27
#define  LVDS_CTRL2_TX_OE1_MASK_SHIFT(reg) (((reg) & LVDS_CTRL2_TX_OE1_MASK) >> LVDS_CTRL2_TX_OE1_SHIFT)
#define  LVDS_CTRL2_TX_OE1_REPLACE_VAL(reg,val) (((reg) & ~LVDS_CTRL2_TX_OE1_MASK) | (((uint32_t)val) << LVDS_CTRL2_TX_OE1_SHIFT))

#define  LVDS_CTRL2_TX_OE0_MASK 0x4000000
#define  LVDS_CTRL2_TX_OE0_SHIFT 26
#define  LVDS_CTRL2_TX_OE0_MASK_SHIFT(reg) (((reg) & LVDS_CTRL2_TX_OE0_MASK) >> LVDS_CTRL2_TX_OE0_SHIFT)
#define  LVDS_CTRL2_TX_OE0_REPLACE_VAL(reg,val) (((reg) & ~LVDS_CTRL2_TX_OE0_MASK) | (((uint32_t)val) << LVDS_CTRL2_TX_OE0_SHIFT))

#define  LVDS_CTRL2_TX_EMPH_SWING5_MASK 0x3000000
#define  LVDS_CTRL2_TX_EMPH_SWING5_SHIFT 24
#define  LVDS_CTRL2_TX_EMPH_SWING5_MASK_SHIFT(reg) (((reg) & LVDS_CTRL2_TX_EMPH_SWING5_MASK) >> LVDS_CTRL2_TX_EMPH_SWING5_SHIFT)
#define  LVDS_CTRL2_TX_EMPH_SWING5_REPLACE_VAL(reg,val) (((reg) & ~LVDS_CTRL2_TX_EMPH_SWING5_MASK) | (((uint32_t)val) << LVDS_CTRL2_TX_EMPH_SWING5_SHIFT))

#define  LVDS_CTRL2_TX_EMPH_SWING4_MASK 0xc00000
#define  LVDS_CTRL2_TX_EMPH_SWING4_SHIFT 22
#define  LVDS_CTRL2_TX_EMPH_SWING4_MASK_SHIFT(reg) (((reg) & LVDS_CTRL2_TX_EMPH_SWING4_MASK) >> LVDS_CTRL2_TX_EMPH_SWING4_SHIFT)
#define  LVDS_CTRL2_TX_EMPH_SWING4_REPLACE_VAL(reg,val) (((reg) & ~LVDS_CTRL2_TX_EMPH_SWING4_MASK) | (((uint32_t)val) << LVDS_CTRL2_TX_EMPH_SWING4_SHIFT))

#define  LVDS_CTRL2_TX_EMPH_SWING3_MASK 0x300000
#define  LVDS_CTRL2_TX_EMPH_SWING3_SHIFT 20
#define  LVDS_CTRL2_TX_EMPH_SWING3_MASK_SHIFT(reg) (((reg) & LVDS_CTRL2_TX_EMPH_SWING3_MASK) >> LVDS_CTRL2_TX_EMPH_SWING3_SHIFT)
#define  LVDS_CTRL2_TX_EMPH_SWING3_REPLACE_VAL(reg,val) (((reg) & ~LVDS_CTRL2_TX_EMPH_SWING3_MASK) | (((uint32_t)val) << LVDS_CTRL2_TX_EMPH_SWING3_SHIFT))

#define  LVDS_CTRL2_TX_EMPH_SWING2_MASK 0xc0000
#define  LVDS_CTRL2_TX_EMPH_SWING2_SHIFT 18
#define  LVDS_CTRL2_TX_EMPH_SWING2_MASK_SHIFT(reg) (((reg) & LVDS_CTRL2_TX_EMPH_SWING2_MASK) >> LVDS_CTRL2_TX_EMPH_SWING2_SHIFT)
#define  LVDS_CTRL2_TX_EMPH_SWING2_REPLACE_VAL(reg,val) (((reg) & ~LVDS_CTRL2_TX_EMPH_SWING2_MASK) | (((uint32_t)val) << LVDS_CTRL2_TX_EMPH_SWING2_SHIFT))

#define  LVDS_CTRL2_TX_EMPH_SWING1_MASK 0x30000
#define  LVDS_CTRL2_TX_EMPH_SWING1_SHIFT 16
#define  LVDS_CTRL2_TX_EMPH_SWING1_MASK_SHIFT(reg) (((reg) & LVDS_CTRL2_TX_EMPH_SWING1_MASK) >> LVDS_CTRL2_TX_EMPH_SWING1_SHIFT)
#define  LVDS_CTRL2_TX_EMPH_SWING1_REPLACE_VAL(reg,val) (((reg) & ~LVDS_CTRL2_TX_EMPH_SWING1_MASK) | (((uint32_t)val) << LVDS_CTRL2_TX_EMPH_SWING1_SHIFT))

#define  LVDS_CTRL2_TX_EMPH_SWING0_MASK 0xc000
#define  LVDS_CTRL2_TX_EMPH_SWING0_SHIFT 14
#define  LVDS_CTRL2_TX_EMPH_SWING0_MASK_SHIFT(reg) (((reg) & LVDS_CTRL2_TX_EMPH_SWING0_MASK) >> LVDS_CTRL2_TX_EMPH_SWING0_SHIFT)
#define  LVDS_CTRL2_TX_EMPH_SWING0_REPLACE_VAL(reg,val) (((reg) & ~LVDS_CTRL2_TX_EMPH_SWING0_MASK) | (((uint32_t)val) << LVDS_CTRL2_TX_EMPH_SWING0_SHIFT))

#define  LVDS_CTRL2_TX_EMPH_EN5_MASK 0x2000
#define  LVDS_CTRL2_TX_EMPH_EN5_SHIFT 13
#define  LVDS_CTRL2_TX_EMPH_EN5_MASK_SHIFT(reg) (((reg) & LVDS_CTRL2_TX_EMPH_EN5_MASK) >> LVDS_CTRL2_TX_EMPH_EN5_SHIFT)
#define  LVDS_CTRL2_TX_EMPH_EN5_REPLACE_VAL(reg,val) (((reg) & ~LVDS_CTRL2_TX_EMPH_EN5_MASK) | (((uint32_t)val) << LVDS_CTRL2_TX_EMPH_EN5_SHIFT))

#define  LVDS_CTRL2_TX_EMPH_EN4_MASK 0x1000
#define  LVDS_CTRL2_TX_EMPH_EN4_SHIFT 12
#define  LVDS_CTRL2_TX_EMPH_EN4_MASK_SHIFT(reg) (((reg) & LVDS_CTRL2_TX_EMPH_EN4_MASK) >> LVDS_CTRL2_TX_EMPH_EN4_SHIFT)
#define  LVDS_CTRL2_TX_EMPH_EN4_REPLACE_VAL(reg,val) (((reg) & ~LVDS_CTRL2_TX_EMPH_EN4_MASK) | (((uint32_t)val) << LVDS_CTRL2_TX_EMPH_EN4_SHIFT))

#define  LVDS_CTRL2_TX_EMPH_EN3_MASK 0x800
#define  LVDS_CTRL2_TX_EMPH_EN3_SHIFT 11
#define  LVDS_CTRL2_TX_EMPH_EN3_MASK_SHIFT(reg) (((reg) & LVDS_CTRL2_TX_EMPH_EN3_MASK) >> LVDS_CTRL2_TX_EMPH_EN3_SHIFT)
#define  LVDS_CTRL2_TX_EMPH_EN3_REPLACE_VAL(reg,val) (((reg) & ~LVDS_CTRL2_TX_EMPH_EN3_MASK) | (((uint32_t)val) << LVDS_CTRL2_TX_EMPH_EN3_SHIFT))

#define  LVDS_CTRL2_TX_EMPH_EN2_MASK 0x400
#define  LVDS_CTRL2_TX_EMPH_EN2_SHIFT 10
#define  LVDS_CTRL2_TX_EMPH_EN2_MASK_SHIFT(reg) (((reg) & LVDS_CTRL2_TX_EMPH_EN2_MASK) >> LVDS_CTRL2_TX_EMPH_EN2_SHIFT)
#define  LVDS_CTRL2_TX_EMPH_EN2_REPLACE_VAL(reg,val) (((reg) & ~LVDS_CTRL2_TX_EMPH_EN2_MASK) | (((uint32_t)val) << LVDS_CTRL2_TX_EMPH_EN2_SHIFT))

#define  LVDS_CTRL2_TX_EMPH_EN1_MASK 0x200
#define  LVDS_CTRL2_TX_EMPH_EN1_SHIFT 9
#define  LVDS_CTRL2_TX_EMPH_EN1_MASK_SHIFT(reg) (((reg) & LVDS_CTRL2_TX_EMPH_EN1_MASK) >> LVDS_CTRL2_TX_EMPH_EN1_SHIFT)
#define  LVDS_CTRL2_TX_EMPH_EN1_REPLACE_VAL(reg,val) (((reg) & ~LVDS_CTRL2_TX_EMPH_EN1_MASK) | (((uint32_t)val) << LVDS_CTRL2_TX_EMPH_EN1_SHIFT))

#define  LVDS_CTRL2_TX_EMPH_EN0_MASK 0x100
#define  LVDS_CTRL2_TX_EMPH_EN0_SHIFT 8
#define  LVDS_CTRL2_TX_EMPH_EN0_MASK_SHIFT(reg) (((reg) & LVDS_CTRL2_TX_EMPH_EN0_MASK) >> LVDS_CTRL2_TX_EMPH_EN0_SHIFT)
#define  LVDS_CTRL2_TX_EMPH_EN0_REPLACE_VAL(reg,val) (((reg) & ~LVDS_CTRL2_TX_EMPH_EN0_MASK) | (((uint32_t)val) << LVDS_CTRL2_TX_EMPH_EN0_SHIFT))

#define  LVDS_CTRL2_RESERVE_I5_MASK 0xff
#define  LVDS_CTRL2_RESERVE_I5_SHIFT 0
#define  LVDS_CTRL2_RESERVE_I5_MASK_SHIFT(reg) (((reg) & LVDS_CTRL2_RESERVE_I5_MASK) >> LVDS_CTRL2_RESERVE_I5_SHIFT)
#define  LVDS_CTRL2_RESERVE_I5_REPLACE_VAL(reg,val) (((reg) & ~LVDS_CTRL2_RESERVE_I5_MASK) | (((uint32_t)val) << LVDS_CTRL2_RESERVE_I5_SHIFT))

//====================================================================
//Register: LVDS PHY Control3 Register (CTRL3)
/** \brief The names of register fields are identical to the port names of the hardmacro model.
     See lvds_6tx_pll specification/datasheet document for usage of the register bits.*/
//====================================================================

#define  LVDS_CTRL3_TX_SR_MASK 0x80000000
#define  LVDS_CTRL3_TX_SR_SHIFT 31
#define  LVDS_CTRL3_TX_SR_MASK_SHIFT(reg) (((reg) & LVDS_CTRL3_TX_SR_MASK) >> LVDS_CTRL3_TX_SR_SHIFT)
#define  LVDS_CTRL3_TX_SR_REPLACE_VAL(reg,val) (((reg) & ~LVDS_CTRL3_TX_SR_MASK) | (((uint32_t)val) << LVDS_CTRL3_TX_SR_SHIFT))

#define  LVDS_CTRL3_TX_IMP_EN_MASK 0x40000000
#define  LVDS_CTRL3_TX_IMP_EN_SHIFT 30
#define  LVDS_CTRL3_TX_IMP_EN_MASK_SHIFT(reg) (((reg) & LVDS_CTRL3_TX_IMP_EN_MASK) >> LVDS_CTRL3_TX_IMP_EN_SHIFT)
#define  LVDS_CTRL3_TX_IMP_EN_REPLACE_VAL(reg,val) (((reg) & ~LVDS_CTRL3_TX_IMP_EN_MASK) | (((uint32_t)val) << LVDS_CTRL3_TX_IMP_EN_SHIFT))

#define  LVDS_CTRL3_TX_HB_DLY5_MASK 0x20000000
#define  LVDS_CTRL3_TX_HB_DLY5_SHIFT 29
#define  LVDS_CTRL3_TX_HB_DLY5_MASK_SHIFT(reg) (((reg) & LVDS_CTRL3_TX_HB_DLY5_MASK) >> LVDS_CTRL3_TX_HB_DLY5_SHIFT)
#define  LVDS_CTRL3_TX_HB_DLY5_REPLACE_VAL(reg,val) (((reg) & ~LVDS_CTRL3_TX_HB_DLY5_MASK) | (((uint32_t)val) << LVDS_CTRL3_TX_HB_DLY5_SHIFT))

#define  LVDS_CTRL3_TX_HB_DLY4_MASK 0x10000000
#define  LVDS_CTRL3_TX_HB_DLY4_SHIFT 28
#define  LVDS_CTRL3_TX_HB_DLY4_MASK_SHIFT(reg) (((reg) & LVDS_CTRL3_TX_HB_DLY4_MASK) >> LVDS_CTRL3_TX_HB_DLY4_SHIFT)
#define  LVDS_CTRL3_TX_HB_DLY4_REPLACE_VAL(reg,val) (((reg) & ~LVDS_CTRL3_TX_HB_DLY4_MASK) | (((uint32_t)val) << LVDS_CTRL3_TX_HB_DLY4_SHIFT))

#define  LVDS_CTRL3_TX_HB_DLY3_MASK 0x8000000
#define  LVDS_CTRL3_TX_HB_DLY3_SHIFT 27
#define  LVDS_CTRL3_TX_HB_DLY3_MASK_SHIFT(reg) (((reg) & LVDS_CTRL3_TX_HB_DLY3_MASK) >> LVDS_CTRL3_TX_HB_DLY3_SHIFT)
#define  LVDS_CTRL3_TX_HB_DLY3_REPLACE_VAL(reg,val) (((reg) & ~LVDS_CTRL3_TX_HB_DLY3_MASK) | (((uint32_t)val) << LVDS_CTRL3_TX_HB_DLY3_SHIFT))

#define  LVDS_CTRL3_TX_HB_DLY2_MASK 0x4000000
#define  LVDS_CTRL3_TX_HB_DLY2_SHIFT 26
#define  LVDS_CTRL3_TX_HB_DLY2_MASK_SHIFT(reg) (((reg) & LVDS_CTRL3_TX_HB_DLY2_MASK) >> LVDS_CTRL3_TX_HB_DLY2_SHIFT)
#define  LVDS_CTRL3_TX_HB_DLY2_REPLACE_VAL(reg,val) (((reg) & ~LVDS_CTRL3_TX_HB_DLY2_MASK) | (((uint32_t)val) << LVDS_CTRL3_TX_HB_DLY2_SHIFT))

#define  LVDS_CTRL3_TX_HB_DLY1_MASK 0x2000000
#define  LVDS_CTRL3_TX_HB_DLY1_SHIFT 25
#define  LVDS_CTRL3_TX_HB_DLY1_MASK_SHIFT(reg) (((reg) & LVDS_CTRL3_TX_HB_DLY1_MASK) >> LVDS_CTRL3_TX_HB_DLY1_SHIFT)
#define  LVDS_CTRL3_TX_HB_DLY1_REPLACE_VAL(reg,val) (((reg) & ~LVDS_CTRL3_TX_HB_DLY1_MASK) | (((uint32_t)val) << LVDS_CTRL3_TX_HB_DLY1_SHIFT))

#define  LVDS_CTRL3_TX_HB_DLY0_MASK 0x1000000
#define  LVDS_CTRL3_TX_HB_DLY0_SHIFT 24
#define  LVDS_CTRL3_TX_HB_DLY0_MASK_SHIFT(reg) (((reg) & LVDS_CTRL3_TX_HB_DLY0_MASK) >> LVDS_CTRL3_TX_HB_DLY0_SHIFT)
#define  LVDS_CTRL3_TX_HB_DLY0_REPLACE_VAL(reg,val) (((reg) & ~LVDS_CTRL3_TX_HB_DLY0_MASK) | (((uint32_t)val) << LVDS_CTRL3_TX_HB_DLY0_SHIFT))

#define  LVDS_CTRL3_TX_SWING5_MASK 0xe00000
#define  LVDS_CTRL3_TX_SWING5_SHIFT 21
#define  LVDS_CTRL3_TX_SWING5_MASK_SHIFT(reg) (((reg) & LVDS_CTRL3_TX_SWING5_MASK) >> LVDS_CTRL3_TX_SWING5_SHIFT)
#define  LVDS_CTRL3_TX_SWING5_REPLACE_VAL(reg,val) (((reg) & ~LVDS_CTRL3_TX_SWING5_MASK) | (((uint32_t)val) << LVDS_CTRL3_TX_SWING5_SHIFT))

#define  LVDS_CTRL3_TX_SWING4_MASK 0x1c0000
#define  LVDS_CTRL3_TX_SWING4_SHIFT 18
#define  LVDS_CTRL3_TX_SWING4_MASK_SHIFT(reg) (((reg) & LVDS_CTRL3_TX_SWING4_MASK) >> LVDS_CTRL3_TX_SWING4_SHIFT)
#define  LVDS_CTRL3_TX_SWING4_REPLACE_VAL(reg,val) (((reg) & ~LVDS_CTRL3_TX_SWING4_MASK) | (((uint32_t)val) << LVDS_CTRL3_TX_SWING4_SHIFT))

#define  LVDS_CTRL3_TX_SWING3_MASK 0x38000
#define  LVDS_CTRL3_TX_SWING3_SHIFT 15
#define  LVDS_CTRL3_TX_SWING3_MASK_SHIFT(reg) (((reg) & LVDS_CTRL3_TX_SWING3_MASK) >> LVDS_CTRL3_TX_SWING3_SHIFT)
#define  LVDS_CTRL3_TX_SWING3_REPLACE_VAL(reg,val) (((reg) & ~LVDS_CTRL3_TX_SWING3_MASK) | (((uint32_t)val) << LVDS_CTRL3_TX_SWING3_SHIFT))

#define  LVDS_CTRL3_TX_SWING2_MASK 0x7000
#define  LVDS_CTRL3_TX_SWING2_SHIFT 12
#define  LVDS_CTRL3_TX_SWING2_MASK_SHIFT(reg) (((reg) & LVDS_CTRL3_TX_SWING2_MASK) >> LVDS_CTRL3_TX_SWING2_SHIFT)
#define  LVDS_CTRL3_TX_SWING2_REPLACE_VAL(reg,val) (((reg) & ~LVDS_CTRL3_TX_SWING2_MASK) | (((uint32_t)val) << LVDS_CTRL3_TX_SWING2_SHIFT))

#define  LVDS_CTRL3_TX_SWING1_MASK 0xe00
#define  LVDS_CTRL3_TX_SWING1_SHIFT 9
#define  LVDS_CTRL3_TX_SWING1_MASK_SHIFT(reg) (((reg) & LVDS_CTRL3_TX_SWING1_MASK) >> LVDS_CTRL3_TX_SWING1_SHIFT)
#define  LVDS_CTRL3_TX_SWING1_REPLACE_VAL(reg,val) (((reg) & ~LVDS_CTRL3_TX_SWING1_MASK) | (((uint32_t)val) << LVDS_CTRL3_TX_SWING1_SHIFT))

#define  LVDS_CTRL3_TX_SWING0_MASK 0x1c0
#define  LVDS_CTRL3_TX_SWING0_SHIFT 6
#define  LVDS_CTRL3_TX_SWING0_MASK_SHIFT(reg) (((reg) & LVDS_CTRL3_TX_SWING0_MASK) >> LVDS_CTRL3_TX_SWING0_SHIFT)
#define  LVDS_CTRL3_TX_SWING0_REPLACE_VAL(reg,val) (((reg) & ~LVDS_CTRL3_TX_SWING0_MASK) | (((uint32_t)val) << LVDS_CTRL3_TX_SWING0_SHIFT))

#define  LVDS_CTRL3_TX_POL_INV5_MASK 0x20
#define  LVDS_CTRL3_TX_POL_INV5_SHIFT 5
#define  LVDS_CTRL3_TX_POL_INV5_MASK_SHIFT(reg) (((reg) & LVDS_CTRL3_TX_POL_INV5_MASK) >> LVDS_CTRL3_TX_POL_INV5_SHIFT)
#define  LVDS_CTRL3_TX_POL_INV5_REPLACE_VAL(reg,val) (((reg) & ~LVDS_CTRL3_TX_POL_INV5_MASK) | (((uint32_t)val) << LVDS_CTRL3_TX_POL_INV5_SHIFT))

#define  LVDS_CTRL3_TX_POL_INV4_MASK 0x10
#define  LVDS_CTRL3_TX_POL_INV4_SHIFT 4
#define  LVDS_CTRL3_TX_POL_INV4_MASK_SHIFT(reg) (((reg) & LVDS_CTRL3_TX_POL_INV4_MASK) >> LVDS_CTRL3_TX_POL_INV4_SHIFT)
#define  LVDS_CTRL3_TX_POL_INV4_REPLACE_VAL(reg,val) (((reg) & ~LVDS_CTRL3_TX_POL_INV4_MASK) | (((uint32_t)val) << LVDS_CTRL3_TX_POL_INV4_SHIFT))

#define  LVDS_CTRL3_TX_POL_INV3_MASK 0x8
#define  LVDS_CTRL3_TX_POL_INV3_SHIFT 3
#define  LVDS_CTRL3_TX_POL_INV3_MASK_SHIFT(reg) (((reg) & LVDS_CTRL3_TX_POL_INV3_MASK) >> LVDS_CTRL3_TX_POL_INV3_SHIFT)
#define  LVDS_CTRL3_TX_POL_INV3_REPLACE_VAL(reg,val) (((reg) & ~LVDS_CTRL3_TX_POL_INV3_MASK) | (((uint32_t)val) << LVDS_CTRL3_TX_POL_INV3_SHIFT))

#define  LVDS_CTRL3_TX_POL_INV2_MASK 0x4
#define  LVDS_CTRL3_TX_POL_INV2_SHIFT 2
#define  LVDS_CTRL3_TX_POL_INV2_MASK_SHIFT(reg) (((reg) & LVDS_CTRL3_TX_POL_INV2_MASK) >> LVDS_CTRL3_TX_POL_INV2_SHIFT)
#define  LVDS_CTRL3_TX_POL_INV2_REPLACE_VAL(reg,val) (((reg) & ~LVDS_CTRL3_TX_POL_INV2_MASK) | (((uint32_t)val) << LVDS_CTRL3_TX_POL_INV2_SHIFT))

#define  LVDS_CTRL3_TX_POL_INV1_MASK 0x2
#define  LVDS_CTRL3_TX_POL_INV1_SHIFT 1
#define  LVDS_CTRL3_TX_POL_INV1_MASK_SHIFT(reg) (((reg) & LVDS_CTRL3_TX_POL_INV1_MASK) >> LVDS_CTRL3_TX_POL_INV1_SHIFT)
#define  LVDS_CTRL3_TX_POL_INV1_REPLACE_VAL(reg,val) (((reg) & ~LVDS_CTRL3_TX_POL_INV1_MASK) | (((uint32_t)val) << LVDS_CTRL3_TX_POL_INV1_SHIFT))

#define  LVDS_CTRL3_TX_POL_INV0_MASK 0x1
#define  LVDS_CTRL3_TX_POL_INV0_SHIFT 0
#define  LVDS_CTRL3_TX_POL_INV0_MASK_SHIFT(reg) (((reg) & LVDS_CTRL3_TX_POL_INV0_MASK) >> LVDS_CTRL3_TX_POL_INV0_SHIFT)
#define  LVDS_CTRL3_TX_POL_INV0_REPLACE_VAL(reg,val) (((reg) & ~LVDS_CTRL3_TX_POL_INV0_MASK) | (((uint32_t)val) << LVDS_CTRL3_TX_POL_INV0_SHIFT))

//====================================================================
//Register: LVDS PHY Impedance Control0 Register (IMP_CTRL0)
/** \brief The names of register fields are identical to the port names of the hardmacro model.
     See lvds_6tx_pll specification/datasheet document for usage of the register bits.*/
//====================================================================

#define  LVDS_IMP_CTRL0_RESERVED1_MASK 0xf0000000
#define  LVDS_IMP_CTRL0_RESERVED1_SHIFT 28
#define  LVDS_IMP_CTRL0_RESERVED1_MASK_SHIFT(reg) (((reg) & LVDS_IMP_CTRL0_RESERVED1_MASK) >> LVDS_IMP_CTRL0_RESERVED1_SHIFT)
#define  LVDS_IMP_CTRL0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~LVDS_IMP_CTRL0_RESERVED1_MASK) | (((uint32_t)val) << LVDS_IMP_CTRL0_RESERVED1_SHIFT))

#define  LVDS_IMP_CTRL0_SBY_VSSR_MASK 0xe000000
#define  LVDS_IMP_CTRL0_SBY_VSSR_SHIFT 25
#define  LVDS_IMP_CTRL0_SBY_VSSR_MASK_SHIFT(reg) (((reg) & LVDS_IMP_CTRL0_SBY_VSSR_MASK) >> LVDS_IMP_CTRL0_SBY_VSSR_SHIFT)
#define  LVDS_IMP_CTRL0_SBY_VSSR_REPLACE_VAL(reg,val) (((reg) & ~LVDS_IMP_CTRL0_SBY_VSSR_MASK) | (((uint32_t)val) << LVDS_IMP_CTRL0_SBY_VSSR_SHIFT))

#define  LVDS_IMP_CTRL0_VSW_VSSR_MASK 0x1c00000
#define  LVDS_IMP_CTRL0_VSW_VSSR_SHIFT 22
#define  LVDS_IMP_CTRL0_VSW_VSSR_MASK_SHIFT(reg) (((reg) & LVDS_IMP_CTRL0_VSW_VSSR_MASK) >> LVDS_IMP_CTRL0_VSW_VSSR_SHIFT)
#define  LVDS_IMP_CTRL0_VSW_VSSR_REPLACE_VAL(reg,val) (((reg) & ~LVDS_IMP_CTRL0_VSW_VSSR_MASK) | (((uint32_t)val) << LVDS_IMP_CTRL0_VSW_VSSR_SHIFT))

#define  LVDS_IMP_CTRL0_VCM_SET_MASK 0x380000
#define  LVDS_IMP_CTRL0_VCM_SET_SHIFT 19
#define  LVDS_IMP_CTRL0_VCM_SET_MASK_SHIFT(reg) (((reg) & LVDS_IMP_CTRL0_VCM_SET_MASK) >> LVDS_IMP_CTRL0_VCM_SET_SHIFT)
#define  LVDS_IMP_CTRL0_VCM_SET_REPLACE_VAL(reg,val) (((reg) & ~LVDS_IMP_CTRL0_VCM_SET_MASK) | (((uint32_t)val) << LVDS_IMP_CTRL0_VCM_SET_SHIFT))

#define  LVDS_IMP_CTRL0_RESERVE_IR_MASK 0x7f800
#define  LVDS_IMP_CTRL0_RESERVE_IR_SHIFT 11
#define  LVDS_IMP_CTRL0_RESERVE_IR_MASK_SHIFT(reg) (((reg) & LVDS_IMP_CTRL0_RESERVE_IR_MASK) >> LVDS_IMP_CTRL0_RESERVE_IR_SHIFT)
#define  LVDS_IMP_CTRL0_RESERVE_IR_REPLACE_VAL(reg,val) (((reg) & ~LVDS_IMP_CTRL0_RESERVE_IR_MASK) | (((uint32_t)val) << LVDS_IMP_CTRL0_RESERVE_IR_SHIFT))

#define  LVDS_IMP_CTRL0_IMP_TUNE_MASK 0x400
#define  LVDS_IMP_CTRL0_IMP_TUNE_SHIFT 10
#define  LVDS_IMP_CTRL0_IMP_TUNE_MASK_SHIFT(reg) (((reg) & LVDS_IMP_CTRL0_IMP_TUNE_MASK) >> LVDS_IMP_CTRL0_IMP_TUNE_SHIFT)
#define  LVDS_IMP_CTRL0_IMP_TUNE_REPLACE_VAL(reg,val) (((reg) & ~LVDS_IMP_CTRL0_IMP_TUNE_MASK) | (((uint32_t)val) << LVDS_IMP_CTRL0_IMP_TUNE_SHIFT))

#define  LVDS_IMP_CTRL0_IMP_SET_MASK 0x380
#define  LVDS_IMP_CTRL0_IMP_SET_SHIFT 7
#define  LVDS_IMP_CTRL0_IMP_SET_MASK_SHIFT(reg) (((reg) & LVDS_IMP_CTRL0_IMP_SET_MASK) >> LVDS_IMP_CTRL0_IMP_SET_SHIFT)
#define  LVDS_IMP_CTRL0_IMP_SET_REPLACE_VAL(reg,val) (((reg) & ~LVDS_IMP_CTRL0_IMP_SET_MASK) | (((uint32_t)val) << LVDS_IMP_CTRL0_IMP_SET_SHIFT))

#define  LVDS_IMP_CTRL0_IMP_OR_MASK 0x40
#define  LVDS_IMP_CTRL0_IMP_OR_SHIFT 6
#define  LVDS_IMP_CTRL0_IMP_OR_MASK_SHIFT(reg) (((reg) & LVDS_IMP_CTRL0_IMP_OR_MASK) >> LVDS_IMP_CTRL0_IMP_OR_SHIFT)
#define  LVDS_IMP_CTRL0_IMP_OR_REPLACE_VAL(reg,val) (((reg) & ~LVDS_IMP_CTRL0_IMP_OR_MASK) | (((uint32_t)val) << LVDS_IMP_CTRL0_IMP_OR_SHIFT))

#define  LVDS_IMP_CTRL0_IMP_EXT_MASK 0x3f
#define  LVDS_IMP_CTRL0_IMP_EXT_SHIFT 0
#define  LVDS_IMP_CTRL0_IMP_EXT_MASK_SHIFT(reg) (((reg) & LVDS_IMP_CTRL0_IMP_EXT_MASK) >> LVDS_IMP_CTRL0_IMP_EXT_SHIFT)
#define  LVDS_IMP_CTRL0_IMP_EXT_REPLACE_VAL(reg,val) (((reg) & ~LVDS_IMP_CTRL0_IMP_EXT_MASK) | (((uint32_t)val) << LVDS_IMP_CTRL0_IMP_EXT_SHIFT))

//====================================================================
//Register: LVDS PHY Impedance Control1 Register (IMP_CTRL1)
/** \brief The names of register fields are identical to the port names of the hardmacro model.
     See lvds_6tx_pll specification/datasheet document for usage of the register bits.*/
//====================================================================

#define  LVDS_IMP_CTRL1_RESERVED1_MASK 0xffffff00
#define  LVDS_IMP_CTRL1_RESERVED1_SHIFT 8
#define  LVDS_IMP_CTRL1_RESERVED1_MASK_SHIFT(reg) (((reg) & LVDS_IMP_CTRL1_RESERVED1_MASK) >> LVDS_IMP_CTRL1_RESERVED1_SHIFT)
#define  LVDS_IMP_CTRL1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~LVDS_IMP_CTRL1_RESERVED1_MASK) | (((uint32_t)val) << LVDS_IMP_CTRL1_RESERVED1_SHIFT))

#define  LVDS_IMP_CTRL1_DLY_TX_CK_MASK 0xe0
#define  LVDS_IMP_CTRL1_DLY_TX_CK_SHIFT 5
#define  LVDS_IMP_CTRL1_DLY_TX_CK_MASK_SHIFT(reg) (((reg) & LVDS_IMP_CTRL1_DLY_TX_CK_MASK) >> LVDS_IMP_CTRL1_DLY_TX_CK_SHIFT)
#define  LVDS_IMP_CTRL1_DLY_TX_CK_REPLACE_VAL(reg,val) (((reg) & ~LVDS_IMP_CTRL1_DLY_TX_CK_MASK) | (((uint32_t)val) << LVDS_IMP_CTRL1_DLY_TX_CK_SHIFT))

#define  LVDS_IMP_CTRL1_DLY_D_CK_MASK 0x1e
#define  LVDS_IMP_CTRL1_DLY_D_CK_SHIFT 1
#define  LVDS_IMP_CTRL1_DLY_D_CK_MASK_SHIFT(reg) (((reg) & LVDS_IMP_CTRL1_DLY_D_CK_MASK) >> LVDS_IMP_CTRL1_DLY_D_CK_SHIFT)
#define  LVDS_IMP_CTRL1_DLY_D_CK_REPLACE_VAL(reg,val) (((reg) & ~LVDS_IMP_CTRL1_DLY_D_CK_MASK) | (((uint32_t)val) << LVDS_IMP_CTRL1_DLY_D_CK_SHIFT))

#define  LVDS_IMP_CTRL1_DLY_D_CK_SIGN_MASK 0x1
#define  LVDS_IMP_CTRL1_DLY_D_CK_SIGN_SHIFT 0
#define  LVDS_IMP_CTRL1_DLY_D_CK_SIGN_MASK_SHIFT(reg) (((reg) & LVDS_IMP_CTRL1_DLY_D_CK_SIGN_MASK) >> LVDS_IMP_CTRL1_DLY_D_CK_SIGN_SHIFT)
#define  LVDS_IMP_CTRL1_DLY_D_CK_SIGN_REPLACE_VAL(reg,val) (((reg) & ~LVDS_IMP_CTRL1_DLY_D_CK_SIGN_MASK) | (((uint32_t)val) << LVDS_IMP_CTRL1_DLY_D_CK_SIGN_SHIFT))

//====================================================================
//Register: LVDS PHY PLL Control0 Register (PLL_CTRL0)
/** \brief The names of register fields are identical to the port names of the hardmacro model.
     See lvds_6tx_pll specification/datasheet document for usage of the register bits.*/
//====================================================================

#define  LVDS_PLL_CTRL0_RESERVED1_MASK 0xfff80000
#define  LVDS_PLL_CTRL0_RESERVED1_SHIFT 19
#define  LVDS_PLL_CTRL0_RESERVED1_MASK_SHIFT(reg) (((reg) & LVDS_PLL_CTRL0_RESERVED1_MASK) >> LVDS_PLL_CTRL0_RESERVED1_SHIFT)
#define  LVDS_PLL_CTRL0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~LVDS_PLL_CTRL0_RESERVED1_MASK) | (((uint32_t)val) << LVDS_PLL_CTRL0_RESERVED1_SHIFT))

#define  LVDS_PLL_CTRL0_FBDIV_MASK 0x7fc00
#define  LVDS_PLL_CTRL0_FBDIV_SHIFT 10
#define  LVDS_PLL_CTRL0_FBDIV_MASK_SHIFT(reg) (((reg) & LVDS_PLL_CTRL0_FBDIV_MASK) >> LVDS_PLL_CTRL0_FBDIV_SHIFT)
#define  LVDS_PLL_CTRL0_FBDIV_REPLACE_VAL(reg,val) (((reg) & ~LVDS_PLL_CTRL0_FBDIV_MASK) | (((uint32_t)val) << LVDS_PLL_CTRL0_FBDIV_SHIFT))

#define  LVDS_PLL_CTRL0_FBCDLY_EN_MASK 0x200
#define  LVDS_PLL_CTRL0_FBCDLY_EN_SHIFT 9
#define  LVDS_PLL_CTRL0_FBCDLY_EN_MASK_SHIFT(reg) (((reg) & LVDS_PLL_CTRL0_FBCDLY_EN_MASK) >> LVDS_PLL_CTRL0_FBCDLY_EN_SHIFT)
#define  LVDS_PLL_CTRL0_FBCDLY_EN_REPLACE_VAL(reg,val) (((reg) & ~LVDS_PLL_CTRL0_FBCDLY_EN_MASK) | (((uint32_t)val) << LVDS_PLL_CTRL0_FBCDLY_EN_SHIFT))

#define  LVDS_PLL_CTRL0_FBCDLY_MASK 0x1f8
#define  LVDS_PLL_CTRL0_FBCDLY_SHIFT 3
#define  LVDS_PLL_CTRL0_FBCDLY_MASK_SHIFT(reg) (((reg) & LVDS_PLL_CTRL0_FBCDLY_MASK) >> LVDS_PLL_CTRL0_FBCDLY_SHIFT)
#define  LVDS_PLL_CTRL0_FBCDLY_REPLACE_VAL(reg,val) (((reg) & ~LVDS_PLL_CTRL0_FBCDLY_MASK) | (((uint32_t)val) << LVDS_PLL_CTRL0_FBCDLY_SHIFT))

#define  LVDS_PLL_CTRL0_CLKOUT_DIV_SEL_MASK 0x6
#define  LVDS_PLL_CTRL0_CLKOUT_DIV_SEL_SHIFT 1
#define  LVDS_PLL_CTRL0_CLKOUT_DIV_SEL_MASK_SHIFT(reg) (((reg) & LVDS_PLL_CTRL0_CLKOUT_DIV_SEL_MASK) >> LVDS_PLL_CTRL0_CLKOUT_DIV_SEL_SHIFT)
#define  LVDS_PLL_CTRL0_CLKOUT_DIV_SEL_REPLACE_VAL(reg,val) (((reg) & ~LVDS_PLL_CTRL0_CLKOUT_DIV_SEL_MASK) | (((uint32_t)val) << LVDS_PLL_CTRL0_CLKOUT_DIV_SEL_SHIFT))

#define  LVDS_PLL_CTRL0_CLK_DET_EN_MASK 0x1
#define  LVDS_PLL_CTRL0_CLK_DET_EN_SHIFT 0
#define  LVDS_PLL_CTRL0_CLK_DET_EN_MASK_SHIFT(reg) (((reg) & LVDS_PLL_CTRL0_CLK_DET_EN_MASK) >> LVDS_PLL_CTRL0_CLK_DET_EN_SHIFT)
#define  LVDS_PLL_CTRL0_CLK_DET_EN_REPLACE_VAL(reg,val) (((reg) & ~LVDS_PLL_CTRL0_CLK_DET_EN_MASK) | (((uint32_t)val) << LVDS_PLL_CTRL0_CLK_DET_EN_SHIFT))

//====================================================================
//Register: LVDS PHY PLL Control1 Register (PLL_CTRL1)
/** \brief The names of register fields are identical to the port names of the hardmacro model.
     See lvds_6tx_pll specification/datasheet document for usage of the register bits.*/
//====================================================================

#define  LVDS_PLL_CTRL1_KVCO_MASK 0xf0000000
#define  LVDS_PLL_CTRL1_KVCO_SHIFT 28
#define  LVDS_PLL_CTRL1_KVCO_MASK_SHIFT(reg) (((reg) & LVDS_PLL_CTRL1_KVCO_MASK) >> LVDS_PLL_CTRL1_KVCO_SHIFT)
#define  LVDS_PLL_CTRL1_KVCO_REPLACE_VAL(reg,val) (((reg) & ~LVDS_PLL_CTRL1_KVCO_MASK) | (((uint32_t)val) << LVDS_PLL_CTRL1_KVCO_SHIFT))

#define  LVDS_PLL_CTRL1_INTPI_MASK 0xf000000
#define  LVDS_PLL_CTRL1_INTPI_SHIFT 24
#define  LVDS_PLL_CTRL1_INTPI_MASK_SHIFT(reg) (((reg) & LVDS_PLL_CTRL1_INTPI_MASK) >> LVDS_PLL_CTRL1_INTPI_SHIFT)
#define  LVDS_PLL_CTRL1_INTPI_REPLACE_VAL(reg,val) (((reg) & ~LVDS_PLL_CTRL1_INTPI_MASK) | (((uint32_t)val) << LVDS_PLL_CTRL1_INTPI_SHIFT))

#define  LVDS_PLL_CTRL1_INTP_CAP_MASK 0xe00000
#define  LVDS_PLL_CTRL1_INTP_CAP_SHIFT 21
#define  LVDS_PLL_CTRL1_INTP_CAP_MASK_SHIFT(reg) (((reg) & LVDS_PLL_CTRL1_INTP_CAP_MASK) >> LVDS_PLL_CTRL1_INTP_CAP_SHIFT)
#define  LVDS_PLL_CTRL1_INTP_CAP_REPLACE_VAL(reg,val) (((reg) & ~LVDS_PLL_CTRL1_INTP_CAP_MASK) | (((uint32_t)val) << LVDS_PLL_CTRL1_INTP_CAP_SHIFT))

#define  LVDS_PLL_CTRL1_ICP_MASK 0x1e0000
#define  LVDS_PLL_CTRL1_ICP_SHIFT 17
#define  LVDS_PLL_CTRL1_ICP_MASK_SHIFT(reg) (((reg) & LVDS_PLL_CTRL1_ICP_MASK) >> LVDS_PLL_CTRL1_ICP_SHIFT)
#define  LVDS_PLL_CTRL1_ICP_REPLACE_VAL(reg,val) (((reg) & ~LVDS_PLL_CTRL1_ICP_MASK) | (((uint32_t)val) << LVDS_PLL_CTRL1_ICP_SHIFT))

#define  LVDS_PLL_CTRL1_FREQ_OFFSET_MASK 0x1ffff
#define  LVDS_PLL_CTRL1_FREQ_OFFSET_SHIFT 0
#define  LVDS_PLL_CTRL1_FREQ_OFFSET_MASK_SHIFT(reg) (((reg) & LVDS_PLL_CTRL1_FREQ_OFFSET_MASK) >> LVDS_PLL_CTRL1_FREQ_OFFSET_SHIFT)
#define  LVDS_PLL_CTRL1_FREQ_OFFSET_REPLACE_VAL(reg,val) (((reg) & ~LVDS_PLL_CTRL1_FREQ_OFFSET_MASK) | (((uint32_t)val) << LVDS_PLL_CTRL1_FREQ_OFFSET_SHIFT))

//====================================================================
//Register: LVDS PHY PLL Control2 Register (PLL_CTRL2)
/** \brief The names of register fields are identical to the port names of the hardmacro model.
     See lvds_6tx_pll specification/datasheet document for usage of the register bits.*/
//====================================================================

#define  LVDS_PLL_CTRL2_REFCLK_BYP_EN_MASK 0x80000000
#define  LVDS_PLL_CTRL2_REFCLK_BYP_EN_SHIFT 31
#define  LVDS_PLL_CTRL2_REFCLK_BYP_EN_MASK_SHIFT(reg) (((reg) & LVDS_PLL_CTRL2_REFCLK_BYP_EN_MASK) >> LVDS_PLL_CTRL2_REFCLK_BYP_EN_SHIFT)
#define  LVDS_PLL_CTRL2_REFCLK_BYP_EN_REPLACE_VAL(reg,val) (((reg) & ~LVDS_PLL_CTRL2_REFCLK_BYP_EN_MASK) | (((uint32_t)val) << LVDS_PLL_CTRL2_REFCLK_BYP_EN_SHIFT))

#define  LVDS_PLL_CTRL2_SSC_EN_MASK 0x40000000
#define  LVDS_PLL_CTRL2_SSC_EN_SHIFT 30
#define  LVDS_PLL_CTRL2_SSC_EN_MASK_SHIFT(reg) (((reg) & LVDS_PLL_CTRL2_SSC_EN_MASK) >> LVDS_PLL_CTRL2_SSC_EN_SHIFT)
#define  LVDS_PLL_CTRL2_SSC_EN_REPLACE_VAL(reg,val) (((reg) & ~LVDS_PLL_CTRL2_SSC_EN_MASK) | (((uint32_t)val) << LVDS_PLL_CTRL2_SSC_EN_SHIFT))

#define  LVDS_PLL_CTRL2_RESET_SSC_MASK 0x20000000
#define  LVDS_PLL_CTRL2_RESET_SSC_SHIFT 29
#define  LVDS_PLL_CTRL2_RESET_SSC_MASK_SHIFT(reg) (((reg) & LVDS_PLL_CTRL2_RESET_SSC_MASK) >> LVDS_PLL_CTRL2_RESET_SSC_SHIFT)
#define  LVDS_PLL_CTRL2_RESET_SSC_REPLACE_VAL(reg,val) (((reg) & ~LVDS_PLL_CTRL2_RESET_SSC_MASK) | (((uint32_t)val) << LVDS_PLL_CTRL2_RESET_SSC_SHIFT))

#define  LVDS_PLL_CTRL2_RESET_PLL_MASK 0x10000000
#define  LVDS_PLL_CTRL2_RESET_PLL_SHIFT 28
#define  LVDS_PLL_CTRL2_RESET_PLL_MASK_SHIFT(reg) (((reg) & LVDS_PLL_CTRL2_RESET_PLL_MASK) >> LVDS_PLL_CTRL2_RESET_PLL_SHIFT)
#define  LVDS_PLL_CTRL2_RESET_PLL_REPLACE_VAL(reg,val) (((reg) & ~LVDS_PLL_CTRL2_RESET_PLL_MASK) | (((uint32_t)val) << LVDS_PLL_CTRL2_RESET_PLL_SHIFT))

#define  LVDS_PLL_CTRL2_RESET_PI_MASK 0x8000000
#define  LVDS_PLL_CTRL2_RESET_PI_SHIFT 27
#define  LVDS_PLL_CTRL2_RESET_PI_MASK_SHIFT(reg) (((reg) & LVDS_PLL_CTRL2_RESET_PI_MASK) >> LVDS_PLL_CTRL2_RESET_PI_SHIFT)
#define  LVDS_PLL_CTRL2_RESET_PI_REPLACE_VAL(reg,val) (((reg) & ~LVDS_PLL_CTRL2_RESET_PI_MASK) | (((uint32_t)val) << LVDS_PLL_CTRL2_RESET_PI_SHIFT))

#define  LVDS_PLL_CTRL2_RESERVE_IP_MASK 0x7fff800
#define  LVDS_PLL_CTRL2_RESERVE_IP_SHIFT 11
#define  LVDS_PLL_CTRL2_RESERVE_IP_MASK_SHIFT(reg) (((reg) & LVDS_PLL_CTRL2_RESERVE_IP_MASK) >> LVDS_PLL_CTRL2_RESERVE_IP_SHIFT)
#define  LVDS_PLL_CTRL2_RESERVE_IP_REPLACE_VAL(reg,val) (((reg) & ~LVDS_PLL_CTRL2_RESERVE_IP_MASK) | (((uint32_t)val) << LVDS_PLL_CTRL2_RESERVE_IP_SHIFT))

#define  LVDS_PLL_CTRL2_REFDIV_MASK 0x7fc
#define  LVDS_PLL_CTRL2_REFDIV_SHIFT 2
#define  LVDS_PLL_CTRL2_REFDIV_MASK_SHIFT(reg) (((reg) & LVDS_PLL_CTRL2_REFDIV_MASK) >> LVDS_PLL_CTRL2_REFDIV_SHIFT)
#define  LVDS_PLL_CTRL2_REFDIV_REPLACE_VAL(reg,val) (((reg) & ~LVDS_PLL_CTRL2_REFDIV_MASK) | (((uint32_t)val) << LVDS_PLL_CTRL2_REFDIV_SHIFT))

#define  LVDS_PLL_CTRL2_PLL_BW_SEL_MASK 0x2
#define  LVDS_PLL_CTRL2_PLL_BW_SEL_SHIFT 1
#define  LVDS_PLL_CTRL2_PLL_BW_SEL_MASK_SHIFT(reg) (((reg) & LVDS_PLL_CTRL2_PLL_BW_SEL_MASK) >> LVDS_PLL_CTRL2_PLL_BW_SEL_SHIFT)
#define  LVDS_PLL_CTRL2_PLL_BW_SEL_REPLACE_VAL(reg,val) (((reg) & ~LVDS_PLL_CTRL2_PLL_BW_SEL_MASK) | (((uint32_t)val) << LVDS_PLL_CTRL2_PLL_BW_SEL_SHIFT))

#define  LVDS_PLL_CTRL2_PI_EN_MASK 0x1
#define  LVDS_PLL_CTRL2_PI_EN_SHIFT 0
#define  LVDS_PLL_CTRL2_PI_EN_MASK_SHIFT(reg) (((reg) & LVDS_PLL_CTRL2_PI_EN_MASK) >> LVDS_PLL_CTRL2_PI_EN_SHIFT)
#define  LVDS_PLL_CTRL2_PI_EN_REPLACE_VAL(reg,val) (((reg) & ~LVDS_PLL_CTRL2_PI_EN_MASK) | (((uint32_t)val) << LVDS_PLL_CTRL2_PI_EN_SHIFT))

//====================================================================
//Register: LVDS PHY PLL Control3 Register (PLL_CTRL3)
/** \brief The names of register fields are identical to the port names of the hardmacro model.
     See lvds_6tx_pll specification/datasheet document for usage of the register bits.*/
//====================================================================

#define  LVDS_PLL_CTRL3_VCO_CAL_EXT_MASK 0xf0000000
#define  LVDS_PLL_CTRL3_VCO_CAL_EXT_SHIFT 28
#define  LVDS_PLL_CTRL3_VCO_CAL_EXT_MASK_SHIFT(reg) (((reg) & LVDS_PLL_CTRL3_VCO_CAL_EXT_MASK) >> LVDS_PLL_CTRL3_VCO_CAL_EXT_SHIFT)
#define  LVDS_PLL_CTRL3_VCO_CAL_EXT_REPLACE_VAL(reg,val) (((reg) & ~LVDS_PLL_CTRL3_VCO_CAL_EXT_MASK) | (((uint32_t)val) << LVDS_PLL_CTRL3_VCO_CAL_EXT_SHIFT))

#define  LVDS_PLL_CTRL3_SSC_RNGE_MASK 0xffe0000
#define  LVDS_PLL_CTRL3_SSC_RNGE_SHIFT 17
#define  LVDS_PLL_CTRL3_SSC_RNGE_MASK_SHIFT(reg) (((reg) & LVDS_PLL_CTRL3_SSC_RNGE_MASK) >> LVDS_PLL_CTRL3_SSC_RNGE_SHIFT)
#define  LVDS_PLL_CTRL3_SSC_RNGE_REPLACE_VAL(reg,val) (((reg) & ~LVDS_PLL_CTRL3_SSC_RNGE_MASK) | (((uint32_t)val) << LVDS_PLL_CTRL3_SSC_RNGE_SHIFT))

#define  LVDS_PLL_CTRL3_SSC_MODE_MASK 0x10000
#define  LVDS_PLL_CTRL3_SSC_MODE_SHIFT 16
#define  LVDS_PLL_CTRL3_SSC_MODE_MASK_SHIFT(reg) (((reg) & LVDS_PLL_CTRL3_SSC_MODE_MASK) >> LVDS_PLL_CTRL3_SSC_MODE_SHIFT)
#define  LVDS_PLL_CTRL3_SSC_MODE_REPLACE_VAL(reg,val) (((reg) & ~LVDS_PLL_CTRL3_SSC_MODE_MASK) | (((uint32_t)val) << LVDS_PLL_CTRL3_SSC_MODE_SHIFT))

#define  LVDS_PLL_CTRL3_SSC_FREQ_DIV_MASK 0xffff
#define  LVDS_PLL_CTRL3_SSC_FREQ_DIV_SHIFT 0
#define  LVDS_PLL_CTRL3_SSC_FREQ_DIV_MASK_SHIFT(reg) (((reg) & LVDS_PLL_CTRL3_SSC_FREQ_DIV_MASK) >> LVDS_PLL_CTRL3_SSC_FREQ_DIV_SHIFT)
#define  LVDS_PLL_CTRL3_SSC_FREQ_DIV_REPLACE_VAL(reg,val) (((reg) & ~LVDS_PLL_CTRL3_SSC_FREQ_DIV_MASK) | (((uint32_t)val) << LVDS_PLL_CTRL3_SSC_FREQ_DIV_SHIFT))

//====================================================================
//Register: LVDS PHY PLL Control4 Register (PLL_CTRL4)
/** \brief The names of register fields are identical to the port names of the hardmacro model.
     See lvds_6tx_pll specification/datasheet document for usage of the register bits.*/
//====================================================================

#define  LVDS_PLL_CTRL4_RESERVED1_MASK 0xfffffe00
#define  LVDS_PLL_CTRL4_RESERVED1_SHIFT 9
#define  LVDS_PLL_CTRL4_RESERVED1_MASK_SHIFT(reg) (((reg) & LVDS_PLL_CTRL4_RESERVED1_MASK) >> LVDS_PLL_CTRL4_RESERVED1_SHIFT)
#define  LVDS_PLL_CTRL4_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~LVDS_PLL_CTRL4_RESERVED1_MASK) | (((uint32_t)val) << LVDS_PLL_CTRL4_RESERVED1_SHIFT))

#define  LVDS_PLL_CTRL4_VDDM_MASK 0x180
#define  LVDS_PLL_CTRL4_VDDM_SHIFT 7
#define  LVDS_PLL_CTRL4_VDDM_MASK_SHIFT(reg) (((reg) & LVDS_PLL_CTRL4_VDDM_MASK) >> LVDS_PLL_CTRL4_VDDM_SHIFT)
#define  LVDS_PLL_CTRL4_VDDM_REPLACE_VAL(reg,val) (((reg) & ~LVDS_PLL_CTRL4_VDDM_MASK) | (((uint32_t)val) << LVDS_PLL_CTRL4_VDDM_SHIFT))

#define  LVDS_PLL_CTRL4_VDDL_MASK 0x70
#define  LVDS_PLL_CTRL4_VDDL_SHIFT 4
#define  LVDS_PLL_CTRL4_VDDL_MASK_SHIFT(reg) (((reg) & LVDS_PLL_CTRL4_VDDL_MASK) >> LVDS_PLL_CTRL4_VDDL_SHIFT)
#define  LVDS_PLL_CTRL4_VDDL_REPLACE_VAL(reg,val) (((reg) & ~LVDS_PLL_CTRL4_VDDL_MASK) | (((uint32_t)val) << LVDS_PLL_CTRL4_VDDL_SHIFT))

#define  LVDS_PLL_CTRL4_VCO_CAL_VTH_MASK 0xc
#define  LVDS_PLL_CTRL4_VCO_CAL_VTH_SHIFT 2
#define  LVDS_PLL_CTRL4_VCO_CAL_VTH_MASK_SHIFT(reg) (((reg) & LVDS_PLL_CTRL4_VCO_CAL_VTH_MASK) >> LVDS_PLL_CTRL4_VCO_CAL_VTH_SHIFT)
#define  LVDS_PLL_CTRL4_VCO_CAL_VTH_REPLACE_VAL(reg,val) (((reg) & ~LVDS_PLL_CTRL4_VCO_CAL_VTH_MASK) | (((uint32_t)val) << LVDS_PLL_CTRL4_VCO_CAL_VTH_SHIFT))

#define  LVDS_PLL_CTRL4_VCO_CAL_START_MASK 0x2
#define  LVDS_PLL_CTRL4_VCO_CAL_START_SHIFT 1
#define  LVDS_PLL_CTRL4_VCO_CAL_START_MASK_SHIFT(reg) (((reg) & LVDS_PLL_CTRL4_VCO_CAL_START_MASK) >> LVDS_PLL_CTRL4_VCO_CAL_START_SHIFT)
#define  LVDS_PLL_CTRL4_VCO_CAL_START_REPLACE_VAL(reg,val) (((reg) & ~LVDS_PLL_CTRL4_VCO_CAL_START_MASK) | (((uint32_t)val) << LVDS_PLL_CTRL4_VCO_CAL_START_SHIFT))

#define  LVDS_PLL_CTRL4_VCO_CAL_EXT_EN_MASK 0x1
#define  LVDS_PLL_CTRL4_VCO_CAL_EXT_EN_SHIFT 0
#define  LVDS_PLL_CTRL4_VCO_CAL_EXT_EN_MASK_SHIFT(reg) (((reg) & LVDS_PLL_CTRL4_VCO_CAL_EXT_EN_MASK) >> LVDS_PLL_CTRL4_VCO_CAL_EXT_EN_SHIFT)
#define  LVDS_PLL_CTRL4_VCO_CAL_EXT_EN_REPLACE_VAL(reg,val) (((reg) & ~LVDS_PLL_CTRL4_VCO_CAL_EXT_EN_MASK) | (((uint32_t)val) << LVDS_PLL_CTRL4_VCO_CAL_EXT_EN_SHIFT))

//====================================================================
//Register: LVDS PHY Status0 Register (STATUS)
/** \brief The names of register fields are identical to the port names of the hardmacro model.
     See lvds_6tx_pll specification/datasheet document for usage of the register bits.*/
//====================================================================

#define  LVDS_STATUS_RESERVED1_MASK 0xff000000
#define  LVDS_STATUS_RESERVED1_SHIFT 24
#define  LVDS_STATUS_RESERVED1_MASK_SHIFT(reg) (((reg) & LVDS_STATUS_RESERVED1_MASK) >> LVDS_STATUS_RESERVED1_SHIFT)
#define  LVDS_STATUS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~LVDS_STATUS_RESERVED1_MASK) | (((uint32_t)val) << LVDS_STATUS_RESERVED1_SHIFT))

#define  LVDS_STATUS_RESERVE_O5_MASK 0xf00000
#define  LVDS_STATUS_RESERVE_O5_SHIFT 20
#define  LVDS_STATUS_RESERVE_O5_MASK_SHIFT(reg) (((reg) & LVDS_STATUS_RESERVE_O5_MASK) >> LVDS_STATUS_RESERVE_O5_SHIFT)
#define  LVDS_STATUS_RESERVE_O5_REPLACE_VAL(reg,val) (((reg) & ~LVDS_STATUS_RESERVE_O5_MASK) | (((uint32_t)val) << LVDS_STATUS_RESERVE_O5_SHIFT))

#define  LVDS_STATUS_RESERVE_O4_MASK 0xf0000
#define  LVDS_STATUS_RESERVE_O4_SHIFT 16
#define  LVDS_STATUS_RESERVE_O4_MASK_SHIFT(reg) (((reg) & LVDS_STATUS_RESERVE_O4_MASK) >> LVDS_STATUS_RESERVE_O4_SHIFT)
#define  LVDS_STATUS_RESERVE_O4_REPLACE_VAL(reg,val) (((reg) & ~LVDS_STATUS_RESERVE_O4_MASK) | (((uint32_t)val) << LVDS_STATUS_RESERVE_O4_SHIFT))

#define  LVDS_STATUS_RESERVE_O3_MASK 0xf000
#define  LVDS_STATUS_RESERVE_O3_SHIFT 12
#define  LVDS_STATUS_RESERVE_O3_MASK_SHIFT(reg) (((reg) & LVDS_STATUS_RESERVE_O3_MASK) >> LVDS_STATUS_RESERVE_O3_SHIFT)
#define  LVDS_STATUS_RESERVE_O3_REPLACE_VAL(reg,val) (((reg) & ~LVDS_STATUS_RESERVE_O3_MASK) | (((uint32_t)val) << LVDS_STATUS_RESERVE_O3_SHIFT))

#define  LVDS_STATUS_RESERVE_O2_MASK 0xf00
#define  LVDS_STATUS_RESERVE_O2_SHIFT 8
#define  LVDS_STATUS_RESERVE_O2_MASK_SHIFT(reg) (((reg) & LVDS_STATUS_RESERVE_O2_MASK) >> LVDS_STATUS_RESERVE_O2_SHIFT)
#define  LVDS_STATUS_RESERVE_O2_REPLACE_VAL(reg,val) (((reg) & ~LVDS_STATUS_RESERVE_O2_MASK) | (((uint32_t)val) << LVDS_STATUS_RESERVE_O2_SHIFT))

#define  LVDS_STATUS_RESERVE_O1_MASK 0xf0
#define  LVDS_STATUS_RESERVE_O1_SHIFT 4
#define  LVDS_STATUS_RESERVE_O1_MASK_SHIFT(reg) (((reg) & LVDS_STATUS_RESERVE_O1_MASK) >> LVDS_STATUS_RESERVE_O1_SHIFT)
#define  LVDS_STATUS_RESERVE_O1_REPLACE_VAL(reg,val) (((reg) & ~LVDS_STATUS_RESERVE_O1_MASK) | (((uint32_t)val) << LVDS_STATUS_RESERVE_O1_SHIFT))

#define  LVDS_STATUS_RESERVE_O0_MASK 0xf
#define  LVDS_STATUS_RESERVE_O0_SHIFT 0
#define  LVDS_STATUS_RESERVE_O0_MASK_SHIFT(reg) (((reg) & LVDS_STATUS_RESERVE_O0_MASK) >> LVDS_STATUS_RESERVE_O0_SHIFT)
#define  LVDS_STATUS_RESERVE_O0_REPLACE_VAL(reg,val) (((reg) & ~LVDS_STATUS_RESERVE_O0_MASK) | (((uint32_t)val) << LVDS_STATUS_RESERVE_O0_SHIFT))

//====================================================================
//Register: LVDS PHY Impedance Status Register (IMP_STATUS)
/** \brief The names of register fields are identical to the port names of the hardmacro model.
     See lvds_6tx_pll specification/datasheet document for usage of the register bits.*/
//====================================================================

#define  LVDS_IMP_STATUS_RESERVED1_MASK 0xffffff80
#define  LVDS_IMP_STATUS_RESERVED1_SHIFT 7
#define  LVDS_IMP_STATUS_RESERVED1_MASK_SHIFT(reg) (((reg) & LVDS_IMP_STATUS_RESERVED1_MASK) >> LVDS_IMP_STATUS_RESERVED1_SHIFT)
#define  LVDS_IMP_STATUS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~LVDS_IMP_STATUS_RESERVED1_MASK) | (((uint32_t)val) << LVDS_IMP_STATUS_RESERVED1_SHIFT))

#define  LVDS_IMP_STATUS_IMP_TUNE_BUSY_MASK 0x40
#define  LVDS_IMP_STATUS_IMP_TUNE_BUSY_SHIFT 6
#define  LVDS_IMP_STATUS_IMP_TUNE_BUSY_MASK_SHIFT(reg) (((reg) & LVDS_IMP_STATUS_IMP_TUNE_BUSY_MASK) >> LVDS_IMP_STATUS_IMP_TUNE_BUSY_SHIFT)
#define  LVDS_IMP_STATUS_IMP_TUNE_BUSY_REPLACE_VAL(reg,val) (((reg) & ~LVDS_IMP_STATUS_IMP_TUNE_BUSY_MASK) | (((uint32_t)val) << LVDS_IMP_STATUS_IMP_TUNE_BUSY_SHIFT))

#define  LVDS_IMP_STATUS_TX_IMP_MASK 0x3f
#define  LVDS_IMP_STATUS_TX_IMP_SHIFT 0
#define  LVDS_IMP_STATUS_TX_IMP_MASK_SHIFT(reg) (((reg) & LVDS_IMP_STATUS_TX_IMP_MASK) >> LVDS_IMP_STATUS_TX_IMP_SHIFT)
#define  LVDS_IMP_STATUS_TX_IMP_REPLACE_VAL(reg,val) (((reg) & ~LVDS_IMP_STATUS_TX_IMP_MASK) | (((uint32_t)val) << LVDS_IMP_STATUS_TX_IMP_SHIFT))

//====================================================================
//Register: LVDS PHY PLL Status Register (PLL_STATUS)
/** \brief The names of register fields are identical to the port names of the hardmacro model.
     See lvds_6tx_pll specification/datasheet document for usage of the register bits.*/
//====================================================================

#define  LVDS_PLL_STATUS_RESERVED1_MASK 0xffffffc0
#define  LVDS_PLL_STATUS_RESERVED1_SHIFT 6
#define  LVDS_PLL_STATUS_RESERVED1_MASK_SHIFT(reg) (((reg) & LVDS_PLL_STATUS_RESERVED1_MASK) >> LVDS_PLL_STATUS_RESERVED1_SHIFT)
#define  LVDS_PLL_STATUS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~LVDS_PLL_STATUS_RESERVED1_MASK) | (((uint32_t)val) << LVDS_PLL_STATUS_RESERVED1_SHIFT))

#define  LVDS_PLL_STATUS_PLL_LOCK_MASK 0x20
#define  LVDS_PLL_STATUS_PLL_LOCK_SHIFT 5
#define  LVDS_PLL_STATUS_PLL_LOCK_MASK_SHIFT(reg) (((reg) & LVDS_PLL_STATUS_PLL_LOCK_MASK) >> LVDS_PLL_STATUS_PLL_LOCK_SHIFT)
#define  LVDS_PLL_STATUS_PLL_LOCK_REPLACE_VAL(reg,val) (((reg) & ~LVDS_PLL_STATUS_PLL_LOCK_MASK) | (((uint32_t)val) << LVDS_PLL_STATUS_PLL_LOCK_SHIFT))

#define  LVDS_PLL_STATUS_VCO_CAL_CTUNE_MASK 0x1e
#define  LVDS_PLL_STATUS_VCO_CAL_CTUNE_SHIFT 1
#define  LVDS_PLL_STATUS_VCO_CAL_CTUNE_MASK_SHIFT(reg) (((reg) & LVDS_PLL_STATUS_VCO_CAL_CTUNE_MASK) >> LVDS_PLL_STATUS_VCO_CAL_CTUNE_SHIFT)
#define  LVDS_PLL_STATUS_VCO_CAL_CTUNE_REPLACE_VAL(reg,val) (((reg) & ~LVDS_PLL_STATUS_VCO_CAL_CTUNE_MASK) | (((uint32_t)val) << LVDS_PLL_STATUS_VCO_CAL_CTUNE_SHIFT))

#define  LVDS_PLL_STATUS_VCO_CAL_DONE_MASK 0x1
#define  LVDS_PLL_STATUS_VCO_CAL_DONE_SHIFT 0
#define  LVDS_PLL_STATUS_VCO_CAL_DONE_MASK_SHIFT(reg) (((reg) & LVDS_PLL_STATUS_VCO_CAL_DONE_MASK) >> LVDS_PLL_STATUS_VCO_CAL_DONE_SHIFT)
#define  LVDS_PLL_STATUS_VCO_CAL_DONE_REPLACE_VAL(reg,val) (((reg) & ~LVDS_PLL_STATUS_VCO_CAL_DONE_MASK) | (((uint32_t)val) << LVDS_PLL_STATUS_VCO_CAL_DONE_SHIFT))

//====================================================================
//Register: LVDS PHY BIST Status Register (BIST_STATUS)
/** \brief The names of register fields are identical to the port names of the hardmacro model.
     See lvds_6tx_pll specification/datasheet document for usage of the register bits.*/
//====================================================================

#define  LVDS_BIST_STATUS_RESERVED1_MASK 0xfffff000
#define  LVDS_BIST_STATUS_RESERVED1_SHIFT 12
#define  LVDS_BIST_STATUS_RESERVED1_MASK_SHIFT(reg) (((reg) & LVDS_BIST_STATUS_RESERVED1_MASK) >> LVDS_BIST_STATUS_RESERVED1_SHIFT)
#define  LVDS_BIST_STATUS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~LVDS_BIST_STATUS_RESERVED1_MASK) | (((uint32_t)val) << LVDS_BIST_STATUS_RESERVED1_SHIFT))

#define  LVDS_BIST_STATUS_BIST_PASS_MASK 0xfc0
#define  LVDS_BIST_STATUS_BIST_PASS_SHIFT 6
#define  LVDS_BIST_STATUS_BIST_PASS_MASK_SHIFT(reg) (((reg) & LVDS_BIST_STATUS_BIST_PASS_MASK) >> LVDS_BIST_STATUS_BIST_PASS_SHIFT)
#define  LVDS_BIST_STATUS_BIST_PASS_REPLACE_VAL(reg,val) (((reg) & ~LVDS_BIST_STATUS_BIST_PASS_MASK) | (((uint32_t)val) << LVDS_BIST_STATUS_BIST_PASS_SHIFT))

#define  LVDS_BIST_STATUS_BIST_SYNC_MASK 0x3f
#define  LVDS_BIST_STATUS_BIST_SYNC_SHIFT 0
#define  LVDS_BIST_STATUS_BIST_SYNC_MASK_SHIFT(reg) (((reg) & LVDS_BIST_STATUS_BIST_SYNC_MASK) >> LVDS_BIST_STATUS_BIST_SYNC_SHIFT)
#define  LVDS_BIST_STATUS_BIST_SYNC_REPLACE_VAL(reg,val) (((reg) & ~LVDS_BIST_STATUS_BIST_SYNC_MASK) | (((uint32_t)val) << LVDS_BIST_STATUS_BIST_SYNC_SHIFT))

//====================================================================
//Register: LVDS D channel[j] bit[i] Configuration Register (Instance 1 of 42) (D_CFG0)
/** \brief D_CFGn register selects the source of data to be routed to the
     LVDS PHY input port, D channel[j] bit[i], where n = j*7 + i. <BR> <BR>
        D_CFG0-6 for D channel[0] bit[0-6] <BR>
        D_CFG7-13 for D channel[1] bit[0-6] <BR>
        D_CFG14-20 for D channel[2] bit[0-6] <BR>
        D_CFG21-27 for D channel[3] bit[0-6] <BR>
        D_CFG28-34 for D channel[4] bit[0-6] <BR>
        D_CFG35-41 for D channel[5] bit[0-6] <BR> <BR>
     The sources of D are the data and control lines from the
     LCD parallel panel interface: <BR>
     LDD[23:0] (pixel data), LCLK (hsync), VFCLK (vsync), and DENA (pixel valid). <BR> (Instance 1 of 42)*/
//====================================================================

#define  LVDS_D_CFG0_RESERVED1_MASK 0xffffffe0
#define  LVDS_D_CFG0_RESERVED1_SHIFT 5
#define  LVDS_D_CFG0_RESERVED1_MASK_SHIFT(reg) (((reg) & LVDS_D_CFG0_RESERVED1_MASK) >> LVDS_D_CFG0_RESERVED1_SHIFT)
#define  LVDS_D_CFG0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~LVDS_D_CFG0_RESERVED1_MASK) | (((uint32_t)val) << LVDS_D_CFG0_RESERVED1_SHIFT))

#define  LVDS_D_CFG0_MUXSEL_MASK 0x1f
#define  LVDS_D_CFG0_MUXSEL_SHIFT 0
#define  LVDS_D_CFG0_MUXSEL_MASK_SHIFT(reg) (((reg) & LVDS_D_CFG0_MUXSEL_MASK) >> LVDS_D_CFG0_MUXSEL_SHIFT)
#define  LVDS_D_CFG0_MUXSEL_REPLACE_VAL(reg,val) (((reg) & ~LVDS_D_CFG0_MUXSEL_MASK) | (((uint32_t)val) << LVDS_D_CFG0_MUXSEL_SHIFT))

//====================================================================
//Register: LVDS D channel[j] bit[i] Configuration Register (Instance 2 of 42) (D_CFG1)
/** \brief D_CFGn register selects the source of data to be routed to the
     LVDS PHY input port, D channel[j] bit[i], where n = j*7 + i. <BR> <BR>
        D_CFG0-6 for D channel[0] bit[0-6] <BR>
        D_CFG7-13 for D channel[1] bit[0-6] <BR>
        D_CFG14-20 for D channel[2] bit[0-6] <BR>
        D_CFG21-27 for D channel[3] bit[0-6] <BR>
        D_CFG28-34 for D channel[4] bit[0-6] <BR>
        D_CFG35-41 for D channel[5] bit[0-6] <BR> <BR>
     The sources of D are the data and control lines from the
     LCD parallel panel interface: <BR>
     LDD[23:0] (pixel data), LCLK (hsync), VFCLK (vsync), and DENA (pixel valid). <BR> (Instance 2 of 42)*/
//====================================================================

#define  LVDS_D_CFG1_RESERVED1_MASK 0xffffffe0
#define  LVDS_D_CFG1_RESERVED1_SHIFT 5
#define  LVDS_D_CFG1_RESERVED1_MASK_SHIFT(reg) (((reg) & LVDS_D_CFG1_RESERVED1_MASK) >> LVDS_D_CFG1_RESERVED1_SHIFT)
#define  LVDS_D_CFG1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~LVDS_D_CFG1_RESERVED1_MASK) | (((uint32_t)val) << LVDS_D_CFG1_RESERVED1_SHIFT))

#define  LVDS_D_CFG1_MUXSEL_MASK 0x1f
#define  LVDS_D_CFG1_MUXSEL_SHIFT 0
#define  LVDS_D_CFG1_MUXSEL_MASK_SHIFT(reg) (((reg) & LVDS_D_CFG1_MUXSEL_MASK) >> LVDS_D_CFG1_MUXSEL_SHIFT)
#define  LVDS_D_CFG1_MUXSEL_REPLACE_VAL(reg,val) (((reg) & ~LVDS_D_CFG1_MUXSEL_MASK) | (((uint32_t)val) << LVDS_D_CFG1_MUXSEL_SHIFT))

//====================================================================
//Register: LVDS D channel[j] bit[i] Configuration Register (Instance 3 of 42) (D_CFG2)
/** \brief D_CFGn register selects the source of data to be routed to the
     LVDS PHY input port, D channel[j] bit[i], where n = j*7 + i. <BR> <BR>
        D_CFG0-6 for D channel[0] bit[0-6] <BR>
        D_CFG7-13 for D channel[1] bit[0-6] <BR>
        D_CFG14-20 for D channel[2] bit[0-6] <BR>
        D_CFG21-27 for D channel[3] bit[0-6] <BR>
        D_CFG28-34 for D channel[4] bit[0-6] <BR>
        D_CFG35-41 for D channel[5] bit[0-6] <BR> <BR>
     The sources of D are the data and control lines from the
     LCD parallel panel interface: <BR>
     LDD[23:0] (pixel data), LCLK (hsync), VFCLK (vsync), and DENA (pixel valid). <BR> (Instance 3 of 42)*/
//====================================================================

#define  LVDS_D_CFG2_RESERVED1_MASK 0xffffffe0
#define  LVDS_D_CFG2_RESERVED1_SHIFT 5
#define  LVDS_D_CFG2_RESERVED1_MASK_SHIFT(reg) (((reg) & LVDS_D_CFG2_RESERVED1_MASK) >> LVDS_D_CFG2_RESERVED1_SHIFT)
#define  LVDS_D_CFG2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~LVDS_D_CFG2_RESERVED1_MASK) | (((uint32_t)val) << LVDS_D_CFG2_RESERVED1_SHIFT))

#define  LVDS_D_CFG2_MUXSEL_MASK 0x1f
#define  LVDS_D_CFG2_MUXSEL_SHIFT 0
#define  LVDS_D_CFG2_MUXSEL_MASK_SHIFT(reg) (((reg) & LVDS_D_CFG2_MUXSEL_MASK) >> LVDS_D_CFG2_MUXSEL_SHIFT)
#define  LVDS_D_CFG2_MUXSEL_REPLACE_VAL(reg,val) (((reg) & ~LVDS_D_CFG2_MUXSEL_MASK) | (((uint32_t)val) << LVDS_D_CFG2_MUXSEL_SHIFT))

//====================================================================
//Register: LVDS D channel[j] bit[i] Configuration Register (Instance 4 of 42) (D_CFG3)
/** \brief D_CFGn register selects the source of data to be routed to the
     LVDS PHY input port, D channel[j] bit[i], where n = j*7 + i. <BR> <BR>
        D_CFG0-6 for D channel[0] bit[0-6] <BR>
        D_CFG7-13 for D channel[1] bit[0-6] <BR>
        D_CFG14-20 for D channel[2] bit[0-6] <BR>
        D_CFG21-27 for D channel[3] bit[0-6] <BR>
        D_CFG28-34 for D channel[4] bit[0-6] <BR>
        D_CFG35-41 for D channel[5] bit[0-6] <BR> <BR>
     The sources of D are the data and control lines from the
     LCD parallel panel interface: <BR>
     LDD[23:0] (pixel data), LCLK (hsync), VFCLK (vsync), and DENA (pixel valid). <BR> (Instance 4 of 42)*/
//====================================================================

#define  LVDS_D_CFG3_RESERVED1_MASK 0xffffffe0
#define  LVDS_D_CFG3_RESERVED1_SHIFT 5
#define  LVDS_D_CFG3_RESERVED1_MASK_SHIFT(reg) (((reg) & LVDS_D_CFG3_RESERVED1_MASK) >> LVDS_D_CFG3_RESERVED1_SHIFT)
#define  LVDS_D_CFG3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~LVDS_D_CFG3_RESERVED1_MASK) | (((uint32_t)val) << LVDS_D_CFG3_RESERVED1_SHIFT))

#define  LVDS_D_CFG3_MUXSEL_MASK 0x1f
#define  LVDS_D_CFG3_MUXSEL_SHIFT 0
#define  LVDS_D_CFG3_MUXSEL_MASK_SHIFT(reg) (((reg) & LVDS_D_CFG3_MUXSEL_MASK) >> LVDS_D_CFG3_MUXSEL_SHIFT)
#define  LVDS_D_CFG3_MUXSEL_REPLACE_VAL(reg,val) (((reg) & ~LVDS_D_CFG3_MUXSEL_MASK) | (((uint32_t)val) << LVDS_D_CFG3_MUXSEL_SHIFT))

//====================================================================
//Register: LVDS D channel[j] bit[i] Configuration Register (Instance 5 of 42) (D_CFG4)
/** \brief D_CFGn register selects the source of data to be routed to the
     LVDS PHY input port, D channel[j] bit[i], where n = j*7 + i. <BR> <BR>
        D_CFG0-6 for D channel[0] bit[0-6] <BR>
        D_CFG7-13 for D channel[1] bit[0-6] <BR>
        D_CFG14-20 for D channel[2] bit[0-6] <BR>
        D_CFG21-27 for D channel[3] bit[0-6] <BR>
        D_CFG28-34 for D channel[4] bit[0-6] <BR>
        D_CFG35-41 for D channel[5] bit[0-6] <BR> <BR>
     The sources of D are the data and control lines from the
     LCD parallel panel interface: <BR>
     LDD[23:0] (pixel data), LCLK (hsync), VFCLK (vsync), and DENA (pixel valid). <BR> (Instance 5 of 42)*/
//====================================================================

#define  LVDS_D_CFG4_RESERVED1_MASK 0xffffffe0
#define  LVDS_D_CFG4_RESERVED1_SHIFT 5
#define  LVDS_D_CFG4_RESERVED1_MASK_SHIFT(reg) (((reg) & LVDS_D_CFG4_RESERVED1_MASK) >> LVDS_D_CFG4_RESERVED1_SHIFT)
#define  LVDS_D_CFG4_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~LVDS_D_CFG4_RESERVED1_MASK) | (((uint32_t)val) << LVDS_D_CFG4_RESERVED1_SHIFT))

#define  LVDS_D_CFG4_MUXSEL_MASK 0x1f
#define  LVDS_D_CFG4_MUXSEL_SHIFT 0
#define  LVDS_D_CFG4_MUXSEL_MASK_SHIFT(reg) (((reg) & LVDS_D_CFG4_MUXSEL_MASK) >> LVDS_D_CFG4_MUXSEL_SHIFT)
#define  LVDS_D_CFG4_MUXSEL_REPLACE_VAL(reg,val) (((reg) & ~LVDS_D_CFG4_MUXSEL_MASK) | (((uint32_t)val) << LVDS_D_CFG4_MUXSEL_SHIFT))

//====================================================================
//Register: LVDS D channel[j] bit[i] Configuration Register (Instance 6 of 42) (D_CFG5)
/** \brief D_CFGn register selects the source of data to be routed to the
     LVDS PHY input port, D channel[j] bit[i], where n = j*7 + i. <BR> <BR>
        D_CFG0-6 for D channel[0] bit[0-6] <BR>
        D_CFG7-13 for D channel[1] bit[0-6] <BR>
        D_CFG14-20 for D channel[2] bit[0-6] <BR>
        D_CFG21-27 for D channel[3] bit[0-6] <BR>
        D_CFG28-34 for D channel[4] bit[0-6] <BR>
        D_CFG35-41 for D channel[5] bit[0-6] <BR> <BR>
     The sources of D are the data and control lines from the
     LCD parallel panel interface: <BR>
     LDD[23:0] (pixel data), LCLK (hsync), VFCLK (vsync), and DENA (pixel valid). <BR> (Instance 6 of 42)*/
//====================================================================

#define  LVDS_D_CFG5_RESERVED1_MASK 0xffffffe0
#define  LVDS_D_CFG5_RESERVED1_SHIFT 5
#define  LVDS_D_CFG5_RESERVED1_MASK_SHIFT(reg) (((reg) & LVDS_D_CFG5_RESERVED1_MASK) >> LVDS_D_CFG5_RESERVED1_SHIFT)
#define  LVDS_D_CFG5_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~LVDS_D_CFG5_RESERVED1_MASK) | (((uint32_t)val) << LVDS_D_CFG5_RESERVED1_SHIFT))

#define  LVDS_D_CFG5_MUXSEL_MASK 0x1f
#define  LVDS_D_CFG5_MUXSEL_SHIFT 0
#define  LVDS_D_CFG5_MUXSEL_MASK_SHIFT(reg) (((reg) & LVDS_D_CFG5_MUXSEL_MASK) >> LVDS_D_CFG5_MUXSEL_SHIFT)
#define  LVDS_D_CFG5_MUXSEL_REPLACE_VAL(reg,val) (((reg) & ~LVDS_D_CFG5_MUXSEL_MASK) | (((uint32_t)val) << LVDS_D_CFG5_MUXSEL_SHIFT))

//====================================================================
//Register: LVDS D channel[j] bit[i] Configuration Register (Instance 7 of 42) (D_CFG6)
/** \brief D_CFGn register selects the source of data to be routed to the
     LVDS PHY input port, D channel[j] bit[i], where n = j*7 + i. <BR> <BR>
        D_CFG0-6 for D channel[0] bit[0-6] <BR>
        D_CFG7-13 for D channel[1] bit[0-6] <BR>
        D_CFG14-20 for D channel[2] bit[0-6] <BR>
        D_CFG21-27 for D channel[3] bit[0-6] <BR>
        D_CFG28-34 for D channel[4] bit[0-6] <BR>
        D_CFG35-41 for D channel[5] bit[0-6] <BR> <BR>
     The sources of D are the data and control lines from the
     LCD parallel panel interface: <BR>
     LDD[23:0] (pixel data), LCLK (hsync), VFCLK (vsync), and DENA (pixel valid). <BR> (Instance 7 of 42)*/
//====================================================================

#define  LVDS_D_CFG6_RESERVED1_MASK 0xffffffe0
#define  LVDS_D_CFG6_RESERVED1_SHIFT 5
#define  LVDS_D_CFG6_RESERVED1_MASK_SHIFT(reg) (((reg) & LVDS_D_CFG6_RESERVED1_MASK) >> LVDS_D_CFG6_RESERVED1_SHIFT)
#define  LVDS_D_CFG6_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~LVDS_D_CFG6_RESERVED1_MASK) | (((uint32_t)val) << LVDS_D_CFG6_RESERVED1_SHIFT))

#define  LVDS_D_CFG6_MUXSEL_MASK 0x1f
#define  LVDS_D_CFG6_MUXSEL_SHIFT 0
#define  LVDS_D_CFG6_MUXSEL_MASK_SHIFT(reg) (((reg) & LVDS_D_CFG6_MUXSEL_MASK) >> LVDS_D_CFG6_MUXSEL_SHIFT)
#define  LVDS_D_CFG6_MUXSEL_REPLACE_VAL(reg,val) (((reg) & ~LVDS_D_CFG6_MUXSEL_MASK) | (((uint32_t)val) << LVDS_D_CFG6_MUXSEL_SHIFT))

//====================================================================
//Register: LVDS D channel[j] bit[i] Configuration Register (Instance 8 of 42) (D_CFG7)
/** \brief D_CFGn register selects the source of data to be routed to the
     LVDS PHY input port, D channel[j] bit[i], where n = j*7 + i. <BR> <BR>
        D_CFG0-6 for D channel[0] bit[0-6] <BR>
        D_CFG7-13 for D channel[1] bit[0-6] <BR>
        D_CFG14-20 for D channel[2] bit[0-6] <BR>
        D_CFG21-27 for D channel[3] bit[0-6] <BR>
        D_CFG28-34 for D channel[4] bit[0-6] <BR>
        D_CFG35-41 for D channel[5] bit[0-6] <BR> <BR>
     The sources of D are the data and control lines from the
     LCD parallel panel interface: <BR>
     LDD[23:0] (pixel data), LCLK (hsync), VFCLK (vsync), and DENA (pixel valid). <BR> (Instance 8 of 42)*/
//====================================================================

#define  LVDS_D_CFG7_RESERVED1_MASK 0xffffffe0
#define  LVDS_D_CFG7_RESERVED1_SHIFT 5
#define  LVDS_D_CFG7_RESERVED1_MASK_SHIFT(reg) (((reg) & LVDS_D_CFG7_RESERVED1_MASK) >> LVDS_D_CFG7_RESERVED1_SHIFT)
#define  LVDS_D_CFG7_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~LVDS_D_CFG7_RESERVED1_MASK) | (((uint32_t)val) << LVDS_D_CFG7_RESERVED1_SHIFT))

#define  LVDS_D_CFG7_MUXSEL_MASK 0x1f
#define  LVDS_D_CFG7_MUXSEL_SHIFT 0
#define  LVDS_D_CFG7_MUXSEL_MASK_SHIFT(reg) (((reg) & LVDS_D_CFG7_MUXSEL_MASK) >> LVDS_D_CFG7_MUXSEL_SHIFT)
#define  LVDS_D_CFG7_MUXSEL_REPLACE_VAL(reg,val) (((reg) & ~LVDS_D_CFG7_MUXSEL_MASK) | (((uint32_t)val) << LVDS_D_CFG7_MUXSEL_SHIFT))

//====================================================================
//Register: LVDS D channel[j] bit[i] Configuration Register (Instance 9 of 42) (D_CFG8)
/** \brief D_CFGn register selects the source of data to be routed to the
     LVDS PHY input port, D channel[j] bit[i], where n = j*7 + i. <BR> <BR>
        D_CFG0-6 for D channel[0] bit[0-6] <BR>
        D_CFG7-13 for D channel[1] bit[0-6] <BR>
        D_CFG14-20 for D channel[2] bit[0-6] <BR>
        D_CFG21-27 for D channel[3] bit[0-6] <BR>
        D_CFG28-34 for D channel[4] bit[0-6] <BR>
        D_CFG35-41 for D channel[5] bit[0-6] <BR> <BR>
     The sources of D are the data and control lines from the
     LCD parallel panel interface: <BR>
     LDD[23:0] (pixel data), LCLK (hsync), VFCLK (vsync), and DENA (pixel valid). <BR> (Instance 9 of 42)*/
//====================================================================

#define  LVDS_D_CFG8_RESERVED1_MASK 0xffffffe0
#define  LVDS_D_CFG8_RESERVED1_SHIFT 5
#define  LVDS_D_CFG8_RESERVED1_MASK_SHIFT(reg) (((reg) & LVDS_D_CFG8_RESERVED1_MASK) >> LVDS_D_CFG8_RESERVED1_SHIFT)
#define  LVDS_D_CFG8_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~LVDS_D_CFG8_RESERVED1_MASK) | (((uint32_t)val) << LVDS_D_CFG8_RESERVED1_SHIFT))

#define  LVDS_D_CFG8_MUXSEL_MASK 0x1f
#define  LVDS_D_CFG8_MUXSEL_SHIFT 0
#define  LVDS_D_CFG8_MUXSEL_MASK_SHIFT(reg) (((reg) & LVDS_D_CFG8_MUXSEL_MASK) >> LVDS_D_CFG8_MUXSEL_SHIFT)
#define  LVDS_D_CFG8_MUXSEL_REPLACE_VAL(reg,val) (((reg) & ~LVDS_D_CFG8_MUXSEL_MASK) | (((uint32_t)val) << LVDS_D_CFG8_MUXSEL_SHIFT))

//====================================================================
//Register: LVDS D channel[j] bit[i] Configuration Register (Instance 10 of 42) (D_CFG9)
/** \brief D_CFGn register selects the source of data to be routed to the
     LVDS PHY input port, D channel[j] bit[i], where n = j*7 + i. <BR> <BR>
        D_CFG0-6 for D channel[0] bit[0-6] <BR>
        D_CFG7-13 for D channel[1] bit[0-6] <BR>
        D_CFG14-20 for D channel[2] bit[0-6] <BR>
        D_CFG21-27 for D channel[3] bit[0-6] <BR>
        D_CFG28-34 for D channel[4] bit[0-6] <BR>
        D_CFG35-41 for D channel[5] bit[0-6] <BR> <BR>
     The sources of D are the data and control lines from the
     LCD parallel panel interface: <BR>
     LDD[23:0] (pixel data), LCLK (hsync), VFCLK (vsync), and DENA (pixel valid). <BR> (Instance 10 of 42)*/
//====================================================================

#define  LVDS_D_CFG9_RESERVED1_MASK 0xffffffe0
#define  LVDS_D_CFG9_RESERVED1_SHIFT 5
#define  LVDS_D_CFG9_RESERVED1_MASK_SHIFT(reg) (((reg) & LVDS_D_CFG9_RESERVED1_MASK) >> LVDS_D_CFG9_RESERVED1_SHIFT)
#define  LVDS_D_CFG9_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~LVDS_D_CFG9_RESERVED1_MASK) | (((uint32_t)val) << LVDS_D_CFG9_RESERVED1_SHIFT))

#define  LVDS_D_CFG9_MUXSEL_MASK 0x1f
#define  LVDS_D_CFG9_MUXSEL_SHIFT 0
#define  LVDS_D_CFG9_MUXSEL_MASK_SHIFT(reg) (((reg) & LVDS_D_CFG9_MUXSEL_MASK) >> LVDS_D_CFG9_MUXSEL_SHIFT)
#define  LVDS_D_CFG9_MUXSEL_REPLACE_VAL(reg,val) (((reg) & ~LVDS_D_CFG9_MUXSEL_MASK) | (((uint32_t)val) << LVDS_D_CFG9_MUXSEL_SHIFT))

//====================================================================
//Register: LVDS D channel[j] bit[i] Configuration Register (Instance 11 of 42) (D_CFG10)
/** \brief D_CFGn register selects the source of data to be routed to the
     LVDS PHY input port, D channel[j] bit[i], where n = j*7 + i. <BR> <BR>
        D_CFG0-6 for D channel[0] bit[0-6] <BR>
        D_CFG7-13 for D channel[1] bit[0-6] <BR>
        D_CFG14-20 for D channel[2] bit[0-6] <BR>
        D_CFG21-27 for D channel[3] bit[0-6] <BR>
        D_CFG28-34 for D channel[4] bit[0-6] <BR>
        D_CFG35-41 for D channel[5] bit[0-6] <BR> <BR>
     The sources of D are the data and control lines from the
     LCD parallel panel interface: <BR>
     LDD[23:0] (pixel data), LCLK (hsync), VFCLK (vsync), and DENA (pixel valid). <BR> (Instance 11 of 42)*/
//====================================================================

#define  LVDS_D_CFG10_RESERVED1_MASK 0xffffffe0
#define  LVDS_D_CFG10_RESERVED1_SHIFT 5
#define  LVDS_D_CFG10_RESERVED1_MASK_SHIFT(reg) (((reg) & LVDS_D_CFG10_RESERVED1_MASK) >> LVDS_D_CFG10_RESERVED1_SHIFT)
#define  LVDS_D_CFG10_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~LVDS_D_CFG10_RESERVED1_MASK) | (((uint32_t)val) << LVDS_D_CFG10_RESERVED1_SHIFT))

#define  LVDS_D_CFG10_MUXSEL_MASK 0x1f
#define  LVDS_D_CFG10_MUXSEL_SHIFT 0
#define  LVDS_D_CFG10_MUXSEL_MASK_SHIFT(reg) (((reg) & LVDS_D_CFG10_MUXSEL_MASK) >> LVDS_D_CFG10_MUXSEL_SHIFT)
#define  LVDS_D_CFG10_MUXSEL_REPLACE_VAL(reg,val) (((reg) & ~LVDS_D_CFG10_MUXSEL_MASK) | (((uint32_t)val) << LVDS_D_CFG10_MUXSEL_SHIFT))

//====================================================================
//Register: LVDS D channel[j] bit[i] Configuration Register (Instance 12 of 42) (D_CFG11)
/** \brief D_CFGn register selects the source of data to be routed to the
     LVDS PHY input port, D channel[j] bit[i], where n = j*7 + i. <BR> <BR>
        D_CFG0-6 for D channel[0] bit[0-6] <BR>
        D_CFG7-13 for D channel[1] bit[0-6] <BR>
        D_CFG14-20 for D channel[2] bit[0-6] <BR>
        D_CFG21-27 for D channel[3] bit[0-6] <BR>
        D_CFG28-34 for D channel[4] bit[0-6] <BR>
        D_CFG35-41 for D channel[5] bit[0-6] <BR> <BR>
     The sources of D are the data and control lines from the
     LCD parallel panel interface: <BR>
     LDD[23:0] (pixel data), LCLK (hsync), VFCLK (vsync), and DENA (pixel valid). <BR> (Instance 12 of 42)*/
//====================================================================

#define  LVDS_D_CFG11_RESERVED1_MASK 0xffffffe0
#define  LVDS_D_CFG11_RESERVED1_SHIFT 5
#define  LVDS_D_CFG11_RESERVED1_MASK_SHIFT(reg) (((reg) & LVDS_D_CFG11_RESERVED1_MASK) >> LVDS_D_CFG11_RESERVED1_SHIFT)
#define  LVDS_D_CFG11_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~LVDS_D_CFG11_RESERVED1_MASK) | (((uint32_t)val) << LVDS_D_CFG11_RESERVED1_SHIFT))

#define  LVDS_D_CFG11_MUXSEL_MASK 0x1f
#define  LVDS_D_CFG11_MUXSEL_SHIFT 0
#define  LVDS_D_CFG11_MUXSEL_MASK_SHIFT(reg) (((reg) & LVDS_D_CFG11_MUXSEL_MASK) >> LVDS_D_CFG11_MUXSEL_SHIFT)
#define  LVDS_D_CFG11_MUXSEL_REPLACE_VAL(reg,val) (((reg) & ~LVDS_D_CFG11_MUXSEL_MASK) | (((uint32_t)val) << LVDS_D_CFG11_MUXSEL_SHIFT))

//====================================================================
//Register: LVDS D channel[j] bit[i] Configuration Register (Instance 13 of 42) (D_CFG12)
/** \brief D_CFGn register selects the source of data to be routed to the
     LVDS PHY input port, D channel[j] bit[i], where n = j*7 + i. <BR> <BR>
        D_CFG0-6 for D channel[0] bit[0-6] <BR>
        D_CFG7-13 for D channel[1] bit[0-6] <BR>
        D_CFG14-20 for D channel[2] bit[0-6] <BR>
        D_CFG21-27 for D channel[3] bit[0-6] <BR>
        D_CFG28-34 for D channel[4] bit[0-6] <BR>
        D_CFG35-41 for D channel[5] bit[0-6] <BR> <BR>
     The sources of D are the data and control lines from the
     LCD parallel panel interface: <BR>
     LDD[23:0] (pixel data), LCLK (hsync), VFCLK (vsync), and DENA (pixel valid). <BR> (Instance 13 of 42)*/
//====================================================================

#define  LVDS_D_CFG12_RESERVED1_MASK 0xffffffe0
#define  LVDS_D_CFG12_RESERVED1_SHIFT 5
#define  LVDS_D_CFG12_RESERVED1_MASK_SHIFT(reg) (((reg) & LVDS_D_CFG12_RESERVED1_MASK) >> LVDS_D_CFG12_RESERVED1_SHIFT)
#define  LVDS_D_CFG12_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~LVDS_D_CFG12_RESERVED1_MASK) | (((uint32_t)val) << LVDS_D_CFG12_RESERVED1_SHIFT))

#define  LVDS_D_CFG12_MUXSEL_MASK 0x1f
#define  LVDS_D_CFG12_MUXSEL_SHIFT 0
#define  LVDS_D_CFG12_MUXSEL_MASK_SHIFT(reg) (((reg) & LVDS_D_CFG12_MUXSEL_MASK) >> LVDS_D_CFG12_MUXSEL_SHIFT)
#define  LVDS_D_CFG12_MUXSEL_REPLACE_VAL(reg,val) (((reg) & ~LVDS_D_CFG12_MUXSEL_MASK) | (((uint32_t)val) << LVDS_D_CFG12_MUXSEL_SHIFT))

//====================================================================
//Register: LVDS D channel[j] bit[i] Configuration Register (Instance 14 of 42) (D_CFG13)
/** \brief D_CFGn register selects the source of data to be routed to the
     LVDS PHY input port, D channel[j] bit[i], where n = j*7 + i. <BR> <BR>
        D_CFG0-6 for D channel[0] bit[0-6] <BR>
        D_CFG7-13 for D channel[1] bit[0-6] <BR>
        D_CFG14-20 for D channel[2] bit[0-6] <BR>
        D_CFG21-27 for D channel[3] bit[0-6] <BR>
        D_CFG28-34 for D channel[4] bit[0-6] <BR>
        D_CFG35-41 for D channel[5] bit[0-6] <BR> <BR>
     The sources of D are the data and control lines from the
     LCD parallel panel interface: <BR>
     LDD[23:0] (pixel data), LCLK (hsync), VFCLK (vsync), and DENA (pixel valid). <BR> (Instance 14 of 42)*/
//====================================================================

#define  LVDS_D_CFG13_RESERVED1_MASK 0xffffffe0
#define  LVDS_D_CFG13_RESERVED1_SHIFT 5
#define  LVDS_D_CFG13_RESERVED1_MASK_SHIFT(reg) (((reg) & LVDS_D_CFG13_RESERVED1_MASK) >> LVDS_D_CFG13_RESERVED1_SHIFT)
#define  LVDS_D_CFG13_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~LVDS_D_CFG13_RESERVED1_MASK) | (((uint32_t)val) << LVDS_D_CFG13_RESERVED1_SHIFT))

#define  LVDS_D_CFG13_MUXSEL_MASK 0x1f
#define  LVDS_D_CFG13_MUXSEL_SHIFT 0
#define  LVDS_D_CFG13_MUXSEL_MASK_SHIFT(reg) (((reg) & LVDS_D_CFG13_MUXSEL_MASK) >> LVDS_D_CFG13_MUXSEL_SHIFT)
#define  LVDS_D_CFG13_MUXSEL_REPLACE_VAL(reg,val) (((reg) & ~LVDS_D_CFG13_MUXSEL_MASK) | (((uint32_t)val) << LVDS_D_CFG13_MUXSEL_SHIFT))

//====================================================================
//Register: LVDS D channel[j] bit[i] Configuration Register (Instance 15 of 42) (D_CFG14)
/** \brief D_CFGn register selects the source of data to be routed to the
     LVDS PHY input port, D channel[j] bit[i], where n = j*7 + i. <BR> <BR>
        D_CFG0-6 for D channel[0] bit[0-6] <BR>
        D_CFG7-13 for D channel[1] bit[0-6] <BR>
        D_CFG14-20 for D channel[2] bit[0-6] <BR>
        D_CFG21-27 for D channel[3] bit[0-6] <BR>
        D_CFG28-34 for D channel[4] bit[0-6] <BR>
        D_CFG35-41 for D channel[5] bit[0-6] <BR> <BR>
     The sources of D are the data and control lines from the
     LCD parallel panel interface: <BR>
     LDD[23:0] (pixel data), LCLK (hsync), VFCLK (vsync), and DENA (pixel valid). <BR> (Instance 15 of 42)*/
//====================================================================

#define  LVDS_D_CFG14_RESERVED1_MASK 0xffffffe0
#define  LVDS_D_CFG14_RESERVED1_SHIFT 5
#define  LVDS_D_CFG14_RESERVED1_MASK_SHIFT(reg) (((reg) & LVDS_D_CFG14_RESERVED1_MASK) >> LVDS_D_CFG14_RESERVED1_SHIFT)
#define  LVDS_D_CFG14_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~LVDS_D_CFG14_RESERVED1_MASK) | (((uint32_t)val) << LVDS_D_CFG14_RESERVED1_SHIFT))

#define  LVDS_D_CFG14_MUXSEL_MASK 0x1f
#define  LVDS_D_CFG14_MUXSEL_SHIFT 0
#define  LVDS_D_CFG14_MUXSEL_MASK_SHIFT(reg) (((reg) & LVDS_D_CFG14_MUXSEL_MASK) >> LVDS_D_CFG14_MUXSEL_SHIFT)
#define  LVDS_D_CFG14_MUXSEL_REPLACE_VAL(reg,val) (((reg) & ~LVDS_D_CFG14_MUXSEL_MASK) | (((uint32_t)val) << LVDS_D_CFG14_MUXSEL_SHIFT))

//====================================================================
//Register: LVDS D channel[j] bit[i] Configuration Register (Instance 16 of 42) (D_CFG15)
/** \brief D_CFGn register selects the source of data to be routed to the
     LVDS PHY input port, D channel[j] bit[i], where n = j*7 + i. <BR> <BR>
        D_CFG0-6 for D channel[0] bit[0-6] <BR>
        D_CFG7-13 for D channel[1] bit[0-6] <BR>
        D_CFG14-20 for D channel[2] bit[0-6] <BR>
        D_CFG21-27 for D channel[3] bit[0-6] <BR>
        D_CFG28-34 for D channel[4] bit[0-6] <BR>
        D_CFG35-41 for D channel[5] bit[0-6] <BR> <BR>
     The sources of D are the data and control lines from the
     LCD parallel panel interface: <BR>
     LDD[23:0] (pixel data), LCLK (hsync), VFCLK (vsync), and DENA (pixel valid). <BR> (Instance 16 of 42)*/
//====================================================================

#define  LVDS_D_CFG15_RESERVED1_MASK 0xffffffe0
#define  LVDS_D_CFG15_RESERVED1_SHIFT 5
#define  LVDS_D_CFG15_RESERVED1_MASK_SHIFT(reg) (((reg) & LVDS_D_CFG15_RESERVED1_MASK) >> LVDS_D_CFG15_RESERVED1_SHIFT)
#define  LVDS_D_CFG15_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~LVDS_D_CFG15_RESERVED1_MASK) | (((uint32_t)val) << LVDS_D_CFG15_RESERVED1_SHIFT))

#define  LVDS_D_CFG15_MUXSEL_MASK 0x1f
#define  LVDS_D_CFG15_MUXSEL_SHIFT 0
#define  LVDS_D_CFG15_MUXSEL_MASK_SHIFT(reg) (((reg) & LVDS_D_CFG15_MUXSEL_MASK) >> LVDS_D_CFG15_MUXSEL_SHIFT)
#define  LVDS_D_CFG15_MUXSEL_REPLACE_VAL(reg,val) (((reg) & ~LVDS_D_CFG15_MUXSEL_MASK) | (((uint32_t)val) << LVDS_D_CFG15_MUXSEL_SHIFT))

//====================================================================
//Register: LVDS D channel[j] bit[i] Configuration Register (Instance 17 of 42) (D_CFG16)
/** \brief D_CFGn register selects the source of data to be routed to the
     LVDS PHY input port, D channel[j] bit[i], where n = j*7 + i. <BR> <BR>
        D_CFG0-6 for D channel[0] bit[0-6] <BR>
        D_CFG7-13 for D channel[1] bit[0-6] <BR>
        D_CFG14-20 for D channel[2] bit[0-6] <BR>
        D_CFG21-27 for D channel[3] bit[0-6] <BR>
        D_CFG28-34 for D channel[4] bit[0-6] <BR>
        D_CFG35-41 for D channel[5] bit[0-6] <BR> <BR>
     The sources of D are the data and control lines from the
     LCD parallel panel interface: <BR>
     LDD[23:0] (pixel data), LCLK (hsync), VFCLK (vsync), and DENA (pixel valid). <BR> (Instance 17 of 42)*/
//====================================================================

#define  LVDS_D_CFG16_RESERVED1_MASK 0xffffffe0
#define  LVDS_D_CFG16_RESERVED1_SHIFT 5
#define  LVDS_D_CFG16_RESERVED1_MASK_SHIFT(reg) (((reg) & LVDS_D_CFG16_RESERVED1_MASK) >> LVDS_D_CFG16_RESERVED1_SHIFT)
#define  LVDS_D_CFG16_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~LVDS_D_CFG16_RESERVED1_MASK) | (((uint32_t)val) << LVDS_D_CFG16_RESERVED1_SHIFT))

#define  LVDS_D_CFG16_MUXSEL_MASK 0x1f
#define  LVDS_D_CFG16_MUXSEL_SHIFT 0
#define  LVDS_D_CFG16_MUXSEL_MASK_SHIFT(reg) (((reg) & LVDS_D_CFG16_MUXSEL_MASK) >> LVDS_D_CFG16_MUXSEL_SHIFT)
#define  LVDS_D_CFG16_MUXSEL_REPLACE_VAL(reg,val) (((reg) & ~LVDS_D_CFG16_MUXSEL_MASK) | (((uint32_t)val) << LVDS_D_CFG16_MUXSEL_SHIFT))

//====================================================================
//Register: LVDS D channel[j] bit[i] Configuration Register (Instance 18 of 42) (D_CFG17)
/** \brief D_CFGn register selects the source of data to be routed to the
     LVDS PHY input port, D channel[j] bit[i], where n = j*7 + i. <BR> <BR>
        D_CFG0-6 for D channel[0] bit[0-6] <BR>
        D_CFG7-13 for D channel[1] bit[0-6] <BR>
        D_CFG14-20 for D channel[2] bit[0-6] <BR>
        D_CFG21-27 for D channel[3] bit[0-6] <BR>
        D_CFG28-34 for D channel[4] bit[0-6] <BR>
        D_CFG35-41 for D channel[5] bit[0-6] <BR> <BR>
     The sources of D are the data and control lines from the
     LCD parallel panel interface: <BR>
     LDD[23:0] (pixel data), LCLK (hsync), VFCLK (vsync), and DENA (pixel valid). <BR> (Instance 18 of 42)*/
//====================================================================

#define  LVDS_D_CFG17_RESERVED1_MASK 0xffffffe0
#define  LVDS_D_CFG17_RESERVED1_SHIFT 5
#define  LVDS_D_CFG17_RESERVED1_MASK_SHIFT(reg) (((reg) & LVDS_D_CFG17_RESERVED1_MASK) >> LVDS_D_CFG17_RESERVED1_SHIFT)
#define  LVDS_D_CFG17_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~LVDS_D_CFG17_RESERVED1_MASK) | (((uint32_t)val) << LVDS_D_CFG17_RESERVED1_SHIFT))

#define  LVDS_D_CFG17_MUXSEL_MASK 0x1f
#define  LVDS_D_CFG17_MUXSEL_SHIFT 0
#define  LVDS_D_CFG17_MUXSEL_MASK_SHIFT(reg) (((reg) & LVDS_D_CFG17_MUXSEL_MASK) >> LVDS_D_CFG17_MUXSEL_SHIFT)
#define  LVDS_D_CFG17_MUXSEL_REPLACE_VAL(reg,val) (((reg) & ~LVDS_D_CFG17_MUXSEL_MASK) | (((uint32_t)val) << LVDS_D_CFG17_MUXSEL_SHIFT))

//====================================================================
//Register: LVDS D channel[j] bit[i] Configuration Register (Instance 19 of 42) (D_CFG18)
/** \brief D_CFGn register selects the source of data to be routed to the
     LVDS PHY input port, D channel[j] bit[i], where n = j*7 + i. <BR> <BR>
        D_CFG0-6 for D channel[0] bit[0-6] <BR>
        D_CFG7-13 for D channel[1] bit[0-6] <BR>
        D_CFG14-20 for D channel[2] bit[0-6] <BR>
        D_CFG21-27 for D channel[3] bit[0-6] <BR>
        D_CFG28-34 for D channel[4] bit[0-6] <BR>
        D_CFG35-41 for D channel[5] bit[0-6] <BR> <BR>
     The sources of D are the data and control lines from the
     LCD parallel panel interface: <BR>
     LDD[23:0] (pixel data), LCLK (hsync), VFCLK (vsync), and DENA (pixel valid). <BR> (Instance 19 of 42)*/
//====================================================================

#define  LVDS_D_CFG18_RESERVED1_MASK 0xffffffe0
#define  LVDS_D_CFG18_RESERVED1_SHIFT 5
#define  LVDS_D_CFG18_RESERVED1_MASK_SHIFT(reg) (((reg) & LVDS_D_CFG18_RESERVED1_MASK) >> LVDS_D_CFG18_RESERVED1_SHIFT)
#define  LVDS_D_CFG18_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~LVDS_D_CFG18_RESERVED1_MASK) | (((uint32_t)val) << LVDS_D_CFG18_RESERVED1_SHIFT))

#define  LVDS_D_CFG18_MUXSEL_MASK 0x1f
#define  LVDS_D_CFG18_MUXSEL_SHIFT 0
#define  LVDS_D_CFG18_MUXSEL_MASK_SHIFT(reg) (((reg) & LVDS_D_CFG18_MUXSEL_MASK) >> LVDS_D_CFG18_MUXSEL_SHIFT)
#define  LVDS_D_CFG18_MUXSEL_REPLACE_VAL(reg,val) (((reg) & ~LVDS_D_CFG18_MUXSEL_MASK) | (((uint32_t)val) << LVDS_D_CFG18_MUXSEL_SHIFT))

//====================================================================
//Register: LVDS D channel[j] bit[i] Configuration Register (Instance 20 of 42) (D_CFG19)
/** \brief D_CFGn register selects the source of data to be routed to the
     LVDS PHY input port, D channel[j] bit[i], where n = j*7 + i. <BR> <BR>
        D_CFG0-6 for D channel[0] bit[0-6] <BR>
        D_CFG7-13 for D channel[1] bit[0-6] <BR>
        D_CFG14-20 for D channel[2] bit[0-6] <BR>
        D_CFG21-27 for D channel[3] bit[0-6] <BR>
        D_CFG28-34 for D channel[4] bit[0-6] <BR>
        D_CFG35-41 for D channel[5] bit[0-6] <BR> <BR>
     The sources of D are the data and control lines from the
     LCD parallel panel interface: <BR>
     LDD[23:0] (pixel data), LCLK (hsync), VFCLK (vsync), and DENA (pixel valid). <BR> (Instance 20 of 42)*/
//====================================================================

#define  LVDS_D_CFG19_RESERVED1_MASK 0xffffffe0
#define  LVDS_D_CFG19_RESERVED1_SHIFT 5
#define  LVDS_D_CFG19_RESERVED1_MASK_SHIFT(reg) (((reg) & LVDS_D_CFG19_RESERVED1_MASK) >> LVDS_D_CFG19_RESERVED1_SHIFT)
#define  LVDS_D_CFG19_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~LVDS_D_CFG19_RESERVED1_MASK) | (((uint32_t)val) << LVDS_D_CFG19_RESERVED1_SHIFT))

#define  LVDS_D_CFG19_MUXSEL_MASK 0x1f
#define  LVDS_D_CFG19_MUXSEL_SHIFT 0
#define  LVDS_D_CFG19_MUXSEL_MASK_SHIFT(reg) (((reg) & LVDS_D_CFG19_MUXSEL_MASK) >> LVDS_D_CFG19_MUXSEL_SHIFT)
#define  LVDS_D_CFG19_MUXSEL_REPLACE_VAL(reg,val) (((reg) & ~LVDS_D_CFG19_MUXSEL_MASK) | (((uint32_t)val) << LVDS_D_CFG19_MUXSEL_SHIFT))

//====================================================================
//Register: LVDS D channel[j] bit[i] Configuration Register (Instance 21 of 42) (D_CFG20)
/** \brief D_CFGn register selects the source of data to be routed to the
     LVDS PHY input port, D channel[j] bit[i], where n = j*7 + i. <BR> <BR>
        D_CFG0-6 for D channel[0] bit[0-6] <BR>
        D_CFG7-13 for D channel[1] bit[0-6] <BR>
        D_CFG14-20 for D channel[2] bit[0-6] <BR>
        D_CFG21-27 for D channel[3] bit[0-6] <BR>
        D_CFG28-34 for D channel[4] bit[0-6] <BR>
        D_CFG35-41 for D channel[5] bit[0-6] <BR> <BR>
     The sources of D are the data and control lines from the
     LCD parallel panel interface: <BR>
     LDD[23:0] (pixel data), LCLK (hsync), VFCLK (vsync), and DENA (pixel valid). <BR> (Instance 21 of 42)*/
//====================================================================

#define  LVDS_D_CFG20_RESERVED1_MASK 0xffffffe0
#define  LVDS_D_CFG20_RESERVED1_SHIFT 5
#define  LVDS_D_CFG20_RESERVED1_MASK_SHIFT(reg) (((reg) & LVDS_D_CFG20_RESERVED1_MASK) >> LVDS_D_CFG20_RESERVED1_SHIFT)
#define  LVDS_D_CFG20_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~LVDS_D_CFG20_RESERVED1_MASK) | (((uint32_t)val) << LVDS_D_CFG20_RESERVED1_SHIFT))

#define  LVDS_D_CFG20_MUXSEL_MASK 0x1f
#define  LVDS_D_CFG20_MUXSEL_SHIFT 0
#define  LVDS_D_CFG20_MUXSEL_MASK_SHIFT(reg) (((reg) & LVDS_D_CFG20_MUXSEL_MASK) >> LVDS_D_CFG20_MUXSEL_SHIFT)
#define  LVDS_D_CFG20_MUXSEL_REPLACE_VAL(reg,val) (((reg) & ~LVDS_D_CFG20_MUXSEL_MASK) | (((uint32_t)val) << LVDS_D_CFG20_MUXSEL_SHIFT))

//====================================================================
//Register: LVDS D channel[j] bit[i] Configuration Register (Instance 22 of 42) (D_CFG21)
/** \brief D_CFGn register selects the source of data to be routed to the
     LVDS PHY input port, D channel[j] bit[i], where n = j*7 + i. <BR> <BR>
        D_CFG0-6 for D channel[0] bit[0-6] <BR>
        D_CFG7-13 for D channel[1] bit[0-6] <BR>
        D_CFG14-20 for D channel[2] bit[0-6] <BR>
        D_CFG21-27 for D channel[3] bit[0-6] <BR>
        D_CFG28-34 for D channel[4] bit[0-6] <BR>
        D_CFG35-41 for D channel[5] bit[0-6] <BR> <BR>
     The sources of D are the data and control lines from the
     LCD parallel panel interface: <BR>
     LDD[23:0] (pixel data), LCLK (hsync), VFCLK (vsync), and DENA (pixel valid). <BR> (Instance 22 of 42)*/
//====================================================================

#define  LVDS_D_CFG21_RESERVED1_MASK 0xffffffe0
#define  LVDS_D_CFG21_RESERVED1_SHIFT 5
#define  LVDS_D_CFG21_RESERVED1_MASK_SHIFT(reg) (((reg) & LVDS_D_CFG21_RESERVED1_MASK) >> LVDS_D_CFG21_RESERVED1_SHIFT)
#define  LVDS_D_CFG21_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~LVDS_D_CFG21_RESERVED1_MASK) | (((uint32_t)val) << LVDS_D_CFG21_RESERVED1_SHIFT))

#define  LVDS_D_CFG21_MUXSEL_MASK 0x1f
#define  LVDS_D_CFG21_MUXSEL_SHIFT 0
#define  LVDS_D_CFG21_MUXSEL_MASK_SHIFT(reg) (((reg) & LVDS_D_CFG21_MUXSEL_MASK) >> LVDS_D_CFG21_MUXSEL_SHIFT)
#define  LVDS_D_CFG21_MUXSEL_REPLACE_VAL(reg,val) (((reg) & ~LVDS_D_CFG21_MUXSEL_MASK) | (((uint32_t)val) << LVDS_D_CFG21_MUXSEL_SHIFT))

//====================================================================
//Register: LVDS D channel[j] bit[i] Configuration Register (Instance 23 of 42) (D_CFG22)
/** \brief D_CFGn register selects the source of data to be routed to the
     LVDS PHY input port, D channel[j] bit[i], where n = j*7 + i. <BR> <BR>
        D_CFG0-6 for D channel[0] bit[0-6] <BR>
        D_CFG7-13 for D channel[1] bit[0-6] <BR>
        D_CFG14-20 for D channel[2] bit[0-6] <BR>
        D_CFG21-27 for D channel[3] bit[0-6] <BR>
        D_CFG28-34 for D channel[4] bit[0-6] <BR>
        D_CFG35-41 for D channel[5] bit[0-6] <BR> <BR>
     The sources of D are the data and control lines from the
     LCD parallel panel interface: <BR>
     LDD[23:0] (pixel data), LCLK (hsync), VFCLK (vsync), and DENA (pixel valid). <BR> (Instance 23 of 42)*/
//====================================================================

#define  LVDS_D_CFG22_RESERVED1_MASK 0xffffffe0
#define  LVDS_D_CFG22_RESERVED1_SHIFT 5
#define  LVDS_D_CFG22_RESERVED1_MASK_SHIFT(reg) (((reg) & LVDS_D_CFG22_RESERVED1_MASK) >> LVDS_D_CFG22_RESERVED1_SHIFT)
#define  LVDS_D_CFG22_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~LVDS_D_CFG22_RESERVED1_MASK) | (((uint32_t)val) << LVDS_D_CFG22_RESERVED1_SHIFT))

#define  LVDS_D_CFG22_MUXSEL_MASK 0x1f
#define  LVDS_D_CFG22_MUXSEL_SHIFT 0
#define  LVDS_D_CFG22_MUXSEL_MASK_SHIFT(reg) (((reg) & LVDS_D_CFG22_MUXSEL_MASK) >> LVDS_D_CFG22_MUXSEL_SHIFT)
#define  LVDS_D_CFG22_MUXSEL_REPLACE_VAL(reg,val) (((reg) & ~LVDS_D_CFG22_MUXSEL_MASK) | (((uint32_t)val) << LVDS_D_CFG22_MUXSEL_SHIFT))

//====================================================================
//Register: LVDS D channel[j] bit[i] Configuration Register (Instance 24 of 42) (D_CFG23)
/** \brief D_CFGn register selects the source of data to be routed to the
     LVDS PHY input port, D channel[j] bit[i], where n = j*7 + i. <BR> <BR>
        D_CFG0-6 for D channel[0] bit[0-6] <BR>
        D_CFG7-13 for D channel[1] bit[0-6] <BR>
        D_CFG14-20 for D channel[2] bit[0-6] <BR>
        D_CFG21-27 for D channel[3] bit[0-6] <BR>
        D_CFG28-34 for D channel[4] bit[0-6] <BR>
        D_CFG35-41 for D channel[5] bit[0-6] <BR> <BR>
     The sources of D are the data and control lines from the
     LCD parallel panel interface: <BR>
     LDD[23:0] (pixel data), LCLK (hsync), VFCLK (vsync), and DENA (pixel valid). <BR> (Instance 24 of 42)*/
//====================================================================

#define  LVDS_D_CFG23_RESERVED1_MASK 0xffffffe0
#define  LVDS_D_CFG23_RESERVED1_SHIFT 5
#define  LVDS_D_CFG23_RESERVED1_MASK_SHIFT(reg) (((reg) & LVDS_D_CFG23_RESERVED1_MASK) >> LVDS_D_CFG23_RESERVED1_SHIFT)
#define  LVDS_D_CFG23_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~LVDS_D_CFG23_RESERVED1_MASK) | (((uint32_t)val) << LVDS_D_CFG23_RESERVED1_SHIFT))

#define  LVDS_D_CFG23_MUXSEL_MASK 0x1f
#define  LVDS_D_CFG23_MUXSEL_SHIFT 0
#define  LVDS_D_CFG23_MUXSEL_MASK_SHIFT(reg) (((reg) & LVDS_D_CFG23_MUXSEL_MASK) >> LVDS_D_CFG23_MUXSEL_SHIFT)
#define  LVDS_D_CFG23_MUXSEL_REPLACE_VAL(reg,val) (((reg) & ~LVDS_D_CFG23_MUXSEL_MASK) | (((uint32_t)val) << LVDS_D_CFG23_MUXSEL_SHIFT))

//====================================================================
//Register: LVDS D channel[j] bit[i] Configuration Register (Instance 25 of 42) (D_CFG24)
/** \brief D_CFGn register selects the source of data to be routed to the
     LVDS PHY input port, D channel[j] bit[i], where n = j*7 + i. <BR> <BR>
        D_CFG0-6 for D channel[0] bit[0-6] <BR>
        D_CFG7-13 for D channel[1] bit[0-6] <BR>
        D_CFG14-20 for D channel[2] bit[0-6] <BR>
        D_CFG21-27 for D channel[3] bit[0-6] <BR>
        D_CFG28-34 for D channel[4] bit[0-6] <BR>
        D_CFG35-41 for D channel[5] bit[0-6] <BR> <BR>
     The sources of D are the data and control lines from the
     LCD parallel panel interface: <BR>
     LDD[23:0] (pixel data), LCLK (hsync), VFCLK (vsync), and DENA (pixel valid). <BR> (Instance 25 of 42)*/
//====================================================================

#define  LVDS_D_CFG24_RESERVED1_MASK 0xffffffe0
#define  LVDS_D_CFG24_RESERVED1_SHIFT 5
#define  LVDS_D_CFG24_RESERVED1_MASK_SHIFT(reg) (((reg) & LVDS_D_CFG24_RESERVED1_MASK) >> LVDS_D_CFG24_RESERVED1_SHIFT)
#define  LVDS_D_CFG24_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~LVDS_D_CFG24_RESERVED1_MASK) | (((uint32_t)val) << LVDS_D_CFG24_RESERVED1_SHIFT))

#define  LVDS_D_CFG24_MUXSEL_MASK 0x1f
#define  LVDS_D_CFG24_MUXSEL_SHIFT 0
#define  LVDS_D_CFG24_MUXSEL_MASK_SHIFT(reg) (((reg) & LVDS_D_CFG24_MUXSEL_MASK) >> LVDS_D_CFG24_MUXSEL_SHIFT)
#define  LVDS_D_CFG24_MUXSEL_REPLACE_VAL(reg,val) (((reg) & ~LVDS_D_CFG24_MUXSEL_MASK) | (((uint32_t)val) << LVDS_D_CFG24_MUXSEL_SHIFT))

//====================================================================
//Register: LVDS D channel[j] bit[i] Configuration Register (Instance 26 of 42) (D_CFG25)
/** \brief D_CFGn register selects the source of data to be routed to the
     LVDS PHY input port, D channel[j] bit[i], where n = j*7 + i. <BR> <BR>
        D_CFG0-6 for D channel[0] bit[0-6] <BR>
        D_CFG7-13 for D channel[1] bit[0-6] <BR>
        D_CFG14-20 for D channel[2] bit[0-6] <BR>
        D_CFG21-27 for D channel[3] bit[0-6] <BR>
        D_CFG28-34 for D channel[4] bit[0-6] <BR>
        D_CFG35-41 for D channel[5] bit[0-6] <BR> <BR>
     The sources of D are the data and control lines from the
     LCD parallel panel interface: <BR>
     LDD[23:0] (pixel data), LCLK (hsync), VFCLK (vsync), and DENA (pixel valid). <BR> (Instance 26 of 42)*/
//====================================================================

#define  LVDS_D_CFG25_RESERVED1_MASK 0xffffffe0
#define  LVDS_D_CFG25_RESERVED1_SHIFT 5
#define  LVDS_D_CFG25_RESERVED1_MASK_SHIFT(reg) (((reg) & LVDS_D_CFG25_RESERVED1_MASK) >> LVDS_D_CFG25_RESERVED1_SHIFT)
#define  LVDS_D_CFG25_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~LVDS_D_CFG25_RESERVED1_MASK) | (((uint32_t)val) << LVDS_D_CFG25_RESERVED1_SHIFT))

#define  LVDS_D_CFG25_MUXSEL_MASK 0x1f
#define  LVDS_D_CFG25_MUXSEL_SHIFT 0
#define  LVDS_D_CFG25_MUXSEL_MASK_SHIFT(reg) (((reg) & LVDS_D_CFG25_MUXSEL_MASK) >> LVDS_D_CFG25_MUXSEL_SHIFT)
#define  LVDS_D_CFG25_MUXSEL_REPLACE_VAL(reg,val) (((reg) & ~LVDS_D_CFG25_MUXSEL_MASK) | (((uint32_t)val) << LVDS_D_CFG25_MUXSEL_SHIFT))

//====================================================================
//Register: LVDS D channel[j] bit[i] Configuration Register (Instance 27 of 42) (D_CFG26)
/** \brief D_CFGn register selects the source of data to be routed to the
     LVDS PHY input port, D channel[j] bit[i], where n = j*7 + i. <BR> <BR>
        D_CFG0-6 for D channel[0] bit[0-6] <BR>
        D_CFG7-13 for D channel[1] bit[0-6] <BR>
        D_CFG14-20 for D channel[2] bit[0-6] <BR>
        D_CFG21-27 for D channel[3] bit[0-6] <BR>
        D_CFG28-34 for D channel[4] bit[0-6] <BR>
        D_CFG35-41 for D channel[5] bit[0-6] <BR> <BR>
     The sources of D are the data and control lines from the
     LCD parallel panel interface: <BR>
     LDD[23:0] (pixel data), LCLK (hsync), VFCLK (vsync), and DENA (pixel valid). <BR> (Instance 27 of 42)*/
//====================================================================

#define  LVDS_D_CFG26_RESERVED1_MASK 0xffffffe0
#define  LVDS_D_CFG26_RESERVED1_SHIFT 5
#define  LVDS_D_CFG26_RESERVED1_MASK_SHIFT(reg) (((reg) & LVDS_D_CFG26_RESERVED1_MASK) >> LVDS_D_CFG26_RESERVED1_SHIFT)
#define  LVDS_D_CFG26_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~LVDS_D_CFG26_RESERVED1_MASK) | (((uint32_t)val) << LVDS_D_CFG26_RESERVED1_SHIFT))

#define  LVDS_D_CFG26_MUXSEL_MASK 0x1f
#define  LVDS_D_CFG26_MUXSEL_SHIFT 0
#define  LVDS_D_CFG26_MUXSEL_MASK_SHIFT(reg) (((reg) & LVDS_D_CFG26_MUXSEL_MASK) >> LVDS_D_CFG26_MUXSEL_SHIFT)
#define  LVDS_D_CFG26_MUXSEL_REPLACE_VAL(reg,val) (((reg) & ~LVDS_D_CFG26_MUXSEL_MASK) | (((uint32_t)val) << LVDS_D_CFG26_MUXSEL_SHIFT))

//====================================================================
//Register: LVDS D channel[j] bit[i] Configuration Register (Instance 28 of 42) (D_CFG27)
/** \brief D_CFGn register selects the source of data to be routed to the
     LVDS PHY input port, D channel[j] bit[i], where n = j*7 + i. <BR> <BR>
        D_CFG0-6 for D channel[0] bit[0-6] <BR>
        D_CFG7-13 for D channel[1] bit[0-6] <BR>
        D_CFG14-20 for D channel[2] bit[0-6] <BR>
        D_CFG21-27 for D channel[3] bit[0-6] <BR>
        D_CFG28-34 for D channel[4] bit[0-6] <BR>
        D_CFG35-41 for D channel[5] bit[0-6] <BR> <BR>
     The sources of D are the data and control lines from the
     LCD parallel panel interface: <BR>
     LDD[23:0] (pixel data), LCLK (hsync), VFCLK (vsync), and DENA (pixel valid). <BR> (Instance 28 of 42)*/
//====================================================================

#define  LVDS_D_CFG27_RESERVED1_MASK 0xffffffe0
#define  LVDS_D_CFG27_RESERVED1_SHIFT 5
#define  LVDS_D_CFG27_RESERVED1_MASK_SHIFT(reg) (((reg) & LVDS_D_CFG27_RESERVED1_MASK) >> LVDS_D_CFG27_RESERVED1_SHIFT)
#define  LVDS_D_CFG27_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~LVDS_D_CFG27_RESERVED1_MASK) | (((uint32_t)val) << LVDS_D_CFG27_RESERVED1_SHIFT))

#define  LVDS_D_CFG27_MUXSEL_MASK 0x1f
#define  LVDS_D_CFG27_MUXSEL_SHIFT 0
#define  LVDS_D_CFG27_MUXSEL_MASK_SHIFT(reg) (((reg) & LVDS_D_CFG27_MUXSEL_MASK) >> LVDS_D_CFG27_MUXSEL_SHIFT)
#define  LVDS_D_CFG27_MUXSEL_REPLACE_VAL(reg,val) (((reg) & ~LVDS_D_CFG27_MUXSEL_MASK) | (((uint32_t)val) << LVDS_D_CFG27_MUXSEL_SHIFT))

//====================================================================
//Register: LVDS D channel[j] bit[i] Configuration Register (Instance 29 of 42) (D_CFG28)
/** \brief D_CFGn register selects the source of data to be routed to the
     LVDS PHY input port, D channel[j] bit[i], where n = j*7 + i. <BR> <BR>
        D_CFG0-6 for D channel[0] bit[0-6] <BR>
        D_CFG7-13 for D channel[1] bit[0-6] <BR>
        D_CFG14-20 for D channel[2] bit[0-6] <BR>
        D_CFG21-27 for D channel[3] bit[0-6] <BR>
        D_CFG28-34 for D channel[4] bit[0-6] <BR>
        D_CFG35-41 for D channel[5] bit[0-6] <BR> <BR>
     The sources of D are the data and control lines from the
     LCD parallel panel interface: <BR>
     LDD[23:0] (pixel data), LCLK (hsync), VFCLK (vsync), and DENA (pixel valid). <BR> (Instance 29 of 42)*/
//====================================================================

#define  LVDS_D_CFG28_RESERVED1_MASK 0xffffffe0
#define  LVDS_D_CFG28_RESERVED1_SHIFT 5
#define  LVDS_D_CFG28_RESERVED1_MASK_SHIFT(reg) (((reg) & LVDS_D_CFG28_RESERVED1_MASK) >> LVDS_D_CFG28_RESERVED1_SHIFT)
#define  LVDS_D_CFG28_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~LVDS_D_CFG28_RESERVED1_MASK) | (((uint32_t)val) << LVDS_D_CFG28_RESERVED1_SHIFT))

#define  LVDS_D_CFG28_MUXSEL_MASK 0x1f
#define  LVDS_D_CFG28_MUXSEL_SHIFT 0
#define  LVDS_D_CFG28_MUXSEL_MASK_SHIFT(reg) (((reg) & LVDS_D_CFG28_MUXSEL_MASK) >> LVDS_D_CFG28_MUXSEL_SHIFT)
#define  LVDS_D_CFG28_MUXSEL_REPLACE_VAL(reg,val) (((reg) & ~LVDS_D_CFG28_MUXSEL_MASK) | (((uint32_t)val) << LVDS_D_CFG28_MUXSEL_SHIFT))

//====================================================================
//Register: LVDS D channel[j] bit[i] Configuration Register (Instance 30 of 42) (D_CFG29)
/** \brief D_CFGn register selects the source of data to be routed to the
     LVDS PHY input port, D channel[j] bit[i], where n = j*7 + i. <BR> <BR>
        D_CFG0-6 for D channel[0] bit[0-6] <BR>
        D_CFG7-13 for D channel[1] bit[0-6] <BR>
        D_CFG14-20 for D channel[2] bit[0-6] <BR>
        D_CFG21-27 for D channel[3] bit[0-6] <BR>
        D_CFG28-34 for D channel[4] bit[0-6] <BR>
        D_CFG35-41 for D channel[5] bit[0-6] <BR> <BR>
     The sources of D are the data and control lines from the
     LCD parallel panel interface: <BR>
     LDD[23:0] (pixel data), LCLK (hsync), VFCLK (vsync), and DENA (pixel valid). <BR> (Instance 30 of 42)*/
//====================================================================

#define  LVDS_D_CFG29_RESERVED1_MASK 0xffffffe0
#define  LVDS_D_CFG29_RESERVED1_SHIFT 5
#define  LVDS_D_CFG29_RESERVED1_MASK_SHIFT(reg) (((reg) & LVDS_D_CFG29_RESERVED1_MASK) >> LVDS_D_CFG29_RESERVED1_SHIFT)
#define  LVDS_D_CFG29_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~LVDS_D_CFG29_RESERVED1_MASK) | (((uint32_t)val) << LVDS_D_CFG29_RESERVED1_SHIFT))

#define  LVDS_D_CFG29_MUXSEL_MASK 0x1f
#define  LVDS_D_CFG29_MUXSEL_SHIFT 0
#define  LVDS_D_CFG29_MUXSEL_MASK_SHIFT(reg) (((reg) & LVDS_D_CFG29_MUXSEL_MASK) >> LVDS_D_CFG29_MUXSEL_SHIFT)
#define  LVDS_D_CFG29_MUXSEL_REPLACE_VAL(reg,val) (((reg) & ~LVDS_D_CFG29_MUXSEL_MASK) | (((uint32_t)val) << LVDS_D_CFG29_MUXSEL_SHIFT))

//====================================================================
//Register: LVDS D channel[j] bit[i] Configuration Register (Instance 31 of 42) (D_CFG30)
/** \brief D_CFGn register selects the source of data to be routed to the
     LVDS PHY input port, D channel[j] bit[i], where n = j*7 + i. <BR> <BR>
        D_CFG0-6 for D channel[0] bit[0-6] <BR>
        D_CFG7-13 for D channel[1] bit[0-6] <BR>
        D_CFG14-20 for D channel[2] bit[0-6] <BR>
        D_CFG21-27 for D channel[3] bit[0-6] <BR>
        D_CFG28-34 for D channel[4] bit[0-6] <BR>
        D_CFG35-41 for D channel[5] bit[0-6] <BR> <BR>
     The sources of D are the data and control lines from the
     LCD parallel panel interface: <BR>
     LDD[23:0] (pixel data), LCLK (hsync), VFCLK (vsync), and DENA (pixel valid). <BR> (Instance 31 of 42)*/
//====================================================================

#define  LVDS_D_CFG30_RESERVED1_MASK 0xffffffe0
#define  LVDS_D_CFG30_RESERVED1_SHIFT 5
#define  LVDS_D_CFG30_RESERVED1_MASK_SHIFT(reg) (((reg) & LVDS_D_CFG30_RESERVED1_MASK) >> LVDS_D_CFG30_RESERVED1_SHIFT)
#define  LVDS_D_CFG30_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~LVDS_D_CFG30_RESERVED1_MASK) | (((uint32_t)val) << LVDS_D_CFG30_RESERVED1_SHIFT))

#define  LVDS_D_CFG30_MUXSEL_MASK 0x1f
#define  LVDS_D_CFG30_MUXSEL_SHIFT 0
#define  LVDS_D_CFG30_MUXSEL_MASK_SHIFT(reg) (((reg) & LVDS_D_CFG30_MUXSEL_MASK) >> LVDS_D_CFG30_MUXSEL_SHIFT)
#define  LVDS_D_CFG30_MUXSEL_REPLACE_VAL(reg,val) (((reg) & ~LVDS_D_CFG30_MUXSEL_MASK) | (((uint32_t)val) << LVDS_D_CFG30_MUXSEL_SHIFT))

//====================================================================
//Register: LVDS D channel[j] bit[i] Configuration Register (Instance 32 of 42) (D_CFG31)
/** \brief D_CFGn register selects the source of data to be routed to the
     LVDS PHY input port, D channel[j] bit[i], where n = j*7 + i. <BR> <BR>
        D_CFG0-6 for D channel[0] bit[0-6] <BR>
        D_CFG7-13 for D channel[1] bit[0-6] <BR>
        D_CFG14-20 for D channel[2] bit[0-6] <BR>
        D_CFG21-27 for D channel[3] bit[0-6] <BR>
        D_CFG28-34 for D channel[4] bit[0-6] <BR>
        D_CFG35-41 for D channel[5] bit[0-6] <BR> <BR>
     The sources of D are the data and control lines from the
     LCD parallel panel interface: <BR>
     LDD[23:0] (pixel data), LCLK (hsync), VFCLK (vsync), and DENA (pixel valid). <BR> (Instance 32 of 42)*/
//====================================================================

#define  LVDS_D_CFG31_RESERVED1_MASK 0xffffffe0
#define  LVDS_D_CFG31_RESERVED1_SHIFT 5
#define  LVDS_D_CFG31_RESERVED1_MASK_SHIFT(reg) (((reg) & LVDS_D_CFG31_RESERVED1_MASK) >> LVDS_D_CFG31_RESERVED1_SHIFT)
#define  LVDS_D_CFG31_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~LVDS_D_CFG31_RESERVED1_MASK) | (((uint32_t)val) << LVDS_D_CFG31_RESERVED1_SHIFT))

#define  LVDS_D_CFG31_MUXSEL_MASK 0x1f
#define  LVDS_D_CFG31_MUXSEL_SHIFT 0
#define  LVDS_D_CFG31_MUXSEL_MASK_SHIFT(reg) (((reg) & LVDS_D_CFG31_MUXSEL_MASK) >> LVDS_D_CFG31_MUXSEL_SHIFT)
#define  LVDS_D_CFG31_MUXSEL_REPLACE_VAL(reg,val) (((reg) & ~LVDS_D_CFG31_MUXSEL_MASK) | (((uint32_t)val) << LVDS_D_CFG31_MUXSEL_SHIFT))

//====================================================================
//Register: LVDS D channel[j] bit[i] Configuration Register (Instance 33 of 42) (D_CFG32)
/** \brief D_CFGn register selects the source of data to be routed to the
     LVDS PHY input port, D channel[j] bit[i], where n = j*7 + i. <BR> <BR>
        D_CFG0-6 for D channel[0] bit[0-6] <BR>
        D_CFG7-13 for D channel[1] bit[0-6] <BR>
        D_CFG14-20 for D channel[2] bit[0-6] <BR>
        D_CFG21-27 for D channel[3] bit[0-6] <BR>
        D_CFG28-34 for D channel[4] bit[0-6] <BR>
        D_CFG35-41 for D channel[5] bit[0-6] <BR> <BR>
     The sources of D are the data and control lines from the
     LCD parallel panel interface: <BR>
     LDD[23:0] (pixel data), LCLK (hsync), VFCLK (vsync), and DENA (pixel valid). <BR> (Instance 33 of 42)*/
//====================================================================

#define  LVDS_D_CFG32_RESERVED1_MASK 0xffffffe0
#define  LVDS_D_CFG32_RESERVED1_SHIFT 5
#define  LVDS_D_CFG32_RESERVED1_MASK_SHIFT(reg) (((reg) & LVDS_D_CFG32_RESERVED1_MASK) >> LVDS_D_CFG32_RESERVED1_SHIFT)
#define  LVDS_D_CFG32_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~LVDS_D_CFG32_RESERVED1_MASK) | (((uint32_t)val) << LVDS_D_CFG32_RESERVED1_SHIFT))

#define  LVDS_D_CFG32_MUXSEL_MASK 0x1f
#define  LVDS_D_CFG32_MUXSEL_SHIFT 0
#define  LVDS_D_CFG32_MUXSEL_MASK_SHIFT(reg) (((reg) & LVDS_D_CFG32_MUXSEL_MASK) >> LVDS_D_CFG32_MUXSEL_SHIFT)
#define  LVDS_D_CFG32_MUXSEL_REPLACE_VAL(reg,val) (((reg) & ~LVDS_D_CFG32_MUXSEL_MASK) | (((uint32_t)val) << LVDS_D_CFG32_MUXSEL_SHIFT))

//====================================================================
//Register: LVDS D channel[j] bit[i] Configuration Register (Instance 34 of 42) (D_CFG33)
/** \brief D_CFGn register selects the source of data to be routed to the
     LVDS PHY input port, D channel[j] bit[i], where n = j*7 + i. <BR> <BR>
        D_CFG0-6 for D channel[0] bit[0-6] <BR>
        D_CFG7-13 for D channel[1] bit[0-6] <BR>
        D_CFG14-20 for D channel[2] bit[0-6] <BR>
        D_CFG21-27 for D channel[3] bit[0-6] <BR>
        D_CFG28-34 for D channel[4] bit[0-6] <BR>
        D_CFG35-41 for D channel[5] bit[0-6] <BR> <BR>
     The sources of D are the data and control lines from the
     LCD parallel panel interface: <BR>
     LDD[23:0] (pixel data), LCLK (hsync), VFCLK (vsync), and DENA (pixel valid). <BR> (Instance 34 of 42)*/
//====================================================================

#define  LVDS_D_CFG33_RESERVED1_MASK 0xffffffe0
#define  LVDS_D_CFG33_RESERVED1_SHIFT 5
#define  LVDS_D_CFG33_RESERVED1_MASK_SHIFT(reg) (((reg) & LVDS_D_CFG33_RESERVED1_MASK) >> LVDS_D_CFG33_RESERVED1_SHIFT)
#define  LVDS_D_CFG33_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~LVDS_D_CFG33_RESERVED1_MASK) | (((uint32_t)val) << LVDS_D_CFG33_RESERVED1_SHIFT))

#define  LVDS_D_CFG33_MUXSEL_MASK 0x1f
#define  LVDS_D_CFG33_MUXSEL_SHIFT 0
#define  LVDS_D_CFG33_MUXSEL_MASK_SHIFT(reg) (((reg) & LVDS_D_CFG33_MUXSEL_MASK) >> LVDS_D_CFG33_MUXSEL_SHIFT)
#define  LVDS_D_CFG33_MUXSEL_REPLACE_VAL(reg,val) (((reg) & ~LVDS_D_CFG33_MUXSEL_MASK) | (((uint32_t)val) << LVDS_D_CFG33_MUXSEL_SHIFT))

//====================================================================
//Register: LVDS D channel[j] bit[i] Configuration Register (Instance 35 of 42) (D_CFG34)
/** \brief D_CFGn register selects the source of data to be routed to the
     LVDS PHY input port, D channel[j] bit[i], where n = j*7 + i. <BR> <BR>
        D_CFG0-6 for D channel[0] bit[0-6] <BR>
        D_CFG7-13 for D channel[1] bit[0-6] <BR>
        D_CFG14-20 for D channel[2] bit[0-6] <BR>
        D_CFG21-27 for D channel[3] bit[0-6] <BR>
        D_CFG28-34 for D channel[4] bit[0-6] <BR>
        D_CFG35-41 for D channel[5] bit[0-6] <BR> <BR>
     The sources of D are the data and control lines from the
     LCD parallel panel interface: <BR>
     LDD[23:0] (pixel data), LCLK (hsync), VFCLK (vsync), and DENA (pixel valid). <BR> (Instance 35 of 42)*/
//====================================================================

#define  LVDS_D_CFG34_RESERVED1_MASK 0xffffffe0
#define  LVDS_D_CFG34_RESERVED1_SHIFT 5
#define  LVDS_D_CFG34_RESERVED1_MASK_SHIFT(reg) (((reg) & LVDS_D_CFG34_RESERVED1_MASK) >> LVDS_D_CFG34_RESERVED1_SHIFT)
#define  LVDS_D_CFG34_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~LVDS_D_CFG34_RESERVED1_MASK) | (((uint32_t)val) << LVDS_D_CFG34_RESERVED1_SHIFT))

#define  LVDS_D_CFG34_MUXSEL_MASK 0x1f
#define  LVDS_D_CFG34_MUXSEL_SHIFT 0
#define  LVDS_D_CFG34_MUXSEL_MASK_SHIFT(reg) (((reg) & LVDS_D_CFG34_MUXSEL_MASK) >> LVDS_D_CFG34_MUXSEL_SHIFT)
#define  LVDS_D_CFG34_MUXSEL_REPLACE_VAL(reg,val) (((reg) & ~LVDS_D_CFG34_MUXSEL_MASK) | (((uint32_t)val) << LVDS_D_CFG34_MUXSEL_SHIFT))

//====================================================================
//Register: LVDS D channel[j] bit[i] Configuration Register (Instance 36 of 42) (D_CFG35)
/** \brief D_CFGn register selects the source of data to be routed to the
     LVDS PHY input port, D channel[j] bit[i], where n = j*7 + i. <BR> <BR>
        D_CFG0-6 for D channel[0] bit[0-6] <BR>
        D_CFG7-13 for D channel[1] bit[0-6] <BR>
        D_CFG14-20 for D channel[2] bit[0-6] <BR>
        D_CFG21-27 for D channel[3] bit[0-6] <BR>
        D_CFG28-34 for D channel[4] bit[0-6] <BR>
        D_CFG35-41 for D channel[5] bit[0-6] <BR> <BR>
     The sources of D are the data and control lines from the
     LCD parallel panel interface: <BR>
     LDD[23:0] (pixel data), LCLK (hsync), VFCLK (vsync), and DENA (pixel valid). <BR> (Instance 36 of 42)*/
//====================================================================

#define  LVDS_D_CFG35_RESERVED1_MASK 0xffffffe0
#define  LVDS_D_CFG35_RESERVED1_SHIFT 5
#define  LVDS_D_CFG35_RESERVED1_MASK_SHIFT(reg) (((reg) & LVDS_D_CFG35_RESERVED1_MASK) >> LVDS_D_CFG35_RESERVED1_SHIFT)
#define  LVDS_D_CFG35_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~LVDS_D_CFG35_RESERVED1_MASK) | (((uint32_t)val) << LVDS_D_CFG35_RESERVED1_SHIFT))

#define  LVDS_D_CFG35_MUXSEL_MASK 0x1f
#define  LVDS_D_CFG35_MUXSEL_SHIFT 0
#define  LVDS_D_CFG35_MUXSEL_MASK_SHIFT(reg) (((reg) & LVDS_D_CFG35_MUXSEL_MASK) >> LVDS_D_CFG35_MUXSEL_SHIFT)
#define  LVDS_D_CFG35_MUXSEL_REPLACE_VAL(reg,val) (((reg) & ~LVDS_D_CFG35_MUXSEL_MASK) | (((uint32_t)val) << LVDS_D_CFG35_MUXSEL_SHIFT))

//====================================================================
//Register: LVDS D channel[j] bit[i] Configuration Register (Instance 37 of 42) (D_CFG36)
/** \brief D_CFGn register selects the source of data to be routed to the
     LVDS PHY input port, D channel[j] bit[i], where n = j*7 + i. <BR> <BR>
        D_CFG0-6 for D channel[0] bit[0-6] <BR>
        D_CFG7-13 for D channel[1] bit[0-6] <BR>
        D_CFG14-20 for D channel[2] bit[0-6] <BR>
        D_CFG21-27 for D channel[3] bit[0-6] <BR>
        D_CFG28-34 for D channel[4] bit[0-6] <BR>
        D_CFG35-41 for D channel[5] bit[0-6] <BR> <BR>
     The sources of D are the data and control lines from the
     LCD parallel panel interface: <BR>
     LDD[23:0] (pixel data), LCLK (hsync), VFCLK (vsync), and DENA (pixel valid). <BR> (Instance 37 of 42)*/
//====================================================================

#define  LVDS_D_CFG36_RESERVED1_MASK 0xffffffe0
#define  LVDS_D_CFG36_RESERVED1_SHIFT 5
#define  LVDS_D_CFG36_RESERVED1_MASK_SHIFT(reg) (((reg) & LVDS_D_CFG36_RESERVED1_MASK) >> LVDS_D_CFG36_RESERVED1_SHIFT)
#define  LVDS_D_CFG36_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~LVDS_D_CFG36_RESERVED1_MASK) | (((uint32_t)val) << LVDS_D_CFG36_RESERVED1_SHIFT))

#define  LVDS_D_CFG36_MUXSEL_MASK 0x1f
#define  LVDS_D_CFG36_MUXSEL_SHIFT 0
#define  LVDS_D_CFG36_MUXSEL_MASK_SHIFT(reg) (((reg) & LVDS_D_CFG36_MUXSEL_MASK) >> LVDS_D_CFG36_MUXSEL_SHIFT)
#define  LVDS_D_CFG36_MUXSEL_REPLACE_VAL(reg,val) (((reg) & ~LVDS_D_CFG36_MUXSEL_MASK) | (((uint32_t)val) << LVDS_D_CFG36_MUXSEL_SHIFT))

//====================================================================
//Register: LVDS D channel[j] bit[i] Configuration Register (Instance 38 of 42) (D_CFG37)
/** \brief D_CFGn register selects the source of data to be routed to the
     LVDS PHY input port, D channel[j] bit[i], where n = j*7 + i. <BR> <BR>
        D_CFG0-6 for D channel[0] bit[0-6] <BR>
        D_CFG7-13 for D channel[1] bit[0-6] <BR>
        D_CFG14-20 for D channel[2] bit[0-6] <BR>
        D_CFG21-27 for D channel[3] bit[0-6] <BR>
        D_CFG28-34 for D channel[4] bit[0-6] <BR>
        D_CFG35-41 for D channel[5] bit[0-6] <BR> <BR>
     The sources of D are the data and control lines from the
     LCD parallel panel interface: <BR>
     LDD[23:0] (pixel data), LCLK (hsync), VFCLK (vsync), and DENA (pixel valid). <BR> (Instance 38 of 42)*/
//====================================================================

#define  LVDS_D_CFG37_RESERVED1_MASK 0xffffffe0
#define  LVDS_D_CFG37_RESERVED1_SHIFT 5
#define  LVDS_D_CFG37_RESERVED1_MASK_SHIFT(reg) (((reg) & LVDS_D_CFG37_RESERVED1_MASK) >> LVDS_D_CFG37_RESERVED1_SHIFT)
#define  LVDS_D_CFG37_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~LVDS_D_CFG37_RESERVED1_MASK) | (((uint32_t)val) << LVDS_D_CFG37_RESERVED1_SHIFT))

#define  LVDS_D_CFG37_MUXSEL_MASK 0x1f
#define  LVDS_D_CFG37_MUXSEL_SHIFT 0
#define  LVDS_D_CFG37_MUXSEL_MASK_SHIFT(reg) (((reg) & LVDS_D_CFG37_MUXSEL_MASK) >> LVDS_D_CFG37_MUXSEL_SHIFT)
#define  LVDS_D_CFG37_MUXSEL_REPLACE_VAL(reg,val) (((reg) & ~LVDS_D_CFG37_MUXSEL_MASK) | (((uint32_t)val) << LVDS_D_CFG37_MUXSEL_SHIFT))

//====================================================================
//Register: LVDS D channel[j] bit[i] Configuration Register (Instance 39 of 42) (D_CFG38)
/** \brief D_CFGn register selects the source of data to be routed to the
     LVDS PHY input port, D channel[j] bit[i], where n = j*7 + i. <BR> <BR>
        D_CFG0-6 for D channel[0] bit[0-6] <BR>
        D_CFG7-13 for D channel[1] bit[0-6] <BR>
        D_CFG14-20 for D channel[2] bit[0-6] <BR>
        D_CFG21-27 for D channel[3] bit[0-6] <BR>
        D_CFG28-34 for D channel[4] bit[0-6] <BR>
        D_CFG35-41 for D channel[5] bit[0-6] <BR> <BR>
     The sources of D are the data and control lines from the
     LCD parallel panel interface: <BR>
     LDD[23:0] (pixel data), LCLK (hsync), VFCLK (vsync), and DENA (pixel valid). <BR> (Instance 39 of 42)*/
//====================================================================

#define  LVDS_D_CFG38_RESERVED1_MASK 0xffffffe0
#define  LVDS_D_CFG38_RESERVED1_SHIFT 5
#define  LVDS_D_CFG38_RESERVED1_MASK_SHIFT(reg) (((reg) & LVDS_D_CFG38_RESERVED1_MASK) >> LVDS_D_CFG38_RESERVED1_SHIFT)
#define  LVDS_D_CFG38_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~LVDS_D_CFG38_RESERVED1_MASK) | (((uint32_t)val) << LVDS_D_CFG38_RESERVED1_SHIFT))

#define  LVDS_D_CFG38_MUXSEL_MASK 0x1f
#define  LVDS_D_CFG38_MUXSEL_SHIFT 0
#define  LVDS_D_CFG38_MUXSEL_MASK_SHIFT(reg) (((reg) & LVDS_D_CFG38_MUXSEL_MASK) >> LVDS_D_CFG38_MUXSEL_SHIFT)
#define  LVDS_D_CFG38_MUXSEL_REPLACE_VAL(reg,val) (((reg) & ~LVDS_D_CFG38_MUXSEL_MASK) | (((uint32_t)val) << LVDS_D_CFG38_MUXSEL_SHIFT))

//====================================================================
//Register: LVDS D channel[j] bit[i] Configuration Register (Instance 40 of 42) (D_CFG39)
/** \brief D_CFGn register selects the source of data to be routed to the
     LVDS PHY input port, D channel[j] bit[i], where n = j*7 + i. <BR> <BR>
        D_CFG0-6 for D channel[0] bit[0-6] <BR>
        D_CFG7-13 for D channel[1] bit[0-6] <BR>
        D_CFG14-20 for D channel[2] bit[0-6] <BR>
        D_CFG21-27 for D channel[3] bit[0-6] <BR>
        D_CFG28-34 for D channel[4] bit[0-6] <BR>
        D_CFG35-41 for D channel[5] bit[0-6] <BR> <BR>
     The sources of D are the data and control lines from the
     LCD parallel panel interface: <BR>
     LDD[23:0] (pixel data), LCLK (hsync), VFCLK (vsync), and DENA (pixel valid). <BR> (Instance 40 of 42)*/
//====================================================================

#define  LVDS_D_CFG39_RESERVED1_MASK 0xffffffe0
#define  LVDS_D_CFG39_RESERVED1_SHIFT 5
#define  LVDS_D_CFG39_RESERVED1_MASK_SHIFT(reg) (((reg) & LVDS_D_CFG39_RESERVED1_MASK) >> LVDS_D_CFG39_RESERVED1_SHIFT)
#define  LVDS_D_CFG39_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~LVDS_D_CFG39_RESERVED1_MASK) | (((uint32_t)val) << LVDS_D_CFG39_RESERVED1_SHIFT))

#define  LVDS_D_CFG39_MUXSEL_MASK 0x1f
#define  LVDS_D_CFG39_MUXSEL_SHIFT 0
#define  LVDS_D_CFG39_MUXSEL_MASK_SHIFT(reg) (((reg) & LVDS_D_CFG39_MUXSEL_MASK) >> LVDS_D_CFG39_MUXSEL_SHIFT)
#define  LVDS_D_CFG39_MUXSEL_REPLACE_VAL(reg,val) (((reg) & ~LVDS_D_CFG39_MUXSEL_MASK) | (((uint32_t)val) << LVDS_D_CFG39_MUXSEL_SHIFT))

//====================================================================
//Register: LVDS D channel[j] bit[i] Configuration Register (Instance 41 of 42) (D_CFG40)
/** \brief D_CFGn register selects the source of data to be routed to the
     LVDS PHY input port, D channel[j] bit[i], where n = j*7 + i. <BR> <BR>
        D_CFG0-6 for D channel[0] bit[0-6] <BR>
        D_CFG7-13 for D channel[1] bit[0-6] <BR>
        D_CFG14-20 for D channel[2] bit[0-6] <BR>
        D_CFG21-27 for D channel[3] bit[0-6] <BR>
        D_CFG28-34 for D channel[4] bit[0-6] <BR>
        D_CFG35-41 for D channel[5] bit[0-6] <BR> <BR>
     The sources of D are the data and control lines from the
     LCD parallel panel interface: <BR>
     LDD[23:0] (pixel data), LCLK (hsync), VFCLK (vsync), and DENA (pixel valid). <BR> (Instance 41 of 42)*/
//====================================================================

#define  LVDS_D_CFG40_RESERVED1_MASK 0xffffffe0
#define  LVDS_D_CFG40_RESERVED1_SHIFT 5
#define  LVDS_D_CFG40_RESERVED1_MASK_SHIFT(reg) (((reg) & LVDS_D_CFG40_RESERVED1_MASK) >> LVDS_D_CFG40_RESERVED1_SHIFT)
#define  LVDS_D_CFG40_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~LVDS_D_CFG40_RESERVED1_MASK) | (((uint32_t)val) << LVDS_D_CFG40_RESERVED1_SHIFT))

#define  LVDS_D_CFG40_MUXSEL_MASK 0x1f
#define  LVDS_D_CFG40_MUXSEL_SHIFT 0
#define  LVDS_D_CFG40_MUXSEL_MASK_SHIFT(reg) (((reg) & LVDS_D_CFG40_MUXSEL_MASK) >> LVDS_D_CFG40_MUXSEL_SHIFT)
#define  LVDS_D_CFG40_MUXSEL_REPLACE_VAL(reg,val) (((reg) & ~LVDS_D_CFG40_MUXSEL_MASK) | (((uint32_t)val) << LVDS_D_CFG40_MUXSEL_SHIFT))

//====================================================================
//Register: LVDS D channel[j] bit[i] Configuration Register (Instance 42 of 42) (D_CFG41)
/** \brief D_CFGn register selects the source of data to be routed to the
     LVDS PHY input port, D channel[j] bit[i], where n = j*7 + i. <BR> <BR>
        D_CFG0-6 for D channel[0] bit[0-6] <BR>
        D_CFG7-13 for D channel[1] bit[0-6] <BR>
        D_CFG14-20 for D channel[2] bit[0-6] <BR>
        D_CFG21-27 for D channel[3] bit[0-6] <BR>
        D_CFG28-34 for D channel[4] bit[0-6] <BR>
        D_CFG35-41 for D channel[5] bit[0-6] <BR> <BR>
     The sources of D are the data and control lines from the
     LCD parallel panel interface: <BR>
     LDD[23:0] (pixel data), LCLK (hsync), VFCLK (vsync), and DENA (pixel valid). <BR> (Instance 42 of 42)*/
//====================================================================

#define  LVDS_D_CFG41_RESERVED1_MASK 0xffffffe0
#define  LVDS_D_CFG41_RESERVED1_SHIFT 5
#define  LVDS_D_CFG41_RESERVED1_MASK_SHIFT(reg) (((reg) & LVDS_D_CFG41_RESERVED1_MASK) >> LVDS_D_CFG41_RESERVED1_SHIFT)
#define  LVDS_D_CFG41_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~LVDS_D_CFG41_RESERVED1_MASK) | (((uint32_t)val) << LVDS_D_CFG41_RESERVED1_SHIFT))

#define  LVDS_D_CFG41_MUXSEL_MASK 0x1f
#define  LVDS_D_CFG41_MUXSEL_SHIFT 0
#define  LVDS_D_CFG41_MUXSEL_MASK_SHIFT(reg) (((reg) & LVDS_D_CFG41_MUXSEL_MASK) >> LVDS_D_CFG41_MUXSEL_SHIFT)
#define  LVDS_D_CFG41_MUXSEL_REPLACE_VAL(reg,val) (((reg) & ~LVDS_D_CFG41_MUXSEL_MASK) | (((uint32_t)val) << LVDS_D_CFG41_MUXSEL_SHIFT))

#endif // LVDS
