 /*
 **************************************************************************************
 *
 * (c) Copyright 2013 Marvell International Ltd.
 *
 *
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/.
 *
 **************************************************************************************
 *
 * \file LUT1D_PIE_BDE_regstructs.h
 * Generated using RegBuild 1.6.3
 *
 **************************************************************************************
 */

#ifndef _LUT1D_PIE_BDE_REGSTRUCTS_H_
#define _LUT1D_PIE_BDE_REGSTRUCTS_H_

#include "hwincl.h"

//====================================================================
//
//Register File: LUT1D_PIE_BDE (LUT1D_PIE_BDE)
/** \brief (rev 0 . 1 . 4 . 5)
    Register descriptions for the LUT1D block.*/
//
//====================================================================

typedef struct LUT1D_PIE_BDE_REGS_s
{
  volatile uint32_t REV0;  ///< 0x0 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0x4 [R]: IP Tagging Revision 1
  volatile uint32_t LUT_CR;  ///< 0x8 [R/W]: LUT1D Configuration Register
  volatile uint32_t reserved0[253];
  volatile uint32_t LUT0[256];  ///< 0x400 [R/W]: LUT1D Look Up Table 0
} LUT1D_PIE_BDE_REGS_t;

#endif // LUT1D_PIE_BDE
 /*
 **************************************************************************************
 *
 * (c) Copyright 2013 Marvell International Ltd.
 *
 *
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/.
 *
 **************************************************************************************
 *
 * \file LUT1D_PIE_BDE_regmasks.h
 * Generated using RegBuild 1.6.3
 *
 **************************************************************************************
 */

#ifndef _LUT1D_PIE_BDE_REGMASKS_H_
#define _LUT1D_PIE_BDE_REGMASKS_H_

#include "hwincl.h"

//====================================================================
//
//Register File: LUT1D_PIE_BDE (LUT1D_PIE_BDE)
/** \brief (rev 0 . 1 . 4 . 5)
    Register descriptions for the LUT1D block.*/
//
//====================================================================

//====================================================================
//Register: IP Tagging Revision 0 (REV0)
/** \brief Provide means for firmware to read IP tagging information.
      This register of particular interest to firmware.*/
//====================================================================

#define  LUT1D_PIE_BDE_REV0_MAJ_MASK 0xffff0000
#define  LUT1D_PIE_BDE_REV0_MAJ_SHIFT 16
#define  LUT1D_PIE_BDE_REV0_MAJ_MASK_SHIFT(reg) (((reg) & LUT1D_PIE_BDE_REV0_MAJ_MASK) >> LUT1D_PIE_BDE_REV0_MAJ_SHIFT)
#define  LUT1D_PIE_BDE_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~LUT1D_PIE_BDE_REV0_MAJ_MASK) | (((uint32_t)val) << LUT1D_PIE_BDE_REV0_MAJ_SHIFT))

#define  LUT1D_PIE_BDE_REV0_MID_MASK 0xffff
#define  LUT1D_PIE_BDE_REV0_MID_SHIFT 0
#define  LUT1D_PIE_BDE_REV0_MID_MASK_SHIFT(reg) (((reg) & LUT1D_PIE_BDE_REV0_MID_MASK) >> LUT1D_PIE_BDE_REV0_MID_SHIFT)
#define  LUT1D_PIE_BDE_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~LUT1D_PIE_BDE_REV0_MID_MASK) | (((uint32_t)val) << LUT1D_PIE_BDE_REV0_MID_SHIFT))

//====================================================================
//Register: IP Tagging Revision 1 (REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  LUT1D_PIE_BDE_REV1_RESERVED1_MASK 0xffff0000
#define  LUT1D_PIE_BDE_REV1_RESERVED1_SHIFT 16
#define  LUT1D_PIE_BDE_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & LUT1D_PIE_BDE_REV1_RESERVED1_MASK) >> LUT1D_PIE_BDE_REV1_RESERVED1_SHIFT)
#define  LUT1D_PIE_BDE_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~LUT1D_PIE_BDE_REV1_RESERVED1_MASK) | (((uint32_t)val) << LUT1D_PIE_BDE_REV1_RESERVED1_SHIFT))

#define  LUT1D_PIE_BDE_REV1_CFG_MASK 0xffff
#define  LUT1D_PIE_BDE_REV1_CFG_SHIFT 0
#define  LUT1D_PIE_BDE_REV1_CFG_MASK_SHIFT(reg) (((reg) & LUT1D_PIE_BDE_REV1_CFG_MASK) >> LUT1D_PIE_BDE_REV1_CFG_SHIFT)
#define  LUT1D_PIE_BDE_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~LUT1D_PIE_BDE_REV1_CFG_MASK) | (((uint32_t)val) << LUT1D_PIE_BDE_REV1_CFG_SHIFT))

//====================================================================
//Register: LUT1D Configuration Register (LUT_CR)
/** \brief The Control Register allows for setting the block mode and CPU access to the SRAMs*/
//====================================================================

#define  LUT1D_PIE_BDE_LUT_CR_RESERVED1_MASK 0xfffc0000
#define  LUT1D_PIE_BDE_LUT_CR_RESERVED1_SHIFT 18
#define  LUT1D_PIE_BDE_LUT_CR_RESERVED1_MASK_SHIFT(reg) (((reg) & LUT1D_PIE_BDE_LUT_CR_RESERVED1_MASK) >> LUT1D_PIE_BDE_LUT_CR_RESERVED1_SHIFT)
#define  LUT1D_PIE_BDE_LUT_CR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~LUT1D_PIE_BDE_LUT_CR_RESERVED1_MASK) | (((uint32_t)val) << LUT1D_PIE_BDE_LUT_CR_RESERVED1_SHIFT))

#define  LUT1D_PIE_BDE_LUT_CR_WRITE_ALL_MASK 0x20000
#define  LUT1D_PIE_BDE_LUT_CR_WRITE_ALL_SHIFT 17
#define  LUT1D_PIE_BDE_LUT_CR_WRITE_ALL_MASK_SHIFT(reg) (((reg) & LUT1D_PIE_BDE_LUT_CR_WRITE_ALL_MASK) >> LUT1D_PIE_BDE_LUT_CR_WRITE_ALL_SHIFT)
#define  LUT1D_PIE_BDE_LUT_CR_WRITE_ALL_REPLACE_VAL(reg,val) (((reg) & ~LUT1D_PIE_BDE_LUT_CR_WRITE_ALL_MASK) | (((uint32_t)val) << LUT1D_PIE_BDE_LUT_CR_WRITE_ALL_SHIFT))

#define  LUT1D_PIE_BDE_LUT_CR_CPU_ACCESS_MASK 0x10000
#define  LUT1D_PIE_BDE_LUT_CR_CPU_ACCESS_SHIFT 16
#define  LUT1D_PIE_BDE_LUT_CR_CPU_ACCESS_MASK_SHIFT(reg) (((reg) & LUT1D_PIE_BDE_LUT_CR_CPU_ACCESS_MASK) >> LUT1D_PIE_BDE_LUT_CR_CPU_ACCESS_SHIFT)
#define  LUT1D_PIE_BDE_LUT_CR_CPU_ACCESS_REPLACE_VAL(reg,val) (((reg) & ~LUT1D_PIE_BDE_LUT_CR_CPU_ACCESS_MASK) | (((uint32_t)val) << LUT1D_PIE_BDE_LUT_CR_CPU_ACCESS_SHIFT))

#define  LUT1D_PIE_BDE_LUT_CR_RESERVED2_MASK 0xfffe
#define  LUT1D_PIE_BDE_LUT_CR_RESERVED2_SHIFT 1
#define  LUT1D_PIE_BDE_LUT_CR_RESERVED2_MASK_SHIFT(reg) (((reg) & LUT1D_PIE_BDE_LUT_CR_RESERVED2_MASK) >> LUT1D_PIE_BDE_LUT_CR_RESERVED2_SHIFT)
#define  LUT1D_PIE_BDE_LUT_CR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~LUT1D_PIE_BDE_LUT_CR_RESERVED2_MASK) | (((uint32_t)val) << LUT1D_PIE_BDE_LUT_CR_RESERVED2_SHIFT))

#define  LUT1D_PIE_BDE_LUT_CR_BYPASS_ENABLE_MASK 0x1
#define  LUT1D_PIE_BDE_LUT_CR_BYPASS_ENABLE_SHIFT 0
#define  LUT1D_PIE_BDE_LUT_CR_BYPASS_ENABLE_MASK_SHIFT(reg) (((reg) & LUT1D_PIE_BDE_LUT_CR_BYPASS_ENABLE_MASK) >> LUT1D_PIE_BDE_LUT_CR_BYPASS_ENABLE_SHIFT)
#define  LUT1D_PIE_BDE_LUT_CR_BYPASS_ENABLE_REPLACE_VAL(reg,val) (((reg) & ~LUT1D_PIE_BDE_LUT_CR_BYPASS_ENABLE_MASK) | (((uint32_t)val) << LUT1D_PIE_BDE_LUT_CR_BYPASS_ENABLE_SHIFT))

//====================================================================
//Register: LUT1D Look Up Table 0 (LUT0)
/** \brief The LUT0 registers are memory mapped to the first LUT (comprised of either 1 of 2 SRAMs). Write to this register to set the value of a particular LUT entry.
      Note the LUT Write Enable register must be enabled, otherwise writing to this register will have no effect.*/
//====================================================================

#define  LUT1D_PIE_BDE_LUT0_RESERVED1_MASK 0xffffc000
#define  LUT1D_PIE_BDE_LUT0_RESERVED1_SHIFT 14
#define  LUT1D_PIE_BDE_LUT0_RESERVED1_MASK_SHIFT(reg) (((reg) & LUT1D_PIE_BDE_LUT0_RESERVED1_MASK) >> LUT1D_PIE_BDE_LUT0_RESERVED1_SHIFT)
#define  LUT1D_PIE_BDE_LUT0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~LUT1D_PIE_BDE_LUT0_RESERVED1_MASK) | (((uint32_t)val) << LUT1D_PIE_BDE_LUT0_RESERVED1_SHIFT))

#define  LUT1D_PIE_BDE_LUT0_LUT_VAL_MASK 0x3fff
#define  LUT1D_PIE_BDE_LUT0_LUT_VAL_SHIFT 0
#define  LUT1D_PIE_BDE_LUT0_LUT_VAL_MASK_SHIFT(reg) (((reg) & LUT1D_PIE_BDE_LUT0_LUT_VAL_MASK) >> LUT1D_PIE_BDE_LUT0_LUT_VAL_SHIFT)
#define  LUT1D_PIE_BDE_LUT0_LUT_VAL_REPLACE_VAL(reg,val) (((reg) & ~LUT1D_PIE_BDE_LUT0_LUT_VAL_MASK) | (((uint32_t)val) << LUT1D_PIE_BDE_LUT0_LUT_VAL_SHIFT))

#endif // LUT1D_PIE_BDE
