 /*
 **************************************************************************************
 *
 * (c) Copyright 2013 Marvell International Ltd.
 *
 *
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/.
 *
 **************************************************************************************
 *
 * \file LRMargin_regmasks.h
 * Generated using RegBuild 1.6.3
 *
 **************************************************************************************
 */

#ifndef _LRMARGIN_REGMASKS_H_
#define _LRMARGIN_REGMASKS_H_

#ifndef __KERNEL__
#include <stdint.h>
#endif

//====================================================================
//
//Register File: Left/Right Margins (LRMargin)
/** \brief Register Descriptions for the PIC LRMargin block (rev 0 . 2 . 3 . 3)*/
//
//====================================================================

//====================================================================
//Register: Left/Right Margins Configuration Register (LRCR)
/** \brief General configuration register for LRMargin block.*/
//====================================================================

#define  LRMARGIN_LRCR_BYPASS_MASK 0x80000000
#define  LRMARGIN_LRCR_BYPASS_SHIFT 31
#define  LRMARGIN_LRCR_BYPASS_MASK_SHIFT(reg) (((reg) & LRMARGIN_LRCR_BYPASS_MASK) >> LRMARGIN_LRCR_BYPASS_SHIFT)
#define  LRMARGIN_LRCR_BYPASS_REPLACE_VAL(reg,val) (((reg) & ~LRMARGIN_LRCR_BYPASS_MASK) | (((uint32_t)val) << LRMARGIN_LRCR_BYPASS_SHIFT))

#define  LRMARGIN_LRCR_RESERVED1_MASK 0x7fffffff
#define  LRMARGIN_LRCR_RESERVED1_SHIFT 0
#define  LRMARGIN_LRCR_RESERVED1_MASK_SHIFT(reg) (((reg) & LRMARGIN_LRCR_RESERVED1_MASK) >> LRMARGIN_LRCR_RESERVED1_SHIFT)
#define  LRMARGIN_LRCR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~LRMARGIN_LRCR_RESERVED1_MASK) | (((uint32_t)val) << LRMARGIN_LRCR_RESERVED1_SHIFT))

//====================================================================
//Register: Left/Right Margins Register (LRMR0)
//====================================================================

#define  LRMARGIN_LRMR0_RIGHTMARGINC0_MASK 0xffff0000
#define  LRMARGIN_LRMR0_RIGHTMARGINC0_SHIFT 16
#define  LRMARGIN_LRMR0_RIGHTMARGINC0_MASK_SHIFT(reg) (((reg) & LRMARGIN_LRMR0_RIGHTMARGINC0_MASK) >> LRMARGIN_LRMR0_RIGHTMARGINC0_SHIFT)
#define  LRMARGIN_LRMR0_RIGHTMARGINC0_REPLACE_VAL(reg,val) (((reg) & ~LRMARGIN_LRMR0_RIGHTMARGINC0_MASK) | (((uint32_t)val) << LRMARGIN_LRMR0_RIGHTMARGINC0_SHIFT))

#define  LRMARGIN_LRMR0_LEFTMARGINC0_MASK 0xffff
#define  LRMARGIN_LRMR0_LEFTMARGINC0_SHIFT 0
#define  LRMARGIN_LRMR0_LEFTMARGINC0_MASK_SHIFT(reg) (((reg) & LRMARGIN_LRMR0_LEFTMARGINC0_MASK) >> LRMARGIN_LRMR0_LEFTMARGINC0_SHIFT)
#define  LRMARGIN_LRMR0_LEFTMARGINC0_REPLACE_VAL(reg,val) (((reg) & ~LRMARGIN_LRMR0_LEFTMARGINC0_MASK) | (((uint32_t)val) << LRMARGIN_LRMR0_LEFTMARGINC0_SHIFT))

//====================================================================
//Register: Left/Right Margins Register (LRMR1)
//====================================================================

#define  LRMARGIN_LRMR1_RIGHTMARGINC1_MASK 0xffff0000
#define  LRMARGIN_LRMR1_RIGHTMARGINC1_SHIFT 16
#define  LRMARGIN_LRMR1_RIGHTMARGINC1_MASK_SHIFT(reg) (((reg) & LRMARGIN_LRMR1_RIGHTMARGINC1_MASK) >> LRMARGIN_LRMR1_RIGHTMARGINC1_SHIFT)
#define  LRMARGIN_LRMR1_RIGHTMARGINC1_REPLACE_VAL(reg,val) (((reg) & ~LRMARGIN_LRMR1_RIGHTMARGINC1_MASK) | (((uint32_t)val) << LRMARGIN_LRMR1_RIGHTMARGINC1_SHIFT))

#define  LRMARGIN_LRMR1_LEFTMARGINC1_MASK 0xffff
#define  LRMARGIN_LRMR1_LEFTMARGINC1_SHIFT 0
#define  LRMARGIN_LRMR1_LEFTMARGINC1_MASK_SHIFT(reg) (((reg) & LRMARGIN_LRMR1_LEFTMARGINC1_MASK) >> LRMARGIN_LRMR1_LEFTMARGINC1_SHIFT)
#define  LRMARGIN_LRMR1_LEFTMARGINC1_REPLACE_VAL(reg,val) (((reg) & ~LRMARGIN_LRMR1_LEFTMARGINC1_MASK) | (((uint32_t)val) << LRMARGIN_LRMR1_LEFTMARGINC1_SHIFT))

//====================================================================
//Register: Left/Right Margins Register (LRMR2)
//====================================================================

#define  LRMARGIN_LRMR2_RIGHTMARGINC2_MASK 0xffff0000
#define  LRMARGIN_LRMR2_RIGHTMARGINC2_SHIFT 16
#define  LRMARGIN_LRMR2_RIGHTMARGINC2_MASK_SHIFT(reg) (((reg) & LRMARGIN_LRMR2_RIGHTMARGINC2_MASK) >> LRMARGIN_LRMR2_RIGHTMARGINC2_SHIFT)
#define  LRMARGIN_LRMR2_RIGHTMARGINC2_REPLACE_VAL(reg,val) (((reg) & ~LRMARGIN_LRMR2_RIGHTMARGINC2_MASK) | (((uint32_t)val) << LRMARGIN_LRMR2_RIGHTMARGINC2_SHIFT))

#define  LRMARGIN_LRMR2_LEFTMARGINC2_MASK 0xffff
#define  LRMARGIN_LRMR2_LEFTMARGINC2_SHIFT 0
#define  LRMARGIN_LRMR2_LEFTMARGINC2_MASK_SHIFT(reg) (((reg) & LRMARGIN_LRMR2_LEFTMARGINC2_MASK) >> LRMARGIN_LRMR2_LEFTMARGINC2_SHIFT)
#define  LRMARGIN_LRMR2_LEFTMARGINC2_REPLACE_VAL(reg,val) (((reg) & ~LRMARGIN_LRMR2_LEFTMARGINC2_MASK) | (((uint32_t)val) << LRMARGIN_LRMR2_LEFTMARGINC2_SHIFT))

//====================================================================
//Register: IP Tagging Revision 0 (REV0)
/** \brief Provide means for firmware to read IP tagging information.
      This register of particular interest to firmware.*/
//====================================================================

#define  LRMARGIN_REV0_MAJ_MASK 0xffff0000
#define  LRMARGIN_REV0_MAJ_SHIFT 16
#define  LRMARGIN_REV0_MAJ_MASK_SHIFT(reg) (((reg) & LRMARGIN_REV0_MAJ_MASK) >> LRMARGIN_REV0_MAJ_SHIFT)
#define  LRMARGIN_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~LRMARGIN_REV0_MAJ_MASK) | (((uint32_t)val) << LRMARGIN_REV0_MAJ_SHIFT))

#define  LRMARGIN_REV0_MID_MASK 0xffff
#define  LRMARGIN_REV0_MID_SHIFT 0
#define  LRMARGIN_REV0_MID_MASK_SHIFT(reg) (((reg) & LRMARGIN_REV0_MID_MASK) >> LRMARGIN_REV0_MID_SHIFT)
#define  LRMARGIN_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~LRMARGIN_REV0_MID_MASK) | (((uint32_t)val) << LRMARGIN_REV0_MID_SHIFT))

//====================================================================
//Register: IP Tagging Revision 1 (REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  LRMARGIN_REV1_RESERVED1_MASK 0xffff0000
#define  LRMARGIN_REV1_RESERVED1_SHIFT 16
#define  LRMARGIN_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & LRMARGIN_REV1_RESERVED1_MASK) >> LRMARGIN_REV1_RESERVED1_SHIFT)
#define  LRMARGIN_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~LRMARGIN_REV1_RESERVED1_MASK) | (((uint32_t)val) << LRMARGIN_REV1_RESERVED1_SHIFT))

#define  LRMARGIN_REV1_CFG_MASK 0xffff
#define  LRMARGIN_REV1_CFG_SHIFT 0
#define  LRMARGIN_REV1_CFG_MASK_SHIFT(reg) (((reg) & LRMARGIN_REV1_CFG_MASK) >> LRMARGIN_REV1_CFG_SHIFT)
#define  LRMARGIN_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~LRMARGIN_REV1_CFG_MASK) | (((uint32_t)val) << LRMARGIN_REV1_CFG_SHIFT))

#endif // LRMARGIN
