 /*
 **************************************************************************************
 *
 * (c) Copyright 2013 Marvell International Ltd.
 *
 *
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/.
 *
 **************************************************************************************
 *
 * \file LCD2_regmasks.h
 * Generated using RegBuild 1.6.3
 *
 **************************************************************************************
 */

#ifndef _LCD2_REGMASKS_H_
#define _LCD2_REGMASKS_H_

#ifndef __KERNEL__
#include <stdint.h>
#endif

//====================================================================
//
//Register File: LCD2 Display Controller (LCD2)
/** \brief Registers for the enhanced LCD Display Controller Block are described in this
section. Regarding the register naming convention, registers for configuring
the video DMA are called LCD_DMA*, and registers for configuring the graphic DMA
are class LCD_GRA*.*/
//
//====================================================================

//====================================================================
//Register: LCD Software Reset (LCD_SOFT_RESET)
//====================================================================

#define  LCD2_LCD_SOFT_RESET_RESERVED1_MASK 0xc0000000
#define  LCD2_LCD_SOFT_RESET_RESERVED1_SHIFT 30
#define  LCD2_LCD_SOFT_RESET_RESERVED1_MASK_SHIFT(reg) (((reg) & LCD2_LCD_SOFT_RESET_RESERVED1_MASK) >> LCD2_LCD_SOFT_RESET_RESERVED1_SHIFT)
#define  LCD2_LCD_SOFT_RESET_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_SOFT_RESET_RESERVED1_MASK) | (((uint32_t)val) << LCD2_LCD_SOFT_RESET_RESERVED1_SHIFT))

#define  LCD2_LCD_SOFT_RESET_CFG_SW_RESET_MASK 0x20000000
#define  LCD2_LCD_SOFT_RESET_CFG_SW_RESET_SHIFT 29
#define  LCD2_LCD_SOFT_RESET_CFG_SW_RESET_MASK_SHIFT(reg) (((reg) & LCD2_LCD_SOFT_RESET_CFG_SW_RESET_MASK) >> LCD2_LCD_SOFT_RESET_CFG_SW_RESET_SHIFT)
#define  LCD2_LCD_SOFT_RESET_CFG_SW_RESET_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_SOFT_RESET_CFG_SW_RESET_MASK) | (((uint32_t)val) << LCD2_LCD_SOFT_RESET_CFG_SW_RESET_SHIFT))

#define  LCD2_LCD_SOFT_RESET_RESERVED2_MASK 0x10000000
#define  LCD2_LCD_SOFT_RESET_RESERVED2_SHIFT 28
#define  LCD2_LCD_SOFT_RESET_RESERVED2_MASK_SHIFT(reg) (((reg) & LCD2_LCD_SOFT_RESET_RESERVED2_MASK) >> LCD2_LCD_SOFT_RESET_RESERVED2_SHIFT)
#define  LCD2_LCD_SOFT_RESET_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_SOFT_RESET_RESERVED2_MASK) | (((uint32_t)val) << LCD2_LCD_SOFT_RESET_RESERVED2_SHIFT))

#define  LCD2_LCD_SOFT_RESET_RESERVED3_MASK 0xfff0000
#define  LCD2_LCD_SOFT_RESET_RESERVED3_SHIFT 16
#define  LCD2_LCD_SOFT_RESET_RESERVED3_MASK_SHIFT(reg) (((reg) & LCD2_LCD_SOFT_RESET_RESERVED3_MASK) >> LCD2_LCD_SOFT_RESET_RESERVED3_SHIFT)
#define  LCD2_LCD_SOFT_RESET_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_SOFT_RESET_RESERVED3_MASK) | (((uint32_t)val) << LCD2_LCD_SOFT_RESET_RESERVED3_SHIFT))

#define  LCD2_LCD_SOFT_RESET_RESERVED4_MASK 0xf000
#define  LCD2_LCD_SOFT_RESET_RESERVED4_SHIFT 12
#define  LCD2_LCD_SOFT_RESET_RESERVED4_MASK_SHIFT(reg) (((reg) & LCD2_LCD_SOFT_RESET_RESERVED4_MASK) >> LCD2_LCD_SOFT_RESET_RESERVED4_SHIFT)
#define  LCD2_LCD_SOFT_RESET_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_SOFT_RESET_RESERVED4_MASK) | (((uint32_t)val) << LCD2_LCD_SOFT_RESET_RESERVED4_SHIFT))

#define  LCD2_LCD_SOFT_RESET_RESERVED5_MASK 0xf00
#define  LCD2_LCD_SOFT_RESET_RESERVED5_SHIFT 8
#define  LCD2_LCD_SOFT_RESET_RESERVED5_MASK_SHIFT(reg) (((reg) & LCD2_LCD_SOFT_RESET_RESERVED5_MASK) >> LCD2_LCD_SOFT_RESET_RESERVED5_SHIFT)
#define  LCD2_LCD_SOFT_RESET_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_SOFT_RESET_RESERVED5_MASK) | (((uint32_t)val) << LCD2_LCD_SOFT_RESET_RESERVED5_SHIFT))

#define  LCD2_LCD_SOFT_RESET_RESERVED6_MASK 0xff
#define  LCD2_LCD_SOFT_RESET_RESERVED6_SHIFT 0
#define  LCD2_LCD_SOFT_RESET_RESERVED6_MASK_SHIFT(reg) (((reg) & LCD2_LCD_SOFT_RESET_RESERVED6_MASK) >> LCD2_LCD_SOFT_RESET_RESERVED6_SHIFT)
#define  LCD2_LCD_SOFT_RESET_RESERVED6_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_SOFT_RESET_RESERVED6_MASK) | (((uint32_t)val) << LCD2_LCD_SOFT_RESET_RESERVED6_SHIFT))

//====================================================================
//Register: Panel Video Frame 0 Y Starting Address Register (LCD_DMA_START_ADDR_Y0)
//====================================================================

#define  LCD2_LCD_DMA_START_ADDR_Y0_CFG_DMA_SA_Y0_MASK 0xffffffff
#define  LCD2_LCD_DMA_START_ADDR_Y0_CFG_DMA_SA_Y0_SHIFT 0
#define  LCD2_LCD_DMA_START_ADDR_Y0_CFG_DMA_SA_Y0_MASK_SHIFT(reg) (((reg) & LCD2_LCD_DMA_START_ADDR_Y0_CFG_DMA_SA_Y0_MASK) >> LCD2_LCD_DMA_START_ADDR_Y0_CFG_DMA_SA_Y0_SHIFT)
#define  LCD2_LCD_DMA_START_ADDR_Y0_CFG_DMA_SA_Y0_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_DMA_START_ADDR_Y0_CFG_DMA_SA_Y0_MASK) | (((uint32_t)val) << LCD2_LCD_DMA_START_ADDR_Y0_CFG_DMA_SA_Y0_SHIFT))

//====================================================================
//Register: Panel Video Frame 0 U Starting Address Register (LCD_DMA_START_ADDR_U0)
//====================================================================

#define  LCD2_LCD_DMA_START_ADDR_U0_CFG_DMA_SA_U0_MASK 0xffffffff
#define  LCD2_LCD_DMA_START_ADDR_U0_CFG_DMA_SA_U0_SHIFT 0
#define  LCD2_LCD_DMA_START_ADDR_U0_CFG_DMA_SA_U0_MASK_SHIFT(reg) (((reg) & LCD2_LCD_DMA_START_ADDR_U0_CFG_DMA_SA_U0_MASK) >> LCD2_LCD_DMA_START_ADDR_U0_CFG_DMA_SA_U0_SHIFT)
#define  LCD2_LCD_DMA_START_ADDR_U0_CFG_DMA_SA_U0_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_DMA_START_ADDR_U0_CFG_DMA_SA_U0_MASK) | (((uint32_t)val) << LCD2_LCD_DMA_START_ADDR_U0_CFG_DMA_SA_U0_SHIFT))

//====================================================================
//Register: Panel Video Frame 0 V Starting Address Register (LCD_DMA_START_ADDR_V0)
//====================================================================

#define  LCD2_LCD_DMA_START_ADDR_V0_CFG_DMA_SA_V0_MASK 0xffffffff
#define  LCD2_LCD_DMA_START_ADDR_V0_CFG_DMA_SA_V0_SHIFT 0
#define  LCD2_LCD_DMA_START_ADDR_V0_CFG_DMA_SA_V0_MASK_SHIFT(reg) (((reg) & LCD2_LCD_DMA_START_ADDR_V0_CFG_DMA_SA_V0_MASK) >> LCD2_LCD_DMA_START_ADDR_V0_CFG_DMA_SA_V0_SHIFT)
#define  LCD2_LCD_DMA_START_ADDR_V0_CFG_DMA_SA_V0_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_DMA_START_ADDR_V0_CFG_DMA_SA_V0_MASK) | (((uint32_t)val) << LCD2_LCD_DMA_START_ADDR_V0_CFG_DMA_SA_V0_SHIFT))

//====================================================================
//Register: Panel Video Frame 0 Command Starting Address Register (LCD_DMA_START_ADDR_C0)
//====================================================================

#define  LCD2_LCD_DMA_START_ADDR_C0_CFG_DMA_SA_C0_MASK 0xffffffff
#define  LCD2_LCD_DMA_START_ADDR_C0_CFG_DMA_SA_C0_SHIFT 0
#define  LCD2_LCD_DMA_START_ADDR_C0_CFG_DMA_SA_C0_MASK_SHIFT(reg) (((reg) & LCD2_LCD_DMA_START_ADDR_C0_CFG_DMA_SA_C0_MASK) >> LCD2_LCD_DMA_START_ADDR_C0_CFG_DMA_SA_C0_SHIFT)
#define  LCD2_LCD_DMA_START_ADDR_C0_CFG_DMA_SA_C0_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_DMA_START_ADDR_C0_CFG_DMA_SA_C0_MASK) | (((uint32_t)val) << LCD2_LCD_DMA_START_ADDR_C0_CFG_DMA_SA_C0_SHIFT))

//====================================================================
//Register: Panel Video Frame 1 Y Starting Address Register (LCD_DMA_START_ADDR_Y1)
//====================================================================

#define  LCD2_LCD_DMA_START_ADDR_Y1_CFG_DMA_SA_Y1_MASK 0xffffffff
#define  LCD2_LCD_DMA_START_ADDR_Y1_CFG_DMA_SA_Y1_SHIFT 0
#define  LCD2_LCD_DMA_START_ADDR_Y1_CFG_DMA_SA_Y1_MASK_SHIFT(reg) (((reg) & LCD2_LCD_DMA_START_ADDR_Y1_CFG_DMA_SA_Y1_MASK) >> LCD2_LCD_DMA_START_ADDR_Y1_CFG_DMA_SA_Y1_SHIFT)
#define  LCD2_LCD_DMA_START_ADDR_Y1_CFG_DMA_SA_Y1_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_DMA_START_ADDR_Y1_CFG_DMA_SA_Y1_MASK) | (((uint32_t)val) << LCD2_LCD_DMA_START_ADDR_Y1_CFG_DMA_SA_Y1_SHIFT))

//====================================================================
//Register: Panel Video Frame 1 U Starting Address Register (LCD_DMA_START_ADDR_U1)
//====================================================================

#define  LCD2_LCD_DMA_START_ADDR_U1_CFG_DMA_SA_U1_MASK 0xffffffff
#define  LCD2_LCD_DMA_START_ADDR_U1_CFG_DMA_SA_U1_SHIFT 0
#define  LCD2_LCD_DMA_START_ADDR_U1_CFG_DMA_SA_U1_MASK_SHIFT(reg) (((reg) & LCD2_LCD_DMA_START_ADDR_U1_CFG_DMA_SA_U1_MASK) >> LCD2_LCD_DMA_START_ADDR_U1_CFG_DMA_SA_U1_SHIFT)
#define  LCD2_LCD_DMA_START_ADDR_U1_CFG_DMA_SA_U1_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_DMA_START_ADDR_U1_CFG_DMA_SA_U1_MASK) | (((uint32_t)val) << LCD2_LCD_DMA_START_ADDR_U1_CFG_DMA_SA_U1_SHIFT))

//====================================================================
//Register: Panel Video Frame 1 V Starting Address Register (LCD_DMA_START_ADDR_V1)
//====================================================================

#define  LCD2_LCD_DMA_START_ADDR_V1_CFG_DMA_SA_V1_MASK 0xffffffff
#define  LCD2_LCD_DMA_START_ADDR_V1_CFG_DMA_SA_V1_SHIFT 0
#define  LCD2_LCD_DMA_START_ADDR_V1_CFG_DMA_SA_V1_MASK_SHIFT(reg) (((reg) & LCD2_LCD_DMA_START_ADDR_V1_CFG_DMA_SA_V1_MASK) >> LCD2_LCD_DMA_START_ADDR_V1_CFG_DMA_SA_V1_SHIFT)
#define  LCD2_LCD_DMA_START_ADDR_V1_CFG_DMA_SA_V1_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_DMA_START_ADDR_V1_CFG_DMA_SA_V1_MASK) | (((uint32_t)val) << LCD2_LCD_DMA_START_ADDR_V1_CFG_DMA_SA_V1_SHIFT))

//====================================================================
//Register: Panel Video Frame 1 Command Starting Address Register (LCD_DMA_START_ADDR_C1)
//====================================================================

#define  LCD2_LCD_DMA_START_ADDR_C1_CFG_DMA_SA_C1_MASK 0xffffffff
#define  LCD2_LCD_DMA_START_ADDR_C1_CFG_DMA_SA_C1_SHIFT 0
#define  LCD2_LCD_DMA_START_ADDR_C1_CFG_DMA_SA_C1_MASK_SHIFT(reg) (((reg) & LCD2_LCD_DMA_START_ADDR_C1_CFG_DMA_SA_C1_MASK) >> LCD2_LCD_DMA_START_ADDR_C1_CFG_DMA_SA_C1_SHIFT)
#define  LCD2_LCD_DMA_START_ADDR_C1_CFG_DMA_SA_C1_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_DMA_START_ADDR_C1_CFG_DMA_SA_C1_MASK) | (((uint32_t)val) << LCD2_LCD_DMA_START_ADDR_C1_CFG_DMA_SA_C1_SHIFT))

//====================================================================
//Register: Panel Video Y and C Line Length (Pitch) Register (LCD_DMA_PITCH_YC)
//====================================================================

#define  LCD2_LCD_DMA_PITCH_YC_SPU_DMA_PITCH_C_MASK 0xffff0000
#define  LCD2_LCD_DMA_PITCH_YC_SPU_DMA_PITCH_C_SHIFT 16
#define  LCD2_LCD_DMA_PITCH_YC_SPU_DMA_PITCH_C_MASK_SHIFT(reg) (((reg) & LCD2_LCD_DMA_PITCH_YC_SPU_DMA_PITCH_C_MASK) >> LCD2_LCD_DMA_PITCH_YC_SPU_DMA_PITCH_C_SHIFT)
#define  LCD2_LCD_DMA_PITCH_YC_SPU_DMA_PITCH_C_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_DMA_PITCH_YC_SPU_DMA_PITCH_C_MASK) | (((uint32_t)val) << LCD2_LCD_DMA_PITCH_YC_SPU_DMA_PITCH_C_SHIFT))

#define  LCD2_LCD_DMA_PITCH_YC_SPU_DMA_PITCH_Y_MASK 0xffff
#define  LCD2_LCD_DMA_PITCH_YC_SPU_DMA_PITCH_Y_SHIFT 0
#define  LCD2_LCD_DMA_PITCH_YC_SPU_DMA_PITCH_Y_MASK_SHIFT(reg) (((reg) & LCD2_LCD_DMA_PITCH_YC_SPU_DMA_PITCH_Y_MASK) >> LCD2_LCD_DMA_PITCH_YC_SPU_DMA_PITCH_Y_SHIFT)
#define  LCD2_LCD_DMA_PITCH_YC_SPU_DMA_PITCH_Y_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_DMA_PITCH_YC_SPU_DMA_PITCH_Y_MASK) | (((uint32_t)val) << LCD2_LCD_DMA_PITCH_YC_SPU_DMA_PITCH_Y_SHIFT))

//====================================================================
//Register: Panel Video U and V Line Length (Pitch) Register (LCD_DMA_PITCH_UV)
//====================================================================

#define  LCD2_LCD_DMA_PITCH_UV_SPU_DMA_PITCH_V_MASK 0xffff0000
#define  LCD2_LCD_DMA_PITCH_UV_SPU_DMA_PITCH_V_SHIFT 16
#define  LCD2_LCD_DMA_PITCH_UV_SPU_DMA_PITCH_V_MASK_SHIFT(reg) (((reg) & LCD2_LCD_DMA_PITCH_UV_SPU_DMA_PITCH_V_MASK) >> LCD2_LCD_DMA_PITCH_UV_SPU_DMA_PITCH_V_SHIFT)
#define  LCD2_LCD_DMA_PITCH_UV_SPU_DMA_PITCH_V_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_DMA_PITCH_UV_SPU_DMA_PITCH_V_MASK) | (((uint32_t)val) << LCD2_LCD_DMA_PITCH_UV_SPU_DMA_PITCH_V_SHIFT))

#define  LCD2_LCD_DMA_PITCH_UV_SPU_DMA_PITCH_U_MASK 0xffff
#define  LCD2_LCD_DMA_PITCH_UV_SPU_DMA_PITCH_U_SHIFT 0
#define  LCD2_LCD_DMA_PITCH_UV_SPU_DMA_PITCH_U_MASK_SHIFT(reg) (((reg) & LCD2_LCD_DMA_PITCH_UV_SPU_DMA_PITCH_U_MASK) >> LCD2_LCD_DMA_PITCH_UV_SPU_DMA_PITCH_U_SHIFT)
#define  LCD2_LCD_DMA_PITCH_UV_SPU_DMA_PITCH_U_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_DMA_PITCH_UV_SPU_DMA_PITCH_U_MASK) | (((uint32_t)val) << LCD2_LCD_DMA_PITCH_UV_SPU_DMA_PITCH_U_SHIFT))

//====================================================================
//Register: Panel Video Starting Point on Screen Register (LCD_DMA_OVSA_HPXL_VLN)
//====================================================================

#define  LCD2_LCD_DMA_OVSA_HPXL_VLN_CFG_DMAFRM_FIX_MASK 0x80000000
#define  LCD2_LCD_DMA_OVSA_HPXL_VLN_CFG_DMAFRM_FIX_SHIFT 31
#define  LCD2_LCD_DMA_OVSA_HPXL_VLN_CFG_DMAFRM_FIX_MASK_SHIFT(reg) (((reg) & LCD2_LCD_DMA_OVSA_HPXL_VLN_CFG_DMAFRM_FIX_MASK) >> LCD2_LCD_DMA_OVSA_HPXL_VLN_CFG_DMAFRM_FIX_SHIFT)
#define  LCD2_LCD_DMA_OVSA_HPXL_VLN_CFG_DMAFRM_FIX_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_DMA_OVSA_HPXL_VLN_CFG_DMAFRM_FIX_MASK) | (((uint32_t)val) << LCD2_LCD_DMA_OVSA_HPXL_VLN_CFG_DMAFRM_FIX_SHIFT))

#define  LCD2_LCD_DMA_OVSA_HPXL_VLN_RESERVED1_MASK 0x70000000
#define  LCD2_LCD_DMA_OVSA_HPXL_VLN_RESERVED1_SHIFT 28
#define  LCD2_LCD_DMA_OVSA_HPXL_VLN_RESERVED1_MASK_SHIFT(reg) (((reg) & LCD2_LCD_DMA_OVSA_HPXL_VLN_RESERVED1_MASK) >> LCD2_LCD_DMA_OVSA_HPXL_VLN_RESERVED1_SHIFT)
#define  LCD2_LCD_DMA_OVSA_HPXL_VLN_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_DMA_OVSA_HPXL_VLN_RESERVED1_MASK) | (((uint32_t)val) << LCD2_LCD_DMA_OVSA_HPXL_VLN_RESERVED1_SHIFT))

#define  LCD2_LCD_DMA_OVSA_HPXL_VLN_CFG_DMA_OVSA_VLN_MASK 0xfff0000
#define  LCD2_LCD_DMA_OVSA_HPXL_VLN_CFG_DMA_OVSA_VLN_SHIFT 16
#define  LCD2_LCD_DMA_OVSA_HPXL_VLN_CFG_DMA_OVSA_VLN_MASK_SHIFT(reg) (((reg) & LCD2_LCD_DMA_OVSA_HPXL_VLN_CFG_DMA_OVSA_VLN_MASK) >> LCD2_LCD_DMA_OVSA_HPXL_VLN_CFG_DMA_OVSA_VLN_SHIFT)
#define  LCD2_LCD_DMA_OVSA_HPXL_VLN_CFG_DMA_OVSA_VLN_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_DMA_OVSA_HPXL_VLN_CFG_DMA_OVSA_VLN_MASK) | (((uint32_t)val) << LCD2_LCD_DMA_OVSA_HPXL_VLN_CFG_DMA_OVSA_VLN_SHIFT))

#define  LCD2_LCD_DMA_OVSA_HPXL_VLN_CFG_DMAFRM_Y_MASK 0x8000
#define  LCD2_LCD_DMA_OVSA_HPXL_VLN_CFG_DMAFRM_Y_SHIFT 15
#define  LCD2_LCD_DMA_OVSA_HPXL_VLN_CFG_DMAFRM_Y_MASK_SHIFT(reg) (((reg) & LCD2_LCD_DMA_OVSA_HPXL_VLN_CFG_DMAFRM_Y_MASK) >> LCD2_LCD_DMA_OVSA_HPXL_VLN_CFG_DMAFRM_Y_SHIFT)
#define  LCD2_LCD_DMA_OVSA_HPXL_VLN_CFG_DMAFRM_Y_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_DMA_OVSA_HPXL_VLN_CFG_DMAFRM_Y_MASK) | (((uint32_t)val) << LCD2_LCD_DMA_OVSA_HPXL_VLN_CFG_DMAFRM_Y_SHIFT))

#define  LCD2_LCD_DMA_OVSA_HPXL_VLN_CFG_DMAFRM_U_MASK 0x4000
#define  LCD2_LCD_DMA_OVSA_HPXL_VLN_CFG_DMAFRM_U_SHIFT 14
#define  LCD2_LCD_DMA_OVSA_HPXL_VLN_CFG_DMAFRM_U_MASK_SHIFT(reg) (((reg) & LCD2_LCD_DMA_OVSA_HPXL_VLN_CFG_DMAFRM_U_MASK) >> LCD2_LCD_DMA_OVSA_HPXL_VLN_CFG_DMAFRM_U_SHIFT)
#define  LCD2_LCD_DMA_OVSA_HPXL_VLN_CFG_DMAFRM_U_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_DMA_OVSA_HPXL_VLN_CFG_DMAFRM_U_MASK) | (((uint32_t)val) << LCD2_LCD_DMA_OVSA_HPXL_VLN_CFG_DMAFRM_U_SHIFT))

#define  LCD2_LCD_DMA_OVSA_HPXL_VLN_CFG_DMAFRM_V_MASK 0x2000
#define  LCD2_LCD_DMA_OVSA_HPXL_VLN_CFG_DMAFRM_V_SHIFT 13
#define  LCD2_LCD_DMA_OVSA_HPXL_VLN_CFG_DMAFRM_V_MASK_SHIFT(reg) (((reg) & LCD2_LCD_DMA_OVSA_HPXL_VLN_CFG_DMAFRM_V_MASK) >> LCD2_LCD_DMA_OVSA_HPXL_VLN_CFG_DMAFRM_V_SHIFT)
#define  LCD2_LCD_DMA_OVSA_HPXL_VLN_CFG_DMAFRM_V_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_DMA_OVSA_HPXL_VLN_CFG_DMAFRM_V_MASK) | (((uint32_t)val) << LCD2_LCD_DMA_OVSA_HPXL_VLN_CFG_DMAFRM_V_SHIFT))

#define  LCD2_LCD_DMA_OVSA_HPXL_VLN_CFG_DMAFRM_C_MASK 0x1000
#define  LCD2_LCD_DMA_OVSA_HPXL_VLN_CFG_DMAFRM_C_SHIFT 12
#define  LCD2_LCD_DMA_OVSA_HPXL_VLN_CFG_DMAFRM_C_MASK_SHIFT(reg) (((reg) & LCD2_LCD_DMA_OVSA_HPXL_VLN_CFG_DMAFRM_C_MASK) >> LCD2_LCD_DMA_OVSA_HPXL_VLN_CFG_DMAFRM_C_SHIFT)
#define  LCD2_LCD_DMA_OVSA_HPXL_VLN_CFG_DMAFRM_C_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_DMA_OVSA_HPXL_VLN_CFG_DMAFRM_C_MASK) | (((uint32_t)val) << LCD2_LCD_DMA_OVSA_HPXL_VLN_CFG_DMAFRM_C_SHIFT))

#define  LCD2_LCD_DMA_OVSA_HPXL_VLN_CFG_DMA_OVSA_HPXL_MASK 0xfff
#define  LCD2_LCD_DMA_OVSA_HPXL_VLN_CFG_DMA_OVSA_HPXL_SHIFT 0
#define  LCD2_LCD_DMA_OVSA_HPXL_VLN_CFG_DMA_OVSA_HPXL_MASK_SHIFT(reg) (((reg) & LCD2_LCD_DMA_OVSA_HPXL_VLN_CFG_DMA_OVSA_HPXL_MASK) >> LCD2_LCD_DMA_OVSA_HPXL_VLN_CFG_DMA_OVSA_HPXL_SHIFT)
#define  LCD2_LCD_DMA_OVSA_HPXL_VLN_CFG_DMA_OVSA_HPXL_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_DMA_OVSA_HPXL_VLN_CFG_DMA_OVSA_HPXL_MASK) | (((uint32_t)val) << LCD2_LCD_DMA_OVSA_HPXL_VLN_CFG_DMA_OVSA_HPXL_SHIFT))

//====================================================================
//Register: Panel Video Source Size Register (LCD_DMA_HPXL_VLN)
//====================================================================

#define  LCD2_LCD_DMA_HPXL_VLN_RESERVED1_MASK 0xf0000000
#define  LCD2_LCD_DMA_HPXL_VLN_RESERVED1_SHIFT 28
#define  LCD2_LCD_DMA_HPXL_VLN_RESERVED1_MASK_SHIFT(reg) (((reg) & LCD2_LCD_DMA_HPXL_VLN_RESERVED1_MASK) >> LCD2_LCD_DMA_HPXL_VLN_RESERVED1_SHIFT)
#define  LCD2_LCD_DMA_HPXL_VLN_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_DMA_HPXL_VLN_RESERVED1_MASK) | (((uint32_t)val) << LCD2_LCD_DMA_HPXL_VLN_RESERVED1_SHIFT))

#define  LCD2_LCD_DMA_HPXL_VLN_CFG_DMA_VLN_MASK 0xfff0000
#define  LCD2_LCD_DMA_HPXL_VLN_CFG_DMA_VLN_SHIFT 16
#define  LCD2_LCD_DMA_HPXL_VLN_CFG_DMA_VLN_MASK_SHIFT(reg) (((reg) & LCD2_LCD_DMA_HPXL_VLN_CFG_DMA_VLN_MASK) >> LCD2_LCD_DMA_HPXL_VLN_CFG_DMA_VLN_SHIFT)
#define  LCD2_LCD_DMA_HPXL_VLN_CFG_DMA_VLN_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_DMA_HPXL_VLN_CFG_DMA_VLN_MASK) | (((uint32_t)val) << LCD2_LCD_DMA_HPXL_VLN_CFG_DMA_VLN_SHIFT))

#define  LCD2_LCD_DMA_HPXL_VLN_RESERVED2_MASK 0xf000
#define  LCD2_LCD_DMA_HPXL_VLN_RESERVED2_SHIFT 12
#define  LCD2_LCD_DMA_HPXL_VLN_RESERVED2_MASK_SHIFT(reg) (((reg) & LCD2_LCD_DMA_HPXL_VLN_RESERVED2_MASK) >> LCD2_LCD_DMA_HPXL_VLN_RESERVED2_SHIFT)
#define  LCD2_LCD_DMA_HPXL_VLN_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_DMA_HPXL_VLN_RESERVED2_MASK) | (((uint32_t)val) << LCD2_LCD_DMA_HPXL_VLN_RESERVED2_SHIFT))

#define  LCD2_LCD_DMA_HPXL_VLN_CFG_DMA_HPXL_MASK 0xfff
#define  LCD2_LCD_DMA_HPXL_VLN_CFG_DMA_HPXL_SHIFT 0
#define  LCD2_LCD_DMA_HPXL_VLN_CFG_DMA_HPXL_MASK_SHIFT(reg) (((reg) & LCD2_LCD_DMA_HPXL_VLN_CFG_DMA_HPXL_MASK) >> LCD2_LCD_DMA_HPXL_VLN_CFG_DMA_HPXL_SHIFT)
#define  LCD2_LCD_DMA_HPXL_VLN_CFG_DMA_HPXL_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_DMA_HPXL_VLN_CFG_DMA_HPXL_MASK) | (((uint32_t)val) << LCD2_LCD_DMA_HPXL_VLN_CFG_DMA_HPXL_SHIFT))

//====================================================================
//Register: Panel Video Destination Size (After Zooming) Register (LCD_DMAZM_HPXL_VLN)
//====================================================================

#define  LCD2_LCD_DMAZM_HPXL_VLN_RESERVED1_MASK 0xf0000000
#define  LCD2_LCD_DMAZM_HPXL_VLN_RESERVED1_SHIFT 28
#define  LCD2_LCD_DMAZM_HPXL_VLN_RESERVED1_MASK_SHIFT(reg) (((reg) & LCD2_LCD_DMAZM_HPXL_VLN_RESERVED1_MASK) >> LCD2_LCD_DMAZM_HPXL_VLN_RESERVED1_SHIFT)
#define  LCD2_LCD_DMAZM_HPXL_VLN_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_DMAZM_HPXL_VLN_RESERVED1_MASK) | (((uint32_t)val) << LCD2_LCD_DMAZM_HPXL_VLN_RESERVED1_SHIFT))

#define  LCD2_LCD_DMAZM_HPXL_VLN_CFG_DMAZM_VLN_MASK 0xfff0000
#define  LCD2_LCD_DMAZM_HPXL_VLN_CFG_DMAZM_VLN_SHIFT 16
#define  LCD2_LCD_DMAZM_HPXL_VLN_CFG_DMAZM_VLN_MASK_SHIFT(reg) (((reg) & LCD2_LCD_DMAZM_HPXL_VLN_CFG_DMAZM_VLN_MASK) >> LCD2_LCD_DMAZM_HPXL_VLN_CFG_DMAZM_VLN_SHIFT)
#define  LCD2_LCD_DMAZM_HPXL_VLN_CFG_DMAZM_VLN_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_DMAZM_HPXL_VLN_CFG_DMAZM_VLN_MASK) | (((uint32_t)val) << LCD2_LCD_DMAZM_HPXL_VLN_CFG_DMAZM_VLN_SHIFT))

#define  LCD2_LCD_DMAZM_HPXL_VLN_RESERVED2_MASK 0xf000
#define  LCD2_LCD_DMAZM_HPXL_VLN_RESERVED2_SHIFT 12
#define  LCD2_LCD_DMAZM_HPXL_VLN_RESERVED2_MASK_SHIFT(reg) (((reg) & LCD2_LCD_DMAZM_HPXL_VLN_RESERVED2_MASK) >> LCD2_LCD_DMAZM_HPXL_VLN_RESERVED2_SHIFT)
#define  LCD2_LCD_DMAZM_HPXL_VLN_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_DMAZM_HPXL_VLN_RESERVED2_MASK) | (((uint32_t)val) << LCD2_LCD_DMAZM_HPXL_VLN_RESERVED2_SHIFT))

#define  LCD2_LCD_DMAZM_HPXL_VLN_CFG_DMAZM_HPXL_MASK 0xfff
#define  LCD2_LCD_DMAZM_HPXL_VLN_CFG_DMAZM_HPXL_SHIFT 0
#define  LCD2_LCD_DMAZM_HPXL_VLN_CFG_DMAZM_HPXL_MASK_SHIFT(reg) (((reg) & LCD2_LCD_DMAZM_HPXL_VLN_CFG_DMAZM_HPXL_MASK) >> LCD2_LCD_DMAZM_HPXL_VLN_CFG_DMAZM_HPXL_SHIFT)
#define  LCD2_LCD_DMAZM_HPXL_VLN_CFG_DMAZM_HPXL_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_DMAZM_HPXL_VLN_CFG_DMAZM_HPXL_MASK) | (((uint32_t)val) << LCD2_LCD_DMAZM_HPXL_VLN_CFG_DMAZM_HPXL_SHIFT))

//====================================================================
//Register: Panel Graphic Frame 0 Starting Address Register (LCD_GRA_START_ADDR0)
//====================================================================

#define  LCD2_LCD_GRA_START_ADDR0_CFG_GRA_SA0_MASK 0xffffffff
#define  LCD2_LCD_GRA_START_ADDR0_CFG_GRA_SA0_SHIFT 0
#define  LCD2_LCD_GRA_START_ADDR0_CFG_GRA_SA0_MASK_SHIFT(reg) (((reg) & LCD2_LCD_GRA_START_ADDR0_CFG_GRA_SA0_MASK) >> LCD2_LCD_GRA_START_ADDR0_CFG_GRA_SA0_SHIFT)
#define  LCD2_LCD_GRA_START_ADDR0_CFG_GRA_SA0_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_GRA_START_ADDR0_CFG_GRA_SA0_MASK) | (((uint32_t)val) << LCD2_LCD_GRA_START_ADDR0_CFG_GRA_SA0_SHIFT))

//====================================================================
//Register: Panel Graphic Frame 1 Starting Address Register (LCD_GRA_START_ADDR1)
//====================================================================

#define  LCD2_LCD_GRA_START_ADDR1_CFG_GRA_SA1_MASK 0xffffffff
#define  LCD2_LCD_GRA_START_ADDR1_CFG_GRA_SA1_SHIFT 0
#define  LCD2_LCD_GRA_START_ADDR1_CFG_GRA_SA1_MASK_SHIFT(reg) (((reg) & LCD2_LCD_GRA_START_ADDR1_CFG_GRA_SA1_MASK) >> LCD2_LCD_GRA_START_ADDR1_CFG_GRA_SA1_SHIFT)
#define  LCD2_LCD_GRA_START_ADDR1_CFG_GRA_SA1_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_GRA_START_ADDR1_CFG_GRA_SA1_MASK) | (((uint32_t)val) << LCD2_LCD_GRA_START_ADDR1_CFG_GRA_SA1_SHIFT))

//====================================================================
//Register: Panel Graphic Line Length (Pitch) Register (LCD_GRA_PITCH)
//====================================================================

#define  LCD2_LCD_GRA_PITCH_PN_DUTY_CYCLE_CTRL_MASK 0xf0000000
#define  LCD2_LCD_GRA_PITCH_PN_DUTY_CYCLE_CTRL_SHIFT 28
#define  LCD2_LCD_GRA_PITCH_PN_DUTY_CYCLE_CTRL_MASK_SHIFT(reg) (((reg) & LCD2_LCD_GRA_PITCH_PN_DUTY_CYCLE_CTRL_MASK) >> LCD2_LCD_GRA_PITCH_PN_DUTY_CYCLE_CTRL_SHIFT)
#define  LCD2_LCD_GRA_PITCH_PN_DUTY_CYCLE_CTRL_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_GRA_PITCH_PN_DUTY_CYCLE_CTRL_MASK) | (((uint32_t)val) << LCD2_LCD_GRA_PITCH_PN_DUTY_CYCLE_CTRL_SHIFT))

#define  LCD2_LCD_GRA_PITCH_CFG_PN_BKLIGHTDIV_MASK 0xfff0000
#define  LCD2_LCD_GRA_PITCH_CFG_PN_BKLIGHTDIV_SHIFT 16
#define  LCD2_LCD_GRA_PITCH_CFG_PN_BKLIGHTDIV_MASK_SHIFT(reg) (((reg) & LCD2_LCD_GRA_PITCH_CFG_PN_BKLIGHTDIV_MASK) >> LCD2_LCD_GRA_PITCH_CFG_PN_BKLIGHTDIV_SHIFT)
#define  LCD2_LCD_GRA_PITCH_CFG_PN_BKLIGHTDIV_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_GRA_PITCH_CFG_PN_BKLIGHTDIV_MASK) | (((uint32_t)val) << LCD2_LCD_GRA_PITCH_CFG_PN_BKLIGHTDIV_SHIFT))

#define  LCD2_LCD_GRA_PITCH_CFG_GRA_PITCH_MASK 0xffff
#define  LCD2_LCD_GRA_PITCH_CFG_GRA_PITCH_SHIFT 0
#define  LCD2_LCD_GRA_PITCH_CFG_GRA_PITCH_MASK_SHIFT(reg) (((reg) & LCD2_LCD_GRA_PITCH_CFG_GRA_PITCH_MASK) >> LCD2_LCD_GRA_PITCH_CFG_GRA_PITCH_SHIFT)
#define  LCD2_LCD_GRA_PITCH_CFG_GRA_PITCH_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_GRA_PITCH_CFG_GRA_PITCH_MASK) | (((uint32_t)val) << LCD2_LCD_GRA_PITCH_CFG_GRA_PITCH_SHIFT))

//====================================================================
//Register: Panel Graphic Starting Point on Screen Register (LCD_GRA_OVSA_HPXL_VLN)
//====================================================================

#define  LCD2_LCD_GRA_OVSA_HPXL_VLN_CFG_GRAFRM_FIX_MASK 0x80000000
#define  LCD2_LCD_GRA_OVSA_HPXL_VLN_CFG_GRAFRM_FIX_SHIFT 31
#define  LCD2_LCD_GRA_OVSA_HPXL_VLN_CFG_GRAFRM_FIX_MASK_SHIFT(reg) (((reg) & LCD2_LCD_GRA_OVSA_HPXL_VLN_CFG_GRAFRM_FIX_MASK) >> LCD2_LCD_GRA_OVSA_HPXL_VLN_CFG_GRAFRM_FIX_SHIFT)
#define  LCD2_LCD_GRA_OVSA_HPXL_VLN_CFG_GRAFRM_FIX_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_GRA_OVSA_HPXL_VLN_CFG_GRAFRM_FIX_MASK) | (((uint32_t)val) << LCD2_LCD_GRA_OVSA_HPXL_VLN_CFG_GRAFRM_FIX_SHIFT))

#define  LCD2_LCD_GRA_OVSA_HPXL_VLN_RESERVED1_MASK 0x70000000
#define  LCD2_LCD_GRA_OVSA_HPXL_VLN_RESERVED1_SHIFT 28
#define  LCD2_LCD_GRA_OVSA_HPXL_VLN_RESERVED1_MASK_SHIFT(reg) (((reg) & LCD2_LCD_GRA_OVSA_HPXL_VLN_RESERVED1_MASK) >> LCD2_LCD_GRA_OVSA_HPXL_VLN_RESERVED1_SHIFT)
#define  LCD2_LCD_GRA_OVSA_HPXL_VLN_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_GRA_OVSA_HPXL_VLN_RESERVED1_MASK) | (((uint32_t)val) << LCD2_LCD_GRA_OVSA_HPXL_VLN_RESERVED1_SHIFT))

#define  LCD2_LCD_GRA_OVSA_HPXL_VLN_CFG_GRA_OVSA_VLN_MASK 0xfff0000
#define  LCD2_LCD_GRA_OVSA_HPXL_VLN_CFG_GRA_OVSA_VLN_SHIFT 16
#define  LCD2_LCD_GRA_OVSA_HPXL_VLN_CFG_GRA_OVSA_VLN_MASK_SHIFT(reg) (((reg) & LCD2_LCD_GRA_OVSA_HPXL_VLN_CFG_GRA_OVSA_VLN_MASK) >> LCD2_LCD_GRA_OVSA_HPXL_VLN_CFG_GRA_OVSA_VLN_SHIFT)
#define  LCD2_LCD_GRA_OVSA_HPXL_VLN_CFG_GRA_OVSA_VLN_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_GRA_OVSA_HPXL_VLN_CFG_GRA_OVSA_VLN_MASK) | (((uint32_t)val) << LCD2_LCD_GRA_OVSA_HPXL_VLN_CFG_GRA_OVSA_VLN_SHIFT))

#define  LCD2_LCD_GRA_OVSA_HPXL_VLN_RESERVED2_MASK 0xe000
#define  LCD2_LCD_GRA_OVSA_HPXL_VLN_RESERVED2_SHIFT 13
#define  LCD2_LCD_GRA_OVSA_HPXL_VLN_RESERVED2_MASK_SHIFT(reg) (((reg) & LCD2_LCD_GRA_OVSA_HPXL_VLN_RESERVED2_MASK) >> LCD2_LCD_GRA_OVSA_HPXL_VLN_RESERVED2_SHIFT)
#define  LCD2_LCD_GRA_OVSA_HPXL_VLN_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_GRA_OVSA_HPXL_VLN_RESERVED2_MASK) | (((uint32_t)val) << LCD2_LCD_GRA_OVSA_HPXL_VLN_RESERVED2_SHIFT))

#define  LCD2_LCD_GRA_OVSA_HPXL_VLN_CFG_GRAFRM_Y_MASK 0x1000
#define  LCD2_LCD_GRA_OVSA_HPXL_VLN_CFG_GRAFRM_Y_SHIFT 12
#define  LCD2_LCD_GRA_OVSA_HPXL_VLN_CFG_GRAFRM_Y_MASK_SHIFT(reg) (((reg) & LCD2_LCD_GRA_OVSA_HPXL_VLN_CFG_GRAFRM_Y_MASK) >> LCD2_LCD_GRA_OVSA_HPXL_VLN_CFG_GRAFRM_Y_SHIFT)
#define  LCD2_LCD_GRA_OVSA_HPXL_VLN_CFG_GRAFRM_Y_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_GRA_OVSA_HPXL_VLN_CFG_GRAFRM_Y_MASK) | (((uint32_t)val) << LCD2_LCD_GRA_OVSA_HPXL_VLN_CFG_GRAFRM_Y_SHIFT))

#define  LCD2_LCD_GRA_OVSA_HPXL_VLN_CFG_GRA_OVSA_HPXL_MASK 0xfff
#define  LCD2_LCD_GRA_OVSA_HPXL_VLN_CFG_GRA_OVSA_HPXL_SHIFT 0
#define  LCD2_LCD_GRA_OVSA_HPXL_VLN_CFG_GRA_OVSA_HPXL_MASK_SHIFT(reg) (((reg) & LCD2_LCD_GRA_OVSA_HPXL_VLN_CFG_GRA_OVSA_HPXL_MASK) >> LCD2_LCD_GRA_OVSA_HPXL_VLN_CFG_GRA_OVSA_HPXL_SHIFT)
#define  LCD2_LCD_GRA_OVSA_HPXL_VLN_CFG_GRA_OVSA_HPXL_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_GRA_OVSA_HPXL_VLN_CFG_GRA_OVSA_HPXL_MASK) | (((uint32_t)val) << LCD2_LCD_GRA_OVSA_HPXL_VLN_CFG_GRA_OVSA_HPXL_SHIFT))

//====================================================================
//Register: Panel Graphic Source Size Register (LCD_GRA_HPXL_VLN)
//====================================================================

#define  LCD2_LCD_GRA_HPXL_VLN_RESERVED1_MASK 0xf0000000
#define  LCD2_LCD_GRA_HPXL_VLN_RESERVED1_SHIFT 28
#define  LCD2_LCD_GRA_HPXL_VLN_RESERVED1_MASK_SHIFT(reg) (((reg) & LCD2_LCD_GRA_HPXL_VLN_RESERVED1_MASK) >> LCD2_LCD_GRA_HPXL_VLN_RESERVED1_SHIFT)
#define  LCD2_LCD_GRA_HPXL_VLN_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_GRA_HPXL_VLN_RESERVED1_MASK) | (((uint32_t)val) << LCD2_LCD_GRA_HPXL_VLN_RESERVED1_SHIFT))

#define  LCD2_LCD_GRA_HPXL_VLN_CFG_GRA_VLN_MASK 0xfff0000
#define  LCD2_LCD_GRA_HPXL_VLN_CFG_GRA_VLN_SHIFT 16
#define  LCD2_LCD_GRA_HPXL_VLN_CFG_GRA_VLN_MASK_SHIFT(reg) (((reg) & LCD2_LCD_GRA_HPXL_VLN_CFG_GRA_VLN_MASK) >> LCD2_LCD_GRA_HPXL_VLN_CFG_GRA_VLN_SHIFT)
#define  LCD2_LCD_GRA_HPXL_VLN_CFG_GRA_VLN_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_GRA_HPXL_VLN_CFG_GRA_VLN_MASK) | (((uint32_t)val) << LCD2_LCD_GRA_HPXL_VLN_CFG_GRA_VLN_SHIFT))

#define  LCD2_LCD_GRA_HPXL_VLN_RESERVED2_MASK 0xf000
#define  LCD2_LCD_GRA_HPXL_VLN_RESERVED2_SHIFT 12
#define  LCD2_LCD_GRA_HPXL_VLN_RESERVED2_MASK_SHIFT(reg) (((reg) & LCD2_LCD_GRA_HPXL_VLN_RESERVED2_MASK) >> LCD2_LCD_GRA_HPXL_VLN_RESERVED2_SHIFT)
#define  LCD2_LCD_GRA_HPXL_VLN_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_GRA_HPXL_VLN_RESERVED2_MASK) | (((uint32_t)val) << LCD2_LCD_GRA_HPXL_VLN_RESERVED2_SHIFT))

#define  LCD2_LCD_GRA_HPXL_VLN_CFG_GRA_HPXL_MASK 0xfff
#define  LCD2_LCD_GRA_HPXL_VLN_CFG_GRA_HPXL_SHIFT 0
#define  LCD2_LCD_GRA_HPXL_VLN_CFG_GRA_HPXL_MASK_SHIFT(reg) (((reg) & LCD2_LCD_GRA_HPXL_VLN_CFG_GRA_HPXL_MASK) >> LCD2_LCD_GRA_HPXL_VLN_CFG_GRA_HPXL_SHIFT)
#define  LCD2_LCD_GRA_HPXL_VLN_CFG_GRA_HPXL_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_GRA_HPXL_VLN_CFG_GRA_HPXL_MASK) | (((uint32_t)val) << LCD2_LCD_GRA_HPXL_VLN_CFG_GRA_HPXL_SHIFT))

//====================================================================
//Register: Panel Graphic Destination Size (after Zooming) Register (LCD_GRAZM_HPXL_VLN)
//====================================================================

#define  LCD2_LCD_GRAZM_HPXL_VLN_RESERVED1_MASK 0xf0000000
#define  LCD2_LCD_GRAZM_HPXL_VLN_RESERVED1_SHIFT 28
#define  LCD2_LCD_GRAZM_HPXL_VLN_RESERVED1_MASK_SHIFT(reg) (((reg) & LCD2_LCD_GRAZM_HPXL_VLN_RESERVED1_MASK) >> LCD2_LCD_GRAZM_HPXL_VLN_RESERVED1_SHIFT)
#define  LCD2_LCD_GRAZM_HPXL_VLN_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_GRAZM_HPXL_VLN_RESERVED1_MASK) | (((uint32_t)val) << LCD2_LCD_GRAZM_HPXL_VLN_RESERVED1_SHIFT))

#define  LCD2_LCD_GRAZM_HPXL_VLN_CFG_GRAZM_VLN_MASK 0xfff0000
#define  LCD2_LCD_GRAZM_HPXL_VLN_CFG_GRAZM_VLN_SHIFT 16
#define  LCD2_LCD_GRAZM_HPXL_VLN_CFG_GRAZM_VLN_MASK_SHIFT(reg) (((reg) & LCD2_LCD_GRAZM_HPXL_VLN_CFG_GRAZM_VLN_MASK) >> LCD2_LCD_GRAZM_HPXL_VLN_CFG_GRAZM_VLN_SHIFT)
#define  LCD2_LCD_GRAZM_HPXL_VLN_CFG_GRAZM_VLN_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_GRAZM_HPXL_VLN_CFG_GRAZM_VLN_MASK) | (((uint32_t)val) << LCD2_LCD_GRAZM_HPXL_VLN_CFG_GRAZM_VLN_SHIFT))

#define  LCD2_LCD_GRAZM_HPXL_VLN_RESERVED2_MASK 0xf000
#define  LCD2_LCD_GRAZM_HPXL_VLN_RESERVED2_SHIFT 12
#define  LCD2_LCD_GRAZM_HPXL_VLN_RESERVED2_MASK_SHIFT(reg) (((reg) & LCD2_LCD_GRAZM_HPXL_VLN_RESERVED2_MASK) >> LCD2_LCD_GRAZM_HPXL_VLN_RESERVED2_SHIFT)
#define  LCD2_LCD_GRAZM_HPXL_VLN_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_GRAZM_HPXL_VLN_RESERVED2_MASK) | (((uint32_t)val) << LCD2_LCD_GRAZM_HPXL_VLN_RESERVED2_SHIFT))

#define  LCD2_LCD_GRAZM_HPXL_VLN_CFG_GRAZM_HPXL_MASK 0xfff
#define  LCD2_LCD_GRAZM_HPXL_VLN_CFG_GRAZM_HPXL_SHIFT 0
#define  LCD2_LCD_GRAZM_HPXL_VLN_CFG_GRAZM_HPXL_MASK_SHIFT(reg) (((reg) & LCD2_LCD_GRAZM_HPXL_VLN_CFG_GRAZM_HPXL_MASK) >> LCD2_LCD_GRAZM_HPXL_VLN_CFG_GRAZM_HPXL_SHIFT)
#define  LCD2_LCD_GRAZM_HPXL_VLN_CFG_GRAZM_HPXL_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_GRAZM_HPXL_VLN_CFG_GRAZM_HPXL_MASK) | (((uint32_t)val) << LCD2_LCD_GRAZM_HPXL_VLN_CFG_GRAZM_HPXL_SHIFT))

//====================================================================
//Register: Panel Total Screen Size Register (LCD_PN_V_H_TOTAL)
//====================================================================

#define  LCD2_LCD_PN_V_H_TOTAL_RESERVED1_MASK 0xf0000000
#define  LCD2_LCD_PN_V_H_TOTAL_RESERVED1_SHIFT 28
#define  LCD2_LCD_PN_V_H_TOTAL_RESERVED1_MASK_SHIFT(reg) (((reg) & LCD2_LCD_PN_V_H_TOTAL_RESERVED1_MASK) >> LCD2_LCD_PN_V_H_TOTAL_RESERVED1_SHIFT)
#define  LCD2_LCD_PN_V_H_TOTAL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_PN_V_H_TOTAL_RESERVED1_MASK) | (((uint32_t)val) << LCD2_LCD_PN_V_H_TOTAL_RESERVED1_SHIFT))

#define  LCD2_LCD_PN_V_H_TOTAL_CFG_PN_V_TOTAL_MASK 0xfff0000
#define  LCD2_LCD_PN_V_H_TOTAL_CFG_PN_V_TOTAL_SHIFT 16
#define  LCD2_LCD_PN_V_H_TOTAL_CFG_PN_V_TOTAL_MASK_SHIFT(reg) (((reg) & LCD2_LCD_PN_V_H_TOTAL_CFG_PN_V_TOTAL_MASK) >> LCD2_LCD_PN_V_H_TOTAL_CFG_PN_V_TOTAL_SHIFT)
#define  LCD2_LCD_PN_V_H_TOTAL_CFG_PN_V_TOTAL_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_PN_V_H_TOTAL_CFG_PN_V_TOTAL_MASK) | (((uint32_t)val) << LCD2_LCD_PN_V_H_TOTAL_CFG_PN_V_TOTAL_SHIFT))

#define  LCD2_LCD_PN_V_H_TOTAL_RESERVED2_MASK 0xf000
#define  LCD2_LCD_PN_V_H_TOTAL_RESERVED2_SHIFT 12
#define  LCD2_LCD_PN_V_H_TOTAL_RESERVED2_MASK_SHIFT(reg) (((reg) & LCD2_LCD_PN_V_H_TOTAL_RESERVED2_MASK) >> LCD2_LCD_PN_V_H_TOTAL_RESERVED2_SHIFT)
#define  LCD2_LCD_PN_V_H_TOTAL_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_PN_V_H_TOTAL_RESERVED2_MASK) | (((uint32_t)val) << LCD2_LCD_PN_V_H_TOTAL_RESERVED2_SHIFT))

#define  LCD2_LCD_PN_V_H_TOTAL_CFG_PN_H_TOTAL_MASK 0xfff
#define  LCD2_LCD_PN_V_H_TOTAL_CFG_PN_H_TOTAL_SHIFT 0
#define  LCD2_LCD_PN_V_H_TOTAL_CFG_PN_H_TOTAL_MASK_SHIFT(reg) (((reg) & LCD2_LCD_PN_V_H_TOTAL_CFG_PN_H_TOTAL_MASK) >> LCD2_LCD_PN_V_H_TOTAL_CFG_PN_H_TOTAL_SHIFT)
#define  LCD2_LCD_PN_V_H_TOTAL_CFG_PN_H_TOTAL_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_PN_V_H_TOTAL_CFG_PN_H_TOTAL_MASK) | (((uint32_t)val) << LCD2_LCD_PN_V_H_TOTAL_CFG_PN_H_TOTAL_SHIFT))

//====================================================================
//Register: Panel Screen Active Size Register (LCD_PN_V_H_ACTIVE)
//====================================================================

#define  LCD2_LCD_PN_V_H_ACTIVE_RESERVED1_MASK 0xf0000000
#define  LCD2_LCD_PN_V_H_ACTIVE_RESERVED1_SHIFT 28
#define  LCD2_LCD_PN_V_H_ACTIVE_RESERVED1_MASK_SHIFT(reg) (((reg) & LCD2_LCD_PN_V_H_ACTIVE_RESERVED1_MASK) >> LCD2_LCD_PN_V_H_ACTIVE_RESERVED1_SHIFT)
#define  LCD2_LCD_PN_V_H_ACTIVE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_PN_V_H_ACTIVE_RESERVED1_MASK) | (((uint32_t)val) << LCD2_LCD_PN_V_H_ACTIVE_RESERVED1_SHIFT))

#define  LCD2_LCD_PN_V_H_ACTIVE_CFG_PN_V_ACTIVE_MASK 0xfff0000
#define  LCD2_LCD_PN_V_H_ACTIVE_CFG_PN_V_ACTIVE_SHIFT 16
#define  LCD2_LCD_PN_V_H_ACTIVE_CFG_PN_V_ACTIVE_MASK_SHIFT(reg) (((reg) & LCD2_LCD_PN_V_H_ACTIVE_CFG_PN_V_ACTIVE_MASK) >> LCD2_LCD_PN_V_H_ACTIVE_CFG_PN_V_ACTIVE_SHIFT)
#define  LCD2_LCD_PN_V_H_ACTIVE_CFG_PN_V_ACTIVE_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_PN_V_H_ACTIVE_CFG_PN_V_ACTIVE_MASK) | (((uint32_t)val) << LCD2_LCD_PN_V_H_ACTIVE_CFG_PN_V_ACTIVE_SHIFT))

#define  LCD2_LCD_PN_V_H_ACTIVE_RESERVED2_MASK 0xf000
#define  LCD2_LCD_PN_V_H_ACTIVE_RESERVED2_SHIFT 12
#define  LCD2_LCD_PN_V_H_ACTIVE_RESERVED2_MASK_SHIFT(reg) (((reg) & LCD2_LCD_PN_V_H_ACTIVE_RESERVED2_MASK) >> LCD2_LCD_PN_V_H_ACTIVE_RESERVED2_SHIFT)
#define  LCD2_LCD_PN_V_H_ACTIVE_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_PN_V_H_ACTIVE_RESERVED2_MASK) | (((uint32_t)val) << LCD2_LCD_PN_V_H_ACTIVE_RESERVED2_SHIFT))

#define  LCD2_LCD_PN_V_H_ACTIVE_CFG_PN_H_ACTIVE_MASK 0xfff
#define  LCD2_LCD_PN_V_H_ACTIVE_CFG_PN_H_ACTIVE_SHIFT 0
#define  LCD2_LCD_PN_V_H_ACTIVE_CFG_PN_H_ACTIVE_MASK_SHIFT(reg) (((reg) & LCD2_LCD_PN_V_H_ACTIVE_CFG_PN_H_ACTIVE_MASK) >> LCD2_LCD_PN_V_H_ACTIVE_CFG_PN_H_ACTIVE_SHIFT)
#define  LCD2_LCD_PN_V_H_ACTIVE_CFG_PN_H_ACTIVE_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_PN_V_H_ACTIVE_CFG_PN_H_ACTIVE_MASK) | (((uint32_t)val) << LCD2_LCD_PN_V_H_ACTIVE_CFG_PN_H_ACTIVE_SHIFT))

//====================================================================
//Register: Panel Screen Horizontal Porch Register (LCD_PN_H_PORCH)
//====================================================================

#define  LCD2_LCD_PN_H_PORCH_RESERVED1_MASK 0xf0000000
#define  LCD2_LCD_PN_H_PORCH_RESERVED1_SHIFT 28
#define  LCD2_LCD_PN_H_PORCH_RESERVED1_MASK_SHIFT(reg) (((reg) & LCD2_LCD_PN_H_PORCH_RESERVED1_MASK) >> LCD2_LCD_PN_H_PORCH_RESERVED1_SHIFT)
#define  LCD2_LCD_PN_H_PORCH_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_PN_H_PORCH_RESERVED1_MASK) | (((uint32_t)val) << LCD2_LCD_PN_H_PORCH_RESERVED1_SHIFT))

#define  LCD2_LCD_PN_H_PORCH_CFG_PN_H_BPORCH_MASK 0xfff0000
#define  LCD2_LCD_PN_H_PORCH_CFG_PN_H_BPORCH_SHIFT 16
#define  LCD2_LCD_PN_H_PORCH_CFG_PN_H_BPORCH_MASK_SHIFT(reg) (((reg) & LCD2_LCD_PN_H_PORCH_CFG_PN_H_BPORCH_MASK) >> LCD2_LCD_PN_H_PORCH_CFG_PN_H_BPORCH_SHIFT)
#define  LCD2_LCD_PN_H_PORCH_CFG_PN_H_BPORCH_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_PN_H_PORCH_CFG_PN_H_BPORCH_MASK) | (((uint32_t)val) << LCD2_LCD_PN_H_PORCH_CFG_PN_H_BPORCH_SHIFT))

#define  LCD2_LCD_PN_H_PORCH_RESERVED2_MASK 0xf000
#define  LCD2_LCD_PN_H_PORCH_RESERVED2_SHIFT 12
#define  LCD2_LCD_PN_H_PORCH_RESERVED2_MASK_SHIFT(reg) (((reg) & LCD2_LCD_PN_H_PORCH_RESERVED2_MASK) >> LCD2_LCD_PN_H_PORCH_RESERVED2_SHIFT)
#define  LCD2_LCD_PN_H_PORCH_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_PN_H_PORCH_RESERVED2_MASK) | (((uint32_t)val) << LCD2_LCD_PN_H_PORCH_RESERVED2_SHIFT))

#define  LCD2_LCD_PN_H_PORCH_CFG_PN_H_FPORCH_MASK 0xfff
#define  LCD2_LCD_PN_H_PORCH_CFG_PN_H_FPORCH_SHIFT 0
#define  LCD2_LCD_PN_H_PORCH_CFG_PN_H_FPORCH_MASK_SHIFT(reg) (((reg) & LCD2_LCD_PN_H_PORCH_CFG_PN_H_FPORCH_MASK) >> LCD2_LCD_PN_H_PORCH_CFG_PN_H_FPORCH_SHIFT)
#define  LCD2_LCD_PN_H_PORCH_CFG_PN_H_FPORCH_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_PN_H_PORCH_CFG_PN_H_FPORCH_MASK) | (((uint32_t)val) << LCD2_LCD_PN_H_PORCH_CFG_PN_H_FPORCH_SHIFT))

//====================================================================
//Register: Panel Screen Vertical Porch Register (LCD_PN_V_PORCH)
//====================================================================

#define  LCD2_LCD_PN_V_PORCH_RESERVED1_MASK 0xf0000000
#define  LCD2_LCD_PN_V_PORCH_RESERVED1_SHIFT 28
#define  LCD2_LCD_PN_V_PORCH_RESERVED1_MASK_SHIFT(reg) (((reg) & LCD2_LCD_PN_V_PORCH_RESERVED1_MASK) >> LCD2_LCD_PN_V_PORCH_RESERVED1_SHIFT)
#define  LCD2_LCD_PN_V_PORCH_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_PN_V_PORCH_RESERVED1_MASK) | (((uint32_t)val) << LCD2_LCD_PN_V_PORCH_RESERVED1_SHIFT))

#define  LCD2_LCD_PN_V_PORCH_CFG_PN_V_BPORCH_MASK 0xfff0000
#define  LCD2_LCD_PN_V_PORCH_CFG_PN_V_BPORCH_SHIFT 16
#define  LCD2_LCD_PN_V_PORCH_CFG_PN_V_BPORCH_MASK_SHIFT(reg) (((reg) & LCD2_LCD_PN_V_PORCH_CFG_PN_V_BPORCH_MASK) >> LCD2_LCD_PN_V_PORCH_CFG_PN_V_BPORCH_SHIFT)
#define  LCD2_LCD_PN_V_PORCH_CFG_PN_V_BPORCH_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_PN_V_PORCH_CFG_PN_V_BPORCH_MASK) | (((uint32_t)val) << LCD2_LCD_PN_V_PORCH_CFG_PN_V_BPORCH_SHIFT))

#define  LCD2_LCD_PN_V_PORCH_RESERVED2_MASK 0xf000
#define  LCD2_LCD_PN_V_PORCH_RESERVED2_SHIFT 12
#define  LCD2_LCD_PN_V_PORCH_RESERVED2_MASK_SHIFT(reg) (((reg) & LCD2_LCD_PN_V_PORCH_RESERVED2_MASK) >> LCD2_LCD_PN_V_PORCH_RESERVED2_SHIFT)
#define  LCD2_LCD_PN_V_PORCH_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_PN_V_PORCH_RESERVED2_MASK) | (((uint32_t)val) << LCD2_LCD_PN_V_PORCH_RESERVED2_SHIFT))

#define  LCD2_LCD_PN_V_PORCH_CFG_PN_V_FPORCH_MASK 0xfff
#define  LCD2_LCD_PN_V_PORCH_CFG_PN_V_FPORCH_SHIFT 0
#define  LCD2_LCD_PN_V_PORCH_CFG_PN_V_FPORCH_MASK_SHIFT(reg) (((reg) & LCD2_LCD_PN_V_PORCH_CFG_PN_V_FPORCH_MASK) >> LCD2_LCD_PN_V_PORCH_CFG_PN_V_FPORCH_SHIFT)
#define  LCD2_LCD_PN_V_PORCH_CFG_PN_V_FPORCH_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_PN_V_PORCH_CFG_PN_V_FPORCH_MASK) | (((uint32_t)val) << LCD2_LCD_PN_V_PORCH_CFG_PN_V_FPORCH_SHIFT))

//====================================================================
//Register: Panel Screen Blank Color Register (LCD_PN_BLANKCOLOR)
//====================================================================

#define  LCD2_LCD_PN_BLANKCOLOR_RESERVED1_MASK 0xff000000
#define  LCD2_LCD_PN_BLANKCOLOR_RESERVED1_SHIFT 24
#define  LCD2_LCD_PN_BLANKCOLOR_RESERVED1_MASK_SHIFT(reg) (((reg) & LCD2_LCD_PN_BLANKCOLOR_RESERVED1_MASK) >> LCD2_LCD_PN_BLANKCOLOR_RESERVED1_SHIFT)
#define  LCD2_LCD_PN_BLANKCOLOR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_PN_BLANKCOLOR_RESERVED1_MASK) | (((uint32_t)val) << LCD2_LCD_PN_BLANKCOLOR_RESERVED1_SHIFT))

#define  LCD2_LCD_PN_BLANKCOLOR_CFG_PN_BLANKCOLOR_MASK 0xffffff
#define  LCD2_LCD_PN_BLANKCOLOR_CFG_PN_BLANKCOLOR_SHIFT 0
#define  LCD2_LCD_PN_BLANKCOLOR_CFG_PN_BLANKCOLOR_MASK_SHIFT(reg) (((reg) & LCD2_LCD_PN_BLANKCOLOR_CFG_PN_BLANKCOLOR_MASK) >> LCD2_LCD_PN_BLANKCOLOR_CFG_PN_BLANKCOLOR_SHIFT)
#define  LCD2_LCD_PN_BLANKCOLOR_CFG_PN_BLANKCOLOR_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_PN_BLANKCOLOR_CFG_PN_BLANKCOLOR_MASK) | (((uint32_t)val) << LCD2_LCD_PN_BLANKCOLOR_CFG_PN_BLANKCOLOR_SHIFT))

//====================================================================
//Register: Panel Video Y Color Key Control (LCD_PN_COLORKEY_Y)
//====================================================================

#define  LCD2_LCD_PN_COLORKEY_Y_CFG_PN_CKEY_Y2_MASK 0xff000000
#define  LCD2_LCD_PN_COLORKEY_Y_CFG_PN_CKEY_Y2_SHIFT 24
#define  LCD2_LCD_PN_COLORKEY_Y_CFG_PN_CKEY_Y2_MASK_SHIFT(reg) (((reg) & LCD2_LCD_PN_COLORKEY_Y_CFG_PN_CKEY_Y2_MASK) >> LCD2_LCD_PN_COLORKEY_Y_CFG_PN_CKEY_Y2_SHIFT)
#define  LCD2_LCD_PN_COLORKEY_Y_CFG_PN_CKEY_Y2_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_PN_COLORKEY_Y_CFG_PN_CKEY_Y2_MASK) | (((uint32_t)val) << LCD2_LCD_PN_COLORKEY_Y_CFG_PN_CKEY_Y2_SHIFT))

#define  LCD2_LCD_PN_COLORKEY_Y_CFG_PN_CKEY_Y1_MASK 0xff0000
#define  LCD2_LCD_PN_COLORKEY_Y_CFG_PN_CKEY_Y1_SHIFT 16
#define  LCD2_LCD_PN_COLORKEY_Y_CFG_PN_CKEY_Y1_MASK_SHIFT(reg) (((reg) & LCD2_LCD_PN_COLORKEY_Y_CFG_PN_CKEY_Y1_MASK) >> LCD2_LCD_PN_COLORKEY_Y_CFG_PN_CKEY_Y1_SHIFT)
#define  LCD2_LCD_PN_COLORKEY_Y_CFG_PN_CKEY_Y1_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_PN_COLORKEY_Y_CFG_PN_CKEY_Y1_MASK) | (((uint32_t)val) << LCD2_LCD_PN_COLORKEY_Y_CFG_PN_CKEY_Y1_SHIFT))

#define  LCD2_LCD_PN_COLORKEY_Y_CFG_PN_CKEY_Y_MASK 0xff00
#define  LCD2_LCD_PN_COLORKEY_Y_CFG_PN_CKEY_Y_SHIFT 8
#define  LCD2_LCD_PN_COLORKEY_Y_CFG_PN_CKEY_Y_MASK_SHIFT(reg) (((reg) & LCD2_LCD_PN_COLORKEY_Y_CFG_PN_CKEY_Y_MASK) >> LCD2_LCD_PN_COLORKEY_Y_CFG_PN_CKEY_Y_SHIFT)
#define  LCD2_LCD_PN_COLORKEY_Y_CFG_PN_CKEY_Y_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_PN_COLORKEY_Y_CFG_PN_CKEY_Y_MASK) | (((uint32_t)val) << LCD2_LCD_PN_COLORKEY_Y_CFG_PN_CKEY_Y_SHIFT))

#define  LCD2_LCD_PN_COLORKEY_Y_CFG_PN_ALPHA_Y_MASK 0xff
#define  LCD2_LCD_PN_COLORKEY_Y_CFG_PN_ALPHA_Y_SHIFT 0
#define  LCD2_LCD_PN_COLORKEY_Y_CFG_PN_ALPHA_Y_MASK_SHIFT(reg) (((reg) & LCD2_LCD_PN_COLORKEY_Y_CFG_PN_ALPHA_Y_MASK) >> LCD2_LCD_PN_COLORKEY_Y_CFG_PN_ALPHA_Y_SHIFT)
#define  LCD2_LCD_PN_COLORKEY_Y_CFG_PN_ALPHA_Y_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_PN_COLORKEY_Y_CFG_PN_ALPHA_Y_MASK) | (((uint32_t)val) << LCD2_LCD_PN_COLORKEY_Y_CFG_PN_ALPHA_Y_SHIFT))

//====================================================================
//Register: Panel Video U Color Key Control Register (LCD_PN_COLORKEY_U)
//====================================================================

#define  LCD2_LCD_PN_COLORKEY_U_CFG_PN_CEY_U2_MASK 0xff000000
#define  LCD2_LCD_PN_COLORKEY_U_CFG_PN_CEY_U2_SHIFT 24
#define  LCD2_LCD_PN_COLORKEY_U_CFG_PN_CEY_U2_MASK_SHIFT(reg) (((reg) & LCD2_LCD_PN_COLORKEY_U_CFG_PN_CEY_U2_MASK) >> LCD2_LCD_PN_COLORKEY_U_CFG_PN_CEY_U2_SHIFT)
#define  LCD2_LCD_PN_COLORKEY_U_CFG_PN_CEY_U2_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_PN_COLORKEY_U_CFG_PN_CEY_U2_MASK) | (((uint32_t)val) << LCD2_LCD_PN_COLORKEY_U_CFG_PN_CEY_U2_SHIFT))

#define  LCD2_LCD_PN_COLORKEY_U_CFG_PN_CKEY_U1_MASK 0xff0000
#define  LCD2_LCD_PN_COLORKEY_U_CFG_PN_CKEY_U1_SHIFT 16
#define  LCD2_LCD_PN_COLORKEY_U_CFG_PN_CKEY_U1_MASK_SHIFT(reg) (((reg) & LCD2_LCD_PN_COLORKEY_U_CFG_PN_CKEY_U1_MASK) >> LCD2_LCD_PN_COLORKEY_U_CFG_PN_CKEY_U1_SHIFT)
#define  LCD2_LCD_PN_COLORKEY_U_CFG_PN_CKEY_U1_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_PN_COLORKEY_U_CFG_PN_CKEY_U1_MASK) | (((uint32_t)val) << LCD2_LCD_PN_COLORKEY_U_CFG_PN_CKEY_U1_SHIFT))

#define  LCD2_LCD_PN_COLORKEY_U_CFG_PN_CKEY_U_MASK 0xff00
#define  LCD2_LCD_PN_COLORKEY_U_CFG_PN_CKEY_U_SHIFT 8
#define  LCD2_LCD_PN_COLORKEY_U_CFG_PN_CKEY_U_MASK_SHIFT(reg) (((reg) & LCD2_LCD_PN_COLORKEY_U_CFG_PN_CKEY_U_MASK) >> LCD2_LCD_PN_COLORKEY_U_CFG_PN_CKEY_U_SHIFT)
#define  LCD2_LCD_PN_COLORKEY_U_CFG_PN_CKEY_U_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_PN_COLORKEY_U_CFG_PN_CKEY_U_MASK) | (((uint32_t)val) << LCD2_LCD_PN_COLORKEY_U_CFG_PN_CKEY_U_SHIFT))

#define  LCD2_LCD_PN_COLORKEY_U_CFG_PN_ALPHA_U_MASK 0xff
#define  LCD2_LCD_PN_COLORKEY_U_CFG_PN_ALPHA_U_SHIFT 0
#define  LCD2_LCD_PN_COLORKEY_U_CFG_PN_ALPHA_U_MASK_SHIFT(reg) (((reg) & LCD2_LCD_PN_COLORKEY_U_CFG_PN_ALPHA_U_MASK) >> LCD2_LCD_PN_COLORKEY_U_CFG_PN_ALPHA_U_SHIFT)
#define  LCD2_LCD_PN_COLORKEY_U_CFG_PN_ALPHA_U_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_PN_COLORKEY_U_CFG_PN_ALPHA_U_MASK) | (((uint32_t)val) << LCD2_LCD_PN_COLORKEY_U_CFG_PN_ALPHA_U_SHIFT))

//====================================================================
//Register: Panel Video V Color Key Control Register (LCD_PN_COLORKEY_V)
//====================================================================

#define  LCD2_LCD_PN_COLORKEY_V_CFG_PN_CKEY_V2_MASK 0xff000000
#define  LCD2_LCD_PN_COLORKEY_V_CFG_PN_CKEY_V2_SHIFT 24
#define  LCD2_LCD_PN_COLORKEY_V_CFG_PN_CKEY_V2_MASK_SHIFT(reg) (((reg) & LCD2_LCD_PN_COLORKEY_V_CFG_PN_CKEY_V2_MASK) >> LCD2_LCD_PN_COLORKEY_V_CFG_PN_CKEY_V2_SHIFT)
#define  LCD2_LCD_PN_COLORKEY_V_CFG_PN_CKEY_V2_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_PN_COLORKEY_V_CFG_PN_CKEY_V2_MASK) | (((uint32_t)val) << LCD2_LCD_PN_COLORKEY_V_CFG_PN_CKEY_V2_SHIFT))

#define  LCD2_LCD_PN_COLORKEY_V_CFG_PN_CKEY_V1_MASK 0xff0000
#define  LCD2_LCD_PN_COLORKEY_V_CFG_PN_CKEY_V1_SHIFT 16
#define  LCD2_LCD_PN_COLORKEY_V_CFG_PN_CKEY_V1_MASK_SHIFT(reg) (((reg) & LCD2_LCD_PN_COLORKEY_V_CFG_PN_CKEY_V1_MASK) >> LCD2_LCD_PN_COLORKEY_V_CFG_PN_CKEY_V1_SHIFT)
#define  LCD2_LCD_PN_COLORKEY_V_CFG_PN_CKEY_V1_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_PN_COLORKEY_V_CFG_PN_CKEY_V1_MASK) | (((uint32_t)val) << LCD2_LCD_PN_COLORKEY_V_CFG_PN_CKEY_V1_SHIFT))

#define  LCD2_LCD_PN_COLORKEY_V_CFG_PN_CKEY_V_MASK 0xff00
#define  LCD2_LCD_PN_COLORKEY_V_CFG_PN_CKEY_V_SHIFT 8
#define  LCD2_LCD_PN_COLORKEY_V_CFG_PN_CKEY_V_MASK_SHIFT(reg) (((reg) & LCD2_LCD_PN_COLORKEY_V_CFG_PN_CKEY_V_MASK) >> LCD2_LCD_PN_COLORKEY_V_CFG_PN_CKEY_V_SHIFT)
#define  LCD2_LCD_PN_COLORKEY_V_CFG_PN_CKEY_V_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_PN_COLORKEY_V_CFG_PN_CKEY_V_MASK) | (((uint32_t)val) << LCD2_LCD_PN_COLORKEY_V_CFG_PN_CKEY_V_SHIFT))

#define  LCD2_LCD_PN_COLORKEY_V_CFG_PN_ALPHA_V_MASK 0xff
#define  LCD2_LCD_PN_COLORKEY_V_CFG_PN_ALPHA_V_SHIFT 0
#define  LCD2_LCD_PN_COLORKEY_V_CFG_PN_ALPHA_V_MASK_SHIFT(reg) (((reg) & LCD2_LCD_PN_COLORKEY_V_CFG_PN_ALPHA_V_MASK) >> LCD2_LCD_PN_COLORKEY_V_CFG_PN_ALPHA_V_SHIFT)
#define  LCD2_LCD_PN_COLORKEY_V_CFG_PN_ALPHA_V_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_PN_COLORKEY_V_CFG_PN_ALPHA_V_MASK) | (((uint32_t)val) << LCD2_LCD_PN_COLORKEY_V_CFG_PN_ALPHA_V_SHIFT))

//====================================================================
//Register: Panel VSYNC Pulse Pixel Edge Control Register (LCD_PN_SEPXLCNT)
//====================================================================

#define  LCD2_LCD_PN_SEPXLCNT_CFG_DBG_RD_INDEX_MASK 0xf0000000
#define  LCD2_LCD_PN_SEPXLCNT_CFG_DBG_RD_INDEX_SHIFT 28
#define  LCD2_LCD_PN_SEPXLCNT_CFG_DBG_RD_INDEX_MASK_SHIFT(reg) (((reg) & LCD2_LCD_PN_SEPXLCNT_CFG_DBG_RD_INDEX_MASK) >> LCD2_LCD_PN_SEPXLCNT_CFG_DBG_RD_INDEX_SHIFT)
#define  LCD2_LCD_PN_SEPXLCNT_CFG_DBG_RD_INDEX_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_PN_SEPXLCNT_CFG_DBG_RD_INDEX_MASK) | (((uint32_t)val) << LCD2_LCD_PN_SEPXLCNT_CFG_DBG_RD_INDEX_SHIFT))

#define  LCD2_LCD_PN_SEPXLCNT_CFG_PN_V_EPXLCNT_MASK 0xfff0000
#define  LCD2_LCD_PN_SEPXLCNT_CFG_PN_V_EPXLCNT_SHIFT 16
#define  LCD2_LCD_PN_SEPXLCNT_CFG_PN_V_EPXLCNT_MASK_SHIFT(reg) (((reg) & LCD2_LCD_PN_SEPXLCNT_CFG_PN_V_EPXLCNT_MASK) >> LCD2_LCD_PN_SEPXLCNT_CFG_PN_V_EPXLCNT_SHIFT)
#define  LCD2_LCD_PN_SEPXLCNT_CFG_PN_V_EPXLCNT_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_PN_SEPXLCNT_CFG_PN_V_EPXLCNT_MASK) | (((uint32_t)val) << LCD2_LCD_PN_SEPXLCNT_CFG_PN_V_EPXLCNT_SHIFT))

#define  LCD2_LCD_PN_SEPXLCNT_RESERVED1_MASK 0xf000
#define  LCD2_LCD_PN_SEPXLCNT_RESERVED1_SHIFT 12
#define  LCD2_LCD_PN_SEPXLCNT_RESERVED1_MASK_SHIFT(reg) (((reg) & LCD2_LCD_PN_SEPXLCNT_RESERVED1_MASK) >> LCD2_LCD_PN_SEPXLCNT_RESERVED1_SHIFT)
#define  LCD2_LCD_PN_SEPXLCNT_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_PN_SEPXLCNT_RESERVED1_MASK) | (((uint32_t)val) << LCD2_LCD_PN_SEPXLCNT_RESERVED1_SHIFT))

#define  LCD2_LCD_PN_SEPXLCNT_CFG_PN_V_SPXLCNT_MASK 0xfff
#define  LCD2_LCD_PN_SEPXLCNT_CFG_PN_V_SPXLCNT_SHIFT 0
#define  LCD2_LCD_PN_SEPXLCNT_CFG_PN_V_SPXLCNT_MASK_SHIFT(reg) (((reg) & LCD2_LCD_PN_SEPXLCNT_CFG_PN_V_SPXLCNT_MASK) >> LCD2_LCD_PN_SEPXLCNT_CFG_PN_V_SPXLCNT_SHIFT)
#define  LCD2_LCD_PN_SEPXLCNT_CFG_PN_V_SPXLCNT_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_PN_SEPXLCNT_CFG_PN_V_SPXLCNT_MASK) | (((uint32_t)val) << LCD2_LCD_PN_SEPXLCNT_CFG_PN_V_SPXLCNT_SHIFT))

//====================================================================
//Register: Smart Panel Read Data Register (LCD_ISA_RXDATA)
//====================================================================

#define  LCD2_LCD_ISA_RXDATA_ISA_RXDATA_MASK 0xffffffff
#define  LCD2_LCD_ISA_RXDATA_ISA_RXDATA_SHIFT 0
#define  LCD2_LCD_ISA_RXDATA_ISA_RXDATA_MASK_SHIFT(reg) (((reg) & LCD2_LCD_ISA_RXDATA_ISA_RXDATA_MASK) >> LCD2_LCD_ISA_RXDATA_ISA_RXDATA_SHIFT)
#define  LCD2_LCD_ISA_RXDATA_ISA_RXDATA_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_ISA_RXDATA_ISA_RXDATA_MASK) | (((uint32_t)val) << LCD2_LCD_ISA_RXDATA_ISA_RXDATA_SHIFT))

//====================================================================
//Register: Panel Path Panel Interface I/O Pad Read Register (LCD_READ_IOPAD)
//====================================================================

#define  LCD2_LCD_READ_IOPAD_RESERVED1_MASK 0xe0000000
#define  LCD2_LCD_READ_IOPAD_RESERVED1_SHIFT 29
#define  LCD2_LCD_READ_IOPAD_RESERVED1_MASK_SHIFT(reg) (((reg) & LCD2_LCD_READ_IOPAD_RESERVED1_MASK) >> LCD2_LCD_READ_IOPAD_RESERVED1_SHIFT)
#define  LCD2_LCD_READ_IOPAD_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_READ_IOPAD_RESERVED1_MASK) | (((uint32_t)val) << LCD2_LCD_READ_IOPAD_RESERVED1_SHIFT))

#define  LCD2_LCD_READ_IOPAD_PN_IOPAD_I_MASK 0x1fffffff
#define  LCD2_LCD_READ_IOPAD_PN_IOPAD_I_SHIFT 0
#define  LCD2_LCD_READ_IOPAD_PN_IOPAD_I_MASK_SHIFT(reg) (((reg) & LCD2_LCD_READ_IOPAD_PN_IOPAD_I_MASK) >> LCD2_LCD_READ_IOPAD_PN_IOPAD_I_SHIFT)
#define  LCD2_LCD_READ_IOPAD_PN_IOPAD_I_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_READ_IOPAD_PN_IOPAD_I_MASK) | (((uint32_t)val) << LCD2_LCD_READ_IOPAD_PN_IOPAD_I_SHIFT))

//====================================================================
//Register: Panel Video Actual Line Length in Memory Register (LCD_DMAVLD_YC)
//====================================================================

#define  LCD2_LCD_DMAVLD_YC_DMA_SA_YFLAG_MASK 0x80000000
#define  LCD2_LCD_DMAVLD_YC_DMA_SA_YFLAG_SHIFT 31
#define  LCD2_LCD_DMAVLD_YC_DMA_SA_YFLAG_MASK_SHIFT(reg) (((reg) & LCD2_LCD_DMAVLD_YC_DMA_SA_YFLAG_MASK) >> LCD2_LCD_DMAVLD_YC_DMA_SA_YFLAG_SHIFT)
#define  LCD2_LCD_DMAVLD_YC_DMA_SA_YFLAG_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_DMAVLD_YC_DMA_SA_YFLAG_MASK) | (((uint32_t)val) << LCD2_LCD_DMAVLD_YC_DMA_SA_YFLAG_SHIFT))

#define  LCD2_LCD_DMAVLD_YC_DMA_SA_UFLAG_MASK 0x40000000
#define  LCD2_LCD_DMAVLD_YC_DMA_SA_UFLAG_SHIFT 30
#define  LCD2_LCD_DMAVLD_YC_DMA_SA_UFLAG_MASK_SHIFT(reg) (((reg) & LCD2_LCD_DMAVLD_YC_DMA_SA_UFLAG_MASK) >> LCD2_LCD_DMAVLD_YC_DMA_SA_UFLAG_SHIFT)
#define  LCD2_LCD_DMAVLD_YC_DMA_SA_UFLAG_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_DMAVLD_YC_DMA_SA_UFLAG_MASK) | (((uint32_t)val) << LCD2_LCD_DMAVLD_YC_DMA_SA_UFLAG_SHIFT))

#define  LCD2_LCD_DMAVLD_YC_DMA_SA_VFLAG_MASK 0x20000000
#define  LCD2_LCD_DMAVLD_YC_DMA_SA_VFLAG_SHIFT 29
#define  LCD2_LCD_DMAVLD_YC_DMA_SA_VFLAG_MASK_SHIFT(reg) (((reg) & LCD2_LCD_DMAVLD_YC_DMA_SA_VFLAG_MASK) >> LCD2_LCD_DMAVLD_YC_DMA_SA_VFLAG_SHIFT)
#define  LCD2_LCD_DMAVLD_YC_DMA_SA_VFLAG_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_DMAVLD_YC_DMA_SA_VFLAG_MASK) | (((uint32_t)val) << LCD2_LCD_DMAVLD_YC_DMA_SA_VFLAG_SHIFT))

#define  LCD2_LCD_DMAVLD_YC_GRA_SA_YFLAG_MASK 0x10000000
#define  LCD2_LCD_DMAVLD_YC_GRA_SA_YFLAG_SHIFT 28
#define  LCD2_LCD_DMAVLD_YC_GRA_SA_YFLAG_MASK_SHIFT(reg) (((reg) & LCD2_LCD_DMAVLD_YC_GRA_SA_YFLAG_MASK) >> LCD2_LCD_DMAVLD_YC_GRA_SA_YFLAG_SHIFT)
#define  LCD2_LCD_DMAVLD_YC_GRA_SA_YFLAG_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_DMAVLD_YC_GRA_SA_YFLAG_MASK) | (((uint32_t)val) << LCD2_LCD_DMAVLD_YC_GRA_SA_YFLAG_SHIFT))

#define  LCD2_LCD_DMAVLD_YC_RESERVED1_MASK 0x8000000
#define  LCD2_LCD_DMAVLD_YC_RESERVED1_SHIFT 27
#define  LCD2_LCD_DMAVLD_YC_RESERVED1_MASK_SHIFT(reg) (((reg) & LCD2_LCD_DMAVLD_YC_RESERVED1_MASK) >> LCD2_LCD_DMAVLD_YC_RESERVED1_SHIFT)
#define  LCD2_LCD_DMAVLD_YC_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_DMAVLD_YC_RESERVED1_MASK) | (((uint32_t)val) << LCD2_LCD_DMAVLD_YC_RESERVED1_SHIFT))

#define  LCD2_LCD_DMAVLD_YC_RESERVED2_MASK 0x4000000
#define  LCD2_LCD_DMAVLD_YC_RESERVED2_SHIFT 26
#define  LCD2_LCD_DMAVLD_YC_RESERVED2_MASK_SHIFT(reg) (((reg) & LCD2_LCD_DMAVLD_YC_RESERVED2_MASK) >> LCD2_LCD_DMAVLD_YC_RESERVED2_SHIFT)
#define  LCD2_LCD_DMAVLD_YC_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_DMAVLD_YC_RESERVED2_MASK) | (((uint32_t)val) << LCD2_LCD_DMAVLD_YC_RESERVED2_SHIFT))

#define  LCD2_LCD_DMAVLD_YC_RESERVED3_MASK 0x2000000
#define  LCD2_LCD_DMAVLD_YC_RESERVED3_SHIFT 25
#define  LCD2_LCD_DMAVLD_YC_RESERVED3_MASK_SHIFT(reg) (((reg) & LCD2_LCD_DMAVLD_YC_RESERVED3_MASK) >> LCD2_LCD_DMAVLD_YC_RESERVED3_SHIFT)
#define  LCD2_LCD_DMAVLD_YC_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_DMAVLD_YC_RESERVED3_MASK) | (((uint32_t)val) << LCD2_LCD_DMAVLD_YC_RESERVED3_SHIFT))

#define  LCD2_LCD_DMAVLD_YC_RESERVED4_MASK 0x1000000
#define  LCD2_LCD_DMAVLD_YC_RESERVED4_SHIFT 24
#define  LCD2_LCD_DMAVLD_YC_RESERVED4_MASK_SHIFT(reg) (((reg) & LCD2_LCD_DMAVLD_YC_RESERVED4_MASK) >> LCD2_LCD_DMAVLD_YC_RESERVED4_SHIFT)
#define  LCD2_LCD_DMAVLD_YC_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_DMAVLD_YC_RESERVED4_MASK) | (((uint32_t)val) << LCD2_LCD_DMAVLD_YC_RESERVED4_SHIFT))

#define  LCD2_LCD_DMAVLD_YC_DMA_SA_CFLAG_MASK 0x800000
#define  LCD2_LCD_DMAVLD_YC_DMA_SA_CFLAG_SHIFT 23
#define  LCD2_LCD_DMAVLD_YC_DMA_SA_CFLAG_MASK_SHIFT(reg) (((reg) & LCD2_LCD_DMAVLD_YC_DMA_SA_CFLAG_MASK) >> LCD2_LCD_DMAVLD_YC_DMA_SA_CFLAG_SHIFT)
#define  LCD2_LCD_DMAVLD_YC_DMA_SA_CFLAG_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_DMAVLD_YC_DMA_SA_CFLAG_MASK) | (((uint32_t)val) << LCD2_LCD_DMAVLD_YC_DMA_SA_CFLAG_SHIFT))

#define  LCD2_LCD_DMAVLD_YC_RESERVED5_MASK 0x7f0000
#define  LCD2_LCD_DMAVLD_YC_RESERVED5_SHIFT 16
#define  LCD2_LCD_DMAVLD_YC_RESERVED5_MASK_SHIFT(reg) (((reg) & LCD2_LCD_DMAVLD_YC_RESERVED5_MASK) >> LCD2_LCD_DMAVLD_YC_RESERVED5_SHIFT)
#define  LCD2_LCD_DMAVLD_YC_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_DMAVLD_YC_RESERVED5_MASK) | (((uint32_t)val) << LCD2_LCD_DMAVLD_YC_RESERVED5_SHIFT))

#define  LCD2_LCD_DMAVLD_YC_CFG_DMAVLD_HLEN_Y_MASK 0xffff
#define  LCD2_LCD_DMAVLD_YC_CFG_DMAVLD_HLEN_Y_SHIFT 0
#define  LCD2_LCD_DMAVLD_YC_CFG_DMAVLD_HLEN_Y_MASK_SHIFT(reg) (((reg) & LCD2_LCD_DMAVLD_YC_CFG_DMAVLD_HLEN_Y_MASK) >> LCD2_LCD_DMAVLD_YC_CFG_DMAVLD_HLEN_Y_SHIFT)
#define  LCD2_LCD_DMAVLD_YC_CFG_DMAVLD_HLEN_Y_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_DMAVLD_YC_CFG_DMAVLD_HLEN_Y_MASK) | (((uint32_t)val) << LCD2_LCD_DMAVLD_YC_CFG_DMAVLD_HLEN_Y_SHIFT))

//====================================================================
//Register: Panel Video U and V Actual Line Length in Memory Register (LCD_DMAVLD_UV)
//====================================================================

#define  LCD2_LCD_DMAVLD_UV_RESERVED1_MASK 0xfff00000
#define  LCD2_LCD_DMAVLD_UV_RESERVED1_SHIFT 20
#define  LCD2_LCD_DMAVLD_UV_RESERVED1_MASK_SHIFT(reg) (((reg) & LCD2_LCD_DMAVLD_UV_RESERVED1_MASK) >> LCD2_LCD_DMAVLD_UV_RESERVED1_SHIFT)
#define  LCD2_LCD_DMAVLD_UV_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_DMAVLD_UV_RESERVED1_MASK) | (((uint32_t)val) << LCD2_LCD_DMAVLD_UV_RESERVED1_SHIFT))

#define  LCD2_LCD_DMAVLD_UV_CFG_DMAVLD_HLEN_V_MASK 0xffc00
#define  LCD2_LCD_DMAVLD_UV_CFG_DMAVLD_HLEN_V_SHIFT 10
#define  LCD2_LCD_DMAVLD_UV_CFG_DMAVLD_HLEN_V_MASK_SHIFT(reg) (((reg) & LCD2_LCD_DMAVLD_UV_CFG_DMAVLD_HLEN_V_MASK) >> LCD2_LCD_DMAVLD_UV_CFG_DMAVLD_HLEN_V_SHIFT)
#define  LCD2_LCD_DMAVLD_UV_CFG_DMAVLD_HLEN_V_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_DMAVLD_UV_CFG_DMAVLD_HLEN_V_MASK) | (((uint32_t)val) << LCD2_LCD_DMAVLD_UV_CFG_DMAVLD_HLEN_V_SHIFT))

#define  LCD2_LCD_DMAVLD_UV_CFG_DMAVLD_HLEN_U_MASK 0x3ff
#define  LCD2_LCD_DMAVLD_UV_CFG_DMAVLD_HLEN_U_SHIFT 0
#define  LCD2_LCD_DMAVLD_UV_CFG_DMAVLD_HLEN_U_MASK_SHIFT(reg) (((reg) & LCD2_LCD_DMAVLD_UV_CFG_DMAVLD_HLEN_U_MASK) >> LCD2_LCD_DMAVLD_UV_CFG_DMAVLD_HLEN_U_SHIFT)
#define  LCD2_LCD_DMAVLD_UV_CFG_DMAVLD_HLEN_U_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_DMAVLD_UV_CFG_DMAVLD_HLEN_U_MASK) | (((uint32_t)val) << LCD2_LCD_DMAVLD_UV_CFG_DMAVLD_HLEN_U_SHIFT))

//====================================================================
//Register: Graphic Actual Line Length (Pitch) in System Memory (LCD_TVGGRAVLD_HLEN)
//====================================================================

#define  LCD2_LCD_TVGGRAVLD_HLEN_RESERVED1_MASK 0xffff0000
#define  LCD2_LCD_TVGGRAVLD_HLEN_RESERVED1_SHIFT 16
#define  LCD2_LCD_TVGGRAVLD_HLEN_RESERVED1_MASK_SHIFT(reg) (((reg) & LCD2_LCD_TVGGRAVLD_HLEN_RESERVED1_MASK) >> LCD2_LCD_TVGGRAVLD_HLEN_RESERVED1_SHIFT)
#define  LCD2_LCD_TVGGRAVLD_HLEN_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_TVGGRAVLD_HLEN_RESERVED1_MASK) | (((uint32_t)val) << LCD2_LCD_TVGGRAVLD_HLEN_RESERVED1_SHIFT))

#define  LCD2_LCD_TVGGRAVLD_HLEN_CFG_GRAVLD_HLEN_MASK 0xffff
#define  LCD2_LCD_TVGGRAVLD_HLEN_CFG_GRAVLD_HLEN_SHIFT 0
#define  LCD2_LCD_TVGGRAVLD_HLEN_CFG_GRAVLD_HLEN_MASK_SHIFT(reg) (((reg) & LCD2_LCD_TVGGRAVLD_HLEN_CFG_GRAVLD_HLEN_MASK) >> LCD2_LCD_TVGGRAVLD_HLEN_CFG_GRAVLD_HLEN_SHIFT)
#define  LCD2_LCD_TVGGRAVLD_HLEN_CFG_GRAVLD_HLEN_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_TVGGRAVLD_HLEN_CFG_GRAVLD_HLEN_MASK) | (((uint32_t)val) << LCD2_LCD_TVGGRAVLD_HLEN_CFG_GRAVLD_HLEN_SHIFT))

//====================================================================
//Register: Panel Gamma Table SRAM Read Data Register (LCD_PN_GAMMA_RDDAT)
//====================================================================

#define  LCD2_LCD_PN_GAMMA_RDDAT_RESERVED1_MASK 0xffffff00
#define  LCD2_LCD_PN_GAMMA_RDDAT_RESERVED1_SHIFT 8
#define  LCD2_LCD_PN_GAMMA_RDDAT_RESERVED1_MASK_SHIFT(reg) (((reg) & LCD2_LCD_PN_GAMMA_RDDAT_RESERVED1_MASK) >> LCD2_LCD_PN_GAMMA_RDDAT_RESERVED1_SHIFT)
#define  LCD2_LCD_PN_GAMMA_RDDAT_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_PN_GAMMA_RDDAT_RESERVED1_MASK) | (((uint32_t)val) << LCD2_LCD_PN_GAMMA_RDDAT_RESERVED1_SHIFT))

#define  LCD2_LCD_PN_GAMMA_RDDAT_CFG_PN_GAMMA_RDDAT_MASK 0xff
#define  LCD2_LCD_PN_GAMMA_RDDAT_CFG_PN_GAMMA_RDDAT_SHIFT 0
#define  LCD2_LCD_PN_GAMMA_RDDAT_CFG_PN_GAMMA_RDDAT_MASK_SHIFT(reg) (((reg) & LCD2_LCD_PN_GAMMA_RDDAT_CFG_PN_GAMMA_RDDAT_MASK) >> LCD2_LCD_PN_GAMMA_RDDAT_CFG_PN_GAMMA_RDDAT_SHIFT)
#define  LCD2_LCD_PN_GAMMA_RDDAT_CFG_PN_GAMMA_RDDAT_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_PN_GAMMA_RDDAT_CFG_PN_GAMMA_RDDAT_MASK) | (((uint32_t)val) << LCD2_LCD_PN_GAMMA_RDDAT_CFG_PN_GAMMA_RDDAT_SHIFT))

//====================================================================
//Register: Panel Palette Table SRAM Read Data Register (LCD_PN_PALETTE_RDDAT)
//====================================================================

#define  LCD2_LCD_PN_PALETTE_RDDAT_RESERVED1_MASK 0xff000000
#define  LCD2_LCD_PN_PALETTE_RDDAT_RESERVED1_SHIFT 24
#define  LCD2_LCD_PN_PALETTE_RDDAT_RESERVED1_MASK_SHIFT(reg) (((reg) & LCD2_LCD_PN_PALETTE_RDDAT_RESERVED1_MASK) >> LCD2_LCD_PN_PALETTE_RDDAT_RESERVED1_SHIFT)
#define  LCD2_LCD_PN_PALETTE_RDDAT_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_PN_PALETTE_RDDAT_RESERVED1_MASK) | (((uint32_t)val) << LCD2_LCD_PN_PALETTE_RDDAT_RESERVED1_SHIFT))

#define  LCD2_LCD_PN_PALETTE_RDDAT_CFG_PN_PALETTE_RDDAT_MASK 0xffffff
#define  LCD2_LCD_PN_PALETTE_RDDAT_CFG_PN_PALETTE_RDDAT_SHIFT 0
#define  LCD2_LCD_PN_PALETTE_RDDAT_CFG_PN_PALETTE_RDDAT_MASK_SHIFT(reg) (((reg) & LCD2_LCD_PN_PALETTE_RDDAT_CFG_PN_PALETTE_RDDAT_MASK) >> LCD2_LCD_PN_PALETTE_RDDAT_CFG_PN_PALETTE_RDDAT_SHIFT)
#define  LCD2_LCD_PN_PALETTE_RDDAT_CFG_PN_PALETTE_RDDAT_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_PN_PALETTE_RDDAT_CFG_PN_PALETTE_RDDAT_MASK) | (((uint32_t)val) << LCD2_LCD_PN_PALETTE_RDDAT_CFG_PN_PALETTE_RDDAT_SHIFT))

//====================================================================
//Register: Panel Slave Path Status and Debug Register (LCD_SLV_DBG)
/** \brief This register provides status information about the 32entry x 32bit AHB Slave Path FIFO. In order to read the FIFO status,
             be sure that the LCD_PN_SEPXLCNT register (0x13C) CG_DBG_RD_INDEX field (bits 31:28) is set to 0.*/
//====================================================================

#define  LCD2_LCD_SLV_DBG_RESERVED1_MASK 0xfff00000
#define  LCD2_LCD_SLV_DBG_RESERVED1_SHIFT 20
#define  LCD2_LCD_SLV_DBG_RESERVED1_MASK_SHIFT(reg) (((reg) & LCD2_LCD_SLV_DBG_RESERVED1_MASK) >> LCD2_LCD_SLV_DBG_RESERVED1_SHIFT)
#define  LCD2_LCD_SLV_DBG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_SLV_DBG_RESERVED1_MASK) | (((uint32_t)val) << LCD2_LCD_SLV_DBG_RESERVED1_SHIFT))

#define  LCD2_LCD_SLV_DBG_SLV_SPACECNT_MASK 0xff000
#define  LCD2_LCD_SLV_DBG_SLV_SPACECNT_SHIFT 12
#define  LCD2_LCD_SLV_DBG_SLV_SPACECNT_MASK_SHIFT(reg) (((reg) & LCD2_LCD_SLV_DBG_SLV_SPACECNT_MASK) >> LCD2_LCD_SLV_DBG_SLV_SPACECNT_SHIFT)
#define  LCD2_LCD_SLV_DBG_SLV_SPACECNT_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_SLV_DBG_SLV_SPACECNT_MASK) | (((uint32_t)val) << LCD2_LCD_SLV_DBG_SLV_SPACECNT_SHIFT))

#define  LCD2_LCD_SLV_DBG_SLV_DATACNT_MASK 0xff0
#define  LCD2_LCD_SLV_DBG_SLV_DATACNT_SHIFT 4
#define  LCD2_LCD_SLV_DBG_SLV_DATACNT_MASK_SHIFT(reg) (((reg) & LCD2_LCD_SLV_DBG_SLV_DATACNT_MASK) >> LCD2_LCD_SLV_DBG_SLV_DATACNT_SHIFT)
#define  LCD2_LCD_SLV_DBG_SLV_DATACNT_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_SLV_DBG_SLV_DATACNT_MASK) | (((uint32_t)val) << LCD2_LCD_SLV_DBG_SLV_DATACNT_SHIFT))

#define  LCD2_LCD_SLV_DBG_RESERVED2_MASK 0xf
#define  LCD2_LCD_SLV_DBG_RESERVED2_SHIFT 0
#define  LCD2_LCD_SLV_DBG_RESERVED2_MASK_SHIFT(reg) (((reg) & LCD2_LCD_SLV_DBG_RESERVED2_MASK) >> LCD2_LCD_SLV_DBG_RESERVED2_SHIFT)
#define  LCD2_LCD_SLV_DBG_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_SLV_DBG_RESERVED2_MASK) | (((uint32_t)val) << LCD2_LCD_SLV_DBG_RESERVED2_SHIFT))

//====================================================================
//Register: Display Frame Number Read Only Registers (LCD_FRAME_CNT)
//====================================================================

#define  LCD2_LCD_FRAME_CNT_RESERVED1_MASK 0xffff0000
#define  LCD2_LCD_FRAME_CNT_RESERVED1_SHIFT 16
#define  LCD2_LCD_FRAME_CNT_RESERVED1_MASK_SHIFT(reg) (((reg) & LCD2_LCD_FRAME_CNT_RESERVED1_MASK) >> LCD2_LCD_FRAME_CNT_RESERVED1_SHIFT)
#define  LCD2_LCD_FRAME_CNT_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_FRAME_CNT_RESERVED1_MASK) | (((uint32_t)val) << LCD2_LCD_FRAME_CNT_RESERVED1_SHIFT))

#define  LCD2_LCD_FRAME_CNT_RESERVED2_MASK 0xc000
#define  LCD2_LCD_FRAME_CNT_RESERVED2_SHIFT 14
#define  LCD2_LCD_FRAME_CNT_RESERVED2_MASK_SHIFT(reg) (((reg) & LCD2_LCD_FRAME_CNT_RESERVED2_MASK) >> LCD2_LCD_FRAME_CNT_RESERVED2_SHIFT)
#define  LCD2_LCD_FRAME_CNT_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_FRAME_CNT_RESERVED2_MASK) | (((uint32_t)val) << LCD2_LCD_FRAME_CNT_RESERVED2_SHIFT))

#define  LCD2_LCD_FRAME_CNT_RESERVED3_MASK 0x3000
#define  LCD2_LCD_FRAME_CNT_RESERVED3_SHIFT 12
#define  LCD2_LCD_FRAME_CNT_RESERVED3_MASK_SHIFT(reg) (((reg) & LCD2_LCD_FRAME_CNT_RESERVED3_MASK) >> LCD2_LCD_FRAME_CNT_RESERVED3_SHIFT)
#define  LCD2_LCD_FRAME_CNT_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_FRAME_CNT_RESERVED3_MASK) | (((uint32_t)val) << LCD2_LCD_FRAME_CNT_RESERVED3_SHIFT))

#define  LCD2_LCD_FRAME_CNT_RESERVED4_MASK 0xc00
#define  LCD2_LCD_FRAME_CNT_RESERVED4_SHIFT 10
#define  LCD2_LCD_FRAME_CNT_RESERVED4_MASK_SHIFT(reg) (((reg) & LCD2_LCD_FRAME_CNT_RESERVED4_MASK) >> LCD2_LCD_FRAME_CNT_RESERVED4_SHIFT)
#define  LCD2_LCD_FRAME_CNT_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_FRAME_CNT_RESERVED4_MASK) | (((uint32_t)val) << LCD2_LCD_FRAME_CNT_RESERVED4_SHIFT))

#define  LCD2_LCD_FRAME_CNT_RESERVED5_MASK 0x300
#define  LCD2_LCD_FRAME_CNT_RESERVED5_SHIFT 8
#define  LCD2_LCD_FRAME_CNT_RESERVED5_MASK_SHIFT(reg) (((reg) & LCD2_LCD_FRAME_CNT_RESERVED5_MASK) >> LCD2_LCD_FRAME_CNT_RESERVED5_SHIFT)
#define  LCD2_LCD_FRAME_CNT_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_FRAME_CNT_RESERVED5_MASK) | (((uint32_t)val) << LCD2_LCD_FRAME_CNT_RESERVED5_SHIFT))

#define  LCD2_LCD_FRAME_CNT_RESERVED6_MASK 0xc0
#define  LCD2_LCD_FRAME_CNT_RESERVED6_SHIFT 6
#define  LCD2_LCD_FRAME_CNT_RESERVED6_MASK_SHIFT(reg) (((reg) & LCD2_LCD_FRAME_CNT_RESERVED6_MASK) >> LCD2_LCD_FRAME_CNT_RESERVED6_SHIFT)
#define  LCD2_LCD_FRAME_CNT_RESERVED6_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_FRAME_CNT_RESERVED6_MASK) | (((uint32_t)val) << LCD2_LCD_FRAME_CNT_RESERVED6_SHIFT))

#define  LCD2_LCD_FRAME_CNT_RESERVED7_MASK 0x30
#define  LCD2_LCD_FRAME_CNT_RESERVED7_SHIFT 4
#define  LCD2_LCD_FRAME_CNT_RESERVED7_MASK_SHIFT(reg) (((reg) & LCD2_LCD_FRAME_CNT_RESERVED7_MASK) >> LCD2_LCD_FRAME_CNT_RESERVED7_SHIFT)
#define  LCD2_LCD_FRAME_CNT_RESERVED7_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_FRAME_CNT_RESERVED7_MASK) | (((uint32_t)val) << LCD2_LCD_FRAME_CNT_RESERVED7_SHIFT))

#define  LCD2_LCD_FRAME_CNT_GRA_FRAME_CNT_MASK 0xc
#define  LCD2_LCD_FRAME_CNT_GRA_FRAME_CNT_SHIFT 2
#define  LCD2_LCD_FRAME_CNT_GRA_FRAME_CNT_MASK_SHIFT(reg) (((reg) & LCD2_LCD_FRAME_CNT_GRA_FRAME_CNT_MASK) >> LCD2_LCD_FRAME_CNT_GRA_FRAME_CNT_SHIFT)
#define  LCD2_LCD_FRAME_CNT_GRA_FRAME_CNT_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_FRAME_CNT_GRA_FRAME_CNT_MASK) | (((uint32_t)val) << LCD2_LCD_FRAME_CNT_GRA_FRAME_CNT_SHIFT))

#define  LCD2_LCD_FRAME_CNT_DMA_FRAME_CNT_MASK 0x3
#define  LCD2_LCD_FRAME_CNT_DMA_FRAME_CNT_SHIFT 0
#define  LCD2_LCD_FRAME_CNT_DMA_FRAME_CNT_MASK_SHIFT(reg) (((reg) & LCD2_LCD_FRAME_CNT_DMA_FRAME_CNT_MASK) >> LCD2_LCD_FRAME_CNT_DMA_FRAME_CNT_SHIFT)
#define  LCD2_LCD_FRAME_CNT_DMA_FRAME_CNT_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_FRAME_CNT_DMA_FRAME_CNT_MASK) | (((uint32_t)val) << LCD2_LCD_FRAME_CNT_DMA_FRAME_CNT_SHIFT))

//====================================================================
//Register: Smart Panel 8-bit Bus Control Register (LCD_SMPN_CTRL)
//====================================================================

#define  LCD2_LCD_SMPN_CTRL_CFG_ISA_RXLOW_MASK 0xf0000000
#define  LCD2_LCD_SMPN_CTRL_CFG_ISA_RXLOW_SHIFT 28
#define  LCD2_LCD_SMPN_CTRL_CFG_ISA_RXLOW_MASK_SHIFT(reg) (((reg) & LCD2_LCD_SMPN_CTRL_CFG_ISA_RXLOW_MASK) >> LCD2_LCD_SMPN_CTRL_CFG_ISA_RXLOW_SHIFT)
#define  LCD2_LCD_SMPN_CTRL_CFG_ISA_RXLOW_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_SMPN_CTRL_CFG_ISA_RXLOW_MASK) | (((uint32_t)val) << LCD2_LCD_SMPN_CTRL_CFG_ISA_RXLOW_SHIFT))

#define  LCD2_LCD_SMPN_CTRL_CFG_ISA_RXHIGH_MASK 0xf000000
#define  LCD2_LCD_SMPN_CTRL_CFG_ISA_RXHIGH_SHIFT 24
#define  LCD2_LCD_SMPN_CTRL_CFG_ISA_RXHIGH_MASK_SHIFT(reg) (((reg) & LCD2_LCD_SMPN_CTRL_CFG_ISA_RXHIGH_MASK) >> LCD2_LCD_SMPN_CTRL_CFG_ISA_RXHIGH_SHIFT)
#define  LCD2_LCD_SMPN_CTRL_CFG_ISA_RXHIGH_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_SMPN_CTRL_CFG_ISA_RXHIGH_MASK) | (((uint32_t)val) << LCD2_LCD_SMPN_CTRL_CFG_ISA_RXHIGH_SHIFT))

#define  LCD2_LCD_SMPN_CTRL_CFG_ISA_TXLOW_MASK 0xf00000
#define  LCD2_LCD_SMPN_CTRL_CFG_ISA_TXLOW_SHIFT 20
#define  LCD2_LCD_SMPN_CTRL_CFG_ISA_TXLOW_MASK_SHIFT(reg) (((reg) & LCD2_LCD_SMPN_CTRL_CFG_ISA_TXLOW_MASK) >> LCD2_LCD_SMPN_CTRL_CFG_ISA_TXLOW_SHIFT)
#define  LCD2_LCD_SMPN_CTRL_CFG_ISA_TXLOW_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_SMPN_CTRL_CFG_ISA_TXLOW_MASK) | (((uint32_t)val) << LCD2_LCD_SMPN_CTRL_CFG_ISA_TXLOW_SHIFT))

#define  LCD2_LCD_SMPN_CTRL_CFG_ISA_TXHIGH_MASK 0xf0000
#define  LCD2_LCD_SMPN_CTRL_CFG_ISA_TXHIGH_SHIFT 16
#define  LCD2_LCD_SMPN_CTRL_CFG_ISA_TXHIGH_MASK_SHIFT(reg) (((reg) & LCD2_LCD_SMPN_CTRL_CFG_ISA_TXHIGH_MASK) >> LCD2_LCD_SMPN_CTRL_CFG_ISA_TXHIGH_SHIFT)
#define  LCD2_LCD_SMPN_CTRL_CFG_ISA_TXHIGH_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_SMPN_CTRL_CFG_ISA_TXHIGH_MASK) | (((uint32_t)val) << LCD2_LCD_SMPN_CTRL_CFG_ISA_TXHIGH_SHIFT))

#define  LCD2_LCD_SMPN_CTRL_CFG_SMPNVSYNC_MASK 0xc000
#define  LCD2_LCD_SMPN_CTRL_CFG_SMPNVSYNC_SHIFT 14
#define  LCD2_LCD_SMPN_CTRL_CFG_SMPNVSYNC_MASK_SHIFT(reg) (((reg) & LCD2_LCD_SMPN_CTRL_CFG_SMPNVSYNC_MASK) >> LCD2_LCD_SMPN_CTRL_CFG_SMPNVSYNC_SHIFT)
#define  LCD2_LCD_SMPN_CTRL_CFG_SMPNVSYNC_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_SMPN_CTRL_CFG_SMPNVSYNC_MASK) | (((uint32_t)val) << LCD2_LCD_SMPN_CTRL_CFG_SMPNVSYNC_SHIFT))

#define  LCD2_LCD_SMPN_CTRL_RESERVED1_MASK 0x2000
#define  LCD2_LCD_SMPN_CTRL_RESERVED1_SHIFT 13
#define  LCD2_LCD_SMPN_CTRL_RESERVED1_MASK_SHIFT(reg) (((reg) & LCD2_LCD_SMPN_CTRL_RESERVED1_MASK) >> LCD2_LCD_SMPN_CTRL_RESERVED1_SHIFT)
#define  LCD2_LCD_SMPN_CTRL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_SMPN_CTRL_RESERVED1_MASK) | (((uint32_t)val) << LCD2_LCD_SMPN_CTRL_RESERVED1_SHIFT))

#define  LCD2_LCD_SMPN_CTRL_CFG_SLV_ONLY_MASK 0x1000
#define  LCD2_LCD_SMPN_CTRL_CFG_SLV_ONLY_SHIFT 12
#define  LCD2_LCD_SMPN_CTRL_CFG_SLV_ONLY_MASK_SHIFT(reg) (((reg) & LCD2_LCD_SMPN_CTRL_CFG_SLV_ONLY_MASK) >> LCD2_LCD_SMPN_CTRL_CFG_SLV_ONLY_SHIFT)
#define  LCD2_LCD_SMPN_CTRL_CFG_SLV_ONLY_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_SMPN_CTRL_CFG_SLV_ONLY_MASK) | (((uint32_t)val) << LCD2_LCD_SMPN_CTRL_CFG_SLV_ONLY_SHIFT))

#define  LCD2_LCD_SMPN_CTRL_CFG_SMPNMODE_MASK 0xf00
#define  LCD2_LCD_SMPN_CTRL_CFG_SMPNMODE_SHIFT 8
#define  LCD2_LCD_SMPN_CTRL_CFG_SMPNMODE_MASK_SHIFT(reg) (((reg) & LCD2_LCD_SMPN_CTRL_CFG_SMPNMODE_MASK) >> LCD2_LCD_SMPN_CTRL_CFG_SMPNMODE_SHIFT)
#define  LCD2_LCD_SMPN_CTRL_CFG_SMPNMODE_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_SMPN_CTRL_CFG_SMPNMODE_MASK) | (((uint32_t)val) << LCD2_LCD_SMPN_CTRL_CFG_SMPNMODE_SHIFT))

#define  LCD2_LCD_SMPN_CTRL_CFG_CMD32OR16B_MASK 0x80
#define  LCD2_LCD_SMPN_CTRL_CFG_CMD32OR16B_SHIFT 7
#define  LCD2_LCD_SMPN_CTRL_CFG_CMD32OR16B_MASK_SHIFT(reg) (((reg) & LCD2_LCD_SMPN_CTRL_CFG_CMD32OR16B_MASK) >> LCD2_LCD_SMPN_CTRL_CFG_CMD32OR16B_SHIFT)
#define  LCD2_LCD_SMPN_CTRL_CFG_CMD32OR16B_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_SMPN_CTRL_CFG_CMD32OR16B_MASK) | (((uint32_t)val) << LCD2_LCD_SMPN_CTRL_CFG_CMD32OR16B_SHIFT))

#define  LCD2_LCD_SMPN_CTRL_CFG_SWAPBYTES_MASK 0x40
#define  LCD2_LCD_SMPN_CTRL_CFG_SWAPBYTES_SHIFT 6
#define  LCD2_LCD_SMPN_CTRL_CFG_SWAPBYTES_MASK_SHIFT(reg) (((reg) & LCD2_LCD_SMPN_CTRL_CFG_SWAPBYTES_MASK) >> LCD2_LCD_SMPN_CTRL_CFG_SWAPBYTES_SHIFT)
#define  LCD2_LCD_SMPN_CTRL_CFG_SWAPBYTES_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_SMPN_CTRL_CFG_SWAPBYTES_MASK) | (((uint32_t)val) << LCD2_LCD_SMPN_CTRL_CFG_SWAPBYTES_SHIFT))

#define  LCD2_LCD_SMPN_CTRL_SMPN_SEL_MASK 0x20
#define  LCD2_LCD_SMPN_CTRL_SMPN_SEL_SHIFT 5
#define  LCD2_LCD_SMPN_CTRL_SMPN_SEL_MASK_SHIFT(reg) (((reg) & LCD2_LCD_SMPN_CTRL_SMPN_SEL_MASK) >> LCD2_LCD_SMPN_CTRL_SMPN_SEL_SHIFT)
#define  LCD2_LCD_SMPN_CTRL_SMPN_SEL_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_SMPN_CTRL_SMPN_SEL_MASK) | (((uint32_t)val) << LCD2_LCD_SMPN_CTRL_SMPN_SEL_SHIFT))

#define  LCD2_LCD_SMPN_CTRL_CFG_SLV_ENA_MASK 0x10
#define  LCD2_LCD_SMPN_CTRL_CFG_SLV_ENA_SHIFT 4
#define  LCD2_LCD_SMPN_CTRL_CFG_SLV_ENA_MASK_SHIFT(reg) (((reg) & LCD2_LCD_SMPN_CTRL_CFG_SLV_ENA_MASK) >> LCD2_LCD_SMPN_CTRL_CFG_SLV_ENA_SHIFT)
#define  LCD2_LCD_SMPN_CTRL_CFG_SLV_ENA_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_SMPN_CTRL_CFG_SLV_ENA_MASK) | (((uint32_t)val) << LCD2_LCD_SMPN_CTRL_CFG_SLV_ENA_SHIFT))

#define  LCD2_LCD_SMPN_CTRL_SMPN_RSTB_MASK 0x8
#define  LCD2_LCD_SMPN_CTRL_SMPN_RSTB_SHIFT 3
#define  LCD2_LCD_SMPN_CTRL_SMPN_RSTB_MASK_SHIFT(reg) (((reg) & LCD2_LCD_SMPN_CTRL_SMPN_RSTB_MASK) >> LCD2_LCD_SMPN_CTRL_SMPN_RSTB_SHIFT)
#define  LCD2_LCD_SMPN_CTRL_SMPN_RSTB_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_SMPN_CTRL_SMPN_RSTB_MASK) | (((uint32_t)val) << LCD2_LCD_SMPN_CTRL_SMPN_RSTB_SHIFT))

#define  LCD2_LCD_SMPN_CTRL_CFG_68S80SB_MASK 0x4
#define  LCD2_LCD_SMPN_CTRL_CFG_68S80SB_SHIFT 2
#define  LCD2_LCD_SMPN_CTRL_CFG_68S80SB_MASK_SHIFT(reg) (((reg) & LCD2_LCD_SMPN_CTRL_CFG_68S80SB_MASK) >> LCD2_LCD_SMPN_CTRL_CFG_68S80SB_SHIFT)
#define  LCD2_LCD_SMPN_CTRL_CFG_68S80SB_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_SMPN_CTRL_CFG_68S80SB_MASK) | (((uint32_t)val) << LCD2_LCD_SMPN_CTRL_CFG_68S80SB_SHIFT))

#define  LCD2_LCD_SMPN_CTRL_CFG_KEEPXFER_MASK 0x2
#define  LCD2_LCD_SMPN_CTRL_CFG_KEEPXFER_SHIFT 1
#define  LCD2_LCD_SMPN_CTRL_CFG_KEEPXFER_MASK_SHIFT(reg) (((reg) & LCD2_LCD_SMPN_CTRL_CFG_KEEPXFER_MASK) >> LCD2_LCD_SMPN_CTRL_CFG_KEEPXFER_SHIFT)
#define  LCD2_LCD_SMPN_CTRL_CFG_KEEPXFER_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_SMPN_CTRL_CFG_KEEPXFER_MASK) | (((uint32_t)val) << LCD2_LCD_SMPN_CTRL_CFG_KEEPXFER_SHIFT))

#define  LCD2_LCD_SMPN_CTRL_CFG_SMPN_ENA_MASK 0x1
#define  LCD2_LCD_SMPN_CTRL_CFG_SMPN_ENA_SHIFT 0
#define  LCD2_LCD_SMPN_CTRL_CFG_SMPN_ENA_MASK_SHIFT(reg) (((reg) & LCD2_LCD_SMPN_CTRL_CFG_SMPN_ENA_MASK) >> LCD2_LCD_SMPN_CTRL_CFG_SMPN_ENA_SHIFT)
#define  LCD2_LCD_SMPN_CTRL_CFG_SMPN_ENA_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_SMPN_CTRL_CFG_SMPN_ENA_MASK) | (((uint32_t)val) << LCD2_LCD_SMPN_CTRL_CFG_SMPN_ENA_SHIFT))

//====================================================================
//Register: AHB Slave Path Data Port Register (LCD_SLV_PORT)
//====================================================================

#define  LCD2_LCD_SLV_PORT_SLV_COMMAND1_A0_MASK 0x80000000
#define  LCD2_LCD_SLV_PORT_SLV_COMMAND1_A0_SHIFT 31
#define  LCD2_LCD_SLV_PORT_SLV_COMMAND1_A0_MASK_SHIFT(reg) (((reg) & LCD2_LCD_SLV_PORT_SLV_COMMAND1_A0_MASK) >> LCD2_LCD_SLV_PORT_SLV_COMMAND1_A0_SHIFT)
#define  LCD2_LCD_SLV_PORT_SLV_COMMAND1_A0_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_SLV_PORT_SLV_COMMAND1_A0_MASK) | (((uint32_t)val) << LCD2_LCD_SLV_PORT_SLV_COMMAND1_A0_SHIFT))

#define  LCD2_LCD_SLV_PORT_RESERVED1_MASK 0x7c000000
#define  LCD2_LCD_SLV_PORT_RESERVED1_SHIFT 26
#define  LCD2_LCD_SLV_PORT_RESERVED1_MASK_SHIFT(reg) (((reg) & LCD2_LCD_SLV_PORT_RESERVED1_MASK) >> LCD2_LCD_SLV_PORT_RESERVED1_SHIFT)
#define  LCD2_LCD_SLV_PORT_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_SLV_PORT_RESERVED1_MASK) | (((uint32_t)val) << LCD2_LCD_SLV_PORT_RESERVED1_SHIFT))

#define  LCD2_LCD_SLV_PORT_SLV_COMMAND1_READ_MASK 0x2000000
#define  LCD2_LCD_SLV_PORT_SLV_COMMAND1_READ_SHIFT 25
#define  LCD2_LCD_SLV_PORT_SLV_COMMAND1_READ_MASK_SHIFT(reg) (((reg) & LCD2_LCD_SLV_PORT_SLV_COMMAND1_READ_MASK) >> LCD2_LCD_SLV_PORT_SLV_COMMAND1_READ_SHIFT)
#define  LCD2_LCD_SLV_PORT_SLV_COMMAND1_READ_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_SLV_PORT_SLV_COMMAND1_READ_MASK) | (((uint32_t)val) << LCD2_LCD_SLV_PORT_SLV_COMMAND1_READ_SHIFT))

#define  LCD2_LCD_SLV_PORT_SLV_COMMAND1_WRITE_MASK 0x1000000
#define  LCD2_LCD_SLV_PORT_SLV_COMMAND1_WRITE_SHIFT 24
#define  LCD2_LCD_SLV_PORT_SLV_COMMAND1_WRITE_MASK_SHIFT(reg) (((reg) & LCD2_LCD_SLV_PORT_SLV_COMMAND1_WRITE_MASK) >> LCD2_LCD_SLV_PORT_SLV_COMMAND1_WRITE_SHIFT)
#define  LCD2_LCD_SLV_PORT_SLV_COMMAND1_WRITE_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_SLV_PORT_SLV_COMMAND1_WRITE_MASK) | (((uint32_t)val) << LCD2_LCD_SLV_PORT_SLV_COMMAND1_WRITE_SHIFT))

#define  LCD2_LCD_SLV_PORT_SLV_COMMAND1_DATA_MASK 0xff0000
#define  LCD2_LCD_SLV_PORT_SLV_COMMAND1_DATA_SHIFT 16
#define  LCD2_LCD_SLV_PORT_SLV_COMMAND1_DATA_MASK_SHIFT(reg) (((reg) & LCD2_LCD_SLV_PORT_SLV_COMMAND1_DATA_MASK) >> LCD2_LCD_SLV_PORT_SLV_COMMAND1_DATA_SHIFT)
#define  LCD2_LCD_SLV_PORT_SLV_COMMAND1_DATA_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_SLV_PORT_SLV_COMMAND1_DATA_MASK) | (((uint32_t)val) << LCD2_LCD_SLV_PORT_SLV_COMMAND1_DATA_SHIFT))

#define  LCD2_LCD_SLV_PORT_SVL_COMMAND0_A0_MASK 0x8000
#define  LCD2_LCD_SLV_PORT_SVL_COMMAND0_A0_SHIFT 15
#define  LCD2_LCD_SLV_PORT_SVL_COMMAND0_A0_MASK_SHIFT(reg) (((reg) & LCD2_LCD_SLV_PORT_SVL_COMMAND0_A0_MASK) >> LCD2_LCD_SLV_PORT_SVL_COMMAND0_A0_SHIFT)
#define  LCD2_LCD_SLV_PORT_SVL_COMMAND0_A0_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_SLV_PORT_SVL_COMMAND0_A0_MASK) | (((uint32_t)val) << LCD2_LCD_SLV_PORT_SVL_COMMAND0_A0_SHIFT))

#define  LCD2_LCD_SLV_PORT_CMD32_FMT_DATA_MASK 0x7c00
#define  LCD2_LCD_SLV_PORT_CMD32_FMT_DATA_SHIFT 10
#define  LCD2_LCD_SLV_PORT_CMD32_FMT_DATA_MASK_SHIFT(reg) (((reg) & LCD2_LCD_SLV_PORT_CMD32_FMT_DATA_MASK) >> LCD2_LCD_SLV_PORT_CMD32_FMT_DATA_SHIFT)
#define  LCD2_LCD_SLV_PORT_CMD32_FMT_DATA_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_SLV_PORT_CMD32_FMT_DATA_MASK) | (((uint32_t)val) << LCD2_LCD_SLV_PORT_CMD32_FMT_DATA_SHIFT))

#define  LCD2_LCD_SLV_PORT_SLV_COMMAND0_READ_MASK 0x200
#define  LCD2_LCD_SLV_PORT_SLV_COMMAND0_READ_SHIFT 9
#define  LCD2_LCD_SLV_PORT_SLV_COMMAND0_READ_MASK_SHIFT(reg) (((reg) & LCD2_LCD_SLV_PORT_SLV_COMMAND0_READ_MASK) >> LCD2_LCD_SLV_PORT_SLV_COMMAND0_READ_SHIFT)
#define  LCD2_LCD_SLV_PORT_SLV_COMMAND0_READ_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_SLV_PORT_SLV_COMMAND0_READ_MASK) | (((uint32_t)val) << LCD2_LCD_SLV_PORT_SLV_COMMAND0_READ_SHIFT))

#define  LCD2_LCD_SLV_PORT_SLV_COMMAND0_WRITE_MASK 0x100
#define  LCD2_LCD_SLV_PORT_SLV_COMMAND0_WRITE_SHIFT 8
#define  LCD2_LCD_SLV_PORT_SLV_COMMAND0_WRITE_MASK_SHIFT(reg) (((reg) & LCD2_LCD_SLV_PORT_SLV_COMMAND0_WRITE_MASK) >> LCD2_LCD_SLV_PORT_SLV_COMMAND0_WRITE_SHIFT)
#define  LCD2_LCD_SLV_PORT_SLV_COMMAND0_WRITE_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_SLV_PORT_SLV_COMMAND0_WRITE_MASK) | (((uint32_t)val) << LCD2_LCD_SLV_PORT_SLV_COMMAND0_WRITE_SHIFT))

#define  LCD2_LCD_SLV_PORT_SLVD_COMMAND0_DATA_MASK 0xff
#define  LCD2_LCD_SLV_PORT_SLVD_COMMAND0_DATA_SHIFT 0
#define  LCD2_LCD_SLV_PORT_SLVD_COMMAND0_DATA_MASK_SHIFT(reg) (((reg) & LCD2_LCD_SLV_PORT_SLVD_COMMAND0_DATA_MASK) >> LCD2_LCD_SLV_PORT_SLVD_COMMAND0_DATA_SHIFT)
#define  LCD2_LCD_SLV_PORT_SLVD_COMMAND0_DATA_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_SLV_PORT_SLVD_COMMAND0_DATA_MASK) | (((uint32_t)val) << LCD2_LCD_SLV_PORT_SLVD_COMMAND0_DATA_SHIFT))

//====================================================================
//Register: Panel Path DMA Control 0 Register (LCD_PN_CTRL0)
//====================================================================

#define  LCD2_LCD_PN_CTRL0_CFG_PN_NOBLENDING_MASK 0x80000000
#define  LCD2_LCD_PN_CTRL0_CFG_PN_NOBLENDING_SHIFT 31
#define  LCD2_LCD_PN_CTRL0_CFG_PN_NOBLENDING_MASK_SHIFT(reg) (((reg) & LCD2_LCD_PN_CTRL0_CFG_PN_NOBLENDING_MASK) >> LCD2_LCD_PN_CTRL0_CFG_PN_NOBLENDING_SHIFT)
#define  LCD2_LCD_PN_CTRL0_CFG_PN_NOBLENDING_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_PN_CTRL0_CFG_PN_NOBLENDING_MASK) | (((uint32_t)val) << LCD2_LCD_PN_CTRL0_CFG_PN_NOBLENDING_SHIFT))

#define  LCD2_LCD_PN_CTRL0_CFG_PN_GAMMA_ENA_MASK 0x40000000
#define  LCD2_LCD_PN_CTRL0_CFG_PN_GAMMA_ENA_SHIFT 30
#define  LCD2_LCD_PN_CTRL0_CFG_PN_GAMMA_ENA_MASK_SHIFT(reg) (((reg) & LCD2_LCD_PN_CTRL0_CFG_PN_GAMMA_ENA_MASK) >> LCD2_LCD_PN_CTRL0_CFG_PN_GAMMA_ENA_SHIFT)
#define  LCD2_LCD_PN_CTRL0_CFG_PN_GAMMA_ENA_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_PN_CTRL0_CFG_PN_GAMMA_ENA_MASK) | (((uint32_t)val) << LCD2_LCD_PN_CTRL0_CFG_PN_GAMMA_ENA_SHIFT))

#define  LCD2_LCD_PN_CTRL0_CFG_PN_CBSH_ENA_MASK 0x20000000
#define  LCD2_LCD_PN_CTRL0_CFG_PN_CBSH_ENA_SHIFT 29
#define  LCD2_LCD_PN_CTRL0_CFG_PN_CBSH_ENA_MASK_SHIFT(reg) (((reg) & LCD2_LCD_PN_CTRL0_CFG_PN_CBSH_ENA_MASK) >> LCD2_LCD_PN_CTRL0_CFG_PN_CBSH_ENA_SHIFT)
#define  LCD2_LCD_PN_CTRL0_CFG_PN_CBSH_ENA_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_PN_CTRL0_CFG_PN_CBSH_ENA_MASK) | (((uint32_t)val) << LCD2_LCD_PN_CTRL0_CFG_PN_CBSH_ENA_SHIFT))

#define  LCD2_LCD_PN_CTRL0_CFG_PN_PALETTE_ENA_MASK 0x10000000
#define  LCD2_LCD_PN_CTRL0_CFG_PN_PALETTE_ENA_SHIFT 28
#define  LCD2_LCD_PN_CTRL0_CFG_PN_PALETTE_ENA_MASK_SHIFT(reg) (((reg) & LCD2_LCD_PN_CTRL0_CFG_PN_PALETTE_ENA_MASK) >> LCD2_LCD_PN_CTRL0_CFG_PN_PALETTE_ENA_SHIFT)
#define  LCD2_LCD_PN_CTRL0_CFG_PN_PALETTE_ENA_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_PN_CTRL0_CFG_PN_PALETTE_ENA_MASK) | (((uint32_t)val) << LCD2_LCD_PN_CTRL0_CFG_PN_PALETTE_ENA_SHIFT))

#define  LCD2_LCD_PN_CTRL0_CFG_ARBFAST_ENA_MASK 0x8000000
#define  LCD2_LCD_PN_CTRL0_CFG_ARBFAST_ENA_SHIFT 27
#define  LCD2_LCD_PN_CTRL0_CFG_ARBFAST_ENA_MASK_SHIFT(reg) (((reg) & LCD2_LCD_PN_CTRL0_CFG_ARBFAST_ENA_MASK) >> LCD2_LCD_PN_CTRL0_CFG_ARBFAST_ENA_SHIFT)
#define  LCD2_LCD_PN_CTRL0_CFG_ARBFAST_ENA_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_PN_CTRL0_CFG_ARBFAST_ENA_MASK) | (((uint32_t)val) << LCD2_LCD_PN_CTRL0_CFG_ARBFAST_ENA_SHIFT))

#define  LCD2_LCD_PN_CTRL0_RESERVED1_MASK 0x4000000
#define  LCD2_LCD_PN_CTRL0_RESERVED1_SHIFT 26
#define  LCD2_LCD_PN_CTRL0_RESERVED1_MASK_SHIFT(reg) (((reg) & LCD2_LCD_PN_CTRL0_RESERVED1_MASK) >> LCD2_LCD_PN_CTRL0_RESERVED1_SHIFT)
#define  LCD2_LCD_PN_CTRL0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_PN_CTRL0_RESERVED1_MASK) | (((uint32_t)val) << LCD2_LCD_PN_CTRL0_RESERVED1_SHIFT))

#define  LCD2_LCD_PN_CTRL0_RESERVED2_MASK 0x2000000
#define  LCD2_LCD_PN_CTRL0_RESERVED2_SHIFT 25
#define  LCD2_LCD_PN_CTRL0_RESERVED2_MASK_SHIFT(reg) (((reg) & LCD2_LCD_PN_CTRL0_RESERVED2_MASK) >> LCD2_LCD_PN_CTRL0_RESERVED2_SHIFT)
#define  LCD2_LCD_PN_CTRL0_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_PN_CTRL0_RESERVED2_MASK) | (((uint32_t)val) << LCD2_LCD_PN_CTRL0_RESERVED2_SHIFT))

#define  LCD2_LCD_PN_CTRL0_RESERVED3_MASK 0x1000000
#define  LCD2_LCD_PN_CTRL0_RESERVED3_SHIFT 24
#define  LCD2_LCD_PN_CTRL0_RESERVED3_MASK_SHIFT(reg) (((reg) & LCD2_LCD_PN_CTRL0_RESERVED3_MASK) >> LCD2_LCD_PN_CTRL0_RESERVED3_SHIFT)
#define  LCD2_LCD_PN_CTRL0_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_PN_CTRL0_RESERVED3_MASK) | (((uint32_t)val) << LCD2_LCD_PN_CTRL0_RESERVED3_SHIFT))

#define  LCD2_LCD_PN_CTRL0_CFG_DMAFORMAT_MASK 0xf00000
#define  LCD2_LCD_PN_CTRL0_CFG_DMAFORMAT_SHIFT 20
#define  LCD2_LCD_PN_CTRL0_CFG_DMAFORMAT_MASK_SHIFT(reg) (((reg) & LCD2_LCD_PN_CTRL0_CFG_DMAFORMAT_MASK) >> LCD2_LCD_PN_CTRL0_CFG_DMAFORMAT_SHIFT)
#define  LCD2_LCD_PN_CTRL0_CFG_DMAFORMAT_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_PN_CTRL0_CFG_DMAFORMAT_MASK) | (((uint32_t)val) << LCD2_LCD_PN_CTRL0_CFG_DMAFORMAT_SHIFT))

#define  LCD2_LCD_PN_CTRL0_CFG_GRAFORMAT_MASK 0xf0000
#define  LCD2_LCD_PN_CTRL0_CFG_GRAFORMAT_SHIFT 16
#define  LCD2_LCD_PN_CTRL0_CFG_GRAFORMAT_MASK_SHIFT(reg) (((reg) & LCD2_LCD_PN_CTRL0_CFG_GRAFORMAT_MASK) >> LCD2_LCD_PN_CTRL0_CFG_GRAFORMAT_SHIFT)
#define  LCD2_LCD_PN_CTRL0_CFG_GRAFORMAT_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_PN_CTRL0_CFG_GRAFORMAT_MASK) | (((uint32_t)val) << LCD2_LCD_PN_CTRL0_CFG_GRAFORMAT_SHIFT))

#define  LCD2_LCD_PN_CTRL0_CFG_GRA_FTOGGLE_MASK 0x8000
#define  LCD2_LCD_PN_CTRL0_CFG_GRA_FTOGGLE_SHIFT 15
#define  LCD2_LCD_PN_CTRL0_CFG_GRA_FTOGGLE_MASK_SHIFT(reg) (((reg) & LCD2_LCD_PN_CTRL0_CFG_GRA_FTOGGLE_MASK) >> LCD2_LCD_PN_CTRL0_CFG_GRA_FTOGGLE_SHIFT)
#define  LCD2_LCD_PN_CTRL0_CFG_GRA_FTOGGLE_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_PN_CTRL0_CFG_GRA_FTOGGLE_MASK) | (((uint32_t)val) << LCD2_LCD_PN_CTRL0_CFG_GRA_FTOGGLE_SHIFT))

#define  LCD2_LCD_PN_CTRL0_CFG_GRA_HSMOOTH_MASK 0x4000
#define  LCD2_LCD_PN_CTRL0_CFG_GRA_HSMOOTH_SHIFT 14
#define  LCD2_LCD_PN_CTRL0_CFG_GRA_HSMOOTH_MASK_SHIFT(reg) (((reg) & LCD2_LCD_PN_CTRL0_CFG_GRA_HSMOOTH_MASK) >> LCD2_LCD_PN_CTRL0_CFG_GRA_HSMOOTH_SHIFT)
#define  LCD2_LCD_PN_CTRL0_CFG_GRA_HSMOOTH_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_PN_CTRL0_CFG_GRA_HSMOOTH_MASK) | (((uint32_t)val) << LCD2_LCD_PN_CTRL0_CFG_GRA_HSMOOTH_SHIFT))

#define  LCD2_LCD_PN_CTRL0_CFG_GRA_TSTMODE_MASK 0x2000
#define  LCD2_LCD_PN_CTRL0_CFG_GRA_TSTMODE_SHIFT 13
#define  LCD2_LCD_PN_CTRL0_CFG_GRA_TSTMODE_MASK_SHIFT(reg) (((reg) & LCD2_LCD_PN_CTRL0_CFG_GRA_TSTMODE_MASK) >> LCD2_LCD_PN_CTRL0_CFG_GRA_TSTMODE_SHIFT)
#define  LCD2_LCD_PN_CTRL0_CFG_GRA_TSTMODE_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_PN_CTRL0_CFG_GRA_TSTMODE_MASK) | (((uint32_t)val) << LCD2_LCD_PN_CTRL0_CFG_GRA_TSTMODE_SHIFT))

#define  LCD2_LCD_PN_CTRL0_CFG_GRA_SWAP_RB_MASK 0x1000
#define  LCD2_LCD_PN_CTRL0_CFG_GRA_SWAP_RB_SHIFT 12
#define  LCD2_LCD_PN_CTRL0_CFG_GRA_SWAP_RB_MASK_SHIFT(reg) (((reg) & LCD2_LCD_PN_CTRL0_CFG_GRA_SWAP_RB_MASK) >> LCD2_LCD_PN_CTRL0_CFG_GRA_SWAP_RB_SHIFT)
#define  LCD2_LCD_PN_CTRL0_CFG_GRA_SWAP_RB_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_PN_CTRL0_CFG_GRA_SWAP_RB_MASK) | (((uint32_t)val) << LCD2_LCD_PN_CTRL0_CFG_GRA_SWAP_RB_SHIFT))

#define  LCD2_LCD_PN_CTRL0_CFG_GRA_SWAP_UV_MASK 0x800
#define  LCD2_LCD_PN_CTRL0_CFG_GRA_SWAP_UV_SHIFT 11
#define  LCD2_LCD_PN_CTRL0_CFG_GRA_SWAP_UV_MASK_SHIFT(reg) (((reg) & LCD2_LCD_PN_CTRL0_CFG_GRA_SWAP_UV_MASK) >> LCD2_LCD_PN_CTRL0_CFG_GRA_SWAP_UV_SHIFT)
#define  LCD2_LCD_PN_CTRL0_CFG_GRA_SWAP_UV_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_PN_CTRL0_CFG_GRA_SWAP_UV_MASK) | (((uint32_t)val) << LCD2_LCD_PN_CTRL0_CFG_GRA_SWAP_UV_SHIFT))

#define  LCD2_LCD_PN_CTRL0_CFG_GRA_SWAP_YU_MASK 0x400
#define  LCD2_LCD_PN_CTRL0_CFG_GRA_SWAP_YU_SHIFT 10
#define  LCD2_LCD_PN_CTRL0_CFG_GRA_SWAP_YU_MASK_SHIFT(reg) (((reg) & LCD2_LCD_PN_CTRL0_CFG_GRA_SWAP_YU_MASK) >> LCD2_LCD_PN_CTRL0_CFG_GRA_SWAP_YU_SHIFT)
#define  LCD2_LCD_PN_CTRL0_CFG_GRA_SWAP_YU_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_PN_CTRL0_CFG_GRA_SWAP_YU_MASK) | (((uint32_t)val) << LCD2_LCD_PN_CTRL0_CFG_GRA_SWAP_YU_SHIFT))

#define  LCD2_LCD_PN_CTRL0_CFG_YUV2RGB_GRA_MASK 0x200
#define  LCD2_LCD_PN_CTRL0_CFG_YUV2RGB_GRA_SHIFT 9
#define  LCD2_LCD_PN_CTRL0_CFG_YUV2RGB_GRA_MASK_SHIFT(reg) (((reg) & LCD2_LCD_PN_CTRL0_CFG_YUV2RGB_GRA_MASK) >> LCD2_LCD_PN_CTRL0_CFG_YUV2RGB_GRA_SHIFT)
#define  LCD2_LCD_PN_CTRL0_CFG_YUV2RGB_GRA_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_PN_CTRL0_CFG_YUV2RGB_GRA_MASK) | (((uint32_t)val) << LCD2_LCD_PN_CTRL0_CFG_YUV2RGB_GRA_SHIFT))

#define  LCD2_LCD_PN_CTRL0_CFG_GRA_ENA_MASK 0x100
#define  LCD2_LCD_PN_CTRL0_CFG_GRA_ENA_SHIFT 8
#define  LCD2_LCD_PN_CTRL0_CFG_GRA_ENA_MASK_SHIFT(reg) (((reg) & LCD2_LCD_PN_CTRL0_CFG_GRA_ENA_MASK) >> LCD2_LCD_PN_CTRL0_CFG_GRA_ENA_SHIFT)
#define  LCD2_LCD_PN_CTRL0_CFG_GRA_ENA_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_PN_CTRL0_CFG_GRA_ENA_MASK) | (((uint32_t)val) << LCD2_LCD_PN_CTRL0_CFG_GRA_ENA_SHIFT))

#define  LCD2_LCD_PN_CTRL0_CFG_DMA_FTOGGLE_MASK 0x80
#define  LCD2_LCD_PN_CTRL0_CFG_DMA_FTOGGLE_SHIFT 7
#define  LCD2_LCD_PN_CTRL0_CFG_DMA_FTOGGLE_MASK_SHIFT(reg) (((reg) & LCD2_LCD_PN_CTRL0_CFG_DMA_FTOGGLE_MASK) >> LCD2_LCD_PN_CTRL0_CFG_DMA_FTOGGLE_SHIFT)
#define  LCD2_LCD_PN_CTRL0_CFG_DMA_FTOGGLE_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_PN_CTRL0_CFG_DMA_FTOGGLE_MASK) | (((uint32_t)val) << LCD2_LCD_PN_CTRL0_CFG_DMA_FTOGGLE_SHIFT))

#define  LCD2_LCD_PN_CTRL0_CFG_DMA_HSMOOTH_MASK 0x40
#define  LCD2_LCD_PN_CTRL0_CFG_DMA_HSMOOTH_SHIFT 6
#define  LCD2_LCD_PN_CTRL0_CFG_DMA_HSMOOTH_MASK_SHIFT(reg) (((reg) & LCD2_LCD_PN_CTRL0_CFG_DMA_HSMOOTH_MASK) >> LCD2_LCD_PN_CTRL0_CFG_DMA_HSMOOTH_SHIFT)
#define  LCD2_LCD_PN_CTRL0_CFG_DMA_HSMOOTH_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_PN_CTRL0_CFG_DMA_HSMOOTH_MASK) | (((uint32_t)val) << LCD2_LCD_PN_CTRL0_CFG_DMA_HSMOOTH_SHIFT))

#define  LCD2_LCD_PN_CTRL0_CFG_DMA_TSTMODE_MASK 0x20
#define  LCD2_LCD_PN_CTRL0_CFG_DMA_TSTMODE_SHIFT 5
#define  LCD2_LCD_PN_CTRL0_CFG_DMA_TSTMODE_MASK_SHIFT(reg) (((reg) & LCD2_LCD_PN_CTRL0_CFG_DMA_TSTMODE_MASK) >> LCD2_LCD_PN_CTRL0_CFG_DMA_TSTMODE_SHIFT)
#define  LCD2_LCD_PN_CTRL0_CFG_DMA_TSTMODE_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_PN_CTRL0_CFG_DMA_TSTMODE_MASK) | (((uint32_t)val) << LCD2_LCD_PN_CTRL0_CFG_DMA_TSTMODE_SHIFT))

#define  LCD2_LCD_PN_CTRL0_CFG_DMA_SWAP_RB_MASK 0x10
#define  LCD2_LCD_PN_CTRL0_CFG_DMA_SWAP_RB_SHIFT 4
#define  LCD2_LCD_PN_CTRL0_CFG_DMA_SWAP_RB_MASK_SHIFT(reg) (((reg) & LCD2_LCD_PN_CTRL0_CFG_DMA_SWAP_RB_MASK) >> LCD2_LCD_PN_CTRL0_CFG_DMA_SWAP_RB_SHIFT)
#define  LCD2_LCD_PN_CTRL0_CFG_DMA_SWAP_RB_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_PN_CTRL0_CFG_DMA_SWAP_RB_MASK) | (((uint32_t)val) << LCD2_LCD_PN_CTRL0_CFG_DMA_SWAP_RB_SHIFT))

#define  LCD2_LCD_PN_CTRL0_CFG_DMA_SWAP_UV_MASK 0x8
#define  LCD2_LCD_PN_CTRL0_CFG_DMA_SWAP_UV_SHIFT 3
#define  LCD2_LCD_PN_CTRL0_CFG_DMA_SWAP_UV_MASK_SHIFT(reg) (((reg) & LCD2_LCD_PN_CTRL0_CFG_DMA_SWAP_UV_MASK) >> LCD2_LCD_PN_CTRL0_CFG_DMA_SWAP_UV_SHIFT)
#define  LCD2_LCD_PN_CTRL0_CFG_DMA_SWAP_UV_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_PN_CTRL0_CFG_DMA_SWAP_UV_MASK) | (((uint32_t)val) << LCD2_LCD_PN_CTRL0_CFG_DMA_SWAP_UV_SHIFT))

#define  LCD2_LCD_PN_CTRL0_CFG_DMA_SWAP_YU_MASK 0x4
#define  LCD2_LCD_PN_CTRL0_CFG_DMA_SWAP_YU_SHIFT 2
#define  LCD2_LCD_PN_CTRL0_CFG_DMA_SWAP_YU_MASK_SHIFT(reg) (((reg) & LCD2_LCD_PN_CTRL0_CFG_DMA_SWAP_YU_MASK) >> LCD2_LCD_PN_CTRL0_CFG_DMA_SWAP_YU_SHIFT)
#define  LCD2_LCD_PN_CTRL0_CFG_DMA_SWAP_YU_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_PN_CTRL0_CFG_DMA_SWAP_YU_MASK) | (((uint32_t)val) << LCD2_LCD_PN_CTRL0_CFG_DMA_SWAP_YU_SHIFT))

#define  LCD2_LCD_PN_CTRL0_CFG_YUV2RGB_DMA_MASK 0x2
#define  LCD2_LCD_PN_CTRL0_CFG_YUV2RGB_DMA_SHIFT 1
#define  LCD2_LCD_PN_CTRL0_CFG_YUV2RGB_DMA_MASK_SHIFT(reg) (((reg) & LCD2_LCD_PN_CTRL0_CFG_YUV2RGB_DMA_MASK) >> LCD2_LCD_PN_CTRL0_CFG_YUV2RGB_DMA_SHIFT)
#define  LCD2_LCD_PN_CTRL0_CFG_YUV2RGB_DMA_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_PN_CTRL0_CFG_YUV2RGB_DMA_MASK) | (((uint32_t)val) << LCD2_LCD_PN_CTRL0_CFG_YUV2RGB_DMA_SHIFT))

#define  LCD2_LCD_PN_CTRL0_CFG_DMA_ENA_MASK 0x1
#define  LCD2_LCD_PN_CTRL0_CFG_DMA_ENA_SHIFT 0
#define  LCD2_LCD_PN_CTRL0_CFG_DMA_ENA_MASK_SHIFT(reg) (((reg) & LCD2_LCD_PN_CTRL0_CFG_DMA_ENA_MASK) >> LCD2_LCD_PN_CTRL0_CFG_DMA_ENA_SHIFT)
#define  LCD2_LCD_PN_CTRL0_CFG_DMA_ENA_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_PN_CTRL0_CFG_DMA_ENA_MASK) | (((uint32_t)val) << LCD2_LCD_PN_CTRL0_CFG_DMA_ENA_SHIFT))

//====================================================================
//Register: Panel Path DMA Control 1 Register (LCD_PN_CTRL1)
//====================================================================

#define  LCD2_LCD_PN_CTRL1_CFG_FRAME_TRIG_MASK 0x80000000
#define  LCD2_LCD_PN_CTRL1_CFG_FRAME_TRIG_SHIFT 31
#define  LCD2_LCD_PN_CTRL1_CFG_FRAME_TRIG_MASK_SHIFT(reg) (((reg) & LCD2_LCD_PN_CTRL1_CFG_FRAME_TRIG_MASK) >> LCD2_LCD_PN_CTRL1_CFG_FRAME_TRIG_SHIFT)
#define  LCD2_LCD_PN_CTRL1_CFG_FRAME_TRIG_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_PN_CTRL1_CFG_FRAME_TRIG_MASK) | (((uint32_t)val) << LCD2_LCD_PN_CTRL1_CFG_FRAME_TRIG_SHIFT))

#define  LCD2_LCD_PN_CTRL1_CFG_PN_VSYNC_MODE_MASK 0x70000000
#define  LCD2_LCD_PN_CTRL1_CFG_PN_VSYNC_MODE_SHIFT 28
#define  LCD2_LCD_PN_CTRL1_CFG_PN_VSYNC_MODE_MASK_SHIFT(reg) (((reg) & LCD2_LCD_PN_CTRL1_CFG_PN_VSYNC_MODE_MASK) >> LCD2_LCD_PN_CTRL1_CFG_PN_VSYNC_MODE_SHIFT)
#define  LCD2_LCD_PN_CTRL1_CFG_PN_VSYNC_MODE_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_PN_CTRL1_CFG_PN_VSYNC_MODE_MASK) | (((uint32_t)val) << LCD2_LCD_PN_CTRL1_CFG_PN_VSYNC_MODE_SHIFT))

#define  LCD2_LCD_PN_CTRL1_CFG_PN_VSYNC_INV_MASK 0x8000000
#define  LCD2_LCD_PN_CTRL1_CFG_PN_VSYNC_INV_SHIFT 27
#define  LCD2_LCD_PN_CTRL1_CFG_PN_VSYNC_INV_MASK_SHIFT(reg) (((reg) & LCD2_LCD_PN_CTRL1_CFG_PN_VSYNC_INV_MASK) >> LCD2_LCD_PN_CTRL1_CFG_PN_VSYNC_INV_SHIFT)
#define  LCD2_LCD_PN_CTRL1_CFG_PN_VSYNC_INV_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_PN_CTRL1_CFG_PN_VSYNC_INV_MASK) | (((uint32_t)val) << LCD2_LCD_PN_CTRL1_CFG_PN_VSYNC_INV_SHIFT))

#define  LCD2_LCD_PN_CTRL1_COLOR_PN_KEY_MODE_MASK 0x7000000
#define  LCD2_LCD_PN_CTRL1_COLOR_PN_KEY_MODE_SHIFT 24
#define  LCD2_LCD_PN_CTRL1_COLOR_PN_KEY_MODE_MASK_SHIFT(reg) (((reg) & LCD2_LCD_PN_CTRL1_COLOR_PN_KEY_MODE_MASK) >> LCD2_LCD_PN_CTRL1_COLOR_PN_KEY_MODE_SHIFT)
#define  LCD2_LCD_PN_CTRL1_COLOR_PN_KEY_MODE_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_PN_CTRL1_COLOR_PN_KEY_MODE_MASK) | (((uint32_t)val) << LCD2_LCD_PN_CTRL1_COLOR_PN_KEY_MODE_SHIFT))

#define  LCD2_LCD_PN_CTRL1_CFG_PN_CARRY_MASK 0x800000
#define  LCD2_LCD_PN_CTRL1_CFG_PN_CARRY_SHIFT 23
#define  LCD2_LCD_PN_CTRL1_CFG_PN_CARRY_MASK_SHIFT(reg) (((reg) & LCD2_LCD_PN_CTRL1_CFG_PN_CARRY_MASK) >> LCD2_LCD_PN_CTRL1_CFG_PN_CARRY_SHIFT)
#define  LCD2_LCD_PN_CTRL1_CFG_PN_CARRY_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_PN_CTRL1_CFG_PN_CARRY_MASK) | (((uint32_t)val) << LCD2_LCD_PN_CTRL1_CFG_PN_CARRY_SHIFT))

#define  LCD2_LCD_PN_CTRL1_RESERVED1_MASK 0x400000
#define  LCD2_LCD_PN_CTRL1_RESERVED1_SHIFT 22
#define  LCD2_LCD_PN_CTRL1_RESERVED1_MASK_SHIFT(reg) (((reg) & LCD2_LCD_PN_CTRL1_RESERVED1_MASK) >> LCD2_LCD_PN_CTRL1_RESERVED1_SHIFT)
#define  LCD2_LCD_PN_CTRL1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_PN_CTRL1_RESERVED1_MASK) | (((uint32_t)val) << LCD2_LCD_PN_CTRL1_RESERVED1_SHIFT))

#define  LCD2_LCD_PN_CTRL1_RESERVED2_MASK 0x200000
#define  LCD2_LCD_PN_CTRL1_RESERVED2_SHIFT 21
#define  LCD2_LCD_PN_CTRL1_RESERVED2_MASK_SHIFT(reg) (((reg) & LCD2_LCD_PN_CTRL1_RESERVED2_MASK) >> LCD2_LCD_PN_CTRL1_RESERVED2_SHIFT)
#define  LCD2_LCD_PN_CTRL1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_PN_CTRL1_RESERVED2_MASK) | (((uint32_t)val) << LCD2_LCD_PN_CTRL1_RESERVED2_SHIFT))

#define  LCD2_LCD_PN_CTRL1_RESERVED3_MASK 0x100000
#define  LCD2_LCD_PN_CTRL1_RESERVED3_SHIFT 20
#define  LCD2_LCD_PN_CTRL1_RESERVED3_MASK_SHIFT(reg) (((reg) & LCD2_LCD_PN_CTRL1_RESERVED3_MASK) >> LCD2_LCD_PN_CTRL1_RESERVED3_SHIFT)
#define  LCD2_LCD_PN_CTRL1_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_PN_CTRL1_RESERVED3_MASK) | (((uint32_t)val) << LCD2_LCD_PN_CTRL1_RESERVED3_SHIFT))

#define  LCD2_LCD_PN_CTRL1_CFG_DSCALE_MASK 0xc0000
#define  LCD2_LCD_PN_CTRL1_CFG_DSCALE_SHIFT 18
#define  LCD2_LCD_PN_CTRL1_CFG_DSCALE_MASK_SHIFT(reg) (((reg) & LCD2_LCD_PN_CTRL1_CFG_DSCALE_MASK) >> LCD2_LCD_PN_CTRL1_CFG_DSCALE_SHIFT)
#define  LCD2_LCD_PN_CTRL1_CFG_DSCALE_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_PN_CTRL1_CFG_DSCALE_MASK) | (((uint32_t)val) << LCD2_LCD_PN_CTRL1_CFG_DSCALE_SHIFT))

#define  LCD2_LCD_PN_CTRL1_CFG_PN_ALPHA_MODE_MASK 0x30000
#define  LCD2_LCD_PN_CTRL1_CFG_PN_ALPHA_MODE_SHIFT 16
#define  LCD2_LCD_PN_CTRL1_CFG_PN_ALPHA_MODE_MASK_SHIFT(reg) (((reg) & LCD2_LCD_PN_CTRL1_CFG_PN_ALPHA_MODE_MASK) >> LCD2_LCD_PN_CTRL1_CFG_PN_ALPHA_MODE_SHIFT)
#define  LCD2_LCD_PN_CTRL1_CFG_PN_ALPHA_MODE_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_PN_CTRL1_CFG_PN_ALPHA_MODE_MASK) | (((uint32_t)val) << LCD2_LCD_PN_CTRL1_CFG_PN_ALPHA_MODE_SHIFT))

#define  LCD2_LCD_PN_CTRL1_CFG_PN_ALPHA_MASK 0xff00
#define  LCD2_LCD_PN_CTRL1_CFG_PN_ALPHA_SHIFT 8
#define  LCD2_LCD_PN_CTRL1_CFG_PN_ALPHA_MASK_SHIFT(reg) (((reg) & LCD2_LCD_PN_CTRL1_CFG_PN_ALPHA_MASK) >> LCD2_LCD_PN_CTRL1_CFG_PN_ALPHA_SHIFT)
#define  LCD2_LCD_PN_CTRL1_CFG_PN_ALPHA_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_PN_CTRL1_CFG_PN_ALPHA_MASK) | (((uint32_t)val) << LCD2_LCD_PN_CTRL1_CFG_PN_ALPHA_SHIFT))

#define  LCD2_LCD_PN_CTRL1_CFG_PXLCMD_MASK 0xff
#define  LCD2_LCD_PN_CTRL1_CFG_PXLCMD_SHIFT 0
#define  LCD2_LCD_PN_CTRL1_CFG_PXLCMD_MASK_SHIFT(reg) (((reg) & LCD2_LCD_PN_CTRL1_CFG_PXLCMD_MASK) >> LCD2_LCD_PN_CTRL1_CFG_PXLCMD_SHIFT)
#define  LCD2_LCD_PN_CTRL1_CFG_PXLCMD_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_PN_CTRL1_CFG_PXLCMD_MASK) | (((uint32_t)val) << LCD2_LCD_PN_CTRL1_CFG_PXLCMD_SHIFT))

//====================================================================
//Register: SRAM Control Register (LCD_SRAM_CTRL)
//====================================================================

#define  LCD2_LCD_SRAM_CTRL_RESERVED1_MASK 0xffff0000
#define  LCD2_LCD_SRAM_CTRL_RESERVED1_SHIFT 16
#define  LCD2_LCD_SRAM_CTRL_RESERVED1_MASK_SHIFT(reg) (((reg) & LCD2_LCD_SRAM_CTRL_RESERVED1_MASK) >> LCD2_LCD_SRAM_CTRL_RESERVED1_SHIFT)
#define  LCD2_LCD_SRAM_CTRL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_SRAM_CTRL_RESERVED1_MASK) | (((uint32_t)val) << LCD2_LCD_SRAM_CTRL_RESERVED1_SHIFT))

#define  LCD2_LCD_SRAM_CTRL_SRAM_INIT_WR_RD_MASK 0xc000
#define  LCD2_LCD_SRAM_CTRL_SRAM_INIT_WR_RD_SHIFT 14
#define  LCD2_LCD_SRAM_CTRL_SRAM_INIT_WR_RD_MASK_SHIFT(reg) (((reg) & LCD2_LCD_SRAM_CTRL_SRAM_INIT_WR_RD_MASK) >> LCD2_LCD_SRAM_CTRL_SRAM_INIT_WR_RD_SHIFT)
#define  LCD2_LCD_SRAM_CTRL_SRAM_INIT_WR_RD_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_SRAM_CTRL_SRAM_INIT_WR_RD_MASK) | (((uint32_t)val) << LCD2_LCD_SRAM_CTRL_SRAM_INIT_WR_RD_SHIFT))

#define  LCD2_LCD_SRAM_CTRL_RESERVED2_MASK 0x3000
#define  LCD2_LCD_SRAM_CTRL_RESERVED2_SHIFT 12
#define  LCD2_LCD_SRAM_CTRL_RESERVED2_MASK_SHIFT(reg) (((reg) & LCD2_LCD_SRAM_CTRL_RESERVED2_MASK) >> LCD2_LCD_SRAM_CTRL_RESERVED2_SHIFT)
#define  LCD2_LCD_SRAM_CTRL_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_SRAM_CTRL_RESERVED2_MASK) | (((uint32_t)val) << LCD2_LCD_SRAM_CTRL_RESERVED2_SHIFT))

#define  LCD2_LCD_SRAM_CTRL_CFG_SRAM_ADDR_LCDID_MASK 0xf00
#define  LCD2_LCD_SRAM_CTRL_CFG_SRAM_ADDR_LCDID_SHIFT 8
#define  LCD2_LCD_SRAM_CTRL_CFG_SRAM_ADDR_LCDID_MASK_SHIFT(reg) (((reg) & LCD2_LCD_SRAM_CTRL_CFG_SRAM_ADDR_LCDID_MASK) >> LCD2_LCD_SRAM_CTRL_CFG_SRAM_ADDR_LCDID_SHIFT)
#define  LCD2_LCD_SRAM_CTRL_CFG_SRAM_ADDR_LCDID_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_SRAM_CTRL_CFG_SRAM_ADDR_LCDID_MASK) | (((uint32_t)val) << LCD2_LCD_SRAM_CTRL_CFG_SRAM_ADDR_LCDID_SHIFT))

#define  LCD2_LCD_SRAM_CTRL_CFG_SRAM_ADDR_MASK 0xff
#define  LCD2_LCD_SRAM_CTRL_CFG_SRAM_ADDR_SHIFT 0
#define  LCD2_LCD_SRAM_CTRL_CFG_SRAM_ADDR_MASK_SHIFT(reg) (((reg) & LCD2_LCD_SRAM_CTRL_CFG_SRAM_ADDR_MASK) >> LCD2_LCD_SRAM_CTRL_CFG_SRAM_ADDR_SHIFT)
#define  LCD2_LCD_SRAM_CTRL_CFG_SRAM_ADDR_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_SRAM_CTRL_CFG_SRAM_ADDR_MASK) | (((uint32_t)val) << LCD2_LCD_SRAM_CTRL_CFG_SRAM_ADDR_SHIFT))

//====================================================================
//Register: SRAM Write Data Register (LCD_SRAM_WRDAT)
//====================================================================

#define  LCD2_LCD_SRAM_WRDAT_CFG_SRAM_WRDAT_MASK 0xffffffff
#define  LCD2_LCD_SRAM_WRDAT_CFG_SRAM_WRDAT_SHIFT 0
#define  LCD2_LCD_SRAM_WRDAT_CFG_SRAM_WRDAT_MASK_SHIFT(reg) (((reg) & LCD2_LCD_SRAM_WRDAT_CFG_SRAM_WRDAT_MASK) >> LCD2_LCD_SRAM_WRDAT_CFG_SRAM_WRDAT_SHIFT)
#define  LCD2_LCD_SRAM_WRDAT_CFG_SRAM_WRDAT_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_SRAM_WRDAT_CFG_SRAM_WRDAT_MASK) | (((uint32_t)val) << LCD2_LCD_SRAM_WRDAT_CFG_SRAM_WRDAT_SHIFT))

//====================================================================
//Register: SRAM Power Down Control Register (LCD_SRAM_PARA1)
//====================================================================

#define  LCD2_LCD_SRAM_PARA1_RESERVED1_MASK 0xffff0000
#define  LCD2_LCD_SRAM_PARA1_RESERVED1_SHIFT 16
#define  LCD2_LCD_SRAM_PARA1_RESERVED1_MASK_SHIFT(reg) (((reg) & LCD2_LCD_SRAM_PARA1_RESERVED1_MASK) >> LCD2_LCD_SRAM_PARA1_RESERVED1_SHIFT)
#define  LCD2_LCD_SRAM_PARA1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_SRAM_PARA1_RESERVED1_MASK) | (((uint32_t)val) << LCD2_LCD_SRAM_PARA1_RESERVED1_SHIFT))

#define  LCD2_LCD_SRAM_PARA1_RESERVED2_MASK 0x8000
#define  LCD2_LCD_SRAM_PARA1_RESERVED2_SHIFT 15
#define  LCD2_LCD_SRAM_PARA1_RESERVED2_MASK_SHIFT(reg) (((reg) & LCD2_LCD_SRAM_PARA1_RESERVED2_MASK) >> LCD2_LCD_SRAM_PARA1_RESERVED2_SHIFT)
#define  LCD2_LCD_SRAM_PARA1_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_SRAM_PARA1_RESERVED2_MASK) | (((uint32_t)val) << LCD2_LCD_SRAM_PARA1_RESERVED2_SHIFT))

#define  LCD2_LCD_SRAM_PARA1_CFG_CSB_256X24_MASK 0x4000
#define  LCD2_LCD_SRAM_PARA1_CFG_CSB_256X24_SHIFT 14
#define  LCD2_LCD_SRAM_PARA1_CFG_CSB_256X24_MASK_SHIFT(reg) (((reg) & LCD2_LCD_SRAM_PARA1_CFG_CSB_256X24_MASK) >> LCD2_LCD_SRAM_PARA1_CFG_CSB_256X24_SHIFT)
#define  LCD2_LCD_SRAM_PARA1_CFG_CSB_256X24_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_SRAM_PARA1_CFG_CSB_256X24_MASK) | (((uint32_t)val) << LCD2_LCD_SRAM_PARA1_CFG_CSB_256X24_SHIFT))

#define  LCD2_LCD_SRAM_PARA1_CFG_CSB_256X8_MASK 0x2000
#define  LCD2_LCD_SRAM_PARA1_CFG_CSB_256X8_SHIFT 13
#define  LCD2_LCD_SRAM_PARA1_CFG_CSB_256X8_MASK_SHIFT(reg) (((reg) & LCD2_LCD_SRAM_PARA1_CFG_CSB_256X8_MASK) >> LCD2_LCD_SRAM_PARA1_CFG_CSB_256X8_SHIFT)
#define  LCD2_LCD_SRAM_PARA1_CFG_CSB_256X8_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_SRAM_PARA1_CFG_CSB_256X8_MASK) | (((uint32_t)val) << LCD2_LCD_SRAM_PARA1_CFG_CSB_256X8_SHIFT))

#define  LCD2_LCD_SRAM_PARA1_RESERVED3_MASK 0x1fff
#define  LCD2_LCD_SRAM_PARA1_RESERVED3_SHIFT 0
#define  LCD2_LCD_SRAM_PARA1_RESERVED3_MASK_SHIFT(reg) (((reg) & LCD2_LCD_SRAM_PARA1_RESERVED3_MASK) >> LCD2_LCD_SRAM_PARA1_RESERVED3_SHIFT)
#define  LCD2_LCD_SRAM_PARA1_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_SRAM_PARA1_RESERVED3_MASK) | (((uint32_t)val) << LCD2_LCD_SRAM_PARA1_RESERVED3_SHIFT))

//====================================================================
//Register: Smart Panel or Dumb Panel Clock Divider (LCD_SCLK_DIV)
/** \brief This register is used to select the pixel clock source, see the field SCLK_MODE.
     <br/> <br/>
     Configuration bits for setting the pixel clock frequency are in the APMU registers called
     LCDXClkConfig_ClkGenConfig and LCDClkConfig,and are documented here for the reader's convenience, 
     See APMU register definition for final specification.
     <br/> <br/>
     NOTE : The pixel clock frequency has an operating range of 100MHz or less, due to implementation
     constraints. Although the APMU register bits allow for a calculated frequency that is greater than 100MHz,
     be sure to configure for a valid operating frequency.
     <br/> <br/>
     For Color Sequential Display mode, the dividers are for clocking the sequential pixel data, which runs at 3 (or 4) times the clock rate of the internal parallel data. See the PN_IOPAD_CONTROL register for configuring color seqential display mode.*/
//====================================================================

#define  LCD2_LCD_SCLK_DIV_SCLK_MODE_MASK 0x80000000
#define  LCD2_LCD_SCLK_DIV_SCLK_MODE_SHIFT 31
#define  LCD2_LCD_SCLK_DIV_SCLK_MODE_MASK_SHIFT(reg) (((reg) & LCD2_LCD_SCLK_DIV_SCLK_MODE_MASK) >> LCD2_LCD_SCLK_DIV_SCLK_MODE_SHIFT)
#define  LCD2_LCD_SCLK_DIV_SCLK_MODE_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_SCLK_DIV_SCLK_MODE_MASK) | (((uint32_t)val) << LCD2_LCD_SCLK_DIV_SCLK_MODE_SHIFT))

#define  LCD2_LCD_SCLK_DIV_RESERVED1_MASK 0x7e000000
#define  LCD2_LCD_SCLK_DIV_RESERVED1_SHIFT 25
#define  LCD2_LCD_SCLK_DIV_RESERVED1_MASK_SHIFT(reg) (((reg) & LCD2_LCD_SCLK_DIV_RESERVED1_MASK) >> LCD2_LCD_SCLK_DIV_RESERVED1_SHIFT)
#define  LCD2_LCD_SCLK_DIV_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_SCLK_DIV_RESERVED1_MASK) | (((uint32_t)val) << LCD2_LCD_SCLK_DIV_RESERVED1_SHIFT))

#define  LCD2_LCD_SCLK_DIV_SRCSEL_MASK 0x1000000
#define  LCD2_LCD_SCLK_DIV_SRCSEL_SHIFT 24
#define  LCD2_LCD_SCLK_DIV_SRCSEL_MASK_SHIFT(reg) (((reg) & LCD2_LCD_SCLK_DIV_SRCSEL_MASK) >> LCD2_LCD_SCLK_DIV_SRCSEL_SHIFT)
#define  LCD2_LCD_SCLK_DIV_SRCSEL_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_SCLK_DIV_SRCSEL_MASK) | (((uint32_t)val) << LCD2_LCD_SCLK_DIV_SRCSEL_SHIFT))

#define  LCD2_LCD_SCLK_DIV_RESERVED2_MASK 0xe00000
#define  LCD2_LCD_SCLK_DIV_RESERVED2_SHIFT 21
#define  LCD2_LCD_SCLK_DIV_RESERVED2_MASK_SHIFT(reg) (((reg) & LCD2_LCD_SCLK_DIV_RESERVED2_MASK) >> LCD2_LCD_SCLK_DIV_RESERVED2_SHIFT)
#define  LCD2_LCD_SCLK_DIV_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_SCLK_DIV_RESERVED2_MASK) | (((uint32_t)val) << LCD2_LCD_SCLK_DIV_RESERVED2_SHIFT))

#define  LCD2_LCD_SCLK_DIV_HIDIV_MASK 0x1f0000
#define  LCD2_LCD_SCLK_DIV_HIDIV_SHIFT 16
#define  LCD2_LCD_SCLK_DIV_HIDIV_MASK_SHIFT(reg) (((reg) & LCD2_LCD_SCLK_DIV_HIDIV_MASK) >> LCD2_LCD_SCLK_DIV_HIDIV_SHIFT)
#define  LCD2_LCD_SCLK_DIV_HIDIV_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_SCLK_DIV_HIDIV_MASK) | (((uint32_t)val) << LCD2_LCD_SCLK_DIV_HIDIV_SHIFT))

#define  LCD2_LCD_SCLK_DIV_RESERVED3_MASK 0xe000
#define  LCD2_LCD_SCLK_DIV_RESERVED3_SHIFT 13
#define  LCD2_LCD_SCLK_DIV_RESERVED3_MASK_SHIFT(reg) (((reg) & LCD2_LCD_SCLK_DIV_RESERVED3_MASK) >> LCD2_LCD_SCLK_DIV_RESERVED3_SHIFT)
#define  LCD2_LCD_SCLK_DIV_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_SCLK_DIV_RESERVED3_MASK) | (((uint32_t)val) << LCD2_LCD_SCLK_DIV_RESERVED3_SHIFT))

#define  LCD2_LCD_SCLK_DIV_LODIV_MASK 0x1f00
#define  LCD2_LCD_SCLK_DIV_LODIV_SHIFT 8
#define  LCD2_LCD_SCLK_DIV_LODIV_MASK_SHIFT(reg) (((reg) & LCD2_LCD_SCLK_DIV_LODIV_MASK) >> LCD2_LCD_SCLK_DIV_LODIV_SHIFT)
#define  LCD2_LCD_SCLK_DIV_LODIV_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_SCLK_DIV_LODIV_MASK) | (((uint32_t)val) << LCD2_LCD_SCLK_DIV_LODIV_SHIFT))

#define  LCD2_LCD_SCLK_DIV_RESERVED4_MASK 0xf8
#define  LCD2_LCD_SCLK_DIV_RESERVED4_SHIFT 3
#define  LCD2_LCD_SCLK_DIV_RESERVED4_MASK_SHIFT(reg) (((reg) & LCD2_LCD_SCLK_DIV_RESERVED4_MASK) >> LCD2_LCD_SCLK_DIV_RESERVED4_SHIFT)
#define  LCD2_LCD_SCLK_DIV_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_SCLK_DIV_RESERVED4_MASK) | (((uint32_t)val) << LCD2_LCD_SCLK_DIV_RESERVED4_SHIFT))

#define  LCD2_LCD_SCLK_DIV_PREDIVEN_MASK 0x4
#define  LCD2_LCD_SCLK_DIV_PREDIVEN_SHIFT 2
#define  LCD2_LCD_SCLK_DIV_PREDIVEN_MASK_SHIFT(reg) (((reg) & LCD2_LCD_SCLK_DIV_PREDIVEN_MASK) >> LCD2_LCD_SCLK_DIV_PREDIVEN_SHIFT)
#define  LCD2_LCD_SCLK_DIV_PREDIVEN_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_SCLK_DIV_PREDIVEN_MASK) | (((uint32_t)val) << LCD2_LCD_SCLK_DIV_PREDIVEN_SHIFT))

#define  LCD2_LCD_SCLK_DIV_XCLKEN_MASK 0x2
#define  LCD2_LCD_SCLK_DIV_XCLKEN_SHIFT 1
#define  LCD2_LCD_SCLK_DIV_XCLKEN_MASK_SHIFT(reg) (((reg) & LCD2_LCD_SCLK_DIV_XCLKEN_MASK) >> LCD2_LCD_SCLK_DIV_XCLKEN_SHIFT)
#define  LCD2_LCD_SCLK_DIV_XCLKEN_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_SCLK_DIV_XCLKEN_MASK) | (((uint32_t)val) << LCD2_LCD_SCLK_DIV_XCLKEN_SHIFT))

#define  LCD2_LCD_SCLK_DIV_CLKEN_MASK 0x1
#define  LCD2_LCD_SCLK_DIV_CLKEN_SHIFT 0
#define  LCD2_LCD_SCLK_DIV_CLKEN_MASK_SHIFT(reg) (((reg) & LCD2_LCD_SCLK_DIV_CLKEN_MASK) >> LCD2_LCD_SCLK_DIV_CLKEN_SHIFT)
#define  LCD2_LCD_SCLK_DIV_CLKEN_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_SCLK_DIV_CLKEN_MASK) | (((uint32_t)val) << LCD2_LCD_SCLK_DIV_CLKEN_SHIFT))

//====================================================================
//Register: Panel Path Video Contrast Register (LCD_PN_CONTRAST)
//====================================================================

#define  LCD2_LCD_PN_CONTRAST_CFG_PN_BRIGHTNESS_MASK 0xffff0000
#define  LCD2_LCD_PN_CONTRAST_CFG_PN_BRIGHTNESS_SHIFT 16
#define  LCD2_LCD_PN_CONTRAST_CFG_PN_BRIGHTNESS_MASK_SHIFT(reg) (((reg) & LCD2_LCD_PN_CONTRAST_CFG_PN_BRIGHTNESS_MASK) >> LCD2_LCD_PN_CONTRAST_CFG_PN_BRIGHTNESS_SHIFT)
#define  LCD2_LCD_PN_CONTRAST_CFG_PN_BRIGHTNESS_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_PN_CONTRAST_CFG_PN_BRIGHTNESS_MASK) | (((uint32_t)val) << LCD2_LCD_PN_CONTRAST_CFG_PN_BRIGHTNESS_SHIFT))

#define  LCD2_LCD_PN_CONTRAST_CFG_PN_CONTRAST_MASK 0xffff
#define  LCD2_LCD_PN_CONTRAST_CFG_PN_CONTRAST_SHIFT 0
#define  LCD2_LCD_PN_CONTRAST_CFG_PN_CONTRAST_MASK_SHIFT(reg) (((reg) & LCD2_LCD_PN_CONTRAST_CFG_PN_CONTRAST_MASK) >> LCD2_LCD_PN_CONTRAST_CFG_PN_CONTRAST_SHIFT)
#define  LCD2_LCD_PN_CONTRAST_CFG_PN_CONTRAST_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_PN_CONTRAST_CFG_PN_CONTRAST_MASK) | (((uint32_t)val) << LCD2_LCD_PN_CONTRAST_CFG_PN_CONTRAST_SHIFT))

//====================================================================
//Register: Panel Path Video Saturation Register (LCD_PN_SATURATION)
//====================================================================

#define  LCD2_LCD_PN_SATURATION_CFG_PN_C_MULT_S_MASK 0xffff0000
#define  LCD2_LCD_PN_SATURATION_CFG_PN_C_MULT_S_SHIFT 16
#define  LCD2_LCD_PN_SATURATION_CFG_PN_C_MULT_S_MASK_SHIFT(reg) (((reg) & LCD2_LCD_PN_SATURATION_CFG_PN_C_MULT_S_MASK) >> LCD2_LCD_PN_SATURATION_CFG_PN_C_MULT_S_SHIFT)
#define  LCD2_LCD_PN_SATURATION_CFG_PN_C_MULT_S_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_PN_SATURATION_CFG_PN_C_MULT_S_MASK) | (((uint32_t)val) << LCD2_LCD_PN_SATURATION_CFG_PN_C_MULT_S_SHIFT))

#define  LCD2_LCD_PN_SATURATION_CFG_PN_SATURATION_MASK 0xffff
#define  LCD2_LCD_PN_SATURATION_CFG_PN_SATURATION_SHIFT 0
#define  LCD2_LCD_PN_SATURATION_CFG_PN_SATURATION_MASK_SHIFT(reg) (((reg) & LCD2_LCD_PN_SATURATION_CFG_PN_SATURATION_MASK) >> LCD2_LCD_PN_SATURATION_CFG_PN_SATURATION_SHIFT)
#define  LCD2_LCD_PN_SATURATION_CFG_PN_SATURATION_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_PN_SATURATION_CFG_PN_SATURATION_MASK) | (((uint32_t)val) << LCD2_LCD_PN_SATURATION_CFG_PN_SATURATION_SHIFT))

//====================================================================
//Register: Panel Path Video Hue Adjust Register (LCD_PN_CBSH_HUE)
//====================================================================

#define  LCD2_LCD_PN_CBSH_HUE_CFG_PN_SIN0_MASK 0xffff0000
#define  LCD2_LCD_PN_CBSH_HUE_CFG_PN_SIN0_SHIFT 16
#define  LCD2_LCD_PN_CBSH_HUE_CFG_PN_SIN0_MASK_SHIFT(reg) (((reg) & LCD2_LCD_PN_CBSH_HUE_CFG_PN_SIN0_MASK) >> LCD2_LCD_PN_CBSH_HUE_CFG_PN_SIN0_SHIFT)
#define  LCD2_LCD_PN_CBSH_HUE_CFG_PN_SIN0_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_PN_CBSH_HUE_CFG_PN_SIN0_MASK) | (((uint32_t)val) << LCD2_LCD_PN_CBSH_HUE_CFG_PN_SIN0_SHIFT))

#define  LCD2_LCD_PN_CBSH_HUE_CFG_PN_COS0_MASK 0xffff
#define  LCD2_LCD_PN_CBSH_HUE_CFG_PN_COS0_SHIFT 0
#define  LCD2_LCD_PN_CBSH_HUE_CFG_PN_COS0_MASK_SHIFT(reg) (((reg) & LCD2_LCD_PN_CBSH_HUE_CFG_PN_COS0_MASK) >> LCD2_LCD_PN_CBSH_HUE_CFG_PN_COS0_SHIFT)
#define  LCD2_LCD_PN_CBSH_HUE_CFG_PN_COS0_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_PN_CBSH_HUE_CFG_PN_COS0_MASK) | (((uint32_t)val) << LCD2_LCD_PN_CBSH_HUE_CFG_PN_COS0_SHIFT))

//====================================================================
//Register: Panel Path Dumb LCD Panel Control Register (LCD_DUMB_CTRL)
//====================================================================

#define  LCD2_LCD_DUMB_CTRL_CFG_DUMBMODE_MASK 0xf0000000
#define  LCD2_LCD_DUMB_CTRL_CFG_DUMBMODE_SHIFT 28
#define  LCD2_LCD_DUMB_CTRL_CFG_DUMBMODE_MASK_SHIFT(reg) (((reg) & LCD2_LCD_DUMB_CTRL_CFG_DUMBMODE_MASK) >> LCD2_LCD_DUMB_CTRL_CFG_DUMBMODE_SHIFT)
#define  LCD2_LCD_DUMB_CTRL_CFG_DUMBMODE_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_DUMB_CTRL_CFG_DUMBMODE_MASK) | (((uint32_t)val) << LCD2_LCD_DUMB_CTRL_CFG_DUMBMODE_SHIFT))

#define  LCD2_LCD_DUMB_CTRL_CFG_LCDGPIO_O_MASK 0xff00000
#define  LCD2_LCD_DUMB_CTRL_CFG_LCDGPIO_O_SHIFT 20
#define  LCD2_LCD_DUMB_CTRL_CFG_LCDGPIO_O_MASK_SHIFT(reg) (((reg) & LCD2_LCD_DUMB_CTRL_CFG_LCDGPIO_O_MASK) >> LCD2_LCD_DUMB_CTRL_CFG_LCDGPIO_O_SHIFT)
#define  LCD2_LCD_DUMB_CTRL_CFG_LCDGPIO_O_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_DUMB_CTRL_CFG_LCDGPIO_O_MASK) | (((uint32_t)val) << LCD2_LCD_DUMB_CTRL_CFG_LCDGPIO_O_SHIFT))

#define  LCD2_LCD_DUMB_CTRL_CFG_LCDGPIO_ENA_MASK 0xff000
#define  LCD2_LCD_DUMB_CTRL_CFG_LCDGPIO_ENA_SHIFT 12
#define  LCD2_LCD_DUMB_CTRL_CFG_LCDGPIO_ENA_MASK_SHIFT(reg) (((reg) & LCD2_LCD_DUMB_CTRL_CFG_LCDGPIO_ENA_MASK) >> LCD2_LCD_DUMB_CTRL_CFG_LCDGPIO_ENA_SHIFT)
#define  LCD2_LCD_DUMB_CTRL_CFG_LCDGPIO_ENA_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_DUMB_CTRL_CFG_LCDGPIO_ENA_MASK) | (((uint32_t)val) << LCD2_LCD_DUMB_CTRL_CFG_LCDGPIO_ENA_SHIFT))

#define  LCD2_LCD_DUMB_CTRL_CFG_GRA_PMBURST_MASK 0x800
#define  LCD2_LCD_DUMB_CTRL_CFG_GRA_PMBURST_SHIFT 11
#define  LCD2_LCD_DUMB_CTRL_CFG_GRA_PMBURST_MASK_SHIFT(reg) (((reg) & LCD2_LCD_DUMB_CTRL_CFG_GRA_PMBURST_MASK) >> LCD2_LCD_DUMB_CTRL_CFG_GRA_PMBURST_SHIFT)
#define  LCD2_LCD_DUMB_CTRL_CFG_GRA_PMBURST_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_DUMB_CTRL_CFG_GRA_PMBURST_MASK) | (((uint32_t)val) << LCD2_LCD_DUMB_CTRL_CFG_GRA_PMBURST_SHIFT))

#define  LCD2_LCD_DUMB_CTRL_RESERVED1_MASK 0x400
#define  LCD2_LCD_DUMB_CTRL_RESERVED1_SHIFT 10
#define  LCD2_LCD_DUMB_CTRL_RESERVED1_MASK_SHIFT(reg) (((reg) & LCD2_LCD_DUMB_CTRL_RESERVED1_MASK) >> LCD2_LCD_DUMB_CTRL_RESERVED1_SHIFT)
#define  LCD2_LCD_DUMB_CTRL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_DUMB_CTRL_RESERVED1_MASK) | (((uint32_t)val) << LCD2_LCD_DUMB_CTRL_RESERVED1_SHIFT))

#define  LCD2_LCD_DUMB_CTRL_CFG_PN_NO_IOPAD_MASK 0x200
#define  LCD2_LCD_DUMB_CTRL_CFG_PN_NO_IOPAD_SHIFT 9
#define  LCD2_LCD_DUMB_CTRL_CFG_PN_NO_IOPAD_MASK_SHIFT(reg) (((reg) & LCD2_LCD_DUMB_CTRL_CFG_PN_NO_IOPAD_MASK) >> LCD2_LCD_DUMB_CTRL_CFG_PN_NO_IOPAD_SHIFT)
#define  LCD2_LCD_DUMB_CTRL_CFG_PN_NO_IOPAD_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_DUMB_CTRL_CFG_PN_NO_IOPAD_MASK) | (((uint32_t)val) << LCD2_LCD_DUMB_CTRL_CFG_PN_NO_IOPAD_SHIFT))

#define  LCD2_LCD_DUMB_CTRL_CFG_PN_BIASOUT_MASK 0x100
#define  LCD2_LCD_DUMB_CTRL_CFG_PN_BIASOUT_SHIFT 8
#define  LCD2_LCD_DUMB_CTRL_CFG_PN_BIASOUT_MASK_SHIFT(reg) (((reg) & LCD2_LCD_DUMB_CTRL_CFG_PN_BIASOUT_MASK) >> LCD2_LCD_DUMB_CTRL_CFG_PN_BIASOUT_SHIFT)
#define  LCD2_LCD_DUMB_CTRL_CFG_PN_BIASOUT_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_DUMB_CTRL_CFG_PN_BIASOUT_MASK) | (((uint32_t)val) << LCD2_LCD_DUMB_CTRL_CFG_PN_BIASOUT_SHIFT))

#define  LCD2_LCD_DUMB_CTRL_CFG_PN_REVERSE_RGB_MASK 0x80
#define  LCD2_LCD_DUMB_CTRL_CFG_PN_REVERSE_RGB_SHIFT 7
#define  LCD2_LCD_DUMB_CTRL_CFG_PN_REVERSE_RGB_MASK_SHIFT(reg) (((reg) & LCD2_LCD_DUMB_CTRL_CFG_PN_REVERSE_RGB_MASK) >> LCD2_LCD_DUMB_CTRL_CFG_PN_REVERSE_RGB_SHIFT)
#define  LCD2_LCD_DUMB_CTRL_CFG_PN_REVERSE_RGB_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_DUMB_CTRL_CFG_PN_REVERSE_RGB_MASK) | (((uint32_t)val) << LCD2_LCD_DUMB_CTRL_CFG_PN_REVERSE_RGB_SHIFT))

#define  LCD2_LCD_DUMB_CTRL_RESERVED2_MASK 0x40
#define  LCD2_LCD_DUMB_CTRL_RESERVED2_SHIFT 6
#define  LCD2_LCD_DUMB_CTRL_RESERVED2_MASK_SHIFT(reg) (((reg) & LCD2_LCD_DUMB_CTRL_RESERVED2_MASK) >> LCD2_LCD_DUMB_CTRL_RESERVED2_SHIFT)
#define  LCD2_LCD_DUMB_CTRL_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_DUMB_CTRL_RESERVED2_MASK) | (((uint32_t)val) << LCD2_LCD_DUMB_CTRL_RESERVED2_SHIFT))

#define  LCD2_LCD_DUMB_CTRL_RESERVED3_MASK 0x20
#define  LCD2_LCD_DUMB_CTRL_RESERVED3_SHIFT 5
#define  LCD2_LCD_DUMB_CTRL_RESERVED3_MASK_SHIFT(reg) (((reg) & LCD2_LCD_DUMB_CTRL_RESERVED3_MASK) >> LCD2_LCD_DUMB_CTRL_RESERVED3_SHIFT)
#define  LCD2_LCD_DUMB_CTRL_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_DUMB_CTRL_RESERVED3_MASK) | (((uint32_t)val) << LCD2_LCD_DUMB_CTRL_RESERVED3_SHIFT))

#define  LCD2_LCD_DUMB_CTRL_CFG_PN_INV_HENA_MASK 0x10
#define  LCD2_LCD_DUMB_CTRL_CFG_PN_INV_HENA_SHIFT 4
#define  LCD2_LCD_DUMB_CTRL_CFG_PN_INV_HENA_MASK_SHIFT(reg) (((reg) & LCD2_LCD_DUMB_CTRL_CFG_PN_INV_HENA_MASK) >> LCD2_LCD_DUMB_CTRL_CFG_PN_INV_HENA_SHIFT)
#define  LCD2_LCD_DUMB_CTRL_CFG_PN_INV_HENA_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_DUMB_CTRL_CFG_PN_INV_HENA_MASK) | (((uint32_t)val) << LCD2_LCD_DUMB_CTRL_CFG_PN_INV_HENA_SHIFT))

#define  LCD2_LCD_DUMB_CTRL_CFG_PN_INV_VSYNC_MASK 0x8
#define  LCD2_LCD_DUMB_CTRL_CFG_PN_INV_VSYNC_SHIFT 3
#define  LCD2_LCD_DUMB_CTRL_CFG_PN_INV_VSYNC_MASK_SHIFT(reg) (((reg) & LCD2_LCD_DUMB_CTRL_CFG_PN_INV_VSYNC_MASK) >> LCD2_LCD_DUMB_CTRL_CFG_PN_INV_VSYNC_SHIFT)
#define  LCD2_LCD_DUMB_CTRL_CFG_PN_INV_VSYNC_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_DUMB_CTRL_CFG_PN_INV_VSYNC_MASK) | (((uint32_t)val) << LCD2_LCD_DUMB_CTRL_CFG_PN_INV_VSYNC_SHIFT))

#define  LCD2_LCD_DUMB_CTRL_CFG_PN_INV_HSYNC_MASK 0x4
#define  LCD2_LCD_DUMB_CTRL_CFG_PN_INV_HSYNC_SHIFT 2
#define  LCD2_LCD_DUMB_CTRL_CFG_PN_INV_HSYNC_MASK_SHIFT(reg) (((reg) & LCD2_LCD_DUMB_CTRL_CFG_PN_INV_HSYNC_MASK) >> LCD2_LCD_DUMB_CTRL_CFG_PN_INV_HSYNC_SHIFT)
#define  LCD2_LCD_DUMB_CTRL_CFG_PN_INV_HSYNC_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_DUMB_CTRL_CFG_PN_INV_HSYNC_MASK) | (((uint32_t)val) << LCD2_LCD_DUMB_CTRL_CFG_PN_INV_HSYNC_SHIFT))

#define  LCD2_LCD_DUMB_CTRL_CFG_PN_INV_PCLK_MASK 0x2
#define  LCD2_LCD_DUMB_CTRL_CFG_PN_INV_PCLK_SHIFT 1
#define  LCD2_LCD_DUMB_CTRL_CFG_PN_INV_PCLK_MASK_SHIFT(reg) (((reg) & LCD2_LCD_DUMB_CTRL_CFG_PN_INV_PCLK_MASK) >> LCD2_LCD_DUMB_CTRL_CFG_PN_INV_PCLK_SHIFT)
#define  LCD2_LCD_DUMB_CTRL_CFG_PN_INV_PCLK_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_DUMB_CTRL_CFG_PN_INV_PCLK_MASK) | (((uint32_t)val) << LCD2_LCD_DUMB_CTRL_CFG_PN_INV_PCLK_SHIFT))

#define  LCD2_LCD_DUMB_CTRL_CFG_DUMB_ENA_MASK 0x1
#define  LCD2_LCD_DUMB_CTRL_CFG_DUMB_ENA_SHIFT 0
#define  LCD2_LCD_DUMB_CTRL_CFG_DUMB_ENA_MASK_SHIFT(reg) (((reg) & LCD2_LCD_DUMB_CTRL_CFG_DUMB_ENA_MASK) >> LCD2_LCD_DUMB_CTRL_CFG_DUMB_ENA_SHIFT)
#define  LCD2_LCD_DUMB_CTRL_CFG_DUMB_ENA_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_DUMB_CTRL_CFG_DUMB_ENA_MASK) | (((uint32_t)val) << LCD2_LCD_DUMB_CTRL_CFG_DUMB_ENA_SHIFT))

//====================================================================
//Register: Panel Path I/O Pads Control Register (PN_IOPAD_CONTROL)
//====================================================================

#define  LCD2_PN_IOPAD_CONTROL_CFG_DMA_SA_YMSK_MASK 0x80000000
#define  LCD2_PN_IOPAD_CONTROL_CFG_DMA_SA_YMSK_SHIFT 31
#define  LCD2_PN_IOPAD_CONTROL_CFG_DMA_SA_YMSK_MASK_SHIFT(reg) (((reg) & LCD2_PN_IOPAD_CONTROL_CFG_DMA_SA_YMSK_MASK) >> LCD2_PN_IOPAD_CONTROL_CFG_DMA_SA_YMSK_SHIFT)
#define  LCD2_PN_IOPAD_CONTROL_CFG_DMA_SA_YMSK_REPLACE_VAL(reg,val) (((reg) & ~LCD2_PN_IOPAD_CONTROL_CFG_DMA_SA_YMSK_MASK) | (((uint32_t)val) << LCD2_PN_IOPAD_CONTROL_CFG_DMA_SA_YMSK_SHIFT))

#define  LCD2_PN_IOPAD_CONTROL_CFG_DMA_SA_UMSK_MASK 0x40000000
#define  LCD2_PN_IOPAD_CONTROL_CFG_DMA_SA_UMSK_SHIFT 30
#define  LCD2_PN_IOPAD_CONTROL_CFG_DMA_SA_UMSK_MASK_SHIFT(reg) (((reg) & LCD2_PN_IOPAD_CONTROL_CFG_DMA_SA_UMSK_MASK) >> LCD2_PN_IOPAD_CONTROL_CFG_DMA_SA_UMSK_SHIFT)
#define  LCD2_PN_IOPAD_CONTROL_CFG_DMA_SA_UMSK_REPLACE_VAL(reg,val) (((reg) & ~LCD2_PN_IOPAD_CONTROL_CFG_DMA_SA_UMSK_MASK) | (((uint32_t)val) << LCD2_PN_IOPAD_CONTROL_CFG_DMA_SA_UMSK_SHIFT))

#define  LCD2_PN_IOPAD_CONTROL_CFG_DMA_SA_VMSK_MASK 0x20000000
#define  LCD2_PN_IOPAD_CONTROL_CFG_DMA_SA_VMSK_SHIFT 29
#define  LCD2_PN_IOPAD_CONTROL_CFG_DMA_SA_VMSK_MASK_SHIFT(reg) (((reg) & LCD2_PN_IOPAD_CONTROL_CFG_DMA_SA_VMSK_MASK) >> LCD2_PN_IOPAD_CONTROL_CFG_DMA_SA_VMSK_SHIFT)
#define  LCD2_PN_IOPAD_CONTROL_CFG_DMA_SA_VMSK_REPLACE_VAL(reg,val) (((reg) & ~LCD2_PN_IOPAD_CONTROL_CFG_DMA_SA_VMSK_MASK) | (((uint32_t)val) << LCD2_PN_IOPAD_CONTROL_CFG_DMA_SA_VMSK_SHIFT))

#define  LCD2_PN_IOPAD_CONTROL_CFG_GRA_SA_YMSK_MASK 0x10000000
#define  LCD2_PN_IOPAD_CONTROL_CFG_GRA_SA_YMSK_SHIFT 28
#define  LCD2_PN_IOPAD_CONTROL_CFG_GRA_SA_YMSK_MASK_SHIFT(reg) (((reg) & LCD2_PN_IOPAD_CONTROL_CFG_GRA_SA_YMSK_MASK) >> LCD2_PN_IOPAD_CONTROL_CFG_GRA_SA_YMSK_SHIFT)
#define  LCD2_PN_IOPAD_CONTROL_CFG_GRA_SA_YMSK_REPLACE_VAL(reg,val) (((reg) & ~LCD2_PN_IOPAD_CONTROL_CFG_GRA_SA_YMSK_MASK) | (((uint32_t)val) << LCD2_PN_IOPAD_CONTROL_CFG_GRA_SA_YMSK_SHIFT))

#define  LCD2_PN_IOPAD_CONTROL_RESERVED1_MASK 0x8000000
#define  LCD2_PN_IOPAD_CONTROL_RESERVED1_SHIFT 27
#define  LCD2_PN_IOPAD_CONTROL_RESERVED1_MASK_SHIFT(reg) (((reg) & LCD2_PN_IOPAD_CONTROL_RESERVED1_MASK) >> LCD2_PN_IOPAD_CONTROL_RESERVED1_SHIFT)
#define  LCD2_PN_IOPAD_CONTROL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~LCD2_PN_IOPAD_CONTROL_RESERVED1_MASK) | (((uint32_t)val) << LCD2_PN_IOPAD_CONTROL_RESERVED1_SHIFT))

#define  LCD2_PN_IOPAD_CONTROL_CSEQ_ODD_ROWORDER_MASK 0x7000000
#define  LCD2_PN_IOPAD_CONTROL_CSEQ_ODD_ROWORDER_SHIFT 24
#define  LCD2_PN_IOPAD_CONTROL_CSEQ_ODD_ROWORDER_MASK_SHIFT(reg) (((reg) & LCD2_PN_IOPAD_CONTROL_CSEQ_ODD_ROWORDER_MASK) >> LCD2_PN_IOPAD_CONTROL_CSEQ_ODD_ROWORDER_SHIFT)
#define  LCD2_PN_IOPAD_CONTROL_CSEQ_ODD_ROWORDER_REPLACE_VAL(reg,val) (((reg) & ~LCD2_PN_IOPAD_CONTROL_CSEQ_ODD_ROWORDER_MASK) | (((uint32_t)val) << LCD2_PN_IOPAD_CONTROL_CSEQ_ODD_ROWORDER_SHIFT))

#define  LCD2_PN_IOPAD_CONTROL_CFG_DMA_SA_CMSK_MASK 0x800000
#define  LCD2_PN_IOPAD_CONTROL_CFG_DMA_SA_CMSK_SHIFT 23
#define  LCD2_PN_IOPAD_CONTROL_CFG_DMA_SA_CMSK_MASK_SHIFT(reg) (((reg) & LCD2_PN_IOPAD_CONTROL_CFG_DMA_SA_CMSK_MASK) >> LCD2_PN_IOPAD_CONTROL_CFG_DMA_SA_CMSK_SHIFT)
#define  LCD2_PN_IOPAD_CONTROL_CFG_DMA_SA_CMSK_REPLACE_VAL(reg,val) (((reg) & ~LCD2_PN_IOPAD_CONTROL_CFG_DMA_SA_CMSK_MASK) | (((uint32_t)val) << LCD2_PN_IOPAD_CONTROL_CFG_DMA_SA_CMSK_SHIFT))

#define  LCD2_PN_IOPAD_CONTROL_RESERVED2_MASK 0x400000
#define  LCD2_PN_IOPAD_CONTROL_RESERVED2_SHIFT 22
#define  LCD2_PN_IOPAD_CONTROL_RESERVED2_MASK_SHIFT(reg) (((reg) & LCD2_PN_IOPAD_CONTROL_RESERVED2_MASK) >> LCD2_PN_IOPAD_CONTROL_RESERVED2_SHIFT)
#define  LCD2_PN_IOPAD_CONTROL_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~LCD2_PN_IOPAD_CONTROL_RESERVED2_MASK) | (((uint32_t)val) << LCD2_PN_IOPAD_CONTROL_RESERVED2_SHIFT))

#define  LCD2_PN_IOPAD_CONTROL_RESERVED3_MASK 0x200000
#define  LCD2_PN_IOPAD_CONTROL_RESERVED3_SHIFT 21
#define  LCD2_PN_IOPAD_CONTROL_RESERVED3_MASK_SHIFT(reg) (((reg) & LCD2_PN_IOPAD_CONTROL_RESERVED3_MASK) >> LCD2_PN_IOPAD_CONTROL_RESERVED3_SHIFT)
#define  LCD2_PN_IOPAD_CONTROL_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~LCD2_PN_IOPAD_CONTROL_RESERVED3_MASK) | (((uint32_t)val) << LCD2_PN_IOPAD_CONTROL_RESERVED3_SHIFT))

#define  LCD2_PN_IOPAD_CONTROL_CFG_SA_ENABLE_MASK 0x100000
#define  LCD2_PN_IOPAD_CONTROL_CFG_SA_ENABLE_SHIFT 20
#define  LCD2_PN_IOPAD_CONTROL_CFG_SA_ENABLE_MASK_SHIFT(reg) (((reg) & LCD2_PN_IOPAD_CONTROL_CFG_SA_ENABLE_MASK) >> LCD2_PN_IOPAD_CONTROL_CFG_SA_ENABLE_SHIFT)
#define  LCD2_PN_IOPAD_CONTROL_CFG_SA_ENABLE_REPLACE_VAL(reg,val) (((reg) & ~LCD2_PN_IOPAD_CONTROL_CFG_SA_ENABLE_MASK) | (((uint32_t)val) << LCD2_PN_IOPAD_CONTROL_CFG_SA_ENABLE_SHIFT))

#define  LCD2_PN_IOPAD_CONTROL_RESERVED4_MASK 0x80000
#define  LCD2_PN_IOPAD_CONTROL_RESERVED4_SHIFT 19
#define  LCD2_PN_IOPAD_CONTROL_RESERVED4_MASK_SHIFT(reg) (((reg) & LCD2_PN_IOPAD_CONTROL_RESERVED4_MASK) >> LCD2_PN_IOPAD_CONTROL_RESERVED4_SHIFT)
#define  LCD2_PN_IOPAD_CONTROL_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~LCD2_PN_IOPAD_CONTROL_RESERVED4_MASK) | (((uint32_t)val) << LCD2_PN_IOPAD_CONTROL_RESERVED4_SHIFT))

#define  LCD2_PN_IOPAD_CONTROL_CSEQ_EVEN_ROWORDER_MASK 0x70000
#define  LCD2_PN_IOPAD_CONTROL_CSEQ_EVEN_ROWORDER_SHIFT 16
#define  LCD2_PN_IOPAD_CONTROL_CSEQ_EVEN_ROWORDER_MASK_SHIFT(reg) (((reg) & LCD2_PN_IOPAD_CONTROL_CSEQ_EVEN_ROWORDER_MASK) >> LCD2_PN_IOPAD_CONTROL_CSEQ_EVEN_ROWORDER_SHIFT)
#define  LCD2_PN_IOPAD_CONTROL_CSEQ_EVEN_ROWORDER_REPLACE_VAL(reg,val) (((reg) & ~LCD2_PN_IOPAD_CONTROL_CSEQ_EVEN_ROWORDER_MASK) | (((uint32_t)val) << LCD2_PN_IOPAD_CONTROL_CSEQ_EVEN_ROWORDER_SHIFT))

#define  LCD2_PN_IOPAD_CONTROL_CFG_GRA_VM_ENA_MASK 0x8000
#define  LCD2_PN_IOPAD_CONTROL_CFG_GRA_VM_ENA_SHIFT 15
#define  LCD2_PN_IOPAD_CONTROL_CFG_GRA_VM_ENA_MASK_SHIFT(reg) (((reg) & LCD2_PN_IOPAD_CONTROL_CFG_GRA_VM_ENA_MASK) >> LCD2_PN_IOPAD_CONTROL_CFG_GRA_VM_ENA_SHIFT)
#define  LCD2_PN_IOPAD_CONTROL_CFG_GRA_VM_ENA_REPLACE_VAL(reg,val) (((reg) & ~LCD2_PN_IOPAD_CONTROL_CFG_GRA_VM_ENA_MASK) | (((uint32_t)val) << LCD2_PN_IOPAD_CONTROL_CFG_GRA_VM_ENA_SHIFT))

#define  LCD2_PN_IOPAD_CONTROL_RESERVED5_MASK 0x4000
#define  LCD2_PN_IOPAD_CONTROL_RESERVED5_SHIFT 14
#define  LCD2_PN_IOPAD_CONTROL_RESERVED5_MASK_SHIFT(reg) (((reg) & LCD2_PN_IOPAD_CONTROL_RESERVED5_MASK) >> LCD2_PN_IOPAD_CONTROL_RESERVED5_SHIFT)
#define  LCD2_PN_IOPAD_CONTROL_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~LCD2_PN_IOPAD_CONTROL_RESERVED5_MASK) | (((uint32_t)val) << LCD2_PN_IOPAD_CONTROL_RESERVED5_SHIFT))

#define  LCD2_PN_IOPAD_CONTROL_CFG_DMA_VM_ENA_MASK 0x2000
#define  LCD2_PN_IOPAD_CONTROL_CFG_DMA_VM_ENA_SHIFT 13
#define  LCD2_PN_IOPAD_CONTROL_CFG_DMA_VM_ENA_MASK_SHIFT(reg) (((reg) & LCD2_PN_IOPAD_CONTROL_CFG_DMA_VM_ENA_MASK) >> LCD2_PN_IOPAD_CONTROL_CFG_DMA_VM_ENA_SHIFT)
#define  LCD2_PN_IOPAD_CONTROL_CFG_DMA_VM_ENA_REPLACE_VAL(reg,val) (((reg) & ~LCD2_PN_IOPAD_CONTROL_CFG_DMA_VM_ENA_MASK) | (((uint32_t)val) << LCD2_PN_IOPAD_CONTROL_CFG_DMA_VM_ENA_SHIFT))

#define  LCD2_PN_IOPAD_CONTROL_CFG_CMD_VM_ENA_MASK 0x1000
#define  LCD2_PN_IOPAD_CONTROL_CFG_CMD_VM_ENA_SHIFT 12
#define  LCD2_PN_IOPAD_CONTROL_CFG_CMD_VM_ENA_MASK_SHIFT(reg) (((reg) & LCD2_PN_IOPAD_CONTROL_CFG_CMD_VM_ENA_MASK) >> LCD2_PN_IOPAD_CONTROL_CFG_CMD_VM_ENA_SHIFT)
#define  LCD2_PN_IOPAD_CONTROL_CFG_CMD_VM_ENA_REPLACE_VAL(reg,val) (((reg) & ~LCD2_PN_IOPAD_CONTROL_CFG_CMD_VM_ENA_MASK) | (((uint32_t)val) << LCD2_PN_IOPAD_CONTROL_CFG_CMD_VM_ENA_SHIFT))

#define  LCD2_PN_IOPAD_CONTROL_RESERVED6_MASK 0xc00
#define  LCD2_PN_IOPAD_CONTROL_RESERVED6_SHIFT 10
#define  LCD2_PN_IOPAD_CONTROL_RESERVED6_MASK_SHIFT(reg) (((reg) & LCD2_PN_IOPAD_CONTROL_RESERVED6_MASK) >> LCD2_PN_IOPAD_CONTROL_RESERVED6_SHIFT)
#define  LCD2_PN_IOPAD_CONTROL_RESERVED6_REPLACE_VAL(reg,val) (((reg) & ~LCD2_PN_IOPAD_CONTROL_RESERVED6_MASK) | (((uint32_t)val) << LCD2_PN_IOPAD_CONTROL_RESERVED6_SHIFT))

#define  LCD2_PN_IOPAD_CONTROL_CFG_PN_CSC_MASK 0x300
#define  LCD2_PN_IOPAD_CONTROL_CFG_PN_CSC_SHIFT 8
#define  LCD2_PN_IOPAD_CONTROL_CFG_PN_CSC_MASK_SHIFT(reg) (((reg) & LCD2_PN_IOPAD_CONTROL_CFG_PN_CSC_MASK) >> LCD2_PN_IOPAD_CONTROL_CFG_PN_CSC_SHIFT)
#define  LCD2_PN_IOPAD_CONTROL_CFG_PN_CSC_REPLACE_VAL(reg,val) (((reg) & ~LCD2_PN_IOPAD_CONTROL_CFG_PN_CSC_MASK) | (((uint32_t)val) << LCD2_PN_IOPAD_CONTROL_CFG_PN_CSC_SHIFT))

#define  LCD2_PN_IOPAD_CONTROL_RESERVED7_MASK 0xc0
#define  LCD2_PN_IOPAD_CONTROL_RESERVED7_SHIFT 6
#define  LCD2_PN_IOPAD_CONTROL_RESERVED7_MASK_SHIFT(reg) (((reg) & LCD2_PN_IOPAD_CONTROL_RESERVED7_MASK) >> LCD2_PN_IOPAD_CONTROL_RESERVED7_SHIFT)
#define  LCD2_PN_IOPAD_CONTROL_RESERVED7_REPLACE_VAL(reg,val) (((reg) & ~LCD2_PN_IOPAD_CONTROL_RESERVED7_MASK) | (((uint32_t)val) << LCD2_PN_IOPAD_CONTROL_RESERVED7_SHIFT))

#define  LCD2_PN_IOPAD_CONTROL_CFG_BOUNDARY_MASK 0x20
#define  LCD2_PN_IOPAD_CONTROL_CFG_BOUNDARY_SHIFT 5
#define  LCD2_PN_IOPAD_CONTROL_CFG_BOUNDARY_MASK_SHIFT(reg) (((reg) & LCD2_PN_IOPAD_CONTROL_CFG_BOUNDARY_MASK) >> LCD2_PN_IOPAD_CONTROL_CFG_BOUNDARY_SHIFT)
#define  LCD2_PN_IOPAD_CONTROL_CFG_BOUNDARY_REPLACE_VAL(reg,val) (((reg) & ~LCD2_PN_IOPAD_CONTROL_CFG_BOUNDARY_MASK) | (((uint32_t)val) << LCD2_PN_IOPAD_CONTROL_CFG_BOUNDARY_SHIFT))

#define  LCD2_PN_IOPAD_CONTROL_CFG_CYC_BURST_LENGTH_MASK 0x10
#define  LCD2_PN_IOPAD_CONTROL_CFG_CYC_BURST_LENGTH_SHIFT 4
#define  LCD2_PN_IOPAD_CONTROL_CFG_CYC_BURST_LENGTH_MASK_SHIFT(reg) (((reg) & LCD2_PN_IOPAD_CONTROL_CFG_CYC_BURST_LENGTH_MASK) >> LCD2_PN_IOPAD_CONTROL_CFG_CYC_BURST_LENGTH_SHIFT)
#define  LCD2_PN_IOPAD_CONTROL_CFG_CYC_BURST_LENGTH_REPLACE_VAL(reg,val) (((reg) & ~LCD2_PN_IOPAD_CONTROL_CFG_CYC_BURST_LENGTH_MASK) | (((uint32_t)val) << LCD2_PN_IOPAD_CONTROL_CFG_CYC_BURST_LENGTH_SHIFT))

#define  LCD2_PN_IOPAD_CONTROL_CFG_IOPADMODE_MASK 0xf
#define  LCD2_PN_IOPAD_CONTROL_CFG_IOPADMODE_SHIFT 0
#define  LCD2_PN_IOPAD_CONTROL_CFG_IOPADMODE_MASK_SHIFT(reg) (((reg) & LCD2_PN_IOPAD_CONTROL_CFG_IOPADMODE_MASK) >> LCD2_PN_IOPAD_CONTROL_CFG_IOPADMODE_SHIFT)
#define  LCD2_PN_IOPAD_CONTROL_CFG_IOPADMODE_REPLACE_VAL(reg,val) (((reg) & ~LCD2_PN_IOPAD_CONTROL_CFG_IOPADMODE_MASK) | (((uint32_t)val) << LCD2_PN_IOPAD_CONTROL_CFG_IOPADMODE_SHIFT))

//====================================================================
//Register: LCD Interrupt Control Register (SPU_IRQ_ENA)
//====================================================================

#define  LCD2_SPU_IRQ_ENA_DMA_FRAME_IRQ0_ENA_MASK 0x80000000
#define  LCD2_SPU_IRQ_ENA_DMA_FRAME_IRQ0_ENA_SHIFT 31
#define  LCD2_SPU_IRQ_ENA_DMA_FRAME_IRQ0_ENA_MASK_SHIFT(reg) (((reg) & LCD2_SPU_IRQ_ENA_DMA_FRAME_IRQ0_ENA_MASK) >> LCD2_SPU_IRQ_ENA_DMA_FRAME_IRQ0_ENA_SHIFT)
#define  LCD2_SPU_IRQ_ENA_DMA_FRAME_IRQ0_ENA_REPLACE_VAL(reg,val) (((reg) & ~LCD2_SPU_IRQ_ENA_DMA_FRAME_IRQ0_ENA_MASK) | (((uint32_t)val) << LCD2_SPU_IRQ_ENA_DMA_FRAME_IRQ0_ENA_SHIFT))

#define  LCD2_SPU_IRQ_ENA_DMA_FRAME_IRQ1_ENA_MASK 0x40000000
#define  LCD2_SPU_IRQ_ENA_DMA_FRAME_IRQ1_ENA_SHIFT 30
#define  LCD2_SPU_IRQ_ENA_DMA_FRAME_IRQ1_ENA_MASK_SHIFT(reg) (((reg) & LCD2_SPU_IRQ_ENA_DMA_FRAME_IRQ1_ENA_MASK) >> LCD2_SPU_IRQ_ENA_DMA_FRAME_IRQ1_ENA_SHIFT)
#define  LCD2_SPU_IRQ_ENA_DMA_FRAME_IRQ1_ENA_REPLACE_VAL(reg,val) (((reg) & ~LCD2_SPU_IRQ_ENA_DMA_FRAME_IRQ1_ENA_MASK) | (((uint32_t)val) << LCD2_SPU_IRQ_ENA_DMA_FRAME_IRQ1_ENA_SHIFT))

#define  LCD2_SPU_IRQ_ENA_DMA_FF_UNDERFLOW_ENA_MASK 0x20000000
#define  LCD2_SPU_IRQ_ENA_DMA_FF_UNDERFLOW_ENA_SHIFT 29
#define  LCD2_SPU_IRQ_ENA_DMA_FF_UNDERFLOW_ENA_MASK_SHIFT(reg) (((reg) & LCD2_SPU_IRQ_ENA_DMA_FF_UNDERFLOW_ENA_MASK) >> LCD2_SPU_IRQ_ENA_DMA_FF_UNDERFLOW_ENA_SHIFT)
#define  LCD2_SPU_IRQ_ENA_DMA_FF_UNDERFLOW_ENA_REPLACE_VAL(reg,val) (((reg) & ~LCD2_SPU_IRQ_ENA_DMA_FF_UNDERFLOW_ENA_MASK) | (((uint32_t)val) << LCD2_SPU_IRQ_ENA_DMA_FF_UNDERFLOW_ENA_SHIFT))

#define  LCD2_SPU_IRQ_ENA_M2A_IRQ_ENA_MASK 0x10000000
#define  LCD2_SPU_IRQ_ENA_M2A_IRQ_ENA_SHIFT 28
#define  LCD2_SPU_IRQ_ENA_M2A_IRQ_ENA_MASK_SHIFT(reg) (((reg) & LCD2_SPU_IRQ_ENA_M2A_IRQ_ENA_MASK) >> LCD2_SPU_IRQ_ENA_M2A_IRQ_ENA_SHIFT)
#define  LCD2_SPU_IRQ_ENA_M2A_IRQ_ENA_REPLACE_VAL(reg,val) (((reg) & ~LCD2_SPU_IRQ_ENA_M2A_IRQ_ENA_MASK) | (((uint32_t)val) << LCD2_SPU_IRQ_ENA_M2A_IRQ_ENA_SHIFT))

#define  LCD2_SPU_IRQ_ENA_GRA_FRAME_IRQ0_ENA_MASK 0x8000000
#define  LCD2_SPU_IRQ_ENA_GRA_FRAME_IRQ0_ENA_SHIFT 27
#define  LCD2_SPU_IRQ_ENA_GRA_FRAME_IRQ0_ENA_MASK_SHIFT(reg) (((reg) & LCD2_SPU_IRQ_ENA_GRA_FRAME_IRQ0_ENA_MASK) >> LCD2_SPU_IRQ_ENA_GRA_FRAME_IRQ0_ENA_SHIFT)
#define  LCD2_SPU_IRQ_ENA_GRA_FRAME_IRQ0_ENA_REPLACE_VAL(reg,val) (((reg) & ~LCD2_SPU_IRQ_ENA_GRA_FRAME_IRQ0_ENA_MASK) | (((uint32_t)val) << LCD2_SPU_IRQ_ENA_GRA_FRAME_IRQ0_ENA_SHIFT))

#define  LCD2_SPU_IRQ_ENA_GRA_FRAME_IRQ1_ENA_MASK 0x4000000
#define  LCD2_SPU_IRQ_ENA_GRA_FRAME_IRQ1_ENA_SHIFT 26
#define  LCD2_SPU_IRQ_ENA_GRA_FRAME_IRQ1_ENA_MASK_SHIFT(reg) (((reg) & LCD2_SPU_IRQ_ENA_GRA_FRAME_IRQ1_ENA_MASK) >> LCD2_SPU_IRQ_ENA_GRA_FRAME_IRQ1_ENA_SHIFT)
#define  LCD2_SPU_IRQ_ENA_GRA_FRAME_IRQ1_ENA_REPLACE_VAL(reg,val) (((reg) & ~LCD2_SPU_IRQ_ENA_GRA_FRAME_IRQ1_ENA_MASK) | (((uint32_t)val) << LCD2_SPU_IRQ_ENA_GRA_FRAME_IRQ1_ENA_SHIFT))

#define  LCD2_SPU_IRQ_ENA_GRA_FF_UNDERFLOW_ENA_MASK 0x2000000
#define  LCD2_SPU_IRQ_ENA_GRA_FF_UNDERFLOW_ENA_SHIFT 25
#define  LCD2_SPU_IRQ_ENA_GRA_FF_UNDERFLOW_ENA_MASK_SHIFT(reg) (((reg) & LCD2_SPU_IRQ_ENA_GRA_FF_UNDERFLOW_ENA_MASK) >> LCD2_SPU_IRQ_ENA_GRA_FF_UNDERFLOW_ENA_SHIFT)
#define  LCD2_SPU_IRQ_ENA_GRA_FF_UNDERFLOW_ENA_REPLACE_VAL(reg,val) (((reg) & ~LCD2_SPU_IRQ_ENA_GRA_FF_UNDERFLOW_ENA_MASK) | (((uint32_t)val) << LCD2_SPU_IRQ_ENA_GRA_FF_UNDERFLOW_ENA_SHIFT))

#define  LCD2_SPU_IRQ_ENA_RESERVED1_MASK 0x1000000
#define  LCD2_SPU_IRQ_ENA_RESERVED1_SHIFT 24
#define  LCD2_SPU_IRQ_ENA_RESERVED1_MASK_SHIFT(reg) (((reg) & LCD2_SPU_IRQ_ENA_RESERVED1_MASK) >> LCD2_SPU_IRQ_ENA_RESERVED1_SHIFT)
#define  LCD2_SPU_IRQ_ENA_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~LCD2_SPU_IRQ_ENA_RESERVED1_MASK) | (((uint32_t)val) << LCD2_SPU_IRQ_ENA_RESERVED1_SHIFT))

#define  LCD2_SPU_IRQ_ENA_VSYNC_IRQ_ENA_MASK 0x800000
#define  LCD2_SPU_IRQ_ENA_VSYNC_IRQ_ENA_SHIFT 23
#define  LCD2_SPU_IRQ_ENA_VSYNC_IRQ_ENA_MASK_SHIFT(reg) (((reg) & LCD2_SPU_IRQ_ENA_VSYNC_IRQ_ENA_MASK) >> LCD2_SPU_IRQ_ENA_VSYNC_IRQ_ENA_SHIFT)
#define  LCD2_SPU_IRQ_ENA_VSYNC_IRQ_ENA_REPLACE_VAL(reg,val) (((reg) & ~LCD2_SPU_IRQ_ENA_VSYNC_IRQ_ENA_MASK) | (((uint32_t)val) << LCD2_SPU_IRQ_ENA_VSYNC_IRQ_ENA_SHIFT))

#define  LCD2_SPU_IRQ_ENA_DUMB_FRAMEDONE_ENA_MASK 0x400000
#define  LCD2_SPU_IRQ_ENA_DUMB_FRAMEDONE_ENA_SHIFT 22
#define  LCD2_SPU_IRQ_ENA_DUMB_FRAMEDONE_ENA_MASK_SHIFT(reg) (((reg) & LCD2_SPU_IRQ_ENA_DUMB_FRAMEDONE_ENA_MASK) >> LCD2_SPU_IRQ_ENA_DUMB_FRAMEDONE_ENA_SHIFT)
#define  LCD2_SPU_IRQ_ENA_DUMB_FRAMEDONE_ENA_REPLACE_VAL(reg,val) (((reg) & ~LCD2_SPU_IRQ_ENA_DUMB_FRAMEDONE_ENA_MASK) | (((uint32_t)val) << LCD2_SPU_IRQ_ENA_DUMB_FRAMEDONE_ENA_SHIFT))

#define  LCD2_SPU_IRQ_ENA_TWC_FRAMEDONE_ENA_MASK 0x200000
#define  LCD2_SPU_IRQ_ENA_TWC_FRAMEDONE_ENA_SHIFT 21
#define  LCD2_SPU_IRQ_ENA_TWC_FRAMEDONE_ENA_MASK_SHIFT(reg) (((reg) & LCD2_SPU_IRQ_ENA_TWC_FRAMEDONE_ENA_MASK) >> LCD2_SPU_IRQ_ENA_TWC_FRAMEDONE_ENA_SHIFT)
#define  LCD2_SPU_IRQ_ENA_TWC_FRAMEDONE_ENA_REPLACE_VAL(reg,val) (((reg) & ~LCD2_SPU_IRQ_ENA_TWC_FRAMEDONE_ENA_MASK) | (((uint32_t)val) << LCD2_SPU_IRQ_ENA_TWC_FRAMEDONE_ENA_SHIFT))

#define  LCD2_SPU_IRQ_ENA_RESERVED2_MASK 0x100000
#define  LCD2_SPU_IRQ_ENA_RESERVED2_SHIFT 20
#define  LCD2_SPU_IRQ_ENA_RESERVED2_MASK_SHIFT(reg) (((reg) & LCD2_SPU_IRQ_ENA_RESERVED2_MASK) >> LCD2_SPU_IRQ_ENA_RESERVED2_SHIFT)
#define  LCD2_SPU_IRQ_ENA_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~LCD2_SPU_IRQ_ENA_RESERVED2_MASK) | (((uint32_t)val) << LCD2_SPU_IRQ_ENA_RESERVED2_SHIFT))

#define  LCD2_SPU_IRQ_ENA_SLV_IRQ_ENA_MASK 0x80000
#define  LCD2_SPU_IRQ_ENA_SLV_IRQ_ENA_SHIFT 19
#define  LCD2_SPU_IRQ_ENA_SLV_IRQ_ENA_MASK_SHIFT(reg) (((reg) & LCD2_SPU_IRQ_ENA_SLV_IRQ_ENA_MASK) >> LCD2_SPU_IRQ_ENA_SLV_IRQ_ENA_SHIFT)
#define  LCD2_SPU_IRQ_ENA_SLV_IRQ_ENA_REPLACE_VAL(reg,val) (((reg) & ~LCD2_SPU_IRQ_ENA_SLV_IRQ_ENA_MASK) | (((uint32_t)val) << LCD2_SPU_IRQ_ENA_SLV_IRQ_ENA_SHIFT))

#define  LCD2_SPU_IRQ_ENA_RESERVED3_MASK 0x40000
#define  LCD2_SPU_IRQ_ENA_RESERVED3_SHIFT 18
#define  LCD2_SPU_IRQ_ENA_RESERVED3_MASK_SHIFT(reg) (((reg) & LCD2_SPU_IRQ_ENA_RESERVED3_MASK) >> LCD2_SPU_IRQ_ENA_RESERVED3_SHIFT)
#define  LCD2_SPU_IRQ_ENA_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~LCD2_SPU_IRQ_ENA_RESERVED3_MASK) | (((uint32_t)val) << LCD2_SPU_IRQ_ENA_RESERVED3_SHIFT))

#define  LCD2_SPU_IRQ_ENA_RESERVED4_MASK 0x20000
#define  LCD2_SPU_IRQ_ENA_RESERVED4_SHIFT 17
#define  LCD2_SPU_IRQ_ENA_RESERVED4_MASK_SHIFT(reg) (((reg) & LCD2_SPU_IRQ_ENA_RESERVED4_MASK) >> LCD2_SPU_IRQ_ENA_RESERVED4_SHIFT)
#define  LCD2_SPU_IRQ_ENA_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~LCD2_SPU_IRQ_ENA_RESERVED4_MASK) | (((uint32_t)val) << LCD2_SPU_IRQ_ENA_RESERVED4_SHIFT))

#define  LCD2_SPU_IRQ_ENA_ERR_IRQ_ENA_MASK 0x10000
#define  LCD2_SPU_IRQ_ENA_ERR_IRQ_ENA_SHIFT 16
#define  LCD2_SPU_IRQ_ENA_ERR_IRQ_ENA_MASK_SHIFT(reg) (((reg) & LCD2_SPU_IRQ_ENA_ERR_IRQ_ENA_MASK) >> LCD2_SPU_IRQ_ENA_ERR_IRQ_ENA_SHIFT)
#define  LCD2_SPU_IRQ_ENA_ERR_IRQ_ENA_REPLACE_VAL(reg,val) (((reg) & ~LCD2_SPU_IRQ_ENA_ERR_IRQ_ENA_MASK) | (((uint32_t)val) << LCD2_SPU_IRQ_ENA_ERR_IRQ_ENA_SHIFT))

#define  LCD2_SPU_IRQ_ENA_RESERVED5_MASK 0x8000
#define  LCD2_SPU_IRQ_ENA_RESERVED5_SHIFT 15
#define  LCD2_SPU_IRQ_ENA_RESERVED5_MASK_SHIFT(reg) (((reg) & LCD2_SPU_IRQ_ENA_RESERVED5_MASK) >> LCD2_SPU_IRQ_ENA_RESERVED5_SHIFT)
#define  LCD2_SPU_IRQ_ENA_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~LCD2_SPU_IRQ_ENA_RESERVED5_MASK) | (((uint32_t)val) << LCD2_SPU_IRQ_ENA_RESERVED5_SHIFT))

#define  LCD2_SPU_IRQ_ENA_RESERVED6_MASK 0x4000
#define  LCD2_SPU_IRQ_ENA_RESERVED6_SHIFT 14
#define  LCD2_SPU_IRQ_ENA_RESERVED6_MASK_SHIFT(reg) (((reg) & LCD2_SPU_IRQ_ENA_RESERVED6_MASK) >> LCD2_SPU_IRQ_ENA_RESERVED6_SHIFT)
#define  LCD2_SPU_IRQ_ENA_RESERVED6_REPLACE_VAL(reg,val) (((reg) & ~LCD2_SPU_IRQ_ENA_RESERVED6_MASK) | (((uint32_t)val) << LCD2_SPU_IRQ_ENA_RESERVED6_SHIFT))

#define  LCD2_SPU_IRQ_ENA_RESERVED7_MASK 0x2000
#define  LCD2_SPU_IRQ_ENA_RESERVED7_SHIFT 13
#define  LCD2_SPU_IRQ_ENA_RESERVED7_MASK_SHIFT(reg) (((reg) & LCD2_SPU_IRQ_ENA_RESERVED7_MASK) >> LCD2_SPU_IRQ_ENA_RESERVED7_SHIFT)
#define  LCD2_SPU_IRQ_ENA_RESERVED7_REPLACE_VAL(reg,val) (((reg) & ~LCD2_SPU_IRQ_ENA_RESERVED7_MASK) | (((uint32_t)val) << LCD2_SPU_IRQ_ENA_RESERVED7_SHIFT))

#define  LCD2_SPU_IRQ_ENA_RESERVED8_MASK 0x1000
#define  LCD2_SPU_IRQ_ENA_RESERVED8_SHIFT 12
#define  LCD2_SPU_IRQ_ENA_RESERVED8_MASK_SHIFT(reg) (((reg) & LCD2_SPU_IRQ_ENA_RESERVED8_MASK) >> LCD2_SPU_IRQ_ENA_RESERVED8_SHIFT)
#define  LCD2_SPU_IRQ_ENA_RESERVED8_REPLACE_VAL(reg,val) (((reg) & ~LCD2_SPU_IRQ_ENA_RESERVED8_MASK) | (((uint32_t)val) << LCD2_SPU_IRQ_ENA_RESERVED8_SHIFT))

#define  LCD2_SPU_IRQ_ENA_RESERVED9_MASK 0x800
#define  LCD2_SPU_IRQ_ENA_RESERVED9_SHIFT 11
#define  LCD2_SPU_IRQ_ENA_RESERVED9_MASK_SHIFT(reg) (((reg) & LCD2_SPU_IRQ_ENA_RESERVED9_MASK) >> LCD2_SPU_IRQ_ENA_RESERVED9_SHIFT)
#define  LCD2_SPU_IRQ_ENA_RESERVED9_REPLACE_VAL(reg,val) (((reg) & ~LCD2_SPU_IRQ_ENA_RESERVED9_MASK) | (((uint32_t)val) << LCD2_SPU_IRQ_ENA_RESERVED9_SHIFT))

#define  LCD2_SPU_IRQ_ENA_RESERVED10_MASK 0x400
#define  LCD2_SPU_IRQ_ENA_RESERVED10_SHIFT 10
#define  LCD2_SPU_IRQ_ENA_RESERVED10_MASK_SHIFT(reg) (((reg) & LCD2_SPU_IRQ_ENA_RESERVED10_MASK) >> LCD2_SPU_IRQ_ENA_RESERVED10_SHIFT)
#define  LCD2_SPU_IRQ_ENA_RESERVED10_REPLACE_VAL(reg,val) (((reg) & ~LCD2_SPU_IRQ_ENA_RESERVED10_MASK) | (((uint32_t)val) << LCD2_SPU_IRQ_ENA_RESERVED10_SHIFT))

#define  LCD2_SPU_IRQ_ENA_RESERVED11_MASK 0x200
#define  LCD2_SPU_IRQ_ENA_RESERVED11_SHIFT 9
#define  LCD2_SPU_IRQ_ENA_RESERVED11_MASK_SHIFT(reg) (((reg) & LCD2_SPU_IRQ_ENA_RESERVED11_MASK) >> LCD2_SPU_IRQ_ENA_RESERVED11_SHIFT)
#define  LCD2_SPU_IRQ_ENA_RESERVED11_REPLACE_VAL(reg,val) (((reg) & ~LCD2_SPU_IRQ_ENA_RESERVED11_MASK) | (((uint32_t)val) << LCD2_SPU_IRQ_ENA_RESERVED11_SHIFT))

#define  LCD2_SPU_IRQ_ENA_RESERVED12_MASK 0x100
#define  LCD2_SPU_IRQ_ENA_RESERVED12_SHIFT 8
#define  LCD2_SPU_IRQ_ENA_RESERVED12_MASK_SHIFT(reg) (((reg) & LCD2_SPU_IRQ_ENA_RESERVED12_MASK) >> LCD2_SPU_IRQ_ENA_RESERVED12_SHIFT)
#define  LCD2_SPU_IRQ_ENA_RESERVED12_REPLACE_VAL(reg,val) (((reg) & ~LCD2_SPU_IRQ_ENA_RESERVED12_MASK) | (((uint32_t)val) << LCD2_SPU_IRQ_ENA_RESERVED12_SHIFT))

#define  LCD2_SPU_IRQ_ENA_RESERVED13_MASK 0xff
#define  LCD2_SPU_IRQ_ENA_RESERVED13_SHIFT 0
#define  LCD2_SPU_IRQ_ENA_RESERVED13_MASK_SHIFT(reg) (((reg) & LCD2_SPU_IRQ_ENA_RESERVED13_MASK) >> LCD2_SPU_IRQ_ENA_RESERVED13_SHIFT)
#define  LCD2_SPU_IRQ_ENA_RESERVED13_REPLACE_VAL(reg,val) (((reg) & ~LCD2_SPU_IRQ_ENA_RESERVED13_MASK) | (((uint32_t)val) << LCD2_SPU_IRQ_ENA_RESERVED13_SHIFT))

//====================================================================
//Register: LCD Interrupt Status Register (SPU_IRQ_ISR)
//====================================================================

#define  LCD2_SPU_IRQ_ISR_DMA_FRAME_IRQ0_MASK 0x80000000
#define  LCD2_SPU_IRQ_ISR_DMA_FRAME_IRQ0_SHIFT 31
#define  LCD2_SPU_IRQ_ISR_DMA_FRAME_IRQ0_MASK_SHIFT(reg) (((reg) & LCD2_SPU_IRQ_ISR_DMA_FRAME_IRQ0_MASK) >> LCD2_SPU_IRQ_ISR_DMA_FRAME_IRQ0_SHIFT)
#define  LCD2_SPU_IRQ_ISR_DMA_FRAME_IRQ0_REPLACE_VAL(reg,val) (((reg) & ~LCD2_SPU_IRQ_ISR_DMA_FRAME_IRQ0_MASK) | (((uint32_t)val) << LCD2_SPU_IRQ_ISR_DMA_FRAME_IRQ0_SHIFT))

#define  LCD2_SPU_IRQ_ISR_DMA_FRAME_IRQ1_MASK 0x40000000
#define  LCD2_SPU_IRQ_ISR_DMA_FRAME_IRQ1_SHIFT 30
#define  LCD2_SPU_IRQ_ISR_DMA_FRAME_IRQ1_MASK_SHIFT(reg) (((reg) & LCD2_SPU_IRQ_ISR_DMA_FRAME_IRQ1_MASK) >> LCD2_SPU_IRQ_ISR_DMA_FRAME_IRQ1_SHIFT)
#define  LCD2_SPU_IRQ_ISR_DMA_FRAME_IRQ1_REPLACE_VAL(reg,val) (((reg) & ~LCD2_SPU_IRQ_ISR_DMA_FRAME_IRQ1_MASK) | (((uint32_t)val) << LCD2_SPU_IRQ_ISR_DMA_FRAME_IRQ1_SHIFT))

#define  LCD2_SPU_IRQ_ISR_DMA_FF_UNDERFLOW_MASK 0x20000000
#define  LCD2_SPU_IRQ_ISR_DMA_FF_UNDERFLOW_SHIFT 29
#define  LCD2_SPU_IRQ_ISR_DMA_FF_UNDERFLOW_MASK_SHIFT(reg) (((reg) & LCD2_SPU_IRQ_ISR_DMA_FF_UNDERFLOW_MASK) >> LCD2_SPU_IRQ_ISR_DMA_FF_UNDERFLOW_SHIFT)
#define  LCD2_SPU_IRQ_ISR_DMA_FF_UNDERFLOW_REPLACE_VAL(reg,val) (((reg) & ~LCD2_SPU_IRQ_ISR_DMA_FF_UNDERFLOW_MASK) | (((uint32_t)val) << LCD2_SPU_IRQ_ISR_DMA_FF_UNDERFLOW_SHIFT))

#define  LCD2_SPU_IRQ_ISR_M2A_IRQ_MASK 0x10000000
#define  LCD2_SPU_IRQ_ISR_M2A_IRQ_SHIFT 28
#define  LCD2_SPU_IRQ_ISR_M2A_IRQ_MASK_SHIFT(reg) (((reg) & LCD2_SPU_IRQ_ISR_M2A_IRQ_MASK) >> LCD2_SPU_IRQ_ISR_M2A_IRQ_SHIFT)
#define  LCD2_SPU_IRQ_ISR_M2A_IRQ_REPLACE_VAL(reg,val) (((reg) & ~LCD2_SPU_IRQ_ISR_M2A_IRQ_MASK) | (((uint32_t)val) << LCD2_SPU_IRQ_ISR_M2A_IRQ_SHIFT))

#define  LCD2_SPU_IRQ_ISR_GRA_FRAME_IRQ0_MASK 0x8000000
#define  LCD2_SPU_IRQ_ISR_GRA_FRAME_IRQ0_SHIFT 27
#define  LCD2_SPU_IRQ_ISR_GRA_FRAME_IRQ0_MASK_SHIFT(reg) (((reg) & LCD2_SPU_IRQ_ISR_GRA_FRAME_IRQ0_MASK) >> LCD2_SPU_IRQ_ISR_GRA_FRAME_IRQ0_SHIFT)
#define  LCD2_SPU_IRQ_ISR_GRA_FRAME_IRQ0_REPLACE_VAL(reg,val) (((reg) & ~LCD2_SPU_IRQ_ISR_GRA_FRAME_IRQ0_MASK) | (((uint32_t)val) << LCD2_SPU_IRQ_ISR_GRA_FRAME_IRQ0_SHIFT))

#define  LCD2_SPU_IRQ_ISR_GRA_FRAME_IRQ1_MASK 0x4000000
#define  LCD2_SPU_IRQ_ISR_GRA_FRAME_IRQ1_SHIFT 26
#define  LCD2_SPU_IRQ_ISR_GRA_FRAME_IRQ1_MASK_SHIFT(reg) (((reg) & LCD2_SPU_IRQ_ISR_GRA_FRAME_IRQ1_MASK) >> LCD2_SPU_IRQ_ISR_GRA_FRAME_IRQ1_SHIFT)
#define  LCD2_SPU_IRQ_ISR_GRA_FRAME_IRQ1_REPLACE_VAL(reg,val) (((reg) & ~LCD2_SPU_IRQ_ISR_GRA_FRAME_IRQ1_MASK) | (((uint32_t)val) << LCD2_SPU_IRQ_ISR_GRA_FRAME_IRQ1_SHIFT))

#define  LCD2_SPU_IRQ_ISR_GRA_FF_UNDERFLOW_MASK 0x2000000
#define  LCD2_SPU_IRQ_ISR_GRA_FF_UNDERFLOW_SHIFT 25
#define  LCD2_SPU_IRQ_ISR_GRA_FF_UNDERFLOW_MASK_SHIFT(reg) (((reg) & LCD2_SPU_IRQ_ISR_GRA_FF_UNDERFLOW_MASK) >> LCD2_SPU_IRQ_ISR_GRA_FF_UNDERFLOW_SHIFT)
#define  LCD2_SPU_IRQ_ISR_GRA_FF_UNDERFLOW_REPLACE_VAL(reg,val) (((reg) & ~LCD2_SPU_IRQ_ISR_GRA_FF_UNDERFLOW_MASK) | (((uint32_t)val) << LCD2_SPU_IRQ_ISR_GRA_FF_UNDERFLOW_SHIFT))

#define  LCD2_SPU_IRQ_ISR_RESERVED1_MASK 0x1000000
#define  LCD2_SPU_IRQ_ISR_RESERVED1_SHIFT 24
#define  LCD2_SPU_IRQ_ISR_RESERVED1_MASK_SHIFT(reg) (((reg) & LCD2_SPU_IRQ_ISR_RESERVED1_MASK) >> LCD2_SPU_IRQ_ISR_RESERVED1_SHIFT)
#define  LCD2_SPU_IRQ_ISR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~LCD2_SPU_IRQ_ISR_RESERVED1_MASK) | (((uint32_t)val) << LCD2_SPU_IRQ_ISR_RESERVED1_SHIFT))

#define  LCD2_SPU_IRQ_ISR_PN_VSYNC_IRQ_MASK 0x800000
#define  LCD2_SPU_IRQ_ISR_PN_VSYNC_IRQ_SHIFT 23
#define  LCD2_SPU_IRQ_ISR_PN_VSYNC_IRQ_MASK_SHIFT(reg) (((reg) & LCD2_SPU_IRQ_ISR_PN_VSYNC_IRQ_MASK) >> LCD2_SPU_IRQ_ISR_PN_VSYNC_IRQ_SHIFT)
#define  LCD2_SPU_IRQ_ISR_PN_VSYNC_IRQ_REPLACE_VAL(reg,val) (((reg) & ~LCD2_SPU_IRQ_ISR_PN_VSYNC_IRQ_MASK) | (((uint32_t)val) << LCD2_SPU_IRQ_ISR_PN_VSYNC_IRQ_SHIFT))

#define  LCD2_SPU_IRQ_ISR_DUMB_FRAMEDONE_MASK 0x400000
#define  LCD2_SPU_IRQ_ISR_DUMB_FRAMEDONE_SHIFT 22
#define  LCD2_SPU_IRQ_ISR_DUMB_FRAMEDONE_MASK_SHIFT(reg) (((reg) & LCD2_SPU_IRQ_ISR_DUMB_FRAMEDONE_MASK) >> LCD2_SPU_IRQ_ISR_DUMB_FRAMEDONE_SHIFT)
#define  LCD2_SPU_IRQ_ISR_DUMB_FRAMEDONE_REPLACE_VAL(reg,val) (((reg) & ~LCD2_SPU_IRQ_ISR_DUMB_FRAMEDONE_MASK) | (((uint32_t)val) << LCD2_SPU_IRQ_ISR_DUMB_FRAMEDONE_SHIFT))

#define  LCD2_SPU_IRQ_ISR_TXC_FRAMEDONE_MASK 0x200000
#define  LCD2_SPU_IRQ_ISR_TXC_FRAMEDONE_SHIFT 21
#define  LCD2_SPU_IRQ_ISR_TXC_FRAMEDONE_MASK_SHIFT(reg) (((reg) & LCD2_SPU_IRQ_ISR_TXC_FRAMEDONE_MASK) >> LCD2_SPU_IRQ_ISR_TXC_FRAMEDONE_SHIFT)
#define  LCD2_SPU_IRQ_ISR_TXC_FRAMEDONE_REPLACE_VAL(reg,val) (((reg) & ~LCD2_SPU_IRQ_ISR_TXC_FRAMEDONE_MASK) | (((uint32_t)val) << LCD2_SPU_IRQ_ISR_TXC_FRAMEDONE_SHIFT))

#define  LCD2_SPU_IRQ_ISR_RESERVED2_MASK 0x100000
#define  LCD2_SPU_IRQ_ISR_RESERVED2_SHIFT 20
#define  LCD2_SPU_IRQ_ISR_RESERVED2_MASK_SHIFT(reg) (((reg) & LCD2_SPU_IRQ_ISR_RESERVED2_MASK) >> LCD2_SPU_IRQ_ISR_RESERVED2_SHIFT)
#define  LCD2_SPU_IRQ_ISR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~LCD2_SPU_IRQ_ISR_RESERVED2_MASK) | (((uint32_t)val) << LCD2_SPU_IRQ_ISR_RESERVED2_SHIFT))

#define  LCD2_SPU_IRQ_ISR_SLV_IRQ_MASK 0x80000
#define  LCD2_SPU_IRQ_ISR_SLV_IRQ_SHIFT 19
#define  LCD2_SPU_IRQ_ISR_SLV_IRQ_MASK_SHIFT(reg) (((reg) & LCD2_SPU_IRQ_ISR_SLV_IRQ_MASK) >> LCD2_SPU_IRQ_ISR_SLV_IRQ_SHIFT)
#define  LCD2_SPU_IRQ_ISR_SLV_IRQ_REPLACE_VAL(reg,val) (((reg) & ~LCD2_SPU_IRQ_ISR_SLV_IRQ_MASK) | (((uint32_t)val) << LCD2_SPU_IRQ_ISR_SLV_IRQ_SHIFT))

#define  LCD2_SPU_IRQ_ISR_RESERVED3_MASK 0x40000
#define  LCD2_SPU_IRQ_ISR_RESERVED3_SHIFT 18
#define  LCD2_SPU_IRQ_ISR_RESERVED3_MASK_SHIFT(reg) (((reg) & LCD2_SPU_IRQ_ISR_RESERVED3_MASK) >> LCD2_SPU_IRQ_ISR_RESERVED3_SHIFT)
#define  LCD2_SPU_IRQ_ISR_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~LCD2_SPU_IRQ_ISR_RESERVED3_MASK) | (((uint32_t)val) << LCD2_SPU_IRQ_ISR_RESERVED3_SHIFT))

#define  LCD2_SPU_IRQ_ISR_RESERVED4_MASK 0x20000
#define  LCD2_SPU_IRQ_ISR_RESERVED4_SHIFT 17
#define  LCD2_SPU_IRQ_ISR_RESERVED4_MASK_SHIFT(reg) (((reg) & LCD2_SPU_IRQ_ISR_RESERVED4_MASK) >> LCD2_SPU_IRQ_ISR_RESERVED4_SHIFT)
#define  LCD2_SPU_IRQ_ISR_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~LCD2_SPU_IRQ_ISR_RESERVED4_MASK) | (((uint32_t)val) << LCD2_SPU_IRQ_ISR_RESERVED4_SHIFT))

#define  LCD2_SPU_IRQ_ISR_ERR_IRQ_MASK 0x10000
#define  LCD2_SPU_IRQ_ISR_ERR_IRQ_SHIFT 16
#define  LCD2_SPU_IRQ_ISR_ERR_IRQ_MASK_SHIFT(reg) (((reg) & LCD2_SPU_IRQ_ISR_ERR_IRQ_MASK) >> LCD2_SPU_IRQ_ISR_ERR_IRQ_SHIFT)
#define  LCD2_SPU_IRQ_ISR_ERR_IRQ_REPLACE_VAL(reg,val) (((reg) & ~LCD2_SPU_IRQ_ISR_ERR_IRQ_MASK) | (((uint32_t)val) << LCD2_SPU_IRQ_ISR_ERR_IRQ_SHIFT))

#define  LCD2_SPU_IRQ_ISR_RESERVED5_MASK 0x8000
#define  LCD2_SPU_IRQ_ISR_RESERVED5_SHIFT 15
#define  LCD2_SPU_IRQ_ISR_RESERVED5_MASK_SHIFT(reg) (((reg) & LCD2_SPU_IRQ_ISR_RESERVED5_MASK) >> LCD2_SPU_IRQ_ISR_RESERVED5_SHIFT)
#define  LCD2_SPU_IRQ_ISR_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~LCD2_SPU_IRQ_ISR_RESERVED5_MASK) | (((uint32_t)val) << LCD2_SPU_IRQ_ISR_RESERVED5_SHIFT))

#define  LCD2_SPU_IRQ_ISR_RESERVED6_MASK 0x4000
#define  LCD2_SPU_IRQ_ISR_RESERVED6_SHIFT 14
#define  LCD2_SPU_IRQ_ISR_RESERVED6_MASK_SHIFT(reg) (((reg) & LCD2_SPU_IRQ_ISR_RESERVED6_MASK) >> LCD2_SPU_IRQ_ISR_RESERVED6_SHIFT)
#define  LCD2_SPU_IRQ_ISR_RESERVED6_REPLACE_VAL(reg,val) (((reg) & ~LCD2_SPU_IRQ_ISR_RESERVED6_MASK) | (((uint32_t)val) << LCD2_SPU_IRQ_ISR_RESERVED6_SHIFT))

#define  LCD2_SPU_IRQ_ISR_RESERVED7_MASK 0x2000
#define  LCD2_SPU_IRQ_ISR_RESERVED7_SHIFT 13
#define  LCD2_SPU_IRQ_ISR_RESERVED7_MASK_SHIFT(reg) (((reg) & LCD2_SPU_IRQ_ISR_RESERVED7_MASK) >> LCD2_SPU_IRQ_ISR_RESERVED7_SHIFT)
#define  LCD2_SPU_IRQ_ISR_RESERVED7_REPLACE_VAL(reg,val) (((reg) & ~LCD2_SPU_IRQ_ISR_RESERVED7_MASK) | (((uint32_t)val) << LCD2_SPU_IRQ_ISR_RESERVED7_SHIFT))

#define  LCD2_SPU_IRQ_ISR_RESERVED8_MASK 0x1000
#define  LCD2_SPU_IRQ_ISR_RESERVED8_SHIFT 12
#define  LCD2_SPU_IRQ_ISR_RESERVED8_MASK_SHIFT(reg) (((reg) & LCD2_SPU_IRQ_ISR_RESERVED8_MASK) >> LCD2_SPU_IRQ_ISR_RESERVED8_SHIFT)
#define  LCD2_SPU_IRQ_ISR_RESERVED8_REPLACE_VAL(reg,val) (((reg) & ~LCD2_SPU_IRQ_ISR_RESERVED8_MASK) | (((uint32_t)val) << LCD2_SPU_IRQ_ISR_RESERVED8_SHIFT))

#define  LCD2_SPU_IRQ_ISR_RESERVED9_MASK 0x800
#define  LCD2_SPU_IRQ_ISR_RESERVED9_SHIFT 11
#define  LCD2_SPU_IRQ_ISR_RESERVED9_MASK_SHIFT(reg) (((reg) & LCD2_SPU_IRQ_ISR_RESERVED9_MASK) >> LCD2_SPU_IRQ_ISR_RESERVED9_SHIFT)
#define  LCD2_SPU_IRQ_ISR_RESERVED9_REPLACE_VAL(reg,val) (((reg) & ~LCD2_SPU_IRQ_ISR_RESERVED9_MASK) | (((uint32_t)val) << LCD2_SPU_IRQ_ISR_RESERVED9_SHIFT))

#define  LCD2_SPU_IRQ_ISR_RESERVED10_MASK 0x400
#define  LCD2_SPU_IRQ_ISR_RESERVED10_SHIFT 10
#define  LCD2_SPU_IRQ_ISR_RESERVED10_MASK_SHIFT(reg) (((reg) & LCD2_SPU_IRQ_ISR_RESERVED10_MASK) >> LCD2_SPU_IRQ_ISR_RESERVED10_SHIFT)
#define  LCD2_SPU_IRQ_ISR_RESERVED10_REPLACE_VAL(reg,val) (((reg) & ~LCD2_SPU_IRQ_ISR_RESERVED10_MASK) | (((uint32_t)val) << LCD2_SPU_IRQ_ISR_RESERVED10_SHIFT))

#define  LCD2_SPU_IRQ_ISR_RESERVED11_MASK 0x200
#define  LCD2_SPU_IRQ_ISR_RESERVED11_SHIFT 9
#define  LCD2_SPU_IRQ_ISR_RESERVED11_MASK_SHIFT(reg) (((reg) & LCD2_SPU_IRQ_ISR_RESERVED11_MASK) >> LCD2_SPU_IRQ_ISR_RESERVED11_SHIFT)
#define  LCD2_SPU_IRQ_ISR_RESERVED11_REPLACE_VAL(reg,val) (((reg) & ~LCD2_SPU_IRQ_ISR_RESERVED11_MASK) | (((uint32_t)val) << LCD2_SPU_IRQ_ISR_RESERVED11_SHIFT))

#define  LCD2_SPU_IRQ_ISR_RESERVED12_MASK 0x100
#define  LCD2_SPU_IRQ_ISR_RESERVED12_SHIFT 8
#define  LCD2_SPU_IRQ_ISR_RESERVED12_MASK_SHIFT(reg) (((reg) & LCD2_SPU_IRQ_ISR_RESERVED12_MASK) >> LCD2_SPU_IRQ_ISR_RESERVED12_SHIFT)
#define  LCD2_SPU_IRQ_ISR_RESERVED12_REPLACE_VAL(reg,val) (((reg) & ~LCD2_SPU_IRQ_ISR_RESERVED12_MASK) | (((uint32_t)val) << LCD2_SPU_IRQ_ISR_RESERVED12_SHIFT))

#define  LCD2_SPU_IRQ_ISR_DMA_FRAME_CNT0_MASK 0x80
#define  LCD2_SPU_IRQ_ISR_DMA_FRAME_CNT0_SHIFT 7
#define  LCD2_SPU_IRQ_ISR_DMA_FRAME_CNT0_MASK_SHIFT(reg) (((reg) & LCD2_SPU_IRQ_ISR_DMA_FRAME_CNT0_MASK) >> LCD2_SPU_IRQ_ISR_DMA_FRAME_CNT0_SHIFT)
#define  LCD2_SPU_IRQ_ISR_DMA_FRAME_CNT0_REPLACE_VAL(reg,val) (((reg) & ~LCD2_SPU_IRQ_ISR_DMA_FRAME_CNT0_MASK) | (((uint32_t)val) << LCD2_SPU_IRQ_ISR_DMA_FRAME_CNT0_SHIFT))

#define  LCD2_SPU_IRQ_ISR_GRA_FRAME_CNT0_MASK 0x40
#define  LCD2_SPU_IRQ_ISR_GRA_FRAME_CNT0_SHIFT 6
#define  LCD2_SPU_IRQ_ISR_GRA_FRAME_CNT0_MASK_SHIFT(reg) (((reg) & LCD2_SPU_IRQ_ISR_GRA_FRAME_CNT0_MASK) >> LCD2_SPU_IRQ_ISR_GRA_FRAME_CNT0_SHIFT)
#define  LCD2_SPU_IRQ_ISR_GRA_FRAME_CNT0_REPLACE_VAL(reg,val) (((reg) & ~LCD2_SPU_IRQ_ISR_GRA_FRAME_CNT0_MASK) | (((uint32_t)val) << LCD2_SPU_IRQ_ISR_GRA_FRAME_CNT0_SHIFT))

#define  LCD2_SPU_IRQ_ISR_RESERVED13_MASK 0x20
#define  LCD2_SPU_IRQ_ISR_RESERVED13_SHIFT 5
#define  LCD2_SPU_IRQ_ISR_RESERVED13_MASK_SHIFT(reg) (((reg) & LCD2_SPU_IRQ_ISR_RESERVED13_MASK) >> LCD2_SPU_IRQ_ISR_RESERVED13_SHIFT)
#define  LCD2_SPU_IRQ_ISR_RESERVED13_REPLACE_VAL(reg,val) (((reg) & ~LCD2_SPU_IRQ_ISR_RESERVED13_MASK) | (((uint32_t)val) << LCD2_SPU_IRQ_ISR_RESERVED13_SHIFT))

#define  LCD2_SPU_IRQ_ISR_RESERVED14_MASK 0x10
#define  LCD2_SPU_IRQ_ISR_RESERVED14_SHIFT 4
#define  LCD2_SPU_IRQ_ISR_RESERVED14_MASK_SHIFT(reg) (((reg) & LCD2_SPU_IRQ_ISR_RESERVED14_MASK) >> LCD2_SPU_IRQ_ISR_RESERVED14_SHIFT)
#define  LCD2_SPU_IRQ_ISR_RESERVED14_REPLACE_VAL(reg,val) (((reg) & ~LCD2_SPU_IRQ_ISR_RESERVED14_MASK) | (((uint32_t)val) << LCD2_SPU_IRQ_ISR_RESERVED14_SHIFT))

#define  LCD2_SPU_IRQ_ISR_DMA_FF_EMPTY_MASK 0x8
#define  LCD2_SPU_IRQ_ISR_DMA_FF_EMPTY_SHIFT 3
#define  LCD2_SPU_IRQ_ISR_DMA_FF_EMPTY_MASK_SHIFT(reg) (((reg) & LCD2_SPU_IRQ_ISR_DMA_FF_EMPTY_MASK) >> LCD2_SPU_IRQ_ISR_DMA_FF_EMPTY_SHIFT)
#define  LCD2_SPU_IRQ_ISR_DMA_FF_EMPTY_REPLACE_VAL(reg,val) (((reg) & ~LCD2_SPU_IRQ_ISR_DMA_FF_EMPTY_MASK) | (((uint32_t)val) << LCD2_SPU_IRQ_ISR_DMA_FF_EMPTY_SHIFT))

#define  LCD2_SPU_IRQ_ISR_GRA_FF_EMPTY_MASK 0x4
#define  LCD2_SPU_IRQ_ISR_GRA_FF_EMPTY_SHIFT 2
#define  LCD2_SPU_IRQ_ISR_GRA_FF_EMPTY_MASK_SHIFT(reg) (((reg) & LCD2_SPU_IRQ_ISR_GRA_FF_EMPTY_MASK) >> LCD2_SPU_IRQ_ISR_GRA_FF_EMPTY_SHIFT)
#define  LCD2_SPU_IRQ_ISR_GRA_FF_EMPTY_REPLACE_VAL(reg,val) (((reg) & ~LCD2_SPU_IRQ_ISR_GRA_FF_EMPTY_MASK) | (((uint32_t)val) << LCD2_SPU_IRQ_ISR_GRA_FF_EMPTY_SHIFT))

#define  LCD2_SPU_IRQ_ISR_RESERVED15_MASK 0x2
#define  LCD2_SPU_IRQ_ISR_RESERVED15_SHIFT 1
#define  LCD2_SPU_IRQ_ISR_RESERVED15_MASK_SHIFT(reg) (((reg) & LCD2_SPU_IRQ_ISR_RESERVED15_MASK) >> LCD2_SPU_IRQ_ISR_RESERVED15_SHIFT)
#define  LCD2_SPU_IRQ_ISR_RESERVED15_REPLACE_VAL(reg,val) (((reg) & ~LCD2_SPU_IRQ_ISR_RESERVED15_MASK) | (((uint32_t)val) << LCD2_SPU_IRQ_ISR_RESERVED15_SHIFT))

#define  LCD2_SPU_IRQ_ISR_RESERVED16_MASK 0x1
#define  LCD2_SPU_IRQ_ISR_RESERVED16_SHIFT 0
#define  LCD2_SPU_IRQ_ISR_RESERVED16_MASK_SHIFT(reg) (((reg) & LCD2_SPU_IRQ_ISR_RESERVED16_MASK) >> LCD2_SPU_IRQ_ISR_RESERVED16_SHIFT)
#define  LCD2_SPU_IRQ_ISR_RESERVED16_REPLACE_VAL(reg,val) (((reg) & ~LCD2_SPU_IRQ_ISR_RESERVED16_MASK) | (((uint32_t)val) << LCD2_SPU_IRQ_ISR_RESERVED16_SHIFT))

//====================================================================
//Register: LCD Interrupt Reset Status Register (SPU_IRQ_RSR)
//====================================================================

#define  LCD2_SPU_IRQ_RSR_RSR_MASK 0xffffff00
#define  LCD2_SPU_IRQ_RSR_RSR_SHIFT 8
#define  LCD2_SPU_IRQ_RSR_RSR_MASK_SHIFT(reg) (((reg) & LCD2_SPU_IRQ_RSR_RSR_MASK) >> LCD2_SPU_IRQ_RSR_RSR_SHIFT)
#define  LCD2_SPU_IRQ_RSR_RSR_REPLACE_VAL(reg,val) (((reg) & ~LCD2_SPU_IRQ_RSR_RSR_MASK) | (((uint32_t)val) << LCD2_SPU_IRQ_RSR_RSR_SHIFT))

#define  LCD2_SPU_IRQ_RSR_RESERVED1_MASK 0xff
#define  LCD2_SPU_IRQ_RSR_RESERVED1_SHIFT 0
#define  LCD2_SPU_IRQ_RSR_RESERVED1_MASK_SHIFT(reg) (((reg) & LCD2_SPU_IRQ_RSR_RESERVED1_MASK) >> LCD2_SPU_IRQ_RSR_RESERVED1_SHIFT)
#define  LCD2_SPU_IRQ_RSR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~LCD2_SPU_IRQ_RSR_RESERVED1_MASK) | (((uint32_t)val) << LCD2_SPU_IRQ_RSR_RESERVED1_SHIFT))

//====================================================================
//Register: Panel Path Graphic Partial Display Horizontal Control Register (LCD_GRA_CUTHPXL)
//====================================================================

#define  LCD2_LCD_GRA_CUTHPXL_GRA_CUTCOLOR_7_4_MASK 0xf0000000
#define  LCD2_LCD_GRA_CUTHPXL_GRA_CUTCOLOR_7_4_SHIFT 28
#define  LCD2_LCD_GRA_CUTHPXL_GRA_CUTCOLOR_7_4_MASK_SHIFT(reg) (((reg) & LCD2_LCD_GRA_CUTHPXL_GRA_CUTCOLOR_7_4_MASK) >> LCD2_LCD_GRA_CUTHPXL_GRA_CUTCOLOR_7_4_SHIFT)
#define  LCD2_LCD_GRA_CUTHPXL_GRA_CUTCOLOR_7_4_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_GRA_CUTHPXL_GRA_CUTCOLOR_7_4_MASK) | (((uint32_t)val) << LCD2_LCD_GRA_CUTHPXL_GRA_CUTCOLOR_7_4_SHIFT))

#define  LCD2_LCD_GRA_CUTHPXL_CFG_GRA_CUTHPXL2_MASK 0xfff0000
#define  LCD2_LCD_GRA_CUTHPXL_CFG_GRA_CUTHPXL2_SHIFT 16
#define  LCD2_LCD_GRA_CUTHPXL_CFG_GRA_CUTHPXL2_MASK_SHIFT(reg) (((reg) & LCD2_LCD_GRA_CUTHPXL_CFG_GRA_CUTHPXL2_MASK) >> LCD2_LCD_GRA_CUTHPXL_CFG_GRA_CUTHPXL2_SHIFT)
#define  LCD2_LCD_GRA_CUTHPXL_CFG_GRA_CUTHPXL2_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_GRA_CUTHPXL_CFG_GRA_CUTHPXL2_MASK) | (((uint32_t)val) << LCD2_LCD_GRA_CUTHPXL_CFG_GRA_CUTHPXL2_SHIFT))

#define  LCD2_LCD_GRA_CUTHPXL_GRA_CUTCOLOR_3_0_MASK 0xf000
#define  LCD2_LCD_GRA_CUTHPXL_GRA_CUTCOLOR_3_0_SHIFT 12
#define  LCD2_LCD_GRA_CUTHPXL_GRA_CUTCOLOR_3_0_MASK_SHIFT(reg) (((reg) & LCD2_LCD_GRA_CUTHPXL_GRA_CUTCOLOR_3_0_MASK) >> LCD2_LCD_GRA_CUTHPXL_GRA_CUTCOLOR_3_0_SHIFT)
#define  LCD2_LCD_GRA_CUTHPXL_GRA_CUTCOLOR_3_0_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_GRA_CUTHPXL_GRA_CUTCOLOR_3_0_MASK) | (((uint32_t)val) << LCD2_LCD_GRA_CUTHPXL_GRA_CUTCOLOR_3_0_SHIFT))

#define  LCD2_LCD_GRA_CUTHPXL_CFG_GRA_CUTHPXL1_MASK 0xfff
#define  LCD2_LCD_GRA_CUTHPXL_CFG_GRA_CUTHPXL1_SHIFT 0
#define  LCD2_LCD_GRA_CUTHPXL_CFG_GRA_CUTHPXL1_MASK_SHIFT(reg) (((reg) & LCD2_LCD_GRA_CUTHPXL_CFG_GRA_CUTHPXL1_MASK) >> LCD2_LCD_GRA_CUTHPXL_CFG_GRA_CUTHPXL1_SHIFT)
#define  LCD2_LCD_GRA_CUTHPXL_CFG_GRA_CUTHPXL1_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_GRA_CUTHPXL_CFG_GRA_CUTHPXL1_MASK) | (((uint32_t)val) << LCD2_LCD_GRA_CUTHPXL_CFG_GRA_CUTHPXL1_SHIFT))

//====================================================================
//Register: Panel Path Graphic Partial Display Vertical Control Register (LCD_GRA_CUTVLN)
//====================================================================

#define  LCD2_LCD_GRA_CUTVLN_GRA_CUTCOLOR_15_12_MASK 0xf0000000
#define  LCD2_LCD_GRA_CUTVLN_GRA_CUTCOLOR_15_12_SHIFT 28
#define  LCD2_LCD_GRA_CUTVLN_GRA_CUTCOLOR_15_12_MASK_SHIFT(reg) (((reg) & LCD2_LCD_GRA_CUTVLN_GRA_CUTCOLOR_15_12_MASK) >> LCD2_LCD_GRA_CUTVLN_GRA_CUTCOLOR_15_12_SHIFT)
#define  LCD2_LCD_GRA_CUTVLN_GRA_CUTCOLOR_15_12_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_GRA_CUTVLN_GRA_CUTCOLOR_15_12_MASK) | (((uint32_t)val) << LCD2_LCD_GRA_CUTVLN_GRA_CUTCOLOR_15_12_SHIFT))

#define  LCD2_LCD_GRA_CUTVLN_CFG_GRA_CUTVLN2_MASK 0xfff0000
#define  LCD2_LCD_GRA_CUTVLN_CFG_GRA_CUTVLN2_SHIFT 16
#define  LCD2_LCD_GRA_CUTVLN_CFG_GRA_CUTVLN2_MASK_SHIFT(reg) (((reg) & LCD2_LCD_GRA_CUTVLN_CFG_GRA_CUTVLN2_MASK) >> LCD2_LCD_GRA_CUTVLN_CFG_GRA_CUTVLN2_SHIFT)
#define  LCD2_LCD_GRA_CUTVLN_CFG_GRA_CUTVLN2_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_GRA_CUTVLN_CFG_GRA_CUTVLN2_MASK) | (((uint32_t)val) << LCD2_LCD_GRA_CUTVLN_CFG_GRA_CUTVLN2_SHIFT))

#define  LCD2_LCD_GRA_CUTVLN_GRA_CUTCOLOR_11_8_MASK 0xf000
#define  LCD2_LCD_GRA_CUTVLN_GRA_CUTCOLOR_11_8_SHIFT 12
#define  LCD2_LCD_GRA_CUTVLN_GRA_CUTCOLOR_11_8_MASK_SHIFT(reg) (((reg) & LCD2_LCD_GRA_CUTVLN_GRA_CUTCOLOR_11_8_MASK) >> LCD2_LCD_GRA_CUTVLN_GRA_CUTCOLOR_11_8_SHIFT)
#define  LCD2_LCD_GRA_CUTVLN_GRA_CUTCOLOR_11_8_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_GRA_CUTVLN_GRA_CUTCOLOR_11_8_MASK) | (((uint32_t)val) << LCD2_LCD_GRA_CUTVLN_GRA_CUTCOLOR_11_8_SHIFT))

#define  LCD2_LCD_GRA_CUTVLN_CFG_GRA_CUTVLN1_MASK 0xfff
#define  LCD2_LCD_GRA_CUTVLN_CFG_GRA_CUTVLN1_SHIFT 0
#define  LCD2_LCD_GRA_CUTVLN_CFG_GRA_CUTVLN1_MASK_SHIFT(reg) (((reg) & LCD2_LCD_GRA_CUTVLN_CFG_GRA_CUTVLN1_MASK) >> LCD2_LCD_GRA_CUTVLN_CFG_GRA_CUTVLN1_SHIFT)
#define  LCD2_LCD_GRA_CUTVLN_CFG_GRA_CUTVLN1_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_GRA_CUTVLN_CFG_GRA_CUTVLN1_MASK) | (((uint32_t)val) << LCD2_LCD_GRA_CUTVLN_CFG_GRA_CUTVLN1_SHIFT))

//====================================================================
//Register: LCD Global Control Register (LCD_TOP_CTRL)
//====================================================================

#define  LCD2_LCD_TOP_CTRL_RESERVED1_MASK 0xfffff000
#define  LCD2_LCD_TOP_CTRL_RESERVED1_SHIFT 12
#define  LCD2_LCD_TOP_CTRL_RESERVED1_MASK_SHIFT(reg) (((reg) & LCD2_LCD_TOP_CTRL_RESERVED1_MASK) >> LCD2_LCD_TOP_CTRL_RESERVED1_SHIFT)
#define  LCD2_LCD_TOP_CTRL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_TOP_CTRL_RESERVED1_MASK) | (((uint32_t)val) << LCD2_LCD_TOP_CTRL_RESERVED1_SHIFT))

#define  LCD2_LCD_TOP_CTRL_CFG_GRA_BURST0TO3_MASK 0xc00
#define  LCD2_LCD_TOP_CTRL_CFG_GRA_BURST0TO3_SHIFT 10
#define  LCD2_LCD_TOP_CTRL_CFG_GRA_BURST0TO3_MASK_SHIFT(reg) (((reg) & LCD2_LCD_TOP_CTRL_CFG_GRA_BURST0TO3_MASK) >> LCD2_LCD_TOP_CTRL_CFG_GRA_BURST0TO3_SHIFT)
#define  LCD2_LCD_TOP_CTRL_CFG_GRA_BURST0TO3_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_TOP_CTRL_CFG_GRA_BURST0TO3_MASK) | (((uint32_t)val) << LCD2_LCD_TOP_CTRL_CFG_GRA_BURST0TO3_SHIFT))

#define  LCD2_LCD_TOP_CTRL_CFG_DMA_BURST0TO3_MASK 0x300
#define  LCD2_LCD_TOP_CTRL_CFG_DMA_BURST0TO3_SHIFT 8
#define  LCD2_LCD_TOP_CTRL_CFG_DMA_BURST0TO3_MASK_SHIFT(reg) (((reg) & LCD2_LCD_TOP_CTRL_CFG_DMA_BURST0TO3_MASK) >> LCD2_LCD_TOP_CTRL_CFG_DMA_BURST0TO3_SHIFT)
#define  LCD2_LCD_TOP_CTRL_CFG_DMA_BURST0TO3_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_TOP_CTRL_CFG_DMA_BURST0TO3_MASK) | (((uint32_t)val) << LCD2_LCD_TOP_CTRL_CFG_DMA_BURST0TO3_SHIFT))

#define  LCD2_LCD_TOP_CTRL_CFG_AHB_RDCNT_MASK 0xc0
#define  LCD2_LCD_TOP_CTRL_CFG_AHB_RDCNT_SHIFT 6
#define  LCD2_LCD_TOP_CTRL_CFG_AHB_RDCNT_MASK_SHIFT(reg) (((reg) & LCD2_LCD_TOP_CTRL_CFG_AHB_RDCNT_MASK) >> LCD2_LCD_TOP_CTRL_CFG_AHB_RDCNT_SHIFT)
#define  LCD2_LCD_TOP_CTRL_CFG_AHB_RDCNT_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_TOP_CTRL_CFG_AHB_RDCNT_MASK) | (((uint32_t)val) << LCD2_LCD_TOP_CTRL_CFG_AHB_RDCNT_SHIFT))

#define  LCD2_LCD_TOP_CTRL_CFG_AHB_WRCNT_MASK 0x30
#define  LCD2_LCD_TOP_CTRL_CFG_AHB_WRCNT_SHIFT 4
#define  LCD2_LCD_TOP_CTRL_CFG_AHB_WRCNT_MASK_SHIFT(reg) (((reg) & LCD2_LCD_TOP_CTRL_CFG_AHB_WRCNT_MASK) >> LCD2_LCD_TOP_CTRL_CFG_AHB_WRCNT_SHIFT)
#define  LCD2_LCD_TOP_CTRL_CFG_AHB_WRCNT_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_TOP_CTRL_CFG_AHB_WRCNT_MASK) | (((uint32_t)val) << LCD2_LCD_TOP_CTRL_CFG_AHB_WRCNT_SHIFT))

#define  LCD2_LCD_TOP_CTRL_RESERVED2_MASK 0xf
#define  LCD2_LCD_TOP_CTRL_RESERVED2_SHIFT 0
#define  LCD2_LCD_TOP_CTRL_RESERVED2_MASK_SHIFT(reg) (((reg) & LCD2_LCD_TOP_CTRL_RESERVED2_MASK) >> LCD2_LCD_TOP_CTRL_RESERVED2_SHIFT)
#define  LCD2_LCD_TOP_CTRL_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_TOP_CTRL_RESERVED2_MASK) | (((uint32_t)val) << LCD2_LCD_TOP_CTRL_RESERVED2_SHIFT))

//====================================================================
//Register: LCD Mixed Overlay Control Register (LCD_AFA_ALL2ONE)
//====================================================================

#define  LCD2_LCD_AFA_ALL2ONE_RESERVED1_MASK 0xff000000
#define  LCD2_LCD_AFA_ALL2ONE_RESERVED1_SHIFT 24
#define  LCD2_LCD_AFA_ALL2ONE_RESERVED1_MASK_SHIFT(reg) (((reg) & LCD2_LCD_AFA_ALL2ONE_RESERVED1_MASK) >> LCD2_LCD_AFA_ALL2ONE_RESERVED1_SHIFT)
#define  LCD2_LCD_AFA_ALL2ONE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_AFA_ALL2ONE_RESERVED1_MASK) | (((uint32_t)val) << LCD2_LCD_AFA_ALL2ONE_RESERVED1_SHIFT))

#define  LCD2_LCD_AFA_ALL2ONE_RESERVED2_MASK 0x800000
#define  LCD2_LCD_AFA_ALL2ONE_RESERVED2_SHIFT 23
#define  LCD2_LCD_AFA_ALL2ONE_RESERVED2_MASK_SHIFT(reg) (((reg) & LCD2_LCD_AFA_ALL2ONE_RESERVED2_MASK) >> LCD2_LCD_AFA_ALL2ONE_RESERVED2_SHIFT)
#define  LCD2_LCD_AFA_ALL2ONE_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_AFA_ALL2ONE_RESERVED2_MASK) | (((uint32_t)val) << LCD2_LCD_AFA_ALL2ONE_RESERVED2_SHIFT))

#define  LCD2_LCD_AFA_ALL2ONE_RESERVED3_MASK 0x400000
#define  LCD2_LCD_AFA_ALL2ONE_RESERVED3_SHIFT 22
#define  LCD2_LCD_AFA_ALL2ONE_RESERVED3_MASK_SHIFT(reg) (((reg) & LCD2_LCD_AFA_ALL2ONE_RESERVED3_MASK) >> LCD2_LCD_AFA_ALL2ONE_RESERVED3_SHIFT)
#define  LCD2_LCD_AFA_ALL2ONE_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_AFA_ALL2ONE_RESERVED3_MASK) | (((uint32_t)val) << LCD2_LCD_AFA_ALL2ONE_RESERVED3_SHIFT))

#define  LCD2_LCD_AFA_ALL2ONE_CFG_GRA_2ZMDN_MASK 0x200000
#define  LCD2_LCD_AFA_ALL2ONE_CFG_GRA_2ZMDN_SHIFT 21
#define  LCD2_LCD_AFA_ALL2ONE_CFG_GRA_2ZMDN_MASK_SHIFT(reg) (((reg) & LCD2_LCD_AFA_ALL2ONE_CFG_GRA_2ZMDN_MASK) >> LCD2_LCD_AFA_ALL2ONE_CFG_GRA_2ZMDN_SHIFT)
#define  LCD2_LCD_AFA_ALL2ONE_CFG_GRA_2ZMDN_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_AFA_ALL2ONE_CFG_GRA_2ZMDN_MASK) | (((uint32_t)val) << LCD2_LCD_AFA_ALL2ONE_CFG_GRA_2ZMDN_SHIFT))

#define  LCD2_LCD_AFA_ALL2ONE_CFG_DMA_2ZMDN_MASK 0x100000
#define  LCD2_LCD_AFA_ALL2ONE_CFG_DMA_2ZMDN_SHIFT 20
#define  LCD2_LCD_AFA_ALL2ONE_CFG_DMA_2ZMDN_MASK_SHIFT(reg) (((reg) & LCD2_LCD_AFA_ALL2ONE_CFG_DMA_2ZMDN_MASK) >> LCD2_LCD_AFA_ALL2ONE_CFG_DMA_2ZMDN_SHIFT)
#define  LCD2_LCD_AFA_ALL2ONE_CFG_DMA_2ZMDN_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_AFA_ALL2ONE_CFG_DMA_2ZMDN_MASK) | (((uint32_t)val) << LCD2_LCD_AFA_ALL2ONE_CFG_DMA_2ZMDN_SHIFT))

#define  LCD2_LCD_AFA_ALL2ONE_RESERVED4_MASK 0xc0000
#define  LCD2_LCD_AFA_ALL2ONE_RESERVED4_SHIFT 18
#define  LCD2_LCD_AFA_ALL2ONE_RESERVED4_MASK_SHIFT(reg) (((reg) & LCD2_LCD_AFA_ALL2ONE_RESERVED4_MASK) >> LCD2_LCD_AFA_ALL2ONE_RESERVED4_SHIFT)
#define  LCD2_LCD_AFA_ALL2ONE_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_AFA_ALL2ONE_RESERVED4_MASK) | (((uint32_t)val) << LCD2_LCD_AFA_ALL2ONE_RESERVED4_SHIFT))

#define  LCD2_LCD_AFA_ALL2ONE_RESERVED5_MASK 0x30000
#define  LCD2_LCD_AFA_ALL2ONE_RESERVED5_SHIFT 16
#define  LCD2_LCD_AFA_ALL2ONE_RESERVED5_MASK_SHIFT(reg) (((reg) & LCD2_LCD_AFA_ALL2ONE_RESERVED5_MASK) >> LCD2_LCD_AFA_ALL2ONE_RESERVED5_SHIFT)
#define  LCD2_LCD_AFA_ALL2ONE_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_AFA_ALL2ONE_RESERVED5_MASK) | (((uint32_t)val) << LCD2_LCD_AFA_ALL2ONE_RESERVED5_SHIFT))

#define  LCD2_LCD_AFA_ALL2ONE_RESERVED6_MASK 0xc000
#define  LCD2_LCD_AFA_ALL2ONE_RESERVED6_SHIFT 14
#define  LCD2_LCD_AFA_ALL2ONE_RESERVED6_MASK_SHIFT(reg) (((reg) & LCD2_LCD_AFA_ALL2ONE_RESERVED6_MASK) >> LCD2_LCD_AFA_ALL2ONE_RESERVED6_SHIFT)
#define  LCD2_LCD_AFA_ALL2ONE_RESERVED6_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_AFA_ALL2ONE_RESERVED6_MASK) | (((uint32_t)val) << LCD2_LCD_AFA_ALL2ONE_RESERVED6_SHIFT))

#define  LCD2_LCD_AFA_ALL2ONE_RESERVED7_MASK 0x3000
#define  LCD2_LCD_AFA_ALL2ONE_RESERVED7_SHIFT 12
#define  LCD2_LCD_AFA_ALL2ONE_RESERVED7_MASK_SHIFT(reg) (((reg) & LCD2_LCD_AFA_ALL2ONE_RESERVED7_MASK) >> LCD2_LCD_AFA_ALL2ONE_RESERVED7_SHIFT)
#define  LCD2_LCD_AFA_ALL2ONE_RESERVED7_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_AFA_ALL2ONE_RESERVED7_MASK) | (((uint32_t)val) << LCD2_LCD_AFA_ALL2ONE_RESERVED7_SHIFT))

#define  LCD2_LCD_AFA_ALL2ONE_RESERVED8_MASK 0xc00
#define  LCD2_LCD_AFA_ALL2ONE_RESERVED8_SHIFT 10
#define  LCD2_LCD_AFA_ALL2ONE_RESERVED8_MASK_SHIFT(reg) (((reg) & LCD2_LCD_AFA_ALL2ONE_RESERVED8_MASK) >> LCD2_LCD_AFA_ALL2ONE_RESERVED8_SHIFT)
#define  LCD2_LCD_AFA_ALL2ONE_RESERVED8_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_AFA_ALL2ONE_RESERVED8_MASK) | (((uint32_t)val) << LCD2_LCD_AFA_ALL2ONE_RESERVED8_SHIFT))

#define  LCD2_LCD_AFA_ALL2ONE_RESERVED9_MASK 0x300
#define  LCD2_LCD_AFA_ALL2ONE_RESERVED9_SHIFT 8
#define  LCD2_LCD_AFA_ALL2ONE_RESERVED9_MASK_SHIFT(reg) (((reg) & LCD2_LCD_AFA_ALL2ONE_RESERVED9_MASK) >> LCD2_LCD_AFA_ALL2ONE_RESERVED9_SHIFT)
#define  LCD2_LCD_AFA_ALL2ONE_RESERVED9_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_AFA_ALL2ONE_RESERVED9_MASK) | (((uint32_t)val) << LCD2_LCD_AFA_ALL2ONE_RESERVED9_SHIFT))

#define  LCD2_LCD_AFA_ALL2ONE_RESERVED10_MASK 0xe0
#define  LCD2_LCD_AFA_ALL2ONE_RESERVED10_SHIFT 5
#define  LCD2_LCD_AFA_ALL2ONE_RESERVED10_MASK_SHIFT(reg) (((reg) & LCD2_LCD_AFA_ALL2ONE_RESERVED10_MASK) >> LCD2_LCD_AFA_ALL2ONE_RESERVED10_SHIFT)
#define  LCD2_LCD_AFA_ALL2ONE_RESERVED10_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_AFA_ALL2ONE_RESERVED10_MASK) | (((uint32_t)val) << LCD2_LCD_AFA_ALL2ONE_RESERVED10_SHIFT))

#define  LCD2_LCD_AFA_ALL2ONE_RESERVED11_MASK 0x10
#define  LCD2_LCD_AFA_ALL2ONE_RESERVED11_SHIFT 4
#define  LCD2_LCD_AFA_ALL2ONE_RESERVED11_MASK_SHIFT(reg) (((reg) & LCD2_LCD_AFA_ALL2ONE_RESERVED11_MASK) >> LCD2_LCD_AFA_ALL2ONE_RESERVED11_SHIFT)
#define  LCD2_LCD_AFA_ALL2ONE_RESERVED11_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_AFA_ALL2ONE_RESERVED11_MASK) | (((uint32_t)val) << LCD2_LCD_AFA_ALL2ONE_RESERVED11_SHIFT))

#define  LCD2_LCD_AFA_ALL2ONE_CFG_OVNXT_MASK 0xc
#define  LCD2_LCD_AFA_ALL2ONE_CFG_OVNXT_SHIFT 2
#define  LCD2_LCD_AFA_ALL2ONE_CFG_OVNXT_MASK_SHIFT(reg) (((reg) & LCD2_LCD_AFA_ALL2ONE_CFG_OVNXT_MASK) >> LCD2_LCD_AFA_ALL2ONE_CFG_OVNXT_SHIFT)
#define  LCD2_LCD_AFA_ALL2ONE_CFG_OVNXT_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_AFA_ALL2ONE_CFG_OVNXT_MASK) | (((uint32_t)val) << LCD2_LCD_AFA_ALL2ONE_CFG_OVNXT_SHIFT))

#define  LCD2_LCD_AFA_ALL2ONE_CFG_OVTOP_MASK 0x3
#define  LCD2_LCD_AFA_ALL2ONE_CFG_OVTOP_SHIFT 0
#define  LCD2_LCD_AFA_ALL2ONE_CFG_OVTOP_MASK_SHIFT(reg) (((reg) & LCD2_LCD_AFA_ALL2ONE_CFG_OVTOP_MASK) >> LCD2_LCD_AFA_ALL2ONE_CFG_OVTOP_SHIFT)
#define  LCD2_LCD_AFA_ALL2ONE_CFG_OVTOP_REPLACE_VAL(reg,val) (((reg) & ~LCD2_LCD_AFA_ALL2ONE_CFG_OVTOP_MASK) | (((uint32_t)val) << LCD2_LCD_AFA_ALL2ONE_CFG_OVTOP_SHIFT))

//====================================================================
//Register: MISR Testability Control Register (MISR_CONTROL)
/** \brief The MISR test logic monitors the LCD block's panel I/O interface for pixel data and timing over a programmable number of frames and captures a CRC signature at the end of the elapsed frames.
      <br/>*/
//====================================================================

#define  LCD2_MISR_CONTROL_RESERVED1_MASK 0xfe000000
#define  LCD2_MISR_CONTROL_RESERVED1_SHIFT 25
#define  LCD2_MISR_CONTROL_RESERVED1_MASK_SHIFT(reg) (((reg) & LCD2_MISR_CONTROL_RESERVED1_MASK) >> LCD2_MISR_CONTROL_RESERVED1_SHIFT)
#define  LCD2_MISR_CONTROL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~LCD2_MISR_CONTROL_RESERVED1_MASK) | (((uint32_t)val) << LCD2_MISR_CONTROL_RESERVED1_SHIFT))

#define  LCD2_MISR_CONTROL_MISR_ENA_MASK 0x1000000
#define  LCD2_MISR_CONTROL_MISR_ENA_SHIFT 24
#define  LCD2_MISR_CONTROL_MISR_ENA_MASK_SHIFT(reg) (((reg) & LCD2_MISR_CONTROL_MISR_ENA_MASK) >> LCD2_MISR_CONTROL_MISR_ENA_SHIFT)
#define  LCD2_MISR_CONTROL_MISR_ENA_REPLACE_VAL(reg,val) (((reg) & ~LCD2_MISR_CONTROL_MISR_ENA_MASK) | (((uint32_t)val) << LCD2_MISR_CONTROL_MISR_ENA_SHIFT))

#define  LCD2_MISR_CONTROL_NUM_FRAMES_MASK 0xff0000
#define  LCD2_MISR_CONTROL_NUM_FRAMES_SHIFT 16
#define  LCD2_MISR_CONTROL_NUM_FRAMES_MASK_SHIFT(reg) (((reg) & LCD2_MISR_CONTROL_NUM_FRAMES_MASK) >> LCD2_MISR_CONTROL_NUM_FRAMES_SHIFT)
#define  LCD2_MISR_CONTROL_NUM_FRAMES_REPLACE_VAL(reg,val) (((reg) & ~LCD2_MISR_CONTROL_NUM_FRAMES_MASK) | (((uint32_t)val) << LCD2_MISR_CONTROL_NUM_FRAMES_SHIFT))

#define  LCD2_MISR_CONTROL_MISR_INITVAL_MASK 0xffff
#define  LCD2_MISR_CONTROL_MISR_INITVAL_SHIFT 0
#define  LCD2_MISR_CONTROL_MISR_INITVAL_MASK_SHIFT(reg) (((reg) & LCD2_MISR_CONTROL_MISR_INITVAL_MASK) >> LCD2_MISR_CONTROL_MISR_INITVAL_SHIFT)
#define  LCD2_MISR_CONTROL_MISR_INITVAL_REPLACE_VAL(reg,val) (((reg) & ~LCD2_MISR_CONTROL_MISR_INITVAL_MASK) | (((uint32_t)val) << LCD2_MISR_CONTROL_MISR_INITVAL_SHIFT))

//====================================================================
//Register: MISR Testability Status Register (MISR_STATUS)
/** \brief The CRC signature is captured in this register*/
//====================================================================

#define  LCD2_MISR_STATUS_RESERVED1_MASK 0xfffe0000
#define  LCD2_MISR_STATUS_RESERVED1_SHIFT 17
#define  LCD2_MISR_STATUS_RESERVED1_MASK_SHIFT(reg) (((reg) & LCD2_MISR_STATUS_RESERVED1_MASK) >> LCD2_MISR_STATUS_RESERVED1_SHIFT)
#define  LCD2_MISR_STATUS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~LCD2_MISR_STATUS_RESERVED1_MASK) | (((uint32_t)val) << LCD2_MISR_STATUS_RESERVED1_SHIFT))

#define  LCD2_MISR_STATUS_MISR_CRC_MASK 0x1ffff
#define  LCD2_MISR_STATUS_MISR_CRC_SHIFT 0
#define  LCD2_MISR_STATUS_MISR_CRC_MASK_SHIFT(reg) (((reg) & LCD2_MISR_STATUS_MISR_CRC_MASK) >> LCD2_MISR_STATUS_MISR_CRC_SHIFT)
#define  LCD2_MISR_STATUS_MISR_CRC_REPLACE_VAL(reg,val) (((reg) & ~LCD2_MISR_STATUS_MISR_CRC_MASK) | (((uint32_t)val) << LCD2_MISR_STATUS_MISR_CRC_SHIFT))

//====================================================================
//Register: IP Tagging Revision 0 (REV0)
/** \brief Provide means for firmware to read IP tagging information.
      This register of particular interest to firmware.*/
//====================================================================

#define  LCD2_REV0_MAJ_MASK 0xffff0000
#define  LCD2_REV0_MAJ_SHIFT 16
#define  LCD2_REV0_MAJ_MASK_SHIFT(reg) (((reg) & LCD2_REV0_MAJ_MASK) >> LCD2_REV0_MAJ_SHIFT)
#define  LCD2_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~LCD2_REV0_MAJ_MASK) | (((uint32_t)val) << LCD2_REV0_MAJ_SHIFT))

#define  LCD2_REV0_MID_MASK 0xffff
#define  LCD2_REV0_MID_SHIFT 0
#define  LCD2_REV0_MID_MASK_SHIFT(reg) (((reg) & LCD2_REV0_MID_MASK) >> LCD2_REV0_MID_SHIFT)
#define  LCD2_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~LCD2_REV0_MID_MASK) | (((uint32_t)val) << LCD2_REV0_MID_SHIFT))

//====================================================================
//Register: IP Tagging Revision 1 (REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  LCD2_REV1_RESERVED1_MASK 0xffff0000
#define  LCD2_REV1_RESERVED1_SHIFT 16
#define  LCD2_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & LCD2_REV1_RESERVED1_MASK) >> LCD2_REV1_RESERVED1_SHIFT)
#define  LCD2_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~LCD2_REV1_RESERVED1_MASK) | (((uint32_t)val) << LCD2_REV1_RESERVED1_SHIFT))

#define  LCD2_REV1_CFG_MASK 0xffff
#define  LCD2_REV1_CFG_SHIFT 0
#define  LCD2_REV1_CFG_MASK_SHIFT(reg) (((reg) & LCD2_REV1_CFG_MASK) >> LCD2_REV1_CFG_SHIFT)
#define  LCD2_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~LCD2_REV1_CFG_MASK) | (((uint32_t)val) << LCD2_REV1_CFG_SHIFT))

#endif // LCD2
