 /*
 **************************************************************************************
 *
 * (c) Copyright 2013 Marvell International Ltd.
 *
 *
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/.
 *
 **************************************************************************************
 *
 * \file JTAGSW_regmasks.h
 * Generated using RegBuild 1.6.3
 *
 **************************************************************************************
 */

#ifndef _JTAGSW_REGMASKS_H_
#define _JTAGSW_REGMASKS_H_

#ifndef __KERNEL__
#include <stdint.h>
#endif

//====================================================================
//
//Register File: JTAGSW (JTAGSW)
/** \brief (rev 0 . 2 . 0 . 0)
    Registers for the bootspi module.*/
//
//====================================================================

//====================================================================
//Register: Enable Software JTAG Register (JTAGSW_EN)
//====================================================================

#define  JTAGSW_JTAGSW_EN_RESERVED1_MASK 0xfffffffe
#define  JTAGSW_JTAGSW_EN_RESERVED1_SHIFT 1
#define  JTAGSW_JTAGSW_EN_RESERVED1_MASK_SHIFT(reg) (((reg) & JTAGSW_JTAGSW_EN_RESERVED1_MASK) >> JTAGSW_JTAGSW_EN_RESERVED1_SHIFT)
#define  JTAGSW_JTAGSW_EN_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~JTAGSW_JTAGSW_EN_RESERVED1_MASK) | (((uint32_t)val) << JTAGSW_JTAGSW_EN_RESERVED1_SHIFT))

#define  JTAGSW_JTAGSW_EN_EN_MUX_JTG_SOFT_MASK 0x1
#define  JTAGSW_JTAGSW_EN_EN_MUX_JTG_SOFT_SHIFT 0
#define  JTAGSW_JTAGSW_EN_EN_MUX_JTG_SOFT_MASK_SHIFT(reg) (((reg) & JTAGSW_JTAGSW_EN_EN_MUX_JTG_SOFT_MASK) >> JTAGSW_JTAGSW_EN_EN_MUX_JTG_SOFT_SHIFT)
#define  JTAGSW_JTAGSW_EN_EN_MUX_JTG_SOFT_REPLACE_VAL(reg,val) (((reg) & ~JTAGSW_JTAGSW_EN_EN_MUX_JTG_SOFT_MASK) | (((uint32_t)val) << JTAGSW_JTAGSW_EN_EN_MUX_JTG_SOFT_SHIFT))

//====================================================================
//Register: Software JTAG Control Register (JTAGSW_CTRL)
//====================================================================

#define  JTAGSW_JTAGSW_CTRL_RESERVED1_MASK 0xfffffff0
#define  JTAGSW_JTAGSW_CTRL_RESERVED1_SHIFT 4
#define  JTAGSW_JTAGSW_CTRL_RESERVED1_MASK_SHIFT(reg) (((reg) & JTAGSW_JTAGSW_CTRL_RESERVED1_MASK) >> JTAGSW_JTAGSW_CTRL_RESERVED1_SHIFT)
#define  JTAGSW_JTAGSW_CTRL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~JTAGSW_JTAGSW_CTRL_RESERVED1_MASK) | (((uint32_t)val) << JTAGSW_JTAGSW_CTRL_RESERVED1_SHIFT))

#define  JTAGSW_JTAGSW_CTRL_JTAG_SOFT_OUT_TCK_MASK 0x8
#define  JTAGSW_JTAGSW_CTRL_JTAG_SOFT_OUT_TCK_SHIFT 3
#define  JTAGSW_JTAGSW_CTRL_JTAG_SOFT_OUT_TCK_MASK_SHIFT(reg) (((reg) & JTAGSW_JTAGSW_CTRL_JTAG_SOFT_OUT_TCK_MASK) >> JTAGSW_JTAGSW_CTRL_JTAG_SOFT_OUT_TCK_SHIFT)
#define  JTAGSW_JTAGSW_CTRL_JTAG_SOFT_OUT_TCK_REPLACE_VAL(reg,val) (((reg) & ~JTAGSW_JTAGSW_CTRL_JTAG_SOFT_OUT_TCK_MASK) | (((uint32_t)val) << JTAGSW_JTAGSW_CTRL_JTAG_SOFT_OUT_TCK_SHIFT))

#define  JTAGSW_JTAGSW_CTRL_JTAG_SOFT_OUT_TMS_MASK 0x4
#define  JTAGSW_JTAGSW_CTRL_JTAG_SOFT_OUT_TMS_SHIFT 2
#define  JTAGSW_JTAGSW_CTRL_JTAG_SOFT_OUT_TMS_MASK_SHIFT(reg) (((reg) & JTAGSW_JTAGSW_CTRL_JTAG_SOFT_OUT_TMS_MASK) >> JTAGSW_JTAGSW_CTRL_JTAG_SOFT_OUT_TMS_SHIFT)
#define  JTAGSW_JTAGSW_CTRL_JTAG_SOFT_OUT_TMS_REPLACE_VAL(reg,val) (((reg) & ~JTAGSW_JTAGSW_CTRL_JTAG_SOFT_OUT_TMS_MASK) | (((uint32_t)val) << JTAGSW_JTAGSW_CTRL_JTAG_SOFT_OUT_TMS_SHIFT))

#define  JTAGSW_JTAGSW_CTRL_JTAG_SOFT_OUT_TRST_MASK 0x2
#define  JTAGSW_JTAGSW_CTRL_JTAG_SOFT_OUT_TRST_SHIFT 1
#define  JTAGSW_JTAGSW_CTRL_JTAG_SOFT_OUT_TRST_MASK_SHIFT(reg) (((reg) & JTAGSW_JTAGSW_CTRL_JTAG_SOFT_OUT_TRST_MASK) >> JTAGSW_JTAGSW_CTRL_JTAG_SOFT_OUT_TRST_SHIFT)
#define  JTAGSW_JTAGSW_CTRL_JTAG_SOFT_OUT_TRST_REPLACE_VAL(reg,val) (((reg) & ~JTAGSW_JTAGSW_CTRL_JTAG_SOFT_OUT_TRST_MASK) | (((uint32_t)val) << JTAGSW_JTAGSW_CTRL_JTAG_SOFT_OUT_TRST_SHIFT))

#define  JTAGSW_JTAGSW_CTRL_JTAG_SOFT_OUT_TDI_MASK 0x1
#define  JTAGSW_JTAGSW_CTRL_JTAG_SOFT_OUT_TDI_SHIFT 0
#define  JTAGSW_JTAGSW_CTRL_JTAG_SOFT_OUT_TDI_MASK_SHIFT(reg) (((reg) & JTAGSW_JTAGSW_CTRL_JTAG_SOFT_OUT_TDI_MASK) >> JTAGSW_JTAGSW_CTRL_JTAG_SOFT_OUT_TDI_SHIFT)
#define  JTAGSW_JTAGSW_CTRL_JTAG_SOFT_OUT_TDI_REPLACE_VAL(reg,val) (((reg) & ~JTAGSW_JTAGSW_CTRL_JTAG_SOFT_OUT_TDI_MASK) | (((uint32_t)val) << JTAGSW_JTAGSW_CTRL_JTAG_SOFT_OUT_TDI_SHIFT))

//====================================================================
//Register: Software JTAG Serial Data Register (JTAGSW_DATA)
//====================================================================

#define  JTAGSW_JTAGSW_DATA_RESERVED1_MASK 0xfffffffe
#define  JTAGSW_JTAGSW_DATA_RESERVED1_SHIFT 1
#define  JTAGSW_JTAGSW_DATA_RESERVED1_MASK_SHIFT(reg) (((reg) & JTAGSW_JTAGSW_DATA_RESERVED1_MASK) >> JTAGSW_JTAGSW_DATA_RESERVED1_SHIFT)
#define  JTAGSW_JTAGSW_DATA_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~JTAGSW_JTAGSW_DATA_RESERVED1_MASK) | (((uint32_t)val) << JTAGSW_JTAGSW_DATA_RESERVED1_SHIFT))

#define  JTAGSW_JTAGSW_DATA_JTAG_SOFT_TDO_MASK 0x1
#define  JTAGSW_JTAGSW_DATA_JTAG_SOFT_TDO_SHIFT 0
#define  JTAGSW_JTAGSW_DATA_JTAG_SOFT_TDO_MASK_SHIFT(reg) (((reg) & JTAGSW_JTAGSW_DATA_JTAG_SOFT_TDO_MASK) >> JTAGSW_JTAGSW_DATA_JTAG_SOFT_TDO_SHIFT)
#define  JTAGSW_JTAGSW_DATA_JTAG_SOFT_TDO_REPLACE_VAL(reg,val) (((reg) & ~JTAGSW_JTAGSW_DATA_JTAG_SOFT_TDO_MASK) | (((uint32_t)val) << JTAGSW_JTAGSW_DATA_JTAG_SOFT_TDO_SHIFT))

//====================================================================
//Register: Software JTAG Revision 0 Register (JTAGSW_REV0)
//====================================================================

#define  JTAGSW_JTAGSW_REV0_JTAG_SW_MAJ_REV_MASK 0xffff0000
#define  JTAGSW_JTAGSW_REV0_JTAG_SW_MAJ_REV_SHIFT 16
#define  JTAGSW_JTAGSW_REV0_JTAG_SW_MAJ_REV_MASK_SHIFT(reg) (((reg) & JTAGSW_JTAGSW_REV0_JTAG_SW_MAJ_REV_MASK) >> JTAGSW_JTAGSW_REV0_JTAG_SW_MAJ_REV_SHIFT)
#define  JTAGSW_JTAGSW_REV0_JTAG_SW_MAJ_REV_REPLACE_VAL(reg,val) (((reg) & ~JTAGSW_JTAGSW_REV0_JTAG_SW_MAJ_REV_MASK) | (((uint32_t)val) << JTAGSW_JTAGSW_REV0_JTAG_SW_MAJ_REV_SHIFT))

#define  JTAGSW_JTAGSW_REV0_JTAG_SW_MID_REV_MASK 0xffff
#define  JTAGSW_JTAGSW_REV0_JTAG_SW_MID_REV_SHIFT 0
#define  JTAGSW_JTAGSW_REV0_JTAG_SW_MID_REV_MASK_SHIFT(reg) (((reg) & JTAGSW_JTAGSW_REV0_JTAG_SW_MID_REV_MASK) >> JTAGSW_JTAGSW_REV0_JTAG_SW_MID_REV_SHIFT)
#define  JTAGSW_JTAGSW_REV0_JTAG_SW_MID_REV_REPLACE_VAL(reg,val) (((reg) & ~JTAGSW_JTAGSW_REV0_JTAG_SW_MID_REV_MASK) | (((uint32_t)val) << JTAGSW_JTAGSW_REV0_JTAG_SW_MID_REV_SHIFT))

//====================================================================
//Register: Software JTAG Revision 1 Register (JTAGSW_REV1)
//====================================================================

#define  JTAGSW_JTAGSW_REV1_RESERVED1_MASK 0xffff0000
#define  JTAGSW_JTAGSW_REV1_RESERVED1_SHIFT 16
#define  JTAGSW_JTAGSW_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & JTAGSW_JTAGSW_REV1_RESERVED1_MASK) >> JTAGSW_JTAGSW_REV1_RESERVED1_SHIFT)
#define  JTAGSW_JTAGSW_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~JTAGSW_JTAGSW_REV1_RESERVED1_MASK) | (((uint32_t)val) << JTAGSW_JTAGSW_REV1_RESERVED1_SHIFT))

#define  JTAGSW_JTAGSW_REV1_JTAG_SW_CFG_MASK 0xffff
#define  JTAGSW_JTAGSW_REV1_JTAG_SW_CFG_SHIFT 0
#define  JTAGSW_JTAGSW_REV1_JTAG_SW_CFG_MASK_SHIFT(reg) (((reg) & JTAGSW_JTAGSW_REV1_JTAG_SW_CFG_MASK) >> JTAGSW_JTAGSW_REV1_JTAG_SW_CFG_SHIFT)
#define  JTAGSW_JTAGSW_REV1_JTAG_SW_CFG_REPLACE_VAL(reg,val) (((reg) & ~JTAGSW_JTAGSW_REV1_JTAG_SW_CFG_MASK) | (((uint32_t)val) << JTAGSW_JTAGSW_REV1_JTAG_SW_CFG_SHIFT))

#endif // JTAGSW
