 /*
 **************************************************************************************
 *
 * (c) Copyright 2013 Marvell International Ltd.
 *
 *
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/.
 *
 **************************************************************************************
 *
 * \file JPEG_TOP_regmasks.h
 * Generated using RegBuild 1.6.3
 *
 **************************************************************************************
 */

#ifndef _JPEG_TOP_REGMASKS_H_
#define _JPEG_TOP_REGMASKS_H_

#ifndef __KERNEL__
#include <stdint.h>
#endif

//====================================================================
//
//Register File: JPEG_TOP (JPEG_TOP)
/** \brief Register descriptions for the JPEG TOP registers.*/
//
//====================================================================

//====================================================================
//Register: Interrupt Pending Register (IRQ_PEND)
/** \brief Used to read the status of the block's interrupts.*/
//====================================================================

#define  JPEG_TOP_IRQ_PEND_RESERVED1_MASK 0xffffffe0
#define  JPEG_TOP_IRQ_PEND_RESERVED1_SHIFT 5
#define  JPEG_TOP_IRQ_PEND_RESERVED1_MASK_SHIFT(reg) (((reg) & JPEG_TOP_IRQ_PEND_RESERVED1_MASK) >> JPEG_TOP_IRQ_PEND_RESERVED1_SHIFT)
#define  JPEG_TOP_IRQ_PEND_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~JPEG_TOP_IRQ_PEND_RESERVED1_MASK) | (((uint32_t)val) << JPEG_TOP_IRQ_PEND_RESERVED1_SHIFT))

#define  JPEG_TOP_IRQ_PEND_CORE_IRQ_PENDING_MASK 0x10
#define  JPEG_TOP_IRQ_PEND_CORE_IRQ_PENDING_SHIFT 4
#define  JPEG_TOP_IRQ_PEND_CORE_IRQ_PENDING_MASK_SHIFT(reg) (((reg) & JPEG_TOP_IRQ_PEND_CORE_IRQ_PENDING_MASK) >> JPEG_TOP_IRQ_PEND_CORE_IRQ_PENDING_SHIFT)
#define  JPEG_TOP_IRQ_PEND_CORE_IRQ_PENDING_REPLACE_VAL(reg,val) (((reg) & ~JPEG_TOP_IRQ_PEND_CORE_IRQ_PENDING_MASK) | (((uint32_t)val) << JPEG_TOP_IRQ_PEND_CORE_IRQ_PENDING_SHIFT))

#define  JPEG_TOP_IRQ_PEND_JPEG_ODMA_IRQ_PENDING_MASK 0x8
#define  JPEG_TOP_IRQ_PEND_JPEG_ODMA_IRQ_PENDING_SHIFT 3
#define  JPEG_TOP_IRQ_PEND_JPEG_ODMA_IRQ_PENDING_MASK_SHIFT(reg) (((reg) & JPEG_TOP_IRQ_PEND_JPEG_ODMA_IRQ_PENDING_MASK) >> JPEG_TOP_IRQ_PEND_JPEG_ODMA_IRQ_PENDING_SHIFT)
#define  JPEG_TOP_IRQ_PEND_JPEG_ODMA_IRQ_PENDING_REPLACE_VAL(reg,val) (((reg) & ~JPEG_TOP_IRQ_PEND_JPEG_ODMA_IRQ_PENDING_MASK) | (((uint32_t)val) << JPEG_TOP_IRQ_PEND_JPEG_ODMA_IRQ_PENDING_SHIFT))

#define  JPEG_TOP_IRQ_PEND_JPEG_IDMA_IRQ_PENDING_MASK 0x4
#define  JPEG_TOP_IRQ_PEND_JPEG_IDMA_IRQ_PENDING_SHIFT 2
#define  JPEG_TOP_IRQ_PEND_JPEG_IDMA_IRQ_PENDING_MASK_SHIFT(reg) (((reg) & JPEG_TOP_IRQ_PEND_JPEG_IDMA_IRQ_PENDING_MASK) >> JPEG_TOP_IRQ_PEND_JPEG_IDMA_IRQ_PENDING_SHIFT)
#define  JPEG_TOP_IRQ_PEND_JPEG_IDMA_IRQ_PENDING_REPLACE_VAL(reg,val) (((reg) & ~JPEG_TOP_IRQ_PEND_JPEG_IDMA_IRQ_PENDING_MASK) | (((uint32_t)val) << JPEG_TOP_IRQ_PEND_JPEG_IDMA_IRQ_PENDING_SHIFT))

#define  JPEG_TOP_IRQ_PEND_POGO_ODMA_IRQ_PENDING_MASK 0x2
#define  JPEG_TOP_IRQ_PEND_POGO_ODMA_IRQ_PENDING_SHIFT 1
#define  JPEG_TOP_IRQ_PEND_POGO_ODMA_IRQ_PENDING_MASK_SHIFT(reg) (((reg) & JPEG_TOP_IRQ_PEND_POGO_ODMA_IRQ_PENDING_MASK) >> JPEG_TOP_IRQ_PEND_POGO_ODMA_IRQ_PENDING_SHIFT)
#define  JPEG_TOP_IRQ_PEND_POGO_ODMA_IRQ_PENDING_REPLACE_VAL(reg,val) (((reg) & ~JPEG_TOP_IRQ_PEND_POGO_ODMA_IRQ_PENDING_MASK) | (((uint32_t)val) << JPEG_TOP_IRQ_PEND_POGO_ODMA_IRQ_PENDING_SHIFT))

#define  JPEG_TOP_IRQ_PEND_POGO_IDMA_IRQ_PENDING_MASK 0x1
#define  JPEG_TOP_IRQ_PEND_POGO_IDMA_IRQ_PENDING_SHIFT 0
#define  JPEG_TOP_IRQ_PEND_POGO_IDMA_IRQ_PENDING_MASK_SHIFT(reg) (((reg) & JPEG_TOP_IRQ_PEND_POGO_IDMA_IRQ_PENDING_MASK) >> JPEG_TOP_IRQ_PEND_POGO_IDMA_IRQ_PENDING_SHIFT)
#define  JPEG_TOP_IRQ_PEND_POGO_IDMA_IRQ_PENDING_REPLACE_VAL(reg,val) (((reg) & ~JPEG_TOP_IRQ_PEND_POGO_IDMA_IRQ_PENDING_MASK) | (((uint32_t)val) << JPEG_TOP_IRQ_PEND_POGO_IDMA_IRQ_PENDING_SHIFT))

//====================================================================
//Register: Configuration Register (CR)
/** \brief This register configures the operation of the JPEG_TOP blocks.*/
//====================================================================

#define  JPEG_TOP_CR_SOFT_RESET_MASK 0x80000000
#define  JPEG_TOP_CR_SOFT_RESET_SHIFT 31
#define  JPEG_TOP_CR_SOFT_RESET_MASK_SHIFT(reg) (((reg) & JPEG_TOP_CR_SOFT_RESET_MASK) >> JPEG_TOP_CR_SOFT_RESET_SHIFT)
#define  JPEG_TOP_CR_SOFT_RESET_REPLACE_VAL(reg,val) (((reg) & ~JPEG_TOP_CR_SOFT_RESET_MASK) | (((uint32_t)val) << JPEG_TOP_CR_SOFT_RESET_SHIFT))

#define  JPEG_TOP_CR_RESERVED1_MASK 0x7fffffff
#define  JPEG_TOP_CR_RESERVED1_SHIFT 0
#define  JPEG_TOP_CR_RESERVED1_MASK_SHIFT(reg) (((reg) & JPEG_TOP_CR_RESERVED1_MASK) >> JPEG_TOP_CR_RESERVED1_SHIFT)
#define  JPEG_TOP_CR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~JPEG_TOP_CR_RESERVED1_MASK) | (((uint32_t)val) << JPEG_TOP_CR_RESERVED1_SHIFT))

//====================================================================
//Register: IP Tagging Revision 0 (REV0)
/** \brief Provide means for firmware to read IP tagging information.
      This register of particular interest to firmware.*/
//====================================================================

#define  JPEG_TOP_REV0_MAJ_MASK 0xffff0000
#define  JPEG_TOP_REV0_MAJ_SHIFT 16
#define  JPEG_TOP_REV0_MAJ_MASK_SHIFT(reg) (((reg) & JPEG_TOP_REV0_MAJ_MASK) >> JPEG_TOP_REV0_MAJ_SHIFT)
#define  JPEG_TOP_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~JPEG_TOP_REV0_MAJ_MASK) | (((uint32_t)val) << JPEG_TOP_REV0_MAJ_SHIFT))

#define  JPEG_TOP_REV0_MID_MASK 0xffff
#define  JPEG_TOP_REV0_MID_SHIFT 0
#define  JPEG_TOP_REV0_MID_MASK_SHIFT(reg) (((reg) & JPEG_TOP_REV0_MID_MASK) >> JPEG_TOP_REV0_MID_SHIFT)
#define  JPEG_TOP_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~JPEG_TOP_REV0_MID_MASK) | (((uint32_t)val) << JPEG_TOP_REV0_MID_SHIFT))

//====================================================================
//Register: IP Tagging Revision 1 (REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  JPEG_TOP_REV1_RESERVED1_MASK 0xffff0000
#define  JPEG_TOP_REV1_RESERVED1_SHIFT 16
#define  JPEG_TOP_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & JPEG_TOP_REV1_RESERVED1_MASK) >> JPEG_TOP_REV1_RESERVED1_SHIFT)
#define  JPEG_TOP_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~JPEG_TOP_REV1_RESERVED1_MASK) | (((uint32_t)val) << JPEG_TOP_REV1_RESERVED1_SHIFT))

#define  JPEG_TOP_REV1_CFG_MASK 0xffff
#define  JPEG_TOP_REV1_CFG_SHIFT 0
#define  JPEG_TOP_REV1_CFG_MASK_SHIFT(reg) (((reg) & JPEG_TOP_REV1_CFG_MASK) >> JPEG_TOP_REV1_CFG_SHIFT)
#define  JPEG_TOP_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~JPEG_TOP_REV1_CFG_MASK) | (((uint32_t)val) << JPEG_TOP_REV1_CFG_SHIFT))

#endif // JPEG_TOP
