 /*
 **************************************************************************************
 *
 * (c) Copyright 2013 Marvell International Ltd.
 *
 *
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/.
 *
 **************************************************************************************
 *
 * \file JPEG_POGO_regmasks.h
 * Generated using RegBuild 1.6.3
 *
 **************************************************************************************
 */

#ifndef _POGO_JPEG_REGMASKS_H_
#define _POGO_JPEG_REGMASKS_H_

#ifndef __KERNEL__
#include <stdint.h>
#endif

//====================================================================
//
//Register File: JPEG Pogoizer (POGO_JPEG)
/** \brief (rev 0 . 6 . 1 . 0)
    These registers provide the means to program the characteristics of the desired
    pogoizing operation.*/
//
//====================================================================

//====================================================================
//Register: Pogoizer Configuration Register (Cfg)
/** \brief The fields in this register are used to configure the characteristics of the desired
      pogoizing operation.*/
//====================================================================

#define  POGO_JPEG_CFG_RESERVED1_MASK 0xffffc000
#define  POGO_JPEG_CFG_RESERVED1_SHIFT 14
#define  POGO_JPEG_CFG_RESERVED1_MASK_SHIFT(reg) (((reg) & POGO_JPEG_CFG_RESERVED1_MASK) >> POGO_JPEG_CFG_RESERVED1_SHIFT)
#define  POGO_JPEG_CFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~POGO_JPEG_CFG_RESERVED1_MASK) | (((uint32_t)val) << POGO_JPEG_CFG_RESERVED1_SHIFT))

#define  POGO_JPEG_CFG_PIXORDER_MASK 0x2000
#define  POGO_JPEG_CFG_PIXORDER_SHIFT 13
#define  POGO_JPEG_CFG_PIXORDER_MASK_SHIFT(reg) (((reg) & POGO_JPEG_CFG_PIXORDER_MASK) >> POGO_JPEG_CFG_PIXORDER_SHIFT)
#define  POGO_JPEG_CFG_PIXORDER_REPLACE_VAL(reg,val) (((reg) & ~POGO_JPEG_CFG_PIXORDER_MASK) | (((uint32_t)val) << POGO_JPEG_CFG_PIXORDER_SHIFT))

#define  POGO_JPEG_CFG_RESERVED2_MASK 0x1000
#define  POGO_JPEG_CFG_RESERVED2_SHIFT 12
#define  POGO_JPEG_CFG_RESERVED2_MASK_SHIFT(reg) (((reg) & POGO_JPEG_CFG_RESERVED2_MASK) >> POGO_JPEG_CFG_RESERVED2_SHIFT)
#define  POGO_JPEG_CFG_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~POGO_JPEG_CFG_RESERVED2_MASK) | (((uint32_t)val) << POGO_JPEG_CFG_RESERVED2_SHIFT))

#define  POGO_JPEG_CFG_SCALEX_MASK 0xc00
#define  POGO_JPEG_CFG_SCALEX_SHIFT 10
#define  POGO_JPEG_CFG_SCALEX_MASK_SHIFT(reg) (((reg) & POGO_JPEG_CFG_SCALEX_MASK) >> POGO_JPEG_CFG_SCALEX_SHIFT)
#define  POGO_JPEG_CFG_SCALEX_REPLACE_VAL(reg,val) (((reg) & ~POGO_JPEG_CFG_SCALEX_MASK) | (((uint32_t)val) << POGO_JPEG_CFG_SCALEX_SHIFT))

#define  POGO_JPEG_CFG_SCALEY_MASK 0x300
#define  POGO_JPEG_CFG_SCALEY_SHIFT 8
#define  POGO_JPEG_CFG_SCALEY_MASK_SHIFT(reg) (((reg) & POGO_JPEG_CFG_SCALEY_MASK) >> POGO_JPEG_CFG_SCALEY_SHIFT)
#define  POGO_JPEG_CFG_SCALEY_REPLACE_VAL(reg,val) (((reg) & ~POGO_JPEG_CFG_SCALEY_MASK) | (((uint32_t)val) << POGO_JPEG_CFG_SCALEY_SHIFT))

#define  POGO_JPEG_CFG_RESERVED3_MASK 0x80
#define  POGO_JPEG_CFG_RESERVED3_SHIFT 7
#define  POGO_JPEG_CFG_RESERVED3_MASK_SHIFT(reg) (((reg) & POGO_JPEG_CFG_RESERVED3_MASK) >> POGO_JPEG_CFG_RESERVED3_SHIFT)
#define  POGO_JPEG_CFG_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~POGO_JPEG_CFG_RESERVED3_MASK) | (((uint32_t)val) << POGO_JPEG_CFG_RESERVED3_SHIFT))

#define  POGO_JPEG_CFG_BPP_MASK 0x70
#define  POGO_JPEG_CFG_BPP_SHIFT 4
#define  POGO_JPEG_CFG_BPP_MASK_SHIFT(reg) (((reg) & POGO_JPEG_CFG_BPP_MASK) >> POGO_JPEG_CFG_BPP_SHIFT)
#define  POGO_JPEG_CFG_BPP_REPLACE_VAL(reg,val) (((reg) & ~POGO_JPEG_CFG_BPP_MASK) | (((uint32_t)val) << POGO_JPEG_CFG_BPP_SHIFT))

#define  POGO_JPEG_CFG_COLORSWAP_MASK 0x8
#define  POGO_JPEG_CFG_COLORSWAP_SHIFT 3
#define  POGO_JPEG_CFG_COLORSWAP_MASK_SHIFT(reg) (((reg) & POGO_JPEG_CFG_COLORSWAP_MASK) >> POGO_JPEG_CFG_COLORSWAP_SHIFT)
#define  POGO_JPEG_CFG_COLORSWAP_REPLACE_VAL(reg,val) (((reg) & ~POGO_JPEG_CFG_COLORSWAP_MASK) | (((uint32_t)val) << POGO_JPEG_CFG_COLORSWAP_SHIFT))

#define  POGO_JPEG_CFG_FMT_MASK 0x7
#define  POGO_JPEG_CFG_FMT_SHIFT 0
#define  POGO_JPEG_CFG_FMT_MASK_SHIFT(reg) (((reg) & POGO_JPEG_CFG_FMT_MASK) >> POGO_JPEG_CFG_FMT_SHIFT)
#define  POGO_JPEG_CFG_FMT_REPLACE_VAL(reg,val) (((reg) & ~POGO_JPEG_CFG_FMT_MASK) | (((uint32_t)val) << POGO_JPEG_CFG_FMT_SHIFT))

//====================================================================
//Register: IP Tagging Revision 0 (REV0)
/** \brief Provide means for firmware to read IP tagging information.
      This register of particular interest to firmware.*/
//====================================================================

#define  POGO_JPEG_REV0_MAJ_MASK 0xffff0000
#define  POGO_JPEG_REV0_MAJ_SHIFT 16
#define  POGO_JPEG_REV0_MAJ_MASK_SHIFT(reg) (((reg) & POGO_JPEG_REV0_MAJ_MASK) >> POGO_JPEG_REV0_MAJ_SHIFT)
#define  POGO_JPEG_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~POGO_JPEG_REV0_MAJ_MASK) | (((uint32_t)val) << POGO_JPEG_REV0_MAJ_SHIFT))

#define  POGO_JPEG_REV0_MID_MASK 0xffff
#define  POGO_JPEG_REV0_MID_SHIFT 0
#define  POGO_JPEG_REV0_MID_MASK_SHIFT(reg) (((reg) & POGO_JPEG_REV0_MID_MASK) >> POGO_JPEG_REV0_MID_SHIFT)
#define  POGO_JPEG_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~POGO_JPEG_REV0_MID_MASK) | (((uint32_t)val) << POGO_JPEG_REV0_MID_SHIFT))

//====================================================================
//Register: IP Tagging Revision 1 (REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  POGO_JPEG_REV1_RESERVED1_MASK 0xffff0000
#define  POGO_JPEG_REV1_RESERVED1_SHIFT 16
#define  POGO_JPEG_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & POGO_JPEG_REV1_RESERVED1_MASK) >> POGO_JPEG_REV1_RESERVED1_SHIFT)
#define  POGO_JPEG_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~POGO_JPEG_REV1_RESERVED1_MASK) | (((uint32_t)val) << POGO_JPEG_REV1_RESERVED1_SHIFT))

#define  POGO_JPEG_REV1_CFG_MASK 0xffff
#define  POGO_JPEG_REV1_CFG_SHIFT 0
#define  POGO_JPEG_REV1_CFG_MASK_SHIFT(reg) (((reg) & POGO_JPEG_REV1_CFG_MASK) >> POGO_JPEG_REV1_CFG_SHIFT)
#define  POGO_JPEG_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~POGO_JPEG_REV1_CFG_MASK) | (((uint32_t)val) << POGO_JPEG_REV1_CFG_SHIFT))

#endif // POGO_JPEG
