 /*
 **************************************************************************************
 *
 * (c) Copyright 2013 Marvell International Ltd.
 *
 *
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/.
 *
 **************************************************************************************
 *
 * \file JPEG_ODMA_regmasks.h
 * Generated using RegBuild 1.6.1
 *
 **************************************************************************************
 */

#ifndef _JPEG_ODMA_CORE_REGMASKS_H_
#define _JPEG_ODMA_CORE_REGMASKS_H_

#ifndef __KERNEL__
#include <stdint.h>
#endif

//====================================================================
//
//Register File: JPEG_ODMA_CORE (JPEG_ODMA_CORE)
//
//====================================================================

//====================================================================
//Register: ODMA Tag Register 0 (OTR0)
//====================================================================

#define  JPEG_ODMA_CORE_OTR0_RESERVED1_MASK 0xffff0000
#define  JPEG_ODMA_CORE_OTR0_RESERVED1_SHIFT 16
#define  JPEG_ODMA_CORE_OTR0_RESERVED1_MASK_SHIFT(reg) (((reg) & JPEG_ODMA_CORE_OTR0_RESERVED1_MASK) >> JPEG_ODMA_CORE_OTR0_RESERVED1_SHIFT)
#define  JPEG_ODMA_CORE_OTR0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~JPEG_ODMA_CORE_OTR0_RESERVED1_MASK) | (((uint32_t)val) << JPEG_ODMA_CORE_OTR0_RESERVED1_SHIFT))

#define  JPEG_ODMA_CORE_OTR0_TAGCFG_MASK 0xffff
#define  JPEG_ODMA_CORE_OTR0_TAGCFG_SHIFT 0
#define  JPEG_ODMA_CORE_OTR0_TAGCFG_MASK_SHIFT(reg) (((reg) & JPEG_ODMA_CORE_OTR0_TAGCFG_MASK) >> JPEG_ODMA_CORE_OTR0_TAGCFG_SHIFT)
#define  JPEG_ODMA_CORE_OTR0_TAGCFG_REPLACE_VAL(reg,val) (((reg) & ~JPEG_ODMA_CORE_OTR0_TAGCFG_MASK) | (((uint32_t)val) << JPEG_ODMA_CORE_OTR0_TAGCFG_SHIFT))

//====================================================================
//Register: ODMA Tag Register 1 (OTR1)
//====================================================================

#define  JPEG_ODMA_CORE_OTR1_RESERVED1_MASK 0xffff0000
#define  JPEG_ODMA_CORE_OTR1_RESERVED1_SHIFT 16
#define  JPEG_ODMA_CORE_OTR1_RESERVED1_MASK_SHIFT(reg) (((reg) & JPEG_ODMA_CORE_OTR1_RESERVED1_MASK) >> JPEG_ODMA_CORE_OTR1_RESERVED1_SHIFT)
#define  JPEG_ODMA_CORE_OTR1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~JPEG_ODMA_CORE_OTR1_RESERVED1_MASK) | (((uint32_t)val) << JPEG_ODMA_CORE_OTR1_RESERVED1_SHIFT))

#define  JPEG_ODMA_CORE_OTR1_TAGMAJ_MASK 0xffff
#define  JPEG_ODMA_CORE_OTR1_TAGMAJ_SHIFT 0
#define  JPEG_ODMA_CORE_OTR1_TAGMAJ_MASK_SHIFT(reg) (((reg) & JPEG_ODMA_CORE_OTR1_TAGMAJ_MASK) >> JPEG_ODMA_CORE_OTR1_TAGMAJ_SHIFT)
#define  JPEG_ODMA_CORE_OTR1_TAGMAJ_REPLACE_VAL(reg,val) (((reg) & ~JPEG_ODMA_CORE_OTR1_TAGMAJ_MASK) | (((uint32_t)val) << JPEG_ODMA_CORE_OTR1_TAGMAJ_SHIFT))

//====================================================================
//Register: ODMA Tag Register 2 (OTR2)
//====================================================================

#define  JPEG_ODMA_CORE_OTR2_RESERVED1_MASK 0xffff0000
#define  JPEG_ODMA_CORE_OTR2_RESERVED1_SHIFT 16
#define  JPEG_ODMA_CORE_OTR2_RESERVED1_MASK_SHIFT(reg) (((reg) & JPEG_ODMA_CORE_OTR2_RESERVED1_MASK) >> JPEG_ODMA_CORE_OTR2_RESERVED1_SHIFT)
#define  JPEG_ODMA_CORE_OTR2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~JPEG_ODMA_CORE_OTR2_RESERVED1_MASK) | (((uint32_t)val) << JPEG_ODMA_CORE_OTR2_RESERVED1_SHIFT))

#define  JPEG_ODMA_CORE_OTR2_TAGMID_MASK 0xffff
#define  JPEG_ODMA_CORE_OTR2_TAGMID_SHIFT 0
#define  JPEG_ODMA_CORE_OTR2_TAGMID_MASK_SHIFT(reg) (((reg) & JPEG_ODMA_CORE_OTR2_TAGMID_MASK) >> JPEG_ODMA_CORE_OTR2_TAGMID_SHIFT)
#define  JPEG_ODMA_CORE_OTR2_TAGMID_REPLACE_VAL(reg,val) (((reg) & ~JPEG_ODMA_CORE_OTR2_TAGMID_MASK) | (((uint32_t)val) << JPEG_ODMA_CORE_OTR2_TAGMID_SHIFT))

//====================================================================
//Register: ODMA Interrupt Enable Register (OIER)
//====================================================================

#define  JPEG_ODMA_CORE_OIER_RESERVED1_MASK 0xfffffffe
#define  JPEG_ODMA_CORE_OIER_RESERVED1_SHIFT 1
#define  JPEG_ODMA_CORE_OIER_RESERVED1_MASK_SHIFT(reg) (((reg) & JPEG_ODMA_CORE_OIER_RESERVED1_MASK) >> JPEG_ODMA_CORE_OIER_RESERVED1_SHIFT)
#define  JPEG_ODMA_CORE_OIER_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~JPEG_ODMA_CORE_OIER_RESERVED1_MASK) | (((uint32_t)val) << JPEG_ODMA_CORE_OIER_RESERVED1_SHIFT))

#define  JPEG_ODMA_CORE_OIER_EOI_MASK 0x1
#define  JPEG_ODMA_CORE_OIER_EOI_SHIFT 0
#define  JPEG_ODMA_CORE_OIER_EOI_MASK_SHIFT(reg) (((reg) & JPEG_ODMA_CORE_OIER_EOI_MASK) >> JPEG_ODMA_CORE_OIER_EOI_SHIFT)
#define  JPEG_ODMA_CORE_OIER_EOI_REPLACE_VAL(reg,val) (((reg) & ~JPEG_ODMA_CORE_OIER_EOI_MASK) | (((uint32_t)val) << JPEG_ODMA_CORE_OIER_EOI_SHIFT))

//====================================================================
//Register: ODMA Interrupt Pending Register (OIPR)
//====================================================================

#define  JPEG_ODMA_CORE_OIPR_RESERVED1_MASK 0xfffffffe
#define  JPEG_ODMA_CORE_OIPR_RESERVED1_SHIFT 1
#define  JPEG_ODMA_CORE_OIPR_RESERVED1_MASK_SHIFT(reg) (((reg) & JPEG_ODMA_CORE_OIPR_RESERVED1_MASK) >> JPEG_ODMA_CORE_OIPR_RESERVED1_SHIFT)
#define  JPEG_ODMA_CORE_OIPR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~JPEG_ODMA_CORE_OIPR_RESERVED1_MASK) | (((uint32_t)val) << JPEG_ODMA_CORE_OIPR_RESERVED1_SHIFT))

#define  JPEG_ODMA_CORE_OIPR_EOI_MASK 0x1
#define  JPEG_ODMA_CORE_OIPR_EOI_SHIFT 0
#define  JPEG_ODMA_CORE_OIPR_EOI_MASK_SHIFT(reg) (((reg) & JPEG_ODMA_CORE_OIPR_EOI_MASK) >> JPEG_ODMA_CORE_OIPR_EOI_SHIFT)
#define  JPEG_ODMA_CORE_OIPR_EOI_REPLACE_VAL(reg,val) (((reg) & ~JPEG_ODMA_CORE_OIPR_EOI_MASK) | (((uint32_t)val) << JPEG_ODMA_CORE_OIPR_EOI_SHIFT))

//====================================================================
//Register: ODMA Interrupt Clear Register (OICR)
//====================================================================

#define  JPEG_ODMA_CORE_OICR_RESERVED1_MASK 0xfffffffe
#define  JPEG_ODMA_CORE_OICR_RESERVED1_SHIFT 1
#define  JPEG_ODMA_CORE_OICR_RESERVED1_MASK_SHIFT(reg) (((reg) & JPEG_ODMA_CORE_OICR_RESERVED1_MASK) >> JPEG_ODMA_CORE_OICR_RESERVED1_SHIFT)
#define  JPEG_ODMA_CORE_OICR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~JPEG_ODMA_CORE_OICR_RESERVED1_MASK) | (((uint32_t)val) << JPEG_ODMA_CORE_OICR_RESERVED1_SHIFT))

#define  JPEG_ODMA_CORE_OICR_EOI_MASK 0x1
#define  JPEG_ODMA_CORE_OICR_EOI_SHIFT 0
#define  JPEG_ODMA_CORE_OICR_EOI_MASK_SHIFT(reg) (((reg) & JPEG_ODMA_CORE_OICR_EOI_MASK) >> JPEG_ODMA_CORE_OICR_EOI_SHIFT)
#define  JPEG_ODMA_CORE_OICR_EOI_REPLACE_VAL(reg,val) (((reg) & ~JPEG_ODMA_CORE_OICR_EOI_MASK) | (((uint32_t)val) << JPEG_ODMA_CORE_OICR_EOI_SHIFT))

//====================================================================
//Register: ODMA Interrupt Force Register (OIFR)
//====================================================================

#define  JPEG_ODMA_CORE_OIFR_RESERVED1_MASK 0xfffffffe
#define  JPEG_ODMA_CORE_OIFR_RESERVED1_SHIFT 1
#define  JPEG_ODMA_CORE_OIFR_RESERVED1_MASK_SHIFT(reg) (((reg) & JPEG_ODMA_CORE_OIFR_RESERVED1_MASK) >> JPEG_ODMA_CORE_OIFR_RESERVED1_SHIFT)
#define  JPEG_ODMA_CORE_OIFR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~JPEG_ODMA_CORE_OIFR_RESERVED1_MASK) | (((uint32_t)val) << JPEG_ODMA_CORE_OIFR_RESERVED1_SHIFT))

#define  JPEG_ODMA_CORE_OIFR_EOI_MASK 0x1
#define  JPEG_ODMA_CORE_OIFR_EOI_SHIFT 0
#define  JPEG_ODMA_CORE_OIFR_EOI_MASK_SHIFT(reg) (((reg) & JPEG_ODMA_CORE_OIFR_EOI_MASK) >> JPEG_ODMA_CORE_OIFR_EOI_SHIFT)
#define  JPEG_ODMA_CORE_OIFR_EOI_REPLACE_VAL(reg,val) (((reg) & ~JPEG_ODMA_CORE_OIFR_EOI_MASK) | (((uint32_t)val) << JPEG_ODMA_CORE_OIFR_EOI_SHIFT))

//====================================================================
//Register: ODMA Buffer Length Register (OBLR)
//====================================================================

#define  JPEG_ODMA_CORE_OBLR_RESERVED1_MASK 0xff000000
#define  JPEG_ODMA_CORE_OBLR_RESERVED1_SHIFT 24
#define  JPEG_ODMA_CORE_OBLR_RESERVED1_MASK_SHIFT(reg) (((reg) & JPEG_ODMA_CORE_OBLR_RESERVED1_MASK) >> JPEG_ODMA_CORE_OBLR_RESERVED1_SHIFT)
#define  JPEG_ODMA_CORE_OBLR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~JPEG_ODMA_CORE_OBLR_RESERVED1_MASK) | (((uint32_t)val) << JPEG_ODMA_CORE_OBLR_RESERVED1_SHIFT))

#define  JPEG_ODMA_CORE_OBLR_BUFLENGTH_MASK 0xffffff
#define  JPEG_ODMA_CORE_OBLR_BUFLENGTH_SHIFT 0
#define  JPEG_ODMA_CORE_OBLR_BUFLENGTH_MASK_SHIFT(reg) (((reg) & JPEG_ODMA_CORE_OBLR_BUFLENGTH_MASK) >> JPEG_ODMA_CORE_OBLR_BUFLENGTH_SHIFT)
#define  JPEG_ODMA_CORE_OBLR_BUFLENGTH_REPLACE_VAL(reg,val) (((reg) & ~JPEG_ODMA_CORE_OBLR_BUFLENGTH_MASK) | (((uint32_t)val) << JPEG_ODMA_CORE_OBLR_BUFLENGTH_SHIFT))

#endif // JPEG_ODMA_CORE
