 /*
 **************************************************************************************
 *
 * (c) Copyright 2013 Marvell International Ltd.
 *
 *
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/.
 *
 **************************************************************************************
 *
 * \file JPEG_CORE_regstructs.h
 * Generated using RegBuild 1.6.3
 *
 **************************************************************************************
 */

#ifndef _JPEG_CORE_REGSTRUCTS_H_
#define _JPEG_CORE_REGSTRUCTS_H_

#ifndef __KERNEL__
#include <stdint.h>
#endif

//====================================================================
//
//Register File: JPEG_CORE (JPEG_CORE)
/** \brief Register descriptions for the JPEG core registers.*/
//
//====================================================================

typedef struct JPEG_CORE_REGS_s
{
  volatile uint32_t IRQ_EN;  ///< 0x0 [R/W]: Interrupt Enable Register
  volatile uint32_t IRQ_PEND;  ///< 0x4 [R]: Interrupt Pending Register
  volatile uint32_t IRQ_ACK;  ///< 0x8 [W]: Interrupt Acknowledge Register
  volatile uint32_t IRQ_FORCE;  ///< 0xc [W]: Interrupt Force Register
  volatile uint32_t CR;  ///< 0x10 [R/W]: Configuration Register
  volatile uint32_t IMAGE;  ///< 0x14 [R/W]: Image Configuration Register
  volatile uint32_t DIM;  ///< 0x18 [R/W]: Image Dimensions Register
  volatile uint32_t PAD;  ///< 0x1c [R/W]: Image Padding Register
  volatile uint32_t PAD_VAL;  ///< 0x20 [R/W]: Image Padding Value Register
  volatile uint32_t SUB;  ///< 0x24 [R/W]: Sub-Sampling Format Register
  volatile uint32_t HUFF;  ///< 0x28 [R/W]: Huffman Configuration Register
  volatile uint32_t HUFF_CODE_EN_DC;  ///< 0x2c [R/W]: Huffman Code Enable DC Register
  volatile uint32_t HUFF_CODE_EN_AC;  ///< 0x30 [R/W]: Huffman Code Enable AC Register
  volatile uint32_t RESTART;  ///< 0x34 [R/W]: Restart Configuration Register
  volatile uint32_t QUANT;  ///< 0x38 [R/W]: Quantization Configuration Register
  volatile uint32_t ECS_OFFSET;  ///< 0x3c [R/W]: ECS Offset Configuration Register
  volatile uint32_t reserved0[16];
  volatile uint32_t REV0;  ///< 0x80 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0x84 [R]: IP Tagging Revision 1
  volatile uint32_t STATUS0;  ///< 0x88 [R]: Status 0 Register
  volatile uint32_t STATUS1;  ///< 0x8c [R]: Status 1 Register
  volatile uint32_t STATUS2;  ///< 0x90 [R]: Status 2 Register
  volatile uint32_t STATUS3;  ///< 0x94 [R]: Status 3 Register
  volatile uint32_t STATUS4;  ///< 0x98 [R]: Status 4 Register
  volatile uint32_t STATUS5;  ///< 0x9c [R]: Status 5 Register
  volatile uint32_t STATUS6;  ///< 0xa0 [R]: Status 6 Register
  volatile uint32_t STATUS7;  ///< 0xa4 [R]: Status 7 Register
  volatile uint32_t STATUS8;  ///< 0xa8 [R]: Status 8 Register
  volatile uint32_t STATUS9;  ///< 0xac [R]: Status 9 Register
  volatile uint32_t reserved1[20];
  volatile uint32_t HUFF_FCODE[64];  ///< 0x100 [R/W]: HUFF FCODE RAM Access Register
  volatile uint32_t HUFF_LCODE[64];  ///< 0x200 [R/W]: HUFF LCODE RAM Access Register
  volatile uint32_t HUFF_PTR[64];  ///< 0x300 [R/W]: HUFF PTR RAM Access Register
  volatile uint32_t reserved2[256];
  volatile uint32_t HUFF_SYM[348];  ///< 0x800 [R/W]: HUFF_SYM RAM Access Register
  volatile uint32_t reserved3[164];
  volatile uint32_t Q_TABLE[256];  ///< 0x1000 [R/W]: Quantization Table Data
  volatile uint32_t reserved4[256];
  volatile uint32_t LEN_CODE[348];  ///< 0x1800 [R/W]: Huffman Encoder Length/Code Table
} JPEG_CORE_REGS_t;

#endif // JPEG_CORE
