 /*
 **************************************************************************************
 *
 * (c) Copyright 2013 Marvell International Ltd.
 *
 *
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/.
 *
 **************************************************************************************
 *
 * \file JPEG_CORE_regmasks.h
 * Generated using RegBuild 1.6.3
 *
 **************************************************************************************
 */

#ifndef _JPEG_CORE_REGMASKS_H_
#define _JPEG_CORE_REGMASKS_H_

#ifndef __KERNEL__
#include <stdint.h>
#endif

//====================================================================
//
//Register File: JPEG_CORE (JPEG_CORE)
/** \brief Register descriptions for the JPEG core registers.*/
//
//====================================================================

//====================================================================
//Register: Interrupt Enable Register (IRQ_EN)
/** \brief Used to enable interrupts for the block.*/
//====================================================================

#define  JPEG_CORE_IRQ_EN_HUFF_RESTART_ERROR_IRQ_EN_MASK 0x80000000
#define  JPEG_CORE_IRQ_EN_HUFF_RESTART_ERROR_IRQ_EN_SHIFT 31
#define  JPEG_CORE_IRQ_EN_HUFF_RESTART_ERROR_IRQ_EN_MASK_SHIFT(reg) (((reg) & JPEG_CORE_IRQ_EN_HUFF_RESTART_ERROR_IRQ_EN_MASK) >> JPEG_CORE_IRQ_EN_HUFF_RESTART_ERROR_IRQ_EN_SHIFT)
#define  JPEG_CORE_IRQ_EN_HUFF_RESTART_ERROR_IRQ_EN_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_IRQ_EN_HUFF_RESTART_ERROR_IRQ_EN_MASK) | (((uint32_t)val) << JPEG_CORE_IRQ_EN_HUFF_RESTART_ERROR_IRQ_EN_SHIFT))

#define  JPEG_CORE_IRQ_EN_HUFF_EOI_ERROR_IRQ_EN_MASK 0x40000000
#define  JPEG_CORE_IRQ_EN_HUFF_EOI_ERROR_IRQ_EN_SHIFT 30
#define  JPEG_CORE_IRQ_EN_HUFF_EOI_ERROR_IRQ_EN_MASK_SHIFT(reg) (((reg) & JPEG_CORE_IRQ_EN_HUFF_EOI_ERROR_IRQ_EN_MASK) >> JPEG_CORE_IRQ_EN_HUFF_EOI_ERROR_IRQ_EN_SHIFT)
#define  JPEG_CORE_IRQ_EN_HUFF_EOI_ERROR_IRQ_EN_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_IRQ_EN_HUFF_EOI_ERROR_IRQ_EN_MASK) | (((uint32_t)val) << JPEG_CORE_IRQ_EN_HUFF_EOI_ERROR_IRQ_EN_SHIFT))

#define  JPEG_CORE_IRQ_EN_HUFF_NO_CODE_ERROR_IRQ_EN_MASK 0x20000000
#define  JPEG_CORE_IRQ_EN_HUFF_NO_CODE_ERROR_IRQ_EN_SHIFT 29
#define  JPEG_CORE_IRQ_EN_HUFF_NO_CODE_ERROR_IRQ_EN_MASK_SHIFT(reg) (((reg) & JPEG_CORE_IRQ_EN_HUFF_NO_CODE_ERROR_IRQ_EN_MASK) >> JPEG_CORE_IRQ_EN_HUFF_NO_CODE_ERROR_IRQ_EN_SHIFT)
#define  JPEG_CORE_IRQ_EN_HUFF_NO_CODE_ERROR_IRQ_EN_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_IRQ_EN_HUFF_NO_CODE_ERROR_IRQ_EN_MASK) | (((uint32_t)val) << JPEG_CORE_IRQ_EN_HUFF_NO_CODE_ERROR_IRQ_EN_SHIFT))

#define  JPEG_CORE_IRQ_EN_HUFF_MULT_CODE_ERROR_IRQ_EN_MASK 0x10000000
#define  JPEG_CORE_IRQ_EN_HUFF_MULT_CODE_ERROR_IRQ_EN_SHIFT 28
#define  JPEG_CORE_IRQ_EN_HUFF_MULT_CODE_ERROR_IRQ_EN_MASK_SHIFT(reg) (((reg) & JPEG_CORE_IRQ_EN_HUFF_MULT_CODE_ERROR_IRQ_EN_MASK) >> JPEG_CORE_IRQ_EN_HUFF_MULT_CODE_ERROR_IRQ_EN_SHIFT)
#define  JPEG_CORE_IRQ_EN_HUFF_MULT_CODE_ERROR_IRQ_EN_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_IRQ_EN_HUFF_MULT_CODE_ERROR_IRQ_EN_MASK) | (((uint32_t)val) << JPEG_CORE_IRQ_EN_HUFF_MULT_CODE_ERROR_IRQ_EN_SHIFT))

#define  JPEG_CORE_IRQ_EN_RESERVED1_MASK 0xfffffe0
#define  JPEG_CORE_IRQ_EN_RESERVED1_SHIFT 5
#define  JPEG_CORE_IRQ_EN_RESERVED1_MASK_SHIFT(reg) (((reg) & JPEG_CORE_IRQ_EN_RESERVED1_MASK) >> JPEG_CORE_IRQ_EN_RESERVED1_SHIFT)
#define  JPEG_CORE_IRQ_EN_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_IRQ_EN_RESERVED1_MASK) | (((uint32_t)val) << JPEG_CORE_IRQ_EN_RESERVED1_SHIFT))

#define  JPEG_CORE_IRQ_EN_HUFF_DONE_IRQ_EN_MASK 0x10
#define  JPEG_CORE_IRQ_EN_HUFF_DONE_IRQ_EN_SHIFT 4
#define  JPEG_CORE_IRQ_EN_HUFF_DONE_IRQ_EN_MASK_SHIFT(reg) (((reg) & JPEG_CORE_IRQ_EN_HUFF_DONE_IRQ_EN_MASK) >> JPEG_CORE_IRQ_EN_HUFF_DONE_IRQ_EN_SHIFT)
#define  JPEG_CORE_IRQ_EN_HUFF_DONE_IRQ_EN_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_IRQ_EN_HUFF_DONE_IRQ_EN_MASK) | (((uint32_t)val) << JPEG_CORE_IRQ_EN_HUFF_DONE_IRQ_EN_SHIFT))

#define  JPEG_CORE_IRQ_EN_HUFF_UNSTUFF_NON_EOI_IRQ_EN_MASK 0x8
#define  JPEG_CORE_IRQ_EN_HUFF_UNSTUFF_NON_EOI_IRQ_EN_SHIFT 3
#define  JPEG_CORE_IRQ_EN_HUFF_UNSTUFF_NON_EOI_IRQ_EN_MASK_SHIFT(reg) (((reg) & JPEG_CORE_IRQ_EN_HUFF_UNSTUFF_NON_EOI_IRQ_EN_MASK) >> JPEG_CORE_IRQ_EN_HUFF_UNSTUFF_NON_EOI_IRQ_EN_SHIFT)
#define  JPEG_CORE_IRQ_EN_HUFF_UNSTUFF_NON_EOI_IRQ_EN_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_IRQ_EN_HUFF_UNSTUFF_NON_EOI_IRQ_EN_MASK) | (((uint32_t)val) << JPEG_CORE_IRQ_EN_HUFF_UNSTUFF_NON_EOI_IRQ_EN_SHIFT))

#define  JPEG_CORE_IRQ_EN_HUFF_UNSTUFF_EOI_IRQ_EN_MASK 0x4
#define  JPEG_CORE_IRQ_EN_HUFF_UNSTUFF_EOI_IRQ_EN_SHIFT 2
#define  JPEG_CORE_IRQ_EN_HUFF_UNSTUFF_EOI_IRQ_EN_MASK_SHIFT(reg) (((reg) & JPEG_CORE_IRQ_EN_HUFF_UNSTUFF_EOI_IRQ_EN_MASK) >> JPEG_CORE_IRQ_EN_HUFF_UNSTUFF_EOI_IRQ_EN_SHIFT)
#define  JPEG_CORE_IRQ_EN_HUFF_UNSTUFF_EOI_IRQ_EN_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_IRQ_EN_HUFF_UNSTUFF_EOI_IRQ_EN_MASK) | (((uint32_t)val) << JPEG_CORE_IRQ_EN_HUFF_UNSTUFF_EOI_IRQ_EN_SHIFT))

#define  JPEG_CORE_IRQ_EN_DECODE_DONE_IRQ_EN_MASK 0x2
#define  JPEG_CORE_IRQ_EN_DECODE_DONE_IRQ_EN_SHIFT 1
#define  JPEG_CORE_IRQ_EN_DECODE_DONE_IRQ_EN_MASK_SHIFT(reg) (((reg) & JPEG_CORE_IRQ_EN_DECODE_DONE_IRQ_EN_MASK) >> JPEG_CORE_IRQ_EN_DECODE_DONE_IRQ_EN_SHIFT)
#define  JPEG_CORE_IRQ_EN_DECODE_DONE_IRQ_EN_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_IRQ_EN_DECODE_DONE_IRQ_EN_MASK) | (((uint32_t)val) << JPEG_CORE_IRQ_EN_DECODE_DONE_IRQ_EN_SHIFT))

#define  JPEG_CORE_IRQ_EN_ENCODE_DONE_IRQ_EN_MASK 0x1
#define  JPEG_CORE_IRQ_EN_ENCODE_DONE_IRQ_EN_SHIFT 0
#define  JPEG_CORE_IRQ_EN_ENCODE_DONE_IRQ_EN_MASK_SHIFT(reg) (((reg) & JPEG_CORE_IRQ_EN_ENCODE_DONE_IRQ_EN_MASK) >> JPEG_CORE_IRQ_EN_ENCODE_DONE_IRQ_EN_SHIFT)
#define  JPEG_CORE_IRQ_EN_ENCODE_DONE_IRQ_EN_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_IRQ_EN_ENCODE_DONE_IRQ_EN_MASK) | (((uint32_t)val) << JPEG_CORE_IRQ_EN_ENCODE_DONE_IRQ_EN_SHIFT))

//====================================================================
//Register: Interrupt Pending Register (IRQ_PEND)
/** \brief Used to read the status of the block's interrupts.*/
//====================================================================

#define  JPEG_CORE_IRQ_PEND_HUFF_RESTART_ERROR_IRQ_PENDING_MASK 0x80000000
#define  JPEG_CORE_IRQ_PEND_HUFF_RESTART_ERROR_IRQ_PENDING_SHIFT 31
#define  JPEG_CORE_IRQ_PEND_HUFF_RESTART_ERROR_IRQ_PENDING_MASK_SHIFT(reg) (((reg) & JPEG_CORE_IRQ_PEND_HUFF_RESTART_ERROR_IRQ_PENDING_MASK) >> JPEG_CORE_IRQ_PEND_HUFF_RESTART_ERROR_IRQ_PENDING_SHIFT)
#define  JPEG_CORE_IRQ_PEND_HUFF_RESTART_ERROR_IRQ_PENDING_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_IRQ_PEND_HUFF_RESTART_ERROR_IRQ_PENDING_MASK) | (((uint32_t)val) << JPEG_CORE_IRQ_PEND_HUFF_RESTART_ERROR_IRQ_PENDING_SHIFT))

#define  JPEG_CORE_IRQ_PEND_HUFF_EOI_ERROR_IRQ_PENDING_MASK 0x40000000
#define  JPEG_CORE_IRQ_PEND_HUFF_EOI_ERROR_IRQ_PENDING_SHIFT 30
#define  JPEG_CORE_IRQ_PEND_HUFF_EOI_ERROR_IRQ_PENDING_MASK_SHIFT(reg) (((reg) & JPEG_CORE_IRQ_PEND_HUFF_EOI_ERROR_IRQ_PENDING_MASK) >> JPEG_CORE_IRQ_PEND_HUFF_EOI_ERROR_IRQ_PENDING_SHIFT)
#define  JPEG_CORE_IRQ_PEND_HUFF_EOI_ERROR_IRQ_PENDING_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_IRQ_PEND_HUFF_EOI_ERROR_IRQ_PENDING_MASK) | (((uint32_t)val) << JPEG_CORE_IRQ_PEND_HUFF_EOI_ERROR_IRQ_PENDING_SHIFT))

#define  JPEG_CORE_IRQ_PEND_HUFF_NO_CODE_ERROR_IRQ_PENDING_MASK 0x20000000
#define  JPEG_CORE_IRQ_PEND_HUFF_NO_CODE_ERROR_IRQ_PENDING_SHIFT 29
#define  JPEG_CORE_IRQ_PEND_HUFF_NO_CODE_ERROR_IRQ_PENDING_MASK_SHIFT(reg) (((reg) & JPEG_CORE_IRQ_PEND_HUFF_NO_CODE_ERROR_IRQ_PENDING_MASK) >> JPEG_CORE_IRQ_PEND_HUFF_NO_CODE_ERROR_IRQ_PENDING_SHIFT)
#define  JPEG_CORE_IRQ_PEND_HUFF_NO_CODE_ERROR_IRQ_PENDING_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_IRQ_PEND_HUFF_NO_CODE_ERROR_IRQ_PENDING_MASK) | (((uint32_t)val) << JPEG_CORE_IRQ_PEND_HUFF_NO_CODE_ERROR_IRQ_PENDING_SHIFT))

#define  JPEG_CORE_IRQ_PEND_HUFF_MULT_CODE_ERROR_IRQ_PENDING_MASK 0x10000000
#define  JPEG_CORE_IRQ_PEND_HUFF_MULT_CODE_ERROR_IRQ_PENDING_SHIFT 28
#define  JPEG_CORE_IRQ_PEND_HUFF_MULT_CODE_ERROR_IRQ_PENDING_MASK_SHIFT(reg) (((reg) & JPEG_CORE_IRQ_PEND_HUFF_MULT_CODE_ERROR_IRQ_PENDING_MASK) >> JPEG_CORE_IRQ_PEND_HUFF_MULT_CODE_ERROR_IRQ_PENDING_SHIFT)
#define  JPEG_CORE_IRQ_PEND_HUFF_MULT_CODE_ERROR_IRQ_PENDING_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_IRQ_PEND_HUFF_MULT_CODE_ERROR_IRQ_PENDING_MASK) | (((uint32_t)val) << JPEG_CORE_IRQ_PEND_HUFF_MULT_CODE_ERROR_IRQ_PENDING_SHIFT))

#define  JPEG_CORE_IRQ_PEND_RESERVED1_MASK 0xfffffe0
#define  JPEG_CORE_IRQ_PEND_RESERVED1_SHIFT 5
#define  JPEG_CORE_IRQ_PEND_RESERVED1_MASK_SHIFT(reg) (((reg) & JPEG_CORE_IRQ_PEND_RESERVED1_MASK) >> JPEG_CORE_IRQ_PEND_RESERVED1_SHIFT)
#define  JPEG_CORE_IRQ_PEND_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_IRQ_PEND_RESERVED1_MASK) | (((uint32_t)val) << JPEG_CORE_IRQ_PEND_RESERVED1_SHIFT))

#define  JPEG_CORE_IRQ_PEND_HUFF_DONE_IRQ_PENDING_MASK 0x10
#define  JPEG_CORE_IRQ_PEND_HUFF_DONE_IRQ_PENDING_SHIFT 4
#define  JPEG_CORE_IRQ_PEND_HUFF_DONE_IRQ_PENDING_MASK_SHIFT(reg) (((reg) & JPEG_CORE_IRQ_PEND_HUFF_DONE_IRQ_PENDING_MASK) >> JPEG_CORE_IRQ_PEND_HUFF_DONE_IRQ_PENDING_SHIFT)
#define  JPEG_CORE_IRQ_PEND_HUFF_DONE_IRQ_PENDING_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_IRQ_PEND_HUFF_DONE_IRQ_PENDING_MASK) | (((uint32_t)val) << JPEG_CORE_IRQ_PEND_HUFF_DONE_IRQ_PENDING_SHIFT))

#define  JPEG_CORE_IRQ_PEND_HUFF_UNSTUFF_NON_EOI_IRQ_PENDING_MASK 0x8
#define  JPEG_CORE_IRQ_PEND_HUFF_UNSTUFF_NON_EOI_IRQ_PENDING_SHIFT 3
#define  JPEG_CORE_IRQ_PEND_HUFF_UNSTUFF_NON_EOI_IRQ_PENDING_MASK_SHIFT(reg) (((reg) & JPEG_CORE_IRQ_PEND_HUFF_UNSTUFF_NON_EOI_IRQ_PENDING_MASK) >> JPEG_CORE_IRQ_PEND_HUFF_UNSTUFF_NON_EOI_IRQ_PENDING_SHIFT)
#define  JPEG_CORE_IRQ_PEND_HUFF_UNSTUFF_NON_EOI_IRQ_PENDING_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_IRQ_PEND_HUFF_UNSTUFF_NON_EOI_IRQ_PENDING_MASK) | (((uint32_t)val) << JPEG_CORE_IRQ_PEND_HUFF_UNSTUFF_NON_EOI_IRQ_PENDING_SHIFT))

#define  JPEG_CORE_IRQ_PEND_HUFF_UNSTUFF_EOI_IRQ_PENDING_MASK 0x4
#define  JPEG_CORE_IRQ_PEND_HUFF_UNSTUFF_EOI_IRQ_PENDING_SHIFT 2
#define  JPEG_CORE_IRQ_PEND_HUFF_UNSTUFF_EOI_IRQ_PENDING_MASK_SHIFT(reg) (((reg) & JPEG_CORE_IRQ_PEND_HUFF_UNSTUFF_EOI_IRQ_PENDING_MASK) >> JPEG_CORE_IRQ_PEND_HUFF_UNSTUFF_EOI_IRQ_PENDING_SHIFT)
#define  JPEG_CORE_IRQ_PEND_HUFF_UNSTUFF_EOI_IRQ_PENDING_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_IRQ_PEND_HUFF_UNSTUFF_EOI_IRQ_PENDING_MASK) | (((uint32_t)val) << JPEG_CORE_IRQ_PEND_HUFF_UNSTUFF_EOI_IRQ_PENDING_SHIFT))

#define  JPEG_CORE_IRQ_PEND_DECODE_DONE_IRQ_PENDING_MASK 0x2
#define  JPEG_CORE_IRQ_PEND_DECODE_DONE_IRQ_PENDING_SHIFT 1
#define  JPEG_CORE_IRQ_PEND_DECODE_DONE_IRQ_PENDING_MASK_SHIFT(reg) (((reg) & JPEG_CORE_IRQ_PEND_DECODE_DONE_IRQ_PENDING_MASK) >> JPEG_CORE_IRQ_PEND_DECODE_DONE_IRQ_PENDING_SHIFT)
#define  JPEG_CORE_IRQ_PEND_DECODE_DONE_IRQ_PENDING_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_IRQ_PEND_DECODE_DONE_IRQ_PENDING_MASK) | (((uint32_t)val) << JPEG_CORE_IRQ_PEND_DECODE_DONE_IRQ_PENDING_SHIFT))

#define  JPEG_CORE_IRQ_PEND_ENCODE_DONE_IRQ_PENDING_MASK 0x1
#define  JPEG_CORE_IRQ_PEND_ENCODE_DONE_IRQ_PENDING_SHIFT 0
#define  JPEG_CORE_IRQ_PEND_ENCODE_DONE_IRQ_PENDING_MASK_SHIFT(reg) (((reg) & JPEG_CORE_IRQ_PEND_ENCODE_DONE_IRQ_PENDING_MASK) >> JPEG_CORE_IRQ_PEND_ENCODE_DONE_IRQ_PENDING_SHIFT)
#define  JPEG_CORE_IRQ_PEND_ENCODE_DONE_IRQ_PENDING_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_IRQ_PEND_ENCODE_DONE_IRQ_PENDING_MASK) | (((uint32_t)val) << JPEG_CORE_IRQ_PEND_ENCODE_DONE_IRQ_PENDING_SHIFT))

//====================================================================
//Register: Interrupt Acknowledge Register (IRQ_ACK)
/** \brief Write a 1 to the bit to clear the appropriate interrupt. <br/> The Input and Output DMA interrupts must be cleared via their respective registers.*/
//====================================================================

#define  JPEG_CORE_IRQ_ACK_HUFF_RESTART_ERROR_IRQ_ACK_MASK 0x80000000
#define  JPEG_CORE_IRQ_ACK_HUFF_RESTART_ERROR_IRQ_ACK_SHIFT 31
#define  JPEG_CORE_IRQ_ACK_HUFF_RESTART_ERROR_IRQ_ACK_MASK_SHIFT(reg) (((reg) & JPEG_CORE_IRQ_ACK_HUFF_RESTART_ERROR_IRQ_ACK_MASK) >> JPEG_CORE_IRQ_ACK_HUFF_RESTART_ERROR_IRQ_ACK_SHIFT)
#define  JPEG_CORE_IRQ_ACK_HUFF_RESTART_ERROR_IRQ_ACK_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_IRQ_ACK_HUFF_RESTART_ERROR_IRQ_ACK_MASK) | (((uint32_t)val) << JPEG_CORE_IRQ_ACK_HUFF_RESTART_ERROR_IRQ_ACK_SHIFT))

#define  JPEG_CORE_IRQ_ACK_HUFF_EOI_ERROR_IRQ_ACK_MASK 0x40000000
#define  JPEG_CORE_IRQ_ACK_HUFF_EOI_ERROR_IRQ_ACK_SHIFT 30
#define  JPEG_CORE_IRQ_ACK_HUFF_EOI_ERROR_IRQ_ACK_MASK_SHIFT(reg) (((reg) & JPEG_CORE_IRQ_ACK_HUFF_EOI_ERROR_IRQ_ACK_MASK) >> JPEG_CORE_IRQ_ACK_HUFF_EOI_ERROR_IRQ_ACK_SHIFT)
#define  JPEG_CORE_IRQ_ACK_HUFF_EOI_ERROR_IRQ_ACK_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_IRQ_ACK_HUFF_EOI_ERROR_IRQ_ACK_MASK) | (((uint32_t)val) << JPEG_CORE_IRQ_ACK_HUFF_EOI_ERROR_IRQ_ACK_SHIFT))

#define  JPEG_CORE_IRQ_ACK_HUFF_NO_CODE_ERROR_IRQ_ACK_MASK 0x20000000
#define  JPEG_CORE_IRQ_ACK_HUFF_NO_CODE_ERROR_IRQ_ACK_SHIFT 29
#define  JPEG_CORE_IRQ_ACK_HUFF_NO_CODE_ERROR_IRQ_ACK_MASK_SHIFT(reg) (((reg) & JPEG_CORE_IRQ_ACK_HUFF_NO_CODE_ERROR_IRQ_ACK_MASK) >> JPEG_CORE_IRQ_ACK_HUFF_NO_CODE_ERROR_IRQ_ACK_SHIFT)
#define  JPEG_CORE_IRQ_ACK_HUFF_NO_CODE_ERROR_IRQ_ACK_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_IRQ_ACK_HUFF_NO_CODE_ERROR_IRQ_ACK_MASK) | (((uint32_t)val) << JPEG_CORE_IRQ_ACK_HUFF_NO_CODE_ERROR_IRQ_ACK_SHIFT))

#define  JPEG_CORE_IRQ_ACK_HUFF_MULT_CODE_ERROR_IRQ_ACK_MASK 0x10000000
#define  JPEG_CORE_IRQ_ACK_HUFF_MULT_CODE_ERROR_IRQ_ACK_SHIFT 28
#define  JPEG_CORE_IRQ_ACK_HUFF_MULT_CODE_ERROR_IRQ_ACK_MASK_SHIFT(reg) (((reg) & JPEG_CORE_IRQ_ACK_HUFF_MULT_CODE_ERROR_IRQ_ACK_MASK) >> JPEG_CORE_IRQ_ACK_HUFF_MULT_CODE_ERROR_IRQ_ACK_SHIFT)
#define  JPEG_CORE_IRQ_ACK_HUFF_MULT_CODE_ERROR_IRQ_ACK_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_IRQ_ACK_HUFF_MULT_CODE_ERROR_IRQ_ACK_MASK) | (((uint32_t)val) << JPEG_CORE_IRQ_ACK_HUFF_MULT_CODE_ERROR_IRQ_ACK_SHIFT))

#define  JPEG_CORE_IRQ_ACK_RESERVED1_MASK 0xfffffe0
#define  JPEG_CORE_IRQ_ACK_RESERVED1_SHIFT 5
#define  JPEG_CORE_IRQ_ACK_RESERVED1_MASK_SHIFT(reg) (((reg) & JPEG_CORE_IRQ_ACK_RESERVED1_MASK) >> JPEG_CORE_IRQ_ACK_RESERVED1_SHIFT)
#define  JPEG_CORE_IRQ_ACK_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_IRQ_ACK_RESERVED1_MASK) | (((uint32_t)val) << JPEG_CORE_IRQ_ACK_RESERVED1_SHIFT))

#define  JPEG_CORE_IRQ_ACK_HUFF_DONE_IRQ_ACK_MASK 0x10
#define  JPEG_CORE_IRQ_ACK_HUFF_DONE_IRQ_ACK_SHIFT 4
#define  JPEG_CORE_IRQ_ACK_HUFF_DONE_IRQ_ACK_MASK_SHIFT(reg) (((reg) & JPEG_CORE_IRQ_ACK_HUFF_DONE_IRQ_ACK_MASK) >> JPEG_CORE_IRQ_ACK_HUFF_DONE_IRQ_ACK_SHIFT)
#define  JPEG_CORE_IRQ_ACK_HUFF_DONE_IRQ_ACK_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_IRQ_ACK_HUFF_DONE_IRQ_ACK_MASK) | (((uint32_t)val) << JPEG_CORE_IRQ_ACK_HUFF_DONE_IRQ_ACK_SHIFT))

#define  JPEG_CORE_IRQ_ACK_HUFF_UNSTUFF_NON_EOI_IRQ_ACK_MASK 0x8
#define  JPEG_CORE_IRQ_ACK_HUFF_UNSTUFF_NON_EOI_IRQ_ACK_SHIFT 3
#define  JPEG_CORE_IRQ_ACK_HUFF_UNSTUFF_NON_EOI_IRQ_ACK_MASK_SHIFT(reg) (((reg) & JPEG_CORE_IRQ_ACK_HUFF_UNSTUFF_NON_EOI_IRQ_ACK_MASK) >> JPEG_CORE_IRQ_ACK_HUFF_UNSTUFF_NON_EOI_IRQ_ACK_SHIFT)
#define  JPEG_CORE_IRQ_ACK_HUFF_UNSTUFF_NON_EOI_IRQ_ACK_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_IRQ_ACK_HUFF_UNSTUFF_NON_EOI_IRQ_ACK_MASK) | (((uint32_t)val) << JPEG_CORE_IRQ_ACK_HUFF_UNSTUFF_NON_EOI_IRQ_ACK_SHIFT))

#define  JPEG_CORE_IRQ_ACK_HUFF_UNSTUFF_EOI_IRQ_ACK_MASK 0x4
#define  JPEG_CORE_IRQ_ACK_HUFF_UNSTUFF_EOI_IRQ_ACK_SHIFT 2
#define  JPEG_CORE_IRQ_ACK_HUFF_UNSTUFF_EOI_IRQ_ACK_MASK_SHIFT(reg) (((reg) & JPEG_CORE_IRQ_ACK_HUFF_UNSTUFF_EOI_IRQ_ACK_MASK) >> JPEG_CORE_IRQ_ACK_HUFF_UNSTUFF_EOI_IRQ_ACK_SHIFT)
#define  JPEG_CORE_IRQ_ACK_HUFF_UNSTUFF_EOI_IRQ_ACK_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_IRQ_ACK_HUFF_UNSTUFF_EOI_IRQ_ACK_MASK) | (((uint32_t)val) << JPEG_CORE_IRQ_ACK_HUFF_UNSTUFF_EOI_IRQ_ACK_SHIFT))

#define  JPEG_CORE_IRQ_ACK_DECODE_DONE_IRQ_ACK_MASK 0x2
#define  JPEG_CORE_IRQ_ACK_DECODE_DONE_IRQ_ACK_SHIFT 1
#define  JPEG_CORE_IRQ_ACK_DECODE_DONE_IRQ_ACK_MASK_SHIFT(reg) (((reg) & JPEG_CORE_IRQ_ACK_DECODE_DONE_IRQ_ACK_MASK) >> JPEG_CORE_IRQ_ACK_DECODE_DONE_IRQ_ACK_SHIFT)
#define  JPEG_CORE_IRQ_ACK_DECODE_DONE_IRQ_ACK_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_IRQ_ACK_DECODE_DONE_IRQ_ACK_MASK) | (((uint32_t)val) << JPEG_CORE_IRQ_ACK_DECODE_DONE_IRQ_ACK_SHIFT))

#define  JPEG_CORE_IRQ_ACK_ENCODE_DONE_IRQ_ACK_MASK 0x1
#define  JPEG_CORE_IRQ_ACK_ENCODE_DONE_IRQ_ACK_SHIFT 0
#define  JPEG_CORE_IRQ_ACK_ENCODE_DONE_IRQ_ACK_MASK_SHIFT(reg) (((reg) & JPEG_CORE_IRQ_ACK_ENCODE_DONE_IRQ_ACK_MASK) >> JPEG_CORE_IRQ_ACK_ENCODE_DONE_IRQ_ACK_SHIFT)
#define  JPEG_CORE_IRQ_ACK_ENCODE_DONE_IRQ_ACK_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_IRQ_ACK_ENCODE_DONE_IRQ_ACK_MASK) | (((uint32_t)val) << JPEG_CORE_IRQ_ACK_ENCODE_DONE_IRQ_ACK_SHIFT))

//====================================================================
//Register: Interrupt Force Register (IRQ_FORCE)
/** \brief Write a 1 to the bit to force the interrupt for testing purposes. <br/> The Input and Output DMA interrupts must be forced via their respective registers.*/
//====================================================================

#define  JPEG_CORE_IRQ_FORCE_HUFF_RESTART_ERROR_IRQ_FORCE_MASK 0x80000000
#define  JPEG_CORE_IRQ_FORCE_HUFF_RESTART_ERROR_IRQ_FORCE_SHIFT 31
#define  JPEG_CORE_IRQ_FORCE_HUFF_RESTART_ERROR_IRQ_FORCE_MASK_SHIFT(reg) (((reg) & JPEG_CORE_IRQ_FORCE_HUFF_RESTART_ERROR_IRQ_FORCE_MASK) >> JPEG_CORE_IRQ_FORCE_HUFF_RESTART_ERROR_IRQ_FORCE_SHIFT)
#define  JPEG_CORE_IRQ_FORCE_HUFF_RESTART_ERROR_IRQ_FORCE_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_IRQ_FORCE_HUFF_RESTART_ERROR_IRQ_FORCE_MASK) | (((uint32_t)val) << JPEG_CORE_IRQ_FORCE_HUFF_RESTART_ERROR_IRQ_FORCE_SHIFT))

#define  JPEG_CORE_IRQ_FORCE_HUFF_EOI_ERROR_IRQ_FORCE_MASK 0x40000000
#define  JPEG_CORE_IRQ_FORCE_HUFF_EOI_ERROR_IRQ_FORCE_SHIFT 30
#define  JPEG_CORE_IRQ_FORCE_HUFF_EOI_ERROR_IRQ_FORCE_MASK_SHIFT(reg) (((reg) & JPEG_CORE_IRQ_FORCE_HUFF_EOI_ERROR_IRQ_FORCE_MASK) >> JPEG_CORE_IRQ_FORCE_HUFF_EOI_ERROR_IRQ_FORCE_SHIFT)
#define  JPEG_CORE_IRQ_FORCE_HUFF_EOI_ERROR_IRQ_FORCE_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_IRQ_FORCE_HUFF_EOI_ERROR_IRQ_FORCE_MASK) | (((uint32_t)val) << JPEG_CORE_IRQ_FORCE_HUFF_EOI_ERROR_IRQ_FORCE_SHIFT))

#define  JPEG_CORE_IRQ_FORCE_HUFF_NO_CODE_ERROR_IRQ_FORCE_MASK 0x20000000
#define  JPEG_CORE_IRQ_FORCE_HUFF_NO_CODE_ERROR_IRQ_FORCE_SHIFT 29
#define  JPEG_CORE_IRQ_FORCE_HUFF_NO_CODE_ERROR_IRQ_FORCE_MASK_SHIFT(reg) (((reg) & JPEG_CORE_IRQ_FORCE_HUFF_NO_CODE_ERROR_IRQ_FORCE_MASK) >> JPEG_CORE_IRQ_FORCE_HUFF_NO_CODE_ERROR_IRQ_FORCE_SHIFT)
#define  JPEG_CORE_IRQ_FORCE_HUFF_NO_CODE_ERROR_IRQ_FORCE_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_IRQ_FORCE_HUFF_NO_CODE_ERROR_IRQ_FORCE_MASK) | (((uint32_t)val) << JPEG_CORE_IRQ_FORCE_HUFF_NO_CODE_ERROR_IRQ_FORCE_SHIFT))

#define  JPEG_CORE_IRQ_FORCE_HUFF_MULT_CODE_ERROR_IRQ_FORCE_MASK 0x10000000
#define  JPEG_CORE_IRQ_FORCE_HUFF_MULT_CODE_ERROR_IRQ_FORCE_SHIFT 28
#define  JPEG_CORE_IRQ_FORCE_HUFF_MULT_CODE_ERROR_IRQ_FORCE_MASK_SHIFT(reg) (((reg) & JPEG_CORE_IRQ_FORCE_HUFF_MULT_CODE_ERROR_IRQ_FORCE_MASK) >> JPEG_CORE_IRQ_FORCE_HUFF_MULT_CODE_ERROR_IRQ_FORCE_SHIFT)
#define  JPEG_CORE_IRQ_FORCE_HUFF_MULT_CODE_ERROR_IRQ_FORCE_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_IRQ_FORCE_HUFF_MULT_CODE_ERROR_IRQ_FORCE_MASK) | (((uint32_t)val) << JPEG_CORE_IRQ_FORCE_HUFF_MULT_CODE_ERROR_IRQ_FORCE_SHIFT))

#define  JPEG_CORE_IRQ_FORCE_RESERVED1_MASK 0xfffffe0
#define  JPEG_CORE_IRQ_FORCE_RESERVED1_SHIFT 5
#define  JPEG_CORE_IRQ_FORCE_RESERVED1_MASK_SHIFT(reg) (((reg) & JPEG_CORE_IRQ_FORCE_RESERVED1_MASK) >> JPEG_CORE_IRQ_FORCE_RESERVED1_SHIFT)
#define  JPEG_CORE_IRQ_FORCE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_IRQ_FORCE_RESERVED1_MASK) | (((uint32_t)val) << JPEG_CORE_IRQ_FORCE_RESERVED1_SHIFT))

#define  JPEG_CORE_IRQ_FORCE_HUFF_DONE_IRQ_FORCE_MASK 0x10
#define  JPEG_CORE_IRQ_FORCE_HUFF_DONE_IRQ_FORCE_SHIFT 4
#define  JPEG_CORE_IRQ_FORCE_HUFF_DONE_IRQ_FORCE_MASK_SHIFT(reg) (((reg) & JPEG_CORE_IRQ_FORCE_HUFF_DONE_IRQ_FORCE_MASK) >> JPEG_CORE_IRQ_FORCE_HUFF_DONE_IRQ_FORCE_SHIFT)
#define  JPEG_CORE_IRQ_FORCE_HUFF_DONE_IRQ_FORCE_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_IRQ_FORCE_HUFF_DONE_IRQ_FORCE_MASK) | (((uint32_t)val) << JPEG_CORE_IRQ_FORCE_HUFF_DONE_IRQ_FORCE_SHIFT))

#define  JPEG_CORE_IRQ_FORCE_HUFF_UNSTUFF_NON_EOI_IRQ_FORCE_MASK 0x8
#define  JPEG_CORE_IRQ_FORCE_HUFF_UNSTUFF_NON_EOI_IRQ_FORCE_SHIFT 3
#define  JPEG_CORE_IRQ_FORCE_HUFF_UNSTUFF_NON_EOI_IRQ_FORCE_MASK_SHIFT(reg) (((reg) & JPEG_CORE_IRQ_FORCE_HUFF_UNSTUFF_NON_EOI_IRQ_FORCE_MASK) >> JPEG_CORE_IRQ_FORCE_HUFF_UNSTUFF_NON_EOI_IRQ_FORCE_SHIFT)
#define  JPEG_CORE_IRQ_FORCE_HUFF_UNSTUFF_NON_EOI_IRQ_FORCE_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_IRQ_FORCE_HUFF_UNSTUFF_NON_EOI_IRQ_FORCE_MASK) | (((uint32_t)val) << JPEG_CORE_IRQ_FORCE_HUFF_UNSTUFF_NON_EOI_IRQ_FORCE_SHIFT))

#define  JPEG_CORE_IRQ_FORCE_HUFF_UNSTUFF_EOI_IRQ_FORCE_MASK 0x4
#define  JPEG_CORE_IRQ_FORCE_HUFF_UNSTUFF_EOI_IRQ_FORCE_SHIFT 2
#define  JPEG_CORE_IRQ_FORCE_HUFF_UNSTUFF_EOI_IRQ_FORCE_MASK_SHIFT(reg) (((reg) & JPEG_CORE_IRQ_FORCE_HUFF_UNSTUFF_EOI_IRQ_FORCE_MASK) >> JPEG_CORE_IRQ_FORCE_HUFF_UNSTUFF_EOI_IRQ_FORCE_SHIFT)
#define  JPEG_CORE_IRQ_FORCE_HUFF_UNSTUFF_EOI_IRQ_FORCE_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_IRQ_FORCE_HUFF_UNSTUFF_EOI_IRQ_FORCE_MASK) | (((uint32_t)val) << JPEG_CORE_IRQ_FORCE_HUFF_UNSTUFF_EOI_IRQ_FORCE_SHIFT))

#define  JPEG_CORE_IRQ_FORCE_DECODE_DONE_IRQ_FORCE_MASK 0x2
#define  JPEG_CORE_IRQ_FORCE_DECODE_DONE_IRQ_FORCE_SHIFT 1
#define  JPEG_CORE_IRQ_FORCE_DECODE_DONE_IRQ_FORCE_MASK_SHIFT(reg) (((reg) & JPEG_CORE_IRQ_FORCE_DECODE_DONE_IRQ_FORCE_MASK) >> JPEG_CORE_IRQ_FORCE_DECODE_DONE_IRQ_FORCE_SHIFT)
#define  JPEG_CORE_IRQ_FORCE_DECODE_DONE_IRQ_FORCE_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_IRQ_FORCE_DECODE_DONE_IRQ_FORCE_MASK) | (((uint32_t)val) << JPEG_CORE_IRQ_FORCE_DECODE_DONE_IRQ_FORCE_SHIFT))

#define  JPEG_CORE_IRQ_FORCE_ENCODE_DONE_IRQ_FORCE_MASK 0x1
#define  JPEG_CORE_IRQ_FORCE_ENCODE_DONE_IRQ_FORCE_SHIFT 0
#define  JPEG_CORE_IRQ_FORCE_ENCODE_DONE_IRQ_FORCE_MASK_SHIFT(reg) (((reg) & JPEG_CORE_IRQ_FORCE_ENCODE_DONE_IRQ_FORCE_MASK) >> JPEG_CORE_IRQ_FORCE_ENCODE_DONE_IRQ_FORCE_SHIFT)
#define  JPEG_CORE_IRQ_FORCE_ENCODE_DONE_IRQ_FORCE_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_IRQ_FORCE_ENCODE_DONE_IRQ_FORCE_MASK) | (((uint32_t)val) << JPEG_CORE_IRQ_FORCE_ENCODE_DONE_IRQ_FORCE_SHIFT))

//====================================================================
//Register: Configuration Register (CR)
/** \brief This register configures the operation of the JPEG block.*/
//====================================================================

#define  JPEG_CORE_CR_CLR_HDR_DATA_MASK 0x80000000
#define  JPEG_CORE_CR_CLR_HDR_DATA_SHIFT 31
#define  JPEG_CORE_CR_CLR_HDR_DATA_MASK_SHIFT(reg) (((reg) & JPEG_CORE_CR_CLR_HDR_DATA_MASK) >> JPEG_CORE_CR_CLR_HDR_DATA_SHIFT)
#define  JPEG_CORE_CR_CLR_HDR_DATA_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_CR_CLR_HDR_DATA_MASK) | (((uint32_t)val) << JPEG_CORE_CR_CLR_HDR_DATA_SHIFT))

#define  JPEG_CORE_CR_SRAM_ACCESS_ENABLE_MASK 0x40000000
#define  JPEG_CORE_CR_SRAM_ACCESS_ENABLE_SHIFT 30
#define  JPEG_CORE_CR_SRAM_ACCESS_ENABLE_MASK_SHIFT(reg) (((reg) & JPEG_CORE_CR_SRAM_ACCESS_ENABLE_MASK) >> JPEG_CORE_CR_SRAM_ACCESS_ENABLE_SHIFT)
#define  JPEG_CORE_CR_SRAM_ACCESS_ENABLE_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_CR_SRAM_ACCESS_ENABLE_MASK) | (((uint32_t)val) << JPEG_CORE_CR_SRAM_ACCESS_ENABLE_SHIFT))

#define  JPEG_CORE_CR_RESERVED1_MASK 0x3fffe000
#define  JPEG_CORE_CR_RESERVED1_SHIFT 13
#define  JPEG_CORE_CR_RESERVED1_MASK_SHIFT(reg) (((reg) & JPEG_CORE_CR_RESERVED1_MASK) >> JPEG_CORE_CR_RESERVED1_SHIFT)
#define  JPEG_CORE_CR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_CR_RESERVED1_MASK) | (((uint32_t)val) << JPEG_CORE_CR_RESERVED1_SHIFT))

#define  JPEG_CORE_CR_HEADER_ENABLE_MASK 0x1000
#define  JPEG_CORE_CR_HEADER_ENABLE_SHIFT 12
#define  JPEG_CORE_CR_HEADER_ENABLE_MASK_SHIFT(reg) (((reg) & JPEG_CORE_CR_HEADER_ENABLE_MASK) >> JPEG_CORE_CR_HEADER_ENABLE_SHIFT)
#define  JPEG_CORE_CR_HEADER_ENABLE_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_CR_HEADER_ENABLE_MASK) | (((uint32_t)val) << JPEG_CORE_CR_HEADER_ENABLE_SHIFT))

#define  JPEG_CORE_CR_RESERVED2_MASK 0xc00
#define  JPEG_CORE_CR_RESERVED2_SHIFT 10
#define  JPEG_CORE_CR_RESERVED2_MASK_SHIFT(reg) (((reg) & JPEG_CORE_CR_RESERVED2_MASK) >> JPEG_CORE_CR_RESERVED2_SHIFT)
#define  JPEG_CORE_CR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_CR_RESERVED2_MASK) | (((uint32_t)val) << JPEG_CORE_CR_RESERVED2_SHIFT))

#define  JPEG_CORE_CR_MONO_CHAN_SEL_MASK 0x300
#define  JPEG_CORE_CR_MONO_CHAN_SEL_SHIFT 8
#define  JPEG_CORE_CR_MONO_CHAN_SEL_MASK_SHIFT(reg) (((reg) & JPEG_CORE_CR_MONO_CHAN_SEL_MASK) >> JPEG_CORE_CR_MONO_CHAN_SEL_SHIFT)
#define  JPEG_CORE_CR_MONO_CHAN_SEL_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_CR_MONO_CHAN_SEL_MASK) | (((uint32_t)val) << JPEG_CORE_CR_MONO_CHAN_SEL_SHIFT))

#define  JPEG_CORE_CR_RESERVED3_MASK 0xe0
#define  JPEG_CORE_CR_RESERVED3_SHIFT 5
#define  JPEG_CORE_CR_RESERVED3_MASK_SHIFT(reg) (((reg) & JPEG_CORE_CR_RESERVED3_MASK) >> JPEG_CORE_CR_RESERVED3_SHIFT)
#define  JPEG_CORE_CR_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_CR_RESERVED3_MASK) | (((uint32_t)val) << JPEG_CORE_CR_RESERVED3_SHIFT))

#define  JPEG_CORE_CR_AVG_N_DECIMATE_MASK 0x10
#define  JPEG_CORE_CR_AVG_N_DECIMATE_SHIFT 4
#define  JPEG_CORE_CR_AVG_N_DECIMATE_MASK_SHIFT(reg) (((reg) & JPEG_CORE_CR_AVG_N_DECIMATE_MASK) >> JPEG_CORE_CR_AVG_N_DECIMATE_SHIFT)
#define  JPEG_CORE_CR_AVG_N_DECIMATE_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_CR_AVG_N_DECIMATE_MASK) | (((uint32_t)val) << JPEG_CORE_CR_AVG_N_DECIMATE_SHIFT))

#define  JPEG_CORE_CR_RESERVED4_MASK 0xe
#define  JPEG_CORE_CR_RESERVED4_SHIFT 1
#define  JPEG_CORE_CR_RESERVED4_MASK_SHIFT(reg) (((reg) & JPEG_CORE_CR_RESERVED4_MASK) >> JPEG_CORE_CR_RESERVED4_SHIFT)
#define  JPEG_CORE_CR_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_CR_RESERVED4_MASK) | (((uint32_t)val) << JPEG_CORE_CR_RESERVED4_SHIFT))

#define  JPEG_CORE_CR_ENCODE_MODE_MASK 0x1
#define  JPEG_CORE_CR_ENCODE_MODE_SHIFT 0
#define  JPEG_CORE_CR_ENCODE_MODE_MASK_SHIFT(reg) (((reg) & JPEG_CORE_CR_ENCODE_MODE_MASK) >> JPEG_CORE_CR_ENCODE_MODE_SHIFT)
#define  JPEG_CORE_CR_ENCODE_MODE_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_CR_ENCODE_MODE_MASK) | (((uint32_t)val) << JPEG_CORE_CR_ENCODE_MODE_SHIFT))

//====================================================================
//Register: Image Configuration Register (IMAGE)
/** \brief Configures general image information used by multiple blocks. Specifically, this register provides overall image information.*/
//====================================================================

#define  JPEG_CORE_IMAGE_RESERVED1_MASK 0xc0000000
#define  JPEG_CORE_IMAGE_RESERVED1_SHIFT 30
#define  JPEG_CORE_IMAGE_RESERVED1_MASK_SHIFT(reg) (((reg) & JPEG_CORE_IMAGE_RESERVED1_MASK) >> JPEG_CORE_IMAGE_RESERVED1_SHIFT)
#define  JPEG_CORE_IMAGE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_IMAGE_RESERVED1_MASK) | (((uint32_t)val) << JPEG_CORE_IMAGE_RESERVED1_SHIFT))

#define  JPEG_CORE_IMAGE_NUM_PLANES_M1_MASK 0x30000000
#define  JPEG_CORE_IMAGE_NUM_PLANES_M1_SHIFT 28
#define  JPEG_CORE_IMAGE_NUM_PLANES_M1_MASK_SHIFT(reg) (((reg) & JPEG_CORE_IMAGE_NUM_PLANES_M1_MASK) >> JPEG_CORE_IMAGE_NUM_PLANES_M1_SHIFT)
#define  JPEG_CORE_IMAGE_NUM_PLANES_M1_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_IMAGE_NUM_PLANES_M1_MASK) | (((uint32_t)val) << JPEG_CORE_IMAGE_NUM_PLANES_M1_SHIFT))

#define  JPEG_CORE_IMAGE_RESERVED2_MASK 0xfffffff
#define  JPEG_CORE_IMAGE_RESERVED2_SHIFT 0
#define  JPEG_CORE_IMAGE_RESERVED2_MASK_SHIFT(reg) (((reg) & JPEG_CORE_IMAGE_RESERVED2_MASK) >> JPEG_CORE_IMAGE_RESERVED2_SHIFT)
#define  JPEG_CORE_IMAGE_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_IMAGE_RESERVED2_MASK) | (((uint32_t)val) << JPEG_CORE_IMAGE_RESERVED2_SHIFT))

//====================================================================
//Register: Image Dimensions Register (DIM)
/** \brief Configures the image dimensions. Any extra values outside of this range (due to MCU alignment or otherwise) are set to the pad value. The block will output the entire MCU on the edges and will not crop down to the size specified here.*/
//====================================================================

#define  JPEG_CORE_DIM_Y_MASK 0xffff0000
#define  JPEG_CORE_DIM_Y_SHIFT 16
#define  JPEG_CORE_DIM_Y_MASK_SHIFT(reg) (((reg) & JPEG_CORE_DIM_Y_MASK) >> JPEG_CORE_DIM_Y_SHIFT)
#define  JPEG_CORE_DIM_Y_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_DIM_Y_MASK) | (((uint32_t)val) << JPEG_CORE_DIM_Y_SHIFT))

#define  JPEG_CORE_DIM_X_MASK 0xffff
#define  JPEG_CORE_DIM_X_SHIFT 0
#define  JPEG_CORE_DIM_X_MASK_SHIFT(reg) (((reg) & JPEG_CORE_DIM_X_MASK) >> JPEG_CORE_DIM_X_SHIFT)
#define  JPEG_CORE_DIM_X_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_DIM_X_MASK) | (((uint32_t)val) << JPEG_CORE_DIM_X_SHIFT))

//====================================================================
//Register: Image Padding Register (PAD)
/** \brief Configures the image padding on the right of the image. This is needed to help with DMA alignment.*/
//====================================================================

#define  JPEG_CORE_PAD_RESERVED1_MASK 0xffffff00
#define  JPEG_CORE_PAD_RESERVED1_SHIFT 8
#define  JPEG_CORE_PAD_RESERVED1_MASK_SHIFT(reg) (((reg) & JPEG_CORE_PAD_RESERVED1_MASK) >> JPEG_CORE_PAD_RESERVED1_SHIFT)
#define  JPEG_CORE_PAD_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_PAD_RESERVED1_MASK) | (((uint32_t)val) << JPEG_CORE_PAD_RESERVED1_SHIFT))

#define  JPEG_CORE_PAD_PAD_X_MASK 0xff
#define  JPEG_CORE_PAD_PAD_X_SHIFT 0
#define  JPEG_CORE_PAD_PAD_X_MASK_SHIFT(reg) (((reg) & JPEG_CORE_PAD_PAD_X_MASK) >> JPEG_CORE_PAD_PAD_X_SHIFT)
#define  JPEG_CORE_PAD_PAD_X_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_PAD_PAD_X_MASK) | (((uint32_t)val) << JPEG_CORE_PAD_PAD_X_SHIFT))

//====================================================================
//Register: Image Padding Value Register (PAD_VAL)
/** \brief The value in this register will be used to pad the image. <br/> NOTE: This value is prior to the CSC.*/
//====================================================================

#define  JPEG_CORE_PAD_VAL_VALUE_MASK 0xffffffff
#define  JPEG_CORE_PAD_VAL_VALUE_SHIFT 0
#define  JPEG_CORE_PAD_VAL_VALUE_MASK_SHIFT(reg) (((reg) & JPEG_CORE_PAD_VAL_VALUE_MASK) >> JPEG_CORE_PAD_VAL_VALUE_SHIFT)
#define  JPEG_CORE_PAD_VAL_VALUE_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_PAD_VAL_VALUE_MASK) | (((uint32_t)val) << JPEG_CORE_PAD_VAL_VALUE_SHIFT))

//====================================================================
//Register: Sub-Sampling Format Register (SUB)
/** \brief Configures general image information used by multiple blocks. This register specifically provides sub-sampling information. Used by the MCU block.*/
//====================================================================

#define  JPEG_CORE_SUB_RESERVED1_MASK 0xc0000000
#define  JPEG_CORE_SUB_RESERVED1_SHIFT 30
#define  JPEG_CORE_SUB_RESERVED1_MASK_SHIFT(reg) (((reg) & JPEG_CORE_SUB_RESERVED1_MASK) >> JPEG_CORE_SUB_RESERVED1_SHIFT)
#define  JPEG_CORE_SUB_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_SUB_RESERVED1_MASK) | (((uint32_t)val) << JPEG_CORE_SUB_RESERVED1_SHIFT))

#define  JPEG_CORE_SUB_V3_M1_MASK 0x30000000
#define  JPEG_CORE_SUB_V3_M1_SHIFT 28
#define  JPEG_CORE_SUB_V3_M1_MASK_SHIFT(reg) (((reg) & JPEG_CORE_SUB_V3_M1_MASK) >> JPEG_CORE_SUB_V3_M1_SHIFT)
#define  JPEG_CORE_SUB_V3_M1_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_SUB_V3_M1_MASK) | (((uint32_t)val) << JPEG_CORE_SUB_V3_M1_SHIFT))

#define  JPEG_CORE_SUB_RESERVED2_MASK 0xc000000
#define  JPEG_CORE_SUB_RESERVED2_SHIFT 26
#define  JPEG_CORE_SUB_RESERVED2_MASK_SHIFT(reg) (((reg) & JPEG_CORE_SUB_RESERVED2_MASK) >> JPEG_CORE_SUB_RESERVED2_SHIFT)
#define  JPEG_CORE_SUB_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_SUB_RESERVED2_MASK) | (((uint32_t)val) << JPEG_CORE_SUB_RESERVED2_SHIFT))

#define  JPEG_CORE_SUB_H3_M1_MASK 0x3000000
#define  JPEG_CORE_SUB_H3_M1_SHIFT 24
#define  JPEG_CORE_SUB_H3_M1_MASK_SHIFT(reg) (((reg) & JPEG_CORE_SUB_H3_M1_MASK) >> JPEG_CORE_SUB_H3_M1_SHIFT)
#define  JPEG_CORE_SUB_H3_M1_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_SUB_H3_M1_MASK) | (((uint32_t)val) << JPEG_CORE_SUB_H3_M1_SHIFT))

#define  JPEG_CORE_SUB_RESERVED3_MASK 0xc00000
#define  JPEG_CORE_SUB_RESERVED3_SHIFT 22
#define  JPEG_CORE_SUB_RESERVED3_MASK_SHIFT(reg) (((reg) & JPEG_CORE_SUB_RESERVED3_MASK) >> JPEG_CORE_SUB_RESERVED3_SHIFT)
#define  JPEG_CORE_SUB_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_SUB_RESERVED3_MASK) | (((uint32_t)val) << JPEG_CORE_SUB_RESERVED3_SHIFT))

#define  JPEG_CORE_SUB_V2_M1_MASK 0x300000
#define  JPEG_CORE_SUB_V2_M1_SHIFT 20
#define  JPEG_CORE_SUB_V2_M1_MASK_SHIFT(reg) (((reg) & JPEG_CORE_SUB_V2_M1_MASK) >> JPEG_CORE_SUB_V2_M1_SHIFT)
#define  JPEG_CORE_SUB_V2_M1_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_SUB_V2_M1_MASK) | (((uint32_t)val) << JPEG_CORE_SUB_V2_M1_SHIFT))

#define  JPEG_CORE_SUB_RESERVED4_MASK 0xc0000
#define  JPEG_CORE_SUB_RESERVED4_SHIFT 18
#define  JPEG_CORE_SUB_RESERVED4_MASK_SHIFT(reg) (((reg) & JPEG_CORE_SUB_RESERVED4_MASK) >> JPEG_CORE_SUB_RESERVED4_SHIFT)
#define  JPEG_CORE_SUB_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_SUB_RESERVED4_MASK) | (((uint32_t)val) << JPEG_CORE_SUB_RESERVED4_SHIFT))

#define  JPEG_CORE_SUB_H2_M1_MASK 0x30000
#define  JPEG_CORE_SUB_H2_M1_SHIFT 16
#define  JPEG_CORE_SUB_H2_M1_MASK_SHIFT(reg) (((reg) & JPEG_CORE_SUB_H2_M1_MASK) >> JPEG_CORE_SUB_H2_M1_SHIFT)
#define  JPEG_CORE_SUB_H2_M1_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_SUB_H2_M1_MASK) | (((uint32_t)val) << JPEG_CORE_SUB_H2_M1_SHIFT))

#define  JPEG_CORE_SUB_RESERVED5_MASK 0xc000
#define  JPEG_CORE_SUB_RESERVED5_SHIFT 14
#define  JPEG_CORE_SUB_RESERVED5_MASK_SHIFT(reg) (((reg) & JPEG_CORE_SUB_RESERVED5_MASK) >> JPEG_CORE_SUB_RESERVED5_SHIFT)
#define  JPEG_CORE_SUB_RESERVED5_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_SUB_RESERVED5_MASK) | (((uint32_t)val) << JPEG_CORE_SUB_RESERVED5_SHIFT))

#define  JPEG_CORE_SUB_V1_M1_MASK 0x3000
#define  JPEG_CORE_SUB_V1_M1_SHIFT 12
#define  JPEG_CORE_SUB_V1_M1_MASK_SHIFT(reg) (((reg) & JPEG_CORE_SUB_V1_M1_MASK) >> JPEG_CORE_SUB_V1_M1_SHIFT)
#define  JPEG_CORE_SUB_V1_M1_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_SUB_V1_M1_MASK) | (((uint32_t)val) << JPEG_CORE_SUB_V1_M1_SHIFT))

#define  JPEG_CORE_SUB_RESERVED6_MASK 0xc00
#define  JPEG_CORE_SUB_RESERVED6_SHIFT 10
#define  JPEG_CORE_SUB_RESERVED6_MASK_SHIFT(reg) (((reg) & JPEG_CORE_SUB_RESERVED6_MASK) >> JPEG_CORE_SUB_RESERVED6_SHIFT)
#define  JPEG_CORE_SUB_RESERVED6_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_SUB_RESERVED6_MASK) | (((uint32_t)val) << JPEG_CORE_SUB_RESERVED6_SHIFT))

#define  JPEG_CORE_SUB_H1_M1_MASK 0x300
#define  JPEG_CORE_SUB_H1_M1_SHIFT 8
#define  JPEG_CORE_SUB_H1_M1_MASK_SHIFT(reg) (((reg) & JPEG_CORE_SUB_H1_M1_MASK) >> JPEG_CORE_SUB_H1_M1_SHIFT)
#define  JPEG_CORE_SUB_H1_M1_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_SUB_H1_M1_MASK) | (((uint32_t)val) << JPEG_CORE_SUB_H1_M1_SHIFT))

#define  JPEG_CORE_SUB_RESERVED7_MASK 0xc0
#define  JPEG_CORE_SUB_RESERVED7_SHIFT 6
#define  JPEG_CORE_SUB_RESERVED7_MASK_SHIFT(reg) (((reg) & JPEG_CORE_SUB_RESERVED7_MASK) >> JPEG_CORE_SUB_RESERVED7_SHIFT)
#define  JPEG_CORE_SUB_RESERVED7_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_SUB_RESERVED7_MASK) | (((uint32_t)val) << JPEG_CORE_SUB_RESERVED7_SHIFT))

#define  JPEG_CORE_SUB_V0_M1_MASK 0x30
#define  JPEG_CORE_SUB_V0_M1_SHIFT 4
#define  JPEG_CORE_SUB_V0_M1_MASK_SHIFT(reg) (((reg) & JPEG_CORE_SUB_V0_M1_MASK) >> JPEG_CORE_SUB_V0_M1_SHIFT)
#define  JPEG_CORE_SUB_V0_M1_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_SUB_V0_M1_MASK) | (((uint32_t)val) << JPEG_CORE_SUB_V0_M1_SHIFT))

#define  JPEG_CORE_SUB_RESERVED8_MASK 0xc
#define  JPEG_CORE_SUB_RESERVED8_SHIFT 2
#define  JPEG_CORE_SUB_RESERVED8_MASK_SHIFT(reg) (((reg) & JPEG_CORE_SUB_RESERVED8_MASK) >> JPEG_CORE_SUB_RESERVED8_SHIFT)
#define  JPEG_CORE_SUB_RESERVED8_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_SUB_RESERVED8_MASK) | (((uint32_t)val) << JPEG_CORE_SUB_RESERVED8_SHIFT))

#define  JPEG_CORE_SUB_H0_M1_MASK 0x3
#define  JPEG_CORE_SUB_H0_M1_SHIFT 0
#define  JPEG_CORE_SUB_H0_M1_MASK_SHIFT(reg) (((reg) & JPEG_CORE_SUB_H0_M1_MASK) >> JPEG_CORE_SUB_H0_M1_SHIFT)
#define  JPEG_CORE_SUB_H0_M1_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_SUB_H0_M1_MASK) | (((uint32_t)val) << JPEG_CORE_SUB_H0_M1_SHIFT))

//====================================================================
//Register: Huffman Configuration Register (HUFF)
/** \brief This register configures the general operation of the Huffman Decoder.*/
//====================================================================

#define  JPEG_CORE_HUFF_RESERVED1_MASK 0xffffff00
#define  JPEG_CORE_HUFF_RESERVED1_SHIFT 8
#define  JPEG_CORE_HUFF_RESERVED1_MASK_SHIFT(reg) (((reg) & JPEG_CORE_HUFF_RESERVED1_MASK) >> JPEG_CORE_HUFF_RESERVED1_SHIFT)
#define  JPEG_CORE_HUFF_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_HUFF_RESERVED1_MASK) | (((uint32_t)val) << JPEG_CORE_HUFF_RESERVED1_SHIFT))

#define  JPEG_CORE_HUFF_AC_TABLE_SEL_MASK 0xf0
#define  JPEG_CORE_HUFF_AC_TABLE_SEL_SHIFT 4
#define  JPEG_CORE_HUFF_AC_TABLE_SEL_MASK_SHIFT(reg) (((reg) & JPEG_CORE_HUFF_AC_TABLE_SEL_MASK) >> JPEG_CORE_HUFF_AC_TABLE_SEL_SHIFT)
#define  JPEG_CORE_HUFF_AC_TABLE_SEL_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_HUFF_AC_TABLE_SEL_MASK) | (((uint32_t)val) << JPEG_CORE_HUFF_AC_TABLE_SEL_SHIFT))

#define  JPEG_CORE_HUFF_DC_TABLE_SEL_MASK 0xf
#define  JPEG_CORE_HUFF_DC_TABLE_SEL_SHIFT 0
#define  JPEG_CORE_HUFF_DC_TABLE_SEL_MASK_SHIFT(reg) (((reg) & JPEG_CORE_HUFF_DC_TABLE_SEL_MASK) >> JPEG_CORE_HUFF_DC_TABLE_SEL_SHIFT)
#define  JPEG_CORE_HUFF_DC_TABLE_SEL_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_HUFF_DC_TABLE_SEL_MASK) | (((uint32_t)val) << JPEG_CORE_HUFF_DC_TABLE_SEL_SHIFT))

//====================================================================
//Register: Huffman Code Enable DC Register (HUFF_CODE_EN_DC)
/** \brief Bits in this register are used to tell the block if a code of a certain length
      is in the table.*/
//====================================================================

#define  JPEG_CORE_HUFF_CODE_EN_DC_DC_CODE_EN_1_MASK 0xffff0000
#define  JPEG_CORE_HUFF_CODE_EN_DC_DC_CODE_EN_1_SHIFT 16
#define  JPEG_CORE_HUFF_CODE_EN_DC_DC_CODE_EN_1_MASK_SHIFT(reg) (((reg) & JPEG_CORE_HUFF_CODE_EN_DC_DC_CODE_EN_1_MASK) >> JPEG_CORE_HUFF_CODE_EN_DC_DC_CODE_EN_1_SHIFT)
#define  JPEG_CORE_HUFF_CODE_EN_DC_DC_CODE_EN_1_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_HUFF_CODE_EN_DC_DC_CODE_EN_1_MASK) | (((uint32_t)val) << JPEG_CORE_HUFF_CODE_EN_DC_DC_CODE_EN_1_SHIFT))

#define  JPEG_CORE_HUFF_CODE_EN_DC_DC_CODE_EN_0_MASK 0xffff
#define  JPEG_CORE_HUFF_CODE_EN_DC_DC_CODE_EN_0_SHIFT 0
#define  JPEG_CORE_HUFF_CODE_EN_DC_DC_CODE_EN_0_MASK_SHIFT(reg) (((reg) & JPEG_CORE_HUFF_CODE_EN_DC_DC_CODE_EN_0_MASK) >> JPEG_CORE_HUFF_CODE_EN_DC_DC_CODE_EN_0_SHIFT)
#define  JPEG_CORE_HUFF_CODE_EN_DC_DC_CODE_EN_0_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_HUFF_CODE_EN_DC_DC_CODE_EN_0_MASK) | (((uint32_t)val) << JPEG_CORE_HUFF_CODE_EN_DC_DC_CODE_EN_0_SHIFT))

//====================================================================
//Register: Huffman Code Enable AC Register (HUFF_CODE_EN_AC)
/** \brief Bits in this register are used to tell the block if a code of a certain length
      is in the table.*/
//====================================================================

#define  JPEG_CORE_HUFF_CODE_EN_AC_AC_CODE_EN_1_MASK 0xffff0000
#define  JPEG_CORE_HUFF_CODE_EN_AC_AC_CODE_EN_1_SHIFT 16
#define  JPEG_CORE_HUFF_CODE_EN_AC_AC_CODE_EN_1_MASK_SHIFT(reg) (((reg) & JPEG_CORE_HUFF_CODE_EN_AC_AC_CODE_EN_1_MASK) >> JPEG_CORE_HUFF_CODE_EN_AC_AC_CODE_EN_1_SHIFT)
#define  JPEG_CORE_HUFF_CODE_EN_AC_AC_CODE_EN_1_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_HUFF_CODE_EN_AC_AC_CODE_EN_1_MASK) | (((uint32_t)val) << JPEG_CORE_HUFF_CODE_EN_AC_AC_CODE_EN_1_SHIFT))

#define  JPEG_CORE_HUFF_CODE_EN_AC_AC_CODE_EN_0_MASK 0xffff
#define  JPEG_CORE_HUFF_CODE_EN_AC_AC_CODE_EN_0_SHIFT 0
#define  JPEG_CORE_HUFF_CODE_EN_AC_AC_CODE_EN_0_MASK_SHIFT(reg) (((reg) & JPEG_CORE_HUFF_CODE_EN_AC_AC_CODE_EN_0_MASK) >> JPEG_CORE_HUFF_CODE_EN_AC_AC_CODE_EN_0_SHIFT)
#define  JPEG_CORE_HUFF_CODE_EN_AC_AC_CODE_EN_0_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_HUFF_CODE_EN_AC_AC_CODE_EN_0_MASK) | (((uint32_t)val) << JPEG_CORE_HUFF_CODE_EN_AC_AC_CODE_EN_0_SHIFT))

//====================================================================
//Register: Restart Configuration Register (RESTART)
/** \brief Provides information about restart intervals.*/
//====================================================================

#define  JPEG_CORE_RESTART_RESTART_ENABLE_MASK 0x80000000
#define  JPEG_CORE_RESTART_RESTART_ENABLE_SHIFT 31
#define  JPEG_CORE_RESTART_RESTART_ENABLE_MASK_SHIFT(reg) (((reg) & JPEG_CORE_RESTART_RESTART_ENABLE_MASK) >> JPEG_CORE_RESTART_RESTART_ENABLE_SHIFT)
#define  JPEG_CORE_RESTART_RESTART_ENABLE_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_RESTART_RESTART_ENABLE_MASK) | (((uint32_t)val) << JPEG_CORE_RESTART_RESTART_ENABLE_SHIFT))

#define  JPEG_CORE_RESTART_RESERVED1_MASK 0x7fff0000
#define  JPEG_CORE_RESTART_RESERVED1_SHIFT 16
#define  JPEG_CORE_RESTART_RESERVED1_MASK_SHIFT(reg) (((reg) & JPEG_CORE_RESTART_RESERVED1_MASK) >> JPEG_CORE_RESTART_RESERVED1_SHIFT)
#define  JPEG_CORE_RESTART_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_RESTART_RESERVED1_MASK) | (((uint32_t)val) << JPEG_CORE_RESTART_RESERVED1_SHIFT))

#define  JPEG_CORE_RESTART_RESTART_INTERVAL_M1_MASK 0xffff
#define  JPEG_CORE_RESTART_RESTART_INTERVAL_M1_SHIFT 0
#define  JPEG_CORE_RESTART_RESTART_INTERVAL_M1_MASK_SHIFT(reg) (((reg) & JPEG_CORE_RESTART_RESTART_INTERVAL_M1_MASK) >> JPEG_CORE_RESTART_RESTART_INTERVAL_M1_SHIFT)
#define  JPEG_CORE_RESTART_RESTART_INTERVAL_M1_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_RESTART_RESTART_INTERVAL_M1_MASK) | (((uint32_t)val) << JPEG_CORE_RESTART_RESTART_INTERVAL_M1_SHIFT))

//====================================================================
//Register: Quantization Configuration Register (QUANT)
/** \brief This register configures the general operation of the QUANT block.*/
//====================================================================

#define  JPEG_CORE_QUANT_RESERVED1_MASK 0xffffff00
#define  JPEG_CORE_QUANT_RESERVED1_SHIFT 8
#define  JPEG_CORE_QUANT_RESERVED1_MASK_SHIFT(reg) (((reg) & JPEG_CORE_QUANT_RESERVED1_MASK) >> JPEG_CORE_QUANT_RESERVED1_SHIFT)
#define  JPEG_CORE_QUANT_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_QUANT_RESERVED1_MASK) | (((uint32_t)val) << JPEG_CORE_QUANT_RESERVED1_SHIFT))

#define  JPEG_CORE_QUANT_Q_MAP_3_MASK 0xc0
#define  JPEG_CORE_QUANT_Q_MAP_3_SHIFT 6
#define  JPEG_CORE_QUANT_Q_MAP_3_MASK_SHIFT(reg) (((reg) & JPEG_CORE_QUANT_Q_MAP_3_MASK) >> JPEG_CORE_QUANT_Q_MAP_3_SHIFT)
#define  JPEG_CORE_QUANT_Q_MAP_3_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_QUANT_Q_MAP_3_MASK) | (((uint32_t)val) << JPEG_CORE_QUANT_Q_MAP_3_SHIFT))

#define  JPEG_CORE_QUANT_Q_MAP_2_MASK 0x30
#define  JPEG_CORE_QUANT_Q_MAP_2_SHIFT 4
#define  JPEG_CORE_QUANT_Q_MAP_2_MASK_SHIFT(reg) (((reg) & JPEG_CORE_QUANT_Q_MAP_2_MASK) >> JPEG_CORE_QUANT_Q_MAP_2_SHIFT)
#define  JPEG_CORE_QUANT_Q_MAP_2_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_QUANT_Q_MAP_2_MASK) | (((uint32_t)val) << JPEG_CORE_QUANT_Q_MAP_2_SHIFT))

#define  JPEG_CORE_QUANT_Q_MAP_1_MASK 0xc
#define  JPEG_CORE_QUANT_Q_MAP_1_SHIFT 2
#define  JPEG_CORE_QUANT_Q_MAP_1_MASK_SHIFT(reg) (((reg) & JPEG_CORE_QUANT_Q_MAP_1_MASK) >> JPEG_CORE_QUANT_Q_MAP_1_SHIFT)
#define  JPEG_CORE_QUANT_Q_MAP_1_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_QUANT_Q_MAP_1_MASK) | (((uint32_t)val) << JPEG_CORE_QUANT_Q_MAP_1_SHIFT))

#define  JPEG_CORE_QUANT_Q_MAP_0_MASK 0x3
#define  JPEG_CORE_QUANT_Q_MAP_0_SHIFT 0
#define  JPEG_CORE_QUANT_Q_MAP_0_MASK_SHIFT(reg) (((reg) & JPEG_CORE_QUANT_Q_MAP_0_MASK) >> JPEG_CORE_QUANT_Q_MAP_0_SHIFT)
#define  JPEG_CORE_QUANT_Q_MAP_0_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_QUANT_Q_MAP_0_MASK) | (((uint32_t)val) << JPEG_CORE_QUANT_Q_MAP_0_SHIFT))

//====================================================================
//Register: ECS Offset Configuration Register (ECS_OFFSET)
/** \brief This tells the JPEG block how to locate the first byte of the ECS.*/
//====================================================================

#define  JPEG_CORE_ECS_OFFSET_RESERVED1_MASK 0xfff00000
#define  JPEG_CORE_ECS_OFFSET_RESERVED1_SHIFT 20
#define  JPEG_CORE_ECS_OFFSET_RESERVED1_MASK_SHIFT(reg) (((reg) & JPEG_CORE_ECS_OFFSET_RESERVED1_MASK) >> JPEG_CORE_ECS_OFFSET_RESERVED1_SHIFT)
#define  JPEG_CORE_ECS_OFFSET_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_ECS_OFFSET_RESERVED1_MASK) | (((uint32_t)val) << JPEG_CORE_ECS_OFFSET_RESERVED1_SHIFT))

#define  JPEG_CORE_ECS_OFFSET_ECS_OFFSET_MASK 0xfffff
#define  JPEG_CORE_ECS_OFFSET_ECS_OFFSET_SHIFT 0
#define  JPEG_CORE_ECS_OFFSET_ECS_OFFSET_MASK_SHIFT(reg) (((reg) & JPEG_CORE_ECS_OFFSET_ECS_OFFSET_MASK) >> JPEG_CORE_ECS_OFFSET_ECS_OFFSET_SHIFT)
#define  JPEG_CORE_ECS_OFFSET_ECS_OFFSET_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_ECS_OFFSET_ECS_OFFSET_MASK) | (((uint32_t)val) << JPEG_CORE_ECS_OFFSET_ECS_OFFSET_SHIFT))

//====================================================================
//Register: IP Tagging Revision 0 (REV0)
/** \brief Provide means for firmware to read IP tagging information.
      This register of particular interest to firmware.*/
//====================================================================

#define  JPEG_CORE_REV0_MAJ_MASK 0xffff0000
#define  JPEG_CORE_REV0_MAJ_SHIFT 16
#define  JPEG_CORE_REV0_MAJ_MASK_SHIFT(reg) (((reg) & JPEG_CORE_REV0_MAJ_MASK) >> JPEG_CORE_REV0_MAJ_SHIFT)
#define  JPEG_CORE_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_REV0_MAJ_MASK) | (((uint32_t)val) << JPEG_CORE_REV0_MAJ_SHIFT))

#define  JPEG_CORE_REV0_MID_MASK 0xffff
#define  JPEG_CORE_REV0_MID_SHIFT 0
#define  JPEG_CORE_REV0_MID_MASK_SHIFT(reg) (((reg) & JPEG_CORE_REV0_MID_MASK) >> JPEG_CORE_REV0_MID_SHIFT)
#define  JPEG_CORE_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_REV0_MID_MASK) | (((uint32_t)val) << JPEG_CORE_REV0_MID_SHIFT))

//====================================================================
//Register: IP Tagging Revision 1 (REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  JPEG_CORE_REV1_RESERVED1_MASK 0xffff0000
#define  JPEG_CORE_REV1_RESERVED1_SHIFT 16
#define  JPEG_CORE_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & JPEG_CORE_REV1_RESERVED1_MASK) >> JPEG_CORE_REV1_RESERVED1_SHIFT)
#define  JPEG_CORE_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_REV1_RESERVED1_MASK) | (((uint32_t)val) << JPEG_CORE_REV1_RESERVED1_SHIFT))

#define  JPEG_CORE_REV1_CFG_MASK 0xffff
#define  JPEG_CORE_REV1_CFG_SHIFT 0
#define  JPEG_CORE_REV1_CFG_MASK_SHIFT(reg) (((reg) & JPEG_CORE_REV1_CFG_MASK) >> JPEG_CORE_REV1_CFG_SHIFT)
#define  JPEG_CORE_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_REV1_CFG_MASK) | (((uint32_t)val) << JPEG_CORE_REV1_CFG_SHIFT))

//====================================================================
//Register: Status 0 Register (STATUS0)
/** \brief Provides block status bits.*/
//====================================================================

#define  JPEG_CORE_STATUS0_RESERVED1_MASK 0xffff0000
#define  JPEG_CORE_STATUS0_RESERVED1_SHIFT 16
#define  JPEG_CORE_STATUS0_RESERVED1_MASK_SHIFT(reg) (((reg) & JPEG_CORE_STATUS0_RESERVED1_MASK) >> JPEG_CORE_STATUS0_RESERVED1_SHIFT)
#define  JPEG_CORE_STATUS0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_STATUS0_RESERVED1_MASK) | (((uint32_t)val) << JPEG_CORE_STATUS0_RESERVED1_SHIFT))

#define  JPEG_CORE_STATUS0_HUFF_DEC_CURR_RESTART_CNT_MASK 0xffff
#define  JPEG_CORE_STATUS0_HUFF_DEC_CURR_RESTART_CNT_SHIFT 0
#define  JPEG_CORE_STATUS0_HUFF_DEC_CURR_RESTART_CNT_MASK_SHIFT(reg) (((reg) & JPEG_CORE_STATUS0_HUFF_DEC_CURR_RESTART_CNT_MASK) >> JPEG_CORE_STATUS0_HUFF_DEC_CURR_RESTART_CNT_SHIFT)
#define  JPEG_CORE_STATUS0_HUFF_DEC_CURR_RESTART_CNT_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_STATUS0_HUFF_DEC_CURR_RESTART_CNT_MASK) | (((uint32_t)val) << JPEG_CORE_STATUS0_HUFF_DEC_CURR_RESTART_CNT_SHIFT))

//====================================================================
//Register: Status 1 Register (STATUS1)
/** \brief Provides block status bits.*/
//====================================================================

#define  JPEG_CORE_STATUS1_HUFF_DEC_CURR_Y_MASK 0xffff0000
#define  JPEG_CORE_STATUS1_HUFF_DEC_CURR_Y_SHIFT 16
#define  JPEG_CORE_STATUS1_HUFF_DEC_CURR_Y_MASK_SHIFT(reg) (((reg) & JPEG_CORE_STATUS1_HUFF_DEC_CURR_Y_MASK) >> JPEG_CORE_STATUS1_HUFF_DEC_CURR_Y_SHIFT)
#define  JPEG_CORE_STATUS1_HUFF_DEC_CURR_Y_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_STATUS1_HUFF_DEC_CURR_Y_MASK) | (((uint32_t)val) << JPEG_CORE_STATUS1_HUFF_DEC_CURR_Y_SHIFT))

#define  JPEG_CORE_STATUS1_HUFF_DEC_CURR_X_MASK 0xffff
#define  JPEG_CORE_STATUS1_HUFF_DEC_CURR_X_SHIFT 0
#define  JPEG_CORE_STATUS1_HUFF_DEC_CURR_X_MASK_SHIFT(reg) (((reg) & JPEG_CORE_STATUS1_HUFF_DEC_CURR_X_MASK) >> JPEG_CORE_STATUS1_HUFF_DEC_CURR_X_SHIFT)
#define  JPEG_CORE_STATUS1_HUFF_DEC_CURR_X_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_STATUS1_HUFF_DEC_CURR_X_MASK) | (((uint32_t)val) << JPEG_CORE_STATUS1_HUFF_DEC_CURR_X_SHIFT))

//====================================================================
//Register: Status 2 Register (STATUS2)
/** \brief Provides block status bits.*/
//====================================================================

#define  JPEG_CORE_STATUS2_RESERVED1_MASK 0xfc000000
#define  JPEG_CORE_STATUS2_RESERVED1_SHIFT 26
#define  JPEG_CORE_STATUS2_RESERVED1_MASK_SHIFT(reg) (((reg) & JPEG_CORE_STATUS2_RESERVED1_MASK) >> JPEG_CORE_STATUS2_RESERVED1_SHIFT)
#define  JPEG_CORE_STATUS2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_STATUS2_RESERVED1_MASK) | (((uint32_t)val) << JPEG_CORE_STATUS2_RESERVED1_SHIFT))

#define  JPEG_CORE_STATUS2_HUFF_DEC_CURR_PLANE_MASK 0x3000000
#define  JPEG_CORE_STATUS2_HUFF_DEC_CURR_PLANE_SHIFT 24
#define  JPEG_CORE_STATUS2_HUFF_DEC_CURR_PLANE_MASK_SHIFT(reg) (((reg) & JPEG_CORE_STATUS2_HUFF_DEC_CURR_PLANE_MASK) >> JPEG_CORE_STATUS2_HUFF_DEC_CURR_PLANE_SHIFT)
#define  JPEG_CORE_STATUS2_HUFF_DEC_CURR_PLANE_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_STATUS2_HUFF_DEC_CURR_PLANE_MASK) | (((uint32_t)val) << JPEG_CORE_STATUS2_HUFF_DEC_CURR_PLANE_SHIFT))

#define  JPEG_CORE_STATUS2_HUFF_DEC_CURR_STATE_MASK 0xe00000
#define  JPEG_CORE_STATUS2_HUFF_DEC_CURR_STATE_SHIFT 21
#define  JPEG_CORE_STATUS2_HUFF_DEC_CURR_STATE_MASK_SHIFT(reg) (((reg) & JPEG_CORE_STATUS2_HUFF_DEC_CURR_STATE_MASK) >> JPEG_CORE_STATUS2_HUFF_DEC_CURR_STATE_SHIFT)
#define  JPEG_CORE_STATUS2_HUFF_DEC_CURR_STATE_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_STATUS2_HUFF_DEC_CURR_STATE_MASK) | (((uint32_t)val) << JPEG_CORE_STATUS2_HUFF_DEC_CURR_STATE_SHIFT))

#define  JPEG_CORE_STATUS2_HUFF_DEC_CURR_ERROR_MASK 0x100000
#define  JPEG_CORE_STATUS2_HUFF_DEC_CURR_ERROR_SHIFT 20
#define  JPEG_CORE_STATUS2_HUFF_DEC_CURR_ERROR_MASK_SHIFT(reg) (((reg) & JPEG_CORE_STATUS2_HUFF_DEC_CURR_ERROR_MASK) >> JPEG_CORE_STATUS2_HUFF_DEC_CURR_ERROR_SHIFT)
#define  JPEG_CORE_STATUS2_HUFF_DEC_CURR_ERROR_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_STATUS2_HUFF_DEC_CURR_ERROR_MASK) | (((uint32_t)val) << JPEG_CORE_STATUS2_HUFF_DEC_CURR_ERROR_SHIFT))

#define  JPEG_CORE_STATUS2_ZZ_CURR_SRAM1_PLANE_MASK 0xc0000
#define  JPEG_CORE_STATUS2_ZZ_CURR_SRAM1_PLANE_SHIFT 18
#define  JPEG_CORE_STATUS2_ZZ_CURR_SRAM1_PLANE_MASK_SHIFT(reg) (((reg) & JPEG_CORE_STATUS2_ZZ_CURR_SRAM1_PLANE_MASK) >> JPEG_CORE_STATUS2_ZZ_CURR_SRAM1_PLANE_SHIFT)
#define  JPEG_CORE_STATUS2_ZZ_CURR_SRAM1_PLANE_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_STATUS2_ZZ_CURR_SRAM1_PLANE_MASK) | (((uint32_t)val) << JPEG_CORE_STATUS2_ZZ_CURR_SRAM1_PLANE_SHIFT))

#define  JPEG_CORE_STATUS2_ZZ_CURR_SRAM0_PLANE_MASK 0x30000
#define  JPEG_CORE_STATUS2_ZZ_CURR_SRAM0_PLANE_SHIFT 16
#define  JPEG_CORE_STATUS2_ZZ_CURR_SRAM0_PLANE_MASK_SHIFT(reg) (((reg) & JPEG_CORE_STATUS2_ZZ_CURR_SRAM0_PLANE_MASK) >> JPEG_CORE_STATUS2_ZZ_CURR_SRAM0_PLANE_SHIFT)
#define  JPEG_CORE_STATUS2_ZZ_CURR_SRAM0_PLANE_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_STATUS2_ZZ_CURR_SRAM0_PLANE_MASK) | (((uint32_t)val) << JPEG_CORE_STATUS2_ZZ_CURR_SRAM0_PLANE_SHIFT))

#define  JPEG_CORE_STATUS2_ZZ_CURR_RD_ADDR_MASK 0xff00
#define  JPEG_CORE_STATUS2_ZZ_CURR_RD_ADDR_SHIFT 8
#define  JPEG_CORE_STATUS2_ZZ_CURR_RD_ADDR_MASK_SHIFT(reg) (((reg) & JPEG_CORE_STATUS2_ZZ_CURR_RD_ADDR_MASK) >> JPEG_CORE_STATUS2_ZZ_CURR_RD_ADDR_SHIFT)
#define  JPEG_CORE_STATUS2_ZZ_CURR_RD_ADDR_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_STATUS2_ZZ_CURR_RD_ADDR_MASK) | (((uint32_t)val) << JPEG_CORE_STATUS2_ZZ_CURR_RD_ADDR_SHIFT))

#define  JPEG_CORE_STATUS2_ZZ_CURR_WR_ADDR_MASK 0xff
#define  JPEG_CORE_STATUS2_ZZ_CURR_WR_ADDR_SHIFT 0
#define  JPEG_CORE_STATUS2_ZZ_CURR_WR_ADDR_MASK_SHIFT(reg) (((reg) & JPEG_CORE_STATUS2_ZZ_CURR_WR_ADDR_MASK) >> JPEG_CORE_STATUS2_ZZ_CURR_WR_ADDR_SHIFT)
#define  JPEG_CORE_STATUS2_ZZ_CURR_WR_ADDR_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_STATUS2_ZZ_CURR_WR_ADDR_MASK) | (((uint32_t)val) << JPEG_CORE_STATUS2_ZZ_CURR_WR_ADDR_SHIFT))

//====================================================================
//Register: Status 3 Register (STATUS3)
/** \brief Provides block status bits.*/
//====================================================================

#define  JPEG_CORE_STATUS3_MCU2PIX_CURR_Y_MASK 0xffff0000
#define  JPEG_CORE_STATUS3_MCU2PIX_CURR_Y_SHIFT 16
#define  JPEG_CORE_STATUS3_MCU2PIX_CURR_Y_MASK_SHIFT(reg) (((reg) & JPEG_CORE_STATUS3_MCU2PIX_CURR_Y_MASK) >> JPEG_CORE_STATUS3_MCU2PIX_CURR_Y_SHIFT)
#define  JPEG_CORE_STATUS3_MCU2PIX_CURR_Y_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_STATUS3_MCU2PIX_CURR_Y_MASK) | (((uint32_t)val) << JPEG_CORE_STATUS3_MCU2PIX_CURR_Y_SHIFT))

#define  JPEG_CORE_STATUS3_MCU2PIX_CURR_X_MASK 0xffff
#define  JPEG_CORE_STATUS3_MCU2PIX_CURR_X_SHIFT 0
#define  JPEG_CORE_STATUS3_MCU2PIX_CURR_X_MASK_SHIFT(reg) (((reg) & JPEG_CORE_STATUS3_MCU2PIX_CURR_X_MASK) >> JPEG_CORE_STATUS3_MCU2PIX_CURR_X_SHIFT)
#define  JPEG_CORE_STATUS3_MCU2PIX_CURR_X_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_STATUS3_MCU2PIX_CURR_X_MASK) | (((uint32_t)val) << JPEG_CORE_STATUS3_MCU2PIX_CURR_X_SHIFT))

//====================================================================
//Register: Status 4 Register (STATUS4)
/** \brief Provides block status bits.*/
//====================================================================

#define  JPEG_CORE_STATUS4_HUFF_ENC_CURR_PLANE_MASK 0xc0000000
#define  JPEG_CORE_STATUS4_HUFF_ENC_CURR_PLANE_SHIFT 30
#define  JPEG_CORE_STATUS4_HUFF_ENC_CURR_PLANE_MASK_SHIFT(reg) (((reg) & JPEG_CORE_STATUS4_HUFF_ENC_CURR_PLANE_MASK) >> JPEG_CORE_STATUS4_HUFF_ENC_CURR_PLANE_SHIFT)
#define  JPEG_CORE_STATUS4_HUFF_ENC_CURR_PLANE_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_STATUS4_HUFF_ENC_CURR_PLANE_MASK) | (((uint32_t)val) << JPEG_CORE_STATUS4_HUFF_ENC_CURR_PLANE_SHIFT))

#define  JPEG_CORE_STATUS4_RESERVED1_MASK 0x3fff0000
#define  JPEG_CORE_STATUS4_RESERVED1_SHIFT 16
#define  JPEG_CORE_STATUS4_RESERVED1_MASK_SHIFT(reg) (((reg) & JPEG_CORE_STATUS4_RESERVED1_MASK) >> JPEG_CORE_STATUS4_RESERVED1_SHIFT)
#define  JPEG_CORE_STATUS4_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_STATUS4_RESERVED1_MASK) | (((uint32_t)val) << JPEG_CORE_STATUS4_RESERVED1_SHIFT))

#define  JPEG_CORE_STATUS4_HUFF_ENC_CURR_RESTART_CNT_MASK 0xffff
#define  JPEG_CORE_STATUS4_HUFF_ENC_CURR_RESTART_CNT_SHIFT 0
#define  JPEG_CORE_STATUS4_HUFF_ENC_CURR_RESTART_CNT_MASK_SHIFT(reg) (((reg) & JPEG_CORE_STATUS4_HUFF_ENC_CURR_RESTART_CNT_MASK) >> JPEG_CORE_STATUS4_HUFF_ENC_CURR_RESTART_CNT_SHIFT)
#define  JPEG_CORE_STATUS4_HUFF_ENC_CURR_RESTART_CNT_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_STATUS4_HUFF_ENC_CURR_RESTART_CNT_MASK) | (((uint32_t)val) << JPEG_CORE_STATUS4_HUFF_ENC_CURR_RESTART_CNT_SHIFT))

//====================================================================
//Register: Status 5 Register (STATUS5)
/** \brief Provides block status bits.*/
//====================================================================

#define  JPEG_CORE_STATUS5_HUFF_ENC_CURR_Y_MASK 0xffff0000
#define  JPEG_CORE_STATUS5_HUFF_ENC_CURR_Y_SHIFT 16
#define  JPEG_CORE_STATUS5_HUFF_ENC_CURR_Y_MASK_SHIFT(reg) (((reg) & JPEG_CORE_STATUS5_HUFF_ENC_CURR_Y_MASK) >> JPEG_CORE_STATUS5_HUFF_ENC_CURR_Y_SHIFT)
#define  JPEG_CORE_STATUS5_HUFF_ENC_CURR_Y_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_STATUS5_HUFF_ENC_CURR_Y_MASK) | (((uint32_t)val) << JPEG_CORE_STATUS5_HUFF_ENC_CURR_Y_SHIFT))

#define  JPEG_CORE_STATUS5_HUFF_ENC_CURR_X_MASK 0xffff
#define  JPEG_CORE_STATUS5_HUFF_ENC_CURR_X_SHIFT 0
#define  JPEG_CORE_STATUS5_HUFF_ENC_CURR_X_MASK_SHIFT(reg) (((reg) & JPEG_CORE_STATUS5_HUFF_ENC_CURR_X_MASK) >> JPEG_CORE_STATUS5_HUFF_ENC_CURR_X_SHIFT)
#define  JPEG_CORE_STATUS5_HUFF_ENC_CURR_X_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_STATUS5_HUFF_ENC_CURR_X_MASK) | (((uint32_t)val) << JPEG_CORE_STATUS5_HUFF_ENC_CURR_X_SHIFT))

//====================================================================
//Register: Status 6 Register (STATUS6)
/** \brief Provides block status bits.*/
//====================================================================

#define  JPEG_CORE_STATUS6_RESERVED1_MASK 0xf8000000
#define  JPEG_CORE_STATUS6_RESERVED1_SHIFT 27
#define  JPEG_CORE_STATUS6_RESERVED1_MASK_SHIFT(reg) (((reg) & JPEG_CORE_STATUS6_RESERVED1_MASK) >> JPEG_CORE_STATUS6_RESERVED1_SHIFT)
#define  JPEG_CORE_STATUS6_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_STATUS6_RESERVED1_MASK) | (((uint32_t)val) << JPEG_CORE_STATUS6_RESERVED1_SHIFT))

#define  JPEG_CORE_STATUS6_HUFF_ENC_RLE_READY_MASK 0x4000000
#define  JPEG_CORE_STATUS6_HUFF_ENC_RLE_READY_SHIFT 26
#define  JPEG_CORE_STATUS6_HUFF_ENC_RLE_READY_MASK_SHIFT(reg) (((reg) & JPEG_CORE_STATUS6_HUFF_ENC_RLE_READY_MASK) >> JPEG_CORE_STATUS6_HUFF_ENC_RLE_READY_SHIFT)
#define  JPEG_CORE_STATUS6_HUFF_ENC_RLE_READY_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_STATUS6_HUFF_ENC_RLE_READY_MASK) | (((uint32_t)val) << JPEG_CORE_STATUS6_HUFF_ENC_RLE_READY_SHIFT))

#define  JPEG_CORE_STATUS6_HUFF_ENC_RLE_VALID_MASK 0x2000000
#define  JPEG_CORE_STATUS6_HUFF_ENC_RLE_VALID_SHIFT 25
#define  JPEG_CORE_STATUS6_HUFF_ENC_RLE_VALID_MASK_SHIFT(reg) (((reg) & JPEG_CORE_STATUS6_HUFF_ENC_RLE_VALID_MASK) >> JPEG_CORE_STATUS6_HUFF_ENC_RLE_VALID_SHIFT)
#define  JPEG_CORE_STATUS6_HUFF_ENC_RLE_VALID_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_STATUS6_HUFF_ENC_RLE_VALID_MASK) | (((uint32_t)val) << JPEG_CORE_STATUS6_HUFF_ENC_RLE_VALID_SHIFT))

#define  JPEG_CORE_STATUS6_HUFF_ENC_RLE_RESTART_MASK 0x1000000
#define  JPEG_CORE_STATUS6_HUFF_ENC_RLE_RESTART_SHIFT 24
#define  JPEG_CORE_STATUS6_HUFF_ENC_RLE_RESTART_MASK_SHIFT(reg) (((reg) & JPEG_CORE_STATUS6_HUFF_ENC_RLE_RESTART_MASK) >> JPEG_CORE_STATUS6_HUFF_ENC_RLE_RESTART_SHIFT)
#define  JPEG_CORE_STATUS6_HUFF_ENC_RLE_RESTART_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_STATUS6_HUFF_ENC_RLE_RESTART_MASK) | (((uint32_t)val) << JPEG_CORE_STATUS6_HUFF_ENC_RLE_RESTART_SHIFT))

#define  JPEG_CORE_STATUS6_HUFF_ENC_RLE_EOI_MASK 0x800000
#define  JPEG_CORE_STATUS6_HUFF_ENC_RLE_EOI_SHIFT 23
#define  JPEG_CORE_STATUS6_HUFF_ENC_RLE_EOI_MASK_SHIFT(reg) (((reg) & JPEG_CORE_STATUS6_HUFF_ENC_RLE_EOI_MASK) >> JPEG_CORE_STATUS6_HUFF_ENC_RLE_EOI_SHIFT)
#define  JPEG_CORE_STATUS6_HUFF_ENC_RLE_EOI_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_STATUS6_HUFF_ENC_RLE_EOI_MASK) | (((uint32_t)val) << JPEG_CORE_STATUS6_HUFF_ENC_RLE_EOI_SHIFT))

#define  JPEG_CORE_STATUS6_HUFF_ENC_RLE_DC_MASK 0x400000
#define  JPEG_CORE_STATUS6_HUFF_ENC_RLE_DC_SHIFT 22
#define  JPEG_CORE_STATUS6_HUFF_ENC_RLE_DC_MASK_SHIFT(reg) (((reg) & JPEG_CORE_STATUS6_HUFF_ENC_RLE_DC_MASK) >> JPEG_CORE_STATUS6_HUFF_ENC_RLE_DC_SHIFT)
#define  JPEG_CORE_STATUS6_HUFF_ENC_RLE_DC_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_STATUS6_HUFF_ENC_RLE_DC_MASK) | (((uint32_t)val) << JPEG_CORE_STATUS6_HUFF_ENC_RLE_DC_SHIFT))

#define  JPEG_CORE_STATUS6_HUFF_ENC_RLE_PLANE_MASK 0x300000
#define  JPEG_CORE_STATUS6_HUFF_ENC_RLE_PLANE_SHIFT 20
#define  JPEG_CORE_STATUS6_HUFF_ENC_RLE_PLANE_MASK_SHIFT(reg) (((reg) & JPEG_CORE_STATUS6_HUFF_ENC_RLE_PLANE_MASK) >> JPEG_CORE_STATUS6_HUFF_ENC_RLE_PLANE_SHIFT)
#define  JPEG_CORE_STATUS6_HUFF_ENC_RLE_PLANE_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_STATUS6_HUFF_ENC_RLE_PLANE_MASK) | (((uint32_t)val) << JPEG_CORE_STATUS6_HUFF_ENC_RLE_PLANE_SHIFT))

#define  JPEG_CORE_STATUS6_HUFF_ENC_RLE_SSSS_MASK 0xf0000
#define  JPEG_CORE_STATUS6_HUFF_ENC_RLE_SSSS_SHIFT 16
#define  JPEG_CORE_STATUS6_HUFF_ENC_RLE_SSSS_MASK_SHIFT(reg) (((reg) & JPEG_CORE_STATUS6_HUFF_ENC_RLE_SSSS_MASK) >> JPEG_CORE_STATUS6_HUFF_ENC_RLE_SSSS_SHIFT)
#define  JPEG_CORE_STATUS6_HUFF_ENC_RLE_SSSS_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_STATUS6_HUFF_ENC_RLE_SSSS_MASK) | (((uint32_t)val) << JPEG_CORE_STATUS6_HUFF_ENC_RLE_SSSS_SHIFT))

#define  JPEG_CORE_STATUS6_HUFF_ENC_RLE_RRRR_MASK 0xf000
#define  JPEG_CORE_STATUS6_HUFF_ENC_RLE_RRRR_SHIFT 12
#define  JPEG_CORE_STATUS6_HUFF_ENC_RLE_RRRR_MASK_SHIFT(reg) (((reg) & JPEG_CORE_STATUS6_HUFF_ENC_RLE_RRRR_MASK) >> JPEG_CORE_STATUS6_HUFF_ENC_RLE_RRRR_SHIFT)
#define  JPEG_CORE_STATUS6_HUFF_ENC_RLE_RRRR_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_STATUS6_HUFF_ENC_RLE_RRRR_MASK) | (((uint32_t)val) << JPEG_CORE_STATUS6_HUFF_ENC_RLE_RRRR_SHIFT))

#define  JPEG_CORE_STATUS6_RESERVED2_MASK 0x800
#define  JPEG_CORE_STATUS6_RESERVED2_SHIFT 11
#define  JPEG_CORE_STATUS6_RESERVED2_MASK_SHIFT(reg) (((reg) & JPEG_CORE_STATUS6_RESERVED2_MASK) >> JPEG_CORE_STATUS6_RESERVED2_SHIFT)
#define  JPEG_CORE_STATUS6_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_STATUS6_RESERVED2_MASK) | (((uint32_t)val) << JPEG_CORE_STATUS6_RESERVED2_SHIFT))

#define  JPEG_CORE_STATUS6_HUFF_ENC_RLE_VALUE_MASK 0x7ff
#define  JPEG_CORE_STATUS6_HUFF_ENC_RLE_VALUE_SHIFT 0
#define  JPEG_CORE_STATUS6_HUFF_ENC_RLE_VALUE_MASK_SHIFT(reg) (((reg) & JPEG_CORE_STATUS6_HUFF_ENC_RLE_VALUE_MASK) >> JPEG_CORE_STATUS6_HUFF_ENC_RLE_VALUE_SHIFT)
#define  JPEG_CORE_STATUS6_HUFF_ENC_RLE_VALUE_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_STATUS6_HUFF_ENC_RLE_VALUE_MASK) | (((uint32_t)val) << JPEG_CORE_STATUS6_HUFF_ENC_RLE_VALUE_SHIFT))

//====================================================================
//Register: Status 7 Register (STATUS7)
/** \brief Provides block status bits.*/
//====================================================================

#define  JPEG_CORE_STATUS7_RESERVED1_MASK 0xf0000000
#define  JPEG_CORE_STATUS7_RESERVED1_SHIFT 28
#define  JPEG_CORE_STATUS7_RESERVED1_MASK_SHIFT(reg) (((reg) & JPEG_CORE_STATUS7_RESERVED1_MASK) >> JPEG_CORE_STATUS7_RESERVED1_SHIFT)
#define  JPEG_CORE_STATUS7_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_STATUS7_RESERVED1_MASK) | (((uint32_t)val) << JPEG_CORE_STATUS7_RESERVED1_SHIFT))

#define  JPEG_CORE_STATUS7_PIX2MCU_OUT_READY_MASK 0x8000000
#define  JPEG_CORE_STATUS7_PIX2MCU_OUT_READY_SHIFT 27
#define  JPEG_CORE_STATUS7_PIX2MCU_OUT_READY_MASK_SHIFT(reg) (((reg) & JPEG_CORE_STATUS7_PIX2MCU_OUT_READY_MASK) >> JPEG_CORE_STATUS7_PIX2MCU_OUT_READY_SHIFT)
#define  JPEG_CORE_STATUS7_PIX2MCU_OUT_READY_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_STATUS7_PIX2MCU_OUT_READY_MASK) | (((uint32_t)val) << JPEG_CORE_STATUS7_PIX2MCU_OUT_READY_SHIFT))

#define  JPEG_CORE_STATUS7_PIX2MCU_OUT_VALID_MASK 0x4000000
#define  JPEG_CORE_STATUS7_PIX2MCU_OUT_VALID_SHIFT 26
#define  JPEG_CORE_STATUS7_PIX2MCU_OUT_VALID_MASK_SHIFT(reg) (((reg) & JPEG_CORE_STATUS7_PIX2MCU_OUT_VALID_MASK) >> JPEG_CORE_STATUS7_PIX2MCU_OUT_VALID_SHIFT)
#define  JPEG_CORE_STATUS7_PIX2MCU_OUT_VALID_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_STATUS7_PIX2MCU_OUT_VALID_MASK) | (((uint32_t)val) << JPEG_CORE_STATUS7_PIX2MCU_OUT_VALID_SHIFT))

#define  JPEG_CORE_STATUS7_PIX2MCU_OUT_PLANE_MASK 0x3000000
#define  JPEG_CORE_STATUS7_PIX2MCU_OUT_PLANE_SHIFT 24
#define  JPEG_CORE_STATUS7_PIX2MCU_OUT_PLANE_MASK_SHIFT(reg) (((reg) & JPEG_CORE_STATUS7_PIX2MCU_OUT_PLANE_MASK) >> JPEG_CORE_STATUS7_PIX2MCU_OUT_PLANE_SHIFT)
#define  JPEG_CORE_STATUS7_PIX2MCU_OUT_PLANE_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_STATUS7_PIX2MCU_OUT_PLANE_MASK) | (((uint32_t)val) << JPEG_CORE_STATUS7_PIX2MCU_OUT_PLANE_SHIFT))

#define  JPEG_CORE_STATUS7_PIX2MCU_OUT_DATA_MASK 0xff0000
#define  JPEG_CORE_STATUS7_PIX2MCU_OUT_DATA_SHIFT 16
#define  JPEG_CORE_STATUS7_PIX2MCU_OUT_DATA_MASK_SHIFT(reg) (((reg) & JPEG_CORE_STATUS7_PIX2MCU_OUT_DATA_MASK) >> JPEG_CORE_STATUS7_PIX2MCU_OUT_DATA_SHIFT)
#define  JPEG_CORE_STATUS7_PIX2MCU_OUT_DATA_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_STATUS7_PIX2MCU_OUT_DATA_MASK) | (((uint32_t)val) << JPEG_CORE_STATUS7_PIX2MCU_OUT_DATA_SHIFT))

#define  JPEG_CORE_STATUS7_RESERVED2_MASK 0xe000
#define  JPEG_CORE_STATUS7_RESERVED2_SHIFT 13
#define  JPEG_CORE_STATUS7_RESERVED2_MASK_SHIFT(reg) (((reg) & JPEG_CORE_STATUS7_RESERVED2_MASK) >> JPEG_CORE_STATUS7_RESERVED2_SHIFT)
#define  JPEG_CORE_STATUS7_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_STATUS7_RESERVED2_MASK) | (((uint32_t)val) << JPEG_CORE_STATUS7_RESERVED2_SHIFT))

#define  JPEG_CORE_STATUS7_HUFF_ENC_OUT_READY_MASK 0x1000
#define  JPEG_CORE_STATUS7_HUFF_ENC_OUT_READY_SHIFT 12
#define  JPEG_CORE_STATUS7_HUFF_ENC_OUT_READY_MASK_SHIFT(reg) (((reg) & JPEG_CORE_STATUS7_HUFF_ENC_OUT_READY_MASK) >> JPEG_CORE_STATUS7_HUFF_ENC_OUT_READY_SHIFT)
#define  JPEG_CORE_STATUS7_HUFF_ENC_OUT_READY_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_STATUS7_HUFF_ENC_OUT_READY_MASK) | (((uint32_t)val) << JPEG_CORE_STATUS7_HUFF_ENC_OUT_READY_SHIFT))

#define  JPEG_CORE_STATUS7_HUFF_ENC_OUT_VALID_MASK 0x800
#define  JPEG_CORE_STATUS7_HUFF_ENC_OUT_VALID_SHIFT 11
#define  JPEG_CORE_STATUS7_HUFF_ENC_OUT_VALID_MASK_SHIFT(reg) (((reg) & JPEG_CORE_STATUS7_HUFF_ENC_OUT_VALID_MASK) >> JPEG_CORE_STATUS7_HUFF_ENC_OUT_VALID_SHIFT)
#define  JPEG_CORE_STATUS7_HUFF_ENC_OUT_VALID_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_STATUS7_HUFF_ENC_OUT_VALID_MASK) | (((uint32_t)val) << JPEG_CORE_STATUS7_HUFF_ENC_OUT_VALID_SHIFT))

#define  JPEG_CORE_STATUS7_HUFF_ENC_OUT_EOI_MASK 0x400
#define  JPEG_CORE_STATUS7_HUFF_ENC_OUT_EOI_SHIFT 10
#define  JPEG_CORE_STATUS7_HUFF_ENC_OUT_EOI_MASK_SHIFT(reg) (((reg) & JPEG_CORE_STATUS7_HUFF_ENC_OUT_EOI_MASK) >> JPEG_CORE_STATUS7_HUFF_ENC_OUT_EOI_SHIFT)
#define  JPEG_CORE_STATUS7_HUFF_ENC_OUT_EOI_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_STATUS7_HUFF_ENC_OUT_EOI_MASK) | (((uint32_t)val) << JPEG_CORE_STATUS7_HUFF_ENC_OUT_EOI_SHIFT))

#define  JPEG_CORE_STATUS7_HUFF_ENC_OUT_DT_MASK 0x300
#define  JPEG_CORE_STATUS7_HUFF_ENC_OUT_DT_SHIFT 8
#define  JPEG_CORE_STATUS7_HUFF_ENC_OUT_DT_MASK_SHIFT(reg) (((reg) & JPEG_CORE_STATUS7_HUFF_ENC_OUT_DT_MASK) >> JPEG_CORE_STATUS7_HUFF_ENC_OUT_DT_SHIFT)
#define  JPEG_CORE_STATUS7_HUFF_ENC_OUT_DT_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_STATUS7_HUFF_ENC_OUT_DT_MASK) | (((uint32_t)val) << JPEG_CORE_STATUS7_HUFF_ENC_OUT_DT_SHIFT))

#define  JPEG_CORE_STATUS7_HUFF_ENC_OUT_DATA_MASK 0xff
#define  JPEG_CORE_STATUS7_HUFF_ENC_OUT_DATA_SHIFT 0
#define  JPEG_CORE_STATUS7_HUFF_ENC_OUT_DATA_MASK_SHIFT(reg) (((reg) & JPEG_CORE_STATUS7_HUFF_ENC_OUT_DATA_MASK) >> JPEG_CORE_STATUS7_HUFF_ENC_OUT_DATA_SHIFT)
#define  JPEG_CORE_STATUS7_HUFF_ENC_OUT_DATA_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_STATUS7_HUFF_ENC_OUT_DATA_MASK) | (((uint32_t)val) << JPEG_CORE_STATUS7_HUFF_ENC_OUT_DATA_SHIFT))

//====================================================================
//Register: Status 8 Register (STATUS8)
/** \brief Provides block status bits.*/
//====================================================================

#define  JPEG_CORE_STATUS8_RESERVED1_MASK 0xffffff80
#define  JPEG_CORE_STATUS8_RESERVED1_SHIFT 7
#define  JPEG_CORE_STATUS8_RESERVED1_MASK_SHIFT(reg) (((reg) & JPEG_CORE_STATUS8_RESERVED1_MASK) >> JPEG_CORE_STATUS8_RESERVED1_SHIFT)
#define  JPEG_CORE_STATUS8_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_STATUS8_RESERVED1_MASK) | (((uint32_t)val) << JPEG_CORE_STATUS8_RESERVED1_SHIFT))

#define  JPEG_CORE_STATUS8_ENC_HDR_ACTIVE_MASK 0x40
#define  JPEG_CORE_STATUS8_ENC_HDR_ACTIVE_SHIFT 6
#define  JPEG_CORE_STATUS8_ENC_HDR_ACTIVE_MASK_SHIFT(reg) (((reg) & JPEG_CORE_STATUS8_ENC_HDR_ACTIVE_MASK) >> JPEG_CORE_STATUS8_ENC_HDR_ACTIVE_SHIFT)
#define  JPEG_CORE_STATUS8_ENC_HDR_ACTIVE_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_STATUS8_ENC_HDR_ACTIVE_MASK) | (((uint32_t)val) << JPEG_CORE_STATUS8_ENC_HDR_ACTIVE_SHIFT))

#define  JPEG_CORE_STATUS8_ENC_HDR_STATE_MASK 0x3f
#define  JPEG_CORE_STATUS8_ENC_HDR_STATE_SHIFT 0
#define  JPEG_CORE_STATUS8_ENC_HDR_STATE_MASK_SHIFT(reg) (((reg) & JPEG_CORE_STATUS8_ENC_HDR_STATE_MASK) >> JPEG_CORE_STATUS8_ENC_HDR_STATE_SHIFT)
#define  JPEG_CORE_STATUS8_ENC_HDR_STATE_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_STATUS8_ENC_HDR_STATE_MASK) | (((uint32_t)val) << JPEG_CORE_STATUS8_ENC_HDR_STATE_SHIFT))

//====================================================================
//Register: Status 9 Register (STATUS9)
/** \brief Provides block status bits.*/
//====================================================================

#define  JPEG_CORE_STATUS9_DEC_HDR_BYTE_CNT_MASK 0xffff0000
#define  JPEG_CORE_STATUS9_DEC_HDR_BYTE_CNT_SHIFT 16
#define  JPEG_CORE_STATUS9_DEC_HDR_BYTE_CNT_MASK_SHIFT(reg) (((reg) & JPEG_CORE_STATUS9_DEC_HDR_BYTE_CNT_MASK) >> JPEG_CORE_STATUS9_DEC_HDR_BYTE_CNT_SHIFT)
#define  JPEG_CORE_STATUS9_DEC_HDR_BYTE_CNT_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_STATUS9_DEC_HDR_BYTE_CNT_MASK) | (((uint32_t)val) << JPEG_CORE_STATUS9_DEC_HDR_BYTE_CNT_SHIFT))

#define  JPEG_CORE_STATUS9_DEC_HDR_PREV_MARKER_MASK 0xff00
#define  JPEG_CORE_STATUS9_DEC_HDR_PREV_MARKER_SHIFT 8
#define  JPEG_CORE_STATUS9_DEC_HDR_PREV_MARKER_MASK_SHIFT(reg) (((reg) & JPEG_CORE_STATUS9_DEC_HDR_PREV_MARKER_MASK) >> JPEG_CORE_STATUS9_DEC_HDR_PREV_MARKER_SHIFT)
#define  JPEG_CORE_STATUS9_DEC_HDR_PREV_MARKER_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_STATUS9_DEC_HDR_PREV_MARKER_MASK) | (((uint32_t)val) << JPEG_CORE_STATUS9_DEC_HDR_PREV_MARKER_SHIFT))

#define  JPEG_CORE_STATUS9_RESERVED1_MASK 0xc0
#define  JPEG_CORE_STATUS9_RESERVED1_SHIFT 6
#define  JPEG_CORE_STATUS9_RESERVED1_MASK_SHIFT(reg) (((reg) & JPEG_CORE_STATUS9_RESERVED1_MASK) >> JPEG_CORE_STATUS9_RESERVED1_SHIFT)
#define  JPEG_CORE_STATUS9_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_STATUS9_RESERVED1_MASK) | (((uint32_t)val) << JPEG_CORE_STATUS9_RESERVED1_SHIFT))

#define  JPEG_CORE_STATUS9_DEC_HDR_STATE_MASK 0x3f
#define  JPEG_CORE_STATUS9_DEC_HDR_STATE_SHIFT 0
#define  JPEG_CORE_STATUS9_DEC_HDR_STATE_MASK_SHIFT(reg) (((reg) & JPEG_CORE_STATUS9_DEC_HDR_STATE_MASK) >> JPEG_CORE_STATUS9_DEC_HDR_STATE_SHIFT)
#define  JPEG_CORE_STATUS9_DEC_HDR_STATE_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_STATUS9_DEC_HDR_STATE_MASK) | (((uint32_t)val) << JPEG_CORE_STATUS9_DEC_HDR_STATE_SHIFT))

//====================================================================
//Register: HUFF FCODE RAM Access Register (HUFF_FCODE)
/** \brief These tables must be programmed with the first binary comparison value for each
      code length.
      Note that this is not implemented in an SRAM, but is actually implemented in flip-flops. <br/> For the first entry of a table, only bit [0] is valid. For the second entry, only
      bits [1:0] are valid and so on.<br/> This is divided into 4 tables. <br/> Addr 0-15 = Table Class = 0 / Table Destination = 0 (DC Table 0) <br/> Addr 16-31 = Table Class = 1 / Table Destination = 0 (AC Table 0) <br/> Addr 32-47 = Table Class = 0 / Table Destination = 1 (DC Table 1)<br/> Addr 48-63 = Table Class = 1 / Table Destination = 1 (AC Table 1)*/
//====================================================================

#define  JPEG_CORE_HUFF_FCODE_RESERVED1_MASK 0xffff0000
#define  JPEG_CORE_HUFF_FCODE_RESERVED1_SHIFT 16
#define  JPEG_CORE_HUFF_FCODE_RESERVED1_MASK_SHIFT(reg) (((reg) & JPEG_CORE_HUFF_FCODE_RESERVED1_MASK) >> JPEG_CORE_HUFF_FCODE_RESERVED1_SHIFT)
#define  JPEG_CORE_HUFF_FCODE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_HUFF_FCODE_RESERVED1_MASK) | (((uint32_t)val) << JPEG_CORE_HUFF_FCODE_RESERVED1_SHIFT))

#define  JPEG_CORE_HUFF_FCODE_VAL_MASK 0xffff
#define  JPEG_CORE_HUFF_FCODE_VAL_SHIFT 0
#define  JPEG_CORE_HUFF_FCODE_VAL_MASK_SHIFT(reg) (((reg) & JPEG_CORE_HUFF_FCODE_VAL_MASK) >> JPEG_CORE_HUFF_FCODE_VAL_SHIFT)
#define  JPEG_CORE_HUFF_FCODE_VAL_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_HUFF_FCODE_VAL_MASK) | (((uint32_t)val) << JPEG_CORE_HUFF_FCODE_VAL_SHIFT))

//====================================================================
//Register: HUFF LCODE RAM Access Register (HUFF_LCODE)
/** \brief These tables must be programmed with the last binary comparison value for each
      code length.
      Note that this is not implemented in an SRAM, but is actually implemented in flip-flops. <br/> For the first entry of a table, only bit [0] is valid. For the second entry, only
      bits [1:0] are valid and so on.<br/> This is divided into 4 tables. <br/> Addr 0-15 = Table Class = 0 / Table Destination = 0 (DC Table 0) <br/> Addr 16-31 = Table Class = 1 / Table Destination = 0 (AC Table 0) <br/> Addr 32-47 = Table Class = 0 / Table Destination = 1 (DC Table 1)<br/> Addr 48-63 = Table Class = 1 / Table Destination = 1 (AC Table 1)*/
//====================================================================

#define  JPEG_CORE_HUFF_LCODE_RESERVED1_MASK 0xffff0000
#define  JPEG_CORE_HUFF_LCODE_RESERVED1_SHIFT 16
#define  JPEG_CORE_HUFF_LCODE_RESERVED1_MASK_SHIFT(reg) (((reg) & JPEG_CORE_HUFF_LCODE_RESERVED1_MASK) >> JPEG_CORE_HUFF_LCODE_RESERVED1_SHIFT)
#define  JPEG_CORE_HUFF_LCODE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_HUFF_LCODE_RESERVED1_MASK) | (((uint32_t)val) << JPEG_CORE_HUFF_LCODE_RESERVED1_SHIFT))

#define  JPEG_CORE_HUFF_LCODE_VAL_MASK 0xffff
#define  JPEG_CORE_HUFF_LCODE_VAL_SHIFT 0
#define  JPEG_CORE_HUFF_LCODE_VAL_MASK_SHIFT(reg) (((reg) & JPEG_CORE_HUFF_LCODE_VAL_MASK) >> JPEG_CORE_HUFF_LCODE_VAL_SHIFT)
#define  JPEG_CORE_HUFF_LCODE_VAL_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_HUFF_LCODE_VAL_MASK) | (((uint32_t)val) << JPEG_CORE_HUFF_LCODE_VAL_SHIFT))

//====================================================================
//Register: HUFF PTR RAM Access Register (HUFF_PTR)
/** \brief This is divided into 4 tables. <br/> Addr 0-15 = Table Class = 0 / Table Destination = 0 (DC Table 0) <br/> Addr 16-31 = Table Class = 1 / Table Destination = 0 (AC Table 0) <br/> Addr 32-47 = Table Class = 0 / Table Destination = 1 (DC Table 1) <br/> Addr 48-63 = Table Class = 1 / Table Destination = 1 (AC Table 1)*/
//====================================================================

#define  JPEG_CORE_HUFF_PTR_RESERVED1_MASK 0xfffffe00
#define  JPEG_CORE_HUFF_PTR_RESERVED1_SHIFT 9
#define  JPEG_CORE_HUFF_PTR_RESERVED1_MASK_SHIFT(reg) (((reg) & JPEG_CORE_HUFF_PTR_RESERVED1_MASK) >> JPEG_CORE_HUFF_PTR_RESERVED1_SHIFT)
#define  JPEG_CORE_HUFF_PTR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_HUFF_PTR_RESERVED1_MASK) | (((uint32_t)val) << JPEG_CORE_HUFF_PTR_RESERVED1_SHIFT))

#define  JPEG_CORE_HUFF_PTR_VAL_MASK 0x1ff
#define  JPEG_CORE_HUFF_PTR_VAL_SHIFT 0
#define  JPEG_CORE_HUFF_PTR_VAL_MASK_SHIFT(reg) (((reg) & JPEG_CORE_HUFF_PTR_VAL_MASK) >> JPEG_CORE_HUFF_PTR_VAL_SHIFT)
#define  JPEG_CORE_HUFF_PTR_VAL_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_HUFF_PTR_VAL_MASK) | (((uint32_t)val) << JPEG_CORE_HUFF_PTR_VAL_SHIFT))

//====================================================================
//Register: HUFF_SYM RAM Access Register (HUFF_SYM)
/** \brief This contains four code tables - two 12-entry DC tables and two 162-entry AC tables. <br/> Addr 0-11 = Table Class = 0 / Table Destination = 0 (DC Table 0) <br/> Addr 12-173 = Table Class = 1 / Table Destination = 0 (AC Table 0) <br/> Addr 174-185 = Table Class = 0 / Table Destination = 1 (DC Table 1) <br/> Addr 186-347 = Table Class = 1 / Table Destination = 1 (AC Table 1)*/
//====================================================================

#define  JPEG_CORE_HUFF_SYM_RESERVED1_MASK 0xffffff00
#define  JPEG_CORE_HUFF_SYM_RESERVED1_SHIFT 8
#define  JPEG_CORE_HUFF_SYM_RESERVED1_MASK_SHIFT(reg) (((reg) & JPEG_CORE_HUFF_SYM_RESERVED1_MASK) >> JPEG_CORE_HUFF_SYM_RESERVED1_SHIFT)
#define  JPEG_CORE_HUFF_SYM_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_HUFF_SYM_RESERVED1_MASK) | (((uint32_t)val) << JPEG_CORE_HUFF_SYM_RESERVED1_SHIFT))

#define  JPEG_CORE_HUFF_SYM_VAL_MASK 0xff
#define  JPEG_CORE_HUFF_SYM_VAL_SHIFT 0
#define  JPEG_CORE_HUFF_SYM_VAL_MASK_SHIFT(reg) (((reg) & JPEG_CORE_HUFF_SYM_VAL_MASK) >> JPEG_CORE_HUFF_SYM_VAL_SHIFT)
#define  JPEG_CORE_HUFF_SYM_VAL_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_HUFF_SYM_VAL_MASK) | (((uint32_t)val) << JPEG_CORE_HUFF_SYM_VAL_SHIFT))

//====================================================================
//Register: Quantization Table Data (Q_TABLE)
/** \brief Quantization Table Access*/
//====================================================================

#define  JPEG_CORE_Q_TABLE_RESERVED1_MASK 0xffffff00
#define  JPEG_CORE_Q_TABLE_RESERVED1_SHIFT 8
#define  JPEG_CORE_Q_TABLE_RESERVED1_MASK_SHIFT(reg) (((reg) & JPEG_CORE_Q_TABLE_RESERVED1_MASK) >> JPEG_CORE_Q_TABLE_RESERVED1_SHIFT)
#define  JPEG_CORE_Q_TABLE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_Q_TABLE_RESERVED1_MASK) | (((uint32_t)val) << JPEG_CORE_Q_TABLE_RESERVED1_SHIFT))

#define  JPEG_CORE_Q_TABLE_DATA_MASK 0xff
#define  JPEG_CORE_Q_TABLE_DATA_SHIFT 0
#define  JPEG_CORE_Q_TABLE_DATA_MASK_SHIFT(reg) (((reg) & JPEG_CORE_Q_TABLE_DATA_MASK) >> JPEG_CORE_Q_TABLE_DATA_SHIFT)
#define  JPEG_CORE_Q_TABLE_DATA_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_Q_TABLE_DATA_MASK) | (((uint32_t)val) << JPEG_CORE_Q_TABLE_DATA_SHIFT))

//====================================================================
//Register: Huffman Encoder Length/Code Table (LEN_CODE)
/** \brief Look-up table used by hardware for Huffman encode. Addr 0-11 = Table Class = 0 / Table Destination = 0 (DC Table 0) <br/> Addr 12-173 = Table Class = 1 / Table Destination = 0 (AC Table 0) <br/> Addr 174-185 = Table Class = 0 / Table Destination = 1 (DC Table 1) <br/> Addr 186-347 = Table Class = 1 / Table Destination = 1 (AC Table 1) <br/> The DC tables have 12 entries and are ordered {EOB, 01, 02, ..., 0B}. <br/> The AC tables have 162 entries and are ordered {EOB, ZRL, 01-0A, 11-1A, ..., F1-FA}.*/
//====================================================================

#define  JPEG_CORE_LEN_CODE_RESERVED1_MASK 0xfff00000
#define  JPEG_CORE_LEN_CODE_RESERVED1_SHIFT 20
#define  JPEG_CORE_LEN_CODE_RESERVED1_MASK_SHIFT(reg) (((reg) & JPEG_CORE_LEN_CODE_RESERVED1_MASK) >> JPEG_CORE_LEN_CODE_RESERVED1_SHIFT)
#define  JPEG_CORE_LEN_CODE_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_LEN_CODE_RESERVED1_MASK) | (((uint32_t)val) << JPEG_CORE_LEN_CODE_RESERVED1_SHIFT))

#define  JPEG_CORE_LEN_CODE_VAL_MASK 0xfffff
#define  JPEG_CORE_LEN_CODE_VAL_SHIFT 0
#define  JPEG_CORE_LEN_CODE_VAL_MASK_SHIFT(reg) (((reg) & JPEG_CORE_LEN_CODE_VAL_MASK) >> JPEG_CORE_LEN_CODE_VAL_SHIFT)
#define  JPEG_CORE_LEN_CODE_VAL_REPLACE_VAL(reg,val) (((reg) & ~JPEG_CORE_LEN_CODE_VAL_MASK) | (((uint32_t)val) << JPEG_CORE_LEN_CODE_VAL_SHIFT))

#endif // JPEG_CORE
