 /*
 **************************************************************************************
 *
 * (c) Copyright 2013 Marvell International Ltd.
 *
 *
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/.
 *
 **************************************************************************************
 *
 * \file JBIG_regstructs.h
 * Generated using RegBuild 1.6.3
 *
 **************************************************************************************
 */

#ifndef _JBIG_CLSTR_REGSTRUCTS_H_
#define _JBIG_CLSTR_REGSTRUCTS_H_

#ifndef __KERNEL__
#include <stdint.h>
#endif

//====================================================================
//
//Register File: JBIG Cluster Registers (JBIG_CLSTR)
/** \brief Register Description for all JBIG resources in the ASIC*/
//
//====================================================================

//====================================================================
//
//Register File: JBIG Codec 0 Registers (JBIG_CODEC_0)
/** \brief Register Description for CODEC core*/
//
//====================================================================

//====================================================================
//
//Register File: JBIG Decoder 0 Registers (JBIG_DECODE_0)
/** \brief Register Description for Decoder CORE*/
//
//====================================================================

//====================================================================
//
//Register File: JBIG Codec 1 Registers (JBIG_CODEC_1)
/** \brief Register Description for CODEC core*/
//
//====================================================================

//====================================================================
//
//Register File: JBIG Decoder 1 Registers (JBIG_DECODE_1)
/** \brief Register Description for Decoder CORE*/
//
//====================================================================

//====================================================================
//
//Register File: JBIG Codec 2 Registers (JBIG_CODEC_2)
/** \brief Register Description for CODEC core*/
//
//====================================================================

//====================================================================
//
//Register File: JBIG Decoder 2 Registers (JBIG_DECODE_2)
/** \brief Register Description for Decoder CORE*/
//
//====================================================================

//====================================================================
//
//Register File: JBIG Codec 3 Registers (JBIG_CODEC_3)
/** \brief Register Description for CODEC core*/
//
//====================================================================

//====================================================================
//
//Register File: JBIG Decoder 3 Registers (JBIG_DECODE_3)
/** \brief Register Description for Decoder CORE*/
//
//====================================================================

//====================================================================
//
//Register File: JBIG Codec 4 Registers (JBIG_CODEC_4)
/** \brief Register Description for CODEC core*/
//
//====================================================================

//====================================================================
//
//Register File: JBIG Codec Registers (JBIG_CODEC_0_CORE)
/** \brief Register Description for CODEC CORE*/
//
//====================================================================

typedef struct JBIG_CODEC_0_CORE_REGS_s
{
  volatile uint32_t JCTL;  ///< 0x0 [R/W]: Codec JBIG Control Register
  volatile uint32_t JSTAT;  ///< 0x4 [R/W]: Codec JBIG Status Register
  volatile uint32_t JX;  ///< 0x8 [R/W]: Codec JBIG X-Dimension (Pixels/line) Register
  volatile uint32_t JY;  ///< 0xc [R/W]: Codec JBIG Y-Dimension (Lines/page) Register
  volatile uint32_t JBIG_EN;  ///< 0x10 [R/W]: Codec JBIG Enable Register
  volatile uint32_t reserved0[4];
  volatile uint32_t JSL;  ///< 0x24 [R/W]: Codec JBIG Stripe Length Register
} JBIG_CODEC_0_CORE_REGS_t;

//====================================================================
//
//Register File: IDMA Registers (JBIG_CODEC_0_IDMA)
/** \brief Registers for the IDMA_AXI module <br/> (rev 0 . 1 . 0 . 5)*/
//
//====================================================================

typedef struct JBIG_CODEC_0_IDMA_REGS_s
{
  volatile uint32_t cfg;  ///< 0x0 [R/W]: Configuration register
  volatile uint32_t status;  ///< 0x4 [R]: Status register
  volatile uint32_t line_width;  ///< 0x8 [R/W]: Line Width register
  volatile uint32_t int_en;  ///< 0xc [R/W]: Interrupt Enable Register
  volatile uint32_t int_st;  ///< 0x10 [R]: Interrupt Pending Register
  volatile uint32_t int_cl;  ///< 0x14 [W]: Interrupt Clear Register
  volatile uint32_t int_fo;  ///< 0x18 [W]: Interrupt Force Register
  volatile uint32_t desc_write;  ///< 0x1c [W]: Descriptor Write Register
  volatile uint32_t desc_read;  ///< 0x20 [R]: Descriptor Read Register
  volatile uint32_t xfer_length;  ///< 0x24 [R]: Descriptor Transfer Length Register
  volatile uint32_t xfer_addr;  ///< 0x28 [R]: Descriptor Transfer Address Register
  volatile uint32_t ctrl_word;  ///< 0x2c [R]: Descriptor Control Word Register
  volatile uint32_t reset;  ///< 0x30 [W]: Soft Reset register
  volatile uint32_t REV0;  ///< 0x34 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0x38 [R]: IP Tagging Revision 1
} JBIG_CODEC_0_IDMA_REGS_t;

//====================================================================
//
//Register File: ODMA Registers (JBIG_CODEC_0_ODMA)
/** \brief Register Descriptions for the ODMA_AXI block (rev 0 . 4 . 0 . 7)*/
//
//====================================================================

typedef struct JBIG_CODEC_0_ODMA_REGS_s
{
  volatile uint32_t cfg;  ///< 0x0 [R/W]: Configuration register
  volatile uint32_t status;  ///< 0x4 [R]: Status register
  volatile uint32_t line_size;  ///< 0x8 [R/W]: Line Size Register
  volatile uint32_t int_en;  ///< 0xc [R/W]: Interrupt Enable Register
  volatile uint32_t int_pend;  ///< 0x10 [R]: Interrupt Pending Register
  volatile uint32_t int_ack;  ///< 0x14 [W]: Interrupt Acknowledge Register
  volatile uint32_t int_fo;  ///< 0x18 [W]: Interrupt Force Register
  volatile uint32_t desc_write;  ///< 0x1c [W]: Descriptor Write Register
  volatile uint32_t desc_read;  ///< 0x20 [R]: Descriptor Read Register
  volatile uint32_t xfer_length;  ///< 0x24 [R]: Descriptor Transfer Length Register
  volatile uint32_t xfer_addr;  ///< 0x28 [R]: Descriptor Transfer Address Register
  volatile uint32_t xfer_burst;  ///< 0x2c [R]: Descriptor Transfer Burst Register
  volatile uint32_t reserved0;
  volatile uint32_t reset;  ///< 0x34 [W]: Soft Reset register
  volatile uint32_t REV0;  ///< 0x38 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0x3c [R]: IP Tagging Revision 1
} JBIG_CODEC_0_ODMA_REGS_t;

//====================================================================
//
//Register File: JBIG Decode Registers (JBIG_DECODE_0_CORE)
/** \brief Register Description for CODEC CORE*/
//
//====================================================================

typedef struct JBIG_DECODE_0_CORE_REGS_s
{
  volatile uint32_t JCTL;  ///< 0x0 [R/W]: Codec JBIG Control Register
  volatile uint32_t JSTAT;  ///< 0x4 [R/W]: Codec JBIG Status Register
  volatile uint32_t JX;  ///< 0x8 [R/W]: Codec JBIG X-Dimension (Pixels/line) Register
  volatile uint32_t JY;  ///< 0xc [R/W]: Codec JBIG Y-Dimension (Lines/page) Register
  volatile uint32_t JBIG_EN;  ///< 0x10 [R/W]: Codec JBIG Enable Register
  volatile uint32_t reserved0[4];
  volatile uint32_t JSL;  ///< 0x24 [R/W]: Codec JBIG Stripe Length Register
} JBIG_DECODE_0_CORE_REGS_t;

//====================================================================
//
//Register File: IDMA Registers (JBIG_DECODE_0_IDMA)
/** \brief Registers for the IDMA_AXI module <br/> (rev 0 . 1 . 0 . 5)*/
//
//====================================================================

typedef struct JBIG_DECODE_0_IDMA_REGS_s
{
  volatile uint32_t cfg;  ///< 0x0 [R/W]: Configuration register
  volatile uint32_t status;  ///< 0x4 [R]: Status register
  volatile uint32_t line_width;  ///< 0x8 [R/W]: Line Width register
  volatile uint32_t int_en;  ///< 0xc [R/W]: Interrupt Enable Register
  volatile uint32_t int_st;  ///< 0x10 [R]: Interrupt Pending Register
  volatile uint32_t int_cl;  ///< 0x14 [W]: Interrupt Clear Register
  volatile uint32_t int_fo;  ///< 0x18 [W]: Interrupt Force Register
  volatile uint32_t desc_write;  ///< 0x1c [W]: Descriptor Write Register
  volatile uint32_t desc_read;  ///< 0x20 [R]: Descriptor Read Register
  volatile uint32_t xfer_length;  ///< 0x24 [R]: Descriptor Transfer Length Register
  volatile uint32_t xfer_addr;  ///< 0x28 [R]: Descriptor Transfer Address Register
  volatile uint32_t ctrl_word;  ///< 0x2c [R]: Descriptor Control Word Register
  volatile uint32_t reset;  ///< 0x30 [W]: Soft Reset register
  volatile uint32_t REV0;  ///< 0x34 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0x38 [R]: IP Tagging Revision 1
} JBIG_DECODE_0_IDMA_REGS_t;

//====================================================================
//
//Register File: ODMA Registers (JBIG_DECODE_0_ODMA)
/** \brief Register Descriptions for the ODMA_AXI block (rev 0 . 4 . 0 . 7)*/
//
//====================================================================

typedef struct JBIG_DECODE_0_ODMA_REGS_s
{
  volatile uint32_t cfg;  ///< 0x0 [R/W]: Configuration register
  volatile uint32_t status;  ///< 0x4 [R]: Status register
  volatile uint32_t line_size;  ///< 0x8 [R/W]: Line Size Register
  volatile uint32_t int_en;  ///< 0xc [R/W]: Interrupt Enable Register
  volatile uint32_t int_pend;  ///< 0x10 [R]: Interrupt Pending Register
  volatile uint32_t int_ack;  ///< 0x14 [W]: Interrupt Acknowledge Register
  volatile uint32_t int_fo;  ///< 0x18 [W]: Interrupt Force Register
  volatile uint32_t desc_write;  ///< 0x1c [W]: Descriptor Write Register
  volatile uint32_t desc_read;  ///< 0x20 [R]: Descriptor Read Register
  volatile uint32_t xfer_length;  ///< 0x24 [R]: Descriptor Transfer Length Register
  volatile uint32_t xfer_addr;  ///< 0x28 [R]: Descriptor Transfer Address Register
  volatile uint32_t xfer_burst;  ///< 0x2c [R]: Descriptor Transfer Burst Register
  volatile uint32_t reserved0;
  volatile uint32_t reset;  ///< 0x34 [W]: Soft Reset register
  volatile uint32_t REV0;  ///< 0x38 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0x3c [R]: IP Tagging Revision 1
} JBIG_DECODE_0_ODMA_REGS_t;

//====================================================================
//
//Register File: JBIG Codec Registers (JBIG_CODEC_1_CORE)
/** \brief Register Description for CODEC CORE*/
//
//====================================================================

typedef struct JBIG_CODEC_1_CORE_REGS_s
{
  volatile uint32_t JCTL;  ///< 0x0 [R/W]: Codec JBIG Control Register
  volatile uint32_t JSTAT;  ///< 0x4 [R/W]: Codec JBIG Status Register
  volatile uint32_t JX;  ///< 0x8 [R/W]: Codec JBIG X-Dimension (Pixels/line) Register
  volatile uint32_t JY;  ///< 0xc [R/W]: Codec JBIG Y-Dimension (Lines/page) Register
  volatile uint32_t JBIG_EN;  ///< 0x10 [R/W]: Codec JBIG Enable Register
  volatile uint32_t reserved0[4];
  volatile uint32_t JSL;  ///< 0x24 [R/W]: Codec JBIG Stripe Length Register
} JBIG_CODEC_1_CORE_REGS_t;

//====================================================================
//
//Register File: IDMA Registers (JBIG_CODEC_1_IDMA)
/** \brief Registers for the IDMA_AXI module <br/> (rev 0 . 1 . 0 . 5)*/
//
//====================================================================

typedef struct JBIG_CODEC_1_IDMA_REGS_s
{
  volatile uint32_t cfg;  ///< 0x0 [R/W]: Configuration register
  volatile uint32_t status;  ///< 0x4 [R]: Status register
  volatile uint32_t line_width;  ///< 0x8 [R/W]: Line Width register
  volatile uint32_t int_en;  ///< 0xc [R/W]: Interrupt Enable Register
  volatile uint32_t int_st;  ///< 0x10 [R]: Interrupt Pending Register
  volatile uint32_t int_cl;  ///< 0x14 [W]: Interrupt Clear Register
  volatile uint32_t int_fo;  ///< 0x18 [W]: Interrupt Force Register
  volatile uint32_t desc_write;  ///< 0x1c [W]: Descriptor Write Register
  volatile uint32_t desc_read;  ///< 0x20 [R]: Descriptor Read Register
  volatile uint32_t xfer_length;  ///< 0x24 [R]: Descriptor Transfer Length Register
  volatile uint32_t xfer_addr;  ///< 0x28 [R]: Descriptor Transfer Address Register
  volatile uint32_t ctrl_word;  ///< 0x2c [R]: Descriptor Control Word Register
  volatile uint32_t reset;  ///< 0x30 [W]: Soft Reset register
  volatile uint32_t REV0;  ///< 0x34 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0x38 [R]: IP Tagging Revision 1
} JBIG_CODEC_1_IDMA_REGS_t;

//====================================================================
//
//Register File: ODMA Registers (JBIG_CODEC_1_ODMA)
/** \brief Register Descriptions for the ODMA_AXI block (rev 0 . 4 . 0 . 7)*/
//
//====================================================================

typedef struct JBIG_CODEC_1_ODMA_REGS_s
{
  volatile uint32_t cfg;  ///< 0x0 [R/W]: Configuration register
  volatile uint32_t status;  ///< 0x4 [R]: Status register
  volatile uint32_t line_size;  ///< 0x8 [R/W]: Line Size Register
  volatile uint32_t int_en;  ///< 0xc [R/W]: Interrupt Enable Register
  volatile uint32_t int_pend;  ///< 0x10 [R]: Interrupt Pending Register
  volatile uint32_t int_ack;  ///< 0x14 [W]: Interrupt Acknowledge Register
  volatile uint32_t int_fo;  ///< 0x18 [W]: Interrupt Force Register
  volatile uint32_t desc_write;  ///< 0x1c [W]: Descriptor Write Register
  volatile uint32_t desc_read;  ///< 0x20 [R]: Descriptor Read Register
  volatile uint32_t xfer_length;  ///< 0x24 [R]: Descriptor Transfer Length Register
  volatile uint32_t xfer_addr;  ///< 0x28 [R]: Descriptor Transfer Address Register
  volatile uint32_t xfer_burst;  ///< 0x2c [R]: Descriptor Transfer Burst Register
  volatile uint32_t reserved0;
  volatile uint32_t reset;  ///< 0x34 [W]: Soft Reset register
  volatile uint32_t REV0;  ///< 0x38 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0x3c [R]: IP Tagging Revision 1
} JBIG_CODEC_1_ODMA_REGS_t;

//====================================================================
//
//Register File: JBIG Decode Registers (JBIG_DECODE_1_CORE)
/** \brief Register Description for CODEC CORE*/
//
//====================================================================

typedef struct JBIG_DECODE_1_CORE_REGS_s
{
  volatile uint32_t JCTL;  ///< 0x0 [R/W]: Codec JBIG Control Register
  volatile uint32_t JSTAT;  ///< 0x4 [R/W]: Codec JBIG Status Register
  volatile uint32_t JX;  ///< 0x8 [R/W]: Codec JBIG X-Dimension (Pixels/line) Register
  volatile uint32_t JY;  ///< 0xc [R/W]: Codec JBIG Y-Dimension (Lines/page) Register
  volatile uint32_t JBIG_EN;  ///< 0x10 [R/W]: Codec JBIG Enable Register
  volatile uint32_t reserved0[4];
  volatile uint32_t JSL;  ///< 0x24 [R/W]: Codec JBIG Stripe Length Register
} JBIG_DECODE_1_CORE_REGS_t;

//====================================================================
//
//Register File: IDMA Registers (JBIG_DECODE_1_IDMA)
/** \brief Registers for the IDMA_AXI module <br/> (rev 0 . 1 . 0 . 5)*/
//
//====================================================================

typedef struct JBIG_DECODE_1_IDMA_REGS_s
{
  volatile uint32_t cfg;  ///< 0x0 [R/W]: Configuration register
  volatile uint32_t status;  ///< 0x4 [R]: Status register
  volatile uint32_t line_width;  ///< 0x8 [R/W]: Line Width register
  volatile uint32_t int_en;  ///< 0xc [R/W]: Interrupt Enable Register
  volatile uint32_t int_st;  ///< 0x10 [R]: Interrupt Pending Register
  volatile uint32_t int_cl;  ///< 0x14 [W]: Interrupt Clear Register
  volatile uint32_t int_fo;  ///< 0x18 [W]: Interrupt Force Register
  volatile uint32_t desc_write;  ///< 0x1c [W]: Descriptor Write Register
  volatile uint32_t desc_read;  ///< 0x20 [R]: Descriptor Read Register
  volatile uint32_t xfer_length;  ///< 0x24 [R]: Descriptor Transfer Length Register
  volatile uint32_t xfer_addr;  ///< 0x28 [R]: Descriptor Transfer Address Register
  volatile uint32_t ctrl_word;  ///< 0x2c [R]: Descriptor Control Word Register
  volatile uint32_t reset;  ///< 0x30 [W]: Soft Reset register
  volatile uint32_t REV0;  ///< 0x34 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0x38 [R]: IP Tagging Revision 1
} JBIG_DECODE_1_IDMA_REGS_t;

//====================================================================
//
//Register File: ODMA Registers (JBIG_DECODE_1_ODMA)
/** \brief Register Descriptions for the ODMA_AXI block (rev 0 . 4 . 0 . 7)*/
//
//====================================================================

typedef struct JBIG_DECODE_1_ODMA_REGS_s
{
  volatile uint32_t cfg;  ///< 0x0 [R/W]: Configuration register
  volatile uint32_t status;  ///< 0x4 [R]: Status register
  volatile uint32_t line_size;  ///< 0x8 [R/W]: Line Size Register
  volatile uint32_t int_en;  ///< 0xc [R/W]: Interrupt Enable Register
  volatile uint32_t int_pend;  ///< 0x10 [R]: Interrupt Pending Register
  volatile uint32_t int_ack;  ///< 0x14 [W]: Interrupt Acknowledge Register
  volatile uint32_t int_fo;  ///< 0x18 [W]: Interrupt Force Register
  volatile uint32_t desc_write;  ///< 0x1c [W]: Descriptor Write Register
  volatile uint32_t desc_read;  ///< 0x20 [R]: Descriptor Read Register
  volatile uint32_t xfer_length;  ///< 0x24 [R]: Descriptor Transfer Length Register
  volatile uint32_t xfer_addr;  ///< 0x28 [R]: Descriptor Transfer Address Register
  volatile uint32_t xfer_burst;  ///< 0x2c [R]: Descriptor Transfer Burst Register
  volatile uint32_t reserved0;
  volatile uint32_t reset;  ///< 0x34 [W]: Soft Reset register
  volatile uint32_t REV0;  ///< 0x38 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0x3c [R]: IP Tagging Revision 1
} JBIG_DECODE_1_ODMA_REGS_t;

//====================================================================
//
//Register File: JBIG Codec Registers (JBIG_CODEC_2_CORE)
/** \brief Register Description for CODEC CORE*/
//
//====================================================================

typedef struct JBIG_CODEC_2_CORE_REGS_s
{
  volatile uint32_t JCTL;  ///< 0x0 [R/W]: Codec JBIG Control Register
  volatile uint32_t JSTAT;  ///< 0x4 [R/W]: Codec JBIG Status Register
  volatile uint32_t JX;  ///< 0x8 [R/W]: Codec JBIG X-Dimension (Pixels/line) Register
  volatile uint32_t JY;  ///< 0xc [R/W]: Codec JBIG Y-Dimension (Lines/page) Register
  volatile uint32_t JBIG_EN;  ///< 0x10 [R/W]: Codec JBIG Enable Register
  volatile uint32_t reserved0[4];
  volatile uint32_t JSL;  ///< 0x24 [R/W]: Codec JBIG Stripe Length Register
} JBIG_CODEC_2_CORE_REGS_t;

//====================================================================
//
//Register File: IDMA Registers (JBIG_CODEC_2_IDMA)
/** \brief Registers for the IDMA_AXI module <br/> (rev 0 . 1 . 0 . 5)*/
//
//====================================================================

typedef struct JBIG_CODEC_2_IDMA_REGS_s
{
  volatile uint32_t cfg;  ///< 0x0 [R/W]: Configuration register
  volatile uint32_t status;  ///< 0x4 [R]: Status register
  volatile uint32_t line_width;  ///< 0x8 [R/W]: Line Width register
  volatile uint32_t int_en;  ///< 0xc [R/W]: Interrupt Enable Register
  volatile uint32_t int_st;  ///< 0x10 [R]: Interrupt Pending Register
  volatile uint32_t int_cl;  ///< 0x14 [W]: Interrupt Clear Register
  volatile uint32_t int_fo;  ///< 0x18 [W]: Interrupt Force Register
  volatile uint32_t desc_write;  ///< 0x1c [W]: Descriptor Write Register
  volatile uint32_t desc_read;  ///< 0x20 [R]: Descriptor Read Register
  volatile uint32_t xfer_length;  ///< 0x24 [R]: Descriptor Transfer Length Register
  volatile uint32_t xfer_addr;  ///< 0x28 [R]: Descriptor Transfer Address Register
  volatile uint32_t ctrl_word;  ///< 0x2c [R]: Descriptor Control Word Register
  volatile uint32_t reset;  ///< 0x30 [W]: Soft Reset register
  volatile uint32_t REV0;  ///< 0x34 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0x38 [R]: IP Tagging Revision 1
} JBIG_CODEC_2_IDMA_REGS_t;

//====================================================================
//
//Register File: ODMA Registers (JBIG_CODEC_2_ODMA)
/** \brief Register Descriptions for the ODMA_AXI block (rev 0 . 4 . 0 . 7)*/
//
//====================================================================

typedef struct JBIG_CODEC_2_ODMA_REGS_s
{
  volatile uint32_t cfg;  ///< 0x0 [R/W]: Configuration register
  volatile uint32_t status;  ///< 0x4 [R]: Status register
  volatile uint32_t line_size;  ///< 0x8 [R/W]: Line Size Register
  volatile uint32_t int_en;  ///< 0xc [R/W]: Interrupt Enable Register
  volatile uint32_t int_pend;  ///< 0x10 [R]: Interrupt Pending Register
  volatile uint32_t int_ack;  ///< 0x14 [W]: Interrupt Acknowledge Register
  volatile uint32_t int_fo;  ///< 0x18 [W]: Interrupt Force Register
  volatile uint32_t desc_write;  ///< 0x1c [W]: Descriptor Write Register
  volatile uint32_t desc_read;  ///< 0x20 [R]: Descriptor Read Register
  volatile uint32_t xfer_length;  ///< 0x24 [R]: Descriptor Transfer Length Register
  volatile uint32_t xfer_addr;  ///< 0x28 [R]: Descriptor Transfer Address Register
  volatile uint32_t xfer_burst;  ///< 0x2c [R]: Descriptor Transfer Burst Register
  volatile uint32_t reserved0;
  volatile uint32_t reset;  ///< 0x34 [W]: Soft Reset register
  volatile uint32_t REV0;  ///< 0x38 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0x3c [R]: IP Tagging Revision 1
} JBIG_CODEC_2_ODMA_REGS_t;

//====================================================================
//
//Register File: JBIG Decode Registers (JBIG_DECODE_2_CORE)
/** \brief Register Description for CODEC CORE*/
//
//====================================================================

typedef struct JBIG_DECODE_2_CORE_REGS_s
{
  volatile uint32_t JCTL;  ///< 0x0 [R/W]: Codec JBIG Control Register
  volatile uint32_t JSTAT;  ///< 0x4 [R/W]: Codec JBIG Status Register
  volatile uint32_t JX;  ///< 0x8 [R/W]: Codec JBIG X-Dimension (Pixels/line) Register
  volatile uint32_t JY;  ///< 0xc [R/W]: Codec JBIG Y-Dimension (Lines/page) Register
  volatile uint32_t JBIG_EN;  ///< 0x10 [R/W]: Codec JBIG Enable Register
  volatile uint32_t reserved0[4];
  volatile uint32_t JSL;  ///< 0x24 [R/W]: Codec JBIG Stripe Length Register
} JBIG_DECODE_2_CORE_REGS_t;

//====================================================================
//
//Register File: IDMA Registers (JBIG_DECODE_2_IDMA)
/** \brief Registers for the IDMA_AXI module <br/> (rev 0 . 1 . 0 . 5)*/
//
//====================================================================

typedef struct JBIG_DECODE_2_IDMA_REGS_s
{
  volatile uint32_t cfg;  ///< 0x0 [R/W]: Configuration register
  volatile uint32_t status;  ///< 0x4 [R]: Status register
  volatile uint32_t line_width;  ///< 0x8 [R/W]: Line Width register
  volatile uint32_t int_en;  ///< 0xc [R/W]: Interrupt Enable Register
  volatile uint32_t int_st;  ///< 0x10 [R]: Interrupt Pending Register
  volatile uint32_t int_cl;  ///< 0x14 [W]: Interrupt Clear Register
  volatile uint32_t int_fo;  ///< 0x18 [W]: Interrupt Force Register
  volatile uint32_t desc_write;  ///< 0x1c [W]: Descriptor Write Register
  volatile uint32_t desc_read;  ///< 0x20 [R]: Descriptor Read Register
  volatile uint32_t xfer_length;  ///< 0x24 [R]: Descriptor Transfer Length Register
  volatile uint32_t xfer_addr;  ///< 0x28 [R]: Descriptor Transfer Address Register
  volatile uint32_t ctrl_word;  ///< 0x2c [R]: Descriptor Control Word Register
  volatile uint32_t reset;  ///< 0x30 [W]: Soft Reset register
  volatile uint32_t REV0;  ///< 0x34 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0x38 [R]: IP Tagging Revision 1
} JBIG_DECODE_2_IDMA_REGS_t;

//====================================================================
//
//Register File: ODMA Registers (JBIG_DECODE_2_ODMA)
/** \brief Register Descriptions for the ODMA_AXI block (rev 0 . 4 . 0 . 7)*/
//
//====================================================================

typedef struct JBIG_DECODE_2_ODMA_REGS_s
{
  volatile uint32_t cfg;  ///< 0x0 [R/W]: Configuration register
  volatile uint32_t status;  ///< 0x4 [R]: Status register
  volatile uint32_t line_size;  ///< 0x8 [R/W]: Line Size Register
  volatile uint32_t int_en;  ///< 0xc [R/W]: Interrupt Enable Register
  volatile uint32_t int_pend;  ///< 0x10 [R]: Interrupt Pending Register
  volatile uint32_t int_ack;  ///< 0x14 [W]: Interrupt Acknowledge Register
  volatile uint32_t int_fo;  ///< 0x18 [W]: Interrupt Force Register
  volatile uint32_t desc_write;  ///< 0x1c [W]: Descriptor Write Register
  volatile uint32_t desc_read;  ///< 0x20 [R]: Descriptor Read Register
  volatile uint32_t xfer_length;  ///< 0x24 [R]: Descriptor Transfer Length Register
  volatile uint32_t xfer_addr;  ///< 0x28 [R]: Descriptor Transfer Address Register
  volatile uint32_t xfer_burst;  ///< 0x2c [R]: Descriptor Transfer Burst Register
  volatile uint32_t reserved0;
  volatile uint32_t reset;  ///< 0x34 [W]: Soft Reset register
  volatile uint32_t REV0;  ///< 0x38 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0x3c [R]: IP Tagging Revision 1
} JBIG_DECODE_2_ODMA_REGS_t;

//====================================================================
//
//Register File: JBIG Codec Registers (JBIG_CODEC_3_CORE)
/** \brief Register Description for CODEC CORE*/
//
//====================================================================

typedef struct JBIG_CODEC_3_CORE_REGS_s
{
  volatile uint32_t JCTL;  ///< 0x0 [R/W]: Codec JBIG Control Register
  volatile uint32_t JSTAT;  ///< 0x4 [R/W]: Codec JBIG Status Register
  volatile uint32_t JX;  ///< 0x8 [R/W]: Codec JBIG X-Dimension (Pixels/line) Register
  volatile uint32_t JY;  ///< 0xc [R/W]: Codec JBIG Y-Dimension (Lines/page) Register
  volatile uint32_t JBIG_EN;  ///< 0x10 [R/W]: Codec JBIG Enable Register
  volatile uint32_t reserved0[4];
  volatile uint32_t JSL;  ///< 0x24 [R/W]: Codec JBIG Stripe Length Register
} JBIG_CODEC_3_CORE_REGS_t;

//====================================================================
//
//Register File: IDMA Registers (JBIG_CODEC_3_IDMA)
/** \brief Registers for the IDMA_AXI module <br/> (rev 0 . 1 . 0 . 5)*/
//
//====================================================================

typedef struct JBIG_CODEC_3_IDMA_REGS_s
{
  volatile uint32_t cfg;  ///< 0x0 [R/W]: Configuration register
  volatile uint32_t status;  ///< 0x4 [R]: Status register
  volatile uint32_t line_width;  ///< 0x8 [R/W]: Line Width register
  volatile uint32_t int_en;  ///< 0xc [R/W]: Interrupt Enable Register
  volatile uint32_t int_st;  ///< 0x10 [R]: Interrupt Pending Register
  volatile uint32_t int_cl;  ///< 0x14 [W]: Interrupt Clear Register
  volatile uint32_t int_fo;  ///< 0x18 [W]: Interrupt Force Register
  volatile uint32_t desc_write;  ///< 0x1c [W]: Descriptor Write Register
  volatile uint32_t desc_read;  ///< 0x20 [R]: Descriptor Read Register
  volatile uint32_t xfer_length;  ///< 0x24 [R]: Descriptor Transfer Length Register
  volatile uint32_t xfer_addr;  ///< 0x28 [R]: Descriptor Transfer Address Register
  volatile uint32_t ctrl_word;  ///< 0x2c [R]: Descriptor Control Word Register
  volatile uint32_t reset;  ///< 0x30 [W]: Soft Reset register
  volatile uint32_t REV0;  ///< 0x34 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0x38 [R]: IP Tagging Revision 1
} JBIG_CODEC_3_IDMA_REGS_t;

//====================================================================
//
//Register File: ODMA Registers (JBIG_CODEC_3_ODMA)
/** \brief Register Descriptions for the ODMA_AXI block (rev 0 . 4 . 0 . 7)*/
//
//====================================================================

typedef struct JBIG_CODEC_3_ODMA_REGS_s
{
  volatile uint32_t cfg;  ///< 0x0 [R/W]: Configuration register
  volatile uint32_t status;  ///< 0x4 [R]: Status register
  volatile uint32_t line_size;  ///< 0x8 [R/W]: Line Size Register
  volatile uint32_t int_en;  ///< 0xc [R/W]: Interrupt Enable Register
  volatile uint32_t int_pend;  ///< 0x10 [R]: Interrupt Pending Register
  volatile uint32_t int_ack;  ///< 0x14 [W]: Interrupt Acknowledge Register
  volatile uint32_t int_fo;  ///< 0x18 [W]: Interrupt Force Register
  volatile uint32_t desc_write;  ///< 0x1c [W]: Descriptor Write Register
  volatile uint32_t desc_read;  ///< 0x20 [R]: Descriptor Read Register
  volatile uint32_t xfer_length;  ///< 0x24 [R]: Descriptor Transfer Length Register
  volatile uint32_t xfer_addr;  ///< 0x28 [R]: Descriptor Transfer Address Register
  volatile uint32_t xfer_burst;  ///< 0x2c [R]: Descriptor Transfer Burst Register
  volatile uint32_t reserved0;
  volatile uint32_t reset;  ///< 0x34 [W]: Soft Reset register
  volatile uint32_t REV0;  ///< 0x38 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0x3c [R]: IP Tagging Revision 1
} JBIG_CODEC_3_ODMA_REGS_t;

//====================================================================
//
//Register File: JBIG Decode Registers (JBIG_DECODE_3_CORE)
/** \brief Register Description for CODEC CORE*/
//
//====================================================================

typedef struct JBIG_DECODE_3_CORE_REGS_s
{
  volatile uint32_t JCTL;  ///< 0x0 [R/W]: Codec JBIG Control Register
  volatile uint32_t JSTAT;  ///< 0x4 [R/W]: Codec JBIG Status Register
  volatile uint32_t JX;  ///< 0x8 [R/W]: Codec JBIG X-Dimension (Pixels/line) Register
  volatile uint32_t JY;  ///< 0xc [R/W]: Codec JBIG Y-Dimension (Lines/page) Register
  volatile uint32_t JBIG_EN;  ///< 0x10 [R/W]: Codec JBIG Enable Register
  volatile uint32_t reserved0[4];
  volatile uint32_t JSL;  ///< 0x24 [R/W]: Codec JBIG Stripe Length Register
} JBIG_DECODE_3_CORE_REGS_t;

//====================================================================
//
//Register File: IDMA Registers (JBIG_DECODE_3_IDMA)
/** \brief Registers for the IDMA_AXI module <br/> (rev 0 . 1 . 0 . 5)*/
//
//====================================================================

typedef struct JBIG_DECODE_3_IDMA_REGS_s
{
  volatile uint32_t cfg;  ///< 0x0 [R/W]: Configuration register
  volatile uint32_t status;  ///< 0x4 [R]: Status register
  volatile uint32_t line_width;  ///< 0x8 [R/W]: Line Width register
  volatile uint32_t int_en;  ///< 0xc [R/W]: Interrupt Enable Register
  volatile uint32_t int_st;  ///< 0x10 [R]: Interrupt Pending Register
  volatile uint32_t int_cl;  ///< 0x14 [W]: Interrupt Clear Register
  volatile uint32_t int_fo;  ///< 0x18 [W]: Interrupt Force Register
  volatile uint32_t desc_write;  ///< 0x1c [W]: Descriptor Write Register
  volatile uint32_t desc_read;  ///< 0x20 [R]: Descriptor Read Register
  volatile uint32_t xfer_length;  ///< 0x24 [R]: Descriptor Transfer Length Register
  volatile uint32_t xfer_addr;  ///< 0x28 [R]: Descriptor Transfer Address Register
  volatile uint32_t ctrl_word;  ///< 0x2c [R]: Descriptor Control Word Register
  volatile uint32_t reset;  ///< 0x30 [W]: Soft Reset register
  volatile uint32_t REV0;  ///< 0x34 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0x38 [R]: IP Tagging Revision 1
} JBIG_DECODE_3_IDMA_REGS_t;

//====================================================================
//
//Register File: ODMA Registers (JBIG_DECODE_3_ODMA)
/** \brief Register Descriptions for the ODMA_AXI block (rev 0 . 4 . 0 . 7)*/
//
//====================================================================

typedef struct JBIG_DECODE_3_ODMA_REGS_s
{
  volatile uint32_t cfg;  ///< 0x0 [R/W]: Configuration register
  volatile uint32_t status;  ///< 0x4 [R]: Status register
  volatile uint32_t line_size;  ///< 0x8 [R/W]: Line Size Register
  volatile uint32_t int_en;  ///< 0xc [R/W]: Interrupt Enable Register
  volatile uint32_t int_pend;  ///< 0x10 [R]: Interrupt Pending Register
  volatile uint32_t int_ack;  ///< 0x14 [W]: Interrupt Acknowledge Register
  volatile uint32_t int_fo;  ///< 0x18 [W]: Interrupt Force Register
  volatile uint32_t desc_write;  ///< 0x1c [W]: Descriptor Write Register
  volatile uint32_t desc_read;  ///< 0x20 [R]: Descriptor Read Register
  volatile uint32_t xfer_length;  ///< 0x24 [R]: Descriptor Transfer Length Register
  volatile uint32_t xfer_addr;  ///< 0x28 [R]: Descriptor Transfer Address Register
  volatile uint32_t xfer_burst;  ///< 0x2c [R]: Descriptor Transfer Burst Register
  volatile uint32_t reserved0;
  volatile uint32_t reset;  ///< 0x34 [W]: Soft Reset register
  volatile uint32_t REV0;  ///< 0x38 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0x3c [R]: IP Tagging Revision 1
} JBIG_DECODE_3_ODMA_REGS_t;

//====================================================================
//
//Register File: JBIG Codec Registers (JBIG_CODEC_4_CORE)
/** \brief Register Description for CODEC CORE*/
//
//====================================================================

typedef struct JBIG_CODEC_4_CORE_REGS_s
{
  volatile uint32_t JCTL;  ///< 0x0 [R/W]: Codec JBIG Control Register
  volatile uint32_t JSTAT;  ///< 0x4 [R/W]: Codec JBIG Status Register
  volatile uint32_t JX;  ///< 0x8 [R/W]: Codec JBIG X-Dimension (Pixels/line) Register
  volatile uint32_t JY;  ///< 0xc [R/W]: Codec JBIG Y-Dimension (Lines/page) Register
  volatile uint32_t JBIG_EN;  ///< 0x10 [R/W]: Codec JBIG Enable Register
  volatile uint32_t reserved0[4];
  volatile uint32_t JSL;  ///< 0x24 [R/W]: Codec JBIG Stripe Length Register
} JBIG_CODEC_4_CORE_REGS_t;

//====================================================================
//
//Register File: IDMA Registers (JBIG_CODEC_4_IDMA)
/** \brief Registers for the IDMA_AXI module <br/> (rev 0 . 1 . 0 . 5)*/
//
//====================================================================

typedef struct JBIG_CODEC_4_IDMA_REGS_s
{
  volatile uint32_t cfg;  ///< 0x0 [R/W]: Configuration register
  volatile uint32_t status;  ///< 0x4 [R]: Status register
  volatile uint32_t line_width;  ///< 0x8 [R/W]: Line Width register
  volatile uint32_t int_en;  ///< 0xc [R/W]: Interrupt Enable Register
  volatile uint32_t int_st;  ///< 0x10 [R]: Interrupt Pending Register
  volatile uint32_t int_cl;  ///< 0x14 [W]: Interrupt Clear Register
  volatile uint32_t int_fo;  ///< 0x18 [W]: Interrupt Force Register
  volatile uint32_t desc_write;  ///< 0x1c [W]: Descriptor Write Register
  volatile uint32_t desc_read;  ///< 0x20 [R]: Descriptor Read Register
  volatile uint32_t xfer_length;  ///< 0x24 [R]: Descriptor Transfer Length Register
  volatile uint32_t xfer_addr;  ///< 0x28 [R]: Descriptor Transfer Address Register
  volatile uint32_t ctrl_word;  ///< 0x2c [R]: Descriptor Control Word Register
  volatile uint32_t reset;  ///< 0x30 [W]: Soft Reset register
  volatile uint32_t REV0;  ///< 0x34 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0x38 [R]: IP Tagging Revision 1
} JBIG_CODEC_4_IDMA_REGS_t;

//====================================================================
//
//Register File: ODMA Registers (JBIG_CODEC_4_ODMA)
/** \brief Register Descriptions for the ODMA_AXI block (rev 0 . 4 . 0 . 7)*/
//
//====================================================================

typedef struct JBIG_CODEC_4_ODMA_REGS_s
{
  volatile uint32_t cfg;  ///< 0x0 [R/W]: Configuration register
  volatile uint32_t status;  ///< 0x4 [R]: Status register
  volatile uint32_t line_size;  ///< 0x8 [R/W]: Line Size Register
  volatile uint32_t int_en;  ///< 0xc [R/W]: Interrupt Enable Register
  volatile uint32_t int_pend;  ///< 0x10 [R]: Interrupt Pending Register
  volatile uint32_t int_ack;  ///< 0x14 [W]: Interrupt Acknowledge Register
  volatile uint32_t int_fo;  ///< 0x18 [W]: Interrupt Force Register
  volatile uint32_t desc_write;  ///< 0x1c [W]: Descriptor Write Register
  volatile uint32_t desc_read;  ///< 0x20 [R]: Descriptor Read Register
  volatile uint32_t xfer_length;  ///< 0x24 [R]: Descriptor Transfer Length Register
  volatile uint32_t xfer_addr;  ///< 0x28 [R]: Descriptor Transfer Address Register
  volatile uint32_t xfer_burst;  ///< 0x2c [R]: Descriptor Transfer Burst Register
  volatile uint32_t reserved0;
  volatile uint32_t reset;  ///< 0x34 [W]: Soft Reset register
  volatile uint32_t REV0;  ///< 0x38 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0x3c [R]: IP Tagging Revision 1
} JBIG_CODEC_4_ODMA_REGS_t;

#endif // JBIG_CLSTR
