 /*
 **************************************************************************************
 *
 * (c) Copyright 2013 Marvell International Ltd.
 *
 *
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/.
 *
 **************************************************************************************
 *
 * \file IPC_regmasks.h
 * Generated using RegBuild 1.6.3
 *
 **************************************************************************************
 */

#ifndef _IPC_REGMASKS_H_
#define _IPC_REGMASKS_H_

#ifndef __KERNEL__
#include <stdint.h>
#endif

//====================================================================
//
//Register File: IPC (IPC)
/** \brief Register Descriptions for the IPC (rev 0 . 3 . 2 . 0)*/
//
//====================================================================

//====================================================================
//Register: IPC_ISRR (IPC_ISRR)
//====================================================================

#define  IPC_IPC_ISRR_RESERVED1_MASK 0xfffff800
#define  IPC_IPC_ISRR_RESERVED1_SHIFT 11
#define  IPC_IPC_ISRR_RESERVED1_MASK_SHIFT(reg) (((reg) & IPC_IPC_ISRR_RESERVED1_MASK) >> IPC_IPC_ISRR_RESERVED1_SHIFT)
#define  IPC_IPC_ISRR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IPC_IPC_ISRR_RESERVED1_MASK) | (((uint32_t)val) << IPC_IPC_ISRR_RESERVED1_SHIFT))

#define  IPC_IPC_ISRR_APB_IPC_ISRR_MASK 0x7ff
#define  IPC_IPC_ISRR_APB_IPC_ISRR_SHIFT 0
#define  IPC_IPC_ISRR_APB_IPC_ISRR_MASK_SHIFT(reg) (((reg) & IPC_IPC_ISRR_APB_IPC_ISRR_MASK) >> IPC_IPC_ISRR_APB_IPC_ISRR_SHIFT)
#define  IPC_IPC_ISRR_APB_IPC_ISRR_REPLACE_VAL(reg,val) (((reg) & ~IPC_IPC_ISRR_APB_IPC_ISRR_MASK) | (((uint32_t)val) << IPC_IPC_ISRR_APB_IPC_ISRR_SHIFT))

//====================================================================
//Register: Write Data Register 0 (IPC_WDR_0)
//====================================================================

#define  IPC_IPC_WDR_0_APB_IPC_WDR_0_MASK 0xffffffff
#define  IPC_IPC_WDR_0_APB_IPC_WDR_0_SHIFT 0
#define  IPC_IPC_WDR_0_APB_IPC_WDR_0_MASK_SHIFT(reg) (((reg) & IPC_IPC_WDR_0_APB_IPC_WDR_0_MASK) >> IPC_IPC_WDR_0_APB_IPC_WDR_0_SHIFT)
#define  IPC_IPC_WDR_0_APB_IPC_WDR_0_REPLACE_VAL(reg,val) (((reg) & ~IPC_IPC_WDR_0_APB_IPC_WDR_0_MASK) | (((uint32_t)val) << IPC_IPC_WDR_0_APB_IPC_WDR_0_SHIFT))

//====================================================================
//Register: Write Data Register 1 (IPC_WDR_1)
//====================================================================

#define  IPC_IPC_WDR_1_APB_IPC_WDR_1_MASK 0xffffffff
#define  IPC_IPC_WDR_1_APB_IPC_WDR_1_SHIFT 0
#define  IPC_IPC_WDR_1_APB_IPC_WDR_1_MASK_SHIFT(reg) (((reg) & IPC_IPC_WDR_1_APB_IPC_WDR_1_MASK) >> IPC_IPC_WDR_1_APB_IPC_WDR_1_SHIFT)
#define  IPC_IPC_WDR_1_APB_IPC_WDR_1_REPLACE_VAL(reg,val) (((reg) & ~IPC_IPC_WDR_1_APB_IPC_WDR_1_MASK) | (((uint32_t)val) << IPC_IPC_WDR_1_APB_IPC_WDR_1_SHIFT))

//====================================================================
//Register: Interrupt Set Register Write (IPC_ISRW)
/** \brief IPCA base register generate interrupt IPC1 - IPC1 is logic OR of all the IPC
interrupts sets by this register
IPCB base register generate interrupt IPC2 - IPC2 is logic OR of all the IPC
interrupts sets by this register*/
//====================================================================

#define  IPC_IPC_ISRW_RESERVED1_MASK 0xfffff800
#define  IPC_IPC_ISRW_RESERVED1_SHIFT 11
#define  IPC_IPC_ISRW_RESERVED1_MASK_SHIFT(reg) (((reg) & IPC_IPC_ISRW_RESERVED1_MASK) >> IPC_IPC_ISRW_RESERVED1_SHIFT)
#define  IPC_IPC_ISRW_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IPC_IPC_ISRW_RESERVED1_MASK) | (((uint32_t)val) << IPC_IPC_ISRW_RESERVED1_SHIFT))

#define  IPC_IPC_ISRW_APB_IPC_ISRW_MASK 0x7ff
#define  IPC_IPC_ISRW_APB_IPC_ISRW_SHIFT 0
#define  IPC_IPC_ISRW_APB_IPC_ISRW_MASK_SHIFT(reg) (((reg) & IPC_IPC_ISRW_APB_IPC_ISRW_MASK) >> IPC_IPC_ISRW_APB_IPC_ISRW_SHIFT)
#define  IPC_IPC_ISRW_APB_IPC_ISRW_REPLACE_VAL(reg,val) (((reg) & ~IPC_IPC_ISRW_APB_IPC_ISRW_MASK) | (((uint32_t)val) << IPC_IPC_ISRW_APB_IPC_ISRW_SHIFT))

//====================================================================
//Register: Interrupt Clear Register (IPC_ICR)
//====================================================================

#define  IPC_IPC_ICR_RESERVED1_MASK 0xfffff800
#define  IPC_IPC_ICR_RESERVED1_SHIFT 11
#define  IPC_IPC_ICR_RESERVED1_MASK_SHIFT(reg) (((reg) & IPC_IPC_ICR_RESERVED1_MASK) >> IPC_IPC_ICR_RESERVED1_SHIFT)
#define  IPC_IPC_ICR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IPC_IPC_ICR_RESERVED1_MASK) | (((uint32_t)val) << IPC_IPC_ICR_RESERVED1_SHIFT))

#define  IPC_IPC_ICR_APB_IPC_ICR_MASK 0x7ff
#define  IPC_IPC_ICR_APB_IPC_ICR_SHIFT 0
#define  IPC_IPC_ICR_APB_IPC_ICR_MASK_SHIFT(reg) (((reg) & IPC_IPC_ICR_APB_IPC_ICR_MASK) >> IPC_IPC_ICR_APB_IPC_ICR_SHIFT)
#define  IPC_IPC_ICR_APB_IPC_ICR_REPLACE_VAL(reg,val) (((reg) & ~IPC_IPC_ICR_APB_IPC_ICR_MASK) | (((uint32_t)val) << IPC_IPC_ICR_APB_IPC_ICR_SHIFT))

//====================================================================
//Register: Interrupt Identification Register (IPC_IIR)
//====================================================================

#define  IPC_IPC_IIR_RESERVED1_MASK 0xfffff800
#define  IPC_IPC_IIR_RESERVED1_SHIFT 11
#define  IPC_IPC_IIR_RESERVED1_MASK_SHIFT(reg) (((reg) & IPC_IPC_IIR_RESERVED1_MASK) >> IPC_IPC_IIR_RESERVED1_SHIFT)
#define  IPC_IPC_IIR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IPC_IPC_IIR_RESERVED1_MASK) | (((uint32_t)val) << IPC_IPC_IIR_RESERVED1_SHIFT))

#define  IPC_IPC_IIR_APB_IPC_IIR_MASK 0x7ff
#define  IPC_IPC_IIR_APB_IPC_IIR_SHIFT 0
#define  IPC_IPC_IIR_APB_IPC_IIR_MASK_SHIFT(reg) (((reg) & IPC_IPC_IIR_APB_IPC_IIR_MASK) >> IPC_IPC_IIR_APB_IPC_IIR_SHIFT)
#define  IPC_IPC_IIR_APB_IPC_IIR_REPLACE_VAL(reg,val) (((reg) & ~IPC_IPC_IIR_APB_IPC_IIR_MASK) | (((uint32_t)val) << IPC_IPC_IIR_APB_IPC_IIR_SHIFT))

//====================================================================
//Register: Read Data Register 0 (IPC_RDR_0)
//====================================================================

#define  IPC_IPC_RDR_0_APB_IPC_RDR_0_MASK 0xffffffff
#define  IPC_IPC_RDR_0_APB_IPC_RDR_0_SHIFT 0
#define  IPC_IPC_RDR_0_APB_IPC_RDR_0_MASK_SHIFT(reg) (((reg) & IPC_IPC_RDR_0_APB_IPC_RDR_0_MASK) >> IPC_IPC_RDR_0_APB_IPC_RDR_0_SHIFT)
#define  IPC_IPC_RDR_0_APB_IPC_RDR_0_REPLACE_VAL(reg,val) (((reg) & ~IPC_IPC_RDR_0_APB_IPC_RDR_0_MASK) | (((uint32_t)val) << IPC_IPC_RDR_0_APB_IPC_RDR_0_SHIFT))

//====================================================================
//Register: Read Data Register 1 (IPC_RDR_1)
//====================================================================

#define  IPC_IPC_RDR_1_APB_IPC_RDR_1_MASK 0xffffffff
#define  IPC_IPC_RDR_1_APB_IPC_RDR_1_SHIFT 0
#define  IPC_IPC_RDR_1_APB_IPC_RDR_1_MASK_SHIFT(reg) (((reg) & IPC_IPC_RDR_1_APB_IPC_RDR_1_MASK) >> IPC_IPC_RDR_1_APB_IPC_RDR_1_SHIFT)
#define  IPC_IPC_RDR_1_APB_IPC_RDR_1_REPLACE_VAL(reg,val) (((reg) & ~IPC_IPC_RDR_1_APB_IPC_RDR_1_MASK) | (((uint32_t)val) << IPC_IPC_RDR_1_APB_IPC_RDR_1_SHIFT))

//====================================================================
//Register: Revision (Major and Mid) Register (IPC_MAJ_MID_REV)
//====================================================================

#define  IPC_IPC_MAJ_MID_REV_MAJ_REV_MASK 0xffff0000
#define  IPC_IPC_MAJ_MID_REV_MAJ_REV_SHIFT 16
#define  IPC_IPC_MAJ_MID_REV_MAJ_REV_MASK_SHIFT(reg) (((reg) & IPC_IPC_MAJ_MID_REV_MAJ_REV_MASK) >> IPC_IPC_MAJ_MID_REV_MAJ_REV_SHIFT)
#define  IPC_IPC_MAJ_MID_REV_MAJ_REV_REPLACE_VAL(reg,val) (((reg) & ~IPC_IPC_MAJ_MID_REV_MAJ_REV_MASK) | (((uint32_t)val) << IPC_IPC_MAJ_MID_REV_MAJ_REV_SHIFT))

#define  IPC_IPC_MAJ_MID_REV_MID_REV_MASK 0xffff
#define  IPC_IPC_MAJ_MID_REV_MID_REV_SHIFT 0
#define  IPC_IPC_MAJ_MID_REV_MID_REV_MASK_SHIFT(reg) (((reg) & IPC_IPC_MAJ_MID_REV_MID_REV_MASK) >> IPC_IPC_MAJ_MID_REV_MID_REV_SHIFT)
#define  IPC_IPC_MAJ_MID_REV_MID_REV_REPLACE_VAL(reg,val) (((reg) & ~IPC_IPC_MAJ_MID_REV_MID_REV_MASK) | (((uint32_t)val) << IPC_IPC_MAJ_MID_REV_MID_REV_SHIFT))

//====================================================================
//Register: Revision (Configuration) Register (IPC_CFG_REV)
//====================================================================

#define  IPC_IPC_CFG_REV_RESERVED1_MASK 0xffff0000
#define  IPC_IPC_CFG_REV_RESERVED1_SHIFT 16
#define  IPC_IPC_CFG_REV_RESERVED1_MASK_SHIFT(reg) (((reg) & IPC_IPC_CFG_REV_RESERVED1_MASK) >> IPC_IPC_CFG_REV_RESERVED1_SHIFT)
#define  IPC_IPC_CFG_REV_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IPC_IPC_CFG_REV_RESERVED1_MASK) | (((uint32_t)val) << IPC_IPC_CFG_REV_RESERVED1_SHIFT))

#define  IPC_IPC_CFG_REV_CFG_REV_MASK 0xffff
#define  IPC_IPC_CFG_REV_CFG_REV_SHIFT 0
#define  IPC_IPC_CFG_REV_CFG_REV_MASK_SHIFT(reg) (((reg) & IPC_IPC_CFG_REV_CFG_REV_MASK) >> IPC_IPC_CFG_REV_CFG_REV_SHIFT)
#define  IPC_IPC_CFG_REV_CFG_REV_REPLACE_VAL(reg,val) (((reg) & ~IPC_IPC_CFG_REV_CFG_REV_MASK) | (((uint32_t)val) << IPC_IPC_CFG_REV_CFG_REV_SHIFT))

//====================================================================
//Register: Dummy Register (IPC_DUMMY)
//====================================================================

#define  IPC_IPC_DUMMY_APB_IPC_DUMMY_MASK 0xffffffff
#define  IPC_IPC_DUMMY_APB_IPC_DUMMY_SHIFT 0
#define  IPC_IPC_DUMMY_APB_IPC_DUMMY_MASK_SHIFT(reg) (((reg) & IPC_IPC_DUMMY_APB_IPC_DUMMY_MASK) >> IPC_IPC_DUMMY_APB_IPC_DUMMY_SHIFT)
#define  IPC_IPC_DUMMY_APB_IPC_DUMMY_REPLACE_VAL(reg,val) (((reg) & ~IPC_IPC_DUMMY_APB_IPC_DUMMY_MASK) | (((uint32_t)val) << IPC_IPC_DUMMY_APB_IPC_DUMMY_SHIFT))

#endif // IPC
