 /*
 **************************************************************************************
 *
 * (c) Copyright 2013 Marvell International Ltd.
 *
 *
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/.
 *
 **************************************************************************************
 *
 * \file HTStats_regstructs.h
 * Generated using RegBuild 1.6.3
 *
 **************************************************************************************
 */

#ifndef _HTSTATS_REGSTRUCTS_H_
#define _HTSTATS_REGSTRUCTS_H_

#ifndef __KERNEL__
#include <stdint.h>
#endif

//====================================================================
//
//Register File: HTStats (HTStats)
/** \brief (rev 0 . 1 . 1 . 0)
    Register descriptions for the HTSTATS block.*/
//
//====================================================================

typedef struct HTSTATS_REGS_s
{
  volatile uint32_t CR;  ///< 0x0 [R/W]: Configuration Register
  volatile uint32_t REV0;  ///< 0x4 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0x8 [R]: IP Tagging Revision 1
  volatile uint32_t reserved0;
  volatile uint32_t CH0_IsoMag;  ///< 0x10 [R/W]: Channel 0: Isolated Pixel Magnitude Replacement
  volatile uint32_t CH0_Accum;  ///< 0x14 [R/W]: Channel 0: Accumulation
  volatile uint32_t CH0_SBP;  ///< 0x18 [R/W]: Channel 0: Surrounded Black Pixel Count
  volatile uint32_t CH0_IsoCnt0;  ///< 0x1c [R/W]: Channel 0: Isolated pixel with center pixel magnitude of 0
  volatile uint32_t CH0_IsoCnt1;  ///< 0x20 [R/W]: Channel 0: Isolated pixel with center pixel magnitude of 1 or 3
  volatile uint32_t CH0_IsoCnt2;  ///< 0x24 [R/W]: Channel 0: Isolated pixel with center pixel magnitude of 4 or 5
  volatile uint32_t CH0_IsoCnt3;  ///< 0x28 [R/W]: Channel 0: Isolated pixel with center pixel magnitude of 6 or 7
  volatile uint32_t CH0_CntRst;  ///< 0x2c [W]: Channel 0: Counter Reset
  volatile uint32_t CH1_IsoMag;  ///< 0x30 [R/W]: Channel 1: Isolated Pixel Magnitude Replacement
  volatile uint32_t CH1_Accum;  ///< 0x34 [R/W]: Channel 1: Accumulation
  volatile uint32_t CH1_SBP;  ///< 0x38 [R/W]: Channel 1: Surrounded Black Pixel Count
  volatile uint32_t CH1_IsoCnt0;  ///< 0x3c [R/W]: Channel 1: Isolated pixel with center pixel magnitude of 0
  volatile uint32_t CH1_IsoCnt1;  ///< 0x40 [R/W]: Channel 1: Isolated pixel with center pixel magnitude of 1 or 3
  volatile uint32_t CH1_IsoCnt2;  ///< 0x44 [R/W]: Channel 1: Isolated pixel with center pixel magnitude of 4 or 5
  volatile uint32_t CH1_IsoCnt3;  ///< 0x48 [R/W]: Channel 1: Isolated pixel with center pixel magnitude of 6 or 7
  volatile uint32_t CH1_CntRst;  ///< 0x4c [W]: Channel 1: Counter Reset
  volatile uint32_t CH2_IsoMag;  ///< 0x50 [R/W]: Channel 2: Isolated Pixel Magnitude Replacement
  volatile uint32_t CH2_Accum;  ///< 0x54 [R/W]: Channel 2: Accumulation
  volatile uint32_t CH2_SBP;  ///< 0x58 [R/W]: Channel 2: Surrounded Black Pixel Count
  volatile uint32_t CH2_IsoCnt0;  ///< 0x5c [R/W]: Channel 2: Isolated pixel with center pixel magnitude of 0
  volatile uint32_t CH2_IsoCnt1;  ///< 0x60 [R/W]: Channel 2: Isolated pixel with center pixel magnitude of 1 or 3
  volatile uint32_t CH2_IsoCnt2;  ///< 0x64 [R/W]: Channel 2: Isolated pixel with center pixel magnitude of 4 or 5
  volatile uint32_t CH2_IsoCnt3;  ///< 0x68 [R/W]: Channel 2: Isolated pixel with center pixel magnitude of 6 or 7
  volatile uint32_t CH2_CntRst;  ///< 0x6c [W]: Channel 2: Counter Reset
  volatile uint32_t CH3_IsoMag;  ///< 0x70 [R/W]: Channel 3: Isolated Pixel Magnitude Replacement
  volatile uint32_t CH3_Accum;  ///< 0x74 [R/W]: Channel 3: Accumulation
  volatile uint32_t CH3_SBP;  ///< 0x78 [R/W]: Channel 3: Surrounded Black Pixel Count
  volatile uint32_t CH3_IsoCnt0;  ///< 0x7c [R/W]: Channel 3: Isolated pixel with center pixel magnitude of 0
  volatile uint32_t CH3_IsoCnt1;  ///< 0x80 [R/W]: Channel 3: Isolated pixel with center pixel magnitude of 1 or 3
  volatile uint32_t CH3_IsoCnt2;  ///< 0x84 [R/W]: Channel 3: Isolated pixel with center pixel magnitude of 4 or 5
  volatile uint32_t CH3_IsoCnt3;  ///< 0x88 [R/W]: Channel 3: Isolated pixel with center pixel magnitude of 6 or 7
  volatile uint32_t CH3_CntRst;  ///< 0x8c [W]: Channel 3: Counter Reset
  volatile uint32_t LW;  ///< 0x90 [R/W]: Pixel Line Width Configuration Register
  volatile uint32_t reserved1[27];
  volatile uint32_t V2M_LUT[16];  ///< 0x100 [R/W]: Vcode to Magnitude Look Up Table
  volatile uint32_t reserved2[48];
  volatile uint32_t ARAR;  ///< 0x200 [R/W]: AMLUT RAM Access Control Register
  volatile uint32_t ARAWR;  ///< 0x204 [W]: AMLUT RAM Address Write Register
  volatile uint32_t ARASR;  ///< 0x208 [R]: AMLUT RAM Address Status Register
  volatile uint32_t ARDWR;  ///< 0x20c [W]: AMLUT RAM Data Write Register
  volatile uint32_t ARDRR;  ///< 0x210 [R]: AMLUT RAM Data Read Register
  volatile uint32_t LBAR;  ///< 0x214 [R/W]: LineBuffer Access Control Register
  volatile uint32_t LBAWR;  ///< 0x218 [W]: LineBuffer Address Write Register
  volatile uint32_t LBASR;  ///< 0x21c [R]: LineBuffer Address Status Register
  volatile uint32_t LBDWR;  ///< 0x220 [W]: LineBuffer Data Write Register
  volatile uint32_t LBDRR;  ///< 0x224 [R]: LineBuffer Data Read Register
  volatile uint32_t SMF;  ///< 0x228 [W]: Force StateMachine Register
  volatile uint32_t reserved3[53];
  volatile uint32_t Control;  ///< 0x300 [R/W]: Control register
  volatile uint32_t Coeff0;  ///< 0x304 [R/W]: Coefficient Row 0
  volatile uint32_t Coeff1;  ///< 0x308 [R/W]: Coefficient Row 1
  volatile uint32_t Coeff2;  ///< 0x30c [R/W]: Coefficient Row 2
  volatile uint32_t Coeff3;  ///< 0x310 [R/W]: Coefficient Row 3
  volatile uint32_t Coeff4;  ///< 0x314 [R/W]: Coefficient Row 4
  volatile uint32_t CompLUT;  ///< 0x318 [R/W]: Compression LUT (4 to 2 bit)
  volatile uint32_t reserved4;
  volatile uint32_t DecLUT;  ///< 0x320 [R/W]: Decompression LUT (2 to 4 bit)
  volatile uint32_t Status;  ///< 0x324 [R]: Status Register
  volatile uint32_t H1_Mux;  ///< 0x328 [R/W]: Hardware Channel 1 Muxing Register
  volatile uint32_t H2_Mux;  ///< 0x32c [R/W]: Hardware Channel 2 Muxing Register
  volatile uint32_t H3_Mux;  ///< 0x330 [R/W]: Hardware Channel 3 Muxing Register
  volatile uint32_t H4_Mux;  ///< 0x334 [R/W]: Hardware Channel 4 Muxing Register
  volatile uint32_t Save;  ///< 0x338 [R]: Save System Register
  volatile uint32_t Restore;  ///< 0x33c [W]: Restore System Register
} HTSTATS_REGS_t;

#endif // HTSTATS
