 /*
 **************************************************************************************
 *
 * (c) Copyright 2013 Marvell International Ltd.
 *
 *
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/.
 *
 **************************************************************************************
 *
 * \file HTStats_regmasks.h
 * Generated using RegBuild 1.6.3
 *
 **************************************************************************************
 */

#ifndef _HTSTATS_REGMASKS_H_
#define _HTSTATS_REGMASKS_H_

#ifndef __KERNEL__
#include <stdint.h>
#endif

//====================================================================
//
//Register File: HTStats (HTStats)
/** \brief (rev 0 . 1 . 1 . 0)
    Register descriptions for the HTSTATS block.*/
//
//====================================================================

//====================================================================
//Register: Configuration Register (CR)
/** \brief General configuration register for HTStats block.*/
//====================================================================

#define  HTSTATS_CR_TALLYMODE_MASK 0x80000000
#define  HTSTATS_CR_TALLYMODE_SHIFT 31
#define  HTSTATS_CR_TALLYMODE_MASK_SHIFT(reg) (((reg) & HTSTATS_CR_TALLYMODE_MASK) >> HTSTATS_CR_TALLYMODE_SHIFT)
#define  HTSTATS_CR_TALLYMODE_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_CR_TALLYMODE_MASK) | (((uint32_t)val) << HTSTATS_CR_TALLYMODE_SHIFT))

#define  HTSTATS_CR_RESERVED1_MASK 0x7fffff00
#define  HTSTATS_CR_RESERVED1_SHIFT 8
#define  HTSTATS_CR_RESERVED1_MASK_SHIFT(reg) (((reg) & HTSTATS_CR_RESERVED1_MASK) >> HTSTATS_CR_RESERVED1_SHIFT)
#define  HTSTATS_CR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_CR_RESERVED1_MASK) | (((uint32_t)val) << HTSTATS_CR_RESERVED1_SHIFT))

#define  HTSTATS_CR_AREALUTMODE_MASK 0xc0
#define  HTSTATS_CR_AREALUTMODE_SHIFT 6
#define  HTSTATS_CR_AREALUTMODE_MASK_SHIFT(reg) (((reg) & HTSTATS_CR_AREALUTMODE_MASK) >> HTSTATS_CR_AREALUTMODE_SHIFT)
#define  HTSTATS_CR_AREALUTMODE_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_CR_AREALUTMODE_MASK) | (((uint32_t)val) << HTSTATS_CR_AREALUTMODE_SHIFT))

#define  HTSTATS_CR_MODE_MASK 0x30
#define  HTSTATS_CR_MODE_SHIFT 4
#define  HTSTATS_CR_MODE_MASK_SHIFT(reg) (((reg) & HTSTATS_CR_MODE_MASK) >> HTSTATS_CR_MODE_SHIFT)
#define  HTSTATS_CR_MODE_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_CR_MODE_MASK) | (((uint32_t)val) << HTSTATS_CR_MODE_SHIFT))

#define  HTSTATS_CR_RESERVED2_MASK 0xc
#define  HTSTATS_CR_RESERVED2_SHIFT 2
#define  HTSTATS_CR_RESERVED2_MASK_SHIFT(reg) (((reg) & HTSTATS_CR_RESERVED2_MASK) >> HTSTATS_CR_RESERVED2_SHIFT)
#define  HTSTATS_CR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_CR_RESERVED2_MASK) | (((uint32_t)val) << HTSTATS_CR_RESERVED2_SHIFT))

#define  HTSTATS_CR_V2M_CPU_MASK 0x2
#define  HTSTATS_CR_V2M_CPU_SHIFT 1
#define  HTSTATS_CR_V2M_CPU_MASK_SHIFT(reg) (((reg) & HTSTATS_CR_V2M_CPU_MASK) >> HTSTATS_CR_V2M_CPU_SHIFT)
#define  HTSTATS_CR_V2M_CPU_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_CR_V2M_CPU_MASK) | (((uint32_t)val) << HTSTATS_CR_V2M_CPU_SHIFT))

#define  HTSTATS_CR_BYP_MASK 0x1
#define  HTSTATS_CR_BYP_SHIFT 0
#define  HTSTATS_CR_BYP_MASK_SHIFT(reg) (((reg) & HTSTATS_CR_BYP_MASK) >> HTSTATS_CR_BYP_SHIFT)
#define  HTSTATS_CR_BYP_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_CR_BYP_MASK) | (((uint32_t)val) << HTSTATS_CR_BYP_SHIFT))

//====================================================================
//Register: IP Tagging Revision 0 (REV0)
/** \brief Provide means for firmware to read IP tagging information.
      This register of particular interest to firmware.*/
//====================================================================

#define  HTSTATS_REV0_MAJ_MASK 0xffff0000
#define  HTSTATS_REV0_MAJ_SHIFT 16
#define  HTSTATS_REV0_MAJ_MASK_SHIFT(reg) (((reg) & HTSTATS_REV0_MAJ_MASK) >> HTSTATS_REV0_MAJ_SHIFT)
#define  HTSTATS_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_REV0_MAJ_MASK) | (((uint32_t)val) << HTSTATS_REV0_MAJ_SHIFT))

#define  HTSTATS_REV0_MID_MASK 0xffff
#define  HTSTATS_REV0_MID_SHIFT 0
#define  HTSTATS_REV0_MID_MASK_SHIFT(reg) (((reg) & HTSTATS_REV0_MID_MASK) >> HTSTATS_REV0_MID_SHIFT)
#define  HTSTATS_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_REV0_MID_MASK) | (((uint32_t)val) << HTSTATS_REV0_MID_SHIFT))

//====================================================================
//Register: IP Tagging Revision 1 (REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  HTSTATS_REV1_RESERVED1_MASK 0xffff0000
#define  HTSTATS_REV1_RESERVED1_SHIFT 16
#define  HTSTATS_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & HTSTATS_REV1_RESERVED1_MASK) >> HTSTATS_REV1_RESERVED1_SHIFT)
#define  HTSTATS_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_REV1_RESERVED1_MASK) | (((uint32_t)val) << HTSTATS_REV1_RESERVED1_SHIFT))

#define  HTSTATS_REV1_CFG_MASK 0xffff
#define  HTSTATS_REV1_CFG_SHIFT 0
#define  HTSTATS_REV1_CFG_MASK_SHIFT(reg) (((reg) & HTSTATS_REV1_CFG_MASK) >> HTSTATS_REV1_CFG_SHIFT)
#define  HTSTATS_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_REV1_CFG_MASK) | (((uint32_t)val) << HTSTATS_REV1_CFG_SHIFT))

//====================================================================
//Register: Channel 0: Isolated Pixel Magnitude Replacement (CH0_IsoMag)
//====================================================================

#define  HTSTATS_CH0_ISOMAG_RESERVED1_MASK 0xfffff000
#define  HTSTATS_CH0_ISOMAG_RESERVED1_SHIFT 12
#define  HTSTATS_CH0_ISOMAG_RESERVED1_MASK_SHIFT(reg) (((reg) & HTSTATS_CH0_ISOMAG_RESERVED1_MASK) >> HTSTATS_CH0_ISOMAG_RESERVED1_SHIFT)
#define  HTSTATS_CH0_ISOMAG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_CH0_ISOMAG_RESERVED1_MASK) | (((uint32_t)val) << HTSTATS_CH0_ISOMAG_RESERVED1_SHIFT))

#define  HTSTATS_CH0_ISOMAG_IP3_MASK 0xf00
#define  HTSTATS_CH0_ISOMAG_IP3_SHIFT 8
#define  HTSTATS_CH0_ISOMAG_IP3_MASK_SHIFT(reg) (((reg) & HTSTATS_CH0_ISOMAG_IP3_MASK) >> HTSTATS_CH0_ISOMAG_IP3_SHIFT)
#define  HTSTATS_CH0_ISOMAG_IP3_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_CH0_ISOMAG_IP3_MASK) | (((uint32_t)val) << HTSTATS_CH0_ISOMAG_IP3_SHIFT))

#define  HTSTATS_CH0_ISOMAG_IP2_MASK 0xf0
#define  HTSTATS_CH0_ISOMAG_IP2_SHIFT 4
#define  HTSTATS_CH0_ISOMAG_IP2_MASK_SHIFT(reg) (((reg) & HTSTATS_CH0_ISOMAG_IP2_MASK) >> HTSTATS_CH0_ISOMAG_IP2_SHIFT)
#define  HTSTATS_CH0_ISOMAG_IP2_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_CH0_ISOMAG_IP2_MASK) | (((uint32_t)val) << HTSTATS_CH0_ISOMAG_IP2_SHIFT))

#define  HTSTATS_CH0_ISOMAG_IP1_MASK 0xf
#define  HTSTATS_CH0_ISOMAG_IP1_SHIFT 0
#define  HTSTATS_CH0_ISOMAG_IP1_MASK_SHIFT(reg) (((reg) & HTSTATS_CH0_ISOMAG_IP1_MASK) >> HTSTATS_CH0_ISOMAG_IP1_SHIFT)
#define  HTSTATS_CH0_ISOMAG_IP1_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_CH0_ISOMAG_IP1_MASK) | (((uint32_t)val) << HTSTATS_CH0_ISOMAG_IP1_SHIFT))

//====================================================================
//Register: Channel 0: Accumulation (CH0_Accum)
//====================================================================

#define  HTSTATS_CH0_ACCUM_SUM_MASK 0xffffffff
#define  HTSTATS_CH0_ACCUM_SUM_SHIFT 0
#define  HTSTATS_CH0_ACCUM_SUM_MASK_SHIFT(reg) (((reg) & HTSTATS_CH0_ACCUM_SUM_MASK) >> HTSTATS_CH0_ACCUM_SUM_SHIFT)
#define  HTSTATS_CH0_ACCUM_SUM_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_CH0_ACCUM_SUM_MASK) | (((uint32_t)val) << HTSTATS_CH0_ACCUM_SUM_SHIFT))

//====================================================================
//Register: Channel 0: Surrounded Black Pixel Count (CH0_SBP)
//====================================================================

#define  HTSTATS_CH0_SBP_SUM_MASK 0xffffffff
#define  HTSTATS_CH0_SBP_SUM_SHIFT 0
#define  HTSTATS_CH0_SBP_SUM_MASK_SHIFT(reg) (((reg) & HTSTATS_CH0_SBP_SUM_MASK) >> HTSTATS_CH0_SBP_SUM_SHIFT)
#define  HTSTATS_CH0_SBP_SUM_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_CH0_SBP_SUM_MASK) | (((uint32_t)val) << HTSTATS_CH0_SBP_SUM_SHIFT))

//====================================================================
//Register: Channel 0: Isolated pixel with center pixel magnitude of 0 (CH0_IsoCnt0)
//====================================================================

#define  HTSTATS_CH0_ISOCNT0_SUM_MASK 0xffffffff
#define  HTSTATS_CH0_ISOCNT0_SUM_SHIFT 0
#define  HTSTATS_CH0_ISOCNT0_SUM_MASK_SHIFT(reg) (((reg) & HTSTATS_CH0_ISOCNT0_SUM_MASK) >> HTSTATS_CH0_ISOCNT0_SUM_SHIFT)
#define  HTSTATS_CH0_ISOCNT0_SUM_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_CH0_ISOCNT0_SUM_MASK) | (((uint32_t)val) << HTSTATS_CH0_ISOCNT0_SUM_SHIFT))

//====================================================================
//Register: Channel 0: Isolated pixel with center pixel magnitude of 1 or 3 (CH0_IsoCnt1)
//====================================================================

#define  HTSTATS_CH0_ISOCNT1_SUM_MASK 0xffffffff
#define  HTSTATS_CH0_ISOCNT1_SUM_SHIFT 0
#define  HTSTATS_CH0_ISOCNT1_SUM_MASK_SHIFT(reg) (((reg) & HTSTATS_CH0_ISOCNT1_SUM_MASK) >> HTSTATS_CH0_ISOCNT1_SUM_SHIFT)
#define  HTSTATS_CH0_ISOCNT1_SUM_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_CH0_ISOCNT1_SUM_MASK) | (((uint32_t)val) << HTSTATS_CH0_ISOCNT1_SUM_SHIFT))

//====================================================================
//Register: Channel 0: Isolated pixel with center pixel magnitude of 4 or 5 (CH0_IsoCnt2)
//====================================================================

#define  HTSTATS_CH0_ISOCNT2_SUM_MASK 0xffffffff
#define  HTSTATS_CH0_ISOCNT2_SUM_SHIFT 0
#define  HTSTATS_CH0_ISOCNT2_SUM_MASK_SHIFT(reg) (((reg) & HTSTATS_CH0_ISOCNT2_SUM_MASK) >> HTSTATS_CH0_ISOCNT2_SUM_SHIFT)
#define  HTSTATS_CH0_ISOCNT2_SUM_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_CH0_ISOCNT2_SUM_MASK) | (((uint32_t)val) << HTSTATS_CH0_ISOCNT2_SUM_SHIFT))

//====================================================================
//Register: Channel 0: Isolated pixel with center pixel magnitude of 6 or 7 (CH0_IsoCnt3)
//====================================================================

#define  HTSTATS_CH0_ISOCNT3_SUM_MASK 0xffffffff
#define  HTSTATS_CH0_ISOCNT3_SUM_SHIFT 0
#define  HTSTATS_CH0_ISOCNT3_SUM_MASK_SHIFT(reg) (((reg) & HTSTATS_CH0_ISOCNT3_SUM_MASK) >> HTSTATS_CH0_ISOCNT3_SUM_SHIFT)
#define  HTSTATS_CH0_ISOCNT3_SUM_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_CH0_ISOCNT3_SUM_MASK) | (((uint32_t)val) << HTSTATS_CH0_ISOCNT3_SUM_SHIFT))

//====================================================================
//Register: Channel 0: Counter Reset (CH0_CntRst)
//====================================================================

#define  HTSTATS_CH0_CNTRST_RESERVED1_MASK 0xffffffc0
#define  HTSTATS_CH0_CNTRST_RESERVED1_SHIFT 6
#define  HTSTATS_CH0_CNTRST_RESERVED1_MASK_SHIFT(reg) (((reg) & HTSTATS_CH0_CNTRST_RESERVED1_MASK) >> HTSTATS_CH0_CNTRST_RESERVED1_SHIFT)
#define  HTSTATS_CH0_CNTRST_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_CH0_CNTRST_RESERVED1_MASK) | (((uint32_t)val) << HTSTATS_CH0_CNTRST_RESERVED1_SHIFT))

#define  HTSTATS_CH0_CNTRST_SBP_MASK 0x20
#define  HTSTATS_CH0_CNTRST_SBP_SHIFT 5
#define  HTSTATS_CH0_CNTRST_SBP_MASK_SHIFT(reg) (((reg) & HTSTATS_CH0_CNTRST_SBP_MASK) >> HTSTATS_CH0_CNTRST_SBP_SHIFT)
#define  HTSTATS_CH0_CNTRST_SBP_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_CH0_CNTRST_SBP_MASK) | (((uint32_t)val) << HTSTATS_CH0_CNTRST_SBP_SHIFT))

#define  HTSTATS_CH0_CNTRST_ISOCNT3_MASK 0x10
#define  HTSTATS_CH0_CNTRST_ISOCNT3_SHIFT 4
#define  HTSTATS_CH0_CNTRST_ISOCNT3_MASK_SHIFT(reg) (((reg) & HTSTATS_CH0_CNTRST_ISOCNT3_MASK) >> HTSTATS_CH0_CNTRST_ISOCNT3_SHIFT)
#define  HTSTATS_CH0_CNTRST_ISOCNT3_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_CH0_CNTRST_ISOCNT3_MASK) | (((uint32_t)val) << HTSTATS_CH0_CNTRST_ISOCNT3_SHIFT))

#define  HTSTATS_CH0_CNTRST_ISOCNT2_MASK 0x8
#define  HTSTATS_CH0_CNTRST_ISOCNT2_SHIFT 3
#define  HTSTATS_CH0_CNTRST_ISOCNT2_MASK_SHIFT(reg) (((reg) & HTSTATS_CH0_CNTRST_ISOCNT2_MASK) >> HTSTATS_CH0_CNTRST_ISOCNT2_SHIFT)
#define  HTSTATS_CH0_CNTRST_ISOCNT2_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_CH0_CNTRST_ISOCNT2_MASK) | (((uint32_t)val) << HTSTATS_CH0_CNTRST_ISOCNT2_SHIFT))

#define  HTSTATS_CH0_CNTRST_ISOCNT1_MASK 0x4
#define  HTSTATS_CH0_CNTRST_ISOCNT1_SHIFT 2
#define  HTSTATS_CH0_CNTRST_ISOCNT1_MASK_SHIFT(reg) (((reg) & HTSTATS_CH0_CNTRST_ISOCNT1_MASK) >> HTSTATS_CH0_CNTRST_ISOCNT1_SHIFT)
#define  HTSTATS_CH0_CNTRST_ISOCNT1_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_CH0_CNTRST_ISOCNT1_MASK) | (((uint32_t)val) << HTSTATS_CH0_CNTRST_ISOCNT1_SHIFT))

#define  HTSTATS_CH0_CNTRST_ISOCNT0_MASK 0x2
#define  HTSTATS_CH0_CNTRST_ISOCNT0_SHIFT 1
#define  HTSTATS_CH0_CNTRST_ISOCNT0_MASK_SHIFT(reg) (((reg) & HTSTATS_CH0_CNTRST_ISOCNT0_MASK) >> HTSTATS_CH0_CNTRST_ISOCNT0_SHIFT)
#define  HTSTATS_CH0_CNTRST_ISOCNT0_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_CH0_CNTRST_ISOCNT0_MASK) | (((uint32_t)val) << HTSTATS_CH0_CNTRST_ISOCNT0_SHIFT))

#define  HTSTATS_CH0_CNTRST_ACCUM_MASK 0x1
#define  HTSTATS_CH0_CNTRST_ACCUM_SHIFT 0
#define  HTSTATS_CH0_CNTRST_ACCUM_MASK_SHIFT(reg) (((reg) & HTSTATS_CH0_CNTRST_ACCUM_MASK) >> HTSTATS_CH0_CNTRST_ACCUM_SHIFT)
#define  HTSTATS_CH0_CNTRST_ACCUM_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_CH0_CNTRST_ACCUM_MASK) | (((uint32_t)val) << HTSTATS_CH0_CNTRST_ACCUM_SHIFT))

//====================================================================
//Register: Channel 1: Isolated Pixel Magnitude Replacement (CH1_IsoMag)
//====================================================================

#define  HTSTATS_CH1_ISOMAG_RESERVED1_MASK 0xfffff000
#define  HTSTATS_CH1_ISOMAG_RESERVED1_SHIFT 12
#define  HTSTATS_CH1_ISOMAG_RESERVED1_MASK_SHIFT(reg) (((reg) & HTSTATS_CH1_ISOMAG_RESERVED1_MASK) >> HTSTATS_CH1_ISOMAG_RESERVED1_SHIFT)
#define  HTSTATS_CH1_ISOMAG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_CH1_ISOMAG_RESERVED1_MASK) | (((uint32_t)val) << HTSTATS_CH1_ISOMAG_RESERVED1_SHIFT))

#define  HTSTATS_CH1_ISOMAG_IP3_MASK 0xf00
#define  HTSTATS_CH1_ISOMAG_IP3_SHIFT 8
#define  HTSTATS_CH1_ISOMAG_IP3_MASK_SHIFT(reg) (((reg) & HTSTATS_CH1_ISOMAG_IP3_MASK) >> HTSTATS_CH1_ISOMAG_IP3_SHIFT)
#define  HTSTATS_CH1_ISOMAG_IP3_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_CH1_ISOMAG_IP3_MASK) | (((uint32_t)val) << HTSTATS_CH1_ISOMAG_IP3_SHIFT))

#define  HTSTATS_CH1_ISOMAG_IP2_MASK 0xf0
#define  HTSTATS_CH1_ISOMAG_IP2_SHIFT 4
#define  HTSTATS_CH1_ISOMAG_IP2_MASK_SHIFT(reg) (((reg) & HTSTATS_CH1_ISOMAG_IP2_MASK) >> HTSTATS_CH1_ISOMAG_IP2_SHIFT)
#define  HTSTATS_CH1_ISOMAG_IP2_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_CH1_ISOMAG_IP2_MASK) | (((uint32_t)val) << HTSTATS_CH1_ISOMAG_IP2_SHIFT))

#define  HTSTATS_CH1_ISOMAG_IP1_MASK 0xf
#define  HTSTATS_CH1_ISOMAG_IP1_SHIFT 0
#define  HTSTATS_CH1_ISOMAG_IP1_MASK_SHIFT(reg) (((reg) & HTSTATS_CH1_ISOMAG_IP1_MASK) >> HTSTATS_CH1_ISOMAG_IP1_SHIFT)
#define  HTSTATS_CH1_ISOMAG_IP1_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_CH1_ISOMAG_IP1_MASK) | (((uint32_t)val) << HTSTATS_CH1_ISOMAG_IP1_SHIFT))

//====================================================================
//Register: Channel 1: Accumulation (CH1_Accum)
//====================================================================

#define  HTSTATS_CH1_ACCUM_SUM_MASK 0xffffffff
#define  HTSTATS_CH1_ACCUM_SUM_SHIFT 0
#define  HTSTATS_CH1_ACCUM_SUM_MASK_SHIFT(reg) (((reg) & HTSTATS_CH1_ACCUM_SUM_MASK) >> HTSTATS_CH1_ACCUM_SUM_SHIFT)
#define  HTSTATS_CH1_ACCUM_SUM_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_CH1_ACCUM_SUM_MASK) | (((uint32_t)val) << HTSTATS_CH1_ACCUM_SUM_SHIFT))

//====================================================================
//Register: Channel 1: Surrounded Black Pixel Count (CH1_SBP)
//====================================================================

#define  HTSTATS_CH1_SBP_SUM_MASK 0xffffffff
#define  HTSTATS_CH1_SBP_SUM_SHIFT 0
#define  HTSTATS_CH1_SBP_SUM_MASK_SHIFT(reg) (((reg) & HTSTATS_CH1_SBP_SUM_MASK) >> HTSTATS_CH1_SBP_SUM_SHIFT)
#define  HTSTATS_CH1_SBP_SUM_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_CH1_SBP_SUM_MASK) | (((uint32_t)val) << HTSTATS_CH1_SBP_SUM_SHIFT))

//====================================================================
//Register: Channel 1: Isolated pixel with center pixel magnitude of 0 (CH1_IsoCnt0)
//====================================================================

#define  HTSTATS_CH1_ISOCNT0_SUM_MASK 0xffffffff
#define  HTSTATS_CH1_ISOCNT0_SUM_SHIFT 0
#define  HTSTATS_CH1_ISOCNT0_SUM_MASK_SHIFT(reg) (((reg) & HTSTATS_CH1_ISOCNT0_SUM_MASK) >> HTSTATS_CH1_ISOCNT0_SUM_SHIFT)
#define  HTSTATS_CH1_ISOCNT0_SUM_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_CH1_ISOCNT0_SUM_MASK) | (((uint32_t)val) << HTSTATS_CH1_ISOCNT0_SUM_SHIFT))

//====================================================================
//Register: Channel 1: Isolated pixel with center pixel magnitude of 1 or 3 (CH1_IsoCnt1)
//====================================================================

#define  HTSTATS_CH1_ISOCNT1_SUM_MASK 0xffffffff
#define  HTSTATS_CH1_ISOCNT1_SUM_SHIFT 0
#define  HTSTATS_CH1_ISOCNT1_SUM_MASK_SHIFT(reg) (((reg) & HTSTATS_CH1_ISOCNT1_SUM_MASK) >> HTSTATS_CH1_ISOCNT1_SUM_SHIFT)
#define  HTSTATS_CH1_ISOCNT1_SUM_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_CH1_ISOCNT1_SUM_MASK) | (((uint32_t)val) << HTSTATS_CH1_ISOCNT1_SUM_SHIFT))

//====================================================================
//Register: Channel 1: Isolated pixel with center pixel magnitude of 4 or 5 (CH1_IsoCnt2)
//====================================================================

#define  HTSTATS_CH1_ISOCNT2_SUM_MASK 0xffffffff
#define  HTSTATS_CH1_ISOCNT2_SUM_SHIFT 0
#define  HTSTATS_CH1_ISOCNT2_SUM_MASK_SHIFT(reg) (((reg) & HTSTATS_CH1_ISOCNT2_SUM_MASK) >> HTSTATS_CH1_ISOCNT2_SUM_SHIFT)
#define  HTSTATS_CH1_ISOCNT2_SUM_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_CH1_ISOCNT2_SUM_MASK) | (((uint32_t)val) << HTSTATS_CH1_ISOCNT2_SUM_SHIFT))

//====================================================================
//Register: Channel 1: Isolated pixel with center pixel magnitude of 6 or 7 (CH1_IsoCnt3)
//====================================================================

#define  HTSTATS_CH1_ISOCNT3_SUM_MASK 0xffffffff
#define  HTSTATS_CH1_ISOCNT3_SUM_SHIFT 0
#define  HTSTATS_CH1_ISOCNT3_SUM_MASK_SHIFT(reg) (((reg) & HTSTATS_CH1_ISOCNT3_SUM_MASK) >> HTSTATS_CH1_ISOCNT3_SUM_SHIFT)
#define  HTSTATS_CH1_ISOCNT3_SUM_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_CH1_ISOCNT3_SUM_MASK) | (((uint32_t)val) << HTSTATS_CH1_ISOCNT3_SUM_SHIFT))

//====================================================================
//Register: Channel 1: Counter Reset (CH1_CntRst)
//====================================================================

#define  HTSTATS_CH1_CNTRST_RESERVED1_MASK 0xffffffc0
#define  HTSTATS_CH1_CNTRST_RESERVED1_SHIFT 6
#define  HTSTATS_CH1_CNTRST_RESERVED1_MASK_SHIFT(reg) (((reg) & HTSTATS_CH1_CNTRST_RESERVED1_MASK) >> HTSTATS_CH1_CNTRST_RESERVED1_SHIFT)
#define  HTSTATS_CH1_CNTRST_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_CH1_CNTRST_RESERVED1_MASK) | (((uint32_t)val) << HTSTATS_CH1_CNTRST_RESERVED1_SHIFT))

#define  HTSTATS_CH1_CNTRST_SBP_MASK 0x20
#define  HTSTATS_CH1_CNTRST_SBP_SHIFT 5
#define  HTSTATS_CH1_CNTRST_SBP_MASK_SHIFT(reg) (((reg) & HTSTATS_CH1_CNTRST_SBP_MASK) >> HTSTATS_CH1_CNTRST_SBP_SHIFT)
#define  HTSTATS_CH1_CNTRST_SBP_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_CH1_CNTRST_SBP_MASK) | (((uint32_t)val) << HTSTATS_CH1_CNTRST_SBP_SHIFT))

#define  HTSTATS_CH1_CNTRST_ISOCNT3_MASK 0x10
#define  HTSTATS_CH1_CNTRST_ISOCNT3_SHIFT 4
#define  HTSTATS_CH1_CNTRST_ISOCNT3_MASK_SHIFT(reg) (((reg) & HTSTATS_CH1_CNTRST_ISOCNT3_MASK) >> HTSTATS_CH1_CNTRST_ISOCNT3_SHIFT)
#define  HTSTATS_CH1_CNTRST_ISOCNT3_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_CH1_CNTRST_ISOCNT3_MASK) | (((uint32_t)val) << HTSTATS_CH1_CNTRST_ISOCNT3_SHIFT))

#define  HTSTATS_CH1_CNTRST_ISOCNT2_MASK 0x8
#define  HTSTATS_CH1_CNTRST_ISOCNT2_SHIFT 3
#define  HTSTATS_CH1_CNTRST_ISOCNT2_MASK_SHIFT(reg) (((reg) & HTSTATS_CH1_CNTRST_ISOCNT2_MASK) >> HTSTATS_CH1_CNTRST_ISOCNT2_SHIFT)
#define  HTSTATS_CH1_CNTRST_ISOCNT2_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_CH1_CNTRST_ISOCNT2_MASK) | (((uint32_t)val) << HTSTATS_CH1_CNTRST_ISOCNT2_SHIFT))

#define  HTSTATS_CH1_CNTRST_ISOCNT1_MASK 0x4
#define  HTSTATS_CH1_CNTRST_ISOCNT1_SHIFT 2
#define  HTSTATS_CH1_CNTRST_ISOCNT1_MASK_SHIFT(reg) (((reg) & HTSTATS_CH1_CNTRST_ISOCNT1_MASK) >> HTSTATS_CH1_CNTRST_ISOCNT1_SHIFT)
#define  HTSTATS_CH1_CNTRST_ISOCNT1_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_CH1_CNTRST_ISOCNT1_MASK) | (((uint32_t)val) << HTSTATS_CH1_CNTRST_ISOCNT1_SHIFT))

#define  HTSTATS_CH1_CNTRST_ISOCNT0_MASK 0x2
#define  HTSTATS_CH1_CNTRST_ISOCNT0_SHIFT 1
#define  HTSTATS_CH1_CNTRST_ISOCNT0_MASK_SHIFT(reg) (((reg) & HTSTATS_CH1_CNTRST_ISOCNT0_MASK) >> HTSTATS_CH1_CNTRST_ISOCNT0_SHIFT)
#define  HTSTATS_CH1_CNTRST_ISOCNT0_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_CH1_CNTRST_ISOCNT0_MASK) | (((uint32_t)val) << HTSTATS_CH1_CNTRST_ISOCNT0_SHIFT))

#define  HTSTATS_CH1_CNTRST_ACCUM_MASK 0x1
#define  HTSTATS_CH1_CNTRST_ACCUM_SHIFT 0
#define  HTSTATS_CH1_CNTRST_ACCUM_MASK_SHIFT(reg) (((reg) & HTSTATS_CH1_CNTRST_ACCUM_MASK) >> HTSTATS_CH1_CNTRST_ACCUM_SHIFT)
#define  HTSTATS_CH1_CNTRST_ACCUM_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_CH1_CNTRST_ACCUM_MASK) | (((uint32_t)val) << HTSTATS_CH1_CNTRST_ACCUM_SHIFT))

//====================================================================
//Register: Channel 2: Isolated Pixel Magnitude Replacement (CH2_IsoMag)
//====================================================================

#define  HTSTATS_CH2_ISOMAG_RESERVED1_MASK 0xfffff000
#define  HTSTATS_CH2_ISOMAG_RESERVED1_SHIFT 12
#define  HTSTATS_CH2_ISOMAG_RESERVED1_MASK_SHIFT(reg) (((reg) & HTSTATS_CH2_ISOMAG_RESERVED1_MASK) >> HTSTATS_CH2_ISOMAG_RESERVED1_SHIFT)
#define  HTSTATS_CH2_ISOMAG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_CH2_ISOMAG_RESERVED1_MASK) | (((uint32_t)val) << HTSTATS_CH2_ISOMAG_RESERVED1_SHIFT))

#define  HTSTATS_CH2_ISOMAG_IP3_MASK 0xf00
#define  HTSTATS_CH2_ISOMAG_IP3_SHIFT 8
#define  HTSTATS_CH2_ISOMAG_IP3_MASK_SHIFT(reg) (((reg) & HTSTATS_CH2_ISOMAG_IP3_MASK) >> HTSTATS_CH2_ISOMAG_IP3_SHIFT)
#define  HTSTATS_CH2_ISOMAG_IP3_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_CH2_ISOMAG_IP3_MASK) | (((uint32_t)val) << HTSTATS_CH2_ISOMAG_IP3_SHIFT))

#define  HTSTATS_CH2_ISOMAG_IP2_MASK 0xf0
#define  HTSTATS_CH2_ISOMAG_IP2_SHIFT 4
#define  HTSTATS_CH2_ISOMAG_IP2_MASK_SHIFT(reg) (((reg) & HTSTATS_CH2_ISOMAG_IP2_MASK) >> HTSTATS_CH2_ISOMAG_IP2_SHIFT)
#define  HTSTATS_CH2_ISOMAG_IP2_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_CH2_ISOMAG_IP2_MASK) | (((uint32_t)val) << HTSTATS_CH2_ISOMAG_IP2_SHIFT))

#define  HTSTATS_CH2_ISOMAG_IP1_MASK 0xf
#define  HTSTATS_CH2_ISOMAG_IP1_SHIFT 0
#define  HTSTATS_CH2_ISOMAG_IP1_MASK_SHIFT(reg) (((reg) & HTSTATS_CH2_ISOMAG_IP1_MASK) >> HTSTATS_CH2_ISOMAG_IP1_SHIFT)
#define  HTSTATS_CH2_ISOMAG_IP1_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_CH2_ISOMAG_IP1_MASK) | (((uint32_t)val) << HTSTATS_CH2_ISOMAG_IP1_SHIFT))

//====================================================================
//Register: Channel 2: Accumulation (CH2_Accum)
//====================================================================

#define  HTSTATS_CH2_ACCUM_SUM_MASK 0xffffffff
#define  HTSTATS_CH2_ACCUM_SUM_SHIFT 0
#define  HTSTATS_CH2_ACCUM_SUM_MASK_SHIFT(reg) (((reg) & HTSTATS_CH2_ACCUM_SUM_MASK) >> HTSTATS_CH2_ACCUM_SUM_SHIFT)
#define  HTSTATS_CH2_ACCUM_SUM_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_CH2_ACCUM_SUM_MASK) | (((uint32_t)val) << HTSTATS_CH2_ACCUM_SUM_SHIFT))

//====================================================================
//Register: Channel 2: Surrounded Black Pixel Count (CH2_SBP)
//====================================================================

#define  HTSTATS_CH2_SBP_SUM_MASK 0xffffffff
#define  HTSTATS_CH2_SBP_SUM_SHIFT 0
#define  HTSTATS_CH2_SBP_SUM_MASK_SHIFT(reg) (((reg) & HTSTATS_CH2_SBP_SUM_MASK) >> HTSTATS_CH2_SBP_SUM_SHIFT)
#define  HTSTATS_CH2_SBP_SUM_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_CH2_SBP_SUM_MASK) | (((uint32_t)val) << HTSTATS_CH2_SBP_SUM_SHIFT))

//====================================================================
//Register: Channel 2: Isolated pixel with center pixel magnitude of 0 (CH2_IsoCnt0)
//====================================================================

#define  HTSTATS_CH2_ISOCNT0_SUM_MASK 0xffffffff
#define  HTSTATS_CH2_ISOCNT0_SUM_SHIFT 0
#define  HTSTATS_CH2_ISOCNT0_SUM_MASK_SHIFT(reg) (((reg) & HTSTATS_CH2_ISOCNT0_SUM_MASK) >> HTSTATS_CH2_ISOCNT0_SUM_SHIFT)
#define  HTSTATS_CH2_ISOCNT0_SUM_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_CH2_ISOCNT0_SUM_MASK) | (((uint32_t)val) << HTSTATS_CH2_ISOCNT0_SUM_SHIFT))

//====================================================================
//Register: Channel 2: Isolated pixel with center pixel magnitude of 1 or 3 (CH2_IsoCnt1)
//====================================================================

#define  HTSTATS_CH2_ISOCNT1_SUM_MASK 0xffffffff
#define  HTSTATS_CH2_ISOCNT1_SUM_SHIFT 0
#define  HTSTATS_CH2_ISOCNT1_SUM_MASK_SHIFT(reg) (((reg) & HTSTATS_CH2_ISOCNT1_SUM_MASK) >> HTSTATS_CH2_ISOCNT1_SUM_SHIFT)
#define  HTSTATS_CH2_ISOCNT1_SUM_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_CH2_ISOCNT1_SUM_MASK) | (((uint32_t)val) << HTSTATS_CH2_ISOCNT1_SUM_SHIFT))

//====================================================================
//Register: Channel 2: Isolated pixel with center pixel magnitude of 4 or 5 (CH2_IsoCnt2)
//====================================================================

#define  HTSTATS_CH2_ISOCNT2_SUM_MASK 0xffffffff
#define  HTSTATS_CH2_ISOCNT2_SUM_SHIFT 0
#define  HTSTATS_CH2_ISOCNT2_SUM_MASK_SHIFT(reg) (((reg) & HTSTATS_CH2_ISOCNT2_SUM_MASK) >> HTSTATS_CH2_ISOCNT2_SUM_SHIFT)
#define  HTSTATS_CH2_ISOCNT2_SUM_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_CH2_ISOCNT2_SUM_MASK) | (((uint32_t)val) << HTSTATS_CH2_ISOCNT2_SUM_SHIFT))

//====================================================================
//Register: Channel 2: Isolated pixel with center pixel magnitude of 6 or 7 (CH2_IsoCnt3)
//====================================================================

#define  HTSTATS_CH2_ISOCNT3_SUM_MASK 0xffffffff
#define  HTSTATS_CH2_ISOCNT3_SUM_SHIFT 0
#define  HTSTATS_CH2_ISOCNT3_SUM_MASK_SHIFT(reg) (((reg) & HTSTATS_CH2_ISOCNT3_SUM_MASK) >> HTSTATS_CH2_ISOCNT3_SUM_SHIFT)
#define  HTSTATS_CH2_ISOCNT3_SUM_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_CH2_ISOCNT3_SUM_MASK) | (((uint32_t)val) << HTSTATS_CH2_ISOCNT3_SUM_SHIFT))

//====================================================================
//Register: Channel 2: Counter Reset (CH2_CntRst)
//====================================================================

#define  HTSTATS_CH2_CNTRST_RESERVED1_MASK 0xffffffc0
#define  HTSTATS_CH2_CNTRST_RESERVED1_SHIFT 6
#define  HTSTATS_CH2_CNTRST_RESERVED1_MASK_SHIFT(reg) (((reg) & HTSTATS_CH2_CNTRST_RESERVED1_MASK) >> HTSTATS_CH2_CNTRST_RESERVED1_SHIFT)
#define  HTSTATS_CH2_CNTRST_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_CH2_CNTRST_RESERVED1_MASK) | (((uint32_t)val) << HTSTATS_CH2_CNTRST_RESERVED1_SHIFT))

#define  HTSTATS_CH2_CNTRST_SBP_MASK 0x20
#define  HTSTATS_CH2_CNTRST_SBP_SHIFT 5
#define  HTSTATS_CH2_CNTRST_SBP_MASK_SHIFT(reg) (((reg) & HTSTATS_CH2_CNTRST_SBP_MASK) >> HTSTATS_CH2_CNTRST_SBP_SHIFT)
#define  HTSTATS_CH2_CNTRST_SBP_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_CH2_CNTRST_SBP_MASK) | (((uint32_t)val) << HTSTATS_CH2_CNTRST_SBP_SHIFT))

#define  HTSTATS_CH2_CNTRST_ISOCNT3_MASK 0x10
#define  HTSTATS_CH2_CNTRST_ISOCNT3_SHIFT 4
#define  HTSTATS_CH2_CNTRST_ISOCNT3_MASK_SHIFT(reg) (((reg) & HTSTATS_CH2_CNTRST_ISOCNT3_MASK) >> HTSTATS_CH2_CNTRST_ISOCNT3_SHIFT)
#define  HTSTATS_CH2_CNTRST_ISOCNT3_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_CH2_CNTRST_ISOCNT3_MASK) | (((uint32_t)val) << HTSTATS_CH2_CNTRST_ISOCNT3_SHIFT))

#define  HTSTATS_CH2_CNTRST_ISOCNT2_MASK 0x8
#define  HTSTATS_CH2_CNTRST_ISOCNT2_SHIFT 3
#define  HTSTATS_CH2_CNTRST_ISOCNT2_MASK_SHIFT(reg) (((reg) & HTSTATS_CH2_CNTRST_ISOCNT2_MASK) >> HTSTATS_CH2_CNTRST_ISOCNT2_SHIFT)
#define  HTSTATS_CH2_CNTRST_ISOCNT2_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_CH2_CNTRST_ISOCNT2_MASK) | (((uint32_t)val) << HTSTATS_CH2_CNTRST_ISOCNT2_SHIFT))

#define  HTSTATS_CH2_CNTRST_ISOCNT1_MASK 0x4
#define  HTSTATS_CH2_CNTRST_ISOCNT1_SHIFT 2
#define  HTSTATS_CH2_CNTRST_ISOCNT1_MASK_SHIFT(reg) (((reg) & HTSTATS_CH2_CNTRST_ISOCNT1_MASK) >> HTSTATS_CH2_CNTRST_ISOCNT1_SHIFT)
#define  HTSTATS_CH2_CNTRST_ISOCNT1_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_CH2_CNTRST_ISOCNT1_MASK) | (((uint32_t)val) << HTSTATS_CH2_CNTRST_ISOCNT1_SHIFT))

#define  HTSTATS_CH2_CNTRST_ISOCNT0_MASK 0x2
#define  HTSTATS_CH2_CNTRST_ISOCNT0_SHIFT 1
#define  HTSTATS_CH2_CNTRST_ISOCNT0_MASK_SHIFT(reg) (((reg) & HTSTATS_CH2_CNTRST_ISOCNT0_MASK) >> HTSTATS_CH2_CNTRST_ISOCNT0_SHIFT)
#define  HTSTATS_CH2_CNTRST_ISOCNT0_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_CH2_CNTRST_ISOCNT0_MASK) | (((uint32_t)val) << HTSTATS_CH2_CNTRST_ISOCNT0_SHIFT))

#define  HTSTATS_CH2_CNTRST_ACCUM_MASK 0x1
#define  HTSTATS_CH2_CNTRST_ACCUM_SHIFT 0
#define  HTSTATS_CH2_CNTRST_ACCUM_MASK_SHIFT(reg) (((reg) & HTSTATS_CH2_CNTRST_ACCUM_MASK) >> HTSTATS_CH2_CNTRST_ACCUM_SHIFT)
#define  HTSTATS_CH2_CNTRST_ACCUM_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_CH2_CNTRST_ACCUM_MASK) | (((uint32_t)val) << HTSTATS_CH2_CNTRST_ACCUM_SHIFT))

//====================================================================
//Register: Channel 3: Isolated Pixel Magnitude Replacement (CH3_IsoMag)
//====================================================================

#define  HTSTATS_CH3_ISOMAG_RESERVED1_MASK 0xfffff000
#define  HTSTATS_CH3_ISOMAG_RESERVED1_SHIFT 12
#define  HTSTATS_CH3_ISOMAG_RESERVED1_MASK_SHIFT(reg) (((reg) & HTSTATS_CH3_ISOMAG_RESERVED1_MASK) >> HTSTATS_CH3_ISOMAG_RESERVED1_SHIFT)
#define  HTSTATS_CH3_ISOMAG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_CH3_ISOMAG_RESERVED1_MASK) | (((uint32_t)val) << HTSTATS_CH3_ISOMAG_RESERVED1_SHIFT))

#define  HTSTATS_CH3_ISOMAG_IP3_MASK 0xf00
#define  HTSTATS_CH3_ISOMAG_IP3_SHIFT 8
#define  HTSTATS_CH3_ISOMAG_IP3_MASK_SHIFT(reg) (((reg) & HTSTATS_CH3_ISOMAG_IP3_MASK) >> HTSTATS_CH3_ISOMAG_IP3_SHIFT)
#define  HTSTATS_CH3_ISOMAG_IP3_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_CH3_ISOMAG_IP3_MASK) | (((uint32_t)val) << HTSTATS_CH3_ISOMAG_IP3_SHIFT))

#define  HTSTATS_CH3_ISOMAG_IP2_MASK 0xf0
#define  HTSTATS_CH3_ISOMAG_IP2_SHIFT 4
#define  HTSTATS_CH3_ISOMAG_IP2_MASK_SHIFT(reg) (((reg) & HTSTATS_CH3_ISOMAG_IP2_MASK) >> HTSTATS_CH3_ISOMAG_IP2_SHIFT)
#define  HTSTATS_CH3_ISOMAG_IP2_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_CH3_ISOMAG_IP2_MASK) | (((uint32_t)val) << HTSTATS_CH3_ISOMAG_IP2_SHIFT))

#define  HTSTATS_CH3_ISOMAG_IP1_MASK 0xf
#define  HTSTATS_CH3_ISOMAG_IP1_SHIFT 0
#define  HTSTATS_CH3_ISOMAG_IP1_MASK_SHIFT(reg) (((reg) & HTSTATS_CH3_ISOMAG_IP1_MASK) >> HTSTATS_CH3_ISOMAG_IP1_SHIFT)
#define  HTSTATS_CH3_ISOMAG_IP1_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_CH3_ISOMAG_IP1_MASK) | (((uint32_t)val) << HTSTATS_CH3_ISOMAG_IP1_SHIFT))

//====================================================================
//Register: Channel 3: Accumulation (CH3_Accum)
//====================================================================

#define  HTSTATS_CH3_ACCUM_SUM_MASK 0xffffffff
#define  HTSTATS_CH3_ACCUM_SUM_SHIFT 0
#define  HTSTATS_CH3_ACCUM_SUM_MASK_SHIFT(reg) (((reg) & HTSTATS_CH3_ACCUM_SUM_MASK) >> HTSTATS_CH3_ACCUM_SUM_SHIFT)
#define  HTSTATS_CH3_ACCUM_SUM_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_CH3_ACCUM_SUM_MASK) | (((uint32_t)val) << HTSTATS_CH3_ACCUM_SUM_SHIFT))

//====================================================================
//Register: Channel 3: Surrounded Black Pixel Count (CH3_SBP)
//====================================================================

#define  HTSTATS_CH3_SBP_SUM_MASK 0xffffffff
#define  HTSTATS_CH3_SBP_SUM_SHIFT 0
#define  HTSTATS_CH3_SBP_SUM_MASK_SHIFT(reg) (((reg) & HTSTATS_CH3_SBP_SUM_MASK) >> HTSTATS_CH3_SBP_SUM_SHIFT)
#define  HTSTATS_CH3_SBP_SUM_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_CH3_SBP_SUM_MASK) | (((uint32_t)val) << HTSTATS_CH3_SBP_SUM_SHIFT))

//====================================================================
//Register: Channel 3: Isolated pixel with center pixel magnitude of 0 (CH3_IsoCnt0)
//====================================================================

#define  HTSTATS_CH3_ISOCNT0_SUM_MASK 0xffffffff
#define  HTSTATS_CH3_ISOCNT0_SUM_SHIFT 0
#define  HTSTATS_CH3_ISOCNT0_SUM_MASK_SHIFT(reg) (((reg) & HTSTATS_CH3_ISOCNT0_SUM_MASK) >> HTSTATS_CH3_ISOCNT0_SUM_SHIFT)
#define  HTSTATS_CH3_ISOCNT0_SUM_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_CH3_ISOCNT0_SUM_MASK) | (((uint32_t)val) << HTSTATS_CH3_ISOCNT0_SUM_SHIFT))

//====================================================================
//Register: Channel 3: Isolated pixel with center pixel magnitude of 1 or 3 (CH3_IsoCnt1)
//====================================================================

#define  HTSTATS_CH3_ISOCNT1_SUM_MASK 0xffffffff
#define  HTSTATS_CH3_ISOCNT1_SUM_SHIFT 0
#define  HTSTATS_CH3_ISOCNT1_SUM_MASK_SHIFT(reg) (((reg) & HTSTATS_CH3_ISOCNT1_SUM_MASK) >> HTSTATS_CH3_ISOCNT1_SUM_SHIFT)
#define  HTSTATS_CH3_ISOCNT1_SUM_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_CH3_ISOCNT1_SUM_MASK) | (((uint32_t)val) << HTSTATS_CH3_ISOCNT1_SUM_SHIFT))

//====================================================================
//Register: Channel 3: Isolated pixel with center pixel magnitude of 4 or 5 (CH3_IsoCnt2)
//====================================================================

#define  HTSTATS_CH3_ISOCNT2_SUM_MASK 0xffffffff
#define  HTSTATS_CH3_ISOCNT2_SUM_SHIFT 0
#define  HTSTATS_CH3_ISOCNT2_SUM_MASK_SHIFT(reg) (((reg) & HTSTATS_CH3_ISOCNT2_SUM_MASK) >> HTSTATS_CH3_ISOCNT2_SUM_SHIFT)
#define  HTSTATS_CH3_ISOCNT2_SUM_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_CH3_ISOCNT2_SUM_MASK) | (((uint32_t)val) << HTSTATS_CH3_ISOCNT2_SUM_SHIFT))

//====================================================================
//Register: Channel 3: Isolated pixel with center pixel magnitude of 6 or 7 (CH3_IsoCnt3)
//====================================================================

#define  HTSTATS_CH3_ISOCNT3_SUM_MASK 0xffffffff
#define  HTSTATS_CH3_ISOCNT3_SUM_SHIFT 0
#define  HTSTATS_CH3_ISOCNT3_SUM_MASK_SHIFT(reg) (((reg) & HTSTATS_CH3_ISOCNT3_SUM_MASK) >> HTSTATS_CH3_ISOCNT3_SUM_SHIFT)
#define  HTSTATS_CH3_ISOCNT3_SUM_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_CH3_ISOCNT3_SUM_MASK) | (((uint32_t)val) << HTSTATS_CH3_ISOCNT3_SUM_SHIFT))

//====================================================================
//Register: Channel 3: Counter Reset (CH3_CntRst)
//====================================================================

#define  HTSTATS_CH3_CNTRST_RESERVED1_MASK 0xffffffc0
#define  HTSTATS_CH3_CNTRST_RESERVED1_SHIFT 6
#define  HTSTATS_CH3_CNTRST_RESERVED1_MASK_SHIFT(reg) (((reg) & HTSTATS_CH3_CNTRST_RESERVED1_MASK) >> HTSTATS_CH3_CNTRST_RESERVED1_SHIFT)
#define  HTSTATS_CH3_CNTRST_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_CH3_CNTRST_RESERVED1_MASK) | (((uint32_t)val) << HTSTATS_CH3_CNTRST_RESERVED1_SHIFT))

#define  HTSTATS_CH3_CNTRST_SBP_MASK 0x20
#define  HTSTATS_CH3_CNTRST_SBP_SHIFT 5
#define  HTSTATS_CH3_CNTRST_SBP_MASK_SHIFT(reg) (((reg) & HTSTATS_CH3_CNTRST_SBP_MASK) >> HTSTATS_CH3_CNTRST_SBP_SHIFT)
#define  HTSTATS_CH3_CNTRST_SBP_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_CH3_CNTRST_SBP_MASK) | (((uint32_t)val) << HTSTATS_CH3_CNTRST_SBP_SHIFT))

#define  HTSTATS_CH3_CNTRST_ISOCNT3_MASK 0x10
#define  HTSTATS_CH3_CNTRST_ISOCNT3_SHIFT 4
#define  HTSTATS_CH3_CNTRST_ISOCNT3_MASK_SHIFT(reg) (((reg) & HTSTATS_CH3_CNTRST_ISOCNT3_MASK) >> HTSTATS_CH3_CNTRST_ISOCNT3_SHIFT)
#define  HTSTATS_CH3_CNTRST_ISOCNT3_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_CH3_CNTRST_ISOCNT3_MASK) | (((uint32_t)val) << HTSTATS_CH3_CNTRST_ISOCNT3_SHIFT))

#define  HTSTATS_CH3_CNTRST_ISOCNT2_MASK 0x8
#define  HTSTATS_CH3_CNTRST_ISOCNT2_SHIFT 3
#define  HTSTATS_CH3_CNTRST_ISOCNT2_MASK_SHIFT(reg) (((reg) & HTSTATS_CH3_CNTRST_ISOCNT2_MASK) >> HTSTATS_CH3_CNTRST_ISOCNT2_SHIFT)
#define  HTSTATS_CH3_CNTRST_ISOCNT2_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_CH3_CNTRST_ISOCNT2_MASK) | (((uint32_t)val) << HTSTATS_CH3_CNTRST_ISOCNT2_SHIFT))

#define  HTSTATS_CH3_CNTRST_ISOCNT1_MASK 0x4
#define  HTSTATS_CH3_CNTRST_ISOCNT1_SHIFT 2
#define  HTSTATS_CH3_CNTRST_ISOCNT1_MASK_SHIFT(reg) (((reg) & HTSTATS_CH3_CNTRST_ISOCNT1_MASK) >> HTSTATS_CH3_CNTRST_ISOCNT1_SHIFT)
#define  HTSTATS_CH3_CNTRST_ISOCNT1_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_CH3_CNTRST_ISOCNT1_MASK) | (((uint32_t)val) << HTSTATS_CH3_CNTRST_ISOCNT1_SHIFT))

#define  HTSTATS_CH3_CNTRST_ISOCNT0_MASK 0x2
#define  HTSTATS_CH3_CNTRST_ISOCNT0_SHIFT 1
#define  HTSTATS_CH3_CNTRST_ISOCNT0_MASK_SHIFT(reg) (((reg) & HTSTATS_CH3_CNTRST_ISOCNT0_MASK) >> HTSTATS_CH3_CNTRST_ISOCNT0_SHIFT)
#define  HTSTATS_CH3_CNTRST_ISOCNT0_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_CH3_CNTRST_ISOCNT0_MASK) | (((uint32_t)val) << HTSTATS_CH3_CNTRST_ISOCNT0_SHIFT))

#define  HTSTATS_CH3_CNTRST_ACCUM_MASK 0x1
#define  HTSTATS_CH3_CNTRST_ACCUM_SHIFT 0
#define  HTSTATS_CH3_CNTRST_ACCUM_MASK_SHIFT(reg) (((reg) & HTSTATS_CH3_CNTRST_ACCUM_MASK) >> HTSTATS_CH3_CNTRST_ACCUM_SHIFT)
#define  HTSTATS_CH3_CNTRST_ACCUM_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_CH3_CNTRST_ACCUM_MASK) | (((uint32_t)val) << HTSTATS_CH3_CNTRST_ACCUM_SHIFT))

//====================================================================
//Register: Pixel Line Width Configuration Register (LW)
/** \brief Pixel Line Width Count*/
//====================================================================

#define  HTSTATS_LW_RESERVED1_MASK 0xffff0000
#define  HTSTATS_LW_RESERVED1_SHIFT 16
#define  HTSTATS_LW_RESERVED1_MASK_SHIFT(reg) (((reg) & HTSTATS_LW_RESERVED1_MASK) >> HTSTATS_LW_RESERVED1_SHIFT)
#define  HTSTATS_LW_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_LW_RESERVED1_MASK) | (((uint32_t)val) << HTSTATS_LW_RESERVED1_SHIFT))

#define  HTSTATS_LW_COUNT_MASK 0xffff
#define  HTSTATS_LW_COUNT_SHIFT 0
#define  HTSTATS_LW_COUNT_MASK_SHIFT(reg) (((reg) & HTSTATS_LW_COUNT_MASK) >> HTSTATS_LW_COUNT_SHIFT)
#define  HTSTATS_LW_COUNT_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_LW_COUNT_MASK) | (((uint32_t)val) << HTSTATS_LW_COUNT_SHIFT))

//====================================================================
//Register: Vcode to Magnitude Look Up Table (V2M_LUT)
/** \brief The LUT, look up table, is used to convert the pixel to a magnitude value. The processor requires Read/Write access to the LUT to set up the values needed. Access to the four LUTs is consolidated into a single register.*/
//====================================================================

#define  HTSTATS_V2M_LUT_RESERVED1_MASK 0xffff0000
#define  HTSTATS_V2M_LUT_RESERVED1_SHIFT 16
#define  HTSTATS_V2M_LUT_RESERVED1_MASK_SHIFT(reg) (((reg) & HTSTATS_V2M_LUT_RESERVED1_MASK) >> HTSTATS_V2M_LUT_RESERVED1_SHIFT)
#define  HTSTATS_V2M_LUT_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_V2M_LUT_RESERVED1_MASK) | (((uint32_t)val) << HTSTATS_V2M_LUT_RESERVED1_SHIFT))

#define  HTSTATS_V2M_LUT_C3_MASK 0xf000
#define  HTSTATS_V2M_LUT_C3_SHIFT 12
#define  HTSTATS_V2M_LUT_C3_MASK_SHIFT(reg) (((reg) & HTSTATS_V2M_LUT_C3_MASK) >> HTSTATS_V2M_LUT_C3_SHIFT)
#define  HTSTATS_V2M_LUT_C3_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_V2M_LUT_C3_MASK) | (((uint32_t)val) << HTSTATS_V2M_LUT_C3_SHIFT))

#define  HTSTATS_V2M_LUT_C2_MASK 0xf00
#define  HTSTATS_V2M_LUT_C2_SHIFT 8
#define  HTSTATS_V2M_LUT_C2_MASK_SHIFT(reg) (((reg) & HTSTATS_V2M_LUT_C2_MASK) >> HTSTATS_V2M_LUT_C2_SHIFT)
#define  HTSTATS_V2M_LUT_C2_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_V2M_LUT_C2_MASK) | (((uint32_t)val) << HTSTATS_V2M_LUT_C2_SHIFT))

#define  HTSTATS_V2M_LUT_C1_MASK 0xf0
#define  HTSTATS_V2M_LUT_C1_SHIFT 4
#define  HTSTATS_V2M_LUT_C1_MASK_SHIFT(reg) (((reg) & HTSTATS_V2M_LUT_C1_MASK) >> HTSTATS_V2M_LUT_C1_SHIFT)
#define  HTSTATS_V2M_LUT_C1_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_V2M_LUT_C1_MASK) | (((uint32_t)val) << HTSTATS_V2M_LUT_C1_SHIFT))

#define  HTSTATS_V2M_LUT_C0_MASK 0xf
#define  HTSTATS_V2M_LUT_C0_SHIFT 0
#define  HTSTATS_V2M_LUT_C0_MASK_SHIFT(reg) (((reg) & HTSTATS_V2M_LUT_C0_MASK) >> HTSTATS_V2M_LUT_C0_SHIFT)
#define  HTSTATS_V2M_LUT_C0_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_V2M_LUT_C0_MASK) | (((uint32_t)val) << HTSTATS_V2M_LUT_C0_SHIFT))

//====================================================================
//Register: AMLUT RAM Access Control Register (ARAR)
//====================================================================

#define  HTSTATS_ARAR_RESERVED1_MASK 0xffffffe0
#define  HTSTATS_ARAR_RESERVED1_SHIFT 5
#define  HTSTATS_ARAR_RESERVED1_MASK_SHIFT(reg) (((reg) & HTSTATS_ARAR_RESERVED1_MASK) >> HTSTATS_ARAR_RESERVED1_SHIFT)
#define  HTSTATS_ARAR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_ARAR_RESERVED1_MASK) | (((uint32_t)val) << HTSTATS_ARAR_RESERVED1_SHIFT))

#define  HTSTATS_ARAR_ALUT_CPU_MASK 0x10
#define  HTSTATS_ARAR_ALUT_CPU_SHIFT 4
#define  HTSTATS_ARAR_ALUT_CPU_MASK_SHIFT(reg) (((reg) & HTSTATS_ARAR_ALUT_CPU_MASK) >> HTSTATS_ARAR_ALUT_CPU_SHIFT)
#define  HTSTATS_ARAR_ALUT_CPU_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_ARAR_ALUT_CPU_MASK) | (((uint32_t)val) << HTSTATS_ARAR_ALUT_CPU_SHIFT))

#define  HTSTATS_ARAR_RAM_SELECT_MASK 0xc
#define  HTSTATS_ARAR_RAM_SELECT_SHIFT 2
#define  HTSTATS_ARAR_RAM_SELECT_MASK_SHIFT(reg) (((reg) & HTSTATS_ARAR_RAM_SELECT_MASK) >> HTSTATS_ARAR_RAM_SELECT_SHIFT)
#define  HTSTATS_ARAR_RAM_SELECT_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_ARAR_RAM_SELECT_MASK) | (((uint32_t)val) << HTSTATS_ARAR_RAM_SELECT_SHIFT))

#define  HTSTATS_ARAR_INC_ADDR_MODE_MASK 0x2
#define  HTSTATS_ARAR_INC_ADDR_MODE_SHIFT 1
#define  HTSTATS_ARAR_INC_ADDR_MODE_MASK_SHIFT(reg) (((reg) & HTSTATS_ARAR_INC_ADDR_MODE_MASK) >> HTSTATS_ARAR_INC_ADDR_MODE_SHIFT)
#define  HTSTATS_ARAR_INC_ADDR_MODE_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_ARAR_INC_ADDR_MODE_MASK) | (((uint32_t)val) << HTSTATS_ARAR_INC_ADDR_MODE_SHIFT))

#define  HTSTATS_ARAR_LB_RNW_MASK 0x1
#define  HTSTATS_ARAR_LB_RNW_SHIFT 0
#define  HTSTATS_ARAR_LB_RNW_MASK_SHIFT(reg) (((reg) & HTSTATS_ARAR_LB_RNW_MASK) >> HTSTATS_ARAR_LB_RNW_SHIFT)
#define  HTSTATS_ARAR_LB_RNW_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_ARAR_LB_RNW_MASK) | (((uint32_t)val) << HTSTATS_ARAR_LB_RNW_SHIFT))

//====================================================================
//Register: AMLUT RAM Address Write Register (ARAWR)
//====================================================================

#define  HTSTATS_ARAWR_ADDRESS_MASK 0xffffffff
#define  HTSTATS_ARAWR_ADDRESS_SHIFT 0
#define  HTSTATS_ARAWR_ADDRESS_MASK_SHIFT(reg) (((reg) & HTSTATS_ARAWR_ADDRESS_MASK) >> HTSTATS_ARAWR_ADDRESS_SHIFT)
#define  HTSTATS_ARAWR_ADDRESS_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_ARAWR_ADDRESS_MASK) | (((uint32_t)val) << HTSTATS_ARAWR_ADDRESS_SHIFT))

//====================================================================
//Register: AMLUT RAM Address Status Register (ARASR)
//====================================================================

#define  HTSTATS_ARASR_ADDRESS_MASK 0xffffffff
#define  HTSTATS_ARASR_ADDRESS_SHIFT 0
#define  HTSTATS_ARASR_ADDRESS_MASK_SHIFT(reg) (((reg) & HTSTATS_ARASR_ADDRESS_MASK) >> HTSTATS_ARASR_ADDRESS_SHIFT)
#define  HTSTATS_ARASR_ADDRESS_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_ARASR_ADDRESS_MASK) | (((uint32_t)val) << HTSTATS_ARASR_ADDRESS_SHIFT))

//====================================================================
//Register: AMLUT RAM Data Write Register (ARDWR)
/** \brief This register writes the AMLUT.*/
//====================================================================

#define  HTSTATS_ARDWR_DATA_MASK 0xffffffff
#define  HTSTATS_ARDWR_DATA_SHIFT 0
#define  HTSTATS_ARDWR_DATA_MASK_SHIFT(reg) (((reg) & HTSTATS_ARDWR_DATA_MASK) >> HTSTATS_ARDWR_DATA_SHIFT)
#define  HTSTATS_ARDWR_DATA_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_ARDWR_DATA_MASK) | (((uint32_t)val) << HTSTATS_ARDWR_DATA_SHIFT))

//====================================================================
//Register: AMLUT RAM Data Read Register (ARDRR)
/** \brief This register reads the AMLUT.*/
//====================================================================

#define  HTSTATS_ARDRR_DATA_MASK 0xffffffff
#define  HTSTATS_ARDRR_DATA_SHIFT 0
#define  HTSTATS_ARDRR_DATA_MASK_SHIFT(reg) (((reg) & HTSTATS_ARDRR_DATA_MASK) >> HTSTATS_ARDRR_DATA_SHIFT)
#define  HTSTATS_ARDRR_DATA_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_ARDRR_DATA_MASK) | (((uint32_t)val) << HTSTATS_ARDRR_DATA_SHIFT))

//====================================================================
//Register: LineBuffer Access Control Register (LBAR)
//====================================================================

#define  HTSTATS_LBAR_RESERVED1_MASK 0xffffffe0
#define  HTSTATS_LBAR_RESERVED1_SHIFT 5
#define  HTSTATS_LBAR_RESERVED1_MASK_SHIFT(reg) (((reg) & HTSTATS_LBAR_RESERVED1_MASK) >> HTSTATS_LBAR_RESERVED1_SHIFT)
#define  HTSTATS_LBAR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_LBAR_RESERVED1_MASK) | (((uint32_t)val) << HTSTATS_LBAR_RESERVED1_SHIFT))

#define  HTSTATS_LBAR_LB_CPU_MASK 0x10
#define  HTSTATS_LBAR_LB_CPU_SHIFT 4
#define  HTSTATS_LBAR_LB_CPU_MASK_SHIFT(reg) (((reg) & HTSTATS_LBAR_LB_CPU_MASK) >> HTSTATS_LBAR_LB_CPU_SHIFT)
#define  HTSTATS_LBAR_LB_CPU_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_LBAR_LB_CPU_MASK) | (((uint32_t)val) << HTSTATS_LBAR_LB_CPU_SHIFT))

#define  HTSTATS_LBAR_RESERVED2_MASK 0x8
#define  HTSTATS_LBAR_RESERVED2_SHIFT 3
#define  HTSTATS_LBAR_RESERVED2_MASK_SHIFT(reg) (((reg) & HTSTATS_LBAR_RESERVED2_MASK) >> HTSTATS_LBAR_RESERVED2_SHIFT)
#define  HTSTATS_LBAR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_LBAR_RESERVED2_MASK) | (((uint32_t)val) << HTSTATS_LBAR_RESERVED2_SHIFT))

#define  HTSTATS_LBAR_RAM_SELECT_MASK 0x4
#define  HTSTATS_LBAR_RAM_SELECT_SHIFT 2
#define  HTSTATS_LBAR_RAM_SELECT_MASK_SHIFT(reg) (((reg) & HTSTATS_LBAR_RAM_SELECT_MASK) >> HTSTATS_LBAR_RAM_SELECT_SHIFT)
#define  HTSTATS_LBAR_RAM_SELECT_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_LBAR_RAM_SELECT_MASK) | (((uint32_t)val) << HTSTATS_LBAR_RAM_SELECT_SHIFT))

#define  HTSTATS_LBAR_INC_ADDR_MODE_MASK 0x2
#define  HTSTATS_LBAR_INC_ADDR_MODE_SHIFT 1
#define  HTSTATS_LBAR_INC_ADDR_MODE_MASK_SHIFT(reg) (((reg) & HTSTATS_LBAR_INC_ADDR_MODE_MASK) >> HTSTATS_LBAR_INC_ADDR_MODE_SHIFT)
#define  HTSTATS_LBAR_INC_ADDR_MODE_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_LBAR_INC_ADDR_MODE_MASK) | (((uint32_t)val) << HTSTATS_LBAR_INC_ADDR_MODE_SHIFT))

#define  HTSTATS_LBAR_LB_RNW_MASK 0x1
#define  HTSTATS_LBAR_LB_RNW_SHIFT 0
#define  HTSTATS_LBAR_LB_RNW_MASK_SHIFT(reg) (((reg) & HTSTATS_LBAR_LB_RNW_MASK) >> HTSTATS_LBAR_LB_RNW_SHIFT)
#define  HTSTATS_LBAR_LB_RNW_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_LBAR_LB_RNW_MASK) | (((uint32_t)val) << HTSTATS_LBAR_LB_RNW_SHIFT))

//====================================================================
//Register: LineBuffer Address Write Register (LBAWR)
//====================================================================

#define  HTSTATS_LBAWR_ADDRESS_MASK 0xffffffff
#define  HTSTATS_LBAWR_ADDRESS_SHIFT 0
#define  HTSTATS_LBAWR_ADDRESS_MASK_SHIFT(reg) (((reg) & HTSTATS_LBAWR_ADDRESS_MASK) >> HTSTATS_LBAWR_ADDRESS_SHIFT)
#define  HTSTATS_LBAWR_ADDRESS_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_LBAWR_ADDRESS_MASK) | (((uint32_t)val) << HTSTATS_LBAWR_ADDRESS_SHIFT))

//====================================================================
//Register: LineBuffer Address Status Register (LBASR)
//====================================================================

#define  HTSTATS_LBASR_ADDRESS_MASK 0xffffffff
#define  HTSTATS_LBASR_ADDRESS_SHIFT 0
#define  HTSTATS_LBASR_ADDRESS_MASK_SHIFT(reg) (((reg) & HTSTATS_LBASR_ADDRESS_MASK) >> HTSTATS_LBASR_ADDRESS_SHIFT)
#define  HTSTATS_LBASR_ADDRESS_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_LBASR_ADDRESS_MASK) | (((uint32_t)val) << HTSTATS_LBASR_ADDRESS_SHIFT))

//====================================================================
//Register: LineBuffer Data Write Register (LBDWR)
/** \brief This register writes the LineBuffer.*/
//====================================================================

#define  HTSTATS_LBDWR_DATA_MASK 0xffffffff
#define  HTSTATS_LBDWR_DATA_SHIFT 0
#define  HTSTATS_LBDWR_DATA_MASK_SHIFT(reg) (((reg) & HTSTATS_LBDWR_DATA_MASK) >> HTSTATS_LBDWR_DATA_SHIFT)
#define  HTSTATS_LBDWR_DATA_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_LBDWR_DATA_MASK) | (((uint32_t)val) << HTSTATS_LBDWR_DATA_SHIFT))

//====================================================================
//Register: LineBuffer Data Read Register (LBDRR)
/** \brief This register reads the LineBuffer.*/
//====================================================================

#define  HTSTATS_LBDRR_DATA_MASK 0xffffffff
#define  HTSTATS_LBDRR_DATA_SHIFT 0
#define  HTSTATS_LBDRR_DATA_MASK_SHIFT(reg) (((reg) & HTSTATS_LBDRR_DATA_MASK) >> HTSTATS_LBDRR_DATA_SHIFT)
#define  HTSTATS_LBDRR_DATA_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_LBDRR_DATA_MASK) | (((uint32_t)val) << HTSTATS_LBDRR_DATA_SHIFT))

//====================================================================
//Register: Force StateMachine Register (SMF)
/** \brief Force State Mahine into different modes of operationk.*/
//====================================================================

#define  HTSTATS_SMF_RESERVED1_MASK 0xfffffffc
#define  HTSTATS_SMF_RESERVED1_SHIFT 2
#define  HTSTATS_SMF_RESERVED1_MASK_SHIFT(reg) (((reg) & HTSTATS_SMF_RESERVED1_MASK) >> HTSTATS_SMF_RESERVED1_SHIFT)
#define  HTSTATS_SMF_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_SMF_RESERVED1_MASK) | (((uint32_t)val) << HTSTATS_SMF_RESERVED1_SHIFT))

#define  HTSTATS_SMF_RESTOREMODE_MASK 0x2
#define  HTSTATS_SMF_RESTOREMODE_SHIFT 1
#define  HTSTATS_SMF_RESTOREMODE_MASK_SHIFT(reg) (((reg) & HTSTATS_SMF_RESTOREMODE_MASK) >> HTSTATS_SMF_RESTOREMODE_SHIFT)
#define  HTSTATS_SMF_RESTOREMODE_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_SMF_RESTOREMODE_MASK) | (((uint32_t)val) << HTSTATS_SMF_RESTOREMODE_SHIFT))

#define  HTSTATS_SMF_IDLE_MASK 0x1
#define  HTSTATS_SMF_IDLE_SHIFT 0
#define  HTSTATS_SMF_IDLE_MASK_SHIFT(reg) (((reg) & HTSTATS_SMF_IDLE_MASK) >> HTSTATS_SMF_IDLE_SHIFT)
#define  HTSTATS_SMF_IDLE_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_SMF_IDLE_MASK) | (((uint32_t)val) << HTSTATS_SMF_IDLE_SHIFT))

//====================================================================
//Register: Control register (Control)
//====================================================================

#define  HTSTATS_CONTROL_RESERVED1_MASK 0xffffff80
#define  HTSTATS_CONTROL_RESERVED1_SHIFT 7
#define  HTSTATS_CONTROL_RESERVED1_MASK_SHIFT(reg) (((reg) & HTSTATS_CONTROL_RESERVED1_MASK) >> HTSTATS_CONTROL_RESERVED1_SHIFT)
#define  HTSTATS_CONTROL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_CONTROL_RESERVED1_MASK) | (((uint32_t)val) << HTSTATS_CONTROL_RESERVED1_SHIFT))

#define  HTSTATS_CONTROL_SCALE_MASK 0x70
#define  HTSTATS_CONTROL_SCALE_SHIFT 4
#define  HTSTATS_CONTROL_SCALE_MASK_SHIFT(reg) (((reg) & HTSTATS_CONTROL_SCALE_MASK) >> HTSTATS_CONTROL_SCALE_SHIFT)
#define  HTSTATS_CONTROL_SCALE_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_CONTROL_SCALE_MASK) | (((uint32_t)val) << HTSTATS_CONTROL_SCALE_SHIFT))

#define  HTSTATS_CONTROL_NUMCOLS_MASK 0xc
#define  HTSTATS_CONTROL_NUMCOLS_SHIFT 2
#define  HTSTATS_CONTROL_NUMCOLS_MASK_SHIFT(reg) (((reg) & HTSTATS_CONTROL_NUMCOLS_MASK) >> HTSTATS_CONTROL_NUMCOLS_SHIFT)
#define  HTSTATS_CONTROL_NUMCOLS_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_CONTROL_NUMCOLS_MASK) | (((uint32_t)val) << HTSTATS_CONTROL_NUMCOLS_SHIFT))

#define  HTSTATS_CONTROL_NUMROWS_MASK 0x3
#define  HTSTATS_CONTROL_NUMROWS_SHIFT 0
#define  HTSTATS_CONTROL_NUMROWS_MASK_SHIFT(reg) (((reg) & HTSTATS_CONTROL_NUMROWS_MASK) >> HTSTATS_CONTROL_NUMROWS_SHIFT)
#define  HTSTATS_CONTROL_NUMROWS_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_CONTROL_NUMROWS_MASK) | (((uint32_t)val) << HTSTATS_CONTROL_NUMROWS_SHIFT))

//====================================================================
//Register: Coefficient Row 0 (Coeff0)
/** \brief 6-bit coefficients for first row of 5x5 matrix*/
//====================================================================

#define  HTSTATS_COEFF0_RESERVED1_MASK 0xc0000000
#define  HTSTATS_COEFF0_RESERVED1_SHIFT 30
#define  HTSTATS_COEFF0_RESERVED1_MASK_SHIFT(reg) (((reg) & HTSTATS_COEFF0_RESERVED1_MASK) >> HTSTATS_COEFF0_RESERVED1_SHIFT)
#define  HTSTATS_COEFF0_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_COEFF0_RESERVED1_MASK) | (((uint32_t)val) << HTSTATS_COEFF0_RESERVED1_SHIFT))

#define  HTSTATS_COEFF0_DATA4_MASK 0x3f000000
#define  HTSTATS_COEFF0_DATA4_SHIFT 24
#define  HTSTATS_COEFF0_DATA4_MASK_SHIFT(reg) (((reg) & HTSTATS_COEFF0_DATA4_MASK) >> HTSTATS_COEFF0_DATA4_SHIFT)
#define  HTSTATS_COEFF0_DATA4_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_COEFF0_DATA4_MASK) | (((uint32_t)val) << HTSTATS_COEFF0_DATA4_SHIFT))

#define  HTSTATS_COEFF0_DATA3_MASK 0xfc0000
#define  HTSTATS_COEFF0_DATA3_SHIFT 18
#define  HTSTATS_COEFF0_DATA3_MASK_SHIFT(reg) (((reg) & HTSTATS_COEFF0_DATA3_MASK) >> HTSTATS_COEFF0_DATA3_SHIFT)
#define  HTSTATS_COEFF0_DATA3_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_COEFF0_DATA3_MASK) | (((uint32_t)val) << HTSTATS_COEFF0_DATA3_SHIFT))

#define  HTSTATS_COEFF0_DATA2_MASK 0x3f000
#define  HTSTATS_COEFF0_DATA2_SHIFT 12
#define  HTSTATS_COEFF0_DATA2_MASK_SHIFT(reg) (((reg) & HTSTATS_COEFF0_DATA2_MASK) >> HTSTATS_COEFF0_DATA2_SHIFT)
#define  HTSTATS_COEFF0_DATA2_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_COEFF0_DATA2_MASK) | (((uint32_t)val) << HTSTATS_COEFF0_DATA2_SHIFT))

#define  HTSTATS_COEFF0_DATA1_MASK 0xfc0
#define  HTSTATS_COEFF0_DATA1_SHIFT 6
#define  HTSTATS_COEFF0_DATA1_MASK_SHIFT(reg) (((reg) & HTSTATS_COEFF0_DATA1_MASK) >> HTSTATS_COEFF0_DATA1_SHIFT)
#define  HTSTATS_COEFF0_DATA1_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_COEFF0_DATA1_MASK) | (((uint32_t)val) << HTSTATS_COEFF0_DATA1_SHIFT))

#define  HTSTATS_COEFF0_DATA0_MASK 0x3f
#define  HTSTATS_COEFF0_DATA0_SHIFT 0
#define  HTSTATS_COEFF0_DATA0_MASK_SHIFT(reg) (((reg) & HTSTATS_COEFF0_DATA0_MASK) >> HTSTATS_COEFF0_DATA0_SHIFT)
#define  HTSTATS_COEFF0_DATA0_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_COEFF0_DATA0_MASK) | (((uint32_t)val) << HTSTATS_COEFF0_DATA0_SHIFT))

//====================================================================
//Register: Coefficient Row 1 (Coeff1)
/** \brief 6-bit coefficients for second row of 5x5 matrix*/
//====================================================================

#define  HTSTATS_COEFF1_RESERVED1_MASK 0xc0000000
#define  HTSTATS_COEFF1_RESERVED1_SHIFT 30
#define  HTSTATS_COEFF1_RESERVED1_MASK_SHIFT(reg) (((reg) & HTSTATS_COEFF1_RESERVED1_MASK) >> HTSTATS_COEFF1_RESERVED1_SHIFT)
#define  HTSTATS_COEFF1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_COEFF1_RESERVED1_MASK) | (((uint32_t)val) << HTSTATS_COEFF1_RESERVED1_SHIFT))

#define  HTSTATS_COEFF1_DATA4_MASK 0x3f000000
#define  HTSTATS_COEFF1_DATA4_SHIFT 24
#define  HTSTATS_COEFF1_DATA4_MASK_SHIFT(reg) (((reg) & HTSTATS_COEFF1_DATA4_MASK) >> HTSTATS_COEFF1_DATA4_SHIFT)
#define  HTSTATS_COEFF1_DATA4_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_COEFF1_DATA4_MASK) | (((uint32_t)val) << HTSTATS_COEFF1_DATA4_SHIFT))

#define  HTSTATS_COEFF1_DATA3_MASK 0xfc0000
#define  HTSTATS_COEFF1_DATA3_SHIFT 18
#define  HTSTATS_COEFF1_DATA3_MASK_SHIFT(reg) (((reg) & HTSTATS_COEFF1_DATA3_MASK) >> HTSTATS_COEFF1_DATA3_SHIFT)
#define  HTSTATS_COEFF1_DATA3_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_COEFF1_DATA3_MASK) | (((uint32_t)val) << HTSTATS_COEFF1_DATA3_SHIFT))

#define  HTSTATS_COEFF1_DATA2_MASK 0x3f000
#define  HTSTATS_COEFF1_DATA2_SHIFT 12
#define  HTSTATS_COEFF1_DATA2_MASK_SHIFT(reg) (((reg) & HTSTATS_COEFF1_DATA2_MASK) >> HTSTATS_COEFF1_DATA2_SHIFT)
#define  HTSTATS_COEFF1_DATA2_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_COEFF1_DATA2_MASK) | (((uint32_t)val) << HTSTATS_COEFF1_DATA2_SHIFT))

#define  HTSTATS_COEFF1_DATA1_MASK 0xfc0
#define  HTSTATS_COEFF1_DATA1_SHIFT 6
#define  HTSTATS_COEFF1_DATA1_MASK_SHIFT(reg) (((reg) & HTSTATS_COEFF1_DATA1_MASK) >> HTSTATS_COEFF1_DATA1_SHIFT)
#define  HTSTATS_COEFF1_DATA1_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_COEFF1_DATA1_MASK) | (((uint32_t)val) << HTSTATS_COEFF1_DATA1_SHIFT))

#define  HTSTATS_COEFF1_DATA0_MASK 0x3f
#define  HTSTATS_COEFF1_DATA0_SHIFT 0
#define  HTSTATS_COEFF1_DATA0_MASK_SHIFT(reg) (((reg) & HTSTATS_COEFF1_DATA0_MASK) >> HTSTATS_COEFF1_DATA0_SHIFT)
#define  HTSTATS_COEFF1_DATA0_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_COEFF1_DATA0_MASK) | (((uint32_t)val) << HTSTATS_COEFF1_DATA0_SHIFT))

//====================================================================
//Register: Coefficient Row 2 (Coeff2)
/** \brief 6-bit coefficients for third row of 5x5 matrix*/
//====================================================================

#define  HTSTATS_COEFF2_RESERVED1_MASK 0xc0000000
#define  HTSTATS_COEFF2_RESERVED1_SHIFT 30
#define  HTSTATS_COEFF2_RESERVED1_MASK_SHIFT(reg) (((reg) & HTSTATS_COEFF2_RESERVED1_MASK) >> HTSTATS_COEFF2_RESERVED1_SHIFT)
#define  HTSTATS_COEFF2_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_COEFF2_RESERVED1_MASK) | (((uint32_t)val) << HTSTATS_COEFF2_RESERVED1_SHIFT))

#define  HTSTATS_COEFF2_DATA4_MASK 0x3f000000
#define  HTSTATS_COEFF2_DATA4_SHIFT 24
#define  HTSTATS_COEFF2_DATA4_MASK_SHIFT(reg) (((reg) & HTSTATS_COEFF2_DATA4_MASK) >> HTSTATS_COEFF2_DATA4_SHIFT)
#define  HTSTATS_COEFF2_DATA4_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_COEFF2_DATA4_MASK) | (((uint32_t)val) << HTSTATS_COEFF2_DATA4_SHIFT))

#define  HTSTATS_COEFF2_DATA3_MASK 0xfc0000
#define  HTSTATS_COEFF2_DATA3_SHIFT 18
#define  HTSTATS_COEFF2_DATA3_MASK_SHIFT(reg) (((reg) & HTSTATS_COEFF2_DATA3_MASK) >> HTSTATS_COEFF2_DATA3_SHIFT)
#define  HTSTATS_COEFF2_DATA3_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_COEFF2_DATA3_MASK) | (((uint32_t)val) << HTSTATS_COEFF2_DATA3_SHIFT))

#define  HTSTATS_COEFF2_DATA2_MASK 0x3f000
#define  HTSTATS_COEFF2_DATA2_SHIFT 12
#define  HTSTATS_COEFF2_DATA2_MASK_SHIFT(reg) (((reg) & HTSTATS_COEFF2_DATA2_MASK) >> HTSTATS_COEFF2_DATA2_SHIFT)
#define  HTSTATS_COEFF2_DATA2_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_COEFF2_DATA2_MASK) | (((uint32_t)val) << HTSTATS_COEFF2_DATA2_SHIFT))

#define  HTSTATS_COEFF2_DATA1_MASK 0xfc0
#define  HTSTATS_COEFF2_DATA1_SHIFT 6
#define  HTSTATS_COEFF2_DATA1_MASK_SHIFT(reg) (((reg) & HTSTATS_COEFF2_DATA1_MASK) >> HTSTATS_COEFF2_DATA1_SHIFT)
#define  HTSTATS_COEFF2_DATA1_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_COEFF2_DATA1_MASK) | (((uint32_t)val) << HTSTATS_COEFF2_DATA1_SHIFT))

#define  HTSTATS_COEFF2_DATA0_MASK 0x3f
#define  HTSTATS_COEFF2_DATA0_SHIFT 0
#define  HTSTATS_COEFF2_DATA0_MASK_SHIFT(reg) (((reg) & HTSTATS_COEFF2_DATA0_MASK) >> HTSTATS_COEFF2_DATA0_SHIFT)
#define  HTSTATS_COEFF2_DATA0_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_COEFF2_DATA0_MASK) | (((uint32_t)val) << HTSTATS_COEFF2_DATA0_SHIFT))

//====================================================================
//Register: Coefficient Row 3 (Coeff3)
/** \brief 6-bit coefficients for fourth row of 5x5 matrix*/
//====================================================================

#define  HTSTATS_COEFF3_RESERVED1_MASK 0xc0000000
#define  HTSTATS_COEFF3_RESERVED1_SHIFT 30
#define  HTSTATS_COEFF3_RESERVED1_MASK_SHIFT(reg) (((reg) & HTSTATS_COEFF3_RESERVED1_MASK) >> HTSTATS_COEFF3_RESERVED1_SHIFT)
#define  HTSTATS_COEFF3_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_COEFF3_RESERVED1_MASK) | (((uint32_t)val) << HTSTATS_COEFF3_RESERVED1_SHIFT))

#define  HTSTATS_COEFF3_DATA4_MASK 0x3f000000
#define  HTSTATS_COEFF3_DATA4_SHIFT 24
#define  HTSTATS_COEFF3_DATA4_MASK_SHIFT(reg) (((reg) & HTSTATS_COEFF3_DATA4_MASK) >> HTSTATS_COEFF3_DATA4_SHIFT)
#define  HTSTATS_COEFF3_DATA4_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_COEFF3_DATA4_MASK) | (((uint32_t)val) << HTSTATS_COEFF3_DATA4_SHIFT))

#define  HTSTATS_COEFF3_DATA3_MASK 0xfc0000
#define  HTSTATS_COEFF3_DATA3_SHIFT 18
#define  HTSTATS_COEFF3_DATA3_MASK_SHIFT(reg) (((reg) & HTSTATS_COEFF3_DATA3_MASK) >> HTSTATS_COEFF3_DATA3_SHIFT)
#define  HTSTATS_COEFF3_DATA3_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_COEFF3_DATA3_MASK) | (((uint32_t)val) << HTSTATS_COEFF3_DATA3_SHIFT))

#define  HTSTATS_COEFF3_DATA2_MASK 0x3f000
#define  HTSTATS_COEFF3_DATA2_SHIFT 12
#define  HTSTATS_COEFF3_DATA2_MASK_SHIFT(reg) (((reg) & HTSTATS_COEFF3_DATA2_MASK) >> HTSTATS_COEFF3_DATA2_SHIFT)
#define  HTSTATS_COEFF3_DATA2_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_COEFF3_DATA2_MASK) | (((uint32_t)val) << HTSTATS_COEFF3_DATA2_SHIFT))

#define  HTSTATS_COEFF3_DATA1_MASK 0xfc0
#define  HTSTATS_COEFF3_DATA1_SHIFT 6
#define  HTSTATS_COEFF3_DATA1_MASK_SHIFT(reg) (((reg) & HTSTATS_COEFF3_DATA1_MASK) >> HTSTATS_COEFF3_DATA1_SHIFT)
#define  HTSTATS_COEFF3_DATA1_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_COEFF3_DATA1_MASK) | (((uint32_t)val) << HTSTATS_COEFF3_DATA1_SHIFT))

#define  HTSTATS_COEFF3_DATA0_MASK 0x3f
#define  HTSTATS_COEFF3_DATA0_SHIFT 0
#define  HTSTATS_COEFF3_DATA0_MASK_SHIFT(reg) (((reg) & HTSTATS_COEFF3_DATA0_MASK) >> HTSTATS_COEFF3_DATA0_SHIFT)
#define  HTSTATS_COEFF3_DATA0_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_COEFF3_DATA0_MASK) | (((uint32_t)val) << HTSTATS_COEFF3_DATA0_SHIFT))

//====================================================================
//Register: Coefficient Row 4 (Coeff4)
/** \brief 6-bit weight for fifth row of 5x5 matrix*/
//====================================================================

#define  HTSTATS_COEFF4_RESERVED1_MASK 0xc0000000
#define  HTSTATS_COEFF4_RESERVED1_SHIFT 30
#define  HTSTATS_COEFF4_RESERVED1_MASK_SHIFT(reg) (((reg) & HTSTATS_COEFF4_RESERVED1_MASK) >> HTSTATS_COEFF4_RESERVED1_SHIFT)
#define  HTSTATS_COEFF4_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_COEFF4_RESERVED1_MASK) | (((uint32_t)val) << HTSTATS_COEFF4_RESERVED1_SHIFT))

#define  HTSTATS_COEFF4_DATA4_MASK 0x3f000000
#define  HTSTATS_COEFF4_DATA4_SHIFT 24
#define  HTSTATS_COEFF4_DATA4_MASK_SHIFT(reg) (((reg) & HTSTATS_COEFF4_DATA4_MASK) >> HTSTATS_COEFF4_DATA4_SHIFT)
#define  HTSTATS_COEFF4_DATA4_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_COEFF4_DATA4_MASK) | (((uint32_t)val) << HTSTATS_COEFF4_DATA4_SHIFT))

#define  HTSTATS_COEFF4_DATA3_MASK 0xfc0000
#define  HTSTATS_COEFF4_DATA3_SHIFT 18
#define  HTSTATS_COEFF4_DATA3_MASK_SHIFT(reg) (((reg) & HTSTATS_COEFF4_DATA3_MASK) >> HTSTATS_COEFF4_DATA3_SHIFT)
#define  HTSTATS_COEFF4_DATA3_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_COEFF4_DATA3_MASK) | (((uint32_t)val) << HTSTATS_COEFF4_DATA3_SHIFT))

#define  HTSTATS_COEFF4_DATA2_MASK 0x3f000
#define  HTSTATS_COEFF4_DATA2_SHIFT 12
#define  HTSTATS_COEFF4_DATA2_MASK_SHIFT(reg) (((reg) & HTSTATS_COEFF4_DATA2_MASK) >> HTSTATS_COEFF4_DATA2_SHIFT)
#define  HTSTATS_COEFF4_DATA2_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_COEFF4_DATA2_MASK) | (((uint32_t)val) << HTSTATS_COEFF4_DATA2_SHIFT))

#define  HTSTATS_COEFF4_DATA1_MASK 0xfc0
#define  HTSTATS_COEFF4_DATA1_SHIFT 6
#define  HTSTATS_COEFF4_DATA1_MASK_SHIFT(reg) (((reg) & HTSTATS_COEFF4_DATA1_MASK) >> HTSTATS_COEFF4_DATA1_SHIFT)
#define  HTSTATS_COEFF4_DATA1_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_COEFF4_DATA1_MASK) | (((uint32_t)val) << HTSTATS_COEFF4_DATA1_SHIFT))

#define  HTSTATS_COEFF4_DATA0_MASK 0x3f
#define  HTSTATS_COEFF4_DATA0_SHIFT 0
#define  HTSTATS_COEFF4_DATA0_MASK_SHIFT(reg) (((reg) & HTSTATS_COEFF4_DATA0_MASK) >> HTSTATS_COEFF4_DATA0_SHIFT)
#define  HTSTATS_COEFF4_DATA0_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_COEFF4_DATA0_MASK) | (((uint32_t)val) << HTSTATS_COEFF4_DATA0_SHIFT))

//====================================================================
//Register: Compression LUT (4 to 2 bit) (CompLUT)
//====================================================================

#define  HTSTATS_COMPLUT_DATA_MASK 0xffffffff
#define  HTSTATS_COMPLUT_DATA_SHIFT 0
#define  HTSTATS_COMPLUT_DATA_MASK_SHIFT(reg) (((reg) & HTSTATS_COMPLUT_DATA_MASK) >> HTSTATS_COMPLUT_DATA_SHIFT)
#define  HTSTATS_COMPLUT_DATA_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_COMPLUT_DATA_MASK) | (((uint32_t)val) << HTSTATS_COMPLUT_DATA_SHIFT))

//====================================================================
//Register: Decompression LUT (2 to 4 bit) (DecLUT)
//====================================================================

#define  HTSTATS_DECLUT_RESERVED1_MASK 0xffff0000
#define  HTSTATS_DECLUT_RESERVED1_SHIFT 16
#define  HTSTATS_DECLUT_RESERVED1_MASK_SHIFT(reg) (((reg) & HTSTATS_DECLUT_RESERVED1_MASK) >> HTSTATS_DECLUT_RESERVED1_SHIFT)
#define  HTSTATS_DECLUT_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_DECLUT_RESERVED1_MASK) | (((uint32_t)val) << HTSTATS_DECLUT_RESERVED1_SHIFT))

#define  HTSTATS_DECLUT_DATA_MASK 0xffff
#define  HTSTATS_DECLUT_DATA_SHIFT 0
#define  HTSTATS_DECLUT_DATA_MASK_SHIFT(reg) (((reg) & HTSTATS_DECLUT_DATA_MASK) >> HTSTATS_DECLUT_DATA_SHIFT)
#define  HTSTATS_DECLUT_DATA_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_DECLUT_DATA_MASK) | (((uint32_t)val) << HTSTATS_DECLUT_DATA_SHIFT))

//====================================================================
//Register: Status Register (Status)
//====================================================================

#define  HTSTATS_STATUS_RESERVED1_MASK 0xffffc000
#define  HTSTATS_STATUS_RESERVED1_SHIFT 14
#define  HTSTATS_STATUS_RESERVED1_MASK_SHIFT(reg) (((reg) & HTSTATS_STATUS_RESERVED1_MASK) >> HTSTATS_STATUS_RESERVED1_SHIFT)
#define  HTSTATS_STATUS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_STATUS_RESERVED1_MASK) | (((uint32_t)val) << HTSTATS_STATUS_RESERVED1_SHIFT))

#define  HTSTATS_STATUS_E3_MASK 0x2000
#define  HTSTATS_STATUS_E3_SHIFT 13
#define  HTSTATS_STATUS_E3_MASK_SHIFT(reg) (((reg) & HTSTATS_STATUS_E3_MASK) >> HTSTATS_STATUS_E3_SHIFT)
#define  HTSTATS_STATUS_E3_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_STATUS_E3_MASK) | (((uint32_t)val) << HTSTATS_STATUS_E3_SHIFT))

#define  HTSTATS_STATUS_B3_MASK 0x1000
#define  HTSTATS_STATUS_B3_SHIFT 12
#define  HTSTATS_STATUS_B3_MASK_SHIFT(reg) (((reg) & HTSTATS_STATUS_B3_MASK) >> HTSTATS_STATUS_B3_SHIFT)
#define  HTSTATS_STATUS_B3_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_STATUS_B3_MASK) | (((uint32_t)val) << HTSTATS_STATUS_B3_SHIFT))

#define  HTSTATS_STATUS_RESERVED2_MASK 0xc00
#define  HTSTATS_STATUS_RESERVED2_SHIFT 10
#define  HTSTATS_STATUS_RESERVED2_MASK_SHIFT(reg) (((reg) & HTSTATS_STATUS_RESERVED2_MASK) >> HTSTATS_STATUS_RESERVED2_SHIFT)
#define  HTSTATS_STATUS_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_STATUS_RESERVED2_MASK) | (((uint32_t)val) << HTSTATS_STATUS_RESERVED2_SHIFT))

#define  HTSTATS_STATUS_E2_MASK 0x200
#define  HTSTATS_STATUS_E2_SHIFT 9
#define  HTSTATS_STATUS_E2_MASK_SHIFT(reg) (((reg) & HTSTATS_STATUS_E2_MASK) >> HTSTATS_STATUS_E2_SHIFT)
#define  HTSTATS_STATUS_E2_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_STATUS_E2_MASK) | (((uint32_t)val) << HTSTATS_STATUS_E2_SHIFT))

#define  HTSTATS_STATUS_B2_MASK 0x100
#define  HTSTATS_STATUS_B2_SHIFT 8
#define  HTSTATS_STATUS_B2_MASK_SHIFT(reg) (((reg) & HTSTATS_STATUS_B2_MASK) >> HTSTATS_STATUS_B2_SHIFT)
#define  HTSTATS_STATUS_B2_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_STATUS_B2_MASK) | (((uint32_t)val) << HTSTATS_STATUS_B2_SHIFT))

#define  HTSTATS_STATUS_RESERVED3_MASK 0xc0
#define  HTSTATS_STATUS_RESERVED3_SHIFT 6
#define  HTSTATS_STATUS_RESERVED3_MASK_SHIFT(reg) (((reg) & HTSTATS_STATUS_RESERVED3_MASK) >> HTSTATS_STATUS_RESERVED3_SHIFT)
#define  HTSTATS_STATUS_RESERVED3_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_STATUS_RESERVED3_MASK) | (((uint32_t)val) << HTSTATS_STATUS_RESERVED3_SHIFT))

#define  HTSTATS_STATUS_E1_MASK 0x20
#define  HTSTATS_STATUS_E1_SHIFT 5
#define  HTSTATS_STATUS_E1_MASK_SHIFT(reg) (((reg) & HTSTATS_STATUS_E1_MASK) >> HTSTATS_STATUS_E1_SHIFT)
#define  HTSTATS_STATUS_E1_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_STATUS_E1_MASK) | (((uint32_t)val) << HTSTATS_STATUS_E1_SHIFT))

#define  HTSTATS_STATUS_B1_MASK 0x10
#define  HTSTATS_STATUS_B1_SHIFT 4
#define  HTSTATS_STATUS_B1_MASK_SHIFT(reg) (((reg) & HTSTATS_STATUS_B1_MASK) >> HTSTATS_STATUS_B1_SHIFT)
#define  HTSTATS_STATUS_B1_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_STATUS_B1_MASK) | (((uint32_t)val) << HTSTATS_STATUS_B1_SHIFT))

#define  HTSTATS_STATUS_RESERVED4_MASK 0xc
#define  HTSTATS_STATUS_RESERVED4_SHIFT 2
#define  HTSTATS_STATUS_RESERVED4_MASK_SHIFT(reg) (((reg) & HTSTATS_STATUS_RESERVED4_MASK) >> HTSTATS_STATUS_RESERVED4_SHIFT)
#define  HTSTATS_STATUS_RESERVED4_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_STATUS_RESERVED4_MASK) | (((uint32_t)val) << HTSTATS_STATUS_RESERVED4_SHIFT))

#define  HTSTATS_STATUS_E0_MASK 0x2
#define  HTSTATS_STATUS_E0_SHIFT 1
#define  HTSTATS_STATUS_E0_MASK_SHIFT(reg) (((reg) & HTSTATS_STATUS_E0_MASK) >> HTSTATS_STATUS_E0_SHIFT)
#define  HTSTATS_STATUS_E0_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_STATUS_E0_MASK) | (((uint32_t)val) << HTSTATS_STATUS_E0_SHIFT))

#define  HTSTATS_STATUS_B0_MASK 0x1
#define  HTSTATS_STATUS_B0_SHIFT 0
#define  HTSTATS_STATUS_B0_MASK_SHIFT(reg) (((reg) & HTSTATS_STATUS_B0_MASK) >> HTSTATS_STATUS_B0_SHIFT)
#define  HTSTATS_STATUS_B0_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_STATUS_B0_MASK) | (((uint32_t)val) << HTSTATS_STATUS_B0_SHIFT))

//====================================================================
//Register: Hardware Channel 1 Muxing Register (H1_Mux)
//====================================================================

#define  HTSTATS_H1_MUX_RESERVED1_MASK 0xffffffe0
#define  HTSTATS_H1_MUX_RESERVED1_SHIFT 5
#define  HTSTATS_H1_MUX_RESERVED1_MASK_SHIFT(reg) (((reg) & HTSTATS_H1_MUX_RESERVED1_MASK) >> HTSTATS_H1_MUX_RESERVED1_SHIFT)
#define  HTSTATS_H1_MUX_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_H1_MUX_RESERVED1_MASK) | (((uint32_t)val) << HTSTATS_H1_MUX_RESERVED1_SHIFT))

#define  HTSTATS_H1_MUX_E_MASK 0x10
#define  HTSTATS_H1_MUX_E_SHIFT 4
#define  HTSTATS_H1_MUX_E_MASK_SHIFT(reg) (((reg) & HTSTATS_H1_MUX_E_MASK) >> HTSTATS_H1_MUX_E_SHIFT)
#define  HTSTATS_H1_MUX_E_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_H1_MUX_E_MASK) | (((uint32_t)val) << HTSTATS_H1_MUX_E_SHIFT))

#define  HTSTATS_H1_MUX_RESERVED2_MASK 0x8
#define  HTSTATS_H1_MUX_RESERVED2_SHIFT 3
#define  HTSTATS_H1_MUX_RESERVED2_MASK_SHIFT(reg) (((reg) & HTSTATS_H1_MUX_RESERVED2_MASK) >> HTSTATS_H1_MUX_RESERVED2_SHIFT)
#define  HTSTATS_H1_MUX_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_H1_MUX_RESERVED2_MASK) | (((uint32_t)val) << HTSTATS_H1_MUX_RESERVED2_SHIFT))

#define  HTSTATS_H1_MUX_CH_MASK 0x7
#define  HTSTATS_H1_MUX_CH_SHIFT 0
#define  HTSTATS_H1_MUX_CH_MASK_SHIFT(reg) (((reg) & HTSTATS_H1_MUX_CH_MASK) >> HTSTATS_H1_MUX_CH_SHIFT)
#define  HTSTATS_H1_MUX_CH_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_H1_MUX_CH_MASK) | (((uint32_t)val) << HTSTATS_H1_MUX_CH_SHIFT))

//====================================================================
//Register: Hardware Channel 2 Muxing Register (H2_Mux)
//====================================================================

#define  HTSTATS_H2_MUX_RESERVED1_MASK 0xffffffe0
#define  HTSTATS_H2_MUX_RESERVED1_SHIFT 5
#define  HTSTATS_H2_MUX_RESERVED1_MASK_SHIFT(reg) (((reg) & HTSTATS_H2_MUX_RESERVED1_MASK) >> HTSTATS_H2_MUX_RESERVED1_SHIFT)
#define  HTSTATS_H2_MUX_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_H2_MUX_RESERVED1_MASK) | (((uint32_t)val) << HTSTATS_H2_MUX_RESERVED1_SHIFT))

#define  HTSTATS_H2_MUX_E_MASK 0x10
#define  HTSTATS_H2_MUX_E_SHIFT 4
#define  HTSTATS_H2_MUX_E_MASK_SHIFT(reg) (((reg) & HTSTATS_H2_MUX_E_MASK) >> HTSTATS_H2_MUX_E_SHIFT)
#define  HTSTATS_H2_MUX_E_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_H2_MUX_E_MASK) | (((uint32_t)val) << HTSTATS_H2_MUX_E_SHIFT))

#define  HTSTATS_H2_MUX_RESERVED2_MASK 0x8
#define  HTSTATS_H2_MUX_RESERVED2_SHIFT 3
#define  HTSTATS_H2_MUX_RESERVED2_MASK_SHIFT(reg) (((reg) & HTSTATS_H2_MUX_RESERVED2_MASK) >> HTSTATS_H2_MUX_RESERVED2_SHIFT)
#define  HTSTATS_H2_MUX_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_H2_MUX_RESERVED2_MASK) | (((uint32_t)val) << HTSTATS_H2_MUX_RESERVED2_SHIFT))

#define  HTSTATS_H2_MUX_CH_MASK 0x7
#define  HTSTATS_H2_MUX_CH_SHIFT 0
#define  HTSTATS_H2_MUX_CH_MASK_SHIFT(reg) (((reg) & HTSTATS_H2_MUX_CH_MASK) >> HTSTATS_H2_MUX_CH_SHIFT)
#define  HTSTATS_H2_MUX_CH_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_H2_MUX_CH_MASK) | (((uint32_t)val) << HTSTATS_H2_MUX_CH_SHIFT))

//====================================================================
//Register: Hardware Channel 3 Muxing Register (H3_Mux)
//====================================================================

#define  HTSTATS_H3_MUX_RESERVED1_MASK 0xffffffe0
#define  HTSTATS_H3_MUX_RESERVED1_SHIFT 5
#define  HTSTATS_H3_MUX_RESERVED1_MASK_SHIFT(reg) (((reg) & HTSTATS_H3_MUX_RESERVED1_MASK) >> HTSTATS_H3_MUX_RESERVED1_SHIFT)
#define  HTSTATS_H3_MUX_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_H3_MUX_RESERVED1_MASK) | (((uint32_t)val) << HTSTATS_H3_MUX_RESERVED1_SHIFT))

#define  HTSTATS_H3_MUX_E_MASK 0x10
#define  HTSTATS_H3_MUX_E_SHIFT 4
#define  HTSTATS_H3_MUX_E_MASK_SHIFT(reg) (((reg) & HTSTATS_H3_MUX_E_MASK) >> HTSTATS_H3_MUX_E_SHIFT)
#define  HTSTATS_H3_MUX_E_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_H3_MUX_E_MASK) | (((uint32_t)val) << HTSTATS_H3_MUX_E_SHIFT))

#define  HTSTATS_H3_MUX_RESERVED2_MASK 0x8
#define  HTSTATS_H3_MUX_RESERVED2_SHIFT 3
#define  HTSTATS_H3_MUX_RESERVED2_MASK_SHIFT(reg) (((reg) & HTSTATS_H3_MUX_RESERVED2_MASK) >> HTSTATS_H3_MUX_RESERVED2_SHIFT)
#define  HTSTATS_H3_MUX_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_H3_MUX_RESERVED2_MASK) | (((uint32_t)val) << HTSTATS_H3_MUX_RESERVED2_SHIFT))

#define  HTSTATS_H3_MUX_CH_MASK 0x7
#define  HTSTATS_H3_MUX_CH_SHIFT 0
#define  HTSTATS_H3_MUX_CH_MASK_SHIFT(reg) (((reg) & HTSTATS_H3_MUX_CH_MASK) >> HTSTATS_H3_MUX_CH_SHIFT)
#define  HTSTATS_H3_MUX_CH_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_H3_MUX_CH_MASK) | (((uint32_t)val) << HTSTATS_H3_MUX_CH_SHIFT))

//====================================================================
//Register: Hardware Channel 4 Muxing Register (H4_Mux)
//====================================================================

#define  HTSTATS_H4_MUX_RESERVED1_MASK 0xffffffe0
#define  HTSTATS_H4_MUX_RESERVED1_SHIFT 5
#define  HTSTATS_H4_MUX_RESERVED1_MASK_SHIFT(reg) (((reg) & HTSTATS_H4_MUX_RESERVED1_MASK) >> HTSTATS_H4_MUX_RESERVED1_SHIFT)
#define  HTSTATS_H4_MUX_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_H4_MUX_RESERVED1_MASK) | (((uint32_t)val) << HTSTATS_H4_MUX_RESERVED1_SHIFT))

#define  HTSTATS_H4_MUX_E_MASK 0x10
#define  HTSTATS_H4_MUX_E_SHIFT 4
#define  HTSTATS_H4_MUX_E_MASK_SHIFT(reg) (((reg) & HTSTATS_H4_MUX_E_MASK) >> HTSTATS_H4_MUX_E_SHIFT)
#define  HTSTATS_H4_MUX_E_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_H4_MUX_E_MASK) | (((uint32_t)val) << HTSTATS_H4_MUX_E_SHIFT))

#define  HTSTATS_H4_MUX_RESERVED2_MASK 0x8
#define  HTSTATS_H4_MUX_RESERVED2_SHIFT 3
#define  HTSTATS_H4_MUX_RESERVED2_MASK_SHIFT(reg) (((reg) & HTSTATS_H4_MUX_RESERVED2_MASK) >> HTSTATS_H4_MUX_RESERVED2_SHIFT)
#define  HTSTATS_H4_MUX_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_H4_MUX_RESERVED2_MASK) | (((uint32_t)val) << HTSTATS_H4_MUX_RESERVED2_SHIFT))

#define  HTSTATS_H4_MUX_CH_MASK 0x7
#define  HTSTATS_H4_MUX_CH_SHIFT 0
#define  HTSTATS_H4_MUX_CH_MASK_SHIFT(reg) (((reg) & HTSTATS_H4_MUX_CH_MASK) >> HTSTATS_H4_MUX_CH_SHIFT)
#define  HTSTATS_H4_MUX_CH_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_H4_MUX_CH_MASK) | (((uint32_t)val) << HTSTATS_H4_MUX_CH_SHIFT))

//====================================================================
//Register: Save System Register (Save)
//====================================================================

#define  HTSTATS_SAVE_D_MASK 0xffffffff
#define  HTSTATS_SAVE_D_SHIFT 0
#define  HTSTATS_SAVE_D_MASK_SHIFT(reg) (((reg) & HTSTATS_SAVE_D_MASK) >> HTSTATS_SAVE_D_SHIFT)
#define  HTSTATS_SAVE_D_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_SAVE_D_MASK) | (((uint32_t)val) << HTSTATS_SAVE_D_SHIFT))

//====================================================================
//Register: Restore System Register (Restore)
//====================================================================

#define  HTSTATS_RESTORE_D_MASK 0xffffffff
#define  HTSTATS_RESTORE_D_SHIFT 0
#define  HTSTATS_RESTORE_D_MASK_SHIFT(reg) (((reg) & HTSTATS_RESTORE_D_MASK) >> HTSTATS_RESTORE_D_SHIFT)
#define  HTSTATS_RESTORE_D_REPLACE_VAL(reg,val) (((reg) & ~HTSTATS_RESTORE_D_MASK) | (((uint32_t)val) << HTSTATS_RESTORE_D_SHIFT))

#endif // HTSTATS
