 /*
 **************************************************************************************
 *
 * (c) Copyright 2013 Marvell International Ltd.
 *
 *
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/.
 *
 **************************************************************************************
 *
 * \file HScale_regmasks.h
 * Generated using RegBuild 1.6.3
 *
 **************************************************************************************
 */

#ifndef _HSCALE_REGMASKS_H_
#define _HSCALE_REGMASKS_H_

#ifndef __KERNEL__
#include <stdint.h>
#endif

//====================================================================
//
//Register File: HScale (HScale)
/** \brief Register Descriptions for the PIC HScale block (rev 0 . 2 . 2 . 3)*/
//
//====================================================================

//====================================================================
//Register: Horizontal Scaler Configuration Register (HSCR)
/** \brief General configuration register for HScale block.*/
//====================================================================

#define  HSCALE_HSCR_RESERVED1_MASK 0xfffffffe
#define  HSCALE_HSCR_RESERVED1_SHIFT 1
#define  HSCALE_HSCR_RESERVED1_MASK_SHIFT(reg) (((reg) & HSCALE_HSCR_RESERVED1_MASK) >> HSCALE_HSCR_RESERVED1_SHIFT)
#define  HSCALE_HSCR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~HSCALE_HSCR_RESERVED1_MASK) | (((uint32_t)val) << HSCALE_HSCR_RESERVED1_SHIFT))

#define  HSCALE_HSCR_BYPASS_MASK 0x1
#define  HSCALE_HSCR_BYPASS_SHIFT 0
#define  HSCALE_HSCR_BYPASS_MASK_SHIFT(reg) (((reg) & HSCALE_HSCR_BYPASS_MASK) >> HSCALE_HSCR_BYPASS_SHIFT)
#define  HSCALE_HSCR_BYPASS_REPLACE_VAL(reg,val) (((reg) & ~HSCALE_HSCR_BYPASS_MASK) | (((uint32_t)val) << HSCALE_HSCR_BYPASS_SHIFT))

//====================================================================
//Register: Horizontal Scaler Scale Register (HSSR)
/** \brief Horizontal Scaler Scale Factor*/
//====================================================================

#define  HSCALE_HSSR_RESERVED1_MASK 0xfffe0000
#define  HSCALE_HSSR_RESERVED1_SHIFT 17
#define  HSCALE_HSSR_RESERVED1_MASK_SHIFT(reg) (((reg) & HSCALE_HSSR_RESERVED1_MASK) >> HSCALE_HSSR_RESERVED1_SHIFT)
#define  HSCALE_HSSR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~HSCALE_HSSR_RESERVED1_MASK) | (((uint32_t)val) << HSCALE_HSSR_RESERVED1_SHIFT))

#define  HSCALE_HSSR_SCALE_MASK 0x1ffff
#define  HSCALE_HSSR_SCALE_SHIFT 0
#define  HSCALE_HSSR_SCALE_MASK_SHIFT(reg) (((reg) & HSCALE_HSSR_SCALE_MASK) >> HSCALE_HSSR_SCALE_SHIFT)
#define  HSCALE_HSSR_SCALE_REPLACE_VAL(reg,val) (((reg) & ~HSCALE_HSSR_SCALE_MASK) | (((uint32_t)val) << HSCALE_HSSR_SCALE_SHIFT))

//====================================================================
//Register: IP Tagging Revision 0 (REV0)
/** \brief Provide means for firmware to read IP tagging information.
      This register of particular interest to firmware.*/
//====================================================================

#define  HSCALE_REV0_MAJ_MASK 0xffff0000
#define  HSCALE_REV0_MAJ_SHIFT 16
#define  HSCALE_REV0_MAJ_MASK_SHIFT(reg) (((reg) & HSCALE_REV0_MAJ_MASK) >> HSCALE_REV0_MAJ_SHIFT)
#define  HSCALE_REV0_MAJ_REPLACE_VAL(reg,val) (((reg) & ~HSCALE_REV0_MAJ_MASK) | (((uint32_t)val) << HSCALE_REV0_MAJ_SHIFT))

#define  HSCALE_REV0_MID_MASK 0xffff
#define  HSCALE_REV0_MID_SHIFT 0
#define  HSCALE_REV0_MID_MASK_SHIFT(reg) (((reg) & HSCALE_REV0_MID_MASK) >> HSCALE_REV0_MID_SHIFT)
#define  HSCALE_REV0_MID_REPLACE_VAL(reg,val) (((reg) & ~HSCALE_REV0_MID_MASK) | (((uint32_t)val) << HSCALE_REV0_MID_SHIFT))

//====================================================================
//Register: IP Tagging Revision 1 (REV1)
/** \brief Provide means for firmware to read IP tagging information.*/
//====================================================================

#define  HSCALE_REV1_RESERVED1_MASK 0xffff0000
#define  HSCALE_REV1_RESERVED1_SHIFT 16
#define  HSCALE_REV1_RESERVED1_MASK_SHIFT(reg) (((reg) & HSCALE_REV1_RESERVED1_MASK) >> HSCALE_REV1_RESERVED1_SHIFT)
#define  HSCALE_REV1_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~HSCALE_REV1_RESERVED1_MASK) | (((uint32_t)val) << HSCALE_REV1_RESERVED1_SHIFT))

#define  HSCALE_REV1_CFG_MASK 0xffff
#define  HSCALE_REV1_CFG_SHIFT 0
#define  HSCALE_REV1_CFG_MASK_SHIFT(reg) (((reg) & HSCALE_REV1_CFG_MASK) >> HSCALE_REV1_CFG_SHIFT)
#define  HSCALE_REV1_CFG_REPLACE_VAL(reg,val) (((reg) & ~HSCALE_REV1_CFG_MASK) | (((uint32_t)val) << HSCALE_REV1_CFG_SHIFT))

#endif // HSCALE
