 /*
 **************************************************************************************
 *
 * (c) Copyright 2013 Marvell International Ltd.
 *
 *
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/.
 *
 **************************************************************************************
 *
 * \file Granite2_Padring_regmasks.h
 * Generated using RegBuild 1.6.3
 *
 **************************************************************************************
 */

#ifndef _GRANITE2_PADRING_REGMASKS_H_
#define _GRANITE2_PADRING_REGMASKS_H_

#ifndef __KERNEL__
#include <stdint.h>
#endif

//====================================================================
//
//Register File: Granite2 PADRING CONFIG Registers (Granite2_PADRING)
/** \brief This register set includes all the registers for the padring I/O configuration*/
//
//====================================================================

//====================================================================
//
//Register File: IO_PAD0 Configuration Registers (IO_PAD0)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

//====================================================================
//Register: IO_PAD0 Configuration Register (PIOCFG)
/** \brief "PHI_PADXDC_SRC" Pad*/
//====================================================================

#define  IO_PAD0_PIOCFG_RESERVED1_MASK 0xfc000000
#define  IO_PAD0_PIOCFG_RESERVED1_SHIFT 26
#define  IO_PAD0_PIOCFG_RESERVED1_MASK_SHIFT(reg) (((reg) & IO_PAD0_PIOCFG_RESERVED1_MASK) >> IO_PAD0_PIOCFG_RESERVED1_SHIFT)
#define  IO_PAD0_PIOCFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD0_PIOCFG_RESERVED1_MASK) | (((uint32_t)val) << IO_PAD0_PIOCFG_RESERVED1_SHIFT))

#define  IO_PAD0_PIOCFG_PD_MASK 0x2000000
#define  IO_PAD0_PIOCFG_PD_SHIFT 25
#define  IO_PAD0_PIOCFG_PD_MASK_SHIFT(reg) (((reg) & IO_PAD0_PIOCFG_PD_MASK) >> IO_PAD0_PIOCFG_PD_SHIFT)
#define  IO_PAD0_PIOCFG_PD_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD0_PIOCFG_PD_MASK) | (((uint32_t)val) << IO_PAD0_PIOCFG_PD_SHIFT))

#define  IO_PAD0_PIOCFG_ODT_EN_MASK 0x1000000
#define  IO_PAD0_PIOCFG_ODT_EN_SHIFT 24
#define  IO_PAD0_PIOCFG_ODT_EN_MASK_SHIFT(reg) (((reg) & IO_PAD0_PIOCFG_ODT_EN_MASK) >> IO_PAD0_PIOCFG_ODT_EN_SHIFT)
#define  IO_PAD0_PIOCFG_ODT_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD0_PIOCFG_ODT_EN_MASK) | (((uint32_t)val) << IO_PAD0_PIOCFG_ODT_EN_SHIFT))

#define  IO_PAD0_PIOCFG_LED_EN_MASK 0x800000
#define  IO_PAD0_PIOCFG_LED_EN_SHIFT 23
#define  IO_PAD0_PIOCFG_LED_EN_MASK_SHIFT(reg) (((reg) & IO_PAD0_PIOCFG_LED_EN_MASK) >> IO_PAD0_PIOCFG_LED_EN_SHIFT)
#define  IO_PAD0_PIOCFG_LED_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD0_PIOCFG_LED_EN_MASK) | (((uint32_t)val) << IO_PAD0_PIOCFG_LED_EN_SHIFT))

#define  IO_PAD0_PIOCFG_I2C_SEL_MASK 0x600000
#define  IO_PAD0_PIOCFG_I2C_SEL_SHIFT 21
#define  IO_PAD0_PIOCFG_I2C_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD0_PIOCFG_I2C_SEL_MASK) >> IO_PAD0_PIOCFG_I2C_SEL_SHIFT)
#define  IO_PAD0_PIOCFG_I2C_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD0_PIOCFG_I2C_SEL_MASK) | (((uint32_t)val) << IO_PAD0_PIOCFG_I2C_SEL_SHIFT))

#define  IO_PAD0_PIOCFG_DGTBSEL_MASK 0x1e0000
#define  IO_PAD0_PIOCFG_DGTBSEL_SHIFT 17
#define  IO_PAD0_PIOCFG_DGTBSEL_MASK_SHIFT(reg) (((reg) & IO_PAD0_PIOCFG_DGTBSEL_MASK) >> IO_PAD0_PIOCFG_DGTBSEL_SHIFT)
#define  IO_PAD0_PIOCFG_DGTBSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD0_PIOCFG_DGTBSEL_MASK) | (((uint32_t)val) << IO_PAD0_PIOCFG_DGTBSEL_SHIFT))

#define  IO_PAD0_PIOCFG_RAWSEL_MASK 0x10000
#define  IO_PAD0_PIOCFG_RAWSEL_SHIFT 16
#define  IO_PAD0_PIOCFG_RAWSEL_MASK_SHIFT(reg) (((reg) & IO_PAD0_PIOCFG_RAWSEL_MASK) >> IO_PAD0_PIOCFG_RAWSEL_SHIFT)
#define  IO_PAD0_PIOCFG_RAWSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD0_PIOCFG_RAWSEL_MASK) | (((uint32_t)val) << IO_PAD0_PIOCFG_RAWSEL_SHIFT))

#define  IO_PAD0_PIOCFG_PULL_SEL_MASK 0x8000
#define  IO_PAD0_PIOCFG_PULL_SEL_SHIFT 15
#define  IO_PAD0_PIOCFG_PULL_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD0_PIOCFG_PULL_SEL_MASK) >> IO_PAD0_PIOCFG_PULL_SEL_SHIFT)
#define  IO_PAD0_PIOCFG_PULL_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD0_PIOCFG_PULL_SEL_MASK) | (((uint32_t)val) << IO_PAD0_PIOCFG_PULL_SEL_SHIFT))

#define  IO_PAD0_PIOCFG_PUEN_MASK 0x4000
#define  IO_PAD0_PIOCFG_PUEN_SHIFT 14
#define  IO_PAD0_PIOCFG_PUEN_MASK_SHIFT(reg) (((reg) & IO_PAD0_PIOCFG_PUEN_MASK) >> IO_PAD0_PIOCFG_PUEN_SHIFT)
#define  IO_PAD0_PIOCFG_PUEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD0_PIOCFG_PUEN_MASK) | (((uint32_t)val) << IO_PAD0_PIOCFG_PUEN_SHIFT))

#define  IO_PAD0_PIOCFG_PDEN_MASK 0x2000
#define  IO_PAD0_PIOCFG_PDEN_SHIFT 13
#define  IO_PAD0_PIOCFG_PDEN_MASK_SHIFT(reg) (((reg) & IO_PAD0_PIOCFG_PDEN_MASK) >> IO_PAD0_PIOCFG_PDEN_SHIFT)
#define  IO_PAD0_PIOCFG_PDEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD0_PIOCFG_PDEN_MASK) | (((uint32_t)val) << IO_PAD0_PIOCFG_PDEN_SHIFT))

#define  IO_PAD0_PIOCFG_SR_MASK 0x1800
#define  IO_PAD0_PIOCFG_SR_SHIFT 11
#define  IO_PAD0_PIOCFG_SR_MASK_SHIFT(reg) (((reg) & IO_PAD0_PIOCFG_SR_MASK) >> IO_PAD0_PIOCFG_SR_SHIFT)
#define  IO_PAD0_PIOCFG_SR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD0_PIOCFG_SR_MASK) | (((uint32_t)val) << IO_PAD0_PIOCFG_SR_SHIFT))

#define  IO_PAD0_PIOCFG_SLP_DI_MASK 0x400
#define  IO_PAD0_PIOCFG_SLP_DI_SHIFT 10
#define  IO_PAD0_PIOCFG_SLP_DI_MASK_SHIFT(reg) (((reg) & IO_PAD0_PIOCFG_SLP_DI_MASK) >> IO_PAD0_PIOCFG_SLP_DI_SHIFT)
#define  IO_PAD0_PIOCFG_SLP_DI_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD0_PIOCFG_SLP_DI_MASK) | (((uint32_t)val) << IO_PAD0_PIOCFG_SLP_DI_SHIFT))

#define  IO_PAD0_PIOCFG_SLP_CNTRL_MASK 0x200
#define  IO_PAD0_PIOCFG_SLP_CNTRL_SHIFT 9
#define  IO_PAD0_PIOCFG_SLP_CNTRL_MASK_SHIFT(reg) (((reg) & IO_PAD0_PIOCFG_SLP_CNTRL_MASK) >> IO_PAD0_PIOCFG_SLP_CNTRL_SHIFT)
#define  IO_PAD0_PIOCFG_SLP_CNTRL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD0_PIOCFG_SLP_CNTRL_MASK) | (((uint32_t)val) << IO_PAD0_PIOCFG_SLP_CNTRL_SHIFT))

#define  IO_PAD0_PIOCFG_SLP_DO_MASK 0x100
#define  IO_PAD0_PIOCFG_SLP_DO_SHIFT 8
#define  IO_PAD0_PIOCFG_SLP_DO_MASK_SHIFT(reg) (((reg) & IO_PAD0_PIOCFG_SLP_DO_MASK) >> IO_PAD0_PIOCFG_SLP_DO_SHIFT)
#define  IO_PAD0_PIOCFG_SLP_DO_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD0_PIOCFG_SLP_DO_MASK) | (((uint32_t)val) << IO_PAD0_PIOCFG_SLP_DO_SHIFT))

#define  IO_PAD0_PIOCFG_SLP_DIR_MASK 0x80
#define  IO_PAD0_PIOCFG_SLP_DIR_SHIFT 7
#define  IO_PAD0_PIOCFG_SLP_DIR_MASK_SHIFT(reg) (((reg) & IO_PAD0_PIOCFG_SLP_DIR_MASK) >> IO_PAD0_PIOCFG_SLP_DIR_SHIFT)
#define  IO_PAD0_PIOCFG_SLP_DIR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD0_PIOCFG_SLP_DIR_MASK) | (((uint32_t)val) << IO_PAD0_PIOCFG_SLP_DIR_SHIFT))

#define  IO_PAD0_PIOCFG_EDGE_EN_N_MASK 0x40
#define  IO_PAD0_PIOCFG_EDGE_EN_N_SHIFT 6
#define  IO_PAD0_PIOCFG_EDGE_EN_N_MASK_SHIFT(reg) (((reg) & IO_PAD0_PIOCFG_EDGE_EN_N_MASK) >> IO_PAD0_PIOCFG_EDGE_EN_N_SHIFT)
#define  IO_PAD0_PIOCFG_EDGE_EN_N_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD0_PIOCFG_EDGE_EN_N_MASK) | (((uint32_t)val) << IO_PAD0_PIOCFG_EDGE_EN_N_SHIFT))

#define  IO_PAD0_PIOCFG_EDGE_FALL_EN_MASK 0x20
#define  IO_PAD0_PIOCFG_EDGE_FALL_EN_SHIFT 5
#define  IO_PAD0_PIOCFG_EDGE_FALL_EN_MASK_SHIFT(reg) (((reg) & IO_PAD0_PIOCFG_EDGE_FALL_EN_MASK) >> IO_PAD0_PIOCFG_EDGE_FALL_EN_SHIFT)
#define  IO_PAD0_PIOCFG_EDGE_FALL_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD0_PIOCFG_EDGE_FALL_EN_MASK) | (((uint32_t)val) << IO_PAD0_PIOCFG_EDGE_FALL_EN_SHIFT))

#define  IO_PAD0_PIOCFG_EDGE_RISE_EN_MASK 0x10
#define  IO_PAD0_PIOCFG_EDGE_RISE_EN_SHIFT 4
#define  IO_PAD0_PIOCFG_EDGE_RISE_EN_MASK_SHIFT(reg) (((reg) & IO_PAD0_PIOCFG_EDGE_RISE_EN_MASK) >> IO_PAD0_PIOCFG_EDGE_RISE_EN_SHIFT)
#define  IO_PAD0_PIOCFG_EDGE_RISE_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD0_PIOCFG_EDGE_RISE_EN_MASK) | (((uint32_t)val) << IO_PAD0_PIOCFG_EDGE_RISE_EN_SHIFT))

#define  IO_PAD0_PIOCFG_SLP_SEL_MASK 0x8
#define  IO_PAD0_PIOCFG_SLP_SEL_SHIFT 3
#define  IO_PAD0_PIOCFG_SLP_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD0_PIOCFG_SLP_SEL_MASK) >> IO_PAD0_PIOCFG_SLP_SEL_SHIFT)
#define  IO_PAD0_PIOCFG_SLP_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD0_PIOCFG_SLP_SEL_MASK) | (((uint32_t)val) << IO_PAD0_PIOCFG_SLP_SEL_SHIFT))

#define  IO_PAD0_PIOCFG_FUNC_SEL_MASK 0x7
#define  IO_PAD0_PIOCFG_FUNC_SEL_SHIFT 0
#define  IO_PAD0_PIOCFG_FUNC_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD0_PIOCFG_FUNC_SEL_MASK) >> IO_PAD0_PIOCFG_FUNC_SEL_SHIFT)
#define  IO_PAD0_PIOCFG_FUNC_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD0_PIOCFG_FUNC_SEL_MASK) | (((uint32_t)val) << IO_PAD0_PIOCFG_FUNC_SEL_SHIFT))

//====================================================================
//
//Register File: IO_PAD1 Configuration Registers (IO_PAD1)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

//====================================================================
//Register: IO_PAD1 Configuration Register (PIOCFG)
/** \brief "PHI_PADXDC_SRC" Pad*/
//====================================================================

#define  IO_PAD1_PIOCFG_RESERVED1_MASK 0xfc000000
#define  IO_PAD1_PIOCFG_RESERVED1_SHIFT 26
#define  IO_PAD1_PIOCFG_RESERVED1_MASK_SHIFT(reg) (((reg) & IO_PAD1_PIOCFG_RESERVED1_MASK) >> IO_PAD1_PIOCFG_RESERVED1_SHIFT)
#define  IO_PAD1_PIOCFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD1_PIOCFG_RESERVED1_MASK) | (((uint32_t)val) << IO_PAD1_PIOCFG_RESERVED1_SHIFT))

#define  IO_PAD1_PIOCFG_PD_MASK 0x2000000
#define  IO_PAD1_PIOCFG_PD_SHIFT 25
#define  IO_PAD1_PIOCFG_PD_MASK_SHIFT(reg) (((reg) & IO_PAD1_PIOCFG_PD_MASK) >> IO_PAD1_PIOCFG_PD_SHIFT)
#define  IO_PAD1_PIOCFG_PD_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD1_PIOCFG_PD_MASK) | (((uint32_t)val) << IO_PAD1_PIOCFG_PD_SHIFT))

#define  IO_PAD1_PIOCFG_ODT_EN_MASK 0x1000000
#define  IO_PAD1_PIOCFG_ODT_EN_SHIFT 24
#define  IO_PAD1_PIOCFG_ODT_EN_MASK_SHIFT(reg) (((reg) & IO_PAD1_PIOCFG_ODT_EN_MASK) >> IO_PAD1_PIOCFG_ODT_EN_SHIFT)
#define  IO_PAD1_PIOCFG_ODT_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD1_PIOCFG_ODT_EN_MASK) | (((uint32_t)val) << IO_PAD1_PIOCFG_ODT_EN_SHIFT))

#define  IO_PAD1_PIOCFG_LED_EN_MASK 0x800000
#define  IO_PAD1_PIOCFG_LED_EN_SHIFT 23
#define  IO_PAD1_PIOCFG_LED_EN_MASK_SHIFT(reg) (((reg) & IO_PAD1_PIOCFG_LED_EN_MASK) >> IO_PAD1_PIOCFG_LED_EN_SHIFT)
#define  IO_PAD1_PIOCFG_LED_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD1_PIOCFG_LED_EN_MASK) | (((uint32_t)val) << IO_PAD1_PIOCFG_LED_EN_SHIFT))

#define  IO_PAD1_PIOCFG_I2C_SEL_MASK 0x600000
#define  IO_PAD1_PIOCFG_I2C_SEL_SHIFT 21
#define  IO_PAD1_PIOCFG_I2C_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD1_PIOCFG_I2C_SEL_MASK) >> IO_PAD1_PIOCFG_I2C_SEL_SHIFT)
#define  IO_PAD1_PIOCFG_I2C_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD1_PIOCFG_I2C_SEL_MASK) | (((uint32_t)val) << IO_PAD1_PIOCFG_I2C_SEL_SHIFT))

#define  IO_PAD1_PIOCFG_DGTBSEL_MASK 0x1e0000
#define  IO_PAD1_PIOCFG_DGTBSEL_SHIFT 17
#define  IO_PAD1_PIOCFG_DGTBSEL_MASK_SHIFT(reg) (((reg) & IO_PAD1_PIOCFG_DGTBSEL_MASK) >> IO_PAD1_PIOCFG_DGTBSEL_SHIFT)
#define  IO_PAD1_PIOCFG_DGTBSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD1_PIOCFG_DGTBSEL_MASK) | (((uint32_t)val) << IO_PAD1_PIOCFG_DGTBSEL_SHIFT))

#define  IO_PAD1_PIOCFG_RAWSEL_MASK 0x10000
#define  IO_PAD1_PIOCFG_RAWSEL_SHIFT 16
#define  IO_PAD1_PIOCFG_RAWSEL_MASK_SHIFT(reg) (((reg) & IO_PAD1_PIOCFG_RAWSEL_MASK) >> IO_PAD1_PIOCFG_RAWSEL_SHIFT)
#define  IO_PAD1_PIOCFG_RAWSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD1_PIOCFG_RAWSEL_MASK) | (((uint32_t)val) << IO_PAD1_PIOCFG_RAWSEL_SHIFT))

#define  IO_PAD1_PIOCFG_PULL_SEL_MASK 0x8000
#define  IO_PAD1_PIOCFG_PULL_SEL_SHIFT 15
#define  IO_PAD1_PIOCFG_PULL_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD1_PIOCFG_PULL_SEL_MASK) >> IO_PAD1_PIOCFG_PULL_SEL_SHIFT)
#define  IO_PAD1_PIOCFG_PULL_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD1_PIOCFG_PULL_SEL_MASK) | (((uint32_t)val) << IO_PAD1_PIOCFG_PULL_SEL_SHIFT))

#define  IO_PAD1_PIOCFG_PUEN_MASK 0x4000
#define  IO_PAD1_PIOCFG_PUEN_SHIFT 14
#define  IO_PAD1_PIOCFG_PUEN_MASK_SHIFT(reg) (((reg) & IO_PAD1_PIOCFG_PUEN_MASK) >> IO_PAD1_PIOCFG_PUEN_SHIFT)
#define  IO_PAD1_PIOCFG_PUEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD1_PIOCFG_PUEN_MASK) | (((uint32_t)val) << IO_PAD1_PIOCFG_PUEN_SHIFT))

#define  IO_PAD1_PIOCFG_PDEN_MASK 0x2000
#define  IO_PAD1_PIOCFG_PDEN_SHIFT 13
#define  IO_PAD1_PIOCFG_PDEN_MASK_SHIFT(reg) (((reg) & IO_PAD1_PIOCFG_PDEN_MASK) >> IO_PAD1_PIOCFG_PDEN_SHIFT)
#define  IO_PAD1_PIOCFG_PDEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD1_PIOCFG_PDEN_MASK) | (((uint32_t)val) << IO_PAD1_PIOCFG_PDEN_SHIFT))

#define  IO_PAD1_PIOCFG_SR_MASK 0x1800
#define  IO_PAD1_PIOCFG_SR_SHIFT 11
#define  IO_PAD1_PIOCFG_SR_MASK_SHIFT(reg) (((reg) & IO_PAD1_PIOCFG_SR_MASK) >> IO_PAD1_PIOCFG_SR_SHIFT)
#define  IO_PAD1_PIOCFG_SR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD1_PIOCFG_SR_MASK) | (((uint32_t)val) << IO_PAD1_PIOCFG_SR_SHIFT))

#define  IO_PAD1_PIOCFG_SLP_DI_MASK 0x400
#define  IO_PAD1_PIOCFG_SLP_DI_SHIFT 10
#define  IO_PAD1_PIOCFG_SLP_DI_MASK_SHIFT(reg) (((reg) & IO_PAD1_PIOCFG_SLP_DI_MASK) >> IO_PAD1_PIOCFG_SLP_DI_SHIFT)
#define  IO_PAD1_PIOCFG_SLP_DI_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD1_PIOCFG_SLP_DI_MASK) | (((uint32_t)val) << IO_PAD1_PIOCFG_SLP_DI_SHIFT))

#define  IO_PAD1_PIOCFG_SLP_CNTRL_MASK 0x200
#define  IO_PAD1_PIOCFG_SLP_CNTRL_SHIFT 9
#define  IO_PAD1_PIOCFG_SLP_CNTRL_MASK_SHIFT(reg) (((reg) & IO_PAD1_PIOCFG_SLP_CNTRL_MASK) >> IO_PAD1_PIOCFG_SLP_CNTRL_SHIFT)
#define  IO_PAD1_PIOCFG_SLP_CNTRL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD1_PIOCFG_SLP_CNTRL_MASK) | (((uint32_t)val) << IO_PAD1_PIOCFG_SLP_CNTRL_SHIFT))

#define  IO_PAD1_PIOCFG_SLP_DO_MASK 0x100
#define  IO_PAD1_PIOCFG_SLP_DO_SHIFT 8
#define  IO_PAD1_PIOCFG_SLP_DO_MASK_SHIFT(reg) (((reg) & IO_PAD1_PIOCFG_SLP_DO_MASK) >> IO_PAD1_PIOCFG_SLP_DO_SHIFT)
#define  IO_PAD1_PIOCFG_SLP_DO_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD1_PIOCFG_SLP_DO_MASK) | (((uint32_t)val) << IO_PAD1_PIOCFG_SLP_DO_SHIFT))

#define  IO_PAD1_PIOCFG_SLP_DIR_MASK 0x80
#define  IO_PAD1_PIOCFG_SLP_DIR_SHIFT 7
#define  IO_PAD1_PIOCFG_SLP_DIR_MASK_SHIFT(reg) (((reg) & IO_PAD1_PIOCFG_SLP_DIR_MASK) >> IO_PAD1_PIOCFG_SLP_DIR_SHIFT)
#define  IO_PAD1_PIOCFG_SLP_DIR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD1_PIOCFG_SLP_DIR_MASK) | (((uint32_t)val) << IO_PAD1_PIOCFG_SLP_DIR_SHIFT))

#define  IO_PAD1_PIOCFG_EDGE_EN_N_MASK 0x40
#define  IO_PAD1_PIOCFG_EDGE_EN_N_SHIFT 6
#define  IO_PAD1_PIOCFG_EDGE_EN_N_MASK_SHIFT(reg) (((reg) & IO_PAD1_PIOCFG_EDGE_EN_N_MASK) >> IO_PAD1_PIOCFG_EDGE_EN_N_SHIFT)
#define  IO_PAD1_PIOCFG_EDGE_EN_N_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD1_PIOCFG_EDGE_EN_N_MASK) | (((uint32_t)val) << IO_PAD1_PIOCFG_EDGE_EN_N_SHIFT))

#define  IO_PAD1_PIOCFG_EDGE_FALL_EN_MASK 0x20
#define  IO_PAD1_PIOCFG_EDGE_FALL_EN_SHIFT 5
#define  IO_PAD1_PIOCFG_EDGE_FALL_EN_MASK_SHIFT(reg) (((reg) & IO_PAD1_PIOCFG_EDGE_FALL_EN_MASK) >> IO_PAD1_PIOCFG_EDGE_FALL_EN_SHIFT)
#define  IO_PAD1_PIOCFG_EDGE_FALL_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD1_PIOCFG_EDGE_FALL_EN_MASK) | (((uint32_t)val) << IO_PAD1_PIOCFG_EDGE_FALL_EN_SHIFT))

#define  IO_PAD1_PIOCFG_EDGE_RISE_EN_MASK 0x10
#define  IO_PAD1_PIOCFG_EDGE_RISE_EN_SHIFT 4
#define  IO_PAD1_PIOCFG_EDGE_RISE_EN_MASK_SHIFT(reg) (((reg) & IO_PAD1_PIOCFG_EDGE_RISE_EN_MASK) >> IO_PAD1_PIOCFG_EDGE_RISE_EN_SHIFT)
#define  IO_PAD1_PIOCFG_EDGE_RISE_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD1_PIOCFG_EDGE_RISE_EN_MASK) | (((uint32_t)val) << IO_PAD1_PIOCFG_EDGE_RISE_EN_SHIFT))

#define  IO_PAD1_PIOCFG_SLP_SEL_MASK 0x8
#define  IO_PAD1_PIOCFG_SLP_SEL_SHIFT 3
#define  IO_PAD1_PIOCFG_SLP_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD1_PIOCFG_SLP_SEL_MASK) >> IO_PAD1_PIOCFG_SLP_SEL_SHIFT)
#define  IO_PAD1_PIOCFG_SLP_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD1_PIOCFG_SLP_SEL_MASK) | (((uint32_t)val) << IO_PAD1_PIOCFG_SLP_SEL_SHIFT))

#define  IO_PAD1_PIOCFG_FUNC_SEL_MASK 0x7
#define  IO_PAD1_PIOCFG_FUNC_SEL_SHIFT 0
#define  IO_PAD1_PIOCFG_FUNC_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD1_PIOCFG_FUNC_SEL_MASK) >> IO_PAD1_PIOCFG_FUNC_SEL_SHIFT)
#define  IO_PAD1_PIOCFG_FUNC_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD1_PIOCFG_FUNC_SEL_MASK) | (((uint32_t)val) << IO_PAD1_PIOCFG_FUNC_SEL_SHIFT))

//====================================================================
//
//Register File: IO_PAD2 Configuration Registers (IO_PAD2)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

//====================================================================
//Register: IO_PAD2 Configuration Register (PIOCFG)
/** \brief "PHI_PADXDC_SRC" Pad*/
//====================================================================

#define  IO_PAD2_PIOCFG_RESERVED1_MASK 0xfc000000
#define  IO_PAD2_PIOCFG_RESERVED1_SHIFT 26
#define  IO_PAD2_PIOCFG_RESERVED1_MASK_SHIFT(reg) (((reg) & IO_PAD2_PIOCFG_RESERVED1_MASK) >> IO_PAD2_PIOCFG_RESERVED1_SHIFT)
#define  IO_PAD2_PIOCFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD2_PIOCFG_RESERVED1_MASK) | (((uint32_t)val) << IO_PAD2_PIOCFG_RESERVED1_SHIFT))

#define  IO_PAD2_PIOCFG_PD_MASK 0x2000000
#define  IO_PAD2_PIOCFG_PD_SHIFT 25
#define  IO_PAD2_PIOCFG_PD_MASK_SHIFT(reg) (((reg) & IO_PAD2_PIOCFG_PD_MASK) >> IO_PAD2_PIOCFG_PD_SHIFT)
#define  IO_PAD2_PIOCFG_PD_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD2_PIOCFG_PD_MASK) | (((uint32_t)val) << IO_PAD2_PIOCFG_PD_SHIFT))

#define  IO_PAD2_PIOCFG_ODT_EN_MASK 0x1000000
#define  IO_PAD2_PIOCFG_ODT_EN_SHIFT 24
#define  IO_PAD2_PIOCFG_ODT_EN_MASK_SHIFT(reg) (((reg) & IO_PAD2_PIOCFG_ODT_EN_MASK) >> IO_PAD2_PIOCFG_ODT_EN_SHIFT)
#define  IO_PAD2_PIOCFG_ODT_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD2_PIOCFG_ODT_EN_MASK) | (((uint32_t)val) << IO_PAD2_PIOCFG_ODT_EN_SHIFT))

#define  IO_PAD2_PIOCFG_LED_EN_MASK 0x800000
#define  IO_PAD2_PIOCFG_LED_EN_SHIFT 23
#define  IO_PAD2_PIOCFG_LED_EN_MASK_SHIFT(reg) (((reg) & IO_PAD2_PIOCFG_LED_EN_MASK) >> IO_PAD2_PIOCFG_LED_EN_SHIFT)
#define  IO_PAD2_PIOCFG_LED_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD2_PIOCFG_LED_EN_MASK) | (((uint32_t)val) << IO_PAD2_PIOCFG_LED_EN_SHIFT))

#define  IO_PAD2_PIOCFG_I2C_SEL_MASK 0x600000
#define  IO_PAD2_PIOCFG_I2C_SEL_SHIFT 21
#define  IO_PAD2_PIOCFG_I2C_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD2_PIOCFG_I2C_SEL_MASK) >> IO_PAD2_PIOCFG_I2C_SEL_SHIFT)
#define  IO_PAD2_PIOCFG_I2C_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD2_PIOCFG_I2C_SEL_MASK) | (((uint32_t)val) << IO_PAD2_PIOCFG_I2C_SEL_SHIFT))

#define  IO_PAD2_PIOCFG_DGTBSEL_MASK 0x1e0000
#define  IO_PAD2_PIOCFG_DGTBSEL_SHIFT 17
#define  IO_PAD2_PIOCFG_DGTBSEL_MASK_SHIFT(reg) (((reg) & IO_PAD2_PIOCFG_DGTBSEL_MASK) >> IO_PAD2_PIOCFG_DGTBSEL_SHIFT)
#define  IO_PAD2_PIOCFG_DGTBSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD2_PIOCFG_DGTBSEL_MASK) | (((uint32_t)val) << IO_PAD2_PIOCFG_DGTBSEL_SHIFT))

#define  IO_PAD2_PIOCFG_RAWSEL_MASK 0x10000
#define  IO_PAD2_PIOCFG_RAWSEL_SHIFT 16
#define  IO_PAD2_PIOCFG_RAWSEL_MASK_SHIFT(reg) (((reg) & IO_PAD2_PIOCFG_RAWSEL_MASK) >> IO_PAD2_PIOCFG_RAWSEL_SHIFT)
#define  IO_PAD2_PIOCFG_RAWSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD2_PIOCFG_RAWSEL_MASK) | (((uint32_t)val) << IO_PAD2_PIOCFG_RAWSEL_SHIFT))

#define  IO_PAD2_PIOCFG_PULL_SEL_MASK 0x8000
#define  IO_PAD2_PIOCFG_PULL_SEL_SHIFT 15
#define  IO_PAD2_PIOCFG_PULL_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD2_PIOCFG_PULL_SEL_MASK) >> IO_PAD2_PIOCFG_PULL_SEL_SHIFT)
#define  IO_PAD2_PIOCFG_PULL_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD2_PIOCFG_PULL_SEL_MASK) | (((uint32_t)val) << IO_PAD2_PIOCFG_PULL_SEL_SHIFT))

#define  IO_PAD2_PIOCFG_PUEN_MASK 0x4000
#define  IO_PAD2_PIOCFG_PUEN_SHIFT 14
#define  IO_PAD2_PIOCFG_PUEN_MASK_SHIFT(reg) (((reg) & IO_PAD2_PIOCFG_PUEN_MASK) >> IO_PAD2_PIOCFG_PUEN_SHIFT)
#define  IO_PAD2_PIOCFG_PUEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD2_PIOCFG_PUEN_MASK) | (((uint32_t)val) << IO_PAD2_PIOCFG_PUEN_SHIFT))

#define  IO_PAD2_PIOCFG_PDEN_MASK 0x2000
#define  IO_PAD2_PIOCFG_PDEN_SHIFT 13
#define  IO_PAD2_PIOCFG_PDEN_MASK_SHIFT(reg) (((reg) & IO_PAD2_PIOCFG_PDEN_MASK) >> IO_PAD2_PIOCFG_PDEN_SHIFT)
#define  IO_PAD2_PIOCFG_PDEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD2_PIOCFG_PDEN_MASK) | (((uint32_t)val) << IO_PAD2_PIOCFG_PDEN_SHIFT))

#define  IO_PAD2_PIOCFG_SR_MASK 0x1800
#define  IO_PAD2_PIOCFG_SR_SHIFT 11
#define  IO_PAD2_PIOCFG_SR_MASK_SHIFT(reg) (((reg) & IO_PAD2_PIOCFG_SR_MASK) >> IO_PAD2_PIOCFG_SR_SHIFT)
#define  IO_PAD2_PIOCFG_SR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD2_PIOCFG_SR_MASK) | (((uint32_t)val) << IO_PAD2_PIOCFG_SR_SHIFT))

#define  IO_PAD2_PIOCFG_SLP_DI_MASK 0x400
#define  IO_PAD2_PIOCFG_SLP_DI_SHIFT 10
#define  IO_PAD2_PIOCFG_SLP_DI_MASK_SHIFT(reg) (((reg) & IO_PAD2_PIOCFG_SLP_DI_MASK) >> IO_PAD2_PIOCFG_SLP_DI_SHIFT)
#define  IO_PAD2_PIOCFG_SLP_DI_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD2_PIOCFG_SLP_DI_MASK) | (((uint32_t)val) << IO_PAD2_PIOCFG_SLP_DI_SHIFT))

#define  IO_PAD2_PIOCFG_SLP_CNTRL_MASK 0x200
#define  IO_PAD2_PIOCFG_SLP_CNTRL_SHIFT 9
#define  IO_PAD2_PIOCFG_SLP_CNTRL_MASK_SHIFT(reg) (((reg) & IO_PAD2_PIOCFG_SLP_CNTRL_MASK) >> IO_PAD2_PIOCFG_SLP_CNTRL_SHIFT)
#define  IO_PAD2_PIOCFG_SLP_CNTRL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD2_PIOCFG_SLP_CNTRL_MASK) | (((uint32_t)val) << IO_PAD2_PIOCFG_SLP_CNTRL_SHIFT))

#define  IO_PAD2_PIOCFG_SLP_DO_MASK 0x100
#define  IO_PAD2_PIOCFG_SLP_DO_SHIFT 8
#define  IO_PAD2_PIOCFG_SLP_DO_MASK_SHIFT(reg) (((reg) & IO_PAD2_PIOCFG_SLP_DO_MASK) >> IO_PAD2_PIOCFG_SLP_DO_SHIFT)
#define  IO_PAD2_PIOCFG_SLP_DO_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD2_PIOCFG_SLP_DO_MASK) | (((uint32_t)val) << IO_PAD2_PIOCFG_SLP_DO_SHIFT))

#define  IO_PAD2_PIOCFG_SLP_DIR_MASK 0x80
#define  IO_PAD2_PIOCFG_SLP_DIR_SHIFT 7
#define  IO_PAD2_PIOCFG_SLP_DIR_MASK_SHIFT(reg) (((reg) & IO_PAD2_PIOCFG_SLP_DIR_MASK) >> IO_PAD2_PIOCFG_SLP_DIR_SHIFT)
#define  IO_PAD2_PIOCFG_SLP_DIR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD2_PIOCFG_SLP_DIR_MASK) | (((uint32_t)val) << IO_PAD2_PIOCFG_SLP_DIR_SHIFT))

#define  IO_PAD2_PIOCFG_EDGE_EN_N_MASK 0x40
#define  IO_PAD2_PIOCFG_EDGE_EN_N_SHIFT 6
#define  IO_PAD2_PIOCFG_EDGE_EN_N_MASK_SHIFT(reg) (((reg) & IO_PAD2_PIOCFG_EDGE_EN_N_MASK) >> IO_PAD2_PIOCFG_EDGE_EN_N_SHIFT)
#define  IO_PAD2_PIOCFG_EDGE_EN_N_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD2_PIOCFG_EDGE_EN_N_MASK) | (((uint32_t)val) << IO_PAD2_PIOCFG_EDGE_EN_N_SHIFT))

#define  IO_PAD2_PIOCFG_EDGE_FALL_EN_MASK 0x20
#define  IO_PAD2_PIOCFG_EDGE_FALL_EN_SHIFT 5
#define  IO_PAD2_PIOCFG_EDGE_FALL_EN_MASK_SHIFT(reg) (((reg) & IO_PAD2_PIOCFG_EDGE_FALL_EN_MASK) >> IO_PAD2_PIOCFG_EDGE_FALL_EN_SHIFT)
#define  IO_PAD2_PIOCFG_EDGE_FALL_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD2_PIOCFG_EDGE_FALL_EN_MASK) | (((uint32_t)val) << IO_PAD2_PIOCFG_EDGE_FALL_EN_SHIFT))

#define  IO_PAD2_PIOCFG_EDGE_RISE_EN_MASK 0x10
#define  IO_PAD2_PIOCFG_EDGE_RISE_EN_SHIFT 4
#define  IO_PAD2_PIOCFG_EDGE_RISE_EN_MASK_SHIFT(reg) (((reg) & IO_PAD2_PIOCFG_EDGE_RISE_EN_MASK) >> IO_PAD2_PIOCFG_EDGE_RISE_EN_SHIFT)
#define  IO_PAD2_PIOCFG_EDGE_RISE_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD2_PIOCFG_EDGE_RISE_EN_MASK) | (((uint32_t)val) << IO_PAD2_PIOCFG_EDGE_RISE_EN_SHIFT))

#define  IO_PAD2_PIOCFG_SLP_SEL_MASK 0x8
#define  IO_PAD2_PIOCFG_SLP_SEL_SHIFT 3
#define  IO_PAD2_PIOCFG_SLP_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD2_PIOCFG_SLP_SEL_MASK) >> IO_PAD2_PIOCFG_SLP_SEL_SHIFT)
#define  IO_PAD2_PIOCFG_SLP_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD2_PIOCFG_SLP_SEL_MASK) | (((uint32_t)val) << IO_PAD2_PIOCFG_SLP_SEL_SHIFT))

#define  IO_PAD2_PIOCFG_FUNC_SEL_MASK 0x7
#define  IO_PAD2_PIOCFG_FUNC_SEL_SHIFT 0
#define  IO_PAD2_PIOCFG_FUNC_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD2_PIOCFG_FUNC_SEL_MASK) >> IO_PAD2_PIOCFG_FUNC_SEL_SHIFT)
#define  IO_PAD2_PIOCFG_FUNC_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD2_PIOCFG_FUNC_SEL_MASK) | (((uint32_t)val) << IO_PAD2_PIOCFG_FUNC_SEL_SHIFT))

//====================================================================
//
//Register File: IO_PAD3 Configuration Registers (IO_PAD3)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

//====================================================================
//Register: IO_PAD3 Configuration Register (PIOCFG)
/** \brief "PHI_PADXDC_SRC" Pad*/
//====================================================================

#define  IO_PAD3_PIOCFG_RESERVED1_MASK 0xfc000000
#define  IO_PAD3_PIOCFG_RESERVED1_SHIFT 26
#define  IO_PAD3_PIOCFG_RESERVED1_MASK_SHIFT(reg) (((reg) & IO_PAD3_PIOCFG_RESERVED1_MASK) >> IO_PAD3_PIOCFG_RESERVED1_SHIFT)
#define  IO_PAD3_PIOCFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD3_PIOCFG_RESERVED1_MASK) | (((uint32_t)val) << IO_PAD3_PIOCFG_RESERVED1_SHIFT))

#define  IO_PAD3_PIOCFG_PD_MASK 0x2000000
#define  IO_PAD3_PIOCFG_PD_SHIFT 25
#define  IO_PAD3_PIOCFG_PD_MASK_SHIFT(reg) (((reg) & IO_PAD3_PIOCFG_PD_MASK) >> IO_PAD3_PIOCFG_PD_SHIFT)
#define  IO_PAD3_PIOCFG_PD_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD3_PIOCFG_PD_MASK) | (((uint32_t)val) << IO_PAD3_PIOCFG_PD_SHIFT))

#define  IO_PAD3_PIOCFG_ODT_EN_MASK 0x1000000
#define  IO_PAD3_PIOCFG_ODT_EN_SHIFT 24
#define  IO_PAD3_PIOCFG_ODT_EN_MASK_SHIFT(reg) (((reg) & IO_PAD3_PIOCFG_ODT_EN_MASK) >> IO_PAD3_PIOCFG_ODT_EN_SHIFT)
#define  IO_PAD3_PIOCFG_ODT_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD3_PIOCFG_ODT_EN_MASK) | (((uint32_t)val) << IO_PAD3_PIOCFG_ODT_EN_SHIFT))

#define  IO_PAD3_PIOCFG_LED_EN_MASK 0x800000
#define  IO_PAD3_PIOCFG_LED_EN_SHIFT 23
#define  IO_PAD3_PIOCFG_LED_EN_MASK_SHIFT(reg) (((reg) & IO_PAD3_PIOCFG_LED_EN_MASK) >> IO_PAD3_PIOCFG_LED_EN_SHIFT)
#define  IO_PAD3_PIOCFG_LED_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD3_PIOCFG_LED_EN_MASK) | (((uint32_t)val) << IO_PAD3_PIOCFG_LED_EN_SHIFT))

#define  IO_PAD3_PIOCFG_I2C_SEL_MASK 0x600000
#define  IO_PAD3_PIOCFG_I2C_SEL_SHIFT 21
#define  IO_PAD3_PIOCFG_I2C_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD3_PIOCFG_I2C_SEL_MASK) >> IO_PAD3_PIOCFG_I2C_SEL_SHIFT)
#define  IO_PAD3_PIOCFG_I2C_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD3_PIOCFG_I2C_SEL_MASK) | (((uint32_t)val) << IO_PAD3_PIOCFG_I2C_SEL_SHIFT))

#define  IO_PAD3_PIOCFG_DGTBSEL_MASK 0x1e0000
#define  IO_PAD3_PIOCFG_DGTBSEL_SHIFT 17
#define  IO_PAD3_PIOCFG_DGTBSEL_MASK_SHIFT(reg) (((reg) & IO_PAD3_PIOCFG_DGTBSEL_MASK) >> IO_PAD3_PIOCFG_DGTBSEL_SHIFT)
#define  IO_PAD3_PIOCFG_DGTBSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD3_PIOCFG_DGTBSEL_MASK) | (((uint32_t)val) << IO_PAD3_PIOCFG_DGTBSEL_SHIFT))

#define  IO_PAD3_PIOCFG_RAWSEL_MASK 0x10000
#define  IO_PAD3_PIOCFG_RAWSEL_SHIFT 16
#define  IO_PAD3_PIOCFG_RAWSEL_MASK_SHIFT(reg) (((reg) & IO_PAD3_PIOCFG_RAWSEL_MASK) >> IO_PAD3_PIOCFG_RAWSEL_SHIFT)
#define  IO_PAD3_PIOCFG_RAWSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD3_PIOCFG_RAWSEL_MASK) | (((uint32_t)val) << IO_PAD3_PIOCFG_RAWSEL_SHIFT))

#define  IO_PAD3_PIOCFG_PULL_SEL_MASK 0x8000
#define  IO_PAD3_PIOCFG_PULL_SEL_SHIFT 15
#define  IO_PAD3_PIOCFG_PULL_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD3_PIOCFG_PULL_SEL_MASK) >> IO_PAD3_PIOCFG_PULL_SEL_SHIFT)
#define  IO_PAD3_PIOCFG_PULL_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD3_PIOCFG_PULL_SEL_MASK) | (((uint32_t)val) << IO_PAD3_PIOCFG_PULL_SEL_SHIFT))

#define  IO_PAD3_PIOCFG_PUEN_MASK 0x4000
#define  IO_PAD3_PIOCFG_PUEN_SHIFT 14
#define  IO_PAD3_PIOCFG_PUEN_MASK_SHIFT(reg) (((reg) & IO_PAD3_PIOCFG_PUEN_MASK) >> IO_PAD3_PIOCFG_PUEN_SHIFT)
#define  IO_PAD3_PIOCFG_PUEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD3_PIOCFG_PUEN_MASK) | (((uint32_t)val) << IO_PAD3_PIOCFG_PUEN_SHIFT))

#define  IO_PAD3_PIOCFG_PDEN_MASK 0x2000
#define  IO_PAD3_PIOCFG_PDEN_SHIFT 13
#define  IO_PAD3_PIOCFG_PDEN_MASK_SHIFT(reg) (((reg) & IO_PAD3_PIOCFG_PDEN_MASK) >> IO_PAD3_PIOCFG_PDEN_SHIFT)
#define  IO_PAD3_PIOCFG_PDEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD3_PIOCFG_PDEN_MASK) | (((uint32_t)val) << IO_PAD3_PIOCFG_PDEN_SHIFT))

#define  IO_PAD3_PIOCFG_SR_MASK 0x1800
#define  IO_PAD3_PIOCFG_SR_SHIFT 11
#define  IO_PAD3_PIOCFG_SR_MASK_SHIFT(reg) (((reg) & IO_PAD3_PIOCFG_SR_MASK) >> IO_PAD3_PIOCFG_SR_SHIFT)
#define  IO_PAD3_PIOCFG_SR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD3_PIOCFG_SR_MASK) | (((uint32_t)val) << IO_PAD3_PIOCFG_SR_SHIFT))

#define  IO_PAD3_PIOCFG_SLP_DI_MASK 0x400
#define  IO_PAD3_PIOCFG_SLP_DI_SHIFT 10
#define  IO_PAD3_PIOCFG_SLP_DI_MASK_SHIFT(reg) (((reg) & IO_PAD3_PIOCFG_SLP_DI_MASK) >> IO_PAD3_PIOCFG_SLP_DI_SHIFT)
#define  IO_PAD3_PIOCFG_SLP_DI_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD3_PIOCFG_SLP_DI_MASK) | (((uint32_t)val) << IO_PAD3_PIOCFG_SLP_DI_SHIFT))

#define  IO_PAD3_PIOCFG_SLP_CNTRL_MASK 0x200
#define  IO_PAD3_PIOCFG_SLP_CNTRL_SHIFT 9
#define  IO_PAD3_PIOCFG_SLP_CNTRL_MASK_SHIFT(reg) (((reg) & IO_PAD3_PIOCFG_SLP_CNTRL_MASK) >> IO_PAD3_PIOCFG_SLP_CNTRL_SHIFT)
#define  IO_PAD3_PIOCFG_SLP_CNTRL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD3_PIOCFG_SLP_CNTRL_MASK) | (((uint32_t)val) << IO_PAD3_PIOCFG_SLP_CNTRL_SHIFT))

#define  IO_PAD3_PIOCFG_SLP_DO_MASK 0x100
#define  IO_PAD3_PIOCFG_SLP_DO_SHIFT 8
#define  IO_PAD3_PIOCFG_SLP_DO_MASK_SHIFT(reg) (((reg) & IO_PAD3_PIOCFG_SLP_DO_MASK) >> IO_PAD3_PIOCFG_SLP_DO_SHIFT)
#define  IO_PAD3_PIOCFG_SLP_DO_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD3_PIOCFG_SLP_DO_MASK) | (((uint32_t)val) << IO_PAD3_PIOCFG_SLP_DO_SHIFT))

#define  IO_PAD3_PIOCFG_SLP_DIR_MASK 0x80
#define  IO_PAD3_PIOCFG_SLP_DIR_SHIFT 7
#define  IO_PAD3_PIOCFG_SLP_DIR_MASK_SHIFT(reg) (((reg) & IO_PAD3_PIOCFG_SLP_DIR_MASK) >> IO_PAD3_PIOCFG_SLP_DIR_SHIFT)
#define  IO_PAD3_PIOCFG_SLP_DIR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD3_PIOCFG_SLP_DIR_MASK) | (((uint32_t)val) << IO_PAD3_PIOCFG_SLP_DIR_SHIFT))

#define  IO_PAD3_PIOCFG_EDGE_EN_N_MASK 0x40
#define  IO_PAD3_PIOCFG_EDGE_EN_N_SHIFT 6
#define  IO_PAD3_PIOCFG_EDGE_EN_N_MASK_SHIFT(reg) (((reg) & IO_PAD3_PIOCFG_EDGE_EN_N_MASK) >> IO_PAD3_PIOCFG_EDGE_EN_N_SHIFT)
#define  IO_PAD3_PIOCFG_EDGE_EN_N_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD3_PIOCFG_EDGE_EN_N_MASK) | (((uint32_t)val) << IO_PAD3_PIOCFG_EDGE_EN_N_SHIFT))

#define  IO_PAD3_PIOCFG_EDGE_FALL_EN_MASK 0x20
#define  IO_PAD3_PIOCFG_EDGE_FALL_EN_SHIFT 5
#define  IO_PAD3_PIOCFG_EDGE_FALL_EN_MASK_SHIFT(reg) (((reg) & IO_PAD3_PIOCFG_EDGE_FALL_EN_MASK) >> IO_PAD3_PIOCFG_EDGE_FALL_EN_SHIFT)
#define  IO_PAD3_PIOCFG_EDGE_FALL_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD3_PIOCFG_EDGE_FALL_EN_MASK) | (((uint32_t)val) << IO_PAD3_PIOCFG_EDGE_FALL_EN_SHIFT))

#define  IO_PAD3_PIOCFG_EDGE_RISE_EN_MASK 0x10
#define  IO_PAD3_PIOCFG_EDGE_RISE_EN_SHIFT 4
#define  IO_PAD3_PIOCFG_EDGE_RISE_EN_MASK_SHIFT(reg) (((reg) & IO_PAD3_PIOCFG_EDGE_RISE_EN_MASK) >> IO_PAD3_PIOCFG_EDGE_RISE_EN_SHIFT)
#define  IO_PAD3_PIOCFG_EDGE_RISE_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD3_PIOCFG_EDGE_RISE_EN_MASK) | (((uint32_t)val) << IO_PAD3_PIOCFG_EDGE_RISE_EN_SHIFT))

#define  IO_PAD3_PIOCFG_SLP_SEL_MASK 0x8
#define  IO_PAD3_PIOCFG_SLP_SEL_SHIFT 3
#define  IO_PAD3_PIOCFG_SLP_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD3_PIOCFG_SLP_SEL_MASK) >> IO_PAD3_PIOCFG_SLP_SEL_SHIFT)
#define  IO_PAD3_PIOCFG_SLP_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD3_PIOCFG_SLP_SEL_MASK) | (((uint32_t)val) << IO_PAD3_PIOCFG_SLP_SEL_SHIFT))

#define  IO_PAD3_PIOCFG_FUNC_SEL_MASK 0x7
#define  IO_PAD3_PIOCFG_FUNC_SEL_SHIFT 0
#define  IO_PAD3_PIOCFG_FUNC_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD3_PIOCFG_FUNC_SEL_MASK) >> IO_PAD3_PIOCFG_FUNC_SEL_SHIFT)
#define  IO_PAD3_PIOCFG_FUNC_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD3_PIOCFG_FUNC_SEL_MASK) | (((uint32_t)val) << IO_PAD3_PIOCFG_FUNC_SEL_SHIFT))

//====================================================================
//
//Register File: IO_PAD4 Configuration Registers (IO_PAD4)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

//====================================================================
//Register: IO_PAD4 Configuration Register (PIOCFG)
/** \brief "PHI_PADXDC_SRC" Pad*/
//====================================================================

#define  IO_PAD4_PIOCFG_RESERVED1_MASK 0xfc000000
#define  IO_PAD4_PIOCFG_RESERVED1_SHIFT 26
#define  IO_PAD4_PIOCFG_RESERVED1_MASK_SHIFT(reg) (((reg) & IO_PAD4_PIOCFG_RESERVED1_MASK) >> IO_PAD4_PIOCFG_RESERVED1_SHIFT)
#define  IO_PAD4_PIOCFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD4_PIOCFG_RESERVED1_MASK) | (((uint32_t)val) << IO_PAD4_PIOCFG_RESERVED1_SHIFT))

#define  IO_PAD4_PIOCFG_PD_MASK 0x2000000
#define  IO_PAD4_PIOCFG_PD_SHIFT 25
#define  IO_PAD4_PIOCFG_PD_MASK_SHIFT(reg) (((reg) & IO_PAD4_PIOCFG_PD_MASK) >> IO_PAD4_PIOCFG_PD_SHIFT)
#define  IO_PAD4_PIOCFG_PD_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD4_PIOCFG_PD_MASK) | (((uint32_t)val) << IO_PAD4_PIOCFG_PD_SHIFT))

#define  IO_PAD4_PIOCFG_ODT_EN_MASK 0x1000000
#define  IO_PAD4_PIOCFG_ODT_EN_SHIFT 24
#define  IO_PAD4_PIOCFG_ODT_EN_MASK_SHIFT(reg) (((reg) & IO_PAD4_PIOCFG_ODT_EN_MASK) >> IO_PAD4_PIOCFG_ODT_EN_SHIFT)
#define  IO_PAD4_PIOCFG_ODT_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD4_PIOCFG_ODT_EN_MASK) | (((uint32_t)val) << IO_PAD4_PIOCFG_ODT_EN_SHIFT))

#define  IO_PAD4_PIOCFG_LED_EN_MASK 0x800000
#define  IO_PAD4_PIOCFG_LED_EN_SHIFT 23
#define  IO_PAD4_PIOCFG_LED_EN_MASK_SHIFT(reg) (((reg) & IO_PAD4_PIOCFG_LED_EN_MASK) >> IO_PAD4_PIOCFG_LED_EN_SHIFT)
#define  IO_PAD4_PIOCFG_LED_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD4_PIOCFG_LED_EN_MASK) | (((uint32_t)val) << IO_PAD4_PIOCFG_LED_EN_SHIFT))

#define  IO_PAD4_PIOCFG_I2C_SEL_MASK 0x600000
#define  IO_PAD4_PIOCFG_I2C_SEL_SHIFT 21
#define  IO_PAD4_PIOCFG_I2C_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD4_PIOCFG_I2C_SEL_MASK) >> IO_PAD4_PIOCFG_I2C_SEL_SHIFT)
#define  IO_PAD4_PIOCFG_I2C_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD4_PIOCFG_I2C_SEL_MASK) | (((uint32_t)val) << IO_PAD4_PIOCFG_I2C_SEL_SHIFT))

#define  IO_PAD4_PIOCFG_DGTBSEL_MASK 0x1e0000
#define  IO_PAD4_PIOCFG_DGTBSEL_SHIFT 17
#define  IO_PAD4_PIOCFG_DGTBSEL_MASK_SHIFT(reg) (((reg) & IO_PAD4_PIOCFG_DGTBSEL_MASK) >> IO_PAD4_PIOCFG_DGTBSEL_SHIFT)
#define  IO_PAD4_PIOCFG_DGTBSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD4_PIOCFG_DGTBSEL_MASK) | (((uint32_t)val) << IO_PAD4_PIOCFG_DGTBSEL_SHIFT))

#define  IO_PAD4_PIOCFG_RAWSEL_MASK 0x10000
#define  IO_PAD4_PIOCFG_RAWSEL_SHIFT 16
#define  IO_PAD4_PIOCFG_RAWSEL_MASK_SHIFT(reg) (((reg) & IO_PAD4_PIOCFG_RAWSEL_MASK) >> IO_PAD4_PIOCFG_RAWSEL_SHIFT)
#define  IO_PAD4_PIOCFG_RAWSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD4_PIOCFG_RAWSEL_MASK) | (((uint32_t)val) << IO_PAD4_PIOCFG_RAWSEL_SHIFT))

#define  IO_PAD4_PIOCFG_PULL_SEL_MASK 0x8000
#define  IO_PAD4_PIOCFG_PULL_SEL_SHIFT 15
#define  IO_PAD4_PIOCFG_PULL_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD4_PIOCFG_PULL_SEL_MASK) >> IO_PAD4_PIOCFG_PULL_SEL_SHIFT)
#define  IO_PAD4_PIOCFG_PULL_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD4_PIOCFG_PULL_SEL_MASK) | (((uint32_t)val) << IO_PAD4_PIOCFG_PULL_SEL_SHIFT))

#define  IO_PAD4_PIOCFG_PUEN_MASK 0x4000
#define  IO_PAD4_PIOCFG_PUEN_SHIFT 14
#define  IO_PAD4_PIOCFG_PUEN_MASK_SHIFT(reg) (((reg) & IO_PAD4_PIOCFG_PUEN_MASK) >> IO_PAD4_PIOCFG_PUEN_SHIFT)
#define  IO_PAD4_PIOCFG_PUEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD4_PIOCFG_PUEN_MASK) | (((uint32_t)val) << IO_PAD4_PIOCFG_PUEN_SHIFT))

#define  IO_PAD4_PIOCFG_PDEN_MASK 0x2000
#define  IO_PAD4_PIOCFG_PDEN_SHIFT 13
#define  IO_PAD4_PIOCFG_PDEN_MASK_SHIFT(reg) (((reg) & IO_PAD4_PIOCFG_PDEN_MASK) >> IO_PAD4_PIOCFG_PDEN_SHIFT)
#define  IO_PAD4_PIOCFG_PDEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD4_PIOCFG_PDEN_MASK) | (((uint32_t)val) << IO_PAD4_PIOCFG_PDEN_SHIFT))

#define  IO_PAD4_PIOCFG_SR_MASK 0x1800
#define  IO_PAD4_PIOCFG_SR_SHIFT 11
#define  IO_PAD4_PIOCFG_SR_MASK_SHIFT(reg) (((reg) & IO_PAD4_PIOCFG_SR_MASK) >> IO_PAD4_PIOCFG_SR_SHIFT)
#define  IO_PAD4_PIOCFG_SR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD4_PIOCFG_SR_MASK) | (((uint32_t)val) << IO_PAD4_PIOCFG_SR_SHIFT))

#define  IO_PAD4_PIOCFG_SLP_DI_MASK 0x400
#define  IO_PAD4_PIOCFG_SLP_DI_SHIFT 10
#define  IO_PAD4_PIOCFG_SLP_DI_MASK_SHIFT(reg) (((reg) & IO_PAD4_PIOCFG_SLP_DI_MASK) >> IO_PAD4_PIOCFG_SLP_DI_SHIFT)
#define  IO_PAD4_PIOCFG_SLP_DI_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD4_PIOCFG_SLP_DI_MASK) | (((uint32_t)val) << IO_PAD4_PIOCFG_SLP_DI_SHIFT))

#define  IO_PAD4_PIOCFG_SLP_CNTRL_MASK 0x200
#define  IO_PAD4_PIOCFG_SLP_CNTRL_SHIFT 9
#define  IO_PAD4_PIOCFG_SLP_CNTRL_MASK_SHIFT(reg) (((reg) & IO_PAD4_PIOCFG_SLP_CNTRL_MASK) >> IO_PAD4_PIOCFG_SLP_CNTRL_SHIFT)
#define  IO_PAD4_PIOCFG_SLP_CNTRL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD4_PIOCFG_SLP_CNTRL_MASK) | (((uint32_t)val) << IO_PAD4_PIOCFG_SLP_CNTRL_SHIFT))

#define  IO_PAD4_PIOCFG_SLP_DO_MASK 0x100
#define  IO_PAD4_PIOCFG_SLP_DO_SHIFT 8
#define  IO_PAD4_PIOCFG_SLP_DO_MASK_SHIFT(reg) (((reg) & IO_PAD4_PIOCFG_SLP_DO_MASK) >> IO_PAD4_PIOCFG_SLP_DO_SHIFT)
#define  IO_PAD4_PIOCFG_SLP_DO_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD4_PIOCFG_SLP_DO_MASK) | (((uint32_t)val) << IO_PAD4_PIOCFG_SLP_DO_SHIFT))

#define  IO_PAD4_PIOCFG_SLP_DIR_MASK 0x80
#define  IO_PAD4_PIOCFG_SLP_DIR_SHIFT 7
#define  IO_PAD4_PIOCFG_SLP_DIR_MASK_SHIFT(reg) (((reg) & IO_PAD4_PIOCFG_SLP_DIR_MASK) >> IO_PAD4_PIOCFG_SLP_DIR_SHIFT)
#define  IO_PAD4_PIOCFG_SLP_DIR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD4_PIOCFG_SLP_DIR_MASK) | (((uint32_t)val) << IO_PAD4_PIOCFG_SLP_DIR_SHIFT))

#define  IO_PAD4_PIOCFG_EDGE_EN_N_MASK 0x40
#define  IO_PAD4_PIOCFG_EDGE_EN_N_SHIFT 6
#define  IO_PAD4_PIOCFG_EDGE_EN_N_MASK_SHIFT(reg) (((reg) & IO_PAD4_PIOCFG_EDGE_EN_N_MASK) >> IO_PAD4_PIOCFG_EDGE_EN_N_SHIFT)
#define  IO_PAD4_PIOCFG_EDGE_EN_N_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD4_PIOCFG_EDGE_EN_N_MASK) | (((uint32_t)val) << IO_PAD4_PIOCFG_EDGE_EN_N_SHIFT))

#define  IO_PAD4_PIOCFG_EDGE_FALL_EN_MASK 0x20
#define  IO_PAD4_PIOCFG_EDGE_FALL_EN_SHIFT 5
#define  IO_PAD4_PIOCFG_EDGE_FALL_EN_MASK_SHIFT(reg) (((reg) & IO_PAD4_PIOCFG_EDGE_FALL_EN_MASK) >> IO_PAD4_PIOCFG_EDGE_FALL_EN_SHIFT)
#define  IO_PAD4_PIOCFG_EDGE_FALL_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD4_PIOCFG_EDGE_FALL_EN_MASK) | (((uint32_t)val) << IO_PAD4_PIOCFG_EDGE_FALL_EN_SHIFT))

#define  IO_PAD4_PIOCFG_EDGE_RISE_EN_MASK 0x10
#define  IO_PAD4_PIOCFG_EDGE_RISE_EN_SHIFT 4
#define  IO_PAD4_PIOCFG_EDGE_RISE_EN_MASK_SHIFT(reg) (((reg) & IO_PAD4_PIOCFG_EDGE_RISE_EN_MASK) >> IO_PAD4_PIOCFG_EDGE_RISE_EN_SHIFT)
#define  IO_PAD4_PIOCFG_EDGE_RISE_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD4_PIOCFG_EDGE_RISE_EN_MASK) | (((uint32_t)val) << IO_PAD4_PIOCFG_EDGE_RISE_EN_SHIFT))

#define  IO_PAD4_PIOCFG_SLP_SEL_MASK 0x8
#define  IO_PAD4_PIOCFG_SLP_SEL_SHIFT 3
#define  IO_PAD4_PIOCFG_SLP_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD4_PIOCFG_SLP_SEL_MASK) >> IO_PAD4_PIOCFG_SLP_SEL_SHIFT)
#define  IO_PAD4_PIOCFG_SLP_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD4_PIOCFG_SLP_SEL_MASK) | (((uint32_t)val) << IO_PAD4_PIOCFG_SLP_SEL_SHIFT))

#define  IO_PAD4_PIOCFG_FUNC_SEL_MASK 0x7
#define  IO_PAD4_PIOCFG_FUNC_SEL_SHIFT 0
#define  IO_PAD4_PIOCFG_FUNC_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD4_PIOCFG_FUNC_SEL_MASK) >> IO_PAD4_PIOCFG_FUNC_SEL_SHIFT)
#define  IO_PAD4_PIOCFG_FUNC_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD4_PIOCFG_FUNC_SEL_MASK) | (((uint32_t)val) << IO_PAD4_PIOCFG_FUNC_SEL_SHIFT))

//====================================================================
//
//Register File: IO_PAD5 Configuration Registers (IO_PAD5)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

//====================================================================
//Register: IO_PAD5 Configuration Register (PIOCFG)
/** \brief "PHI_PADXDC_SRC" Pad*/
//====================================================================

#define  IO_PAD5_PIOCFG_RESERVED1_MASK 0xfc000000
#define  IO_PAD5_PIOCFG_RESERVED1_SHIFT 26
#define  IO_PAD5_PIOCFG_RESERVED1_MASK_SHIFT(reg) (((reg) & IO_PAD5_PIOCFG_RESERVED1_MASK) >> IO_PAD5_PIOCFG_RESERVED1_SHIFT)
#define  IO_PAD5_PIOCFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD5_PIOCFG_RESERVED1_MASK) | (((uint32_t)val) << IO_PAD5_PIOCFG_RESERVED1_SHIFT))

#define  IO_PAD5_PIOCFG_PD_MASK 0x2000000
#define  IO_PAD5_PIOCFG_PD_SHIFT 25
#define  IO_PAD5_PIOCFG_PD_MASK_SHIFT(reg) (((reg) & IO_PAD5_PIOCFG_PD_MASK) >> IO_PAD5_PIOCFG_PD_SHIFT)
#define  IO_PAD5_PIOCFG_PD_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD5_PIOCFG_PD_MASK) | (((uint32_t)val) << IO_PAD5_PIOCFG_PD_SHIFT))

#define  IO_PAD5_PIOCFG_ODT_EN_MASK 0x1000000
#define  IO_PAD5_PIOCFG_ODT_EN_SHIFT 24
#define  IO_PAD5_PIOCFG_ODT_EN_MASK_SHIFT(reg) (((reg) & IO_PAD5_PIOCFG_ODT_EN_MASK) >> IO_PAD5_PIOCFG_ODT_EN_SHIFT)
#define  IO_PAD5_PIOCFG_ODT_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD5_PIOCFG_ODT_EN_MASK) | (((uint32_t)val) << IO_PAD5_PIOCFG_ODT_EN_SHIFT))

#define  IO_PAD5_PIOCFG_LED_EN_MASK 0x800000
#define  IO_PAD5_PIOCFG_LED_EN_SHIFT 23
#define  IO_PAD5_PIOCFG_LED_EN_MASK_SHIFT(reg) (((reg) & IO_PAD5_PIOCFG_LED_EN_MASK) >> IO_PAD5_PIOCFG_LED_EN_SHIFT)
#define  IO_PAD5_PIOCFG_LED_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD5_PIOCFG_LED_EN_MASK) | (((uint32_t)val) << IO_PAD5_PIOCFG_LED_EN_SHIFT))

#define  IO_PAD5_PIOCFG_I2C_SEL_MASK 0x600000
#define  IO_PAD5_PIOCFG_I2C_SEL_SHIFT 21
#define  IO_PAD5_PIOCFG_I2C_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD5_PIOCFG_I2C_SEL_MASK) >> IO_PAD5_PIOCFG_I2C_SEL_SHIFT)
#define  IO_PAD5_PIOCFG_I2C_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD5_PIOCFG_I2C_SEL_MASK) | (((uint32_t)val) << IO_PAD5_PIOCFG_I2C_SEL_SHIFT))

#define  IO_PAD5_PIOCFG_DGTBSEL_MASK 0x1e0000
#define  IO_PAD5_PIOCFG_DGTBSEL_SHIFT 17
#define  IO_PAD5_PIOCFG_DGTBSEL_MASK_SHIFT(reg) (((reg) & IO_PAD5_PIOCFG_DGTBSEL_MASK) >> IO_PAD5_PIOCFG_DGTBSEL_SHIFT)
#define  IO_PAD5_PIOCFG_DGTBSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD5_PIOCFG_DGTBSEL_MASK) | (((uint32_t)val) << IO_PAD5_PIOCFG_DGTBSEL_SHIFT))

#define  IO_PAD5_PIOCFG_RAWSEL_MASK 0x10000
#define  IO_PAD5_PIOCFG_RAWSEL_SHIFT 16
#define  IO_PAD5_PIOCFG_RAWSEL_MASK_SHIFT(reg) (((reg) & IO_PAD5_PIOCFG_RAWSEL_MASK) >> IO_PAD5_PIOCFG_RAWSEL_SHIFT)
#define  IO_PAD5_PIOCFG_RAWSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD5_PIOCFG_RAWSEL_MASK) | (((uint32_t)val) << IO_PAD5_PIOCFG_RAWSEL_SHIFT))

#define  IO_PAD5_PIOCFG_PULL_SEL_MASK 0x8000
#define  IO_PAD5_PIOCFG_PULL_SEL_SHIFT 15
#define  IO_PAD5_PIOCFG_PULL_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD5_PIOCFG_PULL_SEL_MASK) >> IO_PAD5_PIOCFG_PULL_SEL_SHIFT)
#define  IO_PAD5_PIOCFG_PULL_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD5_PIOCFG_PULL_SEL_MASK) | (((uint32_t)val) << IO_PAD5_PIOCFG_PULL_SEL_SHIFT))

#define  IO_PAD5_PIOCFG_PUEN_MASK 0x4000
#define  IO_PAD5_PIOCFG_PUEN_SHIFT 14
#define  IO_PAD5_PIOCFG_PUEN_MASK_SHIFT(reg) (((reg) & IO_PAD5_PIOCFG_PUEN_MASK) >> IO_PAD5_PIOCFG_PUEN_SHIFT)
#define  IO_PAD5_PIOCFG_PUEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD5_PIOCFG_PUEN_MASK) | (((uint32_t)val) << IO_PAD5_PIOCFG_PUEN_SHIFT))

#define  IO_PAD5_PIOCFG_PDEN_MASK 0x2000
#define  IO_PAD5_PIOCFG_PDEN_SHIFT 13
#define  IO_PAD5_PIOCFG_PDEN_MASK_SHIFT(reg) (((reg) & IO_PAD5_PIOCFG_PDEN_MASK) >> IO_PAD5_PIOCFG_PDEN_SHIFT)
#define  IO_PAD5_PIOCFG_PDEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD5_PIOCFG_PDEN_MASK) | (((uint32_t)val) << IO_PAD5_PIOCFG_PDEN_SHIFT))

#define  IO_PAD5_PIOCFG_SR_MASK 0x1800
#define  IO_PAD5_PIOCFG_SR_SHIFT 11
#define  IO_PAD5_PIOCFG_SR_MASK_SHIFT(reg) (((reg) & IO_PAD5_PIOCFG_SR_MASK) >> IO_PAD5_PIOCFG_SR_SHIFT)
#define  IO_PAD5_PIOCFG_SR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD5_PIOCFG_SR_MASK) | (((uint32_t)val) << IO_PAD5_PIOCFG_SR_SHIFT))

#define  IO_PAD5_PIOCFG_SLP_DI_MASK 0x400
#define  IO_PAD5_PIOCFG_SLP_DI_SHIFT 10
#define  IO_PAD5_PIOCFG_SLP_DI_MASK_SHIFT(reg) (((reg) & IO_PAD5_PIOCFG_SLP_DI_MASK) >> IO_PAD5_PIOCFG_SLP_DI_SHIFT)
#define  IO_PAD5_PIOCFG_SLP_DI_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD5_PIOCFG_SLP_DI_MASK) | (((uint32_t)val) << IO_PAD5_PIOCFG_SLP_DI_SHIFT))

#define  IO_PAD5_PIOCFG_SLP_CNTRL_MASK 0x200
#define  IO_PAD5_PIOCFG_SLP_CNTRL_SHIFT 9
#define  IO_PAD5_PIOCFG_SLP_CNTRL_MASK_SHIFT(reg) (((reg) & IO_PAD5_PIOCFG_SLP_CNTRL_MASK) >> IO_PAD5_PIOCFG_SLP_CNTRL_SHIFT)
#define  IO_PAD5_PIOCFG_SLP_CNTRL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD5_PIOCFG_SLP_CNTRL_MASK) | (((uint32_t)val) << IO_PAD5_PIOCFG_SLP_CNTRL_SHIFT))

#define  IO_PAD5_PIOCFG_SLP_DO_MASK 0x100
#define  IO_PAD5_PIOCFG_SLP_DO_SHIFT 8
#define  IO_PAD5_PIOCFG_SLP_DO_MASK_SHIFT(reg) (((reg) & IO_PAD5_PIOCFG_SLP_DO_MASK) >> IO_PAD5_PIOCFG_SLP_DO_SHIFT)
#define  IO_PAD5_PIOCFG_SLP_DO_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD5_PIOCFG_SLP_DO_MASK) | (((uint32_t)val) << IO_PAD5_PIOCFG_SLP_DO_SHIFT))

#define  IO_PAD5_PIOCFG_SLP_DIR_MASK 0x80
#define  IO_PAD5_PIOCFG_SLP_DIR_SHIFT 7
#define  IO_PAD5_PIOCFG_SLP_DIR_MASK_SHIFT(reg) (((reg) & IO_PAD5_PIOCFG_SLP_DIR_MASK) >> IO_PAD5_PIOCFG_SLP_DIR_SHIFT)
#define  IO_PAD5_PIOCFG_SLP_DIR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD5_PIOCFG_SLP_DIR_MASK) | (((uint32_t)val) << IO_PAD5_PIOCFG_SLP_DIR_SHIFT))

#define  IO_PAD5_PIOCFG_EDGE_EN_N_MASK 0x40
#define  IO_PAD5_PIOCFG_EDGE_EN_N_SHIFT 6
#define  IO_PAD5_PIOCFG_EDGE_EN_N_MASK_SHIFT(reg) (((reg) & IO_PAD5_PIOCFG_EDGE_EN_N_MASK) >> IO_PAD5_PIOCFG_EDGE_EN_N_SHIFT)
#define  IO_PAD5_PIOCFG_EDGE_EN_N_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD5_PIOCFG_EDGE_EN_N_MASK) | (((uint32_t)val) << IO_PAD5_PIOCFG_EDGE_EN_N_SHIFT))

#define  IO_PAD5_PIOCFG_EDGE_FALL_EN_MASK 0x20
#define  IO_PAD5_PIOCFG_EDGE_FALL_EN_SHIFT 5
#define  IO_PAD5_PIOCFG_EDGE_FALL_EN_MASK_SHIFT(reg) (((reg) & IO_PAD5_PIOCFG_EDGE_FALL_EN_MASK) >> IO_PAD5_PIOCFG_EDGE_FALL_EN_SHIFT)
#define  IO_PAD5_PIOCFG_EDGE_FALL_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD5_PIOCFG_EDGE_FALL_EN_MASK) | (((uint32_t)val) << IO_PAD5_PIOCFG_EDGE_FALL_EN_SHIFT))

#define  IO_PAD5_PIOCFG_EDGE_RISE_EN_MASK 0x10
#define  IO_PAD5_PIOCFG_EDGE_RISE_EN_SHIFT 4
#define  IO_PAD5_PIOCFG_EDGE_RISE_EN_MASK_SHIFT(reg) (((reg) & IO_PAD5_PIOCFG_EDGE_RISE_EN_MASK) >> IO_PAD5_PIOCFG_EDGE_RISE_EN_SHIFT)
#define  IO_PAD5_PIOCFG_EDGE_RISE_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD5_PIOCFG_EDGE_RISE_EN_MASK) | (((uint32_t)val) << IO_PAD5_PIOCFG_EDGE_RISE_EN_SHIFT))

#define  IO_PAD5_PIOCFG_SLP_SEL_MASK 0x8
#define  IO_PAD5_PIOCFG_SLP_SEL_SHIFT 3
#define  IO_PAD5_PIOCFG_SLP_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD5_PIOCFG_SLP_SEL_MASK) >> IO_PAD5_PIOCFG_SLP_SEL_SHIFT)
#define  IO_PAD5_PIOCFG_SLP_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD5_PIOCFG_SLP_SEL_MASK) | (((uint32_t)val) << IO_PAD5_PIOCFG_SLP_SEL_SHIFT))

#define  IO_PAD5_PIOCFG_FUNC_SEL_MASK 0x7
#define  IO_PAD5_PIOCFG_FUNC_SEL_SHIFT 0
#define  IO_PAD5_PIOCFG_FUNC_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD5_PIOCFG_FUNC_SEL_MASK) >> IO_PAD5_PIOCFG_FUNC_SEL_SHIFT)
#define  IO_PAD5_PIOCFG_FUNC_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD5_PIOCFG_FUNC_SEL_MASK) | (((uint32_t)val) << IO_PAD5_PIOCFG_FUNC_SEL_SHIFT))

//====================================================================
//
//Register File: IO_PAD6 Configuration Registers (IO_PAD6)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

//====================================================================
//Register: IO_PAD6 Configuration Register (PIOCFG)
/** \brief "PHI_PADXDC_SRC" Pad*/
//====================================================================

#define  IO_PAD6_PIOCFG_RESERVED1_MASK 0xfc000000
#define  IO_PAD6_PIOCFG_RESERVED1_SHIFT 26
#define  IO_PAD6_PIOCFG_RESERVED1_MASK_SHIFT(reg) (((reg) & IO_PAD6_PIOCFG_RESERVED1_MASK) >> IO_PAD6_PIOCFG_RESERVED1_SHIFT)
#define  IO_PAD6_PIOCFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD6_PIOCFG_RESERVED1_MASK) | (((uint32_t)val) << IO_PAD6_PIOCFG_RESERVED1_SHIFT))

#define  IO_PAD6_PIOCFG_PD_MASK 0x2000000
#define  IO_PAD6_PIOCFG_PD_SHIFT 25
#define  IO_PAD6_PIOCFG_PD_MASK_SHIFT(reg) (((reg) & IO_PAD6_PIOCFG_PD_MASK) >> IO_PAD6_PIOCFG_PD_SHIFT)
#define  IO_PAD6_PIOCFG_PD_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD6_PIOCFG_PD_MASK) | (((uint32_t)val) << IO_PAD6_PIOCFG_PD_SHIFT))

#define  IO_PAD6_PIOCFG_ODT_EN_MASK 0x1000000
#define  IO_PAD6_PIOCFG_ODT_EN_SHIFT 24
#define  IO_PAD6_PIOCFG_ODT_EN_MASK_SHIFT(reg) (((reg) & IO_PAD6_PIOCFG_ODT_EN_MASK) >> IO_PAD6_PIOCFG_ODT_EN_SHIFT)
#define  IO_PAD6_PIOCFG_ODT_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD6_PIOCFG_ODT_EN_MASK) | (((uint32_t)val) << IO_PAD6_PIOCFG_ODT_EN_SHIFT))

#define  IO_PAD6_PIOCFG_LED_EN_MASK 0x800000
#define  IO_PAD6_PIOCFG_LED_EN_SHIFT 23
#define  IO_PAD6_PIOCFG_LED_EN_MASK_SHIFT(reg) (((reg) & IO_PAD6_PIOCFG_LED_EN_MASK) >> IO_PAD6_PIOCFG_LED_EN_SHIFT)
#define  IO_PAD6_PIOCFG_LED_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD6_PIOCFG_LED_EN_MASK) | (((uint32_t)val) << IO_PAD6_PIOCFG_LED_EN_SHIFT))

#define  IO_PAD6_PIOCFG_I2C_SEL_MASK 0x600000
#define  IO_PAD6_PIOCFG_I2C_SEL_SHIFT 21
#define  IO_PAD6_PIOCFG_I2C_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD6_PIOCFG_I2C_SEL_MASK) >> IO_PAD6_PIOCFG_I2C_SEL_SHIFT)
#define  IO_PAD6_PIOCFG_I2C_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD6_PIOCFG_I2C_SEL_MASK) | (((uint32_t)val) << IO_PAD6_PIOCFG_I2C_SEL_SHIFT))

#define  IO_PAD6_PIOCFG_DGTBSEL_MASK 0x1e0000
#define  IO_PAD6_PIOCFG_DGTBSEL_SHIFT 17
#define  IO_PAD6_PIOCFG_DGTBSEL_MASK_SHIFT(reg) (((reg) & IO_PAD6_PIOCFG_DGTBSEL_MASK) >> IO_PAD6_PIOCFG_DGTBSEL_SHIFT)
#define  IO_PAD6_PIOCFG_DGTBSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD6_PIOCFG_DGTBSEL_MASK) | (((uint32_t)val) << IO_PAD6_PIOCFG_DGTBSEL_SHIFT))

#define  IO_PAD6_PIOCFG_RAWSEL_MASK 0x10000
#define  IO_PAD6_PIOCFG_RAWSEL_SHIFT 16
#define  IO_PAD6_PIOCFG_RAWSEL_MASK_SHIFT(reg) (((reg) & IO_PAD6_PIOCFG_RAWSEL_MASK) >> IO_PAD6_PIOCFG_RAWSEL_SHIFT)
#define  IO_PAD6_PIOCFG_RAWSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD6_PIOCFG_RAWSEL_MASK) | (((uint32_t)val) << IO_PAD6_PIOCFG_RAWSEL_SHIFT))

#define  IO_PAD6_PIOCFG_PULL_SEL_MASK 0x8000
#define  IO_PAD6_PIOCFG_PULL_SEL_SHIFT 15
#define  IO_PAD6_PIOCFG_PULL_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD6_PIOCFG_PULL_SEL_MASK) >> IO_PAD6_PIOCFG_PULL_SEL_SHIFT)
#define  IO_PAD6_PIOCFG_PULL_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD6_PIOCFG_PULL_SEL_MASK) | (((uint32_t)val) << IO_PAD6_PIOCFG_PULL_SEL_SHIFT))

#define  IO_PAD6_PIOCFG_PUEN_MASK 0x4000
#define  IO_PAD6_PIOCFG_PUEN_SHIFT 14
#define  IO_PAD6_PIOCFG_PUEN_MASK_SHIFT(reg) (((reg) & IO_PAD6_PIOCFG_PUEN_MASK) >> IO_PAD6_PIOCFG_PUEN_SHIFT)
#define  IO_PAD6_PIOCFG_PUEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD6_PIOCFG_PUEN_MASK) | (((uint32_t)val) << IO_PAD6_PIOCFG_PUEN_SHIFT))

#define  IO_PAD6_PIOCFG_PDEN_MASK 0x2000
#define  IO_PAD6_PIOCFG_PDEN_SHIFT 13
#define  IO_PAD6_PIOCFG_PDEN_MASK_SHIFT(reg) (((reg) & IO_PAD6_PIOCFG_PDEN_MASK) >> IO_PAD6_PIOCFG_PDEN_SHIFT)
#define  IO_PAD6_PIOCFG_PDEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD6_PIOCFG_PDEN_MASK) | (((uint32_t)val) << IO_PAD6_PIOCFG_PDEN_SHIFT))

#define  IO_PAD6_PIOCFG_SR_MASK 0x1800
#define  IO_PAD6_PIOCFG_SR_SHIFT 11
#define  IO_PAD6_PIOCFG_SR_MASK_SHIFT(reg) (((reg) & IO_PAD6_PIOCFG_SR_MASK) >> IO_PAD6_PIOCFG_SR_SHIFT)
#define  IO_PAD6_PIOCFG_SR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD6_PIOCFG_SR_MASK) | (((uint32_t)val) << IO_PAD6_PIOCFG_SR_SHIFT))

#define  IO_PAD6_PIOCFG_SLP_DI_MASK 0x400
#define  IO_PAD6_PIOCFG_SLP_DI_SHIFT 10
#define  IO_PAD6_PIOCFG_SLP_DI_MASK_SHIFT(reg) (((reg) & IO_PAD6_PIOCFG_SLP_DI_MASK) >> IO_PAD6_PIOCFG_SLP_DI_SHIFT)
#define  IO_PAD6_PIOCFG_SLP_DI_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD6_PIOCFG_SLP_DI_MASK) | (((uint32_t)val) << IO_PAD6_PIOCFG_SLP_DI_SHIFT))

#define  IO_PAD6_PIOCFG_SLP_CNTRL_MASK 0x200
#define  IO_PAD6_PIOCFG_SLP_CNTRL_SHIFT 9
#define  IO_PAD6_PIOCFG_SLP_CNTRL_MASK_SHIFT(reg) (((reg) & IO_PAD6_PIOCFG_SLP_CNTRL_MASK) >> IO_PAD6_PIOCFG_SLP_CNTRL_SHIFT)
#define  IO_PAD6_PIOCFG_SLP_CNTRL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD6_PIOCFG_SLP_CNTRL_MASK) | (((uint32_t)val) << IO_PAD6_PIOCFG_SLP_CNTRL_SHIFT))

#define  IO_PAD6_PIOCFG_SLP_DO_MASK 0x100
#define  IO_PAD6_PIOCFG_SLP_DO_SHIFT 8
#define  IO_PAD6_PIOCFG_SLP_DO_MASK_SHIFT(reg) (((reg) & IO_PAD6_PIOCFG_SLP_DO_MASK) >> IO_PAD6_PIOCFG_SLP_DO_SHIFT)
#define  IO_PAD6_PIOCFG_SLP_DO_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD6_PIOCFG_SLP_DO_MASK) | (((uint32_t)val) << IO_PAD6_PIOCFG_SLP_DO_SHIFT))

#define  IO_PAD6_PIOCFG_SLP_DIR_MASK 0x80
#define  IO_PAD6_PIOCFG_SLP_DIR_SHIFT 7
#define  IO_PAD6_PIOCFG_SLP_DIR_MASK_SHIFT(reg) (((reg) & IO_PAD6_PIOCFG_SLP_DIR_MASK) >> IO_PAD6_PIOCFG_SLP_DIR_SHIFT)
#define  IO_PAD6_PIOCFG_SLP_DIR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD6_PIOCFG_SLP_DIR_MASK) | (((uint32_t)val) << IO_PAD6_PIOCFG_SLP_DIR_SHIFT))

#define  IO_PAD6_PIOCFG_EDGE_EN_N_MASK 0x40
#define  IO_PAD6_PIOCFG_EDGE_EN_N_SHIFT 6
#define  IO_PAD6_PIOCFG_EDGE_EN_N_MASK_SHIFT(reg) (((reg) & IO_PAD6_PIOCFG_EDGE_EN_N_MASK) >> IO_PAD6_PIOCFG_EDGE_EN_N_SHIFT)
#define  IO_PAD6_PIOCFG_EDGE_EN_N_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD6_PIOCFG_EDGE_EN_N_MASK) | (((uint32_t)val) << IO_PAD6_PIOCFG_EDGE_EN_N_SHIFT))

#define  IO_PAD6_PIOCFG_EDGE_FALL_EN_MASK 0x20
#define  IO_PAD6_PIOCFG_EDGE_FALL_EN_SHIFT 5
#define  IO_PAD6_PIOCFG_EDGE_FALL_EN_MASK_SHIFT(reg) (((reg) & IO_PAD6_PIOCFG_EDGE_FALL_EN_MASK) >> IO_PAD6_PIOCFG_EDGE_FALL_EN_SHIFT)
#define  IO_PAD6_PIOCFG_EDGE_FALL_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD6_PIOCFG_EDGE_FALL_EN_MASK) | (((uint32_t)val) << IO_PAD6_PIOCFG_EDGE_FALL_EN_SHIFT))

#define  IO_PAD6_PIOCFG_EDGE_RISE_EN_MASK 0x10
#define  IO_PAD6_PIOCFG_EDGE_RISE_EN_SHIFT 4
#define  IO_PAD6_PIOCFG_EDGE_RISE_EN_MASK_SHIFT(reg) (((reg) & IO_PAD6_PIOCFG_EDGE_RISE_EN_MASK) >> IO_PAD6_PIOCFG_EDGE_RISE_EN_SHIFT)
#define  IO_PAD6_PIOCFG_EDGE_RISE_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD6_PIOCFG_EDGE_RISE_EN_MASK) | (((uint32_t)val) << IO_PAD6_PIOCFG_EDGE_RISE_EN_SHIFT))

#define  IO_PAD6_PIOCFG_SLP_SEL_MASK 0x8
#define  IO_PAD6_PIOCFG_SLP_SEL_SHIFT 3
#define  IO_PAD6_PIOCFG_SLP_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD6_PIOCFG_SLP_SEL_MASK) >> IO_PAD6_PIOCFG_SLP_SEL_SHIFT)
#define  IO_PAD6_PIOCFG_SLP_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD6_PIOCFG_SLP_SEL_MASK) | (((uint32_t)val) << IO_PAD6_PIOCFG_SLP_SEL_SHIFT))

#define  IO_PAD6_PIOCFG_FUNC_SEL_MASK 0x7
#define  IO_PAD6_PIOCFG_FUNC_SEL_SHIFT 0
#define  IO_PAD6_PIOCFG_FUNC_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD6_PIOCFG_FUNC_SEL_MASK) >> IO_PAD6_PIOCFG_FUNC_SEL_SHIFT)
#define  IO_PAD6_PIOCFG_FUNC_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD6_PIOCFG_FUNC_SEL_MASK) | (((uint32_t)val) << IO_PAD6_PIOCFG_FUNC_SEL_SHIFT))

//====================================================================
//
//Register File: IO_PAD7 Configuration Registers (IO_PAD7)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

//====================================================================
//Register: IO_PAD7 Configuration Register (PIOCFG)
/** \brief "PHI_PADXDC_SRC" Pad*/
//====================================================================

#define  IO_PAD7_PIOCFG_RESERVED1_MASK 0xfc000000
#define  IO_PAD7_PIOCFG_RESERVED1_SHIFT 26
#define  IO_PAD7_PIOCFG_RESERVED1_MASK_SHIFT(reg) (((reg) & IO_PAD7_PIOCFG_RESERVED1_MASK) >> IO_PAD7_PIOCFG_RESERVED1_SHIFT)
#define  IO_PAD7_PIOCFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD7_PIOCFG_RESERVED1_MASK) | (((uint32_t)val) << IO_PAD7_PIOCFG_RESERVED1_SHIFT))

#define  IO_PAD7_PIOCFG_PD_MASK 0x2000000
#define  IO_PAD7_PIOCFG_PD_SHIFT 25
#define  IO_PAD7_PIOCFG_PD_MASK_SHIFT(reg) (((reg) & IO_PAD7_PIOCFG_PD_MASK) >> IO_PAD7_PIOCFG_PD_SHIFT)
#define  IO_PAD7_PIOCFG_PD_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD7_PIOCFG_PD_MASK) | (((uint32_t)val) << IO_PAD7_PIOCFG_PD_SHIFT))

#define  IO_PAD7_PIOCFG_ODT_EN_MASK 0x1000000
#define  IO_PAD7_PIOCFG_ODT_EN_SHIFT 24
#define  IO_PAD7_PIOCFG_ODT_EN_MASK_SHIFT(reg) (((reg) & IO_PAD7_PIOCFG_ODT_EN_MASK) >> IO_PAD7_PIOCFG_ODT_EN_SHIFT)
#define  IO_PAD7_PIOCFG_ODT_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD7_PIOCFG_ODT_EN_MASK) | (((uint32_t)val) << IO_PAD7_PIOCFG_ODT_EN_SHIFT))

#define  IO_PAD7_PIOCFG_LED_EN_MASK 0x800000
#define  IO_PAD7_PIOCFG_LED_EN_SHIFT 23
#define  IO_PAD7_PIOCFG_LED_EN_MASK_SHIFT(reg) (((reg) & IO_PAD7_PIOCFG_LED_EN_MASK) >> IO_PAD7_PIOCFG_LED_EN_SHIFT)
#define  IO_PAD7_PIOCFG_LED_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD7_PIOCFG_LED_EN_MASK) | (((uint32_t)val) << IO_PAD7_PIOCFG_LED_EN_SHIFT))

#define  IO_PAD7_PIOCFG_I2C_SEL_MASK 0x600000
#define  IO_PAD7_PIOCFG_I2C_SEL_SHIFT 21
#define  IO_PAD7_PIOCFG_I2C_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD7_PIOCFG_I2C_SEL_MASK) >> IO_PAD7_PIOCFG_I2C_SEL_SHIFT)
#define  IO_PAD7_PIOCFG_I2C_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD7_PIOCFG_I2C_SEL_MASK) | (((uint32_t)val) << IO_PAD7_PIOCFG_I2C_SEL_SHIFT))

#define  IO_PAD7_PIOCFG_DGTBSEL_MASK 0x1e0000
#define  IO_PAD7_PIOCFG_DGTBSEL_SHIFT 17
#define  IO_PAD7_PIOCFG_DGTBSEL_MASK_SHIFT(reg) (((reg) & IO_PAD7_PIOCFG_DGTBSEL_MASK) >> IO_PAD7_PIOCFG_DGTBSEL_SHIFT)
#define  IO_PAD7_PIOCFG_DGTBSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD7_PIOCFG_DGTBSEL_MASK) | (((uint32_t)val) << IO_PAD7_PIOCFG_DGTBSEL_SHIFT))

#define  IO_PAD7_PIOCFG_RAWSEL_MASK 0x10000
#define  IO_PAD7_PIOCFG_RAWSEL_SHIFT 16
#define  IO_PAD7_PIOCFG_RAWSEL_MASK_SHIFT(reg) (((reg) & IO_PAD7_PIOCFG_RAWSEL_MASK) >> IO_PAD7_PIOCFG_RAWSEL_SHIFT)
#define  IO_PAD7_PIOCFG_RAWSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD7_PIOCFG_RAWSEL_MASK) | (((uint32_t)val) << IO_PAD7_PIOCFG_RAWSEL_SHIFT))

#define  IO_PAD7_PIOCFG_PULL_SEL_MASK 0x8000
#define  IO_PAD7_PIOCFG_PULL_SEL_SHIFT 15
#define  IO_PAD7_PIOCFG_PULL_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD7_PIOCFG_PULL_SEL_MASK) >> IO_PAD7_PIOCFG_PULL_SEL_SHIFT)
#define  IO_PAD7_PIOCFG_PULL_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD7_PIOCFG_PULL_SEL_MASK) | (((uint32_t)val) << IO_PAD7_PIOCFG_PULL_SEL_SHIFT))

#define  IO_PAD7_PIOCFG_PUEN_MASK 0x4000
#define  IO_PAD7_PIOCFG_PUEN_SHIFT 14
#define  IO_PAD7_PIOCFG_PUEN_MASK_SHIFT(reg) (((reg) & IO_PAD7_PIOCFG_PUEN_MASK) >> IO_PAD7_PIOCFG_PUEN_SHIFT)
#define  IO_PAD7_PIOCFG_PUEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD7_PIOCFG_PUEN_MASK) | (((uint32_t)val) << IO_PAD7_PIOCFG_PUEN_SHIFT))

#define  IO_PAD7_PIOCFG_PDEN_MASK 0x2000
#define  IO_PAD7_PIOCFG_PDEN_SHIFT 13
#define  IO_PAD7_PIOCFG_PDEN_MASK_SHIFT(reg) (((reg) & IO_PAD7_PIOCFG_PDEN_MASK) >> IO_PAD7_PIOCFG_PDEN_SHIFT)
#define  IO_PAD7_PIOCFG_PDEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD7_PIOCFG_PDEN_MASK) | (((uint32_t)val) << IO_PAD7_PIOCFG_PDEN_SHIFT))

#define  IO_PAD7_PIOCFG_SR_MASK 0x1800
#define  IO_PAD7_PIOCFG_SR_SHIFT 11
#define  IO_PAD7_PIOCFG_SR_MASK_SHIFT(reg) (((reg) & IO_PAD7_PIOCFG_SR_MASK) >> IO_PAD7_PIOCFG_SR_SHIFT)
#define  IO_PAD7_PIOCFG_SR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD7_PIOCFG_SR_MASK) | (((uint32_t)val) << IO_PAD7_PIOCFG_SR_SHIFT))

#define  IO_PAD7_PIOCFG_SLP_DI_MASK 0x400
#define  IO_PAD7_PIOCFG_SLP_DI_SHIFT 10
#define  IO_PAD7_PIOCFG_SLP_DI_MASK_SHIFT(reg) (((reg) & IO_PAD7_PIOCFG_SLP_DI_MASK) >> IO_PAD7_PIOCFG_SLP_DI_SHIFT)
#define  IO_PAD7_PIOCFG_SLP_DI_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD7_PIOCFG_SLP_DI_MASK) | (((uint32_t)val) << IO_PAD7_PIOCFG_SLP_DI_SHIFT))

#define  IO_PAD7_PIOCFG_SLP_CNTRL_MASK 0x200
#define  IO_PAD7_PIOCFG_SLP_CNTRL_SHIFT 9
#define  IO_PAD7_PIOCFG_SLP_CNTRL_MASK_SHIFT(reg) (((reg) & IO_PAD7_PIOCFG_SLP_CNTRL_MASK) >> IO_PAD7_PIOCFG_SLP_CNTRL_SHIFT)
#define  IO_PAD7_PIOCFG_SLP_CNTRL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD7_PIOCFG_SLP_CNTRL_MASK) | (((uint32_t)val) << IO_PAD7_PIOCFG_SLP_CNTRL_SHIFT))

#define  IO_PAD7_PIOCFG_SLP_DO_MASK 0x100
#define  IO_PAD7_PIOCFG_SLP_DO_SHIFT 8
#define  IO_PAD7_PIOCFG_SLP_DO_MASK_SHIFT(reg) (((reg) & IO_PAD7_PIOCFG_SLP_DO_MASK) >> IO_PAD7_PIOCFG_SLP_DO_SHIFT)
#define  IO_PAD7_PIOCFG_SLP_DO_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD7_PIOCFG_SLP_DO_MASK) | (((uint32_t)val) << IO_PAD7_PIOCFG_SLP_DO_SHIFT))

#define  IO_PAD7_PIOCFG_SLP_DIR_MASK 0x80
#define  IO_PAD7_PIOCFG_SLP_DIR_SHIFT 7
#define  IO_PAD7_PIOCFG_SLP_DIR_MASK_SHIFT(reg) (((reg) & IO_PAD7_PIOCFG_SLP_DIR_MASK) >> IO_PAD7_PIOCFG_SLP_DIR_SHIFT)
#define  IO_PAD7_PIOCFG_SLP_DIR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD7_PIOCFG_SLP_DIR_MASK) | (((uint32_t)val) << IO_PAD7_PIOCFG_SLP_DIR_SHIFT))

#define  IO_PAD7_PIOCFG_EDGE_EN_N_MASK 0x40
#define  IO_PAD7_PIOCFG_EDGE_EN_N_SHIFT 6
#define  IO_PAD7_PIOCFG_EDGE_EN_N_MASK_SHIFT(reg) (((reg) & IO_PAD7_PIOCFG_EDGE_EN_N_MASK) >> IO_PAD7_PIOCFG_EDGE_EN_N_SHIFT)
#define  IO_PAD7_PIOCFG_EDGE_EN_N_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD7_PIOCFG_EDGE_EN_N_MASK) | (((uint32_t)val) << IO_PAD7_PIOCFG_EDGE_EN_N_SHIFT))

#define  IO_PAD7_PIOCFG_EDGE_FALL_EN_MASK 0x20
#define  IO_PAD7_PIOCFG_EDGE_FALL_EN_SHIFT 5
#define  IO_PAD7_PIOCFG_EDGE_FALL_EN_MASK_SHIFT(reg) (((reg) & IO_PAD7_PIOCFG_EDGE_FALL_EN_MASK) >> IO_PAD7_PIOCFG_EDGE_FALL_EN_SHIFT)
#define  IO_PAD7_PIOCFG_EDGE_FALL_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD7_PIOCFG_EDGE_FALL_EN_MASK) | (((uint32_t)val) << IO_PAD7_PIOCFG_EDGE_FALL_EN_SHIFT))

#define  IO_PAD7_PIOCFG_EDGE_RISE_EN_MASK 0x10
#define  IO_PAD7_PIOCFG_EDGE_RISE_EN_SHIFT 4
#define  IO_PAD7_PIOCFG_EDGE_RISE_EN_MASK_SHIFT(reg) (((reg) & IO_PAD7_PIOCFG_EDGE_RISE_EN_MASK) >> IO_PAD7_PIOCFG_EDGE_RISE_EN_SHIFT)
#define  IO_PAD7_PIOCFG_EDGE_RISE_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD7_PIOCFG_EDGE_RISE_EN_MASK) | (((uint32_t)val) << IO_PAD7_PIOCFG_EDGE_RISE_EN_SHIFT))

#define  IO_PAD7_PIOCFG_SLP_SEL_MASK 0x8
#define  IO_PAD7_PIOCFG_SLP_SEL_SHIFT 3
#define  IO_PAD7_PIOCFG_SLP_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD7_PIOCFG_SLP_SEL_MASK) >> IO_PAD7_PIOCFG_SLP_SEL_SHIFT)
#define  IO_PAD7_PIOCFG_SLP_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD7_PIOCFG_SLP_SEL_MASK) | (((uint32_t)val) << IO_PAD7_PIOCFG_SLP_SEL_SHIFT))

#define  IO_PAD7_PIOCFG_FUNC_SEL_MASK 0x7
#define  IO_PAD7_PIOCFG_FUNC_SEL_SHIFT 0
#define  IO_PAD7_PIOCFG_FUNC_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD7_PIOCFG_FUNC_SEL_MASK) >> IO_PAD7_PIOCFG_FUNC_SEL_SHIFT)
#define  IO_PAD7_PIOCFG_FUNC_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD7_PIOCFG_FUNC_SEL_MASK) | (((uint32_t)val) << IO_PAD7_PIOCFG_FUNC_SEL_SHIFT))

//====================================================================
//
//Register File: IO_PAD8 Configuration Registers (IO_PAD8)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

//====================================================================
//Register: IO_PAD8 Configuration Register (PIOCFG)
/** \brief "PHI_PADXDC_SRC" Pad*/
//====================================================================

#define  IO_PAD8_PIOCFG_RESERVED1_MASK 0xfc000000
#define  IO_PAD8_PIOCFG_RESERVED1_SHIFT 26
#define  IO_PAD8_PIOCFG_RESERVED1_MASK_SHIFT(reg) (((reg) & IO_PAD8_PIOCFG_RESERVED1_MASK) >> IO_PAD8_PIOCFG_RESERVED1_SHIFT)
#define  IO_PAD8_PIOCFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD8_PIOCFG_RESERVED1_MASK) | (((uint32_t)val) << IO_PAD8_PIOCFG_RESERVED1_SHIFT))

#define  IO_PAD8_PIOCFG_PD_MASK 0x2000000
#define  IO_PAD8_PIOCFG_PD_SHIFT 25
#define  IO_PAD8_PIOCFG_PD_MASK_SHIFT(reg) (((reg) & IO_PAD8_PIOCFG_PD_MASK) >> IO_PAD8_PIOCFG_PD_SHIFT)
#define  IO_PAD8_PIOCFG_PD_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD8_PIOCFG_PD_MASK) | (((uint32_t)val) << IO_PAD8_PIOCFG_PD_SHIFT))

#define  IO_PAD8_PIOCFG_ODT_EN_MASK 0x1000000
#define  IO_PAD8_PIOCFG_ODT_EN_SHIFT 24
#define  IO_PAD8_PIOCFG_ODT_EN_MASK_SHIFT(reg) (((reg) & IO_PAD8_PIOCFG_ODT_EN_MASK) >> IO_PAD8_PIOCFG_ODT_EN_SHIFT)
#define  IO_PAD8_PIOCFG_ODT_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD8_PIOCFG_ODT_EN_MASK) | (((uint32_t)val) << IO_PAD8_PIOCFG_ODT_EN_SHIFT))

#define  IO_PAD8_PIOCFG_LED_EN_MASK 0x800000
#define  IO_PAD8_PIOCFG_LED_EN_SHIFT 23
#define  IO_PAD8_PIOCFG_LED_EN_MASK_SHIFT(reg) (((reg) & IO_PAD8_PIOCFG_LED_EN_MASK) >> IO_PAD8_PIOCFG_LED_EN_SHIFT)
#define  IO_PAD8_PIOCFG_LED_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD8_PIOCFG_LED_EN_MASK) | (((uint32_t)val) << IO_PAD8_PIOCFG_LED_EN_SHIFT))

#define  IO_PAD8_PIOCFG_I2C_SEL_MASK 0x600000
#define  IO_PAD8_PIOCFG_I2C_SEL_SHIFT 21
#define  IO_PAD8_PIOCFG_I2C_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD8_PIOCFG_I2C_SEL_MASK) >> IO_PAD8_PIOCFG_I2C_SEL_SHIFT)
#define  IO_PAD8_PIOCFG_I2C_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD8_PIOCFG_I2C_SEL_MASK) | (((uint32_t)val) << IO_PAD8_PIOCFG_I2C_SEL_SHIFT))

#define  IO_PAD8_PIOCFG_DGTBSEL_MASK 0x1e0000
#define  IO_PAD8_PIOCFG_DGTBSEL_SHIFT 17
#define  IO_PAD8_PIOCFG_DGTBSEL_MASK_SHIFT(reg) (((reg) & IO_PAD8_PIOCFG_DGTBSEL_MASK) >> IO_PAD8_PIOCFG_DGTBSEL_SHIFT)
#define  IO_PAD8_PIOCFG_DGTBSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD8_PIOCFG_DGTBSEL_MASK) | (((uint32_t)val) << IO_PAD8_PIOCFG_DGTBSEL_SHIFT))

#define  IO_PAD8_PIOCFG_RAWSEL_MASK 0x10000
#define  IO_PAD8_PIOCFG_RAWSEL_SHIFT 16
#define  IO_PAD8_PIOCFG_RAWSEL_MASK_SHIFT(reg) (((reg) & IO_PAD8_PIOCFG_RAWSEL_MASK) >> IO_PAD8_PIOCFG_RAWSEL_SHIFT)
#define  IO_PAD8_PIOCFG_RAWSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD8_PIOCFG_RAWSEL_MASK) | (((uint32_t)val) << IO_PAD8_PIOCFG_RAWSEL_SHIFT))

#define  IO_PAD8_PIOCFG_PULL_SEL_MASK 0x8000
#define  IO_PAD8_PIOCFG_PULL_SEL_SHIFT 15
#define  IO_PAD8_PIOCFG_PULL_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD8_PIOCFG_PULL_SEL_MASK) >> IO_PAD8_PIOCFG_PULL_SEL_SHIFT)
#define  IO_PAD8_PIOCFG_PULL_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD8_PIOCFG_PULL_SEL_MASK) | (((uint32_t)val) << IO_PAD8_PIOCFG_PULL_SEL_SHIFT))

#define  IO_PAD8_PIOCFG_PUEN_MASK 0x4000
#define  IO_PAD8_PIOCFG_PUEN_SHIFT 14
#define  IO_PAD8_PIOCFG_PUEN_MASK_SHIFT(reg) (((reg) & IO_PAD8_PIOCFG_PUEN_MASK) >> IO_PAD8_PIOCFG_PUEN_SHIFT)
#define  IO_PAD8_PIOCFG_PUEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD8_PIOCFG_PUEN_MASK) | (((uint32_t)val) << IO_PAD8_PIOCFG_PUEN_SHIFT))

#define  IO_PAD8_PIOCFG_PDEN_MASK 0x2000
#define  IO_PAD8_PIOCFG_PDEN_SHIFT 13
#define  IO_PAD8_PIOCFG_PDEN_MASK_SHIFT(reg) (((reg) & IO_PAD8_PIOCFG_PDEN_MASK) >> IO_PAD8_PIOCFG_PDEN_SHIFT)
#define  IO_PAD8_PIOCFG_PDEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD8_PIOCFG_PDEN_MASK) | (((uint32_t)val) << IO_PAD8_PIOCFG_PDEN_SHIFT))

#define  IO_PAD8_PIOCFG_SR_MASK 0x1800
#define  IO_PAD8_PIOCFG_SR_SHIFT 11
#define  IO_PAD8_PIOCFG_SR_MASK_SHIFT(reg) (((reg) & IO_PAD8_PIOCFG_SR_MASK) >> IO_PAD8_PIOCFG_SR_SHIFT)
#define  IO_PAD8_PIOCFG_SR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD8_PIOCFG_SR_MASK) | (((uint32_t)val) << IO_PAD8_PIOCFG_SR_SHIFT))

#define  IO_PAD8_PIOCFG_SLP_DI_MASK 0x400
#define  IO_PAD8_PIOCFG_SLP_DI_SHIFT 10
#define  IO_PAD8_PIOCFG_SLP_DI_MASK_SHIFT(reg) (((reg) & IO_PAD8_PIOCFG_SLP_DI_MASK) >> IO_PAD8_PIOCFG_SLP_DI_SHIFT)
#define  IO_PAD8_PIOCFG_SLP_DI_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD8_PIOCFG_SLP_DI_MASK) | (((uint32_t)val) << IO_PAD8_PIOCFG_SLP_DI_SHIFT))

#define  IO_PAD8_PIOCFG_SLP_CNTRL_MASK 0x200
#define  IO_PAD8_PIOCFG_SLP_CNTRL_SHIFT 9
#define  IO_PAD8_PIOCFG_SLP_CNTRL_MASK_SHIFT(reg) (((reg) & IO_PAD8_PIOCFG_SLP_CNTRL_MASK) >> IO_PAD8_PIOCFG_SLP_CNTRL_SHIFT)
#define  IO_PAD8_PIOCFG_SLP_CNTRL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD8_PIOCFG_SLP_CNTRL_MASK) | (((uint32_t)val) << IO_PAD8_PIOCFG_SLP_CNTRL_SHIFT))

#define  IO_PAD8_PIOCFG_SLP_DO_MASK 0x100
#define  IO_PAD8_PIOCFG_SLP_DO_SHIFT 8
#define  IO_PAD8_PIOCFG_SLP_DO_MASK_SHIFT(reg) (((reg) & IO_PAD8_PIOCFG_SLP_DO_MASK) >> IO_PAD8_PIOCFG_SLP_DO_SHIFT)
#define  IO_PAD8_PIOCFG_SLP_DO_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD8_PIOCFG_SLP_DO_MASK) | (((uint32_t)val) << IO_PAD8_PIOCFG_SLP_DO_SHIFT))

#define  IO_PAD8_PIOCFG_SLP_DIR_MASK 0x80
#define  IO_PAD8_PIOCFG_SLP_DIR_SHIFT 7
#define  IO_PAD8_PIOCFG_SLP_DIR_MASK_SHIFT(reg) (((reg) & IO_PAD8_PIOCFG_SLP_DIR_MASK) >> IO_PAD8_PIOCFG_SLP_DIR_SHIFT)
#define  IO_PAD8_PIOCFG_SLP_DIR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD8_PIOCFG_SLP_DIR_MASK) | (((uint32_t)val) << IO_PAD8_PIOCFG_SLP_DIR_SHIFT))

#define  IO_PAD8_PIOCFG_EDGE_EN_N_MASK 0x40
#define  IO_PAD8_PIOCFG_EDGE_EN_N_SHIFT 6
#define  IO_PAD8_PIOCFG_EDGE_EN_N_MASK_SHIFT(reg) (((reg) & IO_PAD8_PIOCFG_EDGE_EN_N_MASK) >> IO_PAD8_PIOCFG_EDGE_EN_N_SHIFT)
#define  IO_PAD8_PIOCFG_EDGE_EN_N_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD8_PIOCFG_EDGE_EN_N_MASK) | (((uint32_t)val) << IO_PAD8_PIOCFG_EDGE_EN_N_SHIFT))

#define  IO_PAD8_PIOCFG_EDGE_FALL_EN_MASK 0x20
#define  IO_PAD8_PIOCFG_EDGE_FALL_EN_SHIFT 5
#define  IO_PAD8_PIOCFG_EDGE_FALL_EN_MASK_SHIFT(reg) (((reg) & IO_PAD8_PIOCFG_EDGE_FALL_EN_MASK) >> IO_PAD8_PIOCFG_EDGE_FALL_EN_SHIFT)
#define  IO_PAD8_PIOCFG_EDGE_FALL_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD8_PIOCFG_EDGE_FALL_EN_MASK) | (((uint32_t)val) << IO_PAD8_PIOCFG_EDGE_FALL_EN_SHIFT))

#define  IO_PAD8_PIOCFG_EDGE_RISE_EN_MASK 0x10
#define  IO_PAD8_PIOCFG_EDGE_RISE_EN_SHIFT 4
#define  IO_PAD8_PIOCFG_EDGE_RISE_EN_MASK_SHIFT(reg) (((reg) & IO_PAD8_PIOCFG_EDGE_RISE_EN_MASK) >> IO_PAD8_PIOCFG_EDGE_RISE_EN_SHIFT)
#define  IO_PAD8_PIOCFG_EDGE_RISE_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD8_PIOCFG_EDGE_RISE_EN_MASK) | (((uint32_t)val) << IO_PAD8_PIOCFG_EDGE_RISE_EN_SHIFT))

#define  IO_PAD8_PIOCFG_SLP_SEL_MASK 0x8
#define  IO_PAD8_PIOCFG_SLP_SEL_SHIFT 3
#define  IO_PAD8_PIOCFG_SLP_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD8_PIOCFG_SLP_SEL_MASK) >> IO_PAD8_PIOCFG_SLP_SEL_SHIFT)
#define  IO_PAD8_PIOCFG_SLP_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD8_PIOCFG_SLP_SEL_MASK) | (((uint32_t)val) << IO_PAD8_PIOCFG_SLP_SEL_SHIFT))

#define  IO_PAD8_PIOCFG_FUNC_SEL_MASK 0x7
#define  IO_PAD8_PIOCFG_FUNC_SEL_SHIFT 0
#define  IO_PAD8_PIOCFG_FUNC_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD8_PIOCFG_FUNC_SEL_MASK) >> IO_PAD8_PIOCFG_FUNC_SEL_SHIFT)
#define  IO_PAD8_PIOCFG_FUNC_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD8_PIOCFG_FUNC_SEL_MASK) | (((uint32_t)val) << IO_PAD8_PIOCFG_FUNC_SEL_SHIFT))

//====================================================================
//
//Register File: IO_PAD9 Configuration Registers (IO_PAD9)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

//====================================================================
//Register: IO_PAD9 Configuration Register (PIOCFG)
/** \brief "PHI_PADXDC_SRC" Pad*/
//====================================================================

#define  IO_PAD9_PIOCFG_RESERVED1_MASK 0xfc000000
#define  IO_PAD9_PIOCFG_RESERVED1_SHIFT 26
#define  IO_PAD9_PIOCFG_RESERVED1_MASK_SHIFT(reg) (((reg) & IO_PAD9_PIOCFG_RESERVED1_MASK) >> IO_PAD9_PIOCFG_RESERVED1_SHIFT)
#define  IO_PAD9_PIOCFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD9_PIOCFG_RESERVED1_MASK) | (((uint32_t)val) << IO_PAD9_PIOCFG_RESERVED1_SHIFT))

#define  IO_PAD9_PIOCFG_PD_MASK 0x2000000
#define  IO_PAD9_PIOCFG_PD_SHIFT 25
#define  IO_PAD9_PIOCFG_PD_MASK_SHIFT(reg) (((reg) & IO_PAD9_PIOCFG_PD_MASK) >> IO_PAD9_PIOCFG_PD_SHIFT)
#define  IO_PAD9_PIOCFG_PD_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD9_PIOCFG_PD_MASK) | (((uint32_t)val) << IO_PAD9_PIOCFG_PD_SHIFT))

#define  IO_PAD9_PIOCFG_ODT_EN_MASK 0x1000000
#define  IO_PAD9_PIOCFG_ODT_EN_SHIFT 24
#define  IO_PAD9_PIOCFG_ODT_EN_MASK_SHIFT(reg) (((reg) & IO_PAD9_PIOCFG_ODT_EN_MASK) >> IO_PAD9_PIOCFG_ODT_EN_SHIFT)
#define  IO_PAD9_PIOCFG_ODT_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD9_PIOCFG_ODT_EN_MASK) | (((uint32_t)val) << IO_PAD9_PIOCFG_ODT_EN_SHIFT))

#define  IO_PAD9_PIOCFG_LED_EN_MASK 0x800000
#define  IO_PAD9_PIOCFG_LED_EN_SHIFT 23
#define  IO_PAD9_PIOCFG_LED_EN_MASK_SHIFT(reg) (((reg) & IO_PAD9_PIOCFG_LED_EN_MASK) >> IO_PAD9_PIOCFG_LED_EN_SHIFT)
#define  IO_PAD9_PIOCFG_LED_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD9_PIOCFG_LED_EN_MASK) | (((uint32_t)val) << IO_PAD9_PIOCFG_LED_EN_SHIFT))

#define  IO_PAD9_PIOCFG_I2C_SEL_MASK 0x600000
#define  IO_PAD9_PIOCFG_I2C_SEL_SHIFT 21
#define  IO_PAD9_PIOCFG_I2C_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD9_PIOCFG_I2C_SEL_MASK) >> IO_PAD9_PIOCFG_I2C_SEL_SHIFT)
#define  IO_PAD9_PIOCFG_I2C_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD9_PIOCFG_I2C_SEL_MASK) | (((uint32_t)val) << IO_PAD9_PIOCFG_I2C_SEL_SHIFT))

#define  IO_PAD9_PIOCFG_DGTBSEL_MASK 0x1e0000
#define  IO_PAD9_PIOCFG_DGTBSEL_SHIFT 17
#define  IO_PAD9_PIOCFG_DGTBSEL_MASK_SHIFT(reg) (((reg) & IO_PAD9_PIOCFG_DGTBSEL_MASK) >> IO_PAD9_PIOCFG_DGTBSEL_SHIFT)
#define  IO_PAD9_PIOCFG_DGTBSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD9_PIOCFG_DGTBSEL_MASK) | (((uint32_t)val) << IO_PAD9_PIOCFG_DGTBSEL_SHIFT))

#define  IO_PAD9_PIOCFG_RAWSEL_MASK 0x10000
#define  IO_PAD9_PIOCFG_RAWSEL_SHIFT 16
#define  IO_PAD9_PIOCFG_RAWSEL_MASK_SHIFT(reg) (((reg) & IO_PAD9_PIOCFG_RAWSEL_MASK) >> IO_PAD9_PIOCFG_RAWSEL_SHIFT)
#define  IO_PAD9_PIOCFG_RAWSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD9_PIOCFG_RAWSEL_MASK) | (((uint32_t)val) << IO_PAD9_PIOCFG_RAWSEL_SHIFT))

#define  IO_PAD9_PIOCFG_PULL_SEL_MASK 0x8000
#define  IO_PAD9_PIOCFG_PULL_SEL_SHIFT 15
#define  IO_PAD9_PIOCFG_PULL_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD9_PIOCFG_PULL_SEL_MASK) >> IO_PAD9_PIOCFG_PULL_SEL_SHIFT)
#define  IO_PAD9_PIOCFG_PULL_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD9_PIOCFG_PULL_SEL_MASK) | (((uint32_t)val) << IO_PAD9_PIOCFG_PULL_SEL_SHIFT))

#define  IO_PAD9_PIOCFG_PUEN_MASK 0x4000
#define  IO_PAD9_PIOCFG_PUEN_SHIFT 14
#define  IO_PAD9_PIOCFG_PUEN_MASK_SHIFT(reg) (((reg) & IO_PAD9_PIOCFG_PUEN_MASK) >> IO_PAD9_PIOCFG_PUEN_SHIFT)
#define  IO_PAD9_PIOCFG_PUEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD9_PIOCFG_PUEN_MASK) | (((uint32_t)val) << IO_PAD9_PIOCFG_PUEN_SHIFT))

#define  IO_PAD9_PIOCFG_PDEN_MASK 0x2000
#define  IO_PAD9_PIOCFG_PDEN_SHIFT 13
#define  IO_PAD9_PIOCFG_PDEN_MASK_SHIFT(reg) (((reg) & IO_PAD9_PIOCFG_PDEN_MASK) >> IO_PAD9_PIOCFG_PDEN_SHIFT)
#define  IO_PAD9_PIOCFG_PDEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD9_PIOCFG_PDEN_MASK) | (((uint32_t)val) << IO_PAD9_PIOCFG_PDEN_SHIFT))

#define  IO_PAD9_PIOCFG_SR_MASK 0x1800
#define  IO_PAD9_PIOCFG_SR_SHIFT 11
#define  IO_PAD9_PIOCFG_SR_MASK_SHIFT(reg) (((reg) & IO_PAD9_PIOCFG_SR_MASK) >> IO_PAD9_PIOCFG_SR_SHIFT)
#define  IO_PAD9_PIOCFG_SR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD9_PIOCFG_SR_MASK) | (((uint32_t)val) << IO_PAD9_PIOCFG_SR_SHIFT))

#define  IO_PAD9_PIOCFG_SLP_DI_MASK 0x400
#define  IO_PAD9_PIOCFG_SLP_DI_SHIFT 10
#define  IO_PAD9_PIOCFG_SLP_DI_MASK_SHIFT(reg) (((reg) & IO_PAD9_PIOCFG_SLP_DI_MASK) >> IO_PAD9_PIOCFG_SLP_DI_SHIFT)
#define  IO_PAD9_PIOCFG_SLP_DI_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD9_PIOCFG_SLP_DI_MASK) | (((uint32_t)val) << IO_PAD9_PIOCFG_SLP_DI_SHIFT))

#define  IO_PAD9_PIOCFG_SLP_CNTRL_MASK 0x200
#define  IO_PAD9_PIOCFG_SLP_CNTRL_SHIFT 9
#define  IO_PAD9_PIOCFG_SLP_CNTRL_MASK_SHIFT(reg) (((reg) & IO_PAD9_PIOCFG_SLP_CNTRL_MASK) >> IO_PAD9_PIOCFG_SLP_CNTRL_SHIFT)
#define  IO_PAD9_PIOCFG_SLP_CNTRL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD9_PIOCFG_SLP_CNTRL_MASK) | (((uint32_t)val) << IO_PAD9_PIOCFG_SLP_CNTRL_SHIFT))

#define  IO_PAD9_PIOCFG_SLP_DO_MASK 0x100
#define  IO_PAD9_PIOCFG_SLP_DO_SHIFT 8
#define  IO_PAD9_PIOCFG_SLP_DO_MASK_SHIFT(reg) (((reg) & IO_PAD9_PIOCFG_SLP_DO_MASK) >> IO_PAD9_PIOCFG_SLP_DO_SHIFT)
#define  IO_PAD9_PIOCFG_SLP_DO_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD9_PIOCFG_SLP_DO_MASK) | (((uint32_t)val) << IO_PAD9_PIOCFG_SLP_DO_SHIFT))

#define  IO_PAD9_PIOCFG_SLP_DIR_MASK 0x80
#define  IO_PAD9_PIOCFG_SLP_DIR_SHIFT 7
#define  IO_PAD9_PIOCFG_SLP_DIR_MASK_SHIFT(reg) (((reg) & IO_PAD9_PIOCFG_SLP_DIR_MASK) >> IO_PAD9_PIOCFG_SLP_DIR_SHIFT)
#define  IO_PAD9_PIOCFG_SLP_DIR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD9_PIOCFG_SLP_DIR_MASK) | (((uint32_t)val) << IO_PAD9_PIOCFG_SLP_DIR_SHIFT))

#define  IO_PAD9_PIOCFG_EDGE_EN_N_MASK 0x40
#define  IO_PAD9_PIOCFG_EDGE_EN_N_SHIFT 6
#define  IO_PAD9_PIOCFG_EDGE_EN_N_MASK_SHIFT(reg) (((reg) & IO_PAD9_PIOCFG_EDGE_EN_N_MASK) >> IO_PAD9_PIOCFG_EDGE_EN_N_SHIFT)
#define  IO_PAD9_PIOCFG_EDGE_EN_N_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD9_PIOCFG_EDGE_EN_N_MASK) | (((uint32_t)val) << IO_PAD9_PIOCFG_EDGE_EN_N_SHIFT))

#define  IO_PAD9_PIOCFG_EDGE_FALL_EN_MASK 0x20
#define  IO_PAD9_PIOCFG_EDGE_FALL_EN_SHIFT 5
#define  IO_PAD9_PIOCFG_EDGE_FALL_EN_MASK_SHIFT(reg) (((reg) & IO_PAD9_PIOCFG_EDGE_FALL_EN_MASK) >> IO_PAD9_PIOCFG_EDGE_FALL_EN_SHIFT)
#define  IO_PAD9_PIOCFG_EDGE_FALL_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD9_PIOCFG_EDGE_FALL_EN_MASK) | (((uint32_t)val) << IO_PAD9_PIOCFG_EDGE_FALL_EN_SHIFT))

#define  IO_PAD9_PIOCFG_EDGE_RISE_EN_MASK 0x10
#define  IO_PAD9_PIOCFG_EDGE_RISE_EN_SHIFT 4
#define  IO_PAD9_PIOCFG_EDGE_RISE_EN_MASK_SHIFT(reg) (((reg) & IO_PAD9_PIOCFG_EDGE_RISE_EN_MASK) >> IO_PAD9_PIOCFG_EDGE_RISE_EN_SHIFT)
#define  IO_PAD9_PIOCFG_EDGE_RISE_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD9_PIOCFG_EDGE_RISE_EN_MASK) | (((uint32_t)val) << IO_PAD9_PIOCFG_EDGE_RISE_EN_SHIFT))

#define  IO_PAD9_PIOCFG_SLP_SEL_MASK 0x8
#define  IO_PAD9_PIOCFG_SLP_SEL_SHIFT 3
#define  IO_PAD9_PIOCFG_SLP_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD9_PIOCFG_SLP_SEL_MASK) >> IO_PAD9_PIOCFG_SLP_SEL_SHIFT)
#define  IO_PAD9_PIOCFG_SLP_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD9_PIOCFG_SLP_SEL_MASK) | (((uint32_t)val) << IO_PAD9_PIOCFG_SLP_SEL_SHIFT))

#define  IO_PAD9_PIOCFG_FUNC_SEL_MASK 0x7
#define  IO_PAD9_PIOCFG_FUNC_SEL_SHIFT 0
#define  IO_PAD9_PIOCFG_FUNC_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD9_PIOCFG_FUNC_SEL_MASK) >> IO_PAD9_PIOCFG_FUNC_SEL_SHIFT)
#define  IO_PAD9_PIOCFG_FUNC_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD9_PIOCFG_FUNC_SEL_MASK) | (((uint32_t)val) << IO_PAD9_PIOCFG_FUNC_SEL_SHIFT))

//====================================================================
//
//Register File: IO_PAD10 Configuration Registers (IO_PAD10)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

//====================================================================
//Register: IO_PAD10 Configuration Register (PIOCFG)
/** \brief "PHI_PADXDC_HSIOB" Pad*/
//====================================================================

#define  IO_PAD10_PIOCFG_RESERVED1_MASK 0xfc000000
#define  IO_PAD10_PIOCFG_RESERVED1_SHIFT 26
#define  IO_PAD10_PIOCFG_RESERVED1_MASK_SHIFT(reg) (((reg) & IO_PAD10_PIOCFG_RESERVED1_MASK) >> IO_PAD10_PIOCFG_RESERVED1_SHIFT)
#define  IO_PAD10_PIOCFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD10_PIOCFG_RESERVED1_MASK) | (((uint32_t)val) << IO_PAD10_PIOCFG_RESERVED1_SHIFT))

#define  IO_PAD10_PIOCFG_PD_MASK 0x2000000
#define  IO_PAD10_PIOCFG_PD_SHIFT 25
#define  IO_PAD10_PIOCFG_PD_MASK_SHIFT(reg) (((reg) & IO_PAD10_PIOCFG_PD_MASK) >> IO_PAD10_PIOCFG_PD_SHIFT)
#define  IO_PAD10_PIOCFG_PD_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD10_PIOCFG_PD_MASK) | (((uint32_t)val) << IO_PAD10_PIOCFG_PD_SHIFT))

#define  IO_PAD10_PIOCFG_ODT_EN_MASK 0x1000000
#define  IO_PAD10_PIOCFG_ODT_EN_SHIFT 24
#define  IO_PAD10_PIOCFG_ODT_EN_MASK_SHIFT(reg) (((reg) & IO_PAD10_PIOCFG_ODT_EN_MASK) >> IO_PAD10_PIOCFG_ODT_EN_SHIFT)
#define  IO_PAD10_PIOCFG_ODT_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD10_PIOCFG_ODT_EN_MASK) | (((uint32_t)val) << IO_PAD10_PIOCFG_ODT_EN_SHIFT))

#define  IO_PAD10_PIOCFG_LED_EN_MASK 0x800000
#define  IO_PAD10_PIOCFG_LED_EN_SHIFT 23
#define  IO_PAD10_PIOCFG_LED_EN_MASK_SHIFT(reg) (((reg) & IO_PAD10_PIOCFG_LED_EN_MASK) >> IO_PAD10_PIOCFG_LED_EN_SHIFT)
#define  IO_PAD10_PIOCFG_LED_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD10_PIOCFG_LED_EN_MASK) | (((uint32_t)val) << IO_PAD10_PIOCFG_LED_EN_SHIFT))

#define  IO_PAD10_PIOCFG_I2C_SEL_MASK 0x600000
#define  IO_PAD10_PIOCFG_I2C_SEL_SHIFT 21
#define  IO_PAD10_PIOCFG_I2C_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD10_PIOCFG_I2C_SEL_MASK) >> IO_PAD10_PIOCFG_I2C_SEL_SHIFT)
#define  IO_PAD10_PIOCFG_I2C_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD10_PIOCFG_I2C_SEL_MASK) | (((uint32_t)val) << IO_PAD10_PIOCFG_I2C_SEL_SHIFT))

#define  IO_PAD10_PIOCFG_DGTBSEL_MASK 0x1e0000
#define  IO_PAD10_PIOCFG_DGTBSEL_SHIFT 17
#define  IO_PAD10_PIOCFG_DGTBSEL_MASK_SHIFT(reg) (((reg) & IO_PAD10_PIOCFG_DGTBSEL_MASK) >> IO_PAD10_PIOCFG_DGTBSEL_SHIFT)
#define  IO_PAD10_PIOCFG_DGTBSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD10_PIOCFG_DGTBSEL_MASK) | (((uint32_t)val) << IO_PAD10_PIOCFG_DGTBSEL_SHIFT))

#define  IO_PAD10_PIOCFG_RAWSEL_MASK 0x10000
#define  IO_PAD10_PIOCFG_RAWSEL_SHIFT 16
#define  IO_PAD10_PIOCFG_RAWSEL_MASK_SHIFT(reg) (((reg) & IO_PAD10_PIOCFG_RAWSEL_MASK) >> IO_PAD10_PIOCFG_RAWSEL_SHIFT)
#define  IO_PAD10_PIOCFG_RAWSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD10_PIOCFG_RAWSEL_MASK) | (((uint32_t)val) << IO_PAD10_PIOCFG_RAWSEL_SHIFT))

#define  IO_PAD10_PIOCFG_PULL_SEL_MASK 0x8000
#define  IO_PAD10_PIOCFG_PULL_SEL_SHIFT 15
#define  IO_PAD10_PIOCFG_PULL_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD10_PIOCFG_PULL_SEL_MASK) >> IO_PAD10_PIOCFG_PULL_SEL_SHIFT)
#define  IO_PAD10_PIOCFG_PULL_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD10_PIOCFG_PULL_SEL_MASK) | (((uint32_t)val) << IO_PAD10_PIOCFG_PULL_SEL_SHIFT))

#define  IO_PAD10_PIOCFG_PUEN_MASK 0x4000
#define  IO_PAD10_PIOCFG_PUEN_SHIFT 14
#define  IO_PAD10_PIOCFG_PUEN_MASK_SHIFT(reg) (((reg) & IO_PAD10_PIOCFG_PUEN_MASK) >> IO_PAD10_PIOCFG_PUEN_SHIFT)
#define  IO_PAD10_PIOCFG_PUEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD10_PIOCFG_PUEN_MASK) | (((uint32_t)val) << IO_PAD10_PIOCFG_PUEN_SHIFT))

#define  IO_PAD10_PIOCFG_PDEN_MASK 0x2000
#define  IO_PAD10_PIOCFG_PDEN_SHIFT 13
#define  IO_PAD10_PIOCFG_PDEN_MASK_SHIFT(reg) (((reg) & IO_PAD10_PIOCFG_PDEN_MASK) >> IO_PAD10_PIOCFG_PDEN_SHIFT)
#define  IO_PAD10_PIOCFG_PDEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD10_PIOCFG_PDEN_MASK) | (((uint32_t)val) << IO_PAD10_PIOCFG_PDEN_SHIFT))

#define  IO_PAD10_PIOCFG_SR_MASK 0x1800
#define  IO_PAD10_PIOCFG_SR_SHIFT 11
#define  IO_PAD10_PIOCFG_SR_MASK_SHIFT(reg) (((reg) & IO_PAD10_PIOCFG_SR_MASK) >> IO_PAD10_PIOCFG_SR_SHIFT)
#define  IO_PAD10_PIOCFG_SR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD10_PIOCFG_SR_MASK) | (((uint32_t)val) << IO_PAD10_PIOCFG_SR_SHIFT))

#define  IO_PAD10_PIOCFG_SLP_DI_MASK 0x400
#define  IO_PAD10_PIOCFG_SLP_DI_SHIFT 10
#define  IO_PAD10_PIOCFG_SLP_DI_MASK_SHIFT(reg) (((reg) & IO_PAD10_PIOCFG_SLP_DI_MASK) >> IO_PAD10_PIOCFG_SLP_DI_SHIFT)
#define  IO_PAD10_PIOCFG_SLP_DI_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD10_PIOCFG_SLP_DI_MASK) | (((uint32_t)val) << IO_PAD10_PIOCFG_SLP_DI_SHIFT))

#define  IO_PAD10_PIOCFG_SLP_CNTRL_MASK 0x200
#define  IO_PAD10_PIOCFG_SLP_CNTRL_SHIFT 9
#define  IO_PAD10_PIOCFG_SLP_CNTRL_MASK_SHIFT(reg) (((reg) & IO_PAD10_PIOCFG_SLP_CNTRL_MASK) >> IO_PAD10_PIOCFG_SLP_CNTRL_SHIFT)
#define  IO_PAD10_PIOCFG_SLP_CNTRL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD10_PIOCFG_SLP_CNTRL_MASK) | (((uint32_t)val) << IO_PAD10_PIOCFG_SLP_CNTRL_SHIFT))

#define  IO_PAD10_PIOCFG_SLP_DO_MASK 0x100
#define  IO_PAD10_PIOCFG_SLP_DO_SHIFT 8
#define  IO_PAD10_PIOCFG_SLP_DO_MASK_SHIFT(reg) (((reg) & IO_PAD10_PIOCFG_SLP_DO_MASK) >> IO_PAD10_PIOCFG_SLP_DO_SHIFT)
#define  IO_PAD10_PIOCFG_SLP_DO_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD10_PIOCFG_SLP_DO_MASK) | (((uint32_t)val) << IO_PAD10_PIOCFG_SLP_DO_SHIFT))

#define  IO_PAD10_PIOCFG_SLP_DIR_MASK 0x80
#define  IO_PAD10_PIOCFG_SLP_DIR_SHIFT 7
#define  IO_PAD10_PIOCFG_SLP_DIR_MASK_SHIFT(reg) (((reg) & IO_PAD10_PIOCFG_SLP_DIR_MASK) >> IO_PAD10_PIOCFG_SLP_DIR_SHIFT)
#define  IO_PAD10_PIOCFG_SLP_DIR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD10_PIOCFG_SLP_DIR_MASK) | (((uint32_t)val) << IO_PAD10_PIOCFG_SLP_DIR_SHIFT))

#define  IO_PAD10_PIOCFG_EDGE_EN_N_MASK 0x40
#define  IO_PAD10_PIOCFG_EDGE_EN_N_SHIFT 6
#define  IO_PAD10_PIOCFG_EDGE_EN_N_MASK_SHIFT(reg) (((reg) & IO_PAD10_PIOCFG_EDGE_EN_N_MASK) >> IO_PAD10_PIOCFG_EDGE_EN_N_SHIFT)
#define  IO_PAD10_PIOCFG_EDGE_EN_N_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD10_PIOCFG_EDGE_EN_N_MASK) | (((uint32_t)val) << IO_PAD10_PIOCFG_EDGE_EN_N_SHIFT))

#define  IO_PAD10_PIOCFG_EDGE_FALL_EN_MASK 0x20
#define  IO_PAD10_PIOCFG_EDGE_FALL_EN_SHIFT 5
#define  IO_PAD10_PIOCFG_EDGE_FALL_EN_MASK_SHIFT(reg) (((reg) & IO_PAD10_PIOCFG_EDGE_FALL_EN_MASK) >> IO_PAD10_PIOCFG_EDGE_FALL_EN_SHIFT)
#define  IO_PAD10_PIOCFG_EDGE_FALL_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD10_PIOCFG_EDGE_FALL_EN_MASK) | (((uint32_t)val) << IO_PAD10_PIOCFG_EDGE_FALL_EN_SHIFT))

#define  IO_PAD10_PIOCFG_EDGE_RISE_EN_MASK 0x10
#define  IO_PAD10_PIOCFG_EDGE_RISE_EN_SHIFT 4
#define  IO_PAD10_PIOCFG_EDGE_RISE_EN_MASK_SHIFT(reg) (((reg) & IO_PAD10_PIOCFG_EDGE_RISE_EN_MASK) >> IO_PAD10_PIOCFG_EDGE_RISE_EN_SHIFT)
#define  IO_PAD10_PIOCFG_EDGE_RISE_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD10_PIOCFG_EDGE_RISE_EN_MASK) | (((uint32_t)val) << IO_PAD10_PIOCFG_EDGE_RISE_EN_SHIFT))

#define  IO_PAD10_PIOCFG_SLP_SEL_MASK 0x8
#define  IO_PAD10_PIOCFG_SLP_SEL_SHIFT 3
#define  IO_PAD10_PIOCFG_SLP_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD10_PIOCFG_SLP_SEL_MASK) >> IO_PAD10_PIOCFG_SLP_SEL_SHIFT)
#define  IO_PAD10_PIOCFG_SLP_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD10_PIOCFG_SLP_SEL_MASK) | (((uint32_t)val) << IO_PAD10_PIOCFG_SLP_SEL_SHIFT))

#define  IO_PAD10_PIOCFG_FUNC_SEL_MASK 0x7
#define  IO_PAD10_PIOCFG_FUNC_SEL_SHIFT 0
#define  IO_PAD10_PIOCFG_FUNC_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD10_PIOCFG_FUNC_SEL_MASK) >> IO_PAD10_PIOCFG_FUNC_SEL_SHIFT)
#define  IO_PAD10_PIOCFG_FUNC_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD10_PIOCFG_FUNC_SEL_MASK) | (((uint32_t)val) << IO_PAD10_PIOCFG_FUNC_SEL_SHIFT))

//====================================================================
//
//Register File: IO_PAD11 Configuration Registers (IO_PAD11)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

//====================================================================
//Register: IO_PAD11 Configuration Register (PIOCFG)
/** \brief "PHI_PADXDC_HSIOB" Pad*/
//====================================================================

#define  IO_PAD11_PIOCFG_RESERVED1_MASK 0xfc000000
#define  IO_PAD11_PIOCFG_RESERVED1_SHIFT 26
#define  IO_PAD11_PIOCFG_RESERVED1_MASK_SHIFT(reg) (((reg) & IO_PAD11_PIOCFG_RESERVED1_MASK) >> IO_PAD11_PIOCFG_RESERVED1_SHIFT)
#define  IO_PAD11_PIOCFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD11_PIOCFG_RESERVED1_MASK) | (((uint32_t)val) << IO_PAD11_PIOCFG_RESERVED1_SHIFT))

#define  IO_PAD11_PIOCFG_PD_MASK 0x2000000
#define  IO_PAD11_PIOCFG_PD_SHIFT 25
#define  IO_PAD11_PIOCFG_PD_MASK_SHIFT(reg) (((reg) & IO_PAD11_PIOCFG_PD_MASK) >> IO_PAD11_PIOCFG_PD_SHIFT)
#define  IO_PAD11_PIOCFG_PD_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD11_PIOCFG_PD_MASK) | (((uint32_t)val) << IO_PAD11_PIOCFG_PD_SHIFT))

#define  IO_PAD11_PIOCFG_ODT_EN_MASK 0x1000000
#define  IO_PAD11_PIOCFG_ODT_EN_SHIFT 24
#define  IO_PAD11_PIOCFG_ODT_EN_MASK_SHIFT(reg) (((reg) & IO_PAD11_PIOCFG_ODT_EN_MASK) >> IO_PAD11_PIOCFG_ODT_EN_SHIFT)
#define  IO_PAD11_PIOCFG_ODT_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD11_PIOCFG_ODT_EN_MASK) | (((uint32_t)val) << IO_PAD11_PIOCFG_ODT_EN_SHIFT))

#define  IO_PAD11_PIOCFG_LED_EN_MASK 0x800000
#define  IO_PAD11_PIOCFG_LED_EN_SHIFT 23
#define  IO_PAD11_PIOCFG_LED_EN_MASK_SHIFT(reg) (((reg) & IO_PAD11_PIOCFG_LED_EN_MASK) >> IO_PAD11_PIOCFG_LED_EN_SHIFT)
#define  IO_PAD11_PIOCFG_LED_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD11_PIOCFG_LED_EN_MASK) | (((uint32_t)val) << IO_PAD11_PIOCFG_LED_EN_SHIFT))

#define  IO_PAD11_PIOCFG_I2C_SEL_MASK 0x600000
#define  IO_PAD11_PIOCFG_I2C_SEL_SHIFT 21
#define  IO_PAD11_PIOCFG_I2C_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD11_PIOCFG_I2C_SEL_MASK) >> IO_PAD11_PIOCFG_I2C_SEL_SHIFT)
#define  IO_PAD11_PIOCFG_I2C_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD11_PIOCFG_I2C_SEL_MASK) | (((uint32_t)val) << IO_PAD11_PIOCFG_I2C_SEL_SHIFT))

#define  IO_PAD11_PIOCFG_DGTBSEL_MASK 0x1e0000
#define  IO_PAD11_PIOCFG_DGTBSEL_SHIFT 17
#define  IO_PAD11_PIOCFG_DGTBSEL_MASK_SHIFT(reg) (((reg) & IO_PAD11_PIOCFG_DGTBSEL_MASK) >> IO_PAD11_PIOCFG_DGTBSEL_SHIFT)
#define  IO_PAD11_PIOCFG_DGTBSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD11_PIOCFG_DGTBSEL_MASK) | (((uint32_t)val) << IO_PAD11_PIOCFG_DGTBSEL_SHIFT))

#define  IO_PAD11_PIOCFG_RAWSEL_MASK 0x10000
#define  IO_PAD11_PIOCFG_RAWSEL_SHIFT 16
#define  IO_PAD11_PIOCFG_RAWSEL_MASK_SHIFT(reg) (((reg) & IO_PAD11_PIOCFG_RAWSEL_MASK) >> IO_PAD11_PIOCFG_RAWSEL_SHIFT)
#define  IO_PAD11_PIOCFG_RAWSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD11_PIOCFG_RAWSEL_MASK) | (((uint32_t)val) << IO_PAD11_PIOCFG_RAWSEL_SHIFT))

#define  IO_PAD11_PIOCFG_PULL_SEL_MASK 0x8000
#define  IO_PAD11_PIOCFG_PULL_SEL_SHIFT 15
#define  IO_PAD11_PIOCFG_PULL_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD11_PIOCFG_PULL_SEL_MASK) >> IO_PAD11_PIOCFG_PULL_SEL_SHIFT)
#define  IO_PAD11_PIOCFG_PULL_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD11_PIOCFG_PULL_SEL_MASK) | (((uint32_t)val) << IO_PAD11_PIOCFG_PULL_SEL_SHIFT))

#define  IO_PAD11_PIOCFG_PUEN_MASK 0x4000
#define  IO_PAD11_PIOCFG_PUEN_SHIFT 14
#define  IO_PAD11_PIOCFG_PUEN_MASK_SHIFT(reg) (((reg) & IO_PAD11_PIOCFG_PUEN_MASK) >> IO_PAD11_PIOCFG_PUEN_SHIFT)
#define  IO_PAD11_PIOCFG_PUEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD11_PIOCFG_PUEN_MASK) | (((uint32_t)val) << IO_PAD11_PIOCFG_PUEN_SHIFT))

#define  IO_PAD11_PIOCFG_PDEN_MASK 0x2000
#define  IO_PAD11_PIOCFG_PDEN_SHIFT 13
#define  IO_PAD11_PIOCFG_PDEN_MASK_SHIFT(reg) (((reg) & IO_PAD11_PIOCFG_PDEN_MASK) >> IO_PAD11_PIOCFG_PDEN_SHIFT)
#define  IO_PAD11_PIOCFG_PDEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD11_PIOCFG_PDEN_MASK) | (((uint32_t)val) << IO_PAD11_PIOCFG_PDEN_SHIFT))

#define  IO_PAD11_PIOCFG_SR_MASK 0x1800
#define  IO_PAD11_PIOCFG_SR_SHIFT 11
#define  IO_PAD11_PIOCFG_SR_MASK_SHIFT(reg) (((reg) & IO_PAD11_PIOCFG_SR_MASK) >> IO_PAD11_PIOCFG_SR_SHIFT)
#define  IO_PAD11_PIOCFG_SR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD11_PIOCFG_SR_MASK) | (((uint32_t)val) << IO_PAD11_PIOCFG_SR_SHIFT))

#define  IO_PAD11_PIOCFG_SLP_DI_MASK 0x400
#define  IO_PAD11_PIOCFG_SLP_DI_SHIFT 10
#define  IO_PAD11_PIOCFG_SLP_DI_MASK_SHIFT(reg) (((reg) & IO_PAD11_PIOCFG_SLP_DI_MASK) >> IO_PAD11_PIOCFG_SLP_DI_SHIFT)
#define  IO_PAD11_PIOCFG_SLP_DI_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD11_PIOCFG_SLP_DI_MASK) | (((uint32_t)val) << IO_PAD11_PIOCFG_SLP_DI_SHIFT))

#define  IO_PAD11_PIOCFG_SLP_CNTRL_MASK 0x200
#define  IO_PAD11_PIOCFG_SLP_CNTRL_SHIFT 9
#define  IO_PAD11_PIOCFG_SLP_CNTRL_MASK_SHIFT(reg) (((reg) & IO_PAD11_PIOCFG_SLP_CNTRL_MASK) >> IO_PAD11_PIOCFG_SLP_CNTRL_SHIFT)
#define  IO_PAD11_PIOCFG_SLP_CNTRL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD11_PIOCFG_SLP_CNTRL_MASK) | (((uint32_t)val) << IO_PAD11_PIOCFG_SLP_CNTRL_SHIFT))

#define  IO_PAD11_PIOCFG_SLP_DO_MASK 0x100
#define  IO_PAD11_PIOCFG_SLP_DO_SHIFT 8
#define  IO_PAD11_PIOCFG_SLP_DO_MASK_SHIFT(reg) (((reg) & IO_PAD11_PIOCFG_SLP_DO_MASK) >> IO_PAD11_PIOCFG_SLP_DO_SHIFT)
#define  IO_PAD11_PIOCFG_SLP_DO_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD11_PIOCFG_SLP_DO_MASK) | (((uint32_t)val) << IO_PAD11_PIOCFG_SLP_DO_SHIFT))

#define  IO_PAD11_PIOCFG_SLP_DIR_MASK 0x80
#define  IO_PAD11_PIOCFG_SLP_DIR_SHIFT 7
#define  IO_PAD11_PIOCFG_SLP_DIR_MASK_SHIFT(reg) (((reg) & IO_PAD11_PIOCFG_SLP_DIR_MASK) >> IO_PAD11_PIOCFG_SLP_DIR_SHIFT)
#define  IO_PAD11_PIOCFG_SLP_DIR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD11_PIOCFG_SLP_DIR_MASK) | (((uint32_t)val) << IO_PAD11_PIOCFG_SLP_DIR_SHIFT))

#define  IO_PAD11_PIOCFG_EDGE_EN_N_MASK 0x40
#define  IO_PAD11_PIOCFG_EDGE_EN_N_SHIFT 6
#define  IO_PAD11_PIOCFG_EDGE_EN_N_MASK_SHIFT(reg) (((reg) & IO_PAD11_PIOCFG_EDGE_EN_N_MASK) >> IO_PAD11_PIOCFG_EDGE_EN_N_SHIFT)
#define  IO_PAD11_PIOCFG_EDGE_EN_N_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD11_PIOCFG_EDGE_EN_N_MASK) | (((uint32_t)val) << IO_PAD11_PIOCFG_EDGE_EN_N_SHIFT))

#define  IO_PAD11_PIOCFG_EDGE_FALL_EN_MASK 0x20
#define  IO_PAD11_PIOCFG_EDGE_FALL_EN_SHIFT 5
#define  IO_PAD11_PIOCFG_EDGE_FALL_EN_MASK_SHIFT(reg) (((reg) & IO_PAD11_PIOCFG_EDGE_FALL_EN_MASK) >> IO_PAD11_PIOCFG_EDGE_FALL_EN_SHIFT)
#define  IO_PAD11_PIOCFG_EDGE_FALL_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD11_PIOCFG_EDGE_FALL_EN_MASK) | (((uint32_t)val) << IO_PAD11_PIOCFG_EDGE_FALL_EN_SHIFT))

#define  IO_PAD11_PIOCFG_EDGE_RISE_EN_MASK 0x10
#define  IO_PAD11_PIOCFG_EDGE_RISE_EN_SHIFT 4
#define  IO_PAD11_PIOCFG_EDGE_RISE_EN_MASK_SHIFT(reg) (((reg) & IO_PAD11_PIOCFG_EDGE_RISE_EN_MASK) >> IO_PAD11_PIOCFG_EDGE_RISE_EN_SHIFT)
#define  IO_PAD11_PIOCFG_EDGE_RISE_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD11_PIOCFG_EDGE_RISE_EN_MASK) | (((uint32_t)val) << IO_PAD11_PIOCFG_EDGE_RISE_EN_SHIFT))

#define  IO_PAD11_PIOCFG_SLP_SEL_MASK 0x8
#define  IO_PAD11_PIOCFG_SLP_SEL_SHIFT 3
#define  IO_PAD11_PIOCFG_SLP_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD11_PIOCFG_SLP_SEL_MASK) >> IO_PAD11_PIOCFG_SLP_SEL_SHIFT)
#define  IO_PAD11_PIOCFG_SLP_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD11_PIOCFG_SLP_SEL_MASK) | (((uint32_t)val) << IO_PAD11_PIOCFG_SLP_SEL_SHIFT))

#define  IO_PAD11_PIOCFG_FUNC_SEL_MASK 0x7
#define  IO_PAD11_PIOCFG_FUNC_SEL_SHIFT 0
#define  IO_PAD11_PIOCFG_FUNC_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD11_PIOCFG_FUNC_SEL_MASK) >> IO_PAD11_PIOCFG_FUNC_SEL_SHIFT)
#define  IO_PAD11_PIOCFG_FUNC_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD11_PIOCFG_FUNC_SEL_MASK) | (((uint32_t)val) << IO_PAD11_PIOCFG_FUNC_SEL_SHIFT))

//====================================================================
//
//Register File: IO_PAD12 Configuration Registers (IO_PAD12)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

//====================================================================
//Register: IO_PAD12 Configuration Register (PIOCFG)
/** \brief "PHI_PADXDC_HSIOB" Pad*/
//====================================================================

#define  IO_PAD12_PIOCFG_RESERVED1_MASK 0xfc000000
#define  IO_PAD12_PIOCFG_RESERVED1_SHIFT 26
#define  IO_PAD12_PIOCFG_RESERVED1_MASK_SHIFT(reg) (((reg) & IO_PAD12_PIOCFG_RESERVED1_MASK) >> IO_PAD12_PIOCFG_RESERVED1_SHIFT)
#define  IO_PAD12_PIOCFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD12_PIOCFG_RESERVED1_MASK) | (((uint32_t)val) << IO_PAD12_PIOCFG_RESERVED1_SHIFT))

#define  IO_PAD12_PIOCFG_PD_MASK 0x2000000
#define  IO_PAD12_PIOCFG_PD_SHIFT 25
#define  IO_PAD12_PIOCFG_PD_MASK_SHIFT(reg) (((reg) & IO_PAD12_PIOCFG_PD_MASK) >> IO_PAD12_PIOCFG_PD_SHIFT)
#define  IO_PAD12_PIOCFG_PD_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD12_PIOCFG_PD_MASK) | (((uint32_t)val) << IO_PAD12_PIOCFG_PD_SHIFT))

#define  IO_PAD12_PIOCFG_ODT_EN_MASK 0x1000000
#define  IO_PAD12_PIOCFG_ODT_EN_SHIFT 24
#define  IO_PAD12_PIOCFG_ODT_EN_MASK_SHIFT(reg) (((reg) & IO_PAD12_PIOCFG_ODT_EN_MASK) >> IO_PAD12_PIOCFG_ODT_EN_SHIFT)
#define  IO_PAD12_PIOCFG_ODT_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD12_PIOCFG_ODT_EN_MASK) | (((uint32_t)val) << IO_PAD12_PIOCFG_ODT_EN_SHIFT))

#define  IO_PAD12_PIOCFG_LED_EN_MASK 0x800000
#define  IO_PAD12_PIOCFG_LED_EN_SHIFT 23
#define  IO_PAD12_PIOCFG_LED_EN_MASK_SHIFT(reg) (((reg) & IO_PAD12_PIOCFG_LED_EN_MASK) >> IO_PAD12_PIOCFG_LED_EN_SHIFT)
#define  IO_PAD12_PIOCFG_LED_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD12_PIOCFG_LED_EN_MASK) | (((uint32_t)val) << IO_PAD12_PIOCFG_LED_EN_SHIFT))

#define  IO_PAD12_PIOCFG_I2C_SEL_MASK 0x600000
#define  IO_PAD12_PIOCFG_I2C_SEL_SHIFT 21
#define  IO_PAD12_PIOCFG_I2C_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD12_PIOCFG_I2C_SEL_MASK) >> IO_PAD12_PIOCFG_I2C_SEL_SHIFT)
#define  IO_PAD12_PIOCFG_I2C_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD12_PIOCFG_I2C_SEL_MASK) | (((uint32_t)val) << IO_PAD12_PIOCFG_I2C_SEL_SHIFT))

#define  IO_PAD12_PIOCFG_DGTBSEL_MASK 0x1e0000
#define  IO_PAD12_PIOCFG_DGTBSEL_SHIFT 17
#define  IO_PAD12_PIOCFG_DGTBSEL_MASK_SHIFT(reg) (((reg) & IO_PAD12_PIOCFG_DGTBSEL_MASK) >> IO_PAD12_PIOCFG_DGTBSEL_SHIFT)
#define  IO_PAD12_PIOCFG_DGTBSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD12_PIOCFG_DGTBSEL_MASK) | (((uint32_t)val) << IO_PAD12_PIOCFG_DGTBSEL_SHIFT))

#define  IO_PAD12_PIOCFG_RAWSEL_MASK 0x10000
#define  IO_PAD12_PIOCFG_RAWSEL_SHIFT 16
#define  IO_PAD12_PIOCFG_RAWSEL_MASK_SHIFT(reg) (((reg) & IO_PAD12_PIOCFG_RAWSEL_MASK) >> IO_PAD12_PIOCFG_RAWSEL_SHIFT)
#define  IO_PAD12_PIOCFG_RAWSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD12_PIOCFG_RAWSEL_MASK) | (((uint32_t)val) << IO_PAD12_PIOCFG_RAWSEL_SHIFT))

#define  IO_PAD12_PIOCFG_PULL_SEL_MASK 0x8000
#define  IO_PAD12_PIOCFG_PULL_SEL_SHIFT 15
#define  IO_PAD12_PIOCFG_PULL_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD12_PIOCFG_PULL_SEL_MASK) >> IO_PAD12_PIOCFG_PULL_SEL_SHIFT)
#define  IO_PAD12_PIOCFG_PULL_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD12_PIOCFG_PULL_SEL_MASK) | (((uint32_t)val) << IO_PAD12_PIOCFG_PULL_SEL_SHIFT))

#define  IO_PAD12_PIOCFG_PUEN_MASK 0x4000
#define  IO_PAD12_PIOCFG_PUEN_SHIFT 14
#define  IO_PAD12_PIOCFG_PUEN_MASK_SHIFT(reg) (((reg) & IO_PAD12_PIOCFG_PUEN_MASK) >> IO_PAD12_PIOCFG_PUEN_SHIFT)
#define  IO_PAD12_PIOCFG_PUEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD12_PIOCFG_PUEN_MASK) | (((uint32_t)val) << IO_PAD12_PIOCFG_PUEN_SHIFT))

#define  IO_PAD12_PIOCFG_PDEN_MASK 0x2000
#define  IO_PAD12_PIOCFG_PDEN_SHIFT 13
#define  IO_PAD12_PIOCFG_PDEN_MASK_SHIFT(reg) (((reg) & IO_PAD12_PIOCFG_PDEN_MASK) >> IO_PAD12_PIOCFG_PDEN_SHIFT)
#define  IO_PAD12_PIOCFG_PDEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD12_PIOCFG_PDEN_MASK) | (((uint32_t)val) << IO_PAD12_PIOCFG_PDEN_SHIFT))

#define  IO_PAD12_PIOCFG_SR_MASK 0x1800
#define  IO_PAD12_PIOCFG_SR_SHIFT 11
#define  IO_PAD12_PIOCFG_SR_MASK_SHIFT(reg) (((reg) & IO_PAD12_PIOCFG_SR_MASK) >> IO_PAD12_PIOCFG_SR_SHIFT)
#define  IO_PAD12_PIOCFG_SR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD12_PIOCFG_SR_MASK) | (((uint32_t)val) << IO_PAD12_PIOCFG_SR_SHIFT))

#define  IO_PAD12_PIOCFG_SLP_DI_MASK 0x400
#define  IO_PAD12_PIOCFG_SLP_DI_SHIFT 10
#define  IO_PAD12_PIOCFG_SLP_DI_MASK_SHIFT(reg) (((reg) & IO_PAD12_PIOCFG_SLP_DI_MASK) >> IO_PAD12_PIOCFG_SLP_DI_SHIFT)
#define  IO_PAD12_PIOCFG_SLP_DI_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD12_PIOCFG_SLP_DI_MASK) | (((uint32_t)val) << IO_PAD12_PIOCFG_SLP_DI_SHIFT))

#define  IO_PAD12_PIOCFG_SLP_CNTRL_MASK 0x200
#define  IO_PAD12_PIOCFG_SLP_CNTRL_SHIFT 9
#define  IO_PAD12_PIOCFG_SLP_CNTRL_MASK_SHIFT(reg) (((reg) & IO_PAD12_PIOCFG_SLP_CNTRL_MASK) >> IO_PAD12_PIOCFG_SLP_CNTRL_SHIFT)
#define  IO_PAD12_PIOCFG_SLP_CNTRL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD12_PIOCFG_SLP_CNTRL_MASK) | (((uint32_t)val) << IO_PAD12_PIOCFG_SLP_CNTRL_SHIFT))

#define  IO_PAD12_PIOCFG_SLP_DO_MASK 0x100
#define  IO_PAD12_PIOCFG_SLP_DO_SHIFT 8
#define  IO_PAD12_PIOCFG_SLP_DO_MASK_SHIFT(reg) (((reg) & IO_PAD12_PIOCFG_SLP_DO_MASK) >> IO_PAD12_PIOCFG_SLP_DO_SHIFT)
#define  IO_PAD12_PIOCFG_SLP_DO_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD12_PIOCFG_SLP_DO_MASK) | (((uint32_t)val) << IO_PAD12_PIOCFG_SLP_DO_SHIFT))

#define  IO_PAD12_PIOCFG_SLP_DIR_MASK 0x80
#define  IO_PAD12_PIOCFG_SLP_DIR_SHIFT 7
#define  IO_PAD12_PIOCFG_SLP_DIR_MASK_SHIFT(reg) (((reg) & IO_PAD12_PIOCFG_SLP_DIR_MASK) >> IO_PAD12_PIOCFG_SLP_DIR_SHIFT)
#define  IO_PAD12_PIOCFG_SLP_DIR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD12_PIOCFG_SLP_DIR_MASK) | (((uint32_t)val) << IO_PAD12_PIOCFG_SLP_DIR_SHIFT))

#define  IO_PAD12_PIOCFG_EDGE_EN_N_MASK 0x40
#define  IO_PAD12_PIOCFG_EDGE_EN_N_SHIFT 6
#define  IO_PAD12_PIOCFG_EDGE_EN_N_MASK_SHIFT(reg) (((reg) & IO_PAD12_PIOCFG_EDGE_EN_N_MASK) >> IO_PAD12_PIOCFG_EDGE_EN_N_SHIFT)
#define  IO_PAD12_PIOCFG_EDGE_EN_N_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD12_PIOCFG_EDGE_EN_N_MASK) | (((uint32_t)val) << IO_PAD12_PIOCFG_EDGE_EN_N_SHIFT))

#define  IO_PAD12_PIOCFG_EDGE_FALL_EN_MASK 0x20
#define  IO_PAD12_PIOCFG_EDGE_FALL_EN_SHIFT 5
#define  IO_PAD12_PIOCFG_EDGE_FALL_EN_MASK_SHIFT(reg) (((reg) & IO_PAD12_PIOCFG_EDGE_FALL_EN_MASK) >> IO_PAD12_PIOCFG_EDGE_FALL_EN_SHIFT)
#define  IO_PAD12_PIOCFG_EDGE_FALL_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD12_PIOCFG_EDGE_FALL_EN_MASK) | (((uint32_t)val) << IO_PAD12_PIOCFG_EDGE_FALL_EN_SHIFT))

#define  IO_PAD12_PIOCFG_EDGE_RISE_EN_MASK 0x10
#define  IO_PAD12_PIOCFG_EDGE_RISE_EN_SHIFT 4
#define  IO_PAD12_PIOCFG_EDGE_RISE_EN_MASK_SHIFT(reg) (((reg) & IO_PAD12_PIOCFG_EDGE_RISE_EN_MASK) >> IO_PAD12_PIOCFG_EDGE_RISE_EN_SHIFT)
#define  IO_PAD12_PIOCFG_EDGE_RISE_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD12_PIOCFG_EDGE_RISE_EN_MASK) | (((uint32_t)val) << IO_PAD12_PIOCFG_EDGE_RISE_EN_SHIFT))

#define  IO_PAD12_PIOCFG_SLP_SEL_MASK 0x8
#define  IO_PAD12_PIOCFG_SLP_SEL_SHIFT 3
#define  IO_PAD12_PIOCFG_SLP_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD12_PIOCFG_SLP_SEL_MASK) >> IO_PAD12_PIOCFG_SLP_SEL_SHIFT)
#define  IO_PAD12_PIOCFG_SLP_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD12_PIOCFG_SLP_SEL_MASK) | (((uint32_t)val) << IO_PAD12_PIOCFG_SLP_SEL_SHIFT))

#define  IO_PAD12_PIOCFG_FUNC_SEL_MASK 0x7
#define  IO_PAD12_PIOCFG_FUNC_SEL_SHIFT 0
#define  IO_PAD12_PIOCFG_FUNC_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD12_PIOCFG_FUNC_SEL_MASK) >> IO_PAD12_PIOCFG_FUNC_SEL_SHIFT)
#define  IO_PAD12_PIOCFG_FUNC_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD12_PIOCFG_FUNC_SEL_MASK) | (((uint32_t)val) << IO_PAD12_PIOCFG_FUNC_SEL_SHIFT))

//====================================================================
//
//Register File: IO_PAD13 Configuration Registers (IO_PAD13)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

//====================================================================
//Register: IO_PAD13 Configuration Register (PIOCFG)
/** \brief "PHI_PADXDC_HSIOB" Pad*/
//====================================================================

#define  IO_PAD13_PIOCFG_RESERVED1_MASK 0xfc000000
#define  IO_PAD13_PIOCFG_RESERVED1_SHIFT 26
#define  IO_PAD13_PIOCFG_RESERVED1_MASK_SHIFT(reg) (((reg) & IO_PAD13_PIOCFG_RESERVED1_MASK) >> IO_PAD13_PIOCFG_RESERVED1_SHIFT)
#define  IO_PAD13_PIOCFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD13_PIOCFG_RESERVED1_MASK) | (((uint32_t)val) << IO_PAD13_PIOCFG_RESERVED1_SHIFT))

#define  IO_PAD13_PIOCFG_PD_MASK 0x2000000
#define  IO_PAD13_PIOCFG_PD_SHIFT 25
#define  IO_PAD13_PIOCFG_PD_MASK_SHIFT(reg) (((reg) & IO_PAD13_PIOCFG_PD_MASK) >> IO_PAD13_PIOCFG_PD_SHIFT)
#define  IO_PAD13_PIOCFG_PD_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD13_PIOCFG_PD_MASK) | (((uint32_t)val) << IO_PAD13_PIOCFG_PD_SHIFT))

#define  IO_PAD13_PIOCFG_ODT_EN_MASK 0x1000000
#define  IO_PAD13_PIOCFG_ODT_EN_SHIFT 24
#define  IO_PAD13_PIOCFG_ODT_EN_MASK_SHIFT(reg) (((reg) & IO_PAD13_PIOCFG_ODT_EN_MASK) >> IO_PAD13_PIOCFG_ODT_EN_SHIFT)
#define  IO_PAD13_PIOCFG_ODT_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD13_PIOCFG_ODT_EN_MASK) | (((uint32_t)val) << IO_PAD13_PIOCFG_ODT_EN_SHIFT))

#define  IO_PAD13_PIOCFG_LED_EN_MASK 0x800000
#define  IO_PAD13_PIOCFG_LED_EN_SHIFT 23
#define  IO_PAD13_PIOCFG_LED_EN_MASK_SHIFT(reg) (((reg) & IO_PAD13_PIOCFG_LED_EN_MASK) >> IO_PAD13_PIOCFG_LED_EN_SHIFT)
#define  IO_PAD13_PIOCFG_LED_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD13_PIOCFG_LED_EN_MASK) | (((uint32_t)val) << IO_PAD13_PIOCFG_LED_EN_SHIFT))

#define  IO_PAD13_PIOCFG_I2C_SEL_MASK 0x600000
#define  IO_PAD13_PIOCFG_I2C_SEL_SHIFT 21
#define  IO_PAD13_PIOCFG_I2C_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD13_PIOCFG_I2C_SEL_MASK) >> IO_PAD13_PIOCFG_I2C_SEL_SHIFT)
#define  IO_PAD13_PIOCFG_I2C_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD13_PIOCFG_I2C_SEL_MASK) | (((uint32_t)val) << IO_PAD13_PIOCFG_I2C_SEL_SHIFT))

#define  IO_PAD13_PIOCFG_DGTBSEL_MASK 0x1e0000
#define  IO_PAD13_PIOCFG_DGTBSEL_SHIFT 17
#define  IO_PAD13_PIOCFG_DGTBSEL_MASK_SHIFT(reg) (((reg) & IO_PAD13_PIOCFG_DGTBSEL_MASK) >> IO_PAD13_PIOCFG_DGTBSEL_SHIFT)
#define  IO_PAD13_PIOCFG_DGTBSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD13_PIOCFG_DGTBSEL_MASK) | (((uint32_t)val) << IO_PAD13_PIOCFG_DGTBSEL_SHIFT))

#define  IO_PAD13_PIOCFG_RAWSEL_MASK 0x10000
#define  IO_PAD13_PIOCFG_RAWSEL_SHIFT 16
#define  IO_PAD13_PIOCFG_RAWSEL_MASK_SHIFT(reg) (((reg) & IO_PAD13_PIOCFG_RAWSEL_MASK) >> IO_PAD13_PIOCFG_RAWSEL_SHIFT)
#define  IO_PAD13_PIOCFG_RAWSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD13_PIOCFG_RAWSEL_MASK) | (((uint32_t)val) << IO_PAD13_PIOCFG_RAWSEL_SHIFT))

#define  IO_PAD13_PIOCFG_PULL_SEL_MASK 0x8000
#define  IO_PAD13_PIOCFG_PULL_SEL_SHIFT 15
#define  IO_PAD13_PIOCFG_PULL_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD13_PIOCFG_PULL_SEL_MASK) >> IO_PAD13_PIOCFG_PULL_SEL_SHIFT)
#define  IO_PAD13_PIOCFG_PULL_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD13_PIOCFG_PULL_SEL_MASK) | (((uint32_t)val) << IO_PAD13_PIOCFG_PULL_SEL_SHIFT))

#define  IO_PAD13_PIOCFG_PUEN_MASK 0x4000
#define  IO_PAD13_PIOCFG_PUEN_SHIFT 14
#define  IO_PAD13_PIOCFG_PUEN_MASK_SHIFT(reg) (((reg) & IO_PAD13_PIOCFG_PUEN_MASK) >> IO_PAD13_PIOCFG_PUEN_SHIFT)
#define  IO_PAD13_PIOCFG_PUEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD13_PIOCFG_PUEN_MASK) | (((uint32_t)val) << IO_PAD13_PIOCFG_PUEN_SHIFT))

#define  IO_PAD13_PIOCFG_PDEN_MASK 0x2000
#define  IO_PAD13_PIOCFG_PDEN_SHIFT 13
#define  IO_PAD13_PIOCFG_PDEN_MASK_SHIFT(reg) (((reg) & IO_PAD13_PIOCFG_PDEN_MASK) >> IO_PAD13_PIOCFG_PDEN_SHIFT)
#define  IO_PAD13_PIOCFG_PDEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD13_PIOCFG_PDEN_MASK) | (((uint32_t)val) << IO_PAD13_PIOCFG_PDEN_SHIFT))

#define  IO_PAD13_PIOCFG_SR_MASK 0x1800
#define  IO_PAD13_PIOCFG_SR_SHIFT 11
#define  IO_PAD13_PIOCFG_SR_MASK_SHIFT(reg) (((reg) & IO_PAD13_PIOCFG_SR_MASK) >> IO_PAD13_PIOCFG_SR_SHIFT)
#define  IO_PAD13_PIOCFG_SR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD13_PIOCFG_SR_MASK) | (((uint32_t)val) << IO_PAD13_PIOCFG_SR_SHIFT))

#define  IO_PAD13_PIOCFG_SLP_DI_MASK 0x400
#define  IO_PAD13_PIOCFG_SLP_DI_SHIFT 10
#define  IO_PAD13_PIOCFG_SLP_DI_MASK_SHIFT(reg) (((reg) & IO_PAD13_PIOCFG_SLP_DI_MASK) >> IO_PAD13_PIOCFG_SLP_DI_SHIFT)
#define  IO_PAD13_PIOCFG_SLP_DI_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD13_PIOCFG_SLP_DI_MASK) | (((uint32_t)val) << IO_PAD13_PIOCFG_SLP_DI_SHIFT))

#define  IO_PAD13_PIOCFG_SLP_CNTRL_MASK 0x200
#define  IO_PAD13_PIOCFG_SLP_CNTRL_SHIFT 9
#define  IO_PAD13_PIOCFG_SLP_CNTRL_MASK_SHIFT(reg) (((reg) & IO_PAD13_PIOCFG_SLP_CNTRL_MASK) >> IO_PAD13_PIOCFG_SLP_CNTRL_SHIFT)
#define  IO_PAD13_PIOCFG_SLP_CNTRL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD13_PIOCFG_SLP_CNTRL_MASK) | (((uint32_t)val) << IO_PAD13_PIOCFG_SLP_CNTRL_SHIFT))

#define  IO_PAD13_PIOCFG_SLP_DO_MASK 0x100
#define  IO_PAD13_PIOCFG_SLP_DO_SHIFT 8
#define  IO_PAD13_PIOCFG_SLP_DO_MASK_SHIFT(reg) (((reg) & IO_PAD13_PIOCFG_SLP_DO_MASK) >> IO_PAD13_PIOCFG_SLP_DO_SHIFT)
#define  IO_PAD13_PIOCFG_SLP_DO_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD13_PIOCFG_SLP_DO_MASK) | (((uint32_t)val) << IO_PAD13_PIOCFG_SLP_DO_SHIFT))

#define  IO_PAD13_PIOCFG_SLP_DIR_MASK 0x80
#define  IO_PAD13_PIOCFG_SLP_DIR_SHIFT 7
#define  IO_PAD13_PIOCFG_SLP_DIR_MASK_SHIFT(reg) (((reg) & IO_PAD13_PIOCFG_SLP_DIR_MASK) >> IO_PAD13_PIOCFG_SLP_DIR_SHIFT)
#define  IO_PAD13_PIOCFG_SLP_DIR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD13_PIOCFG_SLP_DIR_MASK) | (((uint32_t)val) << IO_PAD13_PIOCFG_SLP_DIR_SHIFT))

#define  IO_PAD13_PIOCFG_EDGE_EN_N_MASK 0x40
#define  IO_PAD13_PIOCFG_EDGE_EN_N_SHIFT 6
#define  IO_PAD13_PIOCFG_EDGE_EN_N_MASK_SHIFT(reg) (((reg) & IO_PAD13_PIOCFG_EDGE_EN_N_MASK) >> IO_PAD13_PIOCFG_EDGE_EN_N_SHIFT)
#define  IO_PAD13_PIOCFG_EDGE_EN_N_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD13_PIOCFG_EDGE_EN_N_MASK) | (((uint32_t)val) << IO_PAD13_PIOCFG_EDGE_EN_N_SHIFT))

#define  IO_PAD13_PIOCFG_EDGE_FALL_EN_MASK 0x20
#define  IO_PAD13_PIOCFG_EDGE_FALL_EN_SHIFT 5
#define  IO_PAD13_PIOCFG_EDGE_FALL_EN_MASK_SHIFT(reg) (((reg) & IO_PAD13_PIOCFG_EDGE_FALL_EN_MASK) >> IO_PAD13_PIOCFG_EDGE_FALL_EN_SHIFT)
#define  IO_PAD13_PIOCFG_EDGE_FALL_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD13_PIOCFG_EDGE_FALL_EN_MASK) | (((uint32_t)val) << IO_PAD13_PIOCFG_EDGE_FALL_EN_SHIFT))

#define  IO_PAD13_PIOCFG_EDGE_RISE_EN_MASK 0x10
#define  IO_PAD13_PIOCFG_EDGE_RISE_EN_SHIFT 4
#define  IO_PAD13_PIOCFG_EDGE_RISE_EN_MASK_SHIFT(reg) (((reg) & IO_PAD13_PIOCFG_EDGE_RISE_EN_MASK) >> IO_PAD13_PIOCFG_EDGE_RISE_EN_SHIFT)
#define  IO_PAD13_PIOCFG_EDGE_RISE_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD13_PIOCFG_EDGE_RISE_EN_MASK) | (((uint32_t)val) << IO_PAD13_PIOCFG_EDGE_RISE_EN_SHIFT))

#define  IO_PAD13_PIOCFG_SLP_SEL_MASK 0x8
#define  IO_PAD13_PIOCFG_SLP_SEL_SHIFT 3
#define  IO_PAD13_PIOCFG_SLP_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD13_PIOCFG_SLP_SEL_MASK) >> IO_PAD13_PIOCFG_SLP_SEL_SHIFT)
#define  IO_PAD13_PIOCFG_SLP_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD13_PIOCFG_SLP_SEL_MASK) | (((uint32_t)val) << IO_PAD13_PIOCFG_SLP_SEL_SHIFT))

#define  IO_PAD13_PIOCFG_FUNC_SEL_MASK 0x7
#define  IO_PAD13_PIOCFG_FUNC_SEL_SHIFT 0
#define  IO_PAD13_PIOCFG_FUNC_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD13_PIOCFG_FUNC_SEL_MASK) >> IO_PAD13_PIOCFG_FUNC_SEL_SHIFT)
#define  IO_PAD13_PIOCFG_FUNC_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD13_PIOCFG_FUNC_SEL_MASK) | (((uint32_t)val) << IO_PAD13_PIOCFG_FUNC_SEL_SHIFT))

//====================================================================
//
//Register File: IO_PAD14 Configuration Registers (IO_PAD14)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

//====================================================================
//Register: IO_PAD14 Configuration Register (PIOCFG)
/** \brief "PHI_PADXDC_HSIOB" Pad*/
//====================================================================

#define  IO_PAD14_PIOCFG_RESERVED1_MASK 0xfc000000
#define  IO_PAD14_PIOCFG_RESERVED1_SHIFT 26
#define  IO_PAD14_PIOCFG_RESERVED1_MASK_SHIFT(reg) (((reg) & IO_PAD14_PIOCFG_RESERVED1_MASK) >> IO_PAD14_PIOCFG_RESERVED1_SHIFT)
#define  IO_PAD14_PIOCFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD14_PIOCFG_RESERVED1_MASK) | (((uint32_t)val) << IO_PAD14_PIOCFG_RESERVED1_SHIFT))

#define  IO_PAD14_PIOCFG_PD_MASK 0x2000000
#define  IO_PAD14_PIOCFG_PD_SHIFT 25
#define  IO_PAD14_PIOCFG_PD_MASK_SHIFT(reg) (((reg) & IO_PAD14_PIOCFG_PD_MASK) >> IO_PAD14_PIOCFG_PD_SHIFT)
#define  IO_PAD14_PIOCFG_PD_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD14_PIOCFG_PD_MASK) | (((uint32_t)val) << IO_PAD14_PIOCFG_PD_SHIFT))

#define  IO_PAD14_PIOCFG_ODT_EN_MASK 0x1000000
#define  IO_PAD14_PIOCFG_ODT_EN_SHIFT 24
#define  IO_PAD14_PIOCFG_ODT_EN_MASK_SHIFT(reg) (((reg) & IO_PAD14_PIOCFG_ODT_EN_MASK) >> IO_PAD14_PIOCFG_ODT_EN_SHIFT)
#define  IO_PAD14_PIOCFG_ODT_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD14_PIOCFG_ODT_EN_MASK) | (((uint32_t)val) << IO_PAD14_PIOCFG_ODT_EN_SHIFT))

#define  IO_PAD14_PIOCFG_LED_EN_MASK 0x800000
#define  IO_PAD14_PIOCFG_LED_EN_SHIFT 23
#define  IO_PAD14_PIOCFG_LED_EN_MASK_SHIFT(reg) (((reg) & IO_PAD14_PIOCFG_LED_EN_MASK) >> IO_PAD14_PIOCFG_LED_EN_SHIFT)
#define  IO_PAD14_PIOCFG_LED_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD14_PIOCFG_LED_EN_MASK) | (((uint32_t)val) << IO_PAD14_PIOCFG_LED_EN_SHIFT))

#define  IO_PAD14_PIOCFG_I2C_SEL_MASK 0x600000
#define  IO_PAD14_PIOCFG_I2C_SEL_SHIFT 21
#define  IO_PAD14_PIOCFG_I2C_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD14_PIOCFG_I2C_SEL_MASK) >> IO_PAD14_PIOCFG_I2C_SEL_SHIFT)
#define  IO_PAD14_PIOCFG_I2C_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD14_PIOCFG_I2C_SEL_MASK) | (((uint32_t)val) << IO_PAD14_PIOCFG_I2C_SEL_SHIFT))

#define  IO_PAD14_PIOCFG_DGTBSEL_MASK 0x1e0000
#define  IO_PAD14_PIOCFG_DGTBSEL_SHIFT 17
#define  IO_PAD14_PIOCFG_DGTBSEL_MASK_SHIFT(reg) (((reg) & IO_PAD14_PIOCFG_DGTBSEL_MASK) >> IO_PAD14_PIOCFG_DGTBSEL_SHIFT)
#define  IO_PAD14_PIOCFG_DGTBSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD14_PIOCFG_DGTBSEL_MASK) | (((uint32_t)val) << IO_PAD14_PIOCFG_DGTBSEL_SHIFT))

#define  IO_PAD14_PIOCFG_RAWSEL_MASK 0x10000
#define  IO_PAD14_PIOCFG_RAWSEL_SHIFT 16
#define  IO_PAD14_PIOCFG_RAWSEL_MASK_SHIFT(reg) (((reg) & IO_PAD14_PIOCFG_RAWSEL_MASK) >> IO_PAD14_PIOCFG_RAWSEL_SHIFT)
#define  IO_PAD14_PIOCFG_RAWSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD14_PIOCFG_RAWSEL_MASK) | (((uint32_t)val) << IO_PAD14_PIOCFG_RAWSEL_SHIFT))

#define  IO_PAD14_PIOCFG_PULL_SEL_MASK 0x8000
#define  IO_PAD14_PIOCFG_PULL_SEL_SHIFT 15
#define  IO_PAD14_PIOCFG_PULL_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD14_PIOCFG_PULL_SEL_MASK) >> IO_PAD14_PIOCFG_PULL_SEL_SHIFT)
#define  IO_PAD14_PIOCFG_PULL_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD14_PIOCFG_PULL_SEL_MASK) | (((uint32_t)val) << IO_PAD14_PIOCFG_PULL_SEL_SHIFT))

#define  IO_PAD14_PIOCFG_PUEN_MASK 0x4000
#define  IO_PAD14_PIOCFG_PUEN_SHIFT 14
#define  IO_PAD14_PIOCFG_PUEN_MASK_SHIFT(reg) (((reg) & IO_PAD14_PIOCFG_PUEN_MASK) >> IO_PAD14_PIOCFG_PUEN_SHIFT)
#define  IO_PAD14_PIOCFG_PUEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD14_PIOCFG_PUEN_MASK) | (((uint32_t)val) << IO_PAD14_PIOCFG_PUEN_SHIFT))

#define  IO_PAD14_PIOCFG_PDEN_MASK 0x2000
#define  IO_PAD14_PIOCFG_PDEN_SHIFT 13
#define  IO_PAD14_PIOCFG_PDEN_MASK_SHIFT(reg) (((reg) & IO_PAD14_PIOCFG_PDEN_MASK) >> IO_PAD14_PIOCFG_PDEN_SHIFT)
#define  IO_PAD14_PIOCFG_PDEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD14_PIOCFG_PDEN_MASK) | (((uint32_t)val) << IO_PAD14_PIOCFG_PDEN_SHIFT))

#define  IO_PAD14_PIOCFG_SR_MASK 0x1800
#define  IO_PAD14_PIOCFG_SR_SHIFT 11
#define  IO_PAD14_PIOCFG_SR_MASK_SHIFT(reg) (((reg) & IO_PAD14_PIOCFG_SR_MASK) >> IO_PAD14_PIOCFG_SR_SHIFT)
#define  IO_PAD14_PIOCFG_SR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD14_PIOCFG_SR_MASK) | (((uint32_t)val) << IO_PAD14_PIOCFG_SR_SHIFT))

#define  IO_PAD14_PIOCFG_SLP_DI_MASK 0x400
#define  IO_PAD14_PIOCFG_SLP_DI_SHIFT 10
#define  IO_PAD14_PIOCFG_SLP_DI_MASK_SHIFT(reg) (((reg) & IO_PAD14_PIOCFG_SLP_DI_MASK) >> IO_PAD14_PIOCFG_SLP_DI_SHIFT)
#define  IO_PAD14_PIOCFG_SLP_DI_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD14_PIOCFG_SLP_DI_MASK) | (((uint32_t)val) << IO_PAD14_PIOCFG_SLP_DI_SHIFT))

#define  IO_PAD14_PIOCFG_SLP_CNTRL_MASK 0x200
#define  IO_PAD14_PIOCFG_SLP_CNTRL_SHIFT 9
#define  IO_PAD14_PIOCFG_SLP_CNTRL_MASK_SHIFT(reg) (((reg) & IO_PAD14_PIOCFG_SLP_CNTRL_MASK) >> IO_PAD14_PIOCFG_SLP_CNTRL_SHIFT)
#define  IO_PAD14_PIOCFG_SLP_CNTRL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD14_PIOCFG_SLP_CNTRL_MASK) | (((uint32_t)val) << IO_PAD14_PIOCFG_SLP_CNTRL_SHIFT))

#define  IO_PAD14_PIOCFG_SLP_DO_MASK 0x100
#define  IO_PAD14_PIOCFG_SLP_DO_SHIFT 8
#define  IO_PAD14_PIOCFG_SLP_DO_MASK_SHIFT(reg) (((reg) & IO_PAD14_PIOCFG_SLP_DO_MASK) >> IO_PAD14_PIOCFG_SLP_DO_SHIFT)
#define  IO_PAD14_PIOCFG_SLP_DO_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD14_PIOCFG_SLP_DO_MASK) | (((uint32_t)val) << IO_PAD14_PIOCFG_SLP_DO_SHIFT))

#define  IO_PAD14_PIOCFG_SLP_DIR_MASK 0x80
#define  IO_PAD14_PIOCFG_SLP_DIR_SHIFT 7
#define  IO_PAD14_PIOCFG_SLP_DIR_MASK_SHIFT(reg) (((reg) & IO_PAD14_PIOCFG_SLP_DIR_MASK) >> IO_PAD14_PIOCFG_SLP_DIR_SHIFT)
#define  IO_PAD14_PIOCFG_SLP_DIR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD14_PIOCFG_SLP_DIR_MASK) | (((uint32_t)val) << IO_PAD14_PIOCFG_SLP_DIR_SHIFT))

#define  IO_PAD14_PIOCFG_EDGE_EN_N_MASK 0x40
#define  IO_PAD14_PIOCFG_EDGE_EN_N_SHIFT 6
#define  IO_PAD14_PIOCFG_EDGE_EN_N_MASK_SHIFT(reg) (((reg) & IO_PAD14_PIOCFG_EDGE_EN_N_MASK) >> IO_PAD14_PIOCFG_EDGE_EN_N_SHIFT)
#define  IO_PAD14_PIOCFG_EDGE_EN_N_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD14_PIOCFG_EDGE_EN_N_MASK) | (((uint32_t)val) << IO_PAD14_PIOCFG_EDGE_EN_N_SHIFT))

#define  IO_PAD14_PIOCFG_EDGE_FALL_EN_MASK 0x20
#define  IO_PAD14_PIOCFG_EDGE_FALL_EN_SHIFT 5
#define  IO_PAD14_PIOCFG_EDGE_FALL_EN_MASK_SHIFT(reg) (((reg) & IO_PAD14_PIOCFG_EDGE_FALL_EN_MASK) >> IO_PAD14_PIOCFG_EDGE_FALL_EN_SHIFT)
#define  IO_PAD14_PIOCFG_EDGE_FALL_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD14_PIOCFG_EDGE_FALL_EN_MASK) | (((uint32_t)val) << IO_PAD14_PIOCFG_EDGE_FALL_EN_SHIFT))

#define  IO_PAD14_PIOCFG_EDGE_RISE_EN_MASK 0x10
#define  IO_PAD14_PIOCFG_EDGE_RISE_EN_SHIFT 4
#define  IO_PAD14_PIOCFG_EDGE_RISE_EN_MASK_SHIFT(reg) (((reg) & IO_PAD14_PIOCFG_EDGE_RISE_EN_MASK) >> IO_PAD14_PIOCFG_EDGE_RISE_EN_SHIFT)
#define  IO_PAD14_PIOCFG_EDGE_RISE_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD14_PIOCFG_EDGE_RISE_EN_MASK) | (((uint32_t)val) << IO_PAD14_PIOCFG_EDGE_RISE_EN_SHIFT))

#define  IO_PAD14_PIOCFG_SLP_SEL_MASK 0x8
#define  IO_PAD14_PIOCFG_SLP_SEL_SHIFT 3
#define  IO_PAD14_PIOCFG_SLP_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD14_PIOCFG_SLP_SEL_MASK) >> IO_PAD14_PIOCFG_SLP_SEL_SHIFT)
#define  IO_PAD14_PIOCFG_SLP_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD14_PIOCFG_SLP_SEL_MASK) | (((uint32_t)val) << IO_PAD14_PIOCFG_SLP_SEL_SHIFT))

#define  IO_PAD14_PIOCFG_FUNC_SEL_MASK 0x7
#define  IO_PAD14_PIOCFG_FUNC_SEL_SHIFT 0
#define  IO_PAD14_PIOCFG_FUNC_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD14_PIOCFG_FUNC_SEL_MASK) >> IO_PAD14_PIOCFG_FUNC_SEL_SHIFT)
#define  IO_PAD14_PIOCFG_FUNC_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD14_PIOCFG_FUNC_SEL_MASK) | (((uint32_t)val) << IO_PAD14_PIOCFG_FUNC_SEL_SHIFT))

//====================================================================
//
//Register File: IO_PAD15 Configuration Registers (IO_PAD15)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

//====================================================================
//Register: IO_PAD15 Configuration Register (PIOCFG)
/** \brief "PHI_PADXDC_HSIOB" Pad*/
//====================================================================

#define  IO_PAD15_PIOCFG_RESERVED1_MASK 0xfc000000
#define  IO_PAD15_PIOCFG_RESERVED1_SHIFT 26
#define  IO_PAD15_PIOCFG_RESERVED1_MASK_SHIFT(reg) (((reg) & IO_PAD15_PIOCFG_RESERVED1_MASK) >> IO_PAD15_PIOCFG_RESERVED1_SHIFT)
#define  IO_PAD15_PIOCFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD15_PIOCFG_RESERVED1_MASK) | (((uint32_t)val) << IO_PAD15_PIOCFG_RESERVED1_SHIFT))

#define  IO_PAD15_PIOCFG_PD_MASK 0x2000000
#define  IO_PAD15_PIOCFG_PD_SHIFT 25
#define  IO_PAD15_PIOCFG_PD_MASK_SHIFT(reg) (((reg) & IO_PAD15_PIOCFG_PD_MASK) >> IO_PAD15_PIOCFG_PD_SHIFT)
#define  IO_PAD15_PIOCFG_PD_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD15_PIOCFG_PD_MASK) | (((uint32_t)val) << IO_PAD15_PIOCFG_PD_SHIFT))

#define  IO_PAD15_PIOCFG_ODT_EN_MASK 0x1000000
#define  IO_PAD15_PIOCFG_ODT_EN_SHIFT 24
#define  IO_PAD15_PIOCFG_ODT_EN_MASK_SHIFT(reg) (((reg) & IO_PAD15_PIOCFG_ODT_EN_MASK) >> IO_PAD15_PIOCFG_ODT_EN_SHIFT)
#define  IO_PAD15_PIOCFG_ODT_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD15_PIOCFG_ODT_EN_MASK) | (((uint32_t)val) << IO_PAD15_PIOCFG_ODT_EN_SHIFT))

#define  IO_PAD15_PIOCFG_LED_EN_MASK 0x800000
#define  IO_PAD15_PIOCFG_LED_EN_SHIFT 23
#define  IO_PAD15_PIOCFG_LED_EN_MASK_SHIFT(reg) (((reg) & IO_PAD15_PIOCFG_LED_EN_MASK) >> IO_PAD15_PIOCFG_LED_EN_SHIFT)
#define  IO_PAD15_PIOCFG_LED_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD15_PIOCFG_LED_EN_MASK) | (((uint32_t)val) << IO_PAD15_PIOCFG_LED_EN_SHIFT))

#define  IO_PAD15_PIOCFG_I2C_SEL_MASK 0x600000
#define  IO_PAD15_PIOCFG_I2C_SEL_SHIFT 21
#define  IO_PAD15_PIOCFG_I2C_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD15_PIOCFG_I2C_SEL_MASK) >> IO_PAD15_PIOCFG_I2C_SEL_SHIFT)
#define  IO_PAD15_PIOCFG_I2C_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD15_PIOCFG_I2C_SEL_MASK) | (((uint32_t)val) << IO_PAD15_PIOCFG_I2C_SEL_SHIFT))

#define  IO_PAD15_PIOCFG_DGTBSEL_MASK 0x1e0000
#define  IO_PAD15_PIOCFG_DGTBSEL_SHIFT 17
#define  IO_PAD15_PIOCFG_DGTBSEL_MASK_SHIFT(reg) (((reg) & IO_PAD15_PIOCFG_DGTBSEL_MASK) >> IO_PAD15_PIOCFG_DGTBSEL_SHIFT)
#define  IO_PAD15_PIOCFG_DGTBSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD15_PIOCFG_DGTBSEL_MASK) | (((uint32_t)val) << IO_PAD15_PIOCFG_DGTBSEL_SHIFT))

#define  IO_PAD15_PIOCFG_RAWSEL_MASK 0x10000
#define  IO_PAD15_PIOCFG_RAWSEL_SHIFT 16
#define  IO_PAD15_PIOCFG_RAWSEL_MASK_SHIFT(reg) (((reg) & IO_PAD15_PIOCFG_RAWSEL_MASK) >> IO_PAD15_PIOCFG_RAWSEL_SHIFT)
#define  IO_PAD15_PIOCFG_RAWSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD15_PIOCFG_RAWSEL_MASK) | (((uint32_t)val) << IO_PAD15_PIOCFG_RAWSEL_SHIFT))

#define  IO_PAD15_PIOCFG_PULL_SEL_MASK 0x8000
#define  IO_PAD15_PIOCFG_PULL_SEL_SHIFT 15
#define  IO_PAD15_PIOCFG_PULL_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD15_PIOCFG_PULL_SEL_MASK) >> IO_PAD15_PIOCFG_PULL_SEL_SHIFT)
#define  IO_PAD15_PIOCFG_PULL_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD15_PIOCFG_PULL_SEL_MASK) | (((uint32_t)val) << IO_PAD15_PIOCFG_PULL_SEL_SHIFT))

#define  IO_PAD15_PIOCFG_PUEN_MASK 0x4000
#define  IO_PAD15_PIOCFG_PUEN_SHIFT 14
#define  IO_PAD15_PIOCFG_PUEN_MASK_SHIFT(reg) (((reg) & IO_PAD15_PIOCFG_PUEN_MASK) >> IO_PAD15_PIOCFG_PUEN_SHIFT)
#define  IO_PAD15_PIOCFG_PUEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD15_PIOCFG_PUEN_MASK) | (((uint32_t)val) << IO_PAD15_PIOCFG_PUEN_SHIFT))

#define  IO_PAD15_PIOCFG_PDEN_MASK 0x2000
#define  IO_PAD15_PIOCFG_PDEN_SHIFT 13
#define  IO_PAD15_PIOCFG_PDEN_MASK_SHIFT(reg) (((reg) & IO_PAD15_PIOCFG_PDEN_MASK) >> IO_PAD15_PIOCFG_PDEN_SHIFT)
#define  IO_PAD15_PIOCFG_PDEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD15_PIOCFG_PDEN_MASK) | (((uint32_t)val) << IO_PAD15_PIOCFG_PDEN_SHIFT))

#define  IO_PAD15_PIOCFG_SR_MASK 0x1800
#define  IO_PAD15_PIOCFG_SR_SHIFT 11
#define  IO_PAD15_PIOCFG_SR_MASK_SHIFT(reg) (((reg) & IO_PAD15_PIOCFG_SR_MASK) >> IO_PAD15_PIOCFG_SR_SHIFT)
#define  IO_PAD15_PIOCFG_SR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD15_PIOCFG_SR_MASK) | (((uint32_t)val) << IO_PAD15_PIOCFG_SR_SHIFT))

#define  IO_PAD15_PIOCFG_SLP_DI_MASK 0x400
#define  IO_PAD15_PIOCFG_SLP_DI_SHIFT 10
#define  IO_PAD15_PIOCFG_SLP_DI_MASK_SHIFT(reg) (((reg) & IO_PAD15_PIOCFG_SLP_DI_MASK) >> IO_PAD15_PIOCFG_SLP_DI_SHIFT)
#define  IO_PAD15_PIOCFG_SLP_DI_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD15_PIOCFG_SLP_DI_MASK) | (((uint32_t)val) << IO_PAD15_PIOCFG_SLP_DI_SHIFT))

#define  IO_PAD15_PIOCFG_SLP_CNTRL_MASK 0x200
#define  IO_PAD15_PIOCFG_SLP_CNTRL_SHIFT 9
#define  IO_PAD15_PIOCFG_SLP_CNTRL_MASK_SHIFT(reg) (((reg) & IO_PAD15_PIOCFG_SLP_CNTRL_MASK) >> IO_PAD15_PIOCFG_SLP_CNTRL_SHIFT)
#define  IO_PAD15_PIOCFG_SLP_CNTRL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD15_PIOCFG_SLP_CNTRL_MASK) | (((uint32_t)val) << IO_PAD15_PIOCFG_SLP_CNTRL_SHIFT))

#define  IO_PAD15_PIOCFG_SLP_DO_MASK 0x100
#define  IO_PAD15_PIOCFG_SLP_DO_SHIFT 8
#define  IO_PAD15_PIOCFG_SLP_DO_MASK_SHIFT(reg) (((reg) & IO_PAD15_PIOCFG_SLP_DO_MASK) >> IO_PAD15_PIOCFG_SLP_DO_SHIFT)
#define  IO_PAD15_PIOCFG_SLP_DO_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD15_PIOCFG_SLP_DO_MASK) | (((uint32_t)val) << IO_PAD15_PIOCFG_SLP_DO_SHIFT))

#define  IO_PAD15_PIOCFG_SLP_DIR_MASK 0x80
#define  IO_PAD15_PIOCFG_SLP_DIR_SHIFT 7
#define  IO_PAD15_PIOCFG_SLP_DIR_MASK_SHIFT(reg) (((reg) & IO_PAD15_PIOCFG_SLP_DIR_MASK) >> IO_PAD15_PIOCFG_SLP_DIR_SHIFT)
#define  IO_PAD15_PIOCFG_SLP_DIR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD15_PIOCFG_SLP_DIR_MASK) | (((uint32_t)val) << IO_PAD15_PIOCFG_SLP_DIR_SHIFT))

#define  IO_PAD15_PIOCFG_EDGE_EN_N_MASK 0x40
#define  IO_PAD15_PIOCFG_EDGE_EN_N_SHIFT 6
#define  IO_PAD15_PIOCFG_EDGE_EN_N_MASK_SHIFT(reg) (((reg) & IO_PAD15_PIOCFG_EDGE_EN_N_MASK) >> IO_PAD15_PIOCFG_EDGE_EN_N_SHIFT)
#define  IO_PAD15_PIOCFG_EDGE_EN_N_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD15_PIOCFG_EDGE_EN_N_MASK) | (((uint32_t)val) << IO_PAD15_PIOCFG_EDGE_EN_N_SHIFT))

#define  IO_PAD15_PIOCFG_EDGE_FALL_EN_MASK 0x20
#define  IO_PAD15_PIOCFG_EDGE_FALL_EN_SHIFT 5
#define  IO_PAD15_PIOCFG_EDGE_FALL_EN_MASK_SHIFT(reg) (((reg) & IO_PAD15_PIOCFG_EDGE_FALL_EN_MASK) >> IO_PAD15_PIOCFG_EDGE_FALL_EN_SHIFT)
#define  IO_PAD15_PIOCFG_EDGE_FALL_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD15_PIOCFG_EDGE_FALL_EN_MASK) | (((uint32_t)val) << IO_PAD15_PIOCFG_EDGE_FALL_EN_SHIFT))

#define  IO_PAD15_PIOCFG_EDGE_RISE_EN_MASK 0x10
#define  IO_PAD15_PIOCFG_EDGE_RISE_EN_SHIFT 4
#define  IO_PAD15_PIOCFG_EDGE_RISE_EN_MASK_SHIFT(reg) (((reg) & IO_PAD15_PIOCFG_EDGE_RISE_EN_MASK) >> IO_PAD15_PIOCFG_EDGE_RISE_EN_SHIFT)
#define  IO_PAD15_PIOCFG_EDGE_RISE_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD15_PIOCFG_EDGE_RISE_EN_MASK) | (((uint32_t)val) << IO_PAD15_PIOCFG_EDGE_RISE_EN_SHIFT))

#define  IO_PAD15_PIOCFG_SLP_SEL_MASK 0x8
#define  IO_PAD15_PIOCFG_SLP_SEL_SHIFT 3
#define  IO_PAD15_PIOCFG_SLP_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD15_PIOCFG_SLP_SEL_MASK) >> IO_PAD15_PIOCFG_SLP_SEL_SHIFT)
#define  IO_PAD15_PIOCFG_SLP_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD15_PIOCFG_SLP_SEL_MASK) | (((uint32_t)val) << IO_PAD15_PIOCFG_SLP_SEL_SHIFT))

#define  IO_PAD15_PIOCFG_FUNC_SEL_MASK 0x7
#define  IO_PAD15_PIOCFG_FUNC_SEL_SHIFT 0
#define  IO_PAD15_PIOCFG_FUNC_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD15_PIOCFG_FUNC_SEL_MASK) >> IO_PAD15_PIOCFG_FUNC_SEL_SHIFT)
#define  IO_PAD15_PIOCFG_FUNC_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD15_PIOCFG_FUNC_SEL_MASK) | (((uint32_t)val) << IO_PAD15_PIOCFG_FUNC_SEL_SHIFT))

//====================================================================
//
//Register File: IO_PAD16 Configuration Registers (IO_PAD16)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

//====================================================================
//Register: IO_PAD16 Configuration Register (PIOCFG)
/** \brief "PHI_PADXDC_HSIOB" Pad*/
//====================================================================

#define  IO_PAD16_PIOCFG_RESERVED1_MASK 0xfc000000
#define  IO_PAD16_PIOCFG_RESERVED1_SHIFT 26
#define  IO_PAD16_PIOCFG_RESERVED1_MASK_SHIFT(reg) (((reg) & IO_PAD16_PIOCFG_RESERVED1_MASK) >> IO_PAD16_PIOCFG_RESERVED1_SHIFT)
#define  IO_PAD16_PIOCFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD16_PIOCFG_RESERVED1_MASK) | (((uint32_t)val) << IO_PAD16_PIOCFG_RESERVED1_SHIFT))

#define  IO_PAD16_PIOCFG_PD_MASK 0x2000000
#define  IO_PAD16_PIOCFG_PD_SHIFT 25
#define  IO_PAD16_PIOCFG_PD_MASK_SHIFT(reg) (((reg) & IO_PAD16_PIOCFG_PD_MASK) >> IO_PAD16_PIOCFG_PD_SHIFT)
#define  IO_PAD16_PIOCFG_PD_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD16_PIOCFG_PD_MASK) | (((uint32_t)val) << IO_PAD16_PIOCFG_PD_SHIFT))

#define  IO_PAD16_PIOCFG_ODT_EN_MASK 0x1000000
#define  IO_PAD16_PIOCFG_ODT_EN_SHIFT 24
#define  IO_PAD16_PIOCFG_ODT_EN_MASK_SHIFT(reg) (((reg) & IO_PAD16_PIOCFG_ODT_EN_MASK) >> IO_PAD16_PIOCFG_ODT_EN_SHIFT)
#define  IO_PAD16_PIOCFG_ODT_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD16_PIOCFG_ODT_EN_MASK) | (((uint32_t)val) << IO_PAD16_PIOCFG_ODT_EN_SHIFT))

#define  IO_PAD16_PIOCFG_LED_EN_MASK 0x800000
#define  IO_PAD16_PIOCFG_LED_EN_SHIFT 23
#define  IO_PAD16_PIOCFG_LED_EN_MASK_SHIFT(reg) (((reg) & IO_PAD16_PIOCFG_LED_EN_MASK) >> IO_PAD16_PIOCFG_LED_EN_SHIFT)
#define  IO_PAD16_PIOCFG_LED_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD16_PIOCFG_LED_EN_MASK) | (((uint32_t)val) << IO_PAD16_PIOCFG_LED_EN_SHIFT))

#define  IO_PAD16_PIOCFG_I2C_SEL_MASK 0x600000
#define  IO_PAD16_PIOCFG_I2C_SEL_SHIFT 21
#define  IO_PAD16_PIOCFG_I2C_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD16_PIOCFG_I2C_SEL_MASK) >> IO_PAD16_PIOCFG_I2C_SEL_SHIFT)
#define  IO_PAD16_PIOCFG_I2C_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD16_PIOCFG_I2C_SEL_MASK) | (((uint32_t)val) << IO_PAD16_PIOCFG_I2C_SEL_SHIFT))

#define  IO_PAD16_PIOCFG_DGTBSEL_MASK 0x1e0000
#define  IO_PAD16_PIOCFG_DGTBSEL_SHIFT 17
#define  IO_PAD16_PIOCFG_DGTBSEL_MASK_SHIFT(reg) (((reg) & IO_PAD16_PIOCFG_DGTBSEL_MASK) >> IO_PAD16_PIOCFG_DGTBSEL_SHIFT)
#define  IO_PAD16_PIOCFG_DGTBSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD16_PIOCFG_DGTBSEL_MASK) | (((uint32_t)val) << IO_PAD16_PIOCFG_DGTBSEL_SHIFT))

#define  IO_PAD16_PIOCFG_RAWSEL_MASK 0x10000
#define  IO_PAD16_PIOCFG_RAWSEL_SHIFT 16
#define  IO_PAD16_PIOCFG_RAWSEL_MASK_SHIFT(reg) (((reg) & IO_PAD16_PIOCFG_RAWSEL_MASK) >> IO_PAD16_PIOCFG_RAWSEL_SHIFT)
#define  IO_PAD16_PIOCFG_RAWSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD16_PIOCFG_RAWSEL_MASK) | (((uint32_t)val) << IO_PAD16_PIOCFG_RAWSEL_SHIFT))

#define  IO_PAD16_PIOCFG_PULL_SEL_MASK 0x8000
#define  IO_PAD16_PIOCFG_PULL_SEL_SHIFT 15
#define  IO_PAD16_PIOCFG_PULL_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD16_PIOCFG_PULL_SEL_MASK) >> IO_PAD16_PIOCFG_PULL_SEL_SHIFT)
#define  IO_PAD16_PIOCFG_PULL_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD16_PIOCFG_PULL_SEL_MASK) | (((uint32_t)val) << IO_PAD16_PIOCFG_PULL_SEL_SHIFT))

#define  IO_PAD16_PIOCFG_PUEN_MASK 0x4000
#define  IO_PAD16_PIOCFG_PUEN_SHIFT 14
#define  IO_PAD16_PIOCFG_PUEN_MASK_SHIFT(reg) (((reg) & IO_PAD16_PIOCFG_PUEN_MASK) >> IO_PAD16_PIOCFG_PUEN_SHIFT)
#define  IO_PAD16_PIOCFG_PUEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD16_PIOCFG_PUEN_MASK) | (((uint32_t)val) << IO_PAD16_PIOCFG_PUEN_SHIFT))

#define  IO_PAD16_PIOCFG_PDEN_MASK 0x2000
#define  IO_PAD16_PIOCFG_PDEN_SHIFT 13
#define  IO_PAD16_PIOCFG_PDEN_MASK_SHIFT(reg) (((reg) & IO_PAD16_PIOCFG_PDEN_MASK) >> IO_PAD16_PIOCFG_PDEN_SHIFT)
#define  IO_PAD16_PIOCFG_PDEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD16_PIOCFG_PDEN_MASK) | (((uint32_t)val) << IO_PAD16_PIOCFG_PDEN_SHIFT))

#define  IO_PAD16_PIOCFG_SR_MASK 0x1800
#define  IO_PAD16_PIOCFG_SR_SHIFT 11
#define  IO_PAD16_PIOCFG_SR_MASK_SHIFT(reg) (((reg) & IO_PAD16_PIOCFG_SR_MASK) >> IO_PAD16_PIOCFG_SR_SHIFT)
#define  IO_PAD16_PIOCFG_SR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD16_PIOCFG_SR_MASK) | (((uint32_t)val) << IO_PAD16_PIOCFG_SR_SHIFT))

#define  IO_PAD16_PIOCFG_SLP_DI_MASK 0x400
#define  IO_PAD16_PIOCFG_SLP_DI_SHIFT 10
#define  IO_PAD16_PIOCFG_SLP_DI_MASK_SHIFT(reg) (((reg) & IO_PAD16_PIOCFG_SLP_DI_MASK) >> IO_PAD16_PIOCFG_SLP_DI_SHIFT)
#define  IO_PAD16_PIOCFG_SLP_DI_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD16_PIOCFG_SLP_DI_MASK) | (((uint32_t)val) << IO_PAD16_PIOCFG_SLP_DI_SHIFT))

#define  IO_PAD16_PIOCFG_SLP_CNTRL_MASK 0x200
#define  IO_PAD16_PIOCFG_SLP_CNTRL_SHIFT 9
#define  IO_PAD16_PIOCFG_SLP_CNTRL_MASK_SHIFT(reg) (((reg) & IO_PAD16_PIOCFG_SLP_CNTRL_MASK) >> IO_PAD16_PIOCFG_SLP_CNTRL_SHIFT)
#define  IO_PAD16_PIOCFG_SLP_CNTRL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD16_PIOCFG_SLP_CNTRL_MASK) | (((uint32_t)val) << IO_PAD16_PIOCFG_SLP_CNTRL_SHIFT))

#define  IO_PAD16_PIOCFG_SLP_DO_MASK 0x100
#define  IO_PAD16_PIOCFG_SLP_DO_SHIFT 8
#define  IO_PAD16_PIOCFG_SLP_DO_MASK_SHIFT(reg) (((reg) & IO_PAD16_PIOCFG_SLP_DO_MASK) >> IO_PAD16_PIOCFG_SLP_DO_SHIFT)
#define  IO_PAD16_PIOCFG_SLP_DO_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD16_PIOCFG_SLP_DO_MASK) | (((uint32_t)val) << IO_PAD16_PIOCFG_SLP_DO_SHIFT))

#define  IO_PAD16_PIOCFG_SLP_DIR_MASK 0x80
#define  IO_PAD16_PIOCFG_SLP_DIR_SHIFT 7
#define  IO_PAD16_PIOCFG_SLP_DIR_MASK_SHIFT(reg) (((reg) & IO_PAD16_PIOCFG_SLP_DIR_MASK) >> IO_PAD16_PIOCFG_SLP_DIR_SHIFT)
#define  IO_PAD16_PIOCFG_SLP_DIR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD16_PIOCFG_SLP_DIR_MASK) | (((uint32_t)val) << IO_PAD16_PIOCFG_SLP_DIR_SHIFT))

#define  IO_PAD16_PIOCFG_EDGE_EN_N_MASK 0x40
#define  IO_PAD16_PIOCFG_EDGE_EN_N_SHIFT 6
#define  IO_PAD16_PIOCFG_EDGE_EN_N_MASK_SHIFT(reg) (((reg) & IO_PAD16_PIOCFG_EDGE_EN_N_MASK) >> IO_PAD16_PIOCFG_EDGE_EN_N_SHIFT)
#define  IO_PAD16_PIOCFG_EDGE_EN_N_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD16_PIOCFG_EDGE_EN_N_MASK) | (((uint32_t)val) << IO_PAD16_PIOCFG_EDGE_EN_N_SHIFT))

#define  IO_PAD16_PIOCFG_EDGE_FALL_EN_MASK 0x20
#define  IO_PAD16_PIOCFG_EDGE_FALL_EN_SHIFT 5
#define  IO_PAD16_PIOCFG_EDGE_FALL_EN_MASK_SHIFT(reg) (((reg) & IO_PAD16_PIOCFG_EDGE_FALL_EN_MASK) >> IO_PAD16_PIOCFG_EDGE_FALL_EN_SHIFT)
#define  IO_PAD16_PIOCFG_EDGE_FALL_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD16_PIOCFG_EDGE_FALL_EN_MASK) | (((uint32_t)val) << IO_PAD16_PIOCFG_EDGE_FALL_EN_SHIFT))

#define  IO_PAD16_PIOCFG_EDGE_RISE_EN_MASK 0x10
#define  IO_PAD16_PIOCFG_EDGE_RISE_EN_SHIFT 4
#define  IO_PAD16_PIOCFG_EDGE_RISE_EN_MASK_SHIFT(reg) (((reg) & IO_PAD16_PIOCFG_EDGE_RISE_EN_MASK) >> IO_PAD16_PIOCFG_EDGE_RISE_EN_SHIFT)
#define  IO_PAD16_PIOCFG_EDGE_RISE_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD16_PIOCFG_EDGE_RISE_EN_MASK) | (((uint32_t)val) << IO_PAD16_PIOCFG_EDGE_RISE_EN_SHIFT))

#define  IO_PAD16_PIOCFG_SLP_SEL_MASK 0x8
#define  IO_PAD16_PIOCFG_SLP_SEL_SHIFT 3
#define  IO_PAD16_PIOCFG_SLP_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD16_PIOCFG_SLP_SEL_MASK) >> IO_PAD16_PIOCFG_SLP_SEL_SHIFT)
#define  IO_PAD16_PIOCFG_SLP_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD16_PIOCFG_SLP_SEL_MASK) | (((uint32_t)val) << IO_PAD16_PIOCFG_SLP_SEL_SHIFT))

#define  IO_PAD16_PIOCFG_FUNC_SEL_MASK 0x7
#define  IO_PAD16_PIOCFG_FUNC_SEL_SHIFT 0
#define  IO_PAD16_PIOCFG_FUNC_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD16_PIOCFG_FUNC_SEL_MASK) >> IO_PAD16_PIOCFG_FUNC_SEL_SHIFT)
#define  IO_PAD16_PIOCFG_FUNC_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD16_PIOCFG_FUNC_SEL_MASK) | (((uint32_t)val) << IO_PAD16_PIOCFG_FUNC_SEL_SHIFT))

//====================================================================
//
//Register File: IO_PAD17 Configuration Registers (IO_PAD17)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

//====================================================================
//Register: IO_PAD17 Configuration Register (PIOCFG)
/** \brief "PHI_PADXDC_HSIOB" Pad*/
//====================================================================

#define  IO_PAD17_PIOCFG_RESERVED1_MASK 0xfc000000
#define  IO_PAD17_PIOCFG_RESERVED1_SHIFT 26
#define  IO_PAD17_PIOCFG_RESERVED1_MASK_SHIFT(reg) (((reg) & IO_PAD17_PIOCFG_RESERVED1_MASK) >> IO_PAD17_PIOCFG_RESERVED1_SHIFT)
#define  IO_PAD17_PIOCFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD17_PIOCFG_RESERVED1_MASK) | (((uint32_t)val) << IO_PAD17_PIOCFG_RESERVED1_SHIFT))

#define  IO_PAD17_PIOCFG_PD_MASK 0x2000000
#define  IO_PAD17_PIOCFG_PD_SHIFT 25
#define  IO_PAD17_PIOCFG_PD_MASK_SHIFT(reg) (((reg) & IO_PAD17_PIOCFG_PD_MASK) >> IO_PAD17_PIOCFG_PD_SHIFT)
#define  IO_PAD17_PIOCFG_PD_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD17_PIOCFG_PD_MASK) | (((uint32_t)val) << IO_PAD17_PIOCFG_PD_SHIFT))

#define  IO_PAD17_PIOCFG_ODT_EN_MASK 0x1000000
#define  IO_PAD17_PIOCFG_ODT_EN_SHIFT 24
#define  IO_PAD17_PIOCFG_ODT_EN_MASK_SHIFT(reg) (((reg) & IO_PAD17_PIOCFG_ODT_EN_MASK) >> IO_PAD17_PIOCFG_ODT_EN_SHIFT)
#define  IO_PAD17_PIOCFG_ODT_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD17_PIOCFG_ODT_EN_MASK) | (((uint32_t)val) << IO_PAD17_PIOCFG_ODT_EN_SHIFT))

#define  IO_PAD17_PIOCFG_LED_EN_MASK 0x800000
#define  IO_PAD17_PIOCFG_LED_EN_SHIFT 23
#define  IO_PAD17_PIOCFG_LED_EN_MASK_SHIFT(reg) (((reg) & IO_PAD17_PIOCFG_LED_EN_MASK) >> IO_PAD17_PIOCFG_LED_EN_SHIFT)
#define  IO_PAD17_PIOCFG_LED_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD17_PIOCFG_LED_EN_MASK) | (((uint32_t)val) << IO_PAD17_PIOCFG_LED_EN_SHIFT))

#define  IO_PAD17_PIOCFG_I2C_SEL_MASK 0x600000
#define  IO_PAD17_PIOCFG_I2C_SEL_SHIFT 21
#define  IO_PAD17_PIOCFG_I2C_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD17_PIOCFG_I2C_SEL_MASK) >> IO_PAD17_PIOCFG_I2C_SEL_SHIFT)
#define  IO_PAD17_PIOCFG_I2C_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD17_PIOCFG_I2C_SEL_MASK) | (((uint32_t)val) << IO_PAD17_PIOCFG_I2C_SEL_SHIFT))

#define  IO_PAD17_PIOCFG_DGTBSEL_MASK 0x1e0000
#define  IO_PAD17_PIOCFG_DGTBSEL_SHIFT 17
#define  IO_PAD17_PIOCFG_DGTBSEL_MASK_SHIFT(reg) (((reg) & IO_PAD17_PIOCFG_DGTBSEL_MASK) >> IO_PAD17_PIOCFG_DGTBSEL_SHIFT)
#define  IO_PAD17_PIOCFG_DGTBSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD17_PIOCFG_DGTBSEL_MASK) | (((uint32_t)val) << IO_PAD17_PIOCFG_DGTBSEL_SHIFT))

#define  IO_PAD17_PIOCFG_RAWSEL_MASK 0x10000
#define  IO_PAD17_PIOCFG_RAWSEL_SHIFT 16
#define  IO_PAD17_PIOCFG_RAWSEL_MASK_SHIFT(reg) (((reg) & IO_PAD17_PIOCFG_RAWSEL_MASK) >> IO_PAD17_PIOCFG_RAWSEL_SHIFT)
#define  IO_PAD17_PIOCFG_RAWSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD17_PIOCFG_RAWSEL_MASK) | (((uint32_t)val) << IO_PAD17_PIOCFG_RAWSEL_SHIFT))

#define  IO_PAD17_PIOCFG_PULL_SEL_MASK 0x8000
#define  IO_PAD17_PIOCFG_PULL_SEL_SHIFT 15
#define  IO_PAD17_PIOCFG_PULL_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD17_PIOCFG_PULL_SEL_MASK) >> IO_PAD17_PIOCFG_PULL_SEL_SHIFT)
#define  IO_PAD17_PIOCFG_PULL_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD17_PIOCFG_PULL_SEL_MASK) | (((uint32_t)val) << IO_PAD17_PIOCFG_PULL_SEL_SHIFT))

#define  IO_PAD17_PIOCFG_PUEN_MASK 0x4000
#define  IO_PAD17_PIOCFG_PUEN_SHIFT 14
#define  IO_PAD17_PIOCFG_PUEN_MASK_SHIFT(reg) (((reg) & IO_PAD17_PIOCFG_PUEN_MASK) >> IO_PAD17_PIOCFG_PUEN_SHIFT)
#define  IO_PAD17_PIOCFG_PUEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD17_PIOCFG_PUEN_MASK) | (((uint32_t)val) << IO_PAD17_PIOCFG_PUEN_SHIFT))

#define  IO_PAD17_PIOCFG_PDEN_MASK 0x2000
#define  IO_PAD17_PIOCFG_PDEN_SHIFT 13
#define  IO_PAD17_PIOCFG_PDEN_MASK_SHIFT(reg) (((reg) & IO_PAD17_PIOCFG_PDEN_MASK) >> IO_PAD17_PIOCFG_PDEN_SHIFT)
#define  IO_PAD17_PIOCFG_PDEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD17_PIOCFG_PDEN_MASK) | (((uint32_t)val) << IO_PAD17_PIOCFG_PDEN_SHIFT))

#define  IO_PAD17_PIOCFG_SR_MASK 0x1800
#define  IO_PAD17_PIOCFG_SR_SHIFT 11
#define  IO_PAD17_PIOCFG_SR_MASK_SHIFT(reg) (((reg) & IO_PAD17_PIOCFG_SR_MASK) >> IO_PAD17_PIOCFG_SR_SHIFT)
#define  IO_PAD17_PIOCFG_SR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD17_PIOCFG_SR_MASK) | (((uint32_t)val) << IO_PAD17_PIOCFG_SR_SHIFT))

#define  IO_PAD17_PIOCFG_SLP_DI_MASK 0x400
#define  IO_PAD17_PIOCFG_SLP_DI_SHIFT 10
#define  IO_PAD17_PIOCFG_SLP_DI_MASK_SHIFT(reg) (((reg) & IO_PAD17_PIOCFG_SLP_DI_MASK) >> IO_PAD17_PIOCFG_SLP_DI_SHIFT)
#define  IO_PAD17_PIOCFG_SLP_DI_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD17_PIOCFG_SLP_DI_MASK) | (((uint32_t)val) << IO_PAD17_PIOCFG_SLP_DI_SHIFT))

#define  IO_PAD17_PIOCFG_SLP_CNTRL_MASK 0x200
#define  IO_PAD17_PIOCFG_SLP_CNTRL_SHIFT 9
#define  IO_PAD17_PIOCFG_SLP_CNTRL_MASK_SHIFT(reg) (((reg) & IO_PAD17_PIOCFG_SLP_CNTRL_MASK) >> IO_PAD17_PIOCFG_SLP_CNTRL_SHIFT)
#define  IO_PAD17_PIOCFG_SLP_CNTRL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD17_PIOCFG_SLP_CNTRL_MASK) | (((uint32_t)val) << IO_PAD17_PIOCFG_SLP_CNTRL_SHIFT))

#define  IO_PAD17_PIOCFG_SLP_DO_MASK 0x100
#define  IO_PAD17_PIOCFG_SLP_DO_SHIFT 8
#define  IO_PAD17_PIOCFG_SLP_DO_MASK_SHIFT(reg) (((reg) & IO_PAD17_PIOCFG_SLP_DO_MASK) >> IO_PAD17_PIOCFG_SLP_DO_SHIFT)
#define  IO_PAD17_PIOCFG_SLP_DO_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD17_PIOCFG_SLP_DO_MASK) | (((uint32_t)val) << IO_PAD17_PIOCFG_SLP_DO_SHIFT))

#define  IO_PAD17_PIOCFG_SLP_DIR_MASK 0x80
#define  IO_PAD17_PIOCFG_SLP_DIR_SHIFT 7
#define  IO_PAD17_PIOCFG_SLP_DIR_MASK_SHIFT(reg) (((reg) & IO_PAD17_PIOCFG_SLP_DIR_MASK) >> IO_PAD17_PIOCFG_SLP_DIR_SHIFT)
#define  IO_PAD17_PIOCFG_SLP_DIR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD17_PIOCFG_SLP_DIR_MASK) | (((uint32_t)val) << IO_PAD17_PIOCFG_SLP_DIR_SHIFT))

#define  IO_PAD17_PIOCFG_EDGE_EN_N_MASK 0x40
#define  IO_PAD17_PIOCFG_EDGE_EN_N_SHIFT 6
#define  IO_PAD17_PIOCFG_EDGE_EN_N_MASK_SHIFT(reg) (((reg) & IO_PAD17_PIOCFG_EDGE_EN_N_MASK) >> IO_PAD17_PIOCFG_EDGE_EN_N_SHIFT)
#define  IO_PAD17_PIOCFG_EDGE_EN_N_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD17_PIOCFG_EDGE_EN_N_MASK) | (((uint32_t)val) << IO_PAD17_PIOCFG_EDGE_EN_N_SHIFT))

#define  IO_PAD17_PIOCFG_EDGE_FALL_EN_MASK 0x20
#define  IO_PAD17_PIOCFG_EDGE_FALL_EN_SHIFT 5
#define  IO_PAD17_PIOCFG_EDGE_FALL_EN_MASK_SHIFT(reg) (((reg) & IO_PAD17_PIOCFG_EDGE_FALL_EN_MASK) >> IO_PAD17_PIOCFG_EDGE_FALL_EN_SHIFT)
#define  IO_PAD17_PIOCFG_EDGE_FALL_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD17_PIOCFG_EDGE_FALL_EN_MASK) | (((uint32_t)val) << IO_PAD17_PIOCFG_EDGE_FALL_EN_SHIFT))

#define  IO_PAD17_PIOCFG_EDGE_RISE_EN_MASK 0x10
#define  IO_PAD17_PIOCFG_EDGE_RISE_EN_SHIFT 4
#define  IO_PAD17_PIOCFG_EDGE_RISE_EN_MASK_SHIFT(reg) (((reg) & IO_PAD17_PIOCFG_EDGE_RISE_EN_MASK) >> IO_PAD17_PIOCFG_EDGE_RISE_EN_SHIFT)
#define  IO_PAD17_PIOCFG_EDGE_RISE_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD17_PIOCFG_EDGE_RISE_EN_MASK) | (((uint32_t)val) << IO_PAD17_PIOCFG_EDGE_RISE_EN_SHIFT))

#define  IO_PAD17_PIOCFG_SLP_SEL_MASK 0x8
#define  IO_PAD17_PIOCFG_SLP_SEL_SHIFT 3
#define  IO_PAD17_PIOCFG_SLP_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD17_PIOCFG_SLP_SEL_MASK) >> IO_PAD17_PIOCFG_SLP_SEL_SHIFT)
#define  IO_PAD17_PIOCFG_SLP_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD17_PIOCFG_SLP_SEL_MASK) | (((uint32_t)val) << IO_PAD17_PIOCFG_SLP_SEL_SHIFT))

#define  IO_PAD17_PIOCFG_FUNC_SEL_MASK 0x7
#define  IO_PAD17_PIOCFG_FUNC_SEL_SHIFT 0
#define  IO_PAD17_PIOCFG_FUNC_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD17_PIOCFG_FUNC_SEL_MASK) >> IO_PAD17_PIOCFG_FUNC_SEL_SHIFT)
#define  IO_PAD17_PIOCFG_FUNC_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD17_PIOCFG_FUNC_SEL_MASK) | (((uint32_t)val) << IO_PAD17_PIOCFG_FUNC_SEL_SHIFT))

//====================================================================
//
//Register File: IO_PAD18 Configuration Registers (IO_PAD18)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

//====================================================================
//Register: IO_PAD18 Configuration Register (PIOCFG)
/** \brief "PHI_PADXDC_HSIOB" Pad*/
//====================================================================

#define  IO_PAD18_PIOCFG_RESERVED1_MASK 0xfc000000
#define  IO_PAD18_PIOCFG_RESERVED1_SHIFT 26
#define  IO_PAD18_PIOCFG_RESERVED1_MASK_SHIFT(reg) (((reg) & IO_PAD18_PIOCFG_RESERVED1_MASK) >> IO_PAD18_PIOCFG_RESERVED1_SHIFT)
#define  IO_PAD18_PIOCFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD18_PIOCFG_RESERVED1_MASK) | (((uint32_t)val) << IO_PAD18_PIOCFG_RESERVED1_SHIFT))

#define  IO_PAD18_PIOCFG_PD_MASK 0x2000000
#define  IO_PAD18_PIOCFG_PD_SHIFT 25
#define  IO_PAD18_PIOCFG_PD_MASK_SHIFT(reg) (((reg) & IO_PAD18_PIOCFG_PD_MASK) >> IO_PAD18_PIOCFG_PD_SHIFT)
#define  IO_PAD18_PIOCFG_PD_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD18_PIOCFG_PD_MASK) | (((uint32_t)val) << IO_PAD18_PIOCFG_PD_SHIFT))

#define  IO_PAD18_PIOCFG_ODT_EN_MASK 0x1000000
#define  IO_PAD18_PIOCFG_ODT_EN_SHIFT 24
#define  IO_PAD18_PIOCFG_ODT_EN_MASK_SHIFT(reg) (((reg) & IO_PAD18_PIOCFG_ODT_EN_MASK) >> IO_PAD18_PIOCFG_ODT_EN_SHIFT)
#define  IO_PAD18_PIOCFG_ODT_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD18_PIOCFG_ODT_EN_MASK) | (((uint32_t)val) << IO_PAD18_PIOCFG_ODT_EN_SHIFT))

#define  IO_PAD18_PIOCFG_LED_EN_MASK 0x800000
#define  IO_PAD18_PIOCFG_LED_EN_SHIFT 23
#define  IO_PAD18_PIOCFG_LED_EN_MASK_SHIFT(reg) (((reg) & IO_PAD18_PIOCFG_LED_EN_MASK) >> IO_PAD18_PIOCFG_LED_EN_SHIFT)
#define  IO_PAD18_PIOCFG_LED_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD18_PIOCFG_LED_EN_MASK) | (((uint32_t)val) << IO_PAD18_PIOCFG_LED_EN_SHIFT))

#define  IO_PAD18_PIOCFG_I2C_SEL_MASK 0x600000
#define  IO_PAD18_PIOCFG_I2C_SEL_SHIFT 21
#define  IO_PAD18_PIOCFG_I2C_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD18_PIOCFG_I2C_SEL_MASK) >> IO_PAD18_PIOCFG_I2C_SEL_SHIFT)
#define  IO_PAD18_PIOCFG_I2C_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD18_PIOCFG_I2C_SEL_MASK) | (((uint32_t)val) << IO_PAD18_PIOCFG_I2C_SEL_SHIFT))

#define  IO_PAD18_PIOCFG_DGTBSEL_MASK 0x1e0000
#define  IO_PAD18_PIOCFG_DGTBSEL_SHIFT 17
#define  IO_PAD18_PIOCFG_DGTBSEL_MASK_SHIFT(reg) (((reg) & IO_PAD18_PIOCFG_DGTBSEL_MASK) >> IO_PAD18_PIOCFG_DGTBSEL_SHIFT)
#define  IO_PAD18_PIOCFG_DGTBSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD18_PIOCFG_DGTBSEL_MASK) | (((uint32_t)val) << IO_PAD18_PIOCFG_DGTBSEL_SHIFT))

#define  IO_PAD18_PIOCFG_RAWSEL_MASK 0x10000
#define  IO_PAD18_PIOCFG_RAWSEL_SHIFT 16
#define  IO_PAD18_PIOCFG_RAWSEL_MASK_SHIFT(reg) (((reg) & IO_PAD18_PIOCFG_RAWSEL_MASK) >> IO_PAD18_PIOCFG_RAWSEL_SHIFT)
#define  IO_PAD18_PIOCFG_RAWSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD18_PIOCFG_RAWSEL_MASK) | (((uint32_t)val) << IO_PAD18_PIOCFG_RAWSEL_SHIFT))

#define  IO_PAD18_PIOCFG_PULL_SEL_MASK 0x8000
#define  IO_PAD18_PIOCFG_PULL_SEL_SHIFT 15
#define  IO_PAD18_PIOCFG_PULL_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD18_PIOCFG_PULL_SEL_MASK) >> IO_PAD18_PIOCFG_PULL_SEL_SHIFT)
#define  IO_PAD18_PIOCFG_PULL_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD18_PIOCFG_PULL_SEL_MASK) | (((uint32_t)val) << IO_PAD18_PIOCFG_PULL_SEL_SHIFT))

#define  IO_PAD18_PIOCFG_PUEN_MASK 0x4000
#define  IO_PAD18_PIOCFG_PUEN_SHIFT 14
#define  IO_PAD18_PIOCFG_PUEN_MASK_SHIFT(reg) (((reg) & IO_PAD18_PIOCFG_PUEN_MASK) >> IO_PAD18_PIOCFG_PUEN_SHIFT)
#define  IO_PAD18_PIOCFG_PUEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD18_PIOCFG_PUEN_MASK) | (((uint32_t)val) << IO_PAD18_PIOCFG_PUEN_SHIFT))

#define  IO_PAD18_PIOCFG_PDEN_MASK 0x2000
#define  IO_PAD18_PIOCFG_PDEN_SHIFT 13
#define  IO_PAD18_PIOCFG_PDEN_MASK_SHIFT(reg) (((reg) & IO_PAD18_PIOCFG_PDEN_MASK) >> IO_PAD18_PIOCFG_PDEN_SHIFT)
#define  IO_PAD18_PIOCFG_PDEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD18_PIOCFG_PDEN_MASK) | (((uint32_t)val) << IO_PAD18_PIOCFG_PDEN_SHIFT))

#define  IO_PAD18_PIOCFG_SR_MASK 0x1800
#define  IO_PAD18_PIOCFG_SR_SHIFT 11
#define  IO_PAD18_PIOCFG_SR_MASK_SHIFT(reg) (((reg) & IO_PAD18_PIOCFG_SR_MASK) >> IO_PAD18_PIOCFG_SR_SHIFT)
#define  IO_PAD18_PIOCFG_SR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD18_PIOCFG_SR_MASK) | (((uint32_t)val) << IO_PAD18_PIOCFG_SR_SHIFT))

#define  IO_PAD18_PIOCFG_SLP_DI_MASK 0x400
#define  IO_PAD18_PIOCFG_SLP_DI_SHIFT 10
#define  IO_PAD18_PIOCFG_SLP_DI_MASK_SHIFT(reg) (((reg) & IO_PAD18_PIOCFG_SLP_DI_MASK) >> IO_PAD18_PIOCFG_SLP_DI_SHIFT)
#define  IO_PAD18_PIOCFG_SLP_DI_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD18_PIOCFG_SLP_DI_MASK) | (((uint32_t)val) << IO_PAD18_PIOCFG_SLP_DI_SHIFT))

#define  IO_PAD18_PIOCFG_SLP_CNTRL_MASK 0x200
#define  IO_PAD18_PIOCFG_SLP_CNTRL_SHIFT 9
#define  IO_PAD18_PIOCFG_SLP_CNTRL_MASK_SHIFT(reg) (((reg) & IO_PAD18_PIOCFG_SLP_CNTRL_MASK) >> IO_PAD18_PIOCFG_SLP_CNTRL_SHIFT)
#define  IO_PAD18_PIOCFG_SLP_CNTRL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD18_PIOCFG_SLP_CNTRL_MASK) | (((uint32_t)val) << IO_PAD18_PIOCFG_SLP_CNTRL_SHIFT))

#define  IO_PAD18_PIOCFG_SLP_DO_MASK 0x100
#define  IO_PAD18_PIOCFG_SLP_DO_SHIFT 8
#define  IO_PAD18_PIOCFG_SLP_DO_MASK_SHIFT(reg) (((reg) & IO_PAD18_PIOCFG_SLP_DO_MASK) >> IO_PAD18_PIOCFG_SLP_DO_SHIFT)
#define  IO_PAD18_PIOCFG_SLP_DO_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD18_PIOCFG_SLP_DO_MASK) | (((uint32_t)val) << IO_PAD18_PIOCFG_SLP_DO_SHIFT))

#define  IO_PAD18_PIOCFG_SLP_DIR_MASK 0x80
#define  IO_PAD18_PIOCFG_SLP_DIR_SHIFT 7
#define  IO_PAD18_PIOCFG_SLP_DIR_MASK_SHIFT(reg) (((reg) & IO_PAD18_PIOCFG_SLP_DIR_MASK) >> IO_PAD18_PIOCFG_SLP_DIR_SHIFT)
#define  IO_PAD18_PIOCFG_SLP_DIR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD18_PIOCFG_SLP_DIR_MASK) | (((uint32_t)val) << IO_PAD18_PIOCFG_SLP_DIR_SHIFT))

#define  IO_PAD18_PIOCFG_EDGE_EN_N_MASK 0x40
#define  IO_PAD18_PIOCFG_EDGE_EN_N_SHIFT 6
#define  IO_PAD18_PIOCFG_EDGE_EN_N_MASK_SHIFT(reg) (((reg) & IO_PAD18_PIOCFG_EDGE_EN_N_MASK) >> IO_PAD18_PIOCFG_EDGE_EN_N_SHIFT)
#define  IO_PAD18_PIOCFG_EDGE_EN_N_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD18_PIOCFG_EDGE_EN_N_MASK) | (((uint32_t)val) << IO_PAD18_PIOCFG_EDGE_EN_N_SHIFT))

#define  IO_PAD18_PIOCFG_EDGE_FALL_EN_MASK 0x20
#define  IO_PAD18_PIOCFG_EDGE_FALL_EN_SHIFT 5
#define  IO_PAD18_PIOCFG_EDGE_FALL_EN_MASK_SHIFT(reg) (((reg) & IO_PAD18_PIOCFG_EDGE_FALL_EN_MASK) >> IO_PAD18_PIOCFG_EDGE_FALL_EN_SHIFT)
#define  IO_PAD18_PIOCFG_EDGE_FALL_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD18_PIOCFG_EDGE_FALL_EN_MASK) | (((uint32_t)val) << IO_PAD18_PIOCFG_EDGE_FALL_EN_SHIFT))

#define  IO_PAD18_PIOCFG_EDGE_RISE_EN_MASK 0x10
#define  IO_PAD18_PIOCFG_EDGE_RISE_EN_SHIFT 4
#define  IO_PAD18_PIOCFG_EDGE_RISE_EN_MASK_SHIFT(reg) (((reg) & IO_PAD18_PIOCFG_EDGE_RISE_EN_MASK) >> IO_PAD18_PIOCFG_EDGE_RISE_EN_SHIFT)
#define  IO_PAD18_PIOCFG_EDGE_RISE_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD18_PIOCFG_EDGE_RISE_EN_MASK) | (((uint32_t)val) << IO_PAD18_PIOCFG_EDGE_RISE_EN_SHIFT))

#define  IO_PAD18_PIOCFG_SLP_SEL_MASK 0x8
#define  IO_PAD18_PIOCFG_SLP_SEL_SHIFT 3
#define  IO_PAD18_PIOCFG_SLP_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD18_PIOCFG_SLP_SEL_MASK) >> IO_PAD18_PIOCFG_SLP_SEL_SHIFT)
#define  IO_PAD18_PIOCFG_SLP_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD18_PIOCFG_SLP_SEL_MASK) | (((uint32_t)val) << IO_PAD18_PIOCFG_SLP_SEL_SHIFT))

#define  IO_PAD18_PIOCFG_FUNC_SEL_MASK 0x7
#define  IO_PAD18_PIOCFG_FUNC_SEL_SHIFT 0
#define  IO_PAD18_PIOCFG_FUNC_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD18_PIOCFG_FUNC_SEL_MASK) >> IO_PAD18_PIOCFG_FUNC_SEL_SHIFT)
#define  IO_PAD18_PIOCFG_FUNC_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD18_PIOCFG_FUNC_SEL_MASK) | (((uint32_t)val) << IO_PAD18_PIOCFG_FUNC_SEL_SHIFT))

//====================================================================
//
//Register File: IO_PAD19 Configuration Registers (IO_PAD19)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

//====================================================================
//Register: IO_PAD19 Configuration Register (PIOCFG)
/** \brief "PHI_PADXDC_HSIOB" Pad*/
//====================================================================

#define  IO_PAD19_PIOCFG_RESERVED1_MASK 0xfc000000
#define  IO_PAD19_PIOCFG_RESERVED1_SHIFT 26
#define  IO_PAD19_PIOCFG_RESERVED1_MASK_SHIFT(reg) (((reg) & IO_PAD19_PIOCFG_RESERVED1_MASK) >> IO_PAD19_PIOCFG_RESERVED1_SHIFT)
#define  IO_PAD19_PIOCFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD19_PIOCFG_RESERVED1_MASK) | (((uint32_t)val) << IO_PAD19_PIOCFG_RESERVED1_SHIFT))

#define  IO_PAD19_PIOCFG_PD_MASK 0x2000000
#define  IO_PAD19_PIOCFG_PD_SHIFT 25
#define  IO_PAD19_PIOCFG_PD_MASK_SHIFT(reg) (((reg) & IO_PAD19_PIOCFG_PD_MASK) >> IO_PAD19_PIOCFG_PD_SHIFT)
#define  IO_PAD19_PIOCFG_PD_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD19_PIOCFG_PD_MASK) | (((uint32_t)val) << IO_PAD19_PIOCFG_PD_SHIFT))

#define  IO_PAD19_PIOCFG_ODT_EN_MASK 0x1000000
#define  IO_PAD19_PIOCFG_ODT_EN_SHIFT 24
#define  IO_PAD19_PIOCFG_ODT_EN_MASK_SHIFT(reg) (((reg) & IO_PAD19_PIOCFG_ODT_EN_MASK) >> IO_PAD19_PIOCFG_ODT_EN_SHIFT)
#define  IO_PAD19_PIOCFG_ODT_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD19_PIOCFG_ODT_EN_MASK) | (((uint32_t)val) << IO_PAD19_PIOCFG_ODT_EN_SHIFT))

#define  IO_PAD19_PIOCFG_LED_EN_MASK 0x800000
#define  IO_PAD19_PIOCFG_LED_EN_SHIFT 23
#define  IO_PAD19_PIOCFG_LED_EN_MASK_SHIFT(reg) (((reg) & IO_PAD19_PIOCFG_LED_EN_MASK) >> IO_PAD19_PIOCFG_LED_EN_SHIFT)
#define  IO_PAD19_PIOCFG_LED_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD19_PIOCFG_LED_EN_MASK) | (((uint32_t)val) << IO_PAD19_PIOCFG_LED_EN_SHIFT))

#define  IO_PAD19_PIOCFG_I2C_SEL_MASK 0x600000
#define  IO_PAD19_PIOCFG_I2C_SEL_SHIFT 21
#define  IO_PAD19_PIOCFG_I2C_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD19_PIOCFG_I2C_SEL_MASK) >> IO_PAD19_PIOCFG_I2C_SEL_SHIFT)
#define  IO_PAD19_PIOCFG_I2C_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD19_PIOCFG_I2C_SEL_MASK) | (((uint32_t)val) << IO_PAD19_PIOCFG_I2C_SEL_SHIFT))

#define  IO_PAD19_PIOCFG_DGTBSEL_MASK 0x1e0000
#define  IO_PAD19_PIOCFG_DGTBSEL_SHIFT 17
#define  IO_PAD19_PIOCFG_DGTBSEL_MASK_SHIFT(reg) (((reg) & IO_PAD19_PIOCFG_DGTBSEL_MASK) >> IO_PAD19_PIOCFG_DGTBSEL_SHIFT)
#define  IO_PAD19_PIOCFG_DGTBSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD19_PIOCFG_DGTBSEL_MASK) | (((uint32_t)val) << IO_PAD19_PIOCFG_DGTBSEL_SHIFT))

#define  IO_PAD19_PIOCFG_RAWSEL_MASK 0x10000
#define  IO_PAD19_PIOCFG_RAWSEL_SHIFT 16
#define  IO_PAD19_PIOCFG_RAWSEL_MASK_SHIFT(reg) (((reg) & IO_PAD19_PIOCFG_RAWSEL_MASK) >> IO_PAD19_PIOCFG_RAWSEL_SHIFT)
#define  IO_PAD19_PIOCFG_RAWSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD19_PIOCFG_RAWSEL_MASK) | (((uint32_t)val) << IO_PAD19_PIOCFG_RAWSEL_SHIFT))

#define  IO_PAD19_PIOCFG_PULL_SEL_MASK 0x8000
#define  IO_PAD19_PIOCFG_PULL_SEL_SHIFT 15
#define  IO_PAD19_PIOCFG_PULL_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD19_PIOCFG_PULL_SEL_MASK) >> IO_PAD19_PIOCFG_PULL_SEL_SHIFT)
#define  IO_PAD19_PIOCFG_PULL_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD19_PIOCFG_PULL_SEL_MASK) | (((uint32_t)val) << IO_PAD19_PIOCFG_PULL_SEL_SHIFT))

#define  IO_PAD19_PIOCFG_PUEN_MASK 0x4000
#define  IO_PAD19_PIOCFG_PUEN_SHIFT 14
#define  IO_PAD19_PIOCFG_PUEN_MASK_SHIFT(reg) (((reg) & IO_PAD19_PIOCFG_PUEN_MASK) >> IO_PAD19_PIOCFG_PUEN_SHIFT)
#define  IO_PAD19_PIOCFG_PUEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD19_PIOCFG_PUEN_MASK) | (((uint32_t)val) << IO_PAD19_PIOCFG_PUEN_SHIFT))

#define  IO_PAD19_PIOCFG_PDEN_MASK 0x2000
#define  IO_PAD19_PIOCFG_PDEN_SHIFT 13
#define  IO_PAD19_PIOCFG_PDEN_MASK_SHIFT(reg) (((reg) & IO_PAD19_PIOCFG_PDEN_MASK) >> IO_PAD19_PIOCFG_PDEN_SHIFT)
#define  IO_PAD19_PIOCFG_PDEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD19_PIOCFG_PDEN_MASK) | (((uint32_t)val) << IO_PAD19_PIOCFG_PDEN_SHIFT))

#define  IO_PAD19_PIOCFG_SR_MASK 0x1800
#define  IO_PAD19_PIOCFG_SR_SHIFT 11
#define  IO_PAD19_PIOCFG_SR_MASK_SHIFT(reg) (((reg) & IO_PAD19_PIOCFG_SR_MASK) >> IO_PAD19_PIOCFG_SR_SHIFT)
#define  IO_PAD19_PIOCFG_SR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD19_PIOCFG_SR_MASK) | (((uint32_t)val) << IO_PAD19_PIOCFG_SR_SHIFT))

#define  IO_PAD19_PIOCFG_SLP_DI_MASK 0x400
#define  IO_PAD19_PIOCFG_SLP_DI_SHIFT 10
#define  IO_PAD19_PIOCFG_SLP_DI_MASK_SHIFT(reg) (((reg) & IO_PAD19_PIOCFG_SLP_DI_MASK) >> IO_PAD19_PIOCFG_SLP_DI_SHIFT)
#define  IO_PAD19_PIOCFG_SLP_DI_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD19_PIOCFG_SLP_DI_MASK) | (((uint32_t)val) << IO_PAD19_PIOCFG_SLP_DI_SHIFT))

#define  IO_PAD19_PIOCFG_SLP_CNTRL_MASK 0x200
#define  IO_PAD19_PIOCFG_SLP_CNTRL_SHIFT 9
#define  IO_PAD19_PIOCFG_SLP_CNTRL_MASK_SHIFT(reg) (((reg) & IO_PAD19_PIOCFG_SLP_CNTRL_MASK) >> IO_PAD19_PIOCFG_SLP_CNTRL_SHIFT)
#define  IO_PAD19_PIOCFG_SLP_CNTRL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD19_PIOCFG_SLP_CNTRL_MASK) | (((uint32_t)val) << IO_PAD19_PIOCFG_SLP_CNTRL_SHIFT))

#define  IO_PAD19_PIOCFG_SLP_DO_MASK 0x100
#define  IO_PAD19_PIOCFG_SLP_DO_SHIFT 8
#define  IO_PAD19_PIOCFG_SLP_DO_MASK_SHIFT(reg) (((reg) & IO_PAD19_PIOCFG_SLP_DO_MASK) >> IO_PAD19_PIOCFG_SLP_DO_SHIFT)
#define  IO_PAD19_PIOCFG_SLP_DO_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD19_PIOCFG_SLP_DO_MASK) | (((uint32_t)val) << IO_PAD19_PIOCFG_SLP_DO_SHIFT))

#define  IO_PAD19_PIOCFG_SLP_DIR_MASK 0x80
#define  IO_PAD19_PIOCFG_SLP_DIR_SHIFT 7
#define  IO_PAD19_PIOCFG_SLP_DIR_MASK_SHIFT(reg) (((reg) & IO_PAD19_PIOCFG_SLP_DIR_MASK) >> IO_PAD19_PIOCFG_SLP_DIR_SHIFT)
#define  IO_PAD19_PIOCFG_SLP_DIR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD19_PIOCFG_SLP_DIR_MASK) | (((uint32_t)val) << IO_PAD19_PIOCFG_SLP_DIR_SHIFT))

#define  IO_PAD19_PIOCFG_EDGE_EN_N_MASK 0x40
#define  IO_PAD19_PIOCFG_EDGE_EN_N_SHIFT 6
#define  IO_PAD19_PIOCFG_EDGE_EN_N_MASK_SHIFT(reg) (((reg) & IO_PAD19_PIOCFG_EDGE_EN_N_MASK) >> IO_PAD19_PIOCFG_EDGE_EN_N_SHIFT)
#define  IO_PAD19_PIOCFG_EDGE_EN_N_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD19_PIOCFG_EDGE_EN_N_MASK) | (((uint32_t)val) << IO_PAD19_PIOCFG_EDGE_EN_N_SHIFT))

#define  IO_PAD19_PIOCFG_EDGE_FALL_EN_MASK 0x20
#define  IO_PAD19_PIOCFG_EDGE_FALL_EN_SHIFT 5
#define  IO_PAD19_PIOCFG_EDGE_FALL_EN_MASK_SHIFT(reg) (((reg) & IO_PAD19_PIOCFG_EDGE_FALL_EN_MASK) >> IO_PAD19_PIOCFG_EDGE_FALL_EN_SHIFT)
#define  IO_PAD19_PIOCFG_EDGE_FALL_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD19_PIOCFG_EDGE_FALL_EN_MASK) | (((uint32_t)val) << IO_PAD19_PIOCFG_EDGE_FALL_EN_SHIFT))

#define  IO_PAD19_PIOCFG_EDGE_RISE_EN_MASK 0x10
#define  IO_PAD19_PIOCFG_EDGE_RISE_EN_SHIFT 4
#define  IO_PAD19_PIOCFG_EDGE_RISE_EN_MASK_SHIFT(reg) (((reg) & IO_PAD19_PIOCFG_EDGE_RISE_EN_MASK) >> IO_PAD19_PIOCFG_EDGE_RISE_EN_SHIFT)
#define  IO_PAD19_PIOCFG_EDGE_RISE_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD19_PIOCFG_EDGE_RISE_EN_MASK) | (((uint32_t)val) << IO_PAD19_PIOCFG_EDGE_RISE_EN_SHIFT))

#define  IO_PAD19_PIOCFG_SLP_SEL_MASK 0x8
#define  IO_PAD19_PIOCFG_SLP_SEL_SHIFT 3
#define  IO_PAD19_PIOCFG_SLP_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD19_PIOCFG_SLP_SEL_MASK) >> IO_PAD19_PIOCFG_SLP_SEL_SHIFT)
#define  IO_PAD19_PIOCFG_SLP_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD19_PIOCFG_SLP_SEL_MASK) | (((uint32_t)val) << IO_PAD19_PIOCFG_SLP_SEL_SHIFT))

#define  IO_PAD19_PIOCFG_FUNC_SEL_MASK 0x7
#define  IO_PAD19_PIOCFG_FUNC_SEL_SHIFT 0
#define  IO_PAD19_PIOCFG_FUNC_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD19_PIOCFG_FUNC_SEL_MASK) >> IO_PAD19_PIOCFG_FUNC_SEL_SHIFT)
#define  IO_PAD19_PIOCFG_FUNC_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD19_PIOCFG_FUNC_SEL_MASK) | (((uint32_t)val) << IO_PAD19_PIOCFG_FUNC_SEL_SHIFT))

//====================================================================
//
//Register File: IO_PAD20 Configuration Registers (IO_PAD20)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

//====================================================================
//Register: IO_PAD20 Configuration Register (PIOCFG)
/** \brief "PHI_PADXDC_HSIOB" Pad*/
//====================================================================

#define  IO_PAD20_PIOCFG_RESERVED1_MASK 0xfc000000
#define  IO_PAD20_PIOCFG_RESERVED1_SHIFT 26
#define  IO_PAD20_PIOCFG_RESERVED1_MASK_SHIFT(reg) (((reg) & IO_PAD20_PIOCFG_RESERVED1_MASK) >> IO_PAD20_PIOCFG_RESERVED1_SHIFT)
#define  IO_PAD20_PIOCFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD20_PIOCFG_RESERVED1_MASK) | (((uint32_t)val) << IO_PAD20_PIOCFG_RESERVED1_SHIFT))

#define  IO_PAD20_PIOCFG_PD_MASK 0x2000000
#define  IO_PAD20_PIOCFG_PD_SHIFT 25
#define  IO_PAD20_PIOCFG_PD_MASK_SHIFT(reg) (((reg) & IO_PAD20_PIOCFG_PD_MASK) >> IO_PAD20_PIOCFG_PD_SHIFT)
#define  IO_PAD20_PIOCFG_PD_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD20_PIOCFG_PD_MASK) | (((uint32_t)val) << IO_PAD20_PIOCFG_PD_SHIFT))

#define  IO_PAD20_PIOCFG_ODT_EN_MASK 0x1000000
#define  IO_PAD20_PIOCFG_ODT_EN_SHIFT 24
#define  IO_PAD20_PIOCFG_ODT_EN_MASK_SHIFT(reg) (((reg) & IO_PAD20_PIOCFG_ODT_EN_MASK) >> IO_PAD20_PIOCFG_ODT_EN_SHIFT)
#define  IO_PAD20_PIOCFG_ODT_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD20_PIOCFG_ODT_EN_MASK) | (((uint32_t)val) << IO_PAD20_PIOCFG_ODT_EN_SHIFT))

#define  IO_PAD20_PIOCFG_LED_EN_MASK 0x800000
#define  IO_PAD20_PIOCFG_LED_EN_SHIFT 23
#define  IO_PAD20_PIOCFG_LED_EN_MASK_SHIFT(reg) (((reg) & IO_PAD20_PIOCFG_LED_EN_MASK) >> IO_PAD20_PIOCFG_LED_EN_SHIFT)
#define  IO_PAD20_PIOCFG_LED_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD20_PIOCFG_LED_EN_MASK) | (((uint32_t)val) << IO_PAD20_PIOCFG_LED_EN_SHIFT))

#define  IO_PAD20_PIOCFG_I2C_SEL_MASK 0x600000
#define  IO_PAD20_PIOCFG_I2C_SEL_SHIFT 21
#define  IO_PAD20_PIOCFG_I2C_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD20_PIOCFG_I2C_SEL_MASK) >> IO_PAD20_PIOCFG_I2C_SEL_SHIFT)
#define  IO_PAD20_PIOCFG_I2C_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD20_PIOCFG_I2C_SEL_MASK) | (((uint32_t)val) << IO_PAD20_PIOCFG_I2C_SEL_SHIFT))

#define  IO_PAD20_PIOCFG_DGTBSEL_MASK 0x1e0000
#define  IO_PAD20_PIOCFG_DGTBSEL_SHIFT 17
#define  IO_PAD20_PIOCFG_DGTBSEL_MASK_SHIFT(reg) (((reg) & IO_PAD20_PIOCFG_DGTBSEL_MASK) >> IO_PAD20_PIOCFG_DGTBSEL_SHIFT)
#define  IO_PAD20_PIOCFG_DGTBSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD20_PIOCFG_DGTBSEL_MASK) | (((uint32_t)val) << IO_PAD20_PIOCFG_DGTBSEL_SHIFT))

#define  IO_PAD20_PIOCFG_RAWSEL_MASK 0x10000
#define  IO_PAD20_PIOCFG_RAWSEL_SHIFT 16
#define  IO_PAD20_PIOCFG_RAWSEL_MASK_SHIFT(reg) (((reg) & IO_PAD20_PIOCFG_RAWSEL_MASK) >> IO_PAD20_PIOCFG_RAWSEL_SHIFT)
#define  IO_PAD20_PIOCFG_RAWSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD20_PIOCFG_RAWSEL_MASK) | (((uint32_t)val) << IO_PAD20_PIOCFG_RAWSEL_SHIFT))

#define  IO_PAD20_PIOCFG_PULL_SEL_MASK 0x8000
#define  IO_PAD20_PIOCFG_PULL_SEL_SHIFT 15
#define  IO_PAD20_PIOCFG_PULL_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD20_PIOCFG_PULL_SEL_MASK) >> IO_PAD20_PIOCFG_PULL_SEL_SHIFT)
#define  IO_PAD20_PIOCFG_PULL_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD20_PIOCFG_PULL_SEL_MASK) | (((uint32_t)val) << IO_PAD20_PIOCFG_PULL_SEL_SHIFT))

#define  IO_PAD20_PIOCFG_PUEN_MASK 0x4000
#define  IO_PAD20_PIOCFG_PUEN_SHIFT 14
#define  IO_PAD20_PIOCFG_PUEN_MASK_SHIFT(reg) (((reg) & IO_PAD20_PIOCFG_PUEN_MASK) >> IO_PAD20_PIOCFG_PUEN_SHIFT)
#define  IO_PAD20_PIOCFG_PUEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD20_PIOCFG_PUEN_MASK) | (((uint32_t)val) << IO_PAD20_PIOCFG_PUEN_SHIFT))

#define  IO_PAD20_PIOCFG_PDEN_MASK 0x2000
#define  IO_PAD20_PIOCFG_PDEN_SHIFT 13
#define  IO_PAD20_PIOCFG_PDEN_MASK_SHIFT(reg) (((reg) & IO_PAD20_PIOCFG_PDEN_MASK) >> IO_PAD20_PIOCFG_PDEN_SHIFT)
#define  IO_PAD20_PIOCFG_PDEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD20_PIOCFG_PDEN_MASK) | (((uint32_t)val) << IO_PAD20_PIOCFG_PDEN_SHIFT))

#define  IO_PAD20_PIOCFG_SR_MASK 0x1800
#define  IO_PAD20_PIOCFG_SR_SHIFT 11
#define  IO_PAD20_PIOCFG_SR_MASK_SHIFT(reg) (((reg) & IO_PAD20_PIOCFG_SR_MASK) >> IO_PAD20_PIOCFG_SR_SHIFT)
#define  IO_PAD20_PIOCFG_SR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD20_PIOCFG_SR_MASK) | (((uint32_t)val) << IO_PAD20_PIOCFG_SR_SHIFT))

#define  IO_PAD20_PIOCFG_SLP_DI_MASK 0x400
#define  IO_PAD20_PIOCFG_SLP_DI_SHIFT 10
#define  IO_PAD20_PIOCFG_SLP_DI_MASK_SHIFT(reg) (((reg) & IO_PAD20_PIOCFG_SLP_DI_MASK) >> IO_PAD20_PIOCFG_SLP_DI_SHIFT)
#define  IO_PAD20_PIOCFG_SLP_DI_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD20_PIOCFG_SLP_DI_MASK) | (((uint32_t)val) << IO_PAD20_PIOCFG_SLP_DI_SHIFT))

#define  IO_PAD20_PIOCFG_SLP_CNTRL_MASK 0x200
#define  IO_PAD20_PIOCFG_SLP_CNTRL_SHIFT 9
#define  IO_PAD20_PIOCFG_SLP_CNTRL_MASK_SHIFT(reg) (((reg) & IO_PAD20_PIOCFG_SLP_CNTRL_MASK) >> IO_PAD20_PIOCFG_SLP_CNTRL_SHIFT)
#define  IO_PAD20_PIOCFG_SLP_CNTRL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD20_PIOCFG_SLP_CNTRL_MASK) | (((uint32_t)val) << IO_PAD20_PIOCFG_SLP_CNTRL_SHIFT))

#define  IO_PAD20_PIOCFG_SLP_DO_MASK 0x100
#define  IO_PAD20_PIOCFG_SLP_DO_SHIFT 8
#define  IO_PAD20_PIOCFG_SLP_DO_MASK_SHIFT(reg) (((reg) & IO_PAD20_PIOCFG_SLP_DO_MASK) >> IO_PAD20_PIOCFG_SLP_DO_SHIFT)
#define  IO_PAD20_PIOCFG_SLP_DO_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD20_PIOCFG_SLP_DO_MASK) | (((uint32_t)val) << IO_PAD20_PIOCFG_SLP_DO_SHIFT))

#define  IO_PAD20_PIOCFG_SLP_DIR_MASK 0x80
#define  IO_PAD20_PIOCFG_SLP_DIR_SHIFT 7
#define  IO_PAD20_PIOCFG_SLP_DIR_MASK_SHIFT(reg) (((reg) & IO_PAD20_PIOCFG_SLP_DIR_MASK) >> IO_PAD20_PIOCFG_SLP_DIR_SHIFT)
#define  IO_PAD20_PIOCFG_SLP_DIR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD20_PIOCFG_SLP_DIR_MASK) | (((uint32_t)val) << IO_PAD20_PIOCFG_SLP_DIR_SHIFT))

#define  IO_PAD20_PIOCFG_EDGE_EN_N_MASK 0x40
#define  IO_PAD20_PIOCFG_EDGE_EN_N_SHIFT 6
#define  IO_PAD20_PIOCFG_EDGE_EN_N_MASK_SHIFT(reg) (((reg) & IO_PAD20_PIOCFG_EDGE_EN_N_MASK) >> IO_PAD20_PIOCFG_EDGE_EN_N_SHIFT)
#define  IO_PAD20_PIOCFG_EDGE_EN_N_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD20_PIOCFG_EDGE_EN_N_MASK) | (((uint32_t)val) << IO_PAD20_PIOCFG_EDGE_EN_N_SHIFT))

#define  IO_PAD20_PIOCFG_EDGE_FALL_EN_MASK 0x20
#define  IO_PAD20_PIOCFG_EDGE_FALL_EN_SHIFT 5
#define  IO_PAD20_PIOCFG_EDGE_FALL_EN_MASK_SHIFT(reg) (((reg) & IO_PAD20_PIOCFG_EDGE_FALL_EN_MASK) >> IO_PAD20_PIOCFG_EDGE_FALL_EN_SHIFT)
#define  IO_PAD20_PIOCFG_EDGE_FALL_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD20_PIOCFG_EDGE_FALL_EN_MASK) | (((uint32_t)val) << IO_PAD20_PIOCFG_EDGE_FALL_EN_SHIFT))

#define  IO_PAD20_PIOCFG_EDGE_RISE_EN_MASK 0x10
#define  IO_PAD20_PIOCFG_EDGE_RISE_EN_SHIFT 4
#define  IO_PAD20_PIOCFG_EDGE_RISE_EN_MASK_SHIFT(reg) (((reg) & IO_PAD20_PIOCFG_EDGE_RISE_EN_MASK) >> IO_PAD20_PIOCFG_EDGE_RISE_EN_SHIFT)
#define  IO_PAD20_PIOCFG_EDGE_RISE_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD20_PIOCFG_EDGE_RISE_EN_MASK) | (((uint32_t)val) << IO_PAD20_PIOCFG_EDGE_RISE_EN_SHIFT))

#define  IO_PAD20_PIOCFG_SLP_SEL_MASK 0x8
#define  IO_PAD20_PIOCFG_SLP_SEL_SHIFT 3
#define  IO_PAD20_PIOCFG_SLP_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD20_PIOCFG_SLP_SEL_MASK) >> IO_PAD20_PIOCFG_SLP_SEL_SHIFT)
#define  IO_PAD20_PIOCFG_SLP_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD20_PIOCFG_SLP_SEL_MASK) | (((uint32_t)val) << IO_PAD20_PIOCFG_SLP_SEL_SHIFT))

#define  IO_PAD20_PIOCFG_FUNC_SEL_MASK 0x7
#define  IO_PAD20_PIOCFG_FUNC_SEL_SHIFT 0
#define  IO_PAD20_PIOCFG_FUNC_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD20_PIOCFG_FUNC_SEL_MASK) >> IO_PAD20_PIOCFG_FUNC_SEL_SHIFT)
#define  IO_PAD20_PIOCFG_FUNC_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD20_PIOCFG_FUNC_SEL_MASK) | (((uint32_t)val) << IO_PAD20_PIOCFG_FUNC_SEL_SHIFT))

//====================================================================
//
//Register File: IO_PAD21 Configuration Registers (IO_PAD21)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

//====================================================================
//Register: IO_PAD21 Configuration Register (PIOCFG)
/** \brief "PHI_PADXDC_HSIOB" Pad*/
//====================================================================

#define  IO_PAD21_PIOCFG_RESERVED1_MASK 0xfc000000
#define  IO_PAD21_PIOCFG_RESERVED1_SHIFT 26
#define  IO_PAD21_PIOCFG_RESERVED1_MASK_SHIFT(reg) (((reg) & IO_PAD21_PIOCFG_RESERVED1_MASK) >> IO_PAD21_PIOCFG_RESERVED1_SHIFT)
#define  IO_PAD21_PIOCFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD21_PIOCFG_RESERVED1_MASK) | (((uint32_t)val) << IO_PAD21_PIOCFG_RESERVED1_SHIFT))

#define  IO_PAD21_PIOCFG_PD_MASK 0x2000000
#define  IO_PAD21_PIOCFG_PD_SHIFT 25
#define  IO_PAD21_PIOCFG_PD_MASK_SHIFT(reg) (((reg) & IO_PAD21_PIOCFG_PD_MASK) >> IO_PAD21_PIOCFG_PD_SHIFT)
#define  IO_PAD21_PIOCFG_PD_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD21_PIOCFG_PD_MASK) | (((uint32_t)val) << IO_PAD21_PIOCFG_PD_SHIFT))

#define  IO_PAD21_PIOCFG_ODT_EN_MASK 0x1000000
#define  IO_PAD21_PIOCFG_ODT_EN_SHIFT 24
#define  IO_PAD21_PIOCFG_ODT_EN_MASK_SHIFT(reg) (((reg) & IO_PAD21_PIOCFG_ODT_EN_MASK) >> IO_PAD21_PIOCFG_ODT_EN_SHIFT)
#define  IO_PAD21_PIOCFG_ODT_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD21_PIOCFG_ODT_EN_MASK) | (((uint32_t)val) << IO_PAD21_PIOCFG_ODT_EN_SHIFT))

#define  IO_PAD21_PIOCFG_LED_EN_MASK 0x800000
#define  IO_PAD21_PIOCFG_LED_EN_SHIFT 23
#define  IO_PAD21_PIOCFG_LED_EN_MASK_SHIFT(reg) (((reg) & IO_PAD21_PIOCFG_LED_EN_MASK) >> IO_PAD21_PIOCFG_LED_EN_SHIFT)
#define  IO_PAD21_PIOCFG_LED_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD21_PIOCFG_LED_EN_MASK) | (((uint32_t)val) << IO_PAD21_PIOCFG_LED_EN_SHIFT))

#define  IO_PAD21_PIOCFG_I2C_SEL_MASK 0x600000
#define  IO_PAD21_PIOCFG_I2C_SEL_SHIFT 21
#define  IO_PAD21_PIOCFG_I2C_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD21_PIOCFG_I2C_SEL_MASK) >> IO_PAD21_PIOCFG_I2C_SEL_SHIFT)
#define  IO_PAD21_PIOCFG_I2C_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD21_PIOCFG_I2C_SEL_MASK) | (((uint32_t)val) << IO_PAD21_PIOCFG_I2C_SEL_SHIFT))

#define  IO_PAD21_PIOCFG_DGTBSEL_MASK 0x1e0000
#define  IO_PAD21_PIOCFG_DGTBSEL_SHIFT 17
#define  IO_PAD21_PIOCFG_DGTBSEL_MASK_SHIFT(reg) (((reg) & IO_PAD21_PIOCFG_DGTBSEL_MASK) >> IO_PAD21_PIOCFG_DGTBSEL_SHIFT)
#define  IO_PAD21_PIOCFG_DGTBSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD21_PIOCFG_DGTBSEL_MASK) | (((uint32_t)val) << IO_PAD21_PIOCFG_DGTBSEL_SHIFT))

#define  IO_PAD21_PIOCFG_RAWSEL_MASK 0x10000
#define  IO_PAD21_PIOCFG_RAWSEL_SHIFT 16
#define  IO_PAD21_PIOCFG_RAWSEL_MASK_SHIFT(reg) (((reg) & IO_PAD21_PIOCFG_RAWSEL_MASK) >> IO_PAD21_PIOCFG_RAWSEL_SHIFT)
#define  IO_PAD21_PIOCFG_RAWSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD21_PIOCFG_RAWSEL_MASK) | (((uint32_t)val) << IO_PAD21_PIOCFG_RAWSEL_SHIFT))

#define  IO_PAD21_PIOCFG_PULL_SEL_MASK 0x8000
#define  IO_PAD21_PIOCFG_PULL_SEL_SHIFT 15
#define  IO_PAD21_PIOCFG_PULL_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD21_PIOCFG_PULL_SEL_MASK) >> IO_PAD21_PIOCFG_PULL_SEL_SHIFT)
#define  IO_PAD21_PIOCFG_PULL_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD21_PIOCFG_PULL_SEL_MASK) | (((uint32_t)val) << IO_PAD21_PIOCFG_PULL_SEL_SHIFT))

#define  IO_PAD21_PIOCFG_PUEN_MASK 0x4000
#define  IO_PAD21_PIOCFG_PUEN_SHIFT 14
#define  IO_PAD21_PIOCFG_PUEN_MASK_SHIFT(reg) (((reg) & IO_PAD21_PIOCFG_PUEN_MASK) >> IO_PAD21_PIOCFG_PUEN_SHIFT)
#define  IO_PAD21_PIOCFG_PUEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD21_PIOCFG_PUEN_MASK) | (((uint32_t)val) << IO_PAD21_PIOCFG_PUEN_SHIFT))

#define  IO_PAD21_PIOCFG_PDEN_MASK 0x2000
#define  IO_PAD21_PIOCFG_PDEN_SHIFT 13
#define  IO_PAD21_PIOCFG_PDEN_MASK_SHIFT(reg) (((reg) & IO_PAD21_PIOCFG_PDEN_MASK) >> IO_PAD21_PIOCFG_PDEN_SHIFT)
#define  IO_PAD21_PIOCFG_PDEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD21_PIOCFG_PDEN_MASK) | (((uint32_t)val) << IO_PAD21_PIOCFG_PDEN_SHIFT))

#define  IO_PAD21_PIOCFG_SR_MASK 0x1800
#define  IO_PAD21_PIOCFG_SR_SHIFT 11
#define  IO_PAD21_PIOCFG_SR_MASK_SHIFT(reg) (((reg) & IO_PAD21_PIOCFG_SR_MASK) >> IO_PAD21_PIOCFG_SR_SHIFT)
#define  IO_PAD21_PIOCFG_SR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD21_PIOCFG_SR_MASK) | (((uint32_t)val) << IO_PAD21_PIOCFG_SR_SHIFT))

#define  IO_PAD21_PIOCFG_SLP_DI_MASK 0x400
#define  IO_PAD21_PIOCFG_SLP_DI_SHIFT 10
#define  IO_PAD21_PIOCFG_SLP_DI_MASK_SHIFT(reg) (((reg) & IO_PAD21_PIOCFG_SLP_DI_MASK) >> IO_PAD21_PIOCFG_SLP_DI_SHIFT)
#define  IO_PAD21_PIOCFG_SLP_DI_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD21_PIOCFG_SLP_DI_MASK) | (((uint32_t)val) << IO_PAD21_PIOCFG_SLP_DI_SHIFT))

#define  IO_PAD21_PIOCFG_SLP_CNTRL_MASK 0x200
#define  IO_PAD21_PIOCFG_SLP_CNTRL_SHIFT 9
#define  IO_PAD21_PIOCFG_SLP_CNTRL_MASK_SHIFT(reg) (((reg) & IO_PAD21_PIOCFG_SLP_CNTRL_MASK) >> IO_PAD21_PIOCFG_SLP_CNTRL_SHIFT)
#define  IO_PAD21_PIOCFG_SLP_CNTRL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD21_PIOCFG_SLP_CNTRL_MASK) | (((uint32_t)val) << IO_PAD21_PIOCFG_SLP_CNTRL_SHIFT))

#define  IO_PAD21_PIOCFG_SLP_DO_MASK 0x100
#define  IO_PAD21_PIOCFG_SLP_DO_SHIFT 8
#define  IO_PAD21_PIOCFG_SLP_DO_MASK_SHIFT(reg) (((reg) & IO_PAD21_PIOCFG_SLP_DO_MASK) >> IO_PAD21_PIOCFG_SLP_DO_SHIFT)
#define  IO_PAD21_PIOCFG_SLP_DO_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD21_PIOCFG_SLP_DO_MASK) | (((uint32_t)val) << IO_PAD21_PIOCFG_SLP_DO_SHIFT))

#define  IO_PAD21_PIOCFG_SLP_DIR_MASK 0x80
#define  IO_PAD21_PIOCFG_SLP_DIR_SHIFT 7
#define  IO_PAD21_PIOCFG_SLP_DIR_MASK_SHIFT(reg) (((reg) & IO_PAD21_PIOCFG_SLP_DIR_MASK) >> IO_PAD21_PIOCFG_SLP_DIR_SHIFT)
#define  IO_PAD21_PIOCFG_SLP_DIR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD21_PIOCFG_SLP_DIR_MASK) | (((uint32_t)val) << IO_PAD21_PIOCFG_SLP_DIR_SHIFT))

#define  IO_PAD21_PIOCFG_EDGE_EN_N_MASK 0x40
#define  IO_PAD21_PIOCFG_EDGE_EN_N_SHIFT 6
#define  IO_PAD21_PIOCFG_EDGE_EN_N_MASK_SHIFT(reg) (((reg) & IO_PAD21_PIOCFG_EDGE_EN_N_MASK) >> IO_PAD21_PIOCFG_EDGE_EN_N_SHIFT)
#define  IO_PAD21_PIOCFG_EDGE_EN_N_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD21_PIOCFG_EDGE_EN_N_MASK) | (((uint32_t)val) << IO_PAD21_PIOCFG_EDGE_EN_N_SHIFT))

#define  IO_PAD21_PIOCFG_EDGE_FALL_EN_MASK 0x20
#define  IO_PAD21_PIOCFG_EDGE_FALL_EN_SHIFT 5
#define  IO_PAD21_PIOCFG_EDGE_FALL_EN_MASK_SHIFT(reg) (((reg) & IO_PAD21_PIOCFG_EDGE_FALL_EN_MASK) >> IO_PAD21_PIOCFG_EDGE_FALL_EN_SHIFT)
#define  IO_PAD21_PIOCFG_EDGE_FALL_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD21_PIOCFG_EDGE_FALL_EN_MASK) | (((uint32_t)val) << IO_PAD21_PIOCFG_EDGE_FALL_EN_SHIFT))

#define  IO_PAD21_PIOCFG_EDGE_RISE_EN_MASK 0x10
#define  IO_PAD21_PIOCFG_EDGE_RISE_EN_SHIFT 4
#define  IO_PAD21_PIOCFG_EDGE_RISE_EN_MASK_SHIFT(reg) (((reg) & IO_PAD21_PIOCFG_EDGE_RISE_EN_MASK) >> IO_PAD21_PIOCFG_EDGE_RISE_EN_SHIFT)
#define  IO_PAD21_PIOCFG_EDGE_RISE_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD21_PIOCFG_EDGE_RISE_EN_MASK) | (((uint32_t)val) << IO_PAD21_PIOCFG_EDGE_RISE_EN_SHIFT))

#define  IO_PAD21_PIOCFG_SLP_SEL_MASK 0x8
#define  IO_PAD21_PIOCFG_SLP_SEL_SHIFT 3
#define  IO_PAD21_PIOCFG_SLP_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD21_PIOCFG_SLP_SEL_MASK) >> IO_PAD21_PIOCFG_SLP_SEL_SHIFT)
#define  IO_PAD21_PIOCFG_SLP_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD21_PIOCFG_SLP_SEL_MASK) | (((uint32_t)val) << IO_PAD21_PIOCFG_SLP_SEL_SHIFT))

#define  IO_PAD21_PIOCFG_FUNC_SEL_MASK 0x7
#define  IO_PAD21_PIOCFG_FUNC_SEL_SHIFT 0
#define  IO_PAD21_PIOCFG_FUNC_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD21_PIOCFG_FUNC_SEL_MASK) >> IO_PAD21_PIOCFG_FUNC_SEL_SHIFT)
#define  IO_PAD21_PIOCFG_FUNC_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD21_PIOCFG_FUNC_SEL_MASK) | (((uint32_t)val) << IO_PAD21_PIOCFG_FUNC_SEL_SHIFT))

//====================================================================
//
//Register File: IO_PAD22 Configuration Registers (IO_PAD22)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

//====================================================================
//Register: IO_PAD22 Configuration Register (PIOCFG)
/** \brief "PHI_PADXDC_HSIOB" Pad*/
//====================================================================

#define  IO_PAD22_PIOCFG_RESERVED1_MASK 0xfc000000
#define  IO_PAD22_PIOCFG_RESERVED1_SHIFT 26
#define  IO_PAD22_PIOCFG_RESERVED1_MASK_SHIFT(reg) (((reg) & IO_PAD22_PIOCFG_RESERVED1_MASK) >> IO_PAD22_PIOCFG_RESERVED1_SHIFT)
#define  IO_PAD22_PIOCFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD22_PIOCFG_RESERVED1_MASK) | (((uint32_t)val) << IO_PAD22_PIOCFG_RESERVED1_SHIFT))

#define  IO_PAD22_PIOCFG_PD_MASK 0x2000000
#define  IO_PAD22_PIOCFG_PD_SHIFT 25
#define  IO_PAD22_PIOCFG_PD_MASK_SHIFT(reg) (((reg) & IO_PAD22_PIOCFG_PD_MASK) >> IO_PAD22_PIOCFG_PD_SHIFT)
#define  IO_PAD22_PIOCFG_PD_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD22_PIOCFG_PD_MASK) | (((uint32_t)val) << IO_PAD22_PIOCFG_PD_SHIFT))

#define  IO_PAD22_PIOCFG_ODT_EN_MASK 0x1000000
#define  IO_PAD22_PIOCFG_ODT_EN_SHIFT 24
#define  IO_PAD22_PIOCFG_ODT_EN_MASK_SHIFT(reg) (((reg) & IO_PAD22_PIOCFG_ODT_EN_MASK) >> IO_PAD22_PIOCFG_ODT_EN_SHIFT)
#define  IO_PAD22_PIOCFG_ODT_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD22_PIOCFG_ODT_EN_MASK) | (((uint32_t)val) << IO_PAD22_PIOCFG_ODT_EN_SHIFT))

#define  IO_PAD22_PIOCFG_LED_EN_MASK 0x800000
#define  IO_PAD22_PIOCFG_LED_EN_SHIFT 23
#define  IO_PAD22_PIOCFG_LED_EN_MASK_SHIFT(reg) (((reg) & IO_PAD22_PIOCFG_LED_EN_MASK) >> IO_PAD22_PIOCFG_LED_EN_SHIFT)
#define  IO_PAD22_PIOCFG_LED_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD22_PIOCFG_LED_EN_MASK) | (((uint32_t)val) << IO_PAD22_PIOCFG_LED_EN_SHIFT))

#define  IO_PAD22_PIOCFG_I2C_SEL_MASK 0x600000
#define  IO_PAD22_PIOCFG_I2C_SEL_SHIFT 21
#define  IO_PAD22_PIOCFG_I2C_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD22_PIOCFG_I2C_SEL_MASK) >> IO_PAD22_PIOCFG_I2C_SEL_SHIFT)
#define  IO_PAD22_PIOCFG_I2C_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD22_PIOCFG_I2C_SEL_MASK) | (((uint32_t)val) << IO_PAD22_PIOCFG_I2C_SEL_SHIFT))

#define  IO_PAD22_PIOCFG_DGTBSEL_MASK 0x1e0000
#define  IO_PAD22_PIOCFG_DGTBSEL_SHIFT 17
#define  IO_PAD22_PIOCFG_DGTBSEL_MASK_SHIFT(reg) (((reg) & IO_PAD22_PIOCFG_DGTBSEL_MASK) >> IO_PAD22_PIOCFG_DGTBSEL_SHIFT)
#define  IO_PAD22_PIOCFG_DGTBSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD22_PIOCFG_DGTBSEL_MASK) | (((uint32_t)val) << IO_PAD22_PIOCFG_DGTBSEL_SHIFT))

#define  IO_PAD22_PIOCFG_RAWSEL_MASK 0x10000
#define  IO_PAD22_PIOCFG_RAWSEL_SHIFT 16
#define  IO_PAD22_PIOCFG_RAWSEL_MASK_SHIFT(reg) (((reg) & IO_PAD22_PIOCFG_RAWSEL_MASK) >> IO_PAD22_PIOCFG_RAWSEL_SHIFT)
#define  IO_PAD22_PIOCFG_RAWSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD22_PIOCFG_RAWSEL_MASK) | (((uint32_t)val) << IO_PAD22_PIOCFG_RAWSEL_SHIFT))

#define  IO_PAD22_PIOCFG_PULL_SEL_MASK 0x8000
#define  IO_PAD22_PIOCFG_PULL_SEL_SHIFT 15
#define  IO_PAD22_PIOCFG_PULL_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD22_PIOCFG_PULL_SEL_MASK) >> IO_PAD22_PIOCFG_PULL_SEL_SHIFT)
#define  IO_PAD22_PIOCFG_PULL_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD22_PIOCFG_PULL_SEL_MASK) | (((uint32_t)val) << IO_PAD22_PIOCFG_PULL_SEL_SHIFT))

#define  IO_PAD22_PIOCFG_PUEN_MASK 0x4000
#define  IO_PAD22_PIOCFG_PUEN_SHIFT 14
#define  IO_PAD22_PIOCFG_PUEN_MASK_SHIFT(reg) (((reg) & IO_PAD22_PIOCFG_PUEN_MASK) >> IO_PAD22_PIOCFG_PUEN_SHIFT)
#define  IO_PAD22_PIOCFG_PUEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD22_PIOCFG_PUEN_MASK) | (((uint32_t)val) << IO_PAD22_PIOCFG_PUEN_SHIFT))

#define  IO_PAD22_PIOCFG_PDEN_MASK 0x2000
#define  IO_PAD22_PIOCFG_PDEN_SHIFT 13
#define  IO_PAD22_PIOCFG_PDEN_MASK_SHIFT(reg) (((reg) & IO_PAD22_PIOCFG_PDEN_MASK) >> IO_PAD22_PIOCFG_PDEN_SHIFT)
#define  IO_PAD22_PIOCFG_PDEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD22_PIOCFG_PDEN_MASK) | (((uint32_t)val) << IO_PAD22_PIOCFG_PDEN_SHIFT))

#define  IO_PAD22_PIOCFG_SR_MASK 0x1800
#define  IO_PAD22_PIOCFG_SR_SHIFT 11
#define  IO_PAD22_PIOCFG_SR_MASK_SHIFT(reg) (((reg) & IO_PAD22_PIOCFG_SR_MASK) >> IO_PAD22_PIOCFG_SR_SHIFT)
#define  IO_PAD22_PIOCFG_SR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD22_PIOCFG_SR_MASK) | (((uint32_t)val) << IO_PAD22_PIOCFG_SR_SHIFT))

#define  IO_PAD22_PIOCFG_SLP_DI_MASK 0x400
#define  IO_PAD22_PIOCFG_SLP_DI_SHIFT 10
#define  IO_PAD22_PIOCFG_SLP_DI_MASK_SHIFT(reg) (((reg) & IO_PAD22_PIOCFG_SLP_DI_MASK) >> IO_PAD22_PIOCFG_SLP_DI_SHIFT)
#define  IO_PAD22_PIOCFG_SLP_DI_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD22_PIOCFG_SLP_DI_MASK) | (((uint32_t)val) << IO_PAD22_PIOCFG_SLP_DI_SHIFT))

#define  IO_PAD22_PIOCFG_SLP_CNTRL_MASK 0x200
#define  IO_PAD22_PIOCFG_SLP_CNTRL_SHIFT 9
#define  IO_PAD22_PIOCFG_SLP_CNTRL_MASK_SHIFT(reg) (((reg) & IO_PAD22_PIOCFG_SLP_CNTRL_MASK) >> IO_PAD22_PIOCFG_SLP_CNTRL_SHIFT)
#define  IO_PAD22_PIOCFG_SLP_CNTRL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD22_PIOCFG_SLP_CNTRL_MASK) | (((uint32_t)val) << IO_PAD22_PIOCFG_SLP_CNTRL_SHIFT))

#define  IO_PAD22_PIOCFG_SLP_DO_MASK 0x100
#define  IO_PAD22_PIOCFG_SLP_DO_SHIFT 8
#define  IO_PAD22_PIOCFG_SLP_DO_MASK_SHIFT(reg) (((reg) & IO_PAD22_PIOCFG_SLP_DO_MASK) >> IO_PAD22_PIOCFG_SLP_DO_SHIFT)
#define  IO_PAD22_PIOCFG_SLP_DO_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD22_PIOCFG_SLP_DO_MASK) | (((uint32_t)val) << IO_PAD22_PIOCFG_SLP_DO_SHIFT))

#define  IO_PAD22_PIOCFG_SLP_DIR_MASK 0x80
#define  IO_PAD22_PIOCFG_SLP_DIR_SHIFT 7
#define  IO_PAD22_PIOCFG_SLP_DIR_MASK_SHIFT(reg) (((reg) & IO_PAD22_PIOCFG_SLP_DIR_MASK) >> IO_PAD22_PIOCFG_SLP_DIR_SHIFT)
#define  IO_PAD22_PIOCFG_SLP_DIR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD22_PIOCFG_SLP_DIR_MASK) | (((uint32_t)val) << IO_PAD22_PIOCFG_SLP_DIR_SHIFT))

#define  IO_PAD22_PIOCFG_EDGE_EN_N_MASK 0x40
#define  IO_PAD22_PIOCFG_EDGE_EN_N_SHIFT 6
#define  IO_PAD22_PIOCFG_EDGE_EN_N_MASK_SHIFT(reg) (((reg) & IO_PAD22_PIOCFG_EDGE_EN_N_MASK) >> IO_PAD22_PIOCFG_EDGE_EN_N_SHIFT)
#define  IO_PAD22_PIOCFG_EDGE_EN_N_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD22_PIOCFG_EDGE_EN_N_MASK) | (((uint32_t)val) << IO_PAD22_PIOCFG_EDGE_EN_N_SHIFT))

#define  IO_PAD22_PIOCFG_EDGE_FALL_EN_MASK 0x20
#define  IO_PAD22_PIOCFG_EDGE_FALL_EN_SHIFT 5
#define  IO_PAD22_PIOCFG_EDGE_FALL_EN_MASK_SHIFT(reg) (((reg) & IO_PAD22_PIOCFG_EDGE_FALL_EN_MASK) >> IO_PAD22_PIOCFG_EDGE_FALL_EN_SHIFT)
#define  IO_PAD22_PIOCFG_EDGE_FALL_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD22_PIOCFG_EDGE_FALL_EN_MASK) | (((uint32_t)val) << IO_PAD22_PIOCFG_EDGE_FALL_EN_SHIFT))

#define  IO_PAD22_PIOCFG_EDGE_RISE_EN_MASK 0x10
#define  IO_PAD22_PIOCFG_EDGE_RISE_EN_SHIFT 4
#define  IO_PAD22_PIOCFG_EDGE_RISE_EN_MASK_SHIFT(reg) (((reg) & IO_PAD22_PIOCFG_EDGE_RISE_EN_MASK) >> IO_PAD22_PIOCFG_EDGE_RISE_EN_SHIFT)
#define  IO_PAD22_PIOCFG_EDGE_RISE_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD22_PIOCFG_EDGE_RISE_EN_MASK) | (((uint32_t)val) << IO_PAD22_PIOCFG_EDGE_RISE_EN_SHIFT))

#define  IO_PAD22_PIOCFG_SLP_SEL_MASK 0x8
#define  IO_PAD22_PIOCFG_SLP_SEL_SHIFT 3
#define  IO_PAD22_PIOCFG_SLP_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD22_PIOCFG_SLP_SEL_MASK) >> IO_PAD22_PIOCFG_SLP_SEL_SHIFT)
#define  IO_PAD22_PIOCFG_SLP_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD22_PIOCFG_SLP_SEL_MASK) | (((uint32_t)val) << IO_PAD22_PIOCFG_SLP_SEL_SHIFT))

#define  IO_PAD22_PIOCFG_FUNC_SEL_MASK 0x7
#define  IO_PAD22_PIOCFG_FUNC_SEL_SHIFT 0
#define  IO_PAD22_PIOCFG_FUNC_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD22_PIOCFG_FUNC_SEL_MASK) >> IO_PAD22_PIOCFG_FUNC_SEL_SHIFT)
#define  IO_PAD22_PIOCFG_FUNC_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD22_PIOCFG_FUNC_SEL_MASK) | (((uint32_t)val) << IO_PAD22_PIOCFG_FUNC_SEL_SHIFT))

//====================================================================
//
//Register File: IO_PAD23 Configuration Registers (IO_PAD23)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

//====================================================================
//Register: IO_PAD23 Configuration Register (PIOCFG)
/** \brief "PHI_PADXDC_HSIOB" Pad*/
//====================================================================

#define  IO_PAD23_PIOCFG_RESERVED1_MASK 0xfc000000
#define  IO_PAD23_PIOCFG_RESERVED1_SHIFT 26
#define  IO_PAD23_PIOCFG_RESERVED1_MASK_SHIFT(reg) (((reg) & IO_PAD23_PIOCFG_RESERVED1_MASK) >> IO_PAD23_PIOCFG_RESERVED1_SHIFT)
#define  IO_PAD23_PIOCFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD23_PIOCFG_RESERVED1_MASK) | (((uint32_t)val) << IO_PAD23_PIOCFG_RESERVED1_SHIFT))

#define  IO_PAD23_PIOCFG_PD_MASK 0x2000000
#define  IO_PAD23_PIOCFG_PD_SHIFT 25
#define  IO_PAD23_PIOCFG_PD_MASK_SHIFT(reg) (((reg) & IO_PAD23_PIOCFG_PD_MASK) >> IO_PAD23_PIOCFG_PD_SHIFT)
#define  IO_PAD23_PIOCFG_PD_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD23_PIOCFG_PD_MASK) | (((uint32_t)val) << IO_PAD23_PIOCFG_PD_SHIFT))

#define  IO_PAD23_PIOCFG_ODT_EN_MASK 0x1000000
#define  IO_PAD23_PIOCFG_ODT_EN_SHIFT 24
#define  IO_PAD23_PIOCFG_ODT_EN_MASK_SHIFT(reg) (((reg) & IO_PAD23_PIOCFG_ODT_EN_MASK) >> IO_PAD23_PIOCFG_ODT_EN_SHIFT)
#define  IO_PAD23_PIOCFG_ODT_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD23_PIOCFG_ODT_EN_MASK) | (((uint32_t)val) << IO_PAD23_PIOCFG_ODT_EN_SHIFT))

#define  IO_PAD23_PIOCFG_LED_EN_MASK 0x800000
#define  IO_PAD23_PIOCFG_LED_EN_SHIFT 23
#define  IO_PAD23_PIOCFG_LED_EN_MASK_SHIFT(reg) (((reg) & IO_PAD23_PIOCFG_LED_EN_MASK) >> IO_PAD23_PIOCFG_LED_EN_SHIFT)
#define  IO_PAD23_PIOCFG_LED_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD23_PIOCFG_LED_EN_MASK) | (((uint32_t)val) << IO_PAD23_PIOCFG_LED_EN_SHIFT))

#define  IO_PAD23_PIOCFG_I2C_SEL_MASK 0x600000
#define  IO_PAD23_PIOCFG_I2C_SEL_SHIFT 21
#define  IO_PAD23_PIOCFG_I2C_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD23_PIOCFG_I2C_SEL_MASK) >> IO_PAD23_PIOCFG_I2C_SEL_SHIFT)
#define  IO_PAD23_PIOCFG_I2C_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD23_PIOCFG_I2C_SEL_MASK) | (((uint32_t)val) << IO_PAD23_PIOCFG_I2C_SEL_SHIFT))

#define  IO_PAD23_PIOCFG_DGTBSEL_MASK 0x1e0000
#define  IO_PAD23_PIOCFG_DGTBSEL_SHIFT 17
#define  IO_PAD23_PIOCFG_DGTBSEL_MASK_SHIFT(reg) (((reg) & IO_PAD23_PIOCFG_DGTBSEL_MASK) >> IO_PAD23_PIOCFG_DGTBSEL_SHIFT)
#define  IO_PAD23_PIOCFG_DGTBSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD23_PIOCFG_DGTBSEL_MASK) | (((uint32_t)val) << IO_PAD23_PIOCFG_DGTBSEL_SHIFT))

#define  IO_PAD23_PIOCFG_RAWSEL_MASK 0x10000
#define  IO_PAD23_PIOCFG_RAWSEL_SHIFT 16
#define  IO_PAD23_PIOCFG_RAWSEL_MASK_SHIFT(reg) (((reg) & IO_PAD23_PIOCFG_RAWSEL_MASK) >> IO_PAD23_PIOCFG_RAWSEL_SHIFT)
#define  IO_PAD23_PIOCFG_RAWSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD23_PIOCFG_RAWSEL_MASK) | (((uint32_t)val) << IO_PAD23_PIOCFG_RAWSEL_SHIFT))

#define  IO_PAD23_PIOCFG_PULL_SEL_MASK 0x8000
#define  IO_PAD23_PIOCFG_PULL_SEL_SHIFT 15
#define  IO_PAD23_PIOCFG_PULL_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD23_PIOCFG_PULL_SEL_MASK) >> IO_PAD23_PIOCFG_PULL_SEL_SHIFT)
#define  IO_PAD23_PIOCFG_PULL_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD23_PIOCFG_PULL_SEL_MASK) | (((uint32_t)val) << IO_PAD23_PIOCFG_PULL_SEL_SHIFT))

#define  IO_PAD23_PIOCFG_PUEN_MASK 0x4000
#define  IO_PAD23_PIOCFG_PUEN_SHIFT 14
#define  IO_PAD23_PIOCFG_PUEN_MASK_SHIFT(reg) (((reg) & IO_PAD23_PIOCFG_PUEN_MASK) >> IO_PAD23_PIOCFG_PUEN_SHIFT)
#define  IO_PAD23_PIOCFG_PUEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD23_PIOCFG_PUEN_MASK) | (((uint32_t)val) << IO_PAD23_PIOCFG_PUEN_SHIFT))

#define  IO_PAD23_PIOCFG_PDEN_MASK 0x2000
#define  IO_PAD23_PIOCFG_PDEN_SHIFT 13
#define  IO_PAD23_PIOCFG_PDEN_MASK_SHIFT(reg) (((reg) & IO_PAD23_PIOCFG_PDEN_MASK) >> IO_PAD23_PIOCFG_PDEN_SHIFT)
#define  IO_PAD23_PIOCFG_PDEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD23_PIOCFG_PDEN_MASK) | (((uint32_t)val) << IO_PAD23_PIOCFG_PDEN_SHIFT))

#define  IO_PAD23_PIOCFG_SR_MASK 0x1800
#define  IO_PAD23_PIOCFG_SR_SHIFT 11
#define  IO_PAD23_PIOCFG_SR_MASK_SHIFT(reg) (((reg) & IO_PAD23_PIOCFG_SR_MASK) >> IO_PAD23_PIOCFG_SR_SHIFT)
#define  IO_PAD23_PIOCFG_SR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD23_PIOCFG_SR_MASK) | (((uint32_t)val) << IO_PAD23_PIOCFG_SR_SHIFT))

#define  IO_PAD23_PIOCFG_SLP_DI_MASK 0x400
#define  IO_PAD23_PIOCFG_SLP_DI_SHIFT 10
#define  IO_PAD23_PIOCFG_SLP_DI_MASK_SHIFT(reg) (((reg) & IO_PAD23_PIOCFG_SLP_DI_MASK) >> IO_PAD23_PIOCFG_SLP_DI_SHIFT)
#define  IO_PAD23_PIOCFG_SLP_DI_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD23_PIOCFG_SLP_DI_MASK) | (((uint32_t)val) << IO_PAD23_PIOCFG_SLP_DI_SHIFT))

#define  IO_PAD23_PIOCFG_SLP_CNTRL_MASK 0x200
#define  IO_PAD23_PIOCFG_SLP_CNTRL_SHIFT 9
#define  IO_PAD23_PIOCFG_SLP_CNTRL_MASK_SHIFT(reg) (((reg) & IO_PAD23_PIOCFG_SLP_CNTRL_MASK) >> IO_PAD23_PIOCFG_SLP_CNTRL_SHIFT)
#define  IO_PAD23_PIOCFG_SLP_CNTRL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD23_PIOCFG_SLP_CNTRL_MASK) | (((uint32_t)val) << IO_PAD23_PIOCFG_SLP_CNTRL_SHIFT))

#define  IO_PAD23_PIOCFG_SLP_DO_MASK 0x100
#define  IO_PAD23_PIOCFG_SLP_DO_SHIFT 8
#define  IO_PAD23_PIOCFG_SLP_DO_MASK_SHIFT(reg) (((reg) & IO_PAD23_PIOCFG_SLP_DO_MASK) >> IO_PAD23_PIOCFG_SLP_DO_SHIFT)
#define  IO_PAD23_PIOCFG_SLP_DO_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD23_PIOCFG_SLP_DO_MASK) | (((uint32_t)val) << IO_PAD23_PIOCFG_SLP_DO_SHIFT))

#define  IO_PAD23_PIOCFG_SLP_DIR_MASK 0x80
#define  IO_PAD23_PIOCFG_SLP_DIR_SHIFT 7
#define  IO_PAD23_PIOCFG_SLP_DIR_MASK_SHIFT(reg) (((reg) & IO_PAD23_PIOCFG_SLP_DIR_MASK) >> IO_PAD23_PIOCFG_SLP_DIR_SHIFT)
#define  IO_PAD23_PIOCFG_SLP_DIR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD23_PIOCFG_SLP_DIR_MASK) | (((uint32_t)val) << IO_PAD23_PIOCFG_SLP_DIR_SHIFT))

#define  IO_PAD23_PIOCFG_EDGE_EN_N_MASK 0x40
#define  IO_PAD23_PIOCFG_EDGE_EN_N_SHIFT 6
#define  IO_PAD23_PIOCFG_EDGE_EN_N_MASK_SHIFT(reg) (((reg) & IO_PAD23_PIOCFG_EDGE_EN_N_MASK) >> IO_PAD23_PIOCFG_EDGE_EN_N_SHIFT)
#define  IO_PAD23_PIOCFG_EDGE_EN_N_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD23_PIOCFG_EDGE_EN_N_MASK) | (((uint32_t)val) << IO_PAD23_PIOCFG_EDGE_EN_N_SHIFT))

#define  IO_PAD23_PIOCFG_EDGE_FALL_EN_MASK 0x20
#define  IO_PAD23_PIOCFG_EDGE_FALL_EN_SHIFT 5
#define  IO_PAD23_PIOCFG_EDGE_FALL_EN_MASK_SHIFT(reg) (((reg) & IO_PAD23_PIOCFG_EDGE_FALL_EN_MASK) >> IO_PAD23_PIOCFG_EDGE_FALL_EN_SHIFT)
#define  IO_PAD23_PIOCFG_EDGE_FALL_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD23_PIOCFG_EDGE_FALL_EN_MASK) | (((uint32_t)val) << IO_PAD23_PIOCFG_EDGE_FALL_EN_SHIFT))

#define  IO_PAD23_PIOCFG_EDGE_RISE_EN_MASK 0x10
#define  IO_PAD23_PIOCFG_EDGE_RISE_EN_SHIFT 4
#define  IO_PAD23_PIOCFG_EDGE_RISE_EN_MASK_SHIFT(reg) (((reg) & IO_PAD23_PIOCFG_EDGE_RISE_EN_MASK) >> IO_PAD23_PIOCFG_EDGE_RISE_EN_SHIFT)
#define  IO_PAD23_PIOCFG_EDGE_RISE_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD23_PIOCFG_EDGE_RISE_EN_MASK) | (((uint32_t)val) << IO_PAD23_PIOCFG_EDGE_RISE_EN_SHIFT))

#define  IO_PAD23_PIOCFG_SLP_SEL_MASK 0x8
#define  IO_PAD23_PIOCFG_SLP_SEL_SHIFT 3
#define  IO_PAD23_PIOCFG_SLP_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD23_PIOCFG_SLP_SEL_MASK) >> IO_PAD23_PIOCFG_SLP_SEL_SHIFT)
#define  IO_PAD23_PIOCFG_SLP_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD23_PIOCFG_SLP_SEL_MASK) | (((uint32_t)val) << IO_PAD23_PIOCFG_SLP_SEL_SHIFT))

#define  IO_PAD23_PIOCFG_FUNC_SEL_MASK 0x7
#define  IO_PAD23_PIOCFG_FUNC_SEL_SHIFT 0
#define  IO_PAD23_PIOCFG_FUNC_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD23_PIOCFG_FUNC_SEL_MASK) >> IO_PAD23_PIOCFG_FUNC_SEL_SHIFT)
#define  IO_PAD23_PIOCFG_FUNC_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD23_PIOCFG_FUNC_SEL_MASK) | (((uint32_t)val) << IO_PAD23_PIOCFG_FUNC_SEL_SHIFT))

//====================================================================
//
//Register File: IO_PAD24 Configuration Registers (IO_PAD24)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

//====================================================================
//Register: IO_PAD24 Configuration Register (PIOCFG)
/** \brief "PHI_PADXDC_HSIOB" Pad*/
//====================================================================

#define  IO_PAD24_PIOCFG_RESERVED1_MASK 0xfc000000
#define  IO_PAD24_PIOCFG_RESERVED1_SHIFT 26
#define  IO_PAD24_PIOCFG_RESERVED1_MASK_SHIFT(reg) (((reg) & IO_PAD24_PIOCFG_RESERVED1_MASK) >> IO_PAD24_PIOCFG_RESERVED1_SHIFT)
#define  IO_PAD24_PIOCFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD24_PIOCFG_RESERVED1_MASK) | (((uint32_t)val) << IO_PAD24_PIOCFG_RESERVED1_SHIFT))

#define  IO_PAD24_PIOCFG_PD_MASK 0x2000000
#define  IO_PAD24_PIOCFG_PD_SHIFT 25
#define  IO_PAD24_PIOCFG_PD_MASK_SHIFT(reg) (((reg) & IO_PAD24_PIOCFG_PD_MASK) >> IO_PAD24_PIOCFG_PD_SHIFT)
#define  IO_PAD24_PIOCFG_PD_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD24_PIOCFG_PD_MASK) | (((uint32_t)val) << IO_PAD24_PIOCFG_PD_SHIFT))

#define  IO_PAD24_PIOCFG_ODT_EN_MASK 0x1000000
#define  IO_PAD24_PIOCFG_ODT_EN_SHIFT 24
#define  IO_PAD24_PIOCFG_ODT_EN_MASK_SHIFT(reg) (((reg) & IO_PAD24_PIOCFG_ODT_EN_MASK) >> IO_PAD24_PIOCFG_ODT_EN_SHIFT)
#define  IO_PAD24_PIOCFG_ODT_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD24_PIOCFG_ODT_EN_MASK) | (((uint32_t)val) << IO_PAD24_PIOCFG_ODT_EN_SHIFT))

#define  IO_PAD24_PIOCFG_LED_EN_MASK 0x800000
#define  IO_PAD24_PIOCFG_LED_EN_SHIFT 23
#define  IO_PAD24_PIOCFG_LED_EN_MASK_SHIFT(reg) (((reg) & IO_PAD24_PIOCFG_LED_EN_MASK) >> IO_PAD24_PIOCFG_LED_EN_SHIFT)
#define  IO_PAD24_PIOCFG_LED_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD24_PIOCFG_LED_EN_MASK) | (((uint32_t)val) << IO_PAD24_PIOCFG_LED_EN_SHIFT))

#define  IO_PAD24_PIOCFG_I2C_SEL_MASK 0x600000
#define  IO_PAD24_PIOCFG_I2C_SEL_SHIFT 21
#define  IO_PAD24_PIOCFG_I2C_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD24_PIOCFG_I2C_SEL_MASK) >> IO_PAD24_PIOCFG_I2C_SEL_SHIFT)
#define  IO_PAD24_PIOCFG_I2C_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD24_PIOCFG_I2C_SEL_MASK) | (((uint32_t)val) << IO_PAD24_PIOCFG_I2C_SEL_SHIFT))

#define  IO_PAD24_PIOCFG_DGTBSEL_MASK 0x1e0000
#define  IO_PAD24_PIOCFG_DGTBSEL_SHIFT 17
#define  IO_PAD24_PIOCFG_DGTBSEL_MASK_SHIFT(reg) (((reg) & IO_PAD24_PIOCFG_DGTBSEL_MASK) >> IO_PAD24_PIOCFG_DGTBSEL_SHIFT)
#define  IO_PAD24_PIOCFG_DGTBSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD24_PIOCFG_DGTBSEL_MASK) | (((uint32_t)val) << IO_PAD24_PIOCFG_DGTBSEL_SHIFT))

#define  IO_PAD24_PIOCFG_RAWSEL_MASK 0x10000
#define  IO_PAD24_PIOCFG_RAWSEL_SHIFT 16
#define  IO_PAD24_PIOCFG_RAWSEL_MASK_SHIFT(reg) (((reg) & IO_PAD24_PIOCFG_RAWSEL_MASK) >> IO_PAD24_PIOCFG_RAWSEL_SHIFT)
#define  IO_PAD24_PIOCFG_RAWSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD24_PIOCFG_RAWSEL_MASK) | (((uint32_t)val) << IO_PAD24_PIOCFG_RAWSEL_SHIFT))

#define  IO_PAD24_PIOCFG_PULL_SEL_MASK 0x8000
#define  IO_PAD24_PIOCFG_PULL_SEL_SHIFT 15
#define  IO_PAD24_PIOCFG_PULL_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD24_PIOCFG_PULL_SEL_MASK) >> IO_PAD24_PIOCFG_PULL_SEL_SHIFT)
#define  IO_PAD24_PIOCFG_PULL_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD24_PIOCFG_PULL_SEL_MASK) | (((uint32_t)val) << IO_PAD24_PIOCFG_PULL_SEL_SHIFT))

#define  IO_PAD24_PIOCFG_PUEN_MASK 0x4000
#define  IO_PAD24_PIOCFG_PUEN_SHIFT 14
#define  IO_PAD24_PIOCFG_PUEN_MASK_SHIFT(reg) (((reg) & IO_PAD24_PIOCFG_PUEN_MASK) >> IO_PAD24_PIOCFG_PUEN_SHIFT)
#define  IO_PAD24_PIOCFG_PUEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD24_PIOCFG_PUEN_MASK) | (((uint32_t)val) << IO_PAD24_PIOCFG_PUEN_SHIFT))

#define  IO_PAD24_PIOCFG_PDEN_MASK 0x2000
#define  IO_PAD24_PIOCFG_PDEN_SHIFT 13
#define  IO_PAD24_PIOCFG_PDEN_MASK_SHIFT(reg) (((reg) & IO_PAD24_PIOCFG_PDEN_MASK) >> IO_PAD24_PIOCFG_PDEN_SHIFT)
#define  IO_PAD24_PIOCFG_PDEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD24_PIOCFG_PDEN_MASK) | (((uint32_t)val) << IO_PAD24_PIOCFG_PDEN_SHIFT))

#define  IO_PAD24_PIOCFG_SR_MASK 0x1800
#define  IO_PAD24_PIOCFG_SR_SHIFT 11
#define  IO_PAD24_PIOCFG_SR_MASK_SHIFT(reg) (((reg) & IO_PAD24_PIOCFG_SR_MASK) >> IO_PAD24_PIOCFG_SR_SHIFT)
#define  IO_PAD24_PIOCFG_SR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD24_PIOCFG_SR_MASK) | (((uint32_t)val) << IO_PAD24_PIOCFG_SR_SHIFT))

#define  IO_PAD24_PIOCFG_SLP_DI_MASK 0x400
#define  IO_PAD24_PIOCFG_SLP_DI_SHIFT 10
#define  IO_PAD24_PIOCFG_SLP_DI_MASK_SHIFT(reg) (((reg) & IO_PAD24_PIOCFG_SLP_DI_MASK) >> IO_PAD24_PIOCFG_SLP_DI_SHIFT)
#define  IO_PAD24_PIOCFG_SLP_DI_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD24_PIOCFG_SLP_DI_MASK) | (((uint32_t)val) << IO_PAD24_PIOCFG_SLP_DI_SHIFT))

#define  IO_PAD24_PIOCFG_SLP_CNTRL_MASK 0x200
#define  IO_PAD24_PIOCFG_SLP_CNTRL_SHIFT 9
#define  IO_PAD24_PIOCFG_SLP_CNTRL_MASK_SHIFT(reg) (((reg) & IO_PAD24_PIOCFG_SLP_CNTRL_MASK) >> IO_PAD24_PIOCFG_SLP_CNTRL_SHIFT)
#define  IO_PAD24_PIOCFG_SLP_CNTRL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD24_PIOCFG_SLP_CNTRL_MASK) | (((uint32_t)val) << IO_PAD24_PIOCFG_SLP_CNTRL_SHIFT))

#define  IO_PAD24_PIOCFG_SLP_DO_MASK 0x100
#define  IO_PAD24_PIOCFG_SLP_DO_SHIFT 8
#define  IO_PAD24_PIOCFG_SLP_DO_MASK_SHIFT(reg) (((reg) & IO_PAD24_PIOCFG_SLP_DO_MASK) >> IO_PAD24_PIOCFG_SLP_DO_SHIFT)
#define  IO_PAD24_PIOCFG_SLP_DO_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD24_PIOCFG_SLP_DO_MASK) | (((uint32_t)val) << IO_PAD24_PIOCFG_SLP_DO_SHIFT))

#define  IO_PAD24_PIOCFG_SLP_DIR_MASK 0x80
#define  IO_PAD24_PIOCFG_SLP_DIR_SHIFT 7
#define  IO_PAD24_PIOCFG_SLP_DIR_MASK_SHIFT(reg) (((reg) & IO_PAD24_PIOCFG_SLP_DIR_MASK) >> IO_PAD24_PIOCFG_SLP_DIR_SHIFT)
#define  IO_PAD24_PIOCFG_SLP_DIR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD24_PIOCFG_SLP_DIR_MASK) | (((uint32_t)val) << IO_PAD24_PIOCFG_SLP_DIR_SHIFT))

#define  IO_PAD24_PIOCFG_EDGE_EN_N_MASK 0x40
#define  IO_PAD24_PIOCFG_EDGE_EN_N_SHIFT 6
#define  IO_PAD24_PIOCFG_EDGE_EN_N_MASK_SHIFT(reg) (((reg) & IO_PAD24_PIOCFG_EDGE_EN_N_MASK) >> IO_PAD24_PIOCFG_EDGE_EN_N_SHIFT)
#define  IO_PAD24_PIOCFG_EDGE_EN_N_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD24_PIOCFG_EDGE_EN_N_MASK) | (((uint32_t)val) << IO_PAD24_PIOCFG_EDGE_EN_N_SHIFT))

#define  IO_PAD24_PIOCFG_EDGE_FALL_EN_MASK 0x20
#define  IO_PAD24_PIOCFG_EDGE_FALL_EN_SHIFT 5
#define  IO_PAD24_PIOCFG_EDGE_FALL_EN_MASK_SHIFT(reg) (((reg) & IO_PAD24_PIOCFG_EDGE_FALL_EN_MASK) >> IO_PAD24_PIOCFG_EDGE_FALL_EN_SHIFT)
#define  IO_PAD24_PIOCFG_EDGE_FALL_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD24_PIOCFG_EDGE_FALL_EN_MASK) | (((uint32_t)val) << IO_PAD24_PIOCFG_EDGE_FALL_EN_SHIFT))

#define  IO_PAD24_PIOCFG_EDGE_RISE_EN_MASK 0x10
#define  IO_PAD24_PIOCFG_EDGE_RISE_EN_SHIFT 4
#define  IO_PAD24_PIOCFG_EDGE_RISE_EN_MASK_SHIFT(reg) (((reg) & IO_PAD24_PIOCFG_EDGE_RISE_EN_MASK) >> IO_PAD24_PIOCFG_EDGE_RISE_EN_SHIFT)
#define  IO_PAD24_PIOCFG_EDGE_RISE_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD24_PIOCFG_EDGE_RISE_EN_MASK) | (((uint32_t)val) << IO_PAD24_PIOCFG_EDGE_RISE_EN_SHIFT))

#define  IO_PAD24_PIOCFG_SLP_SEL_MASK 0x8
#define  IO_PAD24_PIOCFG_SLP_SEL_SHIFT 3
#define  IO_PAD24_PIOCFG_SLP_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD24_PIOCFG_SLP_SEL_MASK) >> IO_PAD24_PIOCFG_SLP_SEL_SHIFT)
#define  IO_PAD24_PIOCFG_SLP_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD24_PIOCFG_SLP_SEL_MASK) | (((uint32_t)val) << IO_PAD24_PIOCFG_SLP_SEL_SHIFT))

#define  IO_PAD24_PIOCFG_FUNC_SEL_MASK 0x7
#define  IO_PAD24_PIOCFG_FUNC_SEL_SHIFT 0
#define  IO_PAD24_PIOCFG_FUNC_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD24_PIOCFG_FUNC_SEL_MASK) >> IO_PAD24_PIOCFG_FUNC_SEL_SHIFT)
#define  IO_PAD24_PIOCFG_FUNC_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD24_PIOCFG_FUNC_SEL_MASK) | (((uint32_t)val) << IO_PAD24_PIOCFG_FUNC_SEL_SHIFT))

//====================================================================
//
//Register File: IO_PAD25 Configuration Registers (IO_PAD25)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

//====================================================================
//Register: IO_PAD25 Configuration Register (PIOCFG)
/** \brief "PHI_PADXDC_HSIOB" Pad*/
//====================================================================

#define  IO_PAD25_PIOCFG_RESERVED1_MASK 0xfc000000
#define  IO_PAD25_PIOCFG_RESERVED1_SHIFT 26
#define  IO_PAD25_PIOCFG_RESERVED1_MASK_SHIFT(reg) (((reg) & IO_PAD25_PIOCFG_RESERVED1_MASK) >> IO_PAD25_PIOCFG_RESERVED1_SHIFT)
#define  IO_PAD25_PIOCFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD25_PIOCFG_RESERVED1_MASK) | (((uint32_t)val) << IO_PAD25_PIOCFG_RESERVED1_SHIFT))

#define  IO_PAD25_PIOCFG_PD_MASK 0x2000000
#define  IO_PAD25_PIOCFG_PD_SHIFT 25
#define  IO_PAD25_PIOCFG_PD_MASK_SHIFT(reg) (((reg) & IO_PAD25_PIOCFG_PD_MASK) >> IO_PAD25_PIOCFG_PD_SHIFT)
#define  IO_PAD25_PIOCFG_PD_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD25_PIOCFG_PD_MASK) | (((uint32_t)val) << IO_PAD25_PIOCFG_PD_SHIFT))

#define  IO_PAD25_PIOCFG_ODT_EN_MASK 0x1000000
#define  IO_PAD25_PIOCFG_ODT_EN_SHIFT 24
#define  IO_PAD25_PIOCFG_ODT_EN_MASK_SHIFT(reg) (((reg) & IO_PAD25_PIOCFG_ODT_EN_MASK) >> IO_PAD25_PIOCFG_ODT_EN_SHIFT)
#define  IO_PAD25_PIOCFG_ODT_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD25_PIOCFG_ODT_EN_MASK) | (((uint32_t)val) << IO_PAD25_PIOCFG_ODT_EN_SHIFT))

#define  IO_PAD25_PIOCFG_LED_EN_MASK 0x800000
#define  IO_PAD25_PIOCFG_LED_EN_SHIFT 23
#define  IO_PAD25_PIOCFG_LED_EN_MASK_SHIFT(reg) (((reg) & IO_PAD25_PIOCFG_LED_EN_MASK) >> IO_PAD25_PIOCFG_LED_EN_SHIFT)
#define  IO_PAD25_PIOCFG_LED_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD25_PIOCFG_LED_EN_MASK) | (((uint32_t)val) << IO_PAD25_PIOCFG_LED_EN_SHIFT))

#define  IO_PAD25_PIOCFG_I2C_SEL_MASK 0x600000
#define  IO_PAD25_PIOCFG_I2C_SEL_SHIFT 21
#define  IO_PAD25_PIOCFG_I2C_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD25_PIOCFG_I2C_SEL_MASK) >> IO_PAD25_PIOCFG_I2C_SEL_SHIFT)
#define  IO_PAD25_PIOCFG_I2C_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD25_PIOCFG_I2C_SEL_MASK) | (((uint32_t)val) << IO_PAD25_PIOCFG_I2C_SEL_SHIFT))

#define  IO_PAD25_PIOCFG_DGTBSEL_MASK 0x1e0000
#define  IO_PAD25_PIOCFG_DGTBSEL_SHIFT 17
#define  IO_PAD25_PIOCFG_DGTBSEL_MASK_SHIFT(reg) (((reg) & IO_PAD25_PIOCFG_DGTBSEL_MASK) >> IO_PAD25_PIOCFG_DGTBSEL_SHIFT)
#define  IO_PAD25_PIOCFG_DGTBSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD25_PIOCFG_DGTBSEL_MASK) | (((uint32_t)val) << IO_PAD25_PIOCFG_DGTBSEL_SHIFT))

#define  IO_PAD25_PIOCFG_RAWSEL_MASK 0x10000
#define  IO_PAD25_PIOCFG_RAWSEL_SHIFT 16
#define  IO_PAD25_PIOCFG_RAWSEL_MASK_SHIFT(reg) (((reg) & IO_PAD25_PIOCFG_RAWSEL_MASK) >> IO_PAD25_PIOCFG_RAWSEL_SHIFT)
#define  IO_PAD25_PIOCFG_RAWSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD25_PIOCFG_RAWSEL_MASK) | (((uint32_t)val) << IO_PAD25_PIOCFG_RAWSEL_SHIFT))

#define  IO_PAD25_PIOCFG_PULL_SEL_MASK 0x8000
#define  IO_PAD25_PIOCFG_PULL_SEL_SHIFT 15
#define  IO_PAD25_PIOCFG_PULL_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD25_PIOCFG_PULL_SEL_MASK) >> IO_PAD25_PIOCFG_PULL_SEL_SHIFT)
#define  IO_PAD25_PIOCFG_PULL_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD25_PIOCFG_PULL_SEL_MASK) | (((uint32_t)val) << IO_PAD25_PIOCFG_PULL_SEL_SHIFT))

#define  IO_PAD25_PIOCFG_PUEN_MASK 0x4000
#define  IO_PAD25_PIOCFG_PUEN_SHIFT 14
#define  IO_PAD25_PIOCFG_PUEN_MASK_SHIFT(reg) (((reg) & IO_PAD25_PIOCFG_PUEN_MASK) >> IO_PAD25_PIOCFG_PUEN_SHIFT)
#define  IO_PAD25_PIOCFG_PUEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD25_PIOCFG_PUEN_MASK) | (((uint32_t)val) << IO_PAD25_PIOCFG_PUEN_SHIFT))

#define  IO_PAD25_PIOCFG_PDEN_MASK 0x2000
#define  IO_PAD25_PIOCFG_PDEN_SHIFT 13
#define  IO_PAD25_PIOCFG_PDEN_MASK_SHIFT(reg) (((reg) & IO_PAD25_PIOCFG_PDEN_MASK) >> IO_PAD25_PIOCFG_PDEN_SHIFT)
#define  IO_PAD25_PIOCFG_PDEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD25_PIOCFG_PDEN_MASK) | (((uint32_t)val) << IO_PAD25_PIOCFG_PDEN_SHIFT))

#define  IO_PAD25_PIOCFG_SR_MASK 0x1800
#define  IO_PAD25_PIOCFG_SR_SHIFT 11
#define  IO_PAD25_PIOCFG_SR_MASK_SHIFT(reg) (((reg) & IO_PAD25_PIOCFG_SR_MASK) >> IO_PAD25_PIOCFG_SR_SHIFT)
#define  IO_PAD25_PIOCFG_SR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD25_PIOCFG_SR_MASK) | (((uint32_t)val) << IO_PAD25_PIOCFG_SR_SHIFT))

#define  IO_PAD25_PIOCFG_SLP_DI_MASK 0x400
#define  IO_PAD25_PIOCFG_SLP_DI_SHIFT 10
#define  IO_PAD25_PIOCFG_SLP_DI_MASK_SHIFT(reg) (((reg) & IO_PAD25_PIOCFG_SLP_DI_MASK) >> IO_PAD25_PIOCFG_SLP_DI_SHIFT)
#define  IO_PAD25_PIOCFG_SLP_DI_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD25_PIOCFG_SLP_DI_MASK) | (((uint32_t)val) << IO_PAD25_PIOCFG_SLP_DI_SHIFT))

#define  IO_PAD25_PIOCFG_SLP_CNTRL_MASK 0x200
#define  IO_PAD25_PIOCFG_SLP_CNTRL_SHIFT 9
#define  IO_PAD25_PIOCFG_SLP_CNTRL_MASK_SHIFT(reg) (((reg) & IO_PAD25_PIOCFG_SLP_CNTRL_MASK) >> IO_PAD25_PIOCFG_SLP_CNTRL_SHIFT)
#define  IO_PAD25_PIOCFG_SLP_CNTRL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD25_PIOCFG_SLP_CNTRL_MASK) | (((uint32_t)val) << IO_PAD25_PIOCFG_SLP_CNTRL_SHIFT))

#define  IO_PAD25_PIOCFG_SLP_DO_MASK 0x100
#define  IO_PAD25_PIOCFG_SLP_DO_SHIFT 8
#define  IO_PAD25_PIOCFG_SLP_DO_MASK_SHIFT(reg) (((reg) & IO_PAD25_PIOCFG_SLP_DO_MASK) >> IO_PAD25_PIOCFG_SLP_DO_SHIFT)
#define  IO_PAD25_PIOCFG_SLP_DO_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD25_PIOCFG_SLP_DO_MASK) | (((uint32_t)val) << IO_PAD25_PIOCFG_SLP_DO_SHIFT))

#define  IO_PAD25_PIOCFG_SLP_DIR_MASK 0x80
#define  IO_PAD25_PIOCFG_SLP_DIR_SHIFT 7
#define  IO_PAD25_PIOCFG_SLP_DIR_MASK_SHIFT(reg) (((reg) & IO_PAD25_PIOCFG_SLP_DIR_MASK) >> IO_PAD25_PIOCFG_SLP_DIR_SHIFT)
#define  IO_PAD25_PIOCFG_SLP_DIR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD25_PIOCFG_SLP_DIR_MASK) | (((uint32_t)val) << IO_PAD25_PIOCFG_SLP_DIR_SHIFT))

#define  IO_PAD25_PIOCFG_EDGE_EN_N_MASK 0x40
#define  IO_PAD25_PIOCFG_EDGE_EN_N_SHIFT 6
#define  IO_PAD25_PIOCFG_EDGE_EN_N_MASK_SHIFT(reg) (((reg) & IO_PAD25_PIOCFG_EDGE_EN_N_MASK) >> IO_PAD25_PIOCFG_EDGE_EN_N_SHIFT)
#define  IO_PAD25_PIOCFG_EDGE_EN_N_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD25_PIOCFG_EDGE_EN_N_MASK) | (((uint32_t)val) << IO_PAD25_PIOCFG_EDGE_EN_N_SHIFT))

#define  IO_PAD25_PIOCFG_EDGE_FALL_EN_MASK 0x20
#define  IO_PAD25_PIOCFG_EDGE_FALL_EN_SHIFT 5
#define  IO_PAD25_PIOCFG_EDGE_FALL_EN_MASK_SHIFT(reg) (((reg) & IO_PAD25_PIOCFG_EDGE_FALL_EN_MASK) >> IO_PAD25_PIOCFG_EDGE_FALL_EN_SHIFT)
#define  IO_PAD25_PIOCFG_EDGE_FALL_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD25_PIOCFG_EDGE_FALL_EN_MASK) | (((uint32_t)val) << IO_PAD25_PIOCFG_EDGE_FALL_EN_SHIFT))

#define  IO_PAD25_PIOCFG_EDGE_RISE_EN_MASK 0x10
#define  IO_PAD25_PIOCFG_EDGE_RISE_EN_SHIFT 4
#define  IO_PAD25_PIOCFG_EDGE_RISE_EN_MASK_SHIFT(reg) (((reg) & IO_PAD25_PIOCFG_EDGE_RISE_EN_MASK) >> IO_PAD25_PIOCFG_EDGE_RISE_EN_SHIFT)
#define  IO_PAD25_PIOCFG_EDGE_RISE_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD25_PIOCFG_EDGE_RISE_EN_MASK) | (((uint32_t)val) << IO_PAD25_PIOCFG_EDGE_RISE_EN_SHIFT))

#define  IO_PAD25_PIOCFG_SLP_SEL_MASK 0x8
#define  IO_PAD25_PIOCFG_SLP_SEL_SHIFT 3
#define  IO_PAD25_PIOCFG_SLP_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD25_PIOCFG_SLP_SEL_MASK) >> IO_PAD25_PIOCFG_SLP_SEL_SHIFT)
#define  IO_PAD25_PIOCFG_SLP_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD25_PIOCFG_SLP_SEL_MASK) | (((uint32_t)val) << IO_PAD25_PIOCFG_SLP_SEL_SHIFT))

#define  IO_PAD25_PIOCFG_FUNC_SEL_MASK 0x7
#define  IO_PAD25_PIOCFG_FUNC_SEL_SHIFT 0
#define  IO_PAD25_PIOCFG_FUNC_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD25_PIOCFG_FUNC_SEL_MASK) >> IO_PAD25_PIOCFG_FUNC_SEL_SHIFT)
#define  IO_PAD25_PIOCFG_FUNC_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD25_PIOCFG_FUNC_SEL_MASK) | (((uint32_t)val) << IO_PAD25_PIOCFG_FUNC_SEL_SHIFT))

//====================================================================
//
//Register File: IO_PAD26 Configuration Registers (IO_PAD26)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

//====================================================================
//Register: IO_PAD26 Configuration Register (PIOCFG)
/** \brief "PHI_PADXDC_HSIOB" Pad*/
//====================================================================

#define  IO_PAD26_PIOCFG_RESERVED1_MASK 0xfc000000
#define  IO_PAD26_PIOCFG_RESERVED1_SHIFT 26
#define  IO_PAD26_PIOCFG_RESERVED1_MASK_SHIFT(reg) (((reg) & IO_PAD26_PIOCFG_RESERVED1_MASK) >> IO_PAD26_PIOCFG_RESERVED1_SHIFT)
#define  IO_PAD26_PIOCFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD26_PIOCFG_RESERVED1_MASK) | (((uint32_t)val) << IO_PAD26_PIOCFG_RESERVED1_SHIFT))

#define  IO_PAD26_PIOCFG_PD_MASK 0x2000000
#define  IO_PAD26_PIOCFG_PD_SHIFT 25
#define  IO_PAD26_PIOCFG_PD_MASK_SHIFT(reg) (((reg) & IO_PAD26_PIOCFG_PD_MASK) >> IO_PAD26_PIOCFG_PD_SHIFT)
#define  IO_PAD26_PIOCFG_PD_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD26_PIOCFG_PD_MASK) | (((uint32_t)val) << IO_PAD26_PIOCFG_PD_SHIFT))

#define  IO_PAD26_PIOCFG_ODT_EN_MASK 0x1000000
#define  IO_PAD26_PIOCFG_ODT_EN_SHIFT 24
#define  IO_PAD26_PIOCFG_ODT_EN_MASK_SHIFT(reg) (((reg) & IO_PAD26_PIOCFG_ODT_EN_MASK) >> IO_PAD26_PIOCFG_ODT_EN_SHIFT)
#define  IO_PAD26_PIOCFG_ODT_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD26_PIOCFG_ODT_EN_MASK) | (((uint32_t)val) << IO_PAD26_PIOCFG_ODT_EN_SHIFT))

#define  IO_PAD26_PIOCFG_LED_EN_MASK 0x800000
#define  IO_PAD26_PIOCFG_LED_EN_SHIFT 23
#define  IO_PAD26_PIOCFG_LED_EN_MASK_SHIFT(reg) (((reg) & IO_PAD26_PIOCFG_LED_EN_MASK) >> IO_PAD26_PIOCFG_LED_EN_SHIFT)
#define  IO_PAD26_PIOCFG_LED_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD26_PIOCFG_LED_EN_MASK) | (((uint32_t)val) << IO_PAD26_PIOCFG_LED_EN_SHIFT))

#define  IO_PAD26_PIOCFG_I2C_SEL_MASK 0x600000
#define  IO_PAD26_PIOCFG_I2C_SEL_SHIFT 21
#define  IO_PAD26_PIOCFG_I2C_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD26_PIOCFG_I2C_SEL_MASK) >> IO_PAD26_PIOCFG_I2C_SEL_SHIFT)
#define  IO_PAD26_PIOCFG_I2C_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD26_PIOCFG_I2C_SEL_MASK) | (((uint32_t)val) << IO_PAD26_PIOCFG_I2C_SEL_SHIFT))

#define  IO_PAD26_PIOCFG_DGTBSEL_MASK 0x1e0000
#define  IO_PAD26_PIOCFG_DGTBSEL_SHIFT 17
#define  IO_PAD26_PIOCFG_DGTBSEL_MASK_SHIFT(reg) (((reg) & IO_PAD26_PIOCFG_DGTBSEL_MASK) >> IO_PAD26_PIOCFG_DGTBSEL_SHIFT)
#define  IO_PAD26_PIOCFG_DGTBSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD26_PIOCFG_DGTBSEL_MASK) | (((uint32_t)val) << IO_PAD26_PIOCFG_DGTBSEL_SHIFT))

#define  IO_PAD26_PIOCFG_RAWSEL_MASK 0x10000
#define  IO_PAD26_PIOCFG_RAWSEL_SHIFT 16
#define  IO_PAD26_PIOCFG_RAWSEL_MASK_SHIFT(reg) (((reg) & IO_PAD26_PIOCFG_RAWSEL_MASK) >> IO_PAD26_PIOCFG_RAWSEL_SHIFT)
#define  IO_PAD26_PIOCFG_RAWSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD26_PIOCFG_RAWSEL_MASK) | (((uint32_t)val) << IO_PAD26_PIOCFG_RAWSEL_SHIFT))

#define  IO_PAD26_PIOCFG_PULL_SEL_MASK 0x8000
#define  IO_PAD26_PIOCFG_PULL_SEL_SHIFT 15
#define  IO_PAD26_PIOCFG_PULL_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD26_PIOCFG_PULL_SEL_MASK) >> IO_PAD26_PIOCFG_PULL_SEL_SHIFT)
#define  IO_PAD26_PIOCFG_PULL_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD26_PIOCFG_PULL_SEL_MASK) | (((uint32_t)val) << IO_PAD26_PIOCFG_PULL_SEL_SHIFT))

#define  IO_PAD26_PIOCFG_PUEN_MASK 0x4000
#define  IO_PAD26_PIOCFG_PUEN_SHIFT 14
#define  IO_PAD26_PIOCFG_PUEN_MASK_SHIFT(reg) (((reg) & IO_PAD26_PIOCFG_PUEN_MASK) >> IO_PAD26_PIOCFG_PUEN_SHIFT)
#define  IO_PAD26_PIOCFG_PUEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD26_PIOCFG_PUEN_MASK) | (((uint32_t)val) << IO_PAD26_PIOCFG_PUEN_SHIFT))

#define  IO_PAD26_PIOCFG_PDEN_MASK 0x2000
#define  IO_PAD26_PIOCFG_PDEN_SHIFT 13
#define  IO_PAD26_PIOCFG_PDEN_MASK_SHIFT(reg) (((reg) & IO_PAD26_PIOCFG_PDEN_MASK) >> IO_PAD26_PIOCFG_PDEN_SHIFT)
#define  IO_PAD26_PIOCFG_PDEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD26_PIOCFG_PDEN_MASK) | (((uint32_t)val) << IO_PAD26_PIOCFG_PDEN_SHIFT))

#define  IO_PAD26_PIOCFG_SR_MASK 0x1800
#define  IO_PAD26_PIOCFG_SR_SHIFT 11
#define  IO_PAD26_PIOCFG_SR_MASK_SHIFT(reg) (((reg) & IO_PAD26_PIOCFG_SR_MASK) >> IO_PAD26_PIOCFG_SR_SHIFT)
#define  IO_PAD26_PIOCFG_SR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD26_PIOCFG_SR_MASK) | (((uint32_t)val) << IO_PAD26_PIOCFG_SR_SHIFT))

#define  IO_PAD26_PIOCFG_SLP_DI_MASK 0x400
#define  IO_PAD26_PIOCFG_SLP_DI_SHIFT 10
#define  IO_PAD26_PIOCFG_SLP_DI_MASK_SHIFT(reg) (((reg) & IO_PAD26_PIOCFG_SLP_DI_MASK) >> IO_PAD26_PIOCFG_SLP_DI_SHIFT)
#define  IO_PAD26_PIOCFG_SLP_DI_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD26_PIOCFG_SLP_DI_MASK) | (((uint32_t)val) << IO_PAD26_PIOCFG_SLP_DI_SHIFT))

#define  IO_PAD26_PIOCFG_SLP_CNTRL_MASK 0x200
#define  IO_PAD26_PIOCFG_SLP_CNTRL_SHIFT 9
#define  IO_PAD26_PIOCFG_SLP_CNTRL_MASK_SHIFT(reg) (((reg) & IO_PAD26_PIOCFG_SLP_CNTRL_MASK) >> IO_PAD26_PIOCFG_SLP_CNTRL_SHIFT)
#define  IO_PAD26_PIOCFG_SLP_CNTRL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD26_PIOCFG_SLP_CNTRL_MASK) | (((uint32_t)val) << IO_PAD26_PIOCFG_SLP_CNTRL_SHIFT))

#define  IO_PAD26_PIOCFG_SLP_DO_MASK 0x100
#define  IO_PAD26_PIOCFG_SLP_DO_SHIFT 8
#define  IO_PAD26_PIOCFG_SLP_DO_MASK_SHIFT(reg) (((reg) & IO_PAD26_PIOCFG_SLP_DO_MASK) >> IO_PAD26_PIOCFG_SLP_DO_SHIFT)
#define  IO_PAD26_PIOCFG_SLP_DO_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD26_PIOCFG_SLP_DO_MASK) | (((uint32_t)val) << IO_PAD26_PIOCFG_SLP_DO_SHIFT))

#define  IO_PAD26_PIOCFG_SLP_DIR_MASK 0x80
#define  IO_PAD26_PIOCFG_SLP_DIR_SHIFT 7
#define  IO_PAD26_PIOCFG_SLP_DIR_MASK_SHIFT(reg) (((reg) & IO_PAD26_PIOCFG_SLP_DIR_MASK) >> IO_PAD26_PIOCFG_SLP_DIR_SHIFT)
#define  IO_PAD26_PIOCFG_SLP_DIR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD26_PIOCFG_SLP_DIR_MASK) | (((uint32_t)val) << IO_PAD26_PIOCFG_SLP_DIR_SHIFT))

#define  IO_PAD26_PIOCFG_EDGE_EN_N_MASK 0x40
#define  IO_PAD26_PIOCFG_EDGE_EN_N_SHIFT 6
#define  IO_PAD26_PIOCFG_EDGE_EN_N_MASK_SHIFT(reg) (((reg) & IO_PAD26_PIOCFG_EDGE_EN_N_MASK) >> IO_PAD26_PIOCFG_EDGE_EN_N_SHIFT)
#define  IO_PAD26_PIOCFG_EDGE_EN_N_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD26_PIOCFG_EDGE_EN_N_MASK) | (((uint32_t)val) << IO_PAD26_PIOCFG_EDGE_EN_N_SHIFT))

#define  IO_PAD26_PIOCFG_EDGE_FALL_EN_MASK 0x20
#define  IO_PAD26_PIOCFG_EDGE_FALL_EN_SHIFT 5
#define  IO_PAD26_PIOCFG_EDGE_FALL_EN_MASK_SHIFT(reg) (((reg) & IO_PAD26_PIOCFG_EDGE_FALL_EN_MASK) >> IO_PAD26_PIOCFG_EDGE_FALL_EN_SHIFT)
#define  IO_PAD26_PIOCFG_EDGE_FALL_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD26_PIOCFG_EDGE_FALL_EN_MASK) | (((uint32_t)val) << IO_PAD26_PIOCFG_EDGE_FALL_EN_SHIFT))

#define  IO_PAD26_PIOCFG_EDGE_RISE_EN_MASK 0x10
#define  IO_PAD26_PIOCFG_EDGE_RISE_EN_SHIFT 4
#define  IO_PAD26_PIOCFG_EDGE_RISE_EN_MASK_SHIFT(reg) (((reg) & IO_PAD26_PIOCFG_EDGE_RISE_EN_MASK) >> IO_PAD26_PIOCFG_EDGE_RISE_EN_SHIFT)
#define  IO_PAD26_PIOCFG_EDGE_RISE_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD26_PIOCFG_EDGE_RISE_EN_MASK) | (((uint32_t)val) << IO_PAD26_PIOCFG_EDGE_RISE_EN_SHIFT))

#define  IO_PAD26_PIOCFG_SLP_SEL_MASK 0x8
#define  IO_PAD26_PIOCFG_SLP_SEL_SHIFT 3
#define  IO_PAD26_PIOCFG_SLP_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD26_PIOCFG_SLP_SEL_MASK) >> IO_PAD26_PIOCFG_SLP_SEL_SHIFT)
#define  IO_PAD26_PIOCFG_SLP_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD26_PIOCFG_SLP_SEL_MASK) | (((uint32_t)val) << IO_PAD26_PIOCFG_SLP_SEL_SHIFT))

#define  IO_PAD26_PIOCFG_FUNC_SEL_MASK 0x7
#define  IO_PAD26_PIOCFG_FUNC_SEL_SHIFT 0
#define  IO_PAD26_PIOCFG_FUNC_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD26_PIOCFG_FUNC_SEL_MASK) >> IO_PAD26_PIOCFG_FUNC_SEL_SHIFT)
#define  IO_PAD26_PIOCFG_FUNC_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD26_PIOCFG_FUNC_SEL_MASK) | (((uint32_t)val) << IO_PAD26_PIOCFG_FUNC_SEL_SHIFT))

//====================================================================
//
//Register File: IO_PAD27 Configuration Registers (IO_PAD27)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

//====================================================================
//Register: IO_PAD27 Configuration Register (PIOCFG)
/** \brief "PHI_PADXDC_HSIOB" Pad*/
//====================================================================

#define  IO_PAD27_PIOCFG_RESERVED1_MASK 0xfc000000
#define  IO_PAD27_PIOCFG_RESERVED1_SHIFT 26
#define  IO_PAD27_PIOCFG_RESERVED1_MASK_SHIFT(reg) (((reg) & IO_PAD27_PIOCFG_RESERVED1_MASK) >> IO_PAD27_PIOCFG_RESERVED1_SHIFT)
#define  IO_PAD27_PIOCFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD27_PIOCFG_RESERVED1_MASK) | (((uint32_t)val) << IO_PAD27_PIOCFG_RESERVED1_SHIFT))

#define  IO_PAD27_PIOCFG_PD_MASK 0x2000000
#define  IO_PAD27_PIOCFG_PD_SHIFT 25
#define  IO_PAD27_PIOCFG_PD_MASK_SHIFT(reg) (((reg) & IO_PAD27_PIOCFG_PD_MASK) >> IO_PAD27_PIOCFG_PD_SHIFT)
#define  IO_PAD27_PIOCFG_PD_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD27_PIOCFG_PD_MASK) | (((uint32_t)val) << IO_PAD27_PIOCFG_PD_SHIFT))

#define  IO_PAD27_PIOCFG_ODT_EN_MASK 0x1000000
#define  IO_PAD27_PIOCFG_ODT_EN_SHIFT 24
#define  IO_PAD27_PIOCFG_ODT_EN_MASK_SHIFT(reg) (((reg) & IO_PAD27_PIOCFG_ODT_EN_MASK) >> IO_PAD27_PIOCFG_ODT_EN_SHIFT)
#define  IO_PAD27_PIOCFG_ODT_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD27_PIOCFG_ODT_EN_MASK) | (((uint32_t)val) << IO_PAD27_PIOCFG_ODT_EN_SHIFT))

#define  IO_PAD27_PIOCFG_LED_EN_MASK 0x800000
#define  IO_PAD27_PIOCFG_LED_EN_SHIFT 23
#define  IO_PAD27_PIOCFG_LED_EN_MASK_SHIFT(reg) (((reg) & IO_PAD27_PIOCFG_LED_EN_MASK) >> IO_PAD27_PIOCFG_LED_EN_SHIFT)
#define  IO_PAD27_PIOCFG_LED_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD27_PIOCFG_LED_EN_MASK) | (((uint32_t)val) << IO_PAD27_PIOCFG_LED_EN_SHIFT))

#define  IO_PAD27_PIOCFG_I2C_SEL_MASK 0x600000
#define  IO_PAD27_PIOCFG_I2C_SEL_SHIFT 21
#define  IO_PAD27_PIOCFG_I2C_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD27_PIOCFG_I2C_SEL_MASK) >> IO_PAD27_PIOCFG_I2C_SEL_SHIFT)
#define  IO_PAD27_PIOCFG_I2C_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD27_PIOCFG_I2C_SEL_MASK) | (((uint32_t)val) << IO_PAD27_PIOCFG_I2C_SEL_SHIFT))

#define  IO_PAD27_PIOCFG_DGTBSEL_MASK 0x1e0000
#define  IO_PAD27_PIOCFG_DGTBSEL_SHIFT 17
#define  IO_PAD27_PIOCFG_DGTBSEL_MASK_SHIFT(reg) (((reg) & IO_PAD27_PIOCFG_DGTBSEL_MASK) >> IO_PAD27_PIOCFG_DGTBSEL_SHIFT)
#define  IO_PAD27_PIOCFG_DGTBSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD27_PIOCFG_DGTBSEL_MASK) | (((uint32_t)val) << IO_PAD27_PIOCFG_DGTBSEL_SHIFT))

#define  IO_PAD27_PIOCFG_RAWSEL_MASK 0x10000
#define  IO_PAD27_PIOCFG_RAWSEL_SHIFT 16
#define  IO_PAD27_PIOCFG_RAWSEL_MASK_SHIFT(reg) (((reg) & IO_PAD27_PIOCFG_RAWSEL_MASK) >> IO_PAD27_PIOCFG_RAWSEL_SHIFT)
#define  IO_PAD27_PIOCFG_RAWSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD27_PIOCFG_RAWSEL_MASK) | (((uint32_t)val) << IO_PAD27_PIOCFG_RAWSEL_SHIFT))

#define  IO_PAD27_PIOCFG_PULL_SEL_MASK 0x8000
#define  IO_PAD27_PIOCFG_PULL_SEL_SHIFT 15
#define  IO_PAD27_PIOCFG_PULL_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD27_PIOCFG_PULL_SEL_MASK) >> IO_PAD27_PIOCFG_PULL_SEL_SHIFT)
#define  IO_PAD27_PIOCFG_PULL_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD27_PIOCFG_PULL_SEL_MASK) | (((uint32_t)val) << IO_PAD27_PIOCFG_PULL_SEL_SHIFT))

#define  IO_PAD27_PIOCFG_PUEN_MASK 0x4000
#define  IO_PAD27_PIOCFG_PUEN_SHIFT 14
#define  IO_PAD27_PIOCFG_PUEN_MASK_SHIFT(reg) (((reg) & IO_PAD27_PIOCFG_PUEN_MASK) >> IO_PAD27_PIOCFG_PUEN_SHIFT)
#define  IO_PAD27_PIOCFG_PUEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD27_PIOCFG_PUEN_MASK) | (((uint32_t)val) << IO_PAD27_PIOCFG_PUEN_SHIFT))

#define  IO_PAD27_PIOCFG_PDEN_MASK 0x2000
#define  IO_PAD27_PIOCFG_PDEN_SHIFT 13
#define  IO_PAD27_PIOCFG_PDEN_MASK_SHIFT(reg) (((reg) & IO_PAD27_PIOCFG_PDEN_MASK) >> IO_PAD27_PIOCFG_PDEN_SHIFT)
#define  IO_PAD27_PIOCFG_PDEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD27_PIOCFG_PDEN_MASK) | (((uint32_t)val) << IO_PAD27_PIOCFG_PDEN_SHIFT))

#define  IO_PAD27_PIOCFG_SR_MASK 0x1800
#define  IO_PAD27_PIOCFG_SR_SHIFT 11
#define  IO_PAD27_PIOCFG_SR_MASK_SHIFT(reg) (((reg) & IO_PAD27_PIOCFG_SR_MASK) >> IO_PAD27_PIOCFG_SR_SHIFT)
#define  IO_PAD27_PIOCFG_SR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD27_PIOCFG_SR_MASK) | (((uint32_t)val) << IO_PAD27_PIOCFG_SR_SHIFT))

#define  IO_PAD27_PIOCFG_SLP_DI_MASK 0x400
#define  IO_PAD27_PIOCFG_SLP_DI_SHIFT 10
#define  IO_PAD27_PIOCFG_SLP_DI_MASK_SHIFT(reg) (((reg) & IO_PAD27_PIOCFG_SLP_DI_MASK) >> IO_PAD27_PIOCFG_SLP_DI_SHIFT)
#define  IO_PAD27_PIOCFG_SLP_DI_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD27_PIOCFG_SLP_DI_MASK) | (((uint32_t)val) << IO_PAD27_PIOCFG_SLP_DI_SHIFT))

#define  IO_PAD27_PIOCFG_SLP_CNTRL_MASK 0x200
#define  IO_PAD27_PIOCFG_SLP_CNTRL_SHIFT 9
#define  IO_PAD27_PIOCFG_SLP_CNTRL_MASK_SHIFT(reg) (((reg) & IO_PAD27_PIOCFG_SLP_CNTRL_MASK) >> IO_PAD27_PIOCFG_SLP_CNTRL_SHIFT)
#define  IO_PAD27_PIOCFG_SLP_CNTRL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD27_PIOCFG_SLP_CNTRL_MASK) | (((uint32_t)val) << IO_PAD27_PIOCFG_SLP_CNTRL_SHIFT))

#define  IO_PAD27_PIOCFG_SLP_DO_MASK 0x100
#define  IO_PAD27_PIOCFG_SLP_DO_SHIFT 8
#define  IO_PAD27_PIOCFG_SLP_DO_MASK_SHIFT(reg) (((reg) & IO_PAD27_PIOCFG_SLP_DO_MASK) >> IO_PAD27_PIOCFG_SLP_DO_SHIFT)
#define  IO_PAD27_PIOCFG_SLP_DO_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD27_PIOCFG_SLP_DO_MASK) | (((uint32_t)val) << IO_PAD27_PIOCFG_SLP_DO_SHIFT))

#define  IO_PAD27_PIOCFG_SLP_DIR_MASK 0x80
#define  IO_PAD27_PIOCFG_SLP_DIR_SHIFT 7
#define  IO_PAD27_PIOCFG_SLP_DIR_MASK_SHIFT(reg) (((reg) & IO_PAD27_PIOCFG_SLP_DIR_MASK) >> IO_PAD27_PIOCFG_SLP_DIR_SHIFT)
#define  IO_PAD27_PIOCFG_SLP_DIR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD27_PIOCFG_SLP_DIR_MASK) | (((uint32_t)val) << IO_PAD27_PIOCFG_SLP_DIR_SHIFT))

#define  IO_PAD27_PIOCFG_EDGE_EN_N_MASK 0x40
#define  IO_PAD27_PIOCFG_EDGE_EN_N_SHIFT 6
#define  IO_PAD27_PIOCFG_EDGE_EN_N_MASK_SHIFT(reg) (((reg) & IO_PAD27_PIOCFG_EDGE_EN_N_MASK) >> IO_PAD27_PIOCFG_EDGE_EN_N_SHIFT)
#define  IO_PAD27_PIOCFG_EDGE_EN_N_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD27_PIOCFG_EDGE_EN_N_MASK) | (((uint32_t)val) << IO_PAD27_PIOCFG_EDGE_EN_N_SHIFT))

#define  IO_PAD27_PIOCFG_EDGE_FALL_EN_MASK 0x20
#define  IO_PAD27_PIOCFG_EDGE_FALL_EN_SHIFT 5
#define  IO_PAD27_PIOCFG_EDGE_FALL_EN_MASK_SHIFT(reg) (((reg) & IO_PAD27_PIOCFG_EDGE_FALL_EN_MASK) >> IO_PAD27_PIOCFG_EDGE_FALL_EN_SHIFT)
#define  IO_PAD27_PIOCFG_EDGE_FALL_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD27_PIOCFG_EDGE_FALL_EN_MASK) | (((uint32_t)val) << IO_PAD27_PIOCFG_EDGE_FALL_EN_SHIFT))

#define  IO_PAD27_PIOCFG_EDGE_RISE_EN_MASK 0x10
#define  IO_PAD27_PIOCFG_EDGE_RISE_EN_SHIFT 4
#define  IO_PAD27_PIOCFG_EDGE_RISE_EN_MASK_SHIFT(reg) (((reg) & IO_PAD27_PIOCFG_EDGE_RISE_EN_MASK) >> IO_PAD27_PIOCFG_EDGE_RISE_EN_SHIFT)
#define  IO_PAD27_PIOCFG_EDGE_RISE_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD27_PIOCFG_EDGE_RISE_EN_MASK) | (((uint32_t)val) << IO_PAD27_PIOCFG_EDGE_RISE_EN_SHIFT))

#define  IO_PAD27_PIOCFG_SLP_SEL_MASK 0x8
#define  IO_PAD27_PIOCFG_SLP_SEL_SHIFT 3
#define  IO_PAD27_PIOCFG_SLP_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD27_PIOCFG_SLP_SEL_MASK) >> IO_PAD27_PIOCFG_SLP_SEL_SHIFT)
#define  IO_PAD27_PIOCFG_SLP_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD27_PIOCFG_SLP_SEL_MASK) | (((uint32_t)val) << IO_PAD27_PIOCFG_SLP_SEL_SHIFT))

#define  IO_PAD27_PIOCFG_FUNC_SEL_MASK 0x7
#define  IO_PAD27_PIOCFG_FUNC_SEL_SHIFT 0
#define  IO_PAD27_PIOCFG_FUNC_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD27_PIOCFG_FUNC_SEL_MASK) >> IO_PAD27_PIOCFG_FUNC_SEL_SHIFT)
#define  IO_PAD27_PIOCFG_FUNC_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD27_PIOCFG_FUNC_SEL_MASK) | (((uint32_t)val) << IO_PAD27_PIOCFG_FUNC_SEL_SHIFT))

//====================================================================
//
//Register File: IO_PAD28 Configuration Registers (IO_PAD28)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

//====================================================================
//Register: IO_PAD28 Configuration Register (PIOCFG)
/** \brief "PHI_PADXDC_HSIOB" Pad*/
//====================================================================

#define  IO_PAD28_PIOCFG_RESERVED1_MASK 0xfc000000
#define  IO_PAD28_PIOCFG_RESERVED1_SHIFT 26
#define  IO_PAD28_PIOCFG_RESERVED1_MASK_SHIFT(reg) (((reg) & IO_PAD28_PIOCFG_RESERVED1_MASK) >> IO_PAD28_PIOCFG_RESERVED1_SHIFT)
#define  IO_PAD28_PIOCFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD28_PIOCFG_RESERVED1_MASK) | (((uint32_t)val) << IO_PAD28_PIOCFG_RESERVED1_SHIFT))

#define  IO_PAD28_PIOCFG_PD_MASK 0x2000000
#define  IO_PAD28_PIOCFG_PD_SHIFT 25
#define  IO_PAD28_PIOCFG_PD_MASK_SHIFT(reg) (((reg) & IO_PAD28_PIOCFG_PD_MASK) >> IO_PAD28_PIOCFG_PD_SHIFT)
#define  IO_PAD28_PIOCFG_PD_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD28_PIOCFG_PD_MASK) | (((uint32_t)val) << IO_PAD28_PIOCFG_PD_SHIFT))

#define  IO_PAD28_PIOCFG_ODT_EN_MASK 0x1000000
#define  IO_PAD28_PIOCFG_ODT_EN_SHIFT 24
#define  IO_PAD28_PIOCFG_ODT_EN_MASK_SHIFT(reg) (((reg) & IO_PAD28_PIOCFG_ODT_EN_MASK) >> IO_PAD28_PIOCFG_ODT_EN_SHIFT)
#define  IO_PAD28_PIOCFG_ODT_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD28_PIOCFG_ODT_EN_MASK) | (((uint32_t)val) << IO_PAD28_PIOCFG_ODT_EN_SHIFT))

#define  IO_PAD28_PIOCFG_LED_EN_MASK 0x800000
#define  IO_PAD28_PIOCFG_LED_EN_SHIFT 23
#define  IO_PAD28_PIOCFG_LED_EN_MASK_SHIFT(reg) (((reg) & IO_PAD28_PIOCFG_LED_EN_MASK) >> IO_PAD28_PIOCFG_LED_EN_SHIFT)
#define  IO_PAD28_PIOCFG_LED_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD28_PIOCFG_LED_EN_MASK) | (((uint32_t)val) << IO_PAD28_PIOCFG_LED_EN_SHIFT))

#define  IO_PAD28_PIOCFG_I2C_SEL_MASK 0x600000
#define  IO_PAD28_PIOCFG_I2C_SEL_SHIFT 21
#define  IO_PAD28_PIOCFG_I2C_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD28_PIOCFG_I2C_SEL_MASK) >> IO_PAD28_PIOCFG_I2C_SEL_SHIFT)
#define  IO_PAD28_PIOCFG_I2C_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD28_PIOCFG_I2C_SEL_MASK) | (((uint32_t)val) << IO_PAD28_PIOCFG_I2C_SEL_SHIFT))

#define  IO_PAD28_PIOCFG_DGTBSEL_MASK 0x1e0000
#define  IO_PAD28_PIOCFG_DGTBSEL_SHIFT 17
#define  IO_PAD28_PIOCFG_DGTBSEL_MASK_SHIFT(reg) (((reg) & IO_PAD28_PIOCFG_DGTBSEL_MASK) >> IO_PAD28_PIOCFG_DGTBSEL_SHIFT)
#define  IO_PAD28_PIOCFG_DGTBSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD28_PIOCFG_DGTBSEL_MASK) | (((uint32_t)val) << IO_PAD28_PIOCFG_DGTBSEL_SHIFT))

#define  IO_PAD28_PIOCFG_RAWSEL_MASK 0x10000
#define  IO_PAD28_PIOCFG_RAWSEL_SHIFT 16
#define  IO_PAD28_PIOCFG_RAWSEL_MASK_SHIFT(reg) (((reg) & IO_PAD28_PIOCFG_RAWSEL_MASK) >> IO_PAD28_PIOCFG_RAWSEL_SHIFT)
#define  IO_PAD28_PIOCFG_RAWSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD28_PIOCFG_RAWSEL_MASK) | (((uint32_t)val) << IO_PAD28_PIOCFG_RAWSEL_SHIFT))

#define  IO_PAD28_PIOCFG_PULL_SEL_MASK 0x8000
#define  IO_PAD28_PIOCFG_PULL_SEL_SHIFT 15
#define  IO_PAD28_PIOCFG_PULL_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD28_PIOCFG_PULL_SEL_MASK) >> IO_PAD28_PIOCFG_PULL_SEL_SHIFT)
#define  IO_PAD28_PIOCFG_PULL_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD28_PIOCFG_PULL_SEL_MASK) | (((uint32_t)val) << IO_PAD28_PIOCFG_PULL_SEL_SHIFT))

#define  IO_PAD28_PIOCFG_PUEN_MASK 0x4000
#define  IO_PAD28_PIOCFG_PUEN_SHIFT 14
#define  IO_PAD28_PIOCFG_PUEN_MASK_SHIFT(reg) (((reg) & IO_PAD28_PIOCFG_PUEN_MASK) >> IO_PAD28_PIOCFG_PUEN_SHIFT)
#define  IO_PAD28_PIOCFG_PUEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD28_PIOCFG_PUEN_MASK) | (((uint32_t)val) << IO_PAD28_PIOCFG_PUEN_SHIFT))

#define  IO_PAD28_PIOCFG_PDEN_MASK 0x2000
#define  IO_PAD28_PIOCFG_PDEN_SHIFT 13
#define  IO_PAD28_PIOCFG_PDEN_MASK_SHIFT(reg) (((reg) & IO_PAD28_PIOCFG_PDEN_MASK) >> IO_PAD28_PIOCFG_PDEN_SHIFT)
#define  IO_PAD28_PIOCFG_PDEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD28_PIOCFG_PDEN_MASK) | (((uint32_t)val) << IO_PAD28_PIOCFG_PDEN_SHIFT))

#define  IO_PAD28_PIOCFG_SR_MASK 0x1800
#define  IO_PAD28_PIOCFG_SR_SHIFT 11
#define  IO_PAD28_PIOCFG_SR_MASK_SHIFT(reg) (((reg) & IO_PAD28_PIOCFG_SR_MASK) >> IO_PAD28_PIOCFG_SR_SHIFT)
#define  IO_PAD28_PIOCFG_SR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD28_PIOCFG_SR_MASK) | (((uint32_t)val) << IO_PAD28_PIOCFG_SR_SHIFT))

#define  IO_PAD28_PIOCFG_SLP_DI_MASK 0x400
#define  IO_PAD28_PIOCFG_SLP_DI_SHIFT 10
#define  IO_PAD28_PIOCFG_SLP_DI_MASK_SHIFT(reg) (((reg) & IO_PAD28_PIOCFG_SLP_DI_MASK) >> IO_PAD28_PIOCFG_SLP_DI_SHIFT)
#define  IO_PAD28_PIOCFG_SLP_DI_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD28_PIOCFG_SLP_DI_MASK) | (((uint32_t)val) << IO_PAD28_PIOCFG_SLP_DI_SHIFT))

#define  IO_PAD28_PIOCFG_SLP_CNTRL_MASK 0x200
#define  IO_PAD28_PIOCFG_SLP_CNTRL_SHIFT 9
#define  IO_PAD28_PIOCFG_SLP_CNTRL_MASK_SHIFT(reg) (((reg) & IO_PAD28_PIOCFG_SLP_CNTRL_MASK) >> IO_PAD28_PIOCFG_SLP_CNTRL_SHIFT)
#define  IO_PAD28_PIOCFG_SLP_CNTRL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD28_PIOCFG_SLP_CNTRL_MASK) | (((uint32_t)val) << IO_PAD28_PIOCFG_SLP_CNTRL_SHIFT))

#define  IO_PAD28_PIOCFG_SLP_DO_MASK 0x100
#define  IO_PAD28_PIOCFG_SLP_DO_SHIFT 8
#define  IO_PAD28_PIOCFG_SLP_DO_MASK_SHIFT(reg) (((reg) & IO_PAD28_PIOCFG_SLP_DO_MASK) >> IO_PAD28_PIOCFG_SLP_DO_SHIFT)
#define  IO_PAD28_PIOCFG_SLP_DO_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD28_PIOCFG_SLP_DO_MASK) | (((uint32_t)val) << IO_PAD28_PIOCFG_SLP_DO_SHIFT))

#define  IO_PAD28_PIOCFG_SLP_DIR_MASK 0x80
#define  IO_PAD28_PIOCFG_SLP_DIR_SHIFT 7
#define  IO_PAD28_PIOCFG_SLP_DIR_MASK_SHIFT(reg) (((reg) & IO_PAD28_PIOCFG_SLP_DIR_MASK) >> IO_PAD28_PIOCFG_SLP_DIR_SHIFT)
#define  IO_PAD28_PIOCFG_SLP_DIR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD28_PIOCFG_SLP_DIR_MASK) | (((uint32_t)val) << IO_PAD28_PIOCFG_SLP_DIR_SHIFT))

#define  IO_PAD28_PIOCFG_EDGE_EN_N_MASK 0x40
#define  IO_PAD28_PIOCFG_EDGE_EN_N_SHIFT 6
#define  IO_PAD28_PIOCFG_EDGE_EN_N_MASK_SHIFT(reg) (((reg) & IO_PAD28_PIOCFG_EDGE_EN_N_MASK) >> IO_PAD28_PIOCFG_EDGE_EN_N_SHIFT)
#define  IO_PAD28_PIOCFG_EDGE_EN_N_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD28_PIOCFG_EDGE_EN_N_MASK) | (((uint32_t)val) << IO_PAD28_PIOCFG_EDGE_EN_N_SHIFT))

#define  IO_PAD28_PIOCFG_EDGE_FALL_EN_MASK 0x20
#define  IO_PAD28_PIOCFG_EDGE_FALL_EN_SHIFT 5
#define  IO_PAD28_PIOCFG_EDGE_FALL_EN_MASK_SHIFT(reg) (((reg) & IO_PAD28_PIOCFG_EDGE_FALL_EN_MASK) >> IO_PAD28_PIOCFG_EDGE_FALL_EN_SHIFT)
#define  IO_PAD28_PIOCFG_EDGE_FALL_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD28_PIOCFG_EDGE_FALL_EN_MASK) | (((uint32_t)val) << IO_PAD28_PIOCFG_EDGE_FALL_EN_SHIFT))

#define  IO_PAD28_PIOCFG_EDGE_RISE_EN_MASK 0x10
#define  IO_PAD28_PIOCFG_EDGE_RISE_EN_SHIFT 4
#define  IO_PAD28_PIOCFG_EDGE_RISE_EN_MASK_SHIFT(reg) (((reg) & IO_PAD28_PIOCFG_EDGE_RISE_EN_MASK) >> IO_PAD28_PIOCFG_EDGE_RISE_EN_SHIFT)
#define  IO_PAD28_PIOCFG_EDGE_RISE_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD28_PIOCFG_EDGE_RISE_EN_MASK) | (((uint32_t)val) << IO_PAD28_PIOCFG_EDGE_RISE_EN_SHIFT))

#define  IO_PAD28_PIOCFG_SLP_SEL_MASK 0x8
#define  IO_PAD28_PIOCFG_SLP_SEL_SHIFT 3
#define  IO_PAD28_PIOCFG_SLP_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD28_PIOCFG_SLP_SEL_MASK) >> IO_PAD28_PIOCFG_SLP_SEL_SHIFT)
#define  IO_PAD28_PIOCFG_SLP_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD28_PIOCFG_SLP_SEL_MASK) | (((uint32_t)val) << IO_PAD28_PIOCFG_SLP_SEL_SHIFT))

#define  IO_PAD28_PIOCFG_FUNC_SEL_MASK 0x7
#define  IO_PAD28_PIOCFG_FUNC_SEL_SHIFT 0
#define  IO_PAD28_PIOCFG_FUNC_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD28_PIOCFG_FUNC_SEL_MASK) >> IO_PAD28_PIOCFG_FUNC_SEL_SHIFT)
#define  IO_PAD28_PIOCFG_FUNC_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD28_PIOCFG_FUNC_SEL_MASK) | (((uint32_t)val) << IO_PAD28_PIOCFG_FUNC_SEL_SHIFT))

//====================================================================
//
//Register File: IO_PAD29 Configuration Registers (IO_PAD29)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

//====================================================================
//Register: IO_PAD29 Configuration Register (PIOCFG)
/** \brief "PHI_PADXDC_HSIOB" Pad*/
//====================================================================

#define  IO_PAD29_PIOCFG_RESERVED1_MASK 0xfc000000
#define  IO_PAD29_PIOCFG_RESERVED1_SHIFT 26
#define  IO_PAD29_PIOCFG_RESERVED1_MASK_SHIFT(reg) (((reg) & IO_PAD29_PIOCFG_RESERVED1_MASK) >> IO_PAD29_PIOCFG_RESERVED1_SHIFT)
#define  IO_PAD29_PIOCFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD29_PIOCFG_RESERVED1_MASK) | (((uint32_t)val) << IO_PAD29_PIOCFG_RESERVED1_SHIFT))

#define  IO_PAD29_PIOCFG_PD_MASK 0x2000000
#define  IO_PAD29_PIOCFG_PD_SHIFT 25
#define  IO_PAD29_PIOCFG_PD_MASK_SHIFT(reg) (((reg) & IO_PAD29_PIOCFG_PD_MASK) >> IO_PAD29_PIOCFG_PD_SHIFT)
#define  IO_PAD29_PIOCFG_PD_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD29_PIOCFG_PD_MASK) | (((uint32_t)val) << IO_PAD29_PIOCFG_PD_SHIFT))

#define  IO_PAD29_PIOCFG_ODT_EN_MASK 0x1000000
#define  IO_PAD29_PIOCFG_ODT_EN_SHIFT 24
#define  IO_PAD29_PIOCFG_ODT_EN_MASK_SHIFT(reg) (((reg) & IO_PAD29_PIOCFG_ODT_EN_MASK) >> IO_PAD29_PIOCFG_ODT_EN_SHIFT)
#define  IO_PAD29_PIOCFG_ODT_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD29_PIOCFG_ODT_EN_MASK) | (((uint32_t)val) << IO_PAD29_PIOCFG_ODT_EN_SHIFT))

#define  IO_PAD29_PIOCFG_LED_EN_MASK 0x800000
#define  IO_PAD29_PIOCFG_LED_EN_SHIFT 23
#define  IO_PAD29_PIOCFG_LED_EN_MASK_SHIFT(reg) (((reg) & IO_PAD29_PIOCFG_LED_EN_MASK) >> IO_PAD29_PIOCFG_LED_EN_SHIFT)
#define  IO_PAD29_PIOCFG_LED_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD29_PIOCFG_LED_EN_MASK) | (((uint32_t)val) << IO_PAD29_PIOCFG_LED_EN_SHIFT))

#define  IO_PAD29_PIOCFG_I2C_SEL_MASK 0x600000
#define  IO_PAD29_PIOCFG_I2C_SEL_SHIFT 21
#define  IO_PAD29_PIOCFG_I2C_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD29_PIOCFG_I2C_SEL_MASK) >> IO_PAD29_PIOCFG_I2C_SEL_SHIFT)
#define  IO_PAD29_PIOCFG_I2C_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD29_PIOCFG_I2C_SEL_MASK) | (((uint32_t)val) << IO_PAD29_PIOCFG_I2C_SEL_SHIFT))

#define  IO_PAD29_PIOCFG_DGTBSEL_MASK 0x1e0000
#define  IO_PAD29_PIOCFG_DGTBSEL_SHIFT 17
#define  IO_PAD29_PIOCFG_DGTBSEL_MASK_SHIFT(reg) (((reg) & IO_PAD29_PIOCFG_DGTBSEL_MASK) >> IO_PAD29_PIOCFG_DGTBSEL_SHIFT)
#define  IO_PAD29_PIOCFG_DGTBSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD29_PIOCFG_DGTBSEL_MASK) | (((uint32_t)val) << IO_PAD29_PIOCFG_DGTBSEL_SHIFT))

#define  IO_PAD29_PIOCFG_RAWSEL_MASK 0x10000
#define  IO_PAD29_PIOCFG_RAWSEL_SHIFT 16
#define  IO_PAD29_PIOCFG_RAWSEL_MASK_SHIFT(reg) (((reg) & IO_PAD29_PIOCFG_RAWSEL_MASK) >> IO_PAD29_PIOCFG_RAWSEL_SHIFT)
#define  IO_PAD29_PIOCFG_RAWSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD29_PIOCFG_RAWSEL_MASK) | (((uint32_t)val) << IO_PAD29_PIOCFG_RAWSEL_SHIFT))

#define  IO_PAD29_PIOCFG_PULL_SEL_MASK 0x8000
#define  IO_PAD29_PIOCFG_PULL_SEL_SHIFT 15
#define  IO_PAD29_PIOCFG_PULL_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD29_PIOCFG_PULL_SEL_MASK) >> IO_PAD29_PIOCFG_PULL_SEL_SHIFT)
#define  IO_PAD29_PIOCFG_PULL_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD29_PIOCFG_PULL_SEL_MASK) | (((uint32_t)val) << IO_PAD29_PIOCFG_PULL_SEL_SHIFT))

#define  IO_PAD29_PIOCFG_PUEN_MASK 0x4000
#define  IO_PAD29_PIOCFG_PUEN_SHIFT 14
#define  IO_PAD29_PIOCFG_PUEN_MASK_SHIFT(reg) (((reg) & IO_PAD29_PIOCFG_PUEN_MASK) >> IO_PAD29_PIOCFG_PUEN_SHIFT)
#define  IO_PAD29_PIOCFG_PUEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD29_PIOCFG_PUEN_MASK) | (((uint32_t)val) << IO_PAD29_PIOCFG_PUEN_SHIFT))

#define  IO_PAD29_PIOCFG_PDEN_MASK 0x2000
#define  IO_PAD29_PIOCFG_PDEN_SHIFT 13
#define  IO_PAD29_PIOCFG_PDEN_MASK_SHIFT(reg) (((reg) & IO_PAD29_PIOCFG_PDEN_MASK) >> IO_PAD29_PIOCFG_PDEN_SHIFT)
#define  IO_PAD29_PIOCFG_PDEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD29_PIOCFG_PDEN_MASK) | (((uint32_t)val) << IO_PAD29_PIOCFG_PDEN_SHIFT))

#define  IO_PAD29_PIOCFG_SR_MASK 0x1800
#define  IO_PAD29_PIOCFG_SR_SHIFT 11
#define  IO_PAD29_PIOCFG_SR_MASK_SHIFT(reg) (((reg) & IO_PAD29_PIOCFG_SR_MASK) >> IO_PAD29_PIOCFG_SR_SHIFT)
#define  IO_PAD29_PIOCFG_SR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD29_PIOCFG_SR_MASK) | (((uint32_t)val) << IO_PAD29_PIOCFG_SR_SHIFT))

#define  IO_PAD29_PIOCFG_SLP_DI_MASK 0x400
#define  IO_PAD29_PIOCFG_SLP_DI_SHIFT 10
#define  IO_PAD29_PIOCFG_SLP_DI_MASK_SHIFT(reg) (((reg) & IO_PAD29_PIOCFG_SLP_DI_MASK) >> IO_PAD29_PIOCFG_SLP_DI_SHIFT)
#define  IO_PAD29_PIOCFG_SLP_DI_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD29_PIOCFG_SLP_DI_MASK) | (((uint32_t)val) << IO_PAD29_PIOCFG_SLP_DI_SHIFT))

#define  IO_PAD29_PIOCFG_SLP_CNTRL_MASK 0x200
#define  IO_PAD29_PIOCFG_SLP_CNTRL_SHIFT 9
#define  IO_PAD29_PIOCFG_SLP_CNTRL_MASK_SHIFT(reg) (((reg) & IO_PAD29_PIOCFG_SLP_CNTRL_MASK) >> IO_PAD29_PIOCFG_SLP_CNTRL_SHIFT)
#define  IO_PAD29_PIOCFG_SLP_CNTRL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD29_PIOCFG_SLP_CNTRL_MASK) | (((uint32_t)val) << IO_PAD29_PIOCFG_SLP_CNTRL_SHIFT))

#define  IO_PAD29_PIOCFG_SLP_DO_MASK 0x100
#define  IO_PAD29_PIOCFG_SLP_DO_SHIFT 8
#define  IO_PAD29_PIOCFG_SLP_DO_MASK_SHIFT(reg) (((reg) & IO_PAD29_PIOCFG_SLP_DO_MASK) >> IO_PAD29_PIOCFG_SLP_DO_SHIFT)
#define  IO_PAD29_PIOCFG_SLP_DO_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD29_PIOCFG_SLP_DO_MASK) | (((uint32_t)val) << IO_PAD29_PIOCFG_SLP_DO_SHIFT))

#define  IO_PAD29_PIOCFG_SLP_DIR_MASK 0x80
#define  IO_PAD29_PIOCFG_SLP_DIR_SHIFT 7
#define  IO_PAD29_PIOCFG_SLP_DIR_MASK_SHIFT(reg) (((reg) & IO_PAD29_PIOCFG_SLP_DIR_MASK) >> IO_PAD29_PIOCFG_SLP_DIR_SHIFT)
#define  IO_PAD29_PIOCFG_SLP_DIR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD29_PIOCFG_SLP_DIR_MASK) | (((uint32_t)val) << IO_PAD29_PIOCFG_SLP_DIR_SHIFT))

#define  IO_PAD29_PIOCFG_EDGE_EN_N_MASK 0x40
#define  IO_PAD29_PIOCFG_EDGE_EN_N_SHIFT 6
#define  IO_PAD29_PIOCFG_EDGE_EN_N_MASK_SHIFT(reg) (((reg) & IO_PAD29_PIOCFG_EDGE_EN_N_MASK) >> IO_PAD29_PIOCFG_EDGE_EN_N_SHIFT)
#define  IO_PAD29_PIOCFG_EDGE_EN_N_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD29_PIOCFG_EDGE_EN_N_MASK) | (((uint32_t)val) << IO_PAD29_PIOCFG_EDGE_EN_N_SHIFT))

#define  IO_PAD29_PIOCFG_EDGE_FALL_EN_MASK 0x20
#define  IO_PAD29_PIOCFG_EDGE_FALL_EN_SHIFT 5
#define  IO_PAD29_PIOCFG_EDGE_FALL_EN_MASK_SHIFT(reg) (((reg) & IO_PAD29_PIOCFG_EDGE_FALL_EN_MASK) >> IO_PAD29_PIOCFG_EDGE_FALL_EN_SHIFT)
#define  IO_PAD29_PIOCFG_EDGE_FALL_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD29_PIOCFG_EDGE_FALL_EN_MASK) | (((uint32_t)val) << IO_PAD29_PIOCFG_EDGE_FALL_EN_SHIFT))

#define  IO_PAD29_PIOCFG_EDGE_RISE_EN_MASK 0x10
#define  IO_PAD29_PIOCFG_EDGE_RISE_EN_SHIFT 4
#define  IO_PAD29_PIOCFG_EDGE_RISE_EN_MASK_SHIFT(reg) (((reg) & IO_PAD29_PIOCFG_EDGE_RISE_EN_MASK) >> IO_PAD29_PIOCFG_EDGE_RISE_EN_SHIFT)
#define  IO_PAD29_PIOCFG_EDGE_RISE_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD29_PIOCFG_EDGE_RISE_EN_MASK) | (((uint32_t)val) << IO_PAD29_PIOCFG_EDGE_RISE_EN_SHIFT))

#define  IO_PAD29_PIOCFG_SLP_SEL_MASK 0x8
#define  IO_PAD29_PIOCFG_SLP_SEL_SHIFT 3
#define  IO_PAD29_PIOCFG_SLP_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD29_PIOCFG_SLP_SEL_MASK) >> IO_PAD29_PIOCFG_SLP_SEL_SHIFT)
#define  IO_PAD29_PIOCFG_SLP_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD29_PIOCFG_SLP_SEL_MASK) | (((uint32_t)val) << IO_PAD29_PIOCFG_SLP_SEL_SHIFT))

#define  IO_PAD29_PIOCFG_FUNC_SEL_MASK 0x7
#define  IO_PAD29_PIOCFG_FUNC_SEL_SHIFT 0
#define  IO_PAD29_PIOCFG_FUNC_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD29_PIOCFG_FUNC_SEL_MASK) >> IO_PAD29_PIOCFG_FUNC_SEL_SHIFT)
#define  IO_PAD29_PIOCFG_FUNC_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD29_PIOCFG_FUNC_SEL_MASK) | (((uint32_t)val) << IO_PAD29_PIOCFG_FUNC_SEL_SHIFT))

//====================================================================
//
//Register File: IO_PAD30 Configuration Registers (IO_PAD30)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

//====================================================================
//Register: IO_PAD30 Configuration Register (PIOCFG)
/** \brief "PHI_PADXDC_HSIOB" Pad*/
//====================================================================

#define  IO_PAD30_PIOCFG_RESERVED1_MASK 0xfc000000
#define  IO_PAD30_PIOCFG_RESERVED1_SHIFT 26
#define  IO_PAD30_PIOCFG_RESERVED1_MASK_SHIFT(reg) (((reg) & IO_PAD30_PIOCFG_RESERVED1_MASK) >> IO_PAD30_PIOCFG_RESERVED1_SHIFT)
#define  IO_PAD30_PIOCFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD30_PIOCFG_RESERVED1_MASK) | (((uint32_t)val) << IO_PAD30_PIOCFG_RESERVED1_SHIFT))

#define  IO_PAD30_PIOCFG_PD_MASK 0x2000000
#define  IO_PAD30_PIOCFG_PD_SHIFT 25
#define  IO_PAD30_PIOCFG_PD_MASK_SHIFT(reg) (((reg) & IO_PAD30_PIOCFG_PD_MASK) >> IO_PAD30_PIOCFG_PD_SHIFT)
#define  IO_PAD30_PIOCFG_PD_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD30_PIOCFG_PD_MASK) | (((uint32_t)val) << IO_PAD30_PIOCFG_PD_SHIFT))

#define  IO_PAD30_PIOCFG_ODT_EN_MASK 0x1000000
#define  IO_PAD30_PIOCFG_ODT_EN_SHIFT 24
#define  IO_PAD30_PIOCFG_ODT_EN_MASK_SHIFT(reg) (((reg) & IO_PAD30_PIOCFG_ODT_EN_MASK) >> IO_PAD30_PIOCFG_ODT_EN_SHIFT)
#define  IO_PAD30_PIOCFG_ODT_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD30_PIOCFG_ODT_EN_MASK) | (((uint32_t)val) << IO_PAD30_PIOCFG_ODT_EN_SHIFT))

#define  IO_PAD30_PIOCFG_LED_EN_MASK 0x800000
#define  IO_PAD30_PIOCFG_LED_EN_SHIFT 23
#define  IO_PAD30_PIOCFG_LED_EN_MASK_SHIFT(reg) (((reg) & IO_PAD30_PIOCFG_LED_EN_MASK) >> IO_PAD30_PIOCFG_LED_EN_SHIFT)
#define  IO_PAD30_PIOCFG_LED_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD30_PIOCFG_LED_EN_MASK) | (((uint32_t)val) << IO_PAD30_PIOCFG_LED_EN_SHIFT))

#define  IO_PAD30_PIOCFG_I2C_SEL_MASK 0x600000
#define  IO_PAD30_PIOCFG_I2C_SEL_SHIFT 21
#define  IO_PAD30_PIOCFG_I2C_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD30_PIOCFG_I2C_SEL_MASK) >> IO_PAD30_PIOCFG_I2C_SEL_SHIFT)
#define  IO_PAD30_PIOCFG_I2C_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD30_PIOCFG_I2C_SEL_MASK) | (((uint32_t)val) << IO_PAD30_PIOCFG_I2C_SEL_SHIFT))

#define  IO_PAD30_PIOCFG_DGTBSEL_MASK 0x1e0000
#define  IO_PAD30_PIOCFG_DGTBSEL_SHIFT 17
#define  IO_PAD30_PIOCFG_DGTBSEL_MASK_SHIFT(reg) (((reg) & IO_PAD30_PIOCFG_DGTBSEL_MASK) >> IO_PAD30_PIOCFG_DGTBSEL_SHIFT)
#define  IO_PAD30_PIOCFG_DGTBSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD30_PIOCFG_DGTBSEL_MASK) | (((uint32_t)val) << IO_PAD30_PIOCFG_DGTBSEL_SHIFT))

#define  IO_PAD30_PIOCFG_RAWSEL_MASK 0x10000
#define  IO_PAD30_PIOCFG_RAWSEL_SHIFT 16
#define  IO_PAD30_PIOCFG_RAWSEL_MASK_SHIFT(reg) (((reg) & IO_PAD30_PIOCFG_RAWSEL_MASK) >> IO_PAD30_PIOCFG_RAWSEL_SHIFT)
#define  IO_PAD30_PIOCFG_RAWSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD30_PIOCFG_RAWSEL_MASK) | (((uint32_t)val) << IO_PAD30_PIOCFG_RAWSEL_SHIFT))

#define  IO_PAD30_PIOCFG_PULL_SEL_MASK 0x8000
#define  IO_PAD30_PIOCFG_PULL_SEL_SHIFT 15
#define  IO_PAD30_PIOCFG_PULL_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD30_PIOCFG_PULL_SEL_MASK) >> IO_PAD30_PIOCFG_PULL_SEL_SHIFT)
#define  IO_PAD30_PIOCFG_PULL_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD30_PIOCFG_PULL_SEL_MASK) | (((uint32_t)val) << IO_PAD30_PIOCFG_PULL_SEL_SHIFT))

#define  IO_PAD30_PIOCFG_PUEN_MASK 0x4000
#define  IO_PAD30_PIOCFG_PUEN_SHIFT 14
#define  IO_PAD30_PIOCFG_PUEN_MASK_SHIFT(reg) (((reg) & IO_PAD30_PIOCFG_PUEN_MASK) >> IO_PAD30_PIOCFG_PUEN_SHIFT)
#define  IO_PAD30_PIOCFG_PUEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD30_PIOCFG_PUEN_MASK) | (((uint32_t)val) << IO_PAD30_PIOCFG_PUEN_SHIFT))

#define  IO_PAD30_PIOCFG_PDEN_MASK 0x2000
#define  IO_PAD30_PIOCFG_PDEN_SHIFT 13
#define  IO_PAD30_PIOCFG_PDEN_MASK_SHIFT(reg) (((reg) & IO_PAD30_PIOCFG_PDEN_MASK) >> IO_PAD30_PIOCFG_PDEN_SHIFT)
#define  IO_PAD30_PIOCFG_PDEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD30_PIOCFG_PDEN_MASK) | (((uint32_t)val) << IO_PAD30_PIOCFG_PDEN_SHIFT))

#define  IO_PAD30_PIOCFG_SR_MASK 0x1800
#define  IO_PAD30_PIOCFG_SR_SHIFT 11
#define  IO_PAD30_PIOCFG_SR_MASK_SHIFT(reg) (((reg) & IO_PAD30_PIOCFG_SR_MASK) >> IO_PAD30_PIOCFG_SR_SHIFT)
#define  IO_PAD30_PIOCFG_SR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD30_PIOCFG_SR_MASK) | (((uint32_t)val) << IO_PAD30_PIOCFG_SR_SHIFT))

#define  IO_PAD30_PIOCFG_SLP_DI_MASK 0x400
#define  IO_PAD30_PIOCFG_SLP_DI_SHIFT 10
#define  IO_PAD30_PIOCFG_SLP_DI_MASK_SHIFT(reg) (((reg) & IO_PAD30_PIOCFG_SLP_DI_MASK) >> IO_PAD30_PIOCFG_SLP_DI_SHIFT)
#define  IO_PAD30_PIOCFG_SLP_DI_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD30_PIOCFG_SLP_DI_MASK) | (((uint32_t)val) << IO_PAD30_PIOCFG_SLP_DI_SHIFT))

#define  IO_PAD30_PIOCFG_SLP_CNTRL_MASK 0x200
#define  IO_PAD30_PIOCFG_SLP_CNTRL_SHIFT 9
#define  IO_PAD30_PIOCFG_SLP_CNTRL_MASK_SHIFT(reg) (((reg) & IO_PAD30_PIOCFG_SLP_CNTRL_MASK) >> IO_PAD30_PIOCFG_SLP_CNTRL_SHIFT)
#define  IO_PAD30_PIOCFG_SLP_CNTRL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD30_PIOCFG_SLP_CNTRL_MASK) | (((uint32_t)val) << IO_PAD30_PIOCFG_SLP_CNTRL_SHIFT))

#define  IO_PAD30_PIOCFG_SLP_DO_MASK 0x100
#define  IO_PAD30_PIOCFG_SLP_DO_SHIFT 8
#define  IO_PAD30_PIOCFG_SLP_DO_MASK_SHIFT(reg) (((reg) & IO_PAD30_PIOCFG_SLP_DO_MASK) >> IO_PAD30_PIOCFG_SLP_DO_SHIFT)
#define  IO_PAD30_PIOCFG_SLP_DO_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD30_PIOCFG_SLP_DO_MASK) | (((uint32_t)val) << IO_PAD30_PIOCFG_SLP_DO_SHIFT))

#define  IO_PAD30_PIOCFG_SLP_DIR_MASK 0x80
#define  IO_PAD30_PIOCFG_SLP_DIR_SHIFT 7
#define  IO_PAD30_PIOCFG_SLP_DIR_MASK_SHIFT(reg) (((reg) & IO_PAD30_PIOCFG_SLP_DIR_MASK) >> IO_PAD30_PIOCFG_SLP_DIR_SHIFT)
#define  IO_PAD30_PIOCFG_SLP_DIR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD30_PIOCFG_SLP_DIR_MASK) | (((uint32_t)val) << IO_PAD30_PIOCFG_SLP_DIR_SHIFT))

#define  IO_PAD30_PIOCFG_EDGE_EN_N_MASK 0x40
#define  IO_PAD30_PIOCFG_EDGE_EN_N_SHIFT 6
#define  IO_PAD30_PIOCFG_EDGE_EN_N_MASK_SHIFT(reg) (((reg) & IO_PAD30_PIOCFG_EDGE_EN_N_MASK) >> IO_PAD30_PIOCFG_EDGE_EN_N_SHIFT)
#define  IO_PAD30_PIOCFG_EDGE_EN_N_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD30_PIOCFG_EDGE_EN_N_MASK) | (((uint32_t)val) << IO_PAD30_PIOCFG_EDGE_EN_N_SHIFT))

#define  IO_PAD30_PIOCFG_EDGE_FALL_EN_MASK 0x20
#define  IO_PAD30_PIOCFG_EDGE_FALL_EN_SHIFT 5
#define  IO_PAD30_PIOCFG_EDGE_FALL_EN_MASK_SHIFT(reg) (((reg) & IO_PAD30_PIOCFG_EDGE_FALL_EN_MASK) >> IO_PAD30_PIOCFG_EDGE_FALL_EN_SHIFT)
#define  IO_PAD30_PIOCFG_EDGE_FALL_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD30_PIOCFG_EDGE_FALL_EN_MASK) | (((uint32_t)val) << IO_PAD30_PIOCFG_EDGE_FALL_EN_SHIFT))

#define  IO_PAD30_PIOCFG_EDGE_RISE_EN_MASK 0x10
#define  IO_PAD30_PIOCFG_EDGE_RISE_EN_SHIFT 4
#define  IO_PAD30_PIOCFG_EDGE_RISE_EN_MASK_SHIFT(reg) (((reg) & IO_PAD30_PIOCFG_EDGE_RISE_EN_MASK) >> IO_PAD30_PIOCFG_EDGE_RISE_EN_SHIFT)
#define  IO_PAD30_PIOCFG_EDGE_RISE_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD30_PIOCFG_EDGE_RISE_EN_MASK) | (((uint32_t)val) << IO_PAD30_PIOCFG_EDGE_RISE_EN_SHIFT))

#define  IO_PAD30_PIOCFG_SLP_SEL_MASK 0x8
#define  IO_PAD30_PIOCFG_SLP_SEL_SHIFT 3
#define  IO_PAD30_PIOCFG_SLP_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD30_PIOCFG_SLP_SEL_MASK) >> IO_PAD30_PIOCFG_SLP_SEL_SHIFT)
#define  IO_PAD30_PIOCFG_SLP_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD30_PIOCFG_SLP_SEL_MASK) | (((uint32_t)val) << IO_PAD30_PIOCFG_SLP_SEL_SHIFT))

#define  IO_PAD30_PIOCFG_FUNC_SEL_MASK 0x7
#define  IO_PAD30_PIOCFG_FUNC_SEL_SHIFT 0
#define  IO_PAD30_PIOCFG_FUNC_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD30_PIOCFG_FUNC_SEL_MASK) >> IO_PAD30_PIOCFG_FUNC_SEL_SHIFT)
#define  IO_PAD30_PIOCFG_FUNC_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD30_PIOCFG_FUNC_SEL_MASK) | (((uint32_t)val) << IO_PAD30_PIOCFG_FUNC_SEL_SHIFT))

//====================================================================
//
//Register File: IO_PAD31 Configuration Registers (IO_PAD31)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

//====================================================================
//Register: IO_PAD31 Configuration Register (PIOCFG)
/** \brief "PHI_PADXDC_HSIOB" Pad*/
//====================================================================

#define  IO_PAD31_PIOCFG_RESERVED1_MASK 0xfc000000
#define  IO_PAD31_PIOCFG_RESERVED1_SHIFT 26
#define  IO_PAD31_PIOCFG_RESERVED1_MASK_SHIFT(reg) (((reg) & IO_PAD31_PIOCFG_RESERVED1_MASK) >> IO_PAD31_PIOCFG_RESERVED1_SHIFT)
#define  IO_PAD31_PIOCFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD31_PIOCFG_RESERVED1_MASK) | (((uint32_t)val) << IO_PAD31_PIOCFG_RESERVED1_SHIFT))

#define  IO_PAD31_PIOCFG_PD_MASK 0x2000000
#define  IO_PAD31_PIOCFG_PD_SHIFT 25
#define  IO_PAD31_PIOCFG_PD_MASK_SHIFT(reg) (((reg) & IO_PAD31_PIOCFG_PD_MASK) >> IO_PAD31_PIOCFG_PD_SHIFT)
#define  IO_PAD31_PIOCFG_PD_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD31_PIOCFG_PD_MASK) | (((uint32_t)val) << IO_PAD31_PIOCFG_PD_SHIFT))

#define  IO_PAD31_PIOCFG_ODT_EN_MASK 0x1000000
#define  IO_PAD31_PIOCFG_ODT_EN_SHIFT 24
#define  IO_PAD31_PIOCFG_ODT_EN_MASK_SHIFT(reg) (((reg) & IO_PAD31_PIOCFG_ODT_EN_MASK) >> IO_PAD31_PIOCFG_ODT_EN_SHIFT)
#define  IO_PAD31_PIOCFG_ODT_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD31_PIOCFG_ODT_EN_MASK) | (((uint32_t)val) << IO_PAD31_PIOCFG_ODT_EN_SHIFT))

#define  IO_PAD31_PIOCFG_LED_EN_MASK 0x800000
#define  IO_PAD31_PIOCFG_LED_EN_SHIFT 23
#define  IO_PAD31_PIOCFG_LED_EN_MASK_SHIFT(reg) (((reg) & IO_PAD31_PIOCFG_LED_EN_MASK) >> IO_PAD31_PIOCFG_LED_EN_SHIFT)
#define  IO_PAD31_PIOCFG_LED_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD31_PIOCFG_LED_EN_MASK) | (((uint32_t)val) << IO_PAD31_PIOCFG_LED_EN_SHIFT))

#define  IO_PAD31_PIOCFG_I2C_SEL_MASK 0x600000
#define  IO_PAD31_PIOCFG_I2C_SEL_SHIFT 21
#define  IO_PAD31_PIOCFG_I2C_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD31_PIOCFG_I2C_SEL_MASK) >> IO_PAD31_PIOCFG_I2C_SEL_SHIFT)
#define  IO_PAD31_PIOCFG_I2C_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD31_PIOCFG_I2C_SEL_MASK) | (((uint32_t)val) << IO_PAD31_PIOCFG_I2C_SEL_SHIFT))

#define  IO_PAD31_PIOCFG_DGTBSEL_MASK 0x1e0000
#define  IO_PAD31_PIOCFG_DGTBSEL_SHIFT 17
#define  IO_PAD31_PIOCFG_DGTBSEL_MASK_SHIFT(reg) (((reg) & IO_PAD31_PIOCFG_DGTBSEL_MASK) >> IO_PAD31_PIOCFG_DGTBSEL_SHIFT)
#define  IO_PAD31_PIOCFG_DGTBSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD31_PIOCFG_DGTBSEL_MASK) | (((uint32_t)val) << IO_PAD31_PIOCFG_DGTBSEL_SHIFT))

#define  IO_PAD31_PIOCFG_RAWSEL_MASK 0x10000
#define  IO_PAD31_PIOCFG_RAWSEL_SHIFT 16
#define  IO_PAD31_PIOCFG_RAWSEL_MASK_SHIFT(reg) (((reg) & IO_PAD31_PIOCFG_RAWSEL_MASK) >> IO_PAD31_PIOCFG_RAWSEL_SHIFT)
#define  IO_PAD31_PIOCFG_RAWSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD31_PIOCFG_RAWSEL_MASK) | (((uint32_t)val) << IO_PAD31_PIOCFG_RAWSEL_SHIFT))

#define  IO_PAD31_PIOCFG_PULL_SEL_MASK 0x8000
#define  IO_PAD31_PIOCFG_PULL_SEL_SHIFT 15
#define  IO_PAD31_PIOCFG_PULL_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD31_PIOCFG_PULL_SEL_MASK) >> IO_PAD31_PIOCFG_PULL_SEL_SHIFT)
#define  IO_PAD31_PIOCFG_PULL_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD31_PIOCFG_PULL_SEL_MASK) | (((uint32_t)val) << IO_PAD31_PIOCFG_PULL_SEL_SHIFT))

#define  IO_PAD31_PIOCFG_PUEN_MASK 0x4000
#define  IO_PAD31_PIOCFG_PUEN_SHIFT 14
#define  IO_PAD31_PIOCFG_PUEN_MASK_SHIFT(reg) (((reg) & IO_PAD31_PIOCFG_PUEN_MASK) >> IO_PAD31_PIOCFG_PUEN_SHIFT)
#define  IO_PAD31_PIOCFG_PUEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD31_PIOCFG_PUEN_MASK) | (((uint32_t)val) << IO_PAD31_PIOCFG_PUEN_SHIFT))

#define  IO_PAD31_PIOCFG_PDEN_MASK 0x2000
#define  IO_PAD31_PIOCFG_PDEN_SHIFT 13
#define  IO_PAD31_PIOCFG_PDEN_MASK_SHIFT(reg) (((reg) & IO_PAD31_PIOCFG_PDEN_MASK) >> IO_PAD31_PIOCFG_PDEN_SHIFT)
#define  IO_PAD31_PIOCFG_PDEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD31_PIOCFG_PDEN_MASK) | (((uint32_t)val) << IO_PAD31_PIOCFG_PDEN_SHIFT))

#define  IO_PAD31_PIOCFG_SR_MASK 0x1800
#define  IO_PAD31_PIOCFG_SR_SHIFT 11
#define  IO_PAD31_PIOCFG_SR_MASK_SHIFT(reg) (((reg) & IO_PAD31_PIOCFG_SR_MASK) >> IO_PAD31_PIOCFG_SR_SHIFT)
#define  IO_PAD31_PIOCFG_SR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD31_PIOCFG_SR_MASK) | (((uint32_t)val) << IO_PAD31_PIOCFG_SR_SHIFT))

#define  IO_PAD31_PIOCFG_SLP_DI_MASK 0x400
#define  IO_PAD31_PIOCFG_SLP_DI_SHIFT 10
#define  IO_PAD31_PIOCFG_SLP_DI_MASK_SHIFT(reg) (((reg) & IO_PAD31_PIOCFG_SLP_DI_MASK) >> IO_PAD31_PIOCFG_SLP_DI_SHIFT)
#define  IO_PAD31_PIOCFG_SLP_DI_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD31_PIOCFG_SLP_DI_MASK) | (((uint32_t)val) << IO_PAD31_PIOCFG_SLP_DI_SHIFT))

#define  IO_PAD31_PIOCFG_SLP_CNTRL_MASK 0x200
#define  IO_PAD31_PIOCFG_SLP_CNTRL_SHIFT 9
#define  IO_PAD31_PIOCFG_SLP_CNTRL_MASK_SHIFT(reg) (((reg) & IO_PAD31_PIOCFG_SLP_CNTRL_MASK) >> IO_PAD31_PIOCFG_SLP_CNTRL_SHIFT)
#define  IO_PAD31_PIOCFG_SLP_CNTRL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD31_PIOCFG_SLP_CNTRL_MASK) | (((uint32_t)val) << IO_PAD31_PIOCFG_SLP_CNTRL_SHIFT))

#define  IO_PAD31_PIOCFG_SLP_DO_MASK 0x100
#define  IO_PAD31_PIOCFG_SLP_DO_SHIFT 8
#define  IO_PAD31_PIOCFG_SLP_DO_MASK_SHIFT(reg) (((reg) & IO_PAD31_PIOCFG_SLP_DO_MASK) >> IO_PAD31_PIOCFG_SLP_DO_SHIFT)
#define  IO_PAD31_PIOCFG_SLP_DO_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD31_PIOCFG_SLP_DO_MASK) | (((uint32_t)val) << IO_PAD31_PIOCFG_SLP_DO_SHIFT))

#define  IO_PAD31_PIOCFG_SLP_DIR_MASK 0x80
#define  IO_PAD31_PIOCFG_SLP_DIR_SHIFT 7
#define  IO_PAD31_PIOCFG_SLP_DIR_MASK_SHIFT(reg) (((reg) & IO_PAD31_PIOCFG_SLP_DIR_MASK) >> IO_PAD31_PIOCFG_SLP_DIR_SHIFT)
#define  IO_PAD31_PIOCFG_SLP_DIR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD31_PIOCFG_SLP_DIR_MASK) | (((uint32_t)val) << IO_PAD31_PIOCFG_SLP_DIR_SHIFT))

#define  IO_PAD31_PIOCFG_EDGE_EN_N_MASK 0x40
#define  IO_PAD31_PIOCFG_EDGE_EN_N_SHIFT 6
#define  IO_PAD31_PIOCFG_EDGE_EN_N_MASK_SHIFT(reg) (((reg) & IO_PAD31_PIOCFG_EDGE_EN_N_MASK) >> IO_PAD31_PIOCFG_EDGE_EN_N_SHIFT)
#define  IO_PAD31_PIOCFG_EDGE_EN_N_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD31_PIOCFG_EDGE_EN_N_MASK) | (((uint32_t)val) << IO_PAD31_PIOCFG_EDGE_EN_N_SHIFT))

#define  IO_PAD31_PIOCFG_EDGE_FALL_EN_MASK 0x20
#define  IO_PAD31_PIOCFG_EDGE_FALL_EN_SHIFT 5
#define  IO_PAD31_PIOCFG_EDGE_FALL_EN_MASK_SHIFT(reg) (((reg) & IO_PAD31_PIOCFG_EDGE_FALL_EN_MASK) >> IO_PAD31_PIOCFG_EDGE_FALL_EN_SHIFT)
#define  IO_PAD31_PIOCFG_EDGE_FALL_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD31_PIOCFG_EDGE_FALL_EN_MASK) | (((uint32_t)val) << IO_PAD31_PIOCFG_EDGE_FALL_EN_SHIFT))

#define  IO_PAD31_PIOCFG_EDGE_RISE_EN_MASK 0x10
#define  IO_PAD31_PIOCFG_EDGE_RISE_EN_SHIFT 4
#define  IO_PAD31_PIOCFG_EDGE_RISE_EN_MASK_SHIFT(reg) (((reg) & IO_PAD31_PIOCFG_EDGE_RISE_EN_MASK) >> IO_PAD31_PIOCFG_EDGE_RISE_EN_SHIFT)
#define  IO_PAD31_PIOCFG_EDGE_RISE_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD31_PIOCFG_EDGE_RISE_EN_MASK) | (((uint32_t)val) << IO_PAD31_PIOCFG_EDGE_RISE_EN_SHIFT))

#define  IO_PAD31_PIOCFG_SLP_SEL_MASK 0x8
#define  IO_PAD31_PIOCFG_SLP_SEL_SHIFT 3
#define  IO_PAD31_PIOCFG_SLP_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD31_PIOCFG_SLP_SEL_MASK) >> IO_PAD31_PIOCFG_SLP_SEL_SHIFT)
#define  IO_PAD31_PIOCFG_SLP_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD31_PIOCFG_SLP_SEL_MASK) | (((uint32_t)val) << IO_PAD31_PIOCFG_SLP_SEL_SHIFT))

#define  IO_PAD31_PIOCFG_FUNC_SEL_MASK 0x7
#define  IO_PAD31_PIOCFG_FUNC_SEL_SHIFT 0
#define  IO_PAD31_PIOCFG_FUNC_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD31_PIOCFG_FUNC_SEL_MASK) >> IO_PAD31_PIOCFG_FUNC_SEL_SHIFT)
#define  IO_PAD31_PIOCFG_FUNC_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD31_PIOCFG_FUNC_SEL_MASK) | (((uint32_t)val) << IO_PAD31_PIOCFG_FUNC_SEL_SHIFT))

//====================================================================
//
//Register File: IO_PAD32 Configuration Registers (IO_PAD32)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

//====================================================================
//Register: IO_PAD32 Configuration Register (PIOCFG)
/** \brief "PHI_PADXDC_HSIOB" Pad*/
//====================================================================

#define  IO_PAD32_PIOCFG_RESERVED1_MASK 0xfc000000
#define  IO_PAD32_PIOCFG_RESERVED1_SHIFT 26
#define  IO_PAD32_PIOCFG_RESERVED1_MASK_SHIFT(reg) (((reg) & IO_PAD32_PIOCFG_RESERVED1_MASK) >> IO_PAD32_PIOCFG_RESERVED1_SHIFT)
#define  IO_PAD32_PIOCFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD32_PIOCFG_RESERVED1_MASK) | (((uint32_t)val) << IO_PAD32_PIOCFG_RESERVED1_SHIFT))

#define  IO_PAD32_PIOCFG_PD_MASK 0x2000000
#define  IO_PAD32_PIOCFG_PD_SHIFT 25
#define  IO_PAD32_PIOCFG_PD_MASK_SHIFT(reg) (((reg) & IO_PAD32_PIOCFG_PD_MASK) >> IO_PAD32_PIOCFG_PD_SHIFT)
#define  IO_PAD32_PIOCFG_PD_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD32_PIOCFG_PD_MASK) | (((uint32_t)val) << IO_PAD32_PIOCFG_PD_SHIFT))

#define  IO_PAD32_PIOCFG_ODT_EN_MASK 0x1000000
#define  IO_PAD32_PIOCFG_ODT_EN_SHIFT 24
#define  IO_PAD32_PIOCFG_ODT_EN_MASK_SHIFT(reg) (((reg) & IO_PAD32_PIOCFG_ODT_EN_MASK) >> IO_PAD32_PIOCFG_ODT_EN_SHIFT)
#define  IO_PAD32_PIOCFG_ODT_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD32_PIOCFG_ODT_EN_MASK) | (((uint32_t)val) << IO_PAD32_PIOCFG_ODT_EN_SHIFT))

#define  IO_PAD32_PIOCFG_LED_EN_MASK 0x800000
#define  IO_PAD32_PIOCFG_LED_EN_SHIFT 23
#define  IO_PAD32_PIOCFG_LED_EN_MASK_SHIFT(reg) (((reg) & IO_PAD32_PIOCFG_LED_EN_MASK) >> IO_PAD32_PIOCFG_LED_EN_SHIFT)
#define  IO_PAD32_PIOCFG_LED_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD32_PIOCFG_LED_EN_MASK) | (((uint32_t)val) << IO_PAD32_PIOCFG_LED_EN_SHIFT))

#define  IO_PAD32_PIOCFG_I2C_SEL_MASK 0x600000
#define  IO_PAD32_PIOCFG_I2C_SEL_SHIFT 21
#define  IO_PAD32_PIOCFG_I2C_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD32_PIOCFG_I2C_SEL_MASK) >> IO_PAD32_PIOCFG_I2C_SEL_SHIFT)
#define  IO_PAD32_PIOCFG_I2C_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD32_PIOCFG_I2C_SEL_MASK) | (((uint32_t)val) << IO_PAD32_PIOCFG_I2C_SEL_SHIFT))

#define  IO_PAD32_PIOCFG_DGTBSEL_MASK 0x1e0000
#define  IO_PAD32_PIOCFG_DGTBSEL_SHIFT 17
#define  IO_PAD32_PIOCFG_DGTBSEL_MASK_SHIFT(reg) (((reg) & IO_PAD32_PIOCFG_DGTBSEL_MASK) >> IO_PAD32_PIOCFG_DGTBSEL_SHIFT)
#define  IO_PAD32_PIOCFG_DGTBSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD32_PIOCFG_DGTBSEL_MASK) | (((uint32_t)val) << IO_PAD32_PIOCFG_DGTBSEL_SHIFT))

#define  IO_PAD32_PIOCFG_RAWSEL_MASK 0x10000
#define  IO_PAD32_PIOCFG_RAWSEL_SHIFT 16
#define  IO_PAD32_PIOCFG_RAWSEL_MASK_SHIFT(reg) (((reg) & IO_PAD32_PIOCFG_RAWSEL_MASK) >> IO_PAD32_PIOCFG_RAWSEL_SHIFT)
#define  IO_PAD32_PIOCFG_RAWSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD32_PIOCFG_RAWSEL_MASK) | (((uint32_t)val) << IO_PAD32_PIOCFG_RAWSEL_SHIFT))

#define  IO_PAD32_PIOCFG_PULL_SEL_MASK 0x8000
#define  IO_PAD32_PIOCFG_PULL_SEL_SHIFT 15
#define  IO_PAD32_PIOCFG_PULL_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD32_PIOCFG_PULL_SEL_MASK) >> IO_PAD32_PIOCFG_PULL_SEL_SHIFT)
#define  IO_PAD32_PIOCFG_PULL_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD32_PIOCFG_PULL_SEL_MASK) | (((uint32_t)val) << IO_PAD32_PIOCFG_PULL_SEL_SHIFT))

#define  IO_PAD32_PIOCFG_PUEN_MASK 0x4000
#define  IO_PAD32_PIOCFG_PUEN_SHIFT 14
#define  IO_PAD32_PIOCFG_PUEN_MASK_SHIFT(reg) (((reg) & IO_PAD32_PIOCFG_PUEN_MASK) >> IO_PAD32_PIOCFG_PUEN_SHIFT)
#define  IO_PAD32_PIOCFG_PUEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD32_PIOCFG_PUEN_MASK) | (((uint32_t)val) << IO_PAD32_PIOCFG_PUEN_SHIFT))

#define  IO_PAD32_PIOCFG_PDEN_MASK 0x2000
#define  IO_PAD32_PIOCFG_PDEN_SHIFT 13
#define  IO_PAD32_PIOCFG_PDEN_MASK_SHIFT(reg) (((reg) & IO_PAD32_PIOCFG_PDEN_MASK) >> IO_PAD32_PIOCFG_PDEN_SHIFT)
#define  IO_PAD32_PIOCFG_PDEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD32_PIOCFG_PDEN_MASK) | (((uint32_t)val) << IO_PAD32_PIOCFG_PDEN_SHIFT))

#define  IO_PAD32_PIOCFG_SR_MASK 0x1800
#define  IO_PAD32_PIOCFG_SR_SHIFT 11
#define  IO_PAD32_PIOCFG_SR_MASK_SHIFT(reg) (((reg) & IO_PAD32_PIOCFG_SR_MASK) >> IO_PAD32_PIOCFG_SR_SHIFT)
#define  IO_PAD32_PIOCFG_SR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD32_PIOCFG_SR_MASK) | (((uint32_t)val) << IO_PAD32_PIOCFG_SR_SHIFT))

#define  IO_PAD32_PIOCFG_SLP_DI_MASK 0x400
#define  IO_PAD32_PIOCFG_SLP_DI_SHIFT 10
#define  IO_PAD32_PIOCFG_SLP_DI_MASK_SHIFT(reg) (((reg) & IO_PAD32_PIOCFG_SLP_DI_MASK) >> IO_PAD32_PIOCFG_SLP_DI_SHIFT)
#define  IO_PAD32_PIOCFG_SLP_DI_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD32_PIOCFG_SLP_DI_MASK) | (((uint32_t)val) << IO_PAD32_PIOCFG_SLP_DI_SHIFT))

#define  IO_PAD32_PIOCFG_SLP_CNTRL_MASK 0x200
#define  IO_PAD32_PIOCFG_SLP_CNTRL_SHIFT 9
#define  IO_PAD32_PIOCFG_SLP_CNTRL_MASK_SHIFT(reg) (((reg) & IO_PAD32_PIOCFG_SLP_CNTRL_MASK) >> IO_PAD32_PIOCFG_SLP_CNTRL_SHIFT)
#define  IO_PAD32_PIOCFG_SLP_CNTRL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD32_PIOCFG_SLP_CNTRL_MASK) | (((uint32_t)val) << IO_PAD32_PIOCFG_SLP_CNTRL_SHIFT))

#define  IO_PAD32_PIOCFG_SLP_DO_MASK 0x100
#define  IO_PAD32_PIOCFG_SLP_DO_SHIFT 8
#define  IO_PAD32_PIOCFG_SLP_DO_MASK_SHIFT(reg) (((reg) & IO_PAD32_PIOCFG_SLP_DO_MASK) >> IO_PAD32_PIOCFG_SLP_DO_SHIFT)
#define  IO_PAD32_PIOCFG_SLP_DO_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD32_PIOCFG_SLP_DO_MASK) | (((uint32_t)val) << IO_PAD32_PIOCFG_SLP_DO_SHIFT))

#define  IO_PAD32_PIOCFG_SLP_DIR_MASK 0x80
#define  IO_PAD32_PIOCFG_SLP_DIR_SHIFT 7
#define  IO_PAD32_PIOCFG_SLP_DIR_MASK_SHIFT(reg) (((reg) & IO_PAD32_PIOCFG_SLP_DIR_MASK) >> IO_PAD32_PIOCFG_SLP_DIR_SHIFT)
#define  IO_PAD32_PIOCFG_SLP_DIR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD32_PIOCFG_SLP_DIR_MASK) | (((uint32_t)val) << IO_PAD32_PIOCFG_SLP_DIR_SHIFT))

#define  IO_PAD32_PIOCFG_EDGE_EN_N_MASK 0x40
#define  IO_PAD32_PIOCFG_EDGE_EN_N_SHIFT 6
#define  IO_PAD32_PIOCFG_EDGE_EN_N_MASK_SHIFT(reg) (((reg) & IO_PAD32_PIOCFG_EDGE_EN_N_MASK) >> IO_PAD32_PIOCFG_EDGE_EN_N_SHIFT)
#define  IO_PAD32_PIOCFG_EDGE_EN_N_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD32_PIOCFG_EDGE_EN_N_MASK) | (((uint32_t)val) << IO_PAD32_PIOCFG_EDGE_EN_N_SHIFT))

#define  IO_PAD32_PIOCFG_EDGE_FALL_EN_MASK 0x20
#define  IO_PAD32_PIOCFG_EDGE_FALL_EN_SHIFT 5
#define  IO_PAD32_PIOCFG_EDGE_FALL_EN_MASK_SHIFT(reg) (((reg) & IO_PAD32_PIOCFG_EDGE_FALL_EN_MASK) >> IO_PAD32_PIOCFG_EDGE_FALL_EN_SHIFT)
#define  IO_PAD32_PIOCFG_EDGE_FALL_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD32_PIOCFG_EDGE_FALL_EN_MASK) | (((uint32_t)val) << IO_PAD32_PIOCFG_EDGE_FALL_EN_SHIFT))

#define  IO_PAD32_PIOCFG_EDGE_RISE_EN_MASK 0x10
#define  IO_PAD32_PIOCFG_EDGE_RISE_EN_SHIFT 4
#define  IO_PAD32_PIOCFG_EDGE_RISE_EN_MASK_SHIFT(reg) (((reg) & IO_PAD32_PIOCFG_EDGE_RISE_EN_MASK) >> IO_PAD32_PIOCFG_EDGE_RISE_EN_SHIFT)
#define  IO_PAD32_PIOCFG_EDGE_RISE_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD32_PIOCFG_EDGE_RISE_EN_MASK) | (((uint32_t)val) << IO_PAD32_PIOCFG_EDGE_RISE_EN_SHIFT))

#define  IO_PAD32_PIOCFG_SLP_SEL_MASK 0x8
#define  IO_PAD32_PIOCFG_SLP_SEL_SHIFT 3
#define  IO_PAD32_PIOCFG_SLP_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD32_PIOCFG_SLP_SEL_MASK) >> IO_PAD32_PIOCFG_SLP_SEL_SHIFT)
#define  IO_PAD32_PIOCFG_SLP_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD32_PIOCFG_SLP_SEL_MASK) | (((uint32_t)val) << IO_PAD32_PIOCFG_SLP_SEL_SHIFT))

#define  IO_PAD32_PIOCFG_FUNC_SEL_MASK 0x7
#define  IO_PAD32_PIOCFG_FUNC_SEL_SHIFT 0
#define  IO_PAD32_PIOCFG_FUNC_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD32_PIOCFG_FUNC_SEL_MASK) >> IO_PAD32_PIOCFG_FUNC_SEL_SHIFT)
#define  IO_PAD32_PIOCFG_FUNC_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD32_PIOCFG_FUNC_SEL_MASK) | (((uint32_t)val) << IO_PAD32_PIOCFG_FUNC_SEL_SHIFT))

//====================================================================
//
//Register File: IO_PAD33 Configuration Registers (IO_PAD33)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

//====================================================================
//Register: IO_PAD33 Configuration Register (PIOCFG)
/** \brief "PHI_PADXDC_HSIOB" Pad*/
//====================================================================

#define  IO_PAD33_PIOCFG_RESERVED1_MASK 0xfc000000
#define  IO_PAD33_PIOCFG_RESERVED1_SHIFT 26
#define  IO_PAD33_PIOCFG_RESERVED1_MASK_SHIFT(reg) (((reg) & IO_PAD33_PIOCFG_RESERVED1_MASK) >> IO_PAD33_PIOCFG_RESERVED1_SHIFT)
#define  IO_PAD33_PIOCFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD33_PIOCFG_RESERVED1_MASK) | (((uint32_t)val) << IO_PAD33_PIOCFG_RESERVED1_SHIFT))

#define  IO_PAD33_PIOCFG_PD_MASK 0x2000000
#define  IO_PAD33_PIOCFG_PD_SHIFT 25
#define  IO_PAD33_PIOCFG_PD_MASK_SHIFT(reg) (((reg) & IO_PAD33_PIOCFG_PD_MASK) >> IO_PAD33_PIOCFG_PD_SHIFT)
#define  IO_PAD33_PIOCFG_PD_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD33_PIOCFG_PD_MASK) | (((uint32_t)val) << IO_PAD33_PIOCFG_PD_SHIFT))

#define  IO_PAD33_PIOCFG_ODT_EN_MASK 0x1000000
#define  IO_PAD33_PIOCFG_ODT_EN_SHIFT 24
#define  IO_PAD33_PIOCFG_ODT_EN_MASK_SHIFT(reg) (((reg) & IO_PAD33_PIOCFG_ODT_EN_MASK) >> IO_PAD33_PIOCFG_ODT_EN_SHIFT)
#define  IO_PAD33_PIOCFG_ODT_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD33_PIOCFG_ODT_EN_MASK) | (((uint32_t)val) << IO_PAD33_PIOCFG_ODT_EN_SHIFT))

#define  IO_PAD33_PIOCFG_LED_EN_MASK 0x800000
#define  IO_PAD33_PIOCFG_LED_EN_SHIFT 23
#define  IO_PAD33_PIOCFG_LED_EN_MASK_SHIFT(reg) (((reg) & IO_PAD33_PIOCFG_LED_EN_MASK) >> IO_PAD33_PIOCFG_LED_EN_SHIFT)
#define  IO_PAD33_PIOCFG_LED_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD33_PIOCFG_LED_EN_MASK) | (((uint32_t)val) << IO_PAD33_PIOCFG_LED_EN_SHIFT))

#define  IO_PAD33_PIOCFG_I2C_SEL_MASK 0x600000
#define  IO_PAD33_PIOCFG_I2C_SEL_SHIFT 21
#define  IO_PAD33_PIOCFG_I2C_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD33_PIOCFG_I2C_SEL_MASK) >> IO_PAD33_PIOCFG_I2C_SEL_SHIFT)
#define  IO_PAD33_PIOCFG_I2C_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD33_PIOCFG_I2C_SEL_MASK) | (((uint32_t)val) << IO_PAD33_PIOCFG_I2C_SEL_SHIFT))

#define  IO_PAD33_PIOCFG_DGTBSEL_MASK 0x1e0000
#define  IO_PAD33_PIOCFG_DGTBSEL_SHIFT 17
#define  IO_PAD33_PIOCFG_DGTBSEL_MASK_SHIFT(reg) (((reg) & IO_PAD33_PIOCFG_DGTBSEL_MASK) >> IO_PAD33_PIOCFG_DGTBSEL_SHIFT)
#define  IO_PAD33_PIOCFG_DGTBSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD33_PIOCFG_DGTBSEL_MASK) | (((uint32_t)val) << IO_PAD33_PIOCFG_DGTBSEL_SHIFT))

#define  IO_PAD33_PIOCFG_RAWSEL_MASK 0x10000
#define  IO_PAD33_PIOCFG_RAWSEL_SHIFT 16
#define  IO_PAD33_PIOCFG_RAWSEL_MASK_SHIFT(reg) (((reg) & IO_PAD33_PIOCFG_RAWSEL_MASK) >> IO_PAD33_PIOCFG_RAWSEL_SHIFT)
#define  IO_PAD33_PIOCFG_RAWSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD33_PIOCFG_RAWSEL_MASK) | (((uint32_t)val) << IO_PAD33_PIOCFG_RAWSEL_SHIFT))

#define  IO_PAD33_PIOCFG_PULL_SEL_MASK 0x8000
#define  IO_PAD33_PIOCFG_PULL_SEL_SHIFT 15
#define  IO_PAD33_PIOCFG_PULL_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD33_PIOCFG_PULL_SEL_MASK) >> IO_PAD33_PIOCFG_PULL_SEL_SHIFT)
#define  IO_PAD33_PIOCFG_PULL_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD33_PIOCFG_PULL_SEL_MASK) | (((uint32_t)val) << IO_PAD33_PIOCFG_PULL_SEL_SHIFT))

#define  IO_PAD33_PIOCFG_PUEN_MASK 0x4000
#define  IO_PAD33_PIOCFG_PUEN_SHIFT 14
#define  IO_PAD33_PIOCFG_PUEN_MASK_SHIFT(reg) (((reg) & IO_PAD33_PIOCFG_PUEN_MASK) >> IO_PAD33_PIOCFG_PUEN_SHIFT)
#define  IO_PAD33_PIOCFG_PUEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD33_PIOCFG_PUEN_MASK) | (((uint32_t)val) << IO_PAD33_PIOCFG_PUEN_SHIFT))

#define  IO_PAD33_PIOCFG_PDEN_MASK 0x2000
#define  IO_PAD33_PIOCFG_PDEN_SHIFT 13
#define  IO_PAD33_PIOCFG_PDEN_MASK_SHIFT(reg) (((reg) & IO_PAD33_PIOCFG_PDEN_MASK) >> IO_PAD33_PIOCFG_PDEN_SHIFT)
#define  IO_PAD33_PIOCFG_PDEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD33_PIOCFG_PDEN_MASK) | (((uint32_t)val) << IO_PAD33_PIOCFG_PDEN_SHIFT))

#define  IO_PAD33_PIOCFG_SR_MASK 0x1800
#define  IO_PAD33_PIOCFG_SR_SHIFT 11
#define  IO_PAD33_PIOCFG_SR_MASK_SHIFT(reg) (((reg) & IO_PAD33_PIOCFG_SR_MASK) >> IO_PAD33_PIOCFG_SR_SHIFT)
#define  IO_PAD33_PIOCFG_SR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD33_PIOCFG_SR_MASK) | (((uint32_t)val) << IO_PAD33_PIOCFG_SR_SHIFT))

#define  IO_PAD33_PIOCFG_SLP_DI_MASK 0x400
#define  IO_PAD33_PIOCFG_SLP_DI_SHIFT 10
#define  IO_PAD33_PIOCFG_SLP_DI_MASK_SHIFT(reg) (((reg) & IO_PAD33_PIOCFG_SLP_DI_MASK) >> IO_PAD33_PIOCFG_SLP_DI_SHIFT)
#define  IO_PAD33_PIOCFG_SLP_DI_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD33_PIOCFG_SLP_DI_MASK) | (((uint32_t)val) << IO_PAD33_PIOCFG_SLP_DI_SHIFT))

#define  IO_PAD33_PIOCFG_SLP_CNTRL_MASK 0x200
#define  IO_PAD33_PIOCFG_SLP_CNTRL_SHIFT 9
#define  IO_PAD33_PIOCFG_SLP_CNTRL_MASK_SHIFT(reg) (((reg) & IO_PAD33_PIOCFG_SLP_CNTRL_MASK) >> IO_PAD33_PIOCFG_SLP_CNTRL_SHIFT)
#define  IO_PAD33_PIOCFG_SLP_CNTRL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD33_PIOCFG_SLP_CNTRL_MASK) | (((uint32_t)val) << IO_PAD33_PIOCFG_SLP_CNTRL_SHIFT))

#define  IO_PAD33_PIOCFG_SLP_DO_MASK 0x100
#define  IO_PAD33_PIOCFG_SLP_DO_SHIFT 8
#define  IO_PAD33_PIOCFG_SLP_DO_MASK_SHIFT(reg) (((reg) & IO_PAD33_PIOCFG_SLP_DO_MASK) >> IO_PAD33_PIOCFG_SLP_DO_SHIFT)
#define  IO_PAD33_PIOCFG_SLP_DO_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD33_PIOCFG_SLP_DO_MASK) | (((uint32_t)val) << IO_PAD33_PIOCFG_SLP_DO_SHIFT))

#define  IO_PAD33_PIOCFG_SLP_DIR_MASK 0x80
#define  IO_PAD33_PIOCFG_SLP_DIR_SHIFT 7
#define  IO_PAD33_PIOCFG_SLP_DIR_MASK_SHIFT(reg) (((reg) & IO_PAD33_PIOCFG_SLP_DIR_MASK) >> IO_PAD33_PIOCFG_SLP_DIR_SHIFT)
#define  IO_PAD33_PIOCFG_SLP_DIR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD33_PIOCFG_SLP_DIR_MASK) | (((uint32_t)val) << IO_PAD33_PIOCFG_SLP_DIR_SHIFT))

#define  IO_PAD33_PIOCFG_EDGE_EN_N_MASK 0x40
#define  IO_PAD33_PIOCFG_EDGE_EN_N_SHIFT 6
#define  IO_PAD33_PIOCFG_EDGE_EN_N_MASK_SHIFT(reg) (((reg) & IO_PAD33_PIOCFG_EDGE_EN_N_MASK) >> IO_PAD33_PIOCFG_EDGE_EN_N_SHIFT)
#define  IO_PAD33_PIOCFG_EDGE_EN_N_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD33_PIOCFG_EDGE_EN_N_MASK) | (((uint32_t)val) << IO_PAD33_PIOCFG_EDGE_EN_N_SHIFT))

#define  IO_PAD33_PIOCFG_EDGE_FALL_EN_MASK 0x20
#define  IO_PAD33_PIOCFG_EDGE_FALL_EN_SHIFT 5
#define  IO_PAD33_PIOCFG_EDGE_FALL_EN_MASK_SHIFT(reg) (((reg) & IO_PAD33_PIOCFG_EDGE_FALL_EN_MASK) >> IO_PAD33_PIOCFG_EDGE_FALL_EN_SHIFT)
#define  IO_PAD33_PIOCFG_EDGE_FALL_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD33_PIOCFG_EDGE_FALL_EN_MASK) | (((uint32_t)val) << IO_PAD33_PIOCFG_EDGE_FALL_EN_SHIFT))

#define  IO_PAD33_PIOCFG_EDGE_RISE_EN_MASK 0x10
#define  IO_PAD33_PIOCFG_EDGE_RISE_EN_SHIFT 4
#define  IO_PAD33_PIOCFG_EDGE_RISE_EN_MASK_SHIFT(reg) (((reg) & IO_PAD33_PIOCFG_EDGE_RISE_EN_MASK) >> IO_PAD33_PIOCFG_EDGE_RISE_EN_SHIFT)
#define  IO_PAD33_PIOCFG_EDGE_RISE_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD33_PIOCFG_EDGE_RISE_EN_MASK) | (((uint32_t)val) << IO_PAD33_PIOCFG_EDGE_RISE_EN_SHIFT))

#define  IO_PAD33_PIOCFG_SLP_SEL_MASK 0x8
#define  IO_PAD33_PIOCFG_SLP_SEL_SHIFT 3
#define  IO_PAD33_PIOCFG_SLP_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD33_PIOCFG_SLP_SEL_MASK) >> IO_PAD33_PIOCFG_SLP_SEL_SHIFT)
#define  IO_PAD33_PIOCFG_SLP_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD33_PIOCFG_SLP_SEL_MASK) | (((uint32_t)val) << IO_PAD33_PIOCFG_SLP_SEL_SHIFT))

#define  IO_PAD33_PIOCFG_FUNC_SEL_MASK 0x7
#define  IO_PAD33_PIOCFG_FUNC_SEL_SHIFT 0
#define  IO_PAD33_PIOCFG_FUNC_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD33_PIOCFG_FUNC_SEL_MASK) >> IO_PAD33_PIOCFG_FUNC_SEL_SHIFT)
#define  IO_PAD33_PIOCFG_FUNC_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD33_PIOCFG_FUNC_SEL_MASK) | (((uint32_t)val) << IO_PAD33_PIOCFG_FUNC_SEL_SHIFT))

//====================================================================
//
//Register File: IO_PAD34 Configuration Registers (IO_PAD34)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

//====================================================================
//Register: IO_PAD34 Configuration Register (PIOCFG)
/** \brief "PHI_PADXDC_SRC" Pad*/
//====================================================================

#define  IO_PAD34_PIOCFG_RESERVED1_MASK 0xfc000000
#define  IO_PAD34_PIOCFG_RESERVED1_SHIFT 26
#define  IO_PAD34_PIOCFG_RESERVED1_MASK_SHIFT(reg) (((reg) & IO_PAD34_PIOCFG_RESERVED1_MASK) >> IO_PAD34_PIOCFG_RESERVED1_SHIFT)
#define  IO_PAD34_PIOCFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD34_PIOCFG_RESERVED1_MASK) | (((uint32_t)val) << IO_PAD34_PIOCFG_RESERVED1_SHIFT))

#define  IO_PAD34_PIOCFG_PD_MASK 0x2000000
#define  IO_PAD34_PIOCFG_PD_SHIFT 25
#define  IO_PAD34_PIOCFG_PD_MASK_SHIFT(reg) (((reg) & IO_PAD34_PIOCFG_PD_MASK) >> IO_PAD34_PIOCFG_PD_SHIFT)
#define  IO_PAD34_PIOCFG_PD_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD34_PIOCFG_PD_MASK) | (((uint32_t)val) << IO_PAD34_PIOCFG_PD_SHIFT))

#define  IO_PAD34_PIOCFG_ODT_EN_MASK 0x1000000
#define  IO_PAD34_PIOCFG_ODT_EN_SHIFT 24
#define  IO_PAD34_PIOCFG_ODT_EN_MASK_SHIFT(reg) (((reg) & IO_PAD34_PIOCFG_ODT_EN_MASK) >> IO_PAD34_PIOCFG_ODT_EN_SHIFT)
#define  IO_PAD34_PIOCFG_ODT_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD34_PIOCFG_ODT_EN_MASK) | (((uint32_t)val) << IO_PAD34_PIOCFG_ODT_EN_SHIFT))

#define  IO_PAD34_PIOCFG_LED_EN_MASK 0x800000
#define  IO_PAD34_PIOCFG_LED_EN_SHIFT 23
#define  IO_PAD34_PIOCFG_LED_EN_MASK_SHIFT(reg) (((reg) & IO_PAD34_PIOCFG_LED_EN_MASK) >> IO_PAD34_PIOCFG_LED_EN_SHIFT)
#define  IO_PAD34_PIOCFG_LED_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD34_PIOCFG_LED_EN_MASK) | (((uint32_t)val) << IO_PAD34_PIOCFG_LED_EN_SHIFT))

#define  IO_PAD34_PIOCFG_I2C_SEL_MASK 0x600000
#define  IO_PAD34_PIOCFG_I2C_SEL_SHIFT 21
#define  IO_PAD34_PIOCFG_I2C_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD34_PIOCFG_I2C_SEL_MASK) >> IO_PAD34_PIOCFG_I2C_SEL_SHIFT)
#define  IO_PAD34_PIOCFG_I2C_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD34_PIOCFG_I2C_SEL_MASK) | (((uint32_t)val) << IO_PAD34_PIOCFG_I2C_SEL_SHIFT))

#define  IO_PAD34_PIOCFG_DGTBSEL_MASK 0x1e0000
#define  IO_PAD34_PIOCFG_DGTBSEL_SHIFT 17
#define  IO_PAD34_PIOCFG_DGTBSEL_MASK_SHIFT(reg) (((reg) & IO_PAD34_PIOCFG_DGTBSEL_MASK) >> IO_PAD34_PIOCFG_DGTBSEL_SHIFT)
#define  IO_PAD34_PIOCFG_DGTBSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD34_PIOCFG_DGTBSEL_MASK) | (((uint32_t)val) << IO_PAD34_PIOCFG_DGTBSEL_SHIFT))

#define  IO_PAD34_PIOCFG_RAWSEL_MASK 0x10000
#define  IO_PAD34_PIOCFG_RAWSEL_SHIFT 16
#define  IO_PAD34_PIOCFG_RAWSEL_MASK_SHIFT(reg) (((reg) & IO_PAD34_PIOCFG_RAWSEL_MASK) >> IO_PAD34_PIOCFG_RAWSEL_SHIFT)
#define  IO_PAD34_PIOCFG_RAWSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD34_PIOCFG_RAWSEL_MASK) | (((uint32_t)val) << IO_PAD34_PIOCFG_RAWSEL_SHIFT))

#define  IO_PAD34_PIOCFG_PULL_SEL_MASK 0x8000
#define  IO_PAD34_PIOCFG_PULL_SEL_SHIFT 15
#define  IO_PAD34_PIOCFG_PULL_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD34_PIOCFG_PULL_SEL_MASK) >> IO_PAD34_PIOCFG_PULL_SEL_SHIFT)
#define  IO_PAD34_PIOCFG_PULL_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD34_PIOCFG_PULL_SEL_MASK) | (((uint32_t)val) << IO_PAD34_PIOCFG_PULL_SEL_SHIFT))

#define  IO_PAD34_PIOCFG_PUEN_MASK 0x4000
#define  IO_PAD34_PIOCFG_PUEN_SHIFT 14
#define  IO_PAD34_PIOCFG_PUEN_MASK_SHIFT(reg) (((reg) & IO_PAD34_PIOCFG_PUEN_MASK) >> IO_PAD34_PIOCFG_PUEN_SHIFT)
#define  IO_PAD34_PIOCFG_PUEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD34_PIOCFG_PUEN_MASK) | (((uint32_t)val) << IO_PAD34_PIOCFG_PUEN_SHIFT))

#define  IO_PAD34_PIOCFG_PDEN_MASK 0x2000
#define  IO_PAD34_PIOCFG_PDEN_SHIFT 13
#define  IO_PAD34_PIOCFG_PDEN_MASK_SHIFT(reg) (((reg) & IO_PAD34_PIOCFG_PDEN_MASK) >> IO_PAD34_PIOCFG_PDEN_SHIFT)
#define  IO_PAD34_PIOCFG_PDEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD34_PIOCFG_PDEN_MASK) | (((uint32_t)val) << IO_PAD34_PIOCFG_PDEN_SHIFT))

#define  IO_PAD34_PIOCFG_SR_MASK 0x1800
#define  IO_PAD34_PIOCFG_SR_SHIFT 11
#define  IO_PAD34_PIOCFG_SR_MASK_SHIFT(reg) (((reg) & IO_PAD34_PIOCFG_SR_MASK) >> IO_PAD34_PIOCFG_SR_SHIFT)
#define  IO_PAD34_PIOCFG_SR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD34_PIOCFG_SR_MASK) | (((uint32_t)val) << IO_PAD34_PIOCFG_SR_SHIFT))

#define  IO_PAD34_PIOCFG_SLP_DI_MASK 0x400
#define  IO_PAD34_PIOCFG_SLP_DI_SHIFT 10
#define  IO_PAD34_PIOCFG_SLP_DI_MASK_SHIFT(reg) (((reg) & IO_PAD34_PIOCFG_SLP_DI_MASK) >> IO_PAD34_PIOCFG_SLP_DI_SHIFT)
#define  IO_PAD34_PIOCFG_SLP_DI_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD34_PIOCFG_SLP_DI_MASK) | (((uint32_t)val) << IO_PAD34_PIOCFG_SLP_DI_SHIFT))

#define  IO_PAD34_PIOCFG_SLP_CNTRL_MASK 0x200
#define  IO_PAD34_PIOCFG_SLP_CNTRL_SHIFT 9
#define  IO_PAD34_PIOCFG_SLP_CNTRL_MASK_SHIFT(reg) (((reg) & IO_PAD34_PIOCFG_SLP_CNTRL_MASK) >> IO_PAD34_PIOCFG_SLP_CNTRL_SHIFT)
#define  IO_PAD34_PIOCFG_SLP_CNTRL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD34_PIOCFG_SLP_CNTRL_MASK) | (((uint32_t)val) << IO_PAD34_PIOCFG_SLP_CNTRL_SHIFT))

#define  IO_PAD34_PIOCFG_SLP_DO_MASK 0x100
#define  IO_PAD34_PIOCFG_SLP_DO_SHIFT 8
#define  IO_PAD34_PIOCFG_SLP_DO_MASK_SHIFT(reg) (((reg) & IO_PAD34_PIOCFG_SLP_DO_MASK) >> IO_PAD34_PIOCFG_SLP_DO_SHIFT)
#define  IO_PAD34_PIOCFG_SLP_DO_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD34_PIOCFG_SLP_DO_MASK) | (((uint32_t)val) << IO_PAD34_PIOCFG_SLP_DO_SHIFT))

#define  IO_PAD34_PIOCFG_SLP_DIR_MASK 0x80
#define  IO_PAD34_PIOCFG_SLP_DIR_SHIFT 7
#define  IO_PAD34_PIOCFG_SLP_DIR_MASK_SHIFT(reg) (((reg) & IO_PAD34_PIOCFG_SLP_DIR_MASK) >> IO_PAD34_PIOCFG_SLP_DIR_SHIFT)
#define  IO_PAD34_PIOCFG_SLP_DIR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD34_PIOCFG_SLP_DIR_MASK) | (((uint32_t)val) << IO_PAD34_PIOCFG_SLP_DIR_SHIFT))

#define  IO_PAD34_PIOCFG_EDGE_EN_N_MASK 0x40
#define  IO_PAD34_PIOCFG_EDGE_EN_N_SHIFT 6
#define  IO_PAD34_PIOCFG_EDGE_EN_N_MASK_SHIFT(reg) (((reg) & IO_PAD34_PIOCFG_EDGE_EN_N_MASK) >> IO_PAD34_PIOCFG_EDGE_EN_N_SHIFT)
#define  IO_PAD34_PIOCFG_EDGE_EN_N_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD34_PIOCFG_EDGE_EN_N_MASK) | (((uint32_t)val) << IO_PAD34_PIOCFG_EDGE_EN_N_SHIFT))

#define  IO_PAD34_PIOCFG_EDGE_FALL_EN_MASK 0x20
#define  IO_PAD34_PIOCFG_EDGE_FALL_EN_SHIFT 5
#define  IO_PAD34_PIOCFG_EDGE_FALL_EN_MASK_SHIFT(reg) (((reg) & IO_PAD34_PIOCFG_EDGE_FALL_EN_MASK) >> IO_PAD34_PIOCFG_EDGE_FALL_EN_SHIFT)
#define  IO_PAD34_PIOCFG_EDGE_FALL_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD34_PIOCFG_EDGE_FALL_EN_MASK) | (((uint32_t)val) << IO_PAD34_PIOCFG_EDGE_FALL_EN_SHIFT))

#define  IO_PAD34_PIOCFG_EDGE_RISE_EN_MASK 0x10
#define  IO_PAD34_PIOCFG_EDGE_RISE_EN_SHIFT 4
#define  IO_PAD34_PIOCFG_EDGE_RISE_EN_MASK_SHIFT(reg) (((reg) & IO_PAD34_PIOCFG_EDGE_RISE_EN_MASK) >> IO_PAD34_PIOCFG_EDGE_RISE_EN_SHIFT)
#define  IO_PAD34_PIOCFG_EDGE_RISE_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD34_PIOCFG_EDGE_RISE_EN_MASK) | (((uint32_t)val) << IO_PAD34_PIOCFG_EDGE_RISE_EN_SHIFT))

#define  IO_PAD34_PIOCFG_SLP_SEL_MASK 0x8
#define  IO_PAD34_PIOCFG_SLP_SEL_SHIFT 3
#define  IO_PAD34_PIOCFG_SLP_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD34_PIOCFG_SLP_SEL_MASK) >> IO_PAD34_PIOCFG_SLP_SEL_SHIFT)
#define  IO_PAD34_PIOCFG_SLP_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD34_PIOCFG_SLP_SEL_MASK) | (((uint32_t)val) << IO_PAD34_PIOCFG_SLP_SEL_SHIFT))

#define  IO_PAD34_PIOCFG_FUNC_SEL_MASK 0x7
#define  IO_PAD34_PIOCFG_FUNC_SEL_SHIFT 0
#define  IO_PAD34_PIOCFG_FUNC_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD34_PIOCFG_FUNC_SEL_MASK) >> IO_PAD34_PIOCFG_FUNC_SEL_SHIFT)
#define  IO_PAD34_PIOCFG_FUNC_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD34_PIOCFG_FUNC_SEL_MASK) | (((uint32_t)val) << IO_PAD34_PIOCFG_FUNC_SEL_SHIFT))

//====================================================================
//
//Register File: IO_PAD35 Configuration Registers (IO_PAD35)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

//====================================================================
//Register: IO_PAD35 Configuration Register (PIOCFG)
/** \brief "PHI_PADXDC_HSIOB" Pad*/
//====================================================================

#define  IO_PAD35_PIOCFG_RESERVED1_MASK 0xfc000000
#define  IO_PAD35_PIOCFG_RESERVED1_SHIFT 26
#define  IO_PAD35_PIOCFG_RESERVED1_MASK_SHIFT(reg) (((reg) & IO_PAD35_PIOCFG_RESERVED1_MASK) >> IO_PAD35_PIOCFG_RESERVED1_SHIFT)
#define  IO_PAD35_PIOCFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD35_PIOCFG_RESERVED1_MASK) | (((uint32_t)val) << IO_PAD35_PIOCFG_RESERVED1_SHIFT))

#define  IO_PAD35_PIOCFG_PD_MASK 0x2000000
#define  IO_PAD35_PIOCFG_PD_SHIFT 25
#define  IO_PAD35_PIOCFG_PD_MASK_SHIFT(reg) (((reg) & IO_PAD35_PIOCFG_PD_MASK) >> IO_PAD35_PIOCFG_PD_SHIFT)
#define  IO_PAD35_PIOCFG_PD_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD35_PIOCFG_PD_MASK) | (((uint32_t)val) << IO_PAD35_PIOCFG_PD_SHIFT))

#define  IO_PAD35_PIOCFG_ODT_EN_MASK 0x1000000
#define  IO_PAD35_PIOCFG_ODT_EN_SHIFT 24
#define  IO_PAD35_PIOCFG_ODT_EN_MASK_SHIFT(reg) (((reg) & IO_PAD35_PIOCFG_ODT_EN_MASK) >> IO_PAD35_PIOCFG_ODT_EN_SHIFT)
#define  IO_PAD35_PIOCFG_ODT_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD35_PIOCFG_ODT_EN_MASK) | (((uint32_t)val) << IO_PAD35_PIOCFG_ODT_EN_SHIFT))

#define  IO_PAD35_PIOCFG_LED_EN_MASK 0x800000
#define  IO_PAD35_PIOCFG_LED_EN_SHIFT 23
#define  IO_PAD35_PIOCFG_LED_EN_MASK_SHIFT(reg) (((reg) & IO_PAD35_PIOCFG_LED_EN_MASK) >> IO_PAD35_PIOCFG_LED_EN_SHIFT)
#define  IO_PAD35_PIOCFG_LED_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD35_PIOCFG_LED_EN_MASK) | (((uint32_t)val) << IO_PAD35_PIOCFG_LED_EN_SHIFT))

#define  IO_PAD35_PIOCFG_I2C_SEL_MASK 0x600000
#define  IO_PAD35_PIOCFG_I2C_SEL_SHIFT 21
#define  IO_PAD35_PIOCFG_I2C_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD35_PIOCFG_I2C_SEL_MASK) >> IO_PAD35_PIOCFG_I2C_SEL_SHIFT)
#define  IO_PAD35_PIOCFG_I2C_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD35_PIOCFG_I2C_SEL_MASK) | (((uint32_t)val) << IO_PAD35_PIOCFG_I2C_SEL_SHIFT))

#define  IO_PAD35_PIOCFG_DGTBSEL_MASK 0x1e0000
#define  IO_PAD35_PIOCFG_DGTBSEL_SHIFT 17
#define  IO_PAD35_PIOCFG_DGTBSEL_MASK_SHIFT(reg) (((reg) & IO_PAD35_PIOCFG_DGTBSEL_MASK) >> IO_PAD35_PIOCFG_DGTBSEL_SHIFT)
#define  IO_PAD35_PIOCFG_DGTBSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD35_PIOCFG_DGTBSEL_MASK) | (((uint32_t)val) << IO_PAD35_PIOCFG_DGTBSEL_SHIFT))

#define  IO_PAD35_PIOCFG_RAWSEL_MASK 0x10000
#define  IO_PAD35_PIOCFG_RAWSEL_SHIFT 16
#define  IO_PAD35_PIOCFG_RAWSEL_MASK_SHIFT(reg) (((reg) & IO_PAD35_PIOCFG_RAWSEL_MASK) >> IO_PAD35_PIOCFG_RAWSEL_SHIFT)
#define  IO_PAD35_PIOCFG_RAWSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD35_PIOCFG_RAWSEL_MASK) | (((uint32_t)val) << IO_PAD35_PIOCFG_RAWSEL_SHIFT))

#define  IO_PAD35_PIOCFG_PULL_SEL_MASK 0x8000
#define  IO_PAD35_PIOCFG_PULL_SEL_SHIFT 15
#define  IO_PAD35_PIOCFG_PULL_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD35_PIOCFG_PULL_SEL_MASK) >> IO_PAD35_PIOCFG_PULL_SEL_SHIFT)
#define  IO_PAD35_PIOCFG_PULL_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD35_PIOCFG_PULL_SEL_MASK) | (((uint32_t)val) << IO_PAD35_PIOCFG_PULL_SEL_SHIFT))

#define  IO_PAD35_PIOCFG_PUEN_MASK 0x4000
#define  IO_PAD35_PIOCFG_PUEN_SHIFT 14
#define  IO_PAD35_PIOCFG_PUEN_MASK_SHIFT(reg) (((reg) & IO_PAD35_PIOCFG_PUEN_MASK) >> IO_PAD35_PIOCFG_PUEN_SHIFT)
#define  IO_PAD35_PIOCFG_PUEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD35_PIOCFG_PUEN_MASK) | (((uint32_t)val) << IO_PAD35_PIOCFG_PUEN_SHIFT))

#define  IO_PAD35_PIOCFG_PDEN_MASK 0x2000
#define  IO_PAD35_PIOCFG_PDEN_SHIFT 13
#define  IO_PAD35_PIOCFG_PDEN_MASK_SHIFT(reg) (((reg) & IO_PAD35_PIOCFG_PDEN_MASK) >> IO_PAD35_PIOCFG_PDEN_SHIFT)
#define  IO_PAD35_PIOCFG_PDEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD35_PIOCFG_PDEN_MASK) | (((uint32_t)val) << IO_PAD35_PIOCFG_PDEN_SHIFT))

#define  IO_PAD35_PIOCFG_SR_MASK 0x1800
#define  IO_PAD35_PIOCFG_SR_SHIFT 11
#define  IO_PAD35_PIOCFG_SR_MASK_SHIFT(reg) (((reg) & IO_PAD35_PIOCFG_SR_MASK) >> IO_PAD35_PIOCFG_SR_SHIFT)
#define  IO_PAD35_PIOCFG_SR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD35_PIOCFG_SR_MASK) | (((uint32_t)val) << IO_PAD35_PIOCFG_SR_SHIFT))

#define  IO_PAD35_PIOCFG_SLP_DI_MASK 0x400
#define  IO_PAD35_PIOCFG_SLP_DI_SHIFT 10
#define  IO_PAD35_PIOCFG_SLP_DI_MASK_SHIFT(reg) (((reg) & IO_PAD35_PIOCFG_SLP_DI_MASK) >> IO_PAD35_PIOCFG_SLP_DI_SHIFT)
#define  IO_PAD35_PIOCFG_SLP_DI_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD35_PIOCFG_SLP_DI_MASK) | (((uint32_t)val) << IO_PAD35_PIOCFG_SLP_DI_SHIFT))

#define  IO_PAD35_PIOCFG_SLP_CNTRL_MASK 0x200
#define  IO_PAD35_PIOCFG_SLP_CNTRL_SHIFT 9
#define  IO_PAD35_PIOCFG_SLP_CNTRL_MASK_SHIFT(reg) (((reg) & IO_PAD35_PIOCFG_SLP_CNTRL_MASK) >> IO_PAD35_PIOCFG_SLP_CNTRL_SHIFT)
#define  IO_PAD35_PIOCFG_SLP_CNTRL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD35_PIOCFG_SLP_CNTRL_MASK) | (((uint32_t)val) << IO_PAD35_PIOCFG_SLP_CNTRL_SHIFT))

#define  IO_PAD35_PIOCFG_SLP_DO_MASK 0x100
#define  IO_PAD35_PIOCFG_SLP_DO_SHIFT 8
#define  IO_PAD35_PIOCFG_SLP_DO_MASK_SHIFT(reg) (((reg) & IO_PAD35_PIOCFG_SLP_DO_MASK) >> IO_PAD35_PIOCFG_SLP_DO_SHIFT)
#define  IO_PAD35_PIOCFG_SLP_DO_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD35_PIOCFG_SLP_DO_MASK) | (((uint32_t)val) << IO_PAD35_PIOCFG_SLP_DO_SHIFT))

#define  IO_PAD35_PIOCFG_SLP_DIR_MASK 0x80
#define  IO_PAD35_PIOCFG_SLP_DIR_SHIFT 7
#define  IO_PAD35_PIOCFG_SLP_DIR_MASK_SHIFT(reg) (((reg) & IO_PAD35_PIOCFG_SLP_DIR_MASK) >> IO_PAD35_PIOCFG_SLP_DIR_SHIFT)
#define  IO_PAD35_PIOCFG_SLP_DIR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD35_PIOCFG_SLP_DIR_MASK) | (((uint32_t)val) << IO_PAD35_PIOCFG_SLP_DIR_SHIFT))

#define  IO_PAD35_PIOCFG_EDGE_EN_N_MASK 0x40
#define  IO_PAD35_PIOCFG_EDGE_EN_N_SHIFT 6
#define  IO_PAD35_PIOCFG_EDGE_EN_N_MASK_SHIFT(reg) (((reg) & IO_PAD35_PIOCFG_EDGE_EN_N_MASK) >> IO_PAD35_PIOCFG_EDGE_EN_N_SHIFT)
#define  IO_PAD35_PIOCFG_EDGE_EN_N_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD35_PIOCFG_EDGE_EN_N_MASK) | (((uint32_t)val) << IO_PAD35_PIOCFG_EDGE_EN_N_SHIFT))

#define  IO_PAD35_PIOCFG_EDGE_FALL_EN_MASK 0x20
#define  IO_PAD35_PIOCFG_EDGE_FALL_EN_SHIFT 5
#define  IO_PAD35_PIOCFG_EDGE_FALL_EN_MASK_SHIFT(reg) (((reg) & IO_PAD35_PIOCFG_EDGE_FALL_EN_MASK) >> IO_PAD35_PIOCFG_EDGE_FALL_EN_SHIFT)
#define  IO_PAD35_PIOCFG_EDGE_FALL_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD35_PIOCFG_EDGE_FALL_EN_MASK) | (((uint32_t)val) << IO_PAD35_PIOCFG_EDGE_FALL_EN_SHIFT))

#define  IO_PAD35_PIOCFG_EDGE_RISE_EN_MASK 0x10
#define  IO_PAD35_PIOCFG_EDGE_RISE_EN_SHIFT 4
#define  IO_PAD35_PIOCFG_EDGE_RISE_EN_MASK_SHIFT(reg) (((reg) & IO_PAD35_PIOCFG_EDGE_RISE_EN_MASK) >> IO_PAD35_PIOCFG_EDGE_RISE_EN_SHIFT)
#define  IO_PAD35_PIOCFG_EDGE_RISE_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD35_PIOCFG_EDGE_RISE_EN_MASK) | (((uint32_t)val) << IO_PAD35_PIOCFG_EDGE_RISE_EN_SHIFT))

#define  IO_PAD35_PIOCFG_SLP_SEL_MASK 0x8
#define  IO_PAD35_PIOCFG_SLP_SEL_SHIFT 3
#define  IO_PAD35_PIOCFG_SLP_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD35_PIOCFG_SLP_SEL_MASK) >> IO_PAD35_PIOCFG_SLP_SEL_SHIFT)
#define  IO_PAD35_PIOCFG_SLP_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD35_PIOCFG_SLP_SEL_MASK) | (((uint32_t)val) << IO_PAD35_PIOCFG_SLP_SEL_SHIFT))

#define  IO_PAD35_PIOCFG_FUNC_SEL_MASK 0x7
#define  IO_PAD35_PIOCFG_FUNC_SEL_SHIFT 0
#define  IO_PAD35_PIOCFG_FUNC_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD35_PIOCFG_FUNC_SEL_MASK) >> IO_PAD35_PIOCFG_FUNC_SEL_SHIFT)
#define  IO_PAD35_PIOCFG_FUNC_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD35_PIOCFG_FUNC_SEL_MASK) | (((uint32_t)val) << IO_PAD35_PIOCFG_FUNC_SEL_SHIFT))

//====================================================================
//
//Register File: IO_PAD36 Configuration Registers (IO_PAD36)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

//====================================================================
//Register: IO_PAD36 Configuration Register (PIOCFG)
/** \brief "PHI_PADXDC_SRC" Pad*/
//====================================================================

#define  IO_PAD36_PIOCFG_RESERVED1_MASK 0xfc000000
#define  IO_PAD36_PIOCFG_RESERVED1_SHIFT 26
#define  IO_PAD36_PIOCFG_RESERVED1_MASK_SHIFT(reg) (((reg) & IO_PAD36_PIOCFG_RESERVED1_MASK) >> IO_PAD36_PIOCFG_RESERVED1_SHIFT)
#define  IO_PAD36_PIOCFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD36_PIOCFG_RESERVED1_MASK) | (((uint32_t)val) << IO_PAD36_PIOCFG_RESERVED1_SHIFT))

#define  IO_PAD36_PIOCFG_PD_MASK 0x2000000
#define  IO_PAD36_PIOCFG_PD_SHIFT 25
#define  IO_PAD36_PIOCFG_PD_MASK_SHIFT(reg) (((reg) & IO_PAD36_PIOCFG_PD_MASK) >> IO_PAD36_PIOCFG_PD_SHIFT)
#define  IO_PAD36_PIOCFG_PD_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD36_PIOCFG_PD_MASK) | (((uint32_t)val) << IO_PAD36_PIOCFG_PD_SHIFT))

#define  IO_PAD36_PIOCFG_ODT_EN_MASK 0x1000000
#define  IO_PAD36_PIOCFG_ODT_EN_SHIFT 24
#define  IO_PAD36_PIOCFG_ODT_EN_MASK_SHIFT(reg) (((reg) & IO_PAD36_PIOCFG_ODT_EN_MASK) >> IO_PAD36_PIOCFG_ODT_EN_SHIFT)
#define  IO_PAD36_PIOCFG_ODT_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD36_PIOCFG_ODT_EN_MASK) | (((uint32_t)val) << IO_PAD36_PIOCFG_ODT_EN_SHIFT))

#define  IO_PAD36_PIOCFG_LED_EN_MASK 0x800000
#define  IO_PAD36_PIOCFG_LED_EN_SHIFT 23
#define  IO_PAD36_PIOCFG_LED_EN_MASK_SHIFT(reg) (((reg) & IO_PAD36_PIOCFG_LED_EN_MASK) >> IO_PAD36_PIOCFG_LED_EN_SHIFT)
#define  IO_PAD36_PIOCFG_LED_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD36_PIOCFG_LED_EN_MASK) | (((uint32_t)val) << IO_PAD36_PIOCFG_LED_EN_SHIFT))

#define  IO_PAD36_PIOCFG_I2C_SEL_MASK 0x600000
#define  IO_PAD36_PIOCFG_I2C_SEL_SHIFT 21
#define  IO_PAD36_PIOCFG_I2C_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD36_PIOCFG_I2C_SEL_MASK) >> IO_PAD36_PIOCFG_I2C_SEL_SHIFT)
#define  IO_PAD36_PIOCFG_I2C_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD36_PIOCFG_I2C_SEL_MASK) | (((uint32_t)val) << IO_PAD36_PIOCFG_I2C_SEL_SHIFT))

#define  IO_PAD36_PIOCFG_DGTBSEL_MASK 0x1e0000
#define  IO_PAD36_PIOCFG_DGTBSEL_SHIFT 17
#define  IO_PAD36_PIOCFG_DGTBSEL_MASK_SHIFT(reg) (((reg) & IO_PAD36_PIOCFG_DGTBSEL_MASK) >> IO_PAD36_PIOCFG_DGTBSEL_SHIFT)
#define  IO_PAD36_PIOCFG_DGTBSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD36_PIOCFG_DGTBSEL_MASK) | (((uint32_t)val) << IO_PAD36_PIOCFG_DGTBSEL_SHIFT))

#define  IO_PAD36_PIOCFG_RAWSEL_MASK 0x10000
#define  IO_PAD36_PIOCFG_RAWSEL_SHIFT 16
#define  IO_PAD36_PIOCFG_RAWSEL_MASK_SHIFT(reg) (((reg) & IO_PAD36_PIOCFG_RAWSEL_MASK) >> IO_PAD36_PIOCFG_RAWSEL_SHIFT)
#define  IO_PAD36_PIOCFG_RAWSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD36_PIOCFG_RAWSEL_MASK) | (((uint32_t)val) << IO_PAD36_PIOCFG_RAWSEL_SHIFT))

#define  IO_PAD36_PIOCFG_PULL_SEL_MASK 0x8000
#define  IO_PAD36_PIOCFG_PULL_SEL_SHIFT 15
#define  IO_PAD36_PIOCFG_PULL_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD36_PIOCFG_PULL_SEL_MASK) >> IO_PAD36_PIOCFG_PULL_SEL_SHIFT)
#define  IO_PAD36_PIOCFG_PULL_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD36_PIOCFG_PULL_SEL_MASK) | (((uint32_t)val) << IO_PAD36_PIOCFG_PULL_SEL_SHIFT))

#define  IO_PAD36_PIOCFG_PUEN_MASK 0x4000
#define  IO_PAD36_PIOCFG_PUEN_SHIFT 14
#define  IO_PAD36_PIOCFG_PUEN_MASK_SHIFT(reg) (((reg) & IO_PAD36_PIOCFG_PUEN_MASK) >> IO_PAD36_PIOCFG_PUEN_SHIFT)
#define  IO_PAD36_PIOCFG_PUEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD36_PIOCFG_PUEN_MASK) | (((uint32_t)val) << IO_PAD36_PIOCFG_PUEN_SHIFT))

#define  IO_PAD36_PIOCFG_PDEN_MASK 0x2000
#define  IO_PAD36_PIOCFG_PDEN_SHIFT 13
#define  IO_PAD36_PIOCFG_PDEN_MASK_SHIFT(reg) (((reg) & IO_PAD36_PIOCFG_PDEN_MASK) >> IO_PAD36_PIOCFG_PDEN_SHIFT)
#define  IO_PAD36_PIOCFG_PDEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD36_PIOCFG_PDEN_MASK) | (((uint32_t)val) << IO_PAD36_PIOCFG_PDEN_SHIFT))

#define  IO_PAD36_PIOCFG_SR_MASK 0x1800
#define  IO_PAD36_PIOCFG_SR_SHIFT 11
#define  IO_PAD36_PIOCFG_SR_MASK_SHIFT(reg) (((reg) & IO_PAD36_PIOCFG_SR_MASK) >> IO_PAD36_PIOCFG_SR_SHIFT)
#define  IO_PAD36_PIOCFG_SR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD36_PIOCFG_SR_MASK) | (((uint32_t)val) << IO_PAD36_PIOCFG_SR_SHIFT))

#define  IO_PAD36_PIOCFG_SLP_DI_MASK 0x400
#define  IO_PAD36_PIOCFG_SLP_DI_SHIFT 10
#define  IO_PAD36_PIOCFG_SLP_DI_MASK_SHIFT(reg) (((reg) & IO_PAD36_PIOCFG_SLP_DI_MASK) >> IO_PAD36_PIOCFG_SLP_DI_SHIFT)
#define  IO_PAD36_PIOCFG_SLP_DI_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD36_PIOCFG_SLP_DI_MASK) | (((uint32_t)val) << IO_PAD36_PIOCFG_SLP_DI_SHIFT))

#define  IO_PAD36_PIOCFG_SLP_CNTRL_MASK 0x200
#define  IO_PAD36_PIOCFG_SLP_CNTRL_SHIFT 9
#define  IO_PAD36_PIOCFG_SLP_CNTRL_MASK_SHIFT(reg) (((reg) & IO_PAD36_PIOCFG_SLP_CNTRL_MASK) >> IO_PAD36_PIOCFG_SLP_CNTRL_SHIFT)
#define  IO_PAD36_PIOCFG_SLP_CNTRL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD36_PIOCFG_SLP_CNTRL_MASK) | (((uint32_t)val) << IO_PAD36_PIOCFG_SLP_CNTRL_SHIFT))

#define  IO_PAD36_PIOCFG_SLP_DO_MASK 0x100
#define  IO_PAD36_PIOCFG_SLP_DO_SHIFT 8
#define  IO_PAD36_PIOCFG_SLP_DO_MASK_SHIFT(reg) (((reg) & IO_PAD36_PIOCFG_SLP_DO_MASK) >> IO_PAD36_PIOCFG_SLP_DO_SHIFT)
#define  IO_PAD36_PIOCFG_SLP_DO_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD36_PIOCFG_SLP_DO_MASK) | (((uint32_t)val) << IO_PAD36_PIOCFG_SLP_DO_SHIFT))

#define  IO_PAD36_PIOCFG_SLP_DIR_MASK 0x80
#define  IO_PAD36_PIOCFG_SLP_DIR_SHIFT 7
#define  IO_PAD36_PIOCFG_SLP_DIR_MASK_SHIFT(reg) (((reg) & IO_PAD36_PIOCFG_SLP_DIR_MASK) >> IO_PAD36_PIOCFG_SLP_DIR_SHIFT)
#define  IO_PAD36_PIOCFG_SLP_DIR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD36_PIOCFG_SLP_DIR_MASK) | (((uint32_t)val) << IO_PAD36_PIOCFG_SLP_DIR_SHIFT))

#define  IO_PAD36_PIOCFG_EDGE_EN_N_MASK 0x40
#define  IO_PAD36_PIOCFG_EDGE_EN_N_SHIFT 6
#define  IO_PAD36_PIOCFG_EDGE_EN_N_MASK_SHIFT(reg) (((reg) & IO_PAD36_PIOCFG_EDGE_EN_N_MASK) >> IO_PAD36_PIOCFG_EDGE_EN_N_SHIFT)
#define  IO_PAD36_PIOCFG_EDGE_EN_N_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD36_PIOCFG_EDGE_EN_N_MASK) | (((uint32_t)val) << IO_PAD36_PIOCFG_EDGE_EN_N_SHIFT))

#define  IO_PAD36_PIOCFG_EDGE_FALL_EN_MASK 0x20
#define  IO_PAD36_PIOCFG_EDGE_FALL_EN_SHIFT 5
#define  IO_PAD36_PIOCFG_EDGE_FALL_EN_MASK_SHIFT(reg) (((reg) & IO_PAD36_PIOCFG_EDGE_FALL_EN_MASK) >> IO_PAD36_PIOCFG_EDGE_FALL_EN_SHIFT)
#define  IO_PAD36_PIOCFG_EDGE_FALL_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD36_PIOCFG_EDGE_FALL_EN_MASK) | (((uint32_t)val) << IO_PAD36_PIOCFG_EDGE_FALL_EN_SHIFT))

#define  IO_PAD36_PIOCFG_EDGE_RISE_EN_MASK 0x10
#define  IO_PAD36_PIOCFG_EDGE_RISE_EN_SHIFT 4
#define  IO_PAD36_PIOCFG_EDGE_RISE_EN_MASK_SHIFT(reg) (((reg) & IO_PAD36_PIOCFG_EDGE_RISE_EN_MASK) >> IO_PAD36_PIOCFG_EDGE_RISE_EN_SHIFT)
#define  IO_PAD36_PIOCFG_EDGE_RISE_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD36_PIOCFG_EDGE_RISE_EN_MASK) | (((uint32_t)val) << IO_PAD36_PIOCFG_EDGE_RISE_EN_SHIFT))

#define  IO_PAD36_PIOCFG_SLP_SEL_MASK 0x8
#define  IO_PAD36_PIOCFG_SLP_SEL_SHIFT 3
#define  IO_PAD36_PIOCFG_SLP_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD36_PIOCFG_SLP_SEL_MASK) >> IO_PAD36_PIOCFG_SLP_SEL_SHIFT)
#define  IO_PAD36_PIOCFG_SLP_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD36_PIOCFG_SLP_SEL_MASK) | (((uint32_t)val) << IO_PAD36_PIOCFG_SLP_SEL_SHIFT))

#define  IO_PAD36_PIOCFG_FUNC_SEL_MASK 0x7
#define  IO_PAD36_PIOCFG_FUNC_SEL_SHIFT 0
#define  IO_PAD36_PIOCFG_FUNC_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD36_PIOCFG_FUNC_SEL_MASK) >> IO_PAD36_PIOCFG_FUNC_SEL_SHIFT)
#define  IO_PAD36_PIOCFG_FUNC_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD36_PIOCFG_FUNC_SEL_MASK) | (((uint32_t)val) << IO_PAD36_PIOCFG_FUNC_SEL_SHIFT))

//====================================================================
//
//Register File: IO_PAD37 Configuration Registers (IO_PAD37)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

//====================================================================
//Register: IO_PAD37 Configuration Register (PIOCFG)
/** \brief "PHI_PADXDC_SRC" Pad*/
//====================================================================

#define  IO_PAD37_PIOCFG_RESERVED1_MASK 0xfc000000
#define  IO_PAD37_PIOCFG_RESERVED1_SHIFT 26
#define  IO_PAD37_PIOCFG_RESERVED1_MASK_SHIFT(reg) (((reg) & IO_PAD37_PIOCFG_RESERVED1_MASK) >> IO_PAD37_PIOCFG_RESERVED1_SHIFT)
#define  IO_PAD37_PIOCFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD37_PIOCFG_RESERVED1_MASK) | (((uint32_t)val) << IO_PAD37_PIOCFG_RESERVED1_SHIFT))

#define  IO_PAD37_PIOCFG_PD_MASK 0x2000000
#define  IO_PAD37_PIOCFG_PD_SHIFT 25
#define  IO_PAD37_PIOCFG_PD_MASK_SHIFT(reg) (((reg) & IO_PAD37_PIOCFG_PD_MASK) >> IO_PAD37_PIOCFG_PD_SHIFT)
#define  IO_PAD37_PIOCFG_PD_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD37_PIOCFG_PD_MASK) | (((uint32_t)val) << IO_PAD37_PIOCFG_PD_SHIFT))

#define  IO_PAD37_PIOCFG_ODT_EN_MASK 0x1000000
#define  IO_PAD37_PIOCFG_ODT_EN_SHIFT 24
#define  IO_PAD37_PIOCFG_ODT_EN_MASK_SHIFT(reg) (((reg) & IO_PAD37_PIOCFG_ODT_EN_MASK) >> IO_PAD37_PIOCFG_ODT_EN_SHIFT)
#define  IO_PAD37_PIOCFG_ODT_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD37_PIOCFG_ODT_EN_MASK) | (((uint32_t)val) << IO_PAD37_PIOCFG_ODT_EN_SHIFT))

#define  IO_PAD37_PIOCFG_LED_EN_MASK 0x800000
#define  IO_PAD37_PIOCFG_LED_EN_SHIFT 23
#define  IO_PAD37_PIOCFG_LED_EN_MASK_SHIFT(reg) (((reg) & IO_PAD37_PIOCFG_LED_EN_MASK) >> IO_PAD37_PIOCFG_LED_EN_SHIFT)
#define  IO_PAD37_PIOCFG_LED_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD37_PIOCFG_LED_EN_MASK) | (((uint32_t)val) << IO_PAD37_PIOCFG_LED_EN_SHIFT))

#define  IO_PAD37_PIOCFG_I2C_SEL_MASK 0x600000
#define  IO_PAD37_PIOCFG_I2C_SEL_SHIFT 21
#define  IO_PAD37_PIOCFG_I2C_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD37_PIOCFG_I2C_SEL_MASK) >> IO_PAD37_PIOCFG_I2C_SEL_SHIFT)
#define  IO_PAD37_PIOCFG_I2C_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD37_PIOCFG_I2C_SEL_MASK) | (((uint32_t)val) << IO_PAD37_PIOCFG_I2C_SEL_SHIFT))

#define  IO_PAD37_PIOCFG_DGTBSEL_MASK 0x1e0000
#define  IO_PAD37_PIOCFG_DGTBSEL_SHIFT 17
#define  IO_PAD37_PIOCFG_DGTBSEL_MASK_SHIFT(reg) (((reg) & IO_PAD37_PIOCFG_DGTBSEL_MASK) >> IO_PAD37_PIOCFG_DGTBSEL_SHIFT)
#define  IO_PAD37_PIOCFG_DGTBSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD37_PIOCFG_DGTBSEL_MASK) | (((uint32_t)val) << IO_PAD37_PIOCFG_DGTBSEL_SHIFT))

#define  IO_PAD37_PIOCFG_RAWSEL_MASK 0x10000
#define  IO_PAD37_PIOCFG_RAWSEL_SHIFT 16
#define  IO_PAD37_PIOCFG_RAWSEL_MASK_SHIFT(reg) (((reg) & IO_PAD37_PIOCFG_RAWSEL_MASK) >> IO_PAD37_PIOCFG_RAWSEL_SHIFT)
#define  IO_PAD37_PIOCFG_RAWSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD37_PIOCFG_RAWSEL_MASK) | (((uint32_t)val) << IO_PAD37_PIOCFG_RAWSEL_SHIFT))

#define  IO_PAD37_PIOCFG_PULL_SEL_MASK 0x8000
#define  IO_PAD37_PIOCFG_PULL_SEL_SHIFT 15
#define  IO_PAD37_PIOCFG_PULL_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD37_PIOCFG_PULL_SEL_MASK) >> IO_PAD37_PIOCFG_PULL_SEL_SHIFT)
#define  IO_PAD37_PIOCFG_PULL_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD37_PIOCFG_PULL_SEL_MASK) | (((uint32_t)val) << IO_PAD37_PIOCFG_PULL_SEL_SHIFT))

#define  IO_PAD37_PIOCFG_PUEN_MASK 0x4000
#define  IO_PAD37_PIOCFG_PUEN_SHIFT 14
#define  IO_PAD37_PIOCFG_PUEN_MASK_SHIFT(reg) (((reg) & IO_PAD37_PIOCFG_PUEN_MASK) >> IO_PAD37_PIOCFG_PUEN_SHIFT)
#define  IO_PAD37_PIOCFG_PUEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD37_PIOCFG_PUEN_MASK) | (((uint32_t)val) << IO_PAD37_PIOCFG_PUEN_SHIFT))

#define  IO_PAD37_PIOCFG_PDEN_MASK 0x2000
#define  IO_PAD37_PIOCFG_PDEN_SHIFT 13
#define  IO_PAD37_PIOCFG_PDEN_MASK_SHIFT(reg) (((reg) & IO_PAD37_PIOCFG_PDEN_MASK) >> IO_PAD37_PIOCFG_PDEN_SHIFT)
#define  IO_PAD37_PIOCFG_PDEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD37_PIOCFG_PDEN_MASK) | (((uint32_t)val) << IO_PAD37_PIOCFG_PDEN_SHIFT))

#define  IO_PAD37_PIOCFG_SR_MASK 0x1800
#define  IO_PAD37_PIOCFG_SR_SHIFT 11
#define  IO_PAD37_PIOCFG_SR_MASK_SHIFT(reg) (((reg) & IO_PAD37_PIOCFG_SR_MASK) >> IO_PAD37_PIOCFG_SR_SHIFT)
#define  IO_PAD37_PIOCFG_SR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD37_PIOCFG_SR_MASK) | (((uint32_t)val) << IO_PAD37_PIOCFG_SR_SHIFT))

#define  IO_PAD37_PIOCFG_SLP_DI_MASK 0x400
#define  IO_PAD37_PIOCFG_SLP_DI_SHIFT 10
#define  IO_PAD37_PIOCFG_SLP_DI_MASK_SHIFT(reg) (((reg) & IO_PAD37_PIOCFG_SLP_DI_MASK) >> IO_PAD37_PIOCFG_SLP_DI_SHIFT)
#define  IO_PAD37_PIOCFG_SLP_DI_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD37_PIOCFG_SLP_DI_MASK) | (((uint32_t)val) << IO_PAD37_PIOCFG_SLP_DI_SHIFT))

#define  IO_PAD37_PIOCFG_SLP_CNTRL_MASK 0x200
#define  IO_PAD37_PIOCFG_SLP_CNTRL_SHIFT 9
#define  IO_PAD37_PIOCFG_SLP_CNTRL_MASK_SHIFT(reg) (((reg) & IO_PAD37_PIOCFG_SLP_CNTRL_MASK) >> IO_PAD37_PIOCFG_SLP_CNTRL_SHIFT)
#define  IO_PAD37_PIOCFG_SLP_CNTRL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD37_PIOCFG_SLP_CNTRL_MASK) | (((uint32_t)val) << IO_PAD37_PIOCFG_SLP_CNTRL_SHIFT))

#define  IO_PAD37_PIOCFG_SLP_DO_MASK 0x100
#define  IO_PAD37_PIOCFG_SLP_DO_SHIFT 8
#define  IO_PAD37_PIOCFG_SLP_DO_MASK_SHIFT(reg) (((reg) & IO_PAD37_PIOCFG_SLP_DO_MASK) >> IO_PAD37_PIOCFG_SLP_DO_SHIFT)
#define  IO_PAD37_PIOCFG_SLP_DO_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD37_PIOCFG_SLP_DO_MASK) | (((uint32_t)val) << IO_PAD37_PIOCFG_SLP_DO_SHIFT))

#define  IO_PAD37_PIOCFG_SLP_DIR_MASK 0x80
#define  IO_PAD37_PIOCFG_SLP_DIR_SHIFT 7
#define  IO_PAD37_PIOCFG_SLP_DIR_MASK_SHIFT(reg) (((reg) & IO_PAD37_PIOCFG_SLP_DIR_MASK) >> IO_PAD37_PIOCFG_SLP_DIR_SHIFT)
#define  IO_PAD37_PIOCFG_SLP_DIR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD37_PIOCFG_SLP_DIR_MASK) | (((uint32_t)val) << IO_PAD37_PIOCFG_SLP_DIR_SHIFT))

#define  IO_PAD37_PIOCFG_EDGE_EN_N_MASK 0x40
#define  IO_PAD37_PIOCFG_EDGE_EN_N_SHIFT 6
#define  IO_PAD37_PIOCFG_EDGE_EN_N_MASK_SHIFT(reg) (((reg) & IO_PAD37_PIOCFG_EDGE_EN_N_MASK) >> IO_PAD37_PIOCFG_EDGE_EN_N_SHIFT)
#define  IO_PAD37_PIOCFG_EDGE_EN_N_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD37_PIOCFG_EDGE_EN_N_MASK) | (((uint32_t)val) << IO_PAD37_PIOCFG_EDGE_EN_N_SHIFT))

#define  IO_PAD37_PIOCFG_EDGE_FALL_EN_MASK 0x20
#define  IO_PAD37_PIOCFG_EDGE_FALL_EN_SHIFT 5
#define  IO_PAD37_PIOCFG_EDGE_FALL_EN_MASK_SHIFT(reg) (((reg) & IO_PAD37_PIOCFG_EDGE_FALL_EN_MASK) >> IO_PAD37_PIOCFG_EDGE_FALL_EN_SHIFT)
#define  IO_PAD37_PIOCFG_EDGE_FALL_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD37_PIOCFG_EDGE_FALL_EN_MASK) | (((uint32_t)val) << IO_PAD37_PIOCFG_EDGE_FALL_EN_SHIFT))

#define  IO_PAD37_PIOCFG_EDGE_RISE_EN_MASK 0x10
#define  IO_PAD37_PIOCFG_EDGE_RISE_EN_SHIFT 4
#define  IO_PAD37_PIOCFG_EDGE_RISE_EN_MASK_SHIFT(reg) (((reg) & IO_PAD37_PIOCFG_EDGE_RISE_EN_MASK) >> IO_PAD37_PIOCFG_EDGE_RISE_EN_SHIFT)
#define  IO_PAD37_PIOCFG_EDGE_RISE_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD37_PIOCFG_EDGE_RISE_EN_MASK) | (((uint32_t)val) << IO_PAD37_PIOCFG_EDGE_RISE_EN_SHIFT))

#define  IO_PAD37_PIOCFG_SLP_SEL_MASK 0x8
#define  IO_PAD37_PIOCFG_SLP_SEL_SHIFT 3
#define  IO_PAD37_PIOCFG_SLP_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD37_PIOCFG_SLP_SEL_MASK) >> IO_PAD37_PIOCFG_SLP_SEL_SHIFT)
#define  IO_PAD37_PIOCFG_SLP_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD37_PIOCFG_SLP_SEL_MASK) | (((uint32_t)val) << IO_PAD37_PIOCFG_SLP_SEL_SHIFT))

#define  IO_PAD37_PIOCFG_FUNC_SEL_MASK 0x7
#define  IO_PAD37_PIOCFG_FUNC_SEL_SHIFT 0
#define  IO_PAD37_PIOCFG_FUNC_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD37_PIOCFG_FUNC_SEL_MASK) >> IO_PAD37_PIOCFG_FUNC_SEL_SHIFT)
#define  IO_PAD37_PIOCFG_FUNC_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD37_PIOCFG_FUNC_SEL_MASK) | (((uint32_t)val) << IO_PAD37_PIOCFG_FUNC_SEL_SHIFT))

//====================================================================
//
//Register File: IO_PAD38 Configuration Registers (IO_PAD38)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

//====================================================================
//Register: IO_PAD38 Configuration Register (PIOCFG)
/** \brief "PHI_PADXDC_SRC" Pad*/
//====================================================================

#define  IO_PAD38_PIOCFG_RESERVED1_MASK 0xfc000000
#define  IO_PAD38_PIOCFG_RESERVED1_SHIFT 26
#define  IO_PAD38_PIOCFG_RESERVED1_MASK_SHIFT(reg) (((reg) & IO_PAD38_PIOCFG_RESERVED1_MASK) >> IO_PAD38_PIOCFG_RESERVED1_SHIFT)
#define  IO_PAD38_PIOCFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD38_PIOCFG_RESERVED1_MASK) | (((uint32_t)val) << IO_PAD38_PIOCFG_RESERVED1_SHIFT))

#define  IO_PAD38_PIOCFG_PD_MASK 0x2000000
#define  IO_PAD38_PIOCFG_PD_SHIFT 25
#define  IO_PAD38_PIOCFG_PD_MASK_SHIFT(reg) (((reg) & IO_PAD38_PIOCFG_PD_MASK) >> IO_PAD38_PIOCFG_PD_SHIFT)
#define  IO_PAD38_PIOCFG_PD_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD38_PIOCFG_PD_MASK) | (((uint32_t)val) << IO_PAD38_PIOCFG_PD_SHIFT))

#define  IO_PAD38_PIOCFG_ODT_EN_MASK 0x1000000
#define  IO_PAD38_PIOCFG_ODT_EN_SHIFT 24
#define  IO_PAD38_PIOCFG_ODT_EN_MASK_SHIFT(reg) (((reg) & IO_PAD38_PIOCFG_ODT_EN_MASK) >> IO_PAD38_PIOCFG_ODT_EN_SHIFT)
#define  IO_PAD38_PIOCFG_ODT_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD38_PIOCFG_ODT_EN_MASK) | (((uint32_t)val) << IO_PAD38_PIOCFG_ODT_EN_SHIFT))

#define  IO_PAD38_PIOCFG_LED_EN_MASK 0x800000
#define  IO_PAD38_PIOCFG_LED_EN_SHIFT 23
#define  IO_PAD38_PIOCFG_LED_EN_MASK_SHIFT(reg) (((reg) & IO_PAD38_PIOCFG_LED_EN_MASK) >> IO_PAD38_PIOCFG_LED_EN_SHIFT)
#define  IO_PAD38_PIOCFG_LED_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD38_PIOCFG_LED_EN_MASK) | (((uint32_t)val) << IO_PAD38_PIOCFG_LED_EN_SHIFT))

#define  IO_PAD38_PIOCFG_I2C_SEL_MASK 0x600000
#define  IO_PAD38_PIOCFG_I2C_SEL_SHIFT 21
#define  IO_PAD38_PIOCFG_I2C_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD38_PIOCFG_I2C_SEL_MASK) >> IO_PAD38_PIOCFG_I2C_SEL_SHIFT)
#define  IO_PAD38_PIOCFG_I2C_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD38_PIOCFG_I2C_SEL_MASK) | (((uint32_t)val) << IO_PAD38_PIOCFG_I2C_SEL_SHIFT))

#define  IO_PAD38_PIOCFG_DGTBSEL_MASK 0x1e0000
#define  IO_PAD38_PIOCFG_DGTBSEL_SHIFT 17
#define  IO_PAD38_PIOCFG_DGTBSEL_MASK_SHIFT(reg) (((reg) & IO_PAD38_PIOCFG_DGTBSEL_MASK) >> IO_PAD38_PIOCFG_DGTBSEL_SHIFT)
#define  IO_PAD38_PIOCFG_DGTBSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD38_PIOCFG_DGTBSEL_MASK) | (((uint32_t)val) << IO_PAD38_PIOCFG_DGTBSEL_SHIFT))

#define  IO_PAD38_PIOCFG_RAWSEL_MASK 0x10000
#define  IO_PAD38_PIOCFG_RAWSEL_SHIFT 16
#define  IO_PAD38_PIOCFG_RAWSEL_MASK_SHIFT(reg) (((reg) & IO_PAD38_PIOCFG_RAWSEL_MASK) >> IO_PAD38_PIOCFG_RAWSEL_SHIFT)
#define  IO_PAD38_PIOCFG_RAWSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD38_PIOCFG_RAWSEL_MASK) | (((uint32_t)val) << IO_PAD38_PIOCFG_RAWSEL_SHIFT))

#define  IO_PAD38_PIOCFG_PULL_SEL_MASK 0x8000
#define  IO_PAD38_PIOCFG_PULL_SEL_SHIFT 15
#define  IO_PAD38_PIOCFG_PULL_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD38_PIOCFG_PULL_SEL_MASK) >> IO_PAD38_PIOCFG_PULL_SEL_SHIFT)
#define  IO_PAD38_PIOCFG_PULL_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD38_PIOCFG_PULL_SEL_MASK) | (((uint32_t)val) << IO_PAD38_PIOCFG_PULL_SEL_SHIFT))

#define  IO_PAD38_PIOCFG_PUEN_MASK 0x4000
#define  IO_PAD38_PIOCFG_PUEN_SHIFT 14
#define  IO_PAD38_PIOCFG_PUEN_MASK_SHIFT(reg) (((reg) & IO_PAD38_PIOCFG_PUEN_MASK) >> IO_PAD38_PIOCFG_PUEN_SHIFT)
#define  IO_PAD38_PIOCFG_PUEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD38_PIOCFG_PUEN_MASK) | (((uint32_t)val) << IO_PAD38_PIOCFG_PUEN_SHIFT))

#define  IO_PAD38_PIOCFG_PDEN_MASK 0x2000
#define  IO_PAD38_PIOCFG_PDEN_SHIFT 13
#define  IO_PAD38_PIOCFG_PDEN_MASK_SHIFT(reg) (((reg) & IO_PAD38_PIOCFG_PDEN_MASK) >> IO_PAD38_PIOCFG_PDEN_SHIFT)
#define  IO_PAD38_PIOCFG_PDEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD38_PIOCFG_PDEN_MASK) | (((uint32_t)val) << IO_PAD38_PIOCFG_PDEN_SHIFT))

#define  IO_PAD38_PIOCFG_SR_MASK 0x1800
#define  IO_PAD38_PIOCFG_SR_SHIFT 11
#define  IO_PAD38_PIOCFG_SR_MASK_SHIFT(reg) (((reg) & IO_PAD38_PIOCFG_SR_MASK) >> IO_PAD38_PIOCFG_SR_SHIFT)
#define  IO_PAD38_PIOCFG_SR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD38_PIOCFG_SR_MASK) | (((uint32_t)val) << IO_PAD38_PIOCFG_SR_SHIFT))

#define  IO_PAD38_PIOCFG_SLP_DI_MASK 0x400
#define  IO_PAD38_PIOCFG_SLP_DI_SHIFT 10
#define  IO_PAD38_PIOCFG_SLP_DI_MASK_SHIFT(reg) (((reg) & IO_PAD38_PIOCFG_SLP_DI_MASK) >> IO_PAD38_PIOCFG_SLP_DI_SHIFT)
#define  IO_PAD38_PIOCFG_SLP_DI_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD38_PIOCFG_SLP_DI_MASK) | (((uint32_t)val) << IO_PAD38_PIOCFG_SLP_DI_SHIFT))

#define  IO_PAD38_PIOCFG_SLP_CNTRL_MASK 0x200
#define  IO_PAD38_PIOCFG_SLP_CNTRL_SHIFT 9
#define  IO_PAD38_PIOCFG_SLP_CNTRL_MASK_SHIFT(reg) (((reg) & IO_PAD38_PIOCFG_SLP_CNTRL_MASK) >> IO_PAD38_PIOCFG_SLP_CNTRL_SHIFT)
#define  IO_PAD38_PIOCFG_SLP_CNTRL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD38_PIOCFG_SLP_CNTRL_MASK) | (((uint32_t)val) << IO_PAD38_PIOCFG_SLP_CNTRL_SHIFT))

#define  IO_PAD38_PIOCFG_SLP_DO_MASK 0x100
#define  IO_PAD38_PIOCFG_SLP_DO_SHIFT 8
#define  IO_PAD38_PIOCFG_SLP_DO_MASK_SHIFT(reg) (((reg) & IO_PAD38_PIOCFG_SLP_DO_MASK) >> IO_PAD38_PIOCFG_SLP_DO_SHIFT)
#define  IO_PAD38_PIOCFG_SLP_DO_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD38_PIOCFG_SLP_DO_MASK) | (((uint32_t)val) << IO_PAD38_PIOCFG_SLP_DO_SHIFT))

#define  IO_PAD38_PIOCFG_SLP_DIR_MASK 0x80
#define  IO_PAD38_PIOCFG_SLP_DIR_SHIFT 7
#define  IO_PAD38_PIOCFG_SLP_DIR_MASK_SHIFT(reg) (((reg) & IO_PAD38_PIOCFG_SLP_DIR_MASK) >> IO_PAD38_PIOCFG_SLP_DIR_SHIFT)
#define  IO_PAD38_PIOCFG_SLP_DIR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD38_PIOCFG_SLP_DIR_MASK) | (((uint32_t)val) << IO_PAD38_PIOCFG_SLP_DIR_SHIFT))

#define  IO_PAD38_PIOCFG_EDGE_EN_N_MASK 0x40
#define  IO_PAD38_PIOCFG_EDGE_EN_N_SHIFT 6
#define  IO_PAD38_PIOCFG_EDGE_EN_N_MASK_SHIFT(reg) (((reg) & IO_PAD38_PIOCFG_EDGE_EN_N_MASK) >> IO_PAD38_PIOCFG_EDGE_EN_N_SHIFT)
#define  IO_PAD38_PIOCFG_EDGE_EN_N_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD38_PIOCFG_EDGE_EN_N_MASK) | (((uint32_t)val) << IO_PAD38_PIOCFG_EDGE_EN_N_SHIFT))

#define  IO_PAD38_PIOCFG_EDGE_FALL_EN_MASK 0x20
#define  IO_PAD38_PIOCFG_EDGE_FALL_EN_SHIFT 5
#define  IO_PAD38_PIOCFG_EDGE_FALL_EN_MASK_SHIFT(reg) (((reg) & IO_PAD38_PIOCFG_EDGE_FALL_EN_MASK) >> IO_PAD38_PIOCFG_EDGE_FALL_EN_SHIFT)
#define  IO_PAD38_PIOCFG_EDGE_FALL_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD38_PIOCFG_EDGE_FALL_EN_MASK) | (((uint32_t)val) << IO_PAD38_PIOCFG_EDGE_FALL_EN_SHIFT))

#define  IO_PAD38_PIOCFG_EDGE_RISE_EN_MASK 0x10
#define  IO_PAD38_PIOCFG_EDGE_RISE_EN_SHIFT 4
#define  IO_PAD38_PIOCFG_EDGE_RISE_EN_MASK_SHIFT(reg) (((reg) & IO_PAD38_PIOCFG_EDGE_RISE_EN_MASK) >> IO_PAD38_PIOCFG_EDGE_RISE_EN_SHIFT)
#define  IO_PAD38_PIOCFG_EDGE_RISE_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD38_PIOCFG_EDGE_RISE_EN_MASK) | (((uint32_t)val) << IO_PAD38_PIOCFG_EDGE_RISE_EN_SHIFT))

#define  IO_PAD38_PIOCFG_SLP_SEL_MASK 0x8
#define  IO_PAD38_PIOCFG_SLP_SEL_SHIFT 3
#define  IO_PAD38_PIOCFG_SLP_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD38_PIOCFG_SLP_SEL_MASK) >> IO_PAD38_PIOCFG_SLP_SEL_SHIFT)
#define  IO_PAD38_PIOCFG_SLP_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD38_PIOCFG_SLP_SEL_MASK) | (((uint32_t)val) << IO_PAD38_PIOCFG_SLP_SEL_SHIFT))

#define  IO_PAD38_PIOCFG_FUNC_SEL_MASK 0x7
#define  IO_PAD38_PIOCFG_FUNC_SEL_SHIFT 0
#define  IO_PAD38_PIOCFG_FUNC_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD38_PIOCFG_FUNC_SEL_MASK) >> IO_PAD38_PIOCFG_FUNC_SEL_SHIFT)
#define  IO_PAD38_PIOCFG_FUNC_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD38_PIOCFG_FUNC_SEL_MASK) | (((uint32_t)val) << IO_PAD38_PIOCFG_FUNC_SEL_SHIFT))

//====================================================================
//
//Register File: IO_PAD39 Configuration Registers (IO_PAD39)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

//====================================================================
//Register: IO_PAD39 Configuration Register (PIOCFG)
/** \brief "PHI_PADXDC_SRC" Pad*/
//====================================================================

#define  IO_PAD39_PIOCFG_RESERVED1_MASK 0xfc000000
#define  IO_PAD39_PIOCFG_RESERVED1_SHIFT 26
#define  IO_PAD39_PIOCFG_RESERVED1_MASK_SHIFT(reg) (((reg) & IO_PAD39_PIOCFG_RESERVED1_MASK) >> IO_PAD39_PIOCFG_RESERVED1_SHIFT)
#define  IO_PAD39_PIOCFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD39_PIOCFG_RESERVED1_MASK) | (((uint32_t)val) << IO_PAD39_PIOCFG_RESERVED1_SHIFT))

#define  IO_PAD39_PIOCFG_PD_MASK 0x2000000
#define  IO_PAD39_PIOCFG_PD_SHIFT 25
#define  IO_PAD39_PIOCFG_PD_MASK_SHIFT(reg) (((reg) & IO_PAD39_PIOCFG_PD_MASK) >> IO_PAD39_PIOCFG_PD_SHIFT)
#define  IO_PAD39_PIOCFG_PD_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD39_PIOCFG_PD_MASK) | (((uint32_t)val) << IO_PAD39_PIOCFG_PD_SHIFT))

#define  IO_PAD39_PIOCFG_ODT_EN_MASK 0x1000000
#define  IO_PAD39_PIOCFG_ODT_EN_SHIFT 24
#define  IO_PAD39_PIOCFG_ODT_EN_MASK_SHIFT(reg) (((reg) & IO_PAD39_PIOCFG_ODT_EN_MASK) >> IO_PAD39_PIOCFG_ODT_EN_SHIFT)
#define  IO_PAD39_PIOCFG_ODT_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD39_PIOCFG_ODT_EN_MASK) | (((uint32_t)val) << IO_PAD39_PIOCFG_ODT_EN_SHIFT))

#define  IO_PAD39_PIOCFG_LED_EN_MASK 0x800000
#define  IO_PAD39_PIOCFG_LED_EN_SHIFT 23
#define  IO_PAD39_PIOCFG_LED_EN_MASK_SHIFT(reg) (((reg) & IO_PAD39_PIOCFG_LED_EN_MASK) >> IO_PAD39_PIOCFG_LED_EN_SHIFT)
#define  IO_PAD39_PIOCFG_LED_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD39_PIOCFG_LED_EN_MASK) | (((uint32_t)val) << IO_PAD39_PIOCFG_LED_EN_SHIFT))

#define  IO_PAD39_PIOCFG_I2C_SEL_MASK 0x600000
#define  IO_PAD39_PIOCFG_I2C_SEL_SHIFT 21
#define  IO_PAD39_PIOCFG_I2C_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD39_PIOCFG_I2C_SEL_MASK) >> IO_PAD39_PIOCFG_I2C_SEL_SHIFT)
#define  IO_PAD39_PIOCFG_I2C_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD39_PIOCFG_I2C_SEL_MASK) | (((uint32_t)val) << IO_PAD39_PIOCFG_I2C_SEL_SHIFT))

#define  IO_PAD39_PIOCFG_DGTBSEL_MASK 0x1e0000
#define  IO_PAD39_PIOCFG_DGTBSEL_SHIFT 17
#define  IO_PAD39_PIOCFG_DGTBSEL_MASK_SHIFT(reg) (((reg) & IO_PAD39_PIOCFG_DGTBSEL_MASK) >> IO_PAD39_PIOCFG_DGTBSEL_SHIFT)
#define  IO_PAD39_PIOCFG_DGTBSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD39_PIOCFG_DGTBSEL_MASK) | (((uint32_t)val) << IO_PAD39_PIOCFG_DGTBSEL_SHIFT))

#define  IO_PAD39_PIOCFG_RAWSEL_MASK 0x10000
#define  IO_PAD39_PIOCFG_RAWSEL_SHIFT 16
#define  IO_PAD39_PIOCFG_RAWSEL_MASK_SHIFT(reg) (((reg) & IO_PAD39_PIOCFG_RAWSEL_MASK) >> IO_PAD39_PIOCFG_RAWSEL_SHIFT)
#define  IO_PAD39_PIOCFG_RAWSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD39_PIOCFG_RAWSEL_MASK) | (((uint32_t)val) << IO_PAD39_PIOCFG_RAWSEL_SHIFT))

#define  IO_PAD39_PIOCFG_PULL_SEL_MASK 0x8000
#define  IO_PAD39_PIOCFG_PULL_SEL_SHIFT 15
#define  IO_PAD39_PIOCFG_PULL_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD39_PIOCFG_PULL_SEL_MASK) >> IO_PAD39_PIOCFG_PULL_SEL_SHIFT)
#define  IO_PAD39_PIOCFG_PULL_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD39_PIOCFG_PULL_SEL_MASK) | (((uint32_t)val) << IO_PAD39_PIOCFG_PULL_SEL_SHIFT))

#define  IO_PAD39_PIOCFG_PUEN_MASK 0x4000
#define  IO_PAD39_PIOCFG_PUEN_SHIFT 14
#define  IO_PAD39_PIOCFG_PUEN_MASK_SHIFT(reg) (((reg) & IO_PAD39_PIOCFG_PUEN_MASK) >> IO_PAD39_PIOCFG_PUEN_SHIFT)
#define  IO_PAD39_PIOCFG_PUEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD39_PIOCFG_PUEN_MASK) | (((uint32_t)val) << IO_PAD39_PIOCFG_PUEN_SHIFT))

#define  IO_PAD39_PIOCFG_PDEN_MASK 0x2000
#define  IO_PAD39_PIOCFG_PDEN_SHIFT 13
#define  IO_PAD39_PIOCFG_PDEN_MASK_SHIFT(reg) (((reg) & IO_PAD39_PIOCFG_PDEN_MASK) >> IO_PAD39_PIOCFG_PDEN_SHIFT)
#define  IO_PAD39_PIOCFG_PDEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD39_PIOCFG_PDEN_MASK) | (((uint32_t)val) << IO_PAD39_PIOCFG_PDEN_SHIFT))

#define  IO_PAD39_PIOCFG_SR_MASK 0x1800
#define  IO_PAD39_PIOCFG_SR_SHIFT 11
#define  IO_PAD39_PIOCFG_SR_MASK_SHIFT(reg) (((reg) & IO_PAD39_PIOCFG_SR_MASK) >> IO_PAD39_PIOCFG_SR_SHIFT)
#define  IO_PAD39_PIOCFG_SR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD39_PIOCFG_SR_MASK) | (((uint32_t)val) << IO_PAD39_PIOCFG_SR_SHIFT))

#define  IO_PAD39_PIOCFG_SLP_DI_MASK 0x400
#define  IO_PAD39_PIOCFG_SLP_DI_SHIFT 10
#define  IO_PAD39_PIOCFG_SLP_DI_MASK_SHIFT(reg) (((reg) & IO_PAD39_PIOCFG_SLP_DI_MASK) >> IO_PAD39_PIOCFG_SLP_DI_SHIFT)
#define  IO_PAD39_PIOCFG_SLP_DI_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD39_PIOCFG_SLP_DI_MASK) | (((uint32_t)val) << IO_PAD39_PIOCFG_SLP_DI_SHIFT))

#define  IO_PAD39_PIOCFG_SLP_CNTRL_MASK 0x200
#define  IO_PAD39_PIOCFG_SLP_CNTRL_SHIFT 9
#define  IO_PAD39_PIOCFG_SLP_CNTRL_MASK_SHIFT(reg) (((reg) & IO_PAD39_PIOCFG_SLP_CNTRL_MASK) >> IO_PAD39_PIOCFG_SLP_CNTRL_SHIFT)
#define  IO_PAD39_PIOCFG_SLP_CNTRL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD39_PIOCFG_SLP_CNTRL_MASK) | (((uint32_t)val) << IO_PAD39_PIOCFG_SLP_CNTRL_SHIFT))

#define  IO_PAD39_PIOCFG_SLP_DO_MASK 0x100
#define  IO_PAD39_PIOCFG_SLP_DO_SHIFT 8
#define  IO_PAD39_PIOCFG_SLP_DO_MASK_SHIFT(reg) (((reg) & IO_PAD39_PIOCFG_SLP_DO_MASK) >> IO_PAD39_PIOCFG_SLP_DO_SHIFT)
#define  IO_PAD39_PIOCFG_SLP_DO_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD39_PIOCFG_SLP_DO_MASK) | (((uint32_t)val) << IO_PAD39_PIOCFG_SLP_DO_SHIFT))

#define  IO_PAD39_PIOCFG_SLP_DIR_MASK 0x80
#define  IO_PAD39_PIOCFG_SLP_DIR_SHIFT 7
#define  IO_PAD39_PIOCFG_SLP_DIR_MASK_SHIFT(reg) (((reg) & IO_PAD39_PIOCFG_SLP_DIR_MASK) >> IO_PAD39_PIOCFG_SLP_DIR_SHIFT)
#define  IO_PAD39_PIOCFG_SLP_DIR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD39_PIOCFG_SLP_DIR_MASK) | (((uint32_t)val) << IO_PAD39_PIOCFG_SLP_DIR_SHIFT))

#define  IO_PAD39_PIOCFG_EDGE_EN_N_MASK 0x40
#define  IO_PAD39_PIOCFG_EDGE_EN_N_SHIFT 6
#define  IO_PAD39_PIOCFG_EDGE_EN_N_MASK_SHIFT(reg) (((reg) & IO_PAD39_PIOCFG_EDGE_EN_N_MASK) >> IO_PAD39_PIOCFG_EDGE_EN_N_SHIFT)
#define  IO_PAD39_PIOCFG_EDGE_EN_N_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD39_PIOCFG_EDGE_EN_N_MASK) | (((uint32_t)val) << IO_PAD39_PIOCFG_EDGE_EN_N_SHIFT))

#define  IO_PAD39_PIOCFG_EDGE_FALL_EN_MASK 0x20
#define  IO_PAD39_PIOCFG_EDGE_FALL_EN_SHIFT 5
#define  IO_PAD39_PIOCFG_EDGE_FALL_EN_MASK_SHIFT(reg) (((reg) & IO_PAD39_PIOCFG_EDGE_FALL_EN_MASK) >> IO_PAD39_PIOCFG_EDGE_FALL_EN_SHIFT)
#define  IO_PAD39_PIOCFG_EDGE_FALL_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD39_PIOCFG_EDGE_FALL_EN_MASK) | (((uint32_t)val) << IO_PAD39_PIOCFG_EDGE_FALL_EN_SHIFT))

#define  IO_PAD39_PIOCFG_EDGE_RISE_EN_MASK 0x10
#define  IO_PAD39_PIOCFG_EDGE_RISE_EN_SHIFT 4
#define  IO_PAD39_PIOCFG_EDGE_RISE_EN_MASK_SHIFT(reg) (((reg) & IO_PAD39_PIOCFG_EDGE_RISE_EN_MASK) >> IO_PAD39_PIOCFG_EDGE_RISE_EN_SHIFT)
#define  IO_PAD39_PIOCFG_EDGE_RISE_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD39_PIOCFG_EDGE_RISE_EN_MASK) | (((uint32_t)val) << IO_PAD39_PIOCFG_EDGE_RISE_EN_SHIFT))

#define  IO_PAD39_PIOCFG_SLP_SEL_MASK 0x8
#define  IO_PAD39_PIOCFG_SLP_SEL_SHIFT 3
#define  IO_PAD39_PIOCFG_SLP_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD39_PIOCFG_SLP_SEL_MASK) >> IO_PAD39_PIOCFG_SLP_SEL_SHIFT)
#define  IO_PAD39_PIOCFG_SLP_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD39_PIOCFG_SLP_SEL_MASK) | (((uint32_t)val) << IO_PAD39_PIOCFG_SLP_SEL_SHIFT))

#define  IO_PAD39_PIOCFG_FUNC_SEL_MASK 0x7
#define  IO_PAD39_PIOCFG_FUNC_SEL_SHIFT 0
#define  IO_PAD39_PIOCFG_FUNC_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD39_PIOCFG_FUNC_SEL_MASK) >> IO_PAD39_PIOCFG_FUNC_SEL_SHIFT)
#define  IO_PAD39_PIOCFG_FUNC_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD39_PIOCFG_FUNC_SEL_MASK) | (((uint32_t)val) << IO_PAD39_PIOCFG_FUNC_SEL_SHIFT))

//====================================================================
//
//Register File: IO_PAD40 Configuration Registers (IO_PAD40)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

//====================================================================
//Register: IO_PAD40 Configuration Register (PIOCFG)
/** \brief "PHI_PADXDC_SRC" Pad*/
//====================================================================

#define  IO_PAD40_PIOCFG_RESERVED1_MASK 0xfc000000
#define  IO_PAD40_PIOCFG_RESERVED1_SHIFT 26
#define  IO_PAD40_PIOCFG_RESERVED1_MASK_SHIFT(reg) (((reg) & IO_PAD40_PIOCFG_RESERVED1_MASK) >> IO_PAD40_PIOCFG_RESERVED1_SHIFT)
#define  IO_PAD40_PIOCFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD40_PIOCFG_RESERVED1_MASK) | (((uint32_t)val) << IO_PAD40_PIOCFG_RESERVED1_SHIFT))

#define  IO_PAD40_PIOCFG_PD_MASK 0x2000000
#define  IO_PAD40_PIOCFG_PD_SHIFT 25
#define  IO_PAD40_PIOCFG_PD_MASK_SHIFT(reg) (((reg) & IO_PAD40_PIOCFG_PD_MASK) >> IO_PAD40_PIOCFG_PD_SHIFT)
#define  IO_PAD40_PIOCFG_PD_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD40_PIOCFG_PD_MASK) | (((uint32_t)val) << IO_PAD40_PIOCFG_PD_SHIFT))

#define  IO_PAD40_PIOCFG_ODT_EN_MASK 0x1000000
#define  IO_PAD40_PIOCFG_ODT_EN_SHIFT 24
#define  IO_PAD40_PIOCFG_ODT_EN_MASK_SHIFT(reg) (((reg) & IO_PAD40_PIOCFG_ODT_EN_MASK) >> IO_PAD40_PIOCFG_ODT_EN_SHIFT)
#define  IO_PAD40_PIOCFG_ODT_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD40_PIOCFG_ODT_EN_MASK) | (((uint32_t)val) << IO_PAD40_PIOCFG_ODT_EN_SHIFT))

#define  IO_PAD40_PIOCFG_LED_EN_MASK 0x800000
#define  IO_PAD40_PIOCFG_LED_EN_SHIFT 23
#define  IO_PAD40_PIOCFG_LED_EN_MASK_SHIFT(reg) (((reg) & IO_PAD40_PIOCFG_LED_EN_MASK) >> IO_PAD40_PIOCFG_LED_EN_SHIFT)
#define  IO_PAD40_PIOCFG_LED_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD40_PIOCFG_LED_EN_MASK) | (((uint32_t)val) << IO_PAD40_PIOCFG_LED_EN_SHIFT))

#define  IO_PAD40_PIOCFG_I2C_SEL_MASK 0x600000
#define  IO_PAD40_PIOCFG_I2C_SEL_SHIFT 21
#define  IO_PAD40_PIOCFG_I2C_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD40_PIOCFG_I2C_SEL_MASK) >> IO_PAD40_PIOCFG_I2C_SEL_SHIFT)
#define  IO_PAD40_PIOCFG_I2C_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD40_PIOCFG_I2C_SEL_MASK) | (((uint32_t)val) << IO_PAD40_PIOCFG_I2C_SEL_SHIFT))

#define  IO_PAD40_PIOCFG_DGTBSEL_MASK 0x1e0000
#define  IO_PAD40_PIOCFG_DGTBSEL_SHIFT 17
#define  IO_PAD40_PIOCFG_DGTBSEL_MASK_SHIFT(reg) (((reg) & IO_PAD40_PIOCFG_DGTBSEL_MASK) >> IO_PAD40_PIOCFG_DGTBSEL_SHIFT)
#define  IO_PAD40_PIOCFG_DGTBSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD40_PIOCFG_DGTBSEL_MASK) | (((uint32_t)val) << IO_PAD40_PIOCFG_DGTBSEL_SHIFT))

#define  IO_PAD40_PIOCFG_RAWSEL_MASK 0x10000
#define  IO_PAD40_PIOCFG_RAWSEL_SHIFT 16
#define  IO_PAD40_PIOCFG_RAWSEL_MASK_SHIFT(reg) (((reg) & IO_PAD40_PIOCFG_RAWSEL_MASK) >> IO_PAD40_PIOCFG_RAWSEL_SHIFT)
#define  IO_PAD40_PIOCFG_RAWSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD40_PIOCFG_RAWSEL_MASK) | (((uint32_t)val) << IO_PAD40_PIOCFG_RAWSEL_SHIFT))

#define  IO_PAD40_PIOCFG_PULL_SEL_MASK 0x8000
#define  IO_PAD40_PIOCFG_PULL_SEL_SHIFT 15
#define  IO_PAD40_PIOCFG_PULL_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD40_PIOCFG_PULL_SEL_MASK) >> IO_PAD40_PIOCFG_PULL_SEL_SHIFT)
#define  IO_PAD40_PIOCFG_PULL_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD40_PIOCFG_PULL_SEL_MASK) | (((uint32_t)val) << IO_PAD40_PIOCFG_PULL_SEL_SHIFT))

#define  IO_PAD40_PIOCFG_PUEN_MASK 0x4000
#define  IO_PAD40_PIOCFG_PUEN_SHIFT 14
#define  IO_PAD40_PIOCFG_PUEN_MASK_SHIFT(reg) (((reg) & IO_PAD40_PIOCFG_PUEN_MASK) >> IO_PAD40_PIOCFG_PUEN_SHIFT)
#define  IO_PAD40_PIOCFG_PUEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD40_PIOCFG_PUEN_MASK) | (((uint32_t)val) << IO_PAD40_PIOCFG_PUEN_SHIFT))

#define  IO_PAD40_PIOCFG_PDEN_MASK 0x2000
#define  IO_PAD40_PIOCFG_PDEN_SHIFT 13
#define  IO_PAD40_PIOCFG_PDEN_MASK_SHIFT(reg) (((reg) & IO_PAD40_PIOCFG_PDEN_MASK) >> IO_PAD40_PIOCFG_PDEN_SHIFT)
#define  IO_PAD40_PIOCFG_PDEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD40_PIOCFG_PDEN_MASK) | (((uint32_t)val) << IO_PAD40_PIOCFG_PDEN_SHIFT))

#define  IO_PAD40_PIOCFG_SR_MASK 0x1800
#define  IO_PAD40_PIOCFG_SR_SHIFT 11
#define  IO_PAD40_PIOCFG_SR_MASK_SHIFT(reg) (((reg) & IO_PAD40_PIOCFG_SR_MASK) >> IO_PAD40_PIOCFG_SR_SHIFT)
#define  IO_PAD40_PIOCFG_SR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD40_PIOCFG_SR_MASK) | (((uint32_t)val) << IO_PAD40_PIOCFG_SR_SHIFT))

#define  IO_PAD40_PIOCFG_SLP_DI_MASK 0x400
#define  IO_PAD40_PIOCFG_SLP_DI_SHIFT 10
#define  IO_PAD40_PIOCFG_SLP_DI_MASK_SHIFT(reg) (((reg) & IO_PAD40_PIOCFG_SLP_DI_MASK) >> IO_PAD40_PIOCFG_SLP_DI_SHIFT)
#define  IO_PAD40_PIOCFG_SLP_DI_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD40_PIOCFG_SLP_DI_MASK) | (((uint32_t)val) << IO_PAD40_PIOCFG_SLP_DI_SHIFT))

#define  IO_PAD40_PIOCFG_SLP_CNTRL_MASK 0x200
#define  IO_PAD40_PIOCFG_SLP_CNTRL_SHIFT 9
#define  IO_PAD40_PIOCFG_SLP_CNTRL_MASK_SHIFT(reg) (((reg) & IO_PAD40_PIOCFG_SLP_CNTRL_MASK) >> IO_PAD40_PIOCFG_SLP_CNTRL_SHIFT)
#define  IO_PAD40_PIOCFG_SLP_CNTRL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD40_PIOCFG_SLP_CNTRL_MASK) | (((uint32_t)val) << IO_PAD40_PIOCFG_SLP_CNTRL_SHIFT))

#define  IO_PAD40_PIOCFG_SLP_DO_MASK 0x100
#define  IO_PAD40_PIOCFG_SLP_DO_SHIFT 8
#define  IO_PAD40_PIOCFG_SLP_DO_MASK_SHIFT(reg) (((reg) & IO_PAD40_PIOCFG_SLP_DO_MASK) >> IO_PAD40_PIOCFG_SLP_DO_SHIFT)
#define  IO_PAD40_PIOCFG_SLP_DO_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD40_PIOCFG_SLP_DO_MASK) | (((uint32_t)val) << IO_PAD40_PIOCFG_SLP_DO_SHIFT))

#define  IO_PAD40_PIOCFG_SLP_DIR_MASK 0x80
#define  IO_PAD40_PIOCFG_SLP_DIR_SHIFT 7
#define  IO_PAD40_PIOCFG_SLP_DIR_MASK_SHIFT(reg) (((reg) & IO_PAD40_PIOCFG_SLP_DIR_MASK) >> IO_PAD40_PIOCFG_SLP_DIR_SHIFT)
#define  IO_PAD40_PIOCFG_SLP_DIR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD40_PIOCFG_SLP_DIR_MASK) | (((uint32_t)val) << IO_PAD40_PIOCFG_SLP_DIR_SHIFT))

#define  IO_PAD40_PIOCFG_EDGE_EN_N_MASK 0x40
#define  IO_PAD40_PIOCFG_EDGE_EN_N_SHIFT 6
#define  IO_PAD40_PIOCFG_EDGE_EN_N_MASK_SHIFT(reg) (((reg) & IO_PAD40_PIOCFG_EDGE_EN_N_MASK) >> IO_PAD40_PIOCFG_EDGE_EN_N_SHIFT)
#define  IO_PAD40_PIOCFG_EDGE_EN_N_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD40_PIOCFG_EDGE_EN_N_MASK) | (((uint32_t)val) << IO_PAD40_PIOCFG_EDGE_EN_N_SHIFT))

#define  IO_PAD40_PIOCFG_EDGE_FALL_EN_MASK 0x20
#define  IO_PAD40_PIOCFG_EDGE_FALL_EN_SHIFT 5
#define  IO_PAD40_PIOCFG_EDGE_FALL_EN_MASK_SHIFT(reg) (((reg) & IO_PAD40_PIOCFG_EDGE_FALL_EN_MASK) >> IO_PAD40_PIOCFG_EDGE_FALL_EN_SHIFT)
#define  IO_PAD40_PIOCFG_EDGE_FALL_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD40_PIOCFG_EDGE_FALL_EN_MASK) | (((uint32_t)val) << IO_PAD40_PIOCFG_EDGE_FALL_EN_SHIFT))

#define  IO_PAD40_PIOCFG_EDGE_RISE_EN_MASK 0x10
#define  IO_PAD40_PIOCFG_EDGE_RISE_EN_SHIFT 4
#define  IO_PAD40_PIOCFG_EDGE_RISE_EN_MASK_SHIFT(reg) (((reg) & IO_PAD40_PIOCFG_EDGE_RISE_EN_MASK) >> IO_PAD40_PIOCFG_EDGE_RISE_EN_SHIFT)
#define  IO_PAD40_PIOCFG_EDGE_RISE_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD40_PIOCFG_EDGE_RISE_EN_MASK) | (((uint32_t)val) << IO_PAD40_PIOCFG_EDGE_RISE_EN_SHIFT))

#define  IO_PAD40_PIOCFG_SLP_SEL_MASK 0x8
#define  IO_PAD40_PIOCFG_SLP_SEL_SHIFT 3
#define  IO_PAD40_PIOCFG_SLP_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD40_PIOCFG_SLP_SEL_MASK) >> IO_PAD40_PIOCFG_SLP_SEL_SHIFT)
#define  IO_PAD40_PIOCFG_SLP_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD40_PIOCFG_SLP_SEL_MASK) | (((uint32_t)val) << IO_PAD40_PIOCFG_SLP_SEL_SHIFT))

#define  IO_PAD40_PIOCFG_FUNC_SEL_MASK 0x7
#define  IO_PAD40_PIOCFG_FUNC_SEL_SHIFT 0
#define  IO_PAD40_PIOCFG_FUNC_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD40_PIOCFG_FUNC_SEL_MASK) >> IO_PAD40_PIOCFG_FUNC_SEL_SHIFT)
#define  IO_PAD40_PIOCFG_FUNC_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD40_PIOCFG_FUNC_SEL_MASK) | (((uint32_t)val) << IO_PAD40_PIOCFG_FUNC_SEL_SHIFT))

//====================================================================
//
//Register File: IO_PAD41 Configuration Registers (IO_PAD41)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

//====================================================================
//Register: IO_PAD41 Configuration Register (PIOCFG)
/** \brief "PHI_PADXDC_SRC" Pad*/
//====================================================================

#define  IO_PAD41_PIOCFG_RESERVED1_MASK 0xfc000000
#define  IO_PAD41_PIOCFG_RESERVED1_SHIFT 26
#define  IO_PAD41_PIOCFG_RESERVED1_MASK_SHIFT(reg) (((reg) & IO_PAD41_PIOCFG_RESERVED1_MASK) >> IO_PAD41_PIOCFG_RESERVED1_SHIFT)
#define  IO_PAD41_PIOCFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD41_PIOCFG_RESERVED1_MASK) | (((uint32_t)val) << IO_PAD41_PIOCFG_RESERVED1_SHIFT))

#define  IO_PAD41_PIOCFG_PD_MASK 0x2000000
#define  IO_PAD41_PIOCFG_PD_SHIFT 25
#define  IO_PAD41_PIOCFG_PD_MASK_SHIFT(reg) (((reg) & IO_PAD41_PIOCFG_PD_MASK) >> IO_PAD41_PIOCFG_PD_SHIFT)
#define  IO_PAD41_PIOCFG_PD_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD41_PIOCFG_PD_MASK) | (((uint32_t)val) << IO_PAD41_PIOCFG_PD_SHIFT))

#define  IO_PAD41_PIOCFG_ODT_EN_MASK 0x1000000
#define  IO_PAD41_PIOCFG_ODT_EN_SHIFT 24
#define  IO_PAD41_PIOCFG_ODT_EN_MASK_SHIFT(reg) (((reg) & IO_PAD41_PIOCFG_ODT_EN_MASK) >> IO_PAD41_PIOCFG_ODT_EN_SHIFT)
#define  IO_PAD41_PIOCFG_ODT_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD41_PIOCFG_ODT_EN_MASK) | (((uint32_t)val) << IO_PAD41_PIOCFG_ODT_EN_SHIFT))

#define  IO_PAD41_PIOCFG_LED_EN_MASK 0x800000
#define  IO_PAD41_PIOCFG_LED_EN_SHIFT 23
#define  IO_PAD41_PIOCFG_LED_EN_MASK_SHIFT(reg) (((reg) & IO_PAD41_PIOCFG_LED_EN_MASK) >> IO_PAD41_PIOCFG_LED_EN_SHIFT)
#define  IO_PAD41_PIOCFG_LED_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD41_PIOCFG_LED_EN_MASK) | (((uint32_t)val) << IO_PAD41_PIOCFG_LED_EN_SHIFT))

#define  IO_PAD41_PIOCFG_I2C_SEL_MASK 0x600000
#define  IO_PAD41_PIOCFG_I2C_SEL_SHIFT 21
#define  IO_PAD41_PIOCFG_I2C_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD41_PIOCFG_I2C_SEL_MASK) >> IO_PAD41_PIOCFG_I2C_SEL_SHIFT)
#define  IO_PAD41_PIOCFG_I2C_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD41_PIOCFG_I2C_SEL_MASK) | (((uint32_t)val) << IO_PAD41_PIOCFG_I2C_SEL_SHIFT))

#define  IO_PAD41_PIOCFG_DGTBSEL_MASK 0x1e0000
#define  IO_PAD41_PIOCFG_DGTBSEL_SHIFT 17
#define  IO_PAD41_PIOCFG_DGTBSEL_MASK_SHIFT(reg) (((reg) & IO_PAD41_PIOCFG_DGTBSEL_MASK) >> IO_PAD41_PIOCFG_DGTBSEL_SHIFT)
#define  IO_PAD41_PIOCFG_DGTBSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD41_PIOCFG_DGTBSEL_MASK) | (((uint32_t)val) << IO_PAD41_PIOCFG_DGTBSEL_SHIFT))

#define  IO_PAD41_PIOCFG_RAWSEL_MASK 0x10000
#define  IO_PAD41_PIOCFG_RAWSEL_SHIFT 16
#define  IO_PAD41_PIOCFG_RAWSEL_MASK_SHIFT(reg) (((reg) & IO_PAD41_PIOCFG_RAWSEL_MASK) >> IO_PAD41_PIOCFG_RAWSEL_SHIFT)
#define  IO_PAD41_PIOCFG_RAWSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD41_PIOCFG_RAWSEL_MASK) | (((uint32_t)val) << IO_PAD41_PIOCFG_RAWSEL_SHIFT))

#define  IO_PAD41_PIOCFG_PULL_SEL_MASK 0x8000
#define  IO_PAD41_PIOCFG_PULL_SEL_SHIFT 15
#define  IO_PAD41_PIOCFG_PULL_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD41_PIOCFG_PULL_SEL_MASK) >> IO_PAD41_PIOCFG_PULL_SEL_SHIFT)
#define  IO_PAD41_PIOCFG_PULL_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD41_PIOCFG_PULL_SEL_MASK) | (((uint32_t)val) << IO_PAD41_PIOCFG_PULL_SEL_SHIFT))

#define  IO_PAD41_PIOCFG_PUEN_MASK 0x4000
#define  IO_PAD41_PIOCFG_PUEN_SHIFT 14
#define  IO_PAD41_PIOCFG_PUEN_MASK_SHIFT(reg) (((reg) & IO_PAD41_PIOCFG_PUEN_MASK) >> IO_PAD41_PIOCFG_PUEN_SHIFT)
#define  IO_PAD41_PIOCFG_PUEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD41_PIOCFG_PUEN_MASK) | (((uint32_t)val) << IO_PAD41_PIOCFG_PUEN_SHIFT))

#define  IO_PAD41_PIOCFG_PDEN_MASK 0x2000
#define  IO_PAD41_PIOCFG_PDEN_SHIFT 13
#define  IO_PAD41_PIOCFG_PDEN_MASK_SHIFT(reg) (((reg) & IO_PAD41_PIOCFG_PDEN_MASK) >> IO_PAD41_PIOCFG_PDEN_SHIFT)
#define  IO_PAD41_PIOCFG_PDEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD41_PIOCFG_PDEN_MASK) | (((uint32_t)val) << IO_PAD41_PIOCFG_PDEN_SHIFT))

#define  IO_PAD41_PIOCFG_SR_MASK 0x1800
#define  IO_PAD41_PIOCFG_SR_SHIFT 11
#define  IO_PAD41_PIOCFG_SR_MASK_SHIFT(reg) (((reg) & IO_PAD41_PIOCFG_SR_MASK) >> IO_PAD41_PIOCFG_SR_SHIFT)
#define  IO_PAD41_PIOCFG_SR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD41_PIOCFG_SR_MASK) | (((uint32_t)val) << IO_PAD41_PIOCFG_SR_SHIFT))

#define  IO_PAD41_PIOCFG_SLP_DI_MASK 0x400
#define  IO_PAD41_PIOCFG_SLP_DI_SHIFT 10
#define  IO_PAD41_PIOCFG_SLP_DI_MASK_SHIFT(reg) (((reg) & IO_PAD41_PIOCFG_SLP_DI_MASK) >> IO_PAD41_PIOCFG_SLP_DI_SHIFT)
#define  IO_PAD41_PIOCFG_SLP_DI_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD41_PIOCFG_SLP_DI_MASK) | (((uint32_t)val) << IO_PAD41_PIOCFG_SLP_DI_SHIFT))

#define  IO_PAD41_PIOCFG_SLP_CNTRL_MASK 0x200
#define  IO_PAD41_PIOCFG_SLP_CNTRL_SHIFT 9
#define  IO_PAD41_PIOCFG_SLP_CNTRL_MASK_SHIFT(reg) (((reg) & IO_PAD41_PIOCFG_SLP_CNTRL_MASK) >> IO_PAD41_PIOCFG_SLP_CNTRL_SHIFT)
#define  IO_PAD41_PIOCFG_SLP_CNTRL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD41_PIOCFG_SLP_CNTRL_MASK) | (((uint32_t)val) << IO_PAD41_PIOCFG_SLP_CNTRL_SHIFT))

#define  IO_PAD41_PIOCFG_SLP_DO_MASK 0x100
#define  IO_PAD41_PIOCFG_SLP_DO_SHIFT 8
#define  IO_PAD41_PIOCFG_SLP_DO_MASK_SHIFT(reg) (((reg) & IO_PAD41_PIOCFG_SLP_DO_MASK) >> IO_PAD41_PIOCFG_SLP_DO_SHIFT)
#define  IO_PAD41_PIOCFG_SLP_DO_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD41_PIOCFG_SLP_DO_MASK) | (((uint32_t)val) << IO_PAD41_PIOCFG_SLP_DO_SHIFT))

#define  IO_PAD41_PIOCFG_SLP_DIR_MASK 0x80
#define  IO_PAD41_PIOCFG_SLP_DIR_SHIFT 7
#define  IO_PAD41_PIOCFG_SLP_DIR_MASK_SHIFT(reg) (((reg) & IO_PAD41_PIOCFG_SLP_DIR_MASK) >> IO_PAD41_PIOCFG_SLP_DIR_SHIFT)
#define  IO_PAD41_PIOCFG_SLP_DIR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD41_PIOCFG_SLP_DIR_MASK) | (((uint32_t)val) << IO_PAD41_PIOCFG_SLP_DIR_SHIFT))

#define  IO_PAD41_PIOCFG_EDGE_EN_N_MASK 0x40
#define  IO_PAD41_PIOCFG_EDGE_EN_N_SHIFT 6
#define  IO_PAD41_PIOCFG_EDGE_EN_N_MASK_SHIFT(reg) (((reg) & IO_PAD41_PIOCFG_EDGE_EN_N_MASK) >> IO_PAD41_PIOCFG_EDGE_EN_N_SHIFT)
#define  IO_PAD41_PIOCFG_EDGE_EN_N_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD41_PIOCFG_EDGE_EN_N_MASK) | (((uint32_t)val) << IO_PAD41_PIOCFG_EDGE_EN_N_SHIFT))

#define  IO_PAD41_PIOCFG_EDGE_FALL_EN_MASK 0x20
#define  IO_PAD41_PIOCFG_EDGE_FALL_EN_SHIFT 5
#define  IO_PAD41_PIOCFG_EDGE_FALL_EN_MASK_SHIFT(reg) (((reg) & IO_PAD41_PIOCFG_EDGE_FALL_EN_MASK) >> IO_PAD41_PIOCFG_EDGE_FALL_EN_SHIFT)
#define  IO_PAD41_PIOCFG_EDGE_FALL_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD41_PIOCFG_EDGE_FALL_EN_MASK) | (((uint32_t)val) << IO_PAD41_PIOCFG_EDGE_FALL_EN_SHIFT))

#define  IO_PAD41_PIOCFG_EDGE_RISE_EN_MASK 0x10
#define  IO_PAD41_PIOCFG_EDGE_RISE_EN_SHIFT 4
#define  IO_PAD41_PIOCFG_EDGE_RISE_EN_MASK_SHIFT(reg) (((reg) & IO_PAD41_PIOCFG_EDGE_RISE_EN_MASK) >> IO_PAD41_PIOCFG_EDGE_RISE_EN_SHIFT)
#define  IO_PAD41_PIOCFG_EDGE_RISE_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD41_PIOCFG_EDGE_RISE_EN_MASK) | (((uint32_t)val) << IO_PAD41_PIOCFG_EDGE_RISE_EN_SHIFT))

#define  IO_PAD41_PIOCFG_SLP_SEL_MASK 0x8
#define  IO_PAD41_PIOCFG_SLP_SEL_SHIFT 3
#define  IO_PAD41_PIOCFG_SLP_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD41_PIOCFG_SLP_SEL_MASK) >> IO_PAD41_PIOCFG_SLP_SEL_SHIFT)
#define  IO_PAD41_PIOCFG_SLP_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD41_PIOCFG_SLP_SEL_MASK) | (((uint32_t)val) << IO_PAD41_PIOCFG_SLP_SEL_SHIFT))

#define  IO_PAD41_PIOCFG_FUNC_SEL_MASK 0x7
#define  IO_PAD41_PIOCFG_FUNC_SEL_SHIFT 0
#define  IO_PAD41_PIOCFG_FUNC_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD41_PIOCFG_FUNC_SEL_MASK) >> IO_PAD41_PIOCFG_FUNC_SEL_SHIFT)
#define  IO_PAD41_PIOCFG_FUNC_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD41_PIOCFG_FUNC_SEL_MASK) | (((uint32_t)val) << IO_PAD41_PIOCFG_FUNC_SEL_SHIFT))

//====================================================================
//
//Register File: IO_PAD42 Configuration Registers (IO_PAD42)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

//====================================================================
//Register: IO_PAD42 Configuration Register (PIOCFG)
/** \brief "PHI_PADXDC_SRC" Pad*/
//====================================================================

#define  IO_PAD42_PIOCFG_RESERVED1_MASK 0xfc000000
#define  IO_PAD42_PIOCFG_RESERVED1_SHIFT 26
#define  IO_PAD42_PIOCFG_RESERVED1_MASK_SHIFT(reg) (((reg) & IO_PAD42_PIOCFG_RESERVED1_MASK) >> IO_PAD42_PIOCFG_RESERVED1_SHIFT)
#define  IO_PAD42_PIOCFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD42_PIOCFG_RESERVED1_MASK) | (((uint32_t)val) << IO_PAD42_PIOCFG_RESERVED1_SHIFT))

#define  IO_PAD42_PIOCFG_PD_MASK 0x2000000
#define  IO_PAD42_PIOCFG_PD_SHIFT 25
#define  IO_PAD42_PIOCFG_PD_MASK_SHIFT(reg) (((reg) & IO_PAD42_PIOCFG_PD_MASK) >> IO_PAD42_PIOCFG_PD_SHIFT)
#define  IO_PAD42_PIOCFG_PD_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD42_PIOCFG_PD_MASK) | (((uint32_t)val) << IO_PAD42_PIOCFG_PD_SHIFT))

#define  IO_PAD42_PIOCFG_ODT_EN_MASK 0x1000000
#define  IO_PAD42_PIOCFG_ODT_EN_SHIFT 24
#define  IO_PAD42_PIOCFG_ODT_EN_MASK_SHIFT(reg) (((reg) & IO_PAD42_PIOCFG_ODT_EN_MASK) >> IO_PAD42_PIOCFG_ODT_EN_SHIFT)
#define  IO_PAD42_PIOCFG_ODT_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD42_PIOCFG_ODT_EN_MASK) | (((uint32_t)val) << IO_PAD42_PIOCFG_ODT_EN_SHIFT))

#define  IO_PAD42_PIOCFG_LED_EN_MASK 0x800000
#define  IO_PAD42_PIOCFG_LED_EN_SHIFT 23
#define  IO_PAD42_PIOCFG_LED_EN_MASK_SHIFT(reg) (((reg) & IO_PAD42_PIOCFG_LED_EN_MASK) >> IO_PAD42_PIOCFG_LED_EN_SHIFT)
#define  IO_PAD42_PIOCFG_LED_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD42_PIOCFG_LED_EN_MASK) | (((uint32_t)val) << IO_PAD42_PIOCFG_LED_EN_SHIFT))

#define  IO_PAD42_PIOCFG_I2C_SEL_MASK 0x600000
#define  IO_PAD42_PIOCFG_I2C_SEL_SHIFT 21
#define  IO_PAD42_PIOCFG_I2C_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD42_PIOCFG_I2C_SEL_MASK) >> IO_PAD42_PIOCFG_I2C_SEL_SHIFT)
#define  IO_PAD42_PIOCFG_I2C_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD42_PIOCFG_I2C_SEL_MASK) | (((uint32_t)val) << IO_PAD42_PIOCFG_I2C_SEL_SHIFT))

#define  IO_PAD42_PIOCFG_DGTBSEL_MASK 0x1e0000
#define  IO_PAD42_PIOCFG_DGTBSEL_SHIFT 17
#define  IO_PAD42_PIOCFG_DGTBSEL_MASK_SHIFT(reg) (((reg) & IO_PAD42_PIOCFG_DGTBSEL_MASK) >> IO_PAD42_PIOCFG_DGTBSEL_SHIFT)
#define  IO_PAD42_PIOCFG_DGTBSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD42_PIOCFG_DGTBSEL_MASK) | (((uint32_t)val) << IO_PAD42_PIOCFG_DGTBSEL_SHIFT))

#define  IO_PAD42_PIOCFG_RAWSEL_MASK 0x10000
#define  IO_PAD42_PIOCFG_RAWSEL_SHIFT 16
#define  IO_PAD42_PIOCFG_RAWSEL_MASK_SHIFT(reg) (((reg) & IO_PAD42_PIOCFG_RAWSEL_MASK) >> IO_PAD42_PIOCFG_RAWSEL_SHIFT)
#define  IO_PAD42_PIOCFG_RAWSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD42_PIOCFG_RAWSEL_MASK) | (((uint32_t)val) << IO_PAD42_PIOCFG_RAWSEL_SHIFT))

#define  IO_PAD42_PIOCFG_PULL_SEL_MASK 0x8000
#define  IO_PAD42_PIOCFG_PULL_SEL_SHIFT 15
#define  IO_PAD42_PIOCFG_PULL_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD42_PIOCFG_PULL_SEL_MASK) >> IO_PAD42_PIOCFG_PULL_SEL_SHIFT)
#define  IO_PAD42_PIOCFG_PULL_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD42_PIOCFG_PULL_SEL_MASK) | (((uint32_t)val) << IO_PAD42_PIOCFG_PULL_SEL_SHIFT))

#define  IO_PAD42_PIOCFG_PUEN_MASK 0x4000
#define  IO_PAD42_PIOCFG_PUEN_SHIFT 14
#define  IO_PAD42_PIOCFG_PUEN_MASK_SHIFT(reg) (((reg) & IO_PAD42_PIOCFG_PUEN_MASK) >> IO_PAD42_PIOCFG_PUEN_SHIFT)
#define  IO_PAD42_PIOCFG_PUEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD42_PIOCFG_PUEN_MASK) | (((uint32_t)val) << IO_PAD42_PIOCFG_PUEN_SHIFT))

#define  IO_PAD42_PIOCFG_PDEN_MASK 0x2000
#define  IO_PAD42_PIOCFG_PDEN_SHIFT 13
#define  IO_PAD42_PIOCFG_PDEN_MASK_SHIFT(reg) (((reg) & IO_PAD42_PIOCFG_PDEN_MASK) >> IO_PAD42_PIOCFG_PDEN_SHIFT)
#define  IO_PAD42_PIOCFG_PDEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD42_PIOCFG_PDEN_MASK) | (((uint32_t)val) << IO_PAD42_PIOCFG_PDEN_SHIFT))

#define  IO_PAD42_PIOCFG_SR_MASK 0x1800
#define  IO_PAD42_PIOCFG_SR_SHIFT 11
#define  IO_PAD42_PIOCFG_SR_MASK_SHIFT(reg) (((reg) & IO_PAD42_PIOCFG_SR_MASK) >> IO_PAD42_PIOCFG_SR_SHIFT)
#define  IO_PAD42_PIOCFG_SR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD42_PIOCFG_SR_MASK) | (((uint32_t)val) << IO_PAD42_PIOCFG_SR_SHIFT))

#define  IO_PAD42_PIOCFG_SLP_DI_MASK 0x400
#define  IO_PAD42_PIOCFG_SLP_DI_SHIFT 10
#define  IO_PAD42_PIOCFG_SLP_DI_MASK_SHIFT(reg) (((reg) & IO_PAD42_PIOCFG_SLP_DI_MASK) >> IO_PAD42_PIOCFG_SLP_DI_SHIFT)
#define  IO_PAD42_PIOCFG_SLP_DI_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD42_PIOCFG_SLP_DI_MASK) | (((uint32_t)val) << IO_PAD42_PIOCFG_SLP_DI_SHIFT))

#define  IO_PAD42_PIOCFG_SLP_CNTRL_MASK 0x200
#define  IO_PAD42_PIOCFG_SLP_CNTRL_SHIFT 9
#define  IO_PAD42_PIOCFG_SLP_CNTRL_MASK_SHIFT(reg) (((reg) & IO_PAD42_PIOCFG_SLP_CNTRL_MASK) >> IO_PAD42_PIOCFG_SLP_CNTRL_SHIFT)
#define  IO_PAD42_PIOCFG_SLP_CNTRL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD42_PIOCFG_SLP_CNTRL_MASK) | (((uint32_t)val) << IO_PAD42_PIOCFG_SLP_CNTRL_SHIFT))

#define  IO_PAD42_PIOCFG_SLP_DO_MASK 0x100
#define  IO_PAD42_PIOCFG_SLP_DO_SHIFT 8
#define  IO_PAD42_PIOCFG_SLP_DO_MASK_SHIFT(reg) (((reg) & IO_PAD42_PIOCFG_SLP_DO_MASK) >> IO_PAD42_PIOCFG_SLP_DO_SHIFT)
#define  IO_PAD42_PIOCFG_SLP_DO_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD42_PIOCFG_SLP_DO_MASK) | (((uint32_t)val) << IO_PAD42_PIOCFG_SLP_DO_SHIFT))

#define  IO_PAD42_PIOCFG_SLP_DIR_MASK 0x80
#define  IO_PAD42_PIOCFG_SLP_DIR_SHIFT 7
#define  IO_PAD42_PIOCFG_SLP_DIR_MASK_SHIFT(reg) (((reg) & IO_PAD42_PIOCFG_SLP_DIR_MASK) >> IO_PAD42_PIOCFG_SLP_DIR_SHIFT)
#define  IO_PAD42_PIOCFG_SLP_DIR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD42_PIOCFG_SLP_DIR_MASK) | (((uint32_t)val) << IO_PAD42_PIOCFG_SLP_DIR_SHIFT))

#define  IO_PAD42_PIOCFG_EDGE_EN_N_MASK 0x40
#define  IO_PAD42_PIOCFG_EDGE_EN_N_SHIFT 6
#define  IO_PAD42_PIOCFG_EDGE_EN_N_MASK_SHIFT(reg) (((reg) & IO_PAD42_PIOCFG_EDGE_EN_N_MASK) >> IO_PAD42_PIOCFG_EDGE_EN_N_SHIFT)
#define  IO_PAD42_PIOCFG_EDGE_EN_N_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD42_PIOCFG_EDGE_EN_N_MASK) | (((uint32_t)val) << IO_PAD42_PIOCFG_EDGE_EN_N_SHIFT))

#define  IO_PAD42_PIOCFG_EDGE_FALL_EN_MASK 0x20
#define  IO_PAD42_PIOCFG_EDGE_FALL_EN_SHIFT 5
#define  IO_PAD42_PIOCFG_EDGE_FALL_EN_MASK_SHIFT(reg) (((reg) & IO_PAD42_PIOCFG_EDGE_FALL_EN_MASK) >> IO_PAD42_PIOCFG_EDGE_FALL_EN_SHIFT)
#define  IO_PAD42_PIOCFG_EDGE_FALL_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD42_PIOCFG_EDGE_FALL_EN_MASK) | (((uint32_t)val) << IO_PAD42_PIOCFG_EDGE_FALL_EN_SHIFT))

#define  IO_PAD42_PIOCFG_EDGE_RISE_EN_MASK 0x10
#define  IO_PAD42_PIOCFG_EDGE_RISE_EN_SHIFT 4
#define  IO_PAD42_PIOCFG_EDGE_RISE_EN_MASK_SHIFT(reg) (((reg) & IO_PAD42_PIOCFG_EDGE_RISE_EN_MASK) >> IO_PAD42_PIOCFG_EDGE_RISE_EN_SHIFT)
#define  IO_PAD42_PIOCFG_EDGE_RISE_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD42_PIOCFG_EDGE_RISE_EN_MASK) | (((uint32_t)val) << IO_PAD42_PIOCFG_EDGE_RISE_EN_SHIFT))

#define  IO_PAD42_PIOCFG_SLP_SEL_MASK 0x8
#define  IO_PAD42_PIOCFG_SLP_SEL_SHIFT 3
#define  IO_PAD42_PIOCFG_SLP_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD42_PIOCFG_SLP_SEL_MASK) >> IO_PAD42_PIOCFG_SLP_SEL_SHIFT)
#define  IO_PAD42_PIOCFG_SLP_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD42_PIOCFG_SLP_SEL_MASK) | (((uint32_t)val) << IO_PAD42_PIOCFG_SLP_SEL_SHIFT))

#define  IO_PAD42_PIOCFG_FUNC_SEL_MASK 0x7
#define  IO_PAD42_PIOCFG_FUNC_SEL_SHIFT 0
#define  IO_PAD42_PIOCFG_FUNC_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD42_PIOCFG_FUNC_SEL_MASK) >> IO_PAD42_PIOCFG_FUNC_SEL_SHIFT)
#define  IO_PAD42_PIOCFG_FUNC_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD42_PIOCFG_FUNC_SEL_MASK) | (((uint32_t)val) << IO_PAD42_PIOCFG_FUNC_SEL_SHIFT))

//====================================================================
//
//Register File: IO_PAD43 Configuration Registers (IO_PAD43)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

//====================================================================
//Register: IO_PAD43 Configuration Register (PIOCFG)
/** \brief "PHI_PADXDC_SRC" Pad*/
//====================================================================

#define  IO_PAD43_PIOCFG_RESERVED1_MASK 0xfc000000
#define  IO_PAD43_PIOCFG_RESERVED1_SHIFT 26
#define  IO_PAD43_PIOCFG_RESERVED1_MASK_SHIFT(reg) (((reg) & IO_PAD43_PIOCFG_RESERVED1_MASK) >> IO_PAD43_PIOCFG_RESERVED1_SHIFT)
#define  IO_PAD43_PIOCFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD43_PIOCFG_RESERVED1_MASK) | (((uint32_t)val) << IO_PAD43_PIOCFG_RESERVED1_SHIFT))

#define  IO_PAD43_PIOCFG_PD_MASK 0x2000000
#define  IO_PAD43_PIOCFG_PD_SHIFT 25
#define  IO_PAD43_PIOCFG_PD_MASK_SHIFT(reg) (((reg) & IO_PAD43_PIOCFG_PD_MASK) >> IO_PAD43_PIOCFG_PD_SHIFT)
#define  IO_PAD43_PIOCFG_PD_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD43_PIOCFG_PD_MASK) | (((uint32_t)val) << IO_PAD43_PIOCFG_PD_SHIFT))

#define  IO_PAD43_PIOCFG_ODT_EN_MASK 0x1000000
#define  IO_PAD43_PIOCFG_ODT_EN_SHIFT 24
#define  IO_PAD43_PIOCFG_ODT_EN_MASK_SHIFT(reg) (((reg) & IO_PAD43_PIOCFG_ODT_EN_MASK) >> IO_PAD43_PIOCFG_ODT_EN_SHIFT)
#define  IO_PAD43_PIOCFG_ODT_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD43_PIOCFG_ODT_EN_MASK) | (((uint32_t)val) << IO_PAD43_PIOCFG_ODT_EN_SHIFT))

#define  IO_PAD43_PIOCFG_LED_EN_MASK 0x800000
#define  IO_PAD43_PIOCFG_LED_EN_SHIFT 23
#define  IO_PAD43_PIOCFG_LED_EN_MASK_SHIFT(reg) (((reg) & IO_PAD43_PIOCFG_LED_EN_MASK) >> IO_PAD43_PIOCFG_LED_EN_SHIFT)
#define  IO_PAD43_PIOCFG_LED_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD43_PIOCFG_LED_EN_MASK) | (((uint32_t)val) << IO_PAD43_PIOCFG_LED_EN_SHIFT))

#define  IO_PAD43_PIOCFG_I2C_SEL_MASK 0x600000
#define  IO_PAD43_PIOCFG_I2C_SEL_SHIFT 21
#define  IO_PAD43_PIOCFG_I2C_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD43_PIOCFG_I2C_SEL_MASK) >> IO_PAD43_PIOCFG_I2C_SEL_SHIFT)
#define  IO_PAD43_PIOCFG_I2C_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD43_PIOCFG_I2C_SEL_MASK) | (((uint32_t)val) << IO_PAD43_PIOCFG_I2C_SEL_SHIFT))

#define  IO_PAD43_PIOCFG_DGTBSEL_MASK 0x1e0000
#define  IO_PAD43_PIOCFG_DGTBSEL_SHIFT 17
#define  IO_PAD43_PIOCFG_DGTBSEL_MASK_SHIFT(reg) (((reg) & IO_PAD43_PIOCFG_DGTBSEL_MASK) >> IO_PAD43_PIOCFG_DGTBSEL_SHIFT)
#define  IO_PAD43_PIOCFG_DGTBSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD43_PIOCFG_DGTBSEL_MASK) | (((uint32_t)val) << IO_PAD43_PIOCFG_DGTBSEL_SHIFT))

#define  IO_PAD43_PIOCFG_RAWSEL_MASK 0x10000
#define  IO_PAD43_PIOCFG_RAWSEL_SHIFT 16
#define  IO_PAD43_PIOCFG_RAWSEL_MASK_SHIFT(reg) (((reg) & IO_PAD43_PIOCFG_RAWSEL_MASK) >> IO_PAD43_PIOCFG_RAWSEL_SHIFT)
#define  IO_PAD43_PIOCFG_RAWSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD43_PIOCFG_RAWSEL_MASK) | (((uint32_t)val) << IO_PAD43_PIOCFG_RAWSEL_SHIFT))

#define  IO_PAD43_PIOCFG_PULL_SEL_MASK 0x8000
#define  IO_PAD43_PIOCFG_PULL_SEL_SHIFT 15
#define  IO_PAD43_PIOCFG_PULL_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD43_PIOCFG_PULL_SEL_MASK) >> IO_PAD43_PIOCFG_PULL_SEL_SHIFT)
#define  IO_PAD43_PIOCFG_PULL_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD43_PIOCFG_PULL_SEL_MASK) | (((uint32_t)val) << IO_PAD43_PIOCFG_PULL_SEL_SHIFT))

#define  IO_PAD43_PIOCFG_PUEN_MASK 0x4000
#define  IO_PAD43_PIOCFG_PUEN_SHIFT 14
#define  IO_PAD43_PIOCFG_PUEN_MASK_SHIFT(reg) (((reg) & IO_PAD43_PIOCFG_PUEN_MASK) >> IO_PAD43_PIOCFG_PUEN_SHIFT)
#define  IO_PAD43_PIOCFG_PUEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD43_PIOCFG_PUEN_MASK) | (((uint32_t)val) << IO_PAD43_PIOCFG_PUEN_SHIFT))

#define  IO_PAD43_PIOCFG_PDEN_MASK 0x2000
#define  IO_PAD43_PIOCFG_PDEN_SHIFT 13
#define  IO_PAD43_PIOCFG_PDEN_MASK_SHIFT(reg) (((reg) & IO_PAD43_PIOCFG_PDEN_MASK) >> IO_PAD43_PIOCFG_PDEN_SHIFT)
#define  IO_PAD43_PIOCFG_PDEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD43_PIOCFG_PDEN_MASK) | (((uint32_t)val) << IO_PAD43_PIOCFG_PDEN_SHIFT))

#define  IO_PAD43_PIOCFG_SR_MASK 0x1800
#define  IO_PAD43_PIOCFG_SR_SHIFT 11
#define  IO_PAD43_PIOCFG_SR_MASK_SHIFT(reg) (((reg) & IO_PAD43_PIOCFG_SR_MASK) >> IO_PAD43_PIOCFG_SR_SHIFT)
#define  IO_PAD43_PIOCFG_SR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD43_PIOCFG_SR_MASK) | (((uint32_t)val) << IO_PAD43_PIOCFG_SR_SHIFT))

#define  IO_PAD43_PIOCFG_SLP_DI_MASK 0x400
#define  IO_PAD43_PIOCFG_SLP_DI_SHIFT 10
#define  IO_PAD43_PIOCFG_SLP_DI_MASK_SHIFT(reg) (((reg) & IO_PAD43_PIOCFG_SLP_DI_MASK) >> IO_PAD43_PIOCFG_SLP_DI_SHIFT)
#define  IO_PAD43_PIOCFG_SLP_DI_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD43_PIOCFG_SLP_DI_MASK) | (((uint32_t)val) << IO_PAD43_PIOCFG_SLP_DI_SHIFT))

#define  IO_PAD43_PIOCFG_SLP_CNTRL_MASK 0x200
#define  IO_PAD43_PIOCFG_SLP_CNTRL_SHIFT 9
#define  IO_PAD43_PIOCFG_SLP_CNTRL_MASK_SHIFT(reg) (((reg) & IO_PAD43_PIOCFG_SLP_CNTRL_MASK) >> IO_PAD43_PIOCFG_SLP_CNTRL_SHIFT)
#define  IO_PAD43_PIOCFG_SLP_CNTRL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD43_PIOCFG_SLP_CNTRL_MASK) | (((uint32_t)val) << IO_PAD43_PIOCFG_SLP_CNTRL_SHIFT))

#define  IO_PAD43_PIOCFG_SLP_DO_MASK 0x100
#define  IO_PAD43_PIOCFG_SLP_DO_SHIFT 8
#define  IO_PAD43_PIOCFG_SLP_DO_MASK_SHIFT(reg) (((reg) & IO_PAD43_PIOCFG_SLP_DO_MASK) >> IO_PAD43_PIOCFG_SLP_DO_SHIFT)
#define  IO_PAD43_PIOCFG_SLP_DO_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD43_PIOCFG_SLP_DO_MASK) | (((uint32_t)val) << IO_PAD43_PIOCFG_SLP_DO_SHIFT))

#define  IO_PAD43_PIOCFG_SLP_DIR_MASK 0x80
#define  IO_PAD43_PIOCFG_SLP_DIR_SHIFT 7
#define  IO_PAD43_PIOCFG_SLP_DIR_MASK_SHIFT(reg) (((reg) & IO_PAD43_PIOCFG_SLP_DIR_MASK) >> IO_PAD43_PIOCFG_SLP_DIR_SHIFT)
#define  IO_PAD43_PIOCFG_SLP_DIR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD43_PIOCFG_SLP_DIR_MASK) | (((uint32_t)val) << IO_PAD43_PIOCFG_SLP_DIR_SHIFT))

#define  IO_PAD43_PIOCFG_EDGE_EN_N_MASK 0x40
#define  IO_PAD43_PIOCFG_EDGE_EN_N_SHIFT 6
#define  IO_PAD43_PIOCFG_EDGE_EN_N_MASK_SHIFT(reg) (((reg) & IO_PAD43_PIOCFG_EDGE_EN_N_MASK) >> IO_PAD43_PIOCFG_EDGE_EN_N_SHIFT)
#define  IO_PAD43_PIOCFG_EDGE_EN_N_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD43_PIOCFG_EDGE_EN_N_MASK) | (((uint32_t)val) << IO_PAD43_PIOCFG_EDGE_EN_N_SHIFT))

#define  IO_PAD43_PIOCFG_EDGE_FALL_EN_MASK 0x20
#define  IO_PAD43_PIOCFG_EDGE_FALL_EN_SHIFT 5
#define  IO_PAD43_PIOCFG_EDGE_FALL_EN_MASK_SHIFT(reg) (((reg) & IO_PAD43_PIOCFG_EDGE_FALL_EN_MASK) >> IO_PAD43_PIOCFG_EDGE_FALL_EN_SHIFT)
#define  IO_PAD43_PIOCFG_EDGE_FALL_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD43_PIOCFG_EDGE_FALL_EN_MASK) | (((uint32_t)val) << IO_PAD43_PIOCFG_EDGE_FALL_EN_SHIFT))

#define  IO_PAD43_PIOCFG_EDGE_RISE_EN_MASK 0x10
#define  IO_PAD43_PIOCFG_EDGE_RISE_EN_SHIFT 4
#define  IO_PAD43_PIOCFG_EDGE_RISE_EN_MASK_SHIFT(reg) (((reg) & IO_PAD43_PIOCFG_EDGE_RISE_EN_MASK) >> IO_PAD43_PIOCFG_EDGE_RISE_EN_SHIFT)
#define  IO_PAD43_PIOCFG_EDGE_RISE_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD43_PIOCFG_EDGE_RISE_EN_MASK) | (((uint32_t)val) << IO_PAD43_PIOCFG_EDGE_RISE_EN_SHIFT))

#define  IO_PAD43_PIOCFG_SLP_SEL_MASK 0x8
#define  IO_PAD43_PIOCFG_SLP_SEL_SHIFT 3
#define  IO_PAD43_PIOCFG_SLP_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD43_PIOCFG_SLP_SEL_MASK) >> IO_PAD43_PIOCFG_SLP_SEL_SHIFT)
#define  IO_PAD43_PIOCFG_SLP_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD43_PIOCFG_SLP_SEL_MASK) | (((uint32_t)val) << IO_PAD43_PIOCFG_SLP_SEL_SHIFT))

#define  IO_PAD43_PIOCFG_FUNC_SEL_MASK 0x7
#define  IO_PAD43_PIOCFG_FUNC_SEL_SHIFT 0
#define  IO_PAD43_PIOCFG_FUNC_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD43_PIOCFG_FUNC_SEL_MASK) >> IO_PAD43_PIOCFG_FUNC_SEL_SHIFT)
#define  IO_PAD43_PIOCFG_FUNC_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD43_PIOCFG_FUNC_SEL_MASK) | (((uint32_t)val) << IO_PAD43_PIOCFG_FUNC_SEL_SHIFT))

//====================================================================
//
//Register File: IO_PAD44 Configuration Registers (IO_PAD44)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

//====================================================================
//Register: IO_PAD44 Configuration Register (PIOCFG)
/** \brief "PHI_PADXDC_SRC" Pad*/
//====================================================================

#define  IO_PAD44_PIOCFG_RESERVED1_MASK 0xfc000000
#define  IO_PAD44_PIOCFG_RESERVED1_SHIFT 26
#define  IO_PAD44_PIOCFG_RESERVED1_MASK_SHIFT(reg) (((reg) & IO_PAD44_PIOCFG_RESERVED1_MASK) >> IO_PAD44_PIOCFG_RESERVED1_SHIFT)
#define  IO_PAD44_PIOCFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD44_PIOCFG_RESERVED1_MASK) | (((uint32_t)val) << IO_PAD44_PIOCFG_RESERVED1_SHIFT))

#define  IO_PAD44_PIOCFG_PD_MASK 0x2000000
#define  IO_PAD44_PIOCFG_PD_SHIFT 25
#define  IO_PAD44_PIOCFG_PD_MASK_SHIFT(reg) (((reg) & IO_PAD44_PIOCFG_PD_MASK) >> IO_PAD44_PIOCFG_PD_SHIFT)
#define  IO_PAD44_PIOCFG_PD_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD44_PIOCFG_PD_MASK) | (((uint32_t)val) << IO_PAD44_PIOCFG_PD_SHIFT))

#define  IO_PAD44_PIOCFG_ODT_EN_MASK 0x1000000
#define  IO_PAD44_PIOCFG_ODT_EN_SHIFT 24
#define  IO_PAD44_PIOCFG_ODT_EN_MASK_SHIFT(reg) (((reg) & IO_PAD44_PIOCFG_ODT_EN_MASK) >> IO_PAD44_PIOCFG_ODT_EN_SHIFT)
#define  IO_PAD44_PIOCFG_ODT_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD44_PIOCFG_ODT_EN_MASK) | (((uint32_t)val) << IO_PAD44_PIOCFG_ODT_EN_SHIFT))

#define  IO_PAD44_PIOCFG_LED_EN_MASK 0x800000
#define  IO_PAD44_PIOCFG_LED_EN_SHIFT 23
#define  IO_PAD44_PIOCFG_LED_EN_MASK_SHIFT(reg) (((reg) & IO_PAD44_PIOCFG_LED_EN_MASK) >> IO_PAD44_PIOCFG_LED_EN_SHIFT)
#define  IO_PAD44_PIOCFG_LED_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD44_PIOCFG_LED_EN_MASK) | (((uint32_t)val) << IO_PAD44_PIOCFG_LED_EN_SHIFT))

#define  IO_PAD44_PIOCFG_I2C_SEL_MASK 0x600000
#define  IO_PAD44_PIOCFG_I2C_SEL_SHIFT 21
#define  IO_PAD44_PIOCFG_I2C_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD44_PIOCFG_I2C_SEL_MASK) >> IO_PAD44_PIOCFG_I2C_SEL_SHIFT)
#define  IO_PAD44_PIOCFG_I2C_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD44_PIOCFG_I2C_SEL_MASK) | (((uint32_t)val) << IO_PAD44_PIOCFG_I2C_SEL_SHIFT))

#define  IO_PAD44_PIOCFG_DGTBSEL_MASK 0x1e0000
#define  IO_PAD44_PIOCFG_DGTBSEL_SHIFT 17
#define  IO_PAD44_PIOCFG_DGTBSEL_MASK_SHIFT(reg) (((reg) & IO_PAD44_PIOCFG_DGTBSEL_MASK) >> IO_PAD44_PIOCFG_DGTBSEL_SHIFT)
#define  IO_PAD44_PIOCFG_DGTBSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD44_PIOCFG_DGTBSEL_MASK) | (((uint32_t)val) << IO_PAD44_PIOCFG_DGTBSEL_SHIFT))

#define  IO_PAD44_PIOCFG_RAWSEL_MASK 0x10000
#define  IO_PAD44_PIOCFG_RAWSEL_SHIFT 16
#define  IO_PAD44_PIOCFG_RAWSEL_MASK_SHIFT(reg) (((reg) & IO_PAD44_PIOCFG_RAWSEL_MASK) >> IO_PAD44_PIOCFG_RAWSEL_SHIFT)
#define  IO_PAD44_PIOCFG_RAWSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD44_PIOCFG_RAWSEL_MASK) | (((uint32_t)val) << IO_PAD44_PIOCFG_RAWSEL_SHIFT))

#define  IO_PAD44_PIOCFG_PULL_SEL_MASK 0x8000
#define  IO_PAD44_PIOCFG_PULL_SEL_SHIFT 15
#define  IO_PAD44_PIOCFG_PULL_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD44_PIOCFG_PULL_SEL_MASK) >> IO_PAD44_PIOCFG_PULL_SEL_SHIFT)
#define  IO_PAD44_PIOCFG_PULL_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD44_PIOCFG_PULL_SEL_MASK) | (((uint32_t)val) << IO_PAD44_PIOCFG_PULL_SEL_SHIFT))

#define  IO_PAD44_PIOCFG_PUEN_MASK 0x4000
#define  IO_PAD44_PIOCFG_PUEN_SHIFT 14
#define  IO_PAD44_PIOCFG_PUEN_MASK_SHIFT(reg) (((reg) & IO_PAD44_PIOCFG_PUEN_MASK) >> IO_PAD44_PIOCFG_PUEN_SHIFT)
#define  IO_PAD44_PIOCFG_PUEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD44_PIOCFG_PUEN_MASK) | (((uint32_t)val) << IO_PAD44_PIOCFG_PUEN_SHIFT))

#define  IO_PAD44_PIOCFG_PDEN_MASK 0x2000
#define  IO_PAD44_PIOCFG_PDEN_SHIFT 13
#define  IO_PAD44_PIOCFG_PDEN_MASK_SHIFT(reg) (((reg) & IO_PAD44_PIOCFG_PDEN_MASK) >> IO_PAD44_PIOCFG_PDEN_SHIFT)
#define  IO_PAD44_PIOCFG_PDEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD44_PIOCFG_PDEN_MASK) | (((uint32_t)val) << IO_PAD44_PIOCFG_PDEN_SHIFT))

#define  IO_PAD44_PIOCFG_SR_MASK 0x1800
#define  IO_PAD44_PIOCFG_SR_SHIFT 11
#define  IO_PAD44_PIOCFG_SR_MASK_SHIFT(reg) (((reg) & IO_PAD44_PIOCFG_SR_MASK) >> IO_PAD44_PIOCFG_SR_SHIFT)
#define  IO_PAD44_PIOCFG_SR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD44_PIOCFG_SR_MASK) | (((uint32_t)val) << IO_PAD44_PIOCFG_SR_SHIFT))

#define  IO_PAD44_PIOCFG_SLP_DI_MASK 0x400
#define  IO_PAD44_PIOCFG_SLP_DI_SHIFT 10
#define  IO_PAD44_PIOCFG_SLP_DI_MASK_SHIFT(reg) (((reg) & IO_PAD44_PIOCFG_SLP_DI_MASK) >> IO_PAD44_PIOCFG_SLP_DI_SHIFT)
#define  IO_PAD44_PIOCFG_SLP_DI_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD44_PIOCFG_SLP_DI_MASK) | (((uint32_t)val) << IO_PAD44_PIOCFG_SLP_DI_SHIFT))

#define  IO_PAD44_PIOCFG_SLP_CNTRL_MASK 0x200
#define  IO_PAD44_PIOCFG_SLP_CNTRL_SHIFT 9
#define  IO_PAD44_PIOCFG_SLP_CNTRL_MASK_SHIFT(reg) (((reg) & IO_PAD44_PIOCFG_SLP_CNTRL_MASK) >> IO_PAD44_PIOCFG_SLP_CNTRL_SHIFT)
#define  IO_PAD44_PIOCFG_SLP_CNTRL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD44_PIOCFG_SLP_CNTRL_MASK) | (((uint32_t)val) << IO_PAD44_PIOCFG_SLP_CNTRL_SHIFT))

#define  IO_PAD44_PIOCFG_SLP_DO_MASK 0x100
#define  IO_PAD44_PIOCFG_SLP_DO_SHIFT 8
#define  IO_PAD44_PIOCFG_SLP_DO_MASK_SHIFT(reg) (((reg) & IO_PAD44_PIOCFG_SLP_DO_MASK) >> IO_PAD44_PIOCFG_SLP_DO_SHIFT)
#define  IO_PAD44_PIOCFG_SLP_DO_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD44_PIOCFG_SLP_DO_MASK) | (((uint32_t)val) << IO_PAD44_PIOCFG_SLP_DO_SHIFT))

#define  IO_PAD44_PIOCFG_SLP_DIR_MASK 0x80
#define  IO_PAD44_PIOCFG_SLP_DIR_SHIFT 7
#define  IO_PAD44_PIOCFG_SLP_DIR_MASK_SHIFT(reg) (((reg) & IO_PAD44_PIOCFG_SLP_DIR_MASK) >> IO_PAD44_PIOCFG_SLP_DIR_SHIFT)
#define  IO_PAD44_PIOCFG_SLP_DIR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD44_PIOCFG_SLP_DIR_MASK) | (((uint32_t)val) << IO_PAD44_PIOCFG_SLP_DIR_SHIFT))

#define  IO_PAD44_PIOCFG_EDGE_EN_N_MASK 0x40
#define  IO_PAD44_PIOCFG_EDGE_EN_N_SHIFT 6
#define  IO_PAD44_PIOCFG_EDGE_EN_N_MASK_SHIFT(reg) (((reg) & IO_PAD44_PIOCFG_EDGE_EN_N_MASK) >> IO_PAD44_PIOCFG_EDGE_EN_N_SHIFT)
#define  IO_PAD44_PIOCFG_EDGE_EN_N_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD44_PIOCFG_EDGE_EN_N_MASK) | (((uint32_t)val) << IO_PAD44_PIOCFG_EDGE_EN_N_SHIFT))

#define  IO_PAD44_PIOCFG_EDGE_FALL_EN_MASK 0x20
#define  IO_PAD44_PIOCFG_EDGE_FALL_EN_SHIFT 5
#define  IO_PAD44_PIOCFG_EDGE_FALL_EN_MASK_SHIFT(reg) (((reg) & IO_PAD44_PIOCFG_EDGE_FALL_EN_MASK) >> IO_PAD44_PIOCFG_EDGE_FALL_EN_SHIFT)
#define  IO_PAD44_PIOCFG_EDGE_FALL_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD44_PIOCFG_EDGE_FALL_EN_MASK) | (((uint32_t)val) << IO_PAD44_PIOCFG_EDGE_FALL_EN_SHIFT))

#define  IO_PAD44_PIOCFG_EDGE_RISE_EN_MASK 0x10
#define  IO_PAD44_PIOCFG_EDGE_RISE_EN_SHIFT 4
#define  IO_PAD44_PIOCFG_EDGE_RISE_EN_MASK_SHIFT(reg) (((reg) & IO_PAD44_PIOCFG_EDGE_RISE_EN_MASK) >> IO_PAD44_PIOCFG_EDGE_RISE_EN_SHIFT)
#define  IO_PAD44_PIOCFG_EDGE_RISE_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD44_PIOCFG_EDGE_RISE_EN_MASK) | (((uint32_t)val) << IO_PAD44_PIOCFG_EDGE_RISE_EN_SHIFT))

#define  IO_PAD44_PIOCFG_SLP_SEL_MASK 0x8
#define  IO_PAD44_PIOCFG_SLP_SEL_SHIFT 3
#define  IO_PAD44_PIOCFG_SLP_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD44_PIOCFG_SLP_SEL_MASK) >> IO_PAD44_PIOCFG_SLP_SEL_SHIFT)
#define  IO_PAD44_PIOCFG_SLP_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD44_PIOCFG_SLP_SEL_MASK) | (((uint32_t)val) << IO_PAD44_PIOCFG_SLP_SEL_SHIFT))

#define  IO_PAD44_PIOCFG_FUNC_SEL_MASK 0x7
#define  IO_PAD44_PIOCFG_FUNC_SEL_SHIFT 0
#define  IO_PAD44_PIOCFG_FUNC_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD44_PIOCFG_FUNC_SEL_MASK) >> IO_PAD44_PIOCFG_FUNC_SEL_SHIFT)
#define  IO_PAD44_PIOCFG_FUNC_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD44_PIOCFG_FUNC_SEL_MASK) | (((uint32_t)val) << IO_PAD44_PIOCFG_FUNC_SEL_SHIFT))

//====================================================================
//
//Register File: IO_PAD45 Configuration Registers (IO_PAD45)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

//====================================================================
//Register: IO_PAD45 Configuration Register (PIOCFG)
/** \brief "PHI_PADXDC_SRC" Pad*/
//====================================================================

#define  IO_PAD45_PIOCFG_RESERVED1_MASK 0xfc000000
#define  IO_PAD45_PIOCFG_RESERVED1_SHIFT 26
#define  IO_PAD45_PIOCFG_RESERVED1_MASK_SHIFT(reg) (((reg) & IO_PAD45_PIOCFG_RESERVED1_MASK) >> IO_PAD45_PIOCFG_RESERVED1_SHIFT)
#define  IO_PAD45_PIOCFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD45_PIOCFG_RESERVED1_MASK) | (((uint32_t)val) << IO_PAD45_PIOCFG_RESERVED1_SHIFT))

#define  IO_PAD45_PIOCFG_PD_MASK 0x2000000
#define  IO_PAD45_PIOCFG_PD_SHIFT 25
#define  IO_PAD45_PIOCFG_PD_MASK_SHIFT(reg) (((reg) & IO_PAD45_PIOCFG_PD_MASK) >> IO_PAD45_PIOCFG_PD_SHIFT)
#define  IO_PAD45_PIOCFG_PD_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD45_PIOCFG_PD_MASK) | (((uint32_t)val) << IO_PAD45_PIOCFG_PD_SHIFT))

#define  IO_PAD45_PIOCFG_ODT_EN_MASK 0x1000000
#define  IO_PAD45_PIOCFG_ODT_EN_SHIFT 24
#define  IO_PAD45_PIOCFG_ODT_EN_MASK_SHIFT(reg) (((reg) & IO_PAD45_PIOCFG_ODT_EN_MASK) >> IO_PAD45_PIOCFG_ODT_EN_SHIFT)
#define  IO_PAD45_PIOCFG_ODT_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD45_PIOCFG_ODT_EN_MASK) | (((uint32_t)val) << IO_PAD45_PIOCFG_ODT_EN_SHIFT))

#define  IO_PAD45_PIOCFG_LED_EN_MASK 0x800000
#define  IO_PAD45_PIOCFG_LED_EN_SHIFT 23
#define  IO_PAD45_PIOCFG_LED_EN_MASK_SHIFT(reg) (((reg) & IO_PAD45_PIOCFG_LED_EN_MASK) >> IO_PAD45_PIOCFG_LED_EN_SHIFT)
#define  IO_PAD45_PIOCFG_LED_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD45_PIOCFG_LED_EN_MASK) | (((uint32_t)val) << IO_PAD45_PIOCFG_LED_EN_SHIFT))

#define  IO_PAD45_PIOCFG_I2C_SEL_MASK 0x600000
#define  IO_PAD45_PIOCFG_I2C_SEL_SHIFT 21
#define  IO_PAD45_PIOCFG_I2C_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD45_PIOCFG_I2C_SEL_MASK) >> IO_PAD45_PIOCFG_I2C_SEL_SHIFT)
#define  IO_PAD45_PIOCFG_I2C_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD45_PIOCFG_I2C_SEL_MASK) | (((uint32_t)val) << IO_PAD45_PIOCFG_I2C_SEL_SHIFT))

#define  IO_PAD45_PIOCFG_DGTBSEL_MASK 0x1e0000
#define  IO_PAD45_PIOCFG_DGTBSEL_SHIFT 17
#define  IO_PAD45_PIOCFG_DGTBSEL_MASK_SHIFT(reg) (((reg) & IO_PAD45_PIOCFG_DGTBSEL_MASK) >> IO_PAD45_PIOCFG_DGTBSEL_SHIFT)
#define  IO_PAD45_PIOCFG_DGTBSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD45_PIOCFG_DGTBSEL_MASK) | (((uint32_t)val) << IO_PAD45_PIOCFG_DGTBSEL_SHIFT))

#define  IO_PAD45_PIOCFG_RAWSEL_MASK 0x10000
#define  IO_PAD45_PIOCFG_RAWSEL_SHIFT 16
#define  IO_PAD45_PIOCFG_RAWSEL_MASK_SHIFT(reg) (((reg) & IO_PAD45_PIOCFG_RAWSEL_MASK) >> IO_PAD45_PIOCFG_RAWSEL_SHIFT)
#define  IO_PAD45_PIOCFG_RAWSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD45_PIOCFG_RAWSEL_MASK) | (((uint32_t)val) << IO_PAD45_PIOCFG_RAWSEL_SHIFT))

#define  IO_PAD45_PIOCFG_PULL_SEL_MASK 0x8000
#define  IO_PAD45_PIOCFG_PULL_SEL_SHIFT 15
#define  IO_PAD45_PIOCFG_PULL_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD45_PIOCFG_PULL_SEL_MASK) >> IO_PAD45_PIOCFG_PULL_SEL_SHIFT)
#define  IO_PAD45_PIOCFG_PULL_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD45_PIOCFG_PULL_SEL_MASK) | (((uint32_t)val) << IO_PAD45_PIOCFG_PULL_SEL_SHIFT))

#define  IO_PAD45_PIOCFG_PUEN_MASK 0x4000
#define  IO_PAD45_PIOCFG_PUEN_SHIFT 14
#define  IO_PAD45_PIOCFG_PUEN_MASK_SHIFT(reg) (((reg) & IO_PAD45_PIOCFG_PUEN_MASK) >> IO_PAD45_PIOCFG_PUEN_SHIFT)
#define  IO_PAD45_PIOCFG_PUEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD45_PIOCFG_PUEN_MASK) | (((uint32_t)val) << IO_PAD45_PIOCFG_PUEN_SHIFT))

#define  IO_PAD45_PIOCFG_PDEN_MASK 0x2000
#define  IO_PAD45_PIOCFG_PDEN_SHIFT 13
#define  IO_PAD45_PIOCFG_PDEN_MASK_SHIFT(reg) (((reg) & IO_PAD45_PIOCFG_PDEN_MASK) >> IO_PAD45_PIOCFG_PDEN_SHIFT)
#define  IO_PAD45_PIOCFG_PDEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD45_PIOCFG_PDEN_MASK) | (((uint32_t)val) << IO_PAD45_PIOCFG_PDEN_SHIFT))

#define  IO_PAD45_PIOCFG_SR_MASK 0x1800
#define  IO_PAD45_PIOCFG_SR_SHIFT 11
#define  IO_PAD45_PIOCFG_SR_MASK_SHIFT(reg) (((reg) & IO_PAD45_PIOCFG_SR_MASK) >> IO_PAD45_PIOCFG_SR_SHIFT)
#define  IO_PAD45_PIOCFG_SR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD45_PIOCFG_SR_MASK) | (((uint32_t)val) << IO_PAD45_PIOCFG_SR_SHIFT))

#define  IO_PAD45_PIOCFG_SLP_DI_MASK 0x400
#define  IO_PAD45_PIOCFG_SLP_DI_SHIFT 10
#define  IO_PAD45_PIOCFG_SLP_DI_MASK_SHIFT(reg) (((reg) & IO_PAD45_PIOCFG_SLP_DI_MASK) >> IO_PAD45_PIOCFG_SLP_DI_SHIFT)
#define  IO_PAD45_PIOCFG_SLP_DI_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD45_PIOCFG_SLP_DI_MASK) | (((uint32_t)val) << IO_PAD45_PIOCFG_SLP_DI_SHIFT))

#define  IO_PAD45_PIOCFG_SLP_CNTRL_MASK 0x200
#define  IO_PAD45_PIOCFG_SLP_CNTRL_SHIFT 9
#define  IO_PAD45_PIOCFG_SLP_CNTRL_MASK_SHIFT(reg) (((reg) & IO_PAD45_PIOCFG_SLP_CNTRL_MASK) >> IO_PAD45_PIOCFG_SLP_CNTRL_SHIFT)
#define  IO_PAD45_PIOCFG_SLP_CNTRL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD45_PIOCFG_SLP_CNTRL_MASK) | (((uint32_t)val) << IO_PAD45_PIOCFG_SLP_CNTRL_SHIFT))

#define  IO_PAD45_PIOCFG_SLP_DO_MASK 0x100
#define  IO_PAD45_PIOCFG_SLP_DO_SHIFT 8
#define  IO_PAD45_PIOCFG_SLP_DO_MASK_SHIFT(reg) (((reg) & IO_PAD45_PIOCFG_SLP_DO_MASK) >> IO_PAD45_PIOCFG_SLP_DO_SHIFT)
#define  IO_PAD45_PIOCFG_SLP_DO_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD45_PIOCFG_SLP_DO_MASK) | (((uint32_t)val) << IO_PAD45_PIOCFG_SLP_DO_SHIFT))

#define  IO_PAD45_PIOCFG_SLP_DIR_MASK 0x80
#define  IO_PAD45_PIOCFG_SLP_DIR_SHIFT 7
#define  IO_PAD45_PIOCFG_SLP_DIR_MASK_SHIFT(reg) (((reg) & IO_PAD45_PIOCFG_SLP_DIR_MASK) >> IO_PAD45_PIOCFG_SLP_DIR_SHIFT)
#define  IO_PAD45_PIOCFG_SLP_DIR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD45_PIOCFG_SLP_DIR_MASK) | (((uint32_t)val) << IO_PAD45_PIOCFG_SLP_DIR_SHIFT))

#define  IO_PAD45_PIOCFG_EDGE_EN_N_MASK 0x40
#define  IO_PAD45_PIOCFG_EDGE_EN_N_SHIFT 6
#define  IO_PAD45_PIOCFG_EDGE_EN_N_MASK_SHIFT(reg) (((reg) & IO_PAD45_PIOCFG_EDGE_EN_N_MASK) >> IO_PAD45_PIOCFG_EDGE_EN_N_SHIFT)
#define  IO_PAD45_PIOCFG_EDGE_EN_N_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD45_PIOCFG_EDGE_EN_N_MASK) | (((uint32_t)val) << IO_PAD45_PIOCFG_EDGE_EN_N_SHIFT))

#define  IO_PAD45_PIOCFG_EDGE_FALL_EN_MASK 0x20
#define  IO_PAD45_PIOCFG_EDGE_FALL_EN_SHIFT 5
#define  IO_PAD45_PIOCFG_EDGE_FALL_EN_MASK_SHIFT(reg) (((reg) & IO_PAD45_PIOCFG_EDGE_FALL_EN_MASK) >> IO_PAD45_PIOCFG_EDGE_FALL_EN_SHIFT)
#define  IO_PAD45_PIOCFG_EDGE_FALL_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD45_PIOCFG_EDGE_FALL_EN_MASK) | (((uint32_t)val) << IO_PAD45_PIOCFG_EDGE_FALL_EN_SHIFT))

#define  IO_PAD45_PIOCFG_EDGE_RISE_EN_MASK 0x10
#define  IO_PAD45_PIOCFG_EDGE_RISE_EN_SHIFT 4
#define  IO_PAD45_PIOCFG_EDGE_RISE_EN_MASK_SHIFT(reg) (((reg) & IO_PAD45_PIOCFG_EDGE_RISE_EN_MASK) >> IO_PAD45_PIOCFG_EDGE_RISE_EN_SHIFT)
#define  IO_PAD45_PIOCFG_EDGE_RISE_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD45_PIOCFG_EDGE_RISE_EN_MASK) | (((uint32_t)val) << IO_PAD45_PIOCFG_EDGE_RISE_EN_SHIFT))

#define  IO_PAD45_PIOCFG_SLP_SEL_MASK 0x8
#define  IO_PAD45_PIOCFG_SLP_SEL_SHIFT 3
#define  IO_PAD45_PIOCFG_SLP_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD45_PIOCFG_SLP_SEL_MASK) >> IO_PAD45_PIOCFG_SLP_SEL_SHIFT)
#define  IO_PAD45_PIOCFG_SLP_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD45_PIOCFG_SLP_SEL_MASK) | (((uint32_t)val) << IO_PAD45_PIOCFG_SLP_SEL_SHIFT))

#define  IO_PAD45_PIOCFG_FUNC_SEL_MASK 0x7
#define  IO_PAD45_PIOCFG_FUNC_SEL_SHIFT 0
#define  IO_PAD45_PIOCFG_FUNC_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD45_PIOCFG_FUNC_SEL_MASK) >> IO_PAD45_PIOCFG_FUNC_SEL_SHIFT)
#define  IO_PAD45_PIOCFG_FUNC_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD45_PIOCFG_FUNC_SEL_MASK) | (((uint32_t)val) << IO_PAD45_PIOCFG_FUNC_SEL_SHIFT))

//====================================================================
//
//Register File: IO_PAD46 Configuration Registers (IO_PAD46)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

//====================================================================
//Register: IO_PAD46 Configuration Register (PIOCFG)
/** \brief "PHI_PADXDC_SRC" Pad*/
//====================================================================

#define  IO_PAD46_PIOCFG_RESERVED1_MASK 0xfc000000
#define  IO_PAD46_PIOCFG_RESERVED1_SHIFT 26
#define  IO_PAD46_PIOCFG_RESERVED1_MASK_SHIFT(reg) (((reg) & IO_PAD46_PIOCFG_RESERVED1_MASK) >> IO_PAD46_PIOCFG_RESERVED1_SHIFT)
#define  IO_PAD46_PIOCFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD46_PIOCFG_RESERVED1_MASK) | (((uint32_t)val) << IO_PAD46_PIOCFG_RESERVED1_SHIFT))

#define  IO_PAD46_PIOCFG_PD_MASK 0x2000000
#define  IO_PAD46_PIOCFG_PD_SHIFT 25
#define  IO_PAD46_PIOCFG_PD_MASK_SHIFT(reg) (((reg) & IO_PAD46_PIOCFG_PD_MASK) >> IO_PAD46_PIOCFG_PD_SHIFT)
#define  IO_PAD46_PIOCFG_PD_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD46_PIOCFG_PD_MASK) | (((uint32_t)val) << IO_PAD46_PIOCFG_PD_SHIFT))

#define  IO_PAD46_PIOCFG_ODT_EN_MASK 0x1000000
#define  IO_PAD46_PIOCFG_ODT_EN_SHIFT 24
#define  IO_PAD46_PIOCFG_ODT_EN_MASK_SHIFT(reg) (((reg) & IO_PAD46_PIOCFG_ODT_EN_MASK) >> IO_PAD46_PIOCFG_ODT_EN_SHIFT)
#define  IO_PAD46_PIOCFG_ODT_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD46_PIOCFG_ODT_EN_MASK) | (((uint32_t)val) << IO_PAD46_PIOCFG_ODT_EN_SHIFT))

#define  IO_PAD46_PIOCFG_LED_EN_MASK 0x800000
#define  IO_PAD46_PIOCFG_LED_EN_SHIFT 23
#define  IO_PAD46_PIOCFG_LED_EN_MASK_SHIFT(reg) (((reg) & IO_PAD46_PIOCFG_LED_EN_MASK) >> IO_PAD46_PIOCFG_LED_EN_SHIFT)
#define  IO_PAD46_PIOCFG_LED_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD46_PIOCFG_LED_EN_MASK) | (((uint32_t)val) << IO_PAD46_PIOCFG_LED_EN_SHIFT))

#define  IO_PAD46_PIOCFG_I2C_SEL_MASK 0x600000
#define  IO_PAD46_PIOCFG_I2C_SEL_SHIFT 21
#define  IO_PAD46_PIOCFG_I2C_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD46_PIOCFG_I2C_SEL_MASK) >> IO_PAD46_PIOCFG_I2C_SEL_SHIFT)
#define  IO_PAD46_PIOCFG_I2C_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD46_PIOCFG_I2C_SEL_MASK) | (((uint32_t)val) << IO_PAD46_PIOCFG_I2C_SEL_SHIFT))

#define  IO_PAD46_PIOCFG_DGTBSEL_MASK 0x1e0000
#define  IO_PAD46_PIOCFG_DGTBSEL_SHIFT 17
#define  IO_PAD46_PIOCFG_DGTBSEL_MASK_SHIFT(reg) (((reg) & IO_PAD46_PIOCFG_DGTBSEL_MASK) >> IO_PAD46_PIOCFG_DGTBSEL_SHIFT)
#define  IO_PAD46_PIOCFG_DGTBSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD46_PIOCFG_DGTBSEL_MASK) | (((uint32_t)val) << IO_PAD46_PIOCFG_DGTBSEL_SHIFT))

#define  IO_PAD46_PIOCFG_RAWSEL_MASK 0x10000
#define  IO_PAD46_PIOCFG_RAWSEL_SHIFT 16
#define  IO_PAD46_PIOCFG_RAWSEL_MASK_SHIFT(reg) (((reg) & IO_PAD46_PIOCFG_RAWSEL_MASK) >> IO_PAD46_PIOCFG_RAWSEL_SHIFT)
#define  IO_PAD46_PIOCFG_RAWSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD46_PIOCFG_RAWSEL_MASK) | (((uint32_t)val) << IO_PAD46_PIOCFG_RAWSEL_SHIFT))

#define  IO_PAD46_PIOCFG_PULL_SEL_MASK 0x8000
#define  IO_PAD46_PIOCFG_PULL_SEL_SHIFT 15
#define  IO_PAD46_PIOCFG_PULL_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD46_PIOCFG_PULL_SEL_MASK) >> IO_PAD46_PIOCFG_PULL_SEL_SHIFT)
#define  IO_PAD46_PIOCFG_PULL_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD46_PIOCFG_PULL_SEL_MASK) | (((uint32_t)val) << IO_PAD46_PIOCFG_PULL_SEL_SHIFT))

#define  IO_PAD46_PIOCFG_PUEN_MASK 0x4000
#define  IO_PAD46_PIOCFG_PUEN_SHIFT 14
#define  IO_PAD46_PIOCFG_PUEN_MASK_SHIFT(reg) (((reg) & IO_PAD46_PIOCFG_PUEN_MASK) >> IO_PAD46_PIOCFG_PUEN_SHIFT)
#define  IO_PAD46_PIOCFG_PUEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD46_PIOCFG_PUEN_MASK) | (((uint32_t)val) << IO_PAD46_PIOCFG_PUEN_SHIFT))

#define  IO_PAD46_PIOCFG_PDEN_MASK 0x2000
#define  IO_PAD46_PIOCFG_PDEN_SHIFT 13
#define  IO_PAD46_PIOCFG_PDEN_MASK_SHIFT(reg) (((reg) & IO_PAD46_PIOCFG_PDEN_MASK) >> IO_PAD46_PIOCFG_PDEN_SHIFT)
#define  IO_PAD46_PIOCFG_PDEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD46_PIOCFG_PDEN_MASK) | (((uint32_t)val) << IO_PAD46_PIOCFG_PDEN_SHIFT))

#define  IO_PAD46_PIOCFG_SR_MASK 0x1800
#define  IO_PAD46_PIOCFG_SR_SHIFT 11
#define  IO_PAD46_PIOCFG_SR_MASK_SHIFT(reg) (((reg) & IO_PAD46_PIOCFG_SR_MASK) >> IO_PAD46_PIOCFG_SR_SHIFT)
#define  IO_PAD46_PIOCFG_SR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD46_PIOCFG_SR_MASK) | (((uint32_t)val) << IO_PAD46_PIOCFG_SR_SHIFT))

#define  IO_PAD46_PIOCFG_SLP_DI_MASK 0x400
#define  IO_PAD46_PIOCFG_SLP_DI_SHIFT 10
#define  IO_PAD46_PIOCFG_SLP_DI_MASK_SHIFT(reg) (((reg) & IO_PAD46_PIOCFG_SLP_DI_MASK) >> IO_PAD46_PIOCFG_SLP_DI_SHIFT)
#define  IO_PAD46_PIOCFG_SLP_DI_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD46_PIOCFG_SLP_DI_MASK) | (((uint32_t)val) << IO_PAD46_PIOCFG_SLP_DI_SHIFT))

#define  IO_PAD46_PIOCFG_SLP_CNTRL_MASK 0x200
#define  IO_PAD46_PIOCFG_SLP_CNTRL_SHIFT 9
#define  IO_PAD46_PIOCFG_SLP_CNTRL_MASK_SHIFT(reg) (((reg) & IO_PAD46_PIOCFG_SLP_CNTRL_MASK) >> IO_PAD46_PIOCFG_SLP_CNTRL_SHIFT)
#define  IO_PAD46_PIOCFG_SLP_CNTRL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD46_PIOCFG_SLP_CNTRL_MASK) | (((uint32_t)val) << IO_PAD46_PIOCFG_SLP_CNTRL_SHIFT))

#define  IO_PAD46_PIOCFG_SLP_DO_MASK 0x100
#define  IO_PAD46_PIOCFG_SLP_DO_SHIFT 8
#define  IO_PAD46_PIOCFG_SLP_DO_MASK_SHIFT(reg) (((reg) & IO_PAD46_PIOCFG_SLP_DO_MASK) >> IO_PAD46_PIOCFG_SLP_DO_SHIFT)
#define  IO_PAD46_PIOCFG_SLP_DO_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD46_PIOCFG_SLP_DO_MASK) | (((uint32_t)val) << IO_PAD46_PIOCFG_SLP_DO_SHIFT))

#define  IO_PAD46_PIOCFG_SLP_DIR_MASK 0x80
#define  IO_PAD46_PIOCFG_SLP_DIR_SHIFT 7
#define  IO_PAD46_PIOCFG_SLP_DIR_MASK_SHIFT(reg) (((reg) & IO_PAD46_PIOCFG_SLP_DIR_MASK) >> IO_PAD46_PIOCFG_SLP_DIR_SHIFT)
#define  IO_PAD46_PIOCFG_SLP_DIR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD46_PIOCFG_SLP_DIR_MASK) | (((uint32_t)val) << IO_PAD46_PIOCFG_SLP_DIR_SHIFT))

#define  IO_PAD46_PIOCFG_EDGE_EN_N_MASK 0x40
#define  IO_PAD46_PIOCFG_EDGE_EN_N_SHIFT 6
#define  IO_PAD46_PIOCFG_EDGE_EN_N_MASK_SHIFT(reg) (((reg) & IO_PAD46_PIOCFG_EDGE_EN_N_MASK) >> IO_PAD46_PIOCFG_EDGE_EN_N_SHIFT)
#define  IO_PAD46_PIOCFG_EDGE_EN_N_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD46_PIOCFG_EDGE_EN_N_MASK) | (((uint32_t)val) << IO_PAD46_PIOCFG_EDGE_EN_N_SHIFT))

#define  IO_PAD46_PIOCFG_EDGE_FALL_EN_MASK 0x20
#define  IO_PAD46_PIOCFG_EDGE_FALL_EN_SHIFT 5
#define  IO_PAD46_PIOCFG_EDGE_FALL_EN_MASK_SHIFT(reg) (((reg) & IO_PAD46_PIOCFG_EDGE_FALL_EN_MASK) >> IO_PAD46_PIOCFG_EDGE_FALL_EN_SHIFT)
#define  IO_PAD46_PIOCFG_EDGE_FALL_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD46_PIOCFG_EDGE_FALL_EN_MASK) | (((uint32_t)val) << IO_PAD46_PIOCFG_EDGE_FALL_EN_SHIFT))

#define  IO_PAD46_PIOCFG_EDGE_RISE_EN_MASK 0x10
#define  IO_PAD46_PIOCFG_EDGE_RISE_EN_SHIFT 4
#define  IO_PAD46_PIOCFG_EDGE_RISE_EN_MASK_SHIFT(reg) (((reg) & IO_PAD46_PIOCFG_EDGE_RISE_EN_MASK) >> IO_PAD46_PIOCFG_EDGE_RISE_EN_SHIFT)
#define  IO_PAD46_PIOCFG_EDGE_RISE_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD46_PIOCFG_EDGE_RISE_EN_MASK) | (((uint32_t)val) << IO_PAD46_PIOCFG_EDGE_RISE_EN_SHIFT))

#define  IO_PAD46_PIOCFG_SLP_SEL_MASK 0x8
#define  IO_PAD46_PIOCFG_SLP_SEL_SHIFT 3
#define  IO_PAD46_PIOCFG_SLP_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD46_PIOCFG_SLP_SEL_MASK) >> IO_PAD46_PIOCFG_SLP_SEL_SHIFT)
#define  IO_PAD46_PIOCFG_SLP_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD46_PIOCFG_SLP_SEL_MASK) | (((uint32_t)val) << IO_PAD46_PIOCFG_SLP_SEL_SHIFT))

#define  IO_PAD46_PIOCFG_FUNC_SEL_MASK 0x7
#define  IO_PAD46_PIOCFG_FUNC_SEL_SHIFT 0
#define  IO_PAD46_PIOCFG_FUNC_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD46_PIOCFG_FUNC_SEL_MASK) >> IO_PAD46_PIOCFG_FUNC_SEL_SHIFT)
#define  IO_PAD46_PIOCFG_FUNC_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD46_PIOCFG_FUNC_SEL_MASK) | (((uint32_t)val) << IO_PAD46_PIOCFG_FUNC_SEL_SHIFT))

//====================================================================
//
//Register File: IO_PAD47 Configuration Registers (IO_PAD47)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

//====================================================================
//Register: IO_PAD47 Configuration Register (PIOCFG)
/** \brief "PHI_PADXDC_SRC" Pad*/
//====================================================================

#define  IO_PAD47_PIOCFG_RESERVED1_MASK 0xfc000000
#define  IO_PAD47_PIOCFG_RESERVED1_SHIFT 26
#define  IO_PAD47_PIOCFG_RESERVED1_MASK_SHIFT(reg) (((reg) & IO_PAD47_PIOCFG_RESERVED1_MASK) >> IO_PAD47_PIOCFG_RESERVED1_SHIFT)
#define  IO_PAD47_PIOCFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD47_PIOCFG_RESERVED1_MASK) | (((uint32_t)val) << IO_PAD47_PIOCFG_RESERVED1_SHIFT))

#define  IO_PAD47_PIOCFG_PD_MASK 0x2000000
#define  IO_PAD47_PIOCFG_PD_SHIFT 25
#define  IO_PAD47_PIOCFG_PD_MASK_SHIFT(reg) (((reg) & IO_PAD47_PIOCFG_PD_MASK) >> IO_PAD47_PIOCFG_PD_SHIFT)
#define  IO_PAD47_PIOCFG_PD_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD47_PIOCFG_PD_MASK) | (((uint32_t)val) << IO_PAD47_PIOCFG_PD_SHIFT))

#define  IO_PAD47_PIOCFG_ODT_EN_MASK 0x1000000
#define  IO_PAD47_PIOCFG_ODT_EN_SHIFT 24
#define  IO_PAD47_PIOCFG_ODT_EN_MASK_SHIFT(reg) (((reg) & IO_PAD47_PIOCFG_ODT_EN_MASK) >> IO_PAD47_PIOCFG_ODT_EN_SHIFT)
#define  IO_PAD47_PIOCFG_ODT_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD47_PIOCFG_ODT_EN_MASK) | (((uint32_t)val) << IO_PAD47_PIOCFG_ODT_EN_SHIFT))

#define  IO_PAD47_PIOCFG_LED_EN_MASK 0x800000
#define  IO_PAD47_PIOCFG_LED_EN_SHIFT 23
#define  IO_PAD47_PIOCFG_LED_EN_MASK_SHIFT(reg) (((reg) & IO_PAD47_PIOCFG_LED_EN_MASK) >> IO_PAD47_PIOCFG_LED_EN_SHIFT)
#define  IO_PAD47_PIOCFG_LED_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD47_PIOCFG_LED_EN_MASK) | (((uint32_t)val) << IO_PAD47_PIOCFG_LED_EN_SHIFT))

#define  IO_PAD47_PIOCFG_I2C_SEL_MASK 0x600000
#define  IO_PAD47_PIOCFG_I2C_SEL_SHIFT 21
#define  IO_PAD47_PIOCFG_I2C_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD47_PIOCFG_I2C_SEL_MASK) >> IO_PAD47_PIOCFG_I2C_SEL_SHIFT)
#define  IO_PAD47_PIOCFG_I2C_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD47_PIOCFG_I2C_SEL_MASK) | (((uint32_t)val) << IO_PAD47_PIOCFG_I2C_SEL_SHIFT))

#define  IO_PAD47_PIOCFG_DGTBSEL_MASK 0x1e0000
#define  IO_PAD47_PIOCFG_DGTBSEL_SHIFT 17
#define  IO_PAD47_PIOCFG_DGTBSEL_MASK_SHIFT(reg) (((reg) & IO_PAD47_PIOCFG_DGTBSEL_MASK) >> IO_PAD47_PIOCFG_DGTBSEL_SHIFT)
#define  IO_PAD47_PIOCFG_DGTBSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD47_PIOCFG_DGTBSEL_MASK) | (((uint32_t)val) << IO_PAD47_PIOCFG_DGTBSEL_SHIFT))

#define  IO_PAD47_PIOCFG_RAWSEL_MASK 0x10000
#define  IO_PAD47_PIOCFG_RAWSEL_SHIFT 16
#define  IO_PAD47_PIOCFG_RAWSEL_MASK_SHIFT(reg) (((reg) & IO_PAD47_PIOCFG_RAWSEL_MASK) >> IO_PAD47_PIOCFG_RAWSEL_SHIFT)
#define  IO_PAD47_PIOCFG_RAWSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD47_PIOCFG_RAWSEL_MASK) | (((uint32_t)val) << IO_PAD47_PIOCFG_RAWSEL_SHIFT))

#define  IO_PAD47_PIOCFG_PULL_SEL_MASK 0x8000
#define  IO_PAD47_PIOCFG_PULL_SEL_SHIFT 15
#define  IO_PAD47_PIOCFG_PULL_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD47_PIOCFG_PULL_SEL_MASK) >> IO_PAD47_PIOCFG_PULL_SEL_SHIFT)
#define  IO_PAD47_PIOCFG_PULL_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD47_PIOCFG_PULL_SEL_MASK) | (((uint32_t)val) << IO_PAD47_PIOCFG_PULL_SEL_SHIFT))

#define  IO_PAD47_PIOCFG_PUEN_MASK 0x4000
#define  IO_PAD47_PIOCFG_PUEN_SHIFT 14
#define  IO_PAD47_PIOCFG_PUEN_MASK_SHIFT(reg) (((reg) & IO_PAD47_PIOCFG_PUEN_MASK) >> IO_PAD47_PIOCFG_PUEN_SHIFT)
#define  IO_PAD47_PIOCFG_PUEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD47_PIOCFG_PUEN_MASK) | (((uint32_t)val) << IO_PAD47_PIOCFG_PUEN_SHIFT))

#define  IO_PAD47_PIOCFG_PDEN_MASK 0x2000
#define  IO_PAD47_PIOCFG_PDEN_SHIFT 13
#define  IO_PAD47_PIOCFG_PDEN_MASK_SHIFT(reg) (((reg) & IO_PAD47_PIOCFG_PDEN_MASK) >> IO_PAD47_PIOCFG_PDEN_SHIFT)
#define  IO_PAD47_PIOCFG_PDEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD47_PIOCFG_PDEN_MASK) | (((uint32_t)val) << IO_PAD47_PIOCFG_PDEN_SHIFT))

#define  IO_PAD47_PIOCFG_SR_MASK 0x1800
#define  IO_PAD47_PIOCFG_SR_SHIFT 11
#define  IO_PAD47_PIOCFG_SR_MASK_SHIFT(reg) (((reg) & IO_PAD47_PIOCFG_SR_MASK) >> IO_PAD47_PIOCFG_SR_SHIFT)
#define  IO_PAD47_PIOCFG_SR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD47_PIOCFG_SR_MASK) | (((uint32_t)val) << IO_PAD47_PIOCFG_SR_SHIFT))

#define  IO_PAD47_PIOCFG_SLP_DI_MASK 0x400
#define  IO_PAD47_PIOCFG_SLP_DI_SHIFT 10
#define  IO_PAD47_PIOCFG_SLP_DI_MASK_SHIFT(reg) (((reg) & IO_PAD47_PIOCFG_SLP_DI_MASK) >> IO_PAD47_PIOCFG_SLP_DI_SHIFT)
#define  IO_PAD47_PIOCFG_SLP_DI_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD47_PIOCFG_SLP_DI_MASK) | (((uint32_t)val) << IO_PAD47_PIOCFG_SLP_DI_SHIFT))

#define  IO_PAD47_PIOCFG_SLP_CNTRL_MASK 0x200
#define  IO_PAD47_PIOCFG_SLP_CNTRL_SHIFT 9
#define  IO_PAD47_PIOCFG_SLP_CNTRL_MASK_SHIFT(reg) (((reg) & IO_PAD47_PIOCFG_SLP_CNTRL_MASK) >> IO_PAD47_PIOCFG_SLP_CNTRL_SHIFT)
#define  IO_PAD47_PIOCFG_SLP_CNTRL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD47_PIOCFG_SLP_CNTRL_MASK) | (((uint32_t)val) << IO_PAD47_PIOCFG_SLP_CNTRL_SHIFT))

#define  IO_PAD47_PIOCFG_SLP_DO_MASK 0x100
#define  IO_PAD47_PIOCFG_SLP_DO_SHIFT 8
#define  IO_PAD47_PIOCFG_SLP_DO_MASK_SHIFT(reg) (((reg) & IO_PAD47_PIOCFG_SLP_DO_MASK) >> IO_PAD47_PIOCFG_SLP_DO_SHIFT)
#define  IO_PAD47_PIOCFG_SLP_DO_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD47_PIOCFG_SLP_DO_MASK) | (((uint32_t)val) << IO_PAD47_PIOCFG_SLP_DO_SHIFT))

#define  IO_PAD47_PIOCFG_SLP_DIR_MASK 0x80
#define  IO_PAD47_PIOCFG_SLP_DIR_SHIFT 7
#define  IO_PAD47_PIOCFG_SLP_DIR_MASK_SHIFT(reg) (((reg) & IO_PAD47_PIOCFG_SLP_DIR_MASK) >> IO_PAD47_PIOCFG_SLP_DIR_SHIFT)
#define  IO_PAD47_PIOCFG_SLP_DIR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD47_PIOCFG_SLP_DIR_MASK) | (((uint32_t)val) << IO_PAD47_PIOCFG_SLP_DIR_SHIFT))

#define  IO_PAD47_PIOCFG_EDGE_EN_N_MASK 0x40
#define  IO_PAD47_PIOCFG_EDGE_EN_N_SHIFT 6
#define  IO_PAD47_PIOCFG_EDGE_EN_N_MASK_SHIFT(reg) (((reg) & IO_PAD47_PIOCFG_EDGE_EN_N_MASK) >> IO_PAD47_PIOCFG_EDGE_EN_N_SHIFT)
#define  IO_PAD47_PIOCFG_EDGE_EN_N_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD47_PIOCFG_EDGE_EN_N_MASK) | (((uint32_t)val) << IO_PAD47_PIOCFG_EDGE_EN_N_SHIFT))

#define  IO_PAD47_PIOCFG_EDGE_FALL_EN_MASK 0x20
#define  IO_PAD47_PIOCFG_EDGE_FALL_EN_SHIFT 5
#define  IO_PAD47_PIOCFG_EDGE_FALL_EN_MASK_SHIFT(reg) (((reg) & IO_PAD47_PIOCFG_EDGE_FALL_EN_MASK) >> IO_PAD47_PIOCFG_EDGE_FALL_EN_SHIFT)
#define  IO_PAD47_PIOCFG_EDGE_FALL_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD47_PIOCFG_EDGE_FALL_EN_MASK) | (((uint32_t)val) << IO_PAD47_PIOCFG_EDGE_FALL_EN_SHIFT))

#define  IO_PAD47_PIOCFG_EDGE_RISE_EN_MASK 0x10
#define  IO_PAD47_PIOCFG_EDGE_RISE_EN_SHIFT 4
#define  IO_PAD47_PIOCFG_EDGE_RISE_EN_MASK_SHIFT(reg) (((reg) & IO_PAD47_PIOCFG_EDGE_RISE_EN_MASK) >> IO_PAD47_PIOCFG_EDGE_RISE_EN_SHIFT)
#define  IO_PAD47_PIOCFG_EDGE_RISE_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD47_PIOCFG_EDGE_RISE_EN_MASK) | (((uint32_t)val) << IO_PAD47_PIOCFG_EDGE_RISE_EN_SHIFT))

#define  IO_PAD47_PIOCFG_SLP_SEL_MASK 0x8
#define  IO_PAD47_PIOCFG_SLP_SEL_SHIFT 3
#define  IO_PAD47_PIOCFG_SLP_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD47_PIOCFG_SLP_SEL_MASK) >> IO_PAD47_PIOCFG_SLP_SEL_SHIFT)
#define  IO_PAD47_PIOCFG_SLP_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD47_PIOCFG_SLP_SEL_MASK) | (((uint32_t)val) << IO_PAD47_PIOCFG_SLP_SEL_SHIFT))

#define  IO_PAD47_PIOCFG_FUNC_SEL_MASK 0x7
#define  IO_PAD47_PIOCFG_FUNC_SEL_SHIFT 0
#define  IO_PAD47_PIOCFG_FUNC_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD47_PIOCFG_FUNC_SEL_MASK) >> IO_PAD47_PIOCFG_FUNC_SEL_SHIFT)
#define  IO_PAD47_PIOCFG_FUNC_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD47_PIOCFG_FUNC_SEL_MASK) | (((uint32_t)val) << IO_PAD47_PIOCFG_FUNC_SEL_SHIFT))

//====================================================================
//
//Register File: IO_PAD48 Configuration Registers (IO_PAD48)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

//====================================================================
//Register: IO_PAD48 Configuration Register (PIOCFG)
/** \brief "PHI_PADXDC_SRC" Pad*/
//====================================================================

#define  IO_PAD48_PIOCFG_RESERVED1_MASK 0xfc000000
#define  IO_PAD48_PIOCFG_RESERVED1_SHIFT 26
#define  IO_PAD48_PIOCFG_RESERVED1_MASK_SHIFT(reg) (((reg) & IO_PAD48_PIOCFG_RESERVED1_MASK) >> IO_PAD48_PIOCFG_RESERVED1_SHIFT)
#define  IO_PAD48_PIOCFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD48_PIOCFG_RESERVED1_MASK) | (((uint32_t)val) << IO_PAD48_PIOCFG_RESERVED1_SHIFT))

#define  IO_PAD48_PIOCFG_PD_MASK 0x2000000
#define  IO_PAD48_PIOCFG_PD_SHIFT 25
#define  IO_PAD48_PIOCFG_PD_MASK_SHIFT(reg) (((reg) & IO_PAD48_PIOCFG_PD_MASK) >> IO_PAD48_PIOCFG_PD_SHIFT)
#define  IO_PAD48_PIOCFG_PD_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD48_PIOCFG_PD_MASK) | (((uint32_t)val) << IO_PAD48_PIOCFG_PD_SHIFT))

#define  IO_PAD48_PIOCFG_ODT_EN_MASK 0x1000000
#define  IO_PAD48_PIOCFG_ODT_EN_SHIFT 24
#define  IO_PAD48_PIOCFG_ODT_EN_MASK_SHIFT(reg) (((reg) & IO_PAD48_PIOCFG_ODT_EN_MASK) >> IO_PAD48_PIOCFG_ODT_EN_SHIFT)
#define  IO_PAD48_PIOCFG_ODT_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD48_PIOCFG_ODT_EN_MASK) | (((uint32_t)val) << IO_PAD48_PIOCFG_ODT_EN_SHIFT))

#define  IO_PAD48_PIOCFG_LED_EN_MASK 0x800000
#define  IO_PAD48_PIOCFG_LED_EN_SHIFT 23
#define  IO_PAD48_PIOCFG_LED_EN_MASK_SHIFT(reg) (((reg) & IO_PAD48_PIOCFG_LED_EN_MASK) >> IO_PAD48_PIOCFG_LED_EN_SHIFT)
#define  IO_PAD48_PIOCFG_LED_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD48_PIOCFG_LED_EN_MASK) | (((uint32_t)val) << IO_PAD48_PIOCFG_LED_EN_SHIFT))

#define  IO_PAD48_PIOCFG_I2C_SEL_MASK 0x600000
#define  IO_PAD48_PIOCFG_I2C_SEL_SHIFT 21
#define  IO_PAD48_PIOCFG_I2C_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD48_PIOCFG_I2C_SEL_MASK) >> IO_PAD48_PIOCFG_I2C_SEL_SHIFT)
#define  IO_PAD48_PIOCFG_I2C_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD48_PIOCFG_I2C_SEL_MASK) | (((uint32_t)val) << IO_PAD48_PIOCFG_I2C_SEL_SHIFT))

#define  IO_PAD48_PIOCFG_DGTBSEL_MASK 0x1e0000
#define  IO_PAD48_PIOCFG_DGTBSEL_SHIFT 17
#define  IO_PAD48_PIOCFG_DGTBSEL_MASK_SHIFT(reg) (((reg) & IO_PAD48_PIOCFG_DGTBSEL_MASK) >> IO_PAD48_PIOCFG_DGTBSEL_SHIFT)
#define  IO_PAD48_PIOCFG_DGTBSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD48_PIOCFG_DGTBSEL_MASK) | (((uint32_t)val) << IO_PAD48_PIOCFG_DGTBSEL_SHIFT))

#define  IO_PAD48_PIOCFG_RAWSEL_MASK 0x10000
#define  IO_PAD48_PIOCFG_RAWSEL_SHIFT 16
#define  IO_PAD48_PIOCFG_RAWSEL_MASK_SHIFT(reg) (((reg) & IO_PAD48_PIOCFG_RAWSEL_MASK) >> IO_PAD48_PIOCFG_RAWSEL_SHIFT)
#define  IO_PAD48_PIOCFG_RAWSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD48_PIOCFG_RAWSEL_MASK) | (((uint32_t)val) << IO_PAD48_PIOCFG_RAWSEL_SHIFT))

#define  IO_PAD48_PIOCFG_PULL_SEL_MASK 0x8000
#define  IO_PAD48_PIOCFG_PULL_SEL_SHIFT 15
#define  IO_PAD48_PIOCFG_PULL_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD48_PIOCFG_PULL_SEL_MASK) >> IO_PAD48_PIOCFG_PULL_SEL_SHIFT)
#define  IO_PAD48_PIOCFG_PULL_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD48_PIOCFG_PULL_SEL_MASK) | (((uint32_t)val) << IO_PAD48_PIOCFG_PULL_SEL_SHIFT))

#define  IO_PAD48_PIOCFG_PUEN_MASK 0x4000
#define  IO_PAD48_PIOCFG_PUEN_SHIFT 14
#define  IO_PAD48_PIOCFG_PUEN_MASK_SHIFT(reg) (((reg) & IO_PAD48_PIOCFG_PUEN_MASK) >> IO_PAD48_PIOCFG_PUEN_SHIFT)
#define  IO_PAD48_PIOCFG_PUEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD48_PIOCFG_PUEN_MASK) | (((uint32_t)val) << IO_PAD48_PIOCFG_PUEN_SHIFT))

#define  IO_PAD48_PIOCFG_PDEN_MASK 0x2000
#define  IO_PAD48_PIOCFG_PDEN_SHIFT 13
#define  IO_PAD48_PIOCFG_PDEN_MASK_SHIFT(reg) (((reg) & IO_PAD48_PIOCFG_PDEN_MASK) >> IO_PAD48_PIOCFG_PDEN_SHIFT)
#define  IO_PAD48_PIOCFG_PDEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD48_PIOCFG_PDEN_MASK) | (((uint32_t)val) << IO_PAD48_PIOCFG_PDEN_SHIFT))

#define  IO_PAD48_PIOCFG_SR_MASK 0x1800
#define  IO_PAD48_PIOCFG_SR_SHIFT 11
#define  IO_PAD48_PIOCFG_SR_MASK_SHIFT(reg) (((reg) & IO_PAD48_PIOCFG_SR_MASK) >> IO_PAD48_PIOCFG_SR_SHIFT)
#define  IO_PAD48_PIOCFG_SR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD48_PIOCFG_SR_MASK) | (((uint32_t)val) << IO_PAD48_PIOCFG_SR_SHIFT))

#define  IO_PAD48_PIOCFG_SLP_DI_MASK 0x400
#define  IO_PAD48_PIOCFG_SLP_DI_SHIFT 10
#define  IO_PAD48_PIOCFG_SLP_DI_MASK_SHIFT(reg) (((reg) & IO_PAD48_PIOCFG_SLP_DI_MASK) >> IO_PAD48_PIOCFG_SLP_DI_SHIFT)
#define  IO_PAD48_PIOCFG_SLP_DI_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD48_PIOCFG_SLP_DI_MASK) | (((uint32_t)val) << IO_PAD48_PIOCFG_SLP_DI_SHIFT))

#define  IO_PAD48_PIOCFG_SLP_CNTRL_MASK 0x200
#define  IO_PAD48_PIOCFG_SLP_CNTRL_SHIFT 9
#define  IO_PAD48_PIOCFG_SLP_CNTRL_MASK_SHIFT(reg) (((reg) & IO_PAD48_PIOCFG_SLP_CNTRL_MASK) >> IO_PAD48_PIOCFG_SLP_CNTRL_SHIFT)
#define  IO_PAD48_PIOCFG_SLP_CNTRL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD48_PIOCFG_SLP_CNTRL_MASK) | (((uint32_t)val) << IO_PAD48_PIOCFG_SLP_CNTRL_SHIFT))

#define  IO_PAD48_PIOCFG_SLP_DO_MASK 0x100
#define  IO_PAD48_PIOCFG_SLP_DO_SHIFT 8
#define  IO_PAD48_PIOCFG_SLP_DO_MASK_SHIFT(reg) (((reg) & IO_PAD48_PIOCFG_SLP_DO_MASK) >> IO_PAD48_PIOCFG_SLP_DO_SHIFT)
#define  IO_PAD48_PIOCFG_SLP_DO_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD48_PIOCFG_SLP_DO_MASK) | (((uint32_t)val) << IO_PAD48_PIOCFG_SLP_DO_SHIFT))

#define  IO_PAD48_PIOCFG_SLP_DIR_MASK 0x80
#define  IO_PAD48_PIOCFG_SLP_DIR_SHIFT 7
#define  IO_PAD48_PIOCFG_SLP_DIR_MASK_SHIFT(reg) (((reg) & IO_PAD48_PIOCFG_SLP_DIR_MASK) >> IO_PAD48_PIOCFG_SLP_DIR_SHIFT)
#define  IO_PAD48_PIOCFG_SLP_DIR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD48_PIOCFG_SLP_DIR_MASK) | (((uint32_t)val) << IO_PAD48_PIOCFG_SLP_DIR_SHIFT))

#define  IO_PAD48_PIOCFG_EDGE_EN_N_MASK 0x40
#define  IO_PAD48_PIOCFG_EDGE_EN_N_SHIFT 6
#define  IO_PAD48_PIOCFG_EDGE_EN_N_MASK_SHIFT(reg) (((reg) & IO_PAD48_PIOCFG_EDGE_EN_N_MASK) >> IO_PAD48_PIOCFG_EDGE_EN_N_SHIFT)
#define  IO_PAD48_PIOCFG_EDGE_EN_N_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD48_PIOCFG_EDGE_EN_N_MASK) | (((uint32_t)val) << IO_PAD48_PIOCFG_EDGE_EN_N_SHIFT))

#define  IO_PAD48_PIOCFG_EDGE_FALL_EN_MASK 0x20
#define  IO_PAD48_PIOCFG_EDGE_FALL_EN_SHIFT 5
#define  IO_PAD48_PIOCFG_EDGE_FALL_EN_MASK_SHIFT(reg) (((reg) & IO_PAD48_PIOCFG_EDGE_FALL_EN_MASK) >> IO_PAD48_PIOCFG_EDGE_FALL_EN_SHIFT)
#define  IO_PAD48_PIOCFG_EDGE_FALL_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD48_PIOCFG_EDGE_FALL_EN_MASK) | (((uint32_t)val) << IO_PAD48_PIOCFG_EDGE_FALL_EN_SHIFT))

#define  IO_PAD48_PIOCFG_EDGE_RISE_EN_MASK 0x10
#define  IO_PAD48_PIOCFG_EDGE_RISE_EN_SHIFT 4
#define  IO_PAD48_PIOCFG_EDGE_RISE_EN_MASK_SHIFT(reg) (((reg) & IO_PAD48_PIOCFG_EDGE_RISE_EN_MASK) >> IO_PAD48_PIOCFG_EDGE_RISE_EN_SHIFT)
#define  IO_PAD48_PIOCFG_EDGE_RISE_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD48_PIOCFG_EDGE_RISE_EN_MASK) | (((uint32_t)val) << IO_PAD48_PIOCFG_EDGE_RISE_EN_SHIFT))

#define  IO_PAD48_PIOCFG_SLP_SEL_MASK 0x8
#define  IO_PAD48_PIOCFG_SLP_SEL_SHIFT 3
#define  IO_PAD48_PIOCFG_SLP_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD48_PIOCFG_SLP_SEL_MASK) >> IO_PAD48_PIOCFG_SLP_SEL_SHIFT)
#define  IO_PAD48_PIOCFG_SLP_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD48_PIOCFG_SLP_SEL_MASK) | (((uint32_t)val) << IO_PAD48_PIOCFG_SLP_SEL_SHIFT))

#define  IO_PAD48_PIOCFG_FUNC_SEL_MASK 0x7
#define  IO_PAD48_PIOCFG_FUNC_SEL_SHIFT 0
#define  IO_PAD48_PIOCFG_FUNC_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD48_PIOCFG_FUNC_SEL_MASK) >> IO_PAD48_PIOCFG_FUNC_SEL_SHIFT)
#define  IO_PAD48_PIOCFG_FUNC_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD48_PIOCFG_FUNC_SEL_MASK) | (((uint32_t)val) << IO_PAD48_PIOCFG_FUNC_SEL_SHIFT))

//====================================================================
//
//Register File: IO_PAD49 Configuration Registers (IO_PAD49)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

//====================================================================
//Register: IO_PAD49 Configuration Register (PIOCFG)
/** \brief "PHI_PADXDC_SRC" Pad*/
//====================================================================

#define  IO_PAD49_PIOCFG_RESERVED1_MASK 0xfc000000
#define  IO_PAD49_PIOCFG_RESERVED1_SHIFT 26
#define  IO_PAD49_PIOCFG_RESERVED1_MASK_SHIFT(reg) (((reg) & IO_PAD49_PIOCFG_RESERVED1_MASK) >> IO_PAD49_PIOCFG_RESERVED1_SHIFT)
#define  IO_PAD49_PIOCFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD49_PIOCFG_RESERVED1_MASK) | (((uint32_t)val) << IO_PAD49_PIOCFG_RESERVED1_SHIFT))

#define  IO_PAD49_PIOCFG_PD_MASK 0x2000000
#define  IO_PAD49_PIOCFG_PD_SHIFT 25
#define  IO_PAD49_PIOCFG_PD_MASK_SHIFT(reg) (((reg) & IO_PAD49_PIOCFG_PD_MASK) >> IO_PAD49_PIOCFG_PD_SHIFT)
#define  IO_PAD49_PIOCFG_PD_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD49_PIOCFG_PD_MASK) | (((uint32_t)val) << IO_PAD49_PIOCFG_PD_SHIFT))

#define  IO_PAD49_PIOCFG_ODT_EN_MASK 0x1000000
#define  IO_PAD49_PIOCFG_ODT_EN_SHIFT 24
#define  IO_PAD49_PIOCFG_ODT_EN_MASK_SHIFT(reg) (((reg) & IO_PAD49_PIOCFG_ODT_EN_MASK) >> IO_PAD49_PIOCFG_ODT_EN_SHIFT)
#define  IO_PAD49_PIOCFG_ODT_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD49_PIOCFG_ODT_EN_MASK) | (((uint32_t)val) << IO_PAD49_PIOCFG_ODT_EN_SHIFT))

#define  IO_PAD49_PIOCFG_LED_EN_MASK 0x800000
#define  IO_PAD49_PIOCFG_LED_EN_SHIFT 23
#define  IO_PAD49_PIOCFG_LED_EN_MASK_SHIFT(reg) (((reg) & IO_PAD49_PIOCFG_LED_EN_MASK) >> IO_PAD49_PIOCFG_LED_EN_SHIFT)
#define  IO_PAD49_PIOCFG_LED_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD49_PIOCFG_LED_EN_MASK) | (((uint32_t)val) << IO_PAD49_PIOCFG_LED_EN_SHIFT))

#define  IO_PAD49_PIOCFG_I2C_SEL_MASK 0x600000
#define  IO_PAD49_PIOCFG_I2C_SEL_SHIFT 21
#define  IO_PAD49_PIOCFG_I2C_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD49_PIOCFG_I2C_SEL_MASK) >> IO_PAD49_PIOCFG_I2C_SEL_SHIFT)
#define  IO_PAD49_PIOCFG_I2C_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD49_PIOCFG_I2C_SEL_MASK) | (((uint32_t)val) << IO_PAD49_PIOCFG_I2C_SEL_SHIFT))

#define  IO_PAD49_PIOCFG_DGTBSEL_MASK 0x1e0000
#define  IO_PAD49_PIOCFG_DGTBSEL_SHIFT 17
#define  IO_PAD49_PIOCFG_DGTBSEL_MASK_SHIFT(reg) (((reg) & IO_PAD49_PIOCFG_DGTBSEL_MASK) >> IO_PAD49_PIOCFG_DGTBSEL_SHIFT)
#define  IO_PAD49_PIOCFG_DGTBSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD49_PIOCFG_DGTBSEL_MASK) | (((uint32_t)val) << IO_PAD49_PIOCFG_DGTBSEL_SHIFT))

#define  IO_PAD49_PIOCFG_RAWSEL_MASK 0x10000
#define  IO_PAD49_PIOCFG_RAWSEL_SHIFT 16
#define  IO_PAD49_PIOCFG_RAWSEL_MASK_SHIFT(reg) (((reg) & IO_PAD49_PIOCFG_RAWSEL_MASK) >> IO_PAD49_PIOCFG_RAWSEL_SHIFT)
#define  IO_PAD49_PIOCFG_RAWSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD49_PIOCFG_RAWSEL_MASK) | (((uint32_t)val) << IO_PAD49_PIOCFG_RAWSEL_SHIFT))

#define  IO_PAD49_PIOCFG_PULL_SEL_MASK 0x8000
#define  IO_PAD49_PIOCFG_PULL_SEL_SHIFT 15
#define  IO_PAD49_PIOCFG_PULL_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD49_PIOCFG_PULL_SEL_MASK) >> IO_PAD49_PIOCFG_PULL_SEL_SHIFT)
#define  IO_PAD49_PIOCFG_PULL_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD49_PIOCFG_PULL_SEL_MASK) | (((uint32_t)val) << IO_PAD49_PIOCFG_PULL_SEL_SHIFT))

#define  IO_PAD49_PIOCFG_PUEN_MASK 0x4000
#define  IO_PAD49_PIOCFG_PUEN_SHIFT 14
#define  IO_PAD49_PIOCFG_PUEN_MASK_SHIFT(reg) (((reg) & IO_PAD49_PIOCFG_PUEN_MASK) >> IO_PAD49_PIOCFG_PUEN_SHIFT)
#define  IO_PAD49_PIOCFG_PUEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD49_PIOCFG_PUEN_MASK) | (((uint32_t)val) << IO_PAD49_PIOCFG_PUEN_SHIFT))

#define  IO_PAD49_PIOCFG_PDEN_MASK 0x2000
#define  IO_PAD49_PIOCFG_PDEN_SHIFT 13
#define  IO_PAD49_PIOCFG_PDEN_MASK_SHIFT(reg) (((reg) & IO_PAD49_PIOCFG_PDEN_MASK) >> IO_PAD49_PIOCFG_PDEN_SHIFT)
#define  IO_PAD49_PIOCFG_PDEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD49_PIOCFG_PDEN_MASK) | (((uint32_t)val) << IO_PAD49_PIOCFG_PDEN_SHIFT))

#define  IO_PAD49_PIOCFG_SR_MASK 0x1800
#define  IO_PAD49_PIOCFG_SR_SHIFT 11
#define  IO_PAD49_PIOCFG_SR_MASK_SHIFT(reg) (((reg) & IO_PAD49_PIOCFG_SR_MASK) >> IO_PAD49_PIOCFG_SR_SHIFT)
#define  IO_PAD49_PIOCFG_SR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD49_PIOCFG_SR_MASK) | (((uint32_t)val) << IO_PAD49_PIOCFG_SR_SHIFT))

#define  IO_PAD49_PIOCFG_SLP_DI_MASK 0x400
#define  IO_PAD49_PIOCFG_SLP_DI_SHIFT 10
#define  IO_PAD49_PIOCFG_SLP_DI_MASK_SHIFT(reg) (((reg) & IO_PAD49_PIOCFG_SLP_DI_MASK) >> IO_PAD49_PIOCFG_SLP_DI_SHIFT)
#define  IO_PAD49_PIOCFG_SLP_DI_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD49_PIOCFG_SLP_DI_MASK) | (((uint32_t)val) << IO_PAD49_PIOCFG_SLP_DI_SHIFT))

#define  IO_PAD49_PIOCFG_SLP_CNTRL_MASK 0x200
#define  IO_PAD49_PIOCFG_SLP_CNTRL_SHIFT 9
#define  IO_PAD49_PIOCFG_SLP_CNTRL_MASK_SHIFT(reg) (((reg) & IO_PAD49_PIOCFG_SLP_CNTRL_MASK) >> IO_PAD49_PIOCFG_SLP_CNTRL_SHIFT)
#define  IO_PAD49_PIOCFG_SLP_CNTRL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD49_PIOCFG_SLP_CNTRL_MASK) | (((uint32_t)val) << IO_PAD49_PIOCFG_SLP_CNTRL_SHIFT))

#define  IO_PAD49_PIOCFG_SLP_DO_MASK 0x100
#define  IO_PAD49_PIOCFG_SLP_DO_SHIFT 8
#define  IO_PAD49_PIOCFG_SLP_DO_MASK_SHIFT(reg) (((reg) & IO_PAD49_PIOCFG_SLP_DO_MASK) >> IO_PAD49_PIOCFG_SLP_DO_SHIFT)
#define  IO_PAD49_PIOCFG_SLP_DO_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD49_PIOCFG_SLP_DO_MASK) | (((uint32_t)val) << IO_PAD49_PIOCFG_SLP_DO_SHIFT))

#define  IO_PAD49_PIOCFG_SLP_DIR_MASK 0x80
#define  IO_PAD49_PIOCFG_SLP_DIR_SHIFT 7
#define  IO_PAD49_PIOCFG_SLP_DIR_MASK_SHIFT(reg) (((reg) & IO_PAD49_PIOCFG_SLP_DIR_MASK) >> IO_PAD49_PIOCFG_SLP_DIR_SHIFT)
#define  IO_PAD49_PIOCFG_SLP_DIR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD49_PIOCFG_SLP_DIR_MASK) | (((uint32_t)val) << IO_PAD49_PIOCFG_SLP_DIR_SHIFT))

#define  IO_PAD49_PIOCFG_EDGE_EN_N_MASK 0x40
#define  IO_PAD49_PIOCFG_EDGE_EN_N_SHIFT 6
#define  IO_PAD49_PIOCFG_EDGE_EN_N_MASK_SHIFT(reg) (((reg) & IO_PAD49_PIOCFG_EDGE_EN_N_MASK) >> IO_PAD49_PIOCFG_EDGE_EN_N_SHIFT)
#define  IO_PAD49_PIOCFG_EDGE_EN_N_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD49_PIOCFG_EDGE_EN_N_MASK) | (((uint32_t)val) << IO_PAD49_PIOCFG_EDGE_EN_N_SHIFT))

#define  IO_PAD49_PIOCFG_EDGE_FALL_EN_MASK 0x20
#define  IO_PAD49_PIOCFG_EDGE_FALL_EN_SHIFT 5
#define  IO_PAD49_PIOCFG_EDGE_FALL_EN_MASK_SHIFT(reg) (((reg) & IO_PAD49_PIOCFG_EDGE_FALL_EN_MASK) >> IO_PAD49_PIOCFG_EDGE_FALL_EN_SHIFT)
#define  IO_PAD49_PIOCFG_EDGE_FALL_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD49_PIOCFG_EDGE_FALL_EN_MASK) | (((uint32_t)val) << IO_PAD49_PIOCFG_EDGE_FALL_EN_SHIFT))

#define  IO_PAD49_PIOCFG_EDGE_RISE_EN_MASK 0x10
#define  IO_PAD49_PIOCFG_EDGE_RISE_EN_SHIFT 4
#define  IO_PAD49_PIOCFG_EDGE_RISE_EN_MASK_SHIFT(reg) (((reg) & IO_PAD49_PIOCFG_EDGE_RISE_EN_MASK) >> IO_PAD49_PIOCFG_EDGE_RISE_EN_SHIFT)
#define  IO_PAD49_PIOCFG_EDGE_RISE_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD49_PIOCFG_EDGE_RISE_EN_MASK) | (((uint32_t)val) << IO_PAD49_PIOCFG_EDGE_RISE_EN_SHIFT))

#define  IO_PAD49_PIOCFG_SLP_SEL_MASK 0x8
#define  IO_PAD49_PIOCFG_SLP_SEL_SHIFT 3
#define  IO_PAD49_PIOCFG_SLP_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD49_PIOCFG_SLP_SEL_MASK) >> IO_PAD49_PIOCFG_SLP_SEL_SHIFT)
#define  IO_PAD49_PIOCFG_SLP_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD49_PIOCFG_SLP_SEL_MASK) | (((uint32_t)val) << IO_PAD49_PIOCFG_SLP_SEL_SHIFT))

#define  IO_PAD49_PIOCFG_FUNC_SEL_MASK 0x7
#define  IO_PAD49_PIOCFG_FUNC_SEL_SHIFT 0
#define  IO_PAD49_PIOCFG_FUNC_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD49_PIOCFG_FUNC_SEL_MASK) >> IO_PAD49_PIOCFG_FUNC_SEL_SHIFT)
#define  IO_PAD49_PIOCFG_FUNC_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD49_PIOCFG_FUNC_SEL_MASK) | (((uint32_t)val) << IO_PAD49_PIOCFG_FUNC_SEL_SHIFT))

//====================================================================
//
//Register File: IO_PAD50 Configuration Registers (IO_PAD50)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

//====================================================================
//Register: IO_PAD50 Configuration Register (PIOCFG)
/** \brief "PHI_PADXDC_SRC" Pad*/
//====================================================================

#define  IO_PAD50_PIOCFG_RESERVED1_MASK 0xfc000000
#define  IO_PAD50_PIOCFG_RESERVED1_SHIFT 26
#define  IO_PAD50_PIOCFG_RESERVED1_MASK_SHIFT(reg) (((reg) & IO_PAD50_PIOCFG_RESERVED1_MASK) >> IO_PAD50_PIOCFG_RESERVED1_SHIFT)
#define  IO_PAD50_PIOCFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD50_PIOCFG_RESERVED1_MASK) | (((uint32_t)val) << IO_PAD50_PIOCFG_RESERVED1_SHIFT))

#define  IO_PAD50_PIOCFG_PD_MASK 0x2000000
#define  IO_PAD50_PIOCFG_PD_SHIFT 25
#define  IO_PAD50_PIOCFG_PD_MASK_SHIFT(reg) (((reg) & IO_PAD50_PIOCFG_PD_MASK) >> IO_PAD50_PIOCFG_PD_SHIFT)
#define  IO_PAD50_PIOCFG_PD_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD50_PIOCFG_PD_MASK) | (((uint32_t)val) << IO_PAD50_PIOCFG_PD_SHIFT))

#define  IO_PAD50_PIOCFG_ODT_EN_MASK 0x1000000
#define  IO_PAD50_PIOCFG_ODT_EN_SHIFT 24
#define  IO_PAD50_PIOCFG_ODT_EN_MASK_SHIFT(reg) (((reg) & IO_PAD50_PIOCFG_ODT_EN_MASK) >> IO_PAD50_PIOCFG_ODT_EN_SHIFT)
#define  IO_PAD50_PIOCFG_ODT_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD50_PIOCFG_ODT_EN_MASK) | (((uint32_t)val) << IO_PAD50_PIOCFG_ODT_EN_SHIFT))

#define  IO_PAD50_PIOCFG_LED_EN_MASK 0x800000
#define  IO_PAD50_PIOCFG_LED_EN_SHIFT 23
#define  IO_PAD50_PIOCFG_LED_EN_MASK_SHIFT(reg) (((reg) & IO_PAD50_PIOCFG_LED_EN_MASK) >> IO_PAD50_PIOCFG_LED_EN_SHIFT)
#define  IO_PAD50_PIOCFG_LED_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD50_PIOCFG_LED_EN_MASK) | (((uint32_t)val) << IO_PAD50_PIOCFG_LED_EN_SHIFT))

#define  IO_PAD50_PIOCFG_I2C_SEL_MASK 0x600000
#define  IO_PAD50_PIOCFG_I2C_SEL_SHIFT 21
#define  IO_PAD50_PIOCFG_I2C_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD50_PIOCFG_I2C_SEL_MASK) >> IO_PAD50_PIOCFG_I2C_SEL_SHIFT)
#define  IO_PAD50_PIOCFG_I2C_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD50_PIOCFG_I2C_SEL_MASK) | (((uint32_t)val) << IO_PAD50_PIOCFG_I2C_SEL_SHIFT))

#define  IO_PAD50_PIOCFG_DGTBSEL_MASK 0x1e0000
#define  IO_PAD50_PIOCFG_DGTBSEL_SHIFT 17
#define  IO_PAD50_PIOCFG_DGTBSEL_MASK_SHIFT(reg) (((reg) & IO_PAD50_PIOCFG_DGTBSEL_MASK) >> IO_PAD50_PIOCFG_DGTBSEL_SHIFT)
#define  IO_PAD50_PIOCFG_DGTBSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD50_PIOCFG_DGTBSEL_MASK) | (((uint32_t)val) << IO_PAD50_PIOCFG_DGTBSEL_SHIFT))

#define  IO_PAD50_PIOCFG_RAWSEL_MASK 0x10000
#define  IO_PAD50_PIOCFG_RAWSEL_SHIFT 16
#define  IO_PAD50_PIOCFG_RAWSEL_MASK_SHIFT(reg) (((reg) & IO_PAD50_PIOCFG_RAWSEL_MASK) >> IO_PAD50_PIOCFG_RAWSEL_SHIFT)
#define  IO_PAD50_PIOCFG_RAWSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD50_PIOCFG_RAWSEL_MASK) | (((uint32_t)val) << IO_PAD50_PIOCFG_RAWSEL_SHIFT))

#define  IO_PAD50_PIOCFG_PULL_SEL_MASK 0x8000
#define  IO_PAD50_PIOCFG_PULL_SEL_SHIFT 15
#define  IO_PAD50_PIOCFG_PULL_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD50_PIOCFG_PULL_SEL_MASK) >> IO_PAD50_PIOCFG_PULL_SEL_SHIFT)
#define  IO_PAD50_PIOCFG_PULL_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD50_PIOCFG_PULL_SEL_MASK) | (((uint32_t)val) << IO_PAD50_PIOCFG_PULL_SEL_SHIFT))

#define  IO_PAD50_PIOCFG_PUEN_MASK 0x4000
#define  IO_PAD50_PIOCFG_PUEN_SHIFT 14
#define  IO_PAD50_PIOCFG_PUEN_MASK_SHIFT(reg) (((reg) & IO_PAD50_PIOCFG_PUEN_MASK) >> IO_PAD50_PIOCFG_PUEN_SHIFT)
#define  IO_PAD50_PIOCFG_PUEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD50_PIOCFG_PUEN_MASK) | (((uint32_t)val) << IO_PAD50_PIOCFG_PUEN_SHIFT))

#define  IO_PAD50_PIOCFG_PDEN_MASK 0x2000
#define  IO_PAD50_PIOCFG_PDEN_SHIFT 13
#define  IO_PAD50_PIOCFG_PDEN_MASK_SHIFT(reg) (((reg) & IO_PAD50_PIOCFG_PDEN_MASK) >> IO_PAD50_PIOCFG_PDEN_SHIFT)
#define  IO_PAD50_PIOCFG_PDEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD50_PIOCFG_PDEN_MASK) | (((uint32_t)val) << IO_PAD50_PIOCFG_PDEN_SHIFT))

#define  IO_PAD50_PIOCFG_SR_MASK 0x1800
#define  IO_PAD50_PIOCFG_SR_SHIFT 11
#define  IO_PAD50_PIOCFG_SR_MASK_SHIFT(reg) (((reg) & IO_PAD50_PIOCFG_SR_MASK) >> IO_PAD50_PIOCFG_SR_SHIFT)
#define  IO_PAD50_PIOCFG_SR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD50_PIOCFG_SR_MASK) | (((uint32_t)val) << IO_PAD50_PIOCFG_SR_SHIFT))

#define  IO_PAD50_PIOCFG_SLP_DI_MASK 0x400
#define  IO_PAD50_PIOCFG_SLP_DI_SHIFT 10
#define  IO_PAD50_PIOCFG_SLP_DI_MASK_SHIFT(reg) (((reg) & IO_PAD50_PIOCFG_SLP_DI_MASK) >> IO_PAD50_PIOCFG_SLP_DI_SHIFT)
#define  IO_PAD50_PIOCFG_SLP_DI_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD50_PIOCFG_SLP_DI_MASK) | (((uint32_t)val) << IO_PAD50_PIOCFG_SLP_DI_SHIFT))

#define  IO_PAD50_PIOCFG_SLP_CNTRL_MASK 0x200
#define  IO_PAD50_PIOCFG_SLP_CNTRL_SHIFT 9
#define  IO_PAD50_PIOCFG_SLP_CNTRL_MASK_SHIFT(reg) (((reg) & IO_PAD50_PIOCFG_SLP_CNTRL_MASK) >> IO_PAD50_PIOCFG_SLP_CNTRL_SHIFT)
#define  IO_PAD50_PIOCFG_SLP_CNTRL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD50_PIOCFG_SLP_CNTRL_MASK) | (((uint32_t)val) << IO_PAD50_PIOCFG_SLP_CNTRL_SHIFT))

#define  IO_PAD50_PIOCFG_SLP_DO_MASK 0x100
#define  IO_PAD50_PIOCFG_SLP_DO_SHIFT 8
#define  IO_PAD50_PIOCFG_SLP_DO_MASK_SHIFT(reg) (((reg) & IO_PAD50_PIOCFG_SLP_DO_MASK) >> IO_PAD50_PIOCFG_SLP_DO_SHIFT)
#define  IO_PAD50_PIOCFG_SLP_DO_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD50_PIOCFG_SLP_DO_MASK) | (((uint32_t)val) << IO_PAD50_PIOCFG_SLP_DO_SHIFT))

#define  IO_PAD50_PIOCFG_SLP_DIR_MASK 0x80
#define  IO_PAD50_PIOCFG_SLP_DIR_SHIFT 7
#define  IO_PAD50_PIOCFG_SLP_DIR_MASK_SHIFT(reg) (((reg) & IO_PAD50_PIOCFG_SLP_DIR_MASK) >> IO_PAD50_PIOCFG_SLP_DIR_SHIFT)
#define  IO_PAD50_PIOCFG_SLP_DIR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD50_PIOCFG_SLP_DIR_MASK) | (((uint32_t)val) << IO_PAD50_PIOCFG_SLP_DIR_SHIFT))

#define  IO_PAD50_PIOCFG_EDGE_EN_N_MASK 0x40
#define  IO_PAD50_PIOCFG_EDGE_EN_N_SHIFT 6
#define  IO_PAD50_PIOCFG_EDGE_EN_N_MASK_SHIFT(reg) (((reg) & IO_PAD50_PIOCFG_EDGE_EN_N_MASK) >> IO_PAD50_PIOCFG_EDGE_EN_N_SHIFT)
#define  IO_PAD50_PIOCFG_EDGE_EN_N_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD50_PIOCFG_EDGE_EN_N_MASK) | (((uint32_t)val) << IO_PAD50_PIOCFG_EDGE_EN_N_SHIFT))

#define  IO_PAD50_PIOCFG_EDGE_FALL_EN_MASK 0x20
#define  IO_PAD50_PIOCFG_EDGE_FALL_EN_SHIFT 5
#define  IO_PAD50_PIOCFG_EDGE_FALL_EN_MASK_SHIFT(reg) (((reg) & IO_PAD50_PIOCFG_EDGE_FALL_EN_MASK) >> IO_PAD50_PIOCFG_EDGE_FALL_EN_SHIFT)
#define  IO_PAD50_PIOCFG_EDGE_FALL_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD50_PIOCFG_EDGE_FALL_EN_MASK) | (((uint32_t)val) << IO_PAD50_PIOCFG_EDGE_FALL_EN_SHIFT))

#define  IO_PAD50_PIOCFG_EDGE_RISE_EN_MASK 0x10
#define  IO_PAD50_PIOCFG_EDGE_RISE_EN_SHIFT 4
#define  IO_PAD50_PIOCFG_EDGE_RISE_EN_MASK_SHIFT(reg) (((reg) & IO_PAD50_PIOCFG_EDGE_RISE_EN_MASK) >> IO_PAD50_PIOCFG_EDGE_RISE_EN_SHIFT)
#define  IO_PAD50_PIOCFG_EDGE_RISE_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD50_PIOCFG_EDGE_RISE_EN_MASK) | (((uint32_t)val) << IO_PAD50_PIOCFG_EDGE_RISE_EN_SHIFT))

#define  IO_PAD50_PIOCFG_SLP_SEL_MASK 0x8
#define  IO_PAD50_PIOCFG_SLP_SEL_SHIFT 3
#define  IO_PAD50_PIOCFG_SLP_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD50_PIOCFG_SLP_SEL_MASK) >> IO_PAD50_PIOCFG_SLP_SEL_SHIFT)
#define  IO_PAD50_PIOCFG_SLP_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD50_PIOCFG_SLP_SEL_MASK) | (((uint32_t)val) << IO_PAD50_PIOCFG_SLP_SEL_SHIFT))

#define  IO_PAD50_PIOCFG_FUNC_SEL_MASK 0x7
#define  IO_PAD50_PIOCFG_FUNC_SEL_SHIFT 0
#define  IO_PAD50_PIOCFG_FUNC_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD50_PIOCFG_FUNC_SEL_MASK) >> IO_PAD50_PIOCFG_FUNC_SEL_SHIFT)
#define  IO_PAD50_PIOCFG_FUNC_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD50_PIOCFG_FUNC_SEL_MASK) | (((uint32_t)val) << IO_PAD50_PIOCFG_FUNC_SEL_SHIFT))

//====================================================================
//
//Register File: IO_PAD51 Configuration Registers (IO_PAD51)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

//====================================================================
//Register: IO_PAD51 Configuration Register (PIOCFG)
/** \brief "PHI_PADXDC_SRC" Pad*/
//====================================================================

#define  IO_PAD51_PIOCFG_RESERVED1_MASK 0xfc000000
#define  IO_PAD51_PIOCFG_RESERVED1_SHIFT 26
#define  IO_PAD51_PIOCFG_RESERVED1_MASK_SHIFT(reg) (((reg) & IO_PAD51_PIOCFG_RESERVED1_MASK) >> IO_PAD51_PIOCFG_RESERVED1_SHIFT)
#define  IO_PAD51_PIOCFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD51_PIOCFG_RESERVED1_MASK) | (((uint32_t)val) << IO_PAD51_PIOCFG_RESERVED1_SHIFT))

#define  IO_PAD51_PIOCFG_PD_MASK 0x2000000
#define  IO_PAD51_PIOCFG_PD_SHIFT 25
#define  IO_PAD51_PIOCFG_PD_MASK_SHIFT(reg) (((reg) & IO_PAD51_PIOCFG_PD_MASK) >> IO_PAD51_PIOCFG_PD_SHIFT)
#define  IO_PAD51_PIOCFG_PD_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD51_PIOCFG_PD_MASK) | (((uint32_t)val) << IO_PAD51_PIOCFG_PD_SHIFT))

#define  IO_PAD51_PIOCFG_ODT_EN_MASK 0x1000000
#define  IO_PAD51_PIOCFG_ODT_EN_SHIFT 24
#define  IO_PAD51_PIOCFG_ODT_EN_MASK_SHIFT(reg) (((reg) & IO_PAD51_PIOCFG_ODT_EN_MASK) >> IO_PAD51_PIOCFG_ODT_EN_SHIFT)
#define  IO_PAD51_PIOCFG_ODT_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD51_PIOCFG_ODT_EN_MASK) | (((uint32_t)val) << IO_PAD51_PIOCFG_ODT_EN_SHIFT))

#define  IO_PAD51_PIOCFG_LED_EN_MASK 0x800000
#define  IO_PAD51_PIOCFG_LED_EN_SHIFT 23
#define  IO_PAD51_PIOCFG_LED_EN_MASK_SHIFT(reg) (((reg) & IO_PAD51_PIOCFG_LED_EN_MASK) >> IO_PAD51_PIOCFG_LED_EN_SHIFT)
#define  IO_PAD51_PIOCFG_LED_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD51_PIOCFG_LED_EN_MASK) | (((uint32_t)val) << IO_PAD51_PIOCFG_LED_EN_SHIFT))

#define  IO_PAD51_PIOCFG_I2C_SEL_MASK 0x600000
#define  IO_PAD51_PIOCFG_I2C_SEL_SHIFT 21
#define  IO_PAD51_PIOCFG_I2C_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD51_PIOCFG_I2C_SEL_MASK) >> IO_PAD51_PIOCFG_I2C_SEL_SHIFT)
#define  IO_PAD51_PIOCFG_I2C_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD51_PIOCFG_I2C_SEL_MASK) | (((uint32_t)val) << IO_PAD51_PIOCFG_I2C_SEL_SHIFT))

#define  IO_PAD51_PIOCFG_DGTBSEL_MASK 0x1e0000
#define  IO_PAD51_PIOCFG_DGTBSEL_SHIFT 17
#define  IO_PAD51_PIOCFG_DGTBSEL_MASK_SHIFT(reg) (((reg) & IO_PAD51_PIOCFG_DGTBSEL_MASK) >> IO_PAD51_PIOCFG_DGTBSEL_SHIFT)
#define  IO_PAD51_PIOCFG_DGTBSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD51_PIOCFG_DGTBSEL_MASK) | (((uint32_t)val) << IO_PAD51_PIOCFG_DGTBSEL_SHIFT))

#define  IO_PAD51_PIOCFG_RAWSEL_MASK 0x10000
#define  IO_PAD51_PIOCFG_RAWSEL_SHIFT 16
#define  IO_PAD51_PIOCFG_RAWSEL_MASK_SHIFT(reg) (((reg) & IO_PAD51_PIOCFG_RAWSEL_MASK) >> IO_PAD51_PIOCFG_RAWSEL_SHIFT)
#define  IO_PAD51_PIOCFG_RAWSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD51_PIOCFG_RAWSEL_MASK) | (((uint32_t)val) << IO_PAD51_PIOCFG_RAWSEL_SHIFT))

#define  IO_PAD51_PIOCFG_PULL_SEL_MASK 0x8000
#define  IO_PAD51_PIOCFG_PULL_SEL_SHIFT 15
#define  IO_PAD51_PIOCFG_PULL_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD51_PIOCFG_PULL_SEL_MASK) >> IO_PAD51_PIOCFG_PULL_SEL_SHIFT)
#define  IO_PAD51_PIOCFG_PULL_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD51_PIOCFG_PULL_SEL_MASK) | (((uint32_t)val) << IO_PAD51_PIOCFG_PULL_SEL_SHIFT))

#define  IO_PAD51_PIOCFG_PUEN_MASK 0x4000
#define  IO_PAD51_PIOCFG_PUEN_SHIFT 14
#define  IO_PAD51_PIOCFG_PUEN_MASK_SHIFT(reg) (((reg) & IO_PAD51_PIOCFG_PUEN_MASK) >> IO_PAD51_PIOCFG_PUEN_SHIFT)
#define  IO_PAD51_PIOCFG_PUEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD51_PIOCFG_PUEN_MASK) | (((uint32_t)val) << IO_PAD51_PIOCFG_PUEN_SHIFT))

#define  IO_PAD51_PIOCFG_PDEN_MASK 0x2000
#define  IO_PAD51_PIOCFG_PDEN_SHIFT 13
#define  IO_PAD51_PIOCFG_PDEN_MASK_SHIFT(reg) (((reg) & IO_PAD51_PIOCFG_PDEN_MASK) >> IO_PAD51_PIOCFG_PDEN_SHIFT)
#define  IO_PAD51_PIOCFG_PDEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD51_PIOCFG_PDEN_MASK) | (((uint32_t)val) << IO_PAD51_PIOCFG_PDEN_SHIFT))

#define  IO_PAD51_PIOCFG_SR_MASK 0x1800
#define  IO_PAD51_PIOCFG_SR_SHIFT 11
#define  IO_PAD51_PIOCFG_SR_MASK_SHIFT(reg) (((reg) & IO_PAD51_PIOCFG_SR_MASK) >> IO_PAD51_PIOCFG_SR_SHIFT)
#define  IO_PAD51_PIOCFG_SR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD51_PIOCFG_SR_MASK) | (((uint32_t)val) << IO_PAD51_PIOCFG_SR_SHIFT))

#define  IO_PAD51_PIOCFG_SLP_DI_MASK 0x400
#define  IO_PAD51_PIOCFG_SLP_DI_SHIFT 10
#define  IO_PAD51_PIOCFG_SLP_DI_MASK_SHIFT(reg) (((reg) & IO_PAD51_PIOCFG_SLP_DI_MASK) >> IO_PAD51_PIOCFG_SLP_DI_SHIFT)
#define  IO_PAD51_PIOCFG_SLP_DI_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD51_PIOCFG_SLP_DI_MASK) | (((uint32_t)val) << IO_PAD51_PIOCFG_SLP_DI_SHIFT))

#define  IO_PAD51_PIOCFG_SLP_CNTRL_MASK 0x200
#define  IO_PAD51_PIOCFG_SLP_CNTRL_SHIFT 9
#define  IO_PAD51_PIOCFG_SLP_CNTRL_MASK_SHIFT(reg) (((reg) & IO_PAD51_PIOCFG_SLP_CNTRL_MASK) >> IO_PAD51_PIOCFG_SLP_CNTRL_SHIFT)
#define  IO_PAD51_PIOCFG_SLP_CNTRL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD51_PIOCFG_SLP_CNTRL_MASK) | (((uint32_t)val) << IO_PAD51_PIOCFG_SLP_CNTRL_SHIFT))

#define  IO_PAD51_PIOCFG_SLP_DO_MASK 0x100
#define  IO_PAD51_PIOCFG_SLP_DO_SHIFT 8
#define  IO_PAD51_PIOCFG_SLP_DO_MASK_SHIFT(reg) (((reg) & IO_PAD51_PIOCFG_SLP_DO_MASK) >> IO_PAD51_PIOCFG_SLP_DO_SHIFT)
#define  IO_PAD51_PIOCFG_SLP_DO_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD51_PIOCFG_SLP_DO_MASK) | (((uint32_t)val) << IO_PAD51_PIOCFG_SLP_DO_SHIFT))

#define  IO_PAD51_PIOCFG_SLP_DIR_MASK 0x80
#define  IO_PAD51_PIOCFG_SLP_DIR_SHIFT 7
#define  IO_PAD51_PIOCFG_SLP_DIR_MASK_SHIFT(reg) (((reg) & IO_PAD51_PIOCFG_SLP_DIR_MASK) >> IO_PAD51_PIOCFG_SLP_DIR_SHIFT)
#define  IO_PAD51_PIOCFG_SLP_DIR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD51_PIOCFG_SLP_DIR_MASK) | (((uint32_t)val) << IO_PAD51_PIOCFG_SLP_DIR_SHIFT))

#define  IO_PAD51_PIOCFG_EDGE_EN_N_MASK 0x40
#define  IO_PAD51_PIOCFG_EDGE_EN_N_SHIFT 6
#define  IO_PAD51_PIOCFG_EDGE_EN_N_MASK_SHIFT(reg) (((reg) & IO_PAD51_PIOCFG_EDGE_EN_N_MASK) >> IO_PAD51_PIOCFG_EDGE_EN_N_SHIFT)
#define  IO_PAD51_PIOCFG_EDGE_EN_N_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD51_PIOCFG_EDGE_EN_N_MASK) | (((uint32_t)val) << IO_PAD51_PIOCFG_EDGE_EN_N_SHIFT))

#define  IO_PAD51_PIOCFG_EDGE_FALL_EN_MASK 0x20
#define  IO_PAD51_PIOCFG_EDGE_FALL_EN_SHIFT 5
#define  IO_PAD51_PIOCFG_EDGE_FALL_EN_MASK_SHIFT(reg) (((reg) & IO_PAD51_PIOCFG_EDGE_FALL_EN_MASK) >> IO_PAD51_PIOCFG_EDGE_FALL_EN_SHIFT)
#define  IO_PAD51_PIOCFG_EDGE_FALL_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD51_PIOCFG_EDGE_FALL_EN_MASK) | (((uint32_t)val) << IO_PAD51_PIOCFG_EDGE_FALL_EN_SHIFT))

#define  IO_PAD51_PIOCFG_EDGE_RISE_EN_MASK 0x10
#define  IO_PAD51_PIOCFG_EDGE_RISE_EN_SHIFT 4
#define  IO_PAD51_PIOCFG_EDGE_RISE_EN_MASK_SHIFT(reg) (((reg) & IO_PAD51_PIOCFG_EDGE_RISE_EN_MASK) >> IO_PAD51_PIOCFG_EDGE_RISE_EN_SHIFT)
#define  IO_PAD51_PIOCFG_EDGE_RISE_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD51_PIOCFG_EDGE_RISE_EN_MASK) | (((uint32_t)val) << IO_PAD51_PIOCFG_EDGE_RISE_EN_SHIFT))

#define  IO_PAD51_PIOCFG_SLP_SEL_MASK 0x8
#define  IO_PAD51_PIOCFG_SLP_SEL_SHIFT 3
#define  IO_PAD51_PIOCFG_SLP_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD51_PIOCFG_SLP_SEL_MASK) >> IO_PAD51_PIOCFG_SLP_SEL_SHIFT)
#define  IO_PAD51_PIOCFG_SLP_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD51_PIOCFG_SLP_SEL_MASK) | (((uint32_t)val) << IO_PAD51_PIOCFG_SLP_SEL_SHIFT))

#define  IO_PAD51_PIOCFG_FUNC_SEL_MASK 0x7
#define  IO_PAD51_PIOCFG_FUNC_SEL_SHIFT 0
#define  IO_PAD51_PIOCFG_FUNC_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD51_PIOCFG_FUNC_SEL_MASK) >> IO_PAD51_PIOCFG_FUNC_SEL_SHIFT)
#define  IO_PAD51_PIOCFG_FUNC_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD51_PIOCFG_FUNC_SEL_MASK) | (((uint32_t)val) << IO_PAD51_PIOCFG_FUNC_SEL_SHIFT))

//====================================================================
//
//Register File: IO_PAD52 Configuration Registers (IO_PAD52)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

//====================================================================
//Register: IO_PAD52 Configuration Register (PIOCFG)
/** \brief "PHI_PADXDC_SRC" Pad*/
//====================================================================

#define  IO_PAD52_PIOCFG_RESERVED1_MASK 0xfc000000
#define  IO_PAD52_PIOCFG_RESERVED1_SHIFT 26
#define  IO_PAD52_PIOCFG_RESERVED1_MASK_SHIFT(reg) (((reg) & IO_PAD52_PIOCFG_RESERVED1_MASK) >> IO_PAD52_PIOCFG_RESERVED1_SHIFT)
#define  IO_PAD52_PIOCFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD52_PIOCFG_RESERVED1_MASK) | (((uint32_t)val) << IO_PAD52_PIOCFG_RESERVED1_SHIFT))

#define  IO_PAD52_PIOCFG_PD_MASK 0x2000000
#define  IO_PAD52_PIOCFG_PD_SHIFT 25
#define  IO_PAD52_PIOCFG_PD_MASK_SHIFT(reg) (((reg) & IO_PAD52_PIOCFG_PD_MASK) >> IO_PAD52_PIOCFG_PD_SHIFT)
#define  IO_PAD52_PIOCFG_PD_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD52_PIOCFG_PD_MASK) | (((uint32_t)val) << IO_PAD52_PIOCFG_PD_SHIFT))

#define  IO_PAD52_PIOCFG_ODT_EN_MASK 0x1000000
#define  IO_PAD52_PIOCFG_ODT_EN_SHIFT 24
#define  IO_PAD52_PIOCFG_ODT_EN_MASK_SHIFT(reg) (((reg) & IO_PAD52_PIOCFG_ODT_EN_MASK) >> IO_PAD52_PIOCFG_ODT_EN_SHIFT)
#define  IO_PAD52_PIOCFG_ODT_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD52_PIOCFG_ODT_EN_MASK) | (((uint32_t)val) << IO_PAD52_PIOCFG_ODT_EN_SHIFT))

#define  IO_PAD52_PIOCFG_LED_EN_MASK 0x800000
#define  IO_PAD52_PIOCFG_LED_EN_SHIFT 23
#define  IO_PAD52_PIOCFG_LED_EN_MASK_SHIFT(reg) (((reg) & IO_PAD52_PIOCFG_LED_EN_MASK) >> IO_PAD52_PIOCFG_LED_EN_SHIFT)
#define  IO_PAD52_PIOCFG_LED_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD52_PIOCFG_LED_EN_MASK) | (((uint32_t)val) << IO_PAD52_PIOCFG_LED_EN_SHIFT))

#define  IO_PAD52_PIOCFG_I2C_SEL_MASK 0x600000
#define  IO_PAD52_PIOCFG_I2C_SEL_SHIFT 21
#define  IO_PAD52_PIOCFG_I2C_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD52_PIOCFG_I2C_SEL_MASK) >> IO_PAD52_PIOCFG_I2C_SEL_SHIFT)
#define  IO_PAD52_PIOCFG_I2C_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD52_PIOCFG_I2C_SEL_MASK) | (((uint32_t)val) << IO_PAD52_PIOCFG_I2C_SEL_SHIFT))

#define  IO_PAD52_PIOCFG_DGTBSEL_MASK 0x1e0000
#define  IO_PAD52_PIOCFG_DGTBSEL_SHIFT 17
#define  IO_PAD52_PIOCFG_DGTBSEL_MASK_SHIFT(reg) (((reg) & IO_PAD52_PIOCFG_DGTBSEL_MASK) >> IO_PAD52_PIOCFG_DGTBSEL_SHIFT)
#define  IO_PAD52_PIOCFG_DGTBSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD52_PIOCFG_DGTBSEL_MASK) | (((uint32_t)val) << IO_PAD52_PIOCFG_DGTBSEL_SHIFT))

#define  IO_PAD52_PIOCFG_RAWSEL_MASK 0x10000
#define  IO_PAD52_PIOCFG_RAWSEL_SHIFT 16
#define  IO_PAD52_PIOCFG_RAWSEL_MASK_SHIFT(reg) (((reg) & IO_PAD52_PIOCFG_RAWSEL_MASK) >> IO_PAD52_PIOCFG_RAWSEL_SHIFT)
#define  IO_PAD52_PIOCFG_RAWSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD52_PIOCFG_RAWSEL_MASK) | (((uint32_t)val) << IO_PAD52_PIOCFG_RAWSEL_SHIFT))

#define  IO_PAD52_PIOCFG_PULL_SEL_MASK 0x8000
#define  IO_PAD52_PIOCFG_PULL_SEL_SHIFT 15
#define  IO_PAD52_PIOCFG_PULL_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD52_PIOCFG_PULL_SEL_MASK) >> IO_PAD52_PIOCFG_PULL_SEL_SHIFT)
#define  IO_PAD52_PIOCFG_PULL_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD52_PIOCFG_PULL_SEL_MASK) | (((uint32_t)val) << IO_PAD52_PIOCFG_PULL_SEL_SHIFT))

#define  IO_PAD52_PIOCFG_PUEN_MASK 0x4000
#define  IO_PAD52_PIOCFG_PUEN_SHIFT 14
#define  IO_PAD52_PIOCFG_PUEN_MASK_SHIFT(reg) (((reg) & IO_PAD52_PIOCFG_PUEN_MASK) >> IO_PAD52_PIOCFG_PUEN_SHIFT)
#define  IO_PAD52_PIOCFG_PUEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD52_PIOCFG_PUEN_MASK) | (((uint32_t)val) << IO_PAD52_PIOCFG_PUEN_SHIFT))

#define  IO_PAD52_PIOCFG_PDEN_MASK 0x2000
#define  IO_PAD52_PIOCFG_PDEN_SHIFT 13
#define  IO_PAD52_PIOCFG_PDEN_MASK_SHIFT(reg) (((reg) & IO_PAD52_PIOCFG_PDEN_MASK) >> IO_PAD52_PIOCFG_PDEN_SHIFT)
#define  IO_PAD52_PIOCFG_PDEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD52_PIOCFG_PDEN_MASK) | (((uint32_t)val) << IO_PAD52_PIOCFG_PDEN_SHIFT))

#define  IO_PAD52_PIOCFG_SR_MASK 0x1800
#define  IO_PAD52_PIOCFG_SR_SHIFT 11
#define  IO_PAD52_PIOCFG_SR_MASK_SHIFT(reg) (((reg) & IO_PAD52_PIOCFG_SR_MASK) >> IO_PAD52_PIOCFG_SR_SHIFT)
#define  IO_PAD52_PIOCFG_SR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD52_PIOCFG_SR_MASK) | (((uint32_t)val) << IO_PAD52_PIOCFG_SR_SHIFT))

#define  IO_PAD52_PIOCFG_SLP_DI_MASK 0x400
#define  IO_PAD52_PIOCFG_SLP_DI_SHIFT 10
#define  IO_PAD52_PIOCFG_SLP_DI_MASK_SHIFT(reg) (((reg) & IO_PAD52_PIOCFG_SLP_DI_MASK) >> IO_PAD52_PIOCFG_SLP_DI_SHIFT)
#define  IO_PAD52_PIOCFG_SLP_DI_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD52_PIOCFG_SLP_DI_MASK) | (((uint32_t)val) << IO_PAD52_PIOCFG_SLP_DI_SHIFT))

#define  IO_PAD52_PIOCFG_SLP_CNTRL_MASK 0x200
#define  IO_PAD52_PIOCFG_SLP_CNTRL_SHIFT 9
#define  IO_PAD52_PIOCFG_SLP_CNTRL_MASK_SHIFT(reg) (((reg) & IO_PAD52_PIOCFG_SLP_CNTRL_MASK) >> IO_PAD52_PIOCFG_SLP_CNTRL_SHIFT)
#define  IO_PAD52_PIOCFG_SLP_CNTRL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD52_PIOCFG_SLP_CNTRL_MASK) | (((uint32_t)val) << IO_PAD52_PIOCFG_SLP_CNTRL_SHIFT))

#define  IO_PAD52_PIOCFG_SLP_DO_MASK 0x100
#define  IO_PAD52_PIOCFG_SLP_DO_SHIFT 8
#define  IO_PAD52_PIOCFG_SLP_DO_MASK_SHIFT(reg) (((reg) & IO_PAD52_PIOCFG_SLP_DO_MASK) >> IO_PAD52_PIOCFG_SLP_DO_SHIFT)
#define  IO_PAD52_PIOCFG_SLP_DO_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD52_PIOCFG_SLP_DO_MASK) | (((uint32_t)val) << IO_PAD52_PIOCFG_SLP_DO_SHIFT))

#define  IO_PAD52_PIOCFG_SLP_DIR_MASK 0x80
#define  IO_PAD52_PIOCFG_SLP_DIR_SHIFT 7
#define  IO_PAD52_PIOCFG_SLP_DIR_MASK_SHIFT(reg) (((reg) & IO_PAD52_PIOCFG_SLP_DIR_MASK) >> IO_PAD52_PIOCFG_SLP_DIR_SHIFT)
#define  IO_PAD52_PIOCFG_SLP_DIR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD52_PIOCFG_SLP_DIR_MASK) | (((uint32_t)val) << IO_PAD52_PIOCFG_SLP_DIR_SHIFT))

#define  IO_PAD52_PIOCFG_EDGE_EN_N_MASK 0x40
#define  IO_PAD52_PIOCFG_EDGE_EN_N_SHIFT 6
#define  IO_PAD52_PIOCFG_EDGE_EN_N_MASK_SHIFT(reg) (((reg) & IO_PAD52_PIOCFG_EDGE_EN_N_MASK) >> IO_PAD52_PIOCFG_EDGE_EN_N_SHIFT)
#define  IO_PAD52_PIOCFG_EDGE_EN_N_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD52_PIOCFG_EDGE_EN_N_MASK) | (((uint32_t)val) << IO_PAD52_PIOCFG_EDGE_EN_N_SHIFT))

#define  IO_PAD52_PIOCFG_EDGE_FALL_EN_MASK 0x20
#define  IO_PAD52_PIOCFG_EDGE_FALL_EN_SHIFT 5
#define  IO_PAD52_PIOCFG_EDGE_FALL_EN_MASK_SHIFT(reg) (((reg) & IO_PAD52_PIOCFG_EDGE_FALL_EN_MASK) >> IO_PAD52_PIOCFG_EDGE_FALL_EN_SHIFT)
#define  IO_PAD52_PIOCFG_EDGE_FALL_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD52_PIOCFG_EDGE_FALL_EN_MASK) | (((uint32_t)val) << IO_PAD52_PIOCFG_EDGE_FALL_EN_SHIFT))

#define  IO_PAD52_PIOCFG_EDGE_RISE_EN_MASK 0x10
#define  IO_PAD52_PIOCFG_EDGE_RISE_EN_SHIFT 4
#define  IO_PAD52_PIOCFG_EDGE_RISE_EN_MASK_SHIFT(reg) (((reg) & IO_PAD52_PIOCFG_EDGE_RISE_EN_MASK) >> IO_PAD52_PIOCFG_EDGE_RISE_EN_SHIFT)
#define  IO_PAD52_PIOCFG_EDGE_RISE_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD52_PIOCFG_EDGE_RISE_EN_MASK) | (((uint32_t)val) << IO_PAD52_PIOCFG_EDGE_RISE_EN_SHIFT))

#define  IO_PAD52_PIOCFG_SLP_SEL_MASK 0x8
#define  IO_PAD52_PIOCFG_SLP_SEL_SHIFT 3
#define  IO_PAD52_PIOCFG_SLP_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD52_PIOCFG_SLP_SEL_MASK) >> IO_PAD52_PIOCFG_SLP_SEL_SHIFT)
#define  IO_PAD52_PIOCFG_SLP_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD52_PIOCFG_SLP_SEL_MASK) | (((uint32_t)val) << IO_PAD52_PIOCFG_SLP_SEL_SHIFT))

#define  IO_PAD52_PIOCFG_FUNC_SEL_MASK 0x7
#define  IO_PAD52_PIOCFG_FUNC_SEL_SHIFT 0
#define  IO_PAD52_PIOCFG_FUNC_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD52_PIOCFG_FUNC_SEL_MASK) >> IO_PAD52_PIOCFG_FUNC_SEL_SHIFT)
#define  IO_PAD52_PIOCFG_FUNC_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD52_PIOCFG_FUNC_SEL_MASK) | (((uint32_t)val) << IO_PAD52_PIOCFG_FUNC_SEL_SHIFT))

//====================================================================
//
//Register File: IO_PAD53 Configuration Registers (IO_PAD53)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

//====================================================================
//Register: IO_PAD53 Configuration Register (PIOCFG)
/** \brief "PHI_PADXDC_SRC" Pad*/
//====================================================================

#define  IO_PAD53_PIOCFG_RESERVED1_MASK 0xfc000000
#define  IO_PAD53_PIOCFG_RESERVED1_SHIFT 26
#define  IO_PAD53_PIOCFG_RESERVED1_MASK_SHIFT(reg) (((reg) & IO_PAD53_PIOCFG_RESERVED1_MASK) >> IO_PAD53_PIOCFG_RESERVED1_SHIFT)
#define  IO_PAD53_PIOCFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD53_PIOCFG_RESERVED1_MASK) | (((uint32_t)val) << IO_PAD53_PIOCFG_RESERVED1_SHIFT))

#define  IO_PAD53_PIOCFG_PD_MASK 0x2000000
#define  IO_PAD53_PIOCFG_PD_SHIFT 25
#define  IO_PAD53_PIOCFG_PD_MASK_SHIFT(reg) (((reg) & IO_PAD53_PIOCFG_PD_MASK) >> IO_PAD53_PIOCFG_PD_SHIFT)
#define  IO_PAD53_PIOCFG_PD_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD53_PIOCFG_PD_MASK) | (((uint32_t)val) << IO_PAD53_PIOCFG_PD_SHIFT))

#define  IO_PAD53_PIOCFG_ODT_EN_MASK 0x1000000
#define  IO_PAD53_PIOCFG_ODT_EN_SHIFT 24
#define  IO_PAD53_PIOCFG_ODT_EN_MASK_SHIFT(reg) (((reg) & IO_PAD53_PIOCFG_ODT_EN_MASK) >> IO_PAD53_PIOCFG_ODT_EN_SHIFT)
#define  IO_PAD53_PIOCFG_ODT_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD53_PIOCFG_ODT_EN_MASK) | (((uint32_t)val) << IO_PAD53_PIOCFG_ODT_EN_SHIFT))

#define  IO_PAD53_PIOCFG_LED_EN_MASK 0x800000
#define  IO_PAD53_PIOCFG_LED_EN_SHIFT 23
#define  IO_PAD53_PIOCFG_LED_EN_MASK_SHIFT(reg) (((reg) & IO_PAD53_PIOCFG_LED_EN_MASK) >> IO_PAD53_PIOCFG_LED_EN_SHIFT)
#define  IO_PAD53_PIOCFG_LED_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD53_PIOCFG_LED_EN_MASK) | (((uint32_t)val) << IO_PAD53_PIOCFG_LED_EN_SHIFT))

#define  IO_PAD53_PIOCFG_I2C_SEL_MASK 0x600000
#define  IO_PAD53_PIOCFG_I2C_SEL_SHIFT 21
#define  IO_PAD53_PIOCFG_I2C_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD53_PIOCFG_I2C_SEL_MASK) >> IO_PAD53_PIOCFG_I2C_SEL_SHIFT)
#define  IO_PAD53_PIOCFG_I2C_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD53_PIOCFG_I2C_SEL_MASK) | (((uint32_t)val) << IO_PAD53_PIOCFG_I2C_SEL_SHIFT))

#define  IO_PAD53_PIOCFG_DGTBSEL_MASK 0x1e0000
#define  IO_PAD53_PIOCFG_DGTBSEL_SHIFT 17
#define  IO_PAD53_PIOCFG_DGTBSEL_MASK_SHIFT(reg) (((reg) & IO_PAD53_PIOCFG_DGTBSEL_MASK) >> IO_PAD53_PIOCFG_DGTBSEL_SHIFT)
#define  IO_PAD53_PIOCFG_DGTBSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD53_PIOCFG_DGTBSEL_MASK) | (((uint32_t)val) << IO_PAD53_PIOCFG_DGTBSEL_SHIFT))

#define  IO_PAD53_PIOCFG_RAWSEL_MASK 0x10000
#define  IO_PAD53_PIOCFG_RAWSEL_SHIFT 16
#define  IO_PAD53_PIOCFG_RAWSEL_MASK_SHIFT(reg) (((reg) & IO_PAD53_PIOCFG_RAWSEL_MASK) >> IO_PAD53_PIOCFG_RAWSEL_SHIFT)
#define  IO_PAD53_PIOCFG_RAWSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD53_PIOCFG_RAWSEL_MASK) | (((uint32_t)val) << IO_PAD53_PIOCFG_RAWSEL_SHIFT))

#define  IO_PAD53_PIOCFG_PULL_SEL_MASK 0x8000
#define  IO_PAD53_PIOCFG_PULL_SEL_SHIFT 15
#define  IO_PAD53_PIOCFG_PULL_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD53_PIOCFG_PULL_SEL_MASK) >> IO_PAD53_PIOCFG_PULL_SEL_SHIFT)
#define  IO_PAD53_PIOCFG_PULL_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD53_PIOCFG_PULL_SEL_MASK) | (((uint32_t)val) << IO_PAD53_PIOCFG_PULL_SEL_SHIFT))

#define  IO_PAD53_PIOCFG_PUEN_MASK 0x4000
#define  IO_PAD53_PIOCFG_PUEN_SHIFT 14
#define  IO_PAD53_PIOCFG_PUEN_MASK_SHIFT(reg) (((reg) & IO_PAD53_PIOCFG_PUEN_MASK) >> IO_PAD53_PIOCFG_PUEN_SHIFT)
#define  IO_PAD53_PIOCFG_PUEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD53_PIOCFG_PUEN_MASK) | (((uint32_t)val) << IO_PAD53_PIOCFG_PUEN_SHIFT))

#define  IO_PAD53_PIOCFG_PDEN_MASK 0x2000
#define  IO_PAD53_PIOCFG_PDEN_SHIFT 13
#define  IO_PAD53_PIOCFG_PDEN_MASK_SHIFT(reg) (((reg) & IO_PAD53_PIOCFG_PDEN_MASK) >> IO_PAD53_PIOCFG_PDEN_SHIFT)
#define  IO_PAD53_PIOCFG_PDEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD53_PIOCFG_PDEN_MASK) | (((uint32_t)val) << IO_PAD53_PIOCFG_PDEN_SHIFT))

#define  IO_PAD53_PIOCFG_SR_MASK 0x1800
#define  IO_PAD53_PIOCFG_SR_SHIFT 11
#define  IO_PAD53_PIOCFG_SR_MASK_SHIFT(reg) (((reg) & IO_PAD53_PIOCFG_SR_MASK) >> IO_PAD53_PIOCFG_SR_SHIFT)
#define  IO_PAD53_PIOCFG_SR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD53_PIOCFG_SR_MASK) | (((uint32_t)val) << IO_PAD53_PIOCFG_SR_SHIFT))

#define  IO_PAD53_PIOCFG_SLP_DI_MASK 0x400
#define  IO_PAD53_PIOCFG_SLP_DI_SHIFT 10
#define  IO_PAD53_PIOCFG_SLP_DI_MASK_SHIFT(reg) (((reg) & IO_PAD53_PIOCFG_SLP_DI_MASK) >> IO_PAD53_PIOCFG_SLP_DI_SHIFT)
#define  IO_PAD53_PIOCFG_SLP_DI_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD53_PIOCFG_SLP_DI_MASK) | (((uint32_t)val) << IO_PAD53_PIOCFG_SLP_DI_SHIFT))

#define  IO_PAD53_PIOCFG_SLP_CNTRL_MASK 0x200
#define  IO_PAD53_PIOCFG_SLP_CNTRL_SHIFT 9
#define  IO_PAD53_PIOCFG_SLP_CNTRL_MASK_SHIFT(reg) (((reg) & IO_PAD53_PIOCFG_SLP_CNTRL_MASK) >> IO_PAD53_PIOCFG_SLP_CNTRL_SHIFT)
#define  IO_PAD53_PIOCFG_SLP_CNTRL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD53_PIOCFG_SLP_CNTRL_MASK) | (((uint32_t)val) << IO_PAD53_PIOCFG_SLP_CNTRL_SHIFT))

#define  IO_PAD53_PIOCFG_SLP_DO_MASK 0x100
#define  IO_PAD53_PIOCFG_SLP_DO_SHIFT 8
#define  IO_PAD53_PIOCFG_SLP_DO_MASK_SHIFT(reg) (((reg) & IO_PAD53_PIOCFG_SLP_DO_MASK) >> IO_PAD53_PIOCFG_SLP_DO_SHIFT)
#define  IO_PAD53_PIOCFG_SLP_DO_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD53_PIOCFG_SLP_DO_MASK) | (((uint32_t)val) << IO_PAD53_PIOCFG_SLP_DO_SHIFT))

#define  IO_PAD53_PIOCFG_SLP_DIR_MASK 0x80
#define  IO_PAD53_PIOCFG_SLP_DIR_SHIFT 7
#define  IO_PAD53_PIOCFG_SLP_DIR_MASK_SHIFT(reg) (((reg) & IO_PAD53_PIOCFG_SLP_DIR_MASK) >> IO_PAD53_PIOCFG_SLP_DIR_SHIFT)
#define  IO_PAD53_PIOCFG_SLP_DIR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD53_PIOCFG_SLP_DIR_MASK) | (((uint32_t)val) << IO_PAD53_PIOCFG_SLP_DIR_SHIFT))

#define  IO_PAD53_PIOCFG_EDGE_EN_N_MASK 0x40
#define  IO_PAD53_PIOCFG_EDGE_EN_N_SHIFT 6
#define  IO_PAD53_PIOCFG_EDGE_EN_N_MASK_SHIFT(reg) (((reg) & IO_PAD53_PIOCFG_EDGE_EN_N_MASK) >> IO_PAD53_PIOCFG_EDGE_EN_N_SHIFT)
#define  IO_PAD53_PIOCFG_EDGE_EN_N_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD53_PIOCFG_EDGE_EN_N_MASK) | (((uint32_t)val) << IO_PAD53_PIOCFG_EDGE_EN_N_SHIFT))

#define  IO_PAD53_PIOCFG_EDGE_FALL_EN_MASK 0x20
#define  IO_PAD53_PIOCFG_EDGE_FALL_EN_SHIFT 5
#define  IO_PAD53_PIOCFG_EDGE_FALL_EN_MASK_SHIFT(reg) (((reg) & IO_PAD53_PIOCFG_EDGE_FALL_EN_MASK) >> IO_PAD53_PIOCFG_EDGE_FALL_EN_SHIFT)
#define  IO_PAD53_PIOCFG_EDGE_FALL_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD53_PIOCFG_EDGE_FALL_EN_MASK) | (((uint32_t)val) << IO_PAD53_PIOCFG_EDGE_FALL_EN_SHIFT))

#define  IO_PAD53_PIOCFG_EDGE_RISE_EN_MASK 0x10
#define  IO_PAD53_PIOCFG_EDGE_RISE_EN_SHIFT 4
#define  IO_PAD53_PIOCFG_EDGE_RISE_EN_MASK_SHIFT(reg) (((reg) & IO_PAD53_PIOCFG_EDGE_RISE_EN_MASK) >> IO_PAD53_PIOCFG_EDGE_RISE_EN_SHIFT)
#define  IO_PAD53_PIOCFG_EDGE_RISE_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD53_PIOCFG_EDGE_RISE_EN_MASK) | (((uint32_t)val) << IO_PAD53_PIOCFG_EDGE_RISE_EN_SHIFT))

#define  IO_PAD53_PIOCFG_SLP_SEL_MASK 0x8
#define  IO_PAD53_PIOCFG_SLP_SEL_SHIFT 3
#define  IO_PAD53_PIOCFG_SLP_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD53_PIOCFG_SLP_SEL_MASK) >> IO_PAD53_PIOCFG_SLP_SEL_SHIFT)
#define  IO_PAD53_PIOCFG_SLP_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD53_PIOCFG_SLP_SEL_MASK) | (((uint32_t)val) << IO_PAD53_PIOCFG_SLP_SEL_SHIFT))

#define  IO_PAD53_PIOCFG_FUNC_SEL_MASK 0x7
#define  IO_PAD53_PIOCFG_FUNC_SEL_SHIFT 0
#define  IO_PAD53_PIOCFG_FUNC_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD53_PIOCFG_FUNC_SEL_MASK) >> IO_PAD53_PIOCFG_FUNC_SEL_SHIFT)
#define  IO_PAD53_PIOCFG_FUNC_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD53_PIOCFG_FUNC_SEL_MASK) | (((uint32_t)val) << IO_PAD53_PIOCFG_FUNC_SEL_SHIFT))

//====================================================================
//
//Register File: IO_PAD54 Configuration Registers (IO_PAD54)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

//====================================================================
//Register: IO_PAD54 Configuration Register (PIOCFG)
/** \brief "PHI_PADXDC_SRC" Pad*/
//====================================================================

#define  IO_PAD54_PIOCFG_RESERVED1_MASK 0xfc000000
#define  IO_PAD54_PIOCFG_RESERVED1_SHIFT 26
#define  IO_PAD54_PIOCFG_RESERVED1_MASK_SHIFT(reg) (((reg) & IO_PAD54_PIOCFG_RESERVED1_MASK) >> IO_PAD54_PIOCFG_RESERVED1_SHIFT)
#define  IO_PAD54_PIOCFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD54_PIOCFG_RESERVED1_MASK) | (((uint32_t)val) << IO_PAD54_PIOCFG_RESERVED1_SHIFT))

#define  IO_PAD54_PIOCFG_PD_MASK 0x2000000
#define  IO_PAD54_PIOCFG_PD_SHIFT 25
#define  IO_PAD54_PIOCFG_PD_MASK_SHIFT(reg) (((reg) & IO_PAD54_PIOCFG_PD_MASK) >> IO_PAD54_PIOCFG_PD_SHIFT)
#define  IO_PAD54_PIOCFG_PD_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD54_PIOCFG_PD_MASK) | (((uint32_t)val) << IO_PAD54_PIOCFG_PD_SHIFT))

#define  IO_PAD54_PIOCFG_ODT_EN_MASK 0x1000000
#define  IO_PAD54_PIOCFG_ODT_EN_SHIFT 24
#define  IO_PAD54_PIOCFG_ODT_EN_MASK_SHIFT(reg) (((reg) & IO_PAD54_PIOCFG_ODT_EN_MASK) >> IO_PAD54_PIOCFG_ODT_EN_SHIFT)
#define  IO_PAD54_PIOCFG_ODT_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD54_PIOCFG_ODT_EN_MASK) | (((uint32_t)val) << IO_PAD54_PIOCFG_ODT_EN_SHIFT))

#define  IO_PAD54_PIOCFG_LED_EN_MASK 0x800000
#define  IO_PAD54_PIOCFG_LED_EN_SHIFT 23
#define  IO_PAD54_PIOCFG_LED_EN_MASK_SHIFT(reg) (((reg) & IO_PAD54_PIOCFG_LED_EN_MASK) >> IO_PAD54_PIOCFG_LED_EN_SHIFT)
#define  IO_PAD54_PIOCFG_LED_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD54_PIOCFG_LED_EN_MASK) | (((uint32_t)val) << IO_PAD54_PIOCFG_LED_EN_SHIFT))

#define  IO_PAD54_PIOCFG_I2C_SEL_MASK 0x600000
#define  IO_PAD54_PIOCFG_I2C_SEL_SHIFT 21
#define  IO_PAD54_PIOCFG_I2C_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD54_PIOCFG_I2C_SEL_MASK) >> IO_PAD54_PIOCFG_I2C_SEL_SHIFT)
#define  IO_PAD54_PIOCFG_I2C_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD54_PIOCFG_I2C_SEL_MASK) | (((uint32_t)val) << IO_PAD54_PIOCFG_I2C_SEL_SHIFT))

#define  IO_PAD54_PIOCFG_DGTBSEL_MASK 0x1e0000
#define  IO_PAD54_PIOCFG_DGTBSEL_SHIFT 17
#define  IO_PAD54_PIOCFG_DGTBSEL_MASK_SHIFT(reg) (((reg) & IO_PAD54_PIOCFG_DGTBSEL_MASK) >> IO_PAD54_PIOCFG_DGTBSEL_SHIFT)
#define  IO_PAD54_PIOCFG_DGTBSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD54_PIOCFG_DGTBSEL_MASK) | (((uint32_t)val) << IO_PAD54_PIOCFG_DGTBSEL_SHIFT))

#define  IO_PAD54_PIOCFG_RAWSEL_MASK 0x10000
#define  IO_PAD54_PIOCFG_RAWSEL_SHIFT 16
#define  IO_PAD54_PIOCFG_RAWSEL_MASK_SHIFT(reg) (((reg) & IO_PAD54_PIOCFG_RAWSEL_MASK) >> IO_PAD54_PIOCFG_RAWSEL_SHIFT)
#define  IO_PAD54_PIOCFG_RAWSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD54_PIOCFG_RAWSEL_MASK) | (((uint32_t)val) << IO_PAD54_PIOCFG_RAWSEL_SHIFT))

#define  IO_PAD54_PIOCFG_PULL_SEL_MASK 0x8000
#define  IO_PAD54_PIOCFG_PULL_SEL_SHIFT 15
#define  IO_PAD54_PIOCFG_PULL_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD54_PIOCFG_PULL_SEL_MASK) >> IO_PAD54_PIOCFG_PULL_SEL_SHIFT)
#define  IO_PAD54_PIOCFG_PULL_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD54_PIOCFG_PULL_SEL_MASK) | (((uint32_t)val) << IO_PAD54_PIOCFG_PULL_SEL_SHIFT))

#define  IO_PAD54_PIOCFG_PUEN_MASK 0x4000
#define  IO_PAD54_PIOCFG_PUEN_SHIFT 14
#define  IO_PAD54_PIOCFG_PUEN_MASK_SHIFT(reg) (((reg) & IO_PAD54_PIOCFG_PUEN_MASK) >> IO_PAD54_PIOCFG_PUEN_SHIFT)
#define  IO_PAD54_PIOCFG_PUEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD54_PIOCFG_PUEN_MASK) | (((uint32_t)val) << IO_PAD54_PIOCFG_PUEN_SHIFT))

#define  IO_PAD54_PIOCFG_PDEN_MASK 0x2000
#define  IO_PAD54_PIOCFG_PDEN_SHIFT 13
#define  IO_PAD54_PIOCFG_PDEN_MASK_SHIFT(reg) (((reg) & IO_PAD54_PIOCFG_PDEN_MASK) >> IO_PAD54_PIOCFG_PDEN_SHIFT)
#define  IO_PAD54_PIOCFG_PDEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD54_PIOCFG_PDEN_MASK) | (((uint32_t)val) << IO_PAD54_PIOCFG_PDEN_SHIFT))

#define  IO_PAD54_PIOCFG_SR_MASK 0x1800
#define  IO_PAD54_PIOCFG_SR_SHIFT 11
#define  IO_PAD54_PIOCFG_SR_MASK_SHIFT(reg) (((reg) & IO_PAD54_PIOCFG_SR_MASK) >> IO_PAD54_PIOCFG_SR_SHIFT)
#define  IO_PAD54_PIOCFG_SR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD54_PIOCFG_SR_MASK) | (((uint32_t)val) << IO_PAD54_PIOCFG_SR_SHIFT))

#define  IO_PAD54_PIOCFG_SLP_DI_MASK 0x400
#define  IO_PAD54_PIOCFG_SLP_DI_SHIFT 10
#define  IO_PAD54_PIOCFG_SLP_DI_MASK_SHIFT(reg) (((reg) & IO_PAD54_PIOCFG_SLP_DI_MASK) >> IO_PAD54_PIOCFG_SLP_DI_SHIFT)
#define  IO_PAD54_PIOCFG_SLP_DI_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD54_PIOCFG_SLP_DI_MASK) | (((uint32_t)val) << IO_PAD54_PIOCFG_SLP_DI_SHIFT))

#define  IO_PAD54_PIOCFG_SLP_CNTRL_MASK 0x200
#define  IO_PAD54_PIOCFG_SLP_CNTRL_SHIFT 9
#define  IO_PAD54_PIOCFG_SLP_CNTRL_MASK_SHIFT(reg) (((reg) & IO_PAD54_PIOCFG_SLP_CNTRL_MASK) >> IO_PAD54_PIOCFG_SLP_CNTRL_SHIFT)
#define  IO_PAD54_PIOCFG_SLP_CNTRL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD54_PIOCFG_SLP_CNTRL_MASK) | (((uint32_t)val) << IO_PAD54_PIOCFG_SLP_CNTRL_SHIFT))

#define  IO_PAD54_PIOCFG_SLP_DO_MASK 0x100
#define  IO_PAD54_PIOCFG_SLP_DO_SHIFT 8
#define  IO_PAD54_PIOCFG_SLP_DO_MASK_SHIFT(reg) (((reg) & IO_PAD54_PIOCFG_SLP_DO_MASK) >> IO_PAD54_PIOCFG_SLP_DO_SHIFT)
#define  IO_PAD54_PIOCFG_SLP_DO_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD54_PIOCFG_SLP_DO_MASK) | (((uint32_t)val) << IO_PAD54_PIOCFG_SLP_DO_SHIFT))

#define  IO_PAD54_PIOCFG_SLP_DIR_MASK 0x80
#define  IO_PAD54_PIOCFG_SLP_DIR_SHIFT 7
#define  IO_PAD54_PIOCFG_SLP_DIR_MASK_SHIFT(reg) (((reg) & IO_PAD54_PIOCFG_SLP_DIR_MASK) >> IO_PAD54_PIOCFG_SLP_DIR_SHIFT)
#define  IO_PAD54_PIOCFG_SLP_DIR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD54_PIOCFG_SLP_DIR_MASK) | (((uint32_t)val) << IO_PAD54_PIOCFG_SLP_DIR_SHIFT))

#define  IO_PAD54_PIOCFG_EDGE_EN_N_MASK 0x40
#define  IO_PAD54_PIOCFG_EDGE_EN_N_SHIFT 6
#define  IO_PAD54_PIOCFG_EDGE_EN_N_MASK_SHIFT(reg) (((reg) & IO_PAD54_PIOCFG_EDGE_EN_N_MASK) >> IO_PAD54_PIOCFG_EDGE_EN_N_SHIFT)
#define  IO_PAD54_PIOCFG_EDGE_EN_N_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD54_PIOCFG_EDGE_EN_N_MASK) | (((uint32_t)val) << IO_PAD54_PIOCFG_EDGE_EN_N_SHIFT))

#define  IO_PAD54_PIOCFG_EDGE_FALL_EN_MASK 0x20
#define  IO_PAD54_PIOCFG_EDGE_FALL_EN_SHIFT 5
#define  IO_PAD54_PIOCFG_EDGE_FALL_EN_MASK_SHIFT(reg) (((reg) & IO_PAD54_PIOCFG_EDGE_FALL_EN_MASK) >> IO_PAD54_PIOCFG_EDGE_FALL_EN_SHIFT)
#define  IO_PAD54_PIOCFG_EDGE_FALL_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD54_PIOCFG_EDGE_FALL_EN_MASK) | (((uint32_t)val) << IO_PAD54_PIOCFG_EDGE_FALL_EN_SHIFT))

#define  IO_PAD54_PIOCFG_EDGE_RISE_EN_MASK 0x10
#define  IO_PAD54_PIOCFG_EDGE_RISE_EN_SHIFT 4
#define  IO_PAD54_PIOCFG_EDGE_RISE_EN_MASK_SHIFT(reg) (((reg) & IO_PAD54_PIOCFG_EDGE_RISE_EN_MASK) >> IO_PAD54_PIOCFG_EDGE_RISE_EN_SHIFT)
#define  IO_PAD54_PIOCFG_EDGE_RISE_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD54_PIOCFG_EDGE_RISE_EN_MASK) | (((uint32_t)val) << IO_PAD54_PIOCFG_EDGE_RISE_EN_SHIFT))

#define  IO_PAD54_PIOCFG_SLP_SEL_MASK 0x8
#define  IO_PAD54_PIOCFG_SLP_SEL_SHIFT 3
#define  IO_PAD54_PIOCFG_SLP_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD54_PIOCFG_SLP_SEL_MASK) >> IO_PAD54_PIOCFG_SLP_SEL_SHIFT)
#define  IO_PAD54_PIOCFG_SLP_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD54_PIOCFG_SLP_SEL_MASK) | (((uint32_t)val) << IO_PAD54_PIOCFG_SLP_SEL_SHIFT))

#define  IO_PAD54_PIOCFG_FUNC_SEL_MASK 0x7
#define  IO_PAD54_PIOCFG_FUNC_SEL_SHIFT 0
#define  IO_PAD54_PIOCFG_FUNC_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD54_PIOCFG_FUNC_SEL_MASK) >> IO_PAD54_PIOCFG_FUNC_SEL_SHIFT)
#define  IO_PAD54_PIOCFG_FUNC_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD54_PIOCFG_FUNC_SEL_MASK) | (((uint32_t)val) << IO_PAD54_PIOCFG_FUNC_SEL_SHIFT))

//====================================================================
//
//Register File: IO_PAD55 Configuration Registers (IO_PAD55)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

//====================================================================
//Register: IO_PAD55 Configuration Register (PIOCFG)
/** \brief "PHI_PADXDC_SRC" Pad*/
//====================================================================

#define  IO_PAD55_PIOCFG_RESERVED1_MASK 0xfc000000
#define  IO_PAD55_PIOCFG_RESERVED1_SHIFT 26
#define  IO_PAD55_PIOCFG_RESERVED1_MASK_SHIFT(reg) (((reg) & IO_PAD55_PIOCFG_RESERVED1_MASK) >> IO_PAD55_PIOCFG_RESERVED1_SHIFT)
#define  IO_PAD55_PIOCFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD55_PIOCFG_RESERVED1_MASK) | (((uint32_t)val) << IO_PAD55_PIOCFG_RESERVED1_SHIFT))

#define  IO_PAD55_PIOCFG_PD_MASK 0x2000000
#define  IO_PAD55_PIOCFG_PD_SHIFT 25
#define  IO_PAD55_PIOCFG_PD_MASK_SHIFT(reg) (((reg) & IO_PAD55_PIOCFG_PD_MASK) >> IO_PAD55_PIOCFG_PD_SHIFT)
#define  IO_PAD55_PIOCFG_PD_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD55_PIOCFG_PD_MASK) | (((uint32_t)val) << IO_PAD55_PIOCFG_PD_SHIFT))

#define  IO_PAD55_PIOCFG_ODT_EN_MASK 0x1000000
#define  IO_PAD55_PIOCFG_ODT_EN_SHIFT 24
#define  IO_PAD55_PIOCFG_ODT_EN_MASK_SHIFT(reg) (((reg) & IO_PAD55_PIOCFG_ODT_EN_MASK) >> IO_PAD55_PIOCFG_ODT_EN_SHIFT)
#define  IO_PAD55_PIOCFG_ODT_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD55_PIOCFG_ODT_EN_MASK) | (((uint32_t)val) << IO_PAD55_PIOCFG_ODT_EN_SHIFT))

#define  IO_PAD55_PIOCFG_LED_EN_MASK 0x800000
#define  IO_PAD55_PIOCFG_LED_EN_SHIFT 23
#define  IO_PAD55_PIOCFG_LED_EN_MASK_SHIFT(reg) (((reg) & IO_PAD55_PIOCFG_LED_EN_MASK) >> IO_PAD55_PIOCFG_LED_EN_SHIFT)
#define  IO_PAD55_PIOCFG_LED_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD55_PIOCFG_LED_EN_MASK) | (((uint32_t)val) << IO_PAD55_PIOCFG_LED_EN_SHIFT))

#define  IO_PAD55_PIOCFG_I2C_SEL_MASK 0x600000
#define  IO_PAD55_PIOCFG_I2C_SEL_SHIFT 21
#define  IO_PAD55_PIOCFG_I2C_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD55_PIOCFG_I2C_SEL_MASK) >> IO_PAD55_PIOCFG_I2C_SEL_SHIFT)
#define  IO_PAD55_PIOCFG_I2C_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD55_PIOCFG_I2C_SEL_MASK) | (((uint32_t)val) << IO_PAD55_PIOCFG_I2C_SEL_SHIFT))

#define  IO_PAD55_PIOCFG_DGTBSEL_MASK 0x1e0000
#define  IO_PAD55_PIOCFG_DGTBSEL_SHIFT 17
#define  IO_PAD55_PIOCFG_DGTBSEL_MASK_SHIFT(reg) (((reg) & IO_PAD55_PIOCFG_DGTBSEL_MASK) >> IO_PAD55_PIOCFG_DGTBSEL_SHIFT)
#define  IO_PAD55_PIOCFG_DGTBSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD55_PIOCFG_DGTBSEL_MASK) | (((uint32_t)val) << IO_PAD55_PIOCFG_DGTBSEL_SHIFT))

#define  IO_PAD55_PIOCFG_RAWSEL_MASK 0x10000
#define  IO_PAD55_PIOCFG_RAWSEL_SHIFT 16
#define  IO_PAD55_PIOCFG_RAWSEL_MASK_SHIFT(reg) (((reg) & IO_PAD55_PIOCFG_RAWSEL_MASK) >> IO_PAD55_PIOCFG_RAWSEL_SHIFT)
#define  IO_PAD55_PIOCFG_RAWSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD55_PIOCFG_RAWSEL_MASK) | (((uint32_t)val) << IO_PAD55_PIOCFG_RAWSEL_SHIFT))

#define  IO_PAD55_PIOCFG_PULL_SEL_MASK 0x8000
#define  IO_PAD55_PIOCFG_PULL_SEL_SHIFT 15
#define  IO_PAD55_PIOCFG_PULL_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD55_PIOCFG_PULL_SEL_MASK) >> IO_PAD55_PIOCFG_PULL_SEL_SHIFT)
#define  IO_PAD55_PIOCFG_PULL_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD55_PIOCFG_PULL_SEL_MASK) | (((uint32_t)val) << IO_PAD55_PIOCFG_PULL_SEL_SHIFT))

#define  IO_PAD55_PIOCFG_PUEN_MASK 0x4000
#define  IO_PAD55_PIOCFG_PUEN_SHIFT 14
#define  IO_PAD55_PIOCFG_PUEN_MASK_SHIFT(reg) (((reg) & IO_PAD55_PIOCFG_PUEN_MASK) >> IO_PAD55_PIOCFG_PUEN_SHIFT)
#define  IO_PAD55_PIOCFG_PUEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD55_PIOCFG_PUEN_MASK) | (((uint32_t)val) << IO_PAD55_PIOCFG_PUEN_SHIFT))

#define  IO_PAD55_PIOCFG_PDEN_MASK 0x2000
#define  IO_PAD55_PIOCFG_PDEN_SHIFT 13
#define  IO_PAD55_PIOCFG_PDEN_MASK_SHIFT(reg) (((reg) & IO_PAD55_PIOCFG_PDEN_MASK) >> IO_PAD55_PIOCFG_PDEN_SHIFT)
#define  IO_PAD55_PIOCFG_PDEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD55_PIOCFG_PDEN_MASK) | (((uint32_t)val) << IO_PAD55_PIOCFG_PDEN_SHIFT))

#define  IO_PAD55_PIOCFG_SR_MASK 0x1800
#define  IO_PAD55_PIOCFG_SR_SHIFT 11
#define  IO_PAD55_PIOCFG_SR_MASK_SHIFT(reg) (((reg) & IO_PAD55_PIOCFG_SR_MASK) >> IO_PAD55_PIOCFG_SR_SHIFT)
#define  IO_PAD55_PIOCFG_SR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD55_PIOCFG_SR_MASK) | (((uint32_t)val) << IO_PAD55_PIOCFG_SR_SHIFT))

#define  IO_PAD55_PIOCFG_SLP_DI_MASK 0x400
#define  IO_PAD55_PIOCFG_SLP_DI_SHIFT 10
#define  IO_PAD55_PIOCFG_SLP_DI_MASK_SHIFT(reg) (((reg) & IO_PAD55_PIOCFG_SLP_DI_MASK) >> IO_PAD55_PIOCFG_SLP_DI_SHIFT)
#define  IO_PAD55_PIOCFG_SLP_DI_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD55_PIOCFG_SLP_DI_MASK) | (((uint32_t)val) << IO_PAD55_PIOCFG_SLP_DI_SHIFT))

#define  IO_PAD55_PIOCFG_SLP_CNTRL_MASK 0x200
#define  IO_PAD55_PIOCFG_SLP_CNTRL_SHIFT 9
#define  IO_PAD55_PIOCFG_SLP_CNTRL_MASK_SHIFT(reg) (((reg) & IO_PAD55_PIOCFG_SLP_CNTRL_MASK) >> IO_PAD55_PIOCFG_SLP_CNTRL_SHIFT)
#define  IO_PAD55_PIOCFG_SLP_CNTRL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD55_PIOCFG_SLP_CNTRL_MASK) | (((uint32_t)val) << IO_PAD55_PIOCFG_SLP_CNTRL_SHIFT))

#define  IO_PAD55_PIOCFG_SLP_DO_MASK 0x100
#define  IO_PAD55_PIOCFG_SLP_DO_SHIFT 8
#define  IO_PAD55_PIOCFG_SLP_DO_MASK_SHIFT(reg) (((reg) & IO_PAD55_PIOCFG_SLP_DO_MASK) >> IO_PAD55_PIOCFG_SLP_DO_SHIFT)
#define  IO_PAD55_PIOCFG_SLP_DO_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD55_PIOCFG_SLP_DO_MASK) | (((uint32_t)val) << IO_PAD55_PIOCFG_SLP_DO_SHIFT))

#define  IO_PAD55_PIOCFG_SLP_DIR_MASK 0x80
#define  IO_PAD55_PIOCFG_SLP_DIR_SHIFT 7
#define  IO_PAD55_PIOCFG_SLP_DIR_MASK_SHIFT(reg) (((reg) & IO_PAD55_PIOCFG_SLP_DIR_MASK) >> IO_PAD55_PIOCFG_SLP_DIR_SHIFT)
#define  IO_PAD55_PIOCFG_SLP_DIR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD55_PIOCFG_SLP_DIR_MASK) | (((uint32_t)val) << IO_PAD55_PIOCFG_SLP_DIR_SHIFT))

#define  IO_PAD55_PIOCFG_EDGE_EN_N_MASK 0x40
#define  IO_PAD55_PIOCFG_EDGE_EN_N_SHIFT 6
#define  IO_PAD55_PIOCFG_EDGE_EN_N_MASK_SHIFT(reg) (((reg) & IO_PAD55_PIOCFG_EDGE_EN_N_MASK) >> IO_PAD55_PIOCFG_EDGE_EN_N_SHIFT)
#define  IO_PAD55_PIOCFG_EDGE_EN_N_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD55_PIOCFG_EDGE_EN_N_MASK) | (((uint32_t)val) << IO_PAD55_PIOCFG_EDGE_EN_N_SHIFT))

#define  IO_PAD55_PIOCFG_EDGE_FALL_EN_MASK 0x20
#define  IO_PAD55_PIOCFG_EDGE_FALL_EN_SHIFT 5
#define  IO_PAD55_PIOCFG_EDGE_FALL_EN_MASK_SHIFT(reg) (((reg) & IO_PAD55_PIOCFG_EDGE_FALL_EN_MASK) >> IO_PAD55_PIOCFG_EDGE_FALL_EN_SHIFT)
#define  IO_PAD55_PIOCFG_EDGE_FALL_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD55_PIOCFG_EDGE_FALL_EN_MASK) | (((uint32_t)val) << IO_PAD55_PIOCFG_EDGE_FALL_EN_SHIFT))

#define  IO_PAD55_PIOCFG_EDGE_RISE_EN_MASK 0x10
#define  IO_PAD55_PIOCFG_EDGE_RISE_EN_SHIFT 4
#define  IO_PAD55_PIOCFG_EDGE_RISE_EN_MASK_SHIFT(reg) (((reg) & IO_PAD55_PIOCFG_EDGE_RISE_EN_MASK) >> IO_PAD55_PIOCFG_EDGE_RISE_EN_SHIFT)
#define  IO_PAD55_PIOCFG_EDGE_RISE_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD55_PIOCFG_EDGE_RISE_EN_MASK) | (((uint32_t)val) << IO_PAD55_PIOCFG_EDGE_RISE_EN_SHIFT))

#define  IO_PAD55_PIOCFG_SLP_SEL_MASK 0x8
#define  IO_PAD55_PIOCFG_SLP_SEL_SHIFT 3
#define  IO_PAD55_PIOCFG_SLP_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD55_PIOCFG_SLP_SEL_MASK) >> IO_PAD55_PIOCFG_SLP_SEL_SHIFT)
#define  IO_PAD55_PIOCFG_SLP_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD55_PIOCFG_SLP_SEL_MASK) | (((uint32_t)val) << IO_PAD55_PIOCFG_SLP_SEL_SHIFT))

#define  IO_PAD55_PIOCFG_FUNC_SEL_MASK 0x7
#define  IO_PAD55_PIOCFG_FUNC_SEL_SHIFT 0
#define  IO_PAD55_PIOCFG_FUNC_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD55_PIOCFG_FUNC_SEL_MASK) >> IO_PAD55_PIOCFG_FUNC_SEL_SHIFT)
#define  IO_PAD55_PIOCFG_FUNC_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD55_PIOCFG_FUNC_SEL_MASK) | (((uint32_t)val) << IO_PAD55_PIOCFG_FUNC_SEL_SHIFT))

//====================================================================
//
//Register File: IO_PAD56 Configuration Registers (IO_PAD56)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

//====================================================================
//Register: IO_PAD56 Configuration Register (PIOCFG)
/** \brief "PHI_PADXDC_SRC" Pad*/
//====================================================================

#define  IO_PAD56_PIOCFG_RESERVED1_MASK 0xfc000000
#define  IO_PAD56_PIOCFG_RESERVED1_SHIFT 26
#define  IO_PAD56_PIOCFG_RESERVED1_MASK_SHIFT(reg) (((reg) & IO_PAD56_PIOCFG_RESERVED1_MASK) >> IO_PAD56_PIOCFG_RESERVED1_SHIFT)
#define  IO_PAD56_PIOCFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD56_PIOCFG_RESERVED1_MASK) | (((uint32_t)val) << IO_PAD56_PIOCFG_RESERVED1_SHIFT))

#define  IO_PAD56_PIOCFG_PD_MASK 0x2000000
#define  IO_PAD56_PIOCFG_PD_SHIFT 25
#define  IO_PAD56_PIOCFG_PD_MASK_SHIFT(reg) (((reg) & IO_PAD56_PIOCFG_PD_MASK) >> IO_PAD56_PIOCFG_PD_SHIFT)
#define  IO_PAD56_PIOCFG_PD_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD56_PIOCFG_PD_MASK) | (((uint32_t)val) << IO_PAD56_PIOCFG_PD_SHIFT))

#define  IO_PAD56_PIOCFG_ODT_EN_MASK 0x1000000
#define  IO_PAD56_PIOCFG_ODT_EN_SHIFT 24
#define  IO_PAD56_PIOCFG_ODT_EN_MASK_SHIFT(reg) (((reg) & IO_PAD56_PIOCFG_ODT_EN_MASK) >> IO_PAD56_PIOCFG_ODT_EN_SHIFT)
#define  IO_PAD56_PIOCFG_ODT_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD56_PIOCFG_ODT_EN_MASK) | (((uint32_t)val) << IO_PAD56_PIOCFG_ODT_EN_SHIFT))

#define  IO_PAD56_PIOCFG_LED_EN_MASK 0x800000
#define  IO_PAD56_PIOCFG_LED_EN_SHIFT 23
#define  IO_PAD56_PIOCFG_LED_EN_MASK_SHIFT(reg) (((reg) & IO_PAD56_PIOCFG_LED_EN_MASK) >> IO_PAD56_PIOCFG_LED_EN_SHIFT)
#define  IO_PAD56_PIOCFG_LED_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD56_PIOCFG_LED_EN_MASK) | (((uint32_t)val) << IO_PAD56_PIOCFG_LED_EN_SHIFT))

#define  IO_PAD56_PIOCFG_I2C_SEL_MASK 0x600000
#define  IO_PAD56_PIOCFG_I2C_SEL_SHIFT 21
#define  IO_PAD56_PIOCFG_I2C_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD56_PIOCFG_I2C_SEL_MASK) >> IO_PAD56_PIOCFG_I2C_SEL_SHIFT)
#define  IO_PAD56_PIOCFG_I2C_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD56_PIOCFG_I2C_SEL_MASK) | (((uint32_t)val) << IO_PAD56_PIOCFG_I2C_SEL_SHIFT))

#define  IO_PAD56_PIOCFG_DGTBSEL_MASK 0x1e0000
#define  IO_PAD56_PIOCFG_DGTBSEL_SHIFT 17
#define  IO_PAD56_PIOCFG_DGTBSEL_MASK_SHIFT(reg) (((reg) & IO_PAD56_PIOCFG_DGTBSEL_MASK) >> IO_PAD56_PIOCFG_DGTBSEL_SHIFT)
#define  IO_PAD56_PIOCFG_DGTBSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD56_PIOCFG_DGTBSEL_MASK) | (((uint32_t)val) << IO_PAD56_PIOCFG_DGTBSEL_SHIFT))

#define  IO_PAD56_PIOCFG_RAWSEL_MASK 0x10000
#define  IO_PAD56_PIOCFG_RAWSEL_SHIFT 16
#define  IO_PAD56_PIOCFG_RAWSEL_MASK_SHIFT(reg) (((reg) & IO_PAD56_PIOCFG_RAWSEL_MASK) >> IO_PAD56_PIOCFG_RAWSEL_SHIFT)
#define  IO_PAD56_PIOCFG_RAWSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD56_PIOCFG_RAWSEL_MASK) | (((uint32_t)val) << IO_PAD56_PIOCFG_RAWSEL_SHIFT))

#define  IO_PAD56_PIOCFG_PULL_SEL_MASK 0x8000
#define  IO_PAD56_PIOCFG_PULL_SEL_SHIFT 15
#define  IO_PAD56_PIOCFG_PULL_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD56_PIOCFG_PULL_SEL_MASK) >> IO_PAD56_PIOCFG_PULL_SEL_SHIFT)
#define  IO_PAD56_PIOCFG_PULL_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD56_PIOCFG_PULL_SEL_MASK) | (((uint32_t)val) << IO_PAD56_PIOCFG_PULL_SEL_SHIFT))

#define  IO_PAD56_PIOCFG_PUEN_MASK 0x4000
#define  IO_PAD56_PIOCFG_PUEN_SHIFT 14
#define  IO_PAD56_PIOCFG_PUEN_MASK_SHIFT(reg) (((reg) & IO_PAD56_PIOCFG_PUEN_MASK) >> IO_PAD56_PIOCFG_PUEN_SHIFT)
#define  IO_PAD56_PIOCFG_PUEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD56_PIOCFG_PUEN_MASK) | (((uint32_t)val) << IO_PAD56_PIOCFG_PUEN_SHIFT))

#define  IO_PAD56_PIOCFG_PDEN_MASK 0x2000
#define  IO_PAD56_PIOCFG_PDEN_SHIFT 13
#define  IO_PAD56_PIOCFG_PDEN_MASK_SHIFT(reg) (((reg) & IO_PAD56_PIOCFG_PDEN_MASK) >> IO_PAD56_PIOCFG_PDEN_SHIFT)
#define  IO_PAD56_PIOCFG_PDEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD56_PIOCFG_PDEN_MASK) | (((uint32_t)val) << IO_PAD56_PIOCFG_PDEN_SHIFT))

#define  IO_PAD56_PIOCFG_SR_MASK 0x1800
#define  IO_PAD56_PIOCFG_SR_SHIFT 11
#define  IO_PAD56_PIOCFG_SR_MASK_SHIFT(reg) (((reg) & IO_PAD56_PIOCFG_SR_MASK) >> IO_PAD56_PIOCFG_SR_SHIFT)
#define  IO_PAD56_PIOCFG_SR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD56_PIOCFG_SR_MASK) | (((uint32_t)val) << IO_PAD56_PIOCFG_SR_SHIFT))

#define  IO_PAD56_PIOCFG_SLP_DI_MASK 0x400
#define  IO_PAD56_PIOCFG_SLP_DI_SHIFT 10
#define  IO_PAD56_PIOCFG_SLP_DI_MASK_SHIFT(reg) (((reg) & IO_PAD56_PIOCFG_SLP_DI_MASK) >> IO_PAD56_PIOCFG_SLP_DI_SHIFT)
#define  IO_PAD56_PIOCFG_SLP_DI_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD56_PIOCFG_SLP_DI_MASK) | (((uint32_t)val) << IO_PAD56_PIOCFG_SLP_DI_SHIFT))

#define  IO_PAD56_PIOCFG_SLP_CNTRL_MASK 0x200
#define  IO_PAD56_PIOCFG_SLP_CNTRL_SHIFT 9
#define  IO_PAD56_PIOCFG_SLP_CNTRL_MASK_SHIFT(reg) (((reg) & IO_PAD56_PIOCFG_SLP_CNTRL_MASK) >> IO_PAD56_PIOCFG_SLP_CNTRL_SHIFT)
#define  IO_PAD56_PIOCFG_SLP_CNTRL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD56_PIOCFG_SLP_CNTRL_MASK) | (((uint32_t)val) << IO_PAD56_PIOCFG_SLP_CNTRL_SHIFT))

#define  IO_PAD56_PIOCFG_SLP_DO_MASK 0x100
#define  IO_PAD56_PIOCFG_SLP_DO_SHIFT 8
#define  IO_PAD56_PIOCFG_SLP_DO_MASK_SHIFT(reg) (((reg) & IO_PAD56_PIOCFG_SLP_DO_MASK) >> IO_PAD56_PIOCFG_SLP_DO_SHIFT)
#define  IO_PAD56_PIOCFG_SLP_DO_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD56_PIOCFG_SLP_DO_MASK) | (((uint32_t)val) << IO_PAD56_PIOCFG_SLP_DO_SHIFT))

#define  IO_PAD56_PIOCFG_SLP_DIR_MASK 0x80
#define  IO_PAD56_PIOCFG_SLP_DIR_SHIFT 7
#define  IO_PAD56_PIOCFG_SLP_DIR_MASK_SHIFT(reg) (((reg) & IO_PAD56_PIOCFG_SLP_DIR_MASK) >> IO_PAD56_PIOCFG_SLP_DIR_SHIFT)
#define  IO_PAD56_PIOCFG_SLP_DIR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD56_PIOCFG_SLP_DIR_MASK) | (((uint32_t)val) << IO_PAD56_PIOCFG_SLP_DIR_SHIFT))

#define  IO_PAD56_PIOCFG_EDGE_EN_N_MASK 0x40
#define  IO_PAD56_PIOCFG_EDGE_EN_N_SHIFT 6
#define  IO_PAD56_PIOCFG_EDGE_EN_N_MASK_SHIFT(reg) (((reg) & IO_PAD56_PIOCFG_EDGE_EN_N_MASK) >> IO_PAD56_PIOCFG_EDGE_EN_N_SHIFT)
#define  IO_PAD56_PIOCFG_EDGE_EN_N_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD56_PIOCFG_EDGE_EN_N_MASK) | (((uint32_t)val) << IO_PAD56_PIOCFG_EDGE_EN_N_SHIFT))

#define  IO_PAD56_PIOCFG_EDGE_FALL_EN_MASK 0x20
#define  IO_PAD56_PIOCFG_EDGE_FALL_EN_SHIFT 5
#define  IO_PAD56_PIOCFG_EDGE_FALL_EN_MASK_SHIFT(reg) (((reg) & IO_PAD56_PIOCFG_EDGE_FALL_EN_MASK) >> IO_PAD56_PIOCFG_EDGE_FALL_EN_SHIFT)
#define  IO_PAD56_PIOCFG_EDGE_FALL_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD56_PIOCFG_EDGE_FALL_EN_MASK) | (((uint32_t)val) << IO_PAD56_PIOCFG_EDGE_FALL_EN_SHIFT))

#define  IO_PAD56_PIOCFG_EDGE_RISE_EN_MASK 0x10
#define  IO_PAD56_PIOCFG_EDGE_RISE_EN_SHIFT 4
#define  IO_PAD56_PIOCFG_EDGE_RISE_EN_MASK_SHIFT(reg) (((reg) & IO_PAD56_PIOCFG_EDGE_RISE_EN_MASK) >> IO_PAD56_PIOCFG_EDGE_RISE_EN_SHIFT)
#define  IO_PAD56_PIOCFG_EDGE_RISE_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD56_PIOCFG_EDGE_RISE_EN_MASK) | (((uint32_t)val) << IO_PAD56_PIOCFG_EDGE_RISE_EN_SHIFT))

#define  IO_PAD56_PIOCFG_SLP_SEL_MASK 0x8
#define  IO_PAD56_PIOCFG_SLP_SEL_SHIFT 3
#define  IO_PAD56_PIOCFG_SLP_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD56_PIOCFG_SLP_SEL_MASK) >> IO_PAD56_PIOCFG_SLP_SEL_SHIFT)
#define  IO_PAD56_PIOCFG_SLP_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD56_PIOCFG_SLP_SEL_MASK) | (((uint32_t)val) << IO_PAD56_PIOCFG_SLP_SEL_SHIFT))

#define  IO_PAD56_PIOCFG_FUNC_SEL_MASK 0x7
#define  IO_PAD56_PIOCFG_FUNC_SEL_SHIFT 0
#define  IO_PAD56_PIOCFG_FUNC_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD56_PIOCFG_FUNC_SEL_MASK) >> IO_PAD56_PIOCFG_FUNC_SEL_SHIFT)
#define  IO_PAD56_PIOCFG_FUNC_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD56_PIOCFG_FUNC_SEL_MASK) | (((uint32_t)val) << IO_PAD56_PIOCFG_FUNC_SEL_SHIFT))

//====================================================================
//
//Register File: IO_PAD57 Configuration Registers (IO_PAD57)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

//====================================================================
//Register: IO_PAD57 Configuration Register (PIOCFG)
/** \brief "PHI_PADXDC_SRC" Pad*/
//====================================================================

#define  IO_PAD57_PIOCFG_RESERVED1_MASK 0xfc000000
#define  IO_PAD57_PIOCFG_RESERVED1_SHIFT 26
#define  IO_PAD57_PIOCFG_RESERVED1_MASK_SHIFT(reg) (((reg) & IO_PAD57_PIOCFG_RESERVED1_MASK) >> IO_PAD57_PIOCFG_RESERVED1_SHIFT)
#define  IO_PAD57_PIOCFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD57_PIOCFG_RESERVED1_MASK) | (((uint32_t)val) << IO_PAD57_PIOCFG_RESERVED1_SHIFT))

#define  IO_PAD57_PIOCFG_PD_MASK 0x2000000
#define  IO_PAD57_PIOCFG_PD_SHIFT 25
#define  IO_PAD57_PIOCFG_PD_MASK_SHIFT(reg) (((reg) & IO_PAD57_PIOCFG_PD_MASK) >> IO_PAD57_PIOCFG_PD_SHIFT)
#define  IO_PAD57_PIOCFG_PD_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD57_PIOCFG_PD_MASK) | (((uint32_t)val) << IO_PAD57_PIOCFG_PD_SHIFT))

#define  IO_PAD57_PIOCFG_ODT_EN_MASK 0x1000000
#define  IO_PAD57_PIOCFG_ODT_EN_SHIFT 24
#define  IO_PAD57_PIOCFG_ODT_EN_MASK_SHIFT(reg) (((reg) & IO_PAD57_PIOCFG_ODT_EN_MASK) >> IO_PAD57_PIOCFG_ODT_EN_SHIFT)
#define  IO_PAD57_PIOCFG_ODT_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD57_PIOCFG_ODT_EN_MASK) | (((uint32_t)val) << IO_PAD57_PIOCFG_ODT_EN_SHIFT))

#define  IO_PAD57_PIOCFG_LED_EN_MASK 0x800000
#define  IO_PAD57_PIOCFG_LED_EN_SHIFT 23
#define  IO_PAD57_PIOCFG_LED_EN_MASK_SHIFT(reg) (((reg) & IO_PAD57_PIOCFG_LED_EN_MASK) >> IO_PAD57_PIOCFG_LED_EN_SHIFT)
#define  IO_PAD57_PIOCFG_LED_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD57_PIOCFG_LED_EN_MASK) | (((uint32_t)val) << IO_PAD57_PIOCFG_LED_EN_SHIFT))

#define  IO_PAD57_PIOCFG_I2C_SEL_MASK 0x600000
#define  IO_PAD57_PIOCFG_I2C_SEL_SHIFT 21
#define  IO_PAD57_PIOCFG_I2C_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD57_PIOCFG_I2C_SEL_MASK) >> IO_PAD57_PIOCFG_I2C_SEL_SHIFT)
#define  IO_PAD57_PIOCFG_I2C_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD57_PIOCFG_I2C_SEL_MASK) | (((uint32_t)val) << IO_PAD57_PIOCFG_I2C_SEL_SHIFT))

#define  IO_PAD57_PIOCFG_DGTBSEL_MASK 0x1e0000
#define  IO_PAD57_PIOCFG_DGTBSEL_SHIFT 17
#define  IO_PAD57_PIOCFG_DGTBSEL_MASK_SHIFT(reg) (((reg) & IO_PAD57_PIOCFG_DGTBSEL_MASK) >> IO_PAD57_PIOCFG_DGTBSEL_SHIFT)
#define  IO_PAD57_PIOCFG_DGTBSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD57_PIOCFG_DGTBSEL_MASK) | (((uint32_t)val) << IO_PAD57_PIOCFG_DGTBSEL_SHIFT))

#define  IO_PAD57_PIOCFG_RAWSEL_MASK 0x10000
#define  IO_PAD57_PIOCFG_RAWSEL_SHIFT 16
#define  IO_PAD57_PIOCFG_RAWSEL_MASK_SHIFT(reg) (((reg) & IO_PAD57_PIOCFG_RAWSEL_MASK) >> IO_PAD57_PIOCFG_RAWSEL_SHIFT)
#define  IO_PAD57_PIOCFG_RAWSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD57_PIOCFG_RAWSEL_MASK) | (((uint32_t)val) << IO_PAD57_PIOCFG_RAWSEL_SHIFT))

#define  IO_PAD57_PIOCFG_PULL_SEL_MASK 0x8000
#define  IO_PAD57_PIOCFG_PULL_SEL_SHIFT 15
#define  IO_PAD57_PIOCFG_PULL_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD57_PIOCFG_PULL_SEL_MASK) >> IO_PAD57_PIOCFG_PULL_SEL_SHIFT)
#define  IO_PAD57_PIOCFG_PULL_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD57_PIOCFG_PULL_SEL_MASK) | (((uint32_t)val) << IO_PAD57_PIOCFG_PULL_SEL_SHIFT))

#define  IO_PAD57_PIOCFG_PUEN_MASK 0x4000
#define  IO_PAD57_PIOCFG_PUEN_SHIFT 14
#define  IO_PAD57_PIOCFG_PUEN_MASK_SHIFT(reg) (((reg) & IO_PAD57_PIOCFG_PUEN_MASK) >> IO_PAD57_PIOCFG_PUEN_SHIFT)
#define  IO_PAD57_PIOCFG_PUEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD57_PIOCFG_PUEN_MASK) | (((uint32_t)val) << IO_PAD57_PIOCFG_PUEN_SHIFT))

#define  IO_PAD57_PIOCFG_PDEN_MASK 0x2000
#define  IO_PAD57_PIOCFG_PDEN_SHIFT 13
#define  IO_PAD57_PIOCFG_PDEN_MASK_SHIFT(reg) (((reg) & IO_PAD57_PIOCFG_PDEN_MASK) >> IO_PAD57_PIOCFG_PDEN_SHIFT)
#define  IO_PAD57_PIOCFG_PDEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD57_PIOCFG_PDEN_MASK) | (((uint32_t)val) << IO_PAD57_PIOCFG_PDEN_SHIFT))

#define  IO_PAD57_PIOCFG_SR_MASK 0x1800
#define  IO_PAD57_PIOCFG_SR_SHIFT 11
#define  IO_PAD57_PIOCFG_SR_MASK_SHIFT(reg) (((reg) & IO_PAD57_PIOCFG_SR_MASK) >> IO_PAD57_PIOCFG_SR_SHIFT)
#define  IO_PAD57_PIOCFG_SR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD57_PIOCFG_SR_MASK) | (((uint32_t)val) << IO_PAD57_PIOCFG_SR_SHIFT))

#define  IO_PAD57_PIOCFG_SLP_DI_MASK 0x400
#define  IO_PAD57_PIOCFG_SLP_DI_SHIFT 10
#define  IO_PAD57_PIOCFG_SLP_DI_MASK_SHIFT(reg) (((reg) & IO_PAD57_PIOCFG_SLP_DI_MASK) >> IO_PAD57_PIOCFG_SLP_DI_SHIFT)
#define  IO_PAD57_PIOCFG_SLP_DI_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD57_PIOCFG_SLP_DI_MASK) | (((uint32_t)val) << IO_PAD57_PIOCFG_SLP_DI_SHIFT))

#define  IO_PAD57_PIOCFG_SLP_CNTRL_MASK 0x200
#define  IO_PAD57_PIOCFG_SLP_CNTRL_SHIFT 9
#define  IO_PAD57_PIOCFG_SLP_CNTRL_MASK_SHIFT(reg) (((reg) & IO_PAD57_PIOCFG_SLP_CNTRL_MASK) >> IO_PAD57_PIOCFG_SLP_CNTRL_SHIFT)
#define  IO_PAD57_PIOCFG_SLP_CNTRL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD57_PIOCFG_SLP_CNTRL_MASK) | (((uint32_t)val) << IO_PAD57_PIOCFG_SLP_CNTRL_SHIFT))

#define  IO_PAD57_PIOCFG_SLP_DO_MASK 0x100
#define  IO_PAD57_PIOCFG_SLP_DO_SHIFT 8
#define  IO_PAD57_PIOCFG_SLP_DO_MASK_SHIFT(reg) (((reg) & IO_PAD57_PIOCFG_SLP_DO_MASK) >> IO_PAD57_PIOCFG_SLP_DO_SHIFT)
#define  IO_PAD57_PIOCFG_SLP_DO_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD57_PIOCFG_SLP_DO_MASK) | (((uint32_t)val) << IO_PAD57_PIOCFG_SLP_DO_SHIFT))

#define  IO_PAD57_PIOCFG_SLP_DIR_MASK 0x80
#define  IO_PAD57_PIOCFG_SLP_DIR_SHIFT 7
#define  IO_PAD57_PIOCFG_SLP_DIR_MASK_SHIFT(reg) (((reg) & IO_PAD57_PIOCFG_SLP_DIR_MASK) >> IO_PAD57_PIOCFG_SLP_DIR_SHIFT)
#define  IO_PAD57_PIOCFG_SLP_DIR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD57_PIOCFG_SLP_DIR_MASK) | (((uint32_t)val) << IO_PAD57_PIOCFG_SLP_DIR_SHIFT))

#define  IO_PAD57_PIOCFG_EDGE_EN_N_MASK 0x40
#define  IO_PAD57_PIOCFG_EDGE_EN_N_SHIFT 6
#define  IO_PAD57_PIOCFG_EDGE_EN_N_MASK_SHIFT(reg) (((reg) & IO_PAD57_PIOCFG_EDGE_EN_N_MASK) >> IO_PAD57_PIOCFG_EDGE_EN_N_SHIFT)
#define  IO_PAD57_PIOCFG_EDGE_EN_N_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD57_PIOCFG_EDGE_EN_N_MASK) | (((uint32_t)val) << IO_PAD57_PIOCFG_EDGE_EN_N_SHIFT))

#define  IO_PAD57_PIOCFG_EDGE_FALL_EN_MASK 0x20
#define  IO_PAD57_PIOCFG_EDGE_FALL_EN_SHIFT 5
#define  IO_PAD57_PIOCFG_EDGE_FALL_EN_MASK_SHIFT(reg) (((reg) & IO_PAD57_PIOCFG_EDGE_FALL_EN_MASK) >> IO_PAD57_PIOCFG_EDGE_FALL_EN_SHIFT)
#define  IO_PAD57_PIOCFG_EDGE_FALL_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD57_PIOCFG_EDGE_FALL_EN_MASK) | (((uint32_t)val) << IO_PAD57_PIOCFG_EDGE_FALL_EN_SHIFT))

#define  IO_PAD57_PIOCFG_EDGE_RISE_EN_MASK 0x10
#define  IO_PAD57_PIOCFG_EDGE_RISE_EN_SHIFT 4
#define  IO_PAD57_PIOCFG_EDGE_RISE_EN_MASK_SHIFT(reg) (((reg) & IO_PAD57_PIOCFG_EDGE_RISE_EN_MASK) >> IO_PAD57_PIOCFG_EDGE_RISE_EN_SHIFT)
#define  IO_PAD57_PIOCFG_EDGE_RISE_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD57_PIOCFG_EDGE_RISE_EN_MASK) | (((uint32_t)val) << IO_PAD57_PIOCFG_EDGE_RISE_EN_SHIFT))

#define  IO_PAD57_PIOCFG_SLP_SEL_MASK 0x8
#define  IO_PAD57_PIOCFG_SLP_SEL_SHIFT 3
#define  IO_PAD57_PIOCFG_SLP_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD57_PIOCFG_SLP_SEL_MASK) >> IO_PAD57_PIOCFG_SLP_SEL_SHIFT)
#define  IO_PAD57_PIOCFG_SLP_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD57_PIOCFG_SLP_SEL_MASK) | (((uint32_t)val) << IO_PAD57_PIOCFG_SLP_SEL_SHIFT))

#define  IO_PAD57_PIOCFG_FUNC_SEL_MASK 0x7
#define  IO_PAD57_PIOCFG_FUNC_SEL_SHIFT 0
#define  IO_PAD57_PIOCFG_FUNC_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD57_PIOCFG_FUNC_SEL_MASK) >> IO_PAD57_PIOCFG_FUNC_SEL_SHIFT)
#define  IO_PAD57_PIOCFG_FUNC_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD57_PIOCFG_FUNC_SEL_MASK) | (((uint32_t)val) << IO_PAD57_PIOCFG_FUNC_SEL_SHIFT))

//====================================================================
//
//Register File: IO_PAD58 Configuration Registers (IO_PAD58)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

//====================================================================
//Register: IO_PAD58 Configuration Register (PIOCFG)
/** \brief "PHI_PADXDC_SRC" Pad*/
//====================================================================

#define  IO_PAD58_PIOCFG_RESERVED1_MASK 0xfc000000
#define  IO_PAD58_PIOCFG_RESERVED1_SHIFT 26
#define  IO_PAD58_PIOCFG_RESERVED1_MASK_SHIFT(reg) (((reg) & IO_PAD58_PIOCFG_RESERVED1_MASK) >> IO_PAD58_PIOCFG_RESERVED1_SHIFT)
#define  IO_PAD58_PIOCFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD58_PIOCFG_RESERVED1_MASK) | (((uint32_t)val) << IO_PAD58_PIOCFG_RESERVED1_SHIFT))

#define  IO_PAD58_PIOCFG_PD_MASK 0x2000000
#define  IO_PAD58_PIOCFG_PD_SHIFT 25
#define  IO_PAD58_PIOCFG_PD_MASK_SHIFT(reg) (((reg) & IO_PAD58_PIOCFG_PD_MASK) >> IO_PAD58_PIOCFG_PD_SHIFT)
#define  IO_PAD58_PIOCFG_PD_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD58_PIOCFG_PD_MASK) | (((uint32_t)val) << IO_PAD58_PIOCFG_PD_SHIFT))

#define  IO_PAD58_PIOCFG_ODT_EN_MASK 0x1000000
#define  IO_PAD58_PIOCFG_ODT_EN_SHIFT 24
#define  IO_PAD58_PIOCFG_ODT_EN_MASK_SHIFT(reg) (((reg) & IO_PAD58_PIOCFG_ODT_EN_MASK) >> IO_PAD58_PIOCFG_ODT_EN_SHIFT)
#define  IO_PAD58_PIOCFG_ODT_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD58_PIOCFG_ODT_EN_MASK) | (((uint32_t)val) << IO_PAD58_PIOCFG_ODT_EN_SHIFT))

#define  IO_PAD58_PIOCFG_LED_EN_MASK 0x800000
#define  IO_PAD58_PIOCFG_LED_EN_SHIFT 23
#define  IO_PAD58_PIOCFG_LED_EN_MASK_SHIFT(reg) (((reg) & IO_PAD58_PIOCFG_LED_EN_MASK) >> IO_PAD58_PIOCFG_LED_EN_SHIFT)
#define  IO_PAD58_PIOCFG_LED_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD58_PIOCFG_LED_EN_MASK) | (((uint32_t)val) << IO_PAD58_PIOCFG_LED_EN_SHIFT))

#define  IO_PAD58_PIOCFG_I2C_SEL_MASK 0x600000
#define  IO_PAD58_PIOCFG_I2C_SEL_SHIFT 21
#define  IO_PAD58_PIOCFG_I2C_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD58_PIOCFG_I2C_SEL_MASK) >> IO_PAD58_PIOCFG_I2C_SEL_SHIFT)
#define  IO_PAD58_PIOCFG_I2C_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD58_PIOCFG_I2C_SEL_MASK) | (((uint32_t)val) << IO_PAD58_PIOCFG_I2C_SEL_SHIFT))

#define  IO_PAD58_PIOCFG_DGTBSEL_MASK 0x1e0000
#define  IO_PAD58_PIOCFG_DGTBSEL_SHIFT 17
#define  IO_PAD58_PIOCFG_DGTBSEL_MASK_SHIFT(reg) (((reg) & IO_PAD58_PIOCFG_DGTBSEL_MASK) >> IO_PAD58_PIOCFG_DGTBSEL_SHIFT)
#define  IO_PAD58_PIOCFG_DGTBSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD58_PIOCFG_DGTBSEL_MASK) | (((uint32_t)val) << IO_PAD58_PIOCFG_DGTBSEL_SHIFT))

#define  IO_PAD58_PIOCFG_RAWSEL_MASK 0x10000
#define  IO_PAD58_PIOCFG_RAWSEL_SHIFT 16
#define  IO_PAD58_PIOCFG_RAWSEL_MASK_SHIFT(reg) (((reg) & IO_PAD58_PIOCFG_RAWSEL_MASK) >> IO_PAD58_PIOCFG_RAWSEL_SHIFT)
#define  IO_PAD58_PIOCFG_RAWSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD58_PIOCFG_RAWSEL_MASK) | (((uint32_t)val) << IO_PAD58_PIOCFG_RAWSEL_SHIFT))

#define  IO_PAD58_PIOCFG_PULL_SEL_MASK 0x8000
#define  IO_PAD58_PIOCFG_PULL_SEL_SHIFT 15
#define  IO_PAD58_PIOCFG_PULL_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD58_PIOCFG_PULL_SEL_MASK) >> IO_PAD58_PIOCFG_PULL_SEL_SHIFT)
#define  IO_PAD58_PIOCFG_PULL_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD58_PIOCFG_PULL_SEL_MASK) | (((uint32_t)val) << IO_PAD58_PIOCFG_PULL_SEL_SHIFT))

#define  IO_PAD58_PIOCFG_PUEN_MASK 0x4000
#define  IO_PAD58_PIOCFG_PUEN_SHIFT 14
#define  IO_PAD58_PIOCFG_PUEN_MASK_SHIFT(reg) (((reg) & IO_PAD58_PIOCFG_PUEN_MASK) >> IO_PAD58_PIOCFG_PUEN_SHIFT)
#define  IO_PAD58_PIOCFG_PUEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD58_PIOCFG_PUEN_MASK) | (((uint32_t)val) << IO_PAD58_PIOCFG_PUEN_SHIFT))

#define  IO_PAD58_PIOCFG_PDEN_MASK 0x2000
#define  IO_PAD58_PIOCFG_PDEN_SHIFT 13
#define  IO_PAD58_PIOCFG_PDEN_MASK_SHIFT(reg) (((reg) & IO_PAD58_PIOCFG_PDEN_MASK) >> IO_PAD58_PIOCFG_PDEN_SHIFT)
#define  IO_PAD58_PIOCFG_PDEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD58_PIOCFG_PDEN_MASK) | (((uint32_t)val) << IO_PAD58_PIOCFG_PDEN_SHIFT))

#define  IO_PAD58_PIOCFG_SR_MASK 0x1800
#define  IO_PAD58_PIOCFG_SR_SHIFT 11
#define  IO_PAD58_PIOCFG_SR_MASK_SHIFT(reg) (((reg) & IO_PAD58_PIOCFG_SR_MASK) >> IO_PAD58_PIOCFG_SR_SHIFT)
#define  IO_PAD58_PIOCFG_SR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD58_PIOCFG_SR_MASK) | (((uint32_t)val) << IO_PAD58_PIOCFG_SR_SHIFT))

#define  IO_PAD58_PIOCFG_SLP_DI_MASK 0x400
#define  IO_PAD58_PIOCFG_SLP_DI_SHIFT 10
#define  IO_PAD58_PIOCFG_SLP_DI_MASK_SHIFT(reg) (((reg) & IO_PAD58_PIOCFG_SLP_DI_MASK) >> IO_PAD58_PIOCFG_SLP_DI_SHIFT)
#define  IO_PAD58_PIOCFG_SLP_DI_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD58_PIOCFG_SLP_DI_MASK) | (((uint32_t)val) << IO_PAD58_PIOCFG_SLP_DI_SHIFT))

#define  IO_PAD58_PIOCFG_SLP_CNTRL_MASK 0x200
#define  IO_PAD58_PIOCFG_SLP_CNTRL_SHIFT 9
#define  IO_PAD58_PIOCFG_SLP_CNTRL_MASK_SHIFT(reg) (((reg) & IO_PAD58_PIOCFG_SLP_CNTRL_MASK) >> IO_PAD58_PIOCFG_SLP_CNTRL_SHIFT)
#define  IO_PAD58_PIOCFG_SLP_CNTRL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD58_PIOCFG_SLP_CNTRL_MASK) | (((uint32_t)val) << IO_PAD58_PIOCFG_SLP_CNTRL_SHIFT))

#define  IO_PAD58_PIOCFG_SLP_DO_MASK 0x100
#define  IO_PAD58_PIOCFG_SLP_DO_SHIFT 8
#define  IO_PAD58_PIOCFG_SLP_DO_MASK_SHIFT(reg) (((reg) & IO_PAD58_PIOCFG_SLP_DO_MASK) >> IO_PAD58_PIOCFG_SLP_DO_SHIFT)
#define  IO_PAD58_PIOCFG_SLP_DO_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD58_PIOCFG_SLP_DO_MASK) | (((uint32_t)val) << IO_PAD58_PIOCFG_SLP_DO_SHIFT))

#define  IO_PAD58_PIOCFG_SLP_DIR_MASK 0x80
#define  IO_PAD58_PIOCFG_SLP_DIR_SHIFT 7
#define  IO_PAD58_PIOCFG_SLP_DIR_MASK_SHIFT(reg) (((reg) & IO_PAD58_PIOCFG_SLP_DIR_MASK) >> IO_PAD58_PIOCFG_SLP_DIR_SHIFT)
#define  IO_PAD58_PIOCFG_SLP_DIR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD58_PIOCFG_SLP_DIR_MASK) | (((uint32_t)val) << IO_PAD58_PIOCFG_SLP_DIR_SHIFT))

#define  IO_PAD58_PIOCFG_EDGE_EN_N_MASK 0x40
#define  IO_PAD58_PIOCFG_EDGE_EN_N_SHIFT 6
#define  IO_PAD58_PIOCFG_EDGE_EN_N_MASK_SHIFT(reg) (((reg) & IO_PAD58_PIOCFG_EDGE_EN_N_MASK) >> IO_PAD58_PIOCFG_EDGE_EN_N_SHIFT)
#define  IO_PAD58_PIOCFG_EDGE_EN_N_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD58_PIOCFG_EDGE_EN_N_MASK) | (((uint32_t)val) << IO_PAD58_PIOCFG_EDGE_EN_N_SHIFT))

#define  IO_PAD58_PIOCFG_EDGE_FALL_EN_MASK 0x20
#define  IO_PAD58_PIOCFG_EDGE_FALL_EN_SHIFT 5
#define  IO_PAD58_PIOCFG_EDGE_FALL_EN_MASK_SHIFT(reg) (((reg) & IO_PAD58_PIOCFG_EDGE_FALL_EN_MASK) >> IO_PAD58_PIOCFG_EDGE_FALL_EN_SHIFT)
#define  IO_PAD58_PIOCFG_EDGE_FALL_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD58_PIOCFG_EDGE_FALL_EN_MASK) | (((uint32_t)val) << IO_PAD58_PIOCFG_EDGE_FALL_EN_SHIFT))

#define  IO_PAD58_PIOCFG_EDGE_RISE_EN_MASK 0x10
#define  IO_PAD58_PIOCFG_EDGE_RISE_EN_SHIFT 4
#define  IO_PAD58_PIOCFG_EDGE_RISE_EN_MASK_SHIFT(reg) (((reg) & IO_PAD58_PIOCFG_EDGE_RISE_EN_MASK) >> IO_PAD58_PIOCFG_EDGE_RISE_EN_SHIFT)
#define  IO_PAD58_PIOCFG_EDGE_RISE_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD58_PIOCFG_EDGE_RISE_EN_MASK) | (((uint32_t)val) << IO_PAD58_PIOCFG_EDGE_RISE_EN_SHIFT))

#define  IO_PAD58_PIOCFG_SLP_SEL_MASK 0x8
#define  IO_PAD58_PIOCFG_SLP_SEL_SHIFT 3
#define  IO_PAD58_PIOCFG_SLP_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD58_PIOCFG_SLP_SEL_MASK) >> IO_PAD58_PIOCFG_SLP_SEL_SHIFT)
#define  IO_PAD58_PIOCFG_SLP_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD58_PIOCFG_SLP_SEL_MASK) | (((uint32_t)val) << IO_PAD58_PIOCFG_SLP_SEL_SHIFT))

#define  IO_PAD58_PIOCFG_FUNC_SEL_MASK 0x7
#define  IO_PAD58_PIOCFG_FUNC_SEL_SHIFT 0
#define  IO_PAD58_PIOCFG_FUNC_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD58_PIOCFG_FUNC_SEL_MASK) >> IO_PAD58_PIOCFG_FUNC_SEL_SHIFT)
#define  IO_PAD58_PIOCFG_FUNC_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD58_PIOCFG_FUNC_SEL_MASK) | (((uint32_t)val) << IO_PAD58_PIOCFG_FUNC_SEL_SHIFT))

//====================================================================
//
//Register File: IO_PAD59 Configuration Registers (IO_PAD59)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

//====================================================================
//Register: IO_PAD59 Configuration Register (PIOCFG)
/** \brief "PHI_PADXDC_SRC" Pad*/
//====================================================================

#define  IO_PAD59_PIOCFG_RESERVED1_MASK 0xfc000000
#define  IO_PAD59_PIOCFG_RESERVED1_SHIFT 26
#define  IO_PAD59_PIOCFG_RESERVED1_MASK_SHIFT(reg) (((reg) & IO_PAD59_PIOCFG_RESERVED1_MASK) >> IO_PAD59_PIOCFG_RESERVED1_SHIFT)
#define  IO_PAD59_PIOCFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD59_PIOCFG_RESERVED1_MASK) | (((uint32_t)val) << IO_PAD59_PIOCFG_RESERVED1_SHIFT))

#define  IO_PAD59_PIOCFG_PD_MASK 0x2000000
#define  IO_PAD59_PIOCFG_PD_SHIFT 25
#define  IO_PAD59_PIOCFG_PD_MASK_SHIFT(reg) (((reg) & IO_PAD59_PIOCFG_PD_MASK) >> IO_PAD59_PIOCFG_PD_SHIFT)
#define  IO_PAD59_PIOCFG_PD_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD59_PIOCFG_PD_MASK) | (((uint32_t)val) << IO_PAD59_PIOCFG_PD_SHIFT))

#define  IO_PAD59_PIOCFG_ODT_EN_MASK 0x1000000
#define  IO_PAD59_PIOCFG_ODT_EN_SHIFT 24
#define  IO_PAD59_PIOCFG_ODT_EN_MASK_SHIFT(reg) (((reg) & IO_PAD59_PIOCFG_ODT_EN_MASK) >> IO_PAD59_PIOCFG_ODT_EN_SHIFT)
#define  IO_PAD59_PIOCFG_ODT_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD59_PIOCFG_ODT_EN_MASK) | (((uint32_t)val) << IO_PAD59_PIOCFG_ODT_EN_SHIFT))

#define  IO_PAD59_PIOCFG_LED_EN_MASK 0x800000
#define  IO_PAD59_PIOCFG_LED_EN_SHIFT 23
#define  IO_PAD59_PIOCFG_LED_EN_MASK_SHIFT(reg) (((reg) & IO_PAD59_PIOCFG_LED_EN_MASK) >> IO_PAD59_PIOCFG_LED_EN_SHIFT)
#define  IO_PAD59_PIOCFG_LED_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD59_PIOCFG_LED_EN_MASK) | (((uint32_t)val) << IO_PAD59_PIOCFG_LED_EN_SHIFT))

#define  IO_PAD59_PIOCFG_I2C_SEL_MASK 0x600000
#define  IO_PAD59_PIOCFG_I2C_SEL_SHIFT 21
#define  IO_PAD59_PIOCFG_I2C_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD59_PIOCFG_I2C_SEL_MASK) >> IO_PAD59_PIOCFG_I2C_SEL_SHIFT)
#define  IO_PAD59_PIOCFG_I2C_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD59_PIOCFG_I2C_SEL_MASK) | (((uint32_t)val) << IO_PAD59_PIOCFG_I2C_SEL_SHIFT))

#define  IO_PAD59_PIOCFG_DGTBSEL_MASK 0x1e0000
#define  IO_PAD59_PIOCFG_DGTBSEL_SHIFT 17
#define  IO_PAD59_PIOCFG_DGTBSEL_MASK_SHIFT(reg) (((reg) & IO_PAD59_PIOCFG_DGTBSEL_MASK) >> IO_PAD59_PIOCFG_DGTBSEL_SHIFT)
#define  IO_PAD59_PIOCFG_DGTBSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD59_PIOCFG_DGTBSEL_MASK) | (((uint32_t)val) << IO_PAD59_PIOCFG_DGTBSEL_SHIFT))

#define  IO_PAD59_PIOCFG_RAWSEL_MASK 0x10000
#define  IO_PAD59_PIOCFG_RAWSEL_SHIFT 16
#define  IO_PAD59_PIOCFG_RAWSEL_MASK_SHIFT(reg) (((reg) & IO_PAD59_PIOCFG_RAWSEL_MASK) >> IO_PAD59_PIOCFG_RAWSEL_SHIFT)
#define  IO_PAD59_PIOCFG_RAWSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD59_PIOCFG_RAWSEL_MASK) | (((uint32_t)val) << IO_PAD59_PIOCFG_RAWSEL_SHIFT))

#define  IO_PAD59_PIOCFG_PULL_SEL_MASK 0x8000
#define  IO_PAD59_PIOCFG_PULL_SEL_SHIFT 15
#define  IO_PAD59_PIOCFG_PULL_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD59_PIOCFG_PULL_SEL_MASK) >> IO_PAD59_PIOCFG_PULL_SEL_SHIFT)
#define  IO_PAD59_PIOCFG_PULL_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD59_PIOCFG_PULL_SEL_MASK) | (((uint32_t)val) << IO_PAD59_PIOCFG_PULL_SEL_SHIFT))

#define  IO_PAD59_PIOCFG_PUEN_MASK 0x4000
#define  IO_PAD59_PIOCFG_PUEN_SHIFT 14
#define  IO_PAD59_PIOCFG_PUEN_MASK_SHIFT(reg) (((reg) & IO_PAD59_PIOCFG_PUEN_MASK) >> IO_PAD59_PIOCFG_PUEN_SHIFT)
#define  IO_PAD59_PIOCFG_PUEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD59_PIOCFG_PUEN_MASK) | (((uint32_t)val) << IO_PAD59_PIOCFG_PUEN_SHIFT))

#define  IO_PAD59_PIOCFG_PDEN_MASK 0x2000
#define  IO_PAD59_PIOCFG_PDEN_SHIFT 13
#define  IO_PAD59_PIOCFG_PDEN_MASK_SHIFT(reg) (((reg) & IO_PAD59_PIOCFG_PDEN_MASK) >> IO_PAD59_PIOCFG_PDEN_SHIFT)
#define  IO_PAD59_PIOCFG_PDEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD59_PIOCFG_PDEN_MASK) | (((uint32_t)val) << IO_PAD59_PIOCFG_PDEN_SHIFT))

#define  IO_PAD59_PIOCFG_SR_MASK 0x1800
#define  IO_PAD59_PIOCFG_SR_SHIFT 11
#define  IO_PAD59_PIOCFG_SR_MASK_SHIFT(reg) (((reg) & IO_PAD59_PIOCFG_SR_MASK) >> IO_PAD59_PIOCFG_SR_SHIFT)
#define  IO_PAD59_PIOCFG_SR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD59_PIOCFG_SR_MASK) | (((uint32_t)val) << IO_PAD59_PIOCFG_SR_SHIFT))

#define  IO_PAD59_PIOCFG_SLP_DI_MASK 0x400
#define  IO_PAD59_PIOCFG_SLP_DI_SHIFT 10
#define  IO_PAD59_PIOCFG_SLP_DI_MASK_SHIFT(reg) (((reg) & IO_PAD59_PIOCFG_SLP_DI_MASK) >> IO_PAD59_PIOCFG_SLP_DI_SHIFT)
#define  IO_PAD59_PIOCFG_SLP_DI_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD59_PIOCFG_SLP_DI_MASK) | (((uint32_t)val) << IO_PAD59_PIOCFG_SLP_DI_SHIFT))

#define  IO_PAD59_PIOCFG_SLP_CNTRL_MASK 0x200
#define  IO_PAD59_PIOCFG_SLP_CNTRL_SHIFT 9
#define  IO_PAD59_PIOCFG_SLP_CNTRL_MASK_SHIFT(reg) (((reg) & IO_PAD59_PIOCFG_SLP_CNTRL_MASK) >> IO_PAD59_PIOCFG_SLP_CNTRL_SHIFT)
#define  IO_PAD59_PIOCFG_SLP_CNTRL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD59_PIOCFG_SLP_CNTRL_MASK) | (((uint32_t)val) << IO_PAD59_PIOCFG_SLP_CNTRL_SHIFT))

#define  IO_PAD59_PIOCFG_SLP_DO_MASK 0x100
#define  IO_PAD59_PIOCFG_SLP_DO_SHIFT 8
#define  IO_PAD59_PIOCFG_SLP_DO_MASK_SHIFT(reg) (((reg) & IO_PAD59_PIOCFG_SLP_DO_MASK) >> IO_PAD59_PIOCFG_SLP_DO_SHIFT)
#define  IO_PAD59_PIOCFG_SLP_DO_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD59_PIOCFG_SLP_DO_MASK) | (((uint32_t)val) << IO_PAD59_PIOCFG_SLP_DO_SHIFT))

#define  IO_PAD59_PIOCFG_SLP_DIR_MASK 0x80
#define  IO_PAD59_PIOCFG_SLP_DIR_SHIFT 7
#define  IO_PAD59_PIOCFG_SLP_DIR_MASK_SHIFT(reg) (((reg) & IO_PAD59_PIOCFG_SLP_DIR_MASK) >> IO_PAD59_PIOCFG_SLP_DIR_SHIFT)
#define  IO_PAD59_PIOCFG_SLP_DIR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD59_PIOCFG_SLP_DIR_MASK) | (((uint32_t)val) << IO_PAD59_PIOCFG_SLP_DIR_SHIFT))

#define  IO_PAD59_PIOCFG_EDGE_EN_N_MASK 0x40
#define  IO_PAD59_PIOCFG_EDGE_EN_N_SHIFT 6
#define  IO_PAD59_PIOCFG_EDGE_EN_N_MASK_SHIFT(reg) (((reg) & IO_PAD59_PIOCFG_EDGE_EN_N_MASK) >> IO_PAD59_PIOCFG_EDGE_EN_N_SHIFT)
#define  IO_PAD59_PIOCFG_EDGE_EN_N_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD59_PIOCFG_EDGE_EN_N_MASK) | (((uint32_t)val) << IO_PAD59_PIOCFG_EDGE_EN_N_SHIFT))

#define  IO_PAD59_PIOCFG_EDGE_FALL_EN_MASK 0x20
#define  IO_PAD59_PIOCFG_EDGE_FALL_EN_SHIFT 5
#define  IO_PAD59_PIOCFG_EDGE_FALL_EN_MASK_SHIFT(reg) (((reg) & IO_PAD59_PIOCFG_EDGE_FALL_EN_MASK) >> IO_PAD59_PIOCFG_EDGE_FALL_EN_SHIFT)
#define  IO_PAD59_PIOCFG_EDGE_FALL_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD59_PIOCFG_EDGE_FALL_EN_MASK) | (((uint32_t)val) << IO_PAD59_PIOCFG_EDGE_FALL_EN_SHIFT))

#define  IO_PAD59_PIOCFG_EDGE_RISE_EN_MASK 0x10
#define  IO_PAD59_PIOCFG_EDGE_RISE_EN_SHIFT 4
#define  IO_PAD59_PIOCFG_EDGE_RISE_EN_MASK_SHIFT(reg) (((reg) & IO_PAD59_PIOCFG_EDGE_RISE_EN_MASK) >> IO_PAD59_PIOCFG_EDGE_RISE_EN_SHIFT)
#define  IO_PAD59_PIOCFG_EDGE_RISE_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD59_PIOCFG_EDGE_RISE_EN_MASK) | (((uint32_t)val) << IO_PAD59_PIOCFG_EDGE_RISE_EN_SHIFT))

#define  IO_PAD59_PIOCFG_SLP_SEL_MASK 0x8
#define  IO_PAD59_PIOCFG_SLP_SEL_SHIFT 3
#define  IO_PAD59_PIOCFG_SLP_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD59_PIOCFG_SLP_SEL_MASK) >> IO_PAD59_PIOCFG_SLP_SEL_SHIFT)
#define  IO_PAD59_PIOCFG_SLP_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD59_PIOCFG_SLP_SEL_MASK) | (((uint32_t)val) << IO_PAD59_PIOCFG_SLP_SEL_SHIFT))

#define  IO_PAD59_PIOCFG_FUNC_SEL_MASK 0x7
#define  IO_PAD59_PIOCFG_FUNC_SEL_SHIFT 0
#define  IO_PAD59_PIOCFG_FUNC_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD59_PIOCFG_FUNC_SEL_MASK) >> IO_PAD59_PIOCFG_FUNC_SEL_SHIFT)
#define  IO_PAD59_PIOCFG_FUNC_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD59_PIOCFG_FUNC_SEL_MASK) | (((uint32_t)val) << IO_PAD59_PIOCFG_FUNC_SEL_SHIFT))

//====================================================================
//
//Register File: IO_PAD60 Configuration Registers (IO_PAD60)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

//====================================================================
//Register: IO_PAD60 Configuration Register (PIOCFG)
/** \brief "PHI_PADXDC_SRC" Pad*/
//====================================================================

#define  IO_PAD60_PIOCFG_RESERVED1_MASK 0xfc000000
#define  IO_PAD60_PIOCFG_RESERVED1_SHIFT 26
#define  IO_PAD60_PIOCFG_RESERVED1_MASK_SHIFT(reg) (((reg) & IO_PAD60_PIOCFG_RESERVED1_MASK) >> IO_PAD60_PIOCFG_RESERVED1_SHIFT)
#define  IO_PAD60_PIOCFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD60_PIOCFG_RESERVED1_MASK) | (((uint32_t)val) << IO_PAD60_PIOCFG_RESERVED1_SHIFT))

#define  IO_PAD60_PIOCFG_PD_MASK 0x2000000
#define  IO_PAD60_PIOCFG_PD_SHIFT 25
#define  IO_PAD60_PIOCFG_PD_MASK_SHIFT(reg) (((reg) & IO_PAD60_PIOCFG_PD_MASK) >> IO_PAD60_PIOCFG_PD_SHIFT)
#define  IO_PAD60_PIOCFG_PD_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD60_PIOCFG_PD_MASK) | (((uint32_t)val) << IO_PAD60_PIOCFG_PD_SHIFT))

#define  IO_PAD60_PIOCFG_ODT_EN_MASK 0x1000000
#define  IO_PAD60_PIOCFG_ODT_EN_SHIFT 24
#define  IO_PAD60_PIOCFG_ODT_EN_MASK_SHIFT(reg) (((reg) & IO_PAD60_PIOCFG_ODT_EN_MASK) >> IO_PAD60_PIOCFG_ODT_EN_SHIFT)
#define  IO_PAD60_PIOCFG_ODT_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD60_PIOCFG_ODT_EN_MASK) | (((uint32_t)val) << IO_PAD60_PIOCFG_ODT_EN_SHIFT))

#define  IO_PAD60_PIOCFG_LED_EN_MASK 0x800000
#define  IO_PAD60_PIOCFG_LED_EN_SHIFT 23
#define  IO_PAD60_PIOCFG_LED_EN_MASK_SHIFT(reg) (((reg) & IO_PAD60_PIOCFG_LED_EN_MASK) >> IO_PAD60_PIOCFG_LED_EN_SHIFT)
#define  IO_PAD60_PIOCFG_LED_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD60_PIOCFG_LED_EN_MASK) | (((uint32_t)val) << IO_PAD60_PIOCFG_LED_EN_SHIFT))

#define  IO_PAD60_PIOCFG_I2C_SEL_MASK 0x600000
#define  IO_PAD60_PIOCFG_I2C_SEL_SHIFT 21
#define  IO_PAD60_PIOCFG_I2C_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD60_PIOCFG_I2C_SEL_MASK) >> IO_PAD60_PIOCFG_I2C_SEL_SHIFT)
#define  IO_PAD60_PIOCFG_I2C_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD60_PIOCFG_I2C_SEL_MASK) | (((uint32_t)val) << IO_PAD60_PIOCFG_I2C_SEL_SHIFT))

#define  IO_PAD60_PIOCFG_DGTBSEL_MASK 0x1e0000
#define  IO_PAD60_PIOCFG_DGTBSEL_SHIFT 17
#define  IO_PAD60_PIOCFG_DGTBSEL_MASK_SHIFT(reg) (((reg) & IO_PAD60_PIOCFG_DGTBSEL_MASK) >> IO_PAD60_PIOCFG_DGTBSEL_SHIFT)
#define  IO_PAD60_PIOCFG_DGTBSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD60_PIOCFG_DGTBSEL_MASK) | (((uint32_t)val) << IO_PAD60_PIOCFG_DGTBSEL_SHIFT))

#define  IO_PAD60_PIOCFG_RAWSEL_MASK 0x10000
#define  IO_PAD60_PIOCFG_RAWSEL_SHIFT 16
#define  IO_PAD60_PIOCFG_RAWSEL_MASK_SHIFT(reg) (((reg) & IO_PAD60_PIOCFG_RAWSEL_MASK) >> IO_PAD60_PIOCFG_RAWSEL_SHIFT)
#define  IO_PAD60_PIOCFG_RAWSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD60_PIOCFG_RAWSEL_MASK) | (((uint32_t)val) << IO_PAD60_PIOCFG_RAWSEL_SHIFT))

#define  IO_PAD60_PIOCFG_PULL_SEL_MASK 0x8000
#define  IO_PAD60_PIOCFG_PULL_SEL_SHIFT 15
#define  IO_PAD60_PIOCFG_PULL_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD60_PIOCFG_PULL_SEL_MASK) >> IO_PAD60_PIOCFG_PULL_SEL_SHIFT)
#define  IO_PAD60_PIOCFG_PULL_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD60_PIOCFG_PULL_SEL_MASK) | (((uint32_t)val) << IO_PAD60_PIOCFG_PULL_SEL_SHIFT))

#define  IO_PAD60_PIOCFG_PUEN_MASK 0x4000
#define  IO_PAD60_PIOCFG_PUEN_SHIFT 14
#define  IO_PAD60_PIOCFG_PUEN_MASK_SHIFT(reg) (((reg) & IO_PAD60_PIOCFG_PUEN_MASK) >> IO_PAD60_PIOCFG_PUEN_SHIFT)
#define  IO_PAD60_PIOCFG_PUEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD60_PIOCFG_PUEN_MASK) | (((uint32_t)val) << IO_PAD60_PIOCFG_PUEN_SHIFT))

#define  IO_PAD60_PIOCFG_PDEN_MASK 0x2000
#define  IO_PAD60_PIOCFG_PDEN_SHIFT 13
#define  IO_PAD60_PIOCFG_PDEN_MASK_SHIFT(reg) (((reg) & IO_PAD60_PIOCFG_PDEN_MASK) >> IO_PAD60_PIOCFG_PDEN_SHIFT)
#define  IO_PAD60_PIOCFG_PDEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD60_PIOCFG_PDEN_MASK) | (((uint32_t)val) << IO_PAD60_PIOCFG_PDEN_SHIFT))

#define  IO_PAD60_PIOCFG_SR_MASK 0x1800
#define  IO_PAD60_PIOCFG_SR_SHIFT 11
#define  IO_PAD60_PIOCFG_SR_MASK_SHIFT(reg) (((reg) & IO_PAD60_PIOCFG_SR_MASK) >> IO_PAD60_PIOCFG_SR_SHIFT)
#define  IO_PAD60_PIOCFG_SR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD60_PIOCFG_SR_MASK) | (((uint32_t)val) << IO_PAD60_PIOCFG_SR_SHIFT))

#define  IO_PAD60_PIOCFG_SLP_DI_MASK 0x400
#define  IO_PAD60_PIOCFG_SLP_DI_SHIFT 10
#define  IO_PAD60_PIOCFG_SLP_DI_MASK_SHIFT(reg) (((reg) & IO_PAD60_PIOCFG_SLP_DI_MASK) >> IO_PAD60_PIOCFG_SLP_DI_SHIFT)
#define  IO_PAD60_PIOCFG_SLP_DI_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD60_PIOCFG_SLP_DI_MASK) | (((uint32_t)val) << IO_PAD60_PIOCFG_SLP_DI_SHIFT))

#define  IO_PAD60_PIOCFG_SLP_CNTRL_MASK 0x200
#define  IO_PAD60_PIOCFG_SLP_CNTRL_SHIFT 9
#define  IO_PAD60_PIOCFG_SLP_CNTRL_MASK_SHIFT(reg) (((reg) & IO_PAD60_PIOCFG_SLP_CNTRL_MASK) >> IO_PAD60_PIOCFG_SLP_CNTRL_SHIFT)
#define  IO_PAD60_PIOCFG_SLP_CNTRL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD60_PIOCFG_SLP_CNTRL_MASK) | (((uint32_t)val) << IO_PAD60_PIOCFG_SLP_CNTRL_SHIFT))

#define  IO_PAD60_PIOCFG_SLP_DO_MASK 0x100
#define  IO_PAD60_PIOCFG_SLP_DO_SHIFT 8
#define  IO_PAD60_PIOCFG_SLP_DO_MASK_SHIFT(reg) (((reg) & IO_PAD60_PIOCFG_SLP_DO_MASK) >> IO_PAD60_PIOCFG_SLP_DO_SHIFT)
#define  IO_PAD60_PIOCFG_SLP_DO_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD60_PIOCFG_SLP_DO_MASK) | (((uint32_t)val) << IO_PAD60_PIOCFG_SLP_DO_SHIFT))

#define  IO_PAD60_PIOCFG_SLP_DIR_MASK 0x80
#define  IO_PAD60_PIOCFG_SLP_DIR_SHIFT 7
#define  IO_PAD60_PIOCFG_SLP_DIR_MASK_SHIFT(reg) (((reg) & IO_PAD60_PIOCFG_SLP_DIR_MASK) >> IO_PAD60_PIOCFG_SLP_DIR_SHIFT)
#define  IO_PAD60_PIOCFG_SLP_DIR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD60_PIOCFG_SLP_DIR_MASK) | (((uint32_t)val) << IO_PAD60_PIOCFG_SLP_DIR_SHIFT))

#define  IO_PAD60_PIOCFG_EDGE_EN_N_MASK 0x40
#define  IO_PAD60_PIOCFG_EDGE_EN_N_SHIFT 6
#define  IO_PAD60_PIOCFG_EDGE_EN_N_MASK_SHIFT(reg) (((reg) & IO_PAD60_PIOCFG_EDGE_EN_N_MASK) >> IO_PAD60_PIOCFG_EDGE_EN_N_SHIFT)
#define  IO_PAD60_PIOCFG_EDGE_EN_N_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD60_PIOCFG_EDGE_EN_N_MASK) | (((uint32_t)val) << IO_PAD60_PIOCFG_EDGE_EN_N_SHIFT))

#define  IO_PAD60_PIOCFG_EDGE_FALL_EN_MASK 0x20
#define  IO_PAD60_PIOCFG_EDGE_FALL_EN_SHIFT 5
#define  IO_PAD60_PIOCFG_EDGE_FALL_EN_MASK_SHIFT(reg) (((reg) & IO_PAD60_PIOCFG_EDGE_FALL_EN_MASK) >> IO_PAD60_PIOCFG_EDGE_FALL_EN_SHIFT)
#define  IO_PAD60_PIOCFG_EDGE_FALL_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD60_PIOCFG_EDGE_FALL_EN_MASK) | (((uint32_t)val) << IO_PAD60_PIOCFG_EDGE_FALL_EN_SHIFT))

#define  IO_PAD60_PIOCFG_EDGE_RISE_EN_MASK 0x10
#define  IO_PAD60_PIOCFG_EDGE_RISE_EN_SHIFT 4
#define  IO_PAD60_PIOCFG_EDGE_RISE_EN_MASK_SHIFT(reg) (((reg) & IO_PAD60_PIOCFG_EDGE_RISE_EN_MASK) >> IO_PAD60_PIOCFG_EDGE_RISE_EN_SHIFT)
#define  IO_PAD60_PIOCFG_EDGE_RISE_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD60_PIOCFG_EDGE_RISE_EN_MASK) | (((uint32_t)val) << IO_PAD60_PIOCFG_EDGE_RISE_EN_SHIFT))

#define  IO_PAD60_PIOCFG_SLP_SEL_MASK 0x8
#define  IO_PAD60_PIOCFG_SLP_SEL_SHIFT 3
#define  IO_PAD60_PIOCFG_SLP_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD60_PIOCFG_SLP_SEL_MASK) >> IO_PAD60_PIOCFG_SLP_SEL_SHIFT)
#define  IO_PAD60_PIOCFG_SLP_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD60_PIOCFG_SLP_SEL_MASK) | (((uint32_t)val) << IO_PAD60_PIOCFG_SLP_SEL_SHIFT))

#define  IO_PAD60_PIOCFG_FUNC_SEL_MASK 0x7
#define  IO_PAD60_PIOCFG_FUNC_SEL_SHIFT 0
#define  IO_PAD60_PIOCFG_FUNC_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD60_PIOCFG_FUNC_SEL_MASK) >> IO_PAD60_PIOCFG_FUNC_SEL_SHIFT)
#define  IO_PAD60_PIOCFG_FUNC_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD60_PIOCFG_FUNC_SEL_MASK) | (((uint32_t)val) << IO_PAD60_PIOCFG_FUNC_SEL_SHIFT))

//====================================================================
//
//Register File: IO_PAD61 Configuration Registers (IO_PAD61)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

//====================================================================
//Register: IO_PAD61 Configuration Register (PIOCFG)
/** \brief "PHI_PADXDC_SRC" Pad*/
//====================================================================

#define  IO_PAD61_PIOCFG_RESERVED1_MASK 0xfc000000
#define  IO_PAD61_PIOCFG_RESERVED1_SHIFT 26
#define  IO_PAD61_PIOCFG_RESERVED1_MASK_SHIFT(reg) (((reg) & IO_PAD61_PIOCFG_RESERVED1_MASK) >> IO_PAD61_PIOCFG_RESERVED1_SHIFT)
#define  IO_PAD61_PIOCFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD61_PIOCFG_RESERVED1_MASK) | (((uint32_t)val) << IO_PAD61_PIOCFG_RESERVED1_SHIFT))

#define  IO_PAD61_PIOCFG_PD_MASK 0x2000000
#define  IO_PAD61_PIOCFG_PD_SHIFT 25
#define  IO_PAD61_PIOCFG_PD_MASK_SHIFT(reg) (((reg) & IO_PAD61_PIOCFG_PD_MASK) >> IO_PAD61_PIOCFG_PD_SHIFT)
#define  IO_PAD61_PIOCFG_PD_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD61_PIOCFG_PD_MASK) | (((uint32_t)val) << IO_PAD61_PIOCFG_PD_SHIFT))

#define  IO_PAD61_PIOCFG_ODT_EN_MASK 0x1000000
#define  IO_PAD61_PIOCFG_ODT_EN_SHIFT 24
#define  IO_PAD61_PIOCFG_ODT_EN_MASK_SHIFT(reg) (((reg) & IO_PAD61_PIOCFG_ODT_EN_MASK) >> IO_PAD61_PIOCFG_ODT_EN_SHIFT)
#define  IO_PAD61_PIOCFG_ODT_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD61_PIOCFG_ODT_EN_MASK) | (((uint32_t)val) << IO_PAD61_PIOCFG_ODT_EN_SHIFT))

#define  IO_PAD61_PIOCFG_LED_EN_MASK 0x800000
#define  IO_PAD61_PIOCFG_LED_EN_SHIFT 23
#define  IO_PAD61_PIOCFG_LED_EN_MASK_SHIFT(reg) (((reg) & IO_PAD61_PIOCFG_LED_EN_MASK) >> IO_PAD61_PIOCFG_LED_EN_SHIFT)
#define  IO_PAD61_PIOCFG_LED_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD61_PIOCFG_LED_EN_MASK) | (((uint32_t)val) << IO_PAD61_PIOCFG_LED_EN_SHIFT))

#define  IO_PAD61_PIOCFG_I2C_SEL_MASK 0x600000
#define  IO_PAD61_PIOCFG_I2C_SEL_SHIFT 21
#define  IO_PAD61_PIOCFG_I2C_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD61_PIOCFG_I2C_SEL_MASK) >> IO_PAD61_PIOCFG_I2C_SEL_SHIFT)
#define  IO_PAD61_PIOCFG_I2C_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD61_PIOCFG_I2C_SEL_MASK) | (((uint32_t)val) << IO_PAD61_PIOCFG_I2C_SEL_SHIFT))

#define  IO_PAD61_PIOCFG_DGTBSEL_MASK 0x1e0000
#define  IO_PAD61_PIOCFG_DGTBSEL_SHIFT 17
#define  IO_PAD61_PIOCFG_DGTBSEL_MASK_SHIFT(reg) (((reg) & IO_PAD61_PIOCFG_DGTBSEL_MASK) >> IO_PAD61_PIOCFG_DGTBSEL_SHIFT)
#define  IO_PAD61_PIOCFG_DGTBSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD61_PIOCFG_DGTBSEL_MASK) | (((uint32_t)val) << IO_PAD61_PIOCFG_DGTBSEL_SHIFT))

#define  IO_PAD61_PIOCFG_RAWSEL_MASK 0x10000
#define  IO_PAD61_PIOCFG_RAWSEL_SHIFT 16
#define  IO_PAD61_PIOCFG_RAWSEL_MASK_SHIFT(reg) (((reg) & IO_PAD61_PIOCFG_RAWSEL_MASK) >> IO_PAD61_PIOCFG_RAWSEL_SHIFT)
#define  IO_PAD61_PIOCFG_RAWSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD61_PIOCFG_RAWSEL_MASK) | (((uint32_t)val) << IO_PAD61_PIOCFG_RAWSEL_SHIFT))

#define  IO_PAD61_PIOCFG_PULL_SEL_MASK 0x8000
#define  IO_PAD61_PIOCFG_PULL_SEL_SHIFT 15
#define  IO_PAD61_PIOCFG_PULL_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD61_PIOCFG_PULL_SEL_MASK) >> IO_PAD61_PIOCFG_PULL_SEL_SHIFT)
#define  IO_PAD61_PIOCFG_PULL_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD61_PIOCFG_PULL_SEL_MASK) | (((uint32_t)val) << IO_PAD61_PIOCFG_PULL_SEL_SHIFT))

#define  IO_PAD61_PIOCFG_PUEN_MASK 0x4000
#define  IO_PAD61_PIOCFG_PUEN_SHIFT 14
#define  IO_PAD61_PIOCFG_PUEN_MASK_SHIFT(reg) (((reg) & IO_PAD61_PIOCFG_PUEN_MASK) >> IO_PAD61_PIOCFG_PUEN_SHIFT)
#define  IO_PAD61_PIOCFG_PUEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD61_PIOCFG_PUEN_MASK) | (((uint32_t)val) << IO_PAD61_PIOCFG_PUEN_SHIFT))

#define  IO_PAD61_PIOCFG_PDEN_MASK 0x2000
#define  IO_PAD61_PIOCFG_PDEN_SHIFT 13
#define  IO_PAD61_PIOCFG_PDEN_MASK_SHIFT(reg) (((reg) & IO_PAD61_PIOCFG_PDEN_MASK) >> IO_PAD61_PIOCFG_PDEN_SHIFT)
#define  IO_PAD61_PIOCFG_PDEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD61_PIOCFG_PDEN_MASK) | (((uint32_t)val) << IO_PAD61_PIOCFG_PDEN_SHIFT))

#define  IO_PAD61_PIOCFG_SR_MASK 0x1800
#define  IO_PAD61_PIOCFG_SR_SHIFT 11
#define  IO_PAD61_PIOCFG_SR_MASK_SHIFT(reg) (((reg) & IO_PAD61_PIOCFG_SR_MASK) >> IO_PAD61_PIOCFG_SR_SHIFT)
#define  IO_PAD61_PIOCFG_SR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD61_PIOCFG_SR_MASK) | (((uint32_t)val) << IO_PAD61_PIOCFG_SR_SHIFT))

#define  IO_PAD61_PIOCFG_SLP_DI_MASK 0x400
#define  IO_PAD61_PIOCFG_SLP_DI_SHIFT 10
#define  IO_PAD61_PIOCFG_SLP_DI_MASK_SHIFT(reg) (((reg) & IO_PAD61_PIOCFG_SLP_DI_MASK) >> IO_PAD61_PIOCFG_SLP_DI_SHIFT)
#define  IO_PAD61_PIOCFG_SLP_DI_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD61_PIOCFG_SLP_DI_MASK) | (((uint32_t)val) << IO_PAD61_PIOCFG_SLP_DI_SHIFT))

#define  IO_PAD61_PIOCFG_SLP_CNTRL_MASK 0x200
#define  IO_PAD61_PIOCFG_SLP_CNTRL_SHIFT 9
#define  IO_PAD61_PIOCFG_SLP_CNTRL_MASK_SHIFT(reg) (((reg) & IO_PAD61_PIOCFG_SLP_CNTRL_MASK) >> IO_PAD61_PIOCFG_SLP_CNTRL_SHIFT)
#define  IO_PAD61_PIOCFG_SLP_CNTRL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD61_PIOCFG_SLP_CNTRL_MASK) | (((uint32_t)val) << IO_PAD61_PIOCFG_SLP_CNTRL_SHIFT))

#define  IO_PAD61_PIOCFG_SLP_DO_MASK 0x100
#define  IO_PAD61_PIOCFG_SLP_DO_SHIFT 8
#define  IO_PAD61_PIOCFG_SLP_DO_MASK_SHIFT(reg) (((reg) & IO_PAD61_PIOCFG_SLP_DO_MASK) >> IO_PAD61_PIOCFG_SLP_DO_SHIFT)
#define  IO_PAD61_PIOCFG_SLP_DO_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD61_PIOCFG_SLP_DO_MASK) | (((uint32_t)val) << IO_PAD61_PIOCFG_SLP_DO_SHIFT))

#define  IO_PAD61_PIOCFG_SLP_DIR_MASK 0x80
#define  IO_PAD61_PIOCFG_SLP_DIR_SHIFT 7
#define  IO_PAD61_PIOCFG_SLP_DIR_MASK_SHIFT(reg) (((reg) & IO_PAD61_PIOCFG_SLP_DIR_MASK) >> IO_PAD61_PIOCFG_SLP_DIR_SHIFT)
#define  IO_PAD61_PIOCFG_SLP_DIR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD61_PIOCFG_SLP_DIR_MASK) | (((uint32_t)val) << IO_PAD61_PIOCFG_SLP_DIR_SHIFT))

#define  IO_PAD61_PIOCFG_EDGE_EN_N_MASK 0x40
#define  IO_PAD61_PIOCFG_EDGE_EN_N_SHIFT 6
#define  IO_PAD61_PIOCFG_EDGE_EN_N_MASK_SHIFT(reg) (((reg) & IO_PAD61_PIOCFG_EDGE_EN_N_MASK) >> IO_PAD61_PIOCFG_EDGE_EN_N_SHIFT)
#define  IO_PAD61_PIOCFG_EDGE_EN_N_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD61_PIOCFG_EDGE_EN_N_MASK) | (((uint32_t)val) << IO_PAD61_PIOCFG_EDGE_EN_N_SHIFT))

#define  IO_PAD61_PIOCFG_EDGE_FALL_EN_MASK 0x20
#define  IO_PAD61_PIOCFG_EDGE_FALL_EN_SHIFT 5
#define  IO_PAD61_PIOCFG_EDGE_FALL_EN_MASK_SHIFT(reg) (((reg) & IO_PAD61_PIOCFG_EDGE_FALL_EN_MASK) >> IO_PAD61_PIOCFG_EDGE_FALL_EN_SHIFT)
#define  IO_PAD61_PIOCFG_EDGE_FALL_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD61_PIOCFG_EDGE_FALL_EN_MASK) | (((uint32_t)val) << IO_PAD61_PIOCFG_EDGE_FALL_EN_SHIFT))

#define  IO_PAD61_PIOCFG_EDGE_RISE_EN_MASK 0x10
#define  IO_PAD61_PIOCFG_EDGE_RISE_EN_SHIFT 4
#define  IO_PAD61_PIOCFG_EDGE_RISE_EN_MASK_SHIFT(reg) (((reg) & IO_PAD61_PIOCFG_EDGE_RISE_EN_MASK) >> IO_PAD61_PIOCFG_EDGE_RISE_EN_SHIFT)
#define  IO_PAD61_PIOCFG_EDGE_RISE_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD61_PIOCFG_EDGE_RISE_EN_MASK) | (((uint32_t)val) << IO_PAD61_PIOCFG_EDGE_RISE_EN_SHIFT))

#define  IO_PAD61_PIOCFG_SLP_SEL_MASK 0x8
#define  IO_PAD61_PIOCFG_SLP_SEL_SHIFT 3
#define  IO_PAD61_PIOCFG_SLP_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD61_PIOCFG_SLP_SEL_MASK) >> IO_PAD61_PIOCFG_SLP_SEL_SHIFT)
#define  IO_PAD61_PIOCFG_SLP_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD61_PIOCFG_SLP_SEL_MASK) | (((uint32_t)val) << IO_PAD61_PIOCFG_SLP_SEL_SHIFT))

#define  IO_PAD61_PIOCFG_FUNC_SEL_MASK 0x7
#define  IO_PAD61_PIOCFG_FUNC_SEL_SHIFT 0
#define  IO_PAD61_PIOCFG_FUNC_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD61_PIOCFG_FUNC_SEL_MASK) >> IO_PAD61_PIOCFG_FUNC_SEL_SHIFT)
#define  IO_PAD61_PIOCFG_FUNC_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD61_PIOCFG_FUNC_SEL_MASK) | (((uint32_t)val) << IO_PAD61_PIOCFG_FUNC_SEL_SHIFT))

//====================================================================
//
//Register File: IO_PAD62 Configuration Registers (IO_PAD62)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

//====================================================================
//Register: IO_PAD62 Configuration Register (PIOCFG)
/** \brief "PHI_PADXDC_SRC" Pad*/
//====================================================================

#define  IO_PAD62_PIOCFG_RESERVED1_MASK 0xfc000000
#define  IO_PAD62_PIOCFG_RESERVED1_SHIFT 26
#define  IO_PAD62_PIOCFG_RESERVED1_MASK_SHIFT(reg) (((reg) & IO_PAD62_PIOCFG_RESERVED1_MASK) >> IO_PAD62_PIOCFG_RESERVED1_SHIFT)
#define  IO_PAD62_PIOCFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD62_PIOCFG_RESERVED1_MASK) | (((uint32_t)val) << IO_PAD62_PIOCFG_RESERVED1_SHIFT))

#define  IO_PAD62_PIOCFG_PD_MASK 0x2000000
#define  IO_PAD62_PIOCFG_PD_SHIFT 25
#define  IO_PAD62_PIOCFG_PD_MASK_SHIFT(reg) (((reg) & IO_PAD62_PIOCFG_PD_MASK) >> IO_PAD62_PIOCFG_PD_SHIFT)
#define  IO_PAD62_PIOCFG_PD_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD62_PIOCFG_PD_MASK) | (((uint32_t)val) << IO_PAD62_PIOCFG_PD_SHIFT))

#define  IO_PAD62_PIOCFG_ODT_EN_MASK 0x1000000
#define  IO_PAD62_PIOCFG_ODT_EN_SHIFT 24
#define  IO_PAD62_PIOCFG_ODT_EN_MASK_SHIFT(reg) (((reg) & IO_PAD62_PIOCFG_ODT_EN_MASK) >> IO_PAD62_PIOCFG_ODT_EN_SHIFT)
#define  IO_PAD62_PIOCFG_ODT_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD62_PIOCFG_ODT_EN_MASK) | (((uint32_t)val) << IO_PAD62_PIOCFG_ODT_EN_SHIFT))

#define  IO_PAD62_PIOCFG_LED_EN_MASK 0x800000
#define  IO_PAD62_PIOCFG_LED_EN_SHIFT 23
#define  IO_PAD62_PIOCFG_LED_EN_MASK_SHIFT(reg) (((reg) & IO_PAD62_PIOCFG_LED_EN_MASK) >> IO_PAD62_PIOCFG_LED_EN_SHIFT)
#define  IO_PAD62_PIOCFG_LED_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD62_PIOCFG_LED_EN_MASK) | (((uint32_t)val) << IO_PAD62_PIOCFG_LED_EN_SHIFT))

#define  IO_PAD62_PIOCFG_I2C_SEL_MASK 0x600000
#define  IO_PAD62_PIOCFG_I2C_SEL_SHIFT 21
#define  IO_PAD62_PIOCFG_I2C_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD62_PIOCFG_I2C_SEL_MASK) >> IO_PAD62_PIOCFG_I2C_SEL_SHIFT)
#define  IO_PAD62_PIOCFG_I2C_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD62_PIOCFG_I2C_SEL_MASK) | (((uint32_t)val) << IO_PAD62_PIOCFG_I2C_SEL_SHIFT))

#define  IO_PAD62_PIOCFG_DGTBSEL_MASK 0x1e0000
#define  IO_PAD62_PIOCFG_DGTBSEL_SHIFT 17
#define  IO_PAD62_PIOCFG_DGTBSEL_MASK_SHIFT(reg) (((reg) & IO_PAD62_PIOCFG_DGTBSEL_MASK) >> IO_PAD62_PIOCFG_DGTBSEL_SHIFT)
#define  IO_PAD62_PIOCFG_DGTBSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD62_PIOCFG_DGTBSEL_MASK) | (((uint32_t)val) << IO_PAD62_PIOCFG_DGTBSEL_SHIFT))

#define  IO_PAD62_PIOCFG_RAWSEL_MASK 0x10000
#define  IO_PAD62_PIOCFG_RAWSEL_SHIFT 16
#define  IO_PAD62_PIOCFG_RAWSEL_MASK_SHIFT(reg) (((reg) & IO_PAD62_PIOCFG_RAWSEL_MASK) >> IO_PAD62_PIOCFG_RAWSEL_SHIFT)
#define  IO_PAD62_PIOCFG_RAWSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD62_PIOCFG_RAWSEL_MASK) | (((uint32_t)val) << IO_PAD62_PIOCFG_RAWSEL_SHIFT))

#define  IO_PAD62_PIOCFG_PULL_SEL_MASK 0x8000
#define  IO_PAD62_PIOCFG_PULL_SEL_SHIFT 15
#define  IO_PAD62_PIOCFG_PULL_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD62_PIOCFG_PULL_SEL_MASK) >> IO_PAD62_PIOCFG_PULL_SEL_SHIFT)
#define  IO_PAD62_PIOCFG_PULL_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD62_PIOCFG_PULL_SEL_MASK) | (((uint32_t)val) << IO_PAD62_PIOCFG_PULL_SEL_SHIFT))

#define  IO_PAD62_PIOCFG_PUEN_MASK 0x4000
#define  IO_PAD62_PIOCFG_PUEN_SHIFT 14
#define  IO_PAD62_PIOCFG_PUEN_MASK_SHIFT(reg) (((reg) & IO_PAD62_PIOCFG_PUEN_MASK) >> IO_PAD62_PIOCFG_PUEN_SHIFT)
#define  IO_PAD62_PIOCFG_PUEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD62_PIOCFG_PUEN_MASK) | (((uint32_t)val) << IO_PAD62_PIOCFG_PUEN_SHIFT))

#define  IO_PAD62_PIOCFG_PDEN_MASK 0x2000
#define  IO_PAD62_PIOCFG_PDEN_SHIFT 13
#define  IO_PAD62_PIOCFG_PDEN_MASK_SHIFT(reg) (((reg) & IO_PAD62_PIOCFG_PDEN_MASK) >> IO_PAD62_PIOCFG_PDEN_SHIFT)
#define  IO_PAD62_PIOCFG_PDEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD62_PIOCFG_PDEN_MASK) | (((uint32_t)val) << IO_PAD62_PIOCFG_PDEN_SHIFT))

#define  IO_PAD62_PIOCFG_SR_MASK 0x1800
#define  IO_PAD62_PIOCFG_SR_SHIFT 11
#define  IO_PAD62_PIOCFG_SR_MASK_SHIFT(reg) (((reg) & IO_PAD62_PIOCFG_SR_MASK) >> IO_PAD62_PIOCFG_SR_SHIFT)
#define  IO_PAD62_PIOCFG_SR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD62_PIOCFG_SR_MASK) | (((uint32_t)val) << IO_PAD62_PIOCFG_SR_SHIFT))

#define  IO_PAD62_PIOCFG_SLP_DI_MASK 0x400
#define  IO_PAD62_PIOCFG_SLP_DI_SHIFT 10
#define  IO_PAD62_PIOCFG_SLP_DI_MASK_SHIFT(reg) (((reg) & IO_PAD62_PIOCFG_SLP_DI_MASK) >> IO_PAD62_PIOCFG_SLP_DI_SHIFT)
#define  IO_PAD62_PIOCFG_SLP_DI_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD62_PIOCFG_SLP_DI_MASK) | (((uint32_t)val) << IO_PAD62_PIOCFG_SLP_DI_SHIFT))

#define  IO_PAD62_PIOCFG_SLP_CNTRL_MASK 0x200
#define  IO_PAD62_PIOCFG_SLP_CNTRL_SHIFT 9
#define  IO_PAD62_PIOCFG_SLP_CNTRL_MASK_SHIFT(reg) (((reg) & IO_PAD62_PIOCFG_SLP_CNTRL_MASK) >> IO_PAD62_PIOCFG_SLP_CNTRL_SHIFT)
#define  IO_PAD62_PIOCFG_SLP_CNTRL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD62_PIOCFG_SLP_CNTRL_MASK) | (((uint32_t)val) << IO_PAD62_PIOCFG_SLP_CNTRL_SHIFT))

#define  IO_PAD62_PIOCFG_SLP_DO_MASK 0x100
#define  IO_PAD62_PIOCFG_SLP_DO_SHIFT 8
#define  IO_PAD62_PIOCFG_SLP_DO_MASK_SHIFT(reg) (((reg) & IO_PAD62_PIOCFG_SLP_DO_MASK) >> IO_PAD62_PIOCFG_SLP_DO_SHIFT)
#define  IO_PAD62_PIOCFG_SLP_DO_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD62_PIOCFG_SLP_DO_MASK) | (((uint32_t)val) << IO_PAD62_PIOCFG_SLP_DO_SHIFT))

#define  IO_PAD62_PIOCFG_SLP_DIR_MASK 0x80
#define  IO_PAD62_PIOCFG_SLP_DIR_SHIFT 7
#define  IO_PAD62_PIOCFG_SLP_DIR_MASK_SHIFT(reg) (((reg) & IO_PAD62_PIOCFG_SLP_DIR_MASK) >> IO_PAD62_PIOCFG_SLP_DIR_SHIFT)
#define  IO_PAD62_PIOCFG_SLP_DIR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD62_PIOCFG_SLP_DIR_MASK) | (((uint32_t)val) << IO_PAD62_PIOCFG_SLP_DIR_SHIFT))

#define  IO_PAD62_PIOCFG_EDGE_EN_N_MASK 0x40
#define  IO_PAD62_PIOCFG_EDGE_EN_N_SHIFT 6
#define  IO_PAD62_PIOCFG_EDGE_EN_N_MASK_SHIFT(reg) (((reg) & IO_PAD62_PIOCFG_EDGE_EN_N_MASK) >> IO_PAD62_PIOCFG_EDGE_EN_N_SHIFT)
#define  IO_PAD62_PIOCFG_EDGE_EN_N_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD62_PIOCFG_EDGE_EN_N_MASK) | (((uint32_t)val) << IO_PAD62_PIOCFG_EDGE_EN_N_SHIFT))

#define  IO_PAD62_PIOCFG_EDGE_FALL_EN_MASK 0x20
#define  IO_PAD62_PIOCFG_EDGE_FALL_EN_SHIFT 5
#define  IO_PAD62_PIOCFG_EDGE_FALL_EN_MASK_SHIFT(reg) (((reg) & IO_PAD62_PIOCFG_EDGE_FALL_EN_MASK) >> IO_PAD62_PIOCFG_EDGE_FALL_EN_SHIFT)
#define  IO_PAD62_PIOCFG_EDGE_FALL_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD62_PIOCFG_EDGE_FALL_EN_MASK) | (((uint32_t)val) << IO_PAD62_PIOCFG_EDGE_FALL_EN_SHIFT))

#define  IO_PAD62_PIOCFG_EDGE_RISE_EN_MASK 0x10
#define  IO_PAD62_PIOCFG_EDGE_RISE_EN_SHIFT 4
#define  IO_PAD62_PIOCFG_EDGE_RISE_EN_MASK_SHIFT(reg) (((reg) & IO_PAD62_PIOCFG_EDGE_RISE_EN_MASK) >> IO_PAD62_PIOCFG_EDGE_RISE_EN_SHIFT)
#define  IO_PAD62_PIOCFG_EDGE_RISE_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD62_PIOCFG_EDGE_RISE_EN_MASK) | (((uint32_t)val) << IO_PAD62_PIOCFG_EDGE_RISE_EN_SHIFT))

#define  IO_PAD62_PIOCFG_SLP_SEL_MASK 0x8
#define  IO_PAD62_PIOCFG_SLP_SEL_SHIFT 3
#define  IO_PAD62_PIOCFG_SLP_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD62_PIOCFG_SLP_SEL_MASK) >> IO_PAD62_PIOCFG_SLP_SEL_SHIFT)
#define  IO_PAD62_PIOCFG_SLP_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD62_PIOCFG_SLP_SEL_MASK) | (((uint32_t)val) << IO_PAD62_PIOCFG_SLP_SEL_SHIFT))

#define  IO_PAD62_PIOCFG_FUNC_SEL_MASK 0x7
#define  IO_PAD62_PIOCFG_FUNC_SEL_SHIFT 0
#define  IO_PAD62_PIOCFG_FUNC_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD62_PIOCFG_FUNC_SEL_MASK) >> IO_PAD62_PIOCFG_FUNC_SEL_SHIFT)
#define  IO_PAD62_PIOCFG_FUNC_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD62_PIOCFG_FUNC_SEL_MASK) | (((uint32_t)val) << IO_PAD62_PIOCFG_FUNC_SEL_SHIFT))

//====================================================================
//
//Register File: IO_PAD63 Configuration Registers (IO_PAD63)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

//====================================================================
//Register: IO_PAD63 Configuration Register (PIOCFG)
/** \brief "PHI_PADXDC_SRC" Pad*/
//====================================================================

#define  IO_PAD63_PIOCFG_RESERVED1_MASK 0xfc000000
#define  IO_PAD63_PIOCFG_RESERVED1_SHIFT 26
#define  IO_PAD63_PIOCFG_RESERVED1_MASK_SHIFT(reg) (((reg) & IO_PAD63_PIOCFG_RESERVED1_MASK) >> IO_PAD63_PIOCFG_RESERVED1_SHIFT)
#define  IO_PAD63_PIOCFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD63_PIOCFG_RESERVED1_MASK) | (((uint32_t)val) << IO_PAD63_PIOCFG_RESERVED1_SHIFT))

#define  IO_PAD63_PIOCFG_PD_MASK 0x2000000
#define  IO_PAD63_PIOCFG_PD_SHIFT 25
#define  IO_PAD63_PIOCFG_PD_MASK_SHIFT(reg) (((reg) & IO_PAD63_PIOCFG_PD_MASK) >> IO_PAD63_PIOCFG_PD_SHIFT)
#define  IO_PAD63_PIOCFG_PD_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD63_PIOCFG_PD_MASK) | (((uint32_t)val) << IO_PAD63_PIOCFG_PD_SHIFT))

#define  IO_PAD63_PIOCFG_ODT_EN_MASK 0x1000000
#define  IO_PAD63_PIOCFG_ODT_EN_SHIFT 24
#define  IO_PAD63_PIOCFG_ODT_EN_MASK_SHIFT(reg) (((reg) & IO_PAD63_PIOCFG_ODT_EN_MASK) >> IO_PAD63_PIOCFG_ODT_EN_SHIFT)
#define  IO_PAD63_PIOCFG_ODT_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD63_PIOCFG_ODT_EN_MASK) | (((uint32_t)val) << IO_PAD63_PIOCFG_ODT_EN_SHIFT))

#define  IO_PAD63_PIOCFG_LED_EN_MASK 0x800000
#define  IO_PAD63_PIOCFG_LED_EN_SHIFT 23
#define  IO_PAD63_PIOCFG_LED_EN_MASK_SHIFT(reg) (((reg) & IO_PAD63_PIOCFG_LED_EN_MASK) >> IO_PAD63_PIOCFG_LED_EN_SHIFT)
#define  IO_PAD63_PIOCFG_LED_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD63_PIOCFG_LED_EN_MASK) | (((uint32_t)val) << IO_PAD63_PIOCFG_LED_EN_SHIFT))

#define  IO_PAD63_PIOCFG_I2C_SEL_MASK 0x600000
#define  IO_PAD63_PIOCFG_I2C_SEL_SHIFT 21
#define  IO_PAD63_PIOCFG_I2C_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD63_PIOCFG_I2C_SEL_MASK) >> IO_PAD63_PIOCFG_I2C_SEL_SHIFT)
#define  IO_PAD63_PIOCFG_I2C_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD63_PIOCFG_I2C_SEL_MASK) | (((uint32_t)val) << IO_PAD63_PIOCFG_I2C_SEL_SHIFT))

#define  IO_PAD63_PIOCFG_DGTBSEL_MASK 0x1e0000
#define  IO_PAD63_PIOCFG_DGTBSEL_SHIFT 17
#define  IO_PAD63_PIOCFG_DGTBSEL_MASK_SHIFT(reg) (((reg) & IO_PAD63_PIOCFG_DGTBSEL_MASK) >> IO_PAD63_PIOCFG_DGTBSEL_SHIFT)
#define  IO_PAD63_PIOCFG_DGTBSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD63_PIOCFG_DGTBSEL_MASK) | (((uint32_t)val) << IO_PAD63_PIOCFG_DGTBSEL_SHIFT))

#define  IO_PAD63_PIOCFG_RAWSEL_MASK 0x10000
#define  IO_PAD63_PIOCFG_RAWSEL_SHIFT 16
#define  IO_PAD63_PIOCFG_RAWSEL_MASK_SHIFT(reg) (((reg) & IO_PAD63_PIOCFG_RAWSEL_MASK) >> IO_PAD63_PIOCFG_RAWSEL_SHIFT)
#define  IO_PAD63_PIOCFG_RAWSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD63_PIOCFG_RAWSEL_MASK) | (((uint32_t)val) << IO_PAD63_PIOCFG_RAWSEL_SHIFT))

#define  IO_PAD63_PIOCFG_PULL_SEL_MASK 0x8000
#define  IO_PAD63_PIOCFG_PULL_SEL_SHIFT 15
#define  IO_PAD63_PIOCFG_PULL_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD63_PIOCFG_PULL_SEL_MASK) >> IO_PAD63_PIOCFG_PULL_SEL_SHIFT)
#define  IO_PAD63_PIOCFG_PULL_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD63_PIOCFG_PULL_SEL_MASK) | (((uint32_t)val) << IO_PAD63_PIOCFG_PULL_SEL_SHIFT))

#define  IO_PAD63_PIOCFG_PUEN_MASK 0x4000
#define  IO_PAD63_PIOCFG_PUEN_SHIFT 14
#define  IO_PAD63_PIOCFG_PUEN_MASK_SHIFT(reg) (((reg) & IO_PAD63_PIOCFG_PUEN_MASK) >> IO_PAD63_PIOCFG_PUEN_SHIFT)
#define  IO_PAD63_PIOCFG_PUEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD63_PIOCFG_PUEN_MASK) | (((uint32_t)val) << IO_PAD63_PIOCFG_PUEN_SHIFT))

#define  IO_PAD63_PIOCFG_PDEN_MASK 0x2000
#define  IO_PAD63_PIOCFG_PDEN_SHIFT 13
#define  IO_PAD63_PIOCFG_PDEN_MASK_SHIFT(reg) (((reg) & IO_PAD63_PIOCFG_PDEN_MASK) >> IO_PAD63_PIOCFG_PDEN_SHIFT)
#define  IO_PAD63_PIOCFG_PDEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD63_PIOCFG_PDEN_MASK) | (((uint32_t)val) << IO_PAD63_PIOCFG_PDEN_SHIFT))

#define  IO_PAD63_PIOCFG_SR_MASK 0x1800
#define  IO_PAD63_PIOCFG_SR_SHIFT 11
#define  IO_PAD63_PIOCFG_SR_MASK_SHIFT(reg) (((reg) & IO_PAD63_PIOCFG_SR_MASK) >> IO_PAD63_PIOCFG_SR_SHIFT)
#define  IO_PAD63_PIOCFG_SR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD63_PIOCFG_SR_MASK) | (((uint32_t)val) << IO_PAD63_PIOCFG_SR_SHIFT))

#define  IO_PAD63_PIOCFG_SLP_DI_MASK 0x400
#define  IO_PAD63_PIOCFG_SLP_DI_SHIFT 10
#define  IO_PAD63_PIOCFG_SLP_DI_MASK_SHIFT(reg) (((reg) & IO_PAD63_PIOCFG_SLP_DI_MASK) >> IO_PAD63_PIOCFG_SLP_DI_SHIFT)
#define  IO_PAD63_PIOCFG_SLP_DI_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD63_PIOCFG_SLP_DI_MASK) | (((uint32_t)val) << IO_PAD63_PIOCFG_SLP_DI_SHIFT))

#define  IO_PAD63_PIOCFG_SLP_CNTRL_MASK 0x200
#define  IO_PAD63_PIOCFG_SLP_CNTRL_SHIFT 9
#define  IO_PAD63_PIOCFG_SLP_CNTRL_MASK_SHIFT(reg) (((reg) & IO_PAD63_PIOCFG_SLP_CNTRL_MASK) >> IO_PAD63_PIOCFG_SLP_CNTRL_SHIFT)
#define  IO_PAD63_PIOCFG_SLP_CNTRL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD63_PIOCFG_SLP_CNTRL_MASK) | (((uint32_t)val) << IO_PAD63_PIOCFG_SLP_CNTRL_SHIFT))

#define  IO_PAD63_PIOCFG_SLP_DO_MASK 0x100
#define  IO_PAD63_PIOCFG_SLP_DO_SHIFT 8
#define  IO_PAD63_PIOCFG_SLP_DO_MASK_SHIFT(reg) (((reg) & IO_PAD63_PIOCFG_SLP_DO_MASK) >> IO_PAD63_PIOCFG_SLP_DO_SHIFT)
#define  IO_PAD63_PIOCFG_SLP_DO_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD63_PIOCFG_SLP_DO_MASK) | (((uint32_t)val) << IO_PAD63_PIOCFG_SLP_DO_SHIFT))

#define  IO_PAD63_PIOCFG_SLP_DIR_MASK 0x80
#define  IO_PAD63_PIOCFG_SLP_DIR_SHIFT 7
#define  IO_PAD63_PIOCFG_SLP_DIR_MASK_SHIFT(reg) (((reg) & IO_PAD63_PIOCFG_SLP_DIR_MASK) >> IO_PAD63_PIOCFG_SLP_DIR_SHIFT)
#define  IO_PAD63_PIOCFG_SLP_DIR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD63_PIOCFG_SLP_DIR_MASK) | (((uint32_t)val) << IO_PAD63_PIOCFG_SLP_DIR_SHIFT))

#define  IO_PAD63_PIOCFG_EDGE_EN_N_MASK 0x40
#define  IO_PAD63_PIOCFG_EDGE_EN_N_SHIFT 6
#define  IO_PAD63_PIOCFG_EDGE_EN_N_MASK_SHIFT(reg) (((reg) & IO_PAD63_PIOCFG_EDGE_EN_N_MASK) >> IO_PAD63_PIOCFG_EDGE_EN_N_SHIFT)
#define  IO_PAD63_PIOCFG_EDGE_EN_N_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD63_PIOCFG_EDGE_EN_N_MASK) | (((uint32_t)val) << IO_PAD63_PIOCFG_EDGE_EN_N_SHIFT))

#define  IO_PAD63_PIOCFG_EDGE_FALL_EN_MASK 0x20
#define  IO_PAD63_PIOCFG_EDGE_FALL_EN_SHIFT 5
#define  IO_PAD63_PIOCFG_EDGE_FALL_EN_MASK_SHIFT(reg) (((reg) & IO_PAD63_PIOCFG_EDGE_FALL_EN_MASK) >> IO_PAD63_PIOCFG_EDGE_FALL_EN_SHIFT)
#define  IO_PAD63_PIOCFG_EDGE_FALL_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD63_PIOCFG_EDGE_FALL_EN_MASK) | (((uint32_t)val) << IO_PAD63_PIOCFG_EDGE_FALL_EN_SHIFT))

#define  IO_PAD63_PIOCFG_EDGE_RISE_EN_MASK 0x10
#define  IO_PAD63_PIOCFG_EDGE_RISE_EN_SHIFT 4
#define  IO_PAD63_PIOCFG_EDGE_RISE_EN_MASK_SHIFT(reg) (((reg) & IO_PAD63_PIOCFG_EDGE_RISE_EN_MASK) >> IO_PAD63_PIOCFG_EDGE_RISE_EN_SHIFT)
#define  IO_PAD63_PIOCFG_EDGE_RISE_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD63_PIOCFG_EDGE_RISE_EN_MASK) | (((uint32_t)val) << IO_PAD63_PIOCFG_EDGE_RISE_EN_SHIFT))

#define  IO_PAD63_PIOCFG_SLP_SEL_MASK 0x8
#define  IO_PAD63_PIOCFG_SLP_SEL_SHIFT 3
#define  IO_PAD63_PIOCFG_SLP_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD63_PIOCFG_SLP_SEL_MASK) >> IO_PAD63_PIOCFG_SLP_SEL_SHIFT)
#define  IO_PAD63_PIOCFG_SLP_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD63_PIOCFG_SLP_SEL_MASK) | (((uint32_t)val) << IO_PAD63_PIOCFG_SLP_SEL_SHIFT))

#define  IO_PAD63_PIOCFG_FUNC_SEL_MASK 0x7
#define  IO_PAD63_PIOCFG_FUNC_SEL_SHIFT 0
#define  IO_PAD63_PIOCFG_FUNC_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD63_PIOCFG_FUNC_SEL_MASK) >> IO_PAD63_PIOCFG_FUNC_SEL_SHIFT)
#define  IO_PAD63_PIOCFG_FUNC_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD63_PIOCFG_FUNC_SEL_MASK) | (((uint32_t)val) << IO_PAD63_PIOCFG_FUNC_SEL_SHIFT))

//====================================================================
//
//Register File: IO_PAD64 Configuration Registers (IO_PAD64)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

//====================================================================
//Register: IO_PAD64 Configuration Register (PIOCFG)
/** \brief "PHI_PADXDC_SRC" Pad*/
//====================================================================

#define  IO_PAD64_PIOCFG_RESERVED1_MASK 0xfc000000
#define  IO_PAD64_PIOCFG_RESERVED1_SHIFT 26
#define  IO_PAD64_PIOCFG_RESERVED1_MASK_SHIFT(reg) (((reg) & IO_PAD64_PIOCFG_RESERVED1_MASK) >> IO_PAD64_PIOCFG_RESERVED1_SHIFT)
#define  IO_PAD64_PIOCFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD64_PIOCFG_RESERVED1_MASK) | (((uint32_t)val) << IO_PAD64_PIOCFG_RESERVED1_SHIFT))

#define  IO_PAD64_PIOCFG_PD_MASK 0x2000000
#define  IO_PAD64_PIOCFG_PD_SHIFT 25
#define  IO_PAD64_PIOCFG_PD_MASK_SHIFT(reg) (((reg) & IO_PAD64_PIOCFG_PD_MASK) >> IO_PAD64_PIOCFG_PD_SHIFT)
#define  IO_PAD64_PIOCFG_PD_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD64_PIOCFG_PD_MASK) | (((uint32_t)val) << IO_PAD64_PIOCFG_PD_SHIFT))

#define  IO_PAD64_PIOCFG_ODT_EN_MASK 0x1000000
#define  IO_PAD64_PIOCFG_ODT_EN_SHIFT 24
#define  IO_PAD64_PIOCFG_ODT_EN_MASK_SHIFT(reg) (((reg) & IO_PAD64_PIOCFG_ODT_EN_MASK) >> IO_PAD64_PIOCFG_ODT_EN_SHIFT)
#define  IO_PAD64_PIOCFG_ODT_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD64_PIOCFG_ODT_EN_MASK) | (((uint32_t)val) << IO_PAD64_PIOCFG_ODT_EN_SHIFT))

#define  IO_PAD64_PIOCFG_LED_EN_MASK 0x800000
#define  IO_PAD64_PIOCFG_LED_EN_SHIFT 23
#define  IO_PAD64_PIOCFG_LED_EN_MASK_SHIFT(reg) (((reg) & IO_PAD64_PIOCFG_LED_EN_MASK) >> IO_PAD64_PIOCFG_LED_EN_SHIFT)
#define  IO_PAD64_PIOCFG_LED_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD64_PIOCFG_LED_EN_MASK) | (((uint32_t)val) << IO_PAD64_PIOCFG_LED_EN_SHIFT))

#define  IO_PAD64_PIOCFG_I2C_SEL_MASK 0x600000
#define  IO_PAD64_PIOCFG_I2C_SEL_SHIFT 21
#define  IO_PAD64_PIOCFG_I2C_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD64_PIOCFG_I2C_SEL_MASK) >> IO_PAD64_PIOCFG_I2C_SEL_SHIFT)
#define  IO_PAD64_PIOCFG_I2C_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD64_PIOCFG_I2C_SEL_MASK) | (((uint32_t)val) << IO_PAD64_PIOCFG_I2C_SEL_SHIFT))

#define  IO_PAD64_PIOCFG_DGTBSEL_MASK 0x1e0000
#define  IO_PAD64_PIOCFG_DGTBSEL_SHIFT 17
#define  IO_PAD64_PIOCFG_DGTBSEL_MASK_SHIFT(reg) (((reg) & IO_PAD64_PIOCFG_DGTBSEL_MASK) >> IO_PAD64_PIOCFG_DGTBSEL_SHIFT)
#define  IO_PAD64_PIOCFG_DGTBSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD64_PIOCFG_DGTBSEL_MASK) | (((uint32_t)val) << IO_PAD64_PIOCFG_DGTBSEL_SHIFT))

#define  IO_PAD64_PIOCFG_RAWSEL_MASK 0x10000
#define  IO_PAD64_PIOCFG_RAWSEL_SHIFT 16
#define  IO_PAD64_PIOCFG_RAWSEL_MASK_SHIFT(reg) (((reg) & IO_PAD64_PIOCFG_RAWSEL_MASK) >> IO_PAD64_PIOCFG_RAWSEL_SHIFT)
#define  IO_PAD64_PIOCFG_RAWSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD64_PIOCFG_RAWSEL_MASK) | (((uint32_t)val) << IO_PAD64_PIOCFG_RAWSEL_SHIFT))

#define  IO_PAD64_PIOCFG_PULL_SEL_MASK 0x8000
#define  IO_PAD64_PIOCFG_PULL_SEL_SHIFT 15
#define  IO_PAD64_PIOCFG_PULL_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD64_PIOCFG_PULL_SEL_MASK) >> IO_PAD64_PIOCFG_PULL_SEL_SHIFT)
#define  IO_PAD64_PIOCFG_PULL_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD64_PIOCFG_PULL_SEL_MASK) | (((uint32_t)val) << IO_PAD64_PIOCFG_PULL_SEL_SHIFT))

#define  IO_PAD64_PIOCFG_PUEN_MASK 0x4000
#define  IO_PAD64_PIOCFG_PUEN_SHIFT 14
#define  IO_PAD64_PIOCFG_PUEN_MASK_SHIFT(reg) (((reg) & IO_PAD64_PIOCFG_PUEN_MASK) >> IO_PAD64_PIOCFG_PUEN_SHIFT)
#define  IO_PAD64_PIOCFG_PUEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD64_PIOCFG_PUEN_MASK) | (((uint32_t)val) << IO_PAD64_PIOCFG_PUEN_SHIFT))

#define  IO_PAD64_PIOCFG_PDEN_MASK 0x2000
#define  IO_PAD64_PIOCFG_PDEN_SHIFT 13
#define  IO_PAD64_PIOCFG_PDEN_MASK_SHIFT(reg) (((reg) & IO_PAD64_PIOCFG_PDEN_MASK) >> IO_PAD64_PIOCFG_PDEN_SHIFT)
#define  IO_PAD64_PIOCFG_PDEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD64_PIOCFG_PDEN_MASK) | (((uint32_t)val) << IO_PAD64_PIOCFG_PDEN_SHIFT))

#define  IO_PAD64_PIOCFG_SR_MASK 0x1800
#define  IO_PAD64_PIOCFG_SR_SHIFT 11
#define  IO_PAD64_PIOCFG_SR_MASK_SHIFT(reg) (((reg) & IO_PAD64_PIOCFG_SR_MASK) >> IO_PAD64_PIOCFG_SR_SHIFT)
#define  IO_PAD64_PIOCFG_SR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD64_PIOCFG_SR_MASK) | (((uint32_t)val) << IO_PAD64_PIOCFG_SR_SHIFT))

#define  IO_PAD64_PIOCFG_SLP_DI_MASK 0x400
#define  IO_PAD64_PIOCFG_SLP_DI_SHIFT 10
#define  IO_PAD64_PIOCFG_SLP_DI_MASK_SHIFT(reg) (((reg) & IO_PAD64_PIOCFG_SLP_DI_MASK) >> IO_PAD64_PIOCFG_SLP_DI_SHIFT)
#define  IO_PAD64_PIOCFG_SLP_DI_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD64_PIOCFG_SLP_DI_MASK) | (((uint32_t)val) << IO_PAD64_PIOCFG_SLP_DI_SHIFT))

#define  IO_PAD64_PIOCFG_SLP_CNTRL_MASK 0x200
#define  IO_PAD64_PIOCFG_SLP_CNTRL_SHIFT 9
#define  IO_PAD64_PIOCFG_SLP_CNTRL_MASK_SHIFT(reg) (((reg) & IO_PAD64_PIOCFG_SLP_CNTRL_MASK) >> IO_PAD64_PIOCFG_SLP_CNTRL_SHIFT)
#define  IO_PAD64_PIOCFG_SLP_CNTRL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD64_PIOCFG_SLP_CNTRL_MASK) | (((uint32_t)val) << IO_PAD64_PIOCFG_SLP_CNTRL_SHIFT))

#define  IO_PAD64_PIOCFG_SLP_DO_MASK 0x100
#define  IO_PAD64_PIOCFG_SLP_DO_SHIFT 8
#define  IO_PAD64_PIOCFG_SLP_DO_MASK_SHIFT(reg) (((reg) & IO_PAD64_PIOCFG_SLP_DO_MASK) >> IO_PAD64_PIOCFG_SLP_DO_SHIFT)
#define  IO_PAD64_PIOCFG_SLP_DO_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD64_PIOCFG_SLP_DO_MASK) | (((uint32_t)val) << IO_PAD64_PIOCFG_SLP_DO_SHIFT))

#define  IO_PAD64_PIOCFG_SLP_DIR_MASK 0x80
#define  IO_PAD64_PIOCFG_SLP_DIR_SHIFT 7
#define  IO_PAD64_PIOCFG_SLP_DIR_MASK_SHIFT(reg) (((reg) & IO_PAD64_PIOCFG_SLP_DIR_MASK) >> IO_PAD64_PIOCFG_SLP_DIR_SHIFT)
#define  IO_PAD64_PIOCFG_SLP_DIR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD64_PIOCFG_SLP_DIR_MASK) | (((uint32_t)val) << IO_PAD64_PIOCFG_SLP_DIR_SHIFT))

#define  IO_PAD64_PIOCFG_EDGE_EN_N_MASK 0x40
#define  IO_PAD64_PIOCFG_EDGE_EN_N_SHIFT 6
#define  IO_PAD64_PIOCFG_EDGE_EN_N_MASK_SHIFT(reg) (((reg) & IO_PAD64_PIOCFG_EDGE_EN_N_MASK) >> IO_PAD64_PIOCFG_EDGE_EN_N_SHIFT)
#define  IO_PAD64_PIOCFG_EDGE_EN_N_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD64_PIOCFG_EDGE_EN_N_MASK) | (((uint32_t)val) << IO_PAD64_PIOCFG_EDGE_EN_N_SHIFT))

#define  IO_PAD64_PIOCFG_EDGE_FALL_EN_MASK 0x20
#define  IO_PAD64_PIOCFG_EDGE_FALL_EN_SHIFT 5
#define  IO_PAD64_PIOCFG_EDGE_FALL_EN_MASK_SHIFT(reg) (((reg) & IO_PAD64_PIOCFG_EDGE_FALL_EN_MASK) >> IO_PAD64_PIOCFG_EDGE_FALL_EN_SHIFT)
#define  IO_PAD64_PIOCFG_EDGE_FALL_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD64_PIOCFG_EDGE_FALL_EN_MASK) | (((uint32_t)val) << IO_PAD64_PIOCFG_EDGE_FALL_EN_SHIFT))

#define  IO_PAD64_PIOCFG_EDGE_RISE_EN_MASK 0x10
#define  IO_PAD64_PIOCFG_EDGE_RISE_EN_SHIFT 4
#define  IO_PAD64_PIOCFG_EDGE_RISE_EN_MASK_SHIFT(reg) (((reg) & IO_PAD64_PIOCFG_EDGE_RISE_EN_MASK) >> IO_PAD64_PIOCFG_EDGE_RISE_EN_SHIFT)
#define  IO_PAD64_PIOCFG_EDGE_RISE_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD64_PIOCFG_EDGE_RISE_EN_MASK) | (((uint32_t)val) << IO_PAD64_PIOCFG_EDGE_RISE_EN_SHIFT))

#define  IO_PAD64_PIOCFG_SLP_SEL_MASK 0x8
#define  IO_PAD64_PIOCFG_SLP_SEL_SHIFT 3
#define  IO_PAD64_PIOCFG_SLP_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD64_PIOCFG_SLP_SEL_MASK) >> IO_PAD64_PIOCFG_SLP_SEL_SHIFT)
#define  IO_PAD64_PIOCFG_SLP_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD64_PIOCFG_SLP_SEL_MASK) | (((uint32_t)val) << IO_PAD64_PIOCFG_SLP_SEL_SHIFT))

#define  IO_PAD64_PIOCFG_FUNC_SEL_MASK 0x7
#define  IO_PAD64_PIOCFG_FUNC_SEL_SHIFT 0
#define  IO_PAD64_PIOCFG_FUNC_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD64_PIOCFG_FUNC_SEL_MASK) >> IO_PAD64_PIOCFG_FUNC_SEL_SHIFT)
#define  IO_PAD64_PIOCFG_FUNC_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD64_PIOCFG_FUNC_SEL_MASK) | (((uint32_t)val) << IO_PAD64_PIOCFG_FUNC_SEL_SHIFT))

//====================================================================
//
//Register File: IO_PAD65 Configuration Registers (IO_PAD65)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

//====================================================================
//Register: IO_PAD65 Configuration Register (PIOCFG)
/** \brief "PHI_PADXDC_SRC" Pad*/
//====================================================================

#define  IO_PAD65_PIOCFG_RESERVED1_MASK 0xfc000000
#define  IO_PAD65_PIOCFG_RESERVED1_SHIFT 26
#define  IO_PAD65_PIOCFG_RESERVED1_MASK_SHIFT(reg) (((reg) & IO_PAD65_PIOCFG_RESERVED1_MASK) >> IO_PAD65_PIOCFG_RESERVED1_SHIFT)
#define  IO_PAD65_PIOCFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD65_PIOCFG_RESERVED1_MASK) | (((uint32_t)val) << IO_PAD65_PIOCFG_RESERVED1_SHIFT))

#define  IO_PAD65_PIOCFG_PD_MASK 0x2000000
#define  IO_PAD65_PIOCFG_PD_SHIFT 25
#define  IO_PAD65_PIOCFG_PD_MASK_SHIFT(reg) (((reg) & IO_PAD65_PIOCFG_PD_MASK) >> IO_PAD65_PIOCFG_PD_SHIFT)
#define  IO_PAD65_PIOCFG_PD_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD65_PIOCFG_PD_MASK) | (((uint32_t)val) << IO_PAD65_PIOCFG_PD_SHIFT))

#define  IO_PAD65_PIOCFG_ODT_EN_MASK 0x1000000
#define  IO_PAD65_PIOCFG_ODT_EN_SHIFT 24
#define  IO_PAD65_PIOCFG_ODT_EN_MASK_SHIFT(reg) (((reg) & IO_PAD65_PIOCFG_ODT_EN_MASK) >> IO_PAD65_PIOCFG_ODT_EN_SHIFT)
#define  IO_PAD65_PIOCFG_ODT_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD65_PIOCFG_ODT_EN_MASK) | (((uint32_t)val) << IO_PAD65_PIOCFG_ODT_EN_SHIFT))

#define  IO_PAD65_PIOCFG_LED_EN_MASK 0x800000
#define  IO_PAD65_PIOCFG_LED_EN_SHIFT 23
#define  IO_PAD65_PIOCFG_LED_EN_MASK_SHIFT(reg) (((reg) & IO_PAD65_PIOCFG_LED_EN_MASK) >> IO_PAD65_PIOCFG_LED_EN_SHIFT)
#define  IO_PAD65_PIOCFG_LED_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD65_PIOCFG_LED_EN_MASK) | (((uint32_t)val) << IO_PAD65_PIOCFG_LED_EN_SHIFT))

#define  IO_PAD65_PIOCFG_I2C_SEL_MASK 0x600000
#define  IO_PAD65_PIOCFG_I2C_SEL_SHIFT 21
#define  IO_PAD65_PIOCFG_I2C_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD65_PIOCFG_I2C_SEL_MASK) >> IO_PAD65_PIOCFG_I2C_SEL_SHIFT)
#define  IO_PAD65_PIOCFG_I2C_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD65_PIOCFG_I2C_SEL_MASK) | (((uint32_t)val) << IO_PAD65_PIOCFG_I2C_SEL_SHIFT))

#define  IO_PAD65_PIOCFG_DGTBSEL_MASK 0x1e0000
#define  IO_PAD65_PIOCFG_DGTBSEL_SHIFT 17
#define  IO_PAD65_PIOCFG_DGTBSEL_MASK_SHIFT(reg) (((reg) & IO_PAD65_PIOCFG_DGTBSEL_MASK) >> IO_PAD65_PIOCFG_DGTBSEL_SHIFT)
#define  IO_PAD65_PIOCFG_DGTBSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD65_PIOCFG_DGTBSEL_MASK) | (((uint32_t)val) << IO_PAD65_PIOCFG_DGTBSEL_SHIFT))

#define  IO_PAD65_PIOCFG_RAWSEL_MASK 0x10000
#define  IO_PAD65_PIOCFG_RAWSEL_SHIFT 16
#define  IO_PAD65_PIOCFG_RAWSEL_MASK_SHIFT(reg) (((reg) & IO_PAD65_PIOCFG_RAWSEL_MASK) >> IO_PAD65_PIOCFG_RAWSEL_SHIFT)
#define  IO_PAD65_PIOCFG_RAWSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD65_PIOCFG_RAWSEL_MASK) | (((uint32_t)val) << IO_PAD65_PIOCFG_RAWSEL_SHIFT))

#define  IO_PAD65_PIOCFG_PULL_SEL_MASK 0x8000
#define  IO_PAD65_PIOCFG_PULL_SEL_SHIFT 15
#define  IO_PAD65_PIOCFG_PULL_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD65_PIOCFG_PULL_SEL_MASK) >> IO_PAD65_PIOCFG_PULL_SEL_SHIFT)
#define  IO_PAD65_PIOCFG_PULL_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD65_PIOCFG_PULL_SEL_MASK) | (((uint32_t)val) << IO_PAD65_PIOCFG_PULL_SEL_SHIFT))

#define  IO_PAD65_PIOCFG_PUEN_MASK 0x4000
#define  IO_PAD65_PIOCFG_PUEN_SHIFT 14
#define  IO_PAD65_PIOCFG_PUEN_MASK_SHIFT(reg) (((reg) & IO_PAD65_PIOCFG_PUEN_MASK) >> IO_PAD65_PIOCFG_PUEN_SHIFT)
#define  IO_PAD65_PIOCFG_PUEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD65_PIOCFG_PUEN_MASK) | (((uint32_t)val) << IO_PAD65_PIOCFG_PUEN_SHIFT))

#define  IO_PAD65_PIOCFG_PDEN_MASK 0x2000
#define  IO_PAD65_PIOCFG_PDEN_SHIFT 13
#define  IO_PAD65_PIOCFG_PDEN_MASK_SHIFT(reg) (((reg) & IO_PAD65_PIOCFG_PDEN_MASK) >> IO_PAD65_PIOCFG_PDEN_SHIFT)
#define  IO_PAD65_PIOCFG_PDEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD65_PIOCFG_PDEN_MASK) | (((uint32_t)val) << IO_PAD65_PIOCFG_PDEN_SHIFT))

#define  IO_PAD65_PIOCFG_SR_MASK 0x1800
#define  IO_PAD65_PIOCFG_SR_SHIFT 11
#define  IO_PAD65_PIOCFG_SR_MASK_SHIFT(reg) (((reg) & IO_PAD65_PIOCFG_SR_MASK) >> IO_PAD65_PIOCFG_SR_SHIFT)
#define  IO_PAD65_PIOCFG_SR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD65_PIOCFG_SR_MASK) | (((uint32_t)val) << IO_PAD65_PIOCFG_SR_SHIFT))

#define  IO_PAD65_PIOCFG_SLP_DI_MASK 0x400
#define  IO_PAD65_PIOCFG_SLP_DI_SHIFT 10
#define  IO_PAD65_PIOCFG_SLP_DI_MASK_SHIFT(reg) (((reg) & IO_PAD65_PIOCFG_SLP_DI_MASK) >> IO_PAD65_PIOCFG_SLP_DI_SHIFT)
#define  IO_PAD65_PIOCFG_SLP_DI_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD65_PIOCFG_SLP_DI_MASK) | (((uint32_t)val) << IO_PAD65_PIOCFG_SLP_DI_SHIFT))

#define  IO_PAD65_PIOCFG_SLP_CNTRL_MASK 0x200
#define  IO_PAD65_PIOCFG_SLP_CNTRL_SHIFT 9
#define  IO_PAD65_PIOCFG_SLP_CNTRL_MASK_SHIFT(reg) (((reg) & IO_PAD65_PIOCFG_SLP_CNTRL_MASK) >> IO_PAD65_PIOCFG_SLP_CNTRL_SHIFT)
#define  IO_PAD65_PIOCFG_SLP_CNTRL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD65_PIOCFG_SLP_CNTRL_MASK) | (((uint32_t)val) << IO_PAD65_PIOCFG_SLP_CNTRL_SHIFT))

#define  IO_PAD65_PIOCFG_SLP_DO_MASK 0x100
#define  IO_PAD65_PIOCFG_SLP_DO_SHIFT 8
#define  IO_PAD65_PIOCFG_SLP_DO_MASK_SHIFT(reg) (((reg) & IO_PAD65_PIOCFG_SLP_DO_MASK) >> IO_PAD65_PIOCFG_SLP_DO_SHIFT)
#define  IO_PAD65_PIOCFG_SLP_DO_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD65_PIOCFG_SLP_DO_MASK) | (((uint32_t)val) << IO_PAD65_PIOCFG_SLP_DO_SHIFT))

#define  IO_PAD65_PIOCFG_SLP_DIR_MASK 0x80
#define  IO_PAD65_PIOCFG_SLP_DIR_SHIFT 7
#define  IO_PAD65_PIOCFG_SLP_DIR_MASK_SHIFT(reg) (((reg) & IO_PAD65_PIOCFG_SLP_DIR_MASK) >> IO_PAD65_PIOCFG_SLP_DIR_SHIFT)
#define  IO_PAD65_PIOCFG_SLP_DIR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD65_PIOCFG_SLP_DIR_MASK) | (((uint32_t)val) << IO_PAD65_PIOCFG_SLP_DIR_SHIFT))

#define  IO_PAD65_PIOCFG_EDGE_EN_N_MASK 0x40
#define  IO_PAD65_PIOCFG_EDGE_EN_N_SHIFT 6
#define  IO_PAD65_PIOCFG_EDGE_EN_N_MASK_SHIFT(reg) (((reg) & IO_PAD65_PIOCFG_EDGE_EN_N_MASK) >> IO_PAD65_PIOCFG_EDGE_EN_N_SHIFT)
#define  IO_PAD65_PIOCFG_EDGE_EN_N_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD65_PIOCFG_EDGE_EN_N_MASK) | (((uint32_t)val) << IO_PAD65_PIOCFG_EDGE_EN_N_SHIFT))

#define  IO_PAD65_PIOCFG_EDGE_FALL_EN_MASK 0x20
#define  IO_PAD65_PIOCFG_EDGE_FALL_EN_SHIFT 5
#define  IO_PAD65_PIOCFG_EDGE_FALL_EN_MASK_SHIFT(reg) (((reg) & IO_PAD65_PIOCFG_EDGE_FALL_EN_MASK) >> IO_PAD65_PIOCFG_EDGE_FALL_EN_SHIFT)
#define  IO_PAD65_PIOCFG_EDGE_FALL_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD65_PIOCFG_EDGE_FALL_EN_MASK) | (((uint32_t)val) << IO_PAD65_PIOCFG_EDGE_FALL_EN_SHIFT))

#define  IO_PAD65_PIOCFG_EDGE_RISE_EN_MASK 0x10
#define  IO_PAD65_PIOCFG_EDGE_RISE_EN_SHIFT 4
#define  IO_PAD65_PIOCFG_EDGE_RISE_EN_MASK_SHIFT(reg) (((reg) & IO_PAD65_PIOCFG_EDGE_RISE_EN_MASK) >> IO_PAD65_PIOCFG_EDGE_RISE_EN_SHIFT)
#define  IO_PAD65_PIOCFG_EDGE_RISE_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD65_PIOCFG_EDGE_RISE_EN_MASK) | (((uint32_t)val) << IO_PAD65_PIOCFG_EDGE_RISE_EN_SHIFT))

#define  IO_PAD65_PIOCFG_SLP_SEL_MASK 0x8
#define  IO_PAD65_PIOCFG_SLP_SEL_SHIFT 3
#define  IO_PAD65_PIOCFG_SLP_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD65_PIOCFG_SLP_SEL_MASK) >> IO_PAD65_PIOCFG_SLP_SEL_SHIFT)
#define  IO_PAD65_PIOCFG_SLP_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD65_PIOCFG_SLP_SEL_MASK) | (((uint32_t)val) << IO_PAD65_PIOCFG_SLP_SEL_SHIFT))

#define  IO_PAD65_PIOCFG_FUNC_SEL_MASK 0x7
#define  IO_PAD65_PIOCFG_FUNC_SEL_SHIFT 0
#define  IO_PAD65_PIOCFG_FUNC_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD65_PIOCFG_FUNC_SEL_MASK) >> IO_PAD65_PIOCFG_FUNC_SEL_SHIFT)
#define  IO_PAD65_PIOCFG_FUNC_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD65_PIOCFG_FUNC_SEL_MASK) | (((uint32_t)val) << IO_PAD65_PIOCFG_FUNC_SEL_SHIFT))

//====================================================================
//
//Register File: IO_PAD66 Configuration Registers (IO_PAD66)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

//====================================================================
//Register: IO_PAD66 Configuration Register (PIOCFG)
/** \brief "PHI_PADXDC_SRC" Pad*/
//====================================================================

#define  IO_PAD66_PIOCFG_RESERVED1_MASK 0xfc000000
#define  IO_PAD66_PIOCFG_RESERVED1_SHIFT 26
#define  IO_PAD66_PIOCFG_RESERVED1_MASK_SHIFT(reg) (((reg) & IO_PAD66_PIOCFG_RESERVED1_MASK) >> IO_PAD66_PIOCFG_RESERVED1_SHIFT)
#define  IO_PAD66_PIOCFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD66_PIOCFG_RESERVED1_MASK) | (((uint32_t)val) << IO_PAD66_PIOCFG_RESERVED1_SHIFT))

#define  IO_PAD66_PIOCFG_PD_MASK 0x2000000
#define  IO_PAD66_PIOCFG_PD_SHIFT 25
#define  IO_PAD66_PIOCFG_PD_MASK_SHIFT(reg) (((reg) & IO_PAD66_PIOCFG_PD_MASK) >> IO_PAD66_PIOCFG_PD_SHIFT)
#define  IO_PAD66_PIOCFG_PD_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD66_PIOCFG_PD_MASK) | (((uint32_t)val) << IO_PAD66_PIOCFG_PD_SHIFT))

#define  IO_PAD66_PIOCFG_ODT_EN_MASK 0x1000000
#define  IO_PAD66_PIOCFG_ODT_EN_SHIFT 24
#define  IO_PAD66_PIOCFG_ODT_EN_MASK_SHIFT(reg) (((reg) & IO_PAD66_PIOCFG_ODT_EN_MASK) >> IO_PAD66_PIOCFG_ODT_EN_SHIFT)
#define  IO_PAD66_PIOCFG_ODT_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD66_PIOCFG_ODT_EN_MASK) | (((uint32_t)val) << IO_PAD66_PIOCFG_ODT_EN_SHIFT))

#define  IO_PAD66_PIOCFG_LED_EN_MASK 0x800000
#define  IO_PAD66_PIOCFG_LED_EN_SHIFT 23
#define  IO_PAD66_PIOCFG_LED_EN_MASK_SHIFT(reg) (((reg) & IO_PAD66_PIOCFG_LED_EN_MASK) >> IO_PAD66_PIOCFG_LED_EN_SHIFT)
#define  IO_PAD66_PIOCFG_LED_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD66_PIOCFG_LED_EN_MASK) | (((uint32_t)val) << IO_PAD66_PIOCFG_LED_EN_SHIFT))

#define  IO_PAD66_PIOCFG_I2C_SEL_MASK 0x600000
#define  IO_PAD66_PIOCFG_I2C_SEL_SHIFT 21
#define  IO_PAD66_PIOCFG_I2C_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD66_PIOCFG_I2C_SEL_MASK) >> IO_PAD66_PIOCFG_I2C_SEL_SHIFT)
#define  IO_PAD66_PIOCFG_I2C_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD66_PIOCFG_I2C_SEL_MASK) | (((uint32_t)val) << IO_PAD66_PIOCFG_I2C_SEL_SHIFT))

#define  IO_PAD66_PIOCFG_DGTBSEL_MASK 0x1e0000
#define  IO_PAD66_PIOCFG_DGTBSEL_SHIFT 17
#define  IO_PAD66_PIOCFG_DGTBSEL_MASK_SHIFT(reg) (((reg) & IO_PAD66_PIOCFG_DGTBSEL_MASK) >> IO_PAD66_PIOCFG_DGTBSEL_SHIFT)
#define  IO_PAD66_PIOCFG_DGTBSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD66_PIOCFG_DGTBSEL_MASK) | (((uint32_t)val) << IO_PAD66_PIOCFG_DGTBSEL_SHIFT))

#define  IO_PAD66_PIOCFG_RAWSEL_MASK 0x10000
#define  IO_PAD66_PIOCFG_RAWSEL_SHIFT 16
#define  IO_PAD66_PIOCFG_RAWSEL_MASK_SHIFT(reg) (((reg) & IO_PAD66_PIOCFG_RAWSEL_MASK) >> IO_PAD66_PIOCFG_RAWSEL_SHIFT)
#define  IO_PAD66_PIOCFG_RAWSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD66_PIOCFG_RAWSEL_MASK) | (((uint32_t)val) << IO_PAD66_PIOCFG_RAWSEL_SHIFT))

#define  IO_PAD66_PIOCFG_PULL_SEL_MASK 0x8000
#define  IO_PAD66_PIOCFG_PULL_SEL_SHIFT 15
#define  IO_PAD66_PIOCFG_PULL_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD66_PIOCFG_PULL_SEL_MASK) >> IO_PAD66_PIOCFG_PULL_SEL_SHIFT)
#define  IO_PAD66_PIOCFG_PULL_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD66_PIOCFG_PULL_SEL_MASK) | (((uint32_t)val) << IO_PAD66_PIOCFG_PULL_SEL_SHIFT))

#define  IO_PAD66_PIOCFG_PUEN_MASK 0x4000
#define  IO_PAD66_PIOCFG_PUEN_SHIFT 14
#define  IO_PAD66_PIOCFG_PUEN_MASK_SHIFT(reg) (((reg) & IO_PAD66_PIOCFG_PUEN_MASK) >> IO_PAD66_PIOCFG_PUEN_SHIFT)
#define  IO_PAD66_PIOCFG_PUEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD66_PIOCFG_PUEN_MASK) | (((uint32_t)val) << IO_PAD66_PIOCFG_PUEN_SHIFT))

#define  IO_PAD66_PIOCFG_PDEN_MASK 0x2000
#define  IO_PAD66_PIOCFG_PDEN_SHIFT 13
#define  IO_PAD66_PIOCFG_PDEN_MASK_SHIFT(reg) (((reg) & IO_PAD66_PIOCFG_PDEN_MASK) >> IO_PAD66_PIOCFG_PDEN_SHIFT)
#define  IO_PAD66_PIOCFG_PDEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD66_PIOCFG_PDEN_MASK) | (((uint32_t)val) << IO_PAD66_PIOCFG_PDEN_SHIFT))

#define  IO_PAD66_PIOCFG_SR_MASK 0x1800
#define  IO_PAD66_PIOCFG_SR_SHIFT 11
#define  IO_PAD66_PIOCFG_SR_MASK_SHIFT(reg) (((reg) & IO_PAD66_PIOCFG_SR_MASK) >> IO_PAD66_PIOCFG_SR_SHIFT)
#define  IO_PAD66_PIOCFG_SR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD66_PIOCFG_SR_MASK) | (((uint32_t)val) << IO_PAD66_PIOCFG_SR_SHIFT))

#define  IO_PAD66_PIOCFG_SLP_DI_MASK 0x400
#define  IO_PAD66_PIOCFG_SLP_DI_SHIFT 10
#define  IO_PAD66_PIOCFG_SLP_DI_MASK_SHIFT(reg) (((reg) & IO_PAD66_PIOCFG_SLP_DI_MASK) >> IO_PAD66_PIOCFG_SLP_DI_SHIFT)
#define  IO_PAD66_PIOCFG_SLP_DI_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD66_PIOCFG_SLP_DI_MASK) | (((uint32_t)val) << IO_PAD66_PIOCFG_SLP_DI_SHIFT))

#define  IO_PAD66_PIOCFG_SLP_CNTRL_MASK 0x200
#define  IO_PAD66_PIOCFG_SLP_CNTRL_SHIFT 9
#define  IO_PAD66_PIOCFG_SLP_CNTRL_MASK_SHIFT(reg) (((reg) & IO_PAD66_PIOCFG_SLP_CNTRL_MASK) >> IO_PAD66_PIOCFG_SLP_CNTRL_SHIFT)
#define  IO_PAD66_PIOCFG_SLP_CNTRL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD66_PIOCFG_SLP_CNTRL_MASK) | (((uint32_t)val) << IO_PAD66_PIOCFG_SLP_CNTRL_SHIFT))

#define  IO_PAD66_PIOCFG_SLP_DO_MASK 0x100
#define  IO_PAD66_PIOCFG_SLP_DO_SHIFT 8
#define  IO_PAD66_PIOCFG_SLP_DO_MASK_SHIFT(reg) (((reg) & IO_PAD66_PIOCFG_SLP_DO_MASK) >> IO_PAD66_PIOCFG_SLP_DO_SHIFT)
#define  IO_PAD66_PIOCFG_SLP_DO_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD66_PIOCFG_SLP_DO_MASK) | (((uint32_t)val) << IO_PAD66_PIOCFG_SLP_DO_SHIFT))

#define  IO_PAD66_PIOCFG_SLP_DIR_MASK 0x80
#define  IO_PAD66_PIOCFG_SLP_DIR_SHIFT 7
#define  IO_PAD66_PIOCFG_SLP_DIR_MASK_SHIFT(reg) (((reg) & IO_PAD66_PIOCFG_SLP_DIR_MASK) >> IO_PAD66_PIOCFG_SLP_DIR_SHIFT)
#define  IO_PAD66_PIOCFG_SLP_DIR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD66_PIOCFG_SLP_DIR_MASK) | (((uint32_t)val) << IO_PAD66_PIOCFG_SLP_DIR_SHIFT))

#define  IO_PAD66_PIOCFG_EDGE_EN_N_MASK 0x40
#define  IO_PAD66_PIOCFG_EDGE_EN_N_SHIFT 6
#define  IO_PAD66_PIOCFG_EDGE_EN_N_MASK_SHIFT(reg) (((reg) & IO_PAD66_PIOCFG_EDGE_EN_N_MASK) >> IO_PAD66_PIOCFG_EDGE_EN_N_SHIFT)
#define  IO_PAD66_PIOCFG_EDGE_EN_N_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD66_PIOCFG_EDGE_EN_N_MASK) | (((uint32_t)val) << IO_PAD66_PIOCFG_EDGE_EN_N_SHIFT))

#define  IO_PAD66_PIOCFG_EDGE_FALL_EN_MASK 0x20
#define  IO_PAD66_PIOCFG_EDGE_FALL_EN_SHIFT 5
#define  IO_PAD66_PIOCFG_EDGE_FALL_EN_MASK_SHIFT(reg) (((reg) & IO_PAD66_PIOCFG_EDGE_FALL_EN_MASK) >> IO_PAD66_PIOCFG_EDGE_FALL_EN_SHIFT)
#define  IO_PAD66_PIOCFG_EDGE_FALL_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD66_PIOCFG_EDGE_FALL_EN_MASK) | (((uint32_t)val) << IO_PAD66_PIOCFG_EDGE_FALL_EN_SHIFT))

#define  IO_PAD66_PIOCFG_EDGE_RISE_EN_MASK 0x10
#define  IO_PAD66_PIOCFG_EDGE_RISE_EN_SHIFT 4
#define  IO_PAD66_PIOCFG_EDGE_RISE_EN_MASK_SHIFT(reg) (((reg) & IO_PAD66_PIOCFG_EDGE_RISE_EN_MASK) >> IO_PAD66_PIOCFG_EDGE_RISE_EN_SHIFT)
#define  IO_PAD66_PIOCFG_EDGE_RISE_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD66_PIOCFG_EDGE_RISE_EN_MASK) | (((uint32_t)val) << IO_PAD66_PIOCFG_EDGE_RISE_EN_SHIFT))

#define  IO_PAD66_PIOCFG_SLP_SEL_MASK 0x8
#define  IO_PAD66_PIOCFG_SLP_SEL_SHIFT 3
#define  IO_PAD66_PIOCFG_SLP_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD66_PIOCFG_SLP_SEL_MASK) >> IO_PAD66_PIOCFG_SLP_SEL_SHIFT)
#define  IO_PAD66_PIOCFG_SLP_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD66_PIOCFG_SLP_SEL_MASK) | (((uint32_t)val) << IO_PAD66_PIOCFG_SLP_SEL_SHIFT))

#define  IO_PAD66_PIOCFG_FUNC_SEL_MASK 0x7
#define  IO_PAD66_PIOCFG_FUNC_SEL_SHIFT 0
#define  IO_PAD66_PIOCFG_FUNC_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD66_PIOCFG_FUNC_SEL_MASK) >> IO_PAD66_PIOCFG_FUNC_SEL_SHIFT)
#define  IO_PAD66_PIOCFG_FUNC_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD66_PIOCFG_FUNC_SEL_MASK) | (((uint32_t)val) << IO_PAD66_PIOCFG_FUNC_SEL_SHIFT))

//====================================================================
//
//Register File: IO_PAD67 Configuration Registers (IO_PAD67)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

//====================================================================
//Register: IO_PAD67 Configuration Register (PIOCFG)
/** \brief "PHI_PADXDC_SRC" Pad*/
//====================================================================

#define  IO_PAD67_PIOCFG_RESERVED1_MASK 0xfc000000
#define  IO_PAD67_PIOCFG_RESERVED1_SHIFT 26
#define  IO_PAD67_PIOCFG_RESERVED1_MASK_SHIFT(reg) (((reg) & IO_PAD67_PIOCFG_RESERVED1_MASK) >> IO_PAD67_PIOCFG_RESERVED1_SHIFT)
#define  IO_PAD67_PIOCFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD67_PIOCFG_RESERVED1_MASK) | (((uint32_t)val) << IO_PAD67_PIOCFG_RESERVED1_SHIFT))

#define  IO_PAD67_PIOCFG_PD_MASK 0x2000000
#define  IO_PAD67_PIOCFG_PD_SHIFT 25
#define  IO_PAD67_PIOCFG_PD_MASK_SHIFT(reg) (((reg) & IO_PAD67_PIOCFG_PD_MASK) >> IO_PAD67_PIOCFG_PD_SHIFT)
#define  IO_PAD67_PIOCFG_PD_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD67_PIOCFG_PD_MASK) | (((uint32_t)val) << IO_PAD67_PIOCFG_PD_SHIFT))

#define  IO_PAD67_PIOCFG_ODT_EN_MASK 0x1000000
#define  IO_PAD67_PIOCFG_ODT_EN_SHIFT 24
#define  IO_PAD67_PIOCFG_ODT_EN_MASK_SHIFT(reg) (((reg) & IO_PAD67_PIOCFG_ODT_EN_MASK) >> IO_PAD67_PIOCFG_ODT_EN_SHIFT)
#define  IO_PAD67_PIOCFG_ODT_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD67_PIOCFG_ODT_EN_MASK) | (((uint32_t)val) << IO_PAD67_PIOCFG_ODT_EN_SHIFT))

#define  IO_PAD67_PIOCFG_LED_EN_MASK 0x800000
#define  IO_PAD67_PIOCFG_LED_EN_SHIFT 23
#define  IO_PAD67_PIOCFG_LED_EN_MASK_SHIFT(reg) (((reg) & IO_PAD67_PIOCFG_LED_EN_MASK) >> IO_PAD67_PIOCFG_LED_EN_SHIFT)
#define  IO_PAD67_PIOCFG_LED_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD67_PIOCFG_LED_EN_MASK) | (((uint32_t)val) << IO_PAD67_PIOCFG_LED_EN_SHIFT))

#define  IO_PAD67_PIOCFG_I2C_SEL_MASK 0x600000
#define  IO_PAD67_PIOCFG_I2C_SEL_SHIFT 21
#define  IO_PAD67_PIOCFG_I2C_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD67_PIOCFG_I2C_SEL_MASK) >> IO_PAD67_PIOCFG_I2C_SEL_SHIFT)
#define  IO_PAD67_PIOCFG_I2C_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD67_PIOCFG_I2C_SEL_MASK) | (((uint32_t)val) << IO_PAD67_PIOCFG_I2C_SEL_SHIFT))

#define  IO_PAD67_PIOCFG_DGTBSEL_MASK 0x1e0000
#define  IO_PAD67_PIOCFG_DGTBSEL_SHIFT 17
#define  IO_PAD67_PIOCFG_DGTBSEL_MASK_SHIFT(reg) (((reg) & IO_PAD67_PIOCFG_DGTBSEL_MASK) >> IO_PAD67_PIOCFG_DGTBSEL_SHIFT)
#define  IO_PAD67_PIOCFG_DGTBSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD67_PIOCFG_DGTBSEL_MASK) | (((uint32_t)val) << IO_PAD67_PIOCFG_DGTBSEL_SHIFT))

#define  IO_PAD67_PIOCFG_RAWSEL_MASK 0x10000
#define  IO_PAD67_PIOCFG_RAWSEL_SHIFT 16
#define  IO_PAD67_PIOCFG_RAWSEL_MASK_SHIFT(reg) (((reg) & IO_PAD67_PIOCFG_RAWSEL_MASK) >> IO_PAD67_PIOCFG_RAWSEL_SHIFT)
#define  IO_PAD67_PIOCFG_RAWSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD67_PIOCFG_RAWSEL_MASK) | (((uint32_t)val) << IO_PAD67_PIOCFG_RAWSEL_SHIFT))

#define  IO_PAD67_PIOCFG_PULL_SEL_MASK 0x8000
#define  IO_PAD67_PIOCFG_PULL_SEL_SHIFT 15
#define  IO_PAD67_PIOCFG_PULL_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD67_PIOCFG_PULL_SEL_MASK) >> IO_PAD67_PIOCFG_PULL_SEL_SHIFT)
#define  IO_PAD67_PIOCFG_PULL_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD67_PIOCFG_PULL_SEL_MASK) | (((uint32_t)val) << IO_PAD67_PIOCFG_PULL_SEL_SHIFT))

#define  IO_PAD67_PIOCFG_PUEN_MASK 0x4000
#define  IO_PAD67_PIOCFG_PUEN_SHIFT 14
#define  IO_PAD67_PIOCFG_PUEN_MASK_SHIFT(reg) (((reg) & IO_PAD67_PIOCFG_PUEN_MASK) >> IO_PAD67_PIOCFG_PUEN_SHIFT)
#define  IO_PAD67_PIOCFG_PUEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD67_PIOCFG_PUEN_MASK) | (((uint32_t)val) << IO_PAD67_PIOCFG_PUEN_SHIFT))

#define  IO_PAD67_PIOCFG_PDEN_MASK 0x2000
#define  IO_PAD67_PIOCFG_PDEN_SHIFT 13
#define  IO_PAD67_PIOCFG_PDEN_MASK_SHIFT(reg) (((reg) & IO_PAD67_PIOCFG_PDEN_MASK) >> IO_PAD67_PIOCFG_PDEN_SHIFT)
#define  IO_PAD67_PIOCFG_PDEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD67_PIOCFG_PDEN_MASK) | (((uint32_t)val) << IO_PAD67_PIOCFG_PDEN_SHIFT))

#define  IO_PAD67_PIOCFG_SR_MASK 0x1800
#define  IO_PAD67_PIOCFG_SR_SHIFT 11
#define  IO_PAD67_PIOCFG_SR_MASK_SHIFT(reg) (((reg) & IO_PAD67_PIOCFG_SR_MASK) >> IO_PAD67_PIOCFG_SR_SHIFT)
#define  IO_PAD67_PIOCFG_SR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD67_PIOCFG_SR_MASK) | (((uint32_t)val) << IO_PAD67_PIOCFG_SR_SHIFT))

#define  IO_PAD67_PIOCFG_SLP_DI_MASK 0x400
#define  IO_PAD67_PIOCFG_SLP_DI_SHIFT 10
#define  IO_PAD67_PIOCFG_SLP_DI_MASK_SHIFT(reg) (((reg) & IO_PAD67_PIOCFG_SLP_DI_MASK) >> IO_PAD67_PIOCFG_SLP_DI_SHIFT)
#define  IO_PAD67_PIOCFG_SLP_DI_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD67_PIOCFG_SLP_DI_MASK) | (((uint32_t)val) << IO_PAD67_PIOCFG_SLP_DI_SHIFT))

#define  IO_PAD67_PIOCFG_SLP_CNTRL_MASK 0x200
#define  IO_PAD67_PIOCFG_SLP_CNTRL_SHIFT 9
#define  IO_PAD67_PIOCFG_SLP_CNTRL_MASK_SHIFT(reg) (((reg) & IO_PAD67_PIOCFG_SLP_CNTRL_MASK) >> IO_PAD67_PIOCFG_SLP_CNTRL_SHIFT)
#define  IO_PAD67_PIOCFG_SLP_CNTRL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD67_PIOCFG_SLP_CNTRL_MASK) | (((uint32_t)val) << IO_PAD67_PIOCFG_SLP_CNTRL_SHIFT))

#define  IO_PAD67_PIOCFG_SLP_DO_MASK 0x100
#define  IO_PAD67_PIOCFG_SLP_DO_SHIFT 8
#define  IO_PAD67_PIOCFG_SLP_DO_MASK_SHIFT(reg) (((reg) & IO_PAD67_PIOCFG_SLP_DO_MASK) >> IO_PAD67_PIOCFG_SLP_DO_SHIFT)
#define  IO_PAD67_PIOCFG_SLP_DO_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD67_PIOCFG_SLP_DO_MASK) | (((uint32_t)val) << IO_PAD67_PIOCFG_SLP_DO_SHIFT))

#define  IO_PAD67_PIOCFG_SLP_DIR_MASK 0x80
#define  IO_PAD67_PIOCFG_SLP_DIR_SHIFT 7
#define  IO_PAD67_PIOCFG_SLP_DIR_MASK_SHIFT(reg) (((reg) & IO_PAD67_PIOCFG_SLP_DIR_MASK) >> IO_PAD67_PIOCFG_SLP_DIR_SHIFT)
#define  IO_PAD67_PIOCFG_SLP_DIR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD67_PIOCFG_SLP_DIR_MASK) | (((uint32_t)val) << IO_PAD67_PIOCFG_SLP_DIR_SHIFT))

#define  IO_PAD67_PIOCFG_EDGE_EN_N_MASK 0x40
#define  IO_PAD67_PIOCFG_EDGE_EN_N_SHIFT 6
#define  IO_PAD67_PIOCFG_EDGE_EN_N_MASK_SHIFT(reg) (((reg) & IO_PAD67_PIOCFG_EDGE_EN_N_MASK) >> IO_PAD67_PIOCFG_EDGE_EN_N_SHIFT)
#define  IO_PAD67_PIOCFG_EDGE_EN_N_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD67_PIOCFG_EDGE_EN_N_MASK) | (((uint32_t)val) << IO_PAD67_PIOCFG_EDGE_EN_N_SHIFT))

#define  IO_PAD67_PIOCFG_EDGE_FALL_EN_MASK 0x20
#define  IO_PAD67_PIOCFG_EDGE_FALL_EN_SHIFT 5
#define  IO_PAD67_PIOCFG_EDGE_FALL_EN_MASK_SHIFT(reg) (((reg) & IO_PAD67_PIOCFG_EDGE_FALL_EN_MASK) >> IO_PAD67_PIOCFG_EDGE_FALL_EN_SHIFT)
#define  IO_PAD67_PIOCFG_EDGE_FALL_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD67_PIOCFG_EDGE_FALL_EN_MASK) | (((uint32_t)val) << IO_PAD67_PIOCFG_EDGE_FALL_EN_SHIFT))

#define  IO_PAD67_PIOCFG_EDGE_RISE_EN_MASK 0x10
#define  IO_PAD67_PIOCFG_EDGE_RISE_EN_SHIFT 4
#define  IO_PAD67_PIOCFG_EDGE_RISE_EN_MASK_SHIFT(reg) (((reg) & IO_PAD67_PIOCFG_EDGE_RISE_EN_MASK) >> IO_PAD67_PIOCFG_EDGE_RISE_EN_SHIFT)
#define  IO_PAD67_PIOCFG_EDGE_RISE_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD67_PIOCFG_EDGE_RISE_EN_MASK) | (((uint32_t)val) << IO_PAD67_PIOCFG_EDGE_RISE_EN_SHIFT))

#define  IO_PAD67_PIOCFG_SLP_SEL_MASK 0x8
#define  IO_PAD67_PIOCFG_SLP_SEL_SHIFT 3
#define  IO_PAD67_PIOCFG_SLP_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD67_PIOCFG_SLP_SEL_MASK) >> IO_PAD67_PIOCFG_SLP_SEL_SHIFT)
#define  IO_PAD67_PIOCFG_SLP_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD67_PIOCFG_SLP_SEL_MASK) | (((uint32_t)val) << IO_PAD67_PIOCFG_SLP_SEL_SHIFT))

#define  IO_PAD67_PIOCFG_FUNC_SEL_MASK 0x7
#define  IO_PAD67_PIOCFG_FUNC_SEL_SHIFT 0
#define  IO_PAD67_PIOCFG_FUNC_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD67_PIOCFG_FUNC_SEL_MASK) >> IO_PAD67_PIOCFG_FUNC_SEL_SHIFT)
#define  IO_PAD67_PIOCFG_FUNC_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD67_PIOCFG_FUNC_SEL_MASK) | (((uint32_t)val) << IO_PAD67_PIOCFG_FUNC_SEL_SHIFT))

//====================================================================
//
//Register File: IO_PAD68 Configuration Registers (IO_PAD68)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

//====================================================================
//Register: IO_PAD68 Configuration Register (PIOCFG)
/** \brief "PHI_PADXDC_IOB" Pad*/
//====================================================================

#define  IO_PAD68_PIOCFG_RESERVED1_MASK 0xfc000000
#define  IO_PAD68_PIOCFG_RESERVED1_SHIFT 26
#define  IO_PAD68_PIOCFG_RESERVED1_MASK_SHIFT(reg) (((reg) & IO_PAD68_PIOCFG_RESERVED1_MASK) >> IO_PAD68_PIOCFG_RESERVED1_SHIFT)
#define  IO_PAD68_PIOCFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD68_PIOCFG_RESERVED1_MASK) | (((uint32_t)val) << IO_PAD68_PIOCFG_RESERVED1_SHIFT))

#define  IO_PAD68_PIOCFG_PD_MASK 0x2000000
#define  IO_PAD68_PIOCFG_PD_SHIFT 25
#define  IO_PAD68_PIOCFG_PD_MASK_SHIFT(reg) (((reg) & IO_PAD68_PIOCFG_PD_MASK) >> IO_PAD68_PIOCFG_PD_SHIFT)
#define  IO_PAD68_PIOCFG_PD_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD68_PIOCFG_PD_MASK) | (((uint32_t)val) << IO_PAD68_PIOCFG_PD_SHIFT))

#define  IO_PAD68_PIOCFG_ODT_EN_MASK 0x1000000
#define  IO_PAD68_PIOCFG_ODT_EN_SHIFT 24
#define  IO_PAD68_PIOCFG_ODT_EN_MASK_SHIFT(reg) (((reg) & IO_PAD68_PIOCFG_ODT_EN_MASK) >> IO_PAD68_PIOCFG_ODT_EN_SHIFT)
#define  IO_PAD68_PIOCFG_ODT_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD68_PIOCFG_ODT_EN_MASK) | (((uint32_t)val) << IO_PAD68_PIOCFG_ODT_EN_SHIFT))

#define  IO_PAD68_PIOCFG_LED_EN_MASK 0x800000
#define  IO_PAD68_PIOCFG_LED_EN_SHIFT 23
#define  IO_PAD68_PIOCFG_LED_EN_MASK_SHIFT(reg) (((reg) & IO_PAD68_PIOCFG_LED_EN_MASK) >> IO_PAD68_PIOCFG_LED_EN_SHIFT)
#define  IO_PAD68_PIOCFG_LED_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD68_PIOCFG_LED_EN_MASK) | (((uint32_t)val) << IO_PAD68_PIOCFG_LED_EN_SHIFT))

#define  IO_PAD68_PIOCFG_I2C_SEL_MASK 0x600000
#define  IO_PAD68_PIOCFG_I2C_SEL_SHIFT 21
#define  IO_PAD68_PIOCFG_I2C_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD68_PIOCFG_I2C_SEL_MASK) >> IO_PAD68_PIOCFG_I2C_SEL_SHIFT)
#define  IO_PAD68_PIOCFG_I2C_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD68_PIOCFG_I2C_SEL_MASK) | (((uint32_t)val) << IO_PAD68_PIOCFG_I2C_SEL_SHIFT))

#define  IO_PAD68_PIOCFG_DGTBSEL_MASK 0x1e0000
#define  IO_PAD68_PIOCFG_DGTBSEL_SHIFT 17
#define  IO_PAD68_PIOCFG_DGTBSEL_MASK_SHIFT(reg) (((reg) & IO_PAD68_PIOCFG_DGTBSEL_MASK) >> IO_PAD68_PIOCFG_DGTBSEL_SHIFT)
#define  IO_PAD68_PIOCFG_DGTBSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD68_PIOCFG_DGTBSEL_MASK) | (((uint32_t)val) << IO_PAD68_PIOCFG_DGTBSEL_SHIFT))

#define  IO_PAD68_PIOCFG_RAWSEL_MASK 0x10000
#define  IO_PAD68_PIOCFG_RAWSEL_SHIFT 16
#define  IO_PAD68_PIOCFG_RAWSEL_MASK_SHIFT(reg) (((reg) & IO_PAD68_PIOCFG_RAWSEL_MASK) >> IO_PAD68_PIOCFG_RAWSEL_SHIFT)
#define  IO_PAD68_PIOCFG_RAWSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD68_PIOCFG_RAWSEL_MASK) | (((uint32_t)val) << IO_PAD68_PIOCFG_RAWSEL_SHIFT))

#define  IO_PAD68_PIOCFG_PULL_SEL_MASK 0x8000
#define  IO_PAD68_PIOCFG_PULL_SEL_SHIFT 15
#define  IO_PAD68_PIOCFG_PULL_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD68_PIOCFG_PULL_SEL_MASK) >> IO_PAD68_PIOCFG_PULL_SEL_SHIFT)
#define  IO_PAD68_PIOCFG_PULL_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD68_PIOCFG_PULL_SEL_MASK) | (((uint32_t)val) << IO_PAD68_PIOCFG_PULL_SEL_SHIFT))

#define  IO_PAD68_PIOCFG_PUEN_MASK 0x4000
#define  IO_PAD68_PIOCFG_PUEN_SHIFT 14
#define  IO_PAD68_PIOCFG_PUEN_MASK_SHIFT(reg) (((reg) & IO_PAD68_PIOCFG_PUEN_MASK) >> IO_PAD68_PIOCFG_PUEN_SHIFT)
#define  IO_PAD68_PIOCFG_PUEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD68_PIOCFG_PUEN_MASK) | (((uint32_t)val) << IO_PAD68_PIOCFG_PUEN_SHIFT))

#define  IO_PAD68_PIOCFG_PDEN_MASK 0x2000
#define  IO_PAD68_PIOCFG_PDEN_SHIFT 13
#define  IO_PAD68_PIOCFG_PDEN_MASK_SHIFT(reg) (((reg) & IO_PAD68_PIOCFG_PDEN_MASK) >> IO_PAD68_PIOCFG_PDEN_SHIFT)
#define  IO_PAD68_PIOCFG_PDEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD68_PIOCFG_PDEN_MASK) | (((uint32_t)val) << IO_PAD68_PIOCFG_PDEN_SHIFT))

#define  IO_PAD68_PIOCFG_SR_MASK 0x1800
#define  IO_PAD68_PIOCFG_SR_SHIFT 11
#define  IO_PAD68_PIOCFG_SR_MASK_SHIFT(reg) (((reg) & IO_PAD68_PIOCFG_SR_MASK) >> IO_PAD68_PIOCFG_SR_SHIFT)
#define  IO_PAD68_PIOCFG_SR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD68_PIOCFG_SR_MASK) | (((uint32_t)val) << IO_PAD68_PIOCFG_SR_SHIFT))

#define  IO_PAD68_PIOCFG_SLP_DI_MASK 0x400
#define  IO_PAD68_PIOCFG_SLP_DI_SHIFT 10
#define  IO_PAD68_PIOCFG_SLP_DI_MASK_SHIFT(reg) (((reg) & IO_PAD68_PIOCFG_SLP_DI_MASK) >> IO_PAD68_PIOCFG_SLP_DI_SHIFT)
#define  IO_PAD68_PIOCFG_SLP_DI_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD68_PIOCFG_SLP_DI_MASK) | (((uint32_t)val) << IO_PAD68_PIOCFG_SLP_DI_SHIFT))

#define  IO_PAD68_PIOCFG_SLP_CNTRL_MASK 0x200
#define  IO_PAD68_PIOCFG_SLP_CNTRL_SHIFT 9
#define  IO_PAD68_PIOCFG_SLP_CNTRL_MASK_SHIFT(reg) (((reg) & IO_PAD68_PIOCFG_SLP_CNTRL_MASK) >> IO_PAD68_PIOCFG_SLP_CNTRL_SHIFT)
#define  IO_PAD68_PIOCFG_SLP_CNTRL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD68_PIOCFG_SLP_CNTRL_MASK) | (((uint32_t)val) << IO_PAD68_PIOCFG_SLP_CNTRL_SHIFT))

#define  IO_PAD68_PIOCFG_SLP_DO_MASK 0x100
#define  IO_PAD68_PIOCFG_SLP_DO_SHIFT 8
#define  IO_PAD68_PIOCFG_SLP_DO_MASK_SHIFT(reg) (((reg) & IO_PAD68_PIOCFG_SLP_DO_MASK) >> IO_PAD68_PIOCFG_SLP_DO_SHIFT)
#define  IO_PAD68_PIOCFG_SLP_DO_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD68_PIOCFG_SLP_DO_MASK) | (((uint32_t)val) << IO_PAD68_PIOCFG_SLP_DO_SHIFT))

#define  IO_PAD68_PIOCFG_SLP_DIR_MASK 0x80
#define  IO_PAD68_PIOCFG_SLP_DIR_SHIFT 7
#define  IO_PAD68_PIOCFG_SLP_DIR_MASK_SHIFT(reg) (((reg) & IO_PAD68_PIOCFG_SLP_DIR_MASK) >> IO_PAD68_PIOCFG_SLP_DIR_SHIFT)
#define  IO_PAD68_PIOCFG_SLP_DIR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD68_PIOCFG_SLP_DIR_MASK) | (((uint32_t)val) << IO_PAD68_PIOCFG_SLP_DIR_SHIFT))

#define  IO_PAD68_PIOCFG_EDGE_EN_N_MASK 0x40
#define  IO_PAD68_PIOCFG_EDGE_EN_N_SHIFT 6
#define  IO_PAD68_PIOCFG_EDGE_EN_N_MASK_SHIFT(reg) (((reg) & IO_PAD68_PIOCFG_EDGE_EN_N_MASK) >> IO_PAD68_PIOCFG_EDGE_EN_N_SHIFT)
#define  IO_PAD68_PIOCFG_EDGE_EN_N_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD68_PIOCFG_EDGE_EN_N_MASK) | (((uint32_t)val) << IO_PAD68_PIOCFG_EDGE_EN_N_SHIFT))

#define  IO_PAD68_PIOCFG_EDGE_FALL_EN_MASK 0x20
#define  IO_PAD68_PIOCFG_EDGE_FALL_EN_SHIFT 5
#define  IO_PAD68_PIOCFG_EDGE_FALL_EN_MASK_SHIFT(reg) (((reg) & IO_PAD68_PIOCFG_EDGE_FALL_EN_MASK) >> IO_PAD68_PIOCFG_EDGE_FALL_EN_SHIFT)
#define  IO_PAD68_PIOCFG_EDGE_FALL_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD68_PIOCFG_EDGE_FALL_EN_MASK) | (((uint32_t)val) << IO_PAD68_PIOCFG_EDGE_FALL_EN_SHIFT))

#define  IO_PAD68_PIOCFG_EDGE_RISE_EN_MASK 0x10
#define  IO_PAD68_PIOCFG_EDGE_RISE_EN_SHIFT 4
#define  IO_PAD68_PIOCFG_EDGE_RISE_EN_MASK_SHIFT(reg) (((reg) & IO_PAD68_PIOCFG_EDGE_RISE_EN_MASK) >> IO_PAD68_PIOCFG_EDGE_RISE_EN_SHIFT)
#define  IO_PAD68_PIOCFG_EDGE_RISE_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD68_PIOCFG_EDGE_RISE_EN_MASK) | (((uint32_t)val) << IO_PAD68_PIOCFG_EDGE_RISE_EN_SHIFT))

#define  IO_PAD68_PIOCFG_SLP_SEL_MASK 0x8
#define  IO_PAD68_PIOCFG_SLP_SEL_SHIFT 3
#define  IO_PAD68_PIOCFG_SLP_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD68_PIOCFG_SLP_SEL_MASK) >> IO_PAD68_PIOCFG_SLP_SEL_SHIFT)
#define  IO_PAD68_PIOCFG_SLP_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD68_PIOCFG_SLP_SEL_MASK) | (((uint32_t)val) << IO_PAD68_PIOCFG_SLP_SEL_SHIFT))

#define  IO_PAD68_PIOCFG_FUNC_SEL_MASK 0x7
#define  IO_PAD68_PIOCFG_FUNC_SEL_SHIFT 0
#define  IO_PAD68_PIOCFG_FUNC_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD68_PIOCFG_FUNC_SEL_MASK) >> IO_PAD68_PIOCFG_FUNC_SEL_SHIFT)
#define  IO_PAD68_PIOCFG_FUNC_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD68_PIOCFG_FUNC_SEL_MASK) | (((uint32_t)val) << IO_PAD68_PIOCFG_FUNC_SEL_SHIFT))

//====================================================================
//
//Register File: IO_PAD69 Configuration Registers (IO_PAD69)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

//====================================================================
//Register: IO_PAD69 Configuration Register (PIOCFG)
/** \brief "PHI_PADXDC_IOB" Pad*/
//====================================================================

#define  IO_PAD69_PIOCFG_RESERVED1_MASK 0xfc000000
#define  IO_PAD69_PIOCFG_RESERVED1_SHIFT 26
#define  IO_PAD69_PIOCFG_RESERVED1_MASK_SHIFT(reg) (((reg) & IO_PAD69_PIOCFG_RESERVED1_MASK) >> IO_PAD69_PIOCFG_RESERVED1_SHIFT)
#define  IO_PAD69_PIOCFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD69_PIOCFG_RESERVED1_MASK) | (((uint32_t)val) << IO_PAD69_PIOCFG_RESERVED1_SHIFT))

#define  IO_PAD69_PIOCFG_PD_MASK 0x2000000
#define  IO_PAD69_PIOCFG_PD_SHIFT 25
#define  IO_PAD69_PIOCFG_PD_MASK_SHIFT(reg) (((reg) & IO_PAD69_PIOCFG_PD_MASK) >> IO_PAD69_PIOCFG_PD_SHIFT)
#define  IO_PAD69_PIOCFG_PD_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD69_PIOCFG_PD_MASK) | (((uint32_t)val) << IO_PAD69_PIOCFG_PD_SHIFT))

#define  IO_PAD69_PIOCFG_ODT_EN_MASK 0x1000000
#define  IO_PAD69_PIOCFG_ODT_EN_SHIFT 24
#define  IO_PAD69_PIOCFG_ODT_EN_MASK_SHIFT(reg) (((reg) & IO_PAD69_PIOCFG_ODT_EN_MASK) >> IO_PAD69_PIOCFG_ODT_EN_SHIFT)
#define  IO_PAD69_PIOCFG_ODT_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD69_PIOCFG_ODT_EN_MASK) | (((uint32_t)val) << IO_PAD69_PIOCFG_ODT_EN_SHIFT))

#define  IO_PAD69_PIOCFG_LED_EN_MASK 0x800000
#define  IO_PAD69_PIOCFG_LED_EN_SHIFT 23
#define  IO_PAD69_PIOCFG_LED_EN_MASK_SHIFT(reg) (((reg) & IO_PAD69_PIOCFG_LED_EN_MASK) >> IO_PAD69_PIOCFG_LED_EN_SHIFT)
#define  IO_PAD69_PIOCFG_LED_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD69_PIOCFG_LED_EN_MASK) | (((uint32_t)val) << IO_PAD69_PIOCFG_LED_EN_SHIFT))

#define  IO_PAD69_PIOCFG_I2C_SEL_MASK 0x600000
#define  IO_PAD69_PIOCFG_I2C_SEL_SHIFT 21
#define  IO_PAD69_PIOCFG_I2C_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD69_PIOCFG_I2C_SEL_MASK) >> IO_PAD69_PIOCFG_I2C_SEL_SHIFT)
#define  IO_PAD69_PIOCFG_I2C_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD69_PIOCFG_I2C_SEL_MASK) | (((uint32_t)val) << IO_PAD69_PIOCFG_I2C_SEL_SHIFT))

#define  IO_PAD69_PIOCFG_DGTBSEL_MASK 0x1e0000
#define  IO_PAD69_PIOCFG_DGTBSEL_SHIFT 17
#define  IO_PAD69_PIOCFG_DGTBSEL_MASK_SHIFT(reg) (((reg) & IO_PAD69_PIOCFG_DGTBSEL_MASK) >> IO_PAD69_PIOCFG_DGTBSEL_SHIFT)
#define  IO_PAD69_PIOCFG_DGTBSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD69_PIOCFG_DGTBSEL_MASK) | (((uint32_t)val) << IO_PAD69_PIOCFG_DGTBSEL_SHIFT))

#define  IO_PAD69_PIOCFG_RAWSEL_MASK 0x10000
#define  IO_PAD69_PIOCFG_RAWSEL_SHIFT 16
#define  IO_PAD69_PIOCFG_RAWSEL_MASK_SHIFT(reg) (((reg) & IO_PAD69_PIOCFG_RAWSEL_MASK) >> IO_PAD69_PIOCFG_RAWSEL_SHIFT)
#define  IO_PAD69_PIOCFG_RAWSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD69_PIOCFG_RAWSEL_MASK) | (((uint32_t)val) << IO_PAD69_PIOCFG_RAWSEL_SHIFT))

#define  IO_PAD69_PIOCFG_PULL_SEL_MASK 0x8000
#define  IO_PAD69_PIOCFG_PULL_SEL_SHIFT 15
#define  IO_PAD69_PIOCFG_PULL_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD69_PIOCFG_PULL_SEL_MASK) >> IO_PAD69_PIOCFG_PULL_SEL_SHIFT)
#define  IO_PAD69_PIOCFG_PULL_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD69_PIOCFG_PULL_SEL_MASK) | (((uint32_t)val) << IO_PAD69_PIOCFG_PULL_SEL_SHIFT))

#define  IO_PAD69_PIOCFG_PUEN_MASK 0x4000
#define  IO_PAD69_PIOCFG_PUEN_SHIFT 14
#define  IO_PAD69_PIOCFG_PUEN_MASK_SHIFT(reg) (((reg) & IO_PAD69_PIOCFG_PUEN_MASK) >> IO_PAD69_PIOCFG_PUEN_SHIFT)
#define  IO_PAD69_PIOCFG_PUEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD69_PIOCFG_PUEN_MASK) | (((uint32_t)val) << IO_PAD69_PIOCFG_PUEN_SHIFT))

#define  IO_PAD69_PIOCFG_PDEN_MASK 0x2000
#define  IO_PAD69_PIOCFG_PDEN_SHIFT 13
#define  IO_PAD69_PIOCFG_PDEN_MASK_SHIFT(reg) (((reg) & IO_PAD69_PIOCFG_PDEN_MASK) >> IO_PAD69_PIOCFG_PDEN_SHIFT)
#define  IO_PAD69_PIOCFG_PDEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD69_PIOCFG_PDEN_MASK) | (((uint32_t)val) << IO_PAD69_PIOCFG_PDEN_SHIFT))

#define  IO_PAD69_PIOCFG_SR_MASK 0x1800
#define  IO_PAD69_PIOCFG_SR_SHIFT 11
#define  IO_PAD69_PIOCFG_SR_MASK_SHIFT(reg) (((reg) & IO_PAD69_PIOCFG_SR_MASK) >> IO_PAD69_PIOCFG_SR_SHIFT)
#define  IO_PAD69_PIOCFG_SR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD69_PIOCFG_SR_MASK) | (((uint32_t)val) << IO_PAD69_PIOCFG_SR_SHIFT))

#define  IO_PAD69_PIOCFG_SLP_DI_MASK 0x400
#define  IO_PAD69_PIOCFG_SLP_DI_SHIFT 10
#define  IO_PAD69_PIOCFG_SLP_DI_MASK_SHIFT(reg) (((reg) & IO_PAD69_PIOCFG_SLP_DI_MASK) >> IO_PAD69_PIOCFG_SLP_DI_SHIFT)
#define  IO_PAD69_PIOCFG_SLP_DI_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD69_PIOCFG_SLP_DI_MASK) | (((uint32_t)val) << IO_PAD69_PIOCFG_SLP_DI_SHIFT))

#define  IO_PAD69_PIOCFG_SLP_CNTRL_MASK 0x200
#define  IO_PAD69_PIOCFG_SLP_CNTRL_SHIFT 9
#define  IO_PAD69_PIOCFG_SLP_CNTRL_MASK_SHIFT(reg) (((reg) & IO_PAD69_PIOCFG_SLP_CNTRL_MASK) >> IO_PAD69_PIOCFG_SLP_CNTRL_SHIFT)
#define  IO_PAD69_PIOCFG_SLP_CNTRL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD69_PIOCFG_SLP_CNTRL_MASK) | (((uint32_t)val) << IO_PAD69_PIOCFG_SLP_CNTRL_SHIFT))

#define  IO_PAD69_PIOCFG_SLP_DO_MASK 0x100
#define  IO_PAD69_PIOCFG_SLP_DO_SHIFT 8
#define  IO_PAD69_PIOCFG_SLP_DO_MASK_SHIFT(reg) (((reg) & IO_PAD69_PIOCFG_SLP_DO_MASK) >> IO_PAD69_PIOCFG_SLP_DO_SHIFT)
#define  IO_PAD69_PIOCFG_SLP_DO_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD69_PIOCFG_SLP_DO_MASK) | (((uint32_t)val) << IO_PAD69_PIOCFG_SLP_DO_SHIFT))

#define  IO_PAD69_PIOCFG_SLP_DIR_MASK 0x80
#define  IO_PAD69_PIOCFG_SLP_DIR_SHIFT 7
#define  IO_PAD69_PIOCFG_SLP_DIR_MASK_SHIFT(reg) (((reg) & IO_PAD69_PIOCFG_SLP_DIR_MASK) >> IO_PAD69_PIOCFG_SLP_DIR_SHIFT)
#define  IO_PAD69_PIOCFG_SLP_DIR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD69_PIOCFG_SLP_DIR_MASK) | (((uint32_t)val) << IO_PAD69_PIOCFG_SLP_DIR_SHIFT))

#define  IO_PAD69_PIOCFG_EDGE_EN_N_MASK 0x40
#define  IO_PAD69_PIOCFG_EDGE_EN_N_SHIFT 6
#define  IO_PAD69_PIOCFG_EDGE_EN_N_MASK_SHIFT(reg) (((reg) & IO_PAD69_PIOCFG_EDGE_EN_N_MASK) >> IO_PAD69_PIOCFG_EDGE_EN_N_SHIFT)
#define  IO_PAD69_PIOCFG_EDGE_EN_N_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD69_PIOCFG_EDGE_EN_N_MASK) | (((uint32_t)val) << IO_PAD69_PIOCFG_EDGE_EN_N_SHIFT))

#define  IO_PAD69_PIOCFG_EDGE_FALL_EN_MASK 0x20
#define  IO_PAD69_PIOCFG_EDGE_FALL_EN_SHIFT 5
#define  IO_PAD69_PIOCFG_EDGE_FALL_EN_MASK_SHIFT(reg) (((reg) & IO_PAD69_PIOCFG_EDGE_FALL_EN_MASK) >> IO_PAD69_PIOCFG_EDGE_FALL_EN_SHIFT)
#define  IO_PAD69_PIOCFG_EDGE_FALL_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD69_PIOCFG_EDGE_FALL_EN_MASK) | (((uint32_t)val) << IO_PAD69_PIOCFG_EDGE_FALL_EN_SHIFT))

#define  IO_PAD69_PIOCFG_EDGE_RISE_EN_MASK 0x10
#define  IO_PAD69_PIOCFG_EDGE_RISE_EN_SHIFT 4
#define  IO_PAD69_PIOCFG_EDGE_RISE_EN_MASK_SHIFT(reg) (((reg) & IO_PAD69_PIOCFG_EDGE_RISE_EN_MASK) >> IO_PAD69_PIOCFG_EDGE_RISE_EN_SHIFT)
#define  IO_PAD69_PIOCFG_EDGE_RISE_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD69_PIOCFG_EDGE_RISE_EN_MASK) | (((uint32_t)val) << IO_PAD69_PIOCFG_EDGE_RISE_EN_SHIFT))

#define  IO_PAD69_PIOCFG_SLP_SEL_MASK 0x8
#define  IO_PAD69_PIOCFG_SLP_SEL_SHIFT 3
#define  IO_PAD69_PIOCFG_SLP_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD69_PIOCFG_SLP_SEL_MASK) >> IO_PAD69_PIOCFG_SLP_SEL_SHIFT)
#define  IO_PAD69_PIOCFG_SLP_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD69_PIOCFG_SLP_SEL_MASK) | (((uint32_t)val) << IO_PAD69_PIOCFG_SLP_SEL_SHIFT))

#define  IO_PAD69_PIOCFG_FUNC_SEL_MASK 0x7
#define  IO_PAD69_PIOCFG_FUNC_SEL_SHIFT 0
#define  IO_PAD69_PIOCFG_FUNC_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD69_PIOCFG_FUNC_SEL_MASK) >> IO_PAD69_PIOCFG_FUNC_SEL_SHIFT)
#define  IO_PAD69_PIOCFG_FUNC_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD69_PIOCFG_FUNC_SEL_MASK) | (((uint32_t)val) << IO_PAD69_PIOCFG_FUNC_SEL_SHIFT))

//====================================================================
//
//Register File: IO_PAD70 Configuration Registers (IO_PAD70)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

//====================================================================
//Register: IO_PAD70 Configuration Register (PIOCFG)
/** \brief "PHI_PADXDC_IOB" Pad*/
//====================================================================

#define  IO_PAD70_PIOCFG_RESERVED1_MASK 0xfc000000
#define  IO_PAD70_PIOCFG_RESERVED1_SHIFT 26
#define  IO_PAD70_PIOCFG_RESERVED1_MASK_SHIFT(reg) (((reg) & IO_PAD70_PIOCFG_RESERVED1_MASK) >> IO_PAD70_PIOCFG_RESERVED1_SHIFT)
#define  IO_PAD70_PIOCFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD70_PIOCFG_RESERVED1_MASK) | (((uint32_t)val) << IO_PAD70_PIOCFG_RESERVED1_SHIFT))

#define  IO_PAD70_PIOCFG_PD_MASK 0x2000000
#define  IO_PAD70_PIOCFG_PD_SHIFT 25
#define  IO_PAD70_PIOCFG_PD_MASK_SHIFT(reg) (((reg) & IO_PAD70_PIOCFG_PD_MASK) >> IO_PAD70_PIOCFG_PD_SHIFT)
#define  IO_PAD70_PIOCFG_PD_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD70_PIOCFG_PD_MASK) | (((uint32_t)val) << IO_PAD70_PIOCFG_PD_SHIFT))

#define  IO_PAD70_PIOCFG_ODT_EN_MASK 0x1000000
#define  IO_PAD70_PIOCFG_ODT_EN_SHIFT 24
#define  IO_PAD70_PIOCFG_ODT_EN_MASK_SHIFT(reg) (((reg) & IO_PAD70_PIOCFG_ODT_EN_MASK) >> IO_PAD70_PIOCFG_ODT_EN_SHIFT)
#define  IO_PAD70_PIOCFG_ODT_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD70_PIOCFG_ODT_EN_MASK) | (((uint32_t)val) << IO_PAD70_PIOCFG_ODT_EN_SHIFT))

#define  IO_PAD70_PIOCFG_LED_EN_MASK 0x800000
#define  IO_PAD70_PIOCFG_LED_EN_SHIFT 23
#define  IO_PAD70_PIOCFG_LED_EN_MASK_SHIFT(reg) (((reg) & IO_PAD70_PIOCFG_LED_EN_MASK) >> IO_PAD70_PIOCFG_LED_EN_SHIFT)
#define  IO_PAD70_PIOCFG_LED_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD70_PIOCFG_LED_EN_MASK) | (((uint32_t)val) << IO_PAD70_PIOCFG_LED_EN_SHIFT))

#define  IO_PAD70_PIOCFG_I2C_SEL_MASK 0x600000
#define  IO_PAD70_PIOCFG_I2C_SEL_SHIFT 21
#define  IO_PAD70_PIOCFG_I2C_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD70_PIOCFG_I2C_SEL_MASK) >> IO_PAD70_PIOCFG_I2C_SEL_SHIFT)
#define  IO_PAD70_PIOCFG_I2C_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD70_PIOCFG_I2C_SEL_MASK) | (((uint32_t)val) << IO_PAD70_PIOCFG_I2C_SEL_SHIFT))

#define  IO_PAD70_PIOCFG_DGTBSEL_MASK 0x1e0000
#define  IO_PAD70_PIOCFG_DGTBSEL_SHIFT 17
#define  IO_PAD70_PIOCFG_DGTBSEL_MASK_SHIFT(reg) (((reg) & IO_PAD70_PIOCFG_DGTBSEL_MASK) >> IO_PAD70_PIOCFG_DGTBSEL_SHIFT)
#define  IO_PAD70_PIOCFG_DGTBSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD70_PIOCFG_DGTBSEL_MASK) | (((uint32_t)val) << IO_PAD70_PIOCFG_DGTBSEL_SHIFT))

#define  IO_PAD70_PIOCFG_RAWSEL_MASK 0x10000
#define  IO_PAD70_PIOCFG_RAWSEL_SHIFT 16
#define  IO_PAD70_PIOCFG_RAWSEL_MASK_SHIFT(reg) (((reg) & IO_PAD70_PIOCFG_RAWSEL_MASK) >> IO_PAD70_PIOCFG_RAWSEL_SHIFT)
#define  IO_PAD70_PIOCFG_RAWSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD70_PIOCFG_RAWSEL_MASK) | (((uint32_t)val) << IO_PAD70_PIOCFG_RAWSEL_SHIFT))

#define  IO_PAD70_PIOCFG_PULL_SEL_MASK 0x8000
#define  IO_PAD70_PIOCFG_PULL_SEL_SHIFT 15
#define  IO_PAD70_PIOCFG_PULL_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD70_PIOCFG_PULL_SEL_MASK) >> IO_PAD70_PIOCFG_PULL_SEL_SHIFT)
#define  IO_PAD70_PIOCFG_PULL_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD70_PIOCFG_PULL_SEL_MASK) | (((uint32_t)val) << IO_PAD70_PIOCFG_PULL_SEL_SHIFT))

#define  IO_PAD70_PIOCFG_PUEN_MASK 0x4000
#define  IO_PAD70_PIOCFG_PUEN_SHIFT 14
#define  IO_PAD70_PIOCFG_PUEN_MASK_SHIFT(reg) (((reg) & IO_PAD70_PIOCFG_PUEN_MASK) >> IO_PAD70_PIOCFG_PUEN_SHIFT)
#define  IO_PAD70_PIOCFG_PUEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD70_PIOCFG_PUEN_MASK) | (((uint32_t)val) << IO_PAD70_PIOCFG_PUEN_SHIFT))

#define  IO_PAD70_PIOCFG_PDEN_MASK 0x2000
#define  IO_PAD70_PIOCFG_PDEN_SHIFT 13
#define  IO_PAD70_PIOCFG_PDEN_MASK_SHIFT(reg) (((reg) & IO_PAD70_PIOCFG_PDEN_MASK) >> IO_PAD70_PIOCFG_PDEN_SHIFT)
#define  IO_PAD70_PIOCFG_PDEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD70_PIOCFG_PDEN_MASK) | (((uint32_t)val) << IO_PAD70_PIOCFG_PDEN_SHIFT))

#define  IO_PAD70_PIOCFG_SR_MASK 0x1800
#define  IO_PAD70_PIOCFG_SR_SHIFT 11
#define  IO_PAD70_PIOCFG_SR_MASK_SHIFT(reg) (((reg) & IO_PAD70_PIOCFG_SR_MASK) >> IO_PAD70_PIOCFG_SR_SHIFT)
#define  IO_PAD70_PIOCFG_SR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD70_PIOCFG_SR_MASK) | (((uint32_t)val) << IO_PAD70_PIOCFG_SR_SHIFT))

#define  IO_PAD70_PIOCFG_SLP_DI_MASK 0x400
#define  IO_PAD70_PIOCFG_SLP_DI_SHIFT 10
#define  IO_PAD70_PIOCFG_SLP_DI_MASK_SHIFT(reg) (((reg) & IO_PAD70_PIOCFG_SLP_DI_MASK) >> IO_PAD70_PIOCFG_SLP_DI_SHIFT)
#define  IO_PAD70_PIOCFG_SLP_DI_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD70_PIOCFG_SLP_DI_MASK) | (((uint32_t)val) << IO_PAD70_PIOCFG_SLP_DI_SHIFT))

#define  IO_PAD70_PIOCFG_SLP_CNTRL_MASK 0x200
#define  IO_PAD70_PIOCFG_SLP_CNTRL_SHIFT 9
#define  IO_PAD70_PIOCFG_SLP_CNTRL_MASK_SHIFT(reg) (((reg) & IO_PAD70_PIOCFG_SLP_CNTRL_MASK) >> IO_PAD70_PIOCFG_SLP_CNTRL_SHIFT)
#define  IO_PAD70_PIOCFG_SLP_CNTRL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD70_PIOCFG_SLP_CNTRL_MASK) | (((uint32_t)val) << IO_PAD70_PIOCFG_SLP_CNTRL_SHIFT))

#define  IO_PAD70_PIOCFG_SLP_DO_MASK 0x100
#define  IO_PAD70_PIOCFG_SLP_DO_SHIFT 8
#define  IO_PAD70_PIOCFG_SLP_DO_MASK_SHIFT(reg) (((reg) & IO_PAD70_PIOCFG_SLP_DO_MASK) >> IO_PAD70_PIOCFG_SLP_DO_SHIFT)
#define  IO_PAD70_PIOCFG_SLP_DO_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD70_PIOCFG_SLP_DO_MASK) | (((uint32_t)val) << IO_PAD70_PIOCFG_SLP_DO_SHIFT))

#define  IO_PAD70_PIOCFG_SLP_DIR_MASK 0x80
#define  IO_PAD70_PIOCFG_SLP_DIR_SHIFT 7
#define  IO_PAD70_PIOCFG_SLP_DIR_MASK_SHIFT(reg) (((reg) & IO_PAD70_PIOCFG_SLP_DIR_MASK) >> IO_PAD70_PIOCFG_SLP_DIR_SHIFT)
#define  IO_PAD70_PIOCFG_SLP_DIR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD70_PIOCFG_SLP_DIR_MASK) | (((uint32_t)val) << IO_PAD70_PIOCFG_SLP_DIR_SHIFT))

#define  IO_PAD70_PIOCFG_EDGE_EN_N_MASK 0x40
#define  IO_PAD70_PIOCFG_EDGE_EN_N_SHIFT 6
#define  IO_PAD70_PIOCFG_EDGE_EN_N_MASK_SHIFT(reg) (((reg) & IO_PAD70_PIOCFG_EDGE_EN_N_MASK) >> IO_PAD70_PIOCFG_EDGE_EN_N_SHIFT)
#define  IO_PAD70_PIOCFG_EDGE_EN_N_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD70_PIOCFG_EDGE_EN_N_MASK) | (((uint32_t)val) << IO_PAD70_PIOCFG_EDGE_EN_N_SHIFT))

#define  IO_PAD70_PIOCFG_EDGE_FALL_EN_MASK 0x20
#define  IO_PAD70_PIOCFG_EDGE_FALL_EN_SHIFT 5
#define  IO_PAD70_PIOCFG_EDGE_FALL_EN_MASK_SHIFT(reg) (((reg) & IO_PAD70_PIOCFG_EDGE_FALL_EN_MASK) >> IO_PAD70_PIOCFG_EDGE_FALL_EN_SHIFT)
#define  IO_PAD70_PIOCFG_EDGE_FALL_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD70_PIOCFG_EDGE_FALL_EN_MASK) | (((uint32_t)val) << IO_PAD70_PIOCFG_EDGE_FALL_EN_SHIFT))

#define  IO_PAD70_PIOCFG_EDGE_RISE_EN_MASK 0x10
#define  IO_PAD70_PIOCFG_EDGE_RISE_EN_SHIFT 4
#define  IO_PAD70_PIOCFG_EDGE_RISE_EN_MASK_SHIFT(reg) (((reg) & IO_PAD70_PIOCFG_EDGE_RISE_EN_MASK) >> IO_PAD70_PIOCFG_EDGE_RISE_EN_SHIFT)
#define  IO_PAD70_PIOCFG_EDGE_RISE_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD70_PIOCFG_EDGE_RISE_EN_MASK) | (((uint32_t)val) << IO_PAD70_PIOCFG_EDGE_RISE_EN_SHIFT))

#define  IO_PAD70_PIOCFG_SLP_SEL_MASK 0x8
#define  IO_PAD70_PIOCFG_SLP_SEL_SHIFT 3
#define  IO_PAD70_PIOCFG_SLP_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD70_PIOCFG_SLP_SEL_MASK) >> IO_PAD70_PIOCFG_SLP_SEL_SHIFT)
#define  IO_PAD70_PIOCFG_SLP_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD70_PIOCFG_SLP_SEL_MASK) | (((uint32_t)val) << IO_PAD70_PIOCFG_SLP_SEL_SHIFT))

#define  IO_PAD70_PIOCFG_FUNC_SEL_MASK 0x7
#define  IO_PAD70_PIOCFG_FUNC_SEL_SHIFT 0
#define  IO_PAD70_PIOCFG_FUNC_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD70_PIOCFG_FUNC_SEL_MASK) >> IO_PAD70_PIOCFG_FUNC_SEL_SHIFT)
#define  IO_PAD70_PIOCFG_FUNC_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD70_PIOCFG_FUNC_SEL_MASK) | (((uint32_t)val) << IO_PAD70_PIOCFG_FUNC_SEL_SHIFT))

//====================================================================
//
//Register File: IO_PAD71 Configuration Registers (IO_PAD71)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

//====================================================================
//Register: IO_PAD71 Configuration Register (PIOCFG)
/** \brief "PHI_PADXDC_IOB" Pad*/
//====================================================================

#define  IO_PAD71_PIOCFG_RESERVED1_MASK 0xfc000000
#define  IO_PAD71_PIOCFG_RESERVED1_SHIFT 26
#define  IO_PAD71_PIOCFG_RESERVED1_MASK_SHIFT(reg) (((reg) & IO_PAD71_PIOCFG_RESERVED1_MASK) >> IO_PAD71_PIOCFG_RESERVED1_SHIFT)
#define  IO_PAD71_PIOCFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD71_PIOCFG_RESERVED1_MASK) | (((uint32_t)val) << IO_PAD71_PIOCFG_RESERVED1_SHIFT))

#define  IO_PAD71_PIOCFG_PD_MASK 0x2000000
#define  IO_PAD71_PIOCFG_PD_SHIFT 25
#define  IO_PAD71_PIOCFG_PD_MASK_SHIFT(reg) (((reg) & IO_PAD71_PIOCFG_PD_MASK) >> IO_PAD71_PIOCFG_PD_SHIFT)
#define  IO_PAD71_PIOCFG_PD_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD71_PIOCFG_PD_MASK) | (((uint32_t)val) << IO_PAD71_PIOCFG_PD_SHIFT))

#define  IO_PAD71_PIOCFG_ODT_EN_MASK 0x1000000
#define  IO_PAD71_PIOCFG_ODT_EN_SHIFT 24
#define  IO_PAD71_PIOCFG_ODT_EN_MASK_SHIFT(reg) (((reg) & IO_PAD71_PIOCFG_ODT_EN_MASK) >> IO_PAD71_PIOCFG_ODT_EN_SHIFT)
#define  IO_PAD71_PIOCFG_ODT_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD71_PIOCFG_ODT_EN_MASK) | (((uint32_t)val) << IO_PAD71_PIOCFG_ODT_EN_SHIFT))

#define  IO_PAD71_PIOCFG_LED_EN_MASK 0x800000
#define  IO_PAD71_PIOCFG_LED_EN_SHIFT 23
#define  IO_PAD71_PIOCFG_LED_EN_MASK_SHIFT(reg) (((reg) & IO_PAD71_PIOCFG_LED_EN_MASK) >> IO_PAD71_PIOCFG_LED_EN_SHIFT)
#define  IO_PAD71_PIOCFG_LED_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD71_PIOCFG_LED_EN_MASK) | (((uint32_t)val) << IO_PAD71_PIOCFG_LED_EN_SHIFT))

#define  IO_PAD71_PIOCFG_I2C_SEL_MASK 0x600000
#define  IO_PAD71_PIOCFG_I2C_SEL_SHIFT 21
#define  IO_PAD71_PIOCFG_I2C_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD71_PIOCFG_I2C_SEL_MASK) >> IO_PAD71_PIOCFG_I2C_SEL_SHIFT)
#define  IO_PAD71_PIOCFG_I2C_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD71_PIOCFG_I2C_SEL_MASK) | (((uint32_t)val) << IO_PAD71_PIOCFG_I2C_SEL_SHIFT))

#define  IO_PAD71_PIOCFG_DGTBSEL_MASK 0x1e0000
#define  IO_PAD71_PIOCFG_DGTBSEL_SHIFT 17
#define  IO_PAD71_PIOCFG_DGTBSEL_MASK_SHIFT(reg) (((reg) & IO_PAD71_PIOCFG_DGTBSEL_MASK) >> IO_PAD71_PIOCFG_DGTBSEL_SHIFT)
#define  IO_PAD71_PIOCFG_DGTBSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD71_PIOCFG_DGTBSEL_MASK) | (((uint32_t)val) << IO_PAD71_PIOCFG_DGTBSEL_SHIFT))

#define  IO_PAD71_PIOCFG_RAWSEL_MASK 0x10000
#define  IO_PAD71_PIOCFG_RAWSEL_SHIFT 16
#define  IO_PAD71_PIOCFG_RAWSEL_MASK_SHIFT(reg) (((reg) & IO_PAD71_PIOCFG_RAWSEL_MASK) >> IO_PAD71_PIOCFG_RAWSEL_SHIFT)
#define  IO_PAD71_PIOCFG_RAWSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD71_PIOCFG_RAWSEL_MASK) | (((uint32_t)val) << IO_PAD71_PIOCFG_RAWSEL_SHIFT))

#define  IO_PAD71_PIOCFG_PULL_SEL_MASK 0x8000
#define  IO_PAD71_PIOCFG_PULL_SEL_SHIFT 15
#define  IO_PAD71_PIOCFG_PULL_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD71_PIOCFG_PULL_SEL_MASK) >> IO_PAD71_PIOCFG_PULL_SEL_SHIFT)
#define  IO_PAD71_PIOCFG_PULL_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD71_PIOCFG_PULL_SEL_MASK) | (((uint32_t)val) << IO_PAD71_PIOCFG_PULL_SEL_SHIFT))

#define  IO_PAD71_PIOCFG_PUEN_MASK 0x4000
#define  IO_PAD71_PIOCFG_PUEN_SHIFT 14
#define  IO_PAD71_PIOCFG_PUEN_MASK_SHIFT(reg) (((reg) & IO_PAD71_PIOCFG_PUEN_MASK) >> IO_PAD71_PIOCFG_PUEN_SHIFT)
#define  IO_PAD71_PIOCFG_PUEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD71_PIOCFG_PUEN_MASK) | (((uint32_t)val) << IO_PAD71_PIOCFG_PUEN_SHIFT))

#define  IO_PAD71_PIOCFG_PDEN_MASK 0x2000
#define  IO_PAD71_PIOCFG_PDEN_SHIFT 13
#define  IO_PAD71_PIOCFG_PDEN_MASK_SHIFT(reg) (((reg) & IO_PAD71_PIOCFG_PDEN_MASK) >> IO_PAD71_PIOCFG_PDEN_SHIFT)
#define  IO_PAD71_PIOCFG_PDEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD71_PIOCFG_PDEN_MASK) | (((uint32_t)val) << IO_PAD71_PIOCFG_PDEN_SHIFT))

#define  IO_PAD71_PIOCFG_SR_MASK 0x1800
#define  IO_PAD71_PIOCFG_SR_SHIFT 11
#define  IO_PAD71_PIOCFG_SR_MASK_SHIFT(reg) (((reg) & IO_PAD71_PIOCFG_SR_MASK) >> IO_PAD71_PIOCFG_SR_SHIFT)
#define  IO_PAD71_PIOCFG_SR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD71_PIOCFG_SR_MASK) | (((uint32_t)val) << IO_PAD71_PIOCFG_SR_SHIFT))

#define  IO_PAD71_PIOCFG_SLP_DI_MASK 0x400
#define  IO_PAD71_PIOCFG_SLP_DI_SHIFT 10
#define  IO_PAD71_PIOCFG_SLP_DI_MASK_SHIFT(reg) (((reg) & IO_PAD71_PIOCFG_SLP_DI_MASK) >> IO_PAD71_PIOCFG_SLP_DI_SHIFT)
#define  IO_PAD71_PIOCFG_SLP_DI_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD71_PIOCFG_SLP_DI_MASK) | (((uint32_t)val) << IO_PAD71_PIOCFG_SLP_DI_SHIFT))

#define  IO_PAD71_PIOCFG_SLP_CNTRL_MASK 0x200
#define  IO_PAD71_PIOCFG_SLP_CNTRL_SHIFT 9
#define  IO_PAD71_PIOCFG_SLP_CNTRL_MASK_SHIFT(reg) (((reg) & IO_PAD71_PIOCFG_SLP_CNTRL_MASK) >> IO_PAD71_PIOCFG_SLP_CNTRL_SHIFT)
#define  IO_PAD71_PIOCFG_SLP_CNTRL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD71_PIOCFG_SLP_CNTRL_MASK) | (((uint32_t)val) << IO_PAD71_PIOCFG_SLP_CNTRL_SHIFT))

#define  IO_PAD71_PIOCFG_SLP_DO_MASK 0x100
#define  IO_PAD71_PIOCFG_SLP_DO_SHIFT 8
#define  IO_PAD71_PIOCFG_SLP_DO_MASK_SHIFT(reg) (((reg) & IO_PAD71_PIOCFG_SLP_DO_MASK) >> IO_PAD71_PIOCFG_SLP_DO_SHIFT)
#define  IO_PAD71_PIOCFG_SLP_DO_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD71_PIOCFG_SLP_DO_MASK) | (((uint32_t)val) << IO_PAD71_PIOCFG_SLP_DO_SHIFT))

#define  IO_PAD71_PIOCFG_SLP_DIR_MASK 0x80
#define  IO_PAD71_PIOCFG_SLP_DIR_SHIFT 7
#define  IO_PAD71_PIOCFG_SLP_DIR_MASK_SHIFT(reg) (((reg) & IO_PAD71_PIOCFG_SLP_DIR_MASK) >> IO_PAD71_PIOCFG_SLP_DIR_SHIFT)
#define  IO_PAD71_PIOCFG_SLP_DIR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD71_PIOCFG_SLP_DIR_MASK) | (((uint32_t)val) << IO_PAD71_PIOCFG_SLP_DIR_SHIFT))

#define  IO_PAD71_PIOCFG_EDGE_EN_N_MASK 0x40
#define  IO_PAD71_PIOCFG_EDGE_EN_N_SHIFT 6
#define  IO_PAD71_PIOCFG_EDGE_EN_N_MASK_SHIFT(reg) (((reg) & IO_PAD71_PIOCFG_EDGE_EN_N_MASK) >> IO_PAD71_PIOCFG_EDGE_EN_N_SHIFT)
#define  IO_PAD71_PIOCFG_EDGE_EN_N_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD71_PIOCFG_EDGE_EN_N_MASK) | (((uint32_t)val) << IO_PAD71_PIOCFG_EDGE_EN_N_SHIFT))

#define  IO_PAD71_PIOCFG_EDGE_FALL_EN_MASK 0x20
#define  IO_PAD71_PIOCFG_EDGE_FALL_EN_SHIFT 5
#define  IO_PAD71_PIOCFG_EDGE_FALL_EN_MASK_SHIFT(reg) (((reg) & IO_PAD71_PIOCFG_EDGE_FALL_EN_MASK) >> IO_PAD71_PIOCFG_EDGE_FALL_EN_SHIFT)
#define  IO_PAD71_PIOCFG_EDGE_FALL_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD71_PIOCFG_EDGE_FALL_EN_MASK) | (((uint32_t)val) << IO_PAD71_PIOCFG_EDGE_FALL_EN_SHIFT))

#define  IO_PAD71_PIOCFG_EDGE_RISE_EN_MASK 0x10
#define  IO_PAD71_PIOCFG_EDGE_RISE_EN_SHIFT 4
#define  IO_PAD71_PIOCFG_EDGE_RISE_EN_MASK_SHIFT(reg) (((reg) & IO_PAD71_PIOCFG_EDGE_RISE_EN_MASK) >> IO_PAD71_PIOCFG_EDGE_RISE_EN_SHIFT)
#define  IO_PAD71_PIOCFG_EDGE_RISE_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD71_PIOCFG_EDGE_RISE_EN_MASK) | (((uint32_t)val) << IO_PAD71_PIOCFG_EDGE_RISE_EN_SHIFT))

#define  IO_PAD71_PIOCFG_SLP_SEL_MASK 0x8
#define  IO_PAD71_PIOCFG_SLP_SEL_SHIFT 3
#define  IO_PAD71_PIOCFG_SLP_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD71_PIOCFG_SLP_SEL_MASK) >> IO_PAD71_PIOCFG_SLP_SEL_SHIFT)
#define  IO_PAD71_PIOCFG_SLP_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD71_PIOCFG_SLP_SEL_MASK) | (((uint32_t)val) << IO_PAD71_PIOCFG_SLP_SEL_SHIFT))

#define  IO_PAD71_PIOCFG_FUNC_SEL_MASK 0x7
#define  IO_PAD71_PIOCFG_FUNC_SEL_SHIFT 0
#define  IO_PAD71_PIOCFG_FUNC_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD71_PIOCFG_FUNC_SEL_MASK) >> IO_PAD71_PIOCFG_FUNC_SEL_SHIFT)
#define  IO_PAD71_PIOCFG_FUNC_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD71_PIOCFG_FUNC_SEL_MASK) | (((uint32_t)val) << IO_PAD71_PIOCFG_FUNC_SEL_SHIFT))

//====================================================================
//
//Register File: IO_PAD72 Configuration Registers (IO_PAD72)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

//====================================================================
//Register: IO_PAD72 Configuration Register (PIOCFG)
/** \brief "PHI_PADXDC_IOB" Pad*/
//====================================================================

#define  IO_PAD72_PIOCFG_RESERVED1_MASK 0xfc000000
#define  IO_PAD72_PIOCFG_RESERVED1_SHIFT 26
#define  IO_PAD72_PIOCFG_RESERVED1_MASK_SHIFT(reg) (((reg) & IO_PAD72_PIOCFG_RESERVED1_MASK) >> IO_PAD72_PIOCFG_RESERVED1_SHIFT)
#define  IO_PAD72_PIOCFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD72_PIOCFG_RESERVED1_MASK) | (((uint32_t)val) << IO_PAD72_PIOCFG_RESERVED1_SHIFT))

#define  IO_PAD72_PIOCFG_PD_MASK 0x2000000
#define  IO_PAD72_PIOCFG_PD_SHIFT 25
#define  IO_PAD72_PIOCFG_PD_MASK_SHIFT(reg) (((reg) & IO_PAD72_PIOCFG_PD_MASK) >> IO_PAD72_PIOCFG_PD_SHIFT)
#define  IO_PAD72_PIOCFG_PD_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD72_PIOCFG_PD_MASK) | (((uint32_t)val) << IO_PAD72_PIOCFG_PD_SHIFT))

#define  IO_PAD72_PIOCFG_ODT_EN_MASK 0x1000000
#define  IO_PAD72_PIOCFG_ODT_EN_SHIFT 24
#define  IO_PAD72_PIOCFG_ODT_EN_MASK_SHIFT(reg) (((reg) & IO_PAD72_PIOCFG_ODT_EN_MASK) >> IO_PAD72_PIOCFG_ODT_EN_SHIFT)
#define  IO_PAD72_PIOCFG_ODT_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD72_PIOCFG_ODT_EN_MASK) | (((uint32_t)val) << IO_PAD72_PIOCFG_ODT_EN_SHIFT))

#define  IO_PAD72_PIOCFG_LED_EN_MASK 0x800000
#define  IO_PAD72_PIOCFG_LED_EN_SHIFT 23
#define  IO_PAD72_PIOCFG_LED_EN_MASK_SHIFT(reg) (((reg) & IO_PAD72_PIOCFG_LED_EN_MASK) >> IO_PAD72_PIOCFG_LED_EN_SHIFT)
#define  IO_PAD72_PIOCFG_LED_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD72_PIOCFG_LED_EN_MASK) | (((uint32_t)val) << IO_PAD72_PIOCFG_LED_EN_SHIFT))

#define  IO_PAD72_PIOCFG_I2C_SEL_MASK 0x600000
#define  IO_PAD72_PIOCFG_I2C_SEL_SHIFT 21
#define  IO_PAD72_PIOCFG_I2C_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD72_PIOCFG_I2C_SEL_MASK) >> IO_PAD72_PIOCFG_I2C_SEL_SHIFT)
#define  IO_PAD72_PIOCFG_I2C_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD72_PIOCFG_I2C_SEL_MASK) | (((uint32_t)val) << IO_PAD72_PIOCFG_I2C_SEL_SHIFT))

#define  IO_PAD72_PIOCFG_DGTBSEL_MASK 0x1e0000
#define  IO_PAD72_PIOCFG_DGTBSEL_SHIFT 17
#define  IO_PAD72_PIOCFG_DGTBSEL_MASK_SHIFT(reg) (((reg) & IO_PAD72_PIOCFG_DGTBSEL_MASK) >> IO_PAD72_PIOCFG_DGTBSEL_SHIFT)
#define  IO_PAD72_PIOCFG_DGTBSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD72_PIOCFG_DGTBSEL_MASK) | (((uint32_t)val) << IO_PAD72_PIOCFG_DGTBSEL_SHIFT))

#define  IO_PAD72_PIOCFG_RAWSEL_MASK 0x10000
#define  IO_PAD72_PIOCFG_RAWSEL_SHIFT 16
#define  IO_PAD72_PIOCFG_RAWSEL_MASK_SHIFT(reg) (((reg) & IO_PAD72_PIOCFG_RAWSEL_MASK) >> IO_PAD72_PIOCFG_RAWSEL_SHIFT)
#define  IO_PAD72_PIOCFG_RAWSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD72_PIOCFG_RAWSEL_MASK) | (((uint32_t)val) << IO_PAD72_PIOCFG_RAWSEL_SHIFT))

#define  IO_PAD72_PIOCFG_PULL_SEL_MASK 0x8000
#define  IO_PAD72_PIOCFG_PULL_SEL_SHIFT 15
#define  IO_PAD72_PIOCFG_PULL_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD72_PIOCFG_PULL_SEL_MASK) >> IO_PAD72_PIOCFG_PULL_SEL_SHIFT)
#define  IO_PAD72_PIOCFG_PULL_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD72_PIOCFG_PULL_SEL_MASK) | (((uint32_t)val) << IO_PAD72_PIOCFG_PULL_SEL_SHIFT))

#define  IO_PAD72_PIOCFG_PUEN_MASK 0x4000
#define  IO_PAD72_PIOCFG_PUEN_SHIFT 14
#define  IO_PAD72_PIOCFG_PUEN_MASK_SHIFT(reg) (((reg) & IO_PAD72_PIOCFG_PUEN_MASK) >> IO_PAD72_PIOCFG_PUEN_SHIFT)
#define  IO_PAD72_PIOCFG_PUEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD72_PIOCFG_PUEN_MASK) | (((uint32_t)val) << IO_PAD72_PIOCFG_PUEN_SHIFT))

#define  IO_PAD72_PIOCFG_PDEN_MASK 0x2000
#define  IO_PAD72_PIOCFG_PDEN_SHIFT 13
#define  IO_PAD72_PIOCFG_PDEN_MASK_SHIFT(reg) (((reg) & IO_PAD72_PIOCFG_PDEN_MASK) >> IO_PAD72_PIOCFG_PDEN_SHIFT)
#define  IO_PAD72_PIOCFG_PDEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD72_PIOCFG_PDEN_MASK) | (((uint32_t)val) << IO_PAD72_PIOCFG_PDEN_SHIFT))

#define  IO_PAD72_PIOCFG_SR_MASK 0x1800
#define  IO_PAD72_PIOCFG_SR_SHIFT 11
#define  IO_PAD72_PIOCFG_SR_MASK_SHIFT(reg) (((reg) & IO_PAD72_PIOCFG_SR_MASK) >> IO_PAD72_PIOCFG_SR_SHIFT)
#define  IO_PAD72_PIOCFG_SR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD72_PIOCFG_SR_MASK) | (((uint32_t)val) << IO_PAD72_PIOCFG_SR_SHIFT))

#define  IO_PAD72_PIOCFG_SLP_DI_MASK 0x400
#define  IO_PAD72_PIOCFG_SLP_DI_SHIFT 10
#define  IO_PAD72_PIOCFG_SLP_DI_MASK_SHIFT(reg) (((reg) & IO_PAD72_PIOCFG_SLP_DI_MASK) >> IO_PAD72_PIOCFG_SLP_DI_SHIFT)
#define  IO_PAD72_PIOCFG_SLP_DI_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD72_PIOCFG_SLP_DI_MASK) | (((uint32_t)val) << IO_PAD72_PIOCFG_SLP_DI_SHIFT))

#define  IO_PAD72_PIOCFG_SLP_CNTRL_MASK 0x200
#define  IO_PAD72_PIOCFG_SLP_CNTRL_SHIFT 9
#define  IO_PAD72_PIOCFG_SLP_CNTRL_MASK_SHIFT(reg) (((reg) & IO_PAD72_PIOCFG_SLP_CNTRL_MASK) >> IO_PAD72_PIOCFG_SLP_CNTRL_SHIFT)
#define  IO_PAD72_PIOCFG_SLP_CNTRL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD72_PIOCFG_SLP_CNTRL_MASK) | (((uint32_t)val) << IO_PAD72_PIOCFG_SLP_CNTRL_SHIFT))

#define  IO_PAD72_PIOCFG_SLP_DO_MASK 0x100
#define  IO_PAD72_PIOCFG_SLP_DO_SHIFT 8
#define  IO_PAD72_PIOCFG_SLP_DO_MASK_SHIFT(reg) (((reg) & IO_PAD72_PIOCFG_SLP_DO_MASK) >> IO_PAD72_PIOCFG_SLP_DO_SHIFT)
#define  IO_PAD72_PIOCFG_SLP_DO_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD72_PIOCFG_SLP_DO_MASK) | (((uint32_t)val) << IO_PAD72_PIOCFG_SLP_DO_SHIFT))

#define  IO_PAD72_PIOCFG_SLP_DIR_MASK 0x80
#define  IO_PAD72_PIOCFG_SLP_DIR_SHIFT 7
#define  IO_PAD72_PIOCFG_SLP_DIR_MASK_SHIFT(reg) (((reg) & IO_PAD72_PIOCFG_SLP_DIR_MASK) >> IO_PAD72_PIOCFG_SLP_DIR_SHIFT)
#define  IO_PAD72_PIOCFG_SLP_DIR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD72_PIOCFG_SLP_DIR_MASK) | (((uint32_t)val) << IO_PAD72_PIOCFG_SLP_DIR_SHIFT))

#define  IO_PAD72_PIOCFG_EDGE_EN_N_MASK 0x40
#define  IO_PAD72_PIOCFG_EDGE_EN_N_SHIFT 6
#define  IO_PAD72_PIOCFG_EDGE_EN_N_MASK_SHIFT(reg) (((reg) & IO_PAD72_PIOCFG_EDGE_EN_N_MASK) >> IO_PAD72_PIOCFG_EDGE_EN_N_SHIFT)
#define  IO_PAD72_PIOCFG_EDGE_EN_N_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD72_PIOCFG_EDGE_EN_N_MASK) | (((uint32_t)val) << IO_PAD72_PIOCFG_EDGE_EN_N_SHIFT))

#define  IO_PAD72_PIOCFG_EDGE_FALL_EN_MASK 0x20
#define  IO_PAD72_PIOCFG_EDGE_FALL_EN_SHIFT 5
#define  IO_PAD72_PIOCFG_EDGE_FALL_EN_MASK_SHIFT(reg) (((reg) & IO_PAD72_PIOCFG_EDGE_FALL_EN_MASK) >> IO_PAD72_PIOCFG_EDGE_FALL_EN_SHIFT)
#define  IO_PAD72_PIOCFG_EDGE_FALL_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD72_PIOCFG_EDGE_FALL_EN_MASK) | (((uint32_t)val) << IO_PAD72_PIOCFG_EDGE_FALL_EN_SHIFT))

#define  IO_PAD72_PIOCFG_EDGE_RISE_EN_MASK 0x10
#define  IO_PAD72_PIOCFG_EDGE_RISE_EN_SHIFT 4
#define  IO_PAD72_PIOCFG_EDGE_RISE_EN_MASK_SHIFT(reg) (((reg) & IO_PAD72_PIOCFG_EDGE_RISE_EN_MASK) >> IO_PAD72_PIOCFG_EDGE_RISE_EN_SHIFT)
#define  IO_PAD72_PIOCFG_EDGE_RISE_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD72_PIOCFG_EDGE_RISE_EN_MASK) | (((uint32_t)val) << IO_PAD72_PIOCFG_EDGE_RISE_EN_SHIFT))

#define  IO_PAD72_PIOCFG_SLP_SEL_MASK 0x8
#define  IO_PAD72_PIOCFG_SLP_SEL_SHIFT 3
#define  IO_PAD72_PIOCFG_SLP_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD72_PIOCFG_SLP_SEL_MASK) >> IO_PAD72_PIOCFG_SLP_SEL_SHIFT)
#define  IO_PAD72_PIOCFG_SLP_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD72_PIOCFG_SLP_SEL_MASK) | (((uint32_t)val) << IO_PAD72_PIOCFG_SLP_SEL_SHIFT))

#define  IO_PAD72_PIOCFG_FUNC_SEL_MASK 0x7
#define  IO_PAD72_PIOCFG_FUNC_SEL_SHIFT 0
#define  IO_PAD72_PIOCFG_FUNC_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD72_PIOCFG_FUNC_SEL_MASK) >> IO_PAD72_PIOCFG_FUNC_SEL_SHIFT)
#define  IO_PAD72_PIOCFG_FUNC_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD72_PIOCFG_FUNC_SEL_MASK) | (((uint32_t)val) << IO_PAD72_PIOCFG_FUNC_SEL_SHIFT))

//====================================================================
//
//Register File: IO_PAD73 Configuration Registers (IO_PAD73)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

//====================================================================
//Register: IO_PAD73 Configuration Register (PIOCFG)
/** \brief "PHI_PADXDC_IOB" Pad*/
//====================================================================

#define  IO_PAD73_PIOCFG_RESERVED1_MASK 0xfc000000
#define  IO_PAD73_PIOCFG_RESERVED1_SHIFT 26
#define  IO_PAD73_PIOCFG_RESERVED1_MASK_SHIFT(reg) (((reg) & IO_PAD73_PIOCFG_RESERVED1_MASK) >> IO_PAD73_PIOCFG_RESERVED1_SHIFT)
#define  IO_PAD73_PIOCFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD73_PIOCFG_RESERVED1_MASK) | (((uint32_t)val) << IO_PAD73_PIOCFG_RESERVED1_SHIFT))

#define  IO_PAD73_PIOCFG_PD_MASK 0x2000000
#define  IO_PAD73_PIOCFG_PD_SHIFT 25
#define  IO_PAD73_PIOCFG_PD_MASK_SHIFT(reg) (((reg) & IO_PAD73_PIOCFG_PD_MASK) >> IO_PAD73_PIOCFG_PD_SHIFT)
#define  IO_PAD73_PIOCFG_PD_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD73_PIOCFG_PD_MASK) | (((uint32_t)val) << IO_PAD73_PIOCFG_PD_SHIFT))

#define  IO_PAD73_PIOCFG_ODT_EN_MASK 0x1000000
#define  IO_PAD73_PIOCFG_ODT_EN_SHIFT 24
#define  IO_PAD73_PIOCFG_ODT_EN_MASK_SHIFT(reg) (((reg) & IO_PAD73_PIOCFG_ODT_EN_MASK) >> IO_PAD73_PIOCFG_ODT_EN_SHIFT)
#define  IO_PAD73_PIOCFG_ODT_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD73_PIOCFG_ODT_EN_MASK) | (((uint32_t)val) << IO_PAD73_PIOCFG_ODT_EN_SHIFT))

#define  IO_PAD73_PIOCFG_LED_EN_MASK 0x800000
#define  IO_PAD73_PIOCFG_LED_EN_SHIFT 23
#define  IO_PAD73_PIOCFG_LED_EN_MASK_SHIFT(reg) (((reg) & IO_PAD73_PIOCFG_LED_EN_MASK) >> IO_PAD73_PIOCFG_LED_EN_SHIFT)
#define  IO_PAD73_PIOCFG_LED_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD73_PIOCFG_LED_EN_MASK) | (((uint32_t)val) << IO_PAD73_PIOCFG_LED_EN_SHIFT))

#define  IO_PAD73_PIOCFG_I2C_SEL_MASK 0x600000
#define  IO_PAD73_PIOCFG_I2C_SEL_SHIFT 21
#define  IO_PAD73_PIOCFG_I2C_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD73_PIOCFG_I2C_SEL_MASK) >> IO_PAD73_PIOCFG_I2C_SEL_SHIFT)
#define  IO_PAD73_PIOCFG_I2C_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD73_PIOCFG_I2C_SEL_MASK) | (((uint32_t)val) << IO_PAD73_PIOCFG_I2C_SEL_SHIFT))

#define  IO_PAD73_PIOCFG_DGTBSEL_MASK 0x1e0000
#define  IO_PAD73_PIOCFG_DGTBSEL_SHIFT 17
#define  IO_PAD73_PIOCFG_DGTBSEL_MASK_SHIFT(reg) (((reg) & IO_PAD73_PIOCFG_DGTBSEL_MASK) >> IO_PAD73_PIOCFG_DGTBSEL_SHIFT)
#define  IO_PAD73_PIOCFG_DGTBSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD73_PIOCFG_DGTBSEL_MASK) | (((uint32_t)val) << IO_PAD73_PIOCFG_DGTBSEL_SHIFT))

#define  IO_PAD73_PIOCFG_RAWSEL_MASK 0x10000
#define  IO_PAD73_PIOCFG_RAWSEL_SHIFT 16
#define  IO_PAD73_PIOCFG_RAWSEL_MASK_SHIFT(reg) (((reg) & IO_PAD73_PIOCFG_RAWSEL_MASK) >> IO_PAD73_PIOCFG_RAWSEL_SHIFT)
#define  IO_PAD73_PIOCFG_RAWSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD73_PIOCFG_RAWSEL_MASK) | (((uint32_t)val) << IO_PAD73_PIOCFG_RAWSEL_SHIFT))

#define  IO_PAD73_PIOCFG_PULL_SEL_MASK 0x8000
#define  IO_PAD73_PIOCFG_PULL_SEL_SHIFT 15
#define  IO_PAD73_PIOCFG_PULL_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD73_PIOCFG_PULL_SEL_MASK) >> IO_PAD73_PIOCFG_PULL_SEL_SHIFT)
#define  IO_PAD73_PIOCFG_PULL_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD73_PIOCFG_PULL_SEL_MASK) | (((uint32_t)val) << IO_PAD73_PIOCFG_PULL_SEL_SHIFT))

#define  IO_PAD73_PIOCFG_PUEN_MASK 0x4000
#define  IO_PAD73_PIOCFG_PUEN_SHIFT 14
#define  IO_PAD73_PIOCFG_PUEN_MASK_SHIFT(reg) (((reg) & IO_PAD73_PIOCFG_PUEN_MASK) >> IO_PAD73_PIOCFG_PUEN_SHIFT)
#define  IO_PAD73_PIOCFG_PUEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD73_PIOCFG_PUEN_MASK) | (((uint32_t)val) << IO_PAD73_PIOCFG_PUEN_SHIFT))

#define  IO_PAD73_PIOCFG_PDEN_MASK 0x2000
#define  IO_PAD73_PIOCFG_PDEN_SHIFT 13
#define  IO_PAD73_PIOCFG_PDEN_MASK_SHIFT(reg) (((reg) & IO_PAD73_PIOCFG_PDEN_MASK) >> IO_PAD73_PIOCFG_PDEN_SHIFT)
#define  IO_PAD73_PIOCFG_PDEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD73_PIOCFG_PDEN_MASK) | (((uint32_t)val) << IO_PAD73_PIOCFG_PDEN_SHIFT))

#define  IO_PAD73_PIOCFG_SR_MASK 0x1800
#define  IO_PAD73_PIOCFG_SR_SHIFT 11
#define  IO_PAD73_PIOCFG_SR_MASK_SHIFT(reg) (((reg) & IO_PAD73_PIOCFG_SR_MASK) >> IO_PAD73_PIOCFG_SR_SHIFT)
#define  IO_PAD73_PIOCFG_SR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD73_PIOCFG_SR_MASK) | (((uint32_t)val) << IO_PAD73_PIOCFG_SR_SHIFT))

#define  IO_PAD73_PIOCFG_SLP_DI_MASK 0x400
#define  IO_PAD73_PIOCFG_SLP_DI_SHIFT 10
#define  IO_PAD73_PIOCFG_SLP_DI_MASK_SHIFT(reg) (((reg) & IO_PAD73_PIOCFG_SLP_DI_MASK) >> IO_PAD73_PIOCFG_SLP_DI_SHIFT)
#define  IO_PAD73_PIOCFG_SLP_DI_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD73_PIOCFG_SLP_DI_MASK) | (((uint32_t)val) << IO_PAD73_PIOCFG_SLP_DI_SHIFT))

#define  IO_PAD73_PIOCFG_SLP_CNTRL_MASK 0x200
#define  IO_PAD73_PIOCFG_SLP_CNTRL_SHIFT 9
#define  IO_PAD73_PIOCFG_SLP_CNTRL_MASK_SHIFT(reg) (((reg) & IO_PAD73_PIOCFG_SLP_CNTRL_MASK) >> IO_PAD73_PIOCFG_SLP_CNTRL_SHIFT)
#define  IO_PAD73_PIOCFG_SLP_CNTRL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD73_PIOCFG_SLP_CNTRL_MASK) | (((uint32_t)val) << IO_PAD73_PIOCFG_SLP_CNTRL_SHIFT))

#define  IO_PAD73_PIOCFG_SLP_DO_MASK 0x100
#define  IO_PAD73_PIOCFG_SLP_DO_SHIFT 8
#define  IO_PAD73_PIOCFG_SLP_DO_MASK_SHIFT(reg) (((reg) & IO_PAD73_PIOCFG_SLP_DO_MASK) >> IO_PAD73_PIOCFG_SLP_DO_SHIFT)
#define  IO_PAD73_PIOCFG_SLP_DO_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD73_PIOCFG_SLP_DO_MASK) | (((uint32_t)val) << IO_PAD73_PIOCFG_SLP_DO_SHIFT))

#define  IO_PAD73_PIOCFG_SLP_DIR_MASK 0x80
#define  IO_PAD73_PIOCFG_SLP_DIR_SHIFT 7
#define  IO_PAD73_PIOCFG_SLP_DIR_MASK_SHIFT(reg) (((reg) & IO_PAD73_PIOCFG_SLP_DIR_MASK) >> IO_PAD73_PIOCFG_SLP_DIR_SHIFT)
#define  IO_PAD73_PIOCFG_SLP_DIR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD73_PIOCFG_SLP_DIR_MASK) | (((uint32_t)val) << IO_PAD73_PIOCFG_SLP_DIR_SHIFT))

#define  IO_PAD73_PIOCFG_EDGE_EN_N_MASK 0x40
#define  IO_PAD73_PIOCFG_EDGE_EN_N_SHIFT 6
#define  IO_PAD73_PIOCFG_EDGE_EN_N_MASK_SHIFT(reg) (((reg) & IO_PAD73_PIOCFG_EDGE_EN_N_MASK) >> IO_PAD73_PIOCFG_EDGE_EN_N_SHIFT)
#define  IO_PAD73_PIOCFG_EDGE_EN_N_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD73_PIOCFG_EDGE_EN_N_MASK) | (((uint32_t)val) << IO_PAD73_PIOCFG_EDGE_EN_N_SHIFT))

#define  IO_PAD73_PIOCFG_EDGE_FALL_EN_MASK 0x20
#define  IO_PAD73_PIOCFG_EDGE_FALL_EN_SHIFT 5
#define  IO_PAD73_PIOCFG_EDGE_FALL_EN_MASK_SHIFT(reg) (((reg) & IO_PAD73_PIOCFG_EDGE_FALL_EN_MASK) >> IO_PAD73_PIOCFG_EDGE_FALL_EN_SHIFT)
#define  IO_PAD73_PIOCFG_EDGE_FALL_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD73_PIOCFG_EDGE_FALL_EN_MASK) | (((uint32_t)val) << IO_PAD73_PIOCFG_EDGE_FALL_EN_SHIFT))

#define  IO_PAD73_PIOCFG_EDGE_RISE_EN_MASK 0x10
#define  IO_PAD73_PIOCFG_EDGE_RISE_EN_SHIFT 4
#define  IO_PAD73_PIOCFG_EDGE_RISE_EN_MASK_SHIFT(reg) (((reg) & IO_PAD73_PIOCFG_EDGE_RISE_EN_MASK) >> IO_PAD73_PIOCFG_EDGE_RISE_EN_SHIFT)
#define  IO_PAD73_PIOCFG_EDGE_RISE_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD73_PIOCFG_EDGE_RISE_EN_MASK) | (((uint32_t)val) << IO_PAD73_PIOCFG_EDGE_RISE_EN_SHIFT))

#define  IO_PAD73_PIOCFG_SLP_SEL_MASK 0x8
#define  IO_PAD73_PIOCFG_SLP_SEL_SHIFT 3
#define  IO_PAD73_PIOCFG_SLP_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD73_PIOCFG_SLP_SEL_MASK) >> IO_PAD73_PIOCFG_SLP_SEL_SHIFT)
#define  IO_PAD73_PIOCFG_SLP_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD73_PIOCFG_SLP_SEL_MASK) | (((uint32_t)val) << IO_PAD73_PIOCFG_SLP_SEL_SHIFT))

#define  IO_PAD73_PIOCFG_FUNC_SEL_MASK 0x7
#define  IO_PAD73_PIOCFG_FUNC_SEL_SHIFT 0
#define  IO_PAD73_PIOCFG_FUNC_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD73_PIOCFG_FUNC_SEL_MASK) >> IO_PAD73_PIOCFG_FUNC_SEL_SHIFT)
#define  IO_PAD73_PIOCFG_FUNC_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD73_PIOCFG_FUNC_SEL_MASK) | (((uint32_t)val) << IO_PAD73_PIOCFG_FUNC_SEL_SHIFT))

//====================================================================
//
//Register File: IO_PAD74 Configuration Registers (IO_PAD74)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

//====================================================================
//Register: IO_PAD74 Configuration Register (PIOCFG)
/** \brief "PHI_PADXDC_IOB" Pad*/
//====================================================================

#define  IO_PAD74_PIOCFG_RESERVED1_MASK 0xfc000000
#define  IO_PAD74_PIOCFG_RESERVED1_SHIFT 26
#define  IO_PAD74_PIOCFG_RESERVED1_MASK_SHIFT(reg) (((reg) & IO_PAD74_PIOCFG_RESERVED1_MASK) >> IO_PAD74_PIOCFG_RESERVED1_SHIFT)
#define  IO_PAD74_PIOCFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD74_PIOCFG_RESERVED1_MASK) | (((uint32_t)val) << IO_PAD74_PIOCFG_RESERVED1_SHIFT))

#define  IO_PAD74_PIOCFG_PD_MASK 0x2000000
#define  IO_PAD74_PIOCFG_PD_SHIFT 25
#define  IO_PAD74_PIOCFG_PD_MASK_SHIFT(reg) (((reg) & IO_PAD74_PIOCFG_PD_MASK) >> IO_PAD74_PIOCFG_PD_SHIFT)
#define  IO_PAD74_PIOCFG_PD_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD74_PIOCFG_PD_MASK) | (((uint32_t)val) << IO_PAD74_PIOCFG_PD_SHIFT))

#define  IO_PAD74_PIOCFG_ODT_EN_MASK 0x1000000
#define  IO_PAD74_PIOCFG_ODT_EN_SHIFT 24
#define  IO_PAD74_PIOCFG_ODT_EN_MASK_SHIFT(reg) (((reg) & IO_PAD74_PIOCFG_ODT_EN_MASK) >> IO_PAD74_PIOCFG_ODT_EN_SHIFT)
#define  IO_PAD74_PIOCFG_ODT_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD74_PIOCFG_ODT_EN_MASK) | (((uint32_t)val) << IO_PAD74_PIOCFG_ODT_EN_SHIFT))

#define  IO_PAD74_PIOCFG_LED_EN_MASK 0x800000
#define  IO_PAD74_PIOCFG_LED_EN_SHIFT 23
#define  IO_PAD74_PIOCFG_LED_EN_MASK_SHIFT(reg) (((reg) & IO_PAD74_PIOCFG_LED_EN_MASK) >> IO_PAD74_PIOCFG_LED_EN_SHIFT)
#define  IO_PAD74_PIOCFG_LED_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD74_PIOCFG_LED_EN_MASK) | (((uint32_t)val) << IO_PAD74_PIOCFG_LED_EN_SHIFT))

#define  IO_PAD74_PIOCFG_I2C_SEL_MASK 0x600000
#define  IO_PAD74_PIOCFG_I2C_SEL_SHIFT 21
#define  IO_PAD74_PIOCFG_I2C_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD74_PIOCFG_I2C_SEL_MASK) >> IO_PAD74_PIOCFG_I2C_SEL_SHIFT)
#define  IO_PAD74_PIOCFG_I2C_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD74_PIOCFG_I2C_SEL_MASK) | (((uint32_t)val) << IO_PAD74_PIOCFG_I2C_SEL_SHIFT))

#define  IO_PAD74_PIOCFG_DGTBSEL_MASK 0x1e0000
#define  IO_PAD74_PIOCFG_DGTBSEL_SHIFT 17
#define  IO_PAD74_PIOCFG_DGTBSEL_MASK_SHIFT(reg) (((reg) & IO_PAD74_PIOCFG_DGTBSEL_MASK) >> IO_PAD74_PIOCFG_DGTBSEL_SHIFT)
#define  IO_PAD74_PIOCFG_DGTBSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD74_PIOCFG_DGTBSEL_MASK) | (((uint32_t)val) << IO_PAD74_PIOCFG_DGTBSEL_SHIFT))

#define  IO_PAD74_PIOCFG_RAWSEL_MASK 0x10000
#define  IO_PAD74_PIOCFG_RAWSEL_SHIFT 16
#define  IO_PAD74_PIOCFG_RAWSEL_MASK_SHIFT(reg) (((reg) & IO_PAD74_PIOCFG_RAWSEL_MASK) >> IO_PAD74_PIOCFG_RAWSEL_SHIFT)
#define  IO_PAD74_PIOCFG_RAWSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD74_PIOCFG_RAWSEL_MASK) | (((uint32_t)val) << IO_PAD74_PIOCFG_RAWSEL_SHIFT))

#define  IO_PAD74_PIOCFG_PULL_SEL_MASK 0x8000
#define  IO_PAD74_PIOCFG_PULL_SEL_SHIFT 15
#define  IO_PAD74_PIOCFG_PULL_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD74_PIOCFG_PULL_SEL_MASK) >> IO_PAD74_PIOCFG_PULL_SEL_SHIFT)
#define  IO_PAD74_PIOCFG_PULL_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD74_PIOCFG_PULL_SEL_MASK) | (((uint32_t)val) << IO_PAD74_PIOCFG_PULL_SEL_SHIFT))

#define  IO_PAD74_PIOCFG_PUEN_MASK 0x4000
#define  IO_PAD74_PIOCFG_PUEN_SHIFT 14
#define  IO_PAD74_PIOCFG_PUEN_MASK_SHIFT(reg) (((reg) & IO_PAD74_PIOCFG_PUEN_MASK) >> IO_PAD74_PIOCFG_PUEN_SHIFT)
#define  IO_PAD74_PIOCFG_PUEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD74_PIOCFG_PUEN_MASK) | (((uint32_t)val) << IO_PAD74_PIOCFG_PUEN_SHIFT))

#define  IO_PAD74_PIOCFG_PDEN_MASK 0x2000
#define  IO_PAD74_PIOCFG_PDEN_SHIFT 13
#define  IO_PAD74_PIOCFG_PDEN_MASK_SHIFT(reg) (((reg) & IO_PAD74_PIOCFG_PDEN_MASK) >> IO_PAD74_PIOCFG_PDEN_SHIFT)
#define  IO_PAD74_PIOCFG_PDEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD74_PIOCFG_PDEN_MASK) | (((uint32_t)val) << IO_PAD74_PIOCFG_PDEN_SHIFT))

#define  IO_PAD74_PIOCFG_SR_MASK 0x1800
#define  IO_PAD74_PIOCFG_SR_SHIFT 11
#define  IO_PAD74_PIOCFG_SR_MASK_SHIFT(reg) (((reg) & IO_PAD74_PIOCFG_SR_MASK) >> IO_PAD74_PIOCFG_SR_SHIFT)
#define  IO_PAD74_PIOCFG_SR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD74_PIOCFG_SR_MASK) | (((uint32_t)val) << IO_PAD74_PIOCFG_SR_SHIFT))

#define  IO_PAD74_PIOCFG_SLP_DI_MASK 0x400
#define  IO_PAD74_PIOCFG_SLP_DI_SHIFT 10
#define  IO_PAD74_PIOCFG_SLP_DI_MASK_SHIFT(reg) (((reg) & IO_PAD74_PIOCFG_SLP_DI_MASK) >> IO_PAD74_PIOCFG_SLP_DI_SHIFT)
#define  IO_PAD74_PIOCFG_SLP_DI_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD74_PIOCFG_SLP_DI_MASK) | (((uint32_t)val) << IO_PAD74_PIOCFG_SLP_DI_SHIFT))

#define  IO_PAD74_PIOCFG_SLP_CNTRL_MASK 0x200
#define  IO_PAD74_PIOCFG_SLP_CNTRL_SHIFT 9
#define  IO_PAD74_PIOCFG_SLP_CNTRL_MASK_SHIFT(reg) (((reg) & IO_PAD74_PIOCFG_SLP_CNTRL_MASK) >> IO_PAD74_PIOCFG_SLP_CNTRL_SHIFT)
#define  IO_PAD74_PIOCFG_SLP_CNTRL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD74_PIOCFG_SLP_CNTRL_MASK) | (((uint32_t)val) << IO_PAD74_PIOCFG_SLP_CNTRL_SHIFT))

#define  IO_PAD74_PIOCFG_SLP_DO_MASK 0x100
#define  IO_PAD74_PIOCFG_SLP_DO_SHIFT 8
#define  IO_PAD74_PIOCFG_SLP_DO_MASK_SHIFT(reg) (((reg) & IO_PAD74_PIOCFG_SLP_DO_MASK) >> IO_PAD74_PIOCFG_SLP_DO_SHIFT)
#define  IO_PAD74_PIOCFG_SLP_DO_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD74_PIOCFG_SLP_DO_MASK) | (((uint32_t)val) << IO_PAD74_PIOCFG_SLP_DO_SHIFT))

#define  IO_PAD74_PIOCFG_SLP_DIR_MASK 0x80
#define  IO_PAD74_PIOCFG_SLP_DIR_SHIFT 7
#define  IO_PAD74_PIOCFG_SLP_DIR_MASK_SHIFT(reg) (((reg) & IO_PAD74_PIOCFG_SLP_DIR_MASK) >> IO_PAD74_PIOCFG_SLP_DIR_SHIFT)
#define  IO_PAD74_PIOCFG_SLP_DIR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD74_PIOCFG_SLP_DIR_MASK) | (((uint32_t)val) << IO_PAD74_PIOCFG_SLP_DIR_SHIFT))

#define  IO_PAD74_PIOCFG_EDGE_EN_N_MASK 0x40
#define  IO_PAD74_PIOCFG_EDGE_EN_N_SHIFT 6
#define  IO_PAD74_PIOCFG_EDGE_EN_N_MASK_SHIFT(reg) (((reg) & IO_PAD74_PIOCFG_EDGE_EN_N_MASK) >> IO_PAD74_PIOCFG_EDGE_EN_N_SHIFT)
#define  IO_PAD74_PIOCFG_EDGE_EN_N_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD74_PIOCFG_EDGE_EN_N_MASK) | (((uint32_t)val) << IO_PAD74_PIOCFG_EDGE_EN_N_SHIFT))

#define  IO_PAD74_PIOCFG_EDGE_FALL_EN_MASK 0x20
#define  IO_PAD74_PIOCFG_EDGE_FALL_EN_SHIFT 5
#define  IO_PAD74_PIOCFG_EDGE_FALL_EN_MASK_SHIFT(reg) (((reg) & IO_PAD74_PIOCFG_EDGE_FALL_EN_MASK) >> IO_PAD74_PIOCFG_EDGE_FALL_EN_SHIFT)
#define  IO_PAD74_PIOCFG_EDGE_FALL_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD74_PIOCFG_EDGE_FALL_EN_MASK) | (((uint32_t)val) << IO_PAD74_PIOCFG_EDGE_FALL_EN_SHIFT))

#define  IO_PAD74_PIOCFG_EDGE_RISE_EN_MASK 0x10
#define  IO_PAD74_PIOCFG_EDGE_RISE_EN_SHIFT 4
#define  IO_PAD74_PIOCFG_EDGE_RISE_EN_MASK_SHIFT(reg) (((reg) & IO_PAD74_PIOCFG_EDGE_RISE_EN_MASK) >> IO_PAD74_PIOCFG_EDGE_RISE_EN_SHIFT)
#define  IO_PAD74_PIOCFG_EDGE_RISE_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD74_PIOCFG_EDGE_RISE_EN_MASK) | (((uint32_t)val) << IO_PAD74_PIOCFG_EDGE_RISE_EN_SHIFT))

#define  IO_PAD74_PIOCFG_SLP_SEL_MASK 0x8
#define  IO_PAD74_PIOCFG_SLP_SEL_SHIFT 3
#define  IO_PAD74_PIOCFG_SLP_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD74_PIOCFG_SLP_SEL_MASK) >> IO_PAD74_PIOCFG_SLP_SEL_SHIFT)
#define  IO_PAD74_PIOCFG_SLP_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD74_PIOCFG_SLP_SEL_MASK) | (((uint32_t)val) << IO_PAD74_PIOCFG_SLP_SEL_SHIFT))

#define  IO_PAD74_PIOCFG_FUNC_SEL_MASK 0x7
#define  IO_PAD74_PIOCFG_FUNC_SEL_SHIFT 0
#define  IO_PAD74_PIOCFG_FUNC_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD74_PIOCFG_FUNC_SEL_MASK) >> IO_PAD74_PIOCFG_FUNC_SEL_SHIFT)
#define  IO_PAD74_PIOCFG_FUNC_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD74_PIOCFG_FUNC_SEL_MASK) | (((uint32_t)val) << IO_PAD74_PIOCFG_FUNC_SEL_SHIFT))

//====================================================================
//
//Register File: IO_PAD75 Configuration Registers (IO_PAD75)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

//====================================================================
//Register: IO_PAD75 Configuration Register (PIOCFG)
/** \brief "PHI_PADXDC_IOB" Pad*/
//====================================================================

#define  IO_PAD75_PIOCFG_RESERVED1_MASK 0xfc000000
#define  IO_PAD75_PIOCFG_RESERVED1_SHIFT 26
#define  IO_PAD75_PIOCFG_RESERVED1_MASK_SHIFT(reg) (((reg) & IO_PAD75_PIOCFG_RESERVED1_MASK) >> IO_PAD75_PIOCFG_RESERVED1_SHIFT)
#define  IO_PAD75_PIOCFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD75_PIOCFG_RESERVED1_MASK) | (((uint32_t)val) << IO_PAD75_PIOCFG_RESERVED1_SHIFT))

#define  IO_PAD75_PIOCFG_PD_MASK 0x2000000
#define  IO_PAD75_PIOCFG_PD_SHIFT 25
#define  IO_PAD75_PIOCFG_PD_MASK_SHIFT(reg) (((reg) & IO_PAD75_PIOCFG_PD_MASK) >> IO_PAD75_PIOCFG_PD_SHIFT)
#define  IO_PAD75_PIOCFG_PD_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD75_PIOCFG_PD_MASK) | (((uint32_t)val) << IO_PAD75_PIOCFG_PD_SHIFT))

#define  IO_PAD75_PIOCFG_ODT_EN_MASK 0x1000000
#define  IO_PAD75_PIOCFG_ODT_EN_SHIFT 24
#define  IO_PAD75_PIOCFG_ODT_EN_MASK_SHIFT(reg) (((reg) & IO_PAD75_PIOCFG_ODT_EN_MASK) >> IO_PAD75_PIOCFG_ODT_EN_SHIFT)
#define  IO_PAD75_PIOCFG_ODT_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD75_PIOCFG_ODT_EN_MASK) | (((uint32_t)val) << IO_PAD75_PIOCFG_ODT_EN_SHIFT))

#define  IO_PAD75_PIOCFG_LED_EN_MASK 0x800000
#define  IO_PAD75_PIOCFG_LED_EN_SHIFT 23
#define  IO_PAD75_PIOCFG_LED_EN_MASK_SHIFT(reg) (((reg) & IO_PAD75_PIOCFG_LED_EN_MASK) >> IO_PAD75_PIOCFG_LED_EN_SHIFT)
#define  IO_PAD75_PIOCFG_LED_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD75_PIOCFG_LED_EN_MASK) | (((uint32_t)val) << IO_PAD75_PIOCFG_LED_EN_SHIFT))

#define  IO_PAD75_PIOCFG_I2C_SEL_MASK 0x600000
#define  IO_PAD75_PIOCFG_I2C_SEL_SHIFT 21
#define  IO_PAD75_PIOCFG_I2C_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD75_PIOCFG_I2C_SEL_MASK) >> IO_PAD75_PIOCFG_I2C_SEL_SHIFT)
#define  IO_PAD75_PIOCFG_I2C_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD75_PIOCFG_I2C_SEL_MASK) | (((uint32_t)val) << IO_PAD75_PIOCFG_I2C_SEL_SHIFT))

#define  IO_PAD75_PIOCFG_DGTBSEL_MASK 0x1e0000
#define  IO_PAD75_PIOCFG_DGTBSEL_SHIFT 17
#define  IO_PAD75_PIOCFG_DGTBSEL_MASK_SHIFT(reg) (((reg) & IO_PAD75_PIOCFG_DGTBSEL_MASK) >> IO_PAD75_PIOCFG_DGTBSEL_SHIFT)
#define  IO_PAD75_PIOCFG_DGTBSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD75_PIOCFG_DGTBSEL_MASK) | (((uint32_t)val) << IO_PAD75_PIOCFG_DGTBSEL_SHIFT))

#define  IO_PAD75_PIOCFG_RAWSEL_MASK 0x10000
#define  IO_PAD75_PIOCFG_RAWSEL_SHIFT 16
#define  IO_PAD75_PIOCFG_RAWSEL_MASK_SHIFT(reg) (((reg) & IO_PAD75_PIOCFG_RAWSEL_MASK) >> IO_PAD75_PIOCFG_RAWSEL_SHIFT)
#define  IO_PAD75_PIOCFG_RAWSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD75_PIOCFG_RAWSEL_MASK) | (((uint32_t)val) << IO_PAD75_PIOCFG_RAWSEL_SHIFT))

#define  IO_PAD75_PIOCFG_PULL_SEL_MASK 0x8000
#define  IO_PAD75_PIOCFG_PULL_SEL_SHIFT 15
#define  IO_PAD75_PIOCFG_PULL_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD75_PIOCFG_PULL_SEL_MASK) >> IO_PAD75_PIOCFG_PULL_SEL_SHIFT)
#define  IO_PAD75_PIOCFG_PULL_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD75_PIOCFG_PULL_SEL_MASK) | (((uint32_t)val) << IO_PAD75_PIOCFG_PULL_SEL_SHIFT))

#define  IO_PAD75_PIOCFG_PUEN_MASK 0x4000
#define  IO_PAD75_PIOCFG_PUEN_SHIFT 14
#define  IO_PAD75_PIOCFG_PUEN_MASK_SHIFT(reg) (((reg) & IO_PAD75_PIOCFG_PUEN_MASK) >> IO_PAD75_PIOCFG_PUEN_SHIFT)
#define  IO_PAD75_PIOCFG_PUEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD75_PIOCFG_PUEN_MASK) | (((uint32_t)val) << IO_PAD75_PIOCFG_PUEN_SHIFT))

#define  IO_PAD75_PIOCFG_PDEN_MASK 0x2000
#define  IO_PAD75_PIOCFG_PDEN_SHIFT 13
#define  IO_PAD75_PIOCFG_PDEN_MASK_SHIFT(reg) (((reg) & IO_PAD75_PIOCFG_PDEN_MASK) >> IO_PAD75_PIOCFG_PDEN_SHIFT)
#define  IO_PAD75_PIOCFG_PDEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD75_PIOCFG_PDEN_MASK) | (((uint32_t)val) << IO_PAD75_PIOCFG_PDEN_SHIFT))

#define  IO_PAD75_PIOCFG_SR_MASK 0x1800
#define  IO_PAD75_PIOCFG_SR_SHIFT 11
#define  IO_PAD75_PIOCFG_SR_MASK_SHIFT(reg) (((reg) & IO_PAD75_PIOCFG_SR_MASK) >> IO_PAD75_PIOCFG_SR_SHIFT)
#define  IO_PAD75_PIOCFG_SR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD75_PIOCFG_SR_MASK) | (((uint32_t)val) << IO_PAD75_PIOCFG_SR_SHIFT))

#define  IO_PAD75_PIOCFG_SLP_DI_MASK 0x400
#define  IO_PAD75_PIOCFG_SLP_DI_SHIFT 10
#define  IO_PAD75_PIOCFG_SLP_DI_MASK_SHIFT(reg) (((reg) & IO_PAD75_PIOCFG_SLP_DI_MASK) >> IO_PAD75_PIOCFG_SLP_DI_SHIFT)
#define  IO_PAD75_PIOCFG_SLP_DI_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD75_PIOCFG_SLP_DI_MASK) | (((uint32_t)val) << IO_PAD75_PIOCFG_SLP_DI_SHIFT))

#define  IO_PAD75_PIOCFG_SLP_CNTRL_MASK 0x200
#define  IO_PAD75_PIOCFG_SLP_CNTRL_SHIFT 9
#define  IO_PAD75_PIOCFG_SLP_CNTRL_MASK_SHIFT(reg) (((reg) & IO_PAD75_PIOCFG_SLP_CNTRL_MASK) >> IO_PAD75_PIOCFG_SLP_CNTRL_SHIFT)
#define  IO_PAD75_PIOCFG_SLP_CNTRL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD75_PIOCFG_SLP_CNTRL_MASK) | (((uint32_t)val) << IO_PAD75_PIOCFG_SLP_CNTRL_SHIFT))

#define  IO_PAD75_PIOCFG_SLP_DO_MASK 0x100
#define  IO_PAD75_PIOCFG_SLP_DO_SHIFT 8
#define  IO_PAD75_PIOCFG_SLP_DO_MASK_SHIFT(reg) (((reg) & IO_PAD75_PIOCFG_SLP_DO_MASK) >> IO_PAD75_PIOCFG_SLP_DO_SHIFT)
#define  IO_PAD75_PIOCFG_SLP_DO_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD75_PIOCFG_SLP_DO_MASK) | (((uint32_t)val) << IO_PAD75_PIOCFG_SLP_DO_SHIFT))

#define  IO_PAD75_PIOCFG_SLP_DIR_MASK 0x80
#define  IO_PAD75_PIOCFG_SLP_DIR_SHIFT 7
#define  IO_PAD75_PIOCFG_SLP_DIR_MASK_SHIFT(reg) (((reg) & IO_PAD75_PIOCFG_SLP_DIR_MASK) >> IO_PAD75_PIOCFG_SLP_DIR_SHIFT)
#define  IO_PAD75_PIOCFG_SLP_DIR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD75_PIOCFG_SLP_DIR_MASK) | (((uint32_t)val) << IO_PAD75_PIOCFG_SLP_DIR_SHIFT))

#define  IO_PAD75_PIOCFG_EDGE_EN_N_MASK 0x40
#define  IO_PAD75_PIOCFG_EDGE_EN_N_SHIFT 6
#define  IO_PAD75_PIOCFG_EDGE_EN_N_MASK_SHIFT(reg) (((reg) & IO_PAD75_PIOCFG_EDGE_EN_N_MASK) >> IO_PAD75_PIOCFG_EDGE_EN_N_SHIFT)
#define  IO_PAD75_PIOCFG_EDGE_EN_N_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD75_PIOCFG_EDGE_EN_N_MASK) | (((uint32_t)val) << IO_PAD75_PIOCFG_EDGE_EN_N_SHIFT))

#define  IO_PAD75_PIOCFG_EDGE_FALL_EN_MASK 0x20
#define  IO_PAD75_PIOCFG_EDGE_FALL_EN_SHIFT 5
#define  IO_PAD75_PIOCFG_EDGE_FALL_EN_MASK_SHIFT(reg) (((reg) & IO_PAD75_PIOCFG_EDGE_FALL_EN_MASK) >> IO_PAD75_PIOCFG_EDGE_FALL_EN_SHIFT)
#define  IO_PAD75_PIOCFG_EDGE_FALL_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD75_PIOCFG_EDGE_FALL_EN_MASK) | (((uint32_t)val) << IO_PAD75_PIOCFG_EDGE_FALL_EN_SHIFT))

#define  IO_PAD75_PIOCFG_EDGE_RISE_EN_MASK 0x10
#define  IO_PAD75_PIOCFG_EDGE_RISE_EN_SHIFT 4
#define  IO_PAD75_PIOCFG_EDGE_RISE_EN_MASK_SHIFT(reg) (((reg) & IO_PAD75_PIOCFG_EDGE_RISE_EN_MASK) >> IO_PAD75_PIOCFG_EDGE_RISE_EN_SHIFT)
#define  IO_PAD75_PIOCFG_EDGE_RISE_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD75_PIOCFG_EDGE_RISE_EN_MASK) | (((uint32_t)val) << IO_PAD75_PIOCFG_EDGE_RISE_EN_SHIFT))

#define  IO_PAD75_PIOCFG_SLP_SEL_MASK 0x8
#define  IO_PAD75_PIOCFG_SLP_SEL_SHIFT 3
#define  IO_PAD75_PIOCFG_SLP_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD75_PIOCFG_SLP_SEL_MASK) >> IO_PAD75_PIOCFG_SLP_SEL_SHIFT)
#define  IO_PAD75_PIOCFG_SLP_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD75_PIOCFG_SLP_SEL_MASK) | (((uint32_t)val) << IO_PAD75_PIOCFG_SLP_SEL_SHIFT))

#define  IO_PAD75_PIOCFG_FUNC_SEL_MASK 0x7
#define  IO_PAD75_PIOCFG_FUNC_SEL_SHIFT 0
#define  IO_PAD75_PIOCFG_FUNC_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD75_PIOCFG_FUNC_SEL_MASK) >> IO_PAD75_PIOCFG_FUNC_SEL_SHIFT)
#define  IO_PAD75_PIOCFG_FUNC_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD75_PIOCFG_FUNC_SEL_MASK) | (((uint32_t)val) << IO_PAD75_PIOCFG_FUNC_SEL_SHIFT))

//====================================================================
//
//Register File: IO_PAD76 Configuration Registers (IO_PAD76)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

//====================================================================
//Register: IO_PAD76 Configuration Register (PIOCFG)
/** \brief "PHI_PADXDC_IOB" Pad*/
//====================================================================

#define  IO_PAD76_PIOCFG_RESERVED1_MASK 0xfc000000
#define  IO_PAD76_PIOCFG_RESERVED1_SHIFT 26
#define  IO_PAD76_PIOCFG_RESERVED1_MASK_SHIFT(reg) (((reg) & IO_PAD76_PIOCFG_RESERVED1_MASK) >> IO_PAD76_PIOCFG_RESERVED1_SHIFT)
#define  IO_PAD76_PIOCFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD76_PIOCFG_RESERVED1_MASK) | (((uint32_t)val) << IO_PAD76_PIOCFG_RESERVED1_SHIFT))

#define  IO_PAD76_PIOCFG_PD_MASK 0x2000000
#define  IO_PAD76_PIOCFG_PD_SHIFT 25
#define  IO_PAD76_PIOCFG_PD_MASK_SHIFT(reg) (((reg) & IO_PAD76_PIOCFG_PD_MASK) >> IO_PAD76_PIOCFG_PD_SHIFT)
#define  IO_PAD76_PIOCFG_PD_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD76_PIOCFG_PD_MASK) | (((uint32_t)val) << IO_PAD76_PIOCFG_PD_SHIFT))

#define  IO_PAD76_PIOCFG_ODT_EN_MASK 0x1000000
#define  IO_PAD76_PIOCFG_ODT_EN_SHIFT 24
#define  IO_PAD76_PIOCFG_ODT_EN_MASK_SHIFT(reg) (((reg) & IO_PAD76_PIOCFG_ODT_EN_MASK) >> IO_PAD76_PIOCFG_ODT_EN_SHIFT)
#define  IO_PAD76_PIOCFG_ODT_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD76_PIOCFG_ODT_EN_MASK) | (((uint32_t)val) << IO_PAD76_PIOCFG_ODT_EN_SHIFT))

#define  IO_PAD76_PIOCFG_LED_EN_MASK 0x800000
#define  IO_PAD76_PIOCFG_LED_EN_SHIFT 23
#define  IO_PAD76_PIOCFG_LED_EN_MASK_SHIFT(reg) (((reg) & IO_PAD76_PIOCFG_LED_EN_MASK) >> IO_PAD76_PIOCFG_LED_EN_SHIFT)
#define  IO_PAD76_PIOCFG_LED_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD76_PIOCFG_LED_EN_MASK) | (((uint32_t)val) << IO_PAD76_PIOCFG_LED_EN_SHIFT))

#define  IO_PAD76_PIOCFG_I2C_SEL_MASK 0x600000
#define  IO_PAD76_PIOCFG_I2C_SEL_SHIFT 21
#define  IO_PAD76_PIOCFG_I2C_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD76_PIOCFG_I2C_SEL_MASK) >> IO_PAD76_PIOCFG_I2C_SEL_SHIFT)
#define  IO_PAD76_PIOCFG_I2C_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD76_PIOCFG_I2C_SEL_MASK) | (((uint32_t)val) << IO_PAD76_PIOCFG_I2C_SEL_SHIFT))

#define  IO_PAD76_PIOCFG_DGTBSEL_MASK 0x1e0000
#define  IO_PAD76_PIOCFG_DGTBSEL_SHIFT 17
#define  IO_PAD76_PIOCFG_DGTBSEL_MASK_SHIFT(reg) (((reg) & IO_PAD76_PIOCFG_DGTBSEL_MASK) >> IO_PAD76_PIOCFG_DGTBSEL_SHIFT)
#define  IO_PAD76_PIOCFG_DGTBSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD76_PIOCFG_DGTBSEL_MASK) | (((uint32_t)val) << IO_PAD76_PIOCFG_DGTBSEL_SHIFT))

#define  IO_PAD76_PIOCFG_RAWSEL_MASK 0x10000
#define  IO_PAD76_PIOCFG_RAWSEL_SHIFT 16
#define  IO_PAD76_PIOCFG_RAWSEL_MASK_SHIFT(reg) (((reg) & IO_PAD76_PIOCFG_RAWSEL_MASK) >> IO_PAD76_PIOCFG_RAWSEL_SHIFT)
#define  IO_PAD76_PIOCFG_RAWSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD76_PIOCFG_RAWSEL_MASK) | (((uint32_t)val) << IO_PAD76_PIOCFG_RAWSEL_SHIFT))

#define  IO_PAD76_PIOCFG_PULL_SEL_MASK 0x8000
#define  IO_PAD76_PIOCFG_PULL_SEL_SHIFT 15
#define  IO_PAD76_PIOCFG_PULL_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD76_PIOCFG_PULL_SEL_MASK) >> IO_PAD76_PIOCFG_PULL_SEL_SHIFT)
#define  IO_PAD76_PIOCFG_PULL_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD76_PIOCFG_PULL_SEL_MASK) | (((uint32_t)val) << IO_PAD76_PIOCFG_PULL_SEL_SHIFT))

#define  IO_PAD76_PIOCFG_PUEN_MASK 0x4000
#define  IO_PAD76_PIOCFG_PUEN_SHIFT 14
#define  IO_PAD76_PIOCFG_PUEN_MASK_SHIFT(reg) (((reg) & IO_PAD76_PIOCFG_PUEN_MASK) >> IO_PAD76_PIOCFG_PUEN_SHIFT)
#define  IO_PAD76_PIOCFG_PUEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD76_PIOCFG_PUEN_MASK) | (((uint32_t)val) << IO_PAD76_PIOCFG_PUEN_SHIFT))

#define  IO_PAD76_PIOCFG_PDEN_MASK 0x2000
#define  IO_PAD76_PIOCFG_PDEN_SHIFT 13
#define  IO_PAD76_PIOCFG_PDEN_MASK_SHIFT(reg) (((reg) & IO_PAD76_PIOCFG_PDEN_MASK) >> IO_PAD76_PIOCFG_PDEN_SHIFT)
#define  IO_PAD76_PIOCFG_PDEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD76_PIOCFG_PDEN_MASK) | (((uint32_t)val) << IO_PAD76_PIOCFG_PDEN_SHIFT))

#define  IO_PAD76_PIOCFG_SR_MASK 0x1800
#define  IO_PAD76_PIOCFG_SR_SHIFT 11
#define  IO_PAD76_PIOCFG_SR_MASK_SHIFT(reg) (((reg) & IO_PAD76_PIOCFG_SR_MASK) >> IO_PAD76_PIOCFG_SR_SHIFT)
#define  IO_PAD76_PIOCFG_SR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD76_PIOCFG_SR_MASK) | (((uint32_t)val) << IO_PAD76_PIOCFG_SR_SHIFT))

#define  IO_PAD76_PIOCFG_SLP_DI_MASK 0x400
#define  IO_PAD76_PIOCFG_SLP_DI_SHIFT 10
#define  IO_PAD76_PIOCFG_SLP_DI_MASK_SHIFT(reg) (((reg) & IO_PAD76_PIOCFG_SLP_DI_MASK) >> IO_PAD76_PIOCFG_SLP_DI_SHIFT)
#define  IO_PAD76_PIOCFG_SLP_DI_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD76_PIOCFG_SLP_DI_MASK) | (((uint32_t)val) << IO_PAD76_PIOCFG_SLP_DI_SHIFT))

#define  IO_PAD76_PIOCFG_SLP_CNTRL_MASK 0x200
#define  IO_PAD76_PIOCFG_SLP_CNTRL_SHIFT 9
#define  IO_PAD76_PIOCFG_SLP_CNTRL_MASK_SHIFT(reg) (((reg) & IO_PAD76_PIOCFG_SLP_CNTRL_MASK) >> IO_PAD76_PIOCFG_SLP_CNTRL_SHIFT)
#define  IO_PAD76_PIOCFG_SLP_CNTRL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD76_PIOCFG_SLP_CNTRL_MASK) | (((uint32_t)val) << IO_PAD76_PIOCFG_SLP_CNTRL_SHIFT))

#define  IO_PAD76_PIOCFG_SLP_DO_MASK 0x100
#define  IO_PAD76_PIOCFG_SLP_DO_SHIFT 8
#define  IO_PAD76_PIOCFG_SLP_DO_MASK_SHIFT(reg) (((reg) & IO_PAD76_PIOCFG_SLP_DO_MASK) >> IO_PAD76_PIOCFG_SLP_DO_SHIFT)
#define  IO_PAD76_PIOCFG_SLP_DO_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD76_PIOCFG_SLP_DO_MASK) | (((uint32_t)val) << IO_PAD76_PIOCFG_SLP_DO_SHIFT))

#define  IO_PAD76_PIOCFG_SLP_DIR_MASK 0x80
#define  IO_PAD76_PIOCFG_SLP_DIR_SHIFT 7
#define  IO_PAD76_PIOCFG_SLP_DIR_MASK_SHIFT(reg) (((reg) & IO_PAD76_PIOCFG_SLP_DIR_MASK) >> IO_PAD76_PIOCFG_SLP_DIR_SHIFT)
#define  IO_PAD76_PIOCFG_SLP_DIR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD76_PIOCFG_SLP_DIR_MASK) | (((uint32_t)val) << IO_PAD76_PIOCFG_SLP_DIR_SHIFT))

#define  IO_PAD76_PIOCFG_EDGE_EN_N_MASK 0x40
#define  IO_PAD76_PIOCFG_EDGE_EN_N_SHIFT 6
#define  IO_PAD76_PIOCFG_EDGE_EN_N_MASK_SHIFT(reg) (((reg) & IO_PAD76_PIOCFG_EDGE_EN_N_MASK) >> IO_PAD76_PIOCFG_EDGE_EN_N_SHIFT)
#define  IO_PAD76_PIOCFG_EDGE_EN_N_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD76_PIOCFG_EDGE_EN_N_MASK) | (((uint32_t)val) << IO_PAD76_PIOCFG_EDGE_EN_N_SHIFT))

#define  IO_PAD76_PIOCFG_EDGE_FALL_EN_MASK 0x20
#define  IO_PAD76_PIOCFG_EDGE_FALL_EN_SHIFT 5
#define  IO_PAD76_PIOCFG_EDGE_FALL_EN_MASK_SHIFT(reg) (((reg) & IO_PAD76_PIOCFG_EDGE_FALL_EN_MASK) >> IO_PAD76_PIOCFG_EDGE_FALL_EN_SHIFT)
#define  IO_PAD76_PIOCFG_EDGE_FALL_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD76_PIOCFG_EDGE_FALL_EN_MASK) | (((uint32_t)val) << IO_PAD76_PIOCFG_EDGE_FALL_EN_SHIFT))

#define  IO_PAD76_PIOCFG_EDGE_RISE_EN_MASK 0x10
#define  IO_PAD76_PIOCFG_EDGE_RISE_EN_SHIFT 4
#define  IO_PAD76_PIOCFG_EDGE_RISE_EN_MASK_SHIFT(reg) (((reg) & IO_PAD76_PIOCFG_EDGE_RISE_EN_MASK) >> IO_PAD76_PIOCFG_EDGE_RISE_EN_SHIFT)
#define  IO_PAD76_PIOCFG_EDGE_RISE_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD76_PIOCFG_EDGE_RISE_EN_MASK) | (((uint32_t)val) << IO_PAD76_PIOCFG_EDGE_RISE_EN_SHIFT))

#define  IO_PAD76_PIOCFG_SLP_SEL_MASK 0x8
#define  IO_PAD76_PIOCFG_SLP_SEL_SHIFT 3
#define  IO_PAD76_PIOCFG_SLP_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD76_PIOCFG_SLP_SEL_MASK) >> IO_PAD76_PIOCFG_SLP_SEL_SHIFT)
#define  IO_PAD76_PIOCFG_SLP_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD76_PIOCFG_SLP_SEL_MASK) | (((uint32_t)val) << IO_PAD76_PIOCFG_SLP_SEL_SHIFT))

#define  IO_PAD76_PIOCFG_FUNC_SEL_MASK 0x7
#define  IO_PAD76_PIOCFG_FUNC_SEL_SHIFT 0
#define  IO_PAD76_PIOCFG_FUNC_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD76_PIOCFG_FUNC_SEL_MASK) >> IO_PAD76_PIOCFG_FUNC_SEL_SHIFT)
#define  IO_PAD76_PIOCFG_FUNC_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD76_PIOCFG_FUNC_SEL_MASK) | (((uint32_t)val) << IO_PAD76_PIOCFG_FUNC_SEL_SHIFT))

//====================================================================
//
//Register File: IO_PAD77 Configuration Registers (IO_PAD77)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

//====================================================================
//Register: IO_PAD77 Configuration Register (PIOCFG)
/** \brief "PHI_PADXDC_IOB" Pad*/
//====================================================================

#define  IO_PAD77_PIOCFG_RESERVED1_MASK 0xfc000000
#define  IO_PAD77_PIOCFG_RESERVED1_SHIFT 26
#define  IO_PAD77_PIOCFG_RESERVED1_MASK_SHIFT(reg) (((reg) & IO_PAD77_PIOCFG_RESERVED1_MASK) >> IO_PAD77_PIOCFG_RESERVED1_SHIFT)
#define  IO_PAD77_PIOCFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD77_PIOCFG_RESERVED1_MASK) | (((uint32_t)val) << IO_PAD77_PIOCFG_RESERVED1_SHIFT))

#define  IO_PAD77_PIOCFG_PD_MASK 0x2000000
#define  IO_PAD77_PIOCFG_PD_SHIFT 25
#define  IO_PAD77_PIOCFG_PD_MASK_SHIFT(reg) (((reg) & IO_PAD77_PIOCFG_PD_MASK) >> IO_PAD77_PIOCFG_PD_SHIFT)
#define  IO_PAD77_PIOCFG_PD_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD77_PIOCFG_PD_MASK) | (((uint32_t)val) << IO_PAD77_PIOCFG_PD_SHIFT))

#define  IO_PAD77_PIOCFG_ODT_EN_MASK 0x1000000
#define  IO_PAD77_PIOCFG_ODT_EN_SHIFT 24
#define  IO_PAD77_PIOCFG_ODT_EN_MASK_SHIFT(reg) (((reg) & IO_PAD77_PIOCFG_ODT_EN_MASK) >> IO_PAD77_PIOCFG_ODT_EN_SHIFT)
#define  IO_PAD77_PIOCFG_ODT_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD77_PIOCFG_ODT_EN_MASK) | (((uint32_t)val) << IO_PAD77_PIOCFG_ODT_EN_SHIFT))

#define  IO_PAD77_PIOCFG_LED_EN_MASK 0x800000
#define  IO_PAD77_PIOCFG_LED_EN_SHIFT 23
#define  IO_PAD77_PIOCFG_LED_EN_MASK_SHIFT(reg) (((reg) & IO_PAD77_PIOCFG_LED_EN_MASK) >> IO_PAD77_PIOCFG_LED_EN_SHIFT)
#define  IO_PAD77_PIOCFG_LED_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD77_PIOCFG_LED_EN_MASK) | (((uint32_t)val) << IO_PAD77_PIOCFG_LED_EN_SHIFT))

#define  IO_PAD77_PIOCFG_I2C_SEL_MASK 0x600000
#define  IO_PAD77_PIOCFG_I2C_SEL_SHIFT 21
#define  IO_PAD77_PIOCFG_I2C_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD77_PIOCFG_I2C_SEL_MASK) >> IO_PAD77_PIOCFG_I2C_SEL_SHIFT)
#define  IO_PAD77_PIOCFG_I2C_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD77_PIOCFG_I2C_SEL_MASK) | (((uint32_t)val) << IO_PAD77_PIOCFG_I2C_SEL_SHIFT))

#define  IO_PAD77_PIOCFG_DGTBSEL_MASK 0x1e0000
#define  IO_PAD77_PIOCFG_DGTBSEL_SHIFT 17
#define  IO_PAD77_PIOCFG_DGTBSEL_MASK_SHIFT(reg) (((reg) & IO_PAD77_PIOCFG_DGTBSEL_MASK) >> IO_PAD77_PIOCFG_DGTBSEL_SHIFT)
#define  IO_PAD77_PIOCFG_DGTBSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD77_PIOCFG_DGTBSEL_MASK) | (((uint32_t)val) << IO_PAD77_PIOCFG_DGTBSEL_SHIFT))

#define  IO_PAD77_PIOCFG_RAWSEL_MASK 0x10000
#define  IO_PAD77_PIOCFG_RAWSEL_SHIFT 16
#define  IO_PAD77_PIOCFG_RAWSEL_MASK_SHIFT(reg) (((reg) & IO_PAD77_PIOCFG_RAWSEL_MASK) >> IO_PAD77_PIOCFG_RAWSEL_SHIFT)
#define  IO_PAD77_PIOCFG_RAWSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD77_PIOCFG_RAWSEL_MASK) | (((uint32_t)val) << IO_PAD77_PIOCFG_RAWSEL_SHIFT))

#define  IO_PAD77_PIOCFG_PULL_SEL_MASK 0x8000
#define  IO_PAD77_PIOCFG_PULL_SEL_SHIFT 15
#define  IO_PAD77_PIOCFG_PULL_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD77_PIOCFG_PULL_SEL_MASK) >> IO_PAD77_PIOCFG_PULL_SEL_SHIFT)
#define  IO_PAD77_PIOCFG_PULL_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD77_PIOCFG_PULL_SEL_MASK) | (((uint32_t)val) << IO_PAD77_PIOCFG_PULL_SEL_SHIFT))

#define  IO_PAD77_PIOCFG_PUEN_MASK 0x4000
#define  IO_PAD77_PIOCFG_PUEN_SHIFT 14
#define  IO_PAD77_PIOCFG_PUEN_MASK_SHIFT(reg) (((reg) & IO_PAD77_PIOCFG_PUEN_MASK) >> IO_PAD77_PIOCFG_PUEN_SHIFT)
#define  IO_PAD77_PIOCFG_PUEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD77_PIOCFG_PUEN_MASK) | (((uint32_t)val) << IO_PAD77_PIOCFG_PUEN_SHIFT))

#define  IO_PAD77_PIOCFG_PDEN_MASK 0x2000
#define  IO_PAD77_PIOCFG_PDEN_SHIFT 13
#define  IO_PAD77_PIOCFG_PDEN_MASK_SHIFT(reg) (((reg) & IO_PAD77_PIOCFG_PDEN_MASK) >> IO_PAD77_PIOCFG_PDEN_SHIFT)
#define  IO_PAD77_PIOCFG_PDEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD77_PIOCFG_PDEN_MASK) | (((uint32_t)val) << IO_PAD77_PIOCFG_PDEN_SHIFT))

#define  IO_PAD77_PIOCFG_SR_MASK 0x1800
#define  IO_PAD77_PIOCFG_SR_SHIFT 11
#define  IO_PAD77_PIOCFG_SR_MASK_SHIFT(reg) (((reg) & IO_PAD77_PIOCFG_SR_MASK) >> IO_PAD77_PIOCFG_SR_SHIFT)
#define  IO_PAD77_PIOCFG_SR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD77_PIOCFG_SR_MASK) | (((uint32_t)val) << IO_PAD77_PIOCFG_SR_SHIFT))

#define  IO_PAD77_PIOCFG_SLP_DI_MASK 0x400
#define  IO_PAD77_PIOCFG_SLP_DI_SHIFT 10
#define  IO_PAD77_PIOCFG_SLP_DI_MASK_SHIFT(reg) (((reg) & IO_PAD77_PIOCFG_SLP_DI_MASK) >> IO_PAD77_PIOCFG_SLP_DI_SHIFT)
#define  IO_PAD77_PIOCFG_SLP_DI_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD77_PIOCFG_SLP_DI_MASK) | (((uint32_t)val) << IO_PAD77_PIOCFG_SLP_DI_SHIFT))

#define  IO_PAD77_PIOCFG_SLP_CNTRL_MASK 0x200
#define  IO_PAD77_PIOCFG_SLP_CNTRL_SHIFT 9
#define  IO_PAD77_PIOCFG_SLP_CNTRL_MASK_SHIFT(reg) (((reg) & IO_PAD77_PIOCFG_SLP_CNTRL_MASK) >> IO_PAD77_PIOCFG_SLP_CNTRL_SHIFT)
#define  IO_PAD77_PIOCFG_SLP_CNTRL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD77_PIOCFG_SLP_CNTRL_MASK) | (((uint32_t)val) << IO_PAD77_PIOCFG_SLP_CNTRL_SHIFT))

#define  IO_PAD77_PIOCFG_SLP_DO_MASK 0x100
#define  IO_PAD77_PIOCFG_SLP_DO_SHIFT 8
#define  IO_PAD77_PIOCFG_SLP_DO_MASK_SHIFT(reg) (((reg) & IO_PAD77_PIOCFG_SLP_DO_MASK) >> IO_PAD77_PIOCFG_SLP_DO_SHIFT)
#define  IO_PAD77_PIOCFG_SLP_DO_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD77_PIOCFG_SLP_DO_MASK) | (((uint32_t)val) << IO_PAD77_PIOCFG_SLP_DO_SHIFT))

#define  IO_PAD77_PIOCFG_SLP_DIR_MASK 0x80
#define  IO_PAD77_PIOCFG_SLP_DIR_SHIFT 7
#define  IO_PAD77_PIOCFG_SLP_DIR_MASK_SHIFT(reg) (((reg) & IO_PAD77_PIOCFG_SLP_DIR_MASK) >> IO_PAD77_PIOCFG_SLP_DIR_SHIFT)
#define  IO_PAD77_PIOCFG_SLP_DIR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD77_PIOCFG_SLP_DIR_MASK) | (((uint32_t)val) << IO_PAD77_PIOCFG_SLP_DIR_SHIFT))

#define  IO_PAD77_PIOCFG_EDGE_EN_N_MASK 0x40
#define  IO_PAD77_PIOCFG_EDGE_EN_N_SHIFT 6
#define  IO_PAD77_PIOCFG_EDGE_EN_N_MASK_SHIFT(reg) (((reg) & IO_PAD77_PIOCFG_EDGE_EN_N_MASK) >> IO_PAD77_PIOCFG_EDGE_EN_N_SHIFT)
#define  IO_PAD77_PIOCFG_EDGE_EN_N_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD77_PIOCFG_EDGE_EN_N_MASK) | (((uint32_t)val) << IO_PAD77_PIOCFG_EDGE_EN_N_SHIFT))

#define  IO_PAD77_PIOCFG_EDGE_FALL_EN_MASK 0x20
#define  IO_PAD77_PIOCFG_EDGE_FALL_EN_SHIFT 5
#define  IO_PAD77_PIOCFG_EDGE_FALL_EN_MASK_SHIFT(reg) (((reg) & IO_PAD77_PIOCFG_EDGE_FALL_EN_MASK) >> IO_PAD77_PIOCFG_EDGE_FALL_EN_SHIFT)
#define  IO_PAD77_PIOCFG_EDGE_FALL_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD77_PIOCFG_EDGE_FALL_EN_MASK) | (((uint32_t)val) << IO_PAD77_PIOCFG_EDGE_FALL_EN_SHIFT))

#define  IO_PAD77_PIOCFG_EDGE_RISE_EN_MASK 0x10
#define  IO_PAD77_PIOCFG_EDGE_RISE_EN_SHIFT 4
#define  IO_PAD77_PIOCFG_EDGE_RISE_EN_MASK_SHIFT(reg) (((reg) & IO_PAD77_PIOCFG_EDGE_RISE_EN_MASK) >> IO_PAD77_PIOCFG_EDGE_RISE_EN_SHIFT)
#define  IO_PAD77_PIOCFG_EDGE_RISE_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD77_PIOCFG_EDGE_RISE_EN_MASK) | (((uint32_t)val) << IO_PAD77_PIOCFG_EDGE_RISE_EN_SHIFT))

#define  IO_PAD77_PIOCFG_SLP_SEL_MASK 0x8
#define  IO_PAD77_PIOCFG_SLP_SEL_SHIFT 3
#define  IO_PAD77_PIOCFG_SLP_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD77_PIOCFG_SLP_SEL_MASK) >> IO_PAD77_PIOCFG_SLP_SEL_SHIFT)
#define  IO_PAD77_PIOCFG_SLP_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD77_PIOCFG_SLP_SEL_MASK) | (((uint32_t)val) << IO_PAD77_PIOCFG_SLP_SEL_SHIFT))

#define  IO_PAD77_PIOCFG_FUNC_SEL_MASK 0x7
#define  IO_PAD77_PIOCFG_FUNC_SEL_SHIFT 0
#define  IO_PAD77_PIOCFG_FUNC_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD77_PIOCFG_FUNC_SEL_MASK) >> IO_PAD77_PIOCFG_FUNC_SEL_SHIFT)
#define  IO_PAD77_PIOCFG_FUNC_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD77_PIOCFG_FUNC_SEL_MASK) | (((uint32_t)val) << IO_PAD77_PIOCFG_FUNC_SEL_SHIFT))

//====================================================================
//
//Register File: IO_PAD78 Configuration Registers (IO_PAD78)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

//====================================================================
//Register: IO_PAD78 Configuration Register (PIOCFG)
/** \brief "PHI_PADXDC_IOB" Pad*/
//====================================================================

#define  IO_PAD78_PIOCFG_RESERVED1_MASK 0xfc000000
#define  IO_PAD78_PIOCFG_RESERVED1_SHIFT 26
#define  IO_PAD78_PIOCFG_RESERVED1_MASK_SHIFT(reg) (((reg) & IO_PAD78_PIOCFG_RESERVED1_MASK) >> IO_PAD78_PIOCFG_RESERVED1_SHIFT)
#define  IO_PAD78_PIOCFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD78_PIOCFG_RESERVED1_MASK) | (((uint32_t)val) << IO_PAD78_PIOCFG_RESERVED1_SHIFT))

#define  IO_PAD78_PIOCFG_PD_MASK 0x2000000
#define  IO_PAD78_PIOCFG_PD_SHIFT 25
#define  IO_PAD78_PIOCFG_PD_MASK_SHIFT(reg) (((reg) & IO_PAD78_PIOCFG_PD_MASK) >> IO_PAD78_PIOCFG_PD_SHIFT)
#define  IO_PAD78_PIOCFG_PD_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD78_PIOCFG_PD_MASK) | (((uint32_t)val) << IO_PAD78_PIOCFG_PD_SHIFT))

#define  IO_PAD78_PIOCFG_ODT_EN_MASK 0x1000000
#define  IO_PAD78_PIOCFG_ODT_EN_SHIFT 24
#define  IO_PAD78_PIOCFG_ODT_EN_MASK_SHIFT(reg) (((reg) & IO_PAD78_PIOCFG_ODT_EN_MASK) >> IO_PAD78_PIOCFG_ODT_EN_SHIFT)
#define  IO_PAD78_PIOCFG_ODT_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD78_PIOCFG_ODT_EN_MASK) | (((uint32_t)val) << IO_PAD78_PIOCFG_ODT_EN_SHIFT))

#define  IO_PAD78_PIOCFG_LED_EN_MASK 0x800000
#define  IO_PAD78_PIOCFG_LED_EN_SHIFT 23
#define  IO_PAD78_PIOCFG_LED_EN_MASK_SHIFT(reg) (((reg) & IO_PAD78_PIOCFG_LED_EN_MASK) >> IO_PAD78_PIOCFG_LED_EN_SHIFT)
#define  IO_PAD78_PIOCFG_LED_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD78_PIOCFG_LED_EN_MASK) | (((uint32_t)val) << IO_PAD78_PIOCFG_LED_EN_SHIFT))

#define  IO_PAD78_PIOCFG_I2C_SEL_MASK 0x600000
#define  IO_PAD78_PIOCFG_I2C_SEL_SHIFT 21
#define  IO_PAD78_PIOCFG_I2C_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD78_PIOCFG_I2C_SEL_MASK) >> IO_PAD78_PIOCFG_I2C_SEL_SHIFT)
#define  IO_PAD78_PIOCFG_I2C_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD78_PIOCFG_I2C_SEL_MASK) | (((uint32_t)val) << IO_PAD78_PIOCFG_I2C_SEL_SHIFT))

#define  IO_PAD78_PIOCFG_DGTBSEL_MASK 0x1e0000
#define  IO_PAD78_PIOCFG_DGTBSEL_SHIFT 17
#define  IO_PAD78_PIOCFG_DGTBSEL_MASK_SHIFT(reg) (((reg) & IO_PAD78_PIOCFG_DGTBSEL_MASK) >> IO_PAD78_PIOCFG_DGTBSEL_SHIFT)
#define  IO_PAD78_PIOCFG_DGTBSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD78_PIOCFG_DGTBSEL_MASK) | (((uint32_t)val) << IO_PAD78_PIOCFG_DGTBSEL_SHIFT))

#define  IO_PAD78_PIOCFG_RAWSEL_MASK 0x10000
#define  IO_PAD78_PIOCFG_RAWSEL_SHIFT 16
#define  IO_PAD78_PIOCFG_RAWSEL_MASK_SHIFT(reg) (((reg) & IO_PAD78_PIOCFG_RAWSEL_MASK) >> IO_PAD78_PIOCFG_RAWSEL_SHIFT)
#define  IO_PAD78_PIOCFG_RAWSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD78_PIOCFG_RAWSEL_MASK) | (((uint32_t)val) << IO_PAD78_PIOCFG_RAWSEL_SHIFT))

#define  IO_PAD78_PIOCFG_PULL_SEL_MASK 0x8000
#define  IO_PAD78_PIOCFG_PULL_SEL_SHIFT 15
#define  IO_PAD78_PIOCFG_PULL_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD78_PIOCFG_PULL_SEL_MASK) >> IO_PAD78_PIOCFG_PULL_SEL_SHIFT)
#define  IO_PAD78_PIOCFG_PULL_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD78_PIOCFG_PULL_SEL_MASK) | (((uint32_t)val) << IO_PAD78_PIOCFG_PULL_SEL_SHIFT))

#define  IO_PAD78_PIOCFG_PUEN_MASK 0x4000
#define  IO_PAD78_PIOCFG_PUEN_SHIFT 14
#define  IO_PAD78_PIOCFG_PUEN_MASK_SHIFT(reg) (((reg) & IO_PAD78_PIOCFG_PUEN_MASK) >> IO_PAD78_PIOCFG_PUEN_SHIFT)
#define  IO_PAD78_PIOCFG_PUEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD78_PIOCFG_PUEN_MASK) | (((uint32_t)val) << IO_PAD78_PIOCFG_PUEN_SHIFT))

#define  IO_PAD78_PIOCFG_PDEN_MASK 0x2000
#define  IO_PAD78_PIOCFG_PDEN_SHIFT 13
#define  IO_PAD78_PIOCFG_PDEN_MASK_SHIFT(reg) (((reg) & IO_PAD78_PIOCFG_PDEN_MASK) >> IO_PAD78_PIOCFG_PDEN_SHIFT)
#define  IO_PAD78_PIOCFG_PDEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD78_PIOCFG_PDEN_MASK) | (((uint32_t)val) << IO_PAD78_PIOCFG_PDEN_SHIFT))

#define  IO_PAD78_PIOCFG_SR_MASK 0x1800
#define  IO_PAD78_PIOCFG_SR_SHIFT 11
#define  IO_PAD78_PIOCFG_SR_MASK_SHIFT(reg) (((reg) & IO_PAD78_PIOCFG_SR_MASK) >> IO_PAD78_PIOCFG_SR_SHIFT)
#define  IO_PAD78_PIOCFG_SR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD78_PIOCFG_SR_MASK) | (((uint32_t)val) << IO_PAD78_PIOCFG_SR_SHIFT))

#define  IO_PAD78_PIOCFG_SLP_DI_MASK 0x400
#define  IO_PAD78_PIOCFG_SLP_DI_SHIFT 10
#define  IO_PAD78_PIOCFG_SLP_DI_MASK_SHIFT(reg) (((reg) & IO_PAD78_PIOCFG_SLP_DI_MASK) >> IO_PAD78_PIOCFG_SLP_DI_SHIFT)
#define  IO_PAD78_PIOCFG_SLP_DI_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD78_PIOCFG_SLP_DI_MASK) | (((uint32_t)val) << IO_PAD78_PIOCFG_SLP_DI_SHIFT))

#define  IO_PAD78_PIOCFG_SLP_CNTRL_MASK 0x200
#define  IO_PAD78_PIOCFG_SLP_CNTRL_SHIFT 9
#define  IO_PAD78_PIOCFG_SLP_CNTRL_MASK_SHIFT(reg) (((reg) & IO_PAD78_PIOCFG_SLP_CNTRL_MASK) >> IO_PAD78_PIOCFG_SLP_CNTRL_SHIFT)
#define  IO_PAD78_PIOCFG_SLP_CNTRL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD78_PIOCFG_SLP_CNTRL_MASK) | (((uint32_t)val) << IO_PAD78_PIOCFG_SLP_CNTRL_SHIFT))

#define  IO_PAD78_PIOCFG_SLP_DO_MASK 0x100
#define  IO_PAD78_PIOCFG_SLP_DO_SHIFT 8
#define  IO_PAD78_PIOCFG_SLP_DO_MASK_SHIFT(reg) (((reg) & IO_PAD78_PIOCFG_SLP_DO_MASK) >> IO_PAD78_PIOCFG_SLP_DO_SHIFT)
#define  IO_PAD78_PIOCFG_SLP_DO_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD78_PIOCFG_SLP_DO_MASK) | (((uint32_t)val) << IO_PAD78_PIOCFG_SLP_DO_SHIFT))

#define  IO_PAD78_PIOCFG_SLP_DIR_MASK 0x80
#define  IO_PAD78_PIOCFG_SLP_DIR_SHIFT 7
#define  IO_PAD78_PIOCFG_SLP_DIR_MASK_SHIFT(reg) (((reg) & IO_PAD78_PIOCFG_SLP_DIR_MASK) >> IO_PAD78_PIOCFG_SLP_DIR_SHIFT)
#define  IO_PAD78_PIOCFG_SLP_DIR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD78_PIOCFG_SLP_DIR_MASK) | (((uint32_t)val) << IO_PAD78_PIOCFG_SLP_DIR_SHIFT))

#define  IO_PAD78_PIOCFG_EDGE_EN_N_MASK 0x40
#define  IO_PAD78_PIOCFG_EDGE_EN_N_SHIFT 6
#define  IO_PAD78_PIOCFG_EDGE_EN_N_MASK_SHIFT(reg) (((reg) & IO_PAD78_PIOCFG_EDGE_EN_N_MASK) >> IO_PAD78_PIOCFG_EDGE_EN_N_SHIFT)
#define  IO_PAD78_PIOCFG_EDGE_EN_N_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD78_PIOCFG_EDGE_EN_N_MASK) | (((uint32_t)val) << IO_PAD78_PIOCFG_EDGE_EN_N_SHIFT))

#define  IO_PAD78_PIOCFG_EDGE_FALL_EN_MASK 0x20
#define  IO_PAD78_PIOCFG_EDGE_FALL_EN_SHIFT 5
#define  IO_PAD78_PIOCFG_EDGE_FALL_EN_MASK_SHIFT(reg) (((reg) & IO_PAD78_PIOCFG_EDGE_FALL_EN_MASK) >> IO_PAD78_PIOCFG_EDGE_FALL_EN_SHIFT)
#define  IO_PAD78_PIOCFG_EDGE_FALL_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD78_PIOCFG_EDGE_FALL_EN_MASK) | (((uint32_t)val) << IO_PAD78_PIOCFG_EDGE_FALL_EN_SHIFT))

#define  IO_PAD78_PIOCFG_EDGE_RISE_EN_MASK 0x10
#define  IO_PAD78_PIOCFG_EDGE_RISE_EN_SHIFT 4
#define  IO_PAD78_PIOCFG_EDGE_RISE_EN_MASK_SHIFT(reg) (((reg) & IO_PAD78_PIOCFG_EDGE_RISE_EN_MASK) >> IO_PAD78_PIOCFG_EDGE_RISE_EN_SHIFT)
#define  IO_PAD78_PIOCFG_EDGE_RISE_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD78_PIOCFG_EDGE_RISE_EN_MASK) | (((uint32_t)val) << IO_PAD78_PIOCFG_EDGE_RISE_EN_SHIFT))

#define  IO_PAD78_PIOCFG_SLP_SEL_MASK 0x8
#define  IO_PAD78_PIOCFG_SLP_SEL_SHIFT 3
#define  IO_PAD78_PIOCFG_SLP_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD78_PIOCFG_SLP_SEL_MASK) >> IO_PAD78_PIOCFG_SLP_SEL_SHIFT)
#define  IO_PAD78_PIOCFG_SLP_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD78_PIOCFG_SLP_SEL_MASK) | (((uint32_t)val) << IO_PAD78_PIOCFG_SLP_SEL_SHIFT))

#define  IO_PAD78_PIOCFG_FUNC_SEL_MASK 0x7
#define  IO_PAD78_PIOCFG_FUNC_SEL_SHIFT 0
#define  IO_PAD78_PIOCFG_FUNC_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD78_PIOCFG_FUNC_SEL_MASK) >> IO_PAD78_PIOCFG_FUNC_SEL_SHIFT)
#define  IO_PAD78_PIOCFG_FUNC_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD78_PIOCFG_FUNC_SEL_MASK) | (((uint32_t)val) << IO_PAD78_PIOCFG_FUNC_SEL_SHIFT))

//====================================================================
//
//Register File: IO_PAD79 Configuration Registers (IO_PAD79)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

//====================================================================
//Register: IO_PAD79 Configuration Register (PIOCFG)
/** \brief "PHI_PADXDC_IOB" Pad*/
//====================================================================

#define  IO_PAD79_PIOCFG_RESERVED1_MASK 0xfc000000
#define  IO_PAD79_PIOCFG_RESERVED1_SHIFT 26
#define  IO_PAD79_PIOCFG_RESERVED1_MASK_SHIFT(reg) (((reg) & IO_PAD79_PIOCFG_RESERVED1_MASK) >> IO_PAD79_PIOCFG_RESERVED1_SHIFT)
#define  IO_PAD79_PIOCFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD79_PIOCFG_RESERVED1_MASK) | (((uint32_t)val) << IO_PAD79_PIOCFG_RESERVED1_SHIFT))

#define  IO_PAD79_PIOCFG_PD_MASK 0x2000000
#define  IO_PAD79_PIOCFG_PD_SHIFT 25
#define  IO_PAD79_PIOCFG_PD_MASK_SHIFT(reg) (((reg) & IO_PAD79_PIOCFG_PD_MASK) >> IO_PAD79_PIOCFG_PD_SHIFT)
#define  IO_PAD79_PIOCFG_PD_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD79_PIOCFG_PD_MASK) | (((uint32_t)val) << IO_PAD79_PIOCFG_PD_SHIFT))

#define  IO_PAD79_PIOCFG_ODT_EN_MASK 0x1000000
#define  IO_PAD79_PIOCFG_ODT_EN_SHIFT 24
#define  IO_PAD79_PIOCFG_ODT_EN_MASK_SHIFT(reg) (((reg) & IO_PAD79_PIOCFG_ODT_EN_MASK) >> IO_PAD79_PIOCFG_ODT_EN_SHIFT)
#define  IO_PAD79_PIOCFG_ODT_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD79_PIOCFG_ODT_EN_MASK) | (((uint32_t)val) << IO_PAD79_PIOCFG_ODT_EN_SHIFT))

#define  IO_PAD79_PIOCFG_LED_EN_MASK 0x800000
#define  IO_PAD79_PIOCFG_LED_EN_SHIFT 23
#define  IO_PAD79_PIOCFG_LED_EN_MASK_SHIFT(reg) (((reg) & IO_PAD79_PIOCFG_LED_EN_MASK) >> IO_PAD79_PIOCFG_LED_EN_SHIFT)
#define  IO_PAD79_PIOCFG_LED_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD79_PIOCFG_LED_EN_MASK) | (((uint32_t)val) << IO_PAD79_PIOCFG_LED_EN_SHIFT))

#define  IO_PAD79_PIOCFG_I2C_SEL_MASK 0x600000
#define  IO_PAD79_PIOCFG_I2C_SEL_SHIFT 21
#define  IO_PAD79_PIOCFG_I2C_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD79_PIOCFG_I2C_SEL_MASK) >> IO_PAD79_PIOCFG_I2C_SEL_SHIFT)
#define  IO_PAD79_PIOCFG_I2C_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD79_PIOCFG_I2C_SEL_MASK) | (((uint32_t)val) << IO_PAD79_PIOCFG_I2C_SEL_SHIFT))

#define  IO_PAD79_PIOCFG_DGTBSEL_MASK 0x1e0000
#define  IO_PAD79_PIOCFG_DGTBSEL_SHIFT 17
#define  IO_PAD79_PIOCFG_DGTBSEL_MASK_SHIFT(reg) (((reg) & IO_PAD79_PIOCFG_DGTBSEL_MASK) >> IO_PAD79_PIOCFG_DGTBSEL_SHIFT)
#define  IO_PAD79_PIOCFG_DGTBSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD79_PIOCFG_DGTBSEL_MASK) | (((uint32_t)val) << IO_PAD79_PIOCFG_DGTBSEL_SHIFT))

#define  IO_PAD79_PIOCFG_RAWSEL_MASK 0x10000
#define  IO_PAD79_PIOCFG_RAWSEL_SHIFT 16
#define  IO_PAD79_PIOCFG_RAWSEL_MASK_SHIFT(reg) (((reg) & IO_PAD79_PIOCFG_RAWSEL_MASK) >> IO_PAD79_PIOCFG_RAWSEL_SHIFT)
#define  IO_PAD79_PIOCFG_RAWSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD79_PIOCFG_RAWSEL_MASK) | (((uint32_t)val) << IO_PAD79_PIOCFG_RAWSEL_SHIFT))

#define  IO_PAD79_PIOCFG_PULL_SEL_MASK 0x8000
#define  IO_PAD79_PIOCFG_PULL_SEL_SHIFT 15
#define  IO_PAD79_PIOCFG_PULL_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD79_PIOCFG_PULL_SEL_MASK) >> IO_PAD79_PIOCFG_PULL_SEL_SHIFT)
#define  IO_PAD79_PIOCFG_PULL_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD79_PIOCFG_PULL_SEL_MASK) | (((uint32_t)val) << IO_PAD79_PIOCFG_PULL_SEL_SHIFT))

#define  IO_PAD79_PIOCFG_PUEN_MASK 0x4000
#define  IO_PAD79_PIOCFG_PUEN_SHIFT 14
#define  IO_PAD79_PIOCFG_PUEN_MASK_SHIFT(reg) (((reg) & IO_PAD79_PIOCFG_PUEN_MASK) >> IO_PAD79_PIOCFG_PUEN_SHIFT)
#define  IO_PAD79_PIOCFG_PUEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD79_PIOCFG_PUEN_MASK) | (((uint32_t)val) << IO_PAD79_PIOCFG_PUEN_SHIFT))

#define  IO_PAD79_PIOCFG_PDEN_MASK 0x2000
#define  IO_PAD79_PIOCFG_PDEN_SHIFT 13
#define  IO_PAD79_PIOCFG_PDEN_MASK_SHIFT(reg) (((reg) & IO_PAD79_PIOCFG_PDEN_MASK) >> IO_PAD79_PIOCFG_PDEN_SHIFT)
#define  IO_PAD79_PIOCFG_PDEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD79_PIOCFG_PDEN_MASK) | (((uint32_t)val) << IO_PAD79_PIOCFG_PDEN_SHIFT))

#define  IO_PAD79_PIOCFG_SR_MASK 0x1800
#define  IO_PAD79_PIOCFG_SR_SHIFT 11
#define  IO_PAD79_PIOCFG_SR_MASK_SHIFT(reg) (((reg) & IO_PAD79_PIOCFG_SR_MASK) >> IO_PAD79_PIOCFG_SR_SHIFT)
#define  IO_PAD79_PIOCFG_SR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD79_PIOCFG_SR_MASK) | (((uint32_t)val) << IO_PAD79_PIOCFG_SR_SHIFT))

#define  IO_PAD79_PIOCFG_SLP_DI_MASK 0x400
#define  IO_PAD79_PIOCFG_SLP_DI_SHIFT 10
#define  IO_PAD79_PIOCFG_SLP_DI_MASK_SHIFT(reg) (((reg) & IO_PAD79_PIOCFG_SLP_DI_MASK) >> IO_PAD79_PIOCFG_SLP_DI_SHIFT)
#define  IO_PAD79_PIOCFG_SLP_DI_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD79_PIOCFG_SLP_DI_MASK) | (((uint32_t)val) << IO_PAD79_PIOCFG_SLP_DI_SHIFT))

#define  IO_PAD79_PIOCFG_SLP_CNTRL_MASK 0x200
#define  IO_PAD79_PIOCFG_SLP_CNTRL_SHIFT 9
#define  IO_PAD79_PIOCFG_SLP_CNTRL_MASK_SHIFT(reg) (((reg) & IO_PAD79_PIOCFG_SLP_CNTRL_MASK) >> IO_PAD79_PIOCFG_SLP_CNTRL_SHIFT)
#define  IO_PAD79_PIOCFG_SLP_CNTRL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD79_PIOCFG_SLP_CNTRL_MASK) | (((uint32_t)val) << IO_PAD79_PIOCFG_SLP_CNTRL_SHIFT))

#define  IO_PAD79_PIOCFG_SLP_DO_MASK 0x100
#define  IO_PAD79_PIOCFG_SLP_DO_SHIFT 8
#define  IO_PAD79_PIOCFG_SLP_DO_MASK_SHIFT(reg) (((reg) & IO_PAD79_PIOCFG_SLP_DO_MASK) >> IO_PAD79_PIOCFG_SLP_DO_SHIFT)
#define  IO_PAD79_PIOCFG_SLP_DO_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD79_PIOCFG_SLP_DO_MASK) | (((uint32_t)val) << IO_PAD79_PIOCFG_SLP_DO_SHIFT))

#define  IO_PAD79_PIOCFG_SLP_DIR_MASK 0x80
#define  IO_PAD79_PIOCFG_SLP_DIR_SHIFT 7
#define  IO_PAD79_PIOCFG_SLP_DIR_MASK_SHIFT(reg) (((reg) & IO_PAD79_PIOCFG_SLP_DIR_MASK) >> IO_PAD79_PIOCFG_SLP_DIR_SHIFT)
#define  IO_PAD79_PIOCFG_SLP_DIR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD79_PIOCFG_SLP_DIR_MASK) | (((uint32_t)val) << IO_PAD79_PIOCFG_SLP_DIR_SHIFT))

#define  IO_PAD79_PIOCFG_EDGE_EN_N_MASK 0x40
#define  IO_PAD79_PIOCFG_EDGE_EN_N_SHIFT 6
#define  IO_PAD79_PIOCFG_EDGE_EN_N_MASK_SHIFT(reg) (((reg) & IO_PAD79_PIOCFG_EDGE_EN_N_MASK) >> IO_PAD79_PIOCFG_EDGE_EN_N_SHIFT)
#define  IO_PAD79_PIOCFG_EDGE_EN_N_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD79_PIOCFG_EDGE_EN_N_MASK) | (((uint32_t)val) << IO_PAD79_PIOCFG_EDGE_EN_N_SHIFT))

#define  IO_PAD79_PIOCFG_EDGE_FALL_EN_MASK 0x20
#define  IO_PAD79_PIOCFG_EDGE_FALL_EN_SHIFT 5
#define  IO_PAD79_PIOCFG_EDGE_FALL_EN_MASK_SHIFT(reg) (((reg) & IO_PAD79_PIOCFG_EDGE_FALL_EN_MASK) >> IO_PAD79_PIOCFG_EDGE_FALL_EN_SHIFT)
#define  IO_PAD79_PIOCFG_EDGE_FALL_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD79_PIOCFG_EDGE_FALL_EN_MASK) | (((uint32_t)val) << IO_PAD79_PIOCFG_EDGE_FALL_EN_SHIFT))

#define  IO_PAD79_PIOCFG_EDGE_RISE_EN_MASK 0x10
#define  IO_PAD79_PIOCFG_EDGE_RISE_EN_SHIFT 4
#define  IO_PAD79_PIOCFG_EDGE_RISE_EN_MASK_SHIFT(reg) (((reg) & IO_PAD79_PIOCFG_EDGE_RISE_EN_MASK) >> IO_PAD79_PIOCFG_EDGE_RISE_EN_SHIFT)
#define  IO_PAD79_PIOCFG_EDGE_RISE_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD79_PIOCFG_EDGE_RISE_EN_MASK) | (((uint32_t)val) << IO_PAD79_PIOCFG_EDGE_RISE_EN_SHIFT))

#define  IO_PAD79_PIOCFG_SLP_SEL_MASK 0x8
#define  IO_PAD79_PIOCFG_SLP_SEL_SHIFT 3
#define  IO_PAD79_PIOCFG_SLP_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD79_PIOCFG_SLP_SEL_MASK) >> IO_PAD79_PIOCFG_SLP_SEL_SHIFT)
#define  IO_PAD79_PIOCFG_SLP_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD79_PIOCFG_SLP_SEL_MASK) | (((uint32_t)val) << IO_PAD79_PIOCFG_SLP_SEL_SHIFT))

#define  IO_PAD79_PIOCFG_FUNC_SEL_MASK 0x7
#define  IO_PAD79_PIOCFG_FUNC_SEL_SHIFT 0
#define  IO_PAD79_PIOCFG_FUNC_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD79_PIOCFG_FUNC_SEL_MASK) >> IO_PAD79_PIOCFG_FUNC_SEL_SHIFT)
#define  IO_PAD79_PIOCFG_FUNC_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD79_PIOCFG_FUNC_SEL_MASK) | (((uint32_t)val) << IO_PAD79_PIOCFG_FUNC_SEL_SHIFT))

//====================================================================
//
//Register File: IO_PAD80 Configuration Registers (IO_PAD80)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

//====================================================================
//Register: IO_PAD80 Configuration Register (PIOCFG)
/** \brief "PHI_PADXDC_IOB" Pad*/
//====================================================================

#define  IO_PAD80_PIOCFG_RESERVED1_MASK 0xfc000000
#define  IO_PAD80_PIOCFG_RESERVED1_SHIFT 26
#define  IO_PAD80_PIOCFG_RESERVED1_MASK_SHIFT(reg) (((reg) & IO_PAD80_PIOCFG_RESERVED1_MASK) >> IO_PAD80_PIOCFG_RESERVED1_SHIFT)
#define  IO_PAD80_PIOCFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD80_PIOCFG_RESERVED1_MASK) | (((uint32_t)val) << IO_PAD80_PIOCFG_RESERVED1_SHIFT))

#define  IO_PAD80_PIOCFG_PD_MASK 0x2000000
#define  IO_PAD80_PIOCFG_PD_SHIFT 25
#define  IO_PAD80_PIOCFG_PD_MASK_SHIFT(reg) (((reg) & IO_PAD80_PIOCFG_PD_MASK) >> IO_PAD80_PIOCFG_PD_SHIFT)
#define  IO_PAD80_PIOCFG_PD_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD80_PIOCFG_PD_MASK) | (((uint32_t)val) << IO_PAD80_PIOCFG_PD_SHIFT))

#define  IO_PAD80_PIOCFG_ODT_EN_MASK 0x1000000
#define  IO_PAD80_PIOCFG_ODT_EN_SHIFT 24
#define  IO_PAD80_PIOCFG_ODT_EN_MASK_SHIFT(reg) (((reg) & IO_PAD80_PIOCFG_ODT_EN_MASK) >> IO_PAD80_PIOCFG_ODT_EN_SHIFT)
#define  IO_PAD80_PIOCFG_ODT_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD80_PIOCFG_ODT_EN_MASK) | (((uint32_t)val) << IO_PAD80_PIOCFG_ODT_EN_SHIFT))

#define  IO_PAD80_PIOCFG_LED_EN_MASK 0x800000
#define  IO_PAD80_PIOCFG_LED_EN_SHIFT 23
#define  IO_PAD80_PIOCFG_LED_EN_MASK_SHIFT(reg) (((reg) & IO_PAD80_PIOCFG_LED_EN_MASK) >> IO_PAD80_PIOCFG_LED_EN_SHIFT)
#define  IO_PAD80_PIOCFG_LED_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD80_PIOCFG_LED_EN_MASK) | (((uint32_t)val) << IO_PAD80_PIOCFG_LED_EN_SHIFT))

#define  IO_PAD80_PIOCFG_I2C_SEL_MASK 0x600000
#define  IO_PAD80_PIOCFG_I2C_SEL_SHIFT 21
#define  IO_PAD80_PIOCFG_I2C_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD80_PIOCFG_I2C_SEL_MASK) >> IO_PAD80_PIOCFG_I2C_SEL_SHIFT)
#define  IO_PAD80_PIOCFG_I2C_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD80_PIOCFG_I2C_SEL_MASK) | (((uint32_t)val) << IO_PAD80_PIOCFG_I2C_SEL_SHIFT))

#define  IO_PAD80_PIOCFG_DGTBSEL_MASK 0x1e0000
#define  IO_PAD80_PIOCFG_DGTBSEL_SHIFT 17
#define  IO_PAD80_PIOCFG_DGTBSEL_MASK_SHIFT(reg) (((reg) & IO_PAD80_PIOCFG_DGTBSEL_MASK) >> IO_PAD80_PIOCFG_DGTBSEL_SHIFT)
#define  IO_PAD80_PIOCFG_DGTBSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD80_PIOCFG_DGTBSEL_MASK) | (((uint32_t)val) << IO_PAD80_PIOCFG_DGTBSEL_SHIFT))

#define  IO_PAD80_PIOCFG_RAWSEL_MASK 0x10000
#define  IO_PAD80_PIOCFG_RAWSEL_SHIFT 16
#define  IO_PAD80_PIOCFG_RAWSEL_MASK_SHIFT(reg) (((reg) & IO_PAD80_PIOCFG_RAWSEL_MASK) >> IO_PAD80_PIOCFG_RAWSEL_SHIFT)
#define  IO_PAD80_PIOCFG_RAWSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD80_PIOCFG_RAWSEL_MASK) | (((uint32_t)val) << IO_PAD80_PIOCFG_RAWSEL_SHIFT))

#define  IO_PAD80_PIOCFG_PULL_SEL_MASK 0x8000
#define  IO_PAD80_PIOCFG_PULL_SEL_SHIFT 15
#define  IO_PAD80_PIOCFG_PULL_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD80_PIOCFG_PULL_SEL_MASK) >> IO_PAD80_PIOCFG_PULL_SEL_SHIFT)
#define  IO_PAD80_PIOCFG_PULL_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD80_PIOCFG_PULL_SEL_MASK) | (((uint32_t)val) << IO_PAD80_PIOCFG_PULL_SEL_SHIFT))

#define  IO_PAD80_PIOCFG_PUEN_MASK 0x4000
#define  IO_PAD80_PIOCFG_PUEN_SHIFT 14
#define  IO_PAD80_PIOCFG_PUEN_MASK_SHIFT(reg) (((reg) & IO_PAD80_PIOCFG_PUEN_MASK) >> IO_PAD80_PIOCFG_PUEN_SHIFT)
#define  IO_PAD80_PIOCFG_PUEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD80_PIOCFG_PUEN_MASK) | (((uint32_t)val) << IO_PAD80_PIOCFG_PUEN_SHIFT))

#define  IO_PAD80_PIOCFG_PDEN_MASK 0x2000
#define  IO_PAD80_PIOCFG_PDEN_SHIFT 13
#define  IO_PAD80_PIOCFG_PDEN_MASK_SHIFT(reg) (((reg) & IO_PAD80_PIOCFG_PDEN_MASK) >> IO_PAD80_PIOCFG_PDEN_SHIFT)
#define  IO_PAD80_PIOCFG_PDEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD80_PIOCFG_PDEN_MASK) | (((uint32_t)val) << IO_PAD80_PIOCFG_PDEN_SHIFT))

#define  IO_PAD80_PIOCFG_SR_MASK 0x1800
#define  IO_PAD80_PIOCFG_SR_SHIFT 11
#define  IO_PAD80_PIOCFG_SR_MASK_SHIFT(reg) (((reg) & IO_PAD80_PIOCFG_SR_MASK) >> IO_PAD80_PIOCFG_SR_SHIFT)
#define  IO_PAD80_PIOCFG_SR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD80_PIOCFG_SR_MASK) | (((uint32_t)val) << IO_PAD80_PIOCFG_SR_SHIFT))

#define  IO_PAD80_PIOCFG_SLP_DI_MASK 0x400
#define  IO_PAD80_PIOCFG_SLP_DI_SHIFT 10
#define  IO_PAD80_PIOCFG_SLP_DI_MASK_SHIFT(reg) (((reg) & IO_PAD80_PIOCFG_SLP_DI_MASK) >> IO_PAD80_PIOCFG_SLP_DI_SHIFT)
#define  IO_PAD80_PIOCFG_SLP_DI_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD80_PIOCFG_SLP_DI_MASK) | (((uint32_t)val) << IO_PAD80_PIOCFG_SLP_DI_SHIFT))

#define  IO_PAD80_PIOCFG_SLP_CNTRL_MASK 0x200
#define  IO_PAD80_PIOCFG_SLP_CNTRL_SHIFT 9
#define  IO_PAD80_PIOCFG_SLP_CNTRL_MASK_SHIFT(reg) (((reg) & IO_PAD80_PIOCFG_SLP_CNTRL_MASK) >> IO_PAD80_PIOCFG_SLP_CNTRL_SHIFT)
#define  IO_PAD80_PIOCFG_SLP_CNTRL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD80_PIOCFG_SLP_CNTRL_MASK) | (((uint32_t)val) << IO_PAD80_PIOCFG_SLP_CNTRL_SHIFT))

#define  IO_PAD80_PIOCFG_SLP_DO_MASK 0x100
#define  IO_PAD80_PIOCFG_SLP_DO_SHIFT 8
#define  IO_PAD80_PIOCFG_SLP_DO_MASK_SHIFT(reg) (((reg) & IO_PAD80_PIOCFG_SLP_DO_MASK) >> IO_PAD80_PIOCFG_SLP_DO_SHIFT)
#define  IO_PAD80_PIOCFG_SLP_DO_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD80_PIOCFG_SLP_DO_MASK) | (((uint32_t)val) << IO_PAD80_PIOCFG_SLP_DO_SHIFT))

#define  IO_PAD80_PIOCFG_SLP_DIR_MASK 0x80
#define  IO_PAD80_PIOCFG_SLP_DIR_SHIFT 7
#define  IO_PAD80_PIOCFG_SLP_DIR_MASK_SHIFT(reg) (((reg) & IO_PAD80_PIOCFG_SLP_DIR_MASK) >> IO_PAD80_PIOCFG_SLP_DIR_SHIFT)
#define  IO_PAD80_PIOCFG_SLP_DIR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD80_PIOCFG_SLP_DIR_MASK) | (((uint32_t)val) << IO_PAD80_PIOCFG_SLP_DIR_SHIFT))

#define  IO_PAD80_PIOCFG_EDGE_EN_N_MASK 0x40
#define  IO_PAD80_PIOCFG_EDGE_EN_N_SHIFT 6
#define  IO_PAD80_PIOCFG_EDGE_EN_N_MASK_SHIFT(reg) (((reg) & IO_PAD80_PIOCFG_EDGE_EN_N_MASK) >> IO_PAD80_PIOCFG_EDGE_EN_N_SHIFT)
#define  IO_PAD80_PIOCFG_EDGE_EN_N_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD80_PIOCFG_EDGE_EN_N_MASK) | (((uint32_t)val) << IO_PAD80_PIOCFG_EDGE_EN_N_SHIFT))

#define  IO_PAD80_PIOCFG_EDGE_FALL_EN_MASK 0x20
#define  IO_PAD80_PIOCFG_EDGE_FALL_EN_SHIFT 5
#define  IO_PAD80_PIOCFG_EDGE_FALL_EN_MASK_SHIFT(reg) (((reg) & IO_PAD80_PIOCFG_EDGE_FALL_EN_MASK) >> IO_PAD80_PIOCFG_EDGE_FALL_EN_SHIFT)
#define  IO_PAD80_PIOCFG_EDGE_FALL_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD80_PIOCFG_EDGE_FALL_EN_MASK) | (((uint32_t)val) << IO_PAD80_PIOCFG_EDGE_FALL_EN_SHIFT))

#define  IO_PAD80_PIOCFG_EDGE_RISE_EN_MASK 0x10
#define  IO_PAD80_PIOCFG_EDGE_RISE_EN_SHIFT 4
#define  IO_PAD80_PIOCFG_EDGE_RISE_EN_MASK_SHIFT(reg) (((reg) & IO_PAD80_PIOCFG_EDGE_RISE_EN_MASK) >> IO_PAD80_PIOCFG_EDGE_RISE_EN_SHIFT)
#define  IO_PAD80_PIOCFG_EDGE_RISE_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD80_PIOCFG_EDGE_RISE_EN_MASK) | (((uint32_t)val) << IO_PAD80_PIOCFG_EDGE_RISE_EN_SHIFT))

#define  IO_PAD80_PIOCFG_SLP_SEL_MASK 0x8
#define  IO_PAD80_PIOCFG_SLP_SEL_SHIFT 3
#define  IO_PAD80_PIOCFG_SLP_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD80_PIOCFG_SLP_SEL_MASK) >> IO_PAD80_PIOCFG_SLP_SEL_SHIFT)
#define  IO_PAD80_PIOCFG_SLP_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD80_PIOCFG_SLP_SEL_MASK) | (((uint32_t)val) << IO_PAD80_PIOCFG_SLP_SEL_SHIFT))

#define  IO_PAD80_PIOCFG_FUNC_SEL_MASK 0x7
#define  IO_PAD80_PIOCFG_FUNC_SEL_SHIFT 0
#define  IO_PAD80_PIOCFG_FUNC_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD80_PIOCFG_FUNC_SEL_MASK) >> IO_PAD80_PIOCFG_FUNC_SEL_SHIFT)
#define  IO_PAD80_PIOCFG_FUNC_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD80_PIOCFG_FUNC_SEL_MASK) | (((uint32_t)val) << IO_PAD80_PIOCFG_FUNC_SEL_SHIFT))

//====================================================================
//
//Register File: IO_PAD81 Configuration Registers (IO_PAD81)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

//====================================================================
//Register: IO_PAD81 Configuration Register (PIOCFG)
/** \brief "PHI_PADXDC_IOB" Pad*/
//====================================================================

#define  IO_PAD81_PIOCFG_RESERVED1_MASK 0xfc000000
#define  IO_PAD81_PIOCFG_RESERVED1_SHIFT 26
#define  IO_PAD81_PIOCFG_RESERVED1_MASK_SHIFT(reg) (((reg) & IO_PAD81_PIOCFG_RESERVED1_MASK) >> IO_PAD81_PIOCFG_RESERVED1_SHIFT)
#define  IO_PAD81_PIOCFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD81_PIOCFG_RESERVED1_MASK) | (((uint32_t)val) << IO_PAD81_PIOCFG_RESERVED1_SHIFT))

#define  IO_PAD81_PIOCFG_PD_MASK 0x2000000
#define  IO_PAD81_PIOCFG_PD_SHIFT 25
#define  IO_PAD81_PIOCFG_PD_MASK_SHIFT(reg) (((reg) & IO_PAD81_PIOCFG_PD_MASK) >> IO_PAD81_PIOCFG_PD_SHIFT)
#define  IO_PAD81_PIOCFG_PD_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD81_PIOCFG_PD_MASK) | (((uint32_t)val) << IO_PAD81_PIOCFG_PD_SHIFT))

#define  IO_PAD81_PIOCFG_ODT_EN_MASK 0x1000000
#define  IO_PAD81_PIOCFG_ODT_EN_SHIFT 24
#define  IO_PAD81_PIOCFG_ODT_EN_MASK_SHIFT(reg) (((reg) & IO_PAD81_PIOCFG_ODT_EN_MASK) >> IO_PAD81_PIOCFG_ODT_EN_SHIFT)
#define  IO_PAD81_PIOCFG_ODT_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD81_PIOCFG_ODT_EN_MASK) | (((uint32_t)val) << IO_PAD81_PIOCFG_ODT_EN_SHIFT))

#define  IO_PAD81_PIOCFG_LED_EN_MASK 0x800000
#define  IO_PAD81_PIOCFG_LED_EN_SHIFT 23
#define  IO_PAD81_PIOCFG_LED_EN_MASK_SHIFT(reg) (((reg) & IO_PAD81_PIOCFG_LED_EN_MASK) >> IO_PAD81_PIOCFG_LED_EN_SHIFT)
#define  IO_PAD81_PIOCFG_LED_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD81_PIOCFG_LED_EN_MASK) | (((uint32_t)val) << IO_PAD81_PIOCFG_LED_EN_SHIFT))

#define  IO_PAD81_PIOCFG_I2C_SEL_MASK 0x600000
#define  IO_PAD81_PIOCFG_I2C_SEL_SHIFT 21
#define  IO_PAD81_PIOCFG_I2C_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD81_PIOCFG_I2C_SEL_MASK) >> IO_PAD81_PIOCFG_I2C_SEL_SHIFT)
#define  IO_PAD81_PIOCFG_I2C_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD81_PIOCFG_I2C_SEL_MASK) | (((uint32_t)val) << IO_PAD81_PIOCFG_I2C_SEL_SHIFT))

#define  IO_PAD81_PIOCFG_DGTBSEL_MASK 0x1e0000
#define  IO_PAD81_PIOCFG_DGTBSEL_SHIFT 17
#define  IO_PAD81_PIOCFG_DGTBSEL_MASK_SHIFT(reg) (((reg) & IO_PAD81_PIOCFG_DGTBSEL_MASK) >> IO_PAD81_PIOCFG_DGTBSEL_SHIFT)
#define  IO_PAD81_PIOCFG_DGTBSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD81_PIOCFG_DGTBSEL_MASK) | (((uint32_t)val) << IO_PAD81_PIOCFG_DGTBSEL_SHIFT))

#define  IO_PAD81_PIOCFG_RAWSEL_MASK 0x10000
#define  IO_PAD81_PIOCFG_RAWSEL_SHIFT 16
#define  IO_PAD81_PIOCFG_RAWSEL_MASK_SHIFT(reg) (((reg) & IO_PAD81_PIOCFG_RAWSEL_MASK) >> IO_PAD81_PIOCFG_RAWSEL_SHIFT)
#define  IO_PAD81_PIOCFG_RAWSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD81_PIOCFG_RAWSEL_MASK) | (((uint32_t)val) << IO_PAD81_PIOCFG_RAWSEL_SHIFT))

#define  IO_PAD81_PIOCFG_PULL_SEL_MASK 0x8000
#define  IO_PAD81_PIOCFG_PULL_SEL_SHIFT 15
#define  IO_PAD81_PIOCFG_PULL_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD81_PIOCFG_PULL_SEL_MASK) >> IO_PAD81_PIOCFG_PULL_SEL_SHIFT)
#define  IO_PAD81_PIOCFG_PULL_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD81_PIOCFG_PULL_SEL_MASK) | (((uint32_t)val) << IO_PAD81_PIOCFG_PULL_SEL_SHIFT))

#define  IO_PAD81_PIOCFG_PUEN_MASK 0x4000
#define  IO_PAD81_PIOCFG_PUEN_SHIFT 14
#define  IO_PAD81_PIOCFG_PUEN_MASK_SHIFT(reg) (((reg) & IO_PAD81_PIOCFG_PUEN_MASK) >> IO_PAD81_PIOCFG_PUEN_SHIFT)
#define  IO_PAD81_PIOCFG_PUEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD81_PIOCFG_PUEN_MASK) | (((uint32_t)val) << IO_PAD81_PIOCFG_PUEN_SHIFT))

#define  IO_PAD81_PIOCFG_PDEN_MASK 0x2000
#define  IO_PAD81_PIOCFG_PDEN_SHIFT 13
#define  IO_PAD81_PIOCFG_PDEN_MASK_SHIFT(reg) (((reg) & IO_PAD81_PIOCFG_PDEN_MASK) >> IO_PAD81_PIOCFG_PDEN_SHIFT)
#define  IO_PAD81_PIOCFG_PDEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD81_PIOCFG_PDEN_MASK) | (((uint32_t)val) << IO_PAD81_PIOCFG_PDEN_SHIFT))

#define  IO_PAD81_PIOCFG_SR_MASK 0x1800
#define  IO_PAD81_PIOCFG_SR_SHIFT 11
#define  IO_PAD81_PIOCFG_SR_MASK_SHIFT(reg) (((reg) & IO_PAD81_PIOCFG_SR_MASK) >> IO_PAD81_PIOCFG_SR_SHIFT)
#define  IO_PAD81_PIOCFG_SR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD81_PIOCFG_SR_MASK) | (((uint32_t)val) << IO_PAD81_PIOCFG_SR_SHIFT))

#define  IO_PAD81_PIOCFG_SLP_DI_MASK 0x400
#define  IO_PAD81_PIOCFG_SLP_DI_SHIFT 10
#define  IO_PAD81_PIOCFG_SLP_DI_MASK_SHIFT(reg) (((reg) & IO_PAD81_PIOCFG_SLP_DI_MASK) >> IO_PAD81_PIOCFG_SLP_DI_SHIFT)
#define  IO_PAD81_PIOCFG_SLP_DI_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD81_PIOCFG_SLP_DI_MASK) | (((uint32_t)val) << IO_PAD81_PIOCFG_SLP_DI_SHIFT))

#define  IO_PAD81_PIOCFG_SLP_CNTRL_MASK 0x200
#define  IO_PAD81_PIOCFG_SLP_CNTRL_SHIFT 9
#define  IO_PAD81_PIOCFG_SLP_CNTRL_MASK_SHIFT(reg) (((reg) & IO_PAD81_PIOCFG_SLP_CNTRL_MASK) >> IO_PAD81_PIOCFG_SLP_CNTRL_SHIFT)
#define  IO_PAD81_PIOCFG_SLP_CNTRL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD81_PIOCFG_SLP_CNTRL_MASK) | (((uint32_t)val) << IO_PAD81_PIOCFG_SLP_CNTRL_SHIFT))

#define  IO_PAD81_PIOCFG_SLP_DO_MASK 0x100
#define  IO_PAD81_PIOCFG_SLP_DO_SHIFT 8
#define  IO_PAD81_PIOCFG_SLP_DO_MASK_SHIFT(reg) (((reg) & IO_PAD81_PIOCFG_SLP_DO_MASK) >> IO_PAD81_PIOCFG_SLP_DO_SHIFT)
#define  IO_PAD81_PIOCFG_SLP_DO_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD81_PIOCFG_SLP_DO_MASK) | (((uint32_t)val) << IO_PAD81_PIOCFG_SLP_DO_SHIFT))

#define  IO_PAD81_PIOCFG_SLP_DIR_MASK 0x80
#define  IO_PAD81_PIOCFG_SLP_DIR_SHIFT 7
#define  IO_PAD81_PIOCFG_SLP_DIR_MASK_SHIFT(reg) (((reg) & IO_PAD81_PIOCFG_SLP_DIR_MASK) >> IO_PAD81_PIOCFG_SLP_DIR_SHIFT)
#define  IO_PAD81_PIOCFG_SLP_DIR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD81_PIOCFG_SLP_DIR_MASK) | (((uint32_t)val) << IO_PAD81_PIOCFG_SLP_DIR_SHIFT))

#define  IO_PAD81_PIOCFG_EDGE_EN_N_MASK 0x40
#define  IO_PAD81_PIOCFG_EDGE_EN_N_SHIFT 6
#define  IO_PAD81_PIOCFG_EDGE_EN_N_MASK_SHIFT(reg) (((reg) & IO_PAD81_PIOCFG_EDGE_EN_N_MASK) >> IO_PAD81_PIOCFG_EDGE_EN_N_SHIFT)
#define  IO_PAD81_PIOCFG_EDGE_EN_N_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD81_PIOCFG_EDGE_EN_N_MASK) | (((uint32_t)val) << IO_PAD81_PIOCFG_EDGE_EN_N_SHIFT))

#define  IO_PAD81_PIOCFG_EDGE_FALL_EN_MASK 0x20
#define  IO_PAD81_PIOCFG_EDGE_FALL_EN_SHIFT 5
#define  IO_PAD81_PIOCFG_EDGE_FALL_EN_MASK_SHIFT(reg) (((reg) & IO_PAD81_PIOCFG_EDGE_FALL_EN_MASK) >> IO_PAD81_PIOCFG_EDGE_FALL_EN_SHIFT)
#define  IO_PAD81_PIOCFG_EDGE_FALL_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD81_PIOCFG_EDGE_FALL_EN_MASK) | (((uint32_t)val) << IO_PAD81_PIOCFG_EDGE_FALL_EN_SHIFT))

#define  IO_PAD81_PIOCFG_EDGE_RISE_EN_MASK 0x10
#define  IO_PAD81_PIOCFG_EDGE_RISE_EN_SHIFT 4
#define  IO_PAD81_PIOCFG_EDGE_RISE_EN_MASK_SHIFT(reg) (((reg) & IO_PAD81_PIOCFG_EDGE_RISE_EN_MASK) >> IO_PAD81_PIOCFG_EDGE_RISE_EN_SHIFT)
#define  IO_PAD81_PIOCFG_EDGE_RISE_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD81_PIOCFG_EDGE_RISE_EN_MASK) | (((uint32_t)val) << IO_PAD81_PIOCFG_EDGE_RISE_EN_SHIFT))

#define  IO_PAD81_PIOCFG_SLP_SEL_MASK 0x8
#define  IO_PAD81_PIOCFG_SLP_SEL_SHIFT 3
#define  IO_PAD81_PIOCFG_SLP_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD81_PIOCFG_SLP_SEL_MASK) >> IO_PAD81_PIOCFG_SLP_SEL_SHIFT)
#define  IO_PAD81_PIOCFG_SLP_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD81_PIOCFG_SLP_SEL_MASK) | (((uint32_t)val) << IO_PAD81_PIOCFG_SLP_SEL_SHIFT))

#define  IO_PAD81_PIOCFG_FUNC_SEL_MASK 0x7
#define  IO_PAD81_PIOCFG_FUNC_SEL_SHIFT 0
#define  IO_PAD81_PIOCFG_FUNC_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD81_PIOCFG_FUNC_SEL_MASK) >> IO_PAD81_PIOCFG_FUNC_SEL_SHIFT)
#define  IO_PAD81_PIOCFG_FUNC_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD81_PIOCFG_FUNC_SEL_MASK) | (((uint32_t)val) << IO_PAD81_PIOCFG_FUNC_SEL_SHIFT))

//====================================================================
//
//Register File: IO_PAD82 Configuration Registers (IO_PAD82)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

//====================================================================
//Register: IO_PAD82 Configuration Register (PIOCFG)
/** \brief "PHI_PADXDC_IOB" Pad*/
//====================================================================

#define  IO_PAD82_PIOCFG_RESERVED1_MASK 0xfc000000
#define  IO_PAD82_PIOCFG_RESERVED1_SHIFT 26
#define  IO_PAD82_PIOCFG_RESERVED1_MASK_SHIFT(reg) (((reg) & IO_PAD82_PIOCFG_RESERVED1_MASK) >> IO_PAD82_PIOCFG_RESERVED1_SHIFT)
#define  IO_PAD82_PIOCFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD82_PIOCFG_RESERVED1_MASK) | (((uint32_t)val) << IO_PAD82_PIOCFG_RESERVED1_SHIFT))

#define  IO_PAD82_PIOCFG_PD_MASK 0x2000000
#define  IO_PAD82_PIOCFG_PD_SHIFT 25
#define  IO_PAD82_PIOCFG_PD_MASK_SHIFT(reg) (((reg) & IO_PAD82_PIOCFG_PD_MASK) >> IO_PAD82_PIOCFG_PD_SHIFT)
#define  IO_PAD82_PIOCFG_PD_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD82_PIOCFG_PD_MASK) | (((uint32_t)val) << IO_PAD82_PIOCFG_PD_SHIFT))

#define  IO_PAD82_PIOCFG_ODT_EN_MASK 0x1000000
#define  IO_PAD82_PIOCFG_ODT_EN_SHIFT 24
#define  IO_PAD82_PIOCFG_ODT_EN_MASK_SHIFT(reg) (((reg) & IO_PAD82_PIOCFG_ODT_EN_MASK) >> IO_PAD82_PIOCFG_ODT_EN_SHIFT)
#define  IO_PAD82_PIOCFG_ODT_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD82_PIOCFG_ODT_EN_MASK) | (((uint32_t)val) << IO_PAD82_PIOCFG_ODT_EN_SHIFT))

#define  IO_PAD82_PIOCFG_LED_EN_MASK 0x800000
#define  IO_PAD82_PIOCFG_LED_EN_SHIFT 23
#define  IO_PAD82_PIOCFG_LED_EN_MASK_SHIFT(reg) (((reg) & IO_PAD82_PIOCFG_LED_EN_MASK) >> IO_PAD82_PIOCFG_LED_EN_SHIFT)
#define  IO_PAD82_PIOCFG_LED_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD82_PIOCFG_LED_EN_MASK) | (((uint32_t)val) << IO_PAD82_PIOCFG_LED_EN_SHIFT))

#define  IO_PAD82_PIOCFG_I2C_SEL_MASK 0x600000
#define  IO_PAD82_PIOCFG_I2C_SEL_SHIFT 21
#define  IO_PAD82_PIOCFG_I2C_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD82_PIOCFG_I2C_SEL_MASK) >> IO_PAD82_PIOCFG_I2C_SEL_SHIFT)
#define  IO_PAD82_PIOCFG_I2C_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD82_PIOCFG_I2C_SEL_MASK) | (((uint32_t)val) << IO_PAD82_PIOCFG_I2C_SEL_SHIFT))

#define  IO_PAD82_PIOCFG_DGTBSEL_MASK 0x1e0000
#define  IO_PAD82_PIOCFG_DGTBSEL_SHIFT 17
#define  IO_PAD82_PIOCFG_DGTBSEL_MASK_SHIFT(reg) (((reg) & IO_PAD82_PIOCFG_DGTBSEL_MASK) >> IO_PAD82_PIOCFG_DGTBSEL_SHIFT)
#define  IO_PAD82_PIOCFG_DGTBSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD82_PIOCFG_DGTBSEL_MASK) | (((uint32_t)val) << IO_PAD82_PIOCFG_DGTBSEL_SHIFT))

#define  IO_PAD82_PIOCFG_RAWSEL_MASK 0x10000
#define  IO_PAD82_PIOCFG_RAWSEL_SHIFT 16
#define  IO_PAD82_PIOCFG_RAWSEL_MASK_SHIFT(reg) (((reg) & IO_PAD82_PIOCFG_RAWSEL_MASK) >> IO_PAD82_PIOCFG_RAWSEL_SHIFT)
#define  IO_PAD82_PIOCFG_RAWSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD82_PIOCFG_RAWSEL_MASK) | (((uint32_t)val) << IO_PAD82_PIOCFG_RAWSEL_SHIFT))

#define  IO_PAD82_PIOCFG_PULL_SEL_MASK 0x8000
#define  IO_PAD82_PIOCFG_PULL_SEL_SHIFT 15
#define  IO_PAD82_PIOCFG_PULL_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD82_PIOCFG_PULL_SEL_MASK) >> IO_PAD82_PIOCFG_PULL_SEL_SHIFT)
#define  IO_PAD82_PIOCFG_PULL_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD82_PIOCFG_PULL_SEL_MASK) | (((uint32_t)val) << IO_PAD82_PIOCFG_PULL_SEL_SHIFT))

#define  IO_PAD82_PIOCFG_PUEN_MASK 0x4000
#define  IO_PAD82_PIOCFG_PUEN_SHIFT 14
#define  IO_PAD82_PIOCFG_PUEN_MASK_SHIFT(reg) (((reg) & IO_PAD82_PIOCFG_PUEN_MASK) >> IO_PAD82_PIOCFG_PUEN_SHIFT)
#define  IO_PAD82_PIOCFG_PUEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD82_PIOCFG_PUEN_MASK) | (((uint32_t)val) << IO_PAD82_PIOCFG_PUEN_SHIFT))

#define  IO_PAD82_PIOCFG_PDEN_MASK 0x2000
#define  IO_PAD82_PIOCFG_PDEN_SHIFT 13
#define  IO_PAD82_PIOCFG_PDEN_MASK_SHIFT(reg) (((reg) & IO_PAD82_PIOCFG_PDEN_MASK) >> IO_PAD82_PIOCFG_PDEN_SHIFT)
#define  IO_PAD82_PIOCFG_PDEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD82_PIOCFG_PDEN_MASK) | (((uint32_t)val) << IO_PAD82_PIOCFG_PDEN_SHIFT))

#define  IO_PAD82_PIOCFG_SR_MASK 0x1800
#define  IO_PAD82_PIOCFG_SR_SHIFT 11
#define  IO_PAD82_PIOCFG_SR_MASK_SHIFT(reg) (((reg) & IO_PAD82_PIOCFG_SR_MASK) >> IO_PAD82_PIOCFG_SR_SHIFT)
#define  IO_PAD82_PIOCFG_SR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD82_PIOCFG_SR_MASK) | (((uint32_t)val) << IO_PAD82_PIOCFG_SR_SHIFT))

#define  IO_PAD82_PIOCFG_SLP_DI_MASK 0x400
#define  IO_PAD82_PIOCFG_SLP_DI_SHIFT 10
#define  IO_PAD82_PIOCFG_SLP_DI_MASK_SHIFT(reg) (((reg) & IO_PAD82_PIOCFG_SLP_DI_MASK) >> IO_PAD82_PIOCFG_SLP_DI_SHIFT)
#define  IO_PAD82_PIOCFG_SLP_DI_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD82_PIOCFG_SLP_DI_MASK) | (((uint32_t)val) << IO_PAD82_PIOCFG_SLP_DI_SHIFT))

#define  IO_PAD82_PIOCFG_SLP_CNTRL_MASK 0x200
#define  IO_PAD82_PIOCFG_SLP_CNTRL_SHIFT 9
#define  IO_PAD82_PIOCFG_SLP_CNTRL_MASK_SHIFT(reg) (((reg) & IO_PAD82_PIOCFG_SLP_CNTRL_MASK) >> IO_PAD82_PIOCFG_SLP_CNTRL_SHIFT)
#define  IO_PAD82_PIOCFG_SLP_CNTRL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD82_PIOCFG_SLP_CNTRL_MASK) | (((uint32_t)val) << IO_PAD82_PIOCFG_SLP_CNTRL_SHIFT))

#define  IO_PAD82_PIOCFG_SLP_DO_MASK 0x100
#define  IO_PAD82_PIOCFG_SLP_DO_SHIFT 8
#define  IO_PAD82_PIOCFG_SLP_DO_MASK_SHIFT(reg) (((reg) & IO_PAD82_PIOCFG_SLP_DO_MASK) >> IO_PAD82_PIOCFG_SLP_DO_SHIFT)
#define  IO_PAD82_PIOCFG_SLP_DO_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD82_PIOCFG_SLP_DO_MASK) | (((uint32_t)val) << IO_PAD82_PIOCFG_SLP_DO_SHIFT))

#define  IO_PAD82_PIOCFG_SLP_DIR_MASK 0x80
#define  IO_PAD82_PIOCFG_SLP_DIR_SHIFT 7
#define  IO_PAD82_PIOCFG_SLP_DIR_MASK_SHIFT(reg) (((reg) & IO_PAD82_PIOCFG_SLP_DIR_MASK) >> IO_PAD82_PIOCFG_SLP_DIR_SHIFT)
#define  IO_PAD82_PIOCFG_SLP_DIR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD82_PIOCFG_SLP_DIR_MASK) | (((uint32_t)val) << IO_PAD82_PIOCFG_SLP_DIR_SHIFT))

#define  IO_PAD82_PIOCFG_EDGE_EN_N_MASK 0x40
#define  IO_PAD82_PIOCFG_EDGE_EN_N_SHIFT 6
#define  IO_PAD82_PIOCFG_EDGE_EN_N_MASK_SHIFT(reg) (((reg) & IO_PAD82_PIOCFG_EDGE_EN_N_MASK) >> IO_PAD82_PIOCFG_EDGE_EN_N_SHIFT)
#define  IO_PAD82_PIOCFG_EDGE_EN_N_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD82_PIOCFG_EDGE_EN_N_MASK) | (((uint32_t)val) << IO_PAD82_PIOCFG_EDGE_EN_N_SHIFT))

#define  IO_PAD82_PIOCFG_EDGE_FALL_EN_MASK 0x20
#define  IO_PAD82_PIOCFG_EDGE_FALL_EN_SHIFT 5
#define  IO_PAD82_PIOCFG_EDGE_FALL_EN_MASK_SHIFT(reg) (((reg) & IO_PAD82_PIOCFG_EDGE_FALL_EN_MASK) >> IO_PAD82_PIOCFG_EDGE_FALL_EN_SHIFT)
#define  IO_PAD82_PIOCFG_EDGE_FALL_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD82_PIOCFG_EDGE_FALL_EN_MASK) | (((uint32_t)val) << IO_PAD82_PIOCFG_EDGE_FALL_EN_SHIFT))

#define  IO_PAD82_PIOCFG_EDGE_RISE_EN_MASK 0x10
#define  IO_PAD82_PIOCFG_EDGE_RISE_EN_SHIFT 4
#define  IO_PAD82_PIOCFG_EDGE_RISE_EN_MASK_SHIFT(reg) (((reg) & IO_PAD82_PIOCFG_EDGE_RISE_EN_MASK) >> IO_PAD82_PIOCFG_EDGE_RISE_EN_SHIFT)
#define  IO_PAD82_PIOCFG_EDGE_RISE_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD82_PIOCFG_EDGE_RISE_EN_MASK) | (((uint32_t)val) << IO_PAD82_PIOCFG_EDGE_RISE_EN_SHIFT))

#define  IO_PAD82_PIOCFG_SLP_SEL_MASK 0x8
#define  IO_PAD82_PIOCFG_SLP_SEL_SHIFT 3
#define  IO_PAD82_PIOCFG_SLP_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD82_PIOCFG_SLP_SEL_MASK) >> IO_PAD82_PIOCFG_SLP_SEL_SHIFT)
#define  IO_PAD82_PIOCFG_SLP_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD82_PIOCFG_SLP_SEL_MASK) | (((uint32_t)val) << IO_PAD82_PIOCFG_SLP_SEL_SHIFT))

#define  IO_PAD82_PIOCFG_FUNC_SEL_MASK 0x7
#define  IO_PAD82_PIOCFG_FUNC_SEL_SHIFT 0
#define  IO_PAD82_PIOCFG_FUNC_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD82_PIOCFG_FUNC_SEL_MASK) >> IO_PAD82_PIOCFG_FUNC_SEL_SHIFT)
#define  IO_PAD82_PIOCFG_FUNC_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD82_PIOCFG_FUNC_SEL_MASK) | (((uint32_t)val) << IO_PAD82_PIOCFG_FUNC_SEL_SHIFT))

//====================================================================
//
//Register File: IO_PAD83 Configuration Registers (IO_PAD83)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

//====================================================================
//Register: IO_PAD83 Configuration Register (PIOCFG)
/** \brief "PHI_PADXDC_IOB" Pad*/
//====================================================================

#define  IO_PAD83_PIOCFG_RESERVED1_MASK 0xfc000000
#define  IO_PAD83_PIOCFG_RESERVED1_SHIFT 26
#define  IO_PAD83_PIOCFG_RESERVED1_MASK_SHIFT(reg) (((reg) & IO_PAD83_PIOCFG_RESERVED1_MASK) >> IO_PAD83_PIOCFG_RESERVED1_SHIFT)
#define  IO_PAD83_PIOCFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD83_PIOCFG_RESERVED1_MASK) | (((uint32_t)val) << IO_PAD83_PIOCFG_RESERVED1_SHIFT))

#define  IO_PAD83_PIOCFG_PD_MASK 0x2000000
#define  IO_PAD83_PIOCFG_PD_SHIFT 25
#define  IO_PAD83_PIOCFG_PD_MASK_SHIFT(reg) (((reg) & IO_PAD83_PIOCFG_PD_MASK) >> IO_PAD83_PIOCFG_PD_SHIFT)
#define  IO_PAD83_PIOCFG_PD_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD83_PIOCFG_PD_MASK) | (((uint32_t)val) << IO_PAD83_PIOCFG_PD_SHIFT))

#define  IO_PAD83_PIOCFG_ODT_EN_MASK 0x1000000
#define  IO_PAD83_PIOCFG_ODT_EN_SHIFT 24
#define  IO_PAD83_PIOCFG_ODT_EN_MASK_SHIFT(reg) (((reg) & IO_PAD83_PIOCFG_ODT_EN_MASK) >> IO_PAD83_PIOCFG_ODT_EN_SHIFT)
#define  IO_PAD83_PIOCFG_ODT_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD83_PIOCFG_ODT_EN_MASK) | (((uint32_t)val) << IO_PAD83_PIOCFG_ODT_EN_SHIFT))

#define  IO_PAD83_PIOCFG_LED_EN_MASK 0x800000
#define  IO_PAD83_PIOCFG_LED_EN_SHIFT 23
#define  IO_PAD83_PIOCFG_LED_EN_MASK_SHIFT(reg) (((reg) & IO_PAD83_PIOCFG_LED_EN_MASK) >> IO_PAD83_PIOCFG_LED_EN_SHIFT)
#define  IO_PAD83_PIOCFG_LED_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD83_PIOCFG_LED_EN_MASK) | (((uint32_t)val) << IO_PAD83_PIOCFG_LED_EN_SHIFT))

#define  IO_PAD83_PIOCFG_I2C_SEL_MASK 0x600000
#define  IO_PAD83_PIOCFG_I2C_SEL_SHIFT 21
#define  IO_PAD83_PIOCFG_I2C_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD83_PIOCFG_I2C_SEL_MASK) >> IO_PAD83_PIOCFG_I2C_SEL_SHIFT)
#define  IO_PAD83_PIOCFG_I2C_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD83_PIOCFG_I2C_SEL_MASK) | (((uint32_t)val) << IO_PAD83_PIOCFG_I2C_SEL_SHIFT))

#define  IO_PAD83_PIOCFG_DGTBSEL_MASK 0x1e0000
#define  IO_PAD83_PIOCFG_DGTBSEL_SHIFT 17
#define  IO_PAD83_PIOCFG_DGTBSEL_MASK_SHIFT(reg) (((reg) & IO_PAD83_PIOCFG_DGTBSEL_MASK) >> IO_PAD83_PIOCFG_DGTBSEL_SHIFT)
#define  IO_PAD83_PIOCFG_DGTBSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD83_PIOCFG_DGTBSEL_MASK) | (((uint32_t)val) << IO_PAD83_PIOCFG_DGTBSEL_SHIFT))

#define  IO_PAD83_PIOCFG_RAWSEL_MASK 0x10000
#define  IO_PAD83_PIOCFG_RAWSEL_SHIFT 16
#define  IO_PAD83_PIOCFG_RAWSEL_MASK_SHIFT(reg) (((reg) & IO_PAD83_PIOCFG_RAWSEL_MASK) >> IO_PAD83_PIOCFG_RAWSEL_SHIFT)
#define  IO_PAD83_PIOCFG_RAWSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD83_PIOCFG_RAWSEL_MASK) | (((uint32_t)val) << IO_PAD83_PIOCFG_RAWSEL_SHIFT))

#define  IO_PAD83_PIOCFG_PULL_SEL_MASK 0x8000
#define  IO_PAD83_PIOCFG_PULL_SEL_SHIFT 15
#define  IO_PAD83_PIOCFG_PULL_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD83_PIOCFG_PULL_SEL_MASK) >> IO_PAD83_PIOCFG_PULL_SEL_SHIFT)
#define  IO_PAD83_PIOCFG_PULL_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD83_PIOCFG_PULL_SEL_MASK) | (((uint32_t)val) << IO_PAD83_PIOCFG_PULL_SEL_SHIFT))

#define  IO_PAD83_PIOCFG_PUEN_MASK 0x4000
#define  IO_PAD83_PIOCFG_PUEN_SHIFT 14
#define  IO_PAD83_PIOCFG_PUEN_MASK_SHIFT(reg) (((reg) & IO_PAD83_PIOCFG_PUEN_MASK) >> IO_PAD83_PIOCFG_PUEN_SHIFT)
#define  IO_PAD83_PIOCFG_PUEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD83_PIOCFG_PUEN_MASK) | (((uint32_t)val) << IO_PAD83_PIOCFG_PUEN_SHIFT))

#define  IO_PAD83_PIOCFG_PDEN_MASK 0x2000
#define  IO_PAD83_PIOCFG_PDEN_SHIFT 13
#define  IO_PAD83_PIOCFG_PDEN_MASK_SHIFT(reg) (((reg) & IO_PAD83_PIOCFG_PDEN_MASK) >> IO_PAD83_PIOCFG_PDEN_SHIFT)
#define  IO_PAD83_PIOCFG_PDEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD83_PIOCFG_PDEN_MASK) | (((uint32_t)val) << IO_PAD83_PIOCFG_PDEN_SHIFT))

#define  IO_PAD83_PIOCFG_SR_MASK 0x1800
#define  IO_PAD83_PIOCFG_SR_SHIFT 11
#define  IO_PAD83_PIOCFG_SR_MASK_SHIFT(reg) (((reg) & IO_PAD83_PIOCFG_SR_MASK) >> IO_PAD83_PIOCFG_SR_SHIFT)
#define  IO_PAD83_PIOCFG_SR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD83_PIOCFG_SR_MASK) | (((uint32_t)val) << IO_PAD83_PIOCFG_SR_SHIFT))

#define  IO_PAD83_PIOCFG_SLP_DI_MASK 0x400
#define  IO_PAD83_PIOCFG_SLP_DI_SHIFT 10
#define  IO_PAD83_PIOCFG_SLP_DI_MASK_SHIFT(reg) (((reg) & IO_PAD83_PIOCFG_SLP_DI_MASK) >> IO_PAD83_PIOCFG_SLP_DI_SHIFT)
#define  IO_PAD83_PIOCFG_SLP_DI_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD83_PIOCFG_SLP_DI_MASK) | (((uint32_t)val) << IO_PAD83_PIOCFG_SLP_DI_SHIFT))

#define  IO_PAD83_PIOCFG_SLP_CNTRL_MASK 0x200
#define  IO_PAD83_PIOCFG_SLP_CNTRL_SHIFT 9
#define  IO_PAD83_PIOCFG_SLP_CNTRL_MASK_SHIFT(reg) (((reg) & IO_PAD83_PIOCFG_SLP_CNTRL_MASK) >> IO_PAD83_PIOCFG_SLP_CNTRL_SHIFT)
#define  IO_PAD83_PIOCFG_SLP_CNTRL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD83_PIOCFG_SLP_CNTRL_MASK) | (((uint32_t)val) << IO_PAD83_PIOCFG_SLP_CNTRL_SHIFT))

#define  IO_PAD83_PIOCFG_SLP_DO_MASK 0x100
#define  IO_PAD83_PIOCFG_SLP_DO_SHIFT 8
#define  IO_PAD83_PIOCFG_SLP_DO_MASK_SHIFT(reg) (((reg) & IO_PAD83_PIOCFG_SLP_DO_MASK) >> IO_PAD83_PIOCFG_SLP_DO_SHIFT)
#define  IO_PAD83_PIOCFG_SLP_DO_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD83_PIOCFG_SLP_DO_MASK) | (((uint32_t)val) << IO_PAD83_PIOCFG_SLP_DO_SHIFT))

#define  IO_PAD83_PIOCFG_SLP_DIR_MASK 0x80
#define  IO_PAD83_PIOCFG_SLP_DIR_SHIFT 7
#define  IO_PAD83_PIOCFG_SLP_DIR_MASK_SHIFT(reg) (((reg) & IO_PAD83_PIOCFG_SLP_DIR_MASK) >> IO_PAD83_PIOCFG_SLP_DIR_SHIFT)
#define  IO_PAD83_PIOCFG_SLP_DIR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD83_PIOCFG_SLP_DIR_MASK) | (((uint32_t)val) << IO_PAD83_PIOCFG_SLP_DIR_SHIFT))

#define  IO_PAD83_PIOCFG_EDGE_EN_N_MASK 0x40
#define  IO_PAD83_PIOCFG_EDGE_EN_N_SHIFT 6
#define  IO_PAD83_PIOCFG_EDGE_EN_N_MASK_SHIFT(reg) (((reg) & IO_PAD83_PIOCFG_EDGE_EN_N_MASK) >> IO_PAD83_PIOCFG_EDGE_EN_N_SHIFT)
#define  IO_PAD83_PIOCFG_EDGE_EN_N_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD83_PIOCFG_EDGE_EN_N_MASK) | (((uint32_t)val) << IO_PAD83_PIOCFG_EDGE_EN_N_SHIFT))

#define  IO_PAD83_PIOCFG_EDGE_FALL_EN_MASK 0x20
#define  IO_PAD83_PIOCFG_EDGE_FALL_EN_SHIFT 5
#define  IO_PAD83_PIOCFG_EDGE_FALL_EN_MASK_SHIFT(reg) (((reg) & IO_PAD83_PIOCFG_EDGE_FALL_EN_MASK) >> IO_PAD83_PIOCFG_EDGE_FALL_EN_SHIFT)
#define  IO_PAD83_PIOCFG_EDGE_FALL_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD83_PIOCFG_EDGE_FALL_EN_MASK) | (((uint32_t)val) << IO_PAD83_PIOCFG_EDGE_FALL_EN_SHIFT))

#define  IO_PAD83_PIOCFG_EDGE_RISE_EN_MASK 0x10
#define  IO_PAD83_PIOCFG_EDGE_RISE_EN_SHIFT 4
#define  IO_PAD83_PIOCFG_EDGE_RISE_EN_MASK_SHIFT(reg) (((reg) & IO_PAD83_PIOCFG_EDGE_RISE_EN_MASK) >> IO_PAD83_PIOCFG_EDGE_RISE_EN_SHIFT)
#define  IO_PAD83_PIOCFG_EDGE_RISE_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD83_PIOCFG_EDGE_RISE_EN_MASK) | (((uint32_t)val) << IO_PAD83_PIOCFG_EDGE_RISE_EN_SHIFT))

#define  IO_PAD83_PIOCFG_SLP_SEL_MASK 0x8
#define  IO_PAD83_PIOCFG_SLP_SEL_SHIFT 3
#define  IO_PAD83_PIOCFG_SLP_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD83_PIOCFG_SLP_SEL_MASK) >> IO_PAD83_PIOCFG_SLP_SEL_SHIFT)
#define  IO_PAD83_PIOCFG_SLP_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD83_PIOCFG_SLP_SEL_MASK) | (((uint32_t)val) << IO_PAD83_PIOCFG_SLP_SEL_SHIFT))

#define  IO_PAD83_PIOCFG_FUNC_SEL_MASK 0x7
#define  IO_PAD83_PIOCFG_FUNC_SEL_SHIFT 0
#define  IO_PAD83_PIOCFG_FUNC_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD83_PIOCFG_FUNC_SEL_MASK) >> IO_PAD83_PIOCFG_FUNC_SEL_SHIFT)
#define  IO_PAD83_PIOCFG_FUNC_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD83_PIOCFG_FUNC_SEL_MASK) | (((uint32_t)val) << IO_PAD83_PIOCFG_FUNC_SEL_SHIFT))

//====================================================================
//
//Register File: IO_PAD84 Configuration Registers (IO_PAD84)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

//====================================================================
//Register: IO_PAD84 Configuration Register (PIOCFG)
/** \brief "PHI_PADXDC_IOB" Pad*/
//====================================================================

#define  IO_PAD84_PIOCFG_RESERVED1_MASK 0xfc000000
#define  IO_PAD84_PIOCFG_RESERVED1_SHIFT 26
#define  IO_PAD84_PIOCFG_RESERVED1_MASK_SHIFT(reg) (((reg) & IO_PAD84_PIOCFG_RESERVED1_MASK) >> IO_PAD84_PIOCFG_RESERVED1_SHIFT)
#define  IO_PAD84_PIOCFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD84_PIOCFG_RESERVED1_MASK) | (((uint32_t)val) << IO_PAD84_PIOCFG_RESERVED1_SHIFT))

#define  IO_PAD84_PIOCFG_PD_MASK 0x2000000
#define  IO_PAD84_PIOCFG_PD_SHIFT 25
#define  IO_PAD84_PIOCFG_PD_MASK_SHIFT(reg) (((reg) & IO_PAD84_PIOCFG_PD_MASK) >> IO_PAD84_PIOCFG_PD_SHIFT)
#define  IO_PAD84_PIOCFG_PD_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD84_PIOCFG_PD_MASK) | (((uint32_t)val) << IO_PAD84_PIOCFG_PD_SHIFT))

#define  IO_PAD84_PIOCFG_ODT_EN_MASK 0x1000000
#define  IO_PAD84_PIOCFG_ODT_EN_SHIFT 24
#define  IO_PAD84_PIOCFG_ODT_EN_MASK_SHIFT(reg) (((reg) & IO_PAD84_PIOCFG_ODT_EN_MASK) >> IO_PAD84_PIOCFG_ODT_EN_SHIFT)
#define  IO_PAD84_PIOCFG_ODT_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD84_PIOCFG_ODT_EN_MASK) | (((uint32_t)val) << IO_PAD84_PIOCFG_ODT_EN_SHIFT))

#define  IO_PAD84_PIOCFG_LED_EN_MASK 0x800000
#define  IO_PAD84_PIOCFG_LED_EN_SHIFT 23
#define  IO_PAD84_PIOCFG_LED_EN_MASK_SHIFT(reg) (((reg) & IO_PAD84_PIOCFG_LED_EN_MASK) >> IO_PAD84_PIOCFG_LED_EN_SHIFT)
#define  IO_PAD84_PIOCFG_LED_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD84_PIOCFG_LED_EN_MASK) | (((uint32_t)val) << IO_PAD84_PIOCFG_LED_EN_SHIFT))

#define  IO_PAD84_PIOCFG_I2C_SEL_MASK 0x600000
#define  IO_PAD84_PIOCFG_I2C_SEL_SHIFT 21
#define  IO_PAD84_PIOCFG_I2C_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD84_PIOCFG_I2C_SEL_MASK) >> IO_PAD84_PIOCFG_I2C_SEL_SHIFT)
#define  IO_PAD84_PIOCFG_I2C_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD84_PIOCFG_I2C_SEL_MASK) | (((uint32_t)val) << IO_PAD84_PIOCFG_I2C_SEL_SHIFT))

#define  IO_PAD84_PIOCFG_DGTBSEL_MASK 0x1e0000
#define  IO_PAD84_PIOCFG_DGTBSEL_SHIFT 17
#define  IO_PAD84_PIOCFG_DGTBSEL_MASK_SHIFT(reg) (((reg) & IO_PAD84_PIOCFG_DGTBSEL_MASK) >> IO_PAD84_PIOCFG_DGTBSEL_SHIFT)
#define  IO_PAD84_PIOCFG_DGTBSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD84_PIOCFG_DGTBSEL_MASK) | (((uint32_t)val) << IO_PAD84_PIOCFG_DGTBSEL_SHIFT))

#define  IO_PAD84_PIOCFG_RAWSEL_MASK 0x10000
#define  IO_PAD84_PIOCFG_RAWSEL_SHIFT 16
#define  IO_PAD84_PIOCFG_RAWSEL_MASK_SHIFT(reg) (((reg) & IO_PAD84_PIOCFG_RAWSEL_MASK) >> IO_PAD84_PIOCFG_RAWSEL_SHIFT)
#define  IO_PAD84_PIOCFG_RAWSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD84_PIOCFG_RAWSEL_MASK) | (((uint32_t)val) << IO_PAD84_PIOCFG_RAWSEL_SHIFT))

#define  IO_PAD84_PIOCFG_PULL_SEL_MASK 0x8000
#define  IO_PAD84_PIOCFG_PULL_SEL_SHIFT 15
#define  IO_PAD84_PIOCFG_PULL_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD84_PIOCFG_PULL_SEL_MASK) >> IO_PAD84_PIOCFG_PULL_SEL_SHIFT)
#define  IO_PAD84_PIOCFG_PULL_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD84_PIOCFG_PULL_SEL_MASK) | (((uint32_t)val) << IO_PAD84_PIOCFG_PULL_SEL_SHIFT))

#define  IO_PAD84_PIOCFG_PUEN_MASK 0x4000
#define  IO_PAD84_PIOCFG_PUEN_SHIFT 14
#define  IO_PAD84_PIOCFG_PUEN_MASK_SHIFT(reg) (((reg) & IO_PAD84_PIOCFG_PUEN_MASK) >> IO_PAD84_PIOCFG_PUEN_SHIFT)
#define  IO_PAD84_PIOCFG_PUEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD84_PIOCFG_PUEN_MASK) | (((uint32_t)val) << IO_PAD84_PIOCFG_PUEN_SHIFT))

#define  IO_PAD84_PIOCFG_PDEN_MASK 0x2000
#define  IO_PAD84_PIOCFG_PDEN_SHIFT 13
#define  IO_PAD84_PIOCFG_PDEN_MASK_SHIFT(reg) (((reg) & IO_PAD84_PIOCFG_PDEN_MASK) >> IO_PAD84_PIOCFG_PDEN_SHIFT)
#define  IO_PAD84_PIOCFG_PDEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD84_PIOCFG_PDEN_MASK) | (((uint32_t)val) << IO_PAD84_PIOCFG_PDEN_SHIFT))

#define  IO_PAD84_PIOCFG_SR_MASK 0x1800
#define  IO_PAD84_PIOCFG_SR_SHIFT 11
#define  IO_PAD84_PIOCFG_SR_MASK_SHIFT(reg) (((reg) & IO_PAD84_PIOCFG_SR_MASK) >> IO_PAD84_PIOCFG_SR_SHIFT)
#define  IO_PAD84_PIOCFG_SR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD84_PIOCFG_SR_MASK) | (((uint32_t)val) << IO_PAD84_PIOCFG_SR_SHIFT))

#define  IO_PAD84_PIOCFG_SLP_DI_MASK 0x400
#define  IO_PAD84_PIOCFG_SLP_DI_SHIFT 10
#define  IO_PAD84_PIOCFG_SLP_DI_MASK_SHIFT(reg) (((reg) & IO_PAD84_PIOCFG_SLP_DI_MASK) >> IO_PAD84_PIOCFG_SLP_DI_SHIFT)
#define  IO_PAD84_PIOCFG_SLP_DI_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD84_PIOCFG_SLP_DI_MASK) | (((uint32_t)val) << IO_PAD84_PIOCFG_SLP_DI_SHIFT))

#define  IO_PAD84_PIOCFG_SLP_CNTRL_MASK 0x200
#define  IO_PAD84_PIOCFG_SLP_CNTRL_SHIFT 9
#define  IO_PAD84_PIOCFG_SLP_CNTRL_MASK_SHIFT(reg) (((reg) & IO_PAD84_PIOCFG_SLP_CNTRL_MASK) >> IO_PAD84_PIOCFG_SLP_CNTRL_SHIFT)
#define  IO_PAD84_PIOCFG_SLP_CNTRL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD84_PIOCFG_SLP_CNTRL_MASK) | (((uint32_t)val) << IO_PAD84_PIOCFG_SLP_CNTRL_SHIFT))

#define  IO_PAD84_PIOCFG_SLP_DO_MASK 0x100
#define  IO_PAD84_PIOCFG_SLP_DO_SHIFT 8
#define  IO_PAD84_PIOCFG_SLP_DO_MASK_SHIFT(reg) (((reg) & IO_PAD84_PIOCFG_SLP_DO_MASK) >> IO_PAD84_PIOCFG_SLP_DO_SHIFT)
#define  IO_PAD84_PIOCFG_SLP_DO_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD84_PIOCFG_SLP_DO_MASK) | (((uint32_t)val) << IO_PAD84_PIOCFG_SLP_DO_SHIFT))

#define  IO_PAD84_PIOCFG_SLP_DIR_MASK 0x80
#define  IO_PAD84_PIOCFG_SLP_DIR_SHIFT 7
#define  IO_PAD84_PIOCFG_SLP_DIR_MASK_SHIFT(reg) (((reg) & IO_PAD84_PIOCFG_SLP_DIR_MASK) >> IO_PAD84_PIOCFG_SLP_DIR_SHIFT)
#define  IO_PAD84_PIOCFG_SLP_DIR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD84_PIOCFG_SLP_DIR_MASK) | (((uint32_t)val) << IO_PAD84_PIOCFG_SLP_DIR_SHIFT))

#define  IO_PAD84_PIOCFG_EDGE_EN_N_MASK 0x40
#define  IO_PAD84_PIOCFG_EDGE_EN_N_SHIFT 6
#define  IO_PAD84_PIOCFG_EDGE_EN_N_MASK_SHIFT(reg) (((reg) & IO_PAD84_PIOCFG_EDGE_EN_N_MASK) >> IO_PAD84_PIOCFG_EDGE_EN_N_SHIFT)
#define  IO_PAD84_PIOCFG_EDGE_EN_N_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD84_PIOCFG_EDGE_EN_N_MASK) | (((uint32_t)val) << IO_PAD84_PIOCFG_EDGE_EN_N_SHIFT))

#define  IO_PAD84_PIOCFG_EDGE_FALL_EN_MASK 0x20
#define  IO_PAD84_PIOCFG_EDGE_FALL_EN_SHIFT 5
#define  IO_PAD84_PIOCFG_EDGE_FALL_EN_MASK_SHIFT(reg) (((reg) & IO_PAD84_PIOCFG_EDGE_FALL_EN_MASK) >> IO_PAD84_PIOCFG_EDGE_FALL_EN_SHIFT)
#define  IO_PAD84_PIOCFG_EDGE_FALL_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD84_PIOCFG_EDGE_FALL_EN_MASK) | (((uint32_t)val) << IO_PAD84_PIOCFG_EDGE_FALL_EN_SHIFT))

#define  IO_PAD84_PIOCFG_EDGE_RISE_EN_MASK 0x10
#define  IO_PAD84_PIOCFG_EDGE_RISE_EN_SHIFT 4
#define  IO_PAD84_PIOCFG_EDGE_RISE_EN_MASK_SHIFT(reg) (((reg) & IO_PAD84_PIOCFG_EDGE_RISE_EN_MASK) >> IO_PAD84_PIOCFG_EDGE_RISE_EN_SHIFT)
#define  IO_PAD84_PIOCFG_EDGE_RISE_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD84_PIOCFG_EDGE_RISE_EN_MASK) | (((uint32_t)val) << IO_PAD84_PIOCFG_EDGE_RISE_EN_SHIFT))

#define  IO_PAD84_PIOCFG_SLP_SEL_MASK 0x8
#define  IO_PAD84_PIOCFG_SLP_SEL_SHIFT 3
#define  IO_PAD84_PIOCFG_SLP_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD84_PIOCFG_SLP_SEL_MASK) >> IO_PAD84_PIOCFG_SLP_SEL_SHIFT)
#define  IO_PAD84_PIOCFG_SLP_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD84_PIOCFG_SLP_SEL_MASK) | (((uint32_t)val) << IO_PAD84_PIOCFG_SLP_SEL_SHIFT))

#define  IO_PAD84_PIOCFG_FUNC_SEL_MASK 0x7
#define  IO_PAD84_PIOCFG_FUNC_SEL_SHIFT 0
#define  IO_PAD84_PIOCFG_FUNC_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD84_PIOCFG_FUNC_SEL_MASK) >> IO_PAD84_PIOCFG_FUNC_SEL_SHIFT)
#define  IO_PAD84_PIOCFG_FUNC_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD84_PIOCFG_FUNC_SEL_MASK) | (((uint32_t)val) << IO_PAD84_PIOCFG_FUNC_SEL_SHIFT))

//====================================================================
//
//Register File: IO_PAD85 Configuration Registers (IO_PAD85)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

//====================================================================
//Register: IO_PAD85 Configuration Register (PIOCFG)
/** \brief "PHI_PADXDC_IOB" Pad*/
//====================================================================

#define  IO_PAD85_PIOCFG_RESERVED1_MASK 0xfc000000
#define  IO_PAD85_PIOCFG_RESERVED1_SHIFT 26
#define  IO_PAD85_PIOCFG_RESERVED1_MASK_SHIFT(reg) (((reg) & IO_PAD85_PIOCFG_RESERVED1_MASK) >> IO_PAD85_PIOCFG_RESERVED1_SHIFT)
#define  IO_PAD85_PIOCFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD85_PIOCFG_RESERVED1_MASK) | (((uint32_t)val) << IO_PAD85_PIOCFG_RESERVED1_SHIFT))

#define  IO_PAD85_PIOCFG_PD_MASK 0x2000000
#define  IO_PAD85_PIOCFG_PD_SHIFT 25
#define  IO_PAD85_PIOCFG_PD_MASK_SHIFT(reg) (((reg) & IO_PAD85_PIOCFG_PD_MASK) >> IO_PAD85_PIOCFG_PD_SHIFT)
#define  IO_PAD85_PIOCFG_PD_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD85_PIOCFG_PD_MASK) | (((uint32_t)val) << IO_PAD85_PIOCFG_PD_SHIFT))

#define  IO_PAD85_PIOCFG_ODT_EN_MASK 0x1000000
#define  IO_PAD85_PIOCFG_ODT_EN_SHIFT 24
#define  IO_PAD85_PIOCFG_ODT_EN_MASK_SHIFT(reg) (((reg) & IO_PAD85_PIOCFG_ODT_EN_MASK) >> IO_PAD85_PIOCFG_ODT_EN_SHIFT)
#define  IO_PAD85_PIOCFG_ODT_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD85_PIOCFG_ODT_EN_MASK) | (((uint32_t)val) << IO_PAD85_PIOCFG_ODT_EN_SHIFT))

#define  IO_PAD85_PIOCFG_LED_EN_MASK 0x800000
#define  IO_PAD85_PIOCFG_LED_EN_SHIFT 23
#define  IO_PAD85_PIOCFG_LED_EN_MASK_SHIFT(reg) (((reg) & IO_PAD85_PIOCFG_LED_EN_MASK) >> IO_PAD85_PIOCFG_LED_EN_SHIFT)
#define  IO_PAD85_PIOCFG_LED_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD85_PIOCFG_LED_EN_MASK) | (((uint32_t)val) << IO_PAD85_PIOCFG_LED_EN_SHIFT))

#define  IO_PAD85_PIOCFG_I2C_SEL_MASK 0x600000
#define  IO_PAD85_PIOCFG_I2C_SEL_SHIFT 21
#define  IO_PAD85_PIOCFG_I2C_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD85_PIOCFG_I2C_SEL_MASK) >> IO_PAD85_PIOCFG_I2C_SEL_SHIFT)
#define  IO_PAD85_PIOCFG_I2C_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD85_PIOCFG_I2C_SEL_MASK) | (((uint32_t)val) << IO_PAD85_PIOCFG_I2C_SEL_SHIFT))

#define  IO_PAD85_PIOCFG_DGTBSEL_MASK 0x1e0000
#define  IO_PAD85_PIOCFG_DGTBSEL_SHIFT 17
#define  IO_PAD85_PIOCFG_DGTBSEL_MASK_SHIFT(reg) (((reg) & IO_PAD85_PIOCFG_DGTBSEL_MASK) >> IO_PAD85_PIOCFG_DGTBSEL_SHIFT)
#define  IO_PAD85_PIOCFG_DGTBSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD85_PIOCFG_DGTBSEL_MASK) | (((uint32_t)val) << IO_PAD85_PIOCFG_DGTBSEL_SHIFT))

#define  IO_PAD85_PIOCFG_RAWSEL_MASK 0x10000
#define  IO_PAD85_PIOCFG_RAWSEL_SHIFT 16
#define  IO_PAD85_PIOCFG_RAWSEL_MASK_SHIFT(reg) (((reg) & IO_PAD85_PIOCFG_RAWSEL_MASK) >> IO_PAD85_PIOCFG_RAWSEL_SHIFT)
#define  IO_PAD85_PIOCFG_RAWSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD85_PIOCFG_RAWSEL_MASK) | (((uint32_t)val) << IO_PAD85_PIOCFG_RAWSEL_SHIFT))

#define  IO_PAD85_PIOCFG_PULL_SEL_MASK 0x8000
#define  IO_PAD85_PIOCFG_PULL_SEL_SHIFT 15
#define  IO_PAD85_PIOCFG_PULL_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD85_PIOCFG_PULL_SEL_MASK) >> IO_PAD85_PIOCFG_PULL_SEL_SHIFT)
#define  IO_PAD85_PIOCFG_PULL_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD85_PIOCFG_PULL_SEL_MASK) | (((uint32_t)val) << IO_PAD85_PIOCFG_PULL_SEL_SHIFT))

#define  IO_PAD85_PIOCFG_PUEN_MASK 0x4000
#define  IO_PAD85_PIOCFG_PUEN_SHIFT 14
#define  IO_PAD85_PIOCFG_PUEN_MASK_SHIFT(reg) (((reg) & IO_PAD85_PIOCFG_PUEN_MASK) >> IO_PAD85_PIOCFG_PUEN_SHIFT)
#define  IO_PAD85_PIOCFG_PUEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD85_PIOCFG_PUEN_MASK) | (((uint32_t)val) << IO_PAD85_PIOCFG_PUEN_SHIFT))

#define  IO_PAD85_PIOCFG_PDEN_MASK 0x2000
#define  IO_PAD85_PIOCFG_PDEN_SHIFT 13
#define  IO_PAD85_PIOCFG_PDEN_MASK_SHIFT(reg) (((reg) & IO_PAD85_PIOCFG_PDEN_MASK) >> IO_PAD85_PIOCFG_PDEN_SHIFT)
#define  IO_PAD85_PIOCFG_PDEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD85_PIOCFG_PDEN_MASK) | (((uint32_t)val) << IO_PAD85_PIOCFG_PDEN_SHIFT))

#define  IO_PAD85_PIOCFG_SR_MASK 0x1800
#define  IO_PAD85_PIOCFG_SR_SHIFT 11
#define  IO_PAD85_PIOCFG_SR_MASK_SHIFT(reg) (((reg) & IO_PAD85_PIOCFG_SR_MASK) >> IO_PAD85_PIOCFG_SR_SHIFT)
#define  IO_PAD85_PIOCFG_SR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD85_PIOCFG_SR_MASK) | (((uint32_t)val) << IO_PAD85_PIOCFG_SR_SHIFT))

#define  IO_PAD85_PIOCFG_SLP_DI_MASK 0x400
#define  IO_PAD85_PIOCFG_SLP_DI_SHIFT 10
#define  IO_PAD85_PIOCFG_SLP_DI_MASK_SHIFT(reg) (((reg) & IO_PAD85_PIOCFG_SLP_DI_MASK) >> IO_PAD85_PIOCFG_SLP_DI_SHIFT)
#define  IO_PAD85_PIOCFG_SLP_DI_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD85_PIOCFG_SLP_DI_MASK) | (((uint32_t)val) << IO_PAD85_PIOCFG_SLP_DI_SHIFT))

#define  IO_PAD85_PIOCFG_SLP_CNTRL_MASK 0x200
#define  IO_PAD85_PIOCFG_SLP_CNTRL_SHIFT 9
#define  IO_PAD85_PIOCFG_SLP_CNTRL_MASK_SHIFT(reg) (((reg) & IO_PAD85_PIOCFG_SLP_CNTRL_MASK) >> IO_PAD85_PIOCFG_SLP_CNTRL_SHIFT)
#define  IO_PAD85_PIOCFG_SLP_CNTRL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD85_PIOCFG_SLP_CNTRL_MASK) | (((uint32_t)val) << IO_PAD85_PIOCFG_SLP_CNTRL_SHIFT))

#define  IO_PAD85_PIOCFG_SLP_DO_MASK 0x100
#define  IO_PAD85_PIOCFG_SLP_DO_SHIFT 8
#define  IO_PAD85_PIOCFG_SLP_DO_MASK_SHIFT(reg) (((reg) & IO_PAD85_PIOCFG_SLP_DO_MASK) >> IO_PAD85_PIOCFG_SLP_DO_SHIFT)
#define  IO_PAD85_PIOCFG_SLP_DO_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD85_PIOCFG_SLP_DO_MASK) | (((uint32_t)val) << IO_PAD85_PIOCFG_SLP_DO_SHIFT))

#define  IO_PAD85_PIOCFG_SLP_DIR_MASK 0x80
#define  IO_PAD85_PIOCFG_SLP_DIR_SHIFT 7
#define  IO_PAD85_PIOCFG_SLP_DIR_MASK_SHIFT(reg) (((reg) & IO_PAD85_PIOCFG_SLP_DIR_MASK) >> IO_PAD85_PIOCFG_SLP_DIR_SHIFT)
#define  IO_PAD85_PIOCFG_SLP_DIR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD85_PIOCFG_SLP_DIR_MASK) | (((uint32_t)val) << IO_PAD85_PIOCFG_SLP_DIR_SHIFT))

#define  IO_PAD85_PIOCFG_EDGE_EN_N_MASK 0x40
#define  IO_PAD85_PIOCFG_EDGE_EN_N_SHIFT 6
#define  IO_PAD85_PIOCFG_EDGE_EN_N_MASK_SHIFT(reg) (((reg) & IO_PAD85_PIOCFG_EDGE_EN_N_MASK) >> IO_PAD85_PIOCFG_EDGE_EN_N_SHIFT)
#define  IO_PAD85_PIOCFG_EDGE_EN_N_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD85_PIOCFG_EDGE_EN_N_MASK) | (((uint32_t)val) << IO_PAD85_PIOCFG_EDGE_EN_N_SHIFT))

#define  IO_PAD85_PIOCFG_EDGE_FALL_EN_MASK 0x20
#define  IO_PAD85_PIOCFG_EDGE_FALL_EN_SHIFT 5
#define  IO_PAD85_PIOCFG_EDGE_FALL_EN_MASK_SHIFT(reg) (((reg) & IO_PAD85_PIOCFG_EDGE_FALL_EN_MASK) >> IO_PAD85_PIOCFG_EDGE_FALL_EN_SHIFT)
#define  IO_PAD85_PIOCFG_EDGE_FALL_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD85_PIOCFG_EDGE_FALL_EN_MASK) | (((uint32_t)val) << IO_PAD85_PIOCFG_EDGE_FALL_EN_SHIFT))

#define  IO_PAD85_PIOCFG_EDGE_RISE_EN_MASK 0x10
#define  IO_PAD85_PIOCFG_EDGE_RISE_EN_SHIFT 4
#define  IO_PAD85_PIOCFG_EDGE_RISE_EN_MASK_SHIFT(reg) (((reg) & IO_PAD85_PIOCFG_EDGE_RISE_EN_MASK) >> IO_PAD85_PIOCFG_EDGE_RISE_EN_SHIFT)
#define  IO_PAD85_PIOCFG_EDGE_RISE_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD85_PIOCFG_EDGE_RISE_EN_MASK) | (((uint32_t)val) << IO_PAD85_PIOCFG_EDGE_RISE_EN_SHIFT))

#define  IO_PAD85_PIOCFG_SLP_SEL_MASK 0x8
#define  IO_PAD85_PIOCFG_SLP_SEL_SHIFT 3
#define  IO_PAD85_PIOCFG_SLP_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD85_PIOCFG_SLP_SEL_MASK) >> IO_PAD85_PIOCFG_SLP_SEL_SHIFT)
#define  IO_PAD85_PIOCFG_SLP_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD85_PIOCFG_SLP_SEL_MASK) | (((uint32_t)val) << IO_PAD85_PIOCFG_SLP_SEL_SHIFT))

#define  IO_PAD85_PIOCFG_FUNC_SEL_MASK 0x7
#define  IO_PAD85_PIOCFG_FUNC_SEL_SHIFT 0
#define  IO_PAD85_PIOCFG_FUNC_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD85_PIOCFG_FUNC_SEL_MASK) >> IO_PAD85_PIOCFG_FUNC_SEL_SHIFT)
#define  IO_PAD85_PIOCFG_FUNC_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD85_PIOCFG_FUNC_SEL_MASK) | (((uint32_t)val) << IO_PAD85_PIOCFG_FUNC_SEL_SHIFT))

//====================================================================
//
//Register File: IO_PAD86 Configuration Registers (IO_PAD86)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

//====================================================================
//Register: IO_PAD86 Configuration Register (PIOCFG)
/** \brief "PHI_PADXDC_IOB" Pad*/
//====================================================================

#define  IO_PAD86_PIOCFG_RESERVED1_MASK 0xfc000000
#define  IO_PAD86_PIOCFG_RESERVED1_SHIFT 26
#define  IO_PAD86_PIOCFG_RESERVED1_MASK_SHIFT(reg) (((reg) & IO_PAD86_PIOCFG_RESERVED1_MASK) >> IO_PAD86_PIOCFG_RESERVED1_SHIFT)
#define  IO_PAD86_PIOCFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD86_PIOCFG_RESERVED1_MASK) | (((uint32_t)val) << IO_PAD86_PIOCFG_RESERVED1_SHIFT))

#define  IO_PAD86_PIOCFG_PD_MASK 0x2000000
#define  IO_PAD86_PIOCFG_PD_SHIFT 25
#define  IO_PAD86_PIOCFG_PD_MASK_SHIFT(reg) (((reg) & IO_PAD86_PIOCFG_PD_MASK) >> IO_PAD86_PIOCFG_PD_SHIFT)
#define  IO_PAD86_PIOCFG_PD_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD86_PIOCFG_PD_MASK) | (((uint32_t)val) << IO_PAD86_PIOCFG_PD_SHIFT))

#define  IO_PAD86_PIOCFG_ODT_EN_MASK 0x1000000
#define  IO_PAD86_PIOCFG_ODT_EN_SHIFT 24
#define  IO_PAD86_PIOCFG_ODT_EN_MASK_SHIFT(reg) (((reg) & IO_PAD86_PIOCFG_ODT_EN_MASK) >> IO_PAD86_PIOCFG_ODT_EN_SHIFT)
#define  IO_PAD86_PIOCFG_ODT_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD86_PIOCFG_ODT_EN_MASK) | (((uint32_t)val) << IO_PAD86_PIOCFG_ODT_EN_SHIFT))

#define  IO_PAD86_PIOCFG_LED_EN_MASK 0x800000
#define  IO_PAD86_PIOCFG_LED_EN_SHIFT 23
#define  IO_PAD86_PIOCFG_LED_EN_MASK_SHIFT(reg) (((reg) & IO_PAD86_PIOCFG_LED_EN_MASK) >> IO_PAD86_PIOCFG_LED_EN_SHIFT)
#define  IO_PAD86_PIOCFG_LED_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD86_PIOCFG_LED_EN_MASK) | (((uint32_t)val) << IO_PAD86_PIOCFG_LED_EN_SHIFT))

#define  IO_PAD86_PIOCFG_I2C_SEL_MASK 0x600000
#define  IO_PAD86_PIOCFG_I2C_SEL_SHIFT 21
#define  IO_PAD86_PIOCFG_I2C_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD86_PIOCFG_I2C_SEL_MASK) >> IO_PAD86_PIOCFG_I2C_SEL_SHIFT)
#define  IO_PAD86_PIOCFG_I2C_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD86_PIOCFG_I2C_SEL_MASK) | (((uint32_t)val) << IO_PAD86_PIOCFG_I2C_SEL_SHIFT))

#define  IO_PAD86_PIOCFG_DGTBSEL_MASK 0x1e0000
#define  IO_PAD86_PIOCFG_DGTBSEL_SHIFT 17
#define  IO_PAD86_PIOCFG_DGTBSEL_MASK_SHIFT(reg) (((reg) & IO_PAD86_PIOCFG_DGTBSEL_MASK) >> IO_PAD86_PIOCFG_DGTBSEL_SHIFT)
#define  IO_PAD86_PIOCFG_DGTBSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD86_PIOCFG_DGTBSEL_MASK) | (((uint32_t)val) << IO_PAD86_PIOCFG_DGTBSEL_SHIFT))

#define  IO_PAD86_PIOCFG_RAWSEL_MASK 0x10000
#define  IO_PAD86_PIOCFG_RAWSEL_SHIFT 16
#define  IO_PAD86_PIOCFG_RAWSEL_MASK_SHIFT(reg) (((reg) & IO_PAD86_PIOCFG_RAWSEL_MASK) >> IO_PAD86_PIOCFG_RAWSEL_SHIFT)
#define  IO_PAD86_PIOCFG_RAWSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD86_PIOCFG_RAWSEL_MASK) | (((uint32_t)val) << IO_PAD86_PIOCFG_RAWSEL_SHIFT))

#define  IO_PAD86_PIOCFG_PULL_SEL_MASK 0x8000
#define  IO_PAD86_PIOCFG_PULL_SEL_SHIFT 15
#define  IO_PAD86_PIOCFG_PULL_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD86_PIOCFG_PULL_SEL_MASK) >> IO_PAD86_PIOCFG_PULL_SEL_SHIFT)
#define  IO_PAD86_PIOCFG_PULL_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD86_PIOCFG_PULL_SEL_MASK) | (((uint32_t)val) << IO_PAD86_PIOCFG_PULL_SEL_SHIFT))

#define  IO_PAD86_PIOCFG_PUEN_MASK 0x4000
#define  IO_PAD86_PIOCFG_PUEN_SHIFT 14
#define  IO_PAD86_PIOCFG_PUEN_MASK_SHIFT(reg) (((reg) & IO_PAD86_PIOCFG_PUEN_MASK) >> IO_PAD86_PIOCFG_PUEN_SHIFT)
#define  IO_PAD86_PIOCFG_PUEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD86_PIOCFG_PUEN_MASK) | (((uint32_t)val) << IO_PAD86_PIOCFG_PUEN_SHIFT))

#define  IO_PAD86_PIOCFG_PDEN_MASK 0x2000
#define  IO_PAD86_PIOCFG_PDEN_SHIFT 13
#define  IO_PAD86_PIOCFG_PDEN_MASK_SHIFT(reg) (((reg) & IO_PAD86_PIOCFG_PDEN_MASK) >> IO_PAD86_PIOCFG_PDEN_SHIFT)
#define  IO_PAD86_PIOCFG_PDEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD86_PIOCFG_PDEN_MASK) | (((uint32_t)val) << IO_PAD86_PIOCFG_PDEN_SHIFT))

#define  IO_PAD86_PIOCFG_SR_MASK 0x1800
#define  IO_PAD86_PIOCFG_SR_SHIFT 11
#define  IO_PAD86_PIOCFG_SR_MASK_SHIFT(reg) (((reg) & IO_PAD86_PIOCFG_SR_MASK) >> IO_PAD86_PIOCFG_SR_SHIFT)
#define  IO_PAD86_PIOCFG_SR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD86_PIOCFG_SR_MASK) | (((uint32_t)val) << IO_PAD86_PIOCFG_SR_SHIFT))

#define  IO_PAD86_PIOCFG_SLP_DI_MASK 0x400
#define  IO_PAD86_PIOCFG_SLP_DI_SHIFT 10
#define  IO_PAD86_PIOCFG_SLP_DI_MASK_SHIFT(reg) (((reg) & IO_PAD86_PIOCFG_SLP_DI_MASK) >> IO_PAD86_PIOCFG_SLP_DI_SHIFT)
#define  IO_PAD86_PIOCFG_SLP_DI_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD86_PIOCFG_SLP_DI_MASK) | (((uint32_t)val) << IO_PAD86_PIOCFG_SLP_DI_SHIFT))

#define  IO_PAD86_PIOCFG_SLP_CNTRL_MASK 0x200
#define  IO_PAD86_PIOCFG_SLP_CNTRL_SHIFT 9
#define  IO_PAD86_PIOCFG_SLP_CNTRL_MASK_SHIFT(reg) (((reg) & IO_PAD86_PIOCFG_SLP_CNTRL_MASK) >> IO_PAD86_PIOCFG_SLP_CNTRL_SHIFT)
#define  IO_PAD86_PIOCFG_SLP_CNTRL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD86_PIOCFG_SLP_CNTRL_MASK) | (((uint32_t)val) << IO_PAD86_PIOCFG_SLP_CNTRL_SHIFT))

#define  IO_PAD86_PIOCFG_SLP_DO_MASK 0x100
#define  IO_PAD86_PIOCFG_SLP_DO_SHIFT 8
#define  IO_PAD86_PIOCFG_SLP_DO_MASK_SHIFT(reg) (((reg) & IO_PAD86_PIOCFG_SLP_DO_MASK) >> IO_PAD86_PIOCFG_SLP_DO_SHIFT)
#define  IO_PAD86_PIOCFG_SLP_DO_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD86_PIOCFG_SLP_DO_MASK) | (((uint32_t)val) << IO_PAD86_PIOCFG_SLP_DO_SHIFT))

#define  IO_PAD86_PIOCFG_SLP_DIR_MASK 0x80
#define  IO_PAD86_PIOCFG_SLP_DIR_SHIFT 7
#define  IO_PAD86_PIOCFG_SLP_DIR_MASK_SHIFT(reg) (((reg) & IO_PAD86_PIOCFG_SLP_DIR_MASK) >> IO_PAD86_PIOCFG_SLP_DIR_SHIFT)
#define  IO_PAD86_PIOCFG_SLP_DIR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD86_PIOCFG_SLP_DIR_MASK) | (((uint32_t)val) << IO_PAD86_PIOCFG_SLP_DIR_SHIFT))

#define  IO_PAD86_PIOCFG_EDGE_EN_N_MASK 0x40
#define  IO_PAD86_PIOCFG_EDGE_EN_N_SHIFT 6
#define  IO_PAD86_PIOCFG_EDGE_EN_N_MASK_SHIFT(reg) (((reg) & IO_PAD86_PIOCFG_EDGE_EN_N_MASK) >> IO_PAD86_PIOCFG_EDGE_EN_N_SHIFT)
#define  IO_PAD86_PIOCFG_EDGE_EN_N_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD86_PIOCFG_EDGE_EN_N_MASK) | (((uint32_t)val) << IO_PAD86_PIOCFG_EDGE_EN_N_SHIFT))

#define  IO_PAD86_PIOCFG_EDGE_FALL_EN_MASK 0x20
#define  IO_PAD86_PIOCFG_EDGE_FALL_EN_SHIFT 5
#define  IO_PAD86_PIOCFG_EDGE_FALL_EN_MASK_SHIFT(reg) (((reg) & IO_PAD86_PIOCFG_EDGE_FALL_EN_MASK) >> IO_PAD86_PIOCFG_EDGE_FALL_EN_SHIFT)
#define  IO_PAD86_PIOCFG_EDGE_FALL_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD86_PIOCFG_EDGE_FALL_EN_MASK) | (((uint32_t)val) << IO_PAD86_PIOCFG_EDGE_FALL_EN_SHIFT))

#define  IO_PAD86_PIOCFG_EDGE_RISE_EN_MASK 0x10
#define  IO_PAD86_PIOCFG_EDGE_RISE_EN_SHIFT 4
#define  IO_PAD86_PIOCFG_EDGE_RISE_EN_MASK_SHIFT(reg) (((reg) & IO_PAD86_PIOCFG_EDGE_RISE_EN_MASK) >> IO_PAD86_PIOCFG_EDGE_RISE_EN_SHIFT)
#define  IO_PAD86_PIOCFG_EDGE_RISE_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD86_PIOCFG_EDGE_RISE_EN_MASK) | (((uint32_t)val) << IO_PAD86_PIOCFG_EDGE_RISE_EN_SHIFT))

#define  IO_PAD86_PIOCFG_SLP_SEL_MASK 0x8
#define  IO_PAD86_PIOCFG_SLP_SEL_SHIFT 3
#define  IO_PAD86_PIOCFG_SLP_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD86_PIOCFG_SLP_SEL_MASK) >> IO_PAD86_PIOCFG_SLP_SEL_SHIFT)
#define  IO_PAD86_PIOCFG_SLP_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD86_PIOCFG_SLP_SEL_MASK) | (((uint32_t)val) << IO_PAD86_PIOCFG_SLP_SEL_SHIFT))

#define  IO_PAD86_PIOCFG_FUNC_SEL_MASK 0x7
#define  IO_PAD86_PIOCFG_FUNC_SEL_SHIFT 0
#define  IO_PAD86_PIOCFG_FUNC_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD86_PIOCFG_FUNC_SEL_MASK) >> IO_PAD86_PIOCFG_FUNC_SEL_SHIFT)
#define  IO_PAD86_PIOCFG_FUNC_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD86_PIOCFG_FUNC_SEL_MASK) | (((uint32_t)val) << IO_PAD86_PIOCFG_FUNC_SEL_SHIFT))

//====================================================================
//
//Register File: IO_PAD87 Configuration Registers (IO_PAD87)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

//====================================================================
//Register: IO_PAD87 Configuration Register (PIOCFG)
/** \brief "PHI_PADXDC_IOB" Pad*/
//====================================================================

#define  IO_PAD87_PIOCFG_RESERVED1_MASK 0xfc000000
#define  IO_PAD87_PIOCFG_RESERVED1_SHIFT 26
#define  IO_PAD87_PIOCFG_RESERVED1_MASK_SHIFT(reg) (((reg) & IO_PAD87_PIOCFG_RESERVED1_MASK) >> IO_PAD87_PIOCFG_RESERVED1_SHIFT)
#define  IO_PAD87_PIOCFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD87_PIOCFG_RESERVED1_MASK) | (((uint32_t)val) << IO_PAD87_PIOCFG_RESERVED1_SHIFT))

#define  IO_PAD87_PIOCFG_PD_MASK 0x2000000
#define  IO_PAD87_PIOCFG_PD_SHIFT 25
#define  IO_PAD87_PIOCFG_PD_MASK_SHIFT(reg) (((reg) & IO_PAD87_PIOCFG_PD_MASK) >> IO_PAD87_PIOCFG_PD_SHIFT)
#define  IO_PAD87_PIOCFG_PD_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD87_PIOCFG_PD_MASK) | (((uint32_t)val) << IO_PAD87_PIOCFG_PD_SHIFT))

#define  IO_PAD87_PIOCFG_ODT_EN_MASK 0x1000000
#define  IO_PAD87_PIOCFG_ODT_EN_SHIFT 24
#define  IO_PAD87_PIOCFG_ODT_EN_MASK_SHIFT(reg) (((reg) & IO_PAD87_PIOCFG_ODT_EN_MASK) >> IO_PAD87_PIOCFG_ODT_EN_SHIFT)
#define  IO_PAD87_PIOCFG_ODT_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD87_PIOCFG_ODT_EN_MASK) | (((uint32_t)val) << IO_PAD87_PIOCFG_ODT_EN_SHIFT))

#define  IO_PAD87_PIOCFG_LED_EN_MASK 0x800000
#define  IO_PAD87_PIOCFG_LED_EN_SHIFT 23
#define  IO_PAD87_PIOCFG_LED_EN_MASK_SHIFT(reg) (((reg) & IO_PAD87_PIOCFG_LED_EN_MASK) >> IO_PAD87_PIOCFG_LED_EN_SHIFT)
#define  IO_PAD87_PIOCFG_LED_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD87_PIOCFG_LED_EN_MASK) | (((uint32_t)val) << IO_PAD87_PIOCFG_LED_EN_SHIFT))

#define  IO_PAD87_PIOCFG_I2C_SEL_MASK 0x600000
#define  IO_PAD87_PIOCFG_I2C_SEL_SHIFT 21
#define  IO_PAD87_PIOCFG_I2C_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD87_PIOCFG_I2C_SEL_MASK) >> IO_PAD87_PIOCFG_I2C_SEL_SHIFT)
#define  IO_PAD87_PIOCFG_I2C_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD87_PIOCFG_I2C_SEL_MASK) | (((uint32_t)val) << IO_PAD87_PIOCFG_I2C_SEL_SHIFT))

#define  IO_PAD87_PIOCFG_DGTBSEL_MASK 0x1e0000
#define  IO_PAD87_PIOCFG_DGTBSEL_SHIFT 17
#define  IO_PAD87_PIOCFG_DGTBSEL_MASK_SHIFT(reg) (((reg) & IO_PAD87_PIOCFG_DGTBSEL_MASK) >> IO_PAD87_PIOCFG_DGTBSEL_SHIFT)
#define  IO_PAD87_PIOCFG_DGTBSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD87_PIOCFG_DGTBSEL_MASK) | (((uint32_t)val) << IO_PAD87_PIOCFG_DGTBSEL_SHIFT))

#define  IO_PAD87_PIOCFG_RAWSEL_MASK 0x10000
#define  IO_PAD87_PIOCFG_RAWSEL_SHIFT 16
#define  IO_PAD87_PIOCFG_RAWSEL_MASK_SHIFT(reg) (((reg) & IO_PAD87_PIOCFG_RAWSEL_MASK) >> IO_PAD87_PIOCFG_RAWSEL_SHIFT)
#define  IO_PAD87_PIOCFG_RAWSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD87_PIOCFG_RAWSEL_MASK) | (((uint32_t)val) << IO_PAD87_PIOCFG_RAWSEL_SHIFT))

#define  IO_PAD87_PIOCFG_PULL_SEL_MASK 0x8000
#define  IO_PAD87_PIOCFG_PULL_SEL_SHIFT 15
#define  IO_PAD87_PIOCFG_PULL_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD87_PIOCFG_PULL_SEL_MASK) >> IO_PAD87_PIOCFG_PULL_SEL_SHIFT)
#define  IO_PAD87_PIOCFG_PULL_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD87_PIOCFG_PULL_SEL_MASK) | (((uint32_t)val) << IO_PAD87_PIOCFG_PULL_SEL_SHIFT))

#define  IO_PAD87_PIOCFG_PUEN_MASK 0x4000
#define  IO_PAD87_PIOCFG_PUEN_SHIFT 14
#define  IO_PAD87_PIOCFG_PUEN_MASK_SHIFT(reg) (((reg) & IO_PAD87_PIOCFG_PUEN_MASK) >> IO_PAD87_PIOCFG_PUEN_SHIFT)
#define  IO_PAD87_PIOCFG_PUEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD87_PIOCFG_PUEN_MASK) | (((uint32_t)val) << IO_PAD87_PIOCFG_PUEN_SHIFT))

#define  IO_PAD87_PIOCFG_PDEN_MASK 0x2000
#define  IO_PAD87_PIOCFG_PDEN_SHIFT 13
#define  IO_PAD87_PIOCFG_PDEN_MASK_SHIFT(reg) (((reg) & IO_PAD87_PIOCFG_PDEN_MASK) >> IO_PAD87_PIOCFG_PDEN_SHIFT)
#define  IO_PAD87_PIOCFG_PDEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD87_PIOCFG_PDEN_MASK) | (((uint32_t)val) << IO_PAD87_PIOCFG_PDEN_SHIFT))

#define  IO_PAD87_PIOCFG_SR_MASK 0x1800
#define  IO_PAD87_PIOCFG_SR_SHIFT 11
#define  IO_PAD87_PIOCFG_SR_MASK_SHIFT(reg) (((reg) & IO_PAD87_PIOCFG_SR_MASK) >> IO_PAD87_PIOCFG_SR_SHIFT)
#define  IO_PAD87_PIOCFG_SR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD87_PIOCFG_SR_MASK) | (((uint32_t)val) << IO_PAD87_PIOCFG_SR_SHIFT))

#define  IO_PAD87_PIOCFG_SLP_DI_MASK 0x400
#define  IO_PAD87_PIOCFG_SLP_DI_SHIFT 10
#define  IO_PAD87_PIOCFG_SLP_DI_MASK_SHIFT(reg) (((reg) & IO_PAD87_PIOCFG_SLP_DI_MASK) >> IO_PAD87_PIOCFG_SLP_DI_SHIFT)
#define  IO_PAD87_PIOCFG_SLP_DI_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD87_PIOCFG_SLP_DI_MASK) | (((uint32_t)val) << IO_PAD87_PIOCFG_SLP_DI_SHIFT))

#define  IO_PAD87_PIOCFG_SLP_CNTRL_MASK 0x200
#define  IO_PAD87_PIOCFG_SLP_CNTRL_SHIFT 9
#define  IO_PAD87_PIOCFG_SLP_CNTRL_MASK_SHIFT(reg) (((reg) & IO_PAD87_PIOCFG_SLP_CNTRL_MASK) >> IO_PAD87_PIOCFG_SLP_CNTRL_SHIFT)
#define  IO_PAD87_PIOCFG_SLP_CNTRL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD87_PIOCFG_SLP_CNTRL_MASK) | (((uint32_t)val) << IO_PAD87_PIOCFG_SLP_CNTRL_SHIFT))

#define  IO_PAD87_PIOCFG_SLP_DO_MASK 0x100
#define  IO_PAD87_PIOCFG_SLP_DO_SHIFT 8
#define  IO_PAD87_PIOCFG_SLP_DO_MASK_SHIFT(reg) (((reg) & IO_PAD87_PIOCFG_SLP_DO_MASK) >> IO_PAD87_PIOCFG_SLP_DO_SHIFT)
#define  IO_PAD87_PIOCFG_SLP_DO_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD87_PIOCFG_SLP_DO_MASK) | (((uint32_t)val) << IO_PAD87_PIOCFG_SLP_DO_SHIFT))

#define  IO_PAD87_PIOCFG_SLP_DIR_MASK 0x80
#define  IO_PAD87_PIOCFG_SLP_DIR_SHIFT 7
#define  IO_PAD87_PIOCFG_SLP_DIR_MASK_SHIFT(reg) (((reg) & IO_PAD87_PIOCFG_SLP_DIR_MASK) >> IO_PAD87_PIOCFG_SLP_DIR_SHIFT)
#define  IO_PAD87_PIOCFG_SLP_DIR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD87_PIOCFG_SLP_DIR_MASK) | (((uint32_t)val) << IO_PAD87_PIOCFG_SLP_DIR_SHIFT))

#define  IO_PAD87_PIOCFG_EDGE_EN_N_MASK 0x40
#define  IO_PAD87_PIOCFG_EDGE_EN_N_SHIFT 6
#define  IO_PAD87_PIOCFG_EDGE_EN_N_MASK_SHIFT(reg) (((reg) & IO_PAD87_PIOCFG_EDGE_EN_N_MASK) >> IO_PAD87_PIOCFG_EDGE_EN_N_SHIFT)
#define  IO_PAD87_PIOCFG_EDGE_EN_N_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD87_PIOCFG_EDGE_EN_N_MASK) | (((uint32_t)val) << IO_PAD87_PIOCFG_EDGE_EN_N_SHIFT))

#define  IO_PAD87_PIOCFG_EDGE_FALL_EN_MASK 0x20
#define  IO_PAD87_PIOCFG_EDGE_FALL_EN_SHIFT 5
#define  IO_PAD87_PIOCFG_EDGE_FALL_EN_MASK_SHIFT(reg) (((reg) & IO_PAD87_PIOCFG_EDGE_FALL_EN_MASK) >> IO_PAD87_PIOCFG_EDGE_FALL_EN_SHIFT)
#define  IO_PAD87_PIOCFG_EDGE_FALL_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD87_PIOCFG_EDGE_FALL_EN_MASK) | (((uint32_t)val) << IO_PAD87_PIOCFG_EDGE_FALL_EN_SHIFT))

#define  IO_PAD87_PIOCFG_EDGE_RISE_EN_MASK 0x10
#define  IO_PAD87_PIOCFG_EDGE_RISE_EN_SHIFT 4
#define  IO_PAD87_PIOCFG_EDGE_RISE_EN_MASK_SHIFT(reg) (((reg) & IO_PAD87_PIOCFG_EDGE_RISE_EN_MASK) >> IO_PAD87_PIOCFG_EDGE_RISE_EN_SHIFT)
#define  IO_PAD87_PIOCFG_EDGE_RISE_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD87_PIOCFG_EDGE_RISE_EN_MASK) | (((uint32_t)val) << IO_PAD87_PIOCFG_EDGE_RISE_EN_SHIFT))

#define  IO_PAD87_PIOCFG_SLP_SEL_MASK 0x8
#define  IO_PAD87_PIOCFG_SLP_SEL_SHIFT 3
#define  IO_PAD87_PIOCFG_SLP_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD87_PIOCFG_SLP_SEL_MASK) >> IO_PAD87_PIOCFG_SLP_SEL_SHIFT)
#define  IO_PAD87_PIOCFG_SLP_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD87_PIOCFG_SLP_SEL_MASK) | (((uint32_t)val) << IO_PAD87_PIOCFG_SLP_SEL_SHIFT))

#define  IO_PAD87_PIOCFG_FUNC_SEL_MASK 0x7
#define  IO_PAD87_PIOCFG_FUNC_SEL_SHIFT 0
#define  IO_PAD87_PIOCFG_FUNC_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD87_PIOCFG_FUNC_SEL_MASK) >> IO_PAD87_PIOCFG_FUNC_SEL_SHIFT)
#define  IO_PAD87_PIOCFG_FUNC_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD87_PIOCFG_FUNC_SEL_MASK) | (((uint32_t)val) << IO_PAD87_PIOCFG_FUNC_SEL_SHIFT))

//====================================================================
//
//Register File: IO_PAD88 Configuration Registers (IO_PAD88)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

//====================================================================
//Register: IO_PAD88 Configuration Register (PIOCFG)
/** \brief "PHI_PADXDC_IOB" Pad*/
//====================================================================

#define  IO_PAD88_PIOCFG_RESERVED1_MASK 0xfc000000
#define  IO_PAD88_PIOCFG_RESERVED1_SHIFT 26
#define  IO_PAD88_PIOCFG_RESERVED1_MASK_SHIFT(reg) (((reg) & IO_PAD88_PIOCFG_RESERVED1_MASK) >> IO_PAD88_PIOCFG_RESERVED1_SHIFT)
#define  IO_PAD88_PIOCFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD88_PIOCFG_RESERVED1_MASK) | (((uint32_t)val) << IO_PAD88_PIOCFG_RESERVED1_SHIFT))

#define  IO_PAD88_PIOCFG_PD_MASK 0x2000000
#define  IO_PAD88_PIOCFG_PD_SHIFT 25
#define  IO_PAD88_PIOCFG_PD_MASK_SHIFT(reg) (((reg) & IO_PAD88_PIOCFG_PD_MASK) >> IO_PAD88_PIOCFG_PD_SHIFT)
#define  IO_PAD88_PIOCFG_PD_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD88_PIOCFG_PD_MASK) | (((uint32_t)val) << IO_PAD88_PIOCFG_PD_SHIFT))

#define  IO_PAD88_PIOCFG_ODT_EN_MASK 0x1000000
#define  IO_PAD88_PIOCFG_ODT_EN_SHIFT 24
#define  IO_PAD88_PIOCFG_ODT_EN_MASK_SHIFT(reg) (((reg) & IO_PAD88_PIOCFG_ODT_EN_MASK) >> IO_PAD88_PIOCFG_ODT_EN_SHIFT)
#define  IO_PAD88_PIOCFG_ODT_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD88_PIOCFG_ODT_EN_MASK) | (((uint32_t)val) << IO_PAD88_PIOCFG_ODT_EN_SHIFT))

#define  IO_PAD88_PIOCFG_LED_EN_MASK 0x800000
#define  IO_PAD88_PIOCFG_LED_EN_SHIFT 23
#define  IO_PAD88_PIOCFG_LED_EN_MASK_SHIFT(reg) (((reg) & IO_PAD88_PIOCFG_LED_EN_MASK) >> IO_PAD88_PIOCFG_LED_EN_SHIFT)
#define  IO_PAD88_PIOCFG_LED_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD88_PIOCFG_LED_EN_MASK) | (((uint32_t)val) << IO_PAD88_PIOCFG_LED_EN_SHIFT))

#define  IO_PAD88_PIOCFG_I2C_SEL_MASK 0x600000
#define  IO_PAD88_PIOCFG_I2C_SEL_SHIFT 21
#define  IO_PAD88_PIOCFG_I2C_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD88_PIOCFG_I2C_SEL_MASK) >> IO_PAD88_PIOCFG_I2C_SEL_SHIFT)
#define  IO_PAD88_PIOCFG_I2C_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD88_PIOCFG_I2C_SEL_MASK) | (((uint32_t)val) << IO_PAD88_PIOCFG_I2C_SEL_SHIFT))

#define  IO_PAD88_PIOCFG_DGTBSEL_MASK 0x1e0000
#define  IO_PAD88_PIOCFG_DGTBSEL_SHIFT 17
#define  IO_PAD88_PIOCFG_DGTBSEL_MASK_SHIFT(reg) (((reg) & IO_PAD88_PIOCFG_DGTBSEL_MASK) >> IO_PAD88_PIOCFG_DGTBSEL_SHIFT)
#define  IO_PAD88_PIOCFG_DGTBSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD88_PIOCFG_DGTBSEL_MASK) | (((uint32_t)val) << IO_PAD88_PIOCFG_DGTBSEL_SHIFT))

#define  IO_PAD88_PIOCFG_RAWSEL_MASK 0x10000
#define  IO_PAD88_PIOCFG_RAWSEL_SHIFT 16
#define  IO_PAD88_PIOCFG_RAWSEL_MASK_SHIFT(reg) (((reg) & IO_PAD88_PIOCFG_RAWSEL_MASK) >> IO_PAD88_PIOCFG_RAWSEL_SHIFT)
#define  IO_PAD88_PIOCFG_RAWSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD88_PIOCFG_RAWSEL_MASK) | (((uint32_t)val) << IO_PAD88_PIOCFG_RAWSEL_SHIFT))

#define  IO_PAD88_PIOCFG_PULL_SEL_MASK 0x8000
#define  IO_PAD88_PIOCFG_PULL_SEL_SHIFT 15
#define  IO_PAD88_PIOCFG_PULL_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD88_PIOCFG_PULL_SEL_MASK) >> IO_PAD88_PIOCFG_PULL_SEL_SHIFT)
#define  IO_PAD88_PIOCFG_PULL_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD88_PIOCFG_PULL_SEL_MASK) | (((uint32_t)val) << IO_PAD88_PIOCFG_PULL_SEL_SHIFT))

#define  IO_PAD88_PIOCFG_PUEN_MASK 0x4000
#define  IO_PAD88_PIOCFG_PUEN_SHIFT 14
#define  IO_PAD88_PIOCFG_PUEN_MASK_SHIFT(reg) (((reg) & IO_PAD88_PIOCFG_PUEN_MASK) >> IO_PAD88_PIOCFG_PUEN_SHIFT)
#define  IO_PAD88_PIOCFG_PUEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD88_PIOCFG_PUEN_MASK) | (((uint32_t)val) << IO_PAD88_PIOCFG_PUEN_SHIFT))

#define  IO_PAD88_PIOCFG_PDEN_MASK 0x2000
#define  IO_PAD88_PIOCFG_PDEN_SHIFT 13
#define  IO_PAD88_PIOCFG_PDEN_MASK_SHIFT(reg) (((reg) & IO_PAD88_PIOCFG_PDEN_MASK) >> IO_PAD88_PIOCFG_PDEN_SHIFT)
#define  IO_PAD88_PIOCFG_PDEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD88_PIOCFG_PDEN_MASK) | (((uint32_t)val) << IO_PAD88_PIOCFG_PDEN_SHIFT))

#define  IO_PAD88_PIOCFG_SR_MASK 0x1800
#define  IO_PAD88_PIOCFG_SR_SHIFT 11
#define  IO_PAD88_PIOCFG_SR_MASK_SHIFT(reg) (((reg) & IO_PAD88_PIOCFG_SR_MASK) >> IO_PAD88_PIOCFG_SR_SHIFT)
#define  IO_PAD88_PIOCFG_SR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD88_PIOCFG_SR_MASK) | (((uint32_t)val) << IO_PAD88_PIOCFG_SR_SHIFT))

#define  IO_PAD88_PIOCFG_SLP_DI_MASK 0x400
#define  IO_PAD88_PIOCFG_SLP_DI_SHIFT 10
#define  IO_PAD88_PIOCFG_SLP_DI_MASK_SHIFT(reg) (((reg) & IO_PAD88_PIOCFG_SLP_DI_MASK) >> IO_PAD88_PIOCFG_SLP_DI_SHIFT)
#define  IO_PAD88_PIOCFG_SLP_DI_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD88_PIOCFG_SLP_DI_MASK) | (((uint32_t)val) << IO_PAD88_PIOCFG_SLP_DI_SHIFT))

#define  IO_PAD88_PIOCFG_SLP_CNTRL_MASK 0x200
#define  IO_PAD88_PIOCFG_SLP_CNTRL_SHIFT 9
#define  IO_PAD88_PIOCFG_SLP_CNTRL_MASK_SHIFT(reg) (((reg) & IO_PAD88_PIOCFG_SLP_CNTRL_MASK) >> IO_PAD88_PIOCFG_SLP_CNTRL_SHIFT)
#define  IO_PAD88_PIOCFG_SLP_CNTRL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD88_PIOCFG_SLP_CNTRL_MASK) | (((uint32_t)val) << IO_PAD88_PIOCFG_SLP_CNTRL_SHIFT))

#define  IO_PAD88_PIOCFG_SLP_DO_MASK 0x100
#define  IO_PAD88_PIOCFG_SLP_DO_SHIFT 8
#define  IO_PAD88_PIOCFG_SLP_DO_MASK_SHIFT(reg) (((reg) & IO_PAD88_PIOCFG_SLP_DO_MASK) >> IO_PAD88_PIOCFG_SLP_DO_SHIFT)
#define  IO_PAD88_PIOCFG_SLP_DO_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD88_PIOCFG_SLP_DO_MASK) | (((uint32_t)val) << IO_PAD88_PIOCFG_SLP_DO_SHIFT))

#define  IO_PAD88_PIOCFG_SLP_DIR_MASK 0x80
#define  IO_PAD88_PIOCFG_SLP_DIR_SHIFT 7
#define  IO_PAD88_PIOCFG_SLP_DIR_MASK_SHIFT(reg) (((reg) & IO_PAD88_PIOCFG_SLP_DIR_MASK) >> IO_PAD88_PIOCFG_SLP_DIR_SHIFT)
#define  IO_PAD88_PIOCFG_SLP_DIR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD88_PIOCFG_SLP_DIR_MASK) | (((uint32_t)val) << IO_PAD88_PIOCFG_SLP_DIR_SHIFT))

#define  IO_PAD88_PIOCFG_EDGE_EN_N_MASK 0x40
#define  IO_PAD88_PIOCFG_EDGE_EN_N_SHIFT 6
#define  IO_PAD88_PIOCFG_EDGE_EN_N_MASK_SHIFT(reg) (((reg) & IO_PAD88_PIOCFG_EDGE_EN_N_MASK) >> IO_PAD88_PIOCFG_EDGE_EN_N_SHIFT)
#define  IO_PAD88_PIOCFG_EDGE_EN_N_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD88_PIOCFG_EDGE_EN_N_MASK) | (((uint32_t)val) << IO_PAD88_PIOCFG_EDGE_EN_N_SHIFT))

#define  IO_PAD88_PIOCFG_EDGE_FALL_EN_MASK 0x20
#define  IO_PAD88_PIOCFG_EDGE_FALL_EN_SHIFT 5
#define  IO_PAD88_PIOCFG_EDGE_FALL_EN_MASK_SHIFT(reg) (((reg) & IO_PAD88_PIOCFG_EDGE_FALL_EN_MASK) >> IO_PAD88_PIOCFG_EDGE_FALL_EN_SHIFT)
#define  IO_PAD88_PIOCFG_EDGE_FALL_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD88_PIOCFG_EDGE_FALL_EN_MASK) | (((uint32_t)val) << IO_PAD88_PIOCFG_EDGE_FALL_EN_SHIFT))

#define  IO_PAD88_PIOCFG_EDGE_RISE_EN_MASK 0x10
#define  IO_PAD88_PIOCFG_EDGE_RISE_EN_SHIFT 4
#define  IO_PAD88_PIOCFG_EDGE_RISE_EN_MASK_SHIFT(reg) (((reg) & IO_PAD88_PIOCFG_EDGE_RISE_EN_MASK) >> IO_PAD88_PIOCFG_EDGE_RISE_EN_SHIFT)
#define  IO_PAD88_PIOCFG_EDGE_RISE_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD88_PIOCFG_EDGE_RISE_EN_MASK) | (((uint32_t)val) << IO_PAD88_PIOCFG_EDGE_RISE_EN_SHIFT))

#define  IO_PAD88_PIOCFG_SLP_SEL_MASK 0x8
#define  IO_PAD88_PIOCFG_SLP_SEL_SHIFT 3
#define  IO_PAD88_PIOCFG_SLP_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD88_PIOCFG_SLP_SEL_MASK) >> IO_PAD88_PIOCFG_SLP_SEL_SHIFT)
#define  IO_PAD88_PIOCFG_SLP_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD88_PIOCFG_SLP_SEL_MASK) | (((uint32_t)val) << IO_PAD88_PIOCFG_SLP_SEL_SHIFT))

#define  IO_PAD88_PIOCFG_FUNC_SEL_MASK 0x7
#define  IO_PAD88_PIOCFG_FUNC_SEL_SHIFT 0
#define  IO_PAD88_PIOCFG_FUNC_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD88_PIOCFG_FUNC_SEL_MASK) >> IO_PAD88_PIOCFG_FUNC_SEL_SHIFT)
#define  IO_PAD88_PIOCFG_FUNC_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD88_PIOCFG_FUNC_SEL_MASK) | (((uint32_t)val) << IO_PAD88_PIOCFG_FUNC_SEL_SHIFT))

//====================================================================
//
//Register File: IO_PAD89 Configuration Registers (IO_PAD89)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

//====================================================================
//Register: IO_PAD89 Configuration Register (PIOCFG)
/** \brief "PHI_PADXDC_IOB" Pad*/
//====================================================================

#define  IO_PAD89_PIOCFG_RESERVED1_MASK 0xfc000000
#define  IO_PAD89_PIOCFG_RESERVED1_SHIFT 26
#define  IO_PAD89_PIOCFG_RESERVED1_MASK_SHIFT(reg) (((reg) & IO_PAD89_PIOCFG_RESERVED1_MASK) >> IO_PAD89_PIOCFG_RESERVED1_SHIFT)
#define  IO_PAD89_PIOCFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD89_PIOCFG_RESERVED1_MASK) | (((uint32_t)val) << IO_PAD89_PIOCFG_RESERVED1_SHIFT))

#define  IO_PAD89_PIOCFG_PD_MASK 0x2000000
#define  IO_PAD89_PIOCFG_PD_SHIFT 25
#define  IO_PAD89_PIOCFG_PD_MASK_SHIFT(reg) (((reg) & IO_PAD89_PIOCFG_PD_MASK) >> IO_PAD89_PIOCFG_PD_SHIFT)
#define  IO_PAD89_PIOCFG_PD_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD89_PIOCFG_PD_MASK) | (((uint32_t)val) << IO_PAD89_PIOCFG_PD_SHIFT))

#define  IO_PAD89_PIOCFG_ODT_EN_MASK 0x1000000
#define  IO_PAD89_PIOCFG_ODT_EN_SHIFT 24
#define  IO_PAD89_PIOCFG_ODT_EN_MASK_SHIFT(reg) (((reg) & IO_PAD89_PIOCFG_ODT_EN_MASK) >> IO_PAD89_PIOCFG_ODT_EN_SHIFT)
#define  IO_PAD89_PIOCFG_ODT_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD89_PIOCFG_ODT_EN_MASK) | (((uint32_t)val) << IO_PAD89_PIOCFG_ODT_EN_SHIFT))

#define  IO_PAD89_PIOCFG_LED_EN_MASK 0x800000
#define  IO_PAD89_PIOCFG_LED_EN_SHIFT 23
#define  IO_PAD89_PIOCFG_LED_EN_MASK_SHIFT(reg) (((reg) & IO_PAD89_PIOCFG_LED_EN_MASK) >> IO_PAD89_PIOCFG_LED_EN_SHIFT)
#define  IO_PAD89_PIOCFG_LED_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD89_PIOCFG_LED_EN_MASK) | (((uint32_t)val) << IO_PAD89_PIOCFG_LED_EN_SHIFT))

#define  IO_PAD89_PIOCFG_I2C_SEL_MASK 0x600000
#define  IO_PAD89_PIOCFG_I2C_SEL_SHIFT 21
#define  IO_PAD89_PIOCFG_I2C_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD89_PIOCFG_I2C_SEL_MASK) >> IO_PAD89_PIOCFG_I2C_SEL_SHIFT)
#define  IO_PAD89_PIOCFG_I2C_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD89_PIOCFG_I2C_SEL_MASK) | (((uint32_t)val) << IO_PAD89_PIOCFG_I2C_SEL_SHIFT))

#define  IO_PAD89_PIOCFG_DGTBSEL_MASK 0x1e0000
#define  IO_PAD89_PIOCFG_DGTBSEL_SHIFT 17
#define  IO_PAD89_PIOCFG_DGTBSEL_MASK_SHIFT(reg) (((reg) & IO_PAD89_PIOCFG_DGTBSEL_MASK) >> IO_PAD89_PIOCFG_DGTBSEL_SHIFT)
#define  IO_PAD89_PIOCFG_DGTBSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD89_PIOCFG_DGTBSEL_MASK) | (((uint32_t)val) << IO_PAD89_PIOCFG_DGTBSEL_SHIFT))

#define  IO_PAD89_PIOCFG_RAWSEL_MASK 0x10000
#define  IO_PAD89_PIOCFG_RAWSEL_SHIFT 16
#define  IO_PAD89_PIOCFG_RAWSEL_MASK_SHIFT(reg) (((reg) & IO_PAD89_PIOCFG_RAWSEL_MASK) >> IO_PAD89_PIOCFG_RAWSEL_SHIFT)
#define  IO_PAD89_PIOCFG_RAWSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD89_PIOCFG_RAWSEL_MASK) | (((uint32_t)val) << IO_PAD89_PIOCFG_RAWSEL_SHIFT))

#define  IO_PAD89_PIOCFG_PULL_SEL_MASK 0x8000
#define  IO_PAD89_PIOCFG_PULL_SEL_SHIFT 15
#define  IO_PAD89_PIOCFG_PULL_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD89_PIOCFG_PULL_SEL_MASK) >> IO_PAD89_PIOCFG_PULL_SEL_SHIFT)
#define  IO_PAD89_PIOCFG_PULL_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD89_PIOCFG_PULL_SEL_MASK) | (((uint32_t)val) << IO_PAD89_PIOCFG_PULL_SEL_SHIFT))

#define  IO_PAD89_PIOCFG_PUEN_MASK 0x4000
#define  IO_PAD89_PIOCFG_PUEN_SHIFT 14
#define  IO_PAD89_PIOCFG_PUEN_MASK_SHIFT(reg) (((reg) & IO_PAD89_PIOCFG_PUEN_MASK) >> IO_PAD89_PIOCFG_PUEN_SHIFT)
#define  IO_PAD89_PIOCFG_PUEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD89_PIOCFG_PUEN_MASK) | (((uint32_t)val) << IO_PAD89_PIOCFG_PUEN_SHIFT))

#define  IO_PAD89_PIOCFG_PDEN_MASK 0x2000
#define  IO_PAD89_PIOCFG_PDEN_SHIFT 13
#define  IO_PAD89_PIOCFG_PDEN_MASK_SHIFT(reg) (((reg) & IO_PAD89_PIOCFG_PDEN_MASK) >> IO_PAD89_PIOCFG_PDEN_SHIFT)
#define  IO_PAD89_PIOCFG_PDEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD89_PIOCFG_PDEN_MASK) | (((uint32_t)val) << IO_PAD89_PIOCFG_PDEN_SHIFT))

#define  IO_PAD89_PIOCFG_SR_MASK 0x1800
#define  IO_PAD89_PIOCFG_SR_SHIFT 11
#define  IO_PAD89_PIOCFG_SR_MASK_SHIFT(reg) (((reg) & IO_PAD89_PIOCFG_SR_MASK) >> IO_PAD89_PIOCFG_SR_SHIFT)
#define  IO_PAD89_PIOCFG_SR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD89_PIOCFG_SR_MASK) | (((uint32_t)val) << IO_PAD89_PIOCFG_SR_SHIFT))

#define  IO_PAD89_PIOCFG_SLP_DI_MASK 0x400
#define  IO_PAD89_PIOCFG_SLP_DI_SHIFT 10
#define  IO_PAD89_PIOCFG_SLP_DI_MASK_SHIFT(reg) (((reg) & IO_PAD89_PIOCFG_SLP_DI_MASK) >> IO_PAD89_PIOCFG_SLP_DI_SHIFT)
#define  IO_PAD89_PIOCFG_SLP_DI_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD89_PIOCFG_SLP_DI_MASK) | (((uint32_t)val) << IO_PAD89_PIOCFG_SLP_DI_SHIFT))

#define  IO_PAD89_PIOCFG_SLP_CNTRL_MASK 0x200
#define  IO_PAD89_PIOCFG_SLP_CNTRL_SHIFT 9
#define  IO_PAD89_PIOCFG_SLP_CNTRL_MASK_SHIFT(reg) (((reg) & IO_PAD89_PIOCFG_SLP_CNTRL_MASK) >> IO_PAD89_PIOCFG_SLP_CNTRL_SHIFT)
#define  IO_PAD89_PIOCFG_SLP_CNTRL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD89_PIOCFG_SLP_CNTRL_MASK) | (((uint32_t)val) << IO_PAD89_PIOCFG_SLP_CNTRL_SHIFT))

#define  IO_PAD89_PIOCFG_SLP_DO_MASK 0x100
#define  IO_PAD89_PIOCFG_SLP_DO_SHIFT 8
#define  IO_PAD89_PIOCFG_SLP_DO_MASK_SHIFT(reg) (((reg) & IO_PAD89_PIOCFG_SLP_DO_MASK) >> IO_PAD89_PIOCFG_SLP_DO_SHIFT)
#define  IO_PAD89_PIOCFG_SLP_DO_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD89_PIOCFG_SLP_DO_MASK) | (((uint32_t)val) << IO_PAD89_PIOCFG_SLP_DO_SHIFT))

#define  IO_PAD89_PIOCFG_SLP_DIR_MASK 0x80
#define  IO_PAD89_PIOCFG_SLP_DIR_SHIFT 7
#define  IO_PAD89_PIOCFG_SLP_DIR_MASK_SHIFT(reg) (((reg) & IO_PAD89_PIOCFG_SLP_DIR_MASK) >> IO_PAD89_PIOCFG_SLP_DIR_SHIFT)
#define  IO_PAD89_PIOCFG_SLP_DIR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD89_PIOCFG_SLP_DIR_MASK) | (((uint32_t)val) << IO_PAD89_PIOCFG_SLP_DIR_SHIFT))

#define  IO_PAD89_PIOCFG_EDGE_EN_N_MASK 0x40
#define  IO_PAD89_PIOCFG_EDGE_EN_N_SHIFT 6
#define  IO_PAD89_PIOCFG_EDGE_EN_N_MASK_SHIFT(reg) (((reg) & IO_PAD89_PIOCFG_EDGE_EN_N_MASK) >> IO_PAD89_PIOCFG_EDGE_EN_N_SHIFT)
#define  IO_PAD89_PIOCFG_EDGE_EN_N_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD89_PIOCFG_EDGE_EN_N_MASK) | (((uint32_t)val) << IO_PAD89_PIOCFG_EDGE_EN_N_SHIFT))

#define  IO_PAD89_PIOCFG_EDGE_FALL_EN_MASK 0x20
#define  IO_PAD89_PIOCFG_EDGE_FALL_EN_SHIFT 5
#define  IO_PAD89_PIOCFG_EDGE_FALL_EN_MASK_SHIFT(reg) (((reg) & IO_PAD89_PIOCFG_EDGE_FALL_EN_MASK) >> IO_PAD89_PIOCFG_EDGE_FALL_EN_SHIFT)
#define  IO_PAD89_PIOCFG_EDGE_FALL_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD89_PIOCFG_EDGE_FALL_EN_MASK) | (((uint32_t)val) << IO_PAD89_PIOCFG_EDGE_FALL_EN_SHIFT))

#define  IO_PAD89_PIOCFG_EDGE_RISE_EN_MASK 0x10
#define  IO_PAD89_PIOCFG_EDGE_RISE_EN_SHIFT 4
#define  IO_PAD89_PIOCFG_EDGE_RISE_EN_MASK_SHIFT(reg) (((reg) & IO_PAD89_PIOCFG_EDGE_RISE_EN_MASK) >> IO_PAD89_PIOCFG_EDGE_RISE_EN_SHIFT)
#define  IO_PAD89_PIOCFG_EDGE_RISE_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD89_PIOCFG_EDGE_RISE_EN_MASK) | (((uint32_t)val) << IO_PAD89_PIOCFG_EDGE_RISE_EN_SHIFT))

#define  IO_PAD89_PIOCFG_SLP_SEL_MASK 0x8
#define  IO_PAD89_PIOCFG_SLP_SEL_SHIFT 3
#define  IO_PAD89_PIOCFG_SLP_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD89_PIOCFG_SLP_SEL_MASK) >> IO_PAD89_PIOCFG_SLP_SEL_SHIFT)
#define  IO_PAD89_PIOCFG_SLP_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD89_PIOCFG_SLP_SEL_MASK) | (((uint32_t)val) << IO_PAD89_PIOCFG_SLP_SEL_SHIFT))

#define  IO_PAD89_PIOCFG_FUNC_SEL_MASK 0x7
#define  IO_PAD89_PIOCFG_FUNC_SEL_SHIFT 0
#define  IO_PAD89_PIOCFG_FUNC_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD89_PIOCFG_FUNC_SEL_MASK) >> IO_PAD89_PIOCFG_FUNC_SEL_SHIFT)
#define  IO_PAD89_PIOCFG_FUNC_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD89_PIOCFG_FUNC_SEL_MASK) | (((uint32_t)val) << IO_PAD89_PIOCFG_FUNC_SEL_SHIFT))

//====================================================================
//
//Register File: IO_PAD90 Configuration Registers (IO_PAD90)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

//====================================================================
//Register: IO_PAD90 Configuration Register (PIOCFG)
/** \brief "PHI_PADXDC_IOB" Pad*/
//====================================================================

#define  IO_PAD90_PIOCFG_RESERVED1_MASK 0xfc000000
#define  IO_PAD90_PIOCFG_RESERVED1_SHIFT 26
#define  IO_PAD90_PIOCFG_RESERVED1_MASK_SHIFT(reg) (((reg) & IO_PAD90_PIOCFG_RESERVED1_MASK) >> IO_PAD90_PIOCFG_RESERVED1_SHIFT)
#define  IO_PAD90_PIOCFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD90_PIOCFG_RESERVED1_MASK) | (((uint32_t)val) << IO_PAD90_PIOCFG_RESERVED1_SHIFT))

#define  IO_PAD90_PIOCFG_PD_MASK 0x2000000
#define  IO_PAD90_PIOCFG_PD_SHIFT 25
#define  IO_PAD90_PIOCFG_PD_MASK_SHIFT(reg) (((reg) & IO_PAD90_PIOCFG_PD_MASK) >> IO_PAD90_PIOCFG_PD_SHIFT)
#define  IO_PAD90_PIOCFG_PD_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD90_PIOCFG_PD_MASK) | (((uint32_t)val) << IO_PAD90_PIOCFG_PD_SHIFT))

#define  IO_PAD90_PIOCFG_ODT_EN_MASK 0x1000000
#define  IO_PAD90_PIOCFG_ODT_EN_SHIFT 24
#define  IO_PAD90_PIOCFG_ODT_EN_MASK_SHIFT(reg) (((reg) & IO_PAD90_PIOCFG_ODT_EN_MASK) >> IO_PAD90_PIOCFG_ODT_EN_SHIFT)
#define  IO_PAD90_PIOCFG_ODT_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD90_PIOCFG_ODT_EN_MASK) | (((uint32_t)val) << IO_PAD90_PIOCFG_ODT_EN_SHIFT))

#define  IO_PAD90_PIOCFG_LED_EN_MASK 0x800000
#define  IO_PAD90_PIOCFG_LED_EN_SHIFT 23
#define  IO_PAD90_PIOCFG_LED_EN_MASK_SHIFT(reg) (((reg) & IO_PAD90_PIOCFG_LED_EN_MASK) >> IO_PAD90_PIOCFG_LED_EN_SHIFT)
#define  IO_PAD90_PIOCFG_LED_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD90_PIOCFG_LED_EN_MASK) | (((uint32_t)val) << IO_PAD90_PIOCFG_LED_EN_SHIFT))

#define  IO_PAD90_PIOCFG_I2C_SEL_MASK 0x600000
#define  IO_PAD90_PIOCFG_I2C_SEL_SHIFT 21
#define  IO_PAD90_PIOCFG_I2C_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD90_PIOCFG_I2C_SEL_MASK) >> IO_PAD90_PIOCFG_I2C_SEL_SHIFT)
#define  IO_PAD90_PIOCFG_I2C_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD90_PIOCFG_I2C_SEL_MASK) | (((uint32_t)val) << IO_PAD90_PIOCFG_I2C_SEL_SHIFT))

#define  IO_PAD90_PIOCFG_DGTBSEL_MASK 0x1e0000
#define  IO_PAD90_PIOCFG_DGTBSEL_SHIFT 17
#define  IO_PAD90_PIOCFG_DGTBSEL_MASK_SHIFT(reg) (((reg) & IO_PAD90_PIOCFG_DGTBSEL_MASK) >> IO_PAD90_PIOCFG_DGTBSEL_SHIFT)
#define  IO_PAD90_PIOCFG_DGTBSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD90_PIOCFG_DGTBSEL_MASK) | (((uint32_t)val) << IO_PAD90_PIOCFG_DGTBSEL_SHIFT))

#define  IO_PAD90_PIOCFG_RAWSEL_MASK 0x10000
#define  IO_PAD90_PIOCFG_RAWSEL_SHIFT 16
#define  IO_PAD90_PIOCFG_RAWSEL_MASK_SHIFT(reg) (((reg) & IO_PAD90_PIOCFG_RAWSEL_MASK) >> IO_PAD90_PIOCFG_RAWSEL_SHIFT)
#define  IO_PAD90_PIOCFG_RAWSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD90_PIOCFG_RAWSEL_MASK) | (((uint32_t)val) << IO_PAD90_PIOCFG_RAWSEL_SHIFT))

#define  IO_PAD90_PIOCFG_PULL_SEL_MASK 0x8000
#define  IO_PAD90_PIOCFG_PULL_SEL_SHIFT 15
#define  IO_PAD90_PIOCFG_PULL_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD90_PIOCFG_PULL_SEL_MASK) >> IO_PAD90_PIOCFG_PULL_SEL_SHIFT)
#define  IO_PAD90_PIOCFG_PULL_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD90_PIOCFG_PULL_SEL_MASK) | (((uint32_t)val) << IO_PAD90_PIOCFG_PULL_SEL_SHIFT))

#define  IO_PAD90_PIOCFG_PUEN_MASK 0x4000
#define  IO_PAD90_PIOCFG_PUEN_SHIFT 14
#define  IO_PAD90_PIOCFG_PUEN_MASK_SHIFT(reg) (((reg) & IO_PAD90_PIOCFG_PUEN_MASK) >> IO_PAD90_PIOCFG_PUEN_SHIFT)
#define  IO_PAD90_PIOCFG_PUEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD90_PIOCFG_PUEN_MASK) | (((uint32_t)val) << IO_PAD90_PIOCFG_PUEN_SHIFT))

#define  IO_PAD90_PIOCFG_PDEN_MASK 0x2000
#define  IO_PAD90_PIOCFG_PDEN_SHIFT 13
#define  IO_PAD90_PIOCFG_PDEN_MASK_SHIFT(reg) (((reg) & IO_PAD90_PIOCFG_PDEN_MASK) >> IO_PAD90_PIOCFG_PDEN_SHIFT)
#define  IO_PAD90_PIOCFG_PDEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD90_PIOCFG_PDEN_MASK) | (((uint32_t)val) << IO_PAD90_PIOCFG_PDEN_SHIFT))

#define  IO_PAD90_PIOCFG_SR_MASK 0x1800
#define  IO_PAD90_PIOCFG_SR_SHIFT 11
#define  IO_PAD90_PIOCFG_SR_MASK_SHIFT(reg) (((reg) & IO_PAD90_PIOCFG_SR_MASK) >> IO_PAD90_PIOCFG_SR_SHIFT)
#define  IO_PAD90_PIOCFG_SR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD90_PIOCFG_SR_MASK) | (((uint32_t)val) << IO_PAD90_PIOCFG_SR_SHIFT))

#define  IO_PAD90_PIOCFG_SLP_DI_MASK 0x400
#define  IO_PAD90_PIOCFG_SLP_DI_SHIFT 10
#define  IO_PAD90_PIOCFG_SLP_DI_MASK_SHIFT(reg) (((reg) & IO_PAD90_PIOCFG_SLP_DI_MASK) >> IO_PAD90_PIOCFG_SLP_DI_SHIFT)
#define  IO_PAD90_PIOCFG_SLP_DI_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD90_PIOCFG_SLP_DI_MASK) | (((uint32_t)val) << IO_PAD90_PIOCFG_SLP_DI_SHIFT))

#define  IO_PAD90_PIOCFG_SLP_CNTRL_MASK 0x200
#define  IO_PAD90_PIOCFG_SLP_CNTRL_SHIFT 9
#define  IO_PAD90_PIOCFG_SLP_CNTRL_MASK_SHIFT(reg) (((reg) & IO_PAD90_PIOCFG_SLP_CNTRL_MASK) >> IO_PAD90_PIOCFG_SLP_CNTRL_SHIFT)
#define  IO_PAD90_PIOCFG_SLP_CNTRL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD90_PIOCFG_SLP_CNTRL_MASK) | (((uint32_t)val) << IO_PAD90_PIOCFG_SLP_CNTRL_SHIFT))

#define  IO_PAD90_PIOCFG_SLP_DO_MASK 0x100
#define  IO_PAD90_PIOCFG_SLP_DO_SHIFT 8
#define  IO_PAD90_PIOCFG_SLP_DO_MASK_SHIFT(reg) (((reg) & IO_PAD90_PIOCFG_SLP_DO_MASK) >> IO_PAD90_PIOCFG_SLP_DO_SHIFT)
#define  IO_PAD90_PIOCFG_SLP_DO_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD90_PIOCFG_SLP_DO_MASK) | (((uint32_t)val) << IO_PAD90_PIOCFG_SLP_DO_SHIFT))

#define  IO_PAD90_PIOCFG_SLP_DIR_MASK 0x80
#define  IO_PAD90_PIOCFG_SLP_DIR_SHIFT 7
#define  IO_PAD90_PIOCFG_SLP_DIR_MASK_SHIFT(reg) (((reg) & IO_PAD90_PIOCFG_SLP_DIR_MASK) >> IO_PAD90_PIOCFG_SLP_DIR_SHIFT)
#define  IO_PAD90_PIOCFG_SLP_DIR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD90_PIOCFG_SLP_DIR_MASK) | (((uint32_t)val) << IO_PAD90_PIOCFG_SLP_DIR_SHIFT))

#define  IO_PAD90_PIOCFG_EDGE_EN_N_MASK 0x40
#define  IO_PAD90_PIOCFG_EDGE_EN_N_SHIFT 6
#define  IO_PAD90_PIOCFG_EDGE_EN_N_MASK_SHIFT(reg) (((reg) & IO_PAD90_PIOCFG_EDGE_EN_N_MASK) >> IO_PAD90_PIOCFG_EDGE_EN_N_SHIFT)
#define  IO_PAD90_PIOCFG_EDGE_EN_N_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD90_PIOCFG_EDGE_EN_N_MASK) | (((uint32_t)val) << IO_PAD90_PIOCFG_EDGE_EN_N_SHIFT))

#define  IO_PAD90_PIOCFG_EDGE_FALL_EN_MASK 0x20
#define  IO_PAD90_PIOCFG_EDGE_FALL_EN_SHIFT 5
#define  IO_PAD90_PIOCFG_EDGE_FALL_EN_MASK_SHIFT(reg) (((reg) & IO_PAD90_PIOCFG_EDGE_FALL_EN_MASK) >> IO_PAD90_PIOCFG_EDGE_FALL_EN_SHIFT)
#define  IO_PAD90_PIOCFG_EDGE_FALL_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD90_PIOCFG_EDGE_FALL_EN_MASK) | (((uint32_t)val) << IO_PAD90_PIOCFG_EDGE_FALL_EN_SHIFT))

#define  IO_PAD90_PIOCFG_EDGE_RISE_EN_MASK 0x10
#define  IO_PAD90_PIOCFG_EDGE_RISE_EN_SHIFT 4
#define  IO_PAD90_PIOCFG_EDGE_RISE_EN_MASK_SHIFT(reg) (((reg) & IO_PAD90_PIOCFG_EDGE_RISE_EN_MASK) >> IO_PAD90_PIOCFG_EDGE_RISE_EN_SHIFT)
#define  IO_PAD90_PIOCFG_EDGE_RISE_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD90_PIOCFG_EDGE_RISE_EN_MASK) | (((uint32_t)val) << IO_PAD90_PIOCFG_EDGE_RISE_EN_SHIFT))

#define  IO_PAD90_PIOCFG_SLP_SEL_MASK 0x8
#define  IO_PAD90_PIOCFG_SLP_SEL_SHIFT 3
#define  IO_PAD90_PIOCFG_SLP_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD90_PIOCFG_SLP_SEL_MASK) >> IO_PAD90_PIOCFG_SLP_SEL_SHIFT)
#define  IO_PAD90_PIOCFG_SLP_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD90_PIOCFG_SLP_SEL_MASK) | (((uint32_t)val) << IO_PAD90_PIOCFG_SLP_SEL_SHIFT))

#define  IO_PAD90_PIOCFG_FUNC_SEL_MASK 0x7
#define  IO_PAD90_PIOCFG_FUNC_SEL_SHIFT 0
#define  IO_PAD90_PIOCFG_FUNC_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD90_PIOCFG_FUNC_SEL_MASK) >> IO_PAD90_PIOCFG_FUNC_SEL_SHIFT)
#define  IO_PAD90_PIOCFG_FUNC_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD90_PIOCFG_FUNC_SEL_MASK) | (((uint32_t)val) << IO_PAD90_PIOCFG_FUNC_SEL_SHIFT))

//====================================================================
//
//Register File: IO_PAD91 Configuration Registers (IO_PAD91)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

//====================================================================
//Register: IO_PAD91 Configuration Register (PIOCFG)
/** \brief "PHI_PADXDC_IOB" Pad*/
//====================================================================

#define  IO_PAD91_PIOCFG_RESERVED1_MASK 0xfc000000
#define  IO_PAD91_PIOCFG_RESERVED1_SHIFT 26
#define  IO_PAD91_PIOCFG_RESERVED1_MASK_SHIFT(reg) (((reg) & IO_PAD91_PIOCFG_RESERVED1_MASK) >> IO_PAD91_PIOCFG_RESERVED1_SHIFT)
#define  IO_PAD91_PIOCFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD91_PIOCFG_RESERVED1_MASK) | (((uint32_t)val) << IO_PAD91_PIOCFG_RESERVED1_SHIFT))

#define  IO_PAD91_PIOCFG_PD_MASK 0x2000000
#define  IO_PAD91_PIOCFG_PD_SHIFT 25
#define  IO_PAD91_PIOCFG_PD_MASK_SHIFT(reg) (((reg) & IO_PAD91_PIOCFG_PD_MASK) >> IO_PAD91_PIOCFG_PD_SHIFT)
#define  IO_PAD91_PIOCFG_PD_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD91_PIOCFG_PD_MASK) | (((uint32_t)val) << IO_PAD91_PIOCFG_PD_SHIFT))

#define  IO_PAD91_PIOCFG_ODT_EN_MASK 0x1000000
#define  IO_PAD91_PIOCFG_ODT_EN_SHIFT 24
#define  IO_PAD91_PIOCFG_ODT_EN_MASK_SHIFT(reg) (((reg) & IO_PAD91_PIOCFG_ODT_EN_MASK) >> IO_PAD91_PIOCFG_ODT_EN_SHIFT)
#define  IO_PAD91_PIOCFG_ODT_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD91_PIOCFG_ODT_EN_MASK) | (((uint32_t)val) << IO_PAD91_PIOCFG_ODT_EN_SHIFT))

#define  IO_PAD91_PIOCFG_LED_EN_MASK 0x800000
#define  IO_PAD91_PIOCFG_LED_EN_SHIFT 23
#define  IO_PAD91_PIOCFG_LED_EN_MASK_SHIFT(reg) (((reg) & IO_PAD91_PIOCFG_LED_EN_MASK) >> IO_PAD91_PIOCFG_LED_EN_SHIFT)
#define  IO_PAD91_PIOCFG_LED_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD91_PIOCFG_LED_EN_MASK) | (((uint32_t)val) << IO_PAD91_PIOCFG_LED_EN_SHIFT))

#define  IO_PAD91_PIOCFG_I2C_SEL_MASK 0x600000
#define  IO_PAD91_PIOCFG_I2C_SEL_SHIFT 21
#define  IO_PAD91_PIOCFG_I2C_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD91_PIOCFG_I2C_SEL_MASK) >> IO_PAD91_PIOCFG_I2C_SEL_SHIFT)
#define  IO_PAD91_PIOCFG_I2C_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD91_PIOCFG_I2C_SEL_MASK) | (((uint32_t)val) << IO_PAD91_PIOCFG_I2C_SEL_SHIFT))

#define  IO_PAD91_PIOCFG_DGTBSEL_MASK 0x1e0000
#define  IO_PAD91_PIOCFG_DGTBSEL_SHIFT 17
#define  IO_PAD91_PIOCFG_DGTBSEL_MASK_SHIFT(reg) (((reg) & IO_PAD91_PIOCFG_DGTBSEL_MASK) >> IO_PAD91_PIOCFG_DGTBSEL_SHIFT)
#define  IO_PAD91_PIOCFG_DGTBSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD91_PIOCFG_DGTBSEL_MASK) | (((uint32_t)val) << IO_PAD91_PIOCFG_DGTBSEL_SHIFT))

#define  IO_PAD91_PIOCFG_RAWSEL_MASK 0x10000
#define  IO_PAD91_PIOCFG_RAWSEL_SHIFT 16
#define  IO_PAD91_PIOCFG_RAWSEL_MASK_SHIFT(reg) (((reg) & IO_PAD91_PIOCFG_RAWSEL_MASK) >> IO_PAD91_PIOCFG_RAWSEL_SHIFT)
#define  IO_PAD91_PIOCFG_RAWSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD91_PIOCFG_RAWSEL_MASK) | (((uint32_t)val) << IO_PAD91_PIOCFG_RAWSEL_SHIFT))

#define  IO_PAD91_PIOCFG_PULL_SEL_MASK 0x8000
#define  IO_PAD91_PIOCFG_PULL_SEL_SHIFT 15
#define  IO_PAD91_PIOCFG_PULL_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD91_PIOCFG_PULL_SEL_MASK) >> IO_PAD91_PIOCFG_PULL_SEL_SHIFT)
#define  IO_PAD91_PIOCFG_PULL_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD91_PIOCFG_PULL_SEL_MASK) | (((uint32_t)val) << IO_PAD91_PIOCFG_PULL_SEL_SHIFT))

#define  IO_PAD91_PIOCFG_PUEN_MASK 0x4000
#define  IO_PAD91_PIOCFG_PUEN_SHIFT 14
#define  IO_PAD91_PIOCFG_PUEN_MASK_SHIFT(reg) (((reg) & IO_PAD91_PIOCFG_PUEN_MASK) >> IO_PAD91_PIOCFG_PUEN_SHIFT)
#define  IO_PAD91_PIOCFG_PUEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD91_PIOCFG_PUEN_MASK) | (((uint32_t)val) << IO_PAD91_PIOCFG_PUEN_SHIFT))

#define  IO_PAD91_PIOCFG_PDEN_MASK 0x2000
#define  IO_PAD91_PIOCFG_PDEN_SHIFT 13
#define  IO_PAD91_PIOCFG_PDEN_MASK_SHIFT(reg) (((reg) & IO_PAD91_PIOCFG_PDEN_MASK) >> IO_PAD91_PIOCFG_PDEN_SHIFT)
#define  IO_PAD91_PIOCFG_PDEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD91_PIOCFG_PDEN_MASK) | (((uint32_t)val) << IO_PAD91_PIOCFG_PDEN_SHIFT))

#define  IO_PAD91_PIOCFG_SR_MASK 0x1800
#define  IO_PAD91_PIOCFG_SR_SHIFT 11
#define  IO_PAD91_PIOCFG_SR_MASK_SHIFT(reg) (((reg) & IO_PAD91_PIOCFG_SR_MASK) >> IO_PAD91_PIOCFG_SR_SHIFT)
#define  IO_PAD91_PIOCFG_SR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD91_PIOCFG_SR_MASK) | (((uint32_t)val) << IO_PAD91_PIOCFG_SR_SHIFT))

#define  IO_PAD91_PIOCFG_SLP_DI_MASK 0x400
#define  IO_PAD91_PIOCFG_SLP_DI_SHIFT 10
#define  IO_PAD91_PIOCFG_SLP_DI_MASK_SHIFT(reg) (((reg) & IO_PAD91_PIOCFG_SLP_DI_MASK) >> IO_PAD91_PIOCFG_SLP_DI_SHIFT)
#define  IO_PAD91_PIOCFG_SLP_DI_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD91_PIOCFG_SLP_DI_MASK) | (((uint32_t)val) << IO_PAD91_PIOCFG_SLP_DI_SHIFT))

#define  IO_PAD91_PIOCFG_SLP_CNTRL_MASK 0x200
#define  IO_PAD91_PIOCFG_SLP_CNTRL_SHIFT 9
#define  IO_PAD91_PIOCFG_SLP_CNTRL_MASK_SHIFT(reg) (((reg) & IO_PAD91_PIOCFG_SLP_CNTRL_MASK) >> IO_PAD91_PIOCFG_SLP_CNTRL_SHIFT)
#define  IO_PAD91_PIOCFG_SLP_CNTRL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD91_PIOCFG_SLP_CNTRL_MASK) | (((uint32_t)val) << IO_PAD91_PIOCFG_SLP_CNTRL_SHIFT))

#define  IO_PAD91_PIOCFG_SLP_DO_MASK 0x100
#define  IO_PAD91_PIOCFG_SLP_DO_SHIFT 8
#define  IO_PAD91_PIOCFG_SLP_DO_MASK_SHIFT(reg) (((reg) & IO_PAD91_PIOCFG_SLP_DO_MASK) >> IO_PAD91_PIOCFG_SLP_DO_SHIFT)
#define  IO_PAD91_PIOCFG_SLP_DO_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD91_PIOCFG_SLP_DO_MASK) | (((uint32_t)val) << IO_PAD91_PIOCFG_SLP_DO_SHIFT))

#define  IO_PAD91_PIOCFG_SLP_DIR_MASK 0x80
#define  IO_PAD91_PIOCFG_SLP_DIR_SHIFT 7
#define  IO_PAD91_PIOCFG_SLP_DIR_MASK_SHIFT(reg) (((reg) & IO_PAD91_PIOCFG_SLP_DIR_MASK) >> IO_PAD91_PIOCFG_SLP_DIR_SHIFT)
#define  IO_PAD91_PIOCFG_SLP_DIR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD91_PIOCFG_SLP_DIR_MASK) | (((uint32_t)val) << IO_PAD91_PIOCFG_SLP_DIR_SHIFT))

#define  IO_PAD91_PIOCFG_EDGE_EN_N_MASK 0x40
#define  IO_PAD91_PIOCFG_EDGE_EN_N_SHIFT 6
#define  IO_PAD91_PIOCFG_EDGE_EN_N_MASK_SHIFT(reg) (((reg) & IO_PAD91_PIOCFG_EDGE_EN_N_MASK) >> IO_PAD91_PIOCFG_EDGE_EN_N_SHIFT)
#define  IO_PAD91_PIOCFG_EDGE_EN_N_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD91_PIOCFG_EDGE_EN_N_MASK) | (((uint32_t)val) << IO_PAD91_PIOCFG_EDGE_EN_N_SHIFT))

#define  IO_PAD91_PIOCFG_EDGE_FALL_EN_MASK 0x20
#define  IO_PAD91_PIOCFG_EDGE_FALL_EN_SHIFT 5
#define  IO_PAD91_PIOCFG_EDGE_FALL_EN_MASK_SHIFT(reg) (((reg) & IO_PAD91_PIOCFG_EDGE_FALL_EN_MASK) >> IO_PAD91_PIOCFG_EDGE_FALL_EN_SHIFT)
#define  IO_PAD91_PIOCFG_EDGE_FALL_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD91_PIOCFG_EDGE_FALL_EN_MASK) | (((uint32_t)val) << IO_PAD91_PIOCFG_EDGE_FALL_EN_SHIFT))

#define  IO_PAD91_PIOCFG_EDGE_RISE_EN_MASK 0x10
#define  IO_PAD91_PIOCFG_EDGE_RISE_EN_SHIFT 4
#define  IO_PAD91_PIOCFG_EDGE_RISE_EN_MASK_SHIFT(reg) (((reg) & IO_PAD91_PIOCFG_EDGE_RISE_EN_MASK) >> IO_PAD91_PIOCFG_EDGE_RISE_EN_SHIFT)
#define  IO_PAD91_PIOCFG_EDGE_RISE_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD91_PIOCFG_EDGE_RISE_EN_MASK) | (((uint32_t)val) << IO_PAD91_PIOCFG_EDGE_RISE_EN_SHIFT))

#define  IO_PAD91_PIOCFG_SLP_SEL_MASK 0x8
#define  IO_PAD91_PIOCFG_SLP_SEL_SHIFT 3
#define  IO_PAD91_PIOCFG_SLP_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD91_PIOCFG_SLP_SEL_MASK) >> IO_PAD91_PIOCFG_SLP_SEL_SHIFT)
#define  IO_PAD91_PIOCFG_SLP_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD91_PIOCFG_SLP_SEL_MASK) | (((uint32_t)val) << IO_PAD91_PIOCFG_SLP_SEL_SHIFT))

#define  IO_PAD91_PIOCFG_FUNC_SEL_MASK 0x7
#define  IO_PAD91_PIOCFG_FUNC_SEL_SHIFT 0
#define  IO_PAD91_PIOCFG_FUNC_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD91_PIOCFG_FUNC_SEL_MASK) >> IO_PAD91_PIOCFG_FUNC_SEL_SHIFT)
#define  IO_PAD91_PIOCFG_FUNC_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD91_PIOCFG_FUNC_SEL_MASK) | (((uint32_t)val) << IO_PAD91_PIOCFG_FUNC_SEL_SHIFT))

//====================================================================
//
//Register File: IO_PAD92 Configuration Registers (IO_PAD92)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

//====================================================================
//Register: IO_PAD92 Configuration Register (PIOCFG)
/** \brief "PHI_PADXDC_IOB" Pad*/
//====================================================================

#define  IO_PAD92_PIOCFG_RESERVED1_MASK 0xfc000000
#define  IO_PAD92_PIOCFG_RESERVED1_SHIFT 26
#define  IO_PAD92_PIOCFG_RESERVED1_MASK_SHIFT(reg) (((reg) & IO_PAD92_PIOCFG_RESERVED1_MASK) >> IO_PAD92_PIOCFG_RESERVED1_SHIFT)
#define  IO_PAD92_PIOCFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD92_PIOCFG_RESERVED1_MASK) | (((uint32_t)val) << IO_PAD92_PIOCFG_RESERVED1_SHIFT))

#define  IO_PAD92_PIOCFG_PD_MASK 0x2000000
#define  IO_PAD92_PIOCFG_PD_SHIFT 25
#define  IO_PAD92_PIOCFG_PD_MASK_SHIFT(reg) (((reg) & IO_PAD92_PIOCFG_PD_MASK) >> IO_PAD92_PIOCFG_PD_SHIFT)
#define  IO_PAD92_PIOCFG_PD_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD92_PIOCFG_PD_MASK) | (((uint32_t)val) << IO_PAD92_PIOCFG_PD_SHIFT))

#define  IO_PAD92_PIOCFG_ODT_EN_MASK 0x1000000
#define  IO_PAD92_PIOCFG_ODT_EN_SHIFT 24
#define  IO_PAD92_PIOCFG_ODT_EN_MASK_SHIFT(reg) (((reg) & IO_PAD92_PIOCFG_ODT_EN_MASK) >> IO_PAD92_PIOCFG_ODT_EN_SHIFT)
#define  IO_PAD92_PIOCFG_ODT_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD92_PIOCFG_ODT_EN_MASK) | (((uint32_t)val) << IO_PAD92_PIOCFG_ODT_EN_SHIFT))

#define  IO_PAD92_PIOCFG_LED_EN_MASK 0x800000
#define  IO_PAD92_PIOCFG_LED_EN_SHIFT 23
#define  IO_PAD92_PIOCFG_LED_EN_MASK_SHIFT(reg) (((reg) & IO_PAD92_PIOCFG_LED_EN_MASK) >> IO_PAD92_PIOCFG_LED_EN_SHIFT)
#define  IO_PAD92_PIOCFG_LED_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD92_PIOCFG_LED_EN_MASK) | (((uint32_t)val) << IO_PAD92_PIOCFG_LED_EN_SHIFT))

#define  IO_PAD92_PIOCFG_I2C_SEL_MASK 0x600000
#define  IO_PAD92_PIOCFG_I2C_SEL_SHIFT 21
#define  IO_PAD92_PIOCFG_I2C_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD92_PIOCFG_I2C_SEL_MASK) >> IO_PAD92_PIOCFG_I2C_SEL_SHIFT)
#define  IO_PAD92_PIOCFG_I2C_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD92_PIOCFG_I2C_SEL_MASK) | (((uint32_t)val) << IO_PAD92_PIOCFG_I2C_SEL_SHIFT))

#define  IO_PAD92_PIOCFG_DGTBSEL_MASK 0x1e0000
#define  IO_PAD92_PIOCFG_DGTBSEL_SHIFT 17
#define  IO_PAD92_PIOCFG_DGTBSEL_MASK_SHIFT(reg) (((reg) & IO_PAD92_PIOCFG_DGTBSEL_MASK) >> IO_PAD92_PIOCFG_DGTBSEL_SHIFT)
#define  IO_PAD92_PIOCFG_DGTBSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD92_PIOCFG_DGTBSEL_MASK) | (((uint32_t)val) << IO_PAD92_PIOCFG_DGTBSEL_SHIFT))

#define  IO_PAD92_PIOCFG_RAWSEL_MASK 0x10000
#define  IO_PAD92_PIOCFG_RAWSEL_SHIFT 16
#define  IO_PAD92_PIOCFG_RAWSEL_MASK_SHIFT(reg) (((reg) & IO_PAD92_PIOCFG_RAWSEL_MASK) >> IO_PAD92_PIOCFG_RAWSEL_SHIFT)
#define  IO_PAD92_PIOCFG_RAWSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD92_PIOCFG_RAWSEL_MASK) | (((uint32_t)val) << IO_PAD92_PIOCFG_RAWSEL_SHIFT))

#define  IO_PAD92_PIOCFG_PULL_SEL_MASK 0x8000
#define  IO_PAD92_PIOCFG_PULL_SEL_SHIFT 15
#define  IO_PAD92_PIOCFG_PULL_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD92_PIOCFG_PULL_SEL_MASK) >> IO_PAD92_PIOCFG_PULL_SEL_SHIFT)
#define  IO_PAD92_PIOCFG_PULL_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD92_PIOCFG_PULL_SEL_MASK) | (((uint32_t)val) << IO_PAD92_PIOCFG_PULL_SEL_SHIFT))

#define  IO_PAD92_PIOCFG_PUEN_MASK 0x4000
#define  IO_PAD92_PIOCFG_PUEN_SHIFT 14
#define  IO_PAD92_PIOCFG_PUEN_MASK_SHIFT(reg) (((reg) & IO_PAD92_PIOCFG_PUEN_MASK) >> IO_PAD92_PIOCFG_PUEN_SHIFT)
#define  IO_PAD92_PIOCFG_PUEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD92_PIOCFG_PUEN_MASK) | (((uint32_t)val) << IO_PAD92_PIOCFG_PUEN_SHIFT))

#define  IO_PAD92_PIOCFG_PDEN_MASK 0x2000
#define  IO_PAD92_PIOCFG_PDEN_SHIFT 13
#define  IO_PAD92_PIOCFG_PDEN_MASK_SHIFT(reg) (((reg) & IO_PAD92_PIOCFG_PDEN_MASK) >> IO_PAD92_PIOCFG_PDEN_SHIFT)
#define  IO_PAD92_PIOCFG_PDEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD92_PIOCFG_PDEN_MASK) | (((uint32_t)val) << IO_PAD92_PIOCFG_PDEN_SHIFT))

#define  IO_PAD92_PIOCFG_SR_MASK 0x1800
#define  IO_PAD92_PIOCFG_SR_SHIFT 11
#define  IO_PAD92_PIOCFG_SR_MASK_SHIFT(reg) (((reg) & IO_PAD92_PIOCFG_SR_MASK) >> IO_PAD92_PIOCFG_SR_SHIFT)
#define  IO_PAD92_PIOCFG_SR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD92_PIOCFG_SR_MASK) | (((uint32_t)val) << IO_PAD92_PIOCFG_SR_SHIFT))

#define  IO_PAD92_PIOCFG_SLP_DI_MASK 0x400
#define  IO_PAD92_PIOCFG_SLP_DI_SHIFT 10
#define  IO_PAD92_PIOCFG_SLP_DI_MASK_SHIFT(reg) (((reg) & IO_PAD92_PIOCFG_SLP_DI_MASK) >> IO_PAD92_PIOCFG_SLP_DI_SHIFT)
#define  IO_PAD92_PIOCFG_SLP_DI_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD92_PIOCFG_SLP_DI_MASK) | (((uint32_t)val) << IO_PAD92_PIOCFG_SLP_DI_SHIFT))

#define  IO_PAD92_PIOCFG_SLP_CNTRL_MASK 0x200
#define  IO_PAD92_PIOCFG_SLP_CNTRL_SHIFT 9
#define  IO_PAD92_PIOCFG_SLP_CNTRL_MASK_SHIFT(reg) (((reg) & IO_PAD92_PIOCFG_SLP_CNTRL_MASK) >> IO_PAD92_PIOCFG_SLP_CNTRL_SHIFT)
#define  IO_PAD92_PIOCFG_SLP_CNTRL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD92_PIOCFG_SLP_CNTRL_MASK) | (((uint32_t)val) << IO_PAD92_PIOCFG_SLP_CNTRL_SHIFT))

#define  IO_PAD92_PIOCFG_SLP_DO_MASK 0x100
#define  IO_PAD92_PIOCFG_SLP_DO_SHIFT 8
#define  IO_PAD92_PIOCFG_SLP_DO_MASK_SHIFT(reg) (((reg) & IO_PAD92_PIOCFG_SLP_DO_MASK) >> IO_PAD92_PIOCFG_SLP_DO_SHIFT)
#define  IO_PAD92_PIOCFG_SLP_DO_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD92_PIOCFG_SLP_DO_MASK) | (((uint32_t)val) << IO_PAD92_PIOCFG_SLP_DO_SHIFT))

#define  IO_PAD92_PIOCFG_SLP_DIR_MASK 0x80
#define  IO_PAD92_PIOCFG_SLP_DIR_SHIFT 7
#define  IO_PAD92_PIOCFG_SLP_DIR_MASK_SHIFT(reg) (((reg) & IO_PAD92_PIOCFG_SLP_DIR_MASK) >> IO_PAD92_PIOCFG_SLP_DIR_SHIFT)
#define  IO_PAD92_PIOCFG_SLP_DIR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD92_PIOCFG_SLP_DIR_MASK) | (((uint32_t)val) << IO_PAD92_PIOCFG_SLP_DIR_SHIFT))

#define  IO_PAD92_PIOCFG_EDGE_EN_N_MASK 0x40
#define  IO_PAD92_PIOCFG_EDGE_EN_N_SHIFT 6
#define  IO_PAD92_PIOCFG_EDGE_EN_N_MASK_SHIFT(reg) (((reg) & IO_PAD92_PIOCFG_EDGE_EN_N_MASK) >> IO_PAD92_PIOCFG_EDGE_EN_N_SHIFT)
#define  IO_PAD92_PIOCFG_EDGE_EN_N_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD92_PIOCFG_EDGE_EN_N_MASK) | (((uint32_t)val) << IO_PAD92_PIOCFG_EDGE_EN_N_SHIFT))

#define  IO_PAD92_PIOCFG_EDGE_FALL_EN_MASK 0x20
#define  IO_PAD92_PIOCFG_EDGE_FALL_EN_SHIFT 5
#define  IO_PAD92_PIOCFG_EDGE_FALL_EN_MASK_SHIFT(reg) (((reg) & IO_PAD92_PIOCFG_EDGE_FALL_EN_MASK) >> IO_PAD92_PIOCFG_EDGE_FALL_EN_SHIFT)
#define  IO_PAD92_PIOCFG_EDGE_FALL_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD92_PIOCFG_EDGE_FALL_EN_MASK) | (((uint32_t)val) << IO_PAD92_PIOCFG_EDGE_FALL_EN_SHIFT))

#define  IO_PAD92_PIOCFG_EDGE_RISE_EN_MASK 0x10
#define  IO_PAD92_PIOCFG_EDGE_RISE_EN_SHIFT 4
#define  IO_PAD92_PIOCFG_EDGE_RISE_EN_MASK_SHIFT(reg) (((reg) & IO_PAD92_PIOCFG_EDGE_RISE_EN_MASK) >> IO_PAD92_PIOCFG_EDGE_RISE_EN_SHIFT)
#define  IO_PAD92_PIOCFG_EDGE_RISE_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD92_PIOCFG_EDGE_RISE_EN_MASK) | (((uint32_t)val) << IO_PAD92_PIOCFG_EDGE_RISE_EN_SHIFT))

#define  IO_PAD92_PIOCFG_SLP_SEL_MASK 0x8
#define  IO_PAD92_PIOCFG_SLP_SEL_SHIFT 3
#define  IO_PAD92_PIOCFG_SLP_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD92_PIOCFG_SLP_SEL_MASK) >> IO_PAD92_PIOCFG_SLP_SEL_SHIFT)
#define  IO_PAD92_PIOCFG_SLP_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD92_PIOCFG_SLP_SEL_MASK) | (((uint32_t)val) << IO_PAD92_PIOCFG_SLP_SEL_SHIFT))

#define  IO_PAD92_PIOCFG_FUNC_SEL_MASK 0x7
#define  IO_PAD92_PIOCFG_FUNC_SEL_SHIFT 0
#define  IO_PAD92_PIOCFG_FUNC_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD92_PIOCFG_FUNC_SEL_MASK) >> IO_PAD92_PIOCFG_FUNC_SEL_SHIFT)
#define  IO_PAD92_PIOCFG_FUNC_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD92_PIOCFG_FUNC_SEL_MASK) | (((uint32_t)val) << IO_PAD92_PIOCFG_FUNC_SEL_SHIFT))

//====================================================================
//
//Register File: IO_PAD93 Configuration Registers (IO_PAD93)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

//====================================================================
//Register: IO_PAD93 Configuration Register (PIOCFG)
/** \brief "PHI_PADXDC_IOB" Pad*/
//====================================================================

#define  IO_PAD93_PIOCFG_RESERVED1_MASK 0xfc000000
#define  IO_PAD93_PIOCFG_RESERVED1_SHIFT 26
#define  IO_PAD93_PIOCFG_RESERVED1_MASK_SHIFT(reg) (((reg) & IO_PAD93_PIOCFG_RESERVED1_MASK) >> IO_PAD93_PIOCFG_RESERVED1_SHIFT)
#define  IO_PAD93_PIOCFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD93_PIOCFG_RESERVED1_MASK) | (((uint32_t)val) << IO_PAD93_PIOCFG_RESERVED1_SHIFT))

#define  IO_PAD93_PIOCFG_PD_MASK 0x2000000
#define  IO_PAD93_PIOCFG_PD_SHIFT 25
#define  IO_PAD93_PIOCFG_PD_MASK_SHIFT(reg) (((reg) & IO_PAD93_PIOCFG_PD_MASK) >> IO_PAD93_PIOCFG_PD_SHIFT)
#define  IO_PAD93_PIOCFG_PD_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD93_PIOCFG_PD_MASK) | (((uint32_t)val) << IO_PAD93_PIOCFG_PD_SHIFT))

#define  IO_PAD93_PIOCFG_ODT_EN_MASK 0x1000000
#define  IO_PAD93_PIOCFG_ODT_EN_SHIFT 24
#define  IO_PAD93_PIOCFG_ODT_EN_MASK_SHIFT(reg) (((reg) & IO_PAD93_PIOCFG_ODT_EN_MASK) >> IO_PAD93_PIOCFG_ODT_EN_SHIFT)
#define  IO_PAD93_PIOCFG_ODT_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD93_PIOCFG_ODT_EN_MASK) | (((uint32_t)val) << IO_PAD93_PIOCFG_ODT_EN_SHIFT))

#define  IO_PAD93_PIOCFG_LED_EN_MASK 0x800000
#define  IO_PAD93_PIOCFG_LED_EN_SHIFT 23
#define  IO_PAD93_PIOCFG_LED_EN_MASK_SHIFT(reg) (((reg) & IO_PAD93_PIOCFG_LED_EN_MASK) >> IO_PAD93_PIOCFG_LED_EN_SHIFT)
#define  IO_PAD93_PIOCFG_LED_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD93_PIOCFG_LED_EN_MASK) | (((uint32_t)val) << IO_PAD93_PIOCFG_LED_EN_SHIFT))

#define  IO_PAD93_PIOCFG_I2C_SEL_MASK 0x600000
#define  IO_PAD93_PIOCFG_I2C_SEL_SHIFT 21
#define  IO_PAD93_PIOCFG_I2C_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD93_PIOCFG_I2C_SEL_MASK) >> IO_PAD93_PIOCFG_I2C_SEL_SHIFT)
#define  IO_PAD93_PIOCFG_I2C_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD93_PIOCFG_I2C_SEL_MASK) | (((uint32_t)val) << IO_PAD93_PIOCFG_I2C_SEL_SHIFT))

#define  IO_PAD93_PIOCFG_DGTBSEL_MASK 0x1e0000
#define  IO_PAD93_PIOCFG_DGTBSEL_SHIFT 17
#define  IO_PAD93_PIOCFG_DGTBSEL_MASK_SHIFT(reg) (((reg) & IO_PAD93_PIOCFG_DGTBSEL_MASK) >> IO_PAD93_PIOCFG_DGTBSEL_SHIFT)
#define  IO_PAD93_PIOCFG_DGTBSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD93_PIOCFG_DGTBSEL_MASK) | (((uint32_t)val) << IO_PAD93_PIOCFG_DGTBSEL_SHIFT))

#define  IO_PAD93_PIOCFG_RAWSEL_MASK 0x10000
#define  IO_PAD93_PIOCFG_RAWSEL_SHIFT 16
#define  IO_PAD93_PIOCFG_RAWSEL_MASK_SHIFT(reg) (((reg) & IO_PAD93_PIOCFG_RAWSEL_MASK) >> IO_PAD93_PIOCFG_RAWSEL_SHIFT)
#define  IO_PAD93_PIOCFG_RAWSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD93_PIOCFG_RAWSEL_MASK) | (((uint32_t)val) << IO_PAD93_PIOCFG_RAWSEL_SHIFT))

#define  IO_PAD93_PIOCFG_PULL_SEL_MASK 0x8000
#define  IO_PAD93_PIOCFG_PULL_SEL_SHIFT 15
#define  IO_PAD93_PIOCFG_PULL_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD93_PIOCFG_PULL_SEL_MASK) >> IO_PAD93_PIOCFG_PULL_SEL_SHIFT)
#define  IO_PAD93_PIOCFG_PULL_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD93_PIOCFG_PULL_SEL_MASK) | (((uint32_t)val) << IO_PAD93_PIOCFG_PULL_SEL_SHIFT))

#define  IO_PAD93_PIOCFG_PUEN_MASK 0x4000
#define  IO_PAD93_PIOCFG_PUEN_SHIFT 14
#define  IO_PAD93_PIOCFG_PUEN_MASK_SHIFT(reg) (((reg) & IO_PAD93_PIOCFG_PUEN_MASK) >> IO_PAD93_PIOCFG_PUEN_SHIFT)
#define  IO_PAD93_PIOCFG_PUEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD93_PIOCFG_PUEN_MASK) | (((uint32_t)val) << IO_PAD93_PIOCFG_PUEN_SHIFT))

#define  IO_PAD93_PIOCFG_PDEN_MASK 0x2000
#define  IO_PAD93_PIOCFG_PDEN_SHIFT 13
#define  IO_PAD93_PIOCFG_PDEN_MASK_SHIFT(reg) (((reg) & IO_PAD93_PIOCFG_PDEN_MASK) >> IO_PAD93_PIOCFG_PDEN_SHIFT)
#define  IO_PAD93_PIOCFG_PDEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD93_PIOCFG_PDEN_MASK) | (((uint32_t)val) << IO_PAD93_PIOCFG_PDEN_SHIFT))

#define  IO_PAD93_PIOCFG_SR_MASK 0x1800
#define  IO_PAD93_PIOCFG_SR_SHIFT 11
#define  IO_PAD93_PIOCFG_SR_MASK_SHIFT(reg) (((reg) & IO_PAD93_PIOCFG_SR_MASK) >> IO_PAD93_PIOCFG_SR_SHIFT)
#define  IO_PAD93_PIOCFG_SR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD93_PIOCFG_SR_MASK) | (((uint32_t)val) << IO_PAD93_PIOCFG_SR_SHIFT))

#define  IO_PAD93_PIOCFG_SLP_DI_MASK 0x400
#define  IO_PAD93_PIOCFG_SLP_DI_SHIFT 10
#define  IO_PAD93_PIOCFG_SLP_DI_MASK_SHIFT(reg) (((reg) & IO_PAD93_PIOCFG_SLP_DI_MASK) >> IO_PAD93_PIOCFG_SLP_DI_SHIFT)
#define  IO_PAD93_PIOCFG_SLP_DI_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD93_PIOCFG_SLP_DI_MASK) | (((uint32_t)val) << IO_PAD93_PIOCFG_SLP_DI_SHIFT))

#define  IO_PAD93_PIOCFG_SLP_CNTRL_MASK 0x200
#define  IO_PAD93_PIOCFG_SLP_CNTRL_SHIFT 9
#define  IO_PAD93_PIOCFG_SLP_CNTRL_MASK_SHIFT(reg) (((reg) & IO_PAD93_PIOCFG_SLP_CNTRL_MASK) >> IO_PAD93_PIOCFG_SLP_CNTRL_SHIFT)
#define  IO_PAD93_PIOCFG_SLP_CNTRL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD93_PIOCFG_SLP_CNTRL_MASK) | (((uint32_t)val) << IO_PAD93_PIOCFG_SLP_CNTRL_SHIFT))

#define  IO_PAD93_PIOCFG_SLP_DO_MASK 0x100
#define  IO_PAD93_PIOCFG_SLP_DO_SHIFT 8
#define  IO_PAD93_PIOCFG_SLP_DO_MASK_SHIFT(reg) (((reg) & IO_PAD93_PIOCFG_SLP_DO_MASK) >> IO_PAD93_PIOCFG_SLP_DO_SHIFT)
#define  IO_PAD93_PIOCFG_SLP_DO_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD93_PIOCFG_SLP_DO_MASK) | (((uint32_t)val) << IO_PAD93_PIOCFG_SLP_DO_SHIFT))

#define  IO_PAD93_PIOCFG_SLP_DIR_MASK 0x80
#define  IO_PAD93_PIOCFG_SLP_DIR_SHIFT 7
#define  IO_PAD93_PIOCFG_SLP_DIR_MASK_SHIFT(reg) (((reg) & IO_PAD93_PIOCFG_SLP_DIR_MASK) >> IO_PAD93_PIOCFG_SLP_DIR_SHIFT)
#define  IO_PAD93_PIOCFG_SLP_DIR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD93_PIOCFG_SLP_DIR_MASK) | (((uint32_t)val) << IO_PAD93_PIOCFG_SLP_DIR_SHIFT))

#define  IO_PAD93_PIOCFG_EDGE_EN_N_MASK 0x40
#define  IO_PAD93_PIOCFG_EDGE_EN_N_SHIFT 6
#define  IO_PAD93_PIOCFG_EDGE_EN_N_MASK_SHIFT(reg) (((reg) & IO_PAD93_PIOCFG_EDGE_EN_N_MASK) >> IO_PAD93_PIOCFG_EDGE_EN_N_SHIFT)
#define  IO_PAD93_PIOCFG_EDGE_EN_N_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD93_PIOCFG_EDGE_EN_N_MASK) | (((uint32_t)val) << IO_PAD93_PIOCFG_EDGE_EN_N_SHIFT))

#define  IO_PAD93_PIOCFG_EDGE_FALL_EN_MASK 0x20
#define  IO_PAD93_PIOCFG_EDGE_FALL_EN_SHIFT 5
#define  IO_PAD93_PIOCFG_EDGE_FALL_EN_MASK_SHIFT(reg) (((reg) & IO_PAD93_PIOCFG_EDGE_FALL_EN_MASK) >> IO_PAD93_PIOCFG_EDGE_FALL_EN_SHIFT)
#define  IO_PAD93_PIOCFG_EDGE_FALL_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD93_PIOCFG_EDGE_FALL_EN_MASK) | (((uint32_t)val) << IO_PAD93_PIOCFG_EDGE_FALL_EN_SHIFT))

#define  IO_PAD93_PIOCFG_EDGE_RISE_EN_MASK 0x10
#define  IO_PAD93_PIOCFG_EDGE_RISE_EN_SHIFT 4
#define  IO_PAD93_PIOCFG_EDGE_RISE_EN_MASK_SHIFT(reg) (((reg) & IO_PAD93_PIOCFG_EDGE_RISE_EN_MASK) >> IO_PAD93_PIOCFG_EDGE_RISE_EN_SHIFT)
#define  IO_PAD93_PIOCFG_EDGE_RISE_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD93_PIOCFG_EDGE_RISE_EN_MASK) | (((uint32_t)val) << IO_PAD93_PIOCFG_EDGE_RISE_EN_SHIFT))

#define  IO_PAD93_PIOCFG_SLP_SEL_MASK 0x8
#define  IO_PAD93_PIOCFG_SLP_SEL_SHIFT 3
#define  IO_PAD93_PIOCFG_SLP_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD93_PIOCFG_SLP_SEL_MASK) >> IO_PAD93_PIOCFG_SLP_SEL_SHIFT)
#define  IO_PAD93_PIOCFG_SLP_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD93_PIOCFG_SLP_SEL_MASK) | (((uint32_t)val) << IO_PAD93_PIOCFG_SLP_SEL_SHIFT))

#define  IO_PAD93_PIOCFG_FUNC_SEL_MASK 0x7
#define  IO_PAD93_PIOCFG_FUNC_SEL_SHIFT 0
#define  IO_PAD93_PIOCFG_FUNC_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD93_PIOCFG_FUNC_SEL_MASK) >> IO_PAD93_PIOCFG_FUNC_SEL_SHIFT)
#define  IO_PAD93_PIOCFG_FUNC_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD93_PIOCFG_FUNC_SEL_MASK) | (((uint32_t)val) << IO_PAD93_PIOCFG_FUNC_SEL_SHIFT))

//====================================================================
//
//Register File: IO_PAD94 Configuration Registers (IO_PAD94)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

//====================================================================
//Register: IO_PAD94 Configuration Register (PIOCFG)
/** \brief "PHI_PADXDC_IOB" Pad*/
//====================================================================

#define  IO_PAD94_PIOCFG_RESERVED1_MASK 0xfc000000
#define  IO_PAD94_PIOCFG_RESERVED1_SHIFT 26
#define  IO_PAD94_PIOCFG_RESERVED1_MASK_SHIFT(reg) (((reg) & IO_PAD94_PIOCFG_RESERVED1_MASK) >> IO_PAD94_PIOCFG_RESERVED1_SHIFT)
#define  IO_PAD94_PIOCFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD94_PIOCFG_RESERVED1_MASK) | (((uint32_t)val) << IO_PAD94_PIOCFG_RESERVED1_SHIFT))

#define  IO_PAD94_PIOCFG_PD_MASK 0x2000000
#define  IO_PAD94_PIOCFG_PD_SHIFT 25
#define  IO_PAD94_PIOCFG_PD_MASK_SHIFT(reg) (((reg) & IO_PAD94_PIOCFG_PD_MASK) >> IO_PAD94_PIOCFG_PD_SHIFT)
#define  IO_PAD94_PIOCFG_PD_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD94_PIOCFG_PD_MASK) | (((uint32_t)val) << IO_PAD94_PIOCFG_PD_SHIFT))

#define  IO_PAD94_PIOCFG_ODT_EN_MASK 0x1000000
#define  IO_PAD94_PIOCFG_ODT_EN_SHIFT 24
#define  IO_PAD94_PIOCFG_ODT_EN_MASK_SHIFT(reg) (((reg) & IO_PAD94_PIOCFG_ODT_EN_MASK) >> IO_PAD94_PIOCFG_ODT_EN_SHIFT)
#define  IO_PAD94_PIOCFG_ODT_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD94_PIOCFG_ODT_EN_MASK) | (((uint32_t)val) << IO_PAD94_PIOCFG_ODT_EN_SHIFT))

#define  IO_PAD94_PIOCFG_LED_EN_MASK 0x800000
#define  IO_PAD94_PIOCFG_LED_EN_SHIFT 23
#define  IO_PAD94_PIOCFG_LED_EN_MASK_SHIFT(reg) (((reg) & IO_PAD94_PIOCFG_LED_EN_MASK) >> IO_PAD94_PIOCFG_LED_EN_SHIFT)
#define  IO_PAD94_PIOCFG_LED_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD94_PIOCFG_LED_EN_MASK) | (((uint32_t)val) << IO_PAD94_PIOCFG_LED_EN_SHIFT))

#define  IO_PAD94_PIOCFG_I2C_SEL_MASK 0x600000
#define  IO_PAD94_PIOCFG_I2C_SEL_SHIFT 21
#define  IO_PAD94_PIOCFG_I2C_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD94_PIOCFG_I2C_SEL_MASK) >> IO_PAD94_PIOCFG_I2C_SEL_SHIFT)
#define  IO_PAD94_PIOCFG_I2C_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD94_PIOCFG_I2C_SEL_MASK) | (((uint32_t)val) << IO_PAD94_PIOCFG_I2C_SEL_SHIFT))

#define  IO_PAD94_PIOCFG_DGTBSEL_MASK 0x1e0000
#define  IO_PAD94_PIOCFG_DGTBSEL_SHIFT 17
#define  IO_PAD94_PIOCFG_DGTBSEL_MASK_SHIFT(reg) (((reg) & IO_PAD94_PIOCFG_DGTBSEL_MASK) >> IO_PAD94_PIOCFG_DGTBSEL_SHIFT)
#define  IO_PAD94_PIOCFG_DGTBSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD94_PIOCFG_DGTBSEL_MASK) | (((uint32_t)val) << IO_PAD94_PIOCFG_DGTBSEL_SHIFT))

#define  IO_PAD94_PIOCFG_RAWSEL_MASK 0x10000
#define  IO_PAD94_PIOCFG_RAWSEL_SHIFT 16
#define  IO_PAD94_PIOCFG_RAWSEL_MASK_SHIFT(reg) (((reg) & IO_PAD94_PIOCFG_RAWSEL_MASK) >> IO_PAD94_PIOCFG_RAWSEL_SHIFT)
#define  IO_PAD94_PIOCFG_RAWSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD94_PIOCFG_RAWSEL_MASK) | (((uint32_t)val) << IO_PAD94_PIOCFG_RAWSEL_SHIFT))

#define  IO_PAD94_PIOCFG_PULL_SEL_MASK 0x8000
#define  IO_PAD94_PIOCFG_PULL_SEL_SHIFT 15
#define  IO_PAD94_PIOCFG_PULL_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD94_PIOCFG_PULL_SEL_MASK) >> IO_PAD94_PIOCFG_PULL_SEL_SHIFT)
#define  IO_PAD94_PIOCFG_PULL_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD94_PIOCFG_PULL_SEL_MASK) | (((uint32_t)val) << IO_PAD94_PIOCFG_PULL_SEL_SHIFT))

#define  IO_PAD94_PIOCFG_PUEN_MASK 0x4000
#define  IO_PAD94_PIOCFG_PUEN_SHIFT 14
#define  IO_PAD94_PIOCFG_PUEN_MASK_SHIFT(reg) (((reg) & IO_PAD94_PIOCFG_PUEN_MASK) >> IO_PAD94_PIOCFG_PUEN_SHIFT)
#define  IO_PAD94_PIOCFG_PUEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD94_PIOCFG_PUEN_MASK) | (((uint32_t)val) << IO_PAD94_PIOCFG_PUEN_SHIFT))

#define  IO_PAD94_PIOCFG_PDEN_MASK 0x2000
#define  IO_PAD94_PIOCFG_PDEN_SHIFT 13
#define  IO_PAD94_PIOCFG_PDEN_MASK_SHIFT(reg) (((reg) & IO_PAD94_PIOCFG_PDEN_MASK) >> IO_PAD94_PIOCFG_PDEN_SHIFT)
#define  IO_PAD94_PIOCFG_PDEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD94_PIOCFG_PDEN_MASK) | (((uint32_t)val) << IO_PAD94_PIOCFG_PDEN_SHIFT))

#define  IO_PAD94_PIOCFG_SR_MASK 0x1800
#define  IO_PAD94_PIOCFG_SR_SHIFT 11
#define  IO_PAD94_PIOCFG_SR_MASK_SHIFT(reg) (((reg) & IO_PAD94_PIOCFG_SR_MASK) >> IO_PAD94_PIOCFG_SR_SHIFT)
#define  IO_PAD94_PIOCFG_SR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD94_PIOCFG_SR_MASK) | (((uint32_t)val) << IO_PAD94_PIOCFG_SR_SHIFT))

#define  IO_PAD94_PIOCFG_SLP_DI_MASK 0x400
#define  IO_PAD94_PIOCFG_SLP_DI_SHIFT 10
#define  IO_PAD94_PIOCFG_SLP_DI_MASK_SHIFT(reg) (((reg) & IO_PAD94_PIOCFG_SLP_DI_MASK) >> IO_PAD94_PIOCFG_SLP_DI_SHIFT)
#define  IO_PAD94_PIOCFG_SLP_DI_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD94_PIOCFG_SLP_DI_MASK) | (((uint32_t)val) << IO_PAD94_PIOCFG_SLP_DI_SHIFT))

#define  IO_PAD94_PIOCFG_SLP_CNTRL_MASK 0x200
#define  IO_PAD94_PIOCFG_SLP_CNTRL_SHIFT 9
#define  IO_PAD94_PIOCFG_SLP_CNTRL_MASK_SHIFT(reg) (((reg) & IO_PAD94_PIOCFG_SLP_CNTRL_MASK) >> IO_PAD94_PIOCFG_SLP_CNTRL_SHIFT)
#define  IO_PAD94_PIOCFG_SLP_CNTRL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD94_PIOCFG_SLP_CNTRL_MASK) | (((uint32_t)val) << IO_PAD94_PIOCFG_SLP_CNTRL_SHIFT))

#define  IO_PAD94_PIOCFG_SLP_DO_MASK 0x100
#define  IO_PAD94_PIOCFG_SLP_DO_SHIFT 8
#define  IO_PAD94_PIOCFG_SLP_DO_MASK_SHIFT(reg) (((reg) & IO_PAD94_PIOCFG_SLP_DO_MASK) >> IO_PAD94_PIOCFG_SLP_DO_SHIFT)
#define  IO_PAD94_PIOCFG_SLP_DO_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD94_PIOCFG_SLP_DO_MASK) | (((uint32_t)val) << IO_PAD94_PIOCFG_SLP_DO_SHIFT))

#define  IO_PAD94_PIOCFG_SLP_DIR_MASK 0x80
#define  IO_PAD94_PIOCFG_SLP_DIR_SHIFT 7
#define  IO_PAD94_PIOCFG_SLP_DIR_MASK_SHIFT(reg) (((reg) & IO_PAD94_PIOCFG_SLP_DIR_MASK) >> IO_PAD94_PIOCFG_SLP_DIR_SHIFT)
#define  IO_PAD94_PIOCFG_SLP_DIR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD94_PIOCFG_SLP_DIR_MASK) | (((uint32_t)val) << IO_PAD94_PIOCFG_SLP_DIR_SHIFT))

#define  IO_PAD94_PIOCFG_EDGE_EN_N_MASK 0x40
#define  IO_PAD94_PIOCFG_EDGE_EN_N_SHIFT 6
#define  IO_PAD94_PIOCFG_EDGE_EN_N_MASK_SHIFT(reg) (((reg) & IO_PAD94_PIOCFG_EDGE_EN_N_MASK) >> IO_PAD94_PIOCFG_EDGE_EN_N_SHIFT)
#define  IO_PAD94_PIOCFG_EDGE_EN_N_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD94_PIOCFG_EDGE_EN_N_MASK) | (((uint32_t)val) << IO_PAD94_PIOCFG_EDGE_EN_N_SHIFT))

#define  IO_PAD94_PIOCFG_EDGE_FALL_EN_MASK 0x20
#define  IO_PAD94_PIOCFG_EDGE_FALL_EN_SHIFT 5
#define  IO_PAD94_PIOCFG_EDGE_FALL_EN_MASK_SHIFT(reg) (((reg) & IO_PAD94_PIOCFG_EDGE_FALL_EN_MASK) >> IO_PAD94_PIOCFG_EDGE_FALL_EN_SHIFT)
#define  IO_PAD94_PIOCFG_EDGE_FALL_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD94_PIOCFG_EDGE_FALL_EN_MASK) | (((uint32_t)val) << IO_PAD94_PIOCFG_EDGE_FALL_EN_SHIFT))

#define  IO_PAD94_PIOCFG_EDGE_RISE_EN_MASK 0x10
#define  IO_PAD94_PIOCFG_EDGE_RISE_EN_SHIFT 4
#define  IO_PAD94_PIOCFG_EDGE_RISE_EN_MASK_SHIFT(reg) (((reg) & IO_PAD94_PIOCFG_EDGE_RISE_EN_MASK) >> IO_PAD94_PIOCFG_EDGE_RISE_EN_SHIFT)
#define  IO_PAD94_PIOCFG_EDGE_RISE_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD94_PIOCFG_EDGE_RISE_EN_MASK) | (((uint32_t)val) << IO_PAD94_PIOCFG_EDGE_RISE_EN_SHIFT))

#define  IO_PAD94_PIOCFG_SLP_SEL_MASK 0x8
#define  IO_PAD94_PIOCFG_SLP_SEL_SHIFT 3
#define  IO_PAD94_PIOCFG_SLP_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD94_PIOCFG_SLP_SEL_MASK) >> IO_PAD94_PIOCFG_SLP_SEL_SHIFT)
#define  IO_PAD94_PIOCFG_SLP_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD94_PIOCFG_SLP_SEL_MASK) | (((uint32_t)val) << IO_PAD94_PIOCFG_SLP_SEL_SHIFT))

#define  IO_PAD94_PIOCFG_FUNC_SEL_MASK 0x7
#define  IO_PAD94_PIOCFG_FUNC_SEL_SHIFT 0
#define  IO_PAD94_PIOCFG_FUNC_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD94_PIOCFG_FUNC_SEL_MASK) >> IO_PAD94_PIOCFG_FUNC_SEL_SHIFT)
#define  IO_PAD94_PIOCFG_FUNC_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD94_PIOCFG_FUNC_SEL_MASK) | (((uint32_t)val) << IO_PAD94_PIOCFG_FUNC_SEL_SHIFT))

//====================================================================
//
//Register File: IO_PAD95 Configuration Registers (IO_PAD95)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

//====================================================================
//Register: IO_PAD95 Configuration Register (PIOCFG)
/** \brief "PHI_PADXDC_IOB" Pad*/
//====================================================================

#define  IO_PAD95_PIOCFG_RESERVED1_MASK 0xfc000000
#define  IO_PAD95_PIOCFG_RESERVED1_SHIFT 26
#define  IO_PAD95_PIOCFG_RESERVED1_MASK_SHIFT(reg) (((reg) & IO_PAD95_PIOCFG_RESERVED1_MASK) >> IO_PAD95_PIOCFG_RESERVED1_SHIFT)
#define  IO_PAD95_PIOCFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD95_PIOCFG_RESERVED1_MASK) | (((uint32_t)val) << IO_PAD95_PIOCFG_RESERVED1_SHIFT))

#define  IO_PAD95_PIOCFG_PD_MASK 0x2000000
#define  IO_PAD95_PIOCFG_PD_SHIFT 25
#define  IO_PAD95_PIOCFG_PD_MASK_SHIFT(reg) (((reg) & IO_PAD95_PIOCFG_PD_MASK) >> IO_PAD95_PIOCFG_PD_SHIFT)
#define  IO_PAD95_PIOCFG_PD_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD95_PIOCFG_PD_MASK) | (((uint32_t)val) << IO_PAD95_PIOCFG_PD_SHIFT))

#define  IO_PAD95_PIOCFG_ODT_EN_MASK 0x1000000
#define  IO_PAD95_PIOCFG_ODT_EN_SHIFT 24
#define  IO_PAD95_PIOCFG_ODT_EN_MASK_SHIFT(reg) (((reg) & IO_PAD95_PIOCFG_ODT_EN_MASK) >> IO_PAD95_PIOCFG_ODT_EN_SHIFT)
#define  IO_PAD95_PIOCFG_ODT_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD95_PIOCFG_ODT_EN_MASK) | (((uint32_t)val) << IO_PAD95_PIOCFG_ODT_EN_SHIFT))

#define  IO_PAD95_PIOCFG_LED_EN_MASK 0x800000
#define  IO_PAD95_PIOCFG_LED_EN_SHIFT 23
#define  IO_PAD95_PIOCFG_LED_EN_MASK_SHIFT(reg) (((reg) & IO_PAD95_PIOCFG_LED_EN_MASK) >> IO_PAD95_PIOCFG_LED_EN_SHIFT)
#define  IO_PAD95_PIOCFG_LED_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD95_PIOCFG_LED_EN_MASK) | (((uint32_t)val) << IO_PAD95_PIOCFG_LED_EN_SHIFT))

#define  IO_PAD95_PIOCFG_I2C_SEL_MASK 0x600000
#define  IO_PAD95_PIOCFG_I2C_SEL_SHIFT 21
#define  IO_PAD95_PIOCFG_I2C_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD95_PIOCFG_I2C_SEL_MASK) >> IO_PAD95_PIOCFG_I2C_SEL_SHIFT)
#define  IO_PAD95_PIOCFG_I2C_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD95_PIOCFG_I2C_SEL_MASK) | (((uint32_t)val) << IO_PAD95_PIOCFG_I2C_SEL_SHIFT))

#define  IO_PAD95_PIOCFG_DGTBSEL_MASK 0x1e0000
#define  IO_PAD95_PIOCFG_DGTBSEL_SHIFT 17
#define  IO_PAD95_PIOCFG_DGTBSEL_MASK_SHIFT(reg) (((reg) & IO_PAD95_PIOCFG_DGTBSEL_MASK) >> IO_PAD95_PIOCFG_DGTBSEL_SHIFT)
#define  IO_PAD95_PIOCFG_DGTBSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD95_PIOCFG_DGTBSEL_MASK) | (((uint32_t)val) << IO_PAD95_PIOCFG_DGTBSEL_SHIFT))

#define  IO_PAD95_PIOCFG_RAWSEL_MASK 0x10000
#define  IO_PAD95_PIOCFG_RAWSEL_SHIFT 16
#define  IO_PAD95_PIOCFG_RAWSEL_MASK_SHIFT(reg) (((reg) & IO_PAD95_PIOCFG_RAWSEL_MASK) >> IO_PAD95_PIOCFG_RAWSEL_SHIFT)
#define  IO_PAD95_PIOCFG_RAWSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD95_PIOCFG_RAWSEL_MASK) | (((uint32_t)val) << IO_PAD95_PIOCFG_RAWSEL_SHIFT))

#define  IO_PAD95_PIOCFG_PULL_SEL_MASK 0x8000
#define  IO_PAD95_PIOCFG_PULL_SEL_SHIFT 15
#define  IO_PAD95_PIOCFG_PULL_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD95_PIOCFG_PULL_SEL_MASK) >> IO_PAD95_PIOCFG_PULL_SEL_SHIFT)
#define  IO_PAD95_PIOCFG_PULL_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD95_PIOCFG_PULL_SEL_MASK) | (((uint32_t)val) << IO_PAD95_PIOCFG_PULL_SEL_SHIFT))

#define  IO_PAD95_PIOCFG_PUEN_MASK 0x4000
#define  IO_PAD95_PIOCFG_PUEN_SHIFT 14
#define  IO_PAD95_PIOCFG_PUEN_MASK_SHIFT(reg) (((reg) & IO_PAD95_PIOCFG_PUEN_MASK) >> IO_PAD95_PIOCFG_PUEN_SHIFT)
#define  IO_PAD95_PIOCFG_PUEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD95_PIOCFG_PUEN_MASK) | (((uint32_t)val) << IO_PAD95_PIOCFG_PUEN_SHIFT))

#define  IO_PAD95_PIOCFG_PDEN_MASK 0x2000
#define  IO_PAD95_PIOCFG_PDEN_SHIFT 13
#define  IO_PAD95_PIOCFG_PDEN_MASK_SHIFT(reg) (((reg) & IO_PAD95_PIOCFG_PDEN_MASK) >> IO_PAD95_PIOCFG_PDEN_SHIFT)
#define  IO_PAD95_PIOCFG_PDEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD95_PIOCFG_PDEN_MASK) | (((uint32_t)val) << IO_PAD95_PIOCFG_PDEN_SHIFT))

#define  IO_PAD95_PIOCFG_SR_MASK 0x1800
#define  IO_PAD95_PIOCFG_SR_SHIFT 11
#define  IO_PAD95_PIOCFG_SR_MASK_SHIFT(reg) (((reg) & IO_PAD95_PIOCFG_SR_MASK) >> IO_PAD95_PIOCFG_SR_SHIFT)
#define  IO_PAD95_PIOCFG_SR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD95_PIOCFG_SR_MASK) | (((uint32_t)val) << IO_PAD95_PIOCFG_SR_SHIFT))

#define  IO_PAD95_PIOCFG_SLP_DI_MASK 0x400
#define  IO_PAD95_PIOCFG_SLP_DI_SHIFT 10
#define  IO_PAD95_PIOCFG_SLP_DI_MASK_SHIFT(reg) (((reg) & IO_PAD95_PIOCFG_SLP_DI_MASK) >> IO_PAD95_PIOCFG_SLP_DI_SHIFT)
#define  IO_PAD95_PIOCFG_SLP_DI_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD95_PIOCFG_SLP_DI_MASK) | (((uint32_t)val) << IO_PAD95_PIOCFG_SLP_DI_SHIFT))

#define  IO_PAD95_PIOCFG_SLP_CNTRL_MASK 0x200
#define  IO_PAD95_PIOCFG_SLP_CNTRL_SHIFT 9
#define  IO_PAD95_PIOCFG_SLP_CNTRL_MASK_SHIFT(reg) (((reg) & IO_PAD95_PIOCFG_SLP_CNTRL_MASK) >> IO_PAD95_PIOCFG_SLP_CNTRL_SHIFT)
#define  IO_PAD95_PIOCFG_SLP_CNTRL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD95_PIOCFG_SLP_CNTRL_MASK) | (((uint32_t)val) << IO_PAD95_PIOCFG_SLP_CNTRL_SHIFT))

#define  IO_PAD95_PIOCFG_SLP_DO_MASK 0x100
#define  IO_PAD95_PIOCFG_SLP_DO_SHIFT 8
#define  IO_PAD95_PIOCFG_SLP_DO_MASK_SHIFT(reg) (((reg) & IO_PAD95_PIOCFG_SLP_DO_MASK) >> IO_PAD95_PIOCFG_SLP_DO_SHIFT)
#define  IO_PAD95_PIOCFG_SLP_DO_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD95_PIOCFG_SLP_DO_MASK) | (((uint32_t)val) << IO_PAD95_PIOCFG_SLP_DO_SHIFT))

#define  IO_PAD95_PIOCFG_SLP_DIR_MASK 0x80
#define  IO_PAD95_PIOCFG_SLP_DIR_SHIFT 7
#define  IO_PAD95_PIOCFG_SLP_DIR_MASK_SHIFT(reg) (((reg) & IO_PAD95_PIOCFG_SLP_DIR_MASK) >> IO_PAD95_PIOCFG_SLP_DIR_SHIFT)
#define  IO_PAD95_PIOCFG_SLP_DIR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD95_PIOCFG_SLP_DIR_MASK) | (((uint32_t)val) << IO_PAD95_PIOCFG_SLP_DIR_SHIFT))

#define  IO_PAD95_PIOCFG_EDGE_EN_N_MASK 0x40
#define  IO_PAD95_PIOCFG_EDGE_EN_N_SHIFT 6
#define  IO_PAD95_PIOCFG_EDGE_EN_N_MASK_SHIFT(reg) (((reg) & IO_PAD95_PIOCFG_EDGE_EN_N_MASK) >> IO_PAD95_PIOCFG_EDGE_EN_N_SHIFT)
#define  IO_PAD95_PIOCFG_EDGE_EN_N_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD95_PIOCFG_EDGE_EN_N_MASK) | (((uint32_t)val) << IO_PAD95_PIOCFG_EDGE_EN_N_SHIFT))

#define  IO_PAD95_PIOCFG_EDGE_FALL_EN_MASK 0x20
#define  IO_PAD95_PIOCFG_EDGE_FALL_EN_SHIFT 5
#define  IO_PAD95_PIOCFG_EDGE_FALL_EN_MASK_SHIFT(reg) (((reg) & IO_PAD95_PIOCFG_EDGE_FALL_EN_MASK) >> IO_PAD95_PIOCFG_EDGE_FALL_EN_SHIFT)
#define  IO_PAD95_PIOCFG_EDGE_FALL_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD95_PIOCFG_EDGE_FALL_EN_MASK) | (((uint32_t)val) << IO_PAD95_PIOCFG_EDGE_FALL_EN_SHIFT))

#define  IO_PAD95_PIOCFG_EDGE_RISE_EN_MASK 0x10
#define  IO_PAD95_PIOCFG_EDGE_RISE_EN_SHIFT 4
#define  IO_PAD95_PIOCFG_EDGE_RISE_EN_MASK_SHIFT(reg) (((reg) & IO_PAD95_PIOCFG_EDGE_RISE_EN_MASK) >> IO_PAD95_PIOCFG_EDGE_RISE_EN_SHIFT)
#define  IO_PAD95_PIOCFG_EDGE_RISE_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD95_PIOCFG_EDGE_RISE_EN_MASK) | (((uint32_t)val) << IO_PAD95_PIOCFG_EDGE_RISE_EN_SHIFT))

#define  IO_PAD95_PIOCFG_SLP_SEL_MASK 0x8
#define  IO_PAD95_PIOCFG_SLP_SEL_SHIFT 3
#define  IO_PAD95_PIOCFG_SLP_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD95_PIOCFG_SLP_SEL_MASK) >> IO_PAD95_PIOCFG_SLP_SEL_SHIFT)
#define  IO_PAD95_PIOCFG_SLP_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD95_PIOCFG_SLP_SEL_MASK) | (((uint32_t)val) << IO_PAD95_PIOCFG_SLP_SEL_SHIFT))

#define  IO_PAD95_PIOCFG_FUNC_SEL_MASK 0x7
#define  IO_PAD95_PIOCFG_FUNC_SEL_SHIFT 0
#define  IO_PAD95_PIOCFG_FUNC_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD95_PIOCFG_FUNC_SEL_MASK) >> IO_PAD95_PIOCFG_FUNC_SEL_SHIFT)
#define  IO_PAD95_PIOCFG_FUNC_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD95_PIOCFG_FUNC_SEL_MASK) | (((uint32_t)val) << IO_PAD95_PIOCFG_FUNC_SEL_SHIFT))

//====================================================================
//
//Register File: IO_PAD96 Configuration Registers (IO_PAD96)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

//====================================================================
//Register: IO_PAD96 Configuration Register (PIOCFG)
/** \brief "PHI_PADXDC_IOB" Pad*/
//====================================================================

#define  IO_PAD96_PIOCFG_RESERVED1_MASK 0xfc000000
#define  IO_PAD96_PIOCFG_RESERVED1_SHIFT 26
#define  IO_PAD96_PIOCFG_RESERVED1_MASK_SHIFT(reg) (((reg) & IO_PAD96_PIOCFG_RESERVED1_MASK) >> IO_PAD96_PIOCFG_RESERVED1_SHIFT)
#define  IO_PAD96_PIOCFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD96_PIOCFG_RESERVED1_MASK) | (((uint32_t)val) << IO_PAD96_PIOCFG_RESERVED1_SHIFT))

#define  IO_PAD96_PIOCFG_PD_MASK 0x2000000
#define  IO_PAD96_PIOCFG_PD_SHIFT 25
#define  IO_PAD96_PIOCFG_PD_MASK_SHIFT(reg) (((reg) & IO_PAD96_PIOCFG_PD_MASK) >> IO_PAD96_PIOCFG_PD_SHIFT)
#define  IO_PAD96_PIOCFG_PD_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD96_PIOCFG_PD_MASK) | (((uint32_t)val) << IO_PAD96_PIOCFG_PD_SHIFT))

#define  IO_PAD96_PIOCFG_ODT_EN_MASK 0x1000000
#define  IO_PAD96_PIOCFG_ODT_EN_SHIFT 24
#define  IO_PAD96_PIOCFG_ODT_EN_MASK_SHIFT(reg) (((reg) & IO_PAD96_PIOCFG_ODT_EN_MASK) >> IO_PAD96_PIOCFG_ODT_EN_SHIFT)
#define  IO_PAD96_PIOCFG_ODT_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD96_PIOCFG_ODT_EN_MASK) | (((uint32_t)val) << IO_PAD96_PIOCFG_ODT_EN_SHIFT))

#define  IO_PAD96_PIOCFG_LED_EN_MASK 0x800000
#define  IO_PAD96_PIOCFG_LED_EN_SHIFT 23
#define  IO_PAD96_PIOCFG_LED_EN_MASK_SHIFT(reg) (((reg) & IO_PAD96_PIOCFG_LED_EN_MASK) >> IO_PAD96_PIOCFG_LED_EN_SHIFT)
#define  IO_PAD96_PIOCFG_LED_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD96_PIOCFG_LED_EN_MASK) | (((uint32_t)val) << IO_PAD96_PIOCFG_LED_EN_SHIFT))

#define  IO_PAD96_PIOCFG_I2C_SEL_MASK 0x600000
#define  IO_PAD96_PIOCFG_I2C_SEL_SHIFT 21
#define  IO_PAD96_PIOCFG_I2C_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD96_PIOCFG_I2C_SEL_MASK) >> IO_PAD96_PIOCFG_I2C_SEL_SHIFT)
#define  IO_PAD96_PIOCFG_I2C_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD96_PIOCFG_I2C_SEL_MASK) | (((uint32_t)val) << IO_PAD96_PIOCFG_I2C_SEL_SHIFT))

#define  IO_PAD96_PIOCFG_DGTBSEL_MASK 0x1e0000
#define  IO_PAD96_PIOCFG_DGTBSEL_SHIFT 17
#define  IO_PAD96_PIOCFG_DGTBSEL_MASK_SHIFT(reg) (((reg) & IO_PAD96_PIOCFG_DGTBSEL_MASK) >> IO_PAD96_PIOCFG_DGTBSEL_SHIFT)
#define  IO_PAD96_PIOCFG_DGTBSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD96_PIOCFG_DGTBSEL_MASK) | (((uint32_t)val) << IO_PAD96_PIOCFG_DGTBSEL_SHIFT))

#define  IO_PAD96_PIOCFG_RAWSEL_MASK 0x10000
#define  IO_PAD96_PIOCFG_RAWSEL_SHIFT 16
#define  IO_PAD96_PIOCFG_RAWSEL_MASK_SHIFT(reg) (((reg) & IO_PAD96_PIOCFG_RAWSEL_MASK) >> IO_PAD96_PIOCFG_RAWSEL_SHIFT)
#define  IO_PAD96_PIOCFG_RAWSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD96_PIOCFG_RAWSEL_MASK) | (((uint32_t)val) << IO_PAD96_PIOCFG_RAWSEL_SHIFT))

#define  IO_PAD96_PIOCFG_PULL_SEL_MASK 0x8000
#define  IO_PAD96_PIOCFG_PULL_SEL_SHIFT 15
#define  IO_PAD96_PIOCFG_PULL_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD96_PIOCFG_PULL_SEL_MASK) >> IO_PAD96_PIOCFG_PULL_SEL_SHIFT)
#define  IO_PAD96_PIOCFG_PULL_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD96_PIOCFG_PULL_SEL_MASK) | (((uint32_t)val) << IO_PAD96_PIOCFG_PULL_SEL_SHIFT))

#define  IO_PAD96_PIOCFG_PUEN_MASK 0x4000
#define  IO_PAD96_PIOCFG_PUEN_SHIFT 14
#define  IO_PAD96_PIOCFG_PUEN_MASK_SHIFT(reg) (((reg) & IO_PAD96_PIOCFG_PUEN_MASK) >> IO_PAD96_PIOCFG_PUEN_SHIFT)
#define  IO_PAD96_PIOCFG_PUEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD96_PIOCFG_PUEN_MASK) | (((uint32_t)val) << IO_PAD96_PIOCFG_PUEN_SHIFT))

#define  IO_PAD96_PIOCFG_PDEN_MASK 0x2000
#define  IO_PAD96_PIOCFG_PDEN_SHIFT 13
#define  IO_PAD96_PIOCFG_PDEN_MASK_SHIFT(reg) (((reg) & IO_PAD96_PIOCFG_PDEN_MASK) >> IO_PAD96_PIOCFG_PDEN_SHIFT)
#define  IO_PAD96_PIOCFG_PDEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD96_PIOCFG_PDEN_MASK) | (((uint32_t)val) << IO_PAD96_PIOCFG_PDEN_SHIFT))

#define  IO_PAD96_PIOCFG_SR_MASK 0x1800
#define  IO_PAD96_PIOCFG_SR_SHIFT 11
#define  IO_PAD96_PIOCFG_SR_MASK_SHIFT(reg) (((reg) & IO_PAD96_PIOCFG_SR_MASK) >> IO_PAD96_PIOCFG_SR_SHIFT)
#define  IO_PAD96_PIOCFG_SR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD96_PIOCFG_SR_MASK) | (((uint32_t)val) << IO_PAD96_PIOCFG_SR_SHIFT))

#define  IO_PAD96_PIOCFG_SLP_DI_MASK 0x400
#define  IO_PAD96_PIOCFG_SLP_DI_SHIFT 10
#define  IO_PAD96_PIOCFG_SLP_DI_MASK_SHIFT(reg) (((reg) & IO_PAD96_PIOCFG_SLP_DI_MASK) >> IO_PAD96_PIOCFG_SLP_DI_SHIFT)
#define  IO_PAD96_PIOCFG_SLP_DI_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD96_PIOCFG_SLP_DI_MASK) | (((uint32_t)val) << IO_PAD96_PIOCFG_SLP_DI_SHIFT))

#define  IO_PAD96_PIOCFG_SLP_CNTRL_MASK 0x200
#define  IO_PAD96_PIOCFG_SLP_CNTRL_SHIFT 9
#define  IO_PAD96_PIOCFG_SLP_CNTRL_MASK_SHIFT(reg) (((reg) & IO_PAD96_PIOCFG_SLP_CNTRL_MASK) >> IO_PAD96_PIOCFG_SLP_CNTRL_SHIFT)
#define  IO_PAD96_PIOCFG_SLP_CNTRL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD96_PIOCFG_SLP_CNTRL_MASK) | (((uint32_t)val) << IO_PAD96_PIOCFG_SLP_CNTRL_SHIFT))

#define  IO_PAD96_PIOCFG_SLP_DO_MASK 0x100
#define  IO_PAD96_PIOCFG_SLP_DO_SHIFT 8
#define  IO_PAD96_PIOCFG_SLP_DO_MASK_SHIFT(reg) (((reg) & IO_PAD96_PIOCFG_SLP_DO_MASK) >> IO_PAD96_PIOCFG_SLP_DO_SHIFT)
#define  IO_PAD96_PIOCFG_SLP_DO_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD96_PIOCFG_SLP_DO_MASK) | (((uint32_t)val) << IO_PAD96_PIOCFG_SLP_DO_SHIFT))

#define  IO_PAD96_PIOCFG_SLP_DIR_MASK 0x80
#define  IO_PAD96_PIOCFG_SLP_DIR_SHIFT 7
#define  IO_PAD96_PIOCFG_SLP_DIR_MASK_SHIFT(reg) (((reg) & IO_PAD96_PIOCFG_SLP_DIR_MASK) >> IO_PAD96_PIOCFG_SLP_DIR_SHIFT)
#define  IO_PAD96_PIOCFG_SLP_DIR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD96_PIOCFG_SLP_DIR_MASK) | (((uint32_t)val) << IO_PAD96_PIOCFG_SLP_DIR_SHIFT))

#define  IO_PAD96_PIOCFG_EDGE_EN_N_MASK 0x40
#define  IO_PAD96_PIOCFG_EDGE_EN_N_SHIFT 6
#define  IO_PAD96_PIOCFG_EDGE_EN_N_MASK_SHIFT(reg) (((reg) & IO_PAD96_PIOCFG_EDGE_EN_N_MASK) >> IO_PAD96_PIOCFG_EDGE_EN_N_SHIFT)
#define  IO_PAD96_PIOCFG_EDGE_EN_N_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD96_PIOCFG_EDGE_EN_N_MASK) | (((uint32_t)val) << IO_PAD96_PIOCFG_EDGE_EN_N_SHIFT))

#define  IO_PAD96_PIOCFG_EDGE_FALL_EN_MASK 0x20
#define  IO_PAD96_PIOCFG_EDGE_FALL_EN_SHIFT 5
#define  IO_PAD96_PIOCFG_EDGE_FALL_EN_MASK_SHIFT(reg) (((reg) & IO_PAD96_PIOCFG_EDGE_FALL_EN_MASK) >> IO_PAD96_PIOCFG_EDGE_FALL_EN_SHIFT)
#define  IO_PAD96_PIOCFG_EDGE_FALL_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD96_PIOCFG_EDGE_FALL_EN_MASK) | (((uint32_t)val) << IO_PAD96_PIOCFG_EDGE_FALL_EN_SHIFT))

#define  IO_PAD96_PIOCFG_EDGE_RISE_EN_MASK 0x10
#define  IO_PAD96_PIOCFG_EDGE_RISE_EN_SHIFT 4
#define  IO_PAD96_PIOCFG_EDGE_RISE_EN_MASK_SHIFT(reg) (((reg) & IO_PAD96_PIOCFG_EDGE_RISE_EN_MASK) >> IO_PAD96_PIOCFG_EDGE_RISE_EN_SHIFT)
#define  IO_PAD96_PIOCFG_EDGE_RISE_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD96_PIOCFG_EDGE_RISE_EN_MASK) | (((uint32_t)val) << IO_PAD96_PIOCFG_EDGE_RISE_EN_SHIFT))

#define  IO_PAD96_PIOCFG_SLP_SEL_MASK 0x8
#define  IO_PAD96_PIOCFG_SLP_SEL_SHIFT 3
#define  IO_PAD96_PIOCFG_SLP_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD96_PIOCFG_SLP_SEL_MASK) >> IO_PAD96_PIOCFG_SLP_SEL_SHIFT)
#define  IO_PAD96_PIOCFG_SLP_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD96_PIOCFG_SLP_SEL_MASK) | (((uint32_t)val) << IO_PAD96_PIOCFG_SLP_SEL_SHIFT))

#define  IO_PAD96_PIOCFG_FUNC_SEL_MASK 0x7
#define  IO_PAD96_PIOCFG_FUNC_SEL_SHIFT 0
#define  IO_PAD96_PIOCFG_FUNC_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD96_PIOCFG_FUNC_SEL_MASK) >> IO_PAD96_PIOCFG_FUNC_SEL_SHIFT)
#define  IO_PAD96_PIOCFG_FUNC_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD96_PIOCFG_FUNC_SEL_MASK) | (((uint32_t)val) << IO_PAD96_PIOCFG_FUNC_SEL_SHIFT))

//====================================================================
//
//Register File: IO_PAD97 Configuration Registers (IO_PAD97)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

//====================================================================
//Register: IO_PAD97 Configuration Register (PIOCFG)
/** \brief "PHI_PADXDC_IOB" Pad*/
//====================================================================

#define  IO_PAD97_PIOCFG_RESERVED1_MASK 0xfc000000
#define  IO_PAD97_PIOCFG_RESERVED1_SHIFT 26
#define  IO_PAD97_PIOCFG_RESERVED1_MASK_SHIFT(reg) (((reg) & IO_PAD97_PIOCFG_RESERVED1_MASK) >> IO_PAD97_PIOCFG_RESERVED1_SHIFT)
#define  IO_PAD97_PIOCFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD97_PIOCFG_RESERVED1_MASK) | (((uint32_t)val) << IO_PAD97_PIOCFG_RESERVED1_SHIFT))

#define  IO_PAD97_PIOCFG_PD_MASK 0x2000000
#define  IO_PAD97_PIOCFG_PD_SHIFT 25
#define  IO_PAD97_PIOCFG_PD_MASK_SHIFT(reg) (((reg) & IO_PAD97_PIOCFG_PD_MASK) >> IO_PAD97_PIOCFG_PD_SHIFT)
#define  IO_PAD97_PIOCFG_PD_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD97_PIOCFG_PD_MASK) | (((uint32_t)val) << IO_PAD97_PIOCFG_PD_SHIFT))

#define  IO_PAD97_PIOCFG_ODT_EN_MASK 0x1000000
#define  IO_PAD97_PIOCFG_ODT_EN_SHIFT 24
#define  IO_PAD97_PIOCFG_ODT_EN_MASK_SHIFT(reg) (((reg) & IO_PAD97_PIOCFG_ODT_EN_MASK) >> IO_PAD97_PIOCFG_ODT_EN_SHIFT)
#define  IO_PAD97_PIOCFG_ODT_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD97_PIOCFG_ODT_EN_MASK) | (((uint32_t)val) << IO_PAD97_PIOCFG_ODT_EN_SHIFT))

#define  IO_PAD97_PIOCFG_LED_EN_MASK 0x800000
#define  IO_PAD97_PIOCFG_LED_EN_SHIFT 23
#define  IO_PAD97_PIOCFG_LED_EN_MASK_SHIFT(reg) (((reg) & IO_PAD97_PIOCFG_LED_EN_MASK) >> IO_PAD97_PIOCFG_LED_EN_SHIFT)
#define  IO_PAD97_PIOCFG_LED_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD97_PIOCFG_LED_EN_MASK) | (((uint32_t)val) << IO_PAD97_PIOCFG_LED_EN_SHIFT))

#define  IO_PAD97_PIOCFG_I2C_SEL_MASK 0x600000
#define  IO_PAD97_PIOCFG_I2C_SEL_SHIFT 21
#define  IO_PAD97_PIOCFG_I2C_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD97_PIOCFG_I2C_SEL_MASK) >> IO_PAD97_PIOCFG_I2C_SEL_SHIFT)
#define  IO_PAD97_PIOCFG_I2C_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD97_PIOCFG_I2C_SEL_MASK) | (((uint32_t)val) << IO_PAD97_PIOCFG_I2C_SEL_SHIFT))

#define  IO_PAD97_PIOCFG_DGTBSEL_MASK 0x1e0000
#define  IO_PAD97_PIOCFG_DGTBSEL_SHIFT 17
#define  IO_PAD97_PIOCFG_DGTBSEL_MASK_SHIFT(reg) (((reg) & IO_PAD97_PIOCFG_DGTBSEL_MASK) >> IO_PAD97_PIOCFG_DGTBSEL_SHIFT)
#define  IO_PAD97_PIOCFG_DGTBSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD97_PIOCFG_DGTBSEL_MASK) | (((uint32_t)val) << IO_PAD97_PIOCFG_DGTBSEL_SHIFT))

#define  IO_PAD97_PIOCFG_RAWSEL_MASK 0x10000
#define  IO_PAD97_PIOCFG_RAWSEL_SHIFT 16
#define  IO_PAD97_PIOCFG_RAWSEL_MASK_SHIFT(reg) (((reg) & IO_PAD97_PIOCFG_RAWSEL_MASK) >> IO_PAD97_PIOCFG_RAWSEL_SHIFT)
#define  IO_PAD97_PIOCFG_RAWSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD97_PIOCFG_RAWSEL_MASK) | (((uint32_t)val) << IO_PAD97_PIOCFG_RAWSEL_SHIFT))

#define  IO_PAD97_PIOCFG_PULL_SEL_MASK 0x8000
#define  IO_PAD97_PIOCFG_PULL_SEL_SHIFT 15
#define  IO_PAD97_PIOCFG_PULL_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD97_PIOCFG_PULL_SEL_MASK) >> IO_PAD97_PIOCFG_PULL_SEL_SHIFT)
#define  IO_PAD97_PIOCFG_PULL_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD97_PIOCFG_PULL_SEL_MASK) | (((uint32_t)val) << IO_PAD97_PIOCFG_PULL_SEL_SHIFT))

#define  IO_PAD97_PIOCFG_PUEN_MASK 0x4000
#define  IO_PAD97_PIOCFG_PUEN_SHIFT 14
#define  IO_PAD97_PIOCFG_PUEN_MASK_SHIFT(reg) (((reg) & IO_PAD97_PIOCFG_PUEN_MASK) >> IO_PAD97_PIOCFG_PUEN_SHIFT)
#define  IO_PAD97_PIOCFG_PUEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD97_PIOCFG_PUEN_MASK) | (((uint32_t)val) << IO_PAD97_PIOCFG_PUEN_SHIFT))

#define  IO_PAD97_PIOCFG_PDEN_MASK 0x2000
#define  IO_PAD97_PIOCFG_PDEN_SHIFT 13
#define  IO_PAD97_PIOCFG_PDEN_MASK_SHIFT(reg) (((reg) & IO_PAD97_PIOCFG_PDEN_MASK) >> IO_PAD97_PIOCFG_PDEN_SHIFT)
#define  IO_PAD97_PIOCFG_PDEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD97_PIOCFG_PDEN_MASK) | (((uint32_t)val) << IO_PAD97_PIOCFG_PDEN_SHIFT))

#define  IO_PAD97_PIOCFG_SR_MASK 0x1800
#define  IO_PAD97_PIOCFG_SR_SHIFT 11
#define  IO_PAD97_PIOCFG_SR_MASK_SHIFT(reg) (((reg) & IO_PAD97_PIOCFG_SR_MASK) >> IO_PAD97_PIOCFG_SR_SHIFT)
#define  IO_PAD97_PIOCFG_SR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD97_PIOCFG_SR_MASK) | (((uint32_t)val) << IO_PAD97_PIOCFG_SR_SHIFT))

#define  IO_PAD97_PIOCFG_SLP_DI_MASK 0x400
#define  IO_PAD97_PIOCFG_SLP_DI_SHIFT 10
#define  IO_PAD97_PIOCFG_SLP_DI_MASK_SHIFT(reg) (((reg) & IO_PAD97_PIOCFG_SLP_DI_MASK) >> IO_PAD97_PIOCFG_SLP_DI_SHIFT)
#define  IO_PAD97_PIOCFG_SLP_DI_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD97_PIOCFG_SLP_DI_MASK) | (((uint32_t)val) << IO_PAD97_PIOCFG_SLP_DI_SHIFT))

#define  IO_PAD97_PIOCFG_SLP_CNTRL_MASK 0x200
#define  IO_PAD97_PIOCFG_SLP_CNTRL_SHIFT 9
#define  IO_PAD97_PIOCFG_SLP_CNTRL_MASK_SHIFT(reg) (((reg) & IO_PAD97_PIOCFG_SLP_CNTRL_MASK) >> IO_PAD97_PIOCFG_SLP_CNTRL_SHIFT)
#define  IO_PAD97_PIOCFG_SLP_CNTRL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD97_PIOCFG_SLP_CNTRL_MASK) | (((uint32_t)val) << IO_PAD97_PIOCFG_SLP_CNTRL_SHIFT))

#define  IO_PAD97_PIOCFG_SLP_DO_MASK 0x100
#define  IO_PAD97_PIOCFG_SLP_DO_SHIFT 8
#define  IO_PAD97_PIOCFG_SLP_DO_MASK_SHIFT(reg) (((reg) & IO_PAD97_PIOCFG_SLP_DO_MASK) >> IO_PAD97_PIOCFG_SLP_DO_SHIFT)
#define  IO_PAD97_PIOCFG_SLP_DO_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD97_PIOCFG_SLP_DO_MASK) | (((uint32_t)val) << IO_PAD97_PIOCFG_SLP_DO_SHIFT))

#define  IO_PAD97_PIOCFG_SLP_DIR_MASK 0x80
#define  IO_PAD97_PIOCFG_SLP_DIR_SHIFT 7
#define  IO_PAD97_PIOCFG_SLP_DIR_MASK_SHIFT(reg) (((reg) & IO_PAD97_PIOCFG_SLP_DIR_MASK) >> IO_PAD97_PIOCFG_SLP_DIR_SHIFT)
#define  IO_PAD97_PIOCFG_SLP_DIR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD97_PIOCFG_SLP_DIR_MASK) | (((uint32_t)val) << IO_PAD97_PIOCFG_SLP_DIR_SHIFT))

#define  IO_PAD97_PIOCFG_EDGE_EN_N_MASK 0x40
#define  IO_PAD97_PIOCFG_EDGE_EN_N_SHIFT 6
#define  IO_PAD97_PIOCFG_EDGE_EN_N_MASK_SHIFT(reg) (((reg) & IO_PAD97_PIOCFG_EDGE_EN_N_MASK) >> IO_PAD97_PIOCFG_EDGE_EN_N_SHIFT)
#define  IO_PAD97_PIOCFG_EDGE_EN_N_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD97_PIOCFG_EDGE_EN_N_MASK) | (((uint32_t)val) << IO_PAD97_PIOCFG_EDGE_EN_N_SHIFT))

#define  IO_PAD97_PIOCFG_EDGE_FALL_EN_MASK 0x20
#define  IO_PAD97_PIOCFG_EDGE_FALL_EN_SHIFT 5
#define  IO_PAD97_PIOCFG_EDGE_FALL_EN_MASK_SHIFT(reg) (((reg) & IO_PAD97_PIOCFG_EDGE_FALL_EN_MASK) >> IO_PAD97_PIOCFG_EDGE_FALL_EN_SHIFT)
#define  IO_PAD97_PIOCFG_EDGE_FALL_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD97_PIOCFG_EDGE_FALL_EN_MASK) | (((uint32_t)val) << IO_PAD97_PIOCFG_EDGE_FALL_EN_SHIFT))

#define  IO_PAD97_PIOCFG_EDGE_RISE_EN_MASK 0x10
#define  IO_PAD97_PIOCFG_EDGE_RISE_EN_SHIFT 4
#define  IO_PAD97_PIOCFG_EDGE_RISE_EN_MASK_SHIFT(reg) (((reg) & IO_PAD97_PIOCFG_EDGE_RISE_EN_MASK) >> IO_PAD97_PIOCFG_EDGE_RISE_EN_SHIFT)
#define  IO_PAD97_PIOCFG_EDGE_RISE_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD97_PIOCFG_EDGE_RISE_EN_MASK) | (((uint32_t)val) << IO_PAD97_PIOCFG_EDGE_RISE_EN_SHIFT))

#define  IO_PAD97_PIOCFG_SLP_SEL_MASK 0x8
#define  IO_PAD97_PIOCFG_SLP_SEL_SHIFT 3
#define  IO_PAD97_PIOCFG_SLP_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD97_PIOCFG_SLP_SEL_MASK) >> IO_PAD97_PIOCFG_SLP_SEL_SHIFT)
#define  IO_PAD97_PIOCFG_SLP_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD97_PIOCFG_SLP_SEL_MASK) | (((uint32_t)val) << IO_PAD97_PIOCFG_SLP_SEL_SHIFT))

#define  IO_PAD97_PIOCFG_FUNC_SEL_MASK 0x7
#define  IO_PAD97_PIOCFG_FUNC_SEL_SHIFT 0
#define  IO_PAD97_PIOCFG_FUNC_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD97_PIOCFG_FUNC_SEL_MASK) >> IO_PAD97_PIOCFG_FUNC_SEL_SHIFT)
#define  IO_PAD97_PIOCFG_FUNC_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD97_PIOCFG_FUNC_SEL_MASK) | (((uint32_t)val) << IO_PAD97_PIOCFG_FUNC_SEL_SHIFT))

//====================================================================
//
//Register File: IO_PAD98 Configuration Registers (IO_PAD98)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

//====================================================================
//Register: IO_PAD98 Configuration Register (PIOCFG)
/** \brief "PHI_PADXDC_IOB" Pad*/
//====================================================================

#define  IO_PAD98_PIOCFG_RESERVED1_MASK 0xfc000000
#define  IO_PAD98_PIOCFG_RESERVED1_SHIFT 26
#define  IO_PAD98_PIOCFG_RESERVED1_MASK_SHIFT(reg) (((reg) & IO_PAD98_PIOCFG_RESERVED1_MASK) >> IO_PAD98_PIOCFG_RESERVED1_SHIFT)
#define  IO_PAD98_PIOCFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD98_PIOCFG_RESERVED1_MASK) | (((uint32_t)val) << IO_PAD98_PIOCFG_RESERVED1_SHIFT))

#define  IO_PAD98_PIOCFG_PD_MASK 0x2000000
#define  IO_PAD98_PIOCFG_PD_SHIFT 25
#define  IO_PAD98_PIOCFG_PD_MASK_SHIFT(reg) (((reg) & IO_PAD98_PIOCFG_PD_MASK) >> IO_PAD98_PIOCFG_PD_SHIFT)
#define  IO_PAD98_PIOCFG_PD_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD98_PIOCFG_PD_MASK) | (((uint32_t)val) << IO_PAD98_PIOCFG_PD_SHIFT))

#define  IO_PAD98_PIOCFG_ODT_EN_MASK 0x1000000
#define  IO_PAD98_PIOCFG_ODT_EN_SHIFT 24
#define  IO_PAD98_PIOCFG_ODT_EN_MASK_SHIFT(reg) (((reg) & IO_PAD98_PIOCFG_ODT_EN_MASK) >> IO_PAD98_PIOCFG_ODT_EN_SHIFT)
#define  IO_PAD98_PIOCFG_ODT_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD98_PIOCFG_ODT_EN_MASK) | (((uint32_t)val) << IO_PAD98_PIOCFG_ODT_EN_SHIFT))

#define  IO_PAD98_PIOCFG_LED_EN_MASK 0x800000
#define  IO_PAD98_PIOCFG_LED_EN_SHIFT 23
#define  IO_PAD98_PIOCFG_LED_EN_MASK_SHIFT(reg) (((reg) & IO_PAD98_PIOCFG_LED_EN_MASK) >> IO_PAD98_PIOCFG_LED_EN_SHIFT)
#define  IO_PAD98_PIOCFG_LED_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD98_PIOCFG_LED_EN_MASK) | (((uint32_t)val) << IO_PAD98_PIOCFG_LED_EN_SHIFT))

#define  IO_PAD98_PIOCFG_I2C_SEL_MASK 0x600000
#define  IO_PAD98_PIOCFG_I2C_SEL_SHIFT 21
#define  IO_PAD98_PIOCFG_I2C_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD98_PIOCFG_I2C_SEL_MASK) >> IO_PAD98_PIOCFG_I2C_SEL_SHIFT)
#define  IO_PAD98_PIOCFG_I2C_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD98_PIOCFG_I2C_SEL_MASK) | (((uint32_t)val) << IO_PAD98_PIOCFG_I2C_SEL_SHIFT))

#define  IO_PAD98_PIOCFG_DGTBSEL_MASK 0x1e0000
#define  IO_PAD98_PIOCFG_DGTBSEL_SHIFT 17
#define  IO_PAD98_PIOCFG_DGTBSEL_MASK_SHIFT(reg) (((reg) & IO_PAD98_PIOCFG_DGTBSEL_MASK) >> IO_PAD98_PIOCFG_DGTBSEL_SHIFT)
#define  IO_PAD98_PIOCFG_DGTBSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD98_PIOCFG_DGTBSEL_MASK) | (((uint32_t)val) << IO_PAD98_PIOCFG_DGTBSEL_SHIFT))

#define  IO_PAD98_PIOCFG_RAWSEL_MASK 0x10000
#define  IO_PAD98_PIOCFG_RAWSEL_SHIFT 16
#define  IO_PAD98_PIOCFG_RAWSEL_MASK_SHIFT(reg) (((reg) & IO_PAD98_PIOCFG_RAWSEL_MASK) >> IO_PAD98_PIOCFG_RAWSEL_SHIFT)
#define  IO_PAD98_PIOCFG_RAWSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD98_PIOCFG_RAWSEL_MASK) | (((uint32_t)val) << IO_PAD98_PIOCFG_RAWSEL_SHIFT))

#define  IO_PAD98_PIOCFG_PULL_SEL_MASK 0x8000
#define  IO_PAD98_PIOCFG_PULL_SEL_SHIFT 15
#define  IO_PAD98_PIOCFG_PULL_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD98_PIOCFG_PULL_SEL_MASK) >> IO_PAD98_PIOCFG_PULL_SEL_SHIFT)
#define  IO_PAD98_PIOCFG_PULL_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD98_PIOCFG_PULL_SEL_MASK) | (((uint32_t)val) << IO_PAD98_PIOCFG_PULL_SEL_SHIFT))

#define  IO_PAD98_PIOCFG_PUEN_MASK 0x4000
#define  IO_PAD98_PIOCFG_PUEN_SHIFT 14
#define  IO_PAD98_PIOCFG_PUEN_MASK_SHIFT(reg) (((reg) & IO_PAD98_PIOCFG_PUEN_MASK) >> IO_PAD98_PIOCFG_PUEN_SHIFT)
#define  IO_PAD98_PIOCFG_PUEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD98_PIOCFG_PUEN_MASK) | (((uint32_t)val) << IO_PAD98_PIOCFG_PUEN_SHIFT))

#define  IO_PAD98_PIOCFG_PDEN_MASK 0x2000
#define  IO_PAD98_PIOCFG_PDEN_SHIFT 13
#define  IO_PAD98_PIOCFG_PDEN_MASK_SHIFT(reg) (((reg) & IO_PAD98_PIOCFG_PDEN_MASK) >> IO_PAD98_PIOCFG_PDEN_SHIFT)
#define  IO_PAD98_PIOCFG_PDEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD98_PIOCFG_PDEN_MASK) | (((uint32_t)val) << IO_PAD98_PIOCFG_PDEN_SHIFT))

#define  IO_PAD98_PIOCFG_SR_MASK 0x1800
#define  IO_PAD98_PIOCFG_SR_SHIFT 11
#define  IO_PAD98_PIOCFG_SR_MASK_SHIFT(reg) (((reg) & IO_PAD98_PIOCFG_SR_MASK) >> IO_PAD98_PIOCFG_SR_SHIFT)
#define  IO_PAD98_PIOCFG_SR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD98_PIOCFG_SR_MASK) | (((uint32_t)val) << IO_PAD98_PIOCFG_SR_SHIFT))

#define  IO_PAD98_PIOCFG_SLP_DI_MASK 0x400
#define  IO_PAD98_PIOCFG_SLP_DI_SHIFT 10
#define  IO_PAD98_PIOCFG_SLP_DI_MASK_SHIFT(reg) (((reg) & IO_PAD98_PIOCFG_SLP_DI_MASK) >> IO_PAD98_PIOCFG_SLP_DI_SHIFT)
#define  IO_PAD98_PIOCFG_SLP_DI_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD98_PIOCFG_SLP_DI_MASK) | (((uint32_t)val) << IO_PAD98_PIOCFG_SLP_DI_SHIFT))

#define  IO_PAD98_PIOCFG_SLP_CNTRL_MASK 0x200
#define  IO_PAD98_PIOCFG_SLP_CNTRL_SHIFT 9
#define  IO_PAD98_PIOCFG_SLP_CNTRL_MASK_SHIFT(reg) (((reg) & IO_PAD98_PIOCFG_SLP_CNTRL_MASK) >> IO_PAD98_PIOCFG_SLP_CNTRL_SHIFT)
#define  IO_PAD98_PIOCFG_SLP_CNTRL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD98_PIOCFG_SLP_CNTRL_MASK) | (((uint32_t)val) << IO_PAD98_PIOCFG_SLP_CNTRL_SHIFT))

#define  IO_PAD98_PIOCFG_SLP_DO_MASK 0x100
#define  IO_PAD98_PIOCFG_SLP_DO_SHIFT 8
#define  IO_PAD98_PIOCFG_SLP_DO_MASK_SHIFT(reg) (((reg) & IO_PAD98_PIOCFG_SLP_DO_MASK) >> IO_PAD98_PIOCFG_SLP_DO_SHIFT)
#define  IO_PAD98_PIOCFG_SLP_DO_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD98_PIOCFG_SLP_DO_MASK) | (((uint32_t)val) << IO_PAD98_PIOCFG_SLP_DO_SHIFT))

#define  IO_PAD98_PIOCFG_SLP_DIR_MASK 0x80
#define  IO_PAD98_PIOCFG_SLP_DIR_SHIFT 7
#define  IO_PAD98_PIOCFG_SLP_DIR_MASK_SHIFT(reg) (((reg) & IO_PAD98_PIOCFG_SLP_DIR_MASK) >> IO_PAD98_PIOCFG_SLP_DIR_SHIFT)
#define  IO_PAD98_PIOCFG_SLP_DIR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD98_PIOCFG_SLP_DIR_MASK) | (((uint32_t)val) << IO_PAD98_PIOCFG_SLP_DIR_SHIFT))

#define  IO_PAD98_PIOCFG_EDGE_EN_N_MASK 0x40
#define  IO_PAD98_PIOCFG_EDGE_EN_N_SHIFT 6
#define  IO_PAD98_PIOCFG_EDGE_EN_N_MASK_SHIFT(reg) (((reg) & IO_PAD98_PIOCFG_EDGE_EN_N_MASK) >> IO_PAD98_PIOCFG_EDGE_EN_N_SHIFT)
#define  IO_PAD98_PIOCFG_EDGE_EN_N_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD98_PIOCFG_EDGE_EN_N_MASK) | (((uint32_t)val) << IO_PAD98_PIOCFG_EDGE_EN_N_SHIFT))

#define  IO_PAD98_PIOCFG_EDGE_FALL_EN_MASK 0x20
#define  IO_PAD98_PIOCFG_EDGE_FALL_EN_SHIFT 5
#define  IO_PAD98_PIOCFG_EDGE_FALL_EN_MASK_SHIFT(reg) (((reg) & IO_PAD98_PIOCFG_EDGE_FALL_EN_MASK) >> IO_PAD98_PIOCFG_EDGE_FALL_EN_SHIFT)
#define  IO_PAD98_PIOCFG_EDGE_FALL_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD98_PIOCFG_EDGE_FALL_EN_MASK) | (((uint32_t)val) << IO_PAD98_PIOCFG_EDGE_FALL_EN_SHIFT))

#define  IO_PAD98_PIOCFG_EDGE_RISE_EN_MASK 0x10
#define  IO_PAD98_PIOCFG_EDGE_RISE_EN_SHIFT 4
#define  IO_PAD98_PIOCFG_EDGE_RISE_EN_MASK_SHIFT(reg) (((reg) & IO_PAD98_PIOCFG_EDGE_RISE_EN_MASK) >> IO_PAD98_PIOCFG_EDGE_RISE_EN_SHIFT)
#define  IO_PAD98_PIOCFG_EDGE_RISE_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD98_PIOCFG_EDGE_RISE_EN_MASK) | (((uint32_t)val) << IO_PAD98_PIOCFG_EDGE_RISE_EN_SHIFT))

#define  IO_PAD98_PIOCFG_SLP_SEL_MASK 0x8
#define  IO_PAD98_PIOCFG_SLP_SEL_SHIFT 3
#define  IO_PAD98_PIOCFG_SLP_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD98_PIOCFG_SLP_SEL_MASK) >> IO_PAD98_PIOCFG_SLP_SEL_SHIFT)
#define  IO_PAD98_PIOCFG_SLP_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD98_PIOCFG_SLP_SEL_MASK) | (((uint32_t)val) << IO_PAD98_PIOCFG_SLP_SEL_SHIFT))

#define  IO_PAD98_PIOCFG_FUNC_SEL_MASK 0x7
#define  IO_PAD98_PIOCFG_FUNC_SEL_SHIFT 0
#define  IO_PAD98_PIOCFG_FUNC_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD98_PIOCFG_FUNC_SEL_MASK) >> IO_PAD98_PIOCFG_FUNC_SEL_SHIFT)
#define  IO_PAD98_PIOCFG_FUNC_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD98_PIOCFG_FUNC_SEL_MASK) | (((uint32_t)val) << IO_PAD98_PIOCFG_FUNC_SEL_SHIFT))

//====================================================================
//
//Register File: IO_PAD99 Configuration Registers (IO_PAD99)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

//====================================================================
//Register: IO_PAD99 Configuration Register (PIOCFG)
/** \brief "PHI_PADXDC_IOB" Pad*/
//====================================================================

#define  IO_PAD99_PIOCFG_RESERVED1_MASK 0xfc000000
#define  IO_PAD99_PIOCFG_RESERVED1_SHIFT 26
#define  IO_PAD99_PIOCFG_RESERVED1_MASK_SHIFT(reg) (((reg) & IO_PAD99_PIOCFG_RESERVED1_MASK) >> IO_PAD99_PIOCFG_RESERVED1_SHIFT)
#define  IO_PAD99_PIOCFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD99_PIOCFG_RESERVED1_MASK) | (((uint32_t)val) << IO_PAD99_PIOCFG_RESERVED1_SHIFT))

#define  IO_PAD99_PIOCFG_PD_MASK 0x2000000
#define  IO_PAD99_PIOCFG_PD_SHIFT 25
#define  IO_PAD99_PIOCFG_PD_MASK_SHIFT(reg) (((reg) & IO_PAD99_PIOCFG_PD_MASK) >> IO_PAD99_PIOCFG_PD_SHIFT)
#define  IO_PAD99_PIOCFG_PD_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD99_PIOCFG_PD_MASK) | (((uint32_t)val) << IO_PAD99_PIOCFG_PD_SHIFT))

#define  IO_PAD99_PIOCFG_ODT_EN_MASK 0x1000000
#define  IO_PAD99_PIOCFG_ODT_EN_SHIFT 24
#define  IO_PAD99_PIOCFG_ODT_EN_MASK_SHIFT(reg) (((reg) & IO_PAD99_PIOCFG_ODT_EN_MASK) >> IO_PAD99_PIOCFG_ODT_EN_SHIFT)
#define  IO_PAD99_PIOCFG_ODT_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD99_PIOCFG_ODT_EN_MASK) | (((uint32_t)val) << IO_PAD99_PIOCFG_ODT_EN_SHIFT))

#define  IO_PAD99_PIOCFG_LED_EN_MASK 0x800000
#define  IO_PAD99_PIOCFG_LED_EN_SHIFT 23
#define  IO_PAD99_PIOCFG_LED_EN_MASK_SHIFT(reg) (((reg) & IO_PAD99_PIOCFG_LED_EN_MASK) >> IO_PAD99_PIOCFG_LED_EN_SHIFT)
#define  IO_PAD99_PIOCFG_LED_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD99_PIOCFG_LED_EN_MASK) | (((uint32_t)val) << IO_PAD99_PIOCFG_LED_EN_SHIFT))

#define  IO_PAD99_PIOCFG_I2C_SEL_MASK 0x600000
#define  IO_PAD99_PIOCFG_I2C_SEL_SHIFT 21
#define  IO_PAD99_PIOCFG_I2C_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD99_PIOCFG_I2C_SEL_MASK) >> IO_PAD99_PIOCFG_I2C_SEL_SHIFT)
#define  IO_PAD99_PIOCFG_I2C_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD99_PIOCFG_I2C_SEL_MASK) | (((uint32_t)val) << IO_PAD99_PIOCFG_I2C_SEL_SHIFT))

#define  IO_PAD99_PIOCFG_DGTBSEL_MASK 0x1e0000
#define  IO_PAD99_PIOCFG_DGTBSEL_SHIFT 17
#define  IO_PAD99_PIOCFG_DGTBSEL_MASK_SHIFT(reg) (((reg) & IO_PAD99_PIOCFG_DGTBSEL_MASK) >> IO_PAD99_PIOCFG_DGTBSEL_SHIFT)
#define  IO_PAD99_PIOCFG_DGTBSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD99_PIOCFG_DGTBSEL_MASK) | (((uint32_t)val) << IO_PAD99_PIOCFG_DGTBSEL_SHIFT))

#define  IO_PAD99_PIOCFG_RAWSEL_MASK 0x10000
#define  IO_PAD99_PIOCFG_RAWSEL_SHIFT 16
#define  IO_PAD99_PIOCFG_RAWSEL_MASK_SHIFT(reg) (((reg) & IO_PAD99_PIOCFG_RAWSEL_MASK) >> IO_PAD99_PIOCFG_RAWSEL_SHIFT)
#define  IO_PAD99_PIOCFG_RAWSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD99_PIOCFG_RAWSEL_MASK) | (((uint32_t)val) << IO_PAD99_PIOCFG_RAWSEL_SHIFT))

#define  IO_PAD99_PIOCFG_PULL_SEL_MASK 0x8000
#define  IO_PAD99_PIOCFG_PULL_SEL_SHIFT 15
#define  IO_PAD99_PIOCFG_PULL_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD99_PIOCFG_PULL_SEL_MASK) >> IO_PAD99_PIOCFG_PULL_SEL_SHIFT)
#define  IO_PAD99_PIOCFG_PULL_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD99_PIOCFG_PULL_SEL_MASK) | (((uint32_t)val) << IO_PAD99_PIOCFG_PULL_SEL_SHIFT))

#define  IO_PAD99_PIOCFG_PUEN_MASK 0x4000
#define  IO_PAD99_PIOCFG_PUEN_SHIFT 14
#define  IO_PAD99_PIOCFG_PUEN_MASK_SHIFT(reg) (((reg) & IO_PAD99_PIOCFG_PUEN_MASK) >> IO_PAD99_PIOCFG_PUEN_SHIFT)
#define  IO_PAD99_PIOCFG_PUEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD99_PIOCFG_PUEN_MASK) | (((uint32_t)val) << IO_PAD99_PIOCFG_PUEN_SHIFT))

#define  IO_PAD99_PIOCFG_PDEN_MASK 0x2000
#define  IO_PAD99_PIOCFG_PDEN_SHIFT 13
#define  IO_PAD99_PIOCFG_PDEN_MASK_SHIFT(reg) (((reg) & IO_PAD99_PIOCFG_PDEN_MASK) >> IO_PAD99_PIOCFG_PDEN_SHIFT)
#define  IO_PAD99_PIOCFG_PDEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD99_PIOCFG_PDEN_MASK) | (((uint32_t)val) << IO_PAD99_PIOCFG_PDEN_SHIFT))

#define  IO_PAD99_PIOCFG_SR_MASK 0x1800
#define  IO_PAD99_PIOCFG_SR_SHIFT 11
#define  IO_PAD99_PIOCFG_SR_MASK_SHIFT(reg) (((reg) & IO_PAD99_PIOCFG_SR_MASK) >> IO_PAD99_PIOCFG_SR_SHIFT)
#define  IO_PAD99_PIOCFG_SR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD99_PIOCFG_SR_MASK) | (((uint32_t)val) << IO_PAD99_PIOCFG_SR_SHIFT))

#define  IO_PAD99_PIOCFG_SLP_DI_MASK 0x400
#define  IO_PAD99_PIOCFG_SLP_DI_SHIFT 10
#define  IO_PAD99_PIOCFG_SLP_DI_MASK_SHIFT(reg) (((reg) & IO_PAD99_PIOCFG_SLP_DI_MASK) >> IO_PAD99_PIOCFG_SLP_DI_SHIFT)
#define  IO_PAD99_PIOCFG_SLP_DI_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD99_PIOCFG_SLP_DI_MASK) | (((uint32_t)val) << IO_PAD99_PIOCFG_SLP_DI_SHIFT))

#define  IO_PAD99_PIOCFG_SLP_CNTRL_MASK 0x200
#define  IO_PAD99_PIOCFG_SLP_CNTRL_SHIFT 9
#define  IO_PAD99_PIOCFG_SLP_CNTRL_MASK_SHIFT(reg) (((reg) & IO_PAD99_PIOCFG_SLP_CNTRL_MASK) >> IO_PAD99_PIOCFG_SLP_CNTRL_SHIFT)
#define  IO_PAD99_PIOCFG_SLP_CNTRL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD99_PIOCFG_SLP_CNTRL_MASK) | (((uint32_t)val) << IO_PAD99_PIOCFG_SLP_CNTRL_SHIFT))

#define  IO_PAD99_PIOCFG_SLP_DO_MASK 0x100
#define  IO_PAD99_PIOCFG_SLP_DO_SHIFT 8
#define  IO_PAD99_PIOCFG_SLP_DO_MASK_SHIFT(reg) (((reg) & IO_PAD99_PIOCFG_SLP_DO_MASK) >> IO_PAD99_PIOCFG_SLP_DO_SHIFT)
#define  IO_PAD99_PIOCFG_SLP_DO_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD99_PIOCFG_SLP_DO_MASK) | (((uint32_t)val) << IO_PAD99_PIOCFG_SLP_DO_SHIFT))

#define  IO_PAD99_PIOCFG_SLP_DIR_MASK 0x80
#define  IO_PAD99_PIOCFG_SLP_DIR_SHIFT 7
#define  IO_PAD99_PIOCFG_SLP_DIR_MASK_SHIFT(reg) (((reg) & IO_PAD99_PIOCFG_SLP_DIR_MASK) >> IO_PAD99_PIOCFG_SLP_DIR_SHIFT)
#define  IO_PAD99_PIOCFG_SLP_DIR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD99_PIOCFG_SLP_DIR_MASK) | (((uint32_t)val) << IO_PAD99_PIOCFG_SLP_DIR_SHIFT))

#define  IO_PAD99_PIOCFG_EDGE_EN_N_MASK 0x40
#define  IO_PAD99_PIOCFG_EDGE_EN_N_SHIFT 6
#define  IO_PAD99_PIOCFG_EDGE_EN_N_MASK_SHIFT(reg) (((reg) & IO_PAD99_PIOCFG_EDGE_EN_N_MASK) >> IO_PAD99_PIOCFG_EDGE_EN_N_SHIFT)
#define  IO_PAD99_PIOCFG_EDGE_EN_N_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD99_PIOCFG_EDGE_EN_N_MASK) | (((uint32_t)val) << IO_PAD99_PIOCFG_EDGE_EN_N_SHIFT))

#define  IO_PAD99_PIOCFG_EDGE_FALL_EN_MASK 0x20
#define  IO_PAD99_PIOCFG_EDGE_FALL_EN_SHIFT 5
#define  IO_PAD99_PIOCFG_EDGE_FALL_EN_MASK_SHIFT(reg) (((reg) & IO_PAD99_PIOCFG_EDGE_FALL_EN_MASK) >> IO_PAD99_PIOCFG_EDGE_FALL_EN_SHIFT)
#define  IO_PAD99_PIOCFG_EDGE_FALL_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD99_PIOCFG_EDGE_FALL_EN_MASK) | (((uint32_t)val) << IO_PAD99_PIOCFG_EDGE_FALL_EN_SHIFT))

#define  IO_PAD99_PIOCFG_EDGE_RISE_EN_MASK 0x10
#define  IO_PAD99_PIOCFG_EDGE_RISE_EN_SHIFT 4
#define  IO_PAD99_PIOCFG_EDGE_RISE_EN_MASK_SHIFT(reg) (((reg) & IO_PAD99_PIOCFG_EDGE_RISE_EN_MASK) >> IO_PAD99_PIOCFG_EDGE_RISE_EN_SHIFT)
#define  IO_PAD99_PIOCFG_EDGE_RISE_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD99_PIOCFG_EDGE_RISE_EN_MASK) | (((uint32_t)val) << IO_PAD99_PIOCFG_EDGE_RISE_EN_SHIFT))

#define  IO_PAD99_PIOCFG_SLP_SEL_MASK 0x8
#define  IO_PAD99_PIOCFG_SLP_SEL_SHIFT 3
#define  IO_PAD99_PIOCFG_SLP_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD99_PIOCFG_SLP_SEL_MASK) >> IO_PAD99_PIOCFG_SLP_SEL_SHIFT)
#define  IO_PAD99_PIOCFG_SLP_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD99_PIOCFG_SLP_SEL_MASK) | (((uint32_t)val) << IO_PAD99_PIOCFG_SLP_SEL_SHIFT))

#define  IO_PAD99_PIOCFG_FUNC_SEL_MASK 0x7
#define  IO_PAD99_PIOCFG_FUNC_SEL_SHIFT 0
#define  IO_PAD99_PIOCFG_FUNC_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD99_PIOCFG_FUNC_SEL_MASK) >> IO_PAD99_PIOCFG_FUNC_SEL_SHIFT)
#define  IO_PAD99_PIOCFG_FUNC_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD99_PIOCFG_FUNC_SEL_MASK) | (((uint32_t)val) << IO_PAD99_PIOCFG_FUNC_SEL_SHIFT))

//====================================================================
//
//Register File: IO_PAD100 Configuration Registers (IO_PAD100)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

//====================================================================
//Register: IO_PAD100 Configuration Register (PIOCFG)
/** \brief "PHI_PADXDC_SRC" Pad*/
//====================================================================

#define  IO_PAD100_PIOCFG_RESERVED1_MASK 0xfc000000
#define  IO_PAD100_PIOCFG_RESERVED1_SHIFT 26
#define  IO_PAD100_PIOCFG_RESERVED1_MASK_SHIFT(reg) (((reg) & IO_PAD100_PIOCFG_RESERVED1_MASK) >> IO_PAD100_PIOCFG_RESERVED1_SHIFT)
#define  IO_PAD100_PIOCFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD100_PIOCFG_RESERVED1_MASK) | (((uint32_t)val) << IO_PAD100_PIOCFG_RESERVED1_SHIFT))

#define  IO_PAD100_PIOCFG_PD_MASK 0x2000000
#define  IO_PAD100_PIOCFG_PD_SHIFT 25
#define  IO_PAD100_PIOCFG_PD_MASK_SHIFT(reg) (((reg) & IO_PAD100_PIOCFG_PD_MASK) >> IO_PAD100_PIOCFG_PD_SHIFT)
#define  IO_PAD100_PIOCFG_PD_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD100_PIOCFG_PD_MASK) | (((uint32_t)val) << IO_PAD100_PIOCFG_PD_SHIFT))

#define  IO_PAD100_PIOCFG_ODT_EN_MASK 0x1000000
#define  IO_PAD100_PIOCFG_ODT_EN_SHIFT 24
#define  IO_PAD100_PIOCFG_ODT_EN_MASK_SHIFT(reg) (((reg) & IO_PAD100_PIOCFG_ODT_EN_MASK) >> IO_PAD100_PIOCFG_ODT_EN_SHIFT)
#define  IO_PAD100_PIOCFG_ODT_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD100_PIOCFG_ODT_EN_MASK) | (((uint32_t)val) << IO_PAD100_PIOCFG_ODT_EN_SHIFT))

#define  IO_PAD100_PIOCFG_LED_EN_MASK 0x800000
#define  IO_PAD100_PIOCFG_LED_EN_SHIFT 23
#define  IO_PAD100_PIOCFG_LED_EN_MASK_SHIFT(reg) (((reg) & IO_PAD100_PIOCFG_LED_EN_MASK) >> IO_PAD100_PIOCFG_LED_EN_SHIFT)
#define  IO_PAD100_PIOCFG_LED_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD100_PIOCFG_LED_EN_MASK) | (((uint32_t)val) << IO_PAD100_PIOCFG_LED_EN_SHIFT))

#define  IO_PAD100_PIOCFG_I2C_SEL_MASK 0x600000
#define  IO_PAD100_PIOCFG_I2C_SEL_SHIFT 21
#define  IO_PAD100_PIOCFG_I2C_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD100_PIOCFG_I2C_SEL_MASK) >> IO_PAD100_PIOCFG_I2C_SEL_SHIFT)
#define  IO_PAD100_PIOCFG_I2C_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD100_PIOCFG_I2C_SEL_MASK) | (((uint32_t)val) << IO_PAD100_PIOCFG_I2C_SEL_SHIFT))

#define  IO_PAD100_PIOCFG_DGTBSEL_MASK 0x1e0000
#define  IO_PAD100_PIOCFG_DGTBSEL_SHIFT 17
#define  IO_PAD100_PIOCFG_DGTBSEL_MASK_SHIFT(reg) (((reg) & IO_PAD100_PIOCFG_DGTBSEL_MASK) >> IO_PAD100_PIOCFG_DGTBSEL_SHIFT)
#define  IO_PAD100_PIOCFG_DGTBSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD100_PIOCFG_DGTBSEL_MASK) | (((uint32_t)val) << IO_PAD100_PIOCFG_DGTBSEL_SHIFT))

#define  IO_PAD100_PIOCFG_RAWSEL_MASK 0x10000
#define  IO_PAD100_PIOCFG_RAWSEL_SHIFT 16
#define  IO_PAD100_PIOCFG_RAWSEL_MASK_SHIFT(reg) (((reg) & IO_PAD100_PIOCFG_RAWSEL_MASK) >> IO_PAD100_PIOCFG_RAWSEL_SHIFT)
#define  IO_PAD100_PIOCFG_RAWSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD100_PIOCFG_RAWSEL_MASK) | (((uint32_t)val) << IO_PAD100_PIOCFG_RAWSEL_SHIFT))

#define  IO_PAD100_PIOCFG_PULL_SEL_MASK 0x8000
#define  IO_PAD100_PIOCFG_PULL_SEL_SHIFT 15
#define  IO_PAD100_PIOCFG_PULL_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD100_PIOCFG_PULL_SEL_MASK) >> IO_PAD100_PIOCFG_PULL_SEL_SHIFT)
#define  IO_PAD100_PIOCFG_PULL_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD100_PIOCFG_PULL_SEL_MASK) | (((uint32_t)val) << IO_PAD100_PIOCFG_PULL_SEL_SHIFT))

#define  IO_PAD100_PIOCFG_PUEN_MASK 0x4000
#define  IO_PAD100_PIOCFG_PUEN_SHIFT 14
#define  IO_PAD100_PIOCFG_PUEN_MASK_SHIFT(reg) (((reg) & IO_PAD100_PIOCFG_PUEN_MASK) >> IO_PAD100_PIOCFG_PUEN_SHIFT)
#define  IO_PAD100_PIOCFG_PUEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD100_PIOCFG_PUEN_MASK) | (((uint32_t)val) << IO_PAD100_PIOCFG_PUEN_SHIFT))

#define  IO_PAD100_PIOCFG_PDEN_MASK 0x2000
#define  IO_PAD100_PIOCFG_PDEN_SHIFT 13
#define  IO_PAD100_PIOCFG_PDEN_MASK_SHIFT(reg) (((reg) & IO_PAD100_PIOCFG_PDEN_MASK) >> IO_PAD100_PIOCFG_PDEN_SHIFT)
#define  IO_PAD100_PIOCFG_PDEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD100_PIOCFG_PDEN_MASK) | (((uint32_t)val) << IO_PAD100_PIOCFG_PDEN_SHIFT))

#define  IO_PAD100_PIOCFG_SR_MASK 0x1800
#define  IO_PAD100_PIOCFG_SR_SHIFT 11
#define  IO_PAD100_PIOCFG_SR_MASK_SHIFT(reg) (((reg) & IO_PAD100_PIOCFG_SR_MASK) >> IO_PAD100_PIOCFG_SR_SHIFT)
#define  IO_PAD100_PIOCFG_SR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD100_PIOCFG_SR_MASK) | (((uint32_t)val) << IO_PAD100_PIOCFG_SR_SHIFT))

#define  IO_PAD100_PIOCFG_SLP_DI_MASK 0x400
#define  IO_PAD100_PIOCFG_SLP_DI_SHIFT 10
#define  IO_PAD100_PIOCFG_SLP_DI_MASK_SHIFT(reg) (((reg) & IO_PAD100_PIOCFG_SLP_DI_MASK) >> IO_PAD100_PIOCFG_SLP_DI_SHIFT)
#define  IO_PAD100_PIOCFG_SLP_DI_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD100_PIOCFG_SLP_DI_MASK) | (((uint32_t)val) << IO_PAD100_PIOCFG_SLP_DI_SHIFT))

#define  IO_PAD100_PIOCFG_SLP_CNTRL_MASK 0x200
#define  IO_PAD100_PIOCFG_SLP_CNTRL_SHIFT 9
#define  IO_PAD100_PIOCFG_SLP_CNTRL_MASK_SHIFT(reg) (((reg) & IO_PAD100_PIOCFG_SLP_CNTRL_MASK) >> IO_PAD100_PIOCFG_SLP_CNTRL_SHIFT)
#define  IO_PAD100_PIOCFG_SLP_CNTRL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD100_PIOCFG_SLP_CNTRL_MASK) | (((uint32_t)val) << IO_PAD100_PIOCFG_SLP_CNTRL_SHIFT))

#define  IO_PAD100_PIOCFG_SLP_DO_MASK 0x100
#define  IO_PAD100_PIOCFG_SLP_DO_SHIFT 8
#define  IO_PAD100_PIOCFG_SLP_DO_MASK_SHIFT(reg) (((reg) & IO_PAD100_PIOCFG_SLP_DO_MASK) >> IO_PAD100_PIOCFG_SLP_DO_SHIFT)
#define  IO_PAD100_PIOCFG_SLP_DO_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD100_PIOCFG_SLP_DO_MASK) | (((uint32_t)val) << IO_PAD100_PIOCFG_SLP_DO_SHIFT))

#define  IO_PAD100_PIOCFG_SLP_DIR_MASK 0x80
#define  IO_PAD100_PIOCFG_SLP_DIR_SHIFT 7
#define  IO_PAD100_PIOCFG_SLP_DIR_MASK_SHIFT(reg) (((reg) & IO_PAD100_PIOCFG_SLP_DIR_MASK) >> IO_PAD100_PIOCFG_SLP_DIR_SHIFT)
#define  IO_PAD100_PIOCFG_SLP_DIR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD100_PIOCFG_SLP_DIR_MASK) | (((uint32_t)val) << IO_PAD100_PIOCFG_SLP_DIR_SHIFT))

#define  IO_PAD100_PIOCFG_EDGE_EN_N_MASK 0x40
#define  IO_PAD100_PIOCFG_EDGE_EN_N_SHIFT 6
#define  IO_PAD100_PIOCFG_EDGE_EN_N_MASK_SHIFT(reg) (((reg) & IO_PAD100_PIOCFG_EDGE_EN_N_MASK) >> IO_PAD100_PIOCFG_EDGE_EN_N_SHIFT)
#define  IO_PAD100_PIOCFG_EDGE_EN_N_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD100_PIOCFG_EDGE_EN_N_MASK) | (((uint32_t)val) << IO_PAD100_PIOCFG_EDGE_EN_N_SHIFT))

#define  IO_PAD100_PIOCFG_EDGE_FALL_EN_MASK 0x20
#define  IO_PAD100_PIOCFG_EDGE_FALL_EN_SHIFT 5
#define  IO_PAD100_PIOCFG_EDGE_FALL_EN_MASK_SHIFT(reg) (((reg) & IO_PAD100_PIOCFG_EDGE_FALL_EN_MASK) >> IO_PAD100_PIOCFG_EDGE_FALL_EN_SHIFT)
#define  IO_PAD100_PIOCFG_EDGE_FALL_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD100_PIOCFG_EDGE_FALL_EN_MASK) | (((uint32_t)val) << IO_PAD100_PIOCFG_EDGE_FALL_EN_SHIFT))

#define  IO_PAD100_PIOCFG_EDGE_RISE_EN_MASK 0x10
#define  IO_PAD100_PIOCFG_EDGE_RISE_EN_SHIFT 4
#define  IO_PAD100_PIOCFG_EDGE_RISE_EN_MASK_SHIFT(reg) (((reg) & IO_PAD100_PIOCFG_EDGE_RISE_EN_MASK) >> IO_PAD100_PIOCFG_EDGE_RISE_EN_SHIFT)
#define  IO_PAD100_PIOCFG_EDGE_RISE_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD100_PIOCFG_EDGE_RISE_EN_MASK) | (((uint32_t)val) << IO_PAD100_PIOCFG_EDGE_RISE_EN_SHIFT))

#define  IO_PAD100_PIOCFG_SLP_SEL_MASK 0x8
#define  IO_PAD100_PIOCFG_SLP_SEL_SHIFT 3
#define  IO_PAD100_PIOCFG_SLP_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD100_PIOCFG_SLP_SEL_MASK) >> IO_PAD100_PIOCFG_SLP_SEL_SHIFT)
#define  IO_PAD100_PIOCFG_SLP_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD100_PIOCFG_SLP_SEL_MASK) | (((uint32_t)val) << IO_PAD100_PIOCFG_SLP_SEL_SHIFT))

#define  IO_PAD100_PIOCFG_FUNC_SEL_MASK 0x7
#define  IO_PAD100_PIOCFG_FUNC_SEL_SHIFT 0
#define  IO_PAD100_PIOCFG_FUNC_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD100_PIOCFG_FUNC_SEL_MASK) >> IO_PAD100_PIOCFG_FUNC_SEL_SHIFT)
#define  IO_PAD100_PIOCFG_FUNC_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD100_PIOCFG_FUNC_SEL_MASK) | (((uint32_t)val) << IO_PAD100_PIOCFG_FUNC_SEL_SHIFT))

//====================================================================
//
//Register File: IO_PAD101 Configuration Registers (IO_PAD101)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

//====================================================================
//Register: IO_PAD101 Configuration Register (PIOCFG)
/** \brief "PHI_PADXDC_SRC" Pad*/
//====================================================================

#define  IO_PAD101_PIOCFG_RESERVED1_MASK 0xfc000000
#define  IO_PAD101_PIOCFG_RESERVED1_SHIFT 26
#define  IO_PAD101_PIOCFG_RESERVED1_MASK_SHIFT(reg) (((reg) & IO_PAD101_PIOCFG_RESERVED1_MASK) >> IO_PAD101_PIOCFG_RESERVED1_SHIFT)
#define  IO_PAD101_PIOCFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD101_PIOCFG_RESERVED1_MASK) | (((uint32_t)val) << IO_PAD101_PIOCFG_RESERVED1_SHIFT))

#define  IO_PAD101_PIOCFG_PD_MASK 0x2000000
#define  IO_PAD101_PIOCFG_PD_SHIFT 25
#define  IO_PAD101_PIOCFG_PD_MASK_SHIFT(reg) (((reg) & IO_PAD101_PIOCFG_PD_MASK) >> IO_PAD101_PIOCFG_PD_SHIFT)
#define  IO_PAD101_PIOCFG_PD_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD101_PIOCFG_PD_MASK) | (((uint32_t)val) << IO_PAD101_PIOCFG_PD_SHIFT))

#define  IO_PAD101_PIOCFG_ODT_EN_MASK 0x1000000
#define  IO_PAD101_PIOCFG_ODT_EN_SHIFT 24
#define  IO_PAD101_PIOCFG_ODT_EN_MASK_SHIFT(reg) (((reg) & IO_PAD101_PIOCFG_ODT_EN_MASK) >> IO_PAD101_PIOCFG_ODT_EN_SHIFT)
#define  IO_PAD101_PIOCFG_ODT_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD101_PIOCFG_ODT_EN_MASK) | (((uint32_t)val) << IO_PAD101_PIOCFG_ODT_EN_SHIFT))

#define  IO_PAD101_PIOCFG_LED_EN_MASK 0x800000
#define  IO_PAD101_PIOCFG_LED_EN_SHIFT 23
#define  IO_PAD101_PIOCFG_LED_EN_MASK_SHIFT(reg) (((reg) & IO_PAD101_PIOCFG_LED_EN_MASK) >> IO_PAD101_PIOCFG_LED_EN_SHIFT)
#define  IO_PAD101_PIOCFG_LED_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD101_PIOCFG_LED_EN_MASK) | (((uint32_t)val) << IO_PAD101_PIOCFG_LED_EN_SHIFT))

#define  IO_PAD101_PIOCFG_I2C_SEL_MASK 0x600000
#define  IO_PAD101_PIOCFG_I2C_SEL_SHIFT 21
#define  IO_PAD101_PIOCFG_I2C_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD101_PIOCFG_I2C_SEL_MASK) >> IO_PAD101_PIOCFG_I2C_SEL_SHIFT)
#define  IO_PAD101_PIOCFG_I2C_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD101_PIOCFG_I2C_SEL_MASK) | (((uint32_t)val) << IO_PAD101_PIOCFG_I2C_SEL_SHIFT))

#define  IO_PAD101_PIOCFG_DGTBSEL_MASK 0x1e0000
#define  IO_PAD101_PIOCFG_DGTBSEL_SHIFT 17
#define  IO_PAD101_PIOCFG_DGTBSEL_MASK_SHIFT(reg) (((reg) & IO_PAD101_PIOCFG_DGTBSEL_MASK) >> IO_PAD101_PIOCFG_DGTBSEL_SHIFT)
#define  IO_PAD101_PIOCFG_DGTBSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD101_PIOCFG_DGTBSEL_MASK) | (((uint32_t)val) << IO_PAD101_PIOCFG_DGTBSEL_SHIFT))

#define  IO_PAD101_PIOCFG_RAWSEL_MASK 0x10000
#define  IO_PAD101_PIOCFG_RAWSEL_SHIFT 16
#define  IO_PAD101_PIOCFG_RAWSEL_MASK_SHIFT(reg) (((reg) & IO_PAD101_PIOCFG_RAWSEL_MASK) >> IO_PAD101_PIOCFG_RAWSEL_SHIFT)
#define  IO_PAD101_PIOCFG_RAWSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD101_PIOCFG_RAWSEL_MASK) | (((uint32_t)val) << IO_PAD101_PIOCFG_RAWSEL_SHIFT))

#define  IO_PAD101_PIOCFG_PULL_SEL_MASK 0x8000
#define  IO_PAD101_PIOCFG_PULL_SEL_SHIFT 15
#define  IO_PAD101_PIOCFG_PULL_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD101_PIOCFG_PULL_SEL_MASK) >> IO_PAD101_PIOCFG_PULL_SEL_SHIFT)
#define  IO_PAD101_PIOCFG_PULL_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD101_PIOCFG_PULL_SEL_MASK) | (((uint32_t)val) << IO_PAD101_PIOCFG_PULL_SEL_SHIFT))

#define  IO_PAD101_PIOCFG_PUEN_MASK 0x4000
#define  IO_PAD101_PIOCFG_PUEN_SHIFT 14
#define  IO_PAD101_PIOCFG_PUEN_MASK_SHIFT(reg) (((reg) & IO_PAD101_PIOCFG_PUEN_MASK) >> IO_PAD101_PIOCFG_PUEN_SHIFT)
#define  IO_PAD101_PIOCFG_PUEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD101_PIOCFG_PUEN_MASK) | (((uint32_t)val) << IO_PAD101_PIOCFG_PUEN_SHIFT))

#define  IO_PAD101_PIOCFG_PDEN_MASK 0x2000
#define  IO_PAD101_PIOCFG_PDEN_SHIFT 13
#define  IO_PAD101_PIOCFG_PDEN_MASK_SHIFT(reg) (((reg) & IO_PAD101_PIOCFG_PDEN_MASK) >> IO_PAD101_PIOCFG_PDEN_SHIFT)
#define  IO_PAD101_PIOCFG_PDEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD101_PIOCFG_PDEN_MASK) | (((uint32_t)val) << IO_PAD101_PIOCFG_PDEN_SHIFT))

#define  IO_PAD101_PIOCFG_SR_MASK 0x1800
#define  IO_PAD101_PIOCFG_SR_SHIFT 11
#define  IO_PAD101_PIOCFG_SR_MASK_SHIFT(reg) (((reg) & IO_PAD101_PIOCFG_SR_MASK) >> IO_PAD101_PIOCFG_SR_SHIFT)
#define  IO_PAD101_PIOCFG_SR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD101_PIOCFG_SR_MASK) | (((uint32_t)val) << IO_PAD101_PIOCFG_SR_SHIFT))

#define  IO_PAD101_PIOCFG_SLP_DI_MASK 0x400
#define  IO_PAD101_PIOCFG_SLP_DI_SHIFT 10
#define  IO_PAD101_PIOCFG_SLP_DI_MASK_SHIFT(reg) (((reg) & IO_PAD101_PIOCFG_SLP_DI_MASK) >> IO_PAD101_PIOCFG_SLP_DI_SHIFT)
#define  IO_PAD101_PIOCFG_SLP_DI_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD101_PIOCFG_SLP_DI_MASK) | (((uint32_t)val) << IO_PAD101_PIOCFG_SLP_DI_SHIFT))

#define  IO_PAD101_PIOCFG_SLP_CNTRL_MASK 0x200
#define  IO_PAD101_PIOCFG_SLP_CNTRL_SHIFT 9
#define  IO_PAD101_PIOCFG_SLP_CNTRL_MASK_SHIFT(reg) (((reg) & IO_PAD101_PIOCFG_SLP_CNTRL_MASK) >> IO_PAD101_PIOCFG_SLP_CNTRL_SHIFT)
#define  IO_PAD101_PIOCFG_SLP_CNTRL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD101_PIOCFG_SLP_CNTRL_MASK) | (((uint32_t)val) << IO_PAD101_PIOCFG_SLP_CNTRL_SHIFT))

#define  IO_PAD101_PIOCFG_SLP_DO_MASK 0x100
#define  IO_PAD101_PIOCFG_SLP_DO_SHIFT 8
#define  IO_PAD101_PIOCFG_SLP_DO_MASK_SHIFT(reg) (((reg) & IO_PAD101_PIOCFG_SLP_DO_MASK) >> IO_PAD101_PIOCFG_SLP_DO_SHIFT)
#define  IO_PAD101_PIOCFG_SLP_DO_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD101_PIOCFG_SLP_DO_MASK) | (((uint32_t)val) << IO_PAD101_PIOCFG_SLP_DO_SHIFT))

#define  IO_PAD101_PIOCFG_SLP_DIR_MASK 0x80
#define  IO_PAD101_PIOCFG_SLP_DIR_SHIFT 7
#define  IO_PAD101_PIOCFG_SLP_DIR_MASK_SHIFT(reg) (((reg) & IO_PAD101_PIOCFG_SLP_DIR_MASK) >> IO_PAD101_PIOCFG_SLP_DIR_SHIFT)
#define  IO_PAD101_PIOCFG_SLP_DIR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD101_PIOCFG_SLP_DIR_MASK) | (((uint32_t)val) << IO_PAD101_PIOCFG_SLP_DIR_SHIFT))

#define  IO_PAD101_PIOCFG_EDGE_EN_N_MASK 0x40
#define  IO_PAD101_PIOCFG_EDGE_EN_N_SHIFT 6
#define  IO_PAD101_PIOCFG_EDGE_EN_N_MASK_SHIFT(reg) (((reg) & IO_PAD101_PIOCFG_EDGE_EN_N_MASK) >> IO_PAD101_PIOCFG_EDGE_EN_N_SHIFT)
#define  IO_PAD101_PIOCFG_EDGE_EN_N_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD101_PIOCFG_EDGE_EN_N_MASK) | (((uint32_t)val) << IO_PAD101_PIOCFG_EDGE_EN_N_SHIFT))

#define  IO_PAD101_PIOCFG_EDGE_FALL_EN_MASK 0x20
#define  IO_PAD101_PIOCFG_EDGE_FALL_EN_SHIFT 5
#define  IO_PAD101_PIOCFG_EDGE_FALL_EN_MASK_SHIFT(reg) (((reg) & IO_PAD101_PIOCFG_EDGE_FALL_EN_MASK) >> IO_PAD101_PIOCFG_EDGE_FALL_EN_SHIFT)
#define  IO_PAD101_PIOCFG_EDGE_FALL_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD101_PIOCFG_EDGE_FALL_EN_MASK) | (((uint32_t)val) << IO_PAD101_PIOCFG_EDGE_FALL_EN_SHIFT))

#define  IO_PAD101_PIOCFG_EDGE_RISE_EN_MASK 0x10
#define  IO_PAD101_PIOCFG_EDGE_RISE_EN_SHIFT 4
#define  IO_PAD101_PIOCFG_EDGE_RISE_EN_MASK_SHIFT(reg) (((reg) & IO_PAD101_PIOCFG_EDGE_RISE_EN_MASK) >> IO_PAD101_PIOCFG_EDGE_RISE_EN_SHIFT)
#define  IO_PAD101_PIOCFG_EDGE_RISE_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD101_PIOCFG_EDGE_RISE_EN_MASK) | (((uint32_t)val) << IO_PAD101_PIOCFG_EDGE_RISE_EN_SHIFT))

#define  IO_PAD101_PIOCFG_SLP_SEL_MASK 0x8
#define  IO_PAD101_PIOCFG_SLP_SEL_SHIFT 3
#define  IO_PAD101_PIOCFG_SLP_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD101_PIOCFG_SLP_SEL_MASK) >> IO_PAD101_PIOCFG_SLP_SEL_SHIFT)
#define  IO_PAD101_PIOCFG_SLP_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD101_PIOCFG_SLP_SEL_MASK) | (((uint32_t)val) << IO_PAD101_PIOCFG_SLP_SEL_SHIFT))

#define  IO_PAD101_PIOCFG_FUNC_SEL_MASK 0x7
#define  IO_PAD101_PIOCFG_FUNC_SEL_SHIFT 0
#define  IO_PAD101_PIOCFG_FUNC_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD101_PIOCFG_FUNC_SEL_MASK) >> IO_PAD101_PIOCFG_FUNC_SEL_SHIFT)
#define  IO_PAD101_PIOCFG_FUNC_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD101_PIOCFG_FUNC_SEL_MASK) | (((uint32_t)val) << IO_PAD101_PIOCFG_FUNC_SEL_SHIFT))

//====================================================================
//
//Register File: IO_PAD102 Configuration Registers (IO_PAD102)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

//====================================================================
//Register: IO_PAD102 Configuration Register (PIOCFG)
/** \brief "PHI_PADXDC_SRC" Pad*/
//====================================================================

#define  IO_PAD102_PIOCFG_RESERVED1_MASK 0xfc000000
#define  IO_PAD102_PIOCFG_RESERVED1_SHIFT 26
#define  IO_PAD102_PIOCFG_RESERVED1_MASK_SHIFT(reg) (((reg) & IO_PAD102_PIOCFG_RESERVED1_MASK) >> IO_PAD102_PIOCFG_RESERVED1_SHIFT)
#define  IO_PAD102_PIOCFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD102_PIOCFG_RESERVED1_MASK) | (((uint32_t)val) << IO_PAD102_PIOCFG_RESERVED1_SHIFT))

#define  IO_PAD102_PIOCFG_PD_MASK 0x2000000
#define  IO_PAD102_PIOCFG_PD_SHIFT 25
#define  IO_PAD102_PIOCFG_PD_MASK_SHIFT(reg) (((reg) & IO_PAD102_PIOCFG_PD_MASK) >> IO_PAD102_PIOCFG_PD_SHIFT)
#define  IO_PAD102_PIOCFG_PD_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD102_PIOCFG_PD_MASK) | (((uint32_t)val) << IO_PAD102_PIOCFG_PD_SHIFT))

#define  IO_PAD102_PIOCFG_ODT_EN_MASK 0x1000000
#define  IO_PAD102_PIOCFG_ODT_EN_SHIFT 24
#define  IO_PAD102_PIOCFG_ODT_EN_MASK_SHIFT(reg) (((reg) & IO_PAD102_PIOCFG_ODT_EN_MASK) >> IO_PAD102_PIOCFG_ODT_EN_SHIFT)
#define  IO_PAD102_PIOCFG_ODT_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD102_PIOCFG_ODT_EN_MASK) | (((uint32_t)val) << IO_PAD102_PIOCFG_ODT_EN_SHIFT))

#define  IO_PAD102_PIOCFG_LED_EN_MASK 0x800000
#define  IO_PAD102_PIOCFG_LED_EN_SHIFT 23
#define  IO_PAD102_PIOCFG_LED_EN_MASK_SHIFT(reg) (((reg) & IO_PAD102_PIOCFG_LED_EN_MASK) >> IO_PAD102_PIOCFG_LED_EN_SHIFT)
#define  IO_PAD102_PIOCFG_LED_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD102_PIOCFG_LED_EN_MASK) | (((uint32_t)val) << IO_PAD102_PIOCFG_LED_EN_SHIFT))

#define  IO_PAD102_PIOCFG_I2C_SEL_MASK 0x600000
#define  IO_PAD102_PIOCFG_I2C_SEL_SHIFT 21
#define  IO_PAD102_PIOCFG_I2C_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD102_PIOCFG_I2C_SEL_MASK) >> IO_PAD102_PIOCFG_I2C_SEL_SHIFT)
#define  IO_PAD102_PIOCFG_I2C_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD102_PIOCFG_I2C_SEL_MASK) | (((uint32_t)val) << IO_PAD102_PIOCFG_I2C_SEL_SHIFT))

#define  IO_PAD102_PIOCFG_DGTBSEL_MASK 0x1e0000
#define  IO_PAD102_PIOCFG_DGTBSEL_SHIFT 17
#define  IO_PAD102_PIOCFG_DGTBSEL_MASK_SHIFT(reg) (((reg) & IO_PAD102_PIOCFG_DGTBSEL_MASK) >> IO_PAD102_PIOCFG_DGTBSEL_SHIFT)
#define  IO_PAD102_PIOCFG_DGTBSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD102_PIOCFG_DGTBSEL_MASK) | (((uint32_t)val) << IO_PAD102_PIOCFG_DGTBSEL_SHIFT))

#define  IO_PAD102_PIOCFG_RAWSEL_MASK 0x10000
#define  IO_PAD102_PIOCFG_RAWSEL_SHIFT 16
#define  IO_PAD102_PIOCFG_RAWSEL_MASK_SHIFT(reg) (((reg) & IO_PAD102_PIOCFG_RAWSEL_MASK) >> IO_PAD102_PIOCFG_RAWSEL_SHIFT)
#define  IO_PAD102_PIOCFG_RAWSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD102_PIOCFG_RAWSEL_MASK) | (((uint32_t)val) << IO_PAD102_PIOCFG_RAWSEL_SHIFT))

#define  IO_PAD102_PIOCFG_PULL_SEL_MASK 0x8000
#define  IO_PAD102_PIOCFG_PULL_SEL_SHIFT 15
#define  IO_PAD102_PIOCFG_PULL_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD102_PIOCFG_PULL_SEL_MASK) >> IO_PAD102_PIOCFG_PULL_SEL_SHIFT)
#define  IO_PAD102_PIOCFG_PULL_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD102_PIOCFG_PULL_SEL_MASK) | (((uint32_t)val) << IO_PAD102_PIOCFG_PULL_SEL_SHIFT))

#define  IO_PAD102_PIOCFG_PUEN_MASK 0x4000
#define  IO_PAD102_PIOCFG_PUEN_SHIFT 14
#define  IO_PAD102_PIOCFG_PUEN_MASK_SHIFT(reg) (((reg) & IO_PAD102_PIOCFG_PUEN_MASK) >> IO_PAD102_PIOCFG_PUEN_SHIFT)
#define  IO_PAD102_PIOCFG_PUEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD102_PIOCFG_PUEN_MASK) | (((uint32_t)val) << IO_PAD102_PIOCFG_PUEN_SHIFT))

#define  IO_PAD102_PIOCFG_PDEN_MASK 0x2000
#define  IO_PAD102_PIOCFG_PDEN_SHIFT 13
#define  IO_PAD102_PIOCFG_PDEN_MASK_SHIFT(reg) (((reg) & IO_PAD102_PIOCFG_PDEN_MASK) >> IO_PAD102_PIOCFG_PDEN_SHIFT)
#define  IO_PAD102_PIOCFG_PDEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD102_PIOCFG_PDEN_MASK) | (((uint32_t)val) << IO_PAD102_PIOCFG_PDEN_SHIFT))

#define  IO_PAD102_PIOCFG_SR_MASK 0x1800
#define  IO_PAD102_PIOCFG_SR_SHIFT 11
#define  IO_PAD102_PIOCFG_SR_MASK_SHIFT(reg) (((reg) & IO_PAD102_PIOCFG_SR_MASK) >> IO_PAD102_PIOCFG_SR_SHIFT)
#define  IO_PAD102_PIOCFG_SR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD102_PIOCFG_SR_MASK) | (((uint32_t)val) << IO_PAD102_PIOCFG_SR_SHIFT))

#define  IO_PAD102_PIOCFG_SLP_DI_MASK 0x400
#define  IO_PAD102_PIOCFG_SLP_DI_SHIFT 10
#define  IO_PAD102_PIOCFG_SLP_DI_MASK_SHIFT(reg) (((reg) & IO_PAD102_PIOCFG_SLP_DI_MASK) >> IO_PAD102_PIOCFG_SLP_DI_SHIFT)
#define  IO_PAD102_PIOCFG_SLP_DI_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD102_PIOCFG_SLP_DI_MASK) | (((uint32_t)val) << IO_PAD102_PIOCFG_SLP_DI_SHIFT))

#define  IO_PAD102_PIOCFG_SLP_CNTRL_MASK 0x200
#define  IO_PAD102_PIOCFG_SLP_CNTRL_SHIFT 9
#define  IO_PAD102_PIOCFG_SLP_CNTRL_MASK_SHIFT(reg) (((reg) & IO_PAD102_PIOCFG_SLP_CNTRL_MASK) >> IO_PAD102_PIOCFG_SLP_CNTRL_SHIFT)
#define  IO_PAD102_PIOCFG_SLP_CNTRL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD102_PIOCFG_SLP_CNTRL_MASK) | (((uint32_t)val) << IO_PAD102_PIOCFG_SLP_CNTRL_SHIFT))

#define  IO_PAD102_PIOCFG_SLP_DO_MASK 0x100
#define  IO_PAD102_PIOCFG_SLP_DO_SHIFT 8
#define  IO_PAD102_PIOCFG_SLP_DO_MASK_SHIFT(reg) (((reg) & IO_PAD102_PIOCFG_SLP_DO_MASK) >> IO_PAD102_PIOCFG_SLP_DO_SHIFT)
#define  IO_PAD102_PIOCFG_SLP_DO_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD102_PIOCFG_SLP_DO_MASK) | (((uint32_t)val) << IO_PAD102_PIOCFG_SLP_DO_SHIFT))

#define  IO_PAD102_PIOCFG_SLP_DIR_MASK 0x80
#define  IO_PAD102_PIOCFG_SLP_DIR_SHIFT 7
#define  IO_PAD102_PIOCFG_SLP_DIR_MASK_SHIFT(reg) (((reg) & IO_PAD102_PIOCFG_SLP_DIR_MASK) >> IO_PAD102_PIOCFG_SLP_DIR_SHIFT)
#define  IO_PAD102_PIOCFG_SLP_DIR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD102_PIOCFG_SLP_DIR_MASK) | (((uint32_t)val) << IO_PAD102_PIOCFG_SLP_DIR_SHIFT))

#define  IO_PAD102_PIOCFG_EDGE_EN_N_MASK 0x40
#define  IO_PAD102_PIOCFG_EDGE_EN_N_SHIFT 6
#define  IO_PAD102_PIOCFG_EDGE_EN_N_MASK_SHIFT(reg) (((reg) & IO_PAD102_PIOCFG_EDGE_EN_N_MASK) >> IO_PAD102_PIOCFG_EDGE_EN_N_SHIFT)
#define  IO_PAD102_PIOCFG_EDGE_EN_N_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD102_PIOCFG_EDGE_EN_N_MASK) | (((uint32_t)val) << IO_PAD102_PIOCFG_EDGE_EN_N_SHIFT))

#define  IO_PAD102_PIOCFG_EDGE_FALL_EN_MASK 0x20
#define  IO_PAD102_PIOCFG_EDGE_FALL_EN_SHIFT 5
#define  IO_PAD102_PIOCFG_EDGE_FALL_EN_MASK_SHIFT(reg) (((reg) & IO_PAD102_PIOCFG_EDGE_FALL_EN_MASK) >> IO_PAD102_PIOCFG_EDGE_FALL_EN_SHIFT)
#define  IO_PAD102_PIOCFG_EDGE_FALL_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD102_PIOCFG_EDGE_FALL_EN_MASK) | (((uint32_t)val) << IO_PAD102_PIOCFG_EDGE_FALL_EN_SHIFT))

#define  IO_PAD102_PIOCFG_EDGE_RISE_EN_MASK 0x10
#define  IO_PAD102_PIOCFG_EDGE_RISE_EN_SHIFT 4
#define  IO_PAD102_PIOCFG_EDGE_RISE_EN_MASK_SHIFT(reg) (((reg) & IO_PAD102_PIOCFG_EDGE_RISE_EN_MASK) >> IO_PAD102_PIOCFG_EDGE_RISE_EN_SHIFT)
#define  IO_PAD102_PIOCFG_EDGE_RISE_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD102_PIOCFG_EDGE_RISE_EN_MASK) | (((uint32_t)val) << IO_PAD102_PIOCFG_EDGE_RISE_EN_SHIFT))

#define  IO_PAD102_PIOCFG_SLP_SEL_MASK 0x8
#define  IO_PAD102_PIOCFG_SLP_SEL_SHIFT 3
#define  IO_PAD102_PIOCFG_SLP_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD102_PIOCFG_SLP_SEL_MASK) >> IO_PAD102_PIOCFG_SLP_SEL_SHIFT)
#define  IO_PAD102_PIOCFG_SLP_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD102_PIOCFG_SLP_SEL_MASK) | (((uint32_t)val) << IO_PAD102_PIOCFG_SLP_SEL_SHIFT))

#define  IO_PAD102_PIOCFG_FUNC_SEL_MASK 0x7
#define  IO_PAD102_PIOCFG_FUNC_SEL_SHIFT 0
#define  IO_PAD102_PIOCFG_FUNC_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD102_PIOCFG_FUNC_SEL_MASK) >> IO_PAD102_PIOCFG_FUNC_SEL_SHIFT)
#define  IO_PAD102_PIOCFG_FUNC_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD102_PIOCFG_FUNC_SEL_MASK) | (((uint32_t)val) << IO_PAD102_PIOCFG_FUNC_SEL_SHIFT))

//====================================================================
//
//Register File: IO_PAD103 Configuration Registers (IO_PAD103)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

//====================================================================
//Register: IO_PAD103 Configuration Register (PIOCFG)
/** \brief "PHI_PADXDC_SRC" Pad*/
//====================================================================

#define  IO_PAD103_PIOCFG_RESERVED1_MASK 0xfc000000
#define  IO_PAD103_PIOCFG_RESERVED1_SHIFT 26
#define  IO_PAD103_PIOCFG_RESERVED1_MASK_SHIFT(reg) (((reg) & IO_PAD103_PIOCFG_RESERVED1_MASK) >> IO_PAD103_PIOCFG_RESERVED1_SHIFT)
#define  IO_PAD103_PIOCFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD103_PIOCFG_RESERVED1_MASK) | (((uint32_t)val) << IO_PAD103_PIOCFG_RESERVED1_SHIFT))

#define  IO_PAD103_PIOCFG_PD_MASK 0x2000000
#define  IO_PAD103_PIOCFG_PD_SHIFT 25
#define  IO_PAD103_PIOCFG_PD_MASK_SHIFT(reg) (((reg) & IO_PAD103_PIOCFG_PD_MASK) >> IO_PAD103_PIOCFG_PD_SHIFT)
#define  IO_PAD103_PIOCFG_PD_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD103_PIOCFG_PD_MASK) | (((uint32_t)val) << IO_PAD103_PIOCFG_PD_SHIFT))

#define  IO_PAD103_PIOCFG_ODT_EN_MASK 0x1000000
#define  IO_PAD103_PIOCFG_ODT_EN_SHIFT 24
#define  IO_PAD103_PIOCFG_ODT_EN_MASK_SHIFT(reg) (((reg) & IO_PAD103_PIOCFG_ODT_EN_MASK) >> IO_PAD103_PIOCFG_ODT_EN_SHIFT)
#define  IO_PAD103_PIOCFG_ODT_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD103_PIOCFG_ODT_EN_MASK) | (((uint32_t)val) << IO_PAD103_PIOCFG_ODT_EN_SHIFT))

#define  IO_PAD103_PIOCFG_LED_EN_MASK 0x800000
#define  IO_PAD103_PIOCFG_LED_EN_SHIFT 23
#define  IO_PAD103_PIOCFG_LED_EN_MASK_SHIFT(reg) (((reg) & IO_PAD103_PIOCFG_LED_EN_MASK) >> IO_PAD103_PIOCFG_LED_EN_SHIFT)
#define  IO_PAD103_PIOCFG_LED_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD103_PIOCFG_LED_EN_MASK) | (((uint32_t)val) << IO_PAD103_PIOCFG_LED_EN_SHIFT))

#define  IO_PAD103_PIOCFG_I2C_SEL_MASK 0x600000
#define  IO_PAD103_PIOCFG_I2C_SEL_SHIFT 21
#define  IO_PAD103_PIOCFG_I2C_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD103_PIOCFG_I2C_SEL_MASK) >> IO_PAD103_PIOCFG_I2C_SEL_SHIFT)
#define  IO_PAD103_PIOCFG_I2C_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD103_PIOCFG_I2C_SEL_MASK) | (((uint32_t)val) << IO_PAD103_PIOCFG_I2C_SEL_SHIFT))

#define  IO_PAD103_PIOCFG_DGTBSEL_MASK 0x1e0000
#define  IO_PAD103_PIOCFG_DGTBSEL_SHIFT 17
#define  IO_PAD103_PIOCFG_DGTBSEL_MASK_SHIFT(reg) (((reg) & IO_PAD103_PIOCFG_DGTBSEL_MASK) >> IO_PAD103_PIOCFG_DGTBSEL_SHIFT)
#define  IO_PAD103_PIOCFG_DGTBSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD103_PIOCFG_DGTBSEL_MASK) | (((uint32_t)val) << IO_PAD103_PIOCFG_DGTBSEL_SHIFT))

#define  IO_PAD103_PIOCFG_RAWSEL_MASK 0x10000
#define  IO_PAD103_PIOCFG_RAWSEL_SHIFT 16
#define  IO_PAD103_PIOCFG_RAWSEL_MASK_SHIFT(reg) (((reg) & IO_PAD103_PIOCFG_RAWSEL_MASK) >> IO_PAD103_PIOCFG_RAWSEL_SHIFT)
#define  IO_PAD103_PIOCFG_RAWSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD103_PIOCFG_RAWSEL_MASK) | (((uint32_t)val) << IO_PAD103_PIOCFG_RAWSEL_SHIFT))

#define  IO_PAD103_PIOCFG_PULL_SEL_MASK 0x8000
#define  IO_PAD103_PIOCFG_PULL_SEL_SHIFT 15
#define  IO_PAD103_PIOCFG_PULL_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD103_PIOCFG_PULL_SEL_MASK) >> IO_PAD103_PIOCFG_PULL_SEL_SHIFT)
#define  IO_PAD103_PIOCFG_PULL_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD103_PIOCFG_PULL_SEL_MASK) | (((uint32_t)val) << IO_PAD103_PIOCFG_PULL_SEL_SHIFT))

#define  IO_PAD103_PIOCFG_PUEN_MASK 0x4000
#define  IO_PAD103_PIOCFG_PUEN_SHIFT 14
#define  IO_PAD103_PIOCFG_PUEN_MASK_SHIFT(reg) (((reg) & IO_PAD103_PIOCFG_PUEN_MASK) >> IO_PAD103_PIOCFG_PUEN_SHIFT)
#define  IO_PAD103_PIOCFG_PUEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD103_PIOCFG_PUEN_MASK) | (((uint32_t)val) << IO_PAD103_PIOCFG_PUEN_SHIFT))

#define  IO_PAD103_PIOCFG_PDEN_MASK 0x2000
#define  IO_PAD103_PIOCFG_PDEN_SHIFT 13
#define  IO_PAD103_PIOCFG_PDEN_MASK_SHIFT(reg) (((reg) & IO_PAD103_PIOCFG_PDEN_MASK) >> IO_PAD103_PIOCFG_PDEN_SHIFT)
#define  IO_PAD103_PIOCFG_PDEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD103_PIOCFG_PDEN_MASK) | (((uint32_t)val) << IO_PAD103_PIOCFG_PDEN_SHIFT))

#define  IO_PAD103_PIOCFG_SR_MASK 0x1800
#define  IO_PAD103_PIOCFG_SR_SHIFT 11
#define  IO_PAD103_PIOCFG_SR_MASK_SHIFT(reg) (((reg) & IO_PAD103_PIOCFG_SR_MASK) >> IO_PAD103_PIOCFG_SR_SHIFT)
#define  IO_PAD103_PIOCFG_SR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD103_PIOCFG_SR_MASK) | (((uint32_t)val) << IO_PAD103_PIOCFG_SR_SHIFT))

#define  IO_PAD103_PIOCFG_SLP_DI_MASK 0x400
#define  IO_PAD103_PIOCFG_SLP_DI_SHIFT 10
#define  IO_PAD103_PIOCFG_SLP_DI_MASK_SHIFT(reg) (((reg) & IO_PAD103_PIOCFG_SLP_DI_MASK) >> IO_PAD103_PIOCFG_SLP_DI_SHIFT)
#define  IO_PAD103_PIOCFG_SLP_DI_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD103_PIOCFG_SLP_DI_MASK) | (((uint32_t)val) << IO_PAD103_PIOCFG_SLP_DI_SHIFT))

#define  IO_PAD103_PIOCFG_SLP_CNTRL_MASK 0x200
#define  IO_PAD103_PIOCFG_SLP_CNTRL_SHIFT 9
#define  IO_PAD103_PIOCFG_SLP_CNTRL_MASK_SHIFT(reg) (((reg) & IO_PAD103_PIOCFG_SLP_CNTRL_MASK) >> IO_PAD103_PIOCFG_SLP_CNTRL_SHIFT)
#define  IO_PAD103_PIOCFG_SLP_CNTRL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD103_PIOCFG_SLP_CNTRL_MASK) | (((uint32_t)val) << IO_PAD103_PIOCFG_SLP_CNTRL_SHIFT))

#define  IO_PAD103_PIOCFG_SLP_DO_MASK 0x100
#define  IO_PAD103_PIOCFG_SLP_DO_SHIFT 8
#define  IO_PAD103_PIOCFG_SLP_DO_MASK_SHIFT(reg) (((reg) & IO_PAD103_PIOCFG_SLP_DO_MASK) >> IO_PAD103_PIOCFG_SLP_DO_SHIFT)
#define  IO_PAD103_PIOCFG_SLP_DO_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD103_PIOCFG_SLP_DO_MASK) | (((uint32_t)val) << IO_PAD103_PIOCFG_SLP_DO_SHIFT))

#define  IO_PAD103_PIOCFG_SLP_DIR_MASK 0x80
#define  IO_PAD103_PIOCFG_SLP_DIR_SHIFT 7
#define  IO_PAD103_PIOCFG_SLP_DIR_MASK_SHIFT(reg) (((reg) & IO_PAD103_PIOCFG_SLP_DIR_MASK) >> IO_PAD103_PIOCFG_SLP_DIR_SHIFT)
#define  IO_PAD103_PIOCFG_SLP_DIR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD103_PIOCFG_SLP_DIR_MASK) | (((uint32_t)val) << IO_PAD103_PIOCFG_SLP_DIR_SHIFT))

#define  IO_PAD103_PIOCFG_EDGE_EN_N_MASK 0x40
#define  IO_PAD103_PIOCFG_EDGE_EN_N_SHIFT 6
#define  IO_PAD103_PIOCFG_EDGE_EN_N_MASK_SHIFT(reg) (((reg) & IO_PAD103_PIOCFG_EDGE_EN_N_MASK) >> IO_PAD103_PIOCFG_EDGE_EN_N_SHIFT)
#define  IO_PAD103_PIOCFG_EDGE_EN_N_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD103_PIOCFG_EDGE_EN_N_MASK) | (((uint32_t)val) << IO_PAD103_PIOCFG_EDGE_EN_N_SHIFT))

#define  IO_PAD103_PIOCFG_EDGE_FALL_EN_MASK 0x20
#define  IO_PAD103_PIOCFG_EDGE_FALL_EN_SHIFT 5
#define  IO_PAD103_PIOCFG_EDGE_FALL_EN_MASK_SHIFT(reg) (((reg) & IO_PAD103_PIOCFG_EDGE_FALL_EN_MASK) >> IO_PAD103_PIOCFG_EDGE_FALL_EN_SHIFT)
#define  IO_PAD103_PIOCFG_EDGE_FALL_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD103_PIOCFG_EDGE_FALL_EN_MASK) | (((uint32_t)val) << IO_PAD103_PIOCFG_EDGE_FALL_EN_SHIFT))

#define  IO_PAD103_PIOCFG_EDGE_RISE_EN_MASK 0x10
#define  IO_PAD103_PIOCFG_EDGE_RISE_EN_SHIFT 4
#define  IO_PAD103_PIOCFG_EDGE_RISE_EN_MASK_SHIFT(reg) (((reg) & IO_PAD103_PIOCFG_EDGE_RISE_EN_MASK) >> IO_PAD103_PIOCFG_EDGE_RISE_EN_SHIFT)
#define  IO_PAD103_PIOCFG_EDGE_RISE_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD103_PIOCFG_EDGE_RISE_EN_MASK) | (((uint32_t)val) << IO_PAD103_PIOCFG_EDGE_RISE_EN_SHIFT))

#define  IO_PAD103_PIOCFG_SLP_SEL_MASK 0x8
#define  IO_PAD103_PIOCFG_SLP_SEL_SHIFT 3
#define  IO_PAD103_PIOCFG_SLP_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD103_PIOCFG_SLP_SEL_MASK) >> IO_PAD103_PIOCFG_SLP_SEL_SHIFT)
#define  IO_PAD103_PIOCFG_SLP_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD103_PIOCFG_SLP_SEL_MASK) | (((uint32_t)val) << IO_PAD103_PIOCFG_SLP_SEL_SHIFT))

#define  IO_PAD103_PIOCFG_FUNC_SEL_MASK 0x7
#define  IO_PAD103_PIOCFG_FUNC_SEL_SHIFT 0
#define  IO_PAD103_PIOCFG_FUNC_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD103_PIOCFG_FUNC_SEL_MASK) >> IO_PAD103_PIOCFG_FUNC_SEL_SHIFT)
#define  IO_PAD103_PIOCFG_FUNC_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD103_PIOCFG_FUNC_SEL_MASK) | (((uint32_t)val) << IO_PAD103_PIOCFG_FUNC_SEL_SHIFT))

//====================================================================
//
//Register File: IO_PAD104 Configuration Registers (IO_PAD104)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

//====================================================================
//Register: IO_PAD104 Configuration Register (PIOCFG)
/** \brief "PHI_PADXDC_SRC" Pad*/
//====================================================================

#define  IO_PAD104_PIOCFG_RESERVED1_MASK 0xfc000000
#define  IO_PAD104_PIOCFG_RESERVED1_SHIFT 26
#define  IO_PAD104_PIOCFG_RESERVED1_MASK_SHIFT(reg) (((reg) & IO_PAD104_PIOCFG_RESERVED1_MASK) >> IO_PAD104_PIOCFG_RESERVED1_SHIFT)
#define  IO_PAD104_PIOCFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD104_PIOCFG_RESERVED1_MASK) | (((uint32_t)val) << IO_PAD104_PIOCFG_RESERVED1_SHIFT))

#define  IO_PAD104_PIOCFG_PD_MASK 0x2000000
#define  IO_PAD104_PIOCFG_PD_SHIFT 25
#define  IO_PAD104_PIOCFG_PD_MASK_SHIFT(reg) (((reg) & IO_PAD104_PIOCFG_PD_MASK) >> IO_PAD104_PIOCFG_PD_SHIFT)
#define  IO_PAD104_PIOCFG_PD_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD104_PIOCFG_PD_MASK) | (((uint32_t)val) << IO_PAD104_PIOCFG_PD_SHIFT))

#define  IO_PAD104_PIOCFG_ODT_EN_MASK 0x1000000
#define  IO_PAD104_PIOCFG_ODT_EN_SHIFT 24
#define  IO_PAD104_PIOCFG_ODT_EN_MASK_SHIFT(reg) (((reg) & IO_PAD104_PIOCFG_ODT_EN_MASK) >> IO_PAD104_PIOCFG_ODT_EN_SHIFT)
#define  IO_PAD104_PIOCFG_ODT_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD104_PIOCFG_ODT_EN_MASK) | (((uint32_t)val) << IO_PAD104_PIOCFG_ODT_EN_SHIFT))

#define  IO_PAD104_PIOCFG_LED_EN_MASK 0x800000
#define  IO_PAD104_PIOCFG_LED_EN_SHIFT 23
#define  IO_PAD104_PIOCFG_LED_EN_MASK_SHIFT(reg) (((reg) & IO_PAD104_PIOCFG_LED_EN_MASK) >> IO_PAD104_PIOCFG_LED_EN_SHIFT)
#define  IO_PAD104_PIOCFG_LED_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD104_PIOCFG_LED_EN_MASK) | (((uint32_t)val) << IO_PAD104_PIOCFG_LED_EN_SHIFT))

#define  IO_PAD104_PIOCFG_I2C_SEL_MASK 0x600000
#define  IO_PAD104_PIOCFG_I2C_SEL_SHIFT 21
#define  IO_PAD104_PIOCFG_I2C_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD104_PIOCFG_I2C_SEL_MASK) >> IO_PAD104_PIOCFG_I2C_SEL_SHIFT)
#define  IO_PAD104_PIOCFG_I2C_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD104_PIOCFG_I2C_SEL_MASK) | (((uint32_t)val) << IO_PAD104_PIOCFG_I2C_SEL_SHIFT))

#define  IO_PAD104_PIOCFG_DGTBSEL_MASK 0x1e0000
#define  IO_PAD104_PIOCFG_DGTBSEL_SHIFT 17
#define  IO_PAD104_PIOCFG_DGTBSEL_MASK_SHIFT(reg) (((reg) & IO_PAD104_PIOCFG_DGTBSEL_MASK) >> IO_PAD104_PIOCFG_DGTBSEL_SHIFT)
#define  IO_PAD104_PIOCFG_DGTBSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD104_PIOCFG_DGTBSEL_MASK) | (((uint32_t)val) << IO_PAD104_PIOCFG_DGTBSEL_SHIFT))

#define  IO_PAD104_PIOCFG_RAWSEL_MASK 0x10000
#define  IO_PAD104_PIOCFG_RAWSEL_SHIFT 16
#define  IO_PAD104_PIOCFG_RAWSEL_MASK_SHIFT(reg) (((reg) & IO_PAD104_PIOCFG_RAWSEL_MASK) >> IO_PAD104_PIOCFG_RAWSEL_SHIFT)
#define  IO_PAD104_PIOCFG_RAWSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD104_PIOCFG_RAWSEL_MASK) | (((uint32_t)val) << IO_PAD104_PIOCFG_RAWSEL_SHIFT))

#define  IO_PAD104_PIOCFG_PULL_SEL_MASK 0x8000
#define  IO_PAD104_PIOCFG_PULL_SEL_SHIFT 15
#define  IO_PAD104_PIOCFG_PULL_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD104_PIOCFG_PULL_SEL_MASK) >> IO_PAD104_PIOCFG_PULL_SEL_SHIFT)
#define  IO_PAD104_PIOCFG_PULL_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD104_PIOCFG_PULL_SEL_MASK) | (((uint32_t)val) << IO_PAD104_PIOCFG_PULL_SEL_SHIFT))

#define  IO_PAD104_PIOCFG_PUEN_MASK 0x4000
#define  IO_PAD104_PIOCFG_PUEN_SHIFT 14
#define  IO_PAD104_PIOCFG_PUEN_MASK_SHIFT(reg) (((reg) & IO_PAD104_PIOCFG_PUEN_MASK) >> IO_PAD104_PIOCFG_PUEN_SHIFT)
#define  IO_PAD104_PIOCFG_PUEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD104_PIOCFG_PUEN_MASK) | (((uint32_t)val) << IO_PAD104_PIOCFG_PUEN_SHIFT))

#define  IO_PAD104_PIOCFG_PDEN_MASK 0x2000
#define  IO_PAD104_PIOCFG_PDEN_SHIFT 13
#define  IO_PAD104_PIOCFG_PDEN_MASK_SHIFT(reg) (((reg) & IO_PAD104_PIOCFG_PDEN_MASK) >> IO_PAD104_PIOCFG_PDEN_SHIFT)
#define  IO_PAD104_PIOCFG_PDEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD104_PIOCFG_PDEN_MASK) | (((uint32_t)val) << IO_PAD104_PIOCFG_PDEN_SHIFT))

#define  IO_PAD104_PIOCFG_SR_MASK 0x1800
#define  IO_PAD104_PIOCFG_SR_SHIFT 11
#define  IO_PAD104_PIOCFG_SR_MASK_SHIFT(reg) (((reg) & IO_PAD104_PIOCFG_SR_MASK) >> IO_PAD104_PIOCFG_SR_SHIFT)
#define  IO_PAD104_PIOCFG_SR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD104_PIOCFG_SR_MASK) | (((uint32_t)val) << IO_PAD104_PIOCFG_SR_SHIFT))

#define  IO_PAD104_PIOCFG_SLP_DI_MASK 0x400
#define  IO_PAD104_PIOCFG_SLP_DI_SHIFT 10
#define  IO_PAD104_PIOCFG_SLP_DI_MASK_SHIFT(reg) (((reg) & IO_PAD104_PIOCFG_SLP_DI_MASK) >> IO_PAD104_PIOCFG_SLP_DI_SHIFT)
#define  IO_PAD104_PIOCFG_SLP_DI_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD104_PIOCFG_SLP_DI_MASK) | (((uint32_t)val) << IO_PAD104_PIOCFG_SLP_DI_SHIFT))

#define  IO_PAD104_PIOCFG_SLP_CNTRL_MASK 0x200
#define  IO_PAD104_PIOCFG_SLP_CNTRL_SHIFT 9
#define  IO_PAD104_PIOCFG_SLP_CNTRL_MASK_SHIFT(reg) (((reg) & IO_PAD104_PIOCFG_SLP_CNTRL_MASK) >> IO_PAD104_PIOCFG_SLP_CNTRL_SHIFT)
#define  IO_PAD104_PIOCFG_SLP_CNTRL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD104_PIOCFG_SLP_CNTRL_MASK) | (((uint32_t)val) << IO_PAD104_PIOCFG_SLP_CNTRL_SHIFT))

#define  IO_PAD104_PIOCFG_SLP_DO_MASK 0x100
#define  IO_PAD104_PIOCFG_SLP_DO_SHIFT 8
#define  IO_PAD104_PIOCFG_SLP_DO_MASK_SHIFT(reg) (((reg) & IO_PAD104_PIOCFG_SLP_DO_MASK) >> IO_PAD104_PIOCFG_SLP_DO_SHIFT)
#define  IO_PAD104_PIOCFG_SLP_DO_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD104_PIOCFG_SLP_DO_MASK) | (((uint32_t)val) << IO_PAD104_PIOCFG_SLP_DO_SHIFT))

#define  IO_PAD104_PIOCFG_SLP_DIR_MASK 0x80
#define  IO_PAD104_PIOCFG_SLP_DIR_SHIFT 7
#define  IO_PAD104_PIOCFG_SLP_DIR_MASK_SHIFT(reg) (((reg) & IO_PAD104_PIOCFG_SLP_DIR_MASK) >> IO_PAD104_PIOCFG_SLP_DIR_SHIFT)
#define  IO_PAD104_PIOCFG_SLP_DIR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD104_PIOCFG_SLP_DIR_MASK) | (((uint32_t)val) << IO_PAD104_PIOCFG_SLP_DIR_SHIFT))

#define  IO_PAD104_PIOCFG_EDGE_EN_N_MASK 0x40
#define  IO_PAD104_PIOCFG_EDGE_EN_N_SHIFT 6
#define  IO_PAD104_PIOCFG_EDGE_EN_N_MASK_SHIFT(reg) (((reg) & IO_PAD104_PIOCFG_EDGE_EN_N_MASK) >> IO_PAD104_PIOCFG_EDGE_EN_N_SHIFT)
#define  IO_PAD104_PIOCFG_EDGE_EN_N_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD104_PIOCFG_EDGE_EN_N_MASK) | (((uint32_t)val) << IO_PAD104_PIOCFG_EDGE_EN_N_SHIFT))

#define  IO_PAD104_PIOCFG_EDGE_FALL_EN_MASK 0x20
#define  IO_PAD104_PIOCFG_EDGE_FALL_EN_SHIFT 5
#define  IO_PAD104_PIOCFG_EDGE_FALL_EN_MASK_SHIFT(reg) (((reg) & IO_PAD104_PIOCFG_EDGE_FALL_EN_MASK) >> IO_PAD104_PIOCFG_EDGE_FALL_EN_SHIFT)
#define  IO_PAD104_PIOCFG_EDGE_FALL_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD104_PIOCFG_EDGE_FALL_EN_MASK) | (((uint32_t)val) << IO_PAD104_PIOCFG_EDGE_FALL_EN_SHIFT))

#define  IO_PAD104_PIOCFG_EDGE_RISE_EN_MASK 0x10
#define  IO_PAD104_PIOCFG_EDGE_RISE_EN_SHIFT 4
#define  IO_PAD104_PIOCFG_EDGE_RISE_EN_MASK_SHIFT(reg) (((reg) & IO_PAD104_PIOCFG_EDGE_RISE_EN_MASK) >> IO_PAD104_PIOCFG_EDGE_RISE_EN_SHIFT)
#define  IO_PAD104_PIOCFG_EDGE_RISE_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD104_PIOCFG_EDGE_RISE_EN_MASK) | (((uint32_t)val) << IO_PAD104_PIOCFG_EDGE_RISE_EN_SHIFT))

#define  IO_PAD104_PIOCFG_SLP_SEL_MASK 0x8
#define  IO_PAD104_PIOCFG_SLP_SEL_SHIFT 3
#define  IO_PAD104_PIOCFG_SLP_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD104_PIOCFG_SLP_SEL_MASK) >> IO_PAD104_PIOCFG_SLP_SEL_SHIFT)
#define  IO_PAD104_PIOCFG_SLP_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD104_PIOCFG_SLP_SEL_MASK) | (((uint32_t)val) << IO_PAD104_PIOCFG_SLP_SEL_SHIFT))

#define  IO_PAD104_PIOCFG_FUNC_SEL_MASK 0x7
#define  IO_PAD104_PIOCFG_FUNC_SEL_SHIFT 0
#define  IO_PAD104_PIOCFG_FUNC_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD104_PIOCFG_FUNC_SEL_MASK) >> IO_PAD104_PIOCFG_FUNC_SEL_SHIFT)
#define  IO_PAD104_PIOCFG_FUNC_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD104_PIOCFG_FUNC_SEL_MASK) | (((uint32_t)val) << IO_PAD104_PIOCFG_FUNC_SEL_SHIFT))

//====================================================================
//
//Register File: IO_PAD105 Configuration Registers (IO_PAD105)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

//====================================================================
//Register: IO_PAD105 Configuration Register (PIOCFG)
/** \brief "PHI_PADXDC_SRC" Pad*/
//====================================================================

#define  IO_PAD105_PIOCFG_RESERVED1_MASK 0xfc000000
#define  IO_PAD105_PIOCFG_RESERVED1_SHIFT 26
#define  IO_PAD105_PIOCFG_RESERVED1_MASK_SHIFT(reg) (((reg) & IO_PAD105_PIOCFG_RESERVED1_MASK) >> IO_PAD105_PIOCFG_RESERVED1_SHIFT)
#define  IO_PAD105_PIOCFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD105_PIOCFG_RESERVED1_MASK) | (((uint32_t)val) << IO_PAD105_PIOCFG_RESERVED1_SHIFT))

#define  IO_PAD105_PIOCFG_PD_MASK 0x2000000
#define  IO_PAD105_PIOCFG_PD_SHIFT 25
#define  IO_PAD105_PIOCFG_PD_MASK_SHIFT(reg) (((reg) & IO_PAD105_PIOCFG_PD_MASK) >> IO_PAD105_PIOCFG_PD_SHIFT)
#define  IO_PAD105_PIOCFG_PD_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD105_PIOCFG_PD_MASK) | (((uint32_t)val) << IO_PAD105_PIOCFG_PD_SHIFT))

#define  IO_PAD105_PIOCFG_ODT_EN_MASK 0x1000000
#define  IO_PAD105_PIOCFG_ODT_EN_SHIFT 24
#define  IO_PAD105_PIOCFG_ODT_EN_MASK_SHIFT(reg) (((reg) & IO_PAD105_PIOCFG_ODT_EN_MASK) >> IO_PAD105_PIOCFG_ODT_EN_SHIFT)
#define  IO_PAD105_PIOCFG_ODT_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD105_PIOCFG_ODT_EN_MASK) | (((uint32_t)val) << IO_PAD105_PIOCFG_ODT_EN_SHIFT))

#define  IO_PAD105_PIOCFG_LED_EN_MASK 0x800000
#define  IO_PAD105_PIOCFG_LED_EN_SHIFT 23
#define  IO_PAD105_PIOCFG_LED_EN_MASK_SHIFT(reg) (((reg) & IO_PAD105_PIOCFG_LED_EN_MASK) >> IO_PAD105_PIOCFG_LED_EN_SHIFT)
#define  IO_PAD105_PIOCFG_LED_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD105_PIOCFG_LED_EN_MASK) | (((uint32_t)val) << IO_PAD105_PIOCFG_LED_EN_SHIFT))

#define  IO_PAD105_PIOCFG_I2C_SEL_MASK 0x600000
#define  IO_PAD105_PIOCFG_I2C_SEL_SHIFT 21
#define  IO_PAD105_PIOCFG_I2C_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD105_PIOCFG_I2C_SEL_MASK) >> IO_PAD105_PIOCFG_I2C_SEL_SHIFT)
#define  IO_PAD105_PIOCFG_I2C_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD105_PIOCFG_I2C_SEL_MASK) | (((uint32_t)val) << IO_PAD105_PIOCFG_I2C_SEL_SHIFT))

#define  IO_PAD105_PIOCFG_DGTBSEL_MASK 0x1e0000
#define  IO_PAD105_PIOCFG_DGTBSEL_SHIFT 17
#define  IO_PAD105_PIOCFG_DGTBSEL_MASK_SHIFT(reg) (((reg) & IO_PAD105_PIOCFG_DGTBSEL_MASK) >> IO_PAD105_PIOCFG_DGTBSEL_SHIFT)
#define  IO_PAD105_PIOCFG_DGTBSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD105_PIOCFG_DGTBSEL_MASK) | (((uint32_t)val) << IO_PAD105_PIOCFG_DGTBSEL_SHIFT))

#define  IO_PAD105_PIOCFG_RAWSEL_MASK 0x10000
#define  IO_PAD105_PIOCFG_RAWSEL_SHIFT 16
#define  IO_PAD105_PIOCFG_RAWSEL_MASK_SHIFT(reg) (((reg) & IO_PAD105_PIOCFG_RAWSEL_MASK) >> IO_PAD105_PIOCFG_RAWSEL_SHIFT)
#define  IO_PAD105_PIOCFG_RAWSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD105_PIOCFG_RAWSEL_MASK) | (((uint32_t)val) << IO_PAD105_PIOCFG_RAWSEL_SHIFT))

#define  IO_PAD105_PIOCFG_PULL_SEL_MASK 0x8000
#define  IO_PAD105_PIOCFG_PULL_SEL_SHIFT 15
#define  IO_PAD105_PIOCFG_PULL_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD105_PIOCFG_PULL_SEL_MASK) >> IO_PAD105_PIOCFG_PULL_SEL_SHIFT)
#define  IO_PAD105_PIOCFG_PULL_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD105_PIOCFG_PULL_SEL_MASK) | (((uint32_t)val) << IO_PAD105_PIOCFG_PULL_SEL_SHIFT))

#define  IO_PAD105_PIOCFG_PUEN_MASK 0x4000
#define  IO_PAD105_PIOCFG_PUEN_SHIFT 14
#define  IO_PAD105_PIOCFG_PUEN_MASK_SHIFT(reg) (((reg) & IO_PAD105_PIOCFG_PUEN_MASK) >> IO_PAD105_PIOCFG_PUEN_SHIFT)
#define  IO_PAD105_PIOCFG_PUEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD105_PIOCFG_PUEN_MASK) | (((uint32_t)val) << IO_PAD105_PIOCFG_PUEN_SHIFT))

#define  IO_PAD105_PIOCFG_PDEN_MASK 0x2000
#define  IO_PAD105_PIOCFG_PDEN_SHIFT 13
#define  IO_PAD105_PIOCFG_PDEN_MASK_SHIFT(reg) (((reg) & IO_PAD105_PIOCFG_PDEN_MASK) >> IO_PAD105_PIOCFG_PDEN_SHIFT)
#define  IO_PAD105_PIOCFG_PDEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD105_PIOCFG_PDEN_MASK) | (((uint32_t)val) << IO_PAD105_PIOCFG_PDEN_SHIFT))

#define  IO_PAD105_PIOCFG_SR_MASK 0x1800
#define  IO_PAD105_PIOCFG_SR_SHIFT 11
#define  IO_PAD105_PIOCFG_SR_MASK_SHIFT(reg) (((reg) & IO_PAD105_PIOCFG_SR_MASK) >> IO_PAD105_PIOCFG_SR_SHIFT)
#define  IO_PAD105_PIOCFG_SR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD105_PIOCFG_SR_MASK) | (((uint32_t)val) << IO_PAD105_PIOCFG_SR_SHIFT))

#define  IO_PAD105_PIOCFG_SLP_DI_MASK 0x400
#define  IO_PAD105_PIOCFG_SLP_DI_SHIFT 10
#define  IO_PAD105_PIOCFG_SLP_DI_MASK_SHIFT(reg) (((reg) & IO_PAD105_PIOCFG_SLP_DI_MASK) >> IO_PAD105_PIOCFG_SLP_DI_SHIFT)
#define  IO_PAD105_PIOCFG_SLP_DI_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD105_PIOCFG_SLP_DI_MASK) | (((uint32_t)val) << IO_PAD105_PIOCFG_SLP_DI_SHIFT))

#define  IO_PAD105_PIOCFG_SLP_CNTRL_MASK 0x200
#define  IO_PAD105_PIOCFG_SLP_CNTRL_SHIFT 9
#define  IO_PAD105_PIOCFG_SLP_CNTRL_MASK_SHIFT(reg) (((reg) & IO_PAD105_PIOCFG_SLP_CNTRL_MASK) >> IO_PAD105_PIOCFG_SLP_CNTRL_SHIFT)
#define  IO_PAD105_PIOCFG_SLP_CNTRL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD105_PIOCFG_SLP_CNTRL_MASK) | (((uint32_t)val) << IO_PAD105_PIOCFG_SLP_CNTRL_SHIFT))

#define  IO_PAD105_PIOCFG_SLP_DO_MASK 0x100
#define  IO_PAD105_PIOCFG_SLP_DO_SHIFT 8
#define  IO_PAD105_PIOCFG_SLP_DO_MASK_SHIFT(reg) (((reg) & IO_PAD105_PIOCFG_SLP_DO_MASK) >> IO_PAD105_PIOCFG_SLP_DO_SHIFT)
#define  IO_PAD105_PIOCFG_SLP_DO_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD105_PIOCFG_SLP_DO_MASK) | (((uint32_t)val) << IO_PAD105_PIOCFG_SLP_DO_SHIFT))

#define  IO_PAD105_PIOCFG_SLP_DIR_MASK 0x80
#define  IO_PAD105_PIOCFG_SLP_DIR_SHIFT 7
#define  IO_PAD105_PIOCFG_SLP_DIR_MASK_SHIFT(reg) (((reg) & IO_PAD105_PIOCFG_SLP_DIR_MASK) >> IO_PAD105_PIOCFG_SLP_DIR_SHIFT)
#define  IO_PAD105_PIOCFG_SLP_DIR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD105_PIOCFG_SLP_DIR_MASK) | (((uint32_t)val) << IO_PAD105_PIOCFG_SLP_DIR_SHIFT))

#define  IO_PAD105_PIOCFG_EDGE_EN_N_MASK 0x40
#define  IO_PAD105_PIOCFG_EDGE_EN_N_SHIFT 6
#define  IO_PAD105_PIOCFG_EDGE_EN_N_MASK_SHIFT(reg) (((reg) & IO_PAD105_PIOCFG_EDGE_EN_N_MASK) >> IO_PAD105_PIOCFG_EDGE_EN_N_SHIFT)
#define  IO_PAD105_PIOCFG_EDGE_EN_N_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD105_PIOCFG_EDGE_EN_N_MASK) | (((uint32_t)val) << IO_PAD105_PIOCFG_EDGE_EN_N_SHIFT))

#define  IO_PAD105_PIOCFG_EDGE_FALL_EN_MASK 0x20
#define  IO_PAD105_PIOCFG_EDGE_FALL_EN_SHIFT 5
#define  IO_PAD105_PIOCFG_EDGE_FALL_EN_MASK_SHIFT(reg) (((reg) & IO_PAD105_PIOCFG_EDGE_FALL_EN_MASK) >> IO_PAD105_PIOCFG_EDGE_FALL_EN_SHIFT)
#define  IO_PAD105_PIOCFG_EDGE_FALL_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD105_PIOCFG_EDGE_FALL_EN_MASK) | (((uint32_t)val) << IO_PAD105_PIOCFG_EDGE_FALL_EN_SHIFT))

#define  IO_PAD105_PIOCFG_EDGE_RISE_EN_MASK 0x10
#define  IO_PAD105_PIOCFG_EDGE_RISE_EN_SHIFT 4
#define  IO_PAD105_PIOCFG_EDGE_RISE_EN_MASK_SHIFT(reg) (((reg) & IO_PAD105_PIOCFG_EDGE_RISE_EN_MASK) >> IO_PAD105_PIOCFG_EDGE_RISE_EN_SHIFT)
#define  IO_PAD105_PIOCFG_EDGE_RISE_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD105_PIOCFG_EDGE_RISE_EN_MASK) | (((uint32_t)val) << IO_PAD105_PIOCFG_EDGE_RISE_EN_SHIFT))

#define  IO_PAD105_PIOCFG_SLP_SEL_MASK 0x8
#define  IO_PAD105_PIOCFG_SLP_SEL_SHIFT 3
#define  IO_PAD105_PIOCFG_SLP_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD105_PIOCFG_SLP_SEL_MASK) >> IO_PAD105_PIOCFG_SLP_SEL_SHIFT)
#define  IO_PAD105_PIOCFG_SLP_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD105_PIOCFG_SLP_SEL_MASK) | (((uint32_t)val) << IO_PAD105_PIOCFG_SLP_SEL_SHIFT))

#define  IO_PAD105_PIOCFG_FUNC_SEL_MASK 0x7
#define  IO_PAD105_PIOCFG_FUNC_SEL_SHIFT 0
#define  IO_PAD105_PIOCFG_FUNC_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD105_PIOCFG_FUNC_SEL_MASK) >> IO_PAD105_PIOCFG_FUNC_SEL_SHIFT)
#define  IO_PAD105_PIOCFG_FUNC_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD105_PIOCFG_FUNC_SEL_MASK) | (((uint32_t)val) << IO_PAD105_PIOCFG_FUNC_SEL_SHIFT))

//====================================================================
//
//Register File: IO_PAD106 Configuration Registers (IO_PAD106)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

//====================================================================
//Register: IO_PAD106 Configuration Register (PIOCFG)
/** \brief "PHI_PADXDC_SRC" Pad*/
//====================================================================

#define  IO_PAD106_PIOCFG_RESERVED1_MASK 0xfc000000
#define  IO_PAD106_PIOCFG_RESERVED1_SHIFT 26
#define  IO_PAD106_PIOCFG_RESERVED1_MASK_SHIFT(reg) (((reg) & IO_PAD106_PIOCFG_RESERVED1_MASK) >> IO_PAD106_PIOCFG_RESERVED1_SHIFT)
#define  IO_PAD106_PIOCFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD106_PIOCFG_RESERVED1_MASK) | (((uint32_t)val) << IO_PAD106_PIOCFG_RESERVED1_SHIFT))

#define  IO_PAD106_PIOCFG_PD_MASK 0x2000000
#define  IO_PAD106_PIOCFG_PD_SHIFT 25
#define  IO_PAD106_PIOCFG_PD_MASK_SHIFT(reg) (((reg) & IO_PAD106_PIOCFG_PD_MASK) >> IO_PAD106_PIOCFG_PD_SHIFT)
#define  IO_PAD106_PIOCFG_PD_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD106_PIOCFG_PD_MASK) | (((uint32_t)val) << IO_PAD106_PIOCFG_PD_SHIFT))

#define  IO_PAD106_PIOCFG_ODT_EN_MASK 0x1000000
#define  IO_PAD106_PIOCFG_ODT_EN_SHIFT 24
#define  IO_PAD106_PIOCFG_ODT_EN_MASK_SHIFT(reg) (((reg) & IO_PAD106_PIOCFG_ODT_EN_MASK) >> IO_PAD106_PIOCFG_ODT_EN_SHIFT)
#define  IO_PAD106_PIOCFG_ODT_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD106_PIOCFG_ODT_EN_MASK) | (((uint32_t)val) << IO_PAD106_PIOCFG_ODT_EN_SHIFT))

#define  IO_PAD106_PIOCFG_LED_EN_MASK 0x800000
#define  IO_PAD106_PIOCFG_LED_EN_SHIFT 23
#define  IO_PAD106_PIOCFG_LED_EN_MASK_SHIFT(reg) (((reg) & IO_PAD106_PIOCFG_LED_EN_MASK) >> IO_PAD106_PIOCFG_LED_EN_SHIFT)
#define  IO_PAD106_PIOCFG_LED_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD106_PIOCFG_LED_EN_MASK) | (((uint32_t)val) << IO_PAD106_PIOCFG_LED_EN_SHIFT))

#define  IO_PAD106_PIOCFG_I2C_SEL_MASK 0x600000
#define  IO_PAD106_PIOCFG_I2C_SEL_SHIFT 21
#define  IO_PAD106_PIOCFG_I2C_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD106_PIOCFG_I2C_SEL_MASK) >> IO_PAD106_PIOCFG_I2C_SEL_SHIFT)
#define  IO_PAD106_PIOCFG_I2C_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD106_PIOCFG_I2C_SEL_MASK) | (((uint32_t)val) << IO_PAD106_PIOCFG_I2C_SEL_SHIFT))

#define  IO_PAD106_PIOCFG_DGTBSEL_MASK 0x1e0000
#define  IO_PAD106_PIOCFG_DGTBSEL_SHIFT 17
#define  IO_PAD106_PIOCFG_DGTBSEL_MASK_SHIFT(reg) (((reg) & IO_PAD106_PIOCFG_DGTBSEL_MASK) >> IO_PAD106_PIOCFG_DGTBSEL_SHIFT)
#define  IO_PAD106_PIOCFG_DGTBSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD106_PIOCFG_DGTBSEL_MASK) | (((uint32_t)val) << IO_PAD106_PIOCFG_DGTBSEL_SHIFT))

#define  IO_PAD106_PIOCFG_RAWSEL_MASK 0x10000
#define  IO_PAD106_PIOCFG_RAWSEL_SHIFT 16
#define  IO_PAD106_PIOCFG_RAWSEL_MASK_SHIFT(reg) (((reg) & IO_PAD106_PIOCFG_RAWSEL_MASK) >> IO_PAD106_PIOCFG_RAWSEL_SHIFT)
#define  IO_PAD106_PIOCFG_RAWSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD106_PIOCFG_RAWSEL_MASK) | (((uint32_t)val) << IO_PAD106_PIOCFG_RAWSEL_SHIFT))

#define  IO_PAD106_PIOCFG_PULL_SEL_MASK 0x8000
#define  IO_PAD106_PIOCFG_PULL_SEL_SHIFT 15
#define  IO_PAD106_PIOCFG_PULL_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD106_PIOCFG_PULL_SEL_MASK) >> IO_PAD106_PIOCFG_PULL_SEL_SHIFT)
#define  IO_PAD106_PIOCFG_PULL_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD106_PIOCFG_PULL_SEL_MASK) | (((uint32_t)val) << IO_PAD106_PIOCFG_PULL_SEL_SHIFT))

#define  IO_PAD106_PIOCFG_PUEN_MASK 0x4000
#define  IO_PAD106_PIOCFG_PUEN_SHIFT 14
#define  IO_PAD106_PIOCFG_PUEN_MASK_SHIFT(reg) (((reg) & IO_PAD106_PIOCFG_PUEN_MASK) >> IO_PAD106_PIOCFG_PUEN_SHIFT)
#define  IO_PAD106_PIOCFG_PUEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD106_PIOCFG_PUEN_MASK) | (((uint32_t)val) << IO_PAD106_PIOCFG_PUEN_SHIFT))

#define  IO_PAD106_PIOCFG_PDEN_MASK 0x2000
#define  IO_PAD106_PIOCFG_PDEN_SHIFT 13
#define  IO_PAD106_PIOCFG_PDEN_MASK_SHIFT(reg) (((reg) & IO_PAD106_PIOCFG_PDEN_MASK) >> IO_PAD106_PIOCFG_PDEN_SHIFT)
#define  IO_PAD106_PIOCFG_PDEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD106_PIOCFG_PDEN_MASK) | (((uint32_t)val) << IO_PAD106_PIOCFG_PDEN_SHIFT))

#define  IO_PAD106_PIOCFG_SR_MASK 0x1800
#define  IO_PAD106_PIOCFG_SR_SHIFT 11
#define  IO_PAD106_PIOCFG_SR_MASK_SHIFT(reg) (((reg) & IO_PAD106_PIOCFG_SR_MASK) >> IO_PAD106_PIOCFG_SR_SHIFT)
#define  IO_PAD106_PIOCFG_SR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD106_PIOCFG_SR_MASK) | (((uint32_t)val) << IO_PAD106_PIOCFG_SR_SHIFT))

#define  IO_PAD106_PIOCFG_SLP_DI_MASK 0x400
#define  IO_PAD106_PIOCFG_SLP_DI_SHIFT 10
#define  IO_PAD106_PIOCFG_SLP_DI_MASK_SHIFT(reg) (((reg) & IO_PAD106_PIOCFG_SLP_DI_MASK) >> IO_PAD106_PIOCFG_SLP_DI_SHIFT)
#define  IO_PAD106_PIOCFG_SLP_DI_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD106_PIOCFG_SLP_DI_MASK) | (((uint32_t)val) << IO_PAD106_PIOCFG_SLP_DI_SHIFT))

#define  IO_PAD106_PIOCFG_SLP_CNTRL_MASK 0x200
#define  IO_PAD106_PIOCFG_SLP_CNTRL_SHIFT 9
#define  IO_PAD106_PIOCFG_SLP_CNTRL_MASK_SHIFT(reg) (((reg) & IO_PAD106_PIOCFG_SLP_CNTRL_MASK) >> IO_PAD106_PIOCFG_SLP_CNTRL_SHIFT)
#define  IO_PAD106_PIOCFG_SLP_CNTRL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD106_PIOCFG_SLP_CNTRL_MASK) | (((uint32_t)val) << IO_PAD106_PIOCFG_SLP_CNTRL_SHIFT))

#define  IO_PAD106_PIOCFG_SLP_DO_MASK 0x100
#define  IO_PAD106_PIOCFG_SLP_DO_SHIFT 8
#define  IO_PAD106_PIOCFG_SLP_DO_MASK_SHIFT(reg) (((reg) & IO_PAD106_PIOCFG_SLP_DO_MASK) >> IO_PAD106_PIOCFG_SLP_DO_SHIFT)
#define  IO_PAD106_PIOCFG_SLP_DO_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD106_PIOCFG_SLP_DO_MASK) | (((uint32_t)val) << IO_PAD106_PIOCFG_SLP_DO_SHIFT))

#define  IO_PAD106_PIOCFG_SLP_DIR_MASK 0x80
#define  IO_PAD106_PIOCFG_SLP_DIR_SHIFT 7
#define  IO_PAD106_PIOCFG_SLP_DIR_MASK_SHIFT(reg) (((reg) & IO_PAD106_PIOCFG_SLP_DIR_MASK) >> IO_PAD106_PIOCFG_SLP_DIR_SHIFT)
#define  IO_PAD106_PIOCFG_SLP_DIR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD106_PIOCFG_SLP_DIR_MASK) | (((uint32_t)val) << IO_PAD106_PIOCFG_SLP_DIR_SHIFT))

#define  IO_PAD106_PIOCFG_EDGE_EN_N_MASK 0x40
#define  IO_PAD106_PIOCFG_EDGE_EN_N_SHIFT 6
#define  IO_PAD106_PIOCFG_EDGE_EN_N_MASK_SHIFT(reg) (((reg) & IO_PAD106_PIOCFG_EDGE_EN_N_MASK) >> IO_PAD106_PIOCFG_EDGE_EN_N_SHIFT)
#define  IO_PAD106_PIOCFG_EDGE_EN_N_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD106_PIOCFG_EDGE_EN_N_MASK) | (((uint32_t)val) << IO_PAD106_PIOCFG_EDGE_EN_N_SHIFT))

#define  IO_PAD106_PIOCFG_EDGE_FALL_EN_MASK 0x20
#define  IO_PAD106_PIOCFG_EDGE_FALL_EN_SHIFT 5
#define  IO_PAD106_PIOCFG_EDGE_FALL_EN_MASK_SHIFT(reg) (((reg) & IO_PAD106_PIOCFG_EDGE_FALL_EN_MASK) >> IO_PAD106_PIOCFG_EDGE_FALL_EN_SHIFT)
#define  IO_PAD106_PIOCFG_EDGE_FALL_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD106_PIOCFG_EDGE_FALL_EN_MASK) | (((uint32_t)val) << IO_PAD106_PIOCFG_EDGE_FALL_EN_SHIFT))

#define  IO_PAD106_PIOCFG_EDGE_RISE_EN_MASK 0x10
#define  IO_PAD106_PIOCFG_EDGE_RISE_EN_SHIFT 4
#define  IO_PAD106_PIOCFG_EDGE_RISE_EN_MASK_SHIFT(reg) (((reg) & IO_PAD106_PIOCFG_EDGE_RISE_EN_MASK) >> IO_PAD106_PIOCFG_EDGE_RISE_EN_SHIFT)
#define  IO_PAD106_PIOCFG_EDGE_RISE_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD106_PIOCFG_EDGE_RISE_EN_MASK) | (((uint32_t)val) << IO_PAD106_PIOCFG_EDGE_RISE_EN_SHIFT))

#define  IO_PAD106_PIOCFG_SLP_SEL_MASK 0x8
#define  IO_PAD106_PIOCFG_SLP_SEL_SHIFT 3
#define  IO_PAD106_PIOCFG_SLP_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD106_PIOCFG_SLP_SEL_MASK) >> IO_PAD106_PIOCFG_SLP_SEL_SHIFT)
#define  IO_PAD106_PIOCFG_SLP_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD106_PIOCFG_SLP_SEL_MASK) | (((uint32_t)val) << IO_PAD106_PIOCFG_SLP_SEL_SHIFT))

#define  IO_PAD106_PIOCFG_FUNC_SEL_MASK 0x7
#define  IO_PAD106_PIOCFG_FUNC_SEL_SHIFT 0
#define  IO_PAD106_PIOCFG_FUNC_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD106_PIOCFG_FUNC_SEL_MASK) >> IO_PAD106_PIOCFG_FUNC_SEL_SHIFT)
#define  IO_PAD106_PIOCFG_FUNC_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD106_PIOCFG_FUNC_SEL_MASK) | (((uint32_t)val) << IO_PAD106_PIOCFG_FUNC_SEL_SHIFT))

//====================================================================
//
//Register File: IO_PAD107 Configuration Registers (IO_PAD107)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

//====================================================================
//Register: IO_PAD107 Configuration Register (PIOCFG)
/** \brief "PHI_PADXDC_SRC" Pad*/
//====================================================================

#define  IO_PAD107_PIOCFG_RESERVED1_MASK 0xfc000000
#define  IO_PAD107_PIOCFG_RESERVED1_SHIFT 26
#define  IO_PAD107_PIOCFG_RESERVED1_MASK_SHIFT(reg) (((reg) & IO_PAD107_PIOCFG_RESERVED1_MASK) >> IO_PAD107_PIOCFG_RESERVED1_SHIFT)
#define  IO_PAD107_PIOCFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD107_PIOCFG_RESERVED1_MASK) | (((uint32_t)val) << IO_PAD107_PIOCFG_RESERVED1_SHIFT))

#define  IO_PAD107_PIOCFG_PD_MASK 0x2000000
#define  IO_PAD107_PIOCFG_PD_SHIFT 25
#define  IO_PAD107_PIOCFG_PD_MASK_SHIFT(reg) (((reg) & IO_PAD107_PIOCFG_PD_MASK) >> IO_PAD107_PIOCFG_PD_SHIFT)
#define  IO_PAD107_PIOCFG_PD_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD107_PIOCFG_PD_MASK) | (((uint32_t)val) << IO_PAD107_PIOCFG_PD_SHIFT))

#define  IO_PAD107_PIOCFG_ODT_EN_MASK 0x1000000
#define  IO_PAD107_PIOCFG_ODT_EN_SHIFT 24
#define  IO_PAD107_PIOCFG_ODT_EN_MASK_SHIFT(reg) (((reg) & IO_PAD107_PIOCFG_ODT_EN_MASK) >> IO_PAD107_PIOCFG_ODT_EN_SHIFT)
#define  IO_PAD107_PIOCFG_ODT_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD107_PIOCFG_ODT_EN_MASK) | (((uint32_t)val) << IO_PAD107_PIOCFG_ODT_EN_SHIFT))

#define  IO_PAD107_PIOCFG_LED_EN_MASK 0x800000
#define  IO_PAD107_PIOCFG_LED_EN_SHIFT 23
#define  IO_PAD107_PIOCFG_LED_EN_MASK_SHIFT(reg) (((reg) & IO_PAD107_PIOCFG_LED_EN_MASK) >> IO_PAD107_PIOCFG_LED_EN_SHIFT)
#define  IO_PAD107_PIOCFG_LED_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD107_PIOCFG_LED_EN_MASK) | (((uint32_t)val) << IO_PAD107_PIOCFG_LED_EN_SHIFT))

#define  IO_PAD107_PIOCFG_I2C_SEL_MASK 0x600000
#define  IO_PAD107_PIOCFG_I2C_SEL_SHIFT 21
#define  IO_PAD107_PIOCFG_I2C_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD107_PIOCFG_I2C_SEL_MASK) >> IO_PAD107_PIOCFG_I2C_SEL_SHIFT)
#define  IO_PAD107_PIOCFG_I2C_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD107_PIOCFG_I2C_SEL_MASK) | (((uint32_t)val) << IO_PAD107_PIOCFG_I2C_SEL_SHIFT))

#define  IO_PAD107_PIOCFG_DGTBSEL_MASK 0x1e0000
#define  IO_PAD107_PIOCFG_DGTBSEL_SHIFT 17
#define  IO_PAD107_PIOCFG_DGTBSEL_MASK_SHIFT(reg) (((reg) & IO_PAD107_PIOCFG_DGTBSEL_MASK) >> IO_PAD107_PIOCFG_DGTBSEL_SHIFT)
#define  IO_PAD107_PIOCFG_DGTBSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD107_PIOCFG_DGTBSEL_MASK) | (((uint32_t)val) << IO_PAD107_PIOCFG_DGTBSEL_SHIFT))

#define  IO_PAD107_PIOCFG_RAWSEL_MASK 0x10000
#define  IO_PAD107_PIOCFG_RAWSEL_SHIFT 16
#define  IO_PAD107_PIOCFG_RAWSEL_MASK_SHIFT(reg) (((reg) & IO_PAD107_PIOCFG_RAWSEL_MASK) >> IO_PAD107_PIOCFG_RAWSEL_SHIFT)
#define  IO_PAD107_PIOCFG_RAWSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD107_PIOCFG_RAWSEL_MASK) | (((uint32_t)val) << IO_PAD107_PIOCFG_RAWSEL_SHIFT))

#define  IO_PAD107_PIOCFG_PULL_SEL_MASK 0x8000
#define  IO_PAD107_PIOCFG_PULL_SEL_SHIFT 15
#define  IO_PAD107_PIOCFG_PULL_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD107_PIOCFG_PULL_SEL_MASK) >> IO_PAD107_PIOCFG_PULL_SEL_SHIFT)
#define  IO_PAD107_PIOCFG_PULL_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD107_PIOCFG_PULL_SEL_MASK) | (((uint32_t)val) << IO_PAD107_PIOCFG_PULL_SEL_SHIFT))

#define  IO_PAD107_PIOCFG_PUEN_MASK 0x4000
#define  IO_PAD107_PIOCFG_PUEN_SHIFT 14
#define  IO_PAD107_PIOCFG_PUEN_MASK_SHIFT(reg) (((reg) & IO_PAD107_PIOCFG_PUEN_MASK) >> IO_PAD107_PIOCFG_PUEN_SHIFT)
#define  IO_PAD107_PIOCFG_PUEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD107_PIOCFG_PUEN_MASK) | (((uint32_t)val) << IO_PAD107_PIOCFG_PUEN_SHIFT))

#define  IO_PAD107_PIOCFG_PDEN_MASK 0x2000
#define  IO_PAD107_PIOCFG_PDEN_SHIFT 13
#define  IO_PAD107_PIOCFG_PDEN_MASK_SHIFT(reg) (((reg) & IO_PAD107_PIOCFG_PDEN_MASK) >> IO_PAD107_PIOCFG_PDEN_SHIFT)
#define  IO_PAD107_PIOCFG_PDEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD107_PIOCFG_PDEN_MASK) | (((uint32_t)val) << IO_PAD107_PIOCFG_PDEN_SHIFT))

#define  IO_PAD107_PIOCFG_SR_MASK 0x1800
#define  IO_PAD107_PIOCFG_SR_SHIFT 11
#define  IO_PAD107_PIOCFG_SR_MASK_SHIFT(reg) (((reg) & IO_PAD107_PIOCFG_SR_MASK) >> IO_PAD107_PIOCFG_SR_SHIFT)
#define  IO_PAD107_PIOCFG_SR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD107_PIOCFG_SR_MASK) | (((uint32_t)val) << IO_PAD107_PIOCFG_SR_SHIFT))

#define  IO_PAD107_PIOCFG_SLP_DI_MASK 0x400
#define  IO_PAD107_PIOCFG_SLP_DI_SHIFT 10
#define  IO_PAD107_PIOCFG_SLP_DI_MASK_SHIFT(reg) (((reg) & IO_PAD107_PIOCFG_SLP_DI_MASK) >> IO_PAD107_PIOCFG_SLP_DI_SHIFT)
#define  IO_PAD107_PIOCFG_SLP_DI_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD107_PIOCFG_SLP_DI_MASK) | (((uint32_t)val) << IO_PAD107_PIOCFG_SLP_DI_SHIFT))

#define  IO_PAD107_PIOCFG_SLP_CNTRL_MASK 0x200
#define  IO_PAD107_PIOCFG_SLP_CNTRL_SHIFT 9
#define  IO_PAD107_PIOCFG_SLP_CNTRL_MASK_SHIFT(reg) (((reg) & IO_PAD107_PIOCFG_SLP_CNTRL_MASK) >> IO_PAD107_PIOCFG_SLP_CNTRL_SHIFT)
#define  IO_PAD107_PIOCFG_SLP_CNTRL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD107_PIOCFG_SLP_CNTRL_MASK) | (((uint32_t)val) << IO_PAD107_PIOCFG_SLP_CNTRL_SHIFT))

#define  IO_PAD107_PIOCFG_SLP_DO_MASK 0x100
#define  IO_PAD107_PIOCFG_SLP_DO_SHIFT 8
#define  IO_PAD107_PIOCFG_SLP_DO_MASK_SHIFT(reg) (((reg) & IO_PAD107_PIOCFG_SLP_DO_MASK) >> IO_PAD107_PIOCFG_SLP_DO_SHIFT)
#define  IO_PAD107_PIOCFG_SLP_DO_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD107_PIOCFG_SLP_DO_MASK) | (((uint32_t)val) << IO_PAD107_PIOCFG_SLP_DO_SHIFT))

#define  IO_PAD107_PIOCFG_SLP_DIR_MASK 0x80
#define  IO_PAD107_PIOCFG_SLP_DIR_SHIFT 7
#define  IO_PAD107_PIOCFG_SLP_DIR_MASK_SHIFT(reg) (((reg) & IO_PAD107_PIOCFG_SLP_DIR_MASK) >> IO_PAD107_PIOCFG_SLP_DIR_SHIFT)
#define  IO_PAD107_PIOCFG_SLP_DIR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD107_PIOCFG_SLP_DIR_MASK) | (((uint32_t)val) << IO_PAD107_PIOCFG_SLP_DIR_SHIFT))

#define  IO_PAD107_PIOCFG_EDGE_EN_N_MASK 0x40
#define  IO_PAD107_PIOCFG_EDGE_EN_N_SHIFT 6
#define  IO_PAD107_PIOCFG_EDGE_EN_N_MASK_SHIFT(reg) (((reg) & IO_PAD107_PIOCFG_EDGE_EN_N_MASK) >> IO_PAD107_PIOCFG_EDGE_EN_N_SHIFT)
#define  IO_PAD107_PIOCFG_EDGE_EN_N_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD107_PIOCFG_EDGE_EN_N_MASK) | (((uint32_t)val) << IO_PAD107_PIOCFG_EDGE_EN_N_SHIFT))

#define  IO_PAD107_PIOCFG_EDGE_FALL_EN_MASK 0x20
#define  IO_PAD107_PIOCFG_EDGE_FALL_EN_SHIFT 5
#define  IO_PAD107_PIOCFG_EDGE_FALL_EN_MASK_SHIFT(reg) (((reg) & IO_PAD107_PIOCFG_EDGE_FALL_EN_MASK) >> IO_PAD107_PIOCFG_EDGE_FALL_EN_SHIFT)
#define  IO_PAD107_PIOCFG_EDGE_FALL_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD107_PIOCFG_EDGE_FALL_EN_MASK) | (((uint32_t)val) << IO_PAD107_PIOCFG_EDGE_FALL_EN_SHIFT))

#define  IO_PAD107_PIOCFG_EDGE_RISE_EN_MASK 0x10
#define  IO_PAD107_PIOCFG_EDGE_RISE_EN_SHIFT 4
#define  IO_PAD107_PIOCFG_EDGE_RISE_EN_MASK_SHIFT(reg) (((reg) & IO_PAD107_PIOCFG_EDGE_RISE_EN_MASK) >> IO_PAD107_PIOCFG_EDGE_RISE_EN_SHIFT)
#define  IO_PAD107_PIOCFG_EDGE_RISE_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD107_PIOCFG_EDGE_RISE_EN_MASK) | (((uint32_t)val) << IO_PAD107_PIOCFG_EDGE_RISE_EN_SHIFT))

#define  IO_PAD107_PIOCFG_SLP_SEL_MASK 0x8
#define  IO_PAD107_PIOCFG_SLP_SEL_SHIFT 3
#define  IO_PAD107_PIOCFG_SLP_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD107_PIOCFG_SLP_SEL_MASK) >> IO_PAD107_PIOCFG_SLP_SEL_SHIFT)
#define  IO_PAD107_PIOCFG_SLP_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD107_PIOCFG_SLP_SEL_MASK) | (((uint32_t)val) << IO_PAD107_PIOCFG_SLP_SEL_SHIFT))

#define  IO_PAD107_PIOCFG_FUNC_SEL_MASK 0x7
#define  IO_PAD107_PIOCFG_FUNC_SEL_SHIFT 0
#define  IO_PAD107_PIOCFG_FUNC_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD107_PIOCFG_FUNC_SEL_MASK) >> IO_PAD107_PIOCFG_FUNC_SEL_SHIFT)
#define  IO_PAD107_PIOCFG_FUNC_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD107_PIOCFG_FUNC_SEL_MASK) | (((uint32_t)val) << IO_PAD107_PIOCFG_FUNC_SEL_SHIFT))

//====================================================================
//
//Register File: IO_PAD108 Configuration Registers (IO_PAD108)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

//====================================================================
//Register: IO_PAD108 Configuration Register (PIOCFG)
/** \brief "PHI_PADXDC_SRC" Pad*/
//====================================================================

#define  IO_PAD108_PIOCFG_RESERVED1_MASK 0xfc000000
#define  IO_PAD108_PIOCFG_RESERVED1_SHIFT 26
#define  IO_PAD108_PIOCFG_RESERVED1_MASK_SHIFT(reg) (((reg) & IO_PAD108_PIOCFG_RESERVED1_MASK) >> IO_PAD108_PIOCFG_RESERVED1_SHIFT)
#define  IO_PAD108_PIOCFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD108_PIOCFG_RESERVED1_MASK) | (((uint32_t)val) << IO_PAD108_PIOCFG_RESERVED1_SHIFT))

#define  IO_PAD108_PIOCFG_PD_MASK 0x2000000
#define  IO_PAD108_PIOCFG_PD_SHIFT 25
#define  IO_PAD108_PIOCFG_PD_MASK_SHIFT(reg) (((reg) & IO_PAD108_PIOCFG_PD_MASK) >> IO_PAD108_PIOCFG_PD_SHIFT)
#define  IO_PAD108_PIOCFG_PD_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD108_PIOCFG_PD_MASK) | (((uint32_t)val) << IO_PAD108_PIOCFG_PD_SHIFT))

#define  IO_PAD108_PIOCFG_ODT_EN_MASK 0x1000000
#define  IO_PAD108_PIOCFG_ODT_EN_SHIFT 24
#define  IO_PAD108_PIOCFG_ODT_EN_MASK_SHIFT(reg) (((reg) & IO_PAD108_PIOCFG_ODT_EN_MASK) >> IO_PAD108_PIOCFG_ODT_EN_SHIFT)
#define  IO_PAD108_PIOCFG_ODT_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD108_PIOCFG_ODT_EN_MASK) | (((uint32_t)val) << IO_PAD108_PIOCFG_ODT_EN_SHIFT))

#define  IO_PAD108_PIOCFG_LED_EN_MASK 0x800000
#define  IO_PAD108_PIOCFG_LED_EN_SHIFT 23
#define  IO_PAD108_PIOCFG_LED_EN_MASK_SHIFT(reg) (((reg) & IO_PAD108_PIOCFG_LED_EN_MASK) >> IO_PAD108_PIOCFG_LED_EN_SHIFT)
#define  IO_PAD108_PIOCFG_LED_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD108_PIOCFG_LED_EN_MASK) | (((uint32_t)val) << IO_PAD108_PIOCFG_LED_EN_SHIFT))

#define  IO_PAD108_PIOCFG_I2C_SEL_MASK 0x600000
#define  IO_PAD108_PIOCFG_I2C_SEL_SHIFT 21
#define  IO_PAD108_PIOCFG_I2C_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD108_PIOCFG_I2C_SEL_MASK) >> IO_PAD108_PIOCFG_I2C_SEL_SHIFT)
#define  IO_PAD108_PIOCFG_I2C_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD108_PIOCFG_I2C_SEL_MASK) | (((uint32_t)val) << IO_PAD108_PIOCFG_I2C_SEL_SHIFT))

#define  IO_PAD108_PIOCFG_DGTBSEL_MASK 0x1e0000
#define  IO_PAD108_PIOCFG_DGTBSEL_SHIFT 17
#define  IO_PAD108_PIOCFG_DGTBSEL_MASK_SHIFT(reg) (((reg) & IO_PAD108_PIOCFG_DGTBSEL_MASK) >> IO_PAD108_PIOCFG_DGTBSEL_SHIFT)
#define  IO_PAD108_PIOCFG_DGTBSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD108_PIOCFG_DGTBSEL_MASK) | (((uint32_t)val) << IO_PAD108_PIOCFG_DGTBSEL_SHIFT))

#define  IO_PAD108_PIOCFG_RAWSEL_MASK 0x10000
#define  IO_PAD108_PIOCFG_RAWSEL_SHIFT 16
#define  IO_PAD108_PIOCFG_RAWSEL_MASK_SHIFT(reg) (((reg) & IO_PAD108_PIOCFG_RAWSEL_MASK) >> IO_PAD108_PIOCFG_RAWSEL_SHIFT)
#define  IO_PAD108_PIOCFG_RAWSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD108_PIOCFG_RAWSEL_MASK) | (((uint32_t)val) << IO_PAD108_PIOCFG_RAWSEL_SHIFT))

#define  IO_PAD108_PIOCFG_PULL_SEL_MASK 0x8000
#define  IO_PAD108_PIOCFG_PULL_SEL_SHIFT 15
#define  IO_PAD108_PIOCFG_PULL_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD108_PIOCFG_PULL_SEL_MASK) >> IO_PAD108_PIOCFG_PULL_SEL_SHIFT)
#define  IO_PAD108_PIOCFG_PULL_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD108_PIOCFG_PULL_SEL_MASK) | (((uint32_t)val) << IO_PAD108_PIOCFG_PULL_SEL_SHIFT))

#define  IO_PAD108_PIOCFG_PUEN_MASK 0x4000
#define  IO_PAD108_PIOCFG_PUEN_SHIFT 14
#define  IO_PAD108_PIOCFG_PUEN_MASK_SHIFT(reg) (((reg) & IO_PAD108_PIOCFG_PUEN_MASK) >> IO_PAD108_PIOCFG_PUEN_SHIFT)
#define  IO_PAD108_PIOCFG_PUEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD108_PIOCFG_PUEN_MASK) | (((uint32_t)val) << IO_PAD108_PIOCFG_PUEN_SHIFT))

#define  IO_PAD108_PIOCFG_PDEN_MASK 0x2000
#define  IO_PAD108_PIOCFG_PDEN_SHIFT 13
#define  IO_PAD108_PIOCFG_PDEN_MASK_SHIFT(reg) (((reg) & IO_PAD108_PIOCFG_PDEN_MASK) >> IO_PAD108_PIOCFG_PDEN_SHIFT)
#define  IO_PAD108_PIOCFG_PDEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD108_PIOCFG_PDEN_MASK) | (((uint32_t)val) << IO_PAD108_PIOCFG_PDEN_SHIFT))

#define  IO_PAD108_PIOCFG_SR_MASK 0x1800
#define  IO_PAD108_PIOCFG_SR_SHIFT 11
#define  IO_PAD108_PIOCFG_SR_MASK_SHIFT(reg) (((reg) & IO_PAD108_PIOCFG_SR_MASK) >> IO_PAD108_PIOCFG_SR_SHIFT)
#define  IO_PAD108_PIOCFG_SR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD108_PIOCFG_SR_MASK) | (((uint32_t)val) << IO_PAD108_PIOCFG_SR_SHIFT))

#define  IO_PAD108_PIOCFG_SLP_DI_MASK 0x400
#define  IO_PAD108_PIOCFG_SLP_DI_SHIFT 10
#define  IO_PAD108_PIOCFG_SLP_DI_MASK_SHIFT(reg) (((reg) & IO_PAD108_PIOCFG_SLP_DI_MASK) >> IO_PAD108_PIOCFG_SLP_DI_SHIFT)
#define  IO_PAD108_PIOCFG_SLP_DI_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD108_PIOCFG_SLP_DI_MASK) | (((uint32_t)val) << IO_PAD108_PIOCFG_SLP_DI_SHIFT))

#define  IO_PAD108_PIOCFG_SLP_CNTRL_MASK 0x200
#define  IO_PAD108_PIOCFG_SLP_CNTRL_SHIFT 9
#define  IO_PAD108_PIOCFG_SLP_CNTRL_MASK_SHIFT(reg) (((reg) & IO_PAD108_PIOCFG_SLP_CNTRL_MASK) >> IO_PAD108_PIOCFG_SLP_CNTRL_SHIFT)
#define  IO_PAD108_PIOCFG_SLP_CNTRL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD108_PIOCFG_SLP_CNTRL_MASK) | (((uint32_t)val) << IO_PAD108_PIOCFG_SLP_CNTRL_SHIFT))

#define  IO_PAD108_PIOCFG_SLP_DO_MASK 0x100
#define  IO_PAD108_PIOCFG_SLP_DO_SHIFT 8
#define  IO_PAD108_PIOCFG_SLP_DO_MASK_SHIFT(reg) (((reg) & IO_PAD108_PIOCFG_SLP_DO_MASK) >> IO_PAD108_PIOCFG_SLP_DO_SHIFT)
#define  IO_PAD108_PIOCFG_SLP_DO_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD108_PIOCFG_SLP_DO_MASK) | (((uint32_t)val) << IO_PAD108_PIOCFG_SLP_DO_SHIFT))

#define  IO_PAD108_PIOCFG_SLP_DIR_MASK 0x80
#define  IO_PAD108_PIOCFG_SLP_DIR_SHIFT 7
#define  IO_PAD108_PIOCFG_SLP_DIR_MASK_SHIFT(reg) (((reg) & IO_PAD108_PIOCFG_SLP_DIR_MASK) >> IO_PAD108_PIOCFG_SLP_DIR_SHIFT)
#define  IO_PAD108_PIOCFG_SLP_DIR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD108_PIOCFG_SLP_DIR_MASK) | (((uint32_t)val) << IO_PAD108_PIOCFG_SLP_DIR_SHIFT))

#define  IO_PAD108_PIOCFG_EDGE_EN_N_MASK 0x40
#define  IO_PAD108_PIOCFG_EDGE_EN_N_SHIFT 6
#define  IO_PAD108_PIOCFG_EDGE_EN_N_MASK_SHIFT(reg) (((reg) & IO_PAD108_PIOCFG_EDGE_EN_N_MASK) >> IO_PAD108_PIOCFG_EDGE_EN_N_SHIFT)
#define  IO_PAD108_PIOCFG_EDGE_EN_N_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD108_PIOCFG_EDGE_EN_N_MASK) | (((uint32_t)val) << IO_PAD108_PIOCFG_EDGE_EN_N_SHIFT))

#define  IO_PAD108_PIOCFG_EDGE_FALL_EN_MASK 0x20
#define  IO_PAD108_PIOCFG_EDGE_FALL_EN_SHIFT 5
#define  IO_PAD108_PIOCFG_EDGE_FALL_EN_MASK_SHIFT(reg) (((reg) & IO_PAD108_PIOCFG_EDGE_FALL_EN_MASK) >> IO_PAD108_PIOCFG_EDGE_FALL_EN_SHIFT)
#define  IO_PAD108_PIOCFG_EDGE_FALL_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD108_PIOCFG_EDGE_FALL_EN_MASK) | (((uint32_t)val) << IO_PAD108_PIOCFG_EDGE_FALL_EN_SHIFT))

#define  IO_PAD108_PIOCFG_EDGE_RISE_EN_MASK 0x10
#define  IO_PAD108_PIOCFG_EDGE_RISE_EN_SHIFT 4
#define  IO_PAD108_PIOCFG_EDGE_RISE_EN_MASK_SHIFT(reg) (((reg) & IO_PAD108_PIOCFG_EDGE_RISE_EN_MASK) >> IO_PAD108_PIOCFG_EDGE_RISE_EN_SHIFT)
#define  IO_PAD108_PIOCFG_EDGE_RISE_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD108_PIOCFG_EDGE_RISE_EN_MASK) | (((uint32_t)val) << IO_PAD108_PIOCFG_EDGE_RISE_EN_SHIFT))

#define  IO_PAD108_PIOCFG_SLP_SEL_MASK 0x8
#define  IO_PAD108_PIOCFG_SLP_SEL_SHIFT 3
#define  IO_PAD108_PIOCFG_SLP_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD108_PIOCFG_SLP_SEL_MASK) >> IO_PAD108_PIOCFG_SLP_SEL_SHIFT)
#define  IO_PAD108_PIOCFG_SLP_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD108_PIOCFG_SLP_SEL_MASK) | (((uint32_t)val) << IO_PAD108_PIOCFG_SLP_SEL_SHIFT))

#define  IO_PAD108_PIOCFG_FUNC_SEL_MASK 0x7
#define  IO_PAD108_PIOCFG_FUNC_SEL_SHIFT 0
#define  IO_PAD108_PIOCFG_FUNC_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD108_PIOCFG_FUNC_SEL_MASK) >> IO_PAD108_PIOCFG_FUNC_SEL_SHIFT)
#define  IO_PAD108_PIOCFG_FUNC_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD108_PIOCFG_FUNC_SEL_MASK) | (((uint32_t)val) << IO_PAD108_PIOCFG_FUNC_SEL_SHIFT))

//====================================================================
//
//Register File: IO_PAD109 Configuration Registers (IO_PAD109)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

//====================================================================
//Register: IO_PAD109 Configuration Register (PIOCFG)
/** \brief "PHI_PADXDC_SRC" Pad*/
//====================================================================

#define  IO_PAD109_PIOCFG_RESERVED1_MASK 0xfc000000
#define  IO_PAD109_PIOCFG_RESERVED1_SHIFT 26
#define  IO_PAD109_PIOCFG_RESERVED1_MASK_SHIFT(reg) (((reg) & IO_PAD109_PIOCFG_RESERVED1_MASK) >> IO_PAD109_PIOCFG_RESERVED1_SHIFT)
#define  IO_PAD109_PIOCFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD109_PIOCFG_RESERVED1_MASK) | (((uint32_t)val) << IO_PAD109_PIOCFG_RESERVED1_SHIFT))

#define  IO_PAD109_PIOCFG_PD_MASK 0x2000000
#define  IO_PAD109_PIOCFG_PD_SHIFT 25
#define  IO_PAD109_PIOCFG_PD_MASK_SHIFT(reg) (((reg) & IO_PAD109_PIOCFG_PD_MASK) >> IO_PAD109_PIOCFG_PD_SHIFT)
#define  IO_PAD109_PIOCFG_PD_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD109_PIOCFG_PD_MASK) | (((uint32_t)val) << IO_PAD109_PIOCFG_PD_SHIFT))

#define  IO_PAD109_PIOCFG_ODT_EN_MASK 0x1000000
#define  IO_PAD109_PIOCFG_ODT_EN_SHIFT 24
#define  IO_PAD109_PIOCFG_ODT_EN_MASK_SHIFT(reg) (((reg) & IO_PAD109_PIOCFG_ODT_EN_MASK) >> IO_PAD109_PIOCFG_ODT_EN_SHIFT)
#define  IO_PAD109_PIOCFG_ODT_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD109_PIOCFG_ODT_EN_MASK) | (((uint32_t)val) << IO_PAD109_PIOCFG_ODT_EN_SHIFT))

#define  IO_PAD109_PIOCFG_LED_EN_MASK 0x800000
#define  IO_PAD109_PIOCFG_LED_EN_SHIFT 23
#define  IO_PAD109_PIOCFG_LED_EN_MASK_SHIFT(reg) (((reg) & IO_PAD109_PIOCFG_LED_EN_MASK) >> IO_PAD109_PIOCFG_LED_EN_SHIFT)
#define  IO_PAD109_PIOCFG_LED_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD109_PIOCFG_LED_EN_MASK) | (((uint32_t)val) << IO_PAD109_PIOCFG_LED_EN_SHIFT))

#define  IO_PAD109_PIOCFG_I2C_SEL_MASK 0x600000
#define  IO_PAD109_PIOCFG_I2C_SEL_SHIFT 21
#define  IO_PAD109_PIOCFG_I2C_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD109_PIOCFG_I2C_SEL_MASK) >> IO_PAD109_PIOCFG_I2C_SEL_SHIFT)
#define  IO_PAD109_PIOCFG_I2C_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD109_PIOCFG_I2C_SEL_MASK) | (((uint32_t)val) << IO_PAD109_PIOCFG_I2C_SEL_SHIFT))

#define  IO_PAD109_PIOCFG_DGTBSEL_MASK 0x1e0000
#define  IO_PAD109_PIOCFG_DGTBSEL_SHIFT 17
#define  IO_PAD109_PIOCFG_DGTBSEL_MASK_SHIFT(reg) (((reg) & IO_PAD109_PIOCFG_DGTBSEL_MASK) >> IO_PAD109_PIOCFG_DGTBSEL_SHIFT)
#define  IO_PAD109_PIOCFG_DGTBSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD109_PIOCFG_DGTBSEL_MASK) | (((uint32_t)val) << IO_PAD109_PIOCFG_DGTBSEL_SHIFT))

#define  IO_PAD109_PIOCFG_RAWSEL_MASK 0x10000
#define  IO_PAD109_PIOCFG_RAWSEL_SHIFT 16
#define  IO_PAD109_PIOCFG_RAWSEL_MASK_SHIFT(reg) (((reg) & IO_PAD109_PIOCFG_RAWSEL_MASK) >> IO_PAD109_PIOCFG_RAWSEL_SHIFT)
#define  IO_PAD109_PIOCFG_RAWSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD109_PIOCFG_RAWSEL_MASK) | (((uint32_t)val) << IO_PAD109_PIOCFG_RAWSEL_SHIFT))

#define  IO_PAD109_PIOCFG_PULL_SEL_MASK 0x8000
#define  IO_PAD109_PIOCFG_PULL_SEL_SHIFT 15
#define  IO_PAD109_PIOCFG_PULL_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD109_PIOCFG_PULL_SEL_MASK) >> IO_PAD109_PIOCFG_PULL_SEL_SHIFT)
#define  IO_PAD109_PIOCFG_PULL_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD109_PIOCFG_PULL_SEL_MASK) | (((uint32_t)val) << IO_PAD109_PIOCFG_PULL_SEL_SHIFT))

#define  IO_PAD109_PIOCFG_PUEN_MASK 0x4000
#define  IO_PAD109_PIOCFG_PUEN_SHIFT 14
#define  IO_PAD109_PIOCFG_PUEN_MASK_SHIFT(reg) (((reg) & IO_PAD109_PIOCFG_PUEN_MASK) >> IO_PAD109_PIOCFG_PUEN_SHIFT)
#define  IO_PAD109_PIOCFG_PUEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD109_PIOCFG_PUEN_MASK) | (((uint32_t)val) << IO_PAD109_PIOCFG_PUEN_SHIFT))

#define  IO_PAD109_PIOCFG_PDEN_MASK 0x2000
#define  IO_PAD109_PIOCFG_PDEN_SHIFT 13
#define  IO_PAD109_PIOCFG_PDEN_MASK_SHIFT(reg) (((reg) & IO_PAD109_PIOCFG_PDEN_MASK) >> IO_PAD109_PIOCFG_PDEN_SHIFT)
#define  IO_PAD109_PIOCFG_PDEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD109_PIOCFG_PDEN_MASK) | (((uint32_t)val) << IO_PAD109_PIOCFG_PDEN_SHIFT))

#define  IO_PAD109_PIOCFG_SR_MASK 0x1800
#define  IO_PAD109_PIOCFG_SR_SHIFT 11
#define  IO_PAD109_PIOCFG_SR_MASK_SHIFT(reg) (((reg) & IO_PAD109_PIOCFG_SR_MASK) >> IO_PAD109_PIOCFG_SR_SHIFT)
#define  IO_PAD109_PIOCFG_SR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD109_PIOCFG_SR_MASK) | (((uint32_t)val) << IO_PAD109_PIOCFG_SR_SHIFT))

#define  IO_PAD109_PIOCFG_SLP_DI_MASK 0x400
#define  IO_PAD109_PIOCFG_SLP_DI_SHIFT 10
#define  IO_PAD109_PIOCFG_SLP_DI_MASK_SHIFT(reg) (((reg) & IO_PAD109_PIOCFG_SLP_DI_MASK) >> IO_PAD109_PIOCFG_SLP_DI_SHIFT)
#define  IO_PAD109_PIOCFG_SLP_DI_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD109_PIOCFG_SLP_DI_MASK) | (((uint32_t)val) << IO_PAD109_PIOCFG_SLP_DI_SHIFT))

#define  IO_PAD109_PIOCFG_SLP_CNTRL_MASK 0x200
#define  IO_PAD109_PIOCFG_SLP_CNTRL_SHIFT 9
#define  IO_PAD109_PIOCFG_SLP_CNTRL_MASK_SHIFT(reg) (((reg) & IO_PAD109_PIOCFG_SLP_CNTRL_MASK) >> IO_PAD109_PIOCFG_SLP_CNTRL_SHIFT)
#define  IO_PAD109_PIOCFG_SLP_CNTRL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD109_PIOCFG_SLP_CNTRL_MASK) | (((uint32_t)val) << IO_PAD109_PIOCFG_SLP_CNTRL_SHIFT))

#define  IO_PAD109_PIOCFG_SLP_DO_MASK 0x100
#define  IO_PAD109_PIOCFG_SLP_DO_SHIFT 8
#define  IO_PAD109_PIOCFG_SLP_DO_MASK_SHIFT(reg) (((reg) & IO_PAD109_PIOCFG_SLP_DO_MASK) >> IO_PAD109_PIOCFG_SLP_DO_SHIFT)
#define  IO_PAD109_PIOCFG_SLP_DO_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD109_PIOCFG_SLP_DO_MASK) | (((uint32_t)val) << IO_PAD109_PIOCFG_SLP_DO_SHIFT))

#define  IO_PAD109_PIOCFG_SLP_DIR_MASK 0x80
#define  IO_PAD109_PIOCFG_SLP_DIR_SHIFT 7
#define  IO_PAD109_PIOCFG_SLP_DIR_MASK_SHIFT(reg) (((reg) & IO_PAD109_PIOCFG_SLP_DIR_MASK) >> IO_PAD109_PIOCFG_SLP_DIR_SHIFT)
#define  IO_PAD109_PIOCFG_SLP_DIR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD109_PIOCFG_SLP_DIR_MASK) | (((uint32_t)val) << IO_PAD109_PIOCFG_SLP_DIR_SHIFT))

#define  IO_PAD109_PIOCFG_EDGE_EN_N_MASK 0x40
#define  IO_PAD109_PIOCFG_EDGE_EN_N_SHIFT 6
#define  IO_PAD109_PIOCFG_EDGE_EN_N_MASK_SHIFT(reg) (((reg) & IO_PAD109_PIOCFG_EDGE_EN_N_MASK) >> IO_PAD109_PIOCFG_EDGE_EN_N_SHIFT)
#define  IO_PAD109_PIOCFG_EDGE_EN_N_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD109_PIOCFG_EDGE_EN_N_MASK) | (((uint32_t)val) << IO_PAD109_PIOCFG_EDGE_EN_N_SHIFT))

#define  IO_PAD109_PIOCFG_EDGE_FALL_EN_MASK 0x20
#define  IO_PAD109_PIOCFG_EDGE_FALL_EN_SHIFT 5
#define  IO_PAD109_PIOCFG_EDGE_FALL_EN_MASK_SHIFT(reg) (((reg) & IO_PAD109_PIOCFG_EDGE_FALL_EN_MASK) >> IO_PAD109_PIOCFG_EDGE_FALL_EN_SHIFT)
#define  IO_PAD109_PIOCFG_EDGE_FALL_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD109_PIOCFG_EDGE_FALL_EN_MASK) | (((uint32_t)val) << IO_PAD109_PIOCFG_EDGE_FALL_EN_SHIFT))

#define  IO_PAD109_PIOCFG_EDGE_RISE_EN_MASK 0x10
#define  IO_PAD109_PIOCFG_EDGE_RISE_EN_SHIFT 4
#define  IO_PAD109_PIOCFG_EDGE_RISE_EN_MASK_SHIFT(reg) (((reg) & IO_PAD109_PIOCFG_EDGE_RISE_EN_MASK) >> IO_PAD109_PIOCFG_EDGE_RISE_EN_SHIFT)
#define  IO_PAD109_PIOCFG_EDGE_RISE_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD109_PIOCFG_EDGE_RISE_EN_MASK) | (((uint32_t)val) << IO_PAD109_PIOCFG_EDGE_RISE_EN_SHIFT))

#define  IO_PAD109_PIOCFG_SLP_SEL_MASK 0x8
#define  IO_PAD109_PIOCFG_SLP_SEL_SHIFT 3
#define  IO_PAD109_PIOCFG_SLP_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD109_PIOCFG_SLP_SEL_MASK) >> IO_PAD109_PIOCFG_SLP_SEL_SHIFT)
#define  IO_PAD109_PIOCFG_SLP_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD109_PIOCFG_SLP_SEL_MASK) | (((uint32_t)val) << IO_PAD109_PIOCFG_SLP_SEL_SHIFT))

#define  IO_PAD109_PIOCFG_FUNC_SEL_MASK 0x7
#define  IO_PAD109_PIOCFG_FUNC_SEL_SHIFT 0
#define  IO_PAD109_PIOCFG_FUNC_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD109_PIOCFG_FUNC_SEL_MASK) >> IO_PAD109_PIOCFG_FUNC_SEL_SHIFT)
#define  IO_PAD109_PIOCFG_FUNC_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD109_PIOCFG_FUNC_SEL_MASK) | (((uint32_t)val) << IO_PAD109_PIOCFG_FUNC_SEL_SHIFT))

//====================================================================
//
//Register File: VID_LVDSo_D0 Configuration Registers (VID_LVDSo_D0)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

//====================================================================
//Register: VID_LVDSo_D0 Configuration Register (PIOCFG)
/** \brief "PTH_PAD2818LVDSOUT" Pad*/
//====================================================================

#define  VID_LVDSO_D0_PIOCFG_RESERVED1_MASK 0xfc000000
#define  VID_LVDSO_D0_PIOCFG_RESERVED1_SHIFT 26
#define  VID_LVDSO_D0_PIOCFG_RESERVED1_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D0_PIOCFG_RESERVED1_MASK) >> VID_LVDSO_D0_PIOCFG_RESERVED1_SHIFT)
#define  VID_LVDSO_D0_PIOCFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D0_PIOCFG_RESERVED1_MASK) | (((uint32_t)val) << VID_LVDSO_D0_PIOCFG_RESERVED1_SHIFT))

#define  VID_LVDSO_D0_PIOCFG_PD_MASK 0x2000000
#define  VID_LVDSO_D0_PIOCFG_PD_SHIFT 25
#define  VID_LVDSO_D0_PIOCFG_PD_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D0_PIOCFG_PD_MASK) >> VID_LVDSO_D0_PIOCFG_PD_SHIFT)
#define  VID_LVDSO_D0_PIOCFG_PD_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D0_PIOCFG_PD_MASK) | (((uint32_t)val) << VID_LVDSO_D0_PIOCFG_PD_SHIFT))

#define  VID_LVDSO_D0_PIOCFG_ODT_EN_MASK 0x1000000
#define  VID_LVDSO_D0_PIOCFG_ODT_EN_SHIFT 24
#define  VID_LVDSO_D0_PIOCFG_ODT_EN_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D0_PIOCFG_ODT_EN_MASK) >> VID_LVDSO_D0_PIOCFG_ODT_EN_SHIFT)
#define  VID_LVDSO_D0_PIOCFG_ODT_EN_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D0_PIOCFG_ODT_EN_MASK) | (((uint32_t)val) << VID_LVDSO_D0_PIOCFG_ODT_EN_SHIFT))

#define  VID_LVDSO_D0_PIOCFG_LED_EN_MASK 0x800000
#define  VID_LVDSO_D0_PIOCFG_LED_EN_SHIFT 23
#define  VID_LVDSO_D0_PIOCFG_LED_EN_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D0_PIOCFG_LED_EN_MASK) >> VID_LVDSO_D0_PIOCFG_LED_EN_SHIFT)
#define  VID_LVDSO_D0_PIOCFG_LED_EN_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D0_PIOCFG_LED_EN_MASK) | (((uint32_t)val) << VID_LVDSO_D0_PIOCFG_LED_EN_SHIFT))

#define  VID_LVDSO_D0_PIOCFG_I2C_SEL_MASK 0x600000
#define  VID_LVDSO_D0_PIOCFG_I2C_SEL_SHIFT 21
#define  VID_LVDSO_D0_PIOCFG_I2C_SEL_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D0_PIOCFG_I2C_SEL_MASK) >> VID_LVDSO_D0_PIOCFG_I2C_SEL_SHIFT)
#define  VID_LVDSO_D0_PIOCFG_I2C_SEL_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D0_PIOCFG_I2C_SEL_MASK) | (((uint32_t)val) << VID_LVDSO_D0_PIOCFG_I2C_SEL_SHIFT))

#define  VID_LVDSO_D0_PIOCFG_DGTBSEL_MASK 0x1e0000
#define  VID_LVDSO_D0_PIOCFG_DGTBSEL_SHIFT 17
#define  VID_LVDSO_D0_PIOCFG_DGTBSEL_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D0_PIOCFG_DGTBSEL_MASK) >> VID_LVDSO_D0_PIOCFG_DGTBSEL_SHIFT)
#define  VID_LVDSO_D0_PIOCFG_DGTBSEL_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D0_PIOCFG_DGTBSEL_MASK) | (((uint32_t)val) << VID_LVDSO_D0_PIOCFG_DGTBSEL_SHIFT))

#define  VID_LVDSO_D0_PIOCFG_RAWSEL_MASK 0x10000
#define  VID_LVDSO_D0_PIOCFG_RAWSEL_SHIFT 16
#define  VID_LVDSO_D0_PIOCFG_RAWSEL_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D0_PIOCFG_RAWSEL_MASK) >> VID_LVDSO_D0_PIOCFG_RAWSEL_SHIFT)
#define  VID_LVDSO_D0_PIOCFG_RAWSEL_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D0_PIOCFG_RAWSEL_MASK) | (((uint32_t)val) << VID_LVDSO_D0_PIOCFG_RAWSEL_SHIFT))

#define  VID_LVDSO_D0_PIOCFG_PULL_SEL_MASK 0x8000
#define  VID_LVDSO_D0_PIOCFG_PULL_SEL_SHIFT 15
#define  VID_LVDSO_D0_PIOCFG_PULL_SEL_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D0_PIOCFG_PULL_SEL_MASK) >> VID_LVDSO_D0_PIOCFG_PULL_SEL_SHIFT)
#define  VID_LVDSO_D0_PIOCFG_PULL_SEL_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D0_PIOCFG_PULL_SEL_MASK) | (((uint32_t)val) << VID_LVDSO_D0_PIOCFG_PULL_SEL_SHIFT))

#define  VID_LVDSO_D0_PIOCFG_PUEN_MASK 0x4000
#define  VID_LVDSO_D0_PIOCFG_PUEN_SHIFT 14
#define  VID_LVDSO_D0_PIOCFG_PUEN_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D0_PIOCFG_PUEN_MASK) >> VID_LVDSO_D0_PIOCFG_PUEN_SHIFT)
#define  VID_LVDSO_D0_PIOCFG_PUEN_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D0_PIOCFG_PUEN_MASK) | (((uint32_t)val) << VID_LVDSO_D0_PIOCFG_PUEN_SHIFT))

#define  VID_LVDSO_D0_PIOCFG_PDEN_MASK 0x2000
#define  VID_LVDSO_D0_PIOCFG_PDEN_SHIFT 13
#define  VID_LVDSO_D0_PIOCFG_PDEN_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D0_PIOCFG_PDEN_MASK) >> VID_LVDSO_D0_PIOCFG_PDEN_SHIFT)
#define  VID_LVDSO_D0_PIOCFG_PDEN_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D0_PIOCFG_PDEN_MASK) | (((uint32_t)val) << VID_LVDSO_D0_PIOCFG_PDEN_SHIFT))

#define  VID_LVDSO_D0_PIOCFG_SP12_MASK 0x1000
#define  VID_LVDSO_D0_PIOCFG_SP12_SHIFT 12
#define  VID_LVDSO_D0_PIOCFG_SP12_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D0_PIOCFG_SP12_MASK) >> VID_LVDSO_D0_PIOCFG_SP12_SHIFT)
#define  VID_LVDSO_D0_PIOCFG_SP12_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D0_PIOCFG_SP12_MASK) | (((uint32_t)val) << VID_LVDSO_D0_PIOCFG_SP12_SHIFT))

#define  VID_LVDSO_D0_PIOCFG_SR_MASK 0x800
#define  VID_LVDSO_D0_PIOCFG_SR_SHIFT 11
#define  VID_LVDSO_D0_PIOCFG_SR_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D0_PIOCFG_SR_MASK) >> VID_LVDSO_D0_PIOCFG_SR_SHIFT)
#define  VID_LVDSO_D0_PIOCFG_SR_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D0_PIOCFG_SR_MASK) | (((uint32_t)val) << VID_LVDSO_D0_PIOCFG_SR_SHIFT))

#define  VID_LVDSO_D0_PIOCFG_SLP_DI_MASK 0x400
#define  VID_LVDSO_D0_PIOCFG_SLP_DI_SHIFT 10
#define  VID_LVDSO_D0_PIOCFG_SLP_DI_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D0_PIOCFG_SLP_DI_MASK) >> VID_LVDSO_D0_PIOCFG_SLP_DI_SHIFT)
#define  VID_LVDSO_D0_PIOCFG_SLP_DI_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D0_PIOCFG_SLP_DI_MASK) | (((uint32_t)val) << VID_LVDSO_D0_PIOCFG_SLP_DI_SHIFT))

#define  VID_LVDSO_D0_PIOCFG_SLP_CNTRL_MASK 0x200
#define  VID_LVDSO_D0_PIOCFG_SLP_CNTRL_SHIFT 9
#define  VID_LVDSO_D0_PIOCFG_SLP_CNTRL_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D0_PIOCFG_SLP_CNTRL_MASK) >> VID_LVDSO_D0_PIOCFG_SLP_CNTRL_SHIFT)
#define  VID_LVDSO_D0_PIOCFG_SLP_CNTRL_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D0_PIOCFG_SLP_CNTRL_MASK) | (((uint32_t)val) << VID_LVDSO_D0_PIOCFG_SLP_CNTRL_SHIFT))

#define  VID_LVDSO_D0_PIOCFG_SLP_DO_MASK 0x100
#define  VID_LVDSO_D0_PIOCFG_SLP_DO_SHIFT 8
#define  VID_LVDSO_D0_PIOCFG_SLP_DO_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D0_PIOCFG_SLP_DO_MASK) >> VID_LVDSO_D0_PIOCFG_SLP_DO_SHIFT)
#define  VID_LVDSO_D0_PIOCFG_SLP_DO_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D0_PIOCFG_SLP_DO_MASK) | (((uint32_t)val) << VID_LVDSO_D0_PIOCFG_SLP_DO_SHIFT))

#define  VID_LVDSO_D0_PIOCFG_SLP_DIR_MASK 0x80
#define  VID_LVDSO_D0_PIOCFG_SLP_DIR_SHIFT 7
#define  VID_LVDSO_D0_PIOCFG_SLP_DIR_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D0_PIOCFG_SLP_DIR_MASK) >> VID_LVDSO_D0_PIOCFG_SLP_DIR_SHIFT)
#define  VID_LVDSO_D0_PIOCFG_SLP_DIR_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D0_PIOCFG_SLP_DIR_MASK) | (((uint32_t)val) << VID_LVDSO_D0_PIOCFG_SLP_DIR_SHIFT))

#define  VID_LVDSO_D0_PIOCFG_EDGE_EN_N_MASK 0x40
#define  VID_LVDSO_D0_PIOCFG_EDGE_EN_N_SHIFT 6
#define  VID_LVDSO_D0_PIOCFG_EDGE_EN_N_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D0_PIOCFG_EDGE_EN_N_MASK) >> VID_LVDSO_D0_PIOCFG_EDGE_EN_N_SHIFT)
#define  VID_LVDSO_D0_PIOCFG_EDGE_EN_N_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D0_PIOCFG_EDGE_EN_N_MASK) | (((uint32_t)val) << VID_LVDSO_D0_PIOCFG_EDGE_EN_N_SHIFT))

#define  VID_LVDSO_D0_PIOCFG_EDGE_FALL_EN_MASK 0x20
#define  VID_LVDSO_D0_PIOCFG_EDGE_FALL_EN_SHIFT 5
#define  VID_LVDSO_D0_PIOCFG_EDGE_FALL_EN_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D0_PIOCFG_EDGE_FALL_EN_MASK) >> VID_LVDSO_D0_PIOCFG_EDGE_FALL_EN_SHIFT)
#define  VID_LVDSO_D0_PIOCFG_EDGE_FALL_EN_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D0_PIOCFG_EDGE_FALL_EN_MASK) | (((uint32_t)val) << VID_LVDSO_D0_PIOCFG_EDGE_FALL_EN_SHIFT))

#define  VID_LVDSO_D0_PIOCFG_EDGE_RISE_EN_MASK 0x10
#define  VID_LVDSO_D0_PIOCFG_EDGE_RISE_EN_SHIFT 4
#define  VID_LVDSO_D0_PIOCFG_EDGE_RISE_EN_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D0_PIOCFG_EDGE_RISE_EN_MASK) >> VID_LVDSO_D0_PIOCFG_EDGE_RISE_EN_SHIFT)
#define  VID_LVDSO_D0_PIOCFG_EDGE_RISE_EN_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D0_PIOCFG_EDGE_RISE_EN_MASK) | (((uint32_t)val) << VID_LVDSO_D0_PIOCFG_EDGE_RISE_EN_SHIFT))

#define  VID_LVDSO_D0_PIOCFG_SLP_SEL_MASK 0x8
#define  VID_LVDSO_D0_PIOCFG_SLP_SEL_SHIFT 3
#define  VID_LVDSO_D0_PIOCFG_SLP_SEL_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D0_PIOCFG_SLP_SEL_MASK) >> VID_LVDSO_D0_PIOCFG_SLP_SEL_SHIFT)
#define  VID_LVDSO_D0_PIOCFG_SLP_SEL_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D0_PIOCFG_SLP_SEL_MASK) | (((uint32_t)val) << VID_LVDSO_D0_PIOCFG_SLP_SEL_SHIFT))

#define  VID_LVDSO_D0_PIOCFG_FUNC_SEL_MASK 0x7
#define  VID_LVDSO_D0_PIOCFG_FUNC_SEL_SHIFT 0
#define  VID_LVDSO_D0_PIOCFG_FUNC_SEL_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D0_PIOCFG_FUNC_SEL_MASK) >> VID_LVDSO_D0_PIOCFG_FUNC_SEL_SHIFT)
#define  VID_LVDSO_D0_PIOCFG_FUNC_SEL_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D0_PIOCFG_FUNC_SEL_MASK) | (((uint32_t)val) << VID_LVDSO_D0_PIOCFG_FUNC_SEL_SHIFT))

//====================================================================
//
//Register File: VID_LVDSo_D1 Configuration Registers (VID_LVDSo_D1)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

//====================================================================
//Register: VID_LVDSo_D1 Configuration Register (PIOCFG)
/** \brief "PTH_PAD2818LVDSOUT" Pad*/
//====================================================================

#define  VID_LVDSO_D1_PIOCFG_RESERVED1_MASK 0xfc000000
#define  VID_LVDSO_D1_PIOCFG_RESERVED1_SHIFT 26
#define  VID_LVDSO_D1_PIOCFG_RESERVED1_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D1_PIOCFG_RESERVED1_MASK) >> VID_LVDSO_D1_PIOCFG_RESERVED1_SHIFT)
#define  VID_LVDSO_D1_PIOCFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D1_PIOCFG_RESERVED1_MASK) | (((uint32_t)val) << VID_LVDSO_D1_PIOCFG_RESERVED1_SHIFT))

#define  VID_LVDSO_D1_PIOCFG_PD_MASK 0x2000000
#define  VID_LVDSO_D1_PIOCFG_PD_SHIFT 25
#define  VID_LVDSO_D1_PIOCFG_PD_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D1_PIOCFG_PD_MASK) >> VID_LVDSO_D1_PIOCFG_PD_SHIFT)
#define  VID_LVDSO_D1_PIOCFG_PD_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D1_PIOCFG_PD_MASK) | (((uint32_t)val) << VID_LVDSO_D1_PIOCFG_PD_SHIFT))

#define  VID_LVDSO_D1_PIOCFG_ODT_EN_MASK 0x1000000
#define  VID_LVDSO_D1_PIOCFG_ODT_EN_SHIFT 24
#define  VID_LVDSO_D1_PIOCFG_ODT_EN_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D1_PIOCFG_ODT_EN_MASK) >> VID_LVDSO_D1_PIOCFG_ODT_EN_SHIFT)
#define  VID_LVDSO_D1_PIOCFG_ODT_EN_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D1_PIOCFG_ODT_EN_MASK) | (((uint32_t)val) << VID_LVDSO_D1_PIOCFG_ODT_EN_SHIFT))

#define  VID_LVDSO_D1_PIOCFG_LED_EN_MASK 0x800000
#define  VID_LVDSO_D1_PIOCFG_LED_EN_SHIFT 23
#define  VID_LVDSO_D1_PIOCFG_LED_EN_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D1_PIOCFG_LED_EN_MASK) >> VID_LVDSO_D1_PIOCFG_LED_EN_SHIFT)
#define  VID_LVDSO_D1_PIOCFG_LED_EN_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D1_PIOCFG_LED_EN_MASK) | (((uint32_t)val) << VID_LVDSO_D1_PIOCFG_LED_EN_SHIFT))

#define  VID_LVDSO_D1_PIOCFG_I2C_SEL_MASK 0x600000
#define  VID_LVDSO_D1_PIOCFG_I2C_SEL_SHIFT 21
#define  VID_LVDSO_D1_PIOCFG_I2C_SEL_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D1_PIOCFG_I2C_SEL_MASK) >> VID_LVDSO_D1_PIOCFG_I2C_SEL_SHIFT)
#define  VID_LVDSO_D1_PIOCFG_I2C_SEL_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D1_PIOCFG_I2C_SEL_MASK) | (((uint32_t)val) << VID_LVDSO_D1_PIOCFG_I2C_SEL_SHIFT))

#define  VID_LVDSO_D1_PIOCFG_DGTBSEL_MASK 0x1e0000
#define  VID_LVDSO_D1_PIOCFG_DGTBSEL_SHIFT 17
#define  VID_LVDSO_D1_PIOCFG_DGTBSEL_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D1_PIOCFG_DGTBSEL_MASK) >> VID_LVDSO_D1_PIOCFG_DGTBSEL_SHIFT)
#define  VID_LVDSO_D1_PIOCFG_DGTBSEL_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D1_PIOCFG_DGTBSEL_MASK) | (((uint32_t)val) << VID_LVDSO_D1_PIOCFG_DGTBSEL_SHIFT))

#define  VID_LVDSO_D1_PIOCFG_RAWSEL_MASK 0x10000
#define  VID_LVDSO_D1_PIOCFG_RAWSEL_SHIFT 16
#define  VID_LVDSO_D1_PIOCFG_RAWSEL_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D1_PIOCFG_RAWSEL_MASK) >> VID_LVDSO_D1_PIOCFG_RAWSEL_SHIFT)
#define  VID_LVDSO_D1_PIOCFG_RAWSEL_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D1_PIOCFG_RAWSEL_MASK) | (((uint32_t)val) << VID_LVDSO_D1_PIOCFG_RAWSEL_SHIFT))

#define  VID_LVDSO_D1_PIOCFG_PULL_SEL_MASK 0x8000
#define  VID_LVDSO_D1_PIOCFG_PULL_SEL_SHIFT 15
#define  VID_LVDSO_D1_PIOCFG_PULL_SEL_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D1_PIOCFG_PULL_SEL_MASK) >> VID_LVDSO_D1_PIOCFG_PULL_SEL_SHIFT)
#define  VID_LVDSO_D1_PIOCFG_PULL_SEL_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D1_PIOCFG_PULL_SEL_MASK) | (((uint32_t)val) << VID_LVDSO_D1_PIOCFG_PULL_SEL_SHIFT))

#define  VID_LVDSO_D1_PIOCFG_PUEN_MASK 0x4000
#define  VID_LVDSO_D1_PIOCFG_PUEN_SHIFT 14
#define  VID_LVDSO_D1_PIOCFG_PUEN_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D1_PIOCFG_PUEN_MASK) >> VID_LVDSO_D1_PIOCFG_PUEN_SHIFT)
#define  VID_LVDSO_D1_PIOCFG_PUEN_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D1_PIOCFG_PUEN_MASK) | (((uint32_t)val) << VID_LVDSO_D1_PIOCFG_PUEN_SHIFT))

#define  VID_LVDSO_D1_PIOCFG_PDEN_MASK 0x2000
#define  VID_LVDSO_D1_PIOCFG_PDEN_SHIFT 13
#define  VID_LVDSO_D1_PIOCFG_PDEN_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D1_PIOCFG_PDEN_MASK) >> VID_LVDSO_D1_PIOCFG_PDEN_SHIFT)
#define  VID_LVDSO_D1_PIOCFG_PDEN_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D1_PIOCFG_PDEN_MASK) | (((uint32_t)val) << VID_LVDSO_D1_PIOCFG_PDEN_SHIFT))

#define  VID_LVDSO_D1_PIOCFG_SP12_MASK 0x1000
#define  VID_LVDSO_D1_PIOCFG_SP12_SHIFT 12
#define  VID_LVDSO_D1_PIOCFG_SP12_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D1_PIOCFG_SP12_MASK) >> VID_LVDSO_D1_PIOCFG_SP12_SHIFT)
#define  VID_LVDSO_D1_PIOCFG_SP12_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D1_PIOCFG_SP12_MASK) | (((uint32_t)val) << VID_LVDSO_D1_PIOCFG_SP12_SHIFT))

#define  VID_LVDSO_D1_PIOCFG_SR_MASK 0x800
#define  VID_LVDSO_D1_PIOCFG_SR_SHIFT 11
#define  VID_LVDSO_D1_PIOCFG_SR_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D1_PIOCFG_SR_MASK) >> VID_LVDSO_D1_PIOCFG_SR_SHIFT)
#define  VID_LVDSO_D1_PIOCFG_SR_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D1_PIOCFG_SR_MASK) | (((uint32_t)val) << VID_LVDSO_D1_PIOCFG_SR_SHIFT))

#define  VID_LVDSO_D1_PIOCFG_SLP_DI_MASK 0x400
#define  VID_LVDSO_D1_PIOCFG_SLP_DI_SHIFT 10
#define  VID_LVDSO_D1_PIOCFG_SLP_DI_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D1_PIOCFG_SLP_DI_MASK) >> VID_LVDSO_D1_PIOCFG_SLP_DI_SHIFT)
#define  VID_LVDSO_D1_PIOCFG_SLP_DI_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D1_PIOCFG_SLP_DI_MASK) | (((uint32_t)val) << VID_LVDSO_D1_PIOCFG_SLP_DI_SHIFT))

#define  VID_LVDSO_D1_PIOCFG_SLP_CNTRL_MASK 0x200
#define  VID_LVDSO_D1_PIOCFG_SLP_CNTRL_SHIFT 9
#define  VID_LVDSO_D1_PIOCFG_SLP_CNTRL_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D1_PIOCFG_SLP_CNTRL_MASK) >> VID_LVDSO_D1_PIOCFG_SLP_CNTRL_SHIFT)
#define  VID_LVDSO_D1_PIOCFG_SLP_CNTRL_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D1_PIOCFG_SLP_CNTRL_MASK) | (((uint32_t)val) << VID_LVDSO_D1_PIOCFG_SLP_CNTRL_SHIFT))

#define  VID_LVDSO_D1_PIOCFG_SLP_DO_MASK 0x100
#define  VID_LVDSO_D1_PIOCFG_SLP_DO_SHIFT 8
#define  VID_LVDSO_D1_PIOCFG_SLP_DO_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D1_PIOCFG_SLP_DO_MASK) >> VID_LVDSO_D1_PIOCFG_SLP_DO_SHIFT)
#define  VID_LVDSO_D1_PIOCFG_SLP_DO_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D1_PIOCFG_SLP_DO_MASK) | (((uint32_t)val) << VID_LVDSO_D1_PIOCFG_SLP_DO_SHIFT))

#define  VID_LVDSO_D1_PIOCFG_SLP_DIR_MASK 0x80
#define  VID_LVDSO_D1_PIOCFG_SLP_DIR_SHIFT 7
#define  VID_LVDSO_D1_PIOCFG_SLP_DIR_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D1_PIOCFG_SLP_DIR_MASK) >> VID_LVDSO_D1_PIOCFG_SLP_DIR_SHIFT)
#define  VID_LVDSO_D1_PIOCFG_SLP_DIR_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D1_PIOCFG_SLP_DIR_MASK) | (((uint32_t)val) << VID_LVDSO_D1_PIOCFG_SLP_DIR_SHIFT))

#define  VID_LVDSO_D1_PIOCFG_EDGE_EN_N_MASK 0x40
#define  VID_LVDSO_D1_PIOCFG_EDGE_EN_N_SHIFT 6
#define  VID_LVDSO_D1_PIOCFG_EDGE_EN_N_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D1_PIOCFG_EDGE_EN_N_MASK) >> VID_LVDSO_D1_PIOCFG_EDGE_EN_N_SHIFT)
#define  VID_LVDSO_D1_PIOCFG_EDGE_EN_N_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D1_PIOCFG_EDGE_EN_N_MASK) | (((uint32_t)val) << VID_LVDSO_D1_PIOCFG_EDGE_EN_N_SHIFT))

#define  VID_LVDSO_D1_PIOCFG_EDGE_FALL_EN_MASK 0x20
#define  VID_LVDSO_D1_PIOCFG_EDGE_FALL_EN_SHIFT 5
#define  VID_LVDSO_D1_PIOCFG_EDGE_FALL_EN_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D1_PIOCFG_EDGE_FALL_EN_MASK) >> VID_LVDSO_D1_PIOCFG_EDGE_FALL_EN_SHIFT)
#define  VID_LVDSO_D1_PIOCFG_EDGE_FALL_EN_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D1_PIOCFG_EDGE_FALL_EN_MASK) | (((uint32_t)val) << VID_LVDSO_D1_PIOCFG_EDGE_FALL_EN_SHIFT))

#define  VID_LVDSO_D1_PIOCFG_EDGE_RISE_EN_MASK 0x10
#define  VID_LVDSO_D1_PIOCFG_EDGE_RISE_EN_SHIFT 4
#define  VID_LVDSO_D1_PIOCFG_EDGE_RISE_EN_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D1_PIOCFG_EDGE_RISE_EN_MASK) >> VID_LVDSO_D1_PIOCFG_EDGE_RISE_EN_SHIFT)
#define  VID_LVDSO_D1_PIOCFG_EDGE_RISE_EN_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D1_PIOCFG_EDGE_RISE_EN_MASK) | (((uint32_t)val) << VID_LVDSO_D1_PIOCFG_EDGE_RISE_EN_SHIFT))

#define  VID_LVDSO_D1_PIOCFG_SLP_SEL_MASK 0x8
#define  VID_LVDSO_D1_PIOCFG_SLP_SEL_SHIFT 3
#define  VID_LVDSO_D1_PIOCFG_SLP_SEL_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D1_PIOCFG_SLP_SEL_MASK) >> VID_LVDSO_D1_PIOCFG_SLP_SEL_SHIFT)
#define  VID_LVDSO_D1_PIOCFG_SLP_SEL_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D1_PIOCFG_SLP_SEL_MASK) | (((uint32_t)val) << VID_LVDSO_D1_PIOCFG_SLP_SEL_SHIFT))

#define  VID_LVDSO_D1_PIOCFG_FUNC_SEL_MASK 0x7
#define  VID_LVDSO_D1_PIOCFG_FUNC_SEL_SHIFT 0
#define  VID_LVDSO_D1_PIOCFG_FUNC_SEL_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D1_PIOCFG_FUNC_SEL_MASK) >> VID_LVDSO_D1_PIOCFG_FUNC_SEL_SHIFT)
#define  VID_LVDSO_D1_PIOCFG_FUNC_SEL_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D1_PIOCFG_FUNC_SEL_MASK) | (((uint32_t)val) << VID_LVDSO_D1_PIOCFG_FUNC_SEL_SHIFT))

//====================================================================
//
//Register File: VID_LVDSo_D2 Configuration Registers (VID_LVDSo_D2)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

//====================================================================
//Register: VID_LVDSo_D2 Configuration Register (PIOCFG)
/** \brief "PTH_PAD2818LVDSOUT" Pad*/
//====================================================================

#define  VID_LVDSO_D2_PIOCFG_RESERVED1_MASK 0xfc000000
#define  VID_LVDSO_D2_PIOCFG_RESERVED1_SHIFT 26
#define  VID_LVDSO_D2_PIOCFG_RESERVED1_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D2_PIOCFG_RESERVED1_MASK) >> VID_LVDSO_D2_PIOCFG_RESERVED1_SHIFT)
#define  VID_LVDSO_D2_PIOCFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D2_PIOCFG_RESERVED1_MASK) | (((uint32_t)val) << VID_LVDSO_D2_PIOCFG_RESERVED1_SHIFT))

#define  VID_LVDSO_D2_PIOCFG_PD_MASK 0x2000000
#define  VID_LVDSO_D2_PIOCFG_PD_SHIFT 25
#define  VID_LVDSO_D2_PIOCFG_PD_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D2_PIOCFG_PD_MASK) >> VID_LVDSO_D2_PIOCFG_PD_SHIFT)
#define  VID_LVDSO_D2_PIOCFG_PD_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D2_PIOCFG_PD_MASK) | (((uint32_t)val) << VID_LVDSO_D2_PIOCFG_PD_SHIFT))

#define  VID_LVDSO_D2_PIOCFG_ODT_EN_MASK 0x1000000
#define  VID_LVDSO_D2_PIOCFG_ODT_EN_SHIFT 24
#define  VID_LVDSO_D2_PIOCFG_ODT_EN_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D2_PIOCFG_ODT_EN_MASK) >> VID_LVDSO_D2_PIOCFG_ODT_EN_SHIFT)
#define  VID_LVDSO_D2_PIOCFG_ODT_EN_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D2_PIOCFG_ODT_EN_MASK) | (((uint32_t)val) << VID_LVDSO_D2_PIOCFG_ODT_EN_SHIFT))

#define  VID_LVDSO_D2_PIOCFG_LED_EN_MASK 0x800000
#define  VID_LVDSO_D2_PIOCFG_LED_EN_SHIFT 23
#define  VID_LVDSO_D2_PIOCFG_LED_EN_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D2_PIOCFG_LED_EN_MASK) >> VID_LVDSO_D2_PIOCFG_LED_EN_SHIFT)
#define  VID_LVDSO_D2_PIOCFG_LED_EN_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D2_PIOCFG_LED_EN_MASK) | (((uint32_t)val) << VID_LVDSO_D2_PIOCFG_LED_EN_SHIFT))

#define  VID_LVDSO_D2_PIOCFG_I2C_SEL_MASK 0x600000
#define  VID_LVDSO_D2_PIOCFG_I2C_SEL_SHIFT 21
#define  VID_LVDSO_D2_PIOCFG_I2C_SEL_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D2_PIOCFG_I2C_SEL_MASK) >> VID_LVDSO_D2_PIOCFG_I2C_SEL_SHIFT)
#define  VID_LVDSO_D2_PIOCFG_I2C_SEL_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D2_PIOCFG_I2C_SEL_MASK) | (((uint32_t)val) << VID_LVDSO_D2_PIOCFG_I2C_SEL_SHIFT))

#define  VID_LVDSO_D2_PIOCFG_DGTBSEL_MASK 0x1e0000
#define  VID_LVDSO_D2_PIOCFG_DGTBSEL_SHIFT 17
#define  VID_LVDSO_D2_PIOCFG_DGTBSEL_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D2_PIOCFG_DGTBSEL_MASK) >> VID_LVDSO_D2_PIOCFG_DGTBSEL_SHIFT)
#define  VID_LVDSO_D2_PIOCFG_DGTBSEL_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D2_PIOCFG_DGTBSEL_MASK) | (((uint32_t)val) << VID_LVDSO_D2_PIOCFG_DGTBSEL_SHIFT))

#define  VID_LVDSO_D2_PIOCFG_RAWSEL_MASK 0x10000
#define  VID_LVDSO_D2_PIOCFG_RAWSEL_SHIFT 16
#define  VID_LVDSO_D2_PIOCFG_RAWSEL_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D2_PIOCFG_RAWSEL_MASK) >> VID_LVDSO_D2_PIOCFG_RAWSEL_SHIFT)
#define  VID_LVDSO_D2_PIOCFG_RAWSEL_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D2_PIOCFG_RAWSEL_MASK) | (((uint32_t)val) << VID_LVDSO_D2_PIOCFG_RAWSEL_SHIFT))

#define  VID_LVDSO_D2_PIOCFG_PULL_SEL_MASK 0x8000
#define  VID_LVDSO_D2_PIOCFG_PULL_SEL_SHIFT 15
#define  VID_LVDSO_D2_PIOCFG_PULL_SEL_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D2_PIOCFG_PULL_SEL_MASK) >> VID_LVDSO_D2_PIOCFG_PULL_SEL_SHIFT)
#define  VID_LVDSO_D2_PIOCFG_PULL_SEL_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D2_PIOCFG_PULL_SEL_MASK) | (((uint32_t)val) << VID_LVDSO_D2_PIOCFG_PULL_SEL_SHIFT))

#define  VID_LVDSO_D2_PIOCFG_PUEN_MASK 0x4000
#define  VID_LVDSO_D2_PIOCFG_PUEN_SHIFT 14
#define  VID_LVDSO_D2_PIOCFG_PUEN_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D2_PIOCFG_PUEN_MASK) >> VID_LVDSO_D2_PIOCFG_PUEN_SHIFT)
#define  VID_LVDSO_D2_PIOCFG_PUEN_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D2_PIOCFG_PUEN_MASK) | (((uint32_t)val) << VID_LVDSO_D2_PIOCFG_PUEN_SHIFT))

#define  VID_LVDSO_D2_PIOCFG_PDEN_MASK 0x2000
#define  VID_LVDSO_D2_PIOCFG_PDEN_SHIFT 13
#define  VID_LVDSO_D2_PIOCFG_PDEN_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D2_PIOCFG_PDEN_MASK) >> VID_LVDSO_D2_PIOCFG_PDEN_SHIFT)
#define  VID_LVDSO_D2_PIOCFG_PDEN_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D2_PIOCFG_PDEN_MASK) | (((uint32_t)val) << VID_LVDSO_D2_PIOCFG_PDEN_SHIFT))

#define  VID_LVDSO_D2_PIOCFG_SP12_MASK 0x1000
#define  VID_LVDSO_D2_PIOCFG_SP12_SHIFT 12
#define  VID_LVDSO_D2_PIOCFG_SP12_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D2_PIOCFG_SP12_MASK) >> VID_LVDSO_D2_PIOCFG_SP12_SHIFT)
#define  VID_LVDSO_D2_PIOCFG_SP12_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D2_PIOCFG_SP12_MASK) | (((uint32_t)val) << VID_LVDSO_D2_PIOCFG_SP12_SHIFT))

#define  VID_LVDSO_D2_PIOCFG_SR_MASK 0x800
#define  VID_LVDSO_D2_PIOCFG_SR_SHIFT 11
#define  VID_LVDSO_D2_PIOCFG_SR_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D2_PIOCFG_SR_MASK) >> VID_LVDSO_D2_PIOCFG_SR_SHIFT)
#define  VID_LVDSO_D2_PIOCFG_SR_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D2_PIOCFG_SR_MASK) | (((uint32_t)val) << VID_LVDSO_D2_PIOCFG_SR_SHIFT))

#define  VID_LVDSO_D2_PIOCFG_SLP_DI_MASK 0x400
#define  VID_LVDSO_D2_PIOCFG_SLP_DI_SHIFT 10
#define  VID_LVDSO_D2_PIOCFG_SLP_DI_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D2_PIOCFG_SLP_DI_MASK) >> VID_LVDSO_D2_PIOCFG_SLP_DI_SHIFT)
#define  VID_LVDSO_D2_PIOCFG_SLP_DI_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D2_PIOCFG_SLP_DI_MASK) | (((uint32_t)val) << VID_LVDSO_D2_PIOCFG_SLP_DI_SHIFT))

#define  VID_LVDSO_D2_PIOCFG_SLP_CNTRL_MASK 0x200
#define  VID_LVDSO_D2_PIOCFG_SLP_CNTRL_SHIFT 9
#define  VID_LVDSO_D2_PIOCFG_SLP_CNTRL_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D2_PIOCFG_SLP_CNTRL_MASK) >> VID_LVDSO_D2_PIOCFG_SLP_CNTRL_SHIFT)
#define  VID_LVDSO_D2_PIOCFG_SLP_CNTRL_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D2_PIOCFG_SLP_CNTRL_MASK) | (((uint32_t)val) << VID_LVDSO_D2_PIOCFG_SLP_CNTRL_SHIFT))

#define  VID_LVDSO_D2_PIOCFG_SLP_DO_MASK 0x100
#define  VID_LVDSO_D2_PIOCFG_SLP_DO_SHIFT 8
#define  VID_LVDSO_D2_PIOCFG_SLP_DO_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D2_PIOCFG_SLP_DO_MASK) >> VID_LVDSO_D2_PIOCFG_SLP_DO_SHIFT)
#define  VID_LVDSO_D2_PIOCFG_SLP_DO_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D2_PIOCFG_SLP_DO_MASK) | (((uint32_t)val) << VID_LVDSO_D2_PIOCFG_SLP_DO_SHIFT))

#define  VID_LVDSO_D2_PIOCFG_SLP_DIR_MASK 0x80
#define  VID_LVDSO_D2_PIOCFG_SLP_DIR_SHIFT 7
#define  VID_LVDSO_D2_PIOCFG_SLP_DIR_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D2_PIOCFG_SLP_DIR_MASK) >> VID_LVDSO_D2_PIOCFG_SLP_DIR_SHIFT)
#define  VID_LVDSO_D2_PIOCFG_SLP_DIR_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D2_PIOCFG_SLP_DIR_MASK) | (((uint32_t)val) << VID_LVDSO_D2_PIOCFG_SLP_DIR_SHIFT))

#define  VID_LVDSO_D2_PIOCFG_EDGE_EN_N_MASK 0x40
#define  VID_LVDSO_D2_PIOCFG_EDGE_EN_N_SHIFT 6
#define  VID_LVDSO_D2_PIOCFG_EDGE_EN_N_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D2_PIOCFG_EDGE_EN_N_MASK) >> VID_LVDSO_D2_PIOCFG_EDGE_EN_N_SHIFT)
#define  VID_LVDSO_D2_PIOCFG_EDGE_EN_N_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D2_PIOCFG_EDGE_EN_N_MASK) | (((uint32_t)val) << VID_LVDSO_D2_PIOCFG_EDGE_EN_N_SHIFT))

#define  VID_LVDSO_D2_PIOCFG_EDGE_FALL_EN_MASK 0x20
#define  VID_LVDSO_D2_PIOCFG_EDGE_FALL_EN_SHIFT 5
#define  VID_LVDSO_D2_PIOCFG_EDGE_FALL_EN_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D2_PIOCFG_EDGE_FALL_EN_MASK) >> VID_LVDSO_D2_PIOCFG_EDGE_FALL_EN_SHIFT)
#define  VID_LVDSO_D2_PIOCFG_EDGE_FALL_EN_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D2_PIOCFG_EDGE_FALL_EN_MASK) | (((uint32_t)val) << VID_LVDSO_D2_PIOCFG_EDGE_FALL_EN_SHIFT))

#define  VID_LVDSO_D2_PIOCFG_EDGE_RISE_EN_MASK 0x10
#define  VID_LVDSO_D2_PIOCFG_EDGE_RISE_EN_SHIFT 4
#define  VID_LVDSO_D2_PIOCFG_EDGE_RISE_EN_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D2_PIOCFG_EDGE_RISE_EN_MASK) >> VID_LVDSO_D2_PIOCFG_EDGE_RISE_EN_SHIFT)
#define  VID_LVDSO_D2_PIOCFG_EDGE_RISE_EN_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D2_PIOCFG_EDGE_RISE_EN_MASK) | (((uint32_t)val) << VID_LVDSO_D2_PIOCFG_EDGE_RISE_EN_SHIFT))

#define  VID_LVDSO_D2_PIOCFG_SLP_SEL_MASK 0x8
#define  VID_LVDSO_D2_PIOCFG_SLP_SEL_SHIFT 3
#define  VID_LVDSO_D2_PIOCFG_SLP_SEL_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D2_PIOCFG_SLP_SEL_MASK) >> VID_LVDSO_D2_PIOCFG_SLP_SEL_SHIFT)
#define  VID_LVDSO_D2_PIOCFG_SLP_SEL_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D2_PIOCFG_SLP_SEL_MASK) | (((uint32_t)val) << VID_LVDSO_D2_PIOCFG_SLP_SEL_SHIFT))

#define  VID_LVDSO_D2_PIOCFG_FUNC_SEL_MASK 0x7
#define  VID_LVDSO_D2_PIOCFG_FUNC_SEL_SHIFT 0
#define  VID_LVDSO_D2_PIOCFG_FUNC_SEL_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D2_PIOCFG_FUNC_SEL_MASK) >> VID_LVDSO_D2_PIOCFG_FUNC_SEL_SHIFT)
#define  VID_LVDSO_D2_PIOCFG_FUNC_SEL_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D2_PIOCFG_FUNC_SEL_MASK) | (((uint32_t)val) << VID_LVDSO_D2_PIOCFG_FUNC_SEL_SHIFT))

//====================================================================
//
//Register File: VID_LVDSo_D3 Configuration Registers (VID_LVDSo_D3)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

//====================================================================
//Register: VID_LVDSo_D3 Configuration Register (PIOCFG)
/** \brief "PTH_PAD2818LVDSOUT" Pad*/
//====================================================================

#define  VID_LVDSO_D3_PIOCFG_RESERVED1_MASK 0xfc000000
#define  VID_LVDSO_D3_PIOCFG_RESERVED1_SHIFT 26
#define  VID_LVDSO_D3_PIOCFG_RESERVED1_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D3_PIOCFG_RESERVED1_MASK) >> VID_LVDSO_D3_PIOCFG_RESERVED1_SHIFT)
#define  VID_LVDSO_D3_PIOCFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D3_PIOCFG_RESERVED1_MASK) | (((uint32_t)val) << VID_LVDSO_D3_PIOCFG_RESERVED1_SHIFT))

#define  VID_LVDSO_D3_PIOCFG_PD_MASK 0x2000000
#define  VID_LVDSO_D3_PIOCFG_PD_SHIFT 25
#define  VID_LVDSO_D3_PIOCFG_PD_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D3_PIOCFG_PD_MASK) >> VID_LVDSO_D3_PIOCFG_PD_SHIFT)
#define  VID_LVDSO_D3_PIOCFG_PD_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D3_PIOCFG_PD_MASK) | (((uint32_t)val) << VID_LVDSO_D3_PIOCFG_PD_SHIFT))

#define  VID_LVDSO_D3_PIOCFG_ODT_EN_MASK 0x1000000
#define  VID_LVDSO_D3_PIOCFG_ODT_EN_SHIFT 24
#define  VID_LVDSO_D3_PIOCFG_ODT_EN_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D3_PIOCFG_ODT_EN_MASK) >> VID_LVDSO_D3_PIOCFG_ODT_EN_SHIFT)
#define  VID_LVDSO_D3_PIOCFG_ODT_EN_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D3_PIOCFG_ODT_EN_MASK) | (((uint32_t)val) << VID_LVDSO_D3_PIOCFG_ODT_EN_SHIFT))

#define  VID_LVDSO_D3_PIOCFG_LED_EN_MASK 0x800000
#define  VID_LVDSO_D3_PIOCFG_LED_EN_SHIFT 23
#define  VID_LVDSO_D3_PIOCFG_LED_EN_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D3_PIOCFG_LED_EN_MASK) >> VID_LVDSO_D3_PIOCFG_LED_EN_SHIFT)
#define  VID_LVDSO_D3_PIOCFG_LED_EN_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D3_PIOCFG_LED_EN_MASK) | (((uint32_t)val) << VID_LVDSO_D3_PIOCFG_LED_EN_SHIFT))

#define  VID_LVDSO_D3_PIOCFG_I2C_SEL_MASK 0x600000
#define  VID_LVDSO_D3_PIOCFG_I2C_SEL_SHIFT 21
#define  VID_LVDSO_D3_PIOCFG_I2C_SEL_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D3_PIOCFG_I2C_SEL_MASK) >> VID_LVDSO_D3_PIOCFG_I2C_SEL_SHIFT)
#define  VID_LVDSO_D3_PIOCFG_I2C_SEL_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D3_PIOCFG_I2C_SEL_MASK) | (((uint32_t)val) << VID_LVDSO_D3_PIOCFG_I2C_SEL_SHIFT))

#define  VID_LVDSO_D3_PIOCFG_DGTBSEL_MASK 0x1e0000
#define  VID_LVDSO_D3_PIOCFG_DGTBSEL_SHIFT 17
#define  VID_LVDSO_D3_PIOCFG_DGTBSEL_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D3_PIOCFG_DGTBSEL_MASK) >> VID_LVDSO_D3_PIOCFG_DGTBSEL_SHIFT)
#define  VID_LVDSO_D3_PIOCFG_DGTBSEL_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D3_PIOCFG_DGTBSEL_MASK) | (((uint32_t)val) << VID_LVDSO_D3_PIOCFG_DGTBSEL_SHIFT))

#define  VID_LVDSO_D3_PIOCFG_RAWSEL_MASK 0x10000
#define  VID_LVDSO_D3_PIOCFG_RAWSEL_SHIFT 16
#define  VID_LVDSO_D3_PIOCFG_RAWSEL_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D3_PIOCFG_RAWSEL_MASK) >> VID_LVDSO_D3_PIOCFG_RAWSEL_SHIFT)
#define  VID_LVDSO_D3_PIOCFG_RAWSEL_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D3_PIOCFG_RAWSEL_MASK) | (((uint32_t)val) << VID_LVDSO_D3_PIOCFG_RAWSEL_SHIFT))

#define  VID_LVDSO_D3_PIOCFG_PULL_SEL_MASK 0x8000
#define  VID_LVDSO_D3_PIOCFG_PULL_SEL_SHIFT 15
#define  VID_LVDSO_D3_PIOCFG_PULL_SEL_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D3_PIOCFG_PULL_SEL_MASK) >> VID_LVDSO_D3_PIOCFG_PULL_SEL_SHIFT)
#define  VID_LVDSO_D3_PIOCFG_PULL_SEL_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D3_PIOCFG_PULL_SEL_MASK) | (((uint32_t)val) << VID_LVDSO_D3_PIOCFG_PULL_SEL_SHIFT))

#define  VID_LVDSO_D3_PIOCFG_PUEN_MASK 0x4000
#define  VID_LVDSO_D3_PIOCFG_PUEN_SHIFT 14
#define  VID_LVDSO_D3_PIOCFG_PUEN_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D3_PIOCFG_PUEN_MASK) >> VID_LVDSO_D3_PIOCFG_PUEN_SHIFT)
#define  VID_LVDSO_D3_PIOCFG_PUEN_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D3_PIOCFG_PUEN_MASK) | (((uint32_t)val) << VID_LVDSO_D3_PIOCFG_PUEN_SHIFT))

#define  VID_LVDSO_D3_PIOCFG_PDEN_MASK 0x2000
#define  VID_LVDSO_D3_PIOCFG_PDEN_SHIFT 13
#define  VID_LVDSO_D3_PIOCFG_PDEN_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D3_PIOCFG_PDEN_MASK) >> VID_LVDSO_D3_PIOCFG_PDEN_SHIFT)
#define  VID_LVDSO_D3_PIOCFG_PDEN_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D3_PIOCFG_PDEN_MASK) | (((uint32_t)val) << VID_LVDSO_D3_PIOCFG_PDEN_SHIFT))

#define  VID_LVDSO_D3_PIOCFG_SP12_MASK 0x1000
#define  VID_LVDSO_D3_PIOCFG_SP12_SHIFT 12
#define  VID_LVDSO_D3_PIOCFG_SP12_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D3_PIOCFG_SP12_MASK) >> VID_LVDSO_D3_PIOCFG_SP12_SHIFT)
#define  VID_LVDSO_D3_PIOCFG_SP12_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D3_PIOCFG_SP12_MASK) | (((uint32_t)val) << VID_LVDSO_D3_PIOCFG_SP12_SHIFT))

#define  VID_LVDSO_D3_PIOCFG_SR_MASK 0x800
#define  VID_LVDSO_D3_PIOCFG_SR_SHIFT 11
#define  VID_LVDSO_D3_PIOCFG_SR_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D3_PIOCFG_SR_MASK) >> VID_LVDSO_D3_PIOCFG_SR_SHIFT)
#define  VID_LVDSO_D3_PIOCFG_SR_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D3_PIOCFG_SR_MASK) | (((uint32_t)val) << VID_LVDSO_D3_PIOCFG_SR_SHIFT))

#define  VID_LVDSO_D3_PIOCFG_SLP_DI_MASK 0x400
#define  VID_LVDSO_D3_PIOCFG_SLP_DI_SHIFT 10
#define  VID_LVDSO_D3_PIOCFG_SLP_DI_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D3_PIOCFG_SLP_DI_MASK) >> VID_LVDSO_D3_PIOCFG_SLP_DI_SHIFT)
#define  VID_LVDSO_D3_PIOCFG_SLP_DI_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D3_PIOCFG_SLP_DI_MASK) | (((uint32_t)val) << VID_LVDSO_D3_PIOCFG_SLP_DI_SHIFT))

#define  VID_LVDSO_D3_PIOCFG_SLP_CNTRL_MASK 0x200
#define  VID_LVDSO_D3_PIOCFG_SLP_CNTRL_SHIFT 9
#define  VID_LVDSO_D3_PIOCFG_SLP_CNTRL_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D3_PIOCFG_SLP_CNTRL_MASK) >> VID_LVDSO_D3_PIOCFG_SLP_CNTRL_SHIFT)
#define  VID_LVDSO_D3_PIOCFG_SLP_CNTRL_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D3_PIOCFG_SLP_CNTRL_MASK) | (((uint32_t)val) << VID_LVDSO_D3_PIOCFG_SLP_CNTRL_SHIFT))

#define  VID_LVDSO_D3_PIOCFG_SLP_DO_MASK 0x100
#define  VID_LVDSO_D3_PIOCFG_SLP_DO_SHIFT 8
#define  VID_LVDSO_D3_PIOCFG_SLP_DO_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D3_PIOCFG_SLP_DO_MASK) >> VID_LVDSO_D3_PIOCFG_SLP_DO_SHIFT)
#define  VID_LVDSO_D3_PIOCFG_SLP_DO_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D3_PIOCFG_SLP_DO_MASK) | (((uint32_t)val) << VID_LVDSO_D3_PIOCFG_SLP_DO_SHIFT))

#define  VID_LVDSO_D3_PIOCFG_SLP_DIR_MASK 0x80
#define  VID_LVDSO_D3_PIOCFG_SLP_DIR_SHIFT 7
#define  VID_LVDSO_D3_PIOCFG_SLP_DIR_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D3_PIOCFG_SLP_DIR_MASK) >> VID_LVDSO_D3_PIOCFG_SLP_DIR_SHIFT)
#define  VID_LVDSO_D3_PIOCFG_SLP_DIR_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D3_PIOCFG_SLP_DIR_MASK) | (((uint32_t)val) << VID_LVDSO_D3_PIOCFG_SLP_DIR_SHIFT))

#define  VID_LVDSO_D3_PIOCFG_EDGE_EN_N_MASK 0x40
#define  VID_LVDSO_D3_PIOCFG_EDGE_EN_N_SHIFT 6
#define  VID_LVDSO_D3_PIOCFG_EDGE_EN_N_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D3_PIOCFG_EDGE_EN_N_MASK) >> VID_LVDSO_D3_PIOCFG_EDGE_EN_N_SHIFT)
#define  VID_LVDSO_D3_PIOCFG_EDGE_EN_N_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D3_PIOCFG_EDGE_EN_N_MASK) | (((uint32_t)val) << VID_LVDSO_D3_PIOCFG_EDGE_EN_N_SHIFT))

#define  VID_LVDSO_D3_PIOCFG_EDGE_FALL_EN_MASK 0x20
#define  VID_LVDSO_D3_PIOCFG_EDGE_FALL_EN_SHIFT 5
#define  VID_LVDSO_D3_PIOCFG_EDGE_FALL_EN_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D3_PIOCFG_EDGE_FALL_EN_MASK) >> VID_LVDSO_D3_PIOCFG_EDGE_FALL_EN_SHIFT)
#define  VID_LVDSO_D3_PIOCFG_EDGE_FALL_EN_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D3_PIOCFG_EDGE_FALL_EN_MASK) | (((uint32_t)val) << VID_LVDSO_D3_PIOCFG_EDGE_FALL_EN_SHIFT))

#define  VID_LVDSO_D3_PIOCFG_EDGE_RISE_EN_MASK 0x10
#define  VID_LVDSO_D3_PIOCFG_EDGE_RISE_EN_SHIFT 4
#define  VID_LVDSO_D3_PIOCFG_EDGE_RISE_EN_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D3_PIOCFG_EDGE_RISE_EN_MASK) >> VID_LVDSO_D3_PIOCFG_EDGE_RISE_EN_SHIFT)
#define  VID_LVDSO_D3_PIOCFG_EDGE_RISE_EN_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D3_PIOCFG_EDGE_RISE_EN_MASK) | (((uint32_t)val) << VID_LVDSO_D3_PIOCFG_EDGE_RISE_EN_SHIFT))

#define  VID_LVDSO_D3_PIOCFG_SLP_SEL_MASK 0x8
#define  VID_LVDSO_D3_PIOCFG_SLP_SEL_SHIFT 3
#define  VID_LVDSO_D3_PIOCFG_SLP_SEL_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D3_PIOCFG_SLP_SEL_MASK) >> VID_LVDSO_D3_PIOCFG_SLP_SEL_SHIFT)
#define  VID_LVDSO_D3_PIOCFG_SLP_SEL_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D3_PIOCFG_SLP_SEL_MASK) | (((uint32_t)val) << VID_LVDSO_D3_PIOCFG_SLP_SEL_SHIFT))

#define  VID_LVDSO_D3_PIOCFG_FUNC_SEL_MASK 0x7
#define  VID_LVDSO_D3_PIOCFG_FUNC_SEL_SHIFT 0
#define  VID_LVDSO_D3_PIOCFG_FUNC_SEL_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D3_PIOCFG_FUNC_SEL_MASK) >> VID_LVDSO_D3_PIOCFG_FUNC_SEL_SHIFT)
#define  VID_LVDSO_D3_PIOCFG_FUNC_SEL_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D3_PIOCFG_FUNC_SEL_MASK) | (((uint32_t)val) << VID_LVDSO_D3_PIOCFG_FUNC_SEL_SHIFT))

//====================================================================
//
//Register File: VID_LVDSo_D4 Configuration Registers (VID_LVDSo_D4)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

//====================================================================
//Register: VID_LVDSo_D4 Configuration Register (PIOCFG)
/** \brief "PTH_PAD2818LVDSOUT" Pad*/
//====================================================================

#define  VID_LVDSO_D4_PIOCFG_RESERVED1_MASK 0xfc000000
#define  VID_LVDSO_D4_PIOCFG_RESERVED1_SHIFT 26
#define  VID_LVDSO_D4_PIOCFG_RESERVED1_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D4_PIOCFG_RESERVED1_MASK) >> VID_LVDSO_D4_PIOCFG_RESERVED1_SHIFT)
#define  VID_LVDSO_D4_PIOCFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D4_PIOCFG_RESERVED1_MASK) | (((uint32_t)val) << VID_LVDSO_D4_PIOCFG_RESERVED1_SHIFT))

#define  VID_LVDSO_D4_PIOCFG_PD_MASK 0x2000000
#define  VID_LVDSO_D4_PIOCFG_PD_SHIFT 25
#define  VID_LVDSO_D4_PIOCFG_PD_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D4_PIOCFG_PD_MASK) >> VID_LVDSO_D4_PIOCFG_PD_SHIFT)
#define  VID_LVDSO_D4_PIOCFG_PD_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D4_PIOCFG_PD_MASK) | (((uint32_t)val) << VID_LVDSO_D4_PIOCFG_PD_SHIFT))

#define  VID_LVDSO_D4_PIOCFG_ODT_EN_MASK 0x1000000
#define  VID_LVDSO_D4_PIOCFG_ODT_EN_SHIFT 24
#define  VID_LVDSO_D4_PIOCFG_ODT_EN_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D4_PIOCFG_ODT_EN_MASK) >> VID_LVDSO_D4_PIOCFG_ODT_EN_SHIFT)
#define  VID_LVDSO_D4_PIOCFG_ODT_EN_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D4_PIOCFG_ODT_EN_MASK) | (((uint32_t)val) << VID_LVDSO_D4_PIOCFG_ODT_EN_SHIFT))

#define  VID_LVDSO_D4_PIOCFG_LED_EN_MASK 0x800000
#define  VID_LVDSO_D4_PIOCFG_LED_EN_SHIFT 23
#define  VID_LVDSO_D4_PIOCFG_LED_EN_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D4_PIOCFG_LED_EN_MASK) >> VID_LVDSO_D4_PIOCFG_LED_EN_SHIFT)
#define  VID_LVDSO_D4_PIOCFG_LED_EN_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D4_PIOCFG_LED_EN_MASK) | (((uint32_t)val) << VID_LVDSO_D4_PIOCFG_LED_EN_SHIFT))

#define  VID_LVDSO_D4_PIOCFG_I2C_SEL_MASK 0x600000
#define  VID_LVDSO_D4_PIOCFG_I2C_SEL_SHIFT 21
#define  VID_LVDSO_D4_PIOCFG_I2C_SEL_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D4_PIOCFG_I2C_SEL_MASK) >> VID_LVDSO_D4_PIOCFG_I2C_SEL_SHIFT)
#define  VID_LVDSO_D4_PIOCFG_I2C_SEL_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D4_PIOCFG_I2C_SEL_MASK) | (((uint32_t)val) << VID_LVDSO_D4_PIOCFG_I2C_SEL_SHIFT))

#define  VID_LVDSO_D4_PIOCFG_DGTBSEL_MASK 0x1e0000
#define  VID_LVDSO_D4_PIOCFG_DGTBSEL_SHIFT 17
#define  VID_LVDSO_D4_PIOCFG_DGTBSEL_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D4_PIOCFG_DGTBSEL_MASK) >> VID_LVDSO_D4_PIOCFG_DGTBSEL_SHIFT)
#define  VID_LVDSO_D4_PIOCFG_DGTBSEL_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D4_PIOCFG_DGTBSEL_MASK) | (((uint32_t)val) << VID_LVDSO_D4_PIOCFG_DGTBSEL_SHIFT))

#define  VID_LVDSO_D4_PIOCFG_RAWSEL_MASK 0x10000
#define  VID_LVDSO_D4_PIOCFG_RAWSEL_SHIFT 16
#define  VID_LVDSO_D4_PIOCFG_RAWSEL_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D4_PIOCFG_RAWSEL_MASK) >> VID_LVDSO_D4_PIOCFG_RAWSEL_SHIFT)
#define  VID_LVDSO_D4_PIOCFG_RAWSEL_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D4_PIOCFG_RAWSEL_MASK) | (((uint32_t)val) << VID_LVDSO_D4_PIOCFG_RAWSEL_SHIFT))

#define  VID_LVDSO_D4_PIOCFG_PULL_SEL_MASK 0x8000
#define  VID_LVDSO_D4_PIOCFG_PULL_SEL_SHIFT 15
#define  VID_LVDSO_D4_PIOCFG_PULL_SEL_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D4_PIOCFG_PULL_SEL_MASK) >> VID_LVDSO_D4_PIOCFG_PULL_SEL_SHIFT)
#define  VID_LVDSO_D4_PIOCFG_PULL_SEL_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D4_PIOCFG_PULL_SEL_MASK) | (((uint32_t)val) << VID_LVDSO_D4_PIOCFG_PULL_SEL_SHIFT))

#define  VID_LVDSO_D4_PIOCFG_PUEN_MASK 0x4000
#define  VID_LVDSO_D4_PIOCFG_PUEN_SHIFT 14
#define  VID_LVDSO_D4_PIOCFG_PUEN_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D4_PIOCFG_PUEN_MASK) >> VID_LVDSO_D4_PIOCFG_PUEN_SHIFT)
#define  VID_LVDSO_D4_PIOCFG_PUEN_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D4_PIOCFG_PUEN_MASK) | (((uint32_t)val) << VID_LVDSO_D4_PIOCFG_PUEN_SHIFT))

#define  VID_LVDSO_D4_PIOCFG_PDEN_MASK 0x2000
#define  VID_LVDSO_D4_PIOCFG_PDEN_SHIFT 13
#define  VID_LVDSO_D4_PIOCFG_PDEN_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D4_PIOCFG_PDEN_MASK) >> VID_LVDSO_D4_PIOCFG_PDEN_SHIFT)
#define  VID_LVDSO_D4_PIOCFG_PDEN_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D4_PIOCFG_PDEN_MASK) | (((uint32_t)val) << VID_LVDSO_D4_PIOCFG_PDEN_SHIFT))

#define  VID_LVDSO_D4_PIOCFG_SP12_MASK 0x1000
#define  VID_LVDSO_D4_PIOCFG_SP12_SHIFT 12
#define  VID_LVDSO_D4_PIOCFG_SP12_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D4_PIOCFG_SP12_MASK) >> VID_LVDSO_D4_PIOCFG_SP12_SHIFT)
#define  VID_LVDSO_D4_PIOCFG_SP12_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D4_PIOCFG_SP12_MASK) | (((uint32_t)val) << VID_LVDSO_D4_PIOCFG_SP12_SHIFT))

#define  VID_LVDSO_D4_PIOCFG_SR_MASK 0x800
#define  VID_LVDSO_D4_PIOCFG_SR_SHIFT 11
#define  VID_LVDSO_D4_PIOCFG_SR_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D4_PIOCFG_SR_MASK) >> VID_LVDSO_D4_PIOCFG_SR_SHIFT)
#define  VID_LVDSO_D4_PIOCFG_SR_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D4_PIOCFG_SR_MASK) | (((uint32_t)val) << VID_LVDSO_D4_PIOCFG_SR_SHIFT))

#define  VID_LVDSO_D4_PIOCFG_SLP_DI_MASK 0x400
#define  VID_LVDSO_D4_PIOCFG_SLP_DI_SHIFT 10
#define  VID_LVDSO_D4_PIOCFG_SLP_DI_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D4_PIOCFG_SLP_DI_MASK) >> VID_LVDSO_D4_PIOCFG_SLP_DI_SHIFT)
#define  VID_LVDSO_D4_PIOCFG_SLP_DI_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D4_PIOCFG_SLP_DI_MASK) | (((uint32_t)val) << VID_LVDSO_D4_PIOCFG_SLP_DI_SHIFT))

#define  VID_LVDSO_D4_PIOCFG_SLP_CNTRL_MASK 0x200
#define  VID_LVDSO_D4_PIOCFG_SLP_CNTRL_SHIFT 9
#define  VID_LVDSO_D4_PIOCFG_SLP_CNTRL_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D4_PIOCFG_SLP_CNTRL_MASK) >> VID_LVDSO_D4_PIOCFG_SLP_CNTRL_SHIFT)
#define  VID_LVDSO_D4_PIOCFG_SLP_CNTRL_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D4_PIOCFG_SLP_CNTRL_MASK) | (((uint32_t)val) << VID_LVDSO_D4_PIOCFG_SLP_CNTRL_SHIFT))

#define  VID_LVDSO_D4_PIOCFG_SLP_DO_MASK 0x100
#define  VID_LVDSO_D4_PIOCFG_SLP_DO_SHIFT 8
#define  VID_LVDSO_D4_PIOCFG_SLP_DO_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D4_PIOCFG_SLP_DO_MASK) >> VID_LVDSO_D4_PIOCFG_SLP_DO_SHIFT)
#define  VID_LVDSO_D4_PIOCFG_SLP_DO_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D4_PIOCFG_SLP_DO_MASK) | (((uint32_t)val) << VID_LVDSO_D4_PIOCFG_SLP_DO_SHIFT))

#define  VID_LVDSO_D4_PIOCFG_SLP_DIR_MASK 0x80
#define  VID_LVDSO_D4_PIOCFG_SLP_DIR_SHIFT 7
#define  VID_LVDSO_D4_PIOCFG_SLP_DIR_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D4_PIOCFG_SLP_DIR_MASK) >> VID_LVDSO_D4_PIOCFG_SLP_DIR_SHIFT)
#define  VID_LVDSO_D4_PIOCFG_SLP_DIR_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D4_PIOCFG_SLP_DIR_MASK) | (((uint32_t)val) << VID_LVDSO_D4_PIOCFG_SLP_DIR_SHIFT))

#define  VID_LVDSO_D4_PIOCFG_EDGE_EN_N_MASK 0x40
#define  VID_LVDSO_D4_PIOCFG_EDGE_EN_N_SHIFT 6
#define  VID_LVDSO_D4_PIOCFG_EDGE_EN_N_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D4_PIOCFG_EDGE_EN_N_MASK) >> VID_LVDSO_D4_PIOCFG_EDGE_EN_N_SHIFT)
#define  VID_LVDSO_D4_PIOCFG_EDGE_EN_N_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D4_PIOCFG_EDGE_EN_N_MASK) | (((uint32_t)val) << VID_LVDSO_D4_PIOCFG_EDGE_EN_N_SHIFT))

#define  VID_LVDSO_D4_PIOCFG_EDGE_FALL_EN_MASK 0x20
#define  VID_LVDSO_D4_PIOCFG_EDGE_FALL_EN_SHIFT 5
#define  VID_LVDSO_D4_PIOCFG_EDGE_FALL_EN_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D4_PIOCFG_EDGE_FALL_EN_MASK) >> VID_LVDSO_D4_PIOCFG_EDGE_FALL_EN_SHIFT)
#define  VID_LVDSO_D4_PIOCFG_EDGE_FALL_EN_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D4_PIOCFG_EDGE_FALL_EN_MASK) | (((uint32_t)val) << VID_LVDSO_D4_PIOCFG_EDGE_FALL_EN_SHIFT))

#define  VID_LVDSO_D4_PIOCFG_EDGE_RISE_EN_MASK 0x10
#define  VID_LVDSO_D4_PIOCFG_EDGE_RISE_EN_SHIFT 4
#define  VID_LVDSO_D4_PIOCFG_EDGE_RISE_EN_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D4_PIOCFG_EDGE_RISE_EN_MASK) >> VID_LVDSO_D4_PIOCFG_EDGE_RISE_EN_SHIFT)
#define  VID_LVDSO_D4_PIOCFG_EDGE_RISE_EN_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D4_PIOCFG_EDGE_RISE_EN_MASK) | (((uint32_t)val) << VID_LVDSO_D4_PIOCFG_EDGE_RISE_EN_SHIFT))

#define  VID_LVDSO_D4_PIOCFG_SLP_SEL_MASK 0x8
#define  VID_LVDSO_D4_PIOCFG_SLP_SEL_SHIFT 3
#define  VID_LVDSO_D4_PIOCFG_SLP_SEL_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D4_PIOCFG_SLP_SEL_MASK) >> VID_LVDSO_D4_PIOCFG_SLP_SEL_SHIFT)
#define  VID_LVDSO_D4_PIOCFG_SLP_SEL_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D4_PIOCFG_SLP_SEL_MASK) | (((uint32_t)val) << VID_LVDSO_D4_PIOCFG_SLP_SEL_SHIFT))

#define  VID_LVDSO_D4_PIOCFG_FUNC_SEL_MASK 0x7
#define  VID_LVDSO_D4_PIOCFG_FUNC_SEL_SHIFT 0
#define  VID_LVDSO_D4_PIOCFG_FUNC_SEL_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D4_PIOCFG_FUNC_SEL_MASK) >> VID_LVDSO_D4_PIOCFG_FUNC_SEL_SHIFT)
#define  VID_LVDSO_D4_PIOCFG_FUNC_SEL_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D4_PIOCFG_FUNC_SEL_MASK) | (((uint32_t)val) << VID_LVDSO_D4_PIOCFG_FUNC_SEL_SHIFT))

//====================================================================
//
//Register File: VID_LVDSo_D5 Configuration Registers (VID_LVDSo_D5)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

//====================================================================
//Register: VID_LVDSo_D5 Configuration Register (PIOCFG)
/** \brief "PTH_PAD2818LVDSOUT" Pad*/
//====================================================================

#define  VID_LVDSO_D5_PIOCFG_RESERVED1_MASK 0xfc000000
#define  VID_LVDSO_D5_PIOCFG_RESERVED1_SHIFT 26
#define  VID_LVDSO_D5_PIOCFG_RESERVED1_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D5_PIOCFG_RESERVED1_MASK) >> VID_LVDSO_D5_PIOCFG_RESERVED1_SHIFT)
#define  VID_LVDSO_D5_PIOCFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D5_PIOCFG_RESERVED1_MASK) | (((uint32_t)val) << VID_LVDSO_D5_PIOCFG_RESERVED1_SHIFT))

#define  VID_LVDSO_D5_PIOCFG_PD_MASK 0x2000000
#define  VID_LVDSO_D5_PIOCFG_PD_SHIFT 25
#define  VID_LVDSO_D5_PIOCFG_PD_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D5_PIOCFG_PD_MASK) >> VID_LVDSO_D5_PIOCFG_PD_SHIFT)
#define  VID_LVDSO_D5_PIOCFG_PD_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D5_PIOCFG_PD_MASK) | (((uint32_t)val) << VID_LVDSO_D5_PIOCFG_PD_SHIFT))

#define  VID_LVDSO_D5_PIOCFG_ODT_EN_MASK 0x1000000
#define  VID_LVDSO_D5_PIOCFG_ODT_EN_SHIFT 24
#define  VID_LVDSO_D5_PIOCFG_ODT_EN_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D5_PIOCFG_ODT_EN_MASK) >> VID_LVDSO_D5_PIOCFG_ODT_EN_SHIFT)
#define  VID_LVDSO_D5_PIOCFG_ODT_EN_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D5_PIOCFG_ODT_EN_MASK) | (((uint32_t)val) << VID_LVDSO_D5_PIOCFG_ODT_EN_SHIFT))

#define  VID_LVDSO_D5_PIOCFG_LED_EN_MASK 0x800000
#define  VID_LVDSO_D5_PIOCFG_LED_EN_SHIFT 23
#define  VID_LVDSO_D5_PIOCFG_LED_EN_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D5_PIOCFG_LED_EN_MASK) >> VID_LVDSO_D5_PIOCFG_LED_EN_SHIFT)
#define  VID_LVDSO_D5_PIOCFG_LED_EN_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D5_PIOCFG_LED_EN_MASK) | (((uint32_t)val) << VID_LVDSO_D5_PIOCFG_LED_EN_SHIFT))

#define  VID_LVDSO_D5_PIOCFG_I2C_SEL_MASK 0x600000
#define  VID_LVDSO_D5_PIOCFG_I2C_SEL_SHIFT 21
#define  VID_LVDSO_D5_PIOCFG_I2C_SEL_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D5_PIOCFG_I2C_SEL_MASK) >> VID_LVDSO_D5_PIOCFG_I2C_SEL_SHIFT)
#define  VID_LVDSO_D5_PIOCFG_I2C_SEL_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D5_PIOCFG_I2C_SEL_MASK) | (((uint32_t)val) << VID_LVDSO_D5_PIOCFG_I2C_SEL_SHIFT))

#define  VID_LVDSO_D5_PIOCFG_DGTBSEL_MASK 0x1e0000
#define  VID_LVDSO_D5_PIOCFG_DGTBSEL_SHIFT 17
#define  VID_LVDSO_D5_PIOCFG_DGTBSEL_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D5_PIOCFG_DGTBSEL_MASK) >> VID_LVDSO_D5_PIOCFG_DGTBSEL_SHIFT)
#define  VID_LVDSO_D5_PIOCFG_DGTBSEL_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D5_PIOCFG_DGTBSEL_MASK) | (((uint32_t)val) << VID_LVDSO_D5_PIOCFG_DGTBSEL_SHIFT))

#define  VID_LVDSO_D5_PIOCFG_RAWSEL_MASK 0x10000
#define  VID_LVDSO_D5_PIOCFG_RAWSEL_SHIFT 16
#define  VID_LVDSO_D5_PIOCFG_RAWSEL_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D5_PIOCFG_RAWSEL_MASK) >> VID_LVDSO_D5_PIOCFG_RAWSEL_SHIFT)
#define  VID_LVDSO_D5_PIOCFG_RAWSEL_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D5_PIOCFG_RAWSEL_MASK) | (((uint32_t)val) << VID_LVDSO_D5_PIOCFG_RAWSEL_SHIFT))

#define  VID_LVDSO_D5_PIOCFG_PULL_SEL_MASK 0x8000
#define  VID_LVDSO_D5_PIOCFG_PULL_SEL_SHIFT 15
#define  VID_LVDSO_D5_PIOCFG_PULL_SEL_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D5_PIOCFG_PULL_SEL_MASK) >> VID_LVDSO_D5_PIOCFG_PULL_SEL_SHIFT)
#define  VID_LVDSO_D5_PIOCFG_PULL_SEL_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D5_PIOCFG_PULL_SEL_MASK) | (((uint32_t)val) << VID_LVDSO_D5_PIOCFG_PULL_SEL_SHIFT))

#define  VID_LVDSO_D5_PIOCFG_PUEN_MASK 0x4000
#define  VID_LVDSO_D5_PIOCFG_PUEN_SHIFT 14
#define  VID_LVDSO_D5_PIOCFG_PUEN_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D5_PIOCFG_PUEN_MASK) >> VID_LVDSO_D5_PIOCFG_PUEN_SHIFT)
#define  VID_LVDSO_D5_PIOCFG_PUEN_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D5_PIOCFG_PUEN_MASK) | (((uint32_t)val) << VID_LVDSO_D5_PIOCFG_PUEN_SHIFT))

#define  VID_LVDSO_D5_PIOCFG_PDEN_MASK 0x2000
#define  VID_LVDSO_D5_PIOCFG_PDEN_SHIFT 13
#define  VID_LVDSO_D5_PIOCFG_PDEN_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D5_PIOCFG_PDEN_MASK) >> VID_LVDSO_D5_PIOCFG_PDEN_SHIFT)
#define  VID_LVDSO_D5_PIOCFG_PDEN_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D5_PIOCFG_PDEN_MASK) | (((uint32_t)val) << VID_LVDSO_D5_PIOCFG_PDEN_SHIFT))

#define  VID_LVDSO_D5_PIOCFG_SP12_MASK 0x1000
#define  VID_LVDSO_D5_PIOCFG_SP12_SHIFT 12
#define  VID_LVDSO_D5_PIOCFG_SP12_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D5_PIOCFG_SP12_MASK) >> VID_LVDSO_D5_PIOCFG_SP12_SHIFT)
#define  VID_LVDSO_D5_PIOCFG_SP12_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D5_PIOCFG_SP12_MASK) | (((uint32_t)val) << VID_LVDSO_D5_PIOCFG_SP12_SHIFT))

#define  VID_LVDSO_D5_PIOCFG_SR_MASK 0x800
#define  VID_LVDSO_D5_PIOCFG_SR_SHIFT 11
#define  VID_LVDSO_D5_PIOCFG_SR_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D5_PIOCFG_SR_MASK) >> VID_LVDSO_D5_PIOCFG_SR_SHIFT)
#define  VID_LVDSO_D5_PIOCFG_SR_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D5_PIOCFG_SR_MASK) | (((uint32_t)val) << VID_LVDSO_D5_PIOCFG_SR_SHIFT))

#define  VID_LVDSO_D5_PIOCFG_SLP_DI_MASK 0x400
#define  VID_LVDSO_D5_PIOCFG_SLP_DI_SHIFT 10
#define  VID_LVDSO_D5_PIOCFG_SLP_DI_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D5_PIOCFG_SLP_DI_MASK) >> VID_LVDSO_D5_PIOCFG_SLP_DI_SHIFT)
#define  VID_LVDSO_D5_PIOCFG_SLP_DI_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D5_PIOCFG_SLP_DI_MASK) | (((uint32_t)val) << VID_LVDSO_D5_PIOCFG_SLP_DI_SHIFT))

#define  VID_LVDSO_D5_PIOCFG_SLP_CNTRL_MASK 0x200
#define  VID_LVDSO_D5_PIOCFG_SLP_CNTRL_SHIFT 9
#define  VID_LVDSO_D5_PIOCFG_SLP_CNTRL_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D5_PIOCFG_SLP_CNTRL_MASK) >> VID_LVDSO_D5_PIOCFG_SLP_CNTRL_SHIFT)
#define  VID_LVDSO_D5_PIOCFG_SLP_CNTRL_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D5_PIOCFG_SLP_CNTRL_MASK) | (((uint32_t)val) << VID_LVDSO_D5_PIOCFG_SLP_CNTRL_SHIFT))

#define  VID_LVDSO_D5_PIOCFG_SLP_DO_MASK 0x100
#define  VID_LVDSO_D5_PIOCFG_SLP_DO_SHIFT 8
#define  VID_LVDSO_D5_PIOCFG_SLP_DO_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D5_PIOCFG_SLP_DO_MASK) >> VID_LVDSO_D5_PIOCFG_SLP_DO_SHIFT)
#define  VID_LVDSO_D5_PIOCFG_SLP_DO_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D5_PIOCFG_SLP_DO_MASK) | (((uint32_t)val) << VID_LVDSO_D5_PIOCFG_SLP_DO_SHIFT))

#define  VID_LVDSO_D5_PIOCFG_SLP_DIR_MASK 0x80
#define  VID_LVDSO_D5_PIOCFG_SLP_DIR_SHIFT 7
#define  VID_LVDSO_D5_PIOCFG_SLP_DIR_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D5_PIOCFG_SLP_DIR_MASK) >> VID_LVDSO_D5_PIOCFG_SLP_DIR_SHIFT)
#define  VID_LVDSO_D5_PIOCFG_SLP_DIR_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D5_PIOCFG_SLP_DIR_MASK) | (((uint32_t)val) << VID_LVDSO_D5_PIOCFG_SLP_DIR_SHIFT))

#define  VID_LVDSO_D5_PIOCFG_EDGE_EN_N_MASK 0x40
#define  VID_LVDSO_D5_PIOCFG_EDGE_EN_N_SHIFT 6
#define  VID_LVDSO_D5_PIOCFG_EDGE_EN_N_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D5_PIOCFG_EDGE_EN_N_MASK) >> VID_LVDSO_D5_PIOCFG_EDGE_EN_N_SHIFT)
#define  VID_LVDSO_D5_PIOCFG_EDGE_EN_N_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D5_PIOCFG_EDGE_EN_N_MASK) | (((uint32_t)val) << VID_LVDSO_D5_PIOCFG_EDGE_EN_N_SHIFT))

#define  VID_LVDSO_D5_PIOCFG_EDGE_FALL_EN_MASK 0x20
#define  VID_LVDSO_D5_PIOCFG_EDGE_FALL_EN_SHIFT 5
#define  VID_LVDSO_D5_PIOCFG_EDGE_FALL_EN_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D5_PIOCFG_EDGE_FALL_EN_MASK) >> VID_LVDSO_D5_PIOCFG_EDGE_FALL_EN_SHIFT)
#define  VID_LVDSO_D5_PIOCFG_EDGE_FALL_EN_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D5_PIOCFG_EDGE_FALL_EN_MASK) | (((uint32_t)val) << VID_LVDSO_D5_PIOCFG_EDGE_FALL_EN_SHIFT))

#define  VID_LVDSO_D5_PIOCFG_EDGE_RISE_EN_MASK 0x10
#define  VID_LVDSO_D5_PIOCFG_EDGE_RISE_EN_SHIFT 4
#define  VID_LVDSO_D5_PIOCFG_EDGE_RISE_EN_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D5_PIOCFG_EDGE_RISE_EN_MASK) >> VID_LVDSO_D5_PIOCFG_EDGE_RISE_EN_SHIFT)
#define  VID_LVDSO_D5_PIOCFG_EDGE_RISE_EN_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D5_PIOCFG_EDGE_RISE_EN_MASK) | (((uint32_t)val) << VID_LVDSO_D5_PIOCFG_EDGE_RISE_EN_SHIFT))

#define  VID_LVDSO_D5_PIOCFG_SLP_SEL_MASK 0x8
#define  VID_LVDSO_D5_PIOCFG_SLP_SEL_SHIFT 3
#define  VID_LVDSO_D5_PIOCFG_SLP_SEL_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D5_PIOCFG_SLP_SEL_MASK) >> VID_LVDSO_D5_PIOCFG_SLP_SEL_SHIFT)
#define  VID_LVDSO_D5_PIOCFG_SLP_SEL_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D5_PIOCFG_SLP_SEL_MASK) | (((uint32_t)val) << VID_LVDSO_D5_PIOCFG_SLP_SEL_SHIFT))

#define  VID_LVDSO_D5_PIOCFG_FUNC_SEL_MASK 0x7
#define  VID_LVDSO_D5_PIOCFG_FUNC_SEL_SHIFT 0
#define  VID_LVDSO_D5_PIOCFG_FUNC_SEL_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D5_PIOCFG_FUNC_SEL_MASK) >> VID_LVDSO_D5_PIOCFG_FUNC_SEL_SHIFT)
#define  VID_LVDSO_D5_PIOCFG_FUNC_SEL_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D5_PIOCFG_FUNC_SEL_MASK) | (((uint32_t)val) << VID_LVDSO_D5_PIOCFG_FUNC_SEL_SHIFT))

//====================================================================
//
//Register File: VID_LVDSo_D6 Configuration Registers (VID_LVDSo_D6)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

//====================================================================
//Register: VID_LVDSo_D6 Configuration Register (PIOCFG)
/** \brief "PTH_PAD2818LVDSOUT" Pad*/
//====================================================================

#define  VID_LVDSO_D6_PIOCFG_RESERVED1_MASK 0xfc000000
#define  VID_LVDSO_D6_PIOCFG_RESERVED1_SHIFT 26
#define  VID_LVDSO_D6_PIOCFG_RESERVED1_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D6_PIOCFG_RESERVED1_MASK) >> VID_LVDSO_D6_PIOCFG_RESERVED1_SHIFT)
#define  VID_LVDSO_D6_PIOCFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D6_PIOCFG_RESERVED1_MASK) | (((uint32_t)val) << VID_LVDSO_D6_PIOCFG_RESERVED1_SHIFT))

#define  VID_LVDSO_D6_PIOCFG_PD_MASK 0x2000000
#define  VID_LVDSO_D6_PIOCFG_PD_SHIFT 25
#define  VID_LVDSO_D6_PIOCFG_PD_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D6_PIOCFG_PD_MASK) >> VID_LVDSO_D6_PIOCFG_PD_SHIFT)
#define  VID_LVDSO_D6_PIOCFG_PD_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D6_PIOCFG_PD_MASK) | (((uint32_t)val) << VID_LVDSO_D6_PIOCFG_PD_SHIFT))

#define  VID_LVDSO_D6_PIOCFG_ODT_EN_MASK 0x1000000
#define  VID_LVDSO_D6_PIOCFG_ODT_EN_SHIFT 24
#define  VID_LVDSO_D6_PIOCFG_ODT_EN_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D6_PIOCFG_ODT_EN_MASK) >> VID_LVDSO_D6_PIOCFG_ODT_EN_SHIFT)
#define  VID_LVDSO_D6_PIOCFG_ODT_EN_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D6_PIOCFG_ODT_EN_MASK) | (((uint32_t)val) << VID_LVDSO_D6_PIOCFG_ODT_EN_SHIFT))

#define  VID_LVDSO_D6_PIOCFG_LED_EN_MASK 0x800000
#define  VID_LVDSO_D6_PIOCFG_LED_EN_SHIFT 23
#define  VID_LVDSO_D6_PIOCFG_LED_EN_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D6_PIOCFG_LED_EN_MASK) >> VID_LVDSO_D6_PIOCFG_LED_EN_SHIFT)
#define  VID_LVDSO_D6_PIOCFG_LED_EN_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D6_PIOCFG_LED_EN_MASK) | (((uint32_t)val) << VID_LVDSO_D6_PIOCFG_LED_EN_SHIFT))

#define  VID_LVDSO_D6_PIOCFG_I2C_SEL_MASK 0x600000
#define  VID_LVDSO_D6_PIOCFG_I2C_SEL_SHIFT 21
#define  VID_LVDSO_D6_PIOCFG_I2C_SEL_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D6_PIOCFG_I2C_SEL_MASK) >> VID_LVDSO_D6_PIOCFG_I2C_SEL_SHIFT)
#define  VID_LVDSO_D6_PIOCFG_I2C_SEL_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D6_PIOCFG_I2C_SEL_MASK) | (((uint32_t)val) << VID_LVDSO_D6_PIOCFG_I2C_SEL_SHIFT))

#define  VID_LVDSO_D6_PIOCFG_DGTBSEL_MASK 0x1e0000
#define  VID_LVDSO_D6_PIOCFG_DGTBSEL_SHIFT 17
#define  VID_LVDSO_D6_PIOCFG_DGTBSEL_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D6_PIOCFG_DGTBSEL_MASK) >> VID_LVDSO_D6_PIOCFG_DGTBSEL_SHIFT)
#define  VID_LVDSO_D6_PIOCFG_DGTBSEL_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D6_PIOCFG_DGTBSEL_MASK) | (((uint32_t)val) << VID_LVDSO_D6_PIOCFG_DGTBSEL_SHIFT))

#define  VID_LVDSO_D6_PIOCFG_RAWSEL_MASK 0x10000
#define  VID_LVDSO_D6_PIOCFG_RAWSEL_SHIFT 16
#define  VID_LVDSO_D6_PIOCFG_RAWSEL_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D6_PIOCFG_RAWSEL_MASK) >> VID_LVDSO_D6_PIOCFG_RAWSEL_SHIFT)
#define  VID_LVDSO_D6_PIOCFG_RAWSEL_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D6_PIOCFG_RAWSEL_MASK) | (((uint32_t)val) << VID_LVDSO_D6_PIOCFG_RAWSEL_SHIFT))

#define  VID_LVDSO_D6_PIOCFG_PULL_SEL_MASK 0x8000
#define  VID_LVDSO_D6_PIOCFG_PULL_SEL_SHIFT 15
#define  VID_LVDSO_D6_PIOCFG_PULL_SEL_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D6_PIOCFG_PULL_SEL_MASK) >> VID_LVDSO_D6_PIOCFG_PULL_SEL_SHIFT)
#define  VID_LVDSO_D6_PIOCFG_PULL_SEL_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D6_PIOCFG_PULL_SEL_MASK) | (((uint32_t)val) << VID_LVDSO_D6_PIOCFG_PULL_SEL_SHIFT))

#define  VID_LVDSO_D6_PIOCFG_PUEN_MASK 0x4000
#define  VID_LVDSO_D6_PIOCFG_PUEN_SHIFT 14
#define  VID_LVDSO_D6_PIOCFG_PUEN_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D6_PIOCFG_PUEN_MASK) >> VID_LVDSO_D6_PIOCFG_PUEN_SHIFT)
#define  VID_LVDSO_D6_PIOCFG_PUEN_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D6_PIOCFG_PUEN_MASK) | (((uint32_t)val) << VID_LVDSO_D6_PIOCFG_PUEN_SHIFT))

#define  VID_LVDSO_D6_PIOCFG_PDEN_MASK 0x2000
#define  VID_LVDSO_D6_PIOCFG_PDEN_SHIFT 13
#define  VID_LVDSO_D6_PIOCFG_PDEN_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D6_PIOCFG_PDEN_MASK) >> VID_LVDSO_D6_PIOCFG_PDEN_SHIFT)
#define  VID_LVDSO_D6_PIOCFG_PDEN_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D6_PIOCFG_PDEN_MASK) | (((uint32_t)val) << VID_LVDSO_D6_PIOCFG_PDEN_SHIFT))

#define  VID_LVDSO_D6_PIOCFG_SP12_MASK 0x1000
#define  VID_LVDSO_D6_PIOCFG_SP12_SHIFT 12
#define  VID_LVDSO_D6_PIOCFG_SP12_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D6_PIOCFG_SP12_MASK) >> VID_LVDSO_D6_PIOCFG_SP12_SHIFT)
#define  VID_LVDSO_D6_PIOCFG_SP12_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D6_PIOCFG_SP12_MASK) | (((uint32_t)val) << VID_LVDSO_D6_PIOCFG_SP12_SHIFT))

#define  VID_LVDSO_D6_PIOCFG_SR_MASK 0x800
#define  VID_LVDSO_D6_PIOCFG_SR_SHIFT 11
#define  VID_LVDSO_D6_PIOCFG_SR_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D6_PIOCFG_SR_MASK) >> VID_LVDSO_D6_PIOCFG_SR_SHIFT)
#define  VID_LVDSO_D6_PIOCFG_SR_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D6_PIOCFG_SR_MASK) | (((uint32_t)val) << VID_LVDSO_D6_PIOCFG_SR_SHIFT))

#define  VID_LVDSO_D6_PIOCFG_SLP_DI_MASK 0x400
#define  VID_LVDSO_D6_PIOCFG_SLP_DI_SHIFT 10
#define  VID_LVDSO_D6_PIOCFG_SLP_DI_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D6_PIOCFG_SLP_DI_MASK) >> VID_LVDSO_D6_PIOCFG_SLP_DI_SHIFT)
#define  VID_LVDSO_D6_PIOCFG_SLP_DI_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D6_PIOCFG_SLP_DI_MASK) | (((uint32_t)val) << VID_LVDSO_D6_PIOCFG_SLP_DI_SHIFT))

#define  VID_LVDSO_D6_PIOCFG_SLP_CNTRL_MASK 0x200
#define  VID_LVDSO_D6_PIOCFG_SLP_CNTRL_SHIFT 9
#define  VID_LVDSO_D6_PIOCFG_SLP_CNTRL_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D6_PIOCFG_SLP_CNTRL_MASK) >> VID_LVDSO_D6_PIOCFG_SLP_CNTRL_SHIFT)
#define  VID_LVDSO_D6_PIOCFG_SLP_CNTRL_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D6_PIOCFG_SLP_CNTRL_MASK) | (((uint32_t)val) << VID_LVDSO_D6_PIOCFG_SLP_CNTRL_SHIFT))

#define  VID_LVDSO_D6_PIOCFG_SLP_DO_MASK 0x100
#define  VID_LVDSO_D6_PIOCFG_SLP_DO_SHIFT 8
#define  VID_LVDSO_D6_PIOCFG_SLP_DO_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D6_PIOCFG_SLP_DO_MASK) >> VID_LVDSO_D6_PIOCFG_SLP_DO_SHIFT)
#define  VID_LVDSO_D6_PIOCFG_SLP_DO_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D6_PIOCFG_SLP_DO_MASK) | (((uint32_t)val) << VID_LVDSO_D6_PIOCFG_SLP_DO_SHIFT))

#define  VID_LVDSO_D6_PIOCFG_SLP_DIR_MASK 0x80
#define  VID_LVDSO_D6_PIOCFG_SLP_DIR_SHIFT 7
#define  VID_LVDSO_D6_PIOCFG_SLP_DIR_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D6_PIOCFG_SLP_DIR_MASK) >> VID_LVDSO_D6_PIOCFG_SLP_DIR_SHIFT)
#define  VID_LVDSO_D6_PIOCFG_SLP_DIR_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D6_PIOCFG_SLP_DIR_MASK) | (((uint32_t)val) << VID_LVDSO_D6_PIOCFG_SLP_DIR_SHIFT))

#define  VID_LVDSO_D6_PIOCFG_EDGE_EN_N_MASK 0x40
#define  VID_LVDSO_D6_PIOCFG_EDGE_EN_N_SHIFT 6
#define  VID_LVDSO_D6_PIOCFG_EDGE_EN_N_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D6_PIOCFG_EDGE_EN_N_MASK) >> VID_LVDSO_D6_PIOCFG_EDGE_EN_N_SHIFT)
#define  VID_LVDSO_D6_PIOCFG_EDGE_EN_N_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D6_PIOCFG_EDGE_EN_N_MASK) | (((uint32_t)val) << VID_LVDSO_D6_PIOCFG_EDGE_EN_N_SHIFT))

#define  VID_LVDSO_D6_PIOCFG_EDGE_FALL_EN_MASK 0x20
#define  VID_LVDSO_D6_PIOCFG_EDGE_FALL_EN_SHIFT 5
#define  VID_LVDSO_D6_PIOCFG_EDGE_FALL_EN_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D6_PIOCFG_EDGE_FALL_EN_MASK) >> VID_LVDSO_D6_PIOCFG_EDGE_FALL_EN_SHIFT)
#define  VID_LVDSO_D6_PIOCFG_EDGE_FALL_EN_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D6_PIOCFG_EDGE_FALL_EN_MASK) | (((uint32_t)val) << VID_LVDSO_D6_PIOCFG_EDGE_FALL_EN_SHIFT))

#define  VID_LVDSO_D6_PIOCFG_EDGE_RISE_EN_MASK 0x10
#define  VID_LVDSO_D6_PIOCFG_EDGE_RISE_EN_SHIFT 4
#define  VID_LVDSO_D6_PIOCFG_EDGE_RISE_EN_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D6_PIOCFG_EDGE_RISE_EN_MASK) >> VID_LVDSO_D6_PIOCFG_EDGE_RISE_EN_SHIFT)
#define  VID_LVDSO_D6_PIOCFG_EDGE_RISE_EN_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D6_PIOCFG_EDGE_RISE_EN_MASK) | (((uint32_t)val) << VID_LVDSO_D6_PIOCFG_EDGE_RISE_EN_SHIFT))

#define  VID_LVDSO_D6_PIOCFG_SLP_SEL_MASK 0x8
#define  VID_LVDSO_D6_PIOCFG_SLP_SEL_SHIFT 3
#define  VID_LVDSO_D6_PIOCFG_SLP_SEL_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D6_PIOCFG_SLP_SEL_MASK) >> VID_LVDSO_D6_PIOCFG_SLP_SEL_SHIFT)
#define  VID_LVDSO_D6_PIOCFG_SLP_SEL_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D6_PIOCFG_SLP_SEL_MASK) | (((uint32_t)val) << VID_LVDSO_D6_PIOCFG_SLP_SEL_SHIFT))

#define  VID_LVDSO_D6_PIOCFG_FUNC_SEL_MASK 0x7
#define  VID_LVDSO_D6_PIOCFG_FUNC_SEL_SHIFT 0
#define  VID_LVDSO_D6_PIOCFG_FUNC_SEL_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D6_PIOCFG_FUNC_SEL_MASK) >> VID_LVDSO_D6_PIOCFG_FUNC_SEL_SHIFT)
#define  VID_LVDSO_D6_PIOCFG_FUNC_SEL_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D6_PIOCFG_FUNC_SEL_MASK) | (((uint32_t)val) << VID_LVDSO_D6_PIOCFG_FUNC_SEL_SHIFT))

//====================================================================
//
//Register File: VID_LVDSo_D7 Configuration Registers (VID_LVDSo_D7)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

//====================================================================
//Register: VID_LVDSo_D7 Configuration Register (PIOCFG)
/** \brief "PTH_PAD2818LVDSOUT" Pad*/
//====================================================================

#define  VID_LVDSO_D7_PIOCFG_RESERVED1_MASK 0xfc000000
#define  VID_LVDSO_D7_PIOCFG_RESERVED1_SHIFT 26
#define  VID_LVDSO_D7_PIOCFG_RESERVED1_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D7_PIOCFG_RESERVED1_MASK) >> VID_LVDSO_D7_PIOCFG_RESERVED1_SHIFT)
#define  VID_LVDSO_D7_PIOCFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D7_PIOCFG_RESERVED1_MASK) | (((uint32_t)val) << VID_LVDSO_D7_PIOCFG_RESERVED1_SHIFT))

#define  VID_LVDSO_D7_PIOCFG_PD_MASK 0x2000000
#define  VID_LVDSO_D7_PIOCFG_PD_SHIFT 25
#define  VID_LVDSO_D7_PIOCFG_PD_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D7_PIOCFG_PD_MASK) >> VID_LVDSO_D7_PIOCFG_PD_SHIFT)
#define  VID_LVDSO_D7_PIOCFG_PD_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D7_PIOCFG_PD_MASK) | (((uint32_t)val) << VID_LVDSO_D7_PIOCFG_PD_SHIFT))

#define  VID_LVDSO_D7_PIOCFG_ODT_EN_MASK 0x1000000
#define  VID_LVDSO_D7_PIOCFG_ODT_EN_SHIFT 24
#define  VID_LVDSO_D7_PIOCFG_ODT_EN_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D7_PIOCFG_ODT_EN_MASK) >> VID_LVDSO_D7_PIOCFG_ODT_EN_SHIFT)
#define  VID_LVDSO_D7_PIOCFG_ODT_EN_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D7_PIOCFG_ODT_EN_MASK) | (((uint32_t)val) << VID_LVDSO_D7_PIOCFG_ODT_EN_SHIFT))

#define  VID_LVDSO_D7_PIOCFG_LED_EN_MASK 0x800000
#define  VID_LVDSO_D7_PIOCFG_LED_EN_SHIFT 23
#define  VID_LVDSO_D7_PIOCFG_LED_EN_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D7_PIOCFG_LED_EN_MASK) >> VID_LVDSO_D7_PIOCFG_LED_EN_SHIFT)
#define  VID_LVDSO_D7_PIOCFG_LED_EN_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D7_PIOCFG_LED_EN_MASK) | (((uint32_t)val) << VID_LVDSO_D7_PIOCFG_LED_EN_SHIFT))

#define  VID_LVDSO_D7_PIOCFG_I2C_SEL_MASK 0x600000
#define  VID_LVDSO_D7_PIOCFG_I2C_SEL_SHIFT 21
#define  VID_LVDSO_D7_PIOCFG_I2C_SEL_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D7_PIOCFG_I2C_SEL_MASK) >> VID_LVDSO_D7_PIOCFG_I2C_SEL_SHIFT)
#define  VID_LVDSO_D7_PIOCFG_I2C_SEL_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D7_PIOCFG_I2C_SEL_MASK) | (((uint32_t)val) << VID_LVDSO_D7_PIOCFG_I2C_SEL_SHIFT))

#define  VID_LVDSO_D7_PIOCFG_DGTBSEL_MASK 0x1e0000
#define  VID_LVDSO_D7_PIOCFG_DGTBSEL_SHIFT 17
#define  VID_LVDSO_D7_PIOCFG_DGTBSEL_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D7_PIOCFG_DGTBSEL_MASK) >> VID_LVDSO_D7_PIOCFG_DGTBSEL_SHIFT)
#define  VID_LVDSO_D7_PIOCFG_DGTBSEL_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D7_PIOCFG_DGTBSEL_MASK) | (((uint32_t)val) << VID_LVDSO_D7_PIOCFG_DGTBSEL_SHIFT))

#define  VID_LVDSO_D7_PIOCFG_RAWSEL_MASK 0x10000
#define  VID_LVDSO_D7_PIOCFG_RAWSEL_SHIFT 16
#define  VID_LVDSO_D7_PIOCFG_RAWSEL_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D7_PIOCFG_RAWSEL_MASK) >> VID_LVDSO_D7_PIOCFG_RAWSEL_SHIFT)
#define  VID_LVDSO_D7_PIOCFG_RAWSEL_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D7_PIOCFG_RAWSEL_MASK) | (((uint32_t)val) << VID_LVDSO_D7_PIOCFG_RAWSEL_SHIFT))

#define  VID_LVDSO_D7_PIOCFG_PULL_SEL_MASK 0x8000
#define  VID_LVDSO_D7_PIOCFG_PULL_SEL_SHIFT 15
#define  VID_LVDSO_D7_PIOCFG_PULL_SEL_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D7_PIOCFG_PULL_SEL_MASK) >> VID_LVDSO_D7_PIOCFG_PULL_SEL_SHIFT)
#define  VID_LVDSO_D7_PIOCFG_PULL_SEL_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D7_PIOCFG_PULL_SEL_MASK) | (((uint32_t)val) << VID_LVDSO_D7_PIOCFG_PULL_SEL_SHIFT))

#define  VID_LVDSO_D7_PIOCFG_PUEN_MASK 0x4000
#define  VID_LVDSO_D7_PIOCFG_PUEN_SHIFT 14
#define  VID_LVDSO_D7_PIOCFG_PUEN_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D7_PIOCFG_PUEN_MASK) >> VID_LVDSO_D7_PIOCFG_PUEN_SHIFT)
#define  VID_LVDSO_D7_PIOCFG_PUEN_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D7_PIOCFG_PUEN_MASK) | (((uint32_t)val) << VID_LVDSO_D7_PIOCFG_PUEN_SHIFT))

#define  VID_LVDSO_D7_PIOCFG_PDEN_MASK 0x2000
#define  VID_LVDSO_D7_PIOCFG_PDEN_SHIFT 13
#define  VID_LVDSO_D7_PIOCFG_PDEN_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D7_PIOCFG_PDEN_MASK) >> VID_LVDSO_D7_PIOCFG_PDEN_SHIFT)
#define  VID_LVDSO_D7_PIOCFG_PDEN_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D7_PIOCFG_PDEN_MASK) | (((uint32_t)val) << VID_LVDSO_D7_PIOCFG_PDEN_SHIFT))

#define  VID_LVDSO_D7_PIOCFG_SP12_MASK 0x1000
#define  VID_LVDSO_D7_PIOCFG_SP12_SHIFT 12
#define  VID_LVDSO_D7_PIOCFG_SP12_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D7_PIOCFG_SP12_MASK) >> VID_LVDSO_D7_PIOCFG_SP12_SHIFT)
#define  VID_LVDSO_D7_PIOCFG_SP12_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D7_PIOCFG_SP12_MASK) | (((uint32_t)val) << VID_LVDSO_D7_PIOCFG_SP12_SHIFT))

#define  VID_LVDSO_D7_PIOCFG_SR_MASK 0x800
#define  VID_LVDSO_D7_PIOCFG_SR_SHIFT 11
#define  VID_LVDSO_D7_PIOCFG_SR_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D7_PIOCFG_SR_MASK) >> VID_LVDSO_D7_PIOCFG_SR_SHIFT)
#define  VID_LVDSO_D7_PIOCFG_SR_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D7_PIOCFG_SR_MASK) | (((uint32_t)val) << VID_LVDSO_D7_PIOCFG_SR_SHIFT))

#define  VID_LVDSO_D7_PIOCFG_SLP_DI_MASK 0x400
#define  VID_LVDSO_D7_PIOCFG_SLP_DI_SHIFT 10
#define  VID_LVDSO_D7_PIOCFG_SLP_DI_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D7_PIOCFG_SLP_DI_MASK) >> VID_LVDSO_D7_PIOCFG_SLP_DI_SHIFT)
#define  VID_LVDSO_D7_PIOCFG_SLP_DI_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D7_PIOCFG_SLP_DI_MASK) | (((uint32_t)val) << VID_LVDSO_D7_PIOCFG_SLP_DI_SHIFT))

#define  VID_LVDSO_D7_PIOCFG_SLP_CNTRL_MASK 0x200
#define  VID_LVDSO_D7_PIOCFG_SLP_CNTRL_SHIFT 9
#define  VID_LVDSO_D7_PIOCFG_SLP_CNTRL_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D7_PIOCFG_SLP_CNTRL_MASK) >> VID_LVDSO_D7_PIOCFG_SLP_CNTRL_SHIFT)
#define  VID_LVDSO_D7_PIOCFG_SLP_CNTRL_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D7_PIOCFG_SLP_CNTRL_MASK) | (((uint32_t)val) << VID_LVDSO_D7_PIOCFG_SLP_CNTRL_SHIFT))

#define  VID_LVDSO_D7_PIOCFG_SLP_DO_MASK 0x100
#define  VID_LVDSO_D7_PIOCFG_SLP_DO_SHIFT 8
#define  VID_LVDSO_D7_PIOCFG_SLP_DO_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D7_PIOCFG_SLP_DO_MASK) >> VID_LVDSO_D7_PIOCFG_SLP_DO_SHIFT)
#define  VID_LVDSO_D7_PIOCFG_SLP_DO_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D7_PIOCFG_SLP_DO_MASK) | (((uint32_t)val) << VID_LVDSO_D7_PIOCFG_SLP_DO_SHIFT))

#define  VID_LVDSO_D7_PIOCFG_SLP_DIR_MASK 0x80
#define  VID_LVDSO_D7_PIOCFG_SLP_DIR_SHIFT 7
#define  VID_LVDSO_D7_PIOCFG_SLP_DIR_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D7_PIOCFG_SLP_DIR_MASK) >> VID_LVDSO_D7_PIOCFG_SLP_DIR_SHIFT)
#define  VID_LVDSO_D7_PIOCFG_SLP_DIR_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D7_PIOCFG_SLP_DIR_MASK) | (((uint32_t)val) << VID_LVDSO_D7_PIOCFG_SLP_DIR_SHIFT))

#define  VID_LVDSO_D7_PIOCFG_EDGE_EN_N_MASK 0x40
#define  VID_LVDSO_D7_PIOCFG_EDGE_EN_N_SHIFT 6
#define  VID_LVDSO_D7_PIOCFG_EDGE_EN_N_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D7_PIOCFG_EDGE_EN_N_MASK) >> VID_LVDSO_D7_PIOCFG_EDGE_EN_N_SHIFT)
#define  VID_LVDSO_D7_PIOCFG_EDGE_EN_N_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D7_PIOCFG_EDGE_EN_N_MASK) | (((uint32_t)val) << VID_LVDSO_D7_PIOCFG_EDGE_EN_N_SHIFT))

#define  VID_LVDSO_D7_PIOCFG_EDGE_FALL_EN_MASK 0x20
#define  VID_LVDSO_D7_PIOCFG_EDGE_FALL_EN_SHIFT 5
#define  VID_LVDSO_D7_PIOCFG_EDGE_FALL_EN_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D7_PIOCFG_EDGE_FALL_EN_MASK) >> VID_LVDSO_D7_PIOCFG_EDGE_FALL_EN_SHIFT)
#define  VID_LVDSO_D7_PIOCFG_EDGE_FALL_EN_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D7_PIOCFG_EDGE_FALL_EN_MASK) | (((uint32_t)val) << VID_LVDSO_D7_PIOCFG_EDGE_FALL_EN_SHIFT))

#define  VID_LVDSO_D7_PIOCFG_EDGE_RISE_EN_MASK 0x10
#define  VID_LVDSO_D7_PIOCFG_EDGE_RISE_EN_SHIFT 4
#define  VID_LVDSO_D7_PIOCFG_EDGE_RISE_EN_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D7_PIOCFG_EDGE_RISE_EN_MASK) >> VID_LVDSO_D7_PIOCFG_EDGE_RISE_EN_SHIFT)
#define  VID_LVDSO_D7_PIOCFG_EDGE_RISE_EN_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D7_PIOCFG_EDGE_RISE_EN_MASK) | (((uint32_t)val) << VID_LVDSO_D7_PIOCFG_EDGE_RISE_EN_SHIFT))

#define  VID_LVDSO_D7_PIOCFG_SLP_SEL_MASK 0x8
#define  VID_LVDSO_D7_PIOCFG_SLP_SEL_SHIFT 3
#define  VID_LVDSO_D7_PIOCFG_SLP_SEL_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D7_PIOCFG_SLP_SEL_MASK) >> VID_LVDSO_D7_PIOCFG_SLP_SEL_SHIFT)
#define  VID_LVDSO_D7_PIOCFG_SLP_SEL_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D7_PIOCFG_SLP_SEL_MASK) | (((uint32_t)val) << VID_LVDSO_D7_PIOCFG_SLP_SEL_SHIFT))

#define  VID_LVDSO_D7_PIOCFG_FUNC_SEL_MASK 0x7
#define  VID_LVDSO_D7_PIOCFG_FUNC_SEL_SHIFT 0
#define  VID_LVDSO_D7_PIOCFG_FUNC_SEL_MASK_SHIFT(reg) (((reg) & VID_LVDSO_D7_PIOCFG_FUNC_SEL_MASK) >> VID_LVDSO_D7_PIOCFG_FUNC_SEL_SHIFT)
#define  VID_LVDSO_D7_PIOCFG_FUNC_SEL_REPLACE_VAL(reg,val) (((reg) & ~VID_LVDSO_D7_PIOCFG_FUNC_SEL_MASK) | (((uint32_t)val) << VID_LVDSO_D7_PIOCFG_FUNC_SEL_SHIFT))

//====================================================================
//
//Register File: IO_PAD110 Configuration Registers (IO_PAD110)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

//====================================================================
//Register: IO_PAD110 Configuration Register (PIOCFG)
/** \brief "PHI_PADXDC_HSIOB" Pad*/
//====================================================================

#define  IO_PAD110_PIOCFG_RESERVED1_MASK 0xfc000000
#define  IO_PAD110_PIOCFG_RESERVED1_SHIFT 26
#define  IO_PAD110_PIOCFG_RESERVED1_MASK_SHIFT(reg) (((reg) & IO_PAD110_PIOCFG_RESERVED1_MASK) >> IO_PAD110_PIOCFG_RESERVED1_SHIFT)
#define  IO_PAD110_PIOCFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD110_PIOCFG_RESERVED1_MASK) | (((uint32_t)val) << IO_PAD110_PIOCFG_RESERVED1_SHIFT))

#define  IO_PAD110_PIOCFG_PD_MASK 0x2000000
#define  IO_PAD110_PIOCFG_PD_SHIFT 25
#define  IO_PAD110_PIOCFG_PD_MASK_SHIFT(reg) (((reg) & IO_PAD110_PIOCFG_PD_MASK) >> IO_PAD110_PIOCFG_PD_SHIFT)
#define  IO_PAD110_PIOCFG_PD_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD110_PIOCFG_PD_MASK) | (((uint32_t)val) << IO_PAD110_PIOCFG_PD_SHIFT))

#define  IO_PAD110_PIOCFG_ODT_EN_MASK 0x1000000
#define  IO_PAD110_PIOCFG_ODT_EN_SHIFT 24
#define  IO_PAD110_PIOCFG_ODT_EN_MASK_SHIFT(reg) (((reg) & IO_PAD110_PIOCFG_ODT_EN_MASK) >> IO_PAD110_PIOCFG_ODT_EN_SHIFT)
#define  IO_PAD110_PIOCFG_ODT_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD110_PIOCFG_ODT_EN_MASK) | (((uint32_t)val) << IO_PAD110_PIOCFG_ODT_EN_SHIFT))

#define  IO_PAD110_PIOCFG_LED_EN_MASK 0x800000
#define  IO_PAD110_PIOCFG_LED_EN_SHIFT 23
#define  IO_PAD110_PIOCFG_LED_EN_MASK_SHIFT(reg) (((reg) & IO_PAD110_PIOCFG_LED_EN_MASK) >> IO_PAD110_PIOCFG_LED_EN_SHIFT)
#define  IO_PAD110_PIOCFG_LED_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD110_PIOCFG_LED_EN_MASK) | (((uint32_t)val) << IO_PAD110_PIOCFG_LED_EN_SHIFT))

#define  IO_PAD110_PIOCFG_I2C_SEL_MASK 0x600000
#define  IO_PAD110_PIOCFG_I2C_SEL_SHIFT 21
#define  IO_PAD110_PIOCFG_I2C_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD110_PIOCFG_I2C_SEL_MASK) >> IO_PAD110_PIOCFG_I2C_SEL_SHIFT)
#define  IO_PAD110_PIOCFG_I2C_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD110_PIOCFG_I2C_SEL_MASK) | (((uint32_t)val) << IO_PAD110_PIOCFG_I2C_SEL_SHIFT))

#define  IO_PAD110_PIOCFG_DGTBSEL_MASK 0x1e0000
#define  IO_PAD110_PIOCFG_DGTBSEL_SHIFT 17
#define  IO_PAD110_PIOCFG_DGTBSEL_MASK_SHIFT(reg) (((reg) & IO_PAD110_PIOCFG_DGTBSEL_MASK) >> IO_PAD110_PIOCFG_DGTBSEL_SHIFT)
#define  IO_PAD110_PIOCFG_DGTBSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD110_PIOCFG_DGTBSEL_MASK) | (((uint32_t)val) << IO_PAD110_PIOCFG_DGTBSEL_SHIFT))

#define  IO_PAD110_PIOCFG_RAWSEL_MASK 0x10000
#define  IO_PAD110_PIOCFG_RAWSEL_SHIFT 16
#define  IO_PAD110_PIOCFG_RAWSEL_MASK_SHIFT(reg) (((reg) & IO_PAD110_PIOCFG_RAWSEL_MASK) >> IO_PAD110_PIOCFG_RAWSEL_SHIFT)
#define  IO_PAD110_PIOCFG_RAWSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD110_PIOCFG_RAWSEL_MASK) | (((uint32_t)val) << IO_PAD110_PIOCFG_RAWSEL_SHIFT))

#define  IO_PAD110_PIOCFG_PULL_SEL_MASK 0x8000
#define  IO_PAD110_PIOCFG_PULL_SEL_SHIFT 15
#define  IO_PAD110_PIOCFG_PULL_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD110_PIOCFG_PULL_SEL_MASK) >> IO_PAD110_PIOCFG_PULL_SEL_SHIFT)
#define  IO_PAD110_PIOCFG_PULL_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD110_PIOCFG_PULL_SEL_MASK) | (((uint32_t)val) << IO_PAD110_PIOCFG_PULL_SEL_SHIFT))

#define  IO_PAD110_PIOCFG_PUEN_MASK 0x4000
#define  IO_PAD110_PIOCFG_PUEN_SHIFT 14
#define  IO_PAD110_PIOCFG_PUEN_MASK_SHIFT(reg) (((reg) & IO_PAD110_PIOCFG_PUEN_MASK) >> IO_PAD110_PIOCFG_PUEN_SHIFT)
#define  IO_PAD110_PIOCFG_PUEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD110_PIOCFG_PUEN_MASK) | (((uint32_t)val) << IO_PAD110_PIOCFG_PUEN_SHIFT))

#define  IO_PAD110_PIOCFG_PDEN_MASK 0x2000
#define  IO_PAD110_PIOCFG_PDEN_SHIFT 13
#define  IO_PAD110_PIOCFG_PDEN_MASK_SHIFT(reg) (((reg) & IO_PAD110_PIOCFG_PDEN_MASK) >> IO_PAD110_PIOCFG_PDEN_SHIFT)
#define  IO_PAD110_PIOCFG_PDEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD110_PIOCFG_PDEN_MASK) | (((uint32_t)val) << IO_PAD110_PIOCFG_PDEN_SHIFT))

#define  IO_PAD110_PIOCFG_SR_MASK 0x1800
#define  IO_PAD110_PIOCFG_SR_SHIFT 11
#define  IO_PAD110_PIOCFG_SR_MASK_SHIFT(reg) (((reg) & IO_PAD110_PIOCFG_SR_MASK) >> IO_PAD110_PIOCFG_SR_SHIFT)
#define  IO_PAD110_PIOCFG_SR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD110_PIOCFG_SR_MASK) | (((uint32_t)val) << IO_PAD110_PIOCFG_SR_SHIFT))

#define  IO_PAD110_PIOCFG_SLP_DI_MASK 0x400
#define  IO_PAD110_PIOCFG_SLP_DI_SHIFT 10
#define  IO_PAD110_PIOCFG_SLP_DI_MASK_SHIFT(reg) (((reg) & IO_PAD110_PIOCFG_SLP_DI_MASK) >> IO_PAD110_PIOCFG_SLP_DI_SHIFT)
#define  IO_PAD110_PIOCFG_SLP_DI_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD110_PIOCFG_SLP_DI_MASK) | (((uint32_t)val) << IO_PAD110_PIOCFG_SLP_DI_SHIFT))

#define  IO_PAD110_PIOCFG_SLP_CNTRL_MASK 0x200
#define  IO_PAD110_PIOCFG_SLP_CNTRL_SHIFT 9
#define  IO_PAD110_PIOCFG_SLP_CNTRL_MASK_SHIFT(reg) (((reg) & IO_PAD110_PIOCFG_SLP_CNTRL_MASK) >> IO_PAD110_PIOCFG_SLP_CNTRL_SHIFT)
#define  IO_PAD110_PIOCFG_SLP_CNTRL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD110_PIOCFG_SLP_CNTRL_MASK) | (((uint32_t)val) << IO_PAD110_PIOCFG_SLP_CNTRL_SHIFT))

#define  IO_PAD110_PIOCFG_SLP_DO_MASK 0x100
#define  IO_PAD110_PIOCFG_SLP_DO_SHIFT 8
#define  IO_PAD110_PIOCFG_SLP_DO_MASK_SHIFT(reg) (((reg) & IO_PAD110_PIOCFG_SLP_DO_MASK) >> IO_PAD110_PIOCFG_SLP_DO_SHIFT)
#define  IO_PAD110_PIOCFG_SLP_DO_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD110_PIOCFG_SLP_DO_MASK) | (((uint32_t)val) << IO_PAD110_PIOCFG_SLP_DO_SHIFT))

#define  IO_PAD110_PIOCFG_SLP_DIR_MASK 0x80
#define  IO_PAD110_PIOCFG_SLP_DIR_SHIFT 7
#define  IO_PAD110_PIOCFG_SLP_DIR_MASK_SHIFT(reg) (((reg) & IO_PAD110_PIOCFG_SLP_DIR_MASK) >> IO_PAD110_PIOCFG_SLP_DIR_SHIFT)
#define  IO_PAD110_PIOCFG_SLP_DIR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD110_PIOCFG_SLP_DIR_MASK) | (((uint32_t)val) << IO_PAD110_PIOCFG_SLP_DIR_SHIFT))

#define  IO_PAD110_PIOCFG_EDGE_EN_N_MASK 0x40
#define  IO_PAD110_PIOCFG_EDGE_EN_N_SHIFT 6
#define  IO_PAD110_PIOCFG_EDGE_EN_N_MASK_SHIFT(reg) (((reg) & IO_PAD110_PIOCFG_EDGE_EN_N_MASK) >> IO_PAD110_PIOCFG_EDGE_EN_N_SHIFT)
#define  IO_PAD110_PIOCFG_EDGE_EN_N_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD110_PIOCFG_EDGE_EN_N_MASK) | (((uint32_t)val) << IO_PAD110_PIOCFG_EDGE_EN_N_SHIFT))

#define  IO_PAD110_PIOCFG_EDGE_FALL_EN_MASK 0x20
#define  IO_PAD110_PIOCFG_EDGE_FALL_EN_SHIFT 5
#define  IO_PAD110_PIOCFG_EDGE_FALL_EN_MASK_SHIFT(reg) (((reg) & IO_PAD110_PIOCFG_EDGE_FALL_EN_MASK) >> IO_PAD110_PIOCFG_EDGE_FALL_EN_SHIFT)
#define  IO_PAD110_PIOCFG_EDGE_FALL_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD110_PIOCFG_EDGE_FALL_EN_MASK) | (((uint32_t)val) << IO_PAD110_PIOCFG_EDGE_FALL_EN_SHIFT))

#define  IO_PAD110_PIOCFG_EDGE_RISE_EN_MASK 0x10
#define  IO_PAD110_PIOCFG_EDGE_RISE_EN_SHIFT 4
#define  IO_PAD110_PIOCFG_EDGE_RISE_EN_MASK_SHIFT(reg) (((reg) & IO_PAD110_PIOCFG_EDGE_RISE_EN_MASK) >> IO_PAD110_PIOCFG_EDGE_RISE_EN_SHIFT)
#define  IO_PAD110_PIOCFG_EDGE_RISE_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD110_PIOCFG_EDGE_RISE_EN_MASK) | (((uint32_t)val) << IO_PAD110_PIOCFG_EDGE_RISE_EN_SHIFT))

#define  IO_PAD110_PIOCFG_SLP_SEL_MASK 0x8
#define  IO_PAD110_PIOCFG_SLP_SEL_SHIFT 3
#define  IO_PAD110_PIOCFG_SLP_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD110_PIOCFG_SLP_SEL_MASK) >> IO_PAD110_PIOCFG_SLP_SEL_SHIFT)
#define  IO_PAD110_PIOCFG_SLP_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD110_PIOCFG_SLP_SEL_MASK) | (((uint32_t)val) << IO_PAD110_PIOCFG_SLP_SEL_SHIFT))

#define  IO_PAD110_PIOCFG_FUNC_SEL_MASK 0x7
#define  IO_PAD110_PIOCFG_FUNC_SEL_SHIFT 0
#define  IO_PAD110_PIOCFG_FUNC_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD110_PIOCFG_FUNC_SEL_MASK) >> IO_PAD110_PIOCFG_FUNC_SEL_SHIFT)
#define  IO_PAD110_PIOCFG_FUNC_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD110_PIOCFG_FUNC_SEL_MASK) | (((uint32_t)val) << IO_PAD110_PIOCFG_FUNC_SEL_SHIFT))

//====================================================================
//
//Register File: IO_PAD111 Configuration Registers (IO_PAD111)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

//====================================================================
//Register: IO_PAD111 Configuration Register (PIOCFG)
/** \brief "PHI_PADXDC_HSIOB" Pad*/
//====================================================================

#define  IO_PAD111_PIOCFG_RESERVED1_MASK 0xfc000000
#define  IO_PAD111_PIOCFG_RESERVED1_SHIFT 26
#define  IO_PAD111_PIOCFG_RESERVED1_MASK_SHIFT(reg) (((reg) & IO_PAD111_PIOCFG_RESERVED1_MASK) >> IO_PAD111_PIOCFG_RESERVED1_SHIFT)
#define  IO_PAD111_PIOCFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD111_PIOCFG_RESERVED1_MASK) | (((uint32_t)val) << IO_PAD111_PIOCFG_RESERVED1_SHIFT))

#define  IO_PAD111_PIOCFG_PD_MASK 0x2000000
#define  IO_PAD111_PIOCFG_PD_SHIFT 25
#define  IO_PAD111_PIOCFG_PD_MASK_SHIFT(reg) (((reg) & IO_PAD111_PIOCFG_PD_MASK) >> IO_PAD111_PIOCFG_PD_SHIFT)
#define  IO_PAD111_PIOCFG_PD_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD111_PIOCFG_PD_MASK) | (((uint32_t)val) << IO_PAD111_PIOCFG_PD_SHIFT))

#define  IO_PAD111_PIOCFG_ODT_EN_MASK 0x1000000
#define  IO_PAD111_PIOCFG_ODT_EN_SHIFT 24
#define  IO_PAD111_PIOCFG_ODT_EN_MASK_SHIFT(reg) (((reg) & IO_PAD111_PIOCFG_ODT_EN_MASK) >> IO_PAD111_PIOCFG_ODT_EN_SHIFT)
#define  IO_PAD111_PIOCFG_ODT_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD111_PIOCFG_ODT_EN_MASK) | (((uint32_t)val) << IO_PAD111_PIOCFG_ODT_EN_SHIFT))

#define  IO_PAD111_PIOCFG_LED_EN_MASK 0x800000
#define  IO_PAD111_PIOCFG_LED_EN_SHIFT 23
#define  IO_PAD111_PIOCFG_LED_EN_MASK_SHIFT(reg) (((reg) & IO_PAD111_PIOCFG_LED_EN_MASK) >> IO_PAD111_PIOCFG_LED_EN_SHIFT)
#define  IO_PAD111_PIOCFG_LED_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD111_PIOCFG_LED_EN_MASK) | (((uint32_t)val) << IO_PAD111_PIOCFG_LED_EN_SHIFT))

#define  IO_PAD111_PIOCFG_I2C_SEL_MASK 0x600000
#define  IO_PAD111_PIOCFG_I2C_SEL_SHIFT 21
#define  IO_PAD111_PIOCFG_I2C_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD111_PIOCFG_I2C_SEL_MASK) >> IO_PAD111_PIOCFG_I2C_SEL_SHIFT)
#define  IO_PAD111_PIOCFG_I2C_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD111_PIOCFG_I2C_SEL_MASK) | (((uint32_t)val) << IO_PAD111_PIOCFG_I2C_SEL_SHIFT))

#define  IO_PAD111_PIOCFG_DGTBSEL_MASK 0x1e0000
#define  IO_PAD111_PIOCFG_DGTBSEL_SHIFT 17
#define  IO_PAD111_PIOCFG_DGTBSEL_MASK_SHIFT(reg) (((reg) & IO_PAD111_PIOCFG_DGTBSEL_MASK) >> IO_PAD111_PIOCFG_DGTBSEL_SHIFT)
#define  IO_PAD111_PIOCFG_DGTBSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD111_PIOCFG_DGTBSEL_MASK) | (((uint32_t)val) << IO_PAD111_PIOCFG_DGTBSEL_SHIFT))

#define  IO_PAD111_PIOCFG_RAWSEL_MASK 0x10000
#define  IO_PAD111_PIOCFG_RAWSEL_SHIFT 16
#define  IO_PAD111_PIOCFG_RAWSEL_MASK_SHIFT(reg) (((reg) & IO_PAD111_PIOCFG_RAWSEL_MASK) >> IO_PAD111_PIOCFG_RAWSEL_SHIFT)
#define  IO_PAD111_PIOCFG_RAWSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD111_PIOCFG_RAWSEL_MASK) | (((uint32_t)val) << IO_PAD111_PIOCFG_RAWSEL_SHIFT))

#define  IO_PAD111_PIOCFG_PULL_SEL_MASK 0x8000
#define  IO_PAD111_PIOCFG_PULL_SEL_SHIFT 15
#define  IO_PAD111_PIOCFG_PULL_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD111_PIOCFG_PULL_SEL_MASK) >> IO_PAD111_PIOCFG_PULL_SEL_SHIFT)
#define  IO_PAD111_PIOCFG_PULL_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD111_PIOCFG_PULL_SEL_MASK) | (((uint32_t)val) << IO_PAD111_PIOCFG_PULL_SEL_SHIFT))

#define  IO_PAD111_PIOCFG_PUEN_MASK 0x4000
#define  IO_PAD111_PIOCFG_PUEN_SHIFT 14
#define  IO_PAD111_PIOCFG_PUEN_MASK_SHIFT(reg) (((reg) & IO_PAD111_PIOCFG_PUEN_MASK) >> IO_PAD111_PIOCFG_PUEN_SHIFT)
#define  IO_PAD111_PIOCFG_PUEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD111_PIOCFG_PUEN_MASK) | (((uint32_t)val) << IO_PAD111_PIOCFG_PUEN_SHIFT))

#define  IO_PAD111_PIOCFG_PDEN_MASK 0x2000
#define  IO_PAD111_PIOCFG_PDEN_SHIFT 13
#define  IO_PAD111_PIOCFG_PDEN_MASK_SHIFT(reg) (((reg) & IO_PAD111_PIOCFG_PDEN_MASK) >> IO_PAD111_PIOCFG_PDEN_SHIFT)
#define  IO_PAD111_PIOCFG_PDEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD111_PIOCFG_PDEN_MASK) | (((uint32_t)val) << IO_PAD111_PIOCFG_PDEN_SHIFT))

#define  IO_PAD111_PIOCFG_SR_MASK 0x1800
#define  IO_PAD111_PIOCFG_SR_SHIFT 11
#define  IO_PAD111_PIOCFG_SR_MASK_SHIFT(reg) (((reg) & IO_PAD111_PIOCFG_SR_MASK) >> IO_PAD111_PIOCFG_SR_SHIFT)
#define  IO_PAD111_PIOCFG_SR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD111_PIOCFG_SR_MASK) | (((uint32_t)val) << IO_PAD111_PIOCFG_SR_SHIFT))

#define  IO_PAD111_PIOCFG_SLP_DI_MASK 0x400
#define  IO_PAD111_PIOCFG_SLP_DI_SHIFT 10
#define  IO_PAD111_PIOCFG_SLP_DI_MASK_SHIFT(reg) (((reg) & IO_PAD111_PIOCFG_SLP_DI_MASK) >> IO_PAD111_PIOCFG_SLP_DI_SHIFT)
#define  IO_PAD111_PIOCFG_SLP_DI_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD111_PIOCFG_SLP_DI_MASK) | (((uint32_t)val) << IO_PAD111_PIOCFG_SLP_DI_SHIFT))

#define  IO_PAD111_PIOCFG_SLP_CNTRL_MASK 0x200
#define  IO_PAD111_PIOCFG_SLP_CNTRL_SHIFT 9
#define  IO_PAD111_PIOCFG_SLP_CNTRL_MASK_SHIFT(reg) (((reg) & IO_PAD111_PIOCFG_SLP_CNTRL_MASK) >> IO_PAD111_PIOCFG_SLP_CNTRL_SHIFT)
#define  IO_PAD111_PIOCFG_SLP_CNTRL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD111_PIOCFG_SLP_CNTRL_MASK) | (((uint32_t)val) << IO_PAD111_PIOCFG_SLP_CNTRL_SHIFT))

#define  IO_PAD111_PIOCFG_SLP_DO_MASK 0x100
#define  IO_PAD111_PIOCFG_SLP_DO_SHIFT 8
#define  IO_PAD111_PIOCFG_SLP_DO_MASK_SHIFT(reg) (((reg) & IO_PAD111_PIOCFG_SLP_DO_MASK) >> IO_PAD111_PIOCFG_SLP_DO_SHIFT)
#define  IO_PAD111_PIOCFG_SLP_DO_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD111_PIOCFG_SLP_DO_MASK) | (((uint32_t)val) << IO_PAD111_PIOCFG_SLP_DO_SHIFT))

#define  IO_PAD111_PIOCFG_SLP_DIR_MASK 0x80
#define  IO_PAD111_PIOCFG_SLP_DIR_SHIFT 7
#define  IO_PAD111_PIOCFG_SLP_DIR_MASK_SHIFT(reg) (((reg) & IO_PAD111_PIOCFG_SLP_DIR_MASK) >> IO_PAD111_PIOCFG_SLP_DIR_SHIFT)
#define  IO_PAD111_PIOCFG_SLP_DIR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD111_PIOCFG_SLP_DIR_MASK) | (((uint32_t)val) << IO_PAD111_PIOCFG_SLP_DIR_SHIFT))

#define  IO_PAD111_PIOCFG_EDGE_EN_N_MASK 0x40
#define  IO_PAD111_PIOCFG_EDGE_EN_N_SHIFT 6
#define  IO_PAD111_PIOCFG_EDGE_EN_N_MASK_SHIFT(reg) (((reg) & IO_PAD111_PIOCFG_EDGE_EN_N_MASK) >> IO_PAD111_PIOCFG_EDGE_EN_N_SHIFT)
#define  IO_PAD111_PIOCFG_EDGE_EN_N_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD111_PIOCFG_EDGE_EN_N_MASK) | (((uint32_t)val) << IO_PAD111_PIOCFG_EDGE_EN_N_SHIFT))

#define  IO_PAD111_PIOCFG_EDGE_FALL_EN_MASK 0x20
#define  IO_PAD111_PIOCFG_EDGE_FALL_EN_SHIFT 5
#define  IO_PAD111_PIOCFG_EDGE_FALL_EN_MASK_SHIFT(reg) (((reg) & IO_PAD111_PIOCFG_EDGE_FALL_EN_MASK) >> IO_PAD111_PIOCFG_EDGE_FALL_EN_SHIFT)
#define  IO_PAD111_PIOCFG_EDGE_FALL_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD111_PIOCFG_EDGE_FALL_EN_MASK) | (((uint32_t)val) << IO_PAD111_PIOCFG_EDGE_FALL_EN_SHIFT))

#define  IO_PAD111_PIOCFG_EDGE_RISE_EN_MASK 0x10
#define  IO_PAD111_PIOCFG_EDGE_RISE_EN_SHIFT 4
#define  IO_PAD111_PIOCFG_EDGE_RISE_EN_MASK_SHIFT(reg) (((reg) & IO_PAD111_PIOCFG_EDGE_RISE_EN_MASK) >> IO_PAD111_PIOCFG_EDGE_RISE_EN_SHIFT)
#define  IO_PAD111_PIOCFG_EDGE_RISE_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD111_PIOCFG_EDGE_RISE_EN_MASK) | (((uint32_t)val) << IO_PAD111_PIOCFG_EDGE_RISE_EN_SHIFT))

#define  IO_PAD111_PIOCFG_SLP_SEL_MASK 0x8
#define  IO_PAD111_PIOCFG_SLP_SEL_SHIFT 3
#define  IO_PAD111_PIOCFG_SLP_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD111_PIOCFG_SLP_SEL_MASK) >> IO_PAD111_PIOCFG_SLP_SEL_SHIFT)
#define  IO_PAD111_PIOCFG_SLP_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD111_PIOCFG_SLP_SEL_MASK) | (((uint32_t)val) << IO_PAD111_PIOCFG_SLP_SEL_SHIFT))

#define  IO_PAD111_PIOCFG_FUNC_SEL_MASK 0x7
#define  IO_PAD111_PIOCFG_FUNC_SEL_SHIFT 0
#define  IO_PAD111_PIOCFG_FUNC_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD111_PIOCFG_FUNC_SEL_MASK) >> IO_PAD111_PIOCFG_FUNC_SEL_SHIFT)
#define  IO_PAD111_PIOCFG_FUNC_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD111_PIOCFG_FUNC_SEL_MASK) | (((uint32_t)val) << IO_PAD111_PIOCFG_FUNC_SEL_SHIFT))

//====================================================================
//
//Register File: IO_PAD112 Configuration Registers (IO_PAD112)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

//====================================================================
//Register: IO_PAD112 Configuration Register (PIOCFG)
/** \brief "PHI_PADXDC_HSIOB" Pad*/
//====================================================================

#define  IO_PAD112_PIOCFG_RESERVED1_MASK 0xfc000000
#define  IO_PAD112_PIOCFG_RESERVED1_SHIFT 26
#define  IO_PAD112_PIOCFG_RESERVED1_MASK_SHIFT(reg) (((reg) & IO_PAD112_PIOCFG_RESERVED1_MASK) >> IO_PAD112_PIOCFG_RESERVED1_SHIFT)
#define  IO_PAD112_PIOCFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD112_PIOCFG_RESERVED1_MASK) | (((uint32_t)val) << IO_PAD112_PIOCFG_RESERVED1_SHIFT))

#define  IO_PAD112_PIOCFG_PD_MASK 0x2000000
#define  IO_PAD112_PIOCFG_PD_SHIFT 25
#define  IO_PAD112_PIOCFG_PD_MASK_SHIFT(reg) (((reg) & IO_PAD112_PIOCFG_PD_MASK) >> IO_PAD112_PIOCFG_PD_SHIFT)
#define  IO_PAD112_PIOCFG_PD_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD112_PIOCFG_PD_MASK) | (((uint32_t)val) << IO_PAD112_PIOCFG_PD_SHIFT))

#define  IO_PAD112_PIOCFG_ODT_EN_MASK 0x1000000
#define  IO_PAD112_PIOCFG_ODT_EN_SHIFT 24
#define  IO_PAD112_PIOCFG_ODT_EN_MASK_SHIFT(reg) (((reg) & IO_PAD112_PIOCFG_ODT_EN_MASK) >> IO_PAD112_PIOCFG_ODT_EN_SHIFT)
#define  IO_PAD112_PIOCFG_ODT_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD112_PIOCFG_ODT_EN_MASK) | (((uint32_t)val) << IO_PAD112_PIOCFG_ODT_EN_SHIFT))

#define  IO_PAD112_PIOCFG_LED_EN_MASK 0x800000
#define  IO_PAD112_PIOCFG_LED_EN_SHIFT 23
#define  IO_PAD112_PIOCFG_LED_EN_MASK_SHIFT(reg) (((reg) & IO_PAD112_PIOCFG_LED_EN_MASK) >> IO_PAD112_PIOCFG_LED_EN_SHIFT)
#define  IO_PAD112_PIOCFG_LED_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD112_PIOCFG_LED_EN_MASK) | (((uint32_t)val) << IO_PAD112_PIOCFG_LED_EN_SHIFT))

#define  IO_PAD112_PIOCFG_I2C_SEL_MASK 0x600000
#define  IO_PAD112_PIOCFG_I2C_SEL_SHIFT 21
#define  IO_PAD112_PIOCFG_I2C_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD112_PIOCFG_I2C_SEL_MASK) >> IO_PAD112_PIOCFG_I2C_SEL_SHIFT)
#define  IO_PAD112_PIOCFG_I2C_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD112_PIOCFG_I2C_SEL_MASK) | (((uint32_t)val) << IO_PAD112_PIOCFG_I2C_SEL_SHIFT))

#define  IO_PAD112_PIOCFG_DGTBSEL_MASK 0x1e0000
#define  IO_PAD112_PIOCFG_DGTBSEL_SHIFT 17
#define  IO_PAD112_PIOCFG_DGTBSEL_MASK_SHIFT(reg) (((reg) & IO_PAD112_PIOCFG_DGTBSEL_MASK) >> IO_PAD112_PIOCFG_DGTBSEL_SHIFT)
#define  IO_PAD112_PIOCFG_DGTBSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD112_PIOCFG_DGTBSEL_MASK) | (((uint32_t)val) << IO_PAD112_PIOCFG_DGTBSEL_SHIFT))

#define  IO_PAD112_PIOCFG_RAWSEL_MASK 0x10000
#define  IO_PAD112_PIOCFG_RAWSEL_SHIFT 16
#define  IO_PAD112_PIOCFG_RAWSEL_MASK_SHIFT(reg) (((reg) & IO_PAD112_PIOCFG_RAWSEL_MASK) >> IO_PAD112_PIOCFG_RAWSEL_SHIFT)
#define  IO_PAD112_PIOCFG_RAWSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD112_PIOCFG_RAWSEL_MASK) | (((uint32_t)val) << IO_PAD112_PIOCFG_RAWSEL_SHIFT))

#define  IO_PAD112_PIOCFG_PULL_SEL_MASK 0x8000
#define  IO_PAD112_PIOCFG_PULL_SEL_SHIFT 15
#define  IO_PAD112_PIOCFG_PULL_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD112_PIOCFG_PULL_SEL_MASK) >> IO_PAD112_PIOCFG_PULL_SEL_SHIFT)
#define  IO_PAD112_PIOCFG_PULL_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD112_PIOCFG_PULL_SEL_MASK) | (((uint32_t)val) << IO_PAD112_PIOCFG_PULL_SEL_SHIFT))

#define  IO_PAD112_PIOCFG_PUEN_MASK 0x4000
#define  IO_PAD112_PIOCFG_PUEN_SHIFT 14
#define  IO_PAD112_PIOCFG_PUEN_MASK_SHIFT(reg) (((reg) & IO_PAD112_PIOCFG_PUEN_MASK) >> IO_PAD112_PIOCFG_PUEN_SHIFT)
#define  IO_PAD112_PIOCFG_PUEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD112_PIOCFG_PUEN_MASK) | (((uint32_t)val) << IO_PAD112_PIOCFG_PUEN_SHIFT))

#define  IO_PAD112_PIOCFG_PDEN_MASK 0x2000
#define  IO_PAD112_PIOCFG_PDEN_SHIFT 13
#define  IO_PAD112_PIOCFG_PDEN_MASK_SHIFT(reg) (((reg) & IO_PAD112_PIOCFG_PDEN_MASK) >> IO_PAD112_PIOCFG_PDEN_SHIFT)
#define  IO_PAD112_PIOCFG_PDEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD112_PIOCFG_PDEN_MASK) | (((uint32_t)val) << IO_PAD112_PIOCFG_PDEN_SHIFT))

#define  IO_PAD112_PIOCFG_SR_MASK 0x1800
#define  IO_PAD112_PIOCFG_SR_SHIFT 11
#define  IO_PAD112_PIOCFG_SR_MASK_SHIFT(reg) (((reg) & IO_PAD112_PIOCFG_SR_MASK) >> IO_PAD112_PIOCFG_SR_SHIFT)
#define  IO_PAD112_PIOCFG_SR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD112_PIOCFG_SR_MASK) | (((uint32_t)val) << IO_PAD112_PIOCFG_SR_SHIFT))

#define  IO_PAD112_PIOCFG_SLP_DI_MASK 0x400
#define  IO_PAD112_PIOCFG_SLP_DI_SHIFT 10
#define  IO_PAD112_PIOCFG_SLP_DI_MASK_SHIFT(reg) (((reg) & IO_PAD112_PIOCFG_SLP_DI_MASK) >> IO_PAD112_PIOCFG_SLP_DI_SHIFT)
#define  IO_PAD112_PIOCFG_SLP_DI_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD112_PIOCFG_SLP_DI_MASK) | (((uint32_t)val) << IO_PAD112_PIOCFG_SLP_DI_SHIFT))

#define  IO_PAD112_PIOCFG_SLP_CNTRL_MASK 0x200
#define  IO_PAD112_PIOCFG_SLP_CNTRL_SHIFT 9
#define  IO_PAD112_PIOCFG_SLP_CNTRL_MASK_SHIFT(reg) (((reg) & IO_PAD112_PIOCFG_SLP_CNTRL_MASK) >> IO_PAD112_PIOCFG_SLP_CNTRL_SHIFT)
#define  IO_PAD112_PIOCFG_SLP_CNTRL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD112_PIOCFG_SLP_CNTRL_MASK) | (((uint32_t)val) << IO_PAD112_PIOCFG_SLP_CNTRL_SHIFT))

#define  IO_PAD112_PIOCFG_SLP_DO_MASK 0x100
#define  IO_PAD112_PIOCFG_SLP_DO_SHIFT 8
#define  IO_PAD112_PIOCFG_SLP_DO_MASK_SHIFT(reg) (((reg) & IO_PAD112_PIOCFG_SLP_DO_MASK) >> IO_PAD112_PIOCFG_SLP_DO_SHIFT)
#define  IO_PAD112_PIOCFG_SLP_DO_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD112_PIOCFG_SLP_DO_MASK) | (((uint32_t)val) << IO_PAD112_PIOCFG_SLP_DO_SHIFT))

#define  IO_PAD112_PIOCFG_SLP_DIR_MASK 0x80
#define  IO_PAD112_PIOCFG_SLP_DIR_SHIFT 7
#define  IO_PAD112_PIOCFG_SLP_DIR_MASK_SHIFT(reg) (((reg) & IO_PAD112_PIOCFG_SLP_DIR_MASK) >> IO_PAD112_PIOCFG_SLP_DIR_SHIFT)
#define  IO_PAD112_PIOCFG_SLP_DIR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD112_PIOCFG_SLP_DIR_MASK) | (((uint32_t)val) << IO_PAD112_PIOCFG_SLP_DIR_SHIFT))

#define  IO_PAD112_PIOCFG_EDGE_EN_N_MASK 0x40
#define  IO_PAD112_PIOCFG_EDGE_EN_N_SHIFT 6
#define  IO_PAD112_PIOCFG_EDGE_EN_N_MASK_SHIFT(reg) (((reg) & IO_PAD112_PIOCFG_EDGE_EN_N_MASK) >> IO_PAD112_PIOCFG_EDGE_EN_N_SHIFT)
#define  IO_PAD112_PIOCFG_EDGE_EN_N_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD112_PIOCFG_EDGE_EN_N_MASK) | (((uint32_t)val) << IO_PAD112_PIOCFG_EDGE_EN_N_SHIFT))

#define  IO_PAD112_PIOCFG_EDGE_FALL_EN_MASK 0x20
#define  IO_PAD112_PIOCFG_EDGE_FALL_EN_SHIFT 5
#define  IO_PAD112_PIOCFG_EDGE_FALL_EN_MASK_SHIFT(reg) (((reg) & IO_PAD112_PIOCFG_EDGE_FALL_EN_MASK) >> IO_PAD112_PIOCFG_EDGE_FALL_EN_SHIFT)
#define  IO_PAD112_PIOCFG_EDGE_FALL_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD112_PIOCFG_EDGE_FALL_EN_MASK) | (((uint32_t)val) << IO_PAD112_PIOCFG_EDGE_FALL_EN_SHIFT))

#define  IO_PAD112_PIOCFG_EDGE_RISE_EN_MASK 0x10
#define  IO_PAD112_PIOCFG_EDGE_RISE_EN_SHIFT 4
#define  IO_PAD112_PIOCFG_EDGE_RISE_EN_MASK_SHIFT(reg) (((reg) & IO_PAD112_PIOCFG_EDGE_RISE_EN_MASK) >> IO_PAD112_PIOCFG_EDGE_RISE_EN_SHIFT)
#define  IO_PAD112_PIOCFG_EDGE_RISE_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD112_PIOCFG_EDGE_RISE_EN_MASK) | (((uint32_t)val) << IO_PAD112_PIOCFG_EDGE_RISE_EN_SHIFT))

#define  IO_PAD112_PIOCFG_SLP_SEL_MASK 0x8
#define  IO_PAD112_PIOCFG_SLP_SEL_SHIFT 3
#define  IO_PAD112_PIOCFG_SLP_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD112_PIOCFG_SLP_SEL_MASK) >> IO_PAD112_PIOCFG_SLP_SEL_SHIFT)
#define  IO_PAD112_PIOCFG_SLP_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD112_PIOCFG_SLP_SEL_MASK) | (((uint32_t)val) << IO_PAD112_PIOCFG_SLP_SEL_SHIFT))

#define  IO_PAD112_PIOCFG_FUNC_SEL_MASK 0x7
#define  IO_PAD112_PIOCFG_FUNC_SEL_SHIFT 0
#define  IO_PAD112_PIOCFG_FUNC_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD112_PIOCFG_FUNC_SEL_MASK) >> IO_PAD112_PIOCFG_FUNC_SEL_SHIFT)
#define  IO_PAD112_PIOCFG_FUNC_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD112_PIOCFG_FUNC_SEL_MASK) | (((uint32_t)val) << IO_PAD112_PIOCFG_FUNC_SEL_SHIFT))

//====================================================================
//
//Register File: IO_PAD113 Configuration Registers (IO_PAD113)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

//====================================================================
//Register: IO_PAD113 Configuration Register (PIOCFG)
/** \brief "PHI_PADXDC_SDCLK_I2C_PU25K" Pad*/
//====================================================================

#define  IO_PAD113_PIOCFG_RESERVED1_MASK 0xfc000000
#define  IO_PAD113_PIOCFG_RESERVED1_SHIFT 26
#define  IO_PAD113_PIOCFG_RESERVED1_MASK_SHIFT(reg) (((reg) & IO_PAD113_PIOCFG_RESERVED1_MASK) >> IO_PAD113_PIOCFG_RESERVED1_SHIFT)
#define  IO_PAD113_PIOCFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD113_PIOCFG_RESERVED1_MASK) | (((uint32_t)val) << IO_PAD113_PIOCFG_RESERVED1_SHIFT))

#define  IO_PAD113_PIOCFG_PD_MASK 0x2000000
#define  IO_PAD113_PIOCFG_PD_SHIFT 25
#define  IO_PAD113_PIOCFG_PD_MASK_SHIFT(reg) (((reg) & IO_PAD113_PIOCFG_PD_MASK) >> IO_PAD113_PIOCFG_PD_SHIFT)
#define  IO_PAD113_PIOCFG_PD_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD113_PIOCFG_PD_MASK) | (((uint32_t)val) << IO_PAD113_PIOCFG_PD_SHIFT))

#define  IO_PAD113_PIOCFG_ODT_EN_MASK 0x1000000
#define  IO_PAD113_PIOCFG_ODT_EN_SHIFT 24
#define  IO_PAD113_PIOCFG_ODT_EN_MASK_SHIFT(reg) (((reg) & IO_PAD113_PIOCFG_ODT_EN_MASK) >> IO_PAD113_PIOCFG_ODT_EN_SHIFT)
#define  IO_PAD113_PIOCFG_ODT_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD113_PIOCFG_ODT_EN_MASK) | (((uint32_t)val) << IO_PAD113_PIOCFG_ODT_EN_SHIFT))

#define  IO_PAD113_PIOCFG_LED_EN_MASK 0x800000
#define  IO_PAD113_PIOCFG_LED_EN_SHIFT 23
#define  IO_PAD113_PIOCFG_LED_EN_MASK_SHIFT(reg) (((reg) & IO_PAD113_PIOCFG_LED_EN_MASK) >> IO_PAD113_PIOCFG_LED_EN_SHIFT)
#define  IO_PAD113_PIOCFG_LED_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD113_PIOCFG_LED_EN_MASK) | (((uint32_t)val) << IO_PAD113_PIOCFG_LED_EN_SHIFT))

#define  IO_PAD113_PIOCFG_I2C_SEL_MASK 0x600000
#define  IO_PAD113_PIOCFG_I2C_SEL_SHIFT 21
#define  IO_PAD113_PIOCFG_I2C_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD113_PIOCFG_I2C_SEL_MASK) >> IO_PAD113_PIOCFG_I2C_SEL_SHIFT)
#define  IO_PAD113_PIOCFG_I2C_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD113_PIOCFG_I2C_SEL_MASK) | (((uint32_t)val) << IO_PAD113_PIOCFG_I2C_SEL_SHIFT))

#define  IO_PAD113_PIOCFG_DGTBSEL_MASK 0x1e0000
#define  IO_PAD113_PIOCFG_DGTBSEL_SHIFT 17
#define  IO_PAD113_PIOCFG_DGTBSEL_MASK_SHIFT(reg) (((reg) & IO_PAD113_PIOCFG_DGTBSEL_MASK) >> IO_PAD113_PIOCFG_DGTBSEL_SHIFT)
#define  IO_PAD113_PIOCFG_DGTBSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD113_PIOCFG_DGTBSEL_MASK) | (((uint32_t)val) << IO_PAD113_PIOCFG_DGTBSEL_SHIFT))

#define  IO_PAD113_PIOCFG_RAWSEL_MASK 0x10000
#define  IO_PAD113_PIOCFG_RAWSEL_SHIFT 16
#define  IO_PAD113_PIOCFG_RAWSEL_MASK_SHIFT(reg) (((reg) & IO_PAD113_PIOCFG_RAWSEL_MASK) >> IO_PAD113_PIOCFG_RAWSEL_SHIFT)
#define  IO_PAD113_PIOCFG_RAWSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD113_PIOCFG_RAWSEL_MASK) | (((uint32_t)val) << IO_PAD113_PIOCFG_RAWSEL_SHIFT))

#define  IO_PAD113_PIOCFG_PULL_SEL_MASK 0x8000
#define  IO_PAD113_PIOCFG_PULL_SEL_SHIFT 15
#define  IO_PAD113_PIOCFG_PULL_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD113_PIOCFG_PULL_SEL_MASK) >> IO_PAD113_PIOCFG_PULL_SEL_SHIFT)
#define  IO_PAD113_PIOCFG_PULL_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD113_PIOCFG_PULL_SEL_MASK) | (((uint32_t)val) << IO_PAD113_PIOCFG_PULL_SEL_SHIFT))

#define  IO_PAD113_PIOCFG_PUEN_MASK 0x4000
#define  IO_PAD113_PIOCFG_PUEN_SHIFT 14
#define  IO_PAD113_PIOCFG_PUEN_MASK_SHIFT(reg) (((reg) & IO_PAD113_PIOCFG_PUEN_MASK) >> IO_PAD113_PIOCFG_PUEN_SHIFT)
#define  IO_PAD113_PIOCFG_PUEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD113_PIOCFG_PUEN_MASK) | (((uint32_t)val) << IO_PAD113_PIOCFG_PUEN_SHIFT))

#define  IO_PAD113_PIOCFG_PDEN_MASK 0x2000
#define  IO_PAD113_PIOCFG_PDEN_SHIFT 13
#define  IO_PAD113_PIOCFG_PDEN_MASK_SHIFT(reg) (((reg) & IO_PAD113_PIOCFG_PDEN_MASK) >> IO_PAD113_PIOCFG_PDEN_SHIFT)
#define  IO_PAD113_PIOCFG_PDEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD113_PIOCFG_PDEN_MASK) | (((uint32_t)val) << IO_PAD113_PIOCFG_PDEN_SHIFT))

#define  IO_PAD113_PIOCFG_SR_MASK 0x1800
#define  IO_PAD113_PIOCFG_SR_SHIFT 11
#define  IO_PAD113_PIOCFG_SR_MASK_SHIFT(reg) (((reg) & IO_PAD113_PIOCFG_SR_MASK) >> IO_PAD113_PIOCFG_SR_SHIFT)
#define  IO_PAD113_PIOCFG_SR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD113_PIOCFG_SR_MASK) | (((uint32_t)val) << IO_PAD113_PIOCFG_SR_SHIFT))

#define  IO_PAD113_PIOCFG_SLP_DI_MASK 0x400
#define  IO_PAD113_PIOCFG_SLP_DI_SHIFT 10
#define  IO_PAD113_PIOCFG_SLP_DI_MASK_SHIFT(reg) (((reg) & IO_PAD113_PIOCFG_SLP_DI_MASK) >> IO_PAD113_PIOCFG_SLP_DI_SHIFT)
#define  IO_PAD113_PIOCFG_SLP_DI_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD113_PIOCFG_SLP_DI_MASK) | (((uint32_t)val) << IO_PAD113_PIOCFG_SLP_DI_SHIFT))

#define  IO_PAD113_PIOCFG_SLP_CNTRL_MASK 0x200
#define  IO_PAD113_PIOCFG_SLP_CNTRL_SHIFT 9
#define  IO_PAD113_PIOCFG_SLP_CNTRL_MASK_SHIFT(reg) (((reg) & IO_PAD113_PIOCFG_SLP_CNTRL_MASK) >> IO_PAD113_PIOCFG_SLP_CNTRL_SHIFT)
#define  IO_PAD113_PIOCFG_SLP_CNTRL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD113_PIOCFG_SLP_CNTRL_MASK) | (((uint32_t)val) << IO_PAD113_PIOCFG_SLP_CNTRL_SHIFT))

#define  IO_PAD113_PIOCFG_SLP_DO_MASK 0x100
#define  IO_PAD113_PIOCFG_SLP_DO_SHIFT 8
#define  IO_PAD113_PIOCFG_SLP_DO_MASK_SHIFT(reg) (((reg) & IO_PAD113_PIOCFG_SLP_DO_MASK) >> IO_PAD113_PIOCFG_SLP_DO_SHIFT)
#define  IO_PAD113_PIOCFG_SLP_DO_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD113_PIOCFG_SLP_DO_MASK) | (((uint32_t)val) << IO_PAD113_PIOCFG_SLP_DO_SHIFT))

#define  IO_PAD113_PIOCFG_SLP_DIR_MASK 0x80
#define  IO_PAD113_PIOCFG_SLP_DIR_SHIFT 7
#define  IO_PAD113_PIOCFG_SLP_DIR_MASK_SHIFT(reg) (((reg) & IO_PAD113_PIOCFG_SLP_DIR_MASK) >> IO_PAD113_PIOCFG_SLP_DIR_SHIFT)
#define  IO_PAD113_PIOCFG_SLP_DIR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD113_PIOCFG_SLP_DIR_MASK) | (((uint32_t)val) << IO_PAD113_PIOCFG_SLP_DIR_SHIFT))

#define  IO_PAD113_PIOCFG_EDGE_EN_N_MASK 0x40
#define  IO_PAD113_PIOCFG_EDGE_EN_N_SHIFT 6
#define  IO_PAD113_PIOCFG_EDGE_EN_N_MASK_SHIFT(reg) (((reg) & IO_PAD113_PIOCFG_EDGE_EN_N_MASK) >> IO_PAD113_PIOCFG_EDGE_EN_N_SHIFT)
#define  IO_PAD113_PIOCFG_EDGE_EN_N_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD113_PIOCFG_EDGE_EN_N_MASK) | (((uint32_t)val) << IO_PAD113_PIOCFG_EDGE_EN_N_SHIFT))

#define  IO_PAD113_PIOCFG_EDGE_FALL_EN_MASK 0x20
#define  IO_PAD113_PIOCFG_EDGE_FALL_EN_SHIFT 5
#define  IO_PAD113_PIOCFG_EDGE_FALL_EN_MASK_SHIFT(reg) (((reg) & IO_PAD113_PIOCFG_EDGE_FALL_EN_MASK) >> IO_PAD113_PIOCFG_EDGE_FALL_EN_SHIFT)
#define  IO_PAD113_PIOCFG_EDGE_FALL_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD113_PIOCFG_EDGE_FALL_EN_MASK) | (((uint32_t)val) << IO_PAD113_PIOCFG_EDGE_FALL_EN_SHIFT))

#define  IO_PAD113_PIOCFG_EDGE_RISE_EN_MASK 0x10
#define  IO_PAD113_PIOCFG_EDGE_RISE_EN_SHIFT 4
#define  IO_PAD113_PIOCFG_EDGE_RISE_EN_MASK_SHIFT(reg) (((reg) & IO_PAD113_PIOCFG_EDGE_RISE_EN_MASK) >> IO_PAD113_PIOCFG_EDGE_RISE_EN_SHIFT)
#define  IO_PAD113_PIOCFG_EDGE_RISE_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD113_PIOCFG_EDGE_RISE_EN_MASK) | (((uint32_t)val) << IO_PAD113_PIOCFG_EDGE_RISE_EN_SHIFT))

#define  IO_PAD113_PIOCFG_SLP_SEL_MASK 0x8
#define  IO_PAD113_PIOCFG_SLP_SEL_SHIFT 3
#define  IO_PAD113_PIOCFG_SLP_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD113_PIOCFG_SLP_SEL_MASK) >> IO_PAD113_PIOCFG_SLP_SEL_SHIFT)
#define  IO_PAD113_PIOCFG_SLP_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD113_PIOCFG_SLP_SEL_MASK) | (((uint32_t)val) << IO_PAD113_PIOCFG_SLP_SEL_SHIFT))

#define  IO_PAD113_PIOCFG_FUNC_SEL_MASK 0x7
#define  IO_PAD113_PIOCFG_FUNC_SEL_SHIFT 0
#define  IO_PAD113_PIOCFG_FUNC_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD113_PIOCFG_FUNC_SEL_MASK) >> IO_PAD113_PIOCFG_FUNC_SEL_SHIFT)
#define  IO_PAD113_PIOCFG_FUNC_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD113_PIOCFG_FUNC_SEL_MASK) | (((uint32_t)val) << IO_PAD113_PIOCFG_FUNC_SEL_SHIFT))

//====================================================================
//
//Register File: IO_PAD114 Configuration Registers (IO_PAD114)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

//====================================================================
//Register: IO_PAD114 Configuration Register (PIOCFG)
/** \brief "PHI_PADXDC_HSIOB" Pad*/
//====================================================================

#define  IO_PAD114_PIOCFG_RESERVED1_MASK 0xfc000000
#define  IO_PAD114_PIOCFG_RESERVED1_SHIFT 26
#define  IO_PAD114_PIOCFG_RESERVED1_MASK_SHIFT(reg) (((reg) & IO_PAD114_PIOCFG_RESERVED1_MASK) >> IO_PAD114_PIOCFG_RESERVED1_SHIFT)
#define  IO_PAD114_PIOCFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD114_PIOCFG_RESERVED1_MASK) | (((uint32_t)val) << IO_PAD114_PIOCFG_RESERVED1_SHIFT))

#define  IO_PAD114_PIOCFG_PD_MASK 0x2000000
#define  IO_PAD114_PIOCFG_PD_SHIFT 25
#define  IO_PAD114_PIOCFG_PD_MASK_SHIFT(reg) (((reg) & IO_PAD114_PIOCFG_PD_MASK) >> IO_PAD114_PIOCFG_PD_SHIFT)
#define  IO_PAD114_PIOCFG_PD_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD114_PIOCFG_PD_MASK) | (((uint32_t)val) << IO_PAD114_PIOCFG_PD_SHIFT))

#define  IO_PAD114_PIOCFG_ODT_EN_MASK 0x1000000
#define  IO_PAD114_PIOCFG_ODT_EN_SHIFT 24
#define  IO_PAD114_PIOCFG_ODT_EN_MASK_SHIFT(reg) (((reg) & IO_PAD114_PIOCFG_ODT_EN_MASK) >> IO_PAD114_PIOCFG_ODT_EN_SHIFT)
#define  IO_PAD114_PIOCFG_ODT_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD114_PIOCFG_ODT_EN_MASK) | (((uint32_t)val) << IO_PAD114_PIOCFG_ODT_EN_SHIFT))

#define  IO_PAD114_PIOCFG_LED_EN_MASK 0x800000
#define  IO_PAD114_PIOCFG_LED_EN_SHIFT 23
#define  IO_PAD114_PIOCFG_LED_EN_MASK_SHIFT(reg) (((reg) & IO_PAD114_PIOCFG_LED_EN_MASK) >> IO_PAD114_PIOCFG_LED_EN_SHIFT)
#define  IO_PAD114_PIOCFG_LED_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD114_PIOCFG_LED_EN_MASK) | (((uint32_t)val) << IO_PAD114_PIOCFG_LED_EN_SHIFT))

#define  IO_PAD114_PIOCFG_I2C_SEL_MASK 0x600000
#define  IO_PAD114_PIOCFG_I2C_SEL_SHIFT 21
#define  IO_PAD114_PIOCFG_I2C_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD114_PIOCFG_I2C_SEL_MASK) >> IO_PAD114_PIOCFG_I2C_SEL_SHIFT)
#define  IO_PAD114_PIOCFG_I2C_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD114_PIOCFG_I2C_SEL_MASK) | (((uint32_t)val) << IO_PAD114_PIOCFG_I2C_SEL_SHIFT))

#define  IO_PAD114_PIOCFG_DGTBSEL_MASK 0x1e0000
#define  IO_PAD114_PIOCFG_DGTBSEL_SHIFT 17
#define  IO_PAD114_PIOCFG_DGTBSEL_MASK_SHIFT(reg) (((reg) & IO_PAD114_PIOCFG_DGTBSEL_MASK) >> IO_PAD114_PIOCFG_DGTBSEL_SHIFT)
#define  IO_PAD114_PIOCFG_DGTBSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD114_PIOCFG_DGTBSEL_MASK) | (((uint32_t)val) << IO_PAD114_PIOCFG_DGTBSEL_SHIFT))

#define  IO_PAD114_PIOCFG_RAWSEL_MASK 0x10000
#define  IO_PAD114_PIOCFG_RAWSEL_SHIFT 16
#define  IO_PAD114_PIOCFG_RAWSEL_MASK_SHIFT(reg) (((reg) & IO_PAD114_PIOCFG_RAWSEL_MASK) >> IO_PAD114_PIOCFG_RAWSEL_SHIFT)
#define  IO_PAD114_PIOCFG_RAWSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD114_PIOCFG_RAWSEL_MASK) | (((uint32_t)val) << IO_PAD114_PIOCFG_RAWSEL_SHIFT))

#define  IO_PAD114_PIOCFG_PULL_SEL_MASK 0x8000
#define  IO_PAD114_PIOCFG_PULL_SEL_SHIFT 15
#define  IO_PAD114_PIOCFG_PULL_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD114_PIOCFG_PULL_SEL_MASK) >> IO_PAD114_PIOCFG_PULL_SEL_SHIFT)
#define  IO_PAD114_PIOCFG_PULL_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD114_PIOCFG_PULL_SEL_MASK) | (((uint32_t)val) << IO_PAD114_PIOCFG_PULL_SEL_SHIFT))

#define  IO_PAD114_PIOCFG_PUEN_MASK 0x4000
#define  IO_PAD114_PIOCFG_PUEN_SHIFT 14
#define  IO_PAD114_PIOCFG_PUEN_MASK_SHIFT(reg) (((reg) & IO_PAD114_PIOCFG_PUEN_MASK) >> IO_PAD114_PIOCFG_PUEN_SHIFT)
#define  IO_PAD114_PIOCFG_PUEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD114_PIOCFG_PUEN_MASK) | (((uint32_t)val) << IO_PAD114_PIOCFG_PUEN_SHIFT))

#define  IO_PAD114_PIOCFG_PDEN_MASK 0x2000
#define  IO_PAD114_PIOCFG_PDEN_SHIFT 13
#define  IO_PAD114_PIOCFG_PDEN_MASK_SHIFT(reg) (((reg) & IO_PAD114_PIOCFG_PDEN_MASK) >> IO_PAD114_PIOCFG_PDEN_SHIFT)
#define  IO_PAD114_PIOCFG_PDEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD114_PIOCFG_PDEN_MASK) | (((uint32_t)val) << IO_PAD114_PIOCFG_PDEN_SHIFT))

#define  IO_PAD114_PIOCFG_SR_MASK 0x1800
#define  IO_PAD114_PIOCFG_SR_SHIFT 11
#define  IO_PAD114_PIOCFG_SR_MASK_SHIFT(reg) (((reg) & IO_PAD114_PIOCFG_SR_MASK) >> IO_PAD114_PIOCFG_SR_SHIFT)
#define  IO_PAD114_PIOCFG_SR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD114_PIOCFG_SR_MASK) | (((uint32_t)val) << IO_PAD114_PIOCFG_SR_SHIFT))

#define  IO_PAD114_PIOCFG_SLP_DI_MASK 0x400
#define  IO_PAD114_PIOCFG_SLP_DI_SHIFT 10
#define  IO_PAD114_PIOCFG_SLP_DI_MASK_SHIFT(reg) (((reg) & IO_PAD114_PIOCFG_SLP_DI_MASK) >> IO_PAD114_PIOCFG_SLP_DI_SHIFT)
#define  IO_PAD114_PIOCFG_SLP_DI_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD114_PIOCFG_SLP_DI_MASK) | (((uint32_t)val) << IO_PAD114_PIOCFG_SLP_DI_SHIFT))

#define  IO_PAD114_PIOCFG_SLP_CNTRL_MASK 0x200
#define  IO_PAD114_PIOCFG_SLP_CNTRL_SHIFT 9
#define  IO_PAD114_PIOCFG_SLP_CNTRL_MASK_SHIFT(reg) (((reg) & IO_PAD114_PIOCFG_SLP_CNTRL_MASK) >> IO_PAD114_PIOCFG_SLP_CNTRL_SHIFT)
#define  IO_PAD114_PIOCFG_SLP_CNTRL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD114_PIOCFG_SLP_CNTRL_MASK) | (((uint32_t)val) << IO_PAD114_PIOCFG_SLP_CNTRL_SHIFT))

#define  IO_PAD114_PIOCFG_SLP_DO_MASK 0x100
#define  IO_PAD114_PIOCFG_SLP_DO_SHIFT 8
#define  IO_PAD114_PIOCFG_SLP_DO_MASK_SHIFT(reg) (((reg) & IO_PAD114_PIOCFG_SLP_DO_MASK) >> IO_PAD114_PIOCFG_SLP_DO_SHIFT)
#define  IO_PAD114_PIOCFG_SLP_DO_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD114_PIOCFG_SLP_DO_MASK) | (((uint32_t)val) << IO_PAD114_PIOCFG_SLP_DO_SHIFT))

#define  IO_PAD114_PIOCFG_SLP_DIR_MASK 0x80
#define  IO_PAD114_PIOCFG_SLP_DIR_SHIFT 7
#define  IO_PAD114_PIOCFG_SLP_DIR_MASK_SHIFT(reg) (((reg) & IO_PAD114_PIOCFG_SLP_DIR_MASK) >> IO_PAD114_PIOCFG_SLP_DIR_SHIFT)
#define  IO_PAD114_PIOCFG_SLP_DIR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD114_PIOCFG_SLP_DIR_MASK) | (((uint32_t)val) << IO_PAD114_PIOCFG_SLP_DIR_SHIFT))

#define  IO_PAD114_PIOCFG_EDGE_EN_N_MASK 0x40
#define  IO_PAD114_PIOCFG_EDGE_EN_N_SHIFT 6
#define  IO_PAD114_PIOCFG_EDGE_EN_N_MASK_SHIFT(reg) (((reg) & IO_PAD114_PIOCFG_EDGE_EN_N_MASK) >> IO_PAD114_PIOCFG_EDGE_EN_N_SHIFT)
#define  IO_PAD114_PIOCFG_EDGE_EN_N_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD114_PIOCFG_EDGE_EN_N_MASK) | (((uint32_t)val) << IO_PAD114_PIOCFG_EDGE_EN_N_SHIFT))

#define  IO_PAD114_PIOCFG_EDGE_FALL_EN_MASK 0x20
#define  IO_PAD114_PIOCFG_EDGE_FALL_EN_SHIFT 5
#define  IO_PAD114_PIOCFG_EDGE_FALL_EN_MASK_SHIFT(reg) (((reg) & IO_PAD114_PIOCFG_EDGE_FALL_EN_MASK) >> IO_PAD114_PIOCFG_EDGE_FALL_EN_SHIFT)
#define  IO_PAD114_PIOCFG_EDGE_FALL_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD114_PIOCFG_EDGE_FALL_EN_MASK) | (((uint32_t)val) << IO_PAD114_PIOCFG_EDGE_FALL_EN_SHIFT))

#define  IO_PAD114_PIOCFG_EDGE_RISE_EN_MASK 0x10
#define  IO_PAD114_PIOCFG_EDGE_RISE_EN_SHIFT 4
#define  IO_PAD114_PIOCFG_EDGE_RISE_EN_MASK_SHIFT(reg) (((reg) & IO_PAD114_PIOCFG_EDGE_RISE_EN_MASK) >> IO_PAD114_PIOCFG_EDGE_RISE_EN_SHIFT)
#define  IO_PAD114_PIOCFG_EDGE_RISE_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD114_PIOCFG_EDGE_RISE_EN_MASK) | (((uint32_t)val) << IO_PAD114_PIOCFG_EDGE_RISE_EN_SHIFT))

#define  IO_PAD114_PIOCFG_SLP_SEL_MASK 0x8
#define  IO_PAD114_PIOCFG_SLP_SEL_SHIFT 3
#define  IO_PAD114_PIOCFG_SLP_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD114_PIOCFG_SLP_SEL_MASK) >> IO_PAD114_PIOCFG_SLP_SEL_SHIFT)
#define  IO_PAD114_PIOCFG_SLP_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD114_PIOCFG_SLP_SEL_MASK) | (((uint32_t)val) << IO_PAD114_PIOCFG_SLP_SEL_SHIFT))

#define  IO_PAD114_PIOCFG_FUNC_SEL_MASK 0x7
#define  IO_PAD114_PIOCFG_FUNC_SEL_SHIFT 0
#define  IO_PAD114_PIOCFG_FUNC_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD114_PIOCFG_FUNC_SEL_MASK) >> IO_PAD114_PIOCFG_FUNC_SEL_SHIFT)
#define  IO_PAD114_PIOCFG_FUNC_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD114_PIOCFG_FUNC_SEL_MASK) | (((uint32_t)val) << IO_PAD114_PIOCFG_FUNC_SEL_SHIFT))

//====================================================================
//
//Register File: IO_PAD115 Configuration Registers (IO_PAD115)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

//====================================================================
//Register: IO_PAD115 Configuration Register (PIOCFG)
/** \brief "PHI_PADXDC_HSIOB" Pad*/
//====================================================================

#define  IO_PAD115_PIOCFG_RESERVED1_MASK 0xfc000000
#define  IO_PAD115_PIOCFG_RESERVED1_SHIFT 26
#define  IO_PAD115_PIOCFG_RESERVED1_MASK_SHIFT(reg) (((reg) & IO_PAD115_PIOCFG_RESERVED1_MASK) >> IO_PAD115_PIOCFG_RESERVED1_SHIFT)
#define  IO_PAD115_PIOCFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD115_PIOCFG_RESERVED1_MASK) | (((uint32_t)val) << IO_PAD115_PIOCFG_RESERVED1_SHIFT))

#define  IO_PAD115_PIOCFG_PD_MASK 0x2000000
#define  IO_PAD115_PIOCFG_PD_SHIFT 25
#define  IO_PAD115_PIOCFG_PD_MASK_SHIFT(reg) (((reg) & IO_PAD115_PIOCFG_PD_MASK) >> IO_PAD115_PIOCFG_PD_SHIFT)
#define  IO_PAD115_PIOCFG_PD_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD115_PIOCFG_PD_MASK) | (((uint32_t)val) << IO_PAD115_PIOCFG_PD_SHIFT))

#define  IO_PAD115_PIOCFG_ODT_EN_MASK 0x1000000
#define  IO_PAD115_PIOCFG_ODT_EN_SHIFT 24
#define  IO_PAD115_PIOCFG_ODT_EN_MASK_SHIFT(reg) (((reg) & IO_PAD115_PIOCFG_ODT_EN_MASK) >> IO_PAD115_PIOCFG_ODT_EN_SHIFT)
#define  IO_PAD115_PIOCFG_ODT_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD115_PIOCFG_ODT_EN_MASK) | (((uint32_t)val) << IO_PAD115_PIOCFG_ODT_EN_SHIFT))

#define  IO_PAD115_PIOCFG_LED_EN_MASK 0x800000
#define  IO_PAD115_PIOCFG_LED_EN_SHIFT 23
#define  IO_PAD115_PIOCFG_LED_EN_MASK_SHIFT(reg) (((reg) & IO_PAD115_PIOCFG_LED_EN_MASK) >> IO_PAD115_PIOCFG_LED_EN_SHIFT)
#define  IO_PAD115_PIOCFG_LED_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD115_PIOCFG_LED_EN_MASK) | (((uint32_t)val) << IO_PAD115_PIOCFG_LED_EN_SHIFT))

#define  IO_PAD115_PIOCFG_I2C_SEL_MASK 0x600000
#define  IO_PAD115_PIOCFG_I2C_SEL_SHIFT 21
#define  IO_PAD115_PIOCFG_I2C_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD115_PIOCFG_I2C_SEL_MASK) >> IO_PAD115_PIOCFG_I2C_SEL_SHIFT)
#define  IO_PAD115_PIOCFG_I2C_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD115_PIOCFG_I2C_SEL_MASK) | (((uint32_t)val) << IO_PAD115_PIOCFG_I2C_SEL_SHIFT))

#define  IO_PAD115_PIOCFG_DGTBSEL_MASK 0x1e0000
#define  IO_PAD115_PIOCFG_DGTBSEL_SHIFT 17
#define  IO_PAD115_PIOCFG_DGTBSEL_MASK_SHIFT(reg) (((reg) & IO_PAD115_PIOCFG_DGTBSEL_MASK) >> IO_PAD115_PIOCFG_DGTBSEL_SHIFT)
#define  IO_PAD115_PIOCFG_DGTBSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD115_PIOCFG_DGTBSEL_MASK) | (((uint32_t)val) << IO_PAD115_PIOCFG_DGTBSEL_SHIFT))

#define  IO_PAD115_PIOCFG_RAWSEL_MASK 0x10000
#define  IO_PAD115_PIOCFG_RAWSEL_SHIFT 16
#define  IO_PAD115_PIOCFG_RAWSEL_MASK_SHIFT(reg) (((reg) & IO_PAD115_PIOCFG_RAWSEL_MASK) >> IO_PAD115_PIOCFG_RAWSEL_SHIFT)
#define  IO_PAD115_PIOCFG_RAWSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD115_PIOCFG_RAWSEL_MASK) | (((uint32_t)val) << IO_PAD115_PIOCFG_RAWSEL_SHIFT))

#define  IO_PAD115_PIOCFG_PULL_SEL_MASK 0x8000
#define  IO_PAD115_PIOCFG_PULL_SEL_SHIFT 15
#define  IO_PAD115_PIOCFG_PULL_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD115_PIOCFG_PULL_SEL_MASK) >> IO_PAD115_PIOCFG_PULL_SEL_SHIFT)
#define  IO_PAD115_PIOCFG_PULL_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD115_PIOCFG_PULL_SEL_MASK) | (((uint32_t)val) << IO_PAD115_PIOCFG_PULL_SEL_SHIFT))

#define  IO_PAD115_PIOCFG_PUEN_MASK 0x4000
#define  IO_PAD115_PIOCFG_PUEN_SHIFT 14
#define  IO_PAD115_PIOCFG_PUEN_MASK_SHIFT(reg) (((reg) & IO_PAD115_PIOCFG_PUEN_MASK) >> IO_PAD115_PIOCFG_PUEN_SHIFT)
#define  IO_PAD115_PIOCFG_PUEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD115_PIOCFG_PUEN_MASK) | (((uint32_t)val) << IO_PAD115_PIOCFG_PUEN_SHIFT))

#define  IO_PAD115_PIOCFG_PDEN_MASK 0x2000
#define  IO_PAD115_PIOCFG_PDEN_SHIFT 13
#define  IO_PAD115_PIOCFG_PDEN_MASK_SHIFT(reg) (((reg) & IO_PAD115_PIOCFG_PDEN_MASK) >> IO_PAD115_PIOCFG_PDEN_SHIFT)
#define  IO_PAD115_PIOCFG_PDEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD115_PIOCFG_PDEN_MASK) | (((uint32_t)val) << IO_PAD115_PIOCFG_PDEN_SHIFT))

#define  IO_PAD115_PIOCFG_SR_MASK 0x1800
#define  IO_PAD115_PIOCFG_SR_SHIFT 11
#define  IO_PAD115_PIOCFG_SR_MASK_SHIFT(reg) (((reg) & IO_PAD115_PIOCFG_SR_MASK) >> IO_PAD115_PIOCFG_SR_SHIFT)
#define  IO_PAD115_PIOCFG_SR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD115_PIOCFG_SR_MASK) | (((uint32_t)val) << IO_PAD115_PIOCFG_SR_SHIFT))

#define  IO_PAD115_PIOCFG_SLP_DI_MASK 0x400
#define  IO_PAD115_PIOCFG_SLP_DI_SHIFT 10
#define  IO_PAD115_PIOCFG_SLP_DI_MASK_SHIFT(reg) (((reg) & IO_PAD115_PIOCFG_SLP_DI_MASK) >> IO_PAD115_PIOCFG_SLP_DI_SHIFT)
#define  IO_PAD115_PIOCFG_SLP_DI_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD115_PIOCFG_SLP_DI_MASK) | (((uint32_t)val) << IO_PAD115_PIOCFG_SLP_DI_SHIFT))

#define  IO_PAD115_PIOCFG_SLP_CNTRL_MASK 0x200
#define  IO_PAD115_PIOCFG_SLP_CNTRL_SHIFT 9
#define  IO_PAD115_PIOCFG_SLP_CNTRL_MASK_SHIFT(reg) (((reg) & IO_PAD115_PIOCFG_SLP_CNTRL_MASK) >> IO_PAD115_PIOCFG_SLP_CNTRL_SHIFT)
#define  IO_PAD115_PIOCFG_SLP_CNTRL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD115_PIOCFG_SLP_CNTRL_MASK) | (((uint32_t)val) << IO_PAD115_PIOCFG_SLP_CNTRL_SHIFT))

#define  IO_PAD115_PIOCFG_SLP_DO_MASK 0x100
#define  IO_PAD115_PIOCFG_SLP_DO_SHIFT 8
#define  IO_PAD115_PIOCFG_SLP_DO_MASK_SHIFT(reg) (((reg) & IO_PAD115_PIOCFG_SLP_DO_MASK) >> IO_PAD115_PIOCFG_SLP_DO_SHIFT)
#define  IO_PAD115_PIOCFG_SLP_DO_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD115_PIOCFG_SLP_DO_MASK) | (((uint32_t)val) << IO_PAD115_PIOCFG_SLP_DO_SHIFT))

#define  IO_PAD115_PIOCFG_SLP_DIR_MASK 0x80
#define  IO_PAD115_PIOCFG_SLP_DIR_SHIFT 7
#define  IO_PAD115_PIOCFG_SLP_DIR_MASK_SHIFT(reg) (((reg) & IO_PAD115_PIOCFG_SLP_DIR_MASK) >> IO_PAD115_PIOCFG_SLP_DIR_SHIFT)
#define  IO_PAD115_PIOCFG_SLP_DIR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD115_PIOCFG_SLP_DIR_MASK) | (((uint32_t)val) << IO_PAD115_PIOCFG_SLP_DIR_SHIFT))

#define  IO_PAD115_PIOCFG_EDGE_EN_N_MASK 0x40
#define  IO_PAD115_PIOCFG_EDGE_EN_N_SHIFT 6
#define  IO_PAD115_PIOCFG_EDGE_EN_N_MASK_SHIFT(reg) (((reg) & IO_PAD115_PIOCFG_EDGE_EN_N_MASK) >> IO_PAD115_PIOCFG_EDGE_EN_N_SHIFT)
#define  IO_PAD115_PIOCFG_EDGE_EN_N_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD115_PIOCFG_EDGE_EN_N_MASK) | (((uint32_t)val) << IO_PAD115_PIOCFG_EDGE_EN_N_SHIFT))

#define  IO_PAD115_PIOCFG_EDGE_FALL_EN_MASK 0x20
#define  IO_PAD115_PIOCFG_EDGE_FALL_EN_SHIFT 5
#define  IO_PAD115_PIOCFG_EDGE_FALL_EN_MASK_SHIFT(reg) (((reg) & IO_PAD115_PIOCFG_EDGE_FALL_EN_MASK) >> IO_PAD115_PIOCFG_EDGE_FALL_EN_SHIFT)
#define  IO_PAD115_PIOCFG_EDGE_FALL_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD115_PIOCFG_EDGE_FALL_EN_MASK) | (((uint32_t)val) << IO_PAD115_PIOCFG_EDGE_FALL_EN_SHIFT))

#define  IO_PAD115_PIOCFG_EDGE_RISE_EN_MASK 0x10
#define  IO_PAD115_PIOCFG_EDGE_RISE_EN_SHIFT 4
#define  IO_PAD115_PIOCFG_EDGE_RISE_EN_MASK_SHIFT(reg) (((reg) & IO_PAD115_PIOCFG_EDGE_RISE_EN_MASK) >> IO_PAD115_PIOCFG_EDGE_RISE_EN_SHIFT)
#define  IO_PAD115_PIOCFG_EDGE_RISE_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD115_PIOCFG_EDGE_RISE_EN_MASK) | (((uint32_t)val) << IO_PAD115_PIOCFG_EDGE_RISE_EN_SHIFT))

#define  IO_PAD115_PIOCFG_SLP_SEL_MASK 0x8
#define  IO_PAD115_PIOCFG_SLP_SEL_SHIFT 3
#define  IO_PAD115_PIOCFG_SLP_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD115_PIOCFG_SLP_SEL_MASK) >> IO_PAD115_PIOCFG_SLP_SEL_SHIFT)
#define  IO_PAD115_PIOCFG_SLP_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD115_PIOCFG_SLP_SEL_MASK) | (((uint32_t)val) << IO_PAD115_PIOCFG_SLP_SEL_SHIFT))

#define  IO_PAD115_PIOCFG_FUNC_SEL_MASK 0x7
#define  IO_PAD115_PIOCFG_FUNC_SEL_SHIFT 0
#define  IO_PAD115_PIOCFG_FUNC_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD115_PIOCFG_FUNC_SEL_MASK) >> IO_PAD115_PIOCFG_FUNC_SEL_SHIFT)
#define  IO_PAD115_PIOCFG_FUNC_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD115_PIOCFG_FUNC_SEL_MASK) | (((uint32_t)val) << IO_PAD115_PIOCFG_FUNC_SEL_SHIFT))

//====================================================================
//
//Register File: IO_PAD116 Configuration Registers (IO_PAD116)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

//====================================================================
//Register: IO_PAD116 Configuration Register (PIOCFG)
/** \brief "PHI_PADXDC_HSIOB" Pad*/
//====================================================================

#define  IO_PAD116_PIOCFG_RESERVED1_MASK 0xfc000000
#define  IO_PAD116_PIOCFG_RESERVED1_SHIFT 26
#define  IO_PAD116_PIOCFG_RESERVED1_MASK_SHIFT(reg) (((reg) & IO_PAD116_PIOCFG_RESERVED1_MASK) >> IO_PAD116_PIOCFG_RESERVED1_SHIFT)
#define  IO_PAD116_PIOCFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD116_PIOCFG_RESERVED1_MASK) | (((uint32_t)val) << IO_PAD116_PIOCFG_RESERVED1_SHIFT))

#define  IO_PAD116_PIOCFG_PD_MASK 0x2000000
#define  IO_PAD116_PIOCFG_PD_SHIFT 25
#define  IO_PAD116_PIOCFG_PD_MASK_SHIFT(reg) (((reg) & IO_PAD116_PIOCFG_PD_MASK) >> IO_PAD116_PIOCFG_PD_SHIFT)
#define  IO_PAD116_PIOCFG_PD_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD116_PIOCFG_PD_MASK) | (((uint32_t)val) << IO_PAD116_PIOCFG_PD_SHIFT))

#define  IO_PAD116_PIOCFG_ODT_EN_MASK 0x1000000
#define  IO_PAD116_PIOCFG_ODT_EN_SHIFT 24
#define  IO_PAD116_PIOCFG_ODT_EN_MASK_SHIFT(reg) (((reg) & IO_PAD116_PIOCFG_ODT_EN_MASK) >> IO_PAD116_PIOCFG_ODT_EN_SHIFT)
#define  IO_PAD116_PIOCFG_ODT_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD116_PIOCFG_ODT_EN_MASK) | (((uint32_t)val) << IO_PAD116_PIOCFG_ODT_EN_SHIFT))

#define  IO_PAD116_PIOCFG_LED_EN_MASK 0x800000
#define  IO_PAD116_PIOCFG_LED_EN_SHIFT 23
#define  IO_PAD116_PIOCFG_LED_EN_MASK_SHIFT(reg) (((reg) & IO_PAD116_PIOCFG_LED_EN_MASK) >> IO_PAD116_PIOCFG_LED_EN_SHIFT)
#define  IO_PAD116_PIOCFG_LED_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD116_PIOCFG_LED_EN_MASK) | (((uint32_t)val) << IO_PAD116_PIOCFG_LED_EN_SHIFT))

#define  IO_PAD116_PIOCFG_I2C_SEL_MASK 0x600000
#define  IO_PAD116_PIOCFG_I2C_SEL_SHIFT 21
#define  IO_PAD116_PIOCFG_I2C_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD116_PIOCFG_I2C_SEL_MASK) >> IO_PAD116_PIOCFG_I2C_SEL_SHIFT)
#define  IO_PAD116_PIOCFG_I2C_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD116_PIOCFG_I2C_SEL_MASK) | (((uint32_t)val) << IO_PAD116_PIOCFG_I2C_SEL_SHIFT))

#define  IO_PAD116_PIOCFG_DGTBSEL_MASK 0x1e0000
#define  IO_PAD116_PIOCFG_DGTBSEL_SHIFT 17
#define  IO_PAD116_PIOCFG_DGTBSEL_MASK_SHIFT(reg) (((reg) & IO_PAD116_PIOCFG_DGTBSEL_MASK) >> IO_PAD116_PIOCFG_DGTBSEL_SHIFT)
#define  IO_PAD116_PIOCFG_DGTBSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD116_PIOCFG_DGTBSEL_MASK) | (((uint32_t)val) << IO_PAD116_PIOCFG_DGTBSEL_SHIFT))

#define  IO_PAD116_PIOCFG_RAWSEL_MASK 0x10000
#define  IO_PAD116_PIOCFG_RAWSEL_SHIFT 16
#define  IO_PAD116_PIOCFG_RAWSEL_MASK_SHIFT(reg) (((reg) & IO_PAD116_PIOCFG_RAWSEL_MASK) >> IO_PAD116_PIOCFG_RAWSEL_SHIFT)
#define  IO_PAD116_PIOCFG_RAWSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD116_PIOCFG_RAWSEL_MASK) | (((uint32_t)val) << IO_PAD116_PIOCFG_RAWSEL_SHIFT))

#define  IO_PAD116_PIOCFG_PULL_SEL_MASK 0x8000
#define  IO_PAD116_PIOCFG_PULL_SEL_SHIFT 15
#define  IO_PAD116_PIOCFG_PULL_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD116_PIOCFG_PULL_SEL_MASK) >> IO_PAD116_PIOCFG_PULL_SEL_SHIFT)
#define  IO_PAD116_PIOCFG_PULL_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD116_PIOCFG_PULL_SEL_MASK) | (((uint32_t)val) << IO_PAD116_PIOCFG_PULL_SEL_SHIFT))

#define  IO_PAD116_PIOCFG_PUEN_MASK 0x4000
#define  IO_PAD116_PIOCFG_PUEN_SHIFT 14
#define  IO_PAD116_PIOCFG_PUEN_MASK_SHIFT(reg) (((reg) & IO_PAD116_PIOCFG_PUEN_MASK) >> IO_PAD116_PIOCFG_PUEN_SHIFT)
#define  IO_PAD116_PIOCFG_PUEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD116_PIOCFG_PUEN_MASK) | (((uint32_t)val) << IO_PAD116_PIOCFG_PUEN_SHIFT))

#define  IO_PAD116_PIOCFG_PDEN_MASK 0x2000
#define  IO_PAD116_PIOCFG_PDEN_SHIFT 13
#define  IO_PAD116_PIOCFG_PDEN_MASK_SHIFT(reg) (((reg) & IO_PAD116_PIOCFG_PDEN_MASK) >> IO_PAD116_PIOCFG_PDEN_SHIFT)
#define  IO_PAD116_PIOCFG_PDEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD116_PIOCFG_PDEN_MASK) | (((uint32_t)val) << IO_PAD116_PIOCFG_PDEN_SHIFT))

#define  IO_PAD116_PIOCFG_SR_MASK 0x1800
#define  IO_PAD116_PIOCFG_SR_SHIFT 11
#define  IO_PAD116_PIOCFG_SR_MASK_SHIFT(reg) (((reg) & IO_PAD116_PIOCFG_SR_MASK) >> IO_PAD116_PIOCFG_SR_SHIFT)
#define  IO_PAD116_PIOCFG_SR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD116_PIOCFG_SR_MASK) | (((uint32_t)val) << IO_PAD116_PIOCFG_SR_SHIFT))

#define  IO_PAD116_PIOCFG_SLP_DI_MASK 0x400
#define  IO_PAD116_PIOCFG_SLP_DI_SHIFT 10
#define  IO_PAD116_PIOCFG_SLP_DI_MASK_SHIFT(reg) (((reg) & IO_PAD116_PIOCFG_SLP_DI_MASK) >> IO_PAD116_PIOCFG_SLP_DI_SHIFT)
#define  IO_PAD116_PIOCFG_SLP_DI_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD116_PIOCFG_SLP_DI_MASK) | (((uint32_t)val) << IO_PAD116_PIOCFG_SLP_DI_SHIFT))

#define  IO_PAD116_PIOCFG_SLP_CNTRL_MASK 0x200
#define  IO_PAD116_PIOCFG_SLP_CNTRL_SHIFT 9
#define  IO_PAD116_PIOCFG_SLP_CNTRL_MASK_SHIFT(reg) (((reg) & IO_PAD116_PIOCFG_SLP_CNTRL_MASK) >> IO_PAD116_PIOCFG_SLP_CNTRL_SHIFT)
#define  IO_PAD116_PIOCFG_SLP_CNTRL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD116_PIOCFG_SLP_CNTRL_MASK) | (((uint32_t)val) << IO_PAD116_PIOCFG_SLP_CNTRL_SHIFT))

#define  IO_PAD116_PIOCFG_SLP_DO_MASK 0x100
#define  IO_PAD116_PIOCFG_SLP_DO_SHIFT 8
#define  IO_PAD116_PIOCFG_SLP_DO_MASK_SHIFT(reg) (((reg) & IO_PAD116_PIOCFG_SLP_DO_MASK) >> IO_PAD116_PIOCFG_SLP_DO_SHIFT)
#define  IO_PAD116_PIOCFG_SLP_DO_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD116_PIOCFG_SLP_DO_MASK) | (((uint32_t)val) << IO_PAD116_PIOCFG_SLP_DO_SHIFT))

#define  IO_PAD116_PIOCFG_SLP_DIR_MASK 0x80
#define  IO_PAD116_PIOCFG_SLP_DIR_SHIFT 7
#define  IO_PAD116_PIOCFG_SLP_DIR_MASK_SHIFT(reg) (((reg) & IO_PAD116_PIOCFG_SLP_DIR_MASK) >> IO_PAD116_PIOCFG_SLP_DIR_SHIFT)
#define  IO_PAD116_PIOCFG_SLP_DIR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD116_PIOCFG_SLP_DIR_MASK) | (((uint32_t)val) << IO_PAD116_PIOCFG_SLP_DIR_SHIFT))

#define  IO_PAD116_PIOCFG_EDGE_EN_N_MASK 0x40
#define  IO_PAD116_PIOCFG_EDGE_EN_N_SHIFT 6
#define  IO_PAD116_PIOCFG_EDGE_EN_N_MASK_SHIFT(reg) (((reg) & IO_PAD116_PIOCFG_EDGE_EN_N_MASK) >> IO_PAD116_PIOCFG_EDGE_EN_N_SHIFT)
#define  IO_PAD116_PIOCFG_EDGE_EN_N_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD116_PIOCFG_EDGE_EN_N_MASK) | (((uint32_t)val) << IO_PAD116_PIOCFG_EDGE_EN_N_SHIFT))

#define  IO_PAD116_PIOCFG_EDGE_FALL_EN_MASK 0x20
#define  IO_PAD116_PIOCFG_EDGE_FALL_EN_SHIFT 5
#define  IO_PAD116_PIOCFG_EDGE_FALL_EN_MASK_SHIFT(reg) (((reg) & IO_PAD116_PIOCFG_EDGE_FALL_EN_MASK) >> IO_PAD116_PIOCFG_EDGE_FALL_EN_SHIFT)
#define  IO_PAD116_PIOCFG_EDGE_FALL_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD116_PIOCFG_EDGE_FALL_EN_MASK) | (((uint32_t)val) << IO_PAD116_PIOCFG_EDGE_FALL_EN_SHIFT))

#define  IO_PAD116_PIOCFG_EDGE_RISE_EN_MASK 0x10
#define  IO_PAD116_PIOCFG_EDGE_RISE_EN_SHIFT 4
#define  IO_PAD116_PIOCFG_EDGE_RISE_EN_MASK_SHIFT(reg) (((reg) & IO_PAD116_PIOCFG_EDGE_RISE_EN_MASK) >> IO_PAD116_PIOCFG_EDGE_RISE_EN_SHIFT)
#define  IO_PAD116_PIOCFG_EDGE_RISE_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD116_PIOCFG_EDGE_RISE_EN_MASK) | (((uint32_t)val) << IO_PAD116_PIOCFG_EDGE_RISE_EN_SHIFT))

#define  IO_PAD116_PIOCFG_SLP_SEL_MASK 0x8
#define  IO_PAD116_PIOCFG_SLP_SEL_SHIFT 3
#define  IO_PAD116_PIOCFG_SLP_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD116_PIOCFG_SLP_SEL_MASK) >> IO_PAD116_PIOCFG_SLP_SEL_SHIFT)
#define  IO_PAD116_PIOCFG_SLP_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD116_PIOCFG_SLP_SEL_MASK) | (((uint32_t)val) << IO_PAD116_PIOCFG_SLP_SEL_SHIFT))

#define  IO_PAD116_PIOCFG_FUNC_SEL_MASK 0x7
#define  IO_PAD116_PIOCFG_FUNC_SEL_SHIFT 0
#define  IO_PAD116_PIOCFG_FUNC_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD116_PIOCFG_FUNC_SEL_MASK) >> IO_PAD116_PIOCFG_FUNC_SEL_SHIFT)
#define  IO_PAD116_PIOCFG_FUNC_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD116_PIOCFG_FUNC_SEL_MASK) | (((uint32_t)val) << IO_PAD116_PIOCFG_FUNC_SEL_SHIFT))

//====================================================================
//
//Register File: IO_PAD117 Configuration Registers (IO_PAD117)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

//====================================================================
//Register: IO_PAD117 Configuration Register (PIOCFG)
/** \brief "PHI_PADXDC_HSIOB" Pad*/
//====================================================================

#define  IO_PAD117_PIOCFG_RESERVED1_MASK 0xfc000000
#define  IO_PAD117_PIOCFG_RESERVED1_SHIFT 26
#define  IO_PAD117_PIOCFG_RESERVED1_MASK_SHIFT(reg) (((reg) & IO_PAD117_PIOCFG_RESERVED1_MASK) >> IO_PAD117_PIOCFG_RESERVED1_SHIFT)
#define  IO_PAD117_PIOCFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD117_PIOCFG_RESERVED1_MASK) | (((uint32_t)val) << IO_PAD117_PIOCFG_RESERVED1_SHIFT))

#define  IO_PAD117_PIOCFG_PD_MASK 0x2000000
#define  IO_PAD117_PIOCFG_PD_SHIFT 25
#define  IO_PAD117_PIOCFG_PD_MASK_SHIFT(reg) (((reg) & IO_PAD117_PIOCFG_PD_MASK) >> IO_PAD117_PIOCFG_PD_SHIFT)
#define  IO_PAD117_PIOCFG_PD_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD117_PIOCFG_PD_MASK) | (((uint32_t)val) << IO_PAD117_PIOCFG_PD_SHIFT))

#define  IO_PAD117_PIOCFG_ODT_EN_MASK 0x1000000
#define  IO_PAD117_PIOCFG_ODT_EN_SHIFT 24
#define  IO_PAD117_PIOCFG_ODT_EN_MASK_SHIFT(reg) (((reg) & IO_PAD117_PIOCFG_ODT_EN_MASK) >> IO_PAD117_PIOCFG_ODT_EN_SHIFT)
#define  IO_PAD117_PIOCFG_ODT_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD117_PIOCFG_ODT_EN_MASK) | (((uint32_t)val) << IO_PAD117_PIOCFG_ODT_EN_SHIFT))

#define  IO_PAD117_PIOCFG_LED_EN_MASK 0x800000
#define  IO_PAD117_PIOCFG_LED_EN_SHIFT 23
#define  IO_PAD117_PIOCFG_LED_EN_MASK_SHIFT(reg) (((reg) & IO_PAD117_PIOCFG_LED_EN_MASK) >> IO_PAD117_PIOCFG_LED_EN_SHIFT)
#define  IO_PAD117_PIOCFG_LED_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD117_PIOCFG_LED_EN_MASK) | (((uint32_t)val) << IO_PAD117_PIOCFG_LED_EN_SHIFT))

#define  IO_PAD117_PIOCFG_I2C_SEL_MASK 0x600000
#define  IO_PAD117_PIOCFG_I2C_SEL_SHIFT 21
#define  IO_PAD117_PIOCFG_I2C_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD117_PIOCFG_I2C_SEL_MASK) >> IO_PAD117_PIOCFG_I2C_SEL_SHIFT)
#define  IO_PAD117_PIOCFG_I2C_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD117_PIOCFG_I2C_SEL_MASK) | (((uint32_t)val) << IO_PAD117_PIOCFG_I2C_SEL_SHIFT))

#define  IO_PAD117_PIOCFG_DGTBSEL_MASK 0x1e0000
#define  IO_PAD117_PIOCFG_DGTBSEL_SHIFT 17
#define  IO_PAD117_PIOCFG_DGTBSEL_MASK_SHIFT(reg) (((reg) & IO_PAD117_PIOCFG_DGTBSEL_MASK) >> IO_PAD117_PIOCFG_DGTBSEL_SHIFT)
#define  IO_PAD117_PIOCFG_DGTBSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD117_PIOCFG_DGTBSEL_MASK) | (((uint32_t)val) << IO_PAD117_PIOCFG_DGTBSEL_SHIFT))

#define  IO_PAD117_PIOCFG_RAWSEL_MASK 0x10000
#define  IO_PAD117_PIOCFG_RAWSEL_SHIFT 16
#define  IO_PAD117_PIOCFG_RAWSEL_MASK_SHIFT(reg) (((reg) & IO_PAD117_PIOCFG_RAWSEL_MASK) >> IO_PAD117_PIOCFG_RAWSEL_SHIFT)
#define  IO_PAD117_PIOCFG_RAWSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD117_PIOCFG_RAWSEL_MASK) | (((uint32_t)val) << IO_PAD117_PIOCFG_RAWSEL_SHIFT))

#define  IO_PAD117_PIOCFG_PULL_SEL_MASK 0x8000
#define  IO_PAD117_PIOCFG_PULL_SEL_SHIFT 15
#define  IO_PAD117_PIOCFG_PULL_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD117_PIOCFG_PULL_SEL_MASK) >> IO_PAD117_PIOCFG_PULL_SEL_SHIFT)
#define  IO_PAD117_PIOCFG_PULL_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD117_PIOCFG_PULL_SEL_MASK) | (((uint32_t)val) << IO_PAD117_PIOCFG_PULL_SEL_SHIFT))

#define  IO_PAD117_PIOCFG_PUEN_MASK 0x4000
#define  IO_PAD117_PIOCFG_PUEN_SHIFT 14
#define  IO_PAD117_PIOCFG_PUEN_MASK_SHIFT(reg) (((reg) & IO_PAD117_PIOCFG_PUEN_MASK) >> IO_PAD117_PIOCFG_PUEN_SHIFT)
#define  IO_PAD117_PIOCFG_PUEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD117_PIOCFG_PUEN_MASK) | (((uint32_t)val) << IO_PAD117_PIOCFG_PUEN_SHIFT))

#define  IO_PAD117_PIOCFG_PDEN_MASK 0x2000
#define  IO_PAD117_PIOCFG_PDEN_SHIFT 13
#define  IO_PAD117_PIOCFG_PDEN_MASK_SHIFT(reg) (((reg) & IO_PAD117_PIOCFG_PDEN_MASK) >> IO_PAD117_PIOCFG_PDEN_SHIFT)
#define  IO_PAD117_PIOCFG_PDEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD117_PIOCFG_PDEN_MASK) | (((uint32_t)val) << IO_PAD117_PIOCFG_PDEN_SHIFT))

#define  IO_PAD117_PIOCFG_SR_MASK 0x1800
#define  IO_PAD117_PIOCFG_SR_SHIFT 11
#define  IO_PAD117_PIOCFG_SR_MASK_SHIFT(reg) (((reg) & IO_PAD117_PIOCFG_SR_MASK) >> IO_PAD117_PIOCFG_SR_SHIFT)
#define  IO_PAD117_PIOCFG_SR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD117_PIOCFG_SR_MASK) | (((uint32_t)val) << IO_PAD117_PIOCFG_SR_SHIFT))

#define  IO_PAD117_PIOCFG_SLP_DI_MASK 0x400
#define  IO_PAD117_PIOCFG_SLP_DI_SHIFT 10
#define  IO_PAD117_PIOCFG_SLP_DI_MASK_SHIFT(reg) (((reg) & IO_PAD117_PIOCFG_SLP_DI_MASK) >> IO_PAD117_PIOCFG_SLP_DI_SHIFT)
#define  IO_PAD117_PIOCFG_SLP_DI_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD117_PIOCFG_SLP_DI_MASK) | (((uint32_t)val) << IO_PAD117_PIOCFG_SLP_DI_SHIFT))

#define  IO_PAD117_PIOCFG_SLP_CNTRL_MASK 0x200
#define  IO_PAD117_PIOCFG_SLP_CNTRL_SHIFT 9
#define  IO_PAD117_PIOCFG_SLP_CNTRL_MASK_SHIFT(reg) (((reg) & IO_PAD117_PIOCFG_SLP_CNTRL_MASK) >> IO_PAD117_PIOCFG_SLP_CNTRL_SHIFT)
#define  IO_PAD117_PIOCFG_SLP_CNTRL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD117_PIOCFG_SLP_CNTRL_MASK) | (((uint32_t)val) << IO_PAD117_PIOCFG_SLP_CNTRL_SHIFT))

#define  IO_PAD117_PIOCFG_SLP_DO_MASK 0x100
#define  IO_PAD117_PIOCFG_SLP_DO_SHIFT 8
#define  IO_PAD117_PIOCFG_SLP_DO_MASK_SHIFT(reg) (((reg) & IO_PAD117_PIOCFG_SLP_DO_MASK) >> IO_PAD117_PIOCFG_SLP_DO_SHIFT)
#define  IO_PAD117_PIOCFG_SLP_DO_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD117_PIOCFG_SLP_DO_MASK) | (((uint32_t)val) << IO_PAD117_PIOCFG_SLP_DO_SHIFT))

#define  IO_PAD117_PIOCFG_SLP_DIR_MASK 0x80
#define  IO_PAD117_PIOCFG_SLP_DIR_SHIFT 7
#define  IO_PAD117_PIOCFG_SLP_DIR_MASK_SHIFT(reg) (((reg) & IO_PAD117_PIOCFG_SLP_DIR_MASK) >> IO_PAD117_PIOCFG_SLP_DIR_SHIFT)
#define  IO_PAD117_PIOCFG_SLP_DIR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD117_PIOCFG_SLP_DIR_MASK) | (((uint32_t)val) << IO_PAD117_PIOCFG_SLP_DIR_SHIFT))

#define  IO_PAD117_PIOCFG_EDGE_EN_N_MASK 0x40
#define  IO_PAD117_PIOCFG_EDGE_EN_N_SHIFT 6
#define  IO_PAD117_PIOCFG_EDGE_EN_N_MASK_SHIFT(reg) (((reg) & IO_PAD117_PIOCFG_EDGE_EN_N_MASK) >> IO_PAD117_PIOCFG_EDGE_EN_N_SHIFT)
#define  IO_PAD117_PIOCFG_EDGE_EN_N_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD117_PIOCFG_EDGE_EN_N_MASK) | (((uint32_t)val) << IO_PAD117_PIOCFG_EDGE_EN_N_SHIFT))

#define  IO_PAD117_PIOCFG_EDGE_FALL_EN_MASK 0x20
#define  IO_PAD117_PIOCFG_EDGE_FALL_EN_SHIFT 5
#define  IO_PAD117_PIOCFG_EDGE_FALL_EN_MASK_SHIFT(reg) (((reg) & IO_PAD117_PIOCFG_EDGE_FALL_EN_MASK) >> IO_PAD117_PIOCFG_EDGE_FALL_EN_SHIFT)
#define  IO_PAD117_PIOCFG_EDGE_FALL_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD117_PIOCFG_EDGE_FALL_EN_MASK) | (((uint32_t)val) << IO_PAD117_PIOCFG_EDGE_FALL_EN_SHIFT))

#define  IO_PAD117_PIOCFG_EDGE_RISE_EN_MASK 0x10
#define  IO_PAD117_PIOCFG_EDGE_RISE_EN_SHIFT 4
#define  IO_PAD117_PIOCFG_EDGE_RISE_EN_MASK_SHIFT(reg) (((reg) & IO_PAD117_PIOCFG_EDGE_RISE_EN_MASK) >> IO_PAD117_PIOCFG_EDGE_RISE_EN_SHIFT)
#define  IO_PAD117_PIOCFG_EDGE_RISE_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD117_PIOCFG_EDGE_RISE_EN_MASK) | (((uint32_t)val) << IO_PAD117_PIOCFG_EDGE_RISE_EN_SHIFT))

#define  IO_PAD117_PIOCFG_SLP_SEL_MASK 0x8
#define  IO_PAD117_PIOCFG_SLP_SEL_SHIFT 3
#define  IO_PAD117_PIOCFG_SLP_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD117_PIOCFG_SLP_SEL_MASK) >> IO_PAD117_PIOCFG_SLP_SEL_SHIFT)
#define  IO_PAD117_PIOCFG_SLP_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD117_PIOCFG_SLP_SEL_MASK) | (((uint32_t)val) << IO_PAD117_PIOCFG_SLP_SEL_SHIFT))

#define  IO_PAD117_PIOCFG_FUNC_SEL_MASK 0x7
#define  IO_PAD117_PIOCFG_FUNC_SEL_SHIFT 0
#define  IO_PAD117_PIOCFG_FUNC_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD117_PIOCFG_FUNC_SEL_MASK) >> IO_PAD117_PIOCFG_FUNC_SEL_SHIFT)
#define  IO_PAD117_PIOCFG_FUNC_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD117_PIOCFG_FUNC_SEL_MASK) | (((uint32_t)val) << IO_PAD117_PIOCFG_FUNC_SEL_SHIFT))

//====================================================================
//
//Register File: IO_PAD118 Configuration Registers (IO_PAD118)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

//====================================================================
//Register: IO_PAD118 Configuration Register (PIOCFG)
/** \brief "PHI_PADXDC_HSIOB" Pad*/
//====================================================================

#define  IO_PAD118_PIOCFG_RESERVED1_MASK 0xfc000000
#define  IO_PAD118_PIOCFG_RESERVED1_SHIFT 26
#define  IO_PAD118_PIOCFG_RESERVED1_MASK_SHIFT(reg) (((reg) & IO_PAD118_PIOCFG_RESERVED1_MASK) >> IO_PAD118_PIOCFG_RESERVED1_SHIFT)
#define  IO_PAD118_PIOCFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD118_PIOCFG_RESERVED1_MASK) | (((uint32_t)val) << IO_PAD118_PIOCFG_RESERVED1_SHIFT))

#define  IO_PAD118_PIOCFG_PD_MASK 0x2000000
#define  IO_PAD118_PIOCFG_PD_SHIFT 25
#define  IO_PAD118_PIOCFG_PD_MASK_SHIFT(reg) (((reg) & IO_PAD118_PIOCFG_PD_MASK) >> IO_PAD118_PIOCFG_PD_SHIFT)
#define  IO_PAD118_PIOCFG_PD_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD118_PIOCFG_PD_MASK) | (((uint32_t)val) << IO_PAD118_PIOCFG_PD_SHIFT))

#define  IO_PAD118_PIOCFG_ODT_EN_MASK 0x1000000
#define  IO_PAD118_PIOCFG_ODT_EN_SHIFT 24
#define  IO_PAD118_PIOCFG_ODT_EN_MASK_SHIFT(reg) (((reg) & IO_PAD118_PIOCFG_ODT_EN_MASK) >> IO_PAD118_PIOCFG_ODT_EN_SHIFT)
#define  IO_PAD118_PIOCFG_ODT_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD118_PIOCFG_ODT_EN_MASK) | (((uint32_t)val) << IO_PAD118_PIOCFG_ODT_EN_SHIFT))

#define  IO_PAD118_PIOCFG_LED_EN_MASK 0x800000
#define  IO_PAD118_PIOCFG_LED_EN_SHIFT 23
#define  IO_PAD118_PIOCFG_LED_EN_MASK_SHIFT(reg) (((reg) & IO_PAD118_PIOCFG_LED_EN_MASK) >> IO_PAD118_PIOCFG_LED_EN_SHIFT)
#define  IO_PAD118_PIOCFG_LED_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD118_PIOCFG_LED_EN_MASK) | (((uint32_t)val) << IO_PAD118_PIOCFG_LED_EN_SHIFT))

#define  IO_PAD118_PIOCFG_I2C_SEL_MASK 0x600000
#define  IO_PAD118_PIOCFG_I2C_SEL_SHIFT 21
#define  IO_PAD118_PIOCFG_I2C_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD118_PIOCFG_I2C_SEL_MASK) >> IO_PAD118_PIOCFG_I2C_SEL_SHIFT)
#define  IO_PAD118_PIOCFG_I2C_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD118_PIOCFG_I2C_SEL_MASK) | (((uint32_t)val) << IO_PAD118_PIOCFG_I2C_SEL_SHIFT))

#define  IO_PAD118_PIOCFG_DGTBSEL_MASK 0x1e0000
#define  IO_PAD118_PIOCFG_DGTBSEL_SHIFT 17
#define  IO_PAD118_PIOCFG_DGTBSEL_MASK_SHIFT(reg) (((reg) & IO_PAD118_PIOCFG_DGTBSEL_MASK) >> IO_PAD118_PIOCFG_DGTBSEL_SHIFT)
#define  IO_PAD118_PIOCFG_DGTBSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD118_PIOCFG_DGTBSEL_MASK) | (((uint32_t)val) << IO_PAD118_PIOCFG_DGTBSEL_SHIFT))

#define  IO_PAD118_PIOCFG_RAWSEL_MASK 0x10000
#define  IO_PAD118_PIOCFG_RAWSEL_SHIFT 16
#define  IO_PAD118_PIOCFG_RAWSEL_MASK_SHIFT(reg) (((reg) & IO_PAD118_PIOCFG_RAWSEL_MASK) >> IO_PAD118_PIOCFG_RAWSEL_SHIFT)
#define  IO_PAD118_PIOCFG_RAWSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD118_PIOCFG_RAWSEL_MASK) | (((uint32_t)val) << IO_PAD118_PIOCFG_RAWSEL_SHIFT))

#define  IO_PAD118_PIOCFG_PULL_SEL_MASK 0x8000
#define  IO_PAD118_PIOCFG_PULL_SEL_SHIFT 15
#define  IO_PAD118_PIOCFG_PULL_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD118_PIOCFG_PULL_SEL_MASK) >> IO_PAD118_PIOCFG_PULL_SEL_SHIFT)
#define  IO_PAD118_PIOCFG_PULL_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD118_PIOCFG_PULL_SEL_MASK) | (((uint32_t)val) << IO_PAD118_PIOCFG_PULL_SEL_SHIFT))

#define  IO_PAD118_PIOCFG_PUEN_MASK 0x4000
#define  IO_PAD118_PIOCFG_PUEN_SHIFT 14
#define  IO_PAD118_PIOCFG_PUEN_MASK_SHIFT(reg) (((reg) & IO_PAD118_PIOCFG_PUEN_MASK) >> IO_PAD118_PIOCFG_PUEN_SHIFT)
#define  IO_PAD118_PIOCFG_PUEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD118_PIOCFG_PUEN_MASK) | (((uint32_t)val) << IO_PAD118_PIOCFG_PUEN_SHIFT))

#define  IO_PAD118_PIOCFG_PDEN_MASK 0x2000
#define  IO_PAD118_PIOCFG_PDEN_SHIFT 13
#define  IO_PAD118_PIOCFG_PDEN_MASK_SHIFT(reg) (((reg) & IO_PAD118_PIOCFG_PDEN_MASK) >> IO_PAD118_PIOCFG_PDEN_SHIFT)
#define  IO_PAD118_PIOCFG_PDEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD118_PIOCFG_PDEN_MASK) | (((uint32_t)val) << IO_PAD118_PIOCFG_PDEN_SHIFT))

#define  IO_PAD118_PIOCFG_SR_MASK 0x1800
#define  IO_PAD118_PIOCFG_SR_SHIFT 11
#define  IO_PAD118_PIOCFG_SR_MASK_SHIFT(reg) (((reg) & IO_PAD118_PIOCFG_SR_MASK) >> IO_PAD118_PIOCFG_SR_SHIFT)
#define  IO_PAD118_PIOCFG_SR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD118_PIOCFG_SR_MASK) | (((uint32_t)val) << IO_PAD118_PIOCFG_SR_SHIFT))

#define  IO_PAD118_PIOCFG_SLP_DI_MASK 0x400
#define  IO_PAD118_PIOCFG_SLP_DI_SHIFT 10
#define  IO_PAD118_PIOCFG_SLP_DI_MASK_SHIFT(reg) (((reg) & IO_PAD118_PIOCFG_SLP_DI_MASK) >> IO_PAD118_PIOCFG_SLP_DI_SHIFT)
#define  IO_PAD118_PIOCFG_SLP_DI_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD118_PIOCFG_SLP_DI_MASK) | (((uint32_t)val) << IO_PAD118_PIOCFG_SLP_DI_SHIFT))

#define  IO_PAD118_PIOCFG_SLP_CNTRL_MASK 0x200
#define  IO_PAD118_PIOCFG_SLP_CNTRL_SHIFT 9
#define  IO_PAD118_PIOCFG_SLP_CNTRL_MASK_SHIFT(reg) (((reg) & IO_PAD118_PIOCFG_SLP_CNTRL_MASK) >> IO_PAD118_PIOCFG_SLP_CNTRL_SHIFT)
#define  IO_PAD118_PIOCFG_SLP_CNTRL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD118_PIOCFG_SLP_CNTRL_MASK) | (((uint32_t)val) << IO_PAD118_PIOCFG_SLP_CNTRL_SHIFT))

#define  IO_PAD118_PIOCFG_SLP_DO_MASK 0x100
#define  IO_PAD118_PIOCFG_SLP_DO_SHIFT 8
#define  IO_PAD118_PIOCFG_SLP_DO_MASK_SHIFT(reg) (((reg) & IO_PAD118_PIOCFG_SLP_DO_MASK) >> IO_PAD118_PIOCFG_SLP_DO_SHIFT)
#define  IO_PAD118_PIOCFG_SLP_DO_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD118_PIOCFG_SLP_DO_MASK) | (((uint32_t)val) << IO_PAD118_PIOCFG_SLP_DO_SHIFT))

#define  IO_PAD118_PIOCFG_SLP_DIR_MASK 0x80
#define  IO_PAD118_PIOCFG_SLP_DIR_SHIFT 7
#define  IO_PAD118_PIOCFG_SLP_DIR_MASK_SHIFT(reg) (((reg) & IO_PAD118_PIOCFG_SLP_DIR_MASK) >> IO_PAD118_PIOCFG_SLP_DIR_SHIFT)
#define  IO_PAD118_PIOCFG_SLP_DIR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD118_PIOCFG_SLP_DIR_MASK) | (((uint32_t)val) << IO_PAD118_PIOCFG_SLP_DIR_SHIFT))

#define  IO_PAD118_PIOCFG_EDGE_EN_N_MASK 0x40
#define  IO_PAD118_PIOCFG_EDGE_EN_N_SHIFT 6
#define  IO_PAD118_PIOCFG_EDGE_EN_N_MASK_SHIFT(reg) (((reg) & IO_PAD118_PIOCFG_EDGE_EN_N_MASK) >> IO_PAD118_PIOCFG_EDGE_EN_N_SHIFT)
#define  IO_PAD118_PIOCFG_EDGE_EN_N_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD118_PIOCFG_EDGE_EN_N_MASK) | (((uint32_t)val) << IO_PAD118_PIOCFG_EDGE_EN_N_SHIFT))

#define  IO_PAD118_PIOCFG_EDGE_FALL_EN_MASK 0x20
#define  IO_PAD118_PIOCFG_EDGE_FALL_EN_SHIFT 5
#define  IO_PAD118_PIOCFG_EDGE_FALL_EN_MASK_SHIFT(reg) (((reg) & IO_PAD118_PIOCFG_EDGE_FALL_EN_MASK) >> IO_PAD118_PIOCFG_EDGE_FALL_EN_SHIFT)
#define  IO_PAD118_PIOCFG_EDGE_FALL_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD118_PIOCFG_EDGE_FALL_EN_MASK) | (((uint32_t)val) << IO_PAD118_PIOCFG_EDGE_FALL_EN_SHIFT))

#define  IO_PAD118_PIOCFG_EDGE_RISE_EN_MASK 0x10
#define  IO_PAD118_PIOCFG_EDGE_RISE_EN_SHIFT 4
#define  IO_PAD118_PIOCFG_EDGE_RISE_EN_MASK_SHIFT(reg) (((reg) & IO_PAD118_PIOCFG_EDGE_RISE_EN_MASK) >> IO_PAD118_PIOCFG_EDGE_RISE_EN_SHIFT)
#define  IO_PAD118_PIOCFG_EDGE_RISE_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD118_PIOCFG_EDGE_RISE_EN_MASK) | (((uint32_t)val) << IO_PAD118_PIOCFG_EDGE_RISE_EN_SHIFT))

#define  IO_PAD118_PIOCFG_SLP_SEL_MASK 0x8
#define  IO_PAD118_PIOCFG_SLP_SEL_SHIFT 3
#define  IO_PAD118_PIOCFG_SLP_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD118_PIOCFG_SLP_SEL_MASK) >> IO_PAD118_PIOCFG_SLP_SEL_SHIFT)
#define  IO_PAD118_PIOCFG_SLP_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD118_PIOCFG_SLP_SEL_MASK) | (((uint32_t)val) << IO_PAD118_PIOCFG_SLP_SEL_SHIFT))

#define  IO_PAD118_PIOCFG_FUNC_SEL_MASK 0x7
#define  IO_PAD118_PIOCFG_FUNC_SEL_SHIFT 0
#define  IO_PAD118_PIOCFG_FUNC_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD118_PIOCFG_FUNC_SEL_MASK) >> IO_PAD118_PIOCFG_FUNC_SEL_SHIFT)
#define  IO_PAD118_PIOCFG_FUNC_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD118_PIOCFG_FUNC_SEL_MASK) | (((uint32_t)val) << IO_PAD118_PIOCFG_FUNC_SEL_SHIFT))

//====================================================================
//
//Register File: IO_PAD119 Configuration Registers (IO_PAD119)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

//====================================================================
//Register: IO_PAD119 Configuration Register (PIOCFG)
/** \brief "PHI_PADXDC_HSIOB" Pad*/
//====================================================================

#define  IO_PAD119_PIOCFG_RESERVED1_MASK 0xfc000000
#define  IO_PAD119_PIOCFG_RESERVED1_SHIFT 26
#define  IO_PAD119_PIOCFG_RESERVED1_MASK_SHIFT(reg) (((reg) & IO_PAD119_PIOCFG_RESERVED1_MASK) >> IO_PAD119_PIOCFG_RESERVED1_SHIFT)
#define  IO_PAD119_PIOCFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD119_PIOCFG_RESERVED1_MASK) | (((uint32_t)val) << IO_PAD119_PIOCFG_RESERVED1_SHIFT))

#define  IO_PAD119_PIOCFG_PD_MASK 0x2000000
#define  IO_PAD119_PIOCFG_PD_SHIFT 25
#define  IO_PAD119_PIOCFG_PD_MASK_SHIFT(reg) (((reg) & IO_PAD119_PIOCFG_PD_MASK) >> IO_PAD119_PIOCFG_PD_SHIFT)
#define  IO_PAD119_PIOCFG_PD_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD119_PIOCFG_PD_MASK) | (((uint32_t)val) << IO_PAD119_PIOCFG_PD_SHIFT))

#define  IO_PAD119_PIOCFG_ODT_EN_MASK 0x1000000
#define  IO_PAD119_PIOCFG_ODT_EN_SHIFT 24
#define  IO_PAD119_PIOCFG_ODT_EN_MASK_SHIFT(reg) (((reg) & IO_PAD119_PIOCFG_ODT_EN_MASK) >> IO_PAD119_PIOCFG_ODT_EN_SHIFT)
#define  IO_PAD119_PIOCFG_ODT_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD119_PIOCFG_ODT_EN_MASK) | (((uint32_t)val) << IO_PAD119_PIOCFG_ODT_EN_SHIFT))

#define  IO_PAD119_PIOCFG_LED_EN_MASK 0x800000
#define  IO_PAD119_PIOCFG_LED_EN_SHIFT 23
#define  IO_PAD119_PIOCFG_LED_EN_MASK_SHIFT(reg) (((reg) & IO_PAD119_PIOCFG_LED_EN_MASK) >> IO_PAD119_PIOCFG_LED_EN_SHIFT)
#define  IO_PAD119_PIOCFG_LED_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD119_PIOCFG_LED_EN_MASK) | (((uint32_t)val) << IO_PAD119_PIOCFG_LED_EN_SHIFT))

#define  IO_PAD119_PIOCFG_I2C_SEL_MASK 0x600000
#define  IO_PAD119_PIOCFG_I2C_SEL_SHIFT 21
#define  IO_PAD119_PIOCFG_I2C_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD119_PIOCFG_I2C_SEL_MASK) >> IO_PAD119_PIOCFG_I2C_SEL_SHIFT)
#define  IO_PAD119_PIOCFG_I2C_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD119_PIOCFG_I2C_SEL_MASK) | (((uint32_t)val) << IO_PAD119_PIOCFG_I2C_SEL_SHIFT))

#define  IO_PAD119_PIOCFG_DGTBSEL_MASK 0x1e0000
#define  IO_PAD119_PIOCFG_DGTBSEL_SHIFT 17
#define  IO_PAD119_PIOCFG_DGTBSEL_MASK_SHIFT(reg) (((reg) & IO_PAD119_PIOCFG_DGTBSEL_MASK) >> IO_PAD119_PIOCFG_DGTBSEL_SHIFT)
#define  IO_PAD119_PIOCFG_DGTBSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD119_PIOCFG_DGTBSEL_MASK) | (((uint32_t)val) << IO_PAD119_PIOCFG_DGTBSEL_SHIFT))

#define  IO_PAD119_PIOCFG_RAWSEL_MASK 0x10000
#define  IO_PAD119_PIOCFG_RAWSEL_SHIFT 16
#define  IO_PAD119_PIOCFG_RAWSEL_MASK_SHIFT(reg) (((reg) & IO_PAD119_PIOCFG_RAWSEL_MASK) >> IO_PAD119_PIOCFG_RAWSEL_SHIFT)
#define  IO_PAD119_PIOCFG_RAWSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD119_PIOCFG_RAWSEL_MASK) | (((uint32_t)val) << IO_PAD119_PIOCFG_RAWSEL_SHIFT))

#define  IO_PAD119_PIOCFG_PULL_SEL_MASK 0x8000
#define  IO_PAD119_PIOCFG_PULL_SEL_SHIFT 15
#define  IO_PAD119_PIOCFG_PULL_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD119_PIOCFG_PULL_SEL_MASK) >> IO_PAD119_PIOCFG_PULL_SEL_SHIFT)
#define  IO_PAD119_PIOCFG_PULL_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD119_PIOCFG_PULL_SEL_MASK) | (((uint32_t)val) << IO_PAD119_PIOCFG_PULL_SEL_SHIFT))

#define  IO_PAD119_PIOCFG_PUEN_MASK 0x4000
#define  IO_PAD119_PIOCFG_PUEN_SHIFT 14
#define  IO_PAD119_PIOCFG_PUEN_MASK_SHIFT(reg) (((reg) & IO_PAD119_PIOCFG_PUEN_MASK) >> IO_PAD119_PIOCFG_PUEN_SHIFT)
#define  IO_PAD119_PIOCFG_PUEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD119_PIOCFG_PUEN_MASK) | (((uint32_t)val) << IO_PAD119_PIOCFG_PUEN_SHIFT))

#define  IO_PAD119_PIOCFG_PDEN_MASK 0x2000
#define  IO_PAD119_PIOCFG_PDEN_SHIFT 13
#define  IO_PAD119_PIOCFG_PDEN_MASK_SHIFT(reg) (((reg) & IO_PAD119_PIOCFG_PDEN_MASK) >> IO_PAD119_PIOCFG_PDEN_SHIFT)
#define  IO_PAD119_PIOCFG_PDEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD119_PIOCFG_PDEN_MASK) | (((uint32_t)val) << IO_PAD119_PIOCFG_PDEN_SHIFT))

#define  IO_PAD119_PIOCFG_SR_MASK 0x1800
#define  IO_PAD119_PIOCFG_SR_SHIFT 11
#define  IO_PAD119_PIOCFG_SR_MASK_SHIFT(reg) (((reg) & IO_PAD119_PIOCFG_SR_MASK) >> IO_PAD119_PIOCFG_SR_SHIFT)
#define  IO_PAD119_PIOCFG_SR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD119_PIOCFG_SR_MASK) | (((uint32_t)val) << IO_PAD119_PIOCFG_SR_SHIFT))

#define  IO_PAD119_PIOCFG_SLP_DI_MASK 0x400
#define  IO_PAD119_PIOCFG_SLP_DI_SHIFT 10
#define  IO_PAD119_PIOCFG_SLP_DI_MASK_SHIFT(reg) (((reg) & IO_PAD119_PIOCFG_SLP_DI_MASK) >> IO_PAD119_PIOCFG_SLP_DI_SHIFT)
#define  IO_PAD119_PIOCFG_SLP_DI_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD119_PIOCFG_SLP_DI_MASK) | (((uint32_t)val) << IO_PAD119_PIOCFG_SLP_DI_SHIFT))

#define  IO_PAD119_PIOCFG_SLP_CNTRL_MASK 0x200
#define  IO_PAD119_PIOCFG_SLP_CNTRL_SHIFT 9
#define  IO_PAD119_PIOCFG_SLP_CNTRL_MASK_SHIFT(reg) (((reg) & IO_PAD119_PIOCFG_SLP_CNTRL_MASK) >> IO_PAD119_PIOCFG_SLP_CNTRL_SHIFT)
#define  IO_PAD119_PIOCFG_SLP_CNTRL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD119_PIOCFG_SLP_CNTRL_MASK) | (((uint32_t)val) << IO_PAD119_PIOCFG_SLP_CNTRL_SHIFT))

#define  IO_PAD119_PIOCFG_SLP_DO_MASK 0x100
#define  IO_PAD119_PIOCFG_SLP_DO_SHIFT 8
#define  IO_PAD119_PIOCFG_SLP_DO_MASK_SHIFT(reg) (((reg) & IO_PAD119_PIOCFG_SLP_DO_MASK) >> IO_PAD119_PIOCFG_SLP_DO_SHIFT)
#define  IO_PAD119_PIOCFG_SLP_DO_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD119_PIOCFG_SLP_DO_MASK) | (((uint32_t)val) << IO_PAD119_PIOCFG_SLP_DO_SHIFT))

#define  IO_PAD119_PIOCFG_SLP_DIR_MASK 0x80
#define  IO_PAD119_PIOCFG_SLP_DIR_SHIFT 7
#define  IO_PAD119_PIOCFG_SLP_DIR_MASK_SHIFT(reg) (((reg) & IO_PAD119_PIOCFG_SLP_DIR_MASK) >> IO_PAD119_PIOCFG_SLP_DIR_SHIFT)
#define  IO_PAD119_PIOCFG_SLP_DIR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD119_PIOCFG_SLP_DIR_MASK) | (((uint32_t)val) << IO_PAD119_PIOCFG_SLP_DIR_SHIFT))

#define  IO_PAD119_PIOCFG_EDGE_EN_N_MASK 0x40
#define  IO_PAD119_PIOCFG_EDGE_EN_N_SHIFT 6
#define  IO_PAD119_PIOCFG_EDGE_EN_N_MASK_SHIFT(reg) (((reg) & IO_PAD119_PIOCFG_EDGE_EN_N_MASK) >> IO_PAD119_PIOCFG_EDGE_EN_N_SHIFT)
#define  IO_PAD119_PIOCFG_EDGE_EN_N_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD119_PIOCFG_EDGE_EN_N_MASK) | (((uint32_t)val) << IO_PAD119_PIOCFG_EDGE_EN_N_SHIFT))

#define  IO_PAD119_PIOCFG_EDGE_FALL_EN_MASK 0x20
#define  IO_PAD119_PIOCFG_EDGE_FALL_EN_SHIFT 5
#define  IO_PAD119_PIOCFG_EDGE_FALL_EN_MASK_SHIFT(reg) (((reg) & IO_PAD119_PIOCFG_EDGE_FALL_EN_MASK) >> IO_PAD119_PIOCFG_EDGE_FALL_EN_SHIFT)
#define  IO_PAD119_PIOCFG_EDGE_FALL_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD119_PIOCFG_EDGE_FALL_EN_MASK) | (((uint32_t)val) << IO_PAD119_PIOCFG_EDGE_FALL_EN_SHIFT))

#define  IO_PAD119_PIOCFG_EDGE_RISE_EN_MASK 0x10
#define  IO_PAD119_PIOCFG_EDGE_RISE_EN_SHIFT 4
#define  IO_PAD119_PIOCFG_EDGE_RISE_EN_MASK_SHIFT(reg) (((reg) & IO_PAD119_PIOCFG_EDGE_RISE_EN_MASK) >> IO_PAD119_PIOCFG_EDGE_RISE_EN_SHIFT)
#define  IO_PAD119_PIOCFG_EDGE_RISE_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD119_PIOCFG_EDGE_RISE_EN_MASK) | (((uint32_t)val) << IO_PAD119_PIOCFG_EDGE_RISE_EN_SHIFT))

#define  IO_PAD119_PIOCFG_SLP_SEL_MASK 0x8
#define  IO_PAD119_PIOCFG_SLP_SEL_SHIFT 3
#define  IO_PAD119_PIOCFG_SLP_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD119_PIOCFG_SLP_SEL_MASK) >> IO_PAD119_PIOCFG_SLP_SEL_SHIFT)
#define  IO_PAD119_PIOCFG_SLP_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD119_PIOCFG_SLP_SEL_MASK) | (((uint32_t)val) << IO_PAD119_PIOCFG_SLP_SEL_SHIFT))

#define  IO_PAD119_PIOCFG_FUNC_SEL_MASK 0x7
#define  IO_PAD119_PIOCFG_FUNC_SEL_SHIFT 0
#define  IO_PAD119_PIOCFG_FUNC_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD119_PIOCFG_FUNC_SEL_MASK) >> IO_PAD119_PIOCFG_FUNC_SEL_SHIFT)
#define  IO_PAD119_PIOCFG_FUNC_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD119_PIOCFG_FUNC_SEL_MASK) | (((uint32_t)val) << IO_PAD119_PIOCFG_FUNC_SEL_SHIFT))

//====================================================================
//
//Register File: IO_PAD120 Configuration Registers (IO_PAD120)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

//====================================================================
//Register: IO_PAD120 Configuration Register (PIOCFG)
/** \brief "PHI_PADXDC_HSIOB" Pad*/
//====================================================================

#define  IO_PAD120_PIOCFG_RESERVED1_MASK 0xfc000000
#define  IO_PAD120_PIOCFG_RESERVED1_SHIFT 26
#define  IO_PAD120_PIOCFG_RESERVED1_MASK_SHIFT(reg) (((reg) & IO_PAD120_PIOCFG_RESERVED1_MASK) >> IO_PAD120_PIOCFG_RESERVED1_SHIFT)
#define  IO_PAD120_PIOCFG_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD120_PIOCFG_RESERVED1_MASK) | (((uint32_t)val) << IO_PAD120_PIOCFG_RESERVED1_SHIFT))

#define  IO_PAD120_PIOCFG_PD_MASK 0x2000000
#define  IO_PAD120_PIOCFG_PD_SHIFT 25
#define  IO_PAD120_PIOCFG_PD_MASK_SHIFT(reg) (((reg) & IO_PAD120_PIOCFG_PD_MASK) >> IO_PAD120_PIOCFG_PD_SHIFT)
#define  IO_PAD120_PIOCFG_PD_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD120_PIOCFG_PD_MASK) | (((uint32_t)val) << IO_PAD120_PIOCFG_PD_SHIFT))

#define  IO_PAD120_PIOCFG_ODT_EN_MASK 0x1000000
#define  IO_PAD120_PIOCFG_ODT_EN_SHIFT 24
#define  IO_PAD120_PIOCFG_ODT_EN_MASK_SHIFT(reg) (((reg) & IO_PAD120_PIOCFG_ODT_EN_MASK) >> IO_PAD120_PIOCFG_ODT_EN_SHIFT)
#define  IO_PAD120_PIOCFG_ODT_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD120_PIOCFG_ODT_EN_MASK) | (((uint32_t)val) << IO_PAD120_PIOCFG_ODT_EN_SHIFT))

#define  IO_PAD120_PIOCFG_LED_EN_MASK 0x800000
#define  IO_PAD120_PIOCFG_LED_EN_SHIFT 23
#define  IO_PAD120_PIOCFG_LED_EN_MASK_SHIFT(reg) (((reg) & IO_PAD120_PIOCFG_LED_EN_MASK) >> IO_PAD120_PIOCFG_LED_EN_SHIFT)
#define  IO_PAD120_PIOCFG_LED_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD120_PIOCFG_LED_EN_MASK) | (((uint32_t)val) << IO_PAD120_PIOCFG_LED_EN_SHIFT))

#define  IO_PAD120_PIOCFG_I2C_SEL_MASK 0x600000
#define  IO_PAD120_PIOCFG_I2C_SEL_SHIFT 21
#define  IO_PAD120_PIOCFG_I2C_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD120_PIOCFG_I2C_SEL_MASK) >> IO_PAD120_PIOCFG_I2C_SEL_SHIFT)
#define  IO_PAD120_PIOCFG_I2C_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD120_PIOCFG_I2C_SEL_MASK) | (((uint32_t)val) << IO_PAD120_PIOCFG_I2C_SEL_SHIFT))

#define  IO_PAD120_PIOCFG_DGTBSEL_MASK 0x1e0000
#define  IO_PAD120_PIOCFG_DGTBSEL_SHIFT 17
#define  IO_PAD120_PIOCFG_DGTBSEL_MASK_SHIFT(reg) (((reg) & IO_PAD120_PIOCFG_DGTBSEL_MASK) >> IO_PAD120_PIOCFG_DGTBSEL_SHIFT)
#define  IO_PAD120_PIOCFG_DGTBSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD120_PIOCFG_DGTBSEL_MASK) | (((uint32_t)val) << IO_PAD120_PIOCFG_DGTBSEL_SHIFT))

#define  IO_PAD120_PIOCFG_RAWSEL_MASK 0x10000
#define  IO_PAD120_PIOCFG_RAWSEL_SHIFT 16
#define  IO_PAD120_PIOCFG_RAWSEL_MASK_SHIFT(reg) (((reg) & IO_PAD120_PIOCFG_RAWSEL_MASK) >> IO_PAD120_PIOCFG_RAWSEL_SHIFT)
#define  IO_PAD120_PIOCFG_RAWSEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD120_PIOCFG_RAWSEL_MASK) | (((uint32_t)val) << IO_PAD120_PIOCFG_RAWSEL_SHIFT))

#define  IO_PAD120_PIOCFG_PULL_SEL_MASK 0x8000
#define  IO_PAD120_PIOCFG_PULL_SEL_SHIFT 15
#define  IO_PAD120_PIOCFG_PULL_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD120_PIOCFG_PULL_SEL_MASK) >> IO_PAD120_PIOCFG_PULL_SEL_SHIFT)
#define  IO_PAD120_PIOCFG_PULL_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD120_PIOCFG_PULL_SEL_MASK) | (((uint32_t)val) << IO_PAD120_PIOCFG_PULL_SEL_SHIFT))

#define  IO_PAD120_PIOCFG_PUEN_MASK 0x4000
#define  IO_PAD120_PIOCFG_PUEN_SHIFT 14
#define  IO_PAD120_PIOCFG_PUEN_MASK_SHIFT(reg) (((reg) & IO_PAD120_PIOCFG_PUEN_MASK) >> IO_PAD120_PIOCFG_PUEN_SHIFT)
#define  IO_PAD120_PIOCFG_PUEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD120_PIOCFG_PUEN_MASK) | (((uint32_t)val) << IO_PAD120_PIOCFG_PUEN_SHIFT))

#define  IO_PAD120_PIOCFG_PDEN_MASK 0x2000
#define  IO_PAD120_PIOCFG_PDEN_SHIFT 13
#define  IO_PAD120_PIOCFG_PDEN_MASK_SHIFT(reg) (((reg) & IO_PAD120_PIOCFG_PDEN_MASK) >> IO_PAD120_PIOCFG_PDEN_SHIFT)
#define  IO_PAD120_PIOCFG_PDEN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD120_PIOCFG_PDEN_MASK) | (((uint32_t)val) << IO_PAD120_PIOCFG_PDEN_SHIFT))

#define  IO_PAD120_PIOCFG_SR_MASK 0x1800
#define  IO_PAD120_PIOCFG_SR_SHIFT 11
#define  IO_PAD120_PIOCFG_SR_MASK_SHIFT(reg) (((reg) & IO_PAD120_PIOCFG_SR_MASK) >> IO_PAD120_PIOCFG_SR_SHIFT)
#define  IO_PAD120_PIOCFG_SR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD120_PIOCFG_SR_MASK) | (((uint32_t)val) << IO_PAD120_PIOCFG_SR_SHIFT))

#define  IO_PAD120_PIOCFG_SLP_DI_MASK 0x400
#define  IO_PAD120_PIOCFG_SLP_DI_SHIFT 10
#define  IO_PAD120_PIOCFG_SLP_DI_MASK_SHIFT(reg) (((reg) & IO_PAD120_PIOCFG_SLP_DI_MASK) >> IO_PAD120_PIOCFG_SLP_DI_SHIFT)
#define  IO_PAD120_PIOCFG_SLP_DI_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD120_PIOCFG_SLP_DI_MASK) | (((uint32_t)val) << IO_PAD120_PIOCFG_SLP_DI_SHIFT))

#define  IO_PAD120_PIOCFG_SLP_CNTRL_MASK 0x200
#define  IO_PAD120_PIOCFG_SLP_CNTRL_SHIFT 9
#define  IO_PAD120_PIOCFG_SLP_CNTRL_MASK_SHIFT(reg) (((reg) & IO_PAD120_PIOCFG_SLP_CNTRL_MASK) >> IO_PAD120_PIOCFG_SLP_CNTRL_SHIFT)
#define  IO_PAD120_PIOCFG_SLP_CNTRL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD120_PIOCFG_SLP_CNTRL_MASK) | (((uint32_t)val) << IO_PAD120_PIOCFG_SLP_CNTRL_SHIFT))

#define  IO_PAD120_PIOCFG_SLP_DO_MASK 0x100
#define  IO_PAD120_PIOCFG_SLP_DO_SHIFT 8
#define  IO_PAD120_PIOCFG_SLP_DO_MASK_SHIFT(reg) (((reg) & IO_PAD120_PIOCFG_SLP_DO_MASK) >> IO_PAD120_PIOCFG_SLP_DO_SHIFT)
#define  IO_PAD120_PIOCFG_SLP_DO_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD120_PIOCFG_SLP_DO_MASK) | (((uint32_t)val) << IO_PAD120_PIOCFG_SLP_DO_SHIFT))

#define  IO_PAD120_PIOCFG_SLP_DIR_MASK 0x80
#define  IO_PAD120_PIOCFG_SLP_DIR_SHIFT 7
#define  IO_PAD120_PIOCFG_SLP_DIR_MASK_SHIFT(reg) (((reg) & IO_PAD120_PIOCFG_SLP_DIR_MASK) >> IO_PAD120_PIOCFG_SLP_DIR_SHIFT)
#define  IO_PAD120_PIOCFG_SLP_DIR_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD120_PIOCFG_SLP_DIR_MASK) | (((uint32_t)val) << IO_PAD120_PIOCFG_SLP_DIR_SHIFT))

#define  IO_PAD120_PIOCFG_EDGE_EN_N_MASK 0x40
#define  IO_PAD120_PIOCFG_EDGE_EN_N_SHIFT 6
#define  IO_PAD120_PIOCFG_EDGE_EN_N_MASK_SHIFT(reg) (((reg) & IO_PAD120_PIOCFG_EDGE_EN_N_MASK) >> IO_PAD120_PIOCFG_EDGE_EN_N_SHIFT)
#define  IO_PAD120_PIOCFG_EDGE_EN_N_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD120_PIOCFG_EDGE_EN_N_MASK) | (((uint32_t)val) << IO_PAD120_PIOCFG_EDGE_EN_N_SHIFT))

#define  IO_PAD120_PIOCFG_EDGE_FALL_EN_MASK 0x20
#define  IO_PAD120_PIOCFG_EDGE_FALL_EN_SHIFT 5
#define  IO_PAD120_PIOCFG_EDGE_FALL_EN_MASK_SHIFT(reg) (((reg) & IO_PAD120_PIOCFG_EDGE_FALL_EN_MASK) >> IO_PAD120_PIOCFG_EDGE_FALL_EN_SHIFT)
#define  IO_PAD120_PIOCFG_EDGE_FALL_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD120_PIOCFG_EDGE_FALL_EN_MASK) | (((uint32_t)val) << IO_PAD120_PIOCFG_EDGE_FALL_EN_SHIFT))

#define  IO_PAD120_PIOCFG_EDGE_RISE_EN_MASK 0x10
#define  IO_PAD120_PIOCFG_EDGE_RISE_EN_SHIFT 4
#define  IO_PAD120_PIOCFG_EDGE_RISE_EN_MASK_SHIFT(reg) (((reg) & IO_PAD120_PIOCFG_EDGE_RISE_EN_MASK) >> IO_PAD120_PIOCFG_EDGE_RISE_EN_SHIFT)
#define  IO_PAD120_PIOCFG_EDGE_RISE_EN_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD120_PIOCFG_EDGE_RISE_EN_MASK) | (((uint32_t)val) << IO_PAD120_PIOCFG_EDGE_RISE_EN_SHIFT))

#define  IO_PAD120_PIOCFG_SLP_SEL_MASK 0x8
#define  IO_PAD120_PIOCFG_SLP_SEL_SHIFT 3
#define  IO_PAD120_PIOCFG_SLP_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD120_PIOCFG_SLP_SEL_MASK) >> IO_PAD120_PIOCFG_SLP_SEL_SHIFT)
#define  IO_PAD120_PIOCFG_SLP_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD120_PIOCFG_SLP_SEL_MASK) | (((uint32_t)val) << IO_PAD120_PIOCFG_SLP_SEL_SHIFT))

#define  IO_PAD120_PIOCFG_FUNC_SEL_MASK 0x7
#define  IO_PAD120_PIOCFG_FUNC_SEL_SHIFT 0
#define  IO_PAD120_PIOCFG_FUNC_SEL_MASK_SHIFT(reg) (((reg) & IO_PAD120_PIOCFG_FUNC_SEL_MASK) >> IO_PAD120_PIOCFG_FUNC_SEL_SHIFT)
#define  IO_PAD120_PIOCFG_FUNC_SEL_REPLACE_VAL(reg,val) (((reg) & ~IO_PAD120_PIOCFG_FUNC_SEL_MASK) | (((uint32_t)val) << IO_PAD120_PIOCFG_FUNC_SEL_SHIFT))

//====================================================================
//
//Register File: IO_PAD121 Configuration Registers (IO_PAD121)
/** \brief Top-level register file for MFPI*/
//
//====================================================================

//====================================================================
//Register: IO_PAD121 Configuration Register (PIOCFG)
/** \brief "PHI_PADXDC_HSIOB" Pad*/
//=====================================================