 /*
 **************************************************************************************
 *
 * (c) Copyright 2013 Marvell International Ltd.
 *
 *
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/.
 *
 **************************************************************************************
 *
 * \file GIC400_regstructs.h
 * Generated using RegBuild 1.6.3
 *
 **************************************************************************************
 */

#ifndef _GIC400_CORE_REGSTRUCTS_H_
#define _GIC400_CORE_REGSTRUCTS_H_

#ifndef __KERNEL__
#include <stdint.h>
#endif

//====================================================================
//
//Register File: GIC 400 Core Registers (GIC400_Core)
//
//====================================================================

//====================================================================
//
//Register File: GIC400 Distrubutor Registers (GICD)
/** \brief These registers provide control/status for the power islands, SRAMs, and other miscellaneous
    power related functions in the AP section of the chip.*/
//
//====================================================================

typedef struct GICD_REGS_s
{
  volatile uint32_t CTRL;  ///< 0x0 [R/W]: GIC400 Distrubutor Control Register
  volatile uint32_t TYPER;  ///< 0x4 [R]: GIC400 Interrupt Controller Type Register
  volatile uint32_t IIDR;  ///< 0x8 [R]: GIC400 Distrubutor Implementer ID Register
  volatile uint32_t reserved0[29];
  volatile uint32_t IGROUP0;  ///< 0x80 [R/W]: GIC400 Distrubutor Group Control Register (Instance 1 of 8)
  volatile uint32_t IGROUP1;  ///< 0x84 [R/W]: GIC400 Distrubutor Group Control Register (Instance 2 of 8)
  volatile uint32_t IGROUP2;  ///< 0x88 [R/W]: GIC400 Distrubutor Group Control Register (Instance 3 of 8)
  volatile uint32_t IGROUP3;  ///< 0x8c [R/W]: GIC400 Distrubutor Group Control Register (Instance 4 of 8)
  volatile uint32_t IGROUP4;  ///< 0x90 [R/W]: GIC400 Distrubutor Group Control Register (Instance 5 of 8)
  volatile uint32_t IGROUP5;  ///< 0x94 [R/W]: GIC400 Distrubutor Group Control Register (Instance 6 of 8)
  volatile uint32_t IGROUP6;  ///< 0x98 [R/W]: GIC400 Distrubutor Group Control Register (Instance 7 of 8)
  volatile uint32_t IGROUP7;  ///< 0x9c [R/W]: GIC400 Distrubutor Group Control Register (Instance 8 of 8)
  volatile uint32_t reserved1[24];
  volatile uint32_t ISENABLE0;  ///< 0x100 [R/W]: GIC400 Distrubutor Interrupt Set-Enable Register (Instance 1 of 8)
  volatile uint32_t ISENABLE1;  ///< 0x104 [R/W]: GIC400 Distrubutor Interrupt Set-Enable Register (Instance 2 of 8)
  volatile uint32_t ISENABLE2;  ///< 0x108 [R/W]: GIC400 Distrubutor Interrupt Set-Enable Register (Instance 3 of 8)
  volatile uint32_t ISENABLE3;  ///< 0x10c [R/W]: GIC400 Distrubutor Interrupt Set-Enable Register (Instance 4 of 8)
  volatile uint32_t ISENABLE4;  ///< 0x110 [R/W]: GIC400 Distrubutor Interrupt Set-Enable Register (Instance 5 of 8)
  volatile uint32_t ISENABLE5;  ///< 0x114 [R/W]: GIC400 Distrubutor Interrupt Set-Enable Register (Instance 6 of 8)
  volatile uint32_t ISENABLE6;  ///< 0x118 [R/W]: GIC400 Distrubutor Interrupt Set-Enable Register (Instance 7 of 8)
  volatile uint32_t ISENABLE7;  ///< 0x11c [R/W]: GIC400 Distrubutor Interrupt Set-Enable Register (Instance 8 of 8)
  volatile uint32_t reserved2[24];
  volatile uint32_t ICENABLE0;  ///< 0x180 [R/W]: GIC400 Distrubutor Interrupt Clear-Enable Register (Instance 1 of 8)
  volatile uint32_t ICENABLE1;  ///< 0x184 [R/W]: GIC400 Distrubutor Interrupt Clear-Enable Register (Instance 2 of 8)
  volatile uint32_t ICENABLE2;  ///< 0x188 [R/W]: GIC400 Distrubutor Interrupt Clear-Enable Register (Instance 3 of 8)
  volatile uint32_t ICENABLE3;  ///< 0x18c [R/W]: GIC400 Distrubutor Interrupt Clear-Enable Register (Instance 4 of 8)
  volatile uint32_t ICENABLE4;  ///< 0x190 [R/W]: GIC400 Distrubutor Interrupt Clear-Enable Register (Instance 5 of 8)
  volatile uint32_t ICENABLE5;  ///< 0x194 [R/W]: GIC400 Distrubutor Interrupt Clear-Enable Register (Instance 6 of 8)
  volatile uint32_t ICENABLE6;  ///< 0x198 [R/W]: GIC400 Distrubutor Interrupt Clear-Enable Register (Instance 7 of 8)
  volatile uint32_t ICENABLE7;  ///< 0x19c [R/W]: GIC400 Distrubutor Interrupt Clear-Enable Register (Instance 8 of 8)
  volatile uint32_t reserved3[24];
  volatile uint32_t ISPENDR0;  ///< 0x200 [R/W]: GIC400 Distrubutor Set Pending Register (Instance 1 of 8)
  volatile uint32_t ISPENDR1;  ///< 0x204 [R/W]: GIC400 Distrubutor Set Pending Register (Instance 2 of 8)
  volatile uint32_t ISPENDR2;  ///< 0x208 [R/W]: GIC400 Distrubutor Set Pending Register (Instance 3 of 8)
  volatile uint32_t ISPENDR3;  ///< 0x20c [R/W]: GIC400 Distrubutor Set Pending Register (Instance 4 of 8)
  volatile uint32_t ISPENDR4;  ///< 0x210 [R/W]: GIC400 Distrubutor Set Pending Register (Instance 5 of 8)
  volatile uint32_t ISPENDR5;  ///< 0x214 [R/W]: GIC400 Distrubutor Set Pending Register (Instance 6 of 8)
  volatile uint32_t ISPENDR6;  ///< 0x218 [R/W]: GIC400 Distrubutor Set Pending Register (Instance 7 of 8)
  volatile uint32_t ISPENDR7;  ///< 0x21c [R/W]: GIC400 Distrubutor Set Pending Register (Instance 8 of 8)
  volatile uint32_t reserved4[24];
  volatile uint32_t ICPENDR0;  ///< 0x280 [R/W]: GIC400 Distrubutor Clear Pending Register (Instance 1 of 8)
  volatile uint32_t ICPENDR1;  ///< 0x284 [R/W]: GIC400 Distrubutor Clear Pending Register (Instance 2 of 8)
  volatile uint32_t ICPENDR2;  ///< 0x288 [R/W]: GIC400 Distrubutor Clear Pending Register (Instance 3 of 8)
  volatile uint32_t ICPENDR3;  ///< 0x28c [R/W]: GIC400 Distrubutor Clear Pending Register (Instance 4 of 8)
  volatile uint32_t ICPENDR4;  ///< 0x290 [R/W]: GIC400 Distrubutor Clear Pending Register (Instance 5 of 8)
  volatile uint32_t ICPENDR5;  ///< 0x294 [R/W]: GIC400 Distrubutor Clear Pending Register (Instance 6 of 8)
  volatile uint32_t ICPENDR6;  ///< 0x298 [R/W]: GIC400 Distrubutor Clear Pending Register (Instance 7 of 8)
  volatile uint32_t ICPENDR7;  ///< 0x29c [R/W]: GIC400 Distrubutor Clear Pending Register (Instance 8 of 8)
  volatile uint32_t reserved5[24];
  volatile uint32_t ISACTIVE0;  ///< 0x300 [R/W]: GIC400 Distrubutor Set Active State Register (Instance 1 of 8)
  volatile uint32_t ISACTIVE1;  ///< 0x304 [R/W]: GIC400 Distrubutor Set Active State Register (Instance 2 of 8)
  volatile uint32_t ISACTIVE2;  ///< 0x308 [R/W]: GIC400 Distrubutor Set Active State Register (Instance 3 of 8)
  volatile uint32_t ISACTIVE3;  ///< 0x30c [R/W]: GIC400 Distrubutor Set Active State Register (Instance 4 of 8)
  volatile uint32_t ISACTIVE4;  ///< 0x310 [R/W]: GIC400 Distrubutor Set Active State Register (Instance 5 of 8)
  volatile uint32_t ISACTIVE5;  ///< 0x314 [R/W]: GIC400 Distrubutor Set Active State Register (Instance 6 of 8)
  volatile uint32_t ISACTIVE6;  ///< 0x318 [R/W]: GIC400 Distrubutor Set Active State Register (Instance 7 of 8)
  volatile uint32_t ISACTIVE7;  ///< 0x31c [R/W]: GIC400 Distrubutor Set Active State Register (Instance 8 of 8)
  volatile uint32_t reserved6[24];
  volatile uint32_t ICACTIVE0;  ///< 0x380 [R/W]: GIC400 Distrubutor Clear Active State Register (Instance 1 of 8)
  volatile uint32_t ICACTIVE1;  ///< 0x384 [R/W]: GIC400 Distrubutor Clear Active State Register (Instance 2 of 8)
  volatile uint32_t ICACTIVE2;  ///< 0x388 [R/W]: GIC400 Distrubutor Clear Active State Register (Instance 3 of 8)
  volatile uint32_t ICACTIVE3;  ///< 0x38c [R/W]: GIC400 Distrubutor Clear Active State Register (Instance 4 of 8)
  volatile uint32_t ICACTIVE4;  ///< 0x390 [R/W]: GIC400 Distrubutor Clear Active State Register (Instance 5 of 8)
  volatile uint32_t ICACTIVE5;  ///< 0x394 [R/W]: GIC400 Distrubutor Clear Active State Register (Instance 6 of 8)
  volatile uint32_t ICACTIVE6;  ///< 0x398 [R/W]: GIC400 Distrubutor Clear Active State Register (Instance 7 of 8)
  volatile uint32_t ICACTIVE7;  ///< 0x39c [R/W]: GIC400 Distrubutor Clear Active State Register (Instance 8 of 8)
  volatile uint32_t reserved7[24];
  volatile uint32_t IPRIORITY0;  ///< 0x400 [R/W]: GIC400 Distrubutor Set Active State Register (Instance 1 of 64)
  volatile uint32_t IPRIORITY1;  ///< 0x404 [R/W]: GIC400 Distrubutor Set Active State Register (Instance 2 of 64)
  volatile uint32_t IPRIORITY2;  ///< 0x408 [R/W]: GIC400 Distrubutor Set Active State Register (Instance 3 of 64)
  volatile uint32_t IPRIORITY3;  ///< 0x40c [R/W]: GIC400 Distrubutor Set Active State Register (Instance 4 of 64)
  volatile uint32_t IPRIORITY4;  ///< 0x410 [R/W]: GIC400 Distrubutor Set Active State Register (Instance 5 of 64)
  volatile uint32_t IPRIORITY5;  ///< 0x414 [R/W]: GIC400 Distrubutor Set Active State Register (Instance 6 of 64)
  volatile uint32_t IPRIORITY6;  ///< 0x418 [R/W]: GIC400 Distrubutor Set Active State Register (Instance 7 of 64)
  volatile uint32_t IPRIORITY7;  ///< 0x41c [R/W]: GIC400 Distrubutor Set Active State Register (Instance 8 of 64)
  volatile uint32_t IPRIORITY8;  ///< 0x420 [R/W]: GIC400 Distrubutor Set Active State Register (Instance 9 of 64)
  volatile uint32_t IPRIORITY9;  ///< 0x424 [R/W]: GIC400 Distrubutor Set Active State Register (Instance 10 of 64)
  volatile uint32_t IPRIORITY10;  ///< 0x428 [R/W]: GIC400 Distrubutor Set Active State Register (Instance 11 of 64)
  volatile uint32_t IPRIORITY11;  ///< 0x42c [R/W]: GIC400 Distrubutor Set Active State Register (Instance 12 of 64)
  volatile uint32_t IPRIORITY12;  ///< 0x430 [R/W]: GIC400 Distrubutor Set Active State Register (Instance 13 of 64)
  volatile uint32_t IPRIORITY13;  ///< 0x434 [R/W]: GIC400 Distrubutor Set Active State Register (Instance 14 of 64)
  volatile uint32_t IPRIORITY14;  ///< 0x438 [R/W]: GIC400 Distrubutor Set Active State Register (Instance 15 of 64)
  volatile uint32_t IPRIORITY15;  ///< 0x43c [R/W]: GIC400 Distrubutor Set Active State Register (Instance 16 of 64)
  volatile uint32_t IPRIORITY16;  ///< 0x440 [R/W]: GIC400 Distrubutor Set Active State Register (Instance 17 of 64)
  volatile uint32_t IPRIORITY17;  ///< 0x444 [R/W]: GIC400 Distrubutor Set Active State Register (Instance 18 of 64)
  volatile uint32_t IPRIORITY18;  ///< 0x448 [R/W]: GIC400 Distrubutor Set Active State Register (Instance 19 of 64)
  volatile uint32_t IPRIORITY19;  ///< 0x44c [R/W]: GIC400 Distrubutor Set Active State Register (Instance 20 of 64)
  volatile uint32_t IPRIORITY20;  ///< 0x450 [R/W]: GIC400 Distrubutor Set Active State Register (Instance 21 of 64)
  volatile uint32_t IPRIORITY21;  ///< 0x454 [R/W]: GIC400 Distrubutor Set Active State Register (Instance 22 of 64)
  volatile uint32_t IPRIORITY22;  ///< 0x458 [R/W]: GIC400 Distrubutor Set Active State Register (Instance 23 of 64)
  volatile uint32_t IPRIORITY23;  ///< 0x45c [R/W]: GIC400 Distrubutor Set Active State Register (Instance 24 of 64)
  volatile uint32_t IPRIORITY24;  ///< 0x460 [R/W]: GIC400 Distrubutor Set Active State Register (Instance 25 of 64)
  volatile uint32_t IPRIORITY25;  ///< 0x464 [R/W]: GIC400 Distrubutor Set Active State Register (Instance 26 of 64)
  volatile uint32_t IPRIORITY26;  ///< 0x468 [R/W]: GIC400 Distrubutor Set Active State Register (Instance 27 of 64)
  volatile uint32_t IPRIORITY27;  ///< 0x46c [R/W]: GIC400 Distrubutor Set Active State Register (Instance 28 of 64)
  volatile uint32_t IPRIORITY28;  ///< 0x470 [R/W]: GIC400 Distrubutor Set Active State Register (Instance 29 of 64)
  volatile uint32_t IPRIORITY29;  ///< 0x474 [R/W]: GIC400 Distrubutor Set Active State Register (Instance 30 of 64)
  volatile uint32_t IPRIORITY30;  ///< 0x478 [R/W]: GIC400 Distrubutor Set Active State Register (Instance 31 of 64)
  volatile uint32_t IPRIORITY31;  ///< 0x47c [R/W]: GIC400 Distrubutor Set Active State Register (Instance 32 of 64)
  volatile uint32_t IPRIORITY32;  ///< 0x480 [R/W]: GIC400 Distrubutor Set Active State Register (Instance 33 of 64)
  volatile uint32_t IPRIORITY33;  ///< 0x484 [R/W]: GIC400 Distrubutor Set Active State Register (Instance 34 of 64)
  volatile uint32_t IPRIORITY34;  ///< 0x488 [R/W]: GIC400 Distrubutor Set Active State Register (Instance 35 of 64)
  volatile uint32_t IPRIORITY35;  ///< 0x48c [R/W]: GIC400 Distrubutor Set Active State Register (Instance 36 of 64)
  volatile uint32_t IPRIORITY36;  ///< 0x490 [R/W]: GIC400 Distrubutor Set Active State Register (Instance 37 of 64)
  volatile uint32_t IPRIORITY37;  ///< 0x494 [R/W]: GIC400 Distrubutor Set Active State Register (Instance 38 of 64)
  volatile uint32_t IPRIORITY38;  ///< 0x498 [R/W]: GIC400 Distrubutor Set Active State Register (Instance 39 of 64)
  volatile uint32_t IPRIORITY39;  ///< 0x49c [R/W]: GIC400 Distrubutor Set Active State Register (Instance 40 of 64)
  volatile uint32_t IPRIORITY40;  ///< 0x4a0 [R/W]: GIC400 Distrubutor Set Active State Register (Instance 41 of 64)
  volatile uint32_t IPRIORITY41;  ///< 0x4a4 [R/W]: GIC400 Distrubutor Set Active State Register (Instance 42 of 64)
  volatile uint32_t IPRIORITY42;  ///< 0x4a8 [R/W]: GIC400 Distrubutor Set Active State Register (Instance 43 of 64)
  volatile uint32_t IPRIORITY43;  ///< 0x4ac [R/W]: GIC400 Distrubutor Set Active State Register (Instance 44 of 64)
  volatile uint32_t IPRIORITY44;  ///< 0x4b0 [R/W]: GIC400 Distrubutor Set Active State Register (Instance 45 of 64)
  volatile uint32_t IPRIORITY45;  ///< 0x4b4 [R/W]: GIC400 Distrubutor Set Active State Register (Instance 46 of 64)
  volatile uint32_t IPRIORITY46;  ///< 0x4b8 [R/W]: GIC400 Distrubutor Set Active State Register (Instance 47 of 64)
  volatile uint32_t IPRIORITY47;  ///< 0x4bc [R/W]: GIC400 Distrubutor Set Active State Register (Instance 48 of 64)
  volatile uint32_t IPRIORITY48;  ///< 0x4c0 [R/W]: GIC400 Distrubutor Set Active State Register (Instance 49 of 64)
  volatile uint32_t IPRIORITY49;  ///< 0x4c4 [R/W]: GIC400 Distrubutor Set Active State Register (Instance 50 of 64)
  volatile uint32_t IPRIORITY50;  ///< 0x4c8 [R/W]: GIC400 Distrubutor Set Active State Register (Instance 51 of 64)
  volatile uint32_t IPRIORITY51;  ///< 0x4cc [R/W]: GIC400 Distrubutor Set Active State Register (Instance 52 of 64)
  volatile uint32_t IPRIORITY52;  ///< 0x4d0 [R/W]: GIC400 Distrubutor Set Active State Register (Instance 53 of 64)
  volatile uint32_t IPRIORITY53;  ///< 0x4d4 [R/W]: GIC400 Distrubutor Set Active State Register (Instance 54 of 64)
  volatile uint32_t IPRIORITY54;  ///< 0x4d8 [R/W]: GIC400 Distrubutor Set Active State Register (Instance 55 of 64)
  volatile uint32_t IPRIORITY55;  ///< 0x4dc [R/W]: GIC400 Distrubutor Set Active State Register (Instance 56 of 64)
  volatile uint32_t IPRIORITY56;  ///< 0x4e0 [R/W]: GIC400 Distrubutor Set Active State Register (Instance 57 of 64)
  volatile uint32_t IPRIORITY57;  ///< 0x4e4 [R/W]: GIC400 Distrubutor Set Active State Register (Instance 58 of 64)
  volatile uint32_t IPRIORITY58;  ///< 0x4e8 [R/W]: GIC400 Distrubutor Set Active State Register (Instance 59 of 64)
  volatile uint32_t IPRIORITY59;  ///< 0x4ec [R/W]: GIC400 Distrubutor Set Active State Register (Instance 60 of 64)
  volatile uint32_t IPRIORITY60;  ///< 0x4f0 [R/W]: GIC400 Distrubutor Set Active State Register (Instance 61 of 64)
  volatile uint32_t IPRIORITY61;  ///< 0x4f4 [R/W]: GIC400 Distrubutor Set Active State Register (Instance 62 of 64)
  volatile uint32_t IPRIORITY62;  ///< 0x4f8 [R/W]: GIC400 Distrubutor Set Active State Register (Instance 63 of 64)
  volatile uint32_t IPRIORITY63;  ///< 0x4fc [R/W]: GIC400 Distrubutor Set Active State Register (Instance 64 of 64)
  volatile uint32_t reserved8[192];
  volatile uint32_t ITARGETS0;  ///< 0x800 [R/W]: GIC400 Interrupt Target Processor Register (Instance 1 of 64)
  volatile uint32_t ITARGETS1;  ///< 0x804 [R/W]: GIC400 Interrupt Target Processor Register (Instance 2 of 64)
  volatile uint32_t ITARGETS2;  ///< 0x808 [R/W]: GIC400 Interrupt Target Processor Register (Instance 3 of 64)
  volatile uint32_t ITARGETS3;  ///< 0x80c [R/W]: GIC400 Interrupt Target Processor Register (Instance 4 of 64)
  volatile uint32_t ITARGETS4;  ///< 0x810 [R/W]: GIC400 Interrupt Target Processor Register (Instance 5 of 64)
  volatile uint32_t ITARGETS5;  ///< 0x814 [R/W]: GIC400 Interrupt Target Processor Register (Instance 6 of 64)
  volatile uint32_t ITARGETS6;  ///< 0x818 [R/W]: GIC400 Interrupt Target Processor Register (Instance 7 of 64)
  volatile uint32_t ITARGETS7;  ///< 0x81c [R/W]: GIC400 Interrupt Target Processor Register (Instance 8 of 64)
  volatile uint32_t ITARGETS8;  ///< 0x820 [R/W]: GIC400 Interrupt Target Processor Register (Instance 9 of 64)
  volatile uint32_t ITARGETS9;  ///< 0x824 [R/W]: GIC400 Interrupt Target Processor Register (Instance 10 of 64)
  volatile uint32_t ITARGETS10;  ///< 0x828 [R/W]: GIC400 Interrupt Target Processor Register (Instance 11 of 64)
  volatile uint32_t ITARGETS11;  ///< 0x82c [R/W]: GIC400 Interrupt Target Processor Register (Instance 12 of 64)
  volatile uint32_t ITARGETS12;  ///< 0x830 [R/W]: GIC400 Interrupt Target Processor Register (Instance 13 of 64)
  volatile uint32_t ITARGETS13;  ///< 0x834 [R/W]: GIC400 Interrupt Target Processor Register (Instance 14 of 64)
  volatile uint32_t ITARGETS14;  ///< 0x838 [R/W]: GIC400 Interrupt Target Processor Register (Instance 15 of 64)
  volatile uint32_t ITARGETS15;  ///< 0x83c [R/W]: GIC400 Interrupt Target Processor Register (Instance 16 of 64)
  volatile uint32_t ITARGETS16;  ///< 0x840 [R/W]: GIC400 Interrupt Target Processor Register (Instance 17 of 64)
  volatile uint32_t ITARGETS17;  ///< 0x844 [R/W]: GIC400 Interrupt Target Processor Register (Instance 18 of 64)
  volatile uint32_t ITARGETS18;  ///< 0x848 [R/W]: GIC400 Interrupt Target Processor Register (Instance 19 of 64)
  volatile uint32_t ITARGETS19;  ///< 0x84c [R/W]: GIC400 Interrupt Target Processor Register (Instance 20 of 64)
  volatile uint32_t ITARGETS20;  ///< 0x850 [R/W]: GIC400 Interrupt Target Processor Register (Instance 21 of 64)
  volatile uint32_t ITARGETS21;  ///< 0x854 [R/W]: GIC400 Interrupt Target Processor Register (Instance 22 of 64)
  volatile uint32_t ITARGETS22;  ///< 0x858 [R/W]: GIC400 Interrupt Target Processor Register (Instance 23 of 64)
  volatile uint32_t ITARGETS23;  ///< 0x85c [R/W]: GIC400 Interrupt Target Processor Register (Instance 24 of 64)
  volatile uint32_t ITARGETS24;  ///< 0x860 [R/W]: GIC400 Interrupt Target Processor Register (Instance 25 of 64)
  volatile uint32_t ITARGETS25;  ///< 0x864 [R/W]: GIC400 Interrupt Target Processor Register (Instance 26 of 64)
  volatile uint32_t ITARGETS26;  ///< 0x868 [R/W]: GIC400 Interrupt Target Processor Register (Instance 27 of 64)
  volatile uint32_t ITARGETS27;  ///< 0x86c [R/W]: GIC400 Interrupt Target Processor Register (Instance 28 of 64)
  volatile uint32_t ITARGETS28;  ///< 0x870 [R/W]: GIC400 Interrupt Target Processor Register (Instance 29 of 64)
  volatile uint32_t ITARGETS29;  ///< 0x874 [R/W]: GIC400 Interrupt Target Processor Register (Instance 30 of 64)
  volatile uint32_t ITARGETS30;  ///< 0x878 [R/W]: GIC400 Interrupt Target Processor Register (Instance 31 of 64)
  volatile uint32_t ITARGETS31;  ///< 0x87c [R/W]: GIC400 Interrupt Target Processor Register (Instance 32 of 64)
  volatile uint32_t ITARGETS32;  ///< 0x880 [R/W]: GIC400 Interrupt Target Processor Register (Instance 33 of 64)
  volatile uint32_t ITARGETS33;  ///< 0x884 [R/W]: GIC400 Interrupt Target Processor Register (Instance 34 of 64)
  volatile uint32_t ITARGETS34;  ///< 0x888 [R/W]: GIC400 Interrupt Target Processor Register (Instance 35 of 64)
  volatile uint32_t ITARGETS35;  ///< 0x88c [R/W]: GIC400 Interrupt Target Processor Register (Instance 36 of 64)
  volatile uint32_t ITARGETS36;  ///< 0x890 [R/W]: GIC400 Interrupt Target Processor Register (Instance 37 of 64)
  volatile uint32_t ITARGETS37;  ///< 0x894 [R/W]: GIC400 Interrupt Target Processor Register (Instance 38 of 64)
  volatile uint32_t ITARGETS38;  ///< 0x898 [R/W]: GIC400 Interrupt Target Processor Register (Instance 39 of 64)
  volatile uint32_t ITARGETS39;  ///< 0x89c [R/W]: GIC400 Interrupt Target Processor Register (Instance 40 of 64)
  volatile uint32_t ITARGETS40;  ///< 0x8a0 [R/W]: GIC400 Interrupt Target Processor Register (Instance 41 of 64)
  volatile uint32_t ITARGETS41;  ///< 0x8a4 [R/W]: GIC400 Interrupt Target Processor Register (Instance 42 of 64)
  volatile uint32_t ITARGETS42;  ///< 0x8a8 [R/W]: GIC400 Interrupt Target Processor Register (Instance 43 of 64)
  volatile uint32_t ITARGETS43;  ///< 0x8ac [R/W]: GIC400 Interrupt Target Processor Register (Instance 44 of 64)
  volatile uint32_t ITARGETS44;  ///< 0x8b0 [R/W]: GIC400 Interrupt Target Processor Register (Instance 45 of 64)
  volatile uint32_t ITARGETS45;  ///< 0x8b4 [R/W]: GIC400 Interrupt Target Processor Register (Instance 46 of 64)
  volatile uint32_t ITARGETS46;  ///< 0x8b8 [R/W]: GIC400 Interrupt Target Processor Register (Instance 47 of 64)
  volatile uint32_t ITARGETS47;  ///< 0x8bc [R/W]: GIC400 Interrupt Target Processor Register (Instance 48 of 64)
  volatile uint32_t ITARGETS48;  ///< 0x8c0 [R/W]: GIC400 Interrupt Target Processor Register (Instance 49 of 64)
  volatile uint32_t ITARGETS49;  ///< 0x8c4 [R/W]: GIC400 Interrupt Target Processor Register (Instance 50 of 64)
  volatile uint32_t ITARGETS50;  ///< 0x8c8 [R/W]: GIC400 Interrupt Target Processor Register (Instance 51 of 64)
  volatile uint32_t ITARGETS51;  ///< 0x8cc [R/W]: GIC400 Interrupt Target Processor Register (Instance 52 of 64)
  volatile uint32_t ITARGETS52;  ///< 0x8d0 [R/W]: GIC400 Interrupt Target Processor Register (Instance 53 of 64)
  volatile uint32_t ITARGETS53;  ///< 0x8d4 [R/W]: GIC400 Interrupt Target Processor Register (Instance 54 of 64)
  volatile uint32_t ITARGETS54;  ///< 0x8d8 [R/W]: GIC400 Interrupt Target Processor Register (Instance 55 of 64)
  volatile uint32_t ITARGETS55;  ///< 0x8dc [R/W]: GIC400 Interrupt Target Processor Register (Instance 56 of 64)
  volatile uint32_t ITARGETS56;  ///< 0x8e0 [R/W]: GIC400 Interrupt Target Processor Register (Instance 57 of 64)
  volatile uint32_t ITARGETS57;  ///< 0x8e4 [R/W]: GIC400 Interrupt Target Processor Register (Instance 58 of 64)
  volatile uint32_t ITARGETS58;  ///< 0x8e8 [R/W]: GIC400 Interrupt Target Processor Register (Instance 59 of 64)
  volatile uint32_t ITARGETS59;  ///< 0x8ec [R/W]: GIC400 Interrupt Target Processor Register (Instance 60 of 64)
  volatile uint32_t ITARGETS60;  ///< 0x8f0 [R/W]: GIC400 Interrupt Target Processor Register (Instance 61 of 64)
  volatile uint32_t ITARGETS61;  ///< 0x8f4 [R/W]: GIC400 Interrupt Target Processor Register (Instance 62 of 64)
  volatile uint32_t ITARGETS62;  ///< 0x8f8 [R/W]: GIC400 Interrupt Target Processor Register (Instance 63 of 64)
  volatile uint32_t ITARGETS63;  ///< 0x8fc [R/W]: GIC400 Interrupt Target Processor Register (Instance 64 of 64)
  volatile uint32_t reserved9[192];
  volatile uint32_t ICFG0;  ///< 0xc00 [R/W]: GIC400 SPI Interrupt Configuration Register (Instance 1 of 16)
  volatile uint32_t ICFG1;  ///< 0xc04 [R/W]: GIC400 SPI Interrupt Configuration Register (Instance 2 of 16)
  volatile uint32_t ICFG2;  ///< 0xc08 [R/W]: GIC400 SPI Interrupt Configuration Register (Instance 3 of 16)
  volatile uint32_t ICFG3;  ///< 0xc0c [R/W]: GIC400 SPI Interrupt Configuration Register (Instance 4 of 16)
  volatile uint32_t ICFG4;  ///< 0xc10 [R/W]: GIC400 SPI Interrupt Configuration Register (Instance 5 of 16)
  volatile uint32_t ICFG5;  ///< 0xc14 [R/W]: GIC400 SPI Interrupt Configuration Register (Instance 6 of 16)
  volatile uint32_t ICFG6;  ///< 0xc18 [R/W]: GIC400 SPI Interrupt Configuration Register (Instance 7 of 16)
  volatile uint32_t ICFG7;  ///< 0xc1c [R/W]: GIC400 SPI Interrupt Configuration Register (Instance 8 of 16)
  volatile uint32_t ICFG8;  ///< 0xc20 [R/W]: GIC400 SPI Interrupt Configuration Register (Instance 9 of 16)
  volatile uint32_t ICFG9;  ///< 0xc24 [R/W]: GIC400 SPI Interrupt Configuration Register (Instance 10 of 16)
  volatile uint32_t ICFG10;  ///< 0xc28 [R/W]: GIC400 SPI Interrupt Configuration Register (Instance 11 of 16)
  volatile uint32_t ICFG11;  ///< 0xc2c [R/W]: GIC400 SPI Interrupt Configuration Register (Instance 12 of 16)
  volatile uint32_t ICFG12;  ///< 0xc30 [R/W]: GIC400 SPI Interrupt Configuration Register (Instance 13 of 16)
  volatile uint32_t ICFG13;  ///< 0xc34 [R/W]: GIC400 SPI Interrupt Configuration Register (Instance 14 of 16)
  volatile uint32_t ICFG14;  ///< 0xc38 [R/W]: GIC400 SPI Interrupt Configuration Register (Instance 15 of 16)
  volatile uint32_t ICFG15;  ///< 0xc3c [R/W]: GIC400 SPI Interrupt Configuration Register (Instance 16 of 16)
  volatile uint32_t reserved10[48];
  volatile uint32_t PPISR;  ///< 0xd00 [R]: GIC400 PPI Interrupt Status Register
  volatile uint32_t SPISR0;  ///< 0xd04 [R]: GIC400 SPI Interrupt Status Register (Instance 1 of 7)
  volatile uint32_t SPISR1;  ///< 0xd08 [R]: GIC400 SPI Interrupt Status Register (Instance 2 of 7)
  volatile uint32_t SPISR2;  ///< 0xd0c [R]: GIC400 SPI Interrupt Status Register (Instance 3 of 7)
  volatile uint32_t SPISR3;  ///< 0xd10 [R]: GIC400 SPI Interrupt Status Register (Instance 4 of 7)
  volatile uint32_t SPISR4;  ///< 0xd14 [R]: GIC400 SPI Interrupt Status Register (Instance 5 of 7)
  volatile uint32_t SPISR5;  ///< 0xd18 [R]: GIC400 SPI Interrupt Status Register (Instance 6 of 7)
  volatile uint32_t SPISR6;  ///< 0xd1c [R]: GIC400 SPI Interrupt Status Register (Instance 7 of 7)
  volatile uint32_t reserved11[56];
  volatile uint32_t NSACR0;  ///< 0xe00 [R/W]: GIC400 Non Secure Access Control Register (Instance 1 of 14)
  volatile uint32_t NSACR1;  ///< 0xe04 [R/W]: GIC400 Non Secure Access Control Register (Instance 2 of 14)
  volatile uint32_t NSACR2;  ///< 0xe08 [R/W]: GIC400 Non Secure Access Control Register (Instance 3 of 14)
  volatile uint32_t NSACR3;  ///< 0xe0c [R/W]: GIC400 Non Secure Access Control Register (Instance 4 of 14)
  volatile uint32_t NSACR4;  ///< 0xe10 [R/W]: GIC400 Non Secure Access Control Register (Instance 5 of 14)
  volatile uint32_t NSACR5;  ///< 0xe14 [R/W]: GIC400 Non Secure Access Control Register (Instance 6 of 14)
  volatile uint32_t NSACR6;  ///< 0xe18 [R/W]: GIC400 Non Secure Access Control Register (Instance 7 of 14)
  volatile uint32_t NSACR7;  ///< 0xe1c [R/W]: GIC400 Non Secure Access Control Register (Instance 8 of 14)
  volatile uint32_t NSACR8;  ///< 0xe20 [R/W]: GIC400 Non Secure Access Control Register (Instance 9 of 14)
  volatile uint32_t NSACR9;  ///< 0xe24 [R/W]: GIC400 Non Secure Access Control Register (Instance 10 of 14)
  volatile uint32_t NSACR10;  ///< 0xe28 [R/W]: GIC400 Non Secure Access Control Register (Instance 11 of 14)
  volatile uint32_t NSACR11;  ///< 0xe2c [R/W]: GIC400 Non Secure Access Control Register (Instance 12 of 14)
  volatile uint32_t NSACR12;  ///< 0xe30 [R/W]: GIC400 Non Secure Access Control Register (Instance 13 of 14)
  volatile uint32_t NSACR13;  ///< 0xe34 [R/W]: GIC400 Non Secure Access Control Register (Instance 14 of 14)
  volatile uint32_t reserved12[50];
  volatile uint32_t SGIR;  ///< 0xf00 [R/W]: GIC400 Software Generated Interrupt
  volatile uint32_t reserved13[3];
  volatile uint32_t CPENDSGIR0;  ///< 0xf10 [R/W]: GIC400 SGI Clear Pending Register (Instance 1 of 4)
  volatile uint32_t CPENDSGIR1;  ///< 0xf14 [R/W]: GIC400 SGI Clear Pending Register (Instance 2 of 4)
  volatile uint32_t CPENDSGIR2;  ///< 0xf18 [R/W]: GIC400 SGI Clear Pending Register (Instance 3 of 4)
  volatile uint32_t CPENDSGIR3;  ///< 0xf1c [R/W]: GIC400 SGI Clear Pending Register (Instance 4 of 4)
  volatile uint32_t SPENDSGIR0;  ///< 0xf20 [R/W]: GIC400 SGI Clear Pending Register (Instance 1 of 4)
  volatile uint32_t SPENDSGIR1;  ///< 0xf24 [R/W]: GIC400 SGI Clear Pending Register (Instance 2 of 4)
  volatile uint32_t SPENDSGIR2;  ///< 0xf28 [R/W]: GIC400 SGI Clear Pending Register (Instance 3 of 4)
  volatile uint32_t SPENDSGIR3;  ///< 0xf2c [R/W]: GIC400 SGI Clear Pending Register (Instance 4 of 4)
} GICD_REGS_t;

//====================================================================
//
//Register File: GIC400 Distrubutor Registers (GICC)
//
//====================================================================

typedef struct GICC_REGS_s
{
  volatile uint32_t CTRL;  ///< 0x0 [R/W]: GIC400 CPU Control Register
  volatile uint32_t PMR;  ///< 0x4 [R/W]: GIC400 CPU Priority Mask Register
  volatile uint32_t BPR;  ///< 0x8 [R/W]: GIC400 CPU Binary Point Register
  volatile uint32_t IAR;  ///< 0xc [R]: GIC400 CPU Interrupt Acknowledge Register
  volatile uint32_t EOIR;  ///< 0x10 [W]: GIC400 CPU End-Of-Interrupt Register
  volatile uint32_t RPR;  ///< 0x14 [R]: GIC400 CPU Running Priority Register
  volatile uint32_t HPPIR;  ///< 0x18 [R]: GIC400 CPU Highest Priority Interrupt Pending Register
  volatile uint32_t ABPR;  ///< 0x1c [R/W]: GIC400 CPU Alias Binary Point Register
  volatile uint32_t AIAR;  ///< 0x20 [R]: GIC400 CPU Aliased Interrupt Acknowledge Register
  volatile uint32_t AEOIR;  ///< 0x24 [W]: GIC400 CPU Aliased End-Of-Interrupt Register
  volatile uint32_t AHPPIR;  ///< 0x28 [R]: GIC400 CPU Aliased Highest Priority Interrupt Pending Register
} GICC_REGS_t;

#endif // GIC400_CORE
