 /*
 **************************************************************************************
 *
 * (c) Copyright 2013 Marvell International Ltd.
 *
 *
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/.
 *
 **************************************************************************************
 *
 * \file GIC400_regmasks.h
 * Generated using RegBuild 1.6.3
 *
 **************************************************************************************
 */

#ifndef _GIC400_CORE_REGMASKS_H_
#define _GIC400_CORE_REGMASKS_H_

#ifndef __KERNEL__
#include <stdint.h>
#endif

//====================================================================
//
//Register File: GIC 400 Core Registers (GIC400_Core)
//
//====================================================================

//====================================================================
//
//Register File: GIC400 Distrubutor Registers (GICD)
/** \brief These registers provide control/status for the power islands, SRAMs, and other miscellaneous
    power related functions in the AP section of the chip.*/
//
//====================================================================

//====================================================================
//Register: GIC400 Distrubutor Control Register (CTRL)
/** \brief Enables the forwarding of pending interrupts from the Distributor to the CPU interfaces*/
//====================================================================

#define  GICD_CTRL_RESERVED1_MASK 0xfffffffc
#define  GICD_CTRL_RESERVED1_SHIFT 2
#define  GICD_CTRL_RESERVED1_MASK_SHIFT(reg) (((reg) & GICD_CTRL_RESERVED1_MASK) >> GICD_CTRL_RESERVED1_SHIFT)
#define  GICD_CTRL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~GICD_CTRL_RESERVED1_MASK) | (((uint32_t)val) << GICD_CTRL_RESERVED1_SHIFT))

#define  GICD_CTRL_ENABLE1_MASK 0x2
#define  GICD_CTRL_ENABLE1_SHIFT 1
#define  GICD_CTRL_ENABLE1_MASK_SHIFT(reg) (((reg) & GICD_CTRL_ENABLE1_MASK) >> GICD_CTRL_ENABLE1_SHIFT)
#define  GICD_CTRL_ENABLE1_REPLACE_VAL(reg,val) (((reg) & ~GICD_CTRL_ENABLE1_MASK) | (((uint32_t)val) << GICD_CTRL_ENABLE1_SHIFT))

#define  GICD_CTRL_ENABLE0_MASK 0x1
#define  GICD_CTRL_ENABLE0_SHIFT 0
#define  GICD_CTRL_ENABLE0_MASK_SHIFT(reg) (((reg) & GICD_CTRL_ENABLE0_MASK) >> GICD_CTRL_ENABLE0_SHIFT)
#define  GICD_CTRL_ENABLE0_REPLACE_VAL(reg,val) (((reg) & ~GICD_CTRL_ENABLE0_MASK) | (((uint32_t)val) << GICD_CTRL_ENABLE0_SHIFT))

//====================================================================
//Register: GIC400 Interrupt Controller Type Register (TYPER)
/** \brief Enables the forwarding of pending interrupts from the Distributor to the CPU interfaces*/
//====================================================================

#define  GICD_TYPER_RESERVED1_MASK 0xffff0000
#define  GICD_TYPER_RESERVED1_SHIFT 16
#define  GICD_TYPER_RESERVED1_MASK_SHIFT(reg) (((reg) & GICD_TYPER_RESERVED1_MASK) >> GICD_TYPER_RESERVED1_SHIFT)
#define  GICD_TYPER_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~GICD_TYPER_RESERVED1_MASK) | (((uint32_t)val) << GICD_TYPER_RESERVED1_SHIFT))

#define  GICD_TYPER_LSPI_MASK 0xf800
#define  GICD_TYPER_LSPI_SHIFT 11
#define  GICD_TYPER_LSPI_MASK_SHIFT(reg) (((reg) & GICD_TYPER_LSPI_MASK) >> GICD_TYPER_LSPI_SHIFT)
#define  GICD_TYPER_LSPI_REPLACE_VAL(reg,val) (((reg) & ~GICD_TYPER_LSPI_MASK) | (((uint32_t)val) << GICD_TYPER_LSPI_SHIFT))

#define  GICD_TYPER_SECEN_MASK 0x400
#define  GICD_TYPER_SECEN_SHIFT 10
#define  GICD_TYPER_SECEN_MASK_SHIFT(reg) (((reg) & GICD_TYPER_SECEN_MASK) >> GICD_TYPER_SECEN_SHIFT)
#define  GICD_TYPER_SECEN_REPLACE_VAL(reg,val) (((reg) & ~GICD_TYPER_SECEN_MASK) | (((uint32_t)val) << GICD_TYPER_SECEN_SHIFT))

#define  GICD_TYPER_RESERVED2_MASK 0x300
#define  GICD_TYPER_RESERVED2_SHIFT 8
#define  GICD_TYPER_RESERVED2_MASK_SHIFT(reg) (((reg) & GICD_TYPER_RESERVED2_MASK) >> GICD_TYPER_RESERVED2_SHIFT)
#define  GICD_TYPER_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~GICD_TYPER_RESERVED2_MASK) | (((uint32_t)val) << GICD_TYPER_RESERVED2_SHIFT))

#define  GICD_TYPER_CPUNUM_MASK 0xe0
#define  GICD_TYPER_CPUNUM_SHIFT 5
#define  GICD_TYPER_CPUNUM_MASK_SHIFT(reg) (((reg) & GICD_TYPER_CPUNUM_MASK) >> GICD_TYPER_CPUNUM_SHIFT)
#define  GICD_TYPER_CPUNUM_REPLACE_VAL(reg,val) (((reg) & ~GICD_TYPER_CPUNUM_MASK) | (((uint32_t)val) << GICD_TYPER_CPUNUM_SHIFT))

#define  GICD_TYPER_ITLINESNUM_MASK 0x1f
#define  GICD_TYPER_ITLINESNUM_SHIFT 0
#define  GICD_TYPER_ITLINESNUM_MASK_SHIFT(reg) (((reg) & GICD_TYPER_ITLINESNUM_MASK) >> GICD_TYPER_ITLINESNUM_SHIFT)
#define  GICD_TYPER_ITLINESNUM_REPLACE_VAL(reg,val) (((reg) & ~GICD_TYPER_ITLINESNUM_MASK) | (((uint32_t)val) << GICD_TYPER_ITLINESNUM_SHIFT))

//====================================================================
//Register: GIC400 Distrubutor Implementer ID Register (IIDR)
/** \brief Provides Implementer ID and Distrubution ID Number*/
//====================================================================

#define  GICD_IIDR_PRODUCTID_MASK 0xff000000
#define  GICD_IIDR_PRODUCTID_SHIFT 24
#define  GICD_IIDR_PRODUCTID_MASK_SHIFT(reg) (((reg) & GICD_IIDR_PRODUCTID_MASK) >> GICD_IIDR_PRODUCTID_SHIFT)
#define  GICD_IIDR_PRODUCTID_REPLACE_VAL(reg,val) (((reg) & ~GICD_IIDR_PRODUCTID_MASK) | (((uint32_t)val) << GICD_IIDR_PRODUCTID_SHIFT))

#define  GICD_IIDR_RESERVED1_MASK 0xf00000
#define  GICD_IIDR_RESERVED1_SHIFT 20
#define  GICD_IIDR_RESERVED1_MASK_SHIFT(reg) (((reg) & GICD_IIDR_RESERVED1_MASK) >> GICD_IIDR_RESERVED1_SHIFT)
#define  GICD_IIDR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~GICD_IIDR_RESERVED1_MASK) | (((uint32_t)val) << GICD_IIDR_RESERVED1_SHIFT))

#define  GICD_IIDR_MAJORREV_MASK 0xf0000
#define  GICD_IIDR_MAJORREV_SHIFT 16
#define  GICD_IIDR_MAJORREV_MASK_SHIFT(reg) (((reg) & GICD_IIDR_MAJORREV_MASK) >> GICD_IIDR_MAJORREV_SHIFT)
#define  GICD_IIDR_MAJORREV_REPLACE_VAL(reg,val) (((reg) & ~GICD_IIDR_MAJORREV_MASK) | (((uint32_t)val) << GICD_IIDR_MAJORREV_SHIFT))

#define  GICD_IIDR_MINORREV_MASK 0xf000
#define  GICD_IIDR_MINORREV_SHIFT 12
#define  GICD_IIDR_MINORREV_MASK_SHIFT(reg) (((reg) & GICD_IIDR_MINORREV_MASK) >> GICD_IIDR_MINORREV_SHIFT)
#define  GICD_IIDR_MINORREV_REPLACE_VAL(reg,val) (((reg) & ~GICD_IIDR_MINORREV_MASK) | (((uint32_t)val) << GICD_IIDR_MINORREV_SHIFT))

#define  GICD_IIDR_IMPLEMENTER_MASK 0xfff
#define  GICD_IIDR_IMPLEMENTER_SHIFT 0
#define  GICD_IIDR_IMPLEMENTER_MASK_SHIFT(reg) (((reg) & GICD_IIDR_IMPLEMENTER_MASK) >> GICD_IIDR_IMPLEMENTER_SHIFT)
#define  GICD_IIDR_IMPLEMENTER_REPLACE_VAL(reg,val) (((reg) & ~GICD_IIDR_IMPLEMENTER_MASK) | (((uint32_t)val) << GICD_IIDR_IMPLEMENTER_SHIFT))

//====================================================================
//Register: GIC400 Distrubutor Group Control Register (Instance 1 of 8) (IGROUP0)
/** \brief Provides Implementer ID and Distrubution ID Number (Instance 1 of 8)*/
//====================================================================

#define  GICD_IGROUP0_GROUP_MASK 0xffffffff
#define  GICD_IGROUP0_GROUP_SHIFT 0
#define  GICD_IGROUP0_GROUP_MASK_SHIFT(reg) (((reg) & GICD_IGROUP0_GROUP_MASK) >> GICD_IGROUP0_GROUP_SHIFT)
#define  GICD_IGROUP0_GROUP_REPLACE_VAL(reg,val) (((reg) & ~GICD_IGROUP0_GROUP_MASK) | (((uint32_t)val) << GICD_IGROUP0_GROUP_SHIFT))

//====================================================================
//Register: GIC400 Distrubutor Group Control Register (Instance 2 of 8) (IGROUP1)
/** \brief Provides Implementer ID and Distrubution ID Number (Instance 2 of 8)*/
//====================================================================

#define  GICD_IGROUP1_GROUP_MASK 0xffffffff
#define  GICD_IGROUP1_GROUP_SHIFT 0
#define  GICD_IGROUP1_GROUP_MASK_SHIFT(reg) (((reg) & GICD_IGROUP1_GROUP_MASK) >> GICD_IGROUP1_GROUP_SHIFT)
#define  GICD_IGROUP1_GROUP_REPLACE_VAL(reg,val) (((reg) & ~GICD_IGROUP1_GROUP_MASK) | (((uint32_t)val) << GICD_IGROUP1_GROUP_SHIFT))

//====================================================================
//Register: GIC400 Distrubutor Group Control Register (Instance 3 of 8) (IGROUP2)
/** \brief Provides Implementer ID and Distrubution ID Number (Instance 3 of 8)*/
//====================================================================

#define  GICD_IGROUP2_GROUP_MASK 0xffffffff
#define  GICD_IGROUP2_GROUP_SHIFT 0
#define  GICD_IGROUP2_GROUP_MASK_SHIFT(reg) (((reg) & GICD_IGROUP2_GROUP_MASK) >> GICD_IGROUP2_GROUP_SHIFT)
#define  GICD_IGROUP2_GROUP_REPLACE_VAL(reg,val) (((reg) & ~GICD_IGROUP2_GROUP_MASK) | (((uint32_t)val) << GICD_IGROUP2_GROUP_SHIFT))

//====================================================================
//Register: GIC400 Distrubutor Group Control Register (Instance 4 of 8) (IGROUP3)
/** \brief Provides Implementer ID and Distrubution ID Number (Instance 4 of 8)*/
//====================================================================

#define  GICD_IGROUP3_GROUP_MASK 0xffffffff
#define  GICD_IGROUP3_GROUP_SHIFT 0
#define  GICD_IGROUP3_GROUP_MASK_SHIFT(reg) (((reg) & GICD_IGROUP3_GROUP_MASK) >> GICD_IGROUP3_GROUP_SHIFT)
#define  GICD_IGROUP3_GROUP_REPLACE_VAL(reg,val) (((reg) & ~GICD_IGROUP3_GROUP_MASK) | (((uint32_t)val) << GICD_IGROUP3_GROUP_SHIFT))

//====================================================================
//Register: GIC400 Distrubutor Group Control Register (Instance 5 of 8) (IGROUP4)
/** \brief Provides Implementer ID and Distrubution ID Number (Instance 5 of 8)*/
//====================================================================

#define  GICD_IGROUP4_GROUP_MASK 0xffffffff
#define  GICD_IGROUP4_GROUP_SHIFT 0
#define  GICD_IGROUP4_GROUP_MASK_SHIFT(reg) (((reg) & GICD_IGROUP4_GROUP_MASK) >> GICD_IGROUP4_GROUP_SHIFT)
#define  GICD_IGROUP4_GROUP_REPLACE_VAL(reg,val) (((reg) & ~GICD_IGROUP4_GROUP_MASK) | (((uint32_t)val) << GICD_IGROUP4_GROUP_SHIFT))

//====================================================================
//Register: GIC400 Distrubutor Group Control Register (Instance 6 of 8) (IGROUP5)
/** \brief Provides Implementer ID and Distrubution ID Number (Instance 6 of 8)*/
//====================================================================

#define  GICD_IGROUP5_GROUP_MASK 0xffffffff
#define  GICD_IGROUP5_GROUP_SHIFT 0
#define  GICD_IGROUP5_GROUP_MASK_SHIFT(reg) (((reg) & GICD_IGROUP5_GROUP_MASK) >> GICD_IGROUP5_GROUP_SHIFT)
#define  GICD_IGROUP5_GROUP_REPLACE_VAL(reg,val) (((reg) & ~GICD_IGROUP5_GROUP_MASK) | (((uint32_t)val) << GICD_IGROUP5_GROUP_SHIFT))

//====================================================================
//Register: GIC400 Distrubutor Group Control Register (Instance 7 of 8) (IGROUP6)
/** \brief Provides Implementer ID and Distrubution ID Number (Instance 7 of 8)*/
//====================================================================

#define  GICD_IGROUP6_GROUP_MASK 0xffffffff
#define  GICD_IGROUP6_GROUP_SHIFT 0
#define  GICD_IGROUP6_GROUP_MASK_SHIFT(reg) (((reg) & GICD_IGROUP6_GROUP_MASK) >> GICD_IGROUP6_GROUP_SHIFT)
#define  GICD_IGROUP6_GROUP_REPLACE_VAL(reg,val) (((reg) & ~GICD_IGROUP6_GROUP_MASK) | (((uint32_t)val) << GICD_IGROUP6_GROUP_SHIFT))

//====================================================================
//Register: GIC400 Distrubutor Group Control Register (Instance 8 of 8) (IGROUP7)
/** \brief Provides Implementer ID and Distrubution ID Number (Instance 8 of 8)*/
//====================================================================

#define  GICD_IGROUP7_GROUP_MASK 0xffffffff
#define  GICD_IGROUP7_GROUP_SHIFT 0
#define  GICD_IGROUP7_GROUP_MASK_SHIFT(reg) (((reg) & GICD_IGROUP7_GROUP_MASK) >> GICD_IGROUP7_GROUP_SHIFT)
#define  GICD_IGROUP7_GROUP_REPLACE_VAL(reg,val) (((reg) & ~GICD_IGROUP7_GROUP_MASK) | (((uint32_t)val) << GICD_IGROUP7_GROUP_SHIFT))

//====================================================================
//Register: GIC400 Distrubutor Interrupt Set-Enable Register (Instance 1 of 8) (ISENABLE0)
/** \brief Controls GIC400 SPIs Set Enable Register (Instance 1 of 8)*/
//====================================================================

#define  GICD_ISENABLE0_SET_MASK 0xffffffff
#define  GICD_ISENABLE0_SET_SHIFT 0
#define  GICD_ISENABLE0_SET_MASK_SHIFT(reg) (((reg) & GICD_ISENABLE0_SET_MASK) >> GICD_ISENABLE0_SET_SHIFT)
#define  GICD_ISENABLE0_SET_REPLACE_VAL(reg,val) (((reg) & ~GICD_ISENABLE0_SET_MASK) | (((uint32_t)val) << GICD_ISENABLE0_SET_SHIFT))

//====================================================================
//Register: GIC400 Distrubutor Interrupt Set-Enable Register (Instance 2 of 8) (ISENABLE1)
/** \brief Controls GIC400 SPIs Set Enable Register (Instance 2 of 8)*/
//====================================================================

#define  GICD_ISENABLE1_SET_MASK 0xffffffff
#define  GICD_ISENABLE1_SET_SHIFT 0
#define  GICD_ISENABLE1_SET_MASK_SHIFT(reg) (((reg) & GICD_ISENABLE1_SET_MASK) >> GICD_ISENABLE1_SET_SHIFT)
#define  GICD_ISENABLE1_SET_REPLACE_VAL(reg,val) (((reg) & ~GICD_ISENABLE1_SET_MASK) | (((uint32_t)val) << GICD_ISENABLE1_SET_SHIFT))

//====================================================================
//Register: GIC400 Distrubutor Interrupt Set-Enable Register (Instance 3 of 8) (ISENABLE2)
/** \brief Controls GIC400 SPIs Set Enable Register (Instance 3 of 8)*/
//====================================================================

#define  GICD_ISENABLE2_SET_MASK 0xffffffff
#define  GICD_ISENABLE2_SET_SHIFT 0
#define  GICD_ISENABLE2_SET_MASK_SHIFT(reg) (((reg) & GICD_ISENABLE2_SET_MASK) >> GICD_ISENABLE2_SET_SHIFT)
#define  GICD_ISENABLE2_SET_REPLACE_VAL(reg,val) (((reg) & ~GICD_ISENABLE2_SET_MASK) | (((uint32_t)val) << GICD_ISENABLE2_SET_SHIFT))

//====================================================================
//Register: GIC400 Distrubutor Interrupt Set-Enable Register (Instance 4 of 8) (ISENABLE3)
/** \brief Controls GIC400 SPIs Set Enable Register (Instance 4 of 8)*/
//====================================================================

#define  GICD_ISENABLE3_SET_MASK 0xffffffff
#define  GICD_ISENABLE3_SET_SHIFT 0
#define  GICD_ISENABLE3_SET_MASK_SHIFT(reg) (((reg) & GICD_ISENABLE3_SET_MASK) >> GICD_ISENABLE3_SET_SHIFT)
#define  GICD_ISENABLE3_SET_REPLACE_VAL(reg,val) (((reg) & ~GICD_ISENABLE3_SET_MASK) | (((uint32_t)val) << GICD_ISENABLE3_SET_SHIFT))

//====================================================================
//Register: GIC400 Distrubutor Interrupt Set-Enable Register (Instance 5 of 8) (ISENABLE4)
/** \brief Controls GIC400 SPIs Set Enable Register (Instance 5 of 8)*/
//====================================================================

#define  GICD_ISENABLE4_SET_MASK 0xffffffff
#define  GICD_ISENABLE4_SET_SHIFT 0
#define  GICD_ISENABLE4_SET_MASK_SHIFT(reg) (((reg) & GICD_ISENABLE4_SET_MASK) >> GICD_ISENABLE4_SET_SHIFT)
#define  GICD_ISENABLE4_SET_REPLACE_VAL(reg,val) (((reg) & ~GICD_ISENABLE4_SET_MASK) | (((uint32_t)val) << GICD_ISENABLE4_SET_SHIFT))

//====================================================================
//Register: GIC400 Distrubutor Interrupt Set-Enable Register (Instance 6 of 8) (ISENABLE5)
/** \brief Controls GIC400 SPIs Set Enable Register (Instance 6 of 8)*/
//====================================================================

#define  GICD_ISENABLE5_SET_MASK 0xffffffff
#define  GICD_ISENABLE5_SET_SHIFT 0
#define  GICD_ISENABLE5_SET_MASK_SHIFT(reg) (((reg) & GICD_ISENABLE5_SET_MASK) >> GICD_ISENABLE5_SET_SHIFT)
#define  GICD_ISENABLE5_SET_REPLACE_VAL(reg,val) (((reg) & ~GICD_ISENABLE5_SET_MASK) | (((uint32_t)val) << GICD_ISENABLE5_SET_SHIFT))

//====================================================================
//Register: GIC400 Distrubutor Interrupt Set-Enable Register (Instance 7 of 8) (ISENABLE6)
/** \brief Controls GIC400 SPIs Set Enable Register (Instance 7 of 8)*/
//====================================================================

#define  GICD_ISENABLE6_SET_MASK 0xffffffff
#define  GICD_ISENABLE6_SET_SHIFT 0
#define  GICD_ISENABLE6_SET_MASK_SHIFT(reg) (((reg) & GICD_ISENABLE6_SET_MASK) >> GICD_ISENABLE6_SET_SHIFT)
#define  GICD_ISENABLE6_SET_REPLACE_VAL(reg,val) (((reg) & ~GICD_ISENABLE6_SET_MASK) | (((uint32_t)val) << GICD_ISENABLE6_SET_SHIFT))

//====================================================================
//Register: GIC400 Distrubutor Interrupt Set-Enable Register (Instance 8 of 8) (ISENABLE7)
/** \brief Controls GIC400 SPIs Set Enable Register (Instance 8 of 8)*/
//====================================================================

#define  GICD_ISENABLE7_SET_MASK 0xffffffff
#define  GICD_ISENABLE7_SET_SHIFT 0
#define  GICD_ISENABLE7_SET_MASK_SHIFT(reg) (((reg) & GICD_ISENABLE7_SET_MASK) >> GICD_ISENABLE7_SET_SHIFT)
#define  GICD_ISENABLE7_SET_REPLACE_VAL(reg,val) (((reg) & ~GICD_ISENABLE7_SET_MASK) | (((uint32_t)val) << GICD_ISENABLE7_SET_SHIFT))

//====================================================================
//Register: GIC400 Distrubutor Interrupt Clear-Enable Register (Instance 1 of 8) (ICENABLE0)
/** \brief Controls GIC400 SPIs Clear Enable Register (Instance 1 of 8)*/
//====================================================================

#define  GICD_ICENABLE0_CLEAR_MASK 0xffffffff
#define  GICD_ICENABLE0_CLEAR_SHIFT 0
#define  GICD_ICENABLE0_CLEAR_MASK_SHIFT(reg) (((reg) & GICD_ICENABLE0_CLEAR_MASK) >> GICD_ICENABLE0_CLEAR_SHIFT)
#define  GICD_ICENABLE0_CLEAR_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICENABLE0_CLEAR_MASK) | (((uint32_t)val) << GICD_ICENABLE0_CLEAR_SHIFT))

//====================================================================
//Register: GIC400 Distrubutor Interrupt Clear-Enable Register (Instance 2 of 8) (ICENABLE1)
/** \brief Controls GIC400 SPIs Clear Enable Register (Instance 2 of 8)*/
//====================================================================

#define  GICD_ICENABLE1_CLEAR_MASK 0xffffffff
#define  GICD_ICENABLE1_CLEAR_SHIFT 0
#define  GICD_ICENABLE1_CLEAR_MASK_SHIFT(reg) (((reg) & GICD_ICENABLE1_CLEAR_MASK) >> GICD_ICENABLE1_CLEAR_SHIFT)
#define  GICD_ICENABLE1_CLEAR_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICENABLE1_CLEAR_MASK) | (((uint32_t)val) << GICD_ICENABLE1_CLEAR_SHIFT))

//====================================================================
//Register: GIC400 Distrubutor Interrupt Clear-Enable Register (Instance 3 of 8) (ICENABLE2)
/** \brief Controls GIC400 SPIs Clear Enable Register (Instance 3 of 8)*/
//====================================================================

#define  GICD_ICENABLE2_CLEAR_MASK 0xffffffff
#define  GICD_ICENABLE2_CLEAR_SHIFT 0
#define  GICD_ICENABLE2_CLEAR_MASK_SHIFT(reg) (((reg) & GICD_ICENABLE2_CLEAR_MASK) >> GICD_ICENABLE2_CLEAR_SHIFT)
#define  GICD_ICENABLE2_CLEAR_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICENABLE2_CLEAR_MASK) | (((uint32_t)val) << GICD_ICENABLE2_CLEAR_SHIFT))

//====================================================================
//Register: GIC400 Distrubutor Interrupt Clear-Enable Register (Instance 4 of 8) (ICENABLE3)
/** \brief Controls GIC400 SPIs Clear Enable Register (Instance 4 of 8)*/
//====================================================================

#define  GICD_ICENABLE3_CLEAR_MASK 0xffffffff
#define  GICD_ICENABLE3_CLEAR_SHIFT 0
#define  GICD_ICENABLE3_CLEAR_MASK_SHIFT(reg) (((reg) & GICD_ICENABLE3_CLEAR_MASK) >> GICD_ICENABLE3_CLEAR_SHIFT)
#define  GICD_ICENABLE3_CLEAR_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICENABLE3_CLEAR_MASK) | (((uint32_t)val) << GICD_ICENABLE3_CLEAR_SHIFT))

//====================================================================
//Register: GIC400 Distrubutor Interrupt Clear-Enable Register (Instance 5 of 8) (ICENABLE4)
/** \brief Controls GIC400 SPIs Clear Enable Register (Instance 5 of 8)*/
//====================================================================

#define  GICD_ICENABLE4_CLEAR_MASK 0xffffffff
#define  GICD_ICENABLE4_CLEAR_SHIFT 0
#define  GICD_ICENABLE4_CLEAR_MASK_SHIFT(reg) (((reg) & GICD_ICENABLE4_CLEAR_MASK) >> GICD_ICENABLE4_CLEAR_SHIFT)
#define  GICD_ICENABLE4_CLEAR_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICENABLE4_CLEAR_MASK) | (((uint32_t)val) << GICD_ICENABLE4_CLEAR_SHIFT))

//====================================================================
//Register: GIC400 Distrubutor Interrupt Clear-Enable Register (Instance 6 of 8) (ICENABLE5)
/** \brief Controls GIC400 SPIs Clear Enable Register (Instance 6 of 8)*/
//====================================================================

#define  GICD_ICENABLE5_CLEAR_MASK 0xffffffff
#define  GICD_ICENABLE5_CLEAR_SHIFT 0
#define  GICD_ICENABLE5_CLEAR_MASK_SHIFT(reg) (((reg) & GICD_ICENABLE5_CLEAR_MASK) >> GICD_ICENABLE5_CLEAR_SHIFT)
#define  GICD_ICENABLE5_CLEAR_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICENABLE5_CLEAR_MASK) | (((uint32_t)val) << GICD_ICENABLE5_CLEAR_SHIFT))

//====================================================================
//Register: GIC400 Distrubutor Interrupt Clear-Enable Register (Instance 7 of 8) (ICENABLE6)
/** \brief Controls GIC400 SPIs Clear Enable Register (Instance 7 of 8)*/
//====================================================================

#define  GICD_ICENABLE6_CLEAR_MASK 0xffffffff
#define  GICD_ICENABLE6_CLEAR_SHIFT 0
#define  GICD_ICENABLE6_CLEAR_MASK_SHIFT(reg) (((reg) & GICD_ICENABLE6_CLEAR_MASK) >> GICD_ICENABLE6_CLEAR_SHIFT)
#define  GICD_ICENABLE6_CLEAR_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICENABLE6_CLEAR_MASK) | (((uint32_t)val) << GICD_ICENABLE6_CLEAR_SHIFT))

//====================================================================
//Register: GIC400 Distrubutor Interrupt Clear-Enable Register (Instance 8 of 8) (ICENABLE7)
/** \brief Controls GIC400 SPIs Clear Enable Register (Instance 8 of 8)*/
//====================================================================

#define  GICD_ICENABLE7_CLEAR_MASK 0xffffffff
#define  GICD_ICENABLE7_CLEAR_SHIFT 0
#define  GICD_ICENABLE7_CLEAR_MASK_SHIFT(reg) (((reg) & GICD_ICENABLE7_CLEAR_MASK) >> GICD_ICENABLE7_CLEAR_SHIFT)
#define  GICD_ICENABLE7_CLEAR_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICENABLE7_CLEAR_MASK) | (((uint32_t)val) << GICD_ICENABLE7_CLEAR_SHIFT))

//====================================================================
//Register: GIC400 Distrubutor Set Pending Register (Instance 1 of 8) (ISPENDR0)
/** \brief Controls GIC400 Set Pending Register (Instance 1 of 8)*/
//====================================================================

#define  GICD_ISPENDR0_PENDING_MASK 0xffffffff
#define  GICD_ISPENDR0_PENDING_SHIFT 0
#define  GICD_ISPENDR0_PENDING_MASK_SHIFT(reg) (((reg) & GICD_ISPENDR0_PENDING_MASK) >> GICD_ISPENDR0_PENDING_SHIFT)
#define  GICD_ISPENDR0_PENDING_REPLACE_VAL(reg,val) (((reg) & ~GICD_ISPENDR0_PENDING_MASK) | (((uint32_t)val) << GICD_ISPENDR0_PENDING_SHIFT))

//====================================================================
//Register: GIC400 Distrubutor Set Pending Register (Instance 2 of 8) (ISPENDR1)
/** \brief Controls GIC400 Set Pending Register (Instance 2 of 8)*/
//====================================================================

#define  GICD_ISPENDR1_PENDING_MASK 0xffffffff
#define  GICD_ISPENDR1_PENDING_SHIFT 0
#define  GICD_ISPENDR1_PENDING_MASK_SHIFT(reg) (((reg) & GICD_ISPENDR1_PENDING_MASK) >> GICD_ISPENDR1_PENDING_SHIFT)
#define  GICD_ISPENDR1_PENDING_REPLACE_VAL(reg,val) (((reg) & ~GICD_ISPENDR1_PENDING_MASK) | (((uint32_t)val) << GICD_ISPENDR1_PENDING_SHIFT))

//====================================================================
//Register: GIC400 Distrubutor Set Pending Register (Instance 3 of 8) (ISPENDR2)
/** \brief Controls GIC400 Set Pending Register (Instance 3 of 8)*/
//====================================================================

#define  GICD_ISPENDR2_PENDING_MASK 0xffffffff
#define  GICD_ISPENDR2_PENDING_SHIFT 0
#define  GICD_ISPENDR2_PENDING_MASK_SHIFT(reg) (((reg) & GICD_ISPENDR2_PENDING_MASK) >> GICD_ISPENDR2_PENDING_SHIFT)
#define  GICD_ISPENDR2_PENDING_REPLACE_VAL(reg,val) (((reg) & ~GICD_ISPENDR2_PENDING_MASK) | (((uint32_t)val) << GICD_ISPENDR2_PENDING_SHIFT))

//====================================================================
//Register: GIC400 Distrubutor Set Pending Register (Instance 4 of 8) (ISPENDR3)
/** \brief Controls GIC400 Set Pending Register (Instance 4 of 8)*/
//====================================================================

#define  GICD_ISPENDR3_PENDING_MASK 0xffffffff
#define  GICD_ISPENDR3_PENDING_SHIFT 0
#define  GICD_ISPENDR3_PENDING_MASK_SHIFT(reg) (((reg) & GICD_ISPENDR3_PENDING_MASK) >> GICD_ISPENDR3_PENDING_SHIFT)
#define  GICD_ISPENDR3_PENDING_REPLACE_VAL(reg,val) (((reg) & ~GICD_ISPENDR3_PENDING_MASK) | (((uint32_t)val) << GICD_ISPENDR3_PENDING_SHIFT))

//====================================================================
//Register: GIC400 Distrubutor Set Pending Register (Instance 5 of 8) (ISPENDR4)
/** \brief Controls GIC400 Set Pending Register (Instance 5 of 8)*/
//====================================================================

#define  GICD_ISPENDR4_PENDING_MASK 0xffffffff
#define  GICD_ISPENDR4_PENDING_SHIFT 0
#define  GICD_ISPENDR4_PENDING_MASK_SHIFT(reg) (((reg) & GICD_ISPENDR4_PENDING_MASK) >> GICD_ISPENDR4_PENDING_SHIFT)
#define  GICD_ISPENDR4_PENDING_REPLACE_VAL(reg,val) (((reg) & ~GICD_ISPENDR4_PENDING_MASK) | (((uint32_t)val) << GICD_ISPENDR4_PENDING_SHIFT))

//====================================================================
//Register: GIC400 Distrubutor Set Pending Register (Instance 6 of 8) (ISPENDR5)
/** \brief Controls GIC400 Set Pending Register (Instance 6 of 8)*/
//====================================================================

#define  GICD_ISPENDR5_PENDING_MASK 0xffffffff
#define  GICD_ISPENDR5_PENDING_SHIFT 0
#define  GICD_ISPENDR5_PENDING_MASK_SHIFT(reg) (((reg) & GICD_ISPENDR5_PENDING_MASK) >> GICD_ISPENDR5_PENDING_SHIFT)
#define  GICD_ISPENDR5_PENDING_REPLACE_VAL(reg,val) (((reg) & ~GICD_ISPENDR5_PENDING_MASK) | (((uint32_t)val) << GICD_ISPENDR5_PENDING_SHIFT))

//====================================================================
//Register: GIC400 Distrubutor Set Pending Register (Instance 7 of 8) (ISPENDR6)
/** \brief Controls GIC400 Set Pending Register (Instance 7 of 8)*/
//====================================================================

#define  GICD_ISPENDR6_PENDING_MASK 0xffffffff
#define  GICD_ISPENDR6_PENDING_SHIFT 0
#define  GICD_ISPENDR6_PENDING_MASK_SHIFT(reg) (((reg) & GICD_ISPENDR6_PENDING_MASK) >> GICD_ISPENDR6_PENDING_SHIFT)
#define  GICD_ISPENDR6_PENDING_REPLACE_VAL(reg,val) (((reg) & ~GICD_ISPENDR6_PENDING_MASK) | (((uint32_t)val) << GICD_ISPENDR6_PENDING_SHIFT))

//====================================================================
//Register: GIC400 Distrubutor Set Pending Register (Instance 8 of 8) (ISPENDR7)
/** \brief Controls GIC400 Set Pending Register (Instance 8 of 8)*/
//====================================================================

#define  GICD_ISPENDR7_PENDING_MASK 0xffffffff
#define  GICD_ISPENDR7_PENDING_SHIFT 0
#define  GICD_ISPENDR7_PENDING_MASK_SHIFT(reg) (((reg) & GICD_ISPENDR7_PENDING_MASK) >> GICD_ISPENDR7_PENDING_SHIFT)
#define  GICD_ISPENDR7_PENDING_REPLACE_VAL(reg,val) (((reg) & ~GICD_ISPENDR7_PENDING_MASK) | (((uint32_t)val) << GICD_ISPENDR7_PENDING_SHIFT))

//====================================================================
//Register: GIC400 Distrubutor Clear Pending Register (Instance 1 of 8) (ICPENDR0)
/** \brief Controls GIC400 Clear Pending Register (Instance 1 of 8)*/
//====================================================================

#define  GICD_ICPENDR0_PENDING_MASK 0xffffffff
#define  GICD_ICPENDR0_PENDING_SHIFT 0
#define  GICD_ICPENDR0_PENDING_MASK_SHIFT(reg) (((reg) & GICD_ICPENDR0_PENDING_MASK) >> GICD_ICPENDR0_PENDING_SHIFT)
#define  GICD_ICPENDR0_PENDING_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICPENDR0_PENDING_MASK) | (((uint32_t)val) << GICD_ICPENDR0_PENDING_SHIFT))

//====================================================================
//Register: GIC400 Distrubutor Clear Pending Register (Instance 2 of 8) (ICPENDR1)
/** \brief Controls GIC400 Clear Pending Register (Instance 2 of 8)*/
//====================================================================

#define  GICD_ICPENDR1_PENDING_MASK 0xffffffff
#define  GICD_ICPENDR1_PENDING_SHIFT 0
#define  GICD_ICPENDR1_PENDING_MASK_SHIFT(reg) (((reg) & GICD_ICPENDR1_PENDING_MASK) >> GICD_ICPENDR1_PENDING_SHIFT)
#define  GICD_ICPENDR1_PENDING_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICPENDR1_PENDING_MASK) | (((uint32_t)val) << GICD_ICPENDR1_PENDING_SHIFT))

//====================================================================
//Register: GIC400 Distrubutor Clear Pending Register (Instance 3 of 8) (ICPENDR2)
/** \brief Controls GIC400 Clear Pending Register (Instance 3 of 8)*/
//====================================================================

#define  GICD_ICPENDR2_PENDING_MASK 0xffffffff
#define  GICD_ICPENDR2_PENDING_SHIFT 0
#define  GICD_ICPENDR2_PENDING_MASK_SHIFT(reg) (((reg) & GICD_ICPENDR2_PENDING_MASK) >> GICD_ICPENDR2_PENDING_SHIFT)
#define  GICD_ICPENDR2_PENDING_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICPENDR2_PENDING_MASK) | (((uint32_t)val) << GICD_ICPENDR2_PENDING_SHIFT))

//====================================================================
//Register: GIC400 Distrubutor Clear Pending Register (Instance 4 of 8) (ICPENDR3)
/** \brief Controls GIC400 Clear Pending Register (Instance 4 of 8)*/
//====================================================================

#define  GICD_ICPENDR3_PENDING_MASK 0xffffffff
#define  GICD_ICPENDR3_PENDING_SHIFT 0
#define  GICD_ICPENDR3_PENDING_MASK_SHIFT(reg) (((reg) & GICD_ICPENDR3_PENDING_MASK) >> GICD_ICPENDR3_PENDING_SHIFT)
#define  GICD_ICPENDR3_PENDING_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICPENDR3_PENDING_MASK) | (((uint32_t)val) << GICD_ICPENDR3_PENDING_SHIFT))

//====================================================================
//Register: GIC400 Distrubutor Clear Pending Register (Instance 5 of 8) (ICPENDR4)
/** \brief Controls GIC400 Clear Pending Register (Instance 5 of 8)*/
//====================================================================

#define  GICD_ICPENDR4_PENDING_MASK 0xffffffff
#define  GICD_ICPENDR4_PENDING_SHIFT 0
#define  GICD_ICPENDR4_PENDING_MASK_SHIFT(reg) (((reg) & GICD_ICPENDR4_PENDING_MASK) >> GICD_ICPENDR4_PENDING_SHIFT)
#define  GICD_ICPENDR4_PENDING_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICPENDR4_PENDING_MASK) | (((uint32_t)val) << GICD_ICPENDR4_PENDING_SHIFT))

//====================================================================
//Register: GIC400 Distrubutor Clear Pending Register (Instance 6 of 8) (ICPENDR5)
/** \brief Controls GIC400 Clear Pending Register (Instance 6 of 8)*/
//====================================================================

#define  GICD_ICPENDR5_PENDING_MASK 0xffffffff
#define  GICD_ICPENDR5_PENDING_SHIFT 0
#define  GICD_ICPENDR5_PENDING_MASK_SHIFT(reg) (((reg) & GICD_ICPENDR5_PENDING_MASK) >> GICD_ICPENDR5_PENDING_SHIFT)
#define  GICD_ICPENDR5_PENDING_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICPENDR5_PENDING_MASK) | (((uint32_t)val) << GICD_ICPENDR5_PENDING_SHIFT))

//====================================================================
//Register: GIC400 Distrubutor Clear Pending Register (Instance 7 of 8) (ICPENDR6)
/** \brief Controls GIC400 Clear Pending Register (Instance 7 of 8)*/
//====================================================================

#define  GICD_ICPENDR6_PENDING_MASK 0xffffffff
#define  GICD_ICPENDR6_PENDING_SHIFT 0
#define  GICD_ICPENDR6_PENDING_MASK_SHIFT(reg) (((reg) & GICD_ICPENDR6_PENDING_MASK) >> GICD_ICPENDR6_PENDING_SHIFT)
#define  GICD_ICPENDR6_PENDING_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICPENDR6_PENDING_MASK) | (((uint32_t)val) << GICD_ICPENDR6_PENDING_SHIFT))

//====================================================================
//Register: GIC400 Distrubutor Clear Pending Register (Instance 8 of 8) (ICPENDR7)
/** \brief Controls GIC400 Clear Pending Register (Instance 8 of 8)*/
//====================================================================

#define  GICD_ICPENDR7_PENDING_MASK 0xffffffff
#define  GICD_ICPENDR7_PENDING_SHIFT 0
#define  GICD_ICPENDR7_PENDING_MASK_SHIFT(reg) (((reg) & GICD_ICPENDR7_PENDING_MASK) >> GICD_ICPENDR7_PENDING_SHIFT)
#define  GICD_ICPENDR7_PENDING_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICPENDR7_PENDING_MASK) | (((uint32_t)val) << GICD_ICPENDR7_PENDING_SHIFT))

//====================================================================
//Register: GIC400 Distrubutor Set Active State Register (Instance 1 of 8) (ISACTIVE0)
/** \brief Controls GIC400 Set Active State Register (Instance 1 of 8)*/
//====================================================================

#define  GICD_ISACTIVE0_ACTIVE_MASK 0xffffffff
#define  GICD_ISACTIVE0_ACTIVE_SHIFT 0
#define  GICD_ISACTIVE0_ACTIVE_MASK_SHIFT(reg) (((reg) & GICD_ISACTIVE0_ACTIVE_MASK) >> GICD_ISACTIVE0_ACTIVE_SHIFT)
#define  GICD_ISACTIVE0_ACTIVE_REPLACE_VAL(reg,val) (((reg) & ~GICD_ISACTIVE0_ACTIVE_MASK) | (((uint32_t)val) << GICD_ISACTIVE0_ACTIVE_SHIFT))

//====================================================================
//Register: GIC400 Distrubutor Set Active State Register (Instance 2 of 8) (ISACTIVE1)
/** \brief Controls GIC400 Set Active State Register (Instance 2 of 8)*/
//====================================================================

#define  GICD_ISACTIVE1_ACTIVE_MASK 0xffffffff
#define  GICD_ISACTIVE1_ACTIVE_SHIFT 0
#define  GICD_ISACTIVE1_ACTIVE_MASK_SHIFT(reg) (((reg) & GICD_ISACTIVE1_ACTIVE_MASK) >> GICD_ISACTIVE1_ACTIVE_SHIFT)
#define  GICD_ISACTIVE1_ACTIVE_REPLACE_VAL(reg,val) (((reg) & ~GICD_ISACTIVE1_ACTIVE_MASK) | (((uint32_t)val) << GICD_ISACTIVE1_ACTIVE_SHIFT))

//====================================================================
//Register: GIC400 Distrubutor Set Active State Register (Instance 3 of 8) (ISACTIVE2)
/** \brief Controls GIC400 Set Active State Register (Instance 3 of 8)*/
//====================================================================

#define  GICD_ISACTIVE2_ACTIVE_MASK 0xffffffff
#define  GICD_ISACTIVE2_ACTIVE_SHIFT 0
#define  GICD_ISACTIVE2_ACTIVE_MASK_SHIFT(reg) (((reg) & GICD_ISACTIVE2_ACTIVE_MASK) >> GICD_ISACTIVE2_ACTIVE_SHIFT)
#define  GICD_ISACTIVE2_ACTIVE_REPLACE_VAL(reg,val) (((reg) & ~GICD_ISACTIVE2_ACTIVE_MASK) | (((uint32_t)val) << GICD_ISACTIVE2_ACTIVE_SHIFT))

//====================================================================
//Register: GIC400 Distrubutor Set Active State Register (Instance 4 of 8) (ISACTIVE3)
/** \brief Controls GIC400 Set Active State Register (Instance 4 of 8)*/
//====================================================================

#define  GICD_ISACTIVE3_ACTIVE_MASK 0xffffffff
#define  GICD_ISACTIVE3_ACTIVE_SHIFT 0
#define  GICD_ISACTIVE3_ACTIVE_MASK_SHIFT(reg) (((reg) & GICD_ISACTIVE3_ACTIVE_MASK) >> GICD_ISACTIVE3_ACTIVE_SHIFT)
#define  GICD_ISACTIVE3_ACTIVE_REPLACE_VAL(reg,val) (((reg) & ~GICD_ISACTIVE3_ACTIVE_MASK) | (((uint32_t)val) << GICD_ISACTIVE3_ACTIVE_SHIFT))

//====================================================================
//Register: GIC400 Distrubutor Set Active State Register (Instance 5 of 8) (ISACTIVE4)
/** \brief Controls GIC400 Set Active State Register (Instance 5 of 8)*/
//====================================================================

#define  GICD_ISACTIVE4_ACTIVE_MASK 0xffffffff
#define  GICD_ISACTIVE4_ACTIVE_SHIFT 0
#define  GICD_ISACTIVE4_ACTIVE_MASK_SHIFT(reg) (((reg) & GICD_ISACTIVE4_ACTIVE_MASK) >> GICD_ISACTIVE4_ACTIVE_SHIFT)
#define  GICD_ISACTIVE4_ACTIVE_REPLACE_VAL(reg,val) (((reg) & ~GICD_ISACTIVE4_ACTIVE_MASK) | (((uint32_t)val) << GICD_ISACTIVE4_ACTIVE_SHIFT))

//====================================================================
//Register: GIC400 Distrubutor Set Active State Register (Instance 6 of 8) (ISACTIVE5)
/** \brief Controls GIC400 Set Active State Register (Instance 6 of 8)*/
//====================================================================

#define  GICD_ISACTIVE5_ACTIVE_MASK 0xffffffff
#define  GICD_ISACTIVE5_ACTIVE_SHIFT 0
#define  GICD_ISACTIVE5_ACTIVE_MASK_SHIFT(reg) (((reg) & GICD_ISACTIVE5_ACTIVE_MASK) >> GICD_ISACTIVE5_ACTIVE_SHIFT)
#define  GICD_ISACTIVE5_ACTIVE_REPLACE_VAL(reg,val) (((reg) & ~GICD_ISACTIVE5_ACTIVE_MASK) | (((uint32_t)val) << GICD_ISACTIVE5_ACTIVE_SHIFT))

//====================================================================
//Register: GIC400 Distrubutor Set Active State Register (Instance 7 of 8) (ISACTIVE6)
/** \brief Controls GIC400 Set Active State Register (Instance 7 of 8)*/
//====================================================================

#define  GICD_ISACTIVE6_ACTIVE_MASK 0xffffffff
#define  GICD_ISACTIVE6_ACTIVE_SHIFT 0
#define  GICD_ISACTIVE6_ACTIVE_MASK_SHIFT(reg) (((reg) & GICD_ISACTIVE6_ACTIVE_MASK) >> GICD_ISACTIVE6_ACTIVE_SHIFT)
#define  GICD_ISACTIVE6_ACTIVE_REPLACE_VAL(reg,val) (((reg) & ~GICD_ISACTIVE6_ACTIVE_MASK) | (((uint32_t)val) << GICD_ISACTIVE6_ACTIVE_SHIFT))

//====================================================================
//Register: GIC400 Distrubutor Set Active State Register (Instance 8 of 8) (ISACTIVE7)
/** \brief Controls GIC400 Set Active State Register (Instance 8 of 8)*/
//====================================================================

#define  GICD_ISACTIVE7_ACTIVE_MASK 0xffffffff
#define  GICD_ISACTIVE7_ACTIVE_SHIFT 0
#define  GICD_ISACTIVE7_ACTIVE_MASK_SHIFT(reg) (((reg) & GICD_ISACTIVE7_ACTIVE_MASK) >> GICD_ISACTIVE7_ACTIVE_SHIFT)
#define  GICD_ISACTIVE7_ACTIVE_REPLACE_VAL(reg,val) (((reg) & ~GICD_ISACTIVE7_ACTIVE_MASK) | (((uint32_t)val) << GICD_ISACTIVE7_ACTIVE_SHIFT))

//====================================================================
//Register: GIC400 Distrubutor Clear Active State Register (Instance 1 of 8) (ICACTIVE0)
/** \brief Controls GIC400 Set Active State Register (Instance 1 of 8)*/
//====================================================================

#define  GICD_ICACTIVE0_ACTIVE_MASK 0xffffffff
#define  GICD_ICACTIVE0_ACTIVE_SHIFT 0
#define  GICD_ICACTIVE0_ACTIVE_MASK_SHIFT(reg) (((reg) & GICD_ICACTIVE0_ACTIVE_MASK) >> GICD_ICACTIVE0_ACTIVE_SHIFT)
#define  GICD_ICACTIVE0_ACTIVE_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICACTIVE0_ACTIVE_MASK) | (((uint32_t)val) << GICD_ICACTIVE0_ACTIVE_SHIFT))

//====================================================================
//Register: GIC400 Distrubutor Clear Active State Register (Instance 2 of 8) (ICACTIVE1)
/** \brief Controls GIC400 Set Active State Register (Instance 2 of 8)*/
//====================================================================

#define  GICD_ICACTIVE1_ACTIVE_MASK 0xffffffff
#define  GICD_ICACTIVE1_ACTIVE_SHIFT 0
#define  GICD_ICACTIVE1_ACTIVE_MASK_SHIFT(reg) (((reg) & GICD_ICACTIVE1_ACTIVE_MASK) >> GICD_ICACTIVE1_ACTIVE_SHIFT)
#define  GICD_ICACTIVE1_ACTIVE_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICACTIVE1_ACTIVE_MASK) | (((uint32_t)val) << GICD_ICACTIVE1_ACTIVE_SHIFT))

//====================================================================
//Register: GIC400 Distrubutor Clear Active State Register (Instance 3 of 8) (ICACTIVE2)
/** \brief Controls GIC400 Set Active State Register (Instance 3 of 8)*/
//====================================================================

#define  GICD_ICACTIVE2_ACTIVE_MASK 0xffffffff
#define  GICD_ICACTIVE2_ACTIVE_SHIFT 0
#define  GICD_ICACTIVE2_ACTIVE_MASK_SHIFT(reg) (((reg) & GICD_ICACTIVE2_ACTIVE_MASK) >> GICD_ICACTIVE2_ACTIVE_SHIFT)
#define  GICD_ICACTIVE2_ACTIVE_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICACTIVE2_ACTIVE_MASK) | (((uint32_t)val) << GICD_ICACTIVE2_ACTIVE_SHIFT))

//====================================================================
//Register: GIC400 Distrubutor Clear Active State Register (Instance 4 of 8) (ICACTIVE3)
/** \brief Controls GIC400 Set Active State Register (Instance 4 of 8)*/
//====================================================================

#define  GICD_ICACTIVE3_ACTIVE_MASK 0xffffffff
#define  GICD_ICACTIVE3_ACTIVE_SHIFT 0
#define  GICD_ICACTIVE3_ACTIVE_MASK_SHIFT(reg) (((reg) & GICD_ICACTIVE3_ACTIVE_MASK) >> GICD_ICACTIVE3_ACTIVE_SHIFT)
#define  GICD_ICACTIVE3_ACTIVE_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICACTIVE3_ACTIVE_MASK) | (((uint32_t)val) << GICD_ICACTIVE3_ACTIVE_SHIFT))

//====================================================================
//Register: GIC400 Distrubutor Clear Active State Register (Instance 5 of 8) (ICACTIVE4)
/** \brief Controls GIC400 Set Active State Register (Instance 5 of 8)*/
//====================================================================

#define  GICD_ICACTIVE4_ACTIVE_MASK 0xffffffff
#define  GICD_ICACTIVE4_ACTIVE_SHIFT 0
#define  GICD_ICACTIVE4_ACTIVE_MASK_SHIFT(reg) (((reg) & GICD_ICACTIVE4_ACTIVE_MASK) >> GICD_ICACTIVE4_ACTIVE_SHIFT)
#define  GICD_ICACTIVE4_ACTIVE_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICACTIVE4_ACTIVE_MASK) | (((uint32_t)val) << GICD_ICACTIVE4_ACTIVE_SHIFT))

//====================================================================
//Register: GIC400 Distrubutor Clear Active State Register (Instance 6 of 8) (ICACTIVE5)
/** \brief Controls GIC400 Set Active State Register (Instance 6 of 8)*/
//====================================================================

#define  GICD_ICACTIVE5_ACTIVE_MASK 0xffffffff
#define  GICD_ICACTIVE5_ACTIVE_SHIFT 0
#define  GICD_ICACTIVE5_ACTIVE_MASK_SHIFT(reg) (((reg) & GICD_ICACTIVE5_ACTIVE_MASK) >> GICD_ICACTIVE5_ACTIVE_SHIFT)
#define  GICD_ICACTIVE5_ACTIVE_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICACTIVE5_ACTIVE_MASK) | (((uint32_t)val) << GICD_ICACTIVE5_ACTIVE_SHIFT))

//====================================================================
//Register: GIC400 Distrubutor Clear Active State Register (Instance 7 of 8) (ICACTIVE6)
/** \brief Controls GIC400 Set Active State Register (Instance 7 of 8)*/
//====================================================================

#define  GICD_ICACTIVE6_ACTIVE_MASK 0xffffffff
#define  GICD_ICACTIVE6_ACTIVE_SHIFT 0
#define  GICD_ICACTIVE6_ACTIVE_MASK_SHIFT(reg) (((reg) & GICD_ICACTIVE6_ACTIVE_MASK) >> GICD_ICACTIVE6_ACTIVE_SHIFT)
#define  GICD_ICACTIVE6_ACTIVE_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICACTIVE6_ACTIVE_MASK) | (((uint32_t)val) << GICD_ICACTIVE6_ACTIVE_SHIFT))

//====================================================================
//Register: GIC400 Distrubutor Clear Active State Register (Instance 8 of 8) (ICACTIVE7)
/** \brief Controls GIC400 Set Active State Register (Instance 8 of 8)*/
//====================================================================

#define  GICD_ICACTIVE7_ACTIVE_MASK 0xffffffff
#define  GICD_ICACTIVE7_ACTIVE_SHIFT 0
#define  GICD_ICACTIVE7_ACTIVE_MASK_SHIFT(reg) (((reg) & GICD_ICACTIVE7_ACTIVE_MASK) >> GICD_ICACTIVE7_ACTIVE_SHIFT)
#define  GICD_ICACTIVE7_ACTIVE_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICACTIVE7_ACTIVE_MASK) | (((uint32_t)val) << GICD_ICACTIVE7_ACTIVE_SHIFT))

//====================================================================
//Register: GIC400 Distrubutor Set Active State Register (Instance 1 of 64) (IPRIORITY0)
/** \brief GIC400 Interrupt Priority Register (Instance 1 of 64)*/
//====================================================================

#define  GICD_IPRIORITY0_PRIORITY_MASK 0xffffffff
#define  GICD_IPRIORITY0_PRIORITY_SHIFT 0
#define  GICD_IPRIORITY0_PRIORITY_MASK_SHIFT(reg) (((reg) & GICD_IPRIORITY0_PRIORITY_MASK) >> GICD_IPRIORITY0_PRIORITY_SHIFT)
#define  GICD_IPRIORITY0_PRIORITY_REPLACE_VAL(reg,val) (((reg) & ~GICD_IPRIORITY0_PRIORITY_MASK) | (((uint32_t)val) << GICD_IPRIORITY0_PRIORITY_SHIFT))

//====================================================================
//Register: GIC400 Distrubutor Set Active State Register (Instance 2 of 64) (IPRIORITY1)
/** \brief GIC400 Interrupt Priority Register (Instance 2 of 64)*/
//====================================================================

#define  GICD_IPRIORITY1_PRIORITY_MASK 0xffffffff
#define  GICD_IPRIORITY1_PRIORITY_SHIFT 0
#define  GICD_IPRIORITY1_PRIORITY_MASK_SHIFT(reg) (((reg) & GICD_IPRIORITY1_PRIORITY_MASK) >> GICD_IPRIORITY1_PRIORITY_SHIFT)
#define  GICD_IPRIORITY1_PRIORITY_REPLACE_VAL(reg,val) (((reg) & ~GICD_IPRIORITY1_PRIORITY_MASK) | (((uint32_t)val) << GICD_IPRIORITY1_PRIORITY_SHIFT))

//====================================================================
//Register: GIC400 Distrubutor Set Active State Register (Instance 3 of 64) (IPRIORITY2)
/** \brief GIC400 Interrupt Priority Register (Instance 3 of 64)*/
//====================================================================

#define  GICD_IPRIORITY2_PRIORITY_MASK 0xffffffff
#define  GICD_IPRIORITY2_PRIORITY_SHIFT 0
#define  GICD_IPRIORITY2_PRIORITY_MASK_SHIFT(reg) (((reg) & GICD_IPRIORITY2_PRIORITY_MASK) >> GICD_IPRIORITY2_PRIORITY_SHIFT)
#define  GICD_IPRIORITY2_PRIORITY_REPLACE_VAL(reg,val) (((reg) & ~GICD_IPRIORITY2_PRIORITY_MASK) | (((uint32_t)val) << GICD_IPRIORITY2_PRIORITY_SHIFT))

//====================================================================
//Register: GIC400 Distrubutor Set Active State Register (Instance 4 of 64) (IPRIORITY3)
/** \brief GIC400 Interrupt Priority Register (Instance 4 of 64)*/
//====================================================================

#define  GICD_IPRIORITY3_PRIORITY_MASK 0xffffffff
#define  GICD_IPRIORITY3_PRIORITY_SHIFT 0
#define  GICD_IPRIORITY3_PRIORITY_MASK_SHIFT(reg) (((reg) & GICD_IPRIORITY3_PRIORITY_MASK) >> GICD_IPRIORITY3_PRIORITY_SHIFT)
#define  GICD_IPRIORITY3_PRIORITY_REPLACE_VAL(reg,val) (((reg) & ~GICD_IPRIORITY3_PRIORITY_MASK) | (((uint32_t)val) << GICD_IPRIORITY3_PRIORITY_SHIFT))

//====================================================================
//Register: GIC400 Distrubutor Set Active State Register (Instance 5 of 64) (IPRIORITY4)
/** \brief GIC400 Interrupt Priority Register (Instance 5 of 64)*/
//====================================================================

#define  GICD_IPRIORITY4_PRIORITY_MASK 0xffffffff
#define  GICD_IPRIORITY4_PRIORITY_SHIFT 0
#define  GICD_IPRIORITY4_PRIORITY_MASK_SHIFT(reg) (((reg) & GICD_IPRIORITY4_PRIORITY_MASK) >> GICD_IPRIORITY4_PRIORITY_SHIFT)
#define  GICD_IPRIORITY4_PRIORITY_REPLACE_VAL(reg,val) (((reg) & ~GICD_IPRIORITY4_PRIORITY_MASK) | (((uint32_t)val) << GICD_IPRIORITY4_PRIORITY_SHIFT))

//====================================================================
//Register: GIC400 Distrubutor Set Active State Register (Instance 6 of 64) (IPRIORITY5)
/** \brief GIC400 Interrupt Priority Register (Instance 6 of 64)*/
//====================================================================

#define  GICD_IPRIORITY5_PRIORITY_MASK 0xffffffff
#define  GICD_IPRIORITY5_PRIORITY_SHIFT 0
#define  GICD_IPRIORITY5_PRIORITY_MASK_SHIFT(reg) (((reg) & GICD_IPRIORITY5_PRIORITY_MASK) >> GICD_IPRIORITY5_PRIORITY_SHIFT)
#define  GICD_IPRIORITY5_PRIORITY_REPLACE_VAL(reg,val) (((reg) & ~GICD_IPRIORITY5_PRIORITY_MASK) | (((uint32_t)val) << GICD_IPRIORITY5_PRIORITY_SHIFT))

//====================================================================
//Register: GIC400 Distrubutor Set Active State Register (Instance 7 of 64) (IPRIORITY6)
/** \brief GIC400 Interrupt Priority Register (Instance 7 of 64)*/
//====================================================================

#define  GICD_IPRIORITY6_PRIORITY_MASK 0xffffffff
#define  GICD_IPRIORITY6_PRIORITY_SHIFT 0
#define  GICD_IPRIORITY6_PRIORITY_MASK_SHIFT(reg) (((reg) & GICD_IPRIORITY6_PRIORITY_MASK) >> GICD_IPRIORITY6_PRIORITY_SHIFT)
#define  GICD_IPRIORITY6_PRIORITY_REPLACE_VAL(reg,val) (((reg) & ~GICD_IPRIORITY6_PRIORITY_MASK) | (((uint32_t)val) << GICD_IPRIORITY6_PRIORITY_SHIFT))

//====================================================================
//Register: GIC400 Distrubutor Set Active State Register (Instance 8 of 64) (IPRIORITY7)
/** \brief GIC400 Interrupt Priority Register (Instance 8 of 64)*/
//====================================================================

#define  GICD_IPRIORITY7_PRIORITY_MASK 0xffffffff
#define  GICD_IPRIORITY7_PRIORITY_SHIFT 0
#define  GICD_IPRIORITY7_PRIORITY_MASK_SHIFT(reg) (((reg) & GICD_IPRIORITY7_PRIORITY_MASK) >> GICD_IPRIORITY7_PRIORITY_SHIFT)
#define  GICD_IPRIORITY7_PRIORITY_REPLACE_VAL(reg,val) (((reg) & ~GICD_IPRIORITY7_PRIORITY_MASK) | (((uint32_t)val) << GICD_IPRIORITY7_PRIORITY_SHIFT))

//====================================================================
//Register: GIC400 Distrubutor Set Active State Register (Instance 9 of 64) (IPRIORITY8)
/** \brief GIC400 Interrupt Priority Register (Instance 9 of 64)*/
//====================================================================

#define  GICD_IPRIORITY8_PRIORITY_MASK 0xffffffff
#define  GICD_IPRIORITY8_PRIORITY_SHIFT 0
#define  GICD_IPRIORITY8_PRIORITY_MASK_SHIFT(reg) (((reg) & GICD_IPRIORITY8_PRIORITY_MASK) >> GICD_IPRIORITY8_PRIORITY_SHIFT)
#define  GICD_IPRIORITY8_PRIORITY_REPLACE_VAL(reg,val) (((reg) & ~GICD_IPRIORITY8_PRIORITY_MASK) | (((uint32_t)val) << GICD_IPRIORITY8_PRIORITY_SHIFT))

//====================================================================
//Register: GIC400 Distrubutor Set Active State Register (Instance 10 of 64) (IPRIORITY9)
/** \brief GIC400 Interrupt Priority Register (Instance 10 of 64)*/
//====================================================================

#define  GICD_IPRIORITY9_PRIORITY_MASK 0xffffffff
#define  GICD_IPRIORITY9_PRIORITY_SHIFT 0
#define  GICD_IPRIORITY9_PRIORITY_MASK_SHIFT(reg) (((reg) & GICD_IPRIORITY9_PRIORITY_MASK) >> GICD_IPRIORITY9_PRIORITY_SHIFT)
#define  GICD_IPRIORITY9_PRIORITY_REPLACE_VAL(reg,val) (((reg) & ~GICD_IPRIORITY9_PRIORITY_MASK) | (((uint32_t)val) << GICD_IPRIORITY9_PRIORITY_SHIFT))

//====================================================================
//Register: GIC400 Distrubutor Set Active State Register (Instance 11 of 64) (IPRIORITY10)
/** \brief GIC400 Interrupt Priority Register (Instance 11 of 64)*/
//====================================================================

#define  GICD_IPRIORITY10_PRIORITY_MASK 0xffffffff
#define  GICD_IPRIORITY10_PRIORITY_SHIFT 0
#define  GICD_IPRIORITY10_PRIORITY_MASK_SHIFT(reg) (((reg) & GICD_IPRIORITY10_PRIORITY_MASK) >> GICD_IPRIORITY10_PRIORITY_SHIFT)
#define  GICD_IPRIORITY10_PRIORITY_REPLACE_VAL(reg,val) (((reg) & ~GICD_IPRIORITY10_PRIORITY_MASK) | (((uint32_t)val) << GICD_IPRIORITY10_PRIORITY_SHIFT))

//====================================================================
//Register: GIC400 Distrubutor Set Active State Register (Instance 12 of 64) (IPRIORITY11)
/** \brief GIC400 Interrupt Priority Register (Instance 12 of 64)*/
//====================================================================

#define  GICD_IPRIORITY11_PRIORITY_MASK 0xffffffff
#define  GICD_IPRIORITY11_PRIORITY_SHIFT 0
#define  GICD_IPRIORITY11_PRIORITY_MASK_SHIFT(reg) (((reg) & GICD_IPRIORITY11_PRIORITY_MASK) >> GICD_IPRIORITY11_PRIORITY_SHIFT)
#define  GICD_IPRIORITY11_PRIORITY_REPLACE_VAL(reg,val) (((reg) & ~GICD_IPRIORITY11_PRIORITY_MASK) | (((uint32_t)val) << GICD_IPRIORITY11_PRIORITY_SHIFT))

//====================================================================
//Register: GIC400 Distrubutor Set Active State Register (Instance 13 of 64) (IPRIORITY12)
/** \brief GIC400 Interrupt Priority Register (Instance 13 of 64)*/
//====================================================================

#define  GICD_IPRIORITY12_PRIORITY_MASK 0xffffffff
#define  GICD_IPRIORITY12_PRIORITY_SHIFT 0
#define  GICD_IPRIORITY12_PRIORITY_MASK_SHIFT(reg) (((reg) & GICD_IPRIORITY12_PRIORITY_MASK) >> GICD_IPRIORITY12_PRIORITY_SHIFT)
#define  GICD_IPRIORITY12_PRIORITY_REPLACE_VAL(reg,val) (((reg) & ~GICD_IPRIORITY12_PRIORITY_MASK) | (((uint32_t)val) << GICD_IPRIORITY12_PRIORITY_SHIFT))

//====================================================================
//Register: GIC400 Distrubutor Set Active State Register (Instance 14 of 64) (IPRIORITY13)
/** \brief GIC400 Interrupt Priority Register (Instance 14 of 64)*/
//====================================================================

#define  GICD_IPRIORITY13_PRIORITY_MASK 0xffffffff
#define  GICD_IPRIORITY13_PRIORITY_SHIFT 0
#define  GICD_IPRIORITY13_PRIORITY_MASK_SHIFT(reg) (((reg) & GICD_IPRIORITY13_PRIORITY_MASK) >> GICD_IPRIORITY13_PRIORITY_SHIFT)
#define  GICD_IPRIORITY13_PRIORITY_REPLACE_VAL(reg,val) (((reg) & ~GICD_IPRIORITY13_PRIORITY_MASK) | (((uint32_t)val) << GICD_IPRIORITY13_PRIORITY_SHIFT))

//====================================================================
//Register: GIC400 Distrubutor Set Active State Register (Instance 15 of 64) (IPRIORITY14)
/** \brief GIC400 Interrupt Priority Register (Instance 15 of 64)*/
//====================================================================

#define  GICD_IPRIORITY14_PRIORITY_MASK 0xffffffff
#define  GICD_IPRIORITY14_PRIORITY_SHIFT 0
#define  GICD_IPRIORITY14_PRIORITY_MASK_SHIFT(reg) (((reg) & GICD_IPRIORITY14_PRIORITY_MASK) >> GICD_IPRIORITY14_PRIORITY_SHIFT)
#define  GICD_IPRIORITY14_PRIORITY_REPLACE_VAL(reg,val) (((reg) & ~GICD_IPRIORITY14_PRIORITY_MASK) | (((uint32_t)val) << GICD_IPRIORITY14_PRIORITY_SHIFT))

//====================================================================
//Register: GIC400 Distrubutor Set Active State Register (Instance 16 of 64) (IPRIORITY15)
/** \brief GIC400 Interrupt Priority Register (Instance 16 of 64)*/
//====================================================================

#define  GICD_IPRIORITY15_PRIORITY_MASK 0xffffffff
#define  GICD_IPRIORITY15_PRIORITY_SHIFT 0
#define  GICD_IPRIORITY15_PRIORITY_MASK_SHIFT(reg) (((reg) & GICD_IPRIORITY15_PRIORITY_MASK) >> GICD_IPRIORITY15_PRIORITY_SHIFT)
#define  GICD_IPRIORITY15_PRIORITY_REPLACE_VAL(reg,val) (((reg) & ~GICD_IPRIORITY15_PRIORITY_MASK) | (((uint32_t)val) << GICD_IPRIORITY15_PRIORITY_SHIFT))

//====================================================================
//Register: GIC400 Distrubutor Set Active State Register (Instance 17 of 64) (IPRIORITY16)
/** \brief GIC400 Interrupt Priority Register (Instance 17 of 64)*/
//====================================================================

#define  GICD_IPRIORITY16_PRIORITY_MASK 0xffffffff
#define  GICD_IPRIORITY16_PRIORITY_SHIFT 0
#define  GICD_IPRIORITY16_PRIORITY_MASK_SHIFT(reg) (((reg) & GICD_IPRIORITY16_PRIORITY_MASK) >> GICD_IPRIORITY16_PRIORITY_SHIFT)
#define  GICD_IPRIORITY16_PRIORITY_REPLACE_VAL(reg,val) (((reg) & ~GICD_IPRIORITY16_PRIORITY_MASK) | (((uint32_t)val) << GICD_IPRIORITY16_PRIORITY_SHIFT))

//====================================================================
//Register: GIC400 Distrubutor Set Active State Register (Instance 18 of 64) (IPRIORITY17)
/** \brief GIC400 Interrupt Priority Register (Instance 18 of 64)*/
//====================================================================

#define  GICD_IPRIORITY17_PRIORITY_MASK 0xffffffff
#define  GICD_IPRIORITY17_PRIORITY_SHIFT 0
#define  GICD_IPRIORITY17_PRIORITY_MASK_SHIFT(reg) (((reg) & GICD_IPRIORITY17_PRIORITY_MASK) >> GICD_IPRIORITY17_PRIORITY_SHIFT)
#define  GICD_IPRIORITY17_PRIORITY_REPLACE_VAL(reg,val) (((reg) & ~GICD_IPRIORITY17_PRIORITY_MASK) | (((uint32_t)val) << GICD_IPRIORITY17_PRIORITY_SHIFT))

//====================================================================
//Register: GIC400 Distrubutor Set Active State Register (Instance 19 of 64) (IPRIORITY18)
/** \brief GIC400 Interrupt Priority Register (Instance 19 of 64)*/
//====================================================================

#define  GICD_IPRIORITY18_PRIORITY_MASK 0xffffffff
#define  GICD_IPRIORITY18_PRIORITY_SHIFT 0
#define  GICD_IPRIORITY18_PRIORITY_MASK_SHIFT(reg) (((reg) & GICD_IPRIORITY18_PRIORITY_MASK) >> GICD_IPRIORITY18_PRIORITY_SHIFT)
#define  GICD_IPRIORITY18_PRIORITY_REPLACE_VAL(reg,val) (((reg) & ~GICD_IPRIORITY18_PRIORITY_MASK) | (((uint32_t)val) << GICD_IPRIORITY18_PRIORITY_SHIFT))

//====================================================================
//Register: GIC400 Distrubutor Set Active State Register (Instance 20 of 64) (IPRIORITY19)
/** \brief GIC400 Interrupt Priority Register (Instance 20 of 64)*/
//====================================================================

#define  GICD_IPRIORITY19_PRIORITY_MASK 0xffffffff
#define  GICD_IPRIORITY19_PRIORITY_SHIFT 0
#define  GICD_IPRIORITY19_PRIORITY_MASK_SHIFT(reg) (((reg) & GICD_IPRIORITY19_PRIORITY_MASK) >> GICD_IPRIORITY19_PRIORITY_SHIFT)
#define  GICD_IPRIORITY19_PRIORITY_REPLACE_VAL(reg,val) (((reg) & ~GICD_IPRIORITY19_PRIORITY_MASK) | (((uint32_t)val) << GICD_IPRIORITY19_PRIORITY_SHIFT))

//====================================================================
//Register: GIC400 Distrubutor Set Active State Register (Instance 21 of 64) (IPRIORITY20)
/** \brief GIC400 Interrupt Priority Register (Instance 21 of 64)*/
//====================================================================

#define  GICD_IPRIORITY20_PRIORITY_MASK 0xffffffff
#define  GICD_IPRIORITY20_PRIORITY_SHIFT 0
#define  GICD_IPRIORITY20_PRIORITY_MASK_SHIFT(reg) (((reg) & GICD_IPRIORITY20_PRIORITY_MASK) >> GICD_IPRIORITY20_PRIORITY_SHIFT)
#define  GICD_IPRIORITY20_PRIORITY_REPLACE_VAL(reg,val) (((reg) & ~GICD_IPRIORITY20_PRIORITY_MASK) | (((uint32_t)val) << GICD_IPRIORITY20_PRIORITY_SHIFT))

//====================================================================
//Register: GIC400 Distrubutor Set Active State Register (Instance 22 of 64) (IPRIORITY21)
/** \brief GIC400 Interrupt Priority Register (Instance 22 of 64)*/
//====================================================================

#define  GICD_IPRIORITY21_PRIORITY_MASK 0xffffffff
#define  GICD_IPRIORITY21_PRIORITY_SHIFT 0
#define  GICD_IPRIORITY21_PRIORITY_MASK_SHIFT(reg) (((reg) & GICD_IPRIORITY21_PRIORITY_MASK) >> GICD_IPRIORITY21_PRIORITY_SHIFT)
#define  GICD_IPRIORITY21_PRIORITY_REPLACE_VAL(reg,val) (((reg) & ~GICD_IPRIORITY21_PRIORITY_MASK) | (((uint32_t)val) << GICD_IPRIORITY21_PRIORITY_SHIFT))

//====================================================================
//Register: GIC400 Distrubutor Set Active State Register (Instance 23 of 64) (IPRIORITY22)
/** \brief GIC400 Interrupt Priority Register (Instance 23 of 64)*/
//====================================================================

#define  GICD_IPRIORITY22_PRIORITY_MASK 0xffffffff
#define  GICD_IPRIORITY22_PRIORITY_SHIFT 0
#define  GICD_IPRIORITY22_PRIORITY_MASK_SHIFT(reg) (((reg) & GICD_IPRIORITY22_PRIORITY_MASK) >> GICD_IPRIORITY22_PRIORITY_SHIFT)
#define  GICD_IPRIORITY22_PRIORITY_REPLACE_VAL(reg,val) (((reg) & ~GICD_IPRIORITY22_PRIORITY_MASK) | (((uint32_t)val) << GICD_IPRIORITY22_PRIORITY_SHIFT))

//====================================================================
//Register: GIC400 Distrubutor Set Active State Register (Instance 24 of 64) (IPRIORITY23)
/** \brief GIC400 Interrupt Priority Register (Instance 24 of 64)*/
//====================================================================

#define  GICD_IPRIORITY23_PRIORITY_MASK 0xffffffff
#define  GICD_IPRIORITY23_PRIORITY_SHIFT 0
#define  GICD_IPRIORITY23_PRIORITY_MASK_SHIFT(reg) (((reg) & GICD_IPRIORITY23_PRIORITY_MASK) >> GICD_IPRIORITY23_PRIORITY_SHIFT)
#define  GICD_IPRIORITY23_PRIORITY_REPLACE_VAL(reg,val) (((reg) & ~GICD_IPRIORITY23_PRIORITY_MASK) | (((uint32_t)val) << GICD_IPRIORITY23_PRIORITY_SHIFT))

//====================================================================
//Register: GIC400 Distrubutor Set Active State Register (Instance 25 of 64) (IPRIORITY24)
/** \brief GIC400 Interrupt Priority Register (Instance 25 of 64)*/
//====================================================================

#define  GICD_IPRIORITY24_PRIORITY_MASK 0xffffffff
#define  GICD_IPRIORITY24_PRIORITY_SHIFT 0
#define  GICD_IPRIORITY24_PRIORITY_MASK_SHIFT(reg) (((reg) & GICD_IPRIORITY24_PRIORITY_MASK) >> GICD_IPRIORITY24_PRIORITY_SHIFT)
#define  GICD_IPRIORITY24_PRIORITY_REPLACE_VAL(reg,val) (((reg) & ~GICD_IPRIORITY24_PRIORITY_MASK) | (((uint32_t)val) << GICD_IPRIORITY24_PRIORITY_SHIFT))

//====================================================================
//Register: GIC400 Distrubutor Set Active State Register (Instance 26 of 64) (IPRIORITY25)
/** \brief GIC400 Interrupt Priority Register (Instance 26 of 64)*/
//====================================================================

#define  GICD_IPRIORITY25_PRIORITY_MASK 0xffffffff
#define  GICD_IPRIORITY25_PRIORITY_SHIFT 0
#define  GICD_IPRIORITY25_PRIORITY_MASK_SHIFT(reg) (((reg) & GICD_IPRIORITY25_PRIORITY_MASK) >> GICD_IPRIORITY25_PRIORITY_SHIFT)
#define  GICD_IPRIORITY25_PRIORITY_REPLACE_VAL(reg,val) (((reg) & ~GICD_IPRIORITY25_PRIORITY_MASK) | (((uint32_t)val) << GICD_IPRIORITY25_PRIORITY_SHIFT))

//====================================================================
//Register: GIC400 Distrubutor Set Active State Register (Instance 27 of 64) (IPRIORITY26)
/** \brief GIC400 Interrupt Priority Register (Instance 27 of 64)*/
//====================================================================

#define  GICD_IPRIORITY26_PRIORITY_MASK 0xffffffff
#define  GICD_IPRIORITY26_PRIORITY_SHIFT 0
#define  GICD_IPRIORITY26_PRIORITY_MASK_SHIFT(reg) (((reg) & GICD_IPRIORITY26_PRIORITY_MASK) >> GICD_IPRIORITY26_PRIORITY_SHIFT)
#define  GICD_IPRIORITY26_PRIORITY_REPLACE_VAL(reg,val) (((reg) & ~GICD_IPRIORITY26_PRIORITY_MASK) | (((uint32_t)val) << GICD_IPRIORITY26_PRIORITY_SHIFT))

//====================================================================
//Register: GIC400 Distrubutor Set Active State Register (Instance 28 of 64) (IPRIORITY27)
/** \brief GIC400 Interrupt Priority Register (Instance 28 of 64)*/
//====================================================================

#define  GICD_IPRIORITY27_PRIORITY_MASK 0xffffffff
#define  GICD_IPRIORITY27_PRIORITY_SHIFT 0
#define  GICD_IPRIORITY27_PRIORITY_MASK_SHIFT(reg) (((reg) & GICD_IPRIORITY27_PRIORITY_MASK) >> GICD_IPRIORITY27_PRIORITY_SHIFT)
#define  GICD_IPRIORITY27_PRIORITY_REPLACE_VAL(reg,val) (((reg) & ~GICD_IPRIORITY27_PRIORITY_MASK) | (((uint32_t)val) << GICD_IPRIORITY27_PRIORITY_SHIFT))

//====================================================================
//Register: GIC400 Distrubutor Set Active State Register (Instance 29 of 64) (IPRIORITY28)
/** \brief GIC400 Interrupt Priority Register (Instance 29 of 64)*/
//====================================================================

#define  GICD_IPRIORITY28_PRIORITY_MASK 0xffffffff
#define  GICD_IPRIORITY28_PRIORITY_SHIFT 0
#define  GICD_IPRIORITY28_PRIORITY_MASK_SHIFT(reg) (((reg) & GICD_IPRIORITY28_PRIORITY_MASK) >> GICD_IPRIORITY28_PRIORITY_SHIFT)
#define  GICD_IPRIORITY28_PRIORITY_REPLACE_VAL(reg,val) (((reg) & ~GICD_IPRIORITY28_PRIORITY_MASK) | (((uint32_t)val) << GICD_IPRIORITY28_PRIORITY_SHIFT))

//====================================================================
//Register: GIC400 Distrubutor Set Active State Register (Instance 30 of 64) (IPRIORITY29)
/** \brief GIC400 Interrupt Priority Register (Instance 30 of 64)*/
//====================================================================

#define  GICD_IPRIORITY29_PRIORITY_MASK 0xffffffff
#define  GICD_IPRIORITY29_PRIORITY_SHIFT 0
#define  GICD_IPRIORITY29_PRIORITY_MASK_SHIFT(reg) (((reg) & GICD_IPRIORITY29_PRIORITY_MASK) >> GICD_IPRIORITY29_PRIORITY_SHIFT)
#define  GICD_IPRIORITY29_PRIORITY_REPLACE_VAL(reg,val) (((reg) & ~GICD_IPRIORITY29_PRIORITY_MASK) | (((uint32_t)val) << GICD_IPRIORITY29_PRIORITY_SHIFT))

//====================================================================
//Register: GIC400 Distrubutor Set Active State Register (Instance 31 of 64) (IPRIORITY30)
/** \brief GIC400 Interrupt Priority Register (Instance 31 of 64)*/
//====================================================================

#define  GICD_IPRIORITY30_PRIORITY_MASK 0xffffffff
#define  GICD_IPRIORITY30_PRIORITY_SHIFT 0
#define  GICD_IPRIORITY30_PRIORITY_MASK_SHIFT(reg) (((reg) & GICD_IPRIORITY30_PRIORITY_MASK) >> GICD_IPRIORITY30_PRIORITY_SHIFT)
#define  GICD_IPRIORITY30_PRIORITY_REPLACE_VAL(reg,val) (((reg) & ~GICD_IPRIORITY30_PRIORITY_MASK) | (((uint32_t)val) << GICD_IPRIORITY30_PRIORITY_SHIFT))

//====================================================================
//Register: GIC400 Distrubutor Set Active State Register (Instance 32 of 64) (IPRIORITY31)
/** \brief GIC400 Interrupt Priority Register (Instance 32 of 64)*/
//====================================================================

#define  GICD_IPRIORITY31_PRIORITY_MASK 0xffffffff
#define  GICD_IPRIORITY31_PRIORITY_SHIFT 0
#define  GICD_IPRIORITY31_PRIORITY_MASK_SHIFT(reg) (((reg) & GICD_IPRIORITY31_PRIORITY_MASK) >> GICD_IPRIORITY31_PRIORITY_SHIFT)
#define  GICD_IPRIORITY31_PRIORITY_REPLACE_VAL(reg,val) (((reg) & ~GICD_IPRIORITY31_PRIORITY_MASK) | (((uint32_t)val) << GICD_IPRIORITY31_PRIORITY_SHIFT))

//====================================================================
//Register: GIC400 Distrubutor Set Active State Register (Instance 33 of 64) (IPRIORITY32)
/** \brief GIC400 Interrupt Priority Register (Instance 33 of 64)*/
//====================================================================

#define  GICD_IPRIORITY32_PRIORITY_MASK 0xffffffff
#define  GICD_IPRIORITY32_PRIORITY_SHIFT 0
#define  GICD_IPRIORITY32_PRIORITY_MASK_SHIFT(reg) (((reg) & GICD_IPRIORITY32_PRIORITY_MASK) >> GICD_IPRIORITY32_PRIORITY_SHIFT)
#define  GICD_IPRIORITY32_PRIORITY_REPLACE_VAL(reg,val) (((reg) & ~GICD_IPRIORITY32_PRIORITY_MASK) | (((uint32_t)val) << GICD_IPRIORITY32_PRIORITY_SHIFT))

//====================================================================
//Register: GIC400 Distrubutor Set Active State Register (Instance 34 of 64) (IPRIORITY33)
/** \brief GIC400 Interrupt Priority Register (Instance 34 of 64)*/
//====================================================================

#define  GICD_IPRIORITY33_PRIORITY_MASK 0xffffffff
#define  GICD_IPRIORITY33_PRIORITY_SHIFT 0
#define  GICD_IPRIORITY33_PRIORITY_MASK_SHIFT(reg) (((reg) & GICD_IPRIORITY33_PRIORITY_MASK) >> GICD_IPRIORITY33_PRIORITY_SHIFT)
#define  GICD_IPRIORITY33_PRIORITY_REPLACE_VAL(reg,val) (((reg) & ~GICD_IPRIORITY33_PRIORITY_MASK) | (((uint32_t)val) << GICD_IPRIORITY33_PRIORITY_SHIFT))

//====================================================================
//Register: GIC400 Distrubutor Set Active State Register (Instance 35 of 64) (IPRIORITY34)
/** \brief GIC400 Interrupt Priority Register (Instance 35 of 64)*/
//====================================================================

#define  GICD_IPRIORITY34_PRIORITY_MASK 0xffffffff
#define  GICD_IPRIORITY34_PRIORITY_SHIFT 0
#define  GICD_IPRIORITY34_PRIORITY_MASK_SHIFT(reg) (((reg) & GICD_IPRIORITY34_PRIORITY_MASK) >> GICD_IPRIORITY34_PRIORITY_SHIFT)
#define  GICD_IPRIORITY34_PRIORITY_REPLACE_VAL(reg,val) (((reg) & ~GICD_IPRIORITY34_PRIORITY_MASK) | (((uint32_t)val) << GICD_IPRIORITY34_PRIORITY_SHIFT))

//====================================================================
//Register: GIC400 Distrubutor Set Active State Register (Instance 36 of 64) (IPRIORITY35)
/** \brief GIC400 Interrupt Priority Register (Instance 36 of 64)*/
//====================================================================

#define  GICD_IPRIORITY35_PRIORITY_MASK 0xffffffff
#define  GICD_IPRIORITY35_PRIORITY_SHIFT 0
#define  GICD_IPRIORITY35_PRIORITY_MASK_SHIFT(reg) (((reg) & GICD_IPRIORITY35_PRIORITY_MASK) >> GICD_IPRIORITY35_PRIORITY_SHIFT)
#define  GICD_IPRIORITY35_PRIORITY_REPLACE_VAL(reg,val) (((reg) & ~GICD_IPRIORITY35_PRIORITY_MASK) | (((uint32_t)val) << GICD_IPRIORITY35_PRIORITY_SHIFT))

//====================================================================
//Register: GIC400 Distrubutor Set Active State Register (Instance 37 of 64) (IPRIORITY36)
/** \brief GIC400 Interrupt Priority Register (Instance 37 of 64)*/
//====================================================================

#define  GICD_IPRIORITY36_PRIORITY_MASK 0xffffffff
#define  GICD_IPRIORITY36_PRIORITY_SHIFT 0
#define  GICD_IPRIORITY36_PRIORITY_MASK_SHIFT(reg) (((reg) & GICD_IPRIORITY36_PRIORITY_MASK) >> GICD_IPRIORITY36_PRIORITY_SHIFT)
#define  GICD_IPRIORITY36_PRIORITY_REPLACE_VAL(reg,val) (((reg) & ~GICD_IPRIORITY36_PRIORITY_MASK) | (((uint32_t)val) << GICD_IPRIORITY36_PRIORITY_SHIFT))

//====================================================================
//Register: GIC400 Distrubutor Set Active State Register (Instance 38 of 64) (IPRIORITY37)
/** \brief GIC400 Interrupt Priority Register (Instance 38 of 64)*/
//====================================================================

#define  GICD_IPRIORITY37_PRIORITY_MASK 0xffffffff
#define  GICD_IPRIORITY37_PRIORITY_SHIFT 0
#define  GICD_IPRIORITY37_PRIORITY_MASK_SHIFT(reg) (((reg) & GICD_IPRIORITY37_PRIORITY_MASK) >> GICD_IPRIORITY37_PRIORITY_SHIFT)
#define  GICD_IPRIORITY37_PRIORITY_REPLACE_VAL(reg,val) (((reg) & ~GICD_IPRIORITY37_PRIORITY_MASK) | (((uint32_t)val) << GICD_IPRIORITY37_PRIORITY_SHIFT))

//====================================================================
//Register: GIC400 Distrubutor Set Active State Register (Instance 39 of 64) (IPRIORITY38)
/** \brief GIC400 Interrupt Priority Register (Instance 39 of 64)*/
//====================================================================

#define  GICD_IPRIORITY38_PRIORITY_MASK 0xffffffff
#define  GICD_IPRIORITY38_PRIORITY_SHIFT 0
#define  GICD_IPRIORITY38_PRIORITY_MASK_SHIFT(reg) (((reg) & GICD_IPRIORITY38_PRIORITY_MASK) >> GICD_IPRIORITY38_PRIORITY_SHIFT)
#define  GICD_IPRIORITY38_PRIORITY_REPLACE_VAL(reg,val) (((reg) & ~GICD_IPRIORITY38_PRIORITY_MASK) | (((uint32_t)val) << GICD_IPRIORITY38_PRIORITY_SHIFT))

//====================================================================
//Register: GIC400 Distrubutor Set Active State Register (Instance 40 of 64) (IPRIORITY39)
/** \brief GIC400 Interrupt Priority Register (Instance 40 of 64)*/
//====================================================================

#define  GICD_IPRIORITY39_PRIORITY_MASK 0xffffffff
#define  GICD_IPRIORITY39_PRIORITY_SHIFT 0
#define  GICD_IPRIORITY39_PRIORITY_MASK_SHIFT(reg) (((reg) & GICD_IPRIORITY39_PRIORITY_MASK) >> GICD_IPRIORITY39_PRIORITY_SHIFT)
#define  GICD_IPRIORITY39_PRIORITY_REPLACE_VAL(reg,val) (((reg) & ~GICD_IPRIORITY39_PRIORITY_MASK) | (((uint32_t)val) << GICD_IPRIORITY39_PRIORITY_SHIFT))

//====================================================================
//Register: GIC400 Distrubutor Set Active State Register (Instance 41 of 64) (IPRIORITY40)
/** \brief GIC400 Interrupt Priority Register (Instance 41 of 64)*/
//====================================================================

#define  GICD_IPRIORITY40_PRIORITY_MASK 0xffffffff
#define  GICD_IPRIORITY40_PRIORITY_SHIFT 0
#define  GICD_IPRIORITY40_PRIORITY_MASK_SHIFT(reg) (((reg) & GICD_IPRIORITY40_PRIORITY_MASK) >> GICD_IPRIORITY40_PRIORITY_SHIFT)
#define  GICD_IPRIORITY40_PRIORITY_REPLACE_VAL(reg,val) (((reg) & ~GICD_IPRIORITY40_PRIORITY_MASK) | (((uint32_t)val) << GICD_IPRIORITY40_PRIORITY_SHIFT))

//====================================================================
//Register: GIC400 Distrubutor Set Active State Register (Instance 42 of 64) (IPRIORITY41)
/** \brief GIC400 Interrupt Priority Register (Instance 42 of 64)*/
//====================================================================

#define  GICD_IPRIORITY41_PRIORITY_MASK 0xffffffff
#define  GICD_IPRIORITY41_PRIORITY_SHIFT 0
#define  GICD_IPRIORITY41_PRIORITY_MASK_SHIFT(reg) (((reg) & GICD_IPRIORITY41_PRIORITY_MASK) >> GICD_IPRIORITY41_PRIORITY_SHIFT)
#define  GICD_IPRIORITY41_PRIORITY_REPLACE_VAL(reg,val) (((reg) & ~GICD_IPRIORITY41_PRIORITY_MASK) | (((uint32_t)val) << GICD_IPRIORITY41_PRIORITY_SHIFT))

//====================================================================
//Register: GIC400 Distrubutor Set Active State Register (Instance 43 of 64) (IPRIORITY42)
/** \brief GIC400 Interrupt Priority Register (Instance 43 of 64)*/
//====================================================================

#define  GICD_IPRIORITY42_PRIORITY_MASK 0xffffffff
#define  GICD_IPRIORITY42_PRIORITY_SHIFT 0
#define  GICD_IPRIORITY42_PRIORITY_MASK_SHIFT(reg) (((reg) & GICD_IPRIORITY42_PRIORITY_MASK) >> GICD_IPRIORITY42_PRIORITY_SHIFT)
#define  GICD_IPRIORITY42_PRIORITY_REPLACE_VAL(reg,val) (((reg) & ~GICD_IPRIORITY42_PRIORITY_MASK) | (((uint32_t)val) << GICD_IPRIORITY42_PRIORITY_SHIFT))

//====================================================================
//Register: GIC400 Distrubutor Set Active State Register (Instance 44 of 64) (IPRIORITY43)
/** \brief GIC400 Interrupt Priority Register (Instance 44 of 64)*/
//====================================================================

#define  GICD_IPRIORITY43_PRIORITY_MASK 0xffffffff
#define  GICD_IPRIORITY43_PRIORITY_SHIFT 0
#define  GICD_IPRIORITY43_PRIORITY_MASK_SHIFT(reg) (((reg) & GICD_IPRIORITY43_PRIORITY_MASK) >> GICD_IPRIORITY43_PRIORITY_SHIFT)
#define  GICD_IPRIORITY43_PRIORITY_REPLACE_VAL(reg,val) (((reg) & ~GICD_IPRIORITY43_PRIORITY_MASK) | (((uint32_t)val) << GICD_IPRIORITY43_PRIORITY_SHIFT))

//====================================================================
//Register: GIC400 Distrubutor Set Active State Register (Instance 45 of 64) (IPRIORITY44)
/** \brief GIC400 Interrupt Priority Register (Instance 45 of 64)*/
//====================================================================

#define  GICD_IPRIORITY44_PRIORITY_MASK 0xffffffff
#define  GICD_IPRIORITY44_PRIORITY_SHIFT 0
#define  GICD_IPRIORITY44_PRIORITY_MASK_SHIFT(reg) (((reg) & GICD_IPRIORITY44_PRIORITY_MASK) >> GICD_IPRIORITY44_PRIORITY_SHIFT)
#define  GICD_IPRIORITY44_PRIORITY_REPLACE_VAL(reg,val) (((reg) & ~GICD_IPRIORITY44_PRIORITY_MASK) | (((uint32_t)val) << GICD_IPRIORITY44_PRIORITY_SHIFT))

//====================================================================
//Register: GIC400 Distrubutor Set Active State Register (Instance 46 of 64) (IPRIORITY45)
/** \brief GIC400 Interrupt Priority Register (Instance 46 of 64)*/
//====================================================================

#define  GICD_IPRIORITY45_PRIORITY_MASK 0xffffffff
#define  GICD_IPRIORITY45_PRIORITY_SHIFT 0
#define  GICD_IPRIORITY45_PRIORITY_MASK_SHIFT(reg) (((reg) & GICD_IPRIORITY45_PRIORITY_MASK) >> GICD_IPRIORITY45_PRIORITY_SHIFT)
#define  GICD_IPRIORITY45_PRIORITY_REPLACE_VAL(reg,val) (((reg) & ~GICD_IPRIORITY45_PRIORITY_MASK) | (((uint32_t)val) << GICD_IPRIORITY45_PRIORITY_SHIFT))

//====================================================================
//Register: GIC400 Distrubutor Set Active State Register (Instance 47 of 64) (IPRIORITY46)
/** \brief GIC400 Interrupt Priority Register (Instance 47 of 64)*/
//====================================================================

#define  GICD_IPRIORITY46_PRIORITY_MASK 0xffffffff
#define  GICD_IPRIORITY46_PRIORITY_SHIFT 0
#define  GICD_IPRIORITY46_PRIORITY_MASK_SHIFT(reg) (((reg) & GICD_IPRIORITY46_PRIORITY_MASK) >> GICD_IPRIORITY46_PRIORITY_SHIFT)
#define  GICD_IPRIORITY46_PRIORITY_REPLACE_VAL(reg,val) (((reg) & ~GICD_IPRIORITY46_PRIORITY_MASK) | (((uint32_t)val) << GICD_IPRIORITY46_PRIORITY_SHIFT))

//====================================================================
//Register: GIC400 Distrubutor Set Active State Register (Instance 48 of 64) (IPRIORITY47)
/** \brief GIC400 Interrupt Priority Register (Instance 48 of 64)*/
//====================================================================

#define  GICD_IPRIORITY47_PRIORITY_MASK 0xffffffff
#define  GICD_IPRIORITY47_PRIORITY_SHIFT 0
#define  GICD_IPRIORITY47_PRIORITY_MASK_SHIFT(reg) (((reg) & GICD_IPRIORITY47_PRIORITY_MASK) >> GICD_IPRIORITY47_PRIORITY_SHIFT)
#define  GICD_IPRIORITY47_PRIORITY_REPLACE_VAL(reg,val) (((reg) & ~GICD_IPRIORITY47_PRIORITY_MASK) | (((uint32_t)val) << GICD_IPRIORITY47_PRIORITY_SHIFT))

//====================================================================
//Register: GIC400 Distrubutor Set Active State Register (Instance 49 of 64) (IPRIORITY48)
/** \brief GIC400 Interrupt Priority Register (Instance 49 of 64)*/
//====================================================================

#define  GICD_IPRIORITY48_PRIORITY_MASK 0xffffffff
#define  GICD_IPRIORITY48_PRIORITY_SHIFT 0
#define  GICD_IPRIORITY48_PRIORITY_MASK_SHIFT(reg) (((reg) & GICD_IPRIORITY48_PRIORITY_MASK) >> GICD_IPRIORITY48_PRIORITY_SHIFT)
#define  GICD_IPRIORITY48_PRIORITY_REPLACE_VAL(reg,val) (((reg) & ~GICD_IPRIORITY48_PRIORITY_MASK) | (((uint32_t)val) << GICD_IPRIORITY48_PRIORITY_SHIFT))

//====================================================================
//Register: GIC400 Distrubutor Set Active State Register (Instance 50 of 64) (IPRIORITY49)
/** \brief GIC400 Interrupt Priority Register (Instance 50 of 64)*/
//====================================================================

#define  GICD_IPRIORITY49_PRIORITY_MASK 0xffffffff
#define  GICD_IPRIORITY49_PRIORITY_SHIFT 0
#define  GICD_IPRIORITY49_PRIORITY_MASK_SHIFT(reg) (((reg) & GICD_IPRIORITY49_PRIORITY_MASK) >> GICD_IPRIORITY49_PRIORITY_SHIFT)
#define  GICD_IPRIORITY49_PRIORITY_REPLACE_VAL(reg,val) (((reg) & ~GICD_IPRIORITY49_PRIORITY_MASK) | (((uint32_t)val) << GICD_IPRIORITY49_PRIORITY_SHIFT))

//====================================================================
//Register: GIC400 Distrubutor Set Active State Register (Instance 51 of 64) (IPRIORITY50)
/** \brief GIC400 Interrupt Priority Register (Instance 51 of 64)*/
//====================================================================

#define  GICD_IPRIORITY50_PRIORITY_MASK 0xffffffff
#define  GICD_IPRIORITY50_PRIORITY_SHIFT 0
#define  GICD_IPRIORITY50_PRIORITY_MASK_SHIFT(reg) (((reg) & GICD_IPRIORITY50_PRIORITY_MASK) >> GICD_IPRIORITY50_PRIORITY_SHIFT)
#define  GICD_IPRIORITY50_PRIORITY_REPLACE_VAL(reg,val) (((reg) & ~GICD_IPRIORITY50_PRIORITY_MASK) | (((uint32_t)val) << GICD_IPRIORITY50_PRIORITY_SHIFT))

//====================================================================
//Register: GIC400 Distrubutor Set Active State Register (Instance 52 of 64) (IPRIORITY51)
/** \brief GIC400 Interrupt Priority Register (Instance 52 of 64)*/
//====================================================================

#define  GICD_IPRIORITY51_PRIORITY_MASK 0xffffffff
#define  GICD_IPRIORITY51_PRIORITY_SHIFT 0
#define  GICD_IPRIORITY51_PRIORITY_MASK_SHIFT(reg) (((reg) & GICD_IPRIORITY51_PRIORITY_MASK) >> GICD_IPRIORITY51_PRIORITY_SHIFT)
#define  GICD_IPRIORITY51_PRIORITY_REPLACE_VAL(reg,val) (((reg) & ~GICD_IPRIORITY51_PRIORITY_MASK) | (((uint32_t)val) << GICD_IPRIORITY51_PRIORITY_SHIFT))

//====================================================================
//Register: GIC400 Distrubutor Set Active State Register (Instance 53 of 64) (IPRIORITY52)
/** \brief GIC400 Interrupt Priority Register (Instance 53 of 64)*/
//====================================================================

#define  GICD_IPRIORITY52_PRIORITY_MASK 0xffffffff
#define  GICD_IPRIORITY52_PRIORITY_SHIFT 0
#define  GICD_IPRIORITY52_PRIORITY_MASK_SHIFT(reg) (((reg) & GICD_IPRIORITY52_PRIORITY_MASK) >> GICD_IPRIORITY52_PRIORITY_SHIFT)
#define  GICD_IPRIORITY52_PRIORITY_REPLACE_VAL(reg,val) (((reg) & ~GICD_IPRIORITY52_PRIORITY_MASK) | (((uint32_t)val) << GICD_IPRIORITY52_PRIORITY_SHIFT))

//====================================================================
//Register: GIC400 Distrubutor Set Active State Register (Instance 54 of 64) (IPRIORITY53)
/** \brief GIC400 Interrupt Priority Register (Instance 54 of 64)*/
//====================================================================

#define  GICD_IPRIORITY53_PRIORITY_MASK 0xffffffff
#define  GICD_IPRIORITY53_PRIORITY_SHIFT 0
#define  GICD_IPRIORITY53_PRIORITY_MASK_SHIFT(reg) (((reg) & GICD_IPRIORITY53_PRIORITY_MASK) >> GICD_IPRIORITY53_PRIORITY_SHIFT)
#define  GICD_IPRIORITY53_PRIORITY_REPLACE_VAL(reg,val) (((reg) & ~GICD_IPRIORITY53_PRIORITY_MASK) | (((uint32_t)val) << GICD_IPRIORITY53_PRIORITY_SHIFT))

//====================================================================
//Register: GIC400 Distrubutor Set Active State Register (Instance 55 of 64) (IPRIORITY54)
/** \brief GIC400 Interrupt Priority Register (Instance 55 of 64)*/
//====================================================================

#define  GICD_IPRIORITY54_PRIORITY_MASK 0xffffffff
#define  GICD_IPRIORITY54_PRIORITY_SHIFT 0
#define  GICD_IPRIORITY54_PRIORITY_MASK_SHIFT(reg) (((reg) & GICD_IPRIORITY54_PRIORITY_MASK) >> GICD_IPRIORITY54_PRIORITY_SHIFT)
#define  GICD_IPRIORITY54_PRIORITY_REPLACE_VAL(reg,val) (((reg) & ~GICD_IPRIORITY54_PRIORITY_MASK) | (((uint32_t)val) << GICD_IPRIORITY54_PRIORITY_SHIFT))

//====================================================================
//Register: GIC400 Distrubutor Set Active State Register (Instance 56 of 64) (IPRIORITY55)
/** \brief GIC400 Interrupt Priority Register (Instance 56 of 64)*/
//====================================================================

#define  GICD_IPRIORITY55_PRIORITY_MASK 0xffffffff
#define  GICD_IPRIORITY55_PRIORITY_SHIFT 0
#define  GICD_IPRIORITY55_PRIORITY_MASK_SHIFT(reg) (((reg) & GICD_IPRIORITY55_PRIORITY_MASK) >> GICD_IPRIORITY55_PRIORITY_SHIFT)
#define  GICD_IPRIORITY55_PRIORITY_REPLACE_VAL(reg,val) (((reg) & ~GICD_IPRIORITY55_PRIORITY_MASK) | (((uint32_t)val) << GICD_IPRIORITY55_PRIORITY_SHIFT))

//====================================================================
//Register: GIC400 Distrubutor Set Active State Register (Instance 57 of 64) (IPRIORITY56)
/** \brief GIC400 Interrupt Priority Register (Instance 57 of 64)*/
//====================================================================

#define  GICD_IPRIORITY56_PRIORITY_MASK 0xffffffff
#define  GICD_IPRIORITY56_PRIORITY_SHIFT 0
#define  GICD_IPRIORITY56_PRIORITY_MASK_SHIFT(reg) (((reg) & GICD_IPRIORITY56_PRIORITY_MASK) >> GICD_IPRIORITY56_PRIORITY_SHIFT)
#define  GICD_IPRIORITY56_PRIORITY_REPLACE_VAL(reg,val) (((reg) & ~GICD_IPRIORITY56_PRIORITY_MASK) | (((uint32_t)val) << GICD_IPRIORITY56_PRIORITY_SHIFT))

//====================================================================
//Register: GIC400 Distrubutor Set Active State Register (Instance 58 of 64) (IPRIORITY57)
/** \brief GIC400 Interrupt Priority Register (Instance 58 of 64)*/
//====================================================================

#define  GICD_IPRIORITY57_PRIORITY_MASK 0xffffffff
#define  GICD_IPRIORITY57_PRIORITY_SHIFT 0
#define  GICD_IPRIORITY57_PRIORITY_MASK_SHIFT(reg) (((reg) & GICD_IPRIORITY57_PRIORITY_MASK) >> GICD_IPRIORITY57_PRIORITY_SHIFT)
#define  GICD_IPRIORITY57_PRIORITY_REPLACE_VAL(reg,val) (((reg) & ~GICD_IPRIORITY57_PRIORITY_MASK) | (((uint32_t)val) << GICD_IPRIORITY57_PRIORITY_SHIFT))

//====================================================================
//Register: GIC400 Distrubutor Set Active State Register (Instance 59 of 64) (IPRIORITY58)
/** \brief GIC400 Interrupt Priority Register (Instance 59 of 64)*/
//====================================================================

#define  GICD_IPRIORITY58_PRIORITY_MASK 0xffffffff
#define  GICD_IPRIORITY58_PRIORITY_SHIFT 0
#define  GICD_IPRIORITY58_PRIORITY_MASK_SHIFT(reg) (((reg) & GICD_IPRIORITY58_PRIORITY_MASK) >> GICD_IPRIORITY58_PRIORITY_SHIFT)
#define  GICD_IPRIORITY58_PRIORITY_REPLACE_VAL(reg,val) (((reg) & ~GICD_IPRIORITY58_PRIORITY_MASK) | (((uint32_t)val) << GICD_IPRIORITY58_PRIORITY_SHIFT))

//====================================================================
//Register: GIC400 Distrubutor Set Active State Register (Instance 60 of 64) (IPRIORITY59)
/** \brief GIC400 Interrupt Priority Register (Instance 60 of 64)*/
//====================================================================

#define  GICD_IPRIORITY59_PRIORITY_MASK 0xffffffff
#define  GICD_IPRIORITY59_PRIORITY_SHIFT 0
#define  GICD_IPRIORITY59_PRIORITY_MASK_SHIFT(reg) (((reg) & GICD_IPRIORITY59_PRIORITY_MASK) >> GICD_IPRIORITY59_PRIORITY_SHIFT)
#define  GICD_IPRIORITY59_PRIORITY_REPLACE_VAL(reg,val) (((reg) & ~GICD_IPRIORITY59_PRIORITY_MASK) | (((uint32_t)val) << GICD_IPRIORITY59_PRIORITY_SHIFT))

//====================================================================
//Register: GIC400 Distrubutor Set Active State Register (Instance 61 of 64) (IPRIORITY60)
/** \brief GIC400 Interrupt Priority Register (Instance 61 of 64)*/
//====================================================================

#define  GICD_IPRIORITY60_PRIORITY_MASK 0xffffffff
#define  GICD_IPRIORITY60_PRIORITY_SHIFT 0
#define  GICD_IPRIORITY60_PRIORITY_MASK_SHIFT(reg) (((reg) & GICD_IPRIORITY60_PRIORITY_MASK) >> GICD_IPRIORITY60_PRIORITY_SHIFT)
#define  GICD_IPRIORITY60_PRIORITY_REPLACE_VAL(reg,val) (((reg) & ~GICD_IPRIORITY60_PRIORITY_MASK) | (((uint32_t)val) << GICD_IPRIORITY60_PRIORITY_SHIFT))

//====================================================================
//Register: GIC400 Distrubutor Set Active State Register (Instance 62 of 64) (IPRIORITY61)
/** \brief GIC400 Interrupt Priority Register (Instance 62 of 64)*/
//====================================================================

#define  GICD_IPRIORITY61_PRIORITY_MASK 0xffffffff
#define  GICD_IPRIORITY61_PRIORITY_SHIFT 0
#define  GICD_IPRIORITY61_PRIORITY_MASK_SHIFT(reg) (((reg) & GICD_IPRIORITY61_PRIORITY_MASK) >> GICD_IPRIORITY61_PRIORITY_SHIFT)
#define  GICD_IPRIORITY61_PRIORITY_REPLACE_VAL(reg,val) (((reg) & ~GICD_IPRIORITY61_PRIORITY_MASK) | (((uint32_t)val) << GICD_IPRIORITY61_PRIORITY_SHIFT))

//====================================================================
//Register: GIC400 Distrubutor Set Active State Register (Instance 63 of 64) (IPRIORITY62)
/** \brief GIC400 Interrupt Priority Register (Instance 63 of 64)*/
//====================================================================

#define  GICD_IPRIORITY62_PRIORITY_MASK 0xffffffff
#define  GICD_IPRIORITY62_PRIORITY_SHIFT 0
#define  GICD_IPRIORITY62_PRIORITY_MASK_SHIFT(reg) (((reg) & GICD_IPRIORITY62_PRIORITY_MASK) >> GICD_IPRIORITY62_PRIORITY_SHIFT)
#define  GICD_IPRIORITY62_PRIORITY_REPLACE_VAL(reg,val) (((reg) & ~GICD_IPRIORITY62_PRIORITY_MASK) | (((uint32_t)val) << GICD_IPRIORITY62_PRIORITY_SHIFT))

//====================================================================
//Register: GIC400 Distrubutor Set Active State Register (Instance 64 of 64) (IPRIORITY63)
/** \brief GIC400 Interrupt Priority Register (Instance 64 of 64)*/
//====================================================================

#define  GICD_IPRIORITY63_PRIORITY_MASK 0xffffffff
#define  GICD_IPRIORITY63_PRIORITY_SHIFT 0
#define  GICD_IPRIORITY63_PRIORITY_MASK_SHIFT(reg) (((reg) & GICD_IPRIORITY63_PRIORITY_MASK) >> GICD_IPRIORITY63_PRIORITY_SHIFT)
#define  GICD_IPRIORITY63_PRIORITY_REPLACE_VAL(reg,val) (((reg) & ~GICD_IPRIORITY63_PRIORITY_MASK) | (((uint32_t)val) << GICD_IPRIORITY63_PRIORITY_SHIFT))

//====================================================================
//Register: GIC400 Interrupt Target Processor Register (Instance 1 of 64) (ITARGETS0)
/** \brief GIC400 Interrupt Target Processor Register (Instance 1 of 64)*/
//====================================================================

#define  GICD_ITARGETS0_TARGET_MASK 0xffffffff
#define  GICD_ITARGETS0_TARGET_SHIFT 0
#define  GICD_ITARGETS0_TARGET_MASK_SHIFT(reg) (((reg) & GICD_ITARGETS0_TARGET_MASK) >> GICD_ITARGETS0_TARGET_SHIFT)
#define  GICD_ITARGETS0_TARGET_REPLACE_VAL(reg,val) (((reg) & ~GICD_ITARGETS0_TARGET_MASK) | (((uint32_t)val) << GICD_ITARGETS0_TARGET_SHIFT))

//====================================================================
//Register: GIC400 Interrupt Target Processor Register (Instance 2 of 64) (ITARGETS1)
/** \brief GIC400 Interrupt Target Processor Register (Instance 2 of 64)*/
//====================================================================

#define  GICD_ITARGETS1_TARGET_MASK 0xffffffff
#define  GICD_ITARGETS1_TARGET_SHIFT 0
#define  GICD_ITARGETS1_TARGET_MASK_SHIFT(reg) (((reg) & GICD_ITARGETS1_TARGET_MASK) >> GICD_ITARGETS1_TARGET_SHIFT)
#define  GICD_ITARGETS1_TARGET_REPLACE_VAL(reg,val) (((reg) & ~GICD_ITARGETS1_TARGET_MASK) | (((uint32_t)val) << GICD_ITARGETS1_TARGET_SHIFT))

//====================================================================
//Register: GIC400 Interrupt Target Processor Register (Instance 3 of 64) (ITARGETS2)
/** \brief GIC400 Interrupt Target Processor Register (Instance 3 of 64)*/
//====================================================================

#define  GICD_ITARGETS2_TARGET_MASK 0xffffffff
#define  GICD_ITARGETS2_TARGET_SHIFT 0
#define  GICD_ITARGETS2_TARGET_MASK_SHIFT(reg) (((reg) & GICD_ITARGETS2_TARGET_MASK) >> GICD_ITARGETS2_TARGET_SHIFT)
#define  GICD_ITARGETS2_TARGET_REPLACE_VAL(reg,val) (((reg) & ~GICD_ITARGETS2_TARGET_MASK) | (((uint32_t)val) << GICD_ITARGETS2_TARGET_SHIFT))

//====================================================================
//Register: GIC400 Interrupt Target Processor Register (Instance 4 of 64) (ITARGETS3)
/** \brief GIC400 Interrupt Target Processor Register (Instance 4 of 64)*/
//====================================================================

#define  GICD_ITARGETS3_TARGET_MASK 0xffffffff
#define  GICD_ITARGETS3_TARGET_SHIFT 0
#define  GICD_ITARGETS3_TARGET_MASK_SHIFT(reg) (((reg) & GICD_ITARGETS3_TARGET_MASK) >> GICD_ITARGETS3_TARGET_SHIFT)
#define  GICD_ITARGETS3_TARGET_REPLACE_VAL(reg,val) (((reg) & ~GICD_ITARGETS3_TARGET_MASK) | (((uint32_t)val) << GICD_ITARGETS3_TARGET_SHIFT))

//====================================================================
//Register: GIC400 Interrupt Target Processor Register (Instance 5 of 64) (ITARGETS4)
/** \brief GIC400 Interrupt Target Processor Register (Instance 5 of 64)*/
//====================================================================

#define  GICD_ITARGETS4_TARGET_MASK 0xffffffff
#define  GICD_ITARGETS4_TARGET_SHIFT 0
#define  GICD_ITARGETS4_TARGET_MASK_SHIFT(reg) (((reg) & GICD_ITARGETS4_TARGET_MASK) >> GICD_ITARGETS4_TARGET_SHIFT)
#define  GICD_ITARGETS4_TARGET_REPLACE_VAL(reg,val) (((reg) & ~GICD_ITARGETS4_TARGET_MASK) | (((uint32_t)val) << GICD_ITARGETS4_TARGET_SHIFT))

//====================================================================
//Register: GIC400 Interrupt Target Processor Register (Instance 6 of 64) (ITARGETS5)
/** \brief GIC400 Interrupt Target Processor Register (Instance 6 of 64)*/
//====================================================================

#define  GICD_ITARGETS5_TARGET_MASK 0xffffffff
#define  GICD_ITARGETS5_TARGET_SHIFT 0
#define  GICD_ITARGETS5_TARGET_MASK_SHIFT(reg) (((reg) & GICD_ITARGETS5_TARGET_MASK) >> GICD_ITARGETS5_TARGET_SHIFT)
#define  GICD_ITARGETS5_TARGET_REPLACE_VAL(reg,val) (((reg) & ~GICD_ITARGETS5_TARGET_MASK) | (((uint32_t)val) << GICD_ITARGETS5_TARGET_SHIFT))

//====================================================================
//Register: GIC400 Interrupt Target Processor Register (Instance 7 of 64) (ITARGETS6)
/** \brief GIC400 Interrupt Target Processor Register (Instance 7 of 64)*/
//====================================================================

#define  GICD_ITARGETS6_TARGET_MASK 0xffffffff
#define  GICD_ITARGETS6_TARGET_SHIFT 0
#define  GICD_ITARGETS6_TARGET_MASK_SHIFT(reg) (((reg) & GICD_ITARGETS6_TARGET_MASK) >> GICD_ITARGETS6_TARGET_SHIFT)
#define  GICD_ITARGETS6_TARGET_REPLACE_VAL(reg,val) (((reg) & ~GICD_ITARGETS6_TARGET_MASK) | (((uint32_t)val) << GICD_ITARGETS6_TARGET_SHIFT))

//====================================================================
//Register: GIC400 Interrupt Target Processor Register (Instance 8 of 64) (ITARGETS7)
/** \brief GIC400 Interrupt Target Processor Register (Instance 8 of 64)*/
//====================================================================

#define  GICD_ITARGETS7_TARGET_MASK 0xffffffff
#define  GICD_ITARGETS7_TARGET_SHIFT 0
#define  GICD_ITARGETS7_TARGET_MASK_SHIFT(reg) (((reg) & GICD_ITARGETS7_TARGET_MASK) >> GICD_ITARGETS7_TARGET_SHIFT)
#define  GICD_ITARGETS7_TARGET_REPLACE_VAL(reg,val) (((reg) & ~GICD_ITARGETS7_TARGET_MASK) | (((uint32_t)val) << GICD_ITARGETS7_TARGET_SHIFT))

//====================================================================
//Register: GIC400 Interrupt Target Processor Register (Instance 9 of 64) (ITARGETS8)
/** \brief GIC400 Interrupt Target Processor Register (Instance 9 of 64)*/
//====================================================================

#define  GICD_ITARGETS8_TARGET_MASK 0xffffffff
#define  GICD_ITARGETS8_TARGET_SHIFT 0
#define  GICD_ITARGETS8_TARGET_MASK_SHIFT(reg) (((reg) & GICD_ITARGETS8_TARGET_MASK) >> GICD_ITARGETS8_TARGET_SHIFT)
#define  GICD_ITARGETS8_TARGET_REPLACE_VAL(reg,val) (((reg) & ~GICD_ITARGETS8_TARGET_MASK) | (((uint32_t)val) << GICD_ITARGETS8_TARGET_SHIFT))

//====================================================================
//Register: GIC400 Interrupt Target Processor Register (Instance 10 of 64) (ITARGETS9)
/** \brief GIC400 Interrupt Target Processor Register (Instance 10 of 64)*/
//====================================================================

#define  GICD_ITARGETS9_TARGET_MASK 0xffffffff
#define  GICD_ITARGETS9_TARGET_SHIFT 0
#define  GICD_ITARGETS9_TARGET_MASK_SHIFT(reg) (((reg) & GICD_ITARGETS9_TARGET_MASK) >> GICD_ITARGETS9_TARGET_SHIFT)
#define  GICD_ITARGETS9_TARGET_REPLACE_VAL(reg,val) (((reg) & ~GICD_ITARGETS9_TARGET_MASK) | (((uint32_t)val) << GICD_ITARGETS9_TARGET_SHIFT))

//====================================================================
//Register: GIC400 Interrupt Target Processor Register (Instance 11 of 64) (ITARGETS10)
/** \brief GIC400 Interrupt Target Processor Register (Instance 11 of 64)*/
//====================================================================

#define  GICD_ITARGETS10_TARGET_MASK 0xffffffff
#define  GICD_ITARGETS10_TARGET_SHIFT 0
#define  GICD_ITARGETS10_TARGET_MASK_SHIFT(reg) (((reg) & GICD_ITARGETS10_TARGET_MASK) >> GICD_ITARGETS10_TARGET_SHIFT)
#define  GICD_ITARGETS10_TARGET_REPLACE_VAL(reg,val) (((reg) & ~GICD_ITARGETS10_TARGET_MASK) | (((uint32_t)val) << GICD_ITARGETS10_TARGET_SHIFT))

//====================================================================
//Register: GIC400 Interrupt Target Processor Register (Instance 12 of 64) (ITARGETS11)
/** \brief GIC400 Interrupt Target Processor Register (Instance 12 of 64)*/
//====================================================================

#define  GICD_ITARGETS11_TARGET_MASK 0xffffffff
#define  GICD_ITARGETS11_TARGET_SHIFT 0
#define  GICD_ITARGETS11_TARGET_MASK_SHIFT(reg) (((reg) & GICD_ITARGETS11_TARGET_MASK) >> GICD_ITARGETS11_TARGET_SHIFT)
#define  GICD_ITARGETS11_TARGET_REPLACE_VAL(reg,val) (((reg) & ~GICD_ITARGETS11_TARGET_MASK) | (((uint32_t)val) << GICD_ITARGETS11_TARGET_SHIFT))

//====================================================================
//Register: GIC400 Interrupt Target Processor Register (Instance 13 of 64) (ITARGETS12)
/** \brief GIC400 Interrupt Target Processor Register (Instance 13 of 64)*/
//====================================================================

#define  GICD_ITARGETS12_TARGET_MASK 0xffffffff
#define  GICD_ITARGETS12_TARGET_SHIFT 0
#define  GICD_ITARGETS12_TARGET_MASK_SHIFT(reg) (((reg) & GICD_ITARGETS12_TARGET_MASK) >> GICD_ITARGETS12_TARGET_SHIFT)
#define  GICD_ITARGETS12_TARGET_REPLACE_VAL(reg,val) (((reg) & ~GICD_ITARGETS12_TARGET_MASK) | (((uint32_t)val) << GICD_ITARGETS12_TARGET_SHIFT))

//====================================================================
//Register: GIC400 Interrupt Target Processor Register (Instance 14 of 64) (ITARGETS13)
/** \brief GIC400 Interrupt Target Processor Register (Instance 14 of 64)*/
//====================================================================

#define  GICD_ITARGETS13_TARGET_MASK 0xffffffff
#define  GICD_ITARGETS13_TARGET_SHIFT 0
#define  GICD_ITARGETS13_TARGET_MASK_SHIFT(reg) (((reg) & GICD_ITARGETS13_TARGET_MASK) >> GICD_ITARGETS13_TARGET_SHIFT)
#define  GICD_ITARGETS13_TARGET_REPLACE_VAL(reg,val) (((reg) & ~GICD_ITARGETS13_TARGET_MASK) | (((uint32_t)val) << GICD_ITARGETS13_TARGET_SHIFT))

//====================================================================
//Register: GIC400 Interrupt Target Processor Register (Instance 15 of 64) (ITARGETS14)
/** \brief GIC400 Interrupt Target Processor Register (Instance 15 of 64)*/
//====================================================================

#define  GICD_ITARGETS14_TARGET_MASK 0xffffffff
#define  GICD_ITARGETS14_TARGET_SHIFT 0
#define  GICD_ITARGETS14_TARGET_MASK_SHIFT(reg) (((reg) & GICD_ITARGETS14_TARGET_MASK) >> GICD_ITARGETS14_TARGET_SHIFT)
#define  GICD_ITARGETS14_TARGET_REPLACE_VAL(reg,val) (((reg) & ~GICD_ITARGETS14_TARGET_MASK) | (((uint32_t)val) << GICD_ITARGETS14_TARGET_SHIFT))

//====================================================================
//Register: GIC400 Interrupt Target Processor Register (Instance 16 of 64) (ITARGETS15)
/** \brief GIC400 Interrupt Target Processor Register (Instance 16 of 64)*/
//====================================================================

#define  GICD_ITARGETS15_TARGET_MASK 0xffffffff
#define  GICD_ITARGETS15_TARGET_SHIFT 0
#define  GICD_ITARGETS15_TARGET_MASK_SHIFT(reg) (((reg) & GICD_ITARGETS15_TARGET_MASK) >> GICD_ITARGETS15_TARGET_SHIFT)
#define  GICD_ITARGETS15_TARGET_REPLACE_VAL(reg,val) (((reg) & ~GICD_ITARGETS15_TARGET_MASK) | (((uint32_t)val) << GICD_ITARGETS15_TARGET_SHIFT))

//====================================================================
//Register: GIC400 Interrupt Target Processor Register (Instance 17 of 64) (ITARGETS16)
/** \brief GIC400 Interrupt Target Processor Register (Instance 17 of 64)*/
//====================================================================

#define  GICD_ITARGETS16_TARGET_MASK 0xffffffff
#define  GICD_ITARGETS16_TARGET_SHIFT 0
#define  GICD_ITARGETS16_TARGET_MASK_SHIFT(reg) (((reg) & GICD_ITARGETS16_TARGET_MASK) >> GICD_ITARGETS16_TARGET_SHIFT)
#define  GICD_ITARGETS16_TARGET_REPLACE_VAL(reg,val) (((reg) & ~GICD_ITARGETS16_TARGET_MASK) | (((uint32_t)val) << GICD_ITARGETS16_TARGET_SHIFT))

//====================================================================
//Register: GIC400 Interrupt Target Processor Register (Instance 18 of 64) (ITARGETS17)
/** \brief GIC400 Interrupt Target Processor Register (Instance 18 of 64)*/
//====================================================================

#define  GICD_ITARGETS17_TARGET_MASK 0xffffffff
#define  GICD_ITARGETS17_TARGET_SHIFT 0
#define  GICD_ITARGETS17_TARGET_MASK_SHIFT(reg) (((reg) & GICD_ITARGETS17_TARGET_MASK) >> GICD_ITARGETS17_TARGET_SHIFT)
#define  GICD_ITARGETS17_TARGET_REPLACE_VAL(reg,val) (((reg) & ~GICD_ITARGETS17_TARGET_MASK) | (((uint32_t)val) << GICD_ITARGETS17_TARGET_SHIFT))

//====================================================================
//Register: GIC400 Interrupt Target Processor Register (Instance 19 of 64) (ITARGETS18)
/** \brief GIC400 Interrupt Target Processor Register (Instance 19 of 64)*/
//====================================================================

#define  GICD_ITARGETS18_TARGET_MASK 0xffffffff
#define  GICD_ITARGETS18_TARGET_SHIFT 0
#define  GICD_ITARGETS18_TARGET_MASK_SHIFT(reg) (((reg) & GICD_ITARGETS18_TARGET_MASK) >> GICD_ITARGETS18_TARGET_SHIFT)
#define  GICD_ITARGETS18_TARGET_REPLACE_VAL(reg,val) (((reg) & ~GICD_ITARGETS18_TARGET_MASK) | (((uint32_t)val) << GICD_ITARGETS18_TARGET_SHIFT))

//====================================================================
//Register: GIC400 Interrupt Target Processor Register (Instance 20 of 64) (ITARGETS19)
/** \brief GIC400 Interrupt Target Processor Register (Instance 20 of 64)*/
//====================================================================

#define  GICD_ITARGETS19_TARGET_MASK 0xffffffff
#define  GICD_ITARGETS19_TARGET_SHIFT 0
#define  GICD_ITARGETS19_TARGET_MASK_SHIFT(reg) (((reg) & GICD_ITARGETS19_TARGET_MASK) >> GICD_ITARGETS19_TARGET_SHIFT)
#define  GICD_ITARGETS19_TARGET_REPLACE_VAL(reg,val) (((reg) & ~GICD_ITARGETS19_TARGET_MASK) | (((uint32_t)val) << GICD_ITARGETS19_TARGET_SHIFT))

//====================================================================
//Register: GIC400 Interrupt Target Processor Register (Instance 21 of 64) (ITARGETS20)
/** \brief GIC400 Interrupt Target Processor Register (Instance 21 of 64)*/
//====================================================================

#define  GICD_ITARGETS20_TARGET_MASK 0xffffffff
#define  GICD_ITARGETS20_TARGET_SHIFT 0
#define  GICD_ITARGETS20_TARGET_MASK_SHIFT(reg) (((reg) & GICD_ITARGETS20_TARGET_MASK) >> GICD_ITARGETS20_TARGET_SHIFT)
#define  GICD_ITARGETS20_TARGET_REPLACE_VAL(reg,val) (((reg) & ~GICD_ITARGETS20_TARGET_MASK) | (((uint32_t)val) << GICD_ITARGETS20_TARGET_SHIFT))

//====================================================================
//Register: GIC400 Interrupt Target Processor Register (Instance 22 of 64) (ITARGETS21)
/** \brief GIC400 Interrupt Target Processor Register (Instance 22 of 64)*/
//====================================================================

#define  GICD_ITARGETS21_TARGET_MASK 0xffffffff
#define  GICD_ITARGETS21_TARGET_SHIFT 0
#define  GICD_ITARGETS21_TARGET_MASK_SHIFT(reg) (((reg) & GICD_ITARGETS21_TARGET_MASK) >> GICD_ITARGETS21_TARGET_SHIFT)
#define  GICD_ITARGETS21_TARGET_REPLACE_VAL(reg,val) (((reg) & ~GICD_ITARGETS21_TARGET_MASK) | (((uint32_t)val) << GICD_ITARGETS21_TARGET_SHIFT))

//====================================================================
//Register: GIC400 Interrupt Target Processor Register (Instance 23 of 64) (ITARGETS22)
/** \brief GIC400 Interrupt Target Processor Register (Instance 23 of 64)*/
//====================================================================

#define  GICD_ITARGETS22_TARGET_MASK 0xffffffff
#define  GICD_ITARGETS22_TARGET_SHIFT 0
#define  GICD_ITARGETS22_TARGET_MASK_SHIFT(reg) (((reg) & GICD_ITARGETS22_TARGET_MASK) >> GICD_ITARGETS22_TARGET_SHIFT)
#define  GICD_ITARGETS22_TARGET_REPLACE_VAL(reg,val) (((reg) & ~GICD_ITARGETS22_TARGET_MASK) | (((uint32_t)val) << GICD_ITARGETS22_TARGET_SHIFT))

//====================================================================
//Register: GIC400 Interrupt Target Processor Register (Instance 24 of 64) (ITARGETS23)
/** \brief GIC400 Interrupt Target Processor Register (Instance 24 of 64)*/
//====================================================================

#define  GICD_ITARGETS23_TARGET_MASK 0xffffffff
#define  GICD_ITARGETS23_TARGET_SHIFT 0
#define  GICD_ITARGETS23_TARGET_MASK_SHIFT(reg) (((reg) & GICD_ITARGETS23_TARGET_MASK) >> GICD_ITARGETS23_TARGET_SHIFT)
#define  GICD_ITARGETS23_TARGET_REPLACE_VAL(reg,val) (((reg) & ~GICD_ITARGETS23_TARGET_MASK) | (((uint32_t)val) << GICD_ITARGETS23_TARGET_SHIFT))

//====================================================================
//Register: GIC400 Interrupt Target Processor Register (Instance 25 of 64) (ITARGETS24)
/** \brief GIC400 Interrupt Target Processor Register (Instance 25 of 64)*/
//====================================================================

#define  GICD_ITARGETS24_TARGET_MASK 0xffffffff
#define  GICD_ITARGETS24_TARGET_SHIFT 0
#define  GICD_ITARGETS24_TARGET_MASK_SHIFT(reg) (((reg) & GICD_ITARGETS24_TARGET_MASK) >> GICD_ITARGETS24_TARGET_SHIFT)
#define  GICD_ITARGETS24_TARGET_REPLACE_VAL(reg,val) (((reg) & ~GICD_ITARGETS24_TARGET_MASK) | (((uint32_t)val) << GICD_ITARGETS24_TARGET_SHIFT))

//====================================================================
//Register: GIC400 Interrupt Target Processor Register (Instance 26 of 64) (ITARGETS25)
/** \brief GIC400 Interrupt Target Processor Register (Instance 26 of 64)*/
//====================================================================

#define  GICD_ITARGETS25_TARGET_MASK 0xffffffff
#define  GICD_ITARGETS25_TARGET_SHIFT 0
#define  GICD_ITARGETS25_TARGET_MASK_SHIFT(reg) (((reg) & GICD_ITARGETS25_TARGET_MASK) >> GICD_ITARGETS25_TARGET_SHIFT)
#define  GICD_ITARGETS25_TARGET_REPLACE_VAL(reg,val) (((reg) & ~GICD_ITARGETS25_TARGET_MASK) | (((uint32_t)val) << GICD_ITARGETS25_TARGET_SHIFT))

//====================================================================
//Register: GIC400 Interrupt Target Processor Register (Instance 27 of 64) (ITARGETS26)
/** \brief GIC400 Interrupt Target Processor Register (Instance 27 of 64)*/
//====================================================================

#define  GICD_ITARGETS26_TARGET_MASK 0xffffffff
#define  GICD_ITARGETS26_TARGET_SHIFT 0
#define  GICD_ITARGETS26_TARGET_MASK_SHIFT(reg) (((reg) & GICD_ITARGETS26_TARGET_MASK) >> GICD_ITARGETS26_TARGET_SHIFT)
#define  GICD_ITARGETS26_TARGET_REPLACE_VAL(reg,val) (((reg) & ~GICD_ITARGETS26_TARGET_MASK) | (((uint32_t)val) << GICD_ITARGETS26_TARGET_SHIFT))

//====================================================================
//Register: GIC400 Interrupt Target Processor Register (Instance 28 of 64) (ITARGETS27)
/** \brief GIC400 Interrupt Target Processor Register (Instance 28 of 64)*/
//====================================================================

#define  GICD_ITARGETS27_TARGET_MASK 0xffffffff
#define  GICD_ITARGETS27_TARGET_SHIFT 0
#define  GICD_ITARGETS27_TARGET_MASK_SHIFT(reg) (((reg) & GICD_ITARGETS27_TARGET_MASK) >> GICD_ITARGETS27_TARGET_SHIFT)
#define  GICD_ITARGETS27_TARGET_REPLACE_VAL(reg,val) (((reg) & ~GICD_ITARGETS27_TARGET_MASK) | (((uint32_t)val) << GICD_ITARGETS27_TARGET_SHIFT))

//====================================================================
//Register: GIC400 Interrupt Target Processor Register (Instance 29 of 64) (ITARGETS28)
/** \brief GIC400 Interrupt Target Processor Register (Instance 29 of 64)*/
//====================================================================

#define  GICD_ITARGETS28_TARGET_MASK 0xffffffff
#define  GICD_ITARGETS28_TARGET_SHIFT 0
#define  GICD_ITARGETS28_TARGET_MASK_SHIFT(reg) (((reg) & GICD_ITARGETS28_TARGET_MASK) >> GICD_ITARGETS28_TARGET_SHIFT)
#define  GICD_ITARGETS28_TARGET_REPLACE_VAL(reg,val) (((reg) & ~GICD_ITARGETS28_TARGET_MASK) | (((uint32_t)val) << GICD_ITARGETS28_TARGET_SHIFT))

//====================================================================
//Register: GIC400 Interrupt Target Processor Register (Instance 30 of 64) (ITARGETS29)
/** \brief GIC400 Interrupt Target Processor Register (Instance 30 of 64)*/
//====================================================================

#define  GICD_ITARGETS29_TARGET_MASK 0xffffffff
#define  GICD_ITARGETS29_TARGET_SHIFT 0
#define  GICD_ITARGETS29_TARGET_MASK_SHIFT(reg) (((reg) & GICD_ITARGETS29_TARGET_MASK) >> GICD_ITARGETS29_TARGET_SHIFT)
#define  GICD_ITARGETS29_TARGET_REPLACE_VAL(reg,val) (((reg) & ~GICD_ITARGETS29_TARGET_MASK) | (((uint32_t)val) << GICD_ITARGETS29_TARGET_SHIFT))

//====================================================================
//Register: GIC400 Interrupt Target Processor Register (Instance 31 of 64) (ITARGETS30)
/** \brief GIC400 Interrupt Target Processor Register (Instance 31 of 64)*/
//====================================================================

#define  GICD_ITARGETS30_TARGET_MASK 0xffffffff
#define  GICD_ITARGETS30_TARGET_SHIFT 0
#define  GICD_ITARGETS30_TARGET_MASK_SHIFT(reg) (((reg) & GICD_ITARGETS30_TARGET_MASK) >> GICD_ITARGETS30_TARGET_SHIFT)
#define  GICD_ITARGETS30_TARGET_REPLACE_VAL(reg,val) (((reg) & ~GICD_ITARGETS30_TARGET_MASK) | (((uint32_t)val) << GICD_ITARGETS30_TARGET_SHIFT))

//====================================================================
//Register: GIC400 Interrupt Target Processor Register (Instance 32 of 64) (ITARGETS31)
/** \brief GIC400 Interrupt Target Processor Register (Instance 32 of 64)*/
//====================================================================

#define  GICD_ITARGETS31_TARGET_MASK 0xffffffff
#define  GICD_ITARGETS31_TARGET_SHIFT 0
#define  GICD_ITARGETS31_TARGET_MASK_SHIFT(reg) (((reg) & GICD_ITARGETS31_TARGET_MASK) >> GICD_ITARGETS31_TARGET_SHIFT)
#define  GICD_ITARGETS31_TARGET_REPLACE_VAL(reg,val) (((reg) & ~GICD_ITARGETS31_TARGET_MASK) | (((uint32_t)val) << GICD_ITARGETS31_TARGET_SHIFT))

//====================================================================
//Register: GIC400 Interrupt Target Processor Register (Instance 33 of 64) (ITARGETS32)
/** \brief GIC400 Interrupt Target Processor Register (Instance 33 of 64)*/
//====================================================================

#define  GICD_ITARGETS32_TARGET_MASK 0xffffffff
#define  GICD_ITARGETS32_TARGET_SHIFT 0
#define  GICD_ITARGETS32_TARGET_MASK_SHIFT(reg) (((reg) & GICD_ITARGETS32_TARGET_MASK) >> GICD_ITARGETS32_TARGET_SHIFT)
#define  GICD_ITARGETS32_TARGET_REPLACE_VAL(reg,val) (((reg) & ~GICD_ITARGETS32_TARGET_MASK) | (((uint32_t)val) << GICD_ITARGETS32_TARGET_SHIFT))

//====================================================================
//Register: GIC400 Interrupt Target Processor Register (Instance 34 of 64) (ITARGETS33)
/** \brief GIC400 Interrupt Target Processor Register (Instance 34 of 64)*/
//====================================================================

#define  GICD_ITARGETS33_TARGET_MASK 0xffffffff
#define  GICD_ITARGETS33_TARGET_SHIFT 0
#define  GICD_ITARGETS33_TARGET_MASK_SHIFT(reg) (((reg) & GICD_ITARGETS33_TARGET_MASK) >> GICD_ITARGETS33_TARGET_SHIFT)
#define  GICD_ITARGETS33_TARGET_REPLACE_VAL(reg,val) (((reg) & ~GICD_ITARGETS33_TARGET_MASK) | (((uint32_t)val) << GICD_ITARGETS33_TARGET_SHIFT))

//====================================================================
//Register: GIC400 Interrupt Target Processor Register (Instance 35 of 64) (ITARGETS34)
/** \brief GIC400 Interrupt Target Processor Register (Instance 35 of 64)*/
//====================================================================

#define  GICD_ITARGETS34_TARGET_MASK 0xffffffff
#define  GICD_ITARGETS34_TARGET_SHIFT 0
#define  GICD_ITARGETS34_TARGET_MASK_SHIFT(reg) (((reg) & GICD_ITARGETS34_TARGET_MASK) >> GICD_ITARGETS34_TARGET_SHIFT)
#define  GICD_ITARGETS34_TARGET_REPLACE_VAL(reg,val) (((reg) & ~GICD_ITARGETS34_TARGET_MASK) | (((uint32_t)val) << GICD_ITARGETS34_TARGET_SHIFT))

//====================================================================
//Register: GIC400 Interrupt Target Processor Register (Instance 36 of 64) (ITARGETS35)
/** \brief GIC400 Interrupt Target Processor Register (Instance 36 of 64)*/
//====================================================================

#define  GICD_ITARGETS35_TARGET_MASK 0xffffffff
#define  GICD_ITARGETS35_TARGET_SHIFT 0
#define  GICD_ITARGETS35_TARGET_MASK_SHIFT(reg) (((reg) & GICD_ITARGETS35_TARGET_MASK) >> GICD_ITARGETS35_TARGET_SHIFT)
#define  GICD_ITARGETS35_TARGET_REPLACE_VAL(reg,val) (((reg) & ~GICD_ITARGETS35_TARGET_MASK) | (((uint32_t)val) << GICD_ITARGETS35_TARGET_SHIFT))

//====================================================================
//Register: GIC400 Interrupt Target Processor Register (Instance 37 of 64) (ITARGETS36)
/** \brief GIC400 Interrupt Target Processor Register (Instance 37 of 64)*/
//====================================================================

#define  GICD_ITARGETS36_TARGET_MASK 0xffffffff
#define  GICD_ITARGETS36_TARGET_SHIFT 0
#define  GICD_ITARGETS36_TARGET_MASK_SHIFT(reg) (((reg) & GICD_ITARGETS36_TARGET_MASK) >> GICD_ITARGETS36_TARGET_SHIFT)
#define  GICD_ITARGETS36_TARGET_REPLACE_VAL(reg,val) (((reg) & ~GICD_ITARGETS36_TARGET_MASK) | (((uint32_t)val) << GICD_ITARGETS36_TARGET_SHIFT))

//====================================================================
//Register: GIC400 Interrupt Target Processor Register (Instance 38 of 64) (ITARGETS37)
/** \brief GIC400 Interrupt Target Processor Register (Instance 38 of 64)*/
//====================================================================

#define  GICD_ITARGETS37_TARGET_MASK 0xffffffff
#define  GICD_ITARGETS37_TARGET_SHIFT 0
#define  GICD_ITARGETS37_TARGET_MASK_SHIFT(reg) (((reg) & GICD_ITARGETS37_TARGET_MASK) >> GICD_ITARGETS37_TARGET_SHIFT)
#define  GICD_ITARGETS37_TARGET_REPLACE_VAL(reg,val) (((reg) & ~GICD_ITARGETS37_TARGET_MASK) | (((uint32_t)val) << GICD_ITARGETS37_TARGET_SHIFT))

//====================================================================
//Register: GIC400 Interrupt Target Processor Register (Instance 39 of 64) (ITARGETS38)
/** \brief GIC400 Interrupt Target Processor Register (Instance 39 of 64)*/
//====================================================================

#define  GICD_ITARGETS38_TARGET_MASK 0xffffffff
#define  GICD_ITARGETS38_TARGET_SHIFT 0
#define  GICD_ITARGETS38_TARGET_MASK_SHIFT(reg) (((reg) & GICD_ITARGETS38_TARGET_MASK) >> GICD_ITARGETS38_TARGET_SHIFT)
#define  GICD_ITARGETS38_TARGET_REPLACE_VAL(reg,val) (((reg) & ~GICD_ITARGETS38_TARGET_MASK) | (((uint32_t)val) << GICD_ITARGETS38_TARGET_SHIFT))

//====================================================================
//Register: GIC400 Interrupt Target Processor Register (Instance 40 of 64) (ITARGETS39)
/** \brief GIC400 Interrupt Target Processor Register (Instance 40 of 64)*/
//====================================================================

#define  GICD_ITARGETS39_TARGET_MASK 0xffffffff
#define  GICD_ITARGETS39_TARGET_SHIFT 0
#define  GICD_ITARGETS39_TARGET_MASK_SHIFT(reg) (((reg) & GICD_ITARGETS39_TARGET_MASK) >> GICD_ITARGETS39_TARGET_SHIFT)
#define  GICD_ITARGETS39_TARGET_REPLACE_VAL(reg,val) (((reg) & ~GICD_ITARGETS39_TARGET_MASK) | (((uint32_t)val) << GICD_ITARGETS39_TARGET_SHIFT))

//====================================================================
//Register: GIC400 Interrupt Target Processor Register (Instance 41 of 64) (ITARGETS40)
/** \brief GIC400 Interrupt Target Processor Register (Instance 41 of 64)*/
//====================================================================

#define  GICD_ITARGETS40_TARGET_MASK 0xffffffff
#define  GICD_ITARGETS40_TARGET_SHIFT 0
#define  GICD_ITARGETS40_TARGET_MASK_SHIFT(reg) (((reg) & GICD_ITARGETS40_TARGET_MASK) >> GICD_ITARGETS40_TARGET_SHIFT)
#define  GICD_ITARGETS40_TARGET_REPLACE_VAL(reg,val) (((reg) & ~GICD_ITARGETS40_TARGET_MASK) | (((uint32_t)val) << GICD_ITARGETS40_TARGET_SHIFT))

//====================================================================
//Register: GIC400 Interrupt Target Processor Register (Instance 42 of 64) (ITARGETS41)
/** \brief GIC400 Interrupt Target Processor Register (Instance 42 of 64)*/
//====================================================================

#define  GICD_ITARGETS41_TARGET_MASK 0xffffffff
#define  GICD_ITARGETS41_TARGET_SHIFT 0
#define  GICD_ITARGETS41_TARGET_MASK_SHIFT(reg) (((reg) & GICD_ITARGETS41_TARGET_MASK) >> GICD_ITARGETS41_TARGET_SHIFT)
#define  GICD_ITARGETS41_TARGET_REPLACE_VAL(reg,val) (((reg) & ~GICD_ITARGETS41_TARGET_MASK) | (((uint32_t)val) << GICD_ITARGETS41_TARGET_SHIFT))

//====================================================================
//Register: GIC400 Interrupt Target Processor Register (Instance 43 of 64) (ITARGETS42)
/** \brief GIC400 Interrupt Target Processor Register (Instance 43 of 64)*/
//====================================================================

#define  GICD_ITARGETS42_TARGET_MASK 0xffffffff
#define  GICD_ITARGETS42_TARGET_SHIFT 0
#define  GICD_ITARGETS42_TARGET_MASK_SHIFT(reg) (((reg) & GICD_ITARGETS42_TARGET_MASK) >> GICD_ITARGETS42_TARGET_SHIFT)
#define  GICD_ITARGETS42_TARGET_REPLACE_VAL(reg,val) (((reg) & ~GICD_ITARGETS42_TARGET_MASK) | (((uint32_t)val) << GICD_ITARGETS42_TARGET_SHIFT))

//====================================================================
//Register: GIC400 Interrupt Target Processor Register (Instance 44 of 64) (ITARGETS43)
/** \brief GIC400 Interrupt Target Processor Register (Instance 44 of 64)*/
//====================================================================

#define  GICD_ITARGETS43_TARGET_MASK 0xffffffff
#define  GICD_ITARGETS43_TARGET_SHIFT 0
#define  GICD_ITARGETS43_TARGET_MASK_SHIFT(reg) (((reg) & GICD_ITARGETS43_TARGET_MASK) >> GICD_ITARGETS43_TARGET_SHIFT)
#define  GICD_ITARGETS43_TARGET_REPLACE_VAL(reg,val) (((reg) & ~GICD_ITARGETS43_TARGET_MASK) | (((uint32_t)val) << GICD_ITARGETS43_TARGET_SHIFT))

//====================================================================
//Register: GIC400 Interrupt Target Processor Register (Instance 45 of 64) (ITARGETS44)
/** \brief GIC400 Interrupt Target Processor Register (Instance 45 of 64)*/
//====================================================================

#define  GICD_ITARGETS44_TARGET_MASK 0xffffffff
#define  GICD_ITARGETS44_TARGET_SHIFT 0
#define  GICD_ITARGETS44_TARGET_MASK_SHIFT(reg) (((reg) & GICD_ITARGETS44_TARGET_MASK) >> GICD_ITARGETS44_TARGET_SHIFT)
#define  GICD_ITARGETS44_TARGET_REPLACE_VAL(reg,val) (((reg) & ~GICD_ITARGETS44_TARGET_MASK) | (((uint32_t)val) << GICD_ITARGETS44_TARGET_SHIFT))

//====================================================================
//Register: GIC400 Interrupt Target Processor Register (Instance 46 of 64) (ITARGETS45)
/** \brief GIC400 Interrupt Target Processor Register (Instance 46 of 64)*/
//====================================================================

#define  GICD_ITARGETS45_TARGET_MASK 0xffffffff
#define  GICD_ITARGETS45_TARGET_SHIFT 0
#define  GICD_ITARGETS45_TARGET_MASK_SHIFT(reg) (((reg) & GICD_ITARGETS45_TARGET_MASK) >> GICD_ITARGETS45_TARGET_SHIFT)
#define  GICD_ITARGETS45_TARGET_REPLACE_VAL(reg,val) (((reg) & ~GICD_ITARGETS45_TARGET_MASK) | (((uint32_t)val) << GICD_ITARGETS45_TARGET_SHIFT))

//====================================================================
//Register: GIC400 Interrupt Target Processor Register (Instance 47 of 64) (ITARGETS46)
/** \brief GIC400 Interrupt Target Processor Register (Instance 47 of 64)*/
//====================================================================

#define  GICD_ITARGETS46_TARGET_MASK 0xffffffff
#define  GICD_ITARGETS46_TARGET_SHIFT 0
#define  GICD_ITARGETS46_TARGET_MASK_SHIFT(reg) (((reg) & GICD_ITARGETS46_TARGET_MASK) >> GICD_ITARGETS46_TARGET_SHIFT)
#define  GICD_ITARGETS46_TARGET_REPLACE_VAL(reg,val) (((reg) & ~GICD_ITARGETS46_TARGET_MASK) | (((uint32_t)val) << GICD_ITARGETS46_TARGET_SHIFT))

//====================================================================
//Register: GIC400 Interrupt Target Processor Register (Instance 48 of 64) (ITARGETS47)
/** \brief GIC400 Interrupt Target Processor Register (Instance 48 of 64)*/
//====================================================================

#define  GICD_ITARGETS47_TARGET_MASK 0xffffffff
#define  GICD_ITARGETS47_TARGET_SHIFT 0
#define  GICD_ITARGETS47_TARGET_MASK_SHIFT(reg) (((reg) & GICD_ITARGETS47_TARGET_MASK) >> GICD_ITARGETS47_TARGET_SHIFT)
#define  GICD_ITARGETS47_TARGET_REPLACE_VAL(reg,val) (((reg) & ~GICD_ITARGETS47_TARGET_MASK) | (((uint32_t)val) << GICD_ITARGETS47_TARGET_SHIFT))

//====================================================================
//Register: GIC400 Interrupt Target Processor Register (Instance 49 of 64) (ITARGETS48)
/** \brief GIC400 Interrupt Target Processor Register (Instance 49 of 64)*/
//====================================================================

#define  GICD_ITARGETS48_TARGET_MASK 0xffffffff
#define  GICD_ITARGETS48_TARGET_SHIFT 0
#define  GICD_ITARGETS48_TARGET_MASK_SHIFT(reg) (((reg) & GICD_ITARGETS48_TARGET_MASK) >> GICD_ITARGETS48_TARGET_SHIFT)
#define  GICD_ITARGETS48_TARGET_REPLACE_VAL(reg,val) (((reg) & ~GICD_ITARGETS48_TARGET_MASK) | (((uint32_t)val) << GICD_ITARGETS48_TARGET_SHIFT))

//====================================================================
//Register: GIC400 Interrupt Target Processor Register (Instance 50 of 64) (ITARGETS49)
/** \brief GIC400 Interrupt Target Processor Register (Instance 50 of 64)*/
//====================================================================

#define  GICD_ITARGETS49_TARGET_MASK 0xffffffff
#define  GICD_ITARGETS49_TARGET_SHIFT 0
#define  GICD_ITARGETS49_TARGET_MASK_SHIFT(reg) (((reg) & GICD_ITARGETS49_TARGET_MASK) >> GICD_ITARGETS49_TARGET_SHIFT)
#define  GICD_ITARGETS49_TARGET_REPLACE_VAL(reg,val) (((reg) & ~GICD_ITARGETS49_TARGET_MASK) | (((uint32_t)val) << GICD_ITARGETS49_TARGET_SHIFT))

//====================================================================
//Register: GIC400 Interrupt Target Processor Register (Instance 51 of 64) (ITARGETS50)
/** \brief GIC400 Interrupt Target Processor Register (Instance 51 of 64)*/
//====================================================================

#define  GICD_ITARGETS50_TARGET_MASK 0xffffffff
#define  GICD_ITARGETS50_TARGET_SHIFT 0
#define  GICD_ITARGETS50_TARGET_MASK_SHIFT(reg) (((reg) & GICD_ITARGETS50_TARGET_MASK) >> GICD_ITARGETS50_TARGET_SHIFT)
#define  GICD_ITARGETS50_TARGET_REPLACE_VAL(reg,val) (((reg) & ~GICD_ITARGETS50_TARGET_MASK) | (((uint32_t)val) << GICD_ITARGETS50_TARGET_SHIFT))

//====================================================================
//Register: GIC400 Interrupt Target Processor Register (Instance 52 of 64) (ITARGETS51)
/** \brief GIC400 Interrupt Target Processor Register (Instance 52 of 64)*/
//====================================================================

#define  GICD_ITARGETS51_TARGET_MASK 0xffffffff
#define  GICD_ITARGETS51_TARGET_SHIFT 0
#define  GICD_ITARGETS51_TARGET_MASK_SHIFT(reg) (((reg) & GICD_ITARGETS51_TARGET_MASK) >> GICD_ITARGETS51_TARGET_SHIFT)
#define  GICD_ITARGETS51_TARGET_REPLACE_VAL(reg,val) (((reg) & ~GICD_ITARGETS51_TARGET_MASK) | (((uint32_t)val) << GICD_ITARGETS51_TARGET_SHIFT))

//====================================================================
//Register: GIC400 Interrupt Target Processor Register (Instance 53 of 64) (ITARGETS52)
/** \brief GIC400 Interrupt Target Processor Register (Instance 53 of 64)*/
//====================================================================

#define  GICD_ITARGETS52_TARGET_MASK 0xffffffff
#define  GICD_ITARGETS52_TARGET_SHIFT 0
#define  GICD_ITARGETS52_TARGET_MASK_SHIFT(reg) (((reg) & GICD_ITARGETS52_TARGET_MASK) >> GICD_ITARGETS52_TARGET_SHIFT)
#define  GICD_ITARGETS52_TARGET_REPLACE_VAL(reg,val) (((reg) & ~GICD_ITARGETS52_TARGET_MASK) | (((uint32_t)val) << GICD_ITARGETS52_TARGET_SHIFT))

//====================================================================
//Register: GIC400 Interrupt Target Processor Register (Instance 54 of 64) (ITARGETS53)
/** \brief GIC400 Interrupt Target Processor Register (Instance 54 of 64)*/
//====================================================================

#define  GICD_ITARGETS53_TARGET_MASK 0xffffffff
#define  GICD_ITARGETS53_TARGET_SHIFT 0
#define  GICD_ITARGETS53_TARGET_MASK_SHIFT(reg) (((reg) & GICD_ITARGETS53_TARGET_MASK) >> GICD_ITARGETS53_TARGET_SHIFT)
#define  GICD_ITARGETS53_TARGET_REPLACE_VAL(reg,val) (((reg) & ~GICD_ITARGETS53_TARGET_MASK) | (((uint32_t)val) << GICD_ITARGETS53_TARGET_SHIFT))

//====================================================================
//Register: GIC400 Interrupt Target Processor Register (Instance 55 of 64) (ITARGETS54)
/** \brief GIC400 Interrupt Target Processor Register (Instance 55 of 64)*/
//====================================================================

#define  GICD_ITARGETS54_TARGET_MASK 0xffffffff
#define  GICD_ITARGETS54_TARGET_SHIFT 0
#define  GICD_ITARGETS54_TARGET_MASK_SHIFT(reg) (((reg) & GICD_ITARGETS54_TARGET_MASK) >> GICD_ITARGETS54_TARGET_SHIFT)
#define  GICD_ITARGETS54_TARGET_REPLACE_VAL(reg,val) (((reg) & ~GICD_ITARGETS54_TARGET_MASK) | (((uint32_t)val) << GICD_ITARGETS54_TARGET_SHIFT))

//====================================================================
//Register: GIC400 Interrupt Target Processor Register (Instance 56 of 64) (ITARGETS55)
/** \brief GIC400 Interrupt Target Processor Register (Instance 56 of 64)*/
//====================================================================

#define  GICD_ITARGETS55_TARGET_MASK 0xffffffff
#define  GICD_ITARGETS55_TARGET_SHIFT 0
#define  GICD_ITARGETS55_TARGET_MASK_SHIFT(reg) (((reg) & GICD_ITARGETS55_TARGET_MASK) >> GICD_ITARGETS55_TARGET_SHIFT)
#define  GICD_ITARGETS55_TARGET_REPLACE_VAL(reg,val) (((reg) & ~GICD_ITARGETS55_TARGET_MASK) | (((uint32_t)val) << GICD_ITARGETS55_TARGET_SHIFT))

//====================================================================
//Register: GIC400 Interrupt Target Processor Register (Instance 57 of 64) (ITARGETS56)
/** \brief GIC400 Interrupt Target Processor Register (Instance 57 of 64)*/
//====================================================================

#define  GICD_ITARGETS56_TARGET_MASK 0xffffffff
#define  GICD_ITARGETS56_TARGET_SHIFT 0
#define  GICD_ITARGETS56_TARGET_MASK_SHIFT(reg) (((reg) & GICD_ITARGETS56_TARGET_MASK) >> GICD_ITARGETS56_TARGET_SHIFT)
#define  GICD_ITARGETS56_TARGET_REPLACE_VAL(reg,val) (((reg) & ~GICD_ITARGETS56_TARGET_MASK) | (((uint32_t)val) << GICD_ITARGETS56_TARGET_SHIFT))

//====================================================================
//Register: GIC400 Interrupt Target Processor Register (Instance 58 of 64) (ITARGETS57)
/** \brief GIC400 Interrupt Target Processor Register (Instance 58 of 64)*/
//====================================================================

#define  GICD_ITARGETS57_TARGET_MASK 0xffffffff
#define  GICD_ITARGETS57_TARGET_SHIFT 0
#define  GICD_ITARGETS57_TARGET_MASK_SHIFT(reg) (((reg) & GICD_ITARGETS57_TARGET_MASK) >> GICD_ITARGETS57_TARGET_SHIFT)
#define  GICD_ITARGETS57_TARGET_REPLACE_VAL(reg,val) (((reg) & ~GICD_ITARGETS57_TARGET_MASK) | (((uint32_t)val) << GICD_ITARGETS57_TARGET_SHIFT))

//====================================================================
//Register: GIC400 Interrupt Target Processor Register (Instance 59 of 64) (ITARGETS58)
/** \brief GIC400 Interrupt Target Processor Register (Instance 59 of 64)*/
//====================================================================

#define  GICD_ITARGETS58_TARGET_MASK 0xffffffff
#define  GICD_ITARGETS58_TARGET_SHIFT 0
#define  GICD_ITARGETS58_TARGET_MASK_SHIFT(reg) (((reg) & GICD_ITARGETS58_TARGET_MASK) >> GICD_ITARGETS58_TARGET_SHIFT)
#define  GICD_ITARGETS58_TARGET_REPLACE_VAL(reg,val) (((reg) & ~GICD_ITARGETS58_TARGET_MASK) | (((uint32_t)val) << GICD_ITARGETS58_TARGET_SHIFT))

//====================================================================
//Register: GIC400 Interrupt Target Processor Register (Instance 60 of 64) (ITARGETS59)
/** \brief GIC400 Interrupt Target Processor Register (Instance 60 of 64)*/
//====================================================================

#define  GICD_ITARGETS59_TARGET_MASK 0xffffffff
#define  GICD_ITARGETS59_TARGET_SHIFT 0
#define  GICD_ITARGETS59_TARGET_MASK_SHIFT(reg) (((reg) & GICD_ITARGETS59_TARGET_MASK) >> GICD_ITARGETS59_TARGET_SHIFT)
#define  GICD_ITARGETS59_TARGET_REPLACE_VAL(reg,val) (((reg) & ~GICD_ITARGETS59_TARGET_MASK) | (((uint32_t)val) << GICD_ITARGETS59_TARGET_SHIFT))

//====================================================================
//Register: GIC400 Interrupt Target Processor Register (Instance 61 of 64) (ITARGETS60)
/** \brief GIC400 Interrupt Target Processor Register (Instance 61 of 64)*/
//====================================================================

#define  GICD_ITARGETS60_TARGET_MASK 0xffffffff
#define  GICD_ITARGETS60_TARGET_SHIFT 0
#define  GICD_ITARGETS60_TARGET_MASK_SHIFT(reg) (((reg) & GICD_ITARGETS60_TARGET_MASK) >> GICD_ITARGETS60_TARGET_SHIFT)
#define  GICD_ITARGETS60_TARGET_REPLACE_VAL(reg,val) (((reg) & ~GICD_ITARGETS60_TARGET_MASK) | (((uint32_t)val) << GICD_ITARGETS60_TARGET_SHIFT))

//====================================================================
//Register: GIC400 Interrupt Target Processor Register (Instance 62 of 64) (ITARGETS61)
/** \brief GIC400 Interrupt Target Processor Register (Instance 62 of 64)*/
//====================================================================

#define  GICD_ITARGETS61_TARGET_MASK 0xffffffff
#define  GICD_ITARGETS61_TARGET_SHIFT 0
#define  GICD_ITARGETS61_TARGET_MASK_SHIFT(reg) (((reg) & GICD_ITARGETS61_TARGET_MASK) >> GICD_ITARGETS61_TARGET_SHIFT)
#define  GICD_ITARGETS61_TARGET_REPLACE_VAL(reg,val) (((reg) & ~GICD_ITARGETS61_TARGET_MASK) | (((uint32_t)val) << GICD_ITARGETS61_TARGET_SHIFT))

//====================================================================
//Register: GIC400 Interrupt Target Processor Register (Instance 63 of 64) (ITARGETS62)
/** \brief GIC400 Interrupt Target Processor Register (Instance 63 of 64)*/
//====================================================================

#define  GICD_ITARGETS62_TARGET_MASK 0xffffffff
#define  GICD_ITARGETS62_TARGET_SHIFT 0
#define  GICD_ITARGETS62_TARGET_MASK_SHIFT(reg) (((reg) & GICD_ITARGETS62_TARGET_MASK) >> GICD_ITARGETS62_TARGET_SHIFT)
#define  GICD_ITARGETS62_TARGET_REPLACE_VAL(reg,val) (((reg) & ~GICD_ITARGETS62_TARGET_MASK) | (((uint32_t)val) << GICD_ITARGETS62_TARGET_SHIFT))

//====================================================================
//Register: GIC400 Interrupt Target Processor Register (Instance 64 of 64) (ITARGETS63)
/** \brief GIC400 Interrupt Target Processor Register (Instance 64 of 64)*/
//====================================================================

#define  GICD_ITARGETS63_TARGET_MASK 0xffffffff
#define  GICD_ITARGETS63_TARGET_SHIFT 0
#define  GICD_ITARGETS63_TARGET_MASK_SHIFT(reg) (((reg) & GICD_ITARGETS63_TARGET_MASK) >> GICD_ITARGETS63_TARGET_SHIFT)
#define  GICD_ITARGETS63_TARGET_REPLACE_VAL(reg,val) (((reg) & ~GICD_ITARGETS63_TARGET_MASK) | (((uint32_t)val) << GICD_ITARGETS63_TARGET_SHIFT))

//====================================================================
//Register: GIC400 SPI Interrupt Configuration Register (Instance 1 of 16) (ICFG0)
/** \brief GIC400 SPI Interrupt Target Processor Register (Instance 1 of 16)*/
//====================================================================

#define  GICD_ICFG0_CFG15_MASK 0xc0000000
#define  GICD_ICFG0_CFG15_SHIFT 30
#define  GICD_ICFG0_CFG15_MASK_SHIFT(reg) (((reg) & GICD_ICFG0_CFG15_MASK) >> GICD_ICFG0_CFG15_SHIFT)
#define  GICD_ICFG0_CFG15_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG0_CFG15_MASK) | (((uint32_t)val) << GICD_ICFG0_CFG15_SHIFT))

#define  GICD_ICFG0_CFG14_MASK 0x30000000
#define  GICD_ICFG0_CFG14_SHIFT 28
#define  GICD_ICFG0_CFG14_MASK_SHIFT(reg) (((reg) & GICD_ICFG0_CFG14_MASK) >> GICD_ICFG0_CFG14_SHIFT)
#define  GICD_ICFG0_CFG14_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG0_CFG14_MASK) | (((uint32_t)val) << GICD_ICFG0_CFG14_SHIFT))

#define  GICD_ICFG0_CFG13_MASK 0xc000000
#define  GICD_ICFG0_CFG13_SHIFT 26
#define  GICD_ICFG0_CFG13_MASK_SHIFT(reg) (((reg) & GICD_ICFG0_CFG13_MASK) >> GICD_ICFG0_CFG13_SHIFT)
#define  GICD_ICFG0_CFG13_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG0_CFG13_MASK) | (((uint32_t)val) << GICD_ICFG0_CFG13_SHIFT))

#define  GICD_ICFG0_CFG12_MASK 0x3000000
#define  GICD_ICFG0_CFG12_SHIFT 24
#define  GICD_ICFG0_CFG12_MASK_SHIFT(reg) (((reg) & GICD_ICFG0_CFG12_MASK) >> GICD_ICFG0_CFG12_SHIFT)
#define  GICD_ICFG0_CFG12_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG0_CFG12_MASK) | (((uint32_t)val) << GICD_ICFG0_CFG12_SHIFT))

#define  GICD_ICFG0_CFG11_MASK 0xc00000
#define  GICD_ICFG0_CFG11_SHIFT 22
#define  GICD_ICFG0_CFG11_MASK_SHIFT(reg) (((reg) & GICD_ICFG0_CFG11_MASK) >> GICD_ICFG0_CFG11_SHIFT)
#define  GICD_ICFG0_CFG11_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG0_CFG11_MASK) | (((uint32_t)val) << GICD_ICFG0_CFG11_SHIFT))

#define  GICD_ICFG0_CFG10_MASK 0x300000
#define  GICD_ICFG0_CFG10_SHIFT 20
#define  GICD_ICFG0_CFG10_MASK_SHIFT(reg) (((reg) & GICD_ICFG0_CFG10_MASK) >> GICD_ICFG0_CFG10_SHIFT)
#define  GICD_ICFG0_CFG10_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG0_CFG10_MASK) | (((uint32_t)val) << GICD_ICFG0_CFG10_SHIFT))

#define  GICD_ICFG0_CFG9_MASK 0xc0000
#define  GICD_ICFG0_CFG9_SHIFT 18
#define  GICD_ICFG0_CFG9_MASK_SHIFT(reg) (((reg) & GICD_ICFG0_CFG9_MASK) >> GICD_ICFG0_CFG9_SHIFT)
#define  GICD_ICFG0_CFG9_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG0_CFG9_MASK) | (((uint32_t)val) << GICD_ICFG0_CFG9_SHIFT))

#define  GICD_ICFG0_CFG8_MASK 0x30000
#define  GICD_ICFG0_CFG8_SHIFT 16
#define  GICD_ICFG0_CFG8_MASK_SHIFT(reg) (((reg) & GICD_ICFG0_CFG8_MASK) >> GICD_ICFG0_CFG8_SHIFT)
#define  GICD_ICFG0_CFG8_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG0_CFG8_MASK) | (((uint32_t)val) << GICD_ICFG0_CFG8_SHIFT))

#define  GICD_ICFG0_CFG7_MASK 0xc000
#define  GICD_ICFG0_CFG7_SHIFT 14
#define  GICD_ICFG0_CFG7_MASK_SHIFT(reg) (((reg) & GICD_ICFG0_CFG7_MASK) >> GICD_ICFG0_CFG7_SHIFT)
#define  GICD_ICFG0_CFG7_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG0_CFG7_MASK) | (((uint32_t)val) << GICD_ICFG0_CFG7_SHIFT))

#define  GICD_ICFG0_CFG6_MASK 0x3000
#define  GICD_ICFG0_CFG6_SHIFT 12
#define  GICD_ICFG0_CFG6_MASK_SHIFT(reg) (((reg) & GICD_ICFG0_CFG6_MASK) >> GICD_ICFG0_CFG6_SHIFT)
#define  GICD_ICFG0_CFG6_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG0_CFG6_MASK) | (((uint32_t)val) << GICD_ICFG0_CFG6_SHIFT))

#define  GICD_ICFG0_CFG5_MASK 0xc00
#define  GICD_ICFG0_CFG5_SHIFT 10
#define  GICD_ICFG0_CFG5_MASK_SHIFT(reg) (((reg) & GICD_ICFG0_CFG5_MASK) >> GICD_ICFG0_CFG5_SHIFT)
#define  GICD_ICFG0_CFG5_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG0_CFG5_MASK) | (((uint32_t)val) << GICD_ICFG0_CFG5_SHIFT))

#define  GICD_ICFG0_CFG4_MASK 0x300
#define  GICD_ICFG0_CFG4_SHIFT 8
#define  GICD_ICFG0_CFG4_MASK_SHIFT(reg) (((reg) & GICD_ICFG0_CFG4_MASK) >> GICD_ICFG0_CFG4_SHIFT)
#define  GICD_ICFG0_CFG4_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG0_CFG4_MASK) | (((uint32_t)val) << GICD_ICFG0_CFG4_SHIFT))

#define  GICD_ICFG0_CFG3_MASK 0xc0
#define  GICD_ICFG0_CFG3_SHIFT 6
#define  GICD_ICFG0_CFG3_MASK_SHIFT(reg) (((reg) & GICD_ICFG0_CFG3_MASK) >> GICD_ICFG0_CFG3_SHIFT)
#define  GICD_ICFG0_CFG3_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG0_CFG3_MASK) | (((uint32_t)val) << GICD_ICFG0_CFG3_SHIFT))

#define  GICD_ICFG0_CFG2_MASK 0x30
#define  GICD_ICFG0_CFG2_SHIFT 4
#define  GICD_ICFG0_CFG2_MASK_SHIFT(reg) (((reg) & GICD_ICFG0_CFG2_MASK) >> GICD_ICFG0_CFG2_SHIFT)
#define  GICD_ICFG0_CFG2_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG0_CFG2_MASK) | (((uint32_t)val) << GICD_ICFG0_CFG2_SHIFT))

#define  GICD_ICFG0_CFG1_MASK 0xc
#define  GICD_ICFG0_CFG1_SHIFT 2
#define  GICD_ICFG0_CFG1_MASK_SHIFT(reg) (((reg) & GICD_ICFG0_CFG1_MASK) >> GICD_ICFG0_CFG1_SHIFT)
#define  GICD_ICFG0_CFG1_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG0_CFG1_MASK) | (((uint32_t)val) << GICD_ICFG0_CFG1_SHIFT))

#define  GICD_ICFG0_CFG0_MASK 0x3
#define  GICD_ICFG0_CFG0_SHIFT 0
#define  GICD_ICFG0_CFG0_MASK_SHIFT(reg) (((reg) & GICD_ICFG0_CFG0_MASK) >> GICD_ICFG0_CFG0_SHIFT)
#define  GICD_ICFG0_CFG0_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG0_CFG0_MASK) | (((uint32_t)val) << GICD_ICFG0_CFG0_SHIFT))

//====================================================================
//Register: GIC400 SPI Interrupt Configuration Register (Instance 2 of 16) (ICFG1)
/** \brief GIC400 SPI Interrupt Target Processor Register (Instance 2 of 16)*/
//====================================================================

#define  GICD_ICFG1_CFG15_MASK 0xc0000000
#define  GICD_ICFG1_CFG15_SHIFT 30
#define  GICD_ICFG1_CFG15_MASK_SHIFT(reg) (((reg) & GICD_ICFG1_CFG15_MASK) >> GICD_ICFG1_CFG15_SHIFT)
#define  GICD_ICFG1_CFG15_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG1_CFG15_MASK) | (((uint32_t)val) << GICD_ICFG1_CFG15_SHIFT))

#define  GICD_ICFG1_CFG14_MASK 0x30000000
#define  GICD_ICFG1_CFG14_SHIFT 28
#define  GICD_ICFG1_CFG14_MASK_SHIFT(reg) (((reg) & GICD_ICFG1_CFG14_MASK) >> GICD_ICFG1_CFG14_SHIFT)
#define  GICD_ICFG1_CFG14_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG1_CFG14_MASK) | (((uint32_t)val) << GICD_ICFG1_CFG14_SHIFT))

#define  GICD_ICFG1_CFG13_MASK 0xc000000
#define  GICD_ICFG1_CFG13_SHIFT 26
#define  GICD_ICFG1_CFG13_MASK_SHIFT(reg) (((reg) & GICD_ICFG1_CFG13_MASK) >> GICD_ICFG1_CFG13_SHIFT)
#define  GICD_ICFG1_CFG13_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG1_CFG13_MASK) | (((uint32_t)val) << GICD_ICFG1_CFG13_SHIFT))

#define  GICD_ICFG1_CFG12_MASK 0x3000000
#define  GICD_ICFG1_CFG12_SHIFT 24
#define  GICD_ICFG1_CFG12_MASK_SHIFT(reg) (((reg) & GICD_ICFG1_CFG12_MASK) >> GICD_ICFG1_CFG12_SHIFT)
#define  GICD_ICFG1_CFG12_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG1_CFG12_MASK) | (((uint32_t)val) << GICD_ICFG1_CFG12_SHIFT))

#define  GICD_ICFG1_CFG11_MASK 0xc00000
#define  GICD_ICFG1_CFG11_SHIFT 22
#define  GICD_ICFG1_CFG11_MASK_SHIFT(reg) (((reg) & GICD_ICFG1_CFG11_MASK) >> GICD_ICFG1_CFG11_SHIFT)
#define  GICD_ICFG1_CFG11_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG1_CFG11_MASK) | (((uint32_t)val) << GICD_ICFG1_CFG11_SHIFT))

#define  GICD_ICFG1_CFG10_MASK 0x300000
#define  GICD_ICFG1_CFG10_SHIFT 20
#define  GICD_ICFG1_CFG10_MASK_SHIFT(reg) (((reg) & GICD_ICFG1_CFG10_MASK) >> GICD_ICFG1_CFG10_SHIFT)
#define  GICD_ICFG1_CFG10_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG1_CFG10_MASK) | (((uint32_t)val) << GICD_ICFG1_CFG10_SHIFT))

#define  GICD_ICFG1_CFG9_MASK 0xc0000
#define  GICD_ICFG1_CFG9_SHIFT 18
#define  GICD_ICFG1_CFG9_MASK_SHIFT(reg) (((reg) & GICD_ICFG1_CFG9_MASK) >> GICD_ICFG1_CFG9_SHIFT)
#define  GICD_ICFG1_CFG9_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG1_CFG9_MASK) | (((uint32_t)val) << GICD_ICFG1_CFG9_SHIFT))

#define  GICD_ICFG1_CFG8_MASK 0x30000
#define  GICD_ICFG1_CFG8_SHIFT 16
#define  GICD_ICFG1_CFG8_MASK_SHIFT(reg) (((reg) & GICD_ICFG1_CFG8_MASK) >> GICD_ICFG1_CFG8_SHIFT)
#define  GICD_ICFG1_CFG8_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG1_CFG8_MASK) | (((uint32_t)val) << GICD_ICFG1_CFG8_SHIFT))

#define  GICD_ICFG1_CFG7_MASK 0xc000
#define  GICD_ICFG1_CFG7_SHIFT 14
#define  GICD_ICFG1_CFG7_MASK_SHIFT(reg) (((reg) & GICD_ICFG1_CFG7_MASK) >> GICD_ICFG1_CFG7_SHIFT)
#define  GICD_ICFG1_CFG7_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG1_CFG7_MASK) | (((uint32_t)val) << GICD_ICFG1_CFG7_SHIFT))

#define  GICD_ICFG1_CFG6_MASK 0x3000
#define  GICD_ICFG1_CFG6_SHIFT 12
#define  GICD_ICFG1_CFG6_MASK_SHIFT(reg) (((reg) & GICD_ICFG1_CFG6_MASK) >> GICD_ICFG1_CFG6_SHIFT)
#define  GICD_ICFG1_CFG6_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG1_CFG6_MASK) | (((uint32_t)val) << GICD_ICFG1_CFG6_SHIFT))

#define  GICD_ICFG1_CFG5_MASK 0xc00
#define  GICD_ICFG1_CFG5_SHIFT 10
#define  GICD_ICFG1_CFG5_MASK_SHIFT(reg) (((reg) & GICD_ICFG1_CFG5_MASK) >> GICD_ICFG1_CFG5_SHIFT)
#define  GICD_ICFG1_CFG5_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG1_CFG5_MASK) | (((uint32_t)val) << GICD_ICFG1_CFG5_SHIFT))

#define  GICD_ICFG1_CFG4_MASK 0x300
#define  GICD_ICFG1_CFG4_SHIFT 8
#define  GICD_ICFG1_CFG4_MASK_SHIFT(reg) (((reg) & GICD_ICFG1_CFG4_MASK) >> GICD_ICFG1_CFG4_SHIFT)
#define  GICD_ICFG1_CFG4_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG1_CFG4_MASK) | (((uint32_t)val) << GICD_ICFG1_CFG4_SHIFT))

#define  GICD_ICFG1_CFG3_MASK 0xc0
#define  GICD_ICFG1_CFG3_SHIFT 6
#define  GICD_ICFG1_CFG3_MASK_SHIFT(reg) (((reg) & GICD_ICFG1_CFG3_MASK) >> GICD_ICFG1_CFG3_SHIFT)
#define  GICD_ICFG1_CFG3_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG1_CFG3_MASK) | (((uint32_t)val) << GICD_ICFG1_CFG3_SHIFT))

#define  GICD_ICFG1_CFG2_MASK 0x30
#define  GICD_ICFG1_CFG2_SHIFT 4
#define  GICD_ICFG1_CFG2_MASK_SHIFT(reg) (((reg) & GICD_ICFG1_CFG2_MASK) >> GICD_ICFG1_CFG2_SHIFT)
#define  GICD_ICFG1_CFG2_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG1_CFG2_MASK) | (((uint32_t)val) << GICD_ICFG1_CFG2_SHIFT))

#define  GICD_ICFG1_CFG1_MASK 0xc
#define  GICD_ICFG1_CFG1_SHIFT 2
#define  GICD_ICFG1_CFG1_MASK_SHIFT(reg) (((reg) & GICD_ICFG1_CFG1_MASK) >> GICD_ICFG1_CFG1_SHIFT)
#define  GICD_ICFG1_CFG1_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG1_CFG1_MASK) | (((uint32_t)val) << GICD_ICFG1_CFG1_SHIFT))

#define  GICD_ICFG1_CFG0_MASK 0x3
#define  GICD_ICFG1_CFG0_SHIFT 0
#define  GICD_ICFG1_CFG0_MASK_SHIFT(reg) (((reg) & GICD_ICFG1_CFG0_MASK) >> GICD_ICFG1_CFG0_SHIFT)
#define  GICD_ICFG1_CFG0_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG1_CFG0_MASK) | (((uint32_t)val) << GICD_ICFG1_CFG0_SHIFT))

//====================================================================
//Register: GIC400 SPI Interrupt Configuration Register (Instance 3 of 16) (ICFG2)
/** \brief GIC400 SPI Interrupt Target Processor Register (Instance 3 of 16)*/
//====================================================================

#define  GICD_ICFG2_CFG15_MASK 0xc0000000
#define  GICD_ICFG2_CFG15_SHIFT 30
#define  GICD_ICFG2_CFG15_MASK_SHIFT(reg) (((reg) & GICD_ICFG2_CFG15_MASK) >> GICD_ICFG2_CFG15_SHIFT)
#define  GICD_ICFG2_CFG15_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG2_CFG15_MASK) | (((uint32_t)val) << GICD_ICFG2_CFG15_SHIFT))

#define  GICD_ICFG2_CFG14_MASK 0x30000000
#define  GICD_ICFG2_CFG14_SHIFT 28
#define  GICD_ICFG2_CFG14_MASK_SHIFT(reg) (((reg) & GICD_ICFG2_CFG14_MASK) >> GICD_ICFG2_CFG14_SHIFT)
#define  GICD_ICFG2_CFG14_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG2_CFG14_MASK) | (((uint32_t)val) << GICD_ICFG2_CFG14_SHIFT))

#define  GICD_ICFG2_CFG13_MASK 0xc000000
#define  GICD_ICFG2_CFG13_SHIFT 26
#define  GICD_ICFG2_CFG13_MASK_SHIFT(reg) (((reg) & GICD_ICFG2_CFG13_MASK) >> GICD_ICFG2_CFG13_SHIFT)
#define  GICD_ICFG2_CFG13_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG2_CFG13_MASK) | (((uint32_t)val) << GICD_ICFG2_CFG13_SHIFT))

#define  GICD_ICFG2_CFG12_MASK 0x3000000
#define  GICD_ICFG2_CFG12_SHIFT 24
#define  GICD_ICFG2_CFG12_MASK_SHIFT(reg) (((reg) & GICD_ICFG2_CFG12_MASK) >> GICD_ICFG2_CFG12_SHIFT)
#define  GICD_ICFG2_CFG12_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG2_CFG12_MASK) | (((uint32_t)val) << GICD_ICFG2_CFG12_SHIFT))

#define  GICD_ICFG2_CFG11_MASK 0xc00000
#define  GICD_ICFG2_CFG11_SHIFT 22
#define  GICD_ICFG2_CFG11_MASK_SHIFT(reg) (((reg) & GICD_ICFG2_CFG11_MASK) >> GICD_ICFG2_CFG11_SHIFT)
#define  GICD_ICFG2_CFG11_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG2_CFG11_MASK) | (((uint32_t)val) << GICD_ICFG2_CFG11_SHIFT))

#define  GICD_ICFG2_CFG10_MASK 0x300000
#define  GICD_ICFG2_CFG10_SHIFT 20
#define  GICD_ICFG2_CFG10_MASK_SHIFT(reg) (((reg) & GICD_ICFG2_CFG10_MASK) >> GICD_ICFG2_CFG10_SHIFT)
#define  GICD_ICFG2_CFG10_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG2_CFG10_MASK) | (((uint32_t)val) << GICD_ICFG2_CFG10_SHIFT))

#define  GICD_ICFG2_CFG9_MASK 0xc0000
#define  GICD_ICFG2_CFG9_SHIFT 18
#define  GICD_ICFG2_CFG9_MASK_SHIFT(reg) (((reg) & GICD_ICFG2_CFG9_MASK) >> GICD_ICFG2_CFG9_SHIFT)
#define  GICD_ICFG2_CFG9_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG2_CFG9_MASK) | (((uint32_t)val) << GICD_ICFG2_CFG9_SHIFT))

#define  GICD_ICFG2_CFG8_MASK 0x30000
#define  GICD_ICFG2_CFG8_SHIFT 16
#define  GICD_ICFG2_CFG8_MASK_SHIFT(reg) (((reg) & GICD_ICFG2_CFG8_MASK) >> GICD_ICFG2_CFG8_SHIFT)
#define  GICD_ICFG2_CFG8_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG2_CFG8_MASK) | (((uint32_t)val) << GICD_ICFG2_CFG8_SHIFT))

#define  GICD_ICFG2_CFG7_MASK 0xc000
#define  GICD_ICFG2_CFG7_SHIFT 14
#define  GICD_ICFG2_CFG7_MASK_SHIFT(reg) (((reg) & GICD_ICFG2_CFG7_MASK) >> GICD_ICFG2_CFG7_SHIFT)
#define  GICD_ICFG2_CFG7_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG2_CFG7_MASK) | (((uint32_t)val) << GICD_ICFG2_CFG7_SHIFT))

#define  GICD_ICFG2_CFG6_MASK 0x3000
#define  GICD_ICFG2_CFG6_SHIFT 12
#define  GICD_ICFG2_CFG6_MASK_SHIFT(reg) (((reg) & GICD_ICFG2_CFG6_MASK) >> GICD_ICFG2_CFG6_SHIFT)
#define  GICD_ICFG2_CFG6_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG2_CFG6_MASK) | (((uint32_t)val) << GICD_ICFG2_CFG6_SHIFT))

#define  GICD_ICFG2_CFG5_MASK 0xc00
#define  GICD_ICFG2_CFG5_SHIFT 10
#define  GICD_ICFG2_CFG5_MASK_SHIFT(reg) (((reg) & GICD_ICFG2_CFG5_MASK) >> GICD_ICFG2_CFG5_SHIFT)
#define  GICD_ICFG2_CFG5_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG2_CFG5_MASK) | (((uint32_t)val) << GICD_ICFG2_CFG5_SHIFT))

#define  GICD_ICFG2_CFG4_MASK 0x300
#define  GICD_ICFG2_CFG4_SHIFT 8
#define  GICD_ICFG2_CFG4_MASK_SHIFT(reg) (((reg) & GICD_ICFG2_CFG4_MASK) >> GICD_ICFG2_CFG4_SHIFT)
#define  GICD_ICFG2_CFG4_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG2_CFG4_MASK) | (((uint32_t)val) << GICD_ICFG2_CFG4_SHIFT))

#define  GICD_ICFG2_CFG3_MASK 0xc0
#define  GICD_ICFG2_CFG3_SHIFT 6
#define  GICD_ICFG2_CFG3_MASK_SHIFT(reg) (((reg) & GICD_ICFG2_CFG3_MASK) >> GICD_ICFG2_CFG3_SHIFT)
#define  GICD_ICFG2_CFG3_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG2_CFG3_MASK) | (((uint32_t)val) << GICD_ICFG2_CFG3_SHIFT))

#define  GICD_ICFG2_CFG2_MASK 0x30
#define  GICD_ICFG2_CFG2_SHIFT 4
#define  GICD_ICFG2_CFG2_MASK_SHIFT(reg) (((reg) & GICD_ICFG2_CFG2_MASK) >> GICD_ICFG2_CFG2_SHIFT)
#define  GICD_ICFG2_CFG2_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG2_CFG2_MASK) | (((uint32_t)val) << GICD_ICFG2_CFG2_SHIFT))

#define  GICD_ICFG2_CFG1_MASK 0xc
#define  GICD_ICFG2_CFG1_SHIFT 2
#define  GICD_ICFG2_CFG1_MASK_SHIFT(reg) (((reg) & GICD_ICFG2_CFG1_MASK) >> GICD_ICFG2_CFG1_SHIFT)
#define  GICD_ICFG2_CFG1_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG2_CFG1_MASK) | (((uint32_t)val) << GICD_ICFG2_CFG1_SHIFT))

#define  GICD_ICFG2_CFG0_MASK 0x3
#define  GICD_ICFG2_CFG0_SHIFT 0
#define  GICD_ICFG2_CFG0_MASK_SHIFT(reg) (((reg) & GICD_ICFG2_CFG0_MASK) >> GICD_ICFG2_CFG0_SHIFT)
#define  GICD_ICFG2_CFG0_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG2_CFG0_MASK) | (((uint32_t)val) << GICD_ICFG2_CFG0_SHIFT))

//====================================================================
//Register: GIC400 SPI Interrupt Configuration Register (Instance 4 of 16) (ICFG3)
/** \brief GIC400 SPI Interrupt Target Processor Register (Instance 4 of 16)*/
//====================================================================

#define  GICD_ICFG3_CFG15_MASK 0xc0000000
#define  GICD_ICFG3_CFG15_SHIFT 30
#define  GICD_ICFG3_CFG15_MASK_SHIFT(reg) (((reg) & GICD_ICFG3_CFG15_MASK) >> GICD_ICFG3_CFG15_SHIFT)
#define  GICD_ICFG3_CFG15_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG3_CFG15_MASK) | (((uint32_t)val) << GICD_ICFG3_CFG15_SHIFT))

#define  GICD_ICFG3_CFG14_MASK 0x30000000
#define  GICD_ICFG3_CFG14_SHIFT 28
#define  GICD_ICFG3_CFG14_MASK_SHIFT(reg) (((reg) & GICD_ICFG3_CFG14_MASK) >> GICD_ICFG3_CFG14_SHIFT)
#define  GICD_ICFG3_CFG14_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG3_CFG14_MASK) | (((uint32_t)val) << GICD_ICFG3_CFG14_SHIFT))

#define  GICD_ICFG3_CFG13_MASK 0xc000000
#define  GICD_ICFG3_CFG13_SHIFT 26
#define  GICD_ICFG3_CFG13_MASK_SHIFT(reg) (((reg) & GICD_ICFG3_CFG13_MASK) >> GICD_ICFG3_CFG13_SHIFT)
#define  GICD_ICFG3_CFG13_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG3_CFG13_MASK) | (((uint32_t)val) << GICD_ICFG3_CFG13_SHIFT))

#define  GICD_ICFG3_CFG12_MASK 0x3000000
#define  GICD_ICFG3_CFG12_SHIFT 24
#define  GICD_ICFG3_CFG12_MASK_SHIFT(reg) (((reg) & GICD_ICFG3_CFG12_MASK) >> GICD_ICFG3_CFG12_SHIFT)
#define  GICD_ICFG3_CFG12_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG3_CFG12_MASK) | (((uint32_t)val) << GICD_ICFG3_CFG12_SHIFT))

#define  GICD_ICFG3_CFG11_MASK 0xc00000
#define  GICD_ICFG3_CFG11_SHIFT 22
#define  GICD_ICFG3_CFG11_MASK_SHIFT(reg) (((reg) & GICD_ICFG3_CFG11_MASK) >> GICD_ICFG3_CFG11_SHIFT)
#define  GICD_ICFG3_CFG11_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG3_CFG11_MASK) | (((uint32_t)val) << GICD_ICFG3_CFG11_SHIFT))

#define  GICD_ICFG3_CFG10_MASK 0x300000
#define  GICD_ICFG3_CFG10_SHIFT 20
#define  GICD_ICFG3_CFG10_MASK_SHIFT(reg) (((reg) & GICD_ICFG3_CFG10_MASK) >> GICD_ICFG3_CFG10_SHIFT)
#define  GICD_ICFG3_CFG10_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG3_CFG10_MASK) | (((uint32_t)val) << GICD_ICFG3_CFG10_SHIFT))

#define  GICD_ICFG3_CFG9_MASK 0xc0000
#define  GICD_ICFG3_CFG9_SHIFT 18
#define  GICD_ICFG3_CFG9_MASK_SHIFT(reg) (((reg) & GICD_ICFG3_CFG9_MASK) >> GICD_ICFG3_CFG9_SHIFT)
#define  GICD_ICFG3_CFG9_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG3_CFG9_MASK) | (((uint32_t)val) << GICD_ICFG3_CFG9_SHIFT))

#define  GICD_ICFG3_CFG8_MASK 0x30000
#define  GICD_ICFG3_CFG8_SHIFT 16
#define  GICD_ICFG3_CFG8_MASK_SHIFT(reg) (((reg) & GICD_ICFG3_CFG8_MASK) >> GICD_ICFG3_CFG8_SHIFT)
#define  GICD_ICFG3_CFG8_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG3_CFG8_MASK) | (((uint32_t)val) << GICD_ICFG3_CFG8_SHIFT))

#define  GICD_ICFG3_CFG7_MASK 0xc000
#define  GICD_ICFG3_CFG7_SHIFT 14
#define  GICD_ICFG3_CFG7_MASK_SHIFT(reg) (((reg) & GICD_ICFG3_CFG7_MASK) >> GICD_ICFG3_CFG7_SHIFT)
#define  GICD_ICFG3_CFG7_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG3_CFG7_MASK) | (((uint32_t)val) << GICD_ICFG3_CFG7_SHIFT))

#define  GICD_ICFG3_CFG6_MASK 0x3000
#define  GICD_ICFG3_CFG6_SHIFT 12
#define  GICD_ICFG3_CFG6_MASK_SHIFT(reg) (((reg) & GICD_ICFG3_CFG6_MASK) >> GICD_ICFG3_CFG6_SHIFT)
#define  GICD_ICFG3_CFG6_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG3_CFG6_MASK) | (((uint32_t)val) << GICD_ICFG3_CFG6_SHIFT))

#define  GICD_ICFG3_CFG5_MASK 0xc00
#define  GICD_ICFG3_CFG5_SHIFT 10
#define  GICD_ICFG3_CFG5_MASK_SHIFT(reg) (((reg) & GICD_ICFG3_CFG5_MASK) >> GICD_ICFG3_CFG5_SHIFT)
#define  GICD_ICFG3_CFG5_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG3_CFG5_MASK) | (((uint32_t)val) << GICD_ICFG3_CFG5_SHIFT))

#define  GICD_ICFG3_CFG4_MASK 0x300
#define  GICD_ICFG3_CFG4_SHIFT 8
#define  GICD_ICFG3_CFG4_MASK_SHIFT(reg) (((reg) & GICD_ICFG3_CFG4_MASK) >> GICD_ICFG3_CFG4_SHIFT)
#define  GICD_ICFG3_CFG4_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG3_CFG4_MASK) | (((uint32_t)val) << GICD_ICFG3_CFG4_SHIFT))

#define  GICD_ICFG3_CFG3_MASK 0xc0
#define  GICD_ICFG3_CFG3_SHIFT 6
#define  GICD_ICFG3_CFG3_MASK_SHIFT(reg) (((reg) & GICD_ICFG3_CFG3_MASK) >> GICD_ICFG3_CFG3_SHIFT)
#define  GICD_ICFG3_CFG3_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG3_CFG3_MASK) | (((uint32_t)val) << GICD_ICFG3_CFG3_SHIFT))

#define  GICD_ICFG3_CFG2_MASK 0x30
#define  GICD_ICFG3_CFG2_SHIFT 4
#define  GICD_ICFG3_CFG2_MASK_SHIFT(reg) (((reg) & GICD_ICFG3_CFG2_MASK) >> GICD_ICFG3_CFG2_SHIFT)
#define  GICD_ICFG3_CFG2_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG3_CFG2_MASK) | (((uint32_t)val) << GICD_ICFG3_CFG2_SHIFT))

#define  GICD_ICFG3_CFG1_MASK 0xc
#define  GICD_ICFG3_CFG1_SHIFT 2
#define  GICD_ICFG3_CFG1_MASK_SHIFT(reg) (((reg) & GICD_ICFG3_CFG1_MASK) >> GICD_ICFG3_CFG1_SHIFT)
#define  GICD_ICFG3_CFG1_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG3_CFG1_MASK) | (((uint32_t)val) << GICD_ICFG3_CFG1_SHIFT))

#define  GICD_ICFG3_CFG0_MASK 0x3
#define  GICD_ICFG3_CFG0_SHIFT 0
#define  GICD_ICFG3_CFG0_MASK_SHIFT(reg) (((reg) & GICD_ICFG3_CFG0_MASK) >> GICD_ICFG3_CFG0_SHIFT)
#define  GICD_ICFG3_CFG0_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG3_CFG0_MASK) | (((uint32_t)val) << GICD_ICFG3_CFG0_SHIFT))

//====================================================================
//Register: GIC400 SPI Interrupt Configuration Register (Instance 5 of 16) (ICFG4)
/** \brief GIC400 SPI Interrupt Target Processor Register (Instance 5 of 16)*/
//====================================================================

#define  GICD_ICFG4_CFG15_MASK 0xc0000000
#define  GICD_ICFG4_CFG15_SHIFT 30
#define  GICD_ICFG4_CFG15_MASK_SHIFT(reg) (((reg) & GICD_ICFG4_CFG15_MASK) >> GICD_ICFG4_CFG15_SHIFT)
#define  GICD_ICFG4_CFG15_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG4_CFG15_MASK) | (((uint32_t)val) << GICD_ICFG4_CFG15_SHIFT))

#define  GICD_ICFG4_CFG14_MASK 0x30000000
#define  GICD_ICFG4_CFG14_SHIFT 28
#define  GICD_ICFG4_CFG14_MASK_SHIFT(reg) (((reg) & GICD_ICFG4_CFG14_MASK) >> GICD_ICFG4_CFG14_SHIFT)
#define  GICD_ICFG4_CFG14_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG4_CFG14_MASK) | (((uint32_t)val) << GICD_ICFG4_CFG14_SHIFT))

#define  GICD_ICFG4_CFG13_MASK 0xc000000
#define  GICD_ICFG4_CFG13_SHIFT 26
#define  GICD_ICFG4_CFG13_MASK_SHIFT(reg) (((reg) & GICD_ICFG4_CFG13_MASK) >> GICD_ICFG4_CFG13_SHIFT)
#define  GICD_ICFG4_CFG13_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG4_CFG13_MASK) | (((uint32_t)val) << GICD_ICFG4_CFG13_SHIFT))

#define  GICD_ICFG4_CFG12_MASK 0x3000000
#define  GICD_ICFG4_CFG12_SHIFT 24
#define  GICD_ICFG4_CFG12_MASK_SHIFT(reg) (((reg) & GICD_ICFG4_CFG12_MASK) >> GICD_ICFG4_CFG12_SHIFT)
#define  GICD_ICFG4_CFG12_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG4_CFG12_MASK) | (((uint32_t)val) << GICD_ICFG4_CFG12_SHIFT))

#define  GICD_ICFG4_CFG11_MASK 0xc00000
#define  GICD_ICFG4_CFG11_SHIFT 22
#define  GICD_ICFG4_CFG11_MASK_SHIFT(reg) (((reg) & GICD_ICFG4_CFG11_MASK) >> GICD_ICFG4_CFG11_SHIFT)
#define  GICD_ICFG4_CFG11_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG4_CFG11_MASK) | (((uint32_t)val) << GICD_ICFG4_CFG11_SHIFT))

#define  GICD_ICFG4_CFG10_MASK 0x300000
#define  GICD_ICFG4_CFG10_SHIFT 20
#define  GICD_ICFG4_CFG10_MASK_SHIFT(reg) (((reg) & GICD_ICFG4_CFG10_MASK) >> GICD_ICFG4_CFG10_SHIFT)
#define  GICD_ICFG4_CFG10_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG4_CFG10_MASK) | (((uint32_t)val) << GICD_ICFG4_CFG10_SHIFT))

#define  GICD_ICFG4_CFG9_MASK 0xc0000
#define  GICD_ICFG4_CFG9_SHIFT 18
#define  GICD_ICFG4_CFG9_MASK_SHIFT(reg) (((reg) & GICD_ICFG4_CFG9_MASK) >> GICD_ICFG4_CFG9_SHIFT)
#define  GICD_ICFG4_CFG9_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG4_CFG9_MASK) | (((uint32_t)val) << GICD_ICFG4_CFG9_SHIFT))

#define  GICD_ICFG4_CFG8_MASK 0x30000
#define  GICD_ICFG4_CFG8_SHIFT 16
#define  GICD_ICFG4_CFG8_MASK_SHIFT(reg) (((reg) & GICD_ICFG4_CFG8_MASK) >> GICD_ICFG4_CFG8_SHIFT)
#define  GICD_ICFG4_CFG8_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG4_CFG8_MASK) | (((uint32_t)val) << GICD_ICFG4_CFG8_SHIFT))

#define  GICD_ICFG4_CFG7_MASK 0xc000
#define  GICD_ICFG4_CFG7_SHIFT 14
#define  GICD_ICFG4_CFG7_MASK_SHIFT(reg) (((reg) & GICD_ICFG4_CFG7_MASK) >> GICD_ICFG4_CFG7_SHIFT)
#define  GICD_ICFG4_CFG7_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG4_CFG7_MASK) | (((uint32_t)val) << GICD_ICFG4_CFG7_SHIFT))

#define  GICD_ICFG4_CFG6_MASK 0x3000
#define  GICD_ICFG4_CFG6_SHIFT 12
#define  GICD_ICFG4_CFG6_MASK_SHIFT(reg) (((reg) & GICD_ICFG4_CFG6_MASK) >> GICD_ICFG4_CFG6_SHIFT)
#define  GICD_ICFG4_CFG6_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG4_CFG6_MASK) | (((uint32_t)val) << GICD_ICFG4_CFG6_SHIFT))

#define  GICD_ICFG4_CFG5_MASK 0xc00
#define  GICD_ICFG4_CFG5_SHIFT 10
#define  GICD_ICFG4_CFG5_MASK_SHIFT(reg) (((reg) & GICD_ICFG4_CFG5_MASK) >> GICD_ICFG4_CFG5_SHIFT)
#define  GICD_ICFG4_CFG5_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG4_CFG5_MASK) | (((uint32_t)val) << GICD_ICFG4_CFG5_SHIFT))

#define  GICD_ICFG4_CFG4_MASK 0x300
#define  GICD_ICFG4_CFG4_SHIFT 8
#define  GICD_ICFG4_CFG4_MASK_SHIFT(reg) (((reg) & GICD_ICFG4_CFG4_MASK) >> GICD_ICFG4_CFG4_SHIFT)
#define  GICD_ICFG4_CFG4_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG4_CFG4_MASK) | (((uint32_t)val) << GICD_ICFG4_CFG4_SHIFT))

#define  GICD_ICFG4_CFG3_MASK 0xc0
#define  GICD_ICFG4_CFG3_SHIFT 6
#define  GICD_ICFG4_CFG3_MASK_SHIFT(reg) (((reg) & GICD_ICFG4_CFG3_MASK) >> GICD_ICFG4_CFG3_SHIFT)
#define  GICD_ICFG4_CFG3_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG4_CFG3_MASK) | (((uint32_t)val) << GICD_ICFG4_CFG3_SHIFT))

#define  GICD_ICFG4_CFG2_MASK 0x30
#define  GICD_ICFG4_CFG2_SHIFT 4
#define  GICD_ICFG4_CFG2_MASK_SHIFT(reg) (((reg) & GICD_ICFG4_CFG2_MASK) >> GICD_ICFG4_CFG2_SHIFT)
#define  GICD_ICFG4_CFG2_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG4_CFG2_MASK) | (((uint32_t)val) << GICD_ICFG4_CFG2_SHIFT))

#define  GICD_ICFG4_CFG1_MASK 0xc
#define  GICD_ICFG4_CFG1_SHIFT 2
#define  GICD_ICFG4_CFG1_MASK_SHIFT(reg) (((reg) & GICD_ICFG4_CFG1_MASK) >> GICD_ICFG4_CFG1_SHIFT)
#define  GICD_ICFG4_CFG1_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG4_CFG1_MASK) | (((uint32_t)val) << GICD_ICFG4_CFG1_SHIFT))

#define  GICD_ICFG4_CFG0_MASK 0x3
#define  GICD_ICFG4_CFG0_SHIFT 0
#define  GICD_ICFG4_CFG0_MASK_SHIFT(reg) (((reg) & GICD_ICFG4_CFG0_MASK) >> GICD_ICFG4_CFG0_SHIFT)
#define  GICD_ICFG4_CFG0_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG4_CFG0_MASK) | (((uint32_t)val) << GICD_ICFG4_CFG0_SHIFT))

//====================================================================
//Register: GIC400 SPI Interrupt Configuration Register (Instance 6 of 16) (ICFG5)
/** \brief GIC400 SPI Interrupt Target Processor Register (Instance 6 of 16)*/
//====================================================================

#define  GICD_ICFG5_CFG15_MASK 0xc0000000
#define  GICD_ICFG5_CFG15_SHIFT 30
#define  GICD_ICFG5_CFG15_MASK_SHIFT(reg) (((reg) & GICD_ICFG5_CFG15_MASK) >> GICD_ICFG5_CFG15_SHIFT)
#define  GICD_ICFG5_CFG15_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG5_CFG15_MASK) | (((uint32_t)val) << GICD_ICFG5_CFG15_SHIFT))

#define  GICD_ICFG5_CFG14_MASK 0x30000000
#define  GICD_ICFG5_CFG14_SHIFT 28
#define  GICD_ICFG5_CFG14_MASK_SHIFT(reg) (((reg) & GICD_ICFG5_CFG14_MASK) >> GICD_ICFG5_CFG14_SHIFT)
#define  GICD_ICFG5_CFG14_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG5_CFG14_MASK) | (((uint32_t)val) << GICD_ICFG5_CFG14_SHIFT))

#define  GICD_ICFG5_CFG13_MASK 0xc000000
#define  GICD_ICFG5_CFG13_SHIFT 26
#define  GICD_ICFG5_CFG13_MASK_SHIFT(reg) (((reg) & GICD_ICFG5_CFG13_MASK) >> GICD_ICFG5_CFG13_SHIFT)
#define  GICD_ICFG5_CFG13_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG5_CFG13_MASK) | (((uint32_t)val) << GICD_ICFG5_CFG13_SHIFT))

#define  GICD_ICFG5_CFG12_MASK 0x3000000
#define  GICD_ICFG5_CFG12_SHIFT 24
#define  GICD_ICFG5_CFG12_MASK_SHIFT(reg) (((reg) & GICD_ICFG5_CFG12_MASK) >> GICD_ICFG5_CFG12_SHIFT)
#define  GICD_ICFG5_CFG12_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG5_CFG12_MASK) | (((uint32_t)val) << GICD_ICFG5_CFG12_SHIFT))

#define  GICD_ICFG5_CFG11_MASK 0xc00000
#define  GICD_ICFG5_CFG11_SHIFT 22
#define  GICD_ICFG5_CFG11_MASK_SHIFT(reg) (((reg) & GICD_ICFG5_CFG11_MASK) >> GICD_ICFG5_CFG11_SHIFT)
#define  GICD_ICFG5_CFG11_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG5_CFG11_MASK) | (((uint32_t)val) << GICD_ICFG5_CFG11_SHIFT))

#define  GICD_ICFG5_CFG10_MASK 0x300000
#define  GICD_ICFG5_CFG10_SHIFT 20
#define  GICD_ICFG5_CFG10_MASK_SHIFT(reg) (((reg) & GICD_ICFG5_CFG10_MASK) >> GICD_ICFG5_CFG10_SHIFT)
#define  GICD_ICFG5_CFG10_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG5_CFG10_MASK) | (((uint32_t)val) << GICD_ICFG5_CFG10_SHIFT))

#define  GICD_ICFG5_CFG9_MASK 0xc0000
#define  GICD_ICFG5_CFG9_SHIFT 18
#define  GICD_ICFG5_CFG9_MASK_SHIFT(reg) (((reg) & GICD_ICFG5_CFG9_MASK) >> GICD_ICFG5_CFG9_SHIFT)
#define  GICD_ICFG5_CFG9_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG5_CFG9_MASK) | (((uint32_t)val) << GICD_ICFG5_CFG9_SHIFT))

#define  GICD_ICFG5_CFG8_MASK 0x30000
#define  GICD_ICFG5_CFG8_SHIFT 16
#define  GICD_ICFG5_CFG8_MASK_SHIFT(reg) (((reg) & GICD_ICFG5_CFG8_MASK) >> GICD_ICFG5_CFG8_SHIFT)
#define  GICD_ICFG5_CFG8_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG5_CFG8_MASK) | (((uint32_t)val) << GICD_ICFG5_CFG8_SHIFT))

#define  GICD_ICFG5_CFG7_MASK 0xc000
#define  GICD_ICFG5_CFG7_SHIFT 14
#define  GICD_ICFG5_CFG7_MASK_SHIFT(reg) (((reg) & GICD_ICFG5_CFG7_MASK) >> GICD_ICFG5_CFG7_SHIFT)
#define  GICD_ICFG5_CFG7_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG5_CFG7_MASK) | (((uint32_t)val) << GICD_ICFG5_CFG7_SHIFT))

#define  GICD_ICFG5_CFG6_MASK 0x3000
#define  GICD_ICFG5_CFG6_SHIFT 12
#define  GICD_ICFG5_CFG6_MASK_SHIFT(reg) (((reg) & GICD_ICFG5_CFG6_MASK) >> GICD_ICFG5_CFG6_SHIFT)
#define  GICD_ICFG5_CFG6_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG5_CFG6_MASK) | (((uint32_t)val) << GICD_ICFG5_CFG6_SHIFT))

#define  GICD_ICFG5_CFG5_MASK 0xc00
#define  GICD_ICFG5_CFG5_SHIFT 10
#define  GICD_ICFG5_CFG5_MASK_SHIFT(reg) (((reg) & GICD_ICFG5_CFG5_MASK) >> GICD_ICFG5_CFG5_SHIFT)
#define  GICD_ICFG5_CFG5_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG5_CFG5_MASK) | (((uint32_t)val) << GICD_ICFG5_CFG5_SHIFT))

#define  GICD_ICFG5_CFG4_MASK 0x300
#define  GICD_ICFG5_CFG4_SHIFT 8
#define  GICD_ICFG5_CFG4_MASK_SHIFT(reg) (((reg) & GICD_ICFG5_CFG4_MASK) >> GICD_ICFG5_CFG4_SHIFT)
#define  GICD_ICFG5_CFG4_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG5_CFG4_MASK) | (((uint32_t)val) << GICD_ICFG5_CFG4_SHIFT))

#define  GICD_ICFG5_CFG3_MASK 0xc0
#define  GICD_ICFG5_CFG3_SHIFT 6
#define  GICD_ICFG5_CFG3_MASK_SHIFT(reg) (((reg) & GICD_ICFG5_CFG3_MASK) >> GICD_ICFG5_CFG3_SHIFT)
#define  GICD_ICFG5_CFG3_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG5_CFG3_MASK) | (((uint32_t)val) << GICD_ICFG5_CFG3_SHIFT))

#define  GICD_ICFG5_CFG2_MASK 0x30
#define  GICD_ICFG5_CFG2_SHIFT 4
#define  GICD_ICFG5_CFG2_MASK_SHIFT(reg) (((reg) & GICD_ICFG5_CFG2_MASK) >> GICD_ICFG5_CFG2_SHIFT)
#define  GICD_ICFG5_CFG2_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG5_CFG2_MASK) | (((uint32_t)val) << GICD_ICFG5_CFG2_SHIFT))

#define  GICD_ICFG5_CFG1_MASK 0xc
#define  GICD_ICFG5_CFG1_SHIFT 2
#define  GICD_ICFG5_CFG1_MASK_SHIFT(reg) (((reg) & GICD_ICFG5_CFG1_MASK) >> GICD_ICFG5_CFG1_SHIFT)
#define  GICD_ICFG5_CFG1_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG5_CFG1_MASK) | (((uint32_t)val) << GICD_ICFG5_CFG1_SHIFT))

#define  GICD_ICFG5_CFG0_MASK 0x3
#define  GICD_ICFG5_CFG0_SHIFT 0
#define  GICD_ICFG5_CFG0_MASK_SHIFT(reg) (((reg) & GICD_ICFG5_CFG0_MASK) >> GICD_ICFG5_CFG0_SHIFT)
#define  GICD_ICFG5_CFG0_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG5_CFG0_MASK) | (((uint32_t)val) << GICD_ICFG5_CFG0_SHIFT))

//====================================================================
//Register: GIC400 SPI Interrupt Configuration Register (Instance 7 of 16) (ICFG6)
/** \brief GIC400 SPI Interrupt Target Processor Register (Instance 7 of 16)*/
//====================================================================

#define  GICD_ICFG6_CFG15_MASK 0xc0000000
#define  GICD_ICFG6_CFG15_SHIFT 30
#define  GICD_ICFG6_CFG15_MASK_SHIFT(reg) (((reg) & GICD_ICFG6_CFG15_MASK) >> GICD_ICFG6_CFG15_SHIFT)
#define  GICD_ICFG6_CFG15_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG6_CFG15_MASK) | (((uint32_t)val) << GICD_ICFG6_CFG15_SHIFT))

#define  GICD_ICFG6_CFG14_MASK 0x30000000
#define  GICD_ICFG6_CFG14_SHIFT 28
#define  GICD_ICFG6_CFG14_MASK_SHIFT(reg) (((reg) & GICD_ICFG6_CFG14_MASK) >> GICD_ICFG6_CFG14_SHIFT)
#define  GICD_ICFG6_CFG14_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG6_CFG14_MASK) | (((uint32_t)val) << GICD_ICFG6_CFG14_SHIFT))

#define  GICD_ICFG6_CFG13_MASK 0xc000000
#define  GICD_ICFG6_CFG13_SHIFT 26
#define  GICD_ICFG6_CFG13_MASK_SHIFT(reg) (((reg) & GICD_ICFG6_CFG13_MASK) >> GICD_ICFG6_CFG13_SHIFT)
#define  GICD_ICFG6_CFG13_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG6_CFG13_MASK) | (((uint32_t)val) << GICD_ICFG6_CFG13_SHIFT))

#define  GICD_ICFG6_CFG12_MASK 0x3000000
#define  GICD_ICFG6_CFG12_SHIFT 24
#define  GICD_ICFG6_CFG12_MASK_SHIFT(reg) (((reg) & GICD_ICFG6_CFG12_MASK) >> GICD_ICFG6_CFG12_SHIFT)
#define  GICD_ICFG6_CFG12_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG6_CFG12_MASK) | (((uint32_t)val) << GICD_ICFG6_CFG12_SHIFT))

#define  GICD_ICFG6_CFG11_MASK 0xc00000
#define  GICD_ICFG6_CFG11_SHIFT 22
#define  GICD_ICFG6_CFG11_MASK_SHIFT(reg) (((reg) & GICD_ICFG6_CFG11_MASK) >> GICD_ICFG6_CFG11_SHIFT)
#define  GICD_ICFG6_CFG11_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG6_CFG11_MASK) | (((uint32_t)val) << GICD_ICFG6_CFG11_SHIFT))

#define  GICD_ICFG6_CFG10_MASK 0x300000
#define  GICD_ICFG6_CFG10_SHIFT 20
#define  GICD_ICFG6_CFG10_MASK_SHIFT(reg) (((reg) & GICD_ICFG6_CFG10_MASK) >> GICD_ICFG6_CFG10_SHIFT)
#define  GICD_ICFG6_CFG10_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG6_CFG10_MASK) | (((uint32_t)val) << GICD_ICFG6_CFG10_SHIFT))

#define  GICD_ICFG6_CFG9_MASK 0xc0000
#define  GICD_ICFG6_CFG9_SHIFT 18
#define  GICD_ICFG6_CFG9_MASK_SHIFT(reg) (((reg) & GICD_ICFG6_CFG9_MASK) >> GICD_ICFG6_CFG9_SHIFT)
#define  GICD_ICFG6_CFG9_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG6_CFG9_MASK) | (((uint32_t)val) << GICD_ICFG6_CFG9_SHIFT))

#define  GICD_ICFG6_CFG8_MASK 0x30000
#define  GICD_ICFG6_CFG8_SHIFT 16
#define  GICD_ICFG6_CFG8_MASK_SHIFT(reg) (((reg) & GICD_ICFG6_CFG8_MASK) >> GICD_ICFG6_CFG8_SHIFT)
#define  GICD_ICFG6_CFG8_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG6_CFG8_MASK) | (((uint32_t)val) << GICD_ICFG6_CFG8_SHIFT))

#define  GICD_ICFG6_CFG7_MASK 0xc000
#define  GICD_ICFG6_CFG7_SHIFT 14
#define  GICD_ICFG6_CFG7_MASK_SHIFT(reg) (((reg) & GICD_ICFG6_CFG7_MASK) >> GICD_ICFG6_CFG7_SHIFT)
#define  GICD_ICFG6_CFG7_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG6_CFG7_MASK) | (((uint32_t)val) << GICD_ICFG6_CFG7_SHIFT))

#define  GICD_ICFG6_CFG6_MASK 0x3000
#define  GICD_ICFG6_CFG6_SHIFT 12
#define  GICD_ICFG6_CFG6_MASK_SHIFT(reg) (((reg) & GICD_ICFG6_CFG6_MASK) >> GICD_ICFG6_CFG6_SHIFT)
#define  GICD_ICFG6_CFG6_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG6_CFG6_MASK) | (((uint32_t)val) << GICD_ICFG6_CFG6_SHIFT))

#define  GICD_ICFG6_CFG5_MASK 0xc00
#define  GICD_ICFG6_CFG5_SHIFT 10
#define  GICD_ICFG6_CFG5_MASK_SHIFT(reg) (((reg) & GICD_ICFG6_CFG5_MASK) >> GICD_ICFG6_CFG5_SHIFT)
#define  GICD_ICFG6_CFG5_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG6_CFG5_MASK) | (((uint32_t)val) << GICD_ICFG6_CFG5_SHIFT))

#define  GICD_ICFG6_CFG4_MASK 0x300
#define  GICD_ICFG6_CFG4_SHIFT 8
#define  GICD_ICFG6_CFG4_MASK_SHIFT(reg) (((reg) & GICD_ICFG6_CFG4_MASK) >> GICD_ICFG6_CFG4_SHIFT)
#define  GICD_ICFG6_CFG4_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG6_CFG4_MASK) | (((uint32_t)val) << GICD_ICFG6_CFG4_SHIFT))

#define  GICD_ICFG6_CFG3_MASK 0xc0
#define  GICD_ICFG6_CFG3_SHIFT 6
#define  GICD_ICFG6_CFG3_MASK_SHIFT(reg) (((reg) & GICD_ICFG6_CFG3_MASK) >> GICD_ICFG6_CFG3_SHIFT)
#define  GICD_ICFG6_CFG3_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG6_CFG3_MASK) | (((uint32_t)val) << GICD_ICFG6_CFG3_SHIFT))

#define  GICD_ICFG6_CFG2_MASK 0x30
#define  GICD_ICFG6_CFG2_SHIFT 4
#define  GICD_ICFG6_CFG2_MASK_SHIFT(reg) (((reg) & GICD_ICFG6_CFG2_MASK) >> GICD_ICFG6_CFG2_SHIFT)
#define  GICD_ICFG6_CFG2_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG6_CFG2_MASK) | (((uint32_t)val) << GICD_ICFG6_CFG2_SHIFT))

#define  GICD_ICFG6_CFG1_MASK 0xc
#define  GICD_ICFG6_CFG1_SHIFT 2
#define  GICD_ICFG6_CFG1_MASK_SHIFT(reg) (((reg) & GICD_ICFG6_CFG1_MASK) >> GICD_ICFG6_CFG1_SHIFT)
#define  GICD_ICFG6_CFG1_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG6_CFG1_MASK) | (((uint32_t)val) << GICD_ICFG6_CFG1_SHIFT))

#define  GICD_ICFG6_CFG0_MASK 0x3
#define  GICD_ICFG6_CFG0_SHIFT 0
#define  GICD_ICFG6_CFG0_MASK_SHIFT(reg) (((reg) & GICD_ICFG6_CFG0_MASK) >> GICD_ICFG6_CFG0_SHIFT)
#define  GICD_ICFG6_CFG0_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG6_CFG0_MASK) | (((uint32_t)val) << GICD_ICFG6_CFG0_SHIFT))

//====================================================================
//Register: GIC400 SPI Interrupt Configuration Register (Instance 8 of 16) (ICFG7)
/** \brief GIC400 SPI Interrupt Target Processor Register (Instance 8 of 16)*/
//====================================================================

#define  GICD_ICFG7_CFG15_MASK 0xc0000000
#define  GICD_ICFG7_CFG15_SHIFT 30
#define  GICD_ICFG7_CFG15_MASK_SHIFT(reg) (((reg) & GICD_ICFG7_CFG15_MASK) >> GICD_ICFG7_CFG15_SHIFT)
#define  GICD_ICFG7_CFG15_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG7_CFG15_MASK) | (((uint32_t)val) << GICD_ICFG7_CFG15_SHIFT))

#define  GICD_ICFG7_CFG14_MASK 0x30000000
#define  GICD_ICFG7_CFG14_SHIFT 28
#define  GICD_ICFG7_CFG14_MASK_SHIFT(reg) (((reg) & GICD_ICFG7_CFG14_MASK) >> GICD_ICFG7_CFG14_SHIFT)
#define  GICD_ICFG7_CFG14_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG7_CFG14_MASK) | (((uint32_t)val) << GICD_ICFG7_CFG14_SHIFT))

#define  GICD_ICFG7_CFG13_MASK 0xc000000
#define  GICD_ICFG7_CFG13_SHIFT 26
#define  GICD_ICFG7_CFG13_MASK_SHIFT(reg) (((reg) & GICD_ICFG7_CFG13_MASK) >> GICD_ICFG7_CFG13_SHIFT)
#define  GICD_ICFG7_CFG13_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG7_CFG13_MASK) | (((uint32_t)val) << GICD_ICFG7_CFG13_SHIFT))

#define  GICD_ICFG7_CFG12_MASK 0x3000000
#define  GICD_ICFG7_CFG12_SHIFT 24
#define  GICD_ICFG7_CFG12_MASK_SHIFT(reg) (((reg) & GICD_ICFG7_CFG12_MASK) >> GICD_ICFG7_CFG12_SHIFT)
#define  GICD_ICFG7_CFG12_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG7_CFG12_MASK) | (((uint32_t)val) << GICD_ICFG7_CFG12_SHIFT))

#define  GICD_ICFG7_CFG11_MASK 0xc00000
#define  GICD_ICFG7_CFG11_SHIFT 22
#define  GICD_ICFG7_CFG11_MASK_SHIFT(reg) (((reg) & GICD_ICFG7_CFG11_MASK) >> GICD_ICFG7_CFG11_SHIFT)
#define  GICD_ICFG7_CFG11_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG7_CFG11_MASK) | (((uint32_t)val) << GICD_ICFG7_CFG11_SHIFT))

#define  GICD_ICFG7_CFG10_MASK 0x300000
#define  GICD_ICFG7_CFG10_SHIFT 20
#define  GICD_ICFG7_CFG10_MASK_SHIFT(reg) (((reg) & GICD_ICFG7_CFG10_MASK) >> GICD_ICFG7_CFG10_SHIFT)
#define  GICD_ICFG7_CFG10_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG7_CFG10_MASK) | (((uint32_t)val) << GICD_ICFG7_CFG10_SHIFT))

#define  GICD_ICFG7_CFG9_MASK 0xc0000
#define  GICD_ICFG7_CFG9_SHIFT 18
#define  GICD_ICFG7_CFG9_MASK_SHIFT(reg) (((reg) & GICD_ICFG7_CFG9_MASK) >> GICD_ICFG7_CFG9_SHIFT)
#define  GICD_ICFG7_CFG9_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG7_CFG9_MASK) | (((uint32_t)val) << GICD_ICFG7_CFG9_SHIFT))

#define  GICD_ICFG7_CFG8_MASK 0x30000
#define  GICD_ICFG7_CFG8_SHIFT 16
#define  GICD_ICFG7_CFG8_MASK_SHIFT(reg) (((reg) & GICD_ICFG7_CFG8_MASK) >> GICD_ICFG7_CFG8_SHIFT)
#define  GICD_ICFG7_CFG8_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG7_CFG8_MASK) | (((uint32_t)val) << GICD_ICFG7_CFG8_SHIFT))

#define  GICD_ICFG7_CFG7_MASK 0xc000
#define  GICD_ICFG7_CFG7_SHIFT 14
#define  GICD_ICFG7_CFG7_MASK_SHIFT(reg) (((reg) & GICD_ICFG7_CFG7_MASK) >> GICD_ICFG7_CFG7_SHIFT)
#define  GICD_ICFG7_CFG7_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG7_CFG7_MASK) | (((uint32_t)val) << GICD_ICFG7_CFG7_SHIFT))

#define  GICD_ICFG7_CFG6_MASK 0x3000
#define  GICD_ICFG7_CFG6_SHIFT 12
#define  GICD_ICFG7_CFG6_MASK_SHIFT(reg) (((reg) & GICD_ICFG7_CFG6_MASK) >> GICD_ICFG7_CFG6_SHIFT)
#define  GICD_ICFG7_CFG6_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG7_CFG6_MASK) | (((uint32_t)val) << GICD_ICFG7_CFG6_SHIFT))

#define  GICD_ICFG7_CFG5_MASK 0xc00
#define  GICD_ICFG7_CFG5_SHIFT 10
#define  GICD_ICFG7_CFG5_MASK_SHIFT(reg) (((reg) & GICD_ICFG7_CFG5_MASK) >> GICD_ICFG7_CFG5_SHIFT)
#define  GICD_ICFG7_CFG5_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG7_CFG5_MASK) | (((uint32_t)val) << GICD_ICFG7_CFG5_SHIFT))

#define  GICD_ICFG7_CFG4_MASK 0x300
#define  GICD_ICFG7_CFG4_SHIFT 8
#define  GICD_ICFG7_CFG4_MASK_SHIFT(reg) (((reg) & GICD_ICFG7_CFG4_MASK) >> GICD_ICFG7_CFG4_SHIFT)
#define  GICD_ICFG7_CFG4_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG7_CFG4_MASK) | (((uint32_t)val) << GICD_ICFG7_CFG4_SHIFT))

#define  GICD_ICFG7_CFG3_MASK 0xc0
#define  GICD_ICFG7_CFG3_SHIFT 6
#define  GICD_ICFG7_CFG3_MASK_SHIFT(reg) (((reg) & GICD_ICFG7_CFG3_MASK) >> GICD_ICFG7_CFG3_SHIFT)
#define  GICD_ICFG7_CFG3_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG7_CFG3_MASK) | (((uint32_t)val) << GICD_ICFG7_CFG3_SHIFT))

#define  GICD_ICFG7_CFG2_MASK 0x30
#define  GICD_ICFG7_CFG2_SHIFT 4
#define  GICD_ICFG7_CFG2_MASK_SHIFT(reg) (((reg) & GICD_ICFG7_CFG2_MASK) >> GICD_ICFG7_CFG2_SHIFT)
#define  GICD_ICFG7_CFG2_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG7_CFG2_MASK) | (((uint32_t)val) << GICD_ICFG7_CFG2_SHIFT))

#define  GICD_ICFG7_CFG1_MASK 0xc
#define  GICD_ICFG7_CFG1_SHIFT 2
#define  GICD_ICFG7_CFG1_MASK_SHIFT(reg) (((reg) & GICD_ICFG7_CFG1_MASK) >> GICD_ICFG7_CFG1_SHIFT)
#define  GICD_ICFG7_CFG1_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG7_CFG1_MASK) | (((uint32_t)val) << GICD_ICFG7_CFG1_SHIFT))

#define  GICD_ICFG7_CFG0_MASK 0x3
#define  GICD_ICFG7_CFG0_SHIFT 0
#define  GICD_ICFG7_CFG0_MASK_SHIFT(reg) (((reg) & GICD_ICFG7_CFG0_MASK) >> GICD_ICFG7_CFG0_SHIFT)
#define  GICD_ICFG7_CFG0_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG7_CFG0_MASK) | (((uint32_t)val) << GICD_ICFG7_CFG0_SHIFT))

//====================================================================
//Register: GIC400 SPI Interrupt Configuration Register (Instance 9 of 16) (ICFG8)
/** \brief GIC400 SPI Interrupt Target Processor Register (Instance 9 of 16)*/
//====================================================================

#define  GICD_ICFG8_CFG15_MASK 0xc0000000
#define  GICD_ICFG8_CFG15_SHIFT 30
#define  GICD_ICFG8_CFG15_MASK_SHIFT(reg) (((reg) & GICD_ICFG8_CFG15_MASK) >> GICD_ICFG8_CFG15_SHIFT)
#define  GICD_ICFG8_CFG15_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG8_CFG15_MASK) | (((uint32_t)val) << GICD_ICFG8_CFG15_SHIFT))

#define  GICD_ICFG8_CFG14_MASK 0x30000000
#define  GICD_ICFG8_CFG14_SHIFT 28
#define  GICD_ICFG8_CFG14_MASK_SHIFT(reg) (((reg) & GICD_ICFG8_CFG14_MASK) >> GICD_ICFG8_CFG14_SHIFT)
#define  GICD_ICFG8_CFG14_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG8_CFG14_MASK) | (((uint32_t)val) << GICD_ICFG8_CFG14_SHIFT))

#define  GICD_ICFG8_CFG13_MASK 0xc000000
#define  GICD_ICFG8_CFG13_SHIFT 26
#define  GICD_ICFG8_CFG13_MASK_SHIFT(reg) (((reg) & GICD_ICFG8_CFG13_MASK) >> GICD_ICFG8_CFG13_SHIFT)
#define  GICD_ICFG8_CFG13_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG8_CFG13_MASK) | (((uint32_t)val) << GICD_ICFG8_CFG13_SHIFT))

#define  GICD_ICFG8_CFG12_MASK 0x3000000
#define  GICD_ICFG8_CFG12_SHIFT 24
#define  GICD_ICFG8_CFG12_MASK_SHIFT(reg) (((reg) & GICD_ICFG8_CFG12_MASK) >> GICD_ICFG8_CFG12_SHIFT)
#define  GICD_ICFG8_CFG12_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG8_CFG12_MASK) | (((uint32_t)val) << GICD_ICFG8_CFG12_SHIFT))

#define  GICD_ICFG8_CFG11_MASK 0xc00000
#define  GICD_ICFG8_CFG11_SHIFT 22
#define  GICD_ICFG8_CFG11_MASK_SHIFT(reg) (((reg) & GICD_ICFG8_CFG11_MASK) >> GICD_ICFG8_CFG11_SHIFT)
#define  GICD_ICFG8_CFG11_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG8_CFG11_MASK) | (((uint32_t)val) << GICD_ICFG8_CFG11_SHIFT))

#define  GICD_ICFG8_CFG10_MASK 0x300000
#define  GICD_ICFG8_CFG10_SHIFT 20
#define  GICD_ICFG8_CFG10_MASK_SHIFT(reg) (((reg) & GICD_ICFG8_CFG10_MASK) >> GICD_ICFG8_CFG10_SHIFT)
#define  GICD_ICFG8_CFG10_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG8_CFG10_MASK) | (((uint32_t)val) << GICD_ICFG8_CFG10_SHIFT))

#define  GICD_ICFG8_CFG9_MASK 0xc0000
#define  GICD_ICFG8_CFG9_SHIFT 18
#define  GICD_ICFG8_CFG9_MASK_SHIFT(reg) (((reg) & GICD_ICFG8_CFG9_MASK) >> GICD_ICFG8_CFG9_SHIFT)
#define  GICD_ICFG8_CFG9_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG8_CFG9_MASK) | (((uint32_t)val) << GICD_ICFG8_CFG9_SHIFT))

#define  GICD_ICFG8_CFG8_MASK 0x30000
#define  GICD_ICFG8_CFG8_SHIFT 16
#define  GICD_ICFG8_CFG8_MASK_SHIFT(reg) (((reg) & GICD_ICFG8_CFG8_MASK) >> GICD_ICFG8_CFG8_SHIFT)
#define  GICD_ICFG8_CFG8_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG8_CFG8_MASK) | (((uint32_t)val) << GICD_ICFG8_CFG8_SHIFT))

#define  GICD_ICFG8_CFG7_MASK 0xc000
#define  GICD_ICFG8_CFG7_SHIFT 14
#define  GICD_ICFG8_CFG7_MASK_SHIFT(reg) (((reg) & GICD_ICFG8_CFG7_MASK) >> GICD_ICFG8_CFG7_SHIFT)
#define  GICD_ICFG8_CFG7_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG8_CFG7_MASK) | (((uint32_t)val) << GICD_ICFG8_CFG7_SHIFT))

#define  GICD_ICFG8_CFG6_MASK 0x3000
#define  GICD_ICFG8_CFG6_SHIFT 12
#define  GICD_ICFG8_CFG6_MASK_SHIFT(reg) (((reg) & GICD_ICFG8_CFG6_MASK) >> GICD_ICFG8_CFG6_SHIFT)
#define  GICD_ICFG8_CFG6_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG8_CFG6_MASK) | (((uint32_t)val) << GICD_ICFG8_CFG6_SHIFT))

#define  GICD_ICFG8_CFG5_MASK 0xc00
#define  GICD_ICFG8_CFG5_SHIFT 10
#define  GICD_ICFG8_CFG5_MASK_SHIFT(reg) (((reg) & GICD_ICFG8_CFG5_MASK) >> GICD_ICFG8_CFG5_SHIFT)
#define  GICD_ICFG8_CFG5_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG8_CFG5_MASK) | (((uint32_t)val) << GICD_ICFG8_CFG5_SHIFT))

#define  GICD_ICFG8_CFG4_MASK 0x300
#define  GICD_ICFG8_CFG4_SHIFT 8
#define  GICD_ICFG8_CFG4_MASK_SHIFT(reg) (((reg) & GICD_ICFG8_CFG4_MASK) >> GICD_ICFG8_CFG4_SHIFT)
#define  GICD_ICFG8_CFG4_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG8_CFG4_MASK) | (((uint32_t)val) << GICD_ICFG8_CFG4_SHIFT))

#define  GICD_ICFG8_CFG3_MASK 0xc0
#define  GICD_ICFG8_CFG3_SHIFT 6
#define  GICD_ICFG8_CFG3_MASK_SHIFT(reg) (((reg) & GICD_ICFG8_CFG3_MASK) >> GICD_ICFG8_CFG3_SHIFT)
#define  GICD_ICFG8_CFG3_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG8_CFG3_MASK) | (((uint32_t)val) << GICD_ICFG8_CFG3_SHIFT))

#define  GICD_ICFG8_CFG2_MASK 0x30
#define  GICD_ICFG8_CFG2_SHIFT 4
#define  GICD_ICFG8_CFG2_MASK_SHIFT(reg) (((reg) & GICD_ICFG8_CFG2_MASK) >> GICD_ICFG8_CFG2_SHIFT)
#define  GICD_ICFG8_CFG2_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG8_CFG2_MASK) | (((uint32_t)val) << GICD_ICFG8_CFG2_SHIFT))

#define  GICD_ICFG8_CFG1_MASK 0xc
#define  GICD_ICFG8_CFG1_SHIFT 2
#define  GICD_ICFG8_CFG1_MASK_SHIFT(reg) (((reg) & GICD_ICFG8_CFG1_MASK) >> GICD_ICFG8_CFG1_SHIFT)
#define  GICD_ICFG8_CFG1_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG8_CFG1_MASK) | (((uint32_t)val) << GICD_ICFG8_CFG1_SHIFT))

#define  GICD_ICFG8_CFG0_MASK 0x3
#define  GICD_ICFG8_CFG0_SHIFT 0
#define  GICD_ICFG8_CFG0_MASK_SHIFT(reg) (((reg) & GICD_ICFG8_CFG0_MASK) >> GICD_ICFG8_CFG0_SHIFT)
#define  GICD_ICFG8_CFG0_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG8_CFG0_MASK) | (((uint32_t)val) << GICD_ICFG8_CFG0_SHIFT))

//====================================================================
//Register: GIC400 SPI Interrupt Configuration Register (Instance 10 of 16) (ICFG9)
/** \brief GIC400 SPI Interrupt Target Processor Register (Instance 10 of 16)*/
//====================================================================

#define  GICD_ICFG9_CFG15_MASK 0xc0000000
#define  GICD_ICFG9_CFG15_SHIFT 30
#define  GICD_ICFG9_CFG15_MASK_SHIFT(reg) (((reg) & GICD_ICFG9_CFG15_MASK) >> GICD_ICFG9_CFG15_SHIFT)
#define  GICD_ICFG9_CFG15_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG9_CFG15_MASK) | (((uint32_t)val) << GICD_ICFG9_CFG15_SHIFT))

#define  GICD_ICFG9_CFG14_MASK 0x30000000
#define  GICD_ICFG9_CFG14_SHIFT 28
#define  GICD_ICFG9_CFG14_MASK_SHIFT(reg) (((reg) & GICD_ICFG9_CFG14_MASK) >> GICD_ICFG9_CFG14_SHIFT)
#define  GICD_ICFG9_CFG14_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG9_CFG14_MASK) | (((uint32_t)val) << GICD_ICFG9_CFG14_SHIFT))

#define  GICD_ICFG9_CFG13_MASK 0xc000000
#define  GICD_ICFG9_CFG13_SHIFT 26
#define  GICD_ICFG9_CFG13_MASK_SHIFT(reg) (((reg) & GICD_ICFG9_CFG13_MASK) >> GICD_ICFG9_CFG13_SHIFT)
#define  GICD_ICFG9_CFG13_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG9_CFG13_MASK) | (((uint32_t)val) << GICD_ICFG9_CFG13_SHIFT))

#define  GICD_ICFG9_CFG12_MASK 0x3000000
#define  GICD_ICFG9_CFG12_SHIFT 24
#define  GICD_ICFG9_CFG12_MASK_SHIFT(reg) (((reg) & GICD_ICFG9_CFG12_MASK) >> GICD_ICFG9_CFG12_SHIFT)
#define  GICD_ICFG9_CFG12_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG9_CFG12_MASK) | (((uint32_t)val) << GICD_ICFG9_CFG12_SHIFT))

#define  GICD_ICFG9_CFG11_MASK 0xc00000
#define  GICD_ICFG9_CFG11_SHIFT 22
#define  GICD_ICFG9_CFG11_MASK_SHIFT(reg) (((reg) & GICD_ICFG9_CFG11_MASK) >> GICD_ICFG9_CFG11_SHIFT)
#define  GICD_ICFG9_CFG11_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG9_CFG11_MASK) | (((uint32_t)val) << GICD_ICFG9_CFG11_SHIFT))

#define  GICD_ICFG9_CFG10_MASK 0x300000
#define  GICD_ICFG9_CFG10_SHIFT 20
#define  GICD_ICFG9_CFG10_MASK_SHIFT(reg) (((reg) & GICD_ICFG9_CFG10_MASK) >> GICD_ICFG9_CFG10_SHIFT)
#define  GICD_ICFG9_CFG10_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG9_CFG10_MASK) | (((uint32_t)val) << GICD_ICFG9_CFG10_SHIFT))

#define  GICD_ICFG9_CFG9_MASK 0xc0000
#define  GICD_ICFG9_CFG9_SHIFT 18
#define  GICD_ICFG9_CFG9_MASK_SHIFT(reg) (((reg) & GICD_ICFG9_CFG9_MASK) >> GICD_ICFG9_CFG9_SHIFT)
#define  GICD_ICFG9_CFG9_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG9_CFG9_MASK) | (((uint32_t)val) << GICD_ICFG9_CFG9_SHIFT))

#define  GICD_ICFG9_CFG8_MASK 0x30000
#define  GICD_ICFG9_CFG8_SHIFT 16
#define  GICD_ICFG9_CFG8_MASK_SHIFT(reg) (((reg) & GICD_ICFG9_CFG8_MASK) >> GICD_ICFG9_CFG8_SHIFT)
#define  GICD_ICFG9_CFG8_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG9_CFG8_MASK) | (((uint32_t)val) << GICD_ICFG9_CFG8_SHIFT))

#define  GICD_ICFG9_CFG7_MASK 0xc000
#define  GICD_ICFG9_CFG7_SHIFT 14
#define  GICD_ICFG9_CFG7_MASK_SHIFT(reg) (((reg) & GICD_ICFG9_CFG7_MASK) >> GICD_ICFG9_CFG7_SHIFT)
#define  GICD_ICFG9_CFG7_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG9_CFG7_MASK) | (((uint32_t)val) << GICD_ICFG9_CFG7_SHIFT))

#define  GICD_ICFG9_CFG6_MASK 0x3000
#define  GICD_ICFG9_CFG6_SHIFT 12
#define  GICD_ICFG9_CFG6_MASK_SHIFT(reg) (((reg) & GICD_ICFG9_CFG6_MASK) >> GICD_ICFG9_CFG6_SHIFT)
#define  GICD_ICFG9_CFG6_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG9_CFG6_MASK) | (((uint32_t)val) << GICD_ICFG9_CFG6_SHIFT))

#define  GICD_ICFG9_CFG5_MASK 0xc00
#define  GICD_ICFG9_CFG5_SHIFT 10
#define  GICD_ICFG9_CFG5_MASK_SHIFT(reg) (((reg) & GICD_ICFG9_CFG5_MASK) >> GICD_ICFG9_CFG5_SHIFT)
#define  GICD_ICFG9_CFG5_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG9_CFG5_MASK) | (((uint32_t)val) << GICD_ICFG9_CFG5_SHIFT))

#define  GICD_ICFG9_CFG4_MASK 0x300
#define  GICD_ICFG9_CFG4_SHIFT 8
#define  GICD_ICFG9_CFG4_MASK_SHIFT(reg) (((reg) & GICD_ICFG9_CFG4_MASK) >> GICD_ICFG9_CFG4_SHIFT)
#define  GICD_ICFG9_CFG4_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG9_CFG4_MASK) | (((uint32_t)val) << GICD_ICFG9_CFG4_SHIFT))

#define  GICD_ICFG9_CFG3_MASK 0xc0
#define  GICD_ICFG9_CFG3_SHIFT 6
#define  GICD_ICFG9_CFG3_MASK_SHIFT(reg) (((reg) & GICD_ICFG9_CFG3_MASK) >> GICD_ICFG9_CFG3_SHIFT)
#define  GICD_ICFG9_CFG3_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG9_CFG3_MASK) | (((uint32_t)val) << GICD_ICFG9_CFG3_SHIFT))

#define  GICD_ICFG9_CFG2_MASK 0x30
#define  GICD_ICFG9_CFG2_SHIFT 4
#define  GICD_ICFG9_CFG2_MASK_SHIFT(reg) (((reg) & GICD_ICFG9_CFG2_MASK) >> GICD_ICFG9_CFG2_SHIFT)
#define  GICD_ICFG9_CFG2_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG9_CFG2_MASK) | (((uint32_t)val) << GICD_ICFG9_CFG2_SHIFT))

#define  GICD_ICFG9_CFG1_MASK 0xc
#define  GICD_ICFG9_CFG1_SHIFT 2
#define  GICD_ICFG9_CFG1_MASK_SHIFT(reg) (((reg) & GICD_ICFG9_CFG1_MASK) >> GICD_ICFG9_CFG1_SHIFT)
#define  GICD_ICFG9_CFG1_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG9_CFG1_MASK) | (((uint32_t)val) << GICD_ICFG9_CFG1_SHIFT))

#define  GICD_ICFG9_CFG0_MASK 0x3
#define  GICD_ICFG9_CFG0_SHIFT 0
#define  GICD_ICFG9_CFG0_MASK_SHIFT(reg) (((reg) & GICD_ICFG9_CFG0_MASK) >> GICD_ICFG9_CFG0_SHIFT)
#define  GICD_ICFG9_CFG0_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG9_CFG0_MASK) | (((uint32_t)val) << GICD_ICFG9_CFG0_SHIFT))

//====================================================================
//Register: GIC400 SPI Interrupt Configuration Register (Instance 11 of 16) (ICFG10)
/** \brief GIC400 SPI Interrupt Target Processor Register (Instance 11 of 16)*/
//====================================================================

#define  GICD_ICFG10_CFG15_MASK 0xc0000000
#define  GICD_ICFG10_CFG15_SHIFT 30
#define  GICD_ICFG10_CFG15_MASK_SHIFT(reg) (((reg) & GICD_ICFG10_CFG15_MASK) >> GICD_ICFG10_CFG15_SHIFT)
#define  GICD_ICFG10_CFG15_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG10_CFG15_MASK) | (((uint32_t)val) << GICD_ICFG10_CFG15_SHIFT))

#define  GICD_ICFG10_CFG14_MASK 0x30000000
#define  GICD_ICFG10_CFG14_SHIFT 28
#define  GICD_ICFG10_CFG14_MASK_SHIFT(reg) (((reg) & GICD_ICFG10_CFG14_MASK) >> GICD_ICFG10_CFG14_SHIFT)
#define  GICD_ICFG10_CFG14_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG10_CFG14_MASK) | (((uint32_t)val) << GICD_ICFG10_CFG14_SHIFT))

#define  GICD_ICFG10_CFG13_MASK 0xc000000
#define  GICD_ICFG10_CFG13_SHIFT 26
#define  GICD_ICFG10_CFG13_MASK_SHIFT(reg) (((reg) & GICD_ICFG10_CFG13_MASK) >> GICD_ICFG10_CFG13_SHIFT)
#define  GICD_ICFG10_CFG13_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG10_CFG13_MASK) | (((uint32_t)val) << GICD_ICFG10_CFG13_SHIFT))

#define  GICD_ICFG10_CFG12_MASK 0x3000000
#define  GICD_ICFG10_CFG12_SHIFT 24
#define  GICD_ICFG10_CFG12_MASK_SHIFT(reg) (((reg) & GICD_ICFG10_CFG12_MASK) >> GICD_ICFG10_CFG12_SHIFT)
#define  GICD_ICFG10_CFG12_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG10_CFG12_MASK) | (((uint32_t)val) << GICD_ICFG10_CFG12_SHIFT))

#define  GICD_ICFG10_CFG11_MASK 0xc00000
#define  GICD_ICFG10_CFG11_SHIFT 22
#define  GICD_ICFG10_CFG11_MASK_SHIFT(reg) (((reg) & GICD_ICFG10_CFG11_MASK) >> GICD_ICFG10_CFG11_SHIFT)
#define  GICD_ICFG10_CFG11_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG10_CFG11_MASK) | (((uint32_t)val) << GICD_ICFG10_CFG11_SHIFT))

#define  GICD_ICFG10_CFG10_MASK 0x300000
#define  GICD_ICFG10_CFG10_SHIFT 20
#define  GICD_ICFG10_CFG10_MASK_SHIFT(reg) (((reg) & GICD_ICFG10_CFG10_MASK) >> GICD_ICFG10_CFG10_SHIFT)
#define  GICD_ICFG10_CFG10_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG10_CFG10_MASK) | (((uint32_t)val) << GICD_ICFG10_CFG10_SHIFT))

#define  GICD_ICFG10_CFG9_MASK 0xc0000
#define  GICD_ICFG10_CFG9_SHIFT 18
#define  GICD_ICFG10_CFG9_MASK_SHIFT(reg) (((reg) & GICD_ICFG10_CFG9_MASK) >> GICD_ICFG10_CFG9_SHIFT)
#define  GICD_ICFG10_CFG9_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG10_CFG9_MASK) | (((uint32_t)val) << GICD_ICFG10_CFG9_SHIFT))

#define  GICD_ICFG10_CFG8_MASK 0x30000
#define  GICD_ICFG10_CFG8_SHIFT 16
#define  GICD_ICFG10_CFG8_MASK_SHIFT(reg) (((reg) & GICD_ICFG10_CFG8_MASK) >> GICD_ICFG10_CFG8_SHIFT)
#define  GICD_ICFG10_CFG8_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG10_CFG8_MASK) | (((uint32_t)val) << GICD_ICFG10_CFG8_SHIFT))

#define  GICD_ICFG10_CFG7_MASK 0xc000
#define  GICD_ICFG10_CFG7_SHIFT 14
#define  GICD_ICFG10_CFG7_MASK_SHIFT(reg) (((reg) & GICD_ICFG10_CFG7_MASK) >> GICD_ICFG10_CFG7_SHIFT)
#define  GICD_ICFG10_CFG7_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG10_CFG7_MASK) | (((uint32_t)val) << GICD_ICFG10_CFG7_SHIFT))

#define  GICD_ICFG10_CFG6_MASK 0x3000
#define  GICD_ICFG10_CFG6_SHIFT 12
#define  GICD_ICFG10_CFG6_MASK_SHIFT(reg) (((reg) & GICD_ICFG10_CFG6_MASK) >> GICD_ICFG10_CFG6_SHIFT)
#define  GICD_ICFG10_CFG6_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG10_CFG6_MASK) | (((uint32_t)val) << GICD_ICFG10_CFG6_SHIFT))

#define  GICD_ICFG10_CFG5_MASK 0xc00
#define  GICD_ICFG10_CFG5_SHIFT 10
#define  GICD_ICFG10_CFG5_MASK_SHIFT(reg) (((reg) & GICD_ICFG10_CFG5_MASK) >> GICD_ICFG10_CFG5_SHIFT)
#define  GICD_ICFG10_CFG5_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG10_CFG5_MASK) | (((uint32_t)val) << GICD_ICFG10_CFG5_SHIFT))

#define  GICD_ICFG10_CFG4_MASK 0x300
#define  GICD_ICFG10_CFG4_SHIFT 8
#define  GICD_ICFG10_CFG4_MASK_SHIFT(reg) (((reg) & GICD_ICFG10_CFG4_MASK) >> GICD_ICFG10_CFG4_SHIFT)
#define  GICD_ICFG10_CFG4_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG10_CFG4_MASK) | (((uint32_t)val) << GICD_ICFG10_CFG4_SHIFT))

#define  GICD_ICFG10_CFG3_MASK 0xc0
#define  GICD_ICFG10_CFG3_SHIFT 6
#define  GICD_ICFG10_CFG3_MASK_SHIFT(reg) (((reg) & GICD_ICFG10_CFG3_MASK) >> GICD_ICFG10_CFG3_SHIFT)
#define  GICD_ICFG10_CFG3_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG10_CFG3_MASK) | (((uint32_t)val) << GICD_ICFG10_CFG3_SHIFT))

#define  GICD_ICFG10_CFG2_MASK 0x30
#define  GICD_ICFG10_CFG2_SHIFT 4
#define  GICD_ICFG10_CFG2_MASK_SHIFT(reg) (((reg) & GICD_ICFG10_CFG2_MASK) >> GICD_ICFG10_CFG2_SHIFT)
#define  GICD_ICFG10_CFG2_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG10_CFG2_MASK) | (((uint32_t)val) << GICD_ICFG10_CFG2_SHIFT))

#define  GICD_ICFG10_CFG1_MASK 0xc
#define  GICD_ICFG10_CFG1_SHIFT 2
#define  GICD_ICFG10_CFG1_MASK_SHIFT(reg) (((reg) & GICD_ICFG10_CFG1_MASK) >> GICD_ICFG10_CFG1_SHIFT)
#define  GICD_ICFG10_CFG1_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG10_CFG1_MASK) | (((uint32_t)val) << GICD_ICFG10_CFG1_SHIFT))

#define  GICD_ICFG10_CFG0_MASK 0x3
#define  GICD_ICFG10_CFG0_SHIFT 0
#define  GICD_ICFG10_CFG0_MASK_SHIFT(reg) (((reg) & GICD_ICFG10_CFG0_MASK) >> GICD_ICFG10_CFG0_SHIFT)
#define  GICD_ICFG10_CFG0_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG10_CFG0_MASK) | (((uint32_t)val) << GICD_ICFG10_CFG0_SHIFT))

//====================================================================
//Register: GIC400 SPI Interrupt Configuration Register (Instance 12 of 16) (ICFG11)
/** \brief GIC400 SPI Interrupt Target Processor Register (Instance 12 of 16)*/
//====================================================================

#define  GICD_ICFG11_CFG15_MASK 0xc0000000
#define  GICD_ICFG11_CFG15_SHIFT 30
#define  GICD_ICFG11_CFG15_MASK_SHIFT(reg) (((reg) & GICD_ICFG11_CFG15_MASK) >> GICD_ICFG11_CFG15_SHIFT)
#define  GICD_ICFG11_CFG15_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG11_CFG15_MASK) | (((uint32_t)val) << GICD_ICFG11_CFG15_SHIFT))

#define  GICD_ICFG11_CFG14_MASK 0x30000000
#define  GICD_ICFG11_CFG14_SHIFT 28
#define  GICD_ICFG11_CFG14_MASK_SHIFT(reg) (((reg) & GICD_ICFG11_CFG14_MASK) >> GICD_ICFG11_CFG14_SHIFT)
#define  GICD_ICFG11_CFG14_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG11_CFG14_MASK) | (((uint32_t)val) << GICD_ICFG11_CFG14_SHIFT))

#define  GICD_ICFG11_CFG13_MASK 0xc000000
#define  GICD_ICFG11_CFG13_SHIFT 26
#define  GICD_ICFG11_CFG13_MASK_SHIFT(reg) (((reg) & GICD_ICFG11_CFG13_MASK) >> GICD_ICFG11_CFG13_SHIFT)
#define  GICD_ICFG11_CFG13_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG11_CFG13_MASK) | (((uint32_t)val) << GICD_ICFG11_CFG13_SHIFT))

#define  GICD_ICFG11_CFG12_MASK 0x3000000
#define  GICD_ICFG11_CFG12_SHIFT 24
#define  GICD_ICFG11_CFG12_MASK_SHIFT(reg) (((reg) & GICD_ICFG11_CFG12_MASK) >> GICD_ICFG11_CFG12_SHIFT)
#define  GICD_ICFG11_CFG12_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG11_CFG12_MASK) | (((uint32_t)val) << GICD_ICFG11_CFG12_SHIFT))

#define  GICD_ICFG11_CFG11_MASK 0xc00000
#define  GICD_ICFG11_CFG11_SHIFT 22
#define  GICD_ICFG11_CFG11_MASK_SHIFT(reg) (((reg) & GICD_ICFG11_CFG11_MASK) >> GICD_ICFG11_CFG11_SHIFT)
#define  GICD_ICFG11_CFG11_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG11_CFG11_MASK) | (((uint32_t)val) << GICD_ICFG11_CFG11_SHIFT))

#define  GICD_ICFG11_CFG10_MASK 0x300000
#define  GICD_ICFG11_CFG10_SHIFT 20
#define  GICD_ICFG11_CFG10_MASK_SHIFT(reg) (((reg) & GICD_ICFG11_CFG10_MASK) >> GICD_ICFG11_CFG10_SHIFT)
#define  GICD_ICFG11_CFG10_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG11_CFG10_MASK) | (((uint32_t)val) << GICD_ICFG11_CFG10_SHIFT))

#define  GICD_ICFG11_CFG9_MASK 0xc0000
#define  GICD_ICFG11_CFG9_SHIFT 18
#define  GICD_ICFG11_CFG9_MASK_SHIFT(reg) (((reg) & GICD_ICFG11_CFG9_MASK) >> GICD_ICFG11_CFG9_SHIFT)
#define  GICD_ICFG11_CFG9_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG11_CFG9_MASK) | (((uint32_t)val) << GICD_ICFG11_CFG9_SHIFT))

#define  GICD_ICFG11_CFG8_MASK 0x30000
#define  GICD_ICFG11_CFG8_SHIFT 16
#define  GICD_ICFG11_CFG8_MASK_SHIFT(reg) (((reg) & GICD_ICFG11_CFG8_MASK) >> GICD_ICFG11_CFG8_SHIFT)
#define  GICD_ICFG11_CFG8_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG11_CFG8_MASK) | (((uint32_t)val) << GICD_ICFG11_CFG8_SHIFT))

#define  GICD_ICFG11_CFG7_MASK 0xc000
#define  GICD_ICFG11_CFG7_SHIFT 14
#define  GICD_ICFG11_CFG7_MASK_SHIFT(reg) (((reg) & GICD_ICFG11_CFG7_MASK) >> GICD_ICFG11_CFG7_SHIFT)
#define  GICD_ICFG11_CFG7_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG11_CFG7_MASK) | (((uint32_t)val) << GICD_ICFG11_CFG7_SHIFT))

#define  GICD_ICFG11_CFG6_MASK 0x3000
#define  GICD_ICFG11_CFG6_SHIFT 12
#define  GICD_ICFG11_CFG6_MASK_SHIFT(reg) (((reg) & GICD_ICFG11_CFG6_MASK) >> GICD_ICFG11_CFG6_SHIFT)
#define  GICD_ICFG11_CFG6_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG11_CFG6_MASK) | (((uint32_t)val) << GICD_ICFG11_CFG6_SHIFT))

#define  GICD_ICFG11_CFG5_MASK 0xc00
#define  GICD_ICFG11_CFG5_SHIFT 10
#define  GICD_ICFG11_CFG5_MASK_SHIFT(reg) (((reg) & GICD_ICFG11_CFG5_MASK) >> GICD_ICFG11_CFG5_SHIFT)
#define  GICD_ICFG11_CFG5_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG11_CFG5_MASK) | (((uint32_t)val) << GICD_ICFG11_CFG5_SHIFT))

#define  GICD_ICFG11_CFG4_MASK 0x300
#define  GICD_ICFG11_CFG4_SHIFT 8
#define  GICD_ICFG11_CFG4_MASK_SHIFT(reg) (((reg) & GICD_ICFG11_CFG4_MASK) >> GICD_ICFG11_CFG4_SHIFT)
#define  GICD_ICFG11_CFG4_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG11_CFG4_MASK) | (((uint32_t)val) << GICD_ICFG11_CFG4_SHIFT))

#define  GICD_ICFG11_CFG3_MASK 0xc0
#define  GICD_ICFG11_CFG3_SHIFT 6
#define  GICD_ICFG11_CFG3_MASK_SHIFT(reg) (((reg) & GICD_ICFG11_CFG3_MASK) >> GICD_ICFG11_CFG3_SHIFT)
#define  GICD_ICFG11_CFG3_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG11_CFG3_MASK) | (((uint32_t)val) << GICD_ICFG11_CFG3_SHIFT))

#define  GICD_ICFG11_CFG2_MASK 0x30
#define  GICD_ICFG11_CFG2_SHIFT 4
#define  GICD_ICFG11_CFG2_MASK_SHIFT(reg) (((reg) & GICD_ICFG11_CFG2_MASK) >> GICD_ICFG11_CFG2_SHIFT)
#define  GICD_ICFG11_CFG2_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG11_CFG2_MASK) | (((uint32_t)val) << GICD_ICFG11_CFG2_SHIFT))

#define  GICD_ICFG11_CFG1_MASK 0xc
#define  GICD_ICFG11_CFG1_SHIFT 2
#define  GICD_ICFG11_CFG1_MASK_SHIFT(reg) (((reg) & GICD_ICFG11_CFG1_MASK) >> GICD_ICFG11_CFG1_SHIFT)
#define  GICD_ICFG11_CFG1_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG11_CFG1_MASK) | (((uint32_t)val) << GICD_ICFG11_CFG1_SHIFT))

#define  GICD_ICFG11_CFG0_MASK 0x3
#define  GICD_ICFG11_CFG0_SHIFT 0
#define  GICD_ICFG11_CFG0_MASK_SHIFT(reg) (((reg) & GICD_ICFG11_CFG0_MASK) >> GICD_ICFG11_CFG0_SHIFT)
#define  GICD_ICFG11_CFG0_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG11_CFG0_MASK) | (((uint32_t)val) << GICD_ICFG11_CFG0_SHIFT))

//====================================================================
//Register: GIC400 SPI Interrupt Configuration Register (Instance 13 of 16) (ICFG12)
/** \brief GIC400 SPI Interrupt Target Processor Register (Instance 13 of 16)*/
//====================================================================

#define  GICD_ICFG12_CFG15_MASK 0xc0000000
#define  GICD_ICFG12_CFG15_SHIFT 30
#define  GICD_ICFG12_CFG15_MASK_SHIFT(reg) (((reg) & GICD_ICFG12_CFG15_MASK) >> GICD_ICFG12_CFG15_SHIFT)
#define  GICD_ICFG12_CFG15_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG12_CFG15_MASK) | (((uint32_t)val) << GICD_ICFG12_CFG15_SHIFT))

#define  GICD_ICFG12_CFG14_MASK 0x30000000
#define  GICD_ICFG12_CFG14_SHIFT 28
#define  GICD_ICFG12_CFG14_MASK_SHIFT(reg) (((reg) & GICD_ICFG12_CFG14_MASK) >> GICD_ICFG12_CFG14_SHIFT)
#define  GICD_ICFG12_CFG14_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG12_CFG14_MASK) | (((uint32_t)val) << GICD_ICFG12_CFG14_SHIFT))

#define  GICD_ICFG12_CFG13_MASK 0xc000000
#define  GICD_ICFG12_CFG13_SHIFT 26
#define  GICD_ICFG12_CFG13_MASK_SHIFT(reg) (((reg) & GICD_ICFG12_CFG13_MASK) >> GICD_ICFG12_CFG13_SHIFT)
#define  GICD_ICFG12_CFG13_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG12_CFG13_MASK) | (((uint32_t)val) << GICD_ICFG12_CFG13_SHIFT))

#define  GICD_ICFG12_CFG12_MASK 0x3000000
#define  GICD_ICFG12_CFG12_SHIFT 24
#define  GICD_ICFG12_CFG12_MASK_SHIFT(reg) (((reg) & GICD_ICFG12_CFG12_MASK) >> GICD_ICFG12_CFG12_SHIFT)
#define  GICD_ICFG12_CFG12_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG12_CFG12_MASK) | (((uint32_t)val) << GICD_ICFG12_CFG12_SHIFT))

#define  GICD_ICFG12_CFG11_MASK 0xc00000
#define  GICD_ICFG12_CFG11_SHIFT 22
#define  GICD_ICFG12_CFG11_MASK_SHIFT(reg) (((reg) & GICD_ICFG12_CFG11_MASK) >> GICD_ICFG12_CFG11_SHIFT)
#define  GICD_ICFG12_CFG11_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG12_CFG11_MASK) | (((uint32_t)val) << GICD_ICFG12_CFG11_SHIFT))

#define  GICD_ICFG12_CFG10_MASK 0x300000
#define  GICD_ICFG12_CFG10_SHIFT 20
#define  GICD_ICFG12_CFG10_MASK_SHIFT(reg) (((reg) & GICD_ICFG12_CFG10_MASK) >> GICD_ICFG12_CFG10_SHIFT)
#define  GICD_ICFG12_CFG10_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG12_CFG10_MASK) | (((uint32_t)val) << GICD_ICFG12_CFG10_SHIFT))

#define  GICD_ICFG12_CFG9_MASK 0xc0000
#define  GICD_ICFG12_CFG9_SHIFT 18
#define  GICD_ICFG12_CFG9_MASK_SHIFT(reg) (((reg) & GICD_ICFG12_CFG9_MASK) >> GICD_ICFG12_CFG9_SHIFT)
#define  GICD_ICFG12_CFG9_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG12_CFG9_MASK) | (((uint32_t)val) << GICD_ICFG12_CFG9_SHIFT))

#define  GICD_ICFG12_CFG8_MASK 0x30000
#define  GICD_ICFG12_CFG8_SHIFT 16
#define  GICD_ICFG12_CFG8_MASK_SHIFT(reg) (((reg) & GICD_ICFG12_CFG8_MASK) >> GICD_ICFG12_CFG8_SHIFT)
#define  GICD_ICFG12_CFG8_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG12_CFG8_MASK) | (((uint32_t)val) << GICD_ICFG12_CFG8_SHIFT))

#define  GICD_ICFG12_CFG7_MASK 0xc000
#define  GICD_ICFG12_CFG7_SHIFT 14
#define  GICD_ICFG12_CFG7_MASK_SHIFT(reg) (((reg) & GICD_ICFG12_CFG7_MASK) >> GICD_ICFG12_CFG7_SHIFT)
#define  GICD_ICFG12_CFG7_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG12_CFG7_MASK) | (((uint32_t)val) << GICD_ICFG12_CFG7_SHIFT))

#define  GICD_ICFG12_CFG6_MASK 0x3000
#define  GICD_ICFG12_CFG6_SHIFT 12
#define  GICD_ICFG12_CFG6_MASK_SHIFT(reg) (((reg) & GICD_ICFG12_CFG6_MASK) >> GICD_ICFG12_CFG6_SHIFT)
#define  GICD_ICFG12_CFG6_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG12_CFG6_MASK) | (((uint32_t)val) << GICD_ICFG12_CFG6_SHIFT))

#define  GICD_ICFG12_CFG5_MASK 0xc00
#define  GICD_ICFG12_CFG5_SHIFT 10
#define  GICD_ICFG12_CFG5_MASK_SHIFT(reg) (((reg) & GICD_ICFG12_CFG5_MASK) >> GICD_ICFG12_CFG5_SHIFT)
#define  GICD_ICFG12_CFG5_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG12_CFG5_MASK) | (((uint32_t)val) << GICD_ICFG12_CFG5_SHIFT))

#define  GICD_ICFG12_CFG4_MASK 0x300
#define  GICD_ICFG12_CFG4_SHIFT 8
#define  GICD_ICFG12_CFG4_MASK_SHIFT(reg) (((reg) & GICD_ICFG12_CFG4_MASK) >> GICD_ICFG12_CFG4_SHIFT)
#define  GICD_ICFG12_CFG4_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG12_CFG4_MASK) | (((uint32_t)val) << GICD_ICFG12_CFG4_SHIFT))

#define  GICD_ICFG12_CFG3_MASK 0xc0
#define  GICD_ICFG12_CFG3_SHIFT 6
#define  GICD_ICFG12_CFG3_MASK_SHIFT(reg) (((reg) & GICD_ICFG12_CFG3_MASK) >> GICD_ICFG12_CFG3_SHIFT)
#define  GICD_ICFG12_CFG3_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG12_CFG3_MASK) | (((uint32_t)val) << GICD_ICFG12_CFG3_SHIFT))

#define  GICD_ICFG12_CFG2_MASK 0x30
#define  GICD_ICFG12_CFG2_SHIFT 4
#define  GICD_ICFG12_CFG2_MASK_SHIFT(reg) (((reg) & GICD_ICFG12_CFG2_MASK) >> GICD_ICFG12_CFG2_SHIFT)
#define  GICD_ICFG12_CFG2_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG12_CFG2_MASK) | (((uint32_t)val) << GICD_ICFG12_CFG2_SHIFT))

#define  GICD_ICFG12_CFG1_MASK 0xc
#define  GICD_ICFG12_CFG1_SHIFT 2
#define  GICD_ICFG12_CFG1_MASK_SHIFT(reg) (((reg) & GICD_ICFG12_CFG1_MASK) >> GICD_ICFG12_CFG1_SHIFT)
#define  GICD_ICFG12_CFG1_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG12_CFG1_MASK) | (((uint32_t)val) << GICD_ICFG12_CFG1_SHIFT))

#define  GICD_ICFG12_CFG0_MASK 0x3
#define  GICD_ICFG12_CFG0_SHIFT 0
#define  GICD_ICFG12_CFG0_MASK_SHIFT(reg) (((reg) & GICD_ICFG12_CFG0_MASK) >> GICD_ICFG12_CFG0_SHIFT)
#define  GICD_ICFG12_CFG0_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG12_CFG0_MASK) | (((uint32_t)val) << GICD_ICFG12_CFG0_SHIFT))

//====================================================================
//Register: GIC400 SPI Interrupt Configuration Register (Instance 14 of 16) (ICFG13)
/** \brief GIC400 SPI Interrupt Target Processor Register (Instance 14 of 16)*/
//====================================================================

#define  GICD_ICFG13_CFG15_MASK 0xc0000000
#define  GICD_ICFG13_CFG15_SHIFT 30
#define  GICD_ICFG13_CFG15_MASK_SHIFT(reg) (((reg) & GICD_ICFG13_CFG15_MASK) >> GICD_ICFG13_CFG15_SHIFT)
#define  GICD_ICFG13_CFG15_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG13_CFG15_MASK) | (((uint32_t)val) << GICD_ICFG13_CFG15_SHIFT))

#define  GICD_ICFG13_CFG14_MASK 0x30000000
#define  GICD_ICFG13_CFG14_SHIFT 28
#define  GICD_ICFG13_CFG14_MASK_SHIFT(reg) (((reg) & GICD_ICFG13_CFG14_MASK) >> GICD_ICFG13_CFG14_SHIFT)
#define  GICD_ICFG13_CFG14_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG13_CFG14_MASK) | (((uint32_t)val) << GICD_ICFG13_CFG14_SHIFT))

#define  GICD_ICFG13_CFG13_MASK 0xc000000
#define  GICD_ICFG13_CFG13_SHIFT 26
#define  GICD_ICFG13_CFG13_MASK_SHIFT(reg) (((reg) & GICD_ICFG13_CFG13_MASK) >> GICD_ICFG13_CFG13_SHIFT)
#define  GICD_ICFG13_CFG13_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG13_CFG13_MASK) | (((uint32_t)val) << GICD_ICFG13_CFG13_SHIFT))

#define  GICD_ICFG13_CFG12_MASK 0x3000000
#define  GICD_ICFG13_CFG12_SHIFT 24
#define  GICD_ICFG13_CFG12_MASK_SHIFT(reg) (((reg) & GICD_ICFG13_CFG12_MASK) >> GICD_ICFG13_CFG12_SHIFT)
#define  GICD_ICFG13_CFG12_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG13_CFG12_MASK) | (((uint32_t)val) << GICD_ICFG13_CFG12_SHIFT))

#define  GICD_ICFG13_CFG11_MASK 0xc00000
#define  GICD_ICFG13_CFG11_SHIFT 22
#define  GICD_ICFG13_CFG11_MASK_SHIFT(reg) (((reg) & GICD_ICFG13_CFG11_MASK) >> GICD_ICFG13_CFG11_SHIFT)
#define  GICD_ICFG13_CFG11_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG13_CFG11_MASK) | (((uint32_t)val) << GICD_ICFG13_CFG11_SHIFT))

#define  GICD_ICFG13_CFG10_MASK 0x300000
#define  GICD_ICFG13_CFG10_SHIFT 20
#define  GICD_ICFG13_CFG10_MASK_SHIFT(reg) (((reg) & GICD_ICFG13_CFG10_MASK) >> GICD_ICFG13_CFG10_SHIFT)
#define  GICD_ICFG13_CFG10_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG13_CFG10_MASK) | (((uint32_t)val) << GICD_ICFG13_CFG10_SHIFT))

#define  GICD_ICFG13_CFG9_MASK 0xc0000
#define  GICD_ICFG13_CFG9_SHIFT 18
#define  GICD_ICFG13_CFG9_MASK_SHIFT(reg) (((reg) & GICD_ICFG13_CFG9_MASK) >> GICD_ICFG13_CFG9_SHIFT)
#define  GICD_ICFG13_CFG9_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG13_CFG9_MASK) | (((uint32_t)val) << GICD_ICFG13_CFG9_SHIFT))

#define  GICD_ICFG13_CFG8_MASK 0x30000
#define  GICD_ICFG13_CFG8_SHIFT 16
#define  GICD_ICFG13_CFG8_MASK_SHIFT(reg) (((reg) & GICD_ICFG13_CFG8_MASK) >> GICD_ICFG13_CFG8_SHIFT)
#define  GICD_ICFG13_CFG8_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG13_CFG8_MASK) | (((uint32_t)val) << GICD_ICFG13_CFG8_SHIFT))

#define  GICD_ICFG13_CFG7_MASK 0xc000
#define  GICD_ICFG13_CFG7_SHIFT 14
#define  GICD_ICFG13_CFG7_MASK_SHIFT(reg) (((reg) & GICD_ICFG13_CFG7_MASK) >> GICD_ICFG13_CFG7_SHIFT)
#define  GICD_ICFG13_CFG7_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG13_CFG7_MASK) | (((uint32_t)val) << GICD_ICFG13_CFG7_SHIFT))

#define  GICD_ICFG13_CFG6_MASK 0x3000
#define  GICD_ICFG13_CFG6_SHIFT 12
#define  GICD_ICFG13_CFG6_MASK_SHIFT(reg) (((reg) & GICD_ICFG13_CFG6_MASK) >> GICD_ICFG13_CFG6_SHIFT)
#define  GICD_ICFG13_CFG6_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG13_CFG6_MASK) | (((uint32_t)val) << GICD_ICFG13_CFG6_SHIFT))

#define  GICD_ICFG13_CFG5_MASK 0xc00
#define  GICD_ICFG13_CFG5_SHIFT 10
#define  GICD_ICFG13_CFG5_MASK_SHIFT(reg) (((reg) & GICD_ICFG13_CFG5_MASK) >> GICD_ICFG13_CFG5_SHIFT)
#define  GICD_ICFG13_CFG5_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG13_CFG5_MASK) | (((uint32_t)val) << GICD_ICFG13_CFG5_SHIFT))

#define  GICD_ICFG13_CFG4_MASK 0x300
#define  GICD_ICFG13_CFG4_SHIFT 8
#define  GICD_ICFG13_CFG4_MASK_SHIFT(reg) (((reg) & GICD_ICFG13_CFG4_MASK) >> GICD_ICFG13_CFG4_SHIFT)
#define  GICD_ICFG13_CFG4_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG13_CFG4_MASK) | (((uint32_t)val) << GICD_ICFG13_CFG4_SHIFT))

#define  GICD_ICFG13_CFG3_MASK 0xc0
#define  GICD_ICFG13_CFG3_SHIFT 6
#define  GICD_ICFG13_CFG3_MASK_SHIFT(reg) (((reg) & GICD_ICFG13_CFG3_MASK) >> GICD_ICFG13_CFG3_SHIFT)
#define  GICD_ICFG13_CFG3_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG13_CFG3_MASK) | (((uint32_t)val) << GICD_ICFG13_CFG3_SHIFT))

#define  GICD_ICFG13_CFG2_MASK 0x30
#define  GICD_ICFG13_CFG2_SHIFT 4
#define  GICD_ICFG13_CFG2_MASK_SHIFT(reg) (((reg) & GICD_ICFG13_CFG2_MASK) >> GICD_ICFG13_CFG2_SHIFT)
#define  GICD_ICFG13_CFG2_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG13_CFG2_MASK) | (((uint32_t)val) << GICD_ICFG13_CFG2_SHIFT))

#define  GICD_ICFG13_CFG1_MASK 0xc
#define  GICD_ICFG13_CFG1_SHIFT 2
#define  GICD_ICFG13_CFG1_MASK_SHIFT(reg) (((reg) & GICD_ICFG13_CFG1_MASK) >> GICD_ICFG13_CFG1_SHIFT)
#define  GICD_ICFG13_CFG1_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG13_CFG1_MASK) | (((uint32_t)val) << GICD_ICFG13_CFG1_SHIFT))

#define  GICD_ICFG13_CFG0_MASK 0x3
#define  GICD_ICFG13_CFG0_SHIFT 0
#define  GICD_ICFG13_CFG0_MASK_SHIFT(reg) (((reg) & GICD_ICFG13_CFG0_MASK) >> GICD_ICFG13_CFG0_SHIFT)
#define  GICD_ICFG13_CFG0_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG13_CFG0_MASK) | (((uint32_t)val) << GICD_ICFG13_CFG0_SHIFT))

//====================================================================
//Register: GIC400 SPI Interrupt Configuration Register (Instance 15 of 16) (ICFG14)
/** \brief GIC400 SPI Interrupt Target Processor Register (Instance 15 of 16)*/
//====================================================================

#define  GICD_ICFG14_CFG15_MASK 0xc0000000
#define  GICD_ICFG14_CFG15_SHIFT 30
#define  GICD_ICFG14_CFG15_MASK_SHIFT(reg) (((reg) & GICD_ICFG14_CFG15_MASK) >> GICD_ICFG14_CFG15_SHIFT)
#define  GICD_ICFG14_CFG15_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG14_CFG15_MASK) | (((uint32_t)val) << GICD_ICFG14_CFG15_SHIFT))

#define  GICD_ICFG14_CFG14_MASK 0x30000000
#define  GICD_ICFG14_CFG14_SHIFT 28
#define  GICD_ICFG14_CFG14_MASK_SHIFT(reg) (((reg) & GICD_ICFG14_CFG14_MASK) >> GICD_ICFG14_CFG14_SHIFT)
#define  GICD_ICFG14_CFG14_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG14_CFG14_MASK) | (((uint32_t)val) << GICD_ICFG14_CFG14_SHIFT))

#define  GICD_ICFG14_CFG13_MASK 0xc000000
#define  GICD_ICFG14_CFG13_SHIFT 26
#define  GICD_ICFG14_CFG13_MASK_SHIFT(reg) (((reg) & GICD_ICFG14_CFG13_MASK) >> GICD_ICFG14_CFG13_SHIFT)
#define  GICD_ICFG14_CFG13_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG14_CFG13_MASK) | (((uint32_t)val) << GICD_ICFG14_CFG13_SHIFT))

#define  GICD_ICFG14_CFG12_MASK 0x3000000
#define  GICD_ICFG14_CFG12_SHIFT 24
#define  GICD_ICFG14_CFG12_MASK_SHIFT(reg) (((reg) & GICD_ICFG14_CFG12_MASK) >> GICD_ICFG14_CFG12_SHIFT)
#define  GICD_ICFG14_CFG12_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG14_CFG12_MASK) | (((uint32_t)val) << GICD_ICFG14_CFG12_SHIFT))

#define  GICD_ICFG14_CFG11_MASK 0xc00000
#define  GICD_ICFG14_CFG11_SHIFT 22
#define  GICD_ICFG14_CFG11_MASK_SHIFT(reg) (((reg) & GICD_ICFG14_CFG11_MASK) >> GICD_ICFG14_CFG11_SHIFT)
#define  GICD_ICFG14_CFG11_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG14_CFG11_MASK) | (((uint32_t)val) << GICD_ICFG14_CFG11_SHIFT))

#define  GICD_ICFG14_CFG10_MASK 0x300000
#define  GICD_ICFG14_CFG10_SHIFT 20
#define  GICD_ICFG14_CFG10_MASK_SHIFT(reg) (((reg) & GICD_ICFG14_CFG10_MASK) >> GICD_ICFG14_CFG10_SHIFT)
#define  GICD_ICFG14_CFG10_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG14_CFG10_MASK) | (((uint32_t)val) << GICD_ICFG14_CFG10_SHIFT))

#define  GICD_ICFG14_CFG9_MASK 0xc0000
#define  GICD_ICFG14_CFG9_SHIFT 18
#define  GICD_ICFG14_CFG9_MASK_SHIFT(reg) (((reg) & GICD_ICFG14_CFG9_MASK) >> GICD_ICFG14_CFG9_SHIFT)
#define  GICD_ICFG14_CFG9_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG14_CFG9_MASK) | (((uint32_t)val) << GICD_ICFG14_CFG9_SHIFT))

#define  GICD_ICFG14_CFG8_MASK 0x30000
#define  GICD_ICFG14_CFG8_SHIFT 16
#define  GICD_ICFG14_CFG8_MASK_SHIFT(reg) (((reg) & GICD_ICFG14_CFG8_MASK) >> GICD_ICFG14_CFG8_SHIFT)
#define  GICD_ICFG14_CFG8_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG14_CFG8_MASK) | (((uint32_t)val) << GICD_ICFG14_CFG8_SHIFT))

#define  GICD_ICFG14_CFG7_MASK 0xc000
#define  GICD_ICFG14_CFG7_SHIFT 14
#define  GICD_ICFG14_CFG7_MASK_SHIFT(reg) (((reg) & GICD_ICFG14_CFG7_MASK) >> GICD_ICFG14_CFG7_SHIFT)
#define  GICD_ICFG14_CFG7_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG14_CFG7_MASK) | (((uint32_t)val) << GICD_ICFG14_CFG7_SHIFT))

#define  GICD_ICFG14_CFG6_MASK 0x3000
#define  GICD_ICFG14_CFG6_SHIFT 12
#define  GICD_ICFG14_CFG6_MASK_SHIFT(reg) (((reg) & GICD_ICFG14_CFG6_MASK) >> GICD_ICFG14_CFG6_SHIFT)
#define  GICD_ICFG14_CFG6_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG14_CFG6_MASK) | (((uint32_t)val) << GICD_ICFG14_CFG6_SHIFT))

#define  GICD_ICFG14_CFG5_MASK 0xc00
#define  GICD_ICFG14_CFG5_SHIFT 10
#define  GICD_ICFG14_CFG5_MASK_SHIFT(reg) (((reg) & GICD_ICFG14_CFG5_MASK) >> GICD_ICFG14_CFG5_SHIFT)
#define  GICD_ICFG14_CFG5_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG14_CFG5_MASK) | (((uint32_t)val) << GICD_ICFG14_CFG5_SHIFT))

#define  GICD_ICFG14_CFG4_MASK 0x300
#define  GICD_ICFG14_CFG4_SHIFT 8
#define  GICD_ICFG14_CFG4_MASK_SHIFT(reg) (((reg) & GICD_ICFG14_CFG4_MASK) >> GICD_ICFG14_CFG4_SHIFT)
#define  GICD_ICFG14_CFG4_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG14_CFG4_MASK) | (((uint32_t)val) << GICD_ICFG14_CFG4_SHIFT))

#define  GICD_ICFG14_CFG3_MASK 0xc0
#define  GICD_ICFG14_CFG3_SHIFT 6
#define  GICD_ICFG14_CFG3_MASK_SHIFT(reg) (((reg) & GICD_ICFG14_CFG3_MASK) >> GICD_ICFG14_CFG3_SHIFT)
#define  GICD_ICFG14_CFG3_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG14_CFG3_MASK) | (((uint32_t)val) << GICD_ICFG14_CFG3_SHIFT))

#define  GICD_ICFG14_CFG2_MASK 0x30
#define  GICD_ICFG14_CFG2_SHIFT 4
#define  GICD_ICFG14_CFG2_MASK_SHIFT(reg) (((reg) & GICD_ICFG14_CFG2_MASK) >> GICD_ICFG14_CFG2_SHIFT)
#define  GICD_ICFG14_CFG2_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG14_CFG2_MASK) | (((uint32_t)val) << GICD_ICFG14_CFG2_SHIFT))

#define  GICD_ICFG14_CFG1_MASK 0xc
#define  GICD_ICFG14_CFG1_SHIFT 2
#define  GICD_ICFG14_CFG1_MASK_SHIFT(reg) (((reg) & GICD_ICFG14_CFG1_MASK) >> GICD_ICFG14_CFG1_SHIFT)
#define  GICD_ICFG14_CFG1_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG14_CFG1_MASK) | (((uint32_t)val) << GICD_ICFG14_CFG1_SHIFT))

#define  GICD_ICFG14_CFG0_MASK 0x3
#define  GICD_ICFG14_CFG0_SHIFT 0
#define  GICD_ICFG14_CFG0_MASK_SHIFT(reg) (((reg) & GICD_ICFG14_CFG0_MASK) >> GICD_ICFG14_CFG0_SHIFT)
#define  GICD_ICFG14_CFG0_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG14_CFG0_MASK) | (((uint32_t)val) << GICD_ICFG14_CFG0_SHIFT))

//====================================================================
//Register: GIC400 SPI Interrupt Configuration Register (Instance 16 of 16) (ICFG15)
/** \brief GIC400 SPI Interrupt Target Processor Register (Instance 16 of 16)*/
//====================================================================

#define  GICD_ICFG15_CFG15_MASK 0xc0000000
#define  GICD_ICFG15_CFG15_SHIFT 30
#define  GICD_ICFG15_CFG15_MASK_SHIFT(reg) (((reg) & GICD_ICFG15_CFG15_MASK) >> GICD_ICFG15_CFG15_SHIFT)
#define  GICD_ICFG15_CFG15_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG15_CFG15_MASK) | (((uint32_t)val) << GICD_ICFG15_CFG15_SHIFT))

#define  GICD_ICFG15_CFG14_MASK 0x30000000
#define  GICD_ICFG15_CFG14_SHIFT 28
#define  GICD_ICFG15_CFG14_MASK_SHIFT(reg) (((reg) & GICD_ICFG15_CFG14_MASK) >> GICD_ICFG15_CFG14_SHIFT)
#define  GICD_ICFG15_CFG14_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG15_CFG14_MASK) | (((uint32_t)val) << GICD_ICFG15_CFG14_SHIFT))

#define  GICD_ICFG15_CFG13_MASK 0xc000000
#define  GICD_ICFG15_CFG13_SHIFT 26
#define  GICD_ICFG15_CFG13_MASK_SHIFT(reg) (((reg) & GICD_ICFG15_CFG13_MASK) >> GICD_ICFG15_CFG13_SHIFT)
#define  GICD_ICFG15_CFG13_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG15_CFG13_MASK) | (((uint32_t)val) << GICD_ICFG15_CFG13_SHIFT))

#define  GICD_ICFG15_CFG12_MASK 0x3000000
#define  GICD_ICFG15_CFG12_SHIFT 24
#define  GICD_ICFG15_CFG12_MASK_SHIFT(reg) (((reg) & GICD_ICFG15_CFG12_MASK) >> GICD_ICFG15_CFG12_SHIFT)
#define  GICD_ICFG15_CFG12_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG15_CFG12_MASK) | (((uint32_t)val) << GICD_ICFG15_CFG12_SHIFT))

#define  GICD_ICFG15_CFG11_MASK 0xc00000
#define  GICD_ICFG15_CFG11_SHIFT 22
#define  GICD_ICFG15_CFG11_MASK_SHIFT(reg) (((reg) & GICD_ICFG15_CFG11_MASK) >> GICD_ICFG15_CFG11_SHIFT)
#define  GICD_ICFG15_CFG11_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG15_CFG11_MASK) | (((uint32_t)val) << GICD_ICFG15_CFG11_SHIFT))

#define  GICD_ICFG15_CFG10_MASK 0x300000
#define  GICD_ICFG15_CFG10_SHIFT 20
#define  GICD_ICFG15_CFG10_MASK_SHIFT(reg) (((reg) & GICD_ICFG15_CFG10_MASK) >> GICD_ICFG15_CFG10_SHIFT)
#define  GICD_ICFG15_CFG10_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG15_CFG10_MASK) | (((uint32_t)val) << GICD_ICFG15_CFG10_SHIFT))

#define  GICD_ICFG15_CFG9_MASK 0xc0000
#define  GICD_ICFG15_CFG9_SHIFT 18
#define  GICD_ICFG15_CFG9_MASK_SHIFT(reg) (((reg) & GICD_ICFG15_CFG9_MASK) >> GICD_ICFG15_CFG9_SHIFT)
#define  GICD_ICFG15_CFG9_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG15_CFG9_MASK) | (((uint32_t)val) << GICD_ICFG15_CFG9_SHIFT))

#define  GICD_ICFG15_CFG8_MASK 0x30000
#define  GICD_ICFG15_CFG8_SHIFT 16
#define  GICD_ICFG15_CFG8_MASK_SHIFT(reg) (((reg) & GICD_ICFG15_CFG8_MASK) >> GICD_ICFG15_CFG8_SHIFT)
#define  GICD_ICFG15_CFG8_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG15_CFG8_MASK) | (((uint32_t)val) << GICD_ICFG15_CFG8_SHIFT))

#define  GICD_ICFG15_CFG7_MASK 0xc000
#define  GICD_ICFG15_CFG7_SHIFT 14
#define  GICD_ICFG15_CFG7_MASK_SHIFT(reg) (((reg) & GICD_ICFG15_CFG7_MASK) >> GICD_ICFG15_CFG7_SHIFT)
#define  GICD_ICFG15_CFG7_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG15_CFG7_MASK) | (((uint32_t)val) << GICD_ICFG15_CFG7_SHIFT))

#define  GICD_ICFG15_CFG6_MASK 0x3000
#define  GICD_ICFG15_CFG6_SHIFT 12
#define  GICD_ICFG15_CFG6_MASK_SHIFT(reg) (((reg) & GICD_ICFG15_CFG6_MASK) >> GICD_ICFG15_CFG6_SHIFT)
#define  GICD_ICFG15_CFG6_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG15_CFG6_MASK) | (((uint32_t)val) << GICD_ICFG15_CFG6_SHIFT))

#define  GICD_ICFG15_CFG5_MASK 0xc00
#define  GICD_ICFG15_CFG5_SHIFT 10
#define  GICD_ICFG15_CFG5_MASK_SHIFT(reg) (((reg) & GICD_ICFG15_CFG5_MASK) >> GICD_ICFG15_CFG5_SHIFT)
#define  GICD_ICFG15_CFG5_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG15_CFG5_MASK) | (((uint32_t)val) << GICD_ICFG15_CFG5_SHIFT))

#define  GICD_ICFG15_CFG4_MASK 0x300
#define  GICD_ICFG15_CFG4_SHIFT 8
#define  GICD_ICFG15_CFG4_MASK_SHIFT(reg) (((reg) & GICD_ICFG15_CFG4_MASK) >> GICD_ICFG15_CFG4_SHIFT)
#define  GICD_ICFG15_CFG4_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG15_CFG4_MASK) | (((uint32_t)val) << GICD_ICFG15_CFG4_SHIFT))

#define  GICD_ICFG15_CFG3_MASK 0xc0
#define  GICD_ICFG15_CFG3_SHIFT 6
#define  GICD_ICFG15_CFG3_MASK_SHIFT(reg) (((reg) & GICD_ICFG15_CFG3_MASK) >> GICD_ICFG15_CFG3_SHIFT)
#define  GICD_ICFG15_CFG3_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG15_CFG3_MASK) | (((uint32_t)val) << GICD_ICFG15_CFG3_SHIFT))

#define  GICD_ICFG15_CFG2_MASK 0x30
#define  GICD_ICFG15_CFG2_SHIFT 4
#define  GICD_ICFG15_CFG2_MASK_SHIFT(reg) (((reg) & GICD_ICFG15_CFG2_MASK) >> GICD_ICFG15_CFG2_SHIFT)
#define  GICD_ICFG15_CFG2_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG15_CFG2_MASK) | (((uint32_t)val) << GICD_ICFG15_CFG2_SHIFT))

#define  GICD_ICFG15_CFG1_MASK 0xc
#define  GICD_ICFG15_CFG1_SHIFT 2
#define  GICD_ICFG15_CFG1_MASK_SHIFT(reg) (((reg) & GICD_ICFG15_CFG1_MASK) >> GICD_ICFG15_CFG1_SHIFT)
#define  GICD_ICFG15_CFG1_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG15_CFG1_MASK) | (((uint32_t)val) << GICD_ICFG15_CFG1_SHIFT))

#define  GICD_ICFG15_CFG0_MASK 0x3
#define  GICD_ICFG15_CFG0_SHIFT 0
#define  GICD_ICFG15_CFG0_MASK_SHIFT(reg) (((reg) & GICD_ICFG15_CFG0_MASK) >> GICD_ICFG15_CFG0_SHIFT)
#define  GICD_ICFG15_CFG0_REPLACE_VAL(reg,val) (((reg) & ~GICD_ICFG15_CFG0_MASK) | (((uint32_t)val) << GICD_ICFG15_CFG0_SHIFT))

//====================================================================
//Register: GIC400 PPI Interrupt Status Register (PPISR)
/** \brief GIC400 PPI Interrupt Status Register*/
//====================================================================

#define  GICD_PPISR_RESERVED1_MASK 0xffff0000
#define  GICD_PPISR_RESERVED1_SHIFT 16
#define  GICD_PPISR_RESERVED1_MASK_SHIFT(reg) (((reg) & GICD_PPISR_RESERVED1_MASK) >> GICD_PPISR_RESERVED1_SHIFT)
#define  GICD_PPISR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~GICD_PPISR_RESERVED1_MASK) | (((uint32_t)val) << GICD_PPISR_RESERVED1_SHIFT))

#define  GICD_PPISR_STATUS_MASK 0xfe00
#define  GICD_PPISR_STATUS_SHIFT 9
#define  GICD_PPISR_STATUS_MASK_SHIFT(reg) (((reg) & GICD_PPISR_STATUS_MASK) >> GICD_PPISR_STATUS_SHIFT)
#define  GICD_PPISR_STATUS_REPLACE_VAL(reg,val) (((reg) & ~GICD_PPISR_STATUS_MASK) | (((uint32_t)val) << GICD_PPISR_STATUS_SHIFT))

#define  GICD_PPISR_RESERVED2_MASK 0x1ff
#define  GICD_PPISR_RESERVED2_SHIFT 0
#define  GICD_PPISR_RESERVED2_MASK_SHIFT(reg) (((reg) & GICD_PPISR_RESERVED2_MASK) >> GICD_PPISR_RESERVED2_SHIFT)
#define  GICD_PPISR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~GICD_PPISR_RESERVED2_MASK) | (((uint32_t)val) << GICD_PPISR_RESERVED2_SHIFT))

//====================================================================
//Register: GIC400 SPI Interrupt Status Register (Instance 1 of 7) (SPISR0)
/** \brief GIC400 SPI Interrupt Status Register (Instance 1 of 7)*/
//====================================================================

#define  GICD_SPISR0_STATUS_MASK 0xffffffff
#define  GICD_SPISR0_STATUS_SHIFT 0
#define  GICD_SPISR0_STATUS_MASK_SHIFT(reg) (((reg) & GICD_SPISR0_STATUS_MASK) >> GICD_SPISR0_STATUS_SHIFT)
#define  GICD_SPISR0_STATUS_REPLACE_VAL(reg,val) (((reg) & ~GICD_SPISR0_STATUS_MASK) | (((uint32_t)val) << GICD_SPISR0_STATUS_SHIFT))

//====================================================================
//Register: GIC400 SPI Interrupt Status Register (Instance 2 of 7) (SPISR1)
/** \brief GIC400 SPI Interrupt Status Register (Instance 2 of 7)*/
//====================================================================

#define  GICD_SPISR1_STATUS_MASK 0xffffffff
#define  GICD_SPISR1_STATUS_SHIFT 0
#define  GICD_SPISR1_STATUS_MASK_SHIFT(reg) (((reg) & GICD_SPISR1_STATUS_MASK) >> GICD_SPISR1_STATUS_SHIFT)
#define  GICD_SPISR1_STATUS_REPLACE_VAL(reg,val) (((reg) & ~GICD_SPISR1_STATUS_MASK) | (((uint32_t)val) << GICD_SPISR1_STATUS_SHIFT))

//====================================================================
//Register: GIC400 SPI Interrupt Status Register (Instance 3 of 7) (SPISR2)
/** \brief GIC400 SPI Interrupt Status Register (Instance 3 of 7)*/
//====================================================================

#define  GICD_SPISR2_STATUS_MASK 0xffffffff
#define  GICD_SPISR2_STATUS_SHIFT 0
#define  GICD_SPISR2_STATUS_MASK_SHIFT(reg) (((reg) & GICD_SPISR2_STATUS_MASK) >> GICD_SPISR2_STATUS_SHIFT)
#define  GICD_SPISR2_STATUS_REPLACE_VAL(reg,val) (((reg) & ~GICD_SPISR2_STATUS_MASK) | (((uint32_t)val) << GICD_SPISR2_STATUS_SHIFT))

//====================================================================
//Register: GIC400 SPI Interrupt Status Register (Instance 4 of 7) (SPISR3)
/** \brief GIC400 SPI Interrupt Status Register (Instance 4 of 7)*/
//====================================================================

#define  GICD_SPISR3_STATUS_MASK 0xffffffff
#define  GICD_SPISR3_STATUS_SHIFT 0
#define  GICD_SPISR3_STATUS_MASK_SHIFT(reg) (((reg) & GICD_SPISR3_STATUS_MASK) >> GICD_SPISR3_STATUS_SHIFT)
#define  GICD_SPISR3_STATUS_REPLACE_VAL(reg,val) (((reg) & ~GICD_SPISR3_STATUS_MASK) | (((uint32_t)val) << GICD_SPISR3_STATUS_SHIFT))

//====================================================================
//Register: GIC400 SPI Interrupt Status Register (Instance 5 of 7) (SPISR4)
/** \brief GIC400 SPI Interrupt Status Register (Instance 5 of 7)*/
//====================================================================

#define  GICD_SPISR4_STATUS_MASK 0xffffffff
#define  GICD_SPISR4_STATUS_SHIFT 0
#define  GICD_SPISR4_STATUS_MASK_SHIFT(reg) (((reg) & GICD_SPISR4_STATUS_MASK) >> GICD_SPISR4_STATUS_SHIFT)
#define  GICD_SPISR4_STATUS_REPLACE_VAL(reg,val) (((reg) & ~GICD_SPISR4_STATUS_MASK) | (((uint32_t)val) << GICD_SPISR4_STATUS_SHIFT))

//====================================================================
//Register: GIC400 SPI Interrupt Status Register (Instance 6 of 7) (SPISR5)
/** \brief GIC400 SPI Interrupt Status Register (Instance 6 of 7)*/
//====================================================================

#define  GICD_SPISR5_STATUS_MASK 0xffffffff
#define  GICD_SPISR5_STATUS_SHIFT 0
#define  GICD_SPISR5_STATUS_MASK_SHIFT(reg) (((reg) & GICD_SPISR5_STATUS_MASK) >> GICD_SPISR5_STATUS_SHIFT)
#define  GICD_SPISR5_STATUS_REPLACE_VAL(reg,val) (((reg) & ~GICD_SPISR5_STATUS_MASK) | (((uint32_t)val) << GICD_SPISR5_STATUS_SHIFT))

//====================================================================
//Register: GIC400 SPI Interrupt Status Register (Instance 7 of 7) (SPISR6)
/** \brief GIC400 SPI Interrupt Status Register (Instance 7 of 7)*/
//====================================================================

#define  GICD_SPISR6_STATUS_MASK 0xffffffff
#define  GICD_SPISR6_STATUS_SHIFT 0
#define  GICD_SPISR6_STATUS_MASK_SHIFT(reg) (((reg) & GICD_SPISR6_STATUS_MASK) >> GICD_SPISR6_STATUS_SHIFT)
#define  GICD_SPISR6_STATUS_REPLACE_VAL(reg,val) (((reg) & ~GICD_SPISR6_STATUS_MASK) | (((uint32_t)val) << GICD_SPISR6_STATUS_SHIFT))

//====================================================================
//Register: GIC400 Non Secure Access Control Register (Instance 1 of 14) (NSACR0)
/** \brief GIC400 SPI Interrupt Status Register (Instance 1 of 14)*/
//====================================================================

#define  GICD_NSACR0_ACCESS_MASK 0xffffffff
#define  GICD_NSACR0_ACCESS_SHIFT 0
#define  GICD_NSACR0_ACCESS_MASK_SHIFT(reg) (((reg) & GICD_NSACR0_ACCESS_MASK) >> GICD_NSACR0_ACCESS_SHIFT)
#define  GICD_NSACR0_ACCESS_REPLACE_VAL(reg,val) (((reg) & ~GICD_NSACR0_ACCESS_MASK) | (((uint32_t)val) << GICD_NSACR0_ACCESS_SHIFT))

//====================================================================
//Register: GIC400 Non Secure Access Control Register (Instance 2 of 14) (NSACR1)
/** \brief GIC400 SPI Interrupt Status Register (Instance 2 of 14)*/
//====================================================================

#define  GICD_NSACR1_ACCESS_MASK 0xffffffff
#define  GICD_NSACR1_ACCESS_SHIFT 0
#define  GICD_NSACR1_ACCESS_MASK_SHIFT(reg) (((reg) & GICD_NSACR1_ACCESS_MASK) >> GICD_NSACR1_ACCESS_SHIFT)
#define  GICD_NSACR1_ACCESS_REPLACE_VAL(reg,val) (((reg) & ~GICD_NSACR1_ACCESS_MASK) | (((uint32_t)val) << GICD_NSACR1_ACCESS_SHIFT))

//====================================================================
//Register: GIC400 Non Secure Access Control Register (Instance 3 of 14) (NSACR2)
/** \brief GIC400 SPI Interrupt Status Register (Instance 3 of 14)*/
//====================================================================

#define  GICD_NSACR2_ACCESS_MASK 0xffffffff
#define  GICD_NSACR2_ACCESS_SHIFT 0
#define  GICD_NSACR2_ACCESS_MASK_SHIFT(reg) (((reg) & GICD_NSACR2_ACCESS_MASK) >> GICD_NSACR2_ACCESS_SHIFT)
#define  GICD_NSACR2_ACCESS_REPLACE_VAL(reg,val) (((reg) & ~GICD_NSACR2_ACCESS_MASK) | (((uint32_t)val) << GICD_NSACR2_ACCESS_SHIFT))

//====================================================================
//Register: GIC400 Non Secure Access Control Register (Instance 4 of 14) (NSACR3)
/** \brief GIC400 SPI Interrupt Status Register (Instance 4 of 14)*/
//====================================================================

#define  GICD_NSACR3_ACCESS_MASK 0xffffffff
#define  GICD_NSACR3_ACCESS_SHIFT 0
#define  GICD_NSACR3_ACCESS_MASK_SHIFT(reg) (((reg) & GICD_NSACR3_ACCESS_MASK) >> GICD_NSACR3_ACCESS_SHIFT)
#define  GICD_NSACR3_ACCESS_REPLACE_VAL(reg,val) (((reg) & ~GICD_NSACR3_ACCESS_MASK) | (((uint32_t)val) << GICD_NSACR3_ACCESS_SHIFT))

//====================================================================
//Register: GIC400 Non Secure Access Control Register (Instance 5 of 14) (NSACR4)
/** \brief GIC400 SPI Interrupt Status Register (Instance 5 of 14)*/
//====================================================================

#define  GICD_NSACR4_ACCESS_MASK 0xffffffff
#define  GICD_NSACR4_ACCESS_SHIFT 0
#define  GICD_NSACR4_ACCESS_MASK_SHIFT(reg) (((reg) & GICD_NSACR4_ACCESS_MASK) >> GICD_NSACR4_ACCESS_SHIFT)
#define  GICD_NSACR4_ACCESS_REPLACE_VAL(reg,val) (((reg) & ~GICD_NSACR4_ACCESS_MASK) | (((uint32_t)val) << GICD_NSACR4_ACCESS_SHIFT))

//====================================================================
//Register: GIC400 Non Secure Access Control Register (Instance 6 of 14) (NSACR5)
/** \brief GIC400 SPI Interrupt Status Register (Instance 6 of 14)*/
//====================================================================

#define  GICD_NSACR5_ACCESS_MASK 0xffffffff
#define  GICD_NSACR5_ACCESS_SHIFT 0
#define  GICD_NSACR5_ACCESS_MASK_SHIFT(reg) (((reg) & GICD_NSACR5_ACCESS_MASK) >> GICD_NSACR5_ACCESS_SHIFT)
#define  GICD_NSACR5_ACCESS_REPLACE_VAL(reg,val) (((reg) & ~GICD_NSACR5_ACCESS_MASK) | (((uint32_t)val) << GICD_NSACR5_ACCESS_SHIFT))

//====================================================================
//Register: GIC400 Non Secure Access Control Register (Instance 7 of 14) (NSACR6)
/** \brief GIC400 SPI Interrupt Status Register (Instance 7 of 14)*/
//====================================================================

#define  GICD_NSACR6_ACCESS_MASK 0xffffffff
#define  GICD_NSACR6_ACCESS_SHIFT 0
#define  GICD_NSACR6_ACCESS_MASK_SHIFT(reg) (((reg) & GICD_NSACR6_ACCESS_MASK) >> GICD_NSACR6_ACCESS_SHIFT)
#define  GICD_NSACR6_ACCESS_REPLACE_VAL(reg,val) (((reg) & ~GICD_NSACR6_ACCESS_MASK) | (((uint32_t)val) << GICD_NSACR6_ACCESS_SHIFT))

//====================================================================
//Register: GIC400 Non Secure Access Control Register (Instance 8 of 14) (NSACR7)
/** \brief GIC400 SPI Interrupt Status Register (Instance 8 of 14)*/
//====================================================================

#define  GICD_NSACR7_ACCESS_MASK 0xffffffff
#define  GICD_NSACR7_ACCESS_SHIFT 0
#define  GICD_NSACR7_ACCESS_MASK_SHIFT(reg) (((reg) & GICD_NSACR7_ACCESS_MASK) >> GICD_NSACR7_ACCESS_SHIFT)
#define  GICD_NSACR7_ACCESS_REPLACE_VAL(reg,val) (((reg) & ~GICD_NSACR7_ACCESS_MASK) | (((uint32_t)val) << GICD_NSACR7_ACCESS_SHIFT))

//====================================================================
//Register: GIC400 Non Secure Access Control Register (Instance 9 of 14) (NSACR8)
/** \brief GIC400 SPI Interrupt Status Register (Instance 9 of 14)*/
//====================================================================

#define  GICD_NSACR8_ACCESS_MASK 0xffffffff
#define  GICD_NSACR8_ACCESS_SHIFT 0
#define  GICD_NSACR8_ACCESS_MASK_SHIFT(reg) (((reg) & GICD_NSACR8_ACCESS_MASK) >> GICD_NSACR8_ACCESS_SHIFT)
#define  GICD_NSACR8_ACCESS_REPLACE_VAL(reg,val) (((reg) & ~GICD_NSACR8_ACCESS_MASK) | (((uint32_t)val) << GICD_NSACR8_ACCESS_SHIFT))

//====================================================================
//Register: GIC400 Non Secure Access Control Register (Instance 10 of 14) (NSACR9)
/** \brief GIC400 SPI Interrupt Status Register (Instance 10 of 14)*/
//====================================================================

#define  GICD_NSACR9_ACCESS_MASK 0xffffffff
#define  GICD_NSACR9_ACCESS_SHIFT 0
#define  GICD_NSACR9_ACCESS_MASK_SHIFT(reg) (((reg) & GICD_NSACR9_ACCESS_MASK) >> GICD_NSACR9_ACCESS_SHIFT)
#define  GICD_NSACR9_ACCESS_REPLACE_VAL(reg,val) (((reg) & ~GICD_NSACR9_ACCESS_MASK) | (((uint32_t)val) << GICD_NSACR9_ACCESS_SHIFT))

//====================================================================
//Register: GIC400 Non Secure Access Control Register (Instance 11 of 14) (NSACR10)
/** \brief GIC400 SPI Interrupt Status Register (Instance 11 of 14)*/
//====================================================================

#define  GICD_NSACR10_ACCESS_MASK 0xffffffff
#define  GICD_NSACR10_ACCESS_SHIFT 0
#define  GICD_NSACR10_ACCESS_MASK_SHIFT(reg) (((reg) & GICD_NSACR10_ACCESS_MASK) >> GICD_NSACR10_ACCESS_SHIFT)
#define  GICD_NSACR10_ACCESS_REPLACE_VAL(reg,val) (((reg) & ~GICD_NSACR10_ACCESS_MASK) | (((uint32_t)val) << GICD_NSACR10_ACCESS_SHIFT))

//====================================================================
//Register: GIC400 Non Secure Access Control Register (Instance 12 of 14) (NSACR11)
/** \brief GIC400 SPI Interrupt Status Register (Instance 12 of 14)*/
//====================================================================

#define  GICD_NSACR11_ACCESS_MASK 0xffffffff
#define  GICD_NSACR11_ACCESS_SHIFT 0
#define  GICD_NSACR11_ACCESS_MASK_SHIFT(reg) (((reg) & GICD_NSACR11_ACCESS_MASK) >> GICD_NSACR11_ACCESS_SHIFT)
#define  GICD_NSACR11_ACCESS_REPLACE_VAL(reg,val) (((reg) & ~GICD_NSACR11_ACCESS_MASK) | (((uint32_t)val) << GICD_NSACR11_ACCESS_SHIFT))

//====================================================================
//Register: GIC400 Non Secure Access Control Register (Instance 13 of 14) (NSACR12)
/** \brief GIC400 SPI Interrupt Status Register (Instance 13 of 14)*/
//====================================================================

#define  GICD_NSACR12_ACCESS_MASK 0xffffffff
#define  GICD_NSACR12_ACCESS_SHIFT 0
#define  GICD_NSACR12_ACCESS_MASK_SHIFT(reg) (((reg) & GICD_NSACR12_ACCESS_MASK) >> GICD_NSACR12_ACCESS_SHIFT)
#define  GICD_NSACR12_ACCESS_REPLACE_VAL(reg,val) (((reg) & ~GICD_NSACR12_ACCESS_MASK) | (((uint32_t)val) << GICD_NSACR12_ACCESS_SHIFT))

//====================================================================
//Register: GIC400 Non Secure Access Control Register (Instance 14 of 14) (NSACR13)
/** \brief GIC400 SPI Interrupt Status Register (Instance 14 of 14)*/
//====================================================================

#define  GICD_NSACR13_ACCESS_MASK 0xffffffff
#define  GICD_NSACR13_ACCESS_SHIFT 0
#define  GICD_NSACR13_ACCESS_MASK_SHIFT(reg) (((reg) & GICD_NSACR13_ACCESS_MASK) >> GICD_NSACR13_ACCESS_SHIFT)
#define  GICD_NSACR13_ACCESS_REPLACE_VAL(reg,val) (((reg) & ~GICD_NSACR13_ACCESS_MASK) | (((uint32_t)val) << GICD_NSACR13_ACCESS_SHIFT))

//====================================================================
//Register: GIC400 Software Generated Interrupt (SGIR)
/** \brief GIC400 PPI S/W Generated Interrupt Register*/
//====================================================================

#define  GICD_SGIR_RESERVED1_MASK 0xfc000000
#define  GICD_SGIR_RESERVED1_SHIFT 26
#define  GICD_SGIR_RESERVED1_MASK_SHIFT(reg) (((reg) & GICD_SGIR_RESERVED1_MASK) >> GICD_SGIR_RESERVED1_SHIFT)
#define  GICD_SGIR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~GICD_SGIR_RESERVED1_MASK) | (((uint32_t)val) << GICD_SGIR_RESERVED1_SHIFT))

#define  GICD_SGIR_CPUTRGTFILT_MASK 0x3000000
#define  GICD_SGIR_CPUTRGTFILT_SHIFT 24
#define  GICD_SGIR_CPUTRGTFILT_MASK_SHIFT(reg) (((reg) & GICD_SGIR_CPUTRGTFILT_MASK) >> GICD_SGIR_CPUTRGTFILT_SHIFT)
#define  GICD_SGIR_CPUTRGTFILT_REPLACE_VAL(reg,val) (((reg) & ~GICD_SGIR_CPUTRGTFILT_MASK) | (((uint32_t)val) << GICD_SGIR_CPUTRGTFILT_SHIFT))

#define  GICD_SGIR_CPUTRGT_MASK 0xff0000
#define  GICD_SGIR_CPUTRGT_SHIFT 16
#define  GICD_SGIR_CPUTRGT_MASK_SHIFT(reg) (((reg) & GICD_SGIR_CPUTRGT_MASK) >> GICD_SGIR_CPUTRGT_SHIFT)
#define  GICD_SGIR_CPUTRGT_REPLACE_VAL(reg,val) (((reg) & ~GICD_SGIR_CPUTRGT_MASK) | (((uint32_t)val) << GICD_SGIR_CPUTRGT_SHIFT))

#define  GICD_SGIR_NSATT_MASK 0x8000
#define  GICD_SGIR_NSATT_SHIFT 15
#define  GICD_SGIR_NSATT_MASK_SHIFT(reg) (((reg) & GICD_SGIR_NSATT_MASK) >> GICD_SGIR_NSATT_SHIFT)
#define  GICD_SGIR_NSATT_REPLACE_VAL(reg,val) (((reg) & ~GICD_SGIR_NSATT_MASK) | (((uint32_t)val) << GICD_SGIR_NSATT_SHIFT))

#define  GICD_SGIR_RESERVED2_MASK 0x7ff0
#define  GICD_SGIR_RESERVED2_SHIFT 4
#define  GICD_SGIR_RESERVED2_MASK_SHIFT(reg) (((reg) & GICD_SGIR_RESERVED2_MASK) >> GICD_SGIR_RESERVED2_SHIFT)
#define  GICD_SGIR_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~GICD_SGIR_RESERVED2_MASK) | (((uint32_t)val) << GICD_SGIR_RESERVED2_SHIFT))

#define  GICD_SGIR_SGINTID_MASK 0xf
#define  GICD_SGIR_SGINTID_SHIFT 0
#define  GICD_SGIR_SGINTID_MASK_SHIFT(reg) (((reg) & GICD_SGIR_SGINTID_MASK) >> GICD_SGIR_SGINTID_SHIFT)
#define  GICD_SGIR_SGINTID_REPLACE_VAL(reg,val) (((reg) & ~GICD_SGIR_SGINTID_MASK) | (((uint32_t)val) << GICD_SGIR_SGINTID_SHIFT))

//====================================================================
//Register: GIC400 SGI Clear Pending Register (Instance 1 of 4) (CPENDSGIR0)
/** \brief GIC400 SGI Clear Pending InterruptStatus Register (Instance 1 of 4)*/
//====================================================================

#define  GICD_CPENDSGIR0_PEND_MASK 0xffffffff
#define  GICD_CPENDSGIR0_PEND_SHIFT 0
#define  GICD_CPENDSGIR0_PEND_MASK_SHIFT(reg) (((reg) & GICD_CPENDSGIR0_PEND_MASK) >> GICD_CPENDSGIR0_PEND_SHIFT)
#define  GICD_CPENDSGIR0_PEND_REPLACE_VAL(reg,val) (((reg) & ~GICD_CPENDSGIR0_PEND_MASK) | (((uint32_t)val) << GICD_CPENDSGIR0_PEND_SHIFT))

//====================================================================
//Register: GIC400 SGI Clear Pending Register (Instance 2 of 4) (CPENDSGIR1)
/** \brief GIC400 SGI Clear Pending InterruptStatus Register (Instance 2 of 4)*/
//====================================================================

#define  GICD_CPENDSGIR1_PEND_MASK 0xffffffff
#define  GICD_CPENDSGIR1_PEND_SHIFT 0
#define  GICD_CPENDSGIR1_PEND_MASK_SHIFT(reg) (((reg) & GICD_CPENDSGIR1_PEND_MASK) >> GICD_CPENDSGIR1_PEND_SHIFT)
#define  GICD_CPENDSGIR1_PEND_REPLACE_VAL(reg,val) (((reg) & ~GICD_CPENDSGIR1_PEND_MASK) | (((uint32_t)val) << GICD_CPENDSGIR1_PEND_SHIFT))

//====================================================================
//Register: GIC400 SGI Clear Pending Register (Instance 3 of 4) (CPENDSGIR2)
/** \brief GIC400 SGI Clear Pending InterruptStatus Register (Instance 3 of 4)*/
//====================================================================

#define  GICD_CPENDSGIR2_PEND_MASK 0xffffffff
#define  GICD_CPENDSGIR2_PEND_SHIFT 0
#define  GICD_CPENDSGIR2_PEND_MASK_SHIFT(reg) (((reg) & GICD_CPENDSGIR2_PEND_MASK) >> GICD_CPENDSGIR2_PEND_SHIFT)
#define  GICD_CPENDSGIR2_PEND_REPLACE_VAL(reg,val) (((reg) & ~GICD_CPENDSGIR2_PEND_MASK) | (((uint32_t)val) << GICD_CPENDSGIR2_PEND_SHIFT))

//====================================================================
//Register: GIC400 SGI Clear Pending Register (Instance 4 of 4) (CPENDSGIR3)
/** \brief GIC400 SGI Clear Pending InterruptStatus Register (Instance 4 of 4)*/
//====================================================================

#define  GICD_CPENDSGIR3_PEND_MASK 0xffffffff
#define  GICD_CPENDSGIR3_PEND_SHIFT 0
#define  GICD_CPENDSGIR3_PEND_MASK_SHIFT(reg) (((reg) & GICD_CPENDSGIR3_PEND_MASK) >> GICD_CPENDSGIR3_PEND_SHIFT)
#define  GICD_CPENDSGIR3_PEND_REPLACE_VAL(reg,val) (((reg) & ~GICD_CPENDSGIR3_PEND_MASK) | (((uint32_t)val) << GICD_CPENDSGIR3_PEND_SHIFT))

//====================================================================
//Register: GIC400 SGI Clear Pending Register (Instance 1 of 4) (SPENDSGIR0)
/** \brief GIC400 SGI Set Pending InterruptStatus Register (Instance 1 of 4)*/
//====================================================================

#define  GICD_SPENDSGIR0_SET_MASK 0xffffffff
#define  GICD_SPENDSGIR0_SET_SHIFT 0
#define  GICD_SPENDSGIR0_SET_MASK_SHIFT(reg) (((reg) & GICD_SPENDSGIR0_SET_MASK) >> GICD_SPENDSGIR0_SET_SHIFT)
#define  GICD_SPENDSGIR0_SET_REPLACE_VAL(reg,val) (((reg) & ~GICD_SPENDSGIR0_SET_MASK) | (((uint32_t)val) << GICD_SPENDSGIR0_SET_SHIFT))

//====================================================================
//Register: GIC400 SGI Clear Pending Register (Instance 2 of 4) (SPENDSGIR1)
/** \brief GIC400 SGI Set Pending InterruptStatus Register (Instance 2 of 4)*/
//====================================================================

#define  GICD_SPENDSGIR1_SET_MASK 0xffffffff
#define  GICD_SPENDSGIR1_SET_SHIFT 0
#define  GICD_SPENDSGIR1_SET_MASK_SHIFT(reg) (((reg) & GICD_SPENDSGIR1_SET_MASK) >> GICD_SPENDSGIR1_SET_SHIFT)
#define  GICD_SPENDSGIR1_SET_REPLACE_VAL(reg,val) (((reg) & ~GICD_SPENDSGIR1_SET_MASK) | (((uint32_t)val) << GICD_SPENDSGIR1_SET_SHIFT))

//====================================================================
//Register: GIC400 SGI Clear Pending Register (Instance 3 of 4) (SPENDSGIR2)
/** \brief GIC400 SGI Set Pending InterruptStatus Register (Instance 3 of 4)*/
//====================================================================

#define  GICD_SPENDSGIR2_SET_MASK 0xffffffff
#define  GICD_SPENDSGIR2_SET_SHIFT 0
#define  GICD_SPENDSGIR2_SET_MASK_SHIFT(reg) (((reg) & GICD_SPENDSGIR2_SET_MASK) >> GICD_SPENDSGIR2_SET_SHIFT)
#define  GICD_SPENDSGIR2_SET_REPLACE_VAL(reg,val) (((reg) & ~GICD_SPENDSGIR2_SET_MASK) | (((uint32_t)val) << GICD_SPENDSGIR2_SET_SHIFT))

//====================================================================
//Register: GIC400 SGI Clear Pending Register (Instance 4 of 4) (SPENDSGIR3)
/** \brief GIC400 SGI Set Pending InterruptStatus Register (Instance 4 of 4)*/
//====================================================================

#define  GICD_SPENDSGIR3_SET_MASK 0xffffffff
#define  GICD_SPENDSGIR3_SET_SHIFT 0
#define  GICD_SPENDSGIR3_SET_MASK_SHIFT(reg) (((reg) & GICD_SPENDSGIR3_SET_MASK) >> GICD_SPENDSGIR3_SET_SHIFT)
#define  GICD_SPENDSGIR3_SET_REPLACE_VAL(reg,val) (((reg) & ~GICD_SPENDSGIR3_SET_MASK) | (((uint32_t)val) << GICD_SPENDSGIR3_SET_SHIFT))

//====================================================================
//
//Register File: GIC400 Distrubutor Registers (GICC)
//
//====================================================================

//====================================================================
//Register: GIC400 CPU Control Register (CTRL)
/** \brief CPU Interface Control Register*/
//====================================================================

#define  GICC_CTRL_RESERVED1_MASK 0xfffff800
#define  GICC_CTRL_RESERVED1_SHIFT 11
#define  GICC_CTRL_RESERVED1_MASK_SHIFT(reg) (((reg) & GICC_CTRL_RESERVED1_MASK) >> GICC_CTRL_RESERVED1_SHIFT)
#define  GICC_CTRL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~GICC_CTRL_RESERVED1_MASK) | (((uint32_t)val) << GICC_CTRL_RESERVED1_SHIFT))

#define  GICC_CTRL_EOIMODENS_MASK 0x400
#define  GICC_CTRL_EOIMODENS_SHIFT 10
#define  GICC_CTRL_EOIMODENS_MASK_SHIFT(reg) (((reg) & GICC_CTRL_EOIMODENS_MASK) >> GICC_CTRL_EOIMODENS_SHIFT)
#define  GICC_CTRL_EOIMODENS_REPLACE_VAL(reg,val) (((reg) & ~GICC_CTRL_EOIMODENS_MASK) | (((uint32_t)val) << GICC_CTRL_EOIMODENS_SHIFT))

#define  GICC_CTRL_EOIMODES_MASK 0x200
#define  GICC_CTRL_EOIMODES_SHIFT 9
#define  GICC_CTRL_EOIMODES_MASK_SHIFT(reg) (((reg) & GICC_CTRL_EOIMODES_MASK) >> GICC_CTRL_EOIMODES_SHIFT)
#define  GICC_CTRL_EOIMODES_REPLACE_VAL(reg,val) (((reg) & ~GICC_CTRL_EOIMODES_MASK) | (((uint32_t)val) << GICC_CTRL_EOIMODES_SHIFT))

#define  GICC_CTRL_IRQBYPASSGRP1_MASK 0x100
#define  GICC_CTRL_IRQBYPASSGRP1_SHIFT 8
#define  GICC_CTRL_IRQBYPASSGRP1_MASK_SHIFT(reg) (((reg) & GICC_CTRL_IRQBYPASSGRP1_MASK) >> GICC_CTRL_IRQBYPASSGRP1_SHIFT)
#define  GICC_CTRL_IRQBYPASSGRP1_REPLACE_VAL(reg,val) (((reg) & ~GICC_CTRL_IRQBYPASSGRP1_MASK) | (((uint32_t)val) << GICC_CTRL_IRQBYPASSGRP1_SHIFT))

#define  GICC_CTRL_FIQBYPASSGRP1_MASK 0x80
#define  GICC_CTRL_FIQBYPASSGRP1_SHIFT 7
#define  GICC_CTRL_FIQBYPASSGRP1_MASK_SHIFT(reg) (((reg) & GICC_CTRL_FIQBYPASSGRP1_MASK) >> GICC_CTRL_FIQBYPASSGRP1_SHIFT)
#define  GICC_CTRL_FIQBYPASSGRP1_REPLACE_VAL(reg,val) (((reg) & ~GICC_CTRL_FIQBYPASSGRP1_MASK) | (((uint32_t)val) << GICC_CTRL_FIQBYPASSGRP1_SHIFT))

#define  GICC_CTRL_IRQBYPASSGRP0_MASK 0x40
#define  GICC_CTRL_IRQBYPASSGRP0_SHIFT 6
#define  GICC_CTRL_IRQBYPASSGRP0_MASK_SHIFT(reg) (((reg) & GICC_CTRL_IRQBYPASSGRP0_MASK) >> GICC_CTRL_IRQBYPASSGRP0_SHIFT)
#define  GICC_CTRL_IRQBYPASSGRP0_REPLACE_VAL(reg,val) (((reg) & ~GICC_CTRL_IRQBYPASSGRP0_MASK) | (((uint32_t)val) << GICC_CTRL_IRQBYPASSGRP0_SHIFT))

#define  GICC_CTRL_FIQBYPASSGRP0_MASK 0x20
#define  GICC_CTRL_FIQBYPASSGRP0_SHIFT 5
#define  GICC_CTRL_FIQBYPASSGRP0_MASK_SHIFT(reg) (((reg) & GICC_CTRL_FIQBYPASSGRP0_MASK) >> GICC_CTRL_FIQBYPASSGRP0_SHIFT)
#define  GICC_CTRL_FIQBYPASSGRP0_REPLACE_VAL(reg,val) (((reg) & ~GICC_CTRL_FIQBYPASSGRP0_MASK) | (((uint32_t)val) << GICC_CTRL_FIQBYPASSGRP0_SHIFT))

#define  GICC_CTRL_CBPR_MASK 0x10
#define  GICC_CTRL_CBPR_SHIFT 4
#define  GICC_CTRL_CBPR_MASK_SHIFT(reg) (((reg) & GICC_CTRL_CBPR_MASK) >> GICC_CTRL_CBPR_SHIFT)
#define  GICC_CTRL_CBPR_REPLACE_VAL(reg,val) (((reg) & ~GICC_CTRL_CBPR_MASK) | (((uint32_t)val) << GICC_CTRL_CBPR_SHIFT))

#define  GICC_CTRL_FIQEN_MASK 0x8
#define  GICC_CTRL_FIQEN_SHIFT 3
#define  GICC_CTRL_FIQEN_MASK_SHIFT(reg) (((reg) & GICC_CTRL_FIQEN_MASK) >> GICC_CTRL_FIQEN_SHIFT)
#define  GICC_CTRL_FIQEN_REPLACE_VAL(reg,val) (((reg) & ~GICC_CTRL_FIQEN_MASK) | (((uint32_t)val) << GICC_CTRL_FIQEN_SHIFT))

#define  GICC_CTRL_ACKCTRL_MASK 0x4
#define  GICC_CTRL_ACKCTRL_SHIFT 2
#define  GICC_CTRL_ACKCTRL_MASK_SHIFT(reg) (((reg) & GICC_CTRL_ACKCTRL_MASK) >> GICC_CTRL_ACKCTRL_SHIFT)
#define  GICC_CTRL_ACKCTRL_REPLACE_VAL(reg,val) (((reg) & ~GICC_CTRL_ACKCTRL_MASK) | (((uint32_t)val) << GICC_CTRL_ACKCTRL_SHIFT))

#define  GICC_CTRL_ENABLE1_MASK 0x2
#define  GICC_CTRL_ENABLE1_SHIFT 1
#define  GICC_CTRL_ENABLE1_MASK_SHIFT(reg) (((reg) & GICC_CTRL_ENABLE1_MASK) >> GICC_CTRL_ENABLE1_SHIFT)
#define  GICC_CTRL_ENABLE1_REPLACE_VAL(reg,val) (((reg) & ~GICC_CTRL_ENABLE1_MASK) | (((uint32_t)val) << GICC_CTRL_ENABLE1_SHIFT))

#define  GICC_CTRL_ENABLE0_MASK 0x1
#define  GICC_CTRL_ENABLE0_SHIFT 0
#define  GICC_CTRL_ENABLE0_MASK_SHIFT(reg) (((reg) & GICC_CTRL_ENABLE0_MASK) >> GICC_CTRL_ENABLE0_SHIFT)
#define  GICC_CTRL_ENABLE0_REPLACE_VAL(reg,val) (((reg) & ~GICC_CTRL_ENABLE0_MASK) | (((uint32_t)val) << GICC_CTRL_ENABLE0_SHIFT))

//====================================================================
//Register: GIC400 CPU Priority Mask Register (PMR)
/** \brief CPU Priority Mask Register*/
//====================================================================

#define  GICC_PMR_RESERVED1_MASK 0xffffff00
#define  GICC_PMR_RESERVED1_SHIFT 8
#define  GICC_PMR_RESERVED1_MASK_SHIFT(reg) (((reg) & GICC_PMR_RESERVED1_MASK) >> GICC_PMR_RESERVED1_SHIFT)
#define  GICC_PMR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~GICC_PMR_RESERVED1_MASK) | (((uint32_t)val) << GICC_PMR_RESERVED1_SHIFT))

#define  GICC_PMR_PRIORITY_MASK 0xff
#define  GICC_PMR_PRIORITY_SHIFT 0
#define  GICC_PMR_PRIORITY_MASK_SHIFT(reg) (((reg) & GICC_PMR_PRIORITY_MASK) >> GICC_PMR_PRIORITY_SHIFT)
#define  GICC_PMR_PRIORITY_REPLACE_VAL(reg,val) (((reg) & ~GICC_PMR_PRIORITY_MASK) | (((uint32_t)val) << GICC_PMR_PRIORITY_SHIFT))

//====================================================================
//Register: GIC400 CPU Binary Point Register (BPR)
/** \brief CPU Binary Point Register*/
//====================================================================

#define  GICC_BPR_RESERVED1_MASK 0xfffffff8
#define  GICC_BPR_RESERVED1_SHIFT 3
#define  GICC_BPR_RESERVED1_MASK_SHIFT(reg) (((reg) & GICC_BPR_RESERVED1_MASK) >> GICC_BPR_RESERVED1_SHIFT)
#define  GICC_BPR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~GICC_BPR_RESERVED1_MASK) | (((uint32_t)val) << GICC_BPR_RESERVED1_SHIFT))

#define  GICC_BPR_POINT_MASK 0x7
#define  GICC_BPR_POINT_SHIFT 0
#define  GICC_BPR_POINT_MASK_SHIFT(reg) (((reg) & GICC_BPR_POINT_MASK) >> GICC_BPR_POINT_SHIFT)
#define  GICC_BPR_POINT_REPLACE_VAL(reg,val) (((reg) & ~GICC_BPR_POINT_MASK) | (((uint32_t)val) << GICC_BPR_POINT_SHIFT))

//====================================================================
//Register: GIC400 CPU Interrupt Acknowledge Register (IAR)
/** \brief CPU Interrupt Acknowledge Register*/
//====================================================================

#define  GICC_IAR_RESERVED1_MASK 0xffffe000
#define  GICC_IAR_RESERVED1_SHIFT 13
#define  GICC_IAR_RESERVED1_MASK_SHIFT(reg) (((reg) & GICC_IAR_RESERVED1_MASK) >> GICC_IAR_RESERVED1_SHIFT)
#define  GICC_IAR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~GICC_IAR_RESERVED1_MASK) | (((uint32_t)val) << GICC_IAR_RESERVED1_SHIFT))

#define  GICC_IAR_CPUID_MASK 0x1c00
#define  GICC_IAR_CPUID_SHIFT 10
#define  GICC_IAR_CPUID_MASK_SHIFT(reg) (((reg) & GICC_IAR_CPUID_MASK) >> GICC_IAR_CPUID_SHIFT)
#define  GICC_IAR_CPUID_REPLACE_VAL(reg,val) (((reg) & ~GICC_IAR_CPUID_MASK) | (((uint32_t)val) << GICC_IAR_CPUID_SHIFT))

#define  GICC_IAR_ID_MASK 0x3ff
#define  GICC_IAR_ID_SHIFT 0
#define  GICC_IAR_ID_MASK_SHIFT(reg) (((reg) & GICC_IAR_ID_MASK) >> GICC_IAR_ID_SHIFT)
#define  GICC_IAR_ID_REPLACE_VAL(reg,val) (((reg) & ~GICC_IAR_ID_MASK) | (((uint32_t)val) << GICC_IAR_ID_SHIFT))

//====================================================================
//Register: GIC400 CPU End-Of-Interrupt Register (EOIR)
/** \brief CPU End-Of-Interrupt Register*/
//====================================================================

#define  GICC_EOIR_RESERVED1_MASK 0xffffe000
#define  GICC_EOIR_RESERVED1_SHIFT 13
#define  GICC_EOIR_RESERVED1_MASK_SHIFT(reg) (((reg) & GICC_EOIR_RESERVED1_MASK) >> GICC_EOIR_RESERVED1_SHIFT)
#define  GICC_EOIR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~GICC_EOIR_RESERVED1_MASK) | (((uint32_t)val) << GICC_EOIR_RESERVED1_SHIFT))

#define  GICC_EOIR_CPUID_MASK 0x1c00
#define  GICC_EOIR_CPUID_SHIFT 10
#define  GICC_EOIR_CPUID_MASK_SHIFT(reg) (((reg) & GICC_EOIR_CPUID_MASK) >> GICC_EOIR_CPUID_SHIFT)
#define  GICC_EOIR_CPUID_REPLACE_VAL(reg,val) (((reg) & ~GICC_EOIR_CPUID_MASK) | (((uint32_t)val) << GICC_EOIR_CPUID_SHIFT))

#define  GICC_EOIR_ID_MASK 0x3ff
#define  GICC_EOIR_ID_SHIFT 0
#define  GICC_EOIR_ID_MASK_SHIFT(reg) (((reg) & GICC_EOIR_ID_MASK) >> GICC_EOIR_ID_SHIFT)
#define  GICC_EOIR_ID_REPLACE_VAL(reg,val) (((reg) & ~GICC_EOIR_ID_MASK) | (((uint32_t)val) << GICC_EOIR_ID_SHIFT))

//====================================================================
//Register: GIC400 CPU Running Priority Register (RPR)
/** \brief CPU Running Priority Register*/
//====================================================================

#define  GICC_RPR_RESERVED1_MASK 0xffffff00
#define  GICC_RPR_RESERVED1_SHIFT 8
#define  GICC_RPR_RESERVED1_MASK_SHIFT(reg) (((reg) & GICC_RPR_RESERVED1_MASK) >> GICC_RPR_RESERVED1_SHIFT)
#define  GICC_RPR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~GICC_RPR_RESERVED1_MASK) | (((uint32_t)val) << GICC_RPR_RESERVED1_SHIFT))

#define  GICC_RPR_PRIORITY1_MASK 0xff
#define  GICC_RPR_PRIORITY1_SHIFT 0
#define  GICC_RPR_PRIORITY1_MASK_SHIFT(reg) (((reg) & GICC_RPR_PRIORITY1_MASK) >> GICC_RPR_PRIORITY1_SHIFT)
#define  GICC_RPR_PRIORITY1_REPLACE_VAL(reg,val) (((reg) & ~GICC_RPR_PRIORITY1_MASK) | (((uint32_t)val) << GICC_RPR_PRIORITY1_SHIFT))

//====================================================================
//Register: GIC400 CPU Highest Priority Interrupt Pending Register (HPPIR)
/** \brief CPU Highest Priority Interrupt Pending Register*/
//====================================================================

#define  GICC_HPPIR_RESERVED1_MASK 0xffffe000
#define  GICC_HPPIR_RESERVED1_SHIFT 13
#define  GICC_HPPIR_RESERVED1_MASK_SHIFT(reg) (((reg) & GICC_HPPIR_RESERVED1_MASK) >> GICC_HPPIR_RESERVED1_SHIFT)
#define  GICC_HPPIR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~GICC_HPPIR_RESERVED1_MASK) | (((uint32_t)val) << GICC_HPPIR_RESERVED1_SHIFT))

#define  GICC_HPPIR_CPUID_MASK 0x1c00
#define  GICC_HPPIR_CPUID_SHIFT 10
#define  GICC_HPPIR_CPUID_MASK_SHIFT(reg) (((reg) & GICC_HPPIR_CPUID_MASK) >> GICC_HPPIR_CPUID_SHIFT)
#define  GICC_HPPIR_CPUID_REPLACE_VAL(reg,val) (((reg) & ~GICC_HPPIR_CPUID_MASK) | (((uint32_t)val) << GICC_HPPIR_CPUID_SHIFT))

#define  GICC_HPPIR_PENDING_MASK 0x3ff
#define  GICC_HPPIR_PENDING_SHIFT 0
#define  GICC_HPPIR_PENDING_MASK_SHIFT(reg) (((reg) & GICC_HPPIR_PENDING_MASK) >> GICC_HPPIR_PENDING_SHIFT)
#define  GICC_HPPIR_PENDING_REPLACE_VAL(reg,val) (((reg) & ~GICC_HPPIR_PENDING_MASK) | (((uint32_t)val) << GICC_HPPIR_PENDING_SHIFT))

//====================================================================
//Register: GIC400 CPU Alias Binary Point Register (ABPR)
/** \brief CPU Binary Point Register*/
//====================================================================

#define  GICC_ABPR_RESERVED1_MASK 0xfffffff8
#define  GICC_ABPR_RESERVED1_SHIFT 3
#define  GICC_ABPR_RESERVED1_MASK_SHIFT(reg) (((reg) & GICC_ABPR_RESERVED1_MASK) >> GICC_ABPR_RESERVED1_SHIFT)
#define  GICC_ABPR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~GICC_ABPR_RESERVED1_MASK) | (((uint32_t)val) << GICC_ABPR_RESERVED1_SHIFT))

#define  GICC_ABPR_POINT_MASK 0x7
#define  GICC_ABPR_POINT_SHIFT 0
#define  GICC_ABPR_POINT_MASK_SHIFT(reg) (((reg) & GICC_ABPR_POINT_MASK) >> GICC_ABPR_POINT_SHIFT)
#define  GICC_ABPR_POINT_REPLACE_VAL(reg,val) (((reg) & ~GICC_ABPR_POINT_MASK) | (((uint32_t)val) << GICC_ABPR_POINT_SHIFT))

//====================================================================
//Register: GIC400 CPU Aliased Interrupt Acknowledge Register (AIAR)
/** \brief CPU Interrupt Acknowledge Register*/
//====================================================================

#define  GICC_AIAR_RESERVED1_MASK 0xffffe000
#define  GICC_AIAR_RESERVED1_SHIFT 13
#define  GICC_AIAR_RESERVED1_MASK_SHIFT(reg) (((reg) & GICC_AIAR_RESERVED1_MASK) >> GICC_AIAR_RESERVED1_SHIFT)
#define  GICC_AIAR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~GICC_AIAR_RESERVED1_MASK) | (((uint32_t)val) << GICC_AIAR_RESERVED1_SHIFT))

#define  GICC_AIAR_CPUID_MASK 0x1c00
#define  GICC_AIAR_CPUID_SHIFT 10
#define  GICC_AIAR_CPUID_MASK_SHIFT(reg) (((reg) & GICC_AIAR_CPUID_MASK) >> GICC_AIAR_CPUID_SHIFT)
#define  GICC_AIAR_CPUID_REPLACE_VAL(reg,val) (((reg) & ~GICC_AIAR_CPUID_MASK) | (((uint32_t)val) << GICC_AIAR_CPUID_SHIFT))

#define  GICC_AIAR_ID_MASK 0x3ff
#define  GICC_AIAR_ID_SHIFT 0
#define  GICC_AIAR_ID_MASK_SHIFT(reg) (((reg) & GICC_AIAR_ID_MASK) >> GICC_AIAR_ID_SHIFT)
#define  GICC_AIAR_ID_REPLACE_VAL(reg,val) (((reg) & ~GICC_AIAR_ID_MASK) | (((uint32_t)val) << GICC_AIAR_ID_SHIFT))

//====================================================================
//Register: GIC400 CPU Aliased End-Of-Interrupt Register (AEOIR)
/** \brief CPU End-Of-Interrupt Register*/
//====================================================================

#define  GICC_AEOIR_RESERVED1_MASK 0xffffe000
#define  GICC_AEOIR_RESERVED1_SHIFT 13
#define  GICC_AEOIR_RESERVED1_MASK_SHIFT(reg) (((reg) & GICC_AEOIR_RESERVED1_MASK) >> GICC_AEOIR_RESERVED1_SHIFT)
#define  GICC_AEOIR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~GICC_AEOIR_RESERVED1_MASK) | (((uint32_t)val) << GICC_AEOIR_RESERVED1_SHIFT))

#define  GICC_AEOIR_CPUID_MASK 0x1c00
#define  GICC_AEOIR_CPUID_SHIFT 10
#define  GICC_AEOIR_CPUID_MASK_SHIFT(reg) (((reg) & GICC_AEOIR_CPUID_MASK) >> GICC_AEOIR_CPUID_SHIFT)
#define  GICC_AEOIR_CPUID_REPLACE_VAL(reg,val) (((reg) & ~GICC_AEOIR_CPUID_MASK) | (((uint32_t)val) << GICC_AEOIR_CPUID_SHIFT))

#define  GICC_AEOIR_ID_MASK 0x3ff
#define  GICC_AEOIR_ID_SHIFT 0
#define  GICC_AEOIR_ID_MASK_SHIFT(reg) (((reg) & GICC_AEOIR_ID_MASK) >> GICC_AEOIR_ID_SHIFT)
#define  GICC_AEOIR_ID_REPLACE_VAL(reg,val) (((reg) & ~GICC_AEOIR_ID_MASK) | (((uint32_t)val) << GICC_AEOIR_ID_SHIFT))

//====================================================================
//Register: GIC400 CPU Aliased Highest Priority Interrupt Pending Register (AHPPIR)
/** \brief CPU Highest Priority Interrupt Pending Register*/
//====================================================================

#define  GICC_AHPPIR_RESERVED1_MASK 0xffffe000
#define  GICC_AHPPIR_RESERVED1_SHIFT 13
#define  GICC_AHPPIR_RESERVED1_MASK_SHIFT(reg) (((reg) & GICC_AHPPIR_RESERVED1_MASK) >> GICC_AHPPIR_RESERVED1_SHIFT)
#define  GICC_AHPPIR_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~GICC_AHPPIR_RESERVED1_MASK) | (((uint32_t)val) << GICC_AHPPIR_RESERVED1_SHIFT))

#define  GICC_AHPPIR_CPUID_MASK 0x1c00
#define  GICC_AHPPIR_CPUID_SHIFT 10
#define  GICC_AHPPIR_CPUID_MASK_SHIFT(reg) (((reg) & GICC_AHPPIR_CPUID_MASK) >> GICC_AHPPIR_CPUID_SHIFT)
#define  GICC_AHPPIR_CPUID_REPLACE_VAL(reg,val) (((reg) & ~GICC_AHPPIR_CPUID_MASK) | (((uint32_t)val) << GICC_AHPPIR_CPUID_SHIFT))

#define  GICC_AHPPIR_PENDING_MASK 0x3ff
#define  GICC_AHPPIR_PENDING_SHIFT 0
#define  GICC_AHPPIR_PENDING_MASK_SHIFT(reg) (((reg) & GICC_AHPPIR_PENDING_MASK) >> GICC_AHPPIR_PENDING_SHIFT)
#define  GICC_AHPPIR_PENDING_REPLACE_VAL(reg,val) (((reg) & ~GICC_AHPPIR_PENDING_MASK) | (((uint32_t)val) << GICC_AHPPIR_PENDING_SHIFT))

#endif // GIC400_CORE
