 /*
 **************************************************************************************
 *
 * (c) Copyright 2013 Marvell International Ltd.
 *
 *
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/.
 *
 **************************************************************************************
 *
 * \file GC400LT_regstructs.h
 * Generated using RegBuild 1.6.3
 *
 **************************************************************************************
 */

#ifndef _GC400LT_REGSTRUCTS_H_
#define _GC400LT_REGSTRUCTS_H_

#ifndef __KERNEL__
#include <stdint.h>
#endif

//====================================================================
//
//Register File: 2D Graphics Accelerator (GC400LT)
/** \brief Select registers for the Vivante GC400LT GPU.*/
//
//====================================================================

typedef struct GC400LT_REGS_s
{
  volatile uint32_t reserved0;
  volatile uint32_t AQHIdle;  ///< 0x4 [R]: Idle Status Register
  volatile uint32_t reserved1[2];
  volatile uint32_t AQIntrAcknowledge;  ///< 0x10 [R]: Interrupt Acknowledge
  volatile uint32_t AQIntrEnbl;  ///< 0x14 [R/W]: Interrupt Enable
  volatile uint32_t AQIdent;  ///< 0x18 [R]: Identification
  volatile uint32_t reserved2[18];
  volatile uint32_t gcGpOut0;  ///< 0x64 [R/W]: General Purpose Register 0
  volatile uint32_t gcGpOut1;  ///< 0x68 [R/W]: General Purpose Register 1
  volatile uint32_t gcGpOut2;  ///< 0x6c [R/W]: General Purpose Register 2
  volatile uint32_t reserved3[36];
  volatile uint32_t gcModulePowerControls;  ///< 0x100 [R/W]: Module Level Power Control
  volatile uint32_t reserved4[340];
  volatile uint32_t AQCmdBufferAddr;  ///< 0x654 [W]: Command Buffer Address
  volatile uint32_t AQCmdBufferCtrl;  ///< 0x658 [W]: Command Buffer Control
} GC400LT_REGS_t;

#endif // GC400LT
