 /*
 **************************************************************************************
 *
 * (c) Copyright 2013 Marvell International Ltd.
 *
 *
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/.
 *
 **************************************************************************************
 *
 * \file GC400LT_regmasks.h
 * Generated using RegBuild 1.6.3
 *
 **************************************************************************************
 */

#ifndef _GC400LT_REGMASKS_H_
#define _GC400LT_REGMASKS_H_

#ifndef __KERNEL__
#include <stdint.h>
#endif

//====================================================================
//
//Register File: 2D Graphics Accelerator (GC400LT)
/** \brief Select registers for the Vivante GC400LT GPU.*/
//
//====================================================================

//====================================================================
//Register: Idle Status Register (AQHIdle)
/** \brief Enables idle status to be read for a large number of internal modules.*/
//====================================================================

#define  GC400LT_AQHIDLE_AXI_LP_MASK 0x80000000
#define  GC400LT_AQHIDLE_AXI_LP_SHIFT 31
#define  GC400LT_AQHIDLE_AXI_LP_MASK_SHIFT(reg) (((reg) & GC400LT_AQHIDLE_AXI_LP_MASK) >> GC400LT_AQHIDLE_AXI_LP_SHIFT)
#define  GC400LT_AQHIDLE_AXI_LP_REPLACE_VAL(reg,val) (((reg) & ~GC400LT_AQHIDLE_AXI_LP_MASK) | (((uint32_t)val) << GC400LT_AQHIDLE_AXI_LP_SHIFT))

#define  GC400LT_AQHIDLE_UNUSED_MASK 0x7ffff000
#define  GC400LT_AQHIDLE_UNUSED_SHIFT 12
#define  GC400LT_AQHIDLE_UNUSED_MASK_SHIFT(reg) (((reg) & GC400LT_AQHIDLE_UNUSED_MASK) >> GC400LT_AQHIDLE_UNUSED_SHIFT)
#define  GC400LT_AQHIDLE_UNUSED_REPLACE_VAL(reg,val) (((reg) & ~GC400LT_AQHIDLE_UNUSED_MASK) | (((uint32_t)val) << GC400LT_AQHIDLE_UNUSED_SHIFT))

#define  GC400LT_AQHIDLE_IDLE_TS_MASK 0x800
#define  GC400LT_AQHIDLE_IDLE_TS_SHIFT 11
#define  GC400LT_AQHIDLE_IDLE_TS_MASK_SHIFT(reg) (((reg) & GC400LT_AQHIDLE_IDLE_TS_MASK) >> GC400LT_AQHIDLE_IDLE_TS_SHIFT)
#define  GC400LT_AQHIDLE_IDLE_TS_REPLACE_VAL(reg,val) (((reg) & ~GC400LT_AQHIDLE_IDLE_TS_MASK) | (((uint32_t)val) << GC400LT_AQHIDLE_IDLE_TS_SHIFT))

#define  GC400LT_AQHIDLE_IDLE_FP_MASK 0x400
#define  GC400LT_AQHIDLE_IDLE_FP_SHIFT 10
#define  GC400LT_AQHIDLE_IDLE_FP_MASK_SHIFT(reg) (((reg) & GC400LT_AQHIDLE_IDLE_FP_MASK) >> GC400LT_AQHIDLE_IDLE_FP_SHIFT)
#define  GC400LT_AQHIDLE_IDLE_FP_REPLACE_VAL(reg,val) (((reg) & ~GC400LT_AQHIDLE_IDLE_FP_MASK) | (((uint32_t)val) << GC400LT_AQHIDLE_IDLE_FP_SHIFT))

#define  GC400LT_AQHIDLE_IDLE_IM_MASK 0x200
#define  GC400LT_AQHIDLE_IDLE_IM_SHIFT 9
#define  GC400LT_AQHIDLE_IDLE_IM_MASK_SHIFT(reg) (((reg) & GC400LT_AQHIDLE_IDLE_IM_MASK) >> GC400LT_AQHIDLE_IDLE_IM_SHIFT)
#define  GC400LT_AQHIDLE_IDLE_IM_REPLACE_VAL(reg,val) (((reg) & ~GC400LT_AQHIDLE_IDLE_IM_MASK) | (((uint32_t)val) << GC400LT_AQHIDLE_IDLE_IM_SHIFT))

#define  GC400LT_AQHIDLE_IDLE_VG_MASK 0x100
#define  GC400LT_AQHIDLE_IDLE_VG_SHIFT 8
#define  GC400LT_AQHIDLE_IDLE_VG_MASK_SHIFT(reg) (((reg) & GC400LT_AQHIDLE_IDLE_VG_MASK) >> GC400LT_AQHIDLE_IDLE_VG_SHIFT)
#define  GC400LT_AQHIDLE_IDLE_VG_REPLACE_VAL(reg,val) (((reg) & ~GC400LT_AQHIDLE_IDLE_VG_MASK) | (((uint32_t)val) << GC400LT_AQHIDLE_IDLE_VG_SHIFT))

#define  GC400LT_AQHIDLE_IDLE_TX_MASK 0x80
#define  GC400LT_AQHIDLE_IDLE_TX_SHIFT 7
#define  GC400LT_AQHIDLE_IDLE_TX_MASK_SHIFT(reg) (((reg) & GC400LT_AQHIDLE_IDLE_TX_MASK) >> GC400LT_AQHIDLE_IDLE_TX_SHIFT)
#define  GC400LT_AQHIDLE_IDLE_TX_REPLACE_VAL(reg,val) (((reg) & ~GC400LT_AQHIDLE_IDLE_TX_MASK) | (((uint32_t)val) << GC400LT_AQHIDLE_IDLE_TX_SHIFT))

#define  GC400LT_AQHIDLE_IDLE_RA_MASK 0x40
#define  GC400LT_AQHIDLE_IDLE_RA_SHIFT 6
#define  GC400LT_AQHIDLE_IDLE_RA_MASK_SHIFT(reg) (((reg) & GC400LT_AQHIDLE_IDLE_RA_MASK) >> GC400LT_AQHIDLE_IDLE_RA_SHIFT)
#define  GC400LT_AQHIDLE_IDLE_RA_REPLACE_VAL(reg,val) (((reg) & ~GC400LT_AQHIDLE_IDLE_RA_MASK) | (((uint32_t)val) << GC400LT_AQHIDLE_IDLE_RA_SHIFT))

#define  GC400LT_AQHIDLE_IDLE_SE_MASK 0x20
#define  GC400LT_AQHIDLE_IDLE_SE_SHIFT 5
#define  GC400LT_AQHIDLE_IDLE_SE_MASK_SHIFT(reg) (((reg) & GC400LT_AQHIDLE_IDLE_SE_MASK) >> GC400LT_AQHIDLE_IDLE_SE_SHIFT)
#define  GC400LT_AQHIDLE_IDLE_SE_REPLACE_VAL(reg,val) (((reg) & ~GC400LT_AQHIDLE_IDLE_SE_MASK) | (((uint32_t)val) << GC400LT_AQHIDLE_IDLE_SE_SHIFT))

#define  GC400LT_AQHIDLE_IDLE_PA_MASK 0x10
#define  GC400LT_AQHIDLE_IDLE_PA_SHIFT 4
#define  GC400LT_AQHIDLE_IDLE_PA_MASK_SHIFT(reg) (((reg) & GC400LT_AQHIDLE_IDLE_PA_MASK) >> GC400LT_AQHIDLE_IDLE_PA_SHIFT)
#define  GC400LT_AQHIDLE_IDLE_PA_REPLACE_VAL(reg,val) (((reg) & ~GC400LT_AQHIDLE_IDLE_PA_MASK) | (((uint32_t)val) << GC400LT_AQHIDLE_IDLE_PA_SHIFT))

#define  GC400LT_AQHIDLE_IDLE_SH_MASK 0x8
#define  GC400LT_AQHIDLE_IDLE_SH_SHIFT 3
#define  GC400LT_AQHIDLE_IDLE_SH_MASK_SHIFT(reg) (((reg) & GC400LT_AQHIDLE_IDLE_SH_MASK) >> GC400LT_AQHIDLE_IDLE_SH_SHIFT)
#define  GC400LT_AQHIDLE_IDLE_SH_REPLACE_VAL(reg,val) (((reg) & ~GC400LT_AQHIDLE_IDLE_SH_MASK) | (((uint32_t)val) << GC400LT_AQHIDLE_IDLE_SH_SHIFT))

#define  GC400LT_AQHIDLE_IDLE_PE_MASK 0x4
#define  GC400LT_AQHIDLE_IDLE_PE_SHIFT 2
#define  GC400LT_AQHIDLE_IDLE_PE_MASK_SHIFT(reg) (((reg) & GC400LT_AQHIDLE_IDLE_PE_MASK) >> GC400LT_AQHIDLE_IDLE_PE_SHIFT)
#define  GC400LT_AQHIDLE_IDLE_PE_REPLACE_VAL(reg,val) (((reg) & ~GC400LT_AQHIDLE_IDLE_PE_MASK) | (((uint32_t)val) << GC400LT_AQHIDLE_IDLE_PE_SHIFT))

#define  GC400LT_AQHIDLE_IDLE_DE_MASK 0x2
#define  GC400LT_AQHIDLE_IDLE_DE_SHIFT 1
#define  GC400LT_AQHIDLE_IDLE_DE_MASK_SHIFT(reg) (((reg) & GC400LT_AQHIDLE_IDLE_DE_MASK) >> GC400LT_AQHIDLE_IDLE_DE_SHIFT)
#define  GC400LT_AQHIDLE_IDLE_DE_REPLACE_VAL(reg,val) (((reg) & ~GC400LT_AQHIDLE_IDLE_DE_MASK) | (((uint32_t)val) << GC400LT_AQHIDLE_IDLE_DE_SHIFT))

#define  GC400LT_AQHIDLE_IDLE_FE_MASK 0x1
#define  GC400LT_AQHIDLE_IDLE_FE_SHIFT 0
#define  GC400LT_AQHIDLE_IDLE_FE_MASK_SHIFT(reg) (((reg) & GC400LT_AQHIDLE_IDLE_FE_MASK) >> GC400LT_AQHIDLE_IDLE_FE_SHIFT)
#define  GC400LT_AQHIDLE_IDLE_FE_REPLACE_VAL(reg,val) (((reg) & ~GC400LT_AQHIDLE_IDLE_FE_MASK) | (((uint32_t)val) << GC400LT_AQHIDLE_IDLE_FE_SHIFT))

//====================================================================
//Register: Interrupt Acknowledge (AQIntrAcknowledge)
/** \brief Each bit represents a corresponding event being triggered. Reading from this register clears the outstanding interrupt.*/
//====================================================================

#define  GC400LT_AQINTRACKNOWLEDGE_INTR_VEC_MASK 0xffffffff
#define  GC400LT_AQINTRACKNOWLEDGE_INTR_VEC_SHIFT 0
#define  GC400LT_AQINTRACKNOWLEDGE_INTR_VEC_MASK_SHIFT(reg) (((reg) & GC400LT_AQINTRACKNOWLEDGE_INTR_VEC_MASK) >> GC400LT_AQINTRACKNOWLEDGE_INTR_VEC_SHIFT)
#define  GC400LT_AQINTRACKNOWLEDGE_INTR_VEC_REPLACE_VAL(reg,val) (((reg) & ~GC400LT_AQINTRACKNOWLEDGE_INTR_VEC_MASK) | (((uint32_t)val) << GC400LT_AQINTRACKNOWLEDGE_INTR_VEC_SHIFT))

//====================================================================
//Register: Interrupt Enable (AQIntrEnbl)
/** \brief Each bit enables a corresponding event.*/
//====================================================================

#define  GC400LT_AQINTRENBL_INTR_ENBL_VEC_MASK 0xffffffff
#define  GC400LT_AQINTRENBL_INTR_ENBL_VEC_SHIFT 0
#define  GC400LT_AQINTRENBL_INTR_ENBL_VEC_MASK_SHIFT(reg) (((reg) & GC400LT_AQINTRENBL_INTR_ENBL_VEC_MASK) >> GC400LT_AQINTRENBL_INTR_ENBL_VEC_SHIFT)
#define  GC400LT_AQINTRENBL_INTR_ENBL_VEC_REPLACE_VAL(reg,val) (((reg) & ~GC400LT_AQINTRENBL_INTR_ENBL_VEC_MASK) | (((uint32_t)val) << GC400LT_AQINTRENBL_INTR_ENBL_VEC_SHIFT))

//====================================================================
//Register: Identification (AQIdent)
/** \brief Identification register. This register has no set reset value. It varies with the implementation.*/
//====================================================================

#define  GC400LT_AQIDENT_FAM_MASK 0xff000000
#define  GC400LT_AQIDENT_FAM_SHIFT 24
#define  GC400LT_AQIDENT_FAM_MASK_SHIFT(reg) (((reg) & GC400LT_AQIDENT_FAM_MASK) >> GC400LT_AQIDENT_FAM_SHIFT)
#define  GC400LT_AQIDENT_FAM_REPLACE_VAL(reg,val) (((reg) & ~GC400LT_AQIDENT_FAM_MASK) | (((uint32_t)val) << GC400LT_AQIDENT_FAM_SHIFT))

#define  GC400LT_AQIDENT_PROD_MASK 0xff0000
#define  GC400LT_AQIDENT_PROD_SHIFT 16
#define  GC400LT_AQIDENT_PROD_MASK_SHIFT(reg) (((reg) & GC400LT_AQIDENT_PROD_MASK) >> GC400LT_AQIDENT_PROD_SHIFT)
#define  GC400LT_AQIDENT_PROD_REPLACE_VAL(reg,val) (((reg) & ~GC400LT_AQIDENT_PROD_MASK) | (((uint32_t)val) << GC400LT_AQIDENT_PROD_SHIFT))

#define  GC400LT_AQIDENT_REV_MASK 0xf000
#define  GC400LT_AQIDENT_REV_SHIFT 12
#define  GC400LT_AQIDENT_REV_MASK_SHIFT(reg) (((reg) & GC400LT_AQIDENT_REV_MASK) >> GC400LT_AQIDENT_REV_SHIFT)
#define  GC400LT_AQIDENT_REV_REPLACE_VAL(reg,val) (((reg) & ~GC400LT_AQIDENT_REV_MASK) | (((uint32_t)val) << GC400LT_AQIDENT_REV_SHIFT))

#define  GC400LT_AQIDENT_TECH_MASK 0xf00
#define  GC400LT_AQIDENT_TECH_SHIFT 8
#define  GC400LT_AQIDENT_TECH_MASK_SHIFT(reg) (((reg) & GC400LT_AQIDENT_TECH_MASK) >> GC400LT_AQIDENT_TECH_SHIFT)
#define  GC400LT_AQIDENT_TECH_REPLACE_VAL(reg,val) (((reg) & ~GC400LT_AQIDENT_TECH_MASK) | (((uint32_t)val) << GC400LT_AQIDENT_TECH_SHIFT))

#define  GC400LT_AQIDENT_CUST_MASK 0xff
#define  GC400LT_AQIDENT_CUST_SHIFT 0
#define  GC400LT_AQIDENT_CUST_MASK_SHIFT(reg) (((reg) & GC400LT_AQIDENT_CUST_MASK) >> GC400LT_AQIDENT_CUST_SHIFT)
#define  GC400LT_AQIDENT_CUST_REPLACE_VAL(reg,val) (((reg) & ~GC400LT_AQIDENT_CUST_MASK) | (((uint32_t)val) << GC400LT_AQIDENT_CUST_SHIFT))

//====================================================================
//Register: General Purpose Register 0 (gcGpOut0)
/** \brief General purpose output register. R/W but not connected to anywhere.*/
//====================================================================

#define  GC400LT_GCGPOUT0_COUNT_MASK 0xffffffff
#define  GC400LT_GCGPOUT0_COUNT_SHIFT 0
#define  GC400LT_GCGPOUT0_COUNT_MASK_SHIFT(reg) (((reg) & GC400LT_GCGPOUT0_COUNT_MASK) >> GC400LT_GCGPOUT0_COUNT_SHIFT)
#define  GC400LT_GCGPOUT0_COUNT_REPLACE_VAL(reg,val) (((reg) & ~GC400LT_GCGPOUT0_COUNT_MASK) | (((uint32_t)val) << GC400LT_GCGPOUT0_COUNT_SHIFT))

//====================================================================
//Register: General Purpose Register 1 (gcGpOut1)
/** \brief General purpose output register. R/W but not connected to anywhere.*/
//====================================================================

#define  GC400LT_GCGPOUT1_COUNT_MASK 0xffffffff
#define  GC400LT_GCGPOUT1_COUNT_SHIFT 0
#define  GC400LT_GCGPOUT1_COUNT_MASK_SHIFT(reg) (((reg) & GC400LT_GCGPOUT1_COUNT_MASK) >> GC400LT_GCGPOUT1_COUNT_SHIFT)
#define  GC400LT_GCGPOUT1_COUNT_REPLACE_VAL(reg,val) (((reg) & ~GC400LT_GCGPOUT1_COUNT_MASK) | (((uint32_t)val) << GC400LT_GCGPOUT1_COUNT_SHIFT))

//====================================================================
//Register: General Purpose Register 2 (gcGpOut2)
/** \brief General purpose output register. R/W but not connected to anywhere.*/
//====================================================================

#define  GC400LT_GCGPOUT2_COUNT_MASK 0xffffffff
#define  GC400LT_GCGPOUT2_COUNT_SHIFT 0
#define  GC400LT_GCGPOUT2_COUNT_MASK_SHIFT(reg) (((reg) & GC400LT_GCGPOUT2_COUNT_MASK) >> GC400LT_GCGPOUT2_COUNT_SHIFT)
#define  GC400LT_GCGPOUT2_COUNT_REPLACE_VAL(reg,val) (((reg) & ~GC400LT_GCGPOUT2_COUNT_MASK) | (((uint32_t)val) << GC400LT_GCGPOUT2_COUNT_SHIFT))

//====================================================================
//Register: Module Level Power Control (gcModulePowerControls)
/** \brief Identification register. This register has no set reset value. It varies with the implementation.*/
//====================================================================

#define  GC400LT_GCMODULEPOWERCONTROLS_T_OFF_COUNT_MASK 0xffff0000
#define  GC400LT_GCMODULEPOWERCONTROLS_T_OFF_COUNT_SHIFT 16
#define  GC400LT_GCMODULEPOWERCONTROLS_T_OFF_COUNT_MASK_SHIFT(reg) (((reg) & GC400LT_GCMODULEPOWERCONTROLS_T_OFF_COUNT_MASK) >> GC400LT_GCMODULEPOWERCONTROLS_T_OFF_COUNT_SHIFT)
#define  GC400LT_GCMODULEPOWERCONTROLS_T_OFF_COUNT_REPLACE_VAL(reg,val) (((reg) & ~GC400LT_GCMODULEPOWERCONTROLS_T_OFF_COUNT_MASK) | (((uint32_t)val) << GC400LT_GCMODULEPOWERCONTROLS_T_OFF_COUNT_SHIFT))

#define  GC400LT_GCMODULEPOWERCONTROLS_RESERVED1_MASK 0xff00
#define  GC400LT_GCMODULEPOWERCONTROLS_RESERVED1_SHIFT 8
#define  GC400LT_GCMODULEPOWERCONTROLS_RESERVED1_MASK_SHIFT(reg) (((reg) & GC400LT_GCMODULEPOWERCONTROLS_RESERVED1_MASK) >> GC400LT_GCMODULEPOWERCONTROLS_RESERVED1_SHIFT)
#define  GC400LT_GCMODULEPOWERCONTROLS_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~GC400LT_GCMODULEPOWERCONTROLS_RESERVED1_MASK) | (((uint32_t)val) << GC400LT_GCMODULEPOWERCONTROLS_RESERVED1_SHIFT))

#define  GC400LT_GCMODULEPOWERCONTROLS_T_ON_COUNT_MASK 0xf0
#define  GC400LT_GCMODULEPOWERCONTROLS_T_ON_COUNT_SHIFT 4
#define  GC400LT_GCMODULEPOWERCONTROLS_T_ON_COUNT_MASK_SHIFT(reg) (((reg) & GC400LT_GCMODULEPOWERCONTROLS_T_ON_COUNT_MASK) >> GC400LT_GCMODULEPOWERCONTROLS_T_ON_COUNT_SHIFT)
#define  GC400LT_GCMODULEPOWERCONTROLS_T_ON_COUNT_REPLACE_VAL(reg,val) (((reg) & ~GC400LT_GCMODULEPOWERCONTROLS_T_ON_COUNT_MASK) | (((uint32_t)val) << GC400LT_GCMODULEPOWERCONTROLS_T_ON_COUNT_SHIFT))

#define  GC400LT_GCMODULEPOWERCONTROLS_RESERVED2_MASK 0x8
#define  GC400LT_GCMODULEPOWERCONTROLS_RESERVED2_SHIFT 3
#define  GC400LT_GCMODULEPOWERCONTROLS_RESERVED2_MASK_SHIFT(reg) (((reg) & GC400LT_GCMODULEPOWERCONTROLS_RESERVED2_MASK) >> GC400LT_GCMODULEPOWERCONTROLS_RESERVED2_SHIFT)
#define  GC400LT_GCMODULEPOWERCONTROLS_RESERVED2_REPLACE_VAL(reg,val) (((reg) & ~GC400LT_GCMODULEPOWERCONTROLS_RESERVED2_MASK) | (((uint32_t)val) << GC400LT_GCMODULEPOWERCONTROLS_RESERVED2_SHIFT))

#define  GC400LT_GCMODULEPOWERCONTROLS_DSTARVE_MASK 0x4
#define  GC400LT_GCMODULEPOWERCONTROLS_DSTARVE_SHIFT 2
#define  GC400LT_GCMODULEPOWERCONTROLS_DSTARVE_MASK_SHIFT(reg) (((reg) & GC400LT_GCMODULEPOWERCONTROLS_DSTARVE_MASK) >> GC400LT_GCMODULEPOWERCONTROLS_DSTARVE_SHIFT)
#define  GC400LT_GCMODULEPOWERCONTROLS_DSTARVE_REPLACE_VAL(reg,val) (((reg) & ~GC400LT_GCMODULEPOWERCONTROLS_DSTARVE_MASK) | (((uint32_t)val) << GC400LT_GCMODULEPOWERCONTROLS_DSTARVE_SHIFT))

#define  GC400LT_GCMODULEPOWERCONTROLS_DSTALL_MASK 0x2
#define  GC400LT_GCMODULEPOWERCONTROLS_DSTALL_SHIFT 1
#define  GC400LT_GCMODULEPOWERCONTROLS_DSTALL_MASK_SHIFT(reg) (((reg) & GC400LT_GCMODULEPOWERCONTROLS_DSTALL_MASK) >> GC400LT_GCMODULEPOWERCONTROLS_DSTALL_SHIFT)
#define  GC400LT_GCMODULEPOWERCONTROLS_DSTALL_REPLACE_VAL(reg,val) (((reg) & ~GC400LT_GCMODULEPOWERCONTROLS_DSTALL_MASK) | (((uint32_t)val) << GC400LT_GCMODULEPOWERCONTROLS_DSTALL_SHIFT))

#define  GC400LT_GCMODULEPOWERCONTROLS_EN_MASK 0x1
#define  GC400LT_GCMODULEPOWERCONTROLS_EN_SHIFT 0
#define  GC400LT_GCMODULEPOWERCONTROLS_EN_MASK_SHIFT(reg) (((reg) & GC400LT_GCMODULEPOWERCONTROLS_EN_MASK) >> GC400LT_GCMODULEPOWERCONTROLS_EN_SHIFT)
#define  GC400LT_GCMODULEPOWERCONTROLS_EN_REPLACE_VAL(reg,val) (((reg) & ~GC400LT_GCMODULEPOWERCONTROLS_EN_MASK) | (((uint32_t)val) << GC400LT_GCMODULEPOWERCONTROLS_EN_SHIFT))

//====================================================================
//Register: Command Buffer Address (AQCmdBufferAddr)
/** \brief Base address for the command buffer. The address must be 64-bit aligned and it is always physical. To use addresses above 0x8000_0000, program AQMemoryFE with the appropriate offset. Also, this register cannot be read. To check the value of the current fetch address use AQFEDebugCurCmdAdr. Since this is a write-only register it has no reset value.*/
//====================================================================

#define  GC400LT_AQCMDBUFFERADDR_TYPE_MASK 0x80000000
#define  GC400LT_AQCMDBUFFERADDR_TYPE_SHIFT 31
#define  GC400LT_AQCMDBUFFERADDR_TYPE_MASK_SHIFT(reg) (((reg) & GC400LT_AQCMDBUFFERADDR_TYPE_MASK) >> GC400LT_AQCMDBUFFERADDR_TYPE_SHIFT)
#define  GC400LT_AQCMDBUFFERADDR_TYPE_REPLACE_VAL(reg,val) (((reg) & ~GC400LT_AQCMDBUFFERADDR_TYPE_MASK) | (((uint32_t)val) << GC400LT_AQCMDBUFFERADDR_TYPE_SHIFT))

#define  GC400LT_AQCMDBUFFERADDR_ADDRESS_MASK 0x7fffffff
#define  GC400LT_AQCMDBUFFERADDR_ADDRESS_SHIFT 0
#define  GC400LT_AQCMDBUFFERADDR_ADDRESS_MASK_SHIFT(reg) (((reg) & GC400LT_AQCMDBUFFERADDR_ADDRESS_MASK) >> GC400LT_AQCMDBUFFERADDR_ADDRESS_SHIFT)
#define  GC400LT_AQCMDBUFFERADDR_ADDRESS_REPLACE_VAL(reg,val) (((reg) & ~GC400LT_AQCMDBUFFERADDR_ADDRESS_MASK) | (((uint32_t)val) << GC400LT_AQCMDBUFFERADDR_ADDRESS_SHIFT))

//====================================================================
//Register: Command Buffer Control (AQCmdBufferCtrl)
/** \brief Enable parsing of command buffer.*/
//====================================================================

#define  GC400LT_AQCMDBUFFERCTRL_RESERVED1_MASK 0xfffe0000
#define  GC400LT_AQCMDBUFFERCTRL_RESERVED1_SHIFT 17
#define  GC400LT_AQCMDBUFFERCTRL_RESERVED1_MASK_SHIFT(reg) (((reg) & GC400LT_AQCMDBUFFERCTRL_RESERVED1_MASK) >> GC400LT_AQCMDBUFFERCTRL_RESERVED1_SHIFT)
#define  GC400LT_AQCMDBUFFERCTRL_RESERVED1_REPLACE_VAL(reg,val) (((reg) & ~GC400LT_AQCMDBUFFERCTRL_RESERVED1_MASK) | (((uint32_t)val) << GC400LT_AQCMDBUFFERCTRL_RESERVED1_SHIFT))

#define  GC400LT_AQCMDBUFFERCTRL_ENABLE_MASK 0x10000
#define  GC400LT_AQCMDBUFFERCTRL_ENABLE_SHIFT 16
#define  GC400LT_AQCMDBUFFERCTRL_ENABLE_MASK_SHIFT(reg) (((reg) & GC400LT_AQCMDBUFFERCTRL_ENABLE_MASK) >> GC400LT_AQCMDBUFFERCTRL_ENABLE_SHIFT)
#define  GC400LT_AQCMDBUFFERCTRL_ENABLE_REPLACE_VAL(reg,val) (((reg) & ~GC400LT_AQCMDBUFFERCTRL_ENABLE_MASK) | (((uint32_t)val) << GC400LT_AQCMDBUFFERCTRL_ENABLE_SHIFT))

#define  GC400LT_AQCMDBUFFERCTRL_PREFETCH_MASK 0xffff
#define  GC400LT_AQCMDBUFFERCTRL_PREFETCH_SHIFT 0
#define  GC400LT_AQCMDBUFFERCTRL_PREFETCH_MASK_SHIFT(reg) (((reg) & GC400LT_AQCMDBUFFERCTRL_PREFETCH_MASK) >> GC400LT_AQCMDBUFFERCTRL_PREFETCH_SHIFT)
#define  GC400LT_AQCMDBUFFERCTRL_PREFETCH_REPLACE_VAL(reg,val) (((reg) & ~GC400LT_AQCMDBUFFERCTRL_PREFETCH_MASK) | (((uint32_t)val) << GC400LT_AQCMDBUFFERCTRL_PREFETCH_SHIFT))

#endif // GC400LT
