 /*
 **************************************************************************************
 *
 * (c) Copyright 2013 Marvell International Ltd.
 *
 *
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/.
 *
 **************************************************************************************
 *
 * \file FHS_lower_regstructs.h
 * Generated using RegBuild 1.6.3
 *
 **************************************************************************************
 */

#ifndef _FHS_LOWER_REGSTRUCTS_H_
#define _FHS_LOWER_REGSTRUCTS_H_

#ifndef __KERNEL__
#include <stdint.h>
#endif

//====================================================================
//
//Register File: Fractional Horizontal Scale (FHS_lower)
/** \brief (rev 0 . 2 . 2 . 0)<p>
    Register descriptions for the Fractional Horizontal Scale (FHS) block.<p>
    FHS programming is simple, writing only a handful of registers.
    Minimally writing only the input and output image width registers followed by a write to the control register is required, namely: inImageWidth, outImageWidth and control, respectively.
    FHS will apply the correct scale factor to get the desired output.
    The write only control register is read via the read only status register.<br><br>
    Optional for decimation, the High and Low Threshold registers are used to determine if each pixel is significantly light or dark using all three color values. If a pixel is due to be decimated, both it and its neighbor pixel thresholds are checked and if any of the four are met a maximum per color merge function outputs that information into the neighboring pixel to retain as much color as possible. On reset Threshold registers are by shut off with default High values of 0xFF and default Low values of 0x00.
    When using the Threshold registers, the control register's Threshold-Max-not-Min should be programmed to match the color space CMY or RGB, 1'b1 or 1'b0, respectively.
    Also for decimation, if a threshold is not met, the control register's Merge Method dictates whether the decimation pixel color information is used, and if so how, i.e., average, minimum, or maximum.<p>
    FHS will handle three known error conditions:<br>
    1. Bad initialization of the inImageWidth with a value less than two.<br>
    2. Incorrect inImageWidth with respect to the actual data width, smaller value.<br>
    3. Incorrect inImageWidth with respect to the actual data width, larger value.<br>
    Error case 1 is evaluated on the write of the control register, and results in a forced bypass of the scale function.<br>
    Error cases 2 and 3 are determined algorithmically when expected end-of-line/image comes at the wrong time, and result in the FHS either consuming data or generating data to match the outImageWidth.
    For development, control register bit stallOnError may be set which will stall the pipe for error cases 2 and 3 stopping all data flow.
    Interrupts for the error conditions may be enabled in the int_en register, and acknowledged via int_ack register.
    Interrupt pending bits in register int_pend are set for errors regardless of whether or not interrupts are enabled.
    NOTE: The reset value is only valid on system reset or power-up, a soft reset from a higher level block will not affect the registers, as per design guidelines.*/
//
//====================================================================

typedef struct FHS_LOWER_REGS_s
{
  volatile uint32_t inImageWidth;  ///< 0x0 [R/W]: Input Image Pixel Width Register
  volatile uint32_t outImageWidth;  ///< 0x4 [R/W]: Output Image Pixel Width Register
  volatile uint32_t control;  ///< 0x8 [W]: Control Register
  volatile uint32_t status;  ///< 0xc [R]: Status Register
  volatile uint32_t int_pend;  ///< 0x10 [R]: Interrupt Pending Register
  volatile uint32_t int_ack;  ///< 0x14 [W]: Interrupt Acknowledge Register
  volatile uint32_t int_fo;  ///< 0x18 [W]: Interrupt Force Register
  volatile uint32_t int_en;  ///< 0x1c [R/W]: Interrupt Enable Register
  volatile uint32_t REV0;  ///< 0x20 [R]: IP Tagging Revision 0
  volatile uint32_t REV1;  ///< 0x24 [R]: IP Tagging Revision 1
  volatile uint32_t threshEnable;  ///< 0x28 [R/W]: Threshold Enable Register
  volatile uint32_t mergeEnable;  ///< 0x2c [R/W]: Merge Enable Register
  volatile uint32_t reserved0[20];
  volatile uint32_t threshLow0;  ///< 0x80 [R/W]: Merge Low Threshold Registers (Instance 1 of 6)
  volatile uint32_t threshLow1;  ///< 0x84 [R/W]: Merge Low Threshold Registers (Instance 2 of 6)
  volatile uint32_t threshLow2;  ///< 0x88 [R/W]: Merge Low Threshold Registers (Instance 3 of 6)
  volatile uint32_t threshLow3;  ///< 0x8c [R/W]: Merge Low Threshold Registers (Instance 4 of 6)
  volatile uint32_t threshLow4;  ///< 0x90 [R/W]: Merge Low Threshold Registers (Instance 5 of 6)
  volatile uint32_t threshLow5;  ///< 0x94 [R/W]: Merge Low Threshold Registers (Instance 6 of 6)
  volatile uint32_t reserved1[10];
  volatile uint32_t threshHigh0;  ///< 0xc0 [R/W]: Merge High Threshold Register (Instance 1 of 6)
  volatile uint32_t threshHigh1;  ///< 0xc4 [R/W]: Merge High Threshold Register (Instance 2 of 6)
  volatile uint32_t threshHigh2;  ///< 0xc8 [R/W]: Merge High Threshold Register (Instance 3 of 6)
  volatile uint32_t threshHigh3;  ///< 0xcc [R/W]: Merge High Threshold Register (Instance 4 of 6)
  volatile uint32_t threshHigh4;  ///< 0xd0 [R/W]: Merge High Threshold Register (Instance 5 of 6)
  volatile uint32_t threshHigh5;  ///< 0xd4 [R/W]: Merge High Threshold Register (Instance 6 of 6)
} FHS_LOWER_REGS_t;

#endif // FHS_LOWER
